#[doc = "🔠"]
pub const INPUT_LATIN_UPPERCASE: crate::Emoji = crate::Emoji {
    glyph: "🔠",
    codepoint: "1F520",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "input latin uppercase",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("invoer- Latynse bokas"),
            keywords: &[
                "ABCD",
                "Latyn",
                "bokas",
                "invoer",
                "invoer- Latynse bokas",
                "letters",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የላቲን ዓቢይ ፊደል ግቤት"),
            keywords: &["ላቲን", "ዓቢይ ፊደል", "የላቲን ዓቢይ ፊደል ግቤት", "ግቤት", "ፊደላት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أحرف كبيرة"),
            keywords: &["أحرف كبيرة", "حرف لاتيني كبير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেটিন বৰফল\u{9be}ৰ আখৰ দিয\u{9bc}ক"),
            keywords: &[
                "ABCD",
                "ইনপ\u{9c1}ট",
                "বৰফল\u{9be}",
                "বৰ\u{9cd}ণ",
                "লেটিন",
                "লেটিন বৰফল\u{9be}ৰ আখৰ দিয\u{9bc}ক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böyük hərflərlə latın daxiletməsi"),
            keywords: &[
                "böyük hərf",
                "böyük hərflərlə latın daxiletməsi",
                "daxiletmə",
                "hərflər",
                "latın",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("увод лацінскіх літар верхнім рэгістрам"),
            keywords: &[
                "верхні рэгістр",
                "вялікі",
                "лацінскі",
                "літары",
                "увод",
                "увод лацінскіх літар верхнім рэгістрам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("въвеждане на главни букви на латиница"),
            keywords: &[
                "букви",
                "въвеждане",
                "въвеждане на главни букви на латиница",
                "главни",
                "латиница",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইনপ\u{9c1}ট ল\u{9be}তিন বড\u{9bc} হ\u{9be}তের অক\u{9cd}ষর"),
            keywords: &[
                "অক\u{9cd}ষর",
                "ইনপ\u{9c1}ট",
                "ইনপ\u{9c1}ট ল\u{9be}তিন বড\u{9bc} হ\u{9be}তের অক\u{9cd}ষর",
                "বড\u{9bc} হ\u{9be}তের অক\u{9cd}ষর",
                "ল\u{9be}তিন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bizskriv pennlizherennoù latin"),
            keywords: &[
                "ABCD",
                "bizskriv",
                "latin",
                "lizherennoù",
                "pennlizherennoù",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("unos latinica veliko slovo"),
            keywords: &[
                "latinica",
                "slova",
                "unos",
                "unos latinica veliko slovo",
                "velika",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de lletres llatines en majúscules"),
            keywords: &[
                "botó de lletres llatines en majúscules",
                "llatines",
                "lletres",
                "majúscules",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏅᏗᏍᏗ ᎳᏔᏂ ᎦᎸᎳᏗᏗᎪᏪᎵ"),
            keywords: &["ABCD", "ᎦᎸᎳᏗᏗᎪᏪᎵ", "ᎳᏔᏂ", "ᏗᎦᏘᏅᏗᏍᏗ", "ᏗᎪᏪᎳᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zadávání v latince, velká písmena"),
            keywords: &[
                "ABCD",
                "abeceda",
                "klávesnice",
                "latinka",
                "psaní",
                "písmena",
                "velká písmena",
                "vstup",
                "zadávání",
                "zadávání v latince, velká písmena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mewnbwn llythrennau mawr ladin"),
            keywords: &[
                "lladin",
                "llythrennau",
                "llythrennau mawr",
                "mewnbwn",
                "mewnbwn llythrennau mawr ladin",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("store bogstaver"),
            keywords: &["ABCD", "store bogstaver", "symbol for store bogstaver"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eingabesymbol lateinische Großbuchstaben"),
            keywords: &[
                "Eingabesymbol lateinische Großbuchstaben",
                "Großbuchstaben",
                "lateinische Großbuchstaben",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Eingabesymbol lateinische Grossbuchstaben"),
            keywords: &[
                "Eingabesymbol lateinische Grossbuchstaben",
                "Grossbuchstaben",
                "lateinische Grossbuchstaben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κεφαλαία λατινικά"),
            keywords: &["γράμματα", "εισαγωγή", "κεφαλαία", "λατινικά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("input latin uppercase"),
            keywords: &["ABCD", "input", "latin", "letters", "uppercase"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("input Latin uppercase"),
            keywords: &["input Latin uppercase"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("input Latin uppercase"),
            keywords: &["ABCD", "Latin", "input", "letters", "uppercase"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("letras latinas mayúsculas"),
            keywords: &["abcd", "letras", "letras latinas mayúsculas", "mayúsculas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ladina suurtähed"),
            keywords: &["abcd", "ladina", "suurtähed", "tähed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("alfabeto latindarra maiuskulaz"),
            keywords: &[
                "ABCD",
                "alfabeto latindarra maiuskulaz",
                "latindarra",
                "letrak",
                "maiuskula",
                "sarrera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ورودی حروف بزرگ"),
            keywords: &["بزرگ", "حروف", "لاتین", "ورودی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syötä isoja kirjaimia"),
            keywords: &[
                "ABCD",
                "aakkoset",
                "isot",
                "kirjaimet",
                "latinalaiset",
                "syötä",
                "syötä isoja kirjaimia",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("input na latin na uppercase"),
            keywords: &[
                "ABCD",
                "ilagay",
                "input na latin na uppercase",
                "latin",
                "malalaki",
                "titik",
                "uppercase",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stórir bókstavir"),
            keywords: &["ABCD", "stórir bókstavir"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("majuscules"),
            keywords: &["lettres", "lettres latines", "majuscules", "saisie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["ABCD", "latin", "lettres", "majuscules", "saisie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceannlitreacha Laidineacha ionchuir"),
            keywords: &[
                "ceannlitreacha Laidineacha",
                "ceannlitreacha Laidineacha ionchuir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ion-chur litrichean mòra Laideann"),
            keywords: &[
                "ABCD",
                "ion-chur",
                "ion-chur litrichean mòra Laideann",
                "laideann",
                "litir",
                "litrichean",
                "litrichean mòra",
                "mòr",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("letras en maiúscula"),
            keywords: &[
                "ABCD",
                "escribir",
                "letras",
                "letras en maiúscula",
                "maiúsculas",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અપરક\u{ac7}સ લ\u{ac7}ટિન ઇનપ\u{ac1}ટ કરો"),
            keywords: &[
                "અપરક\u{ac7}સ",
                "અપરક\u{ac7}સ અક\u{acd}ષરો",
                "અપરક\u{ac7}સ લ\u{ac7}ટિન ઇનપ\u{ac1}ટ કરો",
                "લ\u{ac7}ટિન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar shigarwar manyan baƙaƙe na latin"),
            keywords: &[
                "ABCD",
                "alamar shigarwar manyan baƙaƙe na latin",
                "baƙaƙe",
                "latin",
                "manyan baƙaƙe",
                "shigarwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן אותיות גדולות"),
            keywords: &[
                "אותיות",
                "גדולות",
                "לחצן אותיות גדולות",
                "לטינית",
                "קלט",
                "רישיות",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("इनप\u{941}ट ल\u{948}टिन अपरक\u{947}स"),
            keywords: &[
                "अपरक\u{947}स",
                "इनप\u{941}ट ल\u{948}टिन अपरक\u{947}स",
                "बड\u{93c}\u{947} अक\u{94d}षर",
                "ल\u{948}टिन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("unos velikih latiničnih slova"),
            keywords: &[
                "latinica",
                "slova",
                "unos",
                "unos velikih latiničnih slova",
                "velika",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("latin nagybetűs bevitel"),
            keywords: &["abcd", "betűk", "bevitel", "latin", "nagybetűs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լատինատառ մեծատառ ներածում"),
            keywords: &[
                "լատինական",
                "լատինատառ մեծատառ ներածում",
                "մեծատառ",
                "մուտքագրել",
                "տառեր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("masukan huruf kapital latin"),
            keywords: &[
                "ABCD",
                "huruf",
                "huruf kapital",
                "latin",
                "masukan",
                "masukan huruf kapital latin",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tinye mkpụrụedemede latin"),
            keywords: &[
                "ABCD",
                "latin",
                "mkpụrụedemede gasị",
                "mkpụrụedemede ukwu",
                "ntinye",
                "tinye mkpụrụedemede latin",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hástafir"),
            keywords: &[
                "hástafir",
                "latneskir hástafir",
                "latneskt letur",
                "setja inn latneska hástafi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante con lettere latine maiuscole"),
            keywords: &[
                "caratteri latini",
                "inserire",
                "lettere",
                "maiuscole",
                "pulsante con lettere latine maiuscole",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("英大文字の入力"),
            keywords: &[
                "ABCD",
                "アルファベット",
                "ローマ字",
                "大文字",
                "英大文字の入力",
                "英字",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lebokake aksara latin gedhe"),
            keywords: &["ABCD", "aksara", "gedhe", "latin", "lebokake"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთავრული ლათინური ასოების შეყვანა"),
            keywords: &[
                "ასოები",
                "ლათინური",
                "მთავრული",
                "მთავრული ლათინური ასოების შეყვანა",
                "შეყვანა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкен латын әріптерін енгізу"),
            keywords: &[
                "бас әріп",
                "енгізу",
                "латын",
                "үлкен латын әріптерін енгізу",
                "әріптер",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("store bogstaver"),
            keywords: &["store bogstaver", "symbol for store bogstaver"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លអក\u{17d2}សរធ\u{17c6}"),
            keywords: &[
                "ABCD",
                "បញ\u{17d2}ច\u{17bc}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លអក\u{17d2}សរធ\u{17c6}",
                "ឡាតា\u{17c6}ង",
                "អក\u{17d2}សរ",
                "អក\u{17d2}សរធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಅಪ\u{ccd}ಪರ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
            ),
            keywords: &[
                "ಅಪ\u{ccd}ಪರ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd}",
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಅಪ\u{ccd}ಪರ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
                "ಎಬ\u{cbf}ಸ\u{cbf}ಡ\u{cbf}",
                "ಪತ\u{ccd}ರಗಳು",
                "ಲ\u{ccd}ಯಾಟೀನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("대문자"),
            keywords: &["대문자", "대문자 입력", "영어 대문자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("इनप\u{942}ट ल\u{945}टीन अपरक\u{947}स"),
            keywords: &[
                "ABCD",
                "अक\u{94d}षरा\u{902}",
                "इनप\u{942}ट",
                "इनप\u{942}ट ल\u{945}टीन अपरक\u{947}स",
                "लाती\u{902}",
                "व\u{94d}हड अक\u{94d}षरा\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("латынча баш тамга менен киргизүү"),
            keywords: &[
                "киргизүү",
                "латынча",
                "латынча баш тамга менен киргизүү",
                "тамгалар",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Groussbuschtawen (Latäin)"),
            keywords: &[
                "ABCD",
                "Buschtawen",
                "Eingab",
                "Groussbuschtawen (Latäin)",
                "grouss",
                "latäin",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນອ\u{eb1}ກສອນຕ\u{ebb}ວໃຫຍ\u{ec8}"),
            keywords: &[
                "ຕ\u{ebb}ວໃຫຍ\u{ec8}",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນອ\u{eb1}ກສອນຕ\u{ebb}ວໃຫຍ\u{ec8}",
                "ອ\u{eb1}ກສອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įvestis didžiosios lotyniškos raidės"),
            keywords: &["ABCD", "didžiosios", "lotyniškos", "raidės", "įvestis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lielie latīņu burti"),
            keywords: &["burti", "ievade", "latīņu", "lielie"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāuru pūmatua ratini"),
            keywords: &["ABCD", "ngā pū", "pūmatua", "ratini", "tāuru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("латински големи букви"),
            keywords: &["букви", "големи", "латински"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലിയക\u{d4d}ഷരങ\u{d4d}ങൾ"),
            keywords: &["ക\u{d4d}യ\u{d3e}പിറ\u{d4d}റൽ", "വലിയക\u{d4d}ഷരങ\u{d4d}ങൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("латин том үсгийн оролт"),
            keywords: &[
                "ABCD",
                "латин",
                "латин том үсгийн оролт",
                "оролт",
                "том үсэг",
                "үсэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इनप\u{941}ट ल\u{945}टिन अपरक\u{947}स"),
            keywords: &[
                "ABCD",
                "अक\u{94d}षर\u{947}",
                "अप\u{94d}परक\u{947}स",
                "इनप\u{941}ट",
                "इनप\u{941}ट ल\u{945}टिन अपरक\u{947}स",
                "ल\u{945}टिन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("huruf besar latin input"),
            keywords: &[
                "huruf",
                "huruf besar",
                "huruf besar latin input",
                "input",
                "latin",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("input latin kapitali"),
            keywords: &["ABCD", "input", "ittri", "kapitali", "latin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းကြ\u{102e}း ထည\u{1037}\u{103a}ရန\u{103a}",
            ),
            keywords: &[
                "စာလ\u{102f}\u{1036}းကြ\u{102e}း",
                "ထည\u{1037}\u{103a}ရန\u{103a}",
                "လက\u{103a}တင\u{103a}",
                "လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းကြ\u{102e}း သင\u{103a}\u{1039}ကေတ",
                "အက\u{1039}ခရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("store bokstaver"),
            keywords: &["ABCD", "bokstaver", "inndata", "store bokstaver"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{94d}याटिन ठ\u{942}लो अक\u{94d}षर राख\u{94d}न"),
            keywords: &[
                "अक\u{94d}षरहर\u{942}",
                "ठ\u{942}लो अक\u{94d}षर",
                "राख\u{94d}न",
                "ल\u{94d}याटिन",
                "ल\u{94d}याटिन ठ\u{942}लो अक\u{94d}षर राख\u{94d}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hoofdletters"),
            keywords: &["ABCD", "Latijns", "hoofdletters", "invoeren", "letters"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("store bokstavar"),
            keywords: &["ABCD", "bokstavar", "inndata", "store bokstavar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} ବଡ\u{b3c} ଅକ\u{b4d}ଷର",
            ),
            keywords: &[
                "ABCD",
                "ଅକ\u{b4d}ଷରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c}",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} ବଡ\u{b3c} ଅକ\u{b4d}ଷର",
                "ବଡ\u{b3c} ଅକ\u{b4d}ଷର",
                "ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡ\u{a47} ਲ\u{a47}ਟਿਨ ਇਨਪ\u{a41}\u{a71}ਟ"),
            keywords: &[
                "ਲ\u{a47}ਟਿਨ",
                "ਵ\u{a71}ਡ\u{a47}",
                "ਵ\u{a71}ਡ\u{a47} ਅ\u{a71}ਖਰ",
                "ਵ\u{a71}ਡ\u{a47} ਲ\u{a47}ਟਿਨ ਇਨਪ\u{a41}\u{a71}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وڈے رومی حرف ان پٹ کرو"),
            keywords: &[
                "ABCD",
                "ان پٹ",
                "خطوط",
                "لاطینی",
                "وڈھے حروف",
                "وڈے رومی حرف ان پٹ کرو",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pút Látin Bíg Lẹ\u{301}ta-dẹm"),
            keywords: &[
                "AB(Ch)D",
                "AB(Ch)D-dẹm",
                "ABCD",
                "Bíg AB(Ch)D",
                "Látin",
                "Put",
                "Pút Látin Bíg Lẹ\u{301}ta-dẹm",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wielkie litery (alfabet łaciński)"),
            keywords: &[
                "abcd",
                "duże litery",
                "kapitaliki",
                "pisać",
                "wielkie litery (alfabet łaciński)",
                "wielkimi literami",
                "wprowadzać",
                "łacińskie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاملتوب لاتینې لوړ الفبا"),
            keywords: &[
                "ای بي سي ډې",
                "توري",
                "شاملتوب",
                "شاملتوب لاتینې لوړ الفبا",
                "لاتيني",
                "لوړ الفبا",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("letras latinas maiúsculas"),
            keywords: &["ABCD", "digitação", "latinas", "letras", "maiúsculas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("introdução de maiúsculas latinas"),
            keywords: &[
                "introdução",
                "introdução de maiúsculas latinas",
                "latinas",
                "letras",
                "maiúsculas",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("introducere majuscule latine"),
            keywords: &["ABCD", "introducere", "latine", "litere", "majuscule"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-732"),
            keywords: &["E10-732"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ввод прописными"),
            keywords: &[
                "ввод прописными",
                "верхний регистр",
                "латиница",
                "прописные",
                "прописные символы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyuguti nkuru z’ikilatini"),
            keywords: &[
                "ABCD",
                "ikilatini",
                "inyuguti",
                "inyuguti nkuru z’ikilatini",
                "kwinjiza",
                "nkuru",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انپٽ لاطيني وڏو ڪيس"),
            keywords: &[
                "ABCD",
                "انپٽ",
                "انپٽ لاطيني وڏو ڪيس",
                "اپرڪيس",
                "اکر",
                "لاطيني",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලත\u{dd2}න\u{dca} කැප\u{dd2}ටල\u{dca} අක\u{dd4}ර\u{dd4} අද\u{dcf}නය"),
            keywords: &[
                "අක\u{dd4}ර\u{dd4}",
                "ආද\u{dcf}නය",
                "කැප\u{dd2}ටල\u{dca} අක\u{dd4}ර\u{dd4}",
                "ලත\u{dd2}න\u{dca}",
                "ලත\u{dd2}න\u{dca} කැප\u{dd2}ටල\u{dca} අක\u{dd4}ර\u{dd4} අද\u{dcf}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zadávanie veľkých písmen latinky"),
            keywords: &[
                "latinka",
                "písmená",
                "veľké písmená",
                "zadať",
                "zadávanie veľkých písmen latinky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vnos velikih črk latinice"),
            keywords: &[
                "latinica",
                "velike črke",
                "vnos",
                "vnos velikih črk latinice",
                "črke",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geli xarfa weyn oo latin ah"),
            keywords: &[
                "ABCD",
                "geli",
                "geli xarfa weyn oo latin ah",
                "latin",
                "weyn",
                "xuruuf",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fut shkronja latine kapitale"),
            keywords: &[
                "ABCD",
                "fut",
                "fut shkronja latine kapitale",
                "kapitale",
                "latin",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("унос великих слова"),
            keywords: &[
                "ABCD",
                "велика",
                "латиница",
                "слова",
                "унос",
                "унос великих слова",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["унос великих слова"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("unos velikih slova"),
            keywords: &[
                "ABCD",
                "latinica",
                "slova",
                "unos",
                "unos velikih slova",
                "velika",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["unos velikih slova"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("versaler"),
            keywords: &["ABC", "alfabet", "stora bokstäver", "versaler"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("weka herufi kubwa za kilatini"),
            keywords: &[
                "ABCD",
                "herufi",
                "herufi kubwa",
                "latini",
                "weka",
                "weka herufi kubwa za kilatini",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லத\u{bcd}த\u{bc0}ன\u{bcd} பேரேழுத\u{bcd}து"),
            keywords: &[
                "ஆங\u{bcd}கிலம\u{bcd}",
                "எழுத\u{bcd}துகள\u{bcd}",
                "கேபிடல\u{bcd} எழுத\u{bcd}துகள\u{bcd}",
                "பேரெழுத\u{bcd}து",
                "லத\u{bcd}த\u{bc0}ன\u{bcd} பேரேழுத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c46}ద\u{c4d}ద అక\u{c4d}షర\u{c3e}లు"),
            keywords: &[
                "అక\u{c4d}షరం",
                "ప\u{c46}ద\u{c4d}ద",
                "ప\u{c46}ద\u{c4d}ద అక\u{c4d}షర\u{c3e}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳарфҳои калони вуруди лотинӣ"),
            keywords: &[
                "ABCD",
                "вуруд",
                "лотинӣ",
                "ҳарфҳо",
                "ҳарфҳои калон",
                "ҳарфҳои калони вуруди лотинӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e31}กษรต\u{e31}วพ\u{e34}มพ\u{e4c}ใหญ\u{e48}"),
            keywords: &[
                "ภาษาอ\u{e31}งกฤษ",
                "อ\u{e31}กษรต\u{e31}วพ\u{e34}มพ\u{e4c}ใหญ\u{e48}",
                "อ\u{e31}กษรต\u{e31}วใหญ\u{e48}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ላቲን ዓበይቲ-ቃላት ኣእቱ"),
            keywords: &[
                "ABCD",
                "ላቲን",
                "ቃላት",
                "ናይ ላቲን ዓበይቲ-ቃላት ኣእቱ",
                "ኣእቱ",
                "ዓበይቲ-ቃላት",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("latyn baş harp girizme"),
            keywords: &[
                "ABÇD",
                "baş harp",
                "giriziş",
                "harplar",
                "latyn",
                "latyn baş harp girizme",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hū mataʻitohi lahi pē"),
            keywords: &["AEF", "hū mataʻitohi lahi pē", "lahi", "mataʻitohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyük harfler"),
            keywords: &[
                "Latin",
                "Latin büyük harfleri",
                "Latin büyük harfleriyle giriş",
                "büyük harf",
                "büyük harfler",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لاتىنچە چوڭ ھەرپ"),
            keywords: &[
                "ABCD",
                "كىرگۈزۈش",
                "لاتىن",
                "لاتىنچە چوڭ ھەرپ",
                "چوڭ",
                "ھەرپ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("введення великими латинськими літерами"),
            keywords: &[
                "введення",
                "введення великими латинськими літерами",
                "великі",
                "латинські",
                "літери",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ان پٹ لاطینی بڑے حروف"),
            keywords: &[
                "ABCD",
                "ان پٹ",
                "ان پٹ لاطینی بڑے حروف",
                "بڑے حروف",
                "حروف",
                "لاطینی",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("katta lotin harflarini kiritish"),
            keywords: &[
                "bosh",
                "harflar",
                "katta lotin harflarini kiritish",
                "kiritish",
                "lotin",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhập chữ hoa la tinh"),
            keywords: &[
                "ABCD",
                "chữ",
                "chữ hoa",
                "la tinh",
                "nhập",
                "nhập chữ hoa la tinh",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbind lateŋ, majiskil"),
            keywords: &[
                "ABCD",
                "bataaxal",
                "lateŋ",
                "majiskil",
                "mbind",
                "mbind lateŋ, majiskil",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("fakela oonobumba abakhulu baselatin"),
            keywords: &[
                "U-ABCD",
                "fakela oonobumba abakhulu baselatin",
                "i-latin",
                "oonobumba",
                "oonobumba abaphezulu",
                "ungeniso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ṣafikun latini ọ\u{300}rọ\u{300} gbólóhùn ńlá"),
            keywords: &[
                "ABCD",
                "látíìnì",
                "lé\u{329}tà nlá",
                "lẹ\u{301}tà",
                "àgbéwọlé",
                "ṣafikun latini ọ\u{300}rọ\u{300} gbólóhùn ńlá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輸入拉丁大階字母"),
            keywords: &["ABCD", "大階", "字母", "拉丁", "輸入", "輸入拉丁大階字母"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("输入拉丁大阶字母"),
            keywords: &["ABCD", "大阶", "字母", "拉丁", "输入", "输入拉丁大阶字母"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("输入大写拉丁字母"),
            keywords: &["ABCD", "打字", "拉丁文", "输入大写拉丁字母", "输入法"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大寫字母鍵"),
            keywords: &["大寫", "大寫字母鍵", "字母", "輸入"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("大階英文輸入"),
            keywords: &["大階", "大階英文", "大階英文輸入"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukufaka uhlamvu olukhulu lwesilatini"),
            keywords: &[
                "isilatini",
                "izinhlamvu",
                "okufakiwe",
                "uhlamvu olukhulu",
                "ukufaka uhlamvu olukhulu lwesilatini",
            ],
        },
    ],
};
#[doc = "🔡"]
pub const INPUT_LATIN_LOWERCASE: crate::Emoji = crate::Emoji {
    glyph: "🔡",
    codepoint: "1F521",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "input latin lowercase",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("invoer- Latynse onderkas"),
            keywords: &[
                "ABCD",
                "Latyn",
                "invoer",
                "invoer- Latynse onderkas",
                "letters",
                "onderkas",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የላቲን ንዑስ ፊደል ግቤት"),
            keywords: &["ላቲን", "ንዑስ ፊደላት", "የላቲን ንዑስ ፊደል ግቤት", "ግቤት", "ፊደላት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أحرف صغيرة"),
            keywords: &["أحرف صغيرة", "حرف لاتيني صغير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেটিন সৰ\u{9c1}ফল\u{9be}ৰ আখৰ দিয\u{9bc}ক"),
            keywords: &[
                "abcd",
                "দিয\u{9bc}ক",
                "বৰ\u{9cd}ণ",
                "লেটিন",
                "লেটিন সৰ\u{9c1}ফল\u{9be}ৰ আখৰ দিয\u{9bc}ক",
                "সৰ\u{9c1}ফল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kiçik hərflərlə latın daxiletməsi"),
            keywords: &[
                "abcd",
                "daxiletmə",
                "hərflər",
                "kiçik hərf",
                "kiçik hərflərlə latın daxiletməsi",
                "latın",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("увод лацінскіх літар ніжнім рэгістрам"),
            keywords: &[
                "лацінскі",
                "літары",
                "малы",
                "ніжні рэгістр",
                "увод",
                "увод лацінскіх літар ніжнім рэгістрам",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("въвеждане на малки букви на латиница"),
            keywords: &[
                "[abcd]",
                "букви",
                "въвеждане",
                "въвеждане на малки букви на латиница",
                "латиница",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইনপ\u{9c1}ট ল\u{9be}তিন ছোট হ\u{9be}তের অক\u{9cd}ষর"),
            keywords: &[
                "অক\u{9cd}ষর",
                "ইনপ\u{9c1}ট",
                "ইনপ\u{9c1}ট ল\u{9be}তিন ছোট হ\u{9be}তের অক\u{9cd}ষর",
                "এ বি সি ডি",
                "ছোট হ\u{9be}তের অক\u{9cd}ষর",
                "ল\u{9be}তিন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bizskriv lizherennoù bihan latin"),
            keywords: &[
                "abcd",
                "bizskriv",
                "bizskriv lizherennoù bihan latin",
                "latin",
                "lizherennoù",
                "lizherennoù bihan",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("unos latinica malo slovo"),
            keywords: &[
                "latinica",
                "mala",
                "slova",
                "unos",
                "unos latinica malo slovo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de lletres llatines en minúscules"),
            keywords: &[
                "botó de lletres llatines en minúscules",
                "llatines",
                "lletres",
                "minúscules",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏅᏗᏍᏗ ᎴᏔᏂ ᎡᎳᏗᏗᎪᏪᎵ"),
            keywords: &[
                "abcd",
                "ᎡᎳᏗᏗᎪᏪᎵ",
                "ᎳᏔᏂ",
                "ᏗᎦᏘᏅᏗᏍᏗ",
                "ᏗᎦᏘᏅᏗᏍᏗ ᎴᏔᏂ ᎡᎳᏗᏗᎪᏪᎵ",
                "ᏗᎪᏪᎳᏅᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zadávání v latince, malá písmena"),
            keywords: &[
                "abcd",
                "abeceda",
                "klávesnice",
                "latinka",
                "malá písmena",
                "psaní",
                "písmena",
                "vstup",
                "zadávání",
                "zadávání v latince, malá písmena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mewnbwn llythrennau bach lladin"),
            keywords: &[
                "abcch",
                "lladin",
                "llythrennau bach",
                "mewnbwn",
                "mewnbwn llythrennau bach lladin",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("små bogstaver"),
            keywords: &["abcd", "små bogstaver", "symbol for små bogstaver"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eingabesymbol lateinische Kleinbuchstaben"),
            keywords: &[
                "Eingabesymbol lateinische Kleinbuchstaben",
                "Kleinbuchstaben",
                "lateinische Kleinbuchstaben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πεζά λατινικά"),
            keywords: &["abcd", "γράμματα", "εισαγωγή", "λατινικά", "πεζά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("input latin lowercase"),
            keywords: &["abcd", "input", "latin", "letters", "lowercase"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("input Latin lowercase"),
            keywords: &["input Latin lowercase"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("input Latin lowercase"),
            keywords: &["Latin", "abcd", "input", "letters", "lowercase"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("letras latinas minúsculas"),
            keywords: &["abcd", "letras", "letras latinas minúsculas", "minúsculas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ladina väiketähed"),
            keywords: &["abcd", "ladina", "tähed", "väiketähed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("alfabeto latindarra minuskulaz"),
            keywords: &[
                "abcd",
                "alfabeto",
                "alfabeto latindarra minuskulaz",
                "hizki",
                "latindar",
                "letra",
                "minuskula",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ورودی حروف کوچک"),
            keywords: &["الفبا", "حروف", "لاتین", "ورودی", "کوچک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syötä pieniä kirjaimia"),
            keywords: &[
                "aakkoset",
                "abcd",
                "kirjaimet",
                "latinalaiset",
                "pienet",
                "syötä",
                "syötä pieniä kirjaimia",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("input na latin na lowercase"),
            keywords: &[
                "abcd",
                "ilagay",
                "input na latin na lowercase",
                "latin",
                "lowercase",
                "maliliit",
                "titik",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smáir bókstavir"),
            keywords: &["abcd", "smáir bókstavir"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("minuscules"),
            keywords: &["lettres", "lettres latines", "minuscules", "saisie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["abcd", "latin", "lettres", "minuscules", "saisie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mionlitreacha Laidineacha ionchuir"),
            keywords: &[
                "mionlitreacha Laidineacha",
                "mionlitreacha Laidineacha ionchuir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ion-chur litrichean beaga Laideann"),
            keywords: &[
                "ABCD",
                "beag",
                "ion-chur",
                "ion-chur litrichean beaga Laideann",
                "laideann",
                "litir",
                "litrichean",
                "litrichean beaga",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("letras en minúscula"),
            keywords: &[
                "abcd",
                "escribir",
                "letras",
                "letras en minúscula",
                "minúsculas",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોઅરક\u{ac7}સ લ\u{ac7}ટિન ઇનપ\u{ac1}ટ કરો"),
            keywords: &[
                "લ\u{ac7}ટિન",
                "લોઅરક\u{ac7}સ",
                "લોઅરક\u{ac7}સ અક\u{acd}ષરો",
                "લોઅરક\u{ac7}સ લ\u{ac7}ટિન ઇનપ\u{ac1}ટ કરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar shigarwa ƙananan baƙaƙe na latin"),
            keywords: &[
                "abcd",
                "alamar shigarwa ƙananan baƙaƙe na latin",
                "baƙaƙe",
                "latin",
                "shigarwa",
                "ƙananan baƙaƙe",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן אותיות קטנות"),
            keywords: &[
                "אותיות",
                "הזנה",
                "לחצן אותיות קטנות",
                "לטינית",
                "קטנות",
                "קלט",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("इनप\u{941}ट ल\u{948}टिन लोअरक\u{947}स अक\u{94d}षर"),
            keywords: &["अक\u{94d}षर", "इनप\u{941}ट", "ल\u{948}टिन", "लोअरक\u{947}स"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("unos malih latiničnih slova"),
            keywords: &[
                "abcd",
                "latinica",
                "mala",
                "unos",
                "unos malih latiničnih slova",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("latin kisbetűs bevitel"),
            keywords: &["abcd", "betűk", "bevitel", "kisbetűs", "latin"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լատինատառ փոքրատառ ներածում"),
            keywords: &[
                "abcd",
                "լատինական",
                "լատինատառ փոքրատառ ներածում",
                "մուտքագրել",
                "տառեր",
                "փոքրատառ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("masukan huruf kecil latin"),
            keywords: &[
                "abcd",
                "huruf",
                "huruf kecil",
                "latin",
                "masukan",
                "masukan huruf kecil latin",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tinye obere mkpụrụedemede latin"),
            keywords: &["abcd", "latin", "mkpụrụedemede", "obere", "tinye"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lágstafir"),
            keywords: &[
                "latneskir lágstafir",
                "latneskt letur",
                "lágstafir",
                "setja inn latneska lágstafi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante con lettere latine minuscole"),
            keywords: &[
                "caratteri latini",
                "inserire",
                "lettere",
                "minuscole",
                "pulsante con lettere latine minuscole",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("英小文字の入力"),
            keywords: &[
                "abcd",
                "アルファベット",
                "ローマ字",
                "小文字",
                "英字",
                "英小文字の入力",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lebokake aksara latin cilik"),
            keywords: &["abcd", "aksara", "cilik", "latin", "lebokake"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნუსხური ლათინური ასოების შეყვანა"),
            keywords: &[
                "abcd",
                "ასოები",
                "ლათინური",
                "ნუსხური",
                "ნუსხური ლათინური ასოების შეყვანა",
                "შეყვანა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кіші латын әріптерін енгізу"),
            keywords: &[
                "abcd",
                "енгізу",
                "кіші латын әріптерін енгізу",
                "кіші әріптер",
                "латын",
                "әріптер",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("små bogstaver"),
            keywords: &["små bogstaver", "symbol for små bogstaver"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លអក\u{17d2}សរត\u{17bc}ច"),
            keywords: &[
                "abcd",
                "បញ\u{17d2}ច\u{17bc}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លអក\u{17d2}សរត\u{17bc}ច",
                "ឡាតា\u{17c6}ង",
                "អក\u{17d2}សរ",
                "អក\u{17d2}សរត\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಇನ\u{ccd}\u{200c}\u{200c}ಪುಟ\u{ccd} ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಲೋಯರ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
            ),
            keywords: &[
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd}",
                "ಇನ\u{ccd}\u{200c}\u{200c}ಪುಟ\u{ccd} ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಲೋಯರ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
                "ಎಬ\u{cbf}ಸ\u{cbf}ಡ\u{cbf}",
                "ಪತ\u{ccd}ರಗಳು",
                "ಲೋಯರ\u{ccd}\u{200c}ಕೇಸ\u{ccd}",
                "ಲ\u{ccd}ಯಾಟೀನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("소문자"),
            keywords: &["소문자", "소문자 입력", "영어 소문자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("इनप\u{942}ट ल\u{945}टीन लोवरक\u{947}स"),
            keywords: &[
                "abcd",
                "अक\u{94d}षरा\u{902}",
                "इनप\u{942}ट",
                "इनप\u{942}ट ल\u{945}टीन लोवरक\u{947}स",
                "लाती\u{902}",
                "ल\u{94d}हान अक\u{94d}षरा\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("латынча кичине тамга менен киргизүү"),
            keywords: &[
                "киргизүү",
                "кичине",
                "латынча",
                "латынча кичине тамга менен киргизүү",
                "тамгалар",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Klengbuschtawen (Latäin)"),
            keywords: &[
                "Buschtawen",
                "Eingab",
                "Klengbuschtawen (Latäin)",
                "abcd",
                "kleng",
                "latäin",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນອ\u{eb1}ກສອນຕ\u{ebb}ວນ\u{ec9}ອຍ"),
            keywords: &[
                "ຕ\u{ebb}ວນ\u{ec9}ອຍ",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນອ\u{eb1}ກສອນຕ\u{ebb}ວນ\u{ec9}ອຍ",
                "ອ\u{eb1}ກສອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įvestis mažosios lotyniškos raidės"),
            keywords: &["abcd", "lotyniškos", "mažosios", "raidės", "įvestis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mazie latīņu burti"),
            keywords: &["burti", "ievade", "latīņu", "mazie"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāuru pūriki ratini"),
            keywords: &["abcd", "ngā pū", "pūriki", "ratini", "tāuru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("латински мали букви"),
            keywords: &["букви", "латински", "мали"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെറിയക\u{d4d}ഷരങ\u{d4d}ങൾ"),
            keywords: &["ചെറിയക\u{d4d}ഷരങ\u{d4d}ങൾ", "സ\u{d4d}\u{200c}മ\u{d3e}ൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("латин жижиг үсгийн оролт"),
            keywords: &[
                "abcd",
                "жижиг үсэг",
                "латин",
                "латин жижиг үсгийн оролт",
                "оролт",
                "үсэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इनप\u{941}ट ल\u{945}टिन लोअरक\u{947}स"),
            keywords: &[
                "abcd",
                "अक\u{94d}षर\u{947}",
                "इनप\u{941}ट",
                "ल\u{945}टिन",
                "लोअरक\u{947}स",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("huruf kecil latin input"),
            keywords: &[
                "abcd",
                "huruf",
                "huruf kecil",
                "huruf kecil latin input",
                "input",
                "latin",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("input latin ittra żgħira"),
            keywords: &[
                "abcd",
                "input",
                "input latin ittra żgħira",
                "ittra żgħira",
                "ittri",
                "latin",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းသေး ထည\u{1037}\u{103a}ရန\u{103a}"),
            keywords: &[
                "စာလ\u{102f}\u{1036}းသေး",
                "ထည\u{1037}\u{103a}ရန\u{103a}",
                "လက\u{103a}တင\u{103a}",
                "လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းသေး သင\u{103a}\u{1039}ကေတ",
                "အက\u{1039}ခရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("små bokstaver"),
            keywords: &["abcd", "bokstaver", "inndata", "små bokstaver"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{94d}याटिन सानो अक\u{94d}षर राख\u{94d}न"),
            keywords: &[
                "अक\u{94d}षरहर\u{942}",
                "एबीसीडी",
                "राख\u{94d}न",
                "ल\u{94d}याटिन",
                "ल\u{94d}याटिन सानो अक\u{94d}षर राख\u{94d}न",
                "सानो अक\u{94d}षर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kleine letters"),
            keywords: &["Latijns", "abcd", "invoeren", "kleine letters", "letters"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("små bokstavar"),
            keywords: &["abcd", "bokstavar", "inndata", "små bokstavar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} ସ\u{b3e}ନ ଅକ\u{b4d}ଷର",
            ),
            keywords: &[
                "abcd",
                "ଅକ\u{b4d}ଷରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c}",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} ସ\u{b3e}ନ ଅକ\u{b4d}ଷର",
                "ଛୋଟ ଅକ\u{b4d}ଷର",
                "ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛ\u{a4b}ਟ\u{a47} ਲ\u{a47}ਟਿਨ ਇਨਪ\u{a41}\u{a71}ਟ"),
            keywords: &[
                "abcd",
                "ਛ\u{a4b}ਟ\u{a47}",
                "ਛ\u{a4b}ਟ\u{a47} ਅ\u{a71}ਖਰ",
                "ਛ\u{a4b}ਟ\u{a47} ਲ\u{a47}ਟਿਨ ਇਨਪ\u{a41}\u{a71}ਟ",
                "ਲ\u{a47}ਟਿਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیکے رومی حروف ان پٹ کرو"),
            keywords: &[
                "abcd",
                "ان پٹ",
                "خطوط",
                "لاطینی",
                "نیکے حروف",
                "نیکے رومی حروف ان پٹ کرو",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pút Látin Smọ\u{301}l Lẹ\u{301}ta-dẹm"),
            keywords: &[
                "AB(Ch)D-dẹm",
                "Látin",
                "Put",
                "Pút Látin Smọ\u{301}l Lẹ\u{301}ta-dẹm",
                "Smọ\u{301}l AB(Ch)D",
                "ab(ch)d",
                "abcd",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("małe litery (alfabet łaciński)"),
            keywords: &[
                "abcd",
                "małe litery (alfabet łaciński)",
                "małymi literami",
                "pisać",
                "wprowadzać",
                "łacińskie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاملتوب لاتینې ټيټه الفبا"),
            keywords: &[
                "ای بي سي ډې",
                "توري",
                "شاملتوب",
                "شاملتوب لاتینې ټيټه الفبا",
                "لاتيني",
                "ټيټه الفبا",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("letras latinas minúsculas"),
            keywords: &["abcd", "digitação", "latinas", "letras", "minúsculas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("introdução de minúsculas latinas"),
            keywords: &[
                "abcd",
                "introdução",
                "introdução de minúsculas latinas",
                "latinas",
                "letras",
                "minúsculas",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("introducere minuscule latine"),
            keywords: &["abcd", "introducere", "latine", "litere", "minuscule"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-733"),
            keywords: &["E10-733"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ввод строчными"),
            keywords: &[
                "алфавит",
                "ввод строчными",
                "нижний регистр",
                "строчные",
                "строчные символы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyuguti nko z’ikilatini"),
            keywords: &[
                "abcd",
                "ikilatini",
                "inyuguti",
                "inyuguti nko z’ikilatini",
                "kwinjiza",
                "nto",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انپٽ لاطيني ننڍو ڪيس"),
            keywords: &[
                "ABCD",
                "انپٽ",
                "انپٽ لاطيني ننڍو ڪيس",
                "اکر",
                "لاطيني",
                "لوئرڪيس",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලත\u{dd2}න\u{dca} ස\u{dd2}ම\u{dca}පල\u{dca} අක\u{dd4}ර\u{dd4} ආද\u{dcf}නය"),
            keywords: &[
                "abcd",
                "අක\u{dd4}ර\u{dd4}",
                "ආද\u{dcf}නය",
                "ලත\u{dd2}න\u{dca}",
                "ලත\u{dd2}න\u{dca} ස\u{dd2}ම\u{dca}පල\u{dca} අක\u{dd4}ර\u{dd4} ආද\u{dcf}නය",
                "ස\u{dd2}ම\u{dca}පල\u{dca} අක\u{dd4}ර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zadávanie malých písmen latinky"),
            keywords: &[
                "abcd",
                "latinka",
                "malé písmená",
                "písmená",
                "zadať",
                "zadávanie malých písmen latinky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vnos malih črk latinice"),
            keywords: &[
                "abcd",
                "latinica",
                "male črke",
                "vnos",
                "vnos malih črk latinice",
                "črke",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geli xarfo latin oo yar yar"),
            keywords: &[
                "abcd",
                "geli",
                "geli xarfo latin oo yar yar",
                "latin",
                "xuruuf",
                "yar yar",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fut shkronja latine jokapitale"),
            keywords: &[
                "abcd",
                "fut",
                "fut shkronja latine jokapitale",
                "jokapitale",
                "latin",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("унос малих слова"),
            keywords: &[
                "abcd",
                "латиница",
                "мала",
                "слова",
                "унос",
                "унос малих слова",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["унос малих слова"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("unos malih slova"),
            keywords: &[
                "abcd",
                "latinica",
                "mala",
                "slova",
                "unos",
                "unos malih slova",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["unos malih slova"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gemener"),
            keywords: &["gemener", "små bokstäver"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("weka hefuri ndogo za kilatini"),
            keywords: &[
                "abcd",
                "herufi",
                "herufi ndogo",
                "latini",
                "weka",
                "weka hefuri ndogo za kilatini",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லத\u{bcd}த\u{bc0}ன\u{bcd} சிற\u{bcd}றெழுத\u{bcd}து"),
            keywords: &[
                "ஆங\u{bcd}கிலம\u{bcd}",
                "சிற\u{bcd}றெழுத\u{bcd}து",
                "தட\u{bcd}டச\u{bcd}சு",
                "லத\u{bcd}த\u{bc0}ன\u{bcd} எழுத\u{bcd}து",
                "லத\u{bcd}த\u{bc0}ன\u{bcd} சிற\u{bcd}றெழுத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}న\u{c4d}న అక\u{c4d}షర\u{c3e}లు"),
            keywords: &[
                "అక\u{c4d}షరం",
                "చ\u{c3f}న\u{c4d}న",
                "చ\u{c3f}న\u{c4d}న అక\u{c4d}షర\u{c3e}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳарфҳои хурди вуруди лотинӣ"),
            keywords: &[
                "abcd",
                "вуруд",
                "лотинӣ",
                "ҳарфҳо",
                "ҳарфҳои хурд",
                "ҳарфҳои хурди вуруди лотинӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e31}กษรต\u{e31}วพ\u{e34}มพ\u{e4c}เล\u{e47}ก"),
            keywords: &[
                "ภาษาอ\u{e31}งกฤษ",
                "อ\u{e31}กษรต\u{e31}วพ\u{e34}มพ\u{e4c}เล\u{e47}ก",
                "อ\u{e31}กษรต\u{e31}วเล\u{e47}ก",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ላቲን ነኣሽቱ-ቃላት ኣእቱ"),
            keywords: &[
                "abcd",
                "ላቲን",
                "ቃላት",
                "ነኣሽቱ-ቃላት",
                "ናይ ላቲን ነኣሽቱ-ቃላት ኣእቱ",
                "ኣእቱ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("latyn setir harp girizme"),
            keywords: &[
                "abçd",
                "giriziş",
                "harplar",
                "latyn",
                "latyn setir harp girizme",
                "setir harp",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hū mataʻitohi siʻi pē"),
            keywords: &["aef", "hū mataʻitohi siʻi pē", "mataʻitohi", "siʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("küçük harfler"),
            keywords: &[
                "Latin",
                "Latin küçük harfleri",
                "Latin küçük harfleriyle giriş",
                "küçük harf",
                "küçük harfler",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لاتىنچە كىچىك ھەرپ"),
            keywords: &[
                "abcd",
                "كىرگۈزۈش",
                "كىچىك",
                "لاتىن",
                "لاتىنچە كىچىك ھەرپ",
                "ھەرپ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("введення малими латинськими літерами"),
            keywords: &[
                "abcd",
                "алфавіт",
                "введення",
                "введення малими латинськими літерами",
                "латинські",
                "літери",
                "малі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ان پٹ لاطینی چھوٹے حروف"),
            keywords: &[
                "abcd",
                "ان پٹ",
                "ان پٹ لاطینی چھوٹے حروف",
                "حروف",
                "لاطینی",
                "چھوٹے حروف",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kichik lotin harflarini kiritish"),
            keywords: &[
                "abcd",
                "harflar",
                "kichik",
                "kichik lotin harflarini kiritish",
                "kiritish",
                "lotin",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhập chữ thường la tinh"),
            keywords: &[
                "abcd",
                "chữ",
                "chữ thường",
                "la tinh",
                "nhập",
                "nhập chữ thường la tinh",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbind lateŋ, miniskil"),
            keywords: &[
                "abcd",
                "bataaxal",
                "lateŋ",
                "mbind",
                "mbind lateŋ, miniskil",
                "miniskil",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("fakela oonobumba abancinane besilatin"),
            keywords: &[
                "fakela oonobumba abancinane besilatin",
                "i-latin",
                "oonobumba",
                "oonobumba abancinane",
                "u-abcd",
                "ungeniso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ṣafikun latini ọ\u{300}rọ\u{300} gbólóhùn kékeré"),
            keywords: &[
                "abcd",
                "látíìnì",
                "lé\u{329}tà nlá",
                "lẹ\u{301}tà",
                "àgbéwọlé",
                "ṣafikun latini ọ\u{300}rọ\u{300} gbólóhùn kékeré",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輸入拉丁細階字母"),
            keywords: &["abcd", "字母", "小階", "拉丁", "輸入", "輸入拉丁細階字母"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("输入拉丁细阶字母"),
            keywords: &["abcd", "字母", "小阶", "拉丁", "输入", "输入拉丁细阶字母"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("输入小写拉丁字母"),
            keywords: &["abcd", "打字", "拉丁文", "输入小写拉丁字母", "输入法"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小寫字母鍵"),
            keywords: &["字母", "小寫", "小寫字母鍵", "輸入"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("細階英文輸入"),
            keywords: &["細階", "細階英文", "細階英文輸入"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukufaka uhlamvu oluncane lwesilatini"),
            keywords: &[
                "isilatini",
                "izinhlamvu",
                "okufakiwe",
                "uhlamvu oluncane",
                "ukufaka uhlamvu oluncane lwesilatini",
            ],
        },
    ],
};
#[doc = "🔢"]
pub const INPUT_NUMBERS: crate::Emoji = crate::Emoji {
    glyph: "🔢",
    codepoint: "1F522",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "input numbers",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("invoersyfers"),
            keywords: &["1234", "invoer", "invoersyfers", "syfers"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቁጥር ግቤት"),
            keywords: &["1234", "ቁጥሮች", "የቁጥር ግቤት", "ግቤት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أرقام"),
            keywords: &["أرقام", "أرقام إدخال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সংখ\u{9cd}য\u{9be} দিয\u{9bc}ক"),
            keywords: &["1234", "দিয\u{9bc}ক", "সংখ\u{9cd}য\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("daxiletmə rəqəmləri"),
            keywords: &["1234", "daxiletmə", "daxiletmə rəqəmləri", "rəqəmlər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("увод лічбаў"),
            keywords: &["1234", "лічбы", "увод", "увод лічбаў"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("въвеждане на цифри"),
            keywords: &["1234", "въвеждане", "въвеждане на цифри", "цифри"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইনপ\u{9c1}ট নম\u{9cd}বর"),
            keywords: &[
                "1234",
                "ইনপ\u{9c1}ট",
                "ইনপ\u{9c1}ট নম\u{9cd}বর",
                "সংখ\u{9cd}য\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bizskriv niveroù"),
            keywords: &["1234", "bizskriv", "niveroù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("unos brojeva"),
            keywords: &["1234", "brojevi", "unos", "unos brojeva"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de números"),
            keywords: &["1234", "botó de números", "dígits", "números", "xifres"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏅᏗᏍᏗ ᏗᏎᏍᏗ"),
            keywords: &["1234", "ᏗᎦᏘᏅᏗᏍᏗ ᏗᏎᏍᏗ", "ᏗᎦᏘᏅᏗᏍᏗᎢ", "ᏗᏎᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zadávání čísel"),
            keywords: &["1234", "zadávání", "zadávání čísel", "čísla"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mewnbwn rhifedd"),
            keywords: &["1234", "mewnbwn", "mewnbwn rhifedd", "rhifau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tal"),
            keywords: &["1234", "symbol for tal", "tal"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eingabesymbol Zahlen"),
            keywords: &["Eingabesymbol Zahlen", "Zahlen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αριθμοί"),
            keywords: &["1234", "αριθμοί", "εισαγωγή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("input numbers"),
            keywords: &["1234", "input", "numbers"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("números"),
            keywords: &["1234", "dígitos", "números"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("numbrid"),
            keywords: &["1234", "numbrid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zenbakiak"),
            keywords: &["1234", "idazkera", "zenbakiak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ورودی عددی"),
            keywords: &["اعداد", "ورودی عددی", "۱۲۳۴"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syötä numeroja"),
            keywords: &["1234", "numerot", "syötä", "syötä numeroja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("input na mga numero"),
            keywords: &["1234", "ilagay", "input na mga numero", "numero"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tøl"),
            keywords: &["1234", "tøl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("saisie de chiffres"),
            keywords: &["1234", "chiffres", "saisie", "saisie de chiffres"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "1234",
                "chiffres",
                "nombres",
                "saisie",
                "saisie de chiffres",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("uimhreacha ionchuir"),
            keywords: &["uimhreacha", "uimhreacha ionchuir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ion-chur àireamhan"),
            keywords: &["1234", "ion-chur", "àireamhan"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("números"),
            keywords: &["1234", "díxitos", "escribir", "números"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ન\u{a82}બર\u{acd}સ ઇનપ\u{ac1}ટ કરો"),
            keywords: &["ન\u{a82}બર\u{acd}સ", "ન\u{a82}બર\u{acd}સ ઇનપ\u{ac1}ટ કરો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shigarwar lambobi"),
            keywords: &["1234", "lambobi", "shigarwa", "shigarwar lambobi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן מספרים"),
            keywords: &["הזנה", "לחצן מספרים", "מספרים", "ספרות", "קלט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अ\u{902}क डाल\u{947}\u{902}"),
            keywords: &[
                "1234",
                "अ\u{902}क डाल\u{947}\u{902}",
                "इनप\u{941}ट",
                "न\u{902}बर",
                "स\u{902}ख\u{94d}याए\u{901}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("unos brojeva"),
            keywords: &["1234", "brojevi", "unos", "unos brojeva"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("számbevitel"),
            keywords: &["1234", "bevitel", "számbevitel", "számok"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թվերի ներածում"),
            keywords: &["1234", "թվեր", "թվերի ներածում", "մուտքագրել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("masukan angka"),
            keywords: &["1234", "angka", "masukan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tinye nọmbà gasị"),
            keywords: &["1234", "nọmbà gasị", "tinye", "tinye nọmbà gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tölustafir"),
            keywords: &["setja inn tölustafi", "tölustafir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante con numeri"),
            keywords: &[
                "inserire",
                "numeri",
                "pulsante con numeri",
                "tastierino numerico",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("数字の入力"),
            keywords: &["1234", "入力", "数字", "数字の入力"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lebokake angka"),
            keywords: &["1234", "angka", "lebokake"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რიცხვების შეყვანა"),
            keywords: &["1234", "რიცხვები", "რიცხვების შეყვანა", "შეყვანა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сандарды енгізу"),
            keywords: &["1234", "енгізу", "сандар", "сандарды енгізу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tal"),
            keywords: &["symbol for tal", "tal"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លលេខ"),
            keywords: &[
                "1234",
                "បញ\u{17d2}ច\u{17bc}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លលេខ",
                "លេខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಸಂಖ\u{ccd}ಯ\u{cc6}ಗಳು"),
            keywords: &["1234", "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಸಂಖ\u{ccd}ಯ\u{cc6}ಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("숫자"),
            keywords: &["숫자", "숫자 입력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("इनप\u{942}ट आ\u{902}कड\u{947}"),
            keywords: &["1234", "आ\u{902}कड\u{947}", "इनप\u{942}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сандарды киргизүү"),
            keywords: &["1234", "киргиз", "сандар", "сандарды киргизүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zueleneingab"),
            keywords: &["1234", "Eingab", "Zuelen", "Zueleneingab"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນໝາຍເລກ"),
            keywords: &[
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນໝາຍເລກ",
                "ໝາຍເລກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įvesties skaičiai"),
            keywords: &["1234", "skaičiai", "įvesties skaičiai", "įvestis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cipari"),
            keywords: &["1234", "cipari", "ievade"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāuru tau"),
            keywords: &["1234", "ngā tau", "tāuru", "tāuru tau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("броеви"),
            keywords: &["броеви", "влез"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സംഖ\u{d4d}യകൾ"),
            keywords: &["സംഖ\u{d4d}യ", "സംഖ\u{d4d}യകൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тоон оролт"),
            keywords: &["1234", "оролт", "тоо", "тоон оролт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इनप\u{941}ट स\u{902}ख\u{94d}\u{200d}या"),
            keywords: &["1234", "इनप\u{941}ट", "स\u{902}ख\u{94d}या"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("nombor input"),
            keywords: &["1234", "input", "nombor"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("numri tal-input"),
            keywords: &["1234", "input", "numri", "numri tal-input"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂဏန\u{103a}းများ ထည\u{1037}\u{103a}ရန\u{103a}"),
            keywords: &[
                "ဂဏန\u{103a}းများ",
                "ဂဏန\u{103a}းများ ထည\u{1037}\u{103a}ရန\u{103a}",
                "၁၂၃၄ ဂဏန\u{103a}းပြ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tall"),
            keywords: &["1234", "inndata", "numeriske data", "tall"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अ\u{902}कहर\u{942} राख\u{94d}न"),
            keywords: &[
                "अ\u{902}कहर\u{942} राख\u{94d}न",
                "राख\u{94d}न",
                "स\u{902}ख\u{94d}याहर\u{942}",
                "१२३४",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("cijfers"),
            keywords: &["1234", "cijfers", "invoeren"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tal"),
            keywords: &["1234", "inndata", "numeriske data", "tal"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ସଂଖ\u{b4d}ୟ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "1234",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c}",
                "ସଂଖ\u{b4d}ୟ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਨਪ\u{a41}\u{a71}ਟ ਨ\u{a70}ਬਰ"),
            keywords: &["1234", "ਇਨਪ\u{a41}\u{a71}ਟ", "ਨ\u{a70}ਬਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نمبرز ان پٹ کرو"),
            keywords: &["1234", "اعداد", "ان پٹ", "نمبرز ان پٹ کرو"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pút Nọ\u{301}mba-dẹm"),
            keywords: &[
                "1234",
                "Nọ\u{301}mba-dẹm",
                "Nọ\u{301}mbas",
                "Put",
                "Pút Nọ\u{301}mba-dẹm",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("cyfry"),
            keywords: &["1234", "cyfry", "liczby", "pisać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاملتوب شمیرې"),
            keywords: &["1234", "شاملتوب", "شاملتوب شمیرې", "شمېرې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("números"),
            keywords: &["1234", "digitação", "números"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("introdução de números"),
            keywords: &["1234", "introdução", "introdução de números", "números"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("introducere numere"),
            keywords: &["123", "cifre", "introducere", "numere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-734"),
            keywords: &["E10-734"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ввод цифр"),
            keywords: &["ввод", "ввод цифр", "цифры"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("nomero z’ibyanditswe"),
            keywords: &["1234", "nomero", "z’ibyanditswe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انپٽ نمبر"),
            keywords: &["1234", "انپٽ", "نمبر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අංක ආද\u{dcf}නය"),
            keywords: &["1234", "අංක", "ආද\u{dcf}නය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zadávanie čísel"),
            keywords: &["1234", "zadať", "zadávanie čísel", "čísla"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vnos številk"),
            keywords: &["1234", "vnos", "vnos številk", "številke"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geli tirooyin"),
            keywords: &["1234", "geli", "tirooyin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fut numra"),
            keywords: &["1234", "fut", "numra"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("унос бројева"),
            keywords: &["1234", "бројеви", "унос", "унос бројева"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["унос бројева"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("unos brojeva"),
            keywords: &["1234", "brojevi", "unos", "unos brojeva"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["unos brojeva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("siffror"),
            keywords: &["nummer", "siffror"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("weka nambari"),
            keywords: &["1234", "nambari", "weka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எண\u{bcd}கள\u{bcd}"),
            keywords: &[
                "எண\u{bcd}",
                "எண\u{bcd} தட\u{bcd}டச\u{bcd}சு",
                "எண\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇన\u{c4d}\u{200c}పుట\u{c4d} సంఖ\u{c4d}యలు"),
            keywords: &["1234", "ఇన\u{c4d}\u{200c}పుట\u{c4d}", "సంఖ\u{c4d}యలు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рақамҳои вуруд"),
            keywords: &["1234", "вуруд", "рақамҳо", "рақамҳои вуруд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมายเลข"),
            keywords: &["1234", "ต\u{e31}วเลข", "หมายเลข"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ቁጽርታት ኣእቱ"),
            keywords: &["1234", "ቁጽርታት", "ኣእቱ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("san girizme"),
            keywords: &["1234", "giriziş", "san girizme", "sanlar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hū mataʻifika pē"),
            keywords: &["123", "hū mataʻifika pē", "mataʻifika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sayılar"),
            keywords: &["sayı girişi", "sayılar"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سان كىرگۈزۈش"),
            keywords: &["1234", "سان", "سان كىرگۈزۈش", "كىرگۈزش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("введення цифрами"),
            keywords: &["1234", "введення", "введення цифрами", "цифри"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ان پٹ اعداد"),
            keywords: &["1234", "ان پٹ", "ان پٹ اعداد", "نمبرات"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("raqam kiritish"),
            keywords: &["1234", "raqam kiritish", "raqamlar", "sonlar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhập số"),
            keywords: &["1234", "nhập", "số"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbindu nimero"),
            keywords: &["1234", "mbind", "mbindu nimero", "numero"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amanani ongeniso"),
            keywords: &["1234", "amanani", "amanani ongeniso", "ungeniso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ṣafikun awọn nọnba"),
            keywords: &["1234", "nọ\u{301}mbà", "àgbéwọlé", "ṣafikun awọn nọnba"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輸入數字"),
            keywords: &["1234", "數字", "輸入", "輸入數字"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("输入数字"),
            keywords: &["1234", "数字", "输入", "输入数字"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("输入数字"),
            keywords: &["1234", "打字", "输入数字"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("數字鍵"),
            keywords: &["123", "數字", "數字鍵", "輸入"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("數字輸入"),
            keywords: &["數字輸入"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinombolo ezifakiwe"),
            keywords: &["1234", "izinombolo", "izinombolo ezifakiwe", "okufakiwe"],
        },
    ],
};
#[doc = "🔣"]
pub const INPUT_SYMBOLS: crate::Emoji = crate::Emoji {
    glyph: "🔣",
    codepoint: "1F523",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "input symbols",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("invoersimbole"),
            keywords: &["invoer", "invoersimbole", "〒♪&%"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የግቤት ምልክቶች"),
            keywords: &["የግቤት ምልክቶች", "ግቤት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رموز"),
            keywords: &["رموز", "رموز إدخال"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিহ\u{9cd}ন দিয\u{9bc}ক"),
            keywords: &["চিহ\u{9cd}ন দিয\u{9bc}ক", "দিয\u{9bc}ক", "〒♪&%"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("daxiletmə simvolları"),
            keywords: &["daxiletmə", "daxiletmə simvolları"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("увод сімвалаў"),
            keywords: &["сімвалы", "увод", "увод сімвалаў"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("въвеждане на символи"),
            keywords: &["въвеждане", "въвеждане на символи"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইনপ\u{9c1}ট চিহ\u{9cd}ন"),
            keywords: &["ইনপ\u{9c1}ট", "ইনপ\u{9c1}ট চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bizskriv arouezioù"),
            keywords: &["arouezioù", "bizskriv"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("unos simbola"),
            keywords: &["unos", "unos simbola"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de símbols"),
            keywords: &["botó de símbols", "símbols", "〒♪&%"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏅᏗᏍᏗ ᏚᏙᏪᎸᎢ"),
            keywords: &["ᏗᎦᏘᏅᏗᏍᏗ", "ᏗᎦᏘᏅᏗᏍᏗ ᏚᏙᏪᎸᎢ", "〒♪&%"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zadávání symbolů"),
            keywords: &[
                "klávesnice",
                "psaní",
                "vstup",
                "zadávání",
                "zadávání symbolů",
                "〒♪&%",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mewnbwn symbylau"),
            keywords: &["mewnbwn", "mewnbwn symbylau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("symboler"),
            keywords: &["symbol for symboler", "symboler"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eingabesymbol Sonderzeichen"),
            keywords: &["Eingabesymbol Sonderzeichen", "Sonderzeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολα"),
            keywords: &["εισαγωγή", "σύμβολα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("input symbols"),
            keywords: &["input", "input symbols", "〒♪&%"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolos"),
            keywords: &["símbolos", "〒♪&%"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sümbolid"),
            keywords: &["sisestus", "sümbolid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ikurrak"),
            keywords: &["idazketa", "ikurrak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ورودی نماد"),
            keywords: &["ورودی", "ورودی نماد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syötä merkkejä"),
            keywords: &["merkit", "symbolit", "syötä", "syötä merkkejä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("input na mga simbolo"),
            keywords: &["ilagay", "input na mga simbolo", "simbolo", "〒♪&%"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("symbol"),
            keywords: &["symbol", "〒♪&%"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("saisie de symboles"),
            keywords: &["saisie", "saisie de symboles", "symboles"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["saisie", "saisie de symboles", "symboles", "〒♪&%"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombailí ionchuir"),
            keywords: &["comharthaí", "siombailí", "siombailí ionchuir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ion-chur shamhlaichean"),
            keywords: &["ion-chur", "ion-chur shamhlaichean", "⁊%", "〒♪&amp"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolos"),
            keywords: &["escribir", "símbolos", "〒♪&%"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રતીકો ઇનપ\u{ac1}ટ કરો"),
            keywords: &["પ\u{acd}રતીકો", "પ\u{acd}રતીકો ઇનપ\u{ac1}ટ કરો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shigarwar alamomi"),
            keywords: &["shigarwa", "shigarwar alamomi", "〒♪&%"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן סמלים"),
            keywords: &["הזנה", "לחצן סמלים", "סימנים", "סמלים", "קלט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("इनप\u{941}ट चिह\u{94d}न"),
            keywords: &["इनप\u{941}ट", "चिह\u{94d}न", "〒♪&%"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("unos simbola"),
            keywords: &["unos", "unos simbola"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szimbólumok bevitele"),
            keywords: &["bevitel", "szimbólumok bevitele"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նշանների ներածում"),
            keywords: &["մուտքագրել", "նշանների ներածում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("masukan simbol"),
            keywords: &["masukan", "masukan simbol", "〒♪&%"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tinye akara gasị"),
            keywords: &["tinye", "tinye akara gasị", "〒♪&%"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tákn"),
            keywords: &["setja inn tákn", "tákn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante con simboli"),
            keywords: &[
                "inserire",
                "pulsante con simboli",
                "simboli",
                "tastierino simboli",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("記号の入力"),
            keywords: &["〒♪&%", "入力", "記号", "記号の入力"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lebokake simbol"),
            keywords: &["lebokake", "lebokake simbol", "〒♪&%"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სიმბოლოების შეყვანა"),
            keywords: &["სიმბოლოების შეყვანა", "შეყვანა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("белгілерді енгізу"),
            keywords: &["белгілерді енгізу", "енгізу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("symboler"),
            keywords: &["symbol for symboler", "symboler"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លសញ\u{17d2}ញា"),
            keywords: &[
                "បញ\u{17d2}ច\u{17bc}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លសញ\u{17d2}ញា",
                "សញ\u{17d2}ញា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}ಗಳು"),
            keywords: &[
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}ಗಳು",
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಸಂಕೇತಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기호"),
            keywords: &["기호", "기호 입력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("इनप\u{942}ट चिन\u{94d}ना\u{902}"),
            keywords: &["इनप\u{942}ट", "इनप\u{942}ट चिन\u{94d}ना\u{902}", "〒♪&%"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("символдорду киргизүү"),
            keywords: &["киргизүү", "символдорду киргизүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Symbolereingab"),
            keywords: &["Eingab", "Symbolereingab", "〒♪&%"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນສ\u{eb1}ນຍາລ\u{eb1}ກ"),
            keywords: &[
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນສ\u{eb1}ນຍາລ\u{eb1}ກ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įvesties simboliai"),
            keywords: &["įvesties simboliai", "įvestis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("simboli"),
            keywords: &["ievade", "simboli"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāuru tohu"),
            keywords: &["tāuru", "tāuru tohu", "〒♪&%"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("симболи"),
            keywords: &["влез", "симболи"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇൻപ\u{d41}ട\u{d4d}ട\u{d4d} അടയ\u{d3e}ളങ\u{d4d}ങൾ"),
            keywords: &[
                "ഇൻപ\u{d41}ട\u{d4d}ട\u{d4d}",
                "ഇൻപ\u{d41}ട\u{d4d}ട\u{d4d} അടയ\u{d3e}ളങ\u{d4d}ങൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дүрс тэмдгийн оролт"),
            keywords: &["дүрс", "дүрс тэмдгийн оролт", "оролт", "тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इनप\u{941}ट चिन\u{94d}ह\u{947}"),
            keywords: &["1234", "इनप\u{941}ट", "इनप\u{941}ट चिन\u{94d}ह\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol input"),
            keywords: &["input", "simbol input"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simboli tal-input"),
            keywords: &["input", "simboli tal-input", "〒♪&%"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သင\u{103a}\u{1039}ကေတများ ထည\u{1037}\u{103a}ရန\u{103a}"),
            keywords: &[
                "ထည\u{1037}\u{103a}သ\u{103d}င\u{103a}းရန\u{103a}",
                "သင\u{103a}\u{1039}ကေတများ ထည\u{1037}\u{103a}ရန\u{103a}",
                "အထ\u{1030}းအက\u{1039}ခရာ သင\u{103a}\u{1039}ကေတများ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("symboler"),
            keywords: &["inndata", "symboler", "〒♪&%"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{902}क\u{947}तहर\u{942} राख\u{94d}न"),
            keywords: &["राख\u{94d}न", "स\u{902}क\u{947}तहर\u{942} राख\u{94d}न"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("symbolen"),
            keywords: &["invoeren", "symbolen", "〒♪&%"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("symbol"),
            keywords: &["inndata", "symbol", "〒♪&%"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ସଙ\u{b4d}କେତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c}",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ସଙ\u{b4d}କେତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "〒♪&%",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਨਪ\u{a41}\u{a71}ਟ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਇਨਪ\u{a41}\u{a71}ਟ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਇਨਪ\u{a41}\u{a71}ਟ ਨਿਸ\u{a3c}ਾਨ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("علامتاں ان پٹ کرو"),
            keywords: &["ان پٹ", "علامتاں ان پٹ کرو", "〒♪&%"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pút Sain-dẹm"),
            keywords: &["Put", "Pút Sain-dẹm", "〒♪&%"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbole"),
            keywords: &["pisać", "symbole", "wprowadzać", "znaki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاملتوب سمبولونه"),
            keywords: &["شاملتوب", "شاملتوب سمبولونه", "〒♪&%"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolos"),
            keywords: &["digitação", "símbolos", "〒♪&%"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("introdução de símbolos"),
            keywords: &["introdução", "introdução de símbolos", "símbolos"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("introducere simboluri"),
            keywords: &["introducere", "simboluri", "〒♪&%"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-735"),
            keywords: &["E10-735"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ввод символов"),
            keywords: &["ввод", "ввод символов", "символы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibimenyetso byinjizwa"),
            keywords: &["ibimenyetso byinjizwa", "ibyanditswe", "〒♪&%"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انپٽ نشانيون"),
            keywords: &["انپٽ", "انپٽ نشانيون", "〒♪&%"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සංකේත ආද\u{dcf}නය"),
            keywords: &["ආද\u{dcf}නය", "සංකේත ආද\u{dcf}නය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zadávanie symbolov"),
            keywords: &["zadať", "zadávanie symbolov"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vnos simbolov"),
            keywords: &["vnos", "vnos simbolov"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geli calaamado"),
            keywords: &["geli", "geli calaamado", "〒♪&%"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fut simbole"),
            keywords: &["fut", "fut simbole", "〒♪&%"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("унос симбола"),
            keywords: &["унос", "унос симбола", "〒♪&%"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["унос симбола"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("unos simbola"),
            keywords: &["unos", "unos simbola", "〒♪&%"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["unos simbola"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("specialtecken"),
            keywords: &["specialtecken", "symboler"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("weka alama"),
            keywords: &["weka", "weka alama"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குறிய\u{bc0}டுகள\u{bcd}"),
            keywords: &[
                "குறிய\u{bc0}டு",
                "குறிய\u{bc0}டுகள\u{bcd}",
                "சிம\u{bcd}பல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇన\u{c4d}\u{200c}పుట\u{c4d} గుర\u{c4d}తులు"),
            keywords: &[
                "ఇన\u{c4d}\u{200c}పుట\u{c4d} గుర\u{c4d}తులు",
                "గుర\u{c4d}తు",
                "చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломатҳои вуруд"),
            keywords: &["аломатҳои вуруд", "вуруд", "〒♪&%"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}"),
            keywords: &["ส\u{e31}ญล\u{e31}กษณ\u{e4c}", "เคร\u{e37}\u{e48}องหมาย"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ኣርማታት ኣእቱ"),
            keywords: &["ኣርማታት ኣእቱ", "ኣእቱ", "〒♪&%"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("simwol girizme"),
            keywords: &["giriziş", "simwol girizme", "〒♪&%"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hū fakaʻilonga pē"),
            keywords: &["@&%", "fakaʻilonga", "hū fakaʻilonga pē"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("işaretler"),
            keywords: &["işaret girişi", "işaretler"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بەلگە كىرگۈزۈش"),
            keywords: &["بەلگە كىرگۈزۈش", "كىرگۈزۈش", "〒♪&%"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("введення символів"),
            keywords: &["введення", "введення символів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ان پٹ علامات"),
            keywords: &["ان پٹ", "ان پٹ علامات", "علامات"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("belgi kiritish"),
            keywords: &["belgi kiritish", "kiritish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhập biểu tượng"),
            keywords: &["nhập", "nhập biểu tượng", "〒♪&%"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndargay mbind"),
            keywords: &["mbind", "màndargay mbind", "〒♪&%"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iisimboli zongeniso"),
            keywords: &["iisimboli zongeniso", "ungeniso", "〒♪&%"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ṣafikun awọn àmì"),
            keywords: &["àgbéwọlé", "ṣafikun awọn àmì", "〒♪&%"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輸入符號"),
            keywords: &["〒♪&%", "輸入", "輸入符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("输入符号"),
            keywords: &["〒♪&%", "输入", "输入符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("输入符号"),
            keywords: &["字符", "打字", "输入符号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("符號鍵"),
            keywords: &["符號鍵", "輸入"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("符號輸入"),
            keywords: &["符號輸入"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izimpawu ezifakiwe"),
            keywords: &["izimpawu ezifakiwe", "okufakiwe"],
        },
    ],
};
#[doc = "🔤"]
pub const INPUT_LATIN_LETTERS: crate::Emoji = crate::Emoji {
    glyph: "🔤",
    codepoint: "1F524",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "input latin letters",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("invoer- Latynse letters"),
            keywords: &[
                "ABC",
                "Latyn",
                "alfabet",
                "invoer",
                "invoer- Latynse letters",
                "letters",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የላቲን ፊደላት ግቤት"),
            keywords: &["ላቲን", "የላቲን ፊደላት ግቤት", "የፊደል ገበታ", "ግቤት", "ፊደላት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أبجدية لاتينية"),
            keywords: &[
                "ABC",
                "أبجدية إدخال لاتينية",
                "أبجدية لاتينية",
                "إنجليزي",
                "لاتيني",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লেটিন বৰ\u{9cd}ণ দিয\u{9bc}ক"),
            keywords: &[
                "abc",
                "দিয\u{9bc}ক",
                "বৰ\u{9cd}ণ",
                "বৰ\u{9cd}ণম\u{9be}ল\u{9be}",
                "লেটিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("latın hərfləri daxiletməsi"),
            keywords: &[
                "abc",
                "daxiletmə",
                "hərflər",
                "latın",
                "latın hərfləri daxiletməsi",
                "əlifba",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("увод лацінскіх літар"),
            keywords: &[
                "алфавіт",
                "лацінскі",
                "літары",
                "увод",
                "увод лацінскіх літар",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("въвеждане на букви на латиница"),
            keywords: &[
                "[abc]",
                "букви",
                "въвеждане",
                "въвеждане на букви на латиница",
                "латиница",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ইনপ\u{9c1}ট ল\u{9be}তিন অক\u{9cd}ষর"),
            keywords: &[
                "অক\u{9cd}ষর",
                "ইনপ\u{9c1}ট",
                "এবিসি",
                "বর\u{9cd}ণম\u{9be}ল\u{9be}",
                "ল\u{9be}তিন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bizskriv lizherennoù latin"),
            keywords: &["abc", "bizskriv", "latin", "lizherennoù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("unos slova latinica"),
            keywords: &["abc", "abeceda", "latinica", "slova", "unos"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó de lletres llatines"),
            keywords: &[
                "abc",
                "alfabet",
                "botó de lletres llatines",
                "lletres",
                "lletres llatines",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏘᏅᏗᏍᏗ ᎴᏔᏂ ᏗᎪᎵᏰᏗ"),
            keywords: &[
                "abc",
                "ᎳᏔᏂ",
                "ᏗᎦᏘᏅᏗᏍᏗ",
                "ᏗᎦᏘᏅᏗᏍᏗ ᎴᏔᏂ ᏗᎪᎵᏰᏗ",
                "ᏗᎪᏪᎳᏅᎢ",
                "ᏗᎪᏪᎶᏗ ᏚᏃᏴᎬᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zadávání písmen v latince"),
            keywords: &[
                "abcd",
                "abeceda",
                "klávesnice",
                "latinka",
                "psaní",
                "písmena",
                "vstup",
                "zadávání",
                "zadávání písmen v latince",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mewnbwn llythrennau lladin"),
            keywords: &[
                "abc",
                "gwyddor",
                "lladin",
                "mewnbwn",
                "mewnbwn llythrennau lladin",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("latinske alfabet"),
            keywords: &["abc", "latinske alfabet", "symbol for latinske alfabet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Eingabesymbol lateinische Buchstaben"),
            keywords: &[
                "Buchstaben",
                "Eingabesymbol lateinische Buchstaben",
                "lateinische Buchstaben",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λατινικά γράμματα"),
            keywords: &["abc", "αλφάβητος", "γράμματα", "εισαγωγή", "λατινικά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("input latin letters"),
            keywords: &["abc", "alphabet", "input", "latin", "letters"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("input Latin letters"),
            keywords: &["input Latin letters"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("input Latin letters"),
            keywords: &["Latin", "abc", "alphabet", "input", "letters"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("alfabeto latino"),
            keywords: &["ABC", "alfabeto latino", "latino"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["abc", "alfabeto latino", "latino", "letras"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ladina tähed"),
            keywords: &["abc", "ladina", "tähed", "tähestik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hizki latindarrak"),
            keywords: &[
                "abc",
                "alfabetoa",
                "hizki latindarrak",
                "latindarra",
                "letrak",
                "sarrera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ورودی حروف لاتین"),
            keywords: &["الفبا", "حروف", "لاتین", "ورودی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syötä kirjaimia"),
            keywords: &[
                "aakkoset",
                "kirjaimet",
                "latinalaiset",
                "syötä",
                "syötä kirjaimia",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("input na mga latin na titik"),
            keywords: &[
                "abakada",
                "abc",
                "alpabeto",
                "ilagay",
                "input na mga latin na titik",
                "latin",
                "titik",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bókstavir"),
            keywords: &["abc", "alfabet", "bókstavarað", "bókstavir", "stavrað"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("alphabet latin"),
            keywords: &["alphabet", "alphabet latin", "lettres", "saisie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["abc", "alphabet", "latin", "lettres", "saisie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("litreacha Laidineacha ionchuir"),
            keywords: &["litreacha Laidineacha", "litreacha Laidineacha ionchuir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ion-chur litrichean Laideann"),
            keywords: &[
                "abc",
                "aibideil",
                "ion-chur",
                "ion-chur litrichean Laideann",
                "laideann",
                "litir",
                "litrichean",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("letras"),
            keywords: &["abc", "alfabeto", "escribir", "letras"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લ\u{ac7}ટિન મ\u{ac2}ળાક\u{acd}ષર ઇનપ\u{ac1}ટ કરો"),
            keywords: &[
                "abc",
                "અ\u{a82}ગ\u{acd}ર\u{ac7}જી",
                "ઇનપ\u{ac1}ટ",
                "લ\u{ac7}ટિન",
                "લ\u{ac7}ટિન મ\u{ac2}ળાક\u{acd}ષર",
                "લ\u{ac7}ટિન મ\u{ac2}ળાક\u{acd}ષર ઇનપ\u{ac1}ટ કરો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shigarwar baƙaƙe na latin"),
            keywords: &[
                "abacada",
                "abc",
                "baƙaƙe",
                "latin",
                "shigarwa",
                "shigarwar baƙaƙe na latin",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן אותיות לטיניות"),
            keywords: &["הזנה", "לחצן אותיות לטיניות", "לטינית", "קלט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("इनप\u{941}ट ल\u{948}टिन अक\u{94d}षर"),
            keywords: &["abc", "अक\u{94d}षर", "इनप\u{941}ट", "ल\u{948}टिन"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("unos latiničnih slova"),
            keywords: &[
                "abc",
                "abeceda",
                "latinica",
                "slova",
                "unos latiničnih slova",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("latin betűk bevitele"),
            keywords: &["abc", "betűk", "bevitel", "latin", "latin betűk bevitele"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լատինատառ ներածում"),
            keywords: &[
                "abc",
                "այբուբեն",
                "լատինական",
                "լատինատառ ներածում",
                "մուտքագրել",
                "տառեր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("masukan huruf latin"),
            keywords: &["abc", "alfabet", "huruf", "latin", "masukan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("tinye mkpụrụedemede latin gasị"),
            keywords: &[
                "abc",
                "alphabeti",
                "latin",
                "mkpụrụedemede gasi",
                "tinye",
                "tinye mkpụrụedemede latin gasị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("latneska stafrófið"),
            keywords: &[
                "ABC",
                "enska",
                "latneska stafrófið",
                "setja inn latneska stafrófið",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante con lettere latine"),
            keywords: &[
                "ABC",
                "alfabeto",
                "caratteri alfabetici",
                "inglese",
                "inserire",
                "pulsante con lettere latine",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("英字の入力"),
            keywords: &["abc", "アルファベット", "ローマ字", "英字", "英字の入力"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lebokake aksara latin"),
            keywords: &["abc", "aksara", "alfabet", "latin", "lebokake"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლათინური ასოების შეყვანა"),
            keywords: &[
                "abc",
                "ანბანი",
                "ასოები",
                "ლათინური",
                "ლათინური ასოების შეყვანა",
                "შეყვანა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("латын әріптерін енгізу"),
            keywords: &[
                "abc",
                "енгізу",
                "латын",
                "латын әріптерін енгізу",
                "әліппе",
                "әріптер",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("latinske alfabet"),
            keywords: &["latinske alfabet", "symbol for latinske alfabet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លអក\u{17d2}សរឡាតា\u{17c6}ង"),
            keywords: &[
                "abc",
                "បញ\u{17d2}ច\u{17bc}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងបញ\u{17d2}ច\u{17bc}លអក\u{17d2}សរឡាតា\u{17c6}ង",
                "ឡាតា\u{17c6}ង",
                "អក\u{17d2}ខរក\u{17d2}រម",
                "អក\u{17d2}សរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd} ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd} ಅಕ\u{ccd}ಷರಗಳು"),
            keywords: &[
                "ಅಕ\u{ccd}ಷರಗಳು",
                "ಇನ\u{ccd}\u{200c}ಪುಟ\u{ccd}",
                "ಎಬ\u{cbf}ಸ\u{cbf}",
                "ಲ\u{ccd}ಯಾಟ\u{cbf}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("라틴어 알파벳"),
            keywords: &["라틴어 알파벳", "라틴어 알파벳 입력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("इनप\u{942}ट ल\u{945}टीन अक\u{94d}षरा\u{902}"),
            keywords: &[
                "abc",
                "अक\u{94d}षरा\u{902}",
                "इनप\u{942}ट",
                "इनप\u{942}ट ल\u{945}टीन अक\u{94d}षरा\u{902}",
                "लाती\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("латын тамгаларын киргизүү"),
            keywords: &["алфавит", "латын", "латын тамгаларын киргизүү", "тамгалар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Buschtaweneingab (Latäin)"),
            keywords: &[
                "Alphabet",
                "Buschtawen",
                "Buschtaweneingab (Latäin)",
                "Eingab",
                "abc",
                "latäin",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນອ\u{eb1}ກສອນລາຕ\u{eb4}ນ"),
            keywords: &[
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມປ\u{ec9}ອນອ\u{eb1}ກສອນລາຕ\u{eb4}ນ",
                "ລາຕ\u{eb4}ນ",
                "ອ\u{eb1}ກສອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įvestis lotyniškos raidės"),
            keywords: &["abc", "abėcėlė", "lotyniškos", "raidės", "įvestis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("latīņu burti"),
            keywords: &["abc", "alfabēts", "burti", "ievade", "latīņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāuru pū ratini"),
            keywords: &[
                "abc",
                "ngā pū",
                "ratini",
                "tātai reta",
                "tāuru",
                "tāuru pū ratini",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("латински букви"),
            keywords: &["букви", "латински"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇംഗ\u{d4d}ലീഷ\u{d4d} അക\u{d4d}ഷരമ\u{d3e}ല"),
            keywords: &[
                "ഇംഗ\u{d4d}ലീഷ\u{d4d} അക\u{d4d}ഷരം എബിസി",
                "ഇംഗ\u{d4d}ലീഷ\u{d4d} അക\u{d4d}ഷരമ\u{d3e}ല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("латин үсгийн оролт"),
            keywords: &[
                "abc",
                "латин",
                "латин үсгийн оролт",
                "оролт",
                "цагаан толгой",
                "үсэг",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("इनप\u{941}ट ल\u{945}टिन अक\u{94d}षर\u{947}"),
            keywords: &[
                "abc",
                "अक\u{94d}षर\u{947}",
                "इनप\u{941}ट",
                "ल\u{945}टिन",
                "वर\u{94d}णमाला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("huruf latin input"),
            keywords: &["abc", "abjad", "huruf", "input", "latin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("input ittri latin"),
            keywords: &["abc", "alfabett", "input", "ittri", "latin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းများ ထည\u{1037}\u{103a}ရန\u{103a}"),
            keywords: &[
                "ထည\u{1037}\u{103a}သ\u{103d}င\u{103a}းရန\u{103a}",
                "လက\u{103a}တင\u{103a}",
                "လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းများ ထည\u{1037}\u{103a}ရန\u{103a}",
                "လက\u{103a}တင\u{103a} စာလ\u{102f}\u{1036}းသေးများ",
                "အက\u{1039}ခရာများ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("latinsk alfabet"),
            keywords: &["ABC", "bokstaver", "inndata", "latinsk", "latinsk alfabet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{94d}याटिन अक\u{94d}षर राख\u{94d}न"),
            keywords: &[
                "अक\u{94d}षर",
                "अक\u{94d}षरहर\u{942}",
                "एबीसी",
                "राख\u{94d}न",
                "ल\u{94d}याटिन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Latijns alfabet"),
            keywords: &["Latijns", "abc", "alfabet", "invoeren", "letters"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("latinsk alfabet"),
            keywords: &["ABC", "bokstavar", "inndata", "latinsk", "latinsk alfabet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c} ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c} ଅକ\u{b4d}ଷରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "abc",
                "ଅକ\u{b4d}ଷରଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଇନପ\u{b41}ଟ\u{b4d}\u{200c}",
                "ବର\u{b4d}ଣ\u{b4d}ଣମ\u{b3e}ଳ\u{b3e}",
                "ଲ\u{b3e}ଟ\u{b3f}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਨਪ\u{a41}\u{a71}ਟ ਲ\u{a47}ਟਿਨ ਅ\u{a71}ਖਰ"),
            keywords: &[
                "abc",
                "ਇਨਪ\u{a41}\u{a71}ਟ ਲ\u{a47}ਟਿਨ ਅ\u{a71}ਖਰ",
                "ਏਬੀਸੀ",
                "ਲ\u{a47}ਟਿਨ ਅ\u{a70}ਗਰ\u{a47}ਜ\u{a3c}ੀ",
                "ਲ\u{a47}ਟਿਨ ਅ\u{a71}ਖਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("رومی حرف ان پٹ کرو"),
            keywords: &[
                "abc",
                "ان پٹ",
                "حروف\u{650} تہجی",
                "خطوط",
                "رومی حرف ان پٹ کرو",
                "لاطینی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pút Látin Lẹ\u{301}ta-dẹm"),
            keywords: &[
                "AB(Ch)D",
                "AB(Ch)D-dẹm",
                "Látin",
                "Put",
                "Pút Látin Lẹ\u{301}ta-dẹm",
                "ab(ch)",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("litery (alfabet łaciński)"),
            keywords: &[
                "abecadło",
                "alfabet",
                "litery (alfabet łaciński)",
                "małe litery",
                "pierwsze litery",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شاملتوب لاتینې الفبا"),
            keywords: &[
                "الفبا",
                "ای بي سي",
                "توري",
                "شاملتوب",
                "شاملتوب لاتینې الفبا",
                "لاتيني",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("letras latinas"),
            keywords: &["abc", "alfabeto", "digitação", "latinas", "letras"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("introdução de letras latinas"),
            keywords: &[
                "abc",
                "abecedário",
                "alfabeto",
                "introdução",
                "introdução de letras latinas",
                "latinas",
                "letras",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("introducere litere latine"),
            keywords: &["abc", "alfabet", "introducere", "latine", "litere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-736"),
            keywords: &["E10-736"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ввод латиницей"),
            keywords: &[
                "алфавит",
                "буквы",
                "ввод латиницей",
                "латиница",
                "латинский алфавит",
                "символы",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyuguti z’ikilatini"),
            keywords: &[
                "abc",
                "ikilatini",
                "inyuguti",
                "inyuguti z’ikilatini",
                "itonde ry’inyuguti",
                "kwinjiza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("انپٽ لاطيني اکر"),
            keywords: &["abc", "الفابيٽ", "انپٽ", "اکر", "لاطيني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලත\u{dd2}න\u{dca} අක\u{dd4}ර\u{dd4} ආද\u{dcf}නය"),
            keywords: &[
                "abc",
                "අක\u{dd4}ර\u{dd4}",
                "ආද\u{dcf}නය",
                "ලත\u{dd2}න\u{dca}",
                "හෝඩ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zadávanie písmen latinky"),
            keywords: &[
                "abc",
                "abeceda",
                "latinka",
                "písmená",
                "zadať",
                "zadávanie písmen latinky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vnos črk latinice"),
            keywords: &[
                "abc",
                "abeceda",
                "latinica",
                "vnos",
                "vnos črk latinice",
                "črke",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("geli xuruuf latin ah"),
            keywords: &[
                "abc",
                "alifbeeta",
                "geli",
                "geli xuruuf latin ah",
                "latin",
                "xuruuf",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fut shkronja latine"),
            keywords: &["abc", "alfabet", "fut", "fut shkronja latine", "latin"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("унос латиничних слова"),
            keywords: &[
                "abc",
                "абецеда",
                "латиница",
                "слова",
                "унос",
                "унос латиничних слова",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["унос латиничних слова"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("unos latiničnih slova"),
            keywords: &[
                "abc",
                "abeceda",
                "latinica",
                "slova",
                "unos",
                "unos latiničnih slova",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["unos latiničnih slova"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bokstäver"),
            keywords: &["ABC", "alfabet", "bokstäver"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("weka herufi za kilatini"),
            keywords: &[
                "abc",
                "alfabeti",
                "herufi",
                "latini",
                "weka",
                "weka herufi za kilatini",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லத\u{bcd}த\u{bc0}ன\u{bcd} எழுத\u{bcd}து"),
            keywords: &[
                "ABC",
                "ஆங\u{bcd}கிலம\u{bcd}",
                "எண\u{bcd} தட\u{bcd}டச\u{bcd}சு",
                "லத\u{bcd}த\u{bc0}ன\u{bcd} எழுத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇన\u{c4d}\u{200c}పుట\u{c4d} ల\u{c3e}ట\u{c3f}న\u{c4d} అక\u{c4d}షర\u{c3e}లు"),
            keywords: &[
                "అక\u{c4d}షరం",
                "ఇన\u{c4d}\u{200c}పుట\u{c4d} ల\u{c3e}ట\u{c3f}న\u{c4d} అక\u{c4d}షర\u{c3e}లు",
                "ల\u{c3e}ట\u{c3f}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳарфҳои вуруди лотинӣ"),
            keywords: &[
                "abc",
                "алфавит",
                "вуруд",
                "лотинӣ",
                "ҳарфҳо",
                "ҳарфҳои вуруди лотинӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}วอ\u{e31}กษรภาษาอ\u{e31}งกฤษ"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษร",
                "ต\u{e31}วอ\u{e31}กษรภาษาอ\u{e31}งกฤษ",
                "อ\u{e31}กษรละต\u{e34}น",
                "เอบ\u{e35}ซ\u{e35}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ላቲን ቃላት ኣእቱ"),
            keywords: &["abc", "ላቲን", "ቃላት", "ኣእቱ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("latyn harp girizme"),
            keywords: &[
                "abç",
                "elipbiý",
                "giriziş",
                "harplar",
                "latyn",
                "latyn harp girizme",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hū mataʻitohi fakalatina"),
            keywords: &["hū mataʻitohi fakalatina", "latina", "mataʻitohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Latin alfabesi"),
            keywords: &[
                "ABC",
                "Latin",
                "Latin alfabesi",
                "Latin alfabesiyle giriş",
                "İngilizce",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("لاتىنچە ھەرپ كىرگۈزۈش"),
            keywords: &[
                "abc",
                "ئېلىپبە",
                "كىرگۈزۈش",
                "لاتىن",
                "لاتىنچە ھەرپ كىرگۈزۈش",
                "ھەرپ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("введення латинськими літерами"),
            keywords: &[
                "abc",
                "алфавіт",
                "введення",
                "введення латинськими літерами",
                "латинські",
                "літери",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ان پٹ لاطینی حروف"),
            keywords: &[
                "abc",
                "ان پٹ",
                "ان پٹ لاطینی حروف",
                "حروف",
                "حروف تہجی",
                "لاطینی",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lotin harflarini kiritish"),
            keywords: &[
                "abc",
                "alifbo",
                "harflar",
                "lotin",
                "lotin harflarini kiritish",
                "matn",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhập chữ cái la tinh"),
            keywords: &[
                "abc",
                "bảng chữ cái",
                "chữ cái",
                "la tinh",
                "nhập",
                "nhập chữ cái la tinh",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("arafi mbindu lateŋ"),
            keywords: &[
                "abc",
                "alfabet",
                "arafi mbindu lateŋ",
                "bataaxal",
                "lateŋ",
                "mbind",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("fakela oonobumba besilatin"),
            keywords: &[
                "abc",
                "fakela oonobumba besilatin",
                "isilatin",
                "oonobumba",
                "ungeniso",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ṣafikun awọn lẹta latini"),
            keywords: &[
                "abc",
                "látíìnì",
                "àgbéwọlé",
                "àwọn lẹ\u{301}tà",
                "álífábẹ\u{301}ẹ\u{300}tì",
                "ṣafikun awọn lẹta latini",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("輸入拉丁字母"),
            keywords: &["abc", "字母", "拉丁", "輸入", "輸入拉丁字母"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("输入拉丁字母"),
            keywords: &["abc", "字母", "拉丁", "输入", "输入拉丁字母"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("输入拉丁字母"),
            keywords: &["abc", "字母", "打字", "拉丁文", "输入拉丁字母"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("拉丁字母鍵"),
            keywords: &["拉丁字母鍵"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("輸入拉丁字母"),
            keywords: &["輸入拉丁字母"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukufaka izinhlamvu zesilatini"),
            keywords: &[
                "abc",
                "alfabhethi",
                "isilatini",
                "izinhlamvu",
                "okufakiwe",
                "ukufaka izinhlamvu zesilatini",
            ],
        },
    ],
};
#[doc = "🅰\u{fe0f}"]
pub const A_BUTTON_BLOOD_TYPE: crate::Emoji = crate::Emoji {
    glyph: "🅰\u{fe0f}",
    codepoint: "1F170 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "A button (blood type)",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🅰",
        codepoint: "1F170",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "A button (blood type)",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("A-knopie (bloedgroep)"),
            keywords: &["A", "A-knopie (bloedgroep)", "bloedgroep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤ አዝራር"),
            keywords: &["ኤ አዝራር", "ደም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر A"),
            keywords: &["إيه", "زر A", "فصيلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("A ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)"),
            keywords: &[
                "A ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)",
                "a",
                "ৰক\u{9cd}ত-বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("a düyməsi"),
            keywords: &["a", "a düyməsi", "qan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("значок «група крыві A»"),
            keywords: &["A", "група", "другая", "значок «група крыві A»", "кроў"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бутон с „a“"),
            keywords: &["[a]", "бутон с „a“", "кръв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("এ বোত\u{9be}ম"),
            keywords: &["এ", "এ বোত\u{9be}ম", "রক\u{9cd}ত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton A (rumm-gwad)"),
            keywords: &["A", "a", "bouton A", "bouton A (rumm-gwad)", "rumm-gwad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("a tipka"),
            keywords: &["a", "a tipka", "krvna grupa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó A (grup sanguini)"),
            keywords: &["A", "botó", "botó A (grup sanguini)"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("A ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)"),
            keywords: &["A ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)", "a", "ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek A (krevní skupina)"),
            keywords: &["a", "krev", "štítek A (krevní skupina)"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm A (grwp gwaed)"),
            keywords: &["a", "botwm A (grwp gwaed)", "gwaed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blodtype A"),
            keywords: &["A", "blod", "blodtype", "type A"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstabe A in rotem Quadrat"),
            keywords: &[
                "Blut",
                "Blutgruppe",
                "Großbuchstabe A in rotem Quadrat",
                "a",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstabe A in Quadrat"),
            keywords: &[
                "Blut",
                "Blutgruppe",
                "Grossbuchstabe A in Quadrat",
                "a",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί Α (ομάδα αίματος)"),
            keywords: &["a", "κουμπί Α (ομάδα αίματος)", "ομάδα αίματος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("A button (blood type)"),
            keywords: &["A button (blood type)", "a", "blood type"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("grupo sanguíneo A"),
            keywords: &["A", "grupo", "sanguíneo", "tipo A"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp A (veregrupp)"),
            keywords: &["a", "nupp A (veregrupp)", "veri"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("a botoia"),
            keywords: &["a", "a botoia", "odol"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه آ (گروه خونی)"),
            keywords: &["آ", "دکمه آ (گروه خونی)", "گروه خونی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("A-veriryhmä"),
            keywords: &["A-veriryhmä", "a", "veriryhmä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na A"),
            keywords: &["a", "button na A", "dugo", "pindutan", "uri"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("A knappur (blóðflokkur)"),
            keywords: &[
                "A knappur (blóðflokkur)",
                "a",
                "blóðflokkur",
                "blóðtypa",
                "knappur",
                "knøttur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("groupe sanguin A"),
            keywords: &["A", "groupe sanguin", "groupe sanguin A"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["A", "groupe sanguin", "groupe sanguin A"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fuilghrúpa A"),
            keywords: &["A", "fuil", "fuilghrúpa", "grúpa A"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan A (seòrsa fala)"),
            keywords: &["a", "fuil", "putan A (seòrsa fala)", "seòrsa fala"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("grupo sanguíneo A"),
            keywords: &["A", "grupo", "sanguíneo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોહીનો પ\u{acd}રકાર A"),
            keywords: &[
                "A",
                "પ\u{acd}રકાર A",
                "લોહી",
                "લોહીનો પ\u{acd}રકાર",
                "લોહીનો પ\u{acd}રકાર A",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin A (irin jini)"),
            keywords: &["a", "irin jini", "maɓallin A (irin jini)"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן A (סוג דם)"),
            keywords: &["a", "לחצן A (סוג דם)", "סוג דם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("A बटन (ख\u{942}न का प\u{94d}रकार)"),
            keywords: &[
                "A बटन (ख\u{942}न का प\u{94d}रकार)",
                "ए",
                "ए बटन",
                "ख\u{942}न",
                "प\u{94d}रकार ए",
                "रक\u{94d}त प\u{94d}रकार",
                "रक\u{94d}त प\u{94d}रकार ए",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka krvne grupe A"),
            keywords: &["a", "krv", "tipka krvne grupe A"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("A gomb (vércsoport)"),
            keywords: &["A gomb (vércsoport)", "a", "vércsoport"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էյ կոճակ"),
            keywords: &["a", "արյուն", "էյ կոճակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol A (golongan darah)"),
            keywords: &[
                "a",
                "golongan darah",
                "tombol A (golongan darah)",
                "tombol a (golongan darah)",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi (ụdị ọbara)"),
            keywords: &["a", "Ọdụmbi (ụdị ọbara)", "ụdị ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("A-blóðflokkur"),
            keywords: &["A", "A-blóðflokkur", "blóð", "blóðflokkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gruppo sanguigno A"),
            keywords: &["gruppo A", "gruppo sanguigno A"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("血液型A型"),
            keywords: &["A型", "血液型", "血液型A型"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol A [golongane getih]"),
            keywords: &["a", "golongane getih", "tombol A [golongane getih]"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი A (სისხლის ტიპი)"),
            keywords: &["a", "სისხლი", "ღილაკი A (სისხლის ტიპი)"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("А түймесі (қызыл түсті)"),
            keywords: &["А түймесі (қызыл түсті)", "а", "қызыл түсті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blodtype A"),
            keywords: &["A", "blod", "blodtype", "type A"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងអក\u{17d2}សរ A (ប\u{17d2}រភេទឈាម)"),
            keywords: &[
                "a",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងអក\u{17d2}សរ A (ប\u{17d2}រភេទឈាម)",
                "ប\u{17d2}រភេទឈាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎ ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ವ\u{cbf}ಧ)"),
            keywords: &[
                "ಎ ಬಟನ\u{ccd}",
                "ಎ ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ವ\u{cbf}ಧ)",
                "ಒಂದು ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ)",
                "ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("에이형"),
            keywords: &["A", "에이형", "혈액형 에이형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("A बटण (रक\u{94d}ताचो गट)"),
            keywords: &["A बटण (रक\u{94d}ताचो गट)", "a", "रक\u{94d}ताचो गट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("а баскычы"),
            keywords: &["а", "а баскычы", "кызыл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("A-Knäppchen (Bluttgrupp)"),
            keywords: &["A", "A-Knäppchen (Bluttgrupp)", "Bluttgrupp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມ A"),
            keywords: &["ປ\u{eb8}\u{ec8}ມ A", "ເລ\u{eb7}ອດ", "ເອ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mygtukas „A“ (raudona)"),
            keywords: &["a", "mygtukas „A“ (raudona)", "raudona"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("A poga (asinsgrupa)"),
            keywords: &["A", "A poga (asinsgrupa)", "asinsgrupa", "poga A"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene A (momo toto)"),
            keywords: &["a", "momo toto", "pātene A (momo toto)"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче А (крвна група)"),
            keywords: &["А", "група", "копче А (крвна група)", "крв"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("A രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം"),
            keywords: &[
                "A രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം",
                "ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} എ",
                "ചിഹ\u{d4d}നം",
                "ബ\u{d4d}ലഡ\u{d4d} ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} എ",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d}",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} A",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("А товчлуур (цусны бүлэг)"),
            keywords: &["А товчлуур (цусны бүлэг)", "а", "цусны бүлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("a बटण"),
            keywords: &[
                "A बटण (रक\u{94d}ताचा प\u{94d}रकार)",
                "a",
                "a बटण",
                "रक\u{94d}ताचा प\u{94d}रकार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang A (jenis darah)"),
            keywords: &["a", "butang A (jenis darah)", "darah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna A (tip tad-demm)"),
            keywords: &["a", "buttuna A (tip tad-demm)", "tip tad-demm"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အေ သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)"),
            keywords: &[
                "ဘ\u{102e}",
                "ဘ\u{102e} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
                "သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား",
                "အေ သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("A-knapp (blodtype)"),
            keywords: &["A", "A-knapp (blodtype)", "blod", "blodtype", "type A"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ए बटन"),
            keywords: &["ए", "ए बटन", "रगत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bloedgroep A"),
            keywords: &["a", "bloedgroep", "bloedgroep A"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("A-knapp (blodtype)"),
            keywords: &["A", "A-knapp (blodtype)", "blod", "blodtype", "type A"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("A ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)"),
            keywords: &[
                "A ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)",
                "a",
                "ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("A ਬਟਨ (ਖ\u{a42}ਨ ਦੀ ਕਿਸਮ)"),
            keywords: &[
                "A",
                "A ਬਟਨ (ਖ\u{a42}ਨ ਦੀ ਕਿਸਮ)",
                "ਕਿਸਮ A",
                "ਖ\u{a42}ਨ",
                "ਖ\u{a42}ਨ ਕਿਸਮ",
                "ਖ\u{a42}ਨ ਕਿਸਮ A",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("A دا بٹن (خون دی قسم)"),
            keywords: &["A دا بٹن (خون دی قسم)", "a", "خون دی ق\u{650}سم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("A Bọ\u{301}tin (Blọ\u{301}d Taip)"),
            keywords: &["A Bọ\u{301}tin (Blọ\u{301}d Taip)", "a"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("grupa krwi A"),
            keywords: &["A", "grupa A", "grupa krwi A", "krew"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("A بټن (د وینې ډول)"),
            keywords: &["A بټن (د وینې ډول)", "a", "د وينې ډول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão A (tipo sanguíneo)"),
            keywords: &[
                "A",
                "botão A (tipo sanguíneo)",
                "sangue",
                "tipo A",
                "tipo sanguíneo",
                "tipo sanguíneo A",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão A (tipo de sangue)"),
            keywords: &["a", "botão A (tipo de sangue)", "sangue"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton A (grupă sanguină)"),
            keywords: &["a", "buton A (grupă sanguină)", "grupă sanguină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-169"),
            keywords: &["E10-169"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("II группа крови"),
            keywords: &[
                "2 группа крови",
                "II группа крови",
                "вторая группа крови",
                "группа крови",
                "кровь",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya A (ubwoko bw’amaraso)"),
            keywords: &["buto ya A (ubwoko bw’amaraso)", "ubwoko bw’amaraso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("A بٽڻ ( رت جو قسم)"),
            keywords: &["A بٽڻ ( رت جو قسم)", "a", "رت جو قسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("a බොත\u{dca}තම"),
            keywords: &["a", "a බොත\u{dca}තම", "ර\u{dd4}ධ\u{dd2}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok A"),
            keywords: &["a", "krv", "štítok A"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s črko a (krvna skupina)"),
            keywords: &["a", "gumb s črko a (krvna skupina)", "kri"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhan (nooca dhiigga)"),
            keywords: &["a", "badhan (nooca dhiigga)", "nooca dhiigga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «A»"),
            keywords: &["a", "butoni «A»", "grup gjaku"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме са словом а"),
            keywords: &[
                "a",
                "дугме са словом A (крвна група)",
                "дугме са словом а",
                "крвна група",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дугме са словом а"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme sa slovom a"),
            keywords: &[
                "a",
                "dugme sa slovom A (krvna grupa)",
                "dugme sa slovom a",
                "krvna grupa",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dugme sa slovom a"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blodgrupp A"),
            keywords: &["blodgrupp A", "typ A"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye herufi A"),
            keywords: &["a", "damu", "kitufe chenye herufi A"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரத\u{bcd}த வகை A"),
            keywords: &["A குரூப\u{bcd}", "இரத\u{bcd}த வகை", "இரத\u{bcd}த வகை A"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎ బటన\u{c4d} (రక\u{c4d}తం రకం)"),
            keywords: &["అక\u{c4d}షరం", "ఎ", "ఎ బటన\u{c4d} (రక\u{c4d}తం రకం)"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"А\" (гуруҳи хун)"),
            keywords: &["а", "гуруҳи хун", "тугмаи \"А\" (гуруҳи хун)"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เล\u{e37}อดกร\u{e38}\u{e4a}ปเอ"),
            keywords: &[
                "กร\u{e38}\u{e4a}ปเล\u{e37}อด",
                "กร\u{e38}\u{e4a}ปเอ",
                "เล\u{e37}อดกร\u{e38}\u{e4a}ปเอ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("A መልጎም (ዓይነት ደም)"),
            keywords: &["A መልጎም (ዓይነት ደም)", "a", "ዓይነት ደም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("A düwmesi (gan topary)"),
            keywords: &["A düwmesi (gan topary)", "a", "gan topary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi faʻahinga toto A"),
            keywords: &[
                "A",
                "faʻahinga toto",
                "meʻalolomi",
                "meʻalolomi faʻahinga toto A",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("A düğmesi (kan grubu)"),
            keywords: &[
                "A",
                "A düğmesi (kan grubu)",
                "A grubu kan",
                "kan",
                "kan grubu",
                "kan grubu A",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("A كۇنۇپكىسى (قان تىپى)"),
            keywords: &["A كۇنۇپكىسى (قان تىپى)", "a", "قان تىپى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка A (IІ група крові)"),
            keywords: &[
                "1",
                "a",
                "i",
                "кнопка A (IІ група крові)",
                "кнопка «група крові а»",
                "кров",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("A بٹن (خون کی قسم)"),
            keywords: &["A بٹن (خون کی قسم)", "اے", "خون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("a tugmasi"),
            keywords: &["a", "a tugmasi", "qon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút A (nhóm máu)"),
            keywords: &["a", "nhóm máu", "nút A (nhóm máu)"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu A (xeetu deret)"),
            keywords: &["a", "bitoŋu A (xeetu deret)", "xeet deret"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi A (uhlobo lwegazi)"),
            keywords: &["a", "iqhosha elithi A (uhlobo lwegazi)", "uhlobo lwegazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọ\u{301}tìnì A (irúfé\u{329} ẹ\u{300}jẹ\u{300})"),
            keywords: &[
                "Bọ\u{301}tìnì A (irúfé\u{329} ẹ\u{300}jẹ\u{300})",
                "a",
                "irúfẹ\u{301} ẹ\u{300}jẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("A 按鈕 (血型)"),
            keywords: &["A 按鈕 (血型)", "a", "血型"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("A 按钮 (血型)"),
            keywords: &["A 按钮 (血型)", "a", "血型"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("A型血"),
            keywords: &["A型血", "a", "按钮", "血液"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("A型"),
            keywords: &["A型", "血型"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("A 型血"),
            keywords: &["A 型血", "血型"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ka-a"),
            keywords: &["a", "igazi", "inkinobho ka-a"],
        },
    ],
};
#[doc = "🆎"]
pub const AB_BUTTON_BLOOD_TYPE: crate::Emoji = crate::Emoji {
    glyph: "🆎",
    codepoint: "1F18E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "AB button (blood type)",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("AB-knopie (bloedgroep)"),
            keywords: &["AB", "AB-knopie (bloedgroep)", "bloedgroep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤቢ አዝራር"),
            keywords: &["ኤቢ አዝራር", "ደም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر AB (فئة الدم)"),
            keywords: &["إيه بي", "زر AB (فئة الدم)", "فصيلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("AB ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)"),
            keywords: &[
                "AB",
                "AB ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)",
                "ৰক\u{9cd}ত-বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ab düyməsi"),
            keywords: &["ab", "ab düyməsi", "qan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("AB (група крыві)"),
            keywords: &["AB", "AB (група крыві)", "група", "кроў", "чацвёртая"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бутон с „ab“"),
            keywords: &["[ab]", "бутон с „ab“", "кръв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("এ বি বোত\u{9be}ম"),
            keywords: &["এ বি বোত\u{9be}ম", "এবি", "রক\u{9cd}ত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton AB (rumm-gwad)"),
            keywords: &[
                "AB",
                "ab",
                "bouton AB",
                "bouton AB (rumm-gwad)",
                "rumm-gwad",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ab tipka"),
            keywords: &["ab", "ab tipka", "krvna grupa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó AB (grup sanguini)"),
            keywords: &["AB", "botó", "botó AB (grup sanguini)"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("AB ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)"),
            keywords: &["AB ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)", "ab", "ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek AB (krevní skupina)"),
            keywords: &["ab", "krev", "štítek AB (krevní skupina)"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm AB (grwp gwaed)"),
            keywords: &["ab", "botwm AB (grwp gwaed)", "gwaed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blodtype AB"),
            keywords: &["AB", "blod", "blodtype", "type AB"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstaben AB in rotem Quadrat"),
            keywords: &[
                "Blut",
                "Blutgruppe",
                "Großbuchstaben AB in rotem Quadrat",
                "ab",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstaben AB in rotem Quadrat"),
            keywords: &[
                "Blut",
                "Blutgruppe",
                "Grossbuchstaben AB in rotem Quadrat",
                "ab",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί ΑΒ (ομάδα αίματος)"),
            keywords: &["ab", "κουμπί ΑΒ (ομάδα αίματος)", "ομάδα αίματος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("AB button (blood type)"),
            keywords: &["AB button (blood type)", "ab", "blood type"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("grupo sanguíneo AB"),
            keywords: &["AB", "grupo", "sanguíneo", "tipo AB"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp AB (veregrupp)"),
            keywords: &["ab", "nupp AB (veregrupp)", "veri"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ab botoia"),
            keywords: &["ab", "ab botoia", "odol"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه آ ب (گروه خونی)"),
            keywords: &["آ ب", "دکمه آ ب (گروه خونی)", "گروه خونی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("AB-veriryhmä"),
            keywords: &["AB-veriryhmä", "ab", "veriryhmä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na AB"),
            keywords: &["AB", "button na AB", "dugo", "pindutan", "uri"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("AB knappur (blóðflokkur)"),
            keywords: &[
                "AB knappur (blóðflokkur)",
                "ab",
                "blóðflokkur",
                "blóðtypa",
                "knappur",
                "knøttur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("groupe sanguin AB"),
            keywords: &["AB", "groupe sanguin", "groupe sanguin AB"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["AB", "groupe sanguin", "groupe sanguin AB"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fuilghrúpa AB"),
            keywords: &["AB", "fuil", "fuilghrúpa", "grúpa AB"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan AB (seòrsa fala)"),
            keywords: &["ab", "fuil", "putan AB (seòrsa fala)", "seòrsa fala"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("grupo sanguíneo AB"),
            keywords: &["AB", "grupo", "sanguíneo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોહીનો પ\u{acd}રકાર AB"),
            keywords: &[
                "AB",
                "પ\u{acd}રકાર AB",
                "લોહી",
                "લોહીનો પ\u{acd}રકાર",
                "લોહીનો પ\u{acd}રકાર AB",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin AB (irin jini)"),
            keywords: &["ab", "irin jini", "maɓallin AB (irin jini)"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן AB (סוג דם)"),
            keywords: &["ab", "לחצן AB (סוג דם)", "סוג דם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("AB बटन (ख\u{942}न का प\u{94d}रकार)"),
            keywords: &[
                "AB",
                "AB बटन (ख\u{942}न का प\u{94d}रकार)",
                "ab",
                "एबी",
                "एबी बटन",
                "ख\u{942}न",
                "प\u{94d}रकार एबी",
                "रक\u{94d}त प\u{94d}रकार",
                "रक\u{94d}त प\u{94d}रकार एबी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka krvne grupe AB"),
            keywords: &["ab", "krv", "tipka krvne grupe AB"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("AB gomb (vércsoport)"),
            keywords: &["AB gomb (vércsoport)", "ab", "vércsoport"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էյ-բի կոճակ"),
            keywords: &["ab", "արյուն", "էյ-բի կոճակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol AB (golongan darah)"),
            keywords: &[
                "ab",
                "golongan darah",
                "tombol AB (golongan darah)",
                "tombol ab (golongan darah)",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi AB (ụdị ọbara)"),
            keywords: &["ab", "Ọdụmbi AB (ụdị ọbara)", "ụdị ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("AB-blóðflokkur"),
            keywords: &["AB", "AB-blóðflokkur", "blóð", "blóðflokkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gruppo sanguigno AB"),
            keywords: &["gruppo AB", "gruppo sanguigno AB"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("血液型AB型"),
            keywords: &["AB型", "血液型", "血液型AB型"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol AB [golongane getih]"),
            keywords: &["ab", "golongane getih", "tombol AB [golongane getih]"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი AB (სისხლის ტიპი)"),
            keywords: &["ab", "სისხლი", "ღილაკი AB (სისხლის ტიპი)"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("AB түймесі (қызыл түсті)"),
            keywords: &["AB түймесі (қызыл түсті)", "ab", "қызыл түсті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blodtype AB"),
            keywords: &["AB", "blod", "blodtype", "type AB"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងអក\u{17d2}សរ AB (ប\u{17d2}រភេទឈាម)"),
            keywords: &[
                "ab",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងអក\u{17d2}សរ AB (ប\u{17d2}រភេទឈាម)",
                "ប\u{17d2}រភេទឈាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಬ\u{cbf} ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ)"),
            keywords: &[
                "ಎಬ\u{cbf}",
                "ಎಬ\u{cbf} ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ)",
                "ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("에이비형"),
            keywords: &["AB", "에이비형", "혈액형 에이비형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("AB बटण (रक\u{94d}ताचो गट)"),
            keywords: &["AB बटण (रक\u{94d}ताचो गट)", "ab", "रक\u{94d}ताचो गट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аб баскычы"),
            keywords: &["аб", "аб баскычы", "кызыл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("AB-Knäppchen (Bluttgrupp)"),
            keywords: &["AB", "AB-Knäppchen (Bluttgrupp)", "Bluttgrupp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມ AB"),
            keywords: &["ປ\u{eb8}\u{ec8}ມ AB", "ເລ\u{eb7}ອດ", "ເອບ\u{eb5}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mygtukas „AB“ (raudona)"),
            keywords: &["ab", "mygtukas „AB“ (raudona)", "raudona"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("AB poga (asinsgrupa)"),
            keywords: &["AB", "AB poga (asinsgrupa)", "asinsgrupa", "poga AB"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene AB (momo toto)"),
            keywords: &["ab", "momo toto", "pātene AB (momo toto)"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче АБ (крвна група)"),
            keywords: &["АБ", "група", "копче АБ (крвна група)", "крв"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("AB രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം"),
            keywords: &[
                "AB രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം",
                "ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} എ",
                "ചിഹ\u{d4d}നം",
                "ബ\u{d4d}ലഡ\u{d4d} ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} എബി",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d}",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} AB",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("AB товчлуур (цусны бүлэг)"),
            keywords: &["AB товчлуур (цусны бүлэг)", "ab", "цусны бүлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ab बटण"),
            keywords: &[
                "AB बटण (रक\u{94d}ताचा प\u{94d}रकार)",
                "ab",
                "ab बटण",
                "रक\u{94d}ताचा प\u{94d}रकार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang AB (jenis darah)"),
            keywords: &["ab", "butang AB (jenis darah)", "darah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna AB (tip tad-demm)"),
            keywords: &["ab", "buttuna AB (tip tad-demm)", "tip tad-demm"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အေဘ\u{102e} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)"),
            keywords: &[
                "သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား",
                "အေဘ\u{102e} (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
                "အေဘ\u{102e} သင\u{103a}\u{1039}ကေတ",
                "အေဘ\u{102e} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("AB-knapp (blodtype)"),
            keywords: &["AB", "AB-knapp (blodtype)", "blod", "blodtype", "type AB"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एबी बटन"),
            keywords: &["एबी", "एबी बटन", "रगत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bloedgroep AB"),
            keywords: &["ab", "bloedgroep", "bloedgroep AB"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("AB-knapp (blodtype)"),
            keywords: &["AB", "AB-knapp (blodtype)", "blod", "blodtype", "type AB"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("AB ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)"),
            keywords: &[
                "AB ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)",
                "ab",
                "ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("AB ਬਟਨ"),
            keywords: &[
                "AB",
                "AB ਬਟਨ",
                "ਕਿਸਮ AB",
                "ਖ\u{a42}ਨ",
                "ਖ\u{a42}ਨ ਕਿਸਮ",
                "ਖ\u{a42}ਨ ਕਿਸਮ AB",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("AB بٹن (خون دی قسم)"),
            keywords: &["AB بٹن (خون دی قسم)", "ab", "خون دی ق\u{650}سم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("AB Bọ\u{301}tin (Blọ\u{301}d Taip)"),
            keywords: &[
                "AB Bọ\u{301}tin (Blọ\u{301}d Taip)",
                "Blọ\u{301}d Taip",
                "ab",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("grupa krwi AB"),
            keywords: &["AB", "grupa AB", "grupa krwi AB", "krew"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("AB بټن (د وینې ډول)"),
            keywords: &["AB بټن (د وینې ډول)", "ای بي", "د وينې ډول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão AB (tipo sanguíneo)"),
            keywords: &[
                "AB",
                "botão AB (tipo sanguíneo)",
                "sangue",
                "tipo AB",
                "tipo sanguíneo",
                "tipo sanguíneo AB",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão AB (tipo de sangue)"),
            keywords: &["ab", "botão AB (tipo de sangue)", "sangue"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton AB (grupă sanguină)"),
            keywords: &["ab", "buton AB (grupă sanguină)", "grupă sanguină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-173"),
            keywords: &["E10-173"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("IV группа крови"),
            keywords: &[
                "4 группа крови",
                "IV группа крови",
                "группа крови",
                "кровь",
                "четвертая группа крови",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya AB (ubwoko bw’amaraso)"),
            keywords: &["ab", "buto ya AB (ubwoko bw’amaraso)", "ubwoko bw’amaraso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("AB بٽڻ (رت جو قسم)"),
            keywords: &["AB بٽڻ (رت جو قسم)", "ab", "رت جو قسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ab බොත\u{dca}තම"),
            keywords: &["ab", "ab බොත\u{dca}තම", "ර\u{dd4}ධ\u{dd2}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok AB"),
            keywords: &["ab", "krv", "štítok AB"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb AB (krvna skupina)"),
            keywords: &["ab", "gumb AB (krvna skupina)", "kri"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("AB badhan (nooca dhiigga)"),
            keywords: &["AB badhan (nooca dhiigga)", "ab", "nooca dhiigga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «AB»"),
            keywords: &["ab", "butoni «AB»", "grup gjaku"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме са словима а и б"),
            keywords: &[
                "aб",
                "дугме са словима A и Б (крвна група)",
                "дугме са словима а и б",
                "крвна група",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дугме са словима а и б"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme sa slovima a i b"),
            keywords: &[
                "ab",
                "dugme sa slovima A i B (krvna grupa)",
                "dugme sa slovima a i b",
                "krvna grupa",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dugme sa slovima a i b"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blodgrupp AB"),
            keywords: &["blodgrupp AB", "typ AB"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye herufi AB"),
            keywords: &["ab", "damu", "kitufe chenye herufi AB"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரத\u{bcd}த வகை AB"),
            keywords: &["AB குரூப\u{bcd}", "இரத\u{bcd}த வகை", "இரத\u{bcd}த வகை AB"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎబ\u{c3f} బటన\u{c4d} (రక\u{c4d}తం రకం)"),
            keywords: &[
                "అక\u{c4d}షరం",
                "ఎబ\u{c3f}",
                "ఎబ\u{c3f} బటన\u{c4d} (రక\u{c4d}తం రకం)",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"АВ\" (гуруҳи хун)"),
            keywords: &["аb", "гуруҳи хун", "тугмаи \"АВ\" (гуруҳи хун)"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เล\u{e37}อดกร\u{e38}\u{e4a}ปเอบ\u{e35}"),
            keywords: &[
                "กร\u{e38}\u{e4a}ปเล\u{e37}อด",
                "กร\u{e38}\u{e4a}ปเล\u{e37}อดเอบ\u{e35}",
                "กร\u{e38}\u{e4a}ปเอบ\u{e35}",
                "เล\u{e37}อดกร\u{e38}\u{e4a}ปเอบ\u{e35}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("AB መልጎም (ዓይነት ደም)"),
            keywords: &["AB መልጎም (ዓይነት ደም)", "ab", "ዓይነት ደም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("AB düwmesi (gan topary)"),
            keywords: &["AB düwmesi (gan topary)", "ab", "gan topary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi faʻahinga toto AB"),
            keywords: &[
                "AB",
                "faʻahinga toto",
                "meʻalolomi",
                "meʻalolomi faʻahinga toto AB",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("AB düğmesi (kan grubu)"),
            keywords: &[
                "AB",
                "AB düğmesi (kan grubu)",
                "AB grubu kan",
                "kan",
                "kan grubu",
                "kan grubu AB",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("AB كۇنۇپكىسى (قان تىپى)"),
            keywords: &["AB كۇنۇپكىسى (قان تىپى)", "ab", "قان تىپى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка AB (IV група крові)"),
            keywords: &[
                "3",
                "ab",
                "iii",
                "кнопка AB (IV група крові)",
                "кнопка «група крові ab»",
                "кров",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("AB بٹن (خون کی قسم)"),
            keywords: &["AB بٹن (خون کی قسم)", "اے بی", "خون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ab tugmasi"),
            keywords: &["ab", "ab tugmasi", "qon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút AB (nhóm máu)"),
            keywords: &["ab", "nhóm máu", "nút AB (nhóm máu)"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu AB (xeetu deret)"),
            keywords: &["ab", "bitoŋu AB (xeetu deret)", "xeetu deret"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi AB (uhlobo lwegazi)"),
            keywords: &["ab", "iqhosha elithi AB (uhlobo lwegazi)", "uhlobo lwegazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini AB (irufẹ ẹjẹ)"),
            keywords: &[
                "Bọtini AB (irufẹ ẹjẹ)",
                "ab",
                "irúfé\u{329} ẹ\u{300}jẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("AB 按鈕 (血型)"),
            keywords: &["AB 按鈕 (血型)", "ab", "血型"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("AB 按钮 (血型)"),
            keywords: &["AB 按钮 (血型)", "ab", "血型"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("AB型血"),
            keywords: &["AB型血", "ab", "按钮", "血液"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("AB型"),
            keywords: &["AB型", "血型"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("AB 型血"),
            keywords: &["AB 型血", "血型"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ka-ab"),
            keywords: &["ab", "igazi", "inkinobho ka-ab"],
        },
    ],
};
#[doc = "🅱\u{fe0f}"]
pub const B_BUTTON_BLOOD_TYPE: crate::Emoji = crate::Emoji {
    glyph: "🅱\u{fe0f}",
    codepoint: "1F171 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "B button (blood type)",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🅱",
        codepoint: "1F171",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "B button (blood type)",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("B-knopie (bloedgroep)"),
            keywords: &["B", "B-knopie (bloedgroep)", "bloedgroep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቢ አዝራር"),
            keywords: &["ቢ አዝራር", "ደም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر B"),
            keywords: &["بي", "زر B", "فصيلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("B ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)"),
            keywords: &[
                "B ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)",
                "b",
                "ৰক\u{9cd}ত-বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("b düyməsi"),
            keywords: &["b", "b düyməsi", "qan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("значок «група крыві B»"),
            keywords: &["B", "група", "значок «група крыві B»", "кроў", "трэцяя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бутон с „b“"),
            keywords: &["[b]", "бутон с „b“", "кръв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বি বোত\u{9be}ম"),
            keywords: &["বি", "বি বোত\u{9be}ম", "রক\u{9cd}ত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton B (rumm-gwad)"),
            keywords: &["B", "b", "bouton B", "bouton B (rumm-gwad)", "rumm-gwad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("b tipka"),
            keywords: &["b", "b tipka", "krvna grupa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó B (grup sanguini)"),
            keywords: &["B", "botó", "botó B (grup sanguini)"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("B ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)"),
            keywords: &[
                "B ᎦᏗ ( ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)",
                "B ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)",
                "b",
                "ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ",
                "Ᏼ ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek B (krevní skupina)"),
            keywords: &["b", "krev", "štítek B (krevní skupina)"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm B (grwp gwaed)"),
            keywords: &["b", "botwm B (grwp gwaed)", "gwaed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blodtype B"),
            keywords: &["B", "blod", "blodtype", "type B"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstabe B in rotem Quadrat"),
            keywords: &[
                "Blut",
                "Blutgruppe",
                "Großbuchstabe B in rotem Quadrat",
                "b",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstabe B in Quadrat"),
            keywords: &[
                "Blut",
                "Blutgruppe",
                "Grossbuchstabe B in Quadrat",
                "b",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί Β (ομάδα αίματος)"),
            keywords: &["b", "κουμπί Β (ομάδα αίματος)", "ομάδα αίματος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("B button (blood type)"),
            keywords: &["B button (blood type)", "b", "blood type"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("grupo sanguíneo B"),
            keywords: &["B", "grupo", "sanguíneo", "tipo B"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp B (veregrupp)"),
            keywords: &["b", "nupp B (veregrupp)", "veri"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("b botoia"),
            keywords: &["b", "b botoia", "odol"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه ب (گروه خونی)"),
            keywords: &["ب", "دکمه ب (گروه خونی)", "گروه خونی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("B-veriryhmä"),
            keywords: &["B-veriryhmä", "b", "veriryhmä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na B"),
            keywords: &["B", "b", "button na B", "dugo", "pindutan", "uri"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("B knappur (blóðflokkur)"),
            keywords: &[
                "B knappur (blóðflokkur)",
                "b",
                "blóðflokkur",
                "blóðtypa",
                "knappur",
                "knøttur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("groupe sanguin B"),
            keywords: &["B", "groupe sanguin", "groupe sanguin B"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["B", "groupe sanguin", "groupe sanguin B"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fuilghrúpa B"),
            keywords: &["B", "fuil", "fuilghrúpa", "grúpa B"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Putan B (seòrsa fala)"),
            keywords: &["Putan B (seòrsa fala)", "b", "fuil", "seòrsa fala"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("grupo sanguíneo B"),
            keywords: &["B", "grupo", "sanguíneo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોહીનો પ\u{acd}રકાર B"),
            keywords: &[
                "B",
                "પ\u{acd}રકાર B",
                "લોહી",
                "લોહીનો પ\u{acd}રકાર",
                "લોહીનો પ\u{acd}રકાર B",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin B (irin jini)"),
            keywords: &["b", "irin jini", "maɓallin B (irin jini)"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן B (סוג דם)"),
            keywords: &["b", "לחצן B (סוג דם)", "סוג דם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("B बटन (रक\u{94d}त प\u{94d}रकार)"),
            keywords: &[
                "B",
                "B बटन (रक\u{94d}त प\u{94d}रकार)",
                "ख\u{942}न",
                "प\u{94d}रकार बी",
                "बी",
                "बी बटन",
                "रक\u{94d}त प\u{94d}रकार",
                "रक\u{94d}त प\u{94d}रकार बी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka krvne grupe B"),
            keywords: &["b", "krv", "tipka krvne grupe B"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("B gomb (vércsoport)"),
            keywords: &["B gomb (vércsoport)", "b", "vércsoport"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բի կոճակ"),
            keywords: &["b", "արյուն", "բի կոճակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol B (golongan darah)"),
            keywords: &[
                "b",
                "golongan darah",
                "tombol B (golongan darah)",
                "tombol b (golongan darah)",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi B (ụdị ọbara)"),
            keywords: &["b", "Ọdụmbi B (ụdị ọbara)", "ụdị ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("B-blóðflokkur"),
            keywords: &["B", "B-blóðflokkur", "blóð", "blóðflokkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gruppo sanguigno B"),
            keywords: &["gruppo B", "gruppo sanguigno B"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("血液型B型"),
            keywords: &["B型", "血液型", "血液型B型"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol B [golongane getih]"),
            keywords: &["b", "golongane getih", "tombol B [golongane getih]"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი B (სისხლის ტიპი)"),
            keywords: &["b", "სისხლი", "ღილაკი B (სისხლის ტიპი)"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("B түймесі (қызыл түсті)"),
            keywords: &["B түймесі (қызыл түсті)", "b", "қызыл түсті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blodtype B"),
            keywords: &["B", "blod", "blodtype", "type B"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងអក\u{17d2}សរ B (ប\u{17d2}រភេទឈាម)"),
            keywords: &[
                "b",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងអក\u{17d2}សរ B (ប\u{17d2}រភេទឈាម)",
                "ប\u{17d2}រភេទឈាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf} ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ)"),
            keywords: &[
                "ಬ\u{cbf}",
                "ಬ\u{cbf} ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ)",
                "ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("비형"),
            keywords: &["B", "비형", "혈액형 비형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("B बटण (रक\u{94d}ताचो गट)"),
            keywords: &["B बटण (रक\u{94d}ताचो गट)", "b", "रक\u{94d}ताचो गट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("б баскычы"),
            keywords: &["б", "б баскычы", "кызыл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("B-Knäppchen (Bluttgrupp)"),
            keywords: &["B", "B-Knäppchen (Bluttgrupp)", "Bluttgrupp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມ B"),
            keywords: &["ບ\u{eb5}", "ປ\u{eb8}\u{ec8}ມ B", "ເລ\u{eb7}ອດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mygtukas „B“ (raudona)"),
            keywords: &["b", "mygtukas „B“ (raudona)", "raudona"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("B poga (asinsgrupa)"),
            keywords: &["B", "B poga (asinsgrupa)", "asinsgrupa", "poga B"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene B (momo toto)"),
            keywords: &["b", "momo toto", "pātene B (momo toto)"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче Б (крвна група)"),
            keywords: &["Б", "група", "копче Б (крвна група)", "крв"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("B രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം"),
            keywords: &[
                "B രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം",
                "ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} എ",
                "ചിഹ\u{d4d}നം",
                "ബ\u{d4d}ലഡ\u{d4d} ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ബി",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d}",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} B",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("B товчлуур (цусны бүлэг)"),
            keywords: &["B товчлуур (цусны бүлэг)", "b", "цусны бүлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("b बटण"),
            keywords: &[
                "B बटण (रक\u{94d}ताचा प\u{94d}रकार)",
                "b",
                "b बटण",
                "रक\u{94d}ताचा प\u{94d}रकार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang B (jenis darah)"),
            keywords: &["b", "butang B (jenis darah)", "darah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna B (tip tad-demm)"),
            keywords: &["b", "buttuna B (tip tad-demm)", "tip tad-demm"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘ\u{102e} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)"),
            keywords: &[
                "ဘ\u{102e}",
                "ဘ\u{102e} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
                "သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("B-knapp (blodtype)"),
            keywords: &["B", "B-knapp (blodtype)", "blod", "blodtype", "type B"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बि बटन"),
            keywords: &["बि", "बि बटन", "रगत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bloedgroep B"),
            keywords: &["b", "bloedgroep", "bloedgroep B"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("B-knapp (blodtype)"),
            keywords: &["B", "B-knapp (blodtype)", "blod", "blodtype", "type B"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("B ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)"),
            keywords: &[
                "B ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)",
                "b",
                "ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("B ਬਟਨ"),
            keywords: &[
                "B",
                "B ਬਟਨ",
                "ਕਿਸਮ B",
                "ਖ\u{a42}ਨ",
                "ਖ\u{a42}ਨ ਕਿਸਮ",
                "ਖ\u{a42}ਨ ਕਿਸਮ B",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("B دا بٹن (خون دی قسم)"),
            keywords: &["B دا بٹن (خون دی قسم)", "b", "خون دی ق\u{650}سم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("B Bọ\u{301}tin (Blọ\u{301}d Taip)"),
            keywords: &["B Bọ\u{301}tin (Blọ\u{301}d Taip)", "Blọ\u{301}d Taip", "b"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("grupa krwi B"),
            keywords: &["B", "grupa B", "grupa krwi B", "krew"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("B بټن (د وینې ډول)"),
            keywords: &["B بټن (د وینې ډول)", "بي", "د وينې ډول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão B (tipo sanguíneo)"),
            keywords: &[
                "B",
                "botão B (tipo sanguíneo)",
                "sangue",
                "tipo B",
                "tipo sanguíneo",
                "tipo sanguíneo B",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão B (tipo de sangue)"),
            keywords: &["b", "blood", "botão B (tipo de sangue)"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton B (grupă sanguină)"),
            keywords: &["b", "buton B (grupă sanguină)", "grupă sanguină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-170"),
            keywords: &["E10-170"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("III группа крови"),
            keywords: &[
                "3 группа крови",
                "III группа крови",
                "группа крови",
                "кровь",
                "третья группа крови",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya B (ubwoko bw’amaraso)"),
            keywords: &["b", "buto ya B (ubwoko bw’amaraso)", "ubwoko bw’amaraso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("B بٽڻ (رت جو قسم)"),
            keywords: &["B بٽڻ (رت جو قسم)", "ab", "رت جو قسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("b බොත\u{dca}තම"),
            keywords: &["b", "b බොත\u{dca}තම", "ර\u{dd4}ධ\u{dd2}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok B"),
            keywords: &["b", "krv", "štítok B"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s črko b (krvna skupina)"),
            keywords: &["b", "gumb s črko b (krvna skupina)", "kri"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("B badhan (nooca dhiigga)"),
            keywords: &["B badhan (nooca dhiigga)", "b", "nooca dhiigga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «B»"),
            keywords: &["b", "butoni «B»", "grup gjaku"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме са словом б"),
            keywords: &[
                "б",
                "дугме са словом Б (крвна група)",
                "дугме са словом б",
                "крвна група",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дугме са словом б"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme sa slovom b"),
            keywords: &[
                "b",
                "dugme sa slovom B (krvna grupa)",
                "dugme sa slovom b",
                "krvna grupa",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dugme sa slovom b"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blodgrupp B"),
            keywords: &["blodgrupp B", "typ B"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye herufi B"),
            keywords: &["b", "damu", "kitufe chenye herufi B"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரத\u{bcd}த வகை B"),
            keywords: &["B குரூப\u{bcd}", "இரத\u{bcd}த வகை", "இரத\u{bcd}த வகை B"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3f} బటన\u{c4d} (రక\u{c4d}తం రకం)"),
            keywords: &[
                "అక\u{c4d}షరం",
                "బ\u{c3f}",
                "బ\u{c3f} బటన\u{c4d} (రక\u{c4d}తం రకం)",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"В\" (гуруҳи хун)"),
            keywords: &["b", "гуруҳи хун", "тугмаи \"В\" (гуруҳи хун)"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เล\u{e37}อดกร\u{e38}\u{e4a}ปบ\u{e35}"),
            keywords: &[
                "กร\u{e38}\u{e4a}ปบ\u{e35}",
                "กร\u{e38}\u{e4a}ปเล\u{e37}อด",
                "เล\u{e37}อดกร\u{e38}\u{e4a}ปบ\u{e35}",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("B መልጎም (ዓይነት ደም)"),
            keywords: &["B መልጎም (ዓይነት ደም)", "b", "ዓይነት ደም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("B düwmesi (gan topary)"),
            keywords: &["B düwmesi (gan topary)", "b", "gan topary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi faʻahinga toto B"),
            keywords: &[
                "B",
                "faʻahinga toto",
                "meʻalolomi",
                "meʻalolomi faʻahinga toto B",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("B grubu (kan grubu)"),
            keywords: &[
                "B",
                "B grubu (kan grubu)",
                "B grubu kan",
                "kan",
                "kan grubu",
                "kan grubu B",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("B كۇنۇپكىسى (قان تىپى)"),
            keywords: &["B كۇنۇپكىسى (قان تىپى)", "b", "قان تىپى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка B (III група крові)"),
            keywords: &[
                "2",
                "b",
                "ii",
                "кнопка B (III група крові)",
                "кнопка «група крові b»",
                "кров",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("B بٹن (خون کی قسم)"),
            keywords: &["B بٹن (خون کی قسم)", "بی", "خون"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("b tugmasi"),
            keywords: &["b", "b tugmasi", "qon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút B (nhóm máu)"),
            keywords: &["b", "nhóm máu", "nút B (nhóm máu)"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu B (xeetu deret)"),
            keywords: &["b", "bitoŋu B (xeetu deret)", "xeetu deret"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi B (uhlobo lwegazi)"),
            keywords: &["b", "iqhosha elithi B (uhlobo lwegazi)", "uhlobo lwegazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọ\u{301}tìnì B(irúfé\u{329} ẹ\u{300}jẹ\u{300})"),
            keywords: &[
                "Bọ\u{301}tìnì B(irúfé\u{329} ẹ\u{300}jẹ\u{300})",
                "b",
                "irúfé\u{329} ẹ\u{300}jẹ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("B 按鈕 (血型)"),
            keywords: &["B 按鈕 (血型)", "b", "血型"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("B 按钮 (血型)"),
            keywords: &["B 按钮 (血型)", "b", "血型"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("B型血"),
            keywords: &["B型血", "b", "按钮", "血液"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("B型"),
            keywords: &["B型", "血型"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("B型血"),
            keywords: &["B型血", "血型"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ka-b"),
            keywords: &["b", "inkinobho ka-b", "uhlobo lwegazi"],
        },
    ],
};
#[doc = "🆑"]
pub const CL_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆑",
    codepoint: "1F191",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "CL button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("CL-knopie"),
            keywords: &["CL", "CL-knopie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መቆጣጠሪያ ካሬ"),
            keywords: &["መቆጣጠሪያ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مسح داخل مربع"),
            keywords: &["مسح", "مسح داخل مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("CL ব\u{9c1}ট\u{9be}ম"),
            keywords: &["CL ব\u{9c1}ট\u{9be}ম", "cl"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat cl düyməsi"),
            keywords: &["cl", "kvadrat cl düyməsi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кнопка «ачысціць»"),
            keywords: &["ачыстка", "кнопка", "кнопка «ачысціць»"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Cl“ в квадрат"),
            keywords: &["cl", "„Cl“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের সি এল"),
            keywords: &["বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের সি এল", "সিএল"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton Diverkañ"),
            keywords: &["CL", "bouton Diverkañ", "cl"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cl kvadrat"),
            keywords: &["cl", "cl kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó CL"),
            keywords: &["CL", "botó CL", "botó esborrar", "esborrar", "quadre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("CL ᎦᏗ"),
            keywords: &["CL ᎦᏗ", "cl", "ᏟᏞ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek CL"),
            keywords: &["cl", "štítek CL"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm CL"),
            keywords: &["botwm CL", "cl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("CL-knap"),
            keywords: &["CL-knap", "CL-tegn", "ryd-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstaben CL in rotem Quadrat"),
            keywords: &["CL", "Großbuchstaben CL in rotem Quadrat"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstaben CL in rotem Quadrat"),
            keywords: &["CL", "Grossbuchstaben CL in rotem Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί CL"),
            keywords: &["cl", "κουμπί CL"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("CL button"),
            keywords: &["CL button", "cl"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("borrar"),
            keywords: &["borrar", "símbolo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("botón CL"),
            keywords: &["CL", "borrar", "borrar recuadrado", "botón CL", "cuadrado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp CL"),
            keywords: &["cl", "nupp CL"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“cl” testua karratu batean"),
            keywords: &["cl", "“cl” testua karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} CL"),
            keywords: &["cl", "دکمه\u{654} CL", "پاک کردن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pyyhi-näppäin"),
            keywords: &["cl", "kumita", "pyyhi", "pyyhi-näppäin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na CL"),
            keywords: &["CL", "button na CL", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("CL knappur"),
            keywords: &["CL knappur", "cl", "knappur", "knøttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Effacer"),
            keywords: &["bouton Effacer", "effacer"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bouton Effacer", "cl", "effacer"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("CL"),
            keywords: &["CL", "comhartha glanta", "glan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan CL"),
            keywords: &["cl", "putan CL"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"borrar\" en inglés"),
            keywords: &[
                "borrado",
                "borrar",
                "botón \"borrar\" en inglés",
                "cl",
                "clear",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાફ કરો"),
            keywords: &["CL", "CL ન\u{ac1}\u{a82} ચિહ\u{acd}ન", "સાફ કરો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin CL"),
            keywords: &["cl", "maɓallin CL"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן CL"),
            keywords: &["cl", "לחצן CL", "לחצן cl", "מחיקה", "מחק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("साफ\u{93c}, क\u{94d}लीयर, साफ\u{93c} चिह\u{94d}न, CL"),
            keywords: &[
                "CL",
                "क\u{94d}लीयर",
                "साफ\u{93c}",
                "साफ\u{93c} चिह\u{94d}न",
                "साफ\u{93c}, क\u{94d}लीयर, साफ\u{93c} चिह\u{94d}न, CL",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka CL"),
            keywords: &["cl", "tipka CL"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("CL gomb"),
            keywords: &["CL gomb", "cl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սի-էլ"),
            keywords: &["cl", "սի-էլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol CL"),
            keywords: &["cl", "tombol CL", "tombol cl"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi CL"),
            keywords: &["cl", "Ọdụmbi CL"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("CL"),
            keywords: &["CL", "CL-skilti", "skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante CL"),
            keywords: &["pulsante CL", "simbolo CL"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("CLマーク"),
            keywords: &["CL", "CLマーク", "クリア"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol CL"),
            keywords: &["busak", "cl", "tombol CL"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი CL"),
            keywords: &["cl", "ღილაკი CL"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("CL түймесі"),
            keywords: &["CL түймесі", "cl"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ryd"),
            keywords: &["CL-tegn", "ryd", "ryd-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ CL ធ\u{17c6}"),
            keywords: &[
                "CL",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ CL ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ಎಲ\u{ccd} ಬಟನ\u{ccd}"),
            keywords: &["ಸ\u{cbf}ಎಲ\u{ccd}", "ಸ\u{cbf}ಎಲ\u{ccd} ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("씨엘"),
            keywords: &["CL", "네모 안에 씨엘", "씨엘", "씨엘 네모 안"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("CL बटण"),
            keywords: &["CL बटण", "cl"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("CL баскычы"),
            keywords: &["CL баскычы", "cl"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("CL-Knäppchen"),
            keywords: &["CL", "CL-Knäppchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມ cl ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມມ\u{ebb}ນທ\u{ebb}ນ"),
            keywords: &[
                "cl",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມ cl ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມມ\u{ebb}ນທ\u{ebb}ນ",
                "ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „CL“"),
            keywords: &["cl", "simbolis „CL“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("poga CL"),
            keywords: &["CL", "notīrīt", "poga CL"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene CL"),
            keywords: &["cl", "pātene CL"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче ЦЛ"),
            keywords: &["исчисти", "копче ЦЛ"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}യ\u{d4d}ച\u{d4d}ച\u{d4d} കളയ\u{d41}ക"),
            keywords: &[
                "CL",
                "ചിഹ\u{d4d}നം",
                "മ\u{d3e}യ\u{d4d}ക\u{d4d}ക\u{d41}ക",
                "മ\u{d3e}യ\u{d4d}ക\u{d4d}കൽ",
                "മ\u{d3e}യ\u{d4d}ച\u{d4d}ച\u{d4d} കളയ\u{d41}ക",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("CL товчлуур"),
            keywords: &["CL товчлуур", "cl"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस साफ"),
            keywords: &["CL बटण", "cl", "चौरस साफ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang CL"),
            keywords: &["butang CL", "cl"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna CL"),
            keywords: &["buttuna CL", "cl"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103e}င\u{103a}းသ\u{103d}ားပြ\u{102e} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "စ\u{102e}အယ\u{103a}လ\u{103a}",
                "စ\u{102e}အယ\u{103a}လ\u{103a} ခလ\u{102f}တ\u{103a}",
                "ရ\u{103e}င\u{103a}းသ\u{103d}ားပြ\u{102e} ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("CL-knapp"),
            keywords: &["CL-knapp", "clear", "slett", "tøm"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड सीएल"),
            keywords: &["सिएल", "स\u{94d}क\u{94d}वायर\u{94d}ड सीएल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("CL-knop"),
            keywords: &["CL-knop", "cl"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("CL-knapp"),
            keywords: &["CL-knapp", "clear", "slett", "tøm"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("CL ବଟନ\u{b4d}\u{200c}"),
            keywords: &["CL ବଟନ\u{b4d}\u{200c}", "cl"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("CL ਬਟਨ"),
            keywords: &[
                "CL",
                "CL ਨਿਸ\u{a3c}ਾਨ",
                "CL ਬਟਨ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸਾਫ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("CL بٹن"),
            keywords: &["CL بٹن", "cl"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("CL Bọ\u{301}tin"),
            keywords: &["CL Bọ\u{301}tin", "cl"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk CL"),
            keywords: &["przycisk CL", "znak CL"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سي ايل بټن"),
            keywords: &["سي ايل", "سي ايل بټن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão CL"),
            keywords: &["botão CL", "cl"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão CL"),
            keywords: &["botão CL", "cl"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton CL"),
            keywords: &["buton CL", "cl"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-174"),
            keywords: &["E10-174"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кнопка «очистить»"),
            keywords: &[
                "кнопка",
                "кнопка \"очистить\"",
                "кнопка \"стереть\"",
                "кнопка «очистить»",
                "очистить",
                "стереть",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya CL"),
            keywords: &["buto ya CL", "cl"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("CL بٽڻ"),
            keywords: &["CL بٽڻ", "cl"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("CL බොත\u{dca}තම"),
            keywords: &["CL බොත\u{dca}තම", "cl"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok CL"),
            keywords: &["cl", "štítok CL"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb CL"),
            keywords: &["cl", "gumb CL"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhan CL"),
            keywords: &["badhan CL", "cl"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «CL»"),
            keywords: &["butoni i pastrimit", "butoni «CL»", "cl"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме CL"),
            keywords: &["cl", "дугме CL"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme CL"),
            keywords: &["cl", "dugme CL"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rensa-symbol"),
            keywords: &["CL-symbol", "redo", "rensa-symbol", "renssymbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye herufi CL"),
            keywords: &["cl", "kitufe chenye herufi CL"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிஎல\u{bcd}"),
            keywords: &["சிஎல\u{bcd}", "சிஎல\u{bcd} பட\u{bcd}டன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ల\u{c3f}యర\u{c4d} బటన\u{c4d}"),
            keywords: &[
                "క\u{c4d}ల\u{c3f}యర\u{c4d}",
                "క\u{c4d}ల\u{c3f}యర\u{c4d} బటన\u{c4d}",
                "గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"CL\""),
            keywords: &["cl", "тугмаи \"CL\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ลบข\u{e49}อม\u{e39}ล"),
            keywords: &["ลบข\u{e49}อม\u{e39}ล", "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ลบ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("CL መልጎም"),
            keywords: &["CL መልጎም", "cl"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("CL düwmesi"),
            keywords: &["CL düwmesi", "COOL düwmesi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi CL"),
            keywords: &["CL", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("CL düğmesi"),
            keywords: &["CL", "CL düğmesi", "CL işareti", "sil"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("CL كۇنۇپكىسى"),
            keywords: &["CL كۇنۇپكىسى", "cl"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка «очистити»"),
            keywords: &[
                "квадрат «очистити текст»",
                "кнопка «очистити»",
                "очистити текст",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("CL بٹن"),
            keywords: &["CL بٹن", "cl"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi cl harflari"),
            keywords: &["cl", "kvadrat ichidagi cl harflari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút CL"),
            keywords: &["cl", "nút CL"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu CL"),
            keywords: &["bitoŋu CL", "cl"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi CL"),
            keywords: &["cl", "iqhosha elithi CL"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini CL"),
            keywords: &["Bọtini CL", "cl"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("CL 按鈕"),
            keywords: &["CL 按鈕", "cl"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("CL 按钮"),
            keywords: &["CL 按钮", "cl"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("CL按钮"),
            keywords: &["CL按钮", "cl", "手机", "清理"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("CL"),
            keywords: &["CL"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("CL 按鈕"),
            keywords: &["CL", "CL 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ka-CL"),
            keywords: &["cl", "inkinobho ka-CL"],
        },
    ],
};
#[doc = "🆒"]
pub const COOL_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆒",
    codepoint: "1F192",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "COOL button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("COOL-knopie"),
            keywords: &["COOL-knopie", "koel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀዝቃዛ ካሬ"),
            keywords: &["ቀዝቃዛ ካሬ", "አሪፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بارد داخل مربع"),
            keywords: &["بارد", "بارد داخل مربع", "لطيف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("COOL ব\u{9c1}ট\u{9be}ম"),
            keywords: &["COOL ব\u{9c1}ট\u{9be}ম", "ঠ\u{9be}ণ\u{9cd}ড\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat əla düyməsi"),
            keywords: &["kvadrat əla düyməsi", "əla"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("слова «файна» ў квадраце"),
            keywords: &["слова «файна» ў квадраце", "файна"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Cool“ в квадрат"),
            keywords: &["cool", "„Cool“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে ক\u{9c1}ল"),
            keywords: &[
                "ক\u{9c1}ল",
                "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে ক\u{9c1}ল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton Cool"),
            keywords: &["COOL", "bouton Cool", "cool"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cool kvadrat"),
            keywords: &["cool", "cool kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó COOL"),
            keywords: &["Cool", "botó COOL", "paraula", "quadre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᏏᏴᏝ ᎦᏗ"),
            keywords: &["ᎤᏁᏏᏴᏝ", "ᎤᏁᏏᏴᏝ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek COOL"),
            keywords: &["cool", "štítek COOL"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm COOL"),
            keywords: &["botwm COOL", "cool"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("COOL-knap"),
            keywords: &["COOL-knap", "cool-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wort „Cool“ in blauem Quadrat"),
            keywords: &["Cool", "Wort „Cool“ in blauem Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί COOL"),
            keywords: &["cool", "κουμπί COOL", "τέλεια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("COOL button"),
            keywords: &["COOL button", "cool"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón COOL"),
            keywords: &["botón", "botón COOL", "cool", "mola"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["botón COOL", "cool", "cuadrado", "genial"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp COOL"),
            keywords: &["lahe", "nupp COOL"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“cool” hitza karratu batean"),
            keywords: &["cool", "eder", "“cool” hitza karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} COOL"),
            keywords: &["ای ول", "باحال", "دکمه\u{654} COOL", "سرد", "کول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("COOL"),
            keywords: &["COOL", "laatikko", "siistiä", "teksti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na COOL"),
            keywords: &["COOL", "button na COOL", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("COOL knappur"),
            keywords: &["COOL knappur", "cool", "knappur", "knøttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Cool"),
            keywords: &["bouton Cool", "cool"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bouton Cool", "cool"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe CÚLÁILTE"),
            keywords: &["cnaipe CÚLÁILTE", "díobhálaí", "faiseanta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan COOL"),
            keywords: &["cool", "gasta", "putan COOL", "smodaig"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"xenial\" en inglés"),
            keywords: &[
                "botón \"xenial\" en inglés",
                "cool",
                "interesante",
                "xenial",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઠ\u{a82}ડાન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ક\u{ac2}લ",
                "ક\u{ac2}લન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ઠ\u{a82}ડાન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin MAI NI’IMA"),
            keywords: &["mai ni’ima", "maɓallin MAI NI’IMA"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן cool"),
            keywords: &["לחצן COOL", "לחצן cool", "מגניב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठ\u{902}डा, ठ\u{902}डा चिह\u{94d}न"),
            keywords: &[
                "ठ\u{902}डा",
                "ठ\u{902}डा चिह\u{94d}न",
                "ठ\u{902}डा, ठ\u{902}डा चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka COOL"),
            keywords: &["cool", "tipka COOL"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("COOL gomb"),
            keywords: &["COOL gomb", "cool"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ԶԻԼ բառը ուղղանկյունի մեջ"),
            keywords: &["ԶԻԼ բառը ուղղանկյունի մեջ", "զիլ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol COOL"),
            keywords: &["cool", "tombol COOL"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbi COOL"),
            keywords: &["dị mma", "ọdụmbi COOL"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svalt"),
            keywords: &["kúl", "skilti", "svalt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante COOL"),
            keywords: &["pulsante COOL", "simbolo Cool"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("COOLマーク"),
            keywords: &["COOL", "COOLマーク", "クール"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol COOL"),
            keywords: &["cool", "tombol COOL"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი COOL"),
            keywords: &["cool", "ღილაკი COOL"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("COOL түймесі"),
            keywords: &["COOL түймесі", "cool"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cool"),
            keywords: &["cool", "cool-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ COOL ធ\u{17c6}"),
            keywords: &[
                "COOL",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ COOL ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc2}ಲ\u{ccd} ಬಟನ\u{ccd}"),
            keywords: &["ಕ\u{cc2}ಲ\u{ccd}", "ಕ\u{cc2}ಲ\u{ccd} ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쿨"),
            keywords: &["cool", "쿨", "쿨 신호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("थ\u{902}ड बटण"),
            keywords: &["थ\u{902}ड", "थ\u{902}ड बटण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы салкын"),
            keywords: &["салкын", "чарчыдагы салкын"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("COOL-Knäppchen"),
            keywords: &["COOL-Knäppchen", "cool"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມ cool"),
            keywords: &[
                "ຄວາມເຢ\u{eb1}ນ",
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມ cool",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „COOL“"),
            keywords: &["simbolis „COOL“", "vėsu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts Cool kvadrātveida ietvarā"),
            keywords: &["cool", "uzraksts Cool kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene RAWE"),
            keywords: &["pātene RAWE", "rawe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче КУЛ"),
            keywords: &["копче КУЛ", "кул"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}ൾ ബട\u{d4d}ടൺ"),
            keywords: &[
                "ക\u{d42}ൾ",
                "ക\u{d42}ൾ ബട\u{d4d}ടൺ",
                "ചിഹ\u{d4d}നം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("COOL товчлуур"),
            keywords: &["COOL товчлуур", "cool"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस छान"),
            keywords: &["COOL बटण", "चौरस छान", "छान"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang COOL"),
            keywords: &["butang COOL", "sejuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna COOL"),
            keywords: &["buttuna COOL", "cool"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အေးဆေးပ\u{1032} ခလ\u{102f}တ\u{103a}"),
            keywords: &["အေးဆေးပ\u{1032}", "အေးဆေးပ\u{1032} ခလ\u{102f}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("COOL-knapp"),
            keywords: &["COOL-knapp", "cool"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड\u{94d}ड क\u{941}ल"),
            keywords: &[
                "क\u{942}ल",
                "स\u{94d}क\u{94d}वायर\u{94d}ड\u{94d}ड क\u{941}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("COOL-knop"),
            keywords: &["COOL-knop", "cool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("COOL-knapp"),
            keywords: &["COOL-knapp", "cool"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅତ\u{b3f} ଉତ\u{b4d}କ\u{b43}ଷ\u{b4d}ଟ ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଅତ\u{b3f} ଉତ\u{b4d}କ\u{b43}ଷ\u{b4d}ଟ",
                "ଅତ\u{b3f} ଉତ\u{b4d}କ\u{b43}ଷ\u{b4d}ଟ ବଟନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਰਗਾਕਾਰ ਠ\u{a70}ਡਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਠ\u{a70}ਡਾ",
                "ਵਰਗਾਕਾਰ ਠ\u{a70}ਡਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چنگا بٹن"),
            keywords: &["چنگا بٹن", "چ\u{64e}نگا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("COOL Bọ\u{301}tin"),
            keywords: &["COOL Bọ\u{301}tin", "Cool"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk COOL"),
            keywords: &["aprobata", "cool", "przycisk COOL", "zachwyt", "świetnie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د سوړ بټن"),
            keywords: &["د سوړ بټن", "سوړ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão \"COOL\""),
            keywords: &["botão \"COOL\"", "cool", "legal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão COOL"),
            keywords: &["botão COOL", "cool", "fixe"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu textul COOL"),
            keywords: &["buton cu textul COOL", "cool"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-175"),
            keywords: &["E10-175"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «круто»"),
            keywords: &["здорово", "значок", "значок «круто»", "кнопка", "круто"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya COOL"),
            keywords: &["buto ya COOL", "hatuje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿڌ جو بٽڻ"),
            keywords: &["ٿڌ جو بٽڻ", "ٿڌو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("COOL බොත\u{dca}තම"),
            keywords: &["COOL බොත\u{dca}තම", "cool"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok COOL"),
            keywords: &["cool", "štítok COOL"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb COOL"),
            keywords: &["frajersko", "gumb COOL"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka QABOW"),
            keywords: &["badhanka QABOW", "qabow"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «COOL»"),
            keywords: &[
                "butoni i freskimit",
                "butoni i freskimit «COOL»",
                "butoni «COOL»",
                "cool",
                "freski",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме COOL"),
            keywords: &["cool", "дугме COOL"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme COOL"),
            keywords: &["cool", "dugme COOL"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("COOL-knapp"),
            keywords: &["COOL-knapp", "cool"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye neno ‘COOL’"),
            keywords: &["baridi", "kitufe chenye neno ‘COOL’"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கூல\u{bcd}"),
            keywords: &["கூல\u{bcd}", "கூல\u{bcd} சின\u{bcd}னம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3e}ంతం బటన\u{c4d}"),
            keywords: &[
                "ఆవ\u{c47}శపడవద\u{c4d}దు",
                "కూల\u{c4d}",
                "కూల\u{c4d} చ\u{c3f}హ\u{c4d}నం",
                "శ\u{c3e}ంతం బటన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"ЗӮР\""),
            keywords: &["салқин", "тугмаи \"ЗӮР\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เย\u{e47}น"),
            keywords: &["ส\u{e31}ญล\u{e31}กษณ\u{e4c}ความเย\u{e47}น", "เย\u{e47}น"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("COOL መልጎም"),
            keywords: &["COOL መልጎም", "cool"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("COOL düwmesi"),
            keywords: &["COOL düwmesi", "bet"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi COOL"),
            keywords: &["COOL", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("COOL düğmesi"),
            keywords: &["COOL düğmesi", "harika", "hoş", "serin", "serin işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("«بولىدىكەن» كۇنۇپكىسى"),
            keywords: &["«بولىدىكەن» كۇنۇپكىسى", "بولىدىكەن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"COOL\""),
            keywords: &["квадрат «круто»", "кнопка \"COOL\"", "круто"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کول بٹن"),
            keywords: &["کول", "کول بٹن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi salqinlik, gap yo‘q so‘zi"),
            keywords: &[
                "kvadrat ichidagi salqinlik, gap yo‘q so‘zi",
                "salqinlik",
                "zo‘r",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút COOL"),
            keywords: &["cool", "nút COOL"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu KUUL"),
            keywords: &["bitoŋu KUUL", "sedd"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi KUHLE"),
            keywords: &["iqhosha elithi KUHLE", "kuhle"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini KUULU"),
            keywords: &["Bọtini KUULU", "tútù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("COOL 按鈕"),
            keywords: &["COOL 按鈕", "cool"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("COOL 按钮"),
            keywords: &["COOL 按钮", "cool"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("cool按钮"),
            keywords: &["cool按钮", "按键", "酷"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("酷"),
            keywords: &["酷"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("Cool 按鈕"),
            keywords: &["Cool 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("kupholile okusikwele"),
            keywords: &["kupholile okusikwele", "lungile"],
        },
    ],
};
#[doc = "🆓"]
pub const FREE_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆓",
    codepoint: "1F193",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "FREE button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("FREE-knopie"),
            keywords: &["FREE-knopie", "gratis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጻ ካሬ"),
            keywords: &["ነጻ", "ነጻ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر \"مجاني\""),
            keywords: &["free", "حر", "زر \"مجاني\"", "كلمة free في مربع", "مجاني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("FREE ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "FREE ব\u{9c1}ট\u{9be}ম",
                "বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat ödənişsiz"),
            keywords: &["kvadrat ödənişsiz", "ödənişsiz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("слова «бясплатна» ў квадраце"),
            keywords: &["бясплатна", "слова «бясплатна» ў квадраце"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Free“ в квадрат"),
            keywords: &["free", "„Free“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে ফ\u{9cd}রী"),
            keywords: &[
                "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে ফ\u{9cd}রী",
                "বিন\u{9be}ম\u{9c2}ল\u{9cd}যে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton Digoust"),
            keywords: &["FREE", "bouton Digoust", "free"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("free kvadrat"),
            keywords: &["besplatno", "free kvadrat", "sloboda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó FREE"),
            keywords: &["Free", "botó FREE", "paraula", "quadre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏎᏭᎢ ᎦᏗ"),
            keywords: &["ᎠᏎᏭᎢ", "ᎠᏎᏭᎢ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek FREE"),
            keywords: &["free", "štítek FREE"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm FREE"),
            keywords: &["botwm FREE", "free"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("FREE-knap"),
            keywords: &["FREE-knap", "gratis-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wort „Free“ in blauem Quadrat"),
            keywords: &["Free", "Wort „Free“ in blauem Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί FREE"),
            keywords: &["free", "δωρεάν", "κουμπί FREE"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("FREE button"),
            keywords: &["FREE button", "free"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón FREE"),
            keywords: &["botón FREE", "gratis", "símbolo gratis"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gratis"),
            keywords: &["cuadrado", "free", "gratis", "libre"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("botón FREE"),
            keywords: &["botón FREE", "cuadrado", "free", "gratis", "libre"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp FREE"),
            keywords: &["nupp FREE", "tasuta"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“free” hitza karratu batean"),
            keywords: &["doan", "free", "libre", "“free” hitza karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} FREE"),
            keywords: &["آزاد", "دکمه\u{654} FREE", "رایگان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("FREE"),
            keywords: &["FREE", "ilmainen", "laatikko", "teksti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na FREE"),
            keywords: &["LIBRE", "button na FREE", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("FREE knappur"),
            keywords: &["FREE knappur", "free", "knappur", "knøttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Gratuit"),
            keywords: &["bouton Gratuit", "gratuit"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("free"),
            keywords: &["free"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe SAOR IN AISCE"),
            keywords: &["cnaipe SAOR IN AISCE", "comhartha", "saor", "saor in aisce"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan FREE"),
            keywords: &["an-asgaidh", "putan FREE", "saor"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"gratis\" en inglés"),
            keywords: &["botón \"gratis\" en inglés", "de balde", "free", "gratis"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મફતન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ચિહ\u{acd}ન",
                "મફત",
                "મફતન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "શ\u{ac1}લ\u{acd}ક રહિત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin KYAUTA"),
            keywords: &["kyauta", "maɓallin KYAUTA"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן free"),
            keywords: &["חופשי", "חינם", "לחצן free"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("निश\u{941}ल\u{94d}क चिह\u{94d}न, श\u{941}ल\u{94d}क म\u{941}क\u{94d}त"),
            keywords: &[
                "चिह\u{94d}न",
                "निश\u{941}ल\u{94d}क",
                "निश\u{941}ल\u{94d}क चिह\u{94d}न, श\u{941}ल\u{94d}क म\u{941}क\u{94d}त",
                "श\u{941}ल\u{94d}क म\u{941}क\u{94d}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka FREE"),
            keywords: &["free", "tipka FREE"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("FREE gomb"),
            keywords: &["FREE gomb", "free"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ԱՆՎՃԱՐ բառը ուղղանկյունի մեջ"),
            keywords: &["ԱՆՎՃԱՐ բառը ուղղանկյունի մեջ", "ազատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol FREE"),
            keywords: &["bebas", "free dalam kotak", "tombol FREE"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ỌDỤMBI efù"),
            keywords: &["efù", "ỌDỤMBI efù"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ókeypis"),
            keywords: &["skilti", "ókeypis", "ókeypis-skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante FREE"),
            keywords: &["gratis", "pulsante FREE", "simbolo Free", "simbolo gratis"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("FREEマーク"),
            keywords: &["FREEマーク", "タダ", "フリー", "無料"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol FREE"),
            keywords: &["free", "tombol FREE"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("free კვადრატში"),
            keywords: &["free კვადრატში", "თავისუფალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("FREE түймесі"),
            keywords: &["FREE түймесі", "free"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gratis"),
            keywords: &["gratis", "gratis-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ FREE ធ\u{17c6}"),
            keywords: &[
                "FREE",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ FREE ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉಚ\u{cbf}ತ ಬಟನ\u{ccd}"),
            keywords: &[
                "ಉಚ\u{cbf}ತ",
                "ಉಚ\u{cbf}ತ ಬಟನ\u{ccd}",
                "ಚ\u{ccc}ಕದ ಉಚ\u{cbf}ತ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("프리"),
            keywords: &["자유", "자유 신호", "프리", "프리 신호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{947}कळो बटण"),
            keywords: &["म\u{947}कळो", "म\u{947}कळो बटण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы акысыз"),
            keywords: &["акысыз", "чарчыдагы акысыз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("FRÄI-Knäppchen"),
            keywords: &["FRÄI-Knäppchen", "fräi"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb8}\u{ec8}ມ free ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມມ\u{ebb}ນທ\u{ebb}ນ"),
            keywords: &[
                "ປ\u{eb8}\u{ec8}ມ",
                "ປ\u{eb8}\u{ec8}ມ free ສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມມ\u{ebb}ນທ\u{ebb}ນ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຟຣ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „FREE“"),
            keywords: &["nemokama", "simbolis „FREE“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts Free kvadrātveida ietvarā"),
            keywords: &["bezmaksas", "free", "uzraksts Free kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene KOREUTU"),
            keywords: &["koreutu", "pātene KOREUTU"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче ФРИ"),
            keywords: &["бесплатно", "копче ФРИ"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d57}ജന\u{d4d}യം"),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "ഫ\u{d4d}രീ",
                "സിംബൽ",
                "സ\u{d57}ജന\u{d4d}യ നിരക\u{d4d}ക\u{d4d}",
                "സ\u{d57}ജന\u{d4d}യം",
                "സ\u{d57}ജന\u{d4d}യനിരക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("FREE товчлуур"),
            keywords: &["FREE товчлуур", "free"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस विनाम\u{942}ल\u{94d}य"),
            keywords: &[
                "FREE बटण",
                "चौरस विनाम\u{942}ल\u{94d}य",
                "विनाम\u{942}ल\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang FREE"),
            keywords: &["butang FREE", "percuma"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna FREE"),
            keywords: &["buttuna FREE", "free"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အခမ\u{1032}\u{1037} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "အခမ\u{1032}\u{1037} ခလ\u{102f}တ\u{103a}",
                "အခမ\u{1032}\u{1037} သင\u{103a}\u{1039}ကေတ",
                "အခမ\u{1032}\u{1037} သင\u{103a}\u{1039}ကေတ ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("FREE-knapp"),
            keywords: &["FREE-knapp", "free", "free-symbol", "gratis"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}कावायर\u{94d}ड फ\u{94d}री"),
            keywords: &["निःश\u{941}ल\u{94d}क", "स\u{94d}कावायर\u{94d}ड फ\u{94d}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("FREE-knop"),
            keywords: &["FREE-knop", "gratis"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("FREE-knapp"),
            keywords: &["FREE-knapp", "free", "free-symbol", "gratis"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3e}ଗଣ\u{b3e} ବଟନ\u{b4d}"),
            keywords: &["ମ\u{b3e}ଗଣ\u{b3e}", "ମ\u{b3e}ଗଣ\u{b3e} ବଟନ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਰਗਾਕਾਰ ਮ\u{a41}ਫ\u{a3c}ਤ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਮ\u{a41}ਫ\u{a3c}ਤ",
                "ਵਰਗਾਕਾਰ ਮ\u{a41}ਫ\u{a3c}ਤ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آزاد بٹن"),
            keywords: &["آزاد بٹن", "مفت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("FREE Bọ\u{301}tin"),
            keywords: &["FREE Bọ\u{301}tin", "Fri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk FREE"),
            keywords: &["przycisk FREE", "znak FREE", "znak braku opłaty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د آزاد بټن"),
            keywords: &["آزاد", "د آزاد بټن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão \"FREE\""),
            keywords: &["botão \"FREE\"", "gratuito", "grátis"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão FREE"),
            keywords: &["botão FREE", "free", "gratuito", "livre"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu textul FREE"),
            keywords: &["buton cu textul FREE", "gratis"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-176"),
            keywords: &["E10-176"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «бесплатно»"),
            keywords: &["бесплатно", "значок", "значок «бесплатно»", "кнопка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya FREE"),
            keywords: &["buto ya FREE", "kidafashwe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مفت بٽڻ"),
            keywords: &["مفت", "مفت بٽڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("FREE බොත\u{dca}තම"),
            keywords: &["FREE බොත\u{dca}තම", "free"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok FREE"),
            keywords: &["free", "štítok FREE"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb FREE"),
            keywords: &["gumb FREE", "prosto"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka BILAASH AH"),
            keywords: &["badhanka BILAASH AH", "bilaash"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «FREE»"),
            keywords: &[
                "butoni i lirimit",
                "butoni i lirimit «FREE»",
                "butoni «FREE»",
                "free",
                "liro",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме FREE"),
            keywords: &["free", "дугме FREE"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme FREE"),
            keywords: &["dugme FREE", "free"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("FREE-knapp"),
            keywords: &["FREE-knapp", "gratis", "gratis-symbol", "symbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cheney neno ‘FREE’"),
            keywords: &["huru", "kitufe cheney neno ‘FREE’"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "huru",
                "kitufe cheney neno ‘FREE’",
                "kitufe chenye neno ‘FREE’",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இலவசம\u{bcd}"),
            keywords: &["இலவசச\u{bcd} சின\u{bcd}னம\u{bcd}", "இலவசம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉచ\u{c3f}తం బటన\u{c4d}"),
            keywords: &[
                "ఉచ\u{c3f}తం బటన\u{c4d}",
                "ఖ\u{c3e}ళ\u{c40} స\u{c4d}థలం",
                "ఖ\u{c3e}ళ\u{c40}గ\u{c3e} ఉన\u{c4d}న\u{c3e}ను",
                "ఛ\u{c3e}ర\u{c4d}జ\u{c40} రహ\u{c3f}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"ОЗОД\""),
            keywords: &["озод", "тугмаи \"ОЗОД\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟร\u{e35}"),
            keywords: &[
                "ฟร\u{e35}",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ฟร\u{e35}",
                "ไม\u{e48}ม\u{e35}ค\u{e48}าใช\u{e49}จ\u{e48}าย",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ክፉት መልጎም"),
            keywords: &["ክፉት", "ክፉት መልጎም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("FREE düwmesi"),
            keywords: &["FREE düwmesi", "erkin"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi FREE"),
            keywords: &["FREE", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("FREE düğmesi"),
            keywords: &[
                "FREE düğmesi",
                "bedava",
                "bedelsiz",
                "işaret",
                "ücretsiz",
                "ücretsiz işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("«بىكار» كۇنۇپكىسى"),
            keywords: &["«بىكار» كۇنۇپكىسى", "بىكار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"FREE\""),
            keywords: &["безкоштовно", "квадрат «безкоштовно»", "кнопка \"FREE\""],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مفت بٹن"),
            keywords: &["مفت", "مفت بٹن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi bo‘sh, tekin so‘zi"),
            keywords: &["bepul", "kvadrat ichidagi bo‘sh, tekin so‘zi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút FREE"),
            keywords: &["free", "nút FREE"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu AMUL FAY"),
            keywords: &["amul fay", "bitoŋu AMUL FAY"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi simahla"),
            keywords: &["iqhosha elithi simahla", "simahla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini ỌFẸ"),
            keywords: &["Bọtini ỌFẸ", "ọ\u{300}fẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("FREE 按鈕"),
            keywords: &["FREE 按鈕", "free"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("FREE 按钮"),
            keywords: &["FREE 按钮", "free"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("免费按钮"),
            keywords: &["不收费", "免费按钮", "按钮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("免費"),
            keywords: &["免費"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("免費按鈕"),
            keywords: &["免費按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho loku-FREE"),
            keywords: &["inkinobho loku-FREE", "mahhala"],
        },
    ],
};
#[doc = "ℹ\u{fe0f}"]
pub const INFORMATION: crate::Emoji = crate::Emoji {
    glyph: "ℹ\u{fe0f}",
    codepoint: "2139 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "information",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "ℹ",
        codepoint: "2139",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "information",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("inligting"),
            keywords: &["I", "inligting"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመረጃ ምንጭ"),
            keywords: &["መረጃ", "የመረጃ ምንጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصدر معلومات"),
            keywords: &["مصدر معلومات", "معلومات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তথ\u{9cd}য"),
            keywords: &["i", "তথ\u{9cd}য"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("informasiya məlumatı"),
            keywords: &["i", "informasiya məlumatı", "məlumat"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("крыніца інфармацыі"),
            keywords: &["даведка", "крыніца інфармацыі", "інфармацыя"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Източник на информация"),
            keywords: &["Източник на информация", "информация"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তথ\u{9cd}য স\u{9c2}ত\u{9cd}র"),
            keywords: &[
                "i চিহ\u{9cd}ন",
                "তথ\u{9cd}য",
                "তথ\u{9cd}য স\u{9c2}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("titouroù"),
            keywords: &["i", "titouroù"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("izvor informacija"),
            keywords: &["i", "informacija", "izvor informacija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("informació"),
            keywords: &["i", "informació", "punt d’informació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏃᎮᏢᏅᎢ"),
            keywords: &["i", "ᎧᏃᎮᏢᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("informace"),
            keywords: &["i", "informace"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwybodaeth"),
            keywords: &["gwybodaeth", "i"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("information"),
            keywords: &["i", "information", "informationskilde", "turistinformation"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Buchstabe „i“ in blauem Quadrat"),
            keywords: &["Buchstabe „i“ in blauem Quadrat", "Information", "i"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πληροφορίες"),
            keywords: &["i", "πληροφορίες"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("information"),
            keywords: &["i", "information"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("información"),
            keywords: &["i", "información"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("teabeallikas"),
            keywords: &["i", "info", "teabeallikas", "teave"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("informazio-iturburua"),
            keywords: &["i", "informazio", "informazio-iturburua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اطلاعات"),
            keywords: &["i", "اطلاعات"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("info"),
            keywords: &["i", "info", "info-piste", "tietoja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pinagmulan ng impormasyon"),
            keywords: &["i", "impormasyon", "pinagmulan ng impormasyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kunning"),
            keywords: &["i", "kunning", "kunningarstova", "leiðbeining", "upplýsing"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("source d’informations"),
            keywords: &["i", "informations", "source d’informations"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("informations"),
            keywords: &["i", "informations"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("foinse eolais"),
            keywords: &["eolas", "foinse eolais", "foinse eolas", "i"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fiosrachadh"),
            keywords: &["fiosrachadh", "i"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("punto de información"),
            keywords: &["información", "punto de información"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માહિતીનો સ\u{acd}રોત"),
            keywords: &["આઇ", "માહિતી", "માહિતીનો સ\u{acd}રોત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bayani"),
            keywords: &["b", "bayani"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל מידע"),
            keywords: &["מודיעין", "מידע", "סמל מידע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}चना"),
            keywords: &[
                "अक\u{94d}षर आई",
                "अक\u{94d}षर आई, स\u{942}चना",
                "आई",
                "जानकारी",
                "स\u{942}चना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("izvor informacija"),
            keywords: &["i", "informacije", "izvor informacija"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("információforrás"),
            keywords: &["i", "információ", "információforrás", "tájékoztatás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տեղեկատու"),
            keywords: &["i", "տեղեկատու", "տեղեկատվություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("informasi"),
            keywords: &["i", "informasi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ozi"),
            keywords: &["i", "ozi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("upplýsingaveita"),
            keywords: &["u", "upplýsingar", "upplýsingaveita"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto informazioni"),
            keywords: &["i", "informazioni", "punto informazioni"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("iマーク"),
            keywords: &["i", "iマーク", "インフォメーション", "情報"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("informasi"),
            keywords: &["i", "informasi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ინფორმაცია"),
            keywords: &["i", "ინფორმაცია"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақпарат көзі"),
            keywords: &["i", "ақпарат", "ақпарат көзі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("informationskilde"),
            keywords: &["i", "information", "informationskilde", "turistinformation"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ i ត\u{17bc}ច"),
            keywords: &[
                "i",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ i ត\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಾಹ\u{cbf}ತ\u{cbf}"),
            keywords: &["ಐ", "ಮಾಹ\u{cbf}ತ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("정보 출처"),
            keywords: &["I", "정보", "정보 출처"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{94d}हायती"),
            keywords: &["माहिती", "म\u{94d}हायती"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("маалымат булагы"),
            keywords: &["маалымат", "маалымат булагы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Informatioun"),
            keywords: &["I", "Informatioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຫ\u{ebc}\u{ec8}ງຂ\u{ecd}\u{ec9}ມ\u{eb9}ນ"),
            keywords: &[
                "ຂ\u{ecd}\u{ec9}ມ\u{eb9}ນ",
                "ທ\u{eb5}\u{ec8}ມາ",
                "ແຫ\u{ebc}\u{ec8}ງ",
                "ແຫ\u{ebc}\u{ec8}ງຂ\u{ecd}\u{ec9}ມ\u{eb9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("informacija"),
            keywords: &["i", "informacija"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("informācijas simbols"),
            keywords: &["i", "informācija", "informācijas simbols"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mōhiohio"),
            keywords: &["i", "mōhiohio"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("информации"),
            keywords: &["информации"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിവരങ\u{d4d}ങൾ"),
            keywords: &["i", "അന\u{d4d}വേഷണം", "വിവരം", "വിവരങ\u{d4d}ങൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мэдээлэл"),
            keywords: &["i", "мэдээлэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("माहिती स\u{94d}त\u{94d}रोत"),
            keywords: &["माहिती", "माहिती स\u{94d}त\u{94d}रोत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sumber maklumat"),
            keywords: &["i", "maklumat", "sumber maklumat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("informazzjoni"),
            keywords: &["i", "informazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သတင\u{103a}းအချက\u{103a}အလက\u{103a}"),
            keywords: &[
                "သတင\u{103a}းအချက\u{103a}အလက\u{103a}",
                "သတင\u{103a}းအချက\u{103a}အလက\u{103a}ပြ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("informasjon"),
            keywords: &["i", "info", "informasjon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जानकारीको श\u{94d}रोत"),
            keywords: &["आई", "जानकारी", "जानकारीको श\u{94d}रोत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("informatie"),
            keywords: &["i", "informatie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("informasjon"),
            keywords: &["i", "info", "informasjon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b42}ଚନ\u{b3e}"),
            keywords: &["i", "ସ\u{b42}ଚନ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਣਕਾਰੀ ਸਰ\u{a4b}ਤ"),
            keywords: &["i", "ਜਾਣਕਾਰੀ", "ਜਾਣਕਾਰੀ ਸਰ\u{a4b}ਤ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("معلومات"),
            keywords: &["i", "معلومات"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ínfọméshọn"),
            keywords: &["i", "Ínfọméshọn"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("informacja"),
            keywords: &[
                "i",
                "informacja",
                "informacje",
                "punkt informacyjny",
                "źródło informacji",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("معلومات"),
            keywords: &["معلومات"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("informações"),
            keywords: &["i", "informações", "símbolo", "símbolo de informações"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("posto de informação"),
            keywords: &["i", "informações", "posto de informação"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("informații"),
            keywords: &["i", "informații"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-005"),
            keywords: &["E10-005"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок информации"),
            keywords: &[
                "значок",
                "значок информации",
                "информация",
                "подробнее",
                "сведения",
                "справка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amakuru"),
            keywords: &["amakuru", "amakuru ’i’"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("معلومات"),
            keywords: &["i", "معلومات"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තොරත\u{dd4}ර\u{dd4} ම\u{dd6}ල\u{dcf}ශ\u{dca}\u{200d}රය"),
            keywords: &[
                "i",
                "තොරත\u{dd4}ර\u{dd4}",
                "තොරත\u{dd4}ර\u{dd4} ම\u{dd6}ල\u{dcf}ශ\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("informačný zdroj"),
            keywords: &["i", "informačný zdroj", "informácie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vir informacij"),
            keywords: &["i", "informacije", "vir informacij"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("macluumaad"),
            keywords: &["i", "macluumaad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("informacion"),
            keywords: &["i", "informacion"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("извор информација"),
            keywords: &["i", "извор информација", "информације"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["извор информација"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("izvor informacija"),
            keywords: &["i", "informacije", "izvor informacija"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["izvor informacija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("information"),
            keywords: &["i", "information", "informationskälla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha maelezo"),
            keywords: &["i", "kitufe cha maelezo", "maelezo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தகவல\u{bcd}"),
            keywords: &["ஆத\u{bbe}ரம\u{bcd}", "தகவல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సమ\u{c3e}చ\u{c3e}రం"),
            keywords: &["సమ\u{c3e}చ\u{c3e}ర మూలం", "సమ\u{c3e}చ\u{c3e}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("маълумот"),
            keywords: &["i", "маълумот"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แหล\u{e48}งข\u{e49}อม\u{e39}ล"),
            keywords: &[
                "ข\u{e49}อม\u{e39}ล",
                "ท\u{e35}\u{e48}มา",
                "แหล\u{e48}ง",
                "แหล\u{e48}งข\u{e49}อม\u{e39}ล",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሓበሬታ"),
            keywords: &["i", "ሓበሬታ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("maglumat"),
            keywords: &["i", "maglumat"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga fakamatala"),
            keywords: &["fakamatala", "fakaʻilonga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bilgi"),
            keywords: &["bilgi", "i harfi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۇچۇر"),
            keywords: &["i", "ئۇچۇر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("джерело інформації"),
            keywords: &["i", "джерело інформації", "інформація"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("معلومات"),
            keywords: &["ماخذ", "معلومات"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("axborot manbasi"),
            keywords: &["axborot", "axborot manbasi", "ma’lumot"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thông tin"),
            keywords: &["i", "thông tin"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("info (xibaar)"),
            keywords: &["i", "info (xibaar)"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkcazelo"),
            keywords: &["i", "inkcazelo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àlàyé"),
            keywords: &["i", "àlàyé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("資訊"),
            keywords: &["i", "資訊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("资讯"),
            keywords: &["i", "资讯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("信息"),
            keywords: &["信息", "查询", "资料"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("資訊"),
            keywords: &["資訊"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("資料"),
            keywords: &["資料"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umthombo wolwazi"),
            keywords: &["i", "ulwazi", "umthombo wolwazi"],
        },
    ],
};
#[doc = "🆔"]
pub const ID_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆔",
    codepoint: "1F194",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ID button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ID-knopie"),
            keywords: &["ID", "ID-knopie", "identiteit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አይዲ ካሬ"),
            keywords: &["መለያ ማንነት", "አይዲ", "አይዲ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر \"معر\u{651}ف الهوي\u{651}ة\""),
            keywords: &[
                "ID في مربع",
                "id",
                "زر \"معر\u{651}ف الهوي\u{651}ة\"",
                "هوية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ID ব\u{9c1}ট\u{9be}ম"),
            keywords: &["ID ব\u{9c1}ট\u{9be}ম", "id", "পৰিচয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat kimlik"),
            keywords: &["id", "kimlik", "kvadrat kimlik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("слова «пасведчанне» ў квадраце"),
            keywords: &[
                "асоба",
                "пасведчанне",
                "слова «пасведчанне» ў квадраце",
                "ідэнтыфікацыя",
                "ідэнтычнасць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„ID“ в квадрат"),
            keywords: &["самоличност", "„ID“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র আইডি"),
            keywords: &["আইডি", "পরিচয\u{9bc}", "বর\u{9cd}গ\u{9be}ক\u{9be}র আইডি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton Anaouder"),
            keywords: &["ID", "bouton Anaouder", "id"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("id kvadrat"),
            keywords: &["id", "id kvadrat", "identitet"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó ID"),
            keywords: &[
                "ID",
                "botó ID",
                "identificació",
                "identitat",
                "símbol d’identificació",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ID ᎦᏗ"),
            keywords: &["ID ᎦᏗ", "id", "ᎪᏟᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek ID"),
            keywords: &["id", "identita", "totožnost", "štítek ID"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm ID"),
            keywords: &["adnabod", "botwm ID", "id"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ID-knap"),
            keywords: &["ID-knap", "id-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstaben ID in lila Quadrat"),
            keywords: &["Großbuchstaben ID in lila Quadrat", "ID"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstaben ID in lila Quadrat"),
            keywords: &["Grossbuchstaben ID in lila Quadrat", "ID"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί ID"),
            keywords: &["id", "κουμπί ID", "ταυτότητα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ID button"),
            keywords: &["ID button", "id", "identity"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de identificación"),
            keywords: &[
                "ID",
                "identidad",
                "símbolo de identificación",
                "símbolo identidad",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("botón ID"),
            keywords: &[
                "ID",
                "botón ID",
                "identidad",
                "símbolo de identificación",
                "símbolo identidad",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp ID"),
            keywords: &["id", "identiteet", "nupp ID"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“id” testua karratu batean"),
            keywords: &["id", "identitate", "nortasun", "“id” testua karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} شناسایی"),
            keywords: &[
                "دکمه\u{654} ID",
                "دکمه\u{654} شناسایی",
                "شناسه",
                "کارت شناسایی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ID"),
            keywords: &["ID", "henkilöllisyystodistus", "id", "identiteetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na ID"),
            keywords: &["ID", "button na ID", "pagkakakilanlan", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ID knappur"),
            keywords: &[
                "ID knappur",
                "id",
                "identitetur",
                "knappur",
                "knøttur",
                "samleiki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Identifiant"),
            keywords: &["bouton Identifiant", "identifiant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe aitheantais"),
            keywords: &[
                "ID",
                "aitheantas",
                "cnaipe aitheantais",
                "comhartha",
                "comhartha aitheantais",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan ID"),
            keywords: &["aithnichear", "dearbh-aithne", "id", "putan ID"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"identificación\" en inglés"),
            keywords: &[
                "ID",
                "botón \"identificación\" en inglés",
                "identidade",
                "identificación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઓળખન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ID",
                "ID ન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ઓળખ",
                "ઓળખન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin ID"),
            keywords: &["id", "maɓallin ID", "shaida"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ID"),
            keywords: &["זהות", "זיהוי", "לחצן ID", "מזהה", "תעודת זהות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आईडी चिह\u{94d}न, पहचान"),
            keywords: &["आईडी", "आईडी चिह\u{94d}न, पहचान", "चिह\u{94d}न", "पहचान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka ID"),
            keywords: &["id", "identitet", "tipka ID"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ID gomb"),
            keywords: &["ID gomb", "id", "identitás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("այ-դի"),
            keywords: &["id", "այ-դի", "ինքնություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol ID"),
            keywords: &["id", "identitas", "tombol ID", "tombol id"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ỌDỤMBI id"),
            keywords: &["id", "njirimara", "ỌDỤMBI id"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ID"),
            keywords: &["ID", "ID-skilti", "skilríki", "skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante ID"),
            keywords: &["identità", "pulsante ID", "simbolo ID"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("IDマーク"),
            keywords: &["ID", "IDマーク", "アイディー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol ID"),
            keywords: &["id", "idhentitas", "tombol ID"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი ID"),
            keywords: &["id", "იდენტიფიკაცია", "ღილაკი ID"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ID түймесі"),
            keywords: &["ID түймесі", "id", "айқындық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("id"),
            keywords: &["id", "id-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ ID ធ\u{17c6}"),
            keywords: &[
                "ID",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ ID ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಐಡ\u{cbf} ಬಟನ\u{ccd}"),
            keywords: &[
                "ಐಡ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಐಡ\u{cbf} ಬಟನ\u{ccd}",
                "ಗುರುತ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아이디"),
            keywords: &["ID", "아이디", "아이디 신호", "아이디 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ID बटण"),
            keywords: &["ID बटण", "id", "वळख"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ID баскычы"),
            keywords: &["ID баскычы", "id", "идентификатор"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ID-Knäppchen"),
            keywords: &["ID", "ID-Knäppchen", "Identitéit"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໝາຍເລກປະຈຳຕ\u{ebb}ວ"),
            keywords: &["ລະຫ\u{eb1}ດປະຈຳຕ\u{ebb}ວ", "ໝາຍເລກ", "ໝາຍເລກປະຈຳຕ\u{ebb}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „ID“"),
            keywords: &["ID", "simbolis „ID“", "tapatybė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts ID kvadrātveida ietvarā"),
            keywords: &["ID", "identitāte", "uzraksts ID kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene TT"),
            keywords: &["pātene TT", "tt", "tuakiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче ИД"),
            keywords: &["идентитет", "копче ИД"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തിരിച\u{d4d}ചറിയൽ ചിഹ\u{d4d}നം"),
            keywords: &[
                "ID",
                "ഐഡന\u{d4d}റിറ\u{d4d}റി",
                "ഐഡി",
                "ചിഹ\u{d4d}നം",
                "തിരിച\u{d4d}ചറിയൽ ചിഹ\u{d4d}നം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ID товчлуур"),
            keywords: &["ID товчлуур", "id", "биеийн байцаалт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस आयडी"),
            keywords: &["ID बटण", "id", "ओळख", "चौरस आयडी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang ID"),
            keywords: &["butang ID", "id", "identiti"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna ID"),
            keywords: &["buttuna ID", "id", "identità"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}\u{102f}င\u{103a}ဒ\u{102e} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "အထောက\u{103a}အထား",
                "အ\u{102d}\u{102f}င\u{103a}ဒ\u{102e} ခလ\u{102f}တ\u{103a}",
                "အ\u{102d}\u{102f}င\u{103a}ဒ\u{102e} သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ID-knapp"),
            keywords: &["ID-knapp", "ID-symbol", "identitet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड आइडी"),
            keywords: &["आईडी", "पहिचान", "स\u{94d}क\u{94d}वायर\u{94d}ड आइडी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ID-knop"),
            keywords: &["ID-knop", "id", "identiteit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ID-knapp"),
            keywords: &["ID-knapp", "ID-symbol", "identitet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ID ବଟନ\u{b4d}\u{200c}"),
            keywords: &["ID ବଟନ\u{b4d}\u{200c}", "id", "ପର\u{b3f}ଚୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ID ਬਟਨ"),
            keywords: &["ID", "ID ਬਟਨ", "ਨਿਸ\u{a3c}ਾਨ", "ਪਛਾਣ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ID بٹن"),
            keywords: &["ID بٹن", "id", "شناخت"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("ID Bọ\u{301}tin"),
            keywords: &["Aídẹ\u{301}ntíti", "ID Bọ\u{301}tin", "id"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk ID"),
            keywords: &["ID", "identyfikator", "przycisk ID", "znak ID"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("آي ډې بټن"),
            keywords: &["آي ډي", "آي ډي بټن", "آي ډې بټن", "پېژندګلو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão ID"),
            keywords: &["ID", "botão ID", "identidade", "símbolo", "símbolo “ID”"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão ID"),
            keywords: &["botão ID", "id", "identidade", "identificação"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton ID"),
            keywords: &["buton ID", "id", "identitate"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-177"),
            keywords: &["E10-177"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «идентификация»"),
            keywords: &[
                "значок",
                "значок «идентификация»",
                "идентификатор",
                "идентификация",
                "кнопка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ID"),
            keywords: &["buto ya ID", "id", "umwirondoro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ID بٽڻ"),
            keywords: &["ID بٽڻ", "id", "شناخت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ID බොත\u{dca}තම"),
            keywords: &["ID බොත\u{dca}තම", "id", "අනන\u{dca}\u{200d}යත\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok ID"),
            keywords: &["id", "identita", "štítok ID"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb ID"),
            keywords: &["gumb ID", "id", "identiteta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ID-ga"),
            keywords: &["aqoonsi", "badhanka ID-ga", "id"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «ID»"),
            keywords: &["ID", "butoni «ID»", "identitet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме ID"),
            keywords: &["id", "дугме ID", "идeнтитeт", "идентификација"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme ID"),
            keywords: &["dugme ID", "id", "identifikacija", "identitet"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ID-knapp"),
            keywords: &["ID", "ID-knapp", "ID-symbol", "identitet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("herufi ID kwenye mraba"),
            keywords: &["herufi ID kwenye mraba", "id", "utambulisho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஐடி"),
            keywords: &["அடைய\u{bbe}ளம\u{bcd}", "ஐடி", "சின\u{bcd}னம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఐడ\u{c3f} బటన\u{c4d}"),
            keywords: &[
                "ఐడ\u{c3f} క\u{c3e}ర\u{c4d}డ\u{c4d}",
                "ఐడ\u{c3f} గుర\u{c4d}తు",
                "ఐడ\u{c3f} బటన\u{c4d}",
                "గుర\u{c4d}త\u{c3f}ంపు",
                "రుజువు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"ID\""),
            keywords: &["id", "тугмаи \"ID\"", "шахсият"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมายเลขประจำต\u{e31}ว"),
            keywords: &[
                "รห\u{e31}สประจำต\u{e31}ว",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}หมายเลขประจำต\u{e31}ว",
                "หมายเลขประจำต\u{e31}ว",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ID መልጎም"),
            keywords: &["ID መልጎም", "id", "መንነት"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ID düwmesi"),
            keywords: &["ID düwmesi", "id", "şahsyýet"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi ID"),
            keywords: &["ID", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ID düğmesi"),
            keywords: &["ID düğmesi", "işaret", "kimlik", "kimlik işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ID كۇنۇپكىسى"),
            keywords: &["ID كۇنۇپكىسى", "id", "كىملىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"ID\""),
            keywords: &[
                "квадрат «ідентифікатор»",
                "кнопка \"ID\"",
                "особистість",
                "ідентифікатор",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ID بٹن"),
            keywords: &["ID بٹن", "id", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi id harflari"),
            keywords: &["id", "kvadrat ichidagi id harflari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút ID"),
            keywords: &["danh tính", "id", "nút ID"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu ID (dàntite)"),
            keywords: &["bitoŋu ID (dàntite)", "dàntite", "id"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha le-ID"),
            keywords: &["id", "iqhosha le-ID", "isazisi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini ID"),
            keywords: &["Bọtini ID", "ìdánimò\u{329}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("ID 按鈕"),
            keywords: &["ID 按鈕", "id", "身份"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("ID 按钮"),
            keywords: &["ID 按钮", "id", "身份"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("ID按钮"),
            keywords: &["ID按钮", "按键", "识别", "身份"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("身分"),
            keywords: &["ID", "身分"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("身份"),
            keywords: &["ID", "身份"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ye-ID"),
            keywords: &["id", "inkinobho ye-ID", "umazisi"],
        },
    ],
};
#[doc = "Ⓜ\u{fe0f}"]
pub const CIRCLED_M: crate::Emoji = crate::Emoji {
    glyph: "Ⓜ\u{fe0f}",
    codepoint: "24C2 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "circled M",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "Ⓜ",
        codepoint: "24C2",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "circled M",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("M in sirkel"),
            keywords: &["M", "M in sirkel", "sirkel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በክብ ውስጥ ያለ ኤም ፊደል"),
            keywords: &["በክብ ውስጥ ያለ ኤም ፊደል", "ክብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حرف إم"),
            keywords: &["إم", "حرف إم", "دائرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c3}ত\u{9cd}ত\u{9be}ব\u{9c3}ত M"),
            keywords: &[
                "m",
                "ব\u{9c3}ত\u{9cd}ত",
                "ব\u{9c3}ত\u{9cd}ত\u{9be}ব\u{9c3}ত M",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dairəvi m hərfi"),
            keywords: &["dairə", "dairəvi m hərfi", "m"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("літара «M» у коле"),
            keywords: &["M", "кола", "круг", "літара", "літара «M» у коле"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Буква „M“ в кръг"),
            keywords: &["[m]", "Буква „M“ в кръг", "кръг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}ত\u{9cd}তে থ\u{9be}ক\u{9be} এম অক\u{9cd}ষর"),
            keywords: &[
                "এম",
                "ব\u{9c3}ত\u{9cd}ত",
                "ব\u{9c3}ত\u{9cd}তে থ\u{9be}ক\u{9be} এম অক\u{9cd}ষর",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("M kelcʼhiet"),
            keywords: &["M", "M kelcʼhiet", "kelcʼh", "m"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slovo m u krugu"),
            keywords: &["krug", "m", "slovo m u krugu"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("lletra M en cercle"),
            keywords: &["M", "cercle", "lletra", "lletra M en cercle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏕᏱᏍᏛ M"),
            keywords: &["m", "ᎦᏐᏆᎳ", "ᎦᏕᏱᏍᏛ M", "ᎦᏕᏱᏍᏛ Ꮇ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("M v kroužku"),
            keywords: &["M v kroužku", "kroužek", "kruh", "m"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llythyren M mewn cylch"),
            keywords: &["cylch", "llythyren M mewn cylch", "m"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("m i cirkel"),
            keywords: &["cirkel", "m", "m i cirkel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Buchstabe „M“ in Kreis"),
            keywords: &["Buchstabe „M“ in Kreis", "Kreis", "M"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("M σε κύκλο"),
            keywords: &["M σε κύκλο", "m", "κύκλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("circled M"),
            keywords: &["circle", "circled M", "m"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("m en círculo"),
            keywords: &["círculo", "m", "m en círculo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("letra m en un círculo"),
            keywords: &["M", "letra", "letra m en un círculo", "metro"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("M ringis"),
            keywords: &["M ringis", "m", "ring"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“m” hizkia zirkulu batean"),
            keywords: &["m", "zirkulu", "“m” hizkia zirkulu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حرف ام در دایره"),
            keywords: &["ام", "حرف ام در دایره", "دایره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("m ympyrässä"),
            keywords: &["m", "m ympyrässä", "metro", "ympyrä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("binilugang M"),
            keywords: &["M", "bilog", "binilugan", "binilugang M"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("M í sirkuli"),
            keywords: &["M í sirkuli", "m", "sirkul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("m encerclé"),
            keywords: &["cercle", "m", "m encerclé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("litir M le ciorcal timpeall air"),
            keywords: &[
                "ciorcal",
                "litir M le ciorcal timpeall air",
                "litir m le ciorcal thart timpeall",
                "m",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("M le cearcall timcheall air"),
            keywords: &["M le cearcall timcheall air", "cearcall", "m"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("círculo coa letra “M”"),
            keywords: &["M", "círculo", "círculo coa letra “M”", "metro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગોળમા\u{a82} અક\u{acd}ષર એમ"),
            keywords: &["એમ", "ગોળ", "ગોળમા\u{a82} અક\u{acd}ષર એમ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("M da aka saka da’ira"),
            keywords: &["M da aka saka da’ira", "da’ira", "m"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("m בעיגול"),
            keywords: &["m בעיגול", "האות אם", "עיגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{943}त\u{94d}त क\u{947} भीतर M"),
            keywords: &[
                "m",
                "व\u{943}त\u{94d}त",
                "व\u{943}त\u{94d}त क\u{947} भीतर M",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("slovo m u krugu"),
            keywords: &["krug", "m", "slovo m u krugu"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bekarikázott M betű"),
            keywords: &["bekarikázott M betű", "kör", "m"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էմ տառը շրջանակի մեջ"),
            keywords: &["m", "էմ տառը շրջանակի մեջ", "շրջան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("huruf M dalam lingkaran"),
            keywords: &[
                "huruf M dalam lingkaran",
                "huruf m dalam lingkaran",
                "lingkaran",
                "m",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwere okirikiri M"),
            keywords: &["m", "nwere okirikiri M", "okirikiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bókstafurinn m inni í hring"),
            keywords: &["bókstafurinn m inni í hring", "hringur", "m"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante M cerchiata"),
            keywords: &["M azzurra", "metro", "pulsante M cerchiata", "simbolo M"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("丸いMマーク"),
            keywords: &["M", "丸", "丸いMマーク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("M dibunderi"),
            keywords: &["M dibunderi", "bunder", "m"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ასო m წრეში"),
            keywords: &["m", "ასო m წრეში", "რგოლი", "წრე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шеңбердегі M"),
            keywords: &["m", "шеңбер", "шеңбердегі M"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("m i cirkel"),
            keywords: &["cirkel", "m", "m i cirkel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អក\u{17d2}សរ M ធ\u{17c6}ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}ម\u{17bc}ល"),
            keywords: &[
                "M",
                "រង\u{17d2}វង\u{17cb}ម\u{17bc}ល",
                "អក\u{17d2}សរ",
                "អក\u{17d2}សរ M ធ\u{17c6}ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}ម\u{17bc}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೃತ\u{ccd}ತಕಾರದ ಎಂ"),
            keywords: &[
                "ಎಂ",
                "ವೃತ\u{ccd}ತ",
                "ವೃತ\u{ccd}ತಕಾರದ ಎಂ",
                "ವೃತ\u{ccd}ತಕಾರದ ಪತ\u{ccd}ರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("원글자 엠"),
            keywords: &["M", "동그라미", "원", "원글자 엠"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वर\u{94d}त\u{941}ळ क\u{947}ल\u{94d}लो M"),
            keywords: &[
                "m",
                "वर\u{94d}त\u{941}ळ",
                "वर\u{94d}त\u{941}ळ क\u{947}ल\u{94d}लो M",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тегеректеги м"),
            keywords: &["м", "тегерек", "тегеректеги м"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("agekreesten M"),
            keywords: &["Krees", "M", "agekreesten M"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຕ m ໃນວ\u{ebb}ງມ\u{ebb}ນ"),
            keywords: &["ວ\u{ebb}ງມ\u{ebb}ນ", "ໂຕ m", "ໂຕ m ໃນວ\u{ebb}ງມ\u{ebb}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raidė „M“"),
            keywords: &["apskritimas", "m", "raidė „M“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("burts M apļveida ietvarā"),
            keywords: &["M", "aplis", "burts M apļveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("M porohitatia"),
            keywords: &["M porohitatia", "m", "porohita"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("буквата м во круг"),
            keywords: &["буквата м во круг", "круг", "м"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d43}ത\u{d4d}തത\u{d4d}തില\u{d41}ള\u{d4d}ള M ചിഹ\u{d4d}നം"),
            keywords: &[
                "m",
                "വ\u{d43}ത\u{d4d}തം",
                "വ\u{d43}ത\u{d4d}തത\u{d4d}തില\u{d41}ള\u{d4d}ള M ചിഹ\u{d4d}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөөрөнхий доторх m"),
            keywords: &["m", "бөөрөнхий", "бөөрөнхий доторх m"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर\u{94d}त\u{941}ळात असल\u{947}ल\u{947} m अक\u{94d}षर"),
            keywords: &[
                "m",
                "वर\u{94d}त\u{941}ळ",
                "वर\u{94d}त\u{941}ळात असल\u{947}ल\u{947} M",
                "वर\u{94d}त\u{941}ळात असल\u{947}ल\u{947} m अक\u{94d}षर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("huruf M dibulatkan"),
            keywords: &["bulatan", "huruf M dibulatkan", "m"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ċirku M"),
            keywords: &["m", "ċirku", "ċirku M"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြေအောက\u{103a}ရထား သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "စက\u{103a}ဝ\u{102d}\u{102f}င\u{103a}း သင\u{103a}\u{1039}ကေတ",
                "မြေအောက\u{103a}ရထား သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("M med ring rundt"),
            keywords: &["M med ring rundt", "m", "sirkel"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("एम अक\u{94d}षरको गोलोको अक\u{94d}षर"),
            keywords: &["एम", "एम अक\u{94d}षरको गोलोको अक\u{94d}षर", "गोलो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("M in cirkel"),
            keywords: &["M in cirkel", "cirkel", "m"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("M med ring rundt"),
            keywords: &["M med ring rundt", "m", "sirkel"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b43}ତ\u{b4d}ତ ମଧ\u{b4d}ୟରେ M"),
            keywords: &["m", "ବ\u{b43}ତ\u{b4d}ତ", "ବ\u{b43}ତ\u{b4d}ତ ମଧ\u{b4d}ୟରେ M"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a47}ਰ\u{a47} ਵਿ\u{a71}ਚ ਲਿਖਿਆ ਅ\u{a71}ਖਰ m"),
            keywords: &[
                "m",
                "ਗ\u{a4b}ਲਾ",
                "ਘ\u{a47}ਰ\u{a47} ਵਿ\u{a71}ਚ ਲਿਖਿਆ ਅ\u{a71}ਖਰ m",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دائرہ ش\u{64f}دہ M"),
            keywords: &["m", "دائرہ", "دائرہ ش\u{64f}دہ M"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("M Wé Dẹm Drọ\u{301} Sẹ\u{301}kúl Raúnd Am"),
            keywords: &[
                "M Wé Dẹm Drọ\u{301} Sẹ\u{301}kúl Raúnd Am",
                "Sẹ\u{301}kúl",
                "m",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("koło z literą M"),
            keywords: &["koło z literą M", "kółko", "m", "metro"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دايره ايم"),
            keywords: &["ايم", "دايره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("círculo com a letra M"),
            keywords: &["círculo", "círculo com a letra M", "letra M", "m"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("círculo com letra m"),
            keywords: &["círculo", "círculo com letra m", "m"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("litera M într-un cerc"),
            keywords: &["cerc", "litera M într-un cerc", "m"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-032"),
            keywords: &["E10-032"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("буква «м» в кружке"),
            keywords: &[
                "буква",
                "буква \"м\" в кружке",
                "буква «м» в кружке",
                "буква в кружке",
                "кружок",
                "м",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("M iri mu ruziga"),
            keywords: &["M iri mu ruziga", "m", "uruziga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سرڪل ٿيل M"),
            keywords: &["m، سرڪل", "دائرو", "سرڪل ٿيل M"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රව\u{dd4}ම\u{dca} M"),
            keywords: &["m", "රව\u{dd4}ම", "රව\u{dd4}ම\u{dca} M"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("M v kruhu"),
            keywords: &["M v kruhu", "kruh", "m"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("črka m v krogu"),
            keywords: &["krog", "m", "črka m v krogu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("M goobaysan"),
            keywords: &["M goobaysan", "goobee", "m"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("«M» e rrethuar"),
            keywords: &["m", "rreth", "«M» e rrethuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("слово м у кругу"),
            keywords: &["m", "круг", "слово м у кругу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("slovo m u krugu"),
            keywords: &["krug", "m", "slovo m u krugu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("m i en cirkel"),
            keywords: &["cirkel", "m i en cirkel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("herufi M kwenye mduara"),
            keywords: &["herufi M kwenye mduara", "m", "mduara"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எம\u{bcd}"),
            keywords: &[
                "எம\u{bcd}",
                "சர\u{bcd}க\u{bcd}கிள\u{bcd} எம\u{bcd} லெட\u{bcd}டர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వృత\u{c4d}త\u{c3e}క\u{c3e}రంల\u{c4b} ఎమ\u{c4d} అక\u{c4d}షరం"),
            keywords: &[
                "ఎమ\u{c4d}",
                "వృత\u{c4d}తం",
                "వృత\u{c4d}త\u{c3e}క\u{c3e}రంల\u{c4b} ఎమ\u{c4d} అక\u{c4d}షరం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("М бо давра қайд шуд"),
            keywords: &["m", "М бо давра қайд шуд", "давра"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}วเอ\u{e47}มในวงกลม"),
            keywords: &["ต\u{e31}วเอ\u{e47}ม", "ต\u{e31}วเอ\u{e47}มในวงกลม", "วงกลม"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ዓንኬላዊ M"),
            keywords: &["m", "ዓንኬላ", "ዓንኬላዊ M", "ዓንኬል M"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("halkaly M"),
            keywords: &["halka", "halkaly M", "m"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga M fuopotopoto"),
            keywords: &["M", "fakaʻilonga", "fuopotopoto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("daire içinde M harfi"),
            keywords: &["daire", "daire içinde M harfi", "m"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھالقىلىق M"),
            keywords: &["m", "ھالقا", "ھالقىلىق M"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("коло з літерою «м»"),
            keywords: &["коло", "коло з літерою «м»", "м"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گول M"),
            keywords: &["m", "حرف", "گول", "گول M"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aylana ichidagi m harfi"),
            keywords: &["aylana", "aylana ichidagi m harfi", "m"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chữ M trong vòng tròn"),
            keywords: &["chữ M trong vòng tròn", "m", "vòng tròn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("M bu wërale serkal"),
            keywords: &["M bu wërale serkal", "m", "wërale serkal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("wenze isangqa M"),
            keywords: &["isangqa", "m", "wenze isangqa M"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("M òdo"),
            keywords: &["M òdo", "m", "òdo"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("圓形 M"),
            keywords: &["m", "圓形", "圓形 M"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圆形 M"),
            keywords: &["m", "圆形", "圆形 M"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圆圈包围的M"),
            keywords: &["圆圈包围的M", "圈", "字母", "米"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("M"),
            keywords: &["M"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("圓圈中嘅 M"),
            keywords: &["圓圈中嘅 M"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uhlamvu m olusendingilizini"),
            keywords: &["indingilizi", "m", "uhlamvu m olusendingilizini"],
        },
    ],
};
#[doc = "🆕"]
pub const NEW_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆕",
    codepoint: "1F195",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "NEW button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("NEW-knopie"),
            keywords: &["NEW-knopie", "nuut"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አዲስ ካሬ"),
            keywords: &["አዲስ", "አዲስ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر \"جديد\""),
            keywords: &["new", "جديد", "زر \"جديد\"", "كلمة new في مربع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("NEW ব\u{9c1}ট\u{9be}ম"),
            keywords: &["NEW ব\u{9c1}ট\u{9be}ম", "নত\u{9c1}ন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat yeni"),
            keywords: &["kvadrat yeni", "yeni"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("слова «новы» ў квадраце"),
            keywords: &["новы", "слова «новы» ў квадраце"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„New“ в квадрат"),
            keywords: &["new", "„New“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে নিউ"),
            keywords: &[
                "নত\u{9c1}ন",
                "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে নিউ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton Nevez"),
            keywords: &["NEW", "bouton Nevez", "new"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("novo kvadrat"),
            keywords: &["novo", "novo kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó NEW"),
            keywords: &["New", "botó NEW", "nou", "paraula", "quadre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤᎢ ᎦᏗ"),
            keywords: &["ᎢᏤᎢ", "ᎢᏤᎢ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek NEW"),
            keywords: &["new", "štítek NEW"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm NEW"),
            keywords: &["botwm NEW", "newydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("NEW-knap"),
            keywords: &["NEW-knap", "nyhed", "nyt-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wort „New“ in blauem Quadrat"),
            keywords: &["Neu", "New", "Wort „New“ in blauem Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί NEW"),
            keywords: &["new", "κουμπί NEW", "νέο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("NEW button"),
            keywords: &["NEW button", "new"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón NEW"),
            keywords: &["NEW", "botón", "nuevo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp NEW"),
            keywords: &["nupp NEW", "uus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“new” hitza zirkulu batean"),
            keywords: &["berri", "new", "“new” hitza zirkulu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} NEW"),
            keywords: &["جدید", "دکمه\u{654} NEW", "نو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("NEW"),
            keywords: &["NEW", "laatikko", "teksti", "uusi", "uutta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na NEW"),
            keywords: &["BAGO", "button na NEW", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("NEW knappur"),
            keywords: &["NEW knappur", "knappur", "knøttur", "new"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Nouveau"),
            keywords: &["bouton Nouveau", "nouveau"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bouton NEW", "bouton Nouveau", "new", "nouveau"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe NUA"),
            keywords: &["cnaipe NUA", "comhartha", "nua"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan NEW"),
            keywords: &["putan NEW", "ùr"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"novo\" en inglés"),
            keywords: &["botón \"novo\" en inglés", "new", "novo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોરસમા\u{a82} નવાન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ચિહ\u{acd}ન",
                "ચોરસમા\u{a82} નવાન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "નવાન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "નવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin SABO"),
            keywords: &["maɓallin SABO", "sabo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן NEW"),
            keywords: &["חדש", "לחצן NEW"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} नया चिह\u{94d}न"),
            keywords: &["NEW बटन", "चौकोर म\u{947}\u{902} नया चिह\u{94d}न", "नया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka NEW"),
            keywords: &["new", "tipka NEW"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("NEW gomb"),
            keywords: &["NEW gomb", "new"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ՆՈՐ բառը ուղղանկյունի մեջ"),
            keywords: &["ՆՈՐ բառը ուղղանկյունի մեջ", "նոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol NEW"),
            keywords: &["baru", "tombol NEW"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ỌDỤMBI ọhụrụ"),
            keywords: &["ỌDỤMBI ọhụrụ", "ọhụrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nýtt"),
            keywords: &["nýtt", "nýtt-skilti", "skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante NEW"),
            keywords: &["pulsante NEW", "simbolo New"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("NEWマーク"),
            keywords: &["NEW", "NEWマーク", "新しい"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol NEW"),
            keywords: &["new", "tombol NEW"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი NEW"),
            keywords: &["ახალი", "ღილაკი NEW"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("NEW түймесі"),
            keywords: &["NEW түймесі", "жаңа"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nyt"),
            keywords: &["nyhed", "nyt", "nyt-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ NEW"),
            keywords: &[
                "NEW",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ NEW",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೊಸ ಬಟನ\u{ccd}"),
            keywords: &["ಹೊಸ", "ಹೊಸ ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뉴"),
            keywords: &[
                "NEW",
                "뉴",
                "뉴 신호",
                "새로운",
                "새로운 소식",
                "새로운 신호",
                "새롭다",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नवो बटण"),
            keywords: &["नवो", "नवो बटण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("NEW баскычы"),
            keywords: &["NEW баскычы", "жаңы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("NEI-Knäppchen"),
            keywords: &["NEI-Knäppchen", "nei"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃໝ\u{ec8}"),
            keywords: &["ສ\u{eb1}ນຍາລ\u{eb1}ກ", "ໃໝ\u{ec8}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „NEW“"),
            keywords: &["new", "simbolis „NEW“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts New kvadrātveida ietvarā"),
            keywords: &["jauns", "new", "uzraksts New kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene HŌU"),
            keywords: &["hōu", "pātene HŌU"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче ЊУ"),
            keywords: &["копче ЊУ", "ново"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d41}തിയത\u{d4d} എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചത\u{d41}രം",
            ),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "പ\u{d41}തിയ ചിഹ\u{d4d}നം",
                "പ\u{d41}തിയത\u{d4d}",
                "പ\u{d41}തിയത\u{d4d} എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചത\u{d41}രം",
                "പ\u{d41}ത\u{d4d}തൻ",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("NEW товчлуур"),
            keywords: &["NEW товчлуур", "шинэ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस नवीन"),
            keywords: &["NEW बटण", "चौरस नवीन", "नवीन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang NEW"),
            keywords: &["baharu", "butang NEW"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna NEW"),
            keywords: &["buttuna NEW", "new"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသစ\u{103a} ခလ\u{102f}တ\u{103a}"),
            keywords: &["အသစ\u{103a}", "အသစ\u{103a} ခလ\u{102f}တ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("NEW-knapp"),
            keywords: &["NEW-knapp", "new", "new-symbol", "ny", "nyhet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड नया\u{901}"),
            keywords: &["नया\u{901}", "स\u{94d}क\u{94d}वायर\u{94d}ड नया\u{901}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("NEW-knop"),
            keywords: &["NEW-knop", "nieuw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("NEW-knapp"),
            keywords: &["NEW-knapp", "new", "new-symbol", "ny", "nyhende"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b42}ତନ ବଟନ\u{b4d}\u{200c}"),
            keywords: &["ନ\u{b42}ତନ", "ନ\u{b42}ତନ ବଟନ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਰਗਾਕਾਰ ਨਵਾ\u{a02} ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਨਵਾ\u{a02}",
                "ਨਵਾ\u{a02} ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਵਰਗਾਕਾਰ ਨਵਾ\u{a02} ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نواں بٹن"),
            keywords: &["نواں", "نواں بٹن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("NEW Bọ\u{301}tin"),
            keywords: &["NEW Bọ\u{301}tin", "New", "Niu"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk NEW"),
            keywords: &["NEW", "nowość", "nowy", "przycisk NEW"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نوې بټن"),
            keywords: &["نوې", "نوې بټن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão \"NEW\""),
            keywords: &["Novo", "botão \"NEW\"", "new"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão NEW"),
            keywords: &["botão NEW", "new", "novo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu textul NEW"),
            keywords: &["buton cu textul NEW", "nou"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-178"),
            keywords: &["E10-178"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «новинка»"),
            keywords: &[
                "значок",
                "значок \"новинка\"",
                "значок «новинка»",
                "новинка",
                "новое",
                "новый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya NEW"),
            keywords: &["buto ya NEW", "nshya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نئون بٽڻ"),
            keywords: &["نئون", "نئون بٽڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රව\u{dd4}ම\u{dca} new"),
            keywords: &["new", "රව\u{dd4}ම\u{dca} new"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok NEW"),
            keywords: &["new", "štítok NEW"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb NEW"),
            keywords: &["gumb NEW", "novo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka CUSUB"),
            keywords: &["badhanka CUSUB", "cusub"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «NEW»"),
            keywords: &["buton", "butoni «NEW»", "i ri", "new"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме NEW"),
            keywords: &["new", "дугме NEW"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme NEW"),
            keywords: &["dugme NEW", "new"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("NEW-knapp"),
            keywords: &["NEW-knapp", "Nyhet", "nyhetssymbol", "symbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye neno ‘NEW’"),
            keywords: &["kitufe chenye neno ‘NEW’", "mpya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நியு"),
            keywords: &["நியு", "புதிய சின\u{bcd}னம\u{bcd}", "புதியது"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4a}త\u{c4d}తద\u{c3f} బటన\u{c4d}"),
            keywords: &[
                "క\u{c4a}త\u{c4d}తద\u{c3f} చ\u{c3f}హ\u{c4d}నం",
                "క\u{c4a}త\u{c4d}తద\u{c3f} బటన\u{c4d}",
                "గుర\u{c4d}తు",
                "సర\u{c3f}క\u{c4a}త\u{c4d}త",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"НАВ\""),
            keywords: &["нав", "тугмаи \"НАВ\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใหม\u{e48}"),
            keywords: &["ส\u{e31}ญล\u{e31}กษณ\u{e4c}ใหม\u{e48}", "ใหม\u{e48}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ሓዲሽ መልጎም"),
            keywords: &["ሓዲሽ", "ሓዲሽ መልጎም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("NEW düwmesi"),
            keywords: &["NEW düwmesi", "täze"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi NEW"),
            keywords: &["NEW", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("NEW düğmesi"),
            keywords: &["NEW düğmesi", "Yeni işareti", "işaret", "yeni"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("«يېڭى» كۇنۇپكىسى"),
            keywords: &["«يېڭى» كۇنۇپكىسى", "يېڭى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"NEW\""),
            keywords: &["квадрат «новий»", "кнопка \"NEW\"", "новий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیا بٹن"),
            keywords: &["نیا", "نیا بٹن", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi yangi so‘zi"),
            keywords: &["kvadrat ichidagi yangi so‘zi", "yangi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút NEW"),
            keywords: &["new", "nút NEW"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu BEES"),
            keywords: &["bees", "bitoŋu BEES"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi ENTSHA"),
            keywords: &["entsha", "iqhosha elithi ENTSHA"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini TUNTUN"),
            keywords: &["Bọtini TUNTUN", "tuntun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("NEW 按鈕"),
            keywords: &["NEW 按鈕", "new"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("NEW 按钮"),
            keywords: &["NEW 按钮", "new"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("new按钮"),
            keywords: &["new按钮", "按键", "新的"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("新"),
            keywords: &["新"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("NEW 按鈕"),
            keywords: &["NEW 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ENTSHA"),
            keywords: &["inkinobho ENTSHA", "okusha"],
        },
    ],
};
#[doc = "🆖"]
pub const NG_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆖",
    codepoint: "1F196",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "NG button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("NG-knopie"),
            keywords: &["NG", "NG-knopie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤንጂ ካሬ"),
            keywords: &["ኤንጂ", "ኤንጂ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر \"غير جيد\""),
            keywords: &["ng", "ng في مربع", "زر \"غير جيد\""],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("NG ব\u{9c1}ট\u{9be}ম"),
            keywords: &["NG ব\u{9c1}ট\u{9be}ম", "এনজি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat ng"),
            keywords: &["kvadrat ng", "ng"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скарачэнне «нічога добрага» ў квадраце"),
            keywords: &[
                "блага",
                "дрэнна",
                "нічога добрага",
                "скарачэнне «нічога добрага» ў квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Ng“ в квадрат"),
            keywords: &["ng", "„Ng“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে এন জি"),
            keywords: &[
                "এনজি চিহ\u{9cd}ন",
                "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে এন জি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ng kvadrat"),
            keywords: &["ng", "ng kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó NG"),
            keywords: &["NG", "botó NG", "paraula", "quadre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("NG ᎦᏗ"),
            keywords: &["NG ᎦᏗ", "ng"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek NG"),
            keywords: &["ng", "štítek NG"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm NG"),
            keywords: &["botwm NG", "ng"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("NG-knap"),
            keywords: &["NG-knap", "NG-tegn", "ikke godt-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstaben NG in blauem Quadrat"),
            keywords: &["Großbuchstaben NG in blauem Quadrat", "NG"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstaben NG in blauem Quadrat"),
            keywords: &["Grossbuchstaben NG in blauem Quadrat", "NG"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί NG"),
            keywords: &["ng", "κουμπί NG"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("NG button"),
            keywords: &["NG button", "ng"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón NG"),
            keywords: &["botón", "botón NG", "ng", "nuevo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["NG", "botón NG", "no good"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp NG"),
            keywords: &["ng", "nupp NG"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“ng” testua karratu batean"),
            keywords: &["ng", "“ng” testua karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} NG"),
            keywords: &["ng", "خوب نیست", "دکمه\u{654} NG"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("NG"),
            keywords: &["NG", "good", "moka", "ng", "no", "teksti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na NG"),
            keywords: &["NG", "button na NG", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("NG knappur"),
            keywords: &["NG knappur", "knappur", "knøttur", "ng"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Pas bien"),
            keywords: &["bouton Pas bien", "interdit", "mauvais"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "NG",
                "bouton NG",
                "bouton Pas bien",
                "no go",
                "not good",
                "pas bien",
                "pas bon",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("NG"),
            keywords: &["NG", "comhartha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan NG"),
            keywords: &["ng", "putan NG"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"mal\" en inglés"),
            keywords: &["NG", "botón \"mal\" en inglés", "mal", "non conforme"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોરસમા\u{a82} ઠીક નહી\u{a82}ન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "NG",
                "ચિહ\u{acd}ન",
                "ચોરસમા\u{a82} ઠીક નહી\u{a82}ન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin NG"),
            keywords: &["maɓallin NG", "ng"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן NG"),
            keywords: &["ng", "לחצן NG"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} ठीक नही\u{902} चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चौकोर म\u{947}\u{902} ठीक नही\u{902} चिह\u{94d}न",
                "ठीक नही\u{902}",
                "ठीक नही\u{902} चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka NG"),
            keywords: &["ng", "tipka NG"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("NG gomb"),
            keywords: &["NG gomb", "ng"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էն-ջի"),
            keywords: &["ng", "էն-ջի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol NG"),
            keywords: &["ng", "tombol NG", "tombol ng"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ỌDỤMBI ng"),
            keywords: &["ng", "ỌDỤMBI ng"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("NG"),
            keywords: &["NG", "NG-skilti", "skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante NG"),
            keywords: &["pulsante NG", "simbolo NG"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("NGマーク"),
            keywords: &["NG", "NGマーク", "エヌジー", "ボツ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol NG"),
            keywords: &["ng", "tombol NG"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი NG"),
            keywords: &["ng", "ღილაკი NG"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("NG түймесі"),
            keywords: &["NG түймесі", "ng"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ikke godt"),
            keywords: &["NG-tegn", "ikke godt", "ikke godt-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ NG"),
            keywords: &[
                "NG",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ NG",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎನ\u{ccd}\u{200c}ಜ\u{cbf} ಬಟನ\u{ccd}"),
            keywords: &[
                "ಎನ\u{ccd}\u{200c}ಜ\u{cbf}",
                "ಎನ\u{ccd}\u{200c}ಜ\u{cbf} ಬಟನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엔지"),
            keywords: &["NG", "노굿", "노굿 신호", "엔지", "엔지 신호", "엔지 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("NG बटण"),
            keywords: &["NG बटण", "ng"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("NG баскычы"),
            keywords: &["NG баскычы", "ng"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("NG-Knäppchen"),
            keywords: &["NG", "NG-Knäppchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ng ໃນຮ\u{eb9}ບສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ"),
            keywords: &[
                "ng",
                "ng ໃນຮ\u{eb9}ບສ\u{eb5}\u{ec8}ຫ\u{ebc}\u{ec8}ຽມ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „NG“"),
            keywords: &["ng", "simbolis „NG“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts NG kvadrātveida ietvarā"),
            keywords: &["NG", "uzraksts NG kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene NG"),
            keywords: &["ng", "pātene NG"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче НГ"),
            keywords: &["копче НГ", "негатив"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "നല\u{d4d}ലതല\u{d4d}ല എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചത\u{d41}ര NG",
            ),
            keywords: &[
                "എൻജി",
                "ചിഹ\u{d4d}നം",
                "നല\u{d4d}ലതല\u{d4d}ല",
                "നല\u{d4d}ലതല\u{d4d}ല എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചത\u{d41}ര NG",
                "മോശം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("NG товчлуур"),
            keywords: &["NG товчлуур", "ng"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस ब\u{947}कार"),
            keywords: &["NG बटण", "ng", "चौरस ब\u{947}कार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang NG"),
            keywords: &["butang NG", "ng"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna NG"),
            keywords: &["buttuna NG", "ng"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မကောင\u{103a}းပါ ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "မကောင\u{103a}းပါ ခလ\u{102f}တ\u{103a}",
                "အင\u{103a}\u{1039}ဂလ\u{102d}ပ\u{103a} အက\u{1039}ခရာ အန\u{103a}ဂျ\u{102e} ပါ ခလ\u{102f}တ\u{103a}",
                "အမ\u{103e}ားပြ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("NG-knapp"),
            keywords: &["NG", "NG-knapp", "NG-symbol", "ikke bra", "no good"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड एनजी"),
            keywords: &["एनजी", "स\u{94d}क\u{94d}वायर\u{94d}ड एनजी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("NG-knop"),
            keywords: &["NG-knop", "ng"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("NG-knapp"),
            keywords: &["NG", "NG-knapp", "NG-symbol", "ikkje bra", "no good"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("NG ବଟନ\u{b4d}\u{200c}"),
            keywords: &["NG ବଟନ\u{b4d}\u{200c}", "ng"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("NG ਬਟਨ"),
            keywords: &["NG", "NG ਬਟਨ", "ਚਿ\u{a70}ਨ\u{a4d}ਹ", "ਨਿਸ\u{a3c}ਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("NG بٹن"),
            keywords: &["NG بٹن", "ng"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("NG Bọ\u{301}tin"),
            keywords: &["NG Bọ\u{301}tin", "ng"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk NG"),
            keywords: &["NG", "niedobrze", "przycisk NG", "źle"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اين جي بټن"),
            keywords: &["اين جي", "اين جي بټن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão NG"),
            keywords: &["NG", "botão NG"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão NG"),
            keywords: &["botão NG", "ng"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton NG"),
            keywords: &["buton NG", "ng"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-179"),
            keywords: &["E10-179"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «не годится»"),
            keywords: &[
                "значок",
                "значок \"не годится\"",
                "значок «не годится»",
                "не годится",
                "нехорошо",
                "плохо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya"),
            keywords: &["buto ya", "ng"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("NG بٽڻ"),
            keywords: &["NG بٽڻ", "ng"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} ng"),
            keywords: &["ng", "හතරැස\u{dca} ng"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok NG"),
            keywords: &["ng", "štítok NG"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb NG"),
            keywords: &["gumb NG", "ng"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka NG"),
            keywords: &["badhanka NG", "ng"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «NG»"),
            keywords: &["buton", "butoni «NG»", "jo mirë", "ng"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме NG"),
            keywords: &["ng", "дугме NG"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme NG"),
            keywords: &["dugme NG", "ng"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("NG-knapp"),
            keywords: &["NG-knapp", "inte bra", "inte bra-symbol", "symbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye herufi NG"),
            keywords: &["kitufe chenye herufi NG", "ng"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("என\u{bcd}ஜி"),
            keywords: &["என\u{bcd}ஜி", "சரியல\u{bcd}ல", "போக\u{bbe}தே"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చతురస\u{c4d}రంల\u{c4b} ఎన\u{c4d}\u{200c}జ\u{c3f} అక\u{c4d}షర\u{c3e}లు"),
            keywords: &[
                "ఎన\u{c4d}\u{200c}జ\u{c3f}",
                "ఎన\u{c4d}\u{200c}జ\u{c3f} అక\u{c4d}షర\u{c3e}లు",
                "ఎన\u{c4d}\u{200c}జ\u{c3f} గుర\u{c4d}తు",
                "చతురస\u{c4d}రంల\u{c4b} ఎన\u{c4d}\u{200c}జ\u{c3f} అక\u{c4d}షర\u{c3e}లు",
                "ప\u{c4d}రమ\u{c3e}ద సంక\u{c47}తం",
                "మంచ\u{c3f}ద\u{c3f} క\u{c3e}దు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"NG\""),
            keywords: &["ng", "тугмаи \"NG\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ป\u{e38}\u{e48}มเอ\u{e47}นจ\u{e35}"),
            keywords: &["ป\u{e38}\u{e48}มเอ\u{e47}นจ\u{e35}", "เอ\u{e47}นจ\u{e35}"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("NG መልጎም"),
            keywords: &["NG መልጎም", "ng"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("NG düwmesi"),
            keywords: &["NG düwmesi", "ng"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi NG"),
            keywords: &["NG", "meʻalolomi", "Ŋ"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("NG düğmesi"),
            keywords: &["NG düğmesi", "NG işareti", "işaret", "ng"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("NG كۇنۇپكىسى"),
            keywords: &["NG كۇنۇپكىسى", "ng"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"NG\""),
            keywords: &["квадрат «негативно»", "кнопка \"NG\"", "негативно"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("NG بٹن"),
            keywords: &["NG بٹن", "ng", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi ng harflari"),
            keywords: &["kvadrat ichidagi ng harflari", "ng"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút NG"),
            keywords: &["ng", "nút NG"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu NG"),
            keywords: &["bitoŋu NG", "ng"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi NG"),
            keywords: &["iqhosha elithi NG", "ng"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini NG"),
            keywords: &["Bọtini NG", "ng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("NG 按鈕"),
            keywords: &["NG 按鈕", "ng"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("NG 按钮"),
            keywords: &["NG 按钮", "ng"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("NG按钮"),
            keywords: &["NG按钮", "按键", "花絮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("NG"),
            keywords: &["NG"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("NG 按鈕"),
            keywords: &["NG 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho ka-NG"),
            keywords: &["inkinobho ka-NG", "ng"],
        },
    ],
};
#[doc = "🅾\u{fe0f}"]
pub const O_BUTTON_BLOOD_TYPE: crate::Emoji = crate::Emoji {
    glyph: "🅾\u{fe0f}",
    codepoint: "1F17E FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "O button (blood type)",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🅾",
        codepoint: "1F17E",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "O button (blood type)",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("O-knopie (bloedgroep)"),
            keywords: &["O", "O-knopie (bloedgroep)", "bloedgroep"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦ አዝራር"),
            keywords: &["ኦ", "ኦ አዝራር", "ደም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر O"),
            keywords: &["زر O", "فصيلة أو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("O ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)"),
            keywords: &[
                "O ব\u{9c1}ট\u{9be}ম (ৰক\u{9cd}ত-বৰ\u{9cd}গ)",
                "o",
                "ৰক\u{9cd}ত-বৰ\u{9cd}গ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("o düyməsi"),
            keywords: &["o", "o düyməsi", "qan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("значок «група крыві 0»"),
            keywords: &["0", "група", "значок «група крыві 0»", "кроў", "першая"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бутон с „O“"),
            keywords: &["[o]", "Бутон с „O“", "кръв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ও বোত\u{9be}ম"),
            keywords: &[
                "ইংর\u{9be}জী ‘ও’ চিহ\u{9cd}ন",
                "ও বোত\u{9be}ম",
                "রক\u{9cd}ত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton O (rumm-gwad)"),
            keywords: &["O", "bouton O", "bouton O (rumm-gwad)", "o", "rumm-gwad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dugme o"),
            keywords: &["dugme o", "krvna grupa", "o"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó O (grup sanguini)"),
            keywords: &["O", "botó", "botó O (grup sanguini)"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("O ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎤᏁᎲᎢ)"),
            keywords: &[
                "O ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ)",
                "O ᎦᏗ (ᎢᏳᏍᏗ ᎩᎦ ᎤᏁᎲᎢ)",
                "o",
                "ᎢᏳᏍᏗ ᎩᎦ ᎣᏁᎲᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek 0 (krevní skupina)"),
            keywords: &["0", "krev", "o", "štítek 0 (krevní skupina)"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm O (grwp gwaed)"),
            keywords: &["botwm O (grwp gwaed)", "gwaed", "o"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blodtype O"),
            keywords: &["O", "blod", "blodtype", "type O"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstabe O in rotem Quadrat"),
            keywords: &[
                "0",
                "Blut",
                "Blutgruppe",
                "Großbuchstabe O in rotem Quadrat",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstabe O in Quadrat"),
            keywords: &[
                "0",
                "Blut",
                "Blutgruppe",
                "Grossbuchstabe O in Quadrat",
                "negativ",
                "positiv",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί O (ομάδα αίματος)"),
            keywords: &["o", "κουμπί O (ομάδα αίματος)", "ομάδα αίματος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("O button (blood type)"),
            keywords: &["O button (blood type)", "blood type", "o"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("grupo sanguíneo tipo O"),
            keywords: &["grupo sanguíneo", "grupo sanguíneo tipo O", "o"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp 0 (veregrupp)"),
            keywords: &["nupp 0 (veregrupp)", "o", "punane", "veri"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“o” botoia"),
            keywords: &["o", "odol", "“o” botoia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه ا\u{64f} (گروه خونی)"),
            keywords: &["ا\u{64f}", "دکمه ا\u{64f} (گروه خونی)", "گروه خونی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("O-veriryhmä"),
            keywords: &["O-veriryhmä", "o", "veriryhmä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na O"),
            keywords: &["O", "button na O", "dugo", "pindutan", "uri"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("O knappur (blóðflokkur)"),
            keywords: &[
                "O knappur (blóðflokkur)",
                "blóðflokkur",
                "blóðtypa",
                "knappur",
                "knøttur",
                "o",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("groupe sanguin O"),
            keywords: &["O", "groupe sanguin", "groupe sanguin O"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["O", "groupe sanguin", "groupe sanguin O"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fuilghrúpa O"),
            keywords: &["O", "fuil", "fuilghrúpa", "grúpa O"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Putan O (seòrsa fala)"),
            keywords: &["Putan O (seòrsa fala)", "fuil", "o", "seòrsa fala"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("grupo sanguíneo O"),
            keywords: &["O", "grupo", "sanguíneo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લોહીનો પ\u{acd}રકાર O"),
            keywords: &[
                "O",
                "પ\u{acd}રકાર O",
                "લોહી",
                "લોહીનો પ\u{acd}રકાર",
                "લોહીનો પ\u{acd}રકાર O",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin O (irin jini)"),
            keywords: &["irin jini", "maɓallin O (irin jini)", "o"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן O (סוג דם)"),
            keywords: &["o", "לחצן O (סוג דם)", "סוג דם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("O बटन (ख\u{942}न का प\u{94d}रकार)"),
            keywords: &[
                "O बटन (ख\u{942}न का प\u{94d}रकार)",
                "ओ",
                "ख\u{942}न",
                "चौकोर म\u{947}\u{902} ओ बटन",
                "प\u{94d}रकार ओ",
                "रक\u{94d}त प\u{94d}रकार",
                "रक\u{94d}त प\u{94d}रकार ओ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka krvne grupe 0"),
            keywords: &["0", "krv", "tipka krvne grupe 0"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("0 gomb (vércsoport)"),
            keywords: &["0", "0 gomb (vércsoport)", "vércsoport"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օ կոճակ"),
            keywords: &["o", "արյուն", "օ կոճակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol O (golongan darah)"),
            keywords: &[
                "golongan darah",
                "o",
                "tombol O (golongan darah)",
                "tombol o (golongan darah)",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("O ọdụmbi (ụdị ọbara)"),
            keywords: &["O ọdụmbi (ụdị ọbara)", "o", "ụdị ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("O-blóðflokkur"),
            keywords: &["O", "O-blóðflokkur", "blóð", "blóðflokkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gruppo sanguigno 0"),
            keywords: &["gruppo 0", "gruppo sanguigno 0"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("血液型O型"),
            keywords: &["O型", "血液型", "血液型O型"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol O [golongane getih]"),
            keywords: &["golongane getih", "o", "tombol O [golongane getih]"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი O (სისხლის ტიპი)"),
            keywords: &["o", "სისხლი", "ღილაკი O (სისხლის ტიპი)"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("O түймесі (қызыл түсті)"),
            keywords: &["O түймесі (қызыл түсті)", "o", "қызыл түсті"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blodtype O"),
            keywords: &["O", "blod", "blodtype", "type O"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ O ធ\u{17c6}"),
            keywords: &[
                "O",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ O ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಓ ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ವ\u{cbf}ಧ)"),
            keywords: &[
                "ಒ",
                "ಓ ಬಟನ\u{ccd} (ರಕ\u{ccd}ತದ ವ\u{cbf}ಧ)",
                "ರಕ\u{ccd}ತದ ಪ\u{ccd}ರಕಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오형"),
            keywords: &["O", "오형", "혈액형 오형"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("O बटण (रक\u{94d}ताचो गट)"),
            keywords: &["O बटण (रक\u{94d}ताचो गट)", "o", "रक\u{94d}ताचो गट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("о баскычы"),
            keywords: &["кызыл", "о", "о баскычы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("O-Knäppchen (Bluttgrupp)"),
            keywords: &["Bluttgrupp", "O", "O-Knäppchen (Bluttgrupp)"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເລ\u{eb7}ອກກ\u{eb8}\u{ec8}ມໂອ"),
            keywords: &[
                "ກ\u{eb8}\u{ec8}ມໂອ",
                "ເລ\u{eb7}ອກກ\u{eb8}\u{ec8}ມໂອ",
                "ເລ\u{eb7}ອດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „O“ (raudona)"),
            keywords: &["o", "raudona", "simbolis „O“ (raudona)"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("O poga (asinsgrupa)"),
            keywords: &["O", "O poga (asinsgrupa)", "asinsgrupa", "poga O"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene O (momo toto)"),
            keywords: &["momo toto", "o", "pātene O (momo toto)"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче О (крвна група)"),
            keywords: &["О", "група", "копче О (крвна група)", "крв"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("O രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം"),
            keywords: &[
                "O രക\u{d4d}തഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം",
                "ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} എ",
                "ചിഹ\u{d4d}നം",
                "ബ\u{d4d}ലഡ\u{d4d} ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} ഒ",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d}",
                "രക\u{d4d}ത ഗ\u{d4d}ര\u{d42}പ\u{d4d}പ\u{d4d} O",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("О товчлуур (цусны бүлэг)"),
            keywords: &["О товчлуур (цусны бүлэг)", "о", "цусны бүлэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("o बटण"),
            keywords: &[
                "O बटण (रक\u{94d}ताचा प\u{94d}रकार)",
                "o",
                "o बटण",
                "रक\u{94d}ताचा प\u{94d}रकार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang O (jenis darah)"),
            keywords: &["butang O (jenis darah)", "darah", "o"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna O (tip tad-demm)"),
            keywords: &["buttuna O (tip tad-demm)", "o", "tip tad-demm"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အ\u{102d}\u{102f} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
            ),
            keywords: &[
                "သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား",
                "အ\u{102d}\u{102f}",
                "အ\u{102d}\u{102f} သင\u{103a}\u{1039}ကေတ (သ\u{103d}ေးအမျ\u{102d}\u{102f}းအစား)",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("O-knapp (blodtype)"),
            keywords: &["O", "O-knapp (blodtype)", "blod", "blodtype", "type O"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("0 बटन"),
            keywords: &["0", "0 बटन", "रगत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bloedgroep O"),
            keywords: &["bloedgroep", "bloedgroep O", "o"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("O-knapp (blodtype)"),
            keywords: &["O", "O-knapp (blodtype)", "blod", "blodtype", "type O"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("O ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)"),
            keywords: &[
                "O ବଟନ\u{b4d}\u{200c} (ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର)",
                "o",
                "ରକ\u{b4d}ତ ପ\u{b4d}ରକ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("O ਬਟਨ"),
            keywords: &[
                "O",
                "O ਬਟਨ",
                "ਕਿਸਮ O",
                "ਖ\u{a42}ਨ",
                "ਖ\u{a42}ਨ ਕਿਸਮ",
                "ਖ\u{a42}ਨ ਕਿਸਮ O",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("O دا بٹن (خون دی قسم)"),
            keywords: &["O دا بٹن (خون دی قسم)", "o", "خون دی ق\u{650}سم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("O Bọ\u{301}tin (Blọ\u{301}d Taip)"),
            keywords: &["Blọ\u{301}d Taip", "O Bọ\u{301}tin (Blọ\u{301}d Taip)", "o"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("grupa krwi 0"),
            keywords: &["0", "grupa 0", "grupa krwi 0", "krew"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("او بټن (د وینې ډول)"),
            keywords: &[
                "او",
                "او بټن (د وينې ډول)",
                "او بټن (د وینې ډول)",
                "د وينې ډول",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão O (tipo sanguíneo)"),
            keywords: &[
                "O",
                "botão O (tipo sanguíneo)",
                "sangue",
                "tipo O",
                "tipo sanguíneo",
                "tipo sanguíneo O",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão O (tipo de sangue)"),
            keywords: &[
                "0",
                "botão 0 (tipo de sangue)",
                "botão O (tipo de sangue)",
                "sangue",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton 0 (grupă sanguină)"),
            keywords: &["0", "buton 0 (grupă sanguină)", "grupă sanguină"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-171"),
            keywords: &["E10-171"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("I группа крови"),
            keywords: &[
                "1 группа крови",
                "I группа крови",
                "группа крови",
                "кровь",
                "первая группа крови",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya O (ubwoko bw’amaraso)"),
            keywords: &["buto ya O (ubwoko bw’amaraso)", "bw’amaraso", "ubwoko"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("O بٽڻ (رت جو قسم)"),
            keywords: &["O بٽڻ (رت جو قسم)", "o", "رت جو قسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("o බොත\u{dca}තම"),
            keywords: &["o", "o බොත\u{dca}තම", "ර\u{dd4}ධ\u{dd2}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok 0"),
            keywords: &["krv", "o", "štítok 0"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s črko O (krvna skupina)"),
            keywords: &["gumb s črko O (krvna skupina)", "kri", "o"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka O (nooca dhiigga)"),
            keywords: &["badhanka O (nooca dhiigga)", "nooca dhiigga", "o"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «O»"),
            keywords: &["butoni «O»", "grup gjaku", "o"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме o"),
            keywords: &["0", "дугме 0 (крвна група)", "дугме o", "крвна група"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["дугме o"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme o"),
            keywords: &["0", "dugme 0 (krvna grupa)", "dugme o", "krvna grupa"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dugme o"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blodgrupp 0"),
            keywords: &["blodgrupp 0", "typ 0"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha O"),
            keywords: &["damu", "kitufe cha O", "o"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரத\u{bcd}த வகை O"),
            keywords: &["O குரூப\u{bcd}", "இரத\u{bcd}த வகை", "இரத\u{bcd}த வகை O"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఓ బటన\u{c4d} (రక\u{c4d}తం రకం)"),
            keywords: &[
                "ఓ",
                "ఓ బటన\u{c4d} (రక\u{c4d}తం రకం)",
                "ఓ బ\u{c4d}లడ\u{c4d} గ\u{c4d}రూప\u{c4d}",
                "ఓ రకం",
                "రక\u{c4d}త వర\u{c4d}గం ఓ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"О\" (гуруҳи хун)"),
            keywords: &["гуруҳи хун", "о", "тугмаи \"О\" (гуруҳи хун)"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เล\u{e37}อดกร\u{e38}\u{e4a}ปโอ"),
            keywords: &[
                "กร\u{e38}\u{e4a}ปเล\u{e37}อด",
                "กร\u{e38}\u{e4a}ปโอ",
                "เล\u{e37}อดกร\u{e38}\u{e4a}ปโอ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("O መልጎም (ዓይነት ደም)"),
            keywords: &["O መልጎም (ዓይነት ደም)", "o", "ዓይነት ደም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("O düwmesi (gan topary)"),
            keywords: &["O düwmesi (gan topary)", "gan topary", "o"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi faʻahinga toto O"),
            keywords: &[
                "O",
                "faʻahinga toto",
                "meʻalolomi",
                "meʻalolomi faʻahinga toto O",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("0 düğmesi (kan grubu)"),
            keywords: &[
                "0 düğmesi (kan grubu)",
                "O",
                "O grubu kan",
                "kan",
                "kan grubu",
                "kan grubu O",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("O كۇنۇپكىسى (قان تىپى)"),
            keywords: &["O كۇنۇپكىسى (قان تىپى)", "o", "قان تىپى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка «І група крові»"),
            keywords: &[
                "4",
                "iv",
                "o",
                "кнопка «І група крові»",
                "кнопка «група крові o»",
                "кров",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("O بٹن (خون کی قسم)"),
            keywords: &["O بٹن (خون کی قسم)", "o", "بٹن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o tugmasi"),
            keywords: &["o", "o tugmasi", "qon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút O (nhóm máu)"),
            keywords: &["nhóm máu", "nút O (nhóm máu)", "o"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋ O (xeetu deret)"),
            keywords: &["bitoŋ O (xeetu deret)", "o", "xeetu deret"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi O (uhlobo lwegazi)"),
            keywords: &["iqhosha elithi O (uhlobo lwegazi)", "o", "uhlobo lwegazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọ\u{301}tìnì O (irúfé\u{329} èjè)"),
            keywords: &[
                "Bọ\u{301}tìnì O (irúfé\u{329} èjè)",
                "irúfé\u{329} èjè",
                "o",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("O 按鈕 (血型)"),
            keywords: &["O 按鈕 (血型)", "o", "血型"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("O 按钮 (血型)"),
            keywords: &["O 按钮 (血型)", "o", "血型"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("O 型血"),
            keywords: &["O 型血", "O型血", "o", "按钮", "血液"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("O型"),
            keywords: &["O型", "血型"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("O型血"),
            keywords: &["O型血", "血型"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho o"),
            keywords: &["igazi", "inkinobho o", "o"],
        },
    ],
};
#[doc = "🆗"]
pub const OK_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆗",
    codepoint: "1F197",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "OK button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("OK-knopie"),
            keywords: &["OK-knopie", "oukei"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኦኬ ካሬ"),
            keywords: &["እሺ", "ኦኬ ካሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر \"موافق\""),
            keywords: &["ok", "ok في مربع", "زر \"موافق\"", "موافق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("OK ব\u{9c1}ট\u{9be}ম"),
            keywords: &["OK ব\u{9c1}ট\u{9be}ম", "ঠিক আছে"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat ok"),
            keywords: &["kvadrat ok", "ok"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ОК у квадраце"),
            keywords: &["ОК", "ОК у квадраце", "добра"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Окей“ в квадрат"),
            keywords: &["ok", "окей", "„Окей“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে ওকে"),
            keywords: &["ঠিক আছে", "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে ওকে"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton OK"),
            keywords: &["OK", "bouton OK", "ok"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ok kvadrat"),
            keywords: &["ok", "ok kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó OK"),
            keywords: &["OK", "botó OK", "d’acord", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏏᏊ ᎦᏗ"),
            keywords: &["ᎣᏏᏊ", "ᎣᏏᏊ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek OK"),
            keywords: &["ok", "štítek OK"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm OK"),
            keywords: &["botwm OK", "ocê"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("OK"),
            keywords: &["OK", "OK-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstaben OK in blauem Quadrat"),
            keywords: &["Großbuchstaben OK in blauem Quadrat", "OK"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstaben OK in blauem Quadrat"),
            keywords: &["Grossbuchstaben OK in blauem Quadrat", "OK"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί OK"),
            keywords: &["OK", "κουμπί OK"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("OK button"),
            keywords: &["OK", "OK button"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón OK"),
            keywords: &["botón", "botón OK", "ok"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp OK"),
            keywords: &["nupp OK", "ok"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“ok” testua karratu batean"),
            keywords: &["ados", "ok", "“ok” testua karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} OK"),
            keywords: &["تأیید", "دکمه اوکی", "دکمه\u{654} OK", "قبول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("OK"),
            keywords: &["OK", "laatikko", "okay", "okei", "selvä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na OK"),
            keywords: &["OK", "button na OK", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("OK knappur"),
            keywords: &["OK knappur", "knappur", "knøttur", "ok"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton OK"),
            keywords: &["OK", "bouton OK"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["OK", "bouton OK"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe OK"),
            keywords: &["OK", "cnaipe OK", "cnáipe OK", "comhartha OK"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan OK"),
            keywords: &["ceart", "ceart ma-thà", "ok", "ok ma-thà", "putan OK"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"ben\" en inglés"),
            keywords: &["OK", "ben", "botón \"ben\" en inglés", "de acordo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑક\u{ac7}ન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &["ઑક\u{ac7}", "ઑક\u{ac7}ન\u{ac1}\u{a82} ચિહ\u{acd}ન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin TO"),
            keywords: &["TO", "maɓallin TO"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן OK"),
            keywords: &["ok", "אוקיי", "אישור", "בסדר", "טוב", "לחצן OK"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठीक बटन"),
            keywords: &[
                "चौकोर म\u{947}\u{902} ठीक चिह\u{94d}न",
                "ठीक",
                "ठीक चिह\u{94d}न",
                "ठीक बटन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka OK"),
            keywords: &["ok", "tipka OK", "u redu"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("OK gomb"),
            keywords: &["OK", "OK gomb"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("օքեյ"),
            keywords: &["ok", "օքեյ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol OK"),
            keywords: &["oke", "tombol OK"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọdụmbi DỊ MMA"),
            keywords: &["Ọ DỊ MMA", "ọdụmbi DỊ MMA"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("OK"),
            keywords: &["OK", "OK-skilti", "í lagi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante OK"),
            keywords: &["pulsante OK", "simbolo OK"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("OKマーク"),
            keywords: &["OK", "OKマーク", "オッケー", "オーケー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol OK"),
            keywords: &["OK", "tombol OK"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი OK"),
            keywords: &["კარგი", "ღილაკი OK"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("OK түймесі"),
            keywords: &["OK", "OK түймесі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("OK"),
            keywords: &["OK", "OK-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ OK ធ\u{17c6}"),
            keywords: &[
                "OK",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ OK ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರ\u{cbf} ಬಟನ\u{ccd}"),
            keywords: &["ಓಕ\u{cc6}", "ಸರ\u{cbf}", "ಸರ\u{cbf} ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오케이"),
            keywords: &["OK", "네", "예", "오케이", "오케이 신호", "좋다"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओक\u{947} बटण"),
            keywords: &["ओक\u{947}", "ओक\u{947} बटण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы ок"),
            keywords: &["ок", "чарчыдагы ок"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("OK-Knäppchen"),
            keywords: &["OK", "OK-Knäppchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}ກລ\u{ebb}ງ"),
            keywords: &[
                "ຕ\u{ebb}ກລ\u{ebb}ງ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຕ\u{ebb}ກລ\u{ebb}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „OK“"),
            keywords: &["ok", "simbolis „OK“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts OK kvadrātveida ietvarā"),
            keywords: &["labi", "ok", "uzraksts OK kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene ĀE"),
            keywords: &["pātene ĀE", "ĀE"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче ОК"),
            keywords: &["добро", "копче ОК", "ок"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ശരിയ\u{d3e}ണ\u{d4d} /OK എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ദ\u{d4d}ര",
            ),
            keywords: &[
                "OK",
                "ഒകെ",
                "ചിഹ\u{d4d}നം",
                "ശരി",
                "ശരിയ\u{d3e}ണ\u{d4d} /OK എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ദ\u{d4d}ര",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("OK товчлуур"),
            keywords: &["OK", "OK товчлуур"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस ठीक आह\u{947}"),
            keywords: &["OK", "OK बटण", "चौरस ठीक आह\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang OK"),
            keywords: &["butang OK", "ok"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna OK"),
            keywords: &["OK", "buttuna OK"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}\u{102f}ကေ သင\u{103a}\u{1039}ကေတပြ ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "အ\u{102d}\u{102f}ကေ",
                "အ\u{102d}\u{102f}ကေ သင\u{103a}\u{1039}ကေတပြ ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("OK-knapp"),
            keywords: &["OK", "OK-knapp", "OK-symbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वार\u{94d}ड ओक\u{947}"),
            keywords: &["ठीक", "स\u{94d}क\u{94d}वार\u{94d}ड ओक\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("OK-knop"),
            keywords: &["OK", "OK-knop"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("OK-knapp"),
            keywords: &["OK", "OK-knapp", "OK-symbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("OK ବଟନ\u{b4d}\u{200c}"),
            keywords: &["OK", "OK ବଟନ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("OK ਬਟਨ"),
            keywords: &["OK ਬਟਨ", "ਚ\u{a70}ਗਾ", "ਠੀਕ", "ਠੀਕ ਦਾ ਪ\u{a4d}ਰਤੀਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹھیک اے بٹن"),
            keywords: &["ٹھیک اے", "ٹھیک اے بٹن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("OK Bọ\u{301}tin"),
            keywords: &["OK", "OK Bọ\u{301}tin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk OK"),
            keywords: &["dobrze", "przycisk OK", "w porządku", "zgoda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("او کی بټن"),
            keywords: &["او کی", "او کی بټن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão OK"),
            keywords: &["OK", "botão OK", "símbolo “OK”"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão OK"),
            keywords: &["botão OK", "ok"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu textul OK"),
            keywords: &["OK", "buton cu textul OK"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-180"),
            keywords: &["E10-180"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «ОК»"),
            keywords: &["ОК", "значок", "значок «ОК»", "окей", "о’кей", "хорошо"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya Yego"),
            keywords: &["Yego", "buto ya Yego"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("OK بٽڻ"),
            keywords: &["OK بٽڻ", "OK، ٺيڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} ok"),
            keywords: &["OK", "හතරැස\u{dca} ok"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok OK"),
            keywords: &["ok", "štítok OK"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb OK"),
            keywords: &["gumb OK", "v redu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka OK"),
            keywords: &["OK", "badhanka OK"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «OK»"),
            keywords: &["OK", "buton", "butoni «OK»", "në rregull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме OK"),
            keywords: &["ok", "дугме OK", "у рeду"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme OK"),
            keywords: &["dugme OK", "ok", "u redu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("OK-knapp"),
            keywords: &["OK", "OK-knapp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye neno ‘OK’"),
            keywords: &["kitufe chenye neno ‘OK’", "sawa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஓகே"),
            keywords: &["ஓகே", "சரி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చతురస\u{c4d}రంల\u{c4b} ఓక\u{c47} అక\u{c4d}షర\u{c3e}లు"),
            keywords: &[
                "ఓక\u{c47}",
                "ఓక\u{c47} అక\u{c4d}షర\u{c3e}లు",
                "చతురస\u{c4d}రంల\u{c4b} ఓక\u{c47} అక\u{c4d}షర\u{c3e}లు",
                "సర\u{c47}",
                "సర\u{c47} గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"OK\""),
            keywords: &["OK", "тугмаи \"OK\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โอเค"),
            keywords: &["ตกลง", "ส\u{e31}ญล\u{e31}กษณ\u{e4c}โอเค", "โอเค"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("OK መልጎም"),
            keywords: &["OK", "OK መልጎም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("OK düwmesi"),
            keywords: &["OK düwmesi", "bolýar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi OK"),
            keywords: &["meʻalolomi OK", "sai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("OK düğmesi"),
            keywords: &["OK düğmesi", "OK işareti", "tamam", "tamam işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("«OK» كۇنۇپكىسى"),
            keywords: &["«OK» كۇنۇپكىسى", "ماقۇل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка «ОК»"),
            keywords: &["ok", "кнопка «ОК»"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوکے بٹن"),
            keywords: &["ok", "اوکے بٹن", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi ok tugmasi"),
            keywords: &["kvadrat ichidagi ok tugmasi", "ok"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút OK"),
            keywords: &["nút OK", "ok"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu waaw-kay"),
            keywords: &["bitoŋu waaw-kay", "waaw-kay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi KULUNGILE"),
            keywords: &["KULUNGILE", "iqhosha elithi KULUNGILE"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini DARA"),
            keywords: &["Bọtini DARA", "Ó Dára"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("OK 按鈕"),
            keywords: &["OK", "OK 按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("OK 按钮"),
            keywords: &["OK", "OK 按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("OK按钮"),
            keywords: &["OK按钮", "同意", "按键"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("好的"),
            keywords: &["可以", "好的", "沒問題"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("OK 按鈕"),
            keywords: &["OK", "OK 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("OK oyisikwele"),
            keywords: &["OK oyisikwele", "ok"],
        },
    ],
};
#[doc = "🅿\u{fe0f}"]
pub const P_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🅿\u{fe0f}",
    codepoint: "1F17F FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "P button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🅿",
        codepoint: "1F17F",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "P button",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("P-knopie"),
            keywords: &["P-knopie", "parkering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፒ አዝራር"),
            keywords: &["መኪና ማቆሚያ", "ፒ አዝራር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("انتظار سيارات"),
            keywords: &["انتظار", "انتظار سيارات"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("P ব\u{9c1}ট\u{9be}ম"),
            keywords: &["P ব\u{9c1}ট\u{9be}ম", "প\u{9be}ৰ\u{9cd}কিং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("p düyməsi"),
            keywords: &["p düyməsi", "parkinq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «паркоўка»"),
            keywords: &["знак", "знак «паркоўка»", "паркоўка", "паркінг", "стаянка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бутон с „P“"),
            keywords: &["Бутон с „P“", "паркинг"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পি বোত\u{9be}ম"),
            keywords: &["প\u{9be}র\u{9cd}কিং", "পি বোত\u{9be}ম"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton P"),
            keywords: &["P", "bouton P", "parklecʼh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dugme p"),
            keywords: &["dugme p", "parking"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó P"),
            keywords: &["P", "aparcament", "botó P", "lletra P", "pàrquing"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("P ᎦᏗ"),
            keywords: &["P ᎦᏗ", "ᏙᏆᎴᎵ ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek P"),
            keywords: &["parking", "parkoviště", "parkování", "štítek P"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm P"),
            keywords: &["botwm P", "parcio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("parkering"),
            keywords: &["parkering", "parkeringsplads"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Großbuchstabe P in blauem Quadrat"),
            keywords: &["Großbuchstabe P in blauem Quadrat", "Parkplatz", "Quadrat"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstabe P in Quadrat"),
            keywords: &["Grossbuchstabe P in Quadrat", "Parkplatz", "Quadrat"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί P"),
            keywords: &["κουμπί P", "πάρκινγκ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("P button"),
            keywords: &["P button", "parking"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("aparcamiento"),
            keywords: &["aparcamiento", "p", "parking"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("estacionamiento"),
            keywords: &["P", "estacionamiento", "letra"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp P"),
            keywords: &["nupp P", "parkimine", "parkla"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“p” botoia"),
            keywords: &["aparkaleku", "parking", "“p” botoia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه پی"),
            keywords: &["دکمه پی", "پارکینگ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("P"),
            keywords: &["P", "merkki", "p", "parkkipaikka", "pysäköinti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na P"),
            keywords: &["P", "button na P", "paradahan", "parking", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("P knappur"),
            keywords: &[
                "P knappur",
                "knappur",
                "knøttur",
                "ok",
                "parkering",
                "parkeringarbásur",
                "parkeringarpláss",
                "parkeringarskiva",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton P"),
            keywords: &["bouton P", "parking"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("icône Stationnement"),
            keywords: &["icône Stationnement", "parking", "stationnement"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe P"),
            keywords: &["carrchlós", "cnaipe P", "páirceáil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan P"),
            keywords: &["putan P", "pàirceadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("aparcadoiro"),
            keywords: &["P", "aparcadoiro", "aparcamento", "aparcar", "parking"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પાર\u{acd}કિ\u{a82}ગ સ\u{acd}થળ"),
            keywords: &["પાર\u{acd}કિ\u{a82}ગ", "પાર\u{acd}કિ\u{a82}ગ સ\u{acd}થળ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin P"),
            keywords: &["fakin", "maɓallin P"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן P"),
            keywords: &["חנייה", "לחצן P", "לחצן p"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} पी बटन, पार\u{94d}कि\u{902}ग"),
            keywords: &[
                "चौकोर म\u{947}\u{902} पी बटन, पार\u{94d}कि\u{902}ग",
                "पार\u{94d}कि\u{902}ग",
                "पार\u{94d}कि\u{902}ग लॉट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka P"),
            keywords: &["parkiranje", "tipka P"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("P gomb"),
            keywords: &["P gomb", "parkolás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փի կոճակ"),
            keywords: &["կայանատեղի", "փի կոճակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol P"),
            keywords: &["parkir", "tombol P", "tombol p"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi P"),
            keywords: &["na-ahazi", "Ọdụmbi P"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bílastæði"),
            keywords: &["bílastæði", "leggja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante P"),
            keywords: &["area di parcheggio", "pulsante P"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("Pマーク"),
            keywords: &["P", "Pマーク", "パーキング", "駐車場"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol P"),
            keywords: &["parkir", "tombol P"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი p"),
            keywords: &["ავტოსადგომი", "პარკინგი", "ღილაკი p"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("P түймесі"),
            keywords: &["P түймесі", "тұрақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("parkering"),
            keywords: &["parkering", "parkeringsplads"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ P ធ\u{17c6}"),
            keywords: &[
                "P",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ P ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cbf} ಬಟನ\u{ccd}"),
            keywords: &["ಪಾರ\u{ccd}ಕ\u{cbf}ಂಗ\u{ccd}", "ಪ\u{cbf} ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주차 표시"),
            keywords: &["P", "음각 피", "주차", "주차 표시", "주차장", "파킹"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("P बटण"),
            keywords: &["P बटण", "पार\u{94d}कि\u{902}ग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("р баскычы"),
            keywords: &["р баскычы", "токтотмо"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("P-Knäppchen"),
            keywords: &["P-Knäppchen", "Parking"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ບ\u{ec8}ອນຈອດລ\u{ebb}ດ"),
            keywords: &["ຈອດລ\u{ebb}ດ", "ບ\u{ec8}ອນຈອດລ\u{ebb}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „P“"),
            keywords: &["automobilių stovėjimas", "simbolis „P“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("poga P"),
            keywords: &["P", "poga P", "stāvvieta"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene P"),
            keywords: &["pātene P", "turanga waka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче П"),
            keywords: &["копче П", "паркинг"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ർക\u{d4d}ക\u{d4d} ചെയ\u{d4d}യ\u{d3e}ന\u{d41}ള\u{d4d}ള സ\u{d4d}ഥലം"),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "പ\u{d3e}ർക\u{d4d}കിംഗ\u{d4d}",
                "പ\u{d3e}ർക\u{d4d}കിംഗ\u{d4d} ലോട\u{d4d}ട\u{d4d}",
                "പ\u{d3e}ർക\u{d4d}കിംഗ\u{d4d} സ\u{d4d}ഥലം",
                "പ\u{d3e}ർക\u{d4d}ക\u{d4d} ചെയ\u{d4d}യ\u{d3e}ന\u{d41}ള\u{d4d}ള സ\u{d4d}ഥലം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("p товчлуур"),
            keywords: &["p товчлуур", "зогсоол"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("p बटण"),
            keywords: &["p बटण", "पार\u{94d}कि\u{902}ग", "पी बटण"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang P"),
            keywords: &["butang P", "letak kereta"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna P"),
            keywords: &["buttuna P", "pparkjar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယာဉ\u{103a}ရပ\u{103a}နားရန\u{103a} သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ယာဉ\u{103a}ရပ\u{103a}နားရန\u{103a} သင\u{103a}\u{1039}ကေတ",
                "ယာဥ\u{103a}ရပ\u{103a}နားရန\u{103a} သင\u{103a}\u{1039}ကေတ",
                "အင\u{103a}\u{1039}ဂလ\u{102d}ပ\u{103a} အက\u{1039}ခရာ ပ\u{102e} သင\u{103a}\u{1039}ကေတပြ ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("P-knapp"),
            keywords: &["P-knapp", "parkering", "parkeringsplass"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पि बटन"),
            keywords: &["पार\u{94d}किङ\u{94d}", "पि बटन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("P-knop"),
            keywords: &["P-knop", "parkeerplaats"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("P-knapp"),
            keywords: &["P-knapp", "parkering", "parkeringsplass"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("P ବଟନ\u{b4d}"),
            keywords: &["P ବଟନ\u{b4d}", "ପ\u{b3e}ର\u{b4d}କ\u{b3f}ଂ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("P ਬਟਨ"),
            keywords: &["P ਬਟਨ", "ਪਾਰਕਿ\u{a70}ਗ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("P دا بٹن"),
            keywords: &["P دا بٹن", "گڈی دا احاطہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("P Bọ\u{301}tin"),
            keywords: &["P Bọ\u{301}tin", "Pákin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("parking"),
            keywords: &["parking", "postój"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("P بټن"),
            keywords: &["P بټن", "ودرېدل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão P"),
            keywords: &["botão P", "estacionamento", "estacionar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão P"),
            keywords: &["botão P", "estacionamento"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton P"),
            keywords: &["buton P", "parcare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-172"),
            keywords: &["E10-172"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("парковка"),
            keywords: &["автостоянка", "машины", "парковка", "стоянка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibuto ya P"),
            keywords: &["ibuto ya P", "parikingi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("P بٽڻ"),
            keywords: &["P بٽڻ", "پارڪنگ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("p බොත\u{dca}තම"),
            keywords: &["p බොත\u{dca}තම", "නැවැත\u{dca}ව\u{dd3}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok P"),
            keywords: &["parkovanie", "štítok P"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb s črko p"),
            keywords: &["gumb s črko p", "parkiranje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka P"),
            keywords: &["badhanka P", "gaari dhigasho"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «P»"),
            keywords: &["butoni «P»", "parkim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак за паркинг"),
            keywords: &["дугме P", "знак за паркинг", "паркирање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["знак за паркинг"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak za parking"),
            keywords: &["dugme P", "parkiranje", "znak za parking"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["znak za parking"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("P-knapp"),
            keywords: &["P-knapp", "parkering", "parkeringsplats"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha P"),
            keywords: &["kitufe cha P", "maegesho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}ர\u{bcd}கிங\u{bcd}"),
            keywords: &[
                "ப\u{bbe}ர\u{bcd}கிங\u{bcd}",
                "ப\u{bbe}ர\u{bcd}கிங\u{bcd} ல\u{bbe}ட\u{bcd}",
                "வ\u{bbe}கனம\u{bcd} நிறுத\u{bcd}துமிடம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3f} అక\u{c4d}షరం"),
            keywords: &[
                "ప\u{c3e}ర\u{c4d}క\u{c3f}ంగ\u{c4d} స\u{c4d}థలం",
                "ప\u{c3e}ర\u{c4d}క\u{c4d} చ\u{c47}యడం",
                "ప\u{c3f} అక\u{c4d}షరం",
                "వ\u{c3e}హన\u{c3e}లు ఆప\u{c47} స\u{c4d}థలం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"P\""),
            keywords: &["таваққуф кардан", "тугмаи \"P\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e35}\u{e48}จอดรถ"),
            keywords: &["จอดรถ", "ท\u{e35}\u{e48}จอดรถ"],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("P መልጎም"),
            keywords: &["P መልጎም", "ፓርኪን"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("P düwmesi"),
            keywords: &["P düwmesi", "awtoduralga"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi P"),
            keywords: &["P", "meʻalolomi", "tau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("P düğmesi"),
            keywords: &["P düğmesi", "p düğmesi", "park yeri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("P كۇنۇپكىسى"),
            keywords: &["P كۇنۇپكىسى", "توختىتىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка «паркування»"),
            keywords: &["кнопка «паркування»", "паркування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("P بٹن"),
            keywords: &["P بٹن", "پارکنگ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("p tugmasi"),
            keywords: &["avtoto‘xtash", "p tugmasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút P"),
            keywords: &["nút P", "đỗ xe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu P"),
            keywords: &["bitoŋu P", "gaare"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi P"),
            keywords: &["iqhosha elithi P", "ukupaka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bó\u{329}tìnì P"),
            keywords: &["bó\u{329}tìnì P", "àyè ìgbékọ\u{300}sí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("P 按鈕"),
            keywords: &["P 按鈕", "泊車"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("P 按钮"),
            keywords: &["P 按钮", "泊车"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("停车按钮"),
            keywords: &["停车按钮", "按键", "泊车"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("P"),
            keywords: &["P", "p", "停車"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("P 按鈕"),
            keywords: &["P", "P 按鈕", "p", "停車"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inkinobho yokupaka"),
            keywords: &["inkinobho yokupaka", "ukupaka"],
        },
    ],
};
#[doc = "🆘"]
pub const SOS_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆘",
    codepoint: "1F198",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "SOS button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("SOS-knopie"),
            keywords: &["SOS", "SOS-knopie", "hulp"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤስኦኤስ ካሬ"),
            keywords: &["ኤስኦኤስ", "ኤስኦኤስ ካሬ", "እገዛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زر \"طوارئ\""),
            keywords: &["sos", "sos في مربع", "زر \"طوارئ\"", "مساعدة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("SOS ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "SOS ব\u{9c1}ট\u{9be}ম",
                "সহ\u{9be}য\u{9bc}",
                "সহ\u{9be}য\u{9bc} বিচ\u{9be}ৰি জৰ\u{9c1}ৰী আহ\u{9cd}ব\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat sos"),
            keywords: &["kvadrat sos", "kömək", "sos"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «SOS»"),
            keywords: &["SOS", "СОС", "дапамажыце", "знак «SOS»"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„SOS“ в квадрат"),
            keywords: &["sos", "помощ", "„SOS“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে এস ও এস"),
            keywords: &[
                "এসওএস",
                "বর\u{9cd}গক\u{9cd}ষেত\u{9cd}রের মধ\u{9cd}যে এস ও এস",
                "স\u{9be}হ\u{9be}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton SOS"),
            keywords: &["SOS", "bouton SOS", "sos"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sos kvadrat"),
            keywords: &["pomoć", "sos", "sos kvadrat"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó SOS"),
            keywords: &["SOS", "auxili", "botó SOS", "emergència", "socors"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("SOS ᎦᏗ"),
            keywords: &["SOS ᎦᏗ", "sos", "ᎠᎵᏍᏕᎸᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek SOS"),
            keywords: &["pomoc", "sos", "štítek SOS"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm SOS"),
            keywords: &["botwm SOS", "help", "sos"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("SOS"),
            keywords: &["SOS", "SOS-signal", "SOS-tegn", "hjælp"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("SOS-Zeichen"),
            keywords: &["Hilfe", "SOS", "SOS-Zeichen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί SOS"),
            keywords: &["sos", "βοήθεια", "κουμπί SOS"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("SOS button"),
            keywords: &["SOS button", "help", "sos"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de socorro"),
            keywords: &["ayuda", "socorro", "sos", "símbolo", "símbolo de socorro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("auxilio"),
            keywords: &[
                "auxilio",
                "ayuda",
                "socorro",
                "sos",
                "símbolo",
                "símbolo de socorro",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("botón SOS"),
            keywords: &[
                "auxilio",
                "ayuda",
                "botón SOS",
                "socorro",
                "sos",
                "símbolo",
                "símbolo de socorro",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp SOS"),
            keywords: &["abi", "appi", "nupp SOS", "sos"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“sos” hitza karratu batean"),
            keywords: &["laguntza", "sos", "“sos” hitza karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه اس او اس"),
            keywords: &["اس او اس", "درخواست کمک", "دکمه اس او اس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("SOS"),
            keywords: &["SOS", "apua", "hätämerkki", "merkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na SOS"),
            keywords: &["SOS", "button na SOS", "pindutan", "tulong"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("SOS knappur"),
            keywords: &[
                "SOS knappur",
                "hjálp",
                "knappur",
                "knøttur",
                "neyðarkall",
                "neyðarróp",
                "sos",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton SOS"),
            keywords: &["SOS", "bouton SOS"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["SOS", "aide", "bouton SOS", "secours"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("SOS"),
            keywords: &["SOS", "cabhair", "comhartha SOS", "comhartha cabhrach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan “SOS”"),
            keywords: &["cobhair", "cuideachadh", "putan “SOS”", "sos"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"socorro!\" en inglés"),
            keywords: &[
                "SOS",
                "auxilio",
                "axuda",
                "botón \"socorro!\" en inglés",
                "socorro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મદદન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "SOS",
                "SOS ન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ચિહ\u{acd}ન",
                "મદદ",
                "મદદન\u{ac1}\u{a82} ચિહ\u{acd}ન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin SOS"),
            keywords: &["maɓallin SOS", "sos", "taimako"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן SOS"),
            keywords: &["sos", "אס או אס", "הצילו", "לחצן SOS", "עזרה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} SOS चिह\u{94d}न"),
            keywords: &[
                "SOS",
                "चिह\u{94d}न",
                "चौकोर म\u{947}\u{902} SOS चिह\u{94d}न",
                "चौकोर म\u{947}\u{902} SOS चिह\u{94d}न, बचाओ",
                "बचाओ",
                "मदद",
                "सहायता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka SOS"),
            keywords: &["pomoć", "sos", "tipka SOS"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("SOS gomb"),
            keywords: &["SOS gomb", "segítség", "sos"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սոս"),
            keywords: &["sos", "սոս", "օգնել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol SOS"),
            keywords: &["bantuan", "sos", "tombol SOS", "tombol sos"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ỌDỤMBI sos"),
            keywords: &["sos", "ènyèmaka", "ỌDỤMBI sos"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("SOS"),
            keywords: &["SOS", "SOS-skilti", "hjálp", "skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante SOS"),
            keywords: &[
                "SOS",
                "Segnale di SOS",
                "pulsante SOS",
                "simbolo di SOS",
                "soccorsi",
                "soccorso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("SOSマーク"),
            keywords: &["SOS", "SOSマーク", "エスオーエス", "助けて"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol SOS"),
            keywords: &["sos", "tombol SOS", "tulung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი SOS"),
            keywords: &["sos", "დახმარება", "ღილაკი SOS"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("SOS түймесі"),
            keywords: &["SOS түймесі", "sos", "көмек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("SOS"),
            keywords: &["SOS", "SOS-signal", "SOS-tegn", "hjælp"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ SOS ធ\u{17c6}"),
            keywords: &[
                "SOS",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ SOS ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಸ\u{ccd}\u{200c}ಒಎಸ\u{ccd} ಬಟನ\u{ccd}"),
            keywords: &[
                "ಎಸ\u{ccd}\u{200c}ಒಎಸ\u{ccd}",
                "ಎಸ\u{ccd}\u{200c}ಒಎಸ\u{ccd} ಬಟನ\u{ccd}",
                "ಸಹಾಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("에스오에스"),
            keywords: &["SOS", "구조", "구조 신호", "에스오에스", "에스오에스 신호"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("SOS बटण"),
            keywords: &["SOS बटण", "sos", "आदार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы сос"),
            keywords: &["жардам", "чарчыдагы сос"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("SOS-Knäppchen"),
            keywords: &["Hëllef", "SOS", "SOS-Knäppchen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{ec8}ວຍແດ\u{ec8}"),
            keywords: &[
                "ຊ\u{ec8}ວຍແດ\u{ec8}",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຂ\u{ecd}ຄວາມຊ\u{ec8}ວຍເຫ\u{ebc}\u{eb7}ອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „SOS“"),
            keywords: &["pagalba", "simbolis „SOS“", "sos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts SOS kvadrātveida ietvarā"),
            keywords: &["SOS", "palīdzība", "uzraksts SOS kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene SOS"),
            keywords: &["pātene SOS", "sos", "āwhina"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче СОС"),
            keywords: &["копче СОС", "повик", "помош"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("SOS മ\u{d41}ദ\u{d4d}ര"),
            keywords: &[
                "SOS",
                "SOS മ\u{d41}ദ\u{d4d}ര",
                "എസ\u{d4d}ഒഎസ\u{d4d}",
                "ചിഹ\u{d4d}നം",
                "സഹ\u{d3e}യ ചിഹ\u{d4d}നം",
                "സഹ\u{d3e}യം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("SOS товчлуур"),
            keywords: &["SOS товчлуур", "sos", "тусламж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस sos"),
            keywords: &["SOS बटण", "sos", "चौरस sos", "मदत"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang SOS"),
            keywords: &["bantu", "butang SOS", "sos"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna SOS"),
            keywords: &["buttuna SOS", "għajnuna", "sos"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရေးပေါ\u{103a} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "က\u{1030}ည\u{102e}ပါ",
                "အက\u{103a}စ\u{103a}အ\u{102d}\u{102f}အက\u{103a}စ\u{103a}",
                "အက\u{103a}စ\u{103a}အ\u{102d}\u{102f}အက\u{103a}စ\u{103a} သင\u{103a}\u{1039}ကေတပြ ခလ\u{102f}တ\u{103a}",
                "အရေးပေါ\u{103a} ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("SOS-knapp"),
            keywords: &["SOS-knapp", "SOS-symbol", "hjelp", "hjelp-symbol", "sos"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड एसओएस"),
            keywords: &["एसओएस", "मदत", "स\u{94d}क\u{94d}वायर\u{94d}ड एसओएस"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("SOS-knop"),
            keywords: &["SOS-knop", "help", "sos"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("SOS-knapp"),
            keywords: &["SOS-knapp", "SOS-symbol", "hjelp", "hjelp-symbol", "sos"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("SOS ବଟନ\u{b4d}"),
            keywords: &["SOS ବଟନ\u{b4d}", "sos", "ସହ\u{b3e}ୟତ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("SOS ਬਟਨ"),
            keywords: &[
                "SOS",
                "SOS ਬਟਨ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਸਹਾਇਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("SOS بٹن"),
            keywords: &["SOS بٹن", "مدد", "مصیبت دا اشارہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("SOS Bọ\u{301}tin"),
            keywords: &["Hẹ\u{301}lẹp", "SOS Bọ\u{301}tin", "sos"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk SOS"),
            keywords: &["na pomoc", "przycisk SOS", "ratunek", "ratunku"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ايس او ايس بټن"),
            keywords: &["ايس او ايس", "ايس او ايس بټن", "مرسته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão SOS"),
            keywords: &["Ajuda", "SOS", "botão SOS", "símbolo", "símbolo “SOS”"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão SOS"),
            keywords: &["ajuda", "botão SOS", "sos"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton S.O.S."),
            keywords: &["S.O.S.", "ajutor", "buton S.O.S."],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-181"),
            keywords: &["E10-181"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок SOS"),
            keywords: &["sos", "значок SOS", "помогите", "помощь", "сос", "спасите"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya SOS"),
            keywords: &["buto ya SOS", "ubufasha"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("SOS بٽڻ"),
            keywords: &["SOS بٽڻ", "sos", "مدد"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} sos"),
            keywords: &["sos", "උදව\u{dd4}", "හතරැස\u{dca} sos"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok SOS"),
            keywords: &["pomoc", "sos", "štítok SOS"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb SOS"),
            keywords: &["gumb SOS", "na pomoč", "sos"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka SOS"),
            keywords: &["SOS", "badhanka SOS", "caawi"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «SOS»"),
            keywords: &["butoni «SOS»", "ndihmë", "sos"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("С.О.С."),
            keywords: &["sos", "С.О.С.", "пoмoћ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("S.O.S."),
            keywords: &["S.O.S.", "pomoć", "sos"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("SOS-knapp"),
            keywords: &["SOS", "SOS-knapp", "SOS-symbol", "hjälp", "symbol"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe chenye neno ‘SOS’"),
            keywords: &["kitufe chenye neno ‘SOS’", "sos", "usaidizi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எஸ\u{bcd}ஓஎஸ\u{bcd}"),
            keywords: &["அவசரம\u{bcd}", "உதவி", "எஸ\u{bcd}ஓஎஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చతురస\u{c4d}రంల\u{c4b} ఎస\u{c4d}ఓఎస\u{c4d}"),
            keywords: &[
                "ఎస\u{c4d}ఓఎస\u{c4d}",
                "ఎస\u{c4d}ఓఎస\u{c4d} అక\u{c4d}షర\u{c3e}లు",
                "ఎస\u{c4d}ఓఎస\u{c4d} గుర\u{c4d}తు",
                "చతురస\u{c4d}రంల\u{c4b} ఎస\u{c4d}ఓఎస\u{c4d}",
                "నన\u{c4d}ను క\u{c3e}ప\u{c3e}డండ\u{c3f}",
                "మ\u{c40} సహ\u{c3e}యం క\u{c3e}వ\u{c3e}ల\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"SOS\""),
            keywords: &["sos", "кӯмак", "тугмаи \"SOS\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e48}วยด\u{e49}วย"),
            keywords: &[
                "ขอความช\u{e48}วยเหล\u{e37}อ",
                "ช\u{e48}วยด\u{e49}วย",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ขอความช\u{e48}วยเหล\u{e37}อ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("SOS መልጎም"),
            keywords: &["SOS መልጎም", "sos", "ሓገዝ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("SOS düwmesi"),
            keywords: &["SOS düwmesi", "kömek", "sos"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi SOS"),
            keywords: &["SOS", "meʻalolomi", "tokoni mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("SOS düğmesi"),
            keywords: &["SOS", "SOS düğmesi", "SOS işareti", "Yardım", "işaret"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("SOS كۇنۇپكىسى"),
            keywords: &["SOS كۇنۇپكىسى", "sos", "ياردەم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"SOS\""),
            keywords: &["sos", "допомога", "кнопка \"SOS\""],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("SOS بٹن"),
            keywords: &["SOS بٹن", "sos", "مدد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi sos so‘zi"),
            keywords: &["kvadrat ichidagi sos so‘zi", "sos", "yordam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút SOS"),
            keywords: &["nút SOS", "sos", "trợ giúp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu WALLU"),
            keywords: &["bitoŋu WALLU", "ndimbal", "wallu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi SOS"),
            keywords: &["iqhosha elithi SOS", "u-sos", "uncedo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini SOS"),
            keywords: &["Bọtini SOS", "sos", "ìrànwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("SOS 按鈕"),
            keywords: &["SOS 按鈕", "sos", "求助"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("SOS 按钮"),
            keywords: &["SOS 按钮", "sos", "求助"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("SOS按钮"),
            keywords: &["SOS按钮", "按键", "求救"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("救命"),
            keywords: &["救命", "求救"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("求救按鈕"),
            keywords: &["sos", "求救信號", "求救按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("sos oyisikwele"),
            keywords: &["sos", "sos oyisikwele", "usizo"],
        },
    ],
};
#[doc = "🆙"]
pub const UP_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆙",
    codepoint: "1F199",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "UP! button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("UP!-knopie"),
            keywords: &["UP!-knopie", "merk", "op"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደላይ! አዝራር"),
            keywords: &["ላይ", "ምልክት", "ወደላይ! አዝራር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أعلى"),
            keywords: &["أعلى", "علامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("UP! ব\u{9c1}ট\u{9be}ম"),
            keywords: &["UP! ব\u{9c1}ট\u{9be}ম", "ওপৰলৈ", "চিন"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("up! button"),
            keywords: &["işarə", "up! button", "yuxarı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «новы ўзровень!»"),
            keywords: &[
                "гульня",
                "знак",
                "знак «новы ўзровень!»",
                "новы",
                "слова «новы ўзровень!»",
                "уверх",
                "узровень",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Бутон с „up!“"),
            keywords: &["[up]", "Бутон с „up!“"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আপ! বোত\u{9be}ম"),
            keywords: &["আপ! বোত\u{9be}ম", "উপরে‘ শীর\u{9cd}ষক চিহ\u{9cd}ন"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("up dugme"),
            keywords: &["gore", "oznaka", "up dugme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó amb la paraula Up!"),
            keywords: &["Up!", "botó", "botó amb la paraula Up!", "paraula"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᎳᏗᎢ! ᎦᏗ"),
            keywords: &["ᎤᏙᏪᎸ", "ᎦᎸᎳᏗ", "ᎦᎸᎳᏗᎢ! ᎦᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek UP!"),
            keywords: &["up", "značka", "štítek UP!"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm UP!"),
            keywords: &["botwm UP!", "i fyny", "marc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("UP!-knap"),
            keywords: &["OP!-tegn", "UP!-knap", "UP!-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzug „UP!“ im blauen Quadrat"),
            keywords: &[
                "Quadrat",
                "Schriftzug",
                "Schriftzug „UP!“ im blauen Quadrat",
                "blau",
                "„Up“",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί UP!"),
            keywords: &["up", "κουμπί UP!", "πάνω", "σήμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("UP! button"),
            keywords: &["UP! button", "mark", "up"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón UP!"),
            keywords: &[
                "arriba",
                "botón UP!",
                "información",
                "novedad",
                "símbolo",
                "up",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp UP!"),
            keywords: &["märk", "nupp UP!", "üles"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“up!” botoia"),
            keywords: &["gora", "markatu", "up", "“up!” botoia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} !UP"),
            keywords: &["up", "بالا", "دکمه\u{654} !UP", "علامت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("UP!"),
            keywords: &["UP!", "huutomerkki", "merkki", "päivitys", "up", "uutta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na UP!"),
            keywords: &["UP!", "button na UP!", "marka", "pindutan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("UP! knappur"),
            keywords: &["UP! knappur", "knappur", "knøttur", "up!", "upp"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton Vers le haut"),
            keywords: &["bouton Vers le haut", "nouveau", "nouveauté"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("icône UP!"),
            keywords: &["icône UP!", "nouveau", "nouveauté", "up"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe THUAS!"),
            keywords: &[
                "Suas!",
                "UP!",
                "cnaipe THUAS!",
                "comhartha",
                "comhartha suas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan “UP!”"),
            keywords: &["comharra", "putan “UP!”", "suas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"arriba!\" en inglés"),
            keywords: &["botón", "botón \"arriba!\" en inglés", "subir", "up!"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપરન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &["UP! બટન", "ઉપરન\u{ac1}\u{a82} ચિહ\u{acd}ન", "ચિહ\u{acd}ન"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן up!"),
            keywords: &["לחצן up!", "למעלה", "מעלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} नई जानकारी, अपड\u{947}ट चिह\u{94d}न"),
            keywords: &[
                "अप!",
                "अपड\u{947}ट",
                "चिह\u{94d}न",
                "चौकोर म\u{947}\u{902} नई जानकारी, अपड\u{947}ट चिह\u{94d}न",
                "नई जानकारी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka UP!"),
            keywords: &["gore", "tipka UP!", "up", "znak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("UP! gomb"),
            keywords: &["UP! gomb", "jel", "up"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ափ կոճակ"),
            keywords: &["up", "ափ կոճակ", "նշան", "վեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol UP!"),
            keywords: &["ke atas", "tanda", "tombol UP!", "tombol up!"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("UP!"),
            keywords: &["UP!", "skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante UP!"),
            keywords: &["pulsante UP!", "simbolo UP!"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("UPマーク"),
            keywords: &["UP", "UPマーク", "アップ", "更新"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol UP!"),
            keywords: &["ndhuwur", "tandha", "tombol UP!"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღილაკი up!"),
            keywords: &["ზემოთ", "ნიშანი", "ღილაკი up!"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("UP! түймесі"),
            keywords: &["UP! түймесі", "up", "белгі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("OP!"),
            keywords: &["OP!", "OP!-tegn", "UP!-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ UP! ធ\u{17c6}ន\u{17b7}ងសញ\u{17d2}ញាឧទាន",
            ),
            keywords: &[
                "UP!",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ UP! ធ\u{17c6}ន\u{17b7}ងសញ\u{17d2}ញាឧទាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲ\u{cc6}! ಬಟನ\u{ccd}"),
            keywords: &["ಅಪ\u{ccd}", "ಗುರುತು", "ಮೇಲ\u{cc6}! ಬಟನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("위로 버튼"),
            keywords: &["UP", "업", "위로 버튼", "위쪽으로"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("UP! बटण"),
            keywords: &["UP! बटण", "ख\u{942}ण। वयर। वयर! बटण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ЖОГОРУ! баскычы"),
            keywords: &["ЖОГОРУ! баскычы", "белги", "өйдө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("UP!-Knäppchen"),
            keywords: &["UP!-Knäppchen", "Zeechen", "no uewen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂ\u{eb6}\u{ec9}ນ!"),
            keywords: &["ຂ\u{eb6}\u{ec9}ນ!", "ສ\u{eb1}ນຍາລ\u{eb1}ກຂ\u{eb6}\u{ec9}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mygtukas „Up!“"),
            keywords: &["mygtukas „Up!“", "up", "žymė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("poga Up!"),
            keywords: &["poga", "poga Up!", "up"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче УП!"),
            keywords: &["горе", "копче УП!", "ознака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "മ\u{d41}കൾഭ\u{d3e}ഗത\u{d4d}തേക\u{d4d}ക\u{d4d} /അപ\u{d4d}പ\u{d4d} മ\u{d41}ദ\u{d4d}ര",
            ),
            keywords: &[
                "അപ\u{d4d}പ\u{d4d} ചിഹ\u{d4d}നം",
                "അപ\u{d4d}പ\u{d4d}! ചിഹ\u{d4d}നം",
                "മ\u{d41}കൾഭ\u{d3e}ഗത\u{d4d}തേക\u{d4d}ക\u{d4d} /അപ\u{d4d}പ\u{d4d} മ\u{d41}ദ\u{d4d}ര",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээ товчлуур"),
            keywords: &["дээшээ", "дээшээ товчлуур", "тэмдэглэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अप! बटण"),
            keywords: &["UP! बटण", "अप! बटण", "चिन\u{94d}ह", "वर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang UP!"),
            keywords: &["butang UP!", "ke atas", "tanda"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037}",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ခလ\u{102f}တ\u{103a}",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037}ပြ သင\u{103a}\u{1039}ကေတ ခလ\u{102f}တ\u{103a}",
                "အမ\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("UP!-knapp"),
            keywords: &["UP!-knapp", "UP!-symbol", "opp", "opp-symbol", "up"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि! बटन"),
            keywords: &["चिन\u{94d}ह", "माथि", "माथि! बटन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("UP!-knop"),
            keywords: &["UP!-knop", "omhoog", "teken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("UP!-knapp"),
            keywords: &["UP!-knapp", "UP!-symbol", "opp", "opp-symbol", "up"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("UP! ବଟନ\u{b4d}\u{200c}"),
            keywords: &["UP! ବଟନ\u{b4d}\u{200c}", "ଚ\u{b3f}ହ\u{b4d}ନ । ଉପର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਤ\u{a47}! ਬਟਨ"),
            keywords: &[
                "UP!",
                "ਉ\u{a71}ਤ\u{a47}! ਬਟਨ",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("UP! Bọ\u{301}tin"),
            keywords: &["Mak", "UP! Bọ\u{301}tin", "Up", "Ọp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk UP!"),
            keywords: &["do góry", "przycisk UP!", "znak UP!"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پورته! بټن"),
            keywords: &["نښه", "پورته", "پورته! بټن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão \"UP!\""),
            keywords: &["UP!", "botão \"UP!\"", "símbolo", "símbolo “UP!”"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão up!"),
            keywords: &["botão", "botão up!", "força!"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu textul UP!"),
            keywords: &["buton", "buton cu textul UP!", "exclamare", "sus"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-182"),
            keywords: &["E10-182"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «обновление»"),
            keywords: &[
                "значок",
                "значок \"обновление\"",
                "значок «обновление»",
                "обновление",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya UP!"),
            keywords: &["akarango", "buto ya UP!", "hejuru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي! بٽڻ"),
            keywords: &["مٿي", "مٿي! بٽڻ", "نشان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("up! බොත\u{dca}තම"),
            keywords: &["up", "up! බොත\u{dca}තම", "ලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok UP!"),
            keywords: &["up", "značka", "štítok UP!"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb z besedo up in klicajem"),
            keywords: &["gumb z besedo up in klicajem", "navzgor", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka KOR!"),
            keywords: &["badhanka KOR!", "calaamad", "kor"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «UP!»"),
            keywords: &["buton", "butoni «UP!»", "lart", "shenjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме UP!"),
            keywords: &["up", "гoрe", "дугме UP!", "знaк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme UP!"),
            keywords: &["dugme UP!", "gore", "up", "znak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("UP!-knapp"),
            keywords: &["UP!", "UP!-knapp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha UP!"),
            keywords: &["alama", "juu", "kitufe cha UP!"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அப\u{bcd}"),
            keywords: &["அப\u{bcd}", "புதியது", "புதுப\u{bcd}பிப\u{bcd}பு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c48}క\u{c3f} బటన\u{c4d}"),
            keywords: &[
                "అప\u{c4d}",
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థక గుర\u{c4d}తుత\u{c4b} యుప\u{c3f} అక\u{c4d}షర\u{c3e}లు",
                "గుర\u{c4d}తు",
                "ప\u{c48}క\u{c3f} బటన\u{c4d}",
                "యుప\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e36}\u{e49}น"),
            keywords: &[
                "ข\u{e36}\u{e49}น",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ข\u{e36}\u{e49}น",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ንላዕሊ! መልጎም"),
            keywords: &["ምልክት", "ንላዕሊ", "ንላዕሊ! መልጎም"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("UP! düwmesi"),
            keywords: &["UP! düwmesi", "belgi", "ýokary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi UP!"),
            keywords: &["UP!", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("UP! düğmesi"),
            keywords: &["UP! düğmesi", "YUKARI!", "YUKARI! işareti", "işaret"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("UP! كۇنۇپكىسى"),
            keywords: &["UP! كۇنۇپكىسى", "ئۈستى", "بەلگە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"UP!\""),
            keywords: &["вгору", "значок", "кнопка \"UP!\""],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر! بٹن"),
            keywords: &["اوپر", "اوپر! بٹن", "بٹن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tepaga tugmasi"),
            keywords: &["belgi", "tepaga", "tepaga tugmasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút UP!"),
            keywords: &["dấu", "nút UP!", "up"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu YEEGAL"),
            keywords: &["bitoŋu YEEGAL", "kaw", "xàmme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi PHEZULU!"),
            keywords: &["iqhosha elithi PHEZULU!", "phezulu", "uphawu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("UP! 按鈕"),
            keywords: &["UP! 按鈕", "up", "標誌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("UP! 按钮"),
            keywords: &["UP! 按钮", "up", "标志"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("up按钮"),
            keywords: &["up按钮", "向上", "按键"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("UP"),
            keywords: &["UP", "up", "向上"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("UP 按鈕"),
            keywords: &["UP 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-up! inkinobho"),
            keywords: &["u-up! inkinobho", "up", "uphawu"],
        },
    ],
};
#[doc = "🆚"]
pub const VS_BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🆚",
    codepoint: "1F19A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "VS button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("VS-knopie"),
            keywords: &["VS-knopie", "versus", "vs"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቪኤስ ካሬ"),
            keywords: &["ቪኤስ ካሬ", "ይጋጠማል ከ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ضد"),
            keywords: &["ضد", "في مقابل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("VS ব\u{9c1}ট\u{9be}ম"),
            keywords: &["VS ব\u{9c1}ট\u{9be}ম", "বন\u{9be}ম"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat vs"),
            keywords: &["kvadrat vs", "qarşı", "vs"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знак «супраць»"),
            keywords: &["гульня", "знак «супраць»", "супраць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Vs“ в квадрат"),
            keywords: &["vs", "„Vs“ в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র মধ\u{9cd}যে ভি এস (ভ\u{9be}র\u{9cd}সেস)"),
            keywords: &[
                "বন\u{9be}ম",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র মধ\u{9cd}যে ভি এস (ভ\u{9be}র\u{9cd}সেস)",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton VS"),
            keywords: &["VS", "bouton VS", "versus", "vs"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vs dugme"),
            keywords: &["protiv", "vs", "vs dugme"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó VS"),
            keywords: &["VS", "botó VS", "contra", "versus", "vs."],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("VS ᎦᏗ"),
            keywords: &["VS ᎦᏗ", "vs", "ᎤᏓᏡᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek VS"),
            keywords: &["versus", "vs", "štítek VS"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("botwm VS"),
            keywords: &["botwm VS", "vs", "yn erbyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("versus"),
            keywords: &["versus", "versus-tegn", "vs.", "vs.-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzug VS in orangem Quadrat"),
            keywords: &[
                "Großbuchstaben VS in orangefarbenem Quadrat",
                "Schriftzug VS in orangem Quadrat",
                "VS",
                "versus",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Grossbuchstaben VS in orangefarbenem Quadrat"),
            keywords: &[
                "Grossbuchstaben VS in orangefarbenem Quadrat",
                "VS",
                "versus",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουμπί VS"),
            keywords: &["vs", "εναντίον", "κουμπί VS"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("VS button"),
            keywords: &["VS button", "versus", "vs"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("botón VS"),
            keywords: &["botón VS", "contra", "frente a", "símbolo", "versus", "vs"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nupp VS"),
            keywords: &["nupp VS", "versus", "vs"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("“vs” testua karratu batean"),
            keywords: &["versus", "vs", "“vs” testua karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} VS"),
            keywords: &[
                "vs",
                "در برابر",
                "در مقابل",
                "دربرابر",
                "درمقابل",
                "دکمه\u{654} VS",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("VS"),
            keywords: &["VS", "merkki", "versus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("button na VS"),
            keywords: &["VS", "button na VS", "pindutan", "versus"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("VS knappur"),
            keywords: &["VS knappur", "knappur", "knøttur", "vs", "ímóti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton VS"),
            keywords: &["bouton VS", "contre", "versus", "vs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bouton VS", "c.", "contre", "vs"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe VS"),
            keywords: &["cnaipe VS", "comhartha", "v", "versus", "vs"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan “VS”"),
            keywords: &["an aghaidh", "putan “VS”", "versus", "vs"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"fronte a\" en inglés"),
            keywords: &[
                "botón \"fronte a\" en inglés",
                "comparación",
                "contra",
                "fronte a",
                "versus",
                "vs",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિ. ન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ચિહ\u{acd}ન",
                "વિ.",
                "વિ. ન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "વિર\u{ac1}દ\u{acd}ધ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin VS"),
            keywords: &["maɓallin VS", "tare da", "vs"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן VS"),
            keywords: &["לחצן VS", "לעומת", "מול", "נגד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} विर\u{941}द\u{94d}ध चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "चौकोर म\u{947}\u{902} विर\u{941}द\u{94d}ध चिह\u{94d}न",
                "बनाम",
                "विर\u{941}द\u{94d}ध",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka VS"),
            keywords: &["tipka VS", "versus", "vs"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("VS gomb"),
            keywords: &["VS gomb", "ellen", "versus", "vs"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վի-էս"),
            keywords: &["ԸՆԴԴԵՄ կոճակ", "ընդդեմ", "վի-էս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol VS"),
            keywords: &["tombol VS", "tombol vs", "versus", "vs"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ỌDỤMBI vs"),
            keywords: &["amaokwu", "vs", "ỌDỤMBI vs"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("VS"),
            keywords: &["VS", "gegn", "skilti", "versus", "versus-skilti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pulsante VS"),
            keywords: &["pulsante VS", "simbolo contro", "versus", "vs"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("VSマーク"),
            keywords: &["VSマーク", "バーサス", "ブイエス", "ヴァーサス", "ヴィエス"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol VS"),
            keywords: &["nglawan", "tombol VS", "versus", "vs"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("vs კვადრატში"),
            keywords: &["vs", "vs კვადრატში", "წინააღმდეგ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("VS түймесі"),
            keywords: &["VS түймесі", "vs", "қарама-қарсы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("versus"),
            keywords: &["versus", "versus-tegn", "vs.", "vs.-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ VS ធ\u{17c6}"),
            keywords: &[
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង VS",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរ VS ធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ಎಸ\u{ccd} ಬಟನ\u{ccd}"),
            keywords: &[
                "vs",
                "ವರ\u{ccd}ಸಸ\u{ccd}",
                "ವ\u{cbf}ಎಸ\u{ccd} ಬಟನ\u{ccd}",
                "ವ\u{cbf}ರುದ\u{ccd}ಧ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("대"),
            keywords: &["VS", "대", "브이에스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("VS बटण"),
            keywords: &["VS बटण", "आड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы крш."),
            keywords: &["каршы", "крш.", "чарчыдагы крш."],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("VS-Knäppchen"),
            keywords: &["VS", "VS-Knäppchen", "versus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ecd}\u{ec8}ສ\u{eb9}\u{ec9}ກ\u{eb1}ບ"),
            keywords: &[
                "ຕ\u{ecd}\u{ec8}ສ\u{eb9}\u{ec9}ກ\u{eb1}ບ",
                "ສ\u{eb1}ນຍາລ\u{eb1}ກຕ\u{ecd}\u{ec8}ສ\u{eb9}\u{ec9}ກ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("simbolis „VS“"),
            keywords: &["palyginti", "simbolis „VS“"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts VS kvadrātveida ietvarā"),
            keywords: &["poga", "uzraksts VS kvadrātveida ietvarā", "vs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene VS"),
            keywords: &["ki", "ki a", "pātene VS"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче ВС"),
            keywords: &["копче ВС", "наспрема", "против"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെഴ\u{d4d}സസ\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ദ\u{d4d}ര"),
            keywords: &[
                "ചിഹ\u{d4d}നം",
                "മ\u{d41}ഖ\u{d3e}മ\u{d41}ഖം",
                "വെഴ\u{d4d}സസ\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ദ\u{d4d}ര",
                "വേഴ\u{d4d}സസ\u{d4d} ചിഹ\u{d4d}നം",
                "സിംബൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дөрвөлжин эсрэг тэмдэг"),
            keywords: &["дөрвөлжин эсрэг тэмдэг", "эсрэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस विर\u{942}द\u{94d}ध"),
            keywords: &[
                "चौरस विर\u{942}द\u{94d}ध",
                "वि",
                "वि बटण",
                "विर\u{941}द\u{94d}ध",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang VS"),
            keywords: &["butang VS", "lawan", "lwn."],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna VS"),
            keywords: &["buttuna VS", "versus", "vs"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆန\u{1037}\u{103a}ကျင\u{103a}ဘက\u{103a}ပြ သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "ဆန\u{1037}\u{103a}ကျင\u{103a}ဘက\u{103a}ပြ သင\u{103a}\u{1039}ကေတ",
                "ဗ\u{103d}\u{102e}အက\u{103a}စ\u{103a}",
                "ဗ\u{103d}\u{102e}အက\u{103a}စ\u{103a} ဆန\u{1037}\u{103a}ကျင\u{103a}ဘက\u{103a}ပြ သင\u{103a}\u{1039}ကေတ ခလ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("VS-knapp"),
            keywords: &["VS-knapp", "versus", "vs", "vs-symbol"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड भर\u{94d}स\u{947}ज"),
            keywords: &[
                "उल\u{94d}टो",
                "विपरीत",
                "स\u{94d}क\u{94d}वायर\u{94d}ड भर\u{94d}स\u{947}ज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("VS-knop"),
            keywords: &["VS-knop", "versus", "vs"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("VS-knapp"),
            keywords: &["VS-knapp", "versus", "vs", "vs-symbol"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("VS ବଟନ\u{b4d}\u{200c}"),
            keywords: &["VS ବଟନ\u{b4d}\u{200c}", "vs", "ବନ\u{b3e}ମ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਰਗਾਕਾਰ vs ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "vs",
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਬਨਾਮ",
                "ਵਰਗਾਕਾਰ vs ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("VS بٹن"),
            keywords: &["VS بٹن", "vs", "وائرس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("VS Bọ\u{301}tin"),
            keywords: &["VS Bọ\u{301}tin", "Vẹsọs", "vs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przycisk VS"),
            keywords: &["VS", "kontra", "przycisk VS", "versus"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وي ايس بټن"),
            keywords: &["اي ايس", "وي ايس بټن", "پرتله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão VS"),
            keywords: &["botão VS", "símbolo", "símbolo “vs”", "versus", "vs"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão VS"),
            keywords: &["botão VS", "v", "versus", "vs"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu textul VS"),
            keywords: &["buton cu textul VS", "versus", "vs."],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-183"),
            keywords: &["E10-183"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «против»"),
            keywords: &["значок", "значок \"против\"", "значок «против»", "против"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya VS"),
            keywords: &["buto ya VS", "hahanganye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("VS بٽڻ"),
            keywords: &["VS بٽڻ", "vs", "بمقابله"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} vs"),
            keywords: &["vs", "එද\u{dd2}ර\u{dd2}ව", "හතරැස\u{dca} vs"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štítok VS"),
            keywords: &["verzus", "vs", "štítok VS"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb VS"),
            keywords: &["gumb VS", "proti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka VS"),
            keywords: &["badhanka VS", "kasoo horjeeda", "vs"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «VS»"),
            keywords: &["buton", "butoni «VS»", "kundrejt", "kundër", "përballë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дугме VS"),
            keywords: &["vs", "дугме VS", "против", "у поређењу са"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dugme VS"),
            keywords: &["dugme VS", "protiv", "u poređenju sa", "vs"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("VS-knapp"),
            keywords: &["VS-knapp", "kontra", "mot", "symbol", "vs"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha VS"),
            keywords: &["dhidi ya", "kitufe cha VS", "vs"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெர\u{bcd}ஸஸ\u{bcd}"),
            keywords: &["நேருக\u{bcd}கு நேர\u{bcd}", "வெர\u{bcd}ஸஸ\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వర\u{c4d}స\u{c46}. బటన\u{c4d}"),
            keywords: &[
                "ప\u{c4d}రత\u{c4d}యర\u{c4d}థ\u{c3f}",
                "వర\u{c4d}స\u{c46}. బటన\u{c4d}",
                "వర\u{c4d}స\u{c46}స\u{c4d}",
                "వ\u{c3f}ఎస\u{c4d} అక\u{c4d}షర\u{c3e}లు",
                "వ\u{c3f}రుద\u{c4d}ధం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"VS\""),
            keywords: &["vs", "бар зидди", "тугмаи \"VS\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e48}อส\u{e39}\u{e49}ก\u{e31}บ"),
            keywords: &[
                "ต\u{e48}อส\u{e39}\u{e49}ก\u{e31}บ",
                "ส\u{e31}ญล\u{e31}กษณ\u{e4c}ต\u{e48}อส\u{e39}\u{e49}ก\u{e31}บ",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("VS መልጎም"),
            keywords: &["VS መልጎም", "vs", "ብመንጽር"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("VS düwmesi"),
            keywords: &["VS düwmesi", "bilen", "vs"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi VS"),
            keywords: &["VS", "meʻalolomi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("VS düğmesi"),
            keywords: &[
                "VS düğmesi",
                "işaret",
                "karşılaştırma",
                "karşılaştırma işareti",
                "vs",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("VS كۇنۇپكىسى"),
            keywords: &["VS كۇنۇپكىسى", "vs", "بەس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"VS\""),
            keywords: &["кнопка \"VS\"", "проти"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("VS بٹن"),
            keywords: &["VS بٹن", "vs", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi raqib sifatida so‘zi"),
            keywords: &["kvadrat ichidagi raqib sifatida so‘zi", "qarshi", "raqib"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút VS"),
            keywords: &["nút VS", "vs", "đấu với"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu daje"),
            keywords: &["bitoŋu daje", "daje ak", "vs"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi VS"),
            keywords: &["iqhosha elithi VS", "thelekisa", "vs"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini VS"),
            keywords: &["Bọtini VS", "figagbága pẹ\u{300}lú", "fp"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("VS 按鈕"),
            keywords: &["VS 按鈕", "vs", "對"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("VS 按钮"),
            keywords: &["VS 按钮", "vs", "对"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("VS按钮"),
            keywords: &["VS按钮", "对决", "按键"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("對戰"),
            keywords: &["vs", "對戰", "比"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("VS 按鈕"),
            keywords: &["VS 按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-vs oyisikwele"),
            keywords: &["u-vs oyisikwele", "verses", "vs"],
        },
    ],
};
#[doc = "🈁"]
pub const JAPANESE__HERE__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈁",
    codepoint: "1F201",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “here” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “hier”-knopie"),
            keywords: &[
                "Japannees",
                "Japannese “hier”-knopie",
                "Japannese “hier”-knoppie",
                "katakana",
                "“hier”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካታካና ኮኮ ካሬ"),
            keywords: &["ካታካና ኮኮ ካሬ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("هنا بالياباني في مربع"),
            keywords: &["هنا بالياباني في مربع", "ياباني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “ইয\u{9bc}\u{9be}ত” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "ক\u{9be}ট\u{9be}ক\u{9be}ন\u{9be}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “ইয\u{9bc}\u{9be}ত” ব\u{9c1}ট\u{9be}ম",
                "“ইয\u{9bc}\u{9be}ত”",
                "ココ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat katakana koko"),
            keywords: &["kvadrat katakana koko", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «тут» у квадраце"),
            keywords: &["пісьмо", "японскае", "ідэаграма «тут» у квадраце"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Коко“ от катакана в квадрат"),
            keywords: &["японски", "„Коко“ от катакана в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র ক\u{9be}ত\u{9be}ক\u{9be}ন\u{9be} কোকো"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র ক\u{9be}ত\u{9be}ক\u{9be}ন\u{9be} কোকো",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton \"amañ\" e japaneg"),
            keywords: &["amañ", "bouton", "bouton \"amañ\" e japaneg", "japaneg"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"ovdje\" na jap."),
            keywords: &[
                "Dugme \"ovdje\" na jap.",
                "Dugme sa tekstom \"ovdje\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"aquí\""),
            keywords: &[
                "botó japonès \"aquí\"",
                "japonès",
                "katakana",
                "koko",
                "quadre",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎠᎭᏂ” ᎦᏗ"),
            keywords: &["ᎧᏔᎧᎾ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎠᎭᏂ” ᎦᏗ", "“ᎠᎭᏂ”", "ココ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „zde“"),
            keywords: &[
                "japonština",
                "katakana",
                "tady",
                "zde",
                "štítek s japonským znakem „zde“",
                "ココ",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("katakana koko mewn sgwâr"),
            keywords: &["Japaneaidd", "katakana koko mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for her"),
            keywords: &["japansk", "kvadratisk ideogram for her"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen „koko“"),
            keywords: &[
                "Schriftzeichen „koko“",
                "japanisches Schriftzeichen",
                "„koko“",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα εδώ σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα εδώ σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “here” button"),
            keywords: &[
                "Japanese",
                "Japanese “here” button",
                "katakana",
                "“here”",
                "ココ",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"aquí\""),
            keywords: &[
                "ideograma japonés para \"aquí\"",
                "japonés",
                "katakana",
                "“aquí”",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"siin\""),
            keywords: &[
                "\"siin\"",
                "jaapani keel",
                "jaapani nupp \"siin\"",
                "katakana",
                "ココ",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("katakana koko karratu batean"),
            keywords: &["japoniera", "katakana koko karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} «اینجا» به ژاپنی"),
            keywords: &["اشاره", "اینجا", "دکمه\u{654} «اینجا» به ژاپنی", "ژاپنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("täällä-kirjainmerkki"),
            keywords: &[
                "japani",
                "katakana",
                "kirjoitusmerkki",
                "täällä-kirjainmerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button para sa salitang \"dito\""),
            keywords: &[
                "Hapones",
                "Hapones na button para sa salitang \"dito\"",
                "katakana",
                "nakaparisukat na katakana na koko",
                "pindutan",
                "“dito”",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"her\" knappur"),
            keywords: &[
                "\"her\"",
                "japanskur",
                "japanskur \"her\" knappur",
                "katakana",
                "ココ",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton ici en japonais"),
            keywords: &["bouton ici en japonais", "ici", "japonais"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}ici\u{a0}»"),
            keywords: &[
                "ici",
                "japonais",
                "katakana",
                "symbole japonais signifiant «\u{a0}ici\u{a0}»",
                "ココ",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"anseo\""),
            keywords: &["Seapáinis", "cnaipe Seapáinise \"anseo\"", "katakana"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “An-seo”"),
            keywords: &[
                "an-seo",
                "iapanais",
                "katakana",
                "putan Seapanais “An-seo”",
                "seapanais",
                "ココ",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"aquí\" en xaponés"),
            keywords: &[
                "aquí",
                "botón \"aquí\" en xaponés",
                "katakana",
                "koko",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચોરસમા\u{a82} અહી\u{a82} માટ\u{ac7}ન\u{ac1}\u{a82} જાપાની ચિહ\u{acd}ન"),
            keywords: &[
                "ચોરસમા\u{a82} અહી\u{a82} માટ\u{ac7}ન\u{ac1}\u{a82} જાપાની ચિહ\u{acd}ન",
                "જાપાની શબ\u{acd}દ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"a nan\" Na Japan"),
            keywords: &[
                "\"a nan\"",
                "Na Japan",
                "katakana",
                "maɓallin \"a nan\" Na Japan",
                "ココ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״כאן״ ביפנית"),
            keywords: &["יפנית", "לחצן ״כאן״ ביפנית", "קטאקאנה", "״כאן״", "ココ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चौकोर म\u{947}\u{902} यहा\u{902} क\u{947} लिए जापानी चिह\u{94d}न"),
            keywords: &[
                "चौकोर म\u{947}\u{902} यहा\u{902} का जापानी चिह\u{94d}न",
                "चौकोर म\u{947}\u{902} यहा\u{902} क\u{947} लिए जापानी चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"ovdje\""),
            keywords: &["japanski", "tipka s ideogramom \"ovdje\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „itt” gomb"),
            keywords: &["japán", "japán „itt” gomb", "katakana", "„itt”", "ココ"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կատականա կոկո"),
            keywords: &["կատականա կոկո", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"di sini\""),
            keywords: &[
                "\"di sini\"",
                "Jepang",
                "katakana",
                "tombol Jepang \"di sini\"",
                "ココ",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “ebe a”"),
            keywords: &[
                "Ndị Japan",
                "katakana",
                "Ọdụmbi Ndị Japan “ebe a”",
                "“ebe a”",
                "ココ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("katakana koko, kassi"),
            keywords: &["hér", "japanska", "katakana", "katakana koko, kassi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese per “Qui”"),
            keywords: &[
                "ideogramma giapponese per “Qui”",
                "ideogramma katakana qui",
                "katakana",
                "parola",
                "qui",
                "tabelloni",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ココのマーク"),
            keywords: &["ここ", "ココ", "ココのマーク"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"ing kene\""),
            keywords: &[
                "Jepang",
                "katakana",
                "tombol Jepang \"ing kene\"",
                "“ing kene”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იაპონური ღილაკი \"აქ\""),
            keywords: &["იაპონური", "იაპონური ღილაკი \"აქ\""],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «катакана коко»"),
            keywords: &["жапон", "шаршыдағы «катакана коко»"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk katakana koko"),
            keywords: &["japansk", "kvadratisk katakana koko"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរជប\u{17c9}\u{17bb}នព\u{17b8}រអានថា ក\u{17bb}ក\u{17bb}",
            ),
            keywords: &[
                "ក\u{17bb}ក\u{17bb}",
                "ជប\u{17c9}\u{17bb}ន",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរជប\u{17c9}\u{17bb}នព\u{17b8}រអានថា ក\u{17bb}ក\u{17bb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಇಲ\u{ccd}ಲ\u{cbf}\" ಬಟನ\u{ccd}"),
            keywords: &[
                "ಜಪಾನೀಸ\u{ccd} \"ಇಲ\u{ccd}ಲ\u{cbf}\" ಬಟನ\u{ccd}",
                "ಜಾಪನೀಸ\u{ccd} ಪದ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일본어 \"여기\" 버튼"),
            keywords: &["koko", "일본어", "일본어 \"여기\" 버튼", "카타카나"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “हा\u{902}गा” बटण"),
            keywords: &[
                "काटाकाना",
                "जपानी",
                "जपानी “हा\u{902}गा” बटण",
                "“हा\u{902}गा”",
                "ココ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы катакана коко"),
            keywords: &["жапончо", "чарчыдагы катакана коко"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’hei’"),
            keywords: &[
                "Katakana",
                "japanesch",
                "japanesche Knäppchen ’hei’",
                "’hei’",
                "ココ",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຢ\u{eb9}\u{ec8}ທ\u{eb5}\u{ec8}ນ\u{eb5}\u{ec9}",
            ),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຢ\u{eb9}\u{ec8}ທ\u{eb5}\u{ec8}ນ\u{eb5}\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("čia reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "čia",
                "čia reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts Šeit katakanā kvadrātveida ietvarā"),
            keywords: &["japāņu", "uzraksts Šeit katakanā kvadrātveida ietvarā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"i konei\""),
            keywords: &[
                "\"i konei\"",
                "Hapanīhi",
                "katakana",
                "pātene Hapanīhi \"i konei\"",
                "ココ",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „тука“ на јапонски"),
            keywords: &["копче „тука“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"ഇവിടെ\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "ഇവിടെ",
                "കറ\u{d4d}റക\u{d4d}ക\u{d3e}ന",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"ഇവിടെ\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"энд\" гэсэн товчлуур"),
            keywords: &[
                "\"энд\"",
                "Японоор \"энд\" гэсэн товчлуур",
                "катакана",
                "ココ",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस कटाकाना कोको"),
            keywords: &[
                "\"य\u{947}थ\u{947}\"",
                "काटाकाना",
                "चौरस कटाकाना कोको",
                "जपानी",
                "जपानी \"य\u{947}थ\u{947}\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang ‘di sini’ Jepun"),
            keywords: &["butang ‘di sini’ Jepun", "jepun"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “hawn”"),
            keywords: &[
                "buttuna Ġappuniż “hawn”",
                "katakana",
                "Ġappuniż",
                "“hawn”",
                "ココ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ ဒ\u{102e}နေရာ ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a}ဘာသာ ဒ\u{102e}နေရာ ခလ\u{102f}တ\u{103a}",
                "ဂျပန\u{103a}ဘာသာစကား",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} ကတကန က\u{102d}\u{102f}က\u{102d}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«her» på japansk"),
            keywords: &[
                "her",
                "japansk",
                "katakana",
                "«her» på japansk",
                "«koko»",
                "ココ",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड कतकाना कोको"),
            keywords: &["जापानिज", "स\u{94d}क\u{94d}वायर\u{94d}ड कतकाना कोको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘hier’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘hier’",
                "Japans woordteken voor ‘hier’",
                "katakana",
                "‘hier’",
                "ココ",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«her» på japansk"),
            keywords: &[
                "her",
                "japansk",
                "katakana",
                "«her» på japansk",
                "«koko»",
                "ココ",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ଏଠ\u{b3e}ରେ” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b3e}ତ\u{b3e}କ\u{b3e}ନ\u{b3e}",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ଏଠ\u{b3e}ରେ” ବଟନ\u{b4d}\u{200c}",
                "“ଏଠ\u{b3e}ରେ”",
                "ココ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਇ\u{a71}ਥ\u{a47}\" ਬਟਨ"),
            keywords: &["\"ਇ\u{a71}ਥ\u{a47}\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی ’ ایتھے اے’ دا بٹن"),
            keywords: &[
                "جاپانی",
                "جاپانی ’ ایتھے اے’ دا بٹن",
                "کٹاکانا",
                "“ایتھے اے”",
                "ココ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Hia”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Hia”",
                "Japán Pípol",
                "Katákaná",
                "“Hia”",
                "ココ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „tutaj”"),
            keywords: &["ideogram", "japoński", "japoński przycisk „tutaj”", "koko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"دلته\" بټن"),
            keywords: &[
                "\"دلته\"",
                "جاپاني",
                "جاپاني \"دلته\" بټن",
                "کټاکنا",
                "ココ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “aqui”"),
            keywords: &[
                "botão japonês de “aqui”",
                "japonês",
                "katakana",
                "“aqui”",
                "ココ",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"aqui\" em japonês"),
            keywords: &["botão \"aqui\" em japonês", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „aici” în japoneză"),
            keywords: &[
                "buton cu semnificația „aici” în japoneză",
                "japozeză",
                "katakana",
                "„aici”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-184"),
            keywords: &["E10-184"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «здесь»"),
            keywords: &["здесь", "значок", "значок «здесь»", "кнопка", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’hano’ mu kiyapani"),
            keywords: &[
                "\"hano\"",
                "Katakana",
                "buto ya ’hano’ mu kiyapani",
                "y’Abayapani",
                "ココ",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘هتي’ بٽڻ"),
            keywords: &["جاپاني", "جاپاني ‘هتي’ بٽڻ", "ڪٽاڪنا", "“هتي”", "ココ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} katakana koko"),
            keywords: &["ජපන\u{dca}", "හතරැස\u{dca} katakana koko"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Tu"),
            keywords: &["japonský ideograf Tu", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »tukaj« v japonščini"),
            keywords: &[
                "gumb za »tukaj« v japonščini",
                "japonsko",
                "katakana",
                "pisava",
                "tukaj",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka Jabbaanka “halkan”"),
            keywords: &["Jabbaanka", "badhanka Jabbaanka “halkan”", "“halkan”"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «këtu» në japonisht"),
            keywords: &["butoni «këtu» në japonisht", "japonisht", "katakana"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("катакана коко у квадрату"),
            keywords: &[
                "катакана",
                "катакана коко у квадрату",
                "јапански",
                "јапанско дугме “овде”",
                "“овде”",
                "ココ",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["катакана коко у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("katakana koko u kvadratu"),
            keywords: &[
                "japanski",
                "japansko dugme “ovde”",
                "katakana",
                "katakana koko u kvadratu",
                "“ovde”",
                "ココ",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["katakana koko u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”här”-knapp"),
            keywords: &[
                "här",
                "japansk ”här”-knapp",
                "katakana",
                "katakana för koko",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("katakana koko kwenye mraba"),
            keywords: &["katakana koko kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"இங\u{bcd}கே\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"இங\u{bcd}கே\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఇక\u{c4d}కడ\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "కటక\u{c3e}న\u{c3e} క\u{c4b}క\u{c4b}",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఇక\u{c4d}కడ\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"инҷо\"-и ҷопонӣ"),
            keywords: &[
                "\"инҷо\"",
                "катакана",
                "тугмаи \"инҷо\"-и ҷопонӣ",
                "ҷопонӣ",
                "ココ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some(
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ท\u{e35}\u{e48}น\u{e35}\u{e48}”",
            ),
            keywords: &[
                "คะตะกะนะ",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ท\u{e35}\u{e48}น\u{e35}\u{e48}”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นอย\u{e39}\u{e48}ท\u{e35}\u{e48}น\u{e35}\u{e48}",
                "“ท\u{e35}\u{e48}น\u{e35}\u{e48}”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ኣብዚ” መልጎም"),
            keywords: &["ናይ ጃፓን", "ናይ ጃፓን “ኣብዚ” መልጎም", "ካታካና", "“ኣብዚ”", "ココ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"şu ýerde\" düwmesi"),
            keywords: &[
                "katakana",
                "ýaponça",
                "ýaponça \"şu ýerde\" düwmesi",
                "“şu ýerde”",
                "ココ",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «ʻi heni» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "heni",
                "meʻalolomi",
                "meʻalolomi «ʻi heni» (fakasiapani)",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"burada\" düğmesi"),
            keywords: &["Japonca", "Japonca \"burada\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «بۇ يەر» دېگەن كۇنۇپكا"),
            keywords: &[
                "«بۇ يەر»",
                "كاتاكانا",
                "ياپونچە",
                "ياپونچە «بۇ يەر» دېگەن كۇنۇپكا",
                "ココ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"тут\" японською"),
            keywords: &["кнопка \"тут\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"یہاں\" بٹن"),
            keywords: &["جاپانی \"یہاں\" بٹن", "چاپانی", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi katakanadagi koko so‘zi"),
            keywords: &["kvadrat ichidagi katakanadagi koko so‘zi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “tại đây”"),
            keywords: &[
                "Tiếng Nhật",
                "katakana",
                "nút Tiếng Nhật “tại đây”",
                "“tại đây”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"fii\" bu sapoŋ"),
            keywords: &[
                "\"fii\"",
                "Sapone",
                "bitoŋu \"fii\" bu sapoŋ",
                "katakana",
                "ココ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"apha\" laseJapan"),
            keywords: &[
                "\"apha\"",
                "IsiJapa",
                "iqhosha elithi \"apha\" laseJapan",
                "katakana",
                "ココ",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"nibi\""),
            keywords: &[
                "\"níbí\"",
                "Bọtini Japanisi \"nibi\"",
                "Japanese",
                "katakana",
                "ココ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「呢度」按鈕"),
            keywords: &["呢度", "日本", "日本「呢度」按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“呢度”按钮"),
            keywords: &["呢度", "日本", "日本“呢度”按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“这里”按钮"),
            keywords: &["按键", "日文", "日文的“这里”按钮", "此处"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日文KOKO"),
            keywords: &["koko", "日文KOKO", "日語", "片假名"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「呢度」按鈕"),
            keywords: &["日文", "日文嘅「呢度」按鈕", "日文字"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuthi lapha oluyiskwele"),
            keywords: &["lapha", "uphawu lokuthi lapha oluyiskwele"],
        },
    ],
};
#[doc = "🈂\u{fe0f}"]
pub const JAPANESE__SERVICE_CHARGE__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈂\u{fe0f}",
    codepoint: "1F202 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “service charge” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🈂",
        codepoint: "1F202",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "Japanese “service charge” button",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “diensfooi”-knopie"),
            keywords: &[
                "Japannees",
                "Japannese “diensfooi”-knopie",
                "Japannese “diensfooi”-knoppie",
                "katakana",
                "“diensfooi”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ካታካና ሳ ካሬ"),
            keywords: &["ካታካና ሳ ካሬ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /خدمة برسوم/ باليابانية"),
            keywords: &["الزر /خدمة برسوم/ باليابانية", "ياباني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “সেৱ\u{9be} ম\u{9be}চ\u{9c1}ল” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "ক\u{9be}ট\u{9be}ক\u{9be}ন\u{9be}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “সেৱ\u{9be} ম\u{9be}চ\u{9c1}ল” ব\u{9c1}ট\u{9be}ম",
                "“সেৱ\u{9be} ম\u{9be}চ\u{9c1}ল”",
                "サ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat katakana sa"),
            keywords: &["kvadrat katakana sa", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «сэрвіс» у квадраце"),
            keywords: &[
                "бясплатна",
                "пісьмо",
                "японскае",
                "ідэаграма «сэрвіс» у квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("„Са“ от катакана в квадрат"),
            keywords: &["японски", "„Са“ от катакана в квадрат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র ক\u{9be}ত\u{9be}ক\u{9be}ন\u{9be}স\u{9be}"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র ক\u{9be}ত\u{9be}ক\u{9be}ন\u{9be}স\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"usluga se naplaćuje\" na jap."),
            keywords: &[
                "Dugme \"usluga se naplaćuje\" na jap.",
                "Dugme sa tekstom \"usluga se naplaćuje\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"càrrec per servei\""),
            keywords: &[
                "botó japonès \"càrrec per servei\"",
                "japonès",
                "katakana",
                "quadre",
                "sa",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎠᏓᏂᏟᏗᎢ” ᎦᏗ"),
            keywords: &["ᎧᏔᎧᎾ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎠᏓᏂᏟᏗᎢ” ᎦᏗ", "“ᎠᏓᏂᏟᏗᎢ”", "サ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek – japonský znak „pozornost podniku“"),
            keywords: &[
                "bezplatně",
                "japonština",
                "katakana",
                "poplatek",
                "služba",
                "zdarma",
                "štítek – japonský znak „pozornost podniku“",
                "サ",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("katakana sa mewn sgwâr"),
            keywords: &["Japaneaidd", "katakana sa mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for serviceafgift"),
            keywords: &["japansk", "kvadratisk ideogram for serviceafgift"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen „sa“"),
            keywords: &["Schriftzeichen „sa“", "japanisches Schriftzeichen", "„sa“"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα χρέωσης υπηρεσίας σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα χρέωσης υπηρεσίας σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “service charge” button"),
            keywords: &[
                "Japanese",
                "Japanese “service charge” button",
                "katakana",
                "“service charge”",
                "サ",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"de cortesía\""),
            keywords: &[
                "cortesía",
                "ideograma japonés para \"de cortesía\"",
                "japonés",
                "katakana",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"teenustasu\""),
            keywords: &[
                "\"teenustasu\"",
                "jaapani keel",
                "jaapani nupp \"teenustasu\"",
                "katakana",
                "サ",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("katakana sa karratu batean"),
            keywords: &["japoniera", "katakana sa karratu batean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} «هزینه\u{654} خدمات» به ژاپنی"),
            keywords: &[
                "دکمه\u{654} «هزینه\u{654} خدمات» به ژاپنی",
                "رایگان",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("palvelumaksu-kirjainmerkki"),
            keywords: &[
                "japani",
                "katakana",
                "kirjoitusmerkki",
                "palvelumaksu-kirjainmerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button para sa salitang \"service charge\""),
            keywords: &[
                "Hapones",
                "Hapones na button para sa salitang \"service charge\"",
                "katakana",
                "nakaparisukat na katakana na sa",
                "pindutan",
                "serbisyo",
                "singil",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"avgreiðslugjald\" knappur"),
            keywords: &[
                "\"avgreiðslugjald\"",
                "\"borðreiðingargjald\"",
                "japanskur",
                "japanskur \"avgreiðslugjald\" knappur",
                "katakana",
                "サ",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton frais de service en japonais"),
            keywords: &[
                "bouton frais de service en japonais",
                "frais de service",
                "japonais",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some(
                "symbole japonais signifiant «\u{a0}service\u{a0}» ou «\u{a0}service payant\u{a0}»",
            ),
            keywords: &[
                "japonais",
                "katakana",
                "payant",
                "service",
                "symbole japonais signifiant «\u{a0}service\u{a0}» ou «\u{a0}service payant\u{a0}»",
                "サ",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"táille seirbhíse\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"táille seirbhíse\"",
                "cnáipe Seapáinis \"táille seirbhíse\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “tàille seirbheise”"),
            keywords: &[
                "iapanais",
                "katakana",
                "putan Seapanais “tàille seirbheise”",
                "seapanais",
                "tàille seirbheise",
                "サ",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón “cargo por servizo” en xaponés"),
            keywords: &[
                "botón “cargo por servizo” en xaponés",
                "cargo por servizo",
                "comisión",
                "katakana",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "ચોરસમા\u{a82} \"સ\u{ac7}વા શ\u{ac1}લ\u{acd}ક\" હ\u{ac7}ત\u{ac1} જાપાની ચિહ\u{acd}ન",
            ),
            keywords: &[
                "કટકાના",
                "ચોરસમા\u{a82} \"સ\u{ac7}વા શ\u{ac1}લ\u{acd}ક\" હ\u{ac7}ત\u{ac1} જાપાની ચિહ\u{acd}ન",
                "જાપાનીઝ",
                "“સ\u{ac7}વા શ\u{ac1}લ\u{acd}ક”",
                "サ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"cajin aiki\" Na Japan"),
            keywords: &[
                "\"cajin aiki\"",
                "Na Japan",
                "katakana",
                "maɓallin \"cajin aiki\" Na Japan",
                "サ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״דמי שירות״ ביפנית"),
            keywords: &[
                "יפנית",
                "לחצן ״דמי שירות״ ביפנית",
                "קטאקאנה",
                "״דמי שירות״",
                "サ",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी सर\u{94d}विस चार\u{94d}ज बटन"),
            keywords: &[
                "जापानी सर\u{94d}विस चार\u{94d}ज बटन",
                "बटन",
                "सर\u{94d}विस चार\u{94d}ज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"naplata usluge\""),
            keywords: &["japanski", "tipka s ideogramom \"naplata usluge\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „szervizdíj” gomb"),
            keywords: &[
                "japán",
                "japán „szervizdíj” gomb",
                "katakana",
                "„szervizdíj”",
                "サ",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կատականա սա"),
            keywords: &["կատականա սա", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"biaya layanan\""),
            keywords: &[
                "\"biaya layanan\"",
                "Jepang",
                "katakana",
                "tombol Jepang \"biaya layanan\"",
                "サ",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “ụgwọ ọrụ”"),
            keywords: &[
                "Ndị Japan",
                "katakana",
                "Ọdụmbi Ndị Japan “ụgwọ ọrụ”",
                "“ụgwọ ọrụ”",
                "サ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("katakana sa, kassi"),
            keywords: &[
                "japanska",
                "katakana",
                "katakana sa, kassi",
                "þjónustugjald",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Costo del servizio”"),
            keywords: &[
                "ideogramma giapponese di “Costo del servizio”",
                "ideogramma katakana sa",
                "katakana",
                "parola",
                "sa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サのマーク"),
            keywords: &["サ", "サのマーク", "サービス料"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"beya laden\""),
            keywords: &[
                "Jepang",
                "katakana",
                "tombol Jepang \"beya laden\"",
                "“beya laden”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იაპონური ღილაკი „სერვისის გადასახადი“"),
            keywords: &["იაპონური", "იაპონური ღილაკი „სერვისის გადასახადი“"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «катакана са»"),
            keywords: &["жапон", "шаршыдағы «катакана са»"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk katakana sa"),
            keywords: &["japansk", "kvadratisk katakana sa"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរជប\u{17c9}\u{17bb}នម\u{17bd}យអានថា សាក\u{17cb}",
            ),
            keywords: &[
                "ជប\u{17c9}\u{17bb}ន",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរជប\u{17c9}\u{17bb}នម\u{17bd}យអានថា សាក\u{17cb}",
                "សាក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಸೇವಾ ಶುಲ\u{ccd}ಕ\" ಬಟನ\u{ccd}"),
            keywords: &[
                "ಕತಕನಾ",
                "ಜಪಾನೀಸ\u{ccd} \"ಸೇವಾ ಶುಲ\u{ccd}ಕ\" ಬಟನ\u{ccd}",
                "ಜಾಪನೀಸ\u{ccd}",
                "ಜಾಪನೀಸ\u{ccd} “ಸೇವಾ ಶುಲ\u{ccd}ಕ” ಬಟನ\u{ccd}",
                "“ಸೇವಾ ಶುಲ\u{ccd}ಕ”",
                "サ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("일본어 \"봉사료\" 버튼"),
            keywords: &["sa", "일본어", "일본어 \"봉사료\" 버튼", "카타카나"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “स\u{947}वा श\u{941}ल\u{94d}क” बटण"),
            keywords: &[
                "काटकाना",
                "जपानी",
                "जपानी “स\u{947}वा श\u{941}ल\u{94d}क” बटण",
                "“स\u{947}वा श\u{941}ल\u{94d}क”",
                "サ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы катакана са"),
            keywords: &["жапончо", "чарчыдагы катакана са"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’Serviceännerung’"),
            keywords: &[
                "Katakana",
                "japanesch",
                "japanesche Knäppchen ’Serviceännerung’",
                "’Serviceännerung’",
                "サ",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຊະ"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຊະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paslaugos mokestį reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "paslaugos mokestis",
                "paslaugos mokestį reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzraksts Pakalpojums katakanā kvadrātveida ietvarā"),
            keywords: &[
                "japāņu",
                "uzraksts Pakalpojums katakanā kvadrātveida ietvarā",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"utu ratonga\""),
            keywords: &[
                "\"utu ratonga\"",
                "Hapanīhi",
                "katakana",
                "pātene Hapanīhi \"utu ratonga\"",
                "サ",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „услугата се наплаќа“ на јапонски"),
            keywords: &["копче „услугата се наплаќа“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സേവന നിരക\u{d4d}ക\u{d4d}\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "\"സേവന നിരക\u{d4d}ക\u{d4d}\"",
                "കറ\u{d4d}റക\u{d4d}ക\u{d3e}ന",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സേവന നിരക\u{d4d}ക\u{d4d}\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"үйлчилгээний төлбөр\" гэсэн товчлуур"),
            keywords: &[
                "\"үйлчилгээний төлбөр\"",
                "Японоор \"үйлчилгээний төлбөр\" гэсэн товчлуур",
                "катакана",
                "サ",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस कटाकाना सा"),
            keywords: &[
                "\"स\u{947}वा श\u{941}ल\u{94d}क\"",
                "काटाकाना",
                "चौरस कटाकाना सा",
                "जपानी",
                "जपानी \"स\u{947}वा श\u{941}ल\u{94d}क\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang ‘caj perkhidmatan’ Jepun"),
            keywords: &[
                "\"caj perkhidmatan\"",
                "Jepun",
                "butang \"caj perkhidmatan Jepun",
                "butang ‘caj perkhidmatan’ Jepun",
                "katakana",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “imposta’ għal servizz“"),
            keywords: &[
                "buttuna Ġappuniż “imposta’ għal servizz“",
                "katakana",
                "Ġappuniż",
                "“imposta tas-servizz”",
                "サ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ ဝန\u{103a}ဆောင\u{103a}ခ ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ ဝန\u{103a}ဆောင\u{103a}ခ ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} ကတကန စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«gebyr» på japansk"),
            keywords: &[
                "gebyr",
                "japansk",
                "katakana",
                "«gebyr» på japansk",
                "«sa»",
                "サ",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड कतकाना एसए"),
            keywords: &["जापानिज", "स\u{94d}क\u{94d}वायर\u{94d}ड कतकाना एसए"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘dienstenheffing’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘dienstenheffing’",
                "Japans teken voor ‘dienst’",
                "katakana",
                "‘dienstenheffing’",
                "サ",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«gebyr» på japansk"),
            keywords: &[
                "gebyr",
                "japansk",
                "katakana",
                "«gebyr» på japansk",
                "«sa»",
                "サ",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ସେବ\u{b3e} ଦେୟ” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "କ\u{b3e}ତ\u{b3e}କ\u{b3e}ନ\u{b3e}",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ସେବ\u{b3e} ଦେୟ” ବଟନ\u{b4d}\u{200c}",
                "“ସେବ\u{b3e} ଦେୟ”",
                "サ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਸ\u{a47}ਵਾ ਸ\u{a3c}\u{a41}ਲਕ\" ਬਟਨ"),
            keywords: &["\"ਸ\u{a47}ਵਾ ਸ\u{a3c}\u{a41}ਲਕ\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “خدمت دا معاوضہ” دا بٹن"),
            keywords: &[
                "جاپانی",
                "جاپانی “خدمت دا معاوضہ” دا بٹن",
                "کٹاکانا",
                "“خدمت دا معاوضہ”",
                "サ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Sávís Chaj”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Sávís Chaj”",
                "Japán Pípol",
                "Katákaná",
                "“Sávís Chaj”",
                "サ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sa w języku katakana"),
            keywords: &["ideogram", "japoński", "sa", "sa w języku katakana"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جاپاني \"خدمت چارج\"بټن"),
            keywords: &[
                "\"خدمت بټن\"",
                "جاپاني",
                "د جاپاني \"خدمت چارج\"بټن",
                "کټاکنا",
                "サ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “taxa de serviço”"),
            keywords: &[
                "botão japonês de “taxa de serviço”",
                "japonês",
                "katakana",
                "“taxa de serviço”",
                "サ",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"taxa de serviço\" em japonês"),
            keywords: &[
                "botão \"taxa de serviço\" em japonês",
                "japonês",
                "katakana",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „taxă pentru serviciu” în japoneză"),
            keywords: &[
                "buton cu semnificația „taxă pentru serviciu” în japoneză",
                "japozeză",
                "katakana",
                "„taxă pentru serviciu”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-185"),
            keywords: &["E10-185"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("цена услуги"),
            keywords: &["значок", "кнопка", "цена услуги", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ibuto y’ \"amafaranga ya serivisi\" y’Abayapani"),
            keywords: &[
                "\"amafaranga ya serivisi\"",
                "Ibuto y’ \"amafaranga ya serivisi\" y’Abayapani",
                "Katakana",
                "y’Abayapani",
                "サ",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني “سروس چارج” بٽڻ"),
            keywords: &[
                "جاپاني",
                "جاپاني “سروس چارج” بٽڻ",
                "ڪٽاڪنا",
                "“سروس چارج”",
                "サ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} katakana sa"),
            keywords: &["ජපන\u{dca}", "හතරැස\u{dca} katakana sa"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Poplatok za službu"),
            keywords: &["japonský ideograf Poplatok za službu", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("japonski znak za \"napitnino\" v kvadratu"),
            keywords: &[
                "japonski znak za \"napitnino\" v kvadratu",
                "japonsko",
                "katakana",
                "napitnina",
                "pisava",
                "postrežnina",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ‘‘lacagta adeegga’‘ ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka ‘‘lacagta adeegga’‘ ee Jabbaanka",
                "katakana",
                "‘‘lacagta adeegga’‘",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «tarifa e shërbimit» në japonisht"),
            keywords: &[
                "butoni «tarifa e shërbimit» në japonisht",
                "japonisht",
                "katakana",
                "«tarifa e shërbimit»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("катакана са у квадрату"),
            keywords: &[
                "jaпaнски",
                "jaпaнско дугме “наплата услуге”",
                "катакана",
                "катакана са у квадрату",
                "„наплата услуге“",
                "サ",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["катакана са у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("katakana sa u kvadratu"),
            keywords: &[
                "japanski",
                "japansko dugme “naplata usluge”",
                "katakana",
                "katakana sa u kvadratu",
                "„naplata usluge“",
                "サ",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["katakana sa u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”serviceavgift”-knapp"),
            keywords: &[
                "japansk ”serviceavgift”-knapp",
                "katakana",
                "katakana för sa",
                "serviceavgift",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("katakana sa kwenye mraba"),
            keywords: &["katakana sa kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"சேவைக\u{bcd} கட\u{bcd}டணம\u{bcd}\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"சேவைக\u{bcd} கட\u{bcd}டணம\u{bcd}\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"స\u{c47}వ\u{c3e} ఛ\u{c3e}ర\u{c4d}జ\u{c40}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "కటక\u{c3e}న\u{c3e} స\u{c3e}",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"స\u{c47}వ\u{c3e} ఛ\u{c3e}ర\u{c4d}జ\u{c40}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Маблағи хизматрасонӣ\"-и ҷопонӣ"),
            keywords: &[
                "\"маблағи хизматрасонӣ\"",
                "катакана",
                "тугмаи \"Маблағи хизматрасонӣ\"-и ҷопонӣ",
                "ҷопонӣ",
                "サ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ค\u{e48}าบร\u{e34}การ”"),
            keywords: &[
                "คะตะกะนะ",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ค\u{e48}าบร\u{e34}การ”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}าซะ",
                "“ค\u{e48}าบร\u{e34}การ”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ክፍሊት ኣገልግሎት” መልጎም"),
            keywords: &[
                "ናይ ጃፓን",
                "ናይ ጃፓን “ክፍሊት ኣገልግሎት” መልጎም",
                "ካታካና",
                "“ክፍሊት ኣገልግሎት”",
                "サ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"hyzmat tölegi\" düwmesi"),
            keywords: &[
                "katakana",
                "ýaponça",
                "ýaponça \"hyzmat tölegi\" düwmesi",
                "“hyzmat tölegi”",
                "サ",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «totongi faifatongia» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «totongi faifatongia» (fakasiapani)",
                "totongi faifatongia",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"servis ücreti\" düğmesi"),
            keywords: &["Japonca", "Japonca \"servis ücreti\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «مۇلازىمەت ھەققى» دېگەن كۇنۇپكا"),
            keywords: &[
                "«مۇلازىمەت ھەققى»",
                "كاتاكانا",
                "ياپونچە",
                "ياپونچە «مۇلازىمەت ھەققى» دېگەن كۇنۇپكا",
                "サ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"сервісний збір\" японською"),
            keywords: &["кнопка \"сервісний збір\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"سروس چارج\" بٹن"),
            keywords: &["جاپانی", "جاپانی \"سروس چارج\" بٹن", "چوکور"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi katakana sa morasi"),
            keywords: &["kvadrat ichidagi katakana sa morasi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “phí dịch vụ”"),
            keywords: &[
                "Tiếng Nhật",
                "katakana",
                "nút Tiếng Nhật “phí dịch vụ”",
                "“phí dịch vụ”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"dafa am juuti\" bu sapoŋ"),
            keywords: &[
                "\"fay cër\"",
                "Sapone",
                "bitoŋu \"dafa am juuti\" bu sapoŋ",
                "katakana",
                "サ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"intalwulo yenkonzo\" lesiJapan"),
            keywords: &[
                "\"intalwulo yenkonzo\"",
                "IsiJapan",
                "iqhosha elithi \"intalwulo yenkonzo\" lesiJapan",
                "katakana",
                "サ",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọ\u{301}tìnì Japanísì \"ìdíyelé fún owó ọ\u{300}yà\""),
            keywords: &[
                "\"ìdíyelé fún owó ọ\u{300}yà\"",
                "Bọ\u{301}tìnì Japanísì \"ìdíyelé fún owó ọ\u{300}yà\"",
                "Japanese",
                "katakana",
                "サ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「服務費」按鈕"),
            keywords: &["日本", "日本「服務費」按鈕", "服務費"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“服务费”按钮"),
            keywords: &["日本", "日本“服务费”按钮", "服务费"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“服务费”按钮"),
            keywords: &["按键", "收费", "日文", "日文的“服务费”按钮", "服务"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("日文服務區"),
            keywords: &["sa", "日文服務區", "日語", "片假名"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「服務費」按鈕"),
            keywords: &["小費", "日文嘅「服務費」按鈕", "服務費"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokumahhala oluyiskwele"),
            keywords: &["mahhala", "uphawu lokumahhala oluyiskwele"],
        },
    ],
};
#[doc = "🈷\u{fe0f}"]
pub const JAPANESE__MONTHLY_AMOUNT__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈷\u{fe0f}",
    codepoint: "1F237 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “monthly amount” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🈷",
        codepoint: "1F237",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "Japanese “monthly amount” button",
        group: "Symbols",
        subgroup: "alphanum",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “maandrekening”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “maandrekening”-knoppie",
                "ideogram",
                "“maandrekening”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጨረቃ ካሬ አይዶግራፍ"),
            keywords: &["የጃፓን", "የጨረቃ ካሬ አይዶግራፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /مبلغ شهري/ باليابانية"),
            keywords: &["الزر /مبلغ شهري/ باليابانية", "اليابانية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "জ\u{9be}প\u{9be}নী “ম\u{9be}হেকীয\u{9bc}\u{9be} পৰিম\u{9be}ণ” ব\u{9c1}ট\u{9be}ম",
            ),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “ম\u{9be}হেকীয\u{9bc}\u{9be} পৰিম\u{9be}ণ” ব\u{9c1}ট\u{9be}ম",
                "“ম\u{9be}হেকীয\u{9bc}\u{9be} পৰিম\u{9be}ণ”",
                "月",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat ay ideoqramı"),
            keywords: &["kvadrat ay ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «месяц» у квадраце"),
            keywords: &[
                "пісьмо",
                "штомесяц",
                "японскае",
                "ідэаграма «месяц» у квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „луна“ в квадрат"),
            keywords: &["Идеограма „луна“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র ম\u{9c1}ন চিত\u{9cd}রলিপি"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র ম\u{9c1}ন চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"mjesečni iznos\" na jap."),
            keywords: &[
                "Dugme \"mjesečni iznos\" na jap.",
                "Dugme sa tekstom \"mjesečni iznos\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"import mensual\""),
            keywords: &[
                "\"quantitat mensual\"",
                "botó japonès \"import mensual\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᏏᏅᏓ ᏳᏓᎵ ᎠᏯᏙᏢᎢ” ᎦᏗ"),
            keywords: &[
                "ᎦᏅᏍᏙᏍᎬ",
                "ᏣᏩᏂᏏ",
                "ᏣᏩᏂᏏ “ᏏᏅᏓ ᏳᏓᎵ ᎠᏯᏙᏢᎢ” ᎦᏗ",
                "“ᏏᏅᏓ ᏳᏓᎵ ᎠᏯᏙᏢᎢ”",
                "月",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „měsíc“"),
            keywords: &[
                "ideogram",
                "japonština",
                "měsíční",
                "měsíčně",
                "štítek s japonským znakem „měsíc“",
                "月",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff lleuad mewn sgwâr"),
            keywords: &["Japaneaidd", "ideograff lleuad mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for månedligt beløb"),
            keywords: &["japansk", "kvadratisk ideogram for månedligt beløb"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „Monatsbetrag“"),
            keywords: &[
                "Schriftzeichen für „Monatsbetrag“",
                "japanisches Schriftzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα μηνιαίου ποσού σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα μηνιαίου ποσού σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “monthly amount” button"),
            keywords: &[
                "Japanese",
                "Japanese “monthly amount” button",
                "ideograph",
                "“monthly amount”",
                "月",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"cantidad mensual\""),
            keywords: &[
                "ideograma",
                "ideograma japonés para \"cantidad mensual\"",
                "japonés",
                "kanji",
                "“cantidad mensual”",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("\"cantidad mensual\" en japonés"),
            keywords: &[
                "\"cantidad mensual\" en japonés",
                "ideograma",
                "japonés",
                "mensual",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ideograma japonés de \"cantidad mensual\""),
            keywords: &[
                "ideograma",
                "ideograma japonés de \"cantidad mensual\"",
                "ideograma japonés para \"cantidad mensual\"",
                "japonés",
                "kanji",
                "“cantidad mensual”",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"kuutasu\""),
            keywords: &[
                "\"kuutasu\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"kuutasu\"",
                "月",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"hileko zenbatekoa\" botoia"),
            keywords: &[
                "ilargia irudikatzen duen ideograma karratu batean",
                "japoniera",
                "japonierazko \"hileko zenbatekoa\" botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} «مقدار ماهانه» به ژاپنی"),
            keywords: &["دکمه\u{654} «مقدار ماهانه» به ژاپنی", "ماه", "ژاپنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuukausittainen määrä -kirjainmerkki"),
            keywords: &[
                "japani",
                "kirjoitusmerkki",
                "kuukausittainen määrä -kirjainmerkki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button para sa salitang \"monthly amount\""),
            keywords: &[
                "Hapones",
                "Hapones na button para sa salitang \"monthly amount\"",
                "buwanan",
                "halaga",
                "ideograpya",
                "nakaparisukat na ideograph ng buwan",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"mánaðarlig upphædd\" knappur"),
            keywords: &[
                "\"mánaðarlig upphædd\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"mánaðarlig upphædd\" knappur",
                "月",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton montant mensuel en japonais"),
            keywords: &[
                "bouton montant mensuel en japonais",
                "japonais",
                "montant mensuel",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}montant mensuel\u{a0}»"),
            keywords: &[
                "idéogramme",
                "japonais",
                "montant mensuel",
                "symbole japonais signifiant «\u{a0}montant mensuel\u{a0}»",
                "月",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"méid míosúil\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"méid míosúil\"",
                "cnáipe Seapáinis \"méid míosúil\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “tàille mhìosail”"),
            keywords: &[
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “tàille mhìosail”",
                "seapanais",
                "tàille mhìosail",
                "月",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"cantidade mensual\" en xaponés"),
            keywords: &[
                "botón \"cantidade mensual\" en xaponés",
                "cantidade mensual",
                "ideograma",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "\"માસિક રકમ\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
            ),
            keywords: &[
                "\"માસિક રકમ\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“માસિક રકમ”",
                "月",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"kuɗin wata-wata\" Na Japan"),
            keywords: &[
                "\"kuɗin wata-wata\"",
                "Na Japan",
                "maɓallin \"kuɗin wata-wata\" Na Japan",
                "zanen harshe",
                "月",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״כמות חודשית״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״כמות חודשית״ ביפנית",
                "״כמות חודשית״",
                "月",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “मासिक श\u{941}ल\u{94d}क” बटन"),
            keywords: &[
                "जापानी “मासिक श\u{941}ल\u{94d}क” बटन",
                "“मासिक श\u{941}ल\u{94d}क”",
                "月",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"mjesečni iznos\""),
            keywords: &["japanski", "tipka s ideogramom \"mjesečni iznos\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „havi összeg” gomb"),
            keywords: &[
                "japán",
                "japán „havi összeg” gomb",
                "képírásjel",
                "„havi összeg”",
                "月",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լուսին գաղափարագիր"),
            keywords: &["լուսին գաղափարագիր", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"jumlah bulanan\""),
            keywords: &[
                "\"jumlah bulanan\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"jumlah bulanan\"",
                "月",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “ọnụego kwa onwa”"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi Ndị Japan “ọnụego kwa onwa”",
                "“ọnụego kwa onwa”",
                "月",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("mánaðarleg upphæð, kassi"),
            keywords: &[
                "japanska",
                "myndletur",
                "mánaðarleg upphæð",
                "mánaðarleg upphæð, kassi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Importo mensile”"),
            keywords: &[
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Importo mensile”",
                "luna",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("月マーク"),
            keywords: &["月", "月マーク", "月極", "月額"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"gunggung sesasen\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"gunggung sesasen\"",
                "“gunggung sesasen”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთვარის იდეოგრამა კვადრატში"),
            keywords: &["იაპონური", "მთვარის იდეოგრამა კვადრატში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «ай» иероглифі"),
            keywords: &["жапон", "шаршыдағы «ай» иероглифі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for måne"),
            keywords: &["japansk", "kvadratisk ideogram for måne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
            ),
            keywords: &[
                "ច\u{17b7}ន ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ព\u{17d2}រះច\u{17d0}ន\u{17d2}ទ",
                "អក\u{17d2}សរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಮಾಸ\u{cbf}ಕ ಮೊತ\u{ccd}ತ\" ಬಟನ\u{ccd}"),
            keywords: &[
                "ಐಡ\u{cbf}ಯೋಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} \"ಮಾಸ\u{cbf}ಕ ಮೊತ\u{ccd}ತ\" ಬಟನ\u{ccd}",
                "“\"ಮಾಸ\u{cbf}ಕ ಮೊತ\u{ccd}ತ”",
                "月",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달 월"),
            keywords: &["개월", "달", "달 월", "한달"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “मासीक रक\u{94d}कम”बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “मासीक रक\u{94d}कम”बटण",
                "जपानी “म\u{94d}हयन\u{94d}याळी रक\u{94d}कम” बटण",
                "“म\u{94d}हयन\u{94d}याळी रक\u{94d}कम”",
                "月",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы ай идеограммасы"),
            keywords: &["жапончо", "чарчыдагы ай идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’mountleche Betrag’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’mountleche Betrag’",
                "’mountleche Betrag’",
                "月",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ພະຈ\u{eb1}ນ"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ພະຈ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėnesio sumą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "mėnesio suma",
                "mėnesio sumą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Mēness kvadrātveida ietvarā"),
            keywords: &["ideogramma Mēness kvadrātveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"nuinga ā-marama\""),
            keywords: &[
                "\"nuinga ā-marama\"",
                "Hapanīhi",
                "pātene Hapanīhi \"nuinga ā-marama\"",
                "tohuwhakairo",
                "月",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „месечна сума“ на јапонски"),
            keywords: &["копче „месечна сума“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"പ\u{d4d}രതിമ\u{d3e}സ ത\u{d41}ക\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "\"പ\u{d4d}രതിമ\u{d3e}സ ത\u{d41}ക\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"പ\u{d4d}രതിമ\u{d3e}സ ത\u{d41}ക\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"сарын дүн\" гэсэн товчлуур"),
            keywords: &[
                "\"сарын дүн\"",
                "Японоор \"сарын дүн\" гэсэн товчлуур",
                "дүрс үсэг",
                "月",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस च\u{902}द\u{94d}र स\u{902}क\u{947}त"),
            keywords: &[
                "\"मासिक रक\u{94d}कम\"",
                "\"स\u{947}वा श\u{941}ल\u{94d}क\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस च\u{902}द\u{94d}र स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"मोफत नाही\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “amaun bulanan” Jepun"),
            keywords: &[
                "Jepun",
                "butang “amaun bulanan” Jepun",
                "ideograf",
                "“amaun bulanan”",
                "月",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “ammont ta’ kull xahar”"),
            keywords: &[
                "buttuna Ġappuniż “ammont ta’ kull xahar”",
                "ideograff",
                "Ġappuniż",
                "“ammont ta’ kull xahar”",
                "月",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ လစဉ\u{103a}ကြေး ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ လစဉ\u{103a}ကြေး ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} လ အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«månedlig beløp» på japansk"),
            keywords: &[
                "ideograf",
                "japansk",
                "månedlig beløp",
                "«månedlig beløp» på japansk",
                "月",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड चन\u{94d}द\u{94d}रमा आइडियोग\u{94d}राफ"),
            keywords: &[
                "जापानिज",
                "स\u{94d}क\u{94d}वायर\u{94d}ड चन\u{94d}द\u{94d}रमा आइडियोग\u{94d}राफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘maandelijks bedrag’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘maandelijks bedrag’",
                "ideogram",
                "‘maandelijks bedrag’",
                "月",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«månadleg beløp» på japansk"),
            keywords: &[
                "ideograf",
                "japansk",
                "månadleg beløp",
                "«månadleg beløp» på japansk",
                "月",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ମ\u{b3e}ସ\u{b3f}କ ର\u{b3e}ଶ\u{b3f}” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ମ\u{b3e}ସ\u{b3f}କ ର\u{b3e}ଶ\u{b3f}” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ମ\u{b3e}ସ\u{b3f}କ ର\u{b3e}ଶ\u{b3f}”",
                "月",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਮਾਸਿਕ ਰਾਸ\u{a3c}ੀ\" ਬਟਨ"),
            keywords: &["\"ਮਾਸਿਕ ਰਾਸ\u{a3c}ੀ\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “ماہانہ رقم” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “ماہانہ رقم” دا بٹن",
                "“ماہانہ رقم”",
                "月",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Mọ\u{301}nt Bai Mọ\u{301}nt Amaunt”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Mọ\u{301}nt Bai Mọ\u{301}nt Amaunt”",
                "Japán Pípol",
                "Japán Raítin",
                "“Mọ\u{301}nt Bai Mọ\u{301}nt Amaunt”",
                "月",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ideogram księżyca"),
            keywords: &["ideogram", "ideogram księżyca", "japoński", "księżyc"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جاپان د \"میاشتنی پيسې\" بټن"),
            keywords: &[
                "\"مياشتنۍ پيسې\"",
                "آيډوګراپ",
                "جاپاني",
                "د جاپان د \"میاشتنی پيسې\" بټن",
                "月",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “quantidade mensal”"),
            keywords: &[
                "botão japonês de “quantidade mensal”",
                "ideograma",
                "japonês",
                "“quantidade mensal”",
                "月",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"valor mensal\" em japonês"),
            keywords: &["botão \"valor mensal\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „valoare lunară” în japoneză"),
            keywords: &[
                "buton cu semnificația „valoare lunară” în japoneză",
                "ideogramă",
                "japoneză",
                "„valoare lunară”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-193"),
            keywords: &["E10-193"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("месяц"),
            keywords: &["значок", "кнопка", "месяц", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ibuto y’\"amafaranga ya buri kwezi\" y’Abayapani"),
            keywords: &[
                "\"amafaranga ya buri kwezi\"",
                "Ibuto y’\"amafaranga ya buri kwezi\" y’Abayapani",
                "Nyapani",
                "imyandikire",
                "月",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني “ماهوار رقم” بٽڻ"),
            keywords: &[
                "آئڊيوگراف",
                "جاپاني",
                "جاپاني “ماهوار رقم” بٽڻ",
                "“ماهوار رقم”",
                "月",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} සඳ සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &["ජපන\u{dca}", "හතරැස\u{dca} සඳ සංකල\u{dca}ප ලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Mesačná suma"),
            keywords: &["japonský ideograf Mesačná suma", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("japonski znak za \"mesečni znesek\""),
            keywords: &[
                "ideogram",
                "japonski znak za \"mesečni znesek\"",
                "japonski znak za \"mesečni znesek\" v kvadratu",
                "japonsko",
                "mesečni znesek",
                "pojmovni znak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka “qaddarka billaha ah” ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka “qaddarka billaha ah” ee Jabbaanka",
                "fikrad-garafeed",
                "“qaddarka billaha ah”",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «shuma mujore» në japonisht"),
            keywords: &[
                "butoni «shuma mujore» në japonisht",
                "ideograf",
                "«shuma mujore»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „месец“ у квадрату"),
            keywords: &[
                "идеограф",
                "идеограф „месец“ у квадрату",
                "јапански",
                "јапанско дугме „месечна количина“",
                "„месечна количина“",
                "月",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("идеограф „мјесец“ у квадрату"),
            keywords: &["идеограф „мјесец“ у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „mesec“ u kvadratu"),
            keywords: &[
                "ideograf",
                "ideograf „mesec“ u kvadratu",
                "japanski",
                "japansko dugme „mesečna količina“",
                "„mesečna količina“",
                "月",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("ideograf „mjesec“ u kvadratu"),
            keywords: &["ideograf „mjesec“ u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”månadsbelopp”-knapp"),
            keywords: &[
                "ideogram",
                "ideogram för månad",
                "japansk",
                "japansk ”månadsbelopp”-knapp",
                "månadsbelopp",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya mwezi kwenye mraba"),
            keywords: &["idiografu ya mwezi kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"ம\u{bbe}த\u{bbe}ந\u{bcd}திரத\u{bcd} தொகை\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"ம\u{bbe}த\u{bbe}ந\u{bcd}திரத\u{bcd} தொகை\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"న\u{c46}లవ\u{c3e}ర\u{c40} మ\u{c4a}త\u{c4d}తం\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"న\u{c46}లవ\u{c3e}ర\u{c40} మ\u{c4a}త\u{c4d}తం\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"арзиши моҳона\"-и ҷопонӣ"),
            keywords: &[
                "\"арзиши моҳона\"",
                "идеограмма",
                "тугмаи \"арзиши моҳона\"-и ҷопонӣ",
                "ҷопонӣ",
                "月",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “จำนวนต\u{e48}อเด\u{e37}อน”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “จำนวนต\u{e48}อเด\u{e37}อน”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นพระจ\u{e31}นทร\u{e4c}",
                "“จำนวนต\u{e48}อเด\u{e37}อน”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ወርሓዊ ድምር” መልጎም"),
            keywords: &[
                "ናይ ጃፓን",
                "ናይ ጃፓን “ወርሓዊ ድምር” መልጎም",
                "ኣይድዮግራፍ",
                "“ወርሓዊ ድምር”",
                "月",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"aýlyk möçber\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"aýlyk möçber\" düwmesi",
                "“aýlyk möçber”",
                "月",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «moʻua fakamāhina» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «moʻua fakamāhina» (fakasiapani)",
                "moʻua fakamāhina",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"aylık ücret\" düğmesi"),
            keywords: &["Japonca", "Japonca \"aylık ücret\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «ئايلىق» دېگەن كۇنۇپكا"),
            keywords: &[
                "«ئايلىق سومما»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «ئايلىق» دېگەن كۇنۇپكا",
                "月",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"щомісяця\" японською"),
            keywords: &["кнопка \"щомісяця\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"ماہانہ رقم\" بٹن"),
            keywords: &[
                "تصویری علامت",
                "جاپانی",
                "جاپانی \"ماہانہ رقم\" بٹن",
                "چاند",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi oy iyeroglifi"),
            keywords: &["kvadrat ichidagi oy iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “số tiền hàng tháng”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “số tiền hàng tháng”",
                "“số tiền hàng tháng”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu sapone \"lu ñuy fay weer\""),
            keywords: &[
                "\"lu ñuy fay weer\"",
                "Sapone",
                "bitoŋu sapone \"lu ñuy fay weer\"",
                "ideograf",
                "月",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"imali yenyanga\" lesiJapan"),
            keywords: &[
                "\"imali yenyanga\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"imali yenyanga\" lesiJapan",
                "月",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bó\u{329}tìnì Japanisi \"owó ìdíyelé oṣoòṣù\""),
            keywords: &[
                "\"owó ìdíyelé oṣoòṣù\"",
                "Bó\u{329}tìnì Japanisi \"owó ìdíyelé oṣoòṣù\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "月",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「月」按鈕"),
            keywords: &["日本", "日本「月」按鈕", "月", "月費"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“月”按钮"),
            keywords: &["日本", "日本“月”按钮", "月", "月费"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“月总量”按钮"),
            keywords: &["按键", "日文", "日文的“月总量”按钮", "月度", "统计"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("月"),
            keywords: &["月"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「月費」按鈕"),
            keywords: &["日文嘅「月費」按鈕", "月費"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwenyanga oluyiskwele"),
            keywords: &["inyanga", "uphawu lwenyanga oluyiskwele"],
        },
    ],
};
#[doc = "🈶"]
pub const JAPANESE__NOT_FREE_OF_CHARGE__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈶",
    codepoint: "1F236",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “not free of charge” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “nie gratis nie”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “nie gratis nie”-knoppie",
                "ideogram",
                "“nie gratis nie”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ያኖረ ካሬ አይዶግራፍ"),
            keywords: &["የጃፓን", "ያኖረ ካሬ አይዶግራፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /غير مجاني/ باليابانية"),
            keywords: &["الزر /غير مجاني/ باليابانية", "يابان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "জ\u{9be}প\u{9be}নী “বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be} নহয\u{9bc}” ব\u{9c1}ট\u{9be}ম",
            ),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be} নহয\u{9bc}” ব\u{9c1}ট\u{9be}ম",
                "“বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be} নহয\u{9bc}”",
                "有",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat çıxış ideoqramı"),
            keywords: &["kvadrat çıxış ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «ў наяўнасці» ў квадраце"),
            keywords: &[
                "прадаецца",
                "пісьмо",
                "японскае",
                "ідэаграма «ў наяўнасці» ў квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „съществувам“ в квадрат"),
            keywords: &["Идеограма „съществувам“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র বিদ\u{9cd}যম\u{9be}ন চিত\u{9cd}রলিপি"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র বিদ\u{9cd}যম\u{9be}ন চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"nije besplatno\" na jap."),
            keywords: &[
                "Dugme \"nije besplatno\" na jap.",
                "Dugme sa tekstom \"nije besplatno\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"de pagament\""),
            keywords: &[
                "\"de pagament\"",
                "botó japonès \"de pagament\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎠᏎᏭ ᏂᎨᏒᎾ” ᎦᏗ"),
            keywords: &["ᎦᏅᏍᏙᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎠᏎᏭ ᏂᎨᏒᎾ” ᎦᏗ", "“ᎥᏝ ᎠᏎᏭᎢ ᏱᎩ”", "有"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „není zdarma“"),
            keywords: &[
                "ideogram",
                "japonština",
                "majetek",
                "není zdarma",
                "vlastnictví",
                "štítek s japonským znakem „není zdarma“",
                "有",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff bodoli mewn sgwâr"),
            keywords: &["Japaneaidd", "ideograff bodoli mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for ikke gratis"),
            keywords: &["japansk", "kvadratisk ideogram for ikke gratis"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „nicht gratis“"),
            keywords: &[
                "Schriftzeichen für „nicht gratis“",
                "japanisches Schriftzeichen",
                "nicht gratis",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα επί πληρωμή σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα επί πληρωμή σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “not free of charge” button"),
            keywords: &[
                "Japanese",
                "Japanese “not free of charge” button",
                "ideograph",
                "“not free of charge”",
                "有",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"de pago\""),
            keywords: &[
                "ideograma",
                "ideograma japonés para \"de pago\"",
                "japonés",
                "kanji",
                "“de pago”",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"pole tasuta\""),
            keywords: &[
                "\"pole tasuta\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"pole tasuta\"",
                "有",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"ez da doakoa\" botoia"),
            keywords: &[
                "existentzia irudikatzen duen ideograma karratu batean",
                "japoniera",
                "japonierazko \"ez da doakoa\" botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} غیرمجانی به ژاپنی"),
            keywords: &["دکمه\u{654} غیرمجانی به ژاپنی", "موجود", "ژاپنی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maksullinen-kirjainmerkki"),
            keywords: &["japani", "kirjoitusmerkki", "maksullinen-kirjainmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button na nagsasabing \"hindi ito libre\""),
            keywords: &[
                "Hapones",
                "Hapones na button na nagsasabing \"hindi ito libre\"",
                "ideograpya",
                "libre",
                "nakaparisukat na ideograph ng pag-iral",
                "pindutan",
                "singil",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"ikki ókeypis\" knappur"),
            keywords: &[
                "\"ikki ókeypis\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"ikki ókeypis\" knappur",
                "有",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton pas gratuit en japonais"),
            keywords: &[
                "bouton pas gratuit en japonais",
                "japonais",
                "pas gratuit",
                "payant",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}payant\u{a0}»"),
            keywords: &[
                "idéogramme",
                "japonais",
                "payant",
                "symbole japonais signifiant «\u{a0}payant\u{a0}»",
                "有",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"nach bhfuil saor in aisce\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"nach bhfuil saor in aisce\"",
                "cnáipe Seapáinis \"nach bhfuil saor in aisce\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Chan ann an-asgaidh”"),
            keywords: &[
                "Chan ann saor ‘s an-asgaidh",
                "Seapanais",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Chan ann an-asgaidh”",
                "putan Seapanais “Chan ann saor ’s an-asgaidh”",
                "有",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"de pago\" en xaponés"),
            keywords: &[
                "botón \"de pago\" en xaponés",
                "de pago",
                "ideograma",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "\"નિઃશ\u{ac1}લ\u{acd}ક નથી\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
            ),
            keywords: &[
                "\"નિઃશ\u{ac1}લ\u{acd}ક નથી\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“નિઃશ\u{ac1}લ\u{acd}ક નથી”",
                "有",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"ba kyauta ba\" Na Japan"),
            keywords: &[
                "\"ba kyauta ba\"",
                "Na Japan",
                "maɓallin \"ba kyauta ba\" Na Japan",
                "zanen harshe",
                "有",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״לא בחינם״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״לא בחינם״ ביפנית",
                "״לא בחינם״",
                "有",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “म\u{941}फ\u{93c}\u{94d}त नही\u{902}” बटन"),
            keywords: &[
                "जापानी",
                "जापानी “म\u{941}फ\u{93c}\u{94d}त नही\u{902}” बटन",
                "“म\u{941}फ\u{93c}\u{94d}त नही\u{902}”",
                "有",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"nije besplatno\""),
            keywords: &["japanski", "tipka s ideogramom \"nije besplatno\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „nem ingyenes” gomb"),
            keywords: &[
                "japán",
                "japán „nem ingyenes” gomb",
                "képírásjel",
                "„nem ingyenes”",
                "有",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գոյ գաղափարագիր"),
            keywords: &["գոյ գաղափարագիր", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"tidak gratis\""),
            keywords: &[
                "\"tidak gratis\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"tidak gratis\"",
                "有",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “abụghị nke efù”"),
            keywords: &[
                "Japanese",
                "ideograph",
                "Ọdụmbi Ndị Japan “abụghị nke efù”",
                "“abụghị nke efù”",
                "有",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Ekki ókeypis“ á japönsku"),
            keywords: &[
                "ekki ókeypis",
                "japanska",
                "myndletur",
                "„Ekki ókeypis“ á japönsku",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “A pagamento”"),
            keywords: &[
                "esistere",
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “A pagamento”",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("有マーク"),
            keywords: &["有", "有マーク", "有料", "有限"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"ora gratis\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"ora gratis\"",
                "“ora gratis”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("არსებობის იდეოგრამა კვადრატში"),
            keywords: &["არსებობის იდეოგრამა კვადრატში", "იაპონური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «болмыс» иероглифі"),
            keywords: &["жапон", "шаршыдағы «болмыс» иероглифі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for eksistens"),
            keywords: &["japansk", "kvadratisk ideogram for eksistens"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា កើតមាន"),
            keywords: &[
                "កើតមាន",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា កើតមាន",
                "អក\u{17d2}សរច\u{17b7}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಶುಲ\u{ccd}ಕ ರಹ\u{cbf}ತವ\u{cbf}ಲ\u{ccd}ಲ\" ಬಟನ\u{ccd}"),
            keywords: &[
                "ಐಡ\u{cbf}ಯೋಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} \"ಶುಲ\u{ccd}ಕ ರಹ\u{cbf}ತವ\u{cbf}ಲ\u{ccd}ಲ\" ಬಟನ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} “ಶುಲ\u{ccd}ಕ ರಹ\u{cbf}ತವ\u{cbf}ಲ\u{ccd}ಲ” ಬಟನ\u{ccd}",
                "“ಶುಲ\u{ccd}ಕ ರಹ\u{cbf}ತವ\u{cbf}ಲ\u{ccd}ಲ”",
                "有",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("있을 유"),
            keywords: &["있을 유", "있음"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “श\u{941}ल\u{94d}क नासतना न\u{94d}हय” बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “फ\u{941}कट न\u{94d}हय” बटण",
                "जपानी “श\u{941}ल\u{94d}क नासतना न\u{94d}हय” बटण",
                "“फ\u{941}कट न\u{94d}हय”",
                "有",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы жашоо идеограммасы"),
            keywords: &["жапончо", "чарчыдагы жашоо идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’net gratis’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’net gratis’",
                "’net gratis’",
                "有",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ມ\u{eb5}"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ມ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ne nemokamą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "ne nemokamas",
                "ne nemokamą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Būt kvadrātveida ietvarā"),
            keywords: &["ideogramma Būt kvadrātveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"ehara i te koreutu\""),
            keywords: &[
                "\"ehara i te koreutu\"",
                "Hapanīhi",
                "pātene Hapanīhi \"ehara i te koreutu\"",
                "tohuwhakairo",
                "有",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „не е бесплатно“ на јапонски"),
            keywords: &["копче „не е бесплатно“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സ\u{d57}ജന\u{d4d}യമല\u{d4d}ല\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "\"സ\u{d57}ജന\u{d4d}യമല\u{d4d}ല\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സ\u{d57}ജന\u{d4d}യമല\u{d4d}ല\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"үнэгүй биш\" гэсэн товчлуур"),
            keywords: &[
                "\"үнэгүй биш\"",
                "Японоор \"үнэгүй биш\" гэсэн товчлуур",
                "дүрс үсэг",
                "有",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस विद\u{94d}यमान स\u{902}क\u{947}त"),
            keywords: &[
                "\"मोफत नाही\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस विद\u{94d}यमान स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"मोफत नाही\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “bukan percuma” Jepun"),
            keywords: &[
                "Jepun",
                "butang “bukan percuma” Jepun",
                "ideograf",
                "“bukan percuma”",
                "有",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “mhux Bla Ħlas”"),
            keywords: &[
                "buttuna Ġappuniż “mhux Bla Ħlas”",
                "ideograff",
                "Ġappuniż",
                "“mhux b’xejn”",
                "有",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဂျပန\u{103a}ဘာသာ အခမ\u{1032}\u{1037} မဟ\u{102f}တ\u{103a}ပါ ခလ\u{102f}တ\u{103a}",
            ),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ အခမ\u{1032}\u{1037} မဟ\u{102f}တ\u{103a}ပါ ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} တည\u{103a}ရ\u{103e}\u{102d}မ\u{103e}\u{102f} အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«ikke gratis» på japansk"),
            keywords: &[
                "ideograf",
                "ikke gratis",
                "japansk",
                "«ikke gratis» på japansk",
                "有",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड भएको आइडियोग\u{94d}राफ"),
            keywords: &[
                "जापानिज",
                "स\u{94d}क\u{94d}वायर\u{94d}ड भएको आइडियोग\u{94d}राफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘niet gratis’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘niet gratis’",
                "ideogram",
                "‘niet gratis’",
                "有",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«ikkje gratis» på japansk"),
            keywords: &[
                "ideograf",
                "ikkje gratis",
                "japansk",
                "«ikkje gratis» på japansk",
                "有",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ଦେୟ ମ\u{b41}କ\u{b4d}ତ ନ\u{b41}ହେ\u{b01}” ବଟନ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ଦେୟ ମ\u{b41}କ\u{b4d}ତ ନ\u{b41}ହେ\u{b01}” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ଦେୟ ମ\u{b41}କ\u{b4d}ତ ନ\u{b41}ହେ\u{b01}”",
                "有",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਮ\u{a41}ਫਤ ਨਹੀ\u{a02}\" ਬਟਨ"),
            keywords: &["\"ਮ\u{a41}ਫਤ ਨਹੀ\u{a02}\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “ادائیگی ت\u{64f}وں بغیر نہیں” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “ادائیگی ت\u{64f}وں بغیر نہیں” دا بٹن",
                "“ادائیگی ت\u{64f}وں بغیر نہیں”",
                "有",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Nọ\u{301} Bi Frí Ọf Chaj”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Nọ\u{301} Bi Frí Ọf Chaj”",
                "Japán Pípol",
                "Japán Raítin",
                "“Nọ\u{301} Bi Frí Ọf Chaj”",
                "有",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „płatne”"),
            keywords: &[
                "ideogram",
                "istnienie",
                "japoński",
                "japoński przycisk „płatne”",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"وړیا نه\" بټن"),
            keywords: &[
                "\"وړيا نه\"",
                "آيډوګراف",
                "جاپاني",
                "جاپاني \"وړیا نه\" بټن",
                "有",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “não gratuito”"),
            keywords: &[
                "botão japonês de “não gratuito”",
                "ideograma",
                "japonês",
                "“não gratuito”",
                "有",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"não gratuito\" em japonês"),
            keywords: &["botão \"não gratuito\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „contra cost” japoneză"),
            keywords: &[
                "buton cu semnificația „contra cost” japoneză",
                "buton cu semnificația „contra cost” în japoneză",
                "ideogramă",
                "japoneză",
                "„contra cost”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-192"),
            keywords: &["E10-192"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("платно"),
            keywords: &["значок", "кнопка", "платно", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’not free of charge’ mu kiyapani"),
            keywords: &[
                "\"itari iy’ubuntu\"",
                "Imyandikire",
                "buto ya ’not free of charge’ mu kiyapani",
                "y’Abayapani",
                "有",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘مفت ۾ نه آهي’ بٽڻ"),
            keywords: &[
                "آئڊيوگراف",
                "جاپاني",
                "جاپاني ‘مفت ۾ نه آهي’ بٽڻ",
                "“مفت ۾ نه آهي”",
                "有",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} පැවත\u{dd3}ම සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &[
                "ජපන\u{dca}",
                "හතරැස\u{dca} පැවත\u{dd3}ම සංකල\u{dca}ප ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Nie je zadarmo"),
            keywords: &["japonský ideograf Nie je zadarmo", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »ni brezplačno« v japonščini"),
            keywords: &[
                "gumb za »ni brezplačno« v japonščini",
                "ideogram",
                "japonsko",
                "ni brezplačno",
                "plačljivo",
                "pojmovni znak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka “ma aha bilaash” ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka “ma aha bilaash” ee Jabbaanka",
                "badhanka “qaddarka billaha ah” ee Jabbaanka",
                "fikrad-garafeed",
                "“qaddarka billaha ah”",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «jo falas» në japonisht"),
            keywords: &[
                "butoni «jo falas» në japonisht",
                "ideograf",
                "japonisht",
                "«jo falas»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „постоји“ у квадрату"),
            keywords: &[
                "идеограф",
                "идеограф „постоји“ у квадрату",
                "јапански",
                "јапанско дугме „није бесплатно“",
                "„није бесплатно“",
                "有",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["идеограф „постоји“ у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „postoji“ u kvadratu"),
            keywords: &[
                "ideograf",
                "ideograf „postoji“ u kvadratu",
                "japanski",
                "japansko dugme „nije besplatno“",
                "„nije besplatno“",
                "有",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ideograf „postoji“ u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”inte gratis”-knapp"),
            keywords: &[
                "ideogram",
                "ideogram för finns",
                "inte gratis",
                "japansk",
                "japansk ”inte gratis”-knapp",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya kuwepo kwenye mraba"),
            keywords: &["idiografu ya kuwepo kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"கட\u{bcd}டணம\u{bcd} விதிக\u{bcd}கப\u{bcd}படும\u{bcd}\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"கட\u{bcd}டணம\u{bcd} விதிக\u{bcd}கப\u{bcd}படும\u{bcd}\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఛ\u{c3e}ర\u{c4d}జ\u{c40}లు ఉన\u{c4d}న\u{c3e}య\u{c3f}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఛ\u{c3e}ర\u{c4d}జ\u{c40}లు ఉన\u{c4d}న\u{c3e}య\u{c3f}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Ройгон нест\"-и ҷопонӣ"),
            keywords: &[
                "\"ройгон\"",
                "идеограмма",
                "тугмаи \"Ройгон нест\"-и ҷопонӣ",
                "ҷопонӣ",
                "有",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some(
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ค\u{e34}ดค\u{e48}าใช\u{e49}จ\u{e48}าย”",
            ),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ค\u{e34}ดค\u{e48}าใช\u{e49}จ\u{e48}าย”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นม\u{e35}",
                "“ค\u{e34}ดค\u{e48}าใช\u{e49}จ\u{e48}าย”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ነጻ ዘይኮነ ክፍሊት” መልጎም"),
            keywords: &[
                "ናይ ጃፓን",
                "ናይ ጃፓን “ነጻ ዘይኮነ ክፍሊት” መልጎም",
                "ኣይድዮግራፍ",
                "““ነጻ ዘይኮነ ክፍሊት”",
                "有",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"mugt däl\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"mugt däl\" düwmesi",
                "“mugt däl”",
                "有",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «totongi» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «totongi» (fakasiapani)",
                "totongi",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"ücretsiz değil\" düğmesi"),
            keywords: &["Japonca", "Japonca \"ücretsiz değil\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «ھەقسىز ئەمەس» دېگەن كۇنۇپكا"),
            keywords: &[
                "«ھەقسىز ئەمەس»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «ھەقسىز ئەمەس» دېگەن كۇنۇپكا",
                "有",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"не безкоштовно\" японською"),
            keywords: &["кнопка \"не безкоштовно\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"مفت نہیں\" بٹن"),
            keywords: &[
                "تصویری علامت",
                "جاپانی",
                "جاپانی \"مفت نہیں\" بٹن",
                "موجودگی",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi mavjudlik iyeroglifi"),
            keywords: &["kvadrat ichidagi mavjudlik iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “không miễn phí”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “không miễn phí”",
                "“không miễn phí”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu sapone \"dafa am juuti\""),
            keywords: &[
                "\"dafa am juuti\"",
                "Sapone",
                "bitoŋu sapone \"dafa am juuti\"",
                "ideograf",
                "有",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"ayikho simahla\" lesiJapan"),
            keywords: &[
                "\"ayiphisi\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"ayikho simahla\" lesiJapan",
                "有",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"kosi lọfẹ\""),
            keywords: &[
                "\"kòṣọ\u{300}fé\u{329}\"",
                "Bọtini Japanisi \"kosi lọfẹ\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "有",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「有」按鈕"),
            keywords: &["收費", "日本", "日本「有」按鈕", "有"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“有”按钮"),
            keywords: &["收费", "日本", "日本“有”按钮", "有"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“收费”按钮"),
            keywords: &["按键", "日文", "日文的“收费”按钮", "费用"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("有"),
            keywords: &["有"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「非免費」按鈕"),
            keywords: &["不是免費", "日文嘅「非免費」按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokungabibikho oluyiskwele"),
            keywords: &["ukungabibikho", "uphawu lokungabibikho oluyiskwele"],
        },
    ],
};
#[doc = "🈯"]
pub const JAPANESE__RESERVED__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈯",
    codepoint: "1F22F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “reserved” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “gereserveer”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “gereserveer”-knoppie",
                "ideogram",
                "“gereserveer”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጣት ካሬ አይዶግራፍ"),
            keywords: &["የጃፓን", "የጣት ካሬ አይዶግራፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /محجوز/ باليابانية"),
            keywords: &["الزر /محجوز/ باليابانية", "الياباني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “সংৰক\u{9cd}ষিত” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “সংৰক\u{9cd}ষিত” ব\u{9c1}ট\u{9be}ম",
                "“সংৰক\u{9cd}ষিত”",
                "指",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat barmaq ideoqramı"),
            keywords: &["kvadrat barmaq ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «паказванне пальцам» у квадраце"),
            keywords: &[
                "кірунак",
                "кітайскае",
                "пісьмо",
                "японскае",
                "ідэаграма «паказванне пальцам» у квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „пръст“ в квадрат"),
            keywords: &["Идеограма „пръст“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র আঙ\u{9c1}লের চিত\u{9cd}রলিপি"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র আঙ\u{9c1}লের চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"rezervirano\" na jap."),
            keywords: &[
                "Dugme \"rezervirano\" na jap.",
                "Dugme sa tekstom \"rezervirano\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"reservat\""),
            keywords: &[
                "\"reservat\"",
                "botó japonès \"reservat\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎦᏃᎯᏴᎢ” ᎦᏗ"),
            keywords: &["ᎦᏅᏍᏙᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎦᏃᎯᏴᎢ” ᎦᏗ", "“ᎠᎯᏰᎸᎢ”", "指"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „rezervováno“"),
            keywords: &[
                "ideogram",
                "japonština",
                "obsazeno",
                "prst",
                "směr",
                "štítek s japonským znakem „rezervováno“",
                "指",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff bys mewn sgwâr"),
            keywords: &["Japaneaidd", "ideograff bys mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for reserveret"),
            keywords: &["japansk", "kvadratisk ideogram for reserveret"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „reserviert“"),
            keywords: &[
                "Schriftzeichen für „reserviert“",
                "japanisches Schriftzeichen",
                "reserviert",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα κράτησης σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα κράτησης σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “reserved” button"),
            keywords: &[
                "Japanese",
                "Japanese “reserved” button",
                "ideograph",
                "“reserved”",
                "指",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"reservado\""),
            keywords: &[
                "ideograma",
                "ideograma japonés para \"reservado\"",
                "japonés",
                "kanji",
                "reservado",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"reserveeritud\""),
            keywords: &[
                "\"reserveeritud\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"reserveeritud\"",
                "指",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"erreserbatuta\" botoia"),
            keywords: &[
                "hatz bat irudikatzen duen ideograma karratu batean",
                "japoniera",
                "japonierazko \"erreserbatuta\" botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ «رزروشده» به ژاپنی"),
            keywords: &[
                "اندیشه\u{200c}نگاشت",
                "دکمۀ «رزروشده» به ژاپنی",
                "رزروشده",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("varattu-kirjainmerkki"),
            keywords: &["japani", "kirjoitusmerkki", "varattu-kirjainmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapopnes na button para sa salitang \"nakareserba\""),
            keywords: &[
                "Hapones",
                "Hapones na button para sa salitang \"nakareserba\"",
                "Hapopnes na button para sa salitang \"nakareserba\"",
                "ideograpya",
                "naka-reserve",
                "nakaparisukat na ideograph ng daliri",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"bílagt\" knappur"),
            keywords: &[
                "\"bílagt\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"bílagt\" knappur",
                "指",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton réservé en japonais"),
            keywords: &["bouton réservé en japonais", "japonais", "réservé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}réservé\u{a0}»"),
            keywords: &[
                "idéogramme",
                "japonais",
                "réservé",
                "symbole japonais signifiant «\u{a0}réservé\u{a0}»",
                "指",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"coinnithe\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"coinnithe\"",
                "cnáipe Seapáinis \"coinnithe\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Glèidhte”"),
            keywords: &[
                "Seapanais",
                "glèidhte",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Glèidhte”",
                "指",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"reservado\" en xaponés"),
            keywords: &[
                "botón \"reservado\" en xaponés",
                "ideograma",
                "reservado",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "\"અનામત\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
            ),
            keywords: &[
                "\"અનામત\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“અનામત”",
                "指",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"ƙayyadadde\" Na Japan"),
            keywords: &[
                "\"ƙayyadadde\"",
                "Na Japan",
                "maɓallin \"ƙayyadadde\" Na Japan",
                "zanen harshe",
                "指",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״מקום שמור״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״מקום שמור״ ביפנית",
                "״מקום שמור״",
                "指",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “आरक\u{94d}षित” बटन"),
            keywords: &[
                "जापानी",
                "जापानी “आरक\u{94d}षित” बटन",
                "“आरक\u{94d}षित”",
                "指",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"rezervirano\""),
            keywords: &["japanski", "tipka s ideogramom \"rezervirano\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „foglalt” gomb"),
            keywords: &[
                "japán",
                "japán „foglalt” gomb",
                "képírásjel",
                "„foglalt”",
                "指",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մատ գաղափարագիր"),
            keywords: &["ճապոնական", "ճապոներեն", "մատ գաղափարագիր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"sudah dipesan\""),
            keywords: &[
                "\"sudah dipesan\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"sudah dipesan\"",
                "指",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “chekwara”"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi Ndị Japan “chekwara”",
                "“echekwara”",
                "指",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Frátekið“ á japönsku"),
            keywords: &["frátekið", "japanska", "myndletur", "„Frátekið“ á japönsku"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Riservato”"),
            keywords: &[
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Riservato”",
                "riservato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("指マーク"),
            keywords: &["指", "指マーク", "指定席"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"wis dipesen\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"wis dipesen\"",
                "“wis dipesen”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თითის იდეოგრამა კვადრატში"),
            keywords: &["თითის იდეოგრამა კვადრატში", "იაპონური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «саусақ» иероглифі"),
            keywords: &["жапон", "шаршыдағы «саусақ» иероглифі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for finger"),
            keywords: &["japansk", "kvadratisk ideogram for finger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ម\u{17d2}រាមដៃ",
            ),
            keywords: &[
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ម\u{17d2}រាមដៃ",
                "ម\u{17d2}រាមដៃ",
                "អក\u{17d2}សរច\u{17b7}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಕಾಯ\u{ccd}ದ\u{cbf}ರ\u{cbf}ಸಲಾಗ\u{cbf}ದ\u{cc6}\" ಬಟನ\u{ccd}"),
            keywords: &[
                "\"ಕಾಯ\u{ccd}ದ\u{cbf}ರ\u{cbf}ಸಲಾಗ\u{cbf}ದ\u{cc6}\"",
                "ಐಡ\u{cbf}ಯೋಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} \"ಕಾಯ\u{ccd}ದ\u{cbf}ರ\u{cbf}ಸಲಾಗ\u{cbf}ದ\u{cc6}\" ಬಟನ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} ಕಾಯ\u{ccd}ದ\u{cbf}ರ\u{cbf}ಸಲಾದ ಬಟನ\u{ccd}",
                "指",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가리킬 지"),
            keywords: &["가리키다", "가리킬 지", "손가락", "지칭"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “आरक\u{94d}षीत” बटण"),
            keywords: &[
                "आयडियोग\u{94d}राफ",
                "जपानी",
                "जपानी “आरक\u{94d}षीत” बटण",
                "“आरक\u{94d}षीत”",
                "指",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы манжа идеограммасы"),
            keywords: &["жапончо", "чарчыдагы манжа идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’reservéiert’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’reservéiert’",
                "’reservéiert’",
                "指",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຊ\u{eb5}\u{ec9}ນ\u{eb4}\u{ec9}ວ",
            ),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຊ\u{eb5}\u{ec9}ນ\u{eb4}\u{ec9}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rezervavimą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "rezervavimą reiškiantis hieroglifas",
                "rezervuotas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Norāde kvadrātveida ietvarā"),
            keywords: &["ideogramma Norāde kvadrātveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"rāhuitia\""),
            keywords: &[
                "\"rāhuitia\"",
                "Hapanīhi",
                "pātene Hapanīhi \"rāhuitia\"",
                "tohuwhakairo",
                "指",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „резервирано“ на јапонски"),
            keywords: &["копче „резервирано“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"റിസർവ\u{d4d} ചെയ\u{d4d}\u{200c}തത\u{d4d}\" ബട\u{d4d}ടൺ",
            ),
            keywords: &[
                "\"റിസർവ\u{d4d} ചെയ\u{d4d}\u{200c}തത\u{d4d}\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"റിസർവ\u{d4d} ചെയ\u{d4d}\u{200c}തത\u{d4d}\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"захиалгатай\" гэсэн товчлуур"),
            keywords: &[
                "\"захиалгатай\"",
                "Японоор \"захиалгатай\" гэсэн товчлуур",
                "指",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस बोटान\u{947} दर\u{94d}शविल\u{947}ला स\u{902}क\u{947}त"),
            keywords: &[
                "\"आरक\u{94d}षित\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस बोटान\u{947} दर\u{94d}शविल\u{947}ला स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"आरक\u{94d}षित\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “ditempah” Jepun"),
            keywords: &[
                "Jepun",
                "butang “ditempah” Jepun",
                "ideograf",
                "“ditempah”",
                "指",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “riservat”"),
            keywords: &[
                "buttuna Ġappuniż “riservat”",
                "ideograff",
                "Ġappuniż",
                "“riservat”",
                "指",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဂျပန\u{103a}ဘာသာ သ\u{102e}းသန\u{1037}\u{103a}မ\u{103e}ာယ\u{1030}ထားပြ\u{102e}း ခလ\u{102f}တ\u{103a}",
            ),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ သ\u{102e}းသန\u{1037}\u{103a}မ\u{103e}ာယ\u{1030}ထားပြ\u{102e}း ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} လက\u{103a}ချောင\u{103a}း အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«reservert» på japansk"),
            keywords: &[
                "ideograf",
                "japansk",
                "reservert",
                "«reservert» på japansk",
                "指",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड औ\u{902}लाको आइडियोग\u{94d}राफ"),
            keywords: &[
                "जापानिज",
                "स\u{94d}क\u{94d}वायर\u{94d}ड औ\u{902}लाको आइडियोग\u{94d}राफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘gereserveerd’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘gereserveerd’",
                "ideogram",
                "‘gereserveerd’",
                "指",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«reservert» på japansk"),
            keywords: &[
                "ideograf",
                "japansk",
                "reservert",
                "«reservert» på japansk",
                "指",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀୟ \"ସଂରକ\u{b4d}ଷ\u{b3f}ତ” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀୟ \"ସଂରକ\u{b4d}ଷ\u{b3f}ତ” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ସଂରକ\u{b4d}ଷ\u{b3f}ତ”",
                "指",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਰਾਖਵਾ\u{a02}\" ਬਟਨ"),
            keywords: &["\"ਰਾਖਵਾ\u{a02}\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “مخصوص کیتا” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “مخصوص کیتا” دا بٹن",
                "“مخصوص کیتا”",
                "指",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Rizav”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Rizav”",
                "Japán Pípol",
                "Japán Raítin",
                "“Rizav Fọ Sọ\u{301}mbọ\u{301}di”",
                "指",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „zarezerwowane”"),
            keywords: &[
                "ideogram",
                "japoński",
                "japoński przycisk „zarezerwowane”",
                "palec",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"د اضافي\" بټن"),
            keywords: &[
                "\"اضافي\"",
                "آيډوګراف",
                "جاپاني",
                "جاپاني \"د اضافي\" بټن",
                "指",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “reservado”"),
            keywords: &[
                "botão japonês de “reservado”",
                "ideograma",
                "japonês",
                "“reservado”",
                "指",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"reservado\" em japonês"),
            keywords: &["botão \"reservado\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „rezervat” în japoneză"),
            keywords: &[
                "buton cu semnificația „rezervat” în japoneză",
                "ideogramă",
                "japoneză",
                "„rezervat”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-187"),
            keywords: &["E10-187"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("забронировано"),
            keywords: &["забронировано", "занято", "значок", "кнопка", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’reserved’ mu kiyapani"),
            keywords: &[
                "\"kibitswe\"",
                "Imyandikire",
                "buto ya ’reserved’ mu kiyapani",
                "y’Abayapani",
                "指",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘‘رکيل’‘ بٽڻ"),
            keywords: &["آئڊيوگراف", "جاپاني", "جاپاني ‘‘رکيل’‘ بٽڻ", "“رکيل”", "指"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} ඇඟ\u{dd2}ල\u{dd2} සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &[
                "ජපන\u{dca}",
                "හතරැස\u{dca} ඇඟ\u{dd2}ල\u{dd2} සංකල\u{dca}ප ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Vyhradené"),
            keywords: &["japonský ideograf Vyhradené", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »rezervirano« v japonščini"),
            keywords: &[
                "gumb za »rezervirano« v japonščini",
                "ideogram",
                "japonsko",
                "pojmovni znak",
                "rezervirano",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka “kaydsan” ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka “kaydsan” ee Jabbaanka",
                "fikir-garafeed",
                "“kaydsan”",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «rezervuar» në japonisht"),
            keywords: &[
                "butoni «rezervuar» në japonisht",
                "ideograf",
                "japonisht",
                "«rezervuar»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „прст“ у квадрату"),
            keywords: &[
                "jaпaнски",
                "jaпaнско дугме “резервисано”",
                "идеограф „прст“ у квадрату",
                "идеограф „резервисано“",
                "指",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „prst“ u kvadratu"),
            keywords: &[
                "ideograf „prst“ u kvadratu",
                "ideograf „rezervisano“",
                "japanski",
                "japansko dugme “rezervisano”",
                "指",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”reserverad”-knapp"),
            keywords: &[
                "ideogram",
                "ideogram för finger",
                "japansk",
                "japansk ”reserverad”-knapp",
                "reserverad",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya kidole kwenye mraba"),
            keywords: &["idiografu ya kidole kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"முன\u{bcd}பதிவு செய\u{bcd}யப\u{bcd}பட\u{bcd}டது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"முன\u{bcd}பதிவு செய\u{bcd}யப\u{bcd}பட\u{bcd}டது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ర\u{c3f}జర\u{c4d}వ\u{c4d} చ\u{c47}యబడ\u{c3f}ంద\u{c3f}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ర\u{c3f}జర\u{c4d}వ\u{c4d} చ\u{c47}యబడ\u{c3f}ంద\u{c3f}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"нигоҳ дошташуда\"-и ҷопонӣ"),
            keywords: &[
                "\"нигоҳ дошташуда\"",
                "идеограмма",
                "тугмаи \"нигоҳ дошташуда\"-и ҷопонӣ",
                "ҷопонӣ",
                "指",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “จองแล\u{e49}ว”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “จองแล\u{e49}ว”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นช\u{e35}\u{e49}น\u{e34}\u{e49}ว",
                "“จองแล\u{e49}ว”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ዝተዓቀበ” መልጎም"),
            keywords: &["ናይ ጃፓን", "ናይ ጃፓን “ዝተዓቀበ” መልጎም", "ኣይድዮግራፍ", "“ዝተዓቀበ”", "指"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"bronlanan\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"bronlanan\" düwmesi",
                "“bronlanan”",
                "指",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «taʻofi» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «taʻofi» (fakasiapani)",
                "taʻofi",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"rezerve\" düğmesi"),
            keywords: &["Japonca", "Japonca \"rezerve\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «ساقلاق» دېگەن كۇنۇپكا"),
            keywords: &[
                "«ساقلاق»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «ساقلاق» دېگەن كۇنۇپكا",
                "指",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"зарезервовано\" японською"),
            keywords: &["кнопка \"зарезервовано\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"محفوظ\" بٹن"),
            keywords: &[
                "انگلی",
                "تصویری علامت",
                "جاپانی",
                "جاپانی \"محفوظ\" بٹن",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi barmoq iyeroglifi"),
            keywords: &["kvadrat ichidagi barmoq iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “đặt trước”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “đặt trước”",
                "“đặt trước”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"amna boroom\" bu sapoŋ"),
            keywords: &[
                "\"amna boroom\"",
                "Sapone",
                "bitoŋu \"amna boroom\" bu sapoŋ",
                "ideograf",
                "指",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"ibhukhishiwe\" lesiJapan"),
            keywords: &[
                "\"ibhukhishiwe\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"ibhukhishiwe\" lesiJapan",
                "指",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"nipamọ\""),
            keywords: &[
                "\"ìpamó\u{329}\"",
                "Bọtini Japanisi \"nipamọ\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "指",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「指」按鈕"),
            keywords: &["指", "日本", "日本「指」按鈕", "預訂"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“指”按钮"),
            keywords: &["指", "日本", "日本“指”按钮", "预订"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“预留”按钮"),
            keywords: &["按键", "日文", "日文的“预留”按钮", "预订"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("指"),
            keywords: &["指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「已預留」按鈕"),
            keywords: &["已劃位", "日文嘅「已預留」按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokukhomba ngomunwe oluyiskwele"),
            keywords: &[
                "ukukhomba ngomunwe",
                "uphawu lokukhomba ngomunwe oluyiskwele",
            ],
        },
    ],
};
#[doc = "🉐"]
pub const JAPANESE__BARGAIN__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🉐",
    codepoint: "1F250",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “bargain” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “winskopie”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “winskopie”-knoppie",
                "ideogram",
                "“winskopie”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለክብ ዕድል አይዶግራፍ"),
            keywords: &["ባለክብ ዕድል አይዶግራፍ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /صفقة/ باليابانية"),
            keywords: &["الزر /صفقة/ باليابانية", "اليابان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “দৰ-দ\u{9be}ম” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “দৰ-দ\u{9be}ম” ব\u{9c1}ট\u{9be}ম",
                "“দৰ-দ\u{9be}ম”",
                "得",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dairə üstünlük ideoqramı"),
            keywords: &["dairə üstünlük ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «выгадная здзелка» ў крузе"),
            keywords: &["пісьмо", "японскае", "ідэаграма «выгадная здзелка» ў крузе"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма за предимство в кръг"),
            keywords: &["Идеограма за предимство в кръг", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গোল\u{9be}ক\u{9be}র স\u{9c1}বিধ\u{9be}জনক চিত\u{9cd}রলিপি"),
            keywords: &[
                "গোল\u{9be}ক\u{9be}র স\u{9c1}বিধ\u{9be}জনক চিত\u{9cd}রলিপি",
                "জ\u{9be}প\u{9be}নি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"vrlo povoljno\" na jap."),
            keywords: &[
                "Dugme \"vrlo povoljno\" na jap.",
                "Dugme sa tekstom \"vrlo povoljno\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"ganga\""),
            keywords: &[
                "\"ganga\"",
                "botó japonès \"ganga\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᏗᎪᏏᏌᏅ” ᎦᏗ"),
            keywords: &["ᎦᏅᏍᏙᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᏗᎪᏏᏌᏅ” ᎦᏗ", "“ᎦᏲᏟ ᎠᏈᏴᏙᏗ”", "得"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek – japonský znak „výhodná koupě“"),
            keywords: &[
                "ideogram",
                "japonština",
                "koupě",
                "výhodnost",
                "výhodná",
                "štítek – japonský znak „výhodná koupě“",
                "得",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff mantais mewn cylch"),
            keywords: &["Japaneaidd", "ideograff mantais mewn cylch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cirkulært ideogram for tilbud"),
            keywords: &["cirkulært ideogram for tilbud", "japansk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „Schnäppchen“"),
            keywords: &[
                "Schnäppchen",
                "Schriftzeichen für „Schnäppchen“",
                "japanisches Schriftzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα προσφοράς σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα προσφοράς σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “bargain” button"),
            keywords: &[
                "Japanese",
                "Japanese “bargain” button",
                "ideograph",
                "“bargain”",
                "得",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"ganga\""),
            keywords: &[
                "ganga",
                "ideograma",
                "ideograma japonés para \"ganga\"",
                "japonés",
                "kanji",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "ganga",
                "ideograma",
                "ideograma japonés para \"ganga\"",
                "japonés",
                "kanji",
                "oferta",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"soodne\""),
            keywords: &[
                "\"soodne\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"soodne\"",
                "得",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"pagotxa\" botoia"),
            keywords: &[
                "abantaila bat irudikatzen duen ideograma zirkulu batean",
                "japoniera",
                "japonierazko \"pagotxa\" botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمه\u{654} «قیمت مناسب» به ژاپنی"),
            keywords: &[
                "دکمه\u{654} «قیمت مناسب» به ژاپنی",
                "مقرون\u{200c}به\u{200c}صرفه",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hyvä ostos -kirjainmerkki"),
            keywords: &["hyvä ostos -kirjainmerkki", "japani", "kirjoitusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button para sa salitang \"bargain\""),
            keywords: &[
                "Hapones",
                "Hapones na button para sa salitang \"bargain\"",
                "baratilyo",
                "ideograpya",
                "nakabilog na ideograph ng kalamangan",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"kvett\" knappur"),
            keywords: &[
                "\"gott keyp\"",
                "\"kvett\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"kvett\" knappur",
                "得",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton bonne affaire en japonais"),
            keywords: &[
                "bonne affaire",
                "bouton bonne affaire en japonais",
                "japonais",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}aubaine\u{a0}»"),
            keywords: &[
                "aubaine",
                "idéogramme",
                "japonais",
                "symbole japonais signifiant «\u{a0}aubaine\u{a0}»",
                "指",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"sladmhargadh\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"sladmhargadh\"",
                "cnáipe Seapáinis \"sladmhargadh\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Bargan”"),
            keywords: &[
                "Seapanais",
                "bargan",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Bargan”",
                "得",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"oportunidade\" en xaponés"),
            keywords: &[
                "botón \"oportunidade\" en xaponés",
                "ideograma",
                "vantaxe",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("\"સોદો\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ગોળ બટન"),
            keywords: &[
                "\"સોદો\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ગોળ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“સોદો”",
                "得",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"ciniki\" Na Japan"),
            keywords: &[
                "\"ciniki\"",
                "Na Japan",
                "ideograph",
                "maɓallin \"ciniki\" Na Japan",
                "得",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״דיל״ ביפנית"),
            keywords: &["יפנית", "לוגו", "לחצן ״דיל״ ביפנית", "״דיל״", "得"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “तोल-मोल” बटन"),
            keywords: &["जापानी", "जापानी “तोल-मोल” बटन", "“तोल-मोल”", "得"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"povoljno\""),
            keywords: &["japanski", "tipka s ideogramom \"povoljno\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „alkalmi vétel” gomb"),
            keywords: &[
                "japán",
                "japán „alkalmi vétel” gomb",
                "képírásjel",
                "„alkalmi vétel”",
                "得",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("առավելություն գաղափարագիր շրջանակի մեջ"),
            keywords: &[
                "առավելություն գաղափարագիր շրջանակի մեջ",
                "ճապոնական",
                "ճապոներեն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("karakter keunggulan dalam lingkaran"),
            keywords: &["jepang", "karakter keunggulan dalam lingkaran"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi “ekwemụọnụ” Ndị Japan"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi “ekwemụọnụ” Ndị Japan",
                "“ekwemụọnụ”",
                "得",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Kjarakaup“ á japönsku"),
            keywords: &[
                "g´óð kaup",
                "japanska",
                "myndletur",
                "„Kjarakaup“ á japönsku",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Occasione”"),
            keywords: &[
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Occasione”",
                "vantaggio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マル得"),
            keywords: &["お得", "マル得", "得"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"rega murah\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"rega murah\"",
                "“rega murah”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უპირატესობის იდეოგრამა წრეში"),
            keywords: &["იაპონური", "უპირატესობის იდეოგრამა წრეში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("доңғалақтағы «артықшылық» иероглифі"),
            keywords: &["доңғалақтағы «артықшылық» иероглифі", "жапон"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cirkulært ideogram for fordel"),
            keywords: &["cirkulært ideogram for fordel", "japansk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}មានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ផលប\u{17d2}រយោជន\u{17cd}",
            ),
            keywords: &[
                "ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}",
                "ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}មានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ផលប\u{17d2}រយោជន\u{17cd}",
                "ប\u{17d2}រយោជន\u{17cd}",
                "អក\u{17d2}សរច\u{17b7}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಬಾರ\u{ccd}ಗೇನ\u{ccd}\" ಬಟನ\u{ccd}"),
            keywords: &[
                "ಐಡ\u{cbf}ಯೋಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} \"ಬಾರ\u{ccd}ಗೇನ\u{ccd}\" ಬಟನ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} “ಬಾರ\u{ccd}ಗೇನ\u{ccd}” ಬಟನ\u{ccd}",
                "ಬಾರ\u{ccd}ಗೇನ\u{ccd}\" ಬಟನ\u{ccd}",
                "得",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("얻을 득"),
            keywords: &["얻을 득", "이득", "이익", "획득"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “बारग\u{947}न” बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “बारग\u{947}न” बटण",
                "जपानी “वाणपण” बटण",
                "“वाणपण”",
                "得",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тегеректеги мүмкүнчүлүк идеограммасы"),
            keywords: &["жапончо", "тегеректеги мүмкүнчүлүк идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’Schnäppchen’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’Schnäppchen’",
                "’Schnäppchen’",
                "得",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ປະໂຫຍດ"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ປະໂຫຍດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susitarimą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "susitarimas",
                "susitarimą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Izdevīgi apļveida ietvarā"),
            keywords: &["ideogramma Izdevīgi apļveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"utu ngāwari\""),
            keywords: &[
                "\"utu ngāwari\"",
                "Hapanīhi",
                "pātene Hapanīhi \"utu ngāwari\"",
                "tohuwhakairo",
                "得",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „зделка“ на јапонски"),
            keywords: &["копче „зделка“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"വിലപേശ\u{d41}ക\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "\"വിലപേശ\u{d41}ക\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"വിലപേശ\u{d41}ക\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"арилжаа\" гэсэн товчлуур"),
            keywords: &[
                "\"арилжаа\"",
                "Японоор \"арилжаа\" гэсэн товчлуур",
                "дүрс үсэг",
                "得",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस लाभ स\u{902}क\u{947}त"),
            keywords: &[
                "\"सौदा\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस लाभ स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"सौदा\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “murah” Jepun"),
            keywords: &["Jepun", "butang “murah” Jepun", "ideograf", "“murah”", "得"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “bargain”"),
            keywords: &[
                "buttuna Ġappuniż “bargain”",
                "ideograff",
                "Ġappuniż",
                "“bargain”",
                "指",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ စျေးပေါသည\u{103a} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ စျေးပေါသည\u{103a} ခလ\u{102f}တ\u{103a}",
                "ဝ\u{102d}\u{102f}င\u{103a}းထားသည\u{1037}\u{103a} သာလ\u{103d}န\u{103a}မ\u{103e}\u{102f} အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«spesialtilbud» på japansk"),
            keywords: &[
                "ideograf",
                "japansk",
                "spesialtilbud",
                "«spesialtilbud» på japansk",
                "得",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गोलो फाइदा आइडियोग\u{94d}राफ"),
            keywords: &["गोलो फाइदा आइडियोग\u{94d}राफ", "जापानिज"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘koopje’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘koopje’",
                "ideogram",
                "‘koopje’",
                "得",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«spesialtilbod» på japansk"),
            keywords: &[
                "ideograf",
                "japansk",
                "spesialtilbod",
                "«spesialtilbod» på japansk",
                "得",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ବ\u{b41}ଝ\u{b3e}ମଣ\u{b3e} କର\u{b3f}ବ\u{b3e}” ବଟନ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ବ\u{b41}ଝ\u{b3e}ମଣ\u{b3e} କର\u{b3f}ବ\u{b3e}” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ବ\u{b41}ଝ\u{b3e}ମଣ\u{b3e} କର\u{b3f}ବ\u{b3e}”",
                "得",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਸ\u{a4c}ਦ\u{a47}ਬਾਜ\u{a3c}ੀ\" ਬਟਨ"),
            keywords: &["\"ਸ\u{a4c}ਦ\u{a47}ਬਾਜ\u{a3c}ੀ\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “سودا بازی” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “سودا بازی” دا بٹن",
                "“سودا بازی”",
                "得",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Gívawé Praiz”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Gívawé Praiz”",
                "Japán Pípol",
                "Japán Raítin",
                "“Gívawé Praiz”",
                "得",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „okazja”"),
            keywords: &[
                "ideogram",
                "japoński",
                "japoński przycisk „okazja”",
                "korzyść",
                "przewaga",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"جوړ جاړ\" بټن"),
            keywords: &[
                "\"جوړجاړ\"",
                "آيډوګراف",
                "جاپاني",
                "جاپاني \"جوړ جاړ\" بټن",
                "得",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “barganha”"),
            keywords: &[
                "botão japonês de “barganha”",
                "ideograma",
                "japonês",
                "“barganha”",
                "得",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"boa oportunidade\" em japonês"),
            keywords: &[
                "botão \"boa oportunidade\" em japonês",
                "ideograma",
                "japonês",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „ocazie” în japoneză"),
            keywords: &[
                "buton cu semnificația „ocazie” în japoneză",
                "ideogramă",
                "japoneză",
                "„ocazie”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-197"),
            keywords: &["E10-197"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("удачная сделка"),
            keywords: &[
                "выгода",
                "значок",
                "кнопка",
                "сделка",
                "удачная сделка",
                "япония",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’bargain’ mu kiyapani"),
            keywords: &[
                "\"guciririkanya\"",
                "Imyandikire",
                "Nyapani",
                "buto ya ’bargain’ mu kiyapani",
                "得",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘سودو’ بٽڻ"),
            keywords: &["آئڊيوگراف", "جاپاني", "جاپاني ‘سودو’ بٽڻ", "“بارگين”", "指"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} ව\u{dcf}ස\u{dd2} සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &[
                "ජපන\u{dca}",
                "හතරැස\u{dca} ව\u{dcf}ස\u{dd2} සංකල\u{dca}ප ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Výhodný nákup"),
            keywords: &["japonský ideograf Výhodný nákup", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »ugodno« v japonščini"),
            keywords: &[
                "gumb za »ugodno« v japonščini",
                "ideogram",
                "japonsko",
                "pojmovni znak",
                "ugoden nakup",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ‘‘gorgortan’‘ ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka ‘‘gorgortan’‘ ee Jabbaanka",
                "fikir-garafeed",
                "‘‘gorgortan’‘",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «me leverdi» në japonisht"),
            keywords: &[
                "butoni «me leverdi» në japonisht",
                "ideograf",
                "japonisht",
                "«me leverdi»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „предност“ у кругу"),
            keywords: &[
                "идеограф",
                "идеограф „предност“ у кругу",
                "јапански",
                "јапанско дугме „багатела“",
                "„багатела“",
                "得",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["идеограф „предност“ у кругу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „prednost“ u krugu"),
            keywords: &[
                "ideograf",
                "ideograf „prednost“ u krugu",
                "japanski",
                "japansko dugme „bagatela“",
                "„bagatela“",
                "得",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ideograf „prednost“ u krugu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”fynd”-knapp"),
            keywords: &[
                "fynd",
                "ideogram",
                "ideogram för bonus",
                "japansk",
                "japansk ”fynd”-knapp",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya manufaa kwenye mduara"),
            keywords: &["idiografu ya manufaa kwenye mduara", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"பேரம\u{bcd}\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"பேரம\u{bcd}\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"బ\u{c47}రం\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"బ\u{c47}రం\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Хариду фурӯш\"-и ҷопонӣ"),
            keywords: &[
                "\"хариду фурӯш\"",
                "идеограмма",
                "тугмаи \"Хариду фурӯш\"-и ҷопонӣ",
                "ҷопонӣ",
                "得",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ราคาถ\u{e39}ก”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ราคาถ\u{e39}ก”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นประโยชน\u{e4c}",
                "“ราคาถ\u{e39}ก”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ምውጋይ” መልጎም"),
            keywords: &["ናይ ጃፓን", "ናይ ጃፓን “ምውጋይ” መልጎም", "ኣይድዮግራፍ", "“ምውጋይ”", "得"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"alyş-çalyş\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"alyş-çalyş\" düwmesi",
                "“alyş-çalyş”",
                "得",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «maʻamaʻa» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "maʻamaʻa",
                "meʻalolomi",
                "meʻalolomi «maʻamaʻa» (fakasiapani)",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"avantaj\" düğmesi"),
            keywords: &["Japonca", "Japonca \"avantaj\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «سودىلىشىش» دېگەن كۇنۇپكا"),
            keywords: &[
                "«سودىلىشىش»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «سودىلىشىش» دېگەن كۇنۇپكا",
                "得",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"угода\" японською"),
            keywords: &["кнопка \"угода\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"سودا بازی \" بٹن"),
            keywords: &[
                "تصویری علامت",
                "جاپانی",
                "جاپانی \"سودا بازی \" بٹن",
                "دائرہ",
                "فائدہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aylana ichidagi afzallik iyeroglifi"),
            keywords: &["aylana ichidagi afzallik iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “mặc cả”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “mặc cả”",
                "“mặc cả”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"waxaale\" bu sapoŋ"),
            keywords: &[
                "\"waxaale\"",
                "Sapone",
                "bitoŋu \"waxaale\" bu sapoŋ",
                "ideograf",
                "得",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"isaphulelo\" lesiJapan"),
            keywords: &[
                "\"isaphulelo\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"isaphulelo\" lesiJapan",
                "得",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"idunadura\""),
            keywords: &[
                "\"ìdúnàdúrà\"",
                "Bọtini Japanisi \"idunadura\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "得",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「得」按鈕"),
            keywords: &["得", "日本", "日本「得」按鈕", "講價"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“得”按钮"),
            keywords: &["得", "日本", "日本“得”按钮", "讲价"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“议价”按钮"),
            keywords: &["按键", "日文", "日文的“议价”按钮", "讨价还价"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("得"),
            keywords: &["得"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「優惠」按鈕"),
            keywords: &["優惠", "日文嘅「優惠」按鈕"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lomtitilizo oluyindingilizi"),
            keywords: &["umtitilizo", "uphawu lomtitilizo oluyindingilizi"],
        },
    ],
};
#[doc = "🈹"]
pub const JAPANESE__DISCOUNT__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈹",
    codepoint: "1F239",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “discount” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “afslag”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “afslag”-knoppie",
                "ideogram",
                "“afslag”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተከፋፈለ ካሬ አይዶግራፍ"),
            keywords: &["የተከፋፈለ ካሬ አይዶግራፍ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /خصم/ باليابانية"),
            keywords: &["الزر /خصم/ باليابانية", "باليابانية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “ৰেহ\u{9be}ই” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “ৰেহ\u{9be}ই” ব\u{9c1}ট\u{9be}ম",
                "“ৰেহ\u{9be}ই”",
                "割",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat bölmə ideoqramı"),
            keywords: &["kvadrat bölmə ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «скідка» ў квадраце"),
            keywords: &[
                "дыскаўнт",
                "пісьмо",
                "японскае",
                "ідэаграма «скідка» ў квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „разделяне“ в квадрат"),
            keywords: &["Идеограма „разделяне“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র বিভক\u{9cd}ত চিত\u{9cd}রলিপি"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র বিভক\u{9cd}ত চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"popust\" na jap."),
            keywords: &[
                "Dugme \"popust\" na jap.",
                "Dugme sa tekstom \"popust\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"descompte\""),
            keywords: &[
                "botó japonès \"descompte\"",
                "ideograma",
                "japonès",
                "kanji",
                "quadre",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎦᏲᏟ ᏧᎬᏩᎶᏗ” ᎦᏗ"),
            keywords: &[
                "ᎦᏅᏍᏙᏍᎬ",
                "ᏣᏩᏂᏏ",
                "ᏣᏩᏂᏏ “ᎦᏲᏟ ᏧᎬᏩᎶᏗ” ᎦᏗ",
                "“ᎠᏲᏟᎨ ᏧᎬᏩᎶᏗ”",
                "割",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „sleva“"),
            keywords: &[
                "akce",
                "ideogram",
                "japonština",
                "sleva",
                "výprodej",
                "štítek s japonským znakem „sleva“",
                "割",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff rhannu mewn sgwâr"),
            keywords: &["Japaneaidd", "ideograff rhannu mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for rabat"),
            keywords: &["japansk", "kvadratisk ideogram for rabat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „Rabatt“"),
            keywords: &[
                "Rabatt",
                "Schriftzeichen für „Rabatt“",
                "japanisches Schriftzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα έκπτωσης σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα έκπτωσης σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “discount” button"),
            keywords: &[
                "Japanese",
                "Japanese “discount” button",
                "ideograph",
                "“discount”",
                "割",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"descuento\""),
            keywords: &[
                "descuento",
                "ideograma",
                "ideograma japonés para \"descuento\"",
                "japonés",
                "kanji",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"allahindlus\""),
            keywords: &[
                "\"allahindlus\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"allahindlus\"",
                "割",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"deskontua\" botoia"),
            keywords: &[
                "japoniera",
                "japonierazko \"deskontua\" botoia",
                "zatiketa irudikatzen duen ideograma karratu batean",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ «تخفیف» به ژاپنی"),
            keywords: &[
                "اندیشه\u{200c}نگاشت",
                "تخفیف",
                "حراج",
                "دکمۀ «تخفیف» به ژاپنی",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("alennus-kirjoitusmerkki"),
            keywords: &["alennus-kirjoitusmerkki", "japani", "kirjoitusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button para sa salitang \"diskuwento\""),
            keywords: &[
                "Hapones",
                "Hapones na button para sa salitang \"diskuwento\"",
                "diskwento",
                "ideograpya",
                "nakaparisukat na ideograph ng paghati",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"avsláttur\" knappur"),
            keywords: &[
                "\"avsláttur\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"avsláttur\" knappur",
                "割",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton réduction en japonais"),
            keywords: &[
                "bouton réduction en japonais",
                "japonais",
                "rabais",
                "réduction",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}rabais\u{a0}»"),
            keywords: &[
                "idéogramme",
                "japonais",
                "rabais",
                "symbole japonais signifiant «\u{a0}rabais\u{a0}»",
                "割",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"lascaine\""),
            keywords: &[
                "cnaipe Seapáinise \"lascaine\"",
                "cnaipe Seapáinise \"saor in aisce\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Lasachadh”"),
            keywords: &[
                "Seapanais",
                "iapanais",
                "ideo-ghraf",
                "lasachadh",
                "putan Seapanais “Lasachadh”",
                "割",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"desconto\" en xaponés"),
            keywords: &[
                "botón \"desconto\" en xaponés",
                "desconto",
                "ideograma",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "\"છ\u{ac2}ટ\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
            ),
            keywords: &[
                "\"છ\u{ac2}ટ\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“છ\u{ac2}ટ”",
                "割",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"rangwame\" Na Japan"),
            keywords: &[
                "\"rangwame\"",
                "Na Japan",
                "maɓallin \"rangwame\" Na Japan",
                "zanen harshe",
                "割",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״הנחה״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״הנחה״ ביפנית",
                "לחצן ״הנחה״ ביפנית“",
                "״הנחה״",
                "割",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “छ\u{942}ट” बटन"),
            keywords: &["जापानी", "जापानी “छ\u{942}ट” बटन", "“छ\u{942}ट”", "割"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"popust\""),
            keywords: &["japanski", "tipka s ideogramom \"popust\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „engedmény” gomb"),
            keywords: &[
                "japán",
                "japán „engedmény” gomb",
                "képírásjel",
                "„engedmény”",
                "割",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաժանել գաղափարագիր"),
            keywords: &["բաժանել գաղափարագիր", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"diskon\""),
            keywords: &[
                "\"diskon\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"diskon\"",
                "割",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “agụpụrụ”"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi Ndị Japan “agụpụrụ”",
                "“agụpụrụ”",
                "割",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Afsláttur“ á japönsku"),
            keywords: &[
                "afsláttur",
                "japanska",
                "myndletur",
                "„Afsláttur“ á japönsku",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Sconto”"),
            keywords: &[
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Sconto”",
                "prezzo scontato",
                "sconto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("割マーク"),
            keywords: &["ディスカウント", "割", "割マーク", "割引"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"diskon\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"diskon\"",
                "“diskon”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაყოფის იდეოგრამა კვადრატში"),
            keywords: &["გაყოფის იდეოგრამა კვადრატში", "იაპონური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «бөлу» иероглифі"),
            keywords: &["жапон", "шаршыдағы «бөлу» иероглифі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for opdeling"),
            keywords: &["japansk", "kvadratisk ideogram for opdeling"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជប\u{17c9}\u{17bb}ន"),
            keywords: &[
                "ជប\u{17c9}\u{17bb}ន",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង “បញ\u{17d2}ច\u{17bb}ះតម\u{17d2}លៃ” ជាភាសាជប\u{17c9}\u{17bb}ន",
                "“បញ\u{17d2}ច\u{17bb}ះតម\u{17d2}លៃ”",
                "割",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} “ರ\u{cbf}ಯಾಯ\u{cbf}ತ\u{cbf}” ಬಟನ\u{ccd}"),
            keywords: &[
                "ಐಡ\u{cbf}ಯೋಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} “ರ\u{cbf}ಯಾಯ\u{cbf}ತ\u{cbf}” ಬಟನ\u{ccd}",
                "“ರ\u{cbf}ಯಾಯ\u{cbf}ತ\u{cbf}”",
                "割",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("나눌 할"),
            keywords: &["나누기", "나눌 할", "나눔", "분리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “सवलत” बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “सवलत” बटण",
                "जपानी “स\u{942}ट” बटण",
                "“स\u{942}ट”",
                "割",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы бөлүү идеограммасы"),
            keywords: &["жапончо", "чарчыдагы бөлүү идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’Rabatt’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’Rabatt’",
                "’Rabatt’",
                "割",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຫານ"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຫານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nuolaidą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "nuolaida",
                "nuolaidą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Atlaide kvadrātveida ietvarā"),
            keywords: &["ideogramma Atlaide kvadrātveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"kua whakaheke\""),
            keywords: &[
                "\"kua whakaheke\"",
                "Hapanīhi",
                "pātene Hapanīhi \"kua whakaheke\"",
                "tohuwhakairo",
                "割",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „попуст“ на јапонски"),
            keywords: &["копче „попуст“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"കിഴിവ\u{d4d}\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "\"കിഴിവ\u{d4d}\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"കിഴിവ\u{d4d}\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"хямдрал\" гэсэн товчлуур"),
            keywords: &[
                "\"хямдрал\"",
                "Японоор \"хямдрал\" гэсэн товчлуур",
                "дүрс үсэг",
                "割",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस विभाजन स\u{902}क\u{947}त"),
            keywords: &[
                "\"स\u{942}ट\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस विभाजन स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"स\u{942}ट\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “diskaun” Jepun"),
            keywords: &[
                "Jepun",
                "butang “diskaun” Jepun",
                "butang “ditempah” Jepun",
                "ideograf",
                "“diskaun”",
                "割",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “skont”"),
            keywords: &[
                "buttuna Ġappuniż “skont”",
                "ideograff",
                "Ġappuniż",
                "“skont”",
                "指",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ လျ\u{103e}ော\u{1037}စျေး ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ လျ\u{103e}ော\u{1037}စျေး ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} ခ\u{103d}\u{1032}ခြမ\u{103a}းမ\u{103e}\u{102f} အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«rabatt» på japansk"),
            keywords: &["ideograf", "japansk", "rabatt", "«rabatt» på japansk", "割"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड भाग लगाएको आइडियोग\u{94d}राफ"),
            keywords: &[
                "जापानिज",
                "स\u{94d}क\u{94d}वायर\u{94d}ड भाग लगाएको आइडियोग\u{94d}राफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘korting’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘korting’",
                "ideogram",
                "‘korting’",
                "割",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«rabatt» på japansk"),
            keywords: &["ideograf", "japansk", "rabatt", "«rabatt» på japansk", "割"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ର\u{b3f}ହ\u{b3e}ତ\u{b3f}” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ର\u{b3f}ହ\u{b3e}ତ\u{b3f}” ବଟନ\u{b4d}\u{200c}",
                "ର\u{b3f}ହ\u{b3e}ତ\u{b3f}",
                "ସଙ\u{b4d}କେତ",
                "“ର\u{b3f}ହ\u{b3e}ତ\u{b3f}”",
                "割",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਛ\u{a4b}ਟ\" ਬਟਨ"),
            keywords: &["\"ਛ\u{a4b}ਟ\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “رعائیت” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “رعائیت” دا بٹن",
                "“رعائیت”",
                "割",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Diskaunt” Bọ\u{301}tin"),
            keywords: &[
                "Diskaunt\"",
                "Idiógraf",
                "Japan",
                "Japán \"Diskaunt\" Bọ\u{301}tin",
                "Japán Bọ\u{301}tin Fọ “Diskaunt” Bọ\u{301}tin",
                "割",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „rabat”"),
            keywords: &[
                "ideogram",
                "japoński",
                "japoński przycisk „rabat”",
                "podział",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د جاپاني د \"رعایت\" بټن"),
            keywords: &[
                "\"رعايت\"",
                "آيډوګراف",
                "جاپاني",
                "د جاپاني د \"رعایت\" بټن",
                "割",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “desconto”"),
            keywords: &[
                "botão japonês de “desconto”",
                "ideograma",
                "japonês",
                "“desconto”",
                "割",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"desconto\" em japonês"),
            keywords: &["botão \"desconto\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „reducere” în japoneză"),
            keywords: &[
                "buton cu semnificația „reducere” în japoneză",
                "ideogramă",
                "japoneză",
                "„reducere”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-195"),
            keywords: &["E10-195"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скидка"),
            keywords: &[
                "значок",
                "значок \"скидка\"",
                "кнопка",
                "кнопка \"скидка\"",
                "скидка",
                "япония",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’discount’ mu kiyapani"),
            keywords: &[
                "\"kugabnaya ibiciro\"",
                "Nyapani",
                "buto ya ’discount’ mu kiyapani",
                "imyandikire",
                "割",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني \"رعايت\" بٽڻ"),
            keywords: &[
                "آئڊيوگراف",
                "جاپاني",
                "جاپاني \"رعايت\" بٽڻ",
                "“رعايت”",
                "指",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} බෙද\u{dd3}ම\u{dca} සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &[
                "ජපන\u{dca}",
                "හතරැස\u{dca} බෙද\u{dd3}ම\u{dca} සංකල\u{dca}ප ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Zľava"),
            keywords: &["japonský ideograf Zľava", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »popust« v japonščini"),
            keywords: &[
                "gumb za »popust« v japonščini",
                "ideogram",
                "japonsko",
                "pojmovni znak",
                "popust",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ‘‘sicir-dhimis’‘ ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka ‘‘sicir-dhimis’‘ ee Jabbaanka",
                "fikir-garafeed",
                "‘‘sicir-dhimis’‘",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «ulje çmimi» në japonisht"),
            keywords: &[
                "butoni «ulje çmimi» në japonisht",
                "ideograf",
                "japonisht",
                "«ulje çmimi»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „раздвајање“ у квадрату"),
            keywords: &[
                "идеограф",
                "идеограф „раздвајање“ у квадрату",
                "јапански",
                "јапанско дугме „снижење“",
                "„снижење“",
                "割",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["идеограф „раздвајање“ у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „razdvajanje“ u kvadratu"),
            keywords: &[
                "ideograf",
                "ideograf „razdvajanje“ u kvadratu",
                "japanski",
                "japansko dugme „sniženje“",
                "„sniženje“",
                "割",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ideograf „razdvajanje“ u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”rabatt”-knapp"),
            keywords: &[
                "ideogram",
                "ideogram för rabatt",
                "japansk",
                "japansk ”rabatt”-knapp",
                "rabatt",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya kugawanya kwenye mraba"),
            keywords: &["idiografu ya kugawanya kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"தள\u{bcd}ளுபடி\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"தள\u{bcd}ளுபடி\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"డ\u{c3f}స\u{c4d}క\u{c4c}ంట\u{c4d}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"డ\u{c3f}స\u{c4d}క\u{c4c}ంట\u{c4d}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Тахфиф\"-и ҷопонӣ"),
            keywords: &[
                "\"тахфиф\"",
                "идеограмма",
                "тугмаи \"Тахфиф\"-и ҷопонӣ",
                "ҷопонӣ",
                "割",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ส\u{e48}วนลด”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ส\u{e48}วนลด”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นหาร",
                "“ส\u{e48}วนลด”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ምጉዳል ዋጋ” መልጎም"),
            keywords: &[
                "ናይ ጃፓን",
                "ናይ ጃፓን “ምጉዳል ዋጋ” መልጎም",
                "ኣይድዮግራፍ",
                "“ምጉዳል ዋጋ”",
                "割",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"arzanladyş\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"arzanladyş\" düwmesi",
                "“arzanladyş”",
                "割",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «fakamaʻamaʻa» (fakasiapani)"),
            keywords: &[
                "fakamaʻamaʻa",
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «fakamaʻamaʻa» (fakasiapani)",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"indirim\" düğmesi"),
            keywords: &["Japonca", "Japonca \"indirim\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «ئېتىبار» دېگەن كۇنۇپكا"),
            keywords: &[
                "«ئېتىبار»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «ئېتىبار» دېگەن كۇنۇپكا",
                "割",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"знижка\" японською"),
            keywords: &["кнопка \"знижка\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"رعایت\" بٹن"),
            keywords: &[
                "تصویری علامت",
                "تقسیم",
                "جاپانی",
                "جاپانی \"رعایت\" بٹن",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi bo‘lish iyeroglifi"),
            keywords: &["kvadrat ichidagi bo‘lish iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “giảm giá”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “giảm giá”",
                "“giảm giá”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"wàññi\" bu sapoŋ"),
            keywords: &[
                "\"wàññi\"",
                "Sapone",
                "bitoŋu \"wàññi\" bu sapoŋ",
                "ideograf",
                "割",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"lesaphulelo\" lesiJapan"),
            keywords: &[
                "\"isaphulelo\"",
                "IsiJpan",
                "i-ideograph",
                "iqhosha elithi \"lesaphulelo\" lesiJapan",
                "割",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"ẹdinwo\""),
            keywords: &[
                "\"ẹ\u{300}dínwó\"",
                "Bọtini Japanisi \"ẹdinwo\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "割",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「割」按鈕"),
            keywords: &["割", "折扣", "日本", "日本「割」按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“割”按钮"),
            keywords: &["割", "折扣", "日本", "日本“割”按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“打折”按钮"),
            keywords: &["折扣", "按键", "日文", "日文的“打折”按钮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("割"),
            keywords: &["割"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「折扣」按鈕"),
            keywords: &["折扣", "日文嘅「折扣」按鈕", "特價"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuncishiswa kwentengo eliyiskwele"),
            keywords: &[
                "ukuncishiswa kwentengo",
                "uphawu lokuncishiswa kwentengo eliyiskwele",
            ],
        },
    ],
};
#[doc = "🈚"]
pub const JAPANESE__FREE_OF_CHARGE__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈚",
    codepoint: "1F21A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “free of charge” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “gratis”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “gratis”-knoppie",
                "ideogram",
                "“gratis”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የአሉታ ካሬ አይዶግራፍ"),
            keywords: &["የአሉታ ካሬ አይዶግራፍ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /مجانا\u{64b}/ باليابانية"),
            keywords: &["الزر /مجانا\u{64b}/ باليابانية", "الياباني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be}” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be}” ব\u{9c1}ট\u{9be}ম",
                "“বিন\u{9be}ম\u{9c2}লীয\u{9bc}\u{9be}”",
                "無",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat inkar ideoqramı"),
            keywords: &["kvadrat inkar ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «адсутнасць» у квадраце"),
            keywords: &[
                "кітайскае",
                "няма",
                "пісьмо",
                "японскае",
                "ідэаграма «адсутнасць» у квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „отрицание“ в квадрат"),
            keywords: &["Идеограма „отрицание“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র অপল\u{9be}পের চিত\u{9cd}রলিপি"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র অপল\u{9be}পের চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton \"digoust\" e japaneg"),
            keywords: &["bouton \"digoust\" e japaneg"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"besplatno\" na jap."),
            keywords: &[
                "Dugme \"besplatno\" na jap.",
                "Dugme sa tekstom \"besplatno\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"gratis\""),
            keywords: &[
                "\"gratis\"",
                "botó japonès \"gratis\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎠᏎᏭᎢ” ᎦᏗ"),
            keywords: &["ᎦᏅᏍᏙᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎠᏎᏭᎢ” ᎦᏗ", "“ᎠᏓᏂᏟᏗ ᏂᎨᏒᎾ”", "無"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „zdarma“"),
            keywords: &[
                "bezplatně",
                "ideogram",
                "japonština",
                "zdarma",
                "štítek s japonským znakem „zdarma“",
                "無",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff negyddiad mewn sgwâr"),
            keywords: &["Japaneaidd", "ideograff negyddiad mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for gratis"),
            keywords: &["japansk", "kvadratisk ideogram for gratis"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „gratis“"),
            keywords: &[
                "Schriftzeichen für „gratis“",
                "gratis",
                "japanisches Schriftzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα δωρεάν σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα δωρεάν σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “free of charge” button"),
            keywords: &[
                "Japanese",
                "Japanese “free of charge” button",
                "ideograph",
                "“free of charge”",
                "無",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"gratis\""),
            keywords: &[
                "gratis",
                "ideograma",
                "ideograma japonés para \"gratis\"",
                "japonés",
                "kanji",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"tasuta\""),
            keywords: &[
                "\"tasuta\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"tasuta\"",
                "無",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"doakoa\" botoia"),
            keywords: &[
                "ezeztapena irudikatzen duen ideograma karratu batean",
                "japoniera",
                "japonierazko \"doakoa\" botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ «رایگان» به ژاپنی"),
            keywords: &[
                "اندیشه\u{200c}نگاشت",
                "دکمۀ «رایگان» به ژاپنی",
                "رایگان",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maksuton-kirjainmerkki"),
            keywords: &["japani", "kirjoitusmerkki", "maksuton-kirjainmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Hapones na button na nagsasabing \"libre\""),
            keywords: &[
                "Hapones",
                "Hapones na button na nagsasabing \"libre\"",
                "ideograpya",
                "libre",
                "nakaparisukat na ideograph ng hindi pagsang-ayon",
                "pindutan",
                "singil",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"ókeypis\" knappur"),
            keywords: &[
                "\"ókeypis\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"ókeypis\" knappur",
                "無",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton gratuit en japonais"),
            keywords: &["bouton gratuit en japonais", "gratuit", "japonais"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}gratuit\u{a0}»"),
            keywords: &[
                "gratuit",
                "idéogramme",
                "japonais",
                "symbole japonais signifiant «\u{a0}gratuit\u{a0}»",
                "無",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnáipe Seapáinise \"saor in aisce\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"saor in aisce\"",
                "cnáipe Seapáinise \"saor in aisce\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Saor ’s an-asgaidh”"),
            keywords: &[
                "Seapanais",
                "an-asgaidh",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Saor ’s an-asgaidh”",
                "saor ‘s an-asgaidh",
                "無",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"gratis\" en xaponés"),
            keywords: &[
                "botón \"gratis\" en xaponés",
                "de balde",
                "gratis",
                "ideograma",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાપાની \"નિઃશ\u{ac1}લ\u{acd}ક\" બટન"),
            keywords: &[
                "ચોરસમા\u{a82} નિઃશ\u{ac1}લ\u{acd}ક માટ\u{ac7} જાપાનીઝ શબ\u{acd}દ",
                "જાપાની \"નિઃશ\u{ac1}લ\u{acd}ક\" બટન",
                "જાપાનીઝ \"નિઃશ\u{ac1}લ\u{acd}ક\" બટન",
                "જાપાનીઝ શબ\u{acd}દ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"kyauta\" Na Japan"),
            keywords: &[
                "\"kyauta\"",
                "Na Japan",
                "maɓallin \"kyauta\" Na Japan",
                "zanen harshe",
                "無",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״חינם״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״חינם״ ביפנית",
                "לחצן ״חינם״ ביפנית“",
                "無",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “म\u{941}फ\u{93c}\u{94d}त” बटन"),
            keywords: &[
                "जापानी",
                "जापानी “म\u{941}फ\u{93c}\u{94d}त” बटन",
                "निःश\u{941}ल\u{94d}क",
                "“म\u{941}फ\u{93c}\u{94d}त”",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"besplatno\""),
            keywords: &["japanski", "tipka s ideogramom \"besplatno\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „ingyenes” gomb"),
            keywords: &[
                "japán",
                "japán „ingyenes” gomb",
                "képírásjel",
                "„ingyenes”",
                "無",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժխտում գաղափարագիր"),
            keywords: &["ժխտում գաղափարագիր", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"gratis\""),
            keywords: &[
                "\"gratis\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"gratis\"",
                "無",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “bụ nke efù”"),
            keywords: &[
                "Japanese",
                "ideograph",
                "Ọdụmbi Ndị Japan “bụ nke efù”",
                "“bụ nke efù”",
                "無",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Ókeypis“ á japönsku"),
            keywords: &["japanska", "myndletur", "ókeypis", "„Ókeypis“ á japönsku"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Gratis”"),
            keywords: &[
                "giapponese",
                "gratis",
                "ideogramma",
                "ideogramma giapponese di “Gratis”",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("無マーク"),
            keywords: &["タダ", "無", "無マーク", "無料"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"gratis\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"gratis\"",
                "“gratis”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უარყოფის იდეოგრამა კვადრატში"),
            keywords: &["იაპონური", "უარყოფის იდეოგრამა კვადრატში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «бас тарту» иероглифі"),
            keywords: &["жапон", "шаршыдағы «бас тарту» иероглифі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for forhandling"),
            keywords: &["japansk", "kvadratisk ideogram for forhandling"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ការបដ\u{17b7}សេធ",
            ),
            keywords: &[
                "បដ\u{17b7}សេធ",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ការបដ\u{17b7}សេធ",
                "អក\u{17d2}សរច\u{17b7}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} \"ಉಚ\u{cbf}ತವಾಗ\u{cbf}\" ಬಟನ\u{ccd}"),
            keywords: &[
                "\"ಉಚ\u{cbf}ತವಾಗ\u{cbf}\"",
                "ಐಡ\u{cbf}ಯೋಗ\u{ccd}ರಾಫ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd}",
                "ಜಪಾನೀಸ\u{ccd} \"ಉಚ\u{cbf}ತವಾಗ\u{cbf}\" ಬಟನ\u{ccd}",
                "無",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("없을 무"),
            keywords: &["없을 무", "없음"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “श\u{941}ल\u{94d}क ना “ बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “फ\u{941}कट” बटण",
                "जपानी “श\u{941}ल\u{94d}क ना “ बटण",
                "“फ\u{941}कट”",
                "無",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы сүйлөшүү идеограммасы"),
            keywords: &["жапончо", "чарчыдагы сүйлөшүү идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’gratis’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’gratis’",
                "’gratis’",
                "無",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ບ\u{ecd}\u{ec8}ມ\u{eb5}"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ບ\u{ecd}\u{ec8}ມ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nemokamumą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "nemokamai",
                "nemokamumą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Nebūt kvadrātveida ietvarā"),
            keywords: &["ideogramma Nebūt kvadrātveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"kāore he utu\""),
            keywords: &[
                "\"kāore he utu\"",
                "Hapanīhi",
                "pātene Hapanīhi \"kāore he utu\"",
                "tohuwhakairo",
                "無",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „бесплатно“ на јапонски"),
            keywords: &["копче „бесплатно“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സ\u{d57}ജന\u{d4d}യമ\u{d3e}ണ\u{d4d}\" ബട\u{d4d}ടൺ",
            ),
            keywords: &[
                "\"സ\u{d57}ജന\u{d4d}യമ\u{d3e}ണ\u{d4d}\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സ\u{d57}ജന\u{d4d}യമ\u{d3e}ണ\u{d4d}\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"үнэгүй\" гэсэн товчлуур"),
            keywords: &[
                "\"үнэгүй\"",
                "Японоор \"үнэгүй\" гэсэн товчлуур",
                "дүрс үсэг",
                "無",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस नकार स\u{902}क\u{947}त"),
            keywords: &[
                "\"मोफत\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस नकार स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"मोफत\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “percuma” Jepun"),
            keywords: &[
                "Jepun",
                "butang “percuma” Jepun",
                "ideograf",
                "“percuma”",
                "無",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “bla ħlas”"),
            keywords: &[
                "buttuna Ġappuniż “bla ħlas”",
                "ideograff",
                "Ġappuniż",
                "“b’xejn”",
                "有",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ အခမ\u{1032}\u{1037} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ အခမ\u{1032}\u{1037} ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} ငြင\u{103a}းဆ\u{102d}\u{102f}ချက\u{103a} အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«gratis» på japansk"),
            keywords: &["gratis", "ideograf", "japansk", "«gratis» på japansk", "無"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड न\u{947}भिग\u{947}सन आइडियोग\u{94d}राफ"),
            keywords: &[
                "जापानिज",
                "स\u{94d}क\u{94d}वायर\u{94d}ड न\u{947}भिग\u{947}सन आइडियोग\u{94d}राफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘gratis’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘gratis’",
                "ideogram",
                "‘gratis’",
                "無",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«gratis» på japansk"),
            keywords: &["gratis", "ideograf", "japansk", "«gratis» på japansk", "無"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ଦେୟ ମ\u{b41}କ\u{b4d}ତ” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ଦେୟ ମ\u{b41}କ\u{b4d}ତ” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ଦେୟ ମ\u{b41}କ\u{b4d}ତ”",
                "無",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਮ\u{a41}ਫਤ\" ਬਟਨ"),
            keywords: &["\"ਮ\u{a41}ਫਤ\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “ادائیگی ت\u{64f}وں بغیر” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “ادائیگی ت\u{64f}وں بغیر” دا بٹن",
                "“ادائیگی ت\u{64f}وں بغیر”",
                "無",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Frí Ọf Chaj”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Frí Ọf Chaj”",
                "Japán Pípol",
                "Japán Raítin",
                "“Frí Ọf Chaj”",
                "無",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „bezpłatne”"),
            keywords: &[
                "ideogram",
                "japoński",
                "japoński przycisk „bezpłatne”",
                "negacja",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"وړیا\"بټن"),
            keywords: &[
                "\"وړیا\"",
                "Jجاپاني \"وړیا\"بټن",
                "آيډوګراف",
                "جاپاني",
                "جاپاني \"وړیا\"بټن",
                "無",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “gratuito”"),
            keywords: &[
                "botão japonês de “gratuito”",
                "ideograma",
                "japonês",
                "“gratuito”",
                "無",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"gratuito\" em japonês"),
            keywords: &["botão \"gratuito\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „gratis” în japoneză"),
            keywords: &[
                "buton cu semnificația „gratis” în japoneză",
                "ideogramă",
                "japoneză",
                "„gratis”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-186"),
            keywords: &["E10-186"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бесплатно"),
            keywords: &["бесплатно", "значок", "кнопка", "япония"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’free Of Charge’ mu kiyapani"),
            keywords: &[
                "\"ubuntu\"",
                "Nyapani",
                "buto ya ’free Of Charge’ mu kiyapani",
                "imyandikire",
                "無",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘مفت ۾‘ بٽڻ"),
            keywords: &[
                "آئڊيوگراف",
                "جاپاني",
                "جاپاني ‘مفت ۾‘ بٽڻ",
                "“مفت ۾ ”",
                "有",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} සෘණ සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &["ජපන\u{dca}", "හතරැස\u{dca} සෘණ සංකල\u{dca}ප ලක\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Zadarmo"),
            keywords: &["japonský ideograf Zadarmo", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »brezplačno« v japonščini"),
            keywords: &[
                "brezplačno",
                "gumb za »brezplačno« v japonščini",
                "ideogram",
                "japonsko",
                "pojmovni znak",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ‘‘waa bilaash’‘ ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka ‘‘waa bilaash’‘ ee Jabbaanka",
                "fikir-garafeed",
                "‘‘waa bilaash’‘",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «falas» në japonisht"),
            keywords: &[
                "butoni «falas» në japonisht",
                "ideograf",
                "japonisht",
                "«falas»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф за негацију у квадрату"),
            keywords: &[
                "идеограф",
                "идеограф за негацију у квадрату",
                "јапански",
                "јапанско дугме „бесплатно“",
                "„бесплатно“",
                "無",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["идеограф за негацију у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf za negaciju u kvadratu"),
            keywords: &[
                "ideograf",
                "ideograf za negaciju u kvadratu",
                "japanski",
                "japansko dugme „besplatno“",
                "„besplatno“",
                "無",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ideograf za negaciju u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”gratis”-knapp"),
            keywords: &[
                "gratis",
                "ideogram",
                "ideogram för gratis",
                "japansk",
                "japansk ”gratis”-knapp",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya kutoa kwenye mraba"),
            keywords: &["idiografu ya kutoa kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"கட\u{bcd}டணமில\u{bcd}ல\u{bbe} சேவை\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"கட\u{bcd}டணமில\u{bcd}ல\u{bbe} சேவை\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఛ\u{c3e}ర\u{c4d}జ\u{c40} ల\u{c47}దు\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఛ\u{c3e}ర\u{c4d}జ\u{c40} ల\u{c47}దు\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Ройгон\"-и ҷопонӣ"),
            keywords: &[
                "\"ройгон\"",
                "идеограмма",
                "тугмаи \"Ройгон\"-и ҷопонӣ",
                "ҷопонӣ",
                "無",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ไม\u{e48}ม\u{e35}”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ไม\u{e48}ม\u{e35}”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นไม\u{e48}ม\u{e35}",
                "“ไม\u{e48}ม\u{e35}”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ካብ ክፍሊት ነጻ” መልጎም"),
            keywords: &[
                "ናይ ጃፓን",
                "ናይ ጃፓን “ካብ ክፍሊት ነጻ” መልጎም",
                "ኣይድዮግራፍ",
                "“ካብ ክፍሊት ነጻ”",
                "無",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"mugt\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"mugt\" düwmesi",
                "“mugt”",
                "無",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «taʻetotongi» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «taʻetotongi» (fakasiapani)",
                "taʻetotongi",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"ücretsiz\" düğmesi"),
            keywords: &["Japonca", "Japonca \"ücretsiz\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «ھەقسىز» دېگەن كۇنۇپكا"),
            keywords: &[
                "«ھەقسىز»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «ھەقسىز» دېگەن كۇنۇپكا",
                "無",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"безкоштовно\" японською"),
            keywords: &["кнопка \"безкоштовно\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"مفت\" بٹن"),
            keywords: &[
                "تصویری علامت",
                "جاپانی",
                "جاپانی \"مفت\" بٹن",
                "نفی",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi inkor iyeroglifi"),
            keywords: &["kvadrat ichidagi inkor iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “miễn phí”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “miễn phí”",
                "“miễn phí”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"amul juuti\" bu sapoŋ"),
            keywords: &[
                "\"amul juuti\"",
                "Sapone",
                "bitoŋu \"amul juuti\" bu sapoŋ",
                "ideograf",
                "無",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"simahala\" lesiJapan"),
            keywords: &[
                "\"simahala\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"simahala\" lesiJapan",
                "無",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"lọ\u{301}fẹ\u{300}é\u{329}\""),
            keywords: &[
                "\"lọ\u{301}fẹ\u{300}é\u{329}\"",
                "Bọtini Japanisi \"lọ\u{301}fẹ\u{300}é\u{329}\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "無",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「無」按鈕"),
            keywords: &["免費", "日本", "日本「無」按鈕", "無"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“无”按钮"),
            keywords: &["免费", "无", "日本", "日本“无”按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“免费”按钮"),
            keywords: &["免费", "按键", "日文", "日文的“免费”按钮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("無"),
            keywords: &["免費", "無"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「免費」按鈕"),
            keywords: &["免費", "日文嘅「免費」按鈕", "無"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuphela komkhiqizo eliyiskwele"),
            keywords: &[
                "ukuphela komkhiqizo",
                "uphawu lokuphela komkhiqizo eliyiskwele",
            ],
        },
    ],
};
#[doc = "🈲"]
pub const JAPANESE__PROHIBITED__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈲",
    codepoint: "1F232",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “prohibited” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “verbode”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “verbode”-knoppie",
                "ideogram",
                "“verbode”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተከለከለ ካሬ አይዶግራፍ"),
            keywords: &["የተከለከለ ካሬ አይዶግራፍ", "የጃፓን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /ممنوع/ باليابانية"),
            keywords: &["الزر /ممنوع/ باليابانية", "ياباني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “নিষিদ\u{9cd}ধ” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “নিষিদ\u{9cd}ধ” ব\u{9c1}ট\u{9be}ম",
                "“নিষিদ\u{9cd}ধ”",
                "禁",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat qadağa ideoqramı"),
            keywords: &["kvadrat qadağa ideoqramı", "yapon"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «забаронена» ў квадраце"),
            keywords: &[
                "забарона",
                "пісьмо",
                "японскае",
                "ідэаграма «забаронена» ў квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „забранявам“ в квадрат"),
            keywords: &["Идеограма „забранявам“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র নিষিদ\u{9cd}ধ চিত\u{9cd}রলিপি"),
            keywords: &[
                "জ\u{9be}প\u{9be}নি",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র নিষিদ\u{9cd}ধ চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bouton \"difennet\" e japaneg"),
            keywords: &["bouton \"difennet\" e japaneg"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"zabranjeno\" na jap."),
            keywords: &[
                "Dugme \"zabranjeno\" na jap.",
                "Dugme sa tekstom \"zabranjeno\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"prohibit\""),
            keywords: &[
                "botó japonès \"prohibit\"",
                "ideograma",
                "japonès",
                "kanji",
                "prohibició",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎢᏯᏛᏁᏗ ᏂᎨᏒᎾ” ᎦᏗ"),
            keywords: &["ᎦᏅᏍᏙᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎢᏯᏛᏁᏗ ᏂᎨᏒᎾ” ᎦᏗ", "“ᎦᏅᏍᏙᏍᎦ“", "禁"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „zákaz“"),
            keywords: &[
                "ideogram",
                "japonština",
                "zakázáno",
                "štítek s japonským znakem „zákaz“",
                "禁",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff gwaharddiad mewn sgwâr"),
            keywords: &["Japaneaidd", "ideograff gwaharddiad mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for forbud"),
            keywords: &["japansk", "kvadratisk ideogram for forbud"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „verbieten“"),
            keywords: &[
                "Schriftzeichen für „verbieten“",
                "japanisches Schriftzeichen",
                "verbieten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα απαγόρευσης σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα απαγόρευσης σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “prohibited” button"),
            keywords: &[
                "Japanese",
                "Japanese “prohibited” button",
                "ideograph",
                "“prohibited”",
                "禁",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"prohibido\""),
            keywords: &[
                "ideograma",
                "ideograma japonés para \"prohibido\"",
                "japonés",
                "kanji",
                "prohibido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"keelatud\""),
            keywords: &[
                "\"keelatud\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"keelatud\"",
                "禁",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"debekatuta\" botoia"),
            keywords: &[
                "debekua irudikatzen duen ideograma karratu batean",
                "japoniera",
                "japonierazko \"debekatuta\" botoia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ «ممنوع» به ژاپنی"),
            keywords: &[
                "اندیشه\u{200c}نگاشت",
                "دکمۀ «ممنوع» به ژاپنی",
                "ممنوع",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kielletty-kirjoitusmerkki"),
            keywords: &["japani", "kielletty-kirjoitusmerkki", "kirjoitusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakaparisukat na ideograph ng pagbabawal"),
            keywords: &[
                "Hapones",
                "bawal",
                "ideograpya",
                "nakaparisukat na ideograph ng pagbabawal",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"bannað\" knappur"),
            keywords: &[
                "\"bannað\"",
                "\"forboð\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"bannað\" knappur",
                "禁",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton interdit en japonais"),
            keywords: &["bouton interdit en japonais", "japonais"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}interdit\u{a0}»"),
            keywords: &[
                "idéogramme",
                "interdit",
                "japonais",
                "symbole japonais signifiant «\u{a0}interdit\u{a0}»",
                "禁",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"cosc\""),
            keywords: &[
                "Seapáinis",
                "cnaipe Seapáinise \"cosc\"",
                "cnáipe Seapáinis \"cosc\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Toirmisgte”"),
            keywords: &[
                "Seapanais",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Toirmisgte”",
                "toirmisgte",
                "禁",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"prohibido\" en xaponés"),
            keywords: &[
                "botón \"prohibido\" en xaponés",
                "ideograma",
                "prohibido",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જાપાની \"નિષ\u{ac7}ધ\" બટન"),
            keywords: &[
                "ચોરસમા\u{a82} નિષિદ\u{acd}ધ માટ\u{ac7} જાપાની શબ\u{acd}દ",
                "ચોરસમા\u{a82} નિષ\u{ac7}ધ માટ\u{ac7} જાપાની શબ\u{acd}દ",
                "જાપાની \"નિષ\u{ac7}ધ\" બટન",
                "જાપાની શબ\u{acd}દ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"an hana\" Na Japan"),
            keywords: &[
                "\"an hana\"",
                "Na Japan",
                "maɓallin \"an hana\" Na Japan",
                "zanen harshe",
                "禁",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״אסור״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״אסור״ ביפנית",
                "לחצן ״אסור״ ביפנית“",
                "禁",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “निष\u{947}ध” बटन"),
            keywords: &["जापानी", "जापानी “निष\u{947}ध” बटन", "“निष\u{947}ध”", "禁"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"zabranjeno\""),
            keywords: &["japanski", "tipka s ideogramom \"zabranjeno\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „tiltott” gomb"),
            keywords: &[
                "japán",
                "japán „tiltott” gomb",
                "képírásjel",
                "„tiltott”",
                "禁",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արգելել գաղափարագիր"),
            keywords: &["արգելել գաղափարագիր", "ճապոնական", "ճապոներեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"dilarang\""),
            keywords: &[
                "\"dilarang\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"dilarang\"",
                "禁",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “egbochiri”"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi Ndị Japan “egbochiri”",
                "“egbochiri”",
                "禁",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Bannað“ á japönsku"),
            keywords: &["bannað", "japanska", "myndletur", "„Bannað“ á japönsku"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Proibito”"),
            keywords: &[
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Proibito”",
                "proibito",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("禁マーク"),
            keywords: &["厳禁", "禁", "禁マーク", "禁止"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"larangan\""),
            keywords: &[
                "Jepang",
                "ideografi",
                "tombol Jepang \"larangan\"",
                "“larangan”",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აკრძალვის იდეოგრამა კვადრატში"),
            keywords: &["აკრძალვის იდეოგრამა კვადრატში", "იაპონური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «тыйым салу» иероглифі"),
            keywords: &["жапон", "шаршыдағы «тыйым салу» иероглифі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for forbud"),
            keywords: &["japansk", "kvadratisk ideogram for forbud"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ហាម"),
            keywords: &[
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ហាម",
                "ហាម",
                "អក\u{17d2}សរច\u{17b7}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} “ನ\u{cbf}ಷೇಧ\u{cbf}ಸಲಾಗ\u{cbf}ದ\u{cc6}” ಬಟನ\u{ccd}"),
            keywords: &[
                "ಜಪಾನೀಸ\u{ccd} “ನ\u{cbf}ಷೇಧ\u{cbf}ಸಲಾಗ\u{cbf}ದ\u{cc6}” ಬಟನ\u{ccd}",
                "ಜಾಪನೀಸ\u{ccd} ಪದ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("금할 금"),
            keywords: &["금지", "금하다", "금할 금", "차단"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “प\u{94d}रतिब\u{902}ध” बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “प\u{94d}रतिब\u{902}धीत” बटण",
                "जपानी “प\u{94d}रतिब\u{902}ध” बटण",
                "“प\u{94d}रतिब\u{902}धीत”",
                "禁",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы тыюу салуу идеограммасы"),
            keywords: &["жапончо", "чарчыдагы тыюу салуу идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’verbueden’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’verbueden’",
                "’verbueden’",
                "禁",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຫ\u{ec9}າມ"),
            keywords: &[
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນ",
                "ພາສາຍ\u{eb5}\u{ec8}ປ\u{eb8}\u{ec8}ນຄຳວ\u{ec8}າ ຫ\u{ec9}າມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("draudimą reiškiantis hieroglifas"),
            keywords: &[
                "draudimas",
                "draudimą reiškiantis hieroglifas",
                "hieroglifas",
                "japonų",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Aizliegt kvadrātveida ietvarā"),
            keywords: &["ideogramma Aizliegt kvadrātveida ietvarā", "japāņu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"kua whakakore\""),
            keywords: &[
                "\"kua whakakore\"",
                "Hapanīhi",
                "pātene Hapanīhi \"kua whakakore\"",
                "tohuwhakairo",
                "禁",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „забрането“ на јапонски"),
            keywords: &["копче „забрането“ на јапонски", "јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"നിരോധിച\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}\" ബട\u{d4d}ടൺ",
            ),
            keywords: &[
                "\"നിരോധിച\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"നിരോധിച\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"хориотой\" гэсэн товчлуур"),
            keywords: &[
                "\"хориотой\"",
                "Японоор \"хориотой\" гэсэн товчлуур",
                "дүрс үсэг",
                "禁",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस प\u{94d}रतिब\u{902}धित स\u{902}क\u{947}त"),
            keywords: &[
                "\"प\u{94d}रतिब\u{902}धित\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस प\u{94d}रतिब\u{902}धित स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"प\u{94d}रतिब\u{902}धित\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “dilarang” Jepun"),
            keywords: &[
                "Jepun",
                "butang “dilarang” Jepun",
                "butang “ditempah” Jepun",
                "ideograf",
                "“dilarang”",
                "禁",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “projbit”"),
            keywords: &[
                "buttuna Ġappuniż “projbit”",
                "ideograph",
                "Ġappuniż",
                "“projbit”",
                "禁",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဂျပန\u{103a}ဘာသာ တားမြစ\u{103a}ချက\u{103a} ခလ\u{102f}တ\u{103a}"),
            keywords: &[
                "ဂျပန\u{103a} ဘာသာစကား",
                "ဂျပန\u{103a}ဘာသာ တားမြစ\u{103a}ချက\u{103a} ခလ\u{102f}တ\u{103a}",
                "လေးထောင\u{1037}\u{103a}က\u{103d}က\u{103a} တားမြစ\u{103a}ချက\u{103a} အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«forbudt» på japansk"),
            keywords: &[
                "forbudt",
                "ideograf",
                "japansk",
                "«forbudt» på japansk",
                "禁",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}क\u{94d}वायर\u{94d}ड निष\u{947}धित आइडियोग\u{94d}राफ"),
            keywords: &[
                "जापानिज",
                "स\u{94d}क\u{94d}वायर\u{94d}ड निष\u{947}धित आइडियोग\u{94d}राफ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘verboden’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘verboden’",
                "ideogram",
                "‘verboden’",
                "禁",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«forbode» på japansk"),
            keywords: &[
                "forbode",
                "ideograf",
                "japansk",
                "«forbode» på japansk",
                "禁",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ”",
                "禁",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਪ\u{a4d}ਰਤਿਬ\u{a70}ਧਿਤ\" ਬਟਨ"),
            keywords: &["\"ਪ\u{a4d}ਰਤਿਬ\u{a70}ਧਿਤ\" ਬਟਨ", "ਜਾਪਾਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “ممنوع” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “ممنوع” دا بٹن",
                "“ممنوع”",
                "禁",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Fọbid”"),
            keywords: &[
                "\"Nọ\u{301} Dú Am\"",
                "Japán Bọ\u{301}tin Fọ “Fọbid”",
                "Japán Pípol",
                "Japán Raítin",
                "“Fọbid”",
                "禁",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „zabronione”"),
            keywords: &[
                "ideogram",
                "japoński",
                "japoński przycisk „zabronione”",
                "zakaz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"منع شوي\" بټن"),
            keywords: &[
                "\"منع شوي\"",
                "آيډوګراف",
                "جاپاني",
                "جاپاني \"منع شوي\" بټن",
                "禁",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “proibido”"),
            keywords: &[
                "botão japonês de “proibido”",
                "ideograma",
                "japonês",
                "“proibido”",
                "禁",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"proibido\" em japonês"),
            keywords: &["botão \"proibido\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „interzis” în japoneză"),
            keywords: &[
                "buton cu semnificația „interzis” în japoneză",
                "ideogramă",
                "japoneză",
                "„interzis”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-188"),
            keywords: &["E10-188"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("запрет"),
            keywords: &[
                "воспрещен",
                "запрет",
                "запрещено",
                "значок",
                "кнопка",
                "нельзя",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’prohibited’ mu kiyapani"),
            keywords: &[
                "\"kibujijwe\"",
                "Nyapani",
                "buto ya ’prohibited’ mu kiyapani",
                "imyandikire",
                "禁",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘منع ڪيل’ بٽڻ"),
            keywords: &[
                "آئڊيوگراف",
                "جاپاني",
                "جاپاني ‘منع ڪيل’ بٽڻ",
                "“منع ٿيل”",
                "禁",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} තහනම\u{dca} සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &[
                "ජපන\u{dca}",
                "හතරැස\u{dca} තහනම\u{dca} සංකල\u{dca}ප ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Zákaz"),
            keywords: &["japonský ideograf Zákaz", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »prepovedano« v japonščini"),
            keywords: &[
                "gumb za »prepovedano« v japonščini",
                "ideogram",
                "japonsko",
                "pojmovni znak",
                "prepovedano",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ‘‘mamnuuc’‘ ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka ‘‘mamnuuc’‘ ee Jabbaanka",
                "badhanka ‘‘waa bilaash’‘ ee Jabbaanka",
                "fikir-garafeed",
                "‘‘waa bilaash’‘",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «ndaluar» në japonisht"),
            keywords: &[
                "butoni «ndaluar» në japonisht",
                "ideograf",
                "japonisht",
                "«ndaluar»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „забрањено“ у квадрату"),
            keywords: &[
                "идеограф",
                "идеограф „забрањено“ у квадрату",
                "јапански",
                "јапанско дугме „забрањено“",
                "„забрањено“",
                "禁",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["идеограф „забрањено“ у квадрату"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „zabranjeno“ u kvadratu"),
            keywords: &[
                "ideograf",
                "ideograf „zabranjeno“ u kvadratu",
                "japanski",
                "japansko dugme „zabranjeno“",
                "„zabranjeno“",
                "禁",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ideograf „zabranjeno“ u kvadratu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”förbjudet”-knapp"),
            keywords: &[
                "förbjudet",
                "ideogram",
                "ideogram för förbud",
                "japansk",
                "japansk ”förbjudet”-knapp",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya marufuku kwenye mraba"),
            keywords: &["idiografu ya marufuku kwenye mraba", "kijapani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"தடை செய\u{bcd}யப\u{bcd}பட\u{bcd}டது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"தடை செய\u{bcd}யப\u{bcd}பட\u{bcd}டது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"న\u{c3f}ష\u{c3f}ద\u{c4d}ధం\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "జపన\u{c40}స\u{c4d} పదం",
                "జపన\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"న\u{c3f}ష\u{c3f}ద\u{c4d}ధం\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
                "జప\u{c3e}న\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"манъ аст\"-и ҷопонӣ"),
            keywords: &[
                "\"манъшуда\"",
                "идеограмма",
                "тугмаи \"манъ аст\"-и ҷопонӣ",
                "ҷопонӣ",
                "禁",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ห\u{e49}าม”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ห\u{e49}าม”",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นห\u{e49}าม",
                "“ห\u{e49}าม”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ዝተኣገደ” መልጎም"),
            keywords: &[
                "ናይ ጃፓን",
                "ናይ ጃፓን “ዝተኣገደ” መልጎም",
                "ናይ ጃፓን “ዝተኣገደ”መልጎም",
                "ኣይድዮግራፍ",
                "“ዝተኣገደ”",
                "禁",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"gadagan\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"gadagan\" düwmesi",
                "“gadagan”",
                "禁",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «tapu» (fakasiapani)"),
            keywords: &[
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «tapu» (fakasiapani)",
                "tapu",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"yasak\" düğmesi"),
            keywords: &["Japonca", "Japonca \"yasak\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «چەكلەنگەن» دېگەن كۇنۇپكا"),
            keywords: &[
                "«چەكلەش»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «چەكلەنگەن» دېگەن كۇنۇپكا",
                "禁",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"заборонено\" японською"),
            keywords: &["кнопка \"заборонено\" японською", "японський"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"ممنوع\" بٹن"),
            keywords: &[
                "تصویری علامت",
                "جاپانی",
                "جاپانی \"ممنوع\" بٹن",
                "ممانعت",
                "چوکور",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kvadrat ichidagi taqiqlash iyeroglifi"),
            keywords: &["kvadrat ichidagi taqiqlash iyeroglifi", "yaponcha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “bị cấm”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “bị cấm”",
                "“bị cấm”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"dañu koy tere\" bu sapoŋ"),
            keywords: &[
                "\"dañu koy tere\"",
                "Sapone",
                "bitoŋu \"dañu koy tere\" bu sapoŋ",
                "ideograf",
                "禁",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"ithintelwe\" lesiJapan"),
            keywords: &[
                "\"ithintelwe\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"ithintelwe\" lesiJapan",
                "禁",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini Japanisi \"ṣediwọ\""),
            keywords: &[
                "\"àìfàyègbà\"",
                "Bọtini Japanisi \"ṣediwọ\"",
                "Japanese",
                "àmì ajẹmáwòrán",
                "禁",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「禁」按鈕"),
            keywords: &["日本", "日本「禁」按鈕", "禁", "禁止"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“禁”按钮"),
            keywords: &["日本", "日本“禁”按钮", "禁", "禁止"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“禁止”按钮"),
            keywords: &["严禁", "按键", "日文", "日文的“禁止”按钮"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("禁"),
            keywords: &["禁"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「禁止」按鈕"),
            keywords: &["日文嘅「禁止」按鈕", "禁止"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokwenqatshelwa oluyiskwele"),
            keywords: &["ukwenqaba", "uphawu lokwenqatshelwa oluyiskwele"],
        },
    ],
};
#[doc = "🉑"]
pub const JAPANESE__ACCEPTABLE__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🉑",
    codepoint: "1F251",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “acceptable” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese “aanvaarbaar”-knoppie"),
            keywords: &[
                "Japannees",
                "Japannese “aanvaarbaar”-knoppie",
                "ideogram",
                "“aanvaarbaar”",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ክብ የተቀበል አይዶግራፍ"),
            keywords: &["ክብ የተቀበል አይዶግራፍ", "የቻይና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /مقبول/ باليابانية"),
            keywords: &["الزر /مقبول/ باليابانية", "صينية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “গ\u{9cd}ৰহণযোগ\u{9cd}য” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “গ\u{9cd}ৰহণযোগ\u{9cd}য” ব\u{9c1}ট\u{9be}ম",
                "“গ\u{9cd}ৰহণযোগ\u{9cd}য”",
                "可",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dairə qəbul etmək ideoqramı"),
            keywords: &["dairə qəbul etmək ideoqramı", "çin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «прыняць» ў крузе"),
            keywords: &[
                "кітайскае",
                "прымальна",
                "пісьмо",
                "ідэаграма «прыняць» ў крузе",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма за приемане в кръг"),
            keywords: &["Идеограма за приемане в кръг", "китайски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}ত\u{9cd}তের মধ\u{9cd}যে স\u{9cd}বীক\u{9c3}ত চিত\u{9cd}রলিপি"),
            keywords: &[
                "চীন\u{9be}",
                "ব\u{9c3}ত\u{9cd}তের মধ\u{9cd}যে স\u{9cd}বীক\u{9c3}ত চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"prihvatljivo\" na jap."),
            keywords: &[
                "Dugme \"prihvatljivo\" na jap.",
                "Dugme sa tekstom \"prihvatljivo\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"acceptable\""),
            keywords: &[
                "acceptable",
                "botó japonès \"acceptable\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᏗᏓᏂᎸᏍᏗ” ᎦᏗ"),
            keywords: &["ᏣᏩᏂᏏ “ᎦᏅᏍᏓ”", "ᏣᏩᏂᏏ “ᏗᏓᏂᎸᏍᏗ” ᎦᏗ", "“ᏗᏓᏓᏂᎸᏍᏙᏗ”", "可"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „přijatelné“"),
            keywords: &[
                "ideogram",
                "japonština",
                "přijetí",
                "příjem",
                "štítek s japonským znakem „přijatelné“",
                "可",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff derbyn mewn cylch"),
            keywords: &["Tsieineaidd", "ideograff derbyn mewn cylch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("cirkulært ideogram for accept"),
            keywords: &["cirkulært ideogram for accept", "japansk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „akzeptieren“"),
            keywords: &[
                "Schriftzeichen für „akzeptieren“",
                "akzeptieren",
                "japanisches Schriftzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα αποδοχής σε κύκλο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα αποδοχής σε κύκλο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “acceptable” button"),
            keywords: &[
                "Japanese",
                "Japanese “acceptable” button",
                "ideograph",
                "“acceptable”",
                "可",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"aceptable\""),
            keywords: &[
                "aceptable",
                "ideograma",
                "ideograma japonés para \"aceptable\"",
                "japonés",
                "kanji",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"vastuvõetav\""),
            keywords: &[
                "\"vastuvõetav\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"vastuvõetav\"",
                "可",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"onargarria\" botoia"),
            keywords: &[
                "japonierazko \"onargarria\" botoia",
                "onarpena irudikatzen duen ideograma zirkulu batean",
                "txinera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ «قابل قبول» به ژاپنی"),
            keywords: &[
                "اندیشه\u{200c}نگاشت",
                "دکمۀ «قابل قبول» به ژاپنی",
                "قبول",
                "پذیرش",
                "پذیرفتن",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hyväksyttävä-kirjoitusmerkki"),
            keywords: &["hyväksyttävä-kirjoitusmerkki", "kiina", "kirjoitusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakabilog na ideograph ng pagtanggap"),
            keywords: &[
                "Hapones",
                "ideograpya",
                "katanggap-tanggap",
                "nakabilog na ideograph ng pagtanggap",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"hóskandi\" knappur"),
            keywords: &[
                "\"hóskandi\"",
                "\"ok\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"hóskandi\" knappur",
                "可",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton accepter en japonais"),
            keywords: &["accepter", "bouton accepter en japonais", "japonais"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}acceptable\u{a0}»"),
            keywords: &[
                "acceptable",
                "idéogramme",
                "japonais",
                "symbole japonais signifiant «\u{a0}acceptable\u{a0}»",
                "可",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"inghlactha\""),
            keywords: &[
                "Sínis",
                "cnaipe Seapáinise \"inghlactha\"",
                "cnáipe Seapáinis \"inghlactha\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Ceart gu leòr”"),
            keywords: &[
                "Seapanais",
                "ceart gu leòr",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Ceart gu leòr”",
                "可",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"aceptable\" en xaponés"),
            keywords: &[
                "aceptable",
                "botón \"aceptable\" en xaponés",
                "ideograma",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "\"સ\u{acd}વીક\u{ac3}તિ\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ગોળ બટન",
            ),
            keywords: &[
                "\"સ\u{acd}વીક\u{ac3}તિ\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ગોળ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“સ\u{acd}વીક\u{ac3}તિ”",
                "可",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"wanda ake yarda da\" Na Japan"),
            keywords: &[
                "\"wanda ake yarda da\"",
                "Na Japan",
                "maɓallin \"wanda ake yarda da\" Na Japan",
                "zanen harshe",
                "可",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״מותר״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״מותר״ ביפנית",
                "לחצן ״מותר״ ביפנית“",
                "可",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “स\u{94d}वीकार\u{94d}य” बटन"),
            keywords: &[
                "जापानी",
                "जापानी “स\u{94d}वीकार\u{94d}य” बटन",
                "“स\u{94d}वीकार\u{94d}य”",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"prihvatljivo\""),
            keywords: &[
                "japanski",
                "tipka s ideogramom \"prihvatljivo",
                "tipka s ideogramom \"prihvatljivo\"",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „elfogadás” gomb"),
            keywords: &[
                "japán",
                "japán „elfogadás” gomb",
                "képírásjel",
                "„elfogadás”",
                "可",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ընդունել գաղափարագիր շրջանակի մեջ"),
            keywords: &["ընդունել գաղափարագիր շրջանակի մեջ", "չինական", "չինարեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"dapat diterima\""),
            keywords: &[
                "\"dapat diterima\"",
                "Jepang",
                "ideograf",
                "tombol Jepang \"dapat diterima",
                "tombol Jepang \"dapat diterima\"",
                "可",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “anabatara”"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi Ndị Japan “anabatara”",
                "“anabatara”",
                "可",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Viðunandi“ á japönsku"),
            keywords: &[
                "japanska",
                "myndletur",
                "samþykkja",
                "„Viðunandi“ á japönsku",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Accettabile”"),
            keywords: &[
                "accettabile",
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Accettabile”",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("可マーク"),
            keywords: &["可", "可マーク", "可能", "許可"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"oleh\""),
            keywords: &["Jepang", "ideografi", "tombol Jepang \"oleh\"", "“oleh”"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მიღების იდეოგრამა წრეში"),
            keywords: &["მიღების იდეოგრამა წრეში", "ჩინური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("доңғалақтағы «қабылдау» иероглифі"),
            keywords: &["доңғалақтағы «қабылдау» иероглифі", "қытай"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("cirkulært ideogram for accept"),
            keywords: &["cirkulært ideogram for accept", "kinesisk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}មានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ទទ\u{17bd}ល",
            ),
            keywords: &[
                "ក\u{17d2}ន\u{17bb}ងរង\u{17d2}វង\u{17cb}មានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា ទទ\u{17bd}ល",
                "ទទ\u{17bd}ល",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "អក\u{17d2}សរច\u{17b7}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} “ಸಮ\u{ccd}ಮತ\u{cbf}ಸಬಹುದಾದ” ಬಟನ\u{ccd}"),
            keywords: &[
                "ಚೈನೀಸ\u{ccd} ಪದ",
                "ಜಪಾನೀಸ\u{ccd} “ಸಮ\u{ccd}ಮತ\u{cbf}ಸಬಹುದಾದ” ಬಟನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("옳을 가"),
            keywords: &["맞음", "옮음", "옳을 가", "허가"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “स\u{94d}विकार करपायोग\u{94d}य” बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “स\u{94d}विकार करपायोग\u{94d}य” बटण",
                "जपानी “स\u{94d}विकार योग\u{94d}य” बटण",
                "“स\u{94d}विकार योग\u{94d}य”",
                "可",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тегеректеги кабыл алуу идеограммасы"),
            keywords: &["кытайча", "тегеректеги кабыл алуу идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’acceptabel’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’acceptabel’",
                "’acceptabel’",
                "可",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຈ\u{eb5}ນຄຳວ\u{ec8}າ ຍອມຮ\u{eb1}ບ"),
            keywords: &["ພາສາຈ\u{eb5}ນ", "ພາສາຈ\u{eb5}ນຄຳວ\u{ec8}າ ຍອມຮ\u{eb1}ບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sutikimą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "sutikimas",
                "sutikimą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Piekrist apļveida ietvarā"),
            keywords: &["ideogramma Piekrist apļveida ietvarā", "ķīniešu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"ka whakaaetia\""),
            keywords: &[
                "\"ka whakaaetia\"",
                "Hapanīhi",
                "pātene Hapanīhi \"ka whakaaetia\"",
                "tohuwhakairo",
                "可",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „прифатливо“ на јапонски"),
            keywords: &["кинески", "копче „прифатливо“ на јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സ\u{d4d}വീക\u{d3e}ര\u{d4d}യമ\u{d3e}ണ\u{d4d}\" ബട\u{d4d}ടൺ",
            ),
            keywords: &[
                "\"സ\u{d4d}വീക\u{d3e}ര\u{d4d}യമ\u{d3e}ണ\u{d4d}\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"സ\u{d4d}വീക\u{d3e}ര\u{d4d}യമ\u{d3e}ണ\u{d4d}\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"зөвшөөрөх\" гэсэн товчлуур"),
            keywords: &[
                "\"зөвшөөрөх\"",
                "Японоор \"зөвшөөрөх\" гэсэн товчлуур",
                "Японы \"зөвшөөрөх\" гэсэн товчлуур",
                "дүрс үсэг",
                "可",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर\u{94d}त\u{941}ळाकार स\u{94d}वीकार करा स\u{902}क\u{947}त"),
            keywords: &[
                "\"स\u{94d}वीकारार\u{94d}ह\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "जपानी",
                "जपानी \"स\u{94d}वीकारार\u{94d}ह\" बटण",
                "जपानी शब\u{94d}द",
                "वर\u{94d}त\u{941}ळाकार स\u{94d}वीकार करा स\u{902}क\u{947}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “boleh diterima” Jepun"),
            keywords: &[
                "Jepun",
                "butang “boleh diterima” Jepun",
                "ideograf",
                "“boleh diterima”",
                "可",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “aċċettabbli”"),
            keywords: &[
                "buttuna Ġappuniż “aċċettabbli”",
                "ideograff",
                "Ġappuniż",
                "“aċċettabbli”",
                "有",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဂျပန\u{103a}ဘာသာ လက\u{103a}ခ\u{1036}န\u{102d}\u{102f}င\u{103a}သည\u{103a} ခလ\u{102f}တ\u{103a}",
            ),
            keywords: &[
                "ဂျပန\u{103a}ဘာသာ လက\u{103a}ခ\u{1036}န\u{102d}\u{102f}င\u{103a}သည\u{103a} ခလ\u{102f}တ\u{103a}",
                "တရ\u{102f}တ\u{103a} ဘာသာစကား",
                "ဝ\u{102d}\u{102f}င\u{103a}းထားသည\u{1037}\u{103a} လက\u{103a}ခ\u{1036}မ\u{103e}\u{102f} အရ\u{102f}ပ\u{103a}စာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("«akseptabelt» på japansk"),
            keywords: &[
                "akseptabelt",
                "ideograf",
                "japansk",
                "«akseptabelt» på japansk",
                "可",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गोलो स\u{94d}वीकार\u{947}को आइडियोग\u{94d}राफ"),
            keywords: &[
                "गोलो स\u{94d}वीकार\u{947}को आइडियोग\u{94d}राफ",
                "चिनिया\u{901}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Japans teken voor ‘acceptabel’"),
            keywords: &[
                "Japans",
                "Japans teken voor ‘acceptabel’",
                "ideogram",
                "‘acceptabel’",
                "可",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("«akseptabelt» på japansk"),
            keywords: &[
                "akseptabelt",
                "ideograf",
                "japansk",
                "«akseptabelt» på japansk",
                "可",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3e}ପ\u{b3e}ନୀ “ଗ\u{b4d}ରହଣୀୟ” ବଟନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଜ\u{b3e}ପ\u{b3e}ନୀ",
                "ଜ\u{b3e}ପ\u{b3e}ନୀ “ଗ\u{b4d}ରହଣୀୟ” ବଟନ\u{b4d}\u{200c}",
                "ସଙ\u{b4d}କେତ",
                "“ଗ\u{b4d}ରହଣୀୟ”",
                "可",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("\"ਮ\u{a70}ਨਣਯ\u{a4b}ਗ\" ਬਟਨ"),
            keywords: &["\"ਮ\u{a70}ਨਣਯ\u{a4b}ਗ\" ਬਟਨ", "ਚੀਨੀ ਸ\u{a3c}ਬਦ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جاپانی “قابل\u{650} قبول” دا بٹن"),
            keywords: &[
                "تص\u{651}ور نگاری",
                "جاپانی",
                "جاپانی “قابل\u{650} قبول” دا بٹن",
                "“قابل\u{650} قبول”",
                "可",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Japán Bọ\u{301}tin Fọ “Asẹpt”"),
            keywords: &[
                "Japán Bọ\u{301}tin Fọ “Asẹpt”",
                "Japán Pípol",
                "Japán Raítin",
                "“Asẹpt”",
                "可",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("japoński przycisk „dozwolone”"),
            keywords: &[
                "akceptacja",
                "chiński",
                "ideogram",
                "japoński przycisk „dozwolone”",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جاپاني \"منلو وړ\"بټن"),
            keywords: &[
                "\"منلو وړ\"",
                "آيډوګراف",
                "جاپاني",
                "جاپاني \"منلو وړ\"بټن",
                "可",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("botão japonês de “aceitável”"),
            keywords: &[
                "botão japonês de “aceitável”",
                "ideograma",
                "japonês",
                "“aceitável”",
                "可",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("botão \"aceitável\" em japonês"),
            keywords: &["botão \"aceitável\" em japonês", "ideograma", "japonês"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("buton cu semnificația „acceptabil” în japoneză"),
            keywords: &[
                "buton cu semnificația „acceptabil” în japoneză",
                "ideogramă",
                "japoneză",
                "„acceptabil”",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-198"),
            keywords: &["E10-198"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("допустимость"),
            keywords: &[
                "допустимо",
                "допустимость",
                "значок",
                "кнопка",
                "можно",
                "приемлемо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("buto ya ’acceptable’ mu kiyapani"),
            keywords: &[
                "\"cyemewe\"",
                "Nyapani",
                "buto ya ’acceptable’ mu kiyapani",
                "imyandikire",
                "可",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جاپاني ‘قابل\u{650} قبول’ بٽڻ"),
            keywords: &[
                "آئڊيوگراف",
                "جاپاني",
                "جاپاني ‘قابل\u{650} قبول’ بٽڻ",
                "“قابل قبول”",
                "禁",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හතරැස\u{dca} ප\u{dd2}ළ\u{dd2}ගැන\u{dd3}ම\u{dca} සංකල\u{dca}ප ලක\u{dd4}ණ"),
            keywords: &[
                "ච\u{dd3}න",
                "හතරැස\u{dca} ප\u{dd2}ළ\u{dd2}ගැන\u{dd3}ම\u{dca} සංකල\u{dca}ප ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("japonský ideograf Prijateľné"),
            keywords: &["japonský ideograf Prijateľné", "japončina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gumb za »sprejemljivo« v japonščini"),
            keywords: &[
                "gumb za »sprejemljivo« v japonščini",
                "ideogram",
                "japonsko",
                "pojmovni znak",
                "sprejemljivo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("badhanka ‘‘la aqbali karo’‘ ee Jabbaanka"),
            keywords: &[
                "Jabbaanka",
                "badhanka ‘‘la aqbali karo’‘ ee Jabbaanka",
                "fikir-garafeed",
                "‘‘la aqbali karo’‘",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("butoni «miratuar» në japonisht"),
            keywords: &[
                "butoni «miratuar» në japonisht",
                "ideograf",
                "japonisht",
                "«miratuar»",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("идеограф „прихватити“ у кругу"),
            keywords: &[
                "идеограф",
                "идеограф „прихватити“ у кругу",
                "јапански",
                "јапанско дугме „прихватљиво“",
                "„прихватљиво“",
                "可",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["идеограф „прихватити“ у кругу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ideograf „prihvatiti“ u krugu"),
            keywords: &[
                "ideograf",
                "ideograf „prihvatiti“ u krugu",
                "japanski",
                "japansko dugme „prihvatljivo“",
                "„prihvatljivo“",
                "可",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ideograf „prihvatiti“ u krugu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("japansk ”godtagbart”-knapp"),
            keywords: &[
                "godtagbart",
                "ideogram",
                "ideogram för godkänna",
                "japansk",
                "japansk ”godtagbart”-knapp",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("idiografu ya kukubali kwenye mduara"),
            keywords: &["idiografu ya kukubali kwenye mduara", "kichina"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"ஏற\u{bcd}கத\u{bcd}தக\u{bcd}கது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ),
            keywords: &[
                "ச\u{bc0}ன மொழி",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"ஏற\u{bcd}கத\u{bcd}தக\u{bcd}கது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
                "ஜப\u{bcd}ப\u{bbe}ன\u{bcd} மொழியில\u{bcd} \"ஏற\u{bcd}றுத\u{bcd}தக\u{bcd}கது\" என\u{bcd}று கூறும\u{bcd} பொத\u{bcd}த\u{bbe}ன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఆమ\u{c4b}దయ\u{c4b}గ\u{c4d}యమ\u{c48}నద\u{c3f}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ),
            keywords: &[
                "ఆకృత\u{c3f}ల\u{c3f}ప\u{c3f} అక\u{c4d}షరం",
                "చ\u{c48}న\u{c3e}",
                "చ\u{c48}న\u{c40}స\u{c4d} పదం",
                "చ\u{c48}న\u{c40}స\u{c4d} భ\u{c3e}ష",
                "జపన\u{c40}స\u{c4d}\u{200c}ల\u{c4b} \"ఆమ\u{c4b}దయ\u{c4b}గ\u{c4d}యమ\u{c48}నద\u{c3f}\" సూచ\u{c3f}ంచ\u{c47} బటన\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тугмаи \"Қобили қабул\"-и ҷопонӣ"),
            keywords: &[
                "\"қобили қабул\"",
                "идеограмма",
                "тугмаи \"Қобили қабул\"-и ҷопонӣ",
                "ҷопонӣ",
                "可",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ยอมร\u{e31}บได\u{e49}”"),
            keywords: &[
                "ต\u{e31}วอ\u{e31}กษรจ\u{e35}น",
                "ภาษาจ\u{e35}นยอมร\u{e31}บ",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}น",
                "ภาษาญ\u{e35}\u{e48}ป\u{e38}\u{e48}นคำว\u{e48}า “ยอมร\u{e31}บได\u{e49}”",
                "“ยอมร\u{e31}บได\u{e49}”",
            ],
        },
        #[cfg(feature = "ti")]
        crate::Annotation {
            lang: "ti",
            tts: Some("ናይ ጃፓን “ቅቡል” መልጎም"),
            keywords: &["ናይ ጃፓን", "ናይ ጃፓን “ቅቡል” መልጎም", "ኣይድዮግራፍ", "“ቅቡል”", "可"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaponça \"kabul ederlik\" düwmesi"),
            keywords: &[
                "ideograf",
                "ýaponça",
                "ýaponça \"kabul ederlik\" düwmesi",
                "“kabul ederlik”",
                "可",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("meʻalolomi «ala tali» (fakasiapani)"),
            keywords: &[
                "ala tali",
                "fakasiapani",
                "meʻalolomi",
                "meʻalolomi «ala tali» (fakasiapani)",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Japonca \"kabul edilebilir\" düğmesi"),
            keywords: &["Japonca", "Japonca \"kabul edilebilir\" düğmesi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياپونچە «لاياقەتلىك» دېگەن كونۇپكا"),
            keywords: &[
                "«لاياقەتلىك»",
                "مەنىلىك يېزىق",
                "ياپونچە",
                "ياپونچە «لاياقەتلىك» دېگەن كونۇپكا",
                "可",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кнопка \"прийнятно\" японською"),
            keywords: &["китайський", "кнопка \"прийнятно\" японською"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جاپانی \"قابل قبول\" بٹن"),
            keywords: &[
                "تصویری علامت",
                "جاپانی \"قابل قبول\" بٹن",
                "منظوری",
                "چینی",
                "گول",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aylana ichidagi qabul qilish iyeroglifi"),
            keywords: &["aylana ichidagi qabul qilish iyeroglifi", "xitoycha"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nút Tiếng Nhật “có thể chấp nhận”"),
            keywords: &[
                "Tiếng Nhật",
                "chữ tượng hình",
                "nút Tiếng Nhật “có thể chấp nhận”",
                "“có thể chấp nhận”",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bitoŋu \"terewu ñu ko\" bu sapoŋ"),
            keywords: &[
                "\"mën nañu ko nangu\"",
                "Sapone",
                "bitoŋu \"terewu ñu ko\" bu sapoŋ",
                "ideograf",
                "可",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhosha elithi \"yamkelekile\" lesiJapan"),
            keywords: &[
                "\"yamkelekile\"",
                "IsiJapan",
                "i-ideograph",
                "iqhosha elithi \"yamkelekile\" lesiJapan",
                "可",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọtini \"itẹwọgba\" Japanisi"),
            keywords: &[
                "\"ìté\u{329}wó\u{329}gbà\"",
                "Bọtini \"itẹwọgba\" Japanisi",
                "Japanese",
                "àmì ajẹmáwòrán",
                "可",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("日本「可」按鈕"),
            keywords: &["可", "接受", "日本", "日本「可」按鈕"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("日本“可”按钮"),
            keywords: &["可", "接受", "日本", "日本“可”按钮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("日文的“可接受”按钮"),
            keywords: &["按键", "日文", "日文的“可接受”按钮", "许可"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("可"),
            keywords: &["可"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("日文嘅「許可」按鈕"),
            keywords: &["日文嘅「許可」按鈕", "許可"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indingilizi ezungeziwe yokwamukela"),
            keywords: &["indingilizi ezungeziwe yokwamukela", "ukwamukela"],
        },
    ],
};
#[doc = "🈸"]
pub const JAPANESE__APPLICATION__BUTTON: crate::Emoji = crate::Emoji {
    glyph: "🈸",
    codepoint: "1F238",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Japanese “application” button",
    group: "Symbols",
    subgroup: "alphanum",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Japannese \"aansoek\"-knoppie"),
            keywords: &[
                "\"aansoek\"",
                "Japannees",
                "Japannese \"aansoek\"-knoppie",
                "ideogram",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተግብር ካሬ አይዶግራፍ"),
            keywords: &["የተግብር ካሬ አይዶግራፍ", "የቻይና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("الزر /تطبيق/ باليابانية"),
            keywords: &["الزر /تطبيق/ باليابانية", "صيني"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9be}প\u{9be}নী “এপ\u{9cd}লিকেশ\u{9cd}বন” ব\u{9c1}ট\u{9be}ম"),
            keywords: &[
                "আইডিয\u{9bc}’গ\u{9cd}ৰ\u{9be}ফ\u{9cd}",
                "জ\u{9be}প\u{9be}নী",
                "জ\u{9be}প\u{9be}নী “এপ\u{9cd}লিকেশ\u{9cd}বন” ব\u{9c1}ট\u{9be}ম",
                "“আবেদন”",
                "申",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kvadrat tətbiq ideoqramı"),
            keywords: &["kvadrat tətbiq ideoqramı", "çin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ідэаграма «заяўка» у квадраце"),
            keywords: &[
                "запыт",
                "заява",
                "кітайскае",
                "пісьмо",
                "ідэаграма «заяўка» у квадраце",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Идеограма „прилагам“ в квадрат"),
            keywords: &["Идеограма „прилагам“ в квадрат", "японски"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}গ\u{9be}ক\u{9be}র প\u{9cd}রযোজ\u{9cd}য চিত\u{9cd}রলিপি"),
            keywords: &[
                "চীন\u{9be}",
                "বর\u{9cd}গ\u{9be}ক\u{9be}র প\u{9cd}রযোজ\u{9cd}য চিত\u{9cd}রলিপি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Dugme \"prijava\" na jap."),
            keywords: &[
                "Dugme \"prijava\" na jap.",
                "Dugme sa tekstom \"prijava\" na japanskom",
                "japanski",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("botó japonès \"aplicació\""),
            keywords: &[
                "aplicar",
                "botó japonès \"aplicació\"",
                "ideograma",
                "japonès",
                "kanji",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏣᏩᏂᏏ “ᎠᎧᎵᏏᏐᏗ” ᎦᏗ"),
            keywords: &["ᎦᏅᏍᏙᏍᎬ", "ᏣᏩᏂᏏ", "ᏣᏩᏂᏏ “ᎠᎧᎵᏏᏐᏗ” ᎦᏗ", "“ᎠᎧᎵᏏᏐᏗ”", "申"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("štítek s japonským znakem „žádost”"),
            keywords: &[
                "dotazy",
                "ideogram",
                "japonština",
                "kontakt",
                "přihláška",
                "štítek s japonským znakem „žádost”",
                "申",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ideograff cais mewn sgwâr"),
            keywords: &["Tsieineaidd", "ideograff cais mewn sgwâr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvadratisk ideogram for anvendelse"),
            keywords: &["japansk", "kvadratisk ideogram for anvendelse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schriftzeichen für „anwenden“"),
            keywords: &[
                "Schriftzeichen für „anwenden“",
                "anwenden",
                "japanisches Schriftzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιδεόγραμμα εφαρμογής σε τετράγωνο"),
            keywords: &["ιαπωνικό", "ιδεόγραμμα εφαρμογής σε τετράγωνο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Japanese “application” button"),
            keywords: &[
                "Japanese",
                "Japanese “application” button",
                "ideograph",
                "“application”",
                "申",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ideograma japonés para \"aplicación\""),
            keywords: &[
                "aplicación",
                "ideograma",
                "ideograma japonés para \"aplicación\"",
                "japonés",
                "kanji",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jaapani nupp \"rakendus\""),
            keywords: &[
                "\"rakendus\"",
                "ideogramm",
                "jaapani keel",
                "jaapani nupp \"rakendus\"",
                "申",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("japonierazko \"eskaera\" botoia"),
            keywords: &[
                "inprimaki bat irudikatzen duen ideograma karratu batean",
                "japonierazko \"eskaera\" botoia",
                "txinera",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دکمۀ «تقاضانامه» به ژاپنی"),
            keywords: &[
                "«تقاضانامه»",
                "اندیشه\u{200c}نگاشت",
                "دکمه\u{654} «تقاضانامه» به ژاپنی",
                "دکمۀ «تقاضانامه» به ژاپنی",
                "ژاپنی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hakemus-kirjoitusmerkki"),
            keywords: &["hakemus-kirjoitusmerkki", "kiina", "kirjoitusmerkki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakaparisukat na ideograph ng pag-apply"),
            keywords: &[
                "Hapones",
                "ideograpya",
                "kahilingan",
                "nakaparisukat na ideograph ng pag-apply",
                "pindutan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("japanskur \"umsókn\" knappur"),
            keywords: &[
                "\"umsókn\"",
                "\"áheitan\"",
                "hugtaksskrift",
                "ideografi",
                "japanskur",
                "japanskur \"umsókn\" knappur",
                "申",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouton application en japonais"),
            keywords: &["application", "bouton application en japonais", "japonais"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("symbole japonais signifiant «\u{a0}application\u{a0}»"),
            keywords: &[
                "application",
                "idéogramme",
                "japonais",
                "symbole japonais signifiant «\u{a0}application\u{a0}»",
                "申",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnaipe Seapáinise \"iarratas\""),
            keywords: &[
                "Sínis",
                "cnaipe Seapáinise \"iarratas\"",
                "cnáipe Seapáinis \"iarratas\"",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("putan Seapanais “Tagradh”"),
            keywords: &[
                "Seapanais",
                "iapanais",
                "ideo-ghraf",
                "putan Seapanais “Tagradh”",
                "tagradh",
                "申",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("botón \"aplicación\" en xaponés"),
            keywords: &[
                "aplicación",
                "botón \"aplicación\" en xaponés",
                "ideograma",
                "xaponés",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "\"લાગ\u{ac1} કરો\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
            ),
            keywords: &[
                "\"લાગ\u{ac1} કરો\" માટ\u{ac7}ના જાપાનીઝ શબ\u{acd}દ સાથ\u{ac7}ન\u{ac1}\u{a82} ચોરસ બટન",
                "જાપાનીઝ",
                "ભાવચિત\u{acd}ર",
                "“લાગ\u{ac1} કરો”",
                "申",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("maɓallin \"buƙata\" Na Japan"),
            keywords: &[
                "\"buƙata\"",
                "Na Japan",
                "maɓallin \"buƙata\" Na Japan",
                "zanen harshe",
                "申",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחצן ״הגשת בקשה״ ביפנית"),
            keywords: &[
                "יפנית",
                "לוגו",
                "לחצן ״הגשת בקשה״ ביפנית",
                "לחצן ״הגשת בקשה״ ביפנית“",
                "申",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जापानी “ऐप\u{94d}लिक\u{947}शन” बटन"),
            keywords: &[
                "जापानी",
                "जापानी “ऐप\u{94d}लिक\u{947}शन” बटन",
                "“ऐप\u{94d}लिक\u{947}शन”",
                "申",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tipka s ideogramom \"zahtjev\""),
            keywords: &["japanski", "tipka s ideogramom \"zahtjev\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("japán „alkalmazás” gomb"),
            keywords: &[
                "japán",
                "japán „alkalmazás” gomb",
                "képírásjel",
                "„alkalmazás”",
                "申",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կիրառել գաղափարագիր"),
            keywords: &["կիրառել գաղափարագիր", "չինական", "չինարեն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tombol Jepang \"lamaran kerja\""),
            keywords: &[
                "china",
                "cina",
                "karakter terapkan dalam kotak",
                "tombol Jepang \"lamaran kerja\"",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ọdụmbi Ndị Japan “etinyere n’ọrụ”"),
            keywords: &[
                "Ndị Japan",
                "ideograph",
                "Ọdụmbi Ndị Japan “etinyere n’ọrụ”",
                "“etinyere n’ọrụ”",
                "申",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("„Umsókn“ á japönsku"),
            keywords: &["beiðni", "japanska", "myndletur", "„Umsókn“ á japönsku"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ideogramma giapponese di “Candidatura”"),
            keywords: &[
                "candidarsi",
                "giapponese",
                "ideogramma",
                "ideogramma giapponese di “Candidatura”",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("申マーク"),
            keywords: &["申", "申し込み", "申マーク", "申請"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tombol Jepang \"aplikasi\""),
            keywords: &[
                "\"aplikasi\"",
                "Jepang",
                "ideografi",
                "tombol Jepang \"aplikasi\"",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გამოყენების იდეოგრამა კვადრატში"),
            keywords: &["გამოყენების იდეოგრამა კვადრატში", "ჩინური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шаршыдағы «қолдану» иероглифі"),
            keywords: &["шаршыдағы «қолдану» иероглифі", "қытай"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvadratisk ideogram for anvendelse"),
            keywords: &["kinesisk", "kvadratisk ideogram for anvendelse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា អន\u{17bb}វត\u{17d2}តឬដាក\u{17cb}ពាក\u{17d2}យ",
            ),
            keywords: &[
                "ដាក\u{17cb}ពាក\u{17d2}យ",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ង",
                "ប\u{17ca}\u{17bc}ត\u{17bb}ងមានអក\u{17d2}សរច\u{17b7}នប\u{17d2}រែថា អន\u{17bb}វត\u{17d2}តឬដាក\u{17cb}ពាក\u{17d2}យ",
                "អក\u{17d2}សរច\u{17b7}ន",
                "អន\u{17bb}វត\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜಪಾನೀಸ\u{ccd} “ಅಪ\u{ccd}ಲ\u{cbf}ಕೇಶನ\u{ccd}” ಬಟನ\u{ccd}"),
            keywords: &[
                "ಚೈನೀಸ\u{ccd} ಪದ",
                "ಜಪಾನೀಸ\u{ccd} “ಅಪ\u{ccd}ಲ\u{cbf}ಕೇಶನ\u{ccd}” ಬಟನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거듭 신"),
            keywords: &["거듭 신"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जपानी “अर\u{94d}ज” बटण"),
            keywords: &[
                "आयडिओग\u{94d}राफ",
                "जपानी",
                "जपानी “अर\u{94d}ज” बटण",
                "“अर\u{94d}ज”",
                "申",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчыдагы колдонуу идеограммасы"),
            keywords: &["кытайча", "чарчыдагы колдонуу идеограммасы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("japanesche Knäppchen ’Applikatioun’"),
            keywords: &[
                "Ideograf",
                "japanesch",
                "japanesche Knäppchen ’Applikatioun’",
                "’Applikatioun’",
                "申",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພາສາຈ\u{eb5}ນຄຳວ\u{ec8}າ ໃຊ\u{ec9}"),
            keywords: &["ພາສາຈ\u{eb5}ນ", "ພາສາຈ\u{eb5}ນຄຳວ\u{ec8}າ ໃຊ\u{ec9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("taikymą reiškiantis hieroglifas"),
            keywords: &[
                "hieroglifas",
                "japonų",
                "taikymas",
                "taikymą reiškiantis hieroglifas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ideogramma Pieprasīt kvadrātveida ietvarā"),
            keywords: &["ideogramma Pieprasīt kvadrātveida ietvarā", "ķīniešu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pātene Hapanīhi \"taupānga\""),
            keywords: &[
                "\"taupānga\"",
                "Hapanīhi",
                "pātene Hapanīhi \"taupānga\"",
                "tohuwhakairo",
                "申",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("копче „апликација“ на јапонски"),
            keywords: &["кинески", "копче „апликација“ на јапонски"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"അപേക\u{d4d}ഷ\" ബട\u{d4d}ടൺ"),
            keywords: &[
                "\"അപേക\u{d4d}ഷ\"",
                "ആശയലിപി",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d}",
                "ജ\u{d3e}പ\u{d4d}പനീസ\u{d4d} \"അപേക\u{d4d}ഷ\" ബട\u{d4d}ടൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Японоор \"хүсэлт гаргах\" гэсэн товчлуур"),
            keywords: &[
                "\"хүсэлт гаргах\"",
                "Японоор \"хүсэлт гаргах\" гэсэн товчлуур",
                "дүрс үсэг",
                "申",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चौरस लाग\u{942} करा स\u{902}क\u{947}त"),
            keywords: &[
                "\"अ\u{945}प\u{94d}लिक\u{947}शन\"",
                "कल\u{94d}पनाचित\u{94d}र",
                "चौरस लाग\u{942} करा स\u{902}क\u{947}त",
                "जपानी",
                "जपानी \"अ\u{945}प\u{94d}लिक\u{947}शन\" बटण",
                "जपानी शब\u{94d}द",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("butang “aplikasi” Jepun"),
            keywords: &[
                "Jepun",
                "butang “aplikasi” Jepun",
                "ideograf",
                "“aplikasi”",
                "申",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("buttuna Ġappuniż “applikazzjoni”"),
            keywords: &[
                "buttuna Ġappuniż “applikazzjoni”",
                "ideograff",
                "Ġappuniż",
                "“applikazzjoni”",
                "有",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဂျပန\u{10