#[doc = "😷"]
pub const FACE_WITH_MEDICAL_MASK: crate::Emoji = crate::Emoji {
    glyph: "😷",
    codepoint: "1F637",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "face with medical mask",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met mediese masker"),
            keywords: &[
                "dokter",
                "gesig",
                "gesig met mediese masker",
                "koud",
                "masker",
                "medisyne",
                "siek",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሕክምና ጭንብል ያደረገ ፊት"),
            keywords: &["ቀዝቃዛ", "የሕክምና ጭንብል ያደረገ ፊት", "የታመመ", "ዶክተር", "ጭንብል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بكمامة"),
            keywords: &[
                "برد",
                "كمامة",
                "كمامة طبية",
                "متوعك صحي\u{64b}ا",
                "وجه بكمامة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিকিৎস\u{9be} ম\u{9c1}খ\u{9be} পৰিহিত ম\u{9c1}খ"),
            keywords: &[
                "অস\u{9c1}স\u{9cd}থ",
                "ঔষধ",
                "চিকিৎসক",
                "চিকিৎস\u{9be} ম\u{9c1}খ\u{9be} পৰিহিত ম\u{9c1}খ",
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "ম\u{9c1}খ",
                "ম\u{9c1}খ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tibbi maskalı üz"),
            keywords: &[
                "həkim",
                "maska",
                "naxoş",
                "soyuq",
                "tibb",
                "tibbi maskalı üz",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар у медыцынскай масцы"),
            keywords: &[
                "доктар",
                "маска",
                "медыцына",
                "твар у медыцынскай масцы",
                "хворы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с медицинска маска"),
            keywords: &["Лице с медицинска маска", "болен", "лекар", "лице", "маска"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খের মধ\u{9cd}যে মেডিক\u{9cd}য\u{9be}ল ম\u{9be}স\u{9cd}ক"),
            keywords: &[
                "অস\u{9c1}স\u{9cd}থ",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be} ল\u{9be}গ\u{9be}",
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের মধ\u{9cd}যে মেডিক\u{9cd}য\u{9be}ল ম\u{9be}স\u{9cd}ক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nosi medicinsku masku"),
            keywords: &["bolest", "doktor", "maska", "nosi medicinsku masku"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb mascareta"),
            keywords: &[
                "cara",
                "cara amb mascareta",
                "cara amb màscara",
                "malaltia",
                "mascareta",
                "màscara",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎦᏃᏢᎩᏅᏬᏘ ᎠᎵᎬᏚᎶᏗ"),
            keywords: &[
                "ᎠᎦᎾᎦᏘ",
                "ᎠᎵᎬᏚᎶᏗ",
                "ᎤᎧᏛ",
                "ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎦᏃᏢᎩᏅᏬᏘ ᎠᎵᎬᏚᎶᏗ",
                "ᎤᏢᎦ",
                "ᎤᏴᏜ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s lékařskou rouškou"),
            keywords: &[
                "doktor",
                "lék",
                "lékař",
                "maska",
                "nachlazený",
                "nemocný",
                "obličej s lékařskou rouškou",
                "smajlík",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â mwgwd meddygol"),
            keywords: &["annwyd", "doctor", "masg", "sâl", "wyneb â mwgwd meddygol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med mundbind"),
            keywords: &[
                "ansigt med mundbind",
                "doktor",
                "forkølet",
                "læge",
                "maske",
                "mundbind",
                "syg",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Atemschutzmaske"),
            keywords: &[
                "Arzt",
                "Gesicht",
                "Gesicht mit Atemschutzmaske",
                "Krankheit",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ιατρική μάσκα"),
            keywords: &[
                "άρρωστος",
                "γιατρός",
                "ιατρική μάσκα",
                "κρύωμα",
                "μάσκα",
                "πρόσωπο",
                "φάρμακο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with medical mask"),
            keywords: &[
                "cold",
                "doctor",
                "face",
                "face with medical mask",
                "mask",
                "sick",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "cold",
                "doctor",
                "face",
                "face with medical mask",
                "ill",
                "mask",
                "medicine",
                "poorly",
                "sick",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cold",
                "doctor",
                "face",
                "face with medical mask",
                "ill",
                "mask",
                "sick",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con mascarilla médica"),
            keywords: &[
                "cara",
                "cara con mascarilla médica",
                "enfermo",
                "malo",
                "máscara",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara con barbijo"),
            keywords: &["barbijo", "cara", "cara con barbijo", "enfermo", "resfrío"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara con mascarilla médica"),
            keywords: &[
                "barbijo",
                "cara",
                "cara con mascarilla médica",
                "cubrebocas",
                "enfermo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara con mascarilla médica"),
            keywords: &[
                "cara",
                "cara con mascarilla médica",
                "doctor",
                "enfermo",
                "mascarilla",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirurgimaskiga kaetud nägu"),
            keywords: &[
                "arst",
                "haige",
                "kirurgimaskiga kaetud nägu",
                "külm",
                "mask",
                "nägu",
                "ravim",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mediku-maskara daraman aurpegia"),
            keywords: &[
                "aurpegi",
                "gaixo",
                "hotzeri",
                "maskara",
                "mediku-maskara daraman aurpegia",
                "medikuntza",
                "sendagile",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت با ماسک پزشکی"),
            keywords: &[
                "بیمار",
                "دکتر",
                "سرد",
                "سرماخورده",
                "صورت با ماسک پزشکی",
                "ماسک",
                "مریض",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama ja hengityssuoja"),
            keywords: &[
                "flunssa",
                "lääke",
                "lääkäri",
                "naama",
                "naama ja hengityssuoja",
                "sairas",
                "suoja",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("may suot na medical mask"),
            keywords: &[
                "doktor",
                "mask",
                "may suot na medical mask",
                "mukha",
                "sakit",
                "sipon",
                "ubo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við masku"),
            keywords: &["andlit", "andlit við masku", "maska", "sjúk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec masque"),
            keywords: &["masque", "visage avec masque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "docteur",
                "froid",
                "malade",
                "masque",
                "médical",
                "visage",
                "visage avec masque",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le masc leighis"),
            keywords: &[
                "aghaidh agus masc uirthi",
                "masc",
                "masc máinliachta",
                "straoiseog le masc leighis",
                "tinn",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le masg dotair air"),
            keywords: &[
                "aodann",
                "aodann le masg dotair air",
                "bochd",
                "dotair",
                "fuar",
                "leigheas",
                "lighiche",
                "masg",
                "tinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara con máscara médica"),
            keywords: &[
                "cara",
                "cara con máscara médica",
                "enferma",
                "enfermo",
                "máscara",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માસ\u{acd}કવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ઠ\u{a82}ડો",
                "તબીબી માસ\u{acd}ક",
                "માસ\u{acd}ક",
                "માસ\u{acd}કવાળો ચહ\u{ac7}રો",
                "હવામાન હ\u{ac7}ઠળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai abin rufen fuska na aikin kula da lafiya"),
            keywords: &[
                "abin rufen fuska",
                "fuska",
                "fuska mai abin rufen fuska na aikin kula da lafiya",
                "likita",
                "magani",
                "maras lafiya",
                "sanyi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם מסיכת מנתח"),
            keywords: &[
                "זיהום אוויר",
                "חולה",
                "מנתח",
                "מסיכה",
                "עשן",
                "פרצוף",
                "פרצוף עם מסיכת מנתח",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चिकित\u{94d}सा मास\u{94d}क वाला च\u{947}हरा"),
            keywords: &[
                "चिकित\u{94d}सा मास\u{94d}क",
                "चिकित\u{94d}सा मास\u{94d}क वाला च\u{947}हरा",
                "च\u{947}हरा",
                "ठ\u{902}ड",
                "नकाब",
                "मास\u{94d}क वाला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s medicinskom maskom"),
            keywords: &[
                "bolest",
                "doktor",
                "lice",
                "lice s medicinskom maskom",
                "maska",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc egészségügyi maszkkal"),
            keywords: &[
                "arc",
                "arc egészségügyi maszkkal",
                "betegség",
                "egészségügyi maszk",
                "gyógyszer",
                "orvos",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բժշկական դիմակով դեմք"),
            keywords: &[
                "բժիշկ",
                "բժշկական դիմակ",
                "բժշկական դիմակով դեմք",
                "հիվանդ",
                "վարակ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bermasker"),
            keywords: &[
                "dokter",
                "flu",
                "masker",
                "sakit",
                "wajah",
                "wajah bermasker",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere mkpuchi ihu ngwaọrụ ụlọ ọgwụ"),
            keywords: &[
                "dọkịta",
                "ihu",
                "ihu nwere mkpuchi ihu ngwaọrụ ụlọ ọgwụ",
                "mkpuchi",
                "onye ọrịa",
                "oyi",
                "ọgwụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með grímu"),
            keywords: &[
                "andlit",
                "andlit með grímu",
                "andlit með læknagrímu",
                "gríma",
                "kalt",
                "veikindi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con mascherina"),
            keywords: &[
                "faccina",
                "faccina con mascherina",
                "maschera",
                "mascherina",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マスク顔"),
            keywords: &["マスク顔", "病気", "花粉症", "顔", "風邪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai nganggo masker dhokter"),
            keywords: &[
                "dhokter",
                "masker",
                "mriang",
                "rai",
                "rai nganggo masker dhokter",
                "watuk",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე სამედიცინო ნიღბით"),
            keywords: &[
                "ავადმყოფი",
                "გაციებული",
                "ექიმი",
                "მედიცინა",
                "ნიღაბი",
                "სახე",
                "სახე სამედიცინო ნიღბით",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem s tgelmust"),
            keywords: &["udem s tgelmust"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ауырып қалу"),
            keywords: &[
                "ауру",
                "ауырып қалу",
                "бет",
                "дәрігер",
                "маска",
                "медициналық маскасы бар бет",
                "суық",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med maske"),
            keywords: &[
                "ansigt",
                "ansigt med maske",
                "doktor",
                "forkølelse",
                "maske",
                "medicin",
                "syg",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខពាក\u{17cb}ម\u{17c9}ាសគ\u{17d2}រ\u{17bc}ពេទ\u{17d2}យ"),
            keywords: &[
                "ពាក\u{17cb}ម\u{17c9}ាស",
                "ម\u{17bb}ខពាក\u{17cb}ម\u{17c9}ាសគ\u{17d2}រ\u{17bc}ពេទ\u{17d2}យ",
                "ម\u{17c9}ាស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವೈದ\u{ccd}ಯಕೀಯ ಮುಖವಾಡದ ಮುಖ"),
            keywords: &[
                "ಮುಖವಾಡದೊಂದ\u{cbf}ಗ\u{cbf}ನ ಮುಖ",
                "ವೈದ\u{ccd}ಯಕೀಯ ಮುಖವಾಡ",
                "ವೈದ\u{ccd}ಯಕೀಯ ಮುಖವಾಡದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마스크 낀 얼굴"),
            keywords: &["감기", "마스크", "마스크 낀 얼굴", "얼굴", "황사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{948}द\u{94d}यकीय मास\u{94d}क घाल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "थ\u{902}ड",
                "द\u{941}य\u{947}\u{902}त",
                "दोतोर",
                "मास\u{94d}क",
                "व\u{948}द\u{94d}यकीय मास\u{94d}क घाल\u{94d}लो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("медициналык беткапчан бет"),
            keywords: &[
                "беткап",
                "дарыгер",
                "медициналык беткапчан бет",
                "оору",
                "суук",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat Doktersmask"),
            keywords: &[
                "Dokter",
                "Gesiicht",
                "Gesiicht mat Doktersmask",
                "Mask",
                "Medezin",
                "kal",
                "krank",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າໃສ\u{ec8}ຜ\u{ec9}າອ\u{eb1}ດປາກ"),
            keywords: &[
                "ທ\u{ec8}ານໝ\u{ecd}",
                "ຜ\u{ec9}າອ\u{eb1}ດປາກ",
                "ແພດ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າໃສ\u{ec8}ຜ\u{ec9}າອ\u{eb1}ດປາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su medicinine kauke"),
            keywords: &[
                "gydytojas",
                "kaukė",
                "medicina",
                "sergantis",
                "veidas",
                "veidas su medicinine kauke",
                "šaltis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar medicīnas masku"),
            keywords: &[
                "maska",
                "medicīna",
                "seja",
                "seja ar medicīnas masku",
                "slims",
                "ārsts",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi mau ārai rongoā"),
            keywords: &[
                "kanohi",
                "kanohi mau ārai rongoā",
                "mate",
                "mātao",
                "rata",
                "rongoā",
                "ārai",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со медицинска маска"),
            keywords: &[
                "болен",
                "лекар",
                "лице со медицинска маска",
                "маска",
                "настинка",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെഡിക\u{d4d}കൽ മ\u{d3e}സ\u{d4d}\u{200c}ക\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "അസ\u{d41}ഖം",
                "ജലദോഷം",
                "ഡോക\u{d4d}\u{200c}ടർ",
                "മ\u{d3e}സ\u{d4d}\u{200c}ക\u{d4d}",
                "മ\u{d41}ഖം",
                "മെഡിക\u{d4d}കൽ മ\u{d3e}സ\u{d4d}\u{200c}ക\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("маск зүүсэн царай"),
            keywords: &["зүүсэн", "маск", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}डिकल मास\u{94d}कसह च\u{947}हरा"),
            keywords: &[
                "आजारी",
                "औषध",
                "च\u{947}हरा",
                "डॉक\u{94d}टर",
                "थ\u{902}ड",
                "मास\u{94d}क",
                "म\u{947}डिकल मास\u{94d}कसह च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka memakai topeng perubatan"),
            keywords: &[
                "doktor",
                "muka",
                "muka memakai topeng perubatan",
                "perubatan",
                "sakit",
                "sejuk",
                "topeng",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ bil-maskra medika"),
            keywords: &[
                "kiesaħ",
                "maskra",
                "mediċina",
                "morda",
                "tabib",
                "wiċċ",
                "wiċċ bil-maskra medika",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ကျန\u{103a}းမာရေး မျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ကျန\u{103a}းမာရေး မျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဆရာဝန\u{103a}",
                "ဆေးရ\u{102f}\u{1036}သ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}းတပ\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဖျားနာခြင\u{103a}း",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာဖ\u{102f}\u{1036}း",
                "အအေးမ\u{102d}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes med munnbind"),
            keywords: &["bakteriemaske", "fjes", "fjes med munnbind", "sykdom"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिकित\u{94d}सा मास\u{94d}क लगाएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "औषधि",
                "चिकित\u{94d}सा मास\u{94d}क लगाएको अन\u{941}हार",
                "चिसो",
                "डाक\u{94d}टर",
                "बिमारी",
                "मास\u{94d}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met doktersmasker"),
            keywords: &[
                "dokter",
                "gezicht",
                "gezicht met doktersmasker",
                "koud",
                "masker",
                "medicijn",
                "ziek",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes med munnbind"),
            keywords: &["bakteriemaske", "fjes", "fjes med munnbind", "sjukdom"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଡ\u{b3e}କ\u{b4d}ତରୀ ମ\u{b41}ଖ\u{b3e} ପ\u{b3f}ନ\u{b4d}ଧ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "କ\u{b4d}ଲ\u{b3e}ନ\u{b4d}ତ",
                "ଡ\u{b3e}କ\u{b4d}ତର",
                "ଡ\u{b3e}କ\u{b4d}ତରୀ ମ\u{b41}ଖ\u{b3e} ପ\u{b3f}ନ\u{b4d}ଧ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ମ\u{b41}ଖ\u{b3e}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a48}ਡੀਕਲ ਨਕਾਬ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਠ\u{a70}ਡਾ",
                "ਨਕਾਬ ਨਾਲ ਚਿਹਰਾ",
                "ਮ\u{a48}ਡੀਕਲ ਨਕਾਬ",
                "ਮ\u{a48}ਡੀਕਲ ਨਕਾਬ ਵਾਲਾ ਚਿਹਰਾ",
                "ਮ\u{a4c}ਸਮ ਅਧੀਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("طبی ماسک نال شکل"),
            keywords: &[
                "دوائی",
                "دی شکل",
                "طبی ماسک نال شکل",
                "طبیب",
                "علیل",
                "ماسک",
                "ٹھنڈا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Wía Mẹ\u{301}díkál Mask"),
            keywords: &[
                "Dọ\u{301}ktọ",
                "Fes Wé Wía Mẹ\u{301}díkál Mask",
                "Kold",
                "Mask",
                "Sik",
                "Síknẹs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz w masce medycznej"),
            keywords: &[
                "choroba",
                "lekarz",
                "maska",
                "operacja",
                "pielęgniarka",
                "twarz",
                "twarz w masce medycznej",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره د طبي ماسک مخ"),
            keywords: &["سره د طبي ماسک مخ", "سوړ", "مخ", "ناروغه", "ډاکټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com máscara médica"),
            keywords: &[
                "doente",
                "gripado",
                "máscara",
                "máscara médica",
                "resfriado",
                "rosto",
                "rosto com máscara médica",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com máscara de médico"),
            keywords: &[
                "cara",
                "cara com máscara de médico",
                "constipação",
                "doente",
                "máscara",
                "médico",
                "remédio",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya barbijowan"),
            keywords: &[
                "barbijo",
                "chiri",
                "hampiq",
                "unqusqa",
                "uya",
                "uya barbijiwan",
                "uya barbijowan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu mască medicală"),
            keywords: &[
                "bolnav",
                "doctor",
                "față",
                "față cu mască medicală",
                "mască",
                "răceală",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-891"),
            keywords: &["E10-891"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в медицинской маске"),
            keywords: &[
                "больной",
                "в медицинской маске",
                "врач",
                "защита",
                "лицо",
                "маска",
                "медик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yambaye masike yo kwa muganga"),
            keywords: &[
                "dogiteri",
                "gikonje",
                "imiti",
                "impishasura",
                "isura",
                "isura yambaye masike yo kwa muganga",
                "urwaye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميڊيڪل ماسڪ سان گڏ چهرو"),
            keywords: &[
                "بيمار",
                "دوا",
                "ميڊيڪل ماسڪ سان گڏ چهرو",
                "نقاب",
                "ٿڌو",
                "چهرو",
                "ڊاڪٽر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}කව\u{dcf}ඩමක\u{dca} සහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}කව\u{dcf}ඩම",
                "ම\u{dd4}කව\u{dcf}ඩමක\u{dca} සහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "රෝග\u{dd3}",
                "වෛද\u{dca}\u{200d}යවරය\u{dcf}",
                "ස\u{dd3}තල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s rúškom"),
            keywords: &[
                "choroba",
                "chorá",
                "doktor",
                "lekár",
                "tvár",
                "tvár s rúškom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z medicinsko masko"),
            keywords: &[
                "bolno",
                "maska",
                "obraz",
                "obraz z medicinsko masko",
                "prehlad",
                "zdravilo",
                "zdravnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji maaskaro caafimaad leh"),
            keywords: &["dhakhtar", "qabow", "waji", "waji maaskaro caafimaad leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me maskë mjekësore"),
            keywords: &[
                "doktor",
                "fytyrë",
                "fytyrë me maskë mjekësore",
                "i sëmurë",
                "të ftohur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са медицинском маском"),
            keywords: &[
                "бoлeст",
                "зараза",
                "лекар",
                "лице",
                "лице са медицинском маском",
                "мaскa",
                "мeдицинa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са медицинском маском"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa medicinskom maskom"),
            keywords: &[
                "bolest",
                "lekar",
                "lice",
                "lice sa medicinskom maskom",
                "maska",
                "medicina",
                "zaraza",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa medicinskom maskom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med munskydd"),
            keywords: &["ansikte med munskydd", "läkare", "munskydd", "sjuk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliovaa barakoa ya matibabu"),
            keywords: &[
                "barakoa",
                "daktari",
                "dawa",
                "mafua",
                "mgonjwa",
                "uso",
                "uso uliovaa barakoa ya matibabu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மருத\u{bcd}துவ ம\u{bbe}ஸ\u{bcd}க\u{bcd} அணிந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "குளிர\u{bcd}",
                "நோய\u{bbe}ளி",
                "மருத\u{bcd}துவ ம\u{bbe}ஸ\u{bcd}க\u{bcd} அணிந\u{bcd}த முகம\u{bcd}",
                "மருத\u{bcd}துவ முகமூடி",
                "மருத\u{bcd}துவர\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఆసుపత\u{c4d}రుల\u{c4d}ల\u{c4b} ధర\u{c3f}ంచ\u{c47} మ\u{c3e}స\u{c4d}క\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న ముఖం",
            ),
            keywords: &[
                "ఆసుపత\u{c4d}ర\u{c3f}",
                "ఆసుపత\u{c4d}రుల\u{c4d}ల\u{c4b} ధర\u{c3f}ంచ\u{c47} మ\u{c3e}స\u{c4d}క\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న ముఖం",
                "మ\u{c3e}స\u{c4d}క\u{c4d}",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо ниқоби тиббӣ"),
            keywords: &[
                "дору",
                "духтур",
                "касал",
                "ниқоб",
                "рӯй",
                "рӯй бо ниқоби тиббӣ",
                "хунук",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e49}าคาดปาก"),
            keywords: &[
                "ป\u{e48}วย",
                "ผ\u{e49}าคาดปาก",
                "หน\u{e49}า",
                "เป\u{e47}นหว\u{e31}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saglyk maskaly ýüz"),
            keywords: &[
                "hassa",
                "lukman",
                "maska",
                "saglyk maskaly ýüz",
                "sowuk",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe pūloa fakafaitoʻo"),
            keywords: &["mata moe pūloa fakafaitoʻo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("maskeli yüz"),
            keywords: &[
                "maske",
                "maskeli yüz",
                "rahatsız",
                "soğuk",
                "tıbbi maske",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ماسكىلىق چىراي"),
            keywords: &[
                "دوختۇر",
                "دورا",
                "سوغۇق",
                "كېسەل",
                "ماسكا",
                "ماسكىلىق چىراي",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя в медичній масці"),
            keywords: &[
                "застуда",
                "лікар",
                "маска",
                "медицина",
                "обличчя в медичній масці",
                "хворий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طبی ماسک والا چہرہ"),
            keywords: &["طبی ماسک والا چہرہ", "ماسک", "ٹھنڈ", "چہرہ", "ڈاکٹر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tibbiy niqob taqqan yuz"),
            keywords: &[
                "dori",
                "kasal",
                "niqob",
                "shifokor",
                "sovuq",
                "tibbiy niqob taqqan yuz",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt đeo khẩu trang y tế"),
            keywords: &[
                "bác sĩ",
                "lạnh",
                "mặt",
                "mặt nạ",
                "mặt đeo khẩu trang y tế",
                "ốm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guñ bàndaas"),
            keywords: &[
                "doktor",
                "garab",
                "kanam",
                "kanam guñ bàndaas",
                "mask",
                "sedd",
                "wopp",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunesigqubuthelo sonyango"),
            keywords: &[
                "amayeza",
                "isigqubuthelo",
                "ubuso",
                "ubuso obunesigqubuthelo sonyango",
                "ugqirha",
                "ukubanda",
                "ukugula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Pẹlu Iboju Iṣoogun"),
            keywords: &[
                "Oju Pẹlu Iboju Iṣoogun",
                "dókítà",
                "ojú",
                "otútù",
                "àárẹ\u{300}",
                "ìbòjú",
                "ògùn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("戴口罩嘅臉"),
            keywords: &["凍", "口罩", "戴口罩嘅臉", "病", "臉", "藥", "醫生"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("戴口罩嘅脸"),
            keywords: &["冻", "医生", "口罩", "戴口罩嘅脸", "病", "脸", "药"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("感冒"),
            keywords: &["医生", "口罩", "感冒", "生病", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("口罩"),
            keywords: &["口罩", "生病"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubso obufake imaski yobuso kadokotela"),
            keywords: &[
                "banda",
                "dokotela",
                "maski",
                "ubso obufake imaski yobuso kadokotela",
                "ubuso",
                "ukugula",
                "umuthi",
            ],
        },
    ],
};
#[doc = "🤒"]
pub const FACE_WITH_THERMOMETER: crate::Emoji = crate::Emoji {
    glyph: "🤒",
    codepoint: "1F912",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "face with thermometer",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met koorspen"),
            keywords: &["gesig", "gesig met koorspen", "koorspen", "siek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቴርሞሜትር የያዘ ፊት"),
            keywords: &["በሽተኛ", "ቴርሞሜትር", "ቴርሞሜትር የያዘ ፊት", "የታመመ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مع ميزان للحرارة"),
            keywords: &[
                "ترمومتر",
                "مريض",
                "وجه",
                "وجه بترمومتر",
                "وجه مع ميزان للحرارة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("থ\u{9be}ৰ\u{9cd}মোমিট\u{9be}ৰ লগ\u{9be}ই থোৱ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "অস\u{9c1}স\u{9cd}থ",
                "থ\u{9be}ৰ\u{9cd}মোমিট\u{9be}ৰ",
                "থ\u{9be}ৰ\u{9cd}মোমিট\u{9be}ৰ লগ\u{9be}ই থোৱ\u{9be} ম\u{9c1}খ",
                "থ\u{9be}ৰ\u{9cd}মোমিট\u{9be}ৰৰ সৈতে চেহেৰ\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("termometrli"),
            keywords: &["naxoş", "termometr", "termometrli", "xəstə", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з тэрмометрам"),
            keywords: &["прастуда", "твар з тэрмометрам", "тэрмометр", "хворы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с термометър"),
            keywords: &["Лице с термометър", "болен", "лице", "термометър"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খের মধ\u{9cd}যে থ\u{9be}র\u{9cd}মোমিট\u{9be}র"),
            keywords: &[
                "অস\u{9c1}স\u{9cd}থ",
                "থ\u{9be}র\u{9cd}মোমিট\u{9be}র",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের মধ\u{9cd}যে থ\u{9be}র\u{9cd}মোমিট\u{9be}র",
                "রোগগ\u{9cd}রস\u{9cd}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("toplomjer u ustima"),
            keywords: &[
                "bolestan",
                "lice",
                "nezdrav",
                "toplomjer",
                "toplomjer u ustima",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb termòmetre"),
            keywords: &[
                "cara",
                "cara amb termòmetre",
                "malalt",
                "malalta",
                "malaltia",
                "termòmetre",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎤᏗᏞᎬ ᎤᎦᏅᏮ ᎠᏎᎯᎯ"),
            keywords: &[
                "ᎤᎧᏛ",
                "ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎤᏗᏞᎬ ᎤᎦᏅᏮ ᎠᏎᎯᎯ",
                "ᎤᏓᏂᎳ",
                "ᎤᏗᏞᎬ ᎤᎦᏅᏮ ᎠᏎᎯᎯ",
                "ᎤᏢᎦ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s teploměrem"),
            keywords: &[
                "nemocný",
                "obličej s teploměrem",
                "smajlík",
                "teploměr",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â thermomedr"),
            keywords: &["sâl", "thermomedr", "wyneb", "wyneb â thermomedr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med termometer"),
            keywords: &["ansigt", "ansigt med termometer", "syg", "termometer"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Fieberthermometer"),
            keywords: &[
                "Fieberthermometer",
                "Gesicht",
                "Gesicht mit Fieberthermometer",
                "krank",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο με θερμόμετρο"),
            keywords: &[
                "άρρωστος",
                "ασθενής",
                "θερμόμετρο",
                "πρόσωπο",
                "πρόσωπο με θερμόμετρο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with thermometer"),
            keywords: &[
                "face",
                "face with thermometer",
                "ill",
                "sick",
                "thermometer",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "face",
                "face with thermometer",
                "ill",
                "poorly",
                "sick",
                "thermometer",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "face",
                "face with thermometer",
                "ill",
                "sick",
                "thermometer",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con termómetro"),
            keywords: &[
                "cara",
                "cara con termómetro",
                "enfermo",
                "malo",
                "termómetro",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara con termómetro"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kraadiklaasiga nägu"),
            keywords: &["haige", "kraadiklaas", "kraadiklaasiga nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("termometroa duen aurpegia"),
            keywords: &[
                "aurpegi",
                "gaixo",
                "termometro",
                "termometroa duen aurpegia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تب\u{200c}دار"),
            keywords: &["بیمار", "تب", "تب\u{200c}دار", "دماسنج", "صورت", "مریض"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama ja kuumemittari"),
            keywords: &[
                "kasvot",
                "kipeä",
                "kuume",
                "lämpö",
                "lämpömittari",
                "naama",
                "naama ja kuumemittari",
                "sairas",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("may thermometer sa bibig"),
            keywords: &[
                "lagnat",
                "may thermometer sa bibig",
                "mukha",
                "sakit",
                "thermometer",
                "trangkaso",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við fepurstokkið"),
            keywords: &["andlit", "andlit við fepurstokkið", "fepurstokkur", "sjúk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec thermomètre"),
            keywords: &[
                "indisposé",
                "malade",
                "thermomètre",
                "visage",
                "visage avec thermomètre",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "indisposé",
                "malade",
                "thermomètre",
                "visage",
                "visage avec thermomètre",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le teirmiméadar"),
            keywords: &[
                "aghaidh",
                "aghaidh le teirmiméadar",
                "breoite",
                "straoiseog le teirmiméadar",
                "teirmiméadar",
                "tinn",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le teas-mheidh"),
            keywords: &[
                "aodann",
                "aodann le teas-mheidh",
                "bochd",
                "teas-mheidh",
                "tinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara con termómetro"),
            keywords: &[
                "cara",
                "cara con termómetro",
                "enferma",
                "enfermo",
                "termómetro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("થર\u{acd}મોમીટર સાથ\u{ac7}નો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "થર\u{acd}મોમીટર",
                "થર\u{acd}મોમીટર સાથ\u{ac7}નો ચહ\u{ac7}રો",
                "બીમાર",
                "મા\u{a82}દ\u{ac1}\u{a82}",
                "મ\u{ac1}ખ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai tsinken awon zafin jiki"),
            keywords: &[
                "fuska",
                "fuska mai tsinken awon zafin jiki",
                "maras lafiya",
                "rashin lafiya",
                "tsinken awon zafin jiki",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם מדחום"),
            keywords: &["חולה", "חום", "מדחום", "פרצוף", "פרצוף עם מדחום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थर\u{94d}मामीटर वाला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "थर\u{94d}मामीटर",
                "थर\u{94d}मामीटर वाला च\u{947}हरा",
                "बीमार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s toplomjerom"),
            keywords: &["lice", "lice s toplomjerom", "prehlada", "toplomjer"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc lázmérővel"),
            keywords: &["arc", "arc lázmérővel", "beteg", "lázmérő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջերմաչափով դեմք"),
            keywords: &["դեմք", "հիվանդ", "ջերմաչափ", "ջերմաչափով դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bertermometer"),
            keywords: &[
                "muka",
                "sakit",
                "termometer",
                "wajah",
                "wajah bertermometer",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere ngwa ogologo"),
            keywords: &[
                "ihu",
                "ihu nwere ngwa ogologo",
                "ngwa ogologo",
                "onye",
                "ọrịa",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með hitamæli í munninum"),
            keywords: &[
                "andlit",
                "andlit með hitamæli í munninum",
                "hitamælir",
                "með flensu",
                "veikur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con termometro"),
            keywords: &[
                "ammalato",
                "faccina con termometro",
                "febbre",
                "influenza",
                "termometro",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("熱がある顔"),
            keywords: &["体温計", "熱がある顔", "熱を測る", "病気", "顔", "風邪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngemut termometer"),
            keywords: &[
                "lara",
                "mriang",
                "rai",
                "rai ngemut termometer",
                "termometer",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე თერმომეტრით"),
            keywords: &["ავადმყოფობა", "თერმომეტრი", "სახე", "სახე თერმომეტრით"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem s utirmumitr"),
            keywords: &["udem s utirmumitr"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызуы көтерілген"),
            keywords: &[
                "ауру",
                "бет",
                "дене қызуы артқан",
                "науқас",
                "термометр",
                "қызуы көтерілген",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med termometer"),
            keywords: &["ansigt", "ansigt med termometer", "syg", "termometer"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខបៀមឧបករណ\u{17cd}ស\u{17d2}ទង\u{17cb}ក\u{17c6}ដៅ"),
            keywords: &[
                "ក\u{17d2}តៅខ\u{17d2}ល\u{17bd}ន",
                "ឈ\u{17ba}",
                "ម\u{17bb}ខបៀមឧបករណ\u{17cd}ស\u{17d2}ទង\u{17cb}ក\u{17c6}ដៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಥರ\u{ccd}ಮಾಮೀಟರ\u{ccd}\u{200c}ನ ಮುಖ"),
            keywords: &[
                "ಥರ\u{ccd}ಮಾಮೀಟರ\u{ccd}\u{200c}ನ ಮುಖ",
                "ಬಾಯ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಥರ\u{ccd}ಮಾಮೀಟರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("체온계를 물고 있는 얼굴"),
            keywords: &["병", "아픔", "얼굴", "체온계", "체온계를 물고 있는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("थर\u{94d}मोमीटर तो\u{902}डान आसपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "थर\u{94d}मोमीटर",
                "थर\u{94d}मोमीटर आसपी च\u{947}रो",
                "थर\u{94d}मोमीटर तो\u{902}डान आसपी च\u{947}रो",
                "द\u{941}य\u{947}\u{902}त",
                "द\u{941}य\u{947}\u{902}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("градусник тиштеген бет"),
            keywords: &["бет", "градусник", "градусник тиштеген бет", "оору"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat Thermometer"),
            keywords: &[
                "Gesiicht",
                "Gesiicht mat Thermometer",
                "Thermometer",
                "krank",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າອ\u{ebb}ມບາຫ\u{ebc}ອດ"),
            keywords: &[
                "ບາຫ\u{ebc}ອດ",
                "ໄຂ\u{ec9}",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າອ\u{ebb}ມບາຫ\u{ebc}ອດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su termometru"),
            keywords: &[
                "ligonis",
                "serga",
                "termometras",
                "veidas",
                "veidas su termometru",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar termometru"),
            keywords: &["seja", "seja ar termometru", "slims", "termometrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi whai inemahana"),
            keywords: &[
                "inemahana",
                "kanohi",
                "kanohi whai inemahana",
                "mate",
                "māuiui",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со термометар"),
            keywords: &["болен", "лице", "лице со термометар", "термометар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തെർമോമീറ\u{d4d}ററ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "അസ\u{d41}ഖം",
                "തെർമോമീറ\u{d4d}ററ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "തെർമോമീറ\u{d4d}റർ",
                "മ\u{d41}ഖം",
                "രോഗം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халуунтай байгаа царай"),
            keywords: &["халуунтай", "халуунтай байгаа царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थर\u{94d}मोमीटर असल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "आजारी",
                "च\u{947}हरा",
                "थर\u{94d}मोमीटर",
                "थर\u{94d}मोमीटर असल\u{947}ला च\u{947}हरा",
                "थर\u{94d}मोमीटरसह च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan termometer"),
            keywords: &[
                "muka",
                "muka dengan termometer",
                "sakit",
                "termometer",
                "tidak sihat",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’termometru"),
            keywords: &["marid", "morda", "termometru", "wiċċ", "wiċċ b’termometru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "သာမ\u{102d}\u{102f}မ\u{102e}တာန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပြဒါးတ\u{102d}\u{102f}င\u{103a}",
                "ပြဒါးတ\u{102d}\u{102f}င\u{103a}န\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဖျားနာခြင\u{103a}း",
                "မျက\u{103a}န\u{103e}ာ",
                "သာမ\u{102d}\u{102f}မ\u{102e}တာန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes med termometer"),
            keywords: &["fjes", "fjes med termometer", "syk", "termometer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थर\u{94d}मोमिटर राख\u{947}को अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ज\u{94d}वरो",
                "थर\u{94d}मोमिटर",
                "थर\u{94d}मोमिटर राख\u{947}को अन\u{941}हार",
                "बिमारी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met thermometer"),
            keywords: &[
                "gezicht",
                "gezicht met thermometer",
                "niet lekker",
                "thermometer",
                "ziek",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes med termometer"),
            keywords: &["fjes", "fjes med termometer", "sjuk", "termometer"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଥର\u{b4d}ମୋମ\u{b3f}ଟର ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅସ\u{b41}ସ\u{b4d}ଥ",
                "କ\u{b4d}ଲ\u{b3e}ନ\u{b4d}ତ",
                "ଥର\u{b4d}ମୋମ\u{b3f}ଟର",
                "ଥର\u{b4d}ମୋମ\u{b3f}ଟର ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਮਾਰ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਥਰਮਾਮੀਟਰ", "ਬਿਮਾਰ", "ਰ\u{a4b}ਗੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تھرمامیٹر نال شکل"),
            keywords: &["بیمار", "تھرمامیٹر نال شکل", "حرارت پیما", "دی شکل", "علیل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wit Tamómẹ\u{301}ta"),
            keywords: &[
                "Fes",
                "Fes Wit Tamómẹ\u{301}ta",
                "Nọ\u{301} Wẹl",
                "Sik",
                "Tamómẹ\u{301}ta",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z termometrem"),
            keywords: &[
                "choroba",
                "gorączka",
                "temperatura",
                "termometr",
                "twarz z termometrem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره ترمامیتر مخ"),
            keywords: &["ترماميټر", "رنځور", "سره ترمامیتر مخ", "مخ", "ناروغه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com termômetro"),
            keywords: &[
                "de cama",
                "febre",
                "febril",
                "rosto",
                "rosto com termômetro",
                "termômetro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com termómetro"),
            keywords: &["cara", "cara com termómetro", "doente", "termómetro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("termometrowan uya"),
            keywords: &["termometro", "termometrowan uya", "unqusqa", "unquy", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu termometru"),
            keywords: &["boală", "față", "față cu termometru", "gură", "termometru"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1012"),
            keywords: &["E10-1012"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("с градусником во рту"),
            keywords: &[
                "болезнь",
                "лицо",
                "недуг",
                "рот",
                "с градусником во рту",
                "термометр",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ifite terimometere"),
            keywords: &[
                "agapimabushyuhe",
                "isura",
                "isura ifite terimometere",
                "urwaye",
                "urwayel",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿرماميٽر سان گڏ چهرو"),
            keywords: &["بيمار", "ٿرماميٽر", "ٿرماميٽر سان گڏ چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උණකට\u{dd4}වක\u{dca} රඳව\u{dcf} ගත\u{dca} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අසන\u{dd3}ප",
                "උණ කට\u{dd4}ව",
                "උණකට\u{dd4}වක\u{dca} රඳව\u{dcf} ගත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ලෙඩ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s teplomerom"),
            keywords: &["chorá", "nezdravá", "teplomer", "tvár", "tvár s teplomerom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s termometrom"),
            keywords: &[
                "bolno",
                "obraz",
                "obraz s termometrom",
                "slabotno",
                "termometer",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji leh heerkulbeegga"),
            keywords: &[
                "heerkulbeegga",
                "jirro",
                "waji",
                "waji leh heerkulbeegga",
                "waji leh heerkulbegga",
                "xanuun",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me termometër"),
            keywords: &[
                "e sëmurë",
                "fytyrë",
                "fytyrë me termometër",
                "i sëmurë",
                "termometër",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са топломером"),
            keywords: &["лице", "лице са топломером", "прeхлaдa", "тoплoмeр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице са топломјером"),
            keywords: &["лице са топломјером"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa toplomerom"),
            keywords: &["lice", "lice sa toplomerom", "prehlada", "toplomer"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice sa toplomjerom"),
            keywords: &["lice sa toplomjerom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med termometer"),
            keywords: &["ansikte", "ansikte med termometer", "sjuk", "termometer"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye kipimajoto mdomoni"),
            keywords: &[
                "ngonjwa",
                "pima joto",
                "ugonjwa",
                "uso",
                "uso wenye kipimajoto mdomoni",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெப\u{bcd}பநிலைம\u{bbe}னி வைத\u{bcd}திருக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "க\u{bbe}ய\u{bcd}ச\u{bcd}சல\u{bcd}",
                "வெப\u{bcd}பநிலைம\u{bbe}னி உள\u{bcd}ள முகம\u{bcd}",
                "வெப\u{bcd}பநிலைம\u{bbe}னி வைத\u{bcd}திருக\u{bcd}கும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("థర\u{c4d}మ\u{c3e}మ\u{c40}టర\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "థర\u{c4d}మ\u{c3e}మ\u{c40}టర\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న ముఖం",
                "ధర\u{c4d}మ\u{c3e}మ\u{c40}టర\u{c4d}",
                "ధర\u{c4d}మ\u{c3e}మ\u{c40}టర\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо ҳароратсанҷ"),
            keywords: &["бемор", "касал", "рӯй", "рӯй бо ҳароратсанҷ", "ҳароратсанҷ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อมปรอท"),
            keywords: &[
                "ปรอทว\u{e31}ดไข\u{e49}",
                "ป\u{e48}วย",
                "หน\u{e49}า",
                "อมปรอท",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("termometrli ýüz"),
            keywords: &["hassa", "kesel", "termometr", "termometrli ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe meʻafuamafana"),
            keywords: &["mata moe meʻafuamafana"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağzında termometre olan yüz"),
            keywords: &["ağzında termometre olan yüz", "hasta", "termometre", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېرمومېتىرلىق چىراي"),
            keywords: &[
                "ئاغرىق",
                "تېرمومېتىر",
                "تېرمومېتىرلىق چىراي",
                "كېسەل",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя з термометром"),
            keywords: &["обличчя", "обличчя з термометром", "термометр", "хворий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تھرمامیٹر لیے چہرہ"),
            keywords: &["بیمار", "تھرمامیٹر", "تھرمامیٹر لیے چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("harorat o‘lchagich tutgan yuz"),
            keywords: &[
                "bemor",
                "harorat o‘lchagich",
                "harorat o‘lchagich tutgan yuz",
                "kasal",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt có miệng ngậm nhiệt kế"),
            keywords: &["mặt", "mặt có miệng ngậm nhiệt kế", "mệt", "nhiệt kế", "ốm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu ànd ak termomeetar"),
            keywords: &[
                "feelaat",
                "kanam",
                "kanam gu ànd ak termomeetar",
                "termomeetar",
                "wopp",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obune-thermometer"),
            keywords: &[
                "i-thermometer",
                "ubuso",
                "ubuso obune-thermometer",
                "ukugula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("oju pẹlu oṣuwọn igbona"),
            keywords: &[
                "oju pẹlu oṣuwọn igbona",
                "ojú",
                "àárẹ\u{300}",
                "ìlera",
                "òṣùwọ\u{300}n ìgbóná",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("探緊熱嘅臉"),
            keywords: &["探熱針", "探緊熱嘅臉", "生病", "病", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("探紧热嘅脸"),
            keywords: &["探热针", "探紧热嘅脸", "生病", "病", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("发烧"),
            keywords: &["体温计", "发烧", "温度计", "生病", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("含溫度計"),
            keywords: &["含溫度計", "生病"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunesihlolakushisa"),
            keywords: &[
                "isihlolakushisa",
                "ubuso",
                "ubuso obunesihlolakushisa",
                "ukugula",
            ],
        },
    ],
};
#[doc = "🤕"]
pub const FACE_WITH_HEAD_BANDAGE: crate::Emoji = crate::Emoji {
    glyph: "🤕",
    codepoint: "1F915",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "face with head-bandage",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met kopverband"),
            keywords: &[
                "besering",
                "gesig",
                "gesig met kopverband",
                "seer",
                "verband",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እራሱ ላይ ፋሻ የጠቀለለ ፊት"),
            keywords: &["ቁስል", "እራሱ ላይ ፋሻ የጠቀለለ ፊት", "ጉዳት", "ፊት", "ፋሻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بعصابة رأس"),
            keywords: &[
                "ألم",
                "جرح",
                "عصابة",
                "وجه",
                "وجه بعصابة رأس",
                "وجه بعصابة على الرأس",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}ৰত বেণ\u{9cd}ডেজৰ সৈতে চেহেৰ\u{9be}"),
            keywords: &[
                "আঘ\u{9be}ত",
                "ক\u{9cd}ষতি",
                "বেণ\u{9cd}ডেজ",
                "ম\u{9c1}খ",
                "ম\u{9c1}ৰত বেণ\u{9cd}ডেজৰ সৈতে চেহেৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("baş sarğılı üz"),
            keywords: &["baş sarğılı üz", "sarğı", "xəsarət", "zədə", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з павязкай на галаве"),
            keywords: &[
                "выцятае месца",
                "павязка",
                "твар з павязкай на галаве",
                "траўма",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с превръзка на главата"),
            keywords: &[
                "Лице с превръзка на главата",
                "лице",
                "нараняване",
                "превръзка",
                "рана",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}থ\u{9be}য\u{9bc} ব\u{9cd}য\u{9be}ন\u{9cd}ডেজ কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "আঘ\u{9be}ত",
                "চোট",
                "ব\u{9cd}য\u{9be}ন\u{9cd}ডেজ",
                "ম\u{9be}থ\u{9be}য\u{9bc} ব\u{9cd}য\u{9be}ন\u{9cd}ডেজ কর\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zavoj na glavi"),
            keywords: &["bol", "lice", "povreda", "zavoj", "zavoj na glavi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb el cap embenat"),
            keywords: &["cap embenat", "cara", "cara amb el cap embenat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎠᏍᎪᎳ-ᎤᏐᏅᏅ ᎦᏇᏅᏙᏗ"),
            keywords: &[
                "ᎤᎧᏛ",
                "ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎠᏍᎪᎳ-ᎤᏐᏅᏅ ᎦᏇᏅᏙᏗ",
                "ᎤᎵᏇᏅᎯ",
                "ᎤᏥᏅᏅᎢ",
                "ᎤᏪᏍᏓᏁ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s ovázanou hlavou"),
            keywords: &[
                "bolest",
                "obličej s ovázanou hlavou",
                "obvaz",
                "smajlík",
                "tvář",
                "výraz",
                "zranění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â rhwymyn i’r pen"),
            keywords: &[
                "dolur",
                "niwed",
                "rhwymyn",
                "wyneb",
                "wyneb â rhwymyn i’r pen",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med bandage"),
            keywords: &["ansigt", "ansigt med bandage", "bandage", "skade", "smerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Kopfverband"),
            keywords: &[
                "Gesicht",
                "Gesicht mit Kopfverband",
                "Schmerzen",
                "Verband",
                "Verletzung",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("επίδεσμος στο κεφάλι"),
            keywords: &[
                "επίδεσμος",
                "επίδεσμος στο κεφάλι",
                "πρόσωπο",
                "τραύμα",
                "χτυπημένος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with head-bandage"),
            keywords: &[
                "bandage",
                "face",
                "face with head-bandage",
                "hurt",
                "injury",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("face with head bandage"),
            keywords: &[
                "bandage",
                "face",
                "face with head bandage",
                "hurt",
                "injury",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bandage",
                "face",
                "face with head bandage",
                "hurt",
                "injury",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con la cabeza vendada"),
            keywords: &[
                "cara",
                "cara con la cabeza vendada",
                "dolor",
                "herida",
                "venda",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cabeza vendada"),
            keywords: &["cabeza vendada", "cara", "dolor", "herido", "vendas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara con la cabeza vendada"),
            keywords: &[
                "cara",
                "cara con la cabeza vendada",
                "dolor",
                "herido",
                "vendas",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara con la cabeza vendada"),
            keywords: &[
                "cara",
                "cara con la cabeza vendada",
                "dolor",
                "herido",
                "vendas",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kinniseotud peaga nägu"),
            keywords: &[
                "kinniseotud",
                "kinniseotud peaga nägu",
                "nägu",
                "side",
                "vigastus",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("buruan benda daraman aurpegia"),
            keywords: &[
                "aurpegi",
                "benda",
                "buruan benda daraman aurpegia",
                "oinaze",
                "zauri",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سر باندپیچی\u{200c}شده"),
            keywords: &[
                "آسیب",
                "باندپیچی",
                "حادثه",
                "سر",
                "سر باندپیچی\u{200c}شده",
                "صدمه",
                "صورت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama ja pääside"),
            keywords: &["kipeä", "naama", "naama ja pääside", "side", "vamma"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("may benda sa ulo"),
            keywords: &[
                "aksidente",
                "benda",
                "injury",
                "may benda sa ulo",
                "mukha",
                "nasaktan",
                "sugat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við bind um høvdið"),
            keywords: &[
                "andlit",
                "andlit við bind um høvdið",
                "bind",
                "skaði",
                "sár",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec bandage autour de la tête"),
            keywords: &["bandage", "tête", "visage avec bandage autour de la tête"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage bandé"),
            keywords: &["bandage", "blessure", "blessé", "visage", "visage bandé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le bindealán ar a ceann"),
            keywords: &[
                "aghaidh",
                "aghaidh le bindealán ar a cheann",
                "bindealán",
                "dochar",
                "gortaithe",
                "straoiseog le bindealán ar a ceann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le clobhd air a’ cheann"),
            keywords: &[
                "aodann",
                "aodann le clobhd air a’ cheann",
                "clobhd",
                "leòinte",
                "leònta",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara coa cabeza vendada"),
            keywords: &[
                "accidente",
                "cara",
                "cara coa cabeza vendada",
                "ferido",
                "venda",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માથ\u{ac7} પટ\u{acd}ટીવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "ઈજા",
                "ઘા",
                "ચહ\u{ac7}રો",
                "પટ\u{acd}ટી",
                "માથ\u{ac7} પટ\u{acd}ટીવાળો ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai bandejin-kai"),
            keywords: &[
                "bandeji",
                "ciwo",
                "fuska",
                "fuska mai bandejin-kai",
                "rauni",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם תחבושת ראש"),
            keywords: &["כואב", "פרצוף", "פרצוף עם תחבושת ראש", "תחבושת ראש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सिर पर पट\u{94d}टी वाला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "चोट",
                "द\u{941}र\u{94d}घटनाग\u{94d}रस\u{94d}त",
                "सिर पर पट\u{94d}टी",
                "सिर पर पट\u{94d}टी वाला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice sa zavojem"),
            keywords: &["bol", "lice", "lice sa zavojem", "ozljeda", "zavoj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc bekötött fejjel"),
            keywords: &["arc", "arc bekötött fejjel", "kötés", "sérülés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գլխակապով դեմք"),
            keywords: &["գլխակապ", "գլխակապով դեմք", "դեմք", "վիրակապ", "վնասվածք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah diperban di kepala"),
            keywords: &[
                "cedera",
                "luka",
                "muka",
                "perban",
                "wajah",
                "wajah diperban di kepala",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere akwà mkpuchi"),
            keywords: &[
                "ahụ",
                "akwà mkpuchi",
                "ihu",
                "ihu nwere akwà mkpuchi",
                "mmerụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með sárabindi"),
            keywords: &[
                "andlit",
                "andlit með sárabindi",
                "meiddur",
                "slasaður",
                "sárabindi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con la testa bendata"),
            keywords: &[
                "bende",
                "dolore",
                "faccina",
                "faccina bendata",
                "faccina con la testa bendata",
                "farsi male",
                "fasciarsi la testa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("包帯を巻いた顔"),
            keywords: &["ケガ", "ケガしてる顔", "包帯", "包帯を巻いた顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai sirahe dibebet"),
            keywords: &["bebet", "cidra", "rai", "rai sirahe dibebet", "tatu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე თავზე ბინტით"),
            keywords: &["ბინტი", "ნატკენი", "სახე", "სახე თავზე ბინტით", "ტრავმა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басы бинттелген"),
            keywords: &["бандаж", "басы бинттелген", "бет", "жарақат алу", "соғу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med bandage"),
            keywords: &["ansigt", "ansigt med bandage", "bandage", "skade", "smerte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខរ\u{17bb}\u{17c6}ប\u{17c9}ង\u{17cb}សេម\u{17c9}ង\u{17cb}"),
            keywords: &[
                "គ\u{17d2}រោះថ\u{17d2}នាក\u{17cb}",
                "ម\u{17bb}ខរ\u{17bb}\u{17c6}ប\u{17c9}ង\u{17cb}សេម\u{17c9}ង\u{17cb}",
                "រប\u{17bd}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಲ\u{cc6} ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd}\u{200c}ನ ಮುಖ"),
            keywords: &[
                "ತಲ\u{cc6} ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd}\u{200c}ನ ಮುಖ",
                "ತಲ\u{cc6}ಗ\u{cc6} ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd} ಹೊಂದ\u{cbf}ರುವ ಮುಖ",
                "ಬ\u{ccd}ಯಾಂಡೇಜ\u{ccd} ಮುಖ",
                "ಹಣ\u{cc6}ಪಟ\u{ccd}ಟ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("머리에 붕대를 감은 얼굴"),
            keywords: &["머리에 붕대를 감은 얼굴", "부상", "붕대", "상처", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तकल\u{947}क ब\u{901}ड\u{947}ज क\u{947}ल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "तकल\u{947}क ब\u{901}ड\u{947}ज क\u{947}ल\u{94d}लो च\u{947}रो",
                "द\u{941}खापत",
                "द\u{942}ख",
                "ब\u{901}ड\u{947}ज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башы бинттелген бет"),
            keywords: &["башы бинттелген бет", "бет", "бинт", "оорутуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat Kappverband"),
            keywords: &[
                "Gesiicht",
                "Gesiicht mat Kappverband",
                "Verband",
                "Verletzung",
                "verletzt",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າມ\u{eb5}ຜ\u{ec9}າພ\u{eb1}ນຫ\u{ebb}ວ"),
            keywords: &[
                "ຜ\u{ec9}າພ\u{eb1}ນແຜ",
                "ເຈ\u{eb1}ບ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າມ\u{eb5}ຜ\u{ec9}າພ\u{eb1}ນຫ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su galvos tvarsčiu"),
            keywords: &[
                "skausmas",
                "sužeidimas",
                "tvarstis",
                "veidas",
                "veidas su galvos tvarsčiu",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar galvas apsēju"),
            keywords: &["apsējs", "ievainojums", "seja", "seja ar galvas apsēju"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi mau takai-upoko"),
            keywords: &[
                "kanohi",
                "kanohi mau takai-upoko",
                "mamae",
                "takai",
                "whara",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со преврска на главата"),
            keywords: &[
                "завој",
                "лице",
                "лице со преврска на главата",
                "повреда",
                "рана",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലയിൽ ബ\u{d3e}ൻഡേജ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "തലയിൽ ബ\u{d3e}ൻഡേജ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "പരിക\u{d4d}ക\u{d4d}",
                "ബ\u{d3e}ൻഡേജ\u{d4d}",
                "മ\u{d41}ഖം",
                "മ\u{d41}റിവ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("толгойндоо шархны боолт зүүсэн царай"),
            keywords: &[
                "зүүсэн",
                "толгой",
                "толгойндоо шархны боолт зүүсэн царай",
                "царай",
                "шархны боолт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोक\u{94d}याला पट\u{94d}यी बा\u{902}धल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "इजा",
                "च\u{947}हरा",
                "डोक\u{94d}याला पट\u{94d}यी बा\u{902}धल\u{947}ला च\u{947}हरा",
                "डोक\u{94d}याला ब\u{901}ड\u{947}ज बा\u{902}धल\u{947}ला च\u{947}हरा",
                "द\u{941}खापत",
                "ब\u{901}ड\u{947}ज",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan kepala berbalut"),
            keywords: &[
                "cedera",
                "kecederaan",
                "muka",
                "muka dengan kepala berbalut",
                "pembalut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’faxxa mar-ras"),
            keywords: &["faxxa", "muġugħ", "wiċċ", "wiċċ b’faxxa mar-ras", "ħsara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပတ\u{103a}တ\u{102e}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ထ\u{102d}ခ\u{102d}\u{102f}က\u{103a}ခြင\u{103a}း",
                "နာကျင\u{103a}ခြင\u{103a}း",
                "ပတ\u{103a}တ\u{102e}း",
                "ပတ\u{103a}တ\u{102e}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "ဦးခေါင\u{103a}းပတ\u{103a}တ\u{102e}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bandasjert hode"),
            keywords: &["bandasje", "bandasjert hode", "fjes", "skade", "skadet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टाउकोमा पट\u{94d}टी लगाइएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "घाउ",
                "चोट",
                "टाउकोमा पट\u{94d}टी लगाइएको अन\u{941}हार",
                "पट\u{94d}टी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met een verband om het hoofd"),
            keywords: &[
                "gewond",
                "gezicht",
                "gezicht met een verband om het hoofd",
                "pijn",
                "verband",
                "verwonding",
                "wond",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bandasjert hovud"),
            keywords: &["bandasje", "bandasjert hovud", "fjes", "skadd", "skade"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ଣ\u{b4d}ଡ-ପଟ\u{b3f} ପଡ\u{b3f}ବ\u{b3e} ସହ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆଘ\u{b3e}ତ",
                "କଷ\u{b4d}ଟ",
                "ପଟ\u{b3f}",
                "ମ\u{b41}ଣ\u{b4d}ଡ-ପଟ\u{b3f} ପଡ\u{b3f}ବ\u{b3e} ସହ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a3c}ਖਮੀ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਜ\u{a3c}ਖਮੀ",
                "ਪ\u{a71}ਟੀ",
                "ਫ\u{a71}ਟੜ ਚਿਹਰਾ",
                "ਸ\u{a71}ਟ ਲ\u{a71}ਗਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سر آلی پٹی نال شکل"),
            keywords: &["دی شکل", "زخمی", "سر آلی پٹی نال شکل", "سٹ", "مرہم پٹی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fés Wit Bándej Fọ Hẹd"),
            keywords: &["Bándej", "Fes", "Fés Wit Bándej Fọ Hẹd", "Pen", "Wund"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z bandażem"),
            keywords: &[
                "bandaż",
                "czoło",
                "głowa",
                "rana",
                "skaleczenie",
                "twarz z bandażem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سره سر-بنداژ مخ"),
            keywords: &["بنداژ", "زخمي", "سره سر-بنداژ مخ", "مخ بنداژ", "ژوبل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com atadura na cabeça"),
            keywords: &[
                "acidentado",
                "ferimento",
                "rosto",
                "rosto com atadura na cabeça",
                "rosto com curativos",
                "rosto machucado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com ligadura na cabeça"),
            keywords: &[
                "cara",
                "cara com ligadura na cabeça",
                "ferimento",
                "ligadura",
                "magoado",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya manku umawan"),
            keywords: &["kʼiri", "kʼirisqa", "uya", "uya manku umawan", "venda"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu capul bandajat"),
            keywords: &["bandaj", "durere", "față", "față cu capul bandajat", "rană"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1015"),
            keywords: &["E10-1015"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("с перевязанной головой"),
            keywords: &[
                "боль",
                "лицо",
                "лоб",
                "плохо",
                "повязка",
                "с перевязанной головой",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ipfutse ku mutwe"),
            keywords: &[
                "igikomere",
                "igipfuko",
                "isura",
                "isura ipfutse ku mutwe",
                "kubabara",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي تي پٽي ٻڌل چهرو"),
            keywords: &["زخم", "مٿي تي پٽي ٻڌل چهرو", "پٽي", "چهرو", "ڏکائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}සට බැන\u{dca}ඩේජ\u{dca} දැම\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ත\u{dd4}ව\u{dcf}ලය",
                "බැන\u{dca}ඩේජ\u{dca}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ර\u{dd2}ද\u{dd3}ම",
                "හ\u{dd2}සට බැන\u{dca}ඩේජ\u{dca} දැම\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s obväzom"),
            keywords: &["obväz", "poranená", "tvár", "tvár s obväzom", "zranenie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, obvezan s povojem"),
            keywords: &[
                "obraz",
                "obraz, obvezan s povojem",
                "povoj",
                "poškodba",
                "poškodovano",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji leh faashid madaxeed"),
            keywords: &[
                "dhaawac",
                "dhaawac ah",
                "faashad",
                "waji",
                "waji leh faashad madaxeed",
                "waji leh faashid madaxeed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me fashë në kokë"),
            keywords: &[
                "fashë",
                "fytyrë",
                "fytyrë me fashë në kokë",
                "lëndim",
                "lëndoj",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са завојем на глави"),
            keywords: &[
                "бoл",
                "зaвoj",
                "лице",
                "лице са завојем на глави",
                "повреда",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa zavojem na glavi"),
            keywords: &[
                "bol",
                "lice",
                "lice sa zavojem na glavi",
                "povreda",
                "zavoj",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med bandage på huvudet"),
            keywords: &[
                "ansikte",
                "ansikte med bandage",
                "ansikte med bandage på huvudet",
                "bandage",
                "skadad",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliofungwa bandeji kichwani"),
            keywords: &[
                "bandeji",
                "kuumia",
                "maumivu",
                "uso",
                "uso uliofungwa bandeji kichwani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தலைக\u{bcd}கட\u{bcd}டு கட\u{bcd}டப\u{bcd}பட\u{bcd}ட முகம\u{bcd}"),
            keywords: &[
                "தலைக\u{bcd}கட\u{bcd}டு",
                "தலைக\u{bcd}கட\u{bcd}டு உள\u{bcd}ள முகம\u{bcd}",
                "தலைக\u{bcd}கட\u{bcd}டு கட\u{bcd}டப\u{bcd}பட\u{bcd}ட முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తలకు కట\u{c4d}టుత\u{c4b} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "కట\u{c4d}టు",
                "తల",
                "తలకు కట\u{c4d}టుత\u{c4b} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо бандинаи сар"),
            keywords: &[
                "бандина",
                "зарар расондан",
                "осеб",
                "рӯй",
                "рӯй бо бандинаи сар",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วแตก"),
            keywords: &[
                "ผ\u{e49}าก\u{e47}อต",
                "หน\u{e49}า",
                "ห\u{e31}วแตก",
                "เจ\u{e47}บ",
                "แผล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kellesi sargyly ýüz"),
            keywords: &["kellesi sargyly ýüz", "sargy", "ynjyly", "ýara", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe haʻi lavea"),
            keywords: &["mata moe haʻi lavea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kafası sarılı yüz"),
            keywords: &["bandaj", "kafası sarılı yüz", "yara", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېڭىق چىراي"),
            keywords: &["تېڭىق", "يارا", "يارىدار", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя з головною повʼязкою"),
            keywords: &[
                "обличчя",
                "обличчя з головною повʼязкою",
                "пов’язка",
                "поранений",
                "рана",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سر پر پٹی باندھے چہرہ"),
            keywords: &["زخم", "سر پر پٹی باندھے چہرہ", "پٹی", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boshi bint bilan o‘ralgan yuz"),
            keywords: &[
                "bint",
                "boshi bint bilan o‘ralgan yuz",
                "jarohat",
                "lat",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt đeo băng đầu"),
            keywords: &["băng", "mặt", "mặt đeo băng đầu", "vết thương", "đau"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guñ laxas ak bàndaas"),
            keywords: &[
                "bandage",
                "gaañu",
                "kanam",
                "kanam guñ laxas ak bàndaas",
                "naxar",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunebhandeji elisentloko"),
            keywords: &[
                "ibhandeji",
                "ubuhlungu",
                "ubuso",
                "ubuso obunebhandeji elisentloko",
                "umonzakalo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Pẹlu Ori ti a de Lọja"),
            keywords: &["Oju Pẹlu Ori ti a de Lọja", "egbò", "farapa", "ojú", "ìdì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紥繃帶嘅臉"),
            keywords: &["受傷", "損傷", "紥繃帶嘅臉", "繃帶", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("紥绷带嘅脸"),
            keywords: &["受伤", "损伤", "紥绷带嘅脸", "绷带", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("受伤"),
            keywords: &["受伤", "打绷带", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("包繃帶"),
            keywords: &["包繃帶", "受傷"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obufake ibhandishi"),
            keywords: &[
                "ibhandishi",
                "ubuhlungu",
                "ubuso",
                "ubuso obufake ibhandishi",
                "ukulimala",
            ],
        },
    ],
};
#[doc = "🤢"]
pub const NAUSEATED_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤢",
    codepoint: "1F922",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "nauseated face",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("naar gesig"),
            keywords: &["gesig", "kots", "naar", "opgooi"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ያስታወከ ፊት"),
            keywords: &["ማስታወክ", "ያስታወከ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مشمئز"),
            keywords: &["اشمئزاز", "غثيان", "وجه متقزز", "وجه مشمئز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c3}ণিত ম\u{9c1}খ"),
            keywords: &[
                "ঘ\u{9c3}ণ\u{9be}",
                "ঘ\u{9c3}ণিত ম\u{9c1}খ",
                "বমি",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("iyrənən üz"),
            keywords: &["iyrənmək", "iyrənən üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("моташна"),
            keywords: &["моташна", "нудзіць", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лице пред повръщане"),
            keywords: &["лице", "лице пред повръщане", "отвратено", "повръщане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গ\u{9be} বমি কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "গ\u{9be} বমি কর\u{9be} ম\u{9c1}খ",
                "বমি",
                "বমি বমি ভ\u{9be}গ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muka"),
            keywords: &["lice", "muka", "povraćanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de nàusees"),
            keywords: &[
                "cara",
                "cara de nàusees",
                "mareig",
                "marejada",
                "marejat",
                "nàusea",
                "vomitar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎸᏕᎳᏗ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎸᏕᎳᏗ", "ᏧᎦᏍᏘᏂᏕᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej se znechuceným výrazem"),
            keywords: &[
                "obličej se znechuceným výrazem",
                "smajlík",
                "tvář",
                "výraz",
                "znechucení",
                "zvracet",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb chwydlyd"),
            keywords: &["chwydlyd", "chwydu", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med kvalme"),
            keywords: &[
                "ansigt med kvalme",
                "bræk",
                "kaste op",
                "kvalme",
                "opkast",
                "syg",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("würgendes Gesicht"),
            keywords: &["Erbrechen", "Gesicht", "würgendes Gesicht", "Übelkeit"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανακατεύομαι"),
            keywords: &["ανακατεύομαι", "εμετός", "ναυτία", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nauseated face"),
            keywords: &["face", "nauseated", "vomit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de náuseas"),
            keywords: &["cara", "cara de náuseas", "náuseas", "vomitar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara de náuseas", "náuseas", "vómito"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("iiveldust tundev nägu"),
            keywords: &["iiveldus", "iiveldust tundev nägu", "nägu", "okse"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi zorabiatua"),
            keywords: &["aurpegi", "aurpegi zorabiatua", "goitika", "zorabiatu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حالت تهوع"),
            keywords: &[
                "استفراغ",
                "بالا آوردن",
                "تهوع",
                "حال بد",
                "حال به\u{200c}هم خوردن",
                "حالت تهوع",
                "صورت سبز",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pahoinvoiva"),
            keywords: &["kasvot", "oksentaa", "pahoinvoida", "pahoinvoiva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nasusuka"),
            keywords: &["mukha", "nasusuka", "suka"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit ið vil spýggja"),
            keywords: &[
                "andlit",
                "andlit ið vil spýggja",
                "sjóverk",
                "spýggj",
                "vaml",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage nauséeux"),
            keywords: &["nausée", "visage", "visage nauséeux", "écœuré"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage écœuré"),
            keywords: &["nausée", "visage", "écœuré"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog bhreoite"),
            keywords: &[
                "breoite",
                "fonn múisce",
                "masmas",
                "straoiseog bhreoite",
                "tinn",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann sgreamha"),
            keywords: &["aodann", "aodann sgreamha", "cur a-mach", "sgreamh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de mareo"),
            keywords: &["cara de mareo", "mareado", "mareo", "náuseas", "vomitar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચીતરી ચડ\u{ac7}લો ચહ\u{ac7}રો"),
            keywords: &[
                "ઊલટી",
                "ચહ\u{ac7}રો",
                "ચીતરી ચડ\u{ac7}લો",
                "ચીતરી ચડ\u{ac7}લો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai tashin zuciya"),
            keywords: &[
                "amai",
                "fuska",
                "fuska mai tashin zuciya",
                "mai tashin zuciya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף סובל מבחילה"),
            keywords: &["בחילה", "הקאה", "פרצוף", "פרצוף סובל מבחילה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उल\u{94d}टी करता च\u{947}हरा"),
            keywords: &["उल\u{94d}टी", "उल\u{94d}टी करता च\u{947}हरा", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice kojem je pozlilo"),
            keywords: &["lice", "lice kojem je pozlilo", "muka", "povraćanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("émelygő arc"),
            keywords: &["arc", "hányás", "émelygő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սրտխառնոցով դեմք"),
            keywords: &["դեմք", "սրտխառնոց", "սրտխառնոցով դեմք", "փսխում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mual"),
            keywords: &["mual", "muka", "muntah", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nkoropu"),
            keywords: &["agbọọ", "ihu", "nkoropu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gubbukall"),
            keywords: &["andlit", "gubba", "gubbukall", "ógleði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina nauseata"),
            keywords: &["faccina", "faccina nauseata", "nausea", "vomito"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("吐き気を催している顔"),
            keywords: &[
                "具合の悪い顔",
                "吐き気を催している顔",
                "気持ち悪い",
                "病気",
                "顔",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngrasa muleg-muleg"),
            keywords: &["muleg-muleg", "mutah", "rai", "rai ngrasa muleg-muleg"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გულისრევა"),
            keywords: &["გულისრევა", "სახე", "ღებინება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүрегі айнып тұр"),
            keywords: &["бет", "жүрегі айнып тұр", "құсқысы келіп тұр"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med kvalme"),
            keywords: &[
                "ansigt",
                "ansigt med kvalme",
                "bræk",
                "kaster op",
                "kvalme",
                "kvalmeansigt",
                "opkast",
                "syg",
                "sygdom",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខរកកលចង\u{17cb}ក\u{17d2}អ\u{17bd}ត"),
            keywords: &[
                "ក\u{17d2}អ\u{17bd}ត",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខរកកលចង\u{17cb}ក\u{17d2}អ\u{17bd}ត",
                "រកកល\u{17cb}ចង\u{17cb}ក\u{17d2}អ\u{17bd}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೇವರ\u{cbf}ಕ\u{cc6} ಮುಖ"),
            keywords: &["ಮುಖ", "ವಾಂತ\u{cbf}", "ಹೇವರ\u{cbf}ಕ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("구역질을 하는 얼굴"),
            keywords: &[
                "구역질을 하는 얼굴",
                "구토",
                "속 울렁거림",
                "얼굴",
                "토하기",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मळमळपी च\u{947}रो"),
            keywords: &["ओ\u{902}कारी", "च\u{947}रो", "मळमळपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүрөгү айланган бет"),
            keywords: &["бет", "жүрөгү айланган", "жүрөгү айланган бет", "кусуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("iwwelt Gesiicht"),
            keywords: &["Gesiicht", "iwwel", "iwwelt Gesiicht", "sech iwwerginn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າພະອ\u{eb7}ດພະອ\u{ebb}ມ"),
            keywords: &[
                "ພະອ\u{eb7}ດພະອ\u{ebb}ມ",
                "ຮາກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າພະອ\u{eb7}ດພະອ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besiruošiantis vemti veidas"),
            keywords: &["besiruošiantis vemti veidas", "veidas", "vemti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nelabums"),
            keywords: &["nelabums", "seja", "slimība"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi kanekane"),
            keywords: &["kanekane", "kanohi", "ruaki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мачнина"),
            keywords: &["мачнина", "повраќа", "слоши"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓക\u{d4d}ക\u{d3e}നിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d3e}വം"),
            keywords: &[
                "ഓക\u{d4d}ക\u{d3e}നം",
                "ഓക\u{d4d}ക\u{d3e}നിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഭ\u{d3e}വം",
                "ഭ\u{d3e}വം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дурамжхан царай"),
            keywords: &["дурамжхан", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मळमळत असतानाचा च\u{947}हरा"),
            keywords: &[
                "ओकारी",
                "च\u{947}हरा",
                "मळमळ होण\u{947}",
                "मळमळत असतानाचा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka mual"),
            keywords: &["loya", "mual", "muka", "muntah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jirremetti"),
            keywords: &["jirremetti", "vomtu", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အော\u{103a}ဂလ\u{102e}ဆန\u{103a}သည\u{1037}\u{103a}ရ\u{102f}ပ\u{103a}"),
            keywords: &[
                "ရ\u{102f}ပ\u{103a}",
                "အန\u{103a}သည\u{103a}",
                "အောက\u{103a}ဂလ\u{102e}ဆန\u{103a}သည\u{103a}",
                "အော\u{103a}ဂလ\u{102e}ဆန\u{103a}သည\u{1037}\u{103a}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvalm"),
            keywords: &["fjes", "kvalm", "oppkast", "spy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बान\u{94d}ता गर\u{947}को अन\u{941}हार"),
            keywords: &[
                "अन\u{941}\u{941}हार",
                "बान\u{94d}ता",
                "बान\u{94d}ता गर\u{947}को",
                "बान\u{94d}ता गर\u{947}को अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("misselijk gezicht"),
            keywords: &["gezicht", "misselijk", "overgeven"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvalm"),
            keywords: &["fjes", "kvalm", "oppkast", "spy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ତ\u{b43}ଷ\u{b4d}ଣ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ବ\u{b3e}ନ\u{b4d}ତ\u{b3f}",
                "ବ\u{b3f}ତ\u{b43}ଷ\u{b4d}ଣ\u{b3e}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜੀਅ ਮਤਲਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &["ਉਲਟੀ", "ਚਿਹਰਾ", "ਜੀਅ ਮਤਲਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("متلی آلی شکل"),
            keywords: &["ا\u{64f}لٹی", "جی متلانا", "دی شکل", "متلی آلی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Wán Vọmit"),
            keywords: &["Fes", "Vọmit", "Wán", "Wé"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z mdłościami"),
            keywords: &["mdłości", "twarz z mdłościami", "wymiotować"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زړه بدوالی مخ"),
            keywords: &["زړه بدوالی مخ", "قي کول", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto nauseado"),
            keywords: &["enjoado", "enjoo", "rosto nauseado", "vômito"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara nauseada"),
            keywords: &["cara", "nauseada", "vómito"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñatʼisqa uya"),
            keywords: &["q’ipna", "uya", "ñatʼisqa uya", "ñat’isqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față îngrețoșată"),
            keywords: &["față", "față îngrețoșată", "greață", "vomă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1028"),
            keywords: &["E10-1028"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тошнит"),
            keywords: &["болезнь", "лицо", "морская болезнь", "тошнит", "тошно"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ifite isesemi"),
            keywords: &["irwaye", "isura", "isura ifite isesemi", "kuruka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("الٽي ايندڙ چهرو"),
            keywords: &["الٽي", "الٽي ايندڙ چهرو", "چهرو", "ڪراهت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ළ\u{dd2}ක\u{dd4}ල\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ප\u{dd2}ළ\u{dd2}ක\u{dd4}ල\u{dca} ව\u{dd6}",
                "ප\u{dd2}ළ\u{dd2}ක\u{dd4}ල\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "වමනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár, ktorej je zle"),
            keywords: &["nevoľnosť", "tvár", "tvár, ktorej je zle", "vracať", "zle"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki se počuti slabo"),
            keywords: &["bruhanje", "obraz, ki se počuti slabo", "slabost"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji lalabo leh"),
            keywords: &["lalabo", "mantaq", "waji", "waji lalabo leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë neverie"),
            keywords: &[
                "fytyrë",
                "fytyrë neverie",
                "neveri",
                "të përziera",
                "të vjella",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице којем је мука"),
            keywords: &["лице", "лице којем је мука", "мука", "мучнина", "повраћање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице којем је мука"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice kojem je muka"),
            keywords: &[
                "lice",
                "lice kojem je muka",
                "muka",
                "mučnina",
                "povraćanje",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice kojem je muka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("äcklat ansikte"),
            keywords: &[
                "ansikte",
                "kasta upp",
                "kräks",
                "spy",
                "äcklad",
                "äcklat ansikte",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichefuchefu"),
            keywords: &["kichefuchefu", "kizunguzungu", "kutapika", "uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒவ\u{bcd}வ\u{bbe}மையை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "ஒவ\u{bcd}வ\u{bbe}மையை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
                "முகம\u{bcd}",
                "வ\u{bbe}ந\u{bcd}தி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}క\u{c3e}రపు ముఖం"),
            keywords: &[
                "న\u{c40}రసం",
                "ముఖం",
                "వ\u{c3e}ంత\u{c3f}",
                "వ\u{c3f}క\u{c3e}రపు ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи дилбеҳузурӣ"),
            keywords: &["дилбеҳузуршуда", "партофтан", "рӯи дилбеҳузурӣ", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าเข\u{e35}ยว"),
            keywords: &[
                "คล\u{e37}\u{e48}นไส\u{e49}",
                "พะอ\u{e37}ดพะอม",
                "หน\u{e49}าเข\u{e35}ยว",
                "อ\u{e49}วก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüregi bulanýan ýüz"),
            keywords: &["gusmak", "ýüregi bulanýan", "ýüregi bulanýan ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata kavahia"),
            keywords: &["mata kavahia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kusmak üzere olan yüz"),
            keywords: &["istifra", "kusmak üzere", "kusmak üzere olan yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆڭلى ئېلىشقان چىراي"),
            keywords: &["قۇسۇش", "كۆڭلى ئېلىشقان چىراي", "كۆڭلى ئېلىشىش", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, яке нудить"),
            keywords: &["блювота", "нудота", "обличчя", "обличчя, яке нудить"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("متلی کی کیفیت والا چہرہ"),
            keywords: &["متلی", "متلی کی کیفیت والا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘ngli ayniyotgan"),
            keywords: &["kasallik", "ko‘ngil aynish", "ko‘ngli ayniyotgan", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt buồn nôn"),
            keywords: &["buồn nôn", "mặt", "mặt buồn nôn", "nôn mửa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu guy teey xel"),
            keywords: &["kanam", "kanamu guy teey xel", "waccu", "xel muy teey"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obonyanyileyo"),
            keywords: &["obunyanyileyo", "ubuso", "ubuso obonyanyileyo", "umgabho"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ailera"),
            keywords: &["Oju Ailera", "ojú", "àìlera", "èébì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嘔心嘅臉"),
            keywords: &["嘔吐", "嘔心", "嘔心嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("呕心嘅脸"),
            keywords: &["呕吐", "呕心", "呕心嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("恶心"),
            keywords: &["吐", "呕", "恶心", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("想吐"),
            keywords: &["吐", "噁心", "想", "想吐"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("想嘔"),
            keywords: &["吐", "噁心", "想", "想嘔"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isicanucanu"),
            keywords: &["isicanucanu", "phalaza", "ubuso", "ukuba nesicanucanu"],
        },
    ],
};
#[doc = "🤮"]
pub const FACE_VOMITING: crate::Emoji = crate::Emoji {
    glyph: "🤮",
    codepoint: "1F92E",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "face vomiting",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat opgooi"),
            keywords: &["gesig wat opgooi", "opgooi", "siek"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚያስታውክ ፊት"),
            keywords: &["የሚያስታውክ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يتقي\u{651}أ"),
            keywords: &["قيء", "وجه يتقيأ", "وجه يتقي\u{651}أ", "يتقيأ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বমি কৰ\u{9be} ম\u{9c1}খ"),
            keywords: &["অস\u{9c1}স\u{9cd}থ", "বমি", "বমি কৰ\u{9be} ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qusan üz"),
            keywords: &["qusan üz", "qusmaq", "xəstə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ванітуе"),
            keywords: &["ванітуе", "ваніты", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Повръщащо лице"),
            keywords: &["Повръщащо лице", "болен", "повръщане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বমনরত ম\u{9c1}খ"),
            keywords: &["অস\u{9c1}স\u{9cd}থ", "বমনরত ম\u{9c1}খ", "বমি কর\u{9be}"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("povraćanje"),
            keywords: &["muka", "povraćanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que vomita"),
            keywords: &["cara", "cara que vomita", "vòmit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛ ᏚᎦᏍᏗᎲᎢ"),
            keywords: &["ᎤᎧᏛ ᏚᎦᏍᏗᎲᎢ", "ᎤᏓᏂᎸ", "ᏚᎦᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvracející obličej"),
            keywords: &[
                "smajlík",
                "tvář",
                "výraz",
                "zvracející obličej",
                "zvracet",
                "špatně",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn chwydu"),
            keywords: &["chwyd", "sic", "wyneb yn chwydu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt, der kaster op"),
            keywords: &["ansigt, der kaster op", "opkast", "syg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kotzendes Gesicht"),
            keywords: &["kotzen", "kotzendes Gesicht", "krank"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο που κάνει εμετό"),
            keywords: &["εμετός", "πρόσωπο που κάνει εμετό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face vomiting"),
            keywords: &["face vomiting", "puke", "sick", "vomit"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara vomitando"),
            keywords: &["cara vomitando", "enfermo", "malo", "vomitar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oksendav nägu"),
            keywords: &["iiveldus", "okse", "oksendav nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("goitika ari den aurpegi"),
            keywords: &["gaixo", "goitika", "goitika ari den aurpegi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درحال استفراغ"),
            keywords: &[
                "استفراغ",
                "بالا آوردن",
                "درحال استفراغ",
                "دچار تهوع",
                "مریض",
                "ناخوش",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oksentava"),
            keywords: &["naama", "oksentaa", "oksentava", "pahoinvointi", "yrjötä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukha na nagsusuka"),
            keywords: &["mukha na nagsusuka", "nasusuka", "suka"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spýggjandi andlit"),
            keywords: &["andlit", "sjóverk", "spýggj", "spýggjandi andlit", "vaml"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui vomit"),
            keywords: &["malade", "visage qui vomit", "vomi", "vomissure"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag cur amach"),
            keywords: &[
                "aghaidh ag cur amach",
                "straoiseog ag cur amach",
                "tinn",
                "urlacan",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ cur a-mach"),
            keywords: &[
                "aodann a’ cur a-mach",
                "bochd",
                "cuir a-mach",
                "cur a-mach",
                "tinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara vomitando"),
            keywords: &["cara", "cara vomitando", "noxo", "vomitar", "vómito"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉલટી કરતો ચહ\u{ac7}રો"),
            keywords: &["ઉલટી કરતો ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska yin amai"),
            keywords: &["amai", "fuska yin amai", "maras lafiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מקיא"),
            keywords: &["בחילה", "הקאה", "פרצוף מקיא"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उल\u{94d}टी करता ह\u{941}आ च\u{947}हरा"),
            keywords: &[
                "उबकाई",
                "उल\u{94d}टी",
                "उल\u{94d}टी करता ह\u{941}आ च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje povraća"),
            keywords: &["bolest", "lice koje povraća", "povraćanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hányó arc"),
            keywords: &["beteg", "hány", "hányó arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փսխող դեմք"),
            keywords: &["սրտխառնոց", "փսխող դեմք", "փսխում"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah muntah"),
            keywords: &["muntah", "sakit", "wajah muntah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu na-agbọ agbọ"),
            keywords: &["ihu na-agbọ agbọ", "ọgbụgbọ", "ọrịa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ælandi andlit"),
            keywords: &["veikindi", "æla", "ælandi andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che vomita"),
            keywords: &["faccina che vomita", "nausea", "vomito"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("嘔吐する顔"),
            keywords: &["げろ", "嘔吐する顔", "気持ち悪い", "病気", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mutah-mutah"),
            keywords: &["lara", "mutah", "rai mutah-mutah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ღებინება"),
            keywords: &["გულისრევა", "ღებინება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құсу"),
            keywords: &["ауыру", "құсу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខចង\u{17cb}ក\u{17d2}អ\u{17bd}ត"),
            keywords: &[
                "ក\u{17d2}អ\u{17bd}ត",
                "ឈ\u{17ba}",
                "ម\u{17bb}ខចង\u{17cb}ក\u{17d2}អ\u{17bd}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವಾಂತ\u{cbf} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಅನಾರೋಗ\u{ccd}ಯ",
                "ವಾಂತ\u{cbf}",
                "ವಾಂತ\u{cbf} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
                "ವಾಂತ\u{cbf} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವಂತ\u{cc6} ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("토하는 얼굴"),
            keywords: &["토", "토하는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओ\u{902}कारो य\u{947}वपी च\u{947}रो"),
            keywords: &[
                "ओ\u{902}कारी",
                "ओ\u{902}कारो य\u{947}वपी च\u{947}रो",
                "द\u{941}य\u{947}\u{902}त",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кусуп жаткан жүз"),
            keywords: &["жүрөгү айлануу", "кусуп жаткан жүз", "кусуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht wat sech iwwergëtt"),
            keywords: &["Gesiicht wat sech iwwergëtt", "iwwerginn", "krank"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າອາຈຽນ"),
            keywords: &["ປ\u{ec8}ວຍ", "ອາຈານ", "ໜ\u{ec9}າອາຈຽນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vemiantis veidas"),
            keywords: &["liga", "vemiantis veidas", "vemti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vemjoša seja"),
            keywords: &["nelabums", "slimība", "vemjoša seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi ruaki"),
            keywords: &["kanohi ruaki", "mate", "ruaki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице повраќа"),
            keywords: &["болен", "лице повраќа", "повраќање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഛർദ\u{d4d}ദിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "അസ\u{d41}ഖം",
                "ഛർദ\u{d4d}ദി",
                "ഛർദ\u{d4d}ദിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөөлжсөн царай"),
            keywords: &["бөөлжих", "бөөлжсөн царай", "өвчтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ओकणारा च\u{947}हरा"),
            keywords: &["आजारी", "ओकणारा च\u{947}हरा", "ओकारी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka muntah"),
            keywords: &["loya", "muka muntah", "muntah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ qed jirremetti"),
            keywords: &["mard", "remettar", "wiċċ qed jirremetti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အန\u{103a}ထ\u{103d}က\u{103a}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ဖျားနာခြင\u{103a}း",
                "အန\u{103a}ထ\u{103d}က\u{103a}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "အန\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "အန\u{103a}သည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kaster opp"),
            keywords: &["fjes", "kaster opp", "kvalm", "oppkast", "spy"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बान\u{94d}ता गर\u{94d}द\u{948} गर\u{947}को अन\u{941}हार"),
            keywords: &[
                "बान\u{94d}ता",
                "बान\u{94d}ता गर\u{94d}द\u{948} गर\u{947}को अन\u{941}हार",
                "बिरामी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("brakend gezicht"),
            keywords: &["braaksel", "brakend gezicht", "ziek"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kastar opp"),
            keywords: &["fjes", "kastar opp", "kvalm", "oppkast", "spy"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ନ\u{b4d}ତ\u{b3f} କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ବ\u{b3e}ନ\u{b4d}ତ\u{b3f}",
                "ବ\u{b3e}ନ\u{b4d}ତ\u{b3f} କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ରୋଗ\u{b3f}ଣ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉਲਟੀ ਕਰਦਾ ਚਿਹਰਾ"),
            keywords: &["ਉਲਟੀ", "ਉਲਟੀ ਕਰਦਾ ਚਿਹਰਾ", "ਬਿਮਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آلٹی آن آلی شکل"),
            keywords: &["آلٹی آن آلی شکل", "ا\u{64f}لٹی", "علیل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Vọmit"),
            keywords: &["Fes Wé De Vọmit", "Sik", "Vọmit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wymiotująca twarz"),
            keywords: &["chory", "wymiotująca twarz", "wymioty"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("قی کوونکی مخ"),
            keywords: &["قي کول", "قی کوونکی مخ", "ناروغه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto vomitando"),
            keywords: &["doente", "rosto vomitando", "vômito"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a vomitar"),
            keywords: &["cara a vomitar", "doente", "vomitar", "vómito"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("q’ipina uya"),
            keywords: &["qʼipina", "qʼipina uya", "q’ipina uya", "unqusqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față vomitând"),
            keywords: &["față vomitând", "greață", "vomă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1040"),
            keywords: &["E10-1040"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рвота"),
            keywords: &["блевать", "рвота", "тошнит", "тошнота"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura y’umuntu uri kuruka"),
            keywords: &["isura y’umuntu uri kuruka", "kuruka", "kurwara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چهرو الٽي ڪندي"),
            keywords: &["الٽي", "بيمار", "چهرو الٽي ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වමනය යන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &["අසන\u{dd3}පය\u{dd2}", "වමනය", "වමනය යන ම\u{dd4}හ\u{dd4}ණ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár, ktorá vracia"),
            keywords: &["tvár, ktorá vracia", "vracať", "zle"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki bruha"),
            keywords: &["obraz, ki bruha"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji mantaq leh"),
            keywords: &["jirro", "mantaq", "waji mantaq leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që vjell"),
            keywords: &["fytyrë që vjell", "sëmurë", "vjellje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице повраћа"),
            keywords: &["лице повраћа", "мучнина", "повраћање"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice povraća"),
            keywords: &["lice povraća", "mučnina", "povraćanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kräkande ansikte"),
            keywords: &[
                "ansikte som kräks",
                "illamående",
                "kräkande ansikte",
                "kräker",
                "kräkning",
                "kräks",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotapika"),
            keywords: &["mgonjwa", "tapika", "uso unaotapika"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ந\u{bcd}தி எடுக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "க\u{bbe}ய\u{bcd}ச\u{bcd}சல\u{bcd}",
                "நோய\u{bcd}",
                "வ\u{bbe}ந\u{bcd}தி",
                "வ\u{bbe}ந\u{bcd}தி எடுக\u{bcd}கும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3e}ంత\u{c3f} చ\u{c47}సుకుంటున\u{c4d}న ముఖం"),
            keywords: &[
                "అన\u{c3e}ర\u{c4b}గ\u{c4d}యం",
                "వ\u{c3e}ంత\u{c3f}",
                "వ\u{c3e}ంత\u{c3f} చ\u{c47}సుకుంటున\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи партофта истода"),
            keywords: &["бемор", "партофтан", "рӯи партофта истода"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าอาเจ\u{e35}ยน"),
            keywords: &["ป\u{e48}วย", "หน\u{e49}าอาเจ\u{e35}ยน", "อ\u{e49}วก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gusýan ýüz"),
            keywords: &["gusmak", "gusýan ýüz", "hassa"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lua"),
            keywords: &["mata lua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kusan yüz"),
            keywords: &["hasta", "istifra", "kusan yüz", "kusmak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇسقان چىراي"),
            keywords: &["قۇسقان چىراي", "قۇسۇش", "كېسەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що блює"),
            keywords: &["блювота", "нудота", "обличчя, що блює"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قے کرتا چہرہ"),
            keywords: &["بیمار", "قے", "قے کرتا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qusish"),
            keywords: &["qusish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt nôn mửa"),
            keywords: &["mặt nôn mửa", "nôn mửa", "ốm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy waccu"),
            keywords: &["feebar", "kanam guy waccu", "waccu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obugabhayo"),
            keywords: &["ubuso obugabhayo", "ukugabha", "ukugula"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Èébì ajẹmọ\u{301}jú"),
            keywords: &["Èébì ajẹmọ\u{301}jú", "àìsàn", "èébì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嘔吐嘅臉"),
            keywords: &["嘔吐", "嘔吐嘅臉", "病"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("呕吐嘅脸"),
            keywords: &["呕吐", "呕吐嘅脸", "病"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("呕吐"),
            keywords: &["不舒服", "呕吐", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("狂吐中"),
            keywords: &["吐", "吐臉", "狂吐中", "病懨懨"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("嘔吐"),
            keywords: &["吐", "嘔吐", "生病"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuphalazayo"),
            keywords: &["gula", "phalaza", "ubuso obuphalazayo"],
        },
    ],
};
#[doc = "🤧"]
pub const SNEEZING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤧",
    codepoint: "1F927",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "sneezing face",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat nies"),
            keywords: &["atsjoe", "gesig", "gesig wat nies", "nies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚያስነጥስ ፊት"),
            keywords: &["መልካም ጤና", "ማስነጠስ", "የሚያስነጥስ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يعطس"),
            keywords: &["عطس", "وجه يعطس", "يرحمك الله", "يرحمكم الله"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}\u{981}চিওৱ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ম\u{9c1}খ",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য",
                "হ\u{9be}\u{981}চি",
                "হ\u{9be}\u{981}চিওৱ\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("asqıran üz"),
            keywords: &["asqıran üz", "asqırmaq", "qrip", "sifət", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чхае"),
            keywords: &["твар", "чхае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кихащо лице"),
            keywords: &["кихане", "кихащо лице", "лице", "наздраве"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}\u{981}চি"),
            keywords: &["ভ\u{9be}ল থ\u{9be}ক", "ম\u{9c1}খ", "হ\u{9be}\u{981}চি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kihanje"),
            keywords: &["kihanje", "lice", "nazdravlje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que esternuda"),
            keywords: &[
                "cara",
                "cara que esternuda",
                "constipat",
                "esternudant",
                "esternut",
                "mocs",
                "salut",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏴᏍᏙᏍᎩ ᎤᎧᏔ"),
            keywords: &["ᎠᏗᏴᎳᏛᏍᎩ ᏗᏁᏟᏙᏗ", "ᎤᎧᏛ", "ᏚᏴᏍᏙᏍᎬᎢ", "ᏧᏴᏍᏙᏍᎩ ᎤᎧᏔ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kýchající obličej"),
            keywords: &["kýchající obličej", "kýchat", "smajlík", "tvář", "výraz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb tisian"),
            keywords: &["gesundheit", "tisian", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nysende ansigt"),
            keywords: &[
                "forkølet",
                "lommetørklæde",
                "nys",
                "nysende ansigt",
                "nyser",
                "prosit",
                "pudser næse",
                "syg",
                "sygdom",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("niesendes Gesicht"),
            keywords: &["Gesicht", "niesen", "niesendes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φταρνίζομαι"),
            keywords: &["πρόσωπο", "υγεία", "φτάρνισμα", "φταρνίζομαι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sneezing face"),
            keywords: &["face", "gesundheit", "sneeze", "sneezing face"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["bless you", "face", "gesundheit", "sneeze"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["bless you", "face", "gesundheit", "sneeze", "sneezing face"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara estornudando"),
            keywords: &[
                "cara",
                "cara estornudando",
                "estornudar",
                "estornudo",
                "pañuelo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de estornudo"),
            keywords: &[
                "cara",
                "cara de estornudo",
                "estornudar",
                "estornudo",
                "resfrío",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara estornudando"),
            keywords: &[
                "cara",
                "cara estornudando",
                "estornudar",
                "estornudo",
                "resfrío",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara estornudando"),
            keywords: &[
                "cara",
                "cara estornudando",
                "estornudar",
                "estornudo",
                "resfrío",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aevastav nägu"),
            keywords: &["aevastav nägu", "aevastus", "nägu", "terviseks"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegia mukiak kentzen"),
            keywords: &["aurpegi", "aurpegia mukiak kentzen", "kendu", "muki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عطسه"),
            keywords: &["خیر باشد", "درحال عطسه", "صورت", "عافیت باشد", "عطسه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aivastava"),
            keywords: &[
                "aivastaa",
                "aivastava",
                "aivastus",
                "kasvot",
                "naama",
                "terveydeksi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bumabahing"),
            keywords: &["bahing", "bumabahing", "mukha"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("njósandi andlit"),
            keywords: &["andlit", "njós", "njósandi andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui éternue"),
            keywords: &[
                "atchoum",
                "rhume",
                "visage",
                "visage qui éternue",
                "éternuement",
                "éternuer",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage qui éternue"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag sraotharthach"),
            keywords: &["aghaidh", "sraoth", "straoiseog ag sraotharthach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann ri sreothairt"),
            keywords: &["aodann", "aodann ri sreothairt", "dia leat", "sreothairt"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara acatarrada"),
            keywords: &[
                "acatarrada",
                "arrefriado",
                "cara acatarrada",
                "catarreira",
                "mocos",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છી\u{a82}ક ખાતો ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "છી\u{a82}ક", "છી\u{a82}ક ખાતો ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai yin atishawa"),
            keywords: &["atishawa", "fuska", "fuska mai yin atishawa", "geshundheit"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מקנח אף"),
            keywords: &["אף", "מקנח", "מתעטש", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छी\u{902}कता च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "छी\u{902}क", "छी\u{902}कता च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje kiše"),
            keywords: &["kihanje", "lice", "lice koje kiše", "nazdravlje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tüsszentő arc"),
            keywords: &["fej", "hapci", "tüsszent", "tüsszentő", "tüsszentő arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փռշտացող դեմք"),
            keywords: &["դեմք", "փռշտացող դեմք", "փռշտոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bersin"),
            keywords: &["bersin", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nfụkọ"),
            keywords: &["gesundheit", "ihu", "ihu nfụkọ", "ntụfọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnerrandi andlit"),
            keywords: &["andlit", "hnerra", "hnerrandi andlit", "hnerri", "kvef"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che starnutisce"),
            keywords: &[
                "faccina",
                "faccina che starnutisce",
                "raffreddore",
                "starnuto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("くしゃみする顔"),
            keywords: &["くしゃみ", "くしゃみする顔", "花粉症", "顔", "風邪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai wahing"),
            keywords: &["mugi gusti paring sehat", "rai", "wahing"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცემინება"),
            keywords: &["სახე", "სიცოცხლე", "ცემინება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түшкіру"),
            keywords: &["бет", "түшкіру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nysende ansigt"),
            keywords: &[
                "forkølet",
                "lommetørklæde",
                "nys",
                "nysende ansigt",
                "nyser",
                "prosit",
                "pudser næse",
                "syg",
                "sygdom",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខកណ\u{17d2}តាស\u{17cb}"),
            keywords: &[
                "កណ\u{17d2}តាស",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខកណ\u{17d2}តាស\u{17cb}",
                "ស\u{17d2}បើយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೀನುವ ಮುಖ"),
            keywords: &["ಜ\u{cc6}ಸುಂದೇಟ\u{ccd}", "ಮುಖ", "ಸೀನು", "ಸೀನುವ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("재채기하는 얼굴"),
            keywords: &["얼굴", "에취", "재채기", "재채기하는 얼굴", "휴지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शि\u{902}कपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "द\u{947}व भोगस\u{942}\u{902}",
                "शि\u{902}कता",
                "शि\u{902}कपी च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бышкырып жаткан бет"),
            keywords: &["бет", "бышкыруу", "бышкырып жаткан бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("néitsend Gesiicht"),
            keywords: &["Gesiicht", "Gesondheet", "néitsen", "néitsend Gesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າກຳລ\u{eb1}ງຈາມ"),
            keywords: &[
                "ຈາມ",
                "ຫ\u{eb1}ດຊ\u{eb4}\u{ec9}ວ",
                "ຮ\u{eb1}ດຊ\u{eb4}ວ",
                "ຮ\u{eb1}ດຊ\u{eb4}\u{ec9}ວ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າກຳລ\u{eb1}ງຈາມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("čiaudantis veidas"),
            keywords: &["veidas", "čiaudantis veidas", "čiaudulys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šķauda"),
            keywords: &["seja", "šķauda"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi matihe"),
            keywords: &["kanohi", "matihe", "ngā manaaki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кивање"),
            keywords: &["кивање", "лице", "лице кое кива", "на здравје"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}ക\u{d4d}കൊലിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "ത\u{d41}മ\u{d4d}മൽ",
                "മ\u{d41}ഖം",
                "മ\u{d42}ക\u{d4d}കൊലിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മ\u{d42}ക\u{d4d}കൊലിപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("найтаах царай"),
            keywords: &["найтаах", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शि\u{902}कत असतानाचा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "तब\u{94d}य\u{947}तीसाठी श\u{941}भ\u{947}च\u{94d}छा द\u{947}ण\u{947}",
                "शि\u{902}कण\u{947}",
                "शि\u{902}कत असतानाचा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bersin"),
            keywords: &["bersin", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jagħtas"),
            keywords: &["gesundheit", "għatsa", "wiċċ", "wiċċ jagħtas"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}ာချေသည\u{1037}\u{103a}ရ\u{102f}ပ\u{103a}"),
            keywords: &[
                "ဆ\u{102d}တ\u{103a}ဖ\u{103d}ား",
                "န\u{103e}ာချေသည\u{1037}\u{103a}ရ\u{102f}ပ\u{103a}",
                "န\u{103e}ာချေသည\u{103a}",
                "ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nyser"),
            keywords: &["fjes", "nys", "nyser"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हाच\u{94d}छिउ\u{901} गर\u{947}को अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "जिस\u{941}नडिहाइट",
                "हाच\u{94d}छिउ\u{901}",
                "हाच\u{94d}छिउ\u{901} गर\u{947}को अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("niezend gezicht"),
            keywords: &["gezicht", "gezondheid", "niezen", "niezend gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nys"),
            keywords: &["fjes", "nys"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛ\u{b3f}ଙ\u{b4d}କ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଛ\u{b3f}ଙ\u{b4d}କ\u{b3f}ବ\u{b3e}",
                "ଛ\u{b3f}ଙ\u{b4d}କ\u{b3f}ବ\u{b3e} ବେଳେ ଶ\u{b41}ଭ ମନ\u{b3e}ସ\u{b3f}ବ\u{b3e}",
                "ଛ\u{b3f}ଙ\u{b4d}କ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛਿ\u{a71}ਕਦਾ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਛਿ\u{a71}ਕ", "ਛਿ\u{a71}ਕਦਾ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چھیک ماردی شکل"),
            keywords: &[
                "دی شکل",
                "صحت مندی لئی دعائیہ کلمہ",
                "چھیک",
                "چھیک ماردی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Sniz"),
            keywords: &["Blẹ\u{301}s Yu", "Fes", "Fes Wé De Sniz", "Sniz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kichająca twarz"),
            keywords: &[
                "katar",
                "kichająca twarz",
                "kichać",
                "na zdrowie",
                "smarkanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پرنجېدونکی مخ"),
            keywords: &["مخ", "پرنجېدل", "پرنجېدونکی مخ", "ګيسونهيټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto espirrando"),
            keywords: &["espirrando", "espirro", "rosto espirrando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a espirrar"),
            keywords: &["cara", "cara a espirrar", "espirro", "santinho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("jachisqa uya"),
            keywords: &["gesundheit", "jachisqa uya", "jachiy", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față care strănută"),
            keywords: &["față", "față care strănută", "noroc", "strănut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1033"),
            keywords: &["E10-1033"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чихает"),
            keywords: &["апчхи", "лицо", "насморк", "пчхи", "чихает"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yitsamura"),
            keywords: &["isura", "kwitsamura", "yitsamura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇڪ ڏيندڙ چهرو"),
            keywords: &["صحت", "نڇ", "چهرو", "ڇڪ ڏيندڙ چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd2}ඹ\u{dd4}හ\u{dd4}ම\u{dca} යවන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ක\u{dd2}ඹ\u{dd4}හ\u{dd4}ම",
                "ක\u{dd2}ඹ\u{dd4}හ\u{dd4}ම\u{dca} යවන ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kýchajúca tvár"),
            keywords: &["kýchajúca tvár", "kýchať", "kýchnutie", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki kiha"),
            keywords: &["kihanje", "na zdravje", "obraz, ki kiha"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji hindhisaayo"),
            keywords: &[
                "hindhisho",
                "u rajeyn caafimaad",
                "waji",
                "waji hindhisaayo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me teshtitje"),
            keywords: &["fytyrë", "fytyrë me teshtitje", "i sëmurë", "teshtitje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које кија"),
            keywords: &["кијање", "лице", "лице које кија", "наздравље"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje kija"),
            keywords: &["kijanje", "lice", "lice koje kija", "nazdravlje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nysande ansikte"),
            keywords: &["ansikte", "nysa", "nysande ansikte", "prosit"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kupiga chafya"),
            keywords: &["gesundheit", "kupiga chafya", "uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தும\u{bcd}முகின\u{bcd}ற முகம\u{bcd}"),
            keywords: &[
                "தும\u{bcd}மல\u{bcd}",
                "தும\u{bcd}முகின\u{bcd}ற முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తుమ\u{c4d}ముతున\u{c4d}న ముఖం"),
            keywords: &[
                "చ\u{c40}దుట",
                "తుమ\u{c4d}ము",
                "తుమ\u{c4d}ముతున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Рӯи атсазананда"),
            keywords: &["Рӯи атсазананда", "атса задан", "рӯй", "саломат бошед"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จาม"),
            keywords: &[
                "จาม",
                "ป\u{e48}วย",
                "หว\u{e31}ด",
                "ฮ\u{e31}ดเช\u{e49}ย",
                "ใครบ\u{e48}นถ\u{e36}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("asgyrýan ýüz"),
            keywords: &["asgyrmak", "asgyrýan ýüz", "tüýkülik", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata mafatua"),
            keywords: &["mata mafatua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hapşıran yüz"),
            keywords: &["hapşıran yüz", "hapşırma", "yüz", "çok yaşa"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چۈشكۈرگەن چىراي"),
            keywords: &["ماڭقا", "چىراي", "چۈشكۈرگەن چىراي", "چۈشكۈرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що чхає"),
            keywords: &["апчхи", "обличчя", "обличчя, що чхає", "хвороба", "чхання"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چھینکیں مارتا چہرہ"),
            keywords: &["بیماری", "چھینک", "چھینکیں مارتا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aksirayotgan"),
            keywords: &["aksirayotgan", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt hắt hơi"),
            keywords: &["hắt hơi", "mặt", "mặt hắt hơi", "sức khỏe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu tissooli"),
            keywords: &["gu jéggi dayo", "kanamu", "tissooli"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuthimlayo"),
            keywords: &["u-gesundheit", "ubuso", "ubuso obuthimlayo", "ukuthimla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Sinsin"),
            keywords: &["Oju Sinsin", "gesundheit", "ojú", "sín"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打乞嚏的臉"),
            keywords: &["乞嚏", "健康", "打乞嚏的臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打乞嚏的脸"),
            keywords: &["乞嚏", "健康", "打乞嚏的脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打喷嚏"),
            keywords: &["喷嚏", "打喷嚏", "脸", "鼻涕"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("打噴嚏"),
            keywords: &["噴", "嚏", "打", "打噴嚏"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("打乞嚏"),
            keywords: &["噴嚏", "打乞嚏"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuthimula"),
            keywords: &["impilo", "thimula", "ubuso", "ukuthimula"],
        },
    ],
};
#[doc = "🥵"]
pub const HOT_FACE: crate::Emoji = crate::Emoji {
    glyph: "🥵",
    codepoint: "1F975",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "hot face",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("warm gesig"),
            keywords: &[
                "hitte-uitputting",
                "koorsig",
                "rooi gesig",
                "sweet",
                "warm",
                "warm gesig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቀላ ፊት"),
            keywords: &["ሙቀት", "ማላብ", "ቀይ ፊት", "የሙቀት ግፊት", "የቀላ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه حار"),
            keywords: &[
                "حار",
                "ضربة شمس",
                "محموم",
                "وجه بلون أحمر",
                "وجه حار",
                "يعرق",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অত\u{9cd}যন\u{9cd}ত গৰমত জিভ\u{9be} মেলি পেলোৱ\u{9be} চেহেৰ\u{9be}"),
            keywords: &[
                "অত\u{9cd}যন\u{9cd}ত গৰমত জিভ\u{9be} মেলি পেলোৱ\u{9be} চেহেৰ\u{9be}",
                "গৰম",
                "ঘৰ\u{9cd}ম\u{9be}ক\u{9cd}ত",
                "চৰ\u{9cd}দি-গৰম",
                "জ\u{9cd}বৰ\u{9be}ক\u{9cd}ৰ\u{9be}ন\u{9cd}ত",
                "ৰঙ\u{9be} পৰ\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pörtləmiş üz"),
            keywords: &[
                "hot",
                "istivurma",
                "pörtləmiş üz",
                "qızarmış üz",
                "qızdırma",
                "tərləmə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гарачы твар"),
            keywords: &[
                "гарачы твар",
                "горача",
                "ліхаманка",
                "перагрэў",
                "пот",
                "чырвоны твар",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зачервено лице"),
            keywords: &[
                "горещина",
                "зачервено лице",
                "зачервяване",
                "температура",
                "топлинен удар",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গরমে ঘ\u{9be}ম ঝর\u{9be} ল\u{9be}ল ম\u{9c1}খ"),
            keywords: &[
                "গরম",
                "গরমে ঘ\u{9be}ম ঝর\u{9be} ল\u{9be}ল ম\u{9c1}খ",
                "ঘ\u{9be}ম ঝরছে",
                "জ\u{9cd}বর জ\u{9cd}বর",
                "ল\u{9be}ল-ম\u{9c1}খয\u{9c1}ক\u{9cd}ত",
                "হিট স\u{9cd}ট\u{9cd}রোক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pregrijano lice"),
            keywords: &[
                "crveno lice",
                "groznica",
                "pregrijano lice",
                "toplotni udar",
                "vruće",
                "znoj",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de calor"),
            keywords: &["calor", "cara de calor", "cara vermella", "febre", "suor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏗᏞᎦ ᎤᎧᏛ"),
            keywords: &[
                "ᎠᎵ ᏓᏓᏑᎶ",
                "ᎤᏗᎴᎬ ᎤᎸᏓᎸᏅ",
                "ᎤᏗᎴᎲᏍᎩ",
                "ᎤᏗᏞᎦ",
                "ᎤᏗᏞᎦ ᎤᎧᏛ",
                "ᎩᎦᎨ-ᎤᎧᏛᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rozpálený obličej"),
            keywords: &[
                "horečka",
                "horko",
                "pocení",
                "rozpálený obličej",
                "rudý obličej",
                "vedro",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb poeth"),
            keywords: &[
                "chwysu",
                "llawn twymyn",
                "poeth",
                "trawiad gwres",
                "wyneb poeth",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("svedende ansigt"),
            keywords: &[
                "feber",
                "hedeslag",
                "rød i hovedet",
                "svede",
                "svedende ansigt",
                "varm",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwitzendes Gesicht"),
            keywords: &[
                "Fieber",
                "Hitzschlag",
                "erhitzt",
                "heiß",
                "schwitzen",
                "schwitzendes Gesicht",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["schwitzendes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζεστό προσωπάκι"),
            keywords: &["ζεστό προσωπάκι", "θερμοπληξία", "πυρετός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hot face"),
            keywords: &[
                "feverish",
                "heat stroke",
                "hot",
                "hot face",
                "red-faced",
                "sweating",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("hot face"),
            keywords: &[
                "feverish",
                "flushed",
                "heat stroke",
                "hot",
                "hot face",
                "red-faced",
                "sweating",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con calor"),
            keywords: &[
                "calor",
                "cara con calor",
                "cara roja",
                "fiebre",
                "golpe de calor",
                "sudor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara de calor"),
            keywords: &[
                "calor",
                "cara colorada",
                "cara de calor",
                "fiebre",
                "golpe de calor",
                "sudor",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara de calor"),
            keywords: &["cara de calor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("higistav nägu"),
            keywords: &[
                "higistav",
                "higistav nägu",
                "kuumarabandus",
                "näost punane",
                "palavikuline",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bero-bero dagoen aurpegia"),
            keywords: &[
                "bero",
                "bero-bero dagoen aurpegia",
                "bero-kolpe",
                "gorritu",
                "izerditan",
                "sukartsu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خیلی گرم"),
            keywords: &[
                "برافروخته",
                "تب\u{200c}دار",
                "خیلی گرم",
                "داغ",
                "عرق\u{200c}کرده",
                "قرمزشده",
                "گرمازده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuumottava"),
            keywords: &[
                "hikoilee",
                "kuumeinen",
                "kuumissaan",
                "kuumottava",
                "lämpöhalvaus",
                "punanaama",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mainit na mukha"),
            keywords: &[
                "atake",
                "feverish",
                "mainit",
                "mainit na mukha",
                "mukhang-pula",
                "pinapawisan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heitt andlit"),
            keywords: &["fepur", "heitt", "heitt andlit", "hitasótt", "sveitti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage rouge et chaud"),
            keywords: &[
                "chaud",
                "coup de chaleur",
                "fièvre",
                "transpiration",
                "visage rouge et chaud",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "canicule",
                "chaud",
                "fièvre",
                "rouge",
                "sueur",
                "visage",
                "visage rouge et chaud",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog the"),
            keywords: &[
                "ag cur allais",
                "fiabhrasach",
                "straoiseog dhearg",
                "straoiseog the",
                "stróc treasa",
                "te",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann teth"),
            keywords: &[
                "aodann dearg",
                "aodann teth",
                "a’ cur fallas",
                "fallas",
                "fiabhras",
                "teas",
                "teth",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de calor"),
            keywords: &["calor", "cara de calor", "febre", "golpe de calor", "suar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલચોળ ચહ\u{ac7}રો"),
            keywords: &["લાલચોળ ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מת מחום"),
            keywords: &["חולה", "מזיע", "מכת חום", "מת מחום", "פרצוף אדום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गर\u{94d}मी स\u{947} लाल च\u{947}हरा"),
            keywords: &[
                "गर\u{94d}म",
                "गर\u{94d}मी स\u{947} लाल च\u{947}हरा",
                "तपता ह\u{941}आ च\u{947}हरा",
                "ब\u{941}खार",
                "ल\u{942} लगना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pregrijano lice"),
            keywords: &[
                "crveno lice",
                "pregrijano lice",
                "toplinski udar",
                "vruće",
                "vrućica",
                "znoj",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("forró arc"),
            keywords: &[
                "forró arc",
                "forróság",
                "hőguta",
                "izzadó",
                "lázas",
                "vörös arcú",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շոգած դեմք"),
            keywords: &[
                "հիվանդ",
                "շոգ",
                "շոգած դեմք",
                "ջերմություն",
                "տաքություն",
                "տենդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah kepanasan"),
            keywords: &[
                "berkeringat",
                "demam",
                "kepanasan",
                "muka merah",
                "panas",
                "wajah kepanasan",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heitt"),
            keywords: &[
                "heitt",
                "með hita",
                "rauður í framan",
                "sviti",
                "sólstingur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina accaldata"),
            keywords: &[
                "caldo",
                "faccina accaldata",
                "faccina sudata",
                "febbricitante",
                "sudore",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("暑い顔"),
            keywords: &["暑い顔", "暑さ", "汗", "熱中症", "発熱", "赤い顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai panas"),
            keywords: &[
                "abang mbranang",
                "kemringet",
                "kepanasen",
                "ndrodhog",
                "panas",
                "rai panas",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცხელი სახე"),
            keywords: &["დასიცხული", "სიცხიანი", "ცხელი", "ცხელი სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ыстықтаған бет"),
            keywords: &[
                "жылу соққысы",
                "терлеп тұр",
                "ыстық",
                "ыстықтаған бет",
                "қызарған",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17d2}ដៅ"),
            keywords: &[
                "ក\u{17d2}ដៅ",
                "ចង\u{17cb}គ\u{17d2}រ\u{17bb}ន",
                "ចាញ\u{17cb}ថ\u{17d2}ងៃ",
                "បែកញើស",
                "ម\u{17bb}ខក\u{17d2}ដៅ",
                "ម\u{17bb}ខក\u{17d2}រហម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಉರ\u{cbf}ಯ ಮುಖ"),
            keywords: &[
                "ಉರ\u{cbf}ಯ ಮುಖ",
                "ಕ\u{cc6}ಂಪು ಮುಖ",
                "ಜ\u{ccd}ವರ",
                "ಬ\u{cbf}ಸ\u{cbf}",
                "ಬ\u{cbf}ಸ\u{cbf}ಲ\u{cbf}ನ ಹೊಡ\u{cc6}ತ",
                "ಬ\u{cc6}ವರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("더운 얼굴"),
            keywords: &[
                "더운",
                "더운 얼굴",
                "더위 먹은",
                "땀 흘리는",
                "빨개진",
                "열나는",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उष\u{94d}ण च\u{947}रो"),
            keywords: &[
                "उष\u{94d}ण",
                "उष\u{94d}ण च\u{947}रो",
                "उष\u{94d}णत\u{947}चो आघात",
                "घाम य\u{947}ता",
                "जोर आयिल\u{94d}लो",
                "ता\u{902}बडो जाल\u{94d}लो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ысыган жүз"),
            keywords: &[
                "дене табынын жогорулашы",
                "инфаркт",
                "кызарган жүз",
                "тердөө",
                "ысыган жүз",
                "ысык",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໜ\u{ec9}າຮ\u{ec9}ອນໃໝ\u{ec9}"),
            keywords: &[
                "ຄວາມຮ\u{ec9}ອນລອບຕ\u{ebb}ວ",
                "ຮ\u{ec9}ອນ",
                "ເຫ\u{eb7}\u{ec8}ອຍ\u{ec9}ອຍ",
                "ໃບໜ\u{ec9}າຮ\u{ec9}ອນໃໝ\u{ec9}",
                "ໄຂ\u{ec9}ຂ\u{eb7}\u{ec9}ນ",
                "ໜ\u{ec9}າແດງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("įkaitęs veidas"),
            keywords: &[
                "karštas",
                "karščiuojantis",
                "prakaitavimas",
                "raudonveidis",
                "įkaitęs veidas",
                "šilumos smūgis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piesārtusi seja"),
            keywords: &[
                "drudzī",
                "karstuma dūriens",
                "nosvīdis",
                "piesārtusi seja",
                "sarkanu seju",
                "saules dūriens",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице зацрвенето од жештина"),
            keywords: &[
                "жешко",
                "зацрвенето лице",
                "лице зацрвенето од жештина",
                "потење",
                "тополотен удар",
                "трескавично",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d42}ട\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "ച\u{d41}വന\u{d4d}ന മ\u{d41}ഖം",
                "ച\u{d42}ട\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "ച\u{d42}ട\u{d41}ള\u{d4d}ളത\u{d4d}",
                "ച\u{d42}ട\u{d4d}",
                "പനിയ\u{d41}ള\u{d4d}ള",
                "വിയർത\u{d4d}തത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("халууцсан царай"),
            keywords: &[
                "наранд цохиулсан",
                "улайсан царай",
                "халуун",
                "халуунтай",
                "халууцсан царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गरम घाम\u{947}जल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "उष\u{94d}णत\u{947}चा स\u{94d}ट\u{94d}रोक",
                "गरम",
                "गरम घाम\u{947}जल\u{947}ला च\u{947}हरा",
                "घाम",
                "तापय\u{941}क\u{94d}त",
                "लाल-च\u{947}हऱ\u{94d}याचा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka sebak"),
            keywords: &[
                "bermuka merah",
                "berpeluh",
                "muka sebak",
                "panas",
                "rasa demam",
                "strok haba",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါသ မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ဇောချ\u{103d}ေးပြန\u{103a}နေသော",
                "ဒေါသ မျက\u{103a}န\u{103e}ာ",
                "ပ\u{1030}သည\u{103a}",
                "ရ\u{103e}က\u{103a}သ\u{103d}ေးဖြန\u{103a}း မျက\u{103a}န\u{103e}ာ",
                "အပ\u{1030}လျ\u{103e}ပ\u{103a}ခြင\u{103a}း",
                "အဖျားတက\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("varmt fjes"),
            keywords: &["feber", "heteslag", "rød", "svetter", "varm", "varmt fjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हट अन\u{941}हार"),
            keywords: &[
                "ज\u{94d}वरो आए जस\u{94d}तो",
                "तातो",
                "तापको स\u{94d}ट\u{94d}रोक",
                "पसिना आइरह\u{947}को",
                "रातो अन\u{941}हारवाला",
                "हट अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("heet gezicht"),
            keywords: &[
                "heet",
                "heet gezicht",
                "koortsig",
                "rood gezicht",
                "zonnesteek",
                "zweten",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("varmt fjes"),
            keywords: &[
                "feber",
                "heteslag",
                "raud",
                "sveittar",
                "varm",
                "varmt fjes",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ର\u{b3e}ଗ\u{b3f} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଗରମ",
                "ଜର\u{b41}ଆ",
                "ଝ\u{b3e}ଳ\u{b41}ଆ",
                "ନ\u{b3e}ଲ\u{b3f}-ମ\u{b41}ହ\u{b01}",
                "ର\u{b3e}ଗ\u{b3f} ମ\u{b41}ହ\u{b01}",
                "ହ\u{b3f}ଟ\u{b4d}\u{200c} ଷ\u{b4d}ଟ\u{b4d}ରୋକ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਪਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ"),
            keywords: &[
                "ਗਰਮੀ ਨਾਲ ਤਪਿਆ ਚਿਹਰਾ",
                "ਗਰਮੀ ਨਾਲ ਲਾਲ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
                "ਤਪਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
                "ਭਖਿਆ ਚਿਹਰਾ",
                "ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਵਾਲਾ ਚਿਹਰਾ",
                "ਸ\u{a47}ਕ ਦਾ ਮਾਰਿਆ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}t Fes"),
            keywords: &[
                "Fọ Fíva To Hól Yu",
                "Hít Strok",
                "Họt",
                "Họ\u{301}t Fes",
                "Rẹ\u{301}d Fes",
                "Swẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rozgrzana twarz"),
            keywords: &[
                "czerwona buźka",
                "rozgrzana buźka",
                "rozgrzana twarz",
                "rozpalony",
                "spocony",
                "udar cieplny",
                "upał",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تود مخ"),
            keywords: &["تود", "تود مخ", "د تودوخې", "د خولې", "سور مخ", "ګرم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto fervendo de calor"),
            keywords: &[
                "febril",
                "insolação",
                "quente",
                "rosto fervendo de calor",
                "rosto vermelho",
                "suando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com calor"),
            keywords: &[
                "cara com calor",
                "cara vermelha",
                "febril",
                "insolação",
                "quente",
                "transpiração",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼuñi uya"),
            keywords: &[
                "fiebre",
                "jumpʼi",
                "puka uya",
                "qʼuñi",
                "qʼuñi uya",
                "ruphay",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față fierbinte"),
            keywords: &[
                "căldură",
                "față fierbinte",
                "față roșie",
                "febril",
                "fierbinte",
                "transpirație",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-015"),
            keywords: &["E11-015"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жар"),
            keywords: &[
                "болеет",
                "высокая температура",
                "жар",
                "лихорадка",
                "потеет",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("گرم چهرو"),
            keywords: &[
                "بخار نما",
                "هيٽ اسٽروڪ",
                "پگهر ايندڙ",
                "گرم",
                "گرم چهرو",
                "ڳاڙهو-چهري سان",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ඇව\u{dd2}ස\u{dca}ස\u{dd4}ණ\u{dd4}",
                "උණ\u{dd4}ස\u{dd4}ම\u{dca}",
                "ද\u{dcf}ඩ\u{dd2}ය දැම\u{dd3}ම\u{dd2}",
                "රත\u{dca} ව\u{dd6} පහර",
                "රත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "රත\u{dd4} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rozhorúčená tvár"),
            keywords: &[
                "horúco",
                "horúčka",
                "pot",
                "potenie",
                "rozhorúčená tvár",
                "úpal",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vroč obraz"),
            keywords: &[
                "poten",
                "rdeč obraz",
                "vroč obraz",
                "vroče",
                "vročina",
                "vročinska kap",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji kulul"),
            keywords: &[
                "dhididaayo",
                "istarooga kuleylka",
                "kuleyl",
                "waji cas",
                "waji kulul",
                "xummad",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrëkuq"),
            keywords: &["fytyrëkuq", "i djersitur", "i skuqur", "me temperaturë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вруће лице"),
            keywords: &[
                "вруће",
                "вруће лице",
                "знојење",
                "температура",
                "црвено лице",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вруће лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vruće lice"),
            keywords: &[
                "crveno lice",
                "temperatura",
                "vruće",
                "vruće lice",
                "znojenje",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vruće lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hett ansikte"),
            keywords: &[
                "febrig",
                "hett",
                "hett ansikte",
                "rött ansikte",
                "svett",
                "värmeslag",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye joto"),
            keywords: &[
                "homa",
                "joto",
                "joto jingi",
                "kijasho",
                "uso mwekundu",
                "uso wenye joto",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெப\u{bcd}பம\u{bbe}ன முகம\u{bcd}"),
            keywords: &[
                "க\u{bbe}ய\u{bcd}ச\u{bcd}சல\u{bcd}",
                "சிவந\u{bcd}த முகம\u{bcd}",
                "சூடு",
                "வியர\u{bcd}வை",
                "வெப\u{bcd}பப\u{bcd} பக\u{bcd}கவ\u{bbe}தம\u{bcd}",
                "வெப\u{bcd}பம\u{bbe}ன முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}డ\u{c3f}త\u{c4b} ఎర\u{c4d}రబడ\u{c3f}న ముఖం"),
            keywords: &[
                "చ\u{c46}మటలు",
                "జ\u{c4d}వరం",
                "వడద\u{c46}బ\u{c4d}బ",
                "వ\u{c47}డ\u{c3f}",
                "వ\u{c47}డ\u{c3f}త\u{c4b} ఎర\u{c4d}రబడ\u{c3f}న ముఖం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e49}อนมาก"),
            keywords: &[
                "ร\u{e49}อน",
                "ร\u{e49}อนต\u{e31}บแลบ",
                "ร\u{e49}อนมาก",
                "เหง\u{e37}\u{e48}อแตกพล\u{e31}\u{e48}ก",
                "ไข\u{e49}ข\u{e36}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzan ýüz"),
            keywords: &[
                "derli",
                "gyzan ýüz",
                "gyzgyn",
                "gyzgynlyk urgusy",
                "gyzyl ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata vevela"),
            keywords: &["mata vevela"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kızarmış yüz"),
            keywords: &[
                "ateşi çıkmış",
                "kırmızı yüz",
                "kızarmış yüz",
                "sıcak",
                "sıcak çarpması",
                "terleme",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("розпашіле обличчя"),
            keywords: &[
                "гаряче",
                "жар",
                "палати",
                "розпашіле обличчя",
                "сонячний удар",
                "спека",
                "червоне лице",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ چہرہ"),
            keywords: &[
                "ب\u{64f}خار ز\u{64e}دہ",
                "حرارت زدگی",
                "سرخ چہرہ",
                "پسینے سے شرابور",
                "گرم",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("isitma"),
            keywords: &[
                "bezgak",
                "harorat",
                "isitma",
                "isitmalash",
                "terlash",
                "yuqori harorat",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt nóng"),
            keywords: &[
                "mặt nóng",
                "nóng",
                "sốc nhiệt",
                "sốt",
                "đỏ mặt",
                "đổ mồ hôi",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("好熱嘅臉"),
            keywords: &["中暑", "出汗", "好熱嘅臉", "熱", "狂熱", "紅面"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("好热嘅脸"),
            keywords: &["中暑", "出汗", "好热嘅脸", "热", "狂热", "红面"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("脸发烧"),
            keywords: &["出汗", "发烧", "发热", "心狂跳", "脸发烧", "脸红"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("熱臉"),
            keywords: &["好熱", "流汗", "熱臉", "發熱", "臉紅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("熱嘅樣"),
            keywords: &["好熱", "流汗", "熱嘅樣", "發熱", "臉紅"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obushiselwayo"),
            keywords: &[
                "feverish",
                "heat stroke",
                "hot",
                "red-faced",
                "sweating",
                "ubuso obushiselwayo",
            ],
        },
    ],
};
#[doc = "🥶"]
pub const COLD_FACE: crate::Emoji = crate::Emoji {
    glyph: "🥶",
    codepoint: "1F976",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "cold face",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("koue gesig"),
            keywords: &["bibber", "blou gesig", "koud", "koue gesig", "vries"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቀዘቀዘ ፊት"),
            keywords: &["ሰማያዊ ፊት", "ቀዝቃዛ", "በራዳ", "በቅዝቃዜ የተጎዳ አፍንጫ", "የቀዘቀዘ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بارد"),
            keywords: &[
                "بارد",
                "تثليج",
                "رقاقات الثلج",
                "متجمد",
                "وجه بارد",
                "وجه باللون الأزرق",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঠ\u{9be}ণ\u{9cd}ড\u{9be}ত ক\u{981}পনি উঠ\u{9be} চেহেৰ\u{9be}"),
            keywords: &[
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}ত ক\u{981}পনি উঠ\u{9be} চেহেৰ\u{9be}",
                "ত\u{9c1}ষ\u{9be}ৰকণ\u{9be}",
                "নীল\u{9be} পৰ\u{9be} ম\u{9c1}খ",
                "বৰফৰ সম\u{9be}ন ঠ\u{9be}ণ\u{9cd}ড\u{9be} পৰ\u{9be}",
                "হিমিভৱন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("donmuş üz"),
            keywords: &["buz", "donmuş", "donmuş üz", "donvurma", "göy üz", "soyuq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("змерзлы твар"),
            keywords: &[
                "замярзае",
                "змерзлы твар",
                "мароз",
                "сіні твар",
                "холадна",
                "ільдзінкі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("замръзнало лице"),
            keywords: &["замръзнало лице", "лед", "посинял", "студ", "хапещ студ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}য\u{9bc} দ\u{9be}\u{981}ত ক\u{9be}\u{981}প\u{9be} নীল ম\u{9c1}খ",
            ),
            keywords: &[
                "জমিয\u{9bc}ে দেওয\u{9bc}\u{9be}",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}য\u{9bc} দ\u{9be}\u{981}ত ক\u{9be}\u{981}প\u{9be} নীল ম\u{9c1}খ",
                "ত\u{9c1}ষ\u{9be}রিক\u{9be}",
                "নীল-ম\u{9c1}খয\u{9c1}ক\u{9cd}ত",
                "হ\u{9be}ড\u{9bc} ক\u{9be}\u{981}প\u{9be}নো ঠ\u{9be}ন\u{9cd}ড\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ledeno lice"),
            keywords: &[
                "hladnoća",
                "ledenice",
                "ledeno lice",
                "plavo lice",
                "promrzlina",
                "smrzavanje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de fred"),
            keywords: &[
                "cara blava",
                "cara de fred",
                "caramell",
                "fred",
                "gel",
                "glaçat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏴᏜ ᎤᎧᏛ"),
            keywords: &["ᎤᏴᏜ", "ᎤᏴᏜ ᎤᎧᏛ", "ᏌᎪᏂᎨ-ᎤᎧᏛᎢ", "ᏕᎦᏁᏍᏓᎳᏗᎠ", "ᏚᎿᏍᏓᎥ", "ᏧᏁᏍᏓᎶᏒ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zmrzlý obličej"),
            keywords: &[
                "modrý obličej",
                "mráz",
                "promrzlý",
                "rampouchy",
                "zima",
                "zmrzlý obličej",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb oer"),
            keywords: &[
                "clychau iâ",
                "ewinrhew",
                "oer",
                "rhewi",
                "wyneb las",
                "wyneb oer",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("frysende ansigt"),
            keywords: &[
                "blåfrossen",
                "forfrysning",
                "fryse",
                "frysende ansigt",
                "istap",
                "kold",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("frierendes Gesicht"),
            keywords: &[
                "Eiszapfen",
                "Frostbeule",
                "frieren",
                "frierendes Gesicht",
                "kalt",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρυώνω"),
            keywords: &["κρυοπάγημα", "κρυώνω", "κρύο", "παγώνω"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cold face"),
            keywords: &[
                "blue-faced",
                "cold",
                "cold face",
                "freezing",
                "frostbite",
                "icicles",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con frío"),
            keywords: &[
                "cara con frío",
                "cara congelada",
                "congelado",
                "frío",
                "helado",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara de frío"),
            keywords: &[
                "cara azul",
                "cara de frío",
                "congelamiento",
                "frío",
                "helado",
                "tempano",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("külmunud nägu"),
            keywords: &[
                "jääpurikad",
                "jäätuv",
                "külmakahjustus",
                "külmunud",
                "külmunud nägu",
                "näost sinine",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi izoztu"),
            keywords: &["aurpegi izoztu", "hotz", "izoztu", "oso hotz", "urdindu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خیلی سرد"),
            keywords: &[
                "خیلی سرد",
                "سرد",
                "سرمازده",
                "قندیل یخ",
                "کبودشده",
                "یخ\u{200c}زده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("paleleva"),
            keywords: &[
                "jääpuikot",
                "jäätynyt",
                "kylmettynyt",
                "kylmä",
                "paleleva",
                "sininen naama",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malamig na mukha"),
            keywords: &[
                "frostbite",
                "giniginaw",
                "icicles",
                "malamig",
                "malamig na mukha",
                "mukhang asul",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kalt andlit"),
            keywords: &["blátt andlit", "frost", "kalt", "kalt andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage bleu et froid"),
            keywords: &[
                "froid",
                "gelure",
                "glacial",
                "glaçon",
                "visage bleu et froid",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bleu",
                "froid",
                "gelure",
                "gelé",
                "glacial",
                "visage",
                "visage bleu et froid",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog fhuar"),
            keywords: &[
                "coinlíní reo",
                "dó seaca",
                "fuar",
                "préachta",
                "straoiseog fhuar",
                "straoiseog ghrom",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann fuar"),
            keywords: &[
                "aodann fuar",
                "aodann ghorm",
                "deigh",
                "eigheanach",
                "eighreachadh",
                "eighrich",
                "fuar",
                "reòite",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de frío"),
            keywords: &["cara de frío", "conxelado", "frío", "xeado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઠ\u{a82}ડો ચહ\u{ac7}રો"),
            keywords: &[
                "ઠ\u{a82}ડો",
                "ઠ\u{a82}ડો ચહ\u{ac7}રો",
                "થીજાવવ\u{ac1}\u{a82}",
                "ફ\u{acd}રોસ\u{acd}ટબાઇટ",
                "ભ\u{ac2}રો પડી ગય\u{ac7}લો ચહ\u{ac7}રો",
                "લટકતો હિમકણ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("למות מקור"),
            keywords: &["למות מקור", "מת מקור", "פרצוף קר", "קופא", "קרח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठ\u{902}ड स\u{947} जमा ह\u{941}आ च\u{947}हरा"),
            keywords: &[
                "जमा ह\u{941}आ",
                "ठ\u{902}ड स\u{947} जमा ह\u{941}आ च\u{947}हरा",
                "ठ\u{902}ड स\u{947} स\u{941}न\u{94d}न",
                "ठ\u{902}डा",
                "नीला-च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zamrznuto lice"),
            keywords: &[
                "hladno",
                "ledeno",
                "ozebline",
                "plavo lice",
                "zamrznuto lice",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fagyos arc"),
            keywords: &[
                "elkékült arc",
                "fagyos arc",
                "fagyoskodik",
                "fagyás",
                "hideg",
                "jégcsapok",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մրսած դեմք"),
            keywords: &["դեմք", "կապտած", "մրսած", "սառած", "ցուրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah kedinginan"),
            keywords: &[
                "es",
                "kedinginan",
                "menggigil",
                "radang dingin",
                "wajah biru",
                "wajah kedinginan",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kalt"),
            keywords: &["blár í framan", "frostbit", "grýlukerti", "kalt", "ískalt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina congelata"),
            keywords: &[
                "faccina blu",
                "faccina congelata",
                "freddo",
                "gelone",
                "ipotermia",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("寒い顔"),
            keywords: &["しもやけ", "つらら", "凍え", "寒い顔", "寒さ", "青い顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai katisen"),
            keywords: &[
                "atis",
                "kadhemen",
                "mati rasa amarga kadhemen",
                "rai biru katisen",
                "rai katisen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცივი სახე"),
            keywords: &["გაყინვა", "ლურჯი სახე", "ყინული", "ცივი", "ცივი სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаураған бет"),
            keywords: &[
                "жаураған бет",
                "көгерген",
                "мұздату",
                "мұздаған",
                "суық",
                "сүңгі",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខត\u{17d2}រជាក\u{17cb}ឡើងកក"),
            keywords: &[
                "ដ\u{17bb}\u{17c6}ទ\u{17b9}កកកស\u{17d2}រ\u{17bd}ច",
                "ត\u{17d2}រជាក\u{17cb}",
                "ត\u{17d2}រជាក\u{17cb}កក",
                "ត\u{17d2}រជាក\u{17cb}ចង\u{17cb}រលេះដៃជើង",
                "ម\u{17bb}ខត\u{17d2}រជាក\u{17cb}ឡើងកក",
                "ម\u{17bb}ខឡើងស\u{17d2}វាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಂಪು ಮುಖ"),
            keywords: &[
                "ತಂಪು",
                "ತಂಪು ಮುಖ",
                "ನೀರ\u{ccd}ಲಲ\u{ccd}ಲುಗಳು",
                "ನೀಲ\u{cbf} ಮುಖ",
                "ಫ\u{ccd}ರಾಸ\u{ccd}ಟ\u{ccd}\u{200c}ಬೈಟ\u{ccd}",
                "ಫ\u{ccd}ರೀಜ\u{cbf}ಂಗ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("추워하는 얼굴"),
            keywords: &[
                "고드름",
                "동상",
                "새파랗게 질린",
                "얼어붙은",
                "추운",
                "추워하는 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("थ\u{902}ड च\u{947}रो"),
            keywords: &[
                "थ\u{902}ड",
                "थ\u{902}ड च\u{947}रो",
                "निळो-च\u{947}रो",
                "बर\u{94d}फ जावप",
                "हिमबाधा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үшүгөн жүз"),
            keywords: &[
                "көгөргөн жүз",
                "майда муз",
                "муздак",
                "үшүгөн жүз",
                "үшүк алуу",
                "үшүү",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໜ\u{ec9}າຊ\u{eb8}\u{ec8}ມເຢ\u{eb1}ນ"),
            keywords: &[
                "ກ\u{ec9}າມແຂງ",
                "ຊ\u{eb8}\u{ec8}ມເຢ\u{eb1}ນ",
                "ຫຍາດນ\u{ecd}\u{ec9}າແຂງ",
                "ໃບໜ\u{ec9}າຊ\u{eb8}\u{ec8}ມເຢ\u{eb1}ນ",
                "ໜ\u{ec9}າຕ\u{eb7}ງຂ\u{eb7}\u{ec9}ນ",
                "ໜ\u{ec9}າສ\u{eb5}ຟ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sušalęs veidas"),
            keywords: &[
                "mėlynveidis",
                "nušalimas",
                "stingdantis",
                "sušalęs veidas",
                "varvekliai",
                "šaltas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nosalusi seja"),
            keywords: &[
                "apsaldējies",
                "auksts",
                "lāstekas",
                "nosalusi seja",
                "nozilējis",
                "stindzinošs",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("замрзнато лице"),
            keywords: &[
                "замрзнато",
                "замрзнато лице",
                "мразулци",
                "сино лице",
                "студено",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തണ\u{d41}ത\u{d4d}ത മ\u{d41}ഖം"),
            keywords: &[
                "തണ\u{d41}ത\u{d4d}ത മ\u{d41}ഖം",
                "തണ\u{d41}ത\u{d4d}ത\u{d41}മരവിച\u{d4d}ചത\u{d4d}",
                "തണ\u{d41}പ\u{d4d}പ\u{d4d}",
                "നീല മ\u{d41}ഖമ\u{d41}ള\u{d4d}ളത\u{d4d}",
                "മഞ\u{d4d}ഞ\u{d41}പ\u{d3e}ളി",
                "മരവിച\u{d4d}ചത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("даарсан царай"),
            keywords: &[
                "даарсан",
                "даарсан царай",
                "унжсан мөс",
                "хүйтэн",
                "хөлдсөн",
                "хөхөрсөн царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थ\u{902}ड च\u{947}हरा"),
            keywords: &[
                "गोठण\u{947}",
                "थ\u{902}ड",
                "थ\u{902}ड च\u{947}हरा",
                "निळ\u{94d}या-च\u{947}हऱ\u{94d}याचा",
                "बर\u{94d}फाच\u{947} त\u{941}कड\u{947}",
                "हिमबाधा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dingin"),
            keywords: &[
                "bermuka biru",
                "dingin",
                "isikel",
                "luka beku",
                "membeku",
                "muka dingin",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေခ\u{1032} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "န\u{103e}င\u{103a}းက\u{102d}\u{102f}က\u{103a}နာ",
                "ပြာန\u{103e}မ\u{103a}းနေသော မျက\u{103a}န\u{103e}ာ",
                "ရေခ\u{1032} မျက\u{103a}န\u{103e}ာ",
                "ရေခ\u{1032}ပန\u{103a}းဆ\u{103d}\u{1032}",
                "အေးခ\u{1032}ခြင\u{103a}း",
                "အေးခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kaldt fjes"),
            keywords: &["blå", "frost", "fryser", "istapper", "kald", "kaldt fjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिसो अन\u{941}हार"),
            keywords: &[
                "इसिकल\u{94d}स",
                "कठ\u{94d}याङ\u{94d}ग\u{94d}रिदो",
                "चिसो",
                "चिसो अन\u{941}हार",
                "त\u{941}षारोल\u{947} खाएको",
                "नीलो अन\u{941}हारवाला",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("koud gezicht"),
            keywords: &[
                "bevriezing",
                "blauw gezicht",
                "ijspegels",
                "koud",
                "koud gezicht",
                "vriezen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kaldt fjes"),
            keywords: &["blå", "frost", "frys", "istappar", "kald", "kaldt fjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଥଣ\u{b4d}ଡ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅତ\u{b3f} ଥଣ\u{b4d}ଡ\u{b3e}",
                "ଆଇସ\u{b3f}କ\u{b3f}ଲସ\u{b4d}\u{200c}",
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ଥଣ\u{b4d}ଡ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ନୀଳ-ମ\u{b41}ହ\u{b01}",
                "ଫ\u{b4d}ରଷ\u{b4d}ଟବ\u{b3e}ଇଟ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠ\u{a70}ਢਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਕ\u{a71}ਕਰ ਖਾਧਾ ਚਿਹਰਾ",
                "ਠ\u{a70}ਢ ਨਾਲ ਨੀਲਾ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
                "ਠ\u{a70}ਢ ਨਾਲ ਭਾਵਹੀਨ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
                "ਠ\u{a70}ਢਾ ਚਿਹਰਾ",
                "ਬਹ\u{a41}ਤ ਠ\u{a70}ਢਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Kold De Kach"),
            keywords: &[
                "Blú Fes",
                "Fes Wé Kold De Kach",
                "Kold",
                "Lọ\u{301}ng Lọ\u{301}ng Aíz Blọk",
                "Tuú Mọ\u{301}ch Kold",
                "Tuú Mọ\u{301}ch Kold Dáméj Pẹ\u{301}sin Bọdí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zmarznięta twarz"),
            keywords: &[
                "mróz",
                "niebieska twarz",
                "odmrożenie",
                "sopel lodu",
                "zimno",
                "zmarznięta twarz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سوړ مخ"),
            keywords: &[
                "آسماني رنګ مخ",
                "آيسيکل",
                "سوړ",
                "سوړ مخ",
                "کنګل",
                "کنګل شوې",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto gelado"),
            keywords: &[
                "congelando",
                "frio",
                "glacial",
                "gélido",
                "rosto azul de frio",
                "rosto gelado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com frio"),
            keywords: &[
                "cara azul",
                "cara com frio",
                "frieira",
                "frio",
                "gelar",
                "sincelo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chiri uya"),
            keywords: &[
                "anqas uya",
                "chhullunkaa",
                "chiri",
                "chiri uy",
                "chiri uya",
                "khutu",
                "khutuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față înghețată"),
            keywords: &[
                "degerat",
                "față albastră",
                "față înghețată",
                "frig",
                "ger",
                "rece",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-016"),
            keywords: &["E11-016"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мерзнет"),
            keywords: &["замерз", "мерзнет", "морозно", "посинел", "холодно"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿڌو چهرو"),
            keywords: &[
                "icicles",
                "بلو-چهرو",
                "فروسٽ بائيٽ",
                "فريزنگ",
                "ٿڌ",
                "ٿڌو چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd3}තල ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අය\u{dd2}ස\u{dca} ක\u{dd6}ර\u{dd4}",
                "ඉත\u{dcf} ශ\u{dca}\u{200d}ර\u{dd3}තල",
                "න\u{dd2}ල\u{dca} ම\u{dd4}හ\u{dd4}ණැත\u{dd2}",
                "ස\u{dd3}තල ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd3}තලය\u{dd2}",
                "හමේ ඇත\u{dd2}වන ත\u{dd4}ව\u{dcf}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mrznúca tvár"),
            keywords: &["cencúľ", "chladno", "mrznúca tvár", "mráz", "zima"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mrzel obraz"),
            keywords: &[
                "ledene sveče",
                "mrzel",
                "mrzel obraz",
                "ozebline",
                "plav obraz",
                "premražen",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji qaboow"),
            keywords: &[
                "baraf",
                "daalan",
                "qaboobaayo",
                "qaboow",
                "qabow",
                "waji qaboow",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e ngrirë"),
            keywords: &["fytyrë e ngrirë", "fytyrëblu", "i acartë", "i ftohtë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("хладно лице"),
            keywords: &["залеђен", "леденице", "модро лице", "хладно", "хладно лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["хладно лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("hladno lice"),
            keywords: &["hladno", "hladno lice", "ledenice", "modro lice", "zaleđen"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["hladno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kallt ansikte"),
            keywords: &[
                "blått ansikte",
                "frostbiten",
                "frusen",
                "istappar",
                "kall",
                "kallt ansikte",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye baridi"),
            keywords: &[
                "barafu",
                "baridi",
                "kuganda",
                "theluji",
                "uso wa samawati",
                "uso wenye baridi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குளிர\u{bcd}ந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "உறைதல\u{bcd}",
                "உறைபனி",
                "குளிர\u{bcd}ச\u{bcd}சி",
                "குளிர\u{bcd}ந\u{bcd}த முகம\u{bcd}",
                "பனிக\u{bcd}கட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చల\u{c4d}లబడ\u{c3f}న ముఖం"),
            keywords: &[
                "ఐస\u{c3f}క\u{c3f}ల\u{c4d}\u{200c}లు",
                "గడ\u{c4d}డకట\u{c4d}టుకుప\u{c4b}వడం",
                "చల\u{c3f}",
                "చల\u{c4d}లబడ\u{c3f}న ముఖం",
                "న\u{c40}ల\u{c3f}రంగు ముఖం",
                "ఫ\u{c4d}ర\u{c3e}స\u{c4d}ట\u{c4d}-బ\u{c48}ట\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หนาวส\u{e31}\u{e48}น"),
            keywords: &[
                "หนาว",
                "หนาวส\u{e31}\u{e48}น",
                "เย\u{e47}นจ\u{e31}ด",
                "เย\u{e47}นยะเย\u{e37}อก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sowuk ýüz"),
            keywords: &[
                "buz şelpeleri",
                "doňan",
                "doňýan",
                "gök ýüzli",
                "sowuk",
                "sowuk ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata momoko"),
            keywords: &["mata momoko"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("üşümüş yüz"),
            keywords: &[
                "buz kesme",
                "buz sarkıtları",
                "donma",
                "morarmış yüz",
                "soğuk",
                "üşümüş yüz",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("замерзле обличчя"),
            keywords: &[
                "бурулька",
                "замерзле обличчя",
                "зуб на зуб",
                "мороз",
                "синє лице",
                "холод",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرد چہرہ"),
            keywords: &[
                "برف کے قلمیں",
                "بہت زیادہ سرد",
                "سرد چہرہ",
                "سردی سے ماؤف",
                "نیلگوں چہرہ",
                "ٹھنڈا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sovqotish"),
            keywords: &[
                "ayoz",
                "ko‘karib ketish",
                "muzlash",
                "qaltirash",
                "sovqotish",
                "sovuq",
                "yaxlash",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt lạnh"),
            keywords: &[
                "lạnh",
                "lạnh cứng",
                "mặt lạnh",
                "mặt xanh",
                "tê cóng",
                "đóng băng",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("好凍嘅臉"),
            keywords: &["冰", "凍", "凍傷", "凍結", "好凍嘅臉", "藍色嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("好冻嘅脸"),
            keywords: &["冰", "冻", "冻伤", "冻结", "好冻嘅脸", "蓝色嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("冷脸"),
            keywords: &["冷", "冷冰冰", "冷脸", "冻僵", "满面寒霜"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("冷臉"),
            keywords: &["冰凍", "冷", "冷臉", "結霜", "藍色的臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("凍嘅樣"),
            keywords: &["冰凍", "冷", "凍嘅樣", "結霜", "藍色嘅樣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obugodolayo"),
            keywords: &[
                "blue-faced",
                "cold",
                "freezing",
                "frostbite",
                "icicles",
                "ubuso obugodolayo",
            ],
        },
    ],
};
#[doc = "🥴"]
pub const WOOZY_FACE: crate::Emoji = crate::Emoji {
    glyph: "🥴",
    codepoint: "1F974",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woozy face",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dronk gesig"),
            keywords: &[
                "dronk",
                "dronk gesig",
                "duiselig",
                "gesuip",
                "lighoofdig",
                "onewe oë",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አጥወልዋይ ፊት"),
            keywords: &["አጥወልዋይ ፊት", "የሰከረ", "የተሸዋረረ አይን", "ድንዝዝ", "ግልብጥ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مصاب بدوار"),
            keywords: &[
                "ثمل",
                "دائخ",
                "عينان غير متساويتين",
                "فم متموج",
                "مسمم",
                "وجه مصاب بدوار",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিহ\u{9cd}বল ম\u{9c1}খ"),
            keywords: &[
                "তৰঙ\u{9cd}গ\u{9be}য\u{9bc}িত ম\u{9c1}খ",
                "প\u{9cd}ৰমত\u{9cd}ত",
                "বিষম চক\u{9c1}",
                "বিহ\u{9cd}বল",
                "বিহ\u{9cd}বল ম\u{9c1}খ",
                "মত\u{9cd}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gicəllənən üz"),
            keywords: &[
                "birtəhər",
                "gicəllənən",
                "gicəllənən üz",
                "sərxoş",
                "çəp gözlər",
                "əyri ağız",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ап’янелы твар"),
            keywords: &[
                "адурманены",
                "ап’янелы",
                "ап’янелы твар",
                "нецвярозы",
                "перакошаны рот",
                "п’яны",
                "разбягаюцца вочы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("опиянено лице"),
            keywords: &[
                "замаян",
                "зигзагообразна уста",
                "неравен поглед",
                "опиянен",
                "опиянено лице",
                "пийнал",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হতব\u{9c1}দ\u{9cd}ধি ম\u{9c1}খ"),
            keywords: &[
                "অর\u{9cd}ধেক খোল\u{9be} চোখ",
                "তরঙ\u{9cd}গ\u{9be}য\u{9bc}িত ম\u{9c1}খ",
                "প\u{9cd}র\u{9be}য\u{9bc} ম\u{9be}ত\u{9be}ল",
                "মত\u{9cd}ত",
                "হতব\u{9c1}দ\u{9cd}ধি",
                "হতব\u{9c1}দ\u{9cd}ধি ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ošamućeno lice"),
            keywords: &[
                "intoksikacija",
                "iskrivljena usta",
                "nejednake oči",
                "ošamućeno lice",
                "pripitost",
                "vrtoglavica",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de mareig"),
            keywords: &[
                "beguda",
                "begut",
                "boca ondulada",
                "cara de mareig",
                "embriac",
                "embriaga",
                "mareig",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎸᏕᏍᏗ ᎤᎧᏛ"),
            keywords: &[
                "ᎢᏧᎳᎭ ᏂᎨᏒᎾ ᏗᎦᏙᎵ",
                "ᎤᎸᏕᎯ",
                "ᎤᎸᏕᏍᏗ ᎤᎧᏛ",
                "ᎤᏚᎩᏓ",
                "ᎤᏥᏈᏗ ᎠᎰᎵ",
                "ᎤᏴᏍᏕᏛᏉ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zpitomělý obličej"),
            keywords: &[
                "líznutý",
                "opilost",
                "různě velké oči",
                "zpitomělý obličej",
                "zvlněná pusa",
                "závrať",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb meddw"),
            keywords: &[
                "ceg tonnog",
                "lled feddw",
                "llygaid anghyson",
                "meddw",
                "pendro",
                "wyneb meddw",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ørt ansigt"),
            keywords: &[
                "beruset",
                "bølget mund",
                "småfuld",
                "svimmel",
                "uens øjne",
                "ørt ansigt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwindeliges Gesicht"),
            keywords: &[
                "angetrunken",
                "beschwipst",
                "betrunken",
                "schwindeliges Gesicht",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζαλισμένο προσωπάκι"),
            keywords: &[
                "ζαλισμένο προσωπάκι",
                "ζαλισμένος",
                "μεθυσμένος",
                "πιωμένος",
                "ψιλομεθυσμένος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woozy face"),
            keywords: &[
                "dizzy",
                "intoxicated",
                "tipsy",
                "uneven eyes",
                "wavy mouth",
                "woozy face",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de grogui"),
            keywords: &[
                "atontado",
                "cara de grogui",
                "entonado",
                "grogui",
                "intoxicado",
                "mareado",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara de mareo"),
            keywords: &[
                "boca ondulada",
                "borrachera",
                "cara de mareo",
                "intoxicación",
                "mareo",
                "ojos desparejos",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara de mareo"),
            keywords: &["cara de mareo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("uimane nägu"),
            keywords: &[
                "alkoholiuimas",
                "joobnud",
                "lainelised huuled",
                "oimetu",
                "uimane nägu",
                "üks silm poolkinni",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("tentel-aurpegia"),
            keywords: &[
                "ahoa okertuta",
                "alai",
                "begiak okertuta",
                "mozkortuta",
                "tentel-aurpegia",
                "zorabiatuta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نشئه"),
            keywords: &[
                "دهان لرزان",
                "شنگول",
                "مست",
                "منگ",
                "نشئه",
                "چشمان بالا و پایین",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tokkurainen naama"),
            keywords: &[
                "aaltoileva suu",
                "heikotus",
                "huppelissa",
                "päissään",
                "silmät sikkaralla",
                "tokkurainen naama",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("woozy na mukha"),
            keywords: &[
                "bibig na wavy",
                "dizzy",
                "hindi pantay ang mata",
                "lasing",
                "nakainom",
                "woozy na mukha",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("í ørviti andlit"),
            keywords: &["kenning", "skít", "svimbul", "í ørviti", "í ørviti andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage éméché"),
            keywords: &[
                "bouche ondulée",
                "dans les vapes",
                "hébété",
                "pompette",
                "rond",
                "visage éméché",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage abruti"),
            keywords: &[
                "bouche ondulée",
                "dans les vapes",
                "hébété",
                "pompette",
                "rond",
                "visage abruti",
                "visage éméché",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog trína chéile"),
            keywords: &[
                "ar meisce",
                "béal corrach",
                "meabhránach",
                "straoiseog trína chéile",
                "súile míchothroma",
                "ólta",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann misgeach"),
            keywords: &[
                "aodann misgeach",
                "daorach",
                "froighleach",
                "misg",
                "smoid",
                "smoideag",
                "smùid",
                "smùideag",
                "stealladh",
                "tuaineal",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara atordada"),
            keywords: &["atordado", "borracho", "bébedo", "cara atordada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વોઝી ચહ\u{ac7}રો"),
            keywords: &[
                "અસ\u{acd}થિર આ\u{a82}ખો",
                "ચક\u{acd}કર",
                "નશો કર\u{ac7}લ",
                "પીધ\u{ac7}લ",
                "વા\u{a82}ક\u{ac1} થત\u{ac1}\u{a82} મોઢ\u{ac1}\u{a82}",
                "વોઝી ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שיכור"),
            keywords: &["מבולבל", "מסוחרר", "סחרחורת", "שיכור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चकराया ह\u{941}आ च\u{947}हरा"),
            keywords: &["चकराया ह\u{941}आ च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ošamućeno lice"),
            keywords: &[
                "intoksikacija",
                "iskrivljena usta",
                "nejednake oči",
                "ošamućeno lice",
                "pripitost",
                "vrtoglavica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("részeges arc"),
            keywords: &[
                "hullámvonalas száj",
                "ittas",
                "keresztbeálló szemek",
                "kába",
                "részeges arc",
                "spicces",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թմրած դեմք"),
            keywords: &[
                "գլխապտույտ",
                "թմրած դեմք",
                "թունավորում",
                "հարբած",
                "ճոճվող",
                "սրտխառնոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah pusing karena mabuk"),
            keywords: &[
                "agak mabuk",
                "mabuk",
                "mata miring",
                "mulut keriting",
                "pusing",
                "wajah pusing karena mabuk",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ringlað andlit"),
            keywords: &[
                "hlykkjóttur munnur",
                "kenderí",
                "ringlað andlit",
                "svima",
                "víma",
                "ójöfn augu",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina stordita"),
            keywords: &[
                "faccina con occhi semiaperti",
                "faccina stordita",
                "frastornato",
                "vertigini",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ふらふらの顔"),
            keywords: &[
                "うつろな目",
                "ふらふらの顔",
                "べろんべろん",
                "ほろ酔い",
                "めまい",
                "中毒",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mendem"),
            keywords: &[
                "cangkem mlethat-mlethot",
                "mata ora pakra",
                "mendem",
                "mlaku ora jejeg",
                "mumet",
                "rai mendem",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თავბრუდახვეული სახე"),
            keywords: &[
                "თავბრუდახვეული სახე",
                "თავბრუსხვევა",
                "მოწამლული",
                "ნასვამი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әлсіреген жүз"),
            keywords: &[
                "бас жазған",
                "басы айналған",
                "екі түрлі көз",
                "мастанған",
                "әлсіреген жүз",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខធ\u{17b8}ងធោង"),
            keywords: &[
                "ធ\u{17d2}លាក\u{17cb}ភ\u{17d2}នែកម\u{17bd}យច\u{17c6}ហៀង",
                "មាត\u{17cb}ដ\u{17bc}ចរលក",
                "ម\u{17bb}ខធ\u{17b8}ងធោង",
                "វ\u{17b7}លម\u{17bb}ខ",
                "ស\u{17d2}រវ\u{17b9}ង",
                "ស\u{17d2}រវ\u{17b9}ងត\u{17b7}ចៗ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಲ\u{cc6}ತ\u{cbf}ರುಗುವಂತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಅಮಲೇರ\u{cbf}ರುವುದು",
                "ಏರುಪೇರಾಗ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳು",
                "ಕುಡ\u{cbf}ದು ಮತ\u{ccd}ತೇರ\u{cbf}ರುವುದು",
                "ತಲ\u{cc6} ಸುತ\u{ccd}ತುವುದು",
                "ತಲ\u{cc6}ತ\u{cbf}ರುಗುವಂತ\u{cbf}ರುವ ಮುಖ",
                "ಸುತ\u{ccd}ತ\u{cbf}ಕೊಂಡ\u{cbf}ರುವ ಬಾಯ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("헤롱헤롱 얼굴"),
            keywords: &[
                "맛이 간",
                "비뚤거리는 입",
                "어지러운",
                "취한",
                "헤롱거리는",
                "헤롱헤롱 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घ\u{941}\u{902}वळ य\u{947}वपी च\u{947}रो"),
            keywords: &[
                "घ\u{941}\u{902}वपी दोळ\u{947}",
                "घ\u{941}\u{902}वळ य\u{947}वपी च\u{947}रो",
                "घ\u{941}\u{902}वळ य\u{947}वपी दोळ\u{947}",
                "चक\u{94d}कर य\u{947}वपी",
                "तर\u{902}गपी तो\u{902}ड",
                "सोरो",
                "सोरो पिय\u{947}ल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башы айланган жүз"),
            keywords: &[
                "башы айланган жүз",
                "башы айлануу",
                "көздөрү кыйшайган",
                "мас",
                "оозу кыйшайган",
                "ууланган",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໜ\u{ec9}າໂຊກເສ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຕາເລ\u{eb7}ອກ",
                "ຖ\u{eb7}ກສານພ\u{eb4}ດ",
                "ປາກເຕ\u{eb5}\u{ec8}ຍ",
                "ມ\u{eb7}ງ\u{ebb}ງ",
                "ວ\u{eb4}ຫ\u{ebb}ວ",
                "ໃບໜ\u{ec9}າໂຊກເສ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apkvaišęs veidas"),
            keywords: &[
                "apkvaišęs veidas",
                "apsvaigęs",
                "banguojanti burna",
                "nelygios akys",
                "įkaušęs",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("noreibusi seja"),
            keywords: &[
                "apreibis",
                "noreibusi seja",
                "piedzēries",
                "šķību muti",
                "šķībām acīm",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("пијано лице"),
            keywords: &["зашеметен", "пијан", "пијано лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മന\u{d4d}ദിച\u{d4d}ച മ\u{d41}ഖം"),
            keywords: &[
                "ഉന\u{d4d}മത\u{d4d}തന\u{d3e}യ",
                "ച\u{d41}ര\u{d41}ണ\u{d4d}ടിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന",
                "മന\u{d4d}ദിച\u{d4d}ച മ\u{d41}ഖം",
                "മയക\u{d4d}കം",
                "ലഹരിപിടിച\u{d4d}ചത\u{d4d}",
                "സമചിത\u{d4d}തതയില\u{d4d}ല\u{d3e}ത\u{d4d}ത",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("толгой эргэсэн царай"),
            keywords: &[
                "толгой эргэсэн царай",
                "толгой эргэх",
                "том жижиг нүд",
                "халамцуу",
                "хордоогүй",
                "хэл яриа ороолдсон",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}त\u{902}भित च\u{947}हरा"),
            keywords: &[
                "अस\u{902}गत डोळ\u{947}",
                "तापट",
                "मादक",
                "वाकड\u{947} तो\u{902}ड",
                "स\u{902}भ\u{94d}रमित",
                "स\u{94d}त\u{902}भित च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka kepeningan"),
            keywords: &[
                "mabuk",
                "mabuk sedikit",
                "mata tidak rata",
                "muka kepeningan",
                "mulut berombak",
                "pening",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကတ\u{102f}န\u{103a}ကယင\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ကတ\u{102f}န\u{103a}ကယင\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ထ\u{103d}ေနေသော",
                "ပါးစပ\u{103a}ရ\u{103d}\u{1032}\u{1037}ခြင\u{103a}း",
                "မ\u{1030}းဝေခြင\u{103a}း",
                "ရ\u{103d}\u{1032}နေသော မျက\u{103a}လ\u{102f}\u{1036}း",
                "အရက\u{103a}မ\u{1030}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svimmelt fjes"),
            keywords: &[
                "brisen",
                "bølgete munn",
                "full",
                "svimmel",
                "svimmelt fjes",
                "ujevne øyne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिङ\u{94d}गटा लाग\u{947}को अन\u{941}हार"),
            keywords: &[
                "असन\u{94d}त\u{941}लित आ\u{901}खा",
                "टिप\u{94d}सी",
                "नशामा लाग\u{942} औषध पर\u{947}को",
                "रिङ\u{94d}गटा",
                "रिङ\u{94d}गटा लाग\u{947}को अन\u{941}हार",
                "वाङ\u{94d}ग\u{947}को म\u{941}ख",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wazig gezicht"),
            keywords: &[
                "aangeschoten",
                "dronken",
                "duizelig",
                "golvende mond",
                "oneven ogen",
                "wazig gezicht",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svimmelt fjes"),
            keywords: &[
                "brisen",
                "bølgete munn",
                "full",
                "svimmel",
                "svimmelt fjes",
                "ujamne auge",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ୱ\u{b41}ଜ\u{b3f} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅସମ\u{b3e}ନ ଆଖ\u{b3f}",
                "ନ\u{b3f}ଶ\u{b3e}ଗ\u{b4d}ରସ\u{b4d}ତ",
                "ବ\u{b3f}ଭ\u{b4d}ର\u{b3e}ନ\u{b4d}ତ",
                "ମ\u{b3e}ତ\u{b3e}ଲ\u{b4d}\u{200c}",
                "ୱ\u{b41}ଜ\u{b3f} ମ\u{b41}ହ\u{b01}",
                "ୱେଭ\u{b3f} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਉ\u{a71}ਘੜ-ਦ\u{a41}\u{a71}ਘੜ ਅ\u{a71}ਖਾ\u{a02}",
                "ਕਲ\u{a4b}ਲਮਈ ਮ\u{a42}\u{a70}ਹ",
                "ਚਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਨਸ\u{a3c}ਿਆਇਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
                "ਸਰ\u{a42}ਰਿਆ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dízí Fes"),
            keywords: &[
                "Dízi",
                "Dízí Fes",
                "Fes Wé Dọ\u{301}n Chak",
                "Pẹ\u{301}sin Wé Ai De Tọ\u{301}n",
                "Pẹ\u{301}sin Wé Drink De Kách",
                "Pẹ\u{301}sin Wé Dọ\u{301}n Buz",
                "Zíg Zág Maut",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zamroczona twarz"),
            keywords: &[
                "faliste usta",
                "na gazie",
                "nierówne oczy",
                "odurzony",
                "pod wpływem",
                "wstawiony",
                "zamroczona twarz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خندور مخ"),
            keywords: &[
                "خندور مخ",
                "خوځيدونکې خوله",
                "سرګرځېدونکې",
                "پرکاله",
                "ګډوډي سترګې",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto embriagado"),
            keywords: &[
                "boca ondulada",
                "bêbado",
                "embriagado",
                "intoxicado",
                "olhos tortos",
                "rosto embriagado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara embriagada"),
            keywords: &[
                "boca ondulada",
                "bêbado",
                "cara embriagada",
                "embriagado",
                "intoxicado",
                "olhos tortos",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uma muyuy"),
            keywords: &[
                "intoxicado",
                "machasqa",
                "muyu muyu",
                "qinquykachasqa simi",
                "uma muyuy",
                "wistʼu ñawikuna",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cherchelită"),
            keywords: &["afumat", "amețit", "beat", "ebrietate", "față cherchelită"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-014"),
            keywords: &["E11-014"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("чувствует головокружение"),
            keywords: &[
                "головокружение",
                "дезориентация",
                "плохо",
                "тошнота",
                "чувствует головокружение",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ووزي چهرو"),
            keywords: &[
                "لهرائيندڙ منهن",
                "ناهمي اکيون",
                "نشي ۾",
                "ووزي چهرو",
                "ٽپسي",
                "چڪرائيندڙ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ක\u{dca}ඛ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අසම\u{dcf}න ඇස\u{dca}",
                "ඉස කරකැව\u{dd2}ල\u{dca}ල",
                "ද\u{dd4}ක\u{dca}ඛ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ",
                "මත\u{dca} ව\u{dd6}",
                "රැල\u{dd2} සහ\u{dd2}ත කට",
                "වෙර\u{dd2} ව\u{dd6}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("malátna tvár"),
            keywords: &[
                "malátna tvár",
                "omámený",
                "opilec",
                "opitý",
                "podnapitý",
                "závrat",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("okajen obraz"),
            keywords: &[
                "okajen obraz",
                "omotičen",
                "različni očesi",
                "v rožicah",
                "valovita usta",
                "vinjen",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji aan dagneyn"),
            keywords: &[
                "af qallocan",
                "caajis",
                "caara",
                "daroogeysan",
                "indho isla sinneyn",
                "waji aan dagneyn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e mjegulluar"),
            keywords: &[
                "e dehur",
                "e mjegulluar",
                "fytyrë e mjegulluar",
                "gojë e valëzuar",
                "xurxull",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("погубљено лице"),
            keywords: &[
                "кривудаве усне",
                "погубљено лице",
                "припит",
                "различите очи",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pogubljeno lice"),
            keywords: &[
                "krivudave usne",
                "pogubljeno lice",
                "pripit",
                "različite oči",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("yrt ansikte"),
            keywords: &[
                "ostadig blick",
                "på örat",
                "påverkad",
                "vågig mun",
                "yr",
                "yrt ansikte",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliolewa"),
            keywords: &[
                "kilevilevi",
                "kizunguzungu",
                "mlevi",
                "mvinyo",
                "ulevi",
                "uso uliolewa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குழப\u{bcd}பம\u{bbe}ன முகம\u{bcd}"),
            keywords: &[
                "குழப\u{bcd}பம\u{bbe}ன முகம\u{bcd}",
                "குழறும\u{bcd} வ\u{bbe}ய\u{bcd}",
                "தடும\u{bbe}ற\u{bcd}றம\u{bcd}",
                "நிலையற\u{bcd}ற கண\u{bcd}கள\u{bcd}",
                "போதை",
                "மயக\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మత\u{c4d}తుగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "కళ\u{c4d}లు త\u{c47}ల\u{c47}యడం",
                "త\u{c3e}గ\u{c3f}న మత\u{c4d}తు",
                "న\u{c3f}ష\u{c3e}",
                "న\u{c4b}ట\u{c4d}ల\u{c4b} జల\u{c4d}లు క\u{c3e}రడం",
                "మత\u{c4d}తు",
                "మత\u{c4d}తుగ\u{c3e} ఉన\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}างงงวย"),
            keywords: &[
                "งงงวย",
                "ม\u{e36}นเมา",
                "ว\u{e34}งเว\u{e35}ยน",
                "หน\u{e49}างงงวย",
                "เมา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("garagol ýüz"),
            keywords: &[
                "agzy gyşyk",
                "başy aýlanýan",
                "garagol ýüz",
                "gözleri çaşy",
                "serhoş",
                "çalaja serhoş",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata konā"),
            keywords: &["mata konā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarhoş yüz"),
            keywords: &[
                "kaymış gözler",
                "sarhoş",
                "sarhoş yüz",
                "sersemlemiş",
                "titreyen ağız",
                "çakırkeyif",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("очманіле обличчя"),
            keywords: &[
                "запаморочений",
                "кривулястий рот",
                "одурманений",
                "очманіле обличчя",
                "ошалілий",
                "перекошені очі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ا\u{64f}لجھن کا شکار شہرہ"),
            keywords: &[
                "ا\u{64f}لجھن کا شکار شہرہ",
                "مخم\u{64f}ور",
                "مدہوش",
                "ناہموار منہ",
                "ٹیڑھی میڑھی آنکھیں",
                "چکرایا ہ\u{64f}وا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boshi aylangan"),
            keywords: &[
                "behuzurlik",
                "bosh aylanish",
                "boshi aylangan",
                "his qilish",
                "ko‘ngil aynish",
                "o‘zini bilmay qolish",
                "yomon",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt choáng váng"),
            keywords: &[
                "chóng mặt",
                "chếnh choáng",
                "miệng uốn lượn",
                "mắt đảo điên",
                "mặt choáng váng",
                "say xỉn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("醉嘅臉"),
            keywords: &["不平嘅眼睛", "暈", "波浪形嘅嘴", "醉", "醉嘅臉", "陶醉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("醉嘅脸"),
            keywords: &["不平嘅眼睛", "晕", "波浪形嘅嘴", "醉", "醉嘅脸", "陶醉"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("头昏眼花"),
            keywords: &["嘴唇颤抖", "头昏眼花", "头晕眼花", "微醺", "眼花", "醉醺醺"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("頭昏眼花"),
            keywords: &["大小眼", "波浪嘴", "頭昏眼花", "頭暈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["大細眼", "波浪嘴", "頭昏眼花", "頭暈"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("woozy face"),
            keywords: &[
                "dizzy",
                "intoxicated",
                "tipsy",
                "uneven eyes",
                "wavy mouth",
                "woozy face",
            ],
        },
    ],
};
#[doc = "😵"]
pub const KNOCKED_OUT_FACE: crate::Emoji = crate::Emoji {
    glyph: "😵",
    codepoint: "1F635",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "knocked-out face",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("duiselig gesig"),
            keywords: &["dronk", "duiselig", "gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የደበተው ፊት"),
            keywords: &["የደበተው", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه دائخ"),
            keywords: &["وجه دائخ", "وجه مصاب بالدوار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}ৰ ঘ\u{9c1}ৰোৱ\u{9be} চেহেৰ\u{9be}"),
            keywords: &[
                "ম\u{9c1}খ",
                "ম\u{9c1}ৰ ঘ\u{9c1}ৰোৱ\u{9be}",
                "ম\u{9c1}ৰ ঘ\u{9c1}ৰোৱ\u{9be} চেহেৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("başıgicəllənən üz"),
            keywords: &["başgicəllənmə", "başıgicəllənən üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("галава круціцца"),
            keywords: &["галава круціцца", "галавакружэнне", "заблытаны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Замаяно лице"),
            keywords: &["Замаяно лице", "замаян", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হতব\u{9c1}দ\u{9cd}ধি হওয\u{9bc}\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ম\u{9c1}খ",
                "হতব\u{9c1}দ\u{9cd}ধি",
                "হতব\u{9c1}দ\u{9cd}ধি হওয\u{9bc}\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vrtoglavica"),
            keywords: &["lice", "vrtoglavica"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara marejada"),
            keywords: &["cara", "marejada", "marejat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎸᏕᎯᏓ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎸᏕᎯᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s výrazem závrati"),
            keywords: &[
                "obličej s výrazem závrati",
                "smajlík",
                "tvář",
                "výraz",
                "závrať",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb wedi llorio"),
            keywords: &["marw", "wedi llorio", "wyneb", "wyneb wedi llorio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("svimmelt ansigt"),
            keywords: &["ansigt", "svimmel", "svimmelt ansigt", "ør"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("benommenes Gesicht"),
            keywords: &["Gesicht", "benommen", "benommenes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζαλάδα"),
            keywords: &["ζαλάδα", "ζαλισμένος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("knocked-out face"),
            keywords: &["dead", "face", "knocked out", "knocked-out face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara mareada"),
            keywords: &["cara", "cara mareada", "mareo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de mareado"),
            keywords: &["cara", "cara de mareado", "mareado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara mareada"),
            keywords: &["cara", "cara mareada", "mareado"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara noqueada"),
            keywords: &["cara", "cara noqueada", "muerto", "noqueado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oimetu nägu"),
            keywords: &["nägu", "oimetu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zorabio-aurpegia"),
            keywords: &["aurpegi", "zorabiatu", "zorabio-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گیج"),
            keywords: &["صورت", "گیج"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tajuton"),
            keywords: &[
                "huimaus",
                "kuollut",
                "naama",
                "pyörtyvä",
                "tajuton",
                "tuupertuva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang nahihilo"),
            keywords: &[
                "hikab",
                "inaantok",
                "mukha",
                "mukhang nahihilo",
                "naghihikab",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svimbult andlit"),
            keywords: &["andlit", "svimbul", "svimbult andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage étourdi"),
            keywords: &["tournis", "visage", "visage étourdi"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage inconscient"),
            keywords: &["inconscient", "mort", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog mheadhránach"),
            keywords: &["aghaidh", "meadhránach", "straoiseog mheadhránach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann na thuaineal"),
            keywords: &["aodann", "aodann na thuaineal", "tuaineal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara mareada"),
            keywords: &["atordamento", "cara mareada", "mareado", "mareo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચક\u{acd}કર આવતો ચહ\u{ac7}રો"),
            keywords: &["ચક\u{acd}કર", "ચક\u{acd}કર આવતો ચહ\u{ac7}રો", "ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai jin jiri"),
            keywords: &["fuska", "fuska mai jin jiri", "jiri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם סחרחורת"),
            keywords: &["מסוחרר", "פרצוף", "פרצוף עם סחרחורת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चक\u{94d}कर खाता च\u{947}हरा"),
            keywords: &["चक\u{94d}कर", "चक\u{94d}कर खाता च\u{947}हरा", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s vrtoglavicom"),
            keywords: &["lice", "lice s vrtoglavicom", "vrtoglavica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szédülő arc"),
            keywords: &["arc", "szédülés", "szédülő arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գլխապտույտով դեմք"),
            keywords: &["գլխապտույտ", "գլխապտույտով դեմք", "դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah pusing"),
            keywords: &["muka", "pusing", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ajụ"),
            keywords: &["ajụ", "ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svimi"),
            keywords: &["andlit", "andlit með svima", "svimi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina frastornata"),
            keywords: &["faccina frastornata", "testa che gira"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("めまい"),
            keywords: &["ふらふら", "めまい", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mumet"),
            keywords: &["mumet", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაბრუებული სახე"),
            keywords: &["გაბრუებული", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басы айналу"),
            keywords: &["басы айналу", "бет"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("svimmelt ansigt"),
            keywords: &["ansigt", "svimmel", "svimmelt ansigt", "ør"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}លម\u{17bb}ខ"),
            keywords: &["ម\u{17bb}ខ", "វ\u{17b7}លម\u{17bb}ខ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಲ\u{cc6}ತ\u{cbf}ರುಗುತ\u{ccd}ತ\u{cbf}ರುವಂತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ತಲ\u{cc6}ತ\u{cbf}ರುಗುತ\u{ccd}ತ\u{cbf}ರುವಂತ\u{cbf}ರುವ ಮುಖ",
                "ತ\u{cc6}ಲ\u{cc6}ತ\u{cbf}ರುಗ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
                "ತ\u{cc6}ಲ\u{cc6}ತ\u{cbf}ರುಗ\u{cbf}ಸುವ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("어지러운 얼굴"),
            keywords: &["어지러운 얼굴", "어지러움", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घ\u{941}\u{902}\u{902}वपी च\u{947}रो"),
            keywords: &[
                "घ\u{941}\u{902}\u{902}वपी च\u{947}रो",
                "घ\u{941}\u{902}वपी",
                "च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башы айланган бет"),
            keywords: &["башы айланган", "башы айланган бет", "бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwindelegt Gesiicht"),
            keywords: &["Gesiicht", "schwindeleg", "schwindelegt Gesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າວ\u{eb4}ນຫ\u{ebb}ວ"),
            keywords: &[
                "ວ\u{eb4}ນຫ\u{ebb}ວ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າວ\u{eb4}ນຫ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apsvaigęs veidas"),
            keywords: &["apsvaigęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("apreibusi seja"),
            keywords: &["apreibis", "apreibusi seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi takaanini"),
            keywords: &["kanohi", "takaanini"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зашеметено лице"),
            keywords: &["зашеметено", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മയക\u{d4d}കത\u{d4d}തില\u{d3e}ണ\u{d4d}ട മ\u{d41}ഖം"),
            keywords: &[
                "മയക\u{d4d}കം",
                "മയക\u{d4d}കത\u{d4d}തില\u{d3e}ണ\u{d4d}ട മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
                "മോഹ\u{d3e}ലസ\u{d4d}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("толгой нь эргэсэн царай"),
            keywords: &["толгой нь эргэсэн", "толгой нь эргэсэн царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भोवळ य\u{947}णारा च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "भोवळ", "भोवळ य\u{947}णारा च\u{947}हरा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka pening"),
            keywords: &["muka", "pening"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ sturdut"),
            keywords: &["sturdut", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{1030}းဝေနေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မ\u{1030}းဝေနေသော မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "သတ\u{102d}လစ\u{103a} မျက\u{103a}န\u{103e}ာ",
                "သေဆ\u{102f}\u{1036}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ør"),
            keywords: &["fjes", "svimmel", "ør"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रि\u{902}गटा लाग\u{947}को अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "रि\u{902}गटा लाग\u{947}को",
                "रि\u{902}गटा लाग\u{947}को अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("duizelig gezicht"),
            keywords: &["duizelig", "gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ør"),
            keywords: &["fjes", "svimmel", "ør"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ\u{b3f}ତ", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a71}ਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਚ\u{a71}ਕਰ", "ਚ\u{a71}ਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بدحواس شکل"),
            keywords: &["بدحواس", "بدحواس شکل", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Wán Fent"),
            keywords: &["Dai", "Fent", "Fes", "Fes Wé Wán Fent"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("oszołomiona twarz"),
            keywords: &["oszołomiona twarz", "oszołomiony"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سرګرزنی مخ"),
            keywords: &["سرګرزنی", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto atordoado"),
            keywords: &["rosto", "rosto atordoado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara atordoada"),
            keywords: &["atordoado", "cara", "cara atordoada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("takasqa uya"),
            keywords: &["takasqa uya", "uya", "wañuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față amețită"),
            keywords: &["amețeală", "față", "față amețită", "ochi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-889"),
            keywords: &["E10-889"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("головокружение"),
            keywords: &[
                "голова кружится",
                "головокружение",
                "головокружительный",
                "лицо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza isereri"),
            keywords: &["igaragaza isereri", "isura", "isura igaragaza isereri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چڪرائيندڙ چهرو"),
            keywords: &["چهرو", "چڪرائيندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ද\u{dd2}මත ගත\u{dd2}යක\u{dca} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "න\u{dd2}ද\u{dd2}මත ගත\u{dd2}යක\u{dca} ඇත\u{dd2}",
                "න\u{dd2}ද\u{dd2}මත ගත\u{dd2}යක\u{dca} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár so závratom"),
            keywords: &["tvár", "tvár so závratom", "závrat"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("omotičen obraz"),
            keywords: &["obraz", "omotičen obraz", "omotično"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji wareersan"),
            keywords: &["waji", "waji wareersan", "wareer"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e trullosur"),
            keywords: &["e trullosur", "fytyrë", "fytyrë e trullosur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са вртоглавицом"),
            keywords: &["вртoглaвицa", "лице", "лице са вртоглавицом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa vrtoglavicom"),
            keywords: &["lice", "lice sa vrtoglavicom", "vrtoglavica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("omtumlat ansikte"),
            keywords: &["omtumlad", "omtumlat ansikte", "yr"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaoonyesha kuwa na kizunguzungu"),
            keywords: &[
                "kizunguzungu",
                "uso",
                "uso unaoonyesha kuwa na kizunguzungu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தலைச\u{bcd}சுற\u{bcd}றும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கிறுகிறுப\u{bcd}பு",
                "தலைச\u{bcd}சுற\u{bcd}றல\u{bcd}",
                "தலைச\u{bcd}சுற\u{bcd}றும\u{bcd} முகம\u{bcd}",
                "தலைச\u{bcd}சுற\u{bcd}றுவது போன\u{bcd}ற உணர\u{bcd}வு",
                "மயக\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తల త\u{c3f}ర\u{c3f}గ\u{c3f}నట\u{c4d}లు ఉండ\u{c47} ముఖం"),
            keywords: &[
                "తల",
                "తల త\u{c3f}ర\u{c3f}గ\u{c3f}నట\u{c4d}లు ఉండ\u{c47} ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи сарчархзанӣ"),
            keywords: &["рӯи сарчархзанӣ", "рӯй", "сарчархзанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าม\u{e36}น"),
            keywords: &["ม\u{e36}น", "หน\u{e49}า", "หน\u{e49}าม\u{e36}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("urlan ýüz"),
            keywords: &["urlan ýüz", "öli", "ýenjilen", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata ninimo"),
            keywords: &["mata ninimo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sersemlemiş yüz"),
            keywords: &["sersemlemiş yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("باش قايغان چىراي"),
            keywords: &["باش قايغان", "باش قايغان چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("запаморочене обличчя"),
            keywords: &["запаморочене обличчя", "запаморочений", "обличчя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چکراتا چہرہ"),
            keywords: &["چکر", "چکراتا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boshi aylanayotgan yuz"),
            keywords: &["boshi aylanayotgan yuz", "boshi aylanish", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt chóng mặt"),
            keywords: &["chóng mặt", "mặt", "mặt chóng mặt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu diis"),
            keywords: &["diis", "kanam", "kanam gu diis"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunesiyezi"),
            keywords: &["isiyezi", "ubuso", "ubuso obunesiyezi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Itoogbe"),
            keywords: &["Oju Itoogbe", "itoogbe", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("頭暈嘅臉"),
            keywords: &["臉", "頭暈", "頭暈嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("头晕嘅脸"),
            keywords: &["头晕", "头晕嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("晕头转向"),
            keywords: &["头晕", "头晕眼花", "晕头", "晕头转向", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("頭暈目眩"),
            keywords: &["表情", "頭暈目眩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunenzululwane"),
            keywords: &["inzululwane", "ubuso", "ubuso obunenzululwane"],
        },
    ],
};
#[doc = "😵\u{200d}💫"]
pub const FACE_WITH_SPIRAL_EYES: crate::Emoji = crate::Emoji {
    glyph: "😵\u{200d}💫",
    codepoint: "1F635 200D 1F4AB",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "face with spiral eyes",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met spiraaloë"),
            keywords: &[
                "duiselig",
                "gehipnotiseer",
                "gesig met spiraaloë",
                "moeilikheid",
                "spiraal",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዞሩ ዓይኖች ያለው ፊት"),
            keywords: &["የዞሩ ዓይኖች ያለው ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بعينين دائختين"),
            keywords: &[
                "حلزون",
                "دائخ",
                "دوامة",
                "لولبي",
                "منو\u{651}م",
                "وجه بعينين دائختين",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c2}ৰি থক\u{9be} চক\u{9c1} থক\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ঘ\u{9c2}ৰি থক\u{9be}",
                "ঘ\u{9c2}ৰি থক\u{9be} চক\u{9c1} থক\u{9be} ম\u{9c1}খ",
                "থ\u{9be}ম",
                "ম\u{9c2}ৰ ঘ\u{9c2}ৰোৱ\u{9be}",
                "সমস\u{9cd}য\u{9be}",
                "হিপ\u{9cd}নোট\u{9be}ইজ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("spiral gözlü üz"),
            keywords: &[
                "başgicəllənmə",
                "hipnozlanmış",
                "problem",
                "spiral",
                "spiral gözlü üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з вачыма-спіралямі"),
            keywords: &[
                "адурманены",
                "гіпноз",
                "загіпнатызаваны",
                "ого",
                "спіраль",
                "твар з вачыма-спіралямі",
                "турботы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лице със спираловидни очи"),
            keywords: &[
                "замаян",
                "лице със спираловидни очи",
                "проблеми",
                "спирала",
                "хипнотизиран",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখ প\u{9be}ক\u{9be}নো ম\u{9c1}খ"),
            keywords: &[
                "চঞ\u{9cd}চল",
                "চোখ প\u{9be}ক\u{9be}নো ম\u{9c1}খ",
                "ঝ\u{9be}মেল\u{9be}",
                "থ\u{9be}ম\u{9be}",
                "সম\u{9cd}মোহিত",
                "সর\u{9cd}পিল",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lice sa sprialnim očima"),
            keywords: &[
                "hipnotiziran",
                "lice sa sprialnim očima",
                "nevolja",
                "oho",
                "spiralno",
                "vrtoglavica",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb ulls d’espiral"),
            keywords: &[
                "cara amb ulls d’espiral",
                "espiral",
                "hipnosi",
                "mareig",
                "problema",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej se spirálami místo očí"),
            keywords: &[
                "hypnotizovaný",
                "no páni",
                "obličej se spirálami místo očí",
                "potíže",
                "spirála",
                "spirály",
                "zhypnotizovaný",
                "závrať",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â llygaid troellog"),
            keywords: &[
                "helbul",
                "hypnoteiddio",
                "penysgafn",
                "troellog",
                "whoa",
                "wyneb â llygaid troellog",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med spiraløjne"),
            keywords: &[
                "ansigt med spiraløjne",
                "hypnose",
                "hypnotiseret",
                "problemer",
                "spiral",
                "svimmel",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Spiralen als Augen"),
            keywords: &["Gesicht mit Spiralen als Augen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Gesicht mit Spiralaugen"),
            keywords: &["Gesicht mit Spiralaugen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο με μάτια σπιράλ"),
            keywords: &["πρόσωπο με μάτια σπιράλ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with spiral eyes"),
            keywords: &[
                "dizzy",
                "face with spiral eyes",
                "hypnotized",
                "spiral",
                "trouble",
                "whoa",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["dizzy", "hypnotised", "spiral", "trouble", "whoa"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "dizzy",
                "face with spiral eyes",
                "hypnotised",
                "spiral",
                "trouble",
                "whoa",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con ojos de espiral"),
            keywords: &[
                "alucinado",
                "cara con ojos de espiral",
                "desmayado",
                "hipnotizado",
                "locura",
                "mareado",
                "problema",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("spiraalsilmadega nägu"),
            keywords: &[
                "hüpnotiseeritud",
                "probleem",
                "spiraalne",
                "spiraalsilmadega nägu",
                "uimane",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kiribil-begiak dituen aurpegia"),
            keywords: &[
                "arazoa",
                "hipnotizatuta",
                "kiribil-begiak dituen aurpegia",
                "kiribila",
                "zorabiatuta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورتک با چشمان چرخشی"),
            keywords: &[
                "سرگیجه",
                "صورتک با چشمان چرخشی",
                "مارپیچ",
                "مشکل",
                "هیپنوتیزم",
                "وه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama jolla spiraalisilmät"),
            keywords: &[
                "apua",
                "huimata",
                "hypnoosissa",
                "naama jolla spiraalisilmät",
                "ongelmia",
                "spiraali",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukang may spiral na mata"),
            keywords: &["mukang may spiral na mata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við snyril eygum"),
            keywords: &[
                "andlit við snyril eygum",
                "dulleiða",
                "hypnotisera",
                "í ørvitu",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage aux yeux en spirales"),
            keywords: &[
                "confusion",
                "hagard",
                "tête qui tourne",
                "visage aux yeux en spirales",
                "étourdi",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage avec yeux en spirale"),
            keywords: &[
                "confusion",
                "hagard",
                "tête qui tourne",
                "visage avec yeux en spirale",
                "étourdi",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh le súile bíse"),
            keywords: &[
                "aghaidh le súile bíse",
                "bís",
                "hiopnóisithe",
                "meadhránach",
                "trioblóid",
                "whoa",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le sùilean snìomhanach"),
            keywords: &[
                "aodann le sùilean snìomhanach",
                "ceann na cheò",
                "luairean",
                "snìomh",
                "suainealachadh",
                "suainealaich",
                "trioblaid",
                "tuainealach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara con ollos de espiral"),
            keywords: &[
                "alucinado",
                "atordado",
                "cara con ollos de espiral",
                "desmaiado",
                "espiral",
                "hipnotizado",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સર\u{acd}પાકાર આ\u{a82}ખોવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "ઓહ",
                "ચક\u{acd}કર",
                "મ\u{ac1}શ\u{acd}ક\u{ac7}લી",
                "સ\u{a82}મોહિત",
                "સર\u{acd}પાકાર",
                "સર\u{acd}પાકાર આ\u{a82}ખોવાળો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם עיני ספירלה"),
            keywords: &["בצרה", "היפנוזה", "מסוחרר", "פרצוף", "פרצוף עם עיני ספירלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घ\u{941}मावदार आ\u{901}खो\u{902} वाला च\u{947}हरा"),
            keywords: &["घ\u{941}मावदार आ\u{901}खो\u{902} वाला च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice sa spiralnim očima"),
            keywords: &[
                "hipnotizirano",
                "iznenađenje",
                "lice sa spiralnim očima",
                "nevolja",
                "spiralno",
                "vrtoglavica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("spirálszemű arc"),
            keywords: &["spirálszemű arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պարուրաձև աչքերով դեմք"),
            keywords: &[
                "գլխապտույտ",
                "շփոթմունք",
                "պարուրաձև",
                "պարուրաձև աչքերով դեմք",
                "փորձանք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan mata berputar"),
            keywords: &["wajah dengan mata berputar"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með gormaugu"),
            keywords: &[
                "andlit með gormaugu",
                "dáleiddur",
                "gormur",
                "hægan",
                "svimar",
                "vandræði",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con occhi a spirale"),
            keywords: &["faccina con occhi a spirale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("目を回した顔"),
            keywords: &[
                "ふらふら",
                "めまい",
                "渦巻き",
                "目がぐるぐる",
                "目が回る",
                "目を回した顔",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngelu"),
            keywords: &[
                "alangan",
                "hipnotis",
                "kodisek",
                "ngelu",
                "ngluwer",
                "rai ngelu",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე სპირალური თვალებით"),
            keywords: &["არეული", "ეუფ", "სახე სპირალური თვალებით", "ჰიპნოზი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көзі шиыршық бет"),
            keywords: &["көзі шиыршық бет"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខមានភ\u{17d2}នែកវ\u{17b7}លរាងគ\u{17bc}ទខ\u{17d2}យង"),
            keywords: &[
                "គ\u{17bc}ទខ\u{17d2}យង",
                "ត\u{17d2}រ\u{17bc}វសណ\u{17d2}ដ\u{17c6}",
                "បញ\u{17d2}ហា",
                "ម\u{17bb}ខមានភ\u{17d2}នែកវ\u{17b7}លរាងគ\u{17bc}ទខ\u{17d2}យង",
                "វ\u{17b7}លម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗ\u{cbf}ರುಗುಟ\u{ccd}ಟುವ ಕಣ\u{ccd}ಣುಗಳ ಮುಖ"),
            keywords: &["ಗ\u{cbf}ರುಗುಟ\u{ccd}ಟುವ ಕಣ\u{ccd}ಣುಗಳ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("현기증 난 얼굴"),
            keywords: &["나선형 눈", "어지럼증", "현기증", "현기증 난 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोळ\u{947} घ\u{941}\u{902}वडावपी च\u{947}रो"),
            keywords: &[
                "अडचण",
                "गोल घ\u{941}\u{902}वपी",
                "घ\u{941}\u{902}वळ आयिल\u{94d}लो",
                "त\u{94d}रास",
                "दोळ\u{947} घ\u{941}\u{902}वडावपी च\u{947}रो",
                "धक\u{94d}को बसप",
                "स\u{902}मोहित जाल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көздүн ордуна спираль тартылган жүз"),
            keywords: &["көздүн ордуна спираль тартылган жүз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຫ\u{ebb}ວໝ\u{eb8}ນ"),
            keywords: &[
                "ຖ\u{eb7}ກສະກ\u{ebb}ດຈ\u{eb4}ດ",
                "ບ\u{eb1}ນຫາ",
                "ຫ\u{ebb}ວໝ\u{eb8}ນ",
                "ເປ\u{eb1}ນວ\u{eb4}ນ",
                "ໂວ\u{ec9}",
                "ໜ\u{ec9}າຫ\u{ebb}ວໝ\u{eb8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su spiralinėmis akimis"),
            keywords: &[
                "bėda",
                "spiralė",
                "svaigulys",
                "užhipnotizuotas",
                "va",
                "veidas su spiralinėmis akimis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar spirālēm acu vietā"),
            keywords: &[
                "apreibis",
                "hipnozē",
                "nepatikšanas",
                "oho",
                "seja ar spirālēm acu vietā",
                "spirāles",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со спирални очи"),
            keywords: &[
                "зашеметен",
                "леле",
                "лице со спирални очи",
                "неволја",
                "спирала",
                "хипнотизиран",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പിരിഞ\u{d4d}ഞ കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &["പിരിഞ\u{d4d}ഞ കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүд нь эрчлээтэй царай"),
            keywords: &[
                "асуудалтай",
                "нүд нь эрчлээтэй царай",
                "паах",
                "спираль",
                "толгой нь эргэсэн",
                "ховсдуулсан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नागमोडी डोळ\u{947} असल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "घ\u{947}री",
                "चक\u{94d}कर",
                "नागमोडी",
                "नागमोडी डोळ\u{947} असल\u{947}ला च\u{947}हरा",
                "स\u{902}मोहित",
                "समस\u{94d}या",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan mata berpusar"),
            keywords: &["muka dengan mata berpusar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ချာလပတ\u{103a}လည\u{103a}နေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ချာလပတ\u{103a}လည\u{103a}ခြင\u{103a}း",
                "ချာလပတ\u{103a}လည\u{103a}နေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဒ\u{102f}က\u{1039}ခ",
                "မ\u{1030}းဝေသော",
                "အ\u{102d}ပ\u{103a}မ\u{103d}ေ\u{1037}ချခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes med spiraløyne"),
            keywords: &[
                "fjes med spiraløyne",
                "hypnotisert",
                "problem",
                "spiral",
                "svimmel",
                "uææ",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बटारिएका आ\u{901}खासहितको अन\u{941}हार"),
            keywords: &[
                "ओहो",
                "चक\u{94d}कर लाग\u{94d}न\u{941}",
                "बटारिएका आ\u{901}खासहितको अन\u{941}हार",
                "बटारिएको",
                "समस\u{94d}या",
                "सम\u{94d}मोहित",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met spiraalvormige ogen"),
            keywords: &[
                "duizelig",
                "gehypnotiseerd",
                "gezicht met spiraalvormige ogen",
                "probleem",
                "spiraalvormig",
                "wow",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes med spiralauge"),
            keywords: &[
                "fjes med spiralauge",
                "hypnotisert",
                "problem",
                "spiral",
                "svimmel",
                "uææ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a71}ਕਰੀ ਅ\u{a71}ਖਾ\u{a02} ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਓਹ",
                "ਚ\u{a71}ਕਰ ਆਉਣਾ",
                "ਚ\u{a71}ਕਰੀ",
                "ਚ\u{a71}ਕਰੀ ਅ\u{a71}ਖਾ\u{a02} ਵਾਲਾ ਚਿਹਰਾ",
                "ਨੀ\u{a02}ਦਜਨਕ",
                "ਮ\u{a41}ਸੀਬਤ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Ai De Tọ\u{301}n Raúnd An Raund"),
            keywords: &[
                "Dízi",
                "Dú Pẹ\u{301}sin Jujú",
                "Fes Wé Ai De Tọ\u{301}n Raúnd An Raund",
                "Hẹẹ",
                "Sọ\u{301}mtin De Tọ\u{301}n Raúnd An Raund",
                "Wahála",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz ze spiralnymi oczami"),
            keywords: &[
                "spirale",
                "twarz ze spiralnymi oczami",
                "wow",
                "zahipnotyzowana twarz",
                "zawroty głowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مخ سرپل سترګې"),
            keywords: &["ستونزه", "سرپل", "مخ سرپل سترګې", "هه", "هیپنوټائز", "چکر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com olhos em espiral"),
            keywords: &[
                "espirais",
                "hipnotizado",
                "problema",
                "rosto com olhos em espiral",
                "tontura",
                "uau",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com olhos em espiral"),
            keywords: &[
                "cara com olhos em espiral",
                "espirais",
                "hipnotizado",
                "problema",
                "tontura",
                "uau",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya espiral ñawikunawan"),
            keywords: &[
                "espiral",
                "hipnotizado",
                "muyu muyu",
                "sasachay",
                "uya espiral ñawikunawan",
                "wow",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu ochi în spirală"),
            keywords: &[
                "amețit",
                "față cu ochi în spirală",
                "hipnotizat",
                "problemă",
                "spirală",
                "uau",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-002"),
            keywords: &["E13.1-002"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ошеломление"),
            keywords: &[
                "беда",
                "в тупике",
                "головокружение",
                "ошеломление",
                "смятение",
                "спираль",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيچدار اک وارو چهرو"),
            keywords: &[
                "رڪيو",
                "مٿو ڦرڻ",
                "ننڊ جي حالت ۾",
                "پريشاني",
                "پيچدار",
                "پيچدار اک وارو چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සර\u{dca}ප\u{dd2}ල\u{dcf}ක\u{dcf}ර ඇස\u{dca} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ආ",
                "කරකැව\u{dd2}ල\u{dca}ල",
                "කරදරය",
                "මෝහනය",
                "සර\u{dca}ප\u{dd2}ල\u{dcf}ක\u{dcf}ර",
                "සර\u{dca}ප\u{dd2}ල\u{dcf}ක\u{dcf}ර ඇස\u{dca} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár so špirálovými očami"),
            keywords: &[
                "hypnóza",
                "problém",
                "tvár so špirálovými očami",
                "závrat",
                "špirála",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s spiralnimi očmi"),
            keywords: &[
                "hipnoza",
                "obraz s spiralnimi očmi",
                "omotica",
                "spirala",
                "težave",
                "vau",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji indho wareegsan leh"),
            keywords: &[
                "dawakhsan",
                "dhibaato",
                "waji indho wareegsan leh",
                "wareeg",
                "wareer",
                "wareersan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me sy spiralë"),
            keywords: &[
                "fytyrë me sy spiralë",
                "hipnotizuar",
                "marramendje",
                "shqetësim",
                "spirale",
                "ua",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са спиралним очима"),
            keywords: &["лице са спиралним очима"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице са спиралним очима"),
            keywords: &["лице са спиралним очима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa spiralnim očima"),
            keywords: &["lice sa spiralnim očima"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice sa spiralnim očima"),
            keywords: &["lice sa spiralnim očima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med spiralögon"),
            keywords: &["ansikte med spiralögon", "fara", "hypnotiserad", "yrsel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye macho yanayozunguka"),
            keywords: &[
                "hiponozi",
                "kilevilevi",
                "kuzunguka",
                "tatizo",
                "uso wenye macho yanayozunguka",
                "whoa",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுழல\u{bcd} கண\u{bcd}கள\u{bcd} கொண\u{bcd}ட முகம\u{bcd}"),
            keywords: &[
                "சிக\u{bcd}கல\u{bcd}",
                "சுழல\u{bcd}",
                "சுழல\u{bcd} கண\u{bcd}கள\u{bcd} கொண\u{bcd}ட முகம\u{bcd}",
                "துயிலூட\u{bcd}டுதல\u{bcd}",
                "நில\u{bcd}",
                "மயக\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}ల\u{c3f}క\u{c46}లు కళ\u{c4d}లత\u{c4b} ముఖం"),
            keywords: &["మ\u{c46}ల\u{c3f}క\u{c46}లు కళ\u{c4d}లత\u{c4b} ముఖం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าตาลาย"),
            keywords: &["หน\u{e49}าตาลาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("spiral gözli ýüz"),
            keywords: &[
                "başy aýlanan",
                "bäý-bä",
                "gipnozlanan",
                "kynçylyk",
                "spiral",
                "spiral gözli ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata takatakai"),
            keywords: &["mata takatakai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarmal gözlü yüz"),
            keywords: &[
                "hipnotize",
                "kafası bulanık",
                "sarmal",
                "sarmal gözlü yüz",
                "sersem",
                "sıkıntı",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("очі-спіралі"),
            keywords: &[
                "гіпноз",
                "заносить",
                "запаморочення",
                "ох",
                "очі-спіралі",
                "проблема",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرغولہ آنکھوں والا چہرہ"),
            keywords: &["مرغولہ آنکھوں والا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("spiral koʻzli yuz"),
            keywords: &[
                "boshogʻriq",
                "gipnoz",
                "jalb etuvchi",
                "maftunkor",
                "spiral koʻzli yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt có đôi mắt xoắn ốc"),
            keywords: &[
                "chóng mặt",
                "mặt có đôi mắt xoắn ốc",
                "rắc rối",
                "thôi miên",
                "xoắn ốc",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("螺旋眼嘅臉"),
            keywords: &["催眠", "哇", "螺旋", "螺旋眼嘅臉", "頭暈", "麻煩"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("螺旋眼嘅脸"),
            keywords: &["催眠", "哇", "头晕", "螺旋", "螺旋眼嘅脸", "麻烦"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("晕"),
            keywords: &["晕"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("目眩頭暈"),
            keywords: &["催眠", "呃", "暈", "煩惱", "目眩頭暈", "眩暈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "🤯"]
pub const EXPLODING_HEAD: crate::Emoji = crate::Emoji {
    glyph: "🤯",
    codepoint: "1F92F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "exploding head",
    group: "Smileys & Emotion",
    subgroup: "face-unwell",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kop wat ontplof"),
            keywords: &["geskok", "kop wat ontplof"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፈነዳ ጭንቅላት"),
            keywords: &["የፈነዳ ጭንቅላት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه برأس منفجر"),
            keywords: &["وجه برأس منفجر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিস\u{9cd}ফোৰিত ম\u{9c1}ৰ"),
            keywords: &["বিস\u{9cd}ফোৰিত ম\u{9c1}ৰ", "বিস\u{9cd}মিত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("partlayan baş"),
            keywords: &["partlayan baş", "şoka düşmüş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("галава выбухае"),
            keywords: &["галава выбухае", "шакіраваны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Експлодираща глава"),
            keywords: &["Експлодираща глава", "невероятно", "шокиран"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফেটে পর\u{9be} ম\u{9be}থ\u{9be}"),
            keywords: &[
                "ফেটে পর\u{9be} ম\u{9be}থ\u{9be}",
                "মর\u{9cd}ম\u{9be}হত ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("eksplodirajuća glava"),
            keywords: &["eksplodirajuća glava", "šok"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cap que explota"),
            keywords: &["cap que explota", "estupefacta", "estupefacte"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᏍᎩᏍᎩ ᎠᎦᏍᏓᏛ"),
            keywords: &["ᎠᏔᏍᎩᏍᎩ ᎠᎦᏍᏓᏛ", "ᎤᏍᎦᏍᏓᏁᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("explodující hlava"),
            keywords: &[
                "explodující hlava",
                "obličej",
                "smajlík",
                "tvář",
                "výbuch",
                "výraz",
                "šok",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pen yn ffrwydro"),
            keywords: &["pen yn ffrwydro", "syn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hoved, der eksploderer"),
            keywords: &["chokeret", "hoved, der eksploderer"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("explodierender Kopf"),
            keywords: &["entsetzt", "explodierender Kopf", "geschockt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κεφάλι που εκρήγνυται"),
            keywords: &["κεφάλι που εκρήγνυται", "σοκαρισμένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("exploding head"),
            keywords: &["exploding head", "mind blown", "shocked"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["exploding head", "mind blown", "shocked"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cabeza explotando"),
            keywords: &["cabeza", "cabeza explotando", "explosión"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("plahvatav pea"),
            keywords: &["plahvatav pea", "šokeeritud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lehertzear den burua"),
            keywords: &["lehertzear den burua", "txundituta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سر منفجرشده"),
            keywords: &["سر منفجرشده", "شوکه", "شوکه\u{200c}شده", "متعجب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("räjähdys päässä"),
            keywords: &[
                "järkytys",
                "naama",
                "paukku",
                "raju",
                "räjähdys päässä",
                "sokki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sumasabog na ulo"),
            keywords: &["nabigla", "sumasabog na ulo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit í brestur"),
            keywords: &["andlit", "andlit í brestur", "brestur", "skelkur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tête qui explose"),
            keywords: &["choqué", "tête qui explose"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog lena ceann ag pléasadh"),
            keywords: &["croitheadh bainte", "straoiseog lena ceann ag pléasadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceann a’ spreadhadh"),
            keywords: &["annas", "ceann a’ spreadhadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de estoupar a cabeza"),
            keywords: &["cabeza", "cara", "cara de estoupar a cabeza", "estoupar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફાટત\u{ac1}\u{a82} માથ\u{ac1}\u{a82}"),
            keywords: &["ફાટત\u{ac1}\u{a82} માથ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kai mai bashewa"),
            keywords: &["firgitacce", "kai mai bashewa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ראש מתפוצץ"),
            keywords: &["המום", "ראש מתפוצץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विस\u{94d}फोट करता ह\u{941}आ सर"),
            keywords: &["विस\u{94d}फोट करता ह\u{941}आ सर", "ह\u{948}रान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("eksplodirajuća glava"),
            keywords: &["eksplodirajuća glava", "šok"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felrobbanó fej"),
            keywords: &["felrobbanó fej", "megdöbbent"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պայթող գլուխ"),
            keywords: &["ապշած", "ուղեղ", "պայթող", "պայթող գլուխ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kepala meledak"),
            keywords: &["kaget", "kepala meledak", "takjub", "terkejut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("isi mere nkụwa"),
            keywords: &["ihe atụghị anya ya", "isi mere nkụwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("splundrað höfuð"),
            keywords: &["splundrað höfuð"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("testa che esplode"),
            keywords: &["scioccato", "testa che esplode"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("頭爆発"),
            keywords: &["ぼんっ", "ショック", "爆発", "頭爆発", "顔", "驚き"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ndhase njeblug"),
            keywords: &["njeblug ndhase", "rai ndhase njeblug", "tratapan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აფეთქებული თავი"),
            keywords: &["აფეთქებული თავი", "დაშოკილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бас жарылғалы тұр"),
            keywords: &["бас жарылғалы тұр"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}បាលក\u{17c6}ព\u{17bb}ងផ\u{17d2}ទ\u{17bb}ះ"),
            keywords: &[
                "ក\u{17d2}បាលក\u{17c6}ព\u{17bb}ងផ\u{17d2}ទ\u{17bb}ះ",
                "រន\u{17d2}ធត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ಫೋಟ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ತಲ\u{cc6}"),
            keywords: &[
                "ಆಘಾತಗೊಂಡ\u{cbf}ರುವುದು",
                "ಸ\u{ccd}ಫೋಟ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ತಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("폭발하는 얼굴"),
            keywords: &["뚜껑 열린 머리", "머리 폭발", "충격", "폭발하는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{941}टपी तकली"),
            keywords: &["आघात जावप", "फ\u{941}टपी तकली"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жарылып жаткан баш"),
            keywords: &["айран таң калган", "жарылып жаткан баш"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("explodéierende Kapp"),
            keywords: &["explodéierende Kapp", "schockéiert"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວລະເບ\u{eb5}ດ"),
            keywords: &["ຕ\u{ebb}ກໃຈ", "ຫ\u{ebb}ວລະເບ\u{eb5}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sprogstanti galva"),
            keywords: &["sprogstanti galva", "šokiruotas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("eksplodējoša galva"),
            keywords: &["eksplodējoša galva", "šokēts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("māhunga pahū"),
            keywords: &["māhunga pahū", "oho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("експлодирачка глава"),
            keywords: &["експлодирачка глава", "шокирано"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൊട\u{d4d}ടിത\u{d4d}തെറിക\u{d4d}ക\u{d41}ന\u{d4d}ന തല"),
            keywords: &[
                "ഞെട\u{d4d}ടിയത\u{d4d}",
                "പൊട\u{d4d}ടിത\u{d4d}തെറിക\u{d4d}ക\u{d41}ന\u{d4d}ന തല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("толгой дэлбэрэх"),
            keywords: &["толгой дэлбэрэх", "цочирдсон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोक\u{94d}यावर स\u{94d}फोट"),
            keywords: &["डोक\u{94d}यावर स\u{94d}फोट", "स\u{94d}तब\u{94d}ध"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kepala meletup"),
            keywords: &["kepala meletup", "terkejut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ras tisplodi"),
            keywords: &["maħsud", "ras tisplodi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါသပေါက\u{103a}က\u{103d}\u{1032}ခေါင\u{103a}း"),
            keywords: &[
                "စ\u{102d}တ\u{103a}မထ\u{102d}န\u{103a}းန\u{102d}\u{102f}င\u{103a}ခြင\u{103a}း",
                "ထ\u{102d}တ\u{103a}လန\u{1037}\u{103a}ခြင\u{103a}း",
                "ဒေါသပေါက\u{103a}က\u{103d}\u{1032}ခေါင\u{103a}း",
                "ဒေါသပေါက\u{103a}က\u{103d}\u{1032}သည\u{1037}\u{103a} ဦးခေါင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("eksploderende hode"),
            keywords: &["eksploderende hode", "forbløffet", "overrasket", "sjokkert"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बिस\u{94d}फोट भइरह\u{947}को टाउको"),
            keywords: &["बिस\u{94d}फोट भइरह\u{947}को टाउको", "स\u{94d}तब\u{94d}ध"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ontploffend hoofd"),
            keywords: &["geschokt", "ontploffend hoofd"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("eksploderande hovud"),
            keywords: &["eksploderande hovud", "forbløffa", "overraska", "sjokkert"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ସ\u{b4d}ଫୋରଣ ହେଉଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଣ\u{b4d}ଡ"),
            keywords: &[
                "ବ\u{b3f}ସ\u{b4d}ଫୋରଣ ହେଉଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଣ\u{b4d}ଡ",
                "ମ\u{b3e}ନସ\u{b3f}କ ଆଘ\u{b3e}ତପ\u{b4d}ର\u{b3e}ପ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਟਦਾ ਹ\u{a4b}ਇਆ ਸਿਰ"),
            keywords: &["ਫਟਦਾ ਹ\u{a4b}ਇਆ ਸਿਰ", "ਹ\u{a48}ਰਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پاٹا سر"),
            keywords: &["حیران ہونا", "پاٹا سر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hẹd Wé Wán Skáta"),
            keywords: &["Bíg Hápí Sọpraiz", "Hẹd Wé Wán Skáta", "Shọk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("eksplodująca głowa"),
            keywords: &["eksplodująca głowa", "szok"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چاودیدلی سر"),
            keywords: &["حيران", "چاودیدلی سر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cabeça explodindo"),
            keywords: &["cabeça explodindo", "chocado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cabeça a explodir"),
            keywords: &["cabeça a explodir", "chocado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("p’akisqa uma"),
            keywords: &["luqlu yuyay", "mancharisqa", "pʼakisqa uma", "p’akisqa uma"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cap care explodează"),
            keywords: &["cap care explodează", "șocat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1041"),
            keywords: &["E10-1041"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("взрыв мозга"),
            keywords: &["в шоке", "взрыв мозга", "голова", "шок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutwe w’umuntu waturitse"),
            keywords: &["umutwe w’umuntu waturitse", "yahungabanye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦاٽندڙ مٿو"),
            keywords: &["ڇرڪ", "ڦاٽندڙ مٿو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ප\u{dd2}රෙන හ\u{dd2}ස"),
            keywords: &[
                "කම\u{dca}ප\u{dcf}වට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ප\u{dd2}ප\u{dd2}රෙන හ\u{dd2}ස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vybuchujúca hlava"),
            keywords: &["nechápem", "vybuchujúca hlava", "šokovaná"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("eksplozija v glavi"),
            keywords: &["eksplozija v glavi"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("madax qarxa"),
            keywords: &["madax qarxa", "yaabay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kokë që shpërthen"),
            keywords: &["i tronditur", "kokë që shpërthen"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глава експлодира"),
            keywords: &["глава експлодира", "шокирано"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глава експлодира"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("glava eksplodira"),
            keywords: &["glava eksplodira", "šokirano"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["glava eksplodira"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("exploderande huvud"),
            keywords: &["chockad", "exploderande huvud"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichwa kinacholipuka"),
            keywords: &["kichwa kinacholipuka", "mshtuko"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெடிக\u{bcd}கும\u{bcd} தலை"),
            keywords: &[
                "அதிர\u{bcd}ச\u{bcd}சி",
                "அதிர\u{bcd}ச\u{bcd}சி அடைந\u{bcd}துவிட\u{bcd}டேன\u{bcd}",
                "வெடிக\u{bcd}கும\u{bcd} தலை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తల భ\u{c3e}రం"),
            keywords: &["ఆశ\u{c4d}చర\u{c4d}యప\u{c4b}య\u{c3e}రు", "తల భ\u{c3e}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сари тарканда"),
            keywords: &["сари тарканда", "шигифтазада"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e47}อค"),
            keywords: &["ช\u{e47}อค", "ตะล\u{e36}ง", "ห\u{e31}วระเบ\u{e34}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("partlaýan kelle"),
            keywords: &["aňk-taňk", "huşy giden", "partlaýan kelle"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata pahū"),
            keywords: &["mata pahū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("patlayan kafa"),
            keywords: &["patlayan kafa", "şoke"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېشى پارتلاش"),
            keywords: &["بېشى پارتلاش", "داڭ قاتقان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("голова, що вибухає"),
            keywords: &["голова, що вибухає", "шокований"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سر پھٹنا"),
            keywords: &["حیران", "سر پھٹنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("miya portlashi"),
            keywords: &["miya portlashi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu nổ tung"),
            keywords: &["bị sốc", "đầu nổ tung"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bopp buy toj"),
            keywords: &["bopp buy toj", "mbettel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intloko edubulayo"),
            keywords: &["intloko edubulayo", "wothukile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Orí tó bú gbàmù"),
            keywords: &["Orí tó bú gbàmù", "Ìjayà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("爆炸頭"),
            keywords: &["爆炸頭", "震驚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("爆炸头"),
            keywords: &["爆炸头", "震惊"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("爆炸头"),
            keywords: &["爆炸头", "震惊"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("一個頭兩個大"),
            keywords: &["一個頭兩個大", "驚嚇"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("頭都爆"),
            keywords: &["腦部爆炸", "頭腦爆炸", "頭都爆"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhanda eliqhumayo"),
            keywords: &["ikhanda eliqhumayo", "thukile"],
        },
    ],
};
