#[doc = "😀"]
pub const GRINNING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😀",
    codepoint: "1F600",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "grinning face",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grinnikende gesig"),
            keywords: &["gesig", "grinnik", "grinnikende gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፈገግ ያለ ፊት"),
            keywords: &["ፈገግ ያለ ፊት", "ፈገግታ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بابتسامة عريضة"),
            keywords: &["ابتسام", "ضحك", "وجه بابتسامة عريضة", "وجه مبتسم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}স\u{9cd}য ম\u{9c1}খী"),
            keywords: &[
                "ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি",
                "হ\u{9be}স\u{9cd}য ম\u{9c1}খী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gülən üz"),
            keywords: &["gülmək", "gülən üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шырока ўсміхаецца"),
            keywords: &["зубы", "усмешка", "шырока ўсміхаецца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Широко усмихнато лице"),
            keywords: &[
                "Широко усмихнато лице",
                "лице",
                "ухилване",
                "широка усмивка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খে দে\u{981}তো হ\u{9be}সি"),
            keywords: &[
                "দে\u{981}তো হ\u{9be}সি",
                "ম\u{9c1}খ",
                "ম\u{9c1}খে দে\u{981}তো হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cerenje"),
            keywords: &["cerenje", "lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara molt somrient"),
            keywords: &["cara", "cara molt somrient", "rialla", "somriure", "ulls"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄞𑄬\u{11101}𑄌\u{11128} 𑄟\u{1112a}"),
            keywords: &["𑄞𑄬\u{11101}𑄌\u{11128} 𑄟\u{1112a}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᏣᏍᏗ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏤᏣᏍᏗ ᎤᎧᏛ", "ᎤᏰᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zubící se obličej"),
            keywords: &["smajlík", "tvář", "výraz", "zubící se obličej", "úšklebek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â cheg agored"),
            keywords: &["lledwenu", "wyneb", "wyneb yn gwenu â cheg agored"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grinende ansigt"),
            keywords: &["glad", "grinende ansigt", "smilende ansigt", "smiley"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grinsendes Gesicht"),
            keywords: &["Gesicht", "grinsendes Gesicht", "lol", "lustig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλατύ χαμόγελο"),
            keywords: &["πλατύ χαμόγελο", "πρόσωπο", "σαρκασμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("grinning face"),
            keywords: &["face", "grin", "grinning face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo"),
            keywords: &["cara", "cara sonriendo", "divertido", "feliz", "sonrisa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara feliz"),
            keywords: &["cara", "cara feliz", "contento", "divertido", "sonrisa"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo"),
            keywords: &["cara", "cara sonriendo", "contento", "divertido", "sonrisa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo"),
            keywords: &["cara", "cara sonriendo", "contento", "divertido", "sonrisa"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("laia naeratusega nägu"),
            keywords: &["irve", "laia naeratusega nägu", "naeratus", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barre egiten ari den aurpegia"),
            keywords: &["aurpegi", "barre egiten ari den aurpegia", "irribarre"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خنده"),
            keywords: &["خنده", "صورت با لبخند", "لبخند", "نیش باز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("leveä hymy"),
            keywords: &["hymy", "kasvot", "leveä hymy", "naama", "virnistys"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang nakangiti"),
            keywords: &[
                "malaking ngiti",
                "mukha",
                "mukhang nakangisi",
                "mukhang nakangiti",
                "nakangiti",
                "ngiti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grínandi andlit"),
            keywords: &["andlit", "grín", "grínandi andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage rieur"),
            keywords: &["sourire", "visage rieur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage avec large sourire"),
            keywords: &[
                "grand sourire",
                "large sourire",
                "visage",
                "visage avec large sourire",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ghealgháireach"),
            keywords: &["aghaidh", "gáire", "meangadh", "straoiseog ghealgháireach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire"),
            keywords: &["aodann", "aodann le gàire", "fiamh-ghàire", "gàire"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara moi riseira"),
            keywords: &["cara", "cara moi riseira", "sorriso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}મિત કરતો ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "સ\u{acd}મિત", "સ\u{acd}મિત કરતો ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushin baki har kunne"),
            keywords: &[
                "fuska",
                "fuska mai murmushin baki har kunne",
                "mai murmushi baki har kunne",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חיוך רחב"),
            keywords: &["חיוך", "חיוך רחב", "מחייך", "פרצוף", "שמח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दा\u{901}त दिखाता च\u{947}हरा"),
            keywords: &["खीस", "च\u{947}हरा", "दा\u{901}त दिखाता च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmijano lice"),
            keywords: &["lice", "nasmijano lice", "smiješak", "usta", "zubi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nevető arc"),
            keywords: &["arc", "nevetés", "nevető arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծիծաղող դեմք"),
            keywords: &["դեմք", "ծիծաղող դեմք", "քմծիծաղել"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("visage con grande surriso"),
            keywords: &[
                "facie",
                "surridente",
                "surriso",
                "visage",
                "visage con grande surriso",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah gembira"),
            keywords: &["bahagia", "gembira", "muka", "senang", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ọchị"),
            keywords: &["ihu", "ọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("glottandi andlit"),
            keywords: &["andlit", "glott", "glottandi andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con un gran sorriso"),
            keywords: &[
                "faccina",
                "faccina che sogghigna",
                "faccina con un gran sorriso",
                "risata",
                "sogghignare",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("にっこり笑う"),
            keywords: &["にっこり", "にっこり笑う", "スマイル", "笑う", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu"),
            keywords: &["guyu", "rai", "rai ngguyu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაკრეჭილი სახე"),
            keywords: &["დაკრეჭა", "დაკრეჭილი", "სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeḥ meqqren"),
            keywords: &["acmumeḥ meqqren"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("езу тартып күлу"),
            keywords: &["бет", "езу тарту", "езу тартып күлу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grinende ansigt"),
            keywords: &["glad", "grinende ansigt", "smilende ansigt", "smiley"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើច"),
            keywords: &["ម\u{17bb}ខ", "ម\u{17bb}ខសើច", "សើច"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾಸ\u{ccd}ಯದ ಮುಖ"),
            keywords: &["ಮುಖ", "ಹಾಸ\u{ccd}ಯ", "ಹಾಸ\u{ccd}ಯದ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("활짝 웃는 얼굴"),
            keywords: &["미소", "스마일", "얼굴", "웃음", "활짝 웃는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उकत\u{94d}या तो\u{902}डाचो हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "उकत\u{94d}या तो\u{902}डाचो हा\u{902}सपी च\u{947}रो",
                "च\u{947}रो",
                "हा\u{902}सप",
                "हा\u{902}सपी च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ырсайган бет"),
            keywords: &["бет", "ырсай", "ырсайган бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Grinsgesiicht"),
            keywords: &["Gesiicht", "Grinsen", "Grinsgesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຍ\u{eb4}\u{ec8}ງແຂ\u{ec9}ວ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຕະຫ\u{ebc}\u{ebb}ກ",
                "ຫ\u{ebb}ວ",
                "ຮາຮ\u{ec8}າ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຍ\u{eb4}\u{ec8}ງແຂ\u{ec9}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("išsišiepęs veidas"),
            keywords: &["išsišiepti", "išsišiepęs veidas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smiekli"),
            keywords: &["seja", "smaids", "smiekli"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi pakiri"),
            keywords: &["kanohi", "pakiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("широко насмеано лице"),
            keywords: &["лице", "широка насмевка", "широко насмеано лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "ഇളിക\u{d4d}കൽ",
                "കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "കളിയ\u{d3e}ക\u{d4d}കൽ",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("инээсэн царай"),
            keywords: &["инээсэн царай", "инээх", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दात विचकणाऱ\u{94d}या हास\u{94d}याचा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "दात विचकणाऱ\u{94d}या हास\u{94d}याचा च\u{947}हरा",
                "दात विचकण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersengih"),
            keywords: &["muka", "muka tersengih", "sengih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jidħak ħafna"),
            keywords: &["jidħaq ħafna", "wiċċ", "wiċċ jidħak ħafna"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032}",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glisefjes"),
            keywords: &["fjes", "glis", "glisefjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रमाएको अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "रमाएको अन\u{941}हार", "ह\u{901}सिलो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grijnzend gezicht"),
            keywords: &["gezicht", "grijns", "grijnzend gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glisefjes"),
            keywords: &["fjes", "glis", "glisefjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b3e}ନ\u{b4d}ତ ଦେଖ\u{b3e}ଇ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଦ\u{b3e}ନ\u{b4d}ତ ଦେଖ\u{b3e}ଇ ହସ\u{b3f}ବ\u{b3e}",
                "ଦ\u{b3e}ନ\u{b4d}ତ ଦେଖ\u{b3e}ଇ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਉਣਾ",
                "ਮ\u{a41}ਸਕਾਨ",
                "ਸਮਾਈਲੀ",
                "ਹ\u{a71}ਸਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دند پیسدی شکل"),
            keywords: &["داند پیسنا", "دند پیسدی شکل", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láfín Fes"),
            keywords: &["Fes", "Laf", "Láfín Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szeroko uśmiechnięta twarz"),
            keywords: &["roześmiana buźka", "szeroko uśmiechnięta twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خندېدلی مخ"),
            keywords: &["خندېدلی مخ", "مخ", "مسکا", "مسکېدلی مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto risonho"),
            keywords: &["lol", "rindo", "risada", "rosto", "rosto risonho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara sorridente"),
            keywords: &["cara", "cara sorridente", "sorriso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya"),
            keywords: &["kusi", "kusisqa uya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față încântată"),
            keywords: &["față", "față încântată", "încântare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-836"),
            keywords: &["E10-836"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("широко улыбается"),
            keywords: &[
                "лицо",
                "радость",
                "счастье",
                "улыбка",
                "широкая улыбка",
                "широко улыбается",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura imwenyura"),
            keywords: &["inseko", "isura", "isura imwenyura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏي کل وارو چهرو"),
            keywords: &["وڏي کل", "وڏي کل وارو چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}නහව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škeriaca sa tvár"),
            keywords: &["tvár", "úškrn", "úškľabok", "škeriaca sa tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("režeči obraz"),
            keywords: &["obraz", "režanje", "režeči obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dareenka wajiga"),
            keywords: &["dareenka wajiga", "gariir", "wajiga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e zgërdheshur"),
            keywords: &[
                "fytyrë",
                "fytyrë e zgërdheshur",
                "zgërdheshje",
                "zgërdhihem",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са широким осмехом"),
            keywords: &["лице", "лице са широким осмехом", "широки осмех"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице са широким осмијехом"),
            keywords: &["лице са широким осмијехом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa širokim osmehom"),
            keywords: &["lice", "lice sa širokim osmehom", "široki osmeh"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice sa širokim osmijehom"),
            keywords: &["lice sa širokim osmijehom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med stort leende"),
            keywords: &["ansikte med stort leende", "leende", "roligt", "skratt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaokenua"),
            keywords: &["kenua", "uso", "uso unaokenua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புன\u{bcd}னகைக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "சிரிப\u{bcd}பு",
                "புன\u{bcd}னகை",
                "புன\u{bcd}னகைக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పళ\u{c4d}లు చూప\u{c3f}స\u{c4d}తూ నవ\u{c4d}వుతున\u{c4d}న ముఖం"),
            keywords: &[
                "నవ\u{c4d}వు",
                "పళ\u{c4d}లు",
                "పళ\u{c4d}లు చూప\u{c3f}స\u{c4d}తూ నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон"),
            keywords: &["рӯи хандон", "рӯй", "фарох табассум кардан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าย\u{e34}\u{e49}มย\u{e34}งฟ\u{e31}น"),
            keywords: &[
                "ย\u{e34}\u{e49}มกว\u{e49}าง",
                "ย\u{e34}\u{e49}มย\u{e34}งฟ\u{e31}น",
                "หน\u{e49}าย\u{e34}\u{e49}มย\u{e34}งฟ\u{e31}น",
                "ใบหน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("syrtarýan ýüz"),
            keywords: &["syrtarma", "syrtarýan ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fiefia"),
            keywords: &["mata fiefia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sırıtan yüz"),
            keywords: &["gülen yüz", "gülme", "lol", "neşeli", "sırıtan yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىشلىق كۈلگەن چىراي"),
            keywords: &["چىراي", "چىشلىق", "چىشلىق كۈلگەن چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("широко всміхнене обличчя"),
            keywords: &[
                "вищир",
                "обличчя",
                "оскал",
                "посмішка",
                "усмішка",
                "широко всміхнене обличчя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھل کے ہنستا چہرہ"),
            keywords: &["منہ", "چہرہ", "کھل کے ہنستا چہرہ", "کھلا", "ہنسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tirjaygan yuz"),
            keywords: &["tirjaygan yuz", "tirjayish", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười toét"),
            keywords: &["mặt", "mặt cười toét", "toe toét"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy gaññi"),
            keywords: &["gaññi", "kanam", "kanam guy gaññi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuhlekayo"),
            keywords: &["hleka", "ubuso", "ubuso obuhlekayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó rẹ\u{301}rìn"),
            keywords: &["Ojú tó rẹ\u{301}rìn", "fẹyín", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("笑臉"),
            keywords: &["微笑", "笑臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("笑脸"),
            keywords: &["微笑", "笑脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("嘿嘿"),
            keywords: &["嘿嘿", "笑脸", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("笑臉"),
            keywords: &["微笑", "笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("笑臉"),
            keywords: &["微笑", "笑臉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obusinekile"),
            keywords: &["osinekile", "ubuso obusinekile"],
        },
    ],
};
#[doc = "😃"]
pub const GRINNING_FACE_WITH_BIG_EYES: crate::Emoji = crate::Emoji {
    glyph: "😃",
    codepoint: "1F603",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "grinning face with big eyes",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("glimlaggende gesig met oop mond"),
            keywords: &[
                "gesig",
                "glimlag",
                "glimlaggende gesig met oop mond",
                "mond",
                "oop",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፉ የተከፈተ ሣቂታ ፊት"),
            keywords: &["ሣቅ", "አፉ የተከፈተ ሣቂታ ፊት", "አፍ", "ክፍት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مبتسم بعينين كبيرتين"),
            keywords: &["ابتسام", "وجه مبتسم بعينين كبيرتين", "وجه مبتسم بفم مفتوح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উজ\u{9cd}জ\u{9cd}বল চক\u{9c1}ৰে হ\u{9be}স\u{9cd}যম\u{9c1}খ"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল চক\u{9c1}ৰে হ\u{9be}স\u{9cd}যম\u{9c1}খ",
                "খোল\u{9be}",
                "ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq ağızla gülən üz"),
            keywords: &["açıq", "açıq ağızla gülən üz", "ağız", "təbəssüm", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("усміхаецца з адкрытым ротам"),
            keywords: &["адкрыты", "рот", "усмешка", "усміхаецца з адкрытым ротам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Широко усмихнато лице с големи очи"),
            keywords: &[
                "Широко усмихнато лице с големи очи",
                "лице",
                "отворен",
                "усмивка",
                "уста",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বড\u{9bc} বড\u{9bc} চোখ করে হ\u{9be}সি ম\u{9c1}খ"),
            keywords: &[
                "খোল\u{9be}",
                "ঠো\u{981}ট",
                "বড\u{9bc} বড\u{9bc} চোখ করে হ\u{9be}সি ম\u{9c1}খ",
                "ম\u{9c1}খ",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kez"),
            keywords: &["kez", "lice", "osmijeh", "otvorena usta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara molt somrient amb els ulls ben oberts"),
            keywords: &[
                "boca oberta",
                "cara",
                "cara molt somrient amb els ulls ben oberts",
                "somriure",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄞\u{11127}𑄢\u{11134} 𑄌\u{1112e}𑄉\u{11127} 𑄉𑄎\u{11127}𑄌𑄬 𑄞𑄬\u{11101}𑄌\u{11128} 𑄟\u{1112a}",
            ),
            keywords: &[
                "𑄞\u{11127}𑄢\u{11134} 𑄌\u{1112e}𑄉\u{11127} 𑄉𑄎\u{11127}𑄌𑄬 𑄞𑄬\u{11101}𑄌\u{11128} 𑄟\u{1112a}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎾᏍᎩ ᎤᏔᎾ ᏗᎦᏙᎵ"),
            keywords: &["ᎠᎰᎵ", "ᎠᏍᎢᏓ", "ᎤᎧᏛ", "ᎤᏤᏣᏍᏗ", "ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎾᏍᎩ ᎤᏔᎾ ᏗᎦᏙᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zubící se obličej s velkýma očima"),
            keywords: &[
                "otevřený",
                "smajlík",
                "tvář",
                "výraz",
                "zubící se obličej s velkýma očima",
                "úsměv",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â cheg agored a llygaid mawr"),
            keywords: &[
                "agored",
                "ceg",
                "gwenu",
                "wyneb",
                "wyneb yn gwenu â cheg agored a llygaid mawr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grinende ansigt med store øjne"),
            keywords: &["glad", "grinende ansigt med store øjne", "smiler", "smiley"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grinsendes Gesicht mit großen Augen"),
            keywords: &[
                "Gesicht",
                "grinsendes Gesicht mit großen Augen",
                "lol",
                "lustig",
                "lächeln",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("grinsendes Gesicht mit grossen Augen"),
            keywords: &[
                "Gesicht",
                "grinsendes Gesicht mit grossen Augen",
                "lol",
                "lustig",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλατύ χαμόγελο με μεγάλα μάτια"),
            keywords: &[
                "ανοιχτό",
                "πλατύ χαμόγελο με μεγάλα μάτια",
                "πρόσωπο",
                "στόμα",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("grinning face with big eyes"),
            keywords: &[
                "face",
                "grinning face with big eyes",
                "mouth",
                "open",
                "smile",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con ojos grandes"),
            keywords: &[
                "cara",
                "cara sonriendo con ojos grandes",
                "divertido",
                "risa",
                "sonriendo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("sonrisa con boca abierta"),
            keywords: &[
                "boca abierta",
                "cara",
                "divertido",
                "risa",
                "sonrisa",
                "sonrisa con boca abierta",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con ojos grandes"),
            keywords: &[
                "boca abierta",
                "cara sonriendo con ojos grandes",
                "divertido",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con ojos grandes"),
            keywords: &[
                "boca abierta",
                "cara",
                "cara sonriendo con ojos grandes",
                "divertido",
                "risa",
                "sonrisa",
                "sonrisa con boca abierta",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud suuga naerunägu"),
            keywords: &[
                "avatud",
                "avatud suuga naerunägu",
                "lahti",
                "naeratus",
                "nägu",
                "suu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barre egiten ari den aurpegia, ahoa irekita"),
            keywords: &[
                "aho",
                "aurpegi",
                "barre egiten ari den aurpegia, ahoa irekita",
                "ireki",
                "irribarre",
                "irribarre egiten ari den aurpegia, ahoa irekita",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت خندان"),
            keywords: &["باز", "خنده", "دهان", "صورت", "صورت خندان", "لبخند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hymy suu auki"),
            keywords: &["auki", "hymy", "kasvot", "naama", "suu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangisi na may malaking mga mata"),
            keywords: &[
                "masaya",
                "mukha",
                "nakangisi na may malaking mga mata",
                "nakangiti",
                "ngiti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grínandi andlit við stórum eygum"),
            keywords: &[
                "andlit",
                "eygu",
                "grín",
                "grínandi andlit við stórum eygum",
                "munnur",
                "opin",
                "stór",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage souriant avec de grands yeux"),
            keywords: &["sourire", "visage souriant avec de grands yeux"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage souriant les yeux grands ouverts"),
            keywords: &[
                "bouche ouverte",
                "sourire",
                "visage",
                "visage souriant les yeux grands ouverts",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag gáire le súile móra"),
            keywords: &[
                "béal ar oscailt",
                "meangadh gáire",
                "straoiseog ag gáire le súile móra",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire is sùilean fosgailte"),
            keywords: &[
                "aodann",
                "aodann le gàire is sùilean fosgailte",
                "beul",
                "fiamh-ghàire",
                "fosgailte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara moi riseira con ollos grandes"),
            keywords: &[
                "aberta",
                "boca",
                "cara",
                "cara moi riseira con ollos grandes",
                "sorriso",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}લ\u{acd}લા મો\u{a82} સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
                "મોટી આ\u{a82}ખો સાથ\u{ac7} સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "સ\u{acd}મિત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da baki a buɗe"),
            keywords: &[
                "a buɗe",
                "baki",
                "fuska",
                "fuska mai murmushi tare da baki a buɗe",
                "murmushi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם חיוך רחב ועיניים גדולות"),
            keywords: &[
                "חיוך",
                "פה מחייך",
                "פרצוף מחייך עם פה פתוח",
                "פרצוף עם חיוך רחב ועיניים גדולות",
                "פרצוף שמח",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बड\u{93c}ी आ\u{901}खो\u{902} वाला दा\u{901}त दिखाता च\u{947}हरा"),
            keywords: &[
                "ख\u{941}ल\u{947} म\u{941}\u{902}ह वाली म\u{941}स\u{94d}कान",
                "च\u{947}हरा",
                "बड\u{93c}ी आ\u{901}खो\u{902} वाला दा\u{901}त दिखाता च\u{947}हरा",
                "म\u{941}स\u{94d}काना",
                "स\u{94d}माइली",
                "ह\u{902}सी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmijano lice s velikim očima"),
            keywords: &[
                "lice",
                "nasmijano lice s velikim očima",
                "otvorena usta",
                "smiješak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagyra nyílt szemmel mosolygó arc"),
            keywords: &[
                "arc",
                "mosoly",
                "nagyra nyílt szemmel mosolygó arc",
                "nyitott száj",
                "vidámság",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժպտացող դեմք բաց բերանով"),
            keywords: &["բաց", "բերան", "դեմք", "ժպտալ", "ժպտացող դեմք բաց բերանով"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("grande surriso con grande oculos"),
            keywords: &[
                "aperte",
                "bucca",
                "facie",
                "grande surriso con grande oculos",
                "surriso",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersenyum lebar"),
            keywords: &[
                "muka",
                "mulut",
                "senyum",
                "terbuka",
                "wajah",
                "wajah tersenyum lebar",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ihu Amụ Nwere Ọnụ Ghe oghe"),
            keywords: &["Ihu Amụ Nwere Ọnụ Ghe oghe", "amụ", "ihu", "mmepe", "ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brosandi andlit með opinn munn"),
            keywords: &[
                "andlit",
                "bros",
                "brosandi andlit með opinn munn",
                "brosandi andlit með stórum augum",
                "opinn munnur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con un gran sorriso e occhi spalancati"),
            keywords: &[
                "faccina",
                "faccina con un gran sorriso e occhi spalancati",
                "faccina sorridente",
                "risata",
                "sorridere",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("わーい"),
            keywords: &["わーい", "スマイル", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu matane mblalak"),
            keywords: &[
                "cangkem",
                "menga",
                "mesem",
                "rai",
                "rai ngguyu matane mblalak",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე ღია პირით"),
            keywords: &[
                "მომღიმარე სახე ღია პირით",
                "პირი",
                "პირღია",
                "სახე",
                "ღია",
                "ღიმილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeh n lfarh"),
            keywords: &["acmumeh n lfarh"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аузын ашып күлу"),
            keywords: &["аузын ашып күлу", "ауыз", "ашық", "бет", "жымию"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt med åben mund"),
            keywords: &["glad", "smilende ansigt med åben mund", "smiler", "smiley"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើចបើកភ\u{17d2}នែកធ\u{17c6}ៗ"),
            keywords: &[
                "បើក",
                "ភ\u{17d2}នែក",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខសើចបើកភ\u{17d2}នែកធ\u{17c6}ៗ",
                "សើច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಯ\u{ccd}ತುಂಬಾ ನಗುತ\u{ccd}ತ\u{cbf}ರುವ ನಗುಮುಖ"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}ದ",
                "ನಗು",
                "ಬಾಯ\u{cbf}",
                "ಬಾಯ\u{ccd}ತುಂಬಾ ನಗುತ\u{ccd}ತ\u{cbf}ರುವ ನಗುಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈을 크게 뜨고 웃는 얼굴"),
            keywords: &[
                "눈을 크게 뜨고 웃는 얼굴",
                "미소",
                "스마일",
                "얼굴",
                "입 벌리고 웃는 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोठ\u{94d}या दोळ\u{94d}या\u{902}चो हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "उकत\u{947}\u{902}",
                "च\u{947}रो",
                "तो\u{902}ड",
                "मोठ\u{94d}या दोळ\u{94d}या\u{902}चो हा\u{902}सपी च\u{947}रो",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күлгөн бет"),
            keywords: &["бет", "күл", "күлгөн бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat oppenem Mond"),
            keywords: &[
                "Gesiicht",
                "Laachen",
                "Mond",
                "laachend Gesiicht mat oppenem Mond",
                "oppen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມອ\u{ec9}າປາກ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຕະຫ\u{ebc}\u{ebb}ກ",
                "ຫ\u{ebb}ວ",
                "ຮາຮ\u{ec8}າ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມອ\u{ec9}າປາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis išsižiojęs veidas"),
            keywords: &[
                "besišypsantis išsižiojęs veidas",
                "burna",
                "praverta",
                "veidas",
                "šypsena",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plats smaids un lielas acis"),
            keywords: &[
                "atvērts",
                "mute",
                "plats smaids un lielas acis",
                "seja",
                "smaids",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene waha tuwhera"),
            keywords: &["kanohi", "menemene", "tuwhera", "waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("насмеано лице со големи очи"),
            keywords: &[
                "лице",
                "насмеано лице со големи очи",
                "насмевка",
                "отворена",
                "уста",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വലിയ കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "ത\u{d41}റന\u{d4d}ന",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "മ\u{d41}ഖം",
                "വലിയ കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "വ\u{d3e}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амаа ангайлган инээж буй царай"),
            keywords: &[
                "ам",
                "амаа ангайлган инээж буй царай",
                "ангайлгах",
                "инээх",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{941}ल\u{94d}या तो\u{902}डान\u{947} मोठ\u{94d}यान\u{947} हसण\u{947}"),
            keywords: &[
                "उघड\u{947}",
                "ख\u{941}ल\u{94d}या तो\u{902}डान\u{947} मोठ\u{94d}यान\u{947} हसण\u{947}",
                "च\u{947}हरा",
                "तो\u{902}ड",
                "मोठ\u{94d}या डोळ\u{94d}या\u{902}नी दात विचकणाऱ\u{94d}या हास\u{94d}याचा च\u{947}हरा",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersengih dengan mata besar"),
            keywords: &[
                "muka",
                "muka tersengih dengan mata besar",
                "mulut",
                "senyum",
                "terbuka",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jidħaq bil-ħalq miftuħ"),
            keywords: &[
                "jitbissem",
                "miftuħ",
                "wiċċ",
                "wiċċ jidħaq bil-ħalq miftuħ",
                "ħalq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}လ\u{102f}\u{1036}းပြ\u{1030}းဖြင\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပါးစပ\u{103a}",
                "ပြ\u{102f}\u{1036}း",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}လ\u{102f}\u{1036}းပြ\u{1030}းဖြင\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
                "ဟ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glisende fjes med vidåpne øyne"),
            keywords: &[
                "fjes",
                "glisende fjes med vidåpne øyne",
                "latter",
                "munn",
                "smil",
                "smilefjes",
                "smilefjes med åpen munn",
                "åpen",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला म\u{941}खसहितको ह\u{901}सिलो अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ख\u{941}ला",
                "ख\u{941}ला म\u{941}खसहितको ह\u{901}सिलो अन\u{941}हार",
                "म\u{941}ख",
                "म\u{941}स\u{94d}कान",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grijnzend gezicht met grote ogen"),
            keywords: &[
                "gezicht",
                "grijnzend gezicht met grote ogen",
                "lach",
                "mond",
                "open",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glisande fjes med vidopne auge"),
            keywords: &[
                "fjes",
                "glisande fjes med vidopne auge",
                "latter",
                "munn",
                "open",
                "smil",
                "smilefjes",
                "smilefjes med open munn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଡ ଆଖ\u{b3f} ସହ\u{b3f}ତ ହସକ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଖୋଲ\u{b3e}",
                "ପ\u{b3e}ଟ\u{b3f}",
                "ବଡ ଆଖ\u{b3f} ସହ\u{b3f}ତ ହସକ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
                "ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਨਾਲ ਹਾਸਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਵਾਲਾ ਚਿਹਰਾ",
                "ਸਮਾਈਲੀ",
                "ਹਾਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھلے منہ نال مسکراندی شکل"),
            keywords: &[
                "دی شکل",
                "مسکرانا",
                "منہ",
                "ک\u{64f}ھلا",
                "کھلے منہ نال مسکراندی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láfín Fes Wé Gẹ\u{301}t Bíg Ai-dẹm"),
            keywords: &[
                "Fes",
                "Laf",
                "Láfín Fes Wé Gẹ\u{301}t Bíg Ai-dẹm",
                "Maut",
                "Ópun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz z otwartymi ustami"),
            keywords: &["uśmiech", "uśmiechnięta twarz z otwartymi ustami", "wesoły"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدلی مخ د غټو سترګو سره"),
            keywords: &["خله", "مخ", "مسکا", "مسکېدلی مخ د غټو سترګو سره", "پېرته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto risonho com olhos bem abertos"),
            keywords: &[
                "aberto",
                "boca",
                "rosto",
                "rosto risonho com olhos bem abertos",
                "sorriso",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara sorridente com olhos bem abertos"),
            keywords: &[
                "aberta",
                "boca",
                "cara",
                "cara sorridente com olhos bem abertos",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya hatun ñawikunawan"),
            keywords: &[
                "kichay",
                "kusi",
                "kusisqa uya hatun ñawikunawan",
                "simi",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față încântată cu ochii mari"),
            keywords: &[
                "deschisă",
                "față",
                "față încântată cu ochii mari",
                "gură",
                "zâmbet",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-839"),
            keywords: &["E10-839"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("смеется"),
            keywords: &["лицо", "радость", "рот", "смеется", "смех", "улыбка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka ifite umunwa wasamye"),
            keywords: &[
                "gufungura",
                "guseka",
                "isura",
                "isura iseka ifite umunwa wasamye",
                "umunwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏين انکين سان وڏي کل وارو چهرو"),
            keywords: &["وڏين انکين سان وڏي کل وارو چهرو", "چهرو، وات، کليل، کل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට ඇර\u{dd4}ණ ස\u{dd2}න\u{dcf}සෙන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කට",
                "කට ඇර\u{dd4}ණ ස\u{dd2}න\u{dcf}සෙන ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}වෘත",
                "ස\u{dd2}නහව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škeriaca sa tvár s\u{a0}veľkými očami"),
            keywords: &[
                "otvorené",
                "tvár",
                "úsmev",
                "ústa",
                "škeriaca sa tvár s\u{a0}veľkými očami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz z odprtimi usti"),
            keywords: &[
                "nasmeh",
                "obraz",
                "odprto",
                "smejoči obraz z odprtimi usti",
                "usta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("muuqaalka wejiga indhaha weyn"),
            keywords: &[
                "afka",
                "dhoola cadeyn",
                "fur",
                "muuqaalka wajiga indha weyn",
                "muuqaalka wejiga indhaha weyn",
                "wajiga",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e qeshur me gojën e hapur"),
            keywords: &[
                "buzëqeshje",
                "e hapur",
                "fytyrë",
                "fytyrë e qeshur me gojën e hapur",
                "gojë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са одушевљеним осмехом"),
            keywords: &[
                "лице",
                "лице са одушевљеним осмехом",
                "осмех",
                "отворено",
                "уста",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице са одушевљеним осмијехом"),
            keywords: &["лице са одушевљеним осмијехом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa oduševljenim osmehom"),
            keywords: &[
                "lice",
                "lice sa oduševljenim osmehom",
                "osmeh",
                "otvoreno",
                "usta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice sa oduševljenim osmijehom"),
            keywords: &["lice sa oduševljenim osmijehom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flinande ansikte med stora ögon"),
            keywords: &[
                "flinande ansikte med stora ögon",
                "leende",
                "roligt",
                "skratt",
                "öppen mun",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu wenye macho makubwa"),
            keywords: &[
                "funguliwa",
                "mdomo",
                "tabasamu",
                "uso",
                "uso unaokenua wenye macho makubwa",
                "uso unaotabasamu wenye macho makubwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}களை விரித\u{bcd}து சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கண\u{bcd}களை விரித\u{bcd}து சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "சிரிப\u{bcd}பு",
                "புன\u{bcd}னகை",
                "முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ప\u{c46}ద\u{c4d}ద కళ\u{c4d}లత\u{c4b} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "నవ\u{c4d}వు",
                "న\u{c4b}రు",
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "ప\u{c46}ద\u{c4d}ద కళ\u{c4d}లత\u{c4b} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо даҳони кушода"),
            keywords: &[
                "даҳон",
                "кушода",
                "рӯи хандон бо даҳони кушода",
                "рӯй",
                "табассум",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าย\u{e34}\u{e49}มอ\u{e49}าปาก"),
            keywords: &[
                "ตลก",
                "ย\u{e34}\u{e49}ม",
                "ย\u{e34}\u{e49}มย\u{e34}งฟ\u{e31}นปากอ\u{e49}า",
                "หน\u{e49}า",
                "หน\u{e49}าย\u{e34}\u{e49}มอ\u{e49}าปาก",
                "ห\u{e31}วเราะ",
                "ฮ\u{e48}าๆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ullakan gözli syrtarýan ýüz"),
            keywords: &[
                "agyz",
                "açyk",
                "ullakan gözli syrtarýan ýüz",
                "ýylgyrmak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fiefia moe kanoʻimata lalahi"),
            keywords: &["mata fiefia moe kanoʻimata lalahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağzı açık sırıtma"),
            keywords: &[
                "ağzı açık gülen yüz",
                "ağzı açık sırıtma",
                "gülen yüz",
                "gülme",
                "gülümseme",
                "lol",
                "neşeli",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزىنى ئېچىپ كۈلۈمسىرەش"),
            keywords: &[
                "ئاغزىنى ئېچىپ كۈلۈمسىرەش",
                "ئوچۇق",
                "ئېغىز",
                "كۈلۈش",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("широко всміхнене обличчя з очищами"),
            keywords: &[
                "відкритий",
                "обличчя",
                "посмішка",
                "рот",
                "широко всміхнене обличчя з очищами",
                "широко усміхнене обличчя з великими очима",
                "широко усміхнене обличчя з очищами",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑی آنکھوں والا کھلے منہ والا مسکراتا چہرہ"),
            keywords: &[
                "بڑی آنکھوں والا کھلے منہ والا مسکراتا چہرہ",
                "مسکراہٹ",
                "منہ",
                "چہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zini katta ochib kulayotgan yuz"),
            keywords: &[
                "ochiq",
                "og‘iz",
                "og‘zini katta ochib kulayotgan yuz",
                "tabassum",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười miệng há với mắt to"),
            keywords: &[
                "cười",
                "miệng",
                "mặt",
                "mặt cười miệng há với mắt to",
                "mặt cười tươi với hai mắt mở to",
                "mở",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak gémmiñ gu ubbeeku di muuñ"),
            keywords: &[
                "gémmiñ",
                "kanam",
                "kanam ak gémmiñ gu ubbeeku di muuñ",
                "muuñ",
                "ubbeeku",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obunomlomo ovulekileyo"),
            keywords: &[
                "ubuso",
                "ubuso obuncumileyo obunomlomo ovulekileyo",
                "umlomo",
                "uncumo",
                "vulekileyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó rẹ\u{301}rìn Pẹ\u{300}lú Ẹnu Lílà sílẹ\u{300}"),
            keywords: &[
                "Ojú tó rẹ\u{301}rìn Pẹ\u{300}lú Ẹnu Lílà sílẹ\u{300}",
                "ojú",
                "rẹ\u{301}rìń músẹ\u{301}",
                "ṣí",
                "ẹnu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大眼睛笑臉"),
            keywords: &["嘴", "大眼睛笑臉", "微笑", "打開", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大眼睛笑脸"),
            keywords: &["嘴", "大眼睛笑脸", "微笑", "打开", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("哈哈"),
            keywords: &["哈哈", "开口笑", "笑脸", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大笑"),
            keywords: &["呵呵", "哈哈", "大笑", "笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("開眼嘅笑臉"),
            keywords: &["哈哈", "笑臉", "開眼嘅笑臉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizelayo obuvule umlomo"),
            keywords: &[
                "moyizela",
                "ubuso",
                "ubuso obumoyizelayo obuvule umlomo",
                "umlomo",
                "vula",
            ],
        },
    ],
};
#[doc = "😄"]
pub const GRINNING_FACE_WITH_SMILING_EYES: crate::Emoji = crate::Emoji {
    glyph: "😄",
    codepoint: "1F604",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "grinning face with smiling eyes",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig en oë glimlag"),
            keywords: &[
                "gesig",
                "gesig en oë glimlag",
                "glimlag",
                "glimlaggende gesig met oop mond en glimlaggende oë",
                "mond",
                "oog",
                "oop",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከተከፈተ አፍ ጋር ሣቂታ ፊት እና ሣቂታ ዓይኖች"),
            keywords: &["ሣቅ", "አፍ", "ከተከፈተ አፍ ጋር ሣቂታ ፊት እና ሣቂታ ዓይኖች", "ክፍት", "ዓይን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مبتسم بعينين باسمتين"),
            keywords: &[
                "أعين مبتسمة",
                "ابتسام",
                "فم مفتوح",
                "وجه مبتسم بعينين باسمتين",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}স\u{9cd}যম\u{9c1}খী চক\u{9c1}ৰে উজ\u{9cd}জ\u{9cd}বল ম\u{9c1}খ"),
            keywords: &[
                "খোল\u{9be}",
                "চক\u{9c1}",
                "ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি",
                "হ\u{9be}স\u{9cd}যম\u{9c1}খী চক\u{9c1}ৰে উজ\u{9cd}জ\u{9cd}বল ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq ağız və gülən gözlərlə gülən üz"),
            keywords: &[
                "açıq",
                "açıq ağız və gülən gözlərlə gülən üz",
                "ağız",
                "göz",
                "təbəssüm",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("усміхаецца, адкрыўшы рот і прыплюшчыўшы вочы"),
            keywords: &[
                "вочы",
                "рот",
                "усмешка",
                "усміхаецца, адкрыўшы рот і прыплюшчыўшы вочы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Широко усмихнато лице с усмихнати очи"),
            keywords: &[
                "Широко усмихнато лице с усмихнати очи",
                "лице",
                "отворен",
                "усмивка",
                "уста",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খোল\u{9be} ম\u{9c1}খে চোখে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি"),
            keywords: &[
                "খোল\u{9be}",
                "খোল\u{9be} ম\u{9c1}খে চোখে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি",
                "চোখ",
                "ঠো\u{981}ট",
                "ম\u{9c1}খ",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kez sa škiljenjem"),
            keywords: &["kez sa škiljenjem", "lice", "osmijeh", "oči", "usta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb rialla i els ulls somrients"),
            keywords: &[
                "boca oberta",
                "cara",
                "cara amb rialla i els ulls somrients",
                "somriure",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎾᏍᎩ ᎤᏤᏣᏍᏗ ᏗᎦᏙᎵ"),
            keywords: &[
                "ᎠᎦᏘ",
                "ᎠᎰᎵ",
                "ᎠᏍᏚᎢᏓ",
                "ᎤᎧᏛ",
                "ᎤᏤᏣᏍᏗ",
                "ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎾᏍᎩ ᎤᏤᏣᏍᏗ ᏗᎦᏙᎵ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zubící se obličej s usměvavýma očima"),
            keywords: &[
                "oko",
                "otevřený",
                "smajlík",
                "tvář",
                "výraz",
                "zubící se obličej s usměvavýma očima",
                "úsměv",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â cheg agored a gwên yn y llygaid"),
            keywords: &[
                "ceg",
                "gwenu",
                "llygad",
                "wyneb",
                "wyneb yn gwenu â cheg agored a gwên yn y llygaid",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grinende ansigt med smilende øjne"),
            keywords: &[
                "glad",
                "grinende ansigt med smilende øjne",
                "smil",
                "smiley",
                "smileøjne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grinsendes Gesicht mit lachenden Augen"),
            keywords: &[
                "Gesicht",
                "grinsendes Gesicht mit lachenden Augen",
                "lol",
                "lustig",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλατύ χαμόγελο με γελαστά μάτια"),
            keywords: &[
                "ανοιχτό",
                "μάτι",
                "πλατύ χαμόγελο με γελαστά μάτια",
                "πρόσωπο",
                "στόμα",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("grinning face with smiling eyes"),
            keywords: &[
                "eye",
                "face",
                "grinning face with smiling eyes",
                "mouth",
                "open",
                "smile",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con ojos sonrientes"),
            keywords: &[
                "abierta",
                "cara",
                "cara sonriendo con ojos sonrientes",
                "ojo",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("boca y ojos sonrientes"),
            keywords: &[
                "boca abierta",
                "boca y ojos sonrientes",
                "cara",
                "divertido",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con ojos sonrientes"),
            keywords: &[
                "boca abierta",
                "cara sonriendo con ojos sonrientes",
                "divertido",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con ojos sonrientes"),
            keywords: &[
                "boca abierta",
                "cara sonriendo con ojos sonrientes",
                "divertido",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud suu ja naeratavate silmadega naerunägu"),
            keywords: &[
                "avatud",
                "avatud suu ja naeratavate silmadega naerunägu",
                "lahti",
                "naeratus",
                "nägu",
                "silm",
                "suu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begiez barreka ari den aurpegia"),
            keywords: &[
                "aho",
                "aurpegi",
                "begi",
                "begiez barreka ari den aurpegia",
                "begiez irribarre egiten ari den aurpegia, ahoa irekita",
                "ireki",
                "irribarre",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خندان"),
            keywords: &[
                "باز",
                "خندان",
                "خنده",
                "دهان",
                "صورتک با پوزخند و چشمان خندان",
                "لبخند",
                "چشم",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hymyilevät silmät ja suu"),
            keywords: &[
                "auki",
                "hymy",
                "hymyilevät silmät ja suu",
                "kasvot",
                "naama",
                "silmä",
                "suu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangisi kasama ang mga nakangiting mata"),
            keywords: &[
                "masaya",
                "mata",
                "mukha",
                "nakangisi kasama ang mga nakangiting mata",
                "nakangiti",
                "nakatawa",
                "ngiti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grínandi andlit við brosandi eygum"),
            keywords: &[
                "andlit",
                "grín",
                "grínandi andlit við brosandi eygum",
                "munnur",
                "opin",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage très souriant aux yeux rieurs"),
            keywords: &["sourire", "visage très souriant aux yeux rieurs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage avec large sourire et yeux rieurs"),
            keywords: &[
                "bouche ouverte",
                "sourire",
                "visage",
                "visage avec large sourire et yeux rieurs",
                "œil",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag gáire le súile gealgháireacha uirthi"),
            keywords: &[
                "béal ar oscailt",
                "meangadh gáire",
                "straoiseog ag gáire le bhéal oscailte agus súile ag déanamh miongháire",
                "straoiseog ag gáire le súile ag déanamh miongháire",
                "straoiseog ag gáire le súile gealgháireacha uirthi",
                "straoiseog ag gáire le súile le miongháire",
                "súile ag gáire",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire na shùilean"),
            keywords: &[
                "aodann",
                "aodann le gàire na shùilean",
                "beul",
                "fiamh-ghàire",
                "fosgailte",
                "sùil",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara moi riseira cos ollos alegres"),
            keywords: &[
                "boca",
                "cara",
                "cara moi riseira cos ollos alegres",
                "ollos",
                "sorriso",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} હસતી આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
            ),
            keywords: &[
                "આ\u{a82}ખ",
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} હસતી આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
                "મો\u{a82}",
                "સ\u{acd}મિત",
                "હસતી આ\u{a82}ખો સાથ\u{ac7} સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da baki a buɗe & idanu masu murmushi"),
            keywords: &[
                "a buɗe",
                "baki",
                "fuska",
                "fuska mai murmushi tare da baki a buɗe & idanu masu murmushi",
                "ido",
                "murmushi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחייך עם פה פתוח ועיניים מחייכות"),
            keywords: &[
                "חיוך",
                "פרצוף מחייך",
                "פרצוף מחייך עם פה פתוח ועיניים מחייכות",
                "שמח",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "म\u{941}स\u{94d}क\u{941}राती आ\u{901}खो\u{902} वाला दा\u{901}त दिखाता च\u{947}हरा",
            ),
            keywords: &[
                "आ\u{901}ख",
                "च\u{947}हरा",
                "म\u{941}\u{901}ह",
                "म\u{941}स\u{94d}क\u{941}राती आ\u{901}खो\u{902} वाला दा\u{901}त दिखाता च\u{947}हरा",
                "म\u{941}स\u{94d}क\u{941}राहट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmijano lice s nasmiješenim očima"),
            keywords: &[
                "lice",
                "nasmijano lice s nasmiješenim očima",
                "otvoreno",
                "oči",
                "smiješak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nevető arc mosolygó szemmel"),
            keywords: &[
                "arc",
                "mosoly",
                "nevető arc mosolygó szemmel",
                "szem",
                "száj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց բերնով ժպտացող դեմք՝ ժպտացող աչքերով"),
            keywords: &[
                "աչք",
                "բաց",
                "բաց բերնով ժպտացող դեմք՝ ժպտացող աչքերով",
                "բերան",
                "դեմք",
                "ժպտալ",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("grande surriso con oculos surridente"),
            keywords: &[
                "aperte",
                "facie",
                "grande surriso con oculos surridente",
                "oculos",
                "surridente",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersenyum lebar dan mata tertutup"),
            keywords: &[
                "mata",
                "muka",
                "mulut",
                "senyum",
                "terbuka",
                "wajah",
                "wajah tersenyum lebar dan mata tertutup",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu amụ nwere mmepe ọnụ & anya amụ"),
            keywords: &[
                "amụ",
                "anya",
                "ihu",
                "ihu amụ nwere mmepe ọnụ & anya amụ",
                "mmepe",
                "ọnụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hlæjandi andlit"),
            keywords: &[
                "andlit",
                "bros",
                "bros og opinn munnur",
                "hlæja",
                "hlæjandi andlit",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con sorriso e occhi sorridenti"),
            keywords: &[
                "bocca aperta",
                "faccina con sorriso e occhi sorridenti",
                "faccina con un gran sorriso e occhi sorridenti",
                "occhi felici",
                "risata",
                "sorriso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("笑顔"),
            keywords: &["わーい", "スマイル", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu nganti merem-merem"),
            keywords: &[
                "cangkem",
                "mata",
                "menga",
                "mesem",
                "rai",
                "rai ngguyu nganti merem-merem",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე ღია პირითა და მომღიმარე თვალებით"),
            keywords: &[
                "თვალი",
                "მომღიმარე სახე ღია პირითა და მომღიმარე თვალებით",
                "პირი",
                "პირღია",
                "სახე",
                "ღია",
                "ღიმილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeh amesrar"),
            keywords: &["acmumeh amesrar"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аузын ашып, ыржиып тұрып күлу"),
            keywords: &[
                "аузын ашып, ыржиып тұрып күлу",
                "ауыз",
                "ашық",
                "бет",
                "жымию",
                "көз",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt med åben mund og smilende øjne"),
            keywords: &[
                "glad",
                "smil",
                "smilende ansigt med åben mund og smilende øjne",
                "smiley",
                "smileøjne",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើចទា\u{17c6}ងមាត\u{17cb} ន\u{17b7}ងភ\u{17d2}នែក"),
            keywords: &[
                "ភ\u{17d2}នែក",
                "មាត\u{17cb}",
                "ម\u{17bb}ខសើចទា\u{17c6}ងមាត\u{17cb} ន\u{17b7}ងភ\u{17d2}នែក",
                "សើច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಗುತ\u{ccd}ತ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳ ಮಂದಸ\u{ccd}ಮ\u{cbf}ತ ಮುಖ"),
            keywords: &[
                "ಕಣ\u{ccd}ಣು",
                "ನಗು",
                "ನಗುತ\u{ccd}ತ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳ ಮಂದಸ\u{ccd}ಮ\u{cbf}ತ ಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미소 짓는 눈으로 활짝 웃는 얼굴"),
            keywords: &[
                "미소",
                "미소 짓는 눈으로 활짝 웃는 얼굴",
                "스마일",
                "얼굴",
                "입 벌리고 웃는 눈웃음 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हा\u{902}स-या दोळ\u{94d}या\u{902}चो हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "उकत\u{947}\u{902}",
                "च\u{947}रो",
                "तो\u{902}ड",
                "दोळो",
                "हा\u{902}स-या दोळ\u{94d}या\u{902}चो हा\u{902}सपी च\u{947}रो",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("каткырып күлгөн бет"),
            keywords: &["бет", "каткыр", "каткырып күлгөн бет", "күл"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat oppenem Mond a laachenden Aen"),
            keywords: &[
                "A",
                "Gesiicht",
                "Laachen",
                "Mond",
                "laachend Gesiicht mat oppenem Mond a laachenden Aen",
                "oppen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຕາຍ\u{eb4}\u{ec9}ມ ແລະອ\u{ec9}າປາກ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຕະຫ\u{ebc}\u{ebb}ກ",
                "ຫ\u{ebb}ວ",
                "ຮາຮ\u{ec8}າ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຕາຍ\u{eb4}\u{ec9}ມ ແລະອ\u{ec9}າປາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis išsižiojęs veidas besišypsančiomis akimis"),
            keywords: &[
                "akys",
                "besišypsantis išsižiojęs veidas besišypsančiomis akimis",
                "burna",
                "praverta",
                "veidas",
                "šypsena",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smaidoša seja ar atvērtu muti un smaidošām acīm"),
            keywords: &[
                "atvērts",
                "mute",
                "seja",
                "smaidoša seja ar atvērtu muti un smaidošām acīm",
                "smaids",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene waha tuwhera me ngā karu menemene"),
            keywords: &[
                "kanohi",
                "kanohi menemene waha tuwhera me ngā karu menemene",
                "karu",
                "menemene",
                "tuwhera",
                "waha",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со отворена уста и насмеани очи"),
            keywords: &[
                "лице со отворена уста и насмеани очи",
                "насмеано лице со отворена уста и насмеани очи",
                "насмевка",
                "отворена",
                "очи",
                "уста",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കളോട\u{d41}ക\u{d42}ടിയ ഗോഷ\u{d4d}\u{200c}ടിച\u{d4d}ചിരിയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
            ),
            keywords: &[
                "കണ\u{d4d}ണ\u{d4d}",
                "ത\u{d41}റന\u{d4d}ന",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കളോട\u{d41}ക\u{d42}ടിയ ഗോഷ\u{d4d}\u{200c}ടിച\u{d4d}ചിരിയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
                "വ\u{d3e}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүдээ онийлгон маасайтал инээсэн царай"),
            keywords: &[
                "ам",
                "амаа ангайлган нүдээ онийлгон инээж буй царай",
                "ангайлгах",
                "инээх",
                "нүдээ онийлгон маасайтал инээсэн царай",
                "нүдээ онийлгох",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हसणार\u{947} डोळ\u{947}"),
            keywords: &[
                "उघड\u{947}",
                "च\u{947}हरा",
                "डोळ\u{947}",
                "तो\u{902}ड",
                "हसणार\u{947} डोळ\u{947}",
                "हसणाऱ\u{94d}या डोळ\u{94d}या\u{902}चा दात विचकणारा च\u{947}हरा",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersengih dan mata tersenyum"),
            keywords: &[
                "mata",
                "muka",
                "muka tersengih dan mata tersenyum",
                "mulut",
                "senyum",
                "terbuka",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jidħaq b’ħalq miftuħ u għajnejn jitbissmu"),
            keywords: &[
                "għajn",
                "jitbissem",
                "miftuħ",
                "wiċċ",
                "wiċċ jidħaq b’ħalq miftuħ u għajnejn jitbissmu",
                "ħalq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းများဖြင\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပါးစပ\u{103a}",
                "ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းများဖြင\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
                "ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032}မျက\u{103a}န\u{103e}ာန\u{103e}င\u{1037}\u{103a} ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းများ",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
                "ဟနေသည\u{103a}",
                "အပြ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smilefjes med åpen munn og smilende øyne"),
            keywords: &[
                "latter",
                "med tenner",
                "morsomt",
                "smil",
                "smilefjes",
                "smilefjes med åpen munn og smilende øyne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "ख\u{941}ला म\u{941}ख र चम\u{94d}किला आ\u{901}खासहितको ह\u{901}सिलो अन\u{941}हार",
            ),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}खा",
                "ख\u{941}ला",
                "ख\u{941}ला म\u{941}ख र चम\u{94d}किला आ\u{901}खासहितको ह\u{901}सिलो अन\u{941}हार",
                "म\u{941}ख",
                "म\u{941}स\u{94d}कान",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grijnzend gezicht met lachende ogen"),
            keywords: &[
                "gezicht",
                "grijnzend gezicht met lachende ogen",
                "lach",
                "mond",
                "oog",
                "open",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smilefjes med open munn og smilande auge"),
            keywords: &[
                "latter",
                "med tenner",
                "morosamt",
                "smil",
                "smilefjes",
                "smilefjes med open munn og smilande auge",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f} ସହ ହସକ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆଖ\u{b3f}",
                "ଖୋଲ\u{b3e}",
                "ପ\u{b3e}ଟ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}",
                "ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
                "ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f} ସହ ହସକ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਅਤ\u{a47} ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
            ),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਅਤ\u{a47} ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਅਤ\u{a47} ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਨਾਲ ਹਾਸਾ",
                "ਸਮਾਈਲੀ",
                "ਹਾਸਾ",
                "ਹ\u{a71}ਸਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھلے م\u{64f}نہ اتے مسکراندیاں اکھاں نال مسکراندی شکل"),
            keywords: &[
                "اکھ",
                "دی شکل",
                "مسکرانا",
                "منہ",
                "ک\u{64f}ھلا",
                "کھلے م\u{64f}نہ اتے مسکراندیاں اکھاں نال مسکراندی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láfín Fés Wit Shaínín Ai"),
            keywords: &[
                "Ai",
                "Fés",
                "Laf",
                "Láfín Fés Wit Shaínín Ai",
                "Láfín Fés Wit Shaínín Ai-dẹm",
                "Maut",
                "Ópun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz z otwartymi ustami i roześmianymi oczami"),
            keywords: &[
                "uśmiech",
                "uśmiechnięta twarz z otwartymi ustami i roześmianymi oczami",
                "wesoły",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدلی مخ د مسکېدلی سترګو سره"),
            keywords: &[
                "برسېره",
                "خله",
                "سترګه",
                "مخ",
                "مسکا",
                "مسکېدلی مخ د مسکېدلی سترګو",
                "مسکېدلی مخ د مسکېدلی سترګو سره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto risonho com olhos sorridentes"),
            keywords: &[
                "aberta",
                "boca",
                "olhos",
                "rosto",
                "rosto risonho com olhos sorridentes",
                "sorriso",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir com boca aberta e olhos sorridentes"),
            keywords: &[
                "aberta",
                "boca",
                "cara",
                "cara a sorrir com boca aberta e olhos sorridentes",
                "olho",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya kusisqa ñawikunawan"),
            keywords: &[
                "kichay",
                "kusi",
                "kusisqa uya kusisqa ñawikunawan",
                "simi",
                "uya",
                "ñawi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față încântată cu ochi zâmbitori"),
            keywords: &[
                "deschisă",
                "față",
                "față încântată cu ochi zâmbitori",
                "gură",
                "ochi",
                "zâmbet",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-840"),
            keywords: &["E10-840"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("смеется с закрытыми глазами"),
            keywords: &[
                "закрытые глаза",
                "радость",
                "смеется с закрытыми глазами",
                "смех",
                "улыбка с закрытыми глазами",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka n’umunwa wasamye n’amaso afunguye"),
            keywords: &[
                "gufungura",
                "ijisho",
                "isura",
                "isura iseka n’umunwa wasamye n’amaso afunguye",
                "kumwenyura",
                "umunwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کلندڙ اکين سان وڏي کل وارو چهرو"),
            keywords: &[
                "اک، چهرو، وات، کليل، کل،",
                "کلندڙ انکين سان وڏي کل وارو چهرو",
                "کلندڙ اکين سان وڏي کل وارو چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "කට ඇර\u{dd4}ණ ස\u{dd2}න\u{dcf}\u{dcf}සෙන ඇස\u{dca} සහ\u{dd2}ත ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
            ),
            keywords: &[
                "ඇස",
                "කට",
                "කට ඇර\u{dd4}ණ ස\u{dd2}න\u{dcf}\u{dcf}සෙන ඇස\u{dca} සහ\u{dd2}ත ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}වෘත",
                "ස\u{dd2}නහව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škeriaca sa tvár s\u{a0}prižmúrenými očami"),
            keywords: &[
                "oko",
                "prižmúrené",
                "tvár",
                "úsmev",
                "ústa",
                "škeriaca sa tvár s\u{a0}prižmúrenými očami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz z odprtimi usti in smejočimi očmi"),
            keywords: &[
                "nasmeh",
                "obraz",
                "odprto",
                "oči",
                "smejoči obraz z odprtimi usti in smejočimi očmi",
                "usta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji indho dhoola cadynaya leh"),
            keywords: &[
                "afka",
                "dareenka wajig oo indho dhoola cadeynaayo leh",
                "dhoolo cadeyn",
                "fur",
                "indhaha",
                "waji indho dhoola cadynaya leh",
                "wajiga",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me gojë të hapur dhe sy të qeshur"),
            keywords: &[
                "buzëqeshje",
                "e hapur",
                "fytyrë",
                "fytyrë e qeshur me gojën e hapur dhe sy të qeshur",
                "fytyrë me gojë të hapur dhe sy të qeshur",
                "gojë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које се слатко смеје"),
            keywords: &[
                "лице",
                "лице које се слатко смеје",
                "око",
                "осмех",
                "отворено",
                "уста",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице које се слатко смије"),
            keywords: &["лице које се слатко смије"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje se slatko smeje"),
            keywords: &[
                "lice",
                "lice koje se slatko smeje",
                "oko",
                "osmeh",
                "otvoreno",
                "usta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice koje se slatko smije"),
            keywords: &["lice koje se slatko smije"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flinande ansikte med leende ögon"),
            keywords: &[
                "flinande ansikte med leende ögon",
                "leende ögon",
                "roligt",
                "skratt",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu wenye macho ya tabasamu"),
            keywords: &[
                "funguliwa",
                "jicho",
                "mdomo",
                "tabasamu",
                "uso",
                "uso unaokenua wenye macho ya tabasamu",
                "uso unaotabasamu wenye macho ya tabasamu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "வ\u{bbe}ய\u{bcd} நிறைய சிரிப\u{bcd}புடன\u{bcd} புன\u{bcd}னகைக\u{bcd}கும\u{bcd} கண\u{bcd}கள\u{bcd} கொண\u{bcd}ட முகம\u{bcd}",
            ),
            keywords: &[
                "கண\u{bcd}",
                "சிரிப\u{bcd}பு",
                "பொங\u{bcd}கும\u{bcd} சிரிப\u{bcd}பு",
                "முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd}",
                "வ\u{bbe}ய\u{bcd} நிறைய சிரிப\u{bcd}புடன\u{bcd} புன\u{bcd}னகைக\u{bcd}கும\u{bcd} கண\u{bcd}கள\u{bcd} கொண\u{bcd}ட முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} సంత\u{c4b}షంత\u{c4b} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "నవ\u{c4d}వు",
                "న\u{c4b}రు",
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} సంత\u{c4b}షంత\u{c4b} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "ముఖం",
                "సంత\u{c4b}షం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо даҳони кушода ва чашмони хандон"),
            keywords: &[
                "даҳон",
                "кушода",
                "рӯи хандон бо даҳони кушода ва чашмони хандон",
                "рӯй",
                "табассум",
                "чашм",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าย\u{e34}\u{e49}มตาย\u{e34}\u{e49}ม และอ\u{e49}าปาก"),
            keywords: &[
                "ตลก",
                "ย\u{e34}\u{e49}ม",
                "หน\u{e49}า",
                "หน\u{e49}าย\u{e34}\u{e49}มตาย\u{e34}\u{e49}ม และอ\u{e49}าปาก",
                "ห\u{e31}วเราะ",
                "ฮ\u{e48}าฮ\u{e48}า",
                "ฮ\u{e48}าๆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gülýän gözli syrtarýan ýüz"),
            keywords: &[
                "agyz",
                "açyk",
                "göz",
                "gülýän gözli syrtarýan ýüz",
                "ýylgyrmak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fiefia moe kanoʻimata malimali"),
            keywords: &["mata fiefia moe kanoʻimata malimali"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gülen gözlerle ağzı açık sırıtma"),
            keywords: &[
                "ağzı açık gülen gözler",
                "gülen gözlerle ağzı açık sırıtma",
                "gülen yüz",
                "gülme",
                "gülümseme",
                "lol",
                "neşeli",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزىنى ئېچىپ كۈلۈمسىرىگەن چىراي"),
            keywords: &[
                "ئاغزىنى ئېچىپ كۈلۈمسىرىگەن چىراي",
                "ئوچۇق",
                "ئېغىز",
                "كۆز",
                "كۈلۈش",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("широко всміхнене обличчя з примруженими очима"),
            keywords: &[
                "відкритий",
                "обличчя",
                "очі",
                "посмішка",
                "рот",
                "усміхнене обличчя з відкритим ротом і примруженими очима",
                "широко всміхнене обличчя з примруженими очима",
                "широко усміхнене обличчя зі змруженими очима",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلے منہ اور مسکراتی آنکھوں والا مسکراتا چہرہ"),
            keywords: &[
                "آنکھ",
                "مسکراہٹ",
                "منہ",
                "چہرہ",
                "کھلے منہ اور مسکراتی آنکھوں والا مسکراتا چہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tabassum, og‘iz ochiq, ko‘zlar qisilgan"),
            keywords: &[
                "ko‘z",
                "ochiq",
                "og‘iz",
                "tabassum",
                "tabassum, og‘iz ochiq, ko‘zlar qisilgan",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười miệng há mắt cười"),
            keywords: &[
                "cười",
                "miệng",
                "mắt",
                "mặt",
                "mặt cười miệng há mắt cười",
                "mở",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy muuñ ak ubbeeku gémmiñ ak muuñ bët"),
            keywords: &[
                "bët",
                "gémmiñ",
                "kanam",
                "kanam guy muuñ ak ubbeeku gémmiñ ak muuñ bët",
                "muuñ",
                "ubbeeku",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obunomlomo ovulekileyo namehlo ancumileyo"),
            keywords: &[
                "iliso",
                "ubuso obuncumileyo obunomlomo ovulekileyo namehlo ancumileyo",
                "umlomo",
                "uncumo",
                "vulekileyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some(
                "ojú tó ń rẹ\u{301}rìń músẹ\u{301} pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti ẹyinjú tó ń rkrìń músẹ\u{301}",
            ),
            keywords: &[
                "ojú",
                "ojú tó ń rẹ\u{301}rìń músẹ\u{301} pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti ẹyinjú tó ń rkrìń músẹ\u{301}",
                "rẹ\u{301}rìń músẹ\u{301}",
                "ṣí",
                "ẹnu",
                "ẹyinjú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("笑臉同微笑眼睛"),
            keywords: &["嘴", "微笑", "打開", "眼", "笑臉同微笑眼睛", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("笑脸同微笑眼睛"),
            keywords: &["嘴", "微笑", "打开", "眼", "笑脸同微笑眼睛", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("大笑"),
            keywords: &["哈哈", "大笑", "开心", "笑", "脸", "高兴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("呵呵"),
            keywords: &["呵呵", "哈哈", "笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("含笑同笑嘻嘻嘅表情"),
            keywords: &[
                "含笑同笑嘻嘻嘅表情",
                "含笑嘅眼睛同笑嘻嘻嘅表情",
                "哈哈",
                "笑臉",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizelayo obuvule umlomo bunamehlo ajabule"),
            keywords: &[
                "ajabule",
                "buvule",
                "ubuso",
                "ubuso obumoyizelayo obuvule umlomo bunamehlo ajabule",
                "umlomo",
            ],
        },
    ],
};
#[doc = "😁"]
pub const BEAMING_FACE_WITH_SMILING_EYES: crate::Emoji = crate::Emoji {
    glyph: "😁",
    codepoint: "1F601",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "beaming face with smiling eyes",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grinnikende gesig met glimlaggende oë"),
            keywords: &[
                "gesig",
                "glimlag",
                "grinnik",
                "grinnikende gesig met glimlaggende oë",
                "oog",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሣቂታ ዓይኖች ያሉት ፊት"),
            keywords: &["ሣቂታ ዓይኖች ያሉት ፊት", "ሣቅ", "ዓይን", "ፈገግታ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مشرق بعينين باسمتين"),
            keywords: &[
                "إشراقة",
                "ابتسامة",
                "عين",
                "وجه",
                "وجه مشرق بأعين باسمة",
                "وجه مشرق بعينين باسمتين",
                "وجه مشرق مع عينين مبتسمتين",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}স\u{9cd}যম\u{9c1}খী চক\u{9c1}ৰ সৈতে উজ\u{9cd}জ\u{9cd}বল ম\u{9c1}খ"),
            keywords: &[
                "চক\u{9c1}",
                "ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি",
                "হ\u{9be}স\u{9cd}যম\u{9c1}খী চক\u{9c1}ৰ সৈতে উজ\u{9cd}জ\u{9cd}বল ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gülən gözlərlə gülən üz"),
            keywords: &["göz", "gülmək", "gülən gözlərlə gülən üz", "təbəssüm", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шырока ўсміхаецца, прыплюшчыўшы вочы"),
            keywords: &[
                "вочы",
                "зубы",
                "усмешка",
                "шырока ўсміхаецца, прыплюшчыўшы вочы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сияещо лице с усмихващи се очи"),
            keywords: &[
                "Сияещо лице с усмихващи се очи",
                "лице",
                "око",
                "усмивка",
                "ухилване",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খে দে\u{981}তো হ\u{9be}সি"),
            keywords: &[
                "চোখ",
                "চোখে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খে দে\u{981}তো হ\u{9be}সি",
                "দে\u{981}তো হ\u{9be}সি",
                "ম\u{9c1}খ",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("cerenje sa škiljenjem"),
            keywords: &[
                "cerenje",
                "cerenje sa škiljenjem",
                "lice",
                "osmijeh",
                "oči",
                "škiljenje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara molt somrient amb els ulls alegres"),
            keywords: &[
                "cara",
                "cara molt somrient amb els ulls alegres",
                "gran somriure",
                "ulls",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄎\u{11127}𑄣\u{11134}𑄎\u{11127}𑄣\u{11133}𑄣𑄬 𑄟\u{1112a} 𑄣\u{11127}𑄉𑄬 𑄦𑄎\u{11133}𑄎𑄬 𑄦𑄎\u{11133}𑄎𑄬 𑄌\u{1112e}𑄉\u{11127}",
            ),
            keywords: &[
                "𑄎\u{11127}𑄣\u{11134}𑄎\u{11127}𑄣\u{11133}𑄣𑄬 𑄟\u{1112a} 𑄣\u{11127}𑄉𑄬 𑄦𑄎\u{11133}𑄎𑄬 𑄦𑄎\u{11133}𑄎𑄬 𑄌\u{1112e}𑄉\u{11127}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎾᏍᎩ ᎤᏤᏣᏍᏗ ᏓᎧᏅᎢ"),
            keywords: &["ᎠᎦᏘ", "ᎤᎧᏛ", "ᎤᏤᏣᏍᏗ", "ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎾᏍᎩ ᎤᏤᏣᏍᏗ ᏓᎧᏅᎢ", "ᎤᏰᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rozzářený obličej s usměvavýma očima"),
            keywords: &[
                "oko",
                "rozzářený obličej s usměvavýma očima",
                "smajlík",
                "tvář",
                "výraz",
                "úsměv",
                "úšklebek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn lledwenu â gwên yn y llygaid"),
            keywords: &[
                "gwenu",
                "lledwenu",
                "llygaid",
                "wyneb",
                "wyneb yn lledwenu â gwên yn y llygaid",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("strålende ansigt med smilende øjne"),
            keywords: &[
                "ansigt der griner",
                "glad",
                "smiley",
                "strålende ansigt med smilende øjne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("strahlendes Gesicht mit lachenden Augen"),
            keywords: &[
                "Gesicht",
                "Zähne",
                "lustig",
                "strahlendes Gesicht mit lachenden Augen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("περιχαρές πρόσωπο με γελαστά μάτια"),
            keywords: &[
                "μάτι",
                "περιχαρές πρόσωπο με γελαστά μάτια",
                "πρόσωπο",
                "σαρκασμός",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("beaming face with smiling eyes"),
            keywords: &[
                "beaming face with smiling eyes",
                "eye",
                "face",
                "grin",
                "smile",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara radiante con ojos sonrientes"),
            keywords: &[
                "cara",
                "cara radiante con ojos sonrientes",
                "ojo",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara y ojos sonrientes"),
            keywords: &[
                "cara",
                "cara y ojos sonrientes",
                "divertido",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara radiante con ojos sonrientes"),
            keywords: &[
                "cara",
                "cara radiante con ojos sonrientes",
                "divertido",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara radiante con ojos sonrientes"),
            keywords: &[
                "cara",
                "cara radiante con ojos sonrientes",
                "divertido",
                "ojo",
                "sonrisa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naerul silmade ja laia naeratusega nägu"),
            keywords: &[
                "irve",
                "naeratus",
                "naerul silmade ja laia naeratusega nägu",
                "nägu",
                "silm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begiez barre egiten ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "barre",
                "begi",
                "begiez barre egiten ari den aurpegia",
                "irribarre",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خنده\u{654} دندانی"),
            keywords: &[
                "تبسم",
                "خنده\u{654} دندانی",
                "صورت",
                "صورت شاد با چشمان خندان",
                "نیشخند",
                "چشم",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("virnistys ja hymyilevät silmät"),
            keywords: &[
                "hymy",
                "kasvot",
                "naama",
                "silmä",
                "virnistys",
                "virnistys ja hymyilevät silmät",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangiti pati ang mga mata"),
            keywords: &[
                "malaking ngiti",
                "mata",
                "mukha",
                "nakangiti",
                "nakangiti nang malaki kasama ang mga mata",
                "nakangiti pati ang mga mata",
                "ngiti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("strálandi andlit við brosandi eygum"),
            keywords: &[
                "andlit",
                "bros",
                "eyga",
                "grín",
                "smíl",
                "strálandi andlit við brosandi eygum",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage souriant aux yeux rieurs"),
            keywords: &["dents", "sourire", "visage souriant aux yeux rieurs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage radieux et yeux rieurs"),
            keywords: &[
                "grand sourire",
                "large sourire",
                "sourire",
                "visage",
                "visage radieux et yeux rieurs",
                "œil",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog gháire le súile & miongháire"),
            keywords: &[
                "gáire",
                "meangadh",
                "straoiseag gáire le súile ag déanamh miongháire",
                "straoiseog gháire le súile & miongháire",
                "straoiseog gháire le súile ag déanamh miongháire",
                "súile ag gáire",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire mhòr"),
            keywords: &["aodann", "aodann le gàire mhòr", "fiamh-ghàire", "sùil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara radiante cos ollos alegres"),
            keywords: &[
                "cara radiante cos ollos alegres",
                "ollos alegres",
                "sorriso",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હસતી આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "આ\u{a82}ખ",
                "ચહ\u{ac7}રો",
                "સ\u{acd}મિત",
                "હસતી આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "હસવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushin baki har kunne tare da idanu masu murmushi"),
            keywords: &[
                "fuska",
                "fuska mai murmushin baki har kunne tare da idanu masu murmushi",
                "ido",
                "murmushi",
                "murmushi na baki har kunne",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף זורח עם עיניים מחייכות"),
            keywords: &[
                "זורח",
                "חיוך",
                "עיניים",
                "פרצוף",
                "פרצוף זורח עם עיניים מחייכות",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "म\u{941}स\u{94d}काती आ\u{901}खो\u{902} क\u{947} साथ खी\u{902}स\u{947}\u{902} निपोरना",
            ),
            keywords: &[
                "आ\u{901}ख",
                "खीस",
                "च\u{947}हरा",
                "म\u{941}स\u{94d}काती आ\u{901}खो\u{902} क\u{947} साथ खी\u{902}स\u{947}\u{902} निपोरना",
                "म\u{941}स\u{94d}क\u{941}राहट",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sretno lice s nasmiješenim očima"),
            keywords: &[
                "lice",
                "lice koje sija od zadovoljstva s nasmiješenim očima",
                "oči",
                "smiješak",
                "sretno lice s nasmiješenim očima",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mosolygó szemmel nevető arc"),
            keywords: &["arc", "mosoly", "mosolygó szemmel nevető arc", "szem"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծիծաղող դեմք ժպտացող աչքերով"),
            keywords: &[
                "աչք",
                "դեմք",
                "ժպտալ",
                "ծիծաղող դեմք ժպտացող աչքերով",
                "քմծիծաղել",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("visage radiante con oculos surridente"),
            keywords: &[
                "facie",
                "radiante",
                "surridente",
                "surriso",
                "visage",
                "visage radiante con oculos surridente",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah gembira dengan mata bahagia"),
            keywords: &[
                "cengiran",
                "mata",
                "muka",
                "senyum",
                "wajah gembira dengan mata bahagia",
                "wajah tersenyum lebar",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ọchị nwere anya amụ"),
            keywords: &["amụ", "anya", "ihu", "ihu ọchị nwere anya amụ", "ọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("glottandi andlit með brosandi augum"),
            keywords: &[
                "andlit",
                "glottandi andlit",
                "glottandi andlit með brosandi augum",
                "hlæja",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina raggiante con occhi felici"),
            keywords: &[
                "faccina",
                "faccina raggiante con occhi felici",
                "occhi felici",
                "risata",
                "sogghignare",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("にやっと笑う"),
            keywords: &["にやっと笑う", "スマイル", "笑う", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu mecengis nganti merem"),
            keywords: &[
                "mata",
                "mecengis",
                "mesem",
                "rai",
                "rai ngguyu mecengis nganti merem",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაკრეჭილი სახე მომღიმარე თვალებით"),
            keywords: &[
                "დაკრეჭა",
                "დაკრეჭილი",
                "დაკრეჭილი სახე მომღიმარე თვალებით",
                "თვალი",
                "სახე",
                "ღიმილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeḥ n tuɣmas meṛṛa"),
            keywords: &["acmumeḥ n tuɣmas meṛṛa"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бал-бұл жайнап күлу"),
            keywords: &["бал-бұл жайнап күлу", "бет", "езу тарту", "күлу", "көз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grinende ansigt med smilende øjne"),
            keywords: &[
                "ansigt der griner",
                "glad",
                "grinende ansigt med smilende øjne",
                "smiley",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើចស\u{17d2}អេញ"),
            keywords: &[
                "ធ\u{17d2}មេញ",
                "ម\u{17bb}ខសើចស\u{17d2}អេញ",
                "ម\u{17bb}\u{17bb}ខ",
                "ស\u{17d2}អេញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಗುವ ಕಣ\u{ccd}ಣುಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಹೊಳ\u{cc6}ಯುವ ಮುಖ"),
            keywords: &[
                "ಕಣ\u{ccd}ಣು",
                "ನಗು",
                "ನಗುವ ಕಣ\u{ccd}ಣುಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಹೊಳ\u{cc6}ಯುವ ಮುಖ",
                "ಮುಖ",
                "ಹಾಸ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미소 짓는 눈으로 웃는 얼굴"),
            keywords: &[
                "눈웃음",
                "미소",
                "미소 짓는 눈으로 웃는 얼굴",
                "스마일",
                "얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हा\u{902}सपी दोळ\u{94d}या\u{902}चो आन\u{902}दी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "दोळो",
                "हा\u{902}स-या दोळ\u{94d}या\u{902}चो आन\u{902}दी च\u{947}रो",
                "हा\u{902}सप",
                "हा\u{902}सपी दोळ\u{94d}या\u{902}चो आन\u{902}दी च\u{947}रो",
                "हा\u{902}स\u{94d}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көздөрүн жымыңдатып ырсайган бет"),
            keywords: &[
                "бет",
                "жымыңда",
                "көз",
                "көздөрүн жымыңдатып ырсайган бет",
                "ырсай",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Grinsgesiicht mat laachenden Aen"),
            keywords: &[
                "A",
                "Gesiicht",
                "Grinsen",
                "Grinsgesiicht mat laachenden Aen",
                "Laachen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຍ\u{eb4}\u{ec8}ງແຂ\u{ec9}ວຕາຍ\u{eb4}\u{ec9}ມ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec8}ງແຂ\u{ec9}ວ",
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຮາຮ\u{ec8}າ",
                "ຮ\u{eb5}ຮ\u{eb5}\u{ec8}",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຍ\u{eb4}\u{ec8}ງແຂ\u{ec9}ວຕາຍ\u{eb4}\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("išsišiepęs veidas su besišypsančiomis akimis"),
            keywords: &[
                "akys",
                "išsišiepti",
                "išsišiepęs veidas su besišypsančiomis akimis",
                "veidas",
                "šypsena",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plats smaids un smaidošas acis"),
            keywords: &["plats smaids un smaidošas acis", "seja", "smaids", "smīns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi pakiri karu menemene"),
            keywords: &["kanohi", "karu", "menemene", "pakiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("широко насмеано лице со насмеани очи"),
            keywords: &[
                "лице",
                "насмевка",
                "око",
                "широка насмевка",
                "широко насмеано лице со насмеани очи",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കള\u{d41}മ\u{d3e}യി പ\u{d4d}രസന\u{d4d}നമ\u{d3e}യ മ\u{d41}ഖം",
            ),
            keywords: &[
                "കണ\u{d4d}ണ\u{d4d}",
                "കളിയ\u{d3e}ക\u{d4d}കൽ",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കള\u{d41}മ\u{d3e}യി പ\u{d4d}രസന\u{d4d}നമ\u{d3e}യ മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүдээ онийлгон инээсэн царай"),
            keywords: &[
                "инээх",
                "нүд",
                "нүдээ онийлгон инээсэн царай",
                "онийлгох",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हसणाऱ\u{94d}या डोळ\u{94d}या\u{902}सह दात विचकणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "डोळ\u{947}",
                "विचकवण\u{947}",
                "हसणाऱ\u{94d}या डोळ\u{94d}या\u{902}सह दात विचकणारा च\u{947}हरा",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka berseri-seri dengan mata tersenyum"),
            keywords: &[
                "mata",
                "muka",
                "muka berseri-seri dengan mata tersenyum",
                "sengih",
                "senyum",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jidħak ħafna b’għajnejn jitbissmu"),
            keywords: &[
                "għajn",
                "jidħaq ħafna",
                "jitbissem",
                "wiċċ",
                "wiċċ jidħak ħafna b’għajnejn jitbissmu",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းများဖြင\u{1037}\u{103a} ပ\u{102e}တ\u{102d}ဖြာနေသော မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပြ\u{102f}\u{1036}း",
                "ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းများဖြင\u{1037}\u{103a} ပ\u{102e}တ\u{102d}ဖြာနေသော မျက\u{103a}န\u{103e}ာ",
                "ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032}",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}လ\u{102f}\u{1036}းများ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glisefjes med smilende øyne"),
            keywords: &[
                "fjes",
                "glis",
                "glisefjes med smilende øyne",
                "latter",
                "lol",
                "smil",
                "smilefjes",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "रमाएका आ\u{901}खासहित मन\u{94d}दम\u{941}स\u{94d}कानय\u{941}क\u{94d}त अन\u{941}हार",
            ),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}खा",
                "म\u{941}स\u{94d}कान",
                "रमाएका आ\u{901}खासहित मन\u{94d}दम\u{941}स\u{94d}कानय\u{941}क\u{94d}त अन\u{941}हार",
                "ह\u{901}सिलो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stralend gezicht met lachende ogen"),
            keywords: &[
                "gezicht",
                "grijns",
                "lach",
                "oog",
                "stralend gezicht met lachende ogen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glisefjes med smilande auge"),
            keywords: &[
                "fjes",
                "glis",
                "glisefjes med smilande auge",
                "latter",
                "lol",
                "smil",
                "smilefjes",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହସହସ\u{b3f}ଆ ଆଖ\u{b3f} ସହ ଆନନ\u{b4d}ଦ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆଖ\u{b3f} । ମ\u{b41}ହ\u{b01} । ଦ\u{b3e}ନ\u{b4d}ତ ଦେଖ\u{b3e}ଇ ହସ\u{b3f}ବ\u{b3e} । ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
                "ହସହସ\u{b3f}ଆ ଆଖ\u{b3f} ସହ ଆନନ\u{b4d}ଦ\u{b3f}ତ ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹਸਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹਸਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਵਾਲਾ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਉਣਾ",
                "ਮ\u{a41}ਸਕਾਨ",
                "ਮ\u{a41}\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مسکراندیاں اکھاں نال دند پیسدی شکل"),
            keywords: &[
                "اکھ",
                "داند پیسنا",
                "دی شکل",
                "مسکرانا",
                "مسکراندیاں اکھاں نال دند پیسدی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bíg Laf Wit Wait Tit"),
            keywords: &["Ai", "Bíg Laf", "Bíg Laf Wit Wait Tit", "Fes", "Hápí Laf"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szeroko uśmiechnięta twarz o roześmianych oczach"),
            keywords: &[
                "szeroko uśmiechnięta twarz o roześmianych oczach",
                "uśmiech",
                "wyszczerzone",
                "zęby",
                "śmiech",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پړقېدونکی مخ دمسکېدلي سترګو سره"),
            keywords: &[
                "خندا",
                "سترګه",
                "مخ",
                "مسکا",
                "پړقېدونکی مخ دمسکېدلي سترګو سره",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto contente com olhos sorridentes"),
            keywords: &[
                "olho",
                "rosto",
                "rosto contente com olhos sorridentes",
                "rosto rindo com olhos sorridentes",
                "sorriso",
                "sorriso aberto",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara sorridente com olhos sorridentes"),
            keywords: &[
                "cara",
                "cara sorridente com olhos sorridentes",
                "olho",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kancharisqa uya kusisqa ñawikunawan"),
            keywords: &[
                "asiy",
                "kancharisqa uya kusisqa ñawikunawan",
                "kusi",
                "kʼancharisqa uya kusisqa ñawikunawan",
                "uya",
                "ñawi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față radioasă cu ochi zâmbitori"),
            keywords: &[
                "față",
                "față radioasă cu ochi zâmbitori",
                "ochi",
                "zâmbet",
                "încântare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-837"),
            keywords: &["E10-837"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("светится от счастья"),
            keywords: &[
                "зубы",
                "светится от счастья",
                "счастливое лицо",
                "улыбающиеся глаза",
                "широкая улыбка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura imwenyura n’amaso yuje inseko"),
            keywords: &[
                "ijisho",
                "inseko",
                "isura",
                "isura imwenyura n’amaso yuje inseko",
                "kumwenyura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کلندڙ اکين سان گڏ چمڪندڙ چهرو"),
            keywords: &[
                "اک",
                "مرڪ",
                "مرڪندڙ اکين سان ٻھڪندڙ چھرو",
                "وڏي کل",
                "چھرو",
                "کلندڙ اکين سان گڏ چمڪندڙ چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ස\u{dd2}න\u{dcf}සෙන ඇස\u{dca} සහ\u{dd2}ත දත\u{dca} ව\u{dd2}ර\u{dd2}තත\u{dca}න ම\u{dd4}හ\u{dd4}ණ",
            ),
            keywords: &[
                "ඇස",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}නහව",
                "ස\u{dd2}න\u{dcf}සෙන ඇස\u{dca} සහ\u{dd2}ත දත\u{dca} ව\u{dd2}ර\u{dd2}තත\u{dca}න ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("natešená tvár s\u{a0}prižmúrenými očami"),
            keywords: &[
                "natešená tvár s\u{a0}prižmúrenými očami",
                "oko",
                "tvár",
                "úsmev",
                "úškrn",
                "úškľabok",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("režeči obraz s smejočimi očmi"),
            keywords: &[
                "nasmeh",
                "obraz",
                "oči",
                "režanje",
                "režeči obraz s smejočimi očmi",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dhalaal indho dhoola cadeynaaayo leh"),
            keywords: &[
                "dhoola cadeyn",
                "gariir",
                "indho",
                "waji",
                "waji dhalaal indho dhoola cadeynaaayo leh",
                "waji dhalaalaayo oo indho dhoolo cadeynaayo leh",
                "wajiga",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e zgërdheshur me sy të qeshur"),
            keywords: &[
                "fytyrë e zgërdheshur me sy të qeshur",
                "sy",
                "zgërdheshje",
                "zgërdhihem",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са кезом"),
            keywords: &["лице", "лице са кезом", "око", "осмех", "широки осмех"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са кезом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa kezom"),
            keywords: &["lice", "lice sa kezom", "oko", "osmeh", "široki osmeh"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa kezom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("strålande ansikte med leende ögon"),
            keywords: &[
                "leende",
                "roligt",
                "skratt",
                "strålande ansikte med leende ögon",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliokenua na macho yanayotabasamu"),
            keywords: &[
                "kenua",
                "macho",
                "tabasamu",
                "uso",
                "uso uliokenua na macho yanayotabasamu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிரித\u{bcd}த கண\u{bcd}களுடன\u{bcd} ஒளி வ\u{bc0}சும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கண\u{bcd}",
                "சிரித\u{bcd}த கண\u{bcd}களுடன\u{bcd} ஒளி வ\u{bc0}சும\u{bcd} முகம\u{bcd}",
                "சிரிப\u{bcd}பு",
                "புன\u{bcd}னகை",
                "பெருமிதச\u{bcd} சிரிப\u{bcd}பு",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పళ\u{c4d}లు బయటకు ప\u{c46}ట\u{c4d}ట\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం"),
            keywords: &[
                "నవ\u{c4d}వు",
                "పళ\u{c4d}లు బయటకు ప\u{c46}ట\u{c4d}ట\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "పళ\u{c4d}లు బయట\u{c3f}క\u{c3f} ప\u{c46}ట\u{c4d}ట\u{c3f} ఉండటం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чеҳраи писхандкунанда бо чашмони табассумкунанда"),
            keywords: &[
                "рӯй",
                "табассум кардан",
                "фарох табассум кардан",
                "чашм",
                "чеҳраи писхандкунанда бо чашмони табассумкунанда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e34}\u{e49}มย\u{e34}งฟ\u{e31}นตาย\u{e34}\u{e49}ม"),
            keywords: &[
                "ย\u{e34}งฟ\u{e31}น",
                "ย\u{e34}\u{e49}ม",
                "ย\u{e34}\u{e49}มย\u{e34}งฟ\u{e31}นตาย\u{e34}\u{e49}ม",
                "หน\u{e49}า",
                "ฮ\u{e35}\u{e48}ฮ\u{e35}\u{e48}",
                "ฮ\u{e35}\u{e48}ๆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gülýän gözli ýyrşarýan ýüz"),
            keywords: &[
                "göz",
                "gülýän gözli ýyrşarýan ýüz",
                "syrtarmak",
                "ýylgyrmak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata ina moe kanoʻimata malimali"),
            keywords: &["mata ina moe kanoʻimata malimali"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gülen gözlerle sırıtma"),
            keywords: &[
                "gülen gözlerle sırıtan yüz",
                "gülen gözlerle sırıtma",
                "gülen yüz",
                "gülme",
                "gülümseme",
                "gülümseyen gözler",
                "lol",
                "neşeli",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىشىنى چىقىرىپ كۈلۈمسىرەش"),
            keywords: &[
                "كۆز",
                "كۈلۈمسىرەش",
                "مۈشۈك",
                "چىراي",
                "چىش",
                "چىشىنى چىقىرىپ كۈلۈمسىرەش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("осяйно всміхнене обличчя й очі"),
            keywords: &[
                "обличчя",
                "осяйно всміхнене обличчя й очі",
                "осяйно усміхнене обличчя з усміхненими очима",
                "осяйно усміхнене обличчя й очі",
                "очі",
                "усмішка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مسکراتی آنکھیں لیے ہنستا چہرہ"),
            keywords: &[
                "آنکھ",
                "مسکراتی آنکھیں لیے ہنستا چہرہ",
                "مسکراہٹ",
                "منہ",
                "چہرہ",
                "کھلا",
                "ہنسنا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tirjaygan yuz, qisilgan ko‘zlar"),
            keywords: &[
                "ko‘z",
                "tabassum",
                "tirjaygan yuz, qisilgan ko‘zlar",
                "tirjayish",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười toét mắt cười"),
            keywords: &["cười", "mắt", "mặt", "mặt cười toét mắt cười", "toe toét"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy gaññi ak bët yuy muuñ"),
            keywords: &[
                "bët",
                "gaññi",
                "kanam",
                "kanam guy gaññi ak bët yuy muuñ",
                "muuñ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuhlekayo obunamehlo ancumileyo"),
            keywords: &[
                "hleka",
                "iliso",
                "ncuma",
                "ubuso",
                "ubuso obuhlekayo obunamehlo ancumileyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó fẹyín pẹ\u{300}lú Ẹyinjú tó rẹ\u{301}rìn músẹ\u{301}"),
            keywords: &[
                "Ojú tó fẹyín pẹ\u{300}lú Ẹyinjú tó rẹ\u{301}rìn músẹ\u{301}",
                "fẹyín",
                "ojú",
                "rẹ\u{301}rìn músẹ\u{301}",
                "ẹyinjú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("帶著微笑眼睛嘅歡欣臉孔"),
            keywords: &[
                "光著臉同微笑眼睛",
                "咧嘴笑",
                "帶著微笑眼睛嘅歡欣臉孔",
                "微笑",
                "眼",
                "臉",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("光着脸同微笑眼睛"),
            keywords: &["光着脸同微笑眼睛", "咧嘴笑", "微笑", "眼", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("嘻嘻"),
            keywords: &["嘻嘻", "笑脸", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("嘻嘻"),
            keywords: &["嘻嘻", "笑臉", "露齒而笑"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("含笑嘅眼睛同笑嘻嘻嘅表情"),
            keywords: &["含笑嘅眼睛同笑嘻嘻嘅表情", "嘻嘻"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obusinekile obunamehlo amoyizelayo"),
            keywords: &[
                "sineka umoyizele",
                "ubuso obusinekile obunamehlo amoyizelayo",
            ],
        },
    ],
};
#[doc = "😆"]
pub const GRINNING_SQUINTING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😆",
    codepoint: "1F606",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "grinning squinting face",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lag gesig met toe oë"),
            keywords: &[
                "gesig",
                "glimlag",
                "glimlaggende gesig met oop mond en oë styf toe",
                "lag",
                "lag gesig met toe oë",
                "mond",
                "oop",
                "tevrede",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከተከፈተ አፍ ጋር ሣቂታ ፊት እና የተጨፈኑ ዓይኖች"),
            keywords: &["ሣቅ", "አፍ", "ከተከፈተ አፍ ጋር ሣቂታ ፊት እና የተጨፈኑ ዓይኖች", "ክፍት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مبتسم بعينين مغلقتين"),
            keywords: &[
                "ابتسامة بأعين مغلقة",
                "فم مفتوح",
                "وجه مبتسم بعينين محدقتين",
                "وجه مبتسم بعينين مغلقتين",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}\u{981}হি থক\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "অট\u{9cd}টহ\u{9be}স\u{9cd}য",
                "খোল\u{9be}",
                "ম\u{9c1}খ",
                "সন\u{9cd}ত\u{9c1}ষ\u{9cd}টি",
                "হ\u{9be}\u{981}হি",
                "হ\u{9be}\u{981}হি থক\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq ağız və bərk yumulmuş gözlərlə gülən üz"),
            keywords: &[
                "açıq",
                "açıq ağız və bərk yumulmuş gözlərlə gülən üz",
                "ağız",
                "gülüş",
                "məmnun",
                "təbəssüm",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("смяецца, адкрыўшы рот і заплюшчыўшы вочы"),
            keywords: &[
                "адкрыты",
                "задаволены",
                "рот",
                "смех",
                "смяецца, адкрыўшы рот і заплюшчыўшы вочы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("широко усмихнато лице с присвити очи"),
            keywords: &[
                "Широко усмихнато лице с присвити очи",
                "лице",
                "смях",
                "усмивка",
                "уста",
                "широко усмихнато лице с присвити очи",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখ বন\u{9cd}ধ করে দে\u{981}তো হ\u{9be}সি"),
            keywords: &[
                "খোল\u{9be}",
                "চোখ বন\u{9cd}ধ করে দে\u{981}তো হ\u{9be}সি",
                "জোরে হ\u{9be}স\u{9be}",
                "ঠো\u{981}ট",
                "ম\u{9c1}খ",
                "ম\u{9c1}খে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খ খোল\u{9be} এবং এ\u{981}টে চোখ বন\u{9cd}ধ কর\u{9be}",
                "সন\u{9cd}ত\u{9c1}ষ\u{9cd}ট",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kez žmireći"),
            keywords: &["kez žmireći", "lice", "smijeh", "zadovoljstvo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara somrient amb els ulls tancats fortament"),
            keywords: &[
                "boca oberta",
                "cara",
                "cara somrient amb els ulls tancats fortament",
                "somriure",
                "ulls tancats",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᏣᏍᏗ ᏍᏈᏘ ᎤᎧᏛ"),
            keywords: &["ᎠᎰᎵ", "ᎤᎧᏛ", "ᎤᎵᎮᎵᏨᎢ", "ᎤᏤᏣᏍᏗ", "ᎤᏤᏣᏍᏗ ᏍᏈᏘ ᎤᎧᏛ", "ᎤᏰᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zubící se obličej s mžourajícíma očima"),
            keywords: &[
                "otevřený",
                "smajlík",
                "smích",
                "spokojený",
                "tvář",
                "výraz",
                "zubící se obličej s mžourajícíma očima",
                "úsměv",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â cheg agored a llygaid ynghau"),
            keywords: &[
                "bodlon",
                "ceg",
                "chwerthin",
                "wyneb",
                "wyneb yn gwenu â cheg agored a llygaid ynghau",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grinende ansigt med lukkede øjne"),
            keywords: &[
                "glad",
                "grinende ansigt med lukkede øjne",
                "grinende ansigt med åben mund og lukkede øjne",
                "lukkede øjne",
                "smil",
                "smil med lukkede øjne",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grinsendes Gesicht mit zusammengekniffenen Augen"),
            keywords: &[
                "Gesicht",
                "geschlossene Augen",
                "grinsendes Gesicht mit zusammengekniffenen Augen",
                "offener Mund",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλατύ\u{a0}χαμόγελο με κλειστά μάτια"),
            keywords: &[
                "ανοιχτό",
                "γέλιο",
                "ικανοποίηση",
                "πλατύ\u{a0}χαμόγελο με κλειστά μάτια",
                "πρόσωπο",
                "στόμα",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("grinning squinting face"),
            keywords: &[
                "face",
                "grinning squinting face",
                "laugh",
                "mouth",
                "satisfied",
                "smile",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con los ojos cerrados"),
            keywords: &[
                "abierta",
                "boca",
                "cara",
                "cara sonriendo con los ojos cerrados",
                "risa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("sonrisa con boca abierta y ojos cerrados"),
            keywords: &[
                "boca abierta",
                "cara",
                "sonrisa con boca abierta y ojos cerrados",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con los ojos cerrados"),
            keywords: &[
                "boca abierta",
                "cara",
                "cara sonriendo con los ojos cerrados",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con los ojos cerrados"),
            keywords: &[
                "boca abierta",
                "cara",
                "cara sonriendo con los ojos cerrados",
                "sonrisa con boca abierta y ojos cerrados",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud suu ja suletud silmadega naerunägu"),
            keywords: &[
                "avatud suu ja suletud silmadega naerunägu",
                "lahti",
                "naer",
                "naeratus",
                "nägu",
                "rahul",
                "suu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barreka ari den aurpegia, begiak itxita"),
            keywords: &[
                "aho",
                "asebeteta",
                "aurpegi",
                "barre",
                "barreka ari den aurpegia, begiak itxita",
                "ireki",
                "irribarre",
                "irribarre egiten ari den aurpegia, begiak itxita",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قاه\u{200c}قاه"),
            keywords: &["خوشحالی", "دهان", "صورت", "قاه\u{200c}قاه", "لبخند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hymy ja tiukasti suljetut silmät"),
            keywords: &[
                "auki",
                "hymy",
                "hymy ja tiukasti suljetut silmät",
                "naama",
                "nauru",
                "suu",
                "tyytyväinen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakatawa nang nakapikit"),
            keywords: &[
                "masaya",
                "mukha",
                "nakangiti",
                "nakapikit",
                "nakatawa",
                "nakatawa nang nakapikit",
                "ngiti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grínandi andlit við krympaðum eygum"),
            keywords: &[
                "andlit",
                "eygu",
                "grín",
                "grínandi andlit við krympaðum eygum",
                "krympa",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage souriant avec yeux plissés"),
            keywords: &[
                "bouche",
                "rire",
                "sourire",
                "visage",
                "visage souriant avec yeux plissés",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage avec large sourire, les yeux fermés"),
            keywords: &[
                "bouche ouverte",
                "rire",
                "satisfait",
                "sourire",
                "visage",
                "visage avec large sourire, les yeux fermés",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag gáire le súile dúnta"),
            keywords: &[
                "béal ar oscailt",
                "meangadh gáire",
                "straoiseog ag gáire le súile dúnta",
                "súile dúnta go dlúth",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann caog-shùileach le gàire"),
            keywords: &[
                "aodann",
                "aodann caog-shùileach le gàire",
                "aodann le gàire, beul fosgailte ⁊ sùilean dùinte",
                "beul",
                "fiamh-ghàire",
                "fosgailte",
                "gàire",
                "sàsaichte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara rindo ás gargalladas"),
            keywords: &[
                "cara rindo ás gargalladas",
                "gargalladas",
                "ollos pechados",
                "rir",
                "risa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} ચ\u{ac1}સ\u{acd}તપણ\u{ac7} બ\u{a82}ધ આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
            ),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} ચ\u{ac1}સ\u{acd}તપણ\u{ac7} બ\u{a82}ધ આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82}એ હાસ\u{acd}ય",
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} મોઢ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
                "બ\u{a82}ધ આ\u{a82}ખો",
                "બ\u{a82}ધ આ\u{a82}ખો સાથ\u{ac7}ન\u{ac1}\u{a82} હાસ\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da baki a buɗe & idanu a rufe"),
            keywords: &[
                "a buɗe",
                "baki",
                "dariya",
                "fuska",
                "fuska mai murmushi tare da baki a buɗe & idanu a rufe",
                "gamsu",
                "murmushi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחייך עם פה פתוח ועיניים עצומות בחוזקה"),
            keywords: &[
                "חיוך",
                "עיניים עצומות",
                "פרצוף מחייך",
                "פרצוף מחייך עם פה פתוח ועיניים עצומות בחוזקה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{902}द आ\u{901}खो\u{902} वाला दा\u{901}त दिखाता च\u{947}हरा"),
            keywords: &[
                "ख\u{941}ला म\u{941}\u{902}ह",
                "ख\u{941}ल\u{947} म\u{941}\u{902}ह वाली म\u{941}स\u{94d}कान",
                "च\u{947}हरा",
                "ब\u{902}द आ\u{901}खो\u{902} वाला दा\u{901}त दिखाता च\u{947}हरा",
                "ब\u{902}द आ\u{902}ख\u{947}\u{902}",
                "ब\u{902}द आ\u{902}खो\u{902} वाली म\u{941}स\u{94d}कान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmijano lice s čvrsto zatvorenim očima"),
            keywords: &[
                "lice",
                "nasmijano lice s čvrsto zatvorenim očima",
                "smijeh",
                "smiješak",
                "zadovoljno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyitott szájjal és lehunyt szemmel mosolygó arc"),
            keywords: &[
                "arc",
                "nevetés",
                "nyitott száj",
                "nyitott szájjal és lehunyt szemmel mosolygó arc",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժպտացող դեմք բաց բերանով և ամուր փակած աչքերով"),
            keywords: &[
                "բաց",
                "բերան",
                "գոհ",
                "դեմք",
                "ժպտալ",
                "ժպտացող դեմք բաց բերանով և ամուր փակած աչքերով",
                "ծիծաղել",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("grande surriso con oculos clause"),
            keywords: &[
                "facie",
                "grande surriso con oculos clause",
                "satisfacite",
                "satisfaction",
                "surridente",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersenyum lebar dan memejamkan mata"),
            keywords: &[
                "mulut",
                "puas",
                "senyum",
                "tertawa",
                "wajah",
                "wajah tersenyum lebar dan memejamkan mata",
                "wajah tersenyum lebar memejamkan mata",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu amụ nwere mmepe ọnụ & anya mechiri emechi"),
            keywords: &[
                "amụ",
                "ihu",
                "ihu amụ nwere mmepe ọnụ & anya mechiri emechi",
                "mmepe",
                "nwere afọ ojuju",
                "ọchị",
                "ọnụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brosandi andlit með pírð augu"),
            keywords: &[
                "andlit",
                "bros",
                "brosandi andlit með pírð augu",
                "brosandi andlit og pírð augu",
                "ánægja",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sorriso a bocca aperta con occhi chiusi"),
            keywords: &[
                "bocca aperta",
                "occhi chiusi",
                "sorriso",
                "sorriso a bocca aperta con occhi chiusi",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("きゃー"),
            keywords: &["きゃー", "スマイル", "嬉しい", "満足", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu nganti matane dhipet"),
            keywords: &[
                "cangkem",
                "guyu",
                "marem",
                "mesem",
                "rai",
                "rai ngguyu nganti matane dhipet",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე ღია პირითა და მაგრად დახუჭული თვალებით"),
            keywords: &[
                "კმაყოფილი",
                "მომღიმარე სახე ღია პირითა და მაგრად დახუჭული თვალებით",
                "პირი",
                "პირღია",
                "სახე",
                "სიცილი",
                "ღია",
                "ღიმილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem acmumaḥ akked yimi yeldin d wallen imedlen"),
            keywords: &["udem acmumaḥ akked yimi yeldin d wallen imedlen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аузын ашып, көзін жұмып күлу"),
            keywords: &[
                "аузын ашып, көзін жұмып күлу",
                "ауыз",
                "ашық",
                "бет",
                "жымию",
                "күлкі",
                "қанағаттану",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt med åben mund og lukkede øjne"),
            keywords: &[
                "glad",
                "lukkede øjne",
                "smil",
                "smil med lukkede øjne",
                "smilende ansigt med åben mund og lukkede øjne",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើចប\u{17b7}ទភ\u{17d2}នែក"),
            keywords: &[
                "ប\u{17b7}ទ",
                "ភ\u{17d2}នែក",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខសើចប\u{17b7}ទភ\u{17d2}នែក",
                "សើច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಂದಸ\u{ccd}ಮ\u{cbf}ತ ಅಣಕ\u{cbf}ಸುವ ಮುಖ"),
            keywords: &[
                "ತೃಪ\u{ccd}ತ\u{cbf}ಯ",
                "ನಗು",
                "ಬಾಯ\u{cbf}",
                "ಮಂದಸ\u{ccd}ಮ\u{cbf}ತ ಅಣಕ\u{cbf}ಸುವ ಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈웃음짓는 얼굴"),
            keywords: &[
                "눈 감고 미소",
                "눈 감고 웃는 얼굴",
                "눈웃음짓는 얼굴",
                "얼굴",
                "입 벌리고 미소",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हा\u{902}सपी तिरसो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "तो\u{902}ड",
                "समाधानी",
                "हा\u{902}सप",
                "हा\u{902}सपी तिरसो च\u{947}रो",
                "हा\u{902}सो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көздөрүн чылк жумуп күлгөн бет"),
            keywords: &[
                "бет",
                "жумуп",
                "күл",
                "көздөрүн чылк жумуп күлгөн бет",
                "чылк",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat oppenem Mond an zouen Aen"),
            keywords: &[
                "Gesiicht",
                "Laachen",
                "Mond",
                "laachend Gesiicht mat oppenem Mond an zouen Aen",
                "oppen",
                "zefridden",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມອ\u{ec9}າປາກ ແລະຫ\u{ebc}\u{eb1}ບຕາ"),
            keywords: &[
                "ຍ\u{eb4}ບຕາ",
                "ຍ\u{eb4}\u{ec9}ມ",
                "ພ\u{ecd}ໃຈ",
                "ຫ\u{ebb}ວ",
                "ອ\u{ec9}າປາກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມອ\u{ec9}າປາກ ແລະຫ\u{ebc}\u{eb1}ບຕາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis išsižiojęs veidas su smarkiai užmerktomis akimis"),
            keywords: &[
                "besišypsantis išsižiojęs veidas su smarkiai užmerktomis akimis",
                "burna",
                "juokas",
                "pasitenkinęs",
                "praverta",
                "veidas",
                "šypsena",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smaidoša seja ar atvērtu muti un aizmiegtām acīm"),
            keywords: &[
                "atvērts",
                "laimīgs",
                "mute",
                "seja",
                "smaidoša seja ar atvērtu muti un aizmiegtām acīm",
                "smaids",
                "smiekli",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene waha tuwhera me ngā karu kopi"),
            keywords: &[
                "kanohi",
                "kanohi menemene waha tuwhera me ngā karu kopi",
                "kata",
                "menemene",
                "ngata",
                "tuwhera",
                "waha",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со отворена уста и затворени очи"),
            keywords: &[
                "лице со отворена уста и затворени очи",
                "насмеано лице со отворена уста и затворени очи",
                "насмевка",
                "отворена",
                "очи",
                "уста",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഇറ\u{d41}ക\u{d4d}കിയടച\u{d4d}ച കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "ഇറ\u{d41}ക\u{d4d}കിയടച\u{d4d}ച കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "ചിരി",
                "പ\u{d3e}തിയടച\u{d4d}ച കണ\u{d4d}ണ\u{d41}കളോടെ ഇളിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "മ\u{d41}ഖം",
                "വ\u{d3e}യ",
                "സംത\u{d43}പ\u{d4d}\u{200c}തമ\u{d3e}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүдээ тас аниж маасайтал инээсэн царай"),
            keywords: &[
                "ам",
                "амаа ангайлган нүдээ тас аниад инээж байгаа царай",
                "ангайлгах",
                "инээх",
                "нүд",
                "нүдээ тас аниж маасайтал инээсэн царай",
                "тас аних",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोळ\u{947} ब\u{902}द कर\u{942}न हसणारा च\u{947}हरा"),
            keywords: &[
                "उघड\u{947}",
                "च\u{947}हरा",
                "डोळ\u{947} ब\u{902}द कर\u{942}न हसणारा च\u{947}हरा",
                "तो\u{902}ड",
                "समाधानी",
                "हसण\u{947}",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersengih mata tertutup rapat"),
            keywords: &[
                "ketawa",
                "muka",
                "muka tersengih mata tertutup rapat",
                "mulut",
                "puas hati",
                "senyum",
                "terbuka",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jidħaq b’ħalq miftuħ u għajnejn magħluqa"),
            keywords: &[
                "jidħq",
                "jitbissem",
                "miftuħ",
                "sodisfatti",
                "wiċċ",
                "wiċċ jidħaq b’ħalq miftuħ u għajnejn magħluqa",
                "ħalq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}စ\u{102d}က\u{102d}\u{102f} ကြ\u{102d}တ\u{103a}မ\u{103e}\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ကျေနပ\u{103a}ခြင\u{103a}း",
                "ကြ\u{102d}တ\u{103a}မ\u{103e}\u{102d}တ\u{103a}၍ ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032}လ\u{102f}ပ\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ပါးစပ\u{103a}",
                "မျက\u{103a}စ\u{102d}က\u{102d}\u{102f} ကြ\u{102d}တ\u{103a}မ\u{103e}\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "ရယ\u{103a}မောခြင\u{103a}း",
                "အပြ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smil med sammenknepne øyne"),
            keywords: &["fjes", "latter", "smil med sammenknepne øyne", "åpen munn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "ख\u{941}ला म\u{941}ख र आ\u{901}खा चिम\u{94d}म भएको ह\u{901}सिलो अन\u{941}हार",
            ),
            keywords: &[
                "अन\u{941}हार",
                "ख\u{941}ला",
                "ख\u{941}ला म\u{941}ख र आ\u{901}खा चिम\u{94d}म भएको ह\u{901}सिलो अन\u{941}हार",
                "म\u{941}ख",
                "म\u{941}स\u{94d}कान",
                "सन\u{94d}त\u{941}ष\u{94d}ट",
                "ह\u{901}साइ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grijnzend gezicht met stijf dichtgeknepen ogen"),
            keywords: &[
                "gezicht",
                "glimlach",
                "grijnzend gezicht met stijf dichtgeknepen ogen",
                "lach",
                "mond",
                "open",
                "tevreden",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smil med samanknipne auge"),
            keywords: &["fjes", "latter", "open munn", "smil med samanknipne auge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ହସ\u{b41}କ\u{b41}ର\u{b3e} ବକ\u{b4d}ର ଚ\u{b3e}ହ\u{b3e}ଣ\u{b3f} ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ପ\u{b3e}ଟ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}",
                "ସନ\u{b4d}ତ\u{b41}ଷ\u{b4d}ଟ",
                "ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
                "ହସ\u{b3f}ବ\u{b3e}",
                "ହସ\u{b41}କ\u{b41}ର\u{b3e} ବକ\u{b4d}ର ଚ\u{b3e}ହ\u{b3e}ଣ\u{b3f} ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਅਤ\u{a47} ਘ\u{a41}\u{a71}ਟ ਕ\u{a47} ਬ\u{a70}ਦ ਕੀਤੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
            ),
            keywords: &[
                "ਅ\u{a71}ਖਾ\u{a02} ਬ\u{a70}ਦ ਨਾਲ ਮ\u{a41}ਸਕਾਨ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਾ ਮ\u{a41}\u{a70}ਹ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਅਤ\u{a47} ਘ\u{a41}\u{a71}ਟ ਕ\u{a47} ਬ\u{a70}ਦ ਕੀਤੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਨਾਲ ਹਾਸਾ",
                "ਚਿਹਰਾ",
                "ਬ\u{a70}ਦ ਅ\u{a71}ਖਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ک\u{64f}ھلے منہ اتے بند کیتیاں اکھاں نال مسکراندی شکل"),
            keywords: &[
                "دی شکل",
                "مسکرانا",
                "مطمئن ہونا",
                "منہ",
                "ک\u{64f}ھلا",
                "ک\u{64f}ھلے منہ اتے بند کیتیاں اکھاں نال مسکراندی شکل",
                "ہسنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láfín Fes Wit Klóz Ai"),
            keywords: &[
                "Fes",
                "Hápi",
                "Hápí Laf",
                "Laf",
                "Láfín Fes Wit Klóz Ai",
                "Maut",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz z przymrużonymi oczami"),
            keywords: &[
                "satysfakcja",
                "uśmiech",
                "uśmiechnięta twarz z przymrużonymi oczami",
                "wesoły",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدلی نيمکښ مخ"),
            keywords: &["خله", "خندا", "قانع", "مخ", "مسکا", "مسکېدلی نيمکښ مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto risonho com olhos semicerrados"),
            keywords: &[
                "gargalhada",
                "olhos fechados",
                "rosto",
                "rosto risonho com olhos semicerrados",
                "sorriso com olhos fechados",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir com boca aberta e olhos bem fechados"),
            keywords: &[
                "aberta",
                "boca",
                "cara",
                "cara a sorrir com boca aberta e olhos bem fechados",
                "riso",
                "satisfação",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya wichqasqa ñawikunawan"),
            keywords: &[
                "asisqa",
                "asiy",
                "kusisqa uya wichqasqa ñawikunawan",
                "munasqa",
                "simi",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față încântată cu ochii întredeschiși"),
            keywords: &[
                "deschisă",
                "față",
                "față încântată cu ochii întredeschiși",
                "gură",
                "râset",
                "satisfacție",
                "zâmbet",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-842"),
            keywords: &["E10-842"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("смеется с прищуренными глазами"),
            keywords: &[
                "прищуренные глаза",
                "смеется с закрытыми глазами",
                "смеется с прищуренными глазами",
                "смех",
                "смех с прищуренными глазами",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka n’umunwa wasamye n’amaso ahumirije"),
            keywords: &[
                "gihagije",
                "gufungura",
                "guseka",
                "isura",
                "isura iseka n’umunwa wasamye n’amaso ahumirije",
                "kumwenyu",
                "umunwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏي کل وارو ڦريل انکين وارو چهرو"),
            keywords: &[
                "وڏي کل وارو ڦريل انکين وارو چهرو",
                "وڏي کل وارو ڦريل اکين وارو چهرو",
                "چهرو، کل، منهن، کليل، مطمئن، مسڪراهٽ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "කට ඇර\u{dd4}ණ ඇස\u{dca} තද\u{dd2}න\u{dca} වස\u{dcf} ගත\u{dca} ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
            ),
            keywords: &[
                "කට",
                "කට ඇර\u{dd4}ණ ඇස\u{dca} තද\u{dd2}න\u{dca} වස\u{dcf} ගත\u{dca} ස\u{dd2}නහ",
                "කට ඇර\u{dd4}ණ ඇස\u{dca} තද\u{dd2}න\u{dca} වස\u{dcf} ගත\u{dca} ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
                "තෘප\u{dca}ත\u{dd2}මත\u{dca}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}වෘත",
                "ස\u{dd2}නහව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škeriaca sa tvár s\u{a0}privretými očami"),
            keywords: &[
                "otvorené",
                "smiech",
                "spokojné",
                "tvár",
                "úsmev",
                "ústa",
                "škeriaca sa tvár s\u{a0}privretými očami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz z odprtimi usti in trdno zaprtimi očmi"),
            keywords: &[
                "nasmeh",
                "obraz",
                "odprto",
                "smejoči obraz z odprtimi usti in trdno zaprtimi očmi",
                "usta",
                "zadovoljno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dareenka wajiga ee qoslaya"),
            keywords: &[
                "afka",
                "dareenka wajiga ee qoslaya",
                "dhoola cadeyn",
                "ku qanacsan yihiin",
                "qosol",
                "waji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e qeshur me sy të mbyllur fort"),
            keywords: &[
                "e kënaqur",
                "fytyrë e qeshur me gojën e hapur dhe sy të mbyllur fort",
                "fytyrë e qeshur me sy të mbyllur fort",
                "gojë",
                "qesh",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са злочестим осмехом"),
            keywords: &[
                "задовољно",
                "лице",
                "лице са злочестим осмехом",
                "осмех",
                "смех",
                "уста",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице са злочестим осмијехом"),
            keywords: &["лице са злочестим осмијехом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa zločestim osmehom"),
            keywords: &[
                "lice",
                "lice sa zločestim osmehom",
                "osmeh",
                "smeh",
                "usta",
                "zadovoljno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice sa zločestim osmijehom"),
            keywords: &["lice sa zločestim osmijehom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flinande ansikte med kisande ögon"),
            keywords: &[
                "ansikte",
                "flinande ansikte med kisande ögon",
                "leende med stängda ögon",
                "stängda ögon",
                "öppen mun",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu wenye mdomo wazi na macho yaliyofungwa"),
            keywords: &[
                "cheka",
                "mdomo",
                "ridhika",
                "tabasamu",
                "uso",
                "uso unaotabasamu wenye mdomo wazi na macho yaliyofungwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "வ\u{bbe}ய\u{bcd} நிறைய சிரிப\u{bcd}புடன\u{bcd} கண\u{bcd}களை இறுக\u{bcd}கம\u{bbe}க மூடிக\u{bcd}கொண\u{bcd}ட முகம\u{bcd}",
            ),
            keywords: &[
                "கண\u{bcd}மண\u{bcd} தெரிய\u{bbe}மல\u{bcd} சிரித\u{bcd}தல\u{bcd}",
                "சிரிப\u{bcd}பு",
                "திருப\u{bcd}தி",
                "முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd}",
                "வ\u{bbe}ய\u{bcd} நிறைய சிரிப\u{bcd}புடன\u{bcd} கண\u{bcd}களை இறுக\u{bcd}கம\u{bbe}க மூடிக\u{bcd}கொண\u{bcd}ட முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "కళ\u{c4d}లు మూస\u{c3f} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "కళ\u{c4d}లు",
                "కళ\u{c4d}లు మూస\u{c3f} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "నవ\u{c4d}వు",
                "న\u{c4b}రు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо даҳони кушода ва чашмони пӯшида"),
            keywords: &[
                "даҳон",
                "кушода",
                "рӯи хандон бо даҳони кушода ва чашмони пӯшида",
                "рӯй",
                "табассум",
                "ханда",
                "қонеъ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e34}\u{e49}มตาหย\u{e35}"),
            keywords: &[
                "ตาหย\u{e35}",
                "ย\u{e34}\u{e49}ม",
                "ย\u{e34}\u{e49}มตาหย\u{e35}",
                "หน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gytak gözli syrtarýan ýüz"),
            keywords: &[
                "agyz",
                "açyk",
                "gytak gözli syrtarýan ýüz",
                "gözüniň gytagy bilen seredýän syrtarýan ýüz",
                "gülki",
                "kanagatlanan",
                "ýylgyrmak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fiefia moe tetepa"),
            keywords: &["mata fiefia moe tetepa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kapalı gözlerle ağzı açık sırıtma"),
            keywords: &[
                "ağız açık",
                "gözler kapalı",
                "kapalı gözlerle ağzı açık sırıtma",
                "kapalı gözlerle gülümseme",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆزىنى يۇمۇپ ئاغزىنى ئېچىپ كۈلۈمسىرەش"),
            keywords: &[
                "ئوچۇق",
                "ئېغىز",
                "رازى",
                "كۆزىنى يۇمۇپ ئاغزىنى ئېچىپ كۈلۈمسىرەش",
                "كۈلۈش",
                "كۈلۈمسىرەش",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("широко всміхнене замружене обличчя"),
            keywords: &[
                "відкритий",
                "задоволений",
                "обличчя",
                "посмішка",
                "рот",
                "сміх",
                "усміхнене обличчя з відкритим ротом і міцно заплющеними очима",
                "широко всміхнене замружене обличчя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلے منہ اور سختی سے بند آنکھوں والا مسکراتا چہرہ"),
            keywords: &[
                "مسکراہٹ",
                "مطمئن",
                "منہ",
                "چہرہ",
                "کھلے منہ اور سختی سے بند آنکھوں والا مسکراتا چہرہ",
                "ہنسی",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zini katta ochib kulayotgan yuz va qattiq yumilgan ko‘zlar"),
            keywords: &[
                "kulgu",
                "mamnun",
                "ochiq",
                "og‘iz",
                "og‘zini katta ochib kulayotgan yuz va qattiq yumilgan ko‘zlar",
                "tabassum",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười miệng há mắt nhắm chặt"),
            keywords: &[
                "cười",
                "cười to",
                "hài lòng",
                "miệng",
                "mặt",
                "mặt cười miệng há mắt nhắm chặt",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy muuñ ak ubbeeku gémmiñ ak buñ tëj bët"),
            keywords: &[
                "gémmiñ",
                "kanam",
                "kanam guy muuñ ak ubbeeku gémmiñ ak buñ tëj bët",
                "muuñ",
                "reetaan",
                "satisfied",
                "ubbeeku",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obunomlomo ovulekileyo namehlo avalekileyo"),
            keywords: &[
                "eyanelisekileyo",
                "hleka",
                "ubuso",
                "ubuso obuncumileyo obunomlomo ovulekileyo namehlo avalekileyo",
                "umlomo",
                "uncumo",
                "vulekileyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some(
                "ojú tó ń rẹ\u{301}rìń músẹ\u{301} pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti òógùn tútù",
            ),
            keywords: &[
                "ojú",
                "ojú tó ń rẹ\u{301}rìń músẹ\u{301} pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti òógùn tútù",
                "rẹ\u{301}rìń músẹ\u{301}",
                "ìtẹ\u{301}larùn",
                "ẹnu",
                "ẹ\u{300}rín",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("瞇著笑嘅臉"),
            keywords: &["嘴", "微笑", "打開", "滿意", "瞇著笑嘅臉", "笑", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("眯着笑嘅脸"),
            keywords: &["嘴", "微笑", "打开", "满意", "眯着笑嘅脸", "笑", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("斜眼笑"),
            keywords: &["开心", "斜眼笑", "眯眼", "笑", "脸", "高兴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("狂笑"),
            keywords: &["呵呵", "哈哈", "狂笑", "笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["呵呵", "哈哈", "狂笑", "笑樣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizelayo buvule umlomo buvale amehlo"),
            keywords: &[
                "aneliseka",
                "moyizela",
                "ubuso",
                "ubuso obumoyizelayo buvule umlomo buvale amehlo",
                "ukuhleka",
                "umlomo",
                "vula",
            ],
        },
    ],
};
#[doc = "😅"]
pub const GRINNING_FACE_WITH_SWEAT: crate::Emoji = crate::Emoji {
    glyph: "😅",
    codepoint: "1F605",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "grinning face with sweat",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lag gesig met sweet"),
            keywords: &[
                "gesig",
                "glimlag",
                "glimlaggende gesig met oop mond en koue sweet",
                "koud",
                "lag gesig met sweet",
                "oop",
                "sweet",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከተከፈተ አፍ ጋር ሣቂታ ፊት እና ቀዝቃዛ ላብ"),
            keywords: &["ላብ", "ሣቅ", "ቀዝቃዛ", "ከተከፈተ አፍ ጋር ሣቂታ ፊት እና ቀዝቃዛ ላብ", "ክፍት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مبتسم بفم مفتوح وعرق بارد"),
            keywords: &[
                "ابتسامة ولكن بعرق بارد",
                "عرق بارد",
                "وجه مبتسم بفم مفتوح وعرق بارد",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘম\u{9be}ৰ\u{9cd}ত ম\u{9c1}খেৰে হ\u{9be}স\u{9cd}য ম\u{9c1}খ"),
            keywords: &[
                "খোল\u{9be}",
                "ঘম\u{9be}ৰ\u{9cd}ত",
                "ঘম\u{9be}ৰ\u{9cd}ত ম\u{9c1}খেৰে হ\u{9be}স\u{9cd}য ম\u{9c1}খ",
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq ağız və soyuq tərlə gülən üz"),
            keywords: &[
                "açıq",
                "açıq ağız və soyuq tərlə gülən üz",
                "soyuq",
                "təbəssüm",
                "tər",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("усміхаецца адкрытым ротам з халодным потам на лбе"),
            keywords: &[
                "пот",
                "усмешка",
                "усміхаецца адкрытым ротам з халодным потам на лбе",
                "халодны",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Широко усмихнато лице с пот на челото"),
            keywords: &[
                "Широко усмихнато лице с пот на челото",
                "лице",
                "отворен",
                "пот",
                "усмивка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ম\u{9c1}খ খোল\u{9be} এবং ঠ\u{9be}ণ\u{9cd}ড\u{9be} ঘ\u{9be}মের স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি",
            ),
            keywords: &[
                "খোল\u{9be}",
                "ঘর\u{9cd}ম\u{9be}ক\u{9cd}ত অবস\u{9cd}থ\u{9be}",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}",
                "ম\u{9c1}খ",
                "ম\u{9c1}খ খোল\u{9be} এবং ঠ\u{9be}ণ\u{9cd}ড\u{9be} ঘ\u{9be}মের স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kez uz hladan znoj"),
            keywords: &["hladan znoj", "kez uz hladan znoj", "lice", "osmijeh"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara somrient amb una gota de suor"),
            keywords: &[
                "cara",
                "cara somrient amb una gota de suor",
                "somriure",
                "suor freda",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏤᏣᏍᏗ ᎤᎧᏛ ᎠᎵ"),
            keywords: &["ᎠᎵ", "ᎠᏍᏚᎢᏓ", "ᎤᎧᏛ", "ᎤᏤᏣᏍᏗ", "ᎤᏴᏝ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zubící se obličej s kapkou potu"),
            keywords: &[
                "otevřený",
                "pot",
                "smajlík",
                "studený",
                "tvář",
                "výraz",
                "zubící se obličej s kapkou potu",
                "úsměv",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â cheg agored a chwys"),
            keywords: &[
                "chwys",
                "gofid",
                "gwenu",
                "wyneb",
                "wyneb yn gwenu â cheg agored a chwys",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grinende ansigt med sveddråbe"),
            keywords: &[
                "grine",
                "grinende ansigt med sveddråbe",
                "sved",
                "åben mund",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grinsendes Gesicht mit Schweißtropfen"),
            keywords: &[
                "Gesicht",
                "Schweiß",
                "grinsendes Gesicht mit Schweißtropfen",
                "lustig",
                "schwitzen",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Lachender Smiley mit kaltem Schweiss"),
            keywords: &[
                "Gesicht",
                "Lachender Smiley mit kaltem Schweiss",
                "Schweiss",
                "lustig",
                "schwitzen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πλατύ\u{a0}χαμόγελο και κρύος ιδρώτας"),
            keywords: &[
                "ανοιχτό",
                "ιδρώτας",
                "κρύος",
                "πλατύ\u{a0}χαμόγελο και κρύος ιδρώτας",
                "πρόσωπο",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("grinning face with sweat"),
            keywords: &[
                "cold",
                "face",
                "grinning face with sweat",
                "open",
                "smile",
                "sweat",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con sudor frío"),
            keywords: &[
                "cara",
                "cara sonriendo con sudor frío",
                "frío",
                "risa",
                "sudor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("sonrisa y sudor frío"),
            keywords: &[
                "boca abierta",
                "cara",
                "sonrisa",
                "sonrisa boca abierta",
                "sonrisa y sudor frío",
                "sudor frío",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con sudor frío"),
            keywords: &[
                "boca abierta",
                "cara sonriendo con sudor frío",
                "sonrisa",
                "sonrisa boca abierta",
                "sudor frío",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con sudor frío"),
            keywords: &[
                "boca abierta",
                "cara",
                "cara sonriendo con sudor frío",
                "sonrisa",
                "sonrisa boca abierta",
                "sonrisa y sudor frío",
                "sudor frío",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("külma higiga kaetud ja avatud suuga naerunägu"),
            keywords: &[
                "avatud",
                "higi",
                "külm",
                "külma higiga kaetud ja avatud suuga naerunägu",
                "naeratus",
                "nägu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barreka ari den aurpegia, izerdi hotzarekin"),
            keywords: &[
                "aurpegi",
                "barreka ari den aurpegia, izerdi hotzarekin",
                "hotz",
                "ireki",
                "irribarre",
                "irribarre egiten ari den aurpegia, izerdi hotzarekin eta ahora irekita",
                "izerdi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خنده و عرق خوشحالی"),
            keywords: &["باز", "خنده و عرق خوشحالی", "صورت", "عرق", "لبخند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hymy ja kylmänhiki"),
            keywords: &[
                "auki",
                "hiki",
                "hymy",
                "hymy ja kylmänhiki",
                "kylmä",
                "naama",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangising mukha na may pawis"),
            keywords: &[
                "malamig",
                "mukha",
                "nakangising mukha na may pawis",
                "nakangiti",
                "nakatawa",
                "ngiti",
                "pawis",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grínandi andlit við sveitta"),
            keywords: &[
                "andlit",
                "bros",
                "grín",
                "grínandi andlit við sveitta",
                "smíl",
                "sveitti",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage souriant avec une goutte de sueur"),
            keywords: &["sourire", "visage souriant avec une goutte de sueur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("un visage en sueur avec large sourire"),
            keywords: &[
                "froide",
                "sourire",
                "sueur",
                "un visage en sueur avec large sourire",
                "visage",
                "visage en sueur avec large sourire",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag gáire le fuarallas"),
            keywords: &[
                "béal ar oscailt",
                "fuarallas",
                "meangadh gáire",
                "straoiseog ag gáire le fuarallas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire a’ cur fallas"),
            keywords: &[
                "aodann",
                "aodann le gàire a’ cur fallas",
                "fallas",
                "fiamh-ghàire",
                "fosgailte",
                "fuar",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara moi riseira cunha pinga de suor"),
            keywords: &[
                "boca",
                "cara",
                "cara moi riseira cunha pinga de suor",
                "sorriso",
                "suor",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
            ),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લો",
                "ચહ\u{ac7}રો",
                "ઠ\u{a82}ડો",
                "પરસ\u{ac7}વો",
                "પરસ\u{ac7}વો સાથ\u{ac7} સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "સ\u{acd}મિત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da baki a buɗe & gumi mai sanyi"),
            keywords: &[
                "a buɗe",
                "fuska",
                "fuska mai murmushi tare da baki a buɗe & gumi mai sanyi",
                "gumi",
                "murmushi",
                "sanyi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחייך עם טיפת זיעה"),
            keywords: &[
                "זיעה",
                "מחייך",
                "פרצוף מחייך",
                "פרצוף מחייך עם טיפת זיעה",
                "פרצוף מחייך עם פה פתוח וטיפת זיעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दा\u{901}त दिखाता पसीन\u{947} वाला च\u{947}हरा"),
            keywords: &[
                "ठ\u{902}डा पसीना",
                "ठ\u{902}ड\u{947} पसीन\u{947} वाली म\u{941}स\u{94d}कान",
                "दा\u{901}त दिखाता पसीन\u{947} वाला च\u{947}हरा",
                "म\u{941}स\u{94d}कान ल\u{947}किन ठ\u{902}डा पसीना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmijano lice s kapljicom znoja"),
            keywords: &[
                "hladno",
                "lice",
                "nasmijano lice s kapljicom znoja",
                "smiješak",
                "znoj",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nevető arc verejtékkel"),
            keywords: &[
                "arc",
                "hideg verejték",
                "mosoly",
                "nevető arc verejtékkel",
                "nyitott száj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժպտացող դեմք բաց բերանով և սառը քրտինքով"),
            keywords: &[
                "բաց",
                "դեմք",
                "ժպտալ",
                "ժպտացող դեմք բաց բերանով և սառը քրտինքով",
                "քրտինք",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("grande surriso con gutta de sudor"),
            keywords: &[
                "aperte",
                "facie",
                "frigide",
                "grande surriso con gutta de sudor",
                "sudor",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersenyum lebar dan berkeringat"),
            keywords: &[
                "dingin",
                "keringat",
                "muka",
                "senyum",
                "terbuka",
                "wajah",
                "wajah tersenyum lebar dan berkeringat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu amụ nwere mmepe ọnụ & okpofufu oyi"),
            keywords: &[
                "amụ",
                "ihu",
                "ihu amụ nwere mmepe ọnụ & okpofufu oyi",
                "mmepe",
                "okpofufu",
                "oyi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bros og kaldur sviti"),
            keywords: &[
                "andlit",
                "bros",
                "bros og kaldur sviti",
                "brosandi sveitt andlit",
                "sviti",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con un gran sorriso e goccia di sudore"),
            keywords: &[
                "faccina con un gran sorriso e goccia di sudore",
                "goccia",
                "sorriso teso",
                "sudore",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("冷や汗笑顔"),
            keywords: &["スマイル", "冷や汗", "冷や汗笑顔", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu nganti kringet tumetes"),
            keywords: &[
                "adhem",
                "kringet",
                "menga",
                "mesem",
                "rai",
                "rai ngguyu nganti kringet tumetes",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე ღია პირითა და ცივი ოფლით"),
            keywords: &[
                "მომღიმარე სახე ღია პირითა და ცივი ოფლით",
                "ოფლი",
                "ოფლიანი",
                "პირღია",
                "სახე",
                "ღია",
                "ღიმილი",
                "ცივი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeh n reffu"),
            keywords: &["acmumeh n reffu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сасқалақтап күлу"),
            keywords: &["жымию", "күлу", "сасқалақтап", "тер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt med åben mund og koldsved"),
            keywords: &[
                "smil med koldsved",
                "smilende ansigt med åben mund og koldsved",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើចចេញញើសព\u{17b8}ថ\u{17d2}ងាស"),
            keywords: &[
                "ញើស",
                "ដ\u{17c6}ណក\u{17cb}ទ\u{17b9}ក",
                "បើកម\u{17bb}ខ",
                "ភ\u{17d2}នែក",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខសើចចេញញើសព\u{17b8}ថ\u{17d2}ងាស",
                "សើច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ವರ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮಂದಸ\u{ccd}ಮ\u{cbf}ತ ಮುಖ"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}ದ",
                "ನಗು",
                "ಬ\u{cc6}ವರ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಮಂದಸ\u{ccd}ಮ\u{cbf}ತ ಮುಖ",
                "ಬ\u{cc6}ವರು",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("땀 흘리며 웃는 얼굴"),
            keywords: &[
                "땀 흘리며 웃는 얼굴",
                "미소",
                "스마일",
                "식은땀",
                "얼굴",
                "웃고 있지만 당황한 얼굴",
                "웃는 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घाम गळपी हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "उकत\u{947}\u{902}",
                "घाम",
                "घाम गळपी हा\u{902}सपी च\u{947}रो",
                "च\u{947}रो",
                "थ\u{902}ड",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тердегенче күлгөн бет"),
            keywords: &["бет", "күл", "терде", "тердегенче күлгөн бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat oppenem Mond a kalem Schweess"),
            keywords: &[
                "Gesiicht",
                "Laachen",
                "Schweess",
                "kal",
                "laachend Gesiicht mat oppenem Mond a kalem Schweess",
                "oppen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມອ\u{ec9}າປາກ ແລະເຫ\u{eb7}\u{ec8}ອຕ\u{ebb}ກ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ເຫ\u{eb7}\u{ec8}ອອອກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມອ\u{ec9}າປາກ ແລະເຫ\u{eb7}\u{ec8}ອຕ\u{ebb}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis išsižiojęs veidas, išpiltas šalto prakaito"),
            keywords: &[
                "besišypsantis išsižiojęs veidas, išpiltas šalto prakaito",
                "prakaitas",
                "praverta",
                "veidas",
                "šaltas",
                "šypsena",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plats smaids ar sviedru lāsi"),
            keywords: &[
                "atvērts",
                "auksts",
                "plats smaids ar sviedru lāsi",
                "seja",
                "smaids",
                "sviedri",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene waha tuwhera me te werawera mātao"),
            keywords: &[
                "kanohi",
                "kanohi menemene waha tuwhera me te werawera mātao",
                "menemene",
                "mātao",
                "tuwhera",
                "werawera",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("насмеано лице со отворена уста и пот"),
            keywords: &[
                "лице",
                "насмеано лице со отворена уста и капка пот",
                "насмеано лице со отворена уста и пот",
                "насмевка",
                "отворена",
                "пот",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വിയർപ\u{d4d}പ\u{d41}ള\u{d4d}ള കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "തണ\u{d41}ത\u{d4d}ത",
                "ത\u{d41}റന\u{d4d}ന",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "മ\u{d41}ഖം",
                "വിയർപ\u{d4d}പ\u{d41}ള\u{d4d}ള കളിയ\u{d3e}ക\u{d4d}കി ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "വിയർപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөлсөө гартал маасайтал инээсэн царай"),
            keywords: &[
                "амаа ангайн",
                "амаа ангайн, бага зэргийн ичиж инээсэн царай",
                "бага зэргийн ичиж инээж байгаа царай",
                "хөлсөө гартал маасайтал инээсэн царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थ\u{902}ड घामासह हास\u{94d}य असल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "उघड\u{947}",
                "च\u{947}हरा",
                "थ\u{902}ड",
                "थ\u{902}ड घाम",
                "थ\u{902}ड घामासह हास\u{94d}य असल\u{947}ला च\u{947}हरा",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersengih dan berpeluh"),
            keywords: &[
                "muka",
                "muka tersengih dan berpeluh",
                "peluh",
                "sejuk",
                "senyum",
                "terbuka",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jidħaq b’ħalq miftuħ u għaraq kiesaħ"),
            keywords: &[
                "għaraq",
                "jitbissem",
                "kiesaħ",
                "miftuħ",
                "wiċċ",
                "wiċċ jidħaq b’ħalq miftuħ u għaraq kiesaħ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဇောချ\u{103d}ေးပြန\u{103a}နေသည\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ဇောချ\u{103d}ေး",
                "ဇောချ\u{103d}ေးပြန\u{103a}နေသည\u{1037}\u{103a} ပြ\u{102f}\u{1036}းဖြ\u{1032}ဖြ\u{1032} မျက\u{103a}န\u{103e}ာ",
                "ဇောချ\u{103d}ေးပြန\u{103a}နေသည\u{1037}\u{103a} အပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "ဟနေသည\u{103a}",
                "အပြ\u{102f}\u{1036}း",
                "အေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glisende fjes som svetter"),
            keywords: &[
                "glisende fjes som svetter",
                "kaldsvette",
                "munn",
                "smil med svette",
                "svett smil med åpen munn",
                "åpen",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला म\u{941}ख र असिनपसिन भएको ह\u{901}सिलो अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ख\u{941}ला",
                "ख\u{941}ला म\u{941}ख र असिनपसिन भएको ह\u{901}सिलो अन\u{941}हार",
                "चिसो",
                "पसिना",
                "हा\u{901}सो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("grijnzend gezicht met zweetdruppels"),
            keywords: &[
                "gezicht",
                "grijnzend gezicht met zweetdruppels",
                "koud",
                "lach",
                "open",
                "zweet",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glisande fjes som sveittar"),
            keywords: &[
                "glisande fjes som sveittar",
                "kaldsveitte",
                "munn",
                "open",
                "smil med sveitte",
                "sveitt smil med open munn",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଝ\u{b3e}ଳ ଲ\u{b3e}ଗ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହସକ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଖୋଲ\u{b3e}",
                "ଝ\u{b3e}ଳ",
                "ଝ\u{b3e}ଳ ଲ\u{b3e}ଗ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହସକ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ମ\u{b41}ହ\u{b01}",
                "ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਅਤ\u{a47}\u{a47} ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
            ),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a41}\u{a70}ਹ ਅਤ\u{a47}\u{a47} ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਠ\u{a70}ਡਾ ਮ\u{a41}ੜ\u{a4d}ਹਕਾ",
                "ਠ\u{a70}ਡਾ ਮ\u{a41}ੜ\u{a4d}ਹਕਾ ਮ\u{a41}ਸਕਾਨ",
                "ਮ\u{a41}ਸਕਾਨ ਪਰ ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਨਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ک\u{64f}ھلے منہ اتے مڑکے نال مسکراندی شکل"),
            keywords: &[
                "دی شکل",
                "مسکرانا",
                "م\u{64f}ڑکا",
                "ٹھنڈا",
                "ک\u{64f}ھلا",
                "ک\u{64f}ھلے منہ اتے مڑکے نال مسکراندی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Láfín Fes With Smọ\u{301}l Swẹt"),
            keywords: &[
                "Fes",
                "Hápí Laf",
                "Kold",
                "Láfín Fes With Smọ\u{301}l Swẹt",
                "Láfín Fés Wit Swet",
                "Swet",
                "Ópun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz z otwartymi ustami, oblana zimnym potem"),
            keywords: &[
                "kropla potu",
                "uśmiech",
                "uśmiechnięta twarz z otwartymi ustami, oblana zimnym potem",
                "wesoły",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدلی مخ د خولو سره"),
            keywords: &[
                "برسېره",
                "خوله",
                "مخ",
                "مسکا",
                "مسکېدلی مخ د خولو سره",
                "يخ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto risonho com gota de suor"),
            keywords: &[
                "rosto",
                "rosto risonho com gota de suor",
                "sorriso com suor frio",
                "suor frio",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir com boca aberta e suor"),
            keywords: &[
                "aberta",
                "cara",
                "cara a sorrir com boca aberta e suor",
                "frio",
                "sorriso",
                "suor",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya sutʼuwan"),
            keywords: &[
                "asiy",
                "chiri",
                "kichay",
                "kusisqa uya sutʼuwan",
                "sutʼu",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față încântată cu sudoare rece"),
            keywords: &[
                "față",
                "față încântată cu sudoare rece",
                "rece",
                "sudoare",
                "zâmbet",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-841"),
            keywords: &["E10-841"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нервно смеется"),
            keywords: &[
                "нервно смеется",
                "нервный смех",
                "облегчение",
                "пот",
                "холодный пот",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka n’umunwa wasamye n’ibyuya by’ubwoba"),
            keywords: &[
                "gikonje",
                "gufungura",
                "guseka",
                "isura",
                "isura iseka n’umunwa wasamye n’ibyuya by’ubwoba",
                "kubira icyuya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پگهر سان وڏي کل وارو چهرو"),
            keywords: &["پگهر سان وڏي کل وارو چهرو", "ٿڌ، چهرو، کليل، کل، پگهر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට ඇර\u{dd4}ණ දහඩ\u{dd2}ය දමන ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කට ඇර\u{dd4}ණ දහඩ\u{dd2}ය දමන ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
                "දහඩ\u{dd2}ය",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}වෘත",
                "ස\u{dd2}නහව",
                "ස\u{dd3}තල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škeriaca sa tvár s\u{a0}potom"),
            keywords: &[
                "horúco",
                "otvorené",
                "pot",
                "tvár",
                "úsmev",
                "škeriaca sa tvár s\u{a0}potom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz z odprtimi usti in mrzlim potom"),
            keywords: &[
                "mrzlo",
                "nasmeh",
                "obraz",
                "odprto",
                "pot",
                "smejoči obraz z odprtimi usti in mrzlim potom",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji gariiraya oo dhididsan"),
            keywords: &[
                "dhidid",
                "dhoolo cadeyn",
                "fur",
                "qabow",
                "waji",
                "waji gariiraya oo dhidid leh",
                "waji gariiraya oo dhididsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e qeshur me djersë të ftohta"),
            keywords: &[
                "djersë",
                "e ftohtë",
                "e hapur",
                "fytyrë e qeshur me djersë të ftohta",
                "fytyrë e qeshur me gojën e hapur dhe djersë të ftohta",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са нервозним осмехом"),
            keywords: &[
                "зној",
                "лице",
                "лице са нервозним осмехом",
                "осмех",
                "отворено",
                "хладно",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице са нервозним осмијехом"),
            keywords: &["лице са нервозним осмијехом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa nervoznim osmehom"),
            keywords: &[
                "hladno",
                "lice",
                "lice sa nervoznim osmehom",
                "osmeh",
                "otvoreno",
                "znoj",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice sa nervoznim osmijehom"),
            keywords: &["lice sa nervoznim osmijehom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flinande ansikte med svettdroppe"),
            keywords: &["flinande ansikte med svettdroppe", "leende men svettas"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu wenye tone la jasho"),
            keywords: &[
                "baridi",
                "funguliwa",
                "jasho",
                "tabasamu",
                "uso",
                "uso unaotabasamu wenye tone la jasho",
                "uso unaotabasamu wenye tone la jasho na mdomo uliofunguliwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "வ\u{bbe}ய\u{bcd} நிறைய சிரிப\u{bcd}புடன\u{bcd}, வியர\u{bcd}வை சொட\u{bcd}டும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "குளிர\u{bcd}",
                "சிரிப\u{bcd}பு",
                "வ\u{bbe}ய\u{bcd} நிறைய சிரிப\u{bcd}புடன\u{bcd}, வியர\u{bcd}வை சொட\u{bcd}டும\u{bcd} முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd} நிறையச\u{bcd} சிரித\u{bcd}தல\u{bcd}",
                "வியர\u{bcd}வை",
                "வியர\u{bcd}வை வரச\u{bcd} சிரித\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "చ\u{c46}మటత\u{c4b} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "చ\u{c46}మట",
                "చ\u{c46}మటత\u{c4b} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "నవ\u{c4d}వు",
                "న\u{c4b}రు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо даҳони кушода ва арақи хунук"),
            keywords: &[
                "арақ",
                "кушода",
                "рӯи хандон бо даҳони кушода ва арақи хунук",
                "рӯй",
                "табассум",
                "хунук",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e34}\u{e49}มเหง\u{e37}\u{e48}อตก"),
            keywords: &[
                "ย\u{e34}\u{e49}ม",
                "ย\u{e34}\u{e49}มเหง\u{e37}\u{e48}อตก",
                "หน\u{e49}า",
                "เหง\u{e37}\u{e48}อออก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("syrtarýan derli ýüz"),
            keywords: &[
                "açyk",
                "der",
                "sowuk",
                "syrtarýan derli ýüz",
                "ýylgyrmak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fiefia moe tautaʻa"),
            keywords: &["mata fiefia moe tautaʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("soğuk terli ağzı açık gülümseme"),
            keywords: &["soğuk ter", "soğuk terli ağzı açık gülümseme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزىنى ئېچىپ سوغۇق تەرلەپ كۈلۈمسىرەش"),
            keywords: &[
                "ئاغزىنى ئېچىپ سوغۇق تەرلەپ كۈلۈمسىرەش",
                "ئوچۇق",
                "تەر",
                "سوغۇق",
                "كۈلۈمسىرەش",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("широко всміхнене обличчя з потом"),
            keywords: &[
                "відкритий",
                "обличчя",
                "посмішка",
                "піт",
                "усміхнене обличчя з відкритим ротом і холодним потом",
                "холодний",
                "широко всміхнене обличчя з потом",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلے منہ اور ٹھنڈے پسینے والا مسکراتا چہرہ"),
            keywords: &[
                "مسکراہٹ",
                "ٹھنڈ",
                "پسینہ",
                "چہرہ",
                "کھلے منہ اور ٹھنڈے پسینے والا مسکراتا چہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zini katta ochib kulayotgan yuz va sovuq ter"),
            keywords: &[
                "ochiq",
                "og‘zini katta ochib kulayotgan yuz va sovuq ter",
                "sovuq",
                "tabassum",
                "ter",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười miệng há mồ hôi"),
            keywords: &[
                "cười",
                "lạnh",
                "mặt",
                "mặt cười miệng há mồ hôi",
                "mồ hôi",
                "mở",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy muuñ ak ubbeeku gémmiñ ak ñàqu tiitaange"),
            keywords: &[
                "kanam",
                "kanam guy muuñ ak ubbeeku gémmiñ ak ñàqu tiitaange",
                "muuñ",
                "sedd",
                "ubbeeku",
                "ñàq",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obunomlomo ovulekileyo nombilo obandayo"),
            keywords: &[
                "ebandayo",
                "ubuso",
                "ubuso obuncumileyo obunomlomo ovulekileyo nombilo obandayo",
                "umbilo",
                "uncumo",
                "vulekileyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú tó ń rẹ\u{301}rìń pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti òógùn"),
            keywords: &[
                "ojú",
                "ojú tó ń rẹ\u{301}rìń pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti òógùn",
                "rẹ\u{301}rìń músẹ\u{301}",
                "òtútù",
                "òógùn",
                "ṣí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("出汗嘅笑臉"),
            keywords: &["凍", "出汗嘅笑臉", "微笑", "打開", "汗", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("出汗嘅笑脸"),
            keywords: &["冻", "出汗嘅笑脸", "微笑", "打开", "汗", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("苦笑"),
            keywords: &["冷汗", "汗", "脸", "苦笑"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("汗"),
            keywords: &["汗", "苦笑"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冒汗同笑嘻嘻嘅表情"),
            keywords: &["冒汗同笑嘻嘻嘅表情", "哈哈", "笑臉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizelayo obuvule umlomo nomjuluko obandayo"),
            keywords: &[
                "banda",
                "moyizela",
                "ubuso",
                "ubuso obumoyizelayo obuvule umlomo nomjuluko obandayo",
                "umjuluko",
                "vula",
            ],
        },
    ],
};
#[doc = "🤣"]
pub const ROLLING_ON_THE_FLOOR_LAUGHING: crate::Emoji = crate::Emoji {
    glyph: "🤣",
    codepoint: "1F923",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "rolling on the floor laughing",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat hard lag"),
            keywords: &["gesig", "gesig wat hard lag", "histeries", "lag", "rol"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሳቅ መሬት ላይ መሽከርከር"),
            keywords: &["መሬት", "መሽከርከር", "ሳቅ", "በሳቅ መሬት ላይ መሽከርከር", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه ضاحك يتدحرج على الأرض"),
            keywords: &["أرض", "تدحرج", "ضحك", "وجه ضاحك يتدحرج على الأرض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "হ\u{9be}\u{981}হি হ\u{9be}\u{981}হি মজিয\u{9bc}\u{9be}ত ব\u{9be}গৰি পৰ\u{9be}",
            ),
            keywords: &[
                "অট\u{9cd}টহ\u{9be}স\u{9cd}য",
                "ব\u{9be}গৰি পৰ\u{9be}",
                "মজিয\u{9bc}\u{9be}",
                "ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি হ\u{9be}\u{981}হি মজিয\u{9bc}\u{9be}ত ব\u{9be}গৰি পৰ\u{9be}",
            ],
        },
        #[cfg(feature = "ast")]
        crate::Annotation {
            lang: "ast",
            tts: Some("rodando pel suelu de risa"),
            keywords: &[
                "cara",
                "risa",
                "rodando",
                "rodando pel suelu de risa",
                "suelu",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gülməkdən nəfəsi kəsilmək"),
            keywords: &[
                "diyirlənən",
                "gülməkdən nəfəsi kəsilmək",
                "gülüş",
                "yer",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("качаюся са смеху"),
            keywords: &["качацца", "качаюся са смеху", "смех"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Заливащо се от смях лице"),
            keywords: &["Заливащо се от смях лице", "заливане", "лице", "смях"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হেসে ম\u{9be}টিতে ল\u{9c1}টোপ\u{9c1}টি খ\u{9be}ওয\u{9bc}\u{9be}"),
            keywords: &[
                "গড\u{9bc}\u{9be}গড\u{9bc}ি",
                "ম\u{9be}টি",
                "ম\u{9c1}খ",
                "হ\u{9be}সি",
                "হেসে ম\u{9be}টিতে ল\u{9c1}টোপ\u{9c1}টি খ\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("valjanje od smijeha"),
            keywords: &["lice", "pod", "smijeh", "valjanje", "valjanje od smijeha"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que es peta de riure"),
            keywords: &[
                "cara",
                "cara que es peta de riure",
                "partir-se",
                "petar-se de riure",
                "pixar-se",
                "riure",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄎\u{11127}𑄘𑄬 𑄦𑄎\u{11127}𑄘𑄬 𑄟𑄘\u{11128}𑄖\u{11134} 𑄉\u{1112a}𑄌\u{11134}𑄎𑄚"),
            keywords: &["𑄦𑄎\u{11127}𑄘𑄬 𑄦𑄎\u{11127}𑄘𑄬 𑄟𑄘\u{11128}𑄖\u{11134} 𑄉\u{1112a}𑄌\u{11134}𑄎𑄚"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏐᏫᎵᏙᎲ ᎥᎿ ᏯᏖᏃ ᎣᏬᎵᏓᏁᎲᎢ"),
            keywords: &["ᎣᏐᏫᎵᏙᎲ", "ᎣᏐᏫᎵᏙᎲ ᎥᎿ ᏯᏖᏃ ᎣᏬᎵᏓᏁᎲᎢ", "ᎤᎧᏛ", "ᎤᏰᏍᎩ", "ᏯᏖᏃ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej válející se smíchy"),
            keywords: &[
                "obličej válející se smíchy",
                "smajlík",
                "smích",
                "tvář",
                "válet",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rholio ar y llawr yn chwerthin"),
            keywords: &[
                "chwerthin",
                "llawr",
                "rholio",
                "rholio ar y llawr yn chwerthin",
                "wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ruller rundt på gulvet af grin"),
            keywords: &[
                "ansigt",
                "griner",
                "gulv",
                "ler",
                "ruller",
                "ruller rundt på gulvet af grin",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich vor Lachen auf dem Boden wälzen"),
            keywords: &["Gesicht", "lachen", "sich vor Lachen auf dem Boden wälzen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ξεκαρδίζομαι"),
            keywords: &[
                "γέλιο",
                "δυνατό γέλιο",
                "ξεκάρδισμα",
                "ξεκαρδίζομαι",
                "πρόσωπο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("rolling on the floor laughing"),
            keywords: &[
                "face",
                "floor",
                "laugh",
                "rofl",
                "rolling",
                "rolling on the floor laughing",
                "rotfl",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara revolviéndose de la risa"),
            keywords: &[
                "cara",
                "cara revolviéndose de la risa",
                "carcajada",
                "ojos cerrados",
                "risa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara llorando de risa"),
            keywords: &[
                "cara",
                "cara llorando de risa",
                "carcajada",
                "risa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naerust kõveras"),
            keywords: &["kõver", "naer", "naerust kõveras"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barrez leherka"),
            keywords: &["barrez", "leherka", "lehertu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("از خنده غش کردن"),
            keywords: &["از خنده", "از خنده غش کردن", "صورت", "غش", "قهقهه", "مردم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nauraa kippurassa"),
            keywords: &["kasvot", "kippura", "naama", "nauraa", "nauraa kippurassa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gumugulong sa kakatawa"),
            keywords: &[
                "gumugulong",
                "gumugulong sa kakatawa",
                "mukha",
                "sahig",
                "tumatawa",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tárandi flennandi andlit"),
            keywords: &["andlit", "lofl", "tár", "tárandi flennandi andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("se rouler par terre de rire"),
            keywords: &[
                "rire",
                "se rouler par terre",
                "se rouler par terre de rire",
                "visage",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("rire à se rouler par terre"),
            keywords: &[
                "rire",
                "rire à se rouler par terre",
                "se rouler par terre",
                "visage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sna trithí gáire"),
            keywords: &[
                "aghaidh",
                "gáire",
                "sna trithí gáire",
                "sna tríthí",
                "urlár",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ ruidhleadh air an làr a’ gàireachdainn"),
            keywords: &[
                "aodann",
                "a’ ruidhleadh air an làr a’ gàireachdainn",
                "gàire",
                "gàireachdainn",
                "làr",
                "roladh",
                "ruidhleadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara esmendrellándose de risa"),
            keywords: &[
                "cara esmendrellándose de risa",
                "escachar",
                "esmendrellarse",
                "gargallada",
                "risa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમીન પર લોટીન\u{ac7} હસવ\u{ac1}\u{a82}"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "જમીન",
                "જમીન પર લોટીન\u{ac7} હસવ\u{ac1}\u{a82}",
                "લોટવ\u{ac1}\u{a82}",
                "હસવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mirgina a daɓe da dariya"),
            keywords: &[
                "dariya",
                "daɓe",
                "fuska",
                "mirgina",
                "mirgina a daɓe da dariya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מתגלגל על הרצפה מרוב צחוק"),
            keywords: &[
                "מתגלגל",
                "מתגלגל על הרצפה מרוב צחוק",
                "פרצוף",
                "צחוק",
                "רצפה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{901}सत\u{947} ह\u{901}सत\u{947} लोट-पोट होना"),
            keywords: &[
                "च\u{947}हरा",
                "फ\u{93c}र\u{94d}श",
                "लोटना",
                "ह\u{901}सत\u{947} ह\u{901}सत\u{947} लोट-पोट होना",
                "ह\u{901}सी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("valjanje od smijeha"),
            keywords: &["lice", "pod", "smijeh", "valjanje", "valjanje od smijeha"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gurul a nevetéstől"),
            keywords: &["fej", "gurul", "gurul a nevetéstől", "nevet", "nevetés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծիծաղից գլորվում է"),
            keywords: &["գլորվել", "դեմք", "ծիծաղ", "ծիծաղից գլորվում է"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("rolante se per terra de rider"),
            keywords: &[
                "facie",
                "ridente",
                "riso",
                "rolante se per terra de rider",
                "rolar",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tertawa terbahak-bahak"),
            keywords: &[
                "kocak",
                "lucu",
                "ngakak",
                "tertawa",
                "tertawa terbahak-bahak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-atụgharị n’ala na-achị ọchị"),
            keywords: &[
                "ihu",
                "na-achị ọchị",
                "na-atụgharị",
                "na-atụgharị n’ala na-achị ọchị",
                "n’ala",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("veltist um af hlátri"),
            keywords: &["hlátur", "veltast", "veltist um af hlátri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("ridere a crepapelle"),
            keywords: &["crepapelle", "ridere", "ridere a crepapelle"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("笑い転げる"),
            keywords: &["スマイル", "笑い転げる", "笑う", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ngguyu ngakak nganti glintingan ing jogan"),
            keywords: &[
                "guyu",
                "jogan",
                "ngglinting",
                "ngguyu ngakak nganti glintingan ing jogan",
                "rai",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სიცილისგან იატაკზე ხოხვა"),
            keywords: &[
                "იატაკი",
                "სახე",
                "სიცილი",
                "სიცილისგან იატაკზე ხოხვა",
                "ხოხვა",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("axbibed di tmurt si tedsa"),
            keywords: &["axbibed di tmurt si tedsa"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ішек-сілесі қатып күлу"),
            keywords: &["бет", "күлу", "ішек-сілесі", "ішек-сілесі қатып күлу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ruller rundt på gulvet af grin"),
            keywords: &[
                "ansigt",
                "grine",
                "griner",
                "gulv",
                "latter",
                "ler",
                "ruller",
                "ruller rundt på gulvet af grin",
                "vrider sig",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សើចរមាលលើដ\u{17b8}"),
            keywords: &[
                "ម\u{17bb}ខ",
                "រមាល",
                "លើដ\u{17b8}",
                "សើច",
                "សើចរមាលលើដ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೊರಳಾಡ\u{cbf} ನಗುವುದು"),
            keywords: &[
                "ನಗು",
                "ನ\u{cc6}ಲ",
                "ನ\u{cc6}ಲದ ಮೇಲ\u{cc6} ಹೊರಳಾಡ\u{cbf} ನಗುವುದು",
                "ಮುಖ",
                "ಹೊರಳಾಡ\u{cbf} ನಗುವುದು",
                "ಹೊರಳಾಡು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("바닥을 구르며 웃는 얼굴"),
            keywords: &[
                "구르기",
                "데굴데굴",
                "바닥",
                "바닥을 구르며 웃는 얼굴",
                "웃음",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जमनीर लोळ\u{942}न हा\u{902}सप"),
            keywords: &[
                "च\u{947}रो",
                "जमनीर लोळ\u{942}न हा\u{902}सप",
                "जमीन",
                "लोळप",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тоголонуп күлүү"),
            keywords: &["күлүү", "тоголонуп күлүү", "тоголонуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("vu Laache rullend"),
            keywords: &[
                "Buedem",
                "Gesiicht",
                "laachen",
                "rullen",
                "vu Laache rullend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວຈ\u{ebb}ນນອນກ\u{eb4}\u{ec9}ງຢ\u{eb9}\u{ec8}ພ\u{eb7}\u{ec9}ນ"),
            keywords: &[
                "ກ\u{eb4}\u{ec9}ງ",
                "ພ\u{eb7}\u{ec9}ນ",
                "ຫ\u{ebb}ວ",
                "ຫ\u{ebb}ວຈ\u{ebb}ນນອນກ\u{eb4}\u{ec9}ງຢ\u{eb9}\u{ec8}ພ\u{eb7}\u{ec9}ນ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raitausi iš juoko"),
            keywords: &["juokas", "raitausi iš juoko", "raitytis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vārtās smieklos pa grīdu"),
            keywords: &["grīda", "seja", "smieties", "vārtās smieklos pa grīdu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("takaoriori ana i te papa me te katakata"),
            keywords: &[
                "kanohi",
                "katakata",
                "papa",
                "takaoriori",
                "takaoriori ana i te papa me te katakata",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("превртување од смеење"),
            keywords: &["под", "превртување од смеење", "смеење", "тркалање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ചിരിച\u{d4d}ച\u{d41}ചിരിച\u{d4d}ച\u{d4d} മണ\u{d4d}ണ\u{d41}കപ\u{d4d}പ\u{d41}ക",
            ),
            keywords: &[
                "ചിരി",
                "ചിരിച\u{d4d}ച\u{d41}ചിരിച\u{d4d}ച\u{d4d} മണ\u{d4d}ണ\u{d41}കപ\u{d4d}പ\u{d41}ക",
                "മണ\u{d4d}ണ\u{d41}കപ\u{d4d}പ\u{d41}ക",
                "മലർന\u{d4d}ന\u{d41}കിടന\u{d4d}ന\u{d4d} ചിരിക\u{d4d}ക\u{d41}ക",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("инээж, газар өнхрөх царай"),
            keywords: &[
                "газар",
                "инээж, газар өнхрөх царай",
                "инээх",
                "царай",
                "өнхрөх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हस\u{942}न हस\u{942}न ब\u{947}जार होण\u{947}"),
            keywords: &[
                "च\u{947}हरा",
                "जमीन",
                "ब\u{947}जार होण\u{947}",
                "हसण\u{947}",
                "हस\u{942}न हस\u{942}न ब\u{947}जार होण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ketawa tergolek-golek"),
            keywords: &["ketawa", "lantai", "muka", "tergolek-golek"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("jirrombla mal-art jidħaq"),
            keywords: &[
                "art",
                "irrumblar",
                "jidħaq",
                "jirrombla mal-art jidħaq",
                "wiċċ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ကြမ\u{103a}းပေါ\u{103a}လ\u{103e}\u{102d}မ\u{1037}\u{103a}ပြ\u{102e}း ရယ\u{103a}နေသည\u{103a}",
            ),
            keywords: &[
                "ကြမ\u{103a}းပေါ\u{103a}လ\u{103e}\u{102d}မ\u{1037}\u{103a}ပြ\u{102e}း ရယ\u{103a}နေသည\u{103a}",
                "ကြမ\u{103a}းပြင\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
                "ရယ\u{103a}မောခြင\u{103a}း",
                "လ\u{103e}\u{102d}မ\u{1037}\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ruller rundt på gulvet i latter"),
            keywords: &[
                "fjes",
                "gulv",
                "latter",
                "ruller",
                "ruller rundt på gulvet i latter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अत\u{94d}यन\u{94d}त\u{948} हा\u{901}स उठ\u{94d}दो"),
            keywords: &[
                "अत\u{94d}यन\u{94d}त\u{948} हा\u{901}स उठ\u{94d}दो",
                "अन\u{941}हार",
                "भ\u{941}ई\u{901}",
                "लडिब\u{941}डी",
                "हा\u{901}सो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht dat op de grond rolt van het lachen"),
            keywords: &[
                "gezicht",
                "gezicht dat op de grond rolt van het lachen",
                "grond",
                "lachen",
                "rollen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rullar rundt på golvet i latter"),
            keywords: &[
                "fjes",
                "golv",
                "latter",
                "rullar",
                "rullar rundt på golvet i latter",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହସ\u{b3f} ହସ\u{b3f} ଚଟ\u{b3e}ଣରେ ଗଡ\u{b3c}\u{b3f}ଯ\u{b3f}ବ\u{b3e}"),
            keywords: &[
                "ଗଡ\u{b3f}ବ\u{b3e}",
                "ଚଟ\u{b3e}ଣ",
                "ମ\u{b41}ହ\u{b01}",
                "ହସ\u{b3f} ହସ\u{b3f} ଚଟ\u{b3e}ଣରେ ଗଡ\u{b3c}\u{b3f}ଯ\u{b3f}ବ\u{b3e}",
                "ହସ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਸ-ਹ\u{a71}ਸ ਲ\u{a4b}ਟ-ਪ\u{a4b}ਟ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਫਰਸ\u{a3c}",
                "ਲ\u{a47}ਟਣਾ",
                "ਹਾਸਾ",
                "ਹ\u{a71}ਸ-ਹ\u{a71}ਸ ਲ\u{a4b}ਟ-ਪ\u{a4b}ਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قہقہے نال زمین اوتے لوٹ پھوٹ"),
            keywords: &[
                "دی شکل",
                "فرش",
                "قہقہے نال زمین اوتے لوٹ پھوٹ",
                "گھمدا ہوئیا",
                "ہسنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹ\u{301}nd Hẹd Wọ\u{301}n Said De Laf"),
            keywords: &[
                "Bẹ\u{301}nd Hẹd Wọ\u{301}n Said De Laf",
                "De Ról Fọ Graun De Laf",
                "Fes",
                "Graun",
                "Laf",
                "Rol",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("tarza się ze śmiechu"),
            keywords: &["kulać się", "tarza się ze śmiechu", "śmiech"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خندا نه په فرش رغړېدل"),
            keywords: &["خندل", "د خندا نه په فرش رغړېدل", "فرش", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rolando no chão de rir"),
            keywords: &[
                "chão",
                "gargalhada",
                "rolando",
                "rolando no chão de rir",
                "rosto",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("a rebolar no chão a rir"),
            keywords: &["a rebolar no chão a rir", "cara", "chão", "rebolar", "rir"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyusqa kusi jallpʼapi"),
            keywords: &[
                "hallpʼa",
                "kusi",
                "muyusqa",
                "muyusqa kusi hallpʼapi",
                "muyusqa kusi jallpʼapi",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("tăvălindu-se pe jos de râs"),
            keywords: &["față", "jos", "râs", "tăvăli", "tăvălindu-se pe jos de râs"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1029"),
            keywords: &["E10-1029"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("катается со смеху"),
            keywords: &[
                "rofl",
                "катается со смеху",
                "кататься от хохота",
                "смех",
                "смеяться",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("yigaragura ku butaka aseka"),
            keywords: &[
                "guseka",
                "hasi",
                "isura",
                "kwigaragura",
                "yigaragura ku butaka aseka",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کلندي فرش تي ليٿڙيون پائيندي"),
            keywords: &[
                "فرش",
                "ليٿريون پائيندي",
                "چھرو",
                "کل",
                "کلندي فرش تي ليٿڙيون پائيندي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}ම පෙරළ\u{dd3}මෙන\u{dca} ස\u{dd2}න\u{dcf}ස\u{dd3}ම"),
            keywords: &[
                "පෙරළ\u{dd3}ම",
                "බ\u{dd2}ම",
                "බ\u{dd2}ම පෙරළ\u{dd3}මෙන\u{dca} ස\u{dd2}න\u{dcf}ස\u{dd3}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}න\u{dcf}සෙනව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("váľam sa od smiechu"),
            keywords: &["smiech", "tvár", "váľam", "váľam sa od smiechu"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("krohotanje"),
            keywords: &["krohotanje", "smeh", "tla", "valjanje po tleh"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhulka ku rafanaayo oo qoslaya"),
            keywords: &[
                "dhulka",
                "dhulka ku rafanaayo oo qoslaya",
                "dhulka ku rafanaayo oo qosolaya",
                "ku rafanaaya",
                "qosl",
                "waji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("rrokullisje në dysheme nga e qeshura"),
            keywords: &[
                "dysheme",
                "fytyrë",
                "qeshje",
                "rrokullisje",
                "rrokullisje në dysheme nga e qeshura",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ваљање од смеха"),
            keywords: &["ваљање", "ваљање од смеха", "лице", "под", "смех"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("ваљање од смијеха"),
            keywords: &["ваљање од смијеха"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("valjanje od smeha"),
            keywords: &["lice", "pod", "smeh", "valjanje", "valjanje od smeha"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("valjanje od smijeha"),
            keywords: &["valjanje od smijeha"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rullar runt på golvet och skrattar"),
            keywords: &[
                "ansikte",
                "golv",
                "rullar",
                "rullar runt på golvet och skrattar",
                "skratt",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("angua kicheko"),
            keywords: &["angua kicheko", "cheka", "kugaragara", "sakafu", "uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விழுந\u{bcd}து விழுந\u{bcd}து சிரிப\u{bcd}பது"),
            keywords: &[
                "க\u{bbe}மெடி",
                "சிரிப\u{bcd}பு",
                "முகம\u{bcd}",
                "விழுந\u{bcd}து விழுந\u{bcd}து சிரிப\u{bcd}பது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3f}ందపడ\u{c3f} ద\u{c4a}ర\u{c4d}లుతూ నవ\u{c4d}వడం"),
            keywords: &[
                "క\u{c3f}ందపడ\u{c3f}",
                "క\u{c3f}ందపడ\u{c3f} ద\u{c4a}ర\u{c4d}లుతూ నవ\u{c4d}వడం",
                "ద\u{c4a}ర\u{c4d}లడం",
                "నవ\u{c4d}వు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аз ханда рӯдакан шудан"),
            keywords: &[
                "аз ханда рӯдакан шудан",
                "даврзананда",
                "рӯй",
                "фарш",
                "хандидан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขำกล\u{e34}\u{e49}ง"),
            keywords: &[
                "กล\u{e34}\u{e49}ง",
                "ขำ",
                "ขำกล\u{e34}\u{e49}ง",
                "แว\u{e49}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("içiňi tutup gülmek"),
            keywords: &["gülmek", "içiňi tutup gülmek", "togalanmak", "ýer", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata kata moe teka faliki"),
            keywords: &["mata kata moe teka faliki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gülmekten yerlere yatma"),
            keywords: &["gülme", "gülmekten yerlere yatma", "yatma", "yer", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۈلۈپ يېتىۋېلىش"),
            keywords: &["ئېغىناش", "كۈلۈش", "كۈلۈپ يېتىۋېلىش", "يەر", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("качається від сміху"),
            keywords: &["качається від сміху", "обличчя", "регіт", "сміх"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہنستے ہنستے لوٹ پوٹ ہونا"),
            keywords: &["لوٹ پوٹ", "چہرہ", "ہنستے ہنستے لوٹ پوٹ ہونا", "ہنسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qotib kulayotgan"),
            keywords: &["kulayotgan", "qahqaha", "qotib", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười lăn cười bò"),
            keywords: &["cười", "lăn", "mặt", "mặt cười lăn cười bò", "sàn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ree ba xalangu ci suuf"),
            keywords: &[
                "kanam",
                "ree ba xalangu ci suuf",
                "reetaan",
                "suuf",
                "xalangu",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukugigitheka phantsi"),
            keywords: &[
                "hleka",
                "ubuso",
                "ukugigitheka phantsi",
                "ukuqengqeleka",
                "umgangatho",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yíyí ní ilẹ\u{300}nlẹ\u{300} tún rẹ\u{301}rìn"),
            keywords: &[
                "Yíyí ní ilẹ\u{300}nlẹ\u{300} tún rẹ\u{301}rìn",
                "ilẹ\u{300}",
                "ojú",
                "rẹ\u{301}rìń",
                "yíyí",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("笑到碌地"),
            keywords: &["地下", "碌地", "笑", "笑到碌地", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("笑到碌地"),
            keywords: &["地下", "碌地", "笑", "笑到碌地", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("笑得满地打滚"),
            keywords: &["地板", "打滚", "笑", "笑得满地打滚", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("笑翻了"),
            keywords: &["捧腹", "笑", "笑翻了", "翻"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("笑到轆地"),
            keywords: &["捧腹", "笑", "笑到轆地", "翻"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ngihleka ngiyabhuquza"),
            keywords: &[
                "bhuquza",
                "hleka",
                "ngihleka ngiyabhuquza",
                "phansi",
                "ubuso",
            ],
        },
    ],
};
#[doc = "😂"]
pub const FACE_WITH_TEARS_OF_JOY: crate::Emoji = crate::Emoji {
    glyph: "😂",
    codepoint: "1F602",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "face with tears of joy",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met trane van vreugde"),
            keywords: &[
                "gesig",
                "gesig met trane van vreugde",
                "lag",
                "traan",
                "vreugde",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሐሤት እንባ ያሉት ፊት"),
            keywords: &["ሐሤት", "እንባ", "ከባድ ሣቅ", "የሐሤት እንባ ያሉት ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بدموع فرح"),
            keywords: &["دموع", "فرح", "وجه", "وجه بدموع فرح", "وجه عليه دموع فرح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আনন\u{9cd}দ\u{9be}শ\u{9cd}ৰ\u{9c1}ৰ সৈতে ম\u{9c1}খ"),
            keywords: &[
                "অট\u{9cd}টহ\u{9be}স\u{9cd}য",
                "আনন\u{9cd}দ",
                "আনন\u{9cd}দ\u{9be}শ\u{9cd}ৰ\u{9c1}ৰ সৈতে ম\u{9c1}খ",
                "চক\u{9c1}প\u{9be}নী",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "ast")]
        crate::Annotation {
            lang: "ast",
            tts: Some("cara llorando d’allegría"),
            keywords: &[
                "allegría",
                "cara",
                "cara llorando d’allegría",
                "llárima",
                "risa",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sevinc göz yaşları olan üz"),
            keywords: &[
                "göz yaşı",
                "gülüş",
                "sevinc",
                "sevinc göz yaşları olan üz",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("слёзы шчасця"),
            keywords: &["зубы", "слёзы", "слёзы шчасця", "смех", "шчасце"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице със сълзи от радост"),
            keywords: &[
                "Лице със сълзи от радост",
                "лице",
                "радост",
                "смях",
                "сълза",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আনন\u{9cd}দের ক\u{9be}ন\u{9cd}ন\u{9be} ভর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "আনন\u{9cd}দ",
                "আনন\u{9cd}দের ক\u{9be}ন\u{9cd}ন\u{9be} ভর\u{9be} ম\u{9c1}খ",
                "ক\u{9be}ন\u{9cd}ন\u{9be}",
                "জোরে হ\u{9be}স\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plakanje od smijeha"),
            keywords: &["lice", "plakanje od smijeha", "radost", "smijeh", "suza"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb llàgrimes d’alegria"),
            keywords: &[
                "alegria",
                "cara",
                "cara amb llàgrimes d’alegria",
                "llàgrimes",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄟\u{1112a} 𑄦𑄚\u{11134}𑄖\u{11134} 𑄦\u{1112a}𑄎\u{11128}𑄢\u{11134} 𑄌\u{1112e}𑄉\u{1112e} 𑄛𑄚\u{11128}",
            ),
            keywords: &[
                "𑄟\u{1112a} 𑄦𑄚\u{11134}𑄖\u{11134} 𑄦\u{1112a}𑄎\u{11128}𑄢\u{11134} 𑄌\u{1112e}𑄉\u{1112e} 𑄛𑄚\u{11128}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᏚᎦᎳᏁᏒ Ꮎ ᎤᎵᎮᎵᏍᏗ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᏚᎦᎳᏁᏒ Ꮎ ᎤᎵᎮᎵᏍᏗ", "ᎤᎵᎮᎵᏨ", "ᎤᏩᏍᏉᎸ", "ᎤᏰᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej slzící smíchy"),
            keywords: &[
                "obličej slzící smíchy",
                "radost",
                "slzy",
                "smajlík",
                "smích",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â dagrau hapusrwydd"),
            keywords: &[
                "chwerthin",
                "dagrau",
                "hapusrwydd",
                "wyneb",
                "wyneb â dagrau hapusrwydd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med glædestårer"),
            keywords: &["ansigt med glædestårer", "glad", "glæde", "tårer"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Freudentränen"),
            keywords: &["Gesicht", "Gesicht mit Freudentränen", "Tränen", "lachen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλαίω από χαρά"),
            keywords: &["γέλιο", "δάκρυ", "κλαίω από χαρά", "πρόσωπο", "χαρά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with tears of joy"),
            keywords: &["face", "face with tears of joy", "joy", "laugh", "tear"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara llorando de risa"),
            keywords: &[
                "cara",
                "cara llorando de risa",
                "felicidad",
                "lágrima",
                "risa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara llorando"),
            keywords: &[
                "cara",
                "cara llorando",
                "cara llorando de risa",
                "felicidad",
                "lágrima",
                "risa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara llorando de felicidad"),
            keywords: &[
                "cara",
                "cara llorando de felicidad",
                "felicidad",
                "feliz",
                "lágrimas",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara llorando de felicidad"),
            keywords: &["cara llorando de felicidad"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rõõmupisaratega nägu"),
            keywords: &["naer", "nägu", "pisar", "rõõm", "rõõmupisaratega nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pozez negar egiten ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "barre",
                "malko",
                "poz",
                "pozez negar egiten ari den aurpegia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("روده\u{200c}بر"),
            keywords: &["اشک", "خنده بلند", "خوشحالی", "روده\u{200c}بر", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvot naurunkyynelissä"),
            keywords: &[
                "ilo",
                "itkunauru",
                "kasvot naurunkyynelissä",
                "naama",
                "naurunkyyneleet",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang naiiyak sa tuwa"),
            keywords: &[
                "iyak",
                "luha",
                "masaya",
                "mukha",
                "mukhang naiiyak sa tuwa",
                "tawa",
                "tumatawa",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við gleðistárum"),
            keywords: &["andlit", "andlit við gleðistárum", "gleði", "látur", "tár"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage riant aux larmes"),
            keywords: &["larmes", "sourire", "visage riant aux larmes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage pleurant de joie"),
            keywords: &["joie", "larme", "rire", "visage", "visage pleurant de joie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le deora áthais"),
            keywords: &["deora áthais", "straoiseog le deora áthais"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le deòir shona"),
            keywords: &["aodann", "aodann le deòir shona", "deur", "gàire", "sona"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara chorando de risa"),
            keywords: &[
                "alegría",
                "bágoas",
                "cara chorando de risa",
                "chorar de risa",
                "escachar",
                "risa",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હર\u{acd}ષના આ\u{a82}સ\u{ac1} સાથ\u{ac7}નો ચહ\u{ac7}રો"),
            keywords: &[
                "અશ\u{acd}ર\u{ac1}",
                "આન\u{a82}દ",
                "ચહ\u{ac7}રો",
                "હર\u{acd}ષના આ\u{a82}સ\u{ac1} સાથ\u{ac7}નો ચહ\u{ac7}રો",
                "હાસ\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai hawayen murna"),
            keywords: &[
                "dariya",
                "fuska",
                "fuska mai hawayen murna",
                "hawaye",
                "murna",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם דמעות שמחה"),
            keywords: &[
                "דמעות",
                "פרצוף",
                "פרצוף עם דמעות שמחה",
                "צחוק",
                "שמח",
                "שמחה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}शी क\u{947} आ\u{901}स\u{941}ओ\u{902} वाला च\u{947}हरा"),
            keywords: &[
                "आ\u{901}स\u{942}",
                "ख\u{941}शी",
                "ख\u{941}शी क\u{947} आ\u{901}स\u{941}ओ\u{902} वाला च\u{947}हरा",
                "च\u{947}हरा",
                "ह\u{901}सी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice sa suzama radosnicama"),
            keywords: &[
                "lice",
                "lice sa suzama radosnicama",
                "smijeh",
                "suze",
                "veselje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc örömkönnyekkel"),
            keywords: &["arc", "arc örömkönnyekkel", "könnyek", "nevetés", "öröm"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեմք ուրախության արցունքներով"),
            keywords: &[
                "արցունք",
                "դեմք",
                "դեմք ուրախության արցունքներով",
                "ծիծաղել",
                "ուրախություն",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("visage plorante de riso"),
            keywords: &[
                "facie",
                "gaudio",
                "joia",
                "lacrimas",
                "visage",
                "visage plorante de riso",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah gembira berurai air mata"),
            keywords: &[
                "air mata",
                "bahagia",
                "tertawa",
                "wajah",
                "wajah dengan air mata bahagia",
                "wajah gembira berurai air mata",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere anya mmiri nke aṅụrị"),
            keywords: &[
                "anya mmiri",
                "aṅụrị",
                "ihu",
                "ihu nwere anya mmiri nke aṅụrị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit tárast af gleði"),
            keywords: &["andlit", "andlit tárast af gleði", "gleðitár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con lacrime di gioia"),
            keywords: &[
                "faccina",
                "faccina con lacrime di gioia",
                "gioia",
                "lacrime",
                "piangere dal ridere",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("嬉し泣き"),
            keywords: &["スマイル", "嬉し泣き", "涙", "笑う", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngguyu nganti luhen saking bungahe"),
            keywords: &[
                "bungah",
                "guyu",
                "luh",
                "rai",
                "rai ngguyu nganti luhen saking bungahe",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე სიხარულის ცრემლებით"),
            keywords: &[
                "მხიარული",
                "სახე",
                "სახე სიხარულის ცრემლებით",
                "სიცილი",
                "სიხარული",
                "ცრემლი",
                "ცრემლიანი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("taḍsa ar imeṭṭawen"),
            keywords: &["taḍsa ar imeṭṭawen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көзден жас шыққанша күлу"),
            keywords: &["бет", "жас", "күлкі", "көзден жас шыққанша күлу", "қуаныш"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med glædestårer"),
            keywords: &["ansigt med glædestårer", "glad", "glæde", "tårer"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខសើចឡើងហៀរទ\u{17b9}កភ\u{17d2}នែក"),
            keywords: &[
                "ទ\u{17b9}កភ\u{17d2}នែក",
                "ម\u{17bb}ខសើចឡើងហៀរទ\u{17b9}កភ\u{17d2}នែក",
                "សើច",
                "\u{200b} រ\u{17b8}ករាយ",
                "\u{200b} សប\u{17d2}បាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆನಂದದ ಕಣ\u{ccd}ಣೀರು, ಆನಂದ ಬಾಷ\u{ccd}ಪ"),
            keywords: &[
                "ಆನಂದದ ಕಣ\u{ccd}ಣೀರು, ಆನಂದ ಬಾಷ\u{ccd}ಪ",
                "ಕಣ\u{ccd}ಣೀರು",
                "ನಗು",
                "ಮುಖ",
                "ಸಂತೋಷ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기쁨의 눈물을 흘리는 얼굴"),
            keywords: &[
                "기쁨",
                "기쁨의 눈물을 흘리는 얼굴",
                "눈물",
                "스마일",
                "얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आन\u{902}दाश\u{94d}र\u{942}चो च\u{947}रो"),
            keywords: &[
                "आन\u{902}द",
                "आन\u{902}दाश\u{94d}र\u{942}चो च\u{947}रो",
                "च\u{947}रो",
                "द\u{942}क",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("боору эзилип күлгөн бет"),
            keywords: &["бет", "боор", "боору эзилип күлгөн бет", "күл", "эзил"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat Freedtréinen"),
            keywords: &[
                "Freed",
                "Gesiicht",
                "Gesiicht mat Freedtréinen",
                "Laachen",
                "Tréin",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{ec9}ອງໄຫ\u{ec9}ດ\u{eb5}ໃຈ"),
            keywords: &[
                "ດ\u{eb5}ໃຈ",
                "ນ\u{ecd}\u{ec9}າຕາ",
                "ຫ\u{ebb}ວ",
                "ຮ\u{ec9}ອງໄຫ\u{ec9}ດ\u{eb5}ໃຈ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su džiaugsmo ašaromis"),
            keywords: &[
                "ašara",
                "džiaugsmas",
                "juokas",
                "veidas",
                "veidas su džiaugsmo ašaromis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar prieka asarām"),
            keywords: &[
                "asaras",
                "prieks",
                "seja",
                "seja ar prieka asarām",
                "smiekli",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi roimata harikoa"),
            keywords: &["harikoa", "kanohi", "kata", "roimata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со солзи радосници"),
            keywords: &["лице", "лице со солзи радосници", "радост", "смеа", "солза"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ആനന\u{d4d}ദ\u{d3e}ശ\u{d4d}ര\u{d41}ക\u{d4d}കളോടെയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
            ),
            keywords: &[
                "ആനന\u{d4d}ദം",
                "ആനന\u{d4d}ദ\u{d3e}ശ\u{d4d}ര\u{d41}ക\u{d4d}കളോടെയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "കണ\u{d4d}ണീർ",
                "പൊട\u{d4d}ടിച\u{d4d}ചിരി",
                "മ\u{d41}ഖം",
                "സന\u{d4d}തോഷം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нулимсаа гартал инээж буй царай"),
            keywords: &[
                "инээх",
                "нулимс гарах",
                "нулимсаа гартал инээж буй царай",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आन\u{902}दाश\u{94d}र\u{942}\u{902}सह च\u{947}हरा"),
            keywords: &[
                "अश\u{94d}र\u{942}",
                "आन\u{902}द",
                "आन\u{902}दाश\u{94d}र\u{942}\u{902}सह च\u{947}हरा",
                "च\u{947}हरा",
                "हसण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan air mata kegembiraan"),
            keywords: &[
                "air mata",
                "gembira",
                "ketawa",
                "muka",
                "muka dengan air mata kegembiraan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ bi dmugħ ta’ ferħ"),
            keywords: &["daħq", "demgħa", "ferħ", "wiċċ", "wiċċ bi dmugħ ta’ ferħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}မ\u{103e}\u{102f} မျက\u{103a}ရည\u{103a}များဖြင\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}မ\u{103e}\u{102f}",
                "ပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}မ\u{103e}\u{102f} မျက\u{103a}ရည\u{103a}များဖြင\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}ရည\u{103a}",
                "ရယ\u{103a}ရ\u{103d}\u{103e}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gledestårer"),
            keywords: &[
                "fjes",
                "fjes med gledestårer",
                "glede",
                "gledestårer",
                "tårer",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}सीको आ\u{901}स\u{941} द\u{947}खिएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}स\u{941}",
                "ख\u{941}शी",
                "ख\u{941}सीको आ\u{901}स\u{941} द\u{947}खिएको अन\u{941}हार",
                "हा\u{901}सो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met tranen van vreugde"),
            keywords: &[
                "gezicht",
                "gezicht met tranen van vreugde",
                "lach",
                "traan",
                "vreugde",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gledestårer"),
            keywords: &[
                "fjes",
                "fjes med gledestårer",
                "glede",
                "gledestårer",
                "tårer",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆନନ\u{b4d}ଦ\u{b3e}ଶ\u{b4d}ର\u{b41} ସହ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆନନ\u{b4d}ଦ",
                "ଆନନ\u{b4d}ଦ\u{b3e}ଶ\u{b4d}ର\u{b41} ସହ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
                "ହସ\u{b3f}ବ\u{b3e} । ଲ\u{b41}ହ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}ਸ\u{a3c}ੀ ਦ\u{a47} ਹ\u{a70}ਝ\u{a42}ਆ\u{a02} ਨਾਲ ਚਿਹਰਾ"),
            keywords: &[
                "ਖ\u{a41}ਸ\u{a3c}ੀ",
                "ਖ\u{a41}ਸ\u{a3c}ੀ ਦ\u{a47} ਹ\u{a70}ਝ\u{a42}",
                "ਖ\u{a41}ਸ\u{a3c}ੀ ਦ\u{a47} ਹ\u{a70}ਝ\u{a42}ਆ\u{a02} ਨਾਲ ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਹ\u{a70}ਝ\u{a42}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خوشی دے اتھرواں نال شکل"),
            keywords: &["اتھرو", "خوشی", "خوشی دے اتھرواں نال شکل", "دی شکل", "ہسنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wit Laf and Tias Fọ Ai"),
            keywords: &[
                "Fes",
                "Fes Wit Hápí Tias Fọ Ai",
                "Fes Wit Laf and Tias Fọ Ai",
                "Hápi",
                "Laf",
                "Tias",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz ze łzami radości"),
            keywords: &["twarz ze łzami radości", "łzy", "śmiech"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خوشحالۍ د اوښکو مخ"),
            keywords: &["اوښکې", "خندا", "خوشالي", "د خوشحالۍ د اوښکو مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto chorando de rir"),
            keywords: &[
                "alegria",
                "lágrimas",
                "rosto",
                "rosto chorando de rir",
                "rosto com lágrimas de alegria",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com lágrimas de felicidade"),
            keywords: &[
                "cara",
                "cara com lágrimas de felicidade",
                "felicidade",
                "lágrimas",
                "riso",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya wiqikunawan"),
            keywords: &["kusi", "kusisqa", "kusisqa uya wiqikunawan", "uya", "wiqi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu lacrimi de bucurie"),
            keywords: &[
                "bucurie",
                "față",
                "față cu lacrimi de bucurie",
                "lacrimi",
                "râset",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-838"),
            keywords: &["E10-838"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("смеется до слез"),
            keywords: &[
                "лицо",
                "радость",
                "слезы",
                "смеется до слез",
                "смех",
                "смех до слез",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ifite amarira y’ibyishimo"),
            keywords: &[
                "guseka",
                "ibyishimo",
                "isura",
                "isura ifite amarira y’ibyishimo",
                "kurira",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خوشي جي ڳوڙهن وارو چهرو"),
            keywords: &[
                "خوشي",
                "خوشي جي ڳوڙهن وارو چهرو",
                "خوشي جي ڳوڙھن وارو چھرو",
                "چھرو",
                "کل",
                "ڳوڙھو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සත\u{dd4}ට\u{dd4} කඳ\u{dd4}ළ\u{dd4} සහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කඳ\u{dd4}ළ\u{dd4}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "සත\u{dd4}ට",
                "සත\u{dd4}ට\u{dd4} කඳ\u{dd4}ළ\u{dd4} සහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}නහව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("plačem od smiechu"),
            keywords: &[
                "plač",
                "plačem od smiechu",
                "radosť",
                "slza",
                "smiech",
                "tvár",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s solzami veselja"),
            keywords: &[
                "obraz",
                "obraz s solzami veselja",
                "smeh",
                "solze",
                "veselje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji ilin farxad leh"),
            keywords: &["farxad", "ilin", "qosol", "waji", "waji ilin farxad leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me lot gëzimi"),
            keywords: &["fytyrë", "fytyrë me lot gëzimi", "gëzim", "lot", "qesh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са сузама радосницама"),
            keywords: &[
                "лице",
                "лице са сузама радосницама",
                "радост",
                "смех",
                "суза",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са сузама радосницама"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa suzama radosnicama"),
            keywords: &[
                "lice",
                "lice sa suzama radosnicama",
                "radost",
                "smeh",
                "suza",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa suzama radosnicama"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med glädjetårar"),
            keywords: &["ansikte med glädjetårar", "glädjetårar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye machozi ya furaha"),
            keywords: &[
                "cheka",
                "chozi",
                "furaha",
                "uso",
                "uso wenye machozi ya furaha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஆனந\u{bcd}தக\u{bcd} கண\u{bcd}ண\u{bc0}ர\u{bcd} சிந\u{bcd}தும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "ஆனந\u{bcd}தக\u{bcd} கண\u{bcd}ண\u{bc0}ர\u{bcd}",
                "ஆனந\u{bcd}தக\u{bcd} கண\u{bcd}ண\u{bc0}ர\u{bcd} சிந\u{bcd}தும\u{bcd} முகம\u{bcd}",
                "கண\u{bcd}ணில\u{bcd} ந\u{bc0}ர\u{bcd} வரச\u{bcd} சிரித\u{bcd}தல\u{bcd}",
                "கண\u{bcd}ண\u{bc0}ர\u{bcd}",
                "சிரிப\u{bcd}பு",
                "மகிழ\u{bcd}ச\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆనందభ\u{c3e}ష\u{c4d}ప\u{c3e}లత\u{c4b} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "ఆనందబ\u{c3e}ష\u{c4d}ప\u{c3e}లు",
                "ఆనందభ\u{c3e}ష\u{c4d}ప\u{c3e}లత\u{c4b} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи бо ашкҳои хурсандӣ"),
            keywords: &[
                "ашк",
                "рӯи бо ашкҳои хурсандӣ",
                "рӯй",
                "хандидан",
                "хурсандӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e49}องไห\u{e49}ด\u{e35}ใจ"),
            keywords: &[
                "ด\u{e35}ใจ",
                "น\u{e49}ำตา",
                "ปล\u{e37}\u{e49}ม",
                "ร\u{e49}องไห\u{e49}ด\u{e35}ใจ",
                "หน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("begenç gözýaşly ýüz"),
            keywords: &["begenç", "begenç gözýaşly ýüz", "gözýaş", "gülki", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe loʻimata fiefia"),
            keywords: &["mata moe loʻimata fiefia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sevinç gözyaşları"),
            keywords: &["gözyaşları", "sevinç", "sevinç gözyaşları olan yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خۇش ياش ئاققان چىراي"),
            keywords: &["خۇش", "خۇش ياش ئاققان چىراي", "كۈل", "ياش", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя в сльозах радості"),
            keywords: &[
                "обличчя",
                "обличчя в сльозах радості",
                "радість",
                "сльози",
                "сміх",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خوشی کے آنسوؤں والا چہرہ"),
            keywords: &["آنسو", "خوشی", "خوشی کے آنسوؤں والا چہرہ", "چہرہ", "ہنسی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quvonch ko‘z yoshlari"),
            keywords: &[
                "ko‘z yosh",
                "kulgu",
                "quvonch",
                "quvonch ko‘z yoshlari",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười với nước mắt vui sướng"),
            keywords: &[
                "cười",
                "mặt",
                "mặt cười với nước mắt vui sướng",
                "nước mắt",
                "vui sướng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu am rangooñu bànneex"),
            keywords: &[
                "kanam",
                "kanam gu am rangooñu bànneex",
                "mbegte",
                "rangooñ",
                "reetaan",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuneenyembezi zovuyo"),
            keywords: &[
                "hleka",
                "iinyembezi",
                "ubuso",
                "ubuso obuneenyembezi zovuyo",
                "uvuyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú pẹ\u{300}lú ẹkún ayọ\u{300}"),
            keywords: &[
                "Ojú pẹ\u{300}lú ẹkún ayọ\u{300}",
                "ojú",
                "àyọ\u{300}",
                "ẹkún",
                "ẹ\u{300}rín",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有開心眼淚嘅臉"),
            keywords: &["快樂", "有開心眼淚嘅臉", "眼淚", "笑", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有开心眼泪嘅脸"),
            keywords: &["快乐", "有开心眼泪嘅脸", "眼泪", "笑", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("笑哭了"),
            keywords: &["眼泪", "笑", "笑哭了", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("感動"),
            keywords: &["喜極而泣", "感動"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("喜極而泣嘅表情"),
            keywords: &["喜極而泣嘅表情", "感動"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunezinyembezi zentokozo"),
            keywords: &[
                "intokozo",
                "izinyembezi",
                "ubuso",
                "ubuso obunezinyembezi zentokozo",
                "uhleko",
            ],
        },
    ],
};
#[doc = "🙂"]
pub const SLIGHTLY_SMILING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🙂",
    codepoint: "1F642",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "slightly smiling face",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat effens glimlag"),
            keywords: &["gesig", "gesig wat effens glimlag", "glimlag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በትንሹ ሣቂታ ፊት"),
            keywords: &["ሣቅ", "በትንሹ ሣቂታ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بابتسامة بسيطة"),
            keywords: &["ابتسامة", "وجه", "وجه بابتسامة بسيطة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ল\u{9be}হেকৈ হ\u{9be}\u{981}হি থক\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ম\u{9c1}খ",
                "ল\u{9be}হেকৈ হ\u{9be}\u{981}হি থক\u{9be} ম\u{9c1}খ",
                "হ\u{9be}\u{981}হি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yüngülcə gülümsəyən üz"),
            keywords: &["təbəssüm", "yüngülcə gülümsəyən üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("злёгку ўсміхаецца"),
            keywords: &["злёгку ўсміхаецца", "усмешка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Леко усмихнато лице"),
            keywords: &["Леко усмихнато лице", "лице", "усмивка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খে স\u{9be}ম\u{9be}ন\u{9cd}য হ\u{9be}সি"),
            keywords: &[
                "ম\u{9c1}খ",
                "ম\u{9c1}খে স\u{9be}ম\u{9be}ন\u{9cd}য হ\u{9be}সি",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("diskretni osmijeh"),
            keywords: &["diskretni osmijeh", "lice", "osmijeh"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que somriu una mica"),
            keywords: &["cara", "cara que somriu una mica", "somriure tímid"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄃𑄬𑄇\u{11133}𑄦\u{11134} 𑄃𑄬𑄇\u{11133}𑄦\u{11134} 𑄦𑄏\u{11127}\u{11101} 𑄦𑄏\u{11127}\u{11101} 𑄟\u{1112a}",
            ),
            keywords: &[
                "𑄃𑄬𑄇\u{11133}𑄦\u{11134} 𑄃𑄬𑄇\u{11133}𑄦\u{11134} 𑄦𑄏\u{11127}\u{11101} 𑄦𑄏\u{11127}\u{11101} 𑄟\u{1112a}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏗᎩᏓ ᎤᏰᏓᏍᎬ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏰᏥᏍᎦ", "ᏍᏗᎩᏓ ᎤᏰᏓᏍᎬ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s mírným úsměvem"),
            keywords: &[
                "obličej s mírným úsměvem",
                "smajlík",
                "tvář",
                "výraz",
                "úsměv",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb ag ychydig o wên arni"),
            keywords: &["gwenu", "gwyneb", "wyneb ag ychydig o wên arni"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("let smilende ansigt"),
            keywords: &["ansigt", "let smilende ansigt", "smil"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("leicht lächelndes Gesicht"),
            keywords: &[
                "Gesicht",
                "Lächeln",
                "leicht lächelndes Gesicht",
                "lächelnd",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ελαφρώς χαμογελαστό πρόσωπο"),
            keywords: &["ελαφρώς χαμογελαστό πρόσωπο", "πρόσωπο", "χαμόγελο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("slightly smiling face"),
            keywords: &["face", "slightly smiling face", "smile"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo ligeramente"),
            keywords: &["cara", "cara sonriendo ligeramente", "sonrisa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara sonriendo levemente"),
            keywords: &[
                "cara",
                "cara sonriendo levemente",
                "leve sonrisa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo ligeramente"),
            keywords: &["cara", "cara sonriendo ligeramente", "sonrisa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo ligeramente"),
            keywords: &[
                "cara",
                "cara sonriendo levemente",
                "cara sonriendo ligeramente",
                "leve sonrisa",
                "sonrisa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naeratusega nägu"),
            keywords: &["naeratus", "naeratusega nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("apur bat irribarre egiten ari den aurpegia"),
            keywords: &[
                "apur bat irribarre egiten ari den aurpegia",
                "aurpegi",
                "irribarre",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لبخند ملایم"),
            keywords: &["صورت", "لبخند", "لبخند ملایم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pieni hymy"),
            keywords: &["hymy", "naama", "pieni hymy"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("medyo nakangiti"),
            keywords: &["medyo nakangiti", "mukha", "nakangiti", "ngiti"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit ið smílur eitt sindur"),
            keywords: &["andlit", "andlit ið smílur eitt sindur", "bros", "smíl"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec un léger sourire"),
            keywords: &["sourire", "visage avec un léger sourire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage avec un léger sourire"),
            keywords: &["sourire", "visage", "visage avec un léger sourire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag miongháire de bheagán"),
            keywords: &[
                "aghaidh",
                "miongháire",
                "straoiseog ag miongháire de bheagán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le fiamh gàire beag"),
            keywords: &["aodann", "aodann le fiamh gàire beag", "fiamh-ghàire"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara cun leve sorriso"),
            keywords: &["cara", "cara cun leve sorriso", "sorriso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સહ\u{ac7}જ સ\u{acd}મિત કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
                "સહ\u{ac7}જ સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "સ\u{acd}મિત",
                "હાસ\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi kaɗan"),
            keywords: &["fuska", "fuska mai murmushi kaɗan", "murmushi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם חיוך קטן"),
            keywords: &[
                "חיוך",
                "מחייך",
                "פרצוף",
                "פרצוף עם חיוך קטן",
                "פרצוף עם חיוך קל",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हल\u{94d}की म\u{941}स\u{94d}कान वाला च\u{947}हरा"),
            keywords: &[
                "धीर\u{947} स\u{947} ह\u{901}सता च\u{947}हरा",
                "स\u{94d}माइली",
                "हल\u{94d}की म\u{941}स\u{94d}कान वाला च\u{947}हरा",
                "हौल\u{947} स\u{947} म\u{941}स\u{94d}काना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("blago nasmiješeno lice"),
            keywords: &["blago nasmiješeno lice", "lice", "smiješak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("finoman mosolygó arc"),
            keywords: &["arc", "finoman mosolygó arc", "mosoly"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թեթևակի ժպտացող դեմք"),
            keywords: &["դեմք", "թեթևակի ժպտացող դեմք", "ժպիտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah agak tersenyum"),
            keywords: &["muka", "senyum", "wajah", "wajah agak tersenyum"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa obere ihu na-amụ amụ"),
            keywords: &["amụ", "ihu", "nwa obere ihu na-amụ amụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("milt bros"),
            keywords: &["andlit", "bros", "milt bros"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con sorriso accennato"),
            keywords: &[
                "faccina con sorriso accennato",
                "mezzo sorriso",
                "sorriso",
                "sorriso a bocca chiusa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("微笑む"),
            keywords: &["スマイル", "微笑み", "微笑む", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mesem"),
            keywords: &["mesem", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოდნავ მომღიმარე სახე"),
            keywords: &["ოდნავ მომღიმარე სახე", "სახე", "ღიმილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeh afessas"),
            keywords: &["acmumeh afessas"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жымию"),
            keywords: &["бет", "жымию"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("let smilende ansigt"),
            keywords: &["ansigt", "let smilende ansigt", "smil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខចេញស\u{17d2}នាមញញ\u{17b9}មបន\u{17d2}ត\u{17b7}ច"),
            keywords: &[
                "ញញ\u{17b9}ម",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខចេញស\u{17d2}នាមញញ\u{17b9}មបន\u{17d2}ត\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ವಲ\u{ccd}ಪ ನಗು ಮುಖ"),
            keywords: &["ನಗು", "ಮುಖ", "ಸ\u{ccd}ವಲ\u{ccd}ಪ ನಗು ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("살짝 미소 짓는 얼굴"),
            keywords: &["미소", "살짝 미소 짓는 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मात\u{94d}श\u{947}\u{902} हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "मात\u{94d}श\u{947}\u{902} हा\u{902}सपी च\u{947}रो",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күлүмсүрөгөн бет"),
            keywords: &["бет", "күлүмсүрө", "күлүмсүрөгөн бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat engem liichte Laachen"),
            keywords: &["Gesiicht", "Gesiicht mat engem liichte Laachen", "Laachen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມບາງໆ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມບາງໆ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šiek tiek besišypsantis veidas"),
            keywords: &["veidas", "šiek tiek besišypsantis veidas", "šypsena"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar vieglu smaidu"),
            keywords: &["seja", "seja ar vieglu smaidu", "smaids"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene iti"),
            keywords: &["kanohi", "kanohi menemene iti", "menemene"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со блага насмевка"),
            keywords: &[
                "блага",
                "лице",
                "лице со блага насмевка",
                "мала",
                "насмевка",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മന\u{d4d}ദഹസിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "ചിരി",
                "ചെറ\u{d41}ത\u{d3e}യ\u{d41}ള\u{d4d}ള മന\u{d4d}ദഹ\u{d3e}സം",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "മന\u{d4d}ദഹസിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മന\u{d4d}ദഹ\u{d3e}സം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бага зэрэг инээмсэглэсэн царай"),
            keywords: &[
                "бага зэрэг",
                "бага зэрэг инээмсэглэсэн царай",
                "инээмсэглэх",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}मित करणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "स\u{94d}मित करणारा च\u{947}हरा",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersenyum sedikit"),
            keywords: &["muka", "muka tersenyum sedikit", "senyum"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jitbissem ftit"),
            keywords: &["jitbissem", "wiċċ", "wiċċ jitbissem ftit"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မသ\u{102d}မသာ ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပြ\u{102f}\u{1036}းနေသည\u{103a}",
                "မသ\u{102d}မသာ ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မသ\u{102d}မသာပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smiler litt"),
            keywords: &["fjes", "smil", "smiler litt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हल\u{94d}का ह\u{901}सिलो अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "म\u{941}स\u{94d}कान",
                "हल\u{94d}का ह\u{901}सिलो अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("enigszins lachend gezicht"),
            keywords: &["enigszins lachend gezicht", "gezicht", "glimlach"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes som smiler litt"),
            keywords: &["fjes", "fjes som smiler litt", "smil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଟ\u{b3f}କେ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଟ\u{b3f}କେ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
                "ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a4b}ੜ\u{a4d}ਹਾ ਜਿਹਾ ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਥ\u{a4b}ੜ\u{a4d}ਹਾ ਜਿਹਾ ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਹਟ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہلکی مسکراندی ہوئی شکل"),
            keywords: &["دی شکل", "مسکرانا", "ہلکی مسکراندی ہوئی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smaílín Fes Wit Jẹ\u{301}ntúl Ai"),
            keywords: &[
                "Fes",
                "Fes wé De Láf Smọ\u{301}l Laf",
                "Hápí Laf",
                "Smaílín Fes Wit Jẹ\u{301}ntúl Ai",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lekko uśmiechnięta twarz"),
            keywords: &["buźka", "lekko uśmiechnięta twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لږ مسکېدلی مخ"),
            keywords: &["لږ مسکېدلی مخ", "مخ", "مسکا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto levemente sorridente"),
            keywords: &["rosto", "rosto levemente sorridente", "sorriso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir ligeiramente"),
            keywords: &["cara", "cara a sorrir ligeiramente", "sorriso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pisi kusisqa uya"),
            keywords: &["kusi", "pisi kusisqa uya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față ușor zâmbitoare"),
            keywords: &["față", "față ușor zâmbitoare", "zâmbet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-902"),
            keywords: &["E10-902"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("слегка улыбается"),
            keywords: &[
                "легкая улыбка",
                "лицо",
                "радость",
                "слегка улыбается",
                "улыбка",
                "хорошо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka gahoro"),
            keywords: &["inseko", "isura", "isura iseka gahoro"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هلڪو مسڪرائيندڙ چهرو"),
            keywords: &["مرڪ", "هلڪو مسڪرائيندڙ چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යන\u{dca}තම\u{dca} ස\u{dd2}න\u{dcf}වෙන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "යන\u{dca}තම\u{dca} ස\u{dd2}න\u{dcf}වෙන ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}නහව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("usmievajúca sa tvár"),
            keywords: &["tvár", "usmievajúca sa tvár", "úsmev"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rahlo smejoči obraz"),
            keywords: &["nasmeh", "obraz", "rahlo smejoči obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji yara dhoola cadeynaya"),
            keywords: &["dhoola cadeyn", "face", "waji yara dhoola cadeynaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë pak e qeshur"),
            keywords: &["buzëqesh", "buzëqeshje", "fytyrë", "fytyrë pak e qeshur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("благо насмејано лице"),
            keywords: &["благо насмејано лице", "лице", "осмех"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("благо насмијано лице"),
            keywords: &["благо насмијано лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("blago nasmejano lice"),
            keywords: &["blago nasmejano lice", "lice", "osmeh"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("blago nasmijano lice"),
            keywords: &["blago nasmijano lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("småleende ansikte"),
            keywords: &["ansikte", "leende", "ler", "småleende ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu kwa mbali"),
            keywords: &["tabasamu", "uso", "uso unaotabasamu kwa mbali"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லேச\u{bbe}கச\u{bcd} சிரித\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "சிரிப\u{bcd}பு",
                "முகம\u{bcd}",
                "லேச\u{bbe}கச\u{bcd} சிரித\u{bcd}த முகம\u{bcd}",
                "லேச\u{bbe}ன சிரிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}రునవ\u{c4d}వు నవ\u{c4d}వుతున\u{c4d}న ముఖం"),
            keywords: &[
                "చ\u{c3f}రునవ\u{c4d}వు నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "నవ\u{c4d}వు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тӯи каме хандон"),
            keywords: &["рӯй", "табассум", "тӯи каме хандон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าย\u{e34}\u{e49}มบางๆ"),
            keywords: &[
                "ย\u{e34}\u{e49}ม",
                "หน\u{e49}า",
                "หน\u{e49}าย\u{e34}\u{e49}มบางๆ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çalaja ýylgyrýan ýüz"),
            keywords: &["çalaja ýylgyrýan ýüz", "ýylgyrmak", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata kiʻi malimali"),
            keywords: &["mata kiʻi malimali"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hafifçe gülümseyen yüz"),
            keywords: &["gülme", "hafifçe gülümseyen yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىللىق خۇش چىراي"),
            keywords: &["ئىللىق خۇش چىراي", "كۈلۈمسىرەش", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трохи всміхнене обличчя"),
            keywords: &[
                "обличчя",
                "посмішка",
                "трохи всміхнене обличчя",
                "трохи усміхнене обличчя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مدھم مسکراہٹ والا چہرہ"),
            keywords: &["مدھم مسکراہٹ والا چہرہ", "مسکراہٹ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yengilgina kulayotgan yuz"),
            keywords: &["tabassum", "yengilgina kulayotgan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười mỉm"),
            keywords: &["cười", "mặt", "mặt cười mỉm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu muuñ tuuti"),
            keywords: &["kanam", "kanam gu muuñ tuuti", "muuñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo kancinane"),
            keywords: &["ncuma", "ubuso", "ubuso obuncumileyo kancinane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti O N Rẹrin Muṣẹn"),
            keywords: &["Oju Ti O N Rẹrin Muṣẹn", "ojú", "rẹ\u{301}rín músẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("咪咪笑嘅臉"),
            keywords: &["咪咪笑嘅臉", "微笑", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("咪咪笑嘅脸"),
            keywords: &["咪咪笑嘅脸", "微笑", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("呵呵"),
            keywords: &["呵呵", "开心", "笑", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("呆呆笑"),
            keywords: &["呆呆笑", "笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("稍為微笑嘅表情"),
            keywords: &["稍為微笑嘅表情", "笑面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizela kancane"),
            keywords: &["moyizela", "ubuso", "ubuso obumoyizela kancane"],
        },
    ],
};
#[doc = "🙃"]
pub const UPSIDE_DOWN_FACE: crate::Emoji = crate::Emoji {
    glyph: "🙃",
    codepoint: "1F643",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "upside-down face",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("onderstebo gesig"),
            keywords: &["gesig", "onderstebo"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተገለበጠ ፊት"),
            keywords: &["የተገለበጠ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مقلوب"),
            keywords: &["مقلوب", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ওলোট\u{9be} ম\u{9c1}খ"),
            keywords: &["ওলোট\u{9be}", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("başı-aşağı üz"),
            keywords: &["baş-aşağı", "başı-aşağı üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дагары нагамі"),
            keywords: &["дагары нагамі", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Обърнато наобратно лице"),
            keywords: &["Обърнато наобратно лице", "лице", "наобратно"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}থ\u{9be}ট\u{9be} নিচে তল\u{9be}ট\u{9be} উপরে এমন ম\u{9c1}খ"),
            keywords: &[
                "ওল\u{9cd}ট\u{9be}নো চেহ\u{9be}র\u{9be}",
                "ম\u{9be}থ\u{9be}ট\u{9be} নিচে তল\u{9be}ট\u{9be} উপরে এমন ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("naglavačke"),
            keywords: &["lice", "naglavačke", "obrnuto"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de cap per avall"),
            keywords: &["cara", "cara de cap per avall", "revés"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏁᏍᏈᏛᏅ-ᎡᎳᏗᏜ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᏗᏁᏍᏈᏛᏅ-ᎡᎳᏗᏜ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("převrácený obličej"),
            keywords: &[
                "převrácený obličej",
                "smajlík",
                "tvář",
                "vzhůru nohama",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â’i ben i waered"),
            keywords: &["ben i waered", "wyneb", "wyneb â’i ben i waered"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("omvendt ansigt"),
            keywords: &["ansigt", "omvendt", "på hovedet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("umgekehrtes Gesicht"),
            keywords: &["Gesicht", "auf dem Kopf stehen", "umgekehrtes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αναποδογυρισμένο πρόσωπο"),
            keywords: &["ανάποδο", "αναποδογυρισμένο πρόσωπο", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("upside-down face"),
            keywords: &["face", "upside-down"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["face", "upside down", "upside-down face"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara al revés"),
            keywords: &["cara", "cara al revés", "revés"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tagurpidi nägu"),
            keywords: &["nägu", "tagurpidi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("buruz behera dagoen aurpegia"),
            keywords: &["aurpegi", "buruz behera", "buruz behera dagoen aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت وارونه"),
            keywords: &["صورت", "لبخند", "معکوس", "وارونه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ylösalainen naama"),
            keywords: &["naama", "väärinpäin", "ylösalainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baligtad na mukha"),
            keywords: &["baligtad", "baligtad na mukha", "mukha"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit ið vendur á høvdinum"),
            keywords: &["andlit", "andlit ið vendur á høvdinum", "upp og niður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tête à l’envers"),
            keywords: &["renversée", "tête", "tête à l’envers"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage à l’envers"),
            keywords: &["renversé", "visage", "visage à l’envers", "à l’envers"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog bun os cionn"),
            keywords: &["aghaidh", "bonn os cionn", "straoiseog bun os cionn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann bun os cionn"),
            keywords: &["aodann", "aodann bun os cionn", "bun os cionn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara ao revés"),
            keywords: &["cara", "cara ao revés", "revés"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઊ\u{a82}ધો ચહ\u{ac7}રો"),
            keywords: &["ઊ\u{a82}ધો", "ચહ\u{ac7}રો", "મ\u{ac1}ખ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska a birkice"),
            keywords: &["a birkice", "fuska", "fuska a birkice"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף הפוך"),
            keywords: &["הפוך", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उल\u{94d}टा च\u{947}हरा"),
            keywords: &["उल\u{94d}टा च\u{947}हरा", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("naopačke okrenuto lice"),
            keywords: &["gore-dolje", "lice", "naopačke okrenuto lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fejjel lefelé fordult arc"),
            keywords: &["arc", "fejjel lefelé", "fejjel lefelé fordult arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գլխիվայր դեմք"),
            keywords: &["գլխիվայր", "դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah terbalik"),
            keywords: &["muka", "terbalik", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nsụgharị-isi n’ala"),
            keywords: &["ihu", "ihu nsụgharị-isi n’ala", "nsụgharị-isi n’ala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit á hvolfi"),
            keywords: &["andlit", "andlit á hvolfi", "á hvolfi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina sottosopra"),
            keywords: &["capovolta", "faccina", "scombussolata", "sottosopra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("さかさまの顔"),
            keywords: &["さかさま", "さかさまの顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kuwalik"),
            keywords: &["kuwalik", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ამოტრიალებული სახე"),
            keywords: &["ამოტრიალებული", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мысқыл"),
            keywords: &["бет", "мысқыл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("omvendt ansigt"),
            keywords: &["ansigt", "omvendt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខញញ\u{17b9}មបញ\u{17d2}រ\u{17d2}ចាស"),
            keywords: &[
                "ញញ\u{17b9}ម",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខញញ\u{17b9}មបញ\u{17d2}រ\u{17d2}ចាស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಲ\u{cc6}ಕ\u{cc6}ಳಗಾದ ಮುಖ"),
            keywords: &["ತಲ\u{cc6}ಕ\u{cc6}ಳಗಾದ ಮುಖ", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거꾸로 된 얼굴"),
            keywords: &["거꾸로 된 얼굴", "뒤집힘", "얼굴", "위아래"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तकली सकयल आसपी च\u{947}रो"),
            keywords: &["च\u{947}रो", "तकली सकयल आसपी च\u{947}रो", "सकयल तकली"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башын ылдый каратып турган бет"),
            keywords: &["башын ылдый", "башын ылдый каратып турган бет", "бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("op der Kopp"),
            keywords: &["Gesiicht", "op der Kopp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າປ\u{eb5}\u{ec9}ນຫ\u{ebb}ວ"),
            keywords: &[
                "ປ\u{eb5}\u{ec9}ນຫ\u{ebb}ວ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າປ\u{eb5}\u{ec9}ນຫ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apverstas veidas"),
            keywords: &["apverstas veidas", "aukštyn kojom", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("apgriezta seja"),
            keywords: &["apgriezta seja", "apgriezts", "otrādi", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi huripoki"),
            keywords: &["huripoki", "kanohi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("превртено лице"),
            keywords: &["лице", "наопаку", "превртено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലകീഴ\u{d3e}യി നിൽക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "തലകീഴ\u{d3e}യത\u{d4d}",
                "തലകീഴ\u{d3e}യി നിൽക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("доошоо харсан царай"),
            keywords: &["доошоо харсан царай", "уруу харсан царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उलटा च\u{947}हरा"),
            keywords: &[
                "उलटा च\u{947}हरा",
                "च\u{947}हरा",
                "वरील बाज\u{942} खाली",
                "वरील बाज\u{942} खाली असल\u{947}ला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka terbalik"),
            keywords: &["muka", "terbalik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ ta’ taħt fuq"),
            keywords: &["ta’ taħt fuq", "wiċċ", "wiċċ ta’ taħt fuq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဇောက\u{103a}ထ\u{102d}\u{102f}း မျက\u{103a}န\u{103e}ာ"),
            keywords: &["ဇောက\u{103a}ထ\u{102d}\u{102f}း", "မျက\u{103a}န\u{103e}ာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes som er opp-ned"),
            keywords: &["fjes", "fjes som er opp-ned", "opp-ned"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि-तल भएको अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "माथि-तल भएको", "माथि-तल भएको अन\u{941}हार"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("omgekeerd gezicht"),
            keywords: &["gezicht", "omgekeerd gezicht", "ondersteboven", "op de kop"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes som er opp-ned"),
            keywords: &["fjes", "fjes som er opp-ned", "opp-ned"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଓଲଟ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &["ଓଲଟ\u{b3e}", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}ਰਖ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਬ\u{a47}ਸਮਝ ਚਿਹਰਾ",
                "ਬ\u{a47}ਹ\u{a42}ਦਗੀ",
                "ਮ\u{a42}ਰਖ ਚਿਹਰਾ",
                "ਮ\u{a42}ਰਖਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پ\u{64f}ٹھی شکل"),
            keywords: &["دی شکل", "پ\u{64f}ٹھا", "پ\u{64f}ٹھی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}psaíd-daún Fes"),
            keywords: &["Fes", "Ọ\u{301}psaíd-daún"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("odwrócona twarz"),
            keywords: &["do góry nogami", "odwrócona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نسکور مخ"),
            keywords: &["مخ", "نسکور"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto de cabeça para baixo"),
            keywords: &["rosto de cabeça para baixo", "rosto invertido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara ao contrário"),
            keywords: &["ao contrário", "cara", "cara ao contrário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tikrasqa uya"),
            keywords: &["tikrasqa", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu susul în jos"),
            keywords: &["față", "față cu susul în jos", "răsturnat", "întors"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-903"),
            keywords: &["E10-903"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вверх тормашками"),
            keywords: &[
                "вверх",
                "вверх тормашками",
                "лицо",
                "ногами",
                "перевернутое",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura-icuritse"),
            keywords: &["icuritse", "isura", "isura-icuritse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ابتو چهرو"),
            keywords: &["ابتو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("යට\u{dd2}ක\u{dd4}ර\u{dd4} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "උඩ\u{dd4} යට\u{dd2}ක\u{dd4}ර\u{dd4}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "යට\u{dd2}ක\u{dd4}ර\u{dd4} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prevrátená tvár"),
            keywords: &["otočená", "prevrátená", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("na glavo obrnjen obraz"),
            keywords: &["na glavo obrnjen obraz", "narobe obrnjeno", "obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji hoos-hoos u raaraca"),
            keywords: &["hoos u foorara", "waji", "waji hoos-hoos u raaraca"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë përmbys"),
            keywords: &["fytyrë", "përmbys"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице окренуто наопако"),
            keywords: &["лице", "лице окренуто наопако", "окренуто наопако"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице окренуто наопако"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice okrenuto naopako"),
            keywords: &["lice", "lice okrenuto naopako", "okrenuto naopako"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice okrenuto naopako"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("upp-och-nervänt ansikte"),
            keywords: &["ansikte", "upp-och-ner", "upp-och-nervänt ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliogeuzwa juu chini"),
            keywords: &["kugeuzwa juu chini", "uso", "uso uliogeuzwa juu chini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தலைக\u{bc0}ழ\u{bcd} முகம\u{bcd}"),
            keywords: &["தலைக\u{bc0}ழ\u{bcd}", "முகம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తలక\u{c4d}ర\u{c3f}ందులుగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "తల",
                "తలక\u{c4d}ర\u{c3f}ందులుగ\u{c3e} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи сарчаппа"),
            keywords: &["Рӯй", "рӯи сарчаппа", "сарчаппа"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}ากล\u{e31}บห\u{e31}ว"),
            keywords: &[
                "กล\u{e31}บห\u{e31}ว",
                "หน\u{e49}า",
                "หน\u{e49}ากล\u{e31}บห\u{e31}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dik başaşak ýüz"),
            keywords: &["başaşak", "dik başaşak ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fulihi"),
            keywords: &["mata fulihi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ters yüz"),
            keywords: &["ters yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دۈم چىراي"),
            keywords: &["دۈم", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя догори дриґом"),
            keywords: &[
                "догори ногами",
                "обличчя",
                "обличчя догори дном",
                "обличчя догори дриґом",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("الٹا چہرہ"),
            keywords: &["الٹآ", "الٹا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘ntarilgan yuz"),
            keywords: &["to‘ntarilgan", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt lộn ngược"),
            keywords: &["lộn ngược", "mặt", "mặt lộn ngược"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu dëppu"),
            keywords: &["buñ juutal", "kanam", "kanam gu dëppu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuphethukileyo"),
            keywords: &["ubuso", "ubuso obuphethukileyo", "ukuphethuka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti O Rọ walẹ"),
            keywords: &["Oju Ti O Rọ walẹ", "dojú kodò", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("上下倒轉嘅臉"),
            keywords: &["上下倒轉", "上下倒轉嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("上下倒转嘅脸"),
            keywords: &["上下倒转", "上下倒转嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("倒脸"),
            keywords: &["倒脸", "脸", "颠倒", "颠倒的脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("顛倒臉"),
            keywords: &["臉上下顛倒", "顛倒臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("顛倒臉"),
            keywords: &["臉上下顛倒", "顛倒臉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obupheke phansi"),
            keywords: &["ubuso", "ubuso obupheke phansi", "ukubheka phansi"],
        },
    ],
};
#[doc = "😉"]
pub const WINKING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😉",
    codepoint: "1F609",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "winking face",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat knipoog"),
            keywords: &["gesig", "gesig wat knipoog", "knipoog"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚጣቀስ ፊት"),
            keywords: &["የሚጣቀስ ፊት", "ጠቀሳ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يغمز"),
            keywords: &["غمزة", "وجه يغمز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিৎক\u{9be}ৰ কৰ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "চিৎক\u{9be}ৰ",
                "চিৎক\u{9be}ৰ কৰ\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göz vuran üz"),
            keywords: &["göz vuran üz", "göz vurmaq", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("падморгвае"),
            keywords: &["падморгвае", "падморгванне", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Намигащо лице"),
            keywords: &["Намигащо лице", "лице", "намигване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখ ম\u{9be}র\u{9be}"),
            keywords: &["চোখ ম\u{9be}র\u{9be}", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("namigivanje"),
            keywords: &["lice", "mig", "namigivanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que pica l’ullet"),
            keywords: &["cara", "cara que pica l’ullet", "ullet"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎦᏔᏁ ᎠᎦᏙᎵ"),
            keywords: &["ᎠᎦᏔᎾᏫᏍᎦ", "ᎠᏓᎦᏔᏁ ᎠᎦᏙᎵ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mrkající obličej"),
            keywords: &["mrkající obličej", "mrknutí", "smajlík", "tvář", "výraz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llygaid yn wincio"),
            keywords: &["llygaid yn wincio", "winc", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blinkende ansigt"),
            keywords: &["ansigt", "ansigt der blinker", "blink", "blinkende ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zwinkerndes Gesicht"),
            keywords: &["Gesicht", "Zwinkern", "zwinkerndes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλείσιμο ματιού"),
            keywords: &["κλείνω το μάτι", "κλείσιμο ματιού", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("winking face"),
            keywords: &["face", "wink", "winking face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara guiñando el ojo"),
            keywords: &["cara", "cara guiñando el ojo", "guiño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara con guiño"),
            keywords: &["cara", "cara con guiño", "guiño"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara guiñando el ojo"),
            keywords: &["cara", "cara guiñando el ojo", "guiño"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara guiñando el ojo"),
            keywords: &["cara", "cara guiñando el ojo", "guiño"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("silma pilgutav nägu"),
            keywords: &["nägu", "silma pilgutav nägu", "silmapilgutus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begiaz keinu egiten ari den aurpegia"),
            keywords: &["aurpegi", "begiaz keinu egiten ari den aurpegia", "keinu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چشمک"),
            keywords: &["صورت", "چشمک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silmänisku"),
            keywords: &[
                "flirtti",
                "huumori",
                "kasvot",
                "naama",
                "salaisuus",
                "silmä",
                "silmänisku",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kumikindat"),
            keywords: &["kindat", "kumikindat", "mukha"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við blunkandi eyga"),
            keywords: &["andlit", "andlit við blunkandi eyga", "blunk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage faisant un clin d’œil"),
            keywords: &["clin d’œil", "visage", "visage faisant un clin d’œil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage clignant d’un œil"),
            keywords: &["clin d’œil", "visage", "visage clignant d’un œil"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag caochadh"),
            keywords: &["aghaidh", "caochadh", "straoiseog ag caochadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le sùil bheag"),
            keywords: &["aodann", "aodann le sùil bheag", "priobadh", "sùil bheag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara chiscando un ollo"),
            keywords: &["cara", "cara chiscando un ollo", "chiscadela", "ollo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આ\u{a82}ખ મારતો ચહ\u{ac7}રો"),
            keywords: &[
                "આ\u{a82}ખ મારતો ચહ\u{ac7}રો",
                "આ\u{a82}ખ મારવી",
                "ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai yin ƙifta"),
            keywords: &["fuska", "fuska mai yin ƙifta", "yi ƙifta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף קורץ"),
            keywords: &["פרצוף", "קורץ", "קריצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आ\u{901}ख मारता च\u{947}हरा"),
            keywords: &[
                "आ\u{901}ख मारता च\u{947}हरा",
                "आ\u{902}ख मारना",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje namiguje"),
            keywords: &["lice", "lice koje namiguje", "namigivanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kacsintó arc"),
            keywords: &["arc", "kacsintás", "kacsintó arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աչքով անող դեմք"),
            keywords: &["աչքով անել", "աչքով անող դեմք", "դեմք"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("visage que batte le palpebras"),
            keywords: &[
                "batter",
                "facie",
                "palpebras",
                "visage",
                "visage que batte le palpebras",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah berkedip"),
            keywords: &["kedip", "muka", "wajah", "wajah berkedip"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ihu na-atabi anya"),
            keywords: &["Ihu na-atabi anya", "ihu", "ntabiri anya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blikkandi andlit"),
            keywords: &["andlit", "blikk", "blikkandi andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che fa l’occhiolino"),
            keywords: &[
                "faccina",
                "faccina che fa l’occhiolino",
                "fare l’occhiolino",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ウインク"),
            keywords: &["ウィンク", "ウインク", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngedhèpi"),
            keywords: &["kedhèp", "rai", "rai ngedhèpi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე ჩაკრული თვალით"),
            keywords: &["სახე", "სახე ჩაკრული თვალით", "ჩაკვრა", "ჩაპაჭუნება"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem yemmalen aɣmaz n ti"),
            keywords: &["udem yemmalen aɣmaz n ti"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көз қысу"),
            keywords: &["бет", "көз қысу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blinkende ansigt"),
            keywords: &["ansigt", "ansigt der blinker", "blink", "blinkende ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខញាក\u{17cb}ភ\u{17d2}នែក"),
            keywords: &[
                "ញាក\u{17cb}ភ\u{17d2}នែក",
                "ភ\u{17d2}នែក",
                "ម\u{17b7}ចភ\u{17d2}នែក",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខញាក\u{17cb}ភ\u{17d2}នែក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಣ\u{ccd}ಣು ಮ\u{cbf}ಟುಕ\u{cbf}ಸುವ ಮುಖ"),
            keywords: &[
                "ಕಣ\u{ccd}ಣು ಮ\u{cbf}ಟುಕ\u{cbf}ಸುವ ಮುಖ",
                "ಮ\u{cbf}ಟುಕ\u{cbf}ಸು",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("윙크하는 얼굴"),
            keywords: &["얼굴", "윙크", "윙크하는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोळ\u{947} मिचकावपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "दोळ\u{947} मिचकावप",
                "दोळ\u{947} मिचकावपी च\u{947}रो",
                "मिचकावप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көзүн кыскан бет"),
            keywords: &["бет", "көз кыс", "көзүн кыскан бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("A zoudréckend"),
            keywords: &["A zoudrécken", "A zoudréckend", "Gesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}ບຕາ"),
            keywords: &[
                "ຍ\u{eb4}ບຕາ",
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຮ\u{eb4}ຮ\u{eb4}",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}ບຕາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mirksintis veidas"),
            keywords: &["mirksintis veidas", "mirktelėjimas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar piemiegtu aci"),
            keywords: &[
                "acs",
                "miegt",
                "mirkšķināt",
                "seja",
                "seja ar piemiegtu aci",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi kimokimo"),
            keywords: &["kanohi", "kanohi kimokimo", "kimo"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице што намигнува"),
            keywords: &["лице", "лице што намигнува", "намигнување"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കണ\u{d4d}ണിറ\u{d41}ക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "കണ\u{d4d}ണടിക\u{d4d}കൽ",
                "കണ\u{d4d}ണിറ\u{d41}ക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ирмэж байгаа царай"),
            keywords: &["ирмэж байгаа царай", "ирмэх", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("एक डोळा मिचकावणारा च\u{947}हरा"),
            keywords: &[
                "एक डोळा मिचकावणारा च\u{947}हरा",
                "च\u{947}हरा",
                "डोळ\u{947} मिचकावण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka kenyit mata"),
            keywords: &["kenyit mata", "muka", "muka kenyit mata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jehmeż"),
            keywords: &["hemeż", "wiċċ", "wiċċ jehmeż"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}စ\u{102d}မ\u{103e}\u{102d}တ\u{103a}ပြနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}စ\u{102d}မ\u{103e}\u{102d}တ\u{103a}ပြခြင\u{103a}း",
                "မျက\u{103a}စ\u{102d}မ\u{103e}\u{102d}တ\u{103a}ပြနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blunkende ansikt"),
            keywords: &["blunk", "blunkende ansikt", "fjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आ\u{901}खा झिम\u{94d}काइएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}खा झिम\u{94d}काइएको अन\u{941}हार",
                "आ\u{901}खा झिम\u{94d}काएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("knipogend gezicht"),
            keywords: &["gezicht", "knipogend gezicht", "knipoog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blunkande fjes"),
            keywords: &["blunk", "blunkande fjes", "fjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଖ\u{b3f} ଠ\u{b3e}ର ମ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆଖ\u{b3f} ଠ\u{b3e}ର ମ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ଆଖ\u{b3f} ମ\u{b3e}ର\u{b3f}ବ\u{b3e}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਖ ਮਟਕਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਅ\u{a71}ਖ ਮਟਕਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਝਪਕਣਾ",
                "ਮਟਕਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اکھ مار دی شکل"),
            keywords: &["اکھ مار دی شکل", "اکھ مارنا", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Klóz Wọ\u{301}n Ai"),
            keywords: &[
                "Fes",
                "Fes Wé Klóz Wọ\u{301}n Ai",
                "Ópún An Klóz Wọ\u{301}n Ai Kwíkkwik",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz puszczająca oko"),
            keywords: &["puszczać oko", "twarz puszczająca oko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سترګه وهونکی مخ"),
            keywords: &["سترګه وهل", "سترګه وهونکی مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com olho piscando"),
            keywords: &["piscada", "rosto", "rosto com olho piscando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a piscar o olho"),
            keywords: &["cara", "cara a piscar o olho", "piscadela"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼirmi uya"),
            keywords: &["chʼirmi", "chʼirmi ya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față care face cu ochiul"),
            keywords: &["față", "față care face cu ochiul", "semn cu ochiul"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-845"),
            keywords: &["E10-845"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("подмигивает"),
            keywords: &[
                "глаз",
                "лицо",
                "мигать",
                "подмигивает",
                "подмигивать",
                "прищур",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yica akajisho"),
            keywords: &["isura", "isura yica akajisho", "kwica ijisho"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اک هڻڻ"),
            keywords: &["اک هڻڻ", "چهرو، اک هڻڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇස\u{dca} ගසන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ඇස\u{dca} ගසන ම\u{dd4}හ\u{dd4}ණ",
                "ඇස\u{dca} ගැස\u{dd3}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žmurkajúca tvár"),
            keywords: &["tvár", "žmurkajúca tvár", "žmurkanie", "žmurknutie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s pomežikom"),
            keywords: &["obraz", "obraz s pomežikom", "pomežik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji il jabinaaya"),
            keywords: &["face", "il jibis", "waji il jabinaaya", "waji il jibinaaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që shkel syrin"),
            keywords: &["fytyrë", "fytyrë që shkel syrin", "shkel syrin"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које намигује"),
            keywords: &["лице", "лице које намигује", "нaмигивaњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje namiguje"),
            keywords: &["lice", "lice koje namiguje", "namigivanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte som blinkar med ögonen"),
            keywords: &[
                "ansikte som blinkar med ögonen",
                "blinkar med ögonen",
                "blinkning",
                "flört",
                "skämt",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaokonyeza"),
            keywords: &["konyeza", "uso", "uso unaokonyeza"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}ணடிக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கண\u{bcd}ணடிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "கண\u{bcd}ணடித\u{bcd}தல\u{bcd}",
                "கிண\u{bcd}டல\u{bcd}",
                "புன\u{bcd}னகை",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కన\u{c4d}ను క\u{c4a}డుతున\u{c4d}న ముఖం"),
            keywords: &[
                "కన\u{c4d}ను",
                "కన\u{c4d}ను క\u{c4a}డుతున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи чашмакзананда"),
            keywords: &["рӯи чашмакзананда", "рӯй", "чашмакзанӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขย\u{e34}บตา"),
            keywords: &["ขย\u{e34}บตา", "ย\u{e34}\u{e49}ม", "หน\u{e49}าขย\u{e34}บตา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("göz gypýan ýüz"),
            keywords: &["göz gypmak", "göz gypýan ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fakakuitaha"),
            keywords: &["mata fakakuitaha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("göz kırpan yüz"),
            keywords: &["göz kırpan yüz", "göz kırpma", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆز قىسىش"),
            keywords: &["قىسىش", "كۆز قىسىش", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що підморгує"),
            keywords: &["обличчя", "обличчя, що підморгує", "підморгування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آنکھ مارتا چہرہ"),
            keywords: &["آنکھ جھپکنا", "آنکھ مارتا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘z qisish"),
            keywords: &["ko‘z qisish", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt nháy mắt"),
            keywords: &["mặt", "mặt nháy mắt", "nháy mắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("piis benn bët"),
            keywords: &["kanam", "piis", "piis benn bët"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuqoba iliso"),
            keywords: &["qoba iliso", "ubuso", "ubuso obuqoba iliso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó ṣẹ\u{301}jù"),
            keywords: &["Ojú tó ṣẹ\u{301}jù", "ojú", "ṣẹ\u{301}jú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("眨眼嘅臉"),
            keywords: &["眨眼", "眨眼嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("眨眼嘅脸"),
            keywords: &["眨眼", "眨眼嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("眨眼"),
            keywords: &["媚眼", "眨眼", "笑"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("眨眼"),
            keywords: &["眨眼", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("眨眼笑嘅表情"),
            keywords: &["眨眼笑嘅表情", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obucishe ihlo"),
            keywords: &["cisha ihlo", "ubuso", "ubuso obucishe ihlo"],
        },
    ],
};
#[doc = "😊"]
pub const SMILING_FACE_WITH_SMILING_EYES: crate::Emoji = crate::Emoji {
    glyph: "😊",
    codepoint: "1F60A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "smiling face with smiling eyes",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("glimlaggende gesig met glimlaggende oë"),
            keywords: &[
                "bloos",
                "gesig",
                "glimlag",
                "glimlaggende gesig met glimlaggende oë",
                "oog",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሣቂታ ዓይኖች ያሉት ሣቂታ ፊት"),
            keywords: &["ሣቂታ ዓይኖች ያሉት ሣቂታ ፊት", "ሣቅ", "ዓይን", "ዕፍረት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه باسم بعينين باسمتين"),
            keywords: &[
                "أعين مبتسمة",
                "ابتسامة وجه وأعين",
                "وجه باسم بعينين باسمتين",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}স\u{9cd}যম\u{9c1}খী চক\u{9c1}ৰে হ\u{9be}স\u{9cd}য ম\u{9c1}খ"),
            keywords: &[
                "চক\u{9c1}",
                "ম\u{9c1}খ",
                "ল\u{9be}জত ৰঙ\u{9be} পৰ\u{9be}",
                "হ\u{9be}\u{981}হি",
                "হ\u{9be}স\u{9cd}যম\u{9c1}খী চক\u{9c1}ৰে হ\u{9be}স\u{9cd}য ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gülən gözlərlə gülümsəyən üz"),
            keywords: &[
                "göz",
                "gülən gözlərlə gülümsəyən üz",
                "təbəssüm",
                "utanma",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("усміхаецца, прыплюшчыўшы вочы"),
            keywords: &[
                "вочы",
                "румянец",
                "усмешка",
                "усміхаецца, прыплюшчыўшы вочы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Усмихнато лице с усмихнати очи"),
            keywords: &[
                "Усмихнато лице с усмихнати очи",
                "изчервяване",
                "лице",
                "око",
                "усмивка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি"),
            keywords: &[
                "গ\u{9be}লে লজ\u{9cd}জ\u{9be}র গোল\u{9be}পী আভ\u{9be}",
                "চোখ",
                "চোখে হ\u{9be}সির স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি",
                "ম\u{9c1}খ",
                "হ\u{9be}সি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("širok osmijeh"),
            keywords: &["lice", "oko", "osmijeh", "rumen", "širok osmijeh"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara somrient amb els ulls alegres"),
            keywords: &[
                "cara",
                "cara somrient amb els ulls alegres",
                "galtes vermelles",
                "somriure",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏰᏗᏍᎩ ᎤᎧᏔ Ꮎ ᏧᏰᏗᏍᎩ ᏗᎦᏙᎵ"),
            keywords: &[
                "ᎠᎦᏘ",
                "ᎤᎧᏛ",
                "ᎤᏤᏣᏍᏗ",
                "ᎤᏰᏗᏍᎩ ᎤᎧᏔ Ꮎ ᏧᏰᏗᏍᎩ ᏗᎦᏙᎵ",
                "ᎩᎦᎨ ᏂᎦᎵᏍᏗᎲᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("smějící se obličej s usměvavýma očima"),
            keywords: &[
                "oko",
                "ruměnec",
                "smajlík",
                "smějící se obličej s usměvavýma očima",
                "tvář",
                "výraz",
                "zardění",
                "úsměv",
                "červenání",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â gwên yn y llygaid"),
            keywords: &[
                "cochi",
                "gwenu",
                "llygad",
                "wyneb",
                "wyneb yn gwenu â gwên yn y llygaid",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("smilende ansigt og øjne"),
            keywords: &["smil med smileøjne", "smilende ansigt og øjne", "smileøjne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lächelndes Gesicht mit lachenden Augen"),
            keywords: &[
                "Freude",
                "Gesicht",
                "erröten",
                "lächelndes Gesicht mit lachenden Augen",
                "rote Wangen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαμογελαστό πρόσωπο\u{a0}με γελαστά μάτια"),
            keywords: &[
                "κοκκινίζω",
                "μάτι",
                "πρόσωπο",
                "χαμογελαστό πρόσωπο\u{a0}με γελαστά μάτια",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("smiling face with smiling eyes"),
            keywords: &[
                "blush",
                "eye",
                "face",
                "smile",
                "smiling face with smiling eyes",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara feliz con ojos sonrientes"),
            keywords: &[
                "cara",
                "cara feliz con ojos sonrientes",
                "ojo",
                "rubor",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara alegre"),
            keywords: &["cara", "cara alegre", "ojos sonrientes", "sonrisa"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara feliz con ojos sonrientes"),
            keywords: &[
                "cara",
                "cara feliz con ojos sonrientes",
                "ojos sonrientes",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara feliz con ojos sonrientes"),
            keywords: &[
                "cara",
                "cara feliz con ojos sonrientes",
                "ojos sonrientes",
                "sonrisa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naeratavate silmadega naerunägu"),
            keywords: &[
                "naeratavate silmadega naerunägu",
                "naeratus",
                "nägu",
                "punastamine",
                "silm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begiez irribarre egiten ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "begi",
                "begiez irribarre egiten ari den aurpegia",
                "gorritu",
                "irribarre",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لبخند خجالتی"),
            keywords: &["خجالت", "سرخ شدن", "صورت", "لبخند", "لبخند خجالتی", "چشم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punastunut hymy"),
            keywords: &["hymy", "naama", "punastunut", "silmä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangiti kasama ang mga mata"),
            keywords: &[
                "blush",
                "masaya",
                "mata",
                "mukha",
                "nakangiti",
                "nakangiti kasama ang mga mata",
                "ngiti",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brosandi andlit við brosandi eygum"),
            keywords: &[
                "andlit",
                "bros",
                "brosandi andlit við brosandi eygum",
                "eyga",
                "rodna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage souriant avec yeux rieurs"),
            keywords: &[
                "rougir",
                "sourire",
                "visage",
                "visage souriant avec yeux rieurs",
                "œil",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage souriant les yeux plissés"),
            keywords: &[
                "rougir",
                "sourire",
                "visage",
                "visage souriant les yeux plissés",
                "œil",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog aoibhiúil le súile le miongháire"),
            keywords: &[
                "meangadh gáire",
                "straoiseog ag gáire le súile ag déanamh miongháire",
                "straoiseog aoibhiúil le súile ag déanamh miongháire",
                "straoiseog aoibhiúil le súile le miongháire",
                "súile ag gáire",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire agus sùilean toilichte"),
            keywords: &[
                "aodann",
                "aodann le gàire agus sùilean toilichte",
                "fiamh-ghàire",
                "ruadhadh",
                "sùil",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara alegre con ollos riseiros"),
            keywords: &[
                "alegre",
                "cara alegre con ollos riseiros",
                "ollos",
                "sorriso",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હસ\u{acd}તી આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "હસતી આ\u{a82}ખો",
                "હસતો ચહ\u{ac7}રો",
                "હસતો ચહ\u{ac7}રો અન\u{ac7} આ\u{a82}ખો",
                "હસ\u{acd}તી આ\u{a82}ખો સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "હાસ\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da idanu mai murmushi"),
            keywords: &[
                "fuska",
                "fuska mai murmushi tare da idanu mai murmushi",
                "ido",
                "ji kunya",
                "murmushi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחייך עם עיניים מחייכות"),
            keywords: &[
                "חיוך",
                "מסמיק",
                "פרצוף מחייך עם עיניים מחייכות",
                "פרצוף שמח",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "म\u{941}स\u{94d}काती आ\u{901}खो\u{902} वाला म\u{941}स\u{94d}काता च\u{947}हरा",
            ),
            keywords: &[
                "म\u{941}स\u{94d}काता च\u{947}हरा",
                "म\u{941}स\u{94d}काता च\u{947}हरा और आ\u{902}ख\u{947}\u{902}",
                "म\u{941}स\u{94d}काती आ\u{901}खो\u{902} वाला म\u{941}स\u{94d}काता च\u{947}हरा",
                "म\u{941}स\u{94d}काती आ\u{902}ख\u{947}\u{902}",
                "म\u{941}स\u{94d}कान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmiješeno lice s nasmiješenim očima"),
            keywords: &[
                "lice",
                "nasmiješeno lice s nasmiješenim očima",
                "oči",
                "rumeno",
                "smiješak",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mosolygó arc mosolygó szemmel"),
            keywords: &[
                "elpirul",
                "elvörösödik",
                "mosoly",
                "mosolygó arc mosolygó szemmel",
                "vidám szemek",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժպտացող դեմք ժպտացող աչքերով"),
            keywords: &[
                "աչք",
                "դեմք",
                "ժպիտ",
                "ժպտացող դեմք ժպտացող աչքերով",
                "շիկնել",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("surriso con oculos surridente"),
            keywords: &[
                "facie",
                "rubescer",
                "rubor",
                "surridente",
                "surriso con oculos surridente",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersenyum dengan mata bahagia"),
            keywords: &[
                "mata",
                "muka",
                "senyum",
                "tersipu",
                "wajah",
                "wajah tersenyum dengan mata bahagia",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu amụ nwere anya amụ"),
            keywords: &["amụ", "anya", "ihu", "ihu amụ nwere anya amụ", "ọtanjele"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bros"),
            keywords: &["andlit", "bros", "brosandi andlit og augu", "brosandi augu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con occhi sorridenti"),
            keywords: &[
                "faccina",
                "faccina con occhi sorridenti",
                "felice",
                "occhi sorridenti",
                "sorriso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("にこにこ"),
            keywords: &[
                "にこにこ",
                "スマイル",
                "微笑み",
                "目を細める",
                "頬を赤らめる",
                "顔",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mesem matane merem"),
            keywords: &[
                "abang pipine",
                "mata",
                "mesem",
                "rai",
                "rai mesem matane merem",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე მომღიმარე თვალებით"),
            keywords: &[
                "თვალი",
                "მომღიმარე სახე მომღიმარე თვალებით",
                "სახე",
                "სირცხვილი",
                "უხერხულობა",
                "ღიმილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem innecṛaḥen s wallen icmumḥen"),
            keywords: &["udem innecṛaḥen s wallen icmumḥen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("риза болып күлу"),
            keywords: &["ажар", "жымию", "күлу", "риза болып күлу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt og øjne"),
            keywords: &["smil med smileøjne", "smilende ansigt og øjne", "smileøjne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខញញ\u{17b9}មពេញច\u{17b7}ត\u{17d2}ត"),
            keywords: &[
                "ញញ\u{17b9}ម",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខក\u{17d2}រហម",
                "ម\u{17bb}ខញញ\u{17b9}មពេញច\u{17b7}ត\u{17d2}ត",
                "អៀន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಗುತ\u{ccd}ತ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳೊಂದ\u{cbf}ಗ\u{cc6} ನಗು ಮುಖ"),
            keywords: &[
                "ಕ\u{cbf}ರುನಗ\u{cc6} ಕಣ\u{ccd}ಣುಗಳು",
                "ಕ\u{cbf}ರುನಗ\u{cc6} ಮುಖ ಮತ\u{ccd}ತು ಕಣ\u{ccd}ಣುಗಳು",
                "ನಗುತ\u{ccd}ತ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳೊಂದ\u{cbf}ಗ\u{cc6} ನಗು ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("미소 짓는 눈으로 살짝 웃는 얼굴"),
            keywords: &[
                "눈웃음",
                "미소",
                "미소 짓는 눈으로 살짝 웃는 얼굴",
                "스마일",
                "얼굴",
                "웃는 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हा\u{902}स-या दोळ\u{94d}या\u{902}चो हा\u{902}सरो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "दोळो",
                "लज\u{947}वप",
                "हा\u{902}स-या दोळ\u{94d}या\u{902}चो हा\u{902}सरो च\u{947}रो",
                "हा\u{902}सप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("уялыңкы жылмайган бет"),
            keywords: &["бет", "жылмай", "уялыңкы", "уялыңкы жылмайган бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat laachenden Aen"),
            keywords: &[
                "A",
                "Gesiicht",
                "Laachen",
                "laachend Gesiicht mat laachenden Aen",
                "rout ginn",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຕາຍ\u{eb4}\u{ec9}ມ"),
            keywords: &[
                "ຕາ",
                "ອ\u{ebb}ບຍ\u{eb4}\u{ec9}ມ",
                "ຮ\u{eb4}ຮ\u{eb4}",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມຕາຍ\u{eb4}\u{ec9}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis veidas su besišypsančiomis akimis"),
            keywords: &[
                "akys",
                "besišypsantis veidas su besišypsančiomis akimis",
                "nurausti",
                "veidas",
                "šypsena",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smaidoša seja ar smaidošām acīm"),
            keywords: &[
                "nosarkt",
                "prieks",
                "seja",
                "smaidoša seja ar smaidošām acīm",
                "smaids",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene karu menemene"),
            keywords: &["kanohi", "karu", "menemene", "mumura"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("насмеано лице со насмеани очи"),
            keywords: &[
                "вцрвенето",
                "лице",
                "насмеано лице со насмеани очи",
                "насмевка",
                "очи",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "കണ\u{d4d}ണ\u{d4d}",
                "കവിളിണ",
                "ന\u{d3e}ണം",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("онийж инээмсэглэсэн царай"),
            keywords: &[
                "инээмсэглэх",
                "ичингүйрэх",
                "онийж инээмсэглэсэн царай",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हसणार\u{94d}\u{200d}या होळ\u{94d}या\u{902}सह हसणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "डोळ\u{947}",
                "लाली",
                "हसणार\u{94d}\u{200d}या होळ\u{94d}या\u{902}सह हसणारा च\u{947}हरा",
                "हसणाऱ\u{94d}या डोळ\u{94d}या\u{902}सह हसणारा च\u{947}हरा",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersenyum dengan mata tersenyum"),
            keywords: &[
                "mata",
                "merah",
                "muka",
                "muka tersenyum dengan mata tersenyum",
                "senyum",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jitbissem b’għajnejn jitbissmu"),
            keywords: &[
                "għajn",
                "jitbissem",
                "jiħmar",
                "wiċċ",
                "wiċċ jitbissem b’għajnejn jitbissmu",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}လ\u{102f}\u{1036}းများ ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} အပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a}မျက\u{103a}လ\u{102f}\u{1036}းများဖြင\u{1037}\u{103a} အပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
                "ပြ\u{102f}\u{1036}းနေသည\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
                "မျက\u{103a}လ\u{102f}\u{1036}းများ ပြ\u{102f}\u{1036}းနေသည\u{1037}\u{103a} အပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
                "ရ\u{103e}က\u{103a}သ\u{103d}ေးဖြန\u{103a}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smil med smilende øyne"),
            keywords: &[
                "fjes",
                "rødme",
                "smil",
                "smil med smilende øyne",
                "smilende øyne",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चम\u{94d}किला आ\u{901}खा र ह\u{901}सिलो अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}खा",
                "चम\u{94d}किला आ\u{901}खा र ह\u{901}सिलो अन\u{941}हार",
                "म\u{941}स\u{94d}कान",
                "लजाएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lachend gezicht met lachende ogen"),
            keywords: &[
                "blozen",
                "gezicht",
                "glimlach",
                "lachend gezicht met lachende ogen",
                "oog",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smil med smilande auge"),
            keywords: &["auge", "fjes", "raudne", "smil", "smil med smilande auge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f} ସହ\u{b3f}ତ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଆଖ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}",
                "ଲଜ\u{b4d}ଜ\u{b3f}ତ ହେବ\u{b3e}",
                "ସ\u{b4d}ମ\u{b3f}ତହ\u{b3e}ସ\u{b4d}ୟ",
                "ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f} ସହ\u{b3f}ତ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ ਚਿਹਰਾ ਅਤ\u{a47} ਅ\u{a71}ਖਾ\u{a02}",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02}",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦੀਆ\u{a02} ਅ\u{a71}ਖਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مسکراندیاں اکھاں نال مسکراندی شکل"),
            keywords: &[
                "اکھ",
                "دی شکل",
                "شرمانا",
                "مسکرانا",
                "مسکراندیاں اکھاں نال مسکراندی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smaílín Fes Wit Shaínín Ai"),
            keywords: &[
                "Ai",
                "Fes",
                "Fes Wé Shem De Kach",
                "Hápí Smail",
                "Smaílín Fes Wit Shaínín Ai",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz o roześmianych oczach"),
            keywords: &[
                "przyjazny",
                "serdeczny",
                "uśmiech",
                "uśmiechnięta twarz o roześmianych oczach",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدونکی مخ د مسکېدونکې سترګو"),
            keywords: &["سترګه", "شرمېدل", "مخ", "مسکېدونکی مخ د مسکېدونکې سترګو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto sorridente com olhos sorridentes"),
            keywords: &[
                "olhos sorrindo",
                "rosto",
                "rosto sorridente com olhos sorridentes",
                "rosto sorrindo",
                "ruborizar",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir com olhos sorridentes"),
            keywords: &[
                "cara",
                "cara a sorrir com olhos sorridentes",
                "corado",
                "olho",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uyata kusisqa ñawikunawan"),
            keywords: &[
                "kusi",
                "kusisqa uyata kusisqa ñawikunawan",
                "pʼinqakuy",
                "uya",
                "ñawi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față zâmbitoare cu ochi zâmbitori"),
            keywords: &[
                "față zâmbitoare cu ochi zâmbitori",
                "ochi",
                "privire",
                "zâmbet",
                "îmbujorare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-846"),
            keywords: &["E10-846"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("довольно улыбается"),
            keywords: &[
                "глаза",
                "довольно улыбается",
                "лицо",
                "румянец",
                "улыбка",
                "щеки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura y’amaso yo guseka"),
            keywords: &["ijisho", "isura y’amaso yo guseka", "kumwenyura", "kwijima"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کلندڙ انکين سان کلندڙ چهرو"),
            keywords: &["شرمائڻ، اک چهرو، مسڪراهٽ", "کلندڙ انکين سان کلندڙ چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ස\u{dd2}න\u{dcf}සෙන ඇස\u{dca} සහ\u{dd2}\u{dd2}ත ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
            ),
            keywords: &[
                "ඇස",
                "ම\u{dd4}හ\u{dd4}ණ",
                "රත\u{dd4} ව\u{dd3}ම",
                "ස\u{dd2}නහව",
                "ස\u{dd2}න\u{dcf}සෙන ඇස\u{dca} සහ\u{dd2}\u{dd2}ත ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("smejúca sa tvár s prižmúrenými očami"),
            keywords: &[
                "oko",
                "smejúca sa tvár s prižmúrenými očami",
                "tvár",
                "zapýrenie",
                "úsmev",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz s smejočimi očmi"),
            keywords: &[
                "nasmeh",
                "obraz",
                "oči",
                "smejoči obraz s smejočimi očmi",
                "zardevanje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji iyo indho dhoolo cadeynaaya"),
            keywords: &[
                "dhoola cadeyn waji dhoola cadeynaaya oo indho dhoolo cadeynaaya leh",
                "gududayn",
                "il",
                "waji",
                "waji iyo indho dhoolo cadeynaaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e qeshur me sy të qeshur"),
            keywords: &[
                "buzëqeshje",
                "fytyrë",
                "fytyrë e qeshur me sy të qeshur",
                "skuqem",
                "sy",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("насмејано лице са насмејаним очима"),
            keywords: &[
                "лице",
                "насмејано лице са насмејаним очима",
                "око",
                "осмех",
                "румено",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("насмијано лице са насмијаним очима"),
            keywords: &["насмијано лице са насмијаним очима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nasmejano lice sa nasmejanim očima"),
            keywords: &[
                "lice",
                "nasmejano lice sa nasmejanim očima",
                "oko",
                "osmeh",
                "rumeno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("nasmijano lice sa nasmijanim očima"),
            keywords: &["nasmijano lice sa nasmijanim očima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("leende ansikte och ögon"),
            keywords: &["glad", "leende ansikte och ögon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu na macho yanayotabasamu"),
            keywords: &[
                "jicho",
                "tabasamu",
                "uso",
                "uso unaotabasamu na macho yanayotabasamu",
                "wekundu wa uso",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிரிக\u{bcd}கும\u{bcd} கண\u{bcd}களுடன\u{bcd} சிரித\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "கண\u{bcd}",
                "சிரிக\u{bcd}கும\u{bcd} கண\u{bcd}களுடன\u{bcd} சிரித\u{bcd}த முகம\u{bcd}",
                "புன\u{bcd}னகை",
                "முகம\u{bcd}",
                "வெட\u{bcd}கப\u{bcd} புன\u{bcd}னகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సంత\u{c4b}షంత\u{c4b} నవ\u{c4d}వుతున\u{c4d}న ముఖం"),
            keywords: &[
                "నవ\u{c4d}వు",
                "ముఖం",
                "సంత\u{c4b}ం",
                "సంత\u{c4b}షంత\u{c4b} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо чашмони хандон"),
            keywords: &[
                "рӯи хандон бо чашмони хандон",
                "рӯй",
                "табассум",
                "хиҷолат",
                "чашм",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าย\u{e34}\u{e49}มตาย\u{e34}\u{e49}ม"),
            keywords: &[
                "ตา",
                "หน\u{e49}า",
                "หน\u{e49}าย\u{e34}\u{e49}มตาย\u{e34}\u{e49}ม",
                "หน\u{e49}าแดง",
                "อมย\u{e34}\u{e49}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gülýän gözli ýylgyrýan ýüz"),
            keywords: &[
                "göz",
                "gülýän gözli ýylgyrýan ýüz",
                "ýylgyrmak",
                "ýüz",
                "ýüzi gyzarmak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata malimali moe kanoʻimata malimali"),
            keywords: &["mata malimali moe kanoʻimata malimali"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağzı açık gülme"),
            keywords: &[
                "ağzı açık gülme",
                "gülümseyen gözler",
                "gülümseyen yüz",
                "gülümseyen yüz ve gözler",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تەبەسسۇملۇق كۆز ۋە خۇش چىراي"),
            keywords: &[
                "تەبەسسۇملۇق كۆز ۋە خۇش چىراي",
                "تەڭلىك",
                "كۆز",
                "كۈلۈمسىرەش",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("усміхнене обличчя й очі"),
            keywords: &[
                "обличчя",
                "очі",
                "посмішка",
                "рум’янець",
                "усміхнене обличчя з примруженими очима",
                "усміхнене обличчя й очі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مسکراتی آنکھوں والا مسکراتا چہرہ"),
            keywords: &[
                "آنکھ",
                "مسکراتی آنکھوں والا مسکراتا چہرہ",
                "مسکراہٹ",
                "چہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tabassum va kulib turgan ko‘zlar"),
            keywords: &[
                "ko‘z",
                "qizarish",
                "tabassum",
                "tabassum va kulib turgan ko‘zlar",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt mỉm cười với hai mắt híp lại"),
            keywords: &[
                "cười",
                "mắt",
                "mặt",
                "mặt mỉm cười với hai mắt híp lại",
                "đỏ mặt",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu mbegte ak bët yuy muuñ"),
            keywords: &[
                "bët",
                "kanam",
                "kanamu mbegte ak bët yuy muuñ",
                "mbegte",
                "muuñ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obunamehlo ancumileyo"),
            keywords: &[
                "iintloni",
                "iliso",
                "ubuso",
                "ubuso obuncumileyo obunamehlo ancumileyo",
                "uncumo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some(
                "Ojú tó rẹ\u{301}rìn Músẹ\u{301} Pẹ\u{300}lú Ẹyinjú tó rẹ\u{301}rìn Músẹ\u{301}",
            ),
            keywords: &[
                "Ojú tó rẹ\u{301}rìn Músẹ\u{301} Pẹ\u{300}lú Ẹyinjú tó rẹ\u{301}rìn Músẹ\u{301}",
                "ojú",
                "rẹ\u{301}rìń músẹ\u{301}",
                "rẹ\u{301}rìń ìtìjù",
                "ẹyinjú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("微笑嘅臉同微笑嘅眼睛"),
            keywords: &["微笑", "微笑嘅臉同微笑嘅眼睛", "眼", "腮紅", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("微笑嘅脸同微笑嘅眼睛"),
            keywords: &["微笑", "微笑嘅脸同微笑嘅眼睛", "眼", "脸", "腮红"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("羞涩微笑"),
            keywords: &["害羞", "微笑", "羞涩", "羞涩微笑", "脸", "脸红"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("微笑"),
            keywords: &["微笑", "笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("瞇眼微笑嘅表情"),
            keywords: &["微笑", "瞇眼微笑嘅表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizelayo namehlo ajabule"),
            keywords: &[
                "amehlo",
                "ihlo",
                "moyizela",
                "ubuso",
                "ubuso obumoyizelayo namehlo ajabule",
            ],
        },
    ],
};
#[doc = "😇"]
pub const SMILING_FACE_WITH_HALO: crate::Emoji = crate::Emoji {
    glyph: "😇",
    codepoint: "1F607",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "smiling face with halo",
    group: "Smileys & Emotion",
    subgroup: "face-smiling",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("glimlaggende gesig met stralekrans"),
            keywords: &[
                "engel",
                "gesig",
                "glimlag",
                "glimlaggende gesig met stralekrans",
                "onskuldig",
                "stralekrans",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ላዩ ላይ ክብ ያለበት ሣቂታ ፊት"),
            keywords: &["ላዩ ላይ ክብ ያለበት ሣቂታ ፊት", "መልዓክ", "ምናባዊ", "ታማኝ", "የዋህ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه مبتسم بهالة"),
            keywords: &["ابتسام", "هالة", "\u{202b}وجه مبتسم بهالة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অলৌকিক মহিম\u{9be}ৰ চেহেৰ\u{9be}"),
            keywords: &[
                "অলৌকিক মহিম\u{9be}",
                "অলৌকিক মহিম\u{9be}ৰ চেহেৰ\u{9be}",
                "দেবদ\u{9c2}ত",
                "নিৰীহ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("başında halə gülmsəyən üz"),
            keywords: &[
                "başında halə gülmsəyən üz",
                "fantastika",
                "halə",
                "mələk",
                "məsum",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з німбам"),
            keywords: &[
                "анёл",
                "арэол",
                "казачны",
                "нявінны",
                "німб",
                "твар з німбам",
                "усмешка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Усмихнато лице с ореол"),
            keywords: &[
                "Усмихнато лице с ореол",
                "ангел",
                "лице",
                "невинно",
                "ореол",
                "фантазия",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}থ\u{9be}য\u{9bc} চক\u{9cd}রের স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি"),
            keywords: &[
                "কল\u{9cd}পন\u{9be}",
                "জ\u{9cd}যোতির\u{9cd}বলয\u{9bc}",
                "দেবদ\u{9c2}ত",
                "নিরীহ",
                "ম\u{9be}থ\u{9be}য\u{9bc} চক\u{9cd}রের স\u{9be}থে ম\u{9c1}খে হ\u{9be}সি",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oreol iznad glave"),
            keywords: &[
                "anđeo",
                "fantazija",
                "lice",
                "nevin",
                "oreol",
                "oreol iznad glave",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara somrient amb aurèola"),
            keywords: &[
                "angelet",
                "aurèola",
                "cara somrient amb aurèola",
                "halo",
                "sant",
                "santa",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏰᏗᏍᎩ ᎤᎧᏔ ᎤᎵᎪᏓ"),
            keywords: &["ᎠᏂᏓᏪᎯ", "ᎤᎧᏛ", "ᎤᏰᏗᏍᎩ ᎤᎧᏔ ᎤᎵᎪᏓ", "ᎮᎶᎯ", "ᎰᏩᏭ ᏂᎨᏒᎾ", "ᎾᏍᎦᏅᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("usmívající se obličej se svatozáří"),
            keywords: &[
                "anděl",
                "fantasy",
                "nevinný",
                "pohádka",
                "smajlík",
                "svatozář",
                "tvář",
                "usmívající se obličej se svatozáří",
                "výraz",
                "úsměv",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu ag eurgylch"),
            keywords: &[
                "angel",
                "diniwed",
                "eurgylch",
                "wyneb",
                "wyneb yn gwenu ag eurgylch",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("smilende ansigt med glorie"),
            keywords: &[
                "engel",
                "glorie",
                "smil",
                "smilende ansigt med glorie",
                "uskyldig",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lächelndes Gesicht mit Heiligenschein"),
            keywords: &[
                "Gesicht",
                "Heiligenschein",
                "Lächeln",
                "lächelndes Gesicht mit Heiligenschein",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαμογελαστό πρόσωπο\u{a0}με φωτοστέφανο"),
            keywords: &[
                "άγγελος",
                "αθώος",
                "παραμύθι",
                "πρόσωπο",
                "φαντασία",
                "φωτοστέφανο",
                "χαμογελαστό πρόσωπο\u{a0}με φωτοστέφανο",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("smiling face with halo"),
            keywords: &[
                "angel",
                "face",
                "fantasy",
                "halo",
                "innocent",
                "smiling face with halo",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con aureola"),
            keywords: &[
                "cara",
                "cara sonriendo con aureola",
                "halo",
                "sonrisa",
                "ángel",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "aureola",
                "cara",
                "cara sonriendo con aureola",
                "inocente",
                "sonriente con aureola",
                "sonrisa",
                "ángel",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con aureola"),
            keywords: &[
                "aureola",
                "cara",
                "cara sonriendo con aureola",
                "inocente",
                "sonriente con aureola",
                "sonrisa",
                "ángel",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con aureola"),
            keywords: &["cara sonriendo con aureola"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aupaistega naerunägu"),
            keywords: &[
                "aupaistega naerunägu",
                "fantaasia",
                "halo",
                "ingel",
                "naeratus",
                "nägu",
                "süütu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("barreka ari den aurpegia argi-koroarekin"),
            keywords: &[
                "aingerua",
                "argi-koroa",
                "aurpegia",
                "barreka ari den aurpegia argi-koroarekin",
                "fantasia",
                "inuzentea",
                "irribarre egiten ari den aurpegia argi-koroarekin",
                "irribarrea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هاله\u{200c}دار"),
            keywords: &[
                "صورت",
                "فانتزی",
                "فرشته",
                "لبخند",
                "معصوم",
                "هاله",
                "هاله\u{200c}دار",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hymy ja sädekehä"),
            keywords: &[
                "enkeli",
                "hymy",
                "hymy ja sädekehä",
                "naama",
                "satu",
                "sädekehä",
                "viaton",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangiti nang may halo"),
            keywords: &[
                "anghel",
                "halo",
                "inosente",
                "mabait",
                "mukha",
                "nakangiti",
                "nakangiti nang may halo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brosandi andlit við halgiboga"),
            keywords: &[
                "andlit",
                "brosandi andlit við halgiboga",
                "gloria",
                "halgibogi",
                "sakleys",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage souriant avec auréole"),
            keywords: &["ange", "visage souriant avec auréole"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage qui sourit avec une auréole"),
            keywords: &[
                "ange",
                "auréole",
                "innocent",
                "visage",
                "visage qui sourit avec une auréole",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag gáire le luan"),
            keywords: &[
                "fáinne solais",
                "meangadh gáire",
                "straoiseog ag gáire le luan",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le gàire agus riomball"),
            keywords: &[
                "aingeal",
                "aodann",
                "aodann le gàire agus riomball",
                "fantastach",
                "faoinsgeul",
                "fiamh-ghàire",
                "neoichiontach",
                "riomball",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara riseira con auréola"),
            keywords: &[
                "anxo",
                "auréola",
                "cara riseira con auréola",
                "santa",
                "santo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}રભાવલય સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "પ\u{acd}રભાવલય",
                "પ\u{acd}રભાવલય સાથ\u{ac7}ન\u{ac1}\u{a82} હાસ\u{acd}ય",
                "પ\u{acd}રભાવલય સાથ\u{ac7}નો સ\u{acd}મિત કરતો ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
                "હાસ\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da da’irar haske"),
            keywords: &[
                "fuska",
                "fuska mai murmushi tare da da’irar haske",
                "labarin aljana",
                "malaika",
                "maras laifi",
                "murmushi",
                "tatsuniya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחייך עם הילת מלאך"),
            keywords: &["מחייך", "מלאך", "פרצוף", "פרצוף מחייך עם הילת מלאך", "תמים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}रभाम\u{902}डल वाली म\u{941}स\u{94d}कान वाला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "प\u{94d}रभाम\u{902}डल",
                "प\u{94d}रभाम\u{902}डल वाली म\u{941}स\u{94d}कान",
                "प\u{94d}रभाम\u{902}डल वाली म\u{941}स\u{94d}कान वाला च\u{947}हरा",
                "म\u{941}स\u{94d}कान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmiješeno lice s aureolom"),
            keywords: &[
                "anđeo",
                "aureola",
                "bajka",
                "lice",
                "nasmiješeno lice s aureolom",
                "nevinost",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mosolygó arc glóriával"),
            keywords: &[
                "angyal",
                "arc",
                "glória",
                "mese",
                "mosoly",
                "mosolygó arc glóriával",
                "ártatlanság",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժպտացող դեմք լուսապսակով"),
            keywords: &[
                "անմեղ",
                "դեմք",
                "ժպիտ",
                "ժպտացող դեմք լուսապսակով",
                "լուսապսակ",
                "հրեշտակ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah malaikat"),
            keywords: &[
                "fantasi",
                "halo",
                "lugu",
                "malaikat",
                "wajah",
                "wajah malaikat tersenyum",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu amụ nwere okirikiri okụ"),
            keywords: &[
                "akụkọ èroro ero",
                "akụkụ",
                "amụ",
                "dị ọcha",
                "ihu",
                "ihu amụ nwere okirikiri okụ",
                "mụọ mma",
                "okirikiri ọkụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brosandi andlit með geislabaug"),
            keywords: &[
                "andlit",
                "bros",
                "bros og geislabaugur",
                "brosandi andlit með geislabaug",
                "geislabaugur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con sorriso e aureola"),
            keywords: &[
                "angioletto",
                "aureola",
                "faccina",
                "faccina con sorriso e aureola",
                "faccina sorridente con aureola",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("天使の輪がついた笑顔"),
            keywords: &["スマイル", "天使の輪", "天使の輪がついた笑顔", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mesem mawa tandha santo ing sirahe"),
            keywords: &[
                "fantasi",
                "rai",
                "rai mesem mawa tandha santo ing sirahe",
                "suci",
                "tandha santo",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე შარავანდედით"),
            keywords: &[
                "ანგელოზი",
                "ზღაპარი",
                "მომღიმარე სახე შარავანდედით",
                "სახე",
                "უდანაშაულო",
                "უმანკო",
                "ფანტაზია",
                "ფანტასტიკა",
                "ღიმილი",
                "შარავანდედი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бейуаз"),
            keywords: &[
                "бейуаз",
                "бейуаз күлкі",
                "бет",
                "жымию",
                "кінәсіз",
                "періште",
                "хало",
                "қиял",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt med glorie"),
            keywords: &["ansigt", "glorie", "smil", "smilende ansigt med glorie"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខមានរង\u{17d2}វង\u{17cb}ទេវតានៅលើក\u{17d2}បាល"),
            keywords: &[
                "ញញ\u{17b9}ម",
                "ទេវតា",
                "ម\u{17bb}ខមានរង\u{17d2}វង\u{17cb}ទេវតានៅលើក\u{17d2}បាល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತೇಜೋಮಂಡಲದೊಂದ\u{cbf}ಗ\u{cc6} ನಗು ಮುಖ"),
            keywords: &[
                "ತೇಜೋಮಂಡಲ",
                "ತೇಜೋಮಂಡಲ ನಗು",
                "ತೇಜೋಮಂಡಲದೊಂದ\u{cbf}ಗ\u{cc6} ನಗು ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("후광이 비치는 웃는 얼굴"),
            keywords: &[
                "미소",
                "스마일",
                "얼굴",
                "웃는 얼굴",
                "후광이 비치는 웃는 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{94d}रभ\u{947} सयत हा\u{902}सरो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "नवलकथा",
                "निश\u{94d}पाप",
                "परी",
                "प\u{94d}रभा",
                "प\u{94d}रभ\u{947} सयत हा\u{902}सरो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башында тегереги бар жылмайган бет"),
            keywords: &[
                "башында тегереги бар жылмайган бет",
                "бейкүнөө",
                "бет",
                "периште",
                "тегерек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat Hellegeschäin"),
            keywords: &[
                "Engel",
                "Fantasie",
                "Gesiicht",
                "Hellegeschäin",
                "Laachen",
                "Mäerchen",
                "laachend Gesiicht mat Hellegeschäin",
                "onschëlleg",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{eb4}\u{ec9}ມເທວະດາ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຍ\u{eb4}\u{ec9}ມເທວະດາ",
                "ນາງຟ\u{ec9}າ",
                "ເທວະດາ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis veidas su aureole"),
            keywords: &[
                "angelas",
                "aureolė",
                "besišypsantis veidas su aureole",
                "fantazija",
                "nekaltas",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smaidoša seja ar nimbu"),
            keywords: &[
                "eņģelis",
                "nevainīgs",
                "nimbs",
                "seja",
                "smaidoša seja ar nimbu",
                "smaids",
                "svētais",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene whai āwheo"),
            keywords: &[
                "anahera",
                "hēkore",
                "kanohi",
                "kanohi menemene whai āwheo",
                "kōrero pakiwaitara",
                "menemene",
                "moemoeā",
                "āwheo",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("насмеано лице со ореол"),
            keywords: &[
                "ангел",
                "насмеано лице со ореол",
                "насмевка",
                "невиност",
                "ореол",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "പ\u{d4d}രക\u{d3e}ശവലയമ\u{d41}ള\u{d4d}ള പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "നിഷ\u{d4d}\u{200c}കളങ\u{d4d}കം",
                "പ\u{d41}ഞ\u{d4d}ചിരി",
                "പ\u{d4d}രക\u{d3e}ശവലയം",
                "പ\u{d4d}രക\u{d3e}ശവലയമ\u{d41}ള\u{d4d}ള പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മ\u{d3e}ല\u{d3e}ഖ",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("инээмсэглэж буй сахиусан тэнгэрийн царай"),
            keywords: &[
                "инээмсэглэж буй сахиусан тэнгэрийн царай",
                "инээмсэглэх",
                "сахиусан тэнгэр",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{947}जोम\u{902}डळ असणारा च\u{947}हरा"),
            keywords: &[
                "आवड",
                "च\u{947}हरा",
                "त\u{947}जोम\u{902}डळ",
                "त\u{947}जोम\u{902}डळ असणारा च\u{947}हरा",
                "त\u{947}जोम\u{902}डळ असणारा हसणारा च\u{947}हरा",
                "द\u{947}वद\u{942}त",
                "निष\u{94d}पाप",
                "परीकथा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersenyum dengan halo"),
            keywords: &[
                "fantasi",
                "halo",
                "malaikat",
                "muka",
                "muka tersenyum dengan halo",
                "suci",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jitbissem b’raġġiera"),
            keywords: &[
                "anġlu",
                "fantasija",
                "innoċenti",
                "jitbissem",
                "raġġiera",
                "wiċċ",
                "wiċċ jitbissem b’raġġiera",
                "ħrafa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရောင\u{103a}လျ\u{103e}\u{1036}စက\u{103a}ဝန\u{103a}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "စ\u{102d}တ\u{103a}က\u{1030}းယဉ\u{103a}",
                "နတ\u{103a}မ\u{102d}မယ\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
                "ရောင\u{103a}လျ\u{103e}\u{1036}စက\u{103a}ဝန\u{103a}း",
                "ရောင\u{103a}လျ\u{103e}\u{1036}စက\u{103a}ဝန\u{103a}းန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smil med glorie"),
            keywords: &[
                "engel",
                "fjes",
                "glorie",
                "smil",
                "smil med glorie",
                "uskyldig",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ह\u{94d}यालो सहितको ह\u{901}सिलो अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "निराधार कल\u{94d}पना",
                "निर\u{94d}दोष",
                "परी",
                "ह\u{94d}यालो",
                "ह\u{94d}यालो सहितको ह\u{901}सिलो अन\u{941}हार",
                "ह\u{94d}यालोय\u{941}क\u{94d}त ह\u{901}सिलो अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lachend gezicht met halo"),
            keywords: &[
                "engel",
                "fantasie",
                "gezicht",
                "glimlach",
                "halo",
                "lach",
                "lachend gezicht met halo",
                "onschuldig",
                "sprookje",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smil med glorie"),
            keywords: &[
                "engel",
                "fjes",
                "glorie",
                "smil",
                "smil med glorie",
                "uskyldig",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଲୋ ସହ\u{b3f}ତ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "କଳ\u{b4d}ପନ\u{b3e}",
                "ନ\u{b3f}ରୀହ",
                "ପରୀ",
                "ମ\u{b41}ହ\u{b01}",
                "ହ\u{b3e}ଲୋ",
                "ହ\u{b3e}ଲୋ ସହ\u{b3f}ତ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਾਲ\u{a4b} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਕਲਪਨਾ",
                "ਚਿਹਰਾ",
                "ਫਰਿਸ\u{a3c}ਤਾ",
                "ਮਾਸ\u{a42}ਮ ਚਿਹਰਾ",
                "ਮ\u{a41}ਸਕਾਨ",
                "ਹਾਲ\u{a4b}",
                "ਹਾਲ\u{a4b} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چمک نال مسکراندی شکل"),
            keywords: &[
                "تصور",
                "دی شکل",
                "فرشتہ",
                "مسکرانا",
                "معصوم",
                "پریاں دی کہانی",
                "چمک نال مسکراندی شکل",
                "ہالہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smaílín Fes With Raúnd Lait Fọ Hẹd"),
            keywords: &[
                "Dream",
                "Fes",
                "Pẹ\u{301}sin Nọ\u{301} Dú Bad",
                "Raúnd Lait",
                "Smaílín Fes With Raúnd Lait Fọ Hẹd",
                "Énjẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz z aureolą"),
            keywords: &[
                "nic nie zrobiłem",
                "uśmiechnięta twarz z aureolą",
                "świętoszek",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدونکی مخ د هالې سره"),
            keywords: &["فرشته", "مخ", "مسکېدونکی مخ د هالې سره", "معصوم", "هاله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto sorridente com auréola"),
            keywords: &[
                "anjo",
                "auréola",
                "inocente",
                "rosto",
                "rosto sorridente com auréola",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir com auréola"),
            keywords: &[
                "anjo",
                "auréola",
                "cara",
                "cara a sorrir com auréola",
                "conto de fadas",
                "fantasia",
                "inocente",
                "sorriso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya aureolawan"),
            keywords: &[
                "angel",
                "aureola",
                "fantasia",
                "juchannaq",
                "kusisqa uya aureolawan",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față zâmbitoare cu aură"),
            keywords: &[
                "aură",
                "fantezie",
                "față zâmbitoare cu aură",
                "halou",
                "inocent",
                "înger",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-843"),
            keywords: &["E10-843"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("с нимбом"),
            keywords: &[
                "ангел",
                "лицо",
                "невинность",
                "с нимбом",
                "святость",
                "сказка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza inseko na halo"),
            keywords: &[
                "amakabyankuru",
                "ikamba",
                "inseko",
                "isura",
                "isura igaragaza inseko na halo",
                "marayika",
                "ntamakemwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نور جي حلقي سان مسڪرائيندڙ چهرو"),
            keywords: &[
                "تصور",
                "فرشتو",
                "مرڪ",
                "معصوم",
                "نور جي حلقي سان مسڪرائيندڙ چهرو",
                "هالو",
                "پري جي ڪهاڻي",
                "چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රැස\u{dca} වළල\u{dca}ල සහ\u{dd2}ත ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අහ\u{dd2}ංසක",
                "රැස\u{dca} වළල\u{dca}ල සහ\u{dd2}ත ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd4}රංගන\u{dcf} කථ\u{dcf}ව",
                "ස\u{dd4}රංගන\u{dcf}ව\u{dd2}ය",
                "හලෝ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("smejúca sa tvár so svätožiarou"),
            keywords: &[
                "anjel",
                "nevinná",
                "smejúca sa tvár so svätožiarou",
                "svätožiara",
                "svätá",
                "tvár",
                "úsmev",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz s svetniškim sijem"),
            keywords: &[
                "angel",
                "avra",
                "fantazija",
                "nasmeh",
                "nedolžno",
                "obraz",
                "pravljica",
                "smejoči obraz s svetniškim sijem",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dhoolo cadeynaya wareeg leh"),
            keywords: &[
                "dambi lahayn",
                "khayaali",
                "malaai’ig",
                "waji",
                "waji dhoolo cadeynaya",
                "waji dhoolo cadeynaya wareeg leh",
                "wareeg",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e qeshur me aureolë"),
            keywords: &[
                "aureolë",
                "buzëqeshje",
                "e pafajshme",
                "engjëll",
                "fytyrë e qeshur me aureolë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("насмејано лице са ореолом"),
            keywords: &[
                "анђео",
                "бајка",
                "лице",
                "насмејано лице са ореолом",
                "невино",
                "ореол",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("насмијано лице са ореолом"),
            keywords: &["насмијано лице са ореолом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nasmejano lice sa oreolom"),
            keywords: &[
                "anđeo",
                "bajka",
                "lice",
                "nasmejano lice sa oreolom",
                "nevino",
                "oreol",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("nasmijano lice sa oreolom"),
            keywords: &["nasmijano lice sa oreolom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("leende ansikte med gloria"),
            keywords: &["gloria", "leende", "leende ansikte med gloria"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu ulio na mduara wa mwangaza juu yake"),
            keywords: &[
                "asiye na hatia",
                "duara ya mwangaza",
                "malaika",
                "njozi",
                "tabasamu",
                "uso unaotabasamu ulio na mduara wa mwangaza juu yake",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒளிவட\u{bcd}டத\u{bcd}துடன\u{bcd} சிரித\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "ஒளிவட\u{bcd}ட சிரிப\u{bcd}பு",
                "ஒளிவட\u{bcd}டத\u{bcd}துடன\u{bcd} சிரித\u{bcd}த முகம\u{bcd}",
                "ஒளிவட\u{bcd}டம\u{bcd}",
                "பிரக\u{bbe}ச சிரிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తలప\u{c48} క\u{c3e}ంత\u{c3f} వలయంత\u{c4b} నవ\u{c4d}వుతున\u{c4d}న ముఖం"),
            keywords: &[
                "క\u{c3e}ంత\u{c3f}",
                "తల",
                "తలప\u{c48} క\u{c3e}ంత\u{c3f} వలయంత\u{c4b} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "నవ\u{c4d}వు",
                "ముఖం",
                "వలయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо ҳола"),
            keywords: &[
                "афсона",
                "бегуноҳ",
                "малоика",
                "рӯи хандон бо ҳола",
                "рӯй",
                "табассум",
                "тахайюлот",
                "ҳола",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e34}\u{e49}มเทวดา"),
            keywords: &[
                "นางฟ\u{e49}า",
                "บร\u{e34}ส\u{e38}ทธ\u{e34}\u{e4c}",
                "ย\u{e34}\u{e49}ม",
                "ย\u{e34}\u{e49}มเทวดา",
                "เทวดา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("başy halkaly ýylgyrýan ýüz"),
            keywords: &[
                "başy halkaly ýylgyrýan ýüz",
                "bigünä",
                "erteki",
                "nurana halka",
                "perişde",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata malimali moe takaniko"),
            keywords: &["mata malimali moe takaniko"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ışık halkalı gülümseme"),
            keywords: &["gülümseme", "yüz", "ışık halkalı gülümseme", "ışık halkası"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("خۇش سالاملىق چىراي"),
            keywords: &[
                "خۇش سالاملىق چىراي",
                "رىۋايەت",
                "سالام",
                "سەمىمىي",
                "فانتازىيە",
                "كۈلۈمسىرەش",
                "پەرىشتە",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("усміхнене обличчя з німбом"),
            keywords: &[
                "ангел",
                "безневинність",
                "казка",
                "німб",
                "обличчя",
                "посмішка",
                "усміхнене обличчя з німбом",
                "фантазія",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہالہ لیے مسکراتا چہرہ"),
            keywords: &[
                "افسانوی",
                "فرشتہ",
                "مسکراہٹ",
                "معصوم",
                "چہرہ",
                "ہالہ لیے مسکراتا چہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tabassum, bosh ustida gardish"),
            keywords: &[
                "begunoh",
                "fantaziya",
                "farishta",
                "gardish",
                "tabassum",
                "tabassum, bosh ustida gardish",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười có hào quang"),
            keywords: &[
                "giả tưởng",
                "hào quang",
                "mặt",
                "mặt cười có hào quang",
                "ngây thơ",
                "thiên thần",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy muuñ ak serkal ci kawam"),
            keywords: &[
                "feem",
                "kanam",
                "kanam guy muuñ ak serkal ci kawam",
                "léebu fee",
                "malaaka",
                "muuñ",
                "serkal ci kaw",
                "xamul-dara",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obunesangqa entloko"),
            keywords: &[
                "i-halo",
                "ingelosi",
                "intsomi",
                "msulwa",
                "ubuso",
                "ubuso obuncumileyo obunesangqa entloko",
                "uncumo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ẹrin Ati Bawo"),
            keywords: &[
                "Oju Ẹrin Ati Bawo",
                "aláìṣẹ\u{300}",
                "báwo",
                "ojú",
                "rẹ\u{301}rìn músẹ\u{301}",
                "àla fú ọmọdé",
                "àlá",
                "àńgẹ\u{301}lì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("頭頂有光環嘅笑臉"),
            keywords: &["光環", "天使", "天真", "童話故事", "頭頂有光環嘅笑臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("头顶有光环嘅笑脸"),
            keywords: &[
                "光环",
                "天使",
                "天真",
                "头顶有光环嘅笑脸",
                "幻想",
                "微笑",
                "童话故事",
                "脸",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微笑天使"),
            keywords: &["光环", "天使", "天真", "幻想", "微笑", "微笑天使", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天使笑臉"),
            keywords: &["天使笑臉", "純真笑臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("頭上有個圈嘅笑面"),
            keywords: &["光環", "光環笑臉", "天使", "無辜", "頭上有個圈嘅笑面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizela nosawubona"),
            keywords: &[
                "ingelosi",
                "insumansumane",
                "moyizela",
                "msulwa",
                "sawubona",
                "ubuso",
                "ubuso obumoyizela nosawubona",
            ],
        },
    ],
};
