#[doc = "🤐"]
pub const ZIPPER_MOUTH_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤐",
    codepoint: "1F910",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "zipper-mouth face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met ritssluitermond"),
            keywords: &["gesig", "gesig met ritssluitermond", "mond", "ritssluiter"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ባለዚፕ አፍ ፊት"),
            keywords: &["ባለዚፕ አፍ ፊት", "አፍ", "ዚፕ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بفم مقفل"),
            keywords: &["فم", "قفل", "وجه", "وجه بفم مقفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খ বন\u{9cd}ধ ৰখ\u{9be} চেহেৰ\u{9be}"),
            keywords: &[
                "বন\u{9cd}ধ ৰখ\u{9be}",
                "ম\u{9c1}খ",
                "ম\u{9c1}খ বন\u{9cd}ধ ৰখ\u{9be} চেহেৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağzı bağlanmış üz"),
            keywords: &["ağzı bağlanmış üz", "ağız", "zəncirbənd", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рот на замок"),
            keywords: &["замок", "маўчу", "рот", "рот на замок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с уста с цип"),
            keywords: &["Лице с уста с цип", "лице", "уста", "цип"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খে ক\u{9c1}ল\u{9c1}প আ\u{981}ট\u{9be}"),
            keywords: &[
                "ঠো\u{981}ট",
                "ম\u{9c1}খ",
                "ম\u{9c1}খে ক\u{9c1}ল\u{9c1}প আ\u{981}ট\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šuti ko zaliven"),
            keywords: &["lice", "usta", "začepljena", "šuti ko zaliven"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb cremallera a la boca"),
            keywords: &[
                "boca",
                "boca tancada",
                "cara",
                "cara amb cremallera a la boca",
                "cremallera",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎥᎧᏁᏍᏗ-ᎠᎰᎵᎤᎧᏓ ᎤᎧᏛ"),
            keywords: &["ᎠᎧᏁᏍᏗ", "ᎠᎰᎵ", "ᎤᎧᏛ", "ᎥᎧᏁᏍᏗ-ᎠᎰᎵᎤᎧᏓ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s pusou na zip"),
            keywords: &[
                "obličej s pusou na zip",
                "smajlík",
                "tvář",
                "výraz",
                "zip",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â sip dros y geg"),
            keywords: &["caeedig", "ceg", "sip", "wyneb", "wyneb â sip dros y geg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med lynlåsmund"),
            keywords: &["ansigt", "ansigt med lynlåsmund", "lynlås", "mund"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Reißverschlussmund"),
            keywords: &[
                "Gesicht",
                "Gesicht mit Reißverschlussmund",
                "Mund",
                "Reißverschluss",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Smiley mit Reissverschlussmund"),
            keywords: &[
                "Gesicht",
                "Mund",
                "Reissverschluss",
                "Smiley mit Reissverschlussmund",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ερμητικά κλειστό στόμα"),
            keywords: &["ερμητικά κλειστό στόμα", "πρόσωπο", "στόμα", "φερμουάρ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("zipper-mouth face"),
            keywords: &["face", "mouth", "zipper", "zipper-mouth face"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["face", "mouth", "zip", "zipper"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con la boca cerrada con cremallera"),
            keywords: &[
                "boca",
                "cara",
                "cara con la boca cerrada con cremallera",
                "cremallera",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara con la boca cerrada con cierre"),
            keywords: &[
                "boca",
                "boca cerrada",
                "cara",
                "cara con la boca cerrada con cierre",
                "cierre",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara con la boca cerrada con cierre"),
            keywords: &[
                "boca",
                "cara",
                "cara con la boca cerrada con cierre",
                "zipper",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "boca",
                "cara",
                "cara con la boca cerrada con cierre",
                "cara con la boca cerrada con cremallera",
                "zipper",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tõmblukusuuga nägu"),
            keywords: &["nägu", "suu", "tõmblukk", "tõmblukusuuga nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kremaileradun ahoa duen aurpegia"),
            keywords: &[
                "aho",
                "aurpegi",
                "kremailera",
                "kremaileradun ahoa duen aurpegia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دهان چفت"),
            keywords: &["دهان", "دهان چفت", "زیپ", "صورت", "قابل اعتماد", "قفل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vetoketjusuu"),
            keywords: &["naama", "suu", "vetoketju", "vetoketjusuu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("naka-zipper ang bibig"),
            keywords: &[
                "bibig",
                "hindi magsasalita",
                "mukha",
                "naka-zipper ang bibig",
                "zipper",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lýnlás andlit"),
            keywords: &["andlit", "lýnlás"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec bouche fermeture éclair"),
            keywords: &[
                "bouche",
                "fermeture éclair",
                "visage",
                "visage avec bouche fermeture éclair",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bouche",
                "bouche cousue",
                "fermeture à glissière",
                "visage",
                "visage avec bouche fermeture éclair",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le béal zipeáilte"),
            keywords: &["aghaidh", "béal", "sip", "straoiseog le béal zipeáilte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le bilean seulaichte"),
            keywords: &[
                "aodann",
                "aodann le bilean seulaichte",
                "beul",
                "bilean",
                "seulaichte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara coa boca pechada cunha cremalleira"),
            keywords: &[
                "boca",
                "cara",
                "cara coa boca pechada cunha cremalleira",
                "cremalleira",
                "silencio",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોઢા પર ઝિપ સાથ\u{ac7}નો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ઝિપથી બ\u{a82}ધ કર\u{ac7}લો મોઢ\u{ac1}\u{a82}",
                "મ\u{ac1}ખ",
                "મોઢા પર ઝિપ સાથ\u{ac7}નો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuskar baki mai zif"),
            keywords: &["baki", "fuska", "fuskar baki mai zif", "zif"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם פה סגור ברוכסן"),
            keywords: &[
                "סגור",
                "פה",
                "פרצוף",
                "פרצוף עם פה סגור ברוכסן",
                "רוכסן",
                "ריצ׳רץ׳",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{93c}िपर-म\u{941}\u{901}ह वाला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "ज\u{93c}िपर-म\u{941}\u{901}ह वाला च\u{947}हरा",
                "म\u{941}\u{902}ह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s patentnim zatvaračem preko usta"),
            keywords: &[
                "lice",
                "lice s patentnim zatvaračem preko usta",
                "lice s ustima zatvorenim patentnim zatvaračem",
                "patentni zatvarač",
                "usta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc összecipzározott szájjal"),
            keywords: &["arc", "arc összecipzározott szájjal", "cipzár", "száj"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ճարմանդավոր բերանով դեմք"),
            keywords: &[
                "բերան",
                "դեմք",
                "ճարմանդ",
                "ճարմանդավոր բերանով դեմք",
                "շղթա",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan mulut tertutup rapat"),
            keywords: &[
                "muka",
                "mulut",
                "rapat",
                "tertutup",
                "wajah",
                "wajah dengan mulut tertutup rapat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu mgbachi ọnụ"),
            keywords: &["ihu", "mgbachi", "ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með rennilás fyrir munninum"),
            keywords: &[
                "andlit",
                "andlit með rennilás fyrir munninum",
                "munnur",
                "rennilás",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con bocca con cerniera"),
            keywords: &[
                "bocca cucita",
                "faccina con bocca con cerniera",
                "no comment",
                "non posso parlare",
                "zitto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("口チャック"),
            keywords: &["チャック", "口", "口チャック", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai sing leregan lambene ditutup"),
            keywords: &[
                "cangkem",
                "leregan",
                "rai",
                "rai sing leregan lambene ditutup",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ელვა-შესაკრავიანი სახე"),
            keywords: &["ელვა", "ელვა-შესაკრავიანი სახე", "პირი", "სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem d yimi ixaden"),
            keywords: &["udem d yimi ixaden"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сөйлемеу"),
            keywords: &["ауыз", "бет", "сыдырма ілгек", "сөйлемеу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med lynlåsmund"),
            keywords: &["ansigt", "ansigt med lynlåsmund", "lynlås", "mund"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខទាញខ\u{17d2}សែរ\u{17bc}តប\u{17b7}តមាត\u{17cb}"),
            keywords: &[
                "ក\u{17bb}\u{17c6}មាត\u{17cb}",
                "ប\u{17b7}ទមាត\u{17cb}",
                "មាត\u{17cb}",
                "ម\u{17bb}ខទាញខ\u{17d2}សែរ\u{17bc}តប\u{17b7}តមាត\u{17cb}",
                "រ\u{17bc}ត",
                "ស\u{17d2}ងៀមស\u{17d2}ងាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಝ\u{cbf}ಪ\u{ccd}ಪರ\u{ccd} ಬಾಯ\u{cbf}ಯ ಮುಖ"),
            keywords: &[
                "ಝ\u{cbf}ಪ\u{ccd}ಪರ\u{ccd}",
                "ಝ\u{cbf}ಪ\u{ccd}ಪರ\u{ccd} ಬಾಯ\u{cbf}ಯ ಮುಖ",
                "ಬಾಯ\u{cbf}",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지퍼로 입을 잠근 얼굴"),
            keywords: &["비밀", "얼굴", "입", "지퍼", "지퍼로 입을 잠근 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("झिपर-तो\u{902}ड च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "झिपर",
                "झिपर-तो\u{902}ड च\u{947}रो",
                "तो\u{902}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эч кимге ооз ачпайм деген бет"),
            keywords: &[
                "ачпа",
                "бет",
                "ооз",
                "сыдырма",
                "эч кимге ооз ачпайм деген бет",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("verschlossene Mond"),
            keywords: &["Gesiicht", "Mond", "Tirett", "verschlossene Mond"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຮ\u{eb9}ດຊ\u{eb4}ບປາກ"),
            keywords: &[
                "ປາກ",
                "ຮ\u{eb9}ດຊ\u{eb4}ບ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຮ\u{eb9}ດຊ\u{eb4}ບປາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su užtrauktuku vietoje burnos"),
            keywords: &[
                "burna",
                "užtrauktukas",
                "veidas",
                "veidas su užtrauktuku vietoje burnos",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar rāvējslēdzēju mutes vietā"),
            keywords: &[
                "ciet",
                "mute",
                "rāvējslēdzējs",
                "seja",
                "seja ar rāvējslēdzēju mutes vietā",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi waha-kōtui"),
            keywords: &["kanohi", "kanohi waha-kōtui", "kōtui", "waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со закопчана уста"),
            keywords: &["лице", "лице со закопчана уста", "патент", "уста"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സിപ\u{d4d}പ\u{d4d} പ\u{d42}ട\u{d4d}ടിട\u{d4d}ട മ\u{d41}ഖം"),
            keywords: &[
                "അടയ\u{d4d}\u{200c}ക\u{d4d}ക\u{d41}ക",
                "മ\u{d41}ഖം",
                "വ\u{d3e}യ",
                "സിപ\u{d4d}പ\u{d4d} പ\u{d42}ട\u{d4d}ടിട\u{d4d}ട മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амаа үдсэн царай"),
            keywords: &["амаа үдсэн", "амаа үдсэн царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तो\u{902}डाला झिप लावल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "झिप लावल\u{947}ला",
                "तो\u{902}ड",
                "तो\u{902}डाला झिप लावल\u{947}ला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka mulut berzip"),
            keywords: &["muka", "muka mulut berzip", "mulut", "zip"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’ħalq b’żipp"),
            keywords: &["wiċċ", "wiċċ b’ħalq b’żipp", "ħalq", "żipp"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "စကားမပြောဘ\u{1032} ပါးစပ\u{103a}ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "စကားမပြောဘ\u{1032} ပါးစပ\u{103a}ပ\u{102d}တ\u{103a}ထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ပါးစပ\u{103a}",
                "ပါးစပ\u{103a}ပ\u{102d}တ\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes med glidelåsmunn"),
            keywords: &["fjes", "fjes med glidelåsmunn", "glidelås", "munn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ख टालिएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "जिपर",
                "म\u{941}ख",
                "म\u{941}ख टालिएको अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met een rits als mond"),
            keywords: &["gezicht", "gezicht met een rits als mond", "mond", "rits"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes med glidelåsmunn"),
            keywords: &["fjes", "fjes med glidelåsmunn", "glidelås", "munn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3f}ପ\u{b4d}\u{200c} ଲଗ\u{b3e} ପ\u{b3e}ଟ\u{b3f} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଜ\u{b3f}ପର\u{b4d}\u{200c}",
                "ଜ\u{b3f}ପ\u{b4d}\u{200c} ଲଗ\u{b3e} ପ\u{b3e}ଟ\u{b3f} ମ\u{b41}ହ\u{b01}",
                "ପ\u{b3e}ଟ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}\u{a70}ਹ ਬ\u{a70}ਦ ਚਿਹਰਾ, ਮ\u{a42}\u{a70}ਹ ਬ\u{a70}ਦ ਰ\u{a71}ਖਣਾ"),
            keywords: &[
                "ਗ\u{a41}ਪਤ ਰ\u{a71}ਖਣਾ",
                "ਗ\u{a71}ਲ ਲ\u{a41}ਕਾਉਣਾ",
                "ਚਿਹਰਾ",
                "ਜ\u{a3c}ਿ\u{a71}ਪਰ",
                "ਭ\u{a47}ਦ ਰ\u{a71}ਖਣਾ",
                "ਮ\u{a42}\u{a70}ਹ",
                "ਮ\u{a42}\u{a70}ਹ ਬ\u{a70}ਦ ਚਿਹਰਾ, ਮ\u{a42}\u{a70}ਹ ਬ\u{a70}ਦ ਰ\u{a71}ਖਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زپرـمنہ آلی شکل"),
            keywords: &["دی شکل", "زپر", "زپرـمنہ آلی شکل", "منہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Zíp-Maut Fes"),
            keywords: &["Fes", "Maut", "Zip", "Zíp-Maut Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z zamkiem błyskawicznym na ustach"),
            keywords: &[
                "buzia na kłódkę",
                "nic nie powiem",
                "twarz z zamkiem błyskawicznym na ustach",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ځنځير د خولې مخ"),
            keywords: &["خوله", "د ځنځير د خولې مخ", "مخ", "ځنځير"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com boca de zíper"),
            keywords: &["rosto", "rosto com boca de zíper", "zíper"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com boca com fecho de correr"),
            keywords: &[
                "boca",
                "cara",
                "cara com boca com fecho de correr",
                "fecho de correr",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya ziper simipi"),
            keywords: &["simi", "uya", "uya ziper simipi", "ziper"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu fermoar la buze"),
            keywords: &[
                "buze",
                "față",
                "față cu fermoar la buze",
                "fermoar",
                "tăcere",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1010"),
            keywords: &["E10-1010"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рот на замке"),
            keywords: &[
                "закрытый",
                "лицо",
                "молчание",
                "рот",
                "рот на замке",
                "секрет",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura-igaragaza lisani ku munwa"),
            keywords: &[
                "igaragaza",
                "isura",
                "isura-igaragaza lisani ku munwa",
                "lisani ku munwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("زپ ٿيل وات وارو چهرو"),
            keywords: &["زپ ٿيل وات وارو چهرو", "زپر", "وات", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කටට ස\u{dd2}ප\u{dca} එකක\u{dca} දැම\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කට",
                "කටට ස\u{dd2}ප\u{dca} එකක\u{dca} දැම\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}ප\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár so zazipsovanými ústami"),
            keywords: &["mlčať", "tvár", "tvár so zazipsovanými ústami", "ústa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z usti v obliki zadrge"),
            keywords: &[
                "obraz",
                "obraz z usti v obliki zadrge",
                "usta",
                "zadrga",
                "zapečateno",
                "zaprto",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji af xiran"),
            keywords: &["afka", "jiinyeer", "waji", "waji af xiran", "waji-af xiran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me gojën e kyçur"),
            keywords: &[
                "fytyrë",
                "fytyrë me gojën e kyçur",
                "gojë",
                "kyç",
                "zinxhir",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са запечаћеним устима"),
            keywords: &[
                "запечаћено",
                "лице",
                "лице са запечаћеним устима",
                "рајсфершлус",
                "уста",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са запечаћеним устима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa zapečaćenim ustima"),
            keywords: &[
                "lice",
                "lice sa zapečaćenim ustima",
                "rajsferšlus",
                "usta",
                "zapečaćeno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa zapečaćenim ustima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte som tiger"),
            keywords: &["ansikte", "ansikte som tiger", "dragkedja", "hemlighet"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliofungwa mdomo kwa zipu"),
            keywords: &["mdomo", "uso", "uso uliofungwa mdomo kwa zipu", "zipu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ய\u{bcd} மூடப\u{bcd}பட\u{bcd}டுள\u{bcd}ள முகம\u{bcd}"),
            keywords: &[
                "மூடிய வ\u{bbe}ய\u{bcd}",
                "வ\u{bbe}யை மூடு",
                "வ\u{bbe}ய\u{bcd} மூடப\u{bcd}பட\u{bcd}டுள\u{bcd}ள முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd} மூடிய முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c4b}రు కట\u{c4d}ట\u{c3f} వ\u{c47}స\u{c3f}న ముఖం"),
            keywords: &[
                "న\u{c4b}రు",
                "న\u{c4b}రు కట\u{c4d}ట\u{c3f} వ\u{c47}స\u{c3f}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи дорои даҳони заҷиракдор"),
            keywords: &["даҳон", "занҷирак", "рӯи дорои даҳони заҷиракдор", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e39}ดซ\u{e34}ปปาก"),
            keywords: &["ร\u{e39}ดซ\u{e34}ป", "ร\u{e39}ดซ\u{e34}ปปาก", "หน\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("syrma agyzly ýüz"),
            keywords: &["agyz", "syrma", "syrma agyzly ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe ngutu meʻa-fakamaʻu-fusi"),
            keywords: &["mata moe ngutu meʻa-fakamaʻu-fusi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağzı fermuarlı yüz"),
            keywords: &["ağzı fermuarlı yüz", "ağız", "fermuar", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سىيرىتما چىراي"),
            keywords: &["ئېغىز", "سىيرتما", "سىيرىتما چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя із застібкою замість рота"),
            keywords: &[
                "блискавка",
                "обличчя",
                "обличчя з застібкою замість рота",
                "обличчя із застібкою замість рота",
                "рот",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ سیے ہوئے چہرہ"),
            keywords: &["سلا ہوا", "منہ", "منہ سیے ہوئے چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zi qulflangan yuz"),
            keywords: &["og‘iz", "og‘zi qulflangan yuz", "qulf", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt có miệng bị kéo khóa"),
            keywords: &["khóa kéo", "miệng", "mặt", "mặt có miệng bị kéo khóa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak gémiñ guñ fermitiir"),
            keywords: &[
                "fermitiir",
                "gémmiñ",
                "kanam",
                "kanam ak gémiñ guñ fermitiir",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuvalwe umlomo ngoziphu"),
            keywords: &[
                "ubuso",
                "ubuso obuvalwe umlomo ngoziphu",
                "umlomo",
                "uziphu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ẹni Ti A Tipa"),
            keywords: &["Oju Ẹni Ti A Tipa", "ojú", "tìpa", "ẹnu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("拉鍊嘴嘅臉"),
            keywords: &["嘴", "拉鍊", "拉鍊嘴嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拉链嘴嘅脸"),
            keywords: &["嘴", "拉链", "拉链嘴嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("闭嘴"),
            keywords: &["嘴", "脸", "闭嘴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("閉嘴"),
            keywords: &["嘴上拉鍊", "閉嘴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("拉鍊嘴嘅表情"),
            keywords: &["拉鍊嘴嘅表情", "閉口不答"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunoziphu"),
            keywords: &["ubuso", "ubuso obunoziphu", "umlomo", "uziphu"],
        },
    ],
};
#[doc = "🤨"]
pub const FACE_WITH_RAISED_EYEBROW: crate::Emoji = crate::Emoji {
    glyph: "🤨",
    codepoint: "1F928",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "face with raised eyebrow",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met geligte wenkbroue"),
            keywords: &["gesig met geligte wenkbroue", "skepties", "wantrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቅንድብ የተነሳ ፊት"),
            keywords: &["ቅንድብ የተነሳ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بحاجب مرفوع"),
            keywords: &["حاجب مرفوع", "شاكك", "وجه بحاجب مرفوع", "يشك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চেল\u{9be}উৰি দ\u{9be}ং খ\u{9be}ই থক\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "চেল\u{9be}উৰি দ\u{9be}ং খ\u{9be}ই থক\u{9be} ম\u{9c1}খ",
                "সন\u{9cd}দেহব\u{9be}দী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaşları qalxmış üz"),
            keywords: &["inamsız", "qaşları qalxmış üz", "skeptik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з узнятым брывом"),
            keywords: &["не верыць", "скептычны", "твар з узнятым брывом"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с повдигната вежда"),
            keywords: &["Лице с повдигната вежда", "недоверие", "скептично"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9cd}র\u{9c1} কোচক\u{9be}নো ম\u{9c1}খ"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "ভ\u{9cd}র\u{9c1} কোচক\u{9be}নো ম\u{9c1}খ",
                "সন\u{9cd}দেহভ\u{9be}জন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podignuta obrva"),
            keywords: &["nepovjerljiv", "podignuta obrva", "skeptičan"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb una cella aixecada"),
            keywords: &[
                "cara amb una cella aixecada",
                "desconfiada",
                "desconfiat",
                "escèptic",
                "escèptica",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛ ᎤᎵᏌᎳᏗ ᎤᎦᏖᏌᎾᎸᎢ"),
            keywords: &["ᎠᎪᎯᏳᎯ ᏂᎨᏒᎾ", "ᎤᎧᏛ ᎤᎵᏌᎳᏗ ᎤᎦᏖᏌᎾᎸᎢ", "ᎤᏜᏏᏘᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej se zvednutým obočím"),
            keywords: &[
                "nedůvěra",
                "obličej se zvednutým obočím",
                "skepse",
                "skeptický",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gydag ael wedi codi"),
            keywords: &["amheuaeth", "sgeptig", "wyneb gydag ael wedi codi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med løftet øjenbryn"),
            keywords: &["ansigt med løftet øjenbryn", "mistro", "skepsis"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit hochgezogenen Augenbrauen"),
            keywords: &[
                "Gesicht mit hochgezogenen Augenbrauen",
                "argwöhnisch",
                "skeptisch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο με σηκωμένο φρύδι"),
            keywords: &["δύσπιστος", "πρόσωπο με σηκωμένο φρύδι", "σκεπτικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with raised eyebrow"),
            keywords: &["distrust", "face with raised eyebrow", "skeptic"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["distrust", "face with raised eyebrow", "sceptic", "skeptic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con ceja alzada"),
            keywords: &["cara con ceja alzada", "desconfiado", "escéptico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kergitatud kulmudega nägu"),
            keywords: &["kergitatud kulmudega nägu", "skeptiline", "umbusaldav"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bekaina jasota duen aurpegia"),
            keywords: &["bekaina jasota duen aurpegia", "eszeptiko", "mesfidatu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت با ابروی بالاداده"),
            keywords: &["سوءظن", "شک", "شکاک", "صورت با ابروی بالاداده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kohotetut kulmakarvat"),
            keywords: &[
                "epäilevä",
                "kasvot",
                "kohotetut kulmakarvat",
                "naama",
                "skeptinen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang nakataas ang kilay"),
            keywords: &["mukhang nakataas ang kilay", "nagdududa", "walang tiwala"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við upplyftum eygnabrúni"),
            keywords: &[
                "andlit",
                "andlit við upplyftum eygnabrúni",
                "eygnabrún",
                "ivi",
                "skeptisk",
                "skeptiskur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec les sourcils relevés"),
            keywords: &["méfiant", "sceptique", "visage avec les sourcils relevés"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le mala ardaithe"),
            keywords: &[
                "aghaidh",
                "aghaidh le mala ardaithe",
                "amhras",
                "sceipteach",
                "straoiseog le mala ardaithe",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le mala togta"),
            keywords: &[
                "aodann le mala togta",
                "dì-earbsa",
                "teagamh",
                "teagamhaiche",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara cunha cella levantada"),
            keywords: &[
                "cara cunha cella levantada",
                "cella levantada",
                "desconfianza",
                "escepticismo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઊ\u{a82}ચી ભ\u{acd}રમર સાથ\u{ac7}નો ચહ\u{ac7}રો"),
            keywords: &["ઊ\u{a82}ચી ભ\u{acd}રમર સાથ\u{ac7}નો ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da ɗagaggiyar gira"),
            keywords: &[
                "fuska tare da ɗagaggiyar gira",
                "mai shakka",
                "maras aminci",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם גבות מורמות"),
            keywords: &[
                "לא מאמין",
                "מטיל ספק",
                "ספקן",
                "פקפקן",
                "פרצוף עם גבות מורמות",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तनी ह\u{941}ई भौहो\u{902} वाला च\u{947}हरा"),
            keywords: &[
                "अविश\u{94d}वासी",
                "तनी ह\u{941}ई भौहो\u{902} वाला च\u{947}हरा",
                "भौह\u{947}\u{902} तान\u{947} ह\u{941}आ च\u{947}हरा",
                "शक\u{94d}की",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s podignutom obrvom"),
            keywords: &["lice s podignutom obrvom", "nepovjerenje", "skeptično"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felhúzott szemöldökű arc"),
            keywords: &["bizalmatlan", "felhúzott szemöldökű arc", "kételkedő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրացրած հոնքով դեմք"),
            keywords: &["անհավատ", "բարձրացրած հոնքով դեմք", "կասկածանք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan alis terangkat"),
            keywords: &[
                "ragu",
                "skeptis",
                "tidak percaya",
                "wajah dengan alis terangkat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu weliri anya elu"),
            keywords: &["enweghị ntụkwasịobi", "ihu weliri anya elu", "uche ọma"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með yppta brún"),
            keywords: &["andlit með yppta brún", "efasemdir", "hissa", "vantraust"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccia con sopracciglia alzate"),
            keywords: &["diffidente", "faccia con sopracciglia alzate", "scettico"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("眉を上げた顔"),
            keywords: &["疑い", "眉を上げた顔", "顔", "驚き"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai alise siji kaangkat"),
            keywords: &["ora percaya", "rai alise siji kaangkat", "skeptis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წარბაწეული სახე"),
            keywords: &["ეჭვი", "სკეპტიკური", "უნდობლობა", "წარბაწეული სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("afus irefden iḍudan bejqen"),
            keywords: &["afus irefden iḍudan bejqen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сенбеу"),
            keywords: &["күмәндану", "сенбеу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខបង\u{17d2}ហាញការម\u{17b7}នពេញច\u{17b7}ត\u{17d2}ត"),
            keywords: &[
                "ម\u{17b7}នជឿ",
                "ម\u{17bb}ខបង\u{17d2}ហាញការម\u{17b7}នពេញច\u{17b7}ត\u{17d2}ត",
                "សង\u{17d2}ស\u{17d0}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎತ\u{ccd}ತರ\u{cbf}ಸ\u{cbf}ದ ಹುಬ\u{ccd}ಬುಳ\u{ccd}ಳ ಮುಖ"),
            keywords: &[
                "ಅಪನಂಬ\u{cbf}ಕ\u{cc6}",
                "ಎತ\u{ccd}ತರ\u{cbf}ಸ\u{cbf}ದ ಹುಬ\u{ccd}ಬುಳ\u{ccd}ಳ ಮುಖ",
                "ಸ\u{ccd}ಕ\u{cc6}ಪ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈썹을 치켜올린 얼굴"),
            keywords: &["눈썹을 치켜올린 얼굴", "불신", "의심"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उ\u{902}चायिल\u{94d}ल\u{94d}या भो\u{902}वया\u{902}चो च\u{947}रो"),
            keywords: &[
                "अविस\u{94d}वास",
                "उ\u{902}चायिल\u{94d}ल\u{94d}या भो\u{902}वया\u{902}चो च\u{947}रो",
                "उखलिल\u{94d}ल\u{94d}या भो\u{902}वया\u{902}चो च\u{947}रो",
                "स\u{902}शयी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кашын серпкен жүз"),
            keywords: &["ишенбөө", "кашын серпкен жүз", "шектенүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat gehuewenem Aperhoer"),
            keywords: &[
                "Gesiicht mat gehuewenem Aperhoer",
                "mësstrauesch",
                "skeptesch",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າພ\u{ec9}ອມຕາເບ\u{eb4}\u{ec8}ງຂ\u{eb6}\u{ec9}ນເທ\u{eb4}ງ"),
            keywords: &[
                "ບ\u{ecd}\u{ec8}ເຊ\u{eb7}\u{ec8}ອ",
                "ສ\u{ebb}ງໄສ",
                "ໜ\u{ec9}າພ\u{ec9}ອມຕາເບ\u{eb4}\u{ec8}ງຂ\u{eb6}\u{ec9}ນເທ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su pakeltais antakiais"),
            keywords: &[
                "nepasitikintis",
                "skeptiškas",
                "veidas su pakeltais antakiais",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar paceltām uzacīm"),
            keywords: &["neuzticīgs", "seja ar paceltām uzacīm", "skeptisks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi tukemata rewa"),
            keywords: &["kaitaunu", "kanohi tukemata rewa", "matakana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со крената веѓа"),
            keywords: &["лице со крената веѓа", "недоверба", "скептично"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}രികമ\u{d41}യർത\u{d4d}തിയ മ\u{d41}ഖം"),
            keywords: &[
                "അവിശ\u{d4d}വ\u{d3e}സം",
                "പ\u{d41}രികമ\u{d41}യർത\u{d4d}തിയ മ\u{d41}ഖം",
                "സംശയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөмсгөө өргөсөн царай"),
            keywords: &["хөмсгөө өргөсөн царай", "эргэлзээ", "үл итгэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भ\u{941}वई उ\u{902}च क\u{947}ल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "अविश\u{94d}वास",
                "भ\u{941}वई उ\u{902}च क\u{947}ल\u{947}ला च\u{947}हरा",
                "स\u{902}शयवादी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan kening terangkat"),
            keywords: &["muka dengan kening terangkat", "pewaham", "sangsi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’ħuġbejn imtella’"),
            keywords: &["nuqqas ta’ fiduċja", "wiċċ b’ħuġbejn imtella’", "xettiku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}ခ\u{102f}\u{1036}းတ\u{103d}န\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}ခ\u{102f}\u{1036}းတ\u{103d}န\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "သ\u{1036}သယမကင\u{103a}းတ\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hevet øyenbryn"),
            keywords: &["hevet øyenbryn", "skeptisk", "tvil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छक\u{94d}क पर\u{947}को अन\u{941}हार"),
            keywords: &[
                "अविश\u{94d}वास",
                "छक\u{94d}क पर\u{947}को अन\u{941}हार",
                "शङ\u{94d}काल\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met opgeheven wenkbrauw"),
            keywords: &["gezicht met opgeheven wenkbrauw", "sceptisch", "wantrouwen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("heva augebryn"),
            keywords: &["heva augebryn", "skeptisk", "tvil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଠ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f}ପତ\u{b3e} ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅବ\u{b3f}ଶ\u{b4d}ଵ\u{b3e}ସ",
                "ଉଠ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f}ପତ\u{b3e} ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}",
                "ସନ\u{b4d}ଦେହୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇ\u{a71}ਕ ਭਰਵ\u{a71}ਟ\u{a47} ਚ\u{a41}\u{a71}ਕਿਆ ਚਿਹਰਾ"),
            keywords: &[
                "ਇ\u{a71}ਕ ਭਰਵ\u{a71}ਟ\u{a47} ਚ\u{a41}\u{a71}ਕਿਆ ਚਿਹਰਾ",
                "ਬ\u{a47}ਵਿਸ\u{a3c}ਵਾਸ",
                "ਭਰਵ\u{a71}ਟ\u{a47} ਚ\u{a41}\u{a71}ਕਿਆ ਚਿਹਰਾ",
                "ਸ\u{a3c}\u{a71}ਕੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}ٹھدی ہوئیاں بھنواں نال شکل"),
            keywords: &["ا\u{64f}ٹھدی ہوئیاں بھنواں نال شکل", "شک کرنا", "عقیدہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Réz Ọ\u{301}p Aíbrau"),
            keywords: &[
                "Aíbrau",
                "Fes",
                "Fes Wé Réz Ọ\u{301}p Aíbrau",
                "Gẹ\u{301}t Tú Maind",
                "Nó Trọst",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z podniesioną brwią"),
            keywords: &["brew", "buźka", "sceptyczny", "twarz z podniesioną brwią"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د اوچتو شويو وريځو مخ"),
            keywords: &["بدګماني", "د اوچتو شويو وريځو مخ", "شکمن"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com sobrancelha levantada"),
            keywords: &["cético", "desconfiança", "rosto com sobrancelha levantada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com sobrancelha levantada"),
            keywords: &["cara com sobrancelha levantada", "cético", "desconfiança"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya wichasqa qhiñipa"),
            keywords: &[
                "eseptico",
                "mana iñisqa",
                "uya wichasqa qhiñipa",
                "uya wichqasqa qhiñipa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu sprânceană ridicată"),
            keywords: &["față cu sprânceană ridicată", "neîncredere", "sceptic"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1034"),
            keywords: &["E10-1034"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("не верит"),
            keywords: &[
                "не верит",
                "недоверие",
                "подозрение",
                "скептик",
                "скептически",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ifite ibitsike bihagaze"),
            keywords: &[
                "amakenga",
                "isura ifite ibitsike bihagaze",
                "umuntu ugira amakenga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اڀريل ڀرن سان چهرو"),
            keywords: &["اڀريل ڀرن سان چهرو", "بي اعتمادي", "شڪي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහළ ග\u{dd2}ය ඇහ\u{dd2} බැම\u{dd2} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අව\u{dd2}ශ\u{dca}ව\u{dcf}සය",
                "ඉහළ ග\u{dd2}ය ඇහ\u{dd2} බැම\u{dd2} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
                "සංශයව\u{dcf}දයක\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár so zdvihnutým obočím"),
            keywords: &[
                "nedôvera",
                "pochyba",
                "skeptik",
                "tvár so zdvihnutým obočím",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z dvignjenimi obrvmi"),
            keywords: &["obraz z dvignjenimi obrvmi"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji sunniyo kor u qaadan leh"),
            keywords: &["aamin darro", "shaki", "waji sunniyo kor u qaadan leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me vetull të ngritur"),
            keywords: &["fytyrë me vetull të ngritur", "skeptik, mosbesues"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са уздигнутом обрвом"),
            keywords: &["лице са уздигнутом обрвом", "неповерење", "скептично"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са уздигнутом обрвом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa uzdignutom obrvom"),
            keywords: &["lice sa uzdignutom obrvom", "nepoverenje", "skeptično"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa uzdignutom obrvom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med höjt ögonbryn"),
            keywords: &[
                "ansikte",
                "ansikte med höjt ögonbryn",
                "skeptisk",
                "tveksam",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye nyusi zilizoinuka"),
            keywords: &["kushuku", "tuhumu", "uso wenye nyusi zilizoinuka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("புருவத\u{bcd}தை உயர\u{bcd}த\u{bcd}தும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அவநம\u{bcd}பிக\u{bcd}கை",
                "சந\u{bcd}தேகம\u{bcd}",
                "புருவத\u{bcd}தை உயர\u{bcd}த\u{bcd}தும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కనుర\u{c46}ప\u{c4d}పలు ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న ముఖం"),
            keywords: &[
                "అపనమ\u{c4d}మకం",
                "కనుర\u{c46}ప\u{c4d}పలు ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న ముఖం",
                "సంద\u{c47}హ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯе, ки қошҳояш бардошта шудааст"),
            keywords: &["нобоварӣ", "рӯе, ки қошҳояш бардошта шудааст", "шаккок"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าประหลาดใจก\u{e31}บย\u{e31}กค\u{e34}\u{e49}ว"),
            keywords: &[
                "คลางแคลงใจ",
                "สงส\u{e31}ย",
                "หน\u{e49}าประหลาดใจก\u{e31}บย\u{e31}กค\u{e34}\u{e49}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaşyny galdyran ýüz"),
            keywords: &["gaşyny galdyran ýüz", "müňkür", "ynamsyzlyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe kemo mahiki"),
            keywords: &["mata moe kemo mahiki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tek kaşı çatık yüz"),
            keywords: &["güvenmeyen", "tek kaşı çatık yüz", "şüpheci"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قېشى ئۆرلىگەن چىراي"),
            keywords: &["ئىشەنمەسلىك", "قېشى ئۆرلىگەن چىراي", "گۇمان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя з піднятими бровами"),
            keywords: &["недовіра", "обличчя з піднятими бровами", "скептичний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اٹھی ہوئی بھویں والا چہرہ"),
            keywords: &["اٹھی ہوئی بھویں والا چہرہ", "بد اعتمادی", "شکی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qosh chimirilgan yuz"),
            keywords: &["qosh chimirilgan yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt với lông mày rướn lên"),
            keywords: &["hoài nghi", "mặt với lông mày rướn lên", "ngờ vực"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak buñ yëkkati yéen"),
            keywords: &["kanam ak buñ yëkkati yéen", "ñaaw-njortu", "ñàkka-wóolu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuneentshiya ezinyusiweyo"),
            keywords: &[
                "intandabuzo",
                "ubuso obuneentshiya ezinyusiweyo",
                "ukungathembi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìrun ojú ta gbé sókè"),
            keywords: &["Oníyèméjì", "Ìrun ojú ta gbé sókè", "àìgbàgbọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("眉毛升起嘅臉"),
            keywords: &["懷疑", "懷疑嘅人", "眉毛升起嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("眉毛升起嘅脸"),
            keywords: &["怀疑", "怀疑嘅人", "眉毛升起嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("挑眉"),
            keywords: &["不信任", "怀疑", "挑眉", "眉毛上挑的脸", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("挑眉驚訝"),
            keywords: &["不相信", "懷疑", "挑眉驚訝"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("單邊戚眉嘅表情"),
            keywords: &["不相信", "單邊戚眉嘅表情", "懷疑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunamashiya aphakanyisiwe"),
            keywords: &[
                "ubuso obunamashiya aphakanyisiwe",
                "ukungathembi",
                "ukunqikaza",
            ],
        },
    ],
};
#[doc = "😐"]
pub const NEUTRAL_FACE: crate::Emoji = crate::Emoji {
    glyph: "😐",
    codepoint: "1F610",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "neutral face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("neutrale gesig"),
            keywords: &["gesig", "neutraal", "neutrale gesig", "uitdrukkingloos"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ገለልተኛ ፊት"),
            keywords: &["ኮስተር ያለ", "ገለልተኛ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه محايد"),
            keywords: &["جمود", "حيادية", "لا تعليق", "وجه محايد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উদ\u{9be}সীন ম\u{9c1}খ"),
            keywords: &["উদ\u{9be}সীন", "বিভোৰ", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("neytral üz"),
            keywords: &["neytral", "soyuqqanlı", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нейтральны твар"),
            keywords: &["абыякавы", "нейтральны", "нейтральны твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Неутрално лице"),
            keywords: &["Неутрално лице", "лице", "непроницаем", "неутрален"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নিরপেক\u{9cd}ষ ম\u{9c1}খ"),
            keywords: &["নিরপেক\u{9cd}ষ", "ভ\u{9be}বলেশহীন", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("indiferentnost"),
            keywords: &["indiferentno", "indiferentnost", "lice", "neutralno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara neutra"),
            keywords: &["cara", "cara neutra", "neutral"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᎵᎪᏛᎾ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᏃᎵᎪᏛᎾ", "ᏄᏰᏥᏍᎬᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s neutrálním výrazem"),
            keywords: &[
                "kamenná tvář",
                "neutrální",
                "obličej s neutrálním výrazem",
                "smajlík",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb niwtral"),
            keywords: &["niwtral", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("neutralt ansigt"),
            keywords: &["ingen kommentar", "neutralt ansigt", "pokeransigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("neutrales Gesicht"),
            keywords: &["Gesicht", "kein Kommentar", "neutrales Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ουδέτερο πρόσωπο"),
            keywords: &["ανέκφραστο", "ουδέτερο", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("neutral face"),
            keywords: &["deadpan", "face", "meh", "neutral"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara neutral"),
            keywords: &["cara", "inexpresivo", "neutral"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "indiferente", "neutral", "neutro"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("erapooletu nägu"),
            keywords: &["erapooletu nägu", "neutraalne", "nägu", "surmtõsine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi neutrala"),
            keywords: &["aurpegi", "espresiorik gabe", "neutrala"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خنثی"),
            keywords: &["بی\u{200c}روح", "بی\u{200c}طرف", "خنثی", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama peruslukemilla"),
            keywords: &["naama", "naama peruslukemilla", "neutraali", "tunteeton"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("walang reaksyon"),
            keywords: &["mukha", "neutral", "walang emosyon", "walang reaksyon"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nevtralt andlit"),
            keywords: &["andlit", "nevtralt", "ópartískt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage neutre"),
            keywords: &["neutre", "visage neutre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage neutre"),
            keywords: &["impassible", "neutre", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog neodrach"),
            keywords: &["aghaidh neodrach", "neodrach", "straoiseog neodrach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann gun fhiamh"),
            keywords: &[
                "aodann",
                "aodann gun fhiamh",
                "bàn",
                "gun fhaireachdainn",
                "gun fhiamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara neutra"),
            keywords: &["cara", "neutra"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તટસ\u{acd}થ ચહ\u{ac7}રો"),
            keywords: &[
                "કોઈ ટિપ\u{acd}પણી નહી\u{a82}",
                "ચહ\u{ac7}રો",
                "તટસ\u{acd}થ",
                "ભાવશ\u{ac2}ન\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai tsaka-tsakanci"),
            keywords: &[
                "fuska",
                "fuska mai tsaka-tsakanci",
                "mai tsaka-tsakanci",
                "mara shige",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף חסר הבעה"),
            keywords: &["חסר הבעה", "פרצוף", "פרצוף חסר הבעה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भावहीन च\u{947}हरा"),
            keywords: &[
                "उदासीन",
                "कोई टिप\u{94d}पणी नही\u{902}",
                "च\u{947}हरा",
                "भावहीन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("neutralno lice"),
            keywords: &["bezlično", "lice", "neutralno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("semleges arc"),
            keywords: &["arc", "pókerarc", "semleges"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("չեզոք դեմք"),
            keywords: &["անվրդով", "դեմք", "չեզոք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah netral"),
            keywords: &["datar", "muka", "netral", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nkịtị"),
            keywords: &["ihu", "ihu nkịtị", "ike ọgwụgwụ", "nnọnetiti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hlutlaust andlit"),
            keywords: &["andlit", "hlutlaust andlit", "hlutleysi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina neutra"),
            keywords: &["faccina", "impassibile", "neutra", "no comment"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ポーカーフェイス"),
            keywords: &["ポーカーフェイス", "無表情", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai anteng"),
            keywords: &["anteng", "luweh", "rai", "tanpa ekspresi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნეიტრალური სახე"),
            keywords: &["ნეიტრალური", "სახე", "უემოციო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("war awal"),
            keywords: &["war awal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бәрібір"),
            keywords: &["бет", "бәрібір", "енжар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("neutralt ansigt"),
            keywords: &["ingen kommentar", "neutralt ansigt", "pokeransigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខធ\u{17d2}វើមាត\u{17cb}ស\u{17d2}មើ"),
            keywords: &[
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខធ\u{17d2}វើមាត\u{17cb}ស\u{17d2}មើ",
                "ស\u{17d2}ងៀមស\u{17d2}ងាត\u{17cb}",
                "ស\u{17d2}មើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಟಸ\u{ccd}ಥ ಮುಖ"),
            keywords: &["ತಟಸ\u{ccd}ಥ", "ನ\u{cbf}ರ\u{ccd}ಲ\u{cbf}ಪ\u{ccd}ತ", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("덤덤한 얼굴"),
            keywords: &["덤덤한 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तटस\u{94d}थ च\u{947}रो"),
            keywords: &["च\u{947}रो", "तटस\u{94d}थ", "निर\u{94d}विकार", "म\u{947}ह"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эриндерин бекем кыскан бет"),
            keywords: &["бекем", "кыс", "эрин", "эриндерин бекем кыскан бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("neutraalt Gesiicht"),
            keywords: &["Gesiicht", "neutraalt Gesiicht", "neutral", "ouni Ausdrock"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເສ\u{eb5}ຍໆ"),
            keywords: &["ເສ\u{eb5}ຍໆ", "ໜ\u{ec9}າ", "ໜ\u{ec9}າເສ\u{eb5}ຍໆ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("neutralus veidas"),
            keywords: &["neišraiškingas", "neutralus", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("neitrāla seja"),
            keywords: &[
                "bez izteiksmes",
                "neitrāla seja",
                "neitrāls",
                "neizteiksmīgs",
                "seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi kūpapa"),
            keywords: &["kanohi", "kūpapa", "whakaririka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рамнодушно лице"),
            keywords: &["лице", "неутралност", "рамнодушно лице", "рамнодушност"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നിഷ\u{d4d}\u{200c}പക\u{d4d}ഷമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "നിഷ\u{d4d}\u{200c}പക\u{d4d}ഷം",
                "നിഷ\u{d4d}\u{200c}പക\u{d4d}ഷമ\u{d3e}യ മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
                "വിക\u{d3e}രമില\u{d4d}ല\u{d3e}ത\u{d4d}ത",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төвийг сахисан царай"),
            keywords: &["төвийг сахисан царай", "төвийг сахих", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तटस\u{94d}थ च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "तटस\u{94d}थ", "निर\u{94d}विकार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka neutral"),
            keywords: &["bersahaja", "muka", "neutral"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ newtrali"),
            keywords: &["mingħajr emozzjoni", "newtrali", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မျက\u{103a}န\u{103e}ာသေ"),
            keywords: &[
                "ဘက\u{103a}မလ\u{102d}\u{102f}က\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာသေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nøytral"),
            keywords: &["fjes", "ingen kommentar", "nøytral", "stum"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तटस\u{94d}थ अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "तटस\u{94d}थ", "भावहीन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("neutraal gezicht"),
            keywords: &["gezicht", "neutraal", "uitgestreken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nøytral"),
            keywords: &["fjes", "ingen kommentar", "nøytral", "stum"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}ଧ\u{b3e}ରଣ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଭ\u{b3e}ବଶ\u{b42}ନ\u{b4d}ୟ",
                "ମ\u{b41}ହ\u{b01}",
                "ସ\u{b3e}ଧ\u{b3e}ରଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਿਰਪ\u{a71}ਖ ਚਿਹਰਾ"),
            keywords: &[
                "ਕ\u{a4b}ਈ ਟਿ\u{a71}ਪਣੀ ਨਹੀ\u{a02}",
                "ਚਿਹਰਾ",
                "ਨਿਰਪ\u{a71}ਖ",
                "ਮ\u{a41}ਰਝਾਇਆ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("غیر جانبدار شکل"),
            keywords: &["دی شکل", "غیر جانبدار", "غیر جانبدار شکل", "غیر مؤثر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Plén Fes"),
            keywords: &[
                "A Dọn Kiá Fes",
                "Fes",
                "Fes Wé Nọ\u{301} De Laf",
                "Plen",
                "Plén Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("neutralna twarz"),
            keywords: &["hm", "neutralna twarz", "nic", "nie mam zdania"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بې پلوه مخ"),
            keywords: &["بې پلوه", "بې پلوه مخ", "مخ", "ځای په ځاي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto neutro"),
            keywords: &["neutro", "rosto", "sem comentários", "sem emoção"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara neutra"),
            keywords: &["cara", "inexpressivo", "neutra", "neutro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼusaq uya"),
            keywords: &["chʼusaq uya", "kikin", "neural", "uh", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față neutră"),
            keywords: &["expresie goală", "față", "față neutră", "neutru"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-852"),
            keywords: &["E10-852"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("все равно"),
            keywords: &["все равно", "лицо", "ничего", "равнодушие"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura itinjirirwa"),
            keywords: &["ikanganye", "isura", "isura itinjirirwa", "ituje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("غير جانبدار چهرو"),
            keywords: &["غير جانبدار چهرو", "غيرجانبدار", "لٿل", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උද\u{dcf}ස\u{dd3}න ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "උද\u{dcf}ස\u{dd3}න",
                "ම\u{dd4}හ\u{dd4}ණ",
                "හැඟ\u{dd3}ම\u{dca} රහ\u{dd2}ත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("neutrálna tvár"),
            keywords: &["kamenná", "neutrálna", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nevtralni obraz"),
            keywords: &["mrtvo hladno", "nevtralni obraz", "nevtralno", "obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dhexdhexaad ah"),
            keywords: &[
                "amakaag",
                "dhexdhexaad",
                "dhimasho",
                "waji",
                "waji dhexdhexaad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë neutrale"),
            keywords: &["fytyrë", "neutral", "neutrale", "pa lëvizje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са неутралним изразом"),
            keywords: &[
                "бeзличнo",
                "лице",
                "лице са неутралним изразом",
                "нeутрaлнo",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са неутралним изразом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa neutralnim izrazom"),
            keywords: &[
                "bezlično",
                "lice",
                "lice sa neutralnim izrazom",
                "neutralno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa neutralnim izrazom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("neutralt ansikte"),
            keywords: &["ingen kommentar", "neutral", "neutralt ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliotulia"),
            keywords: &["bila hisia", "kutulia", "uso", "uso uliotulia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}யை நேர\u{bbe}க இறுக\u{bcd}கம\u{bbe}க மூடிய முகம\u{bcd}"),
            keywords: &[
                "அமைதி",
                "நடுநிலை",
                "பதில\u{bcd} இல\u{bcd}லை",
                "வ\u{bbe}யை நேர\u{bbe}க இறுக\u{bcd}கம\u{bbe}க மூடிய முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఏ భ\u{c3e}వం ల\u{c47}న\u{c3f} ముఖం"),
            keywords: &[
                "ఏ భ\u{c3e}వం ల\u{c47}న\u{c3f} ముఖం",
                "తటస\u{c4d}థ ముఖం",
                "తటస\u{c4d}థం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи нейтралӣ"),
            keywords: &["нейтралӣ", "рӯи карахт", "рӯи нейтралӣ", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าเฉยๆ"),
            keywords: &["หน\u{e49}า", "หน\u{e49}าเฉยๆ", "เฉยๆ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("syr bildirmeýän ýüz"),
            keywords: &["biparh", "syr bermeýän", "syr bildirmeýän ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata noa pē"),
            keywords: &["mata noa pē"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("duygusuz yüz"),
            keywords: &["duygusuz", "nötr", "yorum yok", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("نورمال چىراي"),
            keywords: &["ئۆلۈك", "نورمال", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя з нейтральним виразом"),
            keywords: &[
                "незворушний",
                "нейтральний",
                "обличчя",
                "обличчя з нейтральним виразом",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("غیر جانبدار چہرہ"),
            keywords: &["غیر جانبدار", "غیر جانبدار چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("his-tuyg‘usiz"),
            keywords: &["betaraf", "his-tuyg‘usiz", "hissiz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trung lập"),
            keywords: &["mặt", "mặt ngây ra bất động", "mặt trung lập", "trung lập"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu ni tekk"),
            keywords: &["fige", "kanam", "kanam gu ni tekk", "neutre"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunyutrali"),
            keywords: &["ipani elinzulu", "nyutrali", "ubuso", "ubuso obunyutrali"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú Ìbíìbí"),
            keywords: &["Ojú Ìbíìbí", "ojú", "àárín", "àìpani lẹ\u{301}rìń"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("自然嘅臉"),
            keywords: &["無表情", "臉", "自然", "自然嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("自然嘅脸"),
            keywords: &["无表情", "脸", "自然", "自然嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("冷漠"),
            keywords: &["冷漠", "脸", "面无表情"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("無語"),
            keywords: &["無語", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("無話好說"),
            keywords: &["無話好說", "無語", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obukahle"),
            keywords: &["buthule", "ubuso", "ubuso obukahle"],
        },
    ],
};
#[doc = "😑"]
pub const EXPRESSIONLESS_FACE: crate::Emoji = crate::Emoji {
    glyph: "😑",
    codepoint: "1F611",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "expressionless face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("uitdrukkinglose gesig"),
            keywords: &["gesig", "uitdrukkingloos", "uitdrukkinglose gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምንም ስሜት የሌለው ፊት"),
            keywords: &["ምንም ስሜት የሌለው ፊት", "ስሜት የለሽ", "ስሜት የማይገልጽ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بدون تعبير"),
            keywords: &["لا تعليق", "وجه بدون تعبير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অভিব\u{9cd}যক\u{9cd}তিহীন ম\u{9c1}খ"),
            keywords: &[
                "অভিব\u{9cd}যক\u{9cd}তিহীন",
                "অৰ\u{9cd}থশ\u{9c2}ণ\u{9cd}য",
                "অৰ\u{9cd}থহীন",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ifadəsiz üz"),
            keywords: &["donuq", "durğun", "ifadəsiz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("без эмоцый"),
            keywords: &["без эмоцый", "каменны", "невыразны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Безизразно лице"),
            keywords: &["Безизразно лице", "безизразен", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}বলেশহীন ম\u{9c1}খ"),
            keywords: &[
                "অর\u{9cd}থশ\u{9c2}ন\u{9cd}য",
                "অর\u{9cd}থহীন",
                "ভ\u{9be}বলেশহীন",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bezizražajnost"),
            keywords: &["bezizražajan", "bezizražajnost", "lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara inexpressiva"),
            keywords: &["cara", "inexpressiu", "inexpressiva", "inexpressió"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᏅᏓᏁᏟᏴᏒᎾ ᎤᎧᏛ"),
            keywords: &[
                "ᎤᎧᏛ",
                "ᎤᎧᏛᎢ ᏅᏓᏁᏟᏴᏒᎾ",
                "ᎤᎧᏛᎢ ᏅᏓᏁᏟᏴᏒᎾ ᎤᎧᏛ",
                "Ꮊ",
                "ᏅᏓᏁᏟᏴᏒ",
                "ᏅᏓᏁᏟᏴᏒᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej bez výrazu"),
            keywords: &[
                "bez výrazu",
                "obličej bez výrazu",
                "prázdný výraz",
                "smajlík",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb difynegiant"),
            keywords: &["ddifynegiant", "dring", "wyneb", "wyneb difynegiant"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("udtryksløst ansigt"),
            keywords: &["ingen kommentar", "pokeransigt", "udtryksløst ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ausdrucksloses Gesicht"),
            keywords: &["Gesicht", "ausdrucksloses Gesicht", "kein Kommentar"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανέκφραστο πρόσωπο"),
            keywords: &["ανέκφραστο", "πρόσωπο", "χωρίς έκφραση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("expressionless face"),
            keywords: &[
                "expressionless",
                "face",
                "inexpressive",
                "meh",
                "unexpressive",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sin expresión"),
            keywords: &[
                "cara",
                "cara sin expresión",
                "inexpresiva",
                "inexpresivo",
                "inexpresión",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara sin expresión"),
            keywords: &["cara", "cara sin expresión", "inexpresivo", "nada"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sin expresión"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sin expresión"),
            keywords: &["cara sin expresión"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ilmetu nägu"),
            keywords: &["ilmetu", "mittemidagiütlev", "nägu", "väheütlev"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("espresiorik gabeko aurpegia"),
            keywords: &["aurpegi", "espresiorik gabe", "espresiorik gabeko aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت بی\u{200c}حالت"),
            keywords: &[
                "بدون احساس",
                "بدون حالت",
                "بی\u{200c}بیان",
                "بی\u{200c}حالت",
                "صورت",
                "گنگ",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ilmeetön"),
            keywords: &["ilmeetön", "kasvot", "naama", "tunteeton", "tyhjä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("walang ekspresyon"),
            keywords: &[
                "mukha",
                "walang ekspresyon",
                "walang emosyon",
                "walang reaksyon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kensluleyst andlit"),
            keywords: &["andlit", "kensluleyst"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage sans expression"),
            keywords: &[
                "inexpressif",
                "neutre",
                "sans expression",
                "visage",
                "visage sans expression",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le haghaidh fholamh"),
            keywords: &[
                "féachaint fholamh",
                "féachaint folamh",
                "gnúis dhúrúnta",
                "straoiseog le haghaidh fholamh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann gun fhaireachdainn"),
            keywords: &[
                "aodann",
                "aodann gun fhaireachdainn",
                "bàn",
                "gun fhaireachdainn",
                "gun fhiamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara inexpresiva"),
            keywords: &["cara", "inexpresiva"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભાવશ\u{ac2}ન\u{acd}ય ચહ\u{ac7}રો"),
            keywords: &[
                "અકથનીય ચહ\u{ac7}રો",
                "કોઈ ટિપ\u{acd}પણી નહી\u{a82}",
                "ચહ\u{ac7}રો",
                "ભાવશ\u{ac2}ન\u{acd}ય ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
                "હાવભાવવિહીન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mara shige"),
            keywords: &["fuska", "fuska mara shige", "mara shige", "maras shige"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף חסר הבעה ועיניים סגורות"),
            keywords: &["חסר הבעה", "פרצוף", "פרצוף חסר הבעה ועיניים סגורות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अभिव\u{94d}यक\u{94d}तिरहित च\u{947}हरा"),
            keywords: &[
                "अभिव\u{94d}यक\u{94d}तिरहित च\u{947}हरा",
                "कोई टिप\u{94d}पणी नही\u{902}",
                "च\u{947}हरा",
                "भावश\u{942}न\u{94d}य",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bezizražajno lice"),
            keywords: &["bezizražajno", "bezlično", "lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kifejezéstelen arc"),
            keywords: &["arc", "kifejezéstelen", "semleges", "érzéketlen"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անհույզ դեմք"),
            keywords: &[
                "անարտահայտիչ",
                "անհույզ դեմք",
                "առանց էմոցիաների",
                "դեմք",
                "ոչինչ չարտահայտող",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tanpa ekspresi"),
            keywords: &["datar", "ekspresi", "lempeng", "muka", "tanpa", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu enweghị ngosipụta"),
            keywords: &[
                "egosipụtaghị",
                "emeghị ngosipụta",
                "enweghị ngosipụta",
                "ihu",
                "ihu enweghị ngosipụta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svipbrigðalaust andlit"),
            keywords: &["andlit", "engin svipbrigði", "svipbrigðalaust andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina inespressiva"),
            keywords: &["faccina", "inespressiva", "no comment"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("無表情"),
            keywords: &["無感情", "無表情", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai tanpa ekspresi"),
            keywords: &["luweh", "rai", "rai tanpa ekspresi", "tanpa ekspresi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უემოციო სახე"),
            keywords: &["არაფრის მთქმელი", "არაფრისმთქმელი", "სახე", "უემოციო"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem war asunfal"),
            keywords: &["udem war asunfal"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сезімсіз"),
            keywords: &["бет", "сезімсіз", "эмоциясыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("udtryksløst ansigt"),
            keywords: &["ingen kommentar", "pokeransigt", "udtryksløst ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខធម\u{17d2}មតាម\u{17b7}នបង\u{17d2}ហាញអារម\u{17d2}មណ\u{17cd}"),
            keywords: &[
                "ធម\u{17d2}មតា",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខធម\u{17d2}មតាម\u{17b7}នបង\u{17d2}ហាញអារម\u{17d2}មណ\u{17cd}",
                "ម\u{17bb}ខស\u{17d2}មើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭಾವನ\u{cc6}ಯ\u{cbf}ಲ\u{ccd}ಲದ ಮುಖ"),
            keywords: &[
                "ಭಾವನ\u{cc6}ಯ\u{cbf}ಲ\u{ccd}ಲದ ಮುಖ",
                "ಭಾವವ\u{cbf}ಲ\u{ccd}ಲದ",
                "ವ\u{ccd}ಯಕ\u{ccd}ತಪಡ\u{cbf}ಸಲಾರದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("무표정한 얼굴"),
            keywords: &["무표정한 얼굴", "얼굴", "포커페이스", "표정 없는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हावभाव नासपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "म\u{947}ह",
                "हा\u{902}वभावनात",
                "हावभाव नासपी",
                "हावभाव नासपी च\u{947}रो",
                "हावभावविरयत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кебелбеген бет"),
            keywords: &["бет", "кебелбе", "кебелбеген бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht ouni Ausdrock"),
            keywords: &[
                "Gesiicht",
                "Gesiicht ouni Ausdrock",
                "inexpressiv",
                "onexpressiv",
                "ouni Ausdrock",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເຢ\u{eb1}ນຊາ"),
            keywords: &[
                "ເຢ\u{eb1}ນຊາ",
                "ເສ\u{eb5}ຍໆ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເຢ\u{eb1}ນຊາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas be jokios išraiškos"),
            keywords: &[
                "be išraiškos",
                "neišraiškingas",
                "veidas",
                "veidas be jokios išraiškos",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja bez izteiksmes"),
            keywords: &[
                "bez izteiksmes",
                "neizteiksmīgs",
                "seja",
                "seja bez izteiksmes",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi whakaririka"),
            keywords: &["kanohi", "kore ngangahau", "whakaririka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице без никаков израз"),
            keywords: &["без израз", "лице", "лице без никаков израз", "монотоно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നിർവിക\u{d3e}രമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "നിർവിക\u{d3e}രമ\u{d3e}യ",
                "ഭ\u{d3e}വം",
                "ഭ\u{d3e}വം പ\u{d4d}രകടിപ\u{d4d}പിക\u{d4d}ക\u{d3e}ത\u{d4d}തത\u{d4d}",
                "ഭ\u{d3e}വശ\u{d42}ന\u{d4d}യമ\u{d3e}യ",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сэтгэл хөдлөлийн илрэлгүй царай"),
            keywords: &[
                "илрэлгүй",
                "сэтгэл хөдлөл",
                "сэтгэл хөдлөлийн илрэлгүй царай",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भावहीन च\u{947}हरा"),
            keywords: &[
                "अप\u{94d}रभावी",
                "अव\u{94d}यवहार\u{94d}य",
                "च\u{947}हरा",
                "भावहीन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka selamba"),
            keywords: &["muka", "selamba", "tiada emosi", "tiada perasaan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ mingħajr espressjoni"),
            keywords: &[
                "mingħajr espressjoni",
                "m’għandux espressjoni",
                "nieqes minn espressjoni",
                "wiċċ",
                "wiċċ mingħajr espressjoni",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခ\u{1036}စားမ\u{103e}\u{102f}မ\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ခ\u{1036}စားမ\u{103e}\u{102f}မ\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "အသက\u{103a}မပါ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("uttrykksløs"),
            keywords: &["fjes", "ingen kommentar", "nøytral", "stum", "uttrykksløs"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अभिव\u{94d}यक\u{94d}तिविहीन अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "अभिव\u{94d}यक\u{94d}तिविहीन",
                "भाव नभएको",
                "भावश\u{942}न\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("uitdrukkingsloos gezicht"),
            keywords: &[
                "geen commentaar",
                "geen uitdrukking",
                "gezicht",
                "uitdrukkingsloos",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("uttrykkslaus"),
            keywords: &["fjes", "ingen kommentar", "nøytral", "stum", "uttrykkslaus"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଭ\u{b3f}ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ବ\u{b3f}ହୀନ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅଭ\u{b3f}ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ବ\u{b3f}ହୀନ ମ\u{b41}ହ\u{b01}",
                "କୌଣସ\u{b3f} ମନ\u{b4d}ତବ\u{b4d}ୟ ନ\u{b3e}ହ\u{b3f}\u{b01}",
                "ଭ\u{b3e}ବଶ\u{b42}ନ\u{b4d}ୟ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਨਾ\u{a02} ਹਾਵ-ਭਾਵ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਕ\u{a4b}ਈ ਟਿ\u{a71}ਪਣੀ ਨਹੀ\u{a02}",
                "ਚਿਹਰਾ",
                "ਬਿਨਾ\u{a02} ਹਾਵ-ਭਾਵ",
                "ਬਿਨਾ\u{a02} ਹਾਵ-ਭਾਵ ਚਿਹਰਾ",
                "ਬਿਨਾ\u{a02} ਹਾਵ-ਭਾਵ ਵਾਲਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لا اظہاری شکل"),
            keywords: &[
                "دی شکل",
                "غ\u{64e}یر پ\u{64f}ر معنی",
                "غیر معنی خیز",
                "لا اظہاری",
                "لا اظہاری شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Nọ\u{301} Shó Ẹ\u{301}nítin Wé De Hápún To Am"),
            keywords: &[
                "Fes",
                "Fes Nọ\u{301} Shó Ẹ\u{301}nítin Wé De Hápún To Am",
                "Ẹ\u{301}mptí Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz bez wyrazu"),
            keywords: &[
                "nic",
                "nie mam zdania",
                "nie obchodzi mnie",
                "twarz bez wyrazu",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بې تاثيره مخ"),
            keywords: &["بې اثره", "بې تاثيره", "بې تاثيره مخ", "بې هيجانه", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto inexpressivo"),
            keywords: &["rosto", "rosto inexpressivo", "sem expressão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara sem expressão"),
            keywords: &[
                "cara",
                "cara sem expressão",
                "inexpressivo",
                "sem expressão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mana rimasqa uya"),
            keywords: &[
                "eh",
                "mana expresioniyuq",
                "mana rimasqa uya",
                "uya",
                "wañusqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față fără expresie"),
            keywords: &["față", "față fără expresie", "fără expresie", "inexpresiv"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-853"),
            keywords: &["E10-853"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("без эмоций"),
            keywords: &[
                "без эмоций",
                "безразличие",
                "лицо",
                "нет",
                "ничего",
                "эмоции",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura nta marangamutima"),
            keywords: &[
                "isura",
                "isura nta marangamutima",
                "kidasobanutse",
                "kitagize icyo isobanura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بغير اظهاري وارو چهرو"),
            keywords: &[
                "بغير اظهار",
                "بغير اظهاري وارو چهرو",
                "بي معني",
                "لااظهار",
                "چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හැඟ\u{dd3}මක\u{dca} පළ නොකරන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "භ\u{dcf}ව ප\u{dca}\u{200d}රක\u{dcf}ශන රහ\u{dd2}ත",
                "ම\u{dd4}හ\u{dd4}ණ",
                "හැඟ\u{dd3}මක\u{dca} පළ නොකරන ම\u{dd4}හ\u{dd4}ණ",
                "හැඟ\u{dd3}ම\u{dca} නැත\u{dd2}",
                "හැඟ\u{dd3}ම\u{dca} රහ\u{dd2}ත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bezvýrazná tvár"),
            keywords: &["bezvýrazná", "neurčitá", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("brezizrazni obraz"),
            keywords: &[
                "brezizrazni obraz",
                "brezizrazno",
                "neprizadeto",
                "obraz",
                "prazno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji aan muuqan lahayn"),
            keywords: &[
                "aan waxqabad lahayn",
                "amkaag",
                "hadal la’aan",
                "waji",
                "waji aan muuqan lahayn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë pa shprehje"),
            keywords: &[
                "fytyrë",
                "fytyrë pa shprehje",
                "nuk shprehet",
                "pa shprehje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("безизражајно лице"),
            keywords: &["бeзизрaжajнo", "бeзличнo", "безизражајно лице", "лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bezizražajno lice"),
            keywords: &["bezizražajno", "bezlično", "lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uttryckslöst ansikte"),
            keywords: &["ingen kommentar", "uttryckslöst ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliojikausha"),
            keywords: &[
                "usioeleza chochote",
                "usioonyesha hisia",
                "uso",
                "uso uliojikausha",
                "wenye kujikausha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உணர\u{bcd}ச\u{bcd}சியற\u{bcd}ற முகம\u{bcd}"),
            keywords: &[
                "உணர\u{bcd}ச\u{bcd}சி இல\u{bcd}லை",
                "உணர\u{bcd}ச\u{bcd}சியற\u{bcd}ற முகம\u{bcd}",
                "உறக\u{bcd}கம\u{bcd}",
                "பதில\u{bcd} இல\u{bcd}லை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("భ\u{c3e}వరహ\u{c3f}త ముఖం"),
            keywords: &["భ\u{c3e}వం", "భ\u{c3e}వరహ\u{c3f}త ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи беифода"),
            keywords: &["беифода", "нобурро", "ногуфтанӣ", "рӯи беифода", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าเย\u{e47}นชา"),
            keywords: &["หน\u{e49}า", "หน\u{e49}าเย\u{e47}นชา", "เฉยๆ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("duýgusyz ýüz"),
            keywords: &[
                "duýgusyny bildirmeýän",
                "duýgusyz",
                "duýgy ýok",
                "sep bildirmeýän",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata matanoa"),
            keywords: &["mata matanoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ifadesiz yüz"),
            keywords: &["ifadesiz yüz", "yorum yok", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىپادىسىز چىراي"),
            keywords: &["ئىپادىسىز", "ئىپادىلىك", "ئىپادە يوق", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя без емоцій"),
            keywords: &["без емоцій", "невиразний", "обличчя", "обличчя без емоцій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اظہار سے عاری چہرہ"),
            keywords: &["اظہار سے عاری چہرہ", "بغیر تاثر", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("his-tuyg‘usiz yuz"),
            keywords: &["his-tuyg‘usiz", "ifodasiz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt vô cảm"),
            keywords: &[
                "không diễn cảm",
                "mặt",
                "mặt vô cảm",
                "thản nhiên",
                "vô cảm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu melul nenn"),
            keywords: &[
                "bu waxul dara",
                "budul wax dara",
                "gu melul nenn",
                "kanam",
                "kanam gu melul nenn",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obungena mvakalelo"),
            keywords: &[
                "engena mvakalelo",
                "obungena mvakalelo",
                "obungenamvakalelo",
                "ubuso",
                "ubuso obungena mvakalelo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti Ko Fanimọra"),
            keywords: &[
                "Oju Ti Ko Fanimọra",
                "ojú",
                "àìfanimọ\u{301}ra",
                "àìlè sọ\u{300}rọ\u{300}",
                "àìlèsọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("無表情嘅臉"),
            keywords: &["唔客氣", "無表情", "無表情嘅臉", "無表達", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("无表情嘅脸"),
            keywords: &["唔客气", "无表情", "无表情嘅脸", "无表达", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("无语"),
            keywords: &["无语", "脸", "茫然", "面无表情"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("面無表情"),
            keywords: &["無語", "面無表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("面無表情"),
            keywords: &["無語", "面無表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obungavezi lutho"),
            keywords: &["ubuso", "ubuso obungavezi lutho", "ukungavezi lutho"],
        },
    ],
};
#[doc = "😶"]
pub const FACE_WITHOUT_MOUTH: crate::Emoji = crate::Emoji {
    glyph: "😶",
    codepoint: "1F636",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "face without mouth",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig sonder mond"),
            keywords: &["gesig", "gesig sonder mond", "mond", "stil"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፍ የሌለው ፊት"),
            keywords: &["አፍ", "አፍ የሌለው ፊት", "ዝም ያለ", "ጸጥታ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بدون فم"),
            keywords: &["بدون فم", "وجه بدون فم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খবিহীন চেহেৰ\u{9be}"),
            keywords: &[
                "নিঃশব\u{9cd}দ",
                "ম\u{9c1}খ",
                "ম\u{9c1}খবিহীন চেহেৰ\u{9be}",
                "শ\u{9be}ন\u{9cd}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağızsız üz"),
            keywords: &["ağız", "ağızsız üz", "sakit", "səssiz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар без рота"),
            keywords: &["маўклівы", "рот", "твар без рота", "ціхі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице без уста"),
            keywords: &["Лице без уста", "лице", "тих", "уста"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খ ছ\u{9be}ড\u{9bc}\u{9be}ই ম\u{9c1}খমণ\u{9cd}ডল"),
            keywords: &[
                "ঠো\u{981}ট",
                "নীরব",
                "ম\u{9c1}খ",
                "ম\u{9c1}খ ছ\u{9be}ড\u{9bc}\u{9be}ই ম\u{9c1}খমণ\u{9cd}ডল",
                "শ\u{9be}ন\u{9cd}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lice bez usta"),
            keywords: &["lice", "lice bez usta", "tiho", "usta", "šutnja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara sense boca"),
            keywords: &[
                "callada",
                "callat",
                "cara",
                "cara sense boca",
                "sense boca",
                "silenci",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᏄᏠᏯᏍᏛᎾ ᎠᏲᎵ"),
            keywords: &["ᎠᎰᎵ", "ᎡᏠᏪ", "ᎡᏠᏪᎢ", "ᎤᎧᏛ", "ᎤᎧᏛᎢ ᏄᏠᏯᏍᏛᎾ ᎠᏲᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej bez úst"),
            keywords: &[
                "obličej bez úst",
                "smajlík",
                "tichý",
                "tvář",
                "výraz",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb heb geg"),
            keywords: &["ceg", "distaw", "wyneb", "wyneb heb geg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt uden mund"),
            keywords: &["ansigt", "ansigt uden mund", "mund", "stille", "tavs"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht ohne Mund"),
            keywords: &["Gesicht", "Gesicht ohne Mund", "kein Mund", "sprachlos"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο χωρίς στόμα"),
            keywords: &[
                "ήσυχος",
                "πρόσωπο",
                "πρόσωπο χωρίς στόμα",
                "σιωπηλός",
                "στόμα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face without mouth"),
            keywords: &["face", "face without mouth", "mouth", "quiet", "silent"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sin boca"),
            keywords: &["boca", "callado", "cara", "cara sin boca", "silencio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ilma suuta nägu"),
            keywords: &["ilma suuta nägu", "nägu", "suu", "vaikne", "vaikus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ahorik gabeko aurpegia"),
            keywords: &[
                "aho",
                "ahorik gabeko aurpegia",
                "aurpegi",
                "isilik",
                "isiltasun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت بدون لب"),
            keywords: &[
                "آرام",
                "بی\u{200c}صدا",
                "دهان",
                "ساکت",
                "صورت",
                "صورت بدون لب",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama ilman suuta"),
            keywords: &["hiljaa", "hiljainen", "naama", "naama ilman suuta", "suu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang walang bibig"),
            keywords: &[
                "hindi nagsasalita",
                "mukha",
                "mukhang walang bibig",
                "tahimik",
                "walang bibig",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit uttan munn"),
            keywords: &["andlit", "andlit uttan munn", "munn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage sans bouche"),
            keywords: &["muet", "visage sans bouche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage sans bouche"),
            keywords: &[
                "muet",
                "sans bouche",
                "silence",
                "silencieux",
                "visage",
                "visage sans bouche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog gan bhéal"),
            keywords: &["aghaidh gan bhéal", "straoiseog gan bhéal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann gun bheul"),
            keywords: &["aodann", "aodann gun bheul", "beul", "sàmhach", "tost"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara sen boca"),
            keywords: &["boca", "calar", "cara", "cara sen boca", "silencio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મો\u{a82}ઢા વગરનો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
                "મો\u{a82}ઢા વગરનો",
                "મો\u{a82}ઢા વગરનો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska ban da baki"),
            keywords: &["baki", "fuska", "fuska ban da baki", "mai shiru", "shiru"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף ללא פה"),
            keywords: &["פה", "פרצוף", "פרצוף בלי פה", "פרצוף ללא פה", "שותק", "שקט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिना म\u{941}\u{901}ह का च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "बिना म\u{941}\u{901}ह का च\u{947}हरा",
                "म\u{941}\u{902}ह रहित",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice bez usta"),
            keywords: &["bezglasno", "lice", "lice bez usta", "tiho", "usta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("száj nélküli arc"),
            keywords: &["arc", "csendes", "nincs szája", "néma", "száj nélküli arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("առանց բերանի դեմք"),
            keywords: &["առանց բերանի դեմք", "բերան", "դեմք", "լուռ", "հանգիստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tanpa mulut"),
            keywords: &[
                "diam",
                "muka",
                "mulut",
                "tenang",
                "wajah",
                "wajah tanpa mulut",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu enweghị ọnụ"),
            keywords: &["ihu", "ihu enweghị ọnụ", "nwayọ", "ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit án munns"),
            keywords: &["andlit", "andlit án munns", "enginn munnur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina senza bocca"),
            keywords: &[
                "faccina",
                "faccina senza bocca",
                "non posso parlare",
                "senza bocca",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("口のない顔"),
            keywords: &["だんまり", "口なし", "口のない顔", "沈黙", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai tanpa cangkem"),
            keywords: &["anteng", "cangkem", "meneng", "rai", "rai tanpa cangkem"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უპირო სახე"),
            keywords: &["პირი", "სახე", "სიჩუმე", "სიწყნარე", "უპირო სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ulac imi"),
            keywords: &["ulac imi"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аузы жоқ бет"),
            keywords: &["аузы жоқ бет", "ауыз", "бет", "тыныш", "үнсіз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt uden mund"),
            keywords: &["ansigt", "ansigt uden mund", "mund", "stille", "tavs"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខមានតែភ\u{17d2}នកអត\u{17cb}មាត\u{17cb}"),
            keywords: &[
                "នៅស\u{17d2}ងៀម",
                "មាត\u{17cb}",
                "ម\u{17bb}ខមានតែភ\u{17d2}នកអត\u{17cb}មាត\u{17cb}",
                "អត\u{17cb}ន\u{17b7}យាយ",
                "អត\u{17cb}មាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಯ\u{cbf}ಯ\u{cbf}ಲ\u{ccd}ಲದ ಮುಖ"),
            keywords: &[
                "ಬಾಯ\u{cbf}",
                "ಬಾಯ\u{cbf}ಯ\u{cbf}ಲ\u{ccd}ಲದ ಮುಖ",
                "ಮುಖ",
                "ಮ\u{ccc}ನ",
                "ಸ\u{ccd}ತಬ\u{ccd}ಧ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("입이 없는 얼굴"),
            keywords: &["얼굴", "입 없음", "입이 없는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तो\u{902}डाशिवाय च\u{947}रो"),
            keywords: &[
                "ओग\u{94d}गी",
                "च\u{947}रो",
                "तो\u{902}ड",
                "तो\u{902}डा शिवाय च\u{947}रो",
                "तो\u{902}डाशिवाय च\u{947}रो",
                "थ\u{902}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оозу жок бет"),
            keywords: &["акырын", "бет", "ооз", "оозу жок бет", "тынч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht ouni Mond"),
            keywords: &["Gesiicht", "Gesiicht ouni Mond", "Mond", "roueg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າບ\u{ecd}\u{ec8}ມ\u{eb5}ປາກ"),
            keywords: &[
                "ບ\u{ecd}\u{ec8}ມ\u{eb5}ປາກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າບ\u{ecd}\u{ec8}ມ\u{eb5}ປາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas be burnos"),
            keywords: &["burna", "tylus", "veidas", "veidas be burnos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja bez mutes"),
            keywords: &["kluss", "mute", "seja", "seja bez mutes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi kore waha"),
            keywords: &["hū", "kanohi", "kanohi kore waha", "ngū", "waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице без уста"),
            keywords: &["лице", "лице без уста", "молчи", "тивко", "уста"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}യയില\u{d4d}ല\u{d3e}ത\u{d4d}ത മ\u{d41}ഖം"),
            keywords: &[
                "കണ\u{d4d}ണ\u{d4d}",
                "നിശബ\u{d4d}\u{200c}ദം",
                "മ\u{d41}ഖം",
                "മ\u{d57}നം",
                "വ\u{d3e}യ",
                "വ\u{d3e}യയില\u{d4d}ല\u{d3e}ത\u{d4d}ത മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амгүй царай"),
            keywords: &["амгүй", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{942}क च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "तो\u{902}ड",
                "तो\u{902}ड नसल\u{947}ला च\u{947}हरा",
                "म\u{942}क",
                "शा\u{902}त",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tanpa mulut"),
            keywords: &["muka", "muka tanpa mulut", "mulut", "senyap", "tenang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ mingħajr ħalq"),
            keywords: &["kwieta", "siekta", "wiċċ", "wiċċ mingħajr ħalq", "ħalq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပါးစပ\u{103a}မပါသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ငြ\u{102d}မ\u{103a}သက\u{103a}ခြင\u{103a}း",
                "တ\u{102d}တ\u{103a}ဆ\u{102d}တ\u{103a}ခြင\u{103a}း",
                "ပါးစပ\u{103a}",
                "ပါးစပ\u{103a}မပါသော မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("uten munn"),
            keywords: &["fjes", "ingen munn", "uten munn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}खबिनाको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "च\u{941}प",
                "म\u{941}ख",
                "म\u{941}खबिनाको अन\u{941}हार",
                "शान\u{94d}त",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht zonder mond"),
            keywords: &["gezicht", "gezicht zonder mond", "mond", "rustig", "stil"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("utan munn"),
            keywords: &["fjes", "ingen munn", "utan munn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଟ\u{b3f} ନଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଚ\u{b41}ପ\u{b4d}\u{200c} ର\u{b41}ହ",
                "ପ\u{b3e}ଟ\u{b3f}",
                "ପ\u{b3e}ଟ\u{b3f} ନଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
                "ଶ\u{b3e}ନ\u{b4d}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਨਾ\u{a02} ਮ\u{a42}\u{a70}ਹ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਬਿਨਾ\u{a02} ਮ\u{a42}\u{a70}ਹ ਚਿਹਰਾ",
                "ਬਿਨਾ\u{a02} ਮ\u{a42}\u{a70}ਹ ਵਾਲਾ ਚਿਹਰਾ",
                "ਮ\u{a42}\u{a70}ਹ ਨਹੀ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ دے بغیر شکل"),
            keywords: &["خاموش", "دی شکل", "منہ", "منہ دے بغیر شکل", "چ\u{64f}پ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Nọ\u{301} Gẹ\u{301}t Maut"),
            keywords: &[
                "Fes",
                "Fes Wé Nọ\u{301} Gẹ\u{301}t Maut",
                "Kwáyẹt",
                "Maut",
                "Saílẹnt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz bez ust"),
            keywords: &["buźka", "cisza", "nic nie mówię", "twarz bez ust"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پرته له خولې مخ"),
            keywords: &["خله", "غلې", "مخ", "پرته له خولې مخ", "په قلاره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto sem boca"),
            keywords: &["calado", "quieto", "rosto", "rosto sem boca", "sem boca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara sem boca"),
            keywords: &["boca", "calado", "cara", "cara sem boca", "silencioso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya mana simiyuqwan"),
            keywords: &["chʼin", "simi", "uya", "uya mana simiyuqwan", "ñañiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față fără gură"),
            keywords: &["față", "față fără gură", "gură", "liniște", "tăcut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-890"),
            keywords: &["E10-890"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лицо без рта"),
            keywords: &["без рта", "лицо без рта", "молчание", "тихо", "тишина"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura idafite umunwa"),
            keywords: &["isura", "isura idafite umunwa", "ucecetse", "umunwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بغير وات وارو چهرو"),
            keywords: &["بغير وات وارو چهرو", "خاموش", "وات", "چهرو", "چپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කටක\u{dca} රහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කට",
                "කටක\u{dca} රහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ",
                "න\u{dd2}ශ\u{dca}ශබ\u{dca}ද",
                "න\u{dd2}හඬ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár bez úst"),
            keywords: &["nemá", "tichá", "tvár", "tvár bez úst", "ústa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz brez ust"),
            keywords: &["molčeče", "obraz", "obraz brez ust", "tiho", "usta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji af la’aan"),
            keywords: &["aamusnaan", "afka", "waji", "waji af la’aan", "xasilloon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë pa gojë"),
            keywords: &["e heshtur", "e qetë", "fytyrë", "fytyrë pa gojë", "gojë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице без уста"),
            keywords: &[
                "без речи",
                "лице",
                "лице без уста",
                "нечујно",
                "тихo",
                "уста",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице без уста"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice bez usta"),
            keywords: &[
                "bez reči",
                "lice",
                "lice bez usta",
                "nečujno",
                "tiho",
                "usta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice bez usta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte utan mun"),
            keywords: &["ansikte utan mun", "ingen mun"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso bila mdomo"),
            keywords: &["kimya", "kunyamaza", "mdomo", "uso", "uso bila mdomo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ய\u{bcd} இல\u{bcd}ல\u{bbe}த முகம\u{bcd}"),
            keywords: &[
                "முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd} இல\u{bcd}ல\u{bbe}த முகம\u{bcd}",
                "வ\u{bbe}ய\u{bcd} இல\u{bcd}ல\u{bbe}தது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}శ\u{c4d}శబ\u{c4d}ద\u{c3e}న\u{c4d}న\u{c3f} సూచ\u{c3f}ంచ\u{c47} ముఖం"),
            keywords: &[
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}దం",
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}ద\u{c3e}న\u{c4d}న\u{c3f} సూచ\u{c3f}ంచ\u{c47} ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи бедаҳон"),
            keywords: &["бесадо", "даҳон", "рӯи бедаҳон", "рӯй", "хомӯш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าไม\u{e48}ม\u{e35}ปาก"),
            keywords: &[
                "หน\u{e49}า",
                "หน\u{e49}าไม\u{e48}ม\u{e35}ปาก",
                "ไม\u{e48}ม\u{e35}ปาก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("agyzsyz ýüz"),
            keywords: &["agyz", "agyzsyz ýüz", "sessiz", "ýuwaş", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata taʻengutu"),
            keywords: &["mata", "mata taʻengutu", "ngutu", "ʻikai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağzı olmayan yüz"),
            keywords: &["ağzı olmayan yüz", "ağız", "sakin", "sessiz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىزسىز چىراي"),
            keywords: &["ئېغىز", "ئېغىزسىز چىراي", "تىنچ", "جىم", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя без рота"),
            keywords: &["беззвучно", "обличчя", "обличчя без рота", "рот", "тихо"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بغیر منہ والا چہرہ"),
            keywords: &["بغیر منہ والا چہرہ", "خاموشی", "منہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘izsiz yuz"),
            keywords: &["jimjit", "og‘iz", "og‘izsiz yuz", "sukut", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt không có miệng"),
            keywords: &["miệng", "mặt", "mặt không có miệng", "yên lặng", "ít nói"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu amul gémmiñ"),
            keywords: &[
                "cellaaral",
                "gémmiñ",
                "kanam",
                "kanam gu amul gémmiñ",
                "tekk",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obungenamlomo"),
            keywords: &["cwaka", "thuleyo", "ubuso", "ubuso obungenamlomo", "umlomo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tí kò ní Ẹnu"),
            keywords: &["Ojú tí kò ní Ẹnu", "dáké", "ojú", "ẹnu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("無咀嘅臉"),
            keywords: &["嘴", "無咀嘅臉", "無聲", "臉", "靜"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("无咀嘅脸"),
            keywords: &["嘴", "无咀嘅脸", "无声", "脸", "静"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("沉默"),
            keywords: &["嘴", "安静", "沉默", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("沉默"),
            keywords: &["沉默", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("無言嘅表情"),
            keywords: &["無言嘅表情", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obungenamlomo"),
            keywords: &["ubuso", "ubuso obungenamlomo", "ukuthula", "umlomo"],
        },
    ],
};
#[doc = "😶\u{200d}🌫\u{fe0f}"]
pub const FACE_IN_CLOUDS: crate::Emoji = crate::Emoji {
    glyph: "😶\u{200d}🌫\u{fe0f}",
    codepoint: "1F636 200D 1F32B FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "face in clouds",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "😶\u{200d}🌫",
        codepoint: "1F636 200D 1F32B",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "face in clouds",
        group: "Smileys & Emotion",
        subgroup: "face-neutral-skeptical",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig in wolke"),
            keywords: &[
                "deur die mis",
                "gesig in wolke",
                "kop in die wolke",
                "lugkastele",
                "verstrooid",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደመናማ ገጽ"),
            keywords: &["ደመናማ ገጽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه في الغيوم"),
            keywords: &[
                "رأس في الغيوم",
                "شارد الذهن",
                "وجه في الضباب",
                "وجه في الغيوم",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেঘত ম\u{9c1}খ"),
            keywords: &[
                "অমনোযোগী",
                "ক\u{9c1}\u{981}ৱলীত ম\u{9c1}খ",
                "মেঘত ম\u{9c1}খ",
                "মেঘত ম\u{9c2}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buludlu üz"),
            keywords: &["bulud", "buludlu baş", "buludlu üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар у аблоках"),
            keywords: &[
                "галава ў аблоках",
                "рассеяны",
                "твар у аблоках",
                "твар у тумане",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лице в облаци"),
            keywords: &["лице в мъгла", "лице в облаци", "мечтател", "разсеян"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেঘে ম\u{9c1}খ"),
            keywords: &["মেঘে ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lice u oblacima"),
            keywords: &[
                "glava u oblacima",
                "lice u magli",
                "lice u oblacima",
                "rasijan",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara entre núvols"),
            keywords: &[
                "cap als núvols",
                "cara entre núvols",
                "distracció",
                "distret",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej v oblacích"),
            keywords: &[
                "duchem nepřítomný",
                "hlava v oblacích",
                "nepřítomný",
                "obličej v mlze",
                "obličej v oblacích",
                "smajlík",
                "tvář",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb mewn cymylau"),
            keywords: &[
                "anghofus",
                "pen mewn cymylau",
                "wyneb mewn cymylau",
                "wyneb yn y niwl",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt i sky"),
            keywords: &[
                "ansigt i sky",
                "fraværende",
                "hovedet i skyerne",
                "tåget",
                "ukoncentreret",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht in Wolken"),
            keywords: &["Gesicht in Wolken"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Kopf in den Wolken"),
            keywords: &["Kopf in den Wolken"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο στα σύννεφα"),
            keywords: &[
                "αφηρημένος",
                "κεφάλι στα σύννεφα",
                "πρόσωπο στα σύννεφα",
                "πρόσωπο στην ομίχλη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face in clouds"),
            keywords: &[
                "absentminded",
                "face in clouds",
                "face in the fog",
                "head in clouds",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "absent-minded",
                "face in clouds",
                "face in the fog",
                "head in clouds",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &[
                "absent-minded",
                "face in clouds",
                "face in the fog",
                "head in clouds",
            ],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara en las nubes"),
            keywords: &[
                "atontado",
                "cara",
                "cara en las nubes",
                "despistado",
                "distraído",
                "nubes",
                "parra",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cara en las nubes"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nägu pilvedes"),
            keywords: &["hajameelne", "nägu pilvedes", "nägu udus", "pea pilvedes"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hodei artean dagoen aurpegia"),
            keywords: &[
                "adigalkorra",
                "hodei artean dagoen aurpegia",
                "izarrei begira dagoen aurpegia",
                "laino artean dagoen aurpegia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورتک میان ابر"),
            keywords: &[
                "حواس\u{200c}پرت",
                "سر در میان ابرها",
                "صورتک در مه",
                "صورتک میان ابر",
                "صورتک میان ابرها",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naama pilvissä"),
            keywords: &[
                "hajamielinen",
                "naama pilvissä",
                "naama sumussa",
                "pää pilvissä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang nasa ulap"),
            keywords: &["mukhang nasa ulap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit í skýggjum"),
            keywords: &["andlit í skýggjum", "burtur í øðrum heimi", "hugspjaddur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage dans les nuages"),
            keywords: &[
                "brouillard",
                "dans les nuages",
                "distrait",
                "visage dans le brouillard",
                "visage dans les nuages",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage dans les nuages"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh sna scamaill"),
            keywords: &[
                "aghaidh sa cheo",
                "aghaidh sna scamaill",
                "ceann sna scamaill",
                "dearmadach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodan sna neòil"),
            keywords: &["air seachran", "ann an ceò", "aodan sna neòil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara nas nubes"),
            keywords: &["apampado", "cara nas nubes", "distraído", "nas nubes"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળમા\u{a82} ચહ\u{ac7}રો"),
            keywords: &[
                "ધ\u{ac1}મ\u{acd}મસમા\u{a82} ચહ\u{ac7}રો",
                "વાદળમા\u{a82} ચહ\u{ac7}રો",
                "વાદળોમા\u{a82} ચહ\u{ac7}રો",
                "શ\u{ac2}ન\u{acd}યમનસ\u{acd}ક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף בעננים"),
            keywords: &[
                "בעננים",
                "בערפל",
                "חולמני",
                "מפוזר",
                "פרצוף בעננים",
                "ראש בעננים",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बादलो\u{902} म\u{947}\u{902} च\u{947}हरा"),
            keywords: &["बादलो\u{902} म\u{947}\u{902} च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice u oblacima"),
            keywords: &[
                "glava u oblacima",
                "lice u magli",
                "lice u oblacima",
                "zaboravnost",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc a felhőben"),
            keywords: &["arc a felhőben"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեմք ամպերի մեջ"),
            keywords: &[
                "գլուխ ամպերի մեջ",
                "դեմք ամպերի մեջ",
                "դեմք մառախուղի մեջ",
                "ցրված",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit í skýjum"),
            keywords: &[
                "andlit í skýjum",
                "andlit í þoku",
                "annarshugar",
                "höfuð í skýjum",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("testa tra le nuvole"),
            keywords: &["testa tra le nuvole"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雲の中の顔"),
            keywords: &[
                "うわの空",
                "ぼんやり",
                "夢中",
                "放心状態",
                "雲の中の顔",
                "顔",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ora dong"),
            keywords: &[
                "lalenan",
                "rai ora dong",
                "rai ora mudeng",
                "sirah ora dong",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე ღრუბლებში"),
            keywords: &["გაფანტული", "სახე", "სახე ღრუბლებში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бұлт басқан бет"),
            keywords: &["бұлт басқан бет"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខនៅក\u{17d2}ន\u{17bb}ងពពក"),
            keywords: &[
                "ក\u{17d2}បាលនៅក\u{17d2}ន\u{17bb}ងពពក",
                "ម\u{17bb}ខនៅក\u{17d2}ន\u{17bb}ងពពក",
                "ម\u{17bb}ខនៅក\u{17d2}ន\u{17bb}ងអ\u{17d0}ព\u{17d2}ទ",
                "ស\u{17d2}ល\u{17bb}ងអារម\u{17d2}មណ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೋಡಗಳಲ\u{ccd}ಲ\u{cbf} ಮುಖ"),
            keywords: &[
                "ಮಬ\u{ccd}ಬು ಆವರ\u{cbf}ಸ\u{cbf}ದ ಮುಖ",
                "ಮಾನಸ\u{cbf}ಕವಾಗ\u{cbf} ಕಳ\u{cc6}ದುಹೋಗ\u{cbf}ರುವುದು",
                "ಮೋಡಗಳಲ\u{ccd}ಲ\u{cbf} ತಲ\u{cc6}",
                "ಮೋಡಗಳಲ\u{ccd}ಲ\u{cbf} ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공상에 잠긴 얼굴"),
            keywords: &[
                "공상에 잠긴 얼굴",
                "멍",
                "멍청한 얼굴",
                "멍함",
                "안개 속 얼굴",
                "엉뚱한 생각에 잠긴 얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{942}पा\u{902}त आशिल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "क\u{942}पा\u{902}त आशिल\u{94d}लो च\u{947}रो",
                "तकली क\u{942}पा\u{902}त आशिल\u{94d}लो",
                "तकली जाग\u{94d}यार ना",
                "ध\u{941}क\u{94d}या\u{902}त आशिल\u{94d}लो च\u{947}रो",
                "मन थाऱ\u{94d}यार नाशिल\u{94d}लो",
                "लक\u{94d}ष नाशिल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("булуттагы жүз"),
            keywords: &[
                "булут каптаган жүз",
                "булуттагы жүз",
                "ойго чөккөн",
                "туман баскан жүз",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າໃນເມກ"),
            keywords: &[
                "ຫ\u{ebb}ວໃນເມກ",
                "ໃຈລອຍ",
                "ໜ\u{ec9}າໃນເມກ",
                "ໜ\u{ec9}າໃນໝອກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas debesyse"),
            keywords: &["galva debesyse", "veidas debesyse", "veidas rūke"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja mākoņos"),
            keywords: &["galva mākoņos", "pārdomas", "seja miglā", "seja mākoņos"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице во облаци"),
            keywords: &[
                "глава во облаци",
                "лице во магла",
                "лице во облаци",
                "отсутен со паметот",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മേഘങ\u{d4d}ങളിൽ മ\u{d41}ഖം"),
            keywords: &["മേഘങ\u{d4d}ങളിൽ മ\u{d41}ഖം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алмайрсан царай"),
            keywords: &[
                "алмайрсан",
                "алмайрсан царай",
                "манантай царай",
                "үүлтэй царай",
                "үүлэн дундах толгой",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ढगा\u{902}मध\u{94d}य\u{947} च\u{947}हरा"),
            keywords: &[
                "ढगा\u{902}मध\u{94d}य\u{947} च\u{947}हरा",
                "ढगा\u{902}मध\u{94d}य\u{947} डोक\u{902}",
                "ध\u{941}क\u{94d}यात च\u{947}हरा",
                "विसरभोळा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dikepung awan"),
            keywords: &["muka dikepung awan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102d}မ\u{103a}ထ\u{1032}က မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "တ\u{102d}မ\u{103a}ထ\u{1032}က မျက\u{103a}န\u{103e}ာ",
                "တ\u{102d}မ\u{103a}ထ\u{1032}က ဦးခေါင\u{103a}း",
                "မေ\u{1037}တတ\u{103a}သော",
                "မြ\u{1030}ခ\u{102d}\u{102f}းထ\u{1032}က မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes i skyer"),
            keywords: &["distré", "fjes i skyer", "fraværende", "uoppmerksom"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बादलमा अन\u{941}हार"),
            keywords: &[
                "क\u{941}हिरोमा अन\u{941}हार",
                "ध\u{94d}यान नदिन\u{947}",
                "बादलमा अन\u{941}हार",
                "बादलमा टाउको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht in de wolken"),
            keywords: &[
                "afwezig",
                "gezicht in de mist",
                "gezicht in de wolken",
                "hoofd in de wolken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes i skyer"),
            keywords: &["distré", "fjes i skyer", "fråverande", "uoppmerksam"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେଘରେ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &["ମେଘରେ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਚਿਹਰਾ"),
            keywords: &[
                "ਗ\u{a48}ਰਹਾਜ\u{a3c}ਰ",
                "ਧ\u{a41}\u{a70}ਦ ਵਿ\u{a71}ਚ ਚਿਹਰਾ",
                "ਬ\u{a71}ਦਲ ਵਿ\u{a71}ਚ ਸਿਰ",
                "ਬ\u{a71}ਦਲਾ\u{a02} ਵਿ\u{a71}ਚ ਚਿਹਰਾ",
                "ਸ\u{a4b}ਚ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin De Sí Pípul Fes Fọ Klaud"),
            keywords: &[
                "Kọnfúshọn Hól Pẹ\u{301}sin",
                "Pésín Maind Nọ\u{301} Dé Dia",
                "Pẹ\u{301}sin De Sí Pípul Fes Fọ Klaud",
                "Yu De Tínk Sọ\u{301}mtin Bọt Yọ Maind De Dú Anọ\u{301}dá Tin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz w chmurach"),
            keywords: &[
                "bujać w obłokach",
                "głowa w chmurach",
                "twarz w chmurach",
                "zamyślenie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په وريځو مخ"),
            keywords: &[
                "سر په ورېځو کې",
                "غیرحاضر",
                "په وريځو مخ",
                "په وريځو کې مخ",
                "په ګند کې مخ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto nas nuvens"),
            keywords: &[
                "cabeça nas nuvens",
                "distraído",
                "rosto nas nuvens",
                "rosto no nevoeiro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara nas nuvens"),
            keywords: &[
                "cabeça nas nuvens",
                "cara nas nuvens",
                "cara no nevoeiro",
                "distraído",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya phuyukunapi"),
            keywords: &["chaqrusqa uya", "payu", "phuñusqa uma", "uya phuyukunapi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față în nori"),
            keywords: &["absent", "capul în nori", "față în ceață", "față în nori"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-007"),
            keywords: &["E13.1-007"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лицо в облаках"),
            keywords: &[
                "беззаботный",
                "витающий в облаках",
                "голова в облаках",
                "лицо в облаках",
                "лицо в тумане",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بادلن ۾ چهرو"),
            keywords: &["بادلن ۾ مٿو", "بادلن ۾ چهرو", "غافل", "ڌنڌ ۾ چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වල\u{dcf}ක\u{dd4}ළ\u{dd4}වල ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd3}ද\u{dd4}මෙහ\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
                "වල\u{dcf}ක\u{dd4}ළ\u{dd4}වල ම\u{dd4}හ\u{dd4}ණ",
                "වල\u{dcf}ක\u{dd4}ළ\u{dd4}වල හ\u{dd2}ස",
                "ස\u{dd2}හ\u{dd2} කල\u{dca}පන\u{dcf}ව අඩ\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár v\u{a0}oblakoch"),
            keywords: &[
                "hlava v\u{a0}oblakoch",
                "neprítomná",
                "nesústredená",
                "tvár v\u{a0}hmle",
                "tvár v\u{a0}oblakoch",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz v oblakih"),
            keywords: &[
                "glava v oblakih",
                "obraz v megli",
                "obraz v oblakih",
                "odsoten",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji daruuro ku jira"),
            keywords: &[
                "madax daruur ku jira",
                "maqane-jooga",
                "waji ciiro ku jira",
                "waji daruur ku jira",
                "waji daruuro ku jira",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë në re"),
            keywords: &[
                "fytyrë në mjegull",
                "fytyrë në re",
                "i hutuar",
                "kokë në re",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице у облацима"),
            keywords: &["лице у облацима"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице у облацима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice u oblacima"),
            keywords: &["lice u oblacima"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice u oblacima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte i moln"),
            keywords: &["ansikte i moln", "disträ", "glömsk", "tanksprid"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso kwenye mawingu"),
            keywords: &[
                "fikra za mbali",
                "kichwa katika mawingu",
                "uso katika mawingu",
                "uso kwa ukungu",
                "uso kwenye mawingu",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேகங\u{bcd}களில\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "நினைவிழந\u{bcd}த நிலை",
                "மூடுபனியில\u{bcd} முகம\u{bcd}",
                "மேகங\u{bcd}களில\u{bcd} தலை",
                "மேகங\u{bcd}களில\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c47}ఘ\u{c3e}లల\u{c4b} ఉన\u{c4d}న ముఖం"),
            keywords: &["మ\u{c47}ఘ\u{c3e}లల\u{c4b} ఉన\u{c4d}న ముఖం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าในหม\u{e39}\u{e48}เมฆ"),
            keywords: &["หน\u{e49}าในหม\u{e39}\u{e48}เมฆ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bulutlaryň içinde ýüz"),
            keywords: &[
                "akly başga ýerde",
                "bulutlaryň içinde kelle",
                "bulutlaryň içinde ýüz",
                "ümüriň içindäki ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata ʻihe ʻao"),
            keywords: &["mata ʻihe ʻao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bulutlardaki yüz"),
            keywords: &[
                "bulutlardaki kafa",
                "bulutlardaki yüz",
                "dalgın",
                "sisler arasındaki yüz",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя в хмарах"),
            keywords: &[
                "голова в хмарах",
                "неуважний",
                "обличчи в хмарах",
                "обличчя в тумані",
                "обличчя в хмарах",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بادلوں میں چہرہ"),
            keywords: &["بادلوں میں چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bulutdagi yuz"),
            keywords: &[
                "bulutdagi bosh",
                "bulutdagi yuz",
                "gʻoyib boʻlgan",
                "tuman ichidagi yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt trong đám mây"),
            keywords: &[
                "mặt trong sương mù",
                "mặt trong đám mây",
                "đãng trí",
                "đầu trong đám mây",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雲嘅臉孔"),
            keywords: &["心不在焉", "雲中嘅臉", "雲中嘅頭", "雲嘅臉孔", "霧中嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("云嘅脸孔"),
            keywords: &["云中嘅头", "云中嘅脸", "云嘅脸孔", "心不在焉", "雾中嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("迷茫"),
            keywords: &["迷茫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("茫茫然"),
            keywords: &["一臉霧水", "茫茫然"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "😏"]
pub const SMIRKING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😏",
    codepoint: "1F60F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "smirking face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat grynslag"),
            keywords: &["gesig", "gesig wat grynslag", "grynslag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በምጸት ፈገግ የሚል ፊት"),
            keywords: &["ምጸት", "በምጸት ፈገግ የሚል ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه بابتسامة متكلفة"),
            keywords: &["تكلف", "وجه متكلف", "\u{202b}وجه بابتسامة متكلفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9c3}ত\u{9cd}ৰিম হ\u{9be}\u{981}হি মৰ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9c3}ত\u{9cd}ৰিম হ\u{9be}\u{981}হি",
                "ক\u{9c3}ত\u{9cd}ৰিম হ\u{9be}\u{981}হি মৰ\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("özündən razı gülümsəyən üz"),
            keywords: &[
                "özündən razı gülümsəmək",
                "özündən razı gülümsəyən üz",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ухмыляецца"),
            keywords: &["усмешка", "ухмылка", "ухмыляецца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Подсмихващо се лице"),
            keywords: &["Подсмихващо се лице", "лице", "подсмихване"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c3}ত\u{9cd}রিম হ\u{9be}সির ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9c3}ত\u{9cd}রিম হ\u{9be}সির ম\u{9c1}খ",
                "ব\u{9cd}যঙ\u{9cd}গ করে হ\u{9be}স\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zlobno smješkanje"),
            keywords: &["lice", "smješkanje", "zlobno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara somrient amb superioritat"),
            keywords: &[
                "cara",
                "cara somrient amb superioritat",
                "somriure astut",
                "superioritat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏰᏗᏍᎩ ᎤᎧᏛ"),
            keywords: &["ᎠᏤᏣᏍᏗ", "ᎤᎧᏛ", "ᎤᏰᏗᏍᎩ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ušklíbající se obličej"),
            keywords: &[
                "drzost",
                "drzý",
                "smajlík",
                "tvář",
                "ušklíbající se obličej",
                "výraz",
                "úšklebek",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn cilwenu"),
            keywords: &["cilwen", "wyneb", "wyneb yn cilwenu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med smørret grin"),
            keywords: &["ansigt", "ansigt med smørret grin", "smørret"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("süffisant lächelndes Gesicht"),
            keywords: &["Gesicht", "süffisant lächelndes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μειδίαμα"),
            keywords: &["μειδίαμα", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("smirking face"),
            keywords: &["face", "smirk", "smirking face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con superioridad"),
            keywords: &[
                "cara",
                "cara sonriendo con superioridad",
                "listillo",
                "superioridad",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara sonriendo con superioridad"),
            keywords: &[
                "cara",
                "cara sonriendo con superioridad",
                "creído",
                "gesto de superioridad",
                "sarcástico",
                "sonrisa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con superioridad"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con superioridad"),
            keywords: &["cara sonriendo con superioridad"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("muigav nägu"),
            keywords: &["irvitus", "muigav nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("handitasun-aurpegia"),
            keywords: &["aurpegi", "handiki", "handitasun-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پوزخند"),
            keywords: &["تمسخر", "صورت", "پوزخند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("virnistys"),
            keywords: &["huvittunut", "hymy", "naama", "virne", "virnistys"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangisi"),
            keywords: &["mukha", "nakangisi", "ngisi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lúrt andlit"),
            keywords: &["andlit", "lúrin", "lúrt andlit", "snildur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec un sourire malin"),
            keywords: &["malin", "sourire", "visage avec un sourire malin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage au sourire malin"),
            keywords: &["malin", "sourire", "visage", "visage au sourire malin"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag déanamh seitgháire"),
            keywords: &["siotgháire", "straoiseog ag déanamh seitgháire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le plìonas"),
            keywords: &["aodann", "aodann le plìonas", "plìonas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara con sorriso malicioso"),
            keywords: &["cara", "cara con sorriso malicioso", "malicia", "sorriso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac3}ત\u{acd}રિમ હસતો ચહ\u{ac7}રો"),
            keywords: &[
                "ક\u{ac3}ત\u{acd}રિમ",
                "ક\u{ac3}ત\u{acd}રિમ હસતો ચહ\u{ac7}રો",
                "ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushin wauta"),
            keywords: &["fuska", "fuska mai murmushin wauta", "murmushin wauta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף זחוח"),
            keywords: &["זחוח", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बनावटी ह\u{901}सी वाला च\u{947}हरा"),
            keywords: &[
                "क\u{943}त\u{94d}रिम ह\u{902}सी",
                "च\u{947}हरा",
                "बनावटी ह\u{901}सी वाला च\u{947}हरा",
                "बनावटी ह\u{902}सी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje se smijulji"),
            keywords: &["lice", "lice koje se smijulji", "smijuljenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("önelégült vigyor"),
            keywords: &["arc", "vigyor", "önelégült"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կեղծ ժպտացող դեմք"),
            keywords: &["դեմք", "կեղծ ժպիտ", "կեղծ ժպտացող դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersenyum sombong"),
            keywords: &[
                "seringai",
                "wajah",
                "wajah menyeringai",
                "wajah tersenyum sombong",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu na-eme nka ọchị"),
            keywords: &["ihu", "ihu na-eme nka ọchị", "nka ọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjálfsánægt andlit"),
            keywords: &["andlit", "glott", "sjálfsánægt andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con sorrisetto"),
            keywords: &[
                "faccina",
                "faccina che sorride",
                "faccina con sorrisetto",
                "furbetto",
                "malizioso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("薄笑いをする顔"),
            keywords: &["にやり", "ふっ", "薄笑いをする顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mesem ngenyek"),
            keywords: &["ngenyek", "rai", "rai mesem ngenyek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დამცინავი სახე"),
            keywords: &["დამცინავი სახე", "დაცინვა", "სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeh n tiherci"),
            keywords: &["acmumeh n tiherci"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мырс-мырс күлу"),
            keywords: &["бет", "көз", "мырс-мырс күлу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med smørret grin"),
            keywords: &["ansigt", "ansigt med smørret grin", "smørret"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខញញ\u{17b9}មច\u{17c6}អក"),
            keywords: &["ច\u{17c6}អក", "ម\u{17bb}ខញញ\u{17b9}មច\u{17c6}អក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹುಸ\u{cbf} ನಗುವ\u{cbf}ನ ಮುಖ"),
            keywords: &["ಮುಖ", "ಹುಸ\u{cbf} ನಗು", "ಹುಸ\u{cbf} ನಗುವ\u{cbf}ನ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("히죽거리는 얼굴"),
            keywords: &["웃는 얼굴", "히죽거리는 얼굴", "히죽히죽"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{941}रम\u{941}रख\u{94d}या\u{902}नी हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "म\u{941}रम\u{941}रख\u{94d}या\u{902}नी",
                "म\u{941}रम\u{941}रख\u{94d}या\u{902}नी हा\u{902}सपी च\u{947}रो",
                "म\u{941}रम\u{941}रख\u{94d}या\u{902}नी हासपी च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мыйыгынан жылмайган бет"),
            keywords: &["бет", "мыйыгынан", "мыйыгынан жылмайган бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schmunzelend"),
            keywords: &["Gesiicht", "schmunzelen", "schmunzelend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມເຍາະເຍ\u{eb5}\u{ec9}ຍ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມເຍາະເຍ\u{eb5}\u{ec9}ຍ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມເຍາະເຍ\u{eb5}\u{ec9}ຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("iš pasitenkinimo besišypsantis veidas"),
            keywords: &[
                "iš pasitenkinimo besišypsantis veidas",
                "pasitenkinimas",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smīnoša seja"),
            keywords: &["seja", "smīnoša seja", "smīns", "viltīgs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi tāpahi"),
            keywords: &["kanohi", "tāpahi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со подбивна насмевка"),
            keywords: &[
                "лице",
                "лице со подбивна насмевка",
                "насмевка",
                "подбивно",
                "самозадоволно",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d43}ത\u{d43}മിച\u{d4d}ചിരിയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "ക\u{d43}ത\u{d43}മിച\u{d4d}ചിരിയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "ക\u{d43}ത\u{d4d}രിമച\u{d4d}ചിരി",
                "പ\u{d41}ച\u{d4d}ഛം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ёжтой царай"),
            keywords: &["царай", "ёжтой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बनावटी हास\u{94d}याचा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "बनावटी हास\u{94d}य",
                "बनावटी हास\u{94d}याचा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersenyum sinis"),
            keywords: &["mata", "muka tersenyum sinis", "tersenyum sinis"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jitkerraħ"),
            keywords: &["jitkerraħ", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{103e}ောင\u{103a}ပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "လ\u{103e}ောင\u{103a}ပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
                "လ\u{103e}ောင\u{103a}ပြောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lurt smil"),
            keywords: &["fjes", "lurt smil", "selvtilfreds"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बनावटी अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "बनावटी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gniffelend gezicht"),
            keywords: &["gezicht", "gniffelen", "gniffelend gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lurt smil"),
            keywords: &["fjes", "lurt smil", "sjølvtilfreds"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3f}ର\u{b4d}ବୋଧତ\u{b3e} ଭର\u{b3e} ହସ ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ନ\u{b3f}ର\u{b4d}ବୋଧ ଭ\u{b3e}ବରେ ହସ\u{b3f}ବ\u{b3e}",
                "ନ\u{b3f}ର\u{b4d}ବୋଧତ\u{b3e} ଭର\u{b3e} ହସ ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a71}ਖਰ\u{a47} ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਲਾਕ ਚਿਹਰਾ",
                "ਚਲਾਕੀ",
                "ਚਲਾਕੀ ਭਰੀ ਮ\u{a41}ਸਕਾਨ",
                "ਨ\u{a71}ਖਰ\u{a47} ਵਾਲਾ ਚਿਹਰਾ",
                "ਮ\u{a41}\u{a42}\u{a42}ਰਖਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بناوٹی شکل"),
            keywords: &["بناوٹی شکل", "بناوٹی ہاسا", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wit Bẹn Bẹ\u{301}n Smail"),
            keywords: &[
                "Bẹn Bẹ\u{301}n Smail",
                "Fes",
                "Fes Wit Bẹn Bẹ\u{301}n Smail",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z uśmieszkiem"),
            keywords: &["twarz z uśmieszkiem", "uśmieszek"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ملنډو د خندا مخ"),
            keywords: &["د ملنډو خندا", "د ملنډو د خندا مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com sorriso maroto"),
            keywords: &[
                "rosto",
                "rosto com sorriso maroto",
                "sorriso malicioso",
                "sorriso maroto",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com sorriso sarcástico"),
            keywords: &["cara", "cara com sorriso sarcástico", "sorriso pretensioso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kʼaskiskachasqa uya"),
            keywords: &["kʼaskikachay", "kʼaskiskachasqa uya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu zâmbet superior"),
            keywords: &[
                "afectare",
                "față",
                "față cu zâmbet superior",
                "superioritate",
                "zâmbet",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-851"),
            keywords: &["E10-851"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ухмыляется"),
            keywords: &["задумал", "лицо", "ухмылка", "ухмыляется", "хитрый"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka idasetse"),
            keywords: &["iseka", "isura", "isura iseka idasetse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بناوٽي چهرو"),
            keywords: &["بناوٽي مرڪ", "بناوٽي چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}යවන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "න\u{dd2}යවන ම\u{dd4}හ\u{dd4}ණ",
                "න\u{dd2}යව\u{dd3}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("samoľúba tvár"),
            keywords: &["samoľúba", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s privoščljivim nasmeškom"),
            keywords: &[
                "obraz",
                "obraz s privoščljivim nasmeškom",
                "privoščljiv nasmešek",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji isku dhagan"),
            keywords: &[
                "isku dhaggan",
                "waji",
                "waji isku dhagan",
                "waji isku dhaggan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e vetëkënaqur"),
            keywords: &["e vetëkënaqur", "fytyrë", "fytyrë e vetëkënaqur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које се злобно смешка"),
            keywords: &["злобно смешкање", "лице", "лице које се злобно смешка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице које се злобно смјешка"),
            keywords: &["лице које се злобно смјешка"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje se zlobno smeška"),
            keywords: &["lice", "lice koje se zlobno smeška", "zlobno smeškanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice koje se zlobno smješka"),
            keywords: &["lice koje se zlobno smješka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("halvleende ansikte"),
            keywords: &[
                "flin",
                "flinande ansikte",
                "halvleende ansikte",
                "småleende ansikte",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaobeza"),
            keywords: &["beza", "uso", "uso unaobeza"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பகட\u{bcd}ட\u{bbe}கச\u{bcd} சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "இளிப\u{bcd}பு",
                "பகட\u{bcd}ட\u{bbe}கச\u{bcd} சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "பகட\u{bcd}டு",
                "பகட\u{bcd}டுச\u{bcd} சிரிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}క\u{c3e}రంగ\u{c3e} నవ\u{c4d}వుతున\u{c4d}న ముఖం"),
            keywords: &[
                "నవ\u{c4d}వు",
                "ముఖం",
                "వ\u{c3f}క\u{c3e}రం",
                "వ\u{c3f}క\u{c3e}రంగ\u{c3e} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи писхандакунанда"),
            keywords: &["писханда", "рӯи писхандакунанда", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แสยะย\u{e34}\u{e49}ม"),
            keywords: &["หน\u{e49}า", "แสยะย\u{e34}\u{e49}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kinaýaly ýüz"),
            keywords: &["kinaýa", "kinaýaly ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata katakata manuki"),
            keywords: &["mata katakata manuki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("imalı gülümseme"),
            keywords: &[
                "imalı gülümseme",
                "yapmacık gülümseyen",
                "yapmacık gülümseyen yüz",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھېجايغان چىراي"),
            keywords: &["چىراي", "ھېجايغان چىراي", "ھېجىيىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("самовдоволене обличчя"),
            keywords: &["обличчя", "самовдоволене обличчя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طنزیہ مسکراہٹ والا چہرہ"),
            keywords: &["طنزیہ", "طنزیہ مسکراہٹ والا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("istehzoli yuz"),
            keywords: &["istehzo", "istehzoli yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười khẩy"),
            keywords: &["cười khẩy", "mặt", "mặt cười khẩy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu bëgg-waccu"),
            keywords: &["bëgg-waccu", "kanam", "kanam gu bëgg-waccu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obusinekileyo"),
            keywords: &["ubuso", "ubuso obusinekileyo", "ukusineka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ẹrin Abosi"),
            keywords: &["Oju Ẹrin Abosi", "ojú", "rẹ\u{301}rín àbòsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("傻笑臉"),
            keywords: &["傻笑", "傻笑臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("傻笑脸"),
            keywords: &["傻笑", "傻笑脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("得意"),
            keywords: &["假笑", "得意"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("冷笑"),
            keywords: &["假笑", "冷笑"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冷笑"),
            keywords: &["假笑", "冷笑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso ubunyiphile"),
            keywords: &["nyipha", "ubuso", "ubuso ubunyiphile"],
        },
    ],
};
#[doc = "😒"]
pub const UNAMUSED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😒",
    codepoint: "1F612",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "unamused face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ontevrede gesig"),
            keywords: &["gesig", "ongelukkig", "ontevrede"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ያልተገረመ ፊት"),
            keywords: &["ያልተደሰተ", "ያልተገረመ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه غير مستمتع"),
            keywords: &["غير سعيد", "\u{202b}وجه غير مستمتع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9c1}ঃখিত ম\u{9c1}খ"),
            keywords: &["অস\u{9c1}খী", "দ\u{9c1}ঃখিত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kefsiz üz"),
            keywords: &["kefsiz", "narazı", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("незадаволены твар"),
            keywords: &["зануда", "незадаволены", "незадаволены твар", "нудны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Недоволно лице"),
            keywords: &["Недоволно лице", "лице", "недоволен", "нещастен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিরক\u{9cd}ত ম\u{9c1}খ"),
            keywords: &["অস\u{9c1}খী", "বিরক\u{9cd}ত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("smorenost"),
            keywords: &[
                "lice",
                "nesretan",
                "nezainteresovanost",
                "smor",
                "smorenost",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de desaprovació"),
            keywords: &["avorriment", "cara", "cara de desaprovació", "desaprovació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᏰᏗᏍᎬᎾ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎾᎵᎮᎵᎬᎾ", "ᏄᏰᏗᏍᎬᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej se znuděným výrazem"),
            keywords: &[
                "nešťastný",
                "obličej se znuděným výrazem",
                "smajlík",
                "tvář",
                "výraz",
                "znuděný",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb ddi-ddifyr"),
            keywords: &["anhapus", "di-ddifyr", "wyneb", "wyneb ddi-ddifyr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("uimponeret ansigt"),
            keywords: &["ansigt", "ikke glad", "uimponeret ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("verstimmtes Gesicht"),
            keywords: &["Gesicht", "unglücklich", "verstimmtes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δυσαρέσκεια"),
            keywords: &["δυσαρέσκεια", "δυσαρεστημένος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("unamused face"),
            keywords: &["face", "unamused", "unhappy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de desaprobación"),
            keywords: &["cara", "cara de desaprobación", "insatisfacción", "rechazo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["aburrido", "cara", "cara de desaprobación", "enojado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("põlglik nägu"),
            keywords: &["nägu", "põlglik", "õnnetu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aspertu-aurpegia"),
            keywords: &["aspertu-aurpegia", "aspertuta", "aurpegi", "triste"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کسل"),
            keywords: &["بی\u{200c}حوصله", "صورت", "کسل", "کسل\u{200c}کننده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ei naurata"),
            keywords: &["ei naurata", "naama", "onneton"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hindi natutuwa"),
            keywords: &["hindi masaya", "hindi natutuwa", "mukha"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ikki stuttligt andlit"),
            keywords: &["andlit", "ikki stuttligt", "ikki stuttligt andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage blasé"),
            keywords: &["blasé", "pas content", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage désabusé"),
            keywords: &["contrarié", "désabusé", "pas content", "résigné", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog mhíshásta"),
            keywords: &["aghaidh mhíshásta", "míshásta", "straoiseog mhíshásta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann nuair nach eil e èibhinn"),
            keywords: &["aodann", "aodann nuair nach eil e èibhinn", "mì-thoilichte"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de que non ten graza"),
            keywords: &[
                "aburrido",
                "cara",
                "cara de que non ten graza",
                "desagrado",
                "desaprobación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાખ\u{ac1}શ ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "દ\u{ac1}ઃખી", "નાખ\u{ac1}શ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mara sha’awa"),
            keywords: &["baƙin ciki", "fuska", "fuska mara sha’awa", "mara sha’awa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף לא מתרשם"),
            keywords: &["לא משועשע", "לא מתרשם", "פרצוף", "פרצוף לא מתרשם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अप\u{94d}रसन\u{94d}न च\u{947}हरा"),
            keywords: &["अप\u{94d}रसन\u{94d}न", "च\u{947}हरा", "नाख\u{941}श"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s izrazom dosade"),
            keywords: &[
                "dosađivanje",
                "lice",
                "lice s izrazom dosade",
                "nezadovoljstvo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szomorú arc"),
            keywords: &["arc", "szomorú"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("անտրամադիր դեմք"),
            keywords: &["անտրամադիր", "դեմք", "դժբախտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bosan"),
            keywords: &["bosan", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("uhu atọghị ọchị"),
            keywords: &["atọghị ọchị", "enweghị obi aṅụrị", "ihu", "uhu atọghị ọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("engin gleði"),
            keywords: &["andlit", "ekki skemmt", "engin gleði", "fýla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina contrariata"),
            keywords: &["contrariata", "faccina", "triste"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しらけた"),
            keywords: &["しらけ", "しらけた", "しらける", "ジト目", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai wegah ngguyu"),
            keywords: &["anyel", "rai", "rai wegah ngguyu", "wegah ngguyu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("უხალისო სახე"),
            keywords: &["სახე", "უხალისო", "ცალყბა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem ameklu"),
            keywords: &["udem ameklu"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызық емес"),
            keywords: &["бет", "қуанышты емес", "қызық емес"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("uimponeret ansigt"),
            keywords: &["ansigt", "ikke glad", "uimponeret ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខស\u{17d2}រពោន"),
            keywords: &[
                "ទ\u{17bb}ក\u{17d2}ខព\u{17d2}រ\u{17bd}យ",
                "ម\u{17b7}នសប\u{17d2}បាយច\u{17b7}ត\u{17d2}ត",
                "ម\u{17bb}ខស\u{17d2}រពោន",
                "ស\u{17d2}រពោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅತೃಪ\u{ccd}ತ\u{cbf}ಯ ಮುಖ"),
            keywords: &[
                "ಅತೃಪ\u{ccd}ತ\u{cbf} ಮುಖ",
                "ಅತೃಪ\u{ccd}ತ\u{cbf}ಯ ಮುಖ",
                "ಹಾಸ\u{ccd}ಯಗ\u{ccd}ರಹ\u{cbf}ಸದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지루해하는 얼굴"),
            keywords: &["얼굴", "재미 없어 하는 얼굴", "지루함", "지루해하는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निरस च\u{947}रो"),
            keywords: &["च\u{947}रो", "द\u{941}ख\u{94d}खी", "निरस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таарынган бет"),
            keywords: &["бет", "жактырбаган", "таарынган бет", "таарынуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("onzefridden"),
            keywords: &["Gesiicht", "onglécklech", "onzefridden"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າບ\u{ecd}\u{ec8}ມ\u{ec8}ວນຊ\u{eb7}\u{ec8}ນ"),
            keywords: &[
                "ບ\u{ecd}\u{ec8}ມ\u{eb5}ຄວາມສ\u{eb8}ກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າບ\u{ecd}\u{ec8}ມ\u{ec8}ວນຊ\u{eb7}\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nelinksmas veidas"),
            keywords: &["nelaimingas", "nelinksmas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saīgusi seja"),
            keywords: &["dusmas", "dusmīgs", "saīdzis", "saīgusi seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi katakore"),
            keywords: &["kanohi", "katakore", "pōuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("незаинтересирано лице"),
            keywords: &["лице", "незаинтересирано", "несреќно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അസന\u{d4d}ത\u{d41}ഷ\u{d4d}\u{200c}ടമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "അത\u{d4d}ഭ\u{d41}തമില\u{d4d}ല\u{d3e}ത\u{d4d}ത",
                "അസന\u{d4d}ത\u{d41}ഷ\u{d4d}\u{200c}ടമ\u{d3e}യ മ\u{d41}ഖം",
                "അസന\u{d4d}ത\u{d41}ഷ\u{d4d}\u{200c}ടി",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үл тоосон царай"),
            keywords: &["царай", "үл тоосон", "үл тоосон царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("द\u{941}:खी च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "द\u{941}:खी च\u{947}हरा", "द\u{941}ःखी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tidak puas hati"),
            keywords: &["muka", "muka tidak puas hati", "sedih", "tidak puas hati"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ mhux ferrieħi"),
            keywords: &[
                "mhux ferrieħi",
                "mhux kuntent",
                "wiċċ",
                "wiċċ mhux ferrieħi",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "စ\u{102d}တ\u{103a}အလ\u{102d}\u{102f}မကျသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "စ\u{102d}တ\u{103a}အလ\u{102d}\u{102f}မကျ",
                "စ\u{102d}တ\u{103a}အလ\u{102d}\u{102f}မကျသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("misfornøyd"),
            keywords: &["fjes", "misfornøyd", "sur"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अप\u{94d}रसन\u{94d}न अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "अप\u{94d}रसन\u{94d}न", "व\u{947}ख\u{941}शी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("chagrijnig gezicht"),
            keywords: &[
                "chagrijnig gezicht",
                "gezicht",
                "niet blij",
                "niet leuk",
                "ongelukkig",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("misnøgd"),
            keywords: &["fjes", "misnøgd", "sur"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅପ\u{b4d}ରସନ\u{b4d}ନ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅପ\u{b4d}ରସନ\u{b4d}ନ",
                "ଖ\u{b41}ସ\u{b3f}ନଥ\u{b3f}ବ\u{b3e}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਾ-ਖਸ\u{a3c} ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਨਾ-ਖਸ\u{a3c} ਚਿਹਰਾ", "ਨਾ-ਖ\u{a41}ਸ\u{a3c}"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ناخوش شکل"),
            keywords: &["دی شکل", "غیر دلچسپ", "نا خوش", "ناخوش شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Nọ\u{301} Dé Hapí"),
            keywords: &[
                "Fes",
                "Fes Wé Nọ\u{301} Dé Hapí",
                "Nọ\u{301} Hapí",
                "Skwíz Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niezadowolona twarz"),
            keywords: &["niezadowolona buźka", "niezadowolona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پښيمانه مخ"),
            keywords: &["غمجن", "مخ", "ناخوشاله", "پښيمانه مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto aborrecido"),
            keywords: &[
                "blasé",
                "rosto",
                "rosto aborrecido",
                "rosto de que não achou graça",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara aborrecida"),
            keywords: &["aborrecido", "cara", "cara aborrecida", "descontente"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mana kusisqa uya"),
            keywords: &["llakisqa", "mana kusisqa", "mana kusisqa uya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față morocănoasă"),
            keywords: &["față", "față morocănoasă", "nemulțumire", "neplăcere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-854"),
            keywords: &["E10-854"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скучает"),
            keywords: &["лицо", "недовольный", "скука", "скусно", "скучает", "тоска"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kutishima"),
            keywords: &[
                "idashimishije",
                "isura",
                "isura igaragaza kutishima",
                "itishimye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ناخوش چهرو"),
            keywords: &["ناخوش", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}නෝදයක\u{dca} නැත\u{dd2} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අසත\u{dd4}ට\u{dd4}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}නෝදයක\u{dca} නැත\u{dd2}",
                "ව\u{dd2}නෝදයක\u{dca} නැත\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znudená tvár"),
            keywords: &["nespokojná", "nuda", "tvár", "znudená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s hladnim nasmeškom"),
            keywords: &[
                "nenaklonjeno",
                "nezadovoljno",
                "obraz",
                "obraz s hladnim nasmeškom",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji aan la taaban karin"),
            keywords: &[
                "aan la daboolin",
                "farxad la’aan",
                "waji",
                "waji aan la taaban karin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e pakënaqur"),
            keywords: &["e mërzitur", "e pakënaqur", "fytyrë", "fytyrë e pakënaqur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сморено лице"),
            keywords: &["дoсaда", "лице", "смор", "сморено лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сморено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("smoreno lice"),
            keywords: &["dosada", "lice", "smor", "smoreno lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["smoreno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("missnöjt ansikte"),
            keywords: &["inte glad", "missnöjd", "missnöjt ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso usio na furaha"),
            keywords: &["kukosa furaha", "kutofurahi", "uso usio na furaha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அதிருப\u{bcd}தி முகம\u{bcd}"),
            keywords: &[
                "அதிருப\u{bcd}தி முகம\u{bcd}",
                "ஆச\u{bcd}சரியமில\u{bcd}லை",
                "ஒன\u{bcd}றுமில\u{bcd}லை",
                "வருத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అసంతృప\u{c4d}త\u{c3f} ముఖం"),
            keywords: &["అసంతృప\u{c4d}త\u{c3f}", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи норозӣ"),
            keywords: &["зиқ", "норозӣ", "рӯи норозӣ", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าหน\u{e48}าย"),
            keywords: &[
                "หน\u{e49}า",
                "หน\u{e49}าหน\u{e48}าย",
                "ไม\u{e48}ม\u{e35}ความส\u{e38}ข",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("göwni bitmedik ýüz"),
            keywords: &["begençsiz", "göwni bitmedik", "göwni bitmedik ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata taʻefiefia"),
            keywords: &["mata taʻefiefia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("keyifsiz yüz"),
            keywords: &["keyifsiz yüz", "mutsuz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۇز چىراي"),
            keywords: &["خاپا", "مۇز", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("невдоволене обличчя"),
            keywords: &[
                "невдоволене обличчя",
                "незадоволене обличчя",
                "незадоволений",
                "нещасливий",
                "обличчя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اداس چہرہ"),
            keywords: &["اداس چہرہ", "نا خوش", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qoniqmagan yuz"),
            keywords: &["qoniqmagan", "xafa", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt buồn"),
            keywords: &["buồn", "không vui", "mặt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu ñàkk xorom"),
            keywords: &["kanam", "kanam gu ñàkk xorom", "kontaanul", "ñàkk-caaxaan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obungahlekiyo"),
            keywords: &["engahlekiyo", "ubuso", "ubuso obungahlekiyo", "ukungonwabi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Aifanimọra"),
            keywords: &["Oju Aifanimọra", "ojú", "àìdunú", "àìfanimọ\u{301}ra"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("垂頭喪氣嘅臉"),
            keywords: &["唔開心", "垂頭喪氣", "垂頭喪氣嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("垂头丧气嘅脸"),
            keywords: &["唔开心", "垂头丧气", "垂头丧气嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("不高兴"),
            keywords: &["不屑", "不服", "不高兴", "脸", "郁闷", "鄙视"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("不高興"),
            keywords: &["不開心", "不高興"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("不高興"),
            keywords: &["不開心", "不高興"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obungachazekile"),
            keywords: &[
                "ubuso",
                "ubuso obungachazekile",
                "ukungajabuli",
                "ukungathokozi",
            ],
        },
    ],
};
#[doc = "🙄"]
pub const FACE_WITH_ROLLING_EYES: crate::Emoji = crate::Emoji {
    glyph: "🙄",
    codepoint: "1F644",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "face with rolling eyes",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met oë wat rol"),
            keywords: &["gesig", "gesig met oë wat rol", "oë", "rol"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚሽከረከሩ ዓይኖች ያሉት ፊት"),
            keywords: &["ዓይኖች", "የሚሽከረከሩ", "የሚሽከረከሩ ዓይኖች ያሉት ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بعينين تدوران"),
            keywords: &[
                "طوافة",
                "عين",
                "وجه",
                "وجه بأعين دوارة",
                "وجه بعينين تدوران",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চক\u{9c1} পক\u{9be}ই থক\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "চক\u{9c1}",
                "চক\u{9c1} পক\u{9be}ই থক\u{9be} ম\u{9c1}খ",
                "পকোৱ\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gözlərini fırladan üz"),
            keywords: &["fırlatmaq", "göz", "gözlərini fırladan üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("закочвае вочы"),
            keywords: &["вочы", "закочвае вочы", "закочванне", "толькі не гэта"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с извъртени нагоре очи"),
            keywords: &["Лице с извъртени нагоре очи", "извъртам", "лице", "очи"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখ গোল গোল কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ঘ\u{9c2}র\u{9cd}ণ\u{9be}য\u{9bc}ম\u{9be}ন",
                "চোখ",
                "চোখ গোল গোল কর\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kolutanje očima"),
            keywords: &["kolutanje", "kolutanje očima", "lice", "oči"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb els ulls en blanc"),
            keywords: &["cara", "cara amb els ulls en blanc", "ulls en blanc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎦᎦᏐᏆᎴᎦ ᏗᎦᏙᎵ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎦᎦᏐᏆᎴᎦ ᏗᎦᏙᎵ", "ᏓᎵᏐᏈᎴ", "ᏗᎦᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s očima v sloup"),
            keywords: &[
                "koulející",
                "obličej s očima v sloup",
                "oči",
                "smajlík",
                "tvář",
                "v sloup",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â llygaid yn rholio"),
            keywords: &["llygaid", "rolio", "wyneb", "wyneb â llygaid yn rholio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med rullende øjne"),
            keywords: &["ansigt", "ansigt med rullende øjne", "rullende", "øjne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Augen verdrehendes Gesicht"),
            keywords: &["Augen verdrehen", "Augen verdrehendes Gesicht", "Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βλέμμα αποδοκιμασίας"),
            keywords: &["αναποδογυριστά", "βλέμμα αποδοκιμασίας", "μάτια", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with rolling eyes"),
            keywords: &[
                "eyeroll",
                "eyes",
                "face",
                "face with rolling eyes",
                "rolling",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con ojos en blanco"),
            keywords: &[
                "cara",
                "cara con ojos en blanco",
                "frustración",
                "ojos",
                "vueltos",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara revoleando los ojos"),
            keywords: &["cara", "cara revoleando los ojos", "ojos", "revoleando"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara con ojos en blanco"),
            keywords: &["cara con ojos en blanco"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara con ojos en blanco"),
            keywords: &[
                "cara",
                "cara con ojos en blanco",
                "ojos",
                "volteando",
                "voltear los ojos",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pööritavate silmadega nägu"),
            keywords: &[
                "nägu",
                "pööritamine",
                "pööritavate silmadega nägu",
                "silmad",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begiak bueltaka dituen aurpegia"),
            keywords: &[
                "aurpegi",
                "begiak",
                "begiak bueltaka dituen aurpegia",
                "biraka",
                "bueltaka",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نگاه کلافه"),
            keywords: &["صورت", "نگاه عاقل اندر سفیه", "نگاه کلافه", "چشم", "کلافه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silmien pyöritys"),
            keywords: &["naama", "pyörivä", "silmien pyöritys", "silmät"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("itinitirik ang mga mata"),
            keywords: &[
                "irap",
                "itinitirik ang mga mata",
                "mata",
                "mukha",
                "umiikot",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við rullandi eygum"),
            keywords: &["andlit", "andlit við rullandi eygum", "eygu", "rullandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage roulant des yeux"),
            keywords: &["roulement", "visage roulant des yeux", "yeux"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage qui roule des yeux"),
            keywords: &[
                "roule des yeux",
                "visage",
                "visage qui roule des yeux",
                "yeux",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le súile ag casadh"),
            keywords: &[
                "aghaidh",
                "straoiseog le súile ag casadh",
                "suas chun na bhflaitheas",
                "súile",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ casadh nan sùilean"),
            keywords: &[
                "aodann",
                "aodann a’ casadh nan sùilean",
                "casadh",
                "sùilean",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara cos ollos en branco"),
            keywords: &["cara", "cara cos ollos en branco", "ollos en branco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આ\u{a82}ખો ફ\u{ac7}રવતો ચહ\u{ac7}રો"),
            keywords: &[
                "આ\u{a82}ખો",
                "આ\u{a82}ખો ફ\u{ac7}રવતો ચહ\u{ac7}રો",
                "ચહ\u{ac7}રો",
                "ફ\u{ac7}રવવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da idanu masu mirgina"),
            keywords: &[
                "fuska",
                "fuska tare da idanu masu mirgina",
                "idanu",
                "mai mirgina",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מגלגל עיניים"),
            keywords: &["למעלה", "מגלגל", "עיניים", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर द\u{947}खती आ\u{901}खो\u{902} वाला च\u{947}हरा"),
            keywords: &[
                "आ\u{902}ख\u{947}\u{902}",
                "ऊपर द\u{947}खती आ\u{901}खो\u{902} वाला च\u{947}हरा",
                "ऊपर द\u{947}खती आ\u{902}ख\u{947}\u{902}",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s kolutajućim očima"),
            keywords: &["kolutanje", "lice", "lice s kolutajućim očima", "oči"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szemét forgató arc"),
            keywords: &["arc", "forgó szemek", "szemét forgató arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտտվող աչքերով դեմք"),
            keywords: &["աչքեր", "դեմք", "պտտվող", "պտտվող աչքերով դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan mata ke atas"),
            keywords: &[
                "atas",
                "berputar",
                "mata",
                "muka",
                "wajah",
                "wajah dengan mata ke atas",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere kpụrụkpụrụ anya na-akpọgharị akpọgharị"),
            keywords: &[
                "anya",
                "ihu",
                "ihu nwere kpụrụkpụrụ anya na-akpọgharị akpọgharị",
                "na-akpọgharị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ranghvolfir augum"),
            keywords: &["andlit", "augu", "ranghvolfir", "ranghvolfir augum"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con occhi al cielo"),
            keywords: &[
                "faccina",
                "faccina con occhi al cielo",
                "guardare altrove",
                "roteare gli occhi",
                "sollevare gli occhi al cielo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上を見る顔"),
            keywords: &["上を見る顔", "上目", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai matane mlerok"),
            keywords: &["mata", "mlerok", "rai", "rai matane mlerok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე გადატრიალებული თვალებით"),
            keywords: &[
                "გადატრიალება",
                "თვალები",
                "სახე",
                "სახე გადატრიალებული თვალებით",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("baɛar s wallen"),
            keywords: &["baɛar s wallen"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көзі алару"),
            keywords: &["бет", "көз", "көз алару", "көзі алару"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med rullende øjne"),
            keywords: &["ansigt", "ansigt med rullende øjne", "rullende", "øjne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខធ\u{17d2}វើភ\u{17d2}នែកក\u{17d2}រឡេបក\u{17d2}រឡាប\u{17cb}"),
            keywords: &[
                "ក\u{17d2}រឡេបក\u{17d2}រឡាប\u{17cb}",
                "ភ\u{17d2}នែក",
                "ម\u{17bb}ខធ\u{17d2}វើភ\u{17d2}នែកក\u{17d2}រឡេបក\u{17d2}រឡាប\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cbf}ರುಗುತ\u{ccd}ತ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳ ಮುಖ"),
            keywords: &[
                "ಕಣ\u{ccd}ಣುಗಳು",
                "ತ\u{cbf}ರುಗುತ\u{ccd}ತ\u{cbf}ರುವ",
                "ತ\u{cbf}ರುಗುತ\u{ccd}ತ\u{cbf}ರುವ ಕಣ\u{ccd}ಣುಗಳ ಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈을 굴리고 있는 얼굴"),
            keywords: &["눈 굴리기", "눈을 굴리고 있는 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घ\u{941}\u{902}वपी दोळ\u{94d}या\u{902}चो च\u{947}रो"),
            keywords: &[
                "घ\u{941}\u{902}वपी",
                "घ\u{941}\u{902}वपी दोळो",
                "घ\u{941}\u{902}वपी दोळ\u{94d}या\u{902}चो च\u{947}रो",
                "च\u{947}रो",
                "दोळ\u{947}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көзүн сүзгөн бет"),
            keywords: &["бет", "көз", "көз сүз", "көзүн сүзгөн бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ae verdréinend"),
            keywords: &["Ae verdréinend", "Aen", "Gesiicht", "verdréinen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າທ\u{eb5}\u{ec8}ມ\u{eb5}ຕາລ\u{eb1}ອກແລ\u{eb1}ກ"),
            keywords: &[
                "ຕາລ\u{eb1}ອກແລ\u{eb1}ກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າທ\u{eb5}\u{ec8}ມ\u{eb5}ຕາລ\u{eb1}ອກແລ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas, vartantis akis"),
            keywords: &["akys", "vartyti", "veidas", "veidas, vartantis akis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar pārgrieztām acīm"),
            keywords: &[
                "acis",
                "neapmierināts",
                "pārgriezt",
                "seja",
                "seja ar pārgrieztām acīm",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi karu takahuri"),
            keywords: &["kanohi", "karu", "takahuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице што превртува очи"),
            keywords: &["лице", "лице што превртува очи", "очи", "превртува"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കറങ\u{d4d}ങ\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "കണ\u{d4d}ണ\u{d41}കൾ",
                "കറങ\u{d4d}ങ\u{d41}ന\u{d4d}ന കണ\u{d4d}ണ\u{d41}കള\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "കറങ\u{d4d}ങ\u{d41}ന\u{d4d}ന\u{d41}",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүдээ эргэлдүүлэх царай"),
            keywords: &["нүд", "нүдээ эргэлдүүлэх царай", "царай", "эргэлдсэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोळ\u{947} फिरविणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "डोळ\u{947}",
                "डोळ\u{947} फिरवणारा च\u{947}हरा",
                "डोळ\u{947} फिरविणारा च\u{947}हरा",
                "फिरविण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan mata juling ke atas"),
            keywords: &["juling", "mata", "muka", "muka dengan mata juling ke atas"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’għajnejn iduru"),
            keywords: &["għajnejn", "iduru", "wiċċ", "wiċċ b’għajnejn iduru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "စ\u{102d}တ\u{103a}မရ\u{103e}ည\u{103a}သည\u{1037}\u{103a}ဟန\u{103a}ပြ မျက\u{103a}လ\u{102f}\u{1036}းများ",
            ),
            keywords: &[
                "စ\u{102d}တ\u{103a}မရ\u{103e}ည\u{103a}သည\u{1037}\u{103a}ဟန\u{103a}ပြ မျက\u{103a}လ\u{102f}\u{1036}းများ",
                "ပျင\u{103a}းစရာကောင\u{103a}းသောအကြောင\u{103a}းအရာကြောင\u{1037}\u{103a} ဖြစ\u{103a}ပေါ\u{103a}လာသောမျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
                "မျက\u{103a}လ\u{102f}\u{1036}းပင\u{1037}\u{103a}ကြည\u{1037}\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("himler med øynene"),
            keywords: &["fjes", "himler med øynene", "ruller", "øyne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घ\u{941}मिरह\u{947}को आ\u{901}खासहितको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}खा",
                "घ\u{941}मिरह\u{947}को",
                "घ\u{941}मिरह\u{947}को आ\u{901}खासहितको अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met rollende ogen"),
            keywords: &["gezicht", "gezicht met rollende ogen", "ogen", "rollen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("himlar med auga"),
            keywords: &["auge", "fjes", "himlar med auga", "rullar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଘ\u{b42}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f} ସହ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆଖ\u{b3f}",
                "ଘ\u{b42}ର\u{b41}ଥ\u{b3f}ବ\u{b3e}",
                "ଘ\u{b42}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ଆଖ\u{b3f} ସହ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਖਾ\u{a02} ਘ\u{a41}ਮਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਅ\u{a71}ਕਿਆ ਚਿਹਰਾ",
                "ਅ\u{a71}ਖਾ\u{a02}",
                "ਅ\u{a71}ਖਾ\u{a02} ਘ\u{a41}ਮਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਅ\u{a71}ਖਾ\u{a02} ਘ\u{a41}\u{a70}ਮਾਉਣਾ",
                "ਚਿਹਰਾ",
                "ਮਾਣਹਾਨੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھمدیاں اکھاں نال شکل"),
            keywords: &["اکھاں", "دی شکل", "گھمدا ہوئیا", "گھمدیاں اکھاں نال شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes De Tọ\u{301}n Im Ai-dẹm"),
            keywords: &[
                "Ai-dẹm",
                "Fes",
                "Fes De Tọ\u{301}n Im Ai-dẹm",
                "To Tọn Tọ\u{301}n Yọ Ai-dem",
                "To Tọ\u{301}n Yọ Ai-dẹm",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz przewracająca oczami"),
            keywords: &["buźka", "przewracam oczami", "twarz przewracająca oczami"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تاوهونکو سترګو مخ"),
            keywords: &["تاووهونکې", "د تاوهونکو سترګو مخ", "سترګې", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com olhos revirados"),
            keywords: &[
                "olhos",
                "revirando os olhos",
                "rosto",
                "rosto com olhos revirados",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com olhos revirados"),
            keywords: &["cara", "cara com olhos revirados", "olhos", "revirar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya muyusqa ñawikunawan"),
            keywords: &[
                "muyusqa",
                "muyuy",
                "uya",
                "uya muyusqa ñawikunawan",
                "ñawikuna",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față care dă ochii peste cap"),
            keywords: &["față", "față care dă ochii peste cap", "ochi", "peste cap"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-904"),
            keywords: &["E10-904"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("закатывает глаза"),
            keywords: &[
                "глаза",
                "досада",
                "закатить",
                "закатывает глаза",
                "лицо",
                "скука",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ikanuye amaso"),
            keywords: &["amaso", "ihindukije", "isura", "isura ikanuye amaso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦرندڙ اکين سان چهرو"),
            keywords: &["اکيون", "چهرو", "ڦرندڙ", "ڦرندڙ اکين سان چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කරකවන ඇස\u{dca} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ඇස\u{dca}",
                "කරකවන ඇස\u{dca} ඇත\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
                "කරකැව\u{dd3}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár prevracajúca oči"),
            keywords: &["oči", "prevracať", "tvár", "tvár prevracajúca oči"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z zavijajočimi očmi"),
            keywords: &["obraz", "obraz z zavijajočimi očmi", "oči", "zavijanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji indho wareegayo leh"),
            keywords: &["il wareeg", "waji", "waji indho wareegayo leh", "wareeg"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me sytë që rrotullohen"),
            keywords: &["fytyrë", "fytyrë me sytë që rrotullohen", "rrotullim", "sy"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које колута очима"),
            keywords: &["кoлутaњe", "лице", "лице које колута очима", "очи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице које колута очима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje koluta očima"),
            keywords: &["kolutanje", "lice", "lice koje koluta očima", "oči"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice koje koluta očima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte som\u{a0}himlar med ögonen"),
            keywords: &[
                "ansikte",
                "ansikte som\u{a0}himlar med ögonen",
                "himlar med ögonen",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("usio wenye macho yanayorembua"),
            keywords: &[
                "kubiringika",
                "kurembua",
                "macho",
                "usio wenye macho yanayorembua",
                "uso",
                "uso wenye macho yanayorembua",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}களை உருட\u{bcd}டும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கண\u{bcd}களை உருட\u{bcd}டுதல\u{bcd}",
                "கண\u{bcd}களை உருட\u{bcd}டும\u{bcd} முகம\u{bcd}",
                "கண\u{bcd}களைச\u{bcd} சுழற\u{bcd}றுதல\u{bcd}",
                "கண\u{bcd}களைச\u{bcd} சுழற\u{bcd}றும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కళ\u{c4d}లు త\u{c3f}ప\u{c4d}పుతున\u{c4d}న ముఖం"),
            keywords: &[
                "కళ\u{c4d}లు",
                "కళ\u{c4d}లు త\u{c3f}ప\u{c4d}పుతున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо чашмони даврзананда"),
            keywords: &["даврзанӣ", "рӯй", "рӯй бо чашмони даврзананда", "чашмҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กลอกตา"),
            keywords: &["กลอกตา", "หน\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gözüni agdarýan ýüz"),
            keywords: &["gözler", "gözüni agdarýan ýüz", "togalanýan", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata kilokilo"),
            keywords: &["mata kilokilo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gözlerini deviren yüz"),
            keywords: &["gözler", "gözlerini deviren yüz", "yuvarlanma", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆزى پىرقىرىغان چىراي"),
            keywords: &["ئۆرۈش", "كۆز", "كۆزى پىرقىرىغان چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя із закоченими очима"),
            keywords: &[
                "закочувати",
                "обличчя",
                "обличчя із закоченими очима",
                "очі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھومتی آنکھوں والا چہرہ"),
            keywords: &["آنکھیں", "چہرہ", "گھومتی آنکھوں والا چہرہ", "گھومنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘zlarini aylantirayotgan yuz"),
            keywords: &[
                "aylantirayotgan",
                "ko‘zlar",
                "ko‘zlarini aylantirayotgan yuz",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt có mắt đu đưa"),
            keywords: &["mắt", "mặt", "mặt có mắt đu đưa", "đu đưa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy regeju"),
            keywords: &["bët", "kanam", "kanam guy regeju", "regeju"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunamehlo ajikelezayo"),
            keywords: &[
                "amehlo",
                "ubuso",
                "ubuso obunamehlo ajikelezayo",
                "ukujikeleza",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú Pẹ\u{300}lú Ẹyinjú tó yín"),
            keywords: &[
                "Ojú Pẹ\u{300}lú Ẹyinjú tó yín",
                "ojú",
                "tó yín",
                "àwọn ẹyinjú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("圓碌碌大眼嘅臉"),
            keywords: &["圓碌碌", "圓碌碌大眼嘅臉", "眼", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圆碌碌大眼嘅脸"),
            keywords: &["圆碌碌", "圆碌碌大眼嘅脸", "眼", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("翻白眼"),
            keywords: &["无语", "白眼", "翻白眼", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("翻白眼"),
            keywords: &["不屑", "翻白眼", "鄙視"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("反白眼嘅表情"),
            keywords: &["不屑", "反白眼嘅表情", "鄙視"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obupheqa amehlo"),
            keywords: &["amehlo", "pheqa amehlo", "ubuso", "ubuso obupheqa amehlo"],
        },
    ],
};
#[doc = "😬"]
pub const GRIMACING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😬",
    codepoint: "1F62C",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "grimacing face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("grynsende gesig"),
            keywords: &["gesig", "grynsend", "grynsende gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታሞ የተጨማደደ ፊት"),
            keywords: &["ታሞ የተጨማደደ", "ታሞ የተጨማደደ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه متجهم"),
            keywords: &["عبوس", "وجه متجهم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিক\u{9c3}ত ম\u{9c1}খ"),
            keywords: &[
                "বিক\u{9c3}ত ম\u{9c1}খ",
                "ম\u{9c1}খ",
                "ম\u{9c1}খ বিক\u{9c3}ত কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üz-gözünü turşudan üz"),
            keywords: &["üz", "üz-gözünü turşudan üz", "üz-gözünü turşutmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрыўлены твар"),
            keywords: &["грымаса", "перакошаны", "скрыўлены", "скрыўлены твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с гримаса"),
            keywords: &["Лице с гримаса", "гримаса", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9be}\u{981}ত ব\u{9be}র কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "দ\u{9be}\u{981}ত ব\u{9be}র কর\u{9be} ম\u{9c1}খ",
                "ভেংচ\u{9be}নো",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("grimasa"),
            keywords: &["grimasa", "lice"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que fa una ganyota amb les dents"),
            keywords: &[
                "cara",
                "cara que fa una ganyota amb les dents",
                "dents",
                "ganyota",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᏁᎪᏳᎲᎢ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏓᏁᎪᏳ", "ᎤᏓᏁᎪᏳᎲᎢ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("grimasa s vyceněnými zuby"),
            keywords: &[
                "grimasa",
                "grimasa s vyceněnými zuby",
                "smajlík",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb ag ystum"),
            keywords: &["wyneb", "wyneb ag ystum", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sammenbidt ansigt"),
            keywords: &["ansigt", "lave grimasse", "sammenbidt ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Grimassen schneidendes Gesicht"),
            keywords: &[
                "Gesicht",
                "Grimasse",
                "Grimassen schneidendes Gesicht",
                "Zähne",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γκριμάτσα"),
            keywords: &["γκριμάτσα", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("grimacing face"),
            keywords: &["face", "grimace", "grimacing face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara haciendo una mueca"),
            keywords: &["cara", "cara haciendo una mueca", "mueca"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara haciendo una mueca"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "cara haciendo mueca",
                "cara haciendo una mueca",
                "mueca",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("grimassitav nägu"),
            keywords: &["grimass", "grimassitav nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("imintzio-aurpegia"),
            keywords: &["aurpegi", "imintzio", "imintzio-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دهن\u{200c}کجی"),
            keywords: &["ادا و اصول", "دهن\u{200c}کجی", "شکلک", "صورت", "منزجر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("irvistävä"),
            keywords: &["irvistys", "irvistävä", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangiwi"),
            keywords: &[
                "mukha",
                "nagngingitngit",
                "nagtitiis",
                "nakangiwi",
                "nandidiri",
                "nasasaktan",
                "ngiwi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit ið vísur tenn"),
            keywords: &["andlit", "andlit ið vísur tenn", "snerkja", "tenn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage grimaçant"),
            keywords: &["grimace", "visage", "visage grimaçant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le cár uirthi"),
            keywords: &["aghaidh", "grainc", "straoiseog le cár uirthi"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le drèin air"),
            keywords: &["aodann", "aodann le drèin air", "drèin"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara apertando os dentes"),
            keywords: &["cara", "cara apertando os dentes", "dentes", "nervios"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac7}નચાળા કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ચ\u{ac7}નચાળા",
                "ચ\u{ac7}નચાળા કરતો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska na ɗauren fuska"),
            keywords: &["fuska", "fuska na ɗauren fuska", "ɗauren fuska"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם חיוך מלא שיניים"),
            keywords: &[
                "חיוך",
                "מחייך",
                "פרצוף",
                "פרצוף עם חיוך מלא שיניים",
                "שיניים",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}\u{902}ह बनाता च\u{947}हरा"),
            keywords: &[
                "खिसियाता च\u{947}हरा",
                "च\u{947}हरा",
                "दा\u{902}त निकालना",
                "म\u{941}\u{902}ह बनाता च\u{947}हरा",
                "म\u{941}\u{902}ह बनाना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s grimasom"),
            keywords: &["grimasa", "lice", "lice s grimasom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("grimaszoló arc"),
            keywords: &["arc", "grimasz", "grimaszoló arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծամածռվող դեմք"),
            keywords: &["դեմք", "ծամածռություն", "ծամածռվող դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah menyeringai"),
            keywords: &["menyeringai", "muka", "seringai", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ntachị anya"),
            keywords: &["ihu", "ihu ntachị anya", "ntachi anya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gretta"),
            keywords: &["andlit", "andlit með grettu", "gretta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con smorfia"),
            keywords: &["faccina", "faccina con smorfia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しかめ面"),
            keywords: &["いー", "しかめっ面", "しかめ面", "しかめ顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mringis mbatek"),
            keywords: &["mbatek", "rai", "rai mringis mbatek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დამანჭული სახე"),
            keywords: &["დამანჭვა", "დამანჭული სახე", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бет-аузын қисайту"),
            keywords: &["бет", "бет-аузын қисайту"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sammenbidt ansigt"),
            keywords: &["ansigt", "lave grimasse", "sammenbidt ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខស\u{17d2}អេញស\u{17d2}អ\u{17bc}ញ"),
            keywords: &[
                "ញេញធ\u{17d2}មេញ",
                "ធ\u{17d2}មេញ",
                "ម\u{17bb}ខស\u{17d2}អេញស\u{17d2}អ\u{17bc}ញ",
                "ស\u{17d2}អេញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸೊಟ\u{ccd}ಟ ಮುಖ"),
            keywords: &["ಗಂಟುಮೋರ\u{cc6} ಮುಖ", "ಸೊಟ\u{ccd}ಟ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("찌푸린 얼굴"),
            keywords: &["얼굴", "찌푸린 얼굴", "찡그림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("खिन\u{94d}न तो\u{902}ड"),
            keywords: &["खिन\u{94d}न तो\u{902}ड", "खिन\u{94d}नताय", "च\u{947}रो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кебетесин бузган бет"),
            keywords: &["бет", "буз", "кебете", "кебетесин бузган бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Grimass schneidend Gesiicht"),
            keywords: &["Gesiicht", "Grimass", "Grimass schneidend Gesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າບ\u{eb9}ດບ\u{ec9}ຽວ"),
            keywords: &[
                "ບ\u{eb9}ດບ\u{ec9}ຽວ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າບ\u{eb9}ດບ\u{ec9}ຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besivaipantis veidas"),
            keywords: &["besivaipantis veidas", "grimasa", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("saviebta seja"),
            keywords: &["grimase", "saviebta seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi whāita"),
            keywords: &["kanohi", "whāita"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со гримаса"),
            keywords: &["гримаса", "лице", "лице со гримаса"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗോഷ\u{d4d}\u{200c}ടി ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "കൊഞ\u{d4d}ഞനം ക\u{d41}ത\u{d4d}ത\u{d41}ക",
                "ഗോഷ\u{d4d}\u{200c}ടി",
                "ഗോഷ\u{d4d}\u{200c}ടി ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ярвалзсан царай"),
            keywords: &["царай", "ярвалзсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वाक\u{941}ल\u{94d}या दाखविणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "वाक\u{941}ल\u{94d}या दाखविणारा च\u{947}हरा",
                "वाक\u{941}ल\u{94d}या दाखविण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka menyeringai"),
            keywords: &["menyeringai", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jistmerraħ"),
            keywords: &["jistmerraħ", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{103e}\u{102f}\u{1036}\u{1037}မ\u{1032}\u{1037}နေသော မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာရ\u{103e}\u{102f}\u{1036}\u{1037}ခြင\u{103a}း",
                "ရ\u{103e}\u{102f}\u{1036}\u{1037}မ\u{1032}\u{1037}နေသော မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grimase"),
            keywords: &["fjes", "grimase"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ख बनाएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "म\u{941}ख बनाएको",
                "म\u{941}ख बनाएको अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met grimas"),
            keywords: &["gezicht", "gezicht met grimas", "grimas"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grimase"),
            keywords: &["fjes", "grimase"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}କ\u{b43}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଖତେଇହେବ\u{b3e}",
                "ବ\u{b3f}କ\u{b43}ତ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਚੀਚੀਆ\u{a02} ਲ\u{a48}\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਕਚੀਚੀਆ\u{a02} ਲ\u{a48}\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਬਦਸ\u{a42}ਰਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ بناندی شکل"),
            keywords: &["دی شکل", "منہ بنانا", "منہ بناندی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}glí Fes Wé Sọ\u{301}mtin De Pen"),
            keywords: &[
                "Fes",
                "To Skíz Yọ Fes",
                "Ọ\u{301}glí Fes Wé Sọ\u{301}mtin De Pen",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z grymasem"),
            keywords: &["grymaśna buźka", "twarz z grymasem"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بړوسېدلی مخ"),
            keywords: &["بړوستوب", "بړوسېدلی مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto expressando desagrado"),
            keywords: &[
                "fazendo careta",
                "rosto",
                "rosto expressando desagrado",
                "rosto fazendo careta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a fazer caretas"),
            keywords: &["cara", "cara a fazer caretas", "caretas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya muecaswan"),
            keywords: &["muesca", "uya", "uya muecaswan", "uya muescaswan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu grimasă"),
            keywords: &["față", "față cu grimasă", "grimasă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-880"),
            keywords: &["E10-880"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гримаса"),
            keywords: &["гримаса", "зубы", "лицо", "рожа"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza amenyo"),
            keywords: &["gushinyiriza", "isura", "isura igaragaza amenyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بناوٽي صورت ٺاهيندڙ چهرو"),
            keywords: &["بدصورت بڻائڻ", "بناوٽي صورت ٺاهيندڙ چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd4}ල\u{dd4}ට\u{dd4} කර ගත\u{dca} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ප\u{dd4}ල\u{dd4}ට\u{dd4} කර ගත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
                "ප\u{dd4}ල\u{dd4}ට\u{dd4} කරගත\u{dca}",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vyškerená tvár"),
            keywords: &["grimasa", "tvár", "vyškerená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("spačen obraz"),
            keywords: &["grimasa", "obraz", "spačen obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji naxdin leh"),
            keywords: &["naxdin", "waji", "waji naxdin leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e ngërdheshur"),
            keywords: &["e ngërdheshur", "fytyrë", "fytyrë e ngërdheshur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са гримасом"),
            keywords: &["гримaсa", "лице", "лице са гримасом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa grimasom"),
            keywords: &["grimasa", "lice", "lice sa grimasom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("grimaserande ansikte"),
            keywords: &["grimaserande ansikte", "grimaserar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliokunjwa"),
            keywords: &["kunja", "uso", "uso uliokunjwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பற\u{bcd}களைக\u{bcd} கடிக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "ஈஈஈஈஈஈ!",
                "நக\u{bcd}கல\u{bcd}",
                "பற\u{bcd}களைக\u{bcd} கடிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "பற\u{bcd}களைக\u{bcd} கடித\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}పంత\u{c4b} పళ\u{c4d}లు క\u{c4a}రుకుతున\u{c4d}న ముఖం"),
            keywords: &[
                "క\u{c4b}పం",
                "క\u{c4b}పంత\u{c4b} పళ\u{c4d}లు క\u{c4a}రుకుతున\u{c4d}న ముఖం",
                "పళ\u{c4d}లు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи туршкунанда"),
            keywords: &["рӯи туршкунанда", "рӯй", "рӯй туршкунӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เบะปาก"),
            keywords: &["ย\u{e34}งฟ\u{e31}น", "หน\u{e49}า", "เบะปาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýyrşarýan ýüz"),
            keywords: &["ýyrşarmak", "ýyrşarýan ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata mioʻi"),
            keywords: &["mata mioʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dişlerini gösteren yüz"),
            keywords: &["dişlerini gösteren yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چىشى قېيىشقان چىراي"),
            keywords: &["قېيىشقان", "چىراي", "چىشى قېيىشقان چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя з гримасою"),
            keywords: &[
                "кривляння",
                "обличчя",
                "обличчя з гримасою",
                "скривлене обличчя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مضحکہ خیز چہرہ"),
            keywords: &["مضحکہ خیز چہرہ", "ناگواریت", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("afti burishgan"),
            keywords: &["afti burishgan", "aftini burishtirish", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt nhăn nhó"),
            keywords: &["mặt", "mặt nhăn nhó", "nhăn nhó"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy def yëfi golo"),
            keywords: &["kanam", "kanam guy def yëfi golo", "yëfi golo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obujamileyo"),
            keywords: &["ubuso", "ubuso obujamileyo", "ukujama"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ifaro"),
            keywords: &["Oju Ifaro", "ojú", "ìfaro"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("痛苦嘅臉"),
            keywords: &["痛苦", "痛苦嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("痛苦嘅脸"),
            keywords: &["痛苦", "痛苦嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("龇牙咧嘴"),
            keywords: &["咬牙切齿", "脸", "露齿", "鬼脸", "龇牙咧嘴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("咬牙"),
            keywords: &["咬牙", "咬牙切齒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("依起棚牙"),
            keywords: &["依起棚牙", "咬牙", "咬牙切齒", "繃緊"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuhlinile"),
            keywords: &["hlina", "ubuso", "ubuso obuhlinile"],
        },
    ],
};
#[doc = "😮\u{200d}💨"]
pub const FACE_EXHALING: crate::Emoji = crate::Emoji {
    glyph: "😮\u{200d}💨",
    codepoint: "1F62E 200D 1F4A8",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "face exhaling",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig asem uit"),
            keywords: &[
                "asem uit",
                "fluister",
                "fluit",
                "gesig asem uit",
                "kreun",
                "snak",
                "verlig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ውጭ የሚተነፍስ ገጽ"),
            keywords: &["ወደ ውጭ የሚተነፍስ ገጽ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يزفر الهواء"),
            keywords: &["راحة", "زفير", "صفير", "همس", "وجه يزفر الهواء", "يتلهث"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিশ\u{9be}হ এৰ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "আৰ\u{9be}ম",
                "গে\u{981}থনি",
                "নিশ\u{9be}হ",
                "নিশ\u{9be}হ এৰ\u{9be} ম\u{9c1}খ",
                "ফ\u{9c1}চ-ফ\u{9c1}চনি",
                "ফোফ\u{9be}",
                "স\u{9c1}হ\u{9c1}ৰি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nəfəs alan üz"),
            keywords: &["ciyərəçəkmə", "nəfəs alan üz", "nəfəsalma", "pıçıldama"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар выдыхае"),
            keywords: &[
                "выдых",
                "палёгка",
                "перахапіла дыханне",
                "свіст",
                "твар выдыхае",
                "уздых",
                "шэпт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("издишващо лице"),
            keywords: &[
                "въздъхвам",
                "издишвам",
                "издишващо лице",
                "охкам",
                "пъшкам",
                "шепна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নিশ\u{9cd}ব\u{9be}স ছ\u{9be}ড\u{9bc}\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9be}তর\u{9be}নো",
                "ত\u{9cd}র\u{9be}ণ",
                "নিঃশ\u{9cd}ব\u{9be}স",
                "নিশ\u{9cd}ব\u{9be}স ছ\u{9be}ড\u{9bc}\u{9be} ম\u{9c1}খ",
                "ফিসফিস",
                "ব\u{9be}\u{981}শি",
                "হ\u{9be}\u{981}ফ\u{9be}নো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lice izdiše"),
            keywords: &[
                "dahtanje",
                "izdisanje",
                "lice izdiše",
                "odahnuti",
                "stenjanje",
                "zviždati",
                "šaptati",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que exhala"),
            keywords: &[
                "alleujament",
                "cara que exhala",
                "exhalar",
                "xiulet",
                "xiuxiueig",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vydechující obličej"),
            keywords: &[
                "lapání po dechu",
                "oddechnutí",
                "pískání",
                "vydechnutí",
                "vydechující obličej",
                "výdech",
                "úleva",
                "šepot",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb anadlu allan"),
            keywords: &[
                "anadlu allan",
                "chwiban",
                "ebychu",
                "griddfan",
                "rhyddhad",
                "sibrwd",
                "wyneb anadlu allan",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("udåndende ansigt"),
            keywords: &[
                "ansigt",
                "ekshalerende",
                "fløjt",
                "hvisken",
                "lettelse",
                "pift",
                "pyha",
                "udåndende ansigt",
                "udånding",
                "ånde ud",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht, das ausatmet"),
            keywords: &["Gesicht, das ausatmet"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("ausatmendes Gesicht"),
            keywords: &["ausatmendes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο που ξεφυσάει"),
            keywords: &[
                "ανακούφιση",
                "αναστενάζω",
                "εκπνέω",
                "ξεφυσάω",
                "πρόσωπο που ξεφυσάει",
                "σφυρίζω",
                "ψιθυρίζω",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face exhaling"),
            keywords: &[
                "exhale",
                "face exhaling",
                "gasp",
                "groan",
                "relief",
                "whisper",
                "whistle",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara exhalando"),
            keywords: &[
                "cara",
                "cara exhalando",
                "exhalar",
                "resoplido",
                "respirar",
                "silbato",
                "silbido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väljahingav nägu"),
            keywords: &[
                "kergendus",
                "ohkamine",
                "sosistamine",
                "vilistamine",
                "väljahingamine",
                "väljahingav nägu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arnasa botatzen ari den aurpegia"),
            keywords: &[
                "arnasa botatzen ari den aurpegia",
                "arnasa hartu",
                "arnasestua",
                "hasperena",
                "lasaitua",
                "marmarra",
                "txistua",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورتک در حال بازدم"),
            keywords: &[
                "بازدم",
                "سوت زدن",
                "صورتک در حال بازدم",
                "فوت کردن",
                "نالیدن",
                "نجوا کردن",
                "نفس زدن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hämmästynyt"),
            keywords: &[
                "haukkoa henkeään",
                "helpotus",
                "hämmästynyt",
                "hämmästyä",
                "kuiskaus",
                "puhaltaa",
                "vihellys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang humihinga palabas"),
            keywords: &["mukhang humihinga palabas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit andar út"),
            keywords: &["anda út", "andlit andar út", "bríksla", "floyta", "suffa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage expirant"),
            keywords: &[
                "chuchoter",
                "expiration",
                "siffler",
                "soulagement",
                "sursaut",
                "visage expirant",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh ag análú"),
            keywords: &[
                "aghaidh ag análú",
                "anáil",
                "cnead",
                "cogar",
                "faoiseamh",
                "ochlán",
                "séideadh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodan a’ leigeil anail"),
            keywords: &[
                "anail",
                "aodan a’ leigeil anail",
                "cagar",
                "cnead",
                "cogar",
                "faochadh",
                "fead",
                "leig anail",
                "leig d’ anail",
                "leigeil anail",
                "plosg",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara exhalando"),
            keywords: &[
                "alivio",
                "asubiar",
                "bafexar",
                "cara exhalando",
                "folguexar",
                "resollar",
                "respirar",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શ\u{acd}વાસ છોડતો ચહ\u{ac7}રો"),
            keywords: &[
                "કણસવ\u{ac1}\u{a82}",
                "ગ\u{ac1}સપ\u{ac1}સ",
                "રાહત",
                "શ\u{acd}વાસ છોડતો ચહ\u{ac7}રો",
                "શ\u{acd}વાસ છોડવો",
                "સીટી",
                "હા\u{a82}ફવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף נושף"),
            keywords: &["הפתעה", "לוחש", "משתנק", "מתנשם", "נושף", "פרצוף נושף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सा\u{902}स छोड\u{93c}ता ह\u{941}आ च\u{947}हरा"),
            keywords: &["सा\u{902}स छोड\u{93c}ता ह\u{941}आ च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje izdiše"),
            keywords: &[
                "izdisaj",
                "lice koje izdiše",
                "olakšanje",
                "stenjanje",
                "uzdah",
                "zvižduk",
                "šapat",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("levegőt kifújó arc"),
            keywords: &["levegőt kifújó arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արտաշնչող դեմք"),
            keywords: &[
                "արտաշնչել",
                "արտաշնչող դեմք",
                "թեթևություն",
                "հոգոց",
                "հևալ",
                "հևոց",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah mengembuskan napas"),
            keywords: &["wajah mengembuskan napas"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit að anda frá sér"),
            keywords: &[
                "andköf",
                "andlit að anda frá sér",
                "blístur",
                "hvísl",
                "léttir",
                "stuna",
                "útöndun",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che espira"),
            keywords: &["faccina che espira"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("息を吐く顔"),
            keywords: &[
                "あきらめ",
                "ため息",
                "ほっとした",
                "安心",
                "息を吐く顔",
                "顔",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ambegan lego"),
            keywords: &[
                "ambegan",
                "lega",
                "mbisiki",
                "megap-megap",
                "nglenguh",
                "rai ambegan lego",
                "singsot",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ამოსუნთქვა"),
            keywords: &["ამოოხვრა", "ამოსუნთქვა", "თურჩული", "სტვენა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ауаны шығарып тұрған бет"),
            keywords: &["ауаны шығарып тұрған бет"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខដកដង\u{17d2}ហើមចេញ"),
            keywords: &[
                "ខ\u{17bd}ច",
                "ខ\u{17d2}ស\u{17b9}ប",
                "ដកដង\u{17d2}ហើមចេញ",
                "ដង\u{17d2}ហក\u{17cb}",
                "ថ\u{17d2}ង\u{17bc}រ",
                "ធ\u{17bc}រច\u{17b7}ត\u{17d2}ត",
                "ម\u{17bb}ខដកដង\u{17d2}ហើមចេញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ಟ\u{ccd}ಟುಸ\u{cbf}ರು ಇಡುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &["ನ\u{cbf}ಟ\u{ccd}ಟುಸ\u{cbf}ರು ಇಡುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("날숨 쉬는 얼굴"),
            keywords: &["날숨", "날숨 쉬는 얼굴", "속삭임", "안도", "한숨", "휘파람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{94d}वास सोडपी च\u{947}रो"),
            keywords: &[
                "शिटी मारप",
                "शिळोणी घालप",
                "श\u{94d}वास सोडप",
                "श\u{94d}वास सोडपी च\u{947}रो",
                "स\u{941}स\u{94d}कारप",
                "ह\u{941}\u{902}कार भरप",
                "ह\u{941}स\u{94d}क\u{94d}याम\u{947}कळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("үшкүрүнгөн жүз"),
            keywords: &["үшкүрүнгөн жүз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຫາຍໃຈອອກ"),
            keywords: &[
                "ຊ\u{eb6}\u{ec8}ມ",
                "ຫາຍໃຈອອກ",
                "ອ\u{ec9}າປາກຫາຍໃຈ",
                "ຮ\u{ec9}ອງຄາງ",
                "ເປ\u{ebb}\u{ec8}າປາກ",
                "ໂລ\u{ec8}ງໃຈ",
                "ໜ\u{ec9}າຫາຍໃຈອອກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su garu"),
            keywords: &[
                "dejuoti",
                "gaudyti",
                "iškvėpti",
                "reljefas",
                "veidas su garu",
                "šnabždesys",
                "švilpukas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja nopūšas"),
            keywords: &[
                "atvieglojums",
                "izelpa",
                "nopūta",
                "seja nopūšas",
                "svilpošana",
                "vaids",
                "čuksti",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице издишува"),
            keywords: &[
                "восклик",
                "издишување",
                "лице издишува",
                "олеснување",
                "свиркање",
                "стенкање",
                "шепот",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോപ\u{d3e}ക\u{d41}ല മ\u{d41}ഖം"),
            keywords: &["കോപ\u{d3e}ക\u{d41}ല മ\u{d41}ഖം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амьсгалж буй царай"),
            keywords: &[
                "аахилах",
                "амьсгаа гаргах",
                "амьсгалж буй царай",
                "исгэрэх",
                "санаа алдах",
                "санаа амрах",
                "шүгэлдэх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उच\u{94d}छवास टाकणारा च\u{947}हरा"),
            keywords: &[
                "आराम",
                "उच\u{94d}छवास टाकणारा च\u{947}हरा",
                "उच\u{94d}छवास टाकण\u{947}",
                "कण\u{94d}हण\u{947}",
                "क\u{941}जब\u{941}ज",
                "धाप",
                "शिटी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka menghembuskan nafas"),
            keywords: &["muka menghembuskan nafas"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သက\u{103a}ပြင\u{103a}းချ မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ညည\u{103a}းခြင\u{103a}း",
                "တ\u{102e}းတ\u{102d}\u{102f}းပြောခြင\u{103a}း",
                "ပင\u{1037}\u{103a}သက\u{103a}ရ\u{103e}\u{102d}\u{102f}က\u{103a}ခြင\u{103a}း",
                "ရ\u{103e}\u{1030}ထ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "လေချ\u{103d}န\u{103a}ခြင\u{103a}း",
                "သက\u{103a}ပြင\u{103a}းချ မျက\u{103a}န\u{103e}ာ",
                "ဟင\u{103a}းချခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("puster ut"),
            keywords: &[
                "fjes",
                "gispe",
                "hviske",
                "lettet",
                "plystre",
                "puste ut",
                "puster ut",
                "sukke",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}खबाट सास फाल\u{94d}न\u{947}"),
            keywords: &[
                "कान\u{947}ख\u{941}शी",
                "गहिरो आवाज निकाल\u{94d}न\u{941}",
                "म\u{941}खबाट सास फाल\u{94d}न\u{947}",
                "राहत",
                "सास फाल\u{94d}न\u{947}",
                "सीटी",
                "हा\u{901}सो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht dat uitademt"),
            keywords: &[
                "fluisteren",
                "fluiten",
                "gezicht dat uitademt",
                "kreunen",
                "naar adem snakken",
                "opgelucht",
                "uitademen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pustar ut"),
            keywords: &[
                "fjes",
                "gispe",
                "kviskre",
                "letta",
                "plystre",
                "pustar ut",
                "puste ut",
                "sukke",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਾਹ ਭਰਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਘ\u{a41}ਸਰ-ਮ\u{a41}ਸਰ",
                "ਰਾਹਤ",
                "ਸਾਹ ਬਾਹਰ ਕ\u{a71}ਢਣਾ । ਸਿਸਕੀ",
                "ਸਾਹ ਭਰਦਾ",
                "ਸਾਹ ਭਰਦਾ ਚਿਹਰਾ",
                "ਸੀਟੀ",
                "ਹ\u{a42}\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Brít Ea Kọmọt"),
            keywords: &[
                "Brít Ea Kọmọt",
                "Fes Wé De Brít Ea Kọmọt",
                "Gasp",
                "Gron",
                "To Fíl Hápi",
                "Tọ\u{301}k Sọ\u{301}fli Fọ Pẹ\u{301}sin Mék Ónlí Am Hia",
                "Wíspa",
                "Wísul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz wypuszczająca powietrze"),
            keywords: &[
                "gwizd",
                "twarz wypuszczająca powietrze",
                "ulga",
                "westchnienie",
                "wydmuchiwać powietrze",
                "wypuszczać powietrze",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تنفس مخ"),
            keywords: &[
                "خولې",
                "د تنفس مخ",
                "راحت",
                "ساه ایستل",
                "سیټي",
                "څاڅکی",
                "ګاز",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto exalando"),
            keywords: &[
                "alívio",
                "assobio",
                "assovio",
                "choque",
                "exalar",
                "rosto exalando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a exalar"),
            keywords: &["alívio", "assobio", "cara a exalar", "choque", "exalar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya samachkan"),
            keywords: &[
                "anchhiy",
                "ansaqiy",
                "jinchuy",
                "llamsayay",
                "samay",
                "uya samachkan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față care expiră"),
            keywords: &[
                "expirare",
                "față care expiră",
                "fluierat",
                "oftat",
                "răsuflare",
                "ușurare",
                "șoptit",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-001"),
            keywords: &["E13.1-001"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("выдыхает"),
            keywords: &[
                "вздох",
                "выдох",
                "выдыхает",
                "облегчение",
                "одышка",
                "свист",
                "шепот",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساه ڇڏڻ وارو چهرو"),
            keywords: &[
                "آرام",
                "ساه ٻاهر ڪڍڻ",
                "ساه ڇڏڻ وارو چهرو",
                "سس پس ڪرڻ",
                "سهڪڻ",
                "سيٽي وڄائڻ",
                "ڪرڪڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd4}ස\u{dca}ම හෙළන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අම\u{dcf}ර\u{dd4}වෙන\u{dca} හ\u{dd4}ස\u{dca}ම ගැන\u{dd3}ම",
                "කෙඳ\u{dd2}ර\u{dd2}ය",
                "කෙඳ\u{dd2}ර\u{dd3}ම",
                "ප\u{dd2}ඹ\u{dd3}ම",
                "සහනය",
                "හ\u{dd4}ස\u{dca}ම හෙළන ම\u{dd4}හ\u{dd4}ණ",
                "හ\u{dd4}ස\u{dca}ම හෙළ\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vydychujúca tvár"),
            keywords: &[
                "hvízdať",
                "pískať",
                "stenať",
                "vydychujúca tvár",
                "vydýchnuť",
                "vzdychať",
                "úľava",
                "šepkať",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki izdihne"),
            keywords: &[
                "godrnjanje",
                "izdih",
                "obraz, ki izdihne",
                "olajšanje",
                "sopih",
                "šepet",
                "žvižganje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji afka kala qaday"),
            keywords: &[
                "foodhyid",
                "hawo qadasho",
                "nafisid",
                "neefsasho",
                "taah",
                "waji afka kala qaday",
                "xanshaashaq",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me shfryrje"),
            keywords: &[
                "fishkëllimë",
                "fytyrë me shfryrje",
                "lehtësim",
                "psherëtimë",
                "rënkim",
                "shfryrje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице издише"),
            keywords: &["лице издише"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице издише"),
            keywords: &["лице издише"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice izdiše"),
            keywords: &["lice izdiše"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice izdiše"),
            keywords: &["lice izdiše"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte andas ut"),
            keywords: &["ansikte andas ut"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaopumua"),
            keywords: &[
                "binja",
                "farijika",
                "kite",
                "kukamata",
                "nong’ona",
                "pumua",
                "uso unaopumua",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூச\u{bcd}சுவிடும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "ஆசுவ\u{bbe}சம\u{bcd}",
                "ஊதல\u{bcd}",
                "குசுகுசுப\u{bcd}பு",
                "பெருமூச\u{bcd}சு",
                "மூச\u{bcd}சுத\u{bcd}திணறல\u{bcd}",
                "மூச\u{bcd}சுவிடுதல\u{bcd}",
                "மூச\u{bcd}சுவிடும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉచ\u{c4d}ఛ\u{c4d}వ\u{c3e}స త\u{c40}సుకుంటున\u{c4d}న ముఖం"),
            keywords: &["ఉచ\u{c4d}ఛ\u{c4d}వ\u{c3e}స త\u{c40}సుకుంటున\u{c4d}న ముఖం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าหายใจออก"),
            keywords: &["หน\u{e49}าหายใจออก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bugarýan ýüz"),
            keywords: &[
                "bugarmak",
                "bugarýan ýüz",
                "demikmek",
                "iňňildi",
                "pyşyrdy",
                "rahatlamak",
                "sykylyk",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata hō"),
            keywords: &["mata hō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("nefes veren yüz"),
            keywords: &[
                "fısıldama",
                "nefes veren yüz",
                "nefes verme",
                "rahatlama",
                "sızlanma",
                "ıslık",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що видихає"),
            keywords: &[
                "вдих",
                "видих",
                "обличчя, що видихає",
                "полегшення",
                "свист",
                "стогін",
                "шепотіння",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سانس چھوڑنے والا چہرہ"),
            keywords: &["سانس چھوڑنے والا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nafas chiqarayotgan yuz"),
            keywords: &[
                "havo olish",
                "hustak chalish",
                "ingrash",
                "nafas chiqarayotgan yuz",
                "nafas chiqarish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt thở ra"),
            keywords: &[
                "huýt sáo",
                "mặt thở ra",
                "rên rỉ",
                "thì thầm",
                "thở hổn hển",
                "thở ra",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嘆氣嘅臉"),
            keywords: &[
                "吹口哨",
                "呻吟",
                "呼氣",
                "喘氣",
                "嘆氣嘅臉",
                "耳語",
                "鬆一口氣",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("叹气嘅脸"),
            keywords: &[
                "叹气嘅脸",
                "吹口哨",
                "呻吟",
                "呼气",
                "喘气",
                "松一口气",
                "耳语",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("呼气"),
            keywords: &["呼气"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鬆一口氣"),
            keywords: &["倒抽一口氣", "呻吟", "鬆一口氣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "🤥"]
pub const LYING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤥",
    codepoint: "1F925",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "lying face",
    group: "Smileys & Emotion",
    subgroup: "face-neutral-skeptical",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat jok"),
            keywords: &["gesig", "gesig wat jok", "jok", "leuen", "lieg", "onwaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚዋሽ ፊት"),
            keywords: &["ውሸት", "የሚዋሽ ፊት", "ፊት", "ፒኖኪዮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه كاذب"),
            keywords: &["كذب", "وجه", "وجه كاذب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মিছ\u{9be} কোৱ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "পিনোচিয\u{9bc}ো",
                "মিছ\u{9be}",
                "মিছ\u{9be} কোৱ\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yalançı adam üzü"),
            keywords: &["adam", "yalançı", "üzü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар хлуса"),
            keywords: &["пінокіа", "твар", "твар хлуса", "хлусня"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("лъжещо лице"),
            keywords: &["лице", "лъжа", "лъжещо лице", "пинокио"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মিথ\u{9cd}য\u{9c1}কের ন\u{9be}ক লম\u{9cd}ব\u{9be}"),
            keywords: &[
                "পিন\u{9be}কিও",
                "মিথ\u{9cd}য\u{9be}",
                "মিথ\u{9cd}য\u{9c1}কের ন\u{9be}ক লম\u{9cd}ব\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("laganje"),
            keywords: &["laganje", "laž", "lice", "pinokio"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de mentider"),
            keywords: &["Pinotxo", "cara", "cara de mentider", "mentider", "nas"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏍᎪᏅᏍᎦ ᎤᎧᏛ"),
            keywords: &["ᎠᎵᏍᎪᏅᏍᎦ ᎤᎧᏛ", "ᎠᏓ ᎠᏧᏣ", "ᎠᏛᏍᎪᏅ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej lháře"),
            keywords: &[
                "lhát",
                "obličej lháře",
                "pinocchio",
                "smajlík",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb celwydd"),
            keywords: &["celwydd", "pinocchio", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løgneransigt"),
            keywords: &[
                "ansigt",
                "lang næse",
                "lyver",
                "løgn",
                "løgneransigt",
                "pinocchio",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lügendes Gesicht"),
            keywords: &["Gesicht", "Lüge", "Pinocchio-Nase", "lügendes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φάτσα ψεύτη"),
            keywords: &["πινόκιο", "πρόσωπο", "φάτσα ψεύτη", "ψέμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lying face"),
            keywords: &["face", "lie", "lying face", "pinocchio"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de mentiroso"),
            keywords: &["cara", "cara de mentiroso", "mentiroso", "nariz", "pinocho"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara de mentiroso", "mentira", "nariz", "pinocho"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valetav nägu"),
            keywords: &["nägu", "vale", "valetav nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi gezurtia"),
            keywords: &["aurpegi", "aurpegi gezurtia", "gezur", "pinotxo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت دروغگو"),
            keywords: &[
                "دروغ",
                "دروغگو",
                "دماغ دراز",
                "دماغ\u{200c}دراز",
                "صورت دروغگو",
                "پینوکیو",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valehteleva"),
            keywords: &["kasvot", "valehdella", "valehteleva", "valehtelija"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagsisinungaling"),
            keywords: &["mukha", "nagsisinungaling", "pinocchio", "sinungaling"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit sum lýgur"),
            keywords: &["andlit", "andlit sum lýgur", "lygn", "pinocchio"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage de menteur"),
            keywords: &[
                "mensonge",
                "menteur",
                "pinocchio",
                "visage",
                "visage de menteur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "mensonge",
                "menteur",
                "pinocchio",
                "visage",
                "visage de menteur",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag insint bréag"),
            keywords: &[
                "aghaidh",
                "bréaga",
                "pinocchio",
                "straoiseog ag insint bréag",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann nam breug"),
            keywords: &["aodann", "aodann nam breug", "breug", "pinocchio"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de mentirán"),
            keywords: &[
                "Pinocchio",
                "cara de mentirán",
                "mentireiro",
                "mentirán",
                "nariz",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખોટ\u{ac1}\u{a82} બોલવાવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "ખોટ\u{ac1}\u{a82}",
                "ખોટ\u{ac1}\u{a82} બોલવાવાળો ચહ\u{ac7}રો",
                "ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai yin ƙarya"),
            keywords: &["fuska", "fuska mai yin ƙarya", "pinocchio", "ƙarya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם אף פינוקיו"),
            keywords: &["אף ארוך", "פינוקיו", "פרצוף עם אף פינוקיו", "שקר", "שקרן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("झ\u{942}ठ बोलता च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "झ\u{942}ठ",
                "झ\u{942}ठ बोलता च\u{947}हरा",
                "पिनोकिओ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje laže"),
            keywords: &["laganje", "laž", "lice", "lice koje laže", "pinokio"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("hazudó arc"),
            keywords: &["arc", "hazudik", "hazudó", "hazudós", "pinokkió"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաբող դեմք"),
            keywords: &["դեմք", "խաբող դեմք", "պինոկիո", "սուտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bohong"),
            keywords: &["bohong", "muka", "pinokio", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Ihu asị"),
            keywords: &["Ihu asị", "gosiri", "ihu", "mgbagwojuanya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lygari"),
            keywords: &["andlit", "gosi", "ljúga", "lygari", "lygi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina bugiarda"),
            keywords: &[
                "bugia",
                "bugiardo",
                "faccina bugiarda",
                "naso lungo",
                "pinocchio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("うそつきの顔"),
            keywords: &["うそつきの顔", "ピノキオの顔", "嘘つき", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngapusi"),
            keywords: &["ngapusi", "pinokio", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მატყუარა სახე"),
            keywords: &["მატყუარა სახე", "პინოქიო", "სახე", "ტყუილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өтірікші"),
            keywords: &["Пиноккио", "өтірік", "өтірікші"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("løgneransigt"),
            keywords: &[
                "ansigt",
                "lang næse",
                "lyver",
                "løgn",
                "løgneransigt",
                "pinocchio",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17bb}ហក"),
            keywords: &[
                "pinocchio",
                "ក\u{17bb}ហក",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខក\u{17bb}ហក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುಳ\u{ccd}ಳುಗಾರ ಮುಖ"),
            keywords: &[
                "ಪ\u{cbf}ನಾಷ\u{cbf}ಯೋ",
                "ಮುಖ",
                "ಸುಳ\u{ccd}ಳು",
                "ಸುಳ\u{ccd}ಳುಗಾರ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("거짓말하는 얼굴"),
            keywords: &[
                "거짓말",
                "거짓말쟁이",
                "거짓말하는 얼굴",
                "얼굴",
                "피노키오",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फटकिरो च\u{947}रो"),
            keywords: &["च\u{947}रो", "पिनोचियो", "फट", "फटकिरो च\u{947}रो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жалганчы бет"),
            keywords: &["бет", "жалган", "жалганчы бет", "пиноккио"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ligenergesiicht"),
            keywords: &["Gesiicht", "Ligenergesiicht", "Pinocchio", "léien"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຂ\u{eb5}\u{ec9}ຕ\u{ebb}ວ"),
            keywords: &[
                "ຕ\u{ebb}ວະ",
                "ພ\u{eb4}ນ\u{eb1}ອກຄ\u{eb4}ໂອ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຂ\u{eb5}\u{ec9}ຕ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("meluojantis veidas"),
            keywords: &["melas", "meluojantis veidas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("melojoša seja"),
            keywords: &["meli", "melojoša seja", "pinokio", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi teka"),
            keywords: &["kanohi", "pinōkio", "teka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лажење"),
            keywords: &["лаже", "лажење", "лице", "пинокио"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കള\u{d4d}ളലക\u{d4d}ഷണം"),
            keywords: &["കള\u{d4d}ളം", "കള\u{d4d}ളലക\u{d4d}ഷണം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("худалч царай"),
            keywords: &["пиноккио", "худалч", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("खोटारडा च\u{947}हरा"),
            keywords: &[
                "खोट\u{902}",
                "खोटारडा च\u{947}हरा",
                "च\u{947}हरा",
                "पिनोकिओ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bohong"),
            keywords: &["bohong", "muka", "pinocchio"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jigdeb"),
            keywords: &["jigdeb", "pinocchio", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{1030}လ\u{102d}မ\u{103a}ရ\u{102f}ပ\u{103a}"),
            keywords: &[
                "ရ\u{102f}ပ\u{103a}",
                "လ\u{102d}မ\u{103a}လည\u{103a}",
                "လ\u{1030}လ\u{102d}မ\u{103a}ရ\u{102f}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lyver"),
            keywords: &["fjes", "lyver", "løgn", "pinocchio"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("झ\u{941}ट बोल\u{947}को झल\u{94d}किन\u{947} अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "झ\u{941}ट",
                "झ\u{941}ट बोल\u{947}को झल\u{94d}किन\u{947} अन\u{941}हार",
                "पिनोच\u{94d}चियो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("liegend gezicht"),
            keywords: &["gezicht", "liegen", "liegend gezicht", "pinokkio"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lyg"),
            keywords: &["fjes", "lyg", "løgn", "pinocchio"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b3f}ଛ କହ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ପ\u{b3f}ନୋକ\u{b3f}ଓ",
                "ମ\u{b3f}ଛ",
                "ମ\u{b3f}ଛ କହ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝ\u{a42}ਠਾ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਝ\u{a42}ਠ", "ਝ\u{a42}ਠਾ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جھوٹ بولدی شکل"),
            keywords: &["بالاں دی کہانی دا ہیرو", "جھوٹ", "جھوٹ بولدی شکل", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lai-laí Fes"),
            keywords: &["Fes", "Lai", "Lai-laí Fes", "Pinókio", "lai Laí Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz kłamcy"),
            keywords: &["długi nos", "kłamać", "pinokio", "twarz kłamcy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دروغ مخ"),
            keywords: &["دروغ", "مخ", "پينوشو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto de mentiroso"),
            keywords: &[
                "mentindo",
                "mentira",
                "mentiroso",
                "pinóquio",
                "rosto de mentiroso",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara de mentiroso"),
            keywords: &["cara", "cara de mentiroso", "mentira", "pinóquio"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llullakusqa uya"),
            keywords: &["llullakusqa uya", "llullakuy", "pinocho", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fața mincinoasă"),
            keywords: &["fața mincinoasă", "față", "minciună", "pinocchio"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1031"),
            keywords: &["E10-1031"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лжец"),
            keywords: &["буратино", "врать", "длинный нос", "лжец", "обманывать"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kubeshya"),
            keywords: &["isura", "isura igaragaza kubeshya", "kubeshya", "pinokiyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪوڙ ڳالهائيندڙ چهرو"),
            keywords: &["چهرو", "ڪوڙ", "ڪوڙ ڳالهائيندڙ چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බොර\u{dd4}ක\u{dd2}යන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ප\u{dd2}නොක\u{dd2}යෝ",
                "බොර\u{dd4}ක\u{dd2}යන ම\u{dd4}හ\u{dd4}ණ",
                "බොර\u{dd4}ව",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s\u{a0}dlhým nosom"),
            keywords: &[
                "klamať",
                "klamstvo",
                "lož",
                "tvár",
                "tvár s\u{a0}dlhým nosom",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lažnivi obraz"),
            keywords: &["laž", "lažnivec", "lažnivi obraz", "ostržek"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji jiifo"),
            keywords: &["jiif", "qashin", "waji", "waji jiifo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë mashtrimi"),
            keywords: &[
                "fytyrë",
                "fytyrë mashtrimi",
                "gënjeshtar",
                "mashtrim",
                "pinok",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лажљивац"),
            keywords: &["лаж", "лажљивац", "лица", "нос", "пинокио"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лажљивац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lažljivac"),
            keywords: &["laž", "lažljivac", "lica", "nos", "pinokio"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lažljivac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ljugande ansikte"),
            keywords: &["ansikte", "ljugande ansikte", "lögn", "pinocchio"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaodanganya"),
            keywords: &["kudanganya", "pinocchio", "uso unaodanganya", "uwongo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பொய\u{bcd} கூறும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "ஏம\u{bbe}ற\u{bcd}றுவேலை",
                "பொய\u{bcd}",
                "பொய\u{bcd} கூறும\u{bcd} முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అబద\u{c4d}ధమ\u{c3e}డుతున\u{c4d}న ముఖం"),
            keywords: &[
                "అబద\u{c4d}ధం",
                "అబద\u{c4d}ధమ\u{c3e}డుతున\u{c4d}న ముఖం",
                "ప\u{c40}క\u{c3f}య\u{c4b}",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи дурӯғгӯ"),
            keywords: &["пиноккио", "рӯи дурӯғгӯ", "рӯй", "хобидан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ข\u{e35}\u{e49}โกหก"),
            keywords: &[
                "ข\u{e35}\u{e49}จ\u{e38}\u{e4a}",
                "ข\u{e35}\u{e49}โกหก",
                "จม\u{e39}กยาว",
                "พ\u{e34}น\u{e47}อคค\u{e34}โอ",
                "หน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýalançy ýüz"),
            keywords: &["buratino", "ýalan", "ýalançy ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe ihu lōloa"),
            keywords: &["mata moe ihu lōloa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yalan söyleyen yüz"),
            keywords: &["pinokyo", "yalan söyleme", "yalan söyleyen yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يالغانچى چىراي"),
            keywords: &["يالغانچى", "پىنوچىيو", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що бреше"),
            keywords: &["брехня", "обличчя", "обличчя, що бреше", "піноккіо"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جھوٹ بولتا چہرہ"),
            keywords: &["جھوٹ", "جھوٹ بولتا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aldayotgan"),
            keywords: &["aldayotgan", "pinokkio", "yolg‘on", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt nói dối"),
            keywords: &["mặt", "mặt nói dối", "nói dối", "pinocchio"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu fenkat"),
            keywords: &["buy fen", "kanamu", "kanamu fenkat", "pinocchio"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuxokayo"),
            keywords: &["u-pinocchio", "ubuso", "ubuso obuxokayo", "xoka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Irọ"),
            keywords: &["Oju Irọ", "irọ\u{301}", "ojú", "onímú gígùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("講大話嘅臉"),
            keywords: &["木偶奇遇記", "臉", "講大話", "講大話嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("讲大话嘅脸"),
            keywords: &["木偶奇遇记", "脸", "讲大话", "讲大话嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("说谎"),
            keywords: &["匹诺曹", "脸", "说谎", "长鼻子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鼻子變長了"),
            keywords: &["小木偶", "變", "長", "鼻", "鼻子變長了"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["講大話嘅表情", "鼻子變長了"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amanga"),
            keywords: &["amanga", "ubuso", "upopayi"],
        },
    ],
};
