#[doc = "🤗"]
pub const HUGGING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤗",
    codepoint: "1F917",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hugging face",
    group: "Smileys & Emotion",
    subgroup: "face-hand",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat drukkie gee"),
            keywords: &["drukkie", "gesig", "gesig wat drukkie gee"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እያቀፈ ያለ ፊት"),
            keywords: &["መተቃቀፍ", "ማቀፍ", "እያቀፈ ያለ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يعانق بابتسامة"),
            keywords: &["عناق", "وجه", "وجه بابتسامة عناق", "وجه يعانق بابتسامة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আলিঙ\u{9cd}গন কৰ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "আলিঙ\u{9cd}গন",
                "আলিঙ\u{9cd}গন কৰ\u{9be}",
                "আলিঙ\u{9cd}গন কৰ\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qucaqlayan üz"),
            keywords: &["qucaqlama", "qucaqlayan üz", "qucaqlaşmaq", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("абдымкі"),
            keywords: &["абдымае", "абдымкі", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Прегръщащо лице"),
            keywords: &["Прегръщащо лице", "лице", "прегръдка", "прегръщам"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আলিঙ\u{9cd}গনরত ম\u{9c1}খ"),
            keywords: &[
                "আলিঙ\u{9cd}গন",
                "আলিঙ\u{9cd}গন রত",
                "আলিঙ\u{9cd}গনরত ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zagrljaj"),
            keywords: &["lice", "zagrliti", "zagrljaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb abraçada"),
            keywords: &["abraçada", "cara", "cara amb abraçada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏄᎩᏢᏍᎩ ᎤᎧᏛ"),
            keywords: &["ᎠᏄᎩᏟᏗ", "ᎠᏄᎩᏢᏍᎩ ᎤᎧᏛ", "ᎠᏓᏄᎩᏢᏍᎩ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s otevřenou náručí"),
            keywords: &[
                "obejmout",
                "objetí",
                "obličej s otevřenou náručí",
                "smajlík",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn rhoi cwtsh"),
            keywords: &["cwtsh", "wyneb", "wyneb yn rhoi cwtsh"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krammende ansigt"),
            keywords: &[
                "ansigt",
                "knus",
                "knuser",
                "kram",
                "kramme",
                "krammende ansigt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit umarmenden Händen"),
            keywords: &[
                "Gesicht",
                "Gesicht mit umarmenden Händen",
                "Umarmung",
                "umarmen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγκαλιά"),
            keywords: &["αγκαλιά", "αγκαλιάζω", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hugging face"),
            keywords: &["face", "hug", "hugging"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con manos abrazando"),
            keywords: &["abrazo", "cara", "cara con manos abrazando", "sonrisa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["abrazo", "cara", "cara con manos abrazando"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kallistav nägu"),
            keywords: &["kallistamine", "kallistav nägu", "kallistus", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("besarkada ematen ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "besarkada",
                "besarkada ematen ari den aurpegia",
                "besarkatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بغل کردن"),
            keywords: &["آغوش", "بغل کردن", "در آغوش گرفتن", "صورت", "لبخند"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("halaava naama"),
            keywords: &["halaava naama", "halaus", "hali", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nangyayakap"),
            keywords: &["gesture", "mukha", "nangyayakap", "yakap"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klemmandi andlit"),
            keywords: &["andlit", "klemm", "klemmandi andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui fait un câlin"),
            keywords: &["câlin", "gentil", "visage", "visage qui fait un câlin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage heureux et câlin"),
            keywords: &["câlin", "visage", "visage heureux et câlin"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag tabhairt barróige"),
            keywords: &[
                "ag beir barróg",
                "aghaidh",
                "barróg",
                "straoiseog ag tabhairt barróige",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ pasgadh gàirdeanan timcheall"),
            keywords: &[
                "aodann",
                "aodann a’ pasgadh gàirdeanan timcheall",
                "gàirdeanan",
                "pasgadh",
                "timcheall",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara dando un abrazo"),
            keywords: &["abrazo", "cara", "cara dando un abrazo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આલિ\u{a82}ગન કરતો ચહ\u{ac7}રો"),
            keywords: &[
                "આલિ\u{a82}ગન",
                "આલિ\u{a82}ગન કરતો ચહ\u{ac7}રો",
                "આલિ\u{a82}ગન કરવ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai runguma"),
            keywords: &["fuska", "fuska mai runguma", "mai runguma", "runguma"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחבק"),
            keywords: &["חיבוק", "ידיים", "מחייך", "פרצוף", "פרצוף מחבק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गल\u{947} लगाता ह\u{941}आ च\u{947}हरा"),
            keywords: &[
                "गल\u{947} लगाता ह\u{941}आ",
                "गल\u{947} लगाता ह\u{941}आ च\u{947}हरा",
                "गल\u{947} लगाना",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje grli"),
            keywords: &["grljenje", "lice", "lice koje grli", "zagrljaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ölelés"),
            keywords: &["arc", "ölelés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրկող դեմք"),
            keywords: &["գրկախառնում", "գրկախառնվել", "գրկող դեմք", "դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah memeluk"),
            keywords: &["muka", "peluk", "wajah", "wajah memeluk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu mmakọ\u{300}"),
            keywords: &["ihu", "ihu mmakọ\u{300}", "mmakọ", "na-amakọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("faðmandi andlit"),
            keywords: &["andlit", "faðmandi andlit", "faðmar", "faðmlag"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che abbraccia"),
            keywords: &["abbraccio", "faccina", "faccina che abbraccia", "sorriso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハグ"),
            keywords: &["スマイル", "ハグ", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai nyikep"),
            keywords: &["nyikep", "rai", "sikep"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩახუტების გამომხატველი სახე"),
            keywords: &["სახე", "ჩახუტება", "ჩახუტების გამომხატველი სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem yefkan ahennec"),
            keywords: &["udem yefkan ahennec"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құшақтау"),
            keywords: &["бет", "құшақ", "құшақтау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krammende ansigt"),
            keywords: &[
                "ansigt",
                "knus",
                "knuser",
                "kram",
                "kramme",
                "krammende ansigt",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខបង\u{17d2}ហាញដៃទា\u{17c6}ងព\u{17b8}រចង\u{17cb}អោប"),
            keywords: &[
                "ញញ\u{17b9}ម",
                "បាតដៃ",
                "ម\u{17bb}ខបង\u{17d2}ហាញដៃទា\u{17c6}ងព\u{17b8}រចង\u{17cb}អោប",
                "អោប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಪ\u{ccd}ಪ\u{cbf}ಕೊಳ\u{ccd}ಳುವ ಮುಖ"),
            keywords: &[
                "ಅಪ\u{ccd}ಪ\u{cbf}ಕೊಳ\u{ccd}ಳುವ ಮುಖ",
                "ಅಪ\u{ccd}ಪುಗ\u{cc6}",
                "ಅಪ\u{ccd}ಪುಗ\u{cc6}ಯ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("포옹하고 있는 얼굴"),
            keywords: &[
                "반가워하는 얼굴",
                "얼굴",
                "포옹",
                "포옹하고 있는 얼굴",
                "환영",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{947}\u{902}ग मारपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "व\u{947}\u{902}ग",
                "व\u{947}\u{902}ग मारपी",
                "व\u{947}\u{902}ग मारपी च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кучактап жаткан бет"),
            keywords: &["бет", "кучак", "кучакта", "кучактап жаткан бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ëmaarmung"),
            keywords: &["Gesiicht", "Ëmaarmung", "ëmaarmen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{eb4}\u{ec9}ມກອດ"),
            keywords: &[
                "ກອດ",
                "ຍ\u{eb4}\u{ec9}ມ",
                "ຍ\u{eb4}\u{ec9}ມກອດ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apkabinantis veidas"),
            keywords: &["apkabinantis veidas", "apkabinimas", "apkabinti", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar apskāvienu"),
            keywords: &["apskaut", "apskāviens", "seja", "seja ar apskāvienu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi awhiawhi"),
            keywords: &["awhi", "awhiawhi", "kanohi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице што гушка"),
            keywords: &["гушкање", "лице", "лице што гушка", "прегратка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആലിംഗനം ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "ആലിംഗനം ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "കെട\u{d4d}ടിപ\u{d4d}പിടിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
                "മ\u{d41}ഖം",
                "സ\u{d4d}\u{200c}നേഹം പ\u{d4d}രകടിപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
                "സ\u{d57}ഹ\u{d43}ദം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тэвэрч байгаа царай"),
            keywords: &["тэврэх", "тэвэрч байгаа царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मिठी मारणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "मिठी",
                "मिठी मारणारा च\u{947}हरा",
                "मिठी मारण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka memberi pelukan"),
            keywords: &["memeluk", "muka", "muka memberi pelukan", "peluk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jgħannaq"),
            keywords: &["jgħannaq", "qed jgħannaq", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပ\u{103d}ေ\u{1037}ဖက\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ပ\u{103d}ေ\u{1037}ဖက\u{103a}ခြင\u{103a}း",
                "ပ\u{103d}ေ\u{1037}ဖက\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ပ\u{103d}ေ\u{1037}ဖက\u{103a}နေသည\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes som gir klem"),
            keywords: &["fjes", "fjes som gir klem", "klem"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अ\u{902}गालो मार\u{947}को अन\u{941}हार"),
            keywords: &[
                "अ\u{902}गालो",
                "अ\u{902}गालो मारिरह\u{947}को",
                "अ\u{902}गालो मार\u{947}को अन\u{941}हार",
                "अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blij gezicht met handen uitgestoken voor een knuffel"),
            keywords: &[
                "blij gezicht met handen uitgestoken voor een knuffel",
                "gezicht",
                "knuffel",
                "knuffelen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes som gjev klem"),
            keywords: &["fjes", "fjes som gjev klem", "klem"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "କୋଳ\u{b3e}ଇବ\u{b3e}କ\u{b41} ହ\u{b3e}ତ ଖୋଲ\u{b3e}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଆଲ\u{b3f}ଙ\u{b4d}ଗନ",
                "ଆଲ\u{b3f}ଙ\u{b4d}ଗନ କର\u{b3f}ବ\u{b3e}",
                "କୋଳ\u{b3e}ଇବ\u{b3e}କ\u{b41} ହ\u{b3e}ତ ଖୋଲ\u{b3e}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a71}ਫੀ ਪਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਖ\u{a41}ਸ\u{a3c} ਹ\u{a4b} ਕ\u{a47} ਜ\u{a71}ਫੀ ਪਾਉਣਾ",
                "ਚਿਹਰਾ",
                "ਜ\u{a71}ਫੀ",
                "ਜ\u{a71}ਫੀ ਪਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਜ\u{a71}ਫੀ ਪਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گلے ملدی شکل"),
            keywords: &["دی شکل", "گلے ملدی شکل", "گلے ملدیاں ہوئیاں", "گلے ملنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand De Họ\u{301}l Fes"),
            keywords: &[
                "Fes",
                "Hand De Họ\u{301}l Fes",
                "Hol",
                "Họg",
                "Họ\u{301}gin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z gestem przytulania"),
            keywords: &["twarz z gestem przytulania", "uśmiech", "ściskam"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غاړه ورکوونکی مخ"),
            keywords: &["غاړه ورکوونکی مخ", "غېږه", "غېږه کې نيول", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto abraçando"),
            keywords: &["abraço", "mãos abraçando", "rosto", "rosto abraçando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a dar um abraço"),
            keywords: &["abraçar", "abraço", "cara", "cara a dar um abraço"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ya makʼalliwan"),
            keywords: &["mak’alli", "mak’allisqa", "uya", "ya makʼalliwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu gest de îmbrățișare"),
            keywords: &["față", "față cu gest de îmbrățișare", "îmbrățișare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1017"),
            keywords: &["E10-1017"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обнимает"),
            keywords: &["лицо", "обнимает", "объятие", "руки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza guhoberana"),
            keywords: &[
                "guhobera",
                "guhoberana",
                "isura",
                "isura igaragaza guhoberana",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڀاڪر پائيندڙ چهرو"),
            keywords: &["ڀاڪر", "ڀاڪر پائيندڙ چهرو", "ڀاڪر پائڻ", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැළඳ ගන\u{dca}න\u{dcf} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "වැළඳ ගන\u{dca}නව\u{dcf}",
                "වැළඳ ගන\u{dca}න\u{dcf} ම\u{dd4}හ\u{dd4}ණ",
                "වැළඳ ගැන\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("objímajúca tvár"),
            keywords: &["objatie", "objímajúca tvár", "objímanie", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki objema"),
            keywords: &["objem", "objemanje", "obraz", "obraz, ki objema"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji habsiinaaya"),
            keywords: &["hab", "hab siin", "waji", "waji habsiinaaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që përqafon"),
            keywords: &["fytyrë", "fytyrë që përqafon", "përqafim", "përqafoj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које грли"),
            keywords: &["грљeњe", "зaгрљaj", "лице", "лице које грли"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице које грли"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje grli"),
            keywords: &["grljenje", "lice", "lice koje grli", "zagrljaj"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice koje grli"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte som kramas"),
            keywords: &["ansikte", "ansikte som kramas", "kramas", "leende"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaokumbatia"),
            keywords: &["kukumbatia", "kumbatia", "uso", "uso unaokumbatia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அணைக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அணைக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "அணைப\u{bcd}பு",
                "கட\u{bcd}டிக\u{bcd}கொள\u{bcd}ளுதல\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4c}గ\u{c3f}ల\u{c3f}ంచుకున\u{c4d}న ముఖం"),
            keywords: &[
                "క\u{c4c}గ\u{c3f}ల\u{c3f}",
                "క\u{c4c}గ\u{c3f}ల\u{c3f}ంచుకున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи оғӯшкунанда"),
            keywords: &["оғӯш кардан", "оғӯшкунанда", "рӯи оғӯшкунанда", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e34}\u{e49}มกอด"),
            keywords: &[
                "กอด",
                "ย\u{e34}\u{e49}ม",
                "ย\u{e34}\u{e49}มกอด",
                "หน\u{e49}า",
                "อบอ\u{e38}\u{e48}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gujaklaýan ýüz"),
            keywords: &["gujak", "gujaklamak", "gujaklaýan ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fāʻufua"),
            keywords: &["mata fāʻufua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kucaklayarak gülümseme"),
            keywords: &["kucaklama", "kucaklayarak gülümseme", "sarılma", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇچاقلىغان چىراي"),
            keywords: &["قۇچاق", "قۇچاقلاش", "قۇچاقلىغان چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("щасливе обличчя з руками, що обіймають"),
            keywords: &[
                "обличчя",
                "обійматися",
                "щасливе обличчя з руками, що обіймають",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گلے ملتا چہرہ"),
            keywords: &["چہرہ", "گلے ملتا چہرہ", "گلے ملنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quchayotgan yuz"),
            keywords: &["quchayotgan yuz", "quchish", "quchoq", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt ôm"),
            keywords: &["mặt", "ôm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu kottante"),
            keywords: &["kanam", "kanamu kottante", "kott", "kottante"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obangayo"),
            keywords: &["mange", "ubuso", "ubuso obangayo", "ukwanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("oju Ti O fanimọra"),
            keywords: &["fanimọ\u{301}ra", "oju Ti O fanimọra", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("擁抱嘅臉"),
            keywords: &["擁抱", "擁抱嘅臉", "攬", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拥抱嘅脸"),
            keywords: &["拥抱", "拥抱嘅脸", "揽", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("抱抱"),
            keywords: &["抱", "抱抱", "拥抱", "笑", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("抱抱"),
            keywords: &["抱抱", "擁抱"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("開心擁抱嘅表情"),
            keywords: &["擁抱", "開心擁抱嘅表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obangayo"),
            keywords: &["anga", "ubuso", "ubuso obangayo", "ukwanga"],
        },
    ],
};
#[doc = "🤭"]
pub const FACE_WITH_HAND_OVER_MOUTH: crate::Emoji = crate::Emoji {
    glyph: "🤭",
    codepoint: "1F92D",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "face with hand over mouth",
    group: "Smileys & Emotion",
    subgroup: "face-hand",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met hand oor die mond"),
            keywords: &["gesig met hand oor die mond", "oeps"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እጁን ከንፈሩ ላይ ያደረገ ፊት"),
            keywords: &["እጁን ከንፈሩ ላይ ያደረገ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه ضاحك مع يد تغط\u{651}ي الفم"),
            keywords: &["وجه ضاحك مع يد تغط\u{651}ي الفم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খত হ\u{9be}ত দিয\u{9bc}\u{9be} চেহেৰ\u{9be}"),
            keywords: &["উফ", "ম\u{9c1}খত হ\u{9be}ত দিয\u{9bc}\u{9be} চেহেৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağzını əli ilə örtmüş üz"),
            keywords: &["ağzını əli ilə örtmüş üz", "vay"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("закрывае рукой рот"),
            keywords: &["закрывае рукой рот", "ой"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с ръка пред устата"),
            keywords: &["Лице с ръка пред устата", "издаване", "опа!"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খের ওপর হ\u{9be}ত দেওয\u{9bc}\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "উল\u{9cd}লসিত ম\u{9c1}খ",
                "ম\u{9c1}খের ওপর হ\u{9be}ত দেওয\u{9bc}\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruka preko usta"),
            keywords: &["opa", "ruka preko usta", "ups"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb la mà sobre la boca"),
            keywords: &["cara amb la mà sobre la boca", "tapant-se la boca", "ups"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛ ᎠᎰᎵ ᎤᏭᏝᎢ"),
            keywords: &["ᎤᎧᏛ ᎠᎰᎵ ᎤᏭᏝᎢ", "ᎮᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s dlaní před pusou"),
            keywords: &[
                "ajaj",
                "jejda",
                "jéje",
                "obličej s dlaní před pusou",
                "oj",
                "oops",
                "ouha",
                "ups",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gyda llaw dros y geg"),
            keywords: &["wps", "wyneb gyda llaw dros y geg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med hånd over munden"),
            keywords: &["ansigt med hånd over munden", "ups"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("verlegen kicherndes Gesicht"),
            keywords: &["Huch", "verlegen kicherndes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο με χέρι στο στόμα"),
            keywords: &["πρόσωπο με χέρι στο στόμα", "ωχ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with hand over mouth"),
            keywords: &["face with hand over mouth", "whoops"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["embarrassed", "face with hand over mouth", "oops", "whoops"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["face with hand over mouth", "whoops"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["face with hand over mouth", "oops", "whoops"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["embarrassed", "face with hand over mouth", "oops", "whoops"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con mano sobre la boca"),
            keywords: &["cara con mano sobre la boca", "ostras", "uy", "vaya"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara con mano sobre la boca", "chanfle", "uy", "vaya"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara con mano sobre la boca",
                "chanfle",
                "risita",
                "uy",
                "vaya",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cara con mano sobre la boca", "ups", "uy"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kätt suul hoidev nägu"),
            keywords: &["kätt suul hoidev nägu", "ups"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuaz ahoa estaltzen ari den aurpegia"),
            keywords: &["ene", "eskuaz ahoa estaltzen ari den aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست روی دهن"),
            keywords: &["آخ", "آه", "اوه", "ای وای", "دست روی دهن", "وا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käsi suun edessä"),
            keywords: &["käsi suun edessä", "lipsahdus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukha na nakatakip ang kamay sa bibig"),
            keywords: &["mukha na nakatakip ang kamay sa bibig", "oops", "whoops"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við hond yvir munnin"),
            keywords: &[
                "andlit",
                "andlit við hond yvir munnin",
                "hond",
                "munn",
                "ups",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec une main sur la bouche"),
            keywords: &["oups", "visage avec une main sur la bouche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "Oups",
                "main sur la bouche",
                "visage",
                "visage avec une main sur la bouche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog lena lámh ar a béal"),
            keywords: &[
                "aghaidh le lámha ar an mbéal",
                "straoiseog lena lámh ar a béal",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le làmh air a beul"),
            keywords: &["aodann le làmh air a beul", "oich"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara rindo disimuladamente"),
            keywords: &["cara rindo disimuladamente", "disimulada", "man", "risa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મો\u{a82} પર હાથ મ\u{ac2}ક\u{ac7}લો ચહ\u{ac7}રો"),
            keywords: &["મો\u{a82} પર હાથ મ\u{ac2}ક\u{ac7}લો ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da hannu bisa baki"),
            keywords: &["fuska tare da hannu bisa baki", "nunin baƙin ciki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם יד על הפה"),
            keywords: &["אוי", "אופס", "טעות", "פרצוף עם יד על הפה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}\u{901}ह पर हाथ रख\u{947} ह\u{941}ए च\u{947}हरा"),
            keywords: &[
                "ख\u{941}शी या ह\u{948}रानी स\u{947} चिल\u{94d}लाना",
                "चीख",
                "म\u{941}\u{901}ह पर हाथ रख\u{947} ह\u{941}ए च\u{947}हरा",
                "ह\u{942} ह\u{942}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s rukom preko usta"),
            keywords: &["lice s rukom preko usta", "ups"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc szájra tett kézzel"),
            keywords: &["arc szájra tett kézzel", "hoppá"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքը բերանին դեմք"),
            keywords: &["ձեռքը բերանին դեմք", "վայ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan tangan menutup mulut"),
            keywords: &["ups", "wajah dengan tangan menutup mulut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu n’iji aka mechie ọnụ"),
            keywords: &["ihu mwute", "ihu n’iji aka mechie ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með hendi fyrir munn"),
            keywords: &["andlit með hendi fyrir munn", "úps"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con mano sulla bocca"),
            keywords: &["faccina con mano sulla bocca", "oops"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("口に手を当てた顔"),
            keywords: &[
                "クスクス",
                "スマイル",
                "内緒",
                "口に手を当てた顔",
                "笑顔",
                "顔",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mawa tangan nutupi cangkem"),
            keywords: &["rai mawa tangan nutupi cangkem", "waduh"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახეზე აფარებული ხელი"),
            keywords: &["ვაი", "სახეზე აფარებული ხელი", "უი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аузын қолмен жауып күлу"),
            keywords: &["айтып қою", "аузын қолмен жауып күлу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខយកដៃខ\u{17d2}ទប\u{17cb}មាត\u{17cb}"),
            keywords: &[
                "ម\u{17bb}ខយកដៃខ\u{17d2}ទប\u{17cb}មាត\u{17cb}",
                "អ\u{17bb}ះ !",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈಗಳ\u{cbf}ಂದ ಬಾಯ\u{cbf} ಮುಚ\u{ccd}ಚ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಓಹ\u{ccd}",
                "ಕೈಗಳ\u{cbf}ಂದ ಬಾಯ\u{cbf} ಮುಚ\u{ccd}ಚ\u{cbf}ರುವ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손으로 입을 가린 얼굴"),
            keywords: &["손으로 입을 가린 얼굴", "앗"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तो\u{902}डार हात दवरिल\u{94d}लो च\u{947}रो"),
            keywords: &["तो\u{902}डार हात दवरिल\u{94d}लो च\u{947}रो", "शी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оозун колу менен жапкан жүз"),
            keywords: &["ой!", "оозун колу менен жапкан жүз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat Hand virum Mond"),
            keywords: &["Gesiicht mat Hand virum Mond", "Oups", "Uups"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເອ\u{ebb}າມ\u{eb7}ປ\u{ec9}ອງປາກ"),
            keywords: &["ອ\u{eb8}ຍ", "ໜ\u{ec9}າເອ\u{ebb}າມ\u{eb7}ປ\u{ec9}ອງປາກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su ranka ant burnos"),
            keywords: &["ups", "veidas su ranka ant burnos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar roku pār muti"),
            keywords: &["seja ar roku pār muti", "vai"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi ringa runga waha"),
            keywords: &["aue", "kanohi ringa runga waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со дланка преку устата"),
            keywords: &["лице со дланка преку устата", "упс"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൈകൊണ\u{d4d}ട\u{d4d} വ\u{d3e}യ\u{d4d} മ\u{d42}ടിയ മ\u{d41}ഖം"),
            keywords: &[
                "അമളി",
                "കൈകൊണ\u{d4d}ട\u{d4d} വ\u{d3e}യ\u{d4d} മ\u{d42}ടിയ മ\u{d41}ഖം",
                "ക\u{d4d}ഷമിക\u{d4d}കണം",
                "ശ\u{d4d}ശോ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амаа гараараа тагласан царай"),
            keywords: &["амаа гараараа тагласан царай", "дуу алдах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तो\u{902}डावर हात असल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "अर\u{947}र\u{947}",
                "तो\u{902}डावर हात असल\u{947}ला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan tangan atas mulut"),
            keywords: &["alamak", "muka dengan tangan atas mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ bl-idejn fuq il-ħalq"),
            keywords: &["whoops", "wiċċ bl-idejn fuq il-ħalq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပါးစပ\u{103a}က\u{102d}\u{102f} လက\u{103a}န\u{1032}\u{1037}ပ\u{102d}တ\u{103a}တ\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "စဥ\u{103a}းစားရကြပ\u{103a}သည\u{103a}",
                "ပါးစပ\u{103a}က\u{102d}\u{102f} လက\u{103a}န\u{1032}\u{1037}ပ\u{102d}တ\u{103a}တ\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hånden over munnen"),
            keywords: &["flire", "hånden over munnen", "ops"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छक\u{94d}क पर\u{947}को भाव भएको अन\u{941}हार"),
            keywords: &[
                "छक\u{94d}क पर\u{947}को भाव भएको अन\u{941}हार",
                "ह\u{941}प\u{94d}स",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met hand over de mond"),
            keywords: &["gezicht met hand over de mond", "oeps"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handa over munnen"),
            keywords: &["flire", "handa over munnen", "ops"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b3e}ଟ\u{b3f}ରେ ହ\u{b3e}ତ ବନ\u{b4d}ଦ କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଉତ\u{b4d}ତେଜନ\u{b3e}ଜନ\u{b3f}ତ ଉଚ\u{b4d}ଚ ଶବ\u{b4d}ଦ",
                "ପ\u{b3e}ଟ\u{b3f}ରେ ହ\u{b3e}ତ ବନ\u{b4d}ଦ କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}\u{a70}ਹ ਉ\u{a71}ਤ\u{a47} ਹ\u{a71}ਥ ਰ\u{a71}ਖਿਆ ਚਿਹਰਾ"),
            keywords: &[
                "ਓ ਹ\u{a4b}",
                "ਮ\u{a42}\u{a70}ਹ ਉ\u{a71}ਤ\u{a47} ਹ\u{a71}ਥ ਰ\u{a71}ਖਿਆ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ ا\u{64f}وتے ہتھ نال شکل"),
            keywords: &["للکارنا", "منہ ا\u{64f}وتے ہتھ نال شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wit Hand Fọ Maut"),
            keywords: &["Fes Wit Hand Fọ Maut", "Hẹẹẹ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z ręką na ustach"),
            keywords: &["twarz z ręką na ustach", "ups"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاس په خوله مخ"),
            keywords: &["سوځول", "لاس په خوله مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com a mão sobre a boca"),
            keywords: &["ops", "rosto com a mão sobre a boca"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com mão na boca"),
            keywords: &["cara com mão na boca", "ups"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya makiwan simipi"),
            keywords: &["ups", "uya makiwan simipi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu mâna peste gură"),
            keywords: &["față cu mâna peste gură", "ups"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1039"),
            keywords: &["E10-1039"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("прикрывает рот рукой"),
            keywords: &[
                "лишнего",
                "лишнее",
                "ляпнуть",
                "ой",
                "прикрывает рот рукой",
                "проговориться",
                "хи-хи",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura y’umuntu wifashe ku munwa"),
            keywords: &["apu!", "isura y’umuntu wifashe ku munwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وات تي هٿ وارو چهرو"),
            keywords: &["تعجب", "وات تي هٿ وارو چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dd2}න\u{dca} කට වැස\u{dd4}ණ\u{dd4} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අත\u{dd2}න\u{dca} කට වැස\u{dd4}ණ\u{dd4} ම\u{dd4}හ\u{dd4}ණ",
                "හපොය\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s\u{a0}rukou na ústach"),
            keywords: &["chi", "joj", "tvár s\u{a0}rukou na ústach"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z roko čez usta"),
            keywords: &["obraz z roko čez usta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji afka gacan ka saaran"),
            keywords: &["qoorta", "waji afka gacan ka saaran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me dorën mbi gojë"),
            keywords: &["fytyrë me dorën mbi gojë", "uups!"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са руком преко уста"),
            keywords: &["лице са руком преко уста", "упс"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa rukom preko usta"),
            keywords: &["lice sa rukom preko usta", "ups"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med handen för munnen"),
            keywords: &["ansikte med handen för munnen", "hoppsan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliofunika mdomo kwa mkono"),
            keywords: &["lo!", "uso uliofunika mdomo kwa mkono"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ய\u{bcd} பொத\u{bcd}திச\u{bcd} சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அடட\u{bbe}",
                "கிண\u{bcd}டல\u{bcd}",
                "நக\u{bcd}கல\u{bcd}",
                "நமுட\u{bcd}டுச\u{bcd} சிரிப\u{bcd}பு",
                "வ\u{bbe}ய\u{bcd} பொத\u{bcd}திச\u{bcd} சிரிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}త\u{c3f}త\u{c4b} న\u{c4b}రు మూసుకున\u{c4d}న ముఖం"),
            keywords: &[
                "అయ\u{c4d}య\u{c4b}",
                "చ\u{c47}త\u{c3f}త\u{c4b} న\u{c4b}రు మూసుకున\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо даст дар болои даҳон"),
            keywords: &["рӯй бо даст дар болои даҳон", "ҳоп"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอาม\u{e37}อป\u{e34}ดปาก"),
            keywords: &["เอาม\u{e37}อป\u{e34}ดปาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("eli agzynyň üstünde ýüz"),
            keywords: &["eli agzynyň üstünde ýüz", "oh-ho"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe nima ʻi muʻa ʻoe ngutu"),
            keywords: &["mata moe nima ʻi muʻa ʻoe ngutu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eliyle ağzını kapatan yüz"),
            keywords: &["eliyle ağzını kapatan yüz", "tüh"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزىنى تۇتقان چىراي"),
            keywords: &["ئاغزىنى تۇتقان چىراي", "ۋارقىراش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що прикриває рота рукою"),
            keywords: &["обличчя, що прикриває рота рукою", "ой"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ پر ہاتھ رکھا ہوا چہرہ"),
            keywords: &["افوہ", "منہ پر ہاتھ رکھا ہوا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘izni qo‘l bilan yopish"),
            keywords: &["og‘izni qo‘l bilan yopish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt với tay che miệng"),
            keywords: &["mặt với tay che miệng", "xin lỗi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak loxo bu dar gémmiñ"),
            keywords: &["dar-gémmiñ", "kanam ak loxo bu dar gémmiñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obubekwe isandla emlonyeni"),
            keywords: &["ubuso obubekwe isandla emlonyeni", "whoops"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tá fọwọ\u{301} bo ẹnu"),
            keywords: &["Ikó\u{329}", "Ojú tá fọwọ\u{301} bo ẹnu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("用手掩口嘅臉"),
            keywords: &["呼叫", "用手掩口嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("用手掩口嘅脸"),
            keywords: &["呼叫", "用手掩口嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("不说"),
            keywords: &["不说", "哎呀", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("手蓋住嘴巴"),
            keywords: &["哎喲", "手蓋住嘴巴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("手遮住嘴"),
            keywords: &["哎喲", "手遮住嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obubekwe isandla emlonyeni"),
            keywords: &["ubuso obubekwe isandla emlonyeni", "whoops"],
        },
    ],
};
#[doc = "🤫"]
pub const SHUSHING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤫",
    codepoint: "1F92B",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "shushing face",
    group: "Smileys & Emotion",
    subgroup: "face-hand",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("stilmaak gesig"),
            keywords: &["Sjuut", "stilbly", "stilmaak gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጸጥታ ፊት"),
            keywords: &["የጸጥታ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يطلب الصمت"),
            keywords: &["وجه يطلب الصمت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9be}ন\u{9cd}ত ম\u{9c1}খ"),
            keywords: &["নীৰৱ", "শ\u{9be}ন\u{9cd}ত", "শ\u{9be}ন\u{9cd}ত ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tərpənən sifət"),
            keywords: &["sakit", "tərpənən", "tərpənən sifət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("шыкае"),
            keywords: &["цыц", "ціха", "шыкае", "шыканне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице, което прави „шт!“"),
            keywords: &["Лице, което прави „шт!“", "знак за „шт!“", "тихо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9c1}প কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "চ\u{9c1}প কর\u{9be}",
                "চ\u{9c1}প কর\u{9be} ম\u{9c1}খ",
                "শ\u{9be}ন\u{9cd}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ušutkivanje"),
            keywords: &["psst", "tišina", "ušutkivanje", "šuti"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que demana silenci"),
            keywords: &["callar", "cara que demana silenci", "silenci"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᏪᎢ ᎾᎬᏁᎲᎢ ᎤᎧᏛ"),
            keywords: &["ᎡᎶᏪᎢ", "ᎡᎶᏪᎢ ᎾᎬᏁᎲᎢ ᎤᎧᏛ", "ᎾᎬᏁᎲ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s prstem na puse"),
            keywords: &[
                "obličej s prstem na puse",
                "pst",
                "pšt",
                "ticho",
                "tiše",
                "tišit",
                "utišit",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb hisht"),
            keywords: &["hisht", "tawelwch", "wyneb hisht"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tyssende ansigt"),
            keywords: &["stille", "tysse", "tyssende ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ermahnendes Gesicht"),
            keywords: &["ermahnendes Gesicht", "leise", "pst"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο που κάνει σσσς"),
            keywords: &["ησυχία", "πρόσωπο που κάνει σσσς"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("shushing face"),
            keywords: &["quiet", "shush", "shushing face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("shooshing face"),
            keywords: &["quiet", "shooshing face", "shush", "shushing face"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara pidiendo silencio"),
            keywords: &["callado", "cara pidiendo silencio", "silencio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sõrme suul hoidev nägu"),
            keywords: &["kuss!", "sõrme suul hoidev nägu", "vaikust"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("isiltasuna eskatzen ari den aurpegia"),
            keywords: &[
                "isilarazi",
                "isilik",
                "isiltasuna eskatzen ari den aurpegia",
                "ixo",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هیس"),
            keywords: &["بی\u{200c}صدا", "ساکت", "هیس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hyssyttelevä"),
            keywords: &["hiljentää", "hyssyttelevä", "hyssyttää"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukha na nagpapatahimik"),
            keywords: &["mukha na nagpapatahimik", "shush", "tahimik"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hússjandi andlit"),
            keywords: &["andlit", "hússja", "hússjandi andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec un doigt sur la bouche"),
            keywords: &["chut", "silence", "visage avec un doigt sur la bouche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chut",
                "doigt sur la bouche",
                "silence",
                "visage",
                "visage avec un doigt sur la bouche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog do do chur i do thost"),
            keywords: &["ciúnas", "straoiseog do do chur i do thost", "tost"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann “Ist!”"),
            keywords: &["aodann “Ist!”", "ist", "sàmhach", "tost"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de mandar calar"),
            keywords: &[
                "calada",
                "calado",
                "calar",
                "cara de mandar calar",
                "silencio",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac2}પ કરતો ચહ\u{ac7}રો"),
            keywords: &["ચ\u{ac2}પ કરતો ચહ\u{ac7}રો", "શ\u{acd}શ\u{acd}શ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai shiru"),
            keywords: &["fuska mai shiru", "mai shiru", "shiru"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עושה סימן לשקט"),
            keywords: &["פרצוף עושה סימן לשקט", "שקט", "ששש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शा\u{902}त रहन\u{947} का इशारा करता ह\u{941}आ च\u{947}हरा"),
            keywords: &[
                "च\u{941}प",
                "मौन",
                "शा\u{902}त",
                "शा\u{902}त रहन\u{947} का इशारा करता ह\u{941}आ च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje ušutkava"),
            keywords: &["lice koje ušutkava", "tišina", "ušutkavanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csitító arc"),
            keywords: &["csend", "csitt", "csitító arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("«սուս» անող դեմք"),
            keywords: &["«սուս» անող դեմք", "լուռ", "լռություն", "սուս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah menyuruh diam"),
            keywords: &[
                "diam",
                "jangan berisik",
                "ssst",
                "sst",
                "wajah menyuruh diam",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu mechie onụ"),
            keywords: &["ihu mechie onụ", "mmechiọnụ", "nwayọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andilt að segja uss"),
            keywords: &["andilt að segja uss", "suss", "uss", "þögn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che zittisce"),
            keywords: &["faccina che zittisce", "silenzio", "zittire"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しーっ"),
            keywords: &["しっ", "しー", "しーっ", "静かに", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngaba-aba akon meneng"),
            keywords: &[
                "hus",
                "meneng",
                "rai ngaba-aba akon meneng",
                "rai ngaba-aba hus",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაჩუმების ჟესტი"),
            keywords: &["გაჩუმების ჟესტი", "სიჩუმე", "სუუ", "შშშ", "ჩუ", "ჩუმად"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үндеме"),
            keywords: &["сөйлеме", "тыныш", "үндеме"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រាប\u{17cb}ឱ\u{17d2}យស\u{17d2}ងាត\u{17cb}"),
            keywords: &[
                "ប\u{17d2}រាប\u{17cb}ឱ\u{17d2}យស\u{17d2}ងាត\u{17cb}",
                "ស\u{17d2}ងាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{ccd} ಎಂದು ಹೇಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಮ\u{ccc}ನ",
                "ಶ\u{ccd}",
                "ಶ\u{ccd} ಎಂದು ಹೇಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쉿 하는 얼굴"),
            keywords: &["쉿", "쉿 하는 얼굴", "조용"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("च\u{942}प करपी च\u{947}रो"),
            keywords: &[
                "ओग\u{94d}गी",
                "ओग\u{94d}गी राव\u{942}\u{902}क सा\u{902}गपी च\u{947}रो",
                "च\u{942}प करपी च\u{947}रो",
                "थ\u{902}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("акырын деген жүз"),
            keywords: &["акырын", "акырын деген жүз", "тынч"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mam Fanger virum Mond"),
            keywords: &["Gesiicht mam Fanger virum Mond", "pscht", "roueg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າງຽບ"),
            keywords: &["ງຽບ", "ມ\u{eb4}ດ", "ໜ\u{ec9}າງຽບ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("tildantis veidas"),
            keywords: &["tildantis veidas", "tylus", "ššš"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šušinoša seja"),
            keywords: &["klusināt", "klusēt", "kuš", "šušinoša seja", "šušināt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi whakahū"),
            keywords: &["hū", "kanohi whakahū", "turituri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице прави „шшш“"),
            keywords: &["лице прави „шшш“", "тишина", "шшш"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "നിശബ\u{d4d}\u{200c}ദത പ\u{d3e}ലിക\u{d4d}ക\u{d3e}ൻ ആവശ\u{d4d}യപ\u{d4d}പെട\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "നിശബ\u{d4d}\u{200c}ദത",
                "നിശബ\u{d4d}\u{200c}ദത പ\u{d3e}ലിക\u{d4d}ക\u{d3e}ൻ ആവശ\u{d4d}യപ\u{d4d}പെട\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "ശ\u{d42}",
                "ശ\u{d4d}\u{200c}ശ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чишш гэсэн царай"),
            keywords: &["чимээгүй", "чишш", "чишш гэсэн царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गप\u{94d}प करणारा च\u{947}हरा"),
            keywords: &["गप\u{94d}प", "गप\u{94d}प करणारा च\u{947}हरा", "शा\u{902}त"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka suruh senyap"),
            keywords: &["diam", "muka suruh senyap", "shhh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ qed isikket"),
            keywords: &["kwiet", "skiet", "wiċċ qed isikket"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{103e}\u{102f}းတ\u{102d}\u{102f}းတ\u{102d}\u{102f}းရ\u{102f}ပ\u{103a}န\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "တ\u{102d}တ\u{103a}တ\u{102d}တ\u{103a}နေခ\u{102d}\u{102f}င\u{103a}းနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "တ\u{102d}တ\u{103a}တ\u{102d}တ\u{103a}နေပါ",
                "ရ\u{103e}\u{102f}းတ\u{102d}\u{102f}းတ\u{102d}\u{102f}းရ\u{102f}ပ\u{103a}န\u{1032}\u{1037} မျက\u{103a}န\u{103e}ာ",
                "ရ\u{103e}\u{1030}းတ\u{102d}\u{102f}းတ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hysj"),
            keywords: &["hysj", "stillhet", "vær stille"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{941}प लाग\u{94d}न आग\u{94d}रह गरिरह\u{947}को अन\u{941}हार"),
            keywords: &[
                "च\u{941}प लाग\u{94d}न आग\u{94d}रह",
                "च\u{941}प लाग\u{94d}न आग\u{94d}रह गरिरह\u{947}को अन\u{941}हार",
                "मौ\u{902}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht dat tot stilte maant"),
            keywords: &["gezicht dat tot stilte maant", "sst", "stil"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hysj"),
            keywords: &["hysj", "stille", "ver stille"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଚ\u{b41}ପ\u{b4d}\u{200c} ରହ\u{b3f}ବ\u{b3e} ପ\u{b3e}ଇ\u{b01} କହ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଚ\u{b41}ପ\u{b4d}\u{200c} ରହ\u{b3f}ବ\u{b3e} । ନୀରବ",
                "ଚ\u{b41}ପ\u{b4d}\u{200c} ରହ\u{b3f}ବ\u{b3e} ପ\u{b3e}ଇ\u{b01} କହ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a41}\u{a71}ਪ ਕਰਵਾਉ\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚ\u{a41}\u{a71}ਪ",
                "ਚ\u{a41}\u{a71}ਪ ਕਰਵਾਉ\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਸ\u{a3c}ਾ\u{a02}ਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خاموش کراندی ہوئی شکل"),
            keywords: &["خاموش", "خاموش کراندی ہوئی شکل", "چپ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Pút Fínga Fọ Maut De Mék Shhhh"),
            keywords: &["Fes Pút Fínga Fọ Maut De Mék Shhhh", "Kwáyẹt", "Shhhh"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uciszająca twarz"),
            keywords: &["cicho", "uciszająca twarz", "uciszać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کرارونکی مخ"),
            keywords: &["غلی", "کرارول", "کرارونکی مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto fazendo sinal de silêncio"),
            keywords: &["quieto", "rosto fazendo sinal de silêncio", "silêncio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara de segredo"),
            keywords: &["cara de segredo", "quieto", "segredo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ch’in uya"),
            keywords: &["chʼin", "chʼin uya", "ch’in uya", "ñañiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față care șâșâie"),
            keywords: &["față care șâșâie", "liniște", "șșșt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1037"),
            keywords: &["E10-1037"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тс-с-с"),
            keywords: &["молчи", "секрет", "тайна", "тихо", "тишина", "тс-с-с"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura y’umuntu utuje"),
            keywords: &["isura y’umuntu utuje", "ucecetse", "utuje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چپ چهرو"),
            keywords: &["چپ چهرو", "چپ، ماٺ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ශ\u{dca}ශබ\u{dca}ද ක\u{dd2}ර\u{dd3}මේ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "න\u{dd2}ශ\u{dca}ශබ\u{dca}ද",
                "න\u{dd2}ශ\u{dca}ශබ\u{dca}ද ක\u{dd2}ර\u{dd3}මේ ම\u{dd4}හ\u{dd4}ණ",
                "න\u{dd2}ශ\u{dca}ශබ\u{dca}ද වන\u{dca}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s\u{a0}prstom na ústach"),
            keywords: &["pst", "ticho", "tvár s\u{a0}prstom na ústach", "čit"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz s prstom čez usta"),
            keywords: &["obraz s prstom čez usta"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji ruxmaya"),
            keywords: &["aamusan", "ruxan", "waji ruxmaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që bën \"shtttt!\""),
            keywords: &["fytyrë që bën \"shtttt!\"", "hesht", "pusho", "shtttt!"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("ућуткујуће лице"),
            keywords: &["тихо", "ућуткујуће лице", "ћути"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ućutkujuće lice"),
            keywords: &["tiho", "ućutkujuće lice", "ćuti"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hyssjande ansikte"),
            keywords: &["hyssjande ansikte", "tyst"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaonyamazisha"),
            keywords: &["kimya", "nyamaza", "uso unaonyamazisha"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அமைதிய\u{bbe}க இருக\u{bcd}கச\u{bcd} சொல\u{bcd}லும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அமைதி",
                "அமைதிய\u{bbe}க இருக\u{bcd}கச\u{bcd} சொல\u{bcd}லும\u{bcd} முகம\u{bcd}",
                "வ\u{bbe}யை மூடு",
                "ஷ\u{bcd}ஷ\u{bcd}ஷ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}శ\u{c4d}శబ\u{c4d}ద చ\u{c3f}హ\u{c4d}నంత\u{c4b} ముఖం"),
            keywords: &[
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}ద చ\u{c3f}హ\u{c4d}నం",
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}ద చ\u{c3f}హ\u{c4d}నంత\u{c4b} ముఖం",
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}దం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хомӯшкунанда"),
            keywords: &["ором кардан", "рӯи хомӯшкунанда", "хомӯш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าบอกให\u{e49}เง\u{e35}ยบ"),
            keywords: &[
                "จ\u{e38}\u{e4a}จ\u{e38}\u{e4a}",
                "หน\u{e49}าบอกให\u{e49}เง\u{e35}ยบ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("\"ýuwaşş\" diýýän ýüz"),
            keywords: &["\"ýuwaşş\" diýýän ýüz", "üşş", "ýuwaş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fiemaʻu fakalongolongo"),
            keywords: &["mata fiemaʻu fakalongolongo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sus işareti yapan yüz"),
            keywords: &["sessiz", "sus işareti yapan yüz", "şişt"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("جىم چىراي"),
            keywords: &["ئۈششش", "تىنچ", "جىم چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що цикає"),
            keywords: &["обличчя, що цикає", "тихо", "тссс"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خاموش رہنے کا اشارہ کرنے والہ چہرہ"),
            keywords: &["خاموش", "خاموش رہنے کا اشارہ کرنے والہ چہرہ", "چپ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ts-s-s"),
            keywords: &["ts-s-s"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt ra dấu suỵt"),
            keywords: &["im lặng", "mặt ra dấu suỵt", "suỵt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu shuut noppil"),
            keywords: &["kanamu shuut noppil", "noppi", "shuut"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuthulisayo"),
            keywords: &["cwaka", "thula", "ubuso obuthulisayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó sùpò\u{329}"),
            keywords: &["Ojú tó sùpò\u{329}", "dákẹ\u{301}", "panu mọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("噓嘅臉"),
            keywords: &["噓", "噓嘅臉", "靜"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("嘘嘅脸"),
            keywords: &["嘘", "嘘嘅脸", "静"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("安静的脸"),
            keywords: &["嘘", "安静", "安静的脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("噓"),
            keywords: &["噓", "安靜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuthule"),
            keywords: &["thula", "thule", "ubuso obuthule"],
        },
    ],
};
#[doc = "🤔"]
pub const THINKING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤔",
    codepoint: "1F914",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thinking face",
    group: "Smileys & Emotion",
    subgroup: "face-hand",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat dink"),
            keywords: &["dink", "gesig", "gesig wat dink"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሃሳቢ ፊት"),
            keywords: &["ሃሳቢ ፊት", "ማሰብ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه يفكر"),
            keywords: &["تأمل", "وجه", "\u{202b}وجه يفكر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিন\u{9cd}ত\u{9be}শীল ম\u{9c1}খ"),
            keywords: &[
                "চিন\u{9cd}ত\u{9be}",
                "চিন\u{9cd}ত\u{9be} কৰ\u{9be} ম\u{9c1}খ",
                "চিন\u{9cd}ত\u{9be}শীল ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düşünən üz"),
            keywords: &["düşünür", "düşünən üz", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("у роздуме"),
            keywords: &["гм", "развага", "роздум", "у роздуме"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Замислено лице"),
            keywords: &["Замислено лице", "замислен", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিন\u{9cd}ত\u{9be} কর\u{9be}র মত ম\u{9c1}খ"),
            keywords: &[
                "চিন\u{9cd}ত\u{9be} কর\u{9be}র মত ম\u{9c1}খ",
                "চিন\u{9cd}তিত",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("razmišljanje"),
            keywords: &["lice", "razmišljanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara pensativa"),
            keywords: &["cara", "pensant", "pensatiu", "pensativa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄥\u{11128}𑄘\u{11133}𑄠𑄬𑄉\u{1112e}𑄌\u{11133}𑄠𑄬 𑄟\u{1112a}"),
            keywords: &["𑄥\u{11128}𑄘\u{11133}𑄠𑄬𑄉\u{1112e}𑄌\u{11133}𑄠𑄬 𑄟\u{1112a}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎾᏖᏍᎩ ᎤᎧᏛ"),
            keywords: &["ᎠᏓᎾᏖᏍᎩ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamyšlený obličej"),
            keywords: &["smajlík", "tvář", "výraz", "zamyšlení", "zamyšlený obličej"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn meddwl"),
            keywords: &["meddwl", "wyneb", "wyneb yn meddwl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tænkende ansigt"),
            keywords: &["ansigt", "tanker", "tænkende"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("nachdenkendes Gesicht"),
            keywords: &[
                "Gesicht",
                "nachdenken",
                "nachdenkendes Gesicht",
                "nachdenklich",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σκέφτομαι"),
            keywords: &["πρόσωπο", "σκέφτομαι", "σκεπτόμενος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thinking face"),
            keywords: &["face", "thinking"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara pensativa"),
            keywords: &["cara", "cara pensativa", "pensando"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara pensante"),
            keywords: &["cara", "cara pensante", "duda", "pensar"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara pensativa"),
            keywords: &["cara", "cara pensante", "cara pensativa", "duda", "pensar"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mõtlev nägu"),
            keywords: &["mõtlemine", "mõtlev nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pentsatzen ari den aurpegia"),
            keywords: &["aurpegi", "pentsatzen", "pentsatzen ari den aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درحال تفکر"),
            keywords: &["تفکر", "درحال تفکر", "صورت", "فکر کردن", "متفکر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mietteliäs"),
            keywords: &["mietteliäs", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nag-iisip"),
            keywords: &["isip", "mukha", "nag-iisip"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hugsandi andlit"),
            keywords: &["andlit", "hugsandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage en pleine réflexion"),
            keywords: &["réflexion", "visage", "visage en pleine réflexion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag smaoineamh"),
            keywords: &["ag smaoineamh", "aghaidh", "straoiseog ag smaoineamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann ri smaoineachadh"),
            keywords: &["aodann", "aodann ri smaoineachadh", "smaoineachadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara pensativa"),
            keywords: &["cara", "cara pensativa", "pensar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિચારશીલ ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "વિચાર કરતો", "વિચારશીલ ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai tunani"),
            keywords: &["fuska", "fuska mai tunani", "tunani"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף חושב"),
            keywords: &["חושב", "מהרהר", "פרצוף", "תוהה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सोचता ह\u{941}आ च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "विचारमग\u{94d}न च\u{947}हरा",
                "सोचता ह\u{941}आ च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje razmišlja"),
            keywords: &["lice", "lice koje razmišlja", "razmišljanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gondolkodó arc"),
            keywords: &["arc", "elgondolkodó", "gondolkodó arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մտածող դեմք"),
            keywords: &["դեմք", "մտածող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah berpikir"),
            keywords: &["berpikir", "mikir", "muka", "pikir", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu na-eche echiche"),
            keywords: &["ihu", "ihu na-eche echiche", "na-eche echiche"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hugsandi andlit"),
            keywords: &["andlit", "hugsandi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina concentrata"),
            keywords: &["concentrarsi", "faccina", "faccina concentrata", "pensare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("考える顔"),
            keywords: &["うーん", "考える", "考える顔", "考え中", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mikir"),
            keywords: &["mikir", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩაფიქრებული სახე"),
            keywords: &["სახე", "ფიქრი", "ჩაფიქრებული სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem ikecmen di ttexmim"),
            keywords: &["udem ikecmen di ttexmim"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ойлану"),
            keywords: &["бет", "ойлану"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tænkende ansigt"),
            keywords: &["ansigt", "tanker", "tænkende"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17c6}ព\u{17bb}\u{17bb}ងគ\u{17b7}ត"),
            keywords: &[
                "គ\u{17b7}ត",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខក\u{17c6}ព\u{17bb}\u{17bb}ងគ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಲೋಚನ\u{cc6} ಮುಖ"),
            keywords: &["ಆಲೋಚನ\u{cc6}", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("생각하는 얼굴"),
            keywords: &["생각 중", "생각에 잠긴 얼굴", "생각하는 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विचारी च\u{947}रो"),
            keywords: &["च\u{947}रो", "विचार करता", "विचारी च\u{947}रो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ойго баткан бет"),
            keywords: &["бет", "ойго бат", "ойго баткан бет", "ойлонгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("nodenklech"),
            keywords: &["Gesiicht", "nodenklech"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າກຳລ\u{eb1}ງຄ\u{eb4}ດ"),
            keywords: &["ຄ\u{eb4}ດ", "ໜ\u{ec9}າ", "ໜ\u{ec9}າກຳລ\u{eb1}ງຄ\u{eb4}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mąstantis veidas"),
            keywords: &["mąstantis veidas", "mąstymas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("domīga seja"),
            keywords: &["domāt", "domīga seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi whakaaroaro"),
            keywords: &["kanohi", "whakaaroaro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице што размислува"),
            keywords: &["лице", "лице што размислува", "мисли", "размислува"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആലോചനയിൽ മ\u{d41}ഴ\u{d41}കിയ മ\u{d41}ഖം"),
            keywords: &[
                "ആലോചന",
                "ആലോചനയിൽ മ\u{d41}ഴ\u{d41}കിയ മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бодож байгаа царай"),
            keywords: &["бодож байгаа царай", "бодох", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विचार करणारा च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "विचार करणारा च\u{947}हरा",
                "विचार करण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka sedang berfikir"),
            keywords: &["berfikir", "muka", "muka sedang berfikir"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ ħosbien"),
            keywords: &["wiċċ", "ħosbien"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စဥ\u{103a}းစားနေပ\u{102f}\u{1036} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "စဉ\u{103a}းစားနေပ\u{102f}\u{1036}",
                "စဉ\u{103a}းစားနေပ\u{102f}\u{1036}မျက\u{103a}န\u{103e}ာ",
                "စဥ\u{103a}းစားနေပ\u{102f}\u{1036} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tenkefjes"),
            keywords: &["fjes", "tankefull", "tenkefjes", "tenker"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सोचमग\u{94d}न अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "सोचमग\u{94d}न अन\u{941}हार",
                "सोचिरह\u{947}को",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("nadenkend gezicht"),
            keywords: &["denken", "gezicht", "nadenkend gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tenkjefjes"),
            keywords: &["fjes", "tankefull", "tenkjefjes", "tenkjer"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3f}ନ\u{b4d}ତ\u{b3e}ଶୀଳ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଚ\u{b3f}ନ\u{b4d}ତ\u{b3e} କର\u{b3f}ବ\u{b3e}",
                "ଚ\u{b3f}ନ\u{b4d}ତ\u{b3e}ଶୀଳ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a4b}ਚ ਰਿਹਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਸ\u{a4b}ਚ ਰਿਹਾ ਚਿਹਰਾ",
                "ਸ\u{a4b}ਚ ਵਿ\u{a71}ਚ ਡ\u{a41}\u{a71}ਬਣਾ",
                "ਸ\u{a4b}ਚਣਾ",
                "ਸ\u{a4b}ਚਦਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سوچدی شکل"),
            keywords: &["دی شکل", "سوچدی شکل", "سوچنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes De Tink"),
            keywords: &["De Tink", "Fes", "Fes De Tink"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("myśląca twarz"),
            keywords: &[
                "buźka",
                "myśląca twarz",
                "myślę",
                "zamyślony",
                "zastanawiam się",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("فکرمند مخ"),
            keywords: &["فکرمند", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto pensativo"),
            keywords: &["mão no queixo", "pensando", "rosto", "rosto pensativo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a pensar"),
            keywords: &["cara", "cara a pensar", "pensativo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuyasqa uya"),
            keywords: &["uya", "yuyasqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față gânditoare"),
            keywords: &["față", "față gânditoare", "gândire", "reflecție"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1014"),
            keywords: &["E10-1014"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("думает"),
            keywords: &["думает", "задумчивость", "лицо", "пальцы", "размышления"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura irimo gutekereza"),
            keywords: &["isura", "isura irimo gutekereza", "itekereza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سوچيندڙ چهرو"),
            keywords: &["سوچيندڙ", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කල\u{dca}පන\u{dcf} කරන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කල\u{dca}පන\u{dcf} කරන ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}ත\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("premýšľajúca tvár"),
            keywords: &["premýšľajúca tvár", "premýšľať", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("razmišljujoči obraz"),
            keywords: &["obraz", "razmišljanje", "razmišljujoči obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji fakarsan"),
            keywords: &["fakar", "waji", "waji fakarsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që mendohet"),
            keywords: &["duke u menduar", "fytyrë", "fytyrë që mendohet", "mendim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које размишља"),
            keywords: &["лице", "лице које размишља", "рaзмишљaњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице које размишља"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje razmišlja"),
            keywords: &["lice", "lice koje razmišlja", "razmišljanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice koje razmišlja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte som tänker"),
            keywords: &["ansikte", "ansikte som tänker", "tänker"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotafakari"),
            keywords: &["kufikiri", "uso", "uso unaotafakari"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிந\u{bcd}திக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "சிந\u{bcd}திக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "சிந\u{bcd}தித\u{bcd}தல\u{bcd}",
                "ம\u{bcd}ம\u{bcd}ம\u{bcd}",
                "யோசனை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆల\u{c4b}చ\u{c3f}స\u{c4d}తున\u{c4d}న ముఖం"),
            keywords: &[
                "ఆల\u{c4b}చన",
                "ఆల\u{c4b}చ\u{c3f}స\u{c4d}తున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи аднешакунанда"),
            keywords: &["андешакунӣ", "рӯи аднешакунанда", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าคร\u{e38}\u{e48}นค\u{e34}ด"),
            keywords: &[
                "ค\u{e34}ด",
                "หน\u{e49}า",
                "หน\u{e49}าคร\u{e38}\u{e48}นค\u{e34}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oýlanýan ýüz"),
            keywords: &["oýlanýan", "pikirlenýän", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mataʻi fakakaukau"),
            keywords: &["mataʻi fakakaukau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("düşünen yüz"),
            keywords: &["düşünen yüz", "düşünme", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئويچان چىراي"),
            keywords: &["ئويلاش", "ئويچان چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя в роздумах"),
            keywords: &["обличчя", "обличчя в роздумах"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سوچتا چہرہ"),
            keywords: &["سوچتا چہرہ", "سوچنا", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ylayotgan yuz"),
            keywords: &["o‘ylash", "o‘ylayotgan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt suy nghĩ"),
            keywords: &["mặt", "mặt suy nghĩ", "đang suy nghĩ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu guy xalaat"),
            keywords: &["kanam", "kanamu guy xalaat", "xalaat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obucingayo"),
            keywords: &["ubuso", "ubuso obucingayo", "ukucinga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó Ronú"),
            keywords: &["Ojú tó Ronú", "ojú", "ńronú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("諗野嘅臉"),
            keywords: &["臉", "諗野", "諗野嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("谂野嘅脸"),
            keywords: &["脸", "谂野", "谂野嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("想一想"),
            keywords: &["思考", "想", "想一想", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("思考"),
            keywords: &["思考", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("思考中嘅表情"),
            keywords: &["思考中", "思考中嘅表情", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obucabangayo"),
            keywords: &["cabanga", "ubuso", "ubuso obucabangayo"],
        },
    ],
};
