#[doc = "😎"]
pub const SMILING_FACE_WITH_SUNGLASSES: crate::Emoji = crate::Emoji {
    glyph: "😎",
    codepoint: "1F60E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "smiling face with sunglasses",
    group: "Smileys & Emotion",
    subgroup: "face-glasses",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("glimlaggende gesig met sonbril"),
            keywords: &[
                "bril",
                "gesig",
                "glimlag",
                "glimlaggende gesig met sonbril",
                "helder",
                "koel",
                "oog",
                "son",
                "sonbril",
                "weer",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፀሐይ መነጽር ያደረገ ሣቂታ ፊት"),
            keywords: &["ብሩህ", "አሪፍ", "የፀሐይ መነጽር ያደረገ ሣቂታ ፊት", "ፀሐይ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه مبتسم بنظارة شمس"),
            keywords: &[
                "ابتسامة",
                "جذاب",
                "شمس",
                "نظارة",
                "نظارة شمسية",
                "\u{202b}وجه مبتسم بنظارة شمس",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছ\u{9be}নগ\u{9cd}ল\u{9be}চ পৰিহিত হ\u{9be}স\u{9cd}যম\u{9c1}খ"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল",
                "ক\u{9c1}ল",
                "ছ\u{9be}নগ\u{9cd}ল\u{9be}চ",
                "ছ\u{9be}নগ\u{9cd}ল\u{9be}চ পৰিহিত হ\u{9be}স\u{9cd}যম\u{9c1}খ",
                "ম\u{9c1}খ",
                "স\u{9c2}ৰ\u{9cd}য\u{9cd}য",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gün eynəyi ilə gülən üz"),
            keywords: &[
                "eynək",
                "göz",
                "gün eynəyi",
                "gün eynəyi ilə gülən üz",
                "günəş",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("усміхаецца ў сонечных акулярах"),
            keywords: &[
                "акуляры",
                "круты",
                "сонца",
                "усмешка",
                "усміхаецца ў сонечных акулярах",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Усмихнато лице със слънчеви очила"),
            keywords: &[
                "Усмихнато лице със слънчеви очила",
                "лице",
                "слънце",
                "слънчеви очила",
                "усмивка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}নগ\u{9cd}ল\u{9be}স পরিহিত হ\u{9be}সি ম\u{9c1}খ"),
            keywords: &[
                "উজ\u{9cd}জ\u{9cd}বল",
                "ক\u{9c1}ল",
                "ম\u{9c1}খ",
                "স\u{9be}নগ\u{9cd}ল\u{9be}স",
                "স\u{9be}নগ\u{9cd}ল\u{9be}স পর\u{9be} হ\u{9be}সি ম\u{9c1}খ",
                "স\u{9be}নগ\u{9cd}ল\u{9be}স পরিহিত হ\u{9be}সি ম\u{9c1}খ",
                "স\u{9c2}র\u{9cd}য",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osmijeh sa sunčanim naočalama"),
            keywords: &[
                "fora",
                "naočale",
                "osmijeh sa sunčanim naočalama",
                "sunčane naočale",
                "svjetlost",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara somrient amb ulleres de sol"),
            keywords: &["cara", "cara somrient amb ulleres de sol", "sol", "ulleres"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄏\u{11128} 𑄟\u{1112a} 𑄣\u{11127}𑄉𑄬 𑄌\u{1112e}𑄇\u{11134}𑄥𑄟𑄘\u{11133}𑄠𑄬"),
            keywords: &["𑄦𑄏\u{11128} 𑄟\u{1112a} 𑄣\u{11127}𑄉𑄬 𑄌\u{1112e}𑄇\u{11134}𑄥𑄟𑄘\u{11133}𑄠𑄬"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏰᏗᏍᎩ ᎤᎧᏔ ᏅᏓ ᏗᎦᏛᏅᏙᏗ ᏗᎦᏛᏅᏗᏍᏗ"),
            keywords: &[
                "ᎠᎦᎵ",
                "ᎤᎧᏛ",
                "ᎤᏁᏏᏴᏞ",
                "ᎤᏰᏗᏍᎩ ᎤᎧᏔ ᏅᏓ ᏗᎦᏛᏅᏙᏗ ᏗᎦᏛᏅᏗᏍᏗ",
                "ᏅᏓ",
                "ᏅᏓ ᏗᎦᏛᏅᏙᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("usmívající se obličej s brýlemi"),
            keywords: &[
                "brýle",
                "cool",
                "frajer",
                "jasno",
                "oko",
                "počasí",
                "slunce",
                "sluneční brýle",
                "smajlík",
                "tvář",
                "usmívající se obličej s brýlemi",
                "výraz",
                "úsměv",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwenu â sbectol haul"),
            keywords: &[
                "gwên",
                "llygad",
                "sbectol haul",
                "wyneb",
                "wyneb yn gwenu â sbectol haul",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("smilende ansigt med solbriller"),
            keywords: &[
                "cool",
                "sej",
                "smil med solbriller",
                "smilende ansigt med solbriller",
                "solbriller",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lächelndes Gesicht mit Sonnenbrille"),
            keywords: &[
                "Gesicht",
                "Sonnenbrille",
                "cool",
                "lächelndes Gesicht mit Sonnenbrille",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαμογελαστό πρόσωπο\u{a0}με γυαλιά ηλίου"),
            keywords: &[
                "ήλιος",
                "γυαλιά",
                "γυαλιά ηλίου",
                "καιρός",
                "μάτι",
                "οπτικά",
                "πρόσωπο",
                "στυλάτος",
                "φωτεινός",
                "χαμογελαστό πρόσωπο\u{a0}με γυαλιά ηλίου",
                "χαμόγελο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("smiling face with sunglasses"),
            keywords: &[
                "bright",
                "cool",
                "face",
                "smiling face with sunglasses",
                "sun",
                "sunglasses",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonriendo con gafas de sol"),
            keywords: &[
                "cara",
                "cara sonriendo con gafas de sol",
                "gafas",
                "guay",
                "sol",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara sonriendo con lentes de sol"),
            keywords: &[
                "cara",
                "cara sonriendo con lentes de sol",
                "lentes",
                "lentes de sol",
                "onda",
                "sol",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara sonriendo con lentes de sol"),
            keywords: &[
                "cara",
                "cara sonriendo con lentes de sol",
                "lentes de sol",
                "onda",
                "sol",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara sonriendo con lentes de sol"),
            keywords: &["cara sonriendo con lentes de sol"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päikeseprillidega naerunägu"),
            keywords: &[
                "ere",
                "lahe",
                "naeratus",
                "nägu",
                "päike",
                "päikeseprillid",
                "päikeseprillidega naerunägu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegia barreka, eguzkitako betaurrekoekin"),
            keywords: &[
                "argitasun",
                "aurpegi",
                "aurpegia barreka, eguzkitako betaurrekoekin",
                "begi",
                "cool",
                "eguzkitako betaurreko",
                "irribarre egiten ari den aurpegia, eguzkitako betaurrekoekin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("باحال"),
            keywords: &[
                "باحال",
                "خورشید",
                "روشن",
                "صورت",
                "صورت خندان با عینک آفتابی",
                "عینک آفتابی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aurinkolasihymy"),
            keywords: &["aurinko", "aurinkolasihymy", "aurinkolasit", "cool", "hymy"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakangiti nang may suot na shades"),
            keywords: &[
                "araw",
                "cool",
                "maaraw",
                "nakangiti",
                "nakangiti nang may suot na shades",
                "salamin",
                "sunglasses",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("smílandi andlit við sólbrillum"),
            keywords: &["andlit", "smílandi andlit við sólbrillum", "sólbrillur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec lunettes de soleil"),
            keywords: &["lunettes de soleil", "visage avec lunettes de soleil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage souriant avec des lunettes de soleil"),
            keywords: &[
                "cool",
                "intelligent",
                "soleil",
                "visage",
                "visage souriant avec des lunettes de soleil",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag gáire le spéaclaí gréine"),
            keywords: &[
                "meangadh gáire",
                "spéaclaí gréine",
                "straoiseog ag gáire le spéaclaí gréine",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann toilichte le speuclairean-grèine"),
            keywords: &[
                "aodann",
                "aodann toilichte le speuclairean-grèine",
                "fiamh-ghàire",
                "gasta",
                "grian",
                "smodaig",
                "soilleir",
                "speuclairean",
                "speuclairean-grèine",
                "sùil",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara riseira con lentes de sol"),
            keywords: &[
                "cara",
                "cara riseira con lentes de sol",
                "lentes de sol",
                "sorriso",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સનગ\u{acd}લાસ\u{ac7}સ સાથ\u{ac7} હસતો ચહ\u{ac7}રો"),
            keywords: &[
                "ક\u{ac2}લ",
                "ચહ\u{ac7}રો",
                "ત\u{ac7}જસ\u{acd}વી",
                "સનગ\u{acd}લાસ\u{ac7}સ",
                "સનગ\u{acd}લાસ\u{ac7}સ સાથ\u{ac7} હસતો ચહ\u{ac7}રો",
                "સ\u{ac2}ર\u{acd}ય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murmushi tare da tabarau"),
            keywords: &[
                "fuska",
                "fuska mai murmushi tare da tabarau",
                "ido",
                "kayan ido",
                "mai haske",
                "mai ni’ima",
                "murmushi",
                "rana",
                "tabarau",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מחייך עם משקפי שמש"),
            keywords: &[
                "חיוך",
                "מחייך",
                "משקפיים",
                "פרצוף",
                "פרצוף מחייך עם משקפי שמש",
                "שמח",
                "שמש",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "ध\u{942}प क\u{947} चश\u{94d}म\u{947} क\u{947} साथ म\u{941}स\u{94d}काता च\u{947}हरा",
            ),
            keywords: &[
                "चश\u{94d}म\u{947} क\u{947} साथ म\u{941}स\u{94d}काना",
                "च\u{947}हरा",
                "ध\u{942}प क\u{947} चश\u{94d}म\u{947} क\u{947} साथ म\u{941}स\u{94d}काता च\u{947}हरा",
                "ध\u{942}प क\u{947} चश\u{94d}म\u{947} वाला म\u{941}स\u{94d}काता च\u{947}हरा",
                "म\u{941}स\u{94d}काना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nasmiješeno lice sa sunčanim naočalama"),
            keywords: &[
                "cool",
                "lice",
                "nasmiješeno lice sa sunčanim naočalama",
                "sunce",
                "sunčane naočale",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mosolygó arc napszemüveggel"),
            keywords: &[
                "arc",
                "laza",
                "mosoly",
                "mosolygó arc napszemüveggel",
                "napszemüveg",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժպտացող դեմք արևային ակնոցով"),
            keywords: &[
                "ակնոց",
                "աչք",
                "արև",
                "արևային ակնոց",
                "դեմք",
                "եղանակ",
                "զիլ",
                "ժպտալ",
                "ժպտացող դեմք արևային ակնոցով",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("surriso con oculares de sol"),
            keywords: &[
                "berillos",
                "facie",
                "sol",
                "surriso",
                "surriso con oculares de sol",
                "visage",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah berkacamata hitam"),
            keywords: &[
                "kacamata hitam",
                "keren",
                "matahari",
                "pintar",
                "wajah",
                "wajah berkacamata hitam",
                "wajah tersenyum memakai kacamata",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu amụ nwere ugogbe anya anyanwụ"),
            keywords: &[
                "amụ",
                "anya",
                "anyanwụ",
                "dị mma",
                "ihu",
                "ihu amụ nwere ugogbe anya anyanwụ",
                "ile anya",
                "ugogbe anya",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brosandi andlit með sólgleraugu"),
            keywords: &[
                "bjart",
                "brosandi andlit með sólgleraugu",
                "brosandi andlit með sólgleraugum",
                "svalt",
                "sól",
                "sólgleraugu",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con sorriso e occhiali da sole"),
            keywords: &[
                "faccina",
                "faccina con sorriso e occhiali da sole",
                "occhiali da sole",
                "sorriso",
                "spensierato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サングラスで笑顔"),
            keywords: &["クール", "サングラスで笑顔", "スマイル", "笑顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mesem nganggo kacamata ireng"),
            keywords: &[
                "blereng",
                "kacamata ireng",
                "nggaya",
                "rai",
                "rai mesem nganggo kacamata ireng",
                "srengenge",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მომღიმარე სახე მზის სათვალით"),
            keywords: &[
                "ამინდი",
                "თვალი",
                "კაშკაშა",
                "მზე",
                "მზის სათვალე",
                "მომღიმარე სახე მზის სათვალით",
                "სათვალე",
                "სახე",
                "ტიპი",
                "ღიმილი",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("acmumeḥ s nwader n yiṭij"),
            keywords: &["acmumeḥ s nwader n yiṭij"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көзілдірік тағып жымию"),
            keywords: &["бет", "көзілдірік", "көзілдірік тағып жымию", "мықты"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smilende ansigt med solbriller"),
            keywords: &[
                "ansigt",
                "sej",
                "smil med solbriller",
                "smilende ansigt med solbriller",
                "solbriller",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខញញ\u{17b9}មពាក\u{17cb}វ\u{17c9}ែនតាខ\u{17d2}មៅ"),
            keywords: &[
                "ចា\u{17c6}ងថ\u{17d2}ងៃ",
                "ចា\u{17c6}ងភ\u{17d2}នែក",
                "ញញ\u{17b9}ម",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខញញ\u{17b9}មពាក\u{17cb}វ\u{17c9}ែនតាខ\u{17d2}មៅ",
                "វ\u{17c9}ែនតា",
                "វ\u{17c9}ែនតាខ\u{17d2}មៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸನ\u{ccd}\u{200c}ಗ\u{ccd}ಲಾಸ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ನಗು ಮುಖ"),
            keywords: &[
                "ತಂಪಾದ",
                "ಪ\u{ccd}ರಕಾಶಮಾನವಾದ",
                "ಮುಖ",
                "ಸನ\u{ccd}\u{200c}ಗ\u{ccd}ಲಾಸ\u{ccd}\u{200c}",
                "ಸನ\u{ccd}\u{200c}ಗ\u{ccd}ಲಾಸ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ನಗು ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("선글라스 낀 얼굴"),
            keywords: &["멋짐", "선글라스", "선글라스 낀 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सनग\u{94d}लास घाल\u{94d}लो हा\u{902}सपी च\u{947}रो"),
            keywords: &[
                "उजळ",
                "च\u{947}रो",
                "थ\u{902}ड",
                "सनग\u{94d}लास",
                "सनग\u{94d}लास घाल\u{94d}लो हा\u{902}सपी च\u{947}रो",
                "स\u{941}र\u{94d}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара көз айнекчен жылмайган бет"),
            keywords: &[
                "бет",
                "жарык",
                "кара көз айнек",
                "кара көз айнекчен жылмайган бет",
                "көз айнек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("laachend Gesiicht mat Sonnebrëll"),
            keywords: &[
                "A",
                "Brëll",
                "Gesiicht",
                "Laachen",
                "Sonn",
                "Sonnebrëll",
                "cool",
                "hell",
                "laachend Gesiicht mat Sonnebrëll",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມໃສ\u{ec8}ແວ\u{ec8}ນຕາກ\u{eb1}ນແດດ"),
            keywords: &[
                "ຍ\u{eb4}\u{ec9}ມ",
                "ແວ\u{ec8}ນ",
                "ແວ\u{ec8}ນຕາກ\u{eb1}ນແດດ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຍ\u{eb4}\u{ec9}ມໃສ\u{ec8}ແວ\u{ec8}ນຕາກ\u{eb1}ນແດດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besišypsantis veidas su akiniais nuo saulės"),
            keywords: &[
                "akiniai nuo saulės",
                "besišypsantis veidas su akiniais nuo saulės",
                "saulė",
                "veidas",
                "šaunus",
                "šviesus",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smaidoša seja ar saulesbrillēm"),
            keywords: &[
                "saulesbrilles",
                "seja",
                "smaidoša seja ar saulesbrillēm",
                "smaids",
                "stilīgs",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi menemene mau mōhitirā"),
            keywords: &[
                "kanapa",
                "kanohi",
                "kanohi menemene mau mōhitirā",
                "karu",
                "menemene",
                "mōhiti",
                "mōhitirā",
                "rawe",
                "rā",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("насмеано лице со очила за сонце"),
            keywords: &[
                "лице",
                "насмеано лице со очила за сонце",
                "насмевка",
                "очила",
                "сонце",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കണ\u{d4d}ണടയ\u{d41}ള\u{d4d}ള പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "കണ\u{d4d}ണടയ\u{d41}ള\u{d4d}ള പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "തിളക\u{d4d}കമ\u{d41}ള\u{d4d}ള",
                "മ\u{d41}ഖം",
                "സ\u{d42}ര\u{d4d}യൻ",
                "സ\u{d57}മ\u{d4d}യം",
                "സൺഗ\u{d4d}ല\u{d3e}സ\u{d41}വെച\u{d4d}ച പ\u{d41}ഞ\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "സൺഗ\u{d4d}ല\u{d3e}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нарны шил зүүж инээмсэглэсэн царай"),
            keywords: &[
                "зүүх",
                "инээмсэглэх",
                "нарны шил",
                "нарны шил зүүж инээмсэглэсэн царай",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उन\u{94d}हाचा चष\u{94d}मा घातल\u{947}ला हसरा च\u{947}हरा"),
            keywords: &[
                "उन\u{94d}हाचा चष\u{94d}मा घातल\u{947}ला हसरा च\u{947}हरा",
                "चष\u{94d}मा",
                "च\u{947}हरा",
                "थ\u{902}ड",
                "प\u{94d}रखर",
                "स\u{942}र\u{94d}य",
                "हास\u{94d}य",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tersenyum berkaca mata hitam"),
            keywords: &[
                "bergaya",
                "kaca mata hitam",
                "muka",
                "muka tersenyum berkaca mata hitam",
                "suria",
                "terang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jitbissem b’nuċċali tax-xemx"),
            keywords: &[
                "għajn",
                "imdawwal",
                "jitbissem",
                "modern",
                "nuċċali",
                "nuċċali tax-xemx",
                "nuċċalijiet",
                "wiċċ",
                "wiċċ jitbissem b’nuċċali tax-xemx",
                "xemx",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "နေကာမျက\u{103a}မ\u{103e}န\u{103a}ဖြင\u{1037}\u{103a} အပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "တောက\u{103a}ပခြင\u{103a}း",
                "နေ",
                "နေကာမျက\u{103a}မ\u{103e}န\u{103a}ဖြင\u{1037}\u{103a} အပြ\u{102f}\u{1036}းမျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("smilefjes med solbriller"),
            keywords: &[
                "fjes",
                "kul",
                "lyst",
                "smilefjes med solbriller",
                "sol",
                "solbriller",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शीतल\u{941} चस\u{94d}मा लगाएको ह\u{901}सिलो अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "उज\u{94d}यालो",
                "राम\u{94d}रो",
                "शीतल\u{941} चस\u{94d}मा",
                "शीतल\u{941} चस\u{94d}मा लगाएको ह\u{901}सिलो अन\u{941}हार",
                "स\u{942}र\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lachend gezicht met zonnebril"),
            keywords: &[
                "bril",
                "gezicht",
                "glimlach",
                "lach",
                "lachen",
                "lachend",
                "lachend gezicht met zonnebril",
                "lachend met zonnebril",
                "mooi weer",
                "ogen",
                "oog",
                "zon",
                "zonnebril",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("smilefjes med solbriller"),
            keywords: &[
                "fjes",
                "kul",
                "lyst",
                "smilefjes med solbriller",
                "sol",
                "solbriller",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ସନ\u{b4d}\u{200c}ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c} ସହ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ପର\u{b3f}ଷ\u{b4d}କ\u{b3e}ର",
                "ମ\u{b41}ହ\u{b01}",
                "ସନ\u{b4d}\u{200c}",
                "ସନ\u{b4d}\u{200c}ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c}",
                "ସନ\u{b4d}\u{200c}ଗ\u{b4d}ଲ\u{b3e}ସ\u{b4d}\u{200c} ସହ ହସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਲੀਆ\u{a02} ਐਨਕਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਐਨਕਾ\u{a02} ਨਾਲ ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ",
                "ਕਾਲੀਆ\u{a02} ਐਨਕਾ\u{a02} ਨਾਲ ਹ\u{a71}ਸਦਾ ਚਿਹਰਾ",
                "ਚਮਕਦਾਰ",
                "ਚਿਹਰਾ",
                "ਠ\u{a70}ਡਾ",
                "ਧ\u{a41}\u{a71}ਪ ਦੀਆ\u{a02} ਐਨਕਾ\u{a02}",
                "ਮ\u{a41}ਸਕਰਾਉ\u{a02}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("د\u{64f}ھوب آلی عینک نال مسکراندی شکل"),
            keywords: &[
                "اکھ",
                "اکھ پ\u{64f}وش",
                "د\u{64f}ھوب آلی عینک نال مسکراندی شکل",
                "دھوپ آلیاں عینکاں",
                "دی شکل",
                "روشن",
                "سورج",
                "عینک",
                "مسکرانا",
                "چ\u{64e}نگا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smaílín Fes Wé Wiá Sọ\u{301}nshed"),
            keywords: &[
                "Kul",
                "Shaínín Wẹ\u{301}l Wẹl",
                "Smaílín Fes Wé Wiá Sọ\u{301}nshed",
                "Sọn",
                "Sọ\u{301}nshed",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uśmiechnięta twarz w okularach przeciwsłonecznych"),
            keywords: &[
                "luzak",
                "na luzie",
                "okulary",
                "uśmiechnięta twarz w okularach przeciwsłonecznych",
                "zadowolony",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مسکېدونکی مخ د لمر دعينکو سره"),
            keywords: &[
                "د لمر عينکې",
                "لمر",
                "مخ",
                "مسکېدونکی مخ د لمر دعينکو سره",
                "پړقېدونکې",
                "کول",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto sorridente com óculos escuros"),
            keywords: &[
                "rosto",
                "rosto sorridente com óculos escuros",
                "sol",
                "sorrindo",
                "sorrindo de óculos escuros",
                "óculos escuros",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a sorrir com óculos de sol"),
            keywords: &[
                "cara",
                "cara a sorrir com óculos de sol",
                "fixe",
                "luminoso",
                "olho",
                "sol",
                "sorriso",
                "tempo",
                "óculos",
                "óculos de sol",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kusisqa uya lenteswan"),
            keywords: &[
                "allinlla",
                "inti",
                "kusisqa uya lenteswan",
                "kʼanchay",
                "lentes de sol nisqa",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față zâmbitoare cu ochelari de soare"),
            keywords: &[
                "față",
                "față zâmbitoare cu ochelari de soare",
                "ochelari de soare",
                "relaxare",
                "soare",
                "strălucitor",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-850"),
            keywords: &["E10-850"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("лицо в темных очках"),
            keywords: &[
                "клево",
                "круто",
                "лицо в солнцезащитный очках",
                "лицо в темных очках",
                "солнцезащитные очки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura iseka n’amataratara y’izuba"),
            keywords: &[
                "amataratara",
                "icyeye",
                "ijisho",
                "isura",
                "isura iseka n’amataratara y’izuba",
                "ituje",
                "izuba",
                "kumwenyura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اس جي چشمي سان گڏ مسڪرائيندڙ چهرو"),
            keywords: &[
                "اس جي عينڪ",
                "اس جي چشمي سان گڏ مسڪرائيندڙ چهرو",
                "اک",
                "روشن",
                "سج",
                "شيشا",
                "عمدو",
                "مرڪ",
                "چشمو",
                "چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "අව\u{dca} කණ\u{dca}ණ\u{dcf}ඩ\u{dd2} පැළඳ\u{dd2} ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
            ),
            keywords: &[
                "අව\u{dca} කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}",
                "අව\u{dca} කණ\u{dca}ණ\u{dcf}ඩ\u{dd2} පැළඳ\u{dd2} ස\u{dd2}නහ ම\u{dd4}හ\u{dd4}ණ",
                "කණ\u{dca}ණ\u{dcf}ඩ\u{dd2}",
                "ද\u{dd3}ප\u{dca}ත\u{dd2}මත\u{dca}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "සන\u{dca}ස\u{dd4}න\u{dca}",
                "ස\u{dd6}ර\u{dca}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("smejúca sa tvár s okuliarmi"),
            keywords: &[
                "okuliare",
                "slnko",
                "smejúca sa tvár s okuliarmi",
                "super",
                "tvár",
                "úsmev",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("smejoči obraz s sončnimi očali"),
            keywords: &[
                "frajersko",
                "nasmeh",
                "obraz",
                "očala",
                "oči",
                "smejoči obraz s sončnimi očali",
                "sonce",
                "sončna očala",
                "svetlo",
                "vreme",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dhoola cadeynaya ookiyaala wato"),
            keywords: &[
                "dhalaal",
                "dhoola cadeyn",
                "ookiyaale",
                "qabow",
                "qorrax",
                "waji",
                "waji dhoola cadeynaya ookiyaala wato",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e qeshur me syze dielli"),
            keywords: &[
                "diell",
                "fytyrë",
                "fytyrë e qeshur me syze dielli",
                "i ndritshëm",
                "syze dielli",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("насмејано лице са наочарима за сунце"),
            keywords: &[
                "врeмe",
                "кул",
                "лице",
                "нaoчaрe",
                "нaoчaрe за сунце",
                "насмејано лице са наочарима за сунце",
                "осмех",
                "очи",
                "сунцe",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("насмијано лице са наочарима за сунце"),
            keywords: &["насмијано лице са наочарима за сунце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nasmejano lice sa naočarima za sunce"),
            keywords: &[
                "kul",
                "lice",
                "naočare",
                "naočare za sunce",
                "nasmejano lice sa naočarima za sunce",
                "osmeh",
                "oči",
                "sunce",
                "vreme",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("nasmijano lice sa naočarima za sunce"),
            keywords: &["nasmijano lice sa naočarima za sunce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("leende ansikte med solglasögon"),
            keywords: &[
                "cool",
                "leende",
                "leende ansikte med solglasögon",
                "solglasögon",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaotabasamu uliovaa miwani"),
            keywords: &[
                "hali ya hewa",
                "inayong’aa",
                "jua",
                "tabasamu",
                "uso unaotabasamu uliovaa miwani",
                "vali la macho",
                "wimani ya jua",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "hali ya hewa",
                "inayong’aa",
                "jua",
                "miwani ya jua",
                "tabasamu",
                "uso unaotabasamu uliovaa miwani",
                "vali la macho",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சன\u{bcd}கிள\u{bbe}ஸ\u{bcd} அணிந\u{bcd}த சிரித\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "கண\u{bcd} கூசும\u{bcd} வெளிச\u{bcd}சம\u{bcd}",
                "கூலிங\u{bcd}கிள\u{bbe}ஸ\u{bcd}",
                "கூல\u{bcd}",
                "சன\u{bcd}கிள\u{bbe}ஸ\u{bcd} அணிந\u{bcd}த சிரித\u{bcd}த முகம\u{bcd}",
                "புன\u{bcd}னகை",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు ప\u{c46}ట\u{c4d}టుకున\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు",
                "కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు ప\u{c46}ట\u{c4d}టుకున\u{c3f} నవ\u{c4d}వుతున\u{c4d}న ముఖం",
                "కళ\u{c4d}లద\u{c4d}ద\u{c3e}లు ప\u{c46}ట\u{c4d}టుకున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хандон бо айнаки офтобӣ"),
            keywords: &[
                "айнак",
                "айнаки муҳофизатӣ",
                "айнаки офтобӣ",
                "офтоб",
                "равшан",
                "рӯи хандон бо айнаки офтобӣ",
                "рӯй",
                "салқин",
                "табассум",
                "чашм",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าย\u{e34}\u{e49}มใส\u{e48}แว\u{e48}น"),
            keywords: &[
                "ย\u{e34}\u{e49}ม",
                "หน\u{e49}า",
                "หน\u{e49}าย\u{e34}\u{e49}มใส\u{e48}แว\u{e48}น",
                "แว\u{e48}นก\u{e31}นแดด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gün äýnekli ýylgyrýan ýüz"),
            keywords: &[
                "bet",
                "gün",
                "gün äýnek",
                "gün äýnekli ýylgyrýan ýüz",
                "ýagty",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata malimali moe matasioʻatalaʻā"),
            keywords: &["mata malimali moe matasioʻatalaʻā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("güneş gözlüklü gülümseme"),
            keywords: &[
                "gülümseme",
                "güneş gözlükleri",
                "güneş gözlükleriyle gülümseme",
                "güneş gözlüklü gülümseme",
                "soğukkanlı Jane",
                "soğukkanlı Joe",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆزەينەك تاقىغان خۇش چىراي"),
            keywords: &[
                "ئەينەك",
                "كۆز",
                "كۆزەينەك",
                "كۆزەينەك تاقىغان خۇش چىراي",
                "كۈلۈمسىرەش",
                "كۈن",
                "كۈن ئەينىكى",
                "يورۇق",
                "پەيزى",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("усміхнене обличчя в темних окулярах"),
            keywords: &[
                "крутий",
                "обличчя",
                "окуляри",
                "очі",
                "погода",
                "посмішка",
                "сонце",
                "сонцезахисні",
                "темні окуляри",
                "усміхнене обличчя в темних окулярах",
                "яскраво",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھوپ کا چشمہ لگائے مسکراتا چہرہ"),
            keywords: &[
                "آنکھ",
                "دھوپ",
                "دھوپ کا چشمہ لگائے مسکراتا چہرہ",
                "سورج",
                "مسکراہٹ",
                "چشمہ",
                "چمکیلا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘zoynak taqqan hamda kulayotgan yuz"),
            keywords: &[
                "ko‘zoynak",
                "ko‘zoynak taqqan hamda kulayotgan yuz",
                "ob-havo",
                "quyosh",
                "salqin",
                "tabassum",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cười đeo kính"),
            keywords: &[
                "kính",
                "mặt",
                "mặt cười đeo kính",
                "mặt trời",
                "phong cách",
                "sáng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("muuñ, kanam, nuwaarfime"),
            keywords: &[
                "bët",
                "jant",
                "kanam",
                "lunet",
                "muuñ",
                "muuñ, kanam, nuwaarfime",
                "neex-deret",
                "nuwaarfime",
                "weer",
                "yànj",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuncumileyo obuneendondo"),
            keywords: &[
                "ekhanyayo",
                "entle",
                "iiglasi",
                "iindondo",
                "ilanga",
                "iliso",
                "ubuso",
                "ubuso obuncumileyo obuneendondo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti O N Rẹrin Pẹlu Digi Oju"),
            keywords: &[
                "Oju Ti O N Rẹrin Pẹlu Digi Oju",
                "mọ\u{301}lẹ\u{300}",
                "ojú",
                "rẹ\u{301}rìń músẹ\u{301}",
                "tutù",
                "àwọn gílásì",
                "àwọn gílásì òrùn",
                "ìbojú",
                "òrùn",
                "ẹyinjú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("微笑嘅臉同太陽眼鏡"),
            keywords: &["太陽眼鏡", "微笑嘅臉同太陽眼鏡", "臉", "酷"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("微笑嘅脸同太阳眼镜"),
            keywords: &[
                "太阳",
                "太阳眼镜",
                "微笑",
                "微笑嘅脸同太阳眼镜",
                "眼",
                "眼镜",
                "脸",
                "酷",
                "醒",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("墨镜笑脸"),
            keywords: &["墨镜", "墨镜笑脸", "太阳镜", "眼镜", "酷"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("墨鏡"),
            keywords: &["墨鏡", "酷"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("戴太陽眼鏡嘅笑面"),
            keywords: &["墨鏡", "戴太陽眼鏡嘅笑面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumoyizelayo obugqoke izibuko zelanga"),
            keywords: &[
                "amehlo",
                "ilanga",
                "isimo sezulu",
                "izibuko",
                "izibuko zelanga",
                "moyizela",
                "okugqokwa emehlweni",
                "ubuhle",
                "ubuso",
                "ubuso obumoyizelayo obugqoke izibuko zelanga",
            ],
        },
    ],
};
#[doc = "🤓"]
pub const NERD_FACE: crate::Emoji = crate::Emoji {
    glyph: "🤓",
    codepoint: "1F913",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nerd face",
    group: "Smileys & Emotion",
    subgroup: "face-glasses",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bleeksielgesig"),
            keywords: &["bleeksiel", "bleeksielgesig", "gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ያገጠጠ ባለመነጽር ፊት"),
            keywords: &["መነጽራም", "የገጠጠ", "ያገጠጠ ባለመነጽር ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه عبقري"),
            keywords: &["عبقري", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c1}ৰ\u{9cd}বক চেহেৰ\u{9be}"),
            keywords: &[
                "গীক",
                "ব\u{9c1}ৰ\u{9cd}বক",
                "ব\u{9c1}ৰ\u{9cd}বক চেহেৰ\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("axmaq üz"),
            keywords: &["axmaq", "gicbəsər", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гік"),
            keywords: &["батан", "гік", "задрот", "нёрд"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице на „читанка“"),
            keywords: &["Лице на „читанка“", "зубър", "лице", "читанка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পড\u{9bc}\u{9c1}য\u{9bc}\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "গ\u{9c1}র\u{9c1}",
                "পড\u{9bc}\u{9c1}য\u{9bc}\u{9be} ম\u{9c1}খ",
                "বোক\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("štreber"),
            keywords: &["lice", "čudak", "štreber"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de setciències"),
            keywords: &[
                "aplicada",
                "aplicat",
                "cara de setciències",
                "estudiar",
                "estudiosa",
                "estudiós",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᎸᏗ ᎤᎧᏛ"),
            keywords: &["ᎠᎧᎾᏗ", "ᎤᎦᎸᏗ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej šprta"),
            keywords: &[
                "geek",
                "nerd",
                "obličej šprta",
                "smajlík",
                "tvář",
                "výraz",
                "šplhoun",
                "šprt",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb clyfar"),
            keywords: &["clyfar", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("nørdansigt"),
            keywords: &["ansigt", "nørd", "nørdansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Strebergesicht"),
            keywords: &["Gesicht", "Nerd", "Strebergesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπασίκλας"),
            keywords: &["πρόσωπο", "σπασίκλας", "φυτό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nerd face"),
            keywords: &["face", "geek", "nerd"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de empollón"),
            keywords: &["cara", "cara de empollón", "empollón", "friki", "friqui"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de nerd"),
            keywords: &["anteojos", "cara", "cara de nerd", "geek", "nerd"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nohiku nägu"),
            keywords: &["friik", "nohik", "nohiku nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("arraro-aurpegia"),
            keywords: &["arraro", "arraro-aurpegia", "aurpegi", "berezi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خوره"),
            keywords: &["حرفه\u{200c}ای", "خوره", "صورت", "عجیب و غریب", "متفاوت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nörtti"),
            keywords: &["jänöhammas", "naama", "nörtti", "silmälasit"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nerd"),
            keywords: &["geek", "hippie", "mukha", "nerd", "salamin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nørd andlit"),
            keywords: &["andlit", "nørd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage de geek"),
            keywords: &["geek", "lunettes", "visage", "visage de geek"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage de tronche"),
            keywords: &[
                "geek",
                "lunettes",
                "nerd",
                "tronche",
                "visage",
                "visage de tronche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog shaoithíneach"),
            keywords: &[
                "aghaidh",
                "aghaidh saoithíneach",
                "geocach ríomhaire",
                "saoithín",
                "straoiseog shaoithíneach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann gìog"),
            keywords: &["aodann", "gìog"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de chapón"),
            keywords: &["anteollos", "cara", "cara de chapón", "chapón", "estudar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભોળપણના ભાવવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ભોળપણ",
                "ભોળપણના ભાવવાળો ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
                "મ\u{ac1}ર\u{acd}ખતાના ભાવવાળો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai daƙiƙi"),
            keywords: &["fuska", "fuska mai daƙiƙi", "mai azanci", "mai daƙiƙi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף של חנון"),
            keywords: &["חנון", "מחייך", "משקפיים", "פרצוף", "פרצוף של חנון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{942}र\u{94d}खता क\u{947} भाव वाला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "ब\u{947}वक\u{942}फी क\u{947} भाव वाला च\u{947}हरा",
                "म\u{942}र\u{94d}खता क\u{947} भाव वाला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("štrebersko lice"),
            keywords: &[
                "lice",
                "pametnjaković",
                "šmokljan",
                "štreber",
                "štrebersko lice",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kockaarc"),
            keywords: &["arc", "gépmániás", "kocka", "kockaarc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գերազանցիկի դեմք"),
            keywords: &["գերազանցիկ", "գերազանցիկի դեմք", "դեմք", "խելացի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah kutu buku"),
            keywords: &["buku", "kutu", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu eze ọchị"),
            keywords: &["eze", "ihu", "ọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nördaandlit"),
            keywords: &["andlit", "lúði", "nörd", "nördaandlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina nerd"),
            keywords: &[
                "faccina nerd",
                "nerd",
                "occhiali da nerd",
                "secchione",
                "studioso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オタク"),
            keywords: &["オタク", "マニア", "メガネ", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kutu buku"),
            keywords: &["kutu buku", "kutu komputer", "rai", "rai kutu buku"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სულელური სახე"),
            keywords: &["ნერდი", "სახე", "სულელური სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көзілдірік таққан"),
            keywords: &["білгішсымақ", "көзілдірік таққан"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("nørdansigt"),
            keywords: &["ansigt", "nørd", "nørdansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17c6}ប\u{17d2}លែង"),
            keywords: &[
                "ក\u{17c6}ប\u{17d2}លែង",
                "ម\u{17bb}ខក\u{17c6}ប\u{17d2}លែង",
                "ឡប\u{17cb}ឡប\u{17cb}",
                "ឡ\u{17ba}ក\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{cc6}ದ\u{ccd}ದು ಮುಖ"),
            keywords: &["ದಡ\u{ccd}ಡತನ", "ಪ\u{cc6}ದ\u{ccd}ದು ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("모범생 얼굴"),
            keywords: &["공부벌레", "괴짜", "모범생", "범생이", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मिश\u{94d}कील च\u{947}रो"),
            keywords: &["उत\u{94d}साहीत", "च\u{947}रो", "मिश\u{94d}कील"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чилистен"),
            keywords: &["бет", "окумуштуу", "чилистен"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Nerd"),
            keywords: &["Geek", "Gesiicht", "Nerd"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຄ\u{ebb}ນໂງ\u{ec8}"),
            keywords: &[
                "ຄ\u{ebb}ນໂງ\u{ec8}",
                "ຈ\u{eb4}ງຈ\u{eb1}ງ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຄ\u{ebb}ນໂງ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moksliuko veidas"),
            keywords: &["moksliukas", "moksliuko veidas", "pirmūnas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("gudrītis"),
            keywords: &["briļļainais", "gudrītis", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi nere"),
            keywords: &["kanohi", "kīki", "nere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице на бубалица"),
            keywords: &["бубалица", "лице", "лице на бубалица", "чудак"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോമ\u{d3e}ളി മ\u{d41}ഖം"),
            keywords: &["കിറ\u{d41}ക\u{d4d}കൻ", "കോമ\u{d3e}ളി", "മ\u{d41}ഖം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ухаантай царай"),
            keywords: &["ухаантай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अभ\u{94d}यास\u{942} क\u{902}टाळवाणा च\u{947}हरा"),
            keywords: &[
                "अभ\u{94d}यास\u{942} क\u{902}टाळवाणा",
                "अभ\u{94d}यास\u{942} क\u{902}टाळवाणा च\u{947}हरा",
                "गीक",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka nerda"),
            keywords: &["gek", "muka", "nerda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ nerd"),
            keywords: &["nerd", "stramb", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တစ\u{103a}စ\u{102f}\u{1036}တစ\u{103a}ရာက\u{102d}\u{102f} ရ\u{1030}းသ\u{103d}ပ\u{103a}သ\u{1030}၏ မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "တစ\u{103a}စ\u{102f}\u{1036}တစ\u{103a}ရာက\u{102d}\u{102f} ရ\u{1030}းသ\u{103d}ပ\u{103a}သ\u{1030}၏ မျက\u{103a}န\u{103e}ာ",
                "ပညာရ\u{103e}င\u{103a}",
                "မျက\u{103a}န\u{103e}ာ",
                "ရ\u{1030}းသ\u{103d}ပ\u{103a}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nerdefjes"),
            keywords: &["fjes", "nerd", "nerdefjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पढन\u{94d}दास अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "किताबको किरा",
                "पढन\u{94d}दास अन\u{941}हार",
                "विज\u{94d}ञ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("nerdgezicht"),
            keywords: &["geek", "gezicht", "nerd", "nerderig", "nerdgezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nerdefjes"),
            keywords: &["fjes", "nerd", "nerdefjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3f}ର\u{b4d}ବୋଧ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅଦ\u{b4d}ଭ\u{b41}ତ ଲୋକ",
                "ନ\u{b3f}ର\u{b4d}ବୋଧ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੜ\u{a4d}ਹਾਕ\u{a42} ਚਿਹਰਾ"),
            keywords: &[
                "ਗ\u{a3c}\u{a48}ਰ-ਸਮਾਜਕ ਪਰ ਅਕਲਮ\u{a70}ਦ",
                "ਚਿਹਰਾ",
                "ਪੜ\u{a4d}ਹਾਕ\u{a42} ਚਿਹਰਾ",
                "ਬ\u{a47}ਵਕ\u{a42}ਫ",
                "ਮ\u{a42}ਰਖਤਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بیوقوف شکل"),
            keywords: &["احمق", "بیوقوف شکل", "دی شکل", "نگاہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tẹ\u{301}kíníkál Ẹ\u{301}spat Fes"),
            keywords: &[
                "Búkúrú Pẹ\u{301}sin Fes",
                "Fes",
                "Tẹ\u{301}kíníkál Ẹ\u{301}spat",
                "Tẹ\u{301}kíníkál Ẹ\u{301}spat Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kujon"),
            keywords: &["buźka w okularach", "inteligent", "kujon"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بېګانه مخ"),
            keywords: &["بيګانه", "بېګانه مخ", "مخ", "ګيک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto de nerd"),
            keywords: &["cdf", "estudioso", "nerd", "rosto de nerd", "sabe-tudo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara de cromo"),
            keywords: &["cara", "cara de cromo", "totó"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuyaq uya"),
            keywords: &["friki", "uya", "yuyaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față de tocilar"),
            keywords: &["față", "față de tocilar", "tocilar"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1013"),
            keywords: &["E10-1013"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("очкарик"),
            keywords: &["в очках", "всезнайка", "отличник", "очкарик", "очки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ya kanyuguti"),
            keywords: &["ikigoryi", "isura", "isura ya kanyuguti", "ntibindeba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بيوقوف چهرو"),
            keywords: &["احمق", "بيوقوف چهرو", "چهرو", "گيڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මෝඩ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &["ම\u{dd4}හ\u{dd4}ණ", "මොට\u{dca}ට", "මෝඩ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vedátor"),
            keywords: &["bifľloš", "tvár", "vedátor", "čudák", "šprták"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("piflarski obraz"),
            keywords: &["frik", "obraz", "piflar", "piflarski obraz", "znalec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji xirfad la’aan"),
            keywords: &["aan muuqan", "waji", "waji xirfad la’aan", "xirfad la’aan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë peshkopi"),
            keywords: &["fytyrë", "fytyrë peshkopi", "peshkop"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("штреберско лице"),
            keywords: &["лице", "пaмeтњaкoвић", "штрeбeр", "штреберско лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["штреберско лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("štrebersko lice"),
            keywords: &["lice", "pametnjaković", "štreber", "štrebersko lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["štrebersko lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nördansikte"),
            keywords: &["ansikte", "glasögon", "nörd", "nördansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wa mjuaji"),
            keywords: &[
                "mjuzi wa teknolojia",
                "mtaalamu wa mambo",
                "uso",
                "uso wa mjuaji",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அழகற\u{bcd}ற முகம\u{bcd}"),
            keywords: &[
                "அழகற\u{bcd}ற முகம\u{bcd}",
                "கண\u{bcd}ண\u{bbe}டி",
                "கோம\u{bbe}ளி",
                "வேடிக\u{bcd}கைய\u{bbe}ன முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3e}న\u{c47} నవ\u{c4d}వుకుంటున\u{c4d}న ముఖం"),
            keywords: &[
                "త\u{c3e}న\u{c47} నవ\u{c4d}వుకుంటున\u{c4d}న ముఖం",
                "నవ\u{c4d}వు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи соддалавҳ"),
            keywords: &["доно", "рӯи соддалавҳ", "рӯй", "соддалавҳ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เด\u{e47}กเน\u{e34}ร\u{e4c}ด"),
            keywords: &[
                "จร\u{e34}งจ\u{e31}ง",
                "หน\u{e49}า",
                "เด\u{e47}กเน\u{e34}ร\u{e4c}ด",
                "เน\u{e34}ร\u{e4c}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("botan ýüz"),
            keywords: &["botan", "ylym uran", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe matasioʻata lahi"),
            keywords: &["mata moe matasioʻata lahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ukala yüz"),
            keywords: &["bilgili", "inek öğrenci", "ukala", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("دۆت چىراي"),
            keywords: &["ئەخمەق", "دۆت", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя всезнайка"),
            keywords: &[
                "дойда",
                "дока",
                "обличчя",
                "обличчя всезнайка",
                "обличчя заучки",
                "унікум",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بیوقوفانہ چہرہ"),
            keywords: &["بیوقوفانہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aqlli yuz"),
            keywords: &["aqlli", "bilimdon", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt mọt sách"),
            keywords: &["mặt", "mặt mọt sách", "mọt sách", "đam mê"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu bëñu lëk"),
            keywords: &["bëgg-masin", "kanam", "kanamu bëñu lëk", "lëk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso benkcuba-buchopho"),
            keywords: &[
                "inkcuba-buchopho",
                "ubuso",
                "ubuso benkcuba-buchopho",
                "ungqondongqondo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ọmọwe Ti Ko Jafafa"),
            keywords: &[
                "Oju Ọmọwe Ti Ko Jafafa",
                "ojú",
                "ọ\u{300}mọ\u{300}wé",
                "ọ\u{300}mọ\u{300}wé tí kò jáfáfá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("書呆子嘅臉"),
            keywords: &["奇怪", "書呆子", "書呆子嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("书呆子嘅脸"),
            keywords: &["书呆子", "书呆子嘅脸", "奇怪", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("书呆子脸"),
            keywords: &["书呆子脸", "奇葩", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("搞怪"),
            keywords: &["怪人", "搞怪", "當阿宅"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("書呆子"),
            keywords: &["四眼田雞", "宅宅", "宅男", "書呆子", "阿宅"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso besihlakaniphi"),
            keywords: &["isihlakaniphi", "ubuso", "ubuso besihlakaniphi"],
        },
    ],
};
#[doc = "🧐"]
pub const FACE_WITH_MONOCLE: crate::Emoji = crate::Emoji {
    glyph: "🧐",
    codepoint: "1F9D0",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "face with monocle",
    group: "Smileys & Emotion",
    subgroup: "face-glasses",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met oogglas"),
            keywords: &["bedompig", "gesig met oogglas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የዓይን ባጅ ያደረገ ፊት"),
            keywords: &["የዓይን ባጅ ያደረገ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مع نظارة لعين واحدة"),
            keywords: &["وجه مع نظارة لعين واحدة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মোনোকলৰ চেহেৰ\u{9be}"),
            keywords: &["মোনোকলৰ চেহেৰ\u{9be}", "শ\u{9cd}ব\u{9be}সৰোধী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("monokllu üz"),
            keywords: &["monokllu üz", "stuffy"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з маноклем"),
            keywords: &["напышлівы", "твар з маноклем"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с монокъл"),
            keywords: &["Лице с монокъл", "консервативен", "старомоден"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("একচোখে চশম\u{9be} ওয\u{9bc}\u{9be}ল\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "একচোখে চশম\u{9be} ওয\u{9bc}\u{9be}ল\u{9be} ম\u{9c1}খ",
                "দমবন\u{9cd}ধ কর\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lice s monoklom"),
            keywords: &["lice s monoklom", "monokl", "začepljen"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb monocle"),
            keywords: &["cara amb monocle", "estirada", "estirat", "monocle"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏛᏅᏙᏗ ᎤᎧᏛ"),
            keywords: &["ᎠᎧᎵ", "ᏗᎦᏛᏅᏙᏗ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s brýlovým monoklem"),
            keywords: &[
                "konvenční",
                "obličej s brýlovým monoklem",
                "prudérní",
                "staromódní",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gyda monocl"),
            keywords: &["clòs", "wyneb gyda monocl"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med monokel"),
            keywords: &["ansigt med monokel", "gammeldags"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit Monokel"),
            keywords: &["Gesicht mit Monokel", "Monokel"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο με μονόκλ"),
            keywords: &["ξενέρωτος", "πρόσωπο με μονόκλ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with monocle"),
            keywords: &["face with monocle", "stuffy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con monóculo"),
            keywords: &["aristocrático", "cara con monóculo", "estirado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("monokliga nägu"),
            keywords: &["monokliga nägu", "vanamoeline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("monokulo bat duen aurpegia"),
            keywords: &["aspergarria", "monokulo bat duen aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت با عینک یک\u{200c}چشمی"),
            keywords: &["بدگمانی", "تخیلی", "سوءظن", "صورت با عینک یک\u{200c}چشمی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("monokkeli silmässä"),
            keywords: &["kalkkis", "monokkeli silmässä", "vanhanaikainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukha na may monocle"),
            keywords: &["mukha na may monocle", "stuffy"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við einglesi"),
            keywords: &["andlit", "andlit við einglesi", "einglesi", "monokul"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec un monocle"),
            keywords: &["collet monté", "vieux jeu", "visage avec un monocle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["monocle", "sérieux", "visage", "visage avec un monocle"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le leathspéacla"),
            keywords: &[
                "aghaidh le leathspéacla",
                "leathspéacla",
                "straoiseog le leathspéacla",
                "uasaicmeach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le leth-speuclair"),
            keywords: &["aodann le leth-speuclair", "seann-fhasanta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara con monóculo"),
            keywords: &["cara", "cara con monóculo", "monóculo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોનોકલ સાથ\u{ac7} ચહ\u{ac7}રો"),
            keywords: &["મોનોકલ સાથ\u{ac7} ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da tabarau mai ido ɗaya"),
            keywords: &["fuska tare da tabarau mai ido ɗaya", "mai cunkusa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם מונוקל"),
            keywords: &["כבד", "משעמם", "פרצוף עם מונוקל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("एक आ\u{901}ख म\u{947}\u{902} चश\u{94d}मा पहन\u{947} च\u{947}हरा"),
            keywords: &[
                "उबाऊ",
                "एक आ\u{901}ख म\u{947}\u{902} चश\u{94d}मा पहन\u{947} च\u{947}हरा",
                "भरा ह\u{941}आ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s monoklom"),
            keywords: &["lice s monoklom", "uštogljeno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc monoklival"),
            keywords: &["arc monoklival", "mérges"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոնոկլով դեմք"),
            keywords: &["բարձրամիտ", "խստաբարո", "մոնոկլով դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan monokel"),
            keywords: &["pengap", "sesak", "wajah dengan monokel"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere ahụọnụ"),
            keywords: &["enweghị ezigbo ìkùkù", "ihu nwere ahụọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með einglyrni"),
            keywords: &["andlit með einglyrni", "gamaldags", "teprulegur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con monocolo"),
            keywords: &["faccina con monocolo", "sospetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("モノクルを付けた顔"),
            keywords: &["メガネ", "モノクルを付けた顔", "片眼鏡", "考える", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai nganggo kacamata lensa tunggal"),
            keywords: &["kolot", "rai nganggo kacamata lensa tunggal"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე მონოკლით"),
            keywords: &["მკაცრი", "პედანტი", "სახე მონოკლით", "წესრიგიანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("монокль тағу"),
            keywords: &["менсінбеу", "монокль тағу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខពាក\u{17cb}វ\u{17c9}ែនតាម\u{17d2}ខាង"),
            keywords: &[
                "ម\u{17bb}ខពាក\u{17cb}វ\u{17c9}ែនតាម\u{17d2}ខាង",
                "ហប\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊನೊಕಲ\u{ccd} ಮುಖ"),
            keywords: &[
                "ಒಂದು ಕಣ\u{ccd}ಣ\u{cbf}ಗ\u{cc6} ಕನ\u{ccd}ನಡಕ ಹಾಕ\u{cbf}ರುವ ಮುಖ",
                "ಮೊನೊಕಲ\u{ccd} ಮುಖ",
                "ಸ\u{ccd}ಟಫೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("단안경을 쓴 얼굴"),
            keywords: &["단안경을 쓴 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोनोकल घाल\u{94d}लो च\u{947}रो"),
            keywords: &["मोनोकल घाल\u{94d}लो च\u{947}रो", "रागिष\u{94d}ट"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("монокль кармаган жүз"),
            keywords: &["бой көтөргөн", "монокль кармаган жүз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat Monokel"),
            keywords: &["Gesiicht mat Monokel", "langweileg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າໃສ\u{ec8}ແວ\u{ec8}ນຂ\u{ec9}າງດຽວ"),
            keywords: &[
                "ອ\u{ebb}ບເອ\u{ebb}\u{ec9}າ",
                "ໜ\u{ec9}າໃສ\u{ec8}ແວ\u{ec8}ນຂ\u{ec9}າງດຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas su monokliu"),
            keywords: &["tvankus", "veidas su monokliu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar monokli"),
            keywords: &["seja ar monokli", "vecmodīga"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi mau mōhititahi"),
            keywords: &["kanohi mau mōhititahi", "māuiui"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со монокл"),
            keywords: &["лице со монокл", "надуенко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഒറ\u{d4d}റച\u{d4d}ചില\u{d4d}ല\u{d41}കണ\u{d4d}ണട വച\u{d4d}ച മ\u{d41}ഖം"),
            keywords: &[
                "ഒറ\u{d4d}റച\u{d4d}ചില\u{d4d}ല\u{d41}കണ\u{d4d}ണട വച\u{d4d}ച മ\u{d41}ഖം",
                "ബലംപിട\u{d41}ത\u{d4d}തം",
                "മസില\u{d41}പിട\u{d41}ത\u{d4d}തം",
                "വിരസൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нэг нүдний нүдний шил зүүсэн царай"),
            keywords: &["бүгчим", "нэг нүдний нүдний шил зүүсэн царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मॉनोकल घातल\u{947}ला च\u{947}हरा"),
            keywords: &["मॉनोकल घातल\u{947}ला च\u{947}हरा", "स\u{94d}टफी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka dengan cermin mata satu kanta"),
            keywords: &["muka dengan cermin mata satu kanta", "tersumbat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ bil-monokolu"),
            keywords: &["bla arja", "wiċċ bil-monokolu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တစ\u{103a}ဖက\u{103a}တည\u{103a}းပါတ\u{1032}\u{1037} မျက\u{103a}မ\u{103e}န\u{103a}န\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "တစ\u{103a}ဖက\u{103a}တည\u{103a}းပါတ\u{1032}\u{1037} မျက\u{103a}မ\u{103e}န\u{103a}န\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "လ\u{103e}ောင\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fjes med monokkel"),
            keywords: &["fjes", "fjes med monokkel", "formell", "monokkel", "stiv"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मोनोकलसहितको अन\u{941}हार"),
            keywords: &["मोनोकलसहितको अन\u{941}हार", "र\u{941}ष\u{94d}ट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met monocle"),
            keywords: &["gezicht met monocle", "saai"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fjes med monokkel"),
            keywords: &["fjes", "fjes med monokkel", "formell", "monokkel", "stiv"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଗୋଟେ ଆଖ\u{b3f}ରେ ପ\u{b3f}ନ\u{b4d}ଧ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଚଷମ\u{b3e} ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଅହଙ\u{b4d}କ\u{b3e}ରପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ",
                "ଗୋଟେ ଆଖ\u{b3f}ରେ ପ\u{b3f}ନ\u{b4d}ଧ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଚଷମ\u{b3e} ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਖ ਉ\u{a71}ਤ\u{a47} ਇ\u{a71}ਕ ਸ\u{a3c}ੀਸ\u{a3c}\u{a47} ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਅ\u{a71}ਖ ਉ\u{a71}ਤ\u{a47} ਇ\u{a71}ਕ ਸ\u{a3c}ੀਸ\u{a3c}\u{a47} ਵਾਲਾ ਚਿਹਰਾ",
                "ਭਰਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("یک چشمی شکل"),
            keywords: &["حبس آلا", "یک چشمی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wit Wọ\u{301}n Ai Aíglas"),
            keywords: &["Fes Wit Wọ\u{301}n Ai Aíglas", "Óld-Fáshọn Wè"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z monoklem"),
            keywords: &["twarz z monoklem", "wyniosły"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د يوې سترګې عينکې مخ"),
            keywords: &["تړبوخته", "د يوې سترګې عينکې مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com monóculo"),
            keywords: &["conservador", "rosto com monóculo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com monóculo"),
            keywords: &["cara com monóculo", "conservador", "formal"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya monoculowan"),
            keywords: &["maskasqa", "uya monoculowan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu monoclu"),
            keywords: &["față cu monoclu", "înțepat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1121"),
            keywords: &["E10-1121"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("с моноклем"),
            keywords: &[
                "задавака",
                "монокль",
                "напыщенный",
                "с моноклем",
                "старомодный",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura y’umuntu wambaye idarubindi"),
            keywords: &["isura y’umuntu wambaye idarubindi", "ubangamiwee"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هڪ عينڪ وارو چهرو"),
            keywords: &["جڪڙيل", "هڪ عينڪ وارو چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තන\u{dd2} ක\u{dcf}චයක\u{dca} සහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කේන\u{dca}ත\u{dd2} ග\u{dd2}ය",
                "තන\u{dd2} ක\u{dcf}චයක\u{dca} සහ\u{dd2}ත ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s\u{a0}monoklom"),
            keywords: &["staromódna", "tvár", "tvár s\u{a0}monoklom"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z monoklom"),
            keywords: &["obraz z monoklom"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji hal ookiyaalo leh"),
            keywords: &["cabsi", "waji hal ookiyaalo leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me monokël"),
            keywords: &["fytyrë me monokël", "hundë të bllokuara"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са моноклом"),
            keywords: &["зачепљен", "лице са моноклом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa monoklom"),
            keywords: &["lice sa monoklom", "začepljen"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med monokel"),
            keywords: &["ansikte med monokel", "gammaldags", "torr"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye miwani kwenye jicho moja"),
            keywords: &["iliyorembwa", "uso wenye miwani kwenye jicho moja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒற\u{bcd}றைக\u{bcd} கண\u{bcd}ண\u{bbe}டி அணிந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "அறிவ\u{bbe}ளி",
                "ஒற\u{bcd}றைக\u{bcd} கண\u{bcd}ண\u{bbe}டி அணிந\u{bcd}த முகம\u{bcd}",
                "கூர\u{bcd}ந\u{bcd}த கவனம\u{bcd}",
                "பழம\u{bcd} பஞ\u{bcd}ச\u{bbe}ங\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}న\u{c3f}కల\u{c4d} ప\u{c46}ట\u{c4d}టుకున\u{c4d}న ముఖం"),
            keywords: &[
                "చ\u{c3f}రచ\u{c3f}రల\u{c3e}డటం",
                "మ\u{c3e}న\u{c3f}కల\u{c4d} ప\u{c46}ట\u{c4d}టుకున\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо айнаки якчашма"),
            keywords: &["нафасгир", "рӯй бо айнаки якчашма"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าก\u{e31}บแว\u{e48}นเลนส\u{e4c}เด\u{e35}ยว"),
            keywords: &["หน\u{e49}าก\u{e31}บแว\u{e48}นเลนส\u{e4c}เด\u{e35}ยว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("monoklly ýüz"),
            keywords: &["dykylan", "monoklly ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe matasioʻata tafaʻaki taha"),
            keywords: &["mata moe matasioʻata tafaʻaki taha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tek cam gözlüklü yüz"),
            keywords: &["kendini beğenmiş", "tek cam gözlüklü yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يەكچەشمە چىراي"),
            keywords: &["دىمىق", "يەكچەشمە چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя в моноклі"),
            keywords: &["обличчя в моноклі", "обличчя з моноклем", "пановитий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایک چشمہ پہنا ہوا چہرہ"),
            keywords: &["ایک چشمہ پہنا ہوا چہرہ", "بند ناک والا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("monokl bilan"),
            keywords: &["monokl bilan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt với kính một mắt"),
            keywords: &["mặt với kính một mắt", "ngột ngạt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak lunet-bennbët"),
            keywords: &["fatt", "kanam ak lunet-bennbët"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obune-monocle"),
            keywords: &["ubuso obune-monocle", "ukuxinana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ojú tó súnkì"),
            keywords: &["Ojú tó súnkì", "Sítọ\u{301}fì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("戴單片眼鏡嘅臉"),
            keywords: &["戴單片眼鏡嘅臉", "邋遢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("戴单片眼镜嘅脸"),
            keywords: &["戴单片眼镜嘅脸", "邋遢"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("带单片眼镜的脸"),
            keywords: &["古板", "带单片眼镜的脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("單片眼鏡"),
            keywords: &["單片眼鏡", "病厭厭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("戴單片眼鏡"),
            keywords: &["戴單片眼鏡"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunelensi eyodwa"),
            keywords: &["nuka", "ubuso obunelensi eyodwa"],
        },
    ],
};
