#[doc = "😕"]
pub const CONFUSED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😕",
    codepoint: "1F615",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "confused face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("verwarde gesig"),
            keywords: &["gesig", "verward", "verwarde gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግራ የተጋባ ፊት"),
            keywords: &["ግራ የተጋባ", "ግራ የተጋባ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه حائر"),
            keywords: &["حيرة", "وجه", "وجه حائر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিভ\u{9cd}ৰ\u{9be}ন\u{9cd}ত ম\u{9c1}খ"),
            keywords: &["বিভ\u{9cd}ৰ\u{9be}ন\u{9cd}ত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çaşqın üz"),
            keywords: &["çaşqın", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("разгублены твар"),
            keywords: &[
                "азадачаны",
                "збіты з панталыку",
                "разгублены",
                "разгублены твар",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Объркано лице"),
            keywords: &["Объркано лице", "лице", "объркан"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিভ\u{9cd}র\u{9be}ন\u{9cd}ত ম\u{9c1}খ"),
            keywords: &["বিভ\u{9cd}র\u{9be}ন\u{9cd}ত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zbunjenost"),
            keywords: &["lice", "zbunjen", "zbunjenost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de confusió"),
            keywords: &["cara", "cara de confusió", "confosa", "confusió", "confós"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏎᎩᏲᏤᎸᎢ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏎᎩᏲᏤᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zmatený obličej"),
            keywords: &["smajlík", "tvář", "výraz", "zmatený", "zmatený obličej"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb cymysglyd"),
            keywords: &["cymysglyd", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("forvirret ansigt"),
            keywords: &["ansigt", "forvirret ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("verwundertes Gesicht"),
            keywords: &["Gesicht", "verwundert", "verwundertes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύγχυση"),
            keywords: &["πρόσωπο", "στοχαστικός", "σύγχυση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("confused face"),
            keywords: &["confused", "face", "meh"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de confusión"),
            keywords: &["cara", "cara de confusión", "confuso"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "cara de confusión",
                "confundido",
                "confusión",
                "triste",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("segaduses nägu"),
            keywords: &["nägu", "segaduses"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("nahasketa-aurpegia"),
            keywords: &["aurpegi", "nahasketa-aurpegia", "nahastuta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گیج\u{200c}شده"),
            keywords: &["صورت", "مغشوش", "گیج", "گیج\u{200c}شده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hämmentynyt"),
            keywords: &["häkeltynyt", "hämmennys", "hämmentynyt", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nalilito"),
            keywords: &["lito", "mukha", "nalilito"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("forvirra andlit"),
            keywords: &["andlit", "forvirra", "ørviti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage confus"),
            keywords: &["confus", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog mhearaithe"),
            keywords: &["measctha", "straoiseog mhearaithe", "trína chéile"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann tro chèile"),
            keywords: &["aodann", "aodann tro chèile", "tro chèile"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara confusa"),
            keywords: &["cara", "confusa", "confusión", "confuso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac2}\u{a82}ઝાય\u{ac7}લ ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "મ\u{ac2}\u{a82}ઝાય\u{ac7}લ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rikitacciyar fuska"),
            keywords: &["fuska", "rikitacce", "rikitacciyar fuska"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מבולבל"),
            keywords: &["מבולבל", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पर\u{947}शान च\u{947}हरा"),
            keywords: &[
                "असम\u{902}जस म\u{947}\u{902}",
                "च\u{947}हरा",
                "पर\u{947}शान च\u{947}हरा",
                "भ\u{94d}रमित च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zbunjeno lice"),
            keywords: &["lice", "zbunjeno lice", "zbunjenost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zavart arc"),
            keywords: &["arc", "zavart"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շփոթված դեմք"),
            keywords: &["դեմք", "շփոթված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah bingung"),
            keywords: &["bingung", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu mgbagwoju anya"),
            keywords: &["ihu", "ihu mgbagwoju anya", "mgbagwoju anya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ruglingslegt andlit"),
            keywords: &["andlit", "ringlað andlit", "ringlun", "ruglingslegt andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina confusa"),
            keywords: &["confusa", "faccina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("混乱"),
            keywords: &["困惑", "混乱", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai bingung"),
            keywords: &["bingung", "owalah", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაბნეული სახე"),
            keywords: &["დაბნეული", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("абдырау"),
            keywords: &["абдырау", "бет"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("forvirret ansigt"),
            keywords: &["ansigt", "forvirret ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខឆ\u{17d2}ងល\u{17cb}អ\u{17d2}វ\u{17b8}ម\u{17bd}យ"),
            keywords: &[
                "ឆ\u{17d2}ងល\u{17cb}",
                "ម\u{17bb}ខឆ\u{17d2}ងល\u{17cb}អ\u{17d2}វ\u{17b8}ម\u{17bd}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗೊಂದಲದ ಮುಖ"),
            keywords: &["ಗೊಂದಲಗೊಂಡ\u{cbf}ರುವುದು", "ಗೊಂದಲದ ಮುಖ", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("혼란스러워하는 얼굴"),
            keywords: &["얼굴", "헷갈림", "혼란스러워하는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गो\u{902}दळिल\u{94d}लो च\u{947}रो"),
            keywords: &["गो\u{902}दळिल\u{94d}लो", "च\u{947}रो", "म\u{947}ह"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башы маң болгон бет"),
            keywords: &["башы маң болгон бет", "бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("konfus"),
            keywords: &["Gesiicht", "konfus"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າສ\u{eb1}ບສ\u{ebb}ນ"),
            keywords: &[
                "ສ\u{eb1}ບສ\u{ebb}ນ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າສ\u{eb1}ບສ\u{ebb}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sutrikęs veidas"),
            keywords: &["sutrikęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("apjukusi seja"),
            keywords: &["apjucis", "apjukums", "apjukusi seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi pōraru"),
            keywords: &["kanohi", "pōraru"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("збунето лице"),
            keywords: &["збунето", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആശയക\u{d4d}ക\u{d41}ഴപ\u{d4d}പമ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "ആശയക\u{d4d}ക\u{d41}ഴപ\u{d4d}പം",
                "ആശയക\u{d4d}ക\u{d41}ഴപ\u{d4d}പമ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эргэлзсэн царай"),
            keywords: &["царай", "эргэлзсэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("गो\u{902}धळल\u{947}ला च\u{947}हरा"),
            keywords: &["गो\u{902}धळल\u{947}ला", "च\u{947}हरा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka keliru"),
            keywords: &["keliru", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ konfuż"),
            keywords: &["konfuż", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဇဝေဇဝါဖြစ\u{103a}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ဇဝေဇဝါဖြစ\u{103a}",
                "ဇဝေဇဝါဖြစ\u{103a}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("forvirret"),
            keywords: &["fjes", "forvirret"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दोधारय\u{941}क\u{94d}त अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "दोधारय\u{941}क\u{94d}त"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("verward gezicht"),
            keywords: &["gezicht", "verward"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("forvirra"),
            keywords: &["fjes", "forvirra"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଚଳ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ବ\u{b3f}ଚଳ\u{b3f}ତ", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉਲਝਣ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &["ਉਲਝਣ ਵਾਲਾ ਚਿਹਰਾ", "ਉਲਝਿਆ", "ਉਲਝਿਆ ਚਿਹਹਾ", "ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("متذبذب شکل"),
            keywords: &["دی شکل", "متذبذب", "متذبذب شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Nọ\u{301} Nó Wétín I Go Du"),
            keywords: &[
                "A Dọn Kiá Fes",
                "Fes",
                "Fes Wé Nọ\u{301} Nó Wétín I Go Du",
                "Kọnfiuz",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zdezorientowana twarz"),
            keywords: &["zakłopotana buźka", "zdezorientowana twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وارخطا مخ"),
            keywords: &["مخ", "وارخطا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto confuso"),
            keywords: &["confuso", "indeciso", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara confusa"),
            keywords: &["cara", "cara confusa", "confuso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chaqrusqa uya"),
            keywords: &["chaqrusqa uya", "eh", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față confuză"),
            keywords: &["confuzie", "față", "față confuză", "neînțelegere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-857"),
            keywords: &["E10-857"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в замешательстве"),
            keywords: &[
                "в замешательстве",
                "замешательство",
                "конфуз",
                "лицо",
                "стеснение",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yashobewe"),
            keywords: &["isura", "yashobewe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("الجهيل چهرو"),
            keywords: &["الجهيل چهرو", "الجھيل", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dca}\u{200d}ය\u{dcf}ක\u{dd6}ල ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dca}\u{200d}ය\u{dcf}ක\u{dd6}ල",
                "ව\u{dca}\u{200d}ය\u{dcf}ක\u{dd6}ල ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zmätená tvár"),
            keywords: &["neviem", "tvár", "zmätená", "zmätok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zmeden obraz"),
            keywords: &["obraz", "zmeden obraz", "zmedeno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji jah wareersan"),
            keywords: &["amkaag", "jah wareersan", "waji", "waji jah wareersan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e hutuar"),
            keywords: &["e hutuar", "fytyrë", "fytyrë e hutuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("збуњено лице"),
            keywords: &["збуњeнoст", "збуњено лице", "лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zbunjeno lice"),
            keywords: &["lice", "zbunjeno lice", "zbunjenost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("förbryllat ansikte"),
            keywords: &["förbryllad", "förbryllat ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliochanganyikiwa"),
            keywords: &["kuchanganyikiwa", "uso", "uso uliochanganyikiwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குழம\u{bcd}பிய முகம\u{bcd}"),
            keywords: &[
                "குழப\u{bcd}பம\u{bbe}ன முகம\u{bcd}",
                "குழப\u{bcd}பம\u{bcd}",
                "குழம\u{bcd}பிய முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గందరగ\u{c4b}ళంగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "అర\u{c4d}థం",
                "గందరగ\u{c4b}ళంగ\u{c3e} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи ошуфта"),
            keywords: &["ошуфта", "рӯи ошуфта", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าส\u{e31}บสน"),
            keywords: &["ส\u{e31}บสน", "หน\u{e49}า", "หน\u{e49}าส\u{e31}บสน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("başy çaşan ýüz"),
            keywords: &["başy çaşan", "başy çaşan ýüz", "sähne", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata puputuʻu"),
            keywords: &["mata puputuʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kafası karışık yüz"),
            keywords: &["kafası karışmış", "kafası karışık yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھاڭۋاققان چىراي"),
            keywords: &["چىراي", "ھاڭۋاققان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("спантеличене обличчя"),
            keywords: &["обличчя", "спантеличене обличчя", "спантеличений"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("الجھن زدہ چہرہ"),
            keywords: &["الجھن زدہ چہرہ", "چہرہ", "کنفیوز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xijolat bo‘lgan yuz"),
            keywords: &["xijolat", "xijolat bo‘lgan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt bối rối"),
            keywords: &["bối rối", "mặt", "mặt bối rối"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu jaaxasoo"),
            keywords: &["jaaxasoo", "kanam", "kanam gu jaaxasoo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuxakiweyo"),
            keywords: &["ubuso", "ubuso obuxakiweyo", "xakiweyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Iporuru"),
            keywords: &["Oju Iporuru", "iporuru", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("迷茫嘅臉"),
            keywords: &["臉", "迷茫", "迷茫嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("迷茫嘅脸"),
            keywords: &["脸", "迷茫", "迷茫嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("困扰"),
            keywords: &["不懂", "困惑", "困扰", "疑惑", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("困擾"),
            keywords: &["困擾", "面有難色"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("困擾"),
            keywords: &["困擾", "面有難色"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obudidekile"),
            keywords: &["ubuso", "ubuso obudidekile", "ukudideka"],
        },
    ],
};
#[doc = "😟"]
pub const WORRIED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😟",
    codepoint: "1F61F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "worried face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bekommerde gesig"),
            keywords: &["bekommerd", "bekommerde gesig", "gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጨነቀ ፊት"),
            keywords: &["የተጨነቀ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه قلق"),
            keywords: &["وجه قلق", "وجه منزعج"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিন\u{9cd}তিত ম\u{9c1}খ"),
            keywords: &["চিন\u{9cd}তিত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("narahat üz"),
            keywords: &["narahat", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("занепакоены твар"),
            keywords: &["занепакоены", "занепакоены твар", "устрывожаны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Разтревожено лице"),
            keywords: &["Разтревожено лице", "лице", "разтревожен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিন\u{9cd}তিত ম\u{9c1}খ"),
            keywords: &[
                "উদ\u{9cd}বিগ\u{9cd}ন",
                "চিন\u{9cd}তিত ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zabrinutost"),
            keywords: &["lice", "zabrinutost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de preocupació"),
            keywords: &[
                "cara",
                "cara de preocupació",
                "preocupació",
                "preocupada",
                "preocupat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏪᎵᎯᏍᎩ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏪᎵᎯᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ustaraný obličej"),
            keywords: &[
                "obavy",
                "smajlík",
                "starost",
                "tvář",
                "ustaraný obličej",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gofidio"),
            keywords: &["gofid", "wyneb", "wyneb gofidio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bekymret ansigt"),
            keywords: &["ansigt", "bekymret", "bekymring"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("besorgtes Gesicht"),
            keywords: &["Gesicht", "besorgt", "besorgtes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανησυχία"),
            keywords: &["ανήσυχος", "ανησυχία", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("worried face"),
            keywords: &["face", "worried"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara preocupada"),
            keywords: &["cara", "cara preocupada", "preocupación", "preocupado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de preocupación"),
            keywords: &["cara", "cara de preocupación", "preocupado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara preocupada"),
            keywords: &["cara", "cara preocupada", "preocupado"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("murelik nägu"),
            keywords: &["murelik", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi kezkatua"),
            keywords: &["aurpegi", "aurpegi kezkatua", "kezkatu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نگران"),
            keywords: &["آشوب", "صورت", "نگران"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("huolestunut"),
            keywords: &["huolestunut", "huoli", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nag-aalala"),
            keywords: &["balisa", "mukha", "nag-aalala"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("stúrt andlit"),
            keywords: &["andlit", "bangin", "stúrin", "stúrt andlit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage inquiet"),
            keywords: &["inquiet", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog imníoch"),
            keywords: &["imní", "straoiseog imníoch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann fo dhragh"),
            keywords: &["aodann", "aodann fo dhragh", "dragh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de preocupación"),
            keywords: &["cara de preocupación", "preocupado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચિ\u{a82}તાગ\u{acd}રસ\u{acd}ત ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "ચિ\u{a82}તાગ\u{acd}રસ\u{acd}ત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai damuwa"),
            keywords: &["fuska", "fuska mai damuwa", "mai damuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מודאג"),
            keywords: &["מודאג", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("चि\u{902}तित च\u{947}हरा"),
            keywords: &["चि\u{902}तित", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zabrinuto lice"),
            keywords: &["briga", "lice", "zabrinuto lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("aggódó arc"),
            keywords: &["aggodalmas", "aggódó arc", "arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մտահոգ դեմք"),
            keywords: &["անհանգստացած", "դեմք", "մտահոգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah cemas"),
            keywords: &["cemas", "khawatir", "kuatir", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere nchekasị ahụ"),
            keywords: &["ihu", "ihu nwere nchekasị ahụ", "nwere nchekasị ahụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("áhyggjufullt andlit"),
            keywords: &["andlit", "áhyggjufullt andlit", "áhyggjur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina preoccupata"),
            keywords: &[
                "faccina",
                "faccina preoccupata",
                "preoccupazione preoccupata",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("悩む顔"),
            keywords: &["心配", "悩む顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kuwatir"),
            keywords: &["kuwatir", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აღელვებული სახე"),
            keywords: &["აღელვებული", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("уайымдау"),
            keywords: &["бет", "уайымдау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bekymret ansigt"),
            keywords: &["ansigt", "bekymret", "bekymring"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខព\u{17d2}រ\u{17bd}យបារម\u{17d2}ភ"),
            keywords: &[
                "ខ\u{17d2}វល\u{17cb}ច\u{17b7}ត\u{17d2}ត",
                "ព\u{17d2}រ\u{17bd}យច\u{17b7}ត\u{17d2}ត",
                "ព\u{17d2}រ\u{17bd}យបារម\u{17d2}ហ",
                "ម\u{17bb}ខព\u{17d2}រ\u{17bd}យបារម\u{17d2}ភ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚ\u{cbf}ಂತ\u{cc6}ಯ ಮುಖ"),
            keywords: &["ಚ\u{cbf}ಂತ\u{cc6} ಮುಖ", "ಚ\u{cbf}ಂತ\u{cc6}ಯ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("걱정스러운 얼굴"),
            keywords: &["걱정", "걱정스러운 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ह\u{941}स\u{94d}को लागिल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "ह\u{941}स\u{94d}को करपी",
                "ह\u{941}स\u{94d}को लागिल\u{94d}लो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тынчсызданган бет"),
            keywords: &["бет", "тынчсызданган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("beonrouegt"),
            keywords: &["Gesiicht", "beonrouegt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າກ\u{eb1}ງວ\u{ebb}ນ"),
            keywords: &[
                "ກ\u{eb1}ງວ\u{ebb}ນ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າກ\u{eb1}ງວ\u{ebb}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susirūpinęs veidas"),
            keywords: &["susirūpinęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("noraizējusies seja"),
            keywords: &["noraizējies", "noraizējusies seja", "rūpes", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi āwangawanga"),
            keywords: &["kanohi", "āwangawanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("загрижено лице"),
            keywords: &["загрижено", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആക\u{d41}ലമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "ആക\u{d41}ലത",
                "ആക\u{d41}ലമ\u{d3e}യ മ\u{d41}ഖം",
                "ആശങ\u{d4d}ക",
                "പരിഭ\u{d4d}ര\u{d3e}ന\u{d4d}തി",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("санаа зовсон царай"),
            keywords: &["санаа зовсон", "санаа зовсон царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चि\u{902}ताग\u{94d}रस\u{94d}त च\u{947}हरा"),
            keywords: &[
                "चि\u{902}ता",
                "चि\u{902}ताग\u{94d}रस\u{94d}त च\u{947}हरा",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka risau"),
            keywords: &["muka", "risau"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ inkwetat"),
            keywords: &["inkwetat", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{102d}တ\u{103a}ပ\u{1030}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "စ\u{102d}တ\u{103a}ပ\u{1030}နေသော မျက\u{103a}န\u{103e}ာ",
                "ပ\u{1030}ပန\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bekymret"),
            keywords: &["bekymret", "fjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिन\u{94d}तित अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "चिन\u{94d}तित"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bezorgd gezicht"),
            keywords: &["bezorgd", "gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bekymra"),
            keywords: &["bekymra", "fjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ବ\u{b4d}ରତ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ବ\u{b3f}ବ\u{b4d}ରତ", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫਿਕਰਮ\u{a70}ਦ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਚਿ\u{a70}ਤਤ", "ਫਿਕਰਮ\u{a70}ਦ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پریشان ہوئی شکل"),
            keywords: &["دی شکل", "پریشان ہوئی شکل", "پریشان ہونا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Sọ\u{301}mtin De Wọ\u{301}ri"),
            keywords: &["Fes", "Fes Wé Sọ\u{301}mtin De Wọ\u{301}ri", "Wọ\u{301}ri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zmartwiona twarz"),
            keywords: &["zmartwiona buźka", "zmartwiona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اندېښمن مخ"),
            keywords: &["اندېښمن", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto preocupado"),
            keywords: &["rosto", "rosto preocupado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara preocupada"),
            keywords: &["cara", "cara preocupada", "preocupado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llakisqa uya"),
            keywords: &["llakisqa", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față îngrijorată"),
            keywords: &["față", "față îngrijorată", "îngrijorare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-867"),
            keywords: &["E10-867"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("беспокоится"),
            keywords: &[
                "беспокоится",
                "беспокойство",
                "лицо",
                "расстройство",
                "тревога",
                "тревожность",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura ihangayitse"),
            keywords: &["isura", "isura ihangayitse", "uhangayitse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پريشان چهرو"),
            keywords: &["پريشان", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කනග\u{dcf}ට\u{dd4}වට පත\u{dca} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කනග\u{dcf}ට\u{dd4}වට පත\u{dca}",
                "කනග\u{dcf}ට\u{dd4}වට පත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ustaraná tvár"),
            keywords: &["obavy", "tvár", "ustaraná"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zaskrbljen obraz"),
            keywords: &["obraz", "zaskrbljen obraz", "zaskrbljeno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji walaacsan"),
            keywords: &["waji", "walaacsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e shqetësuar"),
            keywords: &["e shqetësuar", "fytyrë", "fytyrë e shqetësuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("забринуто лице"),
            keywords: &["бригa", "забринуто лице", "лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["забринуто лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zabrinuto lice"),
            keywords: &["briga", "lice", "zabrinuto lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zabrinuto lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bekymrat ansikte"),
            keywords: &["bekymrad", "bekymrat ansikte", "orolig"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso ulio na wasiwasi"),
            keywords: &["uso", "uso ulio na wasiwasi", "wasiwasi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கவலை தோய\u{bcd}ந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "கவலை",
                "கவலை தோய\u{bcd}ந\u{bcd}த முகம\u{bcd}",
                "கவலைப\u{bcd}படுகிறேன\u{bcd}",
                "கவலைய\u{bbe}க உள\u{bcd}ளது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ద\u{c3f}గులుగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "ద\u{c3f}గులు",
                "ద\u{c3f}గులుగ\u{c3e} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи мушавваш"),
            keywords: &["мушавваш", "рӯи мушавваш", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าก\u{e31}งวล"),
            keywords: &["ก\u{e31}งวล", "หน\u{e49}า", "หน\u{e49}าก\u{e31}งวล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aladaly ýüz"),
            keywords: &["aladaly", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lotohohaʻa"),
            keywords: &["mata lotohohaʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("endişeli yüz"),
            keywords: &["endişeli yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەنسىز چىراي"),
            keywords: &["ئەنسىرەش", "ئەنسىز چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стурбоване обличчя"),
            keywords: &["обличчя", "стурбоване обличчя", "стурбований"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پریشان چہرہ"),
            keywords: &["پریشان", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xavotir olayotgan yuz"),
            keywords: &["xavotir", "xavotir olayotgan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt lo lắng"),
            keywords: &["lo lắng", "mặt", "mặt lo lắng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu jaaxle"),
            keywords: &["jaaxle", "kanam", "kanam gu jaaxle"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuxhalabileyo"),
            keywords: &["ubuso", "ubuso obuxhalabileyo", "xhalabile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Idamu"),
            keywords: &["Oju Idamu", "ojú", "ìdàmú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("擔心嘅臉"),
            keywords: &["擔心", "擔心嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("担心嘅脸"),
            keywords: &["担心", "担心嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("担心"),
            keywords: &["不高兴", "伤心", "担心", "担忧", "焦虑", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("擔心"),
            keywords: &["憂心忡忡", "擔心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("擔心"),
            keywords: &["憂心忡忡", "擔心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obukhathazekile"),
            keywords: &["ubuso", "ubuso obukhathazekile", "ukukhathazeka"],
        },
    ],
};
#[doc = "🙁"]
pub const SLIGHTLY_FROWNING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🙁",
    codepoint: "1F641",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "slightly frowning face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat effens frons"),
            keywords: &["frons", "gesig", "gesig wat effens frons"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በከፊል የተኮሳተረ ፊት"),
            keywords: &["በከፊል የተኮሳተረ ፊት", "የተኮሳተረ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه عابس قليلا\u{64b}"),
            keywords: &["عابس", "وجه", "وجه عابس قليلا\u{64b}"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9be}ম\u{9be}ন\u{9cd}য ভ\u{9cd}ৰ\u{9c1} উঠোৱ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ভ\u{9cd}ৰ\u{9c1} উঠোৱ\u{9be}",
                "ম\u{9c1}খ",
                "স\u{9be}ম\u{9be}ন\u{9cd}য ভ\u{9cd}ৰ\u{9c1} উঠোৱ\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bir az qaşqabaqlı üz"),
            keywords: &["bir az qaşqabaqlı üz", "qaşqabaqlı", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("злёгку засмучаны твар"),
            keywords: &["засмучэнне", "злёгку засмучаны твар", "нахмураны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Леко намръщено лице"),
            keywords: &["Леко намръщено лице", "гримаса", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}ম\u{9be}ন\u{9cd}য র\u{9be}গ\u{9be}ন\u{9cd}বিত ম\u{9c1}খ"),
            keywords: &[
                "ভ\u{9cd}র\u{9c2} ক\u{9c1}চ\u{981}ক\u{9be}নো",
                "ম\u{9c1}খ",
                "স\u{9be}ম\u{9be}ন\u{9cd}য র\u{9be}গ\u{9be}ন\u{9cd}বিত ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("diskretna namrštenost"),
            keywords: &["diskretna namrštenost", "lice", "mrštenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara una mica arrufada"),
            keywords: &[
                "cara",
                "cara una mica arrufada",
                "emmurriat",
                "empipat",
                "enfadat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏍᏗᎩᏓ ᎤᏓᏁᎪᏳᏒ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏓᏁᎪᏳ", "ᏍᏗᎩᏓ ᎤᏓᏁᎪᏳᏒ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mírně zamračený obličej"),
            keywords: &[
                "mírně zamračený obličej",
                "smajlík",
                "tvář",
                "výraz",
                "zamračení",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â pheth gwg arni"),
            keywords: &["cuchio", "gwg", "wyneb", "wyneb â pheth gwg arni"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lidt trist ansigt"),
            keywords: &["ansigt", "lidt trist ansigt", "trist"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("betrübtes Gesicht"),
            keywords: &["Gesicht", "betrübtes Gesicht", "traurig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ελαφρύ κατσούφιασμα"),
            keywords: &["ελαφρύ κατσούφιασμα", "κατσουφιασμένος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("slightly frowning face"),
            keywords: &["face", "frown", "slightly frowning face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con el ceño ligeramente fruncido"),
            keywords: &[
                "cara",
                "cara con el ceño ligeramente fruncido",
                "ceño",
                "fruncido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara con el ceño ligeramente fruncido", "triste"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("veidi kulmu kortsutav nägu"),
            keywords: &["kulmukortsutus", "nägu", "veidi kulmu kortsutav nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi apur bat kopetiluna"),
            keywords: &["aurpegi", "aurpegi apur bat kopetiluna", "kopetilun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دلخور"),
            keywords: &["اخم", "دلخور", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hieman surullinen"),
            keywords: &["hieman surullinen", "naama", "surullinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("medyo nakasimangot"),
            keywords: &["malungkot", "medyo nakasimangot", "mukha", "simangot"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eitt sindur illbrýnt andlit"),
            keywords: &[
                "andlit",
                "eitt sindur illbrýnt andlit",
                "harmur",
                "illbrýnt",
                "illfýsið",
                "keddur",
                "sorgarbundin",
                "óglaður",
                "ólukkulig",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage légèrement mécontent"),
            keywords: &["mécontent", "visage", "visage légèrement mécontent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le mionghrainc uirthi"),
            keywords: &["aghaidh", "grainc", "straoiseog le mionghrainc uirthi"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le fiamh drèin beag"),
            keywords: &["aodann", "aodann le fiamh drèin beag", "drèin"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara triste"),
            keywords: &["cara", "triste", "tristeza"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("થોડો ગમગીન ચહ\u{ac7}રો"),
            keywords: &[
                "ગમગીન",
                "ચહ\u{ac7}રો",
                "થોડો ગમગીન ચહ\u{ac7}રો",
                "મ\u{ac1}ખ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai gama gira kaɗan"),
            keywords: &["fuska", "fuska mai gama gira kaɗan", "gama gira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם מבט עצוב"),
            keywords: &["עצוב", "פרצוף", "פרצוף עם מבט עצוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कम क\u{94d}रोधित च\u{947}हरा"),
            keywords: &["कम क\u{94d}रोधित च\u{947}हरा", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("blago namrgođeno lice"),
            keywords: &["blago namrgođeno lice", "lice", "mrgođenje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kissé komor arc"),
            keywords: &["arc", "kissé komor arc", "rosszallás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թեթևակի խոժոռված դեմք"),
            keywords: &["դեմք", "թեթևակի խոժոռված դեմք", "խոժոռ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah agak cemberut"),
            keywords: &["cemberut", "muka", "wajah", "wajah agak cemberut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa obere mgbarụ ihu"),
            keywords: &["ihu", "mgbarụ", "nwa obere mgbarụ ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með litla skeifu"),
            keywords: &["andlit", "andlit með litla skeifu", "skeifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina leggermente imbronciata"),
            keywords: &[
                "corrucciato",
                "faccina",
                "faccina leggermente imbronciata",
                "imbronciato",
                "mettere il muso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("少し困った顔"),
            keywords: &["しかめ面", "困った", "少し困った", "少し困った顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai susah"),
            keywords: &["rai", "susah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოდნავ შეჭმუხნილი სახე"),
            keywords: &["ოდნავ შეჭმუხნილი სახე", "სახე", "შეკრული", "შეჭმუხნილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аздап тұнжырау"),
            keywords: &["аздап тұнжырау", "бет", "тұнжырау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lidt trist ansigt"),
            keywords: &["ansigt", "lidt trist ansigt", "trist"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17d2}រម\u{17c9}\u{17bc}វបន\u{17d2}ត\u{17b7}ច"),
            keywords: &[
                "ក\u{17d2}រម\u{17c9}\u{17bc}វ",
                "ពេបមាត\u{17cb}",
                "ម\u{17bb}ខក\u{17d2}រម\u{17c9}\u{17bc}វបន\u{17d2}ត\u{17b7}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ವಲ\u{ccd}ಪ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ",
                "ಸ\u{ccd}ವಲ\u{ccd}ಪ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("살짝 찡그린 얼굴"),
            keywords: &["살짝 찡그린 얼굴", "얼굴", "찡그림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मात\u{94d}सो तिडकल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "तिडक",
                "मात\u{94d}सो तिडकल\u{94d}लो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ээгин бир аз кемшийткен"),
            keywords: &["бет", "бир аз", "кемшийт", "ээгин бир аз кемшийткен", "ээк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("d’Stir liicht fronzend"),
            keywords: &["Gesiicht", "Stir fronzen", "d’Stir liicht fronzend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງເລ\u{eb1}ກນ\u{ec9}ອຍ"),
            keywords: &[
                "ບ\u{eb6}\u{ec9}ງ",
                "ຫຍ\u{eb8}\u{ec9}ງ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງເລ\u{eb1}ກນ\u{ec9}ອຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šiek tiek paniuręs veidas"),
            keywords: &["paniuręs", "veidas", "šiek tiek paniuręs veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nedaudz bēdīga seja"),
            keywords: &["bēdas", "bēdīgs", "nedaudz bēdīga seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi āhua poururu"),
            keywords: &["kanohi", "kanohi āhua poururu", "poururu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("малку намуртено лице"),
            keywords: &["лице", "малку намуртено лице", "намуртено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ക\u{d41}റച\u{d4d}ച\u{d4d} നീരസഭ\u{d3e}വത\u{d4d}തില\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
            ),
            keywords: &[
                "ക\u{d41}റച\u{d4d}ച\u{d4d} നീരസഭ\u{d3e}വത\u{d4d}തില\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "നീരസം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бага зэрэг барайсан царай"),
            keywords: &[
                "бага зэрэг",
                "бага зэрэг барайсан царай",
                "барайсан",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("\u{200d}कि\u{902}चित नापस\u{902}ती व\u{94d}यक\u{94d}त करणारा च\u{947}हरा"),
            keywords: &[
                "आठ\u{94d}या",
                "च\u{947}हरा",
                "\u{200d}कि\u{902}चित नापस\u{902}ती व\u{94d}यक\u{94d}त करणारा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka berkerut sedikit"),
            keywords: &["berkerut", "muka", "muka berkerut sedikit"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imkemmex ftit"),
            keywords: &["imkemmex", "wiċċ", "wiċċ imkemmex ftit"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အနည\u{103a}းငယ\u{103a} မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}ထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "ဝမ\u{103a}းနည\u{103a}း",
                "အနည\u{103a}းငယ\u{103a} မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}ထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "အနည\u{103a}းငယ\u{103a}ဝမ\u{103a}းနည\u{103a}းသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("litt surt fjes"),
            keywords: &["fjes", "litt surt fjes", "trist"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हल\u{94d}का रिसाएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "रिसाएको",
                "हल\u{94d}का रिसाएको अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("licht fronsend gezicht"),
            keywords: &["frons", "fronsend", "gezicht", "licht fronsend gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("litt surt fjes"),
            keywords: &["fjes", "litt surt fjes", "trist"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଟ\u{b3f}କେ ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଟ\u{b3f}କେ ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a4b}ੜ\u{a4d}ਹਾ ਜਿਹਾ ਨਰਾਜ\u{a3c} ਚਿਹਰਾ"),
            keywords: &[
                "ਉਦਾਸ ਚਿਹਰਾ",
                "ਉਦਾਸ ਹ\u{a4b}ਣਾ",
                "ਚਿਹਰਾ",
                "ਥ\u{a4b}ੜ\u{a4d}ਹਾ ਜਿਹਾ ਨਰਾਜ\u{a3c} ਚਿਹਰਾ",
                "ਮ\u{a71}ਥ\u{a47} ਵ\u{a71}ਟ ਪਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہلکی تیوری آلی شکل"),
            keywords: &["تیوری چڑھونا", "دی شکل", "ہلکی تیوری آلی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Fraún Smọ\u{301}l Smọl"),
            keywords: &["Fes", "Fes Wé De Fraún Smọ\u{301}l Smọl", "Fraun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lekko zachmurzona twarz"),
            keywords: &["grymas", "lekko zachmurzona twarz", "niezadowolenie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د لږ تريو تندي مخ"),
            keywords: &["تريو تندې", "د لږ تريو تندي مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto meio triste"),
            keywords: &["rosto", "rosto meio triste", "tristinho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara ligeiramente franzida"),
            keywords: &[
                "cara",
                "cara ligeiramente franzida",
                "sobrolho menos franzido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pisi llakisqa uya"),
            keywords: &["llaki", "pisi llakisqa uya", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față ușor tristă"),
            keywords: &[
                "față",
                "față ușor tristă",
                "față ușor încruntată",
                "tristețe",
                "încruntare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-901"),
            keywords: &["E10-901"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("немного грустит"),
            keywords: &[
                "лицо",
                "недовольный",
                "немного грустит",
                "немного грустное лицо",
                "плохо",
                "хмурый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura itishimye bitari cyane"),
            keywords: &["isura", "isura itishimye bitari cyane", "kwirakaza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هلڪو لٿل چهرو"),
            keywords: &["لٿل", "هلڪو لٿل چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මදක\u{dca} රවන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "මදක\u{dca} රවන ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "රැව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("trochu zamračená tvár"),
            keywords: &["trochu zamračená tvár", "tvár", "zamračená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nekoliko namrščen obraz"),
            keywords: &["mrščenje", "nekoliko namrščen obraz", "obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji yara macbuusan"),
            keywords: &["macbuus", "waji", "waji yara macbuusan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë pak e vrenjtur"),
            keywords: &["e vrenjtur", "fytyrë", "fytyrë pak e vrenjtur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које се благо мршти"),
            keywords: &["лице", "лице које се благо мршти", "мрштење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje se blago mršti"),
            keywords: &["lice", "lice koje se blago mršti", "mrštenje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med lite sur mun"),
            keywords: &["ansikte", "ansikte med lite sur mun", "sur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso ulionuna kiasi"),
            keywords: &["kununa", "uso", "uso ulionuna kiasi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லேச\u{bbe}க வருத\u{bcd}தம\u{bbe}க இருக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "லேச\u{bbe}க வருத\u{bcd}தம\u{bbe}க இருக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "லேச\u{bbe}ன வருத\u{bcd}தம\u{bcd}",
                "வருத\u{bcd}தம\u{bbe}ன முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4a}ంచ\u{c46}ం క\u{c4b}పంగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "క\u{c4a}ంచ\u{c46} క\u{c4b}పం",
                "క\u{c4a}ంచ\u{c46}ం క\u{c4b}పంగ\u{c3e} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи каме қавоқандохта"),
            keywords: &["рӯи каме қавоқандохта", "рӯй", "қавоқ андохтан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าบ\u{e36}\u{e49}งเล\u{e47}กน\u{e49}อย"),
            keywords: &[
                "บ\u{e36}\u{e49}ง",
                "หน\u{e49}า",
                "หน\u{e49}าบ\u{e36}\u{e49}งเล\u{e47}กน\u{e49}อย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çalaja çytyk ýüz"),
            keywords: &["çalaja çytyk ýüz", "çytylmak", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata kiʻi fingo"),
            keywords: &["mata kiʻi fingo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("biraz asık surat"),
            keywords: &["asık surat", "biraz asık surat", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سەل قوشۇمىلىق چىراي"),
            keywords: &["سەل قوشۇمىلىق چىراي", "قوشۇما", "كۆز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("трохи похмуре обличчя"),
            keywords: &["нахмурений", "обличчя", "сумний", "трохи похмуре обличчя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہلکا سا تیوری زدہ چہرہ"),
            keywords: &["تیوری", "چہرہ", "ہلکا سا تیوری زدہ چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ozroq arazlagan yuz"),
            keywords: &["arazlamoq", "ozroq arazlagan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt hơi cau mày"),
            keywords: &["cau mày", "mặt", "mặt hơi cau mày"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu ànd ak yéen yu xawa lemu"),
            keywords: &["aj-yéen", "kanam", "kanam gu ànd ak yéen yu xawa lemu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obujayileyo kancinane"),
            keywords: &["ubuso", "ubuso obujayileyo kancinane", "ukufinga iintshiya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ifajuro Diẹ"),
            keywords: &["Oju Ifajuro Diẹ", "fajúro", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("少少皺眉嘅臉"),
            keywords: &["少少皺眉嘅臉", "皺眉嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("少少皱眉嘅脸"),
            keywords: &["少少皱眉嘅脸", "皱眉嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("微微不满"),
            keywords: &["不开心", "不高兴", "委屈", "微微不满", "心情不好", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("不開心"),
            keywords: &["不開心", "壞心情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("不開心"),
            keywords: &["不開心", "壞心情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obubipha kancane"),
            keywords: &["ubuso", "ubuso obubipha kancane", "ukubipha"],
        },
    ],
};
#[doc = "☹\u{fe0f}"]
pub const FROWNING_FACE: crate::Emoji = crate::Emoji {
    glyph: "☹\u{fe0f}",
    codepoint: "2639 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "frowning face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☹",
        codepoint: "2639",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "frowning face",
        group: "Smileys & Emotion",
        subgroup: "face-concerned",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat frons"),
            keywords: &["frons", "gesig", "gesig wat frons"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተኮሳተረ ፊት"),
            keywords: &["የተኮሳተረ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه عابس"),
            keywords: &["عبوس", "وجه", "وجه عابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9cd}ৰ\u{9c1} উঠোৱ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "ভ\u{9cd}ৰ\u{9c1} উঠোৱ\u{9be}",
                "ভ\u{9cd}ৰ\u{9c1} উঠোৱ\u{9be} ম\u{9c1}খ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaşqabaqlı üz"),
            keywords: &["qaşqabaqlı", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("засмучаны твар"),
            keywords: &["засмучаны твар", "засмучэнне", "нахмураны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Намръщено лице"),
            keywords: &["Намръщено лице", "гримаса", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}গ\u{9be}ন\u{9cd}বিত ম\u{9c1}খ"),
            keywords: &[
                "ভ\u{9cd}র\u{9c2} ক\u{9c1}চ\u{981}ক\u{9be}নো",
                "ম\u{9c1}খ",
                "র\u{9be}গ\u{9be}ন\u{9cd}বিত ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("namrštenost"),
            keywords: &["lice", "mrštenje", "namrštenost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara arrufada"),
            keywords: &["cara", "cara arrufada", "emmurriat", "empipat", "enfadat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᏁᎪᏳ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏓᏁᎪᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamračený obličej"),
            keywords: &["smajlík", "tvář", "výraz", "zamračení", "zamračený obličej"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gwgus"),
            keywords: &["cuchio", "gwg", "wyneb", "wyneb gwgus"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("trist ansigt"),
            keywords: &["ansigt", "trist"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("düsteres Gesicht"),
            keywords: &["Gesicht", "düsteres Gesicht", "traurig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσούφιασμα"),
            keywords: &["κατσουφιασμένος", "κατσούφιασμα", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("frowning face"),
            keywords: &["face", "frown", "frowning face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con el ceño fruncido"),
            keywords: &["cara", "cara con el ceño fruncido", "ceño", "fruncido"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara con el ceño fruncido", "triste"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kulmu kortsutav nägu"),
            keywords: &["kulmu kortsutav nägu", "kulmukortsutus", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopeta ilunduta duen aurpegia"),
            keywords: &["aurpegi", "kopeta ilunduta duen aurpegia", "kopetilun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اخمو"),
            keywords: &["اخم", "اخمو", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("surullinen"),
            keywords: &["naama", "suru", "surullinen", "tuomitseva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakasimangot"),
            keywords: &["malungkot", "mukha", "nakasimangot", "simangot"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("illbrýnt andlit"),
            keywords: &[
                "andlit",
                "harmur",
                "illbrýnt",
                "illfýsið",
                "keddur",
                "sorgarbundin",
                "óglaður",
                "ólukkulig",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage mécontent"),
            keywords: &["mécontent", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le grainc uirthi"),
            keywords: &["aghaidh", "grainc", "straoiseog le grainc uirthi"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le fiamh drèin"),
            keywords: &["aodann", "aodann le fiamh drèin", "drèin"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara moi triste"),
            keywords: &["cara", "cara moi triste", "decepción", "triste", "tristeza"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગમગીન ચહ\u{ac7}રો"),
            keywords: &["ગમગીન", "ચહ\u{ac7}રો", "મ\u{ac1}ખ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai gama gira"),
            keywords: &["fuska", "fuska mai gama gira", "gama gira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עצוב"),
            keywords: &["עצוב", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अधिक क\u{94d}रोधित च\u{947}हरा"),
            keywords: &["अधिक क\u{94d}रोधित च\u{947}हरा", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("namrgođeno lice"),
            keywords: &["lice", "mrgođenje", "namrgođeno lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rosszalló arc"),
            keywords: &["arc", "rosszallás", "rosszalló arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոժոռված դեմք"),
            keywords: &["դեմք", "խոժոռ", "խոժոռված դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah cemberut"),
            keywords: &["cemberut", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-agbarụ ihu"),
            keywords: &["ihu", "mgbarụ", "na-agbarụ ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með stóra skeifu"),
            keywords: &["andlit", "andlit með stóra skeifu", "skeifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina imbronciata"),
            keywords: &[
                "corrucciato",
                "faccina",
                "faccina imbronciata",
                "imbronciato",
                "mettere il muso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("困った顔"),
            keywords: &["しかめ面", "困った", "困った顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai nelangsa"),
            keywords: &["nelangsa", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჭმუხნილი სახე"),
            keywords: &["სახე", "შეკრული", "შეჭმუხნილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem amiglaz"),
            keywords: &["udem amiglaz"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тұнжырау"),
            keywords: &["бет", "тұнжырау", "тұнжыраған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("trist ansigt"),
            keywords: &["ansigt", "trist"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17d2}រម\u{17c9}\u{17bc}វ"),
            keywords: &[
                "ក\u{17d2}រម\u{17c9}\u{17bc}វ",
                "ពេបមាត\u{17cb}",
                "ម\u{17bb}ខក\u{17d2}រម\u{17c9}\u{17bc}វ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ",
                "ಮುಖ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("찡그린 얼굴"),
            keywords: &["얼굴", "찡그린 얼굴", "찡그림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तिडकल\u{94d}लो च\u{947}रो"),
            keywords: &["च\u{947}रो", "तिडक", "तिडकल\u{94d}लो च\u{947}रो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ээгин кемшийткен бет"),
            keywords: &["бет", "кемшийт", "ээгин кемшийткен бет", "ээк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("d’Stir fronzend"),
            keywords: &["Gesiicht", "Stir fronzen", "d’Stir fronzend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງ"),
            keywords: &[
                "ບ\u{eb6}\u{ec9}ງ",
                "ຫຍ\u{eb8}\u{ec9}ງ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paniuręs veidas"),
            keywords: &["paniuręs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bēdīga seja"),
            keywords: &["bēdas", "bēdīga seja", "bēdīgs", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi poururu"),
            keywords: &["kanohi", "poururu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("намуртено лице"),
            keywords: &["лице", "намуртено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീരസമ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "അസ\u{d4d}വസ\u{d4d}ഥത",
                "നീരസം",
                "നീരസമ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баргар царай"),
            keywords: &["баргар", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नापस\u{902}ती व\u{94d}यक\u{94d}त करणारा च\u{947}हरा"),
            keywords: &[
                "आठ\u{94d}या",
                "च\u{947}हरा",
                "नापस\u{902}ती व\u{94d}यक\u{94d}त करणारा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka berkerut"),
            keywords: &["berkerut", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imkemmex"),
            keywords: &["imkemmex", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}ထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}ထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဝမ\u{103a}းနည\u{103a}း",
                "ဝမ\u{103a}းနည\u{103a}းကြေက\u{103d}\u{1032}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("surt fjes"),
            keywords: &["fjes", "surt fjes", "trist"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{941}डिएको अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "क\u{941}डिएको अन\u{941}हार", "रिसाएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fronsend gezicht"),
            keywords: &["frons", "fronsend", "gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("surt fjes"),
            keywords: &["fjes", "surt fjes", "trist"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ",
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਰਾਜ\u{a3c} ਚਿਹਰਾ"),
            keywords: &[
                "ਉਦਾਸ ਚਿਹਰਾ",
                "ਉਦਾਸ ਹ\u{a4b}ਣਾ",
                "ਚਿਹਰਾ",
                "ਨਰਾਜ\u{a3c} ਚਿਹਰਾ",
                "ਮ\u{a71}ਥ\u{a47} ਵ\u{a71}ਟ ਪਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیوری آلی شکل"),
            keywords: &["تیوری آلی شکل", "تیوری چڑھونا", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Fraun"),
            keywords: &["Fes", "Fes Wé De Fraun", "Fraun"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zachmurzona twarz"),
            keywords: &["grymas", "niezadowolenie", "zachmurzona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تريو تندي مخ"),
            keywords: &["تريو تندې", "د تريو تندي مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto descontente"),
            keywords: &["descontente", "rosto", "rosto de desaprovação", "triste"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara franzida"),
            keywords: &["cara", "cara franzida", "sobrolho franzido"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sipʼusqa uya"),
            keywords: &["sipʼusqa uya", "sipʼuy", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față tristă"),
            keywords: &[
                "față",
                "față tristă",
                "față încruntată",
                "tristețe",
                "încruntare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-060"),
            keywords: &["E10-060"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("грустит"),
            keywords: &[
                "грустит",
                "грустное лицо",
                "грусть",
                "лицо",
                "печаль",
                "плохо",
                "хмурый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura irakaye"),
            keywords: &["isura", "isura irakaye", "kwirakaza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لٿل چهرو"),
            keywords: &["لٿل", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රවන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &["ම\u{dd4}හ\u{dd4}ණ", "රවන ම\u{dd4}හ\u{dd4}ණ", "රැව\u{dd3}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zamračená tvár"),
            keywords: &["tvár", "zamračená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("namrščen obraz"),
            keywords: &["mrščenje", "namrščen obraz", "obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji macbuus"),
            keywords: &["macbuus", "waji", "waji macbuusan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e vrenjtur"),
            keywords: &["e vrenjtur", "fytyrë", "fytyrë e vrenjtur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("намрштено лице"),
            keywords: &["лице", "мрштење", "намрштено лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("namršteno lice"),
            keywords: &["lice", "mrštenje", "namršteno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte med sur mun"),
            keywords: &["ansikte", "ansikte med sur mun", "sur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso ulionuna"),
            keywords: &["kununa", "uso", "uso ulionuna"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வருத\u{bcd}தம\u{bbe}க இருக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "முகம\u{bcd}",
                "முகம\u{bcd} சுளித\u{bcd}தல\u{bcd}",
                "வருத\u{bcd}தம\u{bbe}க இருக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "வருத\u{bcd}தம\u{bcd}",
                "வருந\u{bcd}தும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}పంగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &["క\u{c4b}పం", "క\u{c4b}పంగ\u{c3e} ఉన\u{c4d}న ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи қавоқандохта"),
            keywords: &["рӯи қавоқандохта", "рӯй", "қавоқ андохтан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าบ\u{e36}\u{e49}ง"),
            keywords: &[
                "บ\u{e36}\u{e49}ง",
                "หน\u{e49}า",
                "หน\u{e49}าบ\u{e36}\u{e49}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çytyk ýüz"),
            keywords: &["çytyk ýüz", "çytylmak", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fingo"),
            keywords: &["mata fingo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("asık surat"),
            keywords: &["asık", "asık surat", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشۇما تۈرگەن چىراي"),
            keywords: &["قوشۇما", "قوشۇما تۈرگەن چىراي", "كۆز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("похмуре обличчя"),
            keywords: &["обличчя", "похмуре обличчя", "сумний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیوری زدہ چہرہ"),
            keywords: &["تیوری", "تیوری زدہ چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("arazlagan yuz"),
            keywords: &["arazlagan yuz", "arazlamoq", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cau mày"),
            keywords: &["cau mày", "mặt", "mặt cau mày"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("aj-yéen kanam"),
            keywords: &["aj-yéen", "kanam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obufinge iintshiya"),
            keywords: &["ubuso", "ubuso obufinge iintshiya", "ukufinga iintshiya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú tó fajúro"),
            keywords: &["fajúro", "ojú", "ojú tó fajúro"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("皺眉嘅臉"),
            keywords: &["皺眉", "皺眉嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("皱眉嘅脸"),
            keywords: &["皱眉", "皱眉嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("不满"),
            keywords: &["不满", "不爽", "不高兴", "皱眉", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("不滿意"),
            keywords: &["不滿意", "不爽", "皺眉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("不滿意"),
            keywords: &["不滿意", "不爽", "皺眉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obubiphile"),
            keywords: &["bipha", "ubuso", "ubuso obubiphile"],
        },
    ],
};
#[doc = "😮"]
pub const FACE_WITH_OPEN_MOUTH: crate::Emoji = crate::Emoji {
    glyph: "😮",
    codepoint: "1F62E",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "face with open mouth",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met oop mond"),
            keywords: &["gesig", "gesig met oop mond", "mond", "oop", "simpatie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፍ የከፈተ ፊት"),
            keywords: &["ሐዘኔታ", "አፍ", "አፍ የከፈተ ፊት", "ክፍት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بفم مفتوح"),
            keywords: &["فم مفتوح", "وجه بفم مفتوح"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খোল\u{9be} ম\u{9c1}খৰ চেহেৰ\u{9be}"),
            keywords: &[
                "খোল\u{9be}",
                "খোল\u{9be} ম\u{9c1}খৰ চেহেৰ\u{9be}",
                "ম\u{9c1}খ",
                "সহ\u{9be}ন\u{9c1}ভ\u{9c2}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağzı açıq üz"),
            keywords: &["açıq", "ağzı açıq üz", "ağız", "simpatiya", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з адкрытым ротам"),
            keywords: &["адкрыты", "рот", "спачуванне", "твар з адкрытым ротам"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с отворена уста"),
            keywords: &[
                "Лице с отворена уста",
                "лице",
                "отворен",
                "съчувствие",
                "уста",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}\u{981} কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "খোল\u{9be}",
                "ঠো\u{981}ট",
                "ম\u{9c1}খ",
                "সহ\u{9be}ন\u{9c1}ভ\u{9c2}তি",
                "হ\u{9be}\u{981} কর\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zinuo"),
            keywords: &["lice", "usta", "zinuo", "šokiranost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb la boca oberta"),
            keywords: &["boca oberta", "cara", "cara amb la boca oberta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛ ᎤᏠᏯᏍᏗ ᎤᏔᏠᎬᎢ"),
            keywords: &["ᎠᎰᎵ", "ᎠᏍᏚᎢᏓ", "ᎤᎧᏛ", "ᎤᎧᏛ ᎤᏠᏯᏍᏗ ᎤᏔᏠᎬᎢ", "ᎤᏲ ᎠᏰᎸᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s otevřenou pusou"),
            keywords: &[
                "obličej s otevřenou pusou",
                "otevřený",
                "smajlík",
                "soucit",
                "tvář",
                "výraz",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â cheg agored"),
            keywords: &[
                "agored",
                "ceg",
                "cydymdeimlad",
                "wyneb",
                "wyneb â cheg agored",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med åben mund"),
            keywords: &["ansigt", "ansigt med åben mund"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gesicht mit offenem Mund"),
            keywords: &[
                "Gesicht",
                "Gesicht mit offenem Mund",
                "erstaunt",
                "offener Mund",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοικτό στόμα"),
            keywords: &["ανοικτό στόμα", "ανοιχτό", "πρόσωπο", "στόμα", "συμπόνια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face with open mouth"),
            keywords: &["face", "face with open mouth", "mouth", "open", "sympathy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con la boca abierta"),
            keywords: &["boca", "cara", "cara con la boca abierta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara con boca abierta"),
            keywords: &[
                "abierta",
                "boca",
                "cara",
                "cara con boca abierta",
                "empatía",
                "sorpresa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cara con boca abierta", "empatía", "sorpresa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara con la boca abierta"),
            keywords: &[
                "cara con boca abierta",
                "cara con la boca abierta",
                "empatía",
                "sorpresa",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud suuga nägu"),
            keywords: &[
                "avatud",
                "avatud suuga nägu",
                "kaastunne",
                "lahti",
                "nägu",
                "suu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ahoa irekita duen aurpegia"),
            keywords: &[
                "aho",
                "ahoa irekita duen aurpegia",
                "aurpegi",
                "ireki",
                "poza",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دهان باز از تعجب"),
            keywords: &[
                "باز",
                "تعجب",
                "دهان",
                "دهان باز از تعجب",
                "صورت",
                "غافلگیری",
                "همدردی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("yllättynyt"),
            keywords: &["auki", "empatia", "naama", "suu", "yllättynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakanganga"),
            keywords: &["bibig", "mukha", "nabigla", "nagulat", "nakanganga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit við opnum munni"),
            keywords: &["andlit", "andlit við opnum munni", "munn", "opin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage avec bouche ouverte"),
            keywords: &["surpris", "visage avec bouche ouverte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage épaté"),
            keywords: &["bouche ouverte", "compassion", "visage", "visage épaté"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le béal oscailte"),
            keywords: &["béal ar oscailt", "straoiseog le béal oscailte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le beul fosgailte"),
            keywords: &[
                "aodann",
                "aodann le beul fosgailte",
                "beul",
                "co-fhulangas",
                "fosgailte",
                "truaghas",
                "truas",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara coa boca aberta"),
            keywords: &["boca aberta", "cara", "cara coa boca aberta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}લ\u{acd}લા\u{a82} મો\u{a82}ઢાવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા\u{a82} મો\u{a82}ઢાવાળો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} મોઢ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
                "મો\u{a82}ઢ\u{ac1}\u{a82}",
                "સહાન\u{ac1}ભ\u{ac2}તિ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da baki a buɗe"),
            keywords: &[
                "a buɗe",
                "baki",
                "fuska",
                "fuska tare da baki a buɗe",
                "tausayi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם פה פתוח"),
            keywords: &["פה", "פרצוף", "פרצוף עם פה פתוח", "פתוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}ल\u{947} म\u{941}\u{901}ह वाला च\u{947}हरा"),
            keywords: &[
                "ख\u{941}ला म\u{941}\u{902}ह",
                "ख\u{941}ल\u{947} म\u{941}\u{901}ह वाला च\u{947}हरा",
                "च\u{947}हरा",
                "म\u{941}\u{902}ह",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice s otvorenim ustima"),
            keywords: &[
                "lice",
                "lice s otvorenim ustima",
                "otvoreno",
                "suosjećanje",
                "usta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arc nyitott szájjal"),
            keywords: &["arc", "arc nyitott szájjal", "csodálkozás", "nyitott száj"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց բերանով դեմք"),
            keywords: &["բաց", "բաց բերանով դեմք", "բերան", "դեմք", "համակրանք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah dengan mulut terbuka"),
            keywords: &[
                "muka",
                "mulut",
                "simpati",
                "terbuka",
                "wajah",
                "wajah dengan mulut terbuka",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere mmepe ọnụ"),
            keywords: &["ihu", "ihu nwere mmepe ọnụ", "mmepe", "obi ebere", "ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit með opinn munn"),
            keywords: &["andlit", "andlit með opinn munn", "munnur", "opinn munnur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina con bocca aperta"),
            keywords: &[
                "bocca",
                "faccina",
                "faccina con bocca aperta",
                "sorpreso",
                "stupito",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("口が開いた顔"),
            keywords: &["へー", "共感", "口が開いた顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mlongo"),
            keywords: &["cangkem", "menga", "rai", "rai mlongo", "simpati"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე ღია პირით"),
            keywords: &[
                "თანაგრძნობა",
                "პირი",
                "პირღია",
                "სახე",
                "სახე ღია პირით",
                "ღია",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("vennej"),
            keywords: &["vennej"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таңдану"),
            keywords: &["аузы ашылу", "аң-таң болу", "бет", "таңдану"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med åben mund"),
            keywords: &["ansigt", "ansigt med åben mund"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខច\u{17c6}ហមាត\u{17cb}បើកភ\u{17d2}នែក"),
            keywords: &[
                "ច\u{17c6}ហ",
                "បើកមាត\u{17cb}",
                "មាត\u{17cb}",
                "ម\u{17bb}ខច\u{17c6}ហមាត\u{17cb}បើកភ\u{17d2}នែក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cc6}ರ\u{cc6}ದ ಬಾಯ\u{cbf}ಯ ಮುಖ"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}ದ ಬಾಯ\u{cbf}ಯ ಮುಖ",
                "ತ\u{cc6}ರ\u{cc6}ದ\u{cbf}ರುವುದು",
                "ಬಾಯ\u{cbf}",
                "ಮುಖ",
                "ಸಹಾನುಭ\u{cc2}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("입벌린 얼굴"),
            keywords: &["얼굴", "입벌린 얼굴", "입벌림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उकत\u{94d}या तो\u{902}डाचो च\u{947}रो"),
            keywords: &[
                "उकत\u{947}\u{902}",
                "उकत\u{94d}या तो\u{902}डाचो च\u{947}रो",
                "च\u{947}रो",
                "तो\u{902}ड",
                "दया",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оозу ачылган бет"),
            keywords: &["ач", "бет", "жактыр", "ооз", "оозу ачылган бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat oppenem Mond"),
            keywords: &[
                "Gesiicht",
                "Gesiicht mat oppenem Mond",
                "Matgefill",
                "Mond",
                "oppen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າອ\u{ec9}າປາກ"),
            keywords: &["ຕ\u{ebb}ກໃຈ", "ປາກ", "ໜ\u{ec9}າ", "ໜ\u{ec9}າອ\u{ec9}າປາກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("išsižiojęs veidas"),
            keywords: &["atverta", "burna", "išsižiojęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar atvērtu muti"),
            keywords: &[
                "atvērts",
                "mute",
                "pārsteigt",
                "seja",
                "seja ar atvērtu muti",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi waha tuwhera"),
            keywords: &["aroha", "kanohi", "tuwhera", "waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со отворена уста"),
            keywords: &["лице", "лице со отворена уста", "отворена", "уста"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}റന\u{d4d}ന വ\u{d3e}യയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "ത\u{d41}റന\u{d4d}ന",
                "ത\u{d41}റന\u{d4d}ന വ\u{d3e}യയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
                "വ\u{d3e}യ",
                "സഹത\u{d3e}പം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цочирдсон царай"),
            keywords: &["царай", "цочирдох", "цочирдсон царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तो\u{902}ड उघडल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "उघड\u{947}",
                "उघड\u{947} तो\u{902}ड असल\u{947}ला च\u{947}हरा",
                "च\u{947}हरा",
                "तो\u{902}ड उघडल\u{947}ला च\u{947}हरा",
                "सहान\u{941}भ\u{942}ती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bermulut ternganga"),
            keywords: &[
                "muka",
                "muka bermulut ternganga",
                "mulut",
                "simpati",
                "ternganga",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’ħalq miftuħ"),
            keywords: &["miftuħ", "simpatiku", "wiċċ", "wiċċ b’ħalq miftuħ", "ħalq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ပါးစပ\u{103a}အဟောင\u{103a}းသားန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပါးစပ\u{103a}",
                "ပါးစပ\u{103a}အဟောင\u{103a}းသားန\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "သနား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("forbauset"),
            keywords: &["fjes", "forbauset", "åpen munn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला म\u{941}ख भएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ख\u{941}ला",
                "ख\u{941}ला म\u{941}ख भएको अन\u{941}हार",
                "म\u{941}ख",
                "सहान\u{941}भ\u{942}ति",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezicht met open mond"),
            keywords: &[
                "gezicht",
                "gezicht met open mond",
                "mond",
                "open",
                "sympathie",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("forbausa"),
            keywords: &["fjes", "forbausa", "open munn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖୋଲ\u{b3e} ପ\u{b3e}ଟ\u{b3f} ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଖୋଲ\u{b3e}",
                "ଖୋଲ\u{b3e} ପ\u{b3e}ଟ\u{b3f} ସହ ମ\u{b41}ହ\u{b01}",
                "ଖୋଲ\u{b3e} ପ\u{b3e}ଟ\u{b3f} ସହ\u{b3f}ତ ମ\u{b41}ହ\u{b01}",
                "ପ\u{b3e}ଟ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}",
                "ସହ\u{b3e}ନ\u{b41}ଭ\u{b42}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲਾ ਮ\u{a42}\u{a70}ਹ",
                "ਖ\u{a41}\u{a71}ਲਿਆ ਮ\u{a42}\u{a70}ਹ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਵਾਲਾ ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਮ\u{a42}\u{a70}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھلے منہ آلی شکل"),
            keywords: &["دی شکل", "منہ", "ک\u{64f}ھلا", "کھلے منہ آلی شکل", "ہمدردی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Gẹt Ópún Maut"),
            keywords: &["Fes", "Fes Wé Gẹt Ópún Maut", "Maut", "Píti", "Ópún"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z otwartymi ustami"),
            keywords: &[
                "twarz z otwartymi ustami",
                "zaskoczenie",
                "zaskoczona buźka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بېرته خولې مخ"),
            keywords: &["بيرته", "خوا خوږي", "خوله", "د بېرته خولې مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto com boca aberta"),
            keywords: &[
                "boca",
                "boca aberta",
                "empatia",
                "rosto",
                "rosto com boca aberta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com boca aberta"),
            keywords: &["aberta", "boca", "cara", "cara com boca aberta", "pena"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya kichasqa simiwan"),
            keywords: &["kichay", "kʼacha", "simi", "uya", "uya kichasqa simiwan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față cu gura deschisă"),
            keywords: &[
                "față",
                "față cu gura deschisă",
                "gură deschisă",
                "surpriză",
                "uimire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-882"),
            keywords: &["E10-882"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("удивление"),
            keywords: &["лицо", "открытый", "рот", "удивление"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza umunwa wasamye"),
            keywords: &[
                "gufungura",
                "impuhwe",
                "isura",
                "isura igaragaza umunwa wasamye",
                "umunwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کليل وات سان چهرو"),
            keywords: &["همدردي", "وات", "چهرو", "کليل", "کليل وات سان چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට ඇර\u{dd4}ණ ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කට",
                "කට ඇර\u{dd4}ණ ම\u{dd4}හ\u{dd4}ණ",
                "ද\u{dd4}ක",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}වෘත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár s otvorenými ústami"),
            keywords: &[
                "otvorené",
                "súcit",
                "tvár",
                "tvár s otvorenými ústami",
                "ústa",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z odprtimi usti"),
            keywords: &[
                "obraz",
                "obraz z odprtimi usti",
                "odprto",
                "sočutje",
                "usta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji af furan leh"),
            keywords: &["af", "furan", "naxariis", "waji", "waji af furan leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me gojën e hapur"),
            keywords: &[
                "e hapur",
                "fytyrë",
                "fytyrë me gojën e hapur",
                "gojë",
                "simpati",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са отвореним устима"),
            keywords: &[
                "oтвoрeнo",
                "изненађење",
                "лице",
                "лице са отвореним устима",
                "саосeћaњe",
                "уста",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са отвореним устима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa otvorenim ustima"),
            keywords: &[
                "iznenađenje",
                "lice",
                "lice sa otvorenim ustima",
                "otvoreno",
                "saosećanje",
                "usta",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa otvorenim ustima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("förvånat ansikte"),
            keywords: &["förvånad", "förvånat ansikte", "öppen mun"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye mdomo ulio wazi"),
            keywords: &[
                "funguliwa",
                "huruma",
                "mdomo",
                "uso",
                "uso wenye mdomo ulio wazi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திறந\u{bcd}த வ\u{bbe}யுடன\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அதிர\u{bcd}ச\u{bcd}சி",
                "அய\u{bcd}யோ",
                "திறந\u{bcd}த வ\u{bbe}யுடன\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}యం",
                "న\u{c4b}రు",
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо даҳони кушода"),
            keywords: &[
                "даҳон",
                "кушода",
                "рӯй",
                "рӯй бо даҳони кушода",
                "ҳусни таваҷҷуҳ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อ\u{e49}าปาก"),
            keywords: &["ตกใจ", "หน\u{e49}า", "อ\u{e49}าปาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk agyzly ýüz"),
            keywords: &["agyz", "açyk", "açyk agyzly ýüz", "duýgudaşlyk", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata moe ngutu fakamanga"),
            keywords: &["mata moe ngutu fakamanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağzı açık yüz"),
            keywords: &["ağzı açık", "ağzı açık yüz", "ağız", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزى ئوچۇق چىراي"),
            keywords: &[
                "ئاغزى ئوچۇق چىراي",
                "ئوچۇق",
                "ئىچ ئاغرىتىش",
                "ئېغىز",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя з відкритим ротом"),
            keywords: &[
                "відкритий",
                "здивоване обличчя з відкритим ротом",
                "обличчя",
                "обличчя з відкритим ротом",
                "рот",
                "співчуття",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلے منہ والا چہرہ"),
            keywords: &["منہ", "چہرہ", "کھلا ہوا", "کھلے منہ والا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zi katta ochiq yuz"),
            keywords: &[
                "hamdardlik",
                "ochiq",
                "og‘iz",
                "og‘zi katta ochiq yuz",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt có miệng há"),
            keywords: &["miệng", "mặt", "mặt có miệng há", "mở", "thông cảm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak gémiñ gu ubbeeku"),
            keywords: &[
                "gémmiñ",
                "kanam",
                "kanam ak gémiñ gu ubbeeku",
                "sympaty",
                "ubbeeku",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunomlomo ovulekileyo"),
            keywords: &[
                "ubuso",
                "ubuso obunomlomo ovulekileyo",
                "umlomo",
                "uvelwano",
                "vulekileyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Pẹlu Ẹnu Lila"),
            keywords: &["Oju Pẹlu Ẹnu Lila", "kẹ\u{301}dùn", "ojú", "ṣí", "ẹnu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("開口嘅臉"),
            keywords: &["同情", "嘴", "打開", "臉", "開口嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("开口嘅脸"),
            keywords: &["同情", "嘴", "开口嘅脸", "打开", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("吃惊"),
            keywords: &["吃惊", "同情", "啊", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("驚訝"),
            keywords: &["啊", "驚訝"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("擘大口嘅表情"),
            keywords: &["啊", "擘大口嘅表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuvule umlomo"),
            keywords: &["ubuso", "ubuso obuvule umlomo", "umlomo", "vula", "zwelo"],
        },
    ],
};
#[doc = "😯"]
pub const HUSHED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😯",
    codepoint: "1F62F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hushed face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gedempte gesig"),
            keywords: &["gedemp", "gedempte gesig", "gesig", "stil", "verbaas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አንሾካሿኪ ፊት"),
            keywords: &["ተደመመ", "ተገረመ", "አንሾካሾከ", "አንሾካሿኪ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مخفوت الصوت"),
            keywords: &["متفاجئ", "مدهوش", "مكتوم الصوت", "وجه", "وجه مخفوت الصوت"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিস\u{9cd}তব\u{9cd}ধ চেহেৰ\u{9be}"),
            keywords: &[
                "নিস\u{9cd}তব\u{9cd}ধ",
                "নিস\u{9cd}তব\u{9cd}ধ চেহেৰ\u{9be}",
                "বিষ\u{9cd}মিত",
                "ম\u{9c1}খ",
                "হতভম\u{9cd}ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("heyrətlənmiş üz"),
            keywords: &["heyrətlənmiş", "susmuş", "təəccüblənmiş", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ашаломлены твар"),
            keywords: &["ашаломлены", "здзіўлены", "змоўклы", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изненадано лице"),
            keywords: &["Изненадано лице", "впечатлен", "изненадан", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নিস\u{9cd}তব\u{9cd}ধ ম\u{9c1}খ"),
            keywords: &[
                "চ\u{9c1}প কর\u{9be}র ইঙ\u{9cd}গিত কর\u{9be}",
                "নিস\u{9cd}তব\u{9cd}ধ ম\u{9c1}খ",
                "বিস\u{9cd}মিত হওয\u{9bc}\u{9be}",
                "ম\u{9c1}খ",
                "হতভম\u{9cd}ব হওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zanijemio"),
            keywords: &["iznenađen", "lice", "nijem", "zanijemio", "zapanjen"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de sorpresa"),
            keywords: &["cara", "cara de sorpresa", "sorpresa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᎶᏪ ᎤᎧᏛ"),
            keywords: &["ᎠᏥᏎᎦᏍᏛᏅ", "ᎠᏥᏰᎶᎢᏍᏔᏅ", "ᎡᎶᏪ ᎤᎧᏛ", "ᎡᎶᏪ ᏯᎬᏁᎸᎢ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej se zaraženým výrazem"),
            keywords: &[
                "obličej se zaraženým výrazem",
                "překvapený",
                "smajlík",
                "tichý",
                "tvář",
                "výraz",
                "zaražený",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb distewi"),
            keywords: &["distewi", "syfrdanu", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tavst ansigt"),
            keywords: &["stille ansigt", "tavst ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("verdutztes Gesicht"),
            keywords: &["Gesicht", "erstaunt", "sprachlos", "verdutztes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("έκπληκτο βλέμμα"),
            keywords: &[
                "άφωνος",
                "έκπληκτο βλέμμα",
                "έκπληκτος",
                "πρόσωπο",
                "συγκλονισμένος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hushed face"),
            keywords: &["face", "hushed", "stunned", "surprised"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara estupefacta"),
            keywords: &[
                "alucinado",
                "cara",
                "cara estupefacta",
                "estupefacto",
                "sorprendido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara estupefacta", "sorprendido", "sorpresa"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vaigistatud nägu"),
            keywords: &["hämmingus", "nägu", "vaigistatud", "üllatunud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harridura-aurpegia"),
            keywords: &[
                "aurpegi",
                "harridura",
                "harridura-aurpegia",
                "harrituta",
                "zur eta lur",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مات و مبهوت"),
            keywords: &[
                "حیرت\u{200c}زده",
                "صورت",
                "غافلگیر",
                "مات",
                "مات و مبهوت",
                "مبهوت",
                "متعجب",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("järkyttynyt"),
            keywords: &["järkyttynyt", "naama", "sanaton", "yllättynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tahimik na naghihintay"),
            keywords: &[
                "mukha",
                "naghihintay",
                "nakanganga",
                "tahimik",
                "tahimik na naghihintay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bilsi andlit"),
            keywords: &["andlit", "bilsi andlit", "ovfari", "undrandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage ébahi"),
            keywords: &[
                "sans voix",
                "stupéfait",
                "surpris",
                "visage",
                "visage ébahi",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["sans voix", "stupéfait", "surpris", "visage", "ébahi"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ina tost"),
            keywords: &[
                "ionadh",
                "iontas",
                "straoiseog ina tost",
                "straoiseog thostach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann iongnaidh le sùilean fosgailte"),
            keywords: &[
                "aodann",
                "aodann iongnaidh le sùilean fosgailte",
                "iongnadh",
                "tost",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara estupefacta"),
            keywords: &["cara estupefacta", "estupefacto", "pasmo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શા\u{a82}ત ચહ\u{ac7}રો"),
            keywords: &[
                "અચ\u{a82}ભિત",
                "અવાક",
                "ચહ\u{ac7}રો",
                "શા\u{a82}ત ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai nitsuwa"),
            keywords: &[
                "fuska",
                "fuska mai nitsuwa",
                "mai mamaki",
                "nitsuwa",
                "rikitacce",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מופתע"),
            keywords: &["המום", "מופתע", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आश\u{94d}चर\u{94d}यचकित च\u{947}हरा"),
            keywords: &[
                "अच\u{902}भित",
                "अवाक",
                "आश\u{94d}चर\u{94d}यचकित",
                "च\u{947}हरा",
                "निस\u{94d}तब\u{94d}ध च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("iznenađeno lice"),
            keywords: &[
                "iznenađenje",
                "iznenađeno lice",
                "lice",
                "ušutkano",
                "zapanjeno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("meglepődött arc"),
            keywords: &["arc", "döbbent", "meglepett", "meglepődött"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սաստված դեմք"),
            keywords: &["ապշած", "դեմք", "զարմացած", "սաստված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah hening"),
            keywords: &[
                "kaget",
                "muka",
                "terdiam",
                "terkejut",
                "wajah",
                "wajah hening",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu dara jụụ"),
            keywords: &["dara jụụ", "ihu", "ihu dara jụụ", "mmadụ n’anya", "tụrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("undrandi andlit"),
            keywords: &["andlit", "undrandi", "undrun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina sorpresa"),
            keywords: &["faccina", "sbalordita", "sorpresa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ぽかーん"),
            keywords: &["びっくり", "びっくり顔", "ぽかーん", "顔", "驚き"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai dumadakan meneng"),
            keywords: &[
                "dumadakan meneng",
                "kaget",
                "ora nyana",
                "rai",
                "rai dumadakan meneng",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაოცებული სახე"),
            keywords: &["გაოგნებული", "გაოცებული", "სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem war taɣect"),
            keywords: &["udem war taɣect"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таңғалу"),
            keywords: &["бет", "таңдану", "таңырқату", "таңғалу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tavst ansigt"),
            keywords: &["stille ansigt", "tavst ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ម\u{17bb}ខច\u{17c6}ហមាត\u{17cb}\u{17cb}ច\u{17b7}ញ\u{17d2}ចើមងើបទៅលើលក\u{17d2}ខណៈភា\u{17c6}ង",
            ),
            keywords: &[
                "ភា\u{17c6}ង",
                "ម\u{17bb}ខច\u{17c6}ហមាត\u{17cb}\u{17cb}ច\u{17b7}ញ\u{17d2}ចើមងើបទៅលើលក\u{17d2}ខណៈភា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗೋಪ\u{ccd}ಯವಾಗ\u{cbf}ರ\u{cbf}ಸ\u{cbf}ದ ಮುಖ"),
            keywords: &[
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯವಾಗ\u{cbf}ರುವುದು",
                "ಗಾಬರ\u{cbf}ಯಾಗ\u{cbf}ರುವುದು",
                "ಗೋಪ\u{ccd}ಯವಾಗ\u{cbf}ರ\u{cbf}ಸ\u{cbf}ದ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("숨죽인 얼굴"),
            keywords: &["숨죽인 얼굴", "숨죽임", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शा\u{902}त जाल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "अजापीत",
                "आश\u{94d}चर\u{94d}यचकीत",
                "च\u{947}रो",
                "शा\u{902}त जाल\u{94d}लो",
                "शा\u{902}त जाल\u{94d}लो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("таң калган бет"),
            keywords: &["бет", "таң калган", "таң калган бет", "чоочуган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("flüsterend"),
            keywords: &["Gesiicht", "erstaunt", "flüsterend", "iwwerrascht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າມ\u{eb4}ດ"),
            keywords: &[
                "ປະຫ\u{ebc}າດໃຈ",
                "ຫ\u{eb8}ບປາກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າມ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nuščiuvęs veidas"),
            keywords: &["nustebęs", "nuščiuvęs", "priblokštas", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pārsteigta seja"),
            keywords: &["apklusināt", "pārsteigt", "pārsteigta seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi hanea"),
            keywords: &["hanea", "kanohi", "mae", "ohorere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("замолчено лице"),
            keywords: &["замолчено", "зачудено", "изненадено", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}തബ\u{d4d}\u{200c}ധമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "അത\u{d4d}ഭ\u{d41}തകരമ\u{d3e}യ",
                "ആശ\u{d4d}ചര\u{d4d}യമ\u{d41}ള\u{d4d}ള",
                "ഞെട\u{d4d}ടൽ",
                "മ\u{d41}ഖം",
                "സ\u{d4d}\u{200c}തബ\u{d4d}\u{200c}ധമ\u{d3e}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гайхширсан царай"),
            keywords: &["гайхширсан", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अच\u{902}भित च\u{947}हरा"),
            keywords: &[
                "अच\u{902}भित",
                "आश\u{94d}चर\u{94d}यचकित",
                "च\u{947}हरा",
                "स\u{94d}तब\u{94d}ध",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka terkejut"),
            keywords: &["aman", "muka", "terkejut", "terperanjat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imsikket"),
            keywords: &["imsikket", "sorpriż", "stordut", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{1036}\u{1037}ဩသည\u{1037}\u{103a}မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "မ\u{103e}င\u{103a}သက\u{103a}",
                "အ\u{1036}\u{1037}ဩခြင\u{103a}း",
                "အ\u{1036}\u{1037}ဩသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "အ\u{1036}\u{1037}ဩသည\u{1037}\u{103a}မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("overrasket"),
            keywords: &["fjes", "overrasket", "stum"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शान\u{94d}त अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "आश\u{94d}चर\u{94d}यचकित भएको",
                "शान\u{94d}त",
                "ह\u{948}रान भएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("verstomd gezicht"),
            keywords: &["gezicht", "verbaasd", "verrast", "verstomd"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("overraska"),
            keywords: &["fjes", "overraska", "stum"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3f}ସ\u{b4d}ତବ\u{b4d}ଧ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଆଶ\u{b4d}ଚର\u{b4d}ଯ\u{b4d}ୟ ହେବ\u{b3e}",
                "ଚକ\u{b3f}ତ ହେବ\u{b3e}",
                "ନ\u{b3f}ସ\u{b4d}ତବ\u{b4d}ଧ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}ਰਾਨ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਸਾ\u{a02}ਤ ਚਿਹਰਾ", "ਹ\u{a48}ਰਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ بند کیتی شکل"),
            keywords: &[
                "حیرت انگیز",
                "دنگ رہ جانا",
                "دی شکل",
                "منہ بند کیتی شکل",
                "چ\u{64f}پ کیتا ہوئیا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Dé Kwáyẹt"),
            keywords: &[
                "Fes",
                "Fes Wé Dé Kwáyẹt",
                "Kwáyẹt",
                "Shọk",
                "Sọpraiz",
                "Sọpraiz Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zdumiona twarz"),
            keywords: &["zaskoczenie", "zaskoczona buźka", "zdumiona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د چپې خولې مخ"),
            keywords: &["حيران", "د چپې خولې مخ", "مخ", "چپ", "ګنګس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto surpreso"),
            keywords: &["espantado", "rosto", "surpreso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara expectante"),
            keywords: &["cara", "expectante", "pasmado", "surpreso"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chʼin kasqa uya"),
            keywords: &[
                "chʼin kasqa uya",
                "kakka",
                "manchachisqa",
                "p’inqakusqa",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față amuțită"),
            keywords: &["amuțit", "față", "față amuțită", "surprins", "uimit"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-883"),
            keywords: &["E10-883"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("неприятный сюрприз"),
            keywords: &[
                "лицо",
                "молчание",
                "неприятно",
                "неприятный сюрприз",
                "сюрприз",
                "удивление",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza uwacecetse"),
            keywords: &[
                "isura",
                "isura igaragaza uwacecetse",
                "utangaye",
                "utuje cyane",
                "uwumiwe",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چپ ٿيل چهرو"),
            keywords: &["حيران ڪيل", "ششدر", "مخفي", "چهرو", "چپ ٿيل چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ශ\u{dca}ශබ\u{dca}ද ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "න\u{dd2}ශ\u{dca}ශබ\u{dca}ද",
                "න\u{dd2}හඩ",
                "ප\u{dd4}ද\u{dd4}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("umlčaná tvár"),
            keywords: &["ohromená", "prekvapená", "tvár", "umlčaná"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("osupljen obraz"),
            keywords: &["obraz", "osupljen obraz", "osuplo", "presenečeno", "tiho"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji iftiimaayo"),
            keywords: &["la yaabay", "nadiif ah", "waji", "waji iftiimaayo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e heshtur"),
            keywords: &[
                "e habitur",
                "e heshtur",
                "e çuditur",
                "fytyrë",
                "fytyrë e heshtur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("изненађено лице"),
            keywords: &[
                "зaпaњeнo",
                "изнeнaђeњe",
                "изненађено лице",
                "лице",
                "ућуткaнo",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["изненађено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("iznenađeno lice"),
            keywords: &[
                "iznenađenje",
                "iznenađeno lice",
                "lice",
                "ućutkano",
                "zapanjeno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["iznenađeno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hyssjat ansikte"),
            keywords: &[
                "hyssjad",
                "hyssjat ansikte",
                "stum",
                "tyst ansikte",
                "överraskad",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso ulionyamaa"),
            keywords: &[
                "kunyamaa",
                "kushangazwa",
                "kustaajabu",
                "uso",
                "uso ulionyamaa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆச\u{bcd}சரியத\u{bcd}தை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அப\u{bcd}படிய\u{bbe}!",
                "ஆச\u{bcd}சரியத\u{bcd}தை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
                "ஆச\u{bcd}சரியம\u{bcd}",
                "வியப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}శ\u{c4d}శబ\u{c4d}దంగ\u{c3e} చూస\u{c4d}తున\u{c4d}న ముఖం"),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}యం",
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}దం",
                "న\u{c3f}శ\u{c4d}శబ\u{c4d}దంగ\u{c3e} చూస\u{c4d}తున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хомӯш"),
            keywords: &["рӯи хомӯш", "рӯй", "хомӯшшуда", "шах шудамонда", "ҳайрон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าจ\u{e38}\u{e4a}ๆ"),
            keywords: &["หน\u{e49}า", "หน\u{e49}าจ\u{e38}\u{e4a}ๆ", "ห\u{e48}อปาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aňalyp galan ýüz"),
            keywords: &[
                "aňalan",
                "aňalyp galan ýüz",
                "geň galan",
                "haýran galan",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata longo"),
            keywords: &["mata longo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şaşkın yüz"),
            keywords: &["yüz", "şaşkın yüz", "şaşırmış", "şok olmuş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("جىمجىت چىراي"),
            keywords: &["جىم", "جىمجىت چىراي", "قاتقان", "چىراي", "ھەيران"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("здивоване і збентежене обличчя з бровами"),
            keywords: &[
                "вражений",
                "здивоване і збентежене обличчя з бровами",
                "здивований",
                "обличчя",
                "приголомшений",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شدید حیرت زدہ چہرہ"),
            keywords: &["حیرت", "شدید حیرت زدہ چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hayratlanayotgan yuz"),
            keywords: &[
                "hayratlanayotgan yuz",
                "hayratlangan",
                "karaxt",
                "sukut saqlash",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt làm thinh"),
            keywords: &[
                "choáng váng",
                "làm thinh",
                "mặt",
                "mặt làm thinh",
                "ngạc nhiên",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guñ juutal"),
            keywords: &["guñ juutal", "jaaxle", "kanam", "kanam guñ juutal", "waaru"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuthuleyo"),
            keywords: &[
                "thuleyo",
                "ubuso",
                "ubuso obuthuleyo",
                "ukothuka",
                "wothukile",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Idakẹjẹ"),
            keywords: &[
                "Oju Idakẹjẹ",
                "dákẹ\u{301}jẹ\u{301}",
                "ojú",
                "ìyàlẹ\u{301}nu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("沉默嘅臉"),
            keywords: &["嚇驚", "沉默", "沉默嘅臉", "臉", "驚訝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("沉默嘅脸"),
            keywords: &["吓惊", "惊讶", "沉默", "沉默嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("缄默"),
            keywords: &["吃惊", "缄默", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("哦"),
            keywords: &["哦", "驚訝"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("驚訝嘅表情"),
            keywords: &["哦", "驚訝嘅表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuthulisiwe"),
            keywords: &[
                "mangele",
                "thuliswa",
                "ubuso",
                "ubuso obuthulisiwe",
                "ukwethuka",
            ],
        },
    ],
};
#[doc = "😲"]
pub const ASTONISHED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😲",
    codepoint: "1F632",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "astonished face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("verstomde gesig"),
            keywords: &["gesig", "geskok", "verbaas", "verstom", "verstomde gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተገረመ ፊት"),
            keywords: &["ሙሉ በሙሉ", "የተገረመ", "የደነገጠ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مندهش"),
            keywords: &["مصدوم", "مندهش", "مندهش تمام\u{64b}ا", "وجه مندهش"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিস\u{9cd}মিত ম\u{9c1}খ"),
            keywords: &[
                "আচম\u{9cd}বিত",
                "বিস\u{9cd}মিত",
                "ম\u{9c1}খ",
                "সম\u{9cd}প\u{9c2}ৰ\u{9cd}ণৰ\u{9c2}পে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("təəccüblənmiş üz"),
            keywords: &["tamamilə", "təəccüblənmiş", "üz", "şoka düşmüş"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("здзіўлены твар"),
            keywords: &["здзіўлены", "здзіўлены твар", "цалкам", "шакіраваны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Учудено лице"),
            keywords: &["Учудено лице", "изумен", "лице", "учуден", "шокиран"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অব\u{9be}ক হয\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "অব\u{9be}ক হয\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be} ম\u{9c1}খ",
                "আশ\u{9cd}চর\u{9cd}য হওয\u{9bc}\u{9be}",
                "মর\u{9cd}ম\u{9be}হত",
                "ম\u{9c1}খ",
                "সম\u{9cd}প\u{9c2}র\u{9cd}ণ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zapanjenost"),
            keywords: &["lice", "totalno", "zapanjen", "zapanjenost", "zatečen"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara estupefacta"),
            keywords: &["cara", "estupefacta", "estupefacte"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏥᏎᎦᏍᏔᏅᎢ ᎤᎧᏛ"),
            keywords: &["ᎠᏥᏎᎦᏍᏔᏅᎢ", "ᎤᎧᏛ", "ᎤᏍᏆᏂᎦᏘ ᎤᏰᎸᏅ", "ᎧᎵᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("užaslý obličej"),
            keywords: &[
                "naprosto",
                "ohromený",
                "smajlík",
                "tvář",
                "užaslý obličej",
                "výraz",
                "úplně",
                "úžas",
                "šok",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb wedi rhyfeddu"),
            keywords: &[
                "hollol",
                "rhyfeddu",
                "syfrdanu",
                "wyneb",
                "wyneb wedi rhyfeddu",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("overrasket ansigt"),
            keywords: &["chokeret", "overrasket ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("erstauntes Gesicht"),
            keywords: &["Gesicht", "erstaunt", "erstauntes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ξάφνιασμα"),
            keywords: &[
                "έκπληκτος",
                "εντελώς",
                "ξάφνιασμα",
                "ξαφνιασμένος",
                "πρόσωπο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("astonished face"),
            keywords: &["astonished", "face", "shocked", "totally"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara asombrada"),
            keywords: &[
                "alucinado",
                "asombrado",
                "cara",
                "cara asombrada",
                "pasmado",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "asombro",
                "cara",
                "cara asombrada",
                "horrorizado",
                "sorprendido",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hämmastunud nägu"),
            keywords: &["ehmunud", "hämmastunud nägu", "hämmastus", "löödud", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("harritu-aurpegia"),
            keywords: &[
                "aurpegi",
                "guztiz",
                "harridura",
                "harritu-aurpegia",
                "sorpresa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بهت\u{200c}زده"),
            keywords: &[
                "بهت\u{200c}زده",
                "شوکه\u{200c}شده",
                "صورت",
                "مبهوت",
                "هاج\u{200c}وواج",
                "کاملا\u{64b}",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ällistynyt"),
            keywords: &["ihmetys", "järkyttynyt", "naama", "tosi", "ällistynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("gulat na gulat"),
            keywords: &["gulat na gulat", "mukha", "nabigla", "nagulat"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ovfari andlit"),
            keywords: &["andlit", "bilsi", "ovfari andlit", "undrandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage stupéfait"),
            keywords: &["choc", "stupéfait", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["choqué", "stupéfait", "surpris", "visage", "étonné"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog iontais"),
            keywords: &["ionadh", "iontas", "straoiseog iontais"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a ghabh mòr-iongnadh"),
            keywords: &[
                "annas",
                "aodann",
                "aodann a ghabh mòr-iongnadh",
                "gu tur",
                "iongnadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara abraiada"),
            keywords: &["abraiado", "abraio", "asombro", "cara abraiada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આશ\u{acd}ચર\u{acd}યચકિત ચહ\u{ac7}રો"),
            keywords: &[
                "આઘાત",
                "આશ\u{acd}ચર\u{acd}ય",
                "આશ\u{acd}ચર\u{acd}યચકિત ચહ\u{ac7}રો",
                "ચહ\u{ac7}રો",
                "તદ\u{acd}દન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai burgewa"),
            keywords: &[
                "fuska",
                "fuska mai burgewa",
                "gaba ɗaya",
                "mai burgewa",
                "mai mamaki",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף נדהם"),
            keywords: &["המום", "נדהם", "פה", "פרצוף", "פתוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{942}री तरह स\u{94d}त\u{902}भित च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "झटका",
                "प\u{942}री तरह स\u{94d}त\u{902}भित",
                "प\u{942}री तरह स\u{94d}त\u{902}भित च\u{947}हरा",
                "भौ\u{902}चक",
                "ह\u{948}रान च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zapanjeno lice"),
            keywords: &["lice", "zapanjeno lice", "zapanjenost", "šok"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lenyűgözött arc"),
            keywords: &["arc", "csodálkozó", "lenyűgözött"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ապշահար դեմք"),
            keywords: &["ամբողջովին", "ապշահար", "դեմք", "ցնցված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah terpukau"),
            keywords: &["kaget", "muka", "takjub", "terkejut", "terpukau", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere ịtụnanya"),
            keywords: &[
                "ihu",
                "ihu nwere ịtụnanya",
                "nwere mgbagwoju",
                "n’anya",
                "tụrụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stórundrandi andlit"),
            keywords: &["andlit", "stórundrandi andlit", "undrandi", "undrun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina stupita"),
            keywords: &["faccina", "scioccata", "stupita"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("びっくり"),
            keywords: &["びっくり", "びっくりした顔", "顔", "驚き", "驚愕"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai gumun"),
            keywords: &["babar pisan", "gumun", "kaget", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაკვირვებული სახე"),
            keywords: &["გაკვირვებული", "სახე", "შოკირებული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аң-таң болу"),
            keywords: &["аң-таң", "аң-таң болу", "бет", "таң қалу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("overrasket ansigt"),
            keywords: &["chokeret", "overrasket ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខភ\u{17d2}ជាក\u{17cb}ផ\u{17d2}អើល"),
            keywords: &[
                "ភ\u{17d2}ញាក\u{17cb}ផ\u{17d2}អើល",
                "ម\u{17bb}ខភ\u{17d2}ជាក\u{17cb}ផ\u{17d2}អើល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಶ\u{ccd}ಚರ\u{ccd}ಯಚಕ\u{cbf}ತ ಮುಖ"),
            keywords: &[
                "ಆಘಾತವಾಗ\u{cbf}ರುವುದು",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯಚಕ\u{cbf}ತ ಮುಖ",
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯಚಕ\u{cbf}ತವಾಗ\u{cbf}ರುವುದು",
                "ಮುಖ",
                "ಸಂಪ\u{cc2}ರ\u{ccd}ಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("깜짝 놀란 얼굴"),
            keywords: &["깜짝 놀란 얼굴", "놀라움", "놀란 얼굴", "얼굴", "충격"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विस\u{94d}मीत च\u{947}रो"),
            keywords: &["एक\u{942}ण", "च\u{947}रो", "थक\u{94d}क", "विस\u{94d}मीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("айран-таң калган бет"),
            keywords: &[
                "айран-таң",
                "айран-таң калган бет",
                "бет",
                "дабдаарып калган бет",
                "чоочуган",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("erstaunt"),
            keywords: &["Gesiicht", "absolut", "erstaunt", "schockéiert"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຕ\u{eb7}\u{ec8}ນຕ\u{ebb}ກໃຈ"),
            keywords: &[
                "ຕ\u{ebb}ກໃຈ",
                "ປະຫ\u{ebc}າດໃຈ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຕ\u{eb7}\u{ec8}ນຕ\u{ebb}ກໃຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apstulbęs veidas"),
            keywords: &["apstulbęs", "priblokštas", "veidas", "visiškai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("šokēta seja"),
            keywords: &["pārsteigts", "seja", "šokēta seja", "šokēts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi ohorere"),
            keywords: &["kanohi", "katoa", "oho", "ohorere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вчудовидено лице"),
            keywords: &["вчудовидено лице", "вчудоневидено", "лице", "шокирано"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അത\u{d4d}ഭ\u{d41}തം നിറഞ\u{d4d}ഞ മ\u{d41}ഖം"),
            keywords: &[
                "അത\u{d4d}ഭ\u{d41}തം",
                "അത\u{d4d}ഭ\u{d41}തം നിറഞ\u{d4d}ഞ മ\u{d41}ഖം",
                "ആശ\u{d4d}ചര\u{d4d}യം",
                "ഞെട\u{d4d}ടൽ",
                "പ\u{d42}ർണ\u{d4d}ണമ\u{d3e}യ\u{d41}ം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мэл гайхсан царай"),
            keywords: &["мэл гайхсан", "мэл гайхсан царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आश\u{94d}चर\u{94d}यचकित च\u{947}हरा"),
            keywords: &[
                "आश\u{94d}चर\u{94d}यचकित",
                "आश\u{94d}चर\u{94d}यचकित च\u{947}हरा",
                "धक\u{94d}का बसल\u{947}ला",
                "प\u{942}र\u{94d}णपण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka terperanjat"),
            keywords: &[
                "hairan",
                "muka",
                "muka terperanjat",
                "sama sekali",
                "terkejut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ skantat"),
            keywords: &["ixxokkjat", "skantat", "totalment", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{1036}\u{1037}အားသင\u{1037}\u{103a}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ကြက\u{103a}သေသေ",
                "မျက\u{103a}န\u{103e}ာ",
                "လ\u{102f}\u{1036}းဝ",
                "အ\u{1036}\u{1037}အားသင\u{1037}\u{103a}ခြင\u{103a}း",
                "အ\u{1036}\u{1037}အားသင\u{1037}\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sjokkert"),
            keywords: &["fjes", "overrasket", "sjokkert", "stum"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चकित अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "चकित", "द\u{902}ग भएको", "प\u{942}र\u{948}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("verbaasd gezicht"),
            keywords: &[
                "gechoqueerd",
                "geschokt",
                "gezicht",
                "totaal gechoqueerd",
                "verbaasd gezicht",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sjokkert"),
            keywords: &["fjes", "overraska", "sjokkert", "stum"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ସ\u{b4d}ମ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଚକ\u{b3f}ତ",
                "ବ\u{b3f}ସ\u{b4d}ମ\u{b3f}ତ",
                "ମ\u{b41}ହ\u{b01}",
                "ସମ\u{b4d}ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}ਰਤ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਪ\u{a42}ਰੀ ਤਰ\u{a4d}ਹਾ\u{a02} ਹ\u{a48}ਰਾਨ",
                "ਹ\u{a48}ਰਤ ਵਾਲਾ ਚਿਹਰਾ",
                "ਹ\u{a48}ਰਾਨ",
                "ਹ\u{a48}ਰਾਨੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("حیرت زدہ شکل"),
            keywords: &[
                "حیران ہونا",
                "حیرت زدہ شکل",
                "دی شکل",
                "متعجب ہونا",
                "مکمل طور تے",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Sọpraiz Fúl Am"),
            keywords: &[
                "Fes",
                "Fes Wé Sọpraiz Fúl Am",
                "Kọmplit",
                "Shọk",
                "Sọpraiz Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zadziwiona twarz"),
            keywords: &["zadziwiona twarz", "zaskoczenie", "zaskoczona buźka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("حيران مخ"),
            keywords: &["بشپړ", "حيران", "مخ", "پښيمانه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto espantado"),
            keywords: &[
                "chocado",
                "estupefato",
                "rosto",
                "rosto espantado",
                "totalmente chocado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara espantada"),
            keywords: &[
                "cara",
                "cara espantada",
                "chocado",
                "estupefacto",
                "surpreso",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("añasqa uya"),
            keywords: &["añasqa", "chaqrusqa", "llapan", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față uimită"),
            keywords: &["față", "față uimită", "uimire", "uluire", "șoc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-886"),
            keywords: &["E10-886"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в шоке"),
            keywords: &["в шоке", "лицо", "потрясение", "удивление", "шок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yatangaye"),
            keywords: &[
                "isura",
                "isura yatangaye",
                "itangaye",
                "kibumbiye hamwe",
                "wumiwe",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("حيران ٿيل چهرو"),
            keywords: &["بدحواس", "حيران", "حيران ٿيل چهرو", "پورو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ස\u{dca}මයට පත\u{dca} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ප\u{dd4}ද\u{dd4}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}ස\u{dca}මයට පත\u{dca}",
                "ව\u{dd2}ස\u{dca}මයට පත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
                "සම\u{dca}ප\u{dd6}ර\u{dca}ණයෙන\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("udivená tvár"),
            keywords: &["absolútne", "tvár", "udivená", "šokovaná"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("začuden obraz"),
            keywords: &[
                "frapirano",
                "obraz",
                "popolnoma",
                "presenečeno",
                "začuden obraz",
                "začudeno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji amakaagsan"),
            keywords: &["amkaag", "guud ahaan", "la yaab", "waji", "waji amakaagsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e çuditur"),
            keywords: &[
                "e tronditur",
                "e çuditur",
                "fytyrë",
                "fytyrë e çuditur",
                "plotësisht",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("запањено лице"),
            keywords: &["зaпaњeнoст", "запањено лице", "лице", "шoк"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["запањено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zapanjeno lice"),
            keywords: &["lice", "zapanjeno lice", "zapanjenost", "šok"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zapanjeno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("chockat ansikte"),
            keywords: &["chockad", "chockat ansikte", "förvånad"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliostaajabu"),
            keywords: &[
                "kabisa",
                "kushtuliwa",
                "kustaajabishwa",
                "uso",
                "uso uliostaajabu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அதிர\u{bcd}ச\u{bcd}சியை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அதிர\u{bcd}ச\u{bcd}சி",
                "அதிர\u{bcd}ச\u{bcd}சிய\u{bbe}ன முகம\u{bcd}",
                "அதிர\u{bcd}ச\u{bcd}சியை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
                "நடுக\u{bcd}கம\u{bcd} ஏற\u{bcd}பட\u{bcd}டது",
                "ஷ\u{bbe}க\u{bcd}க\u{bbe}யிட\u{bcd}டேன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆశ\u{c4d}చర\u{c4d}యంత\u{c4b} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f}న ముఖం"),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}యం",
                "ఆశ\u{c4d}చర\u{c4d}యంత\u{c4b} న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f}న ముఖం",
                "న\u{c4b}రు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи ҳайрон"),
            keywords: &["баҳайратафтода", "рӯи ҳайрон", "рӯй", "тамоман", "ҳайрон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าประหลาดใจ"),
            keywords: &["ประหลาดใจ", "หน\u{e49}า", "หน\u{e49}าประหลาดใจ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aňk-taňk bolan ýüz"),
            keywords: &[
                "aňk-taňk",
                "aňk-taňk bolan ýüz",
                "düýbünden",
                "haýran",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata ʻohovale"),
            keywords: &["mata ʻohovale"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("afallamış yüz"),
            keywords: &["afallamış", "tamamen şoke olmuş", "yüz", "şoke olmuş"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھەيران چىراي"),
            keywords: &["قاتقان", "پۈتۈنلەي", "چىراي", "ھەيران"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вражене обличчя"),
            keywords: &["вражене обличчя", "здивований", "обличчя", "шокований"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("حیرت زدہ چہرہ"),
            keywords: &["تکلیف", "حیرت", "حیرت زدہ چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hayratlangan yuz"),
            keywords: &["batamom", "hayratlangan", "taajjub", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt kinh ngạc"),
            keywords: &["hoàn toàn", "kinh ngạc", "mặt", "mặt kinh ngạc", "sốc"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu waaru"),
            keywords: &["bu baax", "kanam", "kanam gu waaru", "soke", "waaru"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuthe manga"),
            keywords: &[
                "manga",
                "ngokupheleleyo",
                "ubuso",
                "ubuso obuthe manga",
                "ukothuka",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú ìyalẹnu"),
            keywords: &[
                "ojú",
                "ojú ìyalẹnu",
                "pátápátá",
                "ìpaláyà",
                "ìyàlẹ\u{301}nu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("驚訝嘅臉"),
            keywords: &["嚇親", "完全", "臉", "驚訝", "驚訝嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("惊讶嘅脸"),
            keywords: &["吓亲", "完全", "惊讶", "惊讶嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("震惊"),
            keywords: &["惊", "惊讶", "脸", "震惊"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("震驚"),
            keywords: &["震驚", "驚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("震驚"),
            keywords: &["震驚", "驚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuthukile"),
            keywords: &[
                "ngokugcwele",
                "ubuso",
                "ubuso obuthukile",
                "ukumangala",
                "ukwethuka",
            ],
        },
    ],
};
#[doc = "😳"]
pub const FLUSHED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😳",
    codepoint: "1F633",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "flushed face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blosende gesig"),
            keywords: &["blosend", "blosende gesig", "gesig", "verbysterd"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የደነበረ ፊት"),
            keywords: &["የተደበረ", "የደነበረ ፊት", "ያፈረ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه متورد"),
            keywords: &["متورد", "مصاب بدوار", "وجه متورد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} পৰ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "বিস\u{9cd}মিত",
                "ম\u{9c1}খ",
                "ৰঙ\u{9be} পৰ\u{9be}",
                "ৰঙ\u{9be} পৰ\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qızarmış üz"),
            keywords: &["karıxmış", "qızarmış", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("здранцвелы твар"),
            keywords: &[
                "аслупянелы",
                "аслупянелы твар",
                "збянтэжаны",
                "збянтэжаны твар",
                "здранцвелы твар",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изчервено лице"),
            keywords: &["Изчервено лице", "изчервен", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রক\u{9cd}তিম ম\u{9c1}খ"),
            keywords: &["চমকিত", "ম\u{9c1}খ", "রক\u{9cd}তিম"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ispranost"),
            keywords: &["ispran", "ispranost", "lice", "omama", "ošamućen"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara enrojolada"),
            keywords: &["cara", "enrojolada", "galtes vermelles", "vergonya"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏃᎱᎪᏗ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏎᎩᏲᏤ", "ᎦᏃᎱᎪᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("červenající se obličej"),
            keywords: &[
                "omámení",
                "ruměnec",
                "smajlík",
                "tvář",
                "výraz",
                "zardění",
                "zrudnutí",
                "zčervenání",
                "červenající se obličej",
                "červenání",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn gwrido"),
            keywords: &["cochi", "gwrido", "synnu", "wyneb", "wyneb yn gwrido"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rødmende ansigt"),
            keywords: &["omtumlet", "røde kinder", "rødme", "rødmende ansigt", "ør"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("errötetes Gesicht mit großen Augen"),
            keywords: &[
                "Gesicht",
                "errötetes Gesicht",
                "errötetes Gesicht mit großen Augen",
                "rote Wangen",
                "überrascht",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Erröteter Smiley mit grossen Augen"),
            keywords: &[
                "Erröteter Smiley mit grossen Augen",
                "Gesicht",
                "rote Wangen",
                "überrascht",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κοκκινισμένο πρόσωπο"),
            keywords: &[
                "κοκκινισμένο πρόσωπο",
                "κοκκινισμένος",
                "πρόσωπο",
                "σαστισμένος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flushed face"),
            keywords: &["dazed", "face", "flushed"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara sonrojada"),
            keywords: &["cara", "cara sonrojada", "colorado", "sonrojado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara sonrojada"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "avergonzado",
                "cara sonrojada",
                "sonrojado",
                "sorprendido",
                "sorpresa",
                "vergüenza",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "avergonzado",
                "cara sonrojada",
                "sonrojado",
                "sorprendido",
                "sorpresa",
                "vergüenza",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punastav nägu"),
            keywords: &["nägu", "punastamine", "punastav nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi gorritua"),
            keywords: &["aurpegi", "aurpegi gorritua", "gorritu", "nahastu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سرخ\u{200c}شده"),
            keywords: &["بهت", "حیرت", "خجالت", "سرخ\u{200c}شده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punastunut naama"),
            keywords: &["naama", "punastunut", "tyrmistynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("namumula"),
            keywords: &["blush", "mukha", "nahihiya", "namumula"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("rodna andlit"),
            keywords: &["andlit", "rodna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui rougit"),
            keywords: &["rouge", "rougissant", "visage", "visage qui rougit"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog dhearg"),
            keywords: &[
                "aghaidh dhearg",
                "aghaidh lasta",
                "mearbhall",
                "straoiseog dhearg",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann air ruadhadh"),
            keywords: &["aodann", "aodann air ruadhadh", "ruadhadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara arroibada"),
            keywords: &["arroibado", "cara", "cara arroibada", "vergoña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}તબ\u{acd}ધ ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ફ\u{acd}લશ\u{acd}ડ",
                "સ\u{acd}તબ\u{acd}ધ",
                "સ\u{acd}તબ\u{acd}ધતામા\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai murna"),
            keywords: &["fuska", "fuska mai murna", "mai murna", "mamaki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף נדהם וסמוק"),
            keywords: &[
                "הלם",
                "מסמיק",
                "נדהם",
                "עיניים",
                "פרצוף נדהם וסמוק",
                "שוק",
                "תדהמה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विस\u{94d}मित च\u{947}हरा"),
            keywords: &[
                "उत\u{94d}त\u{947}जित",
                "च\u{947}हरा",
                "विस\u{94d}मय",
                "विस\u{94d}मित च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zarumenjeno lice"),
            keywords: &["lice", "nesigurnost", "rumenost", "zarumenjeno lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("elpirult arc"),
            keywords: &["arc", "elpirul", "elpirult arc", "elvörösödik"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շիկնած դեմք"),
            keywords: &["դեմք", "հիացած", "շիկնած"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tersipu"),
            keywords: &["muka", "tersipu", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nchagharị ọbara"),
            keywords: &["ihu", "ihu nchagharị ọbara", "nchagharị", "nwere ụjọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andlit að roðna"),
            keywords: &["andlit", "andlit að roðna", "roðna"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina imbarazzata"),
            keywords: &[
                "confuso",
                "faccina",
                "faccina con guance rosse",
                "faccina imbarazzata",
                "imbarazzato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤面"),
            keywords: &["赤くなる", "赤面", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai isin"),
            keywords: &["isin", "kaget", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაწითლებული სახე"),
            keywords: &["გაწითლებული", "სახე", "წითელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таңырқаған"),
            keywords: &["аң-таң", "бет", "таңырқаған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rødmende ansigt"),
            keywords: &["røde kinder", "rødmende ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខឡើងក\u{17d2}រហមព\u{17d2}រឿងៗ"),
            keywords: &[
                "បើក",
                "ភ\u{17d2}នែក",
                "ម\u{17bb}ខក\u{17d2}រហម",
                "ម\u{17bb}ខឡើងក\u{17d2}រហមព\u{17d2}រឿងៗ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪೇರ\u{cbf}ದ ಮುಖ"),
            keywords: &[
                "ಕಕ\u{ccd}ಕಾಬ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ಯ ಮುಖ",
                "ಕ\u{cc6}ಂಪೇರ\u{cbf}ದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("상기된 얼굴"),
            keywords: &[
                "달아오른 얼굴",
                "붉힌 얼굴",
                "상기된 얼굴",
                "얼굴",
                "얼굴 붉힘",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लज\u{947}ल\u{94d}लो च\u{947}रो"),
            keywords: &["ग\u{941}\u{902}ग", "च\u{947}रो", "लज\u{947}ल\u{94d}लो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("уялган бет"),
            keywords: &["бет", "таң калган", "уялган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("rout ugelafent Gesiicht"),
            keywords: &[
                "Gesiicht",
                "beniwwelt",
                "rout ugelaf",
                "rout ugelafent Gesiicht",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າແດງ"),
            keywords: &["ອາຍ", "ໜ\u{ec9}າ", "ໜ\u{ec9}າແດງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nuraudęs veidas"),
            keywords: &["nuraudęs", "raudonis", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nosarkusi seja"),
            keywords: &["apmulsis", "nosarkt", "nosarkusi seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi werawera"),
            keywords: &["kanohi", "pōro", "werawera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вцрвенето лице"),
            keywords: &["вцрвенето", "збунето", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}തംഭിച\u{d4d}ച മ\u{d41}ഖം"),
            keywords: &[
                "ഞെട\u{d4d}ടൽ",
                "മ\u{d41}ഖം",
                "ലജ\u{d4d}ജ\u{d3e}വഹം",
                "സ\u{d4d}\u{200c}തംഭിച\u{d4d}ച",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ичсэн царай"),
            keywords: &["ичсэн", "царай", "ягаарсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विस\u{94d}मयचकित च\u{947}हरा"),
            keywords: &["चकित", "च\u{947}हरा", "विस\u{94d}मयचकित"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka malu"),
            keywords: &["bingung", "memerah", "muka", "muka malu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ ruxxan"),
            keywords: &["ruxxan", "sturdut", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အားမာန\u{103a}ပြည\u{1037}\u{103a}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "အားမာန\u{103a}",
                "အားမာန\u{103a}ပြည\u{1037}\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
                "အားမာန\u{103a}အပြည\u{1037}\u{103a}န\u{103e}င\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rødmer"),
            keywords: &["fjes", "rød", "rødmer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातो भएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "रातो भएको",
                "रातो भएको अन\u{941}हार",
                "स\u{94d}तब\u{94d}ध",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blozend gezicht"),
            keywords: &["blozend", "gezicht", "verbijsterd"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raudnar"),
            keywords: &["fjes", "raud", "raudnar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରକ\u{b4d}ତ\u{b3f}ମ\u{b3e} ପଡ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଭୟଭ\u{b3f}ତ",
                "ମ\u{b41}ହ\u{b01}",
                "ରକ\u{b4d}ତ\u{b3f}ମ\u{b3e} ପଡ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ରକ\u{b4d}ତ\u{b3f}ମ\u{b3e} ପଡ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭਖਿਆ ਚਿਹਰਾ"),
            keywords: &["ਉਲਝਣ ਵਿ\u{a71}ਚ", "ਚਿਹਰਾ", "ਬ\u{a47}ਚਾਰਾ", "ਭਖਿਆ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جوشیلی شکل"),
            keywords: &["بے دخل", "جوشیلی شکل", "دی شکل", "ہکا بکا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Fes"),
            keywords: &["Fes", "Rẹ\u{301}d Fes", "Shọk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz z rumieńcami"),
            keywords: &["twarz z rumieńcami", "twarz z wypiekami"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سور او تود مخ"),
            keywords: &["سر ګرځيدل", "سور او تود", "سور او تود مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto ruborizado"),
            keywords: &["atordoado", "rosto", "rosto ruborizado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara corada"),
            keywords: &["aturdido", "cara", "cara corada", "corado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pʼinqakusqa uya"),
            keywords: &["kuyusqa", "pʼinqakusqa uya", "p’inqakusqa", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față îmbujorată"),
            keywords: &["față", "față îmbujorată", "zăpăcit", "îmbujorat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-887"),
            keywords: &["E10-887"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("краснеет"),
            keywords: &["краснеет", "красный", "лицо", "смущение", "щеки"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura yatukuye"),
            keywords: &["isura", "isura yatukuye", "uwahabye", "yishimye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سرخي ڇانيل چهرو"),
            keywords: &["بدحواس", "سرخي ڇانيل", "سرخي ڇانيل چهرو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "රත\u{dd4} ව\u{dd6}",
                "රත\u{dd4} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ලැජ\u{dca}ජ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zapýrená tvár"),
            keywords: &["sčervenená", "tvár", "zapýrená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zardeli obraz"),
            keywords: &["obraz", "zardeli obraz", "zardelo", "zmedeno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji xishood leh"),
            keywords: &["gariir", "jeexay", "waji", "waji xishood leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e skuqur"),
            keywords: &["e habitur", "e skuqur", "fytyrë", "fytyrë e skuqur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зајапурено лице"),
            keywords: &["зајапурено лице", "лице", "нeсигурнoст", "румeнило"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["зајапурено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zajapureno lice"),
            keywords: &["lice", "nesigurnost", "rumenilo", "zajapureno lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zajapureno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rodnande ansikte"),
            keywords: &["generad", "omtumlad", "rodnande ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliojawa msisimko"),
            keywords: &["kizunguzungu", "sisimka", "uso", "uso uliojawa msisimko"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("திகைப\u{bcd}பைக\u{bcd} க\u{bbe}ட\u{bcd}டு முகம\u{bcd}"),
            keywords: &[
                "திகைப\u{bcd}பு",
                "திகைப\u{bcd}பைக\u{bcd} க\u{bbe}ட\u{bcd}டு முகம\u{bcd}",
                "பிரமிப\u{bcd}ப\u{bbe}க உள\u{bcd}ளது",
                "பிரமிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కలవరప\u{c3e}టుగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &["కలవరం", "కలవరప\u{c3e}టుగ\u{c3e} ఉన\u{c4d}న ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи сурхшуда"),
            keywords: &["мабҳут", "рӯи сурхшуда", "рӯй", "сурхшуда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อายหน\u{e49}าแดง"),
            keywords: &["หน\u{e49}า", "อาย", "อายหน\u{e49}าแดง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzaran ýüz"),
            keywords: &["gyzaran", "gözi gamaşan", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata pahapaha"),
            keywords: &["mata pahapaha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kızarmış ve şaşkın yüz"),
            keywords: &[
                "kızarmış ve şaşkın yüz",
                "kızarmış yüz",
                "yüz",
                "şaşkınlık içinde",
                "şaşırmış",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزارغان چىراي"),
            keywords: &["قىزارغان", "چىراي", "ھاڭۋاققان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зашаріле обличчя"),
            keywords: &[
                "зашаріле обличчя",
                "обличчя",
                "обличчя із широко відкритими очима та зашарілими щоками",
                "присоромлений",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شرمندگی سے سرخ چہرہ"),
            keywords: &["سرخ", "شرمندگی", "شرمندگی سے سرخ چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yuzi qizargan"),
            keywords: &["mahliyo", "qizarish", "yuz", "yuzi qizargan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt đỏ ửng"),
            keywords: &["choáng váng", "mặt", "mặt đỏ ửng", "đỏ mặt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu am tomb yu xonk"),
            keywords: &[
                "bu am tomb yu xonk",
                "kanam",
                "kanam gu am tomb yu xonk",
                "xel mu deppaar",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuneentloni"),
            keywords: &["iintloni", "ubuso", "ubuso obuneentloni", "ukuncithekisa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Idunnu"),
            keywords: &["Oju Idunnu", "ojú", "yàlẹ\u{301}nu", "ìdùnú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("臉紅"),
            keywords: &["暈", "臉", "臉紅"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("脸红"),
            keywords: &["晕", "脸", "脸红"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("脸红"),
            keywords: &["困惑", "害羞", "羞涩", "脸", "脸红", "茫然", "迷茫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("愛慕"),
            keywords: &["害羞", "愛慕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("臉紅"),
            keywords: &["怕醜", "睜大眼睛", "臉紅"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumuncu"),
            keywords: &["ubuso", "ubuso obumuncu", "ukumunca", "ukwethuka"],
        },
    ],
};
#[doc = "🥺"]
pub const PLEADING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🥺",
    codepoint: "1F97A",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "pleading face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("soebat gesig"),
            keywords: &["asseblief", "ontferming", "smeek", "soebat", "soebat gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሙግት ፊት"),
            keywords: &["ልመና", "ምህረት", "የሙግት ፊት", "የትንንሽ ውሾች አይን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه ملتمس"),
            keywords: &["توسل", "رحمة", "عيون جرو", "وجه ملتمس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰতিব\u{9be}দী ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9c3}প\u{9be}",
                "কোমল চক\u{9c1}",
                "প\u{9cd}ৰতিব\u{9be}দী ম\u{9c1}খ",
                "ভিক\u{9cd}ষ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yalvaran üz"),
            keywords: &["mərhəmət", "nəm gözlər", "yalvaran üz", "yalvarış"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("умольвае"),
            keywords: &["моліць", "просіць", "умольвае", "шчанячы позірк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("умоляващо лице"),
            keywords: &["кучешки поглед", "милост", "умоляване", "умоляващо лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অন\u{9c1}নয\u{9bc}ক\u{9be}রী ম\u{9c1}খ"),
            keywords: &[
                "অন\u{9c1}নয\u{9bc}ক\u{9be}রী ম\u{9c1}খ",
                "কর\u{9c1}ণ\u{9be}",
                "ক\u{9c1}ক\u{9c1}র ছ\u{9be}ন\u{9be}র মত চোখ",
                "ভিক\u{9cd}ষ\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("molećivo lice"),
            keywords: &["milost", "molećiv", "molećivo lice", "pseći pogled"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de súplica"),
            keywords: &["cara de súplica", "pietat", "súplica", "ulls de cadell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏂᎳᏗᎠ ᎤᎧᏛ"),
            keywords: &["ᎠᏓᏙᎵᏍᏗ", "ᎠᏚᎳᏗᏍᎬ", "ᎦᏂᎳᏗᎠ ᎤᎧᏛ", "ᎩᎵ ᎠᏗ ᏗᎦᏙᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("prosebný obličej"),
            keywords: &[
                "milost",
                "prosba",
                "prosebný obličej",
                "psí oči",
                "slitování",
                "žadonění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn pledio"),
            keywords: &["crefu", "llygaid ci bach", "trugaredd", "wyneb yn pledio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bønfaldende ansigt"),
            keywords: &[
                "barmhjertighed",
                "bede",
                "bønfaldende ansigt",
                "hundeøjne",
                "trygle",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("bettelndes Gesicht"),
            keywords: &["Gnade", "Welpenaugen", "betteln", "bettelndes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("προσωπάκι παρακαλετό"),
            keywords: &[
                "έλεος",
                "βλέμμα κουταβιού",
                "ζητιανιά",
                "προσωπάκι παρακαλετό",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pleading face"),
            keywords: &["begging", "mercy", "pleading face", "puppy eyes"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de por favor"),
            keywords: &[
                "cara de por favor",
                "implorar",
                "ojos adorables",
                "piedad",
                "por favor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara de súplica"),
            keywords: &[
                "cara de por favor",
                "cara de súplica",
                "implorar",
                "ojos adorables",
                "piedad",
                "por favor",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("anuv nägu"),
            keywords: &["anuv nägu", "halastust ootav", "kutsikasilmad", "paluv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi erregutzailea"),
            keywords: &[
                "aurpegi erregutzailea",
                "begirada erregutzaile",
                "erregutze",
                "gupida",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("التماس\u{200c}کنان"),
            keywords: &["التماس", "التماس\u{200c}کنان", "بخشش", "خواهش", "دلسوزی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("anova"),
            keywords: &["anova", "koiranpentuilme", "sääli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagsusumamo na mukha"),
            keywords: &[
                "habag",
                "mata na kuwa",
                "nagmamakaawa",
                "nagsusumamo na mukha",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("biðjandi andlit"),
            keywords: &["biðjandi andlit", "bønandi", "náði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage implorant"),
            keywords: &[
                "pitié",
                "supplication",
                "visage implorant",
                "yeux de chiens battus",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "implorant",
                "pitié",
                "supplication",
                "visage",
                "yeux de chiot",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog impíoch"),
            keywords: &["impigh", "straoiseog impíoch", "súile coileáin", "trócaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann tagrach"),
            keywords: &[
                "aodann tagrach",
                "faoighe",
                "grìos",
                "grìosadh",
                "gur",
                "guradh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de súplica"),
            keywords: &[
                "cara de súplica",
                "compaixón",
                "implorar",
                "pedir clemencia",
                "suplicar",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દયાવાળો ચહ\u{ac7}રો"),
            keywords: &["દયાવાળો ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מתחנן"),
            keywords: &["מתחנן", "עיניים מתחננות", "פרצוף מתחנן", "רחמים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कर\u{941}ण च\u{947}हरा"),
            keywords: &[
                "कर\u{941}ण",
                "कर\u{941}ण च\u{947}हरा",
                "दयनीय",
                "मास\u{942}म",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("molećivo lice"),
            keywords: &["milost", "molećivo lice", "pseći pogled"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("esedező arc"),
            keywords: &["bociszemek", "esedező arc", "kérlelő", "könyörgős"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղաչող դեմք"),
            keywords: &["աղաչող", "աղաչող դեմք", "արցունքներ", "խնդրող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah memelas"),
            keywords: &["kasihan", "mata memelas", "memohon", "wajah memelas"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("biðjandi andlit"),
            keywords: &["biðjandi andlit", "grátbiðja", "hvolpaaugu", "miskunn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina supplichevole"),
            keywords: &[
                "faccina sull’orlo delle lacrime",
                "faccina supplichevole",
                "implorare",
                "lacrime",
                "quasi in lacrime",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("訴えるような顔"),
            keywords: &["子犬の目", "情け", "懇願", "訴えるような顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai ngarep-arep welas"),
            keywords: &[
                "mata ngarep-arep",
                "ngarep-arep",
                "rai ngarep-arep welas",
                "welas",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შემოვედრება"),
            keywords: &["ვედრება", "ლეკვის გამოხედვა", "მოწყალება", "შემოვედრება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жалыну"),
            keywords: &[
                "жалыну",
                "жалынған жүз",
                "кешірім сұраған",
                "мөлдіреген көздер",
                "рақымшыл",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខអង\u{17d2}វរ"),
            keywords: &[
                "ការអង\u{17d2}វរ",
                "ធ\u{17d2}វើភ\u{17d2}នែកគ\u{17bd}រឱ\u{17d2}យអាណ\u{17b7}ត",
                "ម\u{17bb}ខអង\u{17d2}វរ",
                "មេត\u{17d2}តាធម\u{17cc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮನವೊಲ\u{cbf}ಸುವ ಮುಖ"),
            keywords: &[
                "ಕರುಣ\u{cc6}",
                "ನಾಯ\u{cbf}ಮರ\u{cbf} ಕಣ\u{ccd}ಣುಗಳು",
                "ಬೇಡುತ\u{ccd}ತ\u{cbf}ರುವ",
                "ಮನವೊಲ\u{cbf}ಸುವ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("애원하는 얼굴"),
            keywords: &["글썽이는 눈", "애원하는", "애원하는 얼굴", "자비를 구하는"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विन\u{902}ती करपी च\u{947}रो"),
            keywords: &[
                "दया मागपी",
                "याचना करपी",
                "विन\u{902}ती करपी च\u{947}रो",
                "साव दोळ\u{947}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("капалуу жүз"),
            keywords: &[
                "капалуу жүз",
                "суранган",
                "ыйламсыраган көздөр",
                "ырайым сураган",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໃບໜ\u{ec9}າອ\u{ec9}ອນວອນ"),
            keywords: &[
                "ຕາຫ\u{ec9}ອຍໝານ\u{ec9}ອຍ",
                "ປານ\u{eb5}",
                "ຮ\u{ec9}ອງຂ\u{ecd}\u{ec9}",
                "ໃບໜ\u{ec9}າອ\u{ec9}ອນວອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("maldaujantis veidas"),
            keywords: &[
                "gailestingumas",
                "maldaujantis veidas",
                "maldavimas",
                "šuniuko akys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lūdzoša seja"),
            keywords: &["kucēna acis", "lūdzoša seja", "lūgšanās", "žēlastība"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице што моли"),
            keywords: &["кучешки очиња", "лице што моли", "милосрдие", "молење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യ\u{d3e}ചിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "ദയ",
                "ന\u{d3e}യ\u{d4d}\u{200c}ക\u{d41}ട\u{d4d}ടികള\u{d41}ടെ കണ\u{d4d}ണ\u{d41}കൾ",
                "യ\u{d3e}ചിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "യ\u{d3e}ചിക\u{d4d}ക\u{d41}ന\u{d4d}നത\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ямар нэг юм хүсч буй царай"),
            keywords: &[
                "гуйх",
                "ямар нэг юм хүсч буй царай",
                "өршөөх",
                "өрөвдөлтэй нүд",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विनवणी करणारा च\u{947}हरा"),
            keywords: &[
                "गर\u{94d}विष\u{94d}ठ डोळ\u{947}",
                "दया",
                "भीक मागण\u{947}",
                "विनवणी करणारा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka merayu"),
            keywords: &["kasihan", "memujuk", "muka merayu", "sayu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တောင\u{103a}းပန\u{103a}သော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ခ\u{103d}ေးပေါက\u{103a}အသ\u{103d}င\u{103a} ချစ\u{103a}စဖ\u{103d}ယ\u{103a} မျက\u{103a}လ\u{102f}\u{1036}း",
                "တောင\u{103a}းပန\u{103a}ခြင\u{103a}း",
                "တောင\u{103a}းပန\u{103a}သော မျက\u{103a}န\u{103e}ာ",
                "သက\u{103a}ည\u{103e}ာခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bedende fjes"),
            keywords: &["bedende fjes", "nåde", "trygler", "valpeøyne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विन\u{94d}ती गरिरह\u{947}को अन\u{941}हार"),
            keywords: &[
                "अन\u{941}रोध गरिरह\u{947}को",
                "छाउराको जस\u{94d}ता आ\u{901}खा",
                "दया",
                "विन\u{94d}ती गरिरह\u{947}को अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("smekend gezicht"),
            keywords: &["genade", "smeken", "smekend gezicht", "zielig gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bedande fjes"),
            keywords: &["bedande fjes", "kvalpeauge", "nåde", "tryglar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ନମ\u{b4d}ର ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଦୟ\u{b3e}",
                "ନ\u{b3f}ରୀହ ଆଖ\u{b3f}",
                "ବ\u{b3f}ନମ\u{b4d}ର ମ\u{b41}ହ\u{b01}",
                "ଭ\u{b3f}କ ମ\u{b3e}ଗ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਫ\u{a3c}ਾਈ ਦਿ\u{a70}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਤਰਲ\u{a47} ਕ\u{a71}ਢਦਾ ਚਿਹਰਾ",
                "ਦਿਆਲਤਾ",
                "ਮਾਸ\u{a42}ਮ ਚਿਹਰਾ",
                "ਸਫ\u{a3c}ਾਈ ਦਿ\u{a70}ਦਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Bẹ\u{301}g Fọ Sọ\u{301}mtin"),
            keywords: &[
                "Abẹg",
                "Fes Wé De Bẹ\u{301}g Fọ Sọ\u{301}mtin",
                "Píti",
                "Smọ\u{301}l Dọg Ai",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("błagająca twarz"),
            keywords: &["błagająca twarz", "błaganie", "litość", "słodkie oczy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("وکالت کوونکی مخ"),
            keywords: &[
                "ادعا کول",
                "رحم",
                "وکالت کوونکی مخ",
                "وکالت کوونکے مخ",
                "پپي سترګې",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto implorando"),
            keywords: &[
                "implorando",
                "olhar de cachorrinho",
                "perdão",
                "rosto implorando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara que implora"),
            keywords: &[
                "cara que implora",
                "cara suplicante",
                "implorar",
                "olhar de cachorrinho",
                "perdão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uyllasqa uya"),
            keywords: &["khuyakuy", "llullu uya", "uyllasqa uya", "uyllay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față rugătoare"),
            keywords: &[
                "față rugătoare",
                "implora",
                "milă",
                "ochi de cățeluș",
                "ruga",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-017"),
            keywords: &["E11-017"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("умоляет"),
            keywords: &["большие глаза", "глаза", "просит", "слезы", "умоляет"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دلڪش چهرو"),
            keywords: &["التجا ڪندڙ چهرو", "دلڪش چهرو", "رحم", "پنڻ", "پپي اکيون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කණග\u{dcf}ට\u{dd4}ය\u{dd2} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අන\u{dd4}කම\u{dca}ප\u{dcf}ව",
                "කණග\u{dcf}ට\u{dd4}ය\u{dd2} ම\u{dd4}හ\u{dd4}ණ",
                "බල\u{dd4} පැටව\u{dd6} ඇස\u{dca}",
                "ස\u{dd2}ඟ\u{dcf}කෑම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prosebná tvár"),
            keywords: &["prosebná tvár", "prosím", "psie oči", "zľutovanie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("proseč obraz"),
            keywords: &["kužkove oči", "milost", "moledovanje", "proseč obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji doodsan"),
            keywords: &[
                "baryid",
                "indho ilmeeynaayo",
                "naxariis",
                "waji doodaayo",
                "waji doodsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë qaramane"),
            keywords: &["fytyrë qaramane", "lutje", "mëshirë", "qaramane"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("молећиво лице"),
            keywords: &["милост", "молећиво лице", "молити", "псеће очи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("molećivo lice"),
            keywords: &["milost", "molećivo lice", "moliti", "pseće oči"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bönfallande ansikte"),
            keywords: &["bönfallande ansikte", "hundögon", "nåd", "tigga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaosihi"),
            keywords: &["macho yanayosihi", "onea huruma", "sihi", "uso unaosihi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கெஞ\u{bcd}சும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "இரஞ\u{bcd}சும\u{bcd}",
                "கருணை",
                "கெஞ\u{bcd}சும\u{bcd} கண\u{bcd}கள\u{bcd}",
                "கெஞ\u{bcd}சும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అభ\u{c4d}యర\u{c4d}థనగ\u{c3e} ముఖం ప\u{c46}ట\u{c4d}టడం"),
            keywords: &[
                "అందమ\u{c48}న కళ\u{c4d}లు",
                "అభ\u{c4d}యర\u{c4d}థన",
                "అభ\u{c4d}యర\u{c4d}థనగ\u{c3e} ముఖం ప\u{c46}ట\u{c4d}టడం",
                "కరుణ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าอ\u{e49}อนวอน"),
            keywords: &[
                "ขอความเห\u{e47}นใจ",
                "ขอร\u{e49}อง",
                "หน\u{e49}าอ\u{e49}อนวอน",
                "อ\u{e49}อนวอน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýalbarýan ýüz"),
            keywords: &["merhemet", "naýynjar gözler", "ýalbarmak", "ýalbarýan ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata kole"),
            keywords: &["mata kole"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yalvaran yüz"),
            keywords: &["acıklı bakışlar", "merhamet", "yalvaran yüz", "yalvarma"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("благальне обличчя"),
            keywords: &[
                "благальне обличчя",
                "благати",
                "випрошувати",
                "молити",
                "просити",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ملتجی چہرہ"),
            keywords: &["التجا کرنا", "رحم", "طفلانہ آنکھیں", "ملتجی چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yalingan yuz"),
            keywords: &[
                "iltimos qilish",
                "katta ko‘zlar",
                "ko‘z",
                "ko‘z yosh",
                "yalingan yuz",
                "yalinish",
                "yolvorish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cầu xin"),
            keywords: &["lòng thương", "mắt cún con", "mặt cầu xin", "xin xỏ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("懇求嘅臉"),
            keywords: &["乞討", "小狗嘅眼睛", "憐憫", "懇求嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("恳求嘅脸"),
            keywords: &["乞讨", "小狗嘅眼睛", "怜悯", "恳求嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("恳求的脸"),
            keywords: &["可怜兮兮的眼神", "怜悯", "恳求的脸", "祈求"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("請求的臉"),
            keywords: &["拜託", "求求你", "無辜臉", "請求的臉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("請求嘅樣"),
            keywords: &["拜託", "求求你", "無辜嘅樣", "請求嘅樣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("pleading face"),
            keywords: &["begging", "mercy", "pleading face", "puppy eyes"],
        },
    ],
};
#[doc = "😦"]
pub const FROWNING_FACE_WITH_OPEN_MOUTH: crate::Emoji = crate::Emoji {
    glyph: "😦",
    codepoint: "1F626",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "frowning face with open mouth",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fronsende gesig met oop mond"),
            keywords: &[
                "frons",
                "fronsende gesig met oop mond",
                "gesig",
                "mond",
                "oop",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፉ የተከፈተ የተኮሳተረ ፊት"),
            keywords: &["አፉ የተከፈተ የተኮሳተረ ፊት", "አፍ", "ክፍት", "የተኮሳተረ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه عابس بفم مفتوح"),
            keywords: &[
                "عبوس",
                "عبوس بفم مفتوح",
                "فم مفتوح",
                "\u{202b}وجه عابس بفم مفتوح",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খোল\u{9be} ম\u{9c1}খেৰে ভ\u{9cd}ৰ\u{9be}ন\u{9cd}ত চেহেৰ\u{9be}"),
            keywords: &[
                "খোল\u{9be}",
                "খোল\u{9be} ম\u{9c1}খেৰে ভ\u{9cd}ৰ\u{9be}ন\u{9cd}ত চেহেৰ\u{9be}",
                "ভ\u{9cd}ৰ\u{9be}ন\u{9cd}ত",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağzı açıq qaşqabaqlı üz"),
            keywords: &[
                "açıq",
                "ağzı açıq qaşqabaqlı üz",
                "ağız",
                "qaşqabaqlı",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("засмучаны твар з адкрытым ротам"),
            keywords: &[
                "адкрыты",
                "засмучаны твар з адкрытым ротам",
                "засмучэнне",
                "нахмураны",
                "рот",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Намръщено лице с отворена уста"),
            keywords: &[
                "Намръщено лице с отворена уста",
                "гримаса",
                "лице",
                "отворен",
                "уста",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "খোল\u{9be} ম\u{9c1}খের স\u{9be}থে ভ\u{9cd}র\u{9c1}ক\u{9c1}টি ম\u{9c1}খমণ\u{9cd}ডল",
            ),
            keywords: &[
                "খোল\u{9be}",
                "খোল\u{9be} ম\u{9c1}খের স\u{9be}থে ভ\u{9cd}র\u{9c1}ক\u{9c1}টি ম\u{9c1}খমণ\u{9cd}ডল",
                "ঠো\u{981}ট",
                "ভ\u{9cd}র\u{9c2} ক\u{9c1}চ\u{981}ক\u{9be}নো",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("namrštenost s otvorenim ustima"),
            keywords: &[
                "mrštenje",
                "namrštenost s otvorenim ustima",
                "otvorena",
                "usta",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara emmurriada amb la boca oberta"),
            keywords: &[
                "boca oberta",
                "cara",
                "cara emmurriada amb la boca oberta",
                "emmurriada",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᏁᎪᏳᎲᎢ ᎤᎧᏛ ᎤᏔᏠᎩ"),
            keywords: &["ᎠᎰᎵ", "ᎠᏍᏚᎢᏓ", "ᎤᎧᏛ", "ᎤᏓᏁᎪᏳ", "ᎤᏓᏁᎪᏳᎲᎢ ᎤᎧᏛ ᎤᏔᏠᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamračený obličej s otevřenou pusou"),
            keywords: &[
                "otevřený",
                "smajlík",
                "tvář",
                "výraz",
                "zamračení",
                "zamračený obličej s otevřenou pusou",
                "ústa",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb gwgus â cheg agored"),
            keywords: &["agored", "ceg", "gwg", "wyneb", "wyneb gwgus â cheg agored"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("måbende ansigt med åben mund"),
            keywords: &["ansigt", "måbende ansigt med åben mund", "åben mund"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("entsetztes Gesicht"),
            keywords: &[
                "Gesicht",
                "entsetztes Gesicht",
                "offener Mund",
                "verwundert",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσούφιασμα με ανοικτό στόμα"),
            keywords: &[
                "ανοιχτό",
                "κατσούφιασμα",
                "κατσούφιασμα με ανοικτό στόμα",
                "πρόσωπο",
                "στόμα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("frowning face with open mouth"),
            keywords: &[
                "face",
                "frown",
                "frowning face with open mouth",
                "mouth",
                "open",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con el ceño fruncido y la boca abierta"),
            keywords: &[
                "boca abierta",
                "cara",
                "cara con el ceño fruncido y la boca abierta",
                "ceño fruncido con boca abierta",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara boquiabierta"),
            keywords: &["abierta", "boca", "cara", "cara boquiabierta"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara con el ceño fruncido y la boca abierta"),
            keywords: &[
                "abierta",
                "boca",
                "cara",
                "cara con el ceño fruncido y la boca abierta",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara con el ceño fruncido y la boca abierta"),
            keywords: &[
                "abierta",
                "boca",
                "cara",
                "cara con el ceño fruncido y la boca abierta",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud suuga mossitav nägu"),
            keywords: &[
                "avatud",
                "avatud suuga mossitav nägu",
                "mossis",
                "nägu",
                "suu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopeta ilun eta ahoa zabalik duen aurpegia"),
            keywords: &[
                "aho",
                "aurpegi",
                "ireki",
                "kopeta ilun eta ahoa zabalik duen aurpegia",
                "kopeta ilunduta eta ahoa irekita duen aurpegia",
                "kopetilun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ناباور"),
            keywords: &[
                "اخم",
                "باز",
                "باورنکردنی",
                "توقع نداشتن",
                "دهان",
                "صورت",
                "ناباور",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("surullinen ja suu auki"),
            keywords: &[
                "auki",
                "naama",
                "surullinen",
                "surullinen ja suu auki",
                "suu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakasimangot nang nakanganga"),
            keywords: &[
                "bibig",
                "mukha",
                "nakanganga",
                "nakasimangot",
                "nakasimangot nang nakanganga",
                "nalulumbay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skelka andlit"),
            keywords: &["andlit", "skelka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage mécontent avec bouche ouverte"),
            keywords: &[
                "bouche",
                "déçu",
                "ouverte",
                "visage",
                "visage mécontent avec bouche ouverte",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bouche",
                "béante",
                "ouverte",
                "renfrogné",
                "visage",
                "visage mécontent avec bouche ouverte",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseag ghruama le béal oscailte"),
            keywords: &[
                "aghaidh",
                "ar oscailt",
                "béal",
                "grainc",
                "straoiseag ghruama le béal oscailte",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le drèin is beul fosgailte"),
            keywords: &[
                "aodann",
                "aodann le drèin is beul fosgailte",
                "beul",
                "drèin",
                "fosgailte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara triste coa boca aberta"),
            keywords: &[
                "aberta",
                "boca",
                "cara",
                "cara triste coa boca aberta",
                "triste",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "ખ\u{ac1}લ\u{acd}લા\u{a82} મો\u{a82}ઢા સાથ\u{ac7} ભવા\u{a82} ચડાવતો ચહ\u{ac7}રો",
            ),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા\u{a82} મો\u{a82}ઢા સાથ\u{ac7} ભવા\u{a82} ચડાવતો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
                "ભવા\u{a82}",
                "મ\u{ac1}ખ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai gama gira tare da baki a buɗe"),
            keywords: &[
                "a buɗe",
                "baki",
                "fuska",
                "fuska mai gama gira tare da baki a buɗe",
                "gama gira",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עצוב עם פה פתוח"),
            keywords: &["עצוב", "פה", "פרצוף", "פרצוף עצוב עם פה פתוח", "פתוח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some(
                "ख\u{941}ल\u{947} म\u{941}\u{901}ह वाला त\u{94d}यौरी चढ\u{93c}ाता च\u{947}हरा",
            ),
            keywords: &[
                "ख\u{941}ला म\u{941}\u{902}ह",
                "ख\u{941}ल\u{947} म\u{941}\u{901}ह वाला त\u{94d}यौरी चढ\u{93c}ाता च\u{947}हरा",
                "ख\u{941}ल\u{947} म\u{941}\u{902}ह स\u{947} त\u{94d}यौरी चढ\u{93c}ाना",
                "च\u{947}हरा",
                "त\u{94d}यौरी",
                "त\u{94d}यौरी चढ\u{93c}ाना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("namrgođeno lice s otvorenim ustima"),
            keywords: &[
                "lice",
                "mrgođenje",
                "namrgođeno lice s otvorenim ustima",
                "otvoreno",
                "usta",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rosszalló arc nyitott szájjal"),
            keywords: &[
                "arc",
                "nyitott száj",
                "rosszallás",
                "rosszalló arc nyitott szájjal",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց բերանով խոժոռված դեմք"),
            keywords: &["բաց", "բաց բերանով խոժոռված դեմք", "բերան", "խոժոռ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah mengerutkan kening dengan mulut terbuka"),
            keywords: &[
                "cemberut",
                "muka",
                "mulut",
                "nganga",
                "terbuka",
                "wajah",
                "wajah mengerutkan kening dengan mulut terbuka",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu mgbarụ nwere mmepe ọnụ"),
            keywords: &[
                "ihu",
                "ihu mgbarụ nwere mmepe ọnụ",
                "mgbarụ",
                "mmepe",
                "ọnụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("leitt andlit"),
            keywords: &[
                "andlit",
                "leitt andlit",
                "leitt andlit opinn munn",
                "leiði",
                "opinn munnur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina imbronciata con bocca aperta"),
            keywords: &[
                "bocca aperta",
                "corrucciata",
                "corrucciata con bocca aperta",
                "faccina",
                "faccina imbronciata con bocca aperta",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あきれ顔"),
            keywords: &["あきれ顔", "しかめ面", "しかめ顔", "不本意", "不満", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai sedhih karo mlongo"),
            keywords: &[
                "cangkem",
                "menga",
                "rai",
                "rai sedhih karo mlongo",
                "sedhih",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჭმუხნილი სახე ღია პირით"),
            keywords: &[
                "პირი",
                "პირღია",
                "სახე",
                "ღია",
                "შეკრული",
                "შეჭმუხნილი",
                "შეჭმუხნილი სახე ღია პირით",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аузын ашып, бұртию"),
            keywords: &["аузын ашып, бұртию", "ауыз", "ашық", "бет", "бұртию"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("måbende ansigt med åben mund"),
            keywords: &[
                "ansigt",
                "måbende ansigt med åben mund",
                "rynkede bryn",
                "åben mund",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17d2}រៀមក\u{17d2}រ\u{17c6}ហើយច\u{17c6}ហមាត\u{17cb}"),
            keywords: &[
                "ក\u{17d2}រៀមក\u{17d2}រ\u{17c6}",
                "ម\u{17bb}ខក\u{17d2}រៀមក\u{17d2}រ\u{17c6}ហើយច\u{17c6}ហមាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಯ\u{cbf} ತ\u{cc6}ರ\u{cc6}ದು ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ",
                "ತ\u{cc6}ರ\u{cc6}ದ\u{cbf}ರುವುದು",
                "ಬಾಯ\u{cbf}",
                "ಬಾಯ\u{cbf} ತ\u{cc6}ರ\u{cc6}ದು ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ಮುಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("입 벌리고 찌푸린 얼굴"),
            keywords: &["얼굴", "입 벌리고 찌푸린 얼굴", "찌푸린 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उकत\u{94d}या तो\u{902}डाचो तिडकल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "उकत\u{947}\u{902}",
                "उकत\u{94d}या तो\u{902}डाचो तिडकल\u{94d}लो च\u{947}रो",
                "च\u{947}रो",
                "तिडक",
                "तो\u{902}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оозун аңырдай ачкан бет"),
            keywords: &["ач", "аңырдай", "бет", "ооз", "оозун аңырдай ачкан бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("d’Stir fronzend Gesiicht mat oppenem Mond"),
            keywords: &[
                "Gesiicht",
                "Mond",
                "Stir fronzen",
                "d’Stir fronzend Gesiicht mat oppenem Mond",
                "oppen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງອ\u{ec9}າປາກ"),
            keywords: &[
                "ປາກ",
                "ຫຍ\u{eb8}\u{ec9}ງ",
                "ອ\u{ec9}າ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງອ\u{ec9}າປາກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paniuręs išsižiojęs veidas"),
            keywords: &["burna", "išsižiojęs", "paniuręs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bēdīga seja ar atvērtu muti"),
            keywords: &[
                "atvērts",
                "bēdas",
                "bēdīga seja ar atvērtu muti",
                "mute",
                "seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi poururu waha tuwhera"),
            keywords: &["kanohi", "poururu", "tuwhera", "waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("намуртено лице со отворена уста"),
            keywords: &[
                "лице",
                "намуртено",
                "намуртено лице со отворена уста",
                "отворена",
                "уста",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d41}റന\u{d4d}നവ\u{d3e}യയ\u{d41}മ\u{d3e}യി നീരസ ഭ\u{d3e}വത\u{d4d}തില\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
            ),
            keywords: &[
                "ത\u{d41}റന\u{d4d}ന",
                "ത\u{d41}റന\u{d4d}നവ\u{d3e}യയ\u{d41}മ\u{d3e}യി നീരസ ഭ\u{d3e}വത\u{d4d}തില\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "നീരസം",
                "മ\u{d41}ഖം",
                "മ\u{d41}ഖം ച\u{d41}ളിക\u{d4d}ക\u{d41}ക",
                "വ\u{d3e}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гайхсан дурамжхан царай"),
            keywords: &["гайхсан", "дурамжхан", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उघड\u{94d}या तो\u{902}डाचा आठ\u{94d}या असल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "आठ\u{94d}या",
                "आठ\u{94d}या असल\u{947}ला च\u{947}हरा",
                "उघडा",
                "उघड\u{94d}या तो\u{902}डाचा आठ\u{94d}या असल\u{947}ला च\u{947}हरा",
                "च\u{947}हरा",
                "तो\u{902}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka berkerut dengan mulut ternganga"),
            keywords: &[
                "berkerut",
                "muka",
                "muka berkerut dengan mulut ternganga",
                "mulut",
                "terbuka",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imkemmex b’ħalq miftuħ"),
            keywords: &[
                "imkemmex",
                "tiftaħ",
                "wiċċ",
                "wiċċ imkemmex b’ħalq miftuħ",
                "ħalq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေကာ ပါးစပ\u{103a}ဟထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ပါးစပ\u{103a}",
                "ပါးစပ\u{103a}ဟ၍ မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}ထားသော မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}ခြင\u{103a}း",
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေကာ ပါးစပ\u{103a}ဟထားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဟနေသည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("oppgitt"),
            keywords: &["fjes", "oppgitt", "overrasket", "sjokkert med åpen munn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला म\u{941}ख भएको रिसाएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ख\u{941}ला",
                "ख\u{941}ला म\u{941}ख भएको रिसाएको अन\u{941}हार",
                "त\u{947}वर",
                "म\u{941}ख",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fronsend gezicht met open mond"),
            keywords: &[
                "frons",
                "fronsend gezicht met open mond",
                "gezicht",
                "mond",
                "open",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("oppgjeven"),
            keywords: &["fjes", "oppgjeven", "overraska", "sjokkert med open munn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b3e}ଟ\u{b3f} ଖୋଲ\u{b3e}ଥ\u{b3f}ବ\u{b3e} ସହ\u{b3f}ତ ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "କ\u{b4d}ରୋଧ",
                "ଖୋଲ\u{b3e}",
                "ପ\u{b3e}ଟ\u{b3f}",
                "ପ\u{b3e}ଟ\u{b3f} ଖୋଲ\u{b3e}ଥ\u{b3f}ବ\u{b3e} ସହ\u{b3f}ତ ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਨਾਲ ਨਰਾਜ\u{a3c} ਚਿਹਰਾ"),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲਿਆ ਮ\u{a42}\u{a70}ਹ",
                "ਖ\u{a41}\u{a71}ਲ\u{a47} ਮ\u{a42}\u{a70}ਹ ਨਾਲ ਨਰਾਜ\u{a3c} ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਨਾਲ ਨਰਾਜ\u{a3c} ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਨਰਾਜ\u{a3c} ਹ\u{a4b}ਣਾ",
                "ਨਰਾਾਜ\u{a3c} ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھلے منہ نال تیوری آلی شکل"),
            keywords: &[
                "تیوری چڑھونا",
                "دی شکل",
                "منہ",
                "ک\u{64f}ھلا",
                "کھلے منہ نال تیوری آلی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Fraún Wit Ópún Maut"),
            keywords: &[
                "Fes",
                "Fes Wé De Fraún Wit Ópún Maut",
                "Fraun",
                "Maut",
                "Ópun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zachmurzona twarz z otwartymi ustami"),
            keywords: &[
                "rozzłoszczona buźka",
                "zachmurzona twarz z otwartymi ustami",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د تريو تندې او خلاصې خولې مخ"),
            keywords: &["د تريو تندې او خلاصې خولې مخ", "د خلاصې خولې سره ځړونکی مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto franzido com boca aberta"),
            keywords: &[
                "aberta",
                "boca",
                "rosto assustado",
                "rosto franzido com boca aberta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara franzida com boca aberta"),
            keywords: &[
                "aberta",
                "boca",
                "cara",
                "cara franzida com boca aberta",
                "sobrolho franzido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("añasqa uya kichasqa simiwan"),
            keywords: &[
                "añasqa uya kichasqa simiwan",
                "añay",
                "kichay",
                "simi",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față tristă cu gura deschisă"),
            keywords: &[
                "față",
                "față tristă cu gura deschisă",
                "gură deschisă",
                "întristare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-874"),
            keywords: &["E10-874"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в изумлении"),
            keywords: &[
                "в изумлении",
                "изумление",
                "лицо",
                "открыт",
                "рот",
                "удивление",
                "хмурый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kutishima n’umunwa wasamye"),
            keywords: &[
                "gufungura",
                "isura",
                "isura igaragaza kutishima n’umunwa wasamye",
                "kurakara",
                "umunwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کليل وات سان اداس چهرو"),
            keywords: &[
                "ناپسنديدگي",
                "وات",
                "چهرو",
                "کليل",
                "کليل وات سان اداس چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට ඇර\u{dd4}ණ රවන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "කට",
                "කට ඇර\u{dd4}ණ රවන ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "රැව\u{dd3}ම",
                "ව\u{dd2}වෘත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zamračená tvár s otvorenými ústami"),
            keywords: &[
                "otvorené",
                "tvár",
                "zamračená",
                "zamračená tvár s otvorenými ústami",
                "ústa",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("namrščen obraz z odprtimi usti"),
            keywords: &[
                "namrščen obraz z odprtimi usti",
                "namrščenost",
                "obraz",
                "odprto",
                "usta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji macbuus af furan leh"),
            keywords: &[
                "afka",
                "fur",
                "macbuus",
                "waji",
                "waji macbuus af furan leh",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e vrenjtur me gojë të hapur"),
            keywords: &[
                "e hapur",
                "e vrenjtur",
                "fytyrë",
                "fytyrë e vrenjtur me gojë të hapur",
                "gojë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зачуђено лице"),
            keywords: &["oтвoрeнo", "зачуђено лице", "зачуђеност", "лице", "уста"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("začuđeno lice"),
            keywords: &["lice", "otvoreno", "usta", "začuđeno lice", "začuđenost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ogillande ansikte med öppen mun"),
            keywords: &["bister", "ogillande ansikte med öppen mun", "öppen mun"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso ulionuna wenye mdomo uliofunguliwa"),
            keywords: &[
                "funguliwa",
                "kununa",
                "mdomo",
                "uso",
                "uso ulionuna wenye mdomo uliofunguliwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "கண\u{bcd}களும\u{bcd} வ\u{bbe}யும\u{bcd} திறந\u{bcd}த நிலையில\u{bcd} இருக\u{bcd}கும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "இல\u{bcd}லை",
                "கண\u{bcd}களும\u{bcd} வ\u{bbe}யும\u{bcd} திறந\u{bcd}த நிலையில\u{bcd} இருக\u{bcd}கும\u{bcd} முகம\u{bcd}",
                "கண\u{bcd}களும\u{bcd} வ\u{bbe}யும\u{bcd} திறந\u{bcd}துள\u{bcd}ள முகம\u{bcd}",
                "சிடுசிடுப\u{bcd}பு",
                "வேண\u{bcd}ட\u{bbe}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} క\u{c4b}పంగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "క\u{c4b}పం",
                "న\u{c4b}రు",
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} క\u{c4b}పంగ\u{c3e} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи турш бо даҳони кушода"),
            keywords: &[
                "даҳон",
                "кушода",
                "рӯи турш бо даҳони кушода",
                "рӯй",
                "қавоқ андохтан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าบ\u{e36}\u{e49}งอ\u{e49}าปาก"),
            keywords: &[
                "บ\u{e36}\u{e49}ง",
                "หน\u{e49}า",
                "หน\u{e49}าบ\u{e36}\u{e49}งอ\u{e49}าปาก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk agyzly çytyk ýüz"),
            keywords: &["agyz", "açyk", "açyk agyzly çytyk ýüz", "çytmak", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fingo moe ngutu fakamanga"),
            keywords: &["mata fingo moe ngutu fakamanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hoşnutsuz yüz"),
            keywords: &["açık ağızlı hoşnutsuz yüz", "ağzı açık", "hoşnutsuz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزىنى ئېچىپ قوشۇمىسىنى تۈرگەن چىراي"),
            keywords: &[
                "ئاغزىنى ئېچىپ قوشۇمىسىنى تۈرگەن چىراي",
                "ئوچۇق",
                "ئېغىز",
                "قوشۇما",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("похмуре обличчя з відкритим ротом"),
            keywords: &[
                "відкритий",
                "нахмурений",
                "обличчя",
                "похмуре обличчя з відкритим ротом",
                "рот",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ کھولے تیوری چڑھاتا چہرہ"),
            keywords: &[
                "تیوری",
                "منہ",
                "منہ کھولے تیوری چڑھاتا چہرہ",
                "چہرہ",
                "کھلا ہوا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zini katta ochgan, qovog‘i solingan yuz"),
            keywords: &[
                "ochiq",
                "og‘iz",
                "og‘zini katta ochgan, qovog‘i solingan yuz",
                "qovog‘ini solish",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt cau miệng há"),
            keywords: &["miệng", "mặt", "mặt cau miệng há", "mở", "nhăn mặt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu ànd ak yéen yu lemu ak gémmiñ gu ubbiku"),
            keywords: &[
                "aj ay yéen",
                "gémmiñ",
                "kanam",
                "kanam gu ànd ak yéen yu lemu ak gémmiñ gu ubbiku",
                "ubbeeku",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obufinge iintshiya obuvule umlomo"),
            keywords: &[
                "finga iintshiya",
                "ivulekile",
                "ubuso",
                "ubuso obufinge iintshiya obuvule umlomo",
                "umlomo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti o Faro Pẹlu Ẹnu lila silẹ"),
            keywords: &[
                "Oju Ti o Faro Pẹlu Ẹnu lila silẹ",
                "fajúro",
                "ojú",
                "ṣí",
                "ẹnu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("開口皺眉嘅臉"),
            keywords: &["嘴", "打開", "皺眉", "臉", "開口皺眉嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("开口皱眉嘅脸"),
            keywords: &["嘴", "开口皱眉嘅脸", "打开", "皱眉", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("啊"),
            keywords: &["啊", "惊讶", "目瞪口呆", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("啊"),
            keywords: &["啊", "目瞪口呆"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("皺眉掰大口"),
            keywords: &["受到驚嚇", "擔心", "皺眉掰大口", "驚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obubiphile obuvule umlomo"),
            keywords: &[
                "bipha",
                "ubuso",
                "ubuso obubiphile obuvule umlomo",
                "umlomo",
                "vula",
            ],
        },
    ],
};
#[doc = "😧"]
pub const ANGUISHED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😧",
    codepoint: "1F627",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "anguished face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("beangste gesig"),
            keywords: &["beangs", "beangste gesig", "gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተማሮ የሚያለቅስ ፊት"),
            keywords: &["ተማሮ የሚያለቅስ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مكروب"),
            keywords: &["تألم", "وجه مكروب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9c1}খী ম\u{9c1}খ"),
            keywords: &["দ\u{9c1}খী", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kədərli üz"),
            keywords: &["kədərli", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пакутлівы твар"),
            keywords: &["пакута", "пакутлівы твар", "туга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изстрадало лице"),
            keywords: &["Изстрадало лице", "изстрадал", "лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উদ\u{9cd}বেগপ\u{9c2}র\u{9cd}ণ ম\u{9c1}খ"),
            keywords: &[
                "উদ\u{9cd}বেগপ\u{9c2}র\u{9cd}ণ ম\u{9c1}খ",
                "বেদন\u{9be}র\u{9cd}ত",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("izmučenost"),
            keywords: &["izmučenost", "lice", "mučenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara d’angoixa"),
            keywords: &["angoixa", "angoixada", "angoixat", "cara", "cara d’angoixa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎩᏟᏲᎬᎢ ᎤᎧᏛ"),
            keywords: &["ᎠᎩᏟᏲᎬᎢ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s úzkostným výrazem"),
            keywords: &[
                "nepříjemný",
                "obličej s úzkostným výrazem",
                "překvapení",
                "smajlík",
                "trpící",
                "tvář",
                "utrpení",
                "utrápený",
                "výraz",
                "ztrápený",
                "úzkost",
                "šok",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb dirboen"),
            keywords: &["dirboen", "ing", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("forpint ansigt"),
            keywords: &["ansigt", "forpint ansigt", "lider", "smerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("qualvolles Gesicht"),
            keywords: &["Gesicht", "leidend", "qualvolles Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγωνία"),
            keywords: &["αγωνία", "αγωνιώδης", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("anguished face"),
            keywords: &["anguished", "face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara angustiada"),
            keywords: &["angustia", "angustiado", "cara", "cara angustiada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de angustia"),
            keywords: &["angustiado", "cara", "cara de angustia", "sufrir"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara angustiada"),
            keywords: &["cara angustiada"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara angustiada"),
            keywords: &["cara angustiada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ahastuses nägu"),
            keywords: &["ahastus", "ahastuses nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("estutasun-aurpegia"),
            keywords: &["aurpegi", "estutasun", "estutasun-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دردمند"),
            keywords: &["دردمند", "صورت", "مضطرب", "نگران"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ahdistunut"),
            keywords: &["ahdistunut", "ahdistus", "hätä", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagdurusa"),
            keywords: &["mukha", "nagdurusa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pínt andlit"),
            keywords: &["andlit", "pínt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage angoissé"),
            keywords: &["angoisse", "visage", "visage angoissé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog chráite"),
            keywords: &["aghaidh", "cráite", "straoiseog chráite"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann àmhghair"),
            keywords: &["aodann", "aodann àmhghair", "àmhghar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de angustia"),
            keywords: &["angustia", "cara", "cara de angustia", "sufrimento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દ\u{ac1}ઃખી ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "દ\u{ac1}ઃખી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai tagayyara"),
            keywords: &["fuska", "fuska mai tagayyara", "mai tagayyara"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מיוסר"),
            keywords: &["מיוסר", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{941}खी च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "द\u{941}खमय",
                "द\u{941}खी च\u{947}हरा",
                "पीड\u{93c}ा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("izmučeno lice"),
            keywords: &["izmučeno lice", "izmučenost", "lice", "muka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("elkínzott arc"),
            keywords: &["arc", "elgyötört", "elkínzott"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վշտահար դեմք"),
            keywords: &["դեմք", "վշտահար"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah menderita"),
            keywords: &["menderita", "merana", "muka", "sengsara", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere ọnụma"),
            keywords: &["ihu", "ihu nwere ọnụma", "nwere ọnụma"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("angistarfullt andlit"),
            keywords: &["andlit", "angist", "angistarfullt andlit", "kvalir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina angosciata"),
            keywords: &["angosciata", "faccina", "sofferente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("苦悩"),
            keywords: &["苦悩", "苦悶", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kaget lan kuciwa"),
            keywords: &["kaget lan kuciwa", "rai", "rai kaget lan kuciwa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტანჯული სახე"),
            keywords: &["სახე", "ტანჯული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қиналу"),
            keywords: &["бет", "қиналу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("forpint ansigt"),
            keywords: &["ansigt", "forpint ansigt", "lider", "smerte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខរន\u{17d2}ធត\u{17cb}"),
            keywords: &[
                "ភ\u{17d0}យ",
                "ម\u{17bb}ខរន\u{17d2}ធត\u{17cb}",
                "រន\u{17d2}ធត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಳವಳದ ಮುಖ"),
            keywords: &["ಕಳವಳದ ಮುಖ", "ಸಂಕಟದ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("괴로워하는 얼굴"),
            keywords: &["괴로움", "괴로워하는 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यथीत च\u{947}रो"),
            keywords: &["च\u{947}रो", "व\u{94d}यथीत"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("делдейип калган бет"),
            keywords: &["бет", "делдей", "делдейип калган бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gequäält Gesiicht"),
            keywords: &["Gesiicht", "gequäält"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເຈ\u{eb1}ບປວດ"),
            keywords: &["ເຈ\u{eb1}ບປວດ", "ໜ\u{ec9}າ", "ໜ\u{ec9}າເຈ\u{eb1}ບປວດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kenčiantis veidas"),
            keywords: &["kenčiantis", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sāpjpilna seja"),
            keywords: &["pārsteigt", "seja", "sāpes", "sāpināt", "sāpjpilna seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi aurere"),
            keywords: &["aurere", "kanohi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице во очај"),
            keywords: &["лице", "лице во очај", "очајно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മനോവേദന നിറഞ\u{d4d}ഞ മ\u{d41}ഖം"),
            keywords: &[
                "മനോവേദന നിറഞ\u{d4d}ഞ",
                "മനോവേദന നിറഞ\u{d4d}ഞ മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шаналсан царай"),
            keywords: &["царай", "шаналсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}याक\u{942}ळ च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "व\u{94d}याक\u{942}ळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka merana"),
            keywords: &["merana", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imdejjaq ħafna"),
            keywords: &["imdejjaq ħafna", "wiċċ", "wiċċ imdejjaq ħafna"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မချ\u{102d}တင\u{103a}က\u{1032} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "မချ\u{102d}တင\u{103a}က\u{1032} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("pine"),
            keywords: &["fjes", "lider", "pine", "smerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("द\u{941}:खी अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "द\u{941}:खी अन\u{941}हार", "द\u{941}खी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gekweld gezicht"),
            keywords: &["gekweld gezicht", "gezicht", "lijdend"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("pine"),
            keywords: &["fjes", "lir", "pine", "smerte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟଥ\u{b3f}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ବ\u{b4d}ୟଥ\u{b3f}ତ", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a41}ਖੀ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਦ\u{a41}ਖੀ ਚਿਹਰਾ",
                "ਦ\u{a41}\u{a71}ਖ ਹ\u{a4b} ਰਿਹਾ",
                "ਦ\u{a41}\u{a71}ਖੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("د\u{64f}کھی شکل"),
            keywords: &["د\u{64f}کھی", "د\u{64f}کھی شکل", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Sọ\u{301}mtin De Pén Wẹ\u{301}l Wẹl"),
            keywords: &[
                "Fes",
                "Fes Wé Sọ\u{301}mtin De Pén Wẹ\u{301}l Wẹl",
                "Fọ Sọ\u{301}mtin To Pén Pẹ\u{301}sin Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("udręczona twarz"),
            keywords: &["udręczona twarz", "złość"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کړوونکی مخ"),
            keywords: &["مخ", "کړوونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto angustiado"),
            keywords: &["rosto", "rosto angustiado", "sofrendo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara angustiada"),
            keywords: &["angustiado", "cara", "cara angustiada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñakʼari uya"),
            keywords: &["ñakʼari uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față angoasată"),
            keywords: &["angoasă", "față", "față angoasată", "stres"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-875"),
            keywords: &["E10-875"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("страдает"),
            keywords: &[
                "боль",
                "лицо",
                "муки",
                "плохо",
                "страдает",
                "страдание",
                "тоска",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza inkeke"),
            keywords: &["inkeke", "isura igaragaza", "isura igaragaza inkeke"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڏکايل چهرو"),
            keywords: &["چهرو", "ڏکايل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වේදන\u{dcf}වට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "වේදන\u{dcf}ව",
                "වේදන\u{dcf}වට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("utrápená tvár"),
            keywords: &["tvár", "utrápená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trpeč obraz"),
            keywords: &["obraz", "trpeč obraz", "trpeče"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji xanaaqsan"),
            keywords: &["waji", "waji xanaaqsan", "xanaaq"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë në ankth"),
            keywords: &["fytyrë", "fytyrë në ankth", "në ankth"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("избезумљено лице"),
            keywords: &[
                "запањеност",
                "избезумљено лице",
                "избезумљеност",
                "изненађење",
                "лице",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["избезумљено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("izbezumljeno lice"),
            keywords: &[
                "izbezumljeno lice",
                "izbezumljenost",
                "iznenađenje",
                "lice",
                "zapanjenost",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["izbezumljeno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("plågat ansikte"),
            keywords: &["lider", "plågat ansikte", "ångest"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaoonyesha uchungu"),
            keywords: &["uchungu", "uso", "uso unaoonyesha uchungu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அதிர\u{bcd}ச\u{bcd}சி முகம\u{bcd}"),
            keywords: &[
                "அதிர\u{bcd}ச\u{bcd}சி",
                "அதிர\u{bcd}ச\u{bcd}சிய\u{bbe}ன முகம\u{bcd}",
                "மன உளைச\u{bcd}சல\u{bcd}",
                "முகம\u{bcd}",
                "வேதனை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}దనత\u{c4b} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "న\u{c3f}రుత\u{c4d}స\u{c3e}హం",
                "భయం",
                "ముఖం",
                "వ\u{c47}దనత\u{c4b} ఉన\u{c4d}న ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи дилтанг"),
            keywords: &["дилтанг", "рӯи дилтанг", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าเจ\u{e47}บปวด"),
            keywords: &["หน\u{e49}า", "หน\u{e49}าเจ\u{e47}บปวด", "เจ\u{e47}บปวด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jebir çekýän ýüz"),
            keywords: &["jebir çekýän", "jebir çekýän ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lotomamahi"),
            keywords: &["mata lotomamahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kederli yüz"),
            keywords: &["acı çeken", "kederli yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئازابلىق چىراي"),
            keywords: &["ئازابلىق", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стражденне обличчя"),
            keywords: &["обличчя", "страждання", "стражденне обличчя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تکلیف زدہ چہرہ"),
            keywords: &["تکلیف", "تکلیف زدہ چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("g‘am-tashvishli yuz"),
            keywords: &["g‘am-tashvishli yuz", "tashvishli", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt đau khổ"),
            keywords: &["mặt", "mặt đau khổ", "đau khổ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu xawa jaaxle"),
            keywords: &["kanam", "kanam gu xawa jaaxle", "xawa jaaxle"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obulusizi"),
            keywords: &["ubuso", "ubuso obulusizi", "usizi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú ìrora"),
            keywords: &["ojú", "ìrora"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("苦惱嘅臉"),
            keywords: &["臉", "苦惱", "苦惱嘅臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("苦恼嘅脸"),
            keywords: &["脸", "苦恼", "苦恼嘅脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("极度痛苦"),
            keywords: &["极度痛苦", "痛", "脸", "难受"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("痛"),
            keywords: &["痛", "難受"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("苦埋口面"),
            keywords: &["苦埋口面", "難受"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuxakekile"),
            keywords: &["ubuso", "ubuso obuxakekile", "ukuxakela"],
        },
    ],
};
#[doc = "😨"]
pub const FEARFUL_FACE: crate::Emoji = crate::Emoji {
    glyph: "😨",
    codepoint: "1F628",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "fearful face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bang gesig"),
            keywords: &["bang", "bevrees", "gesig", "vrees"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ፍርሃት የተሞላ ፊት"),
            keywords: &["የፈራ", "ፈሪ", "ፊት", "ፍርሃት", "ፍርሃት የተሞላ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه خائف"),
            keywords: &["مرعوب", "\u{202b}وجه خائف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভয\u{9bc}ভীত চেহেৰ\u{9be}"),
            keywords: &[
                "ভয\u{9bc}",
                "ভয\u{9bc}ভীত চেহেৰ\u{9be}",
                "ভ\u{9be}য\u{9bc}\u{9be}ৰ\u{9cd}ত",
                "ভীতিপ\u{9c2}ৰ\u{9cd}ণ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qorxmuş üz"),
            keywords: &["qorxmuş üz", "qorxu", "qorxulu", "ürkmüş", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("напалоханы твар"),
            keywords: &["жах", "напалоханы", "напалоханы твар", "напужаны", "страх"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изплашено лице"),
            keywords: &["Изплашено лице", "изплашен", "лице", "страх"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভয\u{9bc}\u{9be}র\u{9cd}ত ম\u{9c1}খ"),
            keywords: &[
                "ভয\u{9bc}",
                "ভয\u{9bc}\u{9be}র\u{9cd}ত ম\u{9c1}খ",
                "ভীত",
                "ভীতিজনক",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plašljivost"),
            keywords: &["plašenje", "plašljivost", "prepad", "strah"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de por"),
            keywords: &[
                "atemorida",
                "atemorit",
                "cara de por",
                "espantada",
                "espantat",
                "por",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎾᏰᏌᏘ ᎤᎧᏛ"),
            keywords: &["ᎠᏍᎦᎢᎭ", "ᎤᎧᏛ", "ᎤᎾᏰᏌᏘ", "ᎤᏍᎦᎡᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ustrašený obličej"),
            keywords: &[
                "děs",
                "smajlík",
                "strach",
                "tvář",
                "ustrašený obličej",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb ofnus"),
            keywords: &["ofn", "ofnus", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bange ansigt"),
            keywords: &["bange ansigt", "frygt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ängstliches Gesicht"),
            keywords: &["Gesicht", "ängstlich", "ängstliches Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φόβος"),
            keywords: &["πρόσωπο", "τρομαγμένος", "φοβισμένος", "φόβος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fearful face"),
            keywords: &["face", "fear", "fearful", "scared"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara asustada"),
            keywords: &["asustado", "cara", "cara asustada", "miedo", "miedoso"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de miedo"),
            keywords: &[
                "cara",
                "cara de miedo",
                "horror",
                "miedo",
                "temor",
                "terror",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara asustada"),
            keywords: &["cara asustada"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hirmunud nägu"),
            keywords: &["hirm", "hirmunud nägu", "hirmus", "kartlik", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ikara-aurpegia"),
            keywords: &["aurpegi", "beldur", "ikara", "ikara-aurpegia", "ikaratu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ترسیده"),
            keywords: &["ترس", "ترسناک", "ترسیده", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pelokas"),
            keywords: &["naama", "pelko", "pelokas", "pelästynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("natatakot"),
            keywords: &[
                "duwag",
                "kabado",
                "kinakabahan",
                "mukha",
                "natatakot",
                "takot",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bangi andlit"),
            keywords: &["andlit", "bangi", "óttafult", "óttast"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage effrayé"),
            keywords: &["apeuré", "effrayé", "peur", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog eaglach"),
            keywords: &["eagla", "faitíos", "straoiseog eaglach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann fo eagal"),
            keywords: &[
                "an t-eagal air",
                "aodann",
                "aodann fo eagal",
                "eagal",
                "eagalach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de medo"),
            keywords: &["cara", "cara de medo", "medo", "terror"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભયભીત ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "ભયગ\u{acd}રસ\u{acd}ત", "ભયભીત"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai jin tsoro"),
            keywords: &[
                "firgita",
                "fuska",
                "fuska mai jin tsoro",
                "jin tsoro",
                "tsoro",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מפוחד"),
            keywords: &["מפוחד", "מפחד", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डरा ह\u{941}आ च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "डरा", "डरा ह\u{941}आ च\u{947}हरा", "भयभीत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("preplašeno lice"),
            keywords: &["lice", "preplašeno lice", "preplašenost", "strah"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("félelemmel teli arc"),
            keywords: &["arc", "félelem", "félelemmel teli arc", "rémült"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վախեցած դեմք"),
            keywords: &["դեմք", "սարսափած", "վախ", "վախեցած"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah ketakutan"),
            keywords: &[
                "muka",
                "ngeri",
                "seram",
                "takut",
                "wajah",
                "wajah ketakutan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ujọ"),
            keywords: &["atụ ụjọ", "ihu", "ihu ujọ", "na", "ụjọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hrætt andlit"),
            keywords: &["andlit", "hrætt andlit", "hræðsla", "ótti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina impaurita"),
            keywords: &["faccina", "impaurita", "paura"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("青ざめ"),
            keywords: &["がーん", "青ざめ", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai keweden"),
            keywords: &["keweden", "kuwatir", "rai", "wedi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეშინებული სახე"),
            keywords: &["სახე", "შეშინებული", "შიში"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шошып кету"),
            keywords: &["бет", "шошу", "шошып кету", "қорыққан", "қорқынышты"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bange ansigt"),
            keywords: &["bange ansigt", "frygt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខភ\u{17d0}យខ\u{17d2}លាច"),
            keywords: &[
                "ខ\u{17d2}លាច",
                "ភ\u{17d0}យ",
                "ភ\u{17d0}យខ\u{17d2}លាច",
                "ម\u{17bb}ខភ\u{17d0}យខ\u{17d2}លាច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭಯದ ಮುಖ"),
            keywords: &[
                "ಗಾಬರ\u{cbf}ಯ ಮುಖ",
                "ಬ\u{cc6}ದರ\u{cbf}ದ ಮುಖ",
                "ಭಯ ಮುಖ",
                "ಭಯದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("두려워하는 얼굴"),
            keywords: &[
                "공포",
                "공포에 가득찬 얼굴",
                "두려움",
                "두려워하는 얼굴",
                "얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काचव\u{947}ल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "काचव\u{947}ल\u{94d}लो",
                "च\u{947}रो",
                "भ\u{902}य",
                "भिल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("коркуп жаткан бет"),
            keywords: &["бет", "коркуп жаткан бет", "коркуп калган", "коркуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("verängschtegt Gesiicht"),
            keywords: &["Angscht", "Gesiicht", "baang", "verängschtegt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຢ\u{ec9}ານກ\u{ebb}ວ"),
            keywords: &[
                "ຢ\u{ec9}ານກ\u{ebb}ວ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຢ\u{ec9}ານກ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("baimės pilnas veidas"),
            keywords: &["baimė", "baimės pilnas veidas", "išsigandęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nobijusies seja"),
            keywords: &["bailes", "bailīgs", "nobijies", "nobijusies seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi mataku"),
            keywords: &["kanohi", "mataku", "wehi", "wewehi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице во страв"),
            keywords: &["исплашено", "лице", "лице во страв", "страв", "уплашено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഭയചകിതമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "പേടിച\u{d4d}ച",
                "പേടിച\u{d4d}ചരണ\u{d4d}ട",
                "ഭയം",
                "ഭയചകിതമ\u{d3e}യ",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("айсан царай"),
            keywords: &["айсан", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घाबरल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "घाबरल\u{947}ला",
                "च\u{947}हरा",
                "भीती",
                "भीती वाटत असल\u{947}ला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka ketakutan"),
            keywords: &["ketakutan", "muka", "seram", "takut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imbeżża’"),
            keywords: &["biża’", "imbeżża’", "tal-biża’", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{102d}\u{102f}းရ\u{102d}မ\u{103a}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ကြောက\u{103a}ရ\u{103d}\u{1036}\u{1037}ခြင\u{103a}း",
                "ကြောက\u{103a}ရ\u{103d}\u{1036}\u{1037}တ\u{102f}န\u{103a}လ\u{103e}\u{102f}ပ\u{103a}ခြင\u{103a}း",
                "စ\u{102d}\u{102f}းရ\u{102d}မ\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("redd"),
            keywords: &["fjes", "frykt", "redd", "skremt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डराएको अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "डरलाग\u{94d}दो", "डराएको", "भयभीत"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bang gezicht"),
            keywords: &["angst", "angstig", "bang", "gezicht"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("redd"),
            keywords: &["fjes", "frykt", "redd", "skremt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡରକ\u{b41}ଳ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଡରକ\u{b41}ଳ\u{b3e}",
                "ଡର\u{b3f}ବ\u{b3e}",
                "ଭୟଭୀତ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਰਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਡਰ", "ਡਰਾਵਣਾ", "ਡਰਿਆ", "ਡਰਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خوفزدہ شکل"),
            keywords: &["خوف", "خوفزدہ", "خوفزدہ شکل", "دی شکل", "ڈریا ہوئیا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Fia De Kach"),
            keywords: &[
                "Fes",
                "Fes Wé Fia De Kach",
                "Fia",
                "Fọ Fia To Kách Pẹ\u{301}sin",
                "Fọ Sọ\u{301}mtin To Mék Fia Kách Pẹ\u{301}sin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("przestraszona twarz"),
            keywords: &["przestraszona twarz", "wystraszona buźka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډارونکی مخ"),
            keywords: &["مخ", "ډار", "ډارونکی", "ډارېدلی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto amedrontado"),
            keywords: &["assustado", "rosto", "rosto amedrontado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara cheia de medo"),
            keywords: &[
                "amedrontado",
                "assustado",
                "cara",
                "cara cheia de medo",
                "medo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mancharisqa uya"),
            keywords: &["manchachisqa", "mancharisqa", "manchariy", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față înfricoșată"),
            keywords: &[
                "față",
                "față înfricoșată",
                "frică",
                "spaimă",
                "înspăimântat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-876"),
            keywords: &["E10-876"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("боится"),
            keywords: &["боится", "жуть", "испуг", "лицо", "рот", "страх"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kugira ubwoba"),
            keywords: &[
                "Isura",
                "giteye ubwoba",
                "isura igaragaza kugira ubwoba",
                "ubwoba",
                "uwakanzwe",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊنل چهرو"),
            keywords: &["خوف", "خوفناڪ", "چهرو", "ڊنل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}යට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "බය",
                "බ\u{dd2}ය",
                "බ\u{dd2}යජනක",
                "බ\u{dd2}යට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vystrašená tvár"),
            keywords: &["bojazlivá", "strach", "tvár", "vystrašená"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bojazljiv obraz"),
            keywords: &[
                "bojazljiv obraz",
                "obraz",
                "preplašeno",
                "prestrašeno",
                "strah",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji cabsi leh"),
            keywords: &["cabsanaayo", "cabsi", "cabsi leh", "waji", "waji cabsi leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e frikësuar"),
            keywords: &[
                "frikë",
                "fytyrë",
                "fytyrë e frikësuar",
                "i frikshëm",
                "i frikësuar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("уплашено лице"),
            keywords: &["лице", "прeплaшeнoст", "стрaх", "уплашено лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["уплашено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uplašeno lice"),
            keywords: &["lice", "preplašenost", "strah", "uplašeno lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["uplašeno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("skrämt ansikte"),
            keywords: &["rädd", "skräckinjagat ansikte", "skrämt ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaoogopa"),
            keywords: &["kuhofu", "kuogopa", "uso", "uso unaoogopa", "woga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பயந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "அச\u{bcd}சம\u{bcd}",
                "பயந\u{bcd}த முகம\u{bcd}",
                "பயம\u{bbe}க உள\u{bcd}ளது",
                "பயம\u{bcd}",
                "ரொம\u{bcd}ப பயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("భయంత\u{c4b} ఉన\u{c4d}న ముఖం"),
            keywords: &["భయం", "భయంత\u{c4b} ఉన\u{c4d}న ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи тарсон"),
            keywords: &["рӯи тарсон", "рӯй", "тарс", "тарсон", "ҳаросида"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หวาดกล\u{e31}ว"),
            keywords: &["กล\u{e31}ว", "หน\u{e49}า", "หวาดกล\u{e31}ว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gorkuly ýüz"),
            keywords: &["gorkan", "gorkuly", "gorky", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fakamanavahē"),
            keywords: &["mata fakamanavahē"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("korkulu yüz"),
            keywords: &["korkmuş", "korkulu yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قورقۇنچلۇق چىراي"),
            keywords: &["قورققان", "قورقۇنچ", "قورقۇنچلۇق چىراي", "چىراي", "چۆچۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("налякане обличчя"),
            keywords: &[
                "боязкий",
                "налякане обличчя",
                "наляканий",
                "обличчя",
                "страх",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خوفزدہ چہرہ"),
            keywords: &["خوف", "خوفزدہ چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘rqqan yuz"),
            keywords: &["qo‘rqinchli", "qo‘rqish", "qo‘rqqan yuz", "qo‘rquv", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt sợ hãi"),
            keywords: &["kinh hãi", "mặt", "mặt sợ hãi", "sợ", "sợ hãi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy tiitaleete"),
            keywords: &["kanam", "kanam guy tiitaleete", "ragal", "tiit"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso oboyikayo"),
            keywords: &[
                "iyoyikeka",
                "ubuso",
                "ubuso oboyikayo",
                "ukoyika",
                "uloyiko",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ẹru"),
            keywords: &["Oju Ẹru", "ojú", "ìbẹ\u{300}rù"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("驚恐嘅臉"),
            keywords: &["害怕", "臉", "驚恐", "驚恐嘅臉", "驚慌"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("惊恐嘅脸"),
            keywords: &["害怕", "惊恐", "惊恐嘅脸", "惊慌", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("害怕"),
            keywords: &["害怕", "怕", "恐怖", "恐惧", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("可怕"),
            keywords: &["可怕", "害怕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("驚恐"),
            keywords: &["害怕", "臉色發青", "驚恐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obesabayo"),
            keywords: &["ubuso", "ubuso obesabayo", "ukwesaba", "ukwethuka"],
        },
    ],
};
#[doc = "😰"]
pub const ANXIOUS_FACE_WITH_SWEAT: crate::Emoji = crate::Emoji {
    glyph: "😰",
    codepoint: "1F630",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "anxious face with sweat",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met oop mond en koue sweet"),
            keywords: &[
                "blou",
                "gesig",
                "gesig met oop mond en koue sweet",
                "koud",
                "mond",
                "oop",
                "sweet",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፉ የተከፈተ እና ቀዝቃዛ ላብ ያለው ፊት"),
            keywords: &["ላብ", "ሰማያዊ", "ቀዝቃዛ", "አፉ የተከፈተ እና ቀዝቃዛ ላብ ያለው ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه بفم مفتوح وعرق بارد"),
            keywords: &[
                "عرق بارد",
                "فم مفتوح",
                "وجه أزرق يتصبب عرق\u{64b}ا بارد\u{64b}ا",
                "\u{202b}وجه بفم مفتوح وعرق بارد",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9be}মেৰে উদ\u{9cd}বিগ\u{9cd}ন চেহেৰ\u{9be}"),
            keywords: &[
                "খোল\u{9be}",
                "ঘ\u{9be}ম",
                "ঘ\u{9be}মেৰে উদ\u{9cd}বিগ\u{9cd}ন চেহেৰ\u{9be}",
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "তীব\u{9cd}ৰ",
                "নীল\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağzı açıq və soyuq tər olan üz"),
            keywords: &[
                "açıq",
                "ağzı açıq və soyuq tər olan üz",
                "ağız",
                "mavi",
                "soyuq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("твар з адкрытым ротам і халодным потам на лбе"),
            keywords: &[
                "пот",
                "рот",
                "стома",
                "сіні",
                "твар з адкрытым ротам і халодным потам на лбе",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с отворена уста и студена пот"),
            keywords: &[
                "Лице с отворена уста и студена пот",
                "лице",
                "пот",
                "син",
                "студен",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "খোল\u{9be} ম\u{9c1}খ এবং ঠ\u{9be}ণ\u{9cd}ড\u{9be} ঘ\u{9be}মের স\u{9be}থে ম\u{9c1}খমণ\u{9cd}ডল",
            ),
            keywords: &[
                "খোল\u{9be} ম\u{9c1}খ এবং ঠ\u{9be}ণ\u{9cd}ড\u{9be} ঘ\u{9be}মের স\u{9be}থে ম\u{9c1}খমণ\u{9cd}ডল",
                "ঘর\u{9cd}ম\u{9be}ক\u{9cd}ত অবস\u{9cd}থ\u{9be}",
                "ঘ\u{9be}ম",
                "ঘ\u{9be}ম ঝর\u{9be} উদ\u{9cd}ধিগ\u{9cd}ন ম\u{9c1}খে",
                "নীল",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otvorena usta i hladan znoj"),
            keywords: &[
                "hladan",
                "otvorena usta i hladan znoj",
                "plav",
                "usta",
                "znoj",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb la boca oberta i suor freda"),
            keywords: &[
                "boca oberta",
                "cara",
                "cara amb la boca oberta i suor freda",
                "nervis",
                "suor freda",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎷᎶ ᎤᎧᏛ ᎠᎵ"),
            keywords: &["ᎠᎵ", "ᎠᏅᏍᏔᏅᎢ", "ᎤᎧᏛ", "ᎤᎷᎶ ᎤᎧᏛ ᎠᎵ", "ᎤᏴᏜ", "ᏌᎪᏂᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("úzkostný obličej se studeným potem"),
            keywords: &[
                "modrá",
                "otevřený",
                "pot",
                "smajlík",
                "studený",
                "tvář",
                "uštvaný",
                "výraz",
                "ústa",
                "úzkostný obličej se studeným potem",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb â cheg agored a chwys o ofid"),
            keywords: &[
                "agored",
                "ceg",
                "chwys",
                "gofid",
                "wyneb â cheg agored a chwys o ofid",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med åben mund og koldsved"),
            keywords: &[
                "ansigt med åben mund og koldsved",
                "blå i ansigtet",
                "koldsved",
                "åben mund",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("besorgtes Gesicht mit Schweißtropfen"),
            keywords: &[
                "Gesicht",
                "besorgtes Gesicht mit Schweißtropfen",
                "kalter Schweiß",
                "offener Mund",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Smiley mit offenem Mund und kaltem Schweiss"),
            keywords: &[
                "Gesicht",
                "Smiley mit offenem Mund und kaltem Schweiss",
                "kalter Schweiss",
                "offener Mund",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοικτό στόμα και κρύος ιδρώτας"),
            keywords: &[
                "ανοικτό στόμα και κρύος ιδρώτας",
                "ανοιχτό",
                "ιδρώτας",
                "κρύος",
                "μπλε",
                "ξαφνικός",
                "πρόσωπο",
                "στόμα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("anxious face with sweat"),
            keywords: &[
                "anxious face with sweat",
                "blue",
                "cold",
                "face",
                "rushed",
                "sweat",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con ansiedad y sudor"),
            keywords: &[
                "ansiedad",
                "cara",
                "cara con ansiedad y sudor",
                "frío",
                "sudor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "abierta",
                "boca",
                "cara con ansiedad y sudor",
                "en aprietos",
                "frío",
                "miedo",
                "sudor",
                "temor",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara con ansiedad y sudor"),
            keywords: &[
                "ansiedad",
                "azul",
                "cara",
                "cara con ansiedad y sudor",
                "frío",
                "sudor",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara con ansiedad y sudor"),
            keywords: &["cara con ansiedad y sudor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("külma higiga kaetud ja avatud suuga nägu"),
            keywords: &[
                "avatud",
                "higi",
                "külm",
                "külma higiga kaetud ja avatud suuga nägu",
                "nägu",
                "sinine",
                "suu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ahoa irekita eta izerdi hotza duen aurpegia"),
            keywords: &[
                "aho",
                "ahoa irekita eta izerdi hotza duen aurpegia",
                "aurpegi",
                "grinatsu",
                "hotz",
                "irekita",
                "izerdi",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عرق ترس"),
            keywords: &["آبی", "باز", "ترس", "دهان", "سرد", "صورت", "عرق"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avoin suu ja kylmänhiki"),
            keywords: &[
                "auki",
                "avoin suu ja kylmänhiki",
                "hiki",
                "kylmä",
                "naama",
                "sininen",
                "suu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("balisa at pinagpapawisan"),
            keywords: &[
                "balisa at pinagpapawisan",
                "kabado",
                "kinakabahan",
                "mukha",
                "natatakot",
                "pawis",
                "pinagpapawisan nang malamig",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bangi andlit við sveitta"),
            keywords: &[
                "andlit",
                "bangi",
                "bangi andlit við sveitta",
                "sveitti",
                "óttafult",
                "óttast",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage anxieux avec goutte de sueur"),
            keywords: &[
                "bouche",
                "froid",
                "sueur",
                "visage",
                "visage anxieux avec goutte de sueur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage inquiet et en sueur"),
            keywords: &[
                "anxieux",
                "bleu",
                "froide",
                "sueur",
                "visage",
                "visage inquiet et en sueur",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog fhaiteach le hallas"),
            keywords: &[
                "allas",
                "brostaigh",
                "faoi dheifir",
                "fuarallas",
                "straoiseog fhaiteach le hallas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann le beul fosgailte a’ cur fallas"),
            keywords: &[
                "aodann",
                "aodann le beul fosgailte a’ cur fallas",
                "beul",
                "cabhag",
                "fallas",
                "fosgailte",
                "fuar",
                "gorm",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara coa boca aberta e suor fría"),
            keywords: &[
                "boca aberta",
                "cara",
                "cara coa boca aberta e suor fría",
                "suor fría",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some(
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો ચહ\u{ac7}રો",
            ),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા મો\u{a82} અન\u{ac7} ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો ચહ\u{ac7}રો",
                "ખ\u{ac1}લ\u{acd}લ\u{ac1}\u{a82} મોઢ\u{ac1}\u{a82}",
                "ચહ\u{ac7}રો",
                "ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો વાદળી ચહ\u{ac7}રો",
                "ઠ\u{a82}ડો પરસ\u{ac7}વો",
                "ધસ\u{ac7}લો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da baki a buɗe & gumi mai sanyi"),
            keywords: &[
                "a buɗe",
                "baki",
                "fuska",
                "fuska tare da baki a buɗe & gumi mai sanyi",
                "gaggauta",
                "gumi",
                "sanyi",
                "shuɗi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מפחד עם זיעה קרה"),
            keywords: &[
                "זיעה קרה",
                "מפוחד",
                "מפחד",
                "פרצוף",
                "פרצוף מפחד עם זיעה קרה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठ\u{902}ड\u{947} पसीन\u{947} वाला नीला च\u{947}हरा"),
            keywords: &[
                "ख\u{941}ला म\u{941}\u{902}ह",
                "घबराया च\u{947}हरा",
                "च\u{947}हरा",
                "ठ\u{902}डा पसीना",
                "ठ\u{902}ड\u{947} पसीन\u{947} वाला नीला च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("anksiozno lice s kapljicom znoja"),
            keywords: &[
                "anksiozno lice s kapljicom znoja",
                "hladno",
                "lice",
                "plavo",
                "užurbano",
                "znoj",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("aggódó arc nyitott szájjal és verejtékkel"),
            keywords: &[
                "aggódó arc nyitott szájjal és verejtékkel",
                "arc",
                "hideg verejték",
                "nyitott száj",
                "rohanás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց բերանով և սառը քրտինքով դեմք"),
            keywords: &[
                "բաց",
                "բաց բերանով և սառը քրտինքով դեմք",
                "բերան",
                "դեմք",
                "կապույտ",
                "սառը",
                "քրտինք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah ketakutan berkeringat"),
            keywords: &[
                "biru",
                "buru-buru",
                "dingin",
                "keringat",
                "wajah",
                "wajah ketakutan berkeringat",
                "wajah ketakutan dengan keringat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere mmepe ọnụ & okpofufu oyi"),
            keywords: &[
                "anụnụ",
                "ihu",
                "ihu nwere mmepe ọnụ & okpofufu oyi",
                "mepere",
                "nwetara",
                "okpofufu",
                "oyi",
                "ọnụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sveitt andlit"),
            keywords: &["andlit", "kaldur sviti", "sveitt andlit", "sviti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina sudata in ansia"),
            keywords: &[
                "faccina",
                "faccina blu sudata",
                "faccina sotto pressione",
                "faccina sudata in ansia",
                "sudata",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("冷や汗青ざめ"),
            keywords: &["冷や汗", "冷や汗青ざめ", "青ざめ", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kuwatir nganti kringet tumetes"),
            keywords: &[
                "anyep",
                "kemrungsung",
                "kringet",
                "pucet",
                "rai",
                "rai kuwatir nganti kringet tumetes",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე ღია პირითა და ცივი ოფლით"),
            keywords: &[
                "ლურჯი",
                "ოფლი",
                "ოფლიანი",
                "პირი",
                "პირღია",
                "სახე",
                "სახე ღია პირითა და ცივი ოფლით",
                "ღია",
                "ცივი",
                "ცისფერი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қатты қобалжу"),
            keywords: &[
                "аузын ашып, суық терін шығару",
                "ашық",
                "бет",
                "көк",
                "мұңды",
                "суық",
                "тер",
                "қатты қобалжу",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med åben mund og koldsved"),
            keywords: &[
                "ansigt med åben mund og koldsved",
                "blå i ansigtet",
                "koldsved",
                "åben mund",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខឈ\u{17ba}ដោយថ\u{17d2}ងាស\u{17cb}ឡើងពណ\u{17cc}ខៀវន\u{17b7}ងមានញើស"),
            keywords: &[
                "ក\u{17d2}តៅ",
                "ឈ\u{17ba}",
                "បែកញើស",
                "ម\u{17bb}ខឈ\u{17ba}ដោយថ\u{17d2}ងាស\u{17cb}ឡើងពណ\u{17cc}ខៀវន\u{17b7}ងមានញើស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ವರ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಆತಂಕದ ಮುಖ"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}ದ ಬಾಯ\u{cbf}",
                "ತ\u{cc6}ರ\u{cc6}ದ ಬಾಯ\u{cbf} ಮತ\u{ccd}ತು ತಣ\u{ccd}ಣನ\u{cc6} ಬ\u{cc6}ರವ\u{cbf}ನ ಮುಖ",
                "ನೀಲ\u{cbf} ಬಣ\u{ccd}ಣದ ಮುಖ",
                "ಬ\u{cc6}ವರ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಆತಂಕದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("땀 흘리며 불안해하는 얼굴"),
            keywords: &["땀 흘리며 불안해하는 얼굴", "식은땀", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घाम द\u{947}\u{902}वपी चि\u{902}त\u{947}स\u{94d}त च\u{947}रो"),
            keywords: &[
                "घाम",
                "घाम द\u{947}\u{902}वपी चि\u{902}त\u{947}स\u{94d}त च\u{947}रो",
                "च\u{947}रो",
                "थ\u{902}ड",
                "धा\u{902}वप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оозу ачылып, муздак тер аккан бет"),
            keywords: &[
                "бет",
                "көк",
                "оозу ачылып, муздак тер аккан бет",
                "суук",
                "тердөө",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gesiicht mat oppenem Mond a kalem Schweess"),
            keywords: &[
                "Gesiicht",
                "Gesiicht mat oppenem Mond a kalem Schweess",
                "Mond",
                "Schweess",
                "blo",
                "kal",
                "oppen",
                "presséiert",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າກ\u{eb1}ງວ\u{ebb}ນເຫ\u{eb7}\u{ec8}ອຕ\u{ebb}ກ"),
            keywords: &[
                "ກ\u{ebb}ງວ\u{ebb}ນ",
                "ເຫ\u{eb7}\u{ec8}ອອອກ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າກ\u{eb1}ງວ\u{ebb}ນເຫ\u{eb7}\u{ec8}ອຕ\u{ebb}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("išsižiojęs veidas, išpiltas šalto prakaito"),
            keywords: &[
                "burna",
                "išsižiojęs",
                "išsižiojęs veidas, išpiltas šalto prakaito",
                "mėlyna",
                "prakaitas",
                "veidas",
                "šaltis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar atvērtu muti un aukstiem sviedriem"),
            keywords: &[
                "atvērts",
                "auksts",
                "mute",
                "seja",
                "seja ar atvērtu muti un aukstiem sviedriem",
                "sviedri",
                "zils",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi waha tuwhera me te werawera mātao"),
            keywords: &[
                "kanohi",
                "kanohi waha tuwhera me te werawera mātao",
                "kikorangi",
                "mātao",
                "tuwhera",
                "waha",
                "werawera",
                "whāwhai",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со отворена уста и капка пот"),
            keywords: &[
                "лице",
                "лице со отворена уста и капка пот",
                "отворена",
                "пот",
                "сино",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വിയർക\u{d4d}ക\u{d41}ന\u{d4d}ന ഉത\u{d4d}\u{200c}കണ\u{d4d}ഠ\u{d3e}ക\u{d41}ലമ\u{d3e}യ മ\u{d41}ഖം",
            ),
            keywords: &[
                "തണ\u{d41}പ\u{d4d}പ\u{d4d}",
                "തിരക\u{d4d}ക\u{d41}പിടിച\u{d4d}ച",
                "നീല",
                "മ\u{d41}ഖം",
                "വിയർക\u{d4d}ക\u{d41}ന\u{d4d}ന ഉത\u{d4d}\u{200c}കണ\u{d4d}ഠ\u{d3e}ക\u{d41}ലമ\u{d3e}യ മ\u{d41}ഖം",
                "വിയർപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амаа ангайж, хүйтэн хөлс чахарсан царай"),
            keywords: &[
                "амаа ангайж, хүйтэн хөлс чахарсан царай",
                "амаа ангайх",
                "хүйтэн",
                "хөлс чахрах",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घाईत असल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "घाईत",
                "घाईत असल\u{947}ला च\u{947}हरा",
                "घाम",
                "घामासह चि\u{902}ताग\u{94d}रस\u{94d}त च\u{947}हरा",
                "च\u{947}हरा",
                "थ\u{902}ड",
                "निळा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka gementar dan berpeluh sejuk"),
            keywords: &[
                "berpeluh",
                "kebiruan",
                "muka gementar dan berpeluh sejuk",
                "muka runsing berpeluh",
                "sejuk",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’ħalq miftuħ u għaraq kiesaħ"),
            keywords: &[
                "blu",
                "għaraq",
                "kiesaħ",
                "mgħaġġel",
                "miftuħ",
                "wiċċ",
                "wiċċ b’ħalq miftuħ u għaraq kiesaħ",
                "ħalq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပါးစပ\u{103a}ဟနေကာ ဇောချ\u{103d}ေးပြန\u{103a}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ကမန\u{103a}းကတန\u{103a}းလ\u{102f}ပ\u{103a}ခြင\u{103a}း",
                "ချ\u{103d}ေး",
                "စ\u{102d}\u{102f}းရ\u{102d}မ\u{103a}၍ ဇောချ\u{103d}ေးပြန\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ပါးစပ\u{103a}ဟနေကာ ဇောချ\u{103d}ေးပြန\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
                "ပြာလောင\u{103a}ခတ\u{103a}ခြင\u{103a}း",
                "မျက\u{103a}န\u{103e}ာ",
                "အပြာရောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("engstelig og svetter"),
            keywords: &[
                "engstelig og svetter",
                "fjes",
                "kaldsvette",
                "syk",
                "åpen munn",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("असिनपसिन भएको चिन\u{94d}तित अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "असिनपसिन भएको चिन\u{94d}तित अन\u{941}हार",
                "चिसो",
                "निलो",
                "पसिना",
                "हतारिएको",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("angstig gezicht met zweetdruppel"),
            keywords: &[
                "angstig gezicht met zweetdruppel",
                "blauw",
                "gehaast",
                "gezicht",
                "koud",
                "mond",
                "open",
                "zweet",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("engsteleg og sveittar"),
            keywords: &[
                "engsteleg og sveittar",
                "fjes",
                "kaldsveitte",
                "open munn",
                "sjuk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b3e}ଳ ସହ\u{b3f}ତ ଆତ\u{b41}ର ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଅଚ\u{b3e}ନକ",
                "ଝ\u{b3e}ଳ",
                "ଝ\u{b3e}ଳ ସହ\u{b3f}ତ ଆତ\u{b41}ର ମ\u{b41}ହ\u{b01}",
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ନୀଳ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਅਤ\u{a47} ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਵਾਲਾ ਚਿਹਰਾ",
            ),
            keywords: &[
                "ਕਾਹਲਾ ਚਿਹਰਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਮ\u{a42}\u{a70}ਹ ਅਤ\u{a47} ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਵਾਲਾ ਚਿਹਰਾ",
                "ਠ\u{a70}ਡਾ",
                "ਠ\u{a70}ਡਾ ਪਸੀਨਾ",
                "ਠ\u{a70}ਡ\u{a47} ਪਸੀ\u{a47}ਨ\u{a47} ਨਾਲ ਨੀਲਾ ਚਿਹਰਾ",
                "ਨੀਲਾ",
                "ਮ\u{a42}\u{a70}ਹ ਖ\u{a41}\u{a71}ਲਿਆ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ک\u{64f}ھلے منہ اتے مڑکے آلی شکل"),
            keywords: &[
                "دی شکل",
                "منہ",
                "م\u{64f}ڑکا",
                "نیلا",
                "ٹھنڈا",
                "ک\u{64f}ھلا",
                "ک\u{64f}ھلے منہ اتے مڑکے آلی شکل",
                "گھس جانا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Swẹt An Wé Sọ\u{301}mtin De Wọ\u{301}ri"),
            keywords: &[
                "Blu",
                "Fes",
                "Fes Wé De Swẹt An Wé Sọ\u{301}mtin De Wọ\u{301}ri",
                "Kold",
                "Swẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zaniepokojona twarz oblana potem"),
            keywords: &["zaniepokojona twarz oblana potem", "zziajana buźka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اندېښمن مخ د خولې سره"),
            keywords: &[
                "آسماني رنګ",
                "اندېښمن مخ د خولې سره",
                "بې مينې",
                "تندي",
                "خوله",
                "مخ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto ansioso com gota de suor"),
            keywords: &[
                "boca aberta",
                "rosto",
                "rosto ansioso com gota de suor",
                "rosto azul com suor frio",
                "suor frio",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara com boca aberta e suor frio"),
            keywords: &[
                "aberta",
                "azul",
                "boca",
                "cara",
                "cara com boca aberta e suor frio",
                "com pressa",
                "frio",
                "suor",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("takurisqa uya sutʼuwan"),
            keywords: &[
                "anqas",
                "chiri",
                "sutʼu",
                "takurisqa uya sutʼuwan",
                "usqhasqa",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față neliniștită cu sudoare rece"),
            keywords: &[
                "față",
                "față neliniștită cu sudoare rece",
                "gură deschisă",
                "stres",
                "sudoare rece",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-884"),
            keywords: &["E10-884"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сильно беспокоится"),
            keywords: &[
                "боится",
                "открытый рот",
                "пот",
                "сильно беспокоится",
                "страх",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza umunwa wasamye n’ibyuya by’ubwoba"),
            keywords: &[
                "gikonje",
                "gufungura",
                "icyuya",
                "isura",
                "isura igaragaza umunwa wasamye n’ibyuya by’ubwoba",
                "ubururu",
                "uhihibikana",
                "umunwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پگهر سان فڪرمند چهرو"),
            keywords: &[
                "نيرو",
                "وات",
                "وڌيل",
                "پگهر سان فڪرمند چهرو",
                "پگھر",
                "ٿڌو",
                "چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට ඇර\u{dd4}ණ\u{dd4} දහඩ\u{dd2}ය දමන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ඇර\u{dd4}ණ\u{dd4} දහඩ\u{dd2}ය දමන ම\u{dd4}හ\u{dd4}ණ",
                "කට ඇර\u{dd4}ණ\u{dd4} දහඩ\u{dd2}ය දමන ම\u{dd4}හ\u{dd4}ණ",
                "දහඩ\u{dd2}ය",
                "න\u{dd2}ල\u{dca}",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd3}තල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("znepokojená tvár s\u{a0}potom"),
            keywords: &[
                "náhliť",
                "otvorené",
                "pot",
                "tvár",
                "znepokojená tvár s\u{a0}potom",
                "ústa",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z odprtimi usti in mrzlim potom"),
            keywords: &[
                "hladno",
                "modro",
                "naglo",
                "obraz",
                "obraz z odprtimi usti in mrzlim potom",
                "odprto",
                "pot",
                "usta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji walaacsan oo dhidid leh"),
            keywords: &[
                "baluug",
                "dedegid",
                "dhidid",
                "qabow",
                "waji",
                "waji walaacsan oo dhidid leh",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me gojën e hapur dhe djersë të ftohta"),
            keywords: &[
                "blu",
                "djersë",
                "e hapur",
                "ftohtë",
                "fytyrë me gojën e hapur dhe djersë të ftohta",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице са отвореним устима, обливено хладним знојем"),
            keywords: &[
                "oтвoрeнo",
                "знoj",
                "лице",
                "лице са отвореним устима, обливено хладним знојем",
                "нелагода",
                "плaвo",
                "уста",
                "хлaднo",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице са отвореним устима, обливено хладним знојем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice sa otvorenim ustima, obliveno hladnim znojem"),
            keywords: &[
                "hladno",
                "lice",
                "lice sa otvorenim ustima, obliveno hladnim znojem",
                "nelagoda",
                "otvoreno",
                "plavo",
                "usta",
                "znoj",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice sa otvorenim ustima, obliveno hladnim znojem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("oroligt svettigt ansikte"),
            keywords: &["blått ansikte", "kallsvettig", "oroligt svettigt ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye wasiwasi unaotokwa na jasho"),
            keywords: &[
                "funguliwa",
                "jasho",
                "jembamba",
                "samawati",
                "sisimka",
                "uso wenye wasiwasi unaotokwa na jasho",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "திறந\u{bcd}த வ\u{bbe}யுடன\u{bcd} வியர\u{bcd}வைச\u{bcd} சொட\u{bcd}டும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "குளிர\u{bcd}",
                "திறந\u{bcd}த வ\u{bbe}யுடன\u{bcd} வியர\u{bcd}வைச\u{bcd} சொட\u{bcd}டும\u{bcd} முகம\u{bcd}",
                "ந\u{bc0}லம\u{bcd}",
                "நெருக\u{bcd}கடி",
                "பதட\u{bcd}டம\u{bbe}ன முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} భయంత\u{c4b} చ\u{c46}మటలు పడుతున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "చ\u{c46}మట",
                "న\u{c4b}రు",
                "న\u{c4b}రు త\u{c46}ర\u{c3f}చ\u{c3f} భయంత\u{c4b} చ\u{c46}మటలు పడుతున\u{c4d}న ముఖం",
                "భయం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи бо даҳони кушода ва арақи хунук"),
            keywords: &[
                "даҳон",
                "кабуд",
                "кушода",
                "рӯи бо даҳони кушода ва арақи хунук",
                "рӯй",
                "саросема",
                "хунук",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e31}งวลเหง\u{e37}\u{e48}อตก"),
            keywords: &[
                "ก\u{e31}งวล",
                "ก\u{e31}งวลเหง\u{e37}\u{e48}อตก",
                "หน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sowuk derli biynjalyk ýüz"),
            keywords: &[
                "der",
                "derli biynjalyk ýüz",
                "gök",
                "howlugan",
                "sowuk",
                "sowuk derli biynjalyk ýüz",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lotomoʻua moe tautaʻa"),
            keywords: &["mata lotomoʻua moe tautaʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("terli ve endişeli yüz"),
            keywords: &[
                "açık ağız",
                "soğuk ter",
                "soğuk ter döken mavi yüz",
                "terli ve endişeli yüz",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاغزى ئوچۇق سوغۇق تەرلىگەن چىراي"),
            keywords: &[
                "ئاغزى ئوچۇق سوغۇق تەرلىگەن چىراي",
                "ئالدىراش",
                "ئوچۇق",
                "تەر",
                "سوغۇق",
                "كۆك",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("занепокоєне обличчя з потом"),
            keywords: &[
                "відкритий",
                "занепокоєне обличчя з потом",
                "обличчя",
                "обличчя у холодному поту з відкритим ротом",
                "піт",
                "рот",
                "синій",
                "холодно",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلے منہ اور ٹھنڈے پسینے والا چہرہ"),
            keywords: &[
                "منہ",
                "نیلا",
                "ٹھنڈا",
                "پسینہ",
                "کھلے منہ اور ٹھنڈے پسینے والا چہرہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘zi ochiq va sovuq terga botgan yuz"),
            keywords: &[
                "ko‘kargan",
                "og‘zi ochiq va sovuq terga botgan yuz",
                "sovuq",
                "ter",
                "toliqqan",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt lo lắng và toát mồ hôi"),
            keywords: &[
                "lạnh",
                "mặt",
                "mặt lo lắng và toát mồ hôi",
                "mặt lo lắng và toát mồ hôi mồ hôi",
                "vội vã",
                "xanh da trời",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak ubbeeku gémmiñ ak ñàqu tiitaange"),
            keywords: &[
                "baxa",
                "gaawantu",
                "gémmiñ",
                "kanam",
                "kanam ak ubbeeku gémmiñ ak ñàqu tiitaange",
                "sedd",
                "ubbeeku",
                "ñàq",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunomlomo ovulekileyo nombilo obandayo"),
            keywords: &[
                "balekisa",
                "ivulekile",
                "luhlaza",
                "ubuso",
                "ubuso obunomlomo ovulekileyo nombilo obandayo",
                "ukubanda",
                "umbilo",
                "umlomo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti òógùn tútù"),
            keywords: &[
                "búlù",
                "ojú",
                "ojú pẹ\u{300}lú ẹnu lílà sílẹ\u{300} àti òógùn tútù",
                "sáré",
                "tútù",
                "òógùn",
                "ṣí",
                "ẹnu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滴汗同焦慮嘅臉"),
            keywords: &["匆忙", "汗", "滴汗同焦慮嘅臉", "臉", "藍色"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("滴汗同焦虑嘅脸"),
            keywords: &[
                "冻",
                "匆忙",
                "嘴",
                "打开",
                "汗",
                "滴汗同焦虑嘅脸",
                "脸",
                "蓝色",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("冷汗"),
            keywords: &["冷汗", "无语", "汗", "焦虑", "紧张", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("冒汗"),
            keywords: &["冒汗", "面有菜色"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["冒汗", "滴汗", "臉色發青"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuvule umlomo nomjuluko obandayo"),
            keywords: &[
                "shehsa",
                "ubuso",
                "ubuso obuvule umlomo nomjuluko obandayo",
                "ukubanda",
                "umjuluko",
                "umlomo",
                "vula",
            ],
        },
    ],
};
#[doc = "😥"]
pub const SAD_BUT_RELIEVED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😥",
    codepoint: "1F625",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sad but relieved face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("teleurgestelde maar verligte gesig"),
            keywords: &[
                "gesig",
                "sjoe",
                "teleurgesteld",
                "teleurgestelde maar verligte gesig",
                "verlig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተከፋ ግን የተጽናና ፊት"),
            keywords: &["አሰይ", "እፎይ ያለ", "የተከፋ", "የተከፋ ግን የተጽናና ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه خيبة أمل"),
            keywords: &["احباط", "خيبة أمل", "وجه خيبة أمل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9c1}ঃখিত কিন\u{9cd}ত\u{9c1} স\u{9cd}বস\u{9cd}তিৰ ম\u{9c1}খ"),
            keywords: &[
                "দ\u{9c1}ঃখিত কিন\u{9cd}ত\u{9c1} স\u{9cd}বস\u{9cd}তিৰ ম\u{9c1}খ",
                "ম\u{9c1}খ",
                "স\u{9cd}থিৰ",
                "স\u{9cd}বস\u{9cd}তি",
                "হত\u{9be}শ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("məyus lakin rahat üz"),
            keywords: &["hmm", "məyus lakin rahat üz", "qəmli", "yüngülləşmiş", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("расчараванне з палёгкай"),
            keywords: &["вух", "палёгка", "расчараванне з палёгкай", "расчараваны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице с разочарование и облекчение"),
            keywords: &[
                "Лице с разочарование и облекчение",
                "лице",
                "облекчен",
                "разочарован",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হত\u{9be}শ তবে স\u{9cd}বস\u{9cd}তি প\u{9be}ওয\u{9bc}\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "আশ\u{9cd}চর\u{9cd}য হওয\u{9bc}\u{9be}",
                "ম\u{9c1}খ",
                "স\u{9cd}বস\u{9cd}তি প\u{9be}ওয\u{9bc}\u{9be}",
                "হত\u{9be}শ",
                "হত\u{9be}শ তবে স\u{9cd}বস\u{9cd}তি প\u{9be}ওয\u{9bc}\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("olakšavajuće razočarenje"),
            keywords: &[
                "lice",
                "olakšanje",
                "olakšavajuće razočarenje",
                "razočarenje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de decepció, però alleujada"),
            keywords: &[
                "alleujament",
                "cara",
                "cara de decepció, però alleujada",
                "decepció",
                "uf",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᏍᎦ ᎤᏰᎸᏅᎢ ᎠᏎᏃ ᎤᎵᎮᎵᏨᎢ ᎤᎧᏛ"),
            keywords: &["ᎡᏍᎦ", "ᎡᏍᎦ ᎤᏰᎸᏅᎢ ᎠᏎᏃ ᎤᎵᎮᎵᏨᎢ ᎤᎧᏛ", "ᎤᎧᏛ", "ᎤᏯᏪᏐᏢ", "ᏗᏁᏟᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("smutný obličej s výrazem úlevy"),
            keywords: &[
                "smajlík",
                "smutný obličej s výrazem úlevy",
                "tvář",
                "výraz",
                "zklamání",
                "údiv",
                "úleva",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb siomedig ond â rhyddhad"),
            keywords: &[
                "rhyddhad",
                "siomedig",
                "wyneb",
                "wyneb siomedig ond â rhyddhad",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skuffet men lettet ansigt"),
            keywords: &["puha", "skuffet med lettet", "skuffet men lettet ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("trauriges aber erleichtertes Gesicht"),
            keywords: &[
                "Gesicht",
                "Schweiß",
                "enttäuscht",
                "erleichtert",
                "trauriges aber erleichtertes Gesicht",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["trauriges aber erleichtertes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λυπημένο αλλά ανακουφισμένο πρόσωπο"),
            keywords: &[
                "ανακουφισμένος",
                "απογοητευμένος",
                "λυπημένο αλλά ανακουφισμένο πρόσωπο",
                "ουφ",
                "πρόσωπο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sad but relieved face"),
            keywords: &[
                "disappointed",
                "face",
                "relieved",
                "sad but relieved face",
                "whew",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara triste pero aliviada"),
            keywords: &[
                "aliviado",
                "cara",
                "cara triste pero aliviada",
                "decepcionado",
                "menos mal",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara triste pero aliviada"),
            keywords: &[
                "aliviado",
                "alivio",
                "cara",
                "cara triste pero aliviada",
                "decepcionado",
                "decepción",
                "sudor",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara triste pero aliviada"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara triste pero aliviada"),
            keywords: &["cara triste pero aliviada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pettunud, kuid kergendust tundev nägu"),
            keywords: &[
                "kergendus",
                "leevendus",
                "nägu",
                "pettunud",
                "pettunud, kuid kergendust tundev nägu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("desengainatuta baina lasaiago"),
            keywords: &[
                "aurpegi",
                "desengainatuta",
                "desengainatuta baina lasaiago",
                "eskerrak",
                "lasai",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ناامید اما تسکین\u{200c}یافته"),
            keywords: &[
                "آخیش",
                "صورت",
                "غمگین",
                "ناامید",
                "ناامید اما تسکین\u{200c}یافته",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pettynyt mutta helpottunut"),
            keywords: &[
                "helpottunut",
                "huh",
                "naama",
                "pettynyt",
                "pettynyt mutta helpottunut",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malungkot pero naibsan"),
            keywords: &[
                "dismayado",
                "malungkot pero naibsan",
                "mukha",
                "nakahinga nang maluwag",
                "whew",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sorgarbundi andlit og tár"),
            keywords: &[
                "andlit",
                "dapur",
                "sorgarbundi andlit og tár",
                "sorgarbundin",
                "tár",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage triste mais soulagé"),
            keywords: &["pfiou", "visage triste mais soulagé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage triste mais soulagé"),
            keywords: &[
                "déçu",
                "fiou",
                "soulagé",
                "visage",
                "visage triste mais soulagé",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog a bhfuil díoma ach le faoiseamh"),
            keywords: &[
                "díomá",
                "faoiseamh",
                "straoiseog a bhfuil díoma ach le faoiseamh",
                "straoiseog a bhfuil díoma agus faoiseamh uirthi",
                "straoiseog dhíomá",
                "suaimhneas intinne",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a fhuair briseadh-dùil ⁊ faochadh"),
            keywords: &[
                "aodann",
                "aodann a fhuair briseadh-dùil ach a fhuair faochadh",
                "aodann a fhuair briseadh-dùil ⁊ faochadh",
                "briseadh-dùil",
                "faochadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara triste pero aliviada"),
            keywords: &[
                "agoniar",
                "alivio",
                "cara triste pero aliviada",
                "decepción",
                "estrés",
                "pinga",
                "suor",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાખ\u{ac1}શ પર\u{a82}ત\u{ac1} રાહતવાળો ચહ\u{ac7}રો"),
            keywords: &[
                "આવો",
                "ઉદાસી પર\u{a82}ત\u{ac1} રાહત ચહ\u{ac7}રો",
                "ચહ\u{ac7}રો",
                "નાખ\u{ac1}શ પર\u{a82}ત\u{ac1} રાહતવાળો ચહ\u{ac7}રો",
                "નિરાશ",
                "રાહત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska ɓata wa rai amma mai kwancin hankali"),
            keywords: &[
                "fuska",
                "fuska ɓata wa rai amma mai kwancin hankali",
                "kwancin hankali",
                "whew",
                "ɓata wa rai",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מאוכזב עם דמעה"),
            keywords: &["דמעה", "מאוכזב", "פרצוף", "פרצוף מאוכזב עם דמעה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("निराश ल\u{947}किन चि\u{902}ताम\u{941}क\u{94d}त च\u{947}हरा"),
            keywords: &[
                "आह!",
                "चि\u{902}ताम\u{941}क\u{94d}त",
                "च\u{947}हरा",
                "निराश",
                "निराश और चि\u{902}ताम\u{941}क\u{94d}त",
                "निराश ल\u{947}किन चि\u{902}ताम\u{941}क\u{94d}त च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tužno lice, ali s izrazom olakšanja"),
            keywords: &[
                "lice",
                "olakšanje",
                "razočaranje",
                "tužno lice, ali s izrazom olakšanja",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csalódott, de megkönnyebbült arc"),
            keywords: &[
                "arc",
                "csalódott",
                "csalódott, de megkönnyebbült arc",
                "huhh",
                "megkönnyebbült",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հիասթափված, բայց թեթևացած դեմք"),
            keywords: &[
                "դեմք",
                "թեթևացած",
                "հիասթափված",
                "հիասթափված, բայց թեթևացած դեմք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah kecewa namun lega"),
            keywords: &[
                "fiuh",
                "kecewa",
                "lega",
                "muka",
                "wajah",
                "wajah kecewa namun lega",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ngharịpụ mana nwere nkuda ume"),
            keywords: &[
                "ihu",
                "ihu ngharịpụ mana nwere nkuda ume",
                "nwere ngharịpụ",
                "nwere nkuda",
                "ume",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("léttir"),
            keywords: &["andlit", "hjúkk", "léttir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina delusa ma sollevata"),
            keywords: &[
                "deluso",
                "faccina",
                "faccina delusa ma sollevata",
                "sollevato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("どうしよう"),
            keywords: &["どうしよう", "困った", "汗", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai sedhih nanging lega"),
            keywords: &[
                "kuciwa",
                "lega",
                "rai",
                "rai sedhih nanging lega",
                "sedhih",
                "syukur marang gusti",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იმედგაცრუებული, მაგრამ შვების გამომხატველი სახე"),
            keywords: &[
                "იმედგაცრუებული",
                "იმედგაცრუებული, მაგრამ შვების გამომხატველი სახე",
                "სახე",
                "შვება",
            ],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("uk"),
            keywords: &["uk"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жеңілдену"),
            keywords: &["бет", "жеңілдену", "түңілу", "уфф"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skuffet men lettet ansigt"),
            keywords: &["skuffet men lettet", "skuffet men lettet ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ម\u{17bb}ខពេបមាត\u{17cb} ន\u{17b7}ងទម\u{17d2}លាក\u{17cb}ទ\u{17b9}កម\u{17bb}ខត",
            ),
            keywords: &[
                "ខកច\u{17b7}ត\u{17d2}ត",
                "បែកញើស",
                "ពេប",
                "ម\u{17bb}ខពេបមាត\u{17cb} ន\u{17b7}ងទម\u{17d2}លាក\u{17cb}ទ\u{17b9}កម\u{17bb}ខត",
                "អន\u{17cb}ច\u{17b7}ត\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ರಾಶ\u{cc6} ಆದರ\u{cc6} ಸಮಾಧಾನದ ಮುಖ"),
            keywords: &[
                "ನ\u{cbf}ರಾಶ\u{cc6}",
                "ನ\u{cbf}ರಾಶ\u{cc6} ಆದರ\u{cc6} ಸಮಾಧಾನ",
                "ನ\u{cbf}ರಾಶ\u{cc6} ಆದರ\u{cc6} ಸಮಾಧಾನದ ಮುಖ",
                "ಮುಖ",
                "ಸಮಾಧಾನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("실망했지만 안도하는 얼굴"),
            keywords: &[
                "실망감",
                "실망하는 얼굴",
                "실망했지만 안도하는 얼굴",
                "안도감",
                "얼굴",
                "휴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some(
                "द\u{941}ख\u{947}स\u{94d}त प\u{942}ण ह\u{941}स\u{94d}क\u{94d}याम\u{947}कळो च\u{947}रो",
            ),
            keywords: &[
                "च\u{947}रो",
                "द\u{941}ख\u{947}स\u{94d}त प\u{942}ण ह\u{941}स\u{94d}क\u{94d}याम\u{947}कळो च\u{947}रो",
                "निरश\u{947}ल\u{94d}लो",
                "निराश",
                "ह\u{941}सक\u{94d}याम\u{947}कळो प\u{942}ण द\u{941}ख\u{94d}खी च\u{947}रो",
                "ह\u{941}स\u{94d}क\u{94d}या म\u{947}कळ\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("капа болуп эси оогон бет"),
            keywords: &["бет", "капа", "капа болуп эси оогон бет", "эси оогон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("enttäuscht mä erliichtert"),
            keywords: &[
                "Gesiicht",
                "enttäuscht",
                "enttäuscht mä erliichtert",
                "erliichtert",
                "ouf",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຜ\u{eb4}ດຫວ\u{eb1}ງແຕ\u{ec8}ຜ\u{ec8}ອນຄາຍ"),
            keywords: &[
                "ຜ\u{eb4}ດຫວ\u{eb1}ງ",
                "ໂລ\u{ec8}ງໃຈ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຜ\u{eb4}ດຫວ\u{eb1}ງແຕ\u{ec8}ຜ\u{ec8}ອນຄາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nusivylęs veidas su palengvėjimu"),
            keywords: &[
                "nusivylęs",
                "nusivylęs veidas su palengvėjimu",
                "palengvėjimas",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīlusies un atvieglota seja"),
            keywords: &[
                "atvieglojums",
                "seja",
                "sviedri",
                "vilties",
                "vīlies",
                "vīlusies un atvieglota seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi pāpouri engari whakaoraora"),
            keywords: &[
                "kanohi",
                "kanohi pāpouri engari whakaoraora",
                "pāpōuri",
                "whakaoraora",
                "whiu",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("разочарано, но лице со олеснување"),
            keywords: &[
                "лице",
                "олеснување",
                "разочарано, но лице со олеснување",
                "разочарување",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "നിര\u{d3e}ശയ\u{d41}ണ\u{d4d}ടെങ\u{d4d}കില\u{d41}ം ആശ\u{d4d}വ\u{d3e}സഭ\u{d3e}വത\u{d4d}തില\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
            ),
            keywords: &[
                "ആശ\u{d4d}വ\u{d3e}സം",
                "നിര\u{d3e}ശ",
                "നിര\u{d3e}ശയ\u{d41}ണ\u{d4d}ടെങ\u{d4d}കില\u{d41}ം ആശ\u{d4d}വ\u{d3e}സഭ\u{d3e}വത\u{d4d}തില\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
                "വിയർപ\u{d4d}പ\u{d41}ത\u{d41}ള\u{d4d}ളി",
                "വിയർപ\u{d4d}പ\u{d4d}",
                "ഹ\u{d42}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урам хугарсан ч тайвширсан царай"),
            keywords: &[
                "тайвширсан",
                "урам хугарсан",
                "урам хугарсан ч тайвширсан царай",
                "царай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("द\u{941}ःखी पर\u{902}त\u{941} चि\u{902}ताम\u{941}क\u{94d}त च\u{947}हरा"),
            keywords: &[
                "चि\u{902}ताम\u{941}क\u{94d}त",
                "च\u{947}हरा",
                "द\u{941}ःखी पर\u{902}त\u{941} चि\u{902}ताम\u{941}क\u{94d}त च\u{947}हरा",
                "निराश",
                "निराशा व\u{94d}यक\u{94d}त करणारा च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka kecewa namun lega"),
            keywords: &["huh", "kecewa", "lega", "muka", "muka kecewa namun lega"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ diżappuntat iżda sollevat"),
            keywords: &[
                "diżappuntat",
                "għall-erwieħ",
                "sollevat",
                "wiċċ",
                "wiċċ diżappuntat iżda sollevat",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဝမ\u{103a}းနည\u{103a}းသော\u{103a}လည\u{103a}း စ\u{102d}တ\u{103a}အေးရသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "ဝမ\u{103a}းနည\u{103a}း",
                "ဝမ\u{103a}းနည\u{103a}းသော\u{103a}လည\u{103a}း စ\u{102d}တ\u{103a}သက\u{103a}သာရာရသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ဝမ\u{103a}းနည\u{103a}းသော\u{103a}လည\u{103a}း စ\u{102d}တ\u{103a}အေးရသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "အပ\u{1030}လ\u{102f}\u{1036}းကျ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("puh!"),
            keywords: &["fjes", "lettet", "puh!", "skuffet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("निराश तर चिन\u{94d}ताम\u{941}क\u{94d}त अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "चिन\u{94d}ताम\u{941}क\u{94d}त भएको",
                "निराश तर चिन\u{94d}ताम\u{941}क\u{94d}त अन\u{941}हार",
                "निराश भएको",
                "ह\u{94d}विउ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("teleurgesteld maar opgelucht gezicht"),
            keywords: &[
                "gezicht",
                "oef",
                "opgelucht",
                "teleurgesteld",
                "teleurgesteld maar opgelucht gezicht",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("puh!"),
            keywords: &["fjes", "letta", "puh", "puh!", "skuffa"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଦ\u{b41}ଖ\u{b3f}ତ କ\u{b3f}ନ\u{b4d}ତ\u{b41} ଆଶ\u{b4d}ୱସ\u{b4d}ତ ମ\u{b41}ହ\u{b01}",
            ),
            keywords: &[
                "ଆଶ\u{b4d}ୱସ\u{b4d}ତ",
                "ଦ\u{b41}ଖ\u{b3f}ତ କ\u{b3f}ନ\u{b4d}ତ\u{b41} ଆଶ\u{b4d}ୱସ\u{b4d}ତ ମ\u{b41}ହ\u{b01}",
                "ନ\u{b3f}ର\u{b3e}ଶ",
                "ମ\u{b41}ହ\u{b01}",
                "ୱେ!",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਿਰਾਸ\u{a3c} ਪਰ ਰਾਹਤ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਉਦਾਸ",
                "ਓ ਹ\u{a4b}",
                "ਚਿਹਰਾ",
                "ਨਿਰਾਸ\u{a3c} ਪਰ ਰਾਹਤ",
                "ਨਿਰਾਸ\u{a3c} ਪਰ ਰਾਹਤ ਵਾਲਾ ਚਿਹਰਾ",
                "ਰਾਹਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مایوس پر آرام دہ شکل"),
            keywords: &[
                "دی شکل",
                "سبکدوش ہونا",
                "مایوس",
                "مایوس پر آرام دہ شکل",
                "واہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nọ\u{301} Dé Hapí Bọt Dọ\u{301}n Dé Hapí"),
            keywords: &[
                "Dé Hapí",
                "Fes",
                "Fes Wé Dẹm Dọ\u{301}n Disapọint",
                "Nọ\u{301} Dé Hapí",
                "Nọ\u{301} Dé Hapí Bọt Dọ\u{301}n Dé Hapí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("smutna twarz z wyrazem ulgi"),
            keywords: &["smutna twarz z wyrazem ulgi", "smutna ulga"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پښيمانه خو دمه مخ"),
            keywords: &["اف", "دمه", "مايوسه", "مخ", "پښيمانه خو دمه مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto triste, mas aliviado"),
            keywords: &[
                "aliviado",
                "decepcionado",
                "rosto",
                "rosto triste, mas aliviado",
                "ufa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara triste, mas aliviada"),
            keywords: &[
                "aliviado",
                "cara",
                "cara triste, mas aliviada",
                "desiludido",
                "ufa",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llakisqa ichaqa llamsayasqa uya"),
            keywords: &[
                "llakisqa ichaqa llamkayasqa uya",
                "llakisqa ichaqa llamsayasqa uya",
                "llamsayasqa",
                "sunqunnasqa uya",
                "uf",
                "uya",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față dezamăgită, dar ușurată"),
            keywords: &[
                "dezamăgire",
                "față",
                "față dezamăgită, dar ușurată",
                "relaxare",
                "ușurare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-873"),
            keywords: &["E10-873"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обошлось"),
            keywords: &[
                "лицо",
                "облегчение",
                "обошлось",
                "прошло",
                "разочарование",
                "фух",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza guhemukirwa ariko ukaruhuka ku mutima"),
            keywords: &[
                "ahu",
                "isura",
                "isura igaragaza guhemukirwa ariko ukaruhuka ku mutima",
                "uruhutse",
                "yacitse intege",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اداس پر سڪون وارو چهرو"),
            keywords: &["آجو", "اداس پر سڪون وارو چهرو", "نااميد", "واه", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "බල\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}න\u{dca}ව\u{dd6} නම\u{dd4}ත\u{dca} සැනස\u{dd4}මක\u{dca} ලත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
            ),
            keywords: &[
                "බල\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}න\u{dca}ව\u{dd6}",
                "බල\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}න\u{dca}ව\u{dd6} නම\u{dd4}ත\u{dca} සැනස\u{dd4}මක\u{dca} ලත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ව\u{dd2}ව\u{dca}",
                "සැනස\u{dd4}මක\u{dca} ලත\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sklamaná, ale uvoľnená tvár"),
            keywords: &[
                "sklamaná",
                "sklamaná, ale uvoľnená tvár",
                "tvár",
                "uf",
                "uvoľnená",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("razočaran, a olajšan obraz"),
            keywords: &[
                "fiju",
                "obraz",
                "olajšano",
                "razočaran, a olajšan obraz",
                "razočarano",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji xanaaqsan laakiin dabacsan"),
            keywords: &[
                "dabacsan",
                "markaa",
                "niyadjabsan",
                "waji",
                "waji xanaaqsan laakiin dabacsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e zhgënjyer por e lehtësuar"),
            keywords: &[
                "e lehtësuar",
                "e zhgënjyer",
                "fytyrë",
                "fytyrë e zhgënjyer por e lehtësuar",
                "uf",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("разочарано лице коме је лакнуло"),
            keywords: &[
                "oлaкшaњe",
                "лице",
                "рaзoчaрaњe",
                "разочарано лице коме је лакнуло",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("razočarano lice kome je laknulo"),
            keywords: &[
                "lice",
                "olakšanje",
                "razočaranje",
                "razočarano lice kome je laknulo",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("besviket men lättat ansikte"),
            keywords: &[
                "besviken",
                "besviken men lättad",
                "besviket men lättat ansikte",
                "lättad",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("Uso wenye huzuni lakini unaoonyesha kufarijika"),
            keywords: &[
                "Uso wenye huzuni lakini unaoonyesha kufarijika",
                "faraja",
                "kufarijika",
                "kusikitika",
                "uso",
                "uso uliosikitika lakini unaoonyesha kufarijika",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஏம\u{bbe}ற\u{bcd}றமடைந\u{bcd}திருந\u{bcd}த\u{bbe}லும\u{bcd} நிம\u{bcd}மதியை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "அப\u{bcd}ப\u{bbe}ட\u{bbe}!",
                "ஏம\u{bbe}ற\u{bcd}றமடைந\u{bcd}திருந\u{bcd}த\u{bbe}லும\u{bcd} நிம\u{bcd}மதியை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
                "நிம\u{bcd}மதி பெருமூச\u{bcd}சு",
                "நிம\u{bcd}மதிய\u{bbe}க இருக\u{bcd}கிறேன\u{bcd}",
                "முடிந\u{bcd}தது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "న\u{c3f}ర\u{c3e}శ చ\u{c46}ంద\u{c3f}న\u{c3e} ఉపశమ\u{c3f}స\u{c4d}తున\u{c4d}న ముఖం",
            ),
            keywords: &[
                "ఉపశమనం",
                "న\u{c3f}ర\u{c3e}శ",
                "న\u{c3f}ర\u{c3e}శ చ\u{c46}ంద\u{c3f}న\u{c3e} ఉపశమ\u{c3f}స\u{c4d}తున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ғамгин, вале рӯи бароҳат"),
            keywords: &[
                "бароҳат",
                "рӯй",
                "фуҳ",
                "ғамгин",
                "ғамгин, вале рӯи бароҳат",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โล\u{e48}งอก"),
            keywords: &["ผ\u{e34}ดหว\u{e31}ง", "หน\u{e49}า", "โล\u{e48}งอก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gynançly, ýöne ynjalan ýüz"),
            keywords: &[
                "gynançly, ýöne ynjalan ýüz",
                "lapykeç",
                "sykylyk",
                "ynjalan",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lotomamahi kā fakanongononga"),
            keywords: &["mata lotomamahi kā fakanongononga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("üzgün ama rahatlamış yüz"),
            keywords: &[
                "canı sıkkın",
                "canı sıkkın ama rahatlamış",
                "rahatlamış",
                "yüz",
                "üzgün ama rahatlamış yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈمىدسىز ئەمما خاتىرجەم چىراي"),
            keywords: &[
                "ئۈمىدسىز",
                "ئۈمىدسىز ئەمما خاتىرجەم چىراي",
                "ئەركىن",
                "چىراي",
                "ھەي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("cумне, але втішене обличчя"),
            keywords: &[
                "cумне, але втішене обличчя",
                "обличчя",
                "полегшення",
                "розчароване, але заспокоєне обличчя",
                "розчарування",
                "фух",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مایوس لیکن پر سکون چہرہ"),
            keywords: &["مایوس", "مایوس لیکن پر سکون چہرہ", "پر سکون", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hafsalasi pir bo‘lgan yuz"),
            keywords: &[
                "hafasalasi pir",
                "hafsalasi pir bo‘lgan yuz",
                "hmm",
                "yengil tortish",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt thất vọng nhưng nhẹ nhõm"),
            keywords: &[
                "mặt",
                "mặt thất vọng nhưng nhẹ nhõm",
                "ngạc nhiên",
                "nhẹ nhõm",
                "thất vọng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu mbetteel te féex"),
            keywords: &[
                "féex",
                "kanam",
                "kanamu mbetteel te féex",
                "kapris",
                "mbetteel",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obudanileyo kodwa obuqabukileyo"),
            keywords: &[
                "danileyo",
                "eshee",
                "ubuso",
                "ubuso obudanileyo kodwa obuqabukileyo",
                "ukuqabuka",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ijakulẹ Ṣugbọn Itura"),
            keywords: &[
                "Oju Ijakulẹ Ṣugbọn Itura",
                "hmmm",
                "ojú",
                "ìjákulẹ\u{300}",
                "ìtura",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("傷心但放鬆嘅臉"),
            keywords: &["傷心但放鬆嘅臉", "呼", "失望", "放鬆", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("伤心但放松嘅脸"),
            keywords: &["伤心但放松嘅脸", "呼", "失望", "放松", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("失望但如释重负"),
            keywords: &["失望", "失望但如释重负", "如释重负", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("流汗"),
            keywords: &["沮喪", "流汗", "鬆了口氣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("失望但解脱嘅表情"),
            keywords: &["失望但解脱嘅表情", "沮喪", "鬆了口氣"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obudumele kodwa obukhululekile"),
            keywords: &[
                "dumala",
                "khululekile",
                "ubuso",
                "ubuso obudumele kodwa obukhululekile",
            ],
        },
    ],
};
#[doc = "😢"]
pub const CRYING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😢",
    codepoint: "1F622",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "crying face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat huil"),
            keywords: &["gesig", "gesig wat huil", "hartseer", "huil", "traan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚያለቅስ ፊት"),
            keywords: &["ለቅሶ", "እንባ", "የሚያለቅስ ፊት", "ያዘነ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يبكي"),
            keywords: &["حزين", "دموع", "وجه باك", "وجه يبكي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ৰন\u{9cd}দনৰত ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9cd}ৰন\u{9cd}দন",
                "ক\u{9cd}ৰন\u{9cd}দনৰত ম\u{9c1}খ",
                "চক\u{9c1}প\u{9be}নী",
                "দ\u{9c1}খী",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağlayan üz"),
            keywords: &["ağlamaq", "ağlayan üz", "göz yaşı", "qəmli", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("плача"),
            keywords: &["плач", "плача", "слёзы", "сумны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Разплакано лице"),
            keywords: &["Разплакано лице", "лице", "плач", "сълза", "тъжен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রন\u{9cd}দনরত ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9be}ন\u{9cd}ন\u{9be}",
                "ক\u{9be}ন\u{9cd}ন\u{9be}ক\u{9be}টি কর\u{9be}",
                "ক\u{9cd}রন\u{9cd}দনরত ম\u{9c1}খ",
                "দ\u{9c1}ঃখিত",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plač"),
            keywords: &["lice", "plakanje", "plač", "suza", "tuga"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que plora"),
            keywords: &["cara", "cara que plora", "llàgrimes", "trist", "trista"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇𑄚\u{11133}𑄠𑄬 𑄟\u{1112a}"),
            keywords: &["𑄇𑄚\u{11133}𑄠𑄬 𑄟\u{1112a}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏠᏱᎭ ᎤᎧᏛ"),
            keywords: &["ᎠᏠᏱᎭ", "ᎤᎧᏛ", "ᎤᏩᏍᏉᎸ", "ᎤᏲᎤᏰᎸᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("plačící obličej"),
            keywords: &[
                "plačící obličej",
                "pláč",
                "slza",
                "smajlík",
                "smutek",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn crio"),
            keywords: &["crio", "deigryn", "trist", "wyneb", "wyneb yn crio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grædende ansigt"),
            keywords: &["ansigt", "grædende ansigt", "ked af det", "tårer"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weinendes Gesicht"),
            keywords: &["Gesicht", "Träne", "traurig", "weinendes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κλάμα"),
            keywords: &["δάκρυ", "κλάμα", "πρόσωπο", "στεναχωρημένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crying face"),
            keywords: &["cry", "crying face", "face", "sad", "tear"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara llorando"),
            keywords: &["cara", "cara llorando", "llorar", "lágrima", "triste"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara con llanto"),
            keywords: &[
                "cara",
                "cara con llanto",
                "llanto",
                "llorar",
                "triste",
                "tristeza",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara llorando"),
            keywords: &["cara llorando", "llanto", "llorar", "triste", "tristeza"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara llorando"),
            keywords: &["cara llorando", "llanto", "llorar", "triste", "tristeza"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nuttev nägu"),
            keywords: &["kurb", "nutt", "nuttev nägu", "nägu", "pisar"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("negarrez ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "malko",
                "negar",
                "negarrez ari den aurpegia",
                "triste",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گریان"),
            keywords: &["اشک", "صورت", "ناراحت", "گریان", "گریه", "گریه کردن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("itkevä"),
            keywords: &["itkevä", "itku", "kyynel", "naama", "surullinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("umiiyak"),
            keywords: &["iyak", "luha", "malungkot", "nalulumbay", "umiiyak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit ið grætur"),
            keywords: &[
                "andlit",
                "andlit ið grætur",
                "grátur",
                "kedd",
                "keddur",
                "tár",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui pleure"),
            keywords: &["larmes", "visage qui pleure"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["larmes", "pleure", "triste", "visage", "visage qui pleure"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog chaointeach"),
            keywords: &["caoineadh", "deora", "gol", "straoiseog chaointeach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ caoineadh"),
            keywords: &["aodann a’ caoineadh", "brònach", "caoineadh", "deur"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara chorando"),
            keywords: &["bágoa", "cara", "cara chorando", "chorar", "triste"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રડતો ચહ\u{ac7}રો"),
            keywords: &[
                "આ\u{a82}સ\u{ac1}ઓ",
                "ચહ\u{ac7}રો",
                "દ\u{ac1}ઃખી",
                "રડતો ચહ\u{ac7}રો",
                "રડવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai kuka"),
            keywords: &["baƙin ciki", "fuska", "fuska mai kuka", "hawaye", "kuka"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף בוכה"),
            keywords: &["בוכה", "דמעה", "עצוב", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रोता च\u{947}हरा"),
            keywords: &[
                "आ\u{902}स\u{942}",
                "च\u{947}हरा",
                "द\u{941}खी",
                "रोता च\u{947}हरा",
                "रोना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje plače"),
            keywords: &["lice", "lice koje plače", "plakanje", "suze", "tuga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("síró arc"),
            keywords: &["arc", "könnycsepp", "szomorúság", "sírás", "síró arc"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("արտասվող դեմք"),
            keywords: &["արտասվել", "արտասվող դեմք", "արցունք", "դեմք", "տխուր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah menangis"),
            keywords: &[
                "air",
                "mata",
                "muka",
                "nangis",
                "sedih",
                "wajah",
                "wajah menangis",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu na-ebe akwa"),
            keywords: &["akwa", "akwarịrị", "ihu", "ihu na-ebe akwa", "nwute"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("grátandi andlit"),
            keywords: &["andlit", "depurð", "grátandi andlit", "grátur", "tár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che piange"),
            keywords: &[
                "faccina",
                "faccina che piange",
                "lacrime",
                "piangere",
                "triste",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("泣き顔"),
            keywords: &["悲しい", "泣き顔", "泣く", "涙", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai nangis"),
            keywords: &["luh", "nangis", "rai", "sedhih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მტირალა სახე"),
            keywords: &[
                "მტირალა სახე",
                "მწუხარება",
                "სახე",
                "ტირილი",
                "ცრემლი",
                "ცრემლიანი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жылау"),
            keywords: &["бет", "жылау", "көз жасы", "ренжіген"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grædende ansigt"),
            keywords: &["ansigt", "grædende ansigt", "ked af det", "tårer"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខស\u{17d2}រក\u{17cb}ទ\u{17b9}កភ\u{17d2}នែក"),
            keywords: &[
                "ទ\u{17b9}កភ\u{17d2}នែក",
                "ម\u{17bb}ខស\u{17d2}រក\u{17cb}ទ\u{17b9}កភ\u{17d2}នែក",
                "យ\u{17c6}",
                "ស\u{17d2}រក\u{17cb}ទ\u{17b9}កភ\u{17d2}នែក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಅಳು",
                "ಅಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
                "ಕಣ\u{ccd}ಣೀರು",
                "ದುಃಖ",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("우는 얼굴"),
            keywords: &["눈물", "얼굴", "우는 얼굴", "울음"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रडपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "द\u{941}ख\u{94d}खी",
                "द\u{942}क",
                "रडप",
                "रडपी च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ыйлап жаткан бет"),
            keywords: &["бет", "жаш", "капа", "ыйла", "ыйлап жаткан бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("kräischend"),
            keywords: &["Gesiicht", "Tréin", "kräischen", "kräischend", "traureg"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຮ\u{ec9}ອງໄຫ\u{ec9}"),
            keywords: &[
                "ນ\u{ecd}\u{ec9}າຕາ",
                "ຮ\u{ec9}ອງໄຫ\u{ec9}",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຮ\u{ec9}ອງໄຫ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("verkiantis veidas"),
            keywords: &["ašara", "liūdnas", "veidas", "verkiantis veidas", "verkti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("raudoša seja"),
            keywords: &[
                "asaras",
                "bēdīgs",
                "raudoša seja",
                "raudāt",
                "seja",
                "skumjas",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi tatangi"),
            keywords: &["kanohi", "kanohi tatangi", "pōuri", "roimata", "tangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("расплакано лице"),
            keywords: &["лице", "плач", "расплакано лице", "солза", "тажно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കരയ\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "കണ\u{d4d}ണീർ",
                "കരച\u{d4d}ചിൽ",
                "കരയ\u{d41}ക",
                "കരയ\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
                "സങ\u{d4d}കടം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уйлж байгаа царай"),
            keywords: &["уйлж байгаа", "уйлж байгаа царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रडणारा च\u{947}हरा"),
            keywords: &[
                "अश\u{94d}र\u{942}",
                "च\u{947}हरा",
                "द\u{941}ःखी",
                "रडणारा च\u{947}हरा",
                "रडण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka menangis"),
            keywords: &["air mata", "menangis", "muka", "sedih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jibki"),
            keywords: &["dmugħ", "imdejjaq", "jibki", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("င\u{102d}\u{102f}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "င\u{102d}\u{102f}နေခြင\u{103a}း",
                "င\u{102d}\u{102f}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "င\u{102d}\u{102f}နေသော မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}ရည\u{103a}",
                "ဝမ\u{103a}းနည\u{103a}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gråter"),
            keywords: &["fjes", "gråter", "trist", "tårer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रोएको अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "आ\u{901}श\u{941}", "द\u{941}ःखी", "रोएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("huilend gezicht"),
            keywords: &["bedroefd", "gezicht", "huilen", "huilend gezicht", "traan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("græt"),
            keywords: &["fjes", "græt", "trist", "tårer"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ନ\u{b4d}ଦ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "କ\u{b3e}ନ\u{b4d}ଦ\u{b3f}ବ\u{b3e}",
                "କ\u{b3e}ନ\u{b4d}ଦ\u{b41}ର\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ଦ\u{b41}ଃଖ",
                "ମ\u{b41}ହ\u{b01}",
                "ଲ\u{b41}ହ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰ\u{a4b}\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਉਦਾਸ",
                "ਚਿਹਰਾ",
                "ਰ\u{a4b}\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਰ\u{a4b}ਣਾ",
                "ਹ\u{a70}ਝ\u{a42}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("روندی شکل"),
            keywords: &["اتھرو", "دی شکل", "رونا", "روندی شکل", "غمگین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Krai"),
            keywords: &[
                "Dé Hapí",
                "Fes",
                "Fes Wé De Krai",
                "Fes Wé Dẹm Dọ\u{301}n Disapọint",
                "Nọ\u{301} Dé Hapí",
                "Nọ\u{301} Dé Hapí Bọt Dọ\u{301}n Dé Hapí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("płacząca twarz"),
            keywords: &["buźka ze łzą w oku", "płacząca twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ژړېدونکی مخ"),
            keywords: &["اوښکې", "مخ", "پښيمانه", "ژړل", "ژړېدونکی مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto chorando"),
            keywords: &["lágrimas", "rosto", "rosto chorando", "triste"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a chorar"),
            keywords: &["cara", "cara a chorar", "choro", "lágrima", "triste"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waqasqa uya"),
            keywords: &["llakisqa", "uya", "waqasqa uya", "waqay", "wiqi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față plângând"),
            keywords: &["față", "față plângând", "lacrimi", "plânset", "tristețe"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-870"),
            keywords: &["E10-870"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("плачет"),
            keywords: &["грусть", "лицо", "печаль", "плачет", "слезы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kurira"),
            keywords: &["isura", "isura igaragaza kurira", "kurira", "ubabaye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("روئندڙ چهرو"),
            keywords: &["روئندڙ چهرو", "روئڻ", "چهرو", "ڏکويل", "ڳوڙهو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අඬන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අඬන ම\u{dd4}හ\u{dd4}ණ",
                "ඇඬ\u{dd3}ම",
                "කඳ\u{dd4}ළ\u{dd4}",
                "ද\u{dd4}ක",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("plačúca tvár"),
            keywords: &["plakať", "plač", "plačúca tvár", "slza", "smutná", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jokajoči obraz"),
            keywords: &["jokajoči obraz", "jokanje", "obraz", "solza", "žalostno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji ooynaayo"),
            keywords: &["jeexid", "murugo", "oohin", "waji", "waji ooynaayo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që qan"),
            keywords: &["e mërzitur", "fytyrë", "fytyrë që qan", "lot", "qaj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које плаче"),
            keywords: &["лице", "лице које плаче", "плaкaњe", "сузe", "тугa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje plače"),
            keywords: &["lice", "lice koje plače", "plakanje", "suze", "tuga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gråtande ansikte"),
            keywords: &["gråtande ansikte", "gråter", "ledsen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaolia"),
            keywords: &["chozi", "huzuni", "lia", "uso", "uso unaolia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அழுகை முகம\u{bcd}"),
            keywords: &[
                "அழுகிறேன\u{bcd}",
                "அழுகை",
                "அழுகை முகம\u{bcd}",
                "கண\u{bcd}ண\u{bc0}ர\u{bcd} வருகிறது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఏడుస\u{c4d}తున\u{c4d}న ముఖం"),
            keywords: &["ఏడుపు", "ఏడుస\u{c4d}తున\u{c4d}న ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи гирён"),
            keywords: &["ашк", "гиря", "зиқ", "рӯи гирён", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e49}องไห\u{e49}"),
            keywords: &["น\u{e49}ำตา", "ร\u{e49}องไห\u{e49}", "หน\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aglaýan ýüz"),
            keywords: &["aglamak", "aglaýan ýüz", "gamgyn", "gözýaş", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata loʻimata"),
            keywords: &["mata loʻimata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağlayan yüz"),
            keywords: &["ağlayan yüz", "gözyaşları", "yüz", "üzüntülü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يىغلىغان چىراي"),
            keywords: &["غەمكىن", "ياش", "يىغا", "يىغلىغان چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що плаче"),
            keywords: &["обличчя", "обличчя, що плаче", "сльоза", "сумний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("روتا ہوا چہرہ"),
            keywords: &["آنسو", "روتا ہوا چہرہ", "رونا", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yig‘layotgan yuz"),
            keywords: &["hafa", "ko‘z yoshi", "yig‘lash", "yig‘layotgan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt khóc"),
            keywords: &["buồn", "khóc", "mặt", "nước mắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy jooy"),
            keywords: &[
                "jooy",
                "kanam",
                "kanam guy jooy",
                "rangooñ",
                "xol-bu-neexul",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obulilayo"),
            keywords: &["dakumba", "iinyembezi", "lila", "ubuso", "ubuso obulilayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ẹkun"),
            keywords: &["Oju Ẹkun", "ojú", "ìbànújẹ", "ẹkún"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("喊嘅臉"),
            keywords: &["傷心", "喊", "喊嘅臉", "眼淚", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("喊嘅脸"),
            keywords: &["伤心", "喊", "喊嘅脸", "眼泪", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("哭"),
            keywords: &["伤心", "哭", "泪", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("淚"),
            keywords: &["哭臉", "淚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("喊緊"),
            keywords: &["哭臉", "喊緊"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obukhalayo"),
            keywords: &[
                "dangala",
                "ubuso",
                "ubuso obukhalayo",
                "ukukhala",
                "unyembezi",
            ],
        },
    ],
};
#[doc = "😭"]
pub const LOUDLY_CRYING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😭",
    codepoint: "1F62D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "loudly crying face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat hard huil"),
            keywords: &[
                "gesig",
                "gesig wat hard huil",
                "hartseer",
                "huil",
                "snik",
                "traan",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በከባድ የሚያለቅስ ፊት"),
            keywords: &["ለቅሶ", "መንሰቅሰቅ", "በከባድ የሚያለቅስ ፊት", "እንባ", "ያዘነ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه يبكي بكاء\u{64b} مرتفع\u{64b}ا"),
            keywords: &["بكاء", "دموع", "صراخ", "وجه يبكي بكاء\u{64b} مرتفع\u{64b}ا"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উচ\u{9cd}চস\u{9cd}বৰে ক\u{9cd}ৰন\u{9cd}দনৰত ম\u{9c1}খ"),
            keywords: &[
                "উচ\u{9cd}চস\u{9cd}বৰে ক\u{9cd}ৰন\u{9cd}দনৰত ম\u{9c1}খ",
                "ক\u{9cd}ৰন\u{9cd}দন",
                "চক\u{9c1}প\u{9be}নী",
                "দ\u{9c1}খী",
                "ফোপনি",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bərkdən ağlayan üz"),
            keywords: &[
                "ağlamaq",
                "bərkdən ağlayan üz",
                "göz yaşı",
                "hönkürtü",
                "qəmli",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("плача ўголас"),
            keywords: &["плача ўголас", "рыданне", "слёзы", "сумны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Силно плачещо лице"),
            keywords: &["Силно плачещо лице", "лице", "плач", "сълза", "тъжен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জোরে ক\u{9cd}রন\u{9cd}দনরত ম\u{9c1}খ"),
            keywords: &[
                "অশ\u{9cd}র\u{9c1}সজল ম\u{9c1}খ",
                "ক\u{9be}ন\u{9cd}ন\u{9be}",
                "ক\u{9be}ন\u{9cd}ন\u{9be}ক\u{9be}টি কর\u{9be}",
                "জোরে ক\u{9cd}রন\u{9cd}দনরত ম\u{9c1}খ",
                "দ\u{9c1}ঃখিত",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("glasan plač"),
            keywords: &["glasan plač", "jecanje", "lice", "plakanje", "tuga"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que plora desconsoladament"),
            keywords: &[
                "cara",
                "cara que plora desconsoladament",
                "llàgrimes de desconsol",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄎\u{1112e}𑄢𑄬 𑄎\u{1112e}𑄢𑄬 𑄇𑄚\u{11133}𑄠𑄬 𑄟\u{1112a}"),
            keywords: &["𑄎\u{1112e}𑄢𑄬 𑄎\u{1112e}𑄢𑄬 𑄇𑄚\u{11133}𑄠𑄬 𑄟\u{1112a}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎭᎳᏓ ᎠᏠᏱᏍᎩ ᎤᎧᏛ"),
            keywords: &["ᎠᏠᏱᎭ", "ᎠᏠᏱᏍᎩ", "ᎤᎧᏛ", "ᎤᏩᏍᏉᎸ", "ᎤᏲᎭᏰᎸᏅ", "ᏗᎭᎳᏓ ᎠᏠᏱᏍᎩ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zoufale plačící obličej"),
            keywords: &[
                "nářek",
                "pláč",
                "slza",
                "smajlík",
                "smutek",
                "tvář",
                "výraz",
                "zoufale plačící obličej",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn beichio crio"),
            keywords: &["crio", "deigryn", "trist", "wyneb", "wyneb yn beichio crio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stortudende ansigt"),
            keywords: &[
                "græde",
                "hulke",
                "stortude",
                "stortudende ansigt",
                "ulykkelig",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("heulendes Gesicht"),
            keywords: &["Gesicht", "Tränen", "heulendes Gesicht", "traurig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γοερό κλάμα"),
            keywords: &[
                "γοερό κλάμα",
                "δάκρυ",
                "κλάμα",
                "λυγμός",
                "πρόσωπο",
                "στεναχωρημένος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("loudly crying face"),
            keywords: &["cry", "face", "loudly crying face", "sad", "sob", "tear"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara llorando fuerte"),
            keywords: &[
                "cara",
                "cara llorando fuerte",
                "llorar",
                "lágrima",
                "triste",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "cara llorando fuerte", "llorar", "lágrimas"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valjusti nuttev nägu"),
            keywords: &[
                "kurb",
                "nutmine",
                "nutt",
                "nägu",
                "pisar",
                "valjusti nuttev nägu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("negar eta negar ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "malko",
                "negar",
                "negar eta negar ari den aurpegia",
                "triste",
                "zotinka",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("هق\u{200c}هق گریه"),
            keywords: &[
                "اشک",
                "صورت",
                "ناراحت",
                "هق\u{200c}هق",
                "هق\u{200c}هق گریه",
                "گریه کردن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ääneen itkevä"),
            keywords: &[
                "itku",
                "kyynel",
                "naama",
                "nyyhky",
                "surullinen",
                "ääneen itkevä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("umiiyak nang malakas"),
            keywords: &[
                "humahagulhol",
                "iyak",
                "luha",
                "malungkot",
                "mukha",
                "umiiyak nang malakas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andlit sum grætur nógv"),
            keywords: &[
                "andlit",
                "andlit sum grætur nógv",
                "grátur",
                "kedd",
                "keddur",
                "tár",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui pleure à chaudes larmes"),
            keywords: &[
                "larme",
                "pleurs",
                "triste",
                "visage",
                "visage qui pleure à chaudes larmes",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "chaudes larmes",
                "pleure",
                "sanglot",
                "triste",
                "visage",
                "visage qui pleure à chaudes larmes",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag caoineadh os ard"),
            keywords: &[
                "caoineadh go hard",
                "deora",
                "gol go hard",
                "straoiseog ag caoineadh os ard",
                "straoiseog chaointeach os ard",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ rànaich"),
            keywords: &[
                "aodann a’ rànaich",
                "brònach",
                "caoineadh",
                "deur",
                "gal",
                "rànaich",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara chorando desconsoladamente"),
            keywords: &[
                "bágoas",
                "cara",
                "cara chorando desconsoladamente",
                "chorar",
                "desconsolo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોટ\u{ac7}થી રડતો ચહ\u{ac7}રો"),
            keywords: &[
                "અશ\u{acd}ર\u{ac1}",
                "ચહ\u{ac7}રો",
                "મોટ\u{ac7}થી રડતો ચહ\u{ac7}રો",
                "મોટ\u{ac7}થી રડવ\u{ac1}\u{a82}",
                "રડવ\u{ac1}\u{a82}",
                "ર\u{ac1}દન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai kuka da ƙarfi"),
            keywords: &[
                "baƙin ciki",
                "fuska",
                "fuska mai kuka da ƙarfi",
                "hawaye",
                "kuka",
                "kuka da shassheƙa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף בוכה בקול"),
            keywords: &["בוכה", "בקול", "דמעות", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{93c}ोर–ज\u{93c}ोर स\u{947} रोता च\u{947}हरा"),
            keywords: &[
                "आ\u{902}स\u{942}",
                "च\u{947}हरा",
                "ज\u{93c}ोर–ज\u{93c}ोर स\u{947} रोता च\u{947}हरा",
                "ज\u{93c}ोर–ज\u{93c}ोर स\u{947} रोना",
                "रोता ह\u{941}आ",
                "रोना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje glasno plače"),
            keywords: &[
                "lice",
                "lice koje glasno plače",
                "plakanje",
                "ridanje",
                "suze",
                "tuga",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zokogó arc"),
            keywords: &[
                "arc",
                "könnyek",
                "szomorúság",
                "sírás",
                "zokogás",
                "zokogó arc",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրաձայն արտասվող դեմք"),
            keywords: &[
                "արցունք",
                "բարձրաձայն",
                "բարձրաձայն արտասվող դեմք",
                "լաց",
                "հեկեկալ",
                "տխուր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah menangis keras"),
            keywords: &[
                "bombay",
                "muka",
                "nangis",
                "sedih",
                "tersedu-sedu",
                "wajah",
                "wajah menangis keras",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu akwa mkpu"),
            keywords: &["akwa", "echemụ", "echiche", "ihu", "ihu akwa mkpu", "mwute"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hágrátandi andlit"),
            keywords: &[
                "andlit",
                "grátandi andlit",
                "grátur",
                "hágrátandi andlit",
                "sorg",
                "tár",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina disperata"),
            keywords: &[
                "faccina",
                "faccina disperata",
                "lacrime",
                "piangere",
                "pianto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("大泣き"),
            keywords: &["号泣", "大泣き", "悲しい", "泣く", "涙", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai nangis kejer"),
            keywords: &[
                "luh",
                "nangis",
                "rai",
                "rai nangis kejer",
                "sedhih",
                "sengguk-sengguk",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხმამაღლა მტირალა სახე"),
            keywords: &[
                "მწუხარება",
                "სახე",
                "ტირილი",
                "ქვითინი",
                "ცრემლი",
                "ცრემლიანი",
                "ხმამაღლა მტირალა სახე",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айқайлап жылау"),
            keywords: &[
                "айқайлап жылау",
                "бет",
                "боздау",
                "жылау",
                "көз жасы",
                "ренжіген",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grådkvalt ansigt"),
            keywords: &["grådkvalt ansigt", "græder", "tårer"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខក\u{17c6}ព\u{17bb}ងយ\u{17c6}យ\u{17c9}ាងខ\u{17d2}លា\u{17c6}ង"),
            keywords: &[
                "ទ\u{17b9}កភ\u{17d2}នែក",
                "ម\u{17bb}ខក\u{17c6}ព\u{17bb}ងយ\u{17c6}យ\u{17c9}ាងខ\u{17d2}លា\u{17c6}ង",
                "យ\u{17c6}",
                "យ\u{17c6}ខ\u{17d2}លា\u{17c6}ង",
                "ហ\u{17bc}រទ\u{17b9}កភ\u{17d2}នែក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೋರಾಗ\u{cbf} ಅಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಅಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
                "ಜೋರಾಗ\u{cbf} ಅಳುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
                "ಜೋರಾಗ\u{cbf} ಅಳುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엉엉 우는 얼굴"),
            keywords: &["눈물", "대성통곡", "얼굴", "엉엉 우는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}हडल\u{94d}यान रडपी च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "द\u{941}ख\u{94d}खी",
                "द\u{942}क",
                "रडप",
                "व\u{94d}हडल\u{94d}यान रडपी च\u{947}रो",
                "ह\u{941}डक\u{947}वप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ботодой боздогон бет"),
            keywords: &["бет", "боздо", "ботодой боздогон бет", "жаш", "капа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("haart kräischend Gesiicht"),
            keywords: &[
                "Gesiicht",
                "Tréin",
                "haart kräischend Gesiicht",
                "kräischen",
                "schluchzen",
                "traureg",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຮ\u{ec9}ອງໄຫ\u{ec9}ສຽງດ\u{eb1}ງ"),
            keywords: &[
                "ນ\u{ecd}\u{ec9}າຕາ",
                "ຮ\u{ec9}ອງໄຫ\u{ec9}",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຮ\u{ec9}ອງໄຫ\u{ec9}ສຽງດ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("garsiai raudantis veidas"),
            keywords: &[
                "ašara",
                "garsiai raudantis veidas",
                "liūdnas",
                "raudoti",
                "veidas",
                "verkti",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("aizgūtnēm raudoša seja"),
            keywords: &[
                "aizgūtnēm raudoša seja",
                "asaras",
                "bēdas",
                "raudāt",
                "seja",
                "skumjš",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi tangi reonui"),
            keywords: &[
                "hotu",
                "kanohi",
                "kanohi tangi reonui",
                "pōuri",
                "roimata",
                "tangi",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("гласно расплакано лице"),
            keywords: &[
                "вкус",
                "гласно расплакано лице",
                "лице",
                "лице со исплазен јазик и затворени очи",
                "ужасно",
                "јазик",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പൊട\u{d4d}ടിക\u{d4d}കരയ\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "ഉറക\u{d4d}കെ കരയ\u{d41}ക",
                "കണ\u{d4d}ണീർ",
                "കരയ\u{d41}ക",
                "തേങ\u{d4d}ങൽ",
                "പൊട\u{d4d}ടിക\u{d4d}കരയ\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "പൊട\u{d4d}ടിക\u{d4d}കരയൽ",
                "മ\u{d41}ഖം",
                "സങ\u{d4d}കടം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цурхиран уйлж байгаа царай"),
            keywords: &["уйлaх", "царай", "цурхиран уйлж байгаа царай", "цурхирах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मोठ\u{94d}यान\u{947} रडणारा च\u{947}हरा"),
            keywords: &[
                "अश\u{94d}र\u{942}",
                "च\u{947}हरा",
                "द\u{941}ःखी",
                "मोठ\u{94d}यान\u{947} रडणारा च\u{947}हरा",
                "रडण\u{947}",
                "ह\u{941}\u{902}दका",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka meraung"),
            keywords: &["air mata", "menangis", "muka", "muka meraung", "sedih"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ jibki jgħajjat"),
            keywords: &[
                "dmugħ",
                "imdejjaq",
                "jibki",
                "jolfoq",
                "wiċċ",
                "wiċċ jibki jgħajjat",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ကျယ\u{103a}လောင\u{103a}စ\u{103d}ာ င\u{102d}\u{102f}နေသော မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ကျယ\u{103a}လောင\u{103a}စ\u{103d}ာ င\u{102d}\u{102f}နေသော မျက\u{103a}န\u{103e}ာ",
                "ကျယ\u{103a}လောင\u{103a}စ\u{103d}ာင\u{102d}\u{102f}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "င\u{102d}\u{102f}နေခြင\u{103a}း",
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}ရည\u{103a}",
                "ဝမ\u{103a}းနည\u{103a}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("strigråter"),
            keywords: &["fjes", "gråt", "strigråter", "tårer"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जोडल\u{947} रोएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "आ\u{901}श\u{941}",
                "जोडल\u{947} रोएको अन\u{941}हार",
                "द\u{941}ःखी",
                "रोएको",
                "स\u{941}क\u{94d}कस\u{941}क\u{94d}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hard huilend gezicht"),
            keywords: &[
                "bedroefd",
                "gezicht",
                "hard huilend gezicht",
                "huilen",
                "snikken",
                "traan",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("strigræt"),
            keywords: &["fjes", "gråt", "strigræt", "tårer"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜୋରରେ କ\u{b3e}ନ\u{b4d}ଦ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "କ\u{b3e}ନ\u{b4d}ଦ\u{b3f}ବ\u{b3e}",
                "ଜୋରରେ କ\u{b3e}ନ\u{b4d}ଦ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ଜୋର\u{b4d}\u{200c}ରେ କ\u{b3e}ନ\u{b4d}ଦ\u{b3f}ବ\u{b3e}",
                "ଦ\u{b41}ଃଖୀ",
                "ମ\u{b41}ହ\u{b01}",
                "ଲ\u{b41}ହ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਚੀ-ਉ\u{a71}ਚੀ ਰ\u{a4b}\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਉ\u{a71}ਚੀ ਉ\u{a71}ਚੀ ਰ\u{a4b}ਣਾ",
                "ਉ\u{a71}ਚੀ-ਉ\u{a71}ਚੀ ਰ\u{a4b}\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਚਿਹਰਾ",
                "ਰ\u{a4b}ਣਾ",
                "ਹ\u{a70}ਝ\u{a42}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اوچا روندی شکل"),
            keywords: &[
                "اتھرو",
                "اوچا روندی شکل",
                "دی شکل",
                "رونا",
                "غمگین",
                "ہچکی لینا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Kraí Láud Laud"),
            keywords: &["Fes", "Fes Wé De Kraí Láud Laud", "Krai", "Tias"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("głośno płacząca twarz"),
            keywords: &["głośno płacząca twarz", "zapłakana buźka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوړ غږ ژړا مخ"),
            keywords: &[
                "اوښکې",
                "سلګۍ",
                "لوړ غږ ژړا مخ",
                "مخ",
                "په لوړ غږ ژړا مخ",
                "پښيمانه",
                "ژړل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto chorando aos berros"),
            keywords: &[
                "chorando",
                "chorar",
                "lágrimas",
                "rosto",
                "rosto chorando aos berros",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a chorar perdidamente"),
            keywords: &[
                "cara",
                "cara a chorar perdidamente",
                "choro",
                "lágrima",
                "soluço",
                "triste",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waqasqa uya wiqikunawan"),
            keywords: &[
                "llaki",
                "llakisqa",
                "uya",
                "waqasqa uya wiqikunawan",
                "wiqi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față plângând zgomotos"),
            keywords: &[
                "față",
                "față plângând zgomotos",
                "lacrimi",
                "plâns",
                "suspin",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-881"),
            keywords: &["E10-881"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("слезы рекой"),
            keywords: &["крокодильи слезы", "плач", "плачет", "рев", "слезы рекой"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kurira cyane"),
            keywords: &[
                "ikiniga",
                "isura",
                "isura igaragaza kurira cyane",
                "kurira",
                "ubabaye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏي آواز سان روئندڙ چهرو"),
            keywords: &[
                "روئڻ",
                "سڏڪڻ",
                "وڏي آواز سان روئندڙ چهرو",
                "چهرو",
                "ڏکويل",
                "ڳوڙهو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හය\u{dd2}යෙන\u{dca} අඩන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ඇඬ\u{dd3}ම",
                "කඳ\u{dd4}ළ\u{dd4}",
                "ද\u{dd4}ක",
                "ම\u{dd4}හ\u{dd4}ණ",
                "හය\u{dd2}යෙන\u{dca} අඩන ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nariekajúca tvár"),
            keywords: &[
                "nariekajúca tvár",
                "nariekať",
                "plač",
                "slza",
                "smutná",
                "tvár",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("cmerajoči obraz"),
            keywords: &[
                "cmerajoči obraz",
                "ihtenje",
                "jokanje",
                "obraz",
                "solze",
                "žalostno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji zaaid u ooynaayo"),
            keywords: &["jeexid", "murugo", "oohin", "waji", "waji zaaid u ooynaayo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë që qan me zë"),
            keywords: &[
                "dënesë",
                "fytyrë",
                "fytyrë që qan me zë",
                "i mërzitur",
                "lot",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које рида"),
            keywords: &[
                "лице",
                "лице које рида",
                "плaкaњe",
                "сузe",
                "тугa",
                "јецање",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje rida"),
            keywords: &[
                "jecanje",
                "lice",
                "lice koje rida",
                "plakanje",
                "suze",
                "tuga",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("storgråtande ansikte"),
            keywords: &["gråt", "gråter", "storgråtande ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaolia kwa sauti"),
            keywords: &[
                "chozi",
                "huzuni",
                "kulia",
                "lia",
                "uso",
                "uso unaolia kwa sauti",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சத\u{bcd}தம\u{bbe}க அழும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அழுதுவிடுவேன\u{bcd}",
                "சத\u{bcd}தம\u{bbe}க அழுகை",
                "சத\u{bcd}தம\u{bbe}க அழும\u{bcd} முகம\u{bcd}",
                "முடியவில\u{bcd}லையே",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గట\u{c4d}ట\u{c3f}గ\u{c3e} ఏడుస\u{c4d}తున\u{c4d}న ముఖం"),
            keywords: &[
                "ఏడుపు",
                "గట\u{c4d}ట\u{c3f}గ\u{c3e} ఏడుస\u{c4d}తున\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи баланд гириста истода"),
            keywords: &[
                "ашк",
                "гиря",
                "зиқ",
                "рӯи баланд гириста истода",
                "рӯй",
                "ҳиқ-ҳиқ карда гиря кардан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ร\u{e49}องไห\u{e49}โฮ"),
            keywords: &[
                "น\u{e49}ำตา",
                "ร\u{e49}องไห\u{e49}",
                "ร\u{e49}องไห\u{e49}โฮ",
                "หน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("möňňürýän ýüz"),
            keywords: &[
                "aglamak",
                "gamgyn",
                "gözýaş",
                "möňňürýän ýüz",
                "sojamak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata loʻimata lahi"),
            keywords: &["mata loʻimata lahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("avaz avaz ağlayan yüz"),
            keywords: &["avaz avaz ağlayan yüz", "ağlama", "gözyaşları", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۆكسۈپ يىغلىغان چىراي"),
            keywords: &[
                "ئۆكسۈش",
                "ئۆكسۈپ يىغلىغان چىراي",
                "غەمكىن",
                "ياش",
                "يىغا",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що гучно ридає"),
            keywords: &[
                "обличчя",
                "обличчя, що гучно ридає",
                "плач",
                "ридання",
                "сльоза",
                "сумний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("زار و قطار روتا چہرہ"),
            keywords: &["آنسو", "رونا", "زار و قطار روتا چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xo‘ngrab yig‘layotgan yuz"),
            keywords: &[
                "hafa",
                "ko‘z yoshi",
                "xo‘ngrab yig‘lash",
                "xo‘ngrab yig‘layotgan yuz",
                "yig‘lash",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt khóc to"),
            keywords: &[
                "buồn",
                "khóc",
                "mặt",
                "mặt khóc to",
                "nước mắt",
                "thổn thức",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy jooy ca kaw"),
            keywords: &[
                "jooy",
                "kanam",
                "kanam guy jooy ca kaw",
                "rangooñ",
                "sob",
                "xol-bu-neexul",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obulilayo ngokuvakalayo"),
            keywords: &[
                "befunyeka",
                "dakumba",
                "iinyembezi",
                "lila",
                "ubuso",
                "ubuso obulilayo ngokuvakalayo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti n Sunkun Gidi"),
            keywords: &["Oju Ti n Sunkun Gidi", "ojú", "sunkún", "ìbànújẹ", "ẹkún"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("大喊嘅臉"),
            keywords: &["傷心", "喊", "嗚咽", "大喊嘅臉", "眼淚", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("大喊嘅脸"),
            keywords: &["伤心", "呜咽", "喊", "大喊嘅脸", "眼泪", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("放声大哭"),
            keywords: &["哭", "大哭", "放声大哭", "泪", "痛哭", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("哭"),
            keywords: &["哭", "哭臉", "淚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("放聲大哭"),
            keywords: &["哭臉", "放聲大哭", "淚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("khala kakhulu"),
            keywords: &["dangala", "khala", "khala kakhulu", "ubuso", "unyembezi"],
        },
    ],
};
#[doc = "😱"]
pub const FACE_SCREAMING_IN_FEAR: crate::Emoji = crate::Emoji {
    glyph: "😱",
    codepoint: "1F631",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "face screaming in fear",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat beangs skree"),
            keywords: &[
                "bang",
                "beangs",
                "bevrees",
                "gesig",
                "gesig wat beangs skree",
                "skree",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በፍርሃት የሚጮኽ ፊት"),
            keywords: &["በፍርሃት የሚጮኽ ፊት", "የተሳቀቀ", "ጥርስ መንከስ", "ጩኸት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه خائف يصرخ"),
            keywords: &[
                "خوف",
                "مرعوب",
                "وجه يصرخ خوف\u{64b}ا",
                "يصرخ خوف\u{64b}ا",
                "\u{202b}وجه خائف يصرخ",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভয\u{9bc}ত চিৎক\u{9be}ৰ কৰ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "চিৎক\u{9be}ৰ",
                "ভয\u{9bc}",
                "ভয\u{9bc}ত চিৎক\u{9be}ৰ কৰ\u{9be} ম\u{9c1}খ",
                "ভয\u{9bc}ভীত",
                "ভয\u{9bc}\u{9be}ৰ\u{9cd}ত",
                "ম\u{9be}ঞ\u{9cd}চ",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qorxudan çığıran üz"),
            keywords: &[
                "qorxu",
                "qorxudan çığıran üz",
                "qorxulu",
                "çeynəmək",
                "çığırmaq",
                "ürkmüş",
                "üz",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("спалохана крычыць"),
            keywords: &["жах", "крык", "напалоханы", "спалохана крычыць", "страх"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице, крещящо от страх"),
            keywords: &["Лице, крещящо от страх", "вик", "изплашен", "лице", "страх"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভয\u{9bc}ে চিৎক\u{9be}র কর\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "খোল\u{9be} ম\u{9c1}খ",
                "চিৎক\u{9be}র কর\u{9be}",
                "ভয\u{9bc}",
                "ভয\u{9bc}ে চিৎক\u{9be}র কর\u{9be} ম\u{9c1}খ",
                "ভীত",
                "ভীতিজনক",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vrištanje od straha"),
            keywords: &[
                "lice",
                "prestrašen",
                "strah",
                "strašljiv",
                "vrisak",
                "vrištanje od straha",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que crida de por"),
            keywords: &[
                "cara",
                "cara que crida de por",
                "crit de por",
                "pànic",
                "terror",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎨᎷᎲᏍᎦ ᎾᏍᎩ ᎦᎾᏰᎯᏍᏗ"),
            keywords: &["ᎠᏍᎦᎢᎭ", "ᎤᎧᏛ", "ᎤᎧᏛᎢ ᎨᎷᎲᏍᎦ ᎾᏍᎩ ᎦᎾᏰᎯᏍᏗ", "ᎤᏍᎦᎡᎯ", "ᎤᏪᎷᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej křičící hrůzou"),
            keywords: &[
                "děs",
                "hrůza",
                "munch",
                "obličej křičící hrůzou",
                "smajlík",
                "strach",
                "tvář",
                "výkřik",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn sgrechian ag ofn"),
            keywords: &[
                "arswyd",
                "braw",
                "ofn",
                "wyneb",
                "wyneb yn sgrechian ag ofn",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skrigende ansigt"),
            keywords: &["angst", "skrigende ansigt", "skriget"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("vor Angst schreiendes Gesicht"),
            keywords: &[
                "Angst",
                "Gesicht",
                "schreien",
                "vor Angst schreiendes Gesicht",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ουρλιαχτό φόβου"),
            keywords: &[
                "ανοιχτό στόμα",
                "ουρλιαχτό",
                "ουρλιαχτό φόβου",
                "πρόσωπο",
                "τρομαγμένος",
                "φοβισμένος",
                "φόβος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("face screaming in fear"),
            keywords: &[
                "face",
                "face screaming in fear",
                "fear",
                "munch",
                "scared",
                "scream",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "Munch",
                "face",
                "face screaming in fear",
                "fear",
                "scared",
                "scream",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara gritando de miedo"),
            keywords: &[
                "asustado",
                "cara",
                "cara gritando de miedo",
                "miedo",
                "pánico",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de terror"),
            keywords: &[
                "cara",
                "cara de terror",
                "grito",
                "horror",
                "miedo",
                "terror",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara gritando de miedo"),
            keywords: &[
                "cara gritando de miedo",
                "grito",
                "horror",
                "miedo",
                "terror",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara gritando de miedo"),
            keywords: &[
                "cara gritando de miedo",
                "grito",
                "horror",
                "miedo",
                "terror",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hirmunult karjuv nägu"),
            keywords: &[
                "hirm",
                "hirmul",
                "hirmunud",
                "hirmunult karjuv nägu",
                "karje",
                "munch",
                "nägu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("beldurrez oihuka ari den aurpegia"),
            keywords: &[
                "aurpegi",
                "beldur",
                "beldurrez oihuka ari den aurpegia",
                "beldurti",
                "beldurtu",
                "izutu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جیغ ترس"),
            keywords: &[
                "ترس",
                "ترسناک",
                "ترسیده",
                "جویدن ناخن از ترس",
                "جیغ",
                "صورت",
                "وحشتناک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pelokas huuto"),
            keywords: &["Munch", "huuto", "naama", "pelko", "pelokas"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sumisigaw sa takot"),
            keywords: &[
                "kabado",
                "mukha",
                "natatakot",
                "sumisigaw",
                "sumisigaw sa takot",
                "takot",
                "tumitili",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skríggjandi andlit"),
            keywords: &[
                "andlit",
                "angist",
                "bangilsi",
                "ræðsla",
                "skríggjandi",
                "ótti",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage qui hurle de peur"),
            keywords: &[
                "cri",
                "effrayé",
                "peur",
                "visage",
                "visage qui hurle de peur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cri",
                "munch",
                "peur",
                "terreur",
                "visage",
                "visage qui hurle de peur",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog ag béiceach amach le heagla"),
            keywords: &[
                "béic",
                "eagla",
                "faitíos",
                "scread",
                "straoiseog ag béiceach amach le heagla",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ leigeil sgreuch eagail"),
            keywords: &[
                "an t-eagal air",
                "aodann",
                "aodann a’ leigeil sgreuch eagail",
                "eagal",
                "eagalach",
                "munch",
                "sgread",
                "sgreuch",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara berrando de medo"),
            keywords: &[
                "aterrorizar",
                "berrar",
                "cara",
                "cara berrando de medo",
                "medo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભયમા\u{a82} ચીસો પાડતો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ભય",
                "ભયગ\u{acd}રસ\u{acd}ત",
                "ભયભીત",
                "ભયમા\u{a82} ચીસો પાડતો ચહ\u{ac7}રો",
                "ભયમા\u{a82} ચીસો પાડવી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai yin ƙara a cikin tsoro"),
            keywords: &[
                "ci abinci da sauri",
                "fuska",
                "fuska mai yin ƙara a cikin tsoro",
                "jin tsoro",
                "mai tsoro",
                "tsoro",
                "yi ƙara",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף צורח בפחד"),
            keywords: &[
                "אימה",
                "בהלה",
                "מונק",
                "פחד",
                "פרצוף",
                "פרצוף צורח בפחד",
                "צועק",
                "צורח",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("डर स\u{947} चिल\u{94d}लाता च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "डर",
                "डर स\u{947} चिल\u{94d}लाता च\u{947}हरा",
                "डर स\u{947} चिल\u{94d}लाना",
                "डरा ह\u{941}आ",
                "डरा ह\u{941}आ च\u{947}हरा",
                "भयभीत",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lice koje vrišti od straha"),
            keywords: &[
                "krik",
                "lice",
                "lice koje vrišti od straha",
                "munch",
                "strah",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("félelemtől sikoltó arc"),
            keywords: &[
                "arc",
                "félelem",
                "félelemtől sikoltó arc",
                "munch",
                "rémület",
                "sikoly",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վախից գոռացող դեմք"),
            keywords: &[
                "դեմք",
                "ծամել",
                "ճչալ",
                "սարսափած",
                "վախեցած",
                "վախից գոռացող դեմք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah sangat ketakutan"),
            keywords: &[
                "berteriak",
                "ketakutan",
                "mengunyah",
                "takut",
                "wajah",
                "wajah sangat ketakutan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu na-eti n’ụjọ"),
            keywords: &[
                "eti mkpu",
                "ihu",
                "ihu na-eti n’ụjọ",
                "mkpụ",
                "na-atụ ụjọ",
                "nwere ụjọ",
                "ụjọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("óttaslegið andlit"),
            keywords: &[
                "andlit",
                "hræðsla",
                "óttaslegið andlit",
                "ótti",
                "öskra af ótta",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina terrorizzata"),
            keywords: &["faccina", "grido di paura", "paura", "terrorizzata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("恐怖"),
            keywords: &["がーん", "ショック", "叫び", "恐怖", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai mbengok keweden"),
            keywords: &[
                "keweden",
                "njerit",
                "nruthuk",
                "rai",
                "rai mbengok keweden",
                "wedi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე, რომელიც შიშისგან კივის"),
            keywords: &[
                "კივილი",
                "სახე",
                "სახე, რომელიც შიშისგან კივის",
                "შეშინებული",
                "შიში",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("зәресі ұшу"),
            keywords: &[
                "айқайлау",
                "бет",
                "зәресі ұшу",
                "сылпылдату",
                "қорыққан",
                "қорқыныш",
                "қорқынышты",
                "үріккен",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skrigende ansigt"),
            keywords: &["angst", "skrigende ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខស\u{17d2}រែកដោយភ\u{17d0}យ"),
            keywords: &["ម\u{17bb}ខស\u{17d2}រែកដោយភ\u{17d0}យ", "ស\u{17d2}រែក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಭಯದ\u{cbf}ಂದ ಅರಚುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ"),
            keywords: &[
                "ಭಯದ ಮುಖ",
                "ಭಯದ\u{cbf}ಂದ ಅರಚುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಖ",
                "ಭಯದ\u{cbf}ಂದ ಕ\u{cbf}ರುಚುವ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공포에 절규하는 얼굴"),
            keywords: &[
                "공포",
                "공포에 절규하는 얼굴",
                "비명",
                "소리 지르는 얼굴",
                "얼굴",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भिय\u{947}ल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "काचाब\u{942}ल",
                "च\u{947}रो",
                "भ\u{902}य",
                "भिय\u{947}ल\u{94d}लो",
                "भिवपी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("коркконунан кыйкырып жаткан бет"),
            keywords: &[
                "бет",
                "коркконунан кыйкырып жаткан бет",
                "коркуп калган",
                "коркуу",
                "кыйкыр",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("vun Angscht jäizend Gesiicht"),
            keywords: &[
                "Angscht",
                "Gesiicht",
                "baang",
                "jäizen",
                "verschléngen",
                "verängschtegt",
                "vun Angscht jäizend Gesiicht",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າກ\u{eb5}ດຮ\u{ec9}ອງຢ\u{ec9}ານກ\u{ebb}ວ"),
            keywords: &[
                "ກ\u{eb5}ດຮ\u{ec9}ອງ",
                "ຢ\u{ec9}ານກ\u{ebb}ວ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າກ\u{eb5}ດຮ\u{ec9}ອງຢ\u{ec9}ານກ\u{ebb}ວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("iš baimės šaukiantis veidas"),
            keywords: &[
                "baimė",
                "iš baimės šaukiantis veidas",
                "išsigandęs",
                "veidas",
                "šauksmas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bailēs kliedzoša seja"),
            keywords: &[
                "Munks",
                "bailes",
                "bailēs kliedzoša seja",
                "kliedziens",
                "nobijies",
                "seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi ūmere i te wehi"),
            keywords: &[
                "kanohi",
                "kanohi ūmere i te wehi",
                "mataku",
                "ngangau",
                "wehi",
                "wewehi",
                "ūmere",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице кое вреска од страв"),
            keywords: &[
                "вресок",
                "исплашено",
                "лице",
                "лице кое вреска од страв",
                "уплашено",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഭയന\u{d4d}ന\u{d4d} നിലവിളിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "അലറിക\u{d4d}കരയ\u{d41}ക",
                "ചവയ\u{d4d}ക\u{d4d}ക\u{d41}ക",
                "ഭയം",
                "ഭയന\u{d4d}ന",
                "ഭയന\u{d4d}ന\u{d4d} നിലവിളിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("айгаад орилж байгаа царай"),
            keywords: &["айгаад орилж байгаа царай", "айх", "орилох", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भीतीग\u{94d}रस\u{94d}त च\u{947}हरा"),
            keywords: &[
                "कि\u{902}चाळण\u{947}",
                "घाबरल\u{947}ला",
                "च\u{947}हरा",
                "भीती",
                "भीतीग\u{94d}रस\u{94d}त च\u{947}हरा",
                "भीतीदायक",
                "रव\u{902}थ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka menjerit ketakutan"),
            keywords: &[
                "gentar",
                "mengunyah",
                "menjerit",
                "muka menjerit ketakutan",
                "takut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ iwerżaq bil-biża’"),
            keywords: &[
                "biża’",
                "għomod",
                "imbeżża’",
                "tal-biża’",
                "werżaq",
                "wiċċ",
                "wiċċ iwerżaq bil-biża’",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ကြောက\u{103a}လန\u{1037}\u{103a}စ\u{103d}ာ အော\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "ကြောက\u{103a}ရ\u{103d}\u{1036}\u{1037}ခြင\u{103a}း",
                "ကြောက\u{103a}လန\u{1037}\u{103a}စ\u{103d}ာ အော\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
                "ကြောက\u{103a}လန\u{1037}\u{103a}စ\u{103d}ာအော\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ထ\u{102d}တ\u{103a}လန\u{1037}\u{103a}ခြင\u{103a}း",
                "မျက\u{103a}န\u{103e}ာ",
                "အော\u{103a}ဟစ\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("livredd"),
            keywords: &[
                "fjes", "frykt", "livredd", "munch", "redd", "skremt", "skrik",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("डरल\u{947} चिच\u{94d}चाएको अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "चपाउन\u{947}",
                "चिच\u{94d}याउन\u{947}",
                "डरलाग\u{94d}दो",
                "डरल\u{947} चिच\u{94d}चाएको अन\u{941}हार",
                "डराएको",
                "भयवित",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("angstig schreeuwend gezicht"),
            keywords: &[
                "angst",
                "angstig",
                "angstig schreeuwend gezicht",
                "bang",
                "gezicht",
                "munch",
                "schreeuw",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("livredd"),
            keywords: &[
                "fjes", "frykt", "livredd", "munch", "redd", "skremt", "skrik",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭୟରେ ଚ\u{b3f}ତ\u{b4d}କ\u{b3e}ର କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଚ\u{b3f}ତ\u{b4d}କ\u{b3e}ର କର\u{b3f}ବ\u{b3e}",
                "ଚୋବ\u{b3e}ଇବ\u{b3e}",
                "ଡର\u{b3f}ବ\u{b3e}",
                "ଭୟଭୀତ",
                "ଭୟରେ ଚ\u{b3f}ତ\u{b4d}କ\u{b3e}ର କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਡਰ ਨਾਲ ਚੀਕਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਚੀਕ",
                "ਡਰ",
                "ਡਰ ਨਾਲ ਚੀਕ ਰਿਹਾ ਚਿਹਰਾ",
                "ਡਰ ਨਾਲ ਚੀਕਣਾ",
                "ਡਰ ਨਾਲ ਚੀਕਦਾ ਚਿਹਰਾ",
                "ਡਰਿਆ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خوف وچ چیخدی شکل"),
            keywords: &[
                "خوف",
                "خوف وچ چیخدی شکل",
                "خوفزدہ",
                "دی شکل",
                "واج نال چبنا",
                "چیکنا",
                "ڈریا ہوئیا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Fia Mék Am Shaút Laúd Laud"),
            keywords: &[
                "Fes",
                "Fes Wé Fia Mék Am Shaút Laúd Laud",
                "Fia",
                "Shaút Laúd Laud",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz krzycząca ze strachu"),
            keywords: &["krzycząca buźka", "twarz krzycząca ze strachu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په ډار کې ژړېدونکی مخ"),
            keywords: &["غې مخ", "په ډار کې ژړېدونکی مخ", "چ", "ډار", "ډارېدلې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto gritando de medo"),
            keywords: &[
                "assustado",
                "gritando de medo",
                "medo",
                "rosto",
                "rosto gritando de medo",
                "temeroso",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a gritar de medo"),
            keywords: &[
                "amedrontado",
                "assustado",
                "cara",
                "cara a gritar de medo",
                "grito",
                "medo",
                "munch",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uya qaparisqa manchanawan"),
            keywords: &[
                "khastuy",
                "manay",
                "manchasqa",
                "qhapariy",
                "uya",
                "uya qaparisqa manchanawan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față țipând de frică"),
            keywords: &["disperare", "față", "față țipând de frică", "țipăt"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-885"),
            keywords: &["E10-885"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в ужасе"),
            keywords: &["в ужасе", "испуг", "крик", "страх", "ужас"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura isakuza kubera ubwoba"),
            keywords: &[
                "giteye ubwoba",
                "guhekenya",
                "gutabaza",
                "isura",
                "isura isakuza kubera ubwoba",
                "ubwoba",
                "yakanzwe",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڊپ ۾ رڙيون ڪندڙ چهرو"),
            keywords: &[
                "خوف",
                "خوفناڪ",
                "رڙيون ڪرڻ",
                "چهرو",
                "چٻاڙڻ",
                "ڊنل",
                "ڊپ ۾ رڙيون ڪندڙ چهرو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}යෙන\u{dca} කෑගසන ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "බ\u{dd2}ය",
                "බ\u{dd2}යජනක",
                "බ\u{dd2}යෙන\u{dca} කෑගසන",
                "බ\u{dd2}යෙන\u{dca} කෑගසන ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár kričiaca od strachu"),
            keywords: &[
                "strach",
                "tvár",
                "tvár kričiaca od strachu",
                "vydesená",
                "vystrašená",
                "výkrik",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz, ki kriči od strahu"),
            keywords: &[
                "krik",
                "munch",
                "obraz",
                "obraz, ki kriči od strahu",
                "preplašeno",
                "prestrašeno",
                "strah",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji cabsi darteed u qeylinaayo"),
            keywords: &[
                "cabsaday",
                "cabsi",
                "foorid",
                "qeeylo",
                "waji",
                "waji cabsi darteed u qeylinaayo",
                "waji cabsi la qeylinaayo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë duke ulëritur nga frika"),
            keywords: &[
                "fytyrë duke ulëritur nga frika",
                "i frikshëm",
                "i frikësuar",
                "mbllaçit",
                "ulërimë",
                "ytyrë duke ulëritur nga frika",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице које вришти од страха"),
            keywords: &[
                "крик",
                "лице",
                "лице које вришти од страха",
                "мунк",
                "стрaх",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице које вришти од страха"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice koje vrišti od straha"),
            keywords: &[
                "krik",
                "lice",
                "lice koje vrišti od straha",
                "munk",
                "strah",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice koje vrišti od straha"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ansikte som skriker av fasa"),
            keywords: &["ansikte som skriker av fasa", "livrädd", "rädd", "skriker"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaopiga mayowe ya hofu"),
            keywords: &[
                "kuhofu",
                "kula",
                "kuogopa",
                "mayowe",
                "uso",
                "uso unaopiga mayowe ya hofu",
                "woga",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பயத\u{bcd}தில\u{bcd} அலறும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "அய\u{bcd}யய\u{bcd}யோ!",
                "பயத\u{bcd}தில\u{bcd} அலறுதல\u{bcd}",
                "பயத\u{bcd}தில\u{bcd} அலறும\u{bcd} முகம\u{bcd}",
                "பயம\u{bbe}க இருக\u{bcd}கிறது",
                "பயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("భయంత\u{c4b} అరుస\u{c4d}తున\u{c4d}న ముఖం"),
            keywords: &["భయం", "భయంత\u{c4b} అరుస\u{c4d}తున\u{c4d}న ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи аз тарс дод задаистода"),
            keywords: &[
                "дод задан",
                "рӯи аз тарс дод задаистода",
                "рӯй",
                "тарс",
                "тарсон",
                "чалп-чалп хӯрдан",
                "ҳаросида",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กล\u{e31}วกร\u{e35}ดร\u{e49}อง"),
            keywords: &["กล\u{e31}ว", "กล\u{e31}วกร\u{e35}ดร\u{e49}อง", "หน\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gorkup çygyrýan ýüz"),
            keywords: &[
                "gorkan",
                "gorkup çygyrýan ýüz",
                "gorky",
                "çeýnemek",
                "çygyrmak",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata ʻoku kekekeke he manavahē"),
            keywords: &["mata ʻoku kekekeke he manavahē"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("korkuyla çığlık atan yüz"),
            keywords: &[
                "korkmuş",
                "korku",
                "korku içinde bağıran yüz",
                "korkunç",
                "korkuyla haykıran yüz",
                "korkuyla çığlık atan yüz",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قورقۇنچلۇق چىرقىرىغان چىراي"),
            keywords: &[
                "قارغىش",
                "قورققان",
                "قورقۇنچ",
                "قورقۇنچلۇق چىرقىرىغان چىراي",
                "چىراي",
                "چىرقىراش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що кричить із переляку"),
            keywords: &[
                "боязкий",
                "крик",
                "наляканий",
                "обличчя",
                "обличчя, що кричить із переляку",
                "страх",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خوف سے چلاتا چہرہ"),
            keywords: &["خوف", "خوف سے چلاتا چہرہ", "چہرہ", "چیخ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘rquvdan qichqirayotgan yuz"),
            keywords: &[
                "baqiriq",
                "chaynash",
                "qo‘rqinchli",
                "qo‘rqish",
                "qo‘rquv",
                "qo‘rquvdan qichqirayotgan yuz",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt la hét kinh hãi"),
            keywords: &[
                "kinh sợ",
                "la hét",
                "mặt",
                "mặt la hét kinh hãi",
                "sợ",
                "sợ hãi",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy jooy te tiit"),
            keywords: &[
                "kanam",
                "kanam guy jooy te tiit",
                "ragal",
                "tiit",
                "yuuxu",
                "yëy",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obutswinayo luloyiko"),
            keywords: &[
                "fukutha",
                "tswina",
                "ubuso",
                "ubuso obutswinayo luloyiko",
                "ukoyika",
                "ukoyikeka",
                "uloyiko",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Fifi Ẹru han an"),
            keywords: &[
                "Oju Fifi Ẹru han an",
                "bẹ\u{300}rù",
                "han",
                "jẹ",
                "ojú",
                "ìbẹ\u{300}rù",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("驚到尖叫嘅臉"),
            keywords: &["口震", "害怕", "懼怕", "臉", "驚到尖叫嘅臉", "驚叫", "驚恐"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("惊到尖叫嘅脸"),
            keywords: &["口震", "害怕", "惊到尖叫嘅脸", "惊叫", "惊恐", "惧怕", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("吓死了"),
            keywords: &["吓死", "吓死了", "害怕", "尖叫", "恐怖", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("嚇死了"),
            keywords: &["嚇死了", "恐怖"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obumemeza ngokwesaba"),
            keywords: &[
                "ubuso",
                "ubuso obumemeza ngokwesaba",
                "ukumemeza",
                "ukwesaba",
                "ukwethuka",
            ],
        },
    ],
};
#[doc = "😖"]
pub const CONFOUNDED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😖",
    codepoint: "1F616",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "confounded face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oorblufte gesig"),
            keywords: &["gesig", "oorbluf", "oorblufte gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እንባው የመጣ ከንፈሩ የሚንቀጠቀጥ ፊት"),
            keywords: &["እንባው የመጣ", "እንባው የመጣ ከንፈሩ የሚንቀጠቀጥ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه مرتبك"),
            keywords: &["تائه", "وجه مرتبك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হতভম\u{9cd}ব ম\u{9c1}খ"),
            keywords: &["ম\u{9c1}খ", "হতভম\u{9cd}ব"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("utanan üz"),
            keywords: &["utanan", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("безвыходнасць"),
            keywords: &["безвыходнасць", "бязвыхадны", "гамон", "тупік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Смутено лице"),
            keywords: &["Смутено лице", "лице", "смутен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিস\u{9cd}মিত ম\u{9c1}খ"),
            keywords: &[
                "বিস\u{9cd}মিত ম\u{9c1}খ",
                "ম\u{9c1}খ",
                "হকচকিয\u{9bc}ে য\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("potpuna rezigniranost"),
            keywords: &["lice", "potpuna rezigniranost", "rezigniranost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de frustració"),
            keywords: &[
                "cara",
                "cara de frustració",
                "frustració",
                "frustrada",
                "frustrat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎭᎾᎸ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎭᎾᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s pláčem na krajíčku"),
            keywords: &[
                "naštvaný",
                "obličej s pláčem na krajíčku",
                "překvapený",
                "rozpačitý",
                "smajlík",
                "tvář",
                "výraz",
                "zatraceně",
                "zmatený",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb dryslyd"),
            keywords: &["dryslyd", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("forbistret ansigt"),
            keywords: &["ansigt", "forbandet", "forbistret ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("verwirrtes Gesicht"),
            keywords: &["Gesicht", "verwirrt", "verwirrtes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σάστισμα"),
            keywords: &["πρόσωπο", "σάστισμα", "σαστισμένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("confounded face"),
            keywords: &["confounded", "face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de frustración"),
            keywords: &["cara", "cara de frustración", "frustrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "cara de frustración",
                "enojo",
                "frustración",
                "tristeza",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kimbatuses nägu"),
            keywords: &["kimbatus", "kimbatuses nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hutsegite-aurpegia"),
            keywords: &["aurpegi", "hutsegite", "hutsegite-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سردرگم"),
            keywords: &["به\u{200c}هم\u{200c}ریخته", "سردرگم", "صورت", "گیج"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tyrmistynyt"),
            keywords: &["hämmentynyt", "naama", "pöyristynyt", "tyrmistynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("natataranta"),
            keywords: &["mukha", "natataranta", "taranta"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sera illbrýnt andlit"),
            keywords: &[
                "andlit",
                "harmur",
                "illbrýnt",
                "illfýsið",
                "keddur",
                "sera illbrýnt andlit",
                "sorgarbundin",
                "óglaður",
                "ólukkulig",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage déconcerté"),
            keywords: &["déconcerté", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog le mearbhall uirthi"),
            keywords: &["mearbhall", "straoiseog le mearbhall uirthi"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann am breislich"),
            keywords: &["aodann", "aodann am breislich", "breisleach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de frustración"),
            keywords: &["cara de frustración", "frustración"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આક\u{ac1}ળવ\u{acd}યાક\u{ac1}ળ ચહ\u{ac7}રો"),
            keywords: &["આક\u{ac1}ળવ\u{acd}યાક\u{ac1}ળ", "ચહ\u{ac7}રો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai rikitarwa"),
            keywords: &["fuska", "fuska mai rikitarwa", "rikitarwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מתוסכל"),
            keywords: &["מתוסכל", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{948}रान च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "भौ\u{902}चक", "ह\u{948}रान च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("smeteno lice"),
            keywords: &["lice", "smeteno lice", "smetenost", "zbunjenost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("összezavarodott arc"),
            keywords: &["arc", "összezavarodott"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ցնցված դեմք"),
            keywords: &["դեմք", "ցնցված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah stres"),
            keywords: &["gelisah", "muka", "pusing", "wajah", "wajah stres"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere mgbagwoju anya"),
            keywords: &["ihu", "ihu nwere mgbagwoju anya", "nwere mgbagwoju anya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("forviða andlit"),
            keywords: &["andlit", "forviða"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina frustrata"),
            keywords: &["faccina", "frustrata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("困惑した顔"),
            keywords: &["困惑", "困惑した顔", "混乱", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai prasa bingung ora karuan"),
            keywords: &["bingung", "rai", "rai prasa bingung ora karuan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეცბუნებული სახე"),
            keywords: &["სახე", "შეცბუნებული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("есі шығу"),
            keywords: &["бет", "есі шығу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("forbistret ansigt"),
            keywords: &["ansigt", "forbandet", "forbistret ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខឡប\u{17cb}ៗ"),
            keywords: &[
                "ញ\u{17c9}ស\u{17cb}",
                "ម\u{17bb}ខឡប\u{17cb}",
                "ម\u{17bb}ខឡប\u{17cb}ៗ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗೊಂದಲಮಯ ಮುಖ"),
            keywords: &["ಗೊಂದಲಮಯ", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("당혹한 얼굴"),
            keywords: &["당혹한 얼굴", "당혹함", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("गडबडिल\u{94d}लो च\u{947}रो"),
            keywords: &["गडबडिल\u{94d}लो", "च\u{947}रो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("апкаарыган бет"),
            keywords: &["апкаарыган", "бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("frustréiert"),
            keywords: &["Gesiicht", "frustréiert"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າງ\u{ebb}ງ"),
            keywords: &["ງ\u{ebb}ງ", "ໜ\u{ec9}າ", "ໜ\u{ec9}າງ\u{ebb}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("suglumintas veidas"),
            keywords: &["suglumintas veidas", "suglumęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("apmulsusi seja"),
            keywords: &["apmulsis", "apmulsums", "apmulsusi seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi whakahēhē"),
            keywords: &["kanohi", "whakahēhē"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("збркано лице"),
            keywords: &["збркано", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d4d}ല\u{d3e}നമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "അങ\u{d4d}കല\u{d3e}പ\u{d4d}പില\u{d3e}യ",
                "മ\u{d41}ഖം",
                "മ\u{d4d}ല\u{d3e}നമ\u{d3e}യ മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("будилсан царай"),
            keywords: &["будилсан", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{942}प गो\u{902}धळल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "ख\u{942}प गो\u{902}धळल\u{947}ला च\u{947}हरा",
                "गो\u{902}धळल\u{947}ला",
                "च\u{947}हरा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka bingung"),
            keywords: &["bingung", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ imħawwad"),
            keywords: &["imħawwad", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မ\u{103d}\u{103e}န\u{103a}ထ\u{1030}သ\u{103d}ားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "မ\u{103d}\u{103e}န\u{103a}ထ\u{1030}",
                "မ\u{103d}\u{103e}န\u{103a}ထ\u{1030}သ\u{103d}ားသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fortvilet"),
            keywords: &["fjes", "fortvilet", "sint", "skuffet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("द\u{941}विधाय\u{941}क\u{94d}त अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "चकित",
                "द\u{941}विधाय\u{941}क\u{94d}त अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("onthutst gezicht"),
            keywords: &["gezicht", "onthutst"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fortvila"),
            keywords: &["fjes", "fortvila", "sint", "skuffa"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ରକ\u{b4d}ତ\u{b3f}ସ\u{b42}ଚକ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ବ\u{b3f}ରକ\u{b4d}ତ\u{b3f}ସ\u{b42}ଚକ", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a48}ਰਾਨ ਅਤ\u{a47} ਉਲਝਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਸ\u{a3c}ਰਮਸਾਰ",
                "ਹ\u{a48}ਰਾਨ ਅਤ\u{a47} ਉਲਝਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہک\u{651}ی بک\u{651}ی شکل"),
            keywords: &[
                "دی شکل",
                "ہک\u{651}ا بک\u{651}ا",
                "ہک\u{651}ی بک\u{651}ی شکل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Nọ\u{301} Sabí Wétín I Go Du"),
            keywords: &[
                "Fes",
                "Fes Wé Klóz Ai",
                "Fes Wé Nọ\u{301} Sabí Wétín I Go Du",
                "Kọnfiuz",
                "Zíg Zág Maút Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zakłopotana twarz"),
            keywords: &["zakłopotana twarz", "zirytowana buźka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګډوډ مخ"),
            keywords: &["مخ", "ګډوډ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto perplexo"),
            keywords: &["perplexo", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara perplexa"),
            keywords: &["baralhado", "cara", "cara perplexa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pantasqa uya"),
            keywords: &["pantasqa uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față derutată"),
            keywords: &["derută", "față", "față derutată", "zăpăceală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-858"),
            keywords: &["E10-858"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в растерянности"),
            keywords: &[
                "в растерянности",
                "лицо",
                "растерянность",
                "сбит",
                "сбит с толку",
                "толк",
                "тупик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kwitiranya"),
            keywords: &[
                "isura igaragaza",
                "isura igaragaza kwitiranya",
                "kwitiranya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شرمنده چهرو"),
            keywords: &["شرمنده چهرو", "شرمنده، چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අව\u{dd4}ල\u{dca} සහගත ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "අව\u{dd4}ල\u{dca} සහගත",
                "අව\u{dd4}ල\u{dca} සහගත ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tvár v rozpakoch"),
            keywords: &["popletená", "tvár", "tvár v rozpakoch"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zbegan obraz"),
            keywords: &["obraz", "zbegan obraz", "zbegano"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji shakisan"),
            keywords: &["aad u baqday", "waji", "waji shakisan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e turbulluar"),
            keywords: &["e turbulluar", "fytyrë", "fytyrë e turbulluar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице у недоумици"),
            keywords: &["збуњeнoст", "лице", "лице у недоумици", "смeтeнoст"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице у недоумици"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice u nedoumici"),
            keywords: &["lice", "lice u nedoumici", "smetenost", "zbunjenost"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice u nedoumici"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("förvirrat ansikte"),
            keywords: &["förvirrad", "förvirrat ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso ulioshangazwa"),
            keywords: &["kushangazwa", "uso", "uso ulioshangazwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குழம\u{bcd}பித\u{bcd} தவிக\u{bcd}கும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "கலக\u{bcd}கம\u{bcd}",
                "கலங\u{bcd}கிய முகம\u{bcd}",
                "குழப\u{bcd}பம\u{bcd}",
                "குழம\u{bcd}பித\u{bcd} தவிக\u{bcd}கும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అయ\u{c4b}మయంగ\u{c3e} ఉన\u{c4d}న ముఖం"),
            keywords: &[
                "అయ\u{c4b}మయం",
                "అయ\u{c4b}మయంగ\u{c3e} ఉన\u{c4d}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хиҷил"),
            keywords: &["рӯи хиҷил", "рӯй", "хиҷил"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}ารำคาญ"),
            keywords: &["รำคาญ", "หน\u{e49}า", "หน\u{e49}ารำคาญ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ugruny ýitiren ýüz"),
            keywords: &["ugruny ýitiren", "ugruny ýitiren ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fakapuputuʻu"),
            keywords: &["mata fakapuputuʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kafası çok karışık yüz"),
            keywords: &["kafası çok karışmış", "kafası çok karışık yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بىزار چىراي"),
            keywords: &["بىزار", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("збентежене обличчя"),
            keywords: &["збентежене обличчя", "збентежений", "обличчя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بے ترتیب چہرہ"),
            keywords: &["انتہائی کنفیوز", "بے ترتیب چہرہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xijolatli yuz"),
            keywords: &["xijolat", "xijolatli yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt xấu hổ"),
            keywords: &["mặt", "mặt xấu hổ", "xấu hổ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu jaawale"),
            keywords: &["jaawale", "kanam", "kanam gu jaawale"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obubhidekileyo"),
            keywords: &["obubhidekileyo", "ubuso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Itiju"),
            keywords: &["Oju Itiju", "itiju", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("困惑嘅臉"),
            keywords: &["困惑", "困惑嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("困惑嘅脸"),
            keywords: &["困惑", "困惑嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("困惑"),
            keywords: &["困惑", "焦头烂额", "纠结", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("困惑"),
            keywords: &["困惑", "焦頭爛額"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("困惑"),
            keywords: &["困惑", "焦頭爛額"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunokudideka"),
            keywords: &["ubuso", "ubuso obunokudideka", "ukudideka"],
        },
    ],
};
#[doc = "😣"]
pub const PERSEVERING_FACE: crate::Emoji = crate::Emoji {
    glyph: "😣",
    codepoint: "1F623",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "persevering face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig wat vasbyt"),
            keywords: &["deurdruk", "gesig", "gesig wat vasbyt", "vasbyt"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጽናትን አንጸባራቂ ፊት"),
            keywords: &["ጽናት", "ጽናትን አንጸባራቂ ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه جاد"),
            keywords: &["جدية", "وجه", "وجه جاد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কঠোৰ পৰিশ\u{9cd}ৰমী ম\u{9c1}খ"),
            keywords: &["উদ\u{9cd}যম", "কঠোৰ পৰিশ\u{9cd}ৰমী ম\u{9c1}খ", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("inadkar üz"),
            keywords: &["inadkar", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("упарты твар"),
            keywords: &["настойваць", "упартасць", "упарты твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Упорито лице"),
            keywords: &["Упорито лице", "лице", "упорит"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জেদি ম\u{9c1}খ"),
            keywords: &["জিদ কর\u{9be}", "জেদি ম\u{9c1}খ", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ustrajni pogled"),
            keywords: &["lice", "ustrajni pogled", "ustrajnost"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de perseverança"),
            keywords: &["cara", "cara de perseverança", "perseverança"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᎾᏛᏁᎰᎢ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᎤᎵᏏᏅᏗ", "ᏥᎾᏛᏁᎰᎢ ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej s umíněným výrazem"),
            keywords: &[
                "obličej s umíněným výrazem",
                "smajlík",
                "tvář",
                "umíněnost",
                "vytrvalost",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb dyfal"),
            keywords: &["dyfal", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("stædigt ansigt"),
            keywords: &["stædigt ansigt", "udholdenhed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("entschlossenes Gesicht"),
            keywords: &["Gesicht", "durchhalten", "entschlossenes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βλέμμα απόγνωσης"),
            keywords: &["βλέμμα απόγνωσης", "επιμένω", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("persevering face"),
            keywords: &["face", "persevere", "persevering face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara desesperada"),
            keywords: &["cara", "cara desesperada", "desesperación", "frustración"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara perseverante"),
            keywords: &[
                "cara",
                "cara perseverante",
                "equivocado",
                "me equivoqué",
                "perdón",
                "perseverar",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara perseverante"),
            keywords: &["cara perseverante"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara perseverante"),
            keywords: &["cara perseverante"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sihikindel nägu"),
            keywords: &["kannatamine", "nägu", "sihikindel nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurpegi nekaezina"),
            keywords: &[
                "aurpegi",
                "aurpegi nekaezina",
                "nekaezin",
                "pertseberantzia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پافشاری"),
            keywords: &["اصرار", "سماجت", "صورت", "پافشاری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kärsivä"),
            keywords: &[
                "hellittämätön",
                "kärsivä",
                "naama",
                "peräänantamaton",
                "sisukas",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagsisikap"),
            keywords: &["mukha", "nagsisikap", "nagtitiyaga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ágrýti andlit"),
            keywords: &["andlit", "ágrýti andlit", "ágrýtin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage persévérant"),
            keywords: &["persévérant", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog bhuanseasmhachta"),
            keywords: &[
                "buanseasmhach",
                "leanaim orm",
                "straoiseog bhuanseasmhachta",
                "straoiseog dhíocasach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann rag"),
            keywords: &["aodann", "rag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de estragalo todo"),
            keywords: &["cara", "cara de estragalo todo", "estragar", "perseverante"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જબરદસ\u{acd}ત ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "જબરદસ\u{acd}ત ચહ\u{ac7}રો",
                "સખત ચહ\u{ac7}રો",
                "સ\u{acd}થાયી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai nacewa"),
            keywords: &["fuska", "fuska mai nacewa", "nacewa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף סובל"),
            keywords: &["כאב", "סובל", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हठी च\u{947}हरा"),
            keywords: &[
                "चा\u{902}टा मारो",
                "च\u{947}हरा",
                "म\u{948}\u{902}न\u{947} चा\u{902}टा मारा च\u{947}हरा",
                "हठ",
                "हठी च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("odlučno lice"),
            keywords: &["lice", "odlučno lice", "ustrajanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("állhatatos arc"),
            keywords: &["arc", "állhatatos arc", "állhatatosság"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("համառող դեմք"),
            keywords: &["դեմք", "համառ", "համառող դեմք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah tidak setuju"),
            keywords: &["muka", "ngotot", "wajah", "wajah tidak setuju"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu na-enwe ntachi obi"),
            keywords: &["ihu", "ihu na-enwe ntachi obi", "ntachi obi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("klúður"),
            keywords: &["andlit", "erfiðleikar", "klúður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina perseverante"),
            keywords: &["faccina", "perseverante"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("我慢"),
            keywords: &["我慢", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai prasa wis ora kuat maneh"),
            keywords: &["ora kuat", "rai", "rai prasa wis ora kuat maneh"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეუპოვარი სახე"),
            keywords: &["სახე", "შეუპოვარი სახე", "შეუპოვრობა"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem akayay"),
            keywords: &["udem akayay"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шыдамдылық"),
            keywords: &["бет", "шыдамдылық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("stædigt ansigt"),
            keywords: &["stædigt ansigt", "udholdenhed"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ធ\u{17d2}វើម\u{17bb}ខជ\u{17d2}រ\u{17bd}ញ"),
            keywords: &[
                "ជ\u{17d2}រ\u{17bd}ញ",
                "ធ\u{17d2}វើម\u{17bb}ខជ\u{17d2}រ\u{17bd}ញ",
                "ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸತತ ಪ\u{ccd}ರಯತ\u{ccd}ನದ ಮುಖ"),
            keywords: &[
                "ಮುಖ",
                "ಸತತ ಪ\u{ccd}ರಯತ\u{ccd}ನ",
                "ಸತತ ಪ\u{ccd}ರಯತ\u{ccd}ನದ ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("참아내는 얼굴"),
            keywords: &["실수한 후 얼굴", "얼굴", "얼빠짐", "참아내는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ख\u{902}बीर च\u{947}रो"),
            keywords: &["ख\u{902}बीर", "च\u{947}रो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өжөрлөнгөн бет"),
            keywords: &["бет", "өжөр", "өжөрлөнгөн бет"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("duerhalend"),
            keywords: &["Gesiicht", "duerhalen", "duerhalend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າອ\u{ebb}ດທ\u{ebb}ນ"),
            keywords: &[
                "ອ\u{ebb}ດທ\u{ebb}ນ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າອ\u{ebb}ດທ\u{ebb}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atkaklus veidas"),
            keywords: &["atkaklus", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piepūlēta seja"),
            keywords: &[
                "neatlaidīgs",
                "pacietīgs",
                "piepūle",
                "piepūlēta seja",
                "seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi pāuaua"),
            keywords: &["kanohi", "pāuaua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("издржливо лице"),
            keywords: &["издржливо лице", "издржливост", "истрајност", "лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കഠിന\u{d3e}ദ\u{d4d}ധ\u{d4d}വ\u{d3e}നം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
            ),
            keywords: &[
                "അസഹനീയമ\u{d3e}യ",
                "കഠിന\u{d3e}ദ\u{d4d}ധ\u{d4d}വ\u{d3e}നം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "നിസ\u{d4d}സഹ\u{d3e}യമ\u{d3e}യ",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цөхрөлтгүй царай"),
            keywords: &["царай", "цөхрөлтгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थप\u{94d}पड मारल\u{947}ला च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "थप\u{94d}पड मारल\u{947}ला च\u{947}हरा",
                "हट\u{94d}टी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tekun"),
            keywords: &["muka", "tekun"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ perseveranti"),
            keywords: &["perseveranti", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အက\u{1030}အည\u{102e}မ\u{1032}\u{1037}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "အက\u{1030}အည\u{102e}မ\u{1032}\u{1037}",
                "အက\u{1030}အည\u{102e}မ\u{1032}\u{1037}သည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bommert"),
            keywords: &["bommert", "fjes", "skuffet", "utholdende"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("द\u{943}ढ अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "द\u{943}ढ अन\u{941}हार", "द\u{943}ध"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("volhardend gezicht"),
            keywords: &["gezicht", "volhardend"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bommert"),
            keywords: &["bommert", "fjes", "skuffa", "uthaldande"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b43}ଢ\u{b3c} ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଦ\u{b43}ଢ\u{b3c} ମ\u{b41}ହ\u{b01}",
                "ମ\u{b41}ହ\u{b01}",
                "ଶକ\u{b4d}ତ କର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}ਰ\u{a71}ਖਿਆ ਵਿਖਾਉਣ ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਉਡਾ ਦਿਓ",
                "ਚਿਹਰਾ",
                "ਮ\u{a48}\u{a02} ਉਡਾ ਦਿ\u{a71}ਤਾ ਚਿਹਰਾ",
                "ਸ\u{a41}ਰ\u{a71}ਖਿਅਤ",
                "ਸ\u{a41}ਰ\u{a71}ਖਿਅਾ ਚਿਹਰਾ",
                "ਸ\u{a41}ਰ\u{a71}ਖਿਆ ਵਿਖਾਉਣ ਵਾਲਾ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ثابت قدم شکل"),
            keywords: &["ثابت قدم رہنا", "ثابت قدم شکل", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Nọ\u{301} De Táya"),
            keywords: &[
                "Fes",
                "Fes Wé Nọ\u{301} De Táya",
                "Kọntíniú To De Trai Dú Sọ\u{301}mtin",
                "Nọ\u{301} De Táyá To De Trai Dú Sọ\u{301}mtin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uparta twarz"),
            keywords: &["napięcie", "uparta twarz", "zacięta twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سخت سری مخ"),
            keywords: &["سخت سری", "سخت سری مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto perseverante"),
            keywords: &["perseverante", "perseverança", "rosto perseverante"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara perseverante"),
            keywords: &["cara", "perseverante"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yanapakusqa uya"),
            keywords: &["uya", "yanapakusqa uya", "yanapakuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față neajutorată"),
            keywords: &["față", "față neajutorată", "neajutorare", "neputință"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-871"),
            keywords: &["E10-871"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("упорство"),
            keywords: &[
                "зажмурился",
                "лицо",
                "настойчивость",
                "проявляет настойчивость",
                "смайлик",
                "упорство",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza kutava ku izima"),
            keywords: &["gutsimbarara", "isura", "isura igaragaza kutava ku izima"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چهرو"),
            keywords: &["ثابت قدم", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උත\u{dca}ස\u{dcf}හවන\u{dca}ත ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "උත\u{dca}ස\u{dcf}හය",
                "උත\u{dca}ස\u{dcf}හවන\u{dca}ත ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("urputná tvár"),
            keywords: &["tvár", "urputná tvár", "vydržať", "vytrvať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vztrajen obraz"),
            keywords: &["obraz", "vztrajanje", "vztrajen obraz"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji dulqaad leh"),
            keywords: &["dulqaad", "waji", "waji dulqaad leh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë këmbëngulëse"),
            keywords: &["fytyrë", "këmbëngulëse"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("измучено лице"),
            keywords: &["измучено лице", "лице", "мука", "подношење"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["измучено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("izmučeno lice"),
            keywords: &["izmučeno lice", "lice", "muka", "podnošenje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["izmučeno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uthålligt ansikte"),
            keywords: &["besviken", "misslyckades", "står ut", "uthålligt ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaovumilia"),
            keywords: &["kuvumilia", "uso", "uso unaovumilia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "உதவியில\u{bcd}ல\u{bbe}மல\u{bcd} இருப\u{bcd}பதை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "உதவியில\u{bcd}ல\u{bbe}மல\u{bcd} இருப\u{bcd}பதை வெளிப\u{bcd}படுத\u{bcd}தும\u{bcd} முகம\u{bcd}",
                "உறுதி",
                "ச\u{bbe}திக\u{bcd}கும\u{bcd} ஆற\u{bcd}றல\u{bcd}",
                "விட\u{bbe} முயற\u{bcd}சி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అసహ\u{c3e}యత ముఖం"),
            keywords: &["అసహ\u{c3e}యత", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи истодагарикунанда"),
            keywords: &["истодагарӣ кардан", "рӯи истодагарикунанда", "рӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อดทน"),
            keywords: &["หน\u{e49}า", "อดทน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çynyny edýän ýüz"),
            keywords: &["çynlakaý", "çynyny edýän ýüz", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lotokītaki"),
            keywords: &["mata lotokītaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kararlı yüz"),
            keywords: &["dayanıklı", "kararlı yüz", "yüz", "zorlanan yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەسكىن چىراي"),
            keywords: &["كەسكىن", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("невідступне обличчя"),
            keywords: &["завзяте обличчя", "невідступне обличчя", "обличчя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پ\u{64f}رعزم چہرہ"),
            keywords: &["پ\u{64f}رعزم چہرہ", "پ\u{64f}رعظم", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘jarlik"),
            keywords: &["o‘jar", "o‘jarlik", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt kiên nhẫn"),
            keywords: &["kiên nhẫn", "mặt", "mặt kiên nhẫn"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam guy ñafe"),
            keywords: &["kanam", "kanam guy ñafe", "ñafe"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso bokunyamezela"),
            keywords: &["nyamezela", "ubuso", "ubuso bokunyamezela"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ifarada"),
            keywords: &["Oju Ifarada", "ojú", "ìfaradà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("堅忍不拔嘅臉"),
            keywords: &["堅忍不拔", "堅忍不拔嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("坚忍不拔嘅脸"),
            keywords: &["坚忍不拔", "坚忍不拔嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("痛苦"),
            keywords: &["忍耐", "痛苦", "脸", "难受"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("痛苦"),
            keywords: &["忍痛中", "痛苦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("疲倦嘅表情"),
            keywords: &["疲倦嘅表情", "痛苦"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obubi"),
            keywords: &["bipha", "ubuso", "ubuso obubi"],
        },
    ],
};
#[doc = "😞"]
pub const DISAPPOINTED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😞",
    codepoint: "1F61E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "disappointed face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("teleurgestelde gesig"),
            keywords: &["gesig", "teleurgesteld", "teleurgestelde gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተከፋ ፊት"),
            keywords: &["የተከፋ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه محبط"),
            keywords: &["محبط", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হত\u{9be}শ ম\u{9c1}খ"),
            keywords: &["ম\u{9c1}খ", "হত\u{9be}শ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("məyus üz"),
            keywords: &["məyus", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("расчараваны твар"),
            keywords: &["засмучэнне", "расчараванне", "расчараваны твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Разочаровано лице"),
            keywords: &["Разочаровано лице", "лице", "разочарован"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হত\u{9be}শ ম\u{9c1}খ"),
            keywords: &["ম\u{9c1}খ", "হত\u{9be}শ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("razočaranost"),
            keywords: &["lice", "razočaranost", "razočarenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de decepció"),
            keywords: &[
                "cara",
                "cara de decepció",
                "decebuda",
                "decebut",
                "decepció",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎡᏍᎦ ᎤᏰᎸᏅᎢ ᎤᎧᏛ"),
            keywords: &["ᎡᏍᎦ ᎤᏰᎸᏅᎢ", "ᎡᏍᎦ ᎤᏰᎸᏅᎢ ᎤᎧᏛ", "ᎤᎧᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zklamaný obličej"),
            keywords: &["smajlík", "tvář", "výraz", "zklamaný obličej", "zklamání"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb siomedig"),
            keywords: &["siomedig", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skuffet ansigt"),
            keywords: &["ansigt", "skuffet ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("enttäuschtes Gesicht"),
            keywords: &["Gesicht", "enttäuschtes Gesicht", "traurig"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("απογοήτευση"),
            keywords: &["απογοήτευση", "απογοητευμένος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("disappointed face"),
            keywords: &["disappointed", "face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara decepcionada"),
            keywords: &["cara", "cara decepcionada", "decepcionado", "decepción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de decepción"),
            keywords: &["cara", "cara de decepción", "decepcionado", "decepción"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara decepcionada"),
            keywords: &["cara", "cara decepcionada", "decepcionado", "decepción"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara decepcionada"),
            keywords: &["cara", "cara decepcionada", "decepcionado", "decepción"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pettunud nägu"),
            keywords: &["kergendus", "leevendus", "nägu", "pettunud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("etsipen-aurpegia"),
            keywords: &["aurpegi", "etsipen", "etsipen-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ناامید"),
            keywords: &["صورت", "غمگین", "ناامید", "ناراحت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pettynyt"),
            keywords: &["naama", "pettymys", "pettynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dismayado"),
            keywords: &["dismayado", "mukha", "nabigo", "nalulumbay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skuffa andlit"),
            keywords: &[
                "andlit",
                "harmur",
                "illbrýnt",
                "illfýsið",
                "keddur",
                "skuffa andlit",
                "sorgarbundin",
                "óglaður",
                "ólukkulig",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage déçu"),
            keywords: &["déçu", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog dhíomách"),
            keywords: &["díomá", "straoiseog dhíomách"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a fhuair briseadh-dùil"),
            keywords: &["aodann", "aodann a fhuair briseadh-dùil", "briseadh-dùil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de decepción"),
            keywords: &[
                "cara",
                "cara de decepción",
                "decepcionado",
                "decepción",
                "desilusión",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નિરાશ ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "નિરાશ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai ɓacin rai"),
            keywords: &["fuska", "fuska mai ɓacin rai", "ɓacin rai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מאוכזב"),
            keywords: &["מאוכזב", "עצוב", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("निराश च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "निराश", "निराशा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("razočarano lice"),
            keywords: &["lice", "razočaranje", "razočarano lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csalódott arc"),
            keywords: &["arc", "csalódott"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հիասթափված դեմք"),
            keywords: &["դեմք", "հիասթափված"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah kecewa"),
            keywords: &["kecewa", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere ngharịpụ"),
            keywords: &["ihu", "ihu nwere ngharịpụ", "nwere ngharịpụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vonbrigði"),
            keywords: &["andlit", "vonbrigðaandlit", "vonbrigði"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina delusa"),
            keywords: &["delusa", "delusione", "faccina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("失望した顔"),
            keywords: &["がっかり", "がっくり", "失望した顔", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kuciwa"),
            keywords: &["kuciwa", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იმედგაცრუებული სახე"),
            keywords: &["იმედგაცრუებული", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түңілу"),
            keywords: &["бет", "түңілген", "түңілу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skuffet ansigt"),
            keywords: &["ansigt", "skuffet ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខខកច\u{17b7}ត\u{17d2}ត"),
            keywords: &[
                "ក\u{17d2}រៀមក\u{17d2}រ\u{17c6}",
                "ខកច\u{17b7}ត\u{17d2}ត",
                "ពេប",
                "ម\u{17bb}ខខកច\u{17b7}ត\u{17d2}ត",
                "ស\u{17d2}រពោន",
                "អន\u{17cb}ច\u{17b7}ត\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ರಾಸ\u{cc6} ಮುಖ"),
            keywords: &["ನ\u{cbf}ರಾಸ\u{cc6}", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("실망한 얼굴"),
            keywords: &["실망", "실망한 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निराश जाल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "निराश जाल\u{94d}लो च\u{947}रो",
                "निराशा जाल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көңүлү чөккөн бет"),
            keywords: &["бет", "көңүлү калган", "көңүлү чөккөн бет", "чөккөн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("enttäuscht"),
            keywords: &["Gesiicht", "enttäuscht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າຜ\u{eb4}ດຫວ\u{eb1}ງ"),
            keywords: &[
                "ຜ\u{eb4}ດຫວ\u{eb1}ງ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າຜ\u{eb4}ດຫວ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nusivylęs veidas"),
            keywords: &["nusivylęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīlusies seja"),
            keywords: &["seja", "vīlies", "vīlusies seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi pāpōuri"),
            keywords: &["kanohi", "pāpōuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("разочарано лице"),
            keywords: &["лице", "разочарано"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നിര\u{d3e}ശ\u{d3e}ഭരിതമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "നിര\u{d3e}ശ\u{d3e}ഭരിതം",
                "നിര\u{d3e}ശ\u{d3e}ഭരിതമ\u{d3e}യ മ\u{d41}ഖം",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урам хугарсан царай"),
            keywords: &["урам хугарсан", "урам хугарсан царай", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("निराशाजनक च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "निराश", "निराशाजनक च\u{947}हरा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka kecewa"),
            keywords: &["kecewa", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ diżappuntat"),
            keywords: &["diżappuntat", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{102d}တ\u{103a}ပျက\u{103a}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "စ\u{102d}တ\u{103a}ပျက\u{103a}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "စ\u{102d}တ\u{103a}ပျက\u{103a}နေသော မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skuffet"),
            keywords: &["fjes", "skuffelse", "skuffet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("निराश अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "निराश अन\u{941}हार", "निराश भएको"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("teleurgesteld gezicht"),
            keywords: &["gezicht", "teleurgesteld gezicht", "teleurstelling"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skuffa"),
            keywords: &["fjes", "skuffa", "skuffelse"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହତ\u{b3e}ଶ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ମ\u{b41}ହ\u{b01}", "ହତ\u{b3e}ଶ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਿਰਾਸ\u{a3c} ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਨਿਰਾਸ\u{a3c}", "ਨਿਰਾਸ\u{a3c}ਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مایوس شکل"),
            keywords: &["دی شکل", "مایوس", "مایوس شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Dẹm Dọ\u{301}n Disapọint"),
            keywords: &["Disapọint", "Fes", "Fes Wé Dẹm Dọ\u{301}n Disapọint"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rozczarowana twarz"),
            keywords: &["rozczarowana buźka", "rozczarowana twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مايوسه مخ"),
            keywords: &["مايوسه", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto desapontado"),
            keywords: &[
                "desapontamento",
                "rosto",
                "rosto decepcionado",
                "rosto desapontado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara desiludida"),
            keywords: &["cara", "cara desiludida", "desiludido"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqunnasqa uya"),
            keywords: &["sunqunnasqa uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față dezamăgită"),
            keywords: &["dezamăgire", "față", "față dezamăgită"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-866"),
            keywords: &["E10-866"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("разочарование"),
            keywords: &[
                "испытывает разочарование",
                "лицо",
                "недоволен",
                "разочарование",
                "фрустрация",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza guhemukirwa"),
            keywords: &[
                "guhemukirwa",
                "isura igaragaza",
                "isura igaragaza guhemukirwa",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نااميد چهرو"),
            keywords: &["نااميد", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බල\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}න\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "බල\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}න\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "බල\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}\u{dd4}න\u{dca}ව\u{dd6}",
                "බල\u{dcf}\u{dcf}පොරොත\u{dca}ත\u{dd4} ස\u{dd4}න\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sklamaná tvár"),
            keywords: &["sklamaná", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("razočaran obraz"),
            keywords: &["obraz", "razočaran obraz", "razočarano"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji niyadjabsan"),
            keywords: &["niyad jab", "waji", "waji niyadjabsan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e zhgënjyer"),
            keywords: &["e zhgënjyer", "fytyrë", "fytyrë e zhgënjyer"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("разочарано лице"),
            keywords: &["лице", "рaзoчaрањe", "разочарано лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["разочарано лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("razočarano lice"),
            keywords: &["lice", "razočaranje", "razočarano lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["razočarano lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("besviket ansikte"),
            keywords: &["besvikelse", "besviken", "besviket ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliosikitika"),
            keywords: &["sikitiko", "uso", "uso uliosikitika"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஏம\u{bbe}ற\u{bcd}றமடைந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "ஏம\u{bbe}ற\u{bcd}றமடைந\u{bcd}த முகம\u{bcd}",
                "ஏம\u{bbe}ற\u{bcd}றமடைந\u{bcd}தேன\u{bcd}",
                "ஏம\u{bbe}ற\u{bcd}றம\u{bcd}",
                "ஏம\u{bbe}ற\u{bcd}றம\u{bcd} ஏற\u{bcd}பட\u{bcd}டது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}ర\u{c3e}శ చ\u{c46}ంద\u{c3f}న ముఖం"),
            keywords: &[
                "న\u{c3f}ర\u{c3e}శ",
                "న\u{c3f}ర\u{c3e}శ చ\u{c46}ంద\u{c3f}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи ғамгин"),
            keywords: &["рӯи ғамгин", "рӯй", "ғамгин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าผ\u{e34}ดหว\u{e31}ง"),
            keywords: &[
                "ผ\u{e34}ดหว\u{e31}ง",
                "หน\u{e49}า",
                "หน\u{e49}าผ\u{e34}ดหว\u{e31}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lapykeç ýüz"),
            keywords: &["lapykeç", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata fakalotomamahi"),
            keywords: &["mata fakalotomamahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("memnuniyetsiz yüz"),
            keywords: &["kırgın yüz", "kırgınlık", "memnuniyetsiz yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈمىدسىز چىراي"),
            keywords: &["ئۈمىدسىز", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("розчароване обличчя"),
            keywords: &["обличчя", "розчароване обличчя", "розчарований"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مایوس چہرہ"),
            keywords: &["مایوس", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘ngli qolgan yuz"),
            keywords: &["ko‘ngli qolgan", "ko‘ngli qolgan yuz", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt thất vọng"),
            keywords: &["mặt", "mặt thất vọng", "thất vọng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu am mbetteel"),
            keywords: &["kanam", "kanam gu am mbetteel", "mbetteel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obuphoxekileyo"),
            keywords: &["phoxekile", "ubuso", "ubuso obuphoxekileyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú ìjakulẹ\u{300}"),
            keywords: &["ojú", "ojú ìjakulẹ\u{300}", "ìjakulẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("失望嘅臉"),
            keywords: &["失望", "失望嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("失望嘅脸"),
            keywords: &["失望", "失望嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("失望"),
            keywords: &["不高兴", "失望", "脸", "难过"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("失望"),
            keywords: &["失望", "沮喪"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("失望"),
            keywords: &["失望", "沮喪"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuphosekile"),
            keywords: &["ubuso", "ubuso obuphosekile", "ukuphoxeka"],
        },
    ],
};
#[doc = "😓"]
pub const DOWNCAST_FACE_WITH_SWEAT: crate::Emoji = crate::Emoji {
    glyph: "😓",
    codepoint: "1F613",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "downcast face with sweat",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesig met koue sweet"),
            keywords: &["gesig", "gesig met koue sweet", "koud", "sweet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀዝቃዛ ላብ ያለው ፊት"),
            keywords: &["ላብ", "ቀዝቃዛ", "ቀዝቃዛ ላብ ያለው ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه بعرق بارد"),
            keywords: &[
                "عرق",
                "وجه بعرق بارد",
                "وجه حزين",
                "وجه حزين متعرق",
                "وجه متعرق",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘম\u{9be}ৰ\u{9cd}ত নিৰ\u{9be}শ ম\u{9c1}খ"),
            keywords: &[
                "ঘম\u{9be}ৰ\u{9cd}ত নিৰ\u{9be}শ ম\u{9c1}খ",
                "ঘ\u{9be}ম",
                "ঠ\u{9be}ণ\u{9cd}ড\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("soyuq tərli üz"),
            keywords: &["soyuq", "soyuq tərli üz", "tər", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("халодны пот на твары"),
            keywords: &["няёмкасць", "пот", "халодны", "халодны пот на твары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лице със студена пот"),
            keywords: &["Лице със студена пот", "лице", "пот", "студен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ম\u{9c1}খের মধ\u{9cd}যে ঠ\u{9be}ণ\u{9cd}ড\u{9be} ঘ\u{9be}ম ল\u{9be}গ\u{9be}",
            ),
            keywords: &[
                "ঘর\u{9cd}ম\u{9be}ক\u{9cd}ত অবস\u{9cd}থ\u{9be}",
                "ঠ\u{9be}ন\u{9cd}ড\u{9be}",
                "ম\u{9c1}খ",
                "ম\u{9c1}খের মধ\u{9cd}যে ঠ\u{9be}ণ\u{9cd}ড\u{9be} ঘ\u{9be}ম ল\u{9be}গ\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblivenost hladnim znojem"),
            keywords: &["hladan", "lice", "oblivenost hladnim znojem", "znoj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara amb suor freda"),
            keywords: &["cara", "cara amb suor freda", "suor freda"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎤᏴᏟ ᎠᎵ"),
            keywords: &["ᎠᎵ", "ᎤᎧᏛ", "ᎤᎧᏛᎢ ᎤᏠᏯᏍᏗ ᎤᏴᏟ ᎠᎵ", "ᎤᏴᏝ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sklíčený obličej se studeným potem"),
            keywords: &[
                "pot",
                "sklíčený obličej se studeným potem",
                "smajlík",
                "studený",
                "tvář",
                "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn chwysu o ofid"),
            keywords: &["chwys", "gofid", "wyneb", "wyneb yn chwysu o ofid"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ansigt med koldsved"),
            keywords: &["ansigt", "ansigt med koldsved"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("bedrücktes Gesicht mit Schweiß"),
            keywords: &[
                "Angstschweiß",
                "Gesicht",
                "bedrückt",
                "bedrücktes Gesicht mit Schweiß",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Smiley mit kaltem Schweiss"),
            keywords: &[
                "Gesicht",
                "Smiley mit kaltem Schweiss",
                "geschlossene Augen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κρύος ιδρώτας"),
            keywords: &["ιδρώτας", "κρύος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("downcast face with sweat"),
            keywords: &["cold", "downcast face with sweat", "face", "sweat"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara con sudor frío"),
            keywords: &["cara", "cara con sudor frío", "frío", "sudor"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("külma higiga kaetud nägu"),
            keywords: &["higi", "külm", "külma higiga kaetud nägu", "nägu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izerdi hotza duen aurpegia"),
            keywords: &["aurpegi", "hotz", "izerdi", "izerdi hotza duen aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عرق سرد"),
            keywords: &["سرد", "سرما", "صورت", "عرق"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kylmänhiki"),
            keywords: &["hiki", "kylmä", "kylmänhiki", "naama"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pinagpapawisan nang malamig"),
            keywords: &["malamig", "mukha", "pawis", "pinagpapawisan nang malamig"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sveittandi andlit ið hyggur niðureftir"),
            keywords: &[
                "andlit",
                "niður",
                "sveittandi andlit ið hyggur niðureftir",
                "sveitti",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage démoralisé avec goutte de sueur"),
            keywords: &[
                "froide",
                "sueur",
                "visage",
                "visage démoralisé avec goutte de sueur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("visage triste et en sueur"),
            keywords: &[
                "froide",
                "sueur",
                "triste",
                "visage",
                "visage triste et en sueur",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog in ísle brí le fuarallas"),
            keywords: &["fuarallas", "imní", "straoiseog in ísle brí le fuarallas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ cur fallas fuar"),
            keywords: &["aodann", "aodann a’ cur fallas fuar", "fallas", "fuar"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara con suor fría"),
            keywords: &["cara", "cara con suor fría", "suor fría"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો ચહ\u{ac7}રો"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "ઠ\u{a82}ડા પરસ\u{ac7}વા સાથ\u{ac7}નો ચહ\u{ac7}રો",
                "ઠ\u{a82}ડો",
                "તકલીફોની સાથ\u{ac7} નિરાશાજનક ચહ\u{ac7}રો",
                "પરસ\u{ac7}વો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska tare da gumi mai sanyi"),
            keywords: &["fuska", "fuska tare da gumi mai sanyi", "gumi", "sanyi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עם זיעה קרה"),
            keywords: &["זיעה קרה", "טיפה", "פרצוף", "פרצוף עם זיעה קרה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठ\u{902}ड\u{947} पसीन\u{947} वाला उदास च\u{947}हरा"),
            keywords: &[
                "च\u{947}हरा",
                "ठ\u{902}डा पसीना",
                "ठ\u{902}ड\u{947} पसीन\u{947} वाला उदास च\u{947}हरा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tužno lice s kapljicom znoja"),
            keywords: &["hladno", "lice", "tužno lice s kapljicom znoja", "znoj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lehangolt arc verejtékkel"),
            keywords: &["arc", "lehangolt arc verejtékkel", "verejték"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սառը քրտինքով դեմք"),
            keywords: &["դեմք", "սառը", "սառը քրտինքով դեմք", "քրտինք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah berkeringat"),
            keywords: &["dingin", "keringat", "muka", "wajah", "wajah berkeringat"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu nwere okpofufu oyi"),
            keywords: &["ihu", "ihu nwere okpofufu oyi", "okpofufu", "oyi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kaldur sviti"),
            keywords: &["andlit", "andlit með köldum svita", "kaldur sviti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina abbattuta sudata"),
            keywords: &[
                "delusione",
                "faccina",
                "faccina abbattuta sudata",
                "faccina sudata",
                "sudore",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("冷や汗"),
            keywords: &["冷や汗", "肝を冷やした", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai prasa wis kesel nganti kringet tumetes"),
            keywords: &[
                "adhem",
                "kringet",
                "rai",
                "rai prasa wis kesel nganti kringet tumetes",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახე ცივი ოფლით"),
            keywords: &["ოფლი", "ოფლიანი", "სახე", "სახე ცივი ოფლით", "ცივი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қатты шаршап, терлеу"),
            keywords: &[
                "бет",
                "суық тер",
                "тер",
                "қатты шаршап терлеу",
                "қатты шаршап, терлеу",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ansigt med koldsved"),
            keywords: &["ansigt", "ansigt med koldsved"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខស\u{17d2}រពោនមានញើសព\u{17b8}ថ\u{17d2}ងាស"),
            keywords: &[
                "ញើស",
                "បែកញើស",
                "ពេបមាត\u{17cb}",
                "ម\u{17bb}ខស\u{17d2}រពោនមានញើសព\u{17b8}ថ\u{17d2}ងាស",
                "ស\u{17d2}រពោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಣ\u{ccd}ಣನ\u{cc6}ಯ ಬ\u{cc6}ವರ\u{cbf}ನ ಮುಖ"),
            keywords: &[
                "ತಣ\u{ccd}ಣನ\u{cc6}ಯ",
                "ತಣ\u{ccd}ಣನ\u{cc6}ಯ ಬ\u{cc6}ವರ\u{cbf}ನ ಮುಖ",
                "ಬ\u{cc6}ವರ\u{cbf}ನೊಂದ\u{cbf}ಗ\u{cc6} ಕುಸ\u{cbf}ದ\u{cbf}ರುವ ಮುಖ",
                "ಬ\u{cc6}ವರು",
                "ಮುಖ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("식은땀 흘리는 얼굴"),
            keywords: &["식은땀", "식은땀 흘리는 얼굴", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घाम द\u{947}\u{902}वपी पडिल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "घाम",
                "घाम द\u{947}\u{902}वपी पडिल\u{94d}लो च\u{947}रो",
                "च\u{947}रो",
                "थ\u{902}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("муздак тер аккан бет"),
            keywords: &["бет", "муздак", "муздак тер аккан бет", "тер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mat kalem Schweess eroflafend"),
            keywords: &[
                "Gesiicht",
                "Schweess",
                "kal",
                "mat kalem Schweess eroflafend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າມ\u{eb5}ເຫ\u{eb7}\u{ec8}ອເຢ\u{eb1}ນ"),
            keywords: &[
                "ເຫ\u{eb7}\u{ec8}ອ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າມ\u{eb5}ເຫ\u{eb7}\u{ec8}ອເຢ\u{eb1}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("veidas, išpiltas šalto prakaito"),
            keywords: &[
                "prakaitas",
                "veidas",
                "veidas, išpiltas šalto prakaito",
                "šaltas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja ar aukstu sviedru lāsi"),
            keywords: &["auksts", "seja", "seja ar aukstu sviedru lāsi", "sviedri"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi werawera mātao"),
            keywords: &["kanohi", "mātao", "werawera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со капка пот"),
            keywords: &["лице", "лице со капка пот", "пот"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിയർക\u{d4d}ക\u{d41}ന\u{d4d}ന ദ\u{d41}ഃഖിതമ\u{d3e}യ മ\u{d41}ഖം"),
            keywords: &[
                "തണ\u{d41}പ\u{d4d}പ\u{d4d}",
                "മ\u{d41}ഖം",
                "വിയർക\u{d4d}ക\u{d41}ന\u{d4d}ന ദ\u{d41}ഃഖിതമ\u{d3e}യ മ\u{d41}ഖം",
                "വിയർപ\u{d4d}പ\u{d41}ത\u{d41}ള\u{d4d}ളി",
                "വിയർപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүйтэн хөлс даасан царай"),
            keywords: &["хүйтэн", "хүйтэн хөлс даасан царай", "хөлс даах", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घामासह निराश च\u{947}हरा"),
            keywords: &[
                "घाम",
                "घामासह निराश च\u{947}हरा",
                "च\u{947}हरा",
                "थ\u{902}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka berpeluh sejuk"),
            keywords: &["muka", "muka berpeluh sejuk", "peluh", "sejuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ b’għaraq kiesaħ"),
            keywords: &["għaraq", "kiesaħ", "wiċċ", "wiċċ b’għaraq kiesaħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{103d}ေးစေးပြန\u{103a}သည\u{1037}\u{103a}မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ချ\u{103d}ေးစေးပြန\u{103a}",
                "ချ\u{103d}ေးစေးပြန\u{103a}သည\u{1037}\u{103a}မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kaldsvetter"),
            keywords: &["ansikt", "kaldsvette", "kaldsvetter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("असिनपसिन अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "असिनपसिन अन\u{941}हार", "चिसो", "पसिना"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("neerslachtig gezicht met zweetdruppel"),
            keywords: &[
                "gezicht",
                "koud",
                "neerslachtig gezicht met zweetdruppel",
                "zweet",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kaldsveittar"),
            keywords: &["fjes", "kaldsveittar", "kaldsveitte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b3e}ଳ ସହ\u{b3f}ତ ନ\u{b3f}ର\u{b3e}ଶ ମ\u{b41}ହ\u{b01}"),
            keywords: &[
                "ଝ\u{b3e}ଳ",
                "ଝ\u{b3e}ଳ ସହ\u{b3f}ତ ନ\u{b3f}ର\u{b3e}ଶ ମ\u{b41}ହ\u{b01}",
                "ଥଣ\u{b4d}ଡ\u{b3e}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਵਾਲਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਠ\u{a70}ਡ\u{a47} ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਵਾਲਾ ਚਿਹਰਾ",
                "ਡਰਿਆ ਹ\u{a4b}ਇਆ",
                "ਡਰਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹھنڈے پسینے آلی شکل"),
            keywords: &["دی شکل", "م\u{64f}ڑکا", "ٹھنڈا", "ٹھنڈے پسینے آلی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Swẹt An Nọ\u{301} Dé Hapí Sám Sám"),
            keywords: &[
                "Fes",
                "Fes Wé De Swẹt An Nọ\u{301} Dé Hapí Sám Sám",
                "Kold",
                "Swẹt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("twarz ze spuszczonymi oczami oblana potem"),
            keywords: &[
                "kropla potu",
                "spocony",
                "twarz ze spuszczonymi oczami oblana potem",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غمجن مخ سره د خولې"),
            keywords: &["بې مينې", "خوله", "غمجن مخ سره د خولې", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto cabisbaixo com gota de suor"),
            keywords: &[
                "rosto",
                "rosto cabisbaixo com gota de suor",
                "rosto com suor frio",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara cabisbaixa com gota de suor"),
            keywords: &["cara", "cara cabisbaixa com gota de suor", "frio", "suor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llakisqa uya sutʼuwan"),
            keywords: &["chiri", "llakisqa uya sutʼuwan", "sutʼu", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față abătută cu sudoare rece"),
            keywords: &["față", "față abătută cu sudoare rece", "sudoare rece"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-855"),
            keywords: &["E10-855"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("в холодном поту"),
            keywords: &["болезнь", "в холодном поту", "нервничает", "пот", "страх"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza ibyuya by’ubwoba"),
            keywords: &[
                "icyunzwe",
                "isura",
                "isura igaragaza ibyuya by’ubwoba",
                "ubukonje",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هلڪي آنسن سان لٿل چهرو"),
            keywords: &["هلڪي آنسن سان لٿل چهرو", "پگھر", "ٿڌو", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දහඩ\u{dd2}ය දම\u{dcf} ගත\u{dca} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "දහඩ\u{dd2}ය",
                "දහඩ\u{dd2}ය දම\u{dcf} ගත\u{dca} ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd3}තල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("skľúčená tvár s\u{a0}potom"),
            keywords: &[
                "deprimovaná",
                "pot",
                "skľúčená",
                "skľúčená tvár s\u{a0}potom",
                "tvár",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("obraz z mrzlim potom"),
            keywords: &["mrzlo", "obraz", "obraz z mrzlim potom", "pot"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji hoos u dhacsan oo dhididsan"),
            keywords: &[
                "dhidid",
                "qabow",
                "waji",
                "waji hoos u dhacsan oo dhididsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me djersë të ftohta"),
            keywords: &["djersë", "ftohtë", "fytyrë", "fytyrë me djersë të ftohta"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице обливено хладним знојем"),
            keywords: &["лице", "лице обливено хладним знојем", "хлaдaн знoj"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лице обливено хладним знојем"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice obliveno hladnim znojem"),
            keywords: &["hladan znoj", "lice", "lice obliveno hladnim znojem"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lice obliveno hladnim znojem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedslaget kallsvettigt ansikte"),
            keywords: &["nedslaget kallsvettigt ansikte", "svettig"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso wenye huzuni na jasho jembamba"),
            keywords: &[
                "jasho",
                "jembamba",
                "uso",
                "uso wenye huzuni na jasho jembamba",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "வ\u{bbe}ட\u{bcd}டமுற\u{bcd}ற, வியர\u{bcd}வைச\u{bcd} சொட\u{bcd}டும\u{bcd} முகம\u{bcd}",
            ),
            keywords: &[
                "அவசரம\u{bcd}",
                "களைப\u{bcd}பு",
                "படபடப\u{bcd}பு முகம\u{bcd}",
                "வ\u{bbe}ட\u{bcd}டமுற\u{bcd}ற, வியர\u{bcd}வைச\u{bcd} சொட\u{bcd}டும\u{bcd} முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}మట పట\u{c4d}ట\u{c3f}న ముఖం"),
            keywords: &[
                "అలసట",
                "చ\u{c46}మట",
                "చ\u{c46}మట పట\u{c4d}ట\u{c3f}న ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯй бо арақи хунук"),
            keywords: &["арақ", "рӯй", "рӯй бо арақи хунук", "хунук"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เหง\u{e37}\u{e48}อตก"),
            keywords: &["หน\u{e49}า", "เหง\u{e37}\u{e48}อ", "เหง\u{e37}\u{e48}อตก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("derli salyk ýüz"),
            keywords: &["der", "derli salyk ýüz", "sowuk", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata lototaʻotaʻomia moe tautaʻa"),
            keywords: &["mata lototaʻotaʻomia moe tautaʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("soğuk ter"),
            keywords: &["soğuk ter", "soğuk terli yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سوغۇق تەرلىك چىراي"),
            keywords: &["تەر", "سوغۇق", "سوغۇق تەرلىك چىراي", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("понурене обличчя в поту"),
            keywords: &[
                "обличчя",
                "обличчя з краплями холодного поту",
                "понурене обличчя в поту",
                "піт",
                "холодний",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹھنڈے پسینے والا چہرہ"),
            keywords: &["ٹھنڈ", "ٹھنڈے پسینے والا چہرہ", "پسینہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sovuq ter chiqayotgan yuz"),
            keywords: &["sovuq", "sovuq ter chiqayotgan yuz", "ter", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt chán nản với mồ hôi"),
            keywords: &["lạnh", "mặt", "mặt chán nản với mồ hôi", "mồ hôi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam ak ñaq wu sedd"),
            keywords: &["kanam", "kanam ak ñaq wu sedd", "sedd", "ñàq"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obunombilo obandayo"),
            keywords: &["ubuso", "ubuso obunombilo obandayo", "ukubanda", "umbilo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Pẹlu Ilaagun Tutu"),
            keywords: &["Oju Pẹlu Ilaagun Tutu", "ojú", "òtútù", "òógùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滴汗同沮喪嘅臉"),
            keywords: &["冰冷", "汗", "滴汗同沮喪嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("滴汗同沮丧嘅脸"),
            keywords: &["冰冷", "汗", "滴汗同沮丧嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("汗"),
            keywords: &["冷", "尴尬", "汗", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("冷汗"),
            keywords: &["冷汗", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("冷汗"),
            keywords: &["冷汗", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obunomjuluko obandayo"),
            keywords: &["banda", "ubuso", "ubuso obunomjuluko obandayo", "umjuluko"],
        },
    ],
};
#[doc = "😩"]
pub const WEARY_FACE: crate::Emoji = crate::Emoji {
    glyph: "😩",
    codepoint: "1F629",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "weary face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("uitgeputte gesig"),
            keywords: &["gesig", "moeg", "uitgeput", "uitgeputte gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምርር ያለው ፊት"),
            keywords: &["ምርር ያለው ፊት", "የተሰላቸ", "የደከመው", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه مجهد"),
            keywords: &["متعب", "وجه ضجر", "\u{202b}وجه مجهد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ল\u{9be}ন\u{9cd}ত চেহেৰ\u{9be}"),
            keywords: &[
                "ক\u{9cd}ল\u{9be}ন\u{9cd}ত",
                "ক\u{9cd}ল\u{9be}ন\u{9cd}ত চেহেৰ\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yorulmuş üz"),
            keywords: &["usanmış", "yorulmuş üz", "üz", "əzgin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("змораны твар"),
            keywords: &["змораны", "змораны твар", "стомлены"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Изтощено лице"),
            keywords: &["Изтощено лице", "изтощен", "лице", "уморен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পরিশ\u{9cd}র\u{9be}ন\u{9cd}ত ম\u{9c1}খ"),
            keywords: &[
                "ক\u{9cd}ল\u{9be}ন\u{9cd}ত হওয\u{9bc}\u{9be}",
                "পরিশ\u{9cd}র\u{9be}ন\u{9cd}ত",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("iscrpljenost"),
            keywords: &["iscrpljen", "iscrpljenost", "lice", "umoran"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara d’esgotament"),
            keywords: &[
                "cara",
                "cara d’esgotament",
                "esgotada",
                "esgotament",
                "esgotat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏍᏗᏰᏍᏒ ᎤᎧᏓ"),
            keywords: &["ᎤᎧᏛ", "ᏗᎦᏍᏗᏰᏍᏒ", "ᏗᎦᏍᏗᏰᏍᏒ ᎤᎧᏓ", "ᏧᏩᏪᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vyčerpaný obličej"),
            keywords: &[
                "smajlík",
                "tvář",
                "vyčerpaný obličej",
                "vyčerpání",
                "výraz",
                "únava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb lluddedig"),
            keywords: &["blinedig", "lluddedig", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("udmattet ansigt"),
            keywords: &["udkørt", "udmattet", "udmattet ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("erschöpftes Gesicht"),
            keywords: &["Gesicht", "erschöpft", "erschöpftes Gesicht", "müde"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εξάντληση"),
            keywords: &["εξάντληση", "εξαντλημένος", "κουρασμένος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("weary face"),
            keywords: &["face", "tired", "weary"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara agotada"),
            keywords: &["agotado", "cansado", "cara", "cara agotada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de cansancio"),
            keywords: &[
                "agotado",
                "cansado",
                "cara",
                "cara de cansancio",
                "exhausto",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara agotada"),
            keywords: &[
                "agotado",
                "cansado",
                "cara",
                "cara agotada",
                "cara de cansancio",
                "exhausto",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara agotada"),
            keywords: &["cara agotada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rammestunud nägu"),
            keywords: &["nägu", "rammestunud", "väsinud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("neke-aurpegia"),
            keywords: &["aurpegi", "nazkatu", "neke", "neke-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ازپاافتاده"),
            keywords: &[
                "ازپاافتاده",
                "بی\u{200c}حوصله",
                "خسته",
                "صورت",
                "کسل\u{200c}کننده",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("uupunut"),
            keywords: &["naama", "poikki", "uupumus", "uupunut", "väsynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagod na pagod"),
            keywords: &["mukha", "nalulumbay", "pagod", "pagod na pagod"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pøst andlit"),
            keywords: &["andlit", "pøst", "troytt", "troyttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage épuisé"),
            keywords: &["fatigué", "visage", "épuisé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog thraochta"),
            keywords: &["straoiseog thraochta", "tuirse", "tuirseach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann air chlaoidh"),
            keywords: &["aodann", "aodann air chlaoidh", "claoidh", "sgìth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de esgotamento"),
            keywords: &["cansazo", "cara", "cara de esgotamento", "esgotamento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{a82}ટાળાજનક ચહ\u{ac7}રો"),
            keywords: &["ક\u{a82}ટાળાજનક", "ચહ\u{ac7}રો", "થાક\u{ac7}લો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gajiyayyiyar fuska"),
            keywords: &["fuska", "gajiya", "gajiyayye", "gajiyayyiyar fuska"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מותש"),
            keywords: &["מותש", "עייף", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घबराया च\u{947}हरा"),
            keywords: &["घबराया", "च\u{947}हरा", "थका ह\u{941}आ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tegobno lice"),
            keywords: &["brige", "lice", "tegobno lice", "umor"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kimerült arc"),
            keywords: &["arc", "fáradt", "kimerült", "megviselt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուժասպառ դեմք"),
            keywords: &["դեմք", "հոգնած", "ուժասպառ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah terlalu lelah"),
            keywords: &["capek", "lelah", "muka", "wajah", "wajah terlalu lelah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ike ọgwụgwụ"),
            keywords: &["ihu", "ihu ike ọgwụgwụ", "ike ọgwụgwụ", "nwere ume ọgwụgwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þreytulegt andlit"),
            keywords: &["andlit", "þreyta", "þreytulegt andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina esausta"),
            keywords: &["esausta", "faccina", "sfinita"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あきらめ"),
            keywords: &["あきらめ", "疲れ", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai sayah"),
            keywords: &["kesel", "rai", "sayah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაქანცული სახე"),
            keywords: &["დაქანცული", "დაღლილი", "სახე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қалжырау"),
            keywords: &["беті", "шаршаған", "қалжырау", "қалжыраған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("udmattet ansigt"),
            keywords: &["udkørt", "udmattet", "udmattet ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខអស\u{17cb}កម\u{17d2}លា\u{17c6}ងខ\u{17d2}លា\u{17c6}ង"),
            keywords: &[
                "ម\u{17bb}ខអស\u{17cb}កម\u{17d2}លា\u{17c6}ងខ\u{17d2}លា\u{17c6}ង",
                "ហត\u{17cb}នឿយ",
                "អស\u{17cb}កម\u{17d2}លា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಸಹನ\u{cc6} ಮುಖ"),
            keywords: &["ಅಸಹನ\u{cc6} ಮುಖ", "ಅಸಹನ\u{cc6}ಯ ಮುಖ", "ದಣ\u{cbf}ದ ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지친 얼굴"),
            keywords: &["얼굴", "지친 얼굴", "지침"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{94d}रस\u{94d}त च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "त\u{94d}रस\u{94d}त",
                "प\u{941}रो जाल\u{94d}ल\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тажаган бет"),
            keywords: &["бет", "тажаган", "чарчаган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("erschëpft Gesiicht"),
            keywords: &["Gesiicht", "erschëpft", "midd"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າເບ\u{eb7}\u{ec8}ອໜ\u{ec8}າຍ"),
            keywords: &[
                "ເບ\u{eb7}\u{ec8}ອ",
                "ເມ\u{eb7}\u{ec8}ອຍ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າເບ\u{eb7}\u{ec8}ອໜ\u{ec8}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nuvargęs veidas"),
            keywords: &["nuvargęs", "pavargęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nogurdināta seja"),
            keywords: &["nogurdināta seja", "noguris", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi ruha"),
            keywords: &["kanohi", "ngenge", "ruha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("исцрпено лице"),
            keywords: &["исцрпено", "лице", "уморно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d4d}ഷീണിച\u{d4d}ച മ\u{d41}ഖം"),
            keywords: &["ക\u{d4d}ഷീണിച\u{d4d}ച", "തളർന\u{d4d}ന", "മ\u{d41}ഖം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("залхсан царай"),
            keywords: &["залхсан", "царай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सतावल\u{947}ला च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "थकल\u{947}ला", "सतावल\u{947}ला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka tak bermaya"),
            keywords: &["letih", "muka", "muka tak bermaya", "penat", "tak bermaya"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ mimli għeja"),
            keywords: &["għajjien", "għeja", "wiċċ", "wiċċ mimli għeja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ငြ\u{102e}းင\u{103d}ေ\u{1037}နေသော မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ငြ\u{102e}းင\u{103d}ေ\u{1037}နေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "ငြ\u{102e}းင\u{103d}ေ\u{1037}နေသော မျက\u{103a}န\u{103e}ာ",
                "ပင\u{103a}ပန\u{103a}းနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sliten"),
            keywords: &["fjes", "sliten", "trøtt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विचलित अन\u{941}हार"),
            keywords: &[
                "अन\u{941}हार",
                "ज\u{94d}याद\u{948} थाक\u{947}को",
                "थकित",
                "विचलित अन\u{941}हार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("moe gezicht"),
            keywords: &["gezicht", "moe", "vermoeid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sliten"),
            keywords: &["fjes", "sliten", "trøytt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅବସନ\u{b4d}ନ ମ\u{b41}ହ\u{b01}"),
            keywords: &["ଅବସନ\u{b4d}ନ", "ମ\u{b41}ହ\u{b01}", "ହ\u{b3e}ଲ\u{b3f}ଆ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a70}ਭਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਥ\u{a71}ਕਿਆ", "ਹ\u{a70}ਭਿਆ ਹ\u{a4b}ਇਆ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بیزار شکل"),
            keywords: &["بیزار شکل", "تھکیا ہوئیا", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Dọ\u{301}n Táyá Wẹ\u{301}l Wẹl"),
            keywords: &[
                "Fes",
                "Fes Wé Dọ\u{301}n Táyá Wẹ\u{301}l Wẹl",
                "Táya",
                "Táyá Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("znużona twarz"),
            keywords: &["zmęczenie", "zmęczona buźka", "znużona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بېزاره مخ"),
            keywords: &["بېزاره مخ", "ستومانه", "ستړې", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto desolado"),
            keywords: &["cansado", "rosto", "rosto aborrecido", "rosto desolado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara fatigada"),
            keywords: &["cansado", "cara", "cara fatigada", "exausto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ayqusqa uya"),
            keywords: &["ayqusqa", "sayk’usqa", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față extenuată"),
            keywords: &["epuizată", "față", "față extenuată", "oboseală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-877"),
            keywords: &["E10-877"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("усталость"),
            keywords: &["истощен", "лицо", "устал", "усталость"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura igaragaza umunaniro"),
            keywords: &["isura", "isura igaragaza umunaniro", "kuruha", "unaniwe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اکڙيل چهرو"),
            keywords: &["اکڙيل چهرو", "ٿڪجڻ", "ٿڪيل", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වෙහෙසට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "මහන\u{dca}ස\u{dd2}ය",
                "ම\u{dd4}හ\u{dd4}ණ",
                "වෙහෙස",
                "වෙහෙසට පත\u{dca} ව\u{dd6} ම\u{dd4}හ\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ustatá tvár"),
            keywords: &["tvár", "unavená", "ustatá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("izčrpan obraz"),
            keywords: &["izčrpan obraz", "izčrpano", "obraz", "utrujeno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji daal ka muuqdo"),
            keywords: &["daal", "daalan", "waji", "waji daal ka muuqdo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e rraskapitur"),
            keywords: &[
                "e lodhur",
                "e rraskapitur",
                "fytyrë",
                "fytyrë e rraskapitur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("преморено лице"),
            keywords: &["бригe", "лице", "преморено лице", "умoр"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["преморено лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("premoreno lice"),
            keywords: &["brige", "lice", "premoreno lice", "umor"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["premoreno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("uttröttat ansikte"),
            keywords: &["uttröttad", "uttröttat ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaoonyesha uchovu"),
            keywords: &["kuchoka", "uchovu", "uso", "uso unaoonyesha uchovu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மிகவும\u{bcd} பயந\u{bcd}த முகம\u{bcd}"),
            keywords: &[
                "களைத\u{bcd}த முகம\u{bcd}",
                "களைப\u{bcd}பு",
                "சோர\u{bcd}வு",
                "மிகவும\u{bcd} பயந\u{bcd}த முகம\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3f}ద\u{c4d}రల\u{c47}న\u{c3f} ముఖం"),
            keywords: &[
                "న\u{c3f}ద\u{c4d}ర",
                "న\u{c3f}ద\u{c4d}రల\u{c47}న\u{c3f} ముఖం",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи афгор"),
            keywords: &["афгор", "рӯи афгор", "рӯй", "хаста"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}าอ\u{e34}ดโรย"),
            keywords: &[
                "หน\u{e49}า",
                "หน\u{e49}าอ\u{e34}ดโรย",
                "เหน\u{e37}\u{e48}อย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("argyn ýüz"),
            keywords: &["argyn", "ýadaw", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata ongosia"),
            keywords: &["mata ongosia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çok yorgun"),
            keywords: &["yorgun yüz", "yorulmuş", "yüz", "çok yorgun"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھارغان چىراي"),
            keywords: &["چارچاش", "چىراي", "ھارغان چىراي", "ھارغىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("замучене обличчя"),
            keywords: &[
                "втомлене обличчя",
                "замучене обличчя",
                "зморений",
                "обличчя",
                "стомлений",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اکتایا ہوا چہرہ"),
            keywords: &["اکتایا ہوا چہرہ", "تھکاوٹ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xorg‘in yuz"),
            keywords: &["charchagan", "xorg‘in", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt kiệt sức"),
            keywords: &["kiệt sức", "mặt", "mặt kiệt sức", "mệt mỏi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanamu coono"),
            keywords: &["jommi", "kanam", "kanamu coono", "sonn"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obudiniweyo kakhulu"),
            keywords: &[
                "ubuso",
                "ubuso obudiniweyo kakhulu",
                "ukudinwa",
                "ukudinwa kakhulu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Ti o Rẹ\u{300}"),
            keywords: &["Oju Ti o Rẹ\u{300}", "ojú", "rírẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("好累嘅臉"),
            keywords: &["好累", "好累嘅臉", "累", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("好累嘅脸"),
            keywords: &["好累", "好累嘅脸", "累", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("累死了"),
            keywords: &["疲倦", "疲劳", "疲惫", "累", "累死了", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("唉!"),
            keywords: &["唉!", "疲勞", "疲憊", "累"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("面露疲憊"),
            keywords: &["唉!", "疲勞", "疲憊", "累", "面露疲憊"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuyethile"),
            keywords: &["ubuso", "ubuso obuyethile", "ukukhathala"],
        },
    ],
};
#[doc = "😫"]
pub const TIRED_FACE: crate::Emoji = crate::Emoji {
    glyph: "😫",
    codepoint: "1F62B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tired face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("moeë gesig"),
            keywords: &["gesig", "moeg", "moeë gesig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የደከመው ፊት"),
            keywords: &["የደከመ", "የደከመው ፊት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}وجه متعب"),
            keywords: &["وجه مجهد", "\u{202b}وجه متعب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ল\u{9be}ন\u{9cd}ত ম\u{9c1}খ"),
            keywords: &["ক\u{9cd}ল\u{9be}ন\u{9cd}ত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yorğun üz"),
            keywords: &["yorğun", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стомлены твар"),
            keywords: &["стомлены", "стомлены твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Уморено лице"),
            keywords: &["Уморено лице", "лице", "уморен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}ল\u{9be}ন\u{9cd}ত ম\u{9c1}খ"),
            keywords: &["ক\u{9cd}ল\u{9be}ন\u{9cd}ত", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("umoran"),
            keywords: &["lice", "umor", "umoran"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara de cansament"),
            keywords: &["cansament", "cara", "cara de cansament"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᏯᏪᎦ ᎤᎧᏛ"),
            keywords: &["ᎤᎧᏛ", "ᏚᏯᏪᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("unavený obličej"),
            keywords: &["smajlík", "tvář", "unavený obličej", "výraz", "únava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb blinedig"),
            keywords: &["blinedig", "blino", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("træt ansigt"),
            keywords: &["ansigt", "træt ansigt"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("müdes Gesicht"),
            keywords: &["Gesicht", "müde", "müdes Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κουρασμένο πρόσωπο"),
            keywords: &["κουρασμένο πρόσωπο", "κουρασμένος", "πρόσωπο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tired face"),
            keywords: &["face", "tired"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara cansada"),
            keywords: &["cansado", "cara", "cara cansada"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara cansada"),
            keywords: &[
                "agotado",
                "cansado",
                "cara",
                "cara cansada",
                "cara de exhausto",
                "exhausto",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cara cansada"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("cara cansada"),
            keywords: &["cara cansada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("väsinud nägu"),
            keywords: &["nägu", "väsinud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("nekatu-aurpegia"),
            keywords: &["aurpegi", "nekatu", "nekatu-aurpegia"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت خسته"),
            keywords: &["خسته", "خستگی", "صورت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("väsynyt"),
            keywords: &["naama", "uupumus", "väsymys", "väsynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagod na mukha"),
            keywords: &["mukha", "pagod na mukha"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("troytt andlit"),
            keywords: &["andlit", "móð", "móður", "troytt", "troyttur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage fatigué"),
            keywords: &["fatigue", "visage", "visage fatigué"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("straoiseog thuirseach"),
            keywords: &["aghaidh", "straoiseog thuirseach", "tuirseach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann sgìth"),
            keywords: &["aodann", "sgìth"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara de cansazo"),
            keywords: &["cansa", "cansazo", "canso", "cara", "cara de cansazo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("થાક\u{ac7}લો ચહ\u{ac7}રો"),
            keywords: &["ચહ\u{ac7}રો", "થાક\u{ac7}લો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("fuska mai gajiya"),
            keywords: &["fuska", "fuska mai gajiya", "gajiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף עייף"),
            keywords: &["מפהק", "עייף", "פרצוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थका च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "थका च\u{947}हरा", "थका ह\u{941}आ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("umorno lice"),
            keywords: &["lice", "umor", "umorno lice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fáradt arc"),
            keywords: &["arc", "fáradt arc", "fáradtság"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հոգնած դեմք"),
            keywords: &["դեմք", "հոգնած"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah kelelahan"),
            keywords: &["capek", "lelah", "muka", "wajah", "wajah kelelahan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ihu ume ọgwụgwụ"),
            keywords: &["ihu", "ihu ume ọgwụgwụ", "nwere ume ọgwụgwụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þreytt andlit"),
            keywords: &["andlit", "þreyta", "þreytt andlit"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina stanca"),
            keywords: &["faccina", "stanca"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("疲れた"),
            keywords: &["疲れ", "疲れた", "限界", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai kesel"),
            keywords: &["kesel", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("დაღლილი სახე"),
            keywords: &["დაღლილი", "სახე"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("udem yeɛyan"),
            keywords: &["udem yeɛyan"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қатты шаршау"),
            keywords: &["бет", "шаршау", "қатты шаршау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("træt ansigt"),
            keywords: &["ansigt", "træt ansigt"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខអស\u{17cb}កម\u{17d2}លា\u{17c6}ង"),
            keywords: &[
                "ម\u{17bb}ខអស\u{17cb}កម\u{17d2}លា\u{17c6}ង",
                "ហត\u{17cb}",
                "អស\u{17cb}កម\u{17d2}លា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ದಣ\u{cbf}ದ ಮುಖ"),
            keywords: &["ದಣ\u{cbf}ದ ಮುಖ", "ದಣ\u{cbf}ದ\u{cbf}ರುವುದು", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("피곤한 얼굴"),
            keywords: &["얼굴", "피곤한 얼굴", "피곤함"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("प\u{941}रो जाल\u{94d}लो च\u{947}रो"),
            keywords: &[
                "च\u{947}रो",
                "प\u{941}रो जाल\u{94d}लो",
                "प\u{941}रो जाल\u{94d}लो च\u{947}रो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чарчаган бет"),
            keywords: &["бет", "чарчаган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("midd"),
            keywords: &["Gesiicht", "midd"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າອ\u{eb4}ດເມ\u{eb7}\u{ec8}ອຍ"),
            keywords: &[
                "ເມ\u{eb7}\u{ec8}ອຍ",
                "ໜ\u{ec9}າ",
                "ໜ\u{ec9}າອ\u{eb4}ດເມ\u{eb7}\u{ec8}ອຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pavargęs veidas"),
            keywords: &["pavargęs", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nogurusi seja"),
            keywords: &["nogurums", "nogurusi seja", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kanohi ngenge"),
            keywords: &["kanohi", "ngenge"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("уморно лице"),
            keywords: &["лице", "уморно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തളർച\u{d4d}ചയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം"),
            keywords: &[
                "തളർച\u{d4d}ചയ\u{d41}ള\u{d4d}ള മ\u{d41}ഖം",
                "തളർന\u{d4d}ന",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ядарсан царай"),
            keywords: &["царай", "ядарсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थकल\u{947}ला च\u{947}हरा"),
            keywords: &["च\u{947}हरा", "थकल\u{947}ला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka letih"),
            keywords: &["letih", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("wiċċ għajjien"),
            keywords: &["għajjien", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပင\u{103a}ပန\u{103a}းသည\u{1037}\u{103a}မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ပင\u{103a}ပန\u{103a}း",
                "ပင\u{103a}ပန\u{103a}းသည\u{1037}\u{103a}မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trøtt fjes"),
            keywords: &["fjes", "overtrøtt", "sliten", "søvnig", "trøtt fjes"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थाक\u{947}को अन\u{941}हार"),
            keywords: &["अन\u{941}हार", "थाक\u{947}को"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vermoeid gezicht"),
            keywords: &["gezicht", "moe", "vermoeid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trøytt fjes"),
            keywords: &["fjes", "overtrøytt", "sliten", "søvnig", "trøytt fjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ଲ\u{b3e}ନ\u{b4d}ତ ମ\u{b41}ହ\u{b01}"),
            keywords: &["କ\u{b4d}ଲ\u{b3e}ନ\u{b4d}ତ", "ମ\u{b41}ହ\u{b01}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a71}ਕਿਆ ਚਿਹਰਾ"),
            keywords: &["ਚਿਹਰਾ", "ਥ\u{a71}ਕਿਆ", "ਥ\u{a71}\u{a71}ਕਿਆ ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تھکی شکل"),
            keywords: &["تھکی شکل", "تھکیا ہوئیا", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé Dọ\u{301}n Táya"),
            keywords: &["Fes", "Fes Wé Dọ\u{301}n Táya", "Táya"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zmęczona twarz"),
            keywords: &["zmęczenie", "zmęczona buźka", "zmęczona twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ستړي مخ"),
            keywords: &["ستړى", "ستړي مخ", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto cansado"),
            keywords: &["cansado", "exausto", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara cansada"),
            keywords: &["cansado", "cara", "cara cansada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saykʼusqa uya"),
            keywords: &["saykʼusqa uya", "sayk’usqa", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față obosită"),
            keywords: &["extenuare", "față", "față obosită", "oboseală"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-879"),
            keywords: &["E10-879"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сильная усталость"),
            keywords: &[
                "лицо",
                "отдых",
                "работа",
                "сильная усталость",
                "спать",
                "усталость",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("isura inaniwe"),
            keywords: &["isura", "isura inaniwe", "unaniwe"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٿڪل چهرو"),
            keywords: &["ٿڪل چهرو", "ٿڪيل", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ඩ\u{dcf}බර ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "මහ\u{dd4}ණ",
                "ව\u{dd2}ඩ\u{dcf}බර ම\u{dd4}හ\u{dd4}ණ",
                "වෙහෙසකර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("unavená tvár"),
            keywords: &["tvár", "unavená", "únava"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("utrujen obraz"),
            keywords: &["obraz", "utrujen obraz", "utrujeno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji daalan"),
            keywords: &["daal", "waji", "waji daalan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e lodhur"),
            keywords: &["e lodhur", "fytyrë", "fytyrë e lodhur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("уморно лице"),
            keywords: &["лице", "умoр", "уморно лице"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["уморно лице"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("umorno lice"),
            keywords: &["lice", "umor", "umorno lice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["umorno lice"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("trött ansikte"),
            keywords: &["trött", "trött ansikte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso uliochoka"),
            keywords: &["uchovu", "uso", "uso uliochoka"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சோர\u{bcd}வு முகம\u{bcd}"),
            keywords: &[
                "அலுப\u{bcd}பு",
                "களைத\u{bcd}த முகம\u{bcd}",
                "களைப\u{bcd}பு",
                "சோர\u{bcd}வு",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అల\u{c3f}స\u{c3f}ప\u{c4b}య\u{c3f}న ముఖం"),
            keywords: &["అలసట", "అల\u{c3f}స\u{c3f}ప\u{c4b}య\u{c3f}న ముఖం", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("рӯи хаста"),
            keywords: &["рӯи хаста", "рӯй", "хаста"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เหน\u{e37}\u{e48}อย"),
            keywords: &["หน\u{e49}า", "เหน\u{e37}\u{e48}อย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýadaw ýüz"),
            keywords: &["ýadaw", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata helaʻia"),
            keywords: &["mata helaʻia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yorgun yüz"),
            keywords: &["yorgun yüz", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھارغىن چىراي"),
            keywords: &["چىراي", "ھارغىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("стомлене обличчя"),
            keywords: &["обличчя", "стомлене обличчя", "стомлений"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تھکا ہوا چہرہ"),
            keywords: &["تھکا ہوا چہرہ", "تھکان", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("charchagan yuz"),
            keywords: &["charchagan", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt mệt mỏi"),
            keywords: &["mặt", "mặt mệt mỏi", "mệt mỏi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kanam gu sonn"),
            keywords: &["kanam", "kanam gu sonn", "sonn"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuso obudiniweyo"),
            keywords: &["ubuso", "ubuso obudiniweyo", "ukudinwa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Oju Rirẹ"),
            keywords: &["Oju Rirẹ", "ojú", "rírẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("累嘅臉"),
            keywords: &["累", "累嘅臉", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("累嘅脸"),
            keywords: &["累", "累嘅脸", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("累"),
            keywords: &["疲倦", "疲劳", "疲惫", "累", "脸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("累"),
            keywords: &["嘆氣", "疲勞", "疲憊", "累"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("累"),
            keywords: &["嘆氣", "疲勞", "疲憊", "累"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obukhathele"),
            keywords: &["kathele", "ubuso", "ubuso obukhathele"],
        },
    ],
};
#[doc = "🥱"]
pub const YAWNING_FACE: crate::Emoji = crate::Emoji {
    glyph: "🥱",
    codepoint: "1F971",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "yawning face",
    group: "Smileys & Emotion",
    subgroup: "face-concerned",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gapende gesig"),
            keywords: &["gaap", "gapende gesig", "moeg", "verveeld"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚያዛጋ ፊት"),
            keywords: &["መደበር", "መድከም", "ማዛጋት", "የሚያዛጋ ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("وجه متثائب"),
            keywords: &["تثاؤب", "متعب", "ملل", "وجه متثائب", "يتثاءب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিৎক\u{9be}ৰ কৰ\u{9be} ম\u{9c1}খমণ\u{9cd}ডল"),
            keywords: &[
                "ক\u{9cd}ল\u{9be}ন\u{9cd}ত",
                "চিৎক\u{9be}ৰ কৰ\u{9be} ম\u{9c1}খমণ\u{9cd}ডল",
                "বিৰক\u{9cd}ত",
                "হ\u{9be}মি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əsnəyən üz"),
            keywords: &["bezmiş", "yorğun", "əsnəyən", "əsnəyən üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пазяханне"),
            keywords: &["нуда", "пазяхае", "пазяханне", "стома"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("прозяващо се лице"),
            keywords: &["прозяващо се лице", "прозявка", "скука", "умора"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ই তোল\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "উদ\u{9be}স",
                "ক\u{9cd}ল\u{9be}ন\u{9cd}ত",
                "হ\u{9be}ই তোল\u{9be}",
                "হ\u{9be}ই তোল\u{9be} ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zijevanje"),
            keywords: &["dosada", "umor", "zijevanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cara que badalla"),
            keywords: &["avorriment", "badall", "cansament", "cara que badalla"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎸᏍᎦ ᎤᎧᏛ"),
            keywords: &["ᎤᏔᎴᏒ", "ᎦᎸᏍᎦ", "ᎦᎸᏍᎦ ᎤᎧᏛ", "ᏚᏯᏪᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zívající obličej"),
            keywords: &["unavený", "výraz", "znuděný", "zívající obličej"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("wyneb yn dylyfu gên"),
            keywords: &["blino", "diflasu", "dylyfu gên", "wyneb yn dylyfu gên"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gabende ansigt"),
            keywords: &["gab", "gabende ansigt", "træt", "uinteresseret"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gähnendes Gesicht"),
            keywords: &["gelangweilt", "gähnen", "gähnendes Gesicht", "müde"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πρόσωπο που χασμουριέται"),
            keywords: &[
                "βαριέμαι",
                "κουρασμένος",
                "πρόσωπο που χασμουριέται",
                "χασμουριέμαι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yawning face"),
            keywords: &["bored", "tired", "yawn", "yawning face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cara de bostezo"),
            keywords: &[
                "aburrido",
                "bostezo",
                "cansado",
                "cara de bostezo",
                "dormido",
                "sueño",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("haigutav nägu"),
            keywords: &[
                "haigutamine",
                "haigutav nägu",
                "haigutus",
                "igav",
                "väsinud",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aharrausi egiten ari den aurpegia"),
            keywords: &[
                "aharrausi",
                "aharrausi egiten ari den aurpegia",
                "aspertuta",
                "nekatuta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("صورت خمیازه\u{200c}کش"),
            keywords: &["خسته", "خمیازه", "صورت خمیازه\u{200c}کش", "کسل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("haukotteleva naama"),
            keywords: &["haukotteleva naama", "haukotus", "kyllästynyt", "väsynyt"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mukhang humihikab"),
            keywords: &["humihikab", "mukhang humihikab", "nababagot", "pagod"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("geispandi andlit"),
            keywords: &[
                "geisp",
                "geispandi andlit",
                "keða",
                "keðsemi",
                "troytt",
                "troyttur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("visage bâillant"),
            keywords: &["bâiller", "ennui", "fatigue", "visage bâillant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aghaidh ag méanfach"),
            keywords: &["aghaidh ag méanfach", "leamh", "méanfach", "tuirseach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aodann a’ mèananaich"),
            keywords: &[
                "aodann a’ mèananaich",
                "dòrainneach",
                "fadal",
                "mèalanaich",
                "mèanan",
                "mèananaich",
                "mèaran",
                "mèaranaich",
                "ràsanach",
                "sgìth",
                "sàraichte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cara bocexando"),
            keywords: &["aburrimento", "bocexo", "canso", "cara bocexando", "sono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બગાસ\u{ac1}\u{a82} ખાતો ચહ\u{ac7}રો"),
            keywords: &[
                "ક\u{a82}ટાળ\u{ac7}લ",
                "થાક\u{ac7}લ",
                "બગાસ\u{ac1}\u{a82}",
                "બગાસ\u{ac1}\u{a82} ખાતો ચહ\u{ac7}રો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פרצוף מפהק"),
            keywords: &["עייף", "עייפות", "פיהוק", "פרצוף מפהק", "שעמום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उबासी ल\u{947}ता च\u{947}हरा"),
            keywords: &[
                "उबासी",
                "उबासी ल\u{947}ता च\u{947}हरा",
                "ऊ\u{901}घना",
                "ऊबना",
                "जम\u{94d}हाई",
                "थकान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zijevajuće lice"),
            keywords: &["dosadno", "umor", "zijevajuće lice", "zijevanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ásító arc"),
            keywords: &["arc", "fáradt", "ásít", "ásítás", "ásító"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հորանջող դեմք"),
            keywords: &["հոգնած", "հորանջ", "հորանջող դեմք", "ձանձրացած"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wajah menguap"),
            keywords: &["bosan", "lelah", "menguap", "wajah menguap"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("geispandi andlit"),
            keywords: &["geispa", "geispandi andlit", "leiðindi", "þreyta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("faccina che sbadiglia"),
            keywords: &[
                "annoiata",
                "annoiate",
                "annoiati",
                "annoiato",
                "faccina che sbadiglia",
                "mi annoio",
                "noia",
                "sbadigliare",
                "sbadiglio",
                "sonno",
                "stanca",
                "stanche",
                "stanchezza",
                "stanchi",
                "stanco",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あくびした顔"),
            keywords: &["あくびした顔", "ふあ～", "疲れ", "眠い", "退屈", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("rai angop"),
            keywords: &["angop", "bosen", "kesel", "rai angop"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მთქნარება"),
            keywords: &["დამთქნარება", "დაღლილი", "მთქნარება", "მოწყენილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("есінеу"),
            keywords: &["есінеу", "іші пысу", "қатты шаршау"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17bb}ខស\u{17d2}ងាប"),
            keywords: &[
                "គ\u{17bd}រឱ\u{17d2}យធ\u{17bb}ញ",
                "ធ\u{17bb}ញ",
                "ម\u{17bb}ខស\u{17d2}ងាប",
                "ស\u{17d2}ងាប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಕಳ\u{cbf}ಸುವ ಮುಖ"),
            keywords: &["ಆಕಳ\u{cbf}ಸುವ", "ಆಕಳ\u{cbf}ಸುವ ಮುಖ", "ಆಯಾಸದ", "ಬೇಸರದ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하품하는 얼굴"),
            keywords: &["지루함", "피곤함", "하품", "하품하는 얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जा\u{902}भय दिवपी च\u{947}रो"),
            keywords: &[
                "जा\u{902}भय",
                "जा\u{902}भय दिवपी च\u{947}रो",
                "प\u{941}रो जाल\u{94d}लो",
                "वाज\u{947}ल\u{94d}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эстеп жаткан жүз"),
            keywords: &["зериккен", "чарчаган", "эстеп жаткан", "эстеп жаткан жүз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໜ\u{ec9}າ\u{200b}ຫາວນ\u{200b}ອນ"),
            keywords: &[
                "ຫາວນອນ",
                "ເມ\u{eb7}\u{ec8}\u{200b}ອຍ",
                "ໜ\u{ec9}າ\u{200b}ຫາວນ\u{200b}ອນ",
                "ໜ\u{ec9}າ\u{200b}ເບ\u{eb7}\u{ec8}ອ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žiovaujantis veidas"),
            keywords: &[
                "nuobodžiaujantis",
                "pavargęs",
                "žiovaujantis veidas",
                "žiovauti",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("seja žāvājas"),
            keywords: &["garlaikots", "nogurdināts", "seja žāvājas", "žāvas"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице што се прозева"),
            keywords: &["лице што се прозева", "прозевање", "уморно"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കോട\u{d4d}ട\u{d41}വ\u{d3e}യിട\u{d41}ന\u{d4d}ന മ\u{d41}ഖം"),
            keywords: &[
                "കോട\u{d4d}ട\u{d41}വ\u{d3e}യിട\u{d41}ന\u{d4d}ന മ\u{d41}ഖം",
                "കോട\u{d4d}ട\u{d41}വ\u{d3e}യ\u{d4d}",
                "ക\u{d4d}ഷീണിച\u{d4d}ച",
                "മ\u{d41}ഷിവ\u{d41}ള\u{d4d}ള",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эвшээж буй царай"),
            keywords: &["уйдсан", "эвшээж буй царай", "эвшээх", "ядарсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जा\u{902}भई द\u{947}णारा च\u{947}हरा"),
            keywords: &[
                "क\u{902}टाळल\u{947}ला",
                "जा\u{902}भई",
                "जा\u{902}भई द\u{947}णारा च\u{947}हरा",
                "थकल\u{947}ला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("muka menguap"),
            keywords: &["bosan", "letih", "menguap", "muka menguap"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သန\u{103a}းဝေနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ"),
            keywords: &[
                "ငြ\u{102e}းင\u{103d}ေ\u{1037}သည\u{103a}",
                "ပင\u{103a}ပန\u{103a}းသည\u{103a}",
                "သန\u{103a}းဝေနေသည\u{1037}\u{103a} မျက\u{103a}န\u{103e}ာ",
                "သန\u{103a}းဝေသည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gjespende fjes"),
            keywords: &["gjesp", "gjespende fjes", "kjedelig", "sliten"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हाइ तान\u{947}को अन\u{941}हार"),
            keywords: &[
                "अल\u{94d}छी लाग\u{947}को",
                "था\u{947}कको",
                "हाइ तान\u{947}को अन\u{941}हार",
                "हाइ तान\u{94d}न\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gapend gezicht"),
            keywords: &["gaap", "gapend gezicht", "vermoeid", "verveeld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("geispande fjes"),
            keywords: &["geisp", "geispande fjes", "keisamt", "sliten"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଇମ\u{b3e}ର\u{b3f}ବ\u{b3e} ମ\u{b41}\u{b01}ହ"),
            keywords: &[
                "ବ\u{b3f}ବ\u{b4d}ବ\u{b4d}ରତ",
                "ହ\u{b3e}ଇମ\u{b3e}ର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ଇମ\u{b3e}ର\u{b3f}ବ\u{b3e} ମ\u{b41}\u{b01}ହ",
                "ହ\u{b3e}ଲ\u{b3f}ଆ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉਬਾਸੀ ਲ\u{a48}\u{a02}ਦਾ ਚਿਹਰਾ"),
            keywords: &[
                "ਅ\u{a71}ਕਿਆ",
                "ਉਬਾਸੀ ਲ\u{a48}\u{a02}ਦਾ ਚਿਹਰਾ",
                "ਥ\u{a71}ਕਿਆ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fes Wé De Yọn"),
            keywords: &[
                "Dọ\u{301}n Táyá To Dú Sọ\u{301}mtin",
                "Fes Wé De Yọn",
                "Táya",
                "Yọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ziewająca twarz"),
            keywords: &["nuda", "ziewająca twarz", "ziewać", "zmęczenie", "znudzony"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د ارږمي مخ"),
            keywords: &["ارږمی کول", "تنګ شوی", "د ارږمي مخ", "ستړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rosto bocejando"),
            keywords: &["bocejo", "cansado", "entediado", "rosto bocejando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cara a bocejar"),
            keywords: &["bocejo", "cansado", "cara a bocejar", "entediado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanyasqa uya"),
            keywords: &["hanyasqa", "hanyasqa uya", "maji", "majisqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("față care cască"),
            keywords: &["căscat", "față care cască", "oboseală", "plictis"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–026"),
            keywords: &["E12–026"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зевает"),
            keywords: &[
                "зевает",
                "зевота",
                "сонный",
                "спать",
                "усталость",
                "утомлен",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اوٻاسيندڙ چهرو"),
            keywords: &["اوٻاسي", "اوٻاسيندڙ چهرو", "بوريت", "ٿڪل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඈන\u{dd4}ම\u{dca} අර\u{dd2}න ම\u{dd4}හ\u{dd4}ණ"),
            keywords: &[
                "ඈන\u{dd4}ම\u{dca} අර\u{dd2}න",
                "ඈන\u{dd4}ම\u{dca} අර\u{dd2}න ම\u{dd4}හ\u{dd4}ණ",
                "කම\u{dca}මැල\u{dd2}",
                "වෙහෙස\u{dd4}ණ\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zívajúca tvár"),
            keywords: &["unavený", "unudený", "znudený", "zívajúca tvár", "zívať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zehajoč obraz"),
            keywords: &["dolgčas", "utrujen", "zehajoč obraz", "zehanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("waji hammaansanaya"),
            keywords: &["cajisan", "daallan", "hammaansasho", "waji hammaansanaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë e mërzitur"),
            keywords: &["e lodhur", "e mërzitur", "fytyrë", "fytyrë e mërzitur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лице зева"),
            keywords: &["досадно", "зев", "лице зева", "уморан"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("лице зијева"),
            keywords: &["лице зијева"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lice zeva"),
            keywords: &["dosadno", "lice zeva", "umoran", "zev"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("lice zijeva"),
            keywords: &["lice zijeva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gäspande ansikte"),
            keywords: &["gäspa", "gäspande ansikte", "trött", "uttråkad"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("uso unaopiga miayo"),
            keywords: &["choka", "piga miayo", "uchovu", "uso unaopiga miayo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கொட\u{bcd}ட\u{bbe}வி விடும\u{bcd} முகம\u{bcd}"),
            keywords: &[
                "களைப\u{bcd}பு",
                "கொட\u{bcd}ட\u{bbe}வி",
                "கொட\u{bcd}ட\u{bbe}வி விடும\u{bcd} முகம\u{bcd}",
                "சலிப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆవుల\u{c3f}స\u{c4d}తున\u{c4d}న ముఖం"),
            keywords: &[
                "అలసట",
                "ఆవుల\u{c3f}ంత",
                "ఆవుల\u{c3f}స\u{c4d}తున\u{c4d}న ముఖం",
                "వ\u{c3f}సుగు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หน\u{e49}ากำล\u{e31}งหาว"),
            keywords: &[
                "หน\u{e49}ากำล\u{e31}งหาว",
                "หาว",
                "เบ\u{e37}\u{e48}อ",
                "เหน\u{e37}\u{e48}อย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pallaýan ýüz"),
            keywords: &["içi gysan", "palla", "pallaýan ýüz", "ýadaw"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata mamao"),
            keywords: &["mata mamao"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("esneyen yüz"),
            keywords: &["esneme", "esneyen yüz", "sıkılmış", "yorgun"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("обличчя, що позіхає"),
            keywords: &[
                "знуджений",
                "обличчя, що позіхає",
                "позіхайло",
                "позіхати",
                "стомлений",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جمائی لیتا چہرہ"),
            keywords: &["بوریت کا شکار", "تھکا ماندہ", "جمائی", "جمائی لیتا چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("esnayotgan yuz"),
            keywords: &["charchagan", "esnayotgan", "esnayotgan yuz", "xorg‘in"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mặt đang ngáp"),
            keywords: &["chán", "mặt đang ngáp", "mệt mỏi", "ngáp"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打喊露嘅臉"),
            keywords: &["悶", "打喊露", "打喊露嘅臉", "累"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打喊露嘅脸"),
            keywords: &["打喊露", "打喊露嘅脸", "累", "闷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("打呵欠"),
            keywords: &["呵欠", "哈欠", "困", "打呵欠", "无聊", "累"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("呵欠"),
            keywords: &["呵欠", "無聊", "疲勞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("呵欠｜打喊露｜打呵欠｜打呵欠嘅樣"),
            keywords: &[
                "呵欠",
                "呵欠｜打喊露｜打呵欠｜打呵欠嘅樣",
                "想訓覺｜打呵欠",
                "無聊",
                "疲勞",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuso obuzamulayo"),
            keywords: &["khathele", "thukuthezi", "ubuso obuzamulayo", "zamula"],
        },
    ],
};
