#[doc = "💋"]
pub const KISS_MARK: crate::Emoji = crate::Emoji {
    glyph: "💋",
    codepoint: "1F48B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "kiss mark",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("soenmerk"),
            keywords: &["hart", "lippe", "merk", "romanse", "soen", "soenmerk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመሳም ምልክት"),
            keywords: &["መሳም", "ምልክት", "ከንፈሮች", "የመሳም ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة قبلة"),
            keywords: &["رومانسية", "شفاه", "علامة قبلة", "قبلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9c1}ম\u{9cd}বন চিহ\u{9cd}ন"),
            keywords: &[
                "ও\u{981}ঠ",
                "চ\u{9c1}ম\u{9cd}বন",
                "চ\u{9c1}ম\u{9cd}বন চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("öpüş işarəsi"),
            keywords: &[
                "dodaq",
                "işarə",
                "romantika",
                "öpüş",
                "öpüş işarəsi",
                "ürək",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("след ад пацалунку"),
            keywords: &["губы", "пацалунак", "след ад пацалунку"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Отпечатък от целувка"),
            keywords: &[
                "Отпечатък от целувка",
                "отпечатък",
                "отпечатък от целувка",
                "романтика",
                "устни",
                "целувка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চ\u{9c1}ম\u{9cd}বনের চিহ\u{9cd}ন"),
            keywords: &[
                "চ\u{9c1}ম\u{9cd}বন",
                "চ\u{9c1}ম\u{9cd}বনের চিহ\u{9cd}ন",
                "ঠোট",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otisak poljupca"),
            keywords: &["otisak poljupca", "poljubac", "usne"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("marca de petó"),
            keywords: &["marca", "marca de petó", "petó"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᏪᏙᏅᎢ ᎤᏙᏪᎸᎢ"),
            keywords: &["ᎠᏔᏪᏙᏅᎢ", "ᎠᏔᏪᏙᏅᎢ ᎤᏙᏪᎸᎢ", "ᎤᎭᏁᎦᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("otisk rtů"),
            keywords: &[
                "otisk rtů",
                "polibek",
                "pusa",
                "romance",
                "romantika",
                "rty",
                "srdce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ôl cusan"),
            keywords: &["cusan", "gwefusau", "ôl cusan"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("læbeaftryk"),
            keywords: &["kys", "læbeaftryk", "læber", "romantik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kussabdruck"),
            keywords: &["Kuss", "Kussabdruck", "Lippen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σημάδι από φιλί"),
            keywords: &[
                "έρωτας",
                "καρδιά",
                "σημάδι",
                "σημάδι από φιλί",
                "φιλί",
                "χείλη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("kiss mark"),
            keywords: &["kiss", "kiss mark", "lips"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("marca de beso"),
            keywords: &["beso", "labios", "marca de beso", "romance"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("marca de beso"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suudluse jälg"),
            keywords: &["huuled", "musi", "romantika", "suudluse jälg", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("musu-aztarna"),
            keywords: &["ezpainak", "musu", "musu-aztarna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بوسه ماتیکی"),
            keywords: &[
                "بوسه",
                "بوسه ماتیکی",
                "بوسه\u{654} ماتیکی",
                "عاشقانه",
                "علامت",
                "قلب",
                "لب",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("huulipunajälki"),
            keywords: &["huulet", "huulipunajälki", "jälki", "pusu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("marka ng halik"),
            keywords: &["halik", "labi", "marka ng halik"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("muss merki"),
            keywords: &["koss", "muss", "muss merki", "varrar", "varrastift"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trace de rouge à lèvres"),
            keywords: &["baiser", "lèvres", "rouge", "trace de rouge à lèvres"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("marc póg"),
            keywords: &["beola", "marc póg", "póg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làrach pòige"),
            keywords: &["bilean", "làrach pòige", "pòg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("marca de bico"),
            keywords: &["beizos", "bico", "labios", "marca", "marca de bico"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચ\u{ac1}\u{a82}બનન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "ચ\u{ac1}\u{a82}બન",
                "ચ\u{ac1}\u{a82}બનન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "રોમા\u{a82}સ",
                "હોઠ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar sumba"),
            keywords: &["alamar sumba", "leɓuna", "sumba"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן נשיקה"),
            keywords: &["נשיקה", "סימן נשיקה", "שפתיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("च\u{941}\u{902}बन का निशान"),
            keywords: &[
                "च\u{941}\u{902}बन का चिह\u{94d}न",
                "च\u{941}\u{902}बन का निशान",
                "प\u{94d}यार",
                "हो\u{902}ठ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otisak usana"),
            keywords: &["otisak usana", "poljubac", "trag", "usne"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csóknyom"),
            keywords: &["ajkak", "csók", "csóknyom", "romantika", "szenvedély"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("համբույրի հետք"),
            keywords: &[
                "համբույր",
                "համբույրի հետք",
                "հետք",
                "շուրթեր",
                "սիրավեպ",
                "սիրտ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda ciuman"),
            keywords: &["bibir", "cium", "hati", "romantis", "tanda ciuman"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara nsusu"),
            keywords: &["akara nsusu", "egbugbereọnụ gasị", "nsusu ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kossafar"),
            keywords: &["koss", "kossafar", "rómantík", "varir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("impronta della bocca"),
            keywords: &[
                "bacio",
                "impronta della bocca",
                "labbra",
                "romanticismo",
                "segno delle labbra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("キスマーク"),
            keywords: &["ちゅっ", "キス", "キスマーク", "唇"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha ambung"),
            keywords: &["ambung", "lambe", "tandha ambung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კოცნის კვალი"),
            keywords: &[
                "გული",
                "კოცნა",
                "კოცნის კვალი",
                "ნიშანი",
                "რომანტიკა",
                "ტუჩები",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ерін"),
            keywords: &["белгі", "ерін", "жүрек", "романтика", "өбіс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("læbeaftryk"),
            keywords: &["læbeaftryk", "læber", "romantik"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}នាមថើប"),
            keywords: &["បបេរមាត\u{17cb}", "ស\u{17d2}នាមថើប"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚುಂಬನದ ಗುರುತು"),
            keywords: &["ಚುಂಬನದ ಗುರುತು", "ತುಟ\u{cbf}ಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("입술"),
            keywords: &["뽀뽀", "입술", "쪼옥", "쪽", "키스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उम\u{94d}याची ख\u{942}ण"),
            keywords: &["उमो", "उम\u{94d}याची ख\u{942}ण", "ओ\u{902}ठ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өбүү белгиси"),
            keywords: &["романтика", "эрин", "өбүү белгиси", "өп"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kussmond"),
            keywords: &["Kuss", "Kussmond", "Lëpsen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮອຍຈ\u{eb9}ບ"),
            keywords: &["ຈ\u{eb9}ບ", "ປາກ", "ຮອຍຈ\u{eb9}ບ", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bučinio žymė"),
            keywords: &["bučinio žymė", "bučinys", "lūpos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skūpsta nospiedums"),
            keywords: &[
                "lūpas",
                "lūpukrāsa",
                "nospiedums",
                "skūpsta nospiedums",
                "skūpsts",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu kihi"),
            keywords: &["kihi", "ngutu", "tohu kihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бакнеж со кармин"),
            keywords: &["бакнеж", "бакнеж со кармин", "кармин", "романтика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}ംബന മ\u{d41}ദ\u{d4d}ര"),
            keywords: &[
                "ച\u{d41}ംബന മ\u{d41}ദ\u{d4d}ര",
                "ച\u{d41}ംബനം",
                "ച\u{d41}ണ\u{d4d}ട\u{d41}കൾ",
                "റൊമ\u{d3e}ൻസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үнсэлтийн мөр"),
            keywords: &["уруул", "хайр дурлал", "ягаан", "үнсэлтийн мөр", "үнсэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("च\u{941}\u{902}बनाच\u{947} चिन\u{94d}ह"),
            keywords: &[
                "ओठ",
                "च\u{941}\u{902}बन",
                "च\u{941}\u{902}बनाच\u{947} चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda ciuman"),
            keywords: &["bibir", "cium", "tanda ciuman"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("marka ta’ bewsa"),
            keywords: &["bews", "marka ta’ bewsa", "xofftejn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အနမ\u{103a}း တ\u{1036}ဆ\u{102d}ပ\u{103a}"),
            keywords: &[
                "န\u{103e}\u{102f}တ\u{103a}ခမ\u{103a}း",
                "အနမ\u{103a}း",
                "အနမ\u{103a}း တ\u{1036}ဆ\u{102d}ပ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kyssemerke"),
            keywords: &["kyss", "kyssemerke", "lepper", "romantikk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("च\u{941}म\u{94d}बन चिन\u{94d}ह"),
            keywords: &[
                "ओठ",
                "चिन\u{94d}ह",
                "च\u{941}म\u{94d}बन",
                "मनोरन\u{94d}जन",
                "म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("lipafdruk"),
            keywords: &["kus", "lipafdruk", "lippen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kyssemerke"),
            keywords: &["kyss", "kyssemerke", "lepper", "romantikk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b41}ମ\u{b4d}ବନ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଚ\u{b41}ମ\u{b4d}ବନ । ଓଠ",
                "ଚ\u{b41}ମ\u{b4d}ବନ ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a41}\u{a70}ਮੀ ਦਾ ਨਿਸ\u{a3c}ਾਨ"),
            keywords: &[
                "ਚ\u{a41}\u{a70}ਮੀ",
                "ਚ\u{a41}\u{a70}ਮੀ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਪਿਆਰ",
                "ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چومی دا نشان"),
            keywords: &["ب\u{64f}ل", "چومنا", "چومی دا نشان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kis Mak"),
            keywords: &["Kis", "Kis Mak", "Lips", "Lọv", "Maut"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ślad po pocałunku"),
            keywords: &["odcisk ust", "pocałunek", "usta", "ślad po pocałunku"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مچو نښه"),
            keywords: &["شونډي", "مچو", "مچو نښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("marca de beijo"),
            keywords: &["beijo", "lábios", "marca de beijo", "romance"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "beijo",
                "coração",
                "lábios",
                "marca",
                "marca de beijo",
                "romance",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muchʼa unancha"),
            keywords: &["muchʼa", "muchʼa unancha", "sirpi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("urme de buze"),
            keywords: &["buze", "roșu", "sărut", "urme de buze"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-584"),
            keywords: &["E10-584"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("след от поцелуя"),
            keywords: &[
                "движение",
                "поцелуй",
                "романтика",
                "след от поцелуя",
                "чувства",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cyo gusomana"),
            keywords: &["gusoma", "ikimenyetso cyo gusomana", "iminwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چمي جو نشان"),
            keywords: &["چمي", "چمي جو نشان", "چپ\u{64e}"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dcf}ද\u{dd4} ලක\u{dd4}ණ"),
            keywords: &[
                "තොල\u{dca}",
                "හදවත",
                "හ\u{dcf}ද\u{dd4} ලක\u{dd4}ණ",
                "හ\u{dcf}ද\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("odtlačok pier"),
            keywords: &["bozk", "odtlačok pier", "pery"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sled šminke po poljubu"),
            keywords: &[
                "odtis",
                "poljub",
                "romanca",
                "sled šminke po poljubu",
                "srce",
                "ustnice",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda dhunkashada"),
            keywords: &["bishimo", "calaamadda dhunkashada", "dhunkasho"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e puthjes"),
            keywords: &["buzë", "puthje", "romancë", "shenja e puthjes"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("отисак пољупца"),
            keywords: &[
                "отисак",
                "отисак пољупца",
                "пoљубaц",
                "рoмaнтикa",
                "срцe",
                "уснe",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["отисак пољупца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("otisak poljupca"),
            keywords: &[
                "otisak",
                "otisak poljupca",
                "poljubac",
                "romantika",
                "srce",
                "usne",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["otisak poljupca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("läppavtryck"),
            keywords: &["kyssmärke", "kärlek", "läppar", "läppavtryck"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya busu"),
            keywords: &[
                "alama",
                "alama ya busu",
                "busu",
                "mapenzi",
                "midomo",
                "moyo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("முத\u{bcd}தம\u{bcd}"),
            keywords: &[
                "உதடுகள\u{bcd}",
                "க\u{bbe}தல\u{bcd}",
                "முத\u{bcd}தச\u{bcd} சின\u{bcd}னம\u{bcd}",
                "முத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముద\u{c4d}దు గుర\u{c4d}తు"),
            keywords: &["గుర\u{c4d}తు", "ముద\u{c4d}దు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нишонаи бӯса"),
            keywords: &["бӯса", "лабҳо", "нишонаи бӯса"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รอยจ\u{e39}บ"),
            keywords: &["จ\u{e39}บ", "ปาก", "รอยจ\u{e39}บ", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("posa yzy"),
            keywords: &["dodaklar", "posa", "posa yzy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻilonga loungutu"),
            keywords: &["ʻilonga loungutu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("öpücük izi"),
            keywords: &["dudaklar", "romantizm", "öpücük", "öpücük izi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆيگەن ئىز"),
            keywords: &["سۆيگەن ئىز", "سۆۈش", "لەۋ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("слід цілунку"),
            keywords: &[
                "відбиток",
                "відбиток вуст",
                "губи",
                "закоханість",
                "поцілунок",
                "серце",
                "слід цілунку",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بوسے کا نشان"),
            keywords: &["بوسہ", "بوسے کا نشان", "ہونٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bo‘sa tamg‘asi"),
            keywords: &[
                "bo‘sa",
                "bo‘sa tamg‘asi",
                "lablar",
                "romantika",
                "tamg‘a",
                "yurak",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu nụ hôn"),
            keywords: &["dấu nụ hôn", "hôn", "môi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("marku fóon"),
            keywords: &["fóon", "marku fóon", "tuñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lokuphuza"),
            keywords: &["iinyheke", "phuza", "uphawu lokuphuza"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aami Ifẹnuko"),
            keywords: &["Aami Ifẹnuko", "fẹnukonu", "ètè"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("唇印"),
            keywords: &["吻", "咀唇", "唇印"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("唇印"),
            keywords: &["吻", "咀唇", "唇印"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("唇印"),
            keywords: &["吻", "唇", "唇印", "浪漫"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("唇印"),
            keywords: &["唇印", "親親"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["唇印", "親嘴"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokuqabula"),
            keywords: &["izindebe", "ukuqabula", "uphawu lokuqabula"],
        },
    ],
};
#[doc = "💌"]
pub const LOVE_LETTER: crate::Emoji = crate::Emoji {
    glyph: "💌",
    codepoint: "1F48C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "love letter",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("liefdesbrief"),
            keywords: &["brief", "hart", "liefde", "liefdesbrief", "pos", "romanse"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፍቅር ደብዳቤ"),
            keywords: &["ልብ", "የፍቅር ደብዳቤ", "ደብዳቤ", "ፍቅር", "ፖስታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خطاب حب"),
            keywords: &["خطاب", "خطاب حب", "رسالة عليها قلب", "رومانسية", "قلب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰেম পত\u{9cd}ৰ"),
            keywords: &["পত\u{9cd}ৰ", "প\u{9cd}ৰেম", "মেইল", "হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sevgi məktubu"),
            keywords: &[
                "məktub",
                "poçt",
                "romantika",
                "sevgi",
                "sevgi məktubu",
                "ürək",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("любоўны ліст"),
            keywords: &["каханне", "любоўны ліст", "ліст", "пошта", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Любовно писмо"),
            keywords: &[
                "Любовно писмо",
                "любов",
                "любовно писмо",
                "писмо",
                "романтика",
                "сърце",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}রেমের চিঠি"),
            keywords: &[
                "চিঠি",
                "প\u{9cd}রেমের চিঠি",
                "ভ\u{9be}লব\u{9be}স\u{9be}",
                "মেল",
                "রোম\u{9be}ন\u{9cd}স",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljubavno pismo"),
            keywords: &["ljubav", "ljubavno pismo", "pismo", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("carta d’amor"),
            keywords: &["amor", "carta", "carta d’amor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎸᏉᎪᏪᎳᏅ"),
            keywords: &["ᎠᏓᎨᏳᏗ", "ᎠᏓᎸᏉᎪᏪᎳᏅ", "ᎤᎿᏫ", "ᎪᏪᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("milostný dopis"),
            keywords: &[
                "dopis",
                "láska",
                "milostný dopis",
                "pošta",
                "romance",
                "romantika",
                "srdce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llythyr caru"),
            keywords: &["calon", "cariad", "llythyr", "llythyr caru", "post"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kærlighedsbrev"),
            keywords: &["brev med hjerte", "kærestebrev", "kærlighedsbrev"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Liebesbrief"),
            keywords: &["Brief", "Herz", "Liebe", "Liebesbrief"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ερωτικό γράμμα"),
            keywords: &["έρωτας", "αγάπη", "γράμμα", "ερωτικό γράμμα", "καρδιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("love letter"),
            keywords: &["heart", "letter", "love", "mail"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("carta de amor"),
            keywords: &["amor", "carta", "carta de amor", "corazón", "correo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "carta",
                "carta de amor",
                "corazón",
                "romance",
                "sobre con corazón",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("armastuskiri"),
            keywords: &["armastus", "armastuskiri", "kiri", "romantika", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("maitasun-gutuna"),
            keywords: &["bihotz", "gutun", "maitasun", "maitasun-gutuna", "posta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نامه\u{654} عاشقانه"),
            keywords: &[
                "ایمیل",
                "عاشقانه",
                "عشق",
                "قلب",
                "نامه",
                "نامه\u{654} عاشقانه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rakkauskirje"),
            keywords: &[
                "kirje",
                "posti",
                "rakkaus",
                "rakkauskirje",
                "romantiikka",
                "sydän",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("liham ng pag-ibig"),
            keywords: &[
                "liham",
                "liham ng pag-ibig",
                "love letter",
                "pag-ibig",
                "puso",
                "sulat",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kærleiksbræv"),
            keywords: &["bræv", "kærleiksbræv", "kærleikur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("lettre d’amour"),
            keywords: &["amour", "lettre", "lettre d’amour"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["amour", "cœur", "lettre", "lettre d’amour"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("litir ghrá"),
            keywords: &["croí", "grá", "litir", "litir ghrá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("litir gaoil"),
            keywords: &["cridhe", "gaol", "litir", "litir gaoil", "post"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("carta de amor"),
            keywords: &["amor", "carta", "carta de amor", "corazón", "correo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{acd}ર\u{ac7}મ પત\u{acd}ર"),
            keywords: &[
                "દિલ",
                "દિલ સાથ\u{ac7}નો મ\u{ac7}ઇલ",
                "પત\u{acd}ર",
                "પ\u{acd}ર\u{ac7}મ પત\u{acd}ર",
                "રોમા\u{a82}સ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("wasiƙar soyayya"),
            keywords: &["mel", "soyayya", "wasiƙa", "wasiƙar soyayya", "zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכתב אהבה"),
            keywords: &["אהבה", "דואר", "לב", "מכתב", "מכתב חתום בלב", "רומנטיקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{94d}र\u{947}मपत\u{94d}र"),
            keywords: &[
                "दिल",
                "दिल क\u{947} चिह\u{94d}न वाला पत\u{94d}र",
                "पत\u{94d}र",
                "प\u{94d}यार",
                "प\u{94d}र\u{947}मपत\u{94d}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ljubavno pismo"),
            keywords: &["ljubav", "ljubavno pismo", "pismo", "pošta", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szerelmes levél"),
            keywords: &["levél", "romantika", "szerelem", "szerelmes levél", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սիրային նամակ"),
            keywords: &["նամակ", "սեր", "սիրային նամակ", "սիրավեպ", "սիրտ", "փոստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("surat cinta"),
            keywords: &["cinta", "hati", "romantis", "surat"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("leta ihụ\u{300}nanya"),
            keywords: &[
                "leta",
                "leta ihụ\u{300}nanya",
                "obi",
                "ozi",
                "ịhụ\u{300}nanya",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ástarbréf"),
            keywords: &["bréf", "bréf með hjarta", "hjarta", "rómantík", "ástarbréf"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lettera d’amore"),
            keywords: &[
                "busta con cuore",
                "cuore",
                "lettera d’amore",
                "romanticismo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ラブレター"),
            keywords: &["ハート", "ラブレター", "封筒", "恋文", "手紙"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("layang katresnan"),
            keywords: &["ati", "katresnan", "layang", "surat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სასიყვარულო წერილი"),
            keywords: &[
                "გული",
                "რომანტიკა",
                "სასიყვარულო წერილი",
                "სიყვარული",
                "ფოსტა",
                "წერილი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сүйіспеншілік хаты"),
            keywords: &["жүрек", "махаббат", "пошта", "сүйіспеншілік хаты", "хат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kærlighedsbrev"),
            keywords: &["brev med hjerte", "kærlighedsbrev"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17c6}ប\u{17bb}ត\u{17d2}រស\u{17d2}នេហា"),
            keywords: &[
                "ស\u{17c6}ប\u{17bb}ត\u{17d2}រ",
                "ស\u{17c6}ប\u{17bb}ត\u{17d2}រស\u{17d2}នេហា",
                "ស\u{17d2}នេហា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರೇಮ ಪತ\u{ccd}ರ"),
            keywords: &["ಪ\u{ccd}ರಣಯ", "ಪ\u{ccd}ರೇಮ ಪತ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("러브레터"),
            keywords: &["러브레터", "사랑 고백", "연애 편지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मोगा चिटी"),
            keywords: &["काळीज", "चिटी", "म\u{947}ल", "मोग", "मोगा चिटी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сүйүү каты"),
            keywords: &["жүрөк", "кат", "почта", "романтика", "сүйүү", "сүйүү каты"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Libesbréif"),
            keywords: &["Bréif", "Häerz", "Libesbréif", "Léift", "Post"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{ebb}ດໝາຍຮ\u{eb1}ກ"),
            keywords: &[
                "ຄວາມຮ\u{eb1}ກ",
                "ຈ\u{ebb}ດໝາຍ",
                "ຈ\u{ebb}ດໝາຍຮ\u{eb1}ກ",
                "ຫ\u{ebb}ວໃຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("meilės laiškas"),
            keywords: &["laiškas", "meilė", "meilės laiškas", "paštas", "širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mīlestības vēstule"),
            keywords: &[
                "mīlestība",
                "mīlestības vēstule",
                "pasts",
                "romantika",
                "sirds",
                "vēstule",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("reta aroha"),
            keywords: &["aroha", "manawa", "mēra", "reta"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("љубовно писмо"),
            keywords: &["писмо", "пошта", "романтика", "љубов", "љубовно писмо"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d4d}രണയ ലേഖനം"),
            keywords: &[
                "കത\u{d4d}ത\u{d4d}",
                "പ\u{d4d}രണയ ലേഖനം",
                "പ\u{d4d}രണയം",
                "പ\u{d4d}രണയലേഖനം",
                "റൊമ\u{d3e}ൻസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хайрын захиа"),
            keywords: &["дугтуй", "захиа", "хайр", "хайрын захиа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}र\u{947}म पत\u{94d}र"),
            keywords: &["पत\u{94d}र", "प\u{94d}र\u{947}म", "म\u{947}ल", "ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("surat cinta"),
            keywords: &["cinta", "hati", "mel", "percintaan", "surat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ittra ta’ mħabba"),
            keywords: &["imħabba", "ittra", "ittra ta’ mħabba", "posta", "qalb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရည\u{103a}းစား စာ"),
            keywords: &[
                "စာ",
                "စာပ\u{102d}\u{102f}\u{1037}ခြင\u{103a}း",
                "န\u{103e}လ\u{102f}\u{1036}း",
                "ရည\u{103a}းစား စာ",
                "အချစ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kjærlighesbrev"),
            keywords: &[
                "brev",
                "brev med hjerte",
                "hjerte",
                "kjærlighesbrev",
                "romantikk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}र\u{947}म पत\u{94d}र"),
            keywords: &[
                "चिठ\u{94d}ठी",
                "प\u{94d}र\u{947}म पत\u{94d}र",
                "माया",
                "म\u{941}ट\u{941}",
                "म\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("liefdesbrief"),
            keywords: &["brief", "hart", "liefde", "liefdesbrief", "post"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kjærleiksbrev"),
            keywords: &[
                "brev",
                "brev med hjarte",
                "hjarte",
                "kjærleiksbrev",
                "romantikk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b4d}ରେମ ପତ\u{b4d}ର"),
            keywords: &[
                "ଏକ ହ\u{b43}ଦୟ ଚ\u{b3f}ତ\u{b4d}ର ଥ\u{b3e}ଇ ମେଲ\u{b4d}\u{200c}",
                "ଚ\u{b3f}ଠ\u{b3f}",
                "ପ\u{b4d}ରଣୟ",
                "ପ\u{b4d}ରେମ ପତ\u{b4d}ର",
                "ହ\u{b43}ଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a4d}ਰ\u{a47}ਮ ਪ\u{a71}ਤਰ"),
            keywords: &[
                "ਖ\u{a71}ਤ",
                "ਦਿਲ",
                "ਦਿਲ ਨਾਲ ਚਿ\u{a71}ਠੀ",
                "ਪਿਆਰ",
                "ਪਿਆਰ ਦਾ ਖ\u{a71}ਤ",
                "ਪ\u{a4d}ਰ\u{a47}ਮ ਪ\u{a71}ਤਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیار دا پتر"),
            keywords: &["خط", "دل", "میل", "پریم", "پیار دا پتر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọ\u{301}v Lẹ\u{301}ta"),
            keywords: &["Hat", "Lẹ\u{301}ta", "Lọv", "Lọ\u{301}v Lẹ\u{301}ta", "Mel"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("list miłosny"),
            keywords: &[
                "list",
                "list miłosny",
                "liścik",
                "miłość",
                "serce",
                "wiadomość",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د مینې لیک"),
            keywords: &["د مینې لیک", "زړه", "لیک", "مینه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("carta de amor"),
            keywords: &[
                "carta",
                "carta de amor",
                "coração",
                "correspondência com coração",
                "romance",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "amor",
                "carta",
                "carta de amor",
                "coração",
                "correio",
                "romance",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("munay qillqa"),
            keywords: &["chaski", "munay", "qillqa", "sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("scrisoare de dragoste"),
            keywords: &[
                "dragoste",
                "inimă",
                "iubire",
                "plic",
                "scrisoare",
                "scrisoare de dragoste",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-585"),
            keywords: &["E10-585"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("любовное письмо"),
            keywords: &[
                "записка",
                "любовное письмо",
                "любовь",
                "письмо",
                "почта",
                "тайна",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibahasha y’urukundo"),
            keywords: &[
                "ibahasha y’urukundo",
                "ibaruwa",
                "meyili",
                "umutima",
                "urukundo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيار جو خط"),
            keywords: &["خط", "دل", "ميل", "پيار", "پيار جو خط"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ආදර හස\u{dd4}න"),
            keywords: &[
                "ආදර හස\u{dd4}න",
                "ආදරය",
                "තැපෑල",
                "ප\u{dca}\u{200d}රේමය",
                "ල\u{dd2}ප\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ľúbostný list"),
            keywords: &["list", "láska", "pošta", "srdce", "ľúbostný list"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ljubezensko pismo"),
            keywords: &[
                "ljubezen",
                "ljubezensko pismo",
                "pismo",
                "pošta",
                "romanca",
                "srce",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("warqad jaceyl"),
            keywords: &["boosto", "jaceyl", "wadno", "warqad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("letër dashurie"),
            keywords: &["dashuri", "letër", "letër dashurie", "romancë", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("љубавно писмо"),
            keywords: &[
                "пoштa",
                "писмo",
                "рoмaнтикa",
                "срцe",
                "љубaв",
                "љубавно писмо",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["љубавно писмо"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljubavno pismo"),
            keywords: &[
                "ljubav",
                "ljubavno pismo",
                "pismo",
                "pošta",
                "romantika",
                "srce",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ljubavno pismo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kärleksbrev"),
            keywords: &["brev", "brev med hjärta", "kärlek", "kärleksbrev"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("barua ya mapenzi"),
            keywords: &["barua", "barua ya mapenzi", "mapenzi", "moyo", "upendo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}தல\u{bcd} கடிதம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "கடிதம\u{bcd}",
                "க\u{bbe}தல\u{bcd}",
                "க\u{bbe}தல\u{bcd} தூது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}ర\u{c47}మ ల\u{c47}ఖ"),
            keywords: &["ప\u{c4d}ర\u{c47}మ", "ల\u{c47}ఖ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мактуби ошиқӣ"),
            keywords: &["дил", "мактуб", "мактуби ошиқӣ", "муҳаббат", "почта"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จดหมายร\u{e31}ก"),
            keywords: &[
                "ความร\u{e31}ก",
                "จดหมาย",
                "จดหมายร\u{e31}ก",
                "ห\u{e31}วใจ",
                "อ\u{e35}เมล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("söýgi haty"),
            keywords: &["hat", "poçta", "söýgi", "söýgi haty", "ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tohi ʻofa"),
            keywords: &["tohi ʻofa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("aşk mektubu"),
            keywords: &[
                "aşk mektubu",
                "kalp",
                "kalpli mektup",
                "mektup",
                "romantizm",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆيگۈ خېتى"),
            keywords: &["خەت", "سالامخەت", "سۆيگۈ", "سۆيگۈ خېتى", "يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("любовний лист"),
            keywords: &[
                "закохансіть",
                "кохання",
                "лист",
                "любовний лист",
                "пошта",
                "серце",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("محبت بھرا خط"),
            keywords: &["خط", "رومانس", "محبت بھرا خط", "پیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sevgi xati"),
            keywords: &["pochta", "romantika", "sevgi", "sevgi xati", "xat", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thư tình"),
            keywords: &["lá thư", "thư", "thư tình", "trái tim", "yêu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bataaxalu mbëggeel"),
            keywords: &[
                "bataaxal",
                "bataaxalu mbëggeel",
                "leetar",
                "mbëggeel",
                "xol",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ileta yothando"),
            keywords: &["ileta", "ileta yothando", "intliziyo", "iposi", "uthando"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Lẹta Ifẹ"),
            keywords: &["Lẹta Ifẹ", "lẹ\u{301}tà", "méèlì", "ìfẹ\u{301}", "ọkàn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("情信"),
            keywords: &["信", "寄信", "心", "情信", "愛情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("情信"),
            keywords: &["信", "寄信", "心", "情信", "爱情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("情书"),
            keywords: &["信", "情书", "邮件"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("情書"),
            keywords: &["情書"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("情信"),
            keywords: &["情信"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("incwadi yothando"),
            keywords: &["incwadi", "incwadi yothando", "inhliziyo", "uthando"],
        },
    ],
};
#[doc = "💘"]
pub const HEART_WITH_ARROW: crate::Emoji = crate::Emoji {
    glyph: "💘",
    codepoint: "1F498",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "heart with arrow",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hartjie met pyl"),
            keywords: &[
                "cupido",
                "hart",
                "hartjie met pyl",
                "kupido",
                "pyl",
                "romanse",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀስት የሰነጠቀው ልብ"),
            keywords: &["ልብ", "ቀስት", "ቀስት የሰነጠቀው ልብ", "የተሰነጠቀ", "ፍቅር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب وسهم"),
            keywords: &["حب", "سهم", "قلب", "قلب وسهم", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}\u{981}ড\u{9bc}ৰ সৈতে হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "ক\u{9be}\u{981}ড\u{9bc}",
                "ক\u{9be}\u{981}ড\u{9bc}ৰ সৈতে হ\u{9c3}দয\u{9bc}",
                "ক\u{9be}পিড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oxlu ürək"),
            keywords: &["amur", "ox", "oxlu ürək", "romantika", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("страла ў сэрцы"),
            keywords: &["купідон", "страла", "страла ў сэрцы", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сърце със стрела"),
            keywords: &["Сърце със стрела", "амур", "купидон", "романтика", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তীর বিদ\u{9cd}ধ হ\u{9be}র\u{9cd}ট"),
            keywords: &["কিউপিড", "তীর", "তীর বিদ\u{9cd}ধ হ\u{9be}র\u{9cd}ট"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srce probodeno strijelom"),
            keywords: &["kupid", "srce", "srce probodeno strijelom", "strijela"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor amb fletxa"),
            keywords: &["Cupido", "cor", "cor amb fletxa", "fletxa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏫ ᎦᏝᏗ ᎬᏗ"),
            keywords: &["ᎤᎿᏫ ᎦᏝᏗ ᎬᏗ", "ᎦᏝᏗ", "ᎫᏈᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdce se šípem"),
            keywords: &[
                "amor",
                "amorek",
                "láska",
                "romance",
                "romantika",
                "srdce",
                "srdce se šípem",
                "střela",
                "šíp",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon â saeth trwyddi"),
            keywords: &["calon", "calon â saeth trwyddi", "saeth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerte med pil"),
            keywords: &["amor", "følelser", "hjerte", "hjerte med pil", "kærlighed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz mit Pfeil"),
            keywords: &["Herz", "Herz mit Pfeil", "Liebe", "Pfeil"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά με βέλος"),
            keywords: &["έρωτας", "βέλος", "καρδιά", "καρδιά με βέλος", "ρομάντζο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heart with arrow"),
            keywords: &["arrow", "cupid", "heart with arrow"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón con flecha"),
            keywords: &["amor", "corazón", "corazón con flecha", "emoción", "flecha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("noolega süda"),
            keywords: &["nool", "noolega süda", "romantika", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotza geziarekin"),
            keywords: &["bihotz", "bihotza geziarekin", "gezi", "kupido"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب تیرخورده"),
            keywords: &[
                "الهه\u{654} عشق",
                "تیر",
                "عاشقانه",
                "قلب",
                "قلب تیرخورده",
                "کوپید",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sydän ja nuoli"),
            keywords: &["amor", "nuoli", "romantiikka", "sydän", "sydän ja nuoli"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pusong may palaso"),
            keywords: &[
                "arrow",
                "kupido",
                "pag-ibig",
                "puso na may palaso",
                "pusong may palaso",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pílur ígjøgnum hjarta"),
            keywords: &[
                "Amor",
                "amorina",
                "hjarta",
                "kærleikstekin",
                "pílur",
                "pílur ígjøgnum hjarta",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur et flèche"),
            keywords: &["Cupidon", "cœur", "cœur et flèche", "flèche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cupidon", "cœur", "cœur et flèche", "flèche"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí agus saighead"),
            keywords: &["croí agus saighead", "grá", "saighead"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe le saighead"),
            keywords: &["cridhe le saighead", "cupaid", "saighead"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón con frecha"),
            keywords: &["amor", "corazón", "corazón con frecha", "cupido", "frecha"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તીર સાથ\u{ac7}ન\u{ac1}\u{a82} હ\u{ac3}દય"),
            keywords: &[
                "તીર",
                "તીર સાથ\u{ac7}ન\u{ac1}\u{a82} હ\u{ac3}દય",
                "દિલ",
                "દિલ અન\u{ac7} તીર",
                "પ\u{acd}ર\u{ac7}મ",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciya tare da kibiya"),
            keywords: &["cupid", "kibiya", "zuciya tare da kibiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב עם חץ"),
            keywords: &["אהבה", "חץ", "לב", "לב עם חץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दिल और तीर"),
            keywords: &["तीर", "दिल", "दिल और तीर", "प\u{94d}यार", "भावना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srce sa strelicom"),
            keywords: &[
                "kupid",
                "romantika",
                "srce",
                "srce sa strelicom",
                "strelica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyíllal átlőtt szív"),
            keywords: &[
                "Cupido",
                "nyíl",
                "nyíllal átlőtt szív",
                "romantika",
                "szerelem",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նետահարված սիրտ"),
            keywords: &["կուպիդոն", "նետ", "նետահարված սիրտ", "սիրավեպ", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati terpanah"),
            keywords: &["asmara", "hati", "hati terpanah", "panah", "romantis"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi nwere akụ"),
            keywords: &["akụ", "mmụọ omumeihe", "obi nwere akụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjarta með ör"),
            keywords: &["hjarta", "hjarta með ör", "tilfinningar", "ást", "ör"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore con freccia"),
            keywords: &[
                "amore",
                "cuore",
                "cuore con freccia",
                "cupido",
                "emozione",
                "freccia",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハートに矢"),
            keywords: &["キューピッド", "ハート", "ハートに矢", "矢"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati katuncep panah"),
            keywords: &["ati katuncep panah", "kupid", "panah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გული ისრით"),
            keywords: &["გული", "გული ისრით", "ისარი", "კუპიდონი", "რომანტიკა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("романтика"),
            keywords: &["купидон", "көрсеткі", "романтика"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hjerte med pil"),
            keywords: &["følelser", "hjerte", "hjerte med pil", "kærlighed", "pil"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងត\u{17d2}រ\u{17bc}វគ\u{17d2}រាប\u{17cb}ព\u{17d2}រ\u{17bd}ញ"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងត\u{17d2}រ\u{17bc}វគ\u{17d2}រាប\u{17cb}ព\u{17d2}រ\u{17bd}ញ",
                "ព\u{17d2}រ\u{17bd}ញស\u{17d2}នេហ\u{17cd}",
                "ស\u{17d2}នេហ\u{17cd}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಣದೊಂದ\u{cbf}ಗ\u{cc6} ಹೃದಯ"),
            keywords: &[
                "ಬಾಣದೊಂದ\u{cbf}ಗ\u{cc6} ಹೃದಯ",
                "ಹೃದಯ",
                "ಹೃದಯ ಮತ\u{ccd}ತು ಬಾಣ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화살이 꽂힌 하트"),
            keywords: &["사랑", "큐피드", "화살이 꽂힌 하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाण आसपी काळीज"),
            keywords: &[
                "कामद\u{947}व",
                "बाण",
                "बाण आसपी काळीज",
                "बाण तोपिल\u{94d}ल\u{947}\u{902} काळीज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жебе сайылган жүрөк"),
            keywords: &["жебе", "жебе сайылган жүрөк", "жүрөк", "романтика"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Häerz mat Feil"),
            keywords: &["Cupidon", "Feil", "Häerz mat Feil"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈມ\u{eb5}ລ\u{eb9}ກສອນປ\u{eb1}ກ"),
            keywords: &[
                "ຄວາມຮ\u{eb1}ກ",
                "ລ\u{eb9}ກສອນ",
                "ຫ\u{ebb}ວໃຈ",
                "ຫ\u{ebb}ວໃຈມ\u{eb5}ລ\u{eb9}ກສອນປ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("širdelė su strėle"),
            keywords: &["bučinys", "lūpos", "širdelė su strėle"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sirds ar bultu"),
            keywords: &["bulta", "romantika", "sirds", "sirds ar bultu"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa me te pere"),
            keywords: &["kupiti", "manawa me te pere", "pere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("срце прободено со стрела"),
            keywords: &[
                "купид",
                "романтика",
                "срце",
                "срце прободено со стрела",
                "стрела",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അമ\u{d4d}പടയ\u{d3e}ളത\u{d4d}തോടൊപ\u{d4d}പമ\u{d41}ള\u{d4d}ള ഹ\u{d43}ദയം"),
            keywords: &[
                "അമ\u{d4d}പടയ\u{d3e}ളത\u{d4d}തോടൊപ\u{d4d}പമ\u{d41}ള\u{d4d}ള ഹ\u{d43}ദയം",
                "അമ\u{d4d}പ\u{d4d}",
                "പ\u{d4d}രണയം",
                "വിക\u{d3e}രം",
                "ഹ\u{d43}ദയം",
                "ഹ\u{d43}ദയവ\u{d41}ം അമ\u{d4d}പ\u{d41}ം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сумаар харвасан зүрх"),
            keywords: &["зүрх", "сум", "сумаар харвасан зүрх", "харвах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बाणासह ह\u{943}दय"),
            keywords: &["बाण", "बाणासह ह\u{943}दय", "भावना"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati ditembusi anak panah"),
            keywords: &[
                "anak panah",
                "dewa asmara",
                "hati",
                "hati ditembusi anak panah",
                "percintaan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb bi vleġġa"),
            keywords: &["kupidu", "qalb bi vleġġa", "vleġġa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြားန\u{103e}င\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "မြား",
                "မြားနတ\u{103a}မောင\u{103a}",
                "မြားန\u{103e}င\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
                "မြားန\u{103e}င\u{1037}\u{103a} အသည\u{103a}းန\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjerte med pil"),
            keywords: &["følelser", "hjerte", "hjerte med pil", "kjærlighet", "pil"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("वाण छ\u{947}डिएको म\u{941}ट\u{941}"),
            keywords: &[
                "क\u{941}पिड",
                "मनोरन\u{94d}जन",
                "म\u{941}ट\u{941}",
                "वाण",
                "वाण छ\u{947}डिएको म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hart met pijl"),
            keywords: &["cupido", "hart met pijl", "pijl"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjarte med pil"),
            keywords: &["hjarte", "hjarte med pil", "kjensler", "kjærleik", "pil"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତୀର ସହ\u{b3f}ତ ହ\u{b43}ଦୟ"),
            keywords: &[
                "ତୀର",
                "ତୀର ସହ\u{b3f}ତ ହ\u{b43}ଦୟ",
                "ପ\u{b4d}ରେମ",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ହ\u{b43}ଦୟ",
                "ହ\u{b43}ଦୟ ଏବଂ ତୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਿਲ ਵਿ\u{a71}ਚ ਲ\u{a71}ਗਿਆ ਤੀਰ"),
            keywords: &[
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਤੀਰ",
                "ਦਿਲ",
                "ਦਿਲ ਅਤ\u{a47} ਤੀਰ",
                "ਦਿਲ ਵਿ\u{a71}ਚ ਲ\u{a71}ਗਿਆ ਤੀਰ",
                "ਪਿਆਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیر نال دل"),
            keywords: &["تیر", "تیر نال دل", "کیوپڈ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé Áro Dọ\u{301}n Chuk"),
            keywords: &["Hat Wé Áro Dọ\u{301}n Chuk", "Kúpid", "Áro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("serce przebite strzałą"),
            keywords: &[
                "przebite strzałą",
                "serce przebite strzałą",
                "serce ze strzałą",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تیر وهلۍ زړه"),
            keywords: &["تیر", "تیر وهلی زړه", "تیر وهلۍ زړه", "کاپي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração com flecha"),
            keywords: &["amor", "coração", "coração com flecha", "emoção", "flecha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração com seta"),
            keywords: &["coração", "coração com seta", "cupido", "romance", "seta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqu wachʼiwan"),
            keywords: &["cupido", "sunqu wachʼiwan", "wachʼi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă săgetată"),
            keywords: &["cupidon", "inimă", "inimă săgetată", "săgeată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-597"),
            keywords: &["E10-597"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сердце, пронзенное стрелой"),
            keywords: &[
                "купидон",
                "лук",
                "любовь",
                "сердце, пронзенное стрелой",
                "стрела",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima n’akambi"),
            keywords: &["akambi", "ikigirwamana cy’urukundo", "umutima n’akambi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دل جي وچ ۾ تير"),
            keywords: &["تير، محبت جو ديوتا", "دل جي وچ ۾ تير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඊතලය සහ\u{dd2}ත හදවත"),
            keywords: &[
                "අනංගය\u{dcf}",
                "ඊතලය",
                "ඊතලය සහ\u{dd2}ත හදවත",
                "ප\u{dca}\u{200d}රේමය",
                "හදවත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("srdce so šípom"),
            keywords: &["kupido", "srdce", "srdce so šípom", "šíp"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srce s puščico"),
            keywords: &["kupid", "puščica", "romanca", "srce", "srce s puščico"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno leh fallaar"),
            keywords: &["calaamad qof qaawan", "fallaar", "wadno leh fallaar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër me shigjetë"),
            keywords: &["eros", "romancë", "shigjetë", "zemër", "zemër me shigjetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("срце прободено стрелом"),
            keywords: &[
                "купидон",
                "рoмaнтикa",
                "срцe",
                "срце прободено стрелом",
                "стрeлицa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("срце прободено стријелом"),
            keywords: &["срце прободено стријелом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srce probodeno strelom"),
            keywords: &[
                "kupidon",
                "romantika",
                "srce",
                "srce probodeno strelom",
                "strelica",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("srce probodeno strijelom"),
            keywords: &["srce probodeno strijelom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärta med pil"),
            keywords: &["hjärta", "hjärta med pil", "kärlek", "pil"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo uliopenyezwa mshale"),
            keywords: &[
                "alama ya mapenzi",
                "mapenzi",
                "moyo",
                "moyo uliopenyezwa mshale",
                "mshale",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அம\u{bcd}புக\u{bcd}குறி துளைத\u{bcd}த இதயம\u{bcd}"),
            keywords: &[
                "அம\u{bcd}புக\u{bcd}குறி துளைத\u{bcd}த இதயம\u{bcd}",
                "இதயம\u{bcd}",
                "இதயம\u{bcd} துளைக\u{bcd}கும\u{bcd} அம\u{bcd}பு",
                "க\u{bbe}தல\u{bcd}",
                "க\u{bbe}தல\u{bcd} அம\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హృదయ\u{c3e}క\u{c3e}రంల\u{c4b} బ\u{c3e}ణం"),
            keywords: &[
                "బ\u{c3e}ణం",
                "హృదయం",
                "హృదయ\u{c3e}క\u{c3e}రంల\u{c4b} బ\u{c3e}ణం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дил бо тир"),
            keywords: &["амур", "дил бо тир", "тир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ศรป\u{e31}กใจ"),
            keywords: &[
                "ความร\u{e31}ก",
                "ล\u{e39}กศร",
                "ศรป\u{e31}กใจ",
                "ห\u{e31}วใจ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("okly ýürek"),
            keywords: &["ok", "okly ýürek", "söýgi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu moe ngahau"),
            keywords: &["mafu moe ngahau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ok saplanmış kalp"),
            keywords: &["aşk", "duygu", "kalp", "ok", "ok saplanmış kalp"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوقلۇق يۈرەك"),
            keywords: &["ئوقلۇق يۈرەك", "ئوقياچى", "كۆرسەتكۈچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце, пробите стрілою"),
            keywords: &[
                "закоханість",
                "купідон",
                "серце",
                "серце, пробите стрілою",
                "стріла",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیر پیوست ہوا دل"),
            keywords: &["تیر", "تیر پیوست ہوا دل", "دل", "زخمی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yurak va kamon o‘qi"),
            keywords: &[
                "kamon o‘qi",
                "kupidon",
                "romantika",
                "yurak",
                "yurak va kamon o‘qi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim với mũi tên"),
            keywords: &["mũi tên", "thần tình yêu", "trái tim với mũi tên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol ak fett"),
            keywords: &["bëgg-xaalis", "fett", "xol ak fett"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo enotolo"),
            keywords: &["intliziyo enotolo", "u-cupid", "utolo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Ti o Ni Ọfa"),
            keywords: &["Ọkan Ti o Ni Ọfa", "ọfà", "ọmọ ọlọ\u{301}fà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("穿箭嘅心"),
            keywords: &["丘比特", "穿箭嘅心", "箭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("穿箭嘅心"),
            keywords: &["丘比特", "穿箭嘅心", "箭"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("心中箭了"),
            keywords: &["丘比特", "心中箭了", "浪漫", "爱情", "箭", "红心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("丘比特"),
            keywords: &["丘比特", "愛", "戀愛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("一箭穿心"),
            keywords: &["一箭穿心", "丘比特"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo enomcibisholo"),
            keywords: &["inhliziyo", "inhliziyo enomcibisholo", "umcibisholo"],
        },
    ],
};
#[doc = "💝"]
pub const HEART_WITH_RIBBON: crate::Emoji = crate::Emoji {
    glyph: "💝",
    codepoint: "1F49D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "heart with ribbon",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hartjie met lint"),
            keywords: &["hart", "hartjie met lint", "lint", "valentyn"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሪባን የታሰረ ልብ"),
            keywords: &["ልብ", "ሪባን", "በሪባን የታሰረ ልብ", "ቫለንታይን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}قلب عليه شريط"),
            keywords: &["شريطة", "فالنتين", "قلب", "مشاعر", "\u{202b}قلب عليه شريط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰিবনৰ সৈতে হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "ভেলেণ\u{9cd}ট\u{9be}ইন",
                "ৰিবন",
                "ৰিবনৰ সৈতে হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lentli ürək"),
            keywords: &["lent", "lentli ürək", "valentin", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэрца са стужачкай"),
            keywords: &["валянцінка", "стужка", "сэрца", "сэрца са стужачкай"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Сърце с панделка"),
            keywords: &["Сърце с панделка", "лента", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("রিবন ব\u{9be}\u{981}ধ\u{9be} হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "ফিত\u{9be}",
                "ভ\u{9cd}য\u{9be}লেন\u{9cd}ট\u{9be}ইন",
                "রিবন ব\u{9be}\u{981}ধ\u{9be} হ\u{9be}র\u{9cd}ট",
                "হ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srce s mašnicom"),
            keywords: &["mašnica", "srce", "srce s mašnicom"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor amb un llaç"),
            keywords: &["Sant Valentí", "cor", "cor amb un llaç", "llaç"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏫ ᎠᏇᏡᏍᏗ"),
            keywords: &["ᎠᏇᏡᏍᏗ", "ᎤᎾᏓᎸᏉᏙᏗ", "ᎤᎿᏫ ᎠᏇᏡᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdce s mašlí"),
            keywords: &[
                "mašle",
                "srdce",
                "srdce s mašlí",
                "stuha",
                "stužka",
                "valentýn",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon â rhuban"),
            keywords: &["calon", "calon â rhuban", "ffolant", "rhuban"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerte med bånd"),
            keywords: &["bånd", "følelser", "hjerte", "hjerte med bånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz mit Schleife"),
            keywords: &["Herz", "Herz mit Schleife", "Schleife", "Valentinstag"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά με κορδέλα"),
            keywords: &["βαλεντίνος", "καρδιά", "καρδιά με κορδέλα", "κορδέλα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heart with ribbon"),
            keywords: &["heart with ribbon", "ribbon", "valentine"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón con lazo"),
            keywords: &[
                "corazón",
                "corazón con lazo",
                "emoción",
                "lazo",
                "san valentín",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón con moño"),
            keywords: &["amor", "corazón", "corazón con moño", "emoción", "moño"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("corazón con lazo"),
            keywords: &["amor", "corazón", "corazón con lazo", "emoción", "moño"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lindiga süda"),
            keywords: &["lindiga süda", "lint", "sõbrapäev", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotza begiztarekin"),
            keywords: &["begizta", "bihotz", "bihotza begiztarekin", "valentin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب با روبان"),
            keywords: &["روبان", "قلب", "قلب با روبان", "ولنتاین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sydän ja lahjanauha"),
            keywords: &["nauha", "sydän", "sydän ja lahjanauha", "ystävänpäivä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pusong may ribbon"),
            keywords: &[
                "laso",
                "pag-ibig",
                "puso",
                "puso na may ribbon",
                "pusong may ribbon",
                "valentine",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjarta við bandi"),
            keywords: &["band", "hjarta", "hjarta við bandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur avec ruban"),
            keywords: &["Saint-Valentin", "cœur", "cœur avec ruban", "ruban"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cœur",
                "cœur avec ruban",
                "ruban",
                "saint valentin",
                "st valentin",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí le ribín"),
            keywords: &["croí", "croí le ribín"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe le ribean"),
            keywords: &["bhaileintin", "cridhe le ribean", "là nam pòg", "ribean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón cun lazo"),
            keywords: &["San Valentín", "corazón", "corazón cun lazo", "lazo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિબન સાથ\u{ac7}ન\u{ac1}\u{a82} દિલ"),
            keywords: &[
                "દિલ",
                "રિબન",
                "રિબન સાથ\u{ac7}ન\u{ac1}\u{a82} દિલ",
                "લાગણી",
                "વ\u{ac7}લ\u{ac7}ન\u{acd}ટાઇન",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciya tare da ribon"),
            keywords: &["ribon", "valentine", "zuciya tare da ribon"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב עם סרט מתנה"),
            keywords: &[
                "ולנטיין",
                "חג האהבה",
                "ט״ו באב",
                "לב",
                "לב עם סרט מתנה",
                "מתנה",
                "סרט",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रिबन वाला दिल"),
            keywords: &[
                "दिल",
                "भावना",
                "रिबन",
                "रिबन वाला दिल",
                "व\u{948}ल\u{947}\u{902}टाइन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srce s trakom"),
            keywords: &["srce", "srce s trakom", "traka", "valentinovo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szív szalaggal"),
            keywords: &[
                "ajándék",
                "szalag",
                "szív",
                "szív szalaggal",
                "valentin-nap",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ժապավենով սիրտ"),
            keywords: &["ժապավեն", "ժապավենով սիրտ", "սիրտ", "վալենտին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati berpita"),
            keywords: &["hati", "hati berpita", "pita", "valentine"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi nwere ọmarịcha eriri"),
            keywords: &["obi nwere ọmarịcha eriri", "ribọn", "valentịnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjarta með slaufu"),
            keywords: &[
                "hjarta",
                "hjarta með slaufu",
                "slaufa",
                "tilfinningar",
                "valentínusardagurinn",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore con fiocco"),
            keywords: &[
                "San Valentino",
                "cuore",
                "cuore con fiocco",
                "emozione",
                "fiocco",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハートにリボン"),
            keywords: &["ハート", "ハートにリボン", "バレンタインデー", "リボン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati ditaleni pita"),
            keywords: &["ati ditaleni pita", "pita", "valentin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გული ლენტით"),
            keywords: &["გული", "გული ლენტით", "ვალენტინობა", "ლენტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("таспалы жүрек"),
            keywords: &["валентин", "жүрек", "таспа", "таспалы жүрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hjerte med bånd"),
            keywords: &["bånd", "følelser", "hjerte", "hjerte med bånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងចងប\u{17bc}"),
            keywords: &[
                "ចងប\u{17bc}",
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងចងប\u{17bc}",
                "ស\u{17d2}រឡាញ\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಹೃದಯ"),
            keywords: &[
                "ಪ\u{ccd}ರೇಮ\u{cbf}ಗಳು",
                "ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}",
                "ರ\u{cbf}ಬ\u{ccd}ಬನ\u{ccd}\u{200c}ನೊಂದ\u{cbf}ಗ\u{cc6} ಹೃದಯ",
                "ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("리본 달린 하트"),
            keywords: &[
                "리본",
                "리본 달린 하트",
                "발렌타인 초콜렛 상자",
                "사랑",
                "선물 상자",
                "하트",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रिबीनान ग\u{941}ठलायिल\u{94d}ल\u{947}\u{902} काळीज"),
            keywords: &[
                "रिबीन",
                "रिबीनान ग\u{941}ठलायिल\u{94d}ल\u{947}\u{902} काळीज",
                "व\u{945}ल\u{947}न\u{94d}टायन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("лента байланган жүрөк"),
            keywords: &["валентин", "жүрөк", "лента", "лента байланган жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Häerz mat Putsch"),
            keywords: &["Häerz mat Putsch", "Putsch", "Valentin"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈຜ\u{eb9}ກໂບ"),
            keywords: &["ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈຜ\u{eb9}ກໂບ", "ອາລ\u{ebb}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("širdelė su kaspinu"),
            keywords: &["kaspinas", "valentino diena", "širdelė su kaspinu"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sirds ar lentīti"),
            keywords: &["Valentīndiena", "lentīte", "sirds", "sirds ar lentīti"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa mau rīpene"),
            keywords: &["manawa mau rīpene", "rīpene", "tohu aroha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("срце со панделка"),
            keywords: &[
                "ден на вљубените",
                "панделка",
                "подарок",
                "срце",
                "срце со панделка",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("റിബൺ ച\u{d41}റ\u{d4d}റിയ ഹ\u{d43}ദയം"),
            keywords: &[
                "റിബൺ",
                "റിബൺ ച\u{d41}റ\u{d4d}റിയ ഹ\u{d43}ദയം",
                "വ\u{d3e}ലന\u{d4d}റൈൻ",
                "വിക\u{d3e}രം",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("туузтай зүрх"),
            keywords: &["зүрх", "тууз", "туузтай зүрх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रिबन असल\u{947}ल\u{947} ह\u{943}दय"),
            keywords: &[
                "रिबन",
                "रिबन असल\u{947}ल\u{947} ह\u{943}दय",
                "व\u{94d}ह\u{945}ल\u{947}\u{902}टाईन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati dengan reben"),
            keywords: &["hati", "hati dengan reben", "reben", "valentine"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb b’ċoff"),
            keywords: &["qalb b’ċoff", "valentinu", "żigarella"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဖ\u{1032}ကြ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "ဖ\u{1032}ကြ\u{102d}\u{102f}း",
                "ဖ\u{1032}ကြ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
                "ဖ\u{1032}ကြ\u{102d}\u{102f}းန\u{103e}င\u{1037}\u{103a} အသည\u{103a}းန\u{103e}လ\u{102f}\u{1036}း",
                "ဗယ\u{103a}လင\u{103a}တ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjerte med bånd"),
            keywords: &["bånd", "følelser", "hjerte", "hjerte med bånd", "valentine"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिबनल\u{947} ब\u{947}रिएको म\u{941}ट\u{941}"),
            keywords: &[
                "भ\u{94d}याल\u{947}न\u{94d}टाइन",
                "म\u{941}ट\u{941}",
                "रिबन",
                "रिबनल\u{947} ब\u{947}रिएको म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hart met strik"),
            keywords: &["hart met strik", "strik", "valentijn"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjarte med band"),
            keywords: &["band", "hjarte", "hjarte med band", "kjensler", "valentine"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ର\u{b3f}ବନ\u{b4d}\u{200c} ସହ\u{b3f}ତ ହ\u{b43}ଦୟ"),
            keywords: &[
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ଭ\u{b3e}ଲେଣ\u{b4d}ଟ\u{b3e}ଇନ\u{b4d}\u{200c}",
                "ର\u{b3f}ବନ\u{b4d}\u{200c}",
                "ର\u{b3f}ବନ\u{b4d}\u{200c} ଯ\u{b41}କ\u{b4d}ତ ହ\u{b43}ଦୟ",
                "ର\u{b3f}ବନ\u{b4d}\u{200c} ସହ\u{b3f}ତ ହ\u{b43}ଦୟ",
                "ହ\u{b43}ଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਿਬਨ ਨਾਲ ਦਿਲ"),
            keywords: &[
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਦਿਲ",
                "ਰਿਬਨ",
                "ਰਿਬਨ ਨਾਲ ਦਿਲ",
                "ਵ\u{a48}ਲ\u{a47}ਨਟਾਈਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیتے نال دل"),
            keywords: &["فیتہ", "فیتے نال دل", "ویلنٹائن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé Dẹm Taí Ríbọn"),
            keywords: &["Hat Wé Dẹm Taí Ríbọn", "Ríbọn", "Valẹ\u{301}ntaín Dè"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("serce ze wstążką"),
            keywords: &["serce", "serce ze wstążką", "walentynki", "wstążka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تړلۍ زړه"),
            keywords: &["تړلۍ", "تړلۍ زړه", "عاشقانو ورځ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração com fita"),
            keywords: &[
                "coração",
                "coração com fita",
                "dia dos namorados",
                "emoção",
                "fita",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "coração",
                "coração com fita",
                "coração com laço",
                "fita",
                "romance",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqu cintawan"),
            keywords: &["cinta", "sunqu cintawan", "valentin"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă cu fundiță"),
            keywords: &["cadou", "inimă", "inimă cu fundiță", "panglică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-602"),
            keywords: &["E10-602"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сердце с лентой"),
            keywords: &[
                "валентин",
                "лента",
                "перевязано",
                "сердце",
                "сердце с лентой",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima uriho riba"),
            keywords: &["riba", "umutima uriho riba", "valentine"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ربن سان گڏ دل"),
            keywords: &["ربن", "ربن سان گڏ دل", "ويلنٽائن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd3}ත\u{dca}ත පට\u{dd2}යක\u{dca} සහ\u{dd2}ත හදවත"),
            keywords: &[
                "ප\u{dd3}ත\u{dca}ත පට\u{dd2}ය",
                "ප\u{dd3}ත\u{dca}ත පට\u{dd2}යක\u{dca} සහ\u{dd2}ත හදවත",
                "වැලන\u{dca}ටය\u{dd2}න\u{dca}",
                "හදවත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("srdce so stuhou"),
            keywords: &["srdce", "srdce so stuhou", "stuha", "valentín"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("srce s pentljo"),
            keywords: &["pentlja", "srce", "srce s pentljo", "valentin"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno mara lagu xiray"),
            keywords: &[
                "maalinta Valentine",
                "wadno lagu xiray maro",
                "wadno mara lagu xiray",
                "xabo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër me fjongo"),
            keywords: &["e dashur", "fjongo", "i dashur", "zemër", "zemër me fjongo"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("срце са машницом"),
            keywords: &["дан заљубљених", "срцe", "срце са машницом", "трaкa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["срце са машницом"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srce sa mašnicom"),
            keywords: &["dan zaljubljenih", "srce", "srce sa mašnicom", "traka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["srce sa mašnicom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärta med rosett"),
            keywords: &["alla hjärtans dag", "hjärta", "hjärta med rosett", "rosett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo uliofungwa kwa utepe"),
            keywords: &["moyo", "moyo uliofungwa kwa utepe", "utepe", "valentine"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ரிப\u{bcd}பன\u{bcd} கட\u{bcd}டிய இதயம\u{bcd}"),
            keywords: &[
                "இதயத\u{bcd}தைத\u{bcd} தருதல\u{bcd}",
                "க\u{bbe}தலர\u{bcd}",
                "க\u{bbe}தல\u{bcd}",
                "க\u{bbe}தல\u{bcd} பரிசு",
                "ரிப\u{bcd}பன\u{bcd}",
                "ரிப\u{bcd}பன\u{bcd} கட\u{bcd}டிய இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c3f}బ\u{c4d}బన\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న హృదయం"),
            keywords: &[
                "ర\u{c3f}బ\u{c4d}బన\u{c4d}",
                "ర\u{c3f}బ\u{c4d}బన\u{c4d}\u{200c}త\u{c4b} ఉన\u{c4d}న హృదయం",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дил бо лента"),
            keywords: &["валентин", "дил бо лента", "лента"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจผ\u{e39}กร\u{e34}บบ\u{e34}\u{e49}น"),
            keywords: &[
                "วาเลนไทน\u{e4c}",
                "ห\u{e31}วใจ",
                "ห\u{e31}วใจผ\u{e39}กร\u{e34}บบ\u{e34}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lentaly ýürek"),
            keywords: &["lenta", "lentaly ýürek", "walentin"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu moe lipine"),
            keywords: &["mafu moe lipine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kurdeleli kalp"),
            keywords: &[
                "duygu",
                "kalp",
                "kurdele",
                "kurdeleli kalp",
                "sevgililer günü",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("باغلاق يۈرەك"),
            keywords: &["باغلاق يۈرەك", "تاسما", "يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце зі стрічкою"),
            keywords: &["валентин", "серце", "серце зі стрічкою", "стрічка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ربن باندھے دل"),
            keywords: &["دل", "ربن", "ربن باندھے دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yurak va lenta"),
            keywords: &["lenta", "yurak", "yurak va lenta"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim với ruy băng"),
            keywords: &[
                "lễ tình yêu",
                "ruy băng",
                "trái tim",
                "trái tim với ruy băng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol buñ laxas ribaŋ"),
            keywords: &["Walantin", "ribbon", "xol buñ laxas ribaŋ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo eneribhoni"),
            keywords: &["i-valentine", "intliziyo eneribhoni", "iribhoni"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Pẹlu Riboni"),
            keywords: &[
                "ríbọ\u{301}nì àyájọ\u{301} olólùfẹ\u{300}",
                "Ọkan Pẹlu Riboni",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("有蝴蝶結嘅心"),
            keywords: &["情人", "有蝴蝶結嘅心", "蝴蝶結"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("有蝴蝶结嘅心"),
            keywords: &["情人", "有蝴蝶结嘅心", "蝴蝶结"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("系有缎带的心"),
            keywords: &["爱的礼物", "系有缎带的心", "送你一颗心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("愛的禮物"),
            keywords: &["愛的禮物", "送你一顆心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo eneribhini"),
            keywords: &["inhliziyo", "inhliziyo eneribhini", "iribhini", "uthando"],
        },
    ],
};
#[doc = "💖"]
pub const SPARKLING_HEART: crate::Emoji = crate::Emoji {
    glyph: "💖",
    codepoint: "1F496",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sparkling heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sprankelende hartjie"),
            keywords: &["hart", "opgewonde", "skitter", "sprankelende hartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አንጸባራቂ ልብ"),
            keywords: &["ልብ", "አንጸባራቂ", "የጓጓ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب لامع"),
            keywords: &["إثارة", "حب", "قلب لامع", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঝিলমিলোৱ\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "উৎস\u{9be}হিত",
                "ঝিলমিল",
                "ঝিলমিলোৱ\u{9be} হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qığılcımlı ürək"),
            keywords: &["həyəcanlı", "qığılcım", "qığılcımlı ürək", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бліскучае сэрца"),
            keywords: &[
                "бляск",
                "бліскучае сэрца",
                "захапленне",
                "зіхаценне",
                "сэрца",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Блестящо сърце"),
            keywords: &["Блестящо сърце", "искра", "развълнуван", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জ\u{9cd}বলজ\u{9cd}বলে হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "উত\u{9cd}তেজিত",
                "জ\u{9cd}বলজ\u{9cd}বলে হ\u{9be}র\u{9cd}ট",
                "ঝকমক কর\u{9be}",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("svjetlucavo srce"),
            keywords: &["iskra", "srce", "svjetlucavo srce", "uzbuđenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor espurnejant"),
            keywords: &["cor", "cor espurnejant", "espurneig"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᎷᎩᏍᎩ ᎠᏓᏅᏙ"),
            keywords: &["ᎠᏔᎷᎩᎠ", "ᎠᏔᎷᎩᏍᎩ ᎠᏓᏅᏙ", "ᎤᎳᎾᎩᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jiskřící srdce"),
            keywords: &["jiskra", "jiskřící srdce", "srdce", "vzrušení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon yn disgleirio"),
            keywords: &["calon", "calon yn disgleirio", "cynhyrfu", "disgleirio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerte med stjerner"),
            keywords: &["funkle", "følelser", "hjerte med stjerner", "kærlighed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("funkelndes Herz"),
            keywords: &["Aufregung", "Liebe", "funkelndes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά που αστράφτει"),
            keywords: &[
                "αστράφτω",
                "ενθουσιασμένος",
                "καρδιά",
                "καρδιά που αστράφτει",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sparkling heart"),
            keywords: &["excited", "sparkle", "sparkling heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón brillante"),
            keywords: &["amor", "brillante", "corazón brillante", "emoción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón brillante"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sädelev süda"),
            keywords: &["elevil", "sädelev süda", "sära", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz distiratsua"),
            keywords: &["bihotz", "bihotz distiratsua", "distira", "urduri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب درخشان"),
            keywords: &["درخشش", "قلب", "قلب درخشان", "هیجان\u{200c}زده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kimaltava sydän"),
            keywords: &["innostunut", "kimalle", "kimaltava sydän", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kumikinang na puso"),
            keywords: &["kumikinang", "kumikinang na puso", "nasasabik", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("glitrandi hjarta"),
            keywords: &["glampandi", "glitrandi", "glógvandi", "hjarta", "ljómandi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur étincelant"),
            keywords: &["cœur", "cœur étincelant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "enthousiaste", "étincelant"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí ag lonrú"),
            keywords: &["croí", "croí ag lonrú", "grá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe lainnireach"),
            keywords: &["air bhioran", "cridhe lainnireach", "lainnir"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón escintilante"),
            keywords: &["amor", "corazón", "corazón escintilante", "escintilar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચળકત\u{ac1}\u{a82} દિલ"),
            keywords: &[
                "ચળકત\u{ac1}\u{a82}",
                "ચળકત\u{ac1}\u{a82} દિલ",
                "પ\u{acd}ર\u{ac7}મ",
                "રોમા\u{a82}ચિત",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciya mai ƙyalƙyali"),
            keywords: &["mai ƙyalƙyali", "tsima", "zuciya mai ƙyalƙyali"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב מנצנץ"),
            keywords: &["אהבה", "לב", "מנצנץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रोमा\u{902}चित दिल"),
            keywords: &[
                "चमकदार दिल",
                "चमकना",
                "प\u{94d}यार",
                "भावना",
                "रोमा\u{902}चित",
                "रोमा\u{902}चित दिल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("svjetlucavo srce"),
            keywords: &["iskre", "srce", "svjetlucavo srce", "uzbuđenost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ragyogó szív"),
            keywords: &["izgatott", "ragyogás", "ragyogó szív", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շողշողացող սիրտ"),
            keywords: &["կայծ", "շողշողացող սիրտ", "ոգևորված", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati bersinar"),
            keywords: &["bahagia", "bersinar", "hati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi mmuke"),
            keywords: &["mmuke", "nwere aṅụrị", "obi mmuke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("glitrandi hjarta"),
            keywords: &[
                "glitrandi",
                "glitrandi hjarta",
                "tilfinningar",
                "ást",
                "æsingur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore che luccica"),
            keywords: &[
                "amore",
                "cuore che luccica",
                "emozionato",
                "emozione",
                "luccichio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("きらきらハート"),
            keywords: &["きらきら", "きらきらハート", "ハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati kinclong-kinclong"),
            keywords: &["ati kinclong-kinclong", "bungah", "kinclong-kinclong"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მბრწყინავი გული"),
            keywords: &["აღელვებული", "ბრწყინვა", "გული", "მბრწყინავი გული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жылтыраған жүрек"),
            keywords: &[
                "жылтырау",
                "жылтыраған жүрек",
                "жүрек",
                "көңіл-күйі көтеріңкі",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hjerte med stjerner"),
            keywords: &["følelser", "gnister", "hjerte med stjerner", "kærlighed"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ចចែងចា\u{17c6}ង"),
            keywords: &[
                "ចែងចា\u{17c6}ង",
                "បេដ\u{17bc}ង",
                "បេះដ\u{17bc}ចចែងចា\u{17c6}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ಣುಗುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯ"),
            keywords: &[
                "ಮ\u{cbf}ಣುಗುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯ",
                "ಹರ\u{ccd}ಷ",
                "ಹೊಳ\u{cc6}ಯುವ ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빛나는 하트"),
            keywords: &[
                "기쁨으로 가득찬 마음",
                "두근거림",
                "빛나는 하트",
                "사랑",
                "사랑의 기쁨",
                "설렘",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चकचकपी काळीज"),
            keywords: &["उत\u{94d}त\u{947}जीत", "चकचकपी", "चकचकपी काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жылтылдаган жүрөк"),
            keywords: &["жылтылда", "жылтылдаган жүрөк", "жүрөк", "толкунданган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("glënnerend Häerz"),
            keywords: &["glënneren", "glënnerend Häerz", "opgereegt"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈເປ\u{eb1}\u{ec8}ງປະກາຍ"),
            keywords: &[
                "ຕ\u{eb7}\u{ec8}ນເຕ\u{eb1}\u{ec9}ນ",
                "ຫ\u{ebb}ວໃຈ",
                "ຫ\u{ebb}ວໃຈເປ\u{eb1}\u{ec8}ງປະກາຍ",
                "ຮ\u{eb1}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žėrinti širdelė"),
            keywords: &["susijaudinimas", "žėrinti širdelė", "žėrėti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mirdzoša sirds"),
            keywords: &["mirdzoša sirds", "mirdzēt", "sirds", "spīdēt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa tīaho"),
            keywords: &["hiamo", "manawa tīaho", "tīaho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("светкаво срце"),
            keywords: &["возбуда", "светкаво срце", "светки", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം"),
            keywords: &[
                "അത\u{d4d}ഭ\u{d41}തം",
                "ആവേശം",
                "ആശ\u{d4d}ചര\u{d4d}യം",
                "തിളക\u{d4d}കം",
                "തിളങ\u{d4d}ങ\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം",
                "പ\u{d4d}രണയം",
                "വിക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гялалзаж байгаа зүрх"),
            keywords: &["гялалзаж байгаа зүрх", "гялалзах", "дурлал", "зүрх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उत\u{94d}स\u{941}क ह\u{943}दय"),
            keywords: &[
                "उत\u{94d}स\u{941}क",
                "उत\u{94d}स\u{941}क ह\u{943}दय",
                "चमकणार\u{947} ह\u{943}दय",
                "चमकण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati berkilauan"),
            keywords: &["berkilau", "hati", "hati berkilauan", "teruja"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb tfexfex"),
            keywords: &["eċċitat", "qalb tfexfex", "tfexfex"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရောင\u{103a}လက\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "စ\u{102d}တ\u{103a}လ\u{103e}\u{102f}ပ\u{103a}ရ\u{103e}ား",
                "အရောင\u{103a}လက\u{103a} တောက\u{103a}ပ",
                "အရောင\u{103a}လက\u{103a} တောက\u{103a}ပနေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား",
                "အရောင\u{103a}လက\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skinnende hjerte"),
            keywords: &["følelser", "kjærlighet", "skinnende", "skinnende hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चमकदार म\u{941}ट\u{941}"),
            keywords: &["उत\u{94d}साहित", "चमकदार", "म\u{941}ट\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fonkelend hart"),
            keywords: &["fonkelend", "fonkelend hart", "spannend"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skinande hjarte"),
            keywords: &["kjensler", "kjærleik", "skinande", "skinande hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚମକ\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ"),
            keywords: &[
                "ଚମକ\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ",
                "ଚମତ\u{b4d}କ\u{b3e}ର",
                "ଝଟକ\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ",
                "ପ\u{b4d}ରେମ",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ରୋମ\u{b3e}ଞ\u{b4d}ଚ\u{b3f}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਮਕਦਾ ਦਿਲ"),
            keywords: &[
                "ਉਤਸ\u{a3c}ਾਹਿਤ",
                "ਚਮਕਦਾ",
                "ਚਮਕਦਾ ਦਿਲ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਪਿਆਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("عشق دا اظہار کردا دل"),
            keywords: &["جذباتی ہونا", "جگ مگ کرنا", "عشق دا اظہار کردا دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé De Shaín Brait Wẹ\u{301}l Wẹl"),
            keywords: &[
                "Hapí Wẹ\u{301}l Wẹl",
                "Hat Wé De Shaín Brait Wẹ\u{301}l Wẹl",
                "Hat Wé De Shaín Wẹ\u{301}l Wẹl Wit Smọ\u{301}l Smọ\u{301}l Braít Lait",
                "Shaín Wẹ\u{301}l Wẹl Wit Smál Smọ\u{301}l Braít Lait",
                "Spákul",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("migoczące serce"),
            keywords: &["błyszczące serce", "migoczące serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ځلاداره زړه"),
            keywords: &["زړه پوری", "ځلاداره", "ځلاداره زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração brilhante"),
            keywords: &[
                "amor",
                "brilhante",
                "coração brilhante",
                "emocionante",
                "emoção",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração cintilante"),
            keywords: &["cintilante", "coração", "coração a brilhar", "entusiasmado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kʼanchasqa sunqu"),
            keywords: &["kusisqa", "kʼanchasqa", "kʼanchasqa sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă strălucitoare"),
            keywords: &[
                "entuziasm",
                "fericire",
                "inimă",
                "inimă strălucitoare",
                "strălucire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-595"),
            keywords: &["E10-595"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сверкающее сердце"),
            keywords: &[
                "блеск",
                "звездочки",
                "радость",
                "сверкающее сердце",
                "сердце",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima ubengerana"),
            keywords: &["bishimye", "ibishashi", "umutima ubengerana"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽمڪندڙ دل"),
            keywords: &["ٽمڪندڙ دل", "ٽمڪڻ", "پرجوش"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ද\u{dd4}ලන හදවත"),
            keywords: &[
                "ද\u{dd2}ද\u{dd4}ලන",
                "ප\u{dca}\u{200d}රබෝදමත\u{dca}",
                "හදවත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ligotavé srdce"),
            keywords: &[
                "ligotanie",
                "ligotavé srdce",
                "radosť",
                "srdce",
                "trblietanie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lesketajoče srce"),
            keywords: &["lesketajoče srce", "lesketati se", "srce", "vznemirjeno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno dhalaalaayo"),
            keywords: &["dhalaal", "farxad", "wadno dhalaalaayo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër që shkëlqen"),
            keywords: &["i emocionuar", "shkëlqej", "zemër", "zemër që shkëlqen"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("блиставо срце"),
            keywords: &["блиставо срце", "искрe", "срцe", "узбуђeнoст"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["блиставо срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("blistavo srce"),
            keywords: &["blistavo srce", "iskre", "srce", "uzbuđenost"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["blistavo srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gnistrande hjärta"),
            keywords: &["gnistrande hjärta", "känslor", "kärlek", "upprymd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo unaong’aa"),
            keywords: &["furahia", "metameta", "moyo", "moyo unaong’aa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜொலிக\u{bcd}கும\u{bcd} இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "க\u{bbe}தல\u{bcd}",
                "ஜொலிக\u{bcd}கும\u{bcd} இதயம\u{bcd}",
                "படபடக\u{bcd}கும\u{bcd} இதயம\u{bcd}",
                "பரவசம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}రుస\u{c4d}తున\u{c4d}న హృదయం"),
            keywords: &[
                "మ\u{c46}రుపు",
                "మ\u{c46}రుస\u{c4d}తున\u{c4d}న హృదయం",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили ҷилодор"),
            keywords: &["дили ҷилодор", "ҳаяҷон", "ҷило додан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจว\u{e34}บว\u{e31}บ"),
            keywords: &[
                "ต\u{e37}\u{e48}นเต\u{e49}น",
                "ร\u{e31}ก",
                "ห\u{e31}วใจ",
                "ห\u{e31}วใจว\u{e34}บว\u{e31}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lowurdaýan ýürek"),
            keywords: &["lowurdaýan ýürek", "tolgunan", "uçgun"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu ngingila"),
            keywords: &["mafu ngingila"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pırıldayan kalp"),
            keywords: &["duygu", "heyecanlı", "kalp", "pırıldayan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاقنىغان يۈرەك"),
            keywords: &["يالقۇن", "چاقنىغان يۈرەك", "ھاياجان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце, що виблискує"),
            keywords: &["захоплення", "серце", "серце, що виблискує", "сяйво"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چمکتا دل"),
            keywords: &["دل", "پر جوش", "چمکتا دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqnayotgan yurak"),
            keywords: &["chaqnash", "chaqnayotgan yurak", "hayajonli", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim lấp lánh"),
            keywords: &["bị kích thích", "lấp lánh", "trái tim lấp lánh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu yànj"),
            keywords: &["eksite", "tàkk", "xol bu yànj"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo ekhazimlayo"),
            keywords: &["imincili", "intliziyo ekhazimlayo", "khazimla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Didan"),
            keywords: &["dunú", "dán", "Ọkan Didan"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("閃嘅心"),
            keywords: &["興奮", "閃", "閃嘅心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("闪嘅心"),
            keywords: &["兴奋", "闪", "闪嘅心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("闪亮的心"),
            keywords: &["激动", "红心", "闪亮", "闪亮的心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("開心"),
            keywords: &["放閃", "開心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ekhazimulayo"),
            keywords: &[
                "inhliziyo",
                "inhliziyo ekhazimulayo",
                "intokozo",
                "ukukhazimula",
            ],
        },
    ],
};
#[doc = "💗"]
pub const GROWING_HEART: crate::Emoji = crate::Emoji {
    glyph: "💗",
    codepoint: "1F497",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "growing heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groeiende hartjie"),
            keywords: &[
                "groei",
                "groeiende hartjie",
                "hart",
                "hartklop",
                "opgewonde",
                "senuweeagtig",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እያደገ የሚሄድ ልብ"),
            keywords: &["እያደገ የሚሄድ ልብ", "የልብ ምት", "የሚያድግ", "የጓጓ", "የፈራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب ينمو"),
            keywords: &["إثارة", "توتر", "حب", "قلب", "قلب ينمو", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিকশিত হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "উৎস\u{9be}হিত",
                "ন\u{9be}ড\u{9bc}ি",
                "বিকশিত হ\u{9c3}দয\u{9bc}",
                "বৰ\u{9cd}দ\u{9cd}ধম\u{9be}ন",
                "স\u{9cd}ন\u{9be}য\u{9bc}বিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böyüyıb ürək"),
            keywords: &[
                "böyümək",
                "böyüyıb ürək",
                "həyəcanlı",
                "nervous",
                "ürək",
                "ürək döyüntüsü",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэрца, якое павялічваецца"),
            keywords: &[
                "біццё",
                "захапленне",
                "сэрца",
                "сэрца, якое павялічваецца",
                "хваляванне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Увеличаващо се сърце"),
            keywords: &[
                "Увеличаващо се сърце",
                "нервен",
                "пулс",
                "развълнуван",
                "сърце",
                "туптящо сърце",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বর\u{9cd}ধনশীল হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "উত\u{9cd}তেজিত",
                "ক\u{9cd}রমবর\u{9cd}ধম\u{9be}ন",
                "বর\u{9cd}ধনশীল হ\u{9be}র\u{9cd}ট",
                "স\u{9cd}ন\u{9be}য\u{9bc}\u{9c1}বৈকল\u{9cd}য",
                "হ\u{9c3}দয\u{9bc}",
                "হ\u{9c3}দয\u{9bc} ধ\u{9cd}বনি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uvećano srce"),
            keywords: &["nervoza", "puls", "raste", "uvećano srce", "uzbuđenje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor que creix"),
            keywords: &[
                "batec",
                "cor",
                "cor que creix",
                "creixent",
                "emocionada",
                "emocionat",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏌᎳᏗᎲᎢ ᎤᎿᏫ"),
            keywords: &["ᎠᎵᏌᎳᏗᎲᎢ ᎤᎿᏫ", "ᎠᏓᎿᏫᏍᎬ", "ᎠᏛᏍᎬᎢ", "ᎤᎳᎾᎩᏍᎬ", "ᎤᏓᏅᏖᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rostoucí srdce"),
            keywords: &["nervozita", "puls", "rostoucí", "srdce", "vzrušení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon yn tyfu"),
            keywords: &["calon", "calon yn tyfu", "cynhyrfu", "nerfus", "tyfu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("voksende hjerte"),
            keywords: &[
                "følelser",
                "hjerte",
                "kærlighed",
                "nervøs",
                "voksende hjerte",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("wachsendes Herz"),
            keywords: &["Aufregung", "Liebe", "Nervosität", "wachsendes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά που μεγαλώνει"),
            keywords: &[
                "αυξανόμενος",
                "ενθουσιασμένος",
                "καρδιά",
                "καρδιά που μεγαλώνει",
                "νευρικός",
                "παλμός καρδιάς",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("growing heart"),
            keywords: &["excited", "growing", "growing heart", "nervous", "pulse"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón creciente"),
            keywords: &["corazón", "creciente", "emocionado", "latido", "nervioso"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón que crece"),
            keywords: &[
                "amor",
                "corazón",
                "corazón que crece",
                "emoción",
                "entusiasmado",
                "nervioso",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("corazón creciente"),
            keywords: &[
                "amor",
                "corazón",
                "corazón creciente",
                "emoción",
                "entusiasmado",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kasvav süda"),
            keywords: &["kasvav", "närviline", "pulss", "põnev", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("handitzen ari den bihotza"),
            keywords: &[
                "bihotz",
                "handitu",
                "handitzen ari den bihotza",
                "taupada",
                "urduri",
                "urduritasun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب هیجان\u{200c}زده"),
            keywords: &["تپش", "عصبی", "قلب", "هیجان\u{200c}زده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvava sydän"),
            keywords: &[
                "hermostunut",
                "innostunut",
                "kasvava",
                "sydämen syke",
                "sydän",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lumalaking puso"),
            keywords: &[
                "kinakabahan",
                "lumalaking puso",
                "nasasabik",
                "puso",
                "tumitibok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("glógvandi hjarta"),
            keywords: &["glógvandi", "hjarta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur grandissant"),
            keywords: &["cœur", "cœur grandissant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "grandissant", "nerveux", "pouls", "pulsations"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí ag fás"),
            keywords: &["croí", "croí ag fás", "grá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe a’ fàs"),
            keywords: &[
                "air bhioran",
                "cridhe a’ fàs",
                "cuisle",
                "cuisleachadh",
                "cuislich",
                "fàs",
                "iomagaineach",
                "nearbhasach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón crecendo"),
            keywords: &[
                "amor",
                "corazón",
                "corazón crecendo",
                "emoción",
                "entusiasmo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વધત\u{ac1}\u{a82} દિલ"),
            keywords: &[
                "દિલ",
                "પ\u{acd}ર\u{ac7}મ",
                "મ\u{ac2}\u{a82}ઝાય\u{ac7}લ\u{ac1}\u{a82}",
                "રોમા\u{a82}ચિત",
                "લાગણી",
                "વધત\u{ac1}\u{a82} દિલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciya mai bunƙasawa"),
            keywords: &[
                "bugun jini",
                "juyayi",
                "mai bunƙasawa",
                "tsima",
                "zuciya mai bunƙasawa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב גדל"),
            keywords: &["גדל", "לב", "מתרגש", "מתרחב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बढ\u{93c}ता ह\u{941}आ दिल"),
            keywords: &[
                "घबराया",
                "दिल",
                "प\u{94d}यार",
                "बढ\u{93c}ता ह\u{941}आ दिल",
                "भावना",
                "रोमा\u{902}चित",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srce koje raste"),
            keywords: &[
                "nervoza",
                "pulsiranje",
                "srce",
                "srce koje raste",
                "uzbuđenost",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("növekvő szív"),
            keywords: &[
                "idegesség",
                "izgalom",
                "növekvő szív",
                "szív",
                "szívdobogás",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աճող սիրտ"),
            keywords: &["աճող", "նյարդային", "ոգևորված", "սիրտ", "սրտի զարկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati membesar"),
            keywords: &[
                "deg",
                "detak",
                "gembira",
                "gugup",
                "hati",
                "hati membesar",
                "jantung",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-eto eto"),
            keywords: &[
                "akwara",
                "na-eto eto",
                "nkụ obi",
                "nwere aṅụrị",
                "obi na-eto eto",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stækkandi hjarta"),
            keywords: &["púls", "spenna", "stækkandi hjarta", "taugaspenna", "ást"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore che cresce"),
            keywords: &[
                "amore",
                "cuore",
                "cuore che cresce",
                "emozionato",
                "nervoso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("大きくなるハート"),
            keywords: &["ときめき", "ドキドキ", "ハート", "大きくなるハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati nggembung"),
            keywords: &["ati nggembung", "bungah", "ewuh", "mak ser", "nggembung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზარდი გული"),
            keywords: &["აღელვებული", "გული", "გულის პულსი", "მზარდი", "ნერვიული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("үлкейетін жүрек"),
            keywords: &[
                "жүрек соғысы",
                "күйінгіш",
                "көңіл-күйі көтеріңкі",
                "үлкейетін жүрек",
                "өсу",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("voksende hjerte"),
            keywords: &[
                "følelser",
                "hjerte",
                "kærlighed",
                "nervøs",
                "voksende hjerte",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងរ\u{17b8}កធ\u{17c6}ធាត\u{17cb}"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងរ\u{17b8}កធ\u{17c6}ធាត\u{17cb}",
                "បេះដ\u{17bc}ងលោតញាប\u{17cb}",
                "រ\u{17c6}ភើប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಳ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯ"),
            keywords: &[
                "ಬ\u{cc6}ಳ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯ",
                "ಮಾನಸ\u{cbf}ಕ ಒತ\u{ccd}ತಡ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("커지는 하트"),
            keywords: &[
                "깊어지는 마음",
                "깊어지는 사랑",
                "사랑",
                "커지는 마음",
                "커지는 하트",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाडपी काळीज"),
            keywords: &[
                "उत\u{94d}त\u{947}जीत",
                "गो\u{902}दळिल\u{94d}ल\u{947}\u{902}",
                "ठोक\u{947}",
                "वाडपी",
                "वाडपी काळीज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чоңоюп жаткан жүрөк"),
            keywords: &[
                "жүрөк",
                "жүрөк пульсу",
                "толкунданган",
                "чоңой",
                "чоңоюп жаткан жүрөк",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wuessend Häerz"),
            keywords: &[
                "Schlag",
                "nervös",
                "opgereegt",
                "wuessend",
                "wuessend Häerz",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈກຳລ\u{eb1}ງເຕ\u{eb5}ບໂຕ"),
            keywords: &[
                "ຫ\u{ebb}ວໃຈ",
                "ຫ\u{ebb}ວໃຈກຳລ\u{eb1}ງເຕ\u{eb5}ບໂຕ",
                "ຫ\u{ebb}ວໃຈພອງໃຫຍ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("auganti širdelė"),
            keywords: &[
                "auganti širdelė",
                "didėjimas",
                "pulsas",
                "susijaudinimas",
                "susinervinęs",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augoša sirds"),
            keywords: &["augoša sirds", "sirds", "sirdspuksti"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa tipu haere"),
            keywords: &[
                "hiamo",
                "kapakapa",
                "manawa tipu haere",
                "taiatea",
                "tipu ana",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("срце што расте"),
            keywords: &[
                "возбуда",
                "нервоза",
                "пулс",
                "растење",
                "срце",
                "срце што расте",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വികസിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം"),
            keywords: &[
                "അത\u{d4d}ഭ\u{d41}തം",
                "ആവേശം",
                "ജിജ\u{d4d}ഞ\u{d3e}സ",
                "പരിഭ\u{d4d}ര\u{d3e}ന\u{d4d}തി",
                "പ\u{d4d}രണയം",
                "വികസിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം",
                "വിക\u{d3e}രം",
                "ഹ\u{d43}ദയം",
                "ഹ\u{d43}ദയത\u{d3e}ളം",
                "ഹ\u{d43}ദയമിടിപ\u{d4d}പ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лавширч буй зүрх"),
            keywords: &[
                "лавширч буй",
                "лавширч буй зүрх",
                "сандарсан",
                "хөөрсөн",
                "цохилт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{943}द\u{94d}धि\u{902}गत होणार\u{947} ह\u{943}दय"),
            keywords: &[
                "उत\u{94d}स\u{941}क",
                "निराश",
                "व\u{943}द\u{94d}धि\u{902}गत होणार\u{947} ह\u{943}दय",
                "व\u{943}द\u{94d}धि\u{902}गत होण\u{947}",
                "ह\u{943}दयाची गती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati membesar"),
            keywords: &["denyutan jantung", "gementar", "hati", "membesar", "teruja"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb tikber"),
            keywords: &["eċċitat", "nervuża", "polz", "qalb tikber", "tkabbir"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကြ\u{102e}းထ\u{103d}ားလာနေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "ကြ\u{102e}းထ\u{103d}ားလာနေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
                "ကြ\u{102e}းထ\u{103d}ားလာနေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား",
                "ကြ\u{102e}းထ\u{103d}ားလာသော",
                "စ\u{102d}တ\u{103a}လ\u{103e}\u{102f}ပ\u{103a}ရ\u{103e}ား",
                "န\u{103e}လ\u{102f}\u{1036}းခ\u{102f}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("voksende hjerte"),
            keywords: &[
                "følelser",
                "kjærlighet",
                "nervøs",
                "spent",
                "voksende hjerte",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बढिरह\u{947}को म\u{941}ट\u{941}"),
            keywords: &[
                "उत\u{94d}साहित",
                "चिन\u{94d}तित",
                "बढिरह\u{947}को",
                "बढिरह\u{947}को म\u{941}ट\u{941}",
                "हर\u{94d}टप\u{94d}लस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groeiend hart"),
            keywords: &[
                "groeiend",
                "groeiend hart",
                "hartslag",
                "nerveus",
                "spannend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("veksande hjarte"),
            keywords: &["kjensler", "kjærleik", "nervøs", "spent", "veksande hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଢ\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ"),
            keywords: &[
                "ପ\u{b4d}ରେମ",
                "ବଢ\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ",
                "ବର\u{b4d}ଦ\u{b4d}ଧ\u{b3f}ତ ହ\u{b43}ଦୟ",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ରୋମ\u{b3e}ଞ\u{b4d}ଚ\u{b3f}ତ",
                "ଶଙ\u{b4d}କ\u{b3e}ଗ\u{b4d}ରସ\u{b4d}ତ",
                "ହ\u{b43}ଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਧਦਾ ਦਿਲ"),
            keywords: &[
                "ਉਤਸ\u{a3c}ਾਹਿਤ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਦਿਲ",
                "ਪਿਆਰ",
                "ਬ\u{a47}ਚ\u{a48}ਨ",
                "ਵਧਦਾ ਦਿਲ",
                "ਵ\u{a71}ਧਦਾ ਦਿਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("وددھا ہوئیا دل"),
            keywords: &["اعصابی", "جذباتی ہونا", "نبض", "وددھا ہوئیا دل", "ودھنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé De Gro Bíkọs I Dé Hapí"),
            keywords: &[
                "Gro",
                "Hapí Wẹ\u{301}l Wẹl",
                "Hat Wé De Gro Bíkọs I Dé Hapí",
                "Hátbit",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rosnące serce"),
            keywords: &[
                "bicie serca",
                "puls",
                "rosnące serce",
                "serce rośnie",
                "tętno",
                "zdenerwowany",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غټیدونکې زړه"),
            keywords: &["زړه پوری", "ضربان", "غټیدونکې", "غټیدونکې زړه", "وارخطا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração crescendo"),
            keywords: &[
                "amor",
                "coração",
                "coração crescendo",
                "emoção",
                "nervosismo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração a crescer"),
            keywords: &[
                "a crescer",
                "coração",
                "coração a crescer",
                "entusiasmado",
                "nervoso",
                "palpitação",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paqarisqa sunqu"),
            keywords: &["kusisqa", "paqarisqa", "paqarisqa sunqu", "pulso", "tʼikti"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă care crește"),
            keywords: &[
                "emoție",
                "entuziasm",
                "inimă",
                "inimă care crește",
                "neliniște",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-596"),
            keywords: &["E10-596"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("растущее сердце"),
            keywords: &[
                "биение",
                "больше",
                "размер",
                "растущее сердце",
                "ритм",
                "сердце",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima ukura"),
            keywords: &[
                "bishimishije",
                "gicitse intege",
                "gushishira",
                "ubukure",
                "umutima ukura",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڌندڙ دل"),
            keywords: &["نبض", "وڌندڙ", "وڌندڙ دل", "پرجوش", "پريشان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැඩෙන හදවත"),
            keywords: &[
                "චංචල",
                "ප\u{dca}\u{200d}රබෝදමත\u{dca}",
                "වැඩෙන",
                "හදවත",
                "හෘද ස\u{dca}පන\u{dca}දනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rastúce srdce"),
            keywords: &["nervózne", "pulz", "radosť", "rastúce srdce", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rastoče srce"),
            keywords: &["rastoče", "srce", "srčni utrip", "vznemirjeno", "živčno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno kubcayo"),
            keywords: &[
                "farxad",
                "garaaca wadnaha",
                "kobcis",
                "naxsan",
                "wadno kobcayo",
                "wadno kubcayo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër që rritet"),
            keywords: &[
                "i emocionuar",
                "puls",
                "që rritet",
                "zemër",
                "zemër që rritet",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("срце које расте"),
            keywords: &[
                "нeрвoзa",
                "пулсирaњe",
                "растуће",
                "срцe",
                "срце које расте",
                "узбуђeнoст",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["срце које расте"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srce koje raste"),
            keywords: &[
                "nervoza",
                "pulsiranje",
                "rastuće",
                "srce",
                "srce koje raste",
                "uzbuđenost",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["srce koje raste"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("växande hjärta"),
            keywords: &[
                "hjärta",
                "känslor",
                "kärlek",
                "nervös",
                "upprymd",
                "växande hjärta",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo uaokua"),
            keywords: &[
                "furahia",
                "kukua",
                "moyo",
                "moyo uaokua",
                "mpaigo ya moyo",
                "wasiwasi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("moyo unaokua"),
            keywords: &[
                "furahia",
                "kukua",
                "moyo",
                "moyo uanokua",
                "moyo unaokua",
                "mpaigo ya moyo",
                "wasiwasi",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("படபடக\u{bcd}கும\u{bcd} இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "துடிப\u{bcd}பு",
                "படபடக\u{bcd}கும\u{bcd} இதயம\u{bcd}",
                "படபடப\u{bcd}பு",
                "பரவசம\u{bcd}",
                "விரியும\u{bcd} இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}పంద\u{c3f}స\u{c4d}తున\u{c4d}న హృదయం"),
            keywords: &[
                "ప\u{c46}రుగు",
                "స\u{c4d}పంద\u{c3f}స\u{c4d}తున\u{c4d}న హృదయం",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили афзоянда"),
            keywords: &[
                "асабӣ",
                "дили афзоянда",
                "калон шуда истода",
                "набз",
                "ҳаяҷон",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใจพองโต"),
            keywords: &["ห\u{e31}วใจ", "ใจพองโต"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ulalýan ýürek"),
            keywords: &["galjaň", "puls", "tolgunan", "ulalýan", "ulalýan ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu tupu"),
            keywords: &["mafu tupu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyüyen kalp"),
            keywords: &["aşk", "büyüyen kalp", "coşkulu", "duygu", "kalp", "sinirli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۆسۈۋاتقان يۈرەك"),
            keywords: &[
                "ئۆسكەن",
                "ئۆسۈۋاتقان يۈرەك",
                "جىددىيلەشكەن",
                "سوقۇش",
                "ھاياجان",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце, що зростає"),
            keywords: &[
                "захоплення",
                "збільшується",
                "нервувати",
                "серце",
                "серце, що зростає",
                "серцебиття",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بڑھتا ہوا دل"),
            keywords: &["بڑھتا ہوا دل", "دل", "نروس", "پر جوش"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kattalashayotgan yurak"),
            keywords: &[
                "asab",
                "hayajonli",
                "kattalashayotgan",
                "yurak",
                "yurak urishi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim lớn dần"),
            keywords: &[
                "bị kích thích",
                "lo lắng",
                "nhịp tim",
                "phát triển",
                "trái tim lớn dần",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol buy màgg"),
            keywords: &["buy màgg", "eksite", "mer", "xol buy màgg", "yëngu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo ekhulayo"),
            keywords: &[
                "imincili",
                "intliziyo ekhulayo",
                "ukhulayo",
                "ukubetha kwentliziyo",
                "ukuphakuzela",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Didagba"),
            keywords: &["bẹ\u{300}rù", "dunú", "dàgbà", "ṣọkùlú", "Ọkan Didagba"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("長大嘅心"),
            keywords: &["緊張", "脈動", "興奮", "長大", "長大嘅心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("长大嘅心"),
            keywords: &["兴奋", "紧张", "脉动", "长大", "长大嘅心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("搏动的心"),
            keywords: &["搏动", "搏动的心", "激动", "紧张", "红心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心動"),
            keywords: &["心動", "心撲通跳"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["心動", "心跳"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ekhulayo"),
            keywords: &[
                "inhliziyo",
                "inhliziyo ekhulayo",
                "intokozo",
                "ukukhula",
                "ukwethuka",
                "uvalo",
            ],
        },
    ],
};
#[doc = "💓"]
pub const BEATING_HEART: crate::Emoji = crate::Emoji {
    glyph: "💓",
    codepoint: "1F493",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "beating heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kloppende hartjie"),
            keywords: &["hart", "hartklop", "klop", "kloppende hartjie", "pols"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እየመታ ያለ ልብ"),
            keywords: &["ልብ", "መምታት", "እየመታ ያለ ልብ", "የልብ ምት", "የልብ አመታት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب يخفق"),
            keywords: &["حب", "خفقان", "قلب", "قلب يخفق", "مشاعر", "نبض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পন\u{9cd}দিত হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "ক\u{981}পনি",
                "স\u{9cd}পন\u{9cd}দন",
                "স\u{9cd}পন\u{9cd}দিত হ\u{9c3}দয\u{9bc}",
                "হ\u{9be}ৰ\u{9cd}টবিট",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("döyünən ürək"),
            keywords: &["döyünmək", "döyünən ürək", "ürək", "ürək döyüntüsü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пульсуючае сэрца"),
            keywords: &[
                "біццё",
                "пульсуючае сэрца",
                "сэрца",
                "сэрцабіцце",
                "хваляванне",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Биещо сърце"),
            keywords: &["Биещо сърце", "биене", "биещо", "сърце", "туптене"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}পন\u{9cd}দিত হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "স\u{9cd}পন\u{9cd}দনশীল",
                "স\u{9cd}পন\u{9cd}দিত",
                "স\u{9cd}পন\u{9cd}দিত হ\u{9c3}দয\u{9bc}",
                "হ\u{9c3}দস\u{9cd}পন\u{9cd}দন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srce koje kuca"),
            keywords: &["otkucaji srca", "pulsiranje", "srce", "srce koje kuca"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor que batega"),
            keywords: &["batec", "cor", "cor que batega"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏫ ᎠᏓᎾᏫᏍᎬ"),
            keywords: &["ᎠᏓᎿᏫᏍᎦ", "ᎠᏓᏅᏫᏍᎦ", "ᎤᎿᏫ ᎠᏓᎾᏫᏍᎬ", "ᎤᎿᏫ ᎠᏓᎿᏫᏍᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bušící srdce"),
            keywords: &["bušení", "bušící srdce", "puls", "srdce", "tep"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon yn curo"),
            keywords: &["calon", "calon yn curo", "curo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bankende hjerte"),
            keywords: &["bankende hjerte", "hjerte", "kærlighed", "romantik"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schlagendes Herz"),
            keywords: &["Herz", "Liebe", "schlagendes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά που χτυπά"),
            keywords: &[
                "καρδιά",
                "καρδιά που χτυπά",
                "καρδιοχτύπι",
                "πάλλεται",
                "χτυπά",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("beating heart"),
            keywords: &["beating", "beating heart", "heartbeat", "pulsating"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón latiendo"),
            keywords: &["amor", "corazón", "corazón latiendo", "emoción", "latido"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón que palpita"),
            keywords: &[
                "amor",
                "corazón",
                "corazón que palpita",
                "emoción",
                "latidos",
                "palpitar",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("corazón latiendo"),
            keywords: &[
                "corazón",
                "corazón latiendo",
                "emoción",
                "latidos",
                "palpitar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tukslev süda"),
            keywords: &["löök", "pulss", "süda", "tukslev süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz-taupada"),
            keywords: &["bihotz", "bihotz-taupada", "taupada"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب تپنده"),
            keywords: &["تپش", "تپیدن", "قلب", "قلب تپنده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sykkivä sydän"),
            keywords: &["sydän", "syke", "sykkivä", "sykkiä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tumitibok na puso"),
            keywords: &["puso", "tibok ng puso", "tumitibok", "tumitibok na puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bankandi hjarta"),
            keywords: &["bankandi hjarta", "bankar", "hjarta", "slær"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur battant"),
            keywords: &["cœur", "cœur battant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["battant", "battement", "cœur", "pulsations"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí ag preabadh"),
            keywords: &["croí", "croí ag preabadh", "grá", "preabadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe a’ bualadh"),
            keywords: &["bualadh", "cridhe", "cridhe a’ bualadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón latexando"),
            keywords: &["amor", "corazón", "corazón latexando", "latexo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ધડકત\u{ac1}\u{a82} દિલ"),
            keywords: &[
                "દિલ",
                "ધડકત\u{ac1}\u{a82}",
                "ધડકન",
                "પ\u{acd}ર\u{ac7}મ",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciya mai bugawa"),
            keywords: &["bugawa", "bugawar zuciya", "zuciya mai bugawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב פועם"),
            keywords: &["לב", "פועם", "פעימות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("धड\u{93c}कता दिल"),
            keywords: &[
                "दिल",
                "धड\u{93c}कता दिल",
                "धड\u{93c}कन",
                "धड\u{93c}कना",
                "प\u{94d}यार",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srce koje kuca"),
            keywords: &["kucanje", "otkucaj", "puls", "srce", "srce koje kuca"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dobogó szív"),
            keywords: &["dobogó szív", "szív", "szívdobogás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաբախող սիրտ"),
            keywords: &["բաբախյուն", "բաբախող սիրտ", "պուլսացիա", "սիրտ", "սրտխփոց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati berdetak"),
            keywords: &["denyut", "detak", "hati", "hati berdetak", "jantung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-akụ akụ"),
            keywords: &["na-akụ", "na-eme nkuli nkụda", "obi na-akụ akụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjartsláttur"),
            keywords: &["hjarta", "hjartsláttur", "sláttur", "tilfinningar", "ást"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore che batte"),
            keywords: &["amore", "battito", "cuore", "cuore che batte", "pulsazione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ドキドキするハート"),
            keywords: &["ドキドキ", "ドキドキするハート", "ハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati dheg-dhegan"),
            keywords: &["ati dheg-dhegan", "dheg-dhegan", "dheging ati", "ser-seran"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მფეთქავი გული"),
            keywords: &["გული", "გულისცემა", "მფეთქავი გული", "პულსი", "ფეთქვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("соғып тұрған жүрек"),
            keywords: &[
                "жүрек",
                "жүрек соғысы",
                "соғу",
                "соғып тұрған",
                "соғып тұрған жүрек",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bankende hjerte"),
            keywords: &["bankende hjerte", "hjerte", "kærlighed", "romantik"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងក\u{17c6}ព\u{17bb}ងញ\u{17d0}រ"),
            keywords: &[
                "ញ\u{17d0}រ",
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងក\u{17c6}ព\u{17bb}ងញ\u{17d0}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cbf}ಡ\u{cbf}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯ"),
            keywords: &[
                "ಮ\u{cbf}ಡ\u{cbf}ತ",
                "ಮ\u{cbf}ಡ\u{cbf}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯ",
                "ಹೃದಯ ಸ\u{ccd}ಪಂದನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("두근거리는 하트"),
            keywords: &[
                "두근거리는 마음",
                "두근거리는 하트",
                "두근두근",
                "떨리는 마음",
                "사랑",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धडधडपी काळीज"),
            keywords: &["काळजाच\u{947} ठोक\u{947}", "धडधड", "धडधडपी", "धडधडपी काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кагып жаткан жүрөк"),
            keywords: &[
                "жүрөк",
                "жүрөк кагышы",
                "кагуу",
                "кагып жаткан жүрөк",
                "пульс",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("klappend Häerz"),
            keywords: &[
                "Häerzklappen",
                "Schlag",
                "klappend",
                "klappend Häerz",
                "schloend",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈກຳລ\u{eb1}ງເຕ\u{eb1}\u{ec9}ນ"),
            keywords: &[
                "ຫ\u{ebb}ວໃຈ",
                "ຫ\u{ebb}ວໃຈກຳລ\u{eb1}ງເຕ\u{eb1}\u{ec9}ນ",
                "ຫ\u{ebb}ວໃຈເຕ\u{eb1}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plakanti širdelė"),
            keywords: &[
                "plakanti",
                "plakanti širdelė",
                "pulsavimas",
                "širdies plakimas",
                "širdis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pukstoša sirds"),
            keywords: &["pukstoša sirds", "pukstēt", "sirds", "sirdspuksti"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa patupatu"),
            keywords: &["kapakapa", "manawa patupatu", "patu manawa", "patupatu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("срце што чука"),
            keywords: &["отчукување", "пулс", "срце", "срце што чука", "чука"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}പന\u{d4d}ദിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം"),
            keywords: &[
                "ത\u{d41}ടിപ\u{d4d}പ\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം",
                "ത\u{d41}ടിപ\u{d4d}പ\u{d4d}",
                "പ\u{d4d}രണയം",
                "മിടിപ\u{d4d}പ\u{d4d}",
                "വിക\u{d3e}രം",
                "സ\u{d4d}പന\u{d4d}ദിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цохилж буй зүрх"),
            keywords: &[
                "зүрх",
                "зүрхний цохилт",
                "цохилж буй зүрх",
                "цохилох",
                "ягаан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("धडकणार\u{947} ह\u{943}दय"),
            keywords: &[
                "धडकणार\u{947}",
                "धडकणार\u{947} ह\u{943}दय",
                "धडधडण\u{947}",
                "ह\u{943}दयाची स\u{94d}प\u{902}दन\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jantung berdegup"),
            keywords: &[
                "berdegup",
                "degupan jantung",
                "denyut",
                "hati",
                "jantung berdegup",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb tħabbat"),
            keywords: &["qalb tħabbat", "taħbita tal-qalb", "tħabbat"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခ\u{102f}န\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "ခ\u{102f}န\u{103a}",
                "ခ\u{102f}န\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
                "န\u{103e}လ\u{102f}\u{1036}းခ\u{102f}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bankende hjerte"),
            keywords: &["bankende", "følelser", "hjerte", "kjærlighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("धड\u{94d}किरह\u{947}को म\u{941}ट\u{941}"),
            keywords: &[
                "धड\u{94d}किरह\u{947}को",
                "पल\u{94d}स\u{947}टिङ",
                "म\u{941}ट\u{941}",
                "म\u{941}ट\u{941}को धड\u{94d}कन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kloppend hart"),
            keywords: &["hartslag", "kloppen", "kloppend hart", "slaan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bankande hjarte"),
            keywords: &["bankande", "hjarte", "kjensler", "kjærleik"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ପନ\u{b4d}ଦନ ହେଉଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ"),
            keywords: &[
                "ପ\u{b4d}ରେମ",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ସ\u{b4d}ପନ\u{b4d}ଦନ",
                "ସ\u{b4d}ପନ\u{b4d}ଦନ ହେଉଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟ",
                "ସ\u{b4d}ପନ\u{b4d}ଦ\u{b3f}ତ ହ\u{b43}ଦୟ",
                "ହ\u{b43}ଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਧੜਕਦਾ ਦਿਲ"),
            keywords: &["ਜਜ\u{a3c}ਬਾਤ", "ਦਿਲ", "ਧੜਕਣਾ", "ਧੜਕਦਾ", "ਪਿਆਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دھڑکدا دل"),
            keywords: &["دل دی دھڑکن", "دھڑکدا دل", "مارنا", "چلدی نبض"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé De Bit"),
            keywords: &["Bítin", "Hat Wé De Bit", "Hátbit"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bijące serce"),
            keywords: &["bijące serce", "kocham cię"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ضربان زړه"),
            keywords: &["زړه ضربان", "ضربان", "ضربان زړه", "ځړولی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração pulsante"),
            keywords: &["amor", "batendo", "coração", "emoção", "pulsante"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração a bater"),
            keywords: &["batimento", "coração", "coração a bater", "palpitante"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phatatasqa sunqu"),
            keywords: &[
                "patatasqa sunqu",
                "phatatasqa",
                "phatatasqa sunqu",
                "phatatay",
                "tʼipuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă palpitând"),
            keywords: &["emoție", "inimă", "inimă palpitând", "viață"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-592"),
            keywords: &["E10-592"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пульсирующее сердце"),
            keywords: &[
                "бьется",
                "красное сердце",
                "пульсирует",
                "пульсирующее сердце",
                "сердце",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima utera"),
            keywords: &["gutera", "gutera kw’umutima", "gutitira", "umutima utera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڌڙڪندڙ دل"),
            keywords: &["دل جي ڌڙڪن", "مار", "ڌڙڪندڙ دل", "ڌڙڪڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැහෙන හදවත"),
            keywords: &["ගැහෙන", "ස\u{dca}පන\u{dca}දනය", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tlčúce srdce"),
            keywords: &["pulz", "srdce", "tlkot", "tlčúce srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("utripajoče srce"),
            keywords: &[
                "bitje",
                "srce",
                "srčni utrip",
                "utripajoče srce",
                "utripanje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno garaac"),
            keywords: &["garaacis", "jahwareer", "wadno garaac", "wadno garaacaayo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër që rreh"),
            keywords: &["pulsim", "rrahje", "rrahje zemre", "zemër", "zemër që rreh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("срце које куца"),
            keywords: &["oткуцaj", "куцaњe", "пулс", "срцe", "срце које куца"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["срце које куца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srce koje kuca"),
            keywords: &["kucanje", "otkucaj", "puls", "srce", "srce koje kuca"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["srce koje kuca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bultande hjärta"),
            keywords: &[
                "bultande hjärta",
                "bultar",
                "hjärta",
                "känslor",
                "kärlek",
                "slår",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo unaodunda"),
            keywords: &["kupiga", "mapigo ya moyo", "mbio", "moyo", "moyo unaodunda"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("துடிக\u{bcd}கும\u{bcd} இதயம\u{bcd}"),
            keywords: &[
                "இதயத\u{bcd} துடிப\u{bcd}பு",
                "இதயம\u{bcd}",
                "துடிக\u{bcd}கும\u{bcd} இதயம\u{bcd}",
                "துடித\u{bcd}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}పంద\u{c3f}ంచ\u{c47} హృదయం"),
            keywords: &[
                "స\u{c4d}పంద\u{c3f}ంచడం",
                "స\u{c4d}పంద\u{c3f}ంచ\u{c47} హృదయం",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили тапишзананда"),
            keywords: &["дили тапишзананда", "тапидан", "тапишзанӣ", "тапиши дил"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจเต\u{e49}น"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจเต\u{e49}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("urýan ýürek"),
            keywords: &["puls", "urmak", "urýan ýürek", "ýürek urgusy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu ʻoku tā"),
            keywords: &["mafu ʻoku tā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çarpan kalp"),
            keywords: &["aşk", "duygu", "kalp", "çarpan kalp"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سوقۇۋاتقان يۈرەك"),
            keywords: &["سوقۇش", "سوقۇۋاتقان", "سوقۇۋاتقان يۈرەك", "يۈرەك سوقۇشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце, що бʼється"),
            keywords: &[
                "биття",
                "пульсувати",
                "серце",
                "серце, що бʼється",
                "серцебиття",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھڑکتا دل"),
            keywords: &["دل", "دھڑکتا دل", "دھڑکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("urayotgan yurak"),
            keywords: &["urayotgan", "yurak", "yurak urishi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim đang đập"),
            keywords: &["dao động", "nhịp tim", "trái tim đang đập", "đập"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol buy tëf-tëfi"),
            keywords: &["dóor", "xol buy tëf-tëfi", "yëngu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo ebethayo"),
            keywords: &["intliziyo ebethayo", "ukubetha", "ukubetha kwentliziyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Ti O N Mi"),
            keywords: &["mímí", "mímí ọkàn", "Ọkan Ti O N Mi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("跳動嘅心"),
            keywords: &["心跳", "脈動", "跳動", "跳動嘅心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("跳动嘅心"),
            keywords: &["心跳", "脉动", "跳动", "跳动嘅心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("心跳"),
            keywords: &["心动", "心跳", "爱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心跳"),
            keywords: &["心", "心跳", "愛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo egxumagxumayo"),
            keywords: &[
                "inhliziyo",
                "inhliziyo egxumagxumayo",
                "ukugxumagxuma",
                "ukushaya kwenhliziyo",
            ],
        },
    ],
};
#[doc = "💞"]
pub const REVOLVING_HEARTS: crate::Emoji = crate::Emoji {
    glyph: "💞",
    codepoint: "1F49E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "revolving hearts",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wentelende hartjies"),
            keywords: &["draai", "hart", "wentel", "wentelende hartjies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሚሽከረከሩ ልቦች"),
            keywords: &["ልብ", "የሚሸከረከር", "የሚሽከረከሩ ልቦች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلوب تدور حول بعضها"),
            keywords: &["جذاب", "حب", "قلب", "قلوب تدور حول بعضها", "مثير", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9c2}ৰি থক\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &["ঘ\u{9c2}ৰ\u{9be}", "ঘ\u{9c2}ৰি থক\u{9be} হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fırlanan ürəklr"),
            keywords: &["fırlanan", "fırlanan ürəklr", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэрцы, якія круцяцца"),
            keywords: &["кручэнне", "сэрцы", "сэрцы, якія круцяцца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Обикалящи сърца"),
            keywords: &["Обикалящи сърца", "обикалящ", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9c2}র\u{9cd}ণম\u{9be}ন হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "ঘ\u{9c1}রপ\u{9be}ক",
                "ঘ\u{9c2}র\u{9cd}ণম\u{9be}ন হ\u{9be}র\u{9cd}ট",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("više srca se okreće"),
            keywords: &["kretanje", "srca", "više srca se okreće"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cors que giren"),
            keywords: &["cors", "cors que giren", "gir"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏕᏲ ᏚᏓᏅᏛ"),
            keywords: &["ᏗᏕᏲ", "ᏗᏕᏲ ᏚᏓᏅᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdce vířící v kole"),
            keywords: &["kolo", "otáčení", "srdce", "srdce vířící v kole", "víření"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calonnau yn troelli"),
            keywords: &["calon", "calonnau yn troelli", "troelli"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("roterende hjerter"),
            keywords: &["følelser", "hjerter", "roterende hjerter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("kreisende Herzen"),
            keywords: &["Liebe", "kreisende Herzen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιές που γυρίζουν"),
            keywords: &["καρδιά", "καρδιές που γυρίζουν", "περιστρεφόμενη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("revolving hearts"),
            keywords: &["revolving", "revolving hearts"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazones giratorios"),
            keywords: &["corazones giratorios", "corazón", "giratorio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazones que giran"),
            keywords: &[
                "amor",
                "corazones que giran",
                "corazón",
                "emoción",
                "girar",
                "vueltas",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("corazones giratorios"),
            keywords: &[
                "amor",
                "corazones giratorios",
                "corazón",
                "emoción",
                "girar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pöörlevad südamed"),
            keywords: &["pöörlev", "pöörlevad südamed", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("biraka ari diren bihotzak"),
            keywords: &["bihotz", "biraka", "biraka ari diren bihotzak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب چرخان"),
            keywords: &["قلب", "چرخان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("toisiaan kiertävät sydämet"),
            keywords: &["pyörivä", "sydän", "toisiaan kiertävät sydämet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("umiikot na mga puso"),
            keywords: &["puso", "umiikot", "umiikot na mga puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjørtu sum mela í klingur"),
            keywords: &["hjarta", "hjørtu", "hjørtu sum mela í klingur", "mala"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœurs qui tournent"),
            keywords: &["cœurs", "cœurs qui tournent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cœurs qui tournent"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croíthe ag rothlú"),
            keywords: &["croíthe", "croíthe ag rothlú"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridheachan a’ dol mun cuairt"),
            keywords: &["cridheachan a’ dol mun cuairt", "cuairt", "dol mun cuairt"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazóns voando"),
            keywords: &["corazóns", "corazóns voando", "voar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભમતા દિલ"),
            keywords: &[
                "આરાધ\u{acd}ય",
                "દિલ",
                "પ\u{acd}ર\u{ac7}મ",
                "ભમતા",
                "લાગણી",
                "સ\u{ac1}\u{a82}દર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciyoyi masu juyawa"),
            keywords: &["mai juyawa", "zuciyoyi masu juyawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לבבות נעים במעגל"),
            keywords: &[
                "אהבה",
                "לבבות",
                "לבבות מסתובבים",
                "לבבות נעים במעגל",
                "מעגל",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("घ\u{942}मत\u{947} दिल"),
            keywords: &[
                "आकर\u{94d}षक",
                "कावाई",
                "घ\u{942}मत\u{947} दिल",
                "घ\u{942}मना",
                "दिल",
                "प\u{94d}यार",
                "प\u{94d}यारा",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srca koja se vrte u krug"),
            keywords: &["okretanje", "srca koja se vrte u krug", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("forgó szívek"),
            keywords: &["forgás", "forgó szívek", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտտվող սրտեր"),
            keywords: &["պտտվող", "պտտվող սրտեր", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati berputar"),
            keywords: &["berputar", "hati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-agba okirikiri"),
            keywords: &["na-agba okirikiri", "obi na-agba okirikiri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("snúningshjörtu"),
            keywords: &["hjarta", "snúningshjörtu", "ást"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuori che girano"),
            keywords: &["adorabile", "amore", "carino", "cuore", "cuori che girano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("回転するハート"),
            keywords: &["かわいい", "ハート", "回転するハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati mubeng-mubeng"),
            keywords: &["ati mubeng-mubeng", "mubeng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მბრუნავი გულები"),
            keywords: &["გული", "მბრუნავი", "მბრუნავი გულები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айналып тұрған жүректер"),
            keywords: &["айналу", "айналып тұрған жүректер", "жүрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("roterende hjerter"),
            keywords: &["følelser", "hjerter", "roterende hjerter"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "បេះដ\u{17bc}ងក\u{17c6}ព\u{17bb}\u{17bb}ងរង\u{17d2}វ\u{17b7}លជ\u{17bb}\u{17c6}",
            ),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងក\u{17c6}ព\u{17bb}\u{17bb}ងរង\u{17d2}វ\u{17b7}លជ\u{17bb}\u{17c6}",
                "វ\u{17b7}ល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸುತ\u{ccd}ತುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯಗಳು"),
            keywords: &[
                "ಪರ\u{cbf}ಭ\u{ccd}ರಮ\u{cbf}ಸುವ ಹೃದಯಗಳು",
                "ಸುತ\u{ccd}ತುತ\u{ccd}ತ\u{cbf}ರುವ ಹೃದಯಗಳು",
                "ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("회전하는 하트"),
            keywords: &[
                "귀여움",
                "빙글빙글 하트",
                "사랑",
                "사랑스러움",
                "하트",
                "회전하는 하트",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घ\u{941}\u{902}वपी काळजा\u{902}"),
            keywords: &["घ\u{941}\u{902}वपी", "घ\u{941}\u{902}वपी काळजा\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("айланып жаткан жүрөктөр"),
            keywords: &["айланып жаткан", "айланып жаткан жүрөктөр", "жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("dréiend Häerzer"),
            keywords: &["dréiend", "dréiend Häerzer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈກຳລ\u{eb1}ງໝ\u{eb9}ນຮອບ"),
            keywords: &[
                "ຫ\u{ebb}ວໃຈ",
                "ຫ\u{ebb}ວໃຈກຳລ\u{eb1}ງໝ\u{eb9}ນຮອບ",
                "ອາລ\u{ebb}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("besisukančios širdelės"),
            keywords: &["besisukančios širdelės", "suktis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rotējošas sirdis"),
            keywords: &["rotējošas sirdis", "sirds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā manawa takahurihuri"),
            keywords: &["ngā manawa takahurihuri", "takahurihuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ротирачки срца"),
            keywords: &["ротира", "ротирачки срца", "се врти", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കറങ\u{d4d}ങ\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയങ\u{d4d}ങൾ"),
            keywords: &[
                "ആര\u{d3e}ധനീയം",
                "കറങ\u{d4d}ങ\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയങ\u{d4d}ങൾ",
                "ച\u{d41}റ\u{d4d}റ\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയങ\u{d4d}ങൾ",
                "ച\u{d41}റ\u{d4d}റൽ",
                "പ\u{d4d}രണയം",
                "ഭംഗി",
                "വിക\u{d3e}രം",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эргэлдэж буй зүрх"),
            keywords: &["зүрх", "эргэлдэж буй зүрх", "эргэлдэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "एकम\u{947}का\u{902}मध\u{94d}\u{200d}य\u{947} ग\u{941}\u{902}तल\u{947}ल\u{947} ह\u{943}दय",
            ),
            keywords: &[
                "एकम\u{947}का\u{902}मध\u{94d}य\u{947} ग\u{941}\u{902}तल\u{947}ली ह\u{943}दय\u{947}",
                "एकम\u{947}का\u{902}मध\u{94d}य\u{947} ग\u{941}\u{902}तल\u{947}ल\u{947}",
                "एकम\u{947}का\u{902}मध\u{94d}\u{200d}य\u{947} ग\u{941}\u{902}तल\u{947}ल\u{947} ह\u{943}दय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati berputar"),
            keywords: &["berputar", "hati"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qlub iduru"),
            keywords: &["iduru", "qlub iduru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လည\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းများ"),
            keywords: &[
                "ပတ\u{103a}ချာလ\u{103e}ည\u{1037}\u{103a}",
                "ပတ\u{103a}ချာလ\u{103e}ည\u{1037}\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းများ",
                "လည\u{103a}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းများ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("snurrende hjerter"),
            keywords: &["følelser", "hjerter", "kjærlighet", "snurrende", "søtt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("घ\u{941}मिरह\u{947}का म\u{941}ट\u{941}हर\u{942}"),
            keywords: &[
                "घ\u{941}मिरह\u{947}का म\u{941}ट\u{941}हर\u{942}",
                "घ\u{941}मिरह\u{947}को",
                "म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ronddraaiende harten"),
            keywords: &["draaien", "hart", "ronddraaiende harten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("snurrande hjarte"),
            keywords: &["hjarte", "kjensler", "kjærleik", "snurrande", "søtt"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଘ\u{b42}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଅତ\u{b3f} ସ\u{b41}ନ\u{b4d}ଦର",
                "ଆଦରଣୀୟ",
                "କବ\u{b3e}ଲ\u{b3f}",
                "ଘ\u{b42}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b43}ଦୟଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଘ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣୟମ\u{b3e}ନ",
                "ପ\u{b4d}ରେମ",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ହ\u{b43}ଦୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਘ\u{a41}\u{a70}ਮਦ\u{a47} ਦਿਲ"),
            keywords: &[
                "ਘ\u{a41}\u{a70}ਮਦਾ",
                "ਘ\u{a41}\u{a70}ਮਦ\u{a47} ਦਿਲ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਦਿਲ",
                "ਪਿਆਰ",
                "ਸਤਿਕਾਰਯ\u{a4b}ਗ",
                "ਸ\u{a4b}ਹਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("گھومدا دل"),
            keywords: &["گھمدا ہوئیا", "گھومدا دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat-dẹm Wé De Tọ\u{301}n Raúnd An Raund"),
            keywords: &[
                "Hat-dẹm Wé De Tọ\u{301}n Raúnd An Raund",
                "Tọ\u{301}n Raúnd An Raund",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wirujące serca"),
            keywords: &[
                "miłość",
                "para",
                "serca dwa",
                "tańczące serca",
                "wirujące serca",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تړلۍ زړونه"),
            keywords: &["تړلۍ", "تړلۍ زړونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("corações girando"),
            keywords: &["corações girando", "girando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("corações rodopiantes"),
            keywords: &[
                "coração",
                "corações",
                "corações a girar",
                "corações a rodopiar",
                "corações rodopiantes",
                "rodopiante",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyusqa sunqukuna"),
            keywords: &["muyusqa", "muyusqa sunqukuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimi învârtindu-se în cerc"),
            keywords: &["cerc", "inimi învârtindu-se în cerc", "inimă", "învârtire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-603"),
            keywords: &["E10-603"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вращающиеся сердца"),
            keywords: &["вращающиеся сердца", "вращение", "два", "круги", "сердца"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imitima izenguruka"),
            keywords: &["bihinduka", "imitima izenguruka"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦرندڙ دليون"),
            keywords: &["ڦرندڙ", "ڦرندڙ دليون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කරකැවෙන හදවත\u{dca}"),
            keywords: &["කරකැවෙන", "කරකැවෙන හදවත\u{dca}", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("krúžiace srdcia"),
            keywords: &["krúžiace", "krúžiace srdcia", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vrteči se srci"),
            keywords: &["srce", "vrtenje", "vrteči se srci"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno warwareegaayo"),
            keywords: &["wadno warwareegaayo", "wareeg"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemra që rrotullohen"),
            keywords: &[
                "që rrotullohen",
                "rrotulluese",
                "zemra që rrotullohen",
                "zemër",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("срца која се окрећу"),
            keywords: &["oкрeтaњe", "срцe", "срца која се окрећу"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["срца која се окрећу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srca koja se okreću"),
            keywords: &["okretanje", "srca koja se okreću", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["srca koja se okreću"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("snurrande hjärtan"),
            keywords: &[
                "hjärta",
                "känslor",
                "kärlek",
                "snurrande hjärtan",
                "snurrar",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mioyo inayozunguka"),
            keywords: &["kuzunguka", "mioyo inayozunguka", "moyo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுற\u{bcd}றும\u{bcd} இதயங\u{bcd}கள\u{bcd}"),
            keywords: &[
                "இதயங\u{bcd}கள\u{bcd}",
                "ஈருடல\u{bcd} ஓருயிர\u{bcd}",
                "க\u{bbe}தல\u{bcd}",
                "சுற\u{bcd}றும\u{bcd} இதயங\u{bcd}கள\u{bcd}",
                "சுழற\u{bcd}சி",
                "சுழலும\u{bcd} இதயங\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c3f}రుగుతున\u{c4d}న హృదయ\u{c3e}లు"),
            keywords: &[
                "త\u{c3f}రుగు",
                "త\u{c3f}రుగుతున\u{c4d}న హృదయ\u{c3e}లు",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дилҳои даврзананда"),
            keywords: &["даврзананда", "дилҳои даврзананда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจโคจร"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจโคจร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýlanýan ýürekler"),
            keywords: &["aýlanýan ýürekler", "pyrlanýan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo mafu takai"),
            keywords: &["ongo mafu takai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dönen kalpler"),
            keywords: &["aşk", "dönen", "dönen kalpler", "kalp", "kawaii", "sevimli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايلانغان يۈرەك"),
            keywords: &["ئايلانغان يۈرەك", "ئايلىنىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серця, що обертаються"),
            keywords: &["обертатися", "серце", "серця, що обертаються"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھومتے دل"),
            keywords: &["دل", "گھومتے دل", "گھومنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("aylanayotgan yuraklar"),
            keywords: &["aylanayotgan", "aylanayotgan yuraklar", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim xoay vòng"),
            keywords: &["trái tim xoay vòng", "đang quay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol buñ wëndeelu"),
            keywords: &["wëndeelu", "xol buñ wëndeelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iintliziyo ejikelezayo"),
            keywords: &["ejikelezayo", "iintliziyo ejikelezayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Ti O N Yi"),
            keywords: &["yíyí", "Ọkan Ti O N Yi"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("旋轉嘅心"),
            keywords: &["旋轉", "旋轉嘅心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("旋转嘅心"),
            keywords: &["旋转", "旋转嘅心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("舞动的心"),
            keywords: &["旋转", "涌动", "舞动的心", "跃动"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心之舞"),
            keywords: &["心之舞", "舞動的心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("循環心心"),
            keywords: &["循環心心", "舞動的心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinhliziyo ezizungezayo"),
            keywords: &["inhliziyo", "izinhliziyo ezizungezayo", "ukuzungeza"],
        },
    ],
};
#[doc = "💕"]
pub const TWO_HEARTS: crate::Emoji = crate::Emoji {
    glyph: "💕",
    codepoint: "1F495",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "two hearts",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("twee hartjies"),
            keywords: &["hart", "liefde", "twee hartjies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሁለት ልቦች"),
            keywords: &["ሁለት ልቦች", "ልብ", "ፍቅር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلبان"),
            keywords: &["أحبة", "حب", "قلبان", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9c1}খন হ\u{9c3}দয\u{9bc}"),
            keywords: &["দ\u{9c1}খন হ\u{9c3}দয\u{9bc}", "প\u{9cd}ৰেম"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("iki ürək"),
            keywords: &["iki ürək", "sevgi", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("два сэрцы"),
            keywords: &["два сэрцы", "каханне", "сэрцы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Две сърца"),
            keywords: &["Две сърца", "любов", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9c1}টি হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "দ\u{9c1}টি হ\u{9be}র\u{9cd}ট",
                "ভ\u{9be}লব\u{9be}স\u{9be}",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("div galon"),
            keywords: &["div galon", "kalon", "karantez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dva srca"),
            keywords: &["dva srca", "ljubav", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dos cors"),
            keywords: &["amor", "cor", "dos cors"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎵ ᏗᏓᏅᏙ"),
            keywords: &["ᎠᏓᎨᏳᏗ", "ᏔᎵ ᏗᏓᏅᏙ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dvě srdce"),
            keywords: &["dvě srdce", "láska", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwy galon"),
            keywords: &["calon", "cariad", "dwy galon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("to hjerter"),
            keywords: &["kærlighed", "romantik", "to hjerter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zwei Herzen"),
            keywords: &["Herz", "Liebe", "zwei Herzen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δύο καρδιές"),
            keywords: &["αγάπη", "δύο καρδιές", "καρδιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("two hearts"),
            keywords: &["love", "two hearts"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dos corazones"),
            keywords: &["amantes", "amor", "corazón", "dos corazones"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["amor", "corazón", "dos corazones", "enamorado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kaks südant"),
            keywords: &["armastus", "kaks südant", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bi bihotz"),
            keywords: &["bi bihotz", "bihotz", "maitasun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دو قلب"),
            keywords: &["دو قلب", "عشق", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaksi sydäntä"),
            keywords: &["kaksi sydäntä", "rakkaus", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dalawang puso"),
            keywords: &["dalawang puso", "pag-ibig", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tvey hjørtu"),
            keywords: &["kærleiki", "tvey hjørtu"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("deux cœurs"),
            keywords: &["amour", "cœurs", "deux cœurs"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("deux cœurs"),
            keywords: &["amour", "deux cœurs"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dhá chroí"),
            keywords: &["dhá chroí", "grá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dà chridhe"),
            keywords: &["dà chridhe", "gaol"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dous corazóns"),
            keywords: &["amor", "corazóns", "dous corazóns"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{ac7} દિલ"),
            keywords: &[
                "પ\u{acd}ર\u{ac7}મ",
                "પ\u{acd}ર\u{ac7}મીઓ",
                "બ\u{ac7} દિલ",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciyoyi biyu"),
            keywords: &["soyayye", "zuciyoyi biyu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שני לבבות"),
            keywords: &["אהבה", "לבבות", "שני לבבות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दो दिल"),
            keywords: &["दो दिल", "प\u{94d}यार", "प\u{94d}र\u{947}मी", "भावना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dva srca"),
            keywords: &["dva srca", "ljubav", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("két szív"),
            keywords: &["két szív", "szerelem", "szerelmes szívek", "szív", "szívek"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("երկու սրտեր"),
            keywords: &["երկու սրտեր", "սեր", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dua hati"),
            keywords: &["cinta", "dua hati", "hati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi àbụọ"),
            keywords: &["obi àbụọ", "ịhụnanya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tvö hjörtu"),
            keywords: &["elskendur", "tilfinningar", "tvö hjörtu", "ást"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("due cuori"),
            keywords: &["amore", "due cuori", "emozione", "innamorati"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("2つのハート"),
            keywords: &["2つのハート", "ハート", "ラブ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati loro"),
            keywords: &["ati loro", "katresnan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ორი გული"),
            keywords: &["გული", "ორი გული", "სიყვარული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қос жүрек"),
            keywords: &["жүрек", "махаббат", "қос жүрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("to hjerter"),
            keywords: &["kærlighed", "romantik", "to hjerter"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងព\u{17b8}រ"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងព\u{17b8}រ",
                "បេះដ\u{17bc}ងម\u{17bd}យគ\u{17bc}",
                "ស\u{17d2}នេហា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎರಡು ಹೃದಯಗಳು"),
            keywords: &["ಎರಡು ಹೃದಯಗಳು", "ಪ\u{ccd}ರೇಮ\u{cbf}ಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하트 두 개"),
            keywords: &["사랑", "연인", "하트 두 개"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोन काळजा\u{902}"),
            keywords: &["दोन काळजा\u{902}", "मोग"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кош жүрөк"),
            keywords: &["жүрөк", "кош", "сүйүү", "эки"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zwee Häerzer"),
            keywords: &["Léift", "zwee Häerzer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສອງອ\u{eb1}ນ"),
            keywords: &["ຄວາມຮ\u{eb1}ກ", "ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈສອງອ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dvi širdelės"),
            keywords: &["dvi širdelės", "meilė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("divas sirdis"),
            keywords: &["divas sirdis", "mīlestība", "sirds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rua manawa"),
            keywords: &["aroha", "rua manawa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("две срца"),
            keywords: &["две срца", "срце", "љубов"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("രണ\u{d4d}ട\u{d4d} ഹ\u{d43}ദയങ\u{d4d}ങൾ"),
            keywords: &[
                "പ\u{d4d}രണയം",
                "പ\u{d4d}രണയികൾ",
                "രണ\u{d4d}ട\u{d4d} ഹ\u{d43}ദയങ\u{d4d}ങൾ",
                "വിക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хоёр зүрх"),
            keywords: &["зүрх", "хайр дурлал", "хос", "хоёр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दोन ह\u{943}दय\u{947}"),
            keywords: &["दोन ह\u{943}दय\u{947}", "प\u{94d}र\u{947}म"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dua hati"),
            keywords: &["cinta", "dua hati", "hati"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żewġt iqlub"),
            keywords: &["imħabba", "żewġt iqlub"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}လ\u{102f}\u{1036}းန\u{103e}စ\u{103a}ခ\u{102f}"),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}းန\u{103e}စ\u{103a}ခ\u{102f}",
                "အချစ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("to hjerter"),
            keywords: &["elskere", "følelser", "kjærlighet", "to hjerter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("द\u{941}ईवटा म\u{941}ट\u{941}हर\u{942}"),
            keywords: &[
                "द\u{941}ईवटा म\u{941}ट\u{941}हर\u{942}",
                "माया",
                "म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("twee harten"),
            keywords: &["liefde", "twee harten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("to hjarte"),
            keywords: &["elskarar", "kjensler", "kjærleik", "to hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b41}ଇଟ\u{b3f} ହ\u{b43}ଦୟ"),
            keywords: &[
                "ଦ\u{b41}ଇଟ\u{b3f} ହ\u{b43}ଦୟ",
                "ପ\u{b4d}ରେମ",
                "ପ\u{b4d}ରେମୀ",
                "ଭ\u{b3e}ବନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a4b} ਦਿਲ"),
            keywords: &["ਜਜ\u{a3c}ਬਾਤ", "ਦ\u{a4b} ਦਿਲ", "ਪਿਆਰ", "ਪ\u{a4d}ਰ\u{a47}ਮੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دو دل"),
            keywords: &["دو دل", "پریم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tú Hat"),
            keywords: &["Lọv", "Tú Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dwa serca"),
            keywords: &["dwa serca", "kocham", "miłość", "serca"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوه زړونه"),
            keywords: &["دوه زړونه", "مینه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dois corações"),
            keywords: &["amantes", "amor", "dois corações", "emoção"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["amor", "coração", "corações", "dois corações"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("iskay sunqukuna"),
            keywords: &["iskay sunqukuna", "munay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("două inimioare"),
            keywords: &["afecțiune", "amor", "două inimioare", "dragoste", "iubire"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-594"),
            keywords: &["E10-594"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("два сердца"),
            keywords: &["влюбленные", "два сердца", "любовь", "чувства"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imitima ibiri"),
            keywords: &["imitima ibiri", "urukundo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻه دليون"),
            keywords: &["ٻه دليون", "پيار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හදවත\u{dca} දෙකක\u{dca}"),
            keywords: &["ආදරය", "හදවත", "හදවත\u{dca} දෙකක\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dve srdcia"),
            keywords: &["dve srdcia", "láska", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dve srci"),
            keywords: &["dve srci", "ljubezen", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("labo wadno"),
            keywords: &["jaceyl", "laba wadno", "labo wadno"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dy zemra"),
            keywords: &["dashuri", "dy zemra", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("два срца"),
            keywords: &["два срца", "срцe", "љубaв"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["два срца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dva srca"),
            keywords: &["dva srca", "ljubav", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["dva srca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("två hjärtan"),
            keywords: &["känslor", "kärlek", "två hjärtan"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mioyo miwili"),
            keywords: &["mioyo miwili", "moyo’ upendo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரு இதயங\u{bcd}கள\u{bcd}"),
            keywords: &[
                "இதயங\u{bcd}கள\u{bcd}",
                "இரண\u{bcd}டு இதயங\u{bcd}கள\u{bcd}",
                "இரு இதயங\u{bcd}கள\u{bcd}",
                "ஈருடல\u{bcd} ஓருயிர\u{bcd}",
                "க\u{bbe}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c46}ండు హృదయ\u{c3e}లు"),
            keywords: &["ర\u{c46}ండు", "ర\u{c46}ండు హృదయ\u{c3e}లు", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ду дил"),
            keywords: &["ду дил", "муҳаббат"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใจ 2 ดวง"),
            keywords: &["ร\u{e31}ก", "ใจ 2 ดวง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goşa ýürek"),
            keywords: &["goşa ýürek", "söýgi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo mafu"),
            keywords: &["ongo mafu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iki kalp"),
            keywords: &["aşk", "aşıklar", "duygu", "iki kalp"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوش يۈرەك"),
            keywords: &["سۆيگۈ", "قوش يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("два серця"),
            keywords: &["два серця", "кохання", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دو دل"),
            keywords: &["دل", "دو دل", "پیار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ikkita yurak"),
            keywords: &["ikkita yurak", "sevgi", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai trái tim"),
            keywords: &["hai trái tim", "yêu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ñaari xol"),
            keywords: &["mbëggeel", "ñaari xol"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iintliziyo ezimbini"),
            keywords: &["iintliziyo ezimbini", "uthando"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Ọkan Meji"),
            keywords: &["Awọn Ọkan Meji", "ìfẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("兩個心"),
            keywords: &["兩個心", "愛"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("两个心"),
            keywords: &["两个心", "爱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("两颗心"),
            keywords: &["两颗心", "爱情"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心心相印"),
            keywords: &["心心相印", "相愛"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinhliziyo ezimbili"),
            keywords: &["inhiziyo", "izinhliziyo ezimbili", "uthando"],
        },
    ],
};
#[doc = "💟"]
pub const HEART_DECORATION: crate::Emoji = crate::Emoji {
    glyph: "💟",
    codepoint: "1F49F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "heart decoration",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hartversiering"),
            keywords: &["hart", "hartversiering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የልብ ጌጥ"),
            keywords: &["ልብ", "የልብ ጌጥ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زخرفة قلب"),
            keywords: &["زخرفة قلب", "قلب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ৰ\u{9cd}ট সজোৱ\u{9be}"),
            keywords: &["হ\u{9be}ৰ\u{9cd}ট", "হ\u{9be}ৰ\u{9cd}ট সজোৱ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ürək bəzəyi"),
            keywords: &["ürək", "ürək bəzəyi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("стылізаванае сэрца"),
            keywords: &["стылізаванае сэрца", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Украса сърце"),
            keywords: &["Украса сърце", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}র\u{9cd}ট সজ\u{9cd}জ\u{9be}"),
            keywords: &["হ\u{9be}র\u{9cd}ট সজ\u{9cd}জ\u{9be}", "হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srce ukras"),
            keywords: &["srce", "srce ukras"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor decoratiu"),
            keywords: &["cor", "cor decoratiu"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏫ ᏗᏟᎶᏍᏔᏅ"),
            keywords: &["ᎤᎿᏫ", "ᎤᎿᏫ ᏗᏟᎶᏍᏔᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdce jako ozdoba"),
            keywords: &["srdce", "srdce jako ozdoba"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("addurn calon"),
            keywords: &["addurn calon", "calon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjertedekoration"),
            keywords: &["hjerte", "hjertedekoration"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herzdekoration"),
            keywords: &["Herz", "Herzdekoration"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά σε πλαίσιο"),
            keywords: &["καρδιά", "καρδιά σε πλαίσιο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heart decoration"),
            keywords: &["heart", "heart decoration"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("adorno de corazón"),
            keywords: &["adorno de corazón", "corazón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón de decoración"),
            keywords: &["corazón", "corazón de decoración"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("adorno de corazón"),
            keywords: &["adorno de corazón", "corazón"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("südamekujuline kaunistus"),
            keywords: &["süda", "südamekujuline kaunistus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz apaindua"),
            keywords: &["bihotz", "bihotz apaindua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب تزئینی"),
            keywords: &["تزئین", "قلب", "قلب تزئینی", "قلب تپنده", "قلب درخشان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sydänkoriste"),
            keywords: &["sydän", "sydänkoriste"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dekorasyong puso"),
            keywords: &["dekorasyong puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjarta pynt"),
            keywords: &["hjarta", "prýði", "pynt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("décoration avec cœur"),
            keywords: &["cœur", "décoration avec cœur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "décoration", "décoration avec cœur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("maisiúchán croí"),
            keywords: &["croí", "maisiúchán croí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgeadas cridhe"),
            keywords: &["cridhe", "sgeadas cridhe"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("decoración en forma de corazón"),
            keywords: &["corazón", "decoración", "decoración en forma de corazón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દિલનો શણગાર"),
            keywords: &["દિલ", "દિલનો શણગાર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("adon zuciya"),
            keywords: &["adon zuciya", "zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב בריבוע ורוד"),
            keywords: &["לב", "לב בריבוע ורוד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दिल की सजावट"),
            keywords: &["दिल", "दिल की सजावट"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ukras srca"),
            keywords: &["srce", "ukras srca"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szív formájú dekoráció"),
            keywords: &["dekoráció", "dísz", "szív", "szív formájú dekoráció"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սրտաձև նախշ"),
            keywords: &["նախշ", "սիրտ", "սրտաձև նախշ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dekorasi hati"),
            keywords: &["dekorasi hati", "hati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ịchọ mma obi"),
            keywords: &["obi", "ịchọ mma obi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skraut með hjarta"),
            keywords: &["hjarta", "skraut með hjarta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("decorazione con cuore"),
            keywords: &["cuore", "decorazione con cuore"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハートデコ"),
            keywords: &["ハート", "ハートデコ", "ハートデコレーション"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dhekorasi ati"),
            keywords: &["ati", "dhekorasi ati"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გულის დეკორაცია"),
            keywords: &["გული", "გულის დეკორაცია"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("декоративтік жүрек"),
            keywords: &["декоративтік жүрек", "жүрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hjertedekoration"),
            keywords: &["hjerte", "hjertedekoration"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17bb}ម\u{17d2}ពបេះដ\u{17bc}ង"),
            keywords: &["បេះដ\u{17bc}ង", "ព\u{17bb}ម\u{17d2}ពបេះដ\u{17bc}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೃದಯ ಅಲಂಕಾರ"),
            keywords: &["ಅಲಂಕರ\u{cbf}ತ ಹೃದಯ", "ಹೃದಯ ಅಲಂಕಾರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하트 장식"),
            keywords: &["하트", "하트 장식"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळीज श\u{94d}र\u{943}\u{902}गार"),
            keywords: &["काळीज", "काळीज श\u{94d}र\u{943}\u{902}गार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүрөк менен кооздолгон"),
            keywords: &["жүрөк", "жүрөк менен кооздолгон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Häerzdekoratioun"),
            keywords: &["Häerz", "Häerzdekoratioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ການຕ\u{ebb}ບແຕ\u{ec8}ງຫ\u{ebb}ວໃຈ"),
            keywords: &["ການຕ\u{ebb}ບແຕ\u{ec8}ງຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("širdelės dekoracija"),
            keywords: &["širdelės dekoracija", "širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sirds rotājums"),
            keywords: &["sirds", "sirds rotājums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rākeitanga manawa"),
            keywords: &["manawa", "rākeitanga manawa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("украс со срце"),
            keywords: &["срце", "украс", "украс со срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹ\u{d43}ദയ അലങ\u{d4d}ക\u{d3e}രം"),
            keywords: &["ഹ\u{d43}ദയ അലങ\u{d4d}ക\u{d3e}രം", "ഹ\u{d43}ദയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүрхэн чимэглэл"),
            keywords: &["зүрх", "зүрхэн чимэглэл", "чимэглэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सजावटीच\u{947} ह\u{943}दय"),
            keywords: &["सजावटीच\u{947} ह\u{943}दय", "ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hiasan hati"),
            keywords: &["hati", "hiasan hati"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("dekorazzjoni ta’ qalb"),
            keywords: &["dekorazzjoni ta’ qalb", "qalb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "န\u{103e}လ\u{102f}\u{1036}းဖြင\u{1037}\u{103a} အလ\u{103e}ပြင\u{103a}ဆင\u{103a}ခြင\u{103a}း",
            ),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}း",
                "န\u{103e}လ\u{102f}\u{1036}းဖြင\u{1037}\u{103a} အလ\u{103e}ပြင\u{103a}ခြင\u{103a}း",
                "န\u{103e}လ\u{102f}\u{1036}းဖြင\u{1037}\u{103a} အလ\u{103e}ပြင\u{103a}ဆင\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjertedekorasjon"),
            keywords: &["hjerte", "hjertedekorasjon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ट\u{941}को सजावट"),
            keywords: &["म\u{941}ट\u{941}", "म\u{941}ट\u{941}को सजावट"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("decoratief hart"),
            keywords: &["decoratief hart", "hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjartedekorasjon"),
            keywords: &["hjarte", "hjartedekorasjon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b43}ଦୟ ସ\u{b3e}ଜସଜ\u{b4d}ଜ\u{b3e}"),
            keywords: &["ହ\u{b43}ଦୟ", "ହ\u{b43}ଦୟ ସ\u{b3e}ଜସଜ\u{b4d}ଜ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਿਲ ਦੀ ਸਜਾਵਟ"),
            keywords: &["ਦਿਲ", "ਦਿਲ ਦੀ ਸਜਾਵਟ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دل دی سجاوٹ"),
            keywords: &["دل", "دل دی سجاوٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé Dẹm Mék Am Mék I Lúk Fain"),
            keywords: &[
                "Hat",
                "Hat Wé Dẹm Dẹkọrét Am",
                "Hat Wé Dẹm Mék Am Mék I Lúk Fain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dekoracja z sercem"),
            keywords: &["dekoracja", "dekoracja z sercem", "ozdoba"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سینګار زړه"),
            keywords: &["زړه", "سینګار زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração decorativo"),
            keywords: &["coração", "coração decorativo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["coração", "coração decorativo", "decoração com coração"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqu rikchay"),
            keywords: &["sunqu", "sunqu rikchay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("decorațiune inimă"),
            keywords: &["decor", "decorațiune inimă", "inimă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-604"),
            keywords: &["E10-604"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «сердце»"),
            keywords: &[
                "белое",
                "значок \"сердце\"",
                "значок «сердце»",
                "квадрат",
                "красное",
                "куб",
                "розовый",
                "сердце",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuteguro w’imitima"),
            keywords: &["umuteguro w’imitima", "umutima"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دل جي سجاوٽ"),
            keywords: &["دل", "دل جي سجاوٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හදවත\u{dca} සැරස\u{dd2}ල\u{dca}ල"),
            keywords: &["හදවත", "හදවත\u{dca} සැරස\u{dd2}ල\u{dca}ල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ozdoba v tvare srdca"),
            keywords: &["ozdoba v tvare srdca", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("okrasje s srcem"),
            keywords: &["okrasje s srcem", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qurxinta wadnaha"),
            keywords: &["qurxinta wadnaha", "wadno"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dekorim me zemër"),
            keywords: &["dekorim me zemër", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("украс са срцем"),
            keywords: &["срцe", "украс са срцем"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ukras sa srcem"),
            keywords: &["srce", "ukras sa srcem"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärtdekoration"),
            keywords: &["hjärta", "hjärtdekoration"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mapambo ya moyo"),
            keywords: &["mapambo ya moyo", "moyo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அலங\u{bcd}கரிக\u{bcd}கப\u{bcd}பட\u{bcd}ட இதயம\u{bcd}"),
            keywords: &[
                "அலங\u{bcd}கரிக\u{bcd}கப\u{bcd}பட\u{bcd}ட இதயம\u{bcd}",
                "அலங\u{bcd}க\u{bbe}ரம\u{bcd}",
                "இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("హృదయ అలంకరణ"),
            keywords: &["అలంకరణ", "హృదయ అలంకరణ", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ороиши дил"),
            keywords: &["дил", "ороиши дил"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจประด\u{e31}บ"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจประด\u{e31}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýürek bezegi"),
            keywords: &["ýürek", "ýürek bezegi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu teuteuʻi"),
            keywords: &["mafu teuteuʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kalpli dekorasyon"),
            keywords: &["kalp", "kalpli dekorasyon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈرەك بېزەك"),
            keywords: &["يۈرەك", "يۈرەك بېزەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("прикраса із серцем"),
            keywords: &["прикраса із серцем", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دل کی ڈیکوریشن"),
            keywords: &["دل", "دل کی ڈیکوریشن", "ڈیکوریشن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yurak bezagi"),
            keywords: &["yurak", "yurak bezagi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hình trang trí trái tim"),
            keywords: &["hình trang trí trái tim", "trái tim"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("taaralukaayu xol"),
            keywords: &["taaralukaayu xol", "xol"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umhombiso wentliziyo"),
            keywords: &["intliziyo", "umhombiso wentliziyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Ti A Ṣe Lọṣọ"),
            keywords: &["Ọkan Ti A Ṣe Lọṣọ", "ọkàn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("心形裝飾"),
            keywords: &["心", "心形裝飾"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("心形装饰"),
            keywords: &["心", "心形装饰"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("心型装饰"),
            keywords: &["心型装饰", "装饰"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心在框框裡"),
            keywords: &["心在框框裡", "心型"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("心形裝飾"),
            keywords: &["心型", "心形裝飾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuhlobisa inhliziyo"),
            keywords: &["inhliziyo", "ukuhlobisa inhliziyo"],
        },
    ],
};
#[doc = "❣\u{fe0f}"]
pub const HEART_EXCLAMATION: crate::Emoji = crate::Emoji {
    glyph: "❣\u{fe0f}",
    codepoint: "2763 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "heart exclamation",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "❣",
        codepoint: "2763",
        status: crate::Status::Unqualified,
        introduction_version: 1f32,
        name: "heart exclamation",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dik hartuitroepteken"),
            keywords: &[
                "dik hartuitroepteken",
                "hart",
                "leesteken",
                "teken",
                "uitroep",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በልብ ቅርፅ የተዘጋጀ የቃለ አጋኖ ምልክት"),
            keywords: &[
                "ልብ",
                "ምልክት",
                "ሥርዓተ ነጥብ",
                "ቃለ አጋኖ",
                "በልብ ቅርፅ የተዘጋጀ የቃለ አጋኖ ምልክት",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب على شكل علامة تعجب"),
            keywords: &["تعجب", "علامة تعجب", "قلب", "قلب على شكل علامة تعجب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9c3}দয\u{9bc}ৰ চিত\u{9cd}ৰ সম\u{9cd}বলিত ভ\u{9be}ববোধক চিন"),
            keywords: &[
                "চিন",
                "ভ\u{9be}ববোধক",
                "যতি-চিহ\u{9cd}ন",
                "হ\u{9c3}দয\u{9bc}ৰ চিত\u{9cd}ৰ সম\u{9cd}বলিত ভ\u{9be}ববোধক চিন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ürək nida işarəsi ornamenti"),
            keywords: &[
                "durğu işarəsi",
                "işarə",
                "nida",
                "ürək",
                "ürək nida işarəsi ornamenti",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("клічнік у форме сэрца"),
            keywords: &[
                "знак",
                "знак прыпынку",
                "клічнік",
                "клічнік у форме сэрца",
                "сэрца",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Плътен орнамент от сърце – удивителна"),
            keywords: &[
                "Плътен орнамент от сърце – удивителна",
                "пунктуация",
                "сърце",
                "удивителна",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}র\u{9cd}টের আক\u{9be}রের বিস\u{9cd}ময\u{9bc}স\u{9c2}চক চিহ\u{9cd}ন"),
            keywords: &[
                "চিহ\u{9cd}ন",
                "বির\u{9be}ম চিহ\u{9cd}ন",
                "বিস\u{9cd}ময\u{9bc}বোধক",
                "হ\u{9be}র\u{9cd}টের আক\u{9be}রের বিস\u{9cd}ময\u{9bc}স\u{9c2}চক চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uzvičnik u obliku srca"),
            keywords: &[
                "simbol",
                "srce",
                "uzvičnik",
                "uzvičnik u obliku srca",
                "znak",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("exclamació en forma de cor"),
            keywords: &[
                "cor",
                "exclamació",
                "exclamació en forma de cor",
                "puntuació",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᎨᏓ ᎤᎿᏫ ᏍᏓᏱ ᎥᎧᏁᎬᎢ"),
            keywords: &["ᎤᏓᎨᏓ ᎤᎿᏫ ᏍᏓᏱ ᎥᎧᏁᎬᎢ", "ᎪᏪᎸ", "ᏍᏓᏱ ᎥᎧᏁᎬᎢ", "ᏚᏙᏪᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdce jako vykřičník"),
            keywords: &[
                "interpunkce",
                "srdce",
                "srdce jako vykřičník",
                "vykřičník",
                "znaménko",
                "značka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ebychiad trwm galon"),
            keywords: &[
                "atalnodiad",
                "calon",
                "ebychiad",
                "ebychiad trwm galon",
                "marc",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerte som udråbstegn"),
            keywords: &[
                "hjerte",
                "hjerte som udråbstegn",
                "tegnsætning",
                "udråbstegn",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz als Ausrufezeichen"),
            keywords: &[
                "Ausrufezeichen",
                "Herz",
                "Herz als Ausrufezeichen",
                "Satzzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά θαυμαστικό"),
            keywords: &["θαυμαστικό", "καρδιά", "σημείο", "στίξη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heart exclamation"),
            keywords: &["exclamation", "heart exclamation", "mark", "punctuation"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("exclamación de corazón"),
            keywords: &[
                "corazón",
                "exclamación",
                "exclamación de corazón",
                "puntuación",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("exclamación con forma de corazón"),
            keywords: &["corazón", "exclamación", "exclamación con forma de corazón"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("südamega hüüumärk"),
            keywords: &[
                "hüüumärk",
                "kirjavahemärk",
                "märk",
                "süda",
                "südamega hüüumärk",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz-itxurako harridura-marka"),
            keywords: &[
                "bihotz",
                "bihotz-itxurako harridura-marka",
                "harridura",
                "marka",
                "puntuazioa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت تعجب قلبی"),
            keywords: &[
                "سجاوندی",
                "علامت",
                "علامت تعجب",
                "علامت تعجب قلبی",
                "قلب",
                "نشانه\u{200c}گذاری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sydänhuutomerkki"),
            keywords: &["huutomerkki", "sydän", "sydänhuutomerkki", "välimerkit"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("malaking tandang padamdam na hugis-puso"),
            keywords: &[
                "bantas",
                "malaking tandang padamdam na hugis-puso",
                "pananda",
                "puso",
                "tandang padamdam",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjarta rópitekn"),
            keywords: &["hjarta", "rópitekn", "teknseting"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur point d’exclamation"),
            keywords: &[
                "cœur",
                "cœur point d’exclamation",
                "exclamation",
                "ponctuation",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "cœur point d’exclamation", "exclamation", "point"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha uaillbhreasa croí"),
            keywords: &["comhartha uaillbhreasa croí", "marc", "poncaíocht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("clisg-phuing cridhe"),
            keywords: &["!", "clisg-phuing", "comharra", "cridhe", "puingeachadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("exclamación en forma de corazón"),
            keywords: &[
                "admiración",
                "corazón",
                "exclamación en forma de corazón",
                "puntuación",
                "signo de exclamación",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉદ\u{acd}ગારવાચક ચિહ\u{acd}ન સાથ\u{ac7}ન\u{ac1}\u{a82} હ\u{ac3}દય"),
            keywords: &[
                "ઉદ\u{acd}ગારવાચક",
                "ઉદ\u{acd}ગારવાચક ચિહ\u{acd}ન સાથ\u{ac7}ન\u{ac1}\u{a82} હ\u{ac3}દય",
                "ચિહ\u{acd}ન",
                "વિરામચિહ\u{acd}ન",
                "હ\u{ac3}દય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar motsin rai na nauyin zuciya"),
            keywords: &[
                "alama",
                "alamar motsin rai",
                "alamar motsin rai na nauyin zuciya",
                "alamomin rubutu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן קריאה בצורת לב"),
            keywords: &["אהבה", "לב", "סימן קריאה", "סימן קריאה בצורת לב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विस\u{94d}मय चिह\u{94d}न वाला दिल"),
            keywords: &["गहना", "विस\u{94d}मय चिह\u{94d}न वाला दिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uskličnik u obliku srca"),
            keywords: &[
                "interpunkcija",
                "srce",
                "uskličnik",
                "uskličnik u obliku srca",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nagy szív alakú felkiáltójel"),
            keywords: &[
                "központozás",
                "nagy szív alakú felkiáltójel",
                "szív",
                "írásjel",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բացականչական նշանի տեսքով սիրտ"),
            keywords: &[
                "բացականչական նշանի տեսքով սիրտ",
                "բացականչություն",
                "կետադրական",
                "նշան",
                "սիրտ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tanda seru berbentuk hati"),
            keywords: &["hati", "seru", "tanda", "tanda seru berbentuk hati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nnukwu obi ntimkpu"),
            keywords: &["akara", "nnukwu obi ntimkpu", "ntimkpu", "ntụpọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjarta sem upphrópunarmerki"),
            keywords: &[
                "greinarmerki",
                "hjarta",
                "hjarta sem upphrópunarmerki",
                "merki",
                "upphrópunarmerki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("punto esclamativo a cuore"),
            keywords: &[
                "cuore",
                "punteggiatura",
                "punto esclamativo",
                "punto esclamativo a cuore",
                "simbolo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハートのびっくり"),
            keywords: &[
                "びっくりマーク",
                "エクスクラメーションマーク",
                "ハート",
                "ハートのびっくり",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha penthung wujude ati"),
            keywords: &[
                "mbangetake",
                "tandha",
                "tandha penthung wujude ati",
                "tandha wacan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გულის ფორმის მსხვილი ძახილის ნიშანი"),
            keywords: &[
                "გული",
                "გულის ფორმის მსხვილი ძახილის ნიშანი",
                "ნიშანი",
                "პუნქტუაცია",
                "ძახილი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("леп белгісі тәрізді жүрек"),
            keywords: &[
                "белгі",
                "жүрек",
                "леп белгісі",
                "леп белгісі тәрізді жүрек",
                "пунктуация",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hjerte som udråbstegn"),
            keywords: &[
                "hjerte",
                "hjerte som udråbstegn",
                "tegnsætning",
                "udråbstegn",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាឧទានរ\u{17bc}បបេះដ\u{17bc}ង"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "សញ\u{17d2}ញាឧទាន",
                "សញ\u{17d2}ញាឧទានរ\u{17bc}បបេះដ\u{17bc}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೃದಯ ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಗುರುತು"),
            keywords: &[
                "ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ",
                "ಗುರುತು",
                "ವ\u{cbf}ರಾಮಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ಹೃದಯ ಆಶ\u{ccd}ಚರ\u{ccd}ಯ ಗುರುತು",
                "ಹೃದಯದ ಆಶ\u{ccd}ಚರ\u{ccd}ಯಸ\u{cc2}ಚಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("하트 모양 느낌표"),
            keywords: &["느낌표", "하트", "하트 모양 느낌표"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळीज उदगारचिन\u{94d}न"),
            keywords: &[
                "उदगारचिन\u{94d}न",
                "काळीज उदगारचिन\u{94d}न",
                "ख\u{942}ण",
                "विरामचिन\u{94d}न",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүрөк менен жазылган илеп белгиси"),
            keywords: &[
                "белги",
                "жүрөк",
                "жүрөк менен жазылган илеп белгиси",
                "илеп",
                "пунктуация",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("fettgedréckt Häerzausruffzeechen"),
            keywords: &[
                "Ausruff",
                "Interpunktioun",
                "Zeechen",
                "fettgedréckt Häerzausruffzeechen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງເປ\u{eb1}ນຮ\u{eb9}ບຫ\u{ebb}ວໃຈໃຫຍ\u{ec8}"),
            keywords: &[
                "ຕ\u{ebb}ກໃຈ",
                "ຫ\u{ebb}ວໃຈ",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍທ\u{ec9}ວງເປ\u{eb1}ນຮ\u{eb9}ບຫ\u{ebb}ວໃຈໃຫຍ\u{ec8}",
                "ເຄ\u{eb7}\u{ec8}ອງໝາຍວ\u{eb1}ກຕອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("storas širdelės formos šauktukas"),
            keywords: &[
                "skyryba",
                "storas širdelės formos šauktukas",
                "šauktukas",
                "širdis",
                "ženklas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("izsaukuma zīme sirds formā"),
            keywords: &[
                "izsaukuma zīme sirds formā",
                "izsaukums",
                "pieturzīme",
                "sirds",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohuhā manawa pā"),
            keywords: &["tohu", "tohu reo", "tohuhā", "tohuhā manawa pā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("извичник во вид на срце"),
            keywords: &[
                "знак",
                "извичник",
                "извичник во вид на срце",
                "интерпункциски знак",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഹ\u{d43}ദയ\u{d3e}ക\u{d43}തിയില\u{d41}ള\u{d4d}ള ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
            ),
            keywords: &[
                "ആശ\u{d4d}ചര\u{d4d}യം",
                "ചിഹ\u{d4d}നം",
                "ഹ\u{d43}ദയം",
                "ഹ\u{d43}ദയ\u{d3e}ക\u{d43}തിയില\u{d41}ള\u{d4d}ള അടയ\u{d3e}ളം",
                "ഹ\u{d43}ദയ\u{d3e}ക\u{d43}തിയില\u{d41}ള\u{d4d}ള ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
                "ഹ\u{d43}ദയ\u{d3e}ക\u{d43}തിയിലെ ആശ\u{d4d}ചര\u{d4d}യ ചിഹ\u{d4d}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүрхэн хэлбэртэй анхааруулгын тэмдэг"),
            keywords: &[
                "анхааруулга",
                "зүрх",
                "зүрхэн хэлбэртэй анхааруулгын тэмдэг",
                "тэмдэг",
                "хэлбэр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ह\u{943}दय असल\u{947}ल\u{947} उद\u{94d}गारवाचक चिन\u{94d}ह"),
            keywords: &[
                "उद\u{94d}गारवाचक चिन\u{94d}ह",
                "चिन\u{94d}ह",
                "विरामचिन\u{94d}ह",
                "ह\u{943}दय असल\u{947}ल\u{947} उद\u{94d}गारवाचक चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tanda seru hati"),
            keywords: &["tanda", "tanda baca", "tanda seru", "tanda seru hati"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("esklamazzjoni ta’ qalb miġugħa"),
            keywords: &[
                "esklamazzjoni",
                "esklamazzjoni ta’ qalb miġugħa",
                "marka",
                "punteġġjatura",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လေးလ\u{1036}သည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းပ\u{102f}\u{1036}စ\u{1036} အာမေဍ\u{102d}တ\u{103a}အတ\u{103d}\u{1032}",
            ),
            keywords: &[
                "ပ\u{102f}ဒ\u{103a}ဖြတ\u{103a}ပ\u{102f}ဒ\u{103a}ရပ\u{103a}",
                "လေးလ\u{1036}သည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}းပ\u{102f}\u{1036}စ\u{1036} အာမေဍ\u{102d}တ\u{103a}အတ\u{103d}\u{1032}",
                "အမ\u{103e}တ\u{103a}အသား",
                "အာမေဍ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("utropstegn med hjerte"),
            keywords: &[
                "tegn",
                "tegnsetting",
                "utrop",
                "utropstegn",
                "utropstegn med hjerte",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गाढा म\u{941}ट\u{941}को विस\u{94d}मयाधिबोधक चिन\u{94d}हको सजावट"),
            keywords: &[
                "गाढा म\u{941}ट\u{941}को विस\u{94d}मयाधिबोधक चिन\u{94d}हको सजावट",
                "चिन\u{94d}ह",
                "म\u{941}ट\u{941}",
                "विराम चिन\u{94d}ह",
                "विस\u{94d}मयाधिबधक चिन\u{94d}ह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hart als uitroepteken"),
            keywords: &["hart als uitroepteken", "interpunctie", "teken", "uitroep"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("utropsteikn med hjarte"),
            keywords: &[
                "teikn",
                "teiknsetjing",
                "utrop",
                "utropsteikn",
                "utropsteikn med hjarte",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b43}ଦୟ ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ର\u{b3e}ମଚ\u{b3f}ହ\u{b4d}ନ",
                "ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ",
                "ହ\u{b43}ଦୟ ବ\u{b3f}ସ\u{b4d}ମୟସ\u{b42}ଚକ ଚ\u{b3f}ହ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਜਾਵਟੀ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਦਿਲ",
                "ਵਿਰਾਮ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਸਜਾਵਟੀ ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਹ\u{a48}ਰਾਨੀਵਾਚਕ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دل دی زور دا پ\u{64f}کار"),
            keywords: &[
                "دل دی زور دا پ\u{64f}کار",
                "رموز اوقاف",
                "نشان لانا",
                "چیخ و پکار",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé Dẹm Ték Mék Ẹsklaméshọ\u{301}n Mak"),
            keywords: &[
                "Hat Wé Dẹm Ték Mék Ẹsklaméshọ\u{301}n Mak",
                "Mak",
                "Pọnchuéshọn Mak",
                "Ẹsklaméshọn Mak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wykrzyknik w kształcie serca"),
            keywords: &[
                "czerwony wykrzyknik",
                "serce",
                "wykrzyknik",
                "wykrzyknik w kształcie serca",
                "znak interpunkcyjny",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د زړه ندا"),
            keywords: &["د زړه ندا", "ندا", "نښه", "وقفه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("exclamação de coração"),
            keywords: &[
                "exclamação",
                "exclamação de coração",
                "exclamação em forma de coração",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ponto de exclamação com coração"),
            keywords: &[
                "exclamação",
                "ponto de exclamação com coração",
                "pontuação",
                "sinal",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqu exclamasion"),
            keywords: &["exclamasion", "marka", "puntuacion", "sunqu exclamasion"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul exclamării cu inimioară"),
            keywords: &[
                "punctuație",
                "semnul exclamării",
                "semnul exclamării cu inimioară",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-146"),
            keywords: &["E10-146"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("восклицательный знак в виде сердца"),
            keywords: &[
                "восклицание",
                "восклицательный знак в виде сердца",
                "знак",
                "препинания",
                "сердце",
                "сердце в виде восклицательного знака",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akamenyetso k’umutima gatangara"),
            keywords: &[
                "agatangaro",
                "akamenyetso k’umutima gatangara",
                "akarango",
                "akatuzo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دل واري عجب جي نشاني"),
            keywords: &["دل واري عجب جي نشاني", "عجب", "مارڪ", "پنڪچويشن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හදවතක හැඩය ගත\u{dca} ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ"),
            keywords: &[
                "ලක\u{dd4}ණ",
                "වස\u{dca}මය\u{dcf}ර\u{dca}ථ",
                "ව\u{dd2}ර\u{dcf}ම ලක\u{dd4}ණ",
                "හදවතක හැඩය ගත\u{dca} ව\u{dd2}ස\u{dca}මය\u{dcf}ර\u{dca}ථ ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("výkričník v tvare srdca"),
            keywords: &[
                "interpunkcia",
                "srdce",
                "výkričník v tvare srdca",
                "znak",
                "zvolanie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("klicaj v obliki srca"),
            keywords: &["klicaj", "klicaj v obliki srca", "ločilo", "srce", "znak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("claamad ujeedka wadnaha"),
            keywords: &[
                "amkaag",
                "astaameyn",
                "calaamad",
                "calaamad ujeedka wadnaha",
                "claamad ujeedka wadnaha",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zbukurim i trashë me pikëçuditje me zemër"),
            keywords: &[
                "pikësim",
                "pikëçuditje",
                "shenjë",
                "zbukurim i trashë me pikëçuditje me zemër",
                "zemër",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("украсни узвичник у облику великог срца"),
            keywords: &[
                "интeрпункциja",
                "срцe",
                "узвичник",
                "украсни узвичник у облику великог срца",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["украсни узвичник у облику великог срца"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ukrasni uzvičnik u obliku velikog srca"),
            keywords: &[
                "interpunkcija",
                "srce",
                "ukrasni uzvičnik u obliku velikog srca",
                "uzvičnik",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ukrasni uzvičnik u obliku velikog srca"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("utropstecken i form av ett hjärta"),
            keywords: &[
                "hjärta",
                "utropstecken",
                "utropstecken i form av ett hjärta",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("umbo la moyo lenye alama ya mshangao"),
            keywords: &[
                "alama",
                "moyo wenye mshangao",
                "mshangao",
                "uakifishaji",
                "umbo la moyo lenye alama ya mshangao",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அளவுக\u{bcd}கதிகம\u{bbe}ன க\u{bbe}தல\u{bcd}"),
            keywords: &[
                "அதிக க\u{bbe}தல\u{bcd}",
                "அளவுக\u{bcd}கதிகம\u{bbe}ன க\u{bbe}தல\u{bcd}",
                "உணர\u{bcd}ச\u{bcd}சி",
                "உணர\u{bcd}வு",
                "க\u{bbe}தல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తుత\u{c4b} ఉన\u{c4d}న భ\u{c3e}రమ\u{c48}న నగ",
            ),
            keywords: &[
                "ఆశ\u{c4d}చర\u{c4d}యం",
                "ఆశ\u{c4d}చర\u{c4d}య\u{c3e}ర\u{c4d}థకం గుర\u{c4d}తుత\u{c4b} ఉన\u{c4d}న భ\u{c3e}రమ\u{c48}న నగ",
                "నగ",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хитоби дили вазнин"),
            keywords: &[
                "аломат",
                "аломатҳои китобатӣ",
                "хитоб",
                "хитоби дили вазнин",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ร\u{e39}ปห\u{e31}วใจ"),
            keywords: &[
                "เคร\u{e37}\u{e48}องหมาย",
                "เคร\u{e37}\u{e48}องหมายวรรคตอน",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}",
                "เคร\u{e37}\u{e48}องหมายอ\u{e31}ศเจร\u{e35}ย\u{e4c}ร\u{e39}ปห\u{e31}วใจ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýürekli ýüzlenme"),
            keywords: &[
                "belgi",
                "dyngy",
                "goýy ýürekli ýüzlenme",
                "ýürekli ýüzlenme",
                "ýüzlenme",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu fakaʻilonga kalanga"),
            keywords: &["mafu fakaʻilonga kalanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kalp şeklinde ünlem işareti"),
            keywords: &[
                "işaret",
                "kalp",
                "kalp şeklinde ünlem işareti",
                "noktalama",
                "ünlem işareti",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈرەكلىك ئۈندەش"),
            keywords: &["ئۈندەش", "بەلگە", "تىنىش", "يۈرەكلىك ئۈندەش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("знак оклику у формі серця"),
            keywords: &[
                "знак оклику у формі серця",
                "оклик",
                "пунктуація",
                "розділовий знак",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دلی اظہار"),
            keywords: &[
                "دلی اظہار",
                "رموز\u{650} اوقاف",
                "علامت",
                "علامت\u{650} ندائیہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yurak shaklidagi undov belgisi"),
            keywords: &[
                "belgi",
                "tinish belgisi",
                "undov",
                "yurak shaklidagi undov",
                "yurak shaklidagi undov belgisi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chấm than hình trái tim đậm"),
            keywords: &[
                "chấm câu",
                "cảm thán",
                "dấu",
                "dấu chấm than hình trái tim đậm",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol esklamaasiyoŋ bu fës"),
            keywords: &[
                "esklamaasiyoŋ",
                "màndarga",
                "tomb",
                "xol esklamaasiyoŋ bu fës",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isikhuzo sentliziyo enzima"),
            keywords: &[
                "isikhuzo",
                "isikhuzo sentliziyo enzima",
                "isiphumlisi",
                "uphawu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àmì ìyanú ọkàn tó wúwo"),
            keywords: &["àmì", "àmì ìyanu", "àmì ìyanú ọkàn tó wúwo", "ìfàmìsí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("沉重嘅感嘆嘅"),
            keywords: &["感嘆嘅", "標點符號", "沉重嘅感嘆嘅", "符號"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("沉重嘅感叹嘅"),
            keywords: &["感叹嘅", "标点符号", "沉重嘅感叹嘅", "符号"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("心叹号"),
            keywords: &["叹号", "心动", "心叹号"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心嘆號"),
            keywords: &["心嘆號", "心型驚嘆號"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["心嘆號", "心型感嘆號"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isibabazi senhliziyo edangele"),
            keywords: &[
                "inhliziyo",
                "isibabazi",
                "isibabazi senhliziyo edangele",
                "uphawu",
            ],
        },
    ],
};
#[doc = "💔"]
pub const BROKEN_HEART: crate::Emoji = crate::Emoji {
    glyph: "💔",
    codepoint: "1F494",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "broken heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gebroke hartjie"),
            keywords: &["breek", "gebroke", "gebroke hartjie", "hart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተሰበረ ልብ"),
            keywords: &["ልብ", "ሰበረ", "የተሰበረ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب مكسور"),
            keywords: &["انكسار", "قلب", "قلب مكسور", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভগ\u{9cd}ন হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "ভগ\u{9cd}ন হ\u{9c3}দয\u{9bc}",
                "ভঙ\u{9be}",
                "ভ\u{9be}ঙি যোৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sınmış ürək"),
            keywords: &["sındırmaq", "sındırılmış", "sınmış ürək", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("разбітае сэрца"),
            keywords: &["разбітае", "расчараванне", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Разбито сърце"),
            keywords: &["Разбито сърце", "разбито", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}ঙ\u{9cd}গ\u{9be} হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "ভ\u{9be}ঙ\u{9be}",
                "ভ\u{9be}ঙ\u{9cd}গ\u{9be} হ\u{9be}র\u{9cd}ট",
                "ভেঙে য\u{9be}ওয\u{9bc}\u{9be}",
                "হ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon rannet"),
            keywords: &["kalon", "kalon rannet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("slomljeno srce"),
            keywords: &["patnja", "slomljeno", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor trencat"),
            keywords: &["cor", "trencar", "trencat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏲᏨᎢ ᎤᎿᏫ"),
            keywords: &["ᎤᏲᏨᎢ", "ᎤᏲᏨᎢ ᎤᎿᏫ", "ᎯᏲᏍᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zlomené srdce"),
            keywords: &["srdce", "zlomené srdce", "zlomený", "zlomit"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon wedi torri"),
            keywords: &["calon", "calon wedi torri", "torri"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("knust hjerte"),
            keywords: &["knust hjerte", "ulykkelig kærlighed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gebrochenes Herz"),
            keywords: &["Schmerz", "Trennung", "gebrochenes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ραγισμένη καρδιά"),
            keywords: &["καρδιά", "ραγισμένη καρδιά", "σπάω", "σπασμένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("broken heart"),
            keywords: &["break", "broken", "broken heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón roto"),
            keywords: &["corazón", "emoción", "partido", "roto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón roto"),
            keywords: &["corazón roto"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["corazón", "mal", "roto", "sufrir", "triste"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["corazón", "mal", "roto", "sufrir", "triste"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("murtud süda"),
            keywords: &["murtud", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz hautsia"),
            keywords: &["bihotz", "bihotz hautsia", "hautsi", "hautsita"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب شکسته"),
            keywords: &["شکستن", "شکسته", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("särkynyt sydän"),
            keywords: &["sydän", "särkynyt", "särkyä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("durog na puso"),
            keywords: &["bigo", "broken heart", "durog na puso", "pag-ibig", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brotið hjarta"),
            keywords: &["brotið", "hjarta", "sorgarbundin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur brisé"),
            keywords: &["cœur", "cœur brisé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["brisé", "cœur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croíbhriste"),
            keywords: &["brón", "croí", "croíbhriste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe briste"),
            keywords: &["briseadh", "briste", "cridhe briste"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón roto"),
            keywords: &["corazón", "desamor", "romper o corazón", "roto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભગ\u{acd}ન હ\u{ac3}દય"),
            keywords: &[
                "તોડવ\u{ac1}\u{a82}",
                "ભગ\u{acd}ન",
                "લાગણી",
                "હ\u{ac3}દય",
                "હ\u{ac3}દય ભ\u{a82}ગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("karyayyiyar zuciya"),
            keywords: &["karyayyiyar zuciya", "karye", "karyeyye"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב שבור"),
            keywords: &["אכזבה", "לב", "שבור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ट\u{942}टा दिल"),
            keywords: &[
                "ट\u{942}टना",
                "ट\u{942}टा दिल",
                "ट\u{942}टा ह\u{941}आ",
                "दिल",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("slomljeno srce"),
            keywords: &["slomljeno", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("összetört szív"),
            keywords: &["szív", "összetört"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կոտրված սիրտ"),
            keywords: &["կոտրել", "կոտրված", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("patah hati"),
            keywords: &["hati", "patah", "putus"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi ntiwa"),
            keywords: &["gbajie", "ntiwa", "obi ntiwa"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brostið hjarta"),
            keywords: &["brostið", "hjarta", "ástarsorg"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore infranto"),
            keywords: &["cuore", "emozione", "infranto", "spezzato"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("割れたハート"),
            keywords: &["ハート", "別れた", "割れたハート", "失恋"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lara ati"),
            keywords: &["kelaran", "lara", "lara ati"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გატეხილი გული"),
            keywords: &["გატეხვა", "გატეხილი", "გული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сынған жүрек"),
            keywords: &["жүрек", "сыну", "сынған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("knust hjerte"),
            keywords: &["knust hjerte", "ulykkelig kærlighed"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងបែកជាព\u{17b8}រ"),
            keywords: &[
                "បេះដ\u{17bc}ងបែកជាព\u{17b8}រ",
                "បេះដ\u{17bc}ងប\u{17d2}រេះស\u{17d2}រា\u{17c6}",
                "បែកបេះដ\u{17bc}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಒಡ\u{cc6}ದ\u{cbf}ರುವ ಹೃದಯ"),
            keywords: &[
                "ಒಡ\u{cc6}ದ ಹೃದಯ",
                "ಒಡ\u{cc6}ದ\u{cbf}ರುವ ಹೃದಯ",
                "ಹೃದಯ ಮುರ\u{cbf}ಯುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("깨진 하트"),
            keywords: &[
                "결별",
                "깨진 하트",
                "이별",
                "이별의 고통",
                "이별의 아픔",
                "헤어짐",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भ\u{902}ग पाविल\u{94d}ल\u{947}\u{902} काळीज"),
            keywords: &[
                "भ\u{902}ग",
                "भ\u{902}ग जाल\u{94d}ल\u{947}\u{902}",
                "भ\u{902}ग जाल\u{94d}ल\u{947}\u{902} काळीज",
                "भ\u{902}ग पाविल\u{94d}ल\u{947}\u{902} काळीज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жараланган жүрөк"),
            keywords: &["жараланган", "жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gebrachent Häerz"),
            keywords: &["briechen", "gebrach", "gebrachent Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈແຕກ"),
            keywords: &["ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈແຕກ", "ອ\u{ebb}ກຮ\u{eb1}ກ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sudaužyta širdelė"),
            keywords: &["sudaužyta", "sudaužyta širdelė", "sudaužyti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("salauzta sirds"),
            keywords: &["salauzt", "salauzta sirds", "sirds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa whati"),
            keywords: &["manawa whati", "pakaru", "whati"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("скршено срце"),
            keywords: &["крши", "скршено", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തകർന\u{d4d}ന ഹ\u{d43}ദയം"),
            keywords: &[
                "തകര\u{d41}ക",
                "തകർന\u{d4d}ന ഹ\u{d43}ദയം",
                "തകർന\u{d4d}ന\u{d41}",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шархалсан зүрх"),
            keywords: &["зүрх", "шархалсан зүрх", "шархлах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{941}टल\u{947}ल\u{947} ह\u{943}दय"),
            keywords: &[
                "त\u{941}टण\u{947}",
                "त\u{941}टल\u{947}ल\u{947}",
                "त\u{941}टल\u{947}ल\u{947} ह\u{943}दय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("patah hati"),
            keywords: &["hati", "patah hati", "retak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb maqsuma"),
            keywords: &["kisser", "maqsuma", "qalb maqsuma"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အက\u{103a}က\u{103d}\u{1032}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "က\u{103d}\u{1032}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
                "က\u{103d}\u{1032}နေသော",
                "အက\u{103a}က\u{103d}\u{1032}",
                "အက\u{103a}က\u{103d}\u{1032}နေသည\u{1037}\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("knust hjerte"),
            keywords: &["brudd", "følelser", "hjerte", "knust hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ट\u{941}क\u{94d}रिएको म\u{941}ट\u{941}"),
            keywords: &[
                "ट\u{941}क\u{94d}रिएको",
                "ट\u{941}ट\u{947}को",
                "म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gebroken hart"),
            keywords: &["breken", "gebroken", "gebroken hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("knust hjarte"),
            keywords: &["brot", "hjarte", "kjensler", "knust hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭଗ\u{b4d}ନ ହ\u{b43}ଦୟ"),
            keywords: &[
                "ଭଗ\u{b4d}ନ",
                "ଭ\u{b3e}ଙ\u{b4d}ଗ\u{b3f}ବ\u{b3e}",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ହ\u{b43}ଦୟ",
                "ହ\u{b43}ଦୟ ଭ\u{b3e}ଙ\u{b4d}ଗ\u{b3f}ଯ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a41}\u{a71}ਟਿਆ ਦਿਲ"),
            keywords: &[
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਟ\u{a41}\u{a71}ਟਣਾ",
                "ਟ\u{a41}\u{a71}ਟਿਆ ਦਿਲ",
                "ਟ\u{a41}\u{a71}ਟਿਆ ਹ\u{a4b}ਇਆ ਦਿਲ",
                "ਦਿਲ ਟ\u{a41}ਟਿਆ ਹ\u{a4b}ਇਆ",
                "ਦਿਲ ਤ\u{a4b}ੜਨਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹوٹیا ہوئیا دل"),
            keywords: &["توڑنا", "ٹوٹیا ہوئیا", "ٹوٹیا ہوئیا دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé Dọ\u{301}n Brẹk"),
            keywords: &["Brẹk", "Dọ\u{301}n Brẹk", "Hat Wé Dọ\u{301}n Brẹk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("złamane serce"),
            keywords: &["pęknięte", "serce", "złamane serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مات زړه"),
            keywords: &["مات", "مات زړه", "مات شوی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração partido"),
            keywords: &[
                "coração",
                "coração partido",
                "decepção amorosa",
                "emoção",
                "rompimento",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["coração", "partido", "partir"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pakasqa sunqu"),
            keywords: &["pakasqa", "pakasqa sunqu", "pakay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă zdrobită"),
            keywords: &["durere", "inimă", "inimă zdrobită"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-593"),
            keywords: &["E10-593"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("разбитое сердце"),
            keywords: &["разбитое", "разочарование", "сердце", "части"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima umenetse"),
            keywords: &["Gutandukana", "bitandukanye", "umutima umenetse"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽٽل دل"),
            keywords: &["ٽوڙڻ", "ٽٽل", "ٽٽل دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}ඳ\u{dd4}ණ\u{dd4} හදවත"),
            keywords: &["බ\u{dd2}ඳ\u{dd3}ම", "බ\u{dd2}ඳ\u{dd4}ණ\u{dd4}", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zlomené srdce"),
            keywords: &["srdce", "zlomené", "zlomiť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("strto srce"),
            keywords: &["počeno", "srce", "strto srce", "zlomiti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno jaban"),
            keywords: &["jabay", "jabis", "wadno jaban"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër e thyer"),
            keywords: &["e thyer", "i thyer", "thyej", "zemër", "zemër e thyer"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сломљено срце"),
            keywords: &["слoмљeнo", "сломљено срце", "срцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["сломљено срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("slomljeno srce"),
            keywords: &["slomljeno", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["slomljeno srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brustet hjärta"),
            keywords: &["brustet", "brustet hjärta", "känslor", "trasigt hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo uliovunjika"),
            keywords: &["moyo", "moyo uliovunjika", "vunja", "vunjika"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உடைந\u{bcd}த இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "உடைந\u{bcd}த இதயம\u{bcd}",
                "பிரேக\u{bcd} அப\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3e}యపడ\u{c3f}న హృదయం"),
            keywords: &["గ\u{c3e}యం", "గ\u{c3e}యపడ\u{c3f}న హృదయం", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили шикаста"),
            keywords: &["дили шикаста", "шикаста", "шикастан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("อกห\u{e31}ก"),
            keywords: &["ห\u{e31}วใจ", "อกห\u{e31}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("synan ýürek"),
            keywords: &["döwlen", "döwmek", "synan ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("loto lavea"),
            keywords: &["loto lavea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırık kalp"),
            keywords: &["duygu", "kalp", "kırma", "kırık kalp", "kırılmış"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۇلغان يۈرەك"),
            keywords: &["سۇلغان يۈرەك", "سۇنغان", "سۇنۇش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("розбите серце"),
            keywords: &["розбивати", "розбите", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹوٹا ہوا دل"),
            keywords: &["دل", "ٹوٹا ہوا", "ٹوٹا ہوا دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("singan yurak"),
            keywords: &["singan", "sinish", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim tan vỡ"),
            keywords: &["bị vỡ", "trái tim tan vỡ", "vỡ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu tasaaroo"),
            keywords: &["damm", "dammu", "xol bu tasaaroo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo eyaphukileyo"),
            keywords: &["aphula", "intliziyo eyaphukileyo", "yaphukile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ibanujẹ Ọkan"),
            keywords: &["Ibanujẹ Ọkan", "kán", "ti kán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("破碎嘅心"),
            keywords: &["破碎", "破碎嘅心", "碎"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("破碎嘅心"),
            keywords: &["破碎", "破碎嘅心", "碎"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("心碎"),
            keywords: &["伤心", "心碎"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心碎"),
            keywords: &["心碎", "破碎的心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo eyaphukile"),
            keywords: &["aphukile", "inhliziyo", "inhliziyo eyaphukile", "ukwaphuka"],
        },
    ],
};
#[doc = "❤\u{fe0f}\u{200d}🔥"]
pub const HEART_ON_FIRE: crate::Emoji = crate::Emoji {
    glyph: "❤\u{fe0f}\u{200d}🔥",
    codepoint: "2764 FE0F 200D 1F525",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "heart on fire",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "❤\u{200d}🔥",
        codepoint: "2764 200D 1F525",
        status: crate::Status::Unqualified,
        introduction_version: 13.1f32,
        name: "heart on fire",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hart wat brand"),
            keywords: &["brand", "hart", "hart wat brand", "liefde", "lus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በበስጭት ላይ ያለ ልብ"),
            keywords: &["በበስጭት ላይ ያለ ልብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب يحترق"),
            keywords: &["القلب المقدس", "حب", "حريق", "عشق", "قلب", "قلب يحترق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জ\u{9c1}ইত থক\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "ক\u{9be}মভ\u{9be}ৱ",
                "জ\u{9c1}ইত থক\u{9be} হ\u{9c3}দয\u{9bc}",
                "জ\u{9cd}বল\u{9be}",
                "পবিত\u{9cd}ৰ হ\u{9c3}দয\u{9bc}",
                "প\u{9cd}ৰেম",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("alovlu ürək"),
            keywords: &[
                "alovlu ürək",
                "müqəddəs ürək",
                "sevgi",
                "yanmaq",
                "ürək",
                "şəhvət",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэрца ў агні"),
            keywords: &[
                "агонь",
                "жаданне",
                "каханне",
                "святое сэрца",
                "сэрца",
                "сэрца ў агні",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сърце в пламъци"),
            keywords: &[
                "любов",
                "огън",
                "свещено сърце",
                "страст",
                "сърце",
                "сърце в пламъци",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আগ\u{9c1}নে হ\u{9c3}দয\u{9bc}"),
            keywords: &["আগ\u{9c1}নে হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zapaljeno srce"),
            keywords: &[
                "goriti",
                "ljubav",
                "požuda",
                "srce",
                "sveto srce",
                "zapaljeno srce",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor en flames"),
            keywords: &[
                "amor",
                "cor",
                "cor en flames",
                "cor sagrat",
                "foc",
                "luxúria",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hořící srdce"),
            keywords: &[
                "hořet",
                "hořící srdce",
                "láska",
                "nejsvětější srdce",
                "plamen",
                "srdce",
                "vášeň",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon ar dân"),
            keywords: &[
                "calon",
                "calon ar dân",
                "calon gysegredig",
                "cariad",
                "chwant",
                "llosgi",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brændende hjerte"),
            keywords: &[
                "brændende hjerte",
                "brændende kærlighed",
                "hjerte med ild i",
                "ild",
                "kærlighed",
                "passion",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz in Flammen"),
            keywords: &["Herz in Flammen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("brennendes Herz"),
            keywords: &["brennendes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά που καίγεται"),
            keywords: &["αγάπη", "καίω", "καρδιά", "καρδιά που καίγεται", "πόθος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("heart on fire"),
            keywords: &[
                "burn",
                "heart",
                "heart on fire",
                "love",
                "lust",
                "sacred heart",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón en llamas"),
            keywords: &[
                "amor",
                "corazón",
                "corazón en llamas",
                "fuego",
                "llamas",
                "lujuria",
                "pasión",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("leegitsev süda"),
            keywords: &[
                "armastus",
                "kirg",
                "leegitsev süda",
                "põlev",
                "püha süda",
                "süda",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sutan dagoen bihotza"),
            keywords: &[
                "bihotz sakratua",
                "bihotza",
                "erre",
                "lizunkeria",
                "maitasuna",
                "sutan dagoen bihotza",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب در آتش"),
            keywords: &["سوزاندن", "شهوت", "عشق", "قلب", "قلب در آتش", "قلب مقدس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("palava sydän"),
            keywords: &[
                "himo",
                "liekki",
                "palaa",
                "palava sydän",
                "pyhä sydän",
                "rakkaus",
                "sydän",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pusong nasa apoy"),
            keywords: &["pusong nasa apoy"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjarta sum brennur"),
            keywords: &[
                "brennur",
                "girnd",
                "hjarta",
                "hjarta sum brennur",
                "kærleiki",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur enflammé"),
            keywords: &["amour", "cœur enflammé", "désir", "feu", "passion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cœur en feu"),
            keywords: &["amour", "cœur en feu", "désir", "feu", "passion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí trí thine"),
            keywords: &["croí", "croí naofa", "croí trí thine", "drúis", "dó", "grá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe air theine"),
            keywords: &[
                "connan",
                "cridhe",
                "cridhe air theine",
                "cridhe naoimh",
                "deòthas",
                "drùis",
                "gaol",
                "gràdh",
                "lasair",
                "loisg",
                "losgadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón en chamas"),
            keywords: &[
                "amor",
                "chamas",
                "corazón en chamas",
                "desexo",
                "luxuria",
                "paixón",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દિલ પર આગ"),
            keywords: &[
                "જલન",
                "દિલ",
                "દિલ પર આગ",
                "પવિત\u{acd}ર હ\u{ac3}દય",
                "પ\u{acd}ર\u{ac7}મ",
                "વાસના",
                "સળગત\u{ac1}\u{a82} દિલ",
                "હ\u{ac3}દય",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב בלהבות"),
            keywords: &["לב", "לב בלהבות", "עולה באש", "שורף", "תשוקה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दिल जलना"),
            keywords: &["दिल जलना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srce u plamenu"),
            keywords: &[
                "ljubav",
                "požuda",
                "srce",
                "srce u plamenu",
                "sveto srce",
                "vatra",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lángoló szív"),
            keywords: &["lángoló", "szerelem", "szív", "vágy", "égő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("այրվող սիրտ"),
            keywords: &["այրոց", "այրվող սիրտ", "կիրք", "կրակ", "սեր", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati berapi-api"),
            keywords: &["hati berapi-api"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("logandi hjarta"),
            keywords: &[
                "brenna",
                "girnd",
                "heilagt hjarta",
                "hjarta",
                "logandi hjarta",
                "ást",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore in fiamme"),
            keywords: &["cuore in fiamme"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("燃えるハート"),
            keywords: &[
                "ハート",
                "愛",
                "火の付いた",
                "炎",
                "燃えるハート",
                "聖なる心臓",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati kasmaran"),
            keywords: &[
                "ati",
                "ati kasmaran",
                "ati resik",
                "kobong",
                "pepinginan",
                "tresna",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ალმოდებული გული"),
            keywords: &["ალი", "ალმოდებული გული", "ამური", "სიყვარული", "ცეცხლი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("лаулап тұрған жүрек"),
            keywords: &["лаулап тұрған жүрек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងព\u{17bb}ះកញ\u{17d2}ជ\u{17d2}រោល"),
            keywords: &[
                "ឆេះ",
                "តណ\u{17d2}ហា",
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងព\u{17b7}ស\u{17b7}ដ\u{17d2}ឋ",
                "បេះដ\u{17bc}ងព\u{17bb}ះកញ\u{17d2}ជ\u{17d2}រោល",
                "ស\u{17d2}រឡាញ\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ಂಕ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಹೃದಯ"),
            keywords: &[
                "ಕಾಮ",
                "ಪವ\u{cbf}ತ\u{ccd}ರ ಹೃದಯ",
                "ಪ\u{ccd}ರೀತ\u{cbf}",
                "ಬ\u{cc6}ಂಕ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf} ಹೃದಯ",
                "ಸುಡುವುದು",
                "ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("불 난 하트"),
            keywords: &["마음", "불 난 하트", "불타는 사랑", "사랑", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजो लागिल\u{94d}ल\u{947} काळीज"),
            keywords: &[
                "उजो लागिल\u{94d}ल\u{947} काळीज",
                "काळीज",
                "जळप",
                "पवित\u{94d}र काळीज",
                "मोग",
                "वासना",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өрттөнгөн жүрөк"),
            keywords: &["жүрөк", "күйүү", "сүйүү", "ыйык жүрөк", "өрттөнгөн жүрөк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈມ\u{eb5}ໄຟ"),
            keywords: &[
                "ຫ\u{eb7}\u{ec8}ນ",
                "ຫ\u{ebb}ວໃຈ",
                "ຫ\u{ebb}ວໃຈມ\u{eb5}ໄຟ",
                "ຫ\u{ebb}ວໃຈອ\u{eb1}ນສ\u{eb1}ກສ\u{eb4}ດ",
                "ຮ\u{eb1}ກ",
                "ໃໝ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("deganti širdis"),
            keywords: &["deganti širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("degoša sirds"),
            keywords: &[
                "degoša sirds",
                "kaisle",
                "liesmas",
                "mīla",
                "sirds",
                "svēta sirds",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("запалено срце"),
            keywords: &[
                "гори",
                "запалено срце",
                "свето срце",
                "сладострастие",
                "срце",
                "љубов",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹ\u{d43}ദയത\u{d4d}തിൽ തീ"),
            keywords: &["ഹ\u{d43}ദയത\u{d4d}തിൽ തീ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шатаж буй зүрх"),
            keywords: &[
                "ариун зүрх",
                "зүрх",
                "тачаал",
                "хайр",
                "шатаж буй зүрх",
                "шатах",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ह\u{943}दयात आग"),
            keywords: &[
                "जळण\u{947}",
                "पवित\u{94d}र ह\u{943}दय",
                "प\u{94d}र\u{947}म",
                "वासना",
                "ह\u{943}दय",
                "ह\u{943}दयात आग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati membara"),
            keywords: &["hati membara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}လ\u{102f}\u{1036}းမ\u{102e}းတောက\u{103a}ခြင\u{103a}း"),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}းမ\u{102e}းတောက\u{103a}ခြင\u{103a}း",
                "န\u{103e}လ\u{102f}\u{1036}းသား",
                "ရမက\u{103a}",
                "လောင\u{103a}ကျ\u{103d}မ\u{103a}းခြင\u{103a}း",
                "အချစ\u{103a}",
                "အထ\u{103d}တ\u{103a}အမြတ\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjerte i brann"),
            keywords: &[
                "brann",
                "hellig hjerte",
                "hjerte",
                "hjerte i brann",
                "ild",
                "kjærlighet",
                "lidenskap",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दिलमा आगो लाग\u{947}को"),
            keywords: &[
                "काम वासना",
                "जल\u{947}को",
                "दिलमा आगो लाग\u{947}को",
                "पवित\u{94d}र दिल",
                "माया",
                "म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hart in vuur en vlam"),
            keywords: &[
                "branden",
                "hart",
                "hart in vuur en vlam",
                "heilig hart",
                "liefde",
                "lust",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjarte i brann"),
            keywords: &[
                "brann",
                "eld",
                "heilag hjarte",
                "hjarte",
                "hjarte i brann",
                "kjærleik",
                "lidenskap",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਲਦਾ ਦਿਲ"),
            keywords: &[
                "ਜਲਦਾ ਦਿਲ",
                "ਦਿਲ",
                "ਪਵਿ\u{a71}ਤਰ ਦਿਲ",
                "ਪਿਆਰ",
                "ਲਾਲਸਾ",
                "ਸਾੜ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hat Wé De Bọ\u{301}n Wít Fáya"),
            keywords: &[
                "Bọn",
                "Hat",
                "Hat Wé De Bọ\u{301}n Wít Fáya",
                "Lọv",
                "Pẹ\u{301}sin To Họ\u{301}ngrí Wẹ\u{301}l Wẹl To Slíp Wit Sọ\u{301}mbọdi Bọt I Nó Lọ\u{301}v Di Pẹ\u{301}sin",
                "Sékrẹ\u{301}d Hat",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("serce w płomieniach"),
            keywords: &[
                "miłość",
                "płomienie",
                "płonąć",
                "serce",
                "serce w płomieniach",
                "święte serce",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زړه اور"),
            keywords: &["زړه", "زړه اور", "سوځول", "سپیڅلی زړه", "شوق", "مینه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração em chamas"),
            keywords: &[
                "amor",
                "chamas",
                "coração",
                "coração em chamas",
                "coração sagrado",
                "fogo",
                "luxúria",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sunqu ninapi"),
            keywords: &[
                "munay",
                "ruphay",
                "sunqu",
                "sunqu ninapi",
                "wakʼa sunqu",
                "ñuqi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă în flăcări"),
            keywords: &[
                "arde",
                "dorință",
                "inimă",
                "inimă sacră",
                "inimă în flăcări",
                "iubire",
                "pasiune",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-003"),
            keywords: &["E13.1-003"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("горящее сердце"),
            keywords: &[
                "горящее сердце",
                "любовь",
                "огонь",
                "пламенное сердце",
                "пламя",
                "страсть",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd2}න\u{dd2} ගත\u{dca} හදවත"),
            keywords: &[
                "ආදරය",
                "ග\u{dd2}න\u{dd2} ගත\u{dca} හදවත",
                "ප\u{dd2}ළ\u{dd2}ස\u{dca}ස\u{dd3}ම",
                "ප\u{dd6}ජන\u{dd3}ය හදවත",
                "ර\u{dcf}ගය",
                "හදවත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("horiace srdce"),
            keywords: &["horiace srdce", "láska", "oheň", "srdce", "túžba"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("goreče srce"),
            keywords: &[
                "goreče srce",
                "ljubezen",
                "ogenj",
                "poželenje",
                "srce",
                "sveto srce",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadne ololaya"),
            keywords: &[
                "gubasho",
                "jacayl",
                "lahasho",
                "wadne",
                "wadne ololaya",
                "wadne xurmaysan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër në flakë"),
            keywords: &[
                "dashuri",
                "djegie",
                "epsh",
                "zemër",
                "zemër e shenjtë",
                "zemër në flakë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("запаљено срце"),
            keywords: &["запаљено срце"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("запаљено срце"),
            keywords: &["запаљено срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zapaljeno srce"),
            keywords: &["zapaljeno srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("zapaljeno srce"),
            keywords: &["zapaljeno srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brinnande hjärta"),
            keywords: &["brinnande hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo unaochomeka"),
            keywords: &[
                "chomeka",
                "moyo",
                "moyo mtakatifu",
                "moyo unaochomeka",
                "penda",
                "tamaa",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எரியும\u{bcd} இதயம\u{bcd}"),
            keywords: &[
                "அன\u{bcd}பு",
                "இதயம\u{bcd}",
                "எரிதல\u{bcd}",
                "எரியும\u{bcd} இதயம\u{bcd}",
                "க\u{bbe}மம\u{bcd}",
                "புனிதம\u{bbe}ன இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మండుతున\u{c4d}న హృదయం"),
            keywords: &["మండుతున\u{c4d}న హృదయం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ไฟไหม\u{e49}ห\u{e31}วใจ"),
            keywords: &["ไฟไหม\u{e49}ห\u{e31}วใจ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýanyp duran ýürek"),
            keywords: &[
                "hyjuw",
                "mukaddes ýürek",
                "söýgi",
                "ýanmak",
                "ýanyp duran ýürek",
                "ýürek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu afi"),
            keywords: &["mafu afi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ateşli kalp"),
            keywords: &[
                "alev",
                "arzu",
                "ateşli kalp",
                "aşk",
                "kalp",
                "kutsal kalp",
                "tutku",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палке серце"),
            keywords: &[
                "жага",
                "любов",
                "опік",
                "палке серце",
                "священне серце",
                "серце",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جلتی آگ میں دل"),
            keywords: &["جلتی آگ میں دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("olovdagi yurak"),
            keywords: &[
                "choʻgʻ",
                "ishq",
                "kuydiradi",
                "olov",
                "olovdagi yurak",
                "qizigan qalb",
                "sevgi",
                "yondiradi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim bốc lửa"),
            keywords: &[
                "bốc lửa",
                "cháy",
                "thèm khát",
                "trái tim",
                "trái tim bốc lửa",
                "trái tim linh thiêng",
                "tình yêu",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("燒緊嘅心"),
            keywords: &["心", "情慾", "愛", "有疤痕嘅心", "燒", "燒緊嘅心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("烧紧嘅心"),
            keywords: &["心", "情欲", "有疤痕嘅心", "烧", "烧紧嘅心", "爱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("火上之心"),
            keywords: &["火上之心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("火熱的心"),
            keywords: &["奉獻", "心型", "愛", "慾望", "火熱的心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ebhakuzayo"),
            keywords: &["inhliziyo ebhakuzayo"],
        },
    ],
};
#[doc = "❤\u{fe0f}\u{200d}🩹"]
pub const MENDING_HEART: crate::Emoji = crate::Emoji {
    glyph: "❤\u{fe0f}\u{200d}🩹",
    codepoint: "2764 FE0F 200D 1FA79",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "mending heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "❤\u{200d}🩹",
        codepoint: "2764 200D 1FA79",
        status: crate::Status::Unqualified,
        introduction_version: 13.1f32,
        name: "mending heart",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("helende hart"),
            keywords: &["beter", "gesonder", "helend", "helende hart", "herstel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተጠገነ ልብ"),
            keywords: &["የተጠገነ ልብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب يتعافى"),
            keywords: &["قلب يتعافى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9c3}দয\u{9bc} আৰোগ\u{9cd}য হোৱ\u{9be}"),
            keywords: &[
                "আৰোগ\u{9cd}য হোৱ\u{9be}",
                "উদ\u{9cd}ধ\u{9be}ৰ হোৱ\u{9be}",
                "ঠিক হোৱ\u{9be}",
                "সক\u{9be}হ পোৱ\u{9be}",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য ঠিক হোৱ\u{9be}",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যকৰ",
                "হ\u{9c3}দয\u{9bc} আৰোগ\u{9cd}য হোৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yara bandlı ürək"),
            keywords: &[
                "sağalma",
                "sağlam",
                "yara bandlı ürək",
                "yara bandı bağlamaq",
                "özünə gəlmək",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэрца загойваецца"),
            keywords: &[
                "аднаўленне",
                "выздараўленне",
                "загойванне",
                "лепей",
                "паляпшэнне",
                "папраўленне",
                "сэрца загойваецца",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("превързано сърце"),
            keywords: &[
                "възстановяване",
                "добре",
                "оздравяване",
                "по-здрав",
                "подобрение",
                "превързано сърце",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সংশোধিত হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "উন\u{9cd}নতিশীল",
                "নির\u{9be}ময\u{9bc}ক\u{9be}রী",
                "প\u{9c1}নর\u{9c1}দ\u{9cd}ধ\u{9be}র কর\u{9be}",
                "ভ\u{9be}ল",
                "সংশোধিত হ\u{9c3}দয\u{9bc}",
                "সেরে উঠ\u{9be}",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যকর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("liječenje srca"),
            keywords: &[
                "dobro",
                "liječenje",
                "liječenje srca",
                "oporavak",
                "ozdravljenje",
                "poboljšanje",
                "zdravije",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor embenat"),
            keywords: &[
                "cor",
                "cor embenat",
                "millor",
                "millora",
                "recuperació",
                "salut",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("záplatované srdce"),
            keywords: &[
                "náplast",
                "uzdravit",
                "vyléčit",
                "zdraví",
                "zlepšení",
                "zotavení",
                "záplata",
                "záplatované srdce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trwsio calon"),
            keywords: &["gwella", "iach", "iachach", "trwsio", "trwsio calon"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("helende hjerte"),
            keywords: &[
                "bedring",
                "helende hjerte",
                "hjerte",
                "plaster",
                "plaster på hjerte",
                "rask",
                "sundere",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz mit Verband"),
            keywords: &["Herz mit Verband"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Herz mit Pflaster"),
            keywords: &["Herz mit Pflaster"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά που αναρρώνει"),
            keywords: &[
                "ανάκαμψη",
                "ανάρρωση",
                "αποκατάσταση",
                "βελτίωση",
                "καρδιά που αναρρώνει",
                "υγιέστερος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mending heart"),
            keywords: &[
                "healthier",
                "improving",
                "mending",
                "mending heart",
                "recovering",
                "recuperating",
                "well",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón curándose"),
            keywords: &[
                "bien",
                "corazón curándose",
                "cura",
                "mejor",
                "mejora",
                "recuperación",
                "salud",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tervenev süda"),
            keywords: &[
                "hästi",
                "kosumine",
                "paranemine",
                "taastumine",
                "tervem",
                "tervenemine",
                "tervenev süda",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sendatzen ari den bihotza"),
            keywords: &[
                "hobetzen",
                "leheneratzen",
                "ondo",
                "osasuntsuago",
                "sendatzen",
                "sendatzen ari den bihotza",
                "suspertzen",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب التیام\u{200c}یافته"),
            keywords: &[
                "التیام\u{200c}یافته",
                "تندرست",
                "خوب شدن",
                "در حال بازیابی",
                "در حال بهبود",
                "سالم\u{200c}تر",
                "قلب التیام\u{200c}یافته",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("parantuva sydän"),
            keywords: &[
                "elpyvä",
                "hyvinvoiva",
                "parantuminen",
                "parantuva",
                "parantuva sydän",
                "tervehtyvä",
                "toipuminen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pag-ayos sa puso"),
            keywords: &["pag-ayos sa puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjarta sum er lappa"),
            keywords: &["hjarta", "hjarta sum er lappa", "lappa", "umvæling"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur avec bandages"),
            keywords: &["cœur avec bandages", "réconforter", "réparer", "soigner"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "cœur avec bandages",
                "en convalescence",
                "réconforter",
                "récupérer",
                "soigner",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí deisithe"),
            keywords: &[
                "ag feabhsú",
                "ag teacht ar ais chugat féin",
                "croí deisithe",
                "go maith",
                "níos sláintiúla",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("slànachadh cridhe"),
            keywords: &[
                "fallainn",
                "feabhas",
                "gu math",
                "nas fhallainne",
                "nas fheàrr",
                "slàn",
                "slànachadh cridhe",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón curándose"),
            keywords: &[
                "corazón curándose",
                "curar",
                "desamor",
                "mellorar",
                "recuperación",
                "sandar",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દિલ બહ\u{ac7}લાવવ\u{ac1}\u{a82}"),
            keywords: &[
                "ત\u{a82}દ\u{ac1}રસ\u{acd}ત",
                "દિલ બહ\u{ac7}લાવવ\u{ac1}\u{a82}",
                "દિલાસો",
                "સાર\u{ac1}\u{a82}",
                "સ\u{ac1}ધારણા",
                "સ\u{acd}વસ\u{acd}થ",
                "સ\u{acd}વસ\u{acd}થ થવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב שמשתקם"),
            keywords: &["בריא יותר", "לב שמשתקם", "מחלים", "משתפר", "נרפא"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दिल बहलाना"),
            keywords: &["दिल बहलाना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srce koje se liječi"),
            keywords: &[
                "dobro",
                "obnavljanje",
                "oporavak",
                "poboljšanje",
                "srce koje se liječi",
                "zarastanje",
                "zdravije",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyógyuló szív"),
            keywords: &["gyógyuló szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լավացող սիրտ"),
            keywords: &["առողջ", "բարելավում", "լավանալ", "լավացող սիրտ", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mengobati hati terluka"),
            keywords: &["mengobati hati terluka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjarta að gróa"),
            keywords: &[
                "heilbrigðari",
                "hjarta að gróa",
                "hress",
                "jafna sig",
                "lagast",
                "ná sér",
                "skána",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore guarito"),
            keywords: &["cuore guarito"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("包帯を巻いたハート"),
            keywords: &[
                "ケガ",
                "ハート",
                "傷ついた",
                "傷心",
                "包帯",
                "包帯を巻いたハート",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ndandani ati"),
            keywords: &[
                "luwih waras",
                "mbalekake",
                "mulehake awak",
                "ndandani",
                "ndandani ati",
                "ningkatake",
                "waras",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაჯანსაღებული გული"),
            keywords: &[
                "გამოჯანსაღება",
                "გაჯანსაღებული გული",
                "კარგად ყოფნა",
                "ჯანმრთელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жаралы жүрек"),
            keywords: &["жаралы жүрек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងរ\u{17bb}\u{17c6}រប\u{17bd}ស"),
            keywords: &[
                "ជាសះស\u{17d2}បើយ",
                "ជ\u{17bd}សជ\u{17bb}ល",
                "ធ\u{17bc}រស\u{17d2}បើយ",
                "បេះដ\u{17bc}ងរ\u{17bb}\u{17c6}រប\u{17bd}ស",
                "ប\u{17d2}រសើរឡើង",
                "ស\u{17bb}ខភាពល\u{17d2}អ",
                "ស\u{17bb}ខភាពល\u{17d2}អជាងម\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೃದಯ ಹತೋಟ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf}ಡುವುದು"),
            keywords: &[
                "ಆರಾಮಾಗುತ\u{ccd}ತ\u{cbf}ರುವುದು",
                "ಆರೋಗ\u{ccd}ಯವಂತ",
                "ಒಳ\u{ccd}ಳ\u{cc6}ಯದು",
                "ಚೇತರ\u{cbf}ಕ\u{cc6}",
                "ಸುಧಾರ\u{cbf}ಸುವುದು",
                "ಹತೋಟ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf}ಡುವುದು",
                "ಹೃದಯ ಹತೋಟ\u{cbf}ಯಲ\u{ccd}ಲ\u{cbf}ಡುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("낫고 있는 하트"),
            keywords: &["개선", "건강", "낫고 있는 하트", "치유", "회복", "힐링"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ज\u{941}ळ\u{942}न य\u{947}वपी काळीज"),
            keywords: &[
                "ज\u{941}ळ\u{942}न य\u{947}वपी काळीज",
                "जोडप",
                "निवळप",
                "बर\u{947}\u{902} जावप",
                "भलायकी",
                "सा\u{902}दप",
                "स\u{941}दारप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жарасы чапталган жүрөк"),
            keywords: &["жарасы чапталган жүрөк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດາມໃຈ"),
            keywords: &[
                "ດາມໃຈ",
                "ປ\u{eb1}ບປ\u{eb8}ງ",
                "ພ\u{eb1}ກຟ\u{eb7}\u{ec9}ນ",
                "ຟ\u{eb7}\u{ec9}ນຕ\u{ebb}ວ",
                "ສ\u{eb8}ຂະພາບດ\u{eb5}",
                "ສ\u{ec9}ອມແປງ",
                "ແຂງແຮງຂ\u{eb6}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gydytina širdis"),
            keywords: &[
                "atsigauna",
                "atsigaunanti",
                "gerai",
                "gydytina širdis",
                "sveikesnis",
                "taisymas",
                "tobulinti",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pārsieta sirds"),
            keywords: &[
                "atkopties",
                "atspirgt",
                "labi",
                "pārsiet",
                "pārsieta sirds",
                "uzlabot",
                "veselību",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("залечено срце"),
            keywords: &[
                "добро",
                "закрепнува",
                "залечено срце",
                "поздраво",
                "се залекува",
                "се подобрува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d41}ഖം പ\u{d4d}ര\u{d3e}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം"),
            keywords: &["സ\u{d41}ഖം പ\u{d4d}ര\u{d3e}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന ഹ\u{d43}ദയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("засарч буй"),
            keywords: &[
                "засарч буй",
                "сайжирч буй",
                "сайн",
                "сэргэж буй",
                "эдгэж буй",
                "эрүүл",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सावरणार\u{947} ह\u{943}दय"),
            keywords: &[
                "निरोगी",
                "बर\u{947} होणार\u{947}",
                "रोगम\u{941}क\u{94d}त होणार\u{947}",
                "सावरणार\u{947}",
                "सावरणार\u{947} ह\u{943}दय",
                "स\u{941}धरणार\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati sembuh"),
            keywords: &["hati sembuh"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}လ\u{102f}\u{1036}းသား က\u{102f}စားခြင\u{103a}း"),
            keywords: &[
                "က\u{102f}စားခြင\u{103a}း",
                "ကောင\u{103a}းမ\u{103d}န\u{103a}ခြင\u{103a}း",
                "ကောင\u{103a}းမ\u{103d}န\u{103a}လာခြင\u{103a}း",
                "ကျန\u{103a}းမာခြင\u{103a}း",
                "နာလန\u{103a}ထ\u{1030}လာခြင\u{103a}း",
                "န\u{103e}လ\u{102f}\u{1036}းသား က\u{102f}စားခြင\u{103a}း",
                "အားပြန\u{103a}ဖြည\u{1037}\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lindret hjerte"),
            keywords: &[
                "bedre",
                "bra",
                "forbedring",
                "komme seg",
                "lindret hjerte",
                "lindring",
                "sterkere",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ट\u{941}को चोट निको पार\u{94d}द\u{948}"),
            keywords: &[
                "निको पार\u{94d}द\u{948}",
                "म\u{941}ट\u{941}को चोट निको पार\u{94d}द\u{948}",
                "राम\u{94d}रो",
                "सन\u{94d}चो ह\u{941}\u{901}द\u{948}",
                "स\u{941}धार गर\u{94d}द\u{948}",
                "स\u{94d}वस\u{94d}थ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("helend hart"),
            keywords: &[
                "gezond",
                "gezonder",
                "helend",
                "helend hart",
                "herstellend",
                "verbeterend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lindra hjarte"),
            keywords: &[
                "betre",
                "bra",
                "forbetring",
                "kome seg",
                "lindra hjarte",
                "lindring",
                "sterkare",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a70}ਦਰ\u{a41}ਸਤ ਹ\u{a41}\u{a70}ਦਾ ਦਿਲ"),
            keywords: &[
                "ਖ\u{a48}ਰ",
                "ਤ\u{a70}ਦਰ\u{a41}ਸਤ ਹ\u{a41}\u{a70}ਦਾ ਦਿਲ",
                "ਤ\u{a70}ਦਰ\u{a41}ਸਤੀ",
                "ਮ\u{a41}ਰ\u{a70}ਮਤ",
                "ਸਿਹਤਮ\u{a70}ਦ",
                "ਸ\u{a41}ਧਾਰ",
                "ਸ\u{a41}ਧਾਰਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("To Ripiá Hat Wé Dọn Brẹk"),
            keywords: &[
                "Pẹ\u{301}sin Bọdí Dọn De Wẹl",
                "Pẹ\u{301}sin Dọ\u{301}n De Gẹ\u{301}t Bák Im Páwa Áftá Síknẹs",
                "Pẹ\u{301}sin Dọ\u{301}n De Wẹ\u{301}l Agen",
                "Síknẹs Dọ\u{301}n De Gò",
                "To Ripiá Hat Wé Dọn Brẹk",
                "Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uleczone serce"),
            keywords: &[
                "dobrze",
                "lepiej",
                "lepsze samopoczucie",
                "uleczone serce",
                "zdrowsze",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښه کول زړه"),
            keywords: &["حي", "روغول", "وده کول", "ښه", "ښه کول", "ښه کول زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração remendado"),
            keywords: &[
                "bem",
                "bom",
                "coração remendado",
                "curando",
                "mais saudável",
                "melhorando",
                "recuperação",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("allichasqa sunqu"),
            keywords: &[
                "allichachkan",
                "allichasqa",
                "allichasqa sunqu",
                "allichay kay",
                "allin",
                "qhali kay",
                "qhali kaynin",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă în convalescență"),
            keywords: &[
                "ameliorare",
                "bine",
                "inimă în convalescență",
                "mai sănătos",
                "recuperare",
                "însănătoșire",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-004"),
            keywords: &["E13.1-004"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("заживающее сердце"),
            keywords: &[
                "выздоровление",
                "заживающее сердце",
                "излечение",
                "поправка",
                "улучшение",
                "хорошо",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ව වෙන හදවත"),
            keywords: &[
                "ප\u{dca}\u{200d}රකෘත\u{dd2}මත\u{dca} ව\u{dd3}ම",
                "යථ\u{dcf} තත\u{dca}ත\u{dca}වයට පත\u{dca} ව\u{dd3}ම",
                "වැඩ\u{dd2} ද\u{dd2}ය\u{dd4}ණ\u{dd4} ක\u{dd2}ර\u{dd3}ම",
                "ස\u{dd4}ව ද\u{dd3}ම",
                "ස\u{dd4}ව වෙන හදවත",
                "සෞඛ\u{dca}\u{200d}ය සම\u{dca}පන\u{dca}න",
                "හොඳ\u{dd2}න\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("srdce s\u{a0}obväzom"),
            keywords: &[
                "dobre",
                "lepšie",
                "srdce s\u{a0}obväzom",
                "uzdravovať sa",
                "zdravšie",
                "zotavovať sa",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zakrpano srce"),
            keywords: &[
                "bolj zdravo",
                "izboljšanje",
                "okrevanje",
                "ozdravljeno",
                "zakrpano",
                "zakrpano srce",
                "zdravo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadne dhaawacan"),
            keywords: &[
                "caafimad qaba",
                "fiican",
                "karan",
                "soo boqsanaya",
                "soo kabanaya",
                "wadne dhaawacan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër në shërim"),
            keywords: &[
                "kurim",
                "mirë",
                "më shëndetshëm",
                "përmirësim",
                "rikuperim",
                "shërim",
                "zemër në shërim",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рањено срце"),
            keywords: &["рањено срце"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("срце које зацјељује"),
            keywords: &["срце које зацјељује"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ranjeno srce"),
            keywords: &["ranjeno srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("srce koje zacjeljuje"),
            keywords: &["srce koje zacjeljuje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("läkande hjärta"),
            keywords: &[
                "friskna till",
                "läkande hjärta",
                "läker",
                "läker sår",
                "repa sig",
                "tillfriskna",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kurekebisha moyo"),
            keywords: &[
                "anaimarika",
                "anapata nafuu",
                "anapona",
                "kurekebisha moyo",
                "mwenye afya",
                "rekebisha",
                "vizuri",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஒட\u{bcd}டுத\u{bcd}தையலிடப\u{bcd}பட\u{bcd}ட இதயம\u{bcd}"),
            keywords: &[
                "ஆரோக\u{bcd}கியம\u{bbe}தல\u{bcd}",
                "ஒட\u{bcd}டுத\u{bcd}தையலிடப\u{bcd}பட\u{bcd}ட இதயம\u{bcd}",
                "ஒட\u{bcd}டுத\u{bcd}தையலிடப\u{bcd}பட\u{bcd}டது",
                "குணமடைதல\u{bcd}",
                "தேறிவருதல\u{bcd}",
                "நன\u{bcd}ற\u{bbe}குதல\u{bcd}",
                "முன\u{bcd}னேற\u{bcd}றம\u{bcd} அடைதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కట\u{c4d}టుత\u{c4b} ఉన\u{c4d}న హృదయం"),
            keywords: &["కట\u{c4d}టుత\u{c4b} ఉన\u{c4d}న హృదయం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจท\u{e35}\u{e48}ม\u{e35}การซ\u{e48}อมแซม"),
            keywords: &["ห\u{e31}วใจท\u{e35}\u{e48}ม\u{e35}การซ\u{e48}อมแซม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gowulaşýan ýürek"),
            keywords: &[
                "dikelýän",
                "düzelýän",
                "gowulanýan",
                "gowulaşýan",
                "gowulaşýan ýürek",
                "has sagdyn",
                "oňat",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu monomono"),
            keywords: &["mafu monomono"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iyileşen kalp"),
            keywords: &[
                "daha sağlıklı",
                "iyi",
                "iyileşen",
                "iyileşen kalp",
                "onarılan",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце, що заживає"),
            keywords: &[
                "здоровий",
                "здоровіший",
                "лікування",
                "одужання",
                "покращення",
                "поправка",
                "серце, що заживає",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دل کی اصلاح"),
            keywords: &["دل کی اصلاح"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yurakka malham"),
            keywords: &[
                "davolash",
                "malham",
                "shifo",
                "tuzatish",
                "yurakka dori",
                "yurakka malham",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim đang lành"),
            keywords: &[
                "cải thiện",
                "hồi phục",
                "khỏe mạnh hơn",
                "phục hồi",
                "trái tim đang lành",
                "đang lành",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("包紥嘅心"),
            keywords: &["修補", "健康", "包紥嘅心", "好", "復原緊", "改善", "療傷"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("包紥嘅心"),
            keywords: &["修补", "健康", "包紥嘅心", "复原紧", "好", "改善", "疗伤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("修复受伤的心灵"),
            keywords: &["修复受伤的心灵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("療心"),
            keywords: &["健康", "恢復", "療傷", "療心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "❤\u{fe0f}"]
pub const RED_HEART: crate::Emoji = crate::Emoji {
    glyph: "❤\u{fe0f}",
    codepoint: "2764 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "red heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "❤",
        codepoint: "2764",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "red heart",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("rooi hartjie"),
            keywords: &["hart", "rooi", "rooi hartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀይ ልብ"),
            keywords: &["ልብ", "ቀይ ልብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أحمر"),
            keywords: &["قلب", "قلب أحمر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰঙ\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &["হ\u{9be}ৰ\u{9cd}ট", "ৰঙ\u{9be} হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qırmızı ürək"),
            keywords: &["qırmızı ürək", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чырвонае сэрца"),
            keywords: &["сэрца", "чырвонае сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Червено сърце"),
            keywords: &["Червено сърце", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ল\u{9be}ল হ\u{9be}র\u{9cd}ট"),
            keywords: &["ল\u{9be}ল হ\u{9be}র\u{9cd}ট", "হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon ruz"),
            keywords: &["kalon ruz", "ruz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crveno srce"),
            keywords: &["crveno srce", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor vermell"),
            keywords: &["cor", "cor vermell"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦᎨ ᎤᎿᏫ"),
            keywords: &["ᎤᎿᏫ", "ᎩᎦᎨ ᎤᎿᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rudé srdce"),
            keywords: &["rudé srdce", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon goch"),
            keywords: &["calon", "calon goch"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rødt hjerte"),
            keywords: &["hjerte", "rødt hjerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("rotes Herz"),
            keywords: &["Herz", "rotes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκκινη καρδιά"),
            keywords: &["καρδιά", "κόκκινη καρδιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("red heart"),
            keywords: &["heart", "red heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón rojo"),
            keywords: &["corazón", "emoción", "rojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón rojo"),
            keywords: &["corazón rojo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["amor", "corazón", "emoción", "rojo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["corazón", "corazón rojo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("punane süda"),
            keywords: &["punane süda", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz gorria"),
            keywords: &["bihotz", "bihotz gorria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب قرمز"),
            keywords: &["قلب", "قلب قرمز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("punainen sydän"),
            keywords: &["punainen sydän", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pulang puso"),
            keywords: &["pag-ibig", "pulang puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("reytt hjarta"),
            keywords: &["hjarta", "reytt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur rouge"),
            keywords: &["cœur", "cœur rouge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "rouge"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí dearg"),
            keywords: &["croí", "croí dearg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe dearg"),
            keywords: &["cridhe", "cridhe dearg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón"),
            keywords: &["amor", "corazón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લાલ હ\u{ac3}દય"),
            keywords: &["લાલ", "હ\u{ac3}દય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan zuciya"),
            keywords: &["jan zuciya", "zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב אדום"),
            keywords: &["אדום", "לב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लाल दिल"),
            keywords: &["दिल", "लाल दिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crveno srce"),
            keywords: &["crveno srce", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vörös szív"),
            keywords: &["piros", "szív", "vörös szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կարմիր սիրտ"),
            keywords: &["կարմիր", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati merah"),
            keywords: &["hati", "hati merah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi ọbara"),
            keywords: &["obi", "obi ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rautt hjarta"),
            keywords: &["hjarta", "rautt hjarta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore rosso"),
            keywords: &["amore", "cuore rosso", "rosso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤いハート"),
            keywords: &["ハート", "赤いハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati abang"),
            keywords: &["ati", "ati abang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წითელი გული"),
            keywords: &["გული", "წითელი გული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызыл жүрек"),
            keywords: &["жүрек", "қызыл жүрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rødt hjerte"),
            keywords: &["hjerte", "rødt hjerte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ង"),
            keywords: &["បេះដ\u{17bc}ង", "ស\u{17d2}រឡាញ\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cc6}ಂಪು ಹೃದಯ"),
            keywords: &["ಕ\u{cc6}ಂಪು ಹೃದಯ", "ಹೃದಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("빨간색 하트"),
            keywords: &["마음", "빨간색 하트", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ता\u{902}बड\u{947}\u{902} काळीज"),
            keywords: &["काळीज", "ता\u{902}बड\u{947}\u{902} काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызыл жүрөк"),
            keywords: &["жүрөк", "кызыл жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("rout Häerz"),
            keywords: &["Häerz", "rout Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສ\u{eb5}ແດງ"),
            keywords: &["ສ\u{eb5}ແດງ", "ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈສ\u{eb5}ແດງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("raudona širdelė"),
            keywords: &["raudona širdelė", "širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sarkana sirds"),
            keywords: &["sarkana sirds", "sarkans", "sirds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa whero"),
            keywords: &["manawa", "manawa whero"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црвено срце"),
            keywords: &["срце", "црвено"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ച\u{d41}വന\u{d4d}ന ഹ\u{d43}ദയം"),
            keywords: &[
                "ച\u{d41}വന\u{d4d}ന ഹ\u{d43}ദയം",
                "ച\u{d41}വപ\u{d4d}പ\u{d4d}",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улаан зүрх"),
            keywords: &["зүрх", "улаан", "хайр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लाल ह\u{943}दय"),
            keywords: &["लाल ह\u{943}दय", "ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati merah"),
            keywords: &["hati", "hati merah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb ħamra"),
            keywords: &["qalb", "qalb ħamra"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အန\u{102e}ရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}း",
                "အန\u{102e}ရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rødt hjerte"),
            keywords: &["hjerte", "rødt hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रातो म\u{941}ट\u{941}"),
            keywords: &["म\u{941}ट\u{941}", "रातो म\u{941}ट\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rood hart"),
            keywords: &["hart", "rood hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("raudt hjarte"),
            keywords: &["hjarte", "raudt hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲ\u{b3e}ଲ\u{b4d}\u{200c} ହ\u{b43}ଦୟ"),
            keywords: &["ଲ\u{b3e}ଲ\u{b4d}\u{200c} ହ\u{b43}ଦୟ", "ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾਲ ਦਿਲ"),
            keywords: &["ਦਿਲ", "ਪਿਆਰ", "ਲਾਲ ਦਿਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لال دل"),
            keywords: &["دل", "لال دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Rẹ\u{301}d Hat"),
            keywords: &["Hat", "Rẹ\u{301}d Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czerwone serce"),
            keywords: &["czerwone", "kocham", "miłość", "serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سور زړه"),
            keywords: &["زړه", "سور زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração vermelho"),
            keywords: &["amor", "coração", "coração vermelho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["coração", "coração vermelho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("puka sunqu"),
            keywords: &["puka sunqu", "sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă roșie"),
            keywords: &["inimă", "inimă roșie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-147"),
            keywords: &["E10-147"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("алое сердце"),
            keywords: &["алое", "красное", "сердце", "чувства"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima utukura"),
            keywords: &["umutima", "umutima utukura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳاڙهي دل"),
            keywords: &["دل", "ڳاڙهي دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රත\u{dd4} හදවත"),
            keywords: &["රත\u{dd4} හදවත", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("červené srdce"),
            keywords: &["srdce", "červené"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rdeče srce"),
            keywords: &["rdeče srce", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno cas"),
            keywords: &["wadno", "wadno cas"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër e kuqe"),
            keywords: &["zemër", "zemër e kuqe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црвено срце"),
            keywords: &["срцe", "црвено срце"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crveno srce"),
            keywords: &["crveno srce", "srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("rött hjärta"),
            keywords: &["hjärta", "kärlek", "rött hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo mwekundu"),
            keywords: &["moyo", "moyo mwekundu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிவப\u{bcd}புநிற இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "சிவப\u{bcd}பு",
                "சிவப\u{bcd}புநிற இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎరుపు రంగు హృదయం"),
            keywords: &["ఎరుపు", "ఎరుపు రంగు హృదయం", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили сурх"),
            keywords: &["дил", "дили сурх"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}แดง"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจส\u{e35}แดง", "ห\u{e31}วใจแดง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyzyl ýürek"),
            keywords: &["gyzyl ýürek", "ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu kulokula"),
            keywords: &["mafu kulokula"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kırmızı kalp"),
            keywords: &["kalp", "kırmızı kalp"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزىل يۈرەك"),
            keywords: &["قىزىل يۈرەك", "يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("червоне серце"),
            keywords: &["серце", "червоне серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سرخ دل"),
            keywords: &["دل", "سرخ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qizil yurak"),
            keywords: &["qizil yurak", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu đỏ"),
            keywords: &["trái tim", "trái tim màu đỏ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xonk xol"),
            keywords: &["xol", "xonk xol"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo ebomvu"),
            keywords: &["intliziyo", "intliziyo ebomvu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkàn pupa"),
            keywords: &["ọkàn", "ọkàn pupa"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紅色心"),
            keywords: &["心", "紅色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("红色心"),
            keywords: &["心", "红色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("红心"),
            keywords: &["心", "爱", "红心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("愛心"),
            keywords: &["心型", "愛心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ebomvu"),
            keywords: &["inhliiziyo", "inhliziyo ebomvu"],
        },
    ],
};
#[doc = "🧡"]
pub const ORANGE_HEART: crate::Emoji = crate::Emoji {
    glyph: "🧡",
    codepoint: "1F9E1",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "orange heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oranje hartjie"),
            keywords: &["oranje", "oranje hartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ብርቱካናማ ልብ"),
            keywords: &["ብርቱካናማ ልብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب برتقالي"),
            keywords: &["برتقالة", "قلب برتقالي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কমল\u{9be}ৰঙী হ\u{9c3}দয\u{9bc}"),
            keywords: &["কমল\u{9be}ৰঙী", "কমল\u{9be}ৰঙী হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("narıncı ürək"),
            keywords: &["narıncı", "narıncı ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аранжавае сэрца"),
            keywords: &["аранжавае сэрца", "аранжавы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("оранжево сърце"),
            keywords: &["оранжево", "оранжево сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কমল\u{9be} হ\u{9be}র\u{9cd}ট"),
            keywords: &["কমল\u{9be}", "কমল\u{9be} হ\u{9be}র\u{9cd}ট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon orañjez"),
            keywords: &["kalon orañjez", "orañjez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("narandžasto srce"),
            keywords: &["narandžasta", "narandžasto srce", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor taronja"),
            keywords: &["cor taronja", "taronja"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎶᏂᎨ ᎤᎿᏫ"),
            keywords: &["ᎠᏓᎶᏂᎨ", "ᎠᏓᎶᏂᎨ ᎤᎿᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oranžové srdce"),
            keywords: &["oranžová", "oranžové srdce", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon oren"),
            keywords: &["calon oren", "oren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("orange hjerte"),
            keywords: &["følelser", "hjerte", "orange"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("oranges Herz"),
            keywords: &["orange", "oranges Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πορτοκαλί καρδιά"),
            keywords: &["πορτοκαλί καρδιά", "ποστοκάλι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("orange heart"),
            keywords: &["orange", "orange heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón naranja"),
            keywords: &["corazón", "emoción", "naranja"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("corazón anaranjado"),
            keywords: &["anaranjado", "corazón anaranjado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("oranž süda"),
            keywords: &["oranž", "oranž süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz laranja"),
            keywords: &["bihotz laranja", "laranja"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب نارنجی"),
            keywords: &["قلب", "نارنجی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oranssi sydän"),
            keywords: &["oranssi", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pusong dalandan"),
            keywords: &["dalandan", "pusong dalandan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("appilsingult hjarta"),
            keywords: &["appilsingult", "hjarta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur orange"),
            keywords: &["cœur orange", "orange"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "orange"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí flannbhuí"),
            keywords: &["croí", "flannbhuí", "oráiste"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe orains"),
            keywords: &["cridhe orains", "orains"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón laranxa"),
            keywords: &["corazón", "laranxa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાર\u{a82}ગી દિલ"),
            keywords: &["નાર\u{a82}ગી દિલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zuciyar na ruwan goro"),
            keywords: &["ruwan goro", "zuciyar na ruwan goro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב כתום"),
            keywords: &["כתום", "לב כתום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नार\u{902}गी दिल"),
            keywords: &["नार\u{902}गी दिल"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("narančasto srce"),
            keywords: &["narančasto", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("narancssárga szív"),
            keywords: &["narancssárga", "narancssárga szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("նարնջագույն սիրտ"),
            keywords: &["նարնջագույն", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati oranye"),
            keywords: &["hati", "oranye"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi orenji"),
            keywords: &["obi orenji", "orenji"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("appelsínugult hjarta"),
            keywords: &["appelsínugult", "hjarta", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore arancione"),
            keywords: &["arancione", "cuore", "emozione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("オレンジのハート"),
            keywords: &["オレンジのハート", "ハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati kunir"),
            keywords: &["ati kunir", "kunir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ნარინჯისფერი გული"),
            keywords: &["ნარინჯისფერი", "ნარინჯისფერი გული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қызғылт-сары жүрек"),
            keywords: &["қызғылт-сары жүрек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច"),
            keywords: &[
                "បេះដ\u{17bc}ងពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
                "ពណ\u{17cc}ទ\u{17b9}កក\u{17d2}រ\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6} ಹೃದಯ"),
            keywords: &[
                "ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6}",
                "ಕ\u{cbf}ತ\u{ccd}ತಳ\u{cc6} ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주황색 하트"),
            keywords: &["주황색 하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लारा\u{902}जी काळीज"),
            keywords: &["लारा\u{902}जी", "लारा\u{902}जी काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кызгылтым сары жүрөк"),
            keywords: &["кызгылтым сары", "кызгылтым сары жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("oranget Häerz"),
            keywords: &["orange", "oranget Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈໝາກກ\u{ec9}ຽງ"),
            keywords: &["ຫ\u{ebb}ວໃຈໝາກກ\u{ec9}ຽງ", "ໝາກກ\u{ec9}ຽງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("oranžinė širdelė"),
            keywords: &["oranžinė", "oranžinė širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("oranža sirds"),
            keywords: &["oranža sirds", "oranžs", "sirds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa karaka"),
            keywords: &["karaka", "manawa karaka"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("портокалово срце"),
            keywords: &["портокал", "портокалово срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓറഞ\u{d4d}ച\u{d4d} ഹ\u{d43}ദയം"),
            keywords: &[
                "ഓറഞ\u{d4d}ച\u{d4d}",
                "പ\u{d4d}രണയം",
                "വിക\u{d3e}രം",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("улбар шар зүрх"),
            keywords: &["улбар шар", "улбар шар зүрх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("क\u{947}शरी ह\u{943}दय"),
            keywords: &["क\u{947}शरी", "क\u{947}शरी ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati jingga"),
            keywords: &["hati jingga", "jingga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb oranġjo"),
            keywords: &["oranġjo", "qalb oranġjo"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} အသည\u{103a}းန\u{103e}လ\u{102f}\u{1036}း",
            ),
            keywords: &[
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a}",
                "လ\u{102d}မ\u{1039}မော\u{103a}ရောင\u{103a} အသည\u{103a}းန\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("oransje hjerte"),
            keywords: &["følelser", "hjerte", "oransje"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}न\u{94d}तला रङको म\u{941}ट\u{941}"),
            keywords: &[
                "स\u{941}न\u{94d}तला",
                "स\u{941}न\u{94d}तला रङको म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oranje hart"),
            keywords: &["oranje", "oranje hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("oransje hjarte"),
            keywords: &["hjarte", "kjensler", "oransje"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କମଳ\u{b3e} ହ\u{b43}ଦୟ"),
            keywords: &["କମଳ\u{b3e}", "କମଳ\u{b3e} ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a70}ਤਰੀ ਦਿਲ"),
            keywords: &["ਸ\u{a70}ਤਰੀ", "ਸ\u{a70}ਤਰੀ ਦਿਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نارنگی دل"),
            keywords: &["مالٹا", "نارنگی دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}rénj Kọ\u{301}lọ Hat"),
            keywords: &[
                "Ọ\u{301}renj",
                "Ọ\u{301}renj Kọ\u{301}lọ Hat",
                "Ọ\u{301}rénj Kọ\u{301}lọ Hat",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pomarańczowe serce"),
            keywords: &["pomarańczowe", "pomarańczowe serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نارنجی زړه"),
            keywords: &["نارنجی", "نارنجی زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração laranja"),
            keywords: &["coração", "emoção", "laranja"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração cor de laranja"),
            keywords: &["coração", "coração cor de laranja", "coração laranja"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("willapi sunqu"),
            keywords: &["willapi", "willapi sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă portocalie"),
            keywords: &["inimă", "inimă portocalie", "portocaliu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1138"),
            keywords: &["E10-1138"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("оранжевое сердце"),
            keywords: &["оранжевое", "сердце"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima wa oranje"),
            keywords: &["oranje", "umutima wa oranje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نارنگي دل"),
            keywords: &["نارنگي", "نارنگي دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තැඹ\u{dd2}ල\u{dd2} හදවත"),
            keywords: &["තැඹ\u{dd2}ල\u{dd2}", "තැඹ\u{dd2}ල\u{dd2} හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oranžové srdce"),
            keywords: &["oranžové", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oranžno srce"),
            keywords: &["oranžno srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno oranji ah"),
            keywords: &["oranji", "wadno oranji ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër ngjyrë portokalli"),
            keywords: &["portokalli", "zemër ngjyrë portokalli"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("наранџасто срце"),
            keywords: &["наранџасто", "наранџасто срце", "срцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["наранџасто срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("narandžasto srce"),
            keywords: &["narandžasto", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["narandžasto srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärta i orange"),
            keywords: &["hjärta i orange", "orange"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo wa rangi ya chungwa"),
            keywords: &["chungwa", "moyo wa rangi ya chungwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆரஞ\u{bcd}சு நிற இதயம\u{bcd}"),
            keywords: &[
                "ஆரஞ\u{bcd}சு",
                "ஆரஞ\u{bcd}சு நிற இதயம\u{bcd}",
                "இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}ర\u{c3f}ంజ రంగు హృదయం"),
            keywords: &["ఆర\u{c46}ంజ\u{c4d}", "న\u{c3e}ర\u{c3f}ంజ రంగు హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили норанҷӣ"),
            keywords: &["дили норанҷӣ", "норанҷӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}ส\u{e49}ม"),
            keywords: &["ส\u{e35}ส\u{e49}ม", "ห\u{e31}วใจส\u{e35}ส\u{e49}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mämişi ýürek"),
            keywords: &["mämişi", "mämişi ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu lanumoli"),
            keywords: &["mafu lanumoli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("turuncu kalp"),
            keywords: &["portakal", "turuncu kalp"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىزغۇچ يۈرەك"),
            keywords: &["قىزغۇچ رەڭ", "قىزغۇچ يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("оранжеве серце"),
            keywords: &["оранжеве серце", "помаранчевий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نارنجی دل"),
            keywords: &["نارنجی", "نارنجی دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("apelsinrang yurak"),
            keywords: &["apelsinrang yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu cam"),
            keywords: &["màu cam", "trái tim màu cam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu oraas"),
            keywords: &["oraas", "xol bu oraas"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo eorenji"),
            keywords: &["intliziyo eorenji", "orenji"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọlakàn ọsàn"),
            keywords: &["aláwọ\u{300} ọsàn", "ọlakàn ọsàn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("橙色心"),
            keywords: &["橙色", "橙色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("橙色心"),
            keywords: &["橙色", "橙色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("橙心"),
            keywords: &["橙", "橙心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("橘心"),
            keywords: &["心型", "橘心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("橙心"),
            keywords: &["心型", "橙心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ewolintshi"),
            keywords: &["inhliziyo ewolintshi", "wolintshi"],
        },
    ],
};
#[doc = "💛"]
pub const YELLOW_HEART: crate::Emoji = crate::Emoji {
    glyph: "💛",
    codepoint: "1F49B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "yellow heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("geel hartjie"),
            keywords: &["geel", "geel hartjie", "hart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቢጫ ልብ"),
            keywords: &["ልብ", "ቢጫ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أصفر"),
            keywords: &["أصفر", "قلب", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}লধীয\u{9bc}\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "হ\u{9be}লধীয\u{9bc}\u{9be}",
                "হ\u{9be}লধীয\u{9bc}\u{9be} হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarı ürək"),
            keywords: &["sarı", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жоўтае сэрца"),
            keywords: &["жоўтае сэрца", "жоўты", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Жълто сърце"),
            keywords: &["Жълто сърце", "жълто", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হল\u{9c1}দ হ\u{9be}র\u{9cd}ট"),
            keywords: &["হল\u{9c1}দ", "হল\u{9c1}দ হ\u{9be}র\u{9cd}ট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon velen"),
            keywords: &["kalon velen", "melen"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žuto srce"),
            keywords: &["srce", "žuta", "žuto srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor groc"),
            keywords: &["cor", "cor groc"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᎶᏂᎨ ᎤᎿᏫ"),
            keywords: &["ᏓᎶᏂᎨ", "ᏓᎶᏂᎨ ᎤᎿᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žluté srdce"),
            keywords: &["srdce", "žlutá", "žluté srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon felen"),
            keywords: &["calon", "calon felen", "melyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gult hjerte"),
            keywords: &["følelser", "gul", "gult hjerte", "hjerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gelbes Herz"),
            keywords: &["Herz", "gelb", "gelbes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κίτρινη καρδιά"),
            keywords: &["κίτρινη", "καρδιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("yellow heart"),
            keywords: &["yellow", "yellow heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón amarillo"),
            keywords: &["amarillo", "corazón", "emoción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón amarillo"),
            keywords: &["corazón amarillo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["amarillo", "corazón amarillo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kollane süda"),
            keywords: &["kollane", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz horia"),
            keywords: &["bihotz", "bihotz horia", "hori"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب زرد"),
            keywords: &["زرد", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keltainen sydän"),
            keywords: &["keltainen", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dilaw na puso"),
            keywords: &["dilaw", "dilaw na puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gult hjarta"),
            keywords: &["gult", "hjarta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur jaune"),
            keywords: &["cœur", "cœur jaune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "jaune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí buí"),
            keywords: &["croí", "croí buí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe buidhe"),
            keywords: &["buidhe", "cridhe buidhe"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón amarelo"),
            keywords: &["amarelo", "corazón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પીળ\u{ac1}\u{a82} દિલ"),
            keywords: &["દિલ", "પીળ\u{ac1}\u{a82}", "લાગણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rawayan zuciya"),
            keywords: &["rawaya", "rawayan zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב צהוב"),
            keywords: &["לב", "צהוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीला दिल"),
            keywords: &["दिल", "पीला", "भावना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žuto srce"),
            keywords: &["srce", "žuto"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sárga szív"),
            keywords: &["szív", "sárga"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեղին սիրտ"),
            keywords: &["դեղին", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati kuning"),
            keywords: &["hati", "kuning"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-acha èdò èdò"),
            keywords: &["obi na-acha èdò èdò", "èdò"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gult hjarta"),
            keywords: &["gult", "hjarta", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore giallo"),
            keywords: &["cuore", "emozione", "giallo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黄色のハート"),
            keywords: &["ハート", "黄色のハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati kuning"),
            keywords: &["ati kuning", "kuning"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყვითელი გული"),
            keywords: &["გული", "ყვითელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сары жүрек"),
            keywords: &["жүрек", "сары"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gult hjerte"),
            keywords: &["følelser", "gul", "gult hjerte", "hjerte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}លឿង"),
            keywords: &["បេះដ\u{17bc}ង", "បេះដ\u{17bc}ងពណ\u{17cc}លឿង", "លឿង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಳದ\u{cbf} ಹೃದಯ"),
            keywords: &["ಹಳದ\u{cbf}", "ಹಳದ\u{cbf} ಹೃದಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노란색 하트"),
            keywords: &["노란 하트", "노란색 하트", "사랑", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हळद\u{941}व\u{947}\u{902} काळीज"),
            keywords: &[
                "हळद\u{941}व\u{947}\u{902}",
                "हळद\u{941}व\u{947}\u{902} काळीज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сары жүрөк"),
            keywords: &["жүрөк", "сары"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gielt Häerz"),
            keywords: &["giel", "gielt Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສ\u{eb5}ເຫ\u{ebc}\u{eb7}ອງ"),
            keywords: &["ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈສ\u{eb5}ເຫ\u{ebc}\u{eb7}ອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("geltona širdelė"),
            keywords: &["geltona", "geltona širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzeltena sirds"),
            keywords: &["dzeltena sirds", "dzeltens", "sirds"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa kōwhai"),
            keywords: &["kōwhai", "manawa kōwhai"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жолто срце"),
            keywords: &["жолто", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മഞ\u{d4d}ഞ ഹ\u{d43}ദയം"),
            keywords: &["പ\u{d4d}രണയം", "മഞ\u{d4d}ഞ", "വിക\u{d3e}രം", "ഹ\u{d43}ദയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар зүрх"),
            keywords: &["зүрх", "шар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पिवळ\u{947} ह\u{94d}रदय"),
            keywords: &[
                "पिवळ\u{947}",
                "पिवळ\u{947} ह\u{943}दय",
                "पिवळ\u{947} ह\u{94d}रदय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati kuning"),
            keywords: &["hati", "hati kuning"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb safra"),
            keywords: &["isfar", "qalb safra"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဝါရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &["အဝါ", "အဝါရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gult hjerte"),
            keywords: &["følelser", "gul", "gult hjerte", "hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पह\u{947}\u{901}लो म\u{941}ट\u{941}"),
            keywords: &["पह\u{947}\u{901}लो", "म\u{941}ट\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geel hart"),
            keywords: &["geel", "geel hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gult hjarte"),
            keywords: &["gul", "gult hjarte", "hjarte", "kjensler"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହଳଦ\u{b3f}ଆ ହ\u{b43}ଦୟ"),
            keywords: &["ହଳଦ\u{b3f}ଆ", "ହଳଦ\u{b3f}ଆ ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪੀਲਾ ਦਿਲ"),
            keywords: &["ਜਜ\u{a3c}ਬਾਤ", "ਦਿਲ", "ਪੀਲਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیلا دل"),
            keywords: &["پیلا", "پیلا دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Yẹ\u{301}ló Hat"),
            keywords: &["Hat", "Yẹ\u{301}ló Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żółte serce"),
            keywords: &["serce", "żółte"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ژیړ زړه"),
            keywords: &["ژیړ", "ژیړ زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração amarelo"),
            keywords: &["amarelo", "coração", "emoção"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["amarelo", "coração"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼillu sunqu"),
            keywords: &["qʼillu", "qʼillu sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă galbenă"),
            keywords: &["galben", "inimă", "inimă galbenă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-600"),
            keywords: &["E10-600"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("желтое сердце"),
            keywords: &["желтое", "сердце"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima w’umuhondo"),
            keywords: &["umuhondo", "umutima w’umuhondo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيلي دل"),
            keywords: &["پيلي", "پيلي دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කහ හදවත"),
            keywords: &["කහ", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žlté srdce"),
            keywords: &["srdce", "žlté"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rumeno srce"),
            keywords: &["rumeno", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno jaalle ah"),
            keywords: &["jaalle", "wadno jaalle ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër e verdhë"),
            keywords: &["e verdhë", "zemër", "zemër e verdhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жуто срце"),
            keywords: &["жутo", "жуто срце", "срцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["жуто срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žuto srce"),
            keywords: &["srce", "žuto"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["žuto srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gult hjärta"),
            keywords: &["gul", "gult hjärta", "hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo wa manjano"),
            keywords: &["manjano", "moyo", "moyo wa manjano"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மஞ\u{bcd}சள\u{bcd} நிற இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "மஞ\u{bcd}சள\u{bcd}",
                "மஞ\u{bcd}சள\u{bcd} நிற இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పసుపు పచ\u{c4d}చ రంగు హృదయం"),
            keywords: &["పసుపు పచ\u{c4d}చ", "పసుపు పచ\u{c4d}చ రంగు హృదయం", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили зард"),
            keywords: &["дили зард", "зард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}เหล\u{e37}อง"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจส\u{e35}เหล\u{e37}อง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sary ýürek"),
            keywords: &["sary", "sary ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu engeenga"),
            keywords: &["mafu engeenga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarı kalp"),
            keywords: &["duygu", "kalp", "sarı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سېرىق يۈرەك"),
            keywords: &["سېرىق", "سېرىق يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жовте серце"),
            keywords: &["жовте серце", "жовтий", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیلا دل"),
            keywords: &["دل", "پیلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sariq yurak"),
            keywords: &["sariq", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu vàng"),
            keywords: &["màu vàng", "trái tim màu vàng"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu mboq"),
            keywords: &["mboq", "xol bu mboq"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo emthubi"),
            keywords: &["intliziyo emthubi", "mthubi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Awọ Ofeefe"),
            keywords: &["yẹ\u{301}lò", "Ọkan Awọ Ofeefe"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黃色心"),
            keywords: &["黃色", "黃色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黄色心"),
            keywords: &["黄色", "黄色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黄心"),
            keywords: &["黄", "黄心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黃心"),
            keywords: &["心型", "黃心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo eqanda"),
            keywords: &["inhliziyo", "inhliziyo eqanda", "qanda"],
        },
    ],
};
#[doc = "💚"]
pub const GREEN_HEART: crate::Emoji = crate::Emoji {
    glyph: "💚",
    codepoint: "1F49A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "green heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("groen hartjie"),
            keywords: &["groen", "groen hartjie", "hart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አረንጓዴ ልብ"),
            keywords: &["ልብ", "አረንጓዴ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أخضر"),
            keywords: &["أخضر", "قلب", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সেউজীয\u{9bc}\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "সেউজীয\u{9bc}\u{9be}",
                "সেউজীয\u{9bc}\u{9be} হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşıl ürək"),
            keywords: &["yaşıl", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зялёнае сэрца"),
            keywords: &["зялёнае сэрца", "зялёны", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Зелено сърце"),
            keywords: &["Зелено сърце", "зелен", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সব\u{9c1}জ হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "সব\u{9c1}জ",
                "সব\u{9c1}জ হ\u{9be}র\u{9cd}ট",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon wer"),
            keywords: &["gwer", "kalon wer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zeleno srce"),
            keywords: &["srce", "zelena", "zeleno srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor verd"),
            keywords: &["cor", "cor verd"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎢᏤᏳᏍᏗ ᎤᎿᏫ"),
            keywords: &["ᎢᏤᏳᏍᏗ", "ᎢᏤᏳᏍᏗ ᎤᎿᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zelené srdce"),
            keywords: &["srdce", "zelená", "zelené srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon werdd"),
            keywords: &["calon", "calon werdd", "gwyrdd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("grønt hjerte"),
            keywords: &["følelser", "grøn", "grønt hjerte", "hjerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("grünes Herz"),
            keywords: &["Herz", "grün", "grünes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πράσινη καρδιά"),
            keywords: &["καρδιά", "πράσινη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("green heart"),
            keywords: &["green", "green heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón verde"),
            keywords: &["corazón", "emoción", "verde"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón verde"),
            keywords: &["corazón verde"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["corazón verde", "verde"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("roheline süda"),
            keywords: &["roheline", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz berdea"),
            keywords: &["berde", "bihotz", "bihotz berdea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب سبز"),
            keywords: &["سبز", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vihreä sydän"),
            keywords: &["sydän", "vihreä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("berdeng puso"),
            keywords: &["berde", "berdeng puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("grønt hjarta"),
            keywords: &["grønt", "hjarta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur vert"),
            keywords: &["cœur", "cœur vert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "vert"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí glas"),
            keywords: &["croí", "croí glas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe uaine"),
            keywords: &["cridhe uaine", "uaine"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón verde"),
            keywords: &["corazón", "verde"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લીલ\u{ac1}\u{a82} દિલ"),
            keywords: &["દિલ", "લાગણી", "લીલ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("koren zuciya"),
            keywords: &["kore", "koren zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב ירוק"),
            keywords: &["ירוק", "לב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हरा दिल"),
            keywords: &["दिल", "भावना", "हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zeleno srce"),
            keywords: &["srce", "zeleno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zöld szív"),
            keywords: &["szív", "zöld"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կանաչ սիրտ"),
            keywords: &["կանաչ", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati hijau"),
            keywords: &["hati", "hijau"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-acha ndụ ndụ"),
            keywords: &["ndụ", "obi na-acha ndụ ndụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("grænt hjarta"),
            keywords: &["grænt", "hjarta", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore verde"),
            keywords: &["cuore", "emozione", "verde"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("緑のハート"),
            keywords: &["ハート", "緑のハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati ijo"),
            keywords: &["ati ijo", "ijo"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მწვანე გული"),
            keywords: &["გული", "მწვანე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жасыл жүрек"),
            keywords: &["жасыл", "жүрек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("grønt hjerte"),
            keywords: &["følelser", "grøn", "grønt hjerte", "hjerte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}បៃតង"),
            keywords: &["បេះដ\u{17bc}ង", "បេះដ\u{17bc}ងពណ\u{17cc}បៃតង", "បៃតង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಸ\u{cbf}ರು ಹೃದಯ"),
            keywords: &["ಹಸ\u{cbf}ರು", "ಹಸ\u{cbf}ರು ಹೃದಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("초록색 하트"),
            keywords: &["녹색 하트", "사랑", "초록색 하트", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पाचव\u{947}\u{902} काळीज"),
            keywords: &["पाचव\u{947}\u{902}", "पाचव\u{947}\u{902} काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жашыл жүрөк"),
            keywords: &["жашыл", "жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gréngt Häerz"),
            keywords: &["gréng", "gréngt Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສ\u{eb5}ຂຽວ"),
            keywords: &["ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈສ\u{eb5}ຂຽວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žalia širdelė"),
            keywords: &["žalia", "žalia širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zaļa sirds"),
            keywords: &["sirds", "zaļa sirds", "zaļš"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa kākāriki"),
            keywords: &["kākariki", "manawa kākāriki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зелено срце"),
            keywords: &["зелено", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പച\u{d4d}ച ഹ\u{d43}ദയം"),
            keywords: &["പച\u{d4d}ച", "പ\u{d4d}രണയം", "വിക\u{d3e}രം", "ഹ\u{d43}ദയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ногоон зүрх"),
            keywords: &["зүрх", "ногоон"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हिरव\u{947} ह\u{94d}रदय"),
            keywords: &[
                "हिरव\u{947}",
                "हिरव\u{947} ह\u{943}दय",
                "हिरव\u{947} ह\u{94d}रदय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati hijau"),
            keywords: &["hati", "hijau"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb ħadra"),
            keywords: &["aħdar", "qalb ħadra"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အစ\u{102d}မ\u{103a}းရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "အစ\u{102d}မ\u{103a}း",
                "အစ\u{102d}မ\u{103a}းရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("grønt hjerte"),
            keywords: &["følelser", "grønn", "grønt hjerte", "hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हरियो म\u{941}ट\u{941}"),
            keywords: &["म\u{941}ट\u{941}", "हरियो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("groen hart"),
            keywords: &["groen", "groen hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("grønt hjarte"),
            keywords: &["grøn", "grønt hjarte", "hjarte", "kjensler"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସବ\u{b41}ଜ ହ\u{b43}ଦୟ"),
            keywords: &["ସବ\u{b41}ଜ", "ସବ\u{b41}ଜ ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹਰਾ ਦਿਲ"),
            keywords: &["ਜਜ\u{a3c}ਬਾਤ", "ਦਿਲ", "ਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سبز دل"),
            keywords: &["سبز دل", "ہرا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Grín Hat"),
            keywords: &["Grin", "Grín Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zielone serce"),
            keywords: &["serce", "zielone"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شین زړه"),
            keywords: &["شین", "شین زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração verde"),
            keywords: &["coração", "emoção", "verde"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["coração", "verde"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qʼumir sunqu"),
            keywords: &["qʼumir", "qʼumir sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă verde"),
            keywords: &["inimă", "verde"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-599"),
            keywords: &["E10-599"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зеленое сердце"),
            keywords: &["зеленое", "сердце"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima w’icyatsi"),
            keywords: &["icyatsi", "umutima w’icyatsi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائي دل"),
            keywords: &["سائي", "سائي دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කොළ හදවත"),
            keywords: &["කොල", "කොළ හදවත", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zelené srdce"),
            keywords: &["srdce", "zelené"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zeleno srce"),
            keywords: &["srce", "zeleno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno cagaaran"),
            keywords: &["cagaar", "wadno cagaaran"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër jeshile"),
            keywords: &["jeshile", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зелено срце"),
            keywords: &["зeлeнo", "зелено срце", "срцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["зелено срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zeleno srce"),
            keywords: &["srce", "zeleno"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zeleno srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("grönt hjärta"),
            keywords: &["grön", "grönt hjärta", "hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo wa kijani"),
            keywords: &["kijani", "moyo", "moyo wa kijani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பச\u{bcd}சை நிற இதயம\u{bcd}"),
            keywords: &["இதயம\u{bcd}", "பச\u{bcd}சை", "பச\u{bcd}சை நிற இதயம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆకుపచ\u{c4d}చ రంగు హృదయం"),
            keywords: &["ఆకుపచ\u{c4d}చ", "ఆకుపచ\u{c4d}చ రంగు హృదయం", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили сабз"),
            keywords: &["дили сабз", "сабз"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}เข\u{e35}ยว"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจส\u{e35}เข\u{e35}ยว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýaşyl ýürek"),
            keywords: &["ýaşyl", "ýaşyl ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu lanumata"),
            keywords: &["mafu lanumata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yeşil kalp"),
            keywords: &["duygu", "kalp", "yeşil"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېشىل يۈرەك"),
            keywords: &["يېشىل", "يېشىل يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зелене серце"),
            keywords: &["зелене серце", "зелений", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سبز دل"),
            keywords: &["دل", "سبز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yashil yurak"),
            keywords: &["yashil", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu lục"),
            keywords: &["màu lục", "trái tim màu lục"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu wert"),
            keywords: &["wert", "xol bu wert"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo eluhlaza"),
            keywords: &["intliziyo eluhlaza", "luhlaza"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Awọ Ewe"),
            keywords: &["àwọ\u{300} ewé", "Ọkan Awọ Ewe"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("綠色心"),
            keywords: &["綠色", "綠色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("绿色心"),
            keywords: &["绿色", "绿色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("绿心"),
            keywords: &["绿", "绿心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("綠心"),
            keywords: &["心型", "綠心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo eluhlaza satshani"),
            keywords: &[
                "inhliziyo",
                "inhliziyo eluhlaza satshani",
                "luhlaza satshani",
            ],
        },
    ],
};
#[doc = "💙"]
pub const BLUE_HEART: crate::Emoji = crate::Emoji {
    glyph: "💙",
    codepoint: "1F499",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "blue heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blou hartjie"),
            keywords: &["blou", "blou hartjie", "hart"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰማያዊ ልብ"),
            keywords: &["ልብ", "ሰማያዊ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أزرق"),
            keywords: &["أزرق", "قلب", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নীল\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &["নীল\u{9be}", "নীল\u{9be} হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mavi ürək"),
            keywords: &["mavi", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сіняе сэрца"),
            keywords: &["сэрца", "сіняе сэрца", "сіні"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Синьо сърце"),
            keywords: &["Синьо сърце", "син", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নীল হ\u{9be}র\u{9cd}ট"),
            keywords: &["নীল", "নীল হ\u{9be}র\u{9cd}ট", "হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon cʼhlas"),
            keywords: &["glas", "kalon cʼhlas"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("plavo srce"),
            keywords: &["plava", "plavo srce", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor blau"),
            keywords: &["cor", "cor blau"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏌᎪᏂᎨ ᎤᎿᏫ"),
            keywords: &["ᏌᎪᏂᎨ", "ᏌᎪᏂᎨ ᎤᎿᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("modré srdce"),
            keywords: &["modrá", "modré srdce", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon las"),
            keywords: &["calon", "calon las", "glas"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blåt hjerte"),
            keywords: &["blå", "blåt hjerte", "følelser", "hjerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("blaues Herz"),
            keywords: &["Herz", "blau", "blaues Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μπλε καρδιά"),
            keywords: &["καρδιά", "μπλε"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("blue heart"),
            keywords: &["blue", "blue heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón azul"),
            keywords: &["azul", "corazón", "emoción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón azul"),
            keywords: &["corazón azul"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["azul", "corazón azul"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sinine süda"),
            keywords: &["sinine", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz urdina"),
            keywords: &["bihotz", "bihotz urdina", "urdin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب آبی"),
            keywords: &["آبی", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sininen sydän"),
            keywords: &["sininen", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("asul na puso"),
            keywords: &["asul", "asul na puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("blátt hjarta"),
            keywords: &["blátt", "hjarta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur bleu"),
            keywords: &["cœur", "cœur bleu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bleu", "cœur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí gorm"),
            keywords: &["croí", "croí gorm"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe gorm"),
            keywords: &["cridhe gorm", "gorm"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón azul"),
            keywords: &["azul", "corazón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાદળી દિલ"),
            keywords: &["દિલ", "લાગણી", "વાદળી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shuɗin zuciya"),
            keywords: &["shuɗi", "shuɗin zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב כחול"),
            keywords: &["כחול", "לב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नीला दिल"),
            keywords: &["दिल", "नीला", "भावना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plavo srce"),
            keywords: &["plavo", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kék szív"),
            keywords: &["kék", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կապույտ սիրտ"),
            keywords: &["կապույտ", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati biru"),
            keywords: &["biru", "hati"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-acha anụnụ anụnụ"),
            keywords: &["anụnụ", "obi na-acha anụnụ anụnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("blátt hjarta"),
            keywords: &["blátt", "hjarta", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore azzurro"),
            keywords: &["azzurro", "cuore", "emozione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("青いハート"),
            keywords: &["ハート", "青いハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati biru"),
            keywords: &["ati biru", "biru"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ლურჯი გული"),
            keywords: &["გული", "ლურჯი", "ცისფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көк жүрек"),
            keywords: &["жүрек", "көк"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blåt hjerte"),
            keywords: &["blå", "blåt hjerte", "følelser", "hjerte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}ខៀវ"),
            keywords: &["ខៀវ", "បេះដ\u{17bc}ង", "បេះដ\u{17bc}ងពណ\u{17cc}ខៀវ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೀಲ\u{cbf} ಹೃದಯ"),
            keywords: &["ನೀಲ\u{cbf} ಹೃದಯ", "ಭಾವನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("파란색 하트"),
            keywords: &["사랑", "파란 하트", "파란색 하트", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("निळ\u{947}\u{902} काळीज"),
            keywords: &["निळ\u{947}\u{902}", "निळ\u{947}\u{902} काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көк жүрөк"),
            keywords: &["жүрөк", "көк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("blot Häerz"),
            keywords: &["blo", "blot Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສ\u{eb5}ຟ\u{ec9}າ"),
            keywords: &["ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈສ\u{eb5}ຟ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mėlyna širdelė"),
            keywords: &["mėlyna", "mėlyna širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zila sirds"),
            keywords: &["sirds", "zila sirds", "zils"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa kikorangi"),
            keywords: &["kikorangi", "manawa kikorangi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сино срце"),
            keywords: &["сино", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീല ഹ\u{d43}ദയം"),
            keywords: &["നീല", "പ\u{d4d}രണയം", "വിക\u{d3e}രം", "ഹ\u{d43}ദയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цэнхэр зүрх"),
            keywords: &["зүрх", "цэнхэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("निळ\u{947} ह\u{943}दय"),
            keywords: &["निळ\u{947}", "निळ\u{947} ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati biru"),
            keywords: &["biru", "hati"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb blu"),
            keywords: &["blu", "qalb blu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပြာရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &["အပြာ", "အပြာရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("blått hjerte"),
            keywords: &["blå", "blått hjerte", "følelser", "hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नीलो म\u{941}ट\u{941}"),
            keywords: &["नीलो", "म\u{941}ट\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("blauw hart"),
            keywords: &["blauw", "blauw hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("blått hjarte"),
            keywords: &["blå", "blått hjarte", "hjarte", "kjensler"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନୀଳ ହ\u{b43}ଦୟ"),
            keywords: &["ନୀଳ", "ନୀଳ ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨੀਲਾ ਦਿਲ"),
            keywords: &["ਜਜ\u{a3c}ਬਾਤ", "ਦਿਲ", "ਨੀਲਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیلا دل"),
            keywords: &["نیلا", "نیلا دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blú Hat"),
            keywords: &["Blu", "Blú Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niebieskie serce"),
            keywords: &["niebieskie", "serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اسماني زړه"),
            keywords: &["اسماني", "اسماني زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração azul"),
            keywords: &["azul", "coração", "emoção"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["azul", "coração"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("anqas sunqu"),
            keywords: &["anqas", "anqas sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă albastră"),
            keywords: &["albastru", "inimă", "inimă albastră"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-598"),
            keywords: &["E10-598"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("синее сердце"),
            keywords: &["сердце", "синее"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima w’ubururu"),
            keywords: &["ubururu", "umutima w’ubururu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نيري دل"),
            keywords: &["نيري", "نيري دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ල\u{dca} හදවත"),
            keywords: &["න\u{dd2}ල\u{dca}", "න\u{dd2}ල\u{dca} හදවත", "හදචත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("modré srdce"),
            keywords: &["modré", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("modro srce"),
            keywords: &["modro", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno buluug ah"),
            keywords: &["buluug", "wadno buluug ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër blu"),
            keywords: &["blu", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плаво срце"),
            keywords: &["плaвo", "плаво срце", "срцe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["плаво срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plavo srce"),
            keywords: &["plavo", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["plavo srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blått hjärta"),
            keywords: &["blå", "blått hjärta", "hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo ya samawati"),
            keywords: &["moyo", "moyo ya samawati", "samawati"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}ல நிற இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "ந\u{bc0}ல நிற இதயம\u{bcd}",
                "ந\u{bc0}லம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c40}లం రంగు హృదయం"),
            keywords: &["న\u{c40}లం", "న\u{c40}లం రంగు హృదయం", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили кабуд"),
            keywords: &["дили кабуд", "кабуд"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}น\u{e49}ำเง\u{e34}น"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจส\u{e35}น\u{e49}ำเง\u{e34}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gök ýürek"),
            keywords: &["gök", "gök ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu lanupulū"),
            keywords: &["mafu lanupulū"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mavi kalp"),
            keywords: &["duygu", "kalp", "mavi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆك يۈرەك"),
            keywords: &["كۆك", "كۆك يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("синє серце"),
            keywords: &["серце", "синє серце", "синій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیلا دل"),
            keywords: &["دل", "نیلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘k yurak"),
            keywords: &["ko‘k", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu lam"),
            keywords: &["màu lam", "trái tim màu lam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu baxa"),
            keywords: &["baxa", "xol bu baxa"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo ebhlowu"),
            keywords: &["bhlowu", "intliziyo ebhlowu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Bulu"),
            keywords: &["búlù", "Ọkan Bulu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("藍色心"),
            keywords: &["藍色", "藍色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("蓝色心"),
            keywords: &["蓝色", "蓝色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("蓝心"),
            keywords: &["蓝", "蓝心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("藍心"),
            keywords: &["心型", "藍心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo eluhlaza sasibhakabhaka"),
            keywords: &[
                "inhliziyo",
                "inhliziyo eluhlaza sasibhakabhaka",
                "luhlaza sasibhakabhaka",
            ],
        },
    ],
};
#[doc = "💜"]
pub const PURPLE_HEART: crate::Emoji = crate::Emoji {
    glyph: "💜",
    codepoint: "1F49C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "purple heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("pers hartjie"),
            keywords: &["hart", "pers", "pers hartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወይን ጠጅ ልብ"),
            keywords: &["ልብ", "ወይን ጠጅ", "ወይን ጠጅ ልብ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أرجواني"),
            keywords: &["أرجواني", "قلب", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বেঙ\u{9c1}ণীয\u{9bc}\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "বেঙ\u{9c1}ণীয\u{9bc}\u{9be}",
                "বেঙ\u{9c1}ণীয\u{9bc}\u{9be} হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bənövşəyi ürək"),
            keywords: &["bənövşəyi", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фіялетавае сэрца"),
            keywords: &["сэрца", "фіялетавае сэрца", "фіялетавы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лилаво сърце"),
            keywords: &["Лилаво сърце", "лилаво", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বেগ\u{9c1}নি হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "বেগ\u{9c1}নি হ\u{9be}র\u{9cd}ট",
                "বেগ\u{9c1}নী",
                "হ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon limestra"),
            keywords: &["kalon limestra", "limestra"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljubičasto srce"),
            keywords: &["ljubičasta", "ljubičasto srce", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor lila"),
            keywords: &["cor", "cor lila"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎲᎵᎨ ᎤᎿᏫ"),
            keywords: &["ᎠᏓᎲᎵᎨ", "ᎠᏓᎲᎵᎨ ᎤᎿᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("fialové srdce"),
            keywords: &["fialová", "fialové srdce", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon borffor"),
            keywords: &["calon", "calon borffor", "porffor"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("violet hjerte"),
            keywords: &["følelser", "hjerte", "violet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("lila Herz"),
            keywords: &["Herz", "lila"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μοβ καρδιά"),
            keywords: &["μοβ", "μοβ καρδιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("purple heart"),
            keywords: &["purple", "purple heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón morado"),
            keywords: &["corazón", "emoción", "morado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("corazón morado"),
            keywords: &["corazón morado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["corazón", "emoción", "morado"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["corazón morado", "morado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lilla süda"),
            keywords: &["lilla", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz morea"),
            keywords: &["bihotz", "bihotz morea", "more"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب بنفش"),
            keywords: &["بنفش", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("violetti sydän"),
            keywords: &["sydän", "violetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("purple na puso"),
            keywords: &["purple", "purple na puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("korkalitt hjarta"),
            keywords: &[
                "bláreytt",
                "hjarta",
                "korkalitt",
                "lilla",
                "lillafarva",
                "purpurlitt",
                "purpurreytt",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur violet"),
            keywords: &["cœur", "cœur violet"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cœur", "violet"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí corcra"),
            keywords: &["croí", "croí corcra"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe purpaidh"),
            keywords: &["cridhe purpaidh", "purpaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón violeta"),
            keywords: &["corazón", "violeta"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જા\u{a82}બલી દિલ"),
            keywords: &["જા\u{a82}બલી", "દિલ", "લાગણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("algashin zuciya"),
            keywords: &["algashi", "algashin zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב סגול"),
            keywords: &["לב", "סגול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{948}\u{902}गनी दिल"),
            keywords: &["दिल", "ब\u{948}\u{902}गनी", "भावना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ljubičasto srce"),
            keywords: &["ljubičasto", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lila szív"),
            keywords: &["lila", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանուշակագույն սիրտ"),
            keywords: &["մանուշակագույն", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati ungu"),
            keywords: &["hati", "ungu"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi na-acha pọpụl"),
            keywords: &["obi na-acha pọpụl", "pọpụl"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fjólublátt hjarta"),
            keywords: &["fjólublátt", "hjarta", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore viola"),
            keywords: &["cuore", "emozione", "viola"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("紫のハート"),
            keywords: &["ハート", "紫のハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati wungu"),
            keywords: &["ati wungu", "wungu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("იასამნისფერი გული"),
            keywords: &["გული", "იასამნისფერი", "იისფერი", "მეწამული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("күлгін жүрек"),
            keywords: &["жүрек", "күлгін"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("violet hjerte"),
            keywords: &["følelser", "hjerte", "violet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}ស\u{17d2}វាយ"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងពណ\u{17cc}ស\u{17d2}វាយ",
                "ពណ\u{17cc}ស\u{17d2}វាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೇರಳ\u{cc6} ಹೃದಯ"),
            keywords: &[
                "ನೇರಳ\u{cc6} ಹೃದಯ",
                "ಪರ\u{ccd}ಪಲ\u{ccd} ಹಾರ\u{ccd}ಟ\u{ccd}",
                "ಪರ\u{ccd}ಪಲ\u{ccd} ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("보라색 하트"),
            keywords: &["보라색 하트", "사랑", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जा\u{902}भळ\u{947}\u{902} काळीज"),
            keywords: &[
                "जा\u{902}भळ\u{947}\u{902}",
                "जा\u{902}भळ\u{947}\u{902} काळीज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сыя түстүү жүрөк"),
            keywords: &["жүрөк", "сыя көк", "сыя түстүү жүрөк"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mooft Häerz"),
            keywords: &["mof", "mooft Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສ\u{eb5}ມ\u{ec8}ວງ"),
            keywords: &["ຫ\u{ebb}ວໃຈ", "ຫ\u{ebb}ວໃຈສ\u{eb5}ມ\u{ec8}ວງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("purpurinė širdelė"),
            keywords: &["purpurinė", "purpurinė širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("violeta sirds"),
            keywords: &["sirds", "violeta sirds", "violets"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa poroporo"),
            keywords: &["manawa poroporo", "poroporo"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виолетово срце"),
            keywords: &["виолетово", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പർപ\u{d4d}പിൾ ഹ\u{d43}ദയം"),
            keywords: &[
                "പ\u{d4d}രണയം",
                "പർപ\u{d4d}പിൾ",
                "വിക\u{d3e}രം",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нил ягаан зүрх"),
            keywords: &["зүрх", "нил ягаан", "нил ягаан зүрх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जा\u{902}भळ\u{947} ह\u{94d}रदय"),
            keywords: &[
                "जा\u{902}भळ\u{947}",
                "जा\u{902}भळ\u{947} ह\u{943}दय",
                "जा\u{902}भळ\u{947} ह\u{94d}रदय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati ungu"),
            keywords: &["hati", "ungu"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb vjola"),
            keywords: &["qalb vjola", "vjola"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခရမ\u{103a}းရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "ခရမ\u{103a}း",
                "ခရမ\u{103a}းရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lilla hjerte"),
            keywords: &["følelser", "hjerte", "lilla"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}याजी म\u{941}ट\u{941}"),
            keywords: &["प\u{94d}याजी", "म\u{941}ट\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("paars hart"),
            keywords: &["paars", "paars hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lilla hjarte"),
            keywords: &["hjarte", "kjensler", "lilla"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଇଗଣୀ ହ\u{b43}ଦୟ"),
            keywords: &["ବ\u{b3e}ଇଗଣୀ", "ବ\u{b3e}ଇଗଣୀ ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਮਨੀ ਦਿਲ"),
            keywords: &["ਜਜ\u{a3c}ਬਾਤ", "ਜਾਮਨੀ", "ਦਿਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جامنی دل"),
            keywords: &["جامنی", "جامنی دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pọ\u{301}pul Kọ\u{301}lọ Hat"),
            keywords: &[
                "Pọ\u{301}pul",
                "Pọ\u{301}pul Kọ\u{301}lọ Hat",
                "Pọ\u{301}púl Hat",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("purpurowe serce"),
            keywords: &["fioletowe", "purpurowe serce", "serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بنفش زړه"),
            keywords: &["بنفش", "بنفش زړه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração roxo"),
            keywords: &["coração", "emoção", "roxo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["coração", "roxo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kulli sunqu"),
            keywords: &["kulli", "kulli sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă mov"),
            keywords: &["inimă", "mov"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-601"),
            keywords: &["E10-601"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фиолетовое сердце"),
            keywords: &["сердце", "фиолетовое"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutima wa move"),
            keywords: &["umutima wa move", "umwura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("واڱڻائي دل"),
            keywords: &["واڱڻائي دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දම\u{dca} හදවත"),
            keywords: &["දම\u{dca}", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("fialové srdce"),
            keywords: &["fialové", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vijolično srce"),
            keywords: &["srce", "vijolično"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno midab-buluug-guddud ah"),
            keywords: &[
                "buluug-guduud",
                "wadno midab buluug-guuud ah",
                "wadno midab-buluug-guddud ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër ngjyrë vjollcë"),
            keywords: &["vjollcë", "zemër ngjyrë vjollcë", "zemër vjollcë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("љубичасто срце"),
            keywords: &["срцe", "љубичaстo", "љубичасто срце"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["љубичасто срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljubičasto srce"),
            keywords: &["ljubičasto", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ljubičasto srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lila hjärta"),
            keywords: &["hjärta", "lila"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo wa zambarau"),
            keywords: &["moyo", "moyo wa zambarau", "zambarau"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பர\u{bcd}பிள\u{bcd} நிற இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "ஊத\u{bbe}",
                "ஊத\u{bbe} நிற இதயம\u{bcd}",
                "பர\u{bcd}பிள\u{bcd} நிற இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఊద\u{c3e} రంగు హృదయం"),
            keywords: &["ఊద\u{c3e}", "ఊద\u{c3e} రంగు హృదయం", "హృదయం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили арғувонӣ"),
            keywords: &["арғувонӣ", "дили арғувонӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}ม\u{e48}วง"),
            keywords: &["ห\u{e31}วใจ", "ห\u{e31}วใจส\u{e35}ม\u{e48}วง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mawy ýürek"),
            keywords: &["mawy", "mawy ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu lanufesiʻifekika"),
            keywords: &["mafu lanufesiʻifekika"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mor kalp"),
            keywords: &["duygu", "kalp", "mor"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆسۈن يۈرەك"),
            keywords: &["سۆسۈن", "سۆسۈن يۈرەك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("пурпурове серце"),
            keywords: &["пурпурове серце", "серце", "фіолетовий"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ارغوانی دل"),
            keywords: &["ارغوانی", "دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("binafsharang yurak"),
            keywords: &["binafsharang", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim tím"),
            keywords: &["trái tim tím", "tím"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu yolet"),
            keywords: &["xol bu yolet", "yolet"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo emfusa"),
            keywords: &["intliziyo emfusa", "mfusa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkan Awọ Pọpu"),
            keywords: &["pọ\u{301}pù", "Ọkan Awọ Pọpu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("紫色心"),
            keywords: &["紫色", "紫色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("紫色心"),
            keywords: &["紫色", "紫色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("紫心"),
            keywords: &["紫", "紫心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("紫心"),
            keywords: &["心型", "紫心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ensomi"),
            keywords: &["inhliziyo", "inhliziyo ensomi", "nsomi"],
        },
    ],
};
#[doc = "🤎"]
pub const BROWN_HEART: crate::Emoji = crate::Emoji {
    glyph: "🤎",
    codepoint: "1F90E",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "brown heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bruin hartjie"),
            keywords: &["bruin", "hartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቡናማ ልብ"),
            keywords: &["ልብ", "ቡናማ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب بني"),
            keywords: &["بني", "قلب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}গ\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &["ম\u{9c2}গ\u{9be}", "হ\u{9c3}দয\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qəhvəyi ürək"),
            keywords: &["qəhvəyi", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("карычневае сэрца"),
            keywords: &["карычневае", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кафяво сърце"),
            keywords: &["кафяво", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খয\u{9bc}েরি হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "খয\u{9bc}েরি হ\u{9be}র\u{9cd}ট",
                "ব\u{9be}দ\u{9be}মি",
                "হ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon cʼhell"),
            keywords: &["gell", "kalon cʼhell"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("smeđe srce"),
            keywords: &["smeđa", "smeđe srce", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor marró"),
            keywords: &["cor", "marró"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏬᏗᎨ ᎤᎾᏫ"),
            keywords: &["ᎤᎾᏫ", "ᎤᏬᏗᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hnědé srdce"),
            keywords: &["hnědá", "hnědé srdce", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon frown"),
            keywords: &["brown", "calon", "calon frown"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("brunt hjerte"),
            keywords: &["brun", "brunt hjerte", "hjerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("braunes Herz"),
            keywords: &["Herz", "braun", "braunes Herz"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("braunes Herz"),
            keywords: &["braunes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καφέ καρδιά"),
            keywords: &["καρδιά", "καφέ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("brown heart"),
            keywords: &["brown", "heart"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón marrón"),
            keywords: &["corazón", "emoción", "marrón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("corazón café"),
            keywords: &["corazón", "corazón café", "emoción", "marrón"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("corazón café"),
            keywords: &["café", "corazón café", "marrón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pruun süda"),
            keywords: &["pruun", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz marroia"),
            keywords: &["bihotz", "bihotz marroia", "marroi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب قهوه\u{200c}ای"),
            keywords: &["قلب", "قهوه\u{200c}ای"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ruskea sydän"),
            keywords: &["ruskea", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kayumangging puso"),
            keywords: &["kayumanggi", "kayumangging puso", "puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("brúnt hjarta"),
            keywords: &["brúnt", "hjarta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur marron"),
            keywords: &["brun", "cœur marron", "marron"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cœur brun"),
            keywords: &["brun", "cœur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí donn"),
            keywords: &["croí", "donn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe donn"),
            keywords: &["cridhe", "donn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón marrón"),
            keywords: &["castaño", "corazón", "marrón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કથ\u{acd}થઈ હ\u{ac3}દય"),
            keywords: &["કથ\u{acd}થઈ", "હ\u{ac3}દય"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב חום"),
            keywords: &["חום", "לב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भ\u{942}रा दिल"),
            keywords: &["दिल", "भ\u{942}रा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("smeđe srce"),
            keywords: &["smeđe", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("barna szív"),
            keywords: &["barna", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դարչնագույն սիրտ"),
            keywords: &["դարչնագույն", "սիրտ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati cokelat"),
            keywords: &["cokelat", "hati"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brúnt hjarta"),
            keywords: &["brúnt", "hjarta"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore marrone"),
            keywords: &["cuore", "emozione", "marrone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("茶色いハート"),
            keywords: &["ハート", "茶色いハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati soklat"),
            keywords: &["ati", "soklat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყავისფერი გული"),
            keywords: &["გული", "ყავისფერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қоңыр жүрек"),
            keywords: &["жүрек", "қоңыр"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}ត\u{17d2}នោត"),
            keywords: &[
                "បេះដ\u{17bc}ង",
                "បេះដ\u{17bc}ងពណ\u{17cc}ត\u{17d2}នោត",
                "ពណ\u{17cc}ត\u{17d2}នោត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಂದುಬಣ\u{ccd}ಣದ ಹೃದಯ"),
            keywords: &["ಕಂದು", "ಕಂದುಬಣ\u{ccd}ಣದ ಹೃದಯ", "ಹೃದಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("갈색 하트"),
            keywords: &["갈색", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तपकिरी काळीज"),
            keywords: &["तपकिरी", "तपकिरी काळीज"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("күрөң жүрөк"),
            keywords: &["жүрөк", "күрөң"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວ\u{200b}ໃຈ\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ"),
            keywords: &[
                "ສ\u{eb5}\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ",
                "ຫ\u{ebb}ວ\u{200b}ໃຈ",
                "ຫ\u{ebb}ວ\u{200b}ໃຈ\u{200b}ນ\u{ec9}ຳ\u{200b}ຕານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ruda širdelė"),
            keywords: &["ruda", "širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("brūna sirds"),
            keywords: &["brūna", "sirds"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кафеаво срце"),
            keywords: &["кафеаво", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബ\u{d4d}ര\u{d57}ൺ ഹ\u{d43}ദയം"),
            keywords: &["ബ\u{d4d}ര\u{d57}ൺ", "ഹ\u{d43}ദയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүрэн зүрх"),
            keywords: &["зүрх", "хүрэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तपकिरी ह\u{943}दय"),
            keywords: &["तपकिरी", "ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati perang"),
            keywords: &["hati", "perang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အည\u{102d}\u{102f}ရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား"),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}း",
                "အည\u{102d}\u{102f}ရောင\u{103a}",
                "အည\u{102d}\u{102f}ရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("brunt hjerte"),
            keywords: &["brun", "brunt hjerte", "hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{948}रो ह\u{943}दय"),
            keywords: &["ख\u{948}रो", "ह\u{943}दय"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bruin hart"),
            keywords: &["bruin", "hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("brunt hjarte"),
            keywords: &["brun", "brunt hjarte", "hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଦ\u{b3e}ମୀ ହ\u{b43}ଦୟ"),
            keywords: &["ବ\u{b3e}ଦ\u{b3e}ମୀ", "ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਭ\u{a42}ਰਾ ਦਿਲ"),
            keywords: &["ਦਿਲ", "ਭ\u{a42}ਰਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Braún Hat"),
            keywords: &["Braún", "Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("brązowe serce"),
            keywords: &["brązowe", "serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نسواري زړه"),
            keywords: &["زړه", "نسواري"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração marrom"),
            keywords: &["coração", "marrom"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração castanho"),
            keywords: &["castanho", "coração"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("cafe sunqu"),
            keywords: &["cafe", "sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă maro"),
            keywords: &["inimă", "maro"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–023"),
            keywords: &["E12–023"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("коричневое сердце"),
            keywords: &["бурый", "коричневое", "коричневый", "сердце"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("برائون دل"),
            keywords: &["برائون دل", "دل", "ناسي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd4}ඹ\u{dd4}ර\u{dd4} හදවත"),
            keywords: &["ද\u{dd4}ඹ\u{dd4}ර\u{dd4}", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hnedé srdce"),
            keywords: &["hnedé", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rjavo srce"),
            keywords: &["rjavo", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadne bunni ah"),
            keywords: &["bunni", "wadne", "wadne bunni ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër në ngjyrë kafe"),
            keywords: &["ngjyrë kafe", "zemër", "zemër në ngjyrë kafe"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("браон срце"),
            keywords: &["браон", "срце"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("braon srce"),
            keywords: &["braon", "srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("brunt hjärta"),
            keywords: &["brunt", "hjärta"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo wa hudhurungi"),
            keywords: &["hudhurungi", "moyo", "moyo wa hudhurungi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பழுப\u{bcd}பு நிற இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "பழுப\u{bcd}பு",
                "பழுப\u{bcd}பு நிற இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4b}ధుమరంగు హృదయం"),
            keywords: &["గ\u{c4b}ధుమరంగు", "హృదయం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}น\u{e49}ำตาล"),
            keywords: &[
                "ส\u{e35}น\u{e49}ำตาล",
                "ห\u{e31}วใจ",
                "ห\u{e31}วใจส\u{e35}น\u{e49}ำตาล",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goňur ýürek"),
            keywords: &["goňur", "ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu melomelo"),
            keywords: &["mafu melomelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kahverengi kalp"),
            keywords: &["kahverengi", "kalp"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("коричневе серце"),
            keywords: &["коричневе", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھورا دل"),
            keywords: &["بھورا", "دل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jigarrang yurak"),
            keywords: &["jigarrang", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu nâu"),
            keywords: &["màu nâu", "trái tim", "trái tim màu nâu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("啡色心"),
            keywords: &["啡色", "啡色心", "心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("啡色心"),
            keywords: &["啡色", "啡色心", "心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("棕心"),
            keywords: &["心", "心形", "棕", "棕心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("褐心"),
            keywords: &["心", "褐", "褐心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("啡心｜啡色心｜啡色嘅心"),
            keywords: &["啡", "啡心｜啡色心｜啡色嘅心", "心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo ensundu"),
            keywords: &["inhliziyo", "inhliziyo ensundu", "insundu"],
        },
    ],
};
#[doc = "🖤"]
pub const BLACK_HEART: crate::Emoji = crate::Emoji {
    glyph: "🖤",
    codepoint: "1F5A4",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "black heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("swart hartjie"),
            keywords: &["boos", "hart", "sleg", "swart", "swart hartjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥቁር ልብ"),
            keywords: &["ልብ", "ሰይጣን", "እርጉም", "ጥቁር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أسود"),
            keywords: &["أسود", "شر", "قلب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক’ল\u{9be} হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "ক’ল\u{9be}",
                "ক’ল\u{9be} হ\u{9c3}দয\u{9bc}",
                "বিদ\u{9cd}বেষপ\u{9c2}ৰ\u{9cd}ণ",
                "মন\u{9cd}দ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qara-ürək adam"),
            keywords: &["pis", "qara", "qara-ürək adam", "xislət", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чорнае сэрца"),
            keywords: &["злосць", "сэрца", "чорнае"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("черно сърце"),
            keywords: &["зло", "сърце", "черно"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}লো হ\u{9be}র\u{9cd}ট"),
            keywords: &[
                "ক\u{9be}লো",
                "দ\u{9c1}ষ\u{9cd}ট",
                "ব\u{9be}জে",
                "হ\u{9be}র\u{9cd}ট",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon zu"),
            keywords: &["du", "kalon zu"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("crno srce"),
            keywords: &["crno", "iskvareno", "srce", "zlo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor negre"),
            keywords: &["cor", "cor negre"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎿᎨ ᎤᎾᏫ"),
            keywords: &["ᎤᏲ", "ᎤᏲᎢᏳᎢ", "ᎬᎿᎨ", "ᎬᎿᎨ ᎤᎾᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("černé srdce"),
            keywords: &[
                "smutek",
                "srdce",
                "zkaženost",
                "zlo",
                "černá",
                "černé srdce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon ddu"),
            keywords: &["calon ddu", "drwg", "du", "maleisus"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sort hjerte"),
            keywords: &["hjerte", "ondskab", "ondt", "sort"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwarzes Herz"),
            keywords: &["Herz", "böse", "schwarz", "schwarzes Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαύρη καρδιά"),
            keywords: &["κακός", "καρδιά", "μαγεμένος", "μαύρη καρδιά", "μαύρο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("black heart"),
            keywords: &["black", "black heart", "evil", "wicked"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón negro"),
            keywords: &["corazón", "negro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["corazón negro", "malo", "malvado", "negro"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("must süda"),
            keywords: &["kuri", "must", "süda"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz beltza"),
            keywords: &["beltz", "bihotz", "bihotz beltza", "zital", "zorigaitz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب سیاه"),
            keywords: &[
                "سنگ\u{200c}دل",
                "سیاه",
                "سیاه\u{200c}دل",
                "شرور",
                "شیطانی",
                "قلب سیاه",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("musta sydän"),
            keywords: &["musta", "sydän"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("itim na puso"),
            keywords: &["itim", "itim na puso", "masama", "puso", "sama"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svart hjarta"),
            keywords: &["hjarta", "svart"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur noir"),
            keywords: &["cœur noir", "noir"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí dubh"),
            keywords: &["croí dubh", "dona", "dubh", "gránna"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe dubh"),
            keywords: &["cridhe dubh", "dubh", "olc"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón negro"),
            keywords: &["corazón", "maldade", "malvado", "negro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાળ\u{ac1}\u{a82} હ\u{ac3}દય"),
            keywords: &["કાળ\u{ac1}\u{a82}", "ખરાબ", "હ\u{ac3}દય"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baƙin zuciya"),
            keywords: &["baƙi", "baƙin zuciya", "mugu", "sharri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב שחור"),
            keywords: &["אפל", "כישוף", "לב", "מאגיה", "שחור", "שחורה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("काला दिल"),
            keywords: &["काला", "दिल", "ब\u{941}राई", "श\u{948}तान"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("crno srce"),
            keywords: &["crno", "iskvareno", "srce", "zlo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fekete szív"),
            keywords: &["fekete", "gonosz", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սև սիրտ"),
            keywords: &["չար", "սիրտ", "սև"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati hitam"),
            keywords: &["hati", "hitam", "jahat", "kejam"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("obi ojii"),
            keywords: &["obi ojii", "ojii", "àgwà", "ọjọọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svart hjarta"),
            keywords: &["hjarta", "illt innræti", "svart hjarta", "svartur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore nero"),
            keywords: &["cuore", "dolore", "nero", "tristezza"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("黒いハート"),
            keywords: &["ハート", "黒いハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati ireng"),
            keywords: &["ala", "ati ireng", "culika", "ireng"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შავი გული"),
            keywords: &["ალქაჯი", "ბოროტი", "გული", "შავი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүрегі қара"),
            keywords: &["жүрегі", "қара"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sort hjerte"),
            keywords: &["hjerte", "ondskab", "ondt", "sort"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}ខ\u{17d2}មៅ"),
            keywords: &[
                "ខ\u{17d2}មៅ",
                "ធ\u{17d2}មប\u{17cb}",
                "ប\u{17b7}សាច",
                "បេះដ\u{17bc}ងពណ\u{17cc}ខ\u{17d2}មៅ",
                "បេះដ\u{17bc}វ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ರ\u{ccd}ದಯ ಹೃದಯ"),
            keywords: &[
                "ಕಪ\u{ccd}ಪು",
                "ಕ\u{cc6}ಡುಕು",
                "ದುಷ\u{ccd}ಟ",
                "ನ\u{cbf}ರ\u{ccd}ದಯ ಹೃದಯ",
                "ಹೃದಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("검은색 하트"),
            keywords: &["검은색 하트", "검정", "블랙", "악", "하트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळ\u{947}\u{902} काळीज"),
            keywords: &[
                "काळ\u{947}\u{902}",
                "काळ\u{947}\u{902} काळीज",
                "द\u{941}ष\u{94d}ट",
                "वायट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кара жүрөк"),
            keywords: &["жинденүү", "жүрөк", "кара"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwaarzt Häerz"),
            keywords: &["béis", "schlecht", "schwaarz", "schwaarzt Häerz"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວໃຈສ\u{eb5}ດຳ"),
            keywords: &[
                "ຊ\u{ebb}\u{ec8}ວຮ\u{ec9}າຍ",
                "ດຳ",
                "ຫ\u{ebb}ວໃຈສ\u{eb5}ດຳ",
                "ໃຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("juoda širdis"),
            keywords: &["blogis", "juoda", "širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("melna sirds"),
            keywords: &["melna", "sirds", "ļaunums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("manawa pango"),
            keywords: &["kino", "manawa pango", "nanakia", "pango"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("црно срце"),
            keywords: &["зло", "морбидно", "црно срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കറ\u{d41}ത\u{d4d}ത ഹ\u{d43}ദയം"),
            keywords: &[
                "കറ\u{d41}ത\u{d4d}ത ഹ\u{d43}ദയം",
                "കറ\u{d41}പ\u{d4d}പ\u{d4d}",
                "തിന\u{d4d}മ",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хар зүрх"),
            keywords: &["зүрх", "хар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("काळ\u{947} ह\u{94d}रदय"),
            keywords: &[
                "काळ\u{947}",
                "काळ\u{947} ह\u{943}दय",
                "काळ\u{947} ह\u{94d}रदय",
                "द\u{941}ष\u{94d}ट",
                "वाईट",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati hitam"),
            keywords: &["hati hitam", "hitam", "jahat", "kejam"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qalb sewda"),
            keywords: &["iswed", "qalb sewda", "ħażen", "ħażin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အနက\u{103a}ရောင\u{103a}န\u{103e}လ\u{102f}\u{1036}းသား"),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}းသား",
                "မကောင\u{103a}းစ\u{102d}တ\u{103a}",
                "ယ\u{102f}တ\u{103a}မာသော",
                "အနက\u{103a}",
                "အနက\u{103a}ရောင\u{103a}န\u{103e}လ\u{102f}\u{1036}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svart hjerte"),
            keywords: &["hjerte", "ond", "svart"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अर\u{942}को भलो नचिताउन\u{947}"),
            keywords: &[
                "अर\u{942}को भलो नचिताउन\u{947}",
                "कालो",
                "खराव",
                "द\u{941}ष\u{94d}ट",
                "म\u{941}ट\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zwart hart"),
            keywords: &["slecht", "verdorven", "zwart", "zwart hart"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svart hjarte"),
            keywords: &["hjarte", "svart", "vond"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଳ\u{b3e} ହ\u{b43}ଦୟ"),
            keywords: &[
                "କଳ\u{b3e}",
                "କଳ\u{b3e} ହ\u{b43}ଦୟ",
                "ଦ\u{b41}ଷ\u{b4d}ଟ",
                "ମନ\u{b4d}ଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਲਾ ਦਿਲ"),
            keywords: &["ਕਾਲਾ", "ਦਿਲ", "ਬ\u{a41}ਰਾਈ", "ਸ\u{a3c}\u{a48}ਤਾਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کالا دل"),
            keywords: &["بھیڑ", "شرارتی", "کالا", "کالا دل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blák Hat"),
            keywords: &["Bad", "Blak", "Blák Hat", "Wíkẹd"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("czarne serce"),
            keywords: &["czarne serce", "czarny", "serce", "zło"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تور زړه"),
            keywords: &["بد", "تور", "تور زړه", "شر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração preto"),
            keywords: &["coração", "negro", "preto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("coração preto"),
            keywords: &["coração", "malvado", "mau", "preto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yana sunqu"),
            keywords: &["saqra", "supay", "yana", "yana sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă neagră"),
            keywords: &["inimă", "inimă neagră", "malefic", "negru", "rău"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-810"),
            keywords: &["E10-810"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("черное сердце"),
            keywords: &["злоба", "сердце", "черное"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("imitima yirabura"),
            keywords: &["cy’umugome", "ikibi", "imitima yirabura", "umukara"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاري دل"),
            keywords: &["برائي", "حرامي", "ڪارو", "ڪاري دل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කළ\u{dd4} හදවත"),
            keywords: &[
                "කළ\u{dd4}",
                "ද\u{dd4}ෂ\u{dca}ට",
                "නප\u{dd4}ර\u{dd4}",
                "හදවත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čierne srdce"),
            keywords: &["podlosť", "srdce", "zlo", "čierne"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("črno srce"),
            keywords: &["hudobno", "podlo", "srce", "zlobno", "črno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadno madoow"),
            keywords: &["madoow", "wadno madoow", "xumaan", "xun"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër e zezë"),
            keywords: &["e zezë", "i keq", "ligësi", "zemër", "zemër e zezë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("црно срце"),
            keywords: &["срце", "црно", "љубомора"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["црно срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("crno srce"),
            keywords: &["crno", "ljubomora", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["crno srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("svart hjärta"),
            keywords: &["hjärta", "ond", "svart"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("umbo nyeusi la moyo"),
            keywords: &["moyo", "moyo mweusi", "umbo nyeusi la moyo", "uovu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கருப\u{bcd}பு நிற இதயம\u{bcd}"),
            keywords: &[
                "கருப\u{bcd}பு",
                "கருப\u{bcd}பு நிற இதயம\u{bcd}",
                "கெட\u{bcd}ட",
                "கோபம\u{bcd}",
                "த\u{bc0}ய",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నలుపు రంగు హృదయం"),
            keywords: &[
                "చ\u{c46}డు",
                "నలుపు",
                "నలుపు రంగు హృదయం",
                "మ\u{c4b}సపూర\u{c3f}త",
                "హృదయం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дили сиёҳ"),
            keywords: &["бад", "дили сиёҳ", "сиёҳ", "шарир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ใจดำ"),
            keywords: &["ดำ", "ห\u{e31}วใจส\u{e35}ดำ", "ใจดำ", "ใจร\u{e49}าย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gara ýürek"),
            keywords: &["betniýetli", "erbet", "gara", "gara ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu ʻuliʻuli"),
            keywords: &["mafu ʻuliʻuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("siyah kalp"),
            keywords: &["fena", "kalp", "kötü", "siyah"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قارا يۈرەك"),
            keywords: &["رەزىل", "قارا", "قارا يۈرەك", "يامان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чорне серце"),
            keywords: &["зло", "серце", "чорне"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کالا دل"),
            keywords: &["برا", "دل", "شیطانی", "کالا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ichi qora"),
            keywords: &["ichi qora", "qora", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tim đen"),
            keywords: &["tim đen", "xấu", "đen", "điều ác"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xol bu ñuul"),
            keywords: &["iñaan", "soxor", "xol bu ñuul", "ñuul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intliziyo emnyama"),
            keywords: &["ekhohlakeleyo", "emnyama", "intliziyo emnyama", "ububi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkàn Dúdú"),
            keywords: &["dúdú", "èṣù", "ìkà", "Ọkàn Dúdú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("黑色心"),
            keywords: &["邪惡", "黑色", "黑色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("黑色心"),
            keywords: &["邪恶", "黑色", "黑色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("黑心"),
            keywords: &["心", "邪恶", "黑心", "黑色"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑心"),
            keywords: &["心", "邪惡", "黑", "黑心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo embi"),
            keywords: &[
                "inhliziyo",
                "inhliziyo embi",
                "khohlakele",
                "mnyama",
                "ubuthakathi",
            ],
        },
    ],
};
#[doc = "🤍"]
pub const WHITE_HEART: crate::Emoji = crate::Emoji {
    glyph: "🤍",
    codepoint: "1F90D",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "white heart",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wit hartjie"),
            keywords: &["hartjie", "wit"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ነጭ ልብ"),
            keywords: &["ልብ", "ነጭ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قلب أبيض"),
            keywords: &["أبيض", "بياض", "قلب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বগ\u{9be} হ\u{9c3}দয\u{9bc}ৰ ছবি"),
            keywords: &[
                "বগ\u{9be}",
                "বগ\u{9be} হ\u{9c3}দয\u{9bc}ৰ ছবি",
                "হ\u{9c3}দয\u{9bc}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağ ürək"),
            keywords: &["ağ", "ürək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("белае сэрца"),
            keywords: &["белае", "сэрца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бяло сърце"),
            keywords: &["бяло", "сърце"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}দ\u{9be} হ\u{9be}র\u{9cd}ট"),
            keywords: &["স\u{9be}দ\u{9be}", "হ\u{9be}র\u{9cd}ট"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon wenn"),
            keywords: &["gwenn", "kalon wenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bijelo srce"),
            keywords: &["bijela", "bijelo srce", "srce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor blanc"),
            keywords: &["blanc", "cor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏁᎦ ᎤᎾᏫ"),
            keywords: &["ᎤᎾᏫ", "ᎤᏁᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bílé srdce"),
            keywords: &["bílá", "bílé srdce", "srdce"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("calon wen"),
            keywords: &["calon", "calon wen", "gwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hvidt hjerte"),
            keywords: &["hjerte", "hvid", "hvidt hjerte"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weißes Herz"),
            keywords: &["Herz", "weiß", "weißes Herz"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("weisses Herz"),
            keywords: &["weisses Herz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("λευκή καρδιά"),
            keywords: &["καρδιά", "λευκή καρδιά", "λευκό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("white heart"),
            keywords: &["heart", "white"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón blanco"),
            keywords: &["blanco", "corazón", "emoción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["blanco", "corazón"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("valge süda"),
            keywords: &["süda", "valge"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotz zuria"),
            keywords: &["bihotz", "bihotz zuria", "zuri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب سفید"),
            keywords: &["سفید", "قلب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("valkoinen sydän"),
            keywords: &["sydän", "valkoinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puting puso"),
            keywords: &["puso", "puti", "puting puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hvítt hjarta"),
            keywords: &["hjarta", "hvítt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur blanc"),
            keywords: &["blanc", "cœur blanc"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí bán"),
            keywords: &["bán", "croí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe geal"),
            keywords: &["cridhe", "geal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("corazón branco"),
            keywords: &["branco", "corazón"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શ\u{acd}વ\u{ac7}ત હ\u{ac3}દય"),
            keywords: &["શ\u{acd}વ\u{ac7}ત", "હ\u{ac3}દય"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב לבן"),
            keywords: &["לב", "לבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सफ\u{93c}\u{947}द दिल"),
            keywords: &["दिल", "सफ\u{93c}\u{947}द"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bijelo srce"),
            keywords: &["bijelo", "srce"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fehér szív"),
            keywords: &["fehér", "szív"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սպիտակ սիրտ"),
            keywords: &["սիրտ", "սպիտակ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hati putih"),
            keywords: &["hati", "putih"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hvítt hjarta"),
            keywords: &["hjarta", "hvítt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuore bianco"),
            keywords: &["bianco", "cuore", "emozione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("白いハート"),
            keywords: &["ハート", "白いハート"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ati putih"),
            keywords: &["ati", "putih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თეთრი გული"),
            keywords: &["გული", "თეთრი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақ жүрек"),
            keywords: &["ақ", "жүрек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បេះដ\u{17bc}ងពណ\u{17cc}ស"),
            keywords: &["បេះដ\u{17bc}ង", "បេះដ\u{17bc}ងពណ\u{17cc}ស", "ពណ\u{17cc}ស"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cbf}ಳ\u{cbf}ಯ ಹೃದಯ"),
            keywords: &["ಬ\u{cbf}ಳ\u{cbf}", "ಬ\u{cbf}ಳ\u{cbf}ಯ ಹೃದಯ", "ಹೃದಯ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("흰색 하트"),
            keywords: &["하트", "흰색"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("धव\u{947}\u{902} काळीज"),
            keywords: &["काळीज", "धव\u{947}\u{902}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ак жүрөк"),
            keywords: &["ак", "жүрөк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebb}ວ\u{200b}ໃຈ\u{200b}ຂາວ"),
            keywords: &[
                "ສ\u{eb5}\u{200b}ຂາວ",
                "ຫ\u{ebb}ວ\u{200b}ໃຈ",
                "ຫ\u{ebb}ວ\u{200b}ໃຈ\u{200b}ຂາວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("balta širdelė"),
            keywords: &["balta", "širdelė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("balta sirds"),
            keywords: &["balta", "sirds"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бело срце"),
            keywords: &["бело", "срце"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വെള\u{d41}ത\u{d4d}ത ഹ\u{d43}ദയം"),
            keywords: &[
                "വെള\u{d41}ത\u{d4d}ത ഹ\u{d43}ദയം",
                "വെള\u{d4d}ള",
                "ഹ\u{d43}ദയം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цагаан зүрх"),
            keywords: &["зүрх", "цагаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पा\u{902}ढर\u{947} ह\u{943}दय"),
            keywords: &["पा\u{902}ढर\u{947}", "ह\u{943}दय"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hati putih"),
            keywords: &["hati", "putih"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဖြ\u{1030}ရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား"),
            keywords: &[
                "န\u{103e}လ\u{102f}\u{1036}း",
                "အဖြ\u{1030}",
                "အဖြ\u{1030}ရောင\u{103a} န\u{103e}လ\u{102f}\u{1036}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hvitt hjerte"),
            keywords: &["hjerte", "hvit", "hvitt hjerte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}तो ह\u{943}दय"),
            keywords: &["स\u{947}तो", "ह\u{943}दय"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wit hart"),
            keywords: &["hart", "wit"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvitt hjarte"),
            keywords: &["hjarte", "kvit", "kvitt hjarte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧଳ\u{b3e} ହ\u{b43}ଦୟ"),
            keywords: &["ଧଳ\u{b3e}", "ହ\u{b43}ଦୟ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚਿ\u{a71}ਟਾ ਦਿਲ"),
            keywords: &["ਚਿ\u{a71}ਟਾ", "ਦਿਲ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Waít Hat"),
            keywords: &["Hat", "Wait", "Waít Hat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("białe serce"),
            keywords: &["białe", "serce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سپين زړه"),
            keywords: &["زړه", "سپين"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração branco"),
            keywords: &["branco", "coração"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuraq sunqu"),
            keywords: &["sunqu", "yuraq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă albă"),
            keywords: &["alb", "albă", "inimă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–022"),
            keywords: &["E12–022"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("белое сердце"),
            keywords: &["белое", "белый", "сердце"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سفيد دل"),
            keywords: &["دل", "سفيد"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ද\u{dd4} හදවත"),
            keywords: &["ස\u{dd4}ද\u{dd4}", "හදවත"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("biele srdce"),
            keywords: &["biele", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("belo srce"),
            keywords: &["belo", "srce"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wadne cad (cabsi og)"),
            keywords: &["cad", "wadne", "wadne cad (cabsi og)"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër e bardhë"),
            keywords: &["e bardhë", "zemër", "zemër e bardhë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бело срце"),
            keywords: &["бела", "бело срце", "срце"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бијело срце"),
            keywords: &["бијело срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("belo srce"),
            keywords: &["bela", "belo srce", "srce"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bijelo srce"),
            keywords: &["bijelo srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vitt hjärta"),
            keywords: &["hjärta", "vitt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo mweupe"),
            keywords: &["moyo", "moyo mweupe", "nyeupe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெள\u{bcd}ளை நிற இதயம\u{bcd}"),
            keywords: &[
                "இதயம\u{bcd}",
                "வெள\u{bcd}ளை",
                "வெள\u{bcd}ளை நிற இதயம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}లుపురంగు హృదయం"),
            keywords: &["త\u{c46}లుపురంగు", "హృదయం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจส\u{e35}ขาว"),
            keywords: &["ส\u{e35}ขาว", "ห\u{e31}วใจ", "ห\u{e31}วใจส\u{e35}ขาว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ak ýürek"),
            keywords: &["ak", "ýürek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu hinehina"),
            keywords: &["mafu hinehina"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyaz kalp"),
            keywords: &["beyaz", "kalp"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("біле серце"),
            keywords: &["біле", "серце"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سفید دل"),
            keywords: &["دل", "سفید"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oq yurak"),
            keywords: &["oq", "yurak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trái tim màu trắng"),
            keywords: &["màu trắng", "trái tim", "trái tim màu trắng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("白色心"),
            keywords: &["心", "白色", "白色心"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("白色心"),
            keywords: &["心", "白色", "白色心"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白心"),
            keywords: &["心", "心形", "白", "白心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("白心"),
            keywords: &["心", "白", "白心"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("白心｜白色心｜白色嘅心"),
            keywords: &["心", "白", "白心｜白色心｜白色嘅心"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inhliziyo emhlophe"),
            keywords: &["inhliziyo", "inhliziyo emhlophe", "mhlophe"],
        },
    ],
};
#[doc = "💯"]
pub const HUNDRED_POINTS: crate::Emoji = crate::Emoji {
    glyph: "💯",
    codepoint: "1F4AF",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "hundred points",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("honderd punte"),
            keywords: &[
                "100",
                "honderd",
                "honderd punte",
                "persent",
                "telling",
                "vol",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መቶ ነጥቦች"),
            keywords: &["100", "መቶ", "መቶ ነጥቦች", "ሙሉ", "ውጤት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("100 درجة"),
            keywords: &["100", "100 نقطة", "درجة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("১০০ নম\u{9cd}বৰ"),
            keywords: &[
                "এশ",
                "এশ নম\u{9cd}বৰ",
                "প\u{9c2}ৰ\u{9be}",
                "স\u{9cd}ক’ৰ",
                "১০০",
                "১০০ নম\u{9cd}বৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("100 xal"),
            keywords: &["100", "hundqırmızı", "tam", "xal"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сто ачкоў"),
            keywords: &["100", "ачкоў", "максімум", "сто"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сто точки"),
            keywords: &["100", "резултат", "сто", "сто точки"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("একশো পয\u{9bc}েন\u{9cd}ট"),
            keywords: &[
                "100",
                "একশো পয\u{9bc}েন\u{9cd}ট",
                "প\u{9c2}র\u{9cd}ণ",
                "শত",
                "স\u{9cd}কোর",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kant poent"),
            keywords: &["100", "kant", "kant poent"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sto poena"),
            keywords: &["100", "poeni", "pun", "sto", "sto poena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("100 punts"),
            keywords: &["100", "cent punts", "punts", "puntuació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎪᎯᏧᏈ ᎬᏅᏅᎢ"),
            keywords: &["100", "ᎠᎪᎯᏧᏈ ᎬᏅᏅᎢ", "ᎤᏅᏅᎢ", "ᎧᎵᎢ", "ᏍᎪᎯᏧᏈ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sto bodů"),
            keywords: &["100", "plný", "skóre", "sto", "sto bodů"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cant o bwyntiau"),
            keywords: &["100", "cant", "cant o bwyntiau", "llawn", "sgôr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("100 point"),
            keywords: &["100", "alle rigtige", "hundrede", "point"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("100 Punkte"),
            keywords: &["100", "100 Punkte", "Punktestand", "volle Punktzahl"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εκατό πόντοι"),
            keywords: &["100", "βαθμολογία", "εκατό", "εκατό πόντοι", "πλήρες"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hundred points"),
            keywords: &["100", "full", "hundred", "hundred points", "score"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cien puntos"),
            keywords: &["100", "cien puntos", "pleno", "puntos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("100 puntos"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["100", "perfecto", "puntaje", "puntos", "puntuación"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sada punkti"),
            keywords: &["100", "punkt", "sada", "sada punkti", "täis"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ehun puntu"),
            keywords: &["100", "ehun", "ehun puntu", "oso", "puntuazio"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("۱۰۰ امتیاز"),
            keywords: &["امتیاز", "تمام", "صد", "نمره", "کامل", "۱۰۰"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sata pistettä"),
            keywords: &["100", "pisteet", "sata pistettä", "täydet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sandaang puntos"),
            keywords: &[
                "100",
                "buo",
                "iskor",
                "marka",
                "puntos",
                "sandaan",
                "sandaang puntos",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hundrað stig"),
            keywords: &["100", "hundrað", "stig", "úrslit"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cent points"),
            keywords: &["cent", "cent points"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cent", "cent points", "marque", "score"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scór iomlán"),
            keywords: &["100", "100 pointe", "scór iomlán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceud puing"),
            keywords: &["100", "ceud", "puing", "sgòr", "slàn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("100 puntos"),
            keywords: &["100", "cen", "puntos", "puntuación"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સો પોઇન\u{acd}ટ\u{acd}સ"),
            keywords: &[
                "100",
                "100 પોઇન\u{acd}ટ\u{acd}સ",
                "પ\u{ac2}ર\u{acd}ણ સ\u{acd}કોર",
                "સો પોઇન\u{acd}ટ\u{acd}સ",
                "સ\u{acd}કોર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("makunan ɗari"),
            keywords: &["100", "cikakke", "maki", "makunan ɗari", "ɗari"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ציון 100"),
            keywords: &["100", "מבחן", "ניקוד", "ציון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("100 अ\u{902}क"),
            keywords: &[
                "100",
                "अ\u{902}क",
                "प\u{942}र\u{947} अ\u{902}क",
                "सौ अ\u{902}क",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sto bodova"),
            keywords: &["100", "potpuno", "rezultat", "sto", "sto bodova"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("száz pont"),
            keywords: &["100", "száz", "száz pont", "teljes pontszám"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հարյուր միավոր"),
            keywords: &["100", "ամբողջ", "հաշիվ", "հարյուր", "միավոր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("nilai seratus"),
            keywords: &["100", "lengkap", "nilai seratus", "seratus", "skor"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("pọịntị narị gasị"),
            keywords: &["100", "akara", "narị", "n’uju", "pọịntị narị gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fullt hús"),
            keywords: &["100", "fullt hús", "stig"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("100 punti"),
            keywords: &["100", "punteggio pieno", "punti"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("100点満点"),
            keywords: &["100", "100点", "100点満点", "全問正解", "満点"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("biji satus"),
            keywords: &["100", "biji satus", "kebak", "satus", "sekor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ასი ქულა"),
            keywords: &["100", "ასი", "სავსე", "ქულა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүз балл"),
            keywords: &["100", "жүз", "жүз балл", "толық", "ұпай"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("100 point"),
            keywords: &["100 point", "alle rigtige", "hundrede", "point"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ព\u{17b7}ន\u{17d2}ទ\u{17bb}១០០"),
            keywords: &["100", "ព\u{17b7}ន\u{17d2}ទ\u{17bb}១០០"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cc2}ರು ಪಾಯ\u{cbf}ಂಟ\u{ccd}\u{200c}ಗಳು"),
            keywords: &[
                "100 ಅಂಕಗಳು",
                "ನ\u{cc2}ರು ಪಾಯ\u{cbf}ಂಟ\u{ccd}\u{200c}ಗಳು",
                "ಪ\u{cc2}ರ\u{ccd}ಣ ಸ\u{ccd}ಕೋರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("백점"),
            keywords: &["백점", "백점 표시"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{902}भर ग\u{942}ण"),
            keywords: &[
                "100",
                "प\u{942}र\u{94d}ण",
                "श\u{902}भर",
                "श\u{902}भर ग\u{942}ण",
                "स\u{94d}कोर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүз упай"),
            keywords: &["100", "жүз", "толук", "упай"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("honnert Punkten"),
            keywords: &["100", "Score", "honnert", "honnert Punkten", "voll"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄະແນນຮ\u{ec9}ອຍ"),
            keywords: &["100", "ຄະແນນ", "ຄະແນນຮ\u{ec9}ອຍ", "ຮ\u{ec9}ອຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šimtas taškų"),
            keywords: &["100", "pilnas", "rezultatas", "šimtas", "šimtas taškų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("simt punktu"),
            keywords: &["100", "simt", "simt punktu", "simts"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rau piro"),
            keywords: &["100", "kotahi rau", "kī", "piro", "rau piro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сто поени"),
            keywords: &["100", "поени", "сто поени"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("100 പോയിന\u{d4d}റ\u{d4d}"),
            keywords: &[
                "100",
                "100 പോയിന\u{d4d}റ\u{d4d}",
                "പ\u{d42}ർണ\u{d4d}ണ സ\u{d4d}കോർ",
                "സ\u{d4d}കോർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зуун оноо"),
            keywords: &["дээд", "зуу", "зуун оноо", "оноо"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{902}भर ग\u{941}ण"),
            keywords: &["100", "ग\u{941}ण", "प\u{942}र\u{94d}ण", "श\u{902}भर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("seratus mata"),
            keywords: &["100", "penuh", "seratus", "seratus mata", "skor"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mitt punt"),
            keywords: &["100", "mija", "mitt punt", "punteġġ", "sħiħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမ\u{103e}တ\u{103a} တစ\u{103a}ရာ"),
            keywords: &[
                "တစ\u{103a}ရာ",
                "ရမ\u{103e}တ\u{103a}",
                "အပြည\u{1037}\u{103a}",
                "အမ\u{103e}တ\u{103a} တစ\u{103a}ရာ",
                "၁၀၀",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hundre poeng"),
            keywords: &["100", "full pott", "hundre poeng", "poeng"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सयवटा अ\u{902}कहर\u{942}"),
            keywords: &[
                "अ\u{902}क",
                "प\u{942}रा",
                "सय",
                "सयवटा अ\u{902}कहर\u{942}",
                "१००",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("maximumscore"),
            keywords: &["100", "100 punten", "maximumscore", "score"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hundre poeng"),
            keywords: &["100", "full pott", "hundre poeng", "poeng"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶହେ ପଏଣ\u{b4d}ଟ"),
            keywords: &[
                "100",
                "ପ\u{b42}ର\u{b4d}ଣ\u{b4d}ଣ",
                "ଶହେ",
                "ଶହେ ପଏଣ\u{b4d}ଟ",
                "ସ\u{b4d}କୋର\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a4c} ਅ\u{a70}ਕ"),
            keywords: &[
                "100",
                "ਪ\u{a42}ਰ\u{a47}",
                "ਸਕ\u{a4b}ਰ",
                "ਸ\u{a4c} ਅ\u{a70}ਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سو نکات"),
            keywords: &["100", "سو", "سو نکات", "سکور", "پورا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Skọ Wé Bi Wọ\u{301}n Họ\u{301}ndrẹ\u{301}d Pọínt"),
            keywords: &[
                "100",
                "Ful",
                "Họ\u{301}ndrẹd",
                "Skọ",
                "Skọ Wé Bi Wọ\u{301}n Họ\u{301}ndrẹ\u{301}d Pọínt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sto punktów"),
            keywords: &["100", "setka", "sto punktów", "stówa", "stówka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سل ټکي"),
            keywords: &["100", "بشپړه", "سل", "سل ټکي", "نمرې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cem pontos"),
            keywords: &[
                "100",
                "100 pontos",
                "cem pontos",
                "pontuação",
                "pontuação total",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cem pontos"),
            keywords: &["100", "cem", "cem pontos", "pontuação"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pachaq chikukuna"),
            keywords: &["100", "chikukuna", "hunta", "pachaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("o sută de puncte"),
            keywords: &["100", "maxim", "o sută de puncte", "scor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-620"),
            keywords: &["E10-620"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сто баллов"),
            keywords: &["100", "очки", "очков", "сто", "сто баллов"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amanota ijana"),
            keywords: &["100", "amanota ijana", "ijana", "inota", "yuzuye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سو نقطا"),
            keywords: &["100", "اسڪور", "سئو", "سو نقطا", "پورا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ලක\u{dd4}ණ\u{dd4} ස\u{dd2}යය\u{dd2}"),
            keywords: &[
                "100",
                "ලක\u{dd4}ණ\u{dd4}",
                "ලක\u{dd4}ණ\u{dd4} ස\u{dd2}යය\u{dd2}",
                "සම\u{dca}ප\u{dd6}ර\u{dca}ණ",
                "ස\u{dd2}යය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sto bodov"),
            keywords: &["100", "plný počet", "sto", "sto bodov"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sto točk"),
            keywords: &["100", "sto", "sto točk"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("boqol dhibco"),
            keywords: &["boqol", "boqol dhibco", "boqol dhico", "buuxo", "dhibcaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njëqind pikë"),
            keywords: &["100", "njëqind", "njëqind pikë", "plot", "rezultat"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сто поена"),
            keywords: &["100", "пoтпунo", "рeзултaт", "стo", "сто поена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sto poena"),
            keywords: &["100", "potpuno", "rezultat", "sto", "sto poena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("100 poäng"),
            keywords: &["100 poäng", "full pott"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pointi mia moja"),
            keywords: &["100", "alama", "kamili", "mia moja", "pointi mia moja"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நூற\u{bcd}றுக\u{bcd}கு நூறு"),
            keywords: &[
                "100",
                "நூற\u{bcd}றுக\u{bcd}கு நூறு",
                "முழு மதிப\u{bcd}பெண\u{bcd}",
                "முழு ஸ\u{bcd}கோர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("100 ప\u{c3e}య\u{c3f}ంట\u{c4d}\u{200c}లు"),
            keywords: &["100 ప\u{c3e}య\u{c3f}ంట\u{c4d}\u{200c}లు", "సంఖ\u{c4d}య"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сад хол"),
            keywords: &["100", "пурра", "сад", "хол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คะแนนเต\u{e47}ม"),
            keywords: &["100 คะแนน", "คะแนนเต\u{e47}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýüz utuk"),
            keywords: &["100", "doly", "utuk", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("poini ʻe teau"),
            keywords: &["poini ʻe teau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yüz puan"),
            keywords: &["100", "100 puan", "skor", "yüz puan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈز نومۇر"),
            keywords: &["100", "تولۇق", "نومۇر", "يۈز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("cто балів"),
            keywords: &["100", "cто балів", "максимум", "рахунок", "сто", "сто очок"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سو پوائنٹس"),
            keywords: &["اسکور", "سو", "سو پوائنٹس", "پورے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yuz ball"),
            keywords: &["100", "ball", "to‘liq", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("100 điểm"),
            keywords: &["100", "một trăm", "toàn bộ", "điểm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tombi teeméer"),
            keywords: &["100", "eskoor", "fees", "tombi teeméer", "téemeer"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amanqaku alikhulu"),
            keywords: &["100", "amanqaku alikhulu", "igcwele", "ikhulu", "inqaku"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("koko ọgọrun"),
            keywords: &["100", "koko ọgọrun", "kún", "ìṣirò", "ọgọ\u{301}rùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("一百分"),
            keywords: &["100", "一百分", "分數", "滿分", "百"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("一百分"),
            keywords: &["100", "一百分", "分数", "满分", "百"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("一百分"),
            keywords: &["一百分", "满分", "考试"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("滿分"),
            keywords: &["100分", "滿分"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("100 分"),
            keywords: &["100", "100 分", "一百", "一百分"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amaphuzu ayikhulu"),
            keywords: &[
                "100",
                "amaphuzu ayikhulu",
                "ikhulu",
                "okugcwele",
                "umphumela",
            ],
        },
    ],
};
#[doc = "💢"]
pub const ANGER_SYMBOL: crate::Emoji = crate::Emoji {
    glyph: "💢",
    codepoint: "1F4A2",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "anger symbol",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("woedesimbool"),
            keywords: &["kwaad", "strokie", "woede", "woedesimbool"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የንዴት ምልክት"),
            keywords: &["ንዴት", "አስቂኝ", "እብድ", "የንዴት ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رمز الغضب"),
            keywords: &["رمز الغضب", "علامة غضب", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খঙৰ প\u{9cd}ৰতীক"),
            keywords: &["কমিক", "খং", "খঙৰ প\u{9cd}ৰতীক", "প\u{9be}গল"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qəzəb simvolu"),
            keywords: &["acıqlı", "hirsli", "komik", "qəzəb simvolu"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сімвал злосці"),
            keywords: &["злы", "камічны", "раздражненне", "сімвал злосці", "шалёны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Символ за гняв"),
            keywords: &["Символ за гняв", "гняв", "комикс", "ядосан"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রোধের প\u{9cd}রতীক"),
            keywords: &[
                "কমিক",
                "ক\u{9cd}র\u{9c1}দ\u{9cd}ধ",
                "ক\u{9cd}রোধের প\u{9cd}রতীক",
                "ক\u{9cd}ষিপ\u{9cd}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("simbol ljutnje"),
            keywords: &["bijes", "ljutnja", "simbol ljutnje", "stripovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("símbol d’enuig"),
            keywords: &["còmic", "enfadat", "enuig", "malhumorat", "símbol d’enuig"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᎸᎯ ᏓᏟᎶᏍᏛᎢ"),
            keywords: &["ᎤᎿᎸᎯ", "ᎤᎿᎸᎯ ᏓᏟᎶᏍᏛᎢ", "ᎤᏬᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("japonský symbol hněvu"),
            keywords: &[
                "hněv",
                "japonský symbol hněvu",
                "komiks",
                "manga",
                "naštvaný",
                "vztek",
                "zloba",
                "zlost",
                "úder",
                "žíly",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("symbol dicter"),
            keywords: &["comig", "dig", "gwallgof", "symbol dicter"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vrede"),
            keywords: &["følelse", "tegn for vrede", "vrede"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ärger"),
            keywords: &["Comic", "Wut", "Ärger"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύμβολο θυμού"),
            keywords: &["θυμωμένος", "κόμικ", "οργισμένος", "σύμβολο θυμού"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("anger symbol"),
            keywords: &["anger symbol", "angry", "comic", "mad"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de enfado"),
            keywords: &["cómic", "enfadado", "enfado", "símbolo de enfado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("enojo"),
            keywords: &["cómics", "emoción", "enojo", "señal de enojo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("símbolo de enfado"),
            keywords: &["cómics", "emoción", "señal de enojo", "símbolo de enfado"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("símbolo de enfado"),
            keywords: &["comic", "enfado", "enojado", "símbolo de enfado"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("viha sümbol"),
            keywords: &["koomiks", "tige", "viha sümbol", "vihane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("amorruaren ikurra"),
            keywords: &["amorruaren ikurra", "haserre", "komiki", "sutan"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد عصبانیت"),
            keywords: &["دیوانه", "عصبانی", "مصور", "نماد عصبانیت", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viha"),
            keywords: &["sarjakuva", "viha", "vihainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("simbolo ng galit"),
            keywords: &["galit", "inis", "simbolo ng galit"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vreiði tekin"),
            keywords: &["tekin", "vreiði"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("symbole de colère"),
            keywords: &["colère", "dessin", "furieux", "symbole de colère"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bande dessinée",
                "colère",
                "furieux",
                "symbole",
                "symbole de colère",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail feirge"),
            keywords: &["fearg", "feargach", "siombail feirge"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla feirge"),
            keywords: &["aodann", "dealbh-èibhinn", "feargach", "samhla feirge"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de enfado"),
            keywords: &["cómic", "enfado", "símbolo de enfado"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ગ\u{ac1}સ\u{acd}સાન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "કોમિક",
                "ગ\u{ac1}સ\u{acd}સાન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ગ\u{ac1}સ\u{acd}સ\u{ac7} થય\u{ac7}લ\u{ac1}\u{a82}",
                "ગ\u{ac1}સ\u{acd}સો",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar fushi"),
            keywords: &["alamar fushi", "fushi", "haushi", "mai ban dariya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סמל כעס"),
            keywords: &["כעס", "סמל כעס", "פיצוץ"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ग\u{941}स\u{94d}स\u{947} का चिह\u{94d}न"),
            keywords: &[
                "कॉमिक",
                "ग\u{941}स\u{94d}सा",
                "ग\u{941}स\u{94d}स\u{947} का चिह\u{94d}न",
                "ग\u{941}स\u{94d}स\u{948}ल",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("simbol ljutnje"),
            keywords: &["bijes", "karikatura", "ljuto", "simbol ljutnje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("a düh szimbóluma"),
            keywords: &["a düh szimbóluma", "dühös", "képregény", "mérges"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զայրույթի նշան"),
            keywords: &["զայրացած", "զայրույթի նշան", "խենթ", "կոմիքս", "նշան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("marah"),
            keywords: &["komik", "marah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara iwe"),
            keywords: &["akara iwe", "ara", "iwe", "mkpaọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("reiði"),
            keywords: &["reiði", "reiðitákn", "reiður", "skrípó", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("rabbia"),
            keywords: &[
                "arrabbiato",
                "emozione",
                "fumetto",
                "rabbia",
                "simbolo rabbia",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("むかっ"),
            keywords: &["むかっ", "怒り", "＃"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("simbol nesu"),
            keywords: &["komik", "muring", "nesu", "simbol nesu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სიბრაზის სიმბოლო"),
            keywords: &["გაბრაზებული", "სასაცილო", "სიბრაზის სიმბოლო", "შეშლილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құтырған"),
            keywords: &["ашулы", "комик", "құтырған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vrede"),
            keywords: &["følelse", "tegn for vrede", "vrede"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សញ\u{17d2}ញាខ\u{17b9}ង"),
            keywords: &["ខ\u{17b9}ង\u{200b}", "សញ\u{17d2}ញាខ\u{17b9}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೋಪದ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"),
            keywords: &["ಉದ\u{ccd}ವೇಗ", "ಕೋಪ", "ಕೋಪದ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화남"),
            keywords: &["울컥", "화", "화남"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रागाची ख\u{942}ण"),
            keywords: &["पिश\u{947}\u{902}", "राग", "रागाची ख\u{942}ण", "विनोदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачуулануу белгиси"),
            keywords: &["ачуулануу белгиси", "ачуулуу", "комикс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Rosereiszeechen"),
            keywords: &["Comic", "Rosereiszeechen", "béis", "rosen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb1}ນຍາລ\u{eb1}ກໃຈຮ\u{ec9}າຍ"),
            keywords: &[
                "ສ\u{eb1}ນຍາລ\u{eb1}ກໃຈຮ\u{ec9}າຍ",
                "ອາລ\u{ebb}ມ",
                "ໃຈຮ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pykčio simbolis"),
            keywords: &["komiksas", "piktas", "pykčio simbolis", "supykęs"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dusmu simbols"),
            keywords: &["dusmu simbols", "dusmīgs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu riri"),
            keywords: &["pukuriri", "pōrangi", "tohu riri", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лутина"),
            keywords: &["лут", "лутина", "налутен", "стрип"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ദേഷ\u{d4d}യ ചിഹ\u{d4d}നം"),
            keywords: &[
                "കോപം",
                "കോമിക\u{d4d}ക\u{d4d}",
                "ദേഷ\u{d4d}യ ചിഹ\u{d4d}നം",
                "ദേഷ\u{d4d}യം",
                "ദേഷ\u{d4d}യം ചിഹ\u{d4d}നം",
                "ദേഷ\u{d4d}യപ\u{d4d}പെടൽ",
                "വിക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уурлаж байгаа дүрслэл"),
            keywords: &["дүрслэл", "уурлаж байгаа дүрслэл", "уурлах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रागाच\u{947} प\u{94d}रतीक"),
            keywords: &[
                "कॉमिक",
                "म\u{942}र\u{94d}ख",
                "रागाच\u{947} प\u{94d}रतीक",
                "रागावल\u{947}ला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol marah"),
            keywords: &["berang", "komik", "marah", "simbol marah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("simbolu ta’ rabja"),
            keywords: &["irrabjat", "irrabjat ħafna", "komiku", "simbolu ta’ rabja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဒေါသ"),
            keywords: &["ဒေါသ", "ဒေါသ သင\u{103a}\u{1039}ကေတ", "ဟာသ", "အရ\u{1030}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sinne"),
            keywords: &["følelse", "sinne", "sinnesymbol", "sint", "tegneserie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिसको स\u{902}क\u{947}त"),
            keywords: &[
                "पागल",
                "रिस",
                "रिसको स\u{902}क\u{947}त",
                "ह\u{901}साउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("woedesymbool"),
            keywords: &["boos", "kwaad", "strip", "woedesymbool"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sinne"),
            keywords: &["kjensle", "sinne", "sinnesymbol", "sint", "teikneserie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b4d}ରୋଧ ସଙ\u{b4d}କେତ"),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "କ\u{b4d}ରୋଧ",
                "କ\u{b4d}ରୋଧ ଚ\u{b3f}ହ\u{b4d}ନ",
                "କ\u{b4d}ରୋଧ ସଙ\u{b4d}କେତ",
                "କ\u{b4d}ରୋଧୀ",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ହ\u{b3e}ସ\u{b4d}ୟୋଦ\u{b4d}ଦୀପକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗ\u{a41}\u{a71}ਸ\u{a47} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਗ\u{a41}\u{a71}ਸਾ",
                "ਗ\u{a41}\u{a71}ਸ\u{a47}",
                "ਗ\u{a41}\u{a71}ਸ\u{a47} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਗ\u{a41}\u{a71}ਸ\u{a47} ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਜਜ\u{a3c}ਬਾਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("غصے دی علامت"),
            keywords: &[
                "ر\u{64f}سنا",
                "غصے دی علامت",
                "م\u{64f}ضح\u{650}کہ خیز",
                "پاگل",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vẹ\u{301}ks Sain"),
            keywords: &[
                "Pẹ\u{301}sin Wé De Mék Pípul Laf",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "To Vẹ\u{301}ks Wẹ\u{301}l Wẹl",
                "Vẹks",
                "Vẹ\u{301}ks Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("symbol gniewu"),
            keywords: &["symbol gniewu", "złość"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د قهر نښه"),
            keywords: &["د قهر نښه", "قهر", "لیونۍ", "مسخره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("símbolo de raiva"),
            keywords: &["com raiva", "emoção", "engraçado", "símbolo de raiva"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("símbolo de raiva"),
            keywords: &[
                "desenho",
                "enfurecido",
                "irritado",
                "símbolo de fúria",
                "símbolo de raiva",
                "zangado",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phiñakuy unancha"),
            keywords: &["comic", "mana allin", "phiñakuy", "phiñakuy unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("simbol mânie"),
            keywords: &["bandă desenată", "furie", "simbol mânie", "supărare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-607"),
            keywords: &["E10-607"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок «гнев»"),
            keywords: &["гнев", "злость", "значок «гнев»", "ярость"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’uburakari"),
            keywords: &["ikimenyetso cy’uburakari", "inkuru ishushanyije", "irakaje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪاوڙ جي نشاني"),
            keywords: &["چريو", "ڪامڪ", "ڪاوڙ", "ڪاوڙ جي نشاني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තරහ ලක\u{dd4}ණ"),
            keywords: &[
                "කේන\u{dca}ත\u{dd2}",
                "තරහ ලක\u{dd4}ණ",
                "ප\u{dd2}ස\u{dca}ස\u{dd4}",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("symbol hnevu"),
            keywords: &["hnev", "komiks", "symbol hnevu", "zlosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("simbol jeze"),
            keywords: &["divje", "jezno", "simbol jeze", "strip"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda xanaaqa"),
            keywords: &[
                "calaadda xanaaqa",
                "calaamadda xanaaqa",
                "majaajileeye",
                "xanaaq",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("simboli i zemërimit"),
            keywords: &[
                "i inatosur",
                "i zemëruar",
                "simboli i zemërimit",
                "vizatim komik",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("симбол љутње"),
            keywords: &["бeс", "симбол љутње", "стрип", "љутo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["симбол љутње"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("simbol ljutnje"),
            keywords: &["bes", "ljuto", "simbol ljutnje", "strip"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["simbol ljutnje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("symbol för ilska"),
            keywords: &["arg", "ilska", "symbol för ilska"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("alama ya hasira"),
            keywords: &["alama ya hasira", "ghadhabu", "hasira", "kibonzo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோபம\u{bcd}"),
            keywords: &[
                "ஆவேசம\u{bcd}",
                "கோபம\u{bcd}",
                "சினம\u{bcd}",
                "ச\u{bc0}ற\u{bcd}றம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}ప\u{c3e}న\u{c3f}క\u{c3f} చ\u{c3f}హ\u{c4d}నం"),
            keywords: &[
                "క\u{c4b}పం",
                "క\u{c4b}ప\u{c3e}న\u{c3f}క\u{c3f} చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("аломати ғазаб"),
            keywords: &["аломати ғазаб", "девона", "мазҳакавӣ", "хашмгин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e31}ญล\u{e31}กษณ\u{e4c}ความโกรธ"),
            keywords: &["ส\u{e31}ญล\u{e31}กษณ\u{e4c}ความโกรธ", "โกรธ", "โมโห"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gaharyň nyşany"),
            keywords: &["gaharly", "gaharyň nyşany", "gazaply", "gülkünç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakaʻilonga ʻita"),
            keywords: &["fakaʻilonga ʻita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("öfke simgesi"),
            keywords: &[
                "duygu",
                "çizgi roman",
                "öfke işareti",
                "öfke simgesi",
                "öfkeli",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاچچىق بەلگىسى"),
            keywords: &["ئاچچىق بەلگىسى", "خاپا", "ساراڭ", "كۈلكە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ гніву"),
            keywords: &["злий", "комікси", "розлючений", "символ гніву"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("غصے کی علامت"),
            keywords: &["علامت", "غصہ", "غصے کی علامت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jahl belgisi"),
            keywords: &["jahl belgisi", "jaxl", "latifa", "telba"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("biểu tượng giận giữ"),
            keywords: &["biểu tượng giận giữ", "hài hước", "tức giận", "điên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màndarga ku mer"),
            keywords: &["dof", "mer", "màndarga ku mer", "reelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isimboli yomsindo"),
            keywords: &["hlekisa", "isimboli yomsindo", "ukucaphuka", "umsindo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Àmì Ibinu"),
            keywords: &["bínú", "Àmì Ibinu", "àwàdà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嬲嘅標誌"),
            keywords: &["嬲", "嬲嘅標誌", "搞笑", "發癲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("嬲嘅标志"),
            keywords: &["发癫", "嬲", "嬲嘅标志", "搞笑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("怒"),
            keywords: &["怒", "火大", "生气", "青筋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("怒"),
            keywords: &["怒", "火大", "爆青筋"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["怒", "爆青筋"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lokudinwa"),
            keywords: &["ukucasuka", "ukudinwa", "uphawu lokudinwa"],
        },
    ],
};
#[doc = "💥"]
pub const COLLISION: crate::Emoji = crate::Emoji {
    glyph: "💥",
    codepoint: "1F4A5",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "collision",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("botsing"),
            keywords: &["boem", "botsing", "ontplof", "strokie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግጭት"),
            keywords: &["አስቂኝ", "ግጭት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تصادم"),
            keywords: &["تصادم", "رمز تصادم", "مشاعر", "هزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সংঘৰ\u{9cd}ষ"),
            keywords: &["কমিক", "গৰ\u{9cd}জন", "সংঘৰ\u{9cd}ষ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("toqquşma"),
            keywords: &["bum", "komik", "toqquşma"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("выбух"),
            keywords: &["бабах", "бум", "выбух", "камічны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сблъсък"),
            keywords: &["бум", "комикс", "сблъсък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সংঘর\u{9cd}ষ"),
            keywords: &[
                "কমিক",
                "ব\u{9c1}ম করে শব\u{9cd}দ হওয\u{9bc}\u{9be}",
                "সংঘর\u{9cd}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("tarzhadenn"),
            keywords: &["tarzhadenn", "tresadenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("eksplozija"),
            keywords: &["eksplozija", "stripovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("col·lisió"),
            keywords: &["col·lisió", "còmic", "esclat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᎾᏓᏛᏂᎸ"),
            keywords: &["ᎤᏬᏟᏗ", "ᏍᏓᏱ ᎤᏃᏴᎩ", "ᏚᎾᏓᏛᏂᎸ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srážka"),
            keywords: &["bum", "komiks", "náraz", "srážka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trawiad"),
            keywords: &["comig", "trawiad", "trwst"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kollision"),
            keywords: &["følelser", "kollision", "kollitionstegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zusammenstoß"),
            keywords: &["Comic", "Kollision", "Zusammenstoß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Zusammenstoss"),
            keywords: &["Comic", "Kollision", "Zusammenstoss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σύγκρουση"),
            keywords: &["κόμικ", "σύγκρουση"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("collision"),
            keywords: &["boom", "collision", "comic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("colisión"),
            keywords: &["colisión", "cómic"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["choque", "colisión", "cómic", "emoción", "explosión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["choque", "colisión", "cómics", "emoción", "explosión"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["choque", "colisión", "comic", "explosión"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("piraki"),
            keywords: &["koomiks", "piraki"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eztanda"),
            keywords: &["bum", "eztanda", "komiki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("برخورد"),
            keywords: &["برخورد", "بوم", "صدای انفجار", "مصور", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("törmäys"),
            keywords: &["pum", "sarjakuva", "törmäys"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("banggaan"),
            keywords: &["banggaan", "boom", "kislap", "komiks"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("samanstoytur"),
            keywords: &["bang", "samanbrestur", "samanstoytur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("explosion"),
            keywords: &["collision", "explosion"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bande dessinée", "collision", "explosion"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("pléasc"),
            keywords: &["plab", "pléasc", "torann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bualadh ri chèile"),
            keywords: &["bualadh ri chèile", "dealbh-èibhinn", "spreadhadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("explosión"),
            keywords: &["colisión", "cómic", "explosión"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ટક\u{acd}કર"),
            keywords: &[
                "ટક\u{acd}કર",
                "ટક\u{acd}કરન\u{ac1}\u{a82} પ\u{acd}રતીક",
                "રમ\u{ac2}જી",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("karo"),
            keywords: &["boom", "karo", "mai ban dariya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיצוץ"),
            keywords: &["פיצוץ", "פצצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("टक\u{94d}कर"),
            keywords: &[
                "कॉमिक",
                "टक\u{94d}कर",
                "टक\u{94d}कर का चिह\u{94d}न",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sudar"),
            keywords: &["bum", "eksplozija", "karikatura", "sudar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ütközés"),
            keywords: &["bumm", "képregény", "ütközés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բախում"),
            keywords: &["բախում", "բում", "կոմիքս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tabrakan"),
            keywords: &["komik", "nabrak", "tabrakan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nkụkọrịta"),
            keywords: &["buum", "mkpaọchị", "nkụkọrịta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("árekstur"),
            keywords: &["skrípó", "tilfinningar", "árekstrartákn", "árekstur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("collisione"),
            keywords: &["collisione", "emozione", "fumetto", "simbolo collisione"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("衝突"),
            keywords: &["どんっ", "衝撃", "衝突"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tabrakan"),
            keywords: &["komik", "mak brak", "tabrakan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჯახება"),
            keywords: &["სასაცილო", "შეჯახება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қақтығыс"),
            keywords: &["бум", "комик", "қақтығыс"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kollision"),
            keywords: &["følelser", "kollision", "kollitionstegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}កគ\u{17d2}នា"),
            keywords: &["ប\u{17bb}កគ\u{17d2}នា", "ផ\u{17d2}ទ\u{17bb}\u{17bb}ះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಘರ\u{ccd}ಷಣ\u{cc6}"),
            keywords: &[
                "ಘರ\u{ccd}ಷಣ\u{cc6}",
                "ಘರ\u{ccd}ಷಣ\u{cc6} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("충돌"),
            keywords: &["꽝", "충돌", "쾅"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("टक\u{94d}कर"),
            keywords: &["टक\u{94d}कर", "ब\u{942}म", "विनोदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сүзүшүү"),
            keywords: &["комикс", "сүзүш", "сүзүшүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kollisioun"),
            keywords: &["Boom", "Comic", "Kollisioun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ການຕຳ"),
            keywords: &["ການຕຳ", "ການປະທະກ\u{eb1}ນ", "ຕະລ\u{ebb}ກ", "ບ\u{eb8}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susidūrimas"),
            keywords: &["bum", "komiksas", "susidūrimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sadursme"),
            keywords: &["bums", "sadursme", "troksnis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tutukitanga"),
            keywords: &["pahū", "tutukitanga", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("судир"),
            keywords: &["бум", "експлозија", "стрип", "судир"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}ട\u{d4d}ടിയിടി"),
            keywords: &[
                "ക\u{d42}ട\u{d4d}ടിയിടി",
                "ക\u{d42}ട\u{d4d}ടിയിടി ചിഹ\u{d4d}നം",
                "കോമിക\u{d4d}ക\u{d4d}",
                "ബ\u{d42}ം",
                "വിക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мөргөлдөөн"),
            keywords: &["зурагт ном", "мөргөлдөөн", "тэсрэлт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टक\u{94d}कर"),
            keywords: &["कॉमिक", "टक\u{94d}कर", "ब\u{942}म"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pelanggaran"),
            keywords: &["komik", "ledakan", "pelanggaran"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħabta"),
            keywords: &["boom", "komiku", "ħabta"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တ\u{102d}\u{102f}က\u{103a}မ\u{102d}ခြင\u{103a}း"),
            keywords: &[
                "တ\u{102d}\u{102f}က\u{103a}မ\u{102d}ခြင\u{103a}း",
                "ပေါက\u{103a}က\u{103d}\u{1032}ခြင\u{103a}း",
                "ဟာသ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("krasj"),
            keywords: &["følelse", "kollisjon", "krasj", "smell", "tegneserie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("टक\u{94d}कर"),
            keywords: &["टक\u{94d}कर", "ब\u{941}म", "ह\u{901}साउन\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("botsing"),
            keywords: &["boem", "botsing", "strip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("krasj"),
            keywords: &["kjensle", "kollisjon", "krasj", "smell", "teikneserie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଧକ\u{b4d}କ\u{b3e}"),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "ଧକ\u{b4d}କ\u{b3e}",
                "ବ\u{b41}ମ\u{b4d}\u{200c} । ହ\u{b3e}ସ\u{b4d}ୟୋଦ\u{b4d}ଦୀପକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਟ\u{a71}ਕਰਾਉਣਾ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਟ\u{a71}ਕਰ",
                "ਟ\u{a71}ਕਰ ਦੀ ਨਿਸ\u{a3c}ਾਨ",
                "ਟ\u{a71}ਕਰਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹکرونا"),
            keywords: &["غص\u{651}ے آلا", "م\u{64f}ضح\u{650}کہ خیز", "ٹکرونا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jam"),
            keywords: &["Jam", "Ásídẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kolizja"),
            keywords: &["kolizja", "wybuch", "żartobliwy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("تکړ"),
            keywords: &["بوم", "تکړ", "مسخر", "ټکر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("colisão"),
            keywords: &["colisão", "emoção", "engraçado", "símbolo de colisão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bum", "colisão", "desenho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tupa"),
            keywords: &["bum", "comic", "tupa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("coliziune"),
            keywords: &[
                "bandă desenată",
                "ciocnire",
                "coliziune",
                "explozie",
                "impact",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-610"),
            keywords: &["E10-610"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("взрыв"),
            keywords: &["бум", "взрыв", "столкновение"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igongana"),
            keywords: &["buum", "igongana", "inkuru ishushanyije"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽڪراء\u{64f}"),
            keywords: &["بوم، ڪامڪ", "ٽڪراء\u{64f}"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඝට\u{dca}ටනය"),
            keywords: &[
                "ඝට\u{dca}ටනය",
                "ප\u{dd2}ප\u{dd2}ර\u{dd3}ම",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zrážka"),
            keywords: &["buch", "bum", "komiks", "zrážka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("trk"),
            keywords: &["bum", "eksplozija", "strip", "trk"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("isku dhac"),
            keywords: &[
                "calaamadda qaraxa",
                "isku dhac",
                "isku dhicis",
                "majaajilleeye",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("përplasje"),
            keywords: &["bum", "përplasje", "vizatim komik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("судар"),
            keywords: &["eксплoзиja", "бум", "стрип", "судар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["судар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sudar"),
            keywords: &["bum", "eksplozija", "strip", "sudar"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["sudar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("explosion"),
            keywords: &["explosion", "kollision", "serietidning", "smäll"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mgongano"),
            keywords: &["kibonzo", "mgongano", "mlio"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெடித\u{bcd}தல\u{bcd}"),
            keywords: &[
                "உணர\u{bcd}ச\u{bcd}சி",
                "உணர\u{bcd}வு",
                "நகைச\u{bcd}சுவை",
                "வெடித\u{bcd}தல\u{bcd}",
                "வெடித\u{bcd}தல\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఢ\u{c40}క\u{c4a}నడం"),
            keywords: &[
                "క\u{c3e}మ\u{c3f}క\u{c4d}",
                "ఢ\u{c40}క\u{c4a}నడం",
                "ప\u{c47}లడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бархӯрд"),
            keywords: &["бархӯрд", "бум", "мазҳакавӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("การปะทะ"),
            keywords: &["การปะทะ", "ชน", "โกรธมาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çakyşma"),
            keywords: &["gülkünç", "partlama", "çakyşma"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fepaki"),
            keywords: &["fepaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çarpışma"),
            keywords: &["duygu", "çarpışma", "çarpışma işareti", "çizgi roman"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سوقۇلۇش"),
            keywords: &["سوقۇلۇش", "كۈلكىلىك", "گۈلدۈر-قاراس"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зіткнення"),
            keywords: &["бум", "зіткнення", "комікси"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تصادم"),
            keywords: &["تصادم", "ٹکر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("to‘qnashuv"),
            keywords: &["latifa", "portlash", "to‘qnashuv"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("va chạm"),
            keywords: &["bùng nổ", "hài hước", "va chạm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mbëkkante"),
            keywords: &["boom", "mbëkkante", "reelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukungqubana"),
            keywords: &["hlekisa", "ukungqubana", "uqhushumbo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ikọlu"),
            keywords: &["Ikọlu", "bóòmù", "àwàdà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("碰撞"),
            keywords: &["搞笑", "碰撞", "轟"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("碰撞"),
            keywords: &["搞笑", "碰撞", "轰"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("爆炸"),
            keywords: &["炸", "爆", "爆炸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("碰撞"),
            keywords: &["引爆", "碰撞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukushayisana"),
            keywords: &["gquzu", "opopayi", "ukushayisana"],
        },
    ],
};
#[doc = "💫"]
pub const DIZZY: crate::Emoji = crate::Emoji {
    glyph: "💫",
    codepoint: "1F4AB",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dizzy",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("duiselig"),
            keywords: &["duiselig", "ster", "strokie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ድብት"),
            keywords: &["አስቂኝ", "ኮከብ", "ድብት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دوار"),
            keywords: &["تخيل حركة النجوم", "دوار", "مشاعر", "نجوم", "هزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হতব\u{9c1}দ\u{9cd}ধি"),
            keywords: &["কমিক", "তৰ\u{9be}", "হতব\u{9c1}দ\u{9cd}ধি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("başgicəllənməsi"),
            keywords: &["başgicəllənməsi", "komik", "ulduz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("галавакружэнне"),
            keywords: &["галавакружэнне", "зоркі", "камічны", "прытомнасць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("замайване"),
            keywords: &["замайване", "звезда", "комикс"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হতব\u{9c1}দ\u{9cd}ধি"),
            keywords: &["কমিক", "ত\u{9be}র\u{9be}", "হতব\u{9c1}দ\u{9cd}ধি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ošamućen"),
            keywords: &["ošamutiti", "ošamućen", "stripovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mareig"),
            keywords: &["còmic", "estrella", "mareig"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎸᏕᎯᏓ"),
            keywords: &["ᎤᎸᏕᎯᏓ", "ᎤᏬᏟᏗ", "ᏃᏈᏏ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("závrať"),
            keywords: &["hvězda", "hvězdičky", "komiks", "závrať"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("penysgafn"),
            keywords: &["comig", "penysgafn", "seren"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("svimmel"),
            keywords: &["følelser", "se stjerner", "svimmel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schwindlig"),
            keywords: &[
                "Benommenheit",
                "Comic",
                "Stern",
                "Sterne sehen",
                "schwindlig",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αστεράκια"),
            keywords: &["αστέρι", "αστεράκια", "ζαλάδα", "κόμικ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dizzy"),
            keywords: &["comic", "dizzy", "star"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["comic", "dizzy", "spinning", "spinning stars", "star"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de mareo"),
            keywords: &["cómic", "emoción", "estrella", "mareo", "símbolo de mareo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mareado"),
            keywords: &["cómic", "emoción", "estrellas", "mareado", "mareo", "ver"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("símbolo de mareo"),
            keywords: &[
                "cómics",
                "emoción",
                "estrellas",
                "mareo",
                "símbolo de mareo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("símbolo de mareo"),
            keywords: &["comic", "estrella", "mareado", "símbolo de mareo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("peadpööritav"),
            keywords: &["koomiks", "peadpööritav", "täht"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zorabiatuta"),
            keywords: &["izar", "komiki", "zorabiatuta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سرگیجه"),
            keywords: &["ستاره", "سرگیجه", "مصور", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pyörryttävä"),
            keywords: &["pyörryttävä", "sarjakuva", "tähti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nahihilo"),
            keywords: &["bituin", "hilo", "komiks", "nahihilo", "ulo", "umpog"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svimbul"),
            keywords: &["stjørna", "stjørnuskot", "svimbul", "tekin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étourdissement"),
            keywords: &["tournis", "étourdissement"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bande dessinée", "tournis", "étourdissement"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meadhrán"),
            keywords: &["meadhrán", "mearbhall", "réaltaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tuaineal"),
            keywords: &["dealbh-èibhinn", "rionnag", "tuaineal"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de atordamento"),
            keywords: &[
                "atordamento",
                "cómic",
                "estrelas",
                "mareo",
                "símbolo de atordamento",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચક\u{acd}કર"),
            keywords: &["ચક\u{acd}કર", "તારા", "તારા જોવા", "રમ\u{ac2}જી", "લાગણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jiri"),
            keywords: &["jiri", "mai ban dariya", "tauraro"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כוכב נע במעגל"),
            keywords: &["כוכב", "כוכב נע במעגל", "סחרחורת", "קומיקס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("तार\u{947} दिखना"),
            keywords: &[
                "कॉमिक",
                "चक\u{94d}कर",
                "तार\u{947}",
                "तार\u{947} दिखना",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vrtoglavica"),
            keywords: &["karikatura", "vrtoglavica", "zvjezdice"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szédülés"),
            keywords: &["csillagokat lát", "képregény", "szédülés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գլխապտույտ"),
            keywords: &["աստղ", "գլխապտույտ", "կոմիքս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pusing"),
            keywords: &["bintang", "komik", "pusing"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ajụ"),
            keywords: &["ajụ", "kpakpandò", "mkpaọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ringlaður"),
            keywords: &[
                "ringlaður",
                "sjá stjörnur",
                "skrípó",
                "stjörnur",
                "tilfinningar",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stella con scia"),
            keywords: &[
                "emozione",
                "fumetto",
                "stella con scia",
                "stelle",
                "vedere le stelle",
                "vorticoso",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("くらくら"),
            keywords: &["くらくら", "星", "目が回る"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ngelu"),
            keywords: &["komik", "lintang", "ngelu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაბრუებული"),
            keywords: &["გაბრუებული", "ვარსკვლავი", "სასაცილო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басы айналған"),
            keywords: &["басы айналған", "жұлдыз", "комик"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("svimmel"),
            keywords: &["følelser", "se stjerner", "svimmel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b7}លវល\u{17cb}"),
            keywords: &["វ\u{17b7}ល", "វ\u{17b7}លវល\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cbf}ರುುಗುವ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ಚಂಚಲ",
                "ತ\u{cbf}ರುುಗುವ\u{cbf}ಕ\u{cc6}",
                "ನಕ\u{ccd}ಷತ\u{ccd}ರಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("어지러움"),
            keywords: &["띠용", "별", "어지러움", "어질어질"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घ\u{941}\u{902}वळ"),
            keywords: &["घ\u{941}\u{902}वळ", "नख\u{947}त\u{94d}र", "विनोदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("башы айланган"),
            keywords: &["башы айланган", "жылдыз", "комикс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schwindel"),
            keywords: &["Comic", "Schwindel", "Stär"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ວຽນຫ\u{ebb}ວ"),
            keywords: &["ວຽນຫ\u{ebb}ວ", "ເຫ\u{eb1}ນດາວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apsvaigęs"),
            keywords: &["apsvaigęs", "komiksas", "žvaigždė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("apdullis"),
            keywords: &["apdullis", "zvaigzne"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whakaamai"),
            keywords: &["whakaamai", "whakakata", "whetū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вртоглавица"),
            keywords: &["вртење", "вртоглавица", "стрип", "ѕвезда"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോഹ\u{d3e}ലസ\u{d4d}യം"),
            keywords: &[
                "കോമിക\u{d4d}ക\u{d4d}",
                "നക\u{d4d}ഷത\u{d4d}രം",
                "ഭ\u{d4d}രമ ചിഹ\u{d4d}നം",
                "മോഹ\u{d3e}ലസ\u{d4d}യം",
                "വ\u{d3e}ൽനക\u{d4d}ഷത\u{d4d}രം",
                "വിക\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("төөрөгдүүлсэн"),
            keywords: &["од", "төөрөгдүүлсэн", "төөрөгдүүлэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भोवळ"),
            keywords: &["कॉमिक", "तार\u{947}", "भोवळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pening"),
            keywords: &["bintang", "komik", "pening"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stordut"),
            keywords: &["kewkba", "komiku", "stordut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{1030}းဝေခြင\u{103a}း"),
            keywords: &["ကြယ\u{103a}", "မ\u{1030}းဝေခြင\u{103a}း", "ဟာသ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svimmel"),
            keywords: &["se stjerner", "stjerner", "svimmel", "tegneserie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चक\u{94d}कर"),
            keywords: &["चक\u{94d}कर", "तारा", "ह\u{901}साउन\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("duizelig"),
            keywords: &["duizelig", "ster", "strip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("svimmel"),
            keywords: &["sjå stjerner", "stjerner", "svimmel", "teikneserie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଚଳ\u{b3f}ତ"),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "ଚପଳ",
                "ତ\u{b3e}ର\u{b3e}",
                "ତ\u{b3e}ର\u{b3e} ଦେଖ\u{b3f}ବ\u{b3e}",
                "ବ\u{b3f}ଚଳ\u{b3f}ତ",
                "ଭ\u{b3e}ବନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਾਰ\u{a47} ਵਿਖਾਈ ਦ\u{a47}ਣਾ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਚ\u{a71}ਕਰ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਤਾਰ\u{a47}",
                "ਤਾਰ\u{a47} ਦ\u{a47}ਖਣਾ",
                "ਤਾਰ\u{a47} ਵਿਖਾਈ ਦ\u{a47}ਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بدحواس"),
            keywords: &["بدحواس", "تارہ", "م\u{64f}ضح\u{650}کہ خیز"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ai De Tọn Tọ\u{301}n Yu An Yu Wán Fọl"),
            keywords: &[
                "Ai De Tọn Tọ\u{301}n Yu An Yu Wán Fọl",
                "Dízi",
                "Fent",
                "Sta",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "Yu Fíl Laik Ẹ\u{301}vrítin De Tọ\u{301}n Raúnd An Raund And Yu Wán Fọl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zawroty głowy"),
            keywords: &["spadająca gwiazda", "zawroty głowy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سربدال"),
            keywords: &["ستورۍ", "سربدال", "مسخره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("zonzo"),
            keywords: &[
                "emoção",
                "engraçado",
                "estrelas",
                "olhando para as estrelas",
                "zonzo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tonto"),
            keywords: &["desenho", "estrela", "tonto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("muyu muyu"),
            keywords: &["comic", "muyu muyu", "quyllur"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("amețit"),
            keywords: &["amețeală", "amețit", "bandă desenată", "steluțe"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-616"),
            keywords: &["E10-616"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кружащаяся звезда"),
            keywords: &["головокружение", "звезда", "звезды", "кружащаяся звезда"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ufite isereri"),
            keywords: &["inyenyeri", "ishimishije", "ufite isereri"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("چڪرائيندڙ"),
            keywords: &["ستارو", "مزاحيه", "چڪرائيندڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වල\u{dca}ග ත\u{dcf}රක\u{dcf}ව"),
            keywords: &[
                "තර\u{dd4}ව",
                "වල\u{dca}ග ත\u{dcf}රක\u{dcf}ව",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mám závrat"),
            keywords: &["hviezdičky", "komiks", "mám závrat", "závrat"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("omotica"),
            keywords: &["omotica", "omotično", "planeti", "strip", "zvezda"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wareer"),
            keywords: &["majaajileeye", "wareer", "xiddig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("i trullosur"),
            keywords: &["i trullosur", "vizatim komik", "yll"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вртоглавица"),
            keywords: &["вртоглавица", "звездицe", "стрип"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вртоглавица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vrtoglavica"),
            keywords: &["strip", "vrtoglavica", "zvezdice"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vrtoglavica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("omtumlad"),
            keywords: &["omtumlad", "serietidning", "stjärna", "yr"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kizunguzungu"),
            keywords: &["kibonzo", "kizunguzungu", "nyota"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுற\u{bcd}றல\u{bcd}"),
            keywords: &[
                "சுற\u{bcd}றல\u{bcd}",
                "தலைச\u{bcd}சுற\u{bcd}றல\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரங\u{bcd}கள\u{bcd}",
                "நட\u{bcd}சத\u{bcd}திரம\u{bcd}",
                "மயக\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కళ\u{c4d}లు త\u{c3f}రగడం"),
            keywords: &[
                "కళ\u{c4d}లు త\u{c3f}రగడం",
                "చూడటం",
                "నక\u{c4d}షత\u{c4d}రం",
                "నక\u{c4d}షత\u{c4d}ర\u{c3e}లను చూడటం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сархчархзанӣ"),
            keywords: &["мазҳакавӣ", "сархчархзанӣ", "ситора"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e36}นห\u{e31}ว"),
            keywords: &["ม\u{e36}นห\u{e31}ว", "เห\u{e47}นดาว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("başy aýlanan"),
            keywords: &["başy aýlanan", "gülkünç", "ýyldyz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ninimo"),
            keywords: &["ninimo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("baş dönmesi"),
            keywords: &[
                "baş dönmesi",
                "duygu",
                "yıldızlar",
                "yıldızları görme",
                "çizgi roman",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قېيىش"),
            keywords: &["قېيىش", "كۈلكىلىك", "يۇلتۇز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("символ запаморочення"),
            keywords: &["зірка", "комікси", "символ запаморочення"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سر چکرانا"),
            keywords: &["سر چکرانا", "علامت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bosh aylanish"),
            keywords: &["bosh aylanish", "latifa", "yulduz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("choáng váng"),
            keywords: &["choáng váng", "hài hước", "ngôi sao"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("miir"),
            keywords: &["biddeew", "miir", "reelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isiyezi"),
            keywords: &["hlekisa", "inkwenkwezi", "isiyezi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Itoogbe"),
            keywords: &["Itoogbe", "àwàdà", "ìràwọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("頭暈"),
            keywords: &["搞笑", "星", "頭暈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("头晕"),
            keywords: &["头晕", "搞笑", "星"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("头晕"),
            keywords: &["头晕", "头晕目眩"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("暈頭轉向"),
            keywords: &["暈頭轉向", "頭暈目眩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("頭暈星星"),
            keywords: &["頭暈", "頭暈星星"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inzululwane"),
            keywords: &["inkanyezi", "inzululwane", "opopayi"],
        },
    ],
};
#[doc = "💦"]
pub const SWEAT_DROPLETS: crate::Emoji = crate::Emoji {
    glyph: "💦",
    codepoint: "1F4A6",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "sweat droplets",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("sweetdruppels"),
            keywords: &["spat", "strokie", "sweet", "sweetdruppels"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጣፋጭ ጠብታዎች"),
            keywords: &["ላብ", "አስቂኝ", "የውሃ መረጨት", "ጣፋጭ ጠብታዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عرق يتصبب"),
            keywords: &["عرق", "عرق يتصبب", "مبلل عرق\u{64b}ا", "مشاعر", "هزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঘ\u{9be}মৰ টোপ\u{9be}ল"),
            keywords: &[
                "কমিক",
                "ঘ\u{9be}ম ছিটিকি পৰ\u{9be}",
                "ঘ\u{9be}মৰ টোপ\u{9be}ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tər damcıları"),
            keywords: &["komik", "sıçramaq", "tər", "tər damcıları"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пырскі поту"),
            keywords: &["камічны", "пот", "пырскі", "пырскі поту"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("капки пот"),
            keywords: &["капки пот", "комикс", "пот", "пръска"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9be}মের ফো\u{981}ট\u{9be}"),
            keywords: &[
                "কমিক",
                "ঘর\u{9cd}ম\u{9be}ক\u{9cd}ত অবস\u{9cd}থ\u{9be}",
                "ঘ\u{9be}মের ফো\u{981}ট\u{9be}",
                "জলের ফোট\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kapljice znoja"),
            keywords: &["kapljice znoja", "prskanje", "stripovi", "znoj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gotes de suor"),
            keywords: &["gotes", "gotes de suor", "suor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵ ᏧᏩᏬᏨ"),
            keywords: &["ᎠᎵ", "ᎠᎵ ᏧᏩᏬᏨ", "ᎤᏬᏟᏗ", "ᏗᏍᏚᏟᏥᏙᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kapky potu"),
            keywords: &["cákání", "kapky", "kapky potu", "komiks", "pot"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("defnynnau chwys"),
            keywords: &["chwys", "comig", "defnynnau chwys", "splash"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sveddråber"),
            keywords: &["følelser", "sved", "sveddråber"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schweißtropfen"),
            keywords: &["Comic", "Schweiß", "Schweißtropfen"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Schweisstropfen"),
            keywords: &["Comic", "Schweiss", "Schweisstropfen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σταγόνες ιδρώτα"),
            keywords: &["ιδρώτας", "κόμικ", "πιτσιλιές", "σταγόνες ιδρώτα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sweat droplets"),
            keywords: &["comic", "splashing", "sweat", "sweat droplets"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gotas de sudor"),
            keywords: &["cómic", "emoción", "gotas de sudor", "sudor"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cómics", "emoción", "gotas de sudor", "sudar"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["comic", "gotas de sudor", "salpicar", "sudor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("higipiisad"),
            keywords: &["higi", "higipiisad", "koomiks", "piisad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("izerdi-tantatxoak"),
            keywords: &["izerdi", "izerdi-tantatxoak", "komiki", "zipriztin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قطره\u{200c}های عرق"),
            keywords: &["تراوش", "عرق", "قطره\u{200c}های عرق", "مصور", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hikipisarat"),
            keywords: &["hiki", "hikipisarat", "sarjakuva", "vesi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga patak ng pawis"),
            keywords: &[
                "komiks",
                "laway",
                "mga patak ng pawis",
                "pawis",
                "tumatalsik",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dropar"),
            keywords: &["dropar", "sveitti", "vatn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("gouttes de sueur"),
            keywords: &["gouttes de sueur", "sueur", "éclaboussures"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bande dessinée",
                "goutte",
                "gouttes de sueur",
                "sueur",
                "éclaboussure",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("broainíní allais"),
            keywords: &["braonta", "broainíní allais", "stealladh", "uisce"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boinneagan fallais"),
            keywords: &[
                "boinneag",
                "boinneagan fallais",
                "dealbh-èibhinn",
                "fallas",
                "splaiseadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pingas de suor"),
            keywords: &["cómic", "pingas de suor", "salpicadura", "salpicar", "suor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પરસ\u{ac7}વાના\u{a82} ટીપા"),
            keywords: &[
                "પરસ\u{ac7}વાના\u{a82} છા\u{a82}ટા",
                "પરસ\u{ac7}વાના\u{a82} ટીપા",
                "પરસ\u{ac7}વો",
                "પ\u{acd}રસ\u{acd}વ\u{ac7}દય\u{ac1}ક\u{acd}ત",
                "રમ\u{ac2}જી",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗige-ɗigen gumi"),
            keywords: &["fantsama", "gumi", "mai ban dariya", "ɗige-ɗigen gumi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טיפות זיעה"),
            keywords: &["זיעה", "טיפות", "מים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पसीन\u{947} की ब\u{942}\u{902}द\u{947}\u{902}"),
            keywords: &[
                "कॉमिक",
                "पसीना",
                "पसीन\u{947} की ब\u{942}\u{902}द\u{947}\u{902}",
                "पसीन\u{947}दार",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kapljice znoja"),
            keywords: &[
                "kapljice",
                "kapljice znoja",
                "karikatura",
                "prskanje",
                "znoj",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("izzadságcseppek"),
            keywords: &["izzadság", "izzadságcseppek", "képregény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քրտինքի կաթիլներ"),
            keywords: &["կաթիլներ", "կոմիքս", "ցայտող", "քրտինք", "քրտինքի կաթիլներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("keringat"),
            keywords: &["ciprat", "keringat", "komik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ntụpụta okpoofù"),
            keywords: &["boom", "na-egosipụta", "ntụpụta okpoofù", "okpoofù"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("svitadropar"),
            keywords: &["skrípó", "svitadropar", "sviti", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gocce di sudore"),
            keywords: &[
                "bagno di sudore",
                "emozione",
                "fumetto",
                "gocce di sudore",
                "sudato",
                "sudore",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あせあせ"),
            keywords: &["あせあせ", "汗"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tesing kringet"),
            keywords: &["komik", "kringet", "nyiprat", "tesing kringet"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოფლის წვეთები"),
            keywords: &["ოფლი", "ოფლიანი", "ოფლის წვეთები", "სასაცილო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тер тамшылары"),
            keywords: &["бүрку", "комик", "тер", "тер тамшылары"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("sveddråber"),
            keywords: &["følelser", "sveddråber"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17c6}ណក\u{17cb}ទ\u{17b9}កប\u{17b8}"),
            keywords: &[
                "ត\u{17c6}ណក\u{17cb}ទ\u{17b9}ក",
                "ត\u{17c6}ណក\u{17cb}ទ\u{17b9}កប\u{17b8}",
                "ភ\u{17d2}លៀង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬ\u{cc6}ವರ\u{cbf}ನ ಹನ\u{cbf}ಗಳು"),
            keywords: &[
                "ತೊಟ\u{ccd}ಟ\u{cbf}ಕ\u{ccd}ಕುವ ಬ\u{cc6}ವರು",
                "ಬ\u{cc6}ವರ\u{cbf}ನ ಹನ\u{cbf}ಗಳು",
                "ಬ\u{cc6}ವರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("땀"),
            keywords: &["곤란", "당황", "땀", "삐질삐질"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("घामाच\u{947} थ\u{947}\u{902}ब\u{947}"),
            keywords: &[
                "घाम",
                "घामाच\u{947} थ\u{947}\u{902}ब\u{947}",
                "विनो\u{947}दी",
                "शिताडो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тер тамчылары"),
            keywords: &["комикс", "тер", "тер тамчылары", "чачыраган"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Schweessdrëpsen"),
            keywords: &["Comic", "Schweess", "Schweessdrëpsen", "platschen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຢອດເຫ\u{eb7}\u{ec8}ອ"),
            keywords: &["ຢອດເຫ\u{eb7}\u{ec8}ອ", "ເຫ\u{eb7}\u{ec8}ອ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("prakaito lašeliai"),
            keywords: &["komiksas", "prakaitas", "prakaito lašeliai", "taškymas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sviedru lāses"),
            keywords: &["lāses", "sviedri", "sviedru lāses"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā kōpata werawera"),
            keywords: &["ngā kōpata werawera", "paratī", "werawera", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("капки пот"),
            keywords: &["капки", "пот", "прскање", "стрип"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിയർപ\u{d4d}പ\u{d4d} ത\u{d41}ള\u{d4d}ളികൾ"),
            keywords: &[
                "കോമിക\u{d4d}ക\u{d4d}",
                "വിക\u{d3e}രം",
                "വിയർപ\u{d4d}പ\u{d4d}",
                "വിയർപ\u{d4d}പ\u{d4d} ത\u{d41}ള\u{d4d}ളികൾ",
                "വിയർപ\u{d4d}പ\u{d4d} തെറിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөлсний дусал"),
            keywords: &["дусал", "хөлс", "хөлсний дусал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घामाच\u{947} थ\u{947}\u{902}ब"),
            keywords: &[
                "कॉमिक",
                "घाम",
                "घाम आणणारा",
                "घामाच\u{947} थ\u{947}\u{902}ब",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("titis peluh"),
            keywords: &["komik", "peluh", "percikan", "titis peluh"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("qtar tal-għaraq"),
            keywords: &["għaraq", "komiku", "qed itajjar", "qtar tal-għaraq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ချ\u{103d}ေးစက\u{103a}များ"),
            keywords: &[
                "ချ\u{103d}ေး",
                "ချ\u{103d}ေးစက\u{103a}များ",
                "ပက\u{103a}ဖျန\u{103a}းခြင\u{103a}း",
                "ဟာသ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("svettedråper"),
            keywords: &[
                "dråper",
                "sprut",
                "sprutende",
                "svette",
                "svettedråper",
                "tegneserie",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पसिनाको थोपा"),
            keywords: &[
                "पसिना",
                "पसिनाको थोपा",
                "स\u{94d}प\u{94d}ल\u{94d}यासिङ\u{94d}",
                "ह\u{901}साउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zweetdruppels"),
            keywords: &["druppels", "strip", "zweet", "zweetdruppels"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sveittedropar"),
            keywords: &[
                "dropar",
                "sprut",
                "sprutande",
                "sveitte",
                "sveittedropar",
                "teikneserie",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଝ\u{b3e}ଳ ବ\u{b41}ନ\u{b4d}ଦ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "ଝ\u{b3e}ଳ",
                "ଝ\u{b3e}ଳ ଟୋପ\u{b3e}",
                "ଝ\u{b3e}ଳ ବ\u{b41}ନ\u{b4d}ଦ\u{b3e}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଝ\u{b3e}ଳ ବୋହ\u{b3f}ବ\u{b3e}",
                "ଭ\u{b3e}ବନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਦੀਆ\u{a02} ਬ\u{a42}\u{a70}ਦਾ\u{a02}"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਪਸੀਨਾ",
                "ਮ\u{a41}ੜ\u{a4d}ਹਕਾ",
                "ਮ\u{a41}ੜ\u{a4d}ਹਕਾ ਛਿੜਕਣਾ",
                "ਮ\u{a41}ੜ\u{a4d}ਹਕ\u{a47} ਦੀਆ\u{a02} ਬ\u{a42}\u{a70}ਦਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پسینے دا نیکا جیہا قطرہ"),
            keywords: &[
                "م\u{64f}ضح\u{650}کہ خیز",
                "م\u{64f}ڑکا",
                "پسینے دا نیکا جیہا قطرہ",
                "چ\u{650}ھیٹے ا\u{64f}ڑونا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sọm Drọ\u{301}p Ọf Swẹt"),
            keywords: &[
                "Fọ Líkwid To Fọ\u{301}l Ọn Tọ\u{301}p Sọ\u{301}mtin",
                "Jok",
                "Ple Plé",
                "Swẹt",
                "Sọm Drọ\u{301}p Ọf Swẹt",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("krople potu"),
            keywords: &["krople", "krople potu", "pot", "woda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خولو څاڅکی"),
            keywords: &["خوله", "خولو څاڅکی", "لري کول", "مسخره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pingos de suor"),
            keywords: &["com suor", "emoção", "engraçado", "pingos de suor", "suor"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gotas de suor"),
            keywords: &["desenho", "gota", "gotas de suor", "suor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("jumpʼi sutukuna"),
            keywords: &[
                "chʼiqichisqa",
                "comic",
                "jumpʼi sutukuna",
                "sumpʼi sutukuna",
                "sutʼu",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("picături de transpirație"),
            keywords: &[
                "bandă desenată",
                "efort",
                "picături",
                "picături de transpirație",
                "sudoare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-611"),
            keywords: &["E10-611"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("капли пота"),
            keywords: &[
                "брызги",
                "брызги воды",
                "вода",
                "капли",
                "капли пота",
                "пот",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("udutonyanga tw’ibyuya"),
            keywords: &[
                "icyuya",
                "inkuru ishushanyije",
                "kudumbura",
                "udutonyanga tw’ibyuya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پگهر جا قطرا"),
            keywords: &["مزاڪ", "پگهر جا قطرا", "پگھر", "ڇنڊا اڏائيندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දහඩ\u{dd2}ය බ\u{dd2}ඳ\u{dd4}"),
            keywords: &[
                "දහඩ\u{dd2}ය",
                "දහඩ\u{dd2}ය බ\u{dd2}ඳ\u{dd4}",
                "වැග\u{dd2}ර\u{dd3}ම",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kvapky potu"),
            keywords: &["komiks", "kvapky", "kvapky potu", "pot"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("potne kapljice"),
            keywords: &["pljuskanje", "pot", "potne kapljice", "strip"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhibco dhidid ah"),
            keywords: &[
                "dhibco dhidid",
                "dhibco dhidid ah",
                "dhidid",
                "majaajileeye",
                "sayrin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pika djerse"),
            keywords: &["djersë", "pika djerse", "spërkatje", "vizatim komik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("капљице зноја"),
            keywords: &["знoj", "кaпљицe", "капљице зноја", "прскaњe", "стрип"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["капљице зноја"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kapljice znoja"),
            keywords: &["kapljice", "kapljice znoja", "prskanje", "strip", "znoj"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kapljice znoja"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("stänkande svett"),
            keywords: &["serietidning", "stänkande svett", "svett", "svettig"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("matone ya jasho"),
            keywords: &["jasho", "kibonzo", "matone", "matone ya jasho"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வியர\u{bcd}வைத\u{bcd} துளிகள\u{bcd}"),
            keywords: &[
                "உழைப\u{bcd}பு",
                "கடினம\u{bcd}",
                "வியர\u{bcd}த\u{bcd}துக\u{bcd} கொட\u{bcd}டுதல\u{bcd}",
                "வியர\u{bcd}வை",
                "வியர\u{bcd}வைத\u{bcd} துளிகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}వ\u{c47}దం"),
            keywords: &[
                "స\u{c4d}వ\u{c47}దం",
                "స\u{c4d}వ\u{c47}దం క\u{c3e}రుతున\u{c4d}న చ\u{c3f}హ\u{c4d}నం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("қатраҳои арақ"),
            keywords: &["арақ", "мазҳакавӣ", "пош хӯрдаистода", "қатраҳои арақ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เหง\u{e37}\u{e48}อหยด"),
            keywords: &["เหง\u{e37}\u{e48}อ", "เหง\u{e37}\u{e48}อหยด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("der damjalary"),
            keywords: &["der", "der damjalary", "gülkünç", "syçraýan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tautaʻa tulutā"),
            keywords: &["tautaʻa tulutā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ter damlası"),
            keywords: &["duygu", "ter", "ter damlası", "terli", "çizgi roman"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تەر تامچىسى"),
            keywords: &["تەر", "تەر تامچىسى", "كۈلكىلىك", "چاچراش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("краплі поту"),
            keywords: &["бризки", "комікси", "краплі поту", "піт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پسینے کے قطرے"),
            keywords: &["قطرے", "پسینہ", "پسینے کے قطرے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘z yoshi tomchilari"),
            keywords: &["ko‘z yoshi", "ko‘z yoshi tomchilari", "latifa", "sachrash"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giọt mồ hôi"),
            keywords: &["bắn tung tóe", "giọt mồ hôi", "hài hước", "mồ hôi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("toqu ñaq"),
            keywords: &["reelu", "tasaaroo", "toqu ñaq", "ñàq"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amathontsi ombilo"),
            keywords: &["amathontsi ombilo", "hlekisa", "ukutshiza", "umbilo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ilaagun Ti N kan"),
            keywords: &["Ilaagun Ti N kan", "tami", "àwàdà", "òógùn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("滴汗"),
            keywords: &["搞笑", "汗", "滴汗", "濺"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("滴汗"),
            keywords: &["搞笑", "汗", "溅", "滴汗"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("汗滴"),
            keywords: &["汗", "汗滴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("出汗"),
            keywords: &["出汗", "汗"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amaqabazi omjuluko"),
            keywords: &["amaqabazi omjuluko", "opopayi", "ukujuluka"],
        },
    ],
};
#[doc = "💨"]
pub const DASHING_AWAY: crate::Emoji = crate::Emoji {
    glyph: "💨",
    codepoint: "1F4A8",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "dashing away",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blitsig"),
            keywords: &["blits", "blitsig", "hardloop", "strokie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እየቦነነ ያለ"),
            keywords: &["ሩጫ", "ሰርዝ", "አስቂኝ", "እየቦነነ ያለ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("انطلاقة جري"),
            keywords: &["انطلاقة جري", "جري", "مشاعر", "هرب", "هزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উদ\u{9cd}যমী"),
            keywords: &["উদ\u{9cd}যমী", "কমিক", "ঠেল\u{9be}-ঠেলি", "দৌৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sürətli hərəkət"),
            keywords: &["komik", "qaçış", "sürətli hərəkət", "tez getmək"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("знікненне"),
            keywords: &["бег", "знікненне", "камічны", "рывок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("спринт"),
            keywords: &["комикс", "спринт", "тичане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উদ\u{9cd}যমী"),
            keywords: &[
                "উদ\u{9cd}যমী",
                "কমিক",
                "দৌড\u{9bc}রত",
                "হ\u{9be}ন\u{9be}হ\u{9be}নি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bježanje"),
            keywords: &["bježanje", "pobjeći", "stripovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sortir corrent"),
            keywords: &["còmic", "córrer", "pressa", "sortir corrent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎾᏫᏍᏗᏍᎬᎢ"),
            keywords: &["ᎠᏓᎾᏫᏍᏗᏍᎬᎢ", "ᎠᏓᏫᏍᏗᏍᎬᎢ", "ᎠᏗᏟ", "ᎤᏬᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("spěch"),
            keywords: &["běh", "komiks", "spěch"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("rhuthro"),
            keywords: &["comig", "rhedeg", "rhuthro"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("smutter"),
            keywords: &["er løbet", "følelser", "løber væk", "smutter"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Staubwolke"),
            keywords: &["Comic", "Staubwolke", "rennen", "weglaufen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρέξιμο"),
            keywords: &["κόμικ", "ορμή", "τρέξιμο"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("dashing away"),
            keywords: &["comic", "dash", "dashing away", "running"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("salir corriendo"),
            keywords: &["carrera", "correr", "cómic", "humo", "salir corriendo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("salir corriendo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "correr",
                "corriendo",
                "emoción",
                "escapar",
                "huir",
                "salir corriendo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["comic", "correr", "corriendo", "escapar", "salir corriendo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kiirustamine"),
            keywords: &["jooksmine", "kiirustamine", "koomiks"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ziztu bizian"),
            keywords: &["bizi", "komiki", "korrika", "lasterka", "ziztu bizian"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("به سرعت باد"),
            keywords: &["به سرعت باد", "دوان", "سریع", "مصور", "کمیک", "گرد پا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pikalähtö"),
            keywords: &["juoksu", "pikalähtö", "sarjakuva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagmamadali"),
            keywords: &["bilis", "humaharurot", "komiks", "nagmamadali", "tumatakbo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fok"),
            keywords: &["fok", "renna", "vindur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("décamper"),
            keywords: &["décamper", "filer"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bande dessinée",
                "décamper",
                "filer",
                "fuir",
                "se sauver",
                "s’enfuir",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("rith"),
            keywords: &["rith", "sciuird", "tapa"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ falbh nad dheann"),
            keywords: &[
                "a’ falbh nad dheann",
                "dealbh-èibhinn",
                "deann",
                "luath",
                "ruith",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de saír correndo"),
            keywords: &[
                "cómic",
                "escapar",
                "saír correndo",
                "símbolo de saír correndo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડ\u{ac7}શિ\u{a82}ગ"),
            keywords: &[
                "ચાલ\u{ac1} ડ\u{ac7}શ",
                "ડ\u{ac7}શિ\u{a82}ગ",
                "દોડો",
                "ભાગવ\u{ac1}\u{a82}",
                "રમ\u{ac2}જી",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gudu mai sauri"),
            keywords: &["gudu", "gudu mai sauri", "mai ban dariya", "yin gudu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ענן בתנועה מהירה"),
            keywords: &["מהר", "ענן", "ענן בתנועה מהירה", "ריצה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दौड\u{93c}ना"),
            keywords: &[
                "कॉमिक",
                "त\u{947}ज\u{93c} दौड\u{93c}",
                "दौड\u{93c}",
                "दौड\u{93c}ना",
                "भागना",
                "भावना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bježanje"),
            keywords: &["bježanje", "karikatura", "trčanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rohanás"),
            keywords: &["futás", "képregény", "rohanás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սրընթաց"),
            keywords: &["ընթանալ", "կոմիքս", "սլանալ", "սրընթաց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("berlari"),
            keywords: &["berlari", "kabur", "komik", "lari"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-apụ apụ"),
            keywords: &["mkpaọchị", "na-apụ apụ", "na-emebe", "ọpụpụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hraðferð"),
            keywords: &["flýja", "hlaupa", "hraðferð", "skrípó", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nuvola di polvere"),
            keywords: &[
                "emozione",
                "fuga",
                "fumetto",
                "nuvola di polvere",
                "scappare",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダッシュ"),
            keywords: &["ダッシュ", "急ぐ", "急げ", "走る"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("nggeblas"),
            keywords: &["geblas", "komik", "mlayu", "nggeblas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოწყვეტა"),
            keywords: &["მოწყვეტა", "სასაცილო", "სირბილი", "ტირე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шапшаң"),
            keywords: &["жүгіру", "комик", "серпіліс", "шапшаң"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("smutter"),
            keywords: &["er løbet", "følelser", "løber væk", "smutter"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "សន\u{17d2}ទ\u{17bb}ះខ\u{17d2}យល\u{17cb}ព\u{17b8}ការរត\u{17cb}យ\u{17c9}ាងលឿន",
            ),
            keywords: &[
                "រត\u{17cb}\u{17cb}",
                "សន\u{17d2}ទ\u{17bb}ះខ\u{17d2}យល\u{17cb}ព\u{17b8}ការរត\u{17cb}យ\u{17c9}ាងលឿន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗುದ\u{ccd}ದುವ\u{cbf}ಕ\u{cc6}"),
            keywords: &[
                "ಕಾಮ\u{cbf}ಕ\u{ccd}",
                "ಗುದ\u{ccd}ದುವ\u{cbf}ಕ\u{cc6}",
                "ಚಾಲನ\u{cc6}ಯಲ\u{ccd}ಲ\u{cbf}ದ\u{cc6}",
                "ಡ\u{ccd}ಯಾಶ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("달려나감"),
            keywords: &["달려나감", "슝", "후다닥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ध\u{941}कल\u{942}न उडोवप"),
            keywords: &[
                "धा\u{902}वप",
                "ध\u{941}कलप",
                "ध\u{941}कल\u{942}न उडोवप",
                "विनोदी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("куюндай"),
            keywords: &["комикс", "куюндай", "чурка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("séier fort"),
            keywords: &["Comic", "jauwen", "lafen", "séier fort"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຄ\u{eb7}\u{ec8}ອນທ\u{eb5}\u{ec8}ໄວ"),
            keywords: &[
                "ເຄ\u{eb7}\u{ec8}ອນທ\u{eb5}\u{ec8}ໄວ",
                "ເຄ\u{eb7}\u{ec8}ອນທ\u{eb5}\u{ec8}ໄຫວ",
                "ແລ\u{ec8}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sukeltos dulkės"),
            keywords: &["bėgimas", "dulkės", "komiksas", "sukeltos dulkės"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bēgšana"),
            keywords: &["bēgt", "bēgšana", "skriešana"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rere atu ana"),
            keywords: &["oma ana", "rere", "rere atu ana", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("брзање"),
            keywords: &["брза", "брзање", "стрип", "трчање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വേഗത"),
            keywords: &[
                "ഓട\u{d41}ന\u{d4d}ന\u{d41}",
                "കോമിക\u{d4d}ക\u{d4d}",
                "ഡ\u{d3e}ഷ\u{d4d}",
                "ഡ\u{d3e}ഷ\u{d4d} ചിഹ\u{d4d}നം",
                "വേഗത",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрч хүчтэй"),
            keywords: &["гүйж байгаа", "эрч хүч", "эрч хүчтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("घाईत धावण\u{947}"),
            keywords: &[
                "कॉमिक",
                "घाईत धावण\u{947}",
                "जोरात धावण\u{947}",
                "धावण\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("meluru"),
            keywords: &["berlari", "komik", "meluru"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("jaħrab ’l hemm"),
            keywords: &["jaħrab ’l hemm", "komiku", "qed jiġri", "sing"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တစ\u{103a}ဟ\u{102f}န\u{103a}ထ\u{102d}\u{102f}းပြေးခြင\u{103a}း"),
            keywords: &[
                "တစ\u{103a}ဟ\u{102f}န\u{103a}ထ\u{102d}\u{102f}း",
                "တစ\u{103a}ဟ\u{102f}န\u{103a}ထ\u{102d}\u{102f}းပြေးခြင\u{103a}း",
                "ပြေးခြင\u{103a}း",
                "ဟာသ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("stikker av"),
            keywords: &["forsvinne", "løpe", "stikker av", "tegneserie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जोडल\u{947}"),
            keywords: &[
                "जोडल\u{947}",
                "ड\u{94d}याश",
                "दौडिरह\u{947}को",
                "ह\u{901}साउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wegrennen"),
            keywords: &["rennen", "strip", "wegrennen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("stikk av"),
            keywords: &["forsvinne", "springe", "stikk av", "teikneserie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଡ\u{b3c}\u{b3f}ବ\u{b3e}"),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "ଖ\u{b41}ବ\u{b4d} ଜୋରରେ ଦୌଡ\u{b3c}\u{b3f}ବ\u{b3e}",
                "ଦୌଡ\u{b3c}\u{b3f} ପଳ\u{b3e}ଇବ\u{b3e}",
                "ଦୌଡ\u{b3c}\u{b3f}ବ\u{b3e}",
                "ପ\u{b3e}ଡ\u{b3c}\u{b3f}ବ\u{b3e}",
                "ଭ\u{b3e}ବନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a4c}ੜਨਾ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਚਲਦਾ ਡ\u{a48}ਸ\u{a3c}",
                "ਚ\u{a71}ਲਣਾ",
                "ਜਜ\u{a3c}ਬਾਤ",
                "ਦ\u{a4c}ੜਨਾ",
                "ਭ\u{a71}ਜਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خوش باش وکھرے ہو رہے"),
            keywords: &[
                "بھجدا",
                "خوش باش وکھرے ہو رہے",
                "مارنا",
                "م\u{64f}ضح\u{650}کہ خیز",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("To Ték Spid Rọn"),
            keywords: &[
                "Rọn",
                "Rọ\u{301}n Kwík Kwik",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "To Ték Spid Rọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("szybkie poruszanie się"),
            keywords: &[
                "podmuch wiatru",
                "pęd",
                "pędzić",
                "szybkie poruszanie się",
                "szybkość",
                "wiatr",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لري کول"),
            keywords: &["لري", "لري کول", "مسخره", "منډه وهل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("rapidez"),
            keywords: &["correr", "emoção", "engraçado", "fugir", "rapidez"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("ir-se embora"),
            keywords: &["corrida", "desenho", "fugir", "ir-se embora"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("karuman phawachkan"),
            keywords: &["comic", "karuman phawachkan", "phaway", "purichkan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ștergând-o rapid"),
            keywords: &[
                "alergare",
                "bandă desenată",
                "fugă",
                "grabă",
                "nor de praf",
                "viteză",
                "ștergând-o rapid",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-613"),
            keywords: &["E10-613"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("исчезновение"),
            keywords: &["исчезновение", "облако", "облачко", "пыли", "пыль"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’ibinyaruka"),
            keywords: &[
                "ikimenyetso cy’ibinyaruka",
                "inkuru ishushanyije",
                "kwiruka",
                "umuvuduko",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پري اڇلائڻ"),
            keywords: &["اڇلڻ", "مزاحيه", "پري اڇلائڻ", "ڊوڙندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ල\u{dd2}ස\u{dca}ස\u{dcf} ය\u{dcf}ම"),
            keywords: &[
                "ද\u{dd4}වම\u{dd2}න\u{dca}",
                "ල\u{dd2}ස\u{dca}ස\u{dcf} ය\u{dcf}ම",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("utekám"),
            keywords: &["bežať", "komiks", "trieliť", "utekať", "utekám"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("švigniti"),
            keywords: &["strip", "tek", "švigati", "švigniti"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("tagaayo"),
            keywords: &["majaajileeye", "ordaayo", "tagaayo", "tagid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("i vrullshëm"),
            keywords: &["i vrullshëm", "vizatim komik", "vrapim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бежање"),
            keywords: &["бeжaњe", "бежање", "стрип", "трчaњe"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("бјежање"),
            keywords: &["бјежање"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bežanje"),
            keywords: &["bežanje", "strip", "trčanje"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("bježanje"),
            keywords: &["bježanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fartsymbol"),
            keywords: &["fartsymbol", "springa", "springer iväg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kuharakisha"),
            keywords: &["dashi", "kibonzo", "kuharakisha", "kukimbia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ற\u{bcd}றடிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "ஓட\u{bcd}டம\u{bcd}",
                "க\u{bbe}ற\u{bcd}றடிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "க\u{bbe}ற\u{bcd}று",
                "புயல\u{bcd}",
                "விழுந\u{bcd}தடித\u{bcd}து ஓடுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c47}గంగ\u{c3e} పర\u{c3f}గ\u{c46}త\u{c4d}తడం"),
            keywords: &[
                "పరుగు",
                "వ\u{c47}గం",
                "వ\u{c47}గంగ\u{c3e} పర\u{c3f}గ\u{c46}త\u{c4d}తడం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тез гурехтан"),
            keywords: &["гурехтан", "давидаистода", "мазҳакавӣ", "тез гурехтан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ว\u{e34}\u{e48}งฉ\u{e34}ว"),
            keywords: &["ว\u{e34}\u{e48}งฉ\u{e34}ว", "ว\u{e34}\u{e48}งหน\u{e35}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zut jyrmak"),
            keywords: &["gaçmak", "gülkünç", "ylgamak", "zut jyrmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻoho atu"),
            keywords: &["ʻoho atu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hızla fırlama"),
            keywords: &["duygu", "hızla fırlama", "kaçma", "koşma", "çizgi roman"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇيۇندەك كېتىش"),
            keywords: &["قۇيۇن", "قۇيۇندەك كېتىش", "كۈلكىلىك", "يۈگۈرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("порив вітру"),
            keywords: &["біг", "комікси", "мчати", "порив вітру"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیزی سے دوڑنا"),
            keywords: &["تیزی", "تیزی سے دوڑنا", "دوڑنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqqon"),
            keywords: &["chaqqon", "latifa", "shoshilish", "yugurish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chớp nhoáng"),
            keywords: &["chạy", "chớp nhoáng", "hài hước", "lao", "lao đi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("dem sa yoon"),
            keywords: &["daw", "dem", "dem sa yoon", "reelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukubaleka"),
            keywords: &["baleka", "hlekisa", "ukubaleka"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("N Salọ"),
            keywords: &["N Salọ", "dáàṣì", "àwàdà", "ń sáré"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("快走"),
            keywords: &["快走", "快速", "搞笑", "跑"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("快走"),
            keywords: &["快走", "快速", "搞笑", "跑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("尾气"),
            keywords: &["尾气", "疾驰而去", "飞奔而去"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("揚塵而去"),
            keywords: &["揚塵而去", "放屁"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("強風"),
            keywords: &["大風", "強風", "快速", "放屁", "煙霧"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukushesha"),
            keywords: &["opopayi", "ukugijima", "ukushesha"],
        },
    ],
};
#[doc = "🕳\u{fe0f}"]
pub const HOLE: crate::Emoji = crate::Emoji {
    glyph: "🕳\u{fe0f}",
    codepoint: "1F573 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "hole",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🕳",
        codepoint: "1F573",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "hole",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gat"),
            keywords: &["gat"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቀዳዳ"),
            keywords: &["ቀዳዳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ثقب"),
            keywords: &["ثقب", "حفرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছিদ\u{9cd}ৰ"),
            keywords: &["ছিদ\u{9cd}ৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("deşik"),
            keywords: &["deşik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дзірка"),
            keywords: &["дзірка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дупка"),
            keywords: &["дупка", "яма"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("গর\u{9cd}ত"),
            keywords: &["গর\u{9cd}ত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("toull"),
            keywords: &["toull"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rupa"),
            keywords: &["rupa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("forat"),
            keywords: &["forat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᎴᏒᎢ"),
            keywords: &["ᎠᏔᎴᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("díra"),
            keywords: &["díra"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("twll"),
            keywords: &["twll"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hul"),
            keywords: &["hul", "sort"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Loch"),
            keywords: &["Loch", "schwarz"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τρύπα"),
            keywords: &["μαύρη", "τρύπα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hole"),
            keywords: &["hole"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("agujero"),
            keywords: &["agujero", "orificio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("agujero"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["agujero", "cómics", "pozo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("auk"),
            keywords: &["auk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zuloa"),
            keywords: &["zulo", "zuloa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چاله"),
            keywords: &["سوراخ", "چاله"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("musta aukko"),
            keywords: &["musta", "musta aukko", "pallo", "reikä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("butas"),
            keywords: &["butas", "manhole"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hol"),
            keywords: &["hol"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("trou"),
            keywords: &["trou"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("poll"),
            keywords: &["poll"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("toll"),
            keywords: &["toll"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("burato"),
            keywords: &["buraco", "burato"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છિદ\u{acd}ર"),
            keywords: &["કાણ\u{ac1}\u{a82}", "છિદ\u{acd}ર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("rami"),
            keywords: &["rami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חור"),
            keywords: &["בור", "חור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छिद\u{94d}र"),
            keywords: &["गड\u{94d}ढा", "छिद\u{94d}र"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rupa"),
            keywords: &["rupa"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lyuk"),
            keywords: &["lyuk"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փոս"),
            keywords: &["անցք", "փոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lubang"),
            keywords: &["lobang", "lubang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnụ oghere"),
            keywords: &["ọnụ oghere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hola"),
            keywords: &["hola", "op"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("buco"),
            keywords: &["buco", "fumetto", "nero"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("穴"),
            keywords: &["穴"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bolongan"),
            keywords: &["bolongan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხვრელი"),
            keywords: &["ხვრელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тесік"),
            keywords: &["тесік"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hul"),
            keywords: &["hul", "sort"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រហោយ"),
            keywords: &["ប\u{17d2}រហោង", "ប\u{17d2}រហោយ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರಂಧ\u{ccd}ರ"),
            keywords: &["ಕುಳ\u{cbf}", "ರಂಧ\u{ccd}ರ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("구멍"),
            keywords: &["검은 구멍", "구멍"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ब\u{941}राक"),
            keywords: &["ब\u{941}राक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тешик"),
            keywords: &["тешик"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Lach"),
            keywords: &["Lach"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮ\u{eb9}"),
            keywords: &["ຮ\u{eb9}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("duobė"),
            keywords: &["duobė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("caurums"),
            keywords: &["caurums"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("puare"),
            keywords: &["puare"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дупка"),
            keywords: &["дупка", "отвор"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ഴി"),
            keywords: &["ക\u{d41}ഴി", "ക\u{d42}ഴി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүх"),
            keywords: &["нүх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भोक"),
            keywords: &["छिद\u{94d}र", "भोक"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lubang"),
            keywords: &["lubang"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("toqba"),
            keywords: &["toqba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အပေါက\u{103a}"),
            keywords: &["အပေါက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hull i bakken"),
            keywords: &["hull", "hull i bakken"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}वाल"),
            keywords: &["प\u{94d}वाल"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gat"),
            keywords: &["gat"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hol i bakken"),
            keywords: &["hol", "hol i bakken"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3e}ତ"),
            keywords: &["ଗ\u{b3e}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਡ"),
            keywords: &["ਖ\u{a41}\u{a71}ਡ", "ਮ\u{a4b}ਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("موری"),
            keywords: &["موری"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hol"),
            keywords: &["Hol"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("otwór"),
            keywords: &["dziura", "otwór"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سورۍ"),
            keywords: &["سورۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("buraco"),
            keywords: &["buraco", "buraco no chão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["buraco", "buraco no chão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("t’uqu"),
            keywords: &["t’uqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gaură"),
            keywords: &["gaură"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-794"),
            keywords: &["E10-794"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("дыра"),
            keywords: &["дыра", "отверстие", "пропасть", "черная"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwobo"),
            keywords: &["umwobo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سوراخ"),
            keywords: &["سوراخ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dd4}හරය"),
            keywords: &["ක\u{dd4}හරය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jama"),
            keywords: &["diera", "jama", "kanál"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("luknja"),
            keywords: &["luknja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("god"),
            keywords: &["god"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vrimë"),
            keywords: &["vrimë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рупа"),
            keywords: &["рупa", "рупа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рупа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rupa"),
            keywords: &["rupa"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["rupa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hål"),
            keywords: &["hål"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shimo"),
            keywords: &["shimo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குழி"),
            keywords: &["குழி", "பள\u{bcd}ளம\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రంధ\u{c4d}రం"),
            keywords: &["రంధ\u{c4d}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сурох"),
            keywords: &["сурох"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หล\u{e38}ม"),
            keywords: &["หล\u{e38}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("deşik"),
            keywords: &["deşik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ava"),
            keywords: &["ava"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("delik"),
            keywords: &["delik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تۆشۈك"),
            keywords: &["تۆشۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лунка"),
            keywords: &["діра", "лунка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سوراخ"),
            keywords: &["خالی جگہ", "سوراخ", "چھید"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("teshik"),
            keywords: &["darcha", "kovak", "teshik", "tuynuk"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lỗ"),
            keywords: &["lỗ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("pax"),
            keywords: &["pax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umngxuma"),
            keywords: &["umngxuma"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ihò"),
            keywords: &["ihò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("窿"),
            keywords: &["窿"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("窿"),
            keywords: &["窿"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("洞"),
            keywords: &["坑", "洞", "陷阱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("洞"),
            keywords: &["坑洞", "洞"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("imbobo"),
            keywords: &["imbobo"],
        },
    ],
};
#[doc = "💣"]
pub const BOMB: crate::Emoji = crate::Emoji {
    glyph: "💣",
    codepoint: "1F4A3",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bomb",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bom"),
            keywords: &["bom", "strokie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቦምብ"),
            keywords: &["ቦምብ", "አስቂኝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قنبلة"),
            keywords: &["قنبلة", "مشاعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বোম\u{9be}"),
            keywords: &["কমিক", "বোম\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("bomba"),
            keywords: &["bomba", "komik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бомба"),
            keywords: &["бомба", "камічны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бомба"),
            keywords: &["бомба", "комикс"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বোম\u{9be}"),
            keywords: &["কমিক", "বোম\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bombezenn"),
            keywords: &["bombezenn", "tresadenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("bomba"),
            keywords: &["bomba", "stripovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bomba"),
            keywords: &["bomba", "còmic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏔᏍᎩᏍᎩ"),
            keywords: &["ᎠᏔᏍᎩᏍᎩ", "ᎤᏬᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("bomba"),
            keywords: &["bomba", "komiks"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bom"),
            keywords: &["bom", "comig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bombe"),
            keywords: &["bombe", "følelse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bombe"),
            keywords: &["Bombe", "Comic"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βόμβα"),
            keywords: &["βόμβα", "κόμικ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bomb"),
            keywords: &["bomb", "comic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bomba"),
            keywords: &["bomba", "cómic", "emoción"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bomba", "cómics", "explosión", "explota"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["bomba", "comic"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pomm"),
            keywords: &["koomiks", "pomm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lehergailua"),
            keywords: &["komiki", "lehergailua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بمب"),
            keywords: &["بمب", "مصور", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pommi"),
            keywords: &["pommi", "sarjakuva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bomba"),
            keywords: &["armas", "bomba", "komiks", "pampasabog", "sandata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bumba"),
            keywords: &["bumba", "vopn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bombe"),
            keywords: &["bombe", "dessin"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bande dessinée", "bombe"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buama"),
            keywords: &["buama", "pléascadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boma"),
            keywords: &["boma", "dealbh-èibhinn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bomba"),
            keywords: &["bomba", "cómic"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બોમ\u{acd}બ"),
            keywords: &["બોમ\u{acd}બ", "રમ\u{ac2}જી", "લાગણી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("bam"),
            keywords: &["bam", "mai ban dariya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פצצה"),
            keywords: &["פצצה", "קומיקס", "רימון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बम"),
            keywords: &["कॉमिक", "बम", "भावना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("bomba"),
            keywords: &["bomba", "eksplozija", "karikatura", "uskoro"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bomba"),
            keywords: &["bomba", "képregény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ռումբ"),
            keywords: &["կոմիքս", "ռումբ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bom"),
            keywords: &["bom", "komik"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ogbunigwe"),
            keywords: &["mkpaọchị", "ogbunigwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sprengja"),
            keywords: &["skrípó", "sprengja", "tilfinningar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bomba"),
            keywords: &["bomba", "emozione", "fumetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("爆弾"),
            keywords: &["爆弾"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bom"),
            keywords: &["bom", "komik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბომბი"),
            keywords: &["ბომბი", "სასაცილო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бомба"),
            keywords: &["бомба", "комик", "ұйқы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bombe"),
            keywords: &["bombe", "følelse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រាប\u{17cb}បែក"),
            keywords: &["គ\u{17d2}រាប\u{17cb}បែក", "ផ\u{17d2}ទ\u{17bb}ះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಂಬ\u{ccd}"),
            keywords: &["ಕಾಮ\u{cbf}ಕ\u{ccd}", "ಬಾಂಬ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("폭탄"),
            keywords: &["폭발", "폭탄"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बा\u{901}ब"),
            keywords: &["बा\u{901}ब", "विनोदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бомба"),
            keywords: &["бомба", "комикс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bomm"),
            keywords: &["Bomm", "Comic"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລະເບ\u{eb5}ດ"),
            keywords: &["ຕະລ\u{ebb}ກ", "ລະເບ\u{eb5}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("bomba"),
            keywords: &["bomba", "komiksas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("spridzeklis"),
            keywords: &["bumba", "spridzeklis", "spridzināt", "sprāgt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pōma"),
            keywords: &["pōma", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бомба"),
            keywords: &["бомба", "бум", "стрип"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബോംബ\u{d4d}"),
            keywords: &["കോമിക\u{d4d}ക\u{d4d}", "ബോംബ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тэсрэх бөмбөг"),
            keywords: &["бөмбөг", "тэсрэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बॉम\u{94d}ब"),
            keywords: &["कॉमिक", "बॉम\u{94d}ब"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bom"),
            keywords: &["bom", "komik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bomba"),
            keywords: &["bomba", "komiku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{102f}\u{1036}း"),
            keywords: &["ဗ\u{102f}\u{1036}း", "ဟာသ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bombe"),
            keywords: &["bombe", "følelse", "tegneserie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बम"),
            keywords: &["बम", "ह\u{901}साउन\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bom"),
            keywords: &["bom", "strip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bombe"),
            keywords: &["bombe", "kjensle", "teikneserie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବୋମ\u{b3e}"),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "ବୋମ\u{b3e}",
                "ହ\u{b3e}ସ\u{b4d}ୟୋଦ\u{b4d}ଦୀପକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a70}ਬ"),
            keywords: &["ਕਾਮਿਕ", "ਜਜ\u{a3c}ਬਾਤ", "ਬ\u{a70}ਬ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بمب"),
            keywords: &["بمب", "م\u{64f}ضح\u{650}کہ خیز"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bọmb"),
            keywords: &["Bọmb", "Jok", "Plè Plé"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("bomba"),
            keywords: &["bomba", "żartobliwy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بم"),
            keywords: &["بم", "مسخره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bomba"),
            keywords: &["bomba", "emoção", "engraçado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bomba", "desenho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("bomba"),
            keywords: &["bomba", "comic"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bombă"),
            keywords: &["bandă desenată", "bombă", "fitil"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-608"),
            keywords: &["E10-608"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бомба"),
            keywords: &["бомба", "взрыв", "опасность", "черная"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibombe"),
            keywords: &["ibombe", "inkuru ishushanyije"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بم"),
            keywords: &["بم", "ڪامڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බෝම\u{dca}බය"),
            keywords: &["බෝම\u{dca}බය", "හ\u{dcf}ස\u{dca}\u{200d}යජනක"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bomba"),
            keywords: &["bomba", "komiks"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bomba"),
            keywords: &["bomba", "strip"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bam"),
            keywords: &["bam", "majaajileeye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bombë"),
            keywords: &["bombë", "vizatim komik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бомба"),
            keywords: &["eксплoзиja", "бомба", "стрип", "ускoрo"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["бомба"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("bomba"),
            keywords: &["bomba", "eksplozija", "strip", "uskoro"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["bomba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bomb"),
            keywords: &["bomb", "serietidning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bomu"),
            keywords: &["bomu", "kibonzo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெடிபொருள\u{bcd}"),
            keywords: &[
                "குண\u{bcd}டு",
                "குண\u{bcd}டுவெடிப\u{bcd}பு",
                "வெடிகுண\u{bcd}டு",
                "வெடிபொருள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3e}ంబ\u{c4d}"),
            keywords: &["బ\u{c3e}ంబ\u{c4d}", "వ\u{c3f}ధ\u{c4d}వంసం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бомба"),
            keywords: &["бомба", "мазҳакавӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ระเบ\u{e34}ด"),
            keywords: &["ระเบ\u{e34}ด", "โกรธมาก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bomba"),
            keywords: &["bomba", "gülkünç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulukōkō"),
            keywords: &["pulukōkō"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bomba"),
            keywords: &["bomba", "duygu", "çizgi roman"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پارتلاتقۇچ"),
            keywords: &["كۈلكىلىك", "پارتلاتقۇچ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("бомба"),
            keywords: &["бомба", "комікси"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بم"),
            keywords: &["آگ", "بم", "بمباری"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bomba"),
            keywords: &["bomba", "latifa"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bom"),
            keywords: &["bom", "hài hước"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bomb"),
            keywords: &["bomb", "reelu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhombu"),
            keywords: &["hlekisa", "ibhombu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bọmbu"),
            keywords: &["Bọmbu", "àwàdà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("炸彈"),
            keywords: &["搞笑", "炸彈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("炸弹"),
            keywords: &["搞笑", "炸弹"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("炸弹"),
            keywords: &["炸弹", "爆炸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("炸彈"),
            keywords: &["地雷", "炸彈", "雷區"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhomu"),
            keywords: &["ibhomu", "opopayi"],
        },
    ],
};
#[doc = "💬"]
pub const SPEECH_BALLOON: crate::Emoji = crate::Emoji {
    glyph: "💬",
    codepoint: "1F4AC",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "speech balloon",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spraakballon"),
            keywords: &[
                "ballon",
                "borrel",
                "dialoog",
                "spraak",
                "spraakballon",
                "strokie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የንግግር አፉፋ"),
            keywords: &["ንግግር", "አረፋ", "አስቂኝ", "አፉፋ", "ወሬ", "የንግግር አፉፋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فقاعة كلام"),
            keywords: &["بالونة", "حوار", "فقاعة كلام"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}পিচ বেল\u{9c1}ন"),
            keywords: &[
                "কথন",
                "কমিক",
                "বেল\u{9c1}ন",
                "সংল\u{9be}প",
                "স\u{9cd}পিচ বেল\u{9c1}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("nitq şarı"),
            keywords: &["dialoq", "komik", "köpük", "nitq", "nitq şarı", "şar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("воблачка з тэкстам"),
            keywords: &[
                "бурбалка",
                "воблачка",
                "воблачка з тэкстам",
                "дыялог",
                "камічны",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Балонче за говор"),
            keywords: &["Балонче за говор", "балонче", "говор", "диалог", "комикс"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বক\u{9cd}তব\u{9cd}যের বেল\u{9c1}ন"),
            keywords: &[
                "কমিক",
                "ড\u{9be}য\u{9bc}\u{9be}লগ",
                "বক\u{9cd}তব\u{9cd}যের বেল\u{9c1}ন",
                "বক\u{9cd}ত\u{9c3}ত\u{9be}",
                "ব\u{9c1}দ\u{9cd}ব\u{9c1}দ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačić razgovora"),
            keywords: &[
                "dijalog",
                "oblačić",
                "oblačić razgovora",
                "razgovor",
                "stripovi",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bafarada de parlar"),
            keywords: &[
                "bafarada",
                "bafarada de parlar",
                "còmic",
                "diàleg",
                "parlar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏬᏂᎯᏍᏗᎢ ᎤᏃᎴ ᎠᏲᏙᏗ"),
            keywords: &[
                "ᎤᏃᎴ ᎠᏲᏙᏗ",
                "ᎤᏆᎷᏒ",
                "ᎤᏬᏟᏗ",
                "ᎦᏬᏂᎯᏍᏗᎢ",
                "ᎦᏬᏂᎯᏍᏗᎢ ᎤᏃᎴ ᎠᏲᏙᏗ",
                "ᏗᏟᏃᎮᏗᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("řečová bublina"),
            keywords: &["bublina", "dialog", "komiks", "řeč", "řečová bublina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("balŵn deialog"),
            keywords: &["balŵn", "comig", "deialog", "swigen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("taleboble"),
            keywords: &["tale", "taleboble"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sprechblase mit drei Punkten"),
            keywords: &[
                "Dialog",
                "Gespräch",
                "Sprechblase",
                "Sprechblase mit drei Punkten",
                "Unterhaltung",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συννεφάκι ομιλίας"),
            keywords: &[
                "διάλογος",
                "κόμικ",
                "μπαλόνι",
                "ομιλία",
                "συννεφάκι",
                "συννεφάκι ομιλίας",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("speech balloon"),
            keywords: &["balloon", "bubble", "comic", "dialog", "speech"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["balloon", "bubble", "comic", "dialogue", "speech"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bocadillo de diálogo"),
            keywords: &[
                "bocadillo",
                "bocadillo de diálogo",
                "conversación",
                "cómic",
                "diálogo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo de diálogo"),
            keywords: &[
                "burbuja",
                "cómic",
                "diálogo",
                "globo",
                "globo de diálogo",
                "hablar",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["burbuja", "cómics", "diálogo", "globo", "globo de diálogo"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "burbuja",
                "comic",
                "diálogo",
                "globo",
                "globo de diágolo",
                "globo de diálogo",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jutumull"),
            keywords: &["dialoog", "jutt", "jutumull", "koomiks", "mull"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bunbuiloa"),
            keywords: &["bunbuiloa", "elkarrizketa", "hizketa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بالن گفتار"),
            keywords: &[
                "بالن",
                "بالن گفتار",
                "حباب",
                "دیالوگ",
                "مصور",
                "کمیک",
                "گفتگو",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puhekupla"),
            keywords: &[
                "ilmapallo",
                "keskustelu",
                "kupla",
                "puhe",
                "puhekupla",
                "sarjakuva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("speech balloon"),
            keywords: &["balloon", "dialog", "komiks", "speech balloon", "usapan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("talubløðra"),
            keywords: &["bløðra", "samtala", "tala", "talubløðra"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bulle de parole"),
            keywords: &["bulle", "bulle de parole", "dialogue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bande dessinée",
                "bulle",
                "bulle de parole",
                "dialogue",
                "parole",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bolgán cainte"),
            keywords: &["bolgán", "bolgán cainte", "caint"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("builgean còmhraidh"),
            keywords: &[
                "bailiùn",
                "bruidhinn",
                "builgean",
                "builgean còmhraidh",
                "cainnt",
                "còmhradh",
                "dealbh-èibhinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo de diálogo á esquerda"),
            keywords: &[
                "cómic",
                "diálogo",
                "falar",
                "globo",
                "globo de diálogo á esquerda",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભાષણ ફ\u{ac1}ગ\u{acd}ગો"),
            keywords: &[
                "પરપોટો",
                "ફ\u{ac1}ગ\u{acd}ગો",
                "ભાષણ પરપોટો",
                "ભાષણ ફ\u{ac1}ગ\u{acd}ગો",
                "રમ\u{ac2}જી",
                "સ\u{a82}વાદ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("balan-balan magana"),
            keywords: &["balan-balan", "kumfa", "magana", "mai ban dariya", "zance"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בועת דיבור"),
            keywords: &["בועה", "בועת דיבור", "בלון", "דו-שיח", "דיאלוג", "שיחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{902}वाद ब\u{941}लब\u{941}ला"),
            keywords: &[
                "कॉमिक",
                "ग\u{941}ब\u{94d}बारा",
                "ब\u{941}लब\u{941}ला",
                "बोलन\u{947} का ग\u{941}ब\u{94d}बारा",
                "वाक ब\u{941}लब\u{941}ला",
                "स\u{902}वाद",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("govorni oblačić"),
            keywords: &["dijalog", "govor", "govorni oblačić", "oblačić", "strip"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szövegbuborék"),
            keywords: &[
                "beszéd",
                "buborék",
                "képregény",
                "párbeszéd",
                "szövegbuborék",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոսքի ամպիկ"),
            keywords: &[
                "երկխոսություն",
                "խոսք",
                "խոսքի ամպիկ",
                "կոմիքս",
                "պղպջակ",
                "փուչիկ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("balon ucapan"),
            keywords: &["balon", "dialog", "gelembung", "komik", "ucapan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("blonblon okwu"),
            keywords: &["blonblo", "blonblon", "mkpaọchị", "okwu", "ụbụbọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("talblaðra"),
            keywords: &["blaðra", "skrípó", "tala", "talblaðra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fumetto"),
            keywords: &["dialogo", "fumetto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("会話の吹き出し"),
            keywords: &["セリフ", "会話", "会話の吹き出し", "吹き出し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balon omongan"),
            keywords: &["balon", "dhiyalog", "komik", "omongan", "plendhungan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საუბრის ბუშტი"),
            keywords: &["ბუშტი", "დიალოგი", "ლაპარაკი", "სასაცილო", "საუბრის ბუშტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сұхбаттасу көпіршігі"),
            keywords: &[
                "диалог",
                "комик",
                "көпіршік",
                "сұхбат",
                "сұхбаттасу көпіршігі",
                "ұшатын шар",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("taleboble"),
            keywords: &["tale", "taleboble"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "រង\u{17d2}វង\u{17cb}បង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយខាងស\u{17d2}តា\u{17c6}",
            ),
            keywords: &[
                "ន\u{17b7}យាយ",
                "ពាក\u{17d2}យសម\u{17d2}ត\u{17b8}",
                "រង\u{17d2}វង\u{17cb}បង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយខាងស\u{17d2}តា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಧ\u{ccd}ವನ\u{cbf} ಬಲ\u{cc2}ನ\u{ccd}"),
            keywords: &[
                "ಧ\u{ccd}ವನ\u{cbf} ಬಲ\u{cc2}ನ\u{ccd}",
                "ಮಾತ\u{cbf}ನ ಬಬಲ\u{ccd}",
                "ಮಾತ\u{cbf}ನ ಬಲ\u{cc2}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("말풍선"),
            keywords: &["대화", "대화창", "말풍선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाचा बोमाडो"),
            keywords: &["फ\u{941}गो", "बोमाडो", "वाचा", "विनोदी", "स\u{902}वाद"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кеп шарчасы"),
            keywords: &[
                "диалог",
                "кеп",
                "кеп көбүгү",
                "кеп шарчасы",
                "комикс",
                "көбүк",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Spriechblos"),
            keywords: &[
                "Ball",
                "Blos",
                "Comic",
                "Dialog",
                "Spriechblos",
                "schwätzen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb9}ມເປ\u{ebb}\u{ec9}າຄຳເວ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຄຳເວ\u{ebb}\u{ec9}າ",
                "ບ\u{ebb}ດສ\u{ebb}ນທະນາ",
                "ປ\u{eb9}ມເປ\u{ebb}\u{ec9}າ",
                "ປ\u{eb9}ມເປ\u{ebb}\u{ec9}າຄຳເວ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalbos debesėlis"),
            keywords: &[
                "balionas",
                "debesėlis",
                "dialogas",
                "kalba",
                "kalbos debesėlis",
                "komiksas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("runas burbulis"),
            keywords: &["burbulis", "dialogs", "runa", "runas burbulis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūangi kōrero"),
            keywords: &["kōrero", "mirumiru", "pūangi", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("балон за говор"),
            keywords: &["балон", "балон за говор", "говор", "дијалог", "стрип"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സംഭ\u{d3e}ഷണ ബല\u{d42}ൺ"),
            keywords: &[
                "ക\u{d41}മിള",
                "കോമിക\u{d4d}ക\u{d4d}",
                "ബല\u{d42}ൺ",
                "സംഭ\u{d3e}ഷണ ബല\u{d42}ൺ",
                "സംഭ\u{d3e}ഷണം",
                "സംസ\u{d3e}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ярианы хэсэг"),
            keywords: &["төсөөлөл", "шаар", "яриа", "ярианы хэсэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}वाद दर\u{94d}शविणारा फ\u{941}गा"),
            keywords: &[
                "कॉमिक",
                "फ\u{941}गा",
                "बबल",
                "बोलण\u{947}",
                "स\u{902}वाद",
                "स\u{902}वाद दर\u{94d}शविणारा फ\u{941}गा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelembung pertuturan"),
            keywords: &[
                "belon",
                "dialog",
                "gelembung",
                "gelembung pertuturan",
                "komik",
                "ucapan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bużżieqa tad-diskors"),
            keywords: &[
                "buzzieqa",
                "bużżieqa",
                "bużżieqa tad-diskors",
                "djalogu",
                "komik",
                "taħdit",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စကားပြော အက\u{103d}က\u{103a}"),
            keywords: &[
                "စကားပြော",
                "စကားပြောအက\u{103d}က\u{103a}",
                "ပ\u{1030}ဖောင\u{103a}း",
                "အက\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("snakkeboble"),
            keywords: &[
                "ballong",
                "boble",
                "dialog",
                "dialogboble",
                "snakkeboble",
                "tegneserie",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("वाक\u{94d}य ब\u{947}ल\u{941}न"),
            keywords: &[
                "फोका",
                "ब\u{947}ल\u{941}न",
                "वाक\u{94d}य",
                "स\u{902}वाद",
                "ह\u{901}साउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spraakballon"),
            keywords: &[
                "ballon",
                "dialoog",
                "spraak",
                "spraakballon",
                "strip",
                "tekstballon",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("snakkeboble"),
            keywords: &[
                "ballong",
                "boble",
                "dialog",
                "dialogboble",
                "snakkeboble",
                "teikneserie",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଥନ ବେଲ\u{b41}ନ\u{b4d}"),
            keywords: &[
                "କଥନ ବେଲ\u{b41}ନ\u{b4d}",
                "କମ\u{b3f}କ\u{b4d}",
                "କହ\u{b3f}ବ\u{b3e} ବବଲ\u{b4d}",
                "କହ\u{b3f}ବ\u{b3e} ବେଲ\u{b41}ନ\u{b4d}",
                "ବବଲ\u{b4d}",
                "ବେଲ\u{b41}ନ\u{b4d}",
                "ସଂଳ\u{b3e}ପ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4b}ਲੀ ਬਬਲ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਗ\u{a41}ਬਾਰਾ",
                "ਗ\u{a71}ਲ-ਬਾਤ",
                "ਬ\u{a41}ਲਬ\u{a41}ਲਾ",
                "ਬ\u{a4b}ਲੀ ਬਬਲ",
                "ਭਾਸ\u{a3c}ਣ ਗ\u{a41}ਬਾਰਾ",
                "ਭਾਸ\u{a3c}ਣ ਬ\u{a41}ਲਬ\u{a41}ਲਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تقریری بھکانہ"),
            keywords: &[
                "تقریر",
                "تقریری بھکانہ",
                "حباب",
                "م\u{64f}ضح\u{650}کہ خیز",
                "مکالمہ",
                "پکانہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹ\u{301}séj Blonbló Píkchọ"),
            keywords: &[
                "Blonbló",
                "Bọ\u{301}bul",
                "Jok",
                "Mẹ\u{301}séj Blonbló Píkchọ",
                "Ple Plé",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "To Tọk Tọ\u{301}k Wít Pípul",
                "Tọk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dymek"),
            keywords: &["dialog", "dymek", "rozmowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بیان پوګاڼه"),
            keywords: &["بیان", "خبري", "مسخره", "پوګاڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balão de diálogo"),
            keywords: &[
                "balão",
                "balão de conversa",
                "balão de diálogo",
                "diálogo",
                "engraçado",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("balão de fala"),
            keywords: &["balão", "balão de fala", "desenho", "diálogo", "fala"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rimaypa glubun"),
            keywords: &[
                "glubu",
                "kusi",
                "phukpu",
                "rimana",
                "rimasqa",
                "rimaypa glubun",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balon de dialog"),
            keywords: &["balon", "balon de dialog", "bandă desenată", "dialog"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-617"),
            keywords: &["E10-617"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("облачко с многоточием"),
            keywords: &[
                "многоточие",
                "мысли",
                "облако",
                "облако с многоточием",
                "облачко",
                "облачко с многоточием",
                "речь",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igipurizomvugo"),
            keywords: &[
                "akabaruni",
                "akabarunigitekerezo",
                "igipurizomvugo",
                "ikiganiro",
                "imvugo",
                "inkuru ishushanyije",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳالهائڻ وارو ڦوڪڻو"),
            keywords: &[
                "بلبلا",
                "مزاحيه",
                "ڦڪڻو",
                "ڳاله ٻوله",
                "ڳالهائڻ وارو ڦوڪڻو",
                "ڳاهائڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කථන බැල\u{dd6}නය"),
            keywords: &[
                "කථන බැල\u{dd4}නය",
                "කථන බැල\u{dd6}නය",
                "කථ\u{dcf}ව",
                "දෙබස",
                "බැල\u{dd6}නය",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("reč"),
            keywords: &["bublina", "hovoriť", "komiks", "reč"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblaček z govorom"),
            keywords: &[
                "balon",
                "dialog",
                "govor",
                "oblaček",
                "oblaček z govorom",
                "strip",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("balluun hadal"),
            keywords: &["balluun", "hadal", "majaajileeye", "wada hadal", "xumbo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flluskë e të folurit"),
            keywords: &[
                "balonë",
                "dialog",
                "flluskë",
                "flluskë e të folurit",
                "vizatim komik",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облачић за говор"),
            keywords: &["oблaчић", "гoвoр", "диjaлoг", "облачић за говор", "стрип"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["облачић за говор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblačić za govor"),
            keywords: &["dijalog", "govor", "oblačić", "oblačić za govor", "strip"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oblačić za govor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pratbubbla"),
            keywords: &["bubbla", "dialogbubbla", "pratbubbla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha usemi"),
            keywords: &[
                "ishara",
                "kibonzo",
                "kitufe cha usemi",
                "mazungumzo",
                "puto",
                "usemi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேச\u{bcd}சு வடிவ பலூன\u{bcd}"),
            keywords: &[
                "உரைய\u{bbe}டல\u{bcd}",
                "குமிழ\u{bcd}",
                "பேச\u{bcd}சு",
                "பேச\u{bcd}சு வடிவ பலூன\u{bcd}",
                "பேச\u{bcd}சுக\u{bcd}குமிழ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("డ\u{c48}ల\u{c3e}గ\u{c4d} బుడగ"),
            keywords: &["డ\u{c48}ల\u{c3e}గ\u{c4d}", "బుడగ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳубоби нутқ"),
            keywords: &[
                "балон",
                "мазҳакавӣ",
                "муколама",
                "нутқ",
                "ҳубоб",
                "ҳубоби нутқ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พ\u{e39}ดไม\u{e48}ออก"),
            keywords: &[
                "คำพ\u{e39}ด",
                "บทสนทนา",
                "พ\u{e39}ดไม\u{e48}ออก",
                "ล\u{e39}กโป\u{e48}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gepleşik şary"),
            keywords: &[
                "gepleşik",
                "gepleşik şary",
                "gülkünç",
                "gürrüň",
                "köpük",
                "şar",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulalea"),
            keywords: &["pulalea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("konuşma balonu"),
            keywords: &[
                "balon",
                "iletişim",
                "iletişim balonu",
                "konuşma balonu",
                "çizgi roman",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆز رامكىسى"),
            keywords: &[
                "دىيالوگ",
                "سۆز رامكىسى",
                "سۆزلەش",
                "شار",
                "كۆپۈك",
                "كۈلكىلىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("текстова булька"),
            keywords: &[
                "діалог",
                "комікси",
                "розмова",
                "текстова булька",
                "хмаринка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گفتگو غبارہ"),
            keywords: &["علامت", "غبارہ", "گفتگو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nutq buluti"),
            keywords: &["dialog", "latifa", "nutq", "nutq buluti", "pufak", "shar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bong bóng lời nói"),
            keywords: &[
                "bong bóng",
                "bong bóng lời nói",
                "bài diễn văn",
                "bóng",
                "hài hước",
                "thoại",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("rëddu bind kàddu"),
            keywords: &["bul", "jalog", "mànq", "reelu", "rëddu bind kàddu", "wax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhaloni yentetho"),
            keywords: &[
                "hlekisa",
                "ibhaloni yentetho",
                "ibhaluni",
                "incoko",
                "intetho",
                "iqhamza",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bàlúnù Ọ\u{300}rọ\u{300} Sísọ"),
            keywords: &[
                "Bàlúnù Ọ\u{300}rọ\u{300} Sísọ",
                "bàlú",
                "àdàlú",
                "àwàdà",
                "ìtàkùrọ\u{300}sọ",
                "ọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("對話氣球"),
            keywords: &["對話", "對話氣球", "搞笑", "氣球", "泡泡", "講野"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("对话气球"),
            keywords: &["对话", "对话气球", "搞笑", "气球", "泡泡", "讲野"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("话语气泡"),
            keywords: &["发言", "对话框", "气泡", "话语气泡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("對話框"),
            keywords: &["對話框"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhaluni lenikulumo"),
            keywords: &["ibhaluni", "ibhaluni lenikulumo", "inkulumo", "opopayi"],
        },
    ],
};
#[doc = "👁\u{fe0f}\u{200d}🗨\u{fe0f}"]
pub const EYE_IN_SPEECH_BUBBLE: crate::Emoji = crate::Emoji {
    glyph: "👁\u{fe0f}\u{200d}🗨\u{fe0f}",
    codepoint: "1F441 FE0F 200D 1F5E8 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 2f32,
    name: "eye in speech bubble",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[
        crate::Emoji {
            glyph: "👁\u{200d}🗨\u{fe0f}",
            codepoint: "1F441 200D 1F5E8 FE0F",
            status: crate::Status::Unqualified,
            introduction_version: 2f32,
            name: "eye in speech bubble",
            group: "Smileys & Emotion",
            subgroup: "emotion",
            is_variant: true,
            variants: &[],
            annotations: &[],
        },
        crate::Emoji {
            glyph: "👁\u{fe0f}\u{200d}🗨",
            codepoint: "1F441 FE0F 200D 1F5E8",
            status: crate::Status::Unqualified,
            introduction_version: 2f32,
            name: "eye in speech bubble",
            group: "Smileys & Emotion",
            subgroup: "emotion",
            is_variant: true,
            variants: &[],
            annotations: &[],
        },
        crate::Emoji {
            glyph: "👁\u{200d}🗨",
            codepoint: "1F441 200D 1F5E8",
            status: crate::Status::Unqualified,
            introduction_version: 2f32,
            name: "eye in speech bubble",
            group: "Smileys & Emotion",
            subgroup: "emotion",
            is_variant: true,
            variants: &[],
            annotations: &[],
        },
    ],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oog in spraakborrel"),
            keywords: &["afloer", "getuie", "oog in spraakborrel", "spraakborrel"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዓይን በንግግር አፉፋ"),
            keywords: &["ምስክር", "ንግግር", "አይን", "ዓይን በንግግር አፉፋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عين في فقاعة كلام"),
            keywords: &["شاهد", "عين", "عين في فقاعة كلام", "فقاعة تفسيرية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চক\u{9c1}ৰ দৰে স\u{9cd}পিচ ব\u{9be}ব’ল"),
            keywords: &[
                "চক\u{9c1}",
                "চক\u{9c1}ৰ দৰে স\u{9cd}পিচ ব\u{9be}ব’ল",
                "স\u{9be}ক\u{9cd}ষী",
                "স\u{9cd}পিচ ব\u{9be}ব’ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tanıq işarəsi"),
            keywords: &["göz", "nitq qabarcığı", "tanıq işarəsi", "şahid"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вока ў бурбалцы"),
            keywords: &["бурбалка з тэкстам", "вока", "вока ў бурбалцы", "сведка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("око в балонче за говор"),
            keywords: &[
                "балонче за говор",
                "око",
                "око в балонче за говор",
                "свидетел",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখের মতন স\u{9cd}পিচ ব\u{9be}বল"),
            keywords: &[
                "চোখ",
                "চোখের মতন স\u{9cd}পিচ ব\u{9be}বল",
                "স\u{9be}ক\u{9cd}ষী",
                "স\u{9cd}পিচ ব\u{9be}বল",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oko u oblačiću razgovora"),
            keywords: &[
                "motrenje",
                "oblačić razgovora",
                "oko",
                "oko u oblačiću razgovora",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ull dins d’una bafarada"),
            keywords: &[
                "bafarada",
                "testimoni",
                "ull",
                "ull dins d’una bafarada",
                "vist",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘ ᎥᎿ ᎥᎧᏁᎬᎢ ᎤᏆᎷᏒ"),
            keywords: &["ᎠᎦᏔᎯ", "ᎠᎦᏘ", "ᎠᎦᏘ ᎥᎿ ᎥᎧᏁᎬᎢ ᎤᏆᎷᏒ", "ᎥᎧᏁᎬᎢ ᎤᏆᎷᏒ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oko v řečové bublině"),
            keywords: &[
                "oko",
                "oko v řečové bublině",
                "svědectví",
                "svědek",
                "řečová bublina",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llygad mewn cwmwl"),
            keywords: &["llygad", "llygad mewn cwmwl", "mewn cwmwl", "tyst"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("øje i taleboble"),
            keywords: &["se", "taleboble", "vidne", "øje", "øje i taleboble"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Auge in Sprechblase"),
            keywords: &["Auge", "Auge in Sprechblase", "Dialog", "reden", "sprechen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάτι σε συννεφάκι ομιλίας"),
            keywords: &[
                "μάτι",
                "μάτι σε συννεφάκι ομιλίας",
                "συννεφάκι",
                "συνομιλία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eye in speech bubble"),
            keywords: &["eye", "eye in speech bubble", "speech bubble", "witness"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ojo en bocadillo de texto"),
            keywords: &[
                "bocadillo de texto",
                "ojo",
                "ojo en bocadillo de texto",
                "testigo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("ojo en una burbuja de texto"),
            keywords: &[
                "bocadillo de texto",
                "ojo",
                "ojo en una burbuja de texto",
                "testigo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("ojo en un globo de texto"),
            keywords: &["ojo en un globo de texto"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("ojo en un globo de texto"),
            keywords: &["ojo en un globo de texto"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("silm jutumullis"),
            keywords: &[
                "dialoog",
                "jutumull",
                "silm",
                "silm jutumullis",
                "tunnistaja",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begi bat duen bunbuiloa"),
            keywords: &["begi", "begi bat duen bunbuiloa", "bunbuilo", "lekuko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چشم در حباب گفتار"),
            keywords: &[
                "حباب گفتار",
                "من شاهدم",
                "چشم در حباب گفتار",
                "کمپین منع قلدری",
                "گفتگو",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puhekuplasilmä"),
            keywords: &[
                "puhekupla",
                "puhekuplasilmä",
                "silminnäkijä",
                "silmä",
                "todistaja",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mata sa speech bubble"),
            keywords: &["mata", "mata sa speech bubble", "saksi", "speech bubble"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eyga í talubløðru"),
            keywords: &["eyga", "eyga í talubløðru", "talubløðra"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("œil dans une bulle de BD"),
            keywords: &["bulle de BD", "témoin", "œil", "œil dans une bulle de BD"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("œil dans une bulle de parole"),
            keywords: &[
                "bulle",
                "parole",
                "témoin",
                "œil",
                "œil dans une bulle de parole",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("súil i mbolgán cainte"),
            keywords: &["bolgán cainte", "finné", "súil", "súil i mbolgán cainte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sùil ann am builgean còmhraidh"),
            keywords: &[
                "builgean còmhraidh",
                "fianais",
                "sùil",
                "sùil ann am builgean còmhraidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo de diálogo en forma de ollo"),
            keywords: &[
                "globo",
                "globo de diálogo en forma de ollo",
                "ollo",
                "testemuña",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાક\u{acd}ષી"),
            keywords: &["આ\u{a82}ખ", "સાક\u{acd}ષી", "સ\u{acd}પીચ બબલ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ido a cikin kumfan magana"),
            keywords: &[
                "ido",
                "ido a cikin kumfan magana",
                "kumfan magana",
                "mai shaida",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עין בבועת דיבור"),
            keywords: &["בועת דיבור", "עד", "עין", "עין בבועת דיבור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}पीच बबल म\u{947}\u{902} आ\u{902}ख"),
            keywords: &[
                "आ\u{902}ख",
                "गवाह",
                "स\u{94d}पीच बबल",
                "स\u{94d}पीच बबल म\u{947}\u{902} आ\u{902}ख",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oko u oblačiću"),
            keywords: &["oko u oblačiću", "svjedok"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szem szövegbuborékban"),
            keywords: &[
                "párbeszéd",
                "szem",
                "szem szövegbuborékban",
                "szövegbuborék",
                "tanú",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ականատեսի նշան"),
            keywords: &["ականատես", "ականատեսի նշան", "ամպիկ", "աչք", "վկա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mata di dalam gelembung ucapan"),
            keywords: &[
                "gelembung",
                "mata",
                "mata di dalam gelembung ucapan",
                "ucapan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anya na blonblo okwu"),
            keywords: &["akaebe", "anya", "anya na blonblo okwu", "blonblo okwu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("auga í talblöðru"),
            keywords: &["auga", "auga í talblöðru", "samræða", "sjá", "talblaðra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhio nel fumetto"),
            keywords: &[
                "fumetto",
                "nuvoletta",
                "occhio",
                "occhio nel fumetto",
                "testimone",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("吹き出しの目"),
            keywords: &["吹き出し", "吹き出しの目", "目", "目撃"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mata ing njero balon omongan"),
            keywords: &[
                "balon omongan",
                "mata",
                "mata ing njero balon omongan",
                "seksi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თვალი, საუბრის ბუშტში"),
            keywords: &["თვალი", "თვალი, საუბრის ბუშტში", "მოწმე", "საუბრის ბუჭტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("куәгер белгішесі"),
            keywords: &["куәгер", "куәгер белгішесі", "көз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("øje i taleboble"),
            keywords: &["se", "taleboble", "vidne", "øje", "øje i taleboble"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}នែកក\u{17d2}ន\u{17bb}ងពព\u{17bb}ះ"),
            keywords: &[
                "ពព\u{17bb}ះពាក\u{17d2}យន\u{17b7}យាយ",
                "ភ\u{17d2}នែក",
                "ភ\u{17d2}នែកក\u{17d2}ន\u{17bb}ងពព\u{17bb}ះ",
                "សាក\u{17d2}ស\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಾತ\u{cbf}ನ ಬಬಲ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಕಣ\u{ccd}ಣು"),
            keywords: &[
                "ಕಣ\u{ccd}ಣು",
                "ನೋಡು",
                "ಮಾತ\u{cbf}ನ ಬಬಲ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಕಣ\u{ccd}ಣು",
                "ಮಾತು ಬಬಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("말풍선 속 눈"),
            keywords: &["눈", "말풍선", "말풍선 속 눈"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वाचा फ\u{941}ग\u{94d}या\u{902}त दोळो"),
            keywords: &[
                "गवाय",
                "दोळो",
                "वाचा फ\u{941}गो",
                "वाचा फ\u{941}ग\u{94d}या\u{902}त दोळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кеп көбүгүндөгү көз"),
            keywords: &["кеп көбүгү", "кеп көбүгүндөгү көз", "күбө", "көз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("A an enger Spriechblos"),
            keywords: &[
                "A",
                "A an enger Spriechblos",
                "Spriechblos",
                "erkennen",
                "gesinn",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາໃນປ\u{ec8}ອງຄຳເວ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ກ\u{ec8}ອງຄຳເວ\u{ebb}\u{ec9}າ",
                "ຕາ",
                "ຕາໃນປ\u{ec8}ອງຄຳເວ\u{ebb}\u{ec9}າ",
                "ປ\u{ec8}ອງຄຳເວ\u{ebb}\u{ec9}າ",
                "ພະຍານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akis kalbėjimo burbule"),
            keywords: &[
                "akis",
                "akis kalbėjimo burbule",
                "kalbėjimo burbulas",
                "liudjimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("liecinieka zīme"),
            keywords: &["acs", "liecinieka zīme", "liecinieks", "runas burbulis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karu rō mirumiru kōrero"),
            keywords: &[
                "kaiwhakaatu",
                "karu",
                "karu rō mirumiru kōrero",
                "mirumiru kōrero",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("око во балон за говор"),
            keywords: &["балон за говор", "око", "око во балон за говор", "сведок"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}പീച\u{d4d}ച\u{d4d} ബബിളിലെ കണ\u{d4d}ണ\u{d4d}"),
            keywords: &[
                "കണ\u{d4d}ണ\u{d4d}",
                "ബബിൾ",
                "സംഭ\u{d3e}ഷണം",
                "സ\u{d4d}പീച\u{d4d}ച\u{d4d} ബബിളിലെ കണ\u{d4d}ണ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ярианы хөөсөн доторх нүд"),
            keywords: &["гэрч", "нүд", "ярианы хөөс", "ярианы хөөсөн доторх нүд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("भाष\u{94d}याच\u{94d}या फ\u{941}ग\u{94d}यातील डोळा"),
            keywords: &[
                "डोळा",
                "भाष\u{94d}याच\u{94d}या फ\u{941}ग\u{94d}यातील डोळा",
                "भाष\u{94d}यातील फ\u{941}गा",
                "साक\u{94d}षीदार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mata dalam gelembung pertuturan"),
            keywords: &[
                "gelembung pertuturan",
                "mata",
                "mata dalam gelembung pertuturan",
                "saksi",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għajnejn f’bużżieqa tad-diskors"),
            keywords: &[
                "bużżieqa tad-diskors",
                "għajn",
                "għajnejn f’bużżieqa tad-diskors",
                "xhud",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}န\u{103e}ာလ\u{102f}\u{1036}းပ\u{102f}\u{1036}စ\u{1036} စကားပြောအက\u{103d}က\u{103a}",
            ),
            keywords: &[
                "စကားပြောအက\u{103d}က\u{103a}",
                "မျက\u{103a}န\u{103e}ာလ\u{102f}\u{1036}းပ\u{102f}\u{1036}စ\u{1036} စကားပြောအက\u{103d}က\u{103a}",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
                "သက\u{103a}သေ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øye i snakkeboble"),
            keywords: &["snakkeboble", "øye", "øye i snakkeboble"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आ\u{901}खामा वाक\u{94d}य बबल"),
            keywords: &[
                "आ\u{901}खा",
                "आ\u{901}खामा वाक\u{94d}य बबल",
                "वाक\u{94d}य बबल",
                "साक\u{94d}षी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spraakballon met oog"),
            keywords: &["getuige", "oog", "spraakballon", "spraakballon met oog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("auge i snakkeboble"),
            keywords: &["auge", "auge i snakkeboble", "snakkeboble"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଥନ ଫୋଟକ\u{b3e}ରେ ଆଖ\u{b3f}"),
            keywords: &[
                "ଆଖ\u{b3f}",
                "କଥନ ଫୋଟକ\u{b3e} ବ\u{b3e} ସ\u{b4d}ପ\u{b3f}ଚ\u{b4d}\u{200c} ବବ\u{b41}ଲ\u{b4d}\u{200c}",
                "କଥନ ଫୋଟକ\u{b3e}ରେ ଆଖ\u{b3f}",
                "ସ\u{b3e}କ\u{b4d}ଷୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਪੀਚ ਬਬਲ ਵਿ\u{a71}ਚ ਅ\u{a71}ਖ"),
            keywords: &[
                "ਅ\u{a71}ਖ",
                "ਗਵਾਹ",
                "ਸਪੀਚ ਬਬਲ",
                "ਸਪੀਚ ਬਬਲ ਵਿ\u{a71}ਚ ਅ\u{a71}ਖ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تقریری حباب وچ اکھ"),
            keywords: &["اکھ", "تقریر دا حباب", "تقریری حباب وچ اکھ", "گواہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ai Fọ Ínsaid Mẹ\u{301}séj Blonbló Píkchọ"),
            keywords: &[
                "Ai",
                "Ai Fọ Ínsaid Mẹ\u{301}séj Blonbló Píkchọ",
                "Mẹ\u{301}sej",
                "Tọk",
                "Wítnẹs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("oko w dymku"),
            keywords: &["dymek", "oko", "oko w dymku", "wzrok"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غږ پوګاڼه کې سترګه"),
            keywords: &[
                "سترګه",
                "شاهد",
                "غږ پوقاڼه",
                "غږ پوقاڼه کې سترګه",
                "غږ پوګاڼه کې سترګه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("olho no balão de diálogo"),
            keywords: &[
                "balão de diálogo",
                "olho",
                "olho no balão de diálogo",
                "testemunha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("olho em balão de fala"),
            keywords: &[
                "balão de fala",
                "olho",
                "olho em balão de fala",
                "testemunha",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñawi rimasqa phukpupi"),
            keywords: &[
                "rimasqa phukpupi",
                "testigo",
                "ñawi",
                "ñawi rimasqa phukpupi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ochi în balon de dialog"),
            keywords: &[
                "balon de dialog",
                "martor",
                "ochi",
                "ochi în balon de dialog",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1157"),
            keywords: &["E10-1157"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("значок свидетеля"),
            keywords: &[
                "глаз",
                "значок свидетеля",
                "против преследования",
                "свидетель",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ijisho riri mu kabaruni"),
            keywords: &["akabaruni", "ijisho", "ijisho riri mu kabaruni", "umuhamya"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڳالهه بلبلن ۾ اک"),
            keywords: &["اک، ڳالهه ٻولهه جا بلبلا، گوا", "ڳالهه بلبلن ۾ اک"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කථන බ\u{dd4}බ\u{dd4}ළක ත\u{dd2}බෙන ඇස"),
            keywords: &[
                "ඇස",
                "කථන බ\u{dd4}බ\u{dd4}ළ",
                "කථන බ\u{dd4}බ\u{dd4}ළක ත\u{dd2}බෙන ඇස",
                "ස\u{dcf}ක\u{dca}ෂ\u{dd2}කර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oko v bubline"),
            keywords: &["bublina", "dialóg", "oko", "oko v bubline", "reč"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oko v oblačku z govorom"),
            keywords: &[
                "dialog",
                "oblaček z govorom",
                "oko",
                "oko v oblačku z govorom",
                "priča",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("il xumbo hadal ku leh"),
            keywords: &["il", "il xumbo hadal ku leh", "marqaati", "xumbo hadal"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sy në flluskën e të folurit"),
            keywords: &[
                "dëshmitar",
                "flluskë e të folurit",
                "sy",
                "sy në flluskën e të folurit",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("око у облачићу дијалога"),
            keywords: &[
                "дијалог",
                "облачић",
                "око",
                "око у облачићу дијалога",
                "сведок",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["око у облачићу дијалога"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oko u oblačiću dijaloga"),
            keywords: &[
                "dijalog",
                "oblačić",
                "oko",
                "oko u oblačiću dijaloga",
                "svedok",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oko u oblačiću dijaloga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öga i pratbubbla"),
            keywords: &["pratbubbla", "vittne", "öga", "öga i pratbubbla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jicho ndani ya puto la usemi unaoelekea kulia"),
            keywords: &[
                "jicho ndani ya puto la usemi unaoelekea kulia",
                "kushuhudia",
                "mazungumzo",
                "usemi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பேச\u{bcd}சுவடிவக\u{bcd} குமிழியில\u{bcd} கண\u{bcd}"),
            keywords: &[
                "பேச\u{bcd}சுக\u{bcd} குமிழி, கண\u{bcd}",
                "பேச\u{bcd}சுவடிவக\u{bcd} குமிழியில\u{bcd} கண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c4d}రసంగ బుడుగల\u{c4b} కన\u{c4d}ను"),
            keywords: &[
                "కన\u{c4d}ను",
                "ప\u{c4d}రసంగ బడుగ",
                "ప\u{c4d}రసంగ బుడుగల\u{c4b} కన\u{c4d}ను",
                "స\u{c3e}క\u{c4d}ష\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чашм дар ҳуббоби гуфтугӯ"),
            keywords: &[
                "чашм",
                "чашм дар ҳуббоби гуфтугӯ",
                "шоҳид",
                "ҳуббоби гуфтугӯ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตาในล\u{e39}กโป\u{e48}งคำพ\u{e39}ด"),
            keywords: &[
                "ตา",
                "ตาในล\u{e39}กโป\u{e48}งคำพ\u{e39}ด",
                "พยาน",
                "ล\u{e39}กโป\u{e48}งคำพ\u{e39}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gepleşik şarynyň içinde göz"),
            keywords: &[
                "gepleşik şary",
                "gepleşik şarynyň içinde göz",
                "göz",
                "şaýat",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kanoʻimata ʻi ha pulalea"),
            keywords: &["kanoʻimata ʻi ha pulalea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("konuşma balonunda göz"),
            keywords: &["göz", "konuşma balonu", "konuşma balonunda göz", "tanıklık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شاردىكى كۆز"),
            keywords: &["دىيالوگ", "شاردىكى كۆز", "كۆز", "گۇۋاھچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("око в текстовій бульці"),
            keywords: &[
                "око",
                "око в текстовій бульці",
                "око в текстовій бульці, що символізує кампанію проти залякування",
                "проти переслідування",
                "свідок",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دھمکی روکنے کی مہم"),
            keywords: &["آنکھ", "دھمکی", "دھمکی روکنے کی مہم", "مہم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("nutq pufagida ko‘z"),
            keywords: &["guvoh", "ko‘z", "nutq pufagi", "nutq pufagida ko‘z"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mắt trong bong bóng lời nói"),
            keywords: &[
                "bong bóng lời nói",
                "mắt",
                "mắt trong bong bóng lời nói",
                "nhân chứng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bët ci rëddu-bind-wax"),
            keywords: &["bët", "bët ci rëddu-bind-wax", "rëddu-bind-wax", "seede"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iliso elikwiqhamza lentetho"),
            keywords: &[
                "iliso",
                "iliso elikwiqhamza lentetho",
                "ingqina",
                "iqamza lentetho",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ojú ní àlú ọ\u{300}rọ\u{300}"),
            keywords: &[
                "bàlú ọ\u{300}rọ\u{300}",
                "eyinjú",
                "ojú ní àlú ọ\u{300}rọ\u{300}",
                "ẹléri",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("眼睛泡泡"),
            keywords: &["對話泡泡", "眼", "眼睛泡泡", "見證"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("眼睛泡泡"),
            keywords: &["对话泡泡", "眼", "眼睛泡泡", "见证"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("眼睛对话框"),
            keywords: &["对话框", "眼睛", "眼睛对话框"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("眼睛對話框"),
            keywords: &["對話框", "眼睛對話框"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihlo eliyibhaluni lenkulumo"),
            keywords: &[
                "ibhaluni lenkulumo",
                "ihlo",
                "ihlo eliyibhaluni lenkulumo",
                "ufakazi",
            ],
        },
    ],
};
#[doc = "🗨\u{fe0f}"]
pub const LEFT_SPEECH_BUBBLE: crate::Emoji = crate::Emoji {
    glyph: "🗨\u{fe0f}",
    codepoint: "1F5E8 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 2f32,
    name: "left speech bubble",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗨",
        codepoint: "1F5E8",
        status: crate::Status::Unqualified,
        introduction_version: 2f32,
        name: "left speech bubble",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("spraakborrel links"),
            keywords: &["dialoog", "spraak", "spraakborrel links"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የግራ ንግግር አፉፋ"),
            keywords: &["ንግግር", "ወሬ", "የግራ ንግግር አፉፋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فقاعة كلام يسرى"),
            keywords: &["حديث", "حوار", "فقاعة كلام يسرى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ও\u{981} কথন ব\u{9c1}ৰব\u{9c1}ৰণি"),
            keywords: &[
                "কথন",
                "ব\u{9be}ও\u{981} কথন ব\u{9c1}ৰব\u{9c1}ৰণি",
                "সংল\u{9be}প",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("boş nitq şarı"),
            keywords: &["boş nitq şarı", "dialoq", "nitq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бурбалка з тэкстам злева"),
            keywords: &["бурбалка з тэкстам злева", "дыялог", "маўленне"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Балонче за говор отляво"),
            keywords: &["Балонче за говор отляво", "говор", "диалог"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কথ\u{9be} বল\u{9be}র ব\u{9be}মদিকের ব\u{9c1}দব\u{9c1}দ"),
            keywords: &[
                "কথ\u{9be} বল\u{9be}র ব\u{9be}মদিকের ব\u{9c1}দব\u{9c1}দ",
                "ড\u{9be}য\u{9bc}\u{9be}লগ",
                "বক\u{9cd}ত\u{9c3}ত\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačić razgovora okrenut nalijevo"),
            keywords: &["dijalog", "oblačić razgovora okrenut nalijevo", "razgovor"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bafarada de parlar cap a l’esquerra"),
            keywords: &[
                "bafarada",
                "bafarada de parlar cap a l’esquerra",
                "esquerra",
                "parlar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ ᎦᏬᏂᎯᏍᏗᎢ ᎤᏆᎷᏒᎢ"),
            keywords: &["ᎠᎦᏍᎦᏂ ᎦᏬᏂᎯᏍᏗᎢ ᎤᏆᎷᏒᎢ", "ᎦᏬᏂᎯᏍᏗᎢ", "ᏗᏟᏃᎮᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("levá řečová bublina"),
            keywords: &["dialog", "levá řečová bublina", "řeč"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("swigen siarad i’r chwith"),
            keywords: &["deialog", "siarad", "swigen siarad i’r chwith"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("taleboble til venstre"),
            keywords: &["dialog", "snak", "tale", "taleboble til venstre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sprechblase links"),
            keywords: &[
                "Dialog",
                "Sprechblase links",
                "Unterhaltung",
                "reden",
                "sprechen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αριστερό συννεφάκι ομιλίας"),
            keywords: &["αριστερό συννεφάκι ομιλίας", "διάλογος", "συνομιλία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("left speech bubble"),
            keywords: &["dialog", "left speech bubble", "speech"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["dialogue", "speech"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["dialogue", "left speech bubble", "speech"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bocadillo de diálogo por la izquierda"),
            keywords: &[
                "bocadillo",
                "bocadillo de diálogo por la izquierda",
                "burbuja",
                "conversación",
                "diálogo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo de diálogo izquierdo"),
            keywords: &[
                "burbuja",
                "cómic",
                "diálogo",
                "globo",
                "globo de diálogo izquierdo",
                "izquierdo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "burbuja",
                "cómics",
                "diálogo",
                "globo",
                "globo de diálogo izquierdo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["diálogo", "globo de diálogo izquierdo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jutumull suunaga vasakule"),
            keywords: &["dialoog", "jutt", "jutumull suunaga vasakule"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera doan bunbuiloa"),
            keywords: &["elkarrizketa", "ezkerrera doan bunbuiloa", "hizketa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حباب گفتار چپ"),
            keywords: &["حباب گفتار چپ", "دیالوگ", "گفتگو"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vasen puhekupla"),
            keywords: &["keskustelu", "puhe", "vasen puhekupla"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kaliwang speech bubble"),
            keywords: &[
                "balloon",
                "dialog",
                "kaliwang speech bubble",
                "komiks",
                "usapan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("svørt talubløðra"),
            keywords: &["samtala", "svørt talubløðra", "tala"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bulle de parole gauche"),
            keywords: &["bulle", "bulle de parole gauche", "dialogue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("bulle de parole à gauche"),
            keywords: &[
                "bande dessinée",
                "bulle",
                "bulle de parole à gauche",
                "dialogue",
                "parole",
                "à gauche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bolgán cainte ar chlé"),
            keywords: &[
                "bolgán cainte ar chlé",
                "bolgán cainte chlé",
                "caint",
                "comhrá",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("builgean còmhraidh dhan taobh chlì"),
            keywords: &[
                "bruidhinn",
                "builgean còmhraidh dhan taobh chlì",
                "cainnt",
                "còmhradh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo de diálogo á dereita"),
            keywords: &[
                "cómic",
                "diálogo",
                "falar",
                "globo",
                "globo de diálogo á dereita",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબ\u{ac1}\u{a82} સ\u{acd}પીચ બબલ"),
            keywords: &[
                "ડાબ\u{ac1}\u{a82} સ\u{acd}પીચ બબલ",
                "વાણી",
                "સ\u{a82}વાદ",
                "સ\u{acd}પીચ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kumfan magana na hagu"),
            keywords: &["kumfan magana na hagu", "magana", "zance"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בועת דיבור משמאל"),
            keywords: &[
                "בועה",
                "בועת דיבור משמאל",
                "דו-שיח",
                "דיאלוג",
                "דיבור",
                "ענן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाया\u{901} स\u{94d}पीच बबल"),
            keywords: &["बाया\u{901} स\u{94d}पीच बबल", "बोली", "स\u{902}वाद"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lijevi govorni oblačić"),
            keywords: &["dijalog", "govor", "lijevi govorni oblačić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra nyíló szövegbuborék"),
            keywords: &[
                "balra nyíló szövegbuborék",
                "beszéd",
                "buborék",
                "képregény",
                "párbeszéd",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոսքի ձախակողմյա ամպիկ"),
            keywords: &["երկխոսություն", "խոսք", "խոսքի ձախակողմյա ամպիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelembung ucapan kiri"),
            keywords: &["dialog", "gelembung ucapan kiri", "ucapan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("blonblo okwu akaèkpè"),
            keywords: &["blonblo okwu akaèkpè", "okwu", "ụbọbọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vinstri talblaðra"),
            keywords: &["ræða", "samræða", "vinstri talblaðra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nuvoletta nera"),
            keywords: &["dialogo", "fumetto", "nuvoletta", "nuvoletta nera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("吹き出し左"),
            keywords: &["セリフ", "会話", "吹き出し", "吹き出し左"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balon omongan sisih kiwa"),
            keywords: &["balon omongan sisih kiwa", "dhiyalog", "omongan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საუბრის მარცხენა ბუშტი"),
            keywords: &["დიალოგი", "ლაპარაკი", "საუბრის მარცხენა ბუშტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол жақ сұхбаттасу көпіршігі"),
            keywords: &["диалог", "сол жақ сұхбаттасу көпіршігі", "сұхбат"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("taleboble til venstre"),
            keywords: &["dialog", "snak", "tale", "taleboble til venstre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "រង\u{17d2}វង\u{17cb}បង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយខាងឆ\u{17d2}វេង",
            ),
            keywords: &[
                "ឆ\u{17d2}វេង",
                "ន\u{17b7}យាយ",
                "រង\u{17d2}វង\u{17cb}បង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយខាងឆ\u{17d2}វេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಡ ಧ\u{ccd}ವನ\u{cbf} ಬಬಲ\u{ccd}"),
            keywords: &["ಎಡ ಧ\u{ccd}ವನ\u{cbf} ಬಬಲ\u{ccd}", "ಮಾತು", "ಸಂವಾದ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽 말풍선"),
            keywords: &["말", "말풍선", "왼쪽 말풍선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दावो वाचा फ\u{941}गो"),
            keywords: &["दावो वाचा फ\u{941}गो", "वाचा", "स\u{902}वाद"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сол тараптагы кеп көбүгү"),
            keywords: &["диалог", "кеп", "сол тараптагы кеп көбүгү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("lénks Spriechblos"),
            keywords: &["Dialog", "lénks Spriechblos", "schwätzen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກໂປ\u{ec8}ງຄຳເວ\u{ebb}\u{ec9}າຊ\u{ec9}າຍ"),
            keywords: &[
                "ການສ\u{ebb}ນທະນາ",
                "ຄຳເວ\u{ebb}\u{ec9}າ",
                "ລ\u{eb9}ກໂປ\u{ec8}ງຄຳເວ\u{ebb}\u{ec9}າຊ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kairysis kalbos debesėlis"),
            keywords: &["dialogas", "kairysis kalbos debesėlis", "kalba"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa kreisi vērsts runas burbulis"),
            keywords: &[
                "burbulis",
                "dialogs",
                "pa kreisi vērsts runas burbulis",
                "runa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mirumiru kōrero mauī"),
            keywords: &["kōrero", "mirumiru kōrero mauī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лев балон за говор"),
            keywords: &["балон", "дијалог", "лев балон за говор", "лево", "стрип"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള സംഭ\u{d3e}ഷണ ബബിൾ"),
            keywords: &[
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള സംഭ\u{d3e}ഷണ ബബിൾ",
                "ഡയലോഗ\u{d4d}",
                "സംഭ\u{d3e}ഷണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн талын ярианы хэсэг"),
            keywords: &["зүүн", "зүүн талын ярианы хэсэг", "тал", "хэсэг", "яриа"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{902}वाद दर\u{94d}शविणारा डावा फ\u{941}गा"),
            keywords: &[
                "उच\u{94d}चार",
                "बोलण\u{947}",
                "स\u{902}वाद दर\u{94d}शविणारा डावा फ\u{941}गा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelembung pertuturan kiri"),
            keywords: &["dialog", "gelembung pertuturan kiri", "ucapan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bużżieqa tad-diskors fuq ix-xellug"),
            keywords: &["bużżieqa tad-diskors fuq ix-xellug", "diskors", "djalogu"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ဘက\u{103a} စကားပြော အက\u{103d}က\u{103a}"),
            keywords: &[
                "စကား",
                "စကားပြော",
                "ဘယ\u{103a}ဘက\u{103a} စကားပြော အက\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("snakkeboble mot venstre"),
            keywords: &["dialog", "snakkeboble mot venstre", "tale"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाया\u{901} वाक\u{94d}य बबल"),
            keywords: &["बाया\u{901} वाक\u{94d}य बबल", "वाक\u{94d}य", "सम\u{94d}वाद"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spraakballon naar links"),
            keywords: &["dialoog", "spraak", "spraakballon naar links"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("snakkeboble mot venstre"),
            keywords: &["dialog", "snakkeboble mot venstre", "tale"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ମ କଥନ ଫୋଟକ\u{b3e}"),
            keywords: &["କଥନ", "ବ\u{b3e}ମ କଥନ ଫୋଟକ\u{b3e}", "ସଂଳ\u{b3e}ପ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}ਬਾ ਬ\u{a4b}ਲੀ ਬਬਲ"),
            keywords: &[
                "ਖ\u{a71}ਬਾ ਬ\u{a4b}ਲੀ ਬਬਲ",
                "ਬ\u{a4b}ਲੀ",
                "ਵਾਰਤਾਲਾਪ",
                "ਵਿਚਾਰ-ਚਰਚਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تقریر دا کھبا حباب"),
            keywords: &["تقریر", "تقریر دا کھبا حباب", "مکالمہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lẹ\u{301}ft Hánd Saíd Mẹ\u{301}séj Blonbló Píkchọ"),
            keywords: &[
                "Lẹ\u{301}ft Hánd Saíd Mẹ\u{301}séj Blonbló Píkchọ",
                "To Tọ\u{301}k Wít Pípul",
                "Tọk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lewostronny dymek"),
            keywords: &["dialog", "dymek", "lewostronny dymek", "rozmowa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بیان چپه پوګاڼه"),
            keywords: &["بیان", "خبري", "د بیان چپه پوګاڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balão de diálogo à esquerda"),
            keywords: &["balão de diálogo", "balão de diálogo à esquerda"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("balão de fala do lado esquerdo"),
            keywords: &["balão de fala do lado esquerdo", "diálogo", "fala"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lluq’i rimasqa phukpupi"),
            keywords: &[
                "lluqʼi rimasqa phukpupi",
                "lluq’i rimasqa phukpupi",
                "rimana",
                "rimay",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balon de dialog la stânga"),
            keywords: &[
                "balon",
                "balon de dialog la stânga",
                "desen",
                "dialog",
                "stânga",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-827"),
            keywords: &["E10-827"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пустое облачко"),
            keywords: &[
                "голубое облачко",
                "облачко",
                "пустое облачко",
                "речь",
                "черное облачко",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganiro cy’akabaruni k’ibumoso"),
            keywords: &["ikiganiro", "ikiganiro cy’akabaruni k’ibumoso", "imvugo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي طرف بلبلا ڳالهه ٻولهه"),
            keywords: &["کاٻي طرف بلبلا ڳالهه ٻولهه", "ڳالهائڻ", "ڳالهه ٻولهه"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වම\u{dca} කථන බ\u{dd4}බ\u{dd4}ළ"),
            keywords: &["කථ\u{dcf}ව", "දෙබස", "වම\u{dca} කථන බ\u{dd4}බ\u{dd4}ළ"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ľavá bublina"),
            keywords: &["dialóg", "komiks", "reč", "ľavá bublina"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("levi oblaček z govorom"),
            keywords: &["dialog", "govor", "levi oblaček z govorom"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xumbo hadal bidix"),
            keywords: &["wada hadal", "xumbo hadal bidix"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flluskë e të folurit majtas"),
            keywords: &["dialog", "flluskë e të folurit majtas", "të folurit"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облачић за говор усмерен налево"),
            keywords: &["гoвoр", "диjaлoг", "облачић за говор усмерен налево"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("облачић за говор усмјерен налијево"),
            keywords: &["облачић за говор усмјерен налијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblačić za govor usmeren nalevo"),
            keywords: &["dijalog", "govor", "oblačić za govor usmeren nalevo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("oblačić za govor usmjeren nalijevo"),
            keywords: &["oblačić za govor usmjeren nalijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pratbubbla åt vänster"),
            keywords: &["pratbubbla", "pratbubbla åt vänster"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha usemi cha kushoto"),
            keywords: &["kitufe cha usemi cha kushoto", "mazungumzo", "usemi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடது புற பேச\u{bcd}சுவடிவக\u{bcd} குமிழ\u{bcd}"),
            keywords: &[
                "இடது புற பேச\u{bcd}சுவடிவக\u{bcd} குமிழ\u{bcd}",
                "பேச\u{bcd}சுவடிவக\u{bcd} குமிழ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమ డ\u{c48}ల\u{c3e}గ\u{c4d} బుడగ"),
            keywords: &[
                "ఎడమ డ\u{c48}ల\u{c3e}గ\u{c4d} బుడగ",
                "డ\u{c48}ల\u{c3e}గ\u{c4d}",
                "బుడగ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳубоби чапи гуфтугӯ"),
            keywords: &["муколама", "нутқ", "ҳубоби чапи гуфтугӯ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟองคำพ\u{e39}ด"),
            keywords: &["คำพ\u{e39}ด", "บทสนทนา", "ฟองคำพ\u{e39}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepden gepleşik şary"),
            keywords: &["gepleşik", "gürrüň", "çepden gepleşik şary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulalea ʻi hema"),
            keywords: &["pulalea ʻi hema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sol konuşma balonu"),
            keywords: &["diyalog", "konuşma", "sol konuşma balonu"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سول سۆز رامكىسى"),
            keywords: &["دىيالوگ", "سول سۆز رامكىسى", "سۆزلەش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хмаринка з текстом зліва"),
            keywords: &["діалог", "розмова", "хмаринка з текстом зліва"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گفتگو غبارہ بائیں"),
            keywords: &["بایاں", "علامت", "غبارہ", "گفتگو غبارہ بائیں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chap nutq pufakchasi"),
            keywords: &["chap nutq pufakchasi", "dialog", "nutq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bong bóng lời nói trái"),
            keywords: &["bong bóng lời nói trái", "bài diễn văn", "thoại"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bulu bind waxu càmmoñ"),
            keywords: &["bulu bind waxu càmmoñ", "jalog", "kàddu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhamza lentetho elisekhohlo"),
            keywords: &["incoko", "intetho", "iqhamza lentetho elisekhohlo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bàlúnù ọ\u{300}rọ\u{300} sísọ òsì"),
            keywords: &[
                "bàlúnù ọ\u{300}rọ\u{300} sísọ òsì",
                "ìtàkùrọ\u{300}sọ",
                "ọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("左對話泡泡"),
            keywords: &["對話", "左對話泡泡", "講野"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("左对话泡泡"),
            keywords: &["对话", "左对话泡泡", "讲野"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("朝左的话语气泡"),
            keywords: &["对话框", "朝左的话语气泡", "话语"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("黑色對話框"),
            keywords: &["對話框", "黑色對話框"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhaluni lenkulumo lakwesokunxele"),
            keywords: &["ibhaluni lenkulumo lakwesokunxele", "inkulumo"],
        },
    ],
};
#[doc = "🗯\u{fe0f}"]
pub const RIGHT_ANGER_BUBBLE: crate::Emoji = crate::Emoji {
    glyph: "🗯\u{fe0f}",
    codepoint: "1F5EF FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "right anger bubble",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗯",
        codepoint: "1F5EF",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "right anger bubble",
        group: "Smileys & Emotion",
        subgroup: "emotion",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("woedeborrel regs"),
            keywords: &["ballon", "borrel", "kwaad", "woede", "woedeborrel regs"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቀኝ የንዴት አፉፋ"),
            keywords: &["ንዴት", "አረፋ", "አፉፋ", "እብድ", "የቀኝ የንዴት አፉፋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فقاعة غضب يمنى"),
            keywords: &["بالون", "جنون", "غضب", "فقاعة", "فقاعة غضب يمنى"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সো\u{981}ফ\u{9be}লে খঙৰ ব\u{9c1}ৰব\u{9c1}ৰণি"),
            keywords: &[
                "খং",
                "প\u{9be}গল",
                "ব\u{9c1}ৰব\u{9c1}ৰণি",
                "বেল\u{9c1}ন",
                "সো\u{981}ফ\u{9be}লে খঙৰ ব\u{9c1}ৰব\u{9c1}ৰণি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sağ qəzəb şarı"),
            keywords: &["acıqlı", "hirsli", "köpük", "sağ qəzəb şarı", "şar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бурбалка з абурэннем справа"),
            keywords: &[
                "бурбалка",
                "бурбалка з абурэннем справа",
                "воблачка",
                "злы",
                "шалёны",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Балонче за гняв отдясно"),
            keywords: &["Балонче за гняв отдясно", "балонче", "гняв", "ядосан"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}নে ক\u{9cd}রোধের ব\u{9c1}দ\u{9cd}ব\u{9c1}দ"),
            keywords: &[
                "ক\u{9cd}র\u{9c1}দ\u{9cd}ধ",
                "ক\u{9cd}ষিপ\u{9cd}ত",
                "ড\u{9be}নে ক\u{9cd}রোধের ব\u{9c1}দ\u{9cd}ব\u{9c1}দ",
                "ব\u{9c1}দ\u{9cd}ব\u{9c1}দ",
                "বেল\u{9c1}ন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačić ljutitog razgovora okrenut nadesno"),
            keywords: &[
                "dijalog",
                "ljutnja",
                "oblačić",
                "oblačić ljutitog razgovora okrenut nadesno",
                "razgovor",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bafarada d’enuig cap a la dreta"),
            keywords: &[
                "bafarada",
                "bafarada d’enuig cap a la dreta",
                "dreta",
                "parlar",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ ᎤᎿᎸᎯ ᎤᏆᎷᏒᎢ"),
            keywords: &["ᎠᎦᏘᏏ ᎤᎿᎸᎯ ᎤᏆᎷᏒᎢ", "ᎤᎿᎸᎯ", "ᎤᏃᎴ ᎠᏲᏙᏗ", "ᎤᏆᎷᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pravá rozzlobená bublina"),
            keywords: &[
                "bublina",
                "hněv",
                "naštvaný",
                "pravá rozzlobená bublina",
                "vztek",
                "zloba",
                "zlost",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("swigen ddig i’r dde"),
            keywords: &["balŵn", "dig", "swigen", "swigen ddig i’r dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vred taleboble til højre"),
            keywords: &[
                "ballon",
                "boble",
                "udråb",
                "vred",
                "vred taleboble til højre",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Sprechblase für wütende Aussage rechts"),
            keywords: &[
                "Sprechblase",
                "Sprechblase für wütende Aussage rechts",
                "wütend",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δεξί συννεφάκι θυμού"),
            keywords: &[
                "δεξί συννεφάκι θυμού",
                "θυμωμένος",
                "θυμός",
                "μπαλόνι",
                "συννεφάκι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("right anger bubble"),
            keywords: &["angry", "balloon", "bubble", "mad", "right anger bubble"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bocadillo de enfado por la derecha"),
            keywords: &[
                "bocadillo",
                "bocadillo de enfado por la derecha",
                "cabreo",
                "enfado",
                "rabia",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo de enojo derecho"),
            keywords: &[
                "burbuja",
                "cómic",
                "derecho",
                "enojado",
                "enojo",
                "globo",
                "globo de enojo derecho",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "burbuja",
                "cómics",
                "derecho",
                "enojado",
                "globo",
                "globo de enojo derecho",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "burbuja",
                "enojado",
                "enojo",
                "globo",
                "globo de enojo derecho",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vihamull suunaga paremale"),
            keywords: &["mull", "tige", "vihamull suunaga paremale", "vihane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuinera doan sumindura-bunbuiloa"),
            keywords: &[
                "bunbuilo",
                "eskuinera doan sumindura-bunbuiloa",
                "haserre",
                "sumindu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("حباب خشم راست"),
            keywords: &["بالن", "جنون", "حباب", "حباب خشم راست", "دیوانه", "عصبانی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oikea vihainen puhekupla"),
            keywords: &[
                "ilmapallo",
                "kupla",
                "oikea vihainen puhekupla",
                "puhekupla",
                "vihainen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kanang anger bubble"),
            keywords: &[
                "balloon",
                "dialog",
                "galit",
                "kanang anger bubble",
                "komiks",
                "usapan",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("átalandi talubløðra"),
            keywords: &[
                "hartan",
                "skeld",
                "skelda",
                "talubløðra",
                "ábreiðsla",
                "átala",
                "átalandi talubløðra",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bulle colère droite"),
            keywords: &["bulle", "colère", "droite"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("bulle de colère à droite"),
            keywords: &[
                "bande dessinée",
                "bulle",
                "bulle de colère à droite",
                "dialogue",
                "parole",
                "à droite",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bolgán feirge ar dheis"),
            keywords: &[
                "ar buille",
                "balún",
                "bolgán",
                "bolgán feirge ar dheis",
                "bolgán feirge dheis",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("builgean feirg dhan taobh deas"),
            keywords: &[
                "bailiùn",
                "builgean",
                "builgean feirg dhan taobh deas",
                "feargach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo de diálogo enfadado"),
            keywords: &[
                "berrar",
                "cómic",
                "diálogo",
                "globo",
                "globo de diálogo enfadado",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમણી તરફન\u{ac1}\u{a82} ગ\u{ac1}સ\u{acd}સાન\u{ac1}\u{a82} બબલ"),
            keywords: &[
                "ક\u{acd}રોધ",
                "જમણી તરફન\u{ac1}\u{a82} ગ\u{ac1}સ\u{acd}સાન\u{ac1}\u{a82} બબલ",
                "પરપોટો",
                "પાગલ",
                "ફ\u{ac1}ગ\u{acd}ગો",
                "બબલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kumfan fushi na dama"),
            keywords: &[
                "balan-balan",
                "fushi",
                "haushi",
                "kumfa",
                "kumfan fushi na dama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בועת דיבור כועס מימין"),
            keywords: &[
                "בועה",
                "בועת דיבור כועס מימין",
                "דו-שיח",
                "דיאלוג",
                "דיבור",
                "כועס",
                "ענן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाया\u{901} ग\u{941}स\u{94d}स\u{947} वाला बबल"),
            keywords: &[
                "ग\u{941}ब\u{94d}बारा",
                "ग\u{941}स\u{94d}सा",
                "दाया\u{901} ग\u{941}स\u{94d}स\u{947} वाला बबल",
                "पागल",
                "बबल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("desni ljuti govorni oblačić"),
            keywords: &["bijes", "desni ljuti govorni oblačić", "ljutnja", "oblačić"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra nyíló dühös szövegbuborék"),
            keywords: &[
                "buborék",
                "dühös",
                "jobbra nyíló dühös szövegbuborék",
                "képregény",
                "mérges",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զայրույթի աջակողմյա ամպիկ"),
            keywords: &[
                "զայրույթ",
                "զայրույթի աջակողմյա ամպիկ",
                "խենթ",
                "պղպջակ",
                "փուչիկ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelembung marah kanan"),
            keywords: &["balon", "gelembung", "gelembung marah kanan", "marah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("blonblo iwe akanri"),
            keywords: &["ara", "blonblo", "blonblo iwe akanri", "blonblon", "iwe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("reiðileg hægri talblaðra"),
            keywords: &["blaðra", "bóla", "reiðileg hægri talblaðra", "reiður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nuvoletta rabbia"),
            keywords: &["dialogo", "fumetto", "nuvoletta rabbia", "rabbia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("怒りの吹き出し"),
            keywords: &["吹き出し", "怒りの吹き出し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balon nesu sisih tengen"),
            keywords: &[
                "balon",
                "balon nesu sisih tengen",
                "muring",
                "nesu",
                "plendhungan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სიბრაზის მარჯვენა ბუშტი"),
            keywords: &["ბუშტი", "გაბრაზებული", "სიბრაზის მარჯვენა ბუშტი", "შეშლილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ок жақ ашулы сұхбаттасу көпіршігі"),
            keywords: &[
                "ашулы",
                "жынданған",
                "көпіршік",
                "ок жақ ашулы сұхбаттасу көпіршігі",
                "қалқыма терезе",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vred taleboble til højre"),
            keywords: &["ballon", "boble", "mad", "vred", "vred taleboble til højre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "រង\u{17d2}វង\u{17cb}អង\u{17d2}កាញ\u{17cb}បង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយខាងស\u{17d2}តា\u{17c6}",
            ),
            keywords: &[
                "ខាងស\u{17d2}តា\u{17c6}",
                "ន\u{17b7}យាយ",
                "រង\u{17d2}វង\u{17cb}អង\u{17d2}កាញ\u{17cb}បង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយខាងស\u{17d2}តា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಲಭಾಗದ ಕೋಪದ ಬಬಲ\u{ccd}"),
            keywords: &["ಕೋಪ", "ಬಲಭಾಗದ ಕೋಪದ ಬಬಲ\u{ccd}", "ಬಲ\u{cc2}ನ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("화난 표현의 오른쪽 말풍선"),
            keywords: &["말풍선", "화난", "화난 표현의 오른쪽 말풍선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजवो रागार फ\u{941}गो"),
            keywords: &[
                "उजवो रागार फ\u{941}गो",
                "पिसो",
                "फ\u{941}गो",
                "बोमाडो",
                "रागार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оң тараптагы ачуулу кеп көбүгү"),
            keywords: &[
                "ачуулуу",
                "көбүк",
                "оң тараптагы ачуулу кеп көбүгү",
                "шарча",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("riets Rosereispriechblos"),
            keywords: &["Ball", "Blos", "béis", "riets Rosereispriechblos", "rosen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb9}ກໂປ\u{ec8}ງໃຈຮ\u{ec9}າຍຂວາ"),
            keywords: &[
                "ລ\u{eb9}ກໂປ\u{ec8}ງ",
                "ລ\u{eb9}ກໂປ\u{ec8}ງໃຈຮ\u{ec9}າຍຂວາ",
                "ໃຈຮ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dešinysis pykčio debesėlis"),
            keywords: &[
                "balionas",
                "debesėlis",
                "dešinysis pykčio debesėlis",
                "piktas",
                "įsiutęs",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa labi vērsts dusmu burbulis"),
            keywords: &[
                "burbulis",
                "dialogs",
                "dusmīgs",
                "pa labi vērsts dusmu burbulis",
                "runa",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("mirumiru riri matau"),
            keywords: &[
                "mirumiru",
                "mirumiru riri matau",
                "pōrangi",
                "pūangi",
                "riri",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("десен балон за лутина"),
            keywords: &[
                "балон",
                "десен балон за говор",
                "десен балон за лутина",
                "десно",
                "дијалог",
                "стрип",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള ദേഷ\u{d4d}യ ബല\u{d42}ൺ"),
            keywords: &[
                "കോപം",
                "ദേഷ\u{d4d}യം",
                "ബബിൾ",
                "ബല\u{d42}ൺ",
                "വലത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള ദേഷ\u{d4d}യ ബല\u{d42}ൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун талын ууртай ярианы хэсэг"),
            keywords: &[
                "баруун",
                "баруун талын ууртай ярианы хэсэг",
                "бөмбөлөг",
                "уурны хөөс",
                "ууртай",
                "уцаартай",
                "хөөс",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("राग दर\u{94d}शविणारा फ\u{941}गा"),
            keywords: &[
                "फ\u{941}गा",
                "बबल",
                "म\u{942}र\u{94d}ख",
                "राग दर\u{94d}शविणारा उजवा फ\u{941}गा",
                "राग दर\u{94d}शविणारा फ\u{941}गा",
                "रागावल\u{947}ला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelembung marah kanan"),
            keywords: &[
                "belon",
                "berang",
                "gelembung",
                "gelembung marah kanan",
                "marah",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bużżieqa ta’ rabja fuq il-lemin"),
            keywords: &[
                "buzzieqa",
                "bużżieqa",
                "bużżieqa ta’ rabja fuq il-lemin",
                "irrabjat",
                "irrabjat ħafna",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာဘက\u{103a} ဒေါသ အက\u{103d}က\u{103a}"),
            keywords: &[
                "ညာဘက\u{103a} ဒေါသ အက\u{103d}က\u{103a}",
                "ဒေါသ",
                "ပ\u{1030}စည\u{103a}ဖောင\u{103a}း",
                "ပ\u{1030}ဖောင\u{103a}း",
                "ရ\u{1030}းသ\u{103d}ပ\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("sint snakkeboble mot høyre"),
            keywords: &[
                "ballong",
                "boble",
                "sint",
                "sint snakkeboble mot høyre",
                "sur",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दाया\u{901} रिसको बबल"),
            keywords: &[
                "दाया\u{901} रिसको बबल",
                "पागल",
                "फोका",
                "ब\u{947}ल\u{941}न",
                "रिस",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boze spraakballon naar rechts"),
            keywords: &[
                "ballon",
                "boze spraakballon naar rechts",
                "kwaad",
                "woede",
                "woedeballon",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("sint snakkeboble mot høgre"),
            keywords: &[
                "ballong",
                "boble",
                "sint",
                "sint snakkeboble mot høgre",
                "sur",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଡ\u{b3e}ହ\u{b3e}ଣ କ\u{b4d}ରୋଧ ଫୋଟକ\u{b3e}"),
            keywords: &[
                "କୋଧ",
                "ଡ\u{b3e}ହ\u{b3e}ଣ କ\u{b4d}ରୋଧ ଫୋଟକ\u{b3e}",
                "ପ\u{b3e}ଗଳ",
                "ଫୋଟକ\u{b3e}",
                "ବେଲ\u{b41}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}ਜਾ ਨਰਾਜ\u{a3c}ਗੀ ਬਬਲ"),
            keywords: &[
                "ਗ\u{a41}ਬਾਰਾ",
                "ਗ\u{a41}\u{a71}ਸਾ ਹ\u{a4b}ਣਾ",
                "ਪਾਗਲ",
                "ਬਬਲ",
                "ਸ\u{a71}ਜਾ ਨਰਾਜ\u{a3c}ਗੀ ਬਬਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("غصے دا سج\u{651}ا حباب"),
            keywords: &[
                "حباب",
                "ر\u{64f}سنا",
                "غصے دا سج\u{651}ا حباب",
                "پاگل",
                "پکانہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Raít Hánd Saíd Vẹks Blonbló Píkchọ"),
            keywords: &[
                "Blonbló",
                "Bíg Vẹks",
                "Bọ\u{301}bul",
                "Raít Hánd Saíd Vẹks Blonbló Píkchọ",
                "Vẹks",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("prawostronny dymek złości"),
            keywords: &[
                "dymek",
                "prawostronny dymek złości",
                "zdenerwowany",
                "złość",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښې خوا قهر پوګاڼه"),
            keywords: &[
                "قهر",
                "لیونۍ",
                "پوګاڼه",
                "ښې خوا قهر پوګاڼه",
                "ښې خوا قهرپوګاڼه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balão de raiva à direita"),
            keywords: &[
                "balão de diálogo",
                "balão de raiva à direita",
                "discurso furioso",
                "enérgico",
                "irado",
                "raiva",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("balão de raiva do lado direito"),
            keywords: &[
                "balão",
                "balão de raiva do lado direito",
                "enfurecido",
                "irritado",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paña phiñasqa phukpu"),
            keywords: &["paña phiñasqa phukpu", "phiñasqa", "phiñay", "phukpu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balon de dialog furios la dreapta"),
            keywords: &[
                "balon",
                "balon de dialog furios la dreapta",
                "furie",
                "supărare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-828"),
            keywords: &["E10-828"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("гневное облачко"),
            keywords: &[
                "вправо",
                "гнев",
                "гневное облачко",
                "негатив",
                "облачко",
                "ярость",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akabaruni gasongoye k’iburyo"),
            keywords: &[
                "akabaruni",
                "akabaruni gasongoye k’iburyo",
                "igipirizo",
                "karakaje",
                "kirakaje",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڄي پاسي ڪاوڙ جا بلبلا"),
            keywords: &[
                "بلبلو",
                "ساڄي پاسي ڪاوڙ جا بلبلا",
                "چريو",
                "ڦوڪڻو",
                "ڪاوڙيل",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දක\u{dd4}ණ\u{dd4} තරහ බ\u{dd4}බ\u{dd4}ළ"),
            keywords: &[
                "කේන\u{dca}ත\u{dd2}\u{dd2}",
                "දක\u{dd4}ණ\u{dd4} තරහ බ\u{dd4}බ\u{dd4}ළ",
                "ප\u{dd2}ස\u{dca}ස\u{dd4}",
                "බැල\u{dd6}නය",
                "බ\u{dd4}බ\u{dd4}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hnev"),
            keywords: &["bublina", "hnev", "komiks", "zlosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("desni oblaček z jeznim govorom"),
            keywords: &[
                "balon",
                "desni oblaček z jeznim govorom",
                "divje",
                "jezno",
                "oblaček",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("xanaaqa xumbo midig"),
            keywords: &["baaluun", "waali", "xanaaq", "xanaaqa xumbo midig", "xumbo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flluskë zemërimi djathtas"),
            keywords: &[
                "balonë",
                "flluskë",
                "flluskë zemërimi djathtas",
                "i inatosur",
                "i zemëruar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облачић за љутити говор усмерен десно"),
            keywords: &[
                "oблaчић",
                "бeс",
                "облачић за љутити говор",
                "облачић за љутити говор усмерен десно",
                "љутњa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("облачић за љутити говор усмјерен десно"),
            keywords: &["облачић за љутити говор усмјерен десно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblačić za ljutiti govor usmeren desno"),
            keywords: &[
                "bes",
                "ljutnja",
                "oblačić",
                "oblačić za ljutiti govor",
                "oblačić za ljutiti govor usmeren desno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("oblačić za ljutiti govor usmjeren desno"),
            keywords: &["oblačić za ljutiti govor usmjeren desno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("arg pratbubbla åt höger"),
            keywords: &["arg", "arg pratbubbla åt höger", "pratbubbla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha usemi wa hasira cha kulia"),
            keywords: &[
                "ghadhabu",
                "hasira",
                "ishara",
                "kitufe cha usemi wa hasira cha kulia",
                "puto",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலது புற கோபக\u{bcd} குமிழ\u{bcd}"),
            keywords: &[
                "கோபக\u{bcd} குமிழ\u{bcd}",
                "வலது புற கோபக\u{bcd} குமிழ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}పంత\u{c4b} ఉన\u{c4d}న కుడ\u{c3f} బుడగ"),
            keywords: &[
                "క\u{c4b}పం",
                "క\u{c4b}పంత\u{c4b} ఉన\u{c4d}న కుడ\u{c3f} బుడగ",
                "బుడగ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳубоби рости ғазаб"),
            keywords: &["балон", "девона", "хашмгин", "ҳубоб", "ҳубоби рости ғазаб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟองคำพ\u{e39}ดร\u{e38}นแรง"),
            keywords: &[
                "ฟองคำพ\u{e39}ด",
                "ฟองคำพ\u{e39}ดร\u{e38}นแรง",
                "ล\u{e39}กโป\u{e48}ง",
                "โกรธ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sagdan gahar şary"),
            keywords: &["gahar", "gazaply", "köpük", "sagdan gahar şary", "şar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulalea ʻita"),
            keywords: &["pulalea ʻita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağ öfke balonu"),
            keywords: &["balon", "kızgın", "sağ öfke balonu", "öfke"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوڭ خاپىلىق كۆپۈكچىسى"),
            keywords: &["ئوڭ خاپىلىق كۆپۈكچىسى", "خاپا", "ساراڭ", "شار", "كۆپۈك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("булька із сердитою реплікою"),
            keywords: &[
                "булька із сердитою реплікою",
                "злий",
                "розлючений",
                "хмаринка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("غصہ غبارہ دائیں"),
            keywords: &["دایاں", "علامت", "غبارہ", "غصہ غبارہ دائیں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ng burchakli pufakcha"),
            keywords: &["hafa", "jaxl", "o‘ng burchakli pufakcha", "po‘fak", "shar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bong bóng góc phải"),
            keywords: &[
                "bong bóng",
                "bong bóng góc phải",
                "khí cầu",
                "tức giận",
                "điên",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndijoor mer bul"),
            keywords: &["bul", "dof", "mer", "mànq", "ndijoor mer bul"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iqhamza lomsindo elisekunene"),
            keywords: &[
                "ibhaluni",
                "iqamza",
                "iqhamza lomsindo elisekunene",
                "ukucaphuka",
                "umsindo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("bàlúnù ọ\u{300}rọ\u{300} sísọ ọ\u{300}tún"),
            keywords: &[
                "bàlúnù",
                "bàlúnù ọ\u{300}rọ\u{300} sísọ ọ\u{300}tún",
                "bínú",
                "àdàlú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("右邊嬲泡泡"),
            keywords: &["右邊嬲泡泡", "嬲", "氣球", "泡泡", "發癲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("右边嬲泡泡"),
            keywords: &["发癫", "右边嬲泡泡", "嬲", "气球", "泡泡"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("愤怒话语气泡"),
            keywords: &["对话框", "愤怒", "愤怒话语气泡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("爆炸對話框"),
            keywords: &["對話框", "爆炸對話框"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhaluni lenkulumo lakwesokudla lolaka"),
            keywords: &[
                "ibhaluni",
                "ibhaluni lenkulumo lakwesokudla lolaka",
                "ukucasuka",
                "ulaka",
            ],
        },
    ],
};
#[doc = "💭"]
pub const THOUGHT_BALLOON: crate::Emoji = crate::Emoji {
    glyph: "💭",
    codepoint: "1F4AD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thought balloon",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dinkballon"),
            keywords: &["ballon", "borrel", "dink", "dinkballon", "strokie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሐሳብ ገላጭ አፉፋ"),
            keywords: &["ሐሳብ", "ሐሳብ ገላጭ አፉፋ", "አረፋ", "አስቂኝ", "አፉፋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فقاعة أفكار"),
            keywords: &["بالونة", "فقاعة أفكار", "فكرة", "هزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চিন\u{9cd}ত\u{9be}ৰ বেল\u{9c1}ন"),
            keywords: &[
                "কমিক",
                "চিন\u{9cd}ত\u{9be}",
                "চিন\u{9cd}ত\u{9be}ৰ বেল\u{9c1}ন",
                "ব\u{9c1}ৰব\u{9c1}ৰণি",
                "বেল\u{9c1}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("düşüncə şarı"),
            keywords: &["düşüncə", "düşüncə şarı", "komik", "köpük", "şar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("воблачка з думкамі"),
            keywords: &[
                "бурбалка",
                "воблачка",
                "воблачка з думкамі",
                "думкі",
                "камічны",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Балонче за мисъл"),
            keywords: &["Балонче за мисъл", "балонче", "комикс", "мисъл"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("থট বেল\u{9c1}ন"),
            keywords: &[
                "কমিক",
                "থট বেল\u{9c1}ন",
                "ব\u{9c1}দ\u{9cd}ব\u{9c1}দ",
                "বেল\u{9c1}ন",
                "ভ\u{9be}বন\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oblačić razmišljanja"),
            keywords: &[
                "dijalog",
                "oblačić",
                "oblačić razmišljanja",
                "razmišljanje",
                "stripovi",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bafarada de pensar"),
            keywords: &["bafarada", "bafarada de pensar", "pensar"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᎾᏖᎸᏍᎩ ᎤᏃᎴ ᎠᏦᏔᏍᏙᏗ"),
            keywords: &["ᎠᏓᎾᏖᎸᏍᎩ ᎤᏃᎴ ᎠᏦᏔᏍᏙᏗ", "ᎠᏓᏅᏖᏢᎢ", "ᎤᏃᎴ ᎠᏲᏙᏗ", "ᎤᏆᎷᏒᎢ", "ᎤᏬᏟᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("myšlenková bublina"),
            keywords: &["bublina", "komiks", "myšlenka", "myšlenková bublina"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cwmwl meddwl"),
            keywords: &["balŵn", "comig", "cwmwl meddwl", "swigen"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tankeboble"),
            keywords: &["tanke", "tankeboble"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gedankenblase"),
            keywords: &["Comic", "Gedankenblase", "Nachdenken"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συννεφάκι σκέψης"),
            keywords: &["κόμικ", "μπαλόνι", "σκέψη", "συννεφάκι", "συννεφάκι σκέψης"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thought balloon"),
            keywords: &["balloon", "bubble", "comic", "thought"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("thought bubble"),
            keywords: &[""],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bocadillo de pensamiento"),
            keywords: &[
                "bocadillo",
                "bocadillo de pensamiento",
                "burbuja",
                "cómic",
                "pensamiento",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("globo de pensamiento"),
            keywords: &[
                "burbuja",
                "cómic",
                "globo",
                "globo de pensamiento",
                "pensamiento",
                "pensar",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "burbuja",
                "cómics",
                "globo",
                "globo de pensamiento",
                "pensamiento",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "burbuja",
                "comic",
                "globo",
                "globo de pensamiento",
                "pensamiento",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mõttemull"),
            keywords: &["koomiks", "mull", "mõte", "mõttemull"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burutazio-bunbuiloa"),
            keywords: &[
                "bunbuilo",
                "burutazio",
                "burutazio-bunbuiloa",
                "komiki",
                "pentsamendu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بالن افکار"),
            keywords: &["بالن", "بالن افکار", "حباب", "فکر", "مصور", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ajatuskupla"),
            keywords: &["ajatus", "ajatuskupla", "ilmapallo", "kupla", "sarjakuva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("thought balloon"),
            keywords: &[
                "balloon",
                "bubble",
                "komiks",
                "nag-iisip",
                "thought balloon",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tankabløðra"),
            keywords: &["hugskot", "tankabløðra", "tanki", "umsorgan"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bulle de pensée"),
            keywords: &["bulle", "bulle de pensée", "pensée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bande dessinée", "bulle", "bulle de pensée", "pensée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bolgán smaointe"),
            keywords: &["bolgán", "bolgán smaointe", "smaoineamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("builgean smaoineachaidh"),
            keywords: &[
                "bailiùn",
                "builgean",
                "builgean smaoineachaidh",
                "dealbh-èibhinn",
                "smaoineachadh",
                "smaointinn",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("globo de pensamento"),
            keywords: &["cómic", "globo", "globo de pensamento", "pensamento"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિચારનો ફ\u{ac1}ગ\u{acd}ગો"),
            keywords: &[
                "પરપોટો",
                "રમ\u{ac2}જી",
                "વિચાર",
                "વિચારનો પરપોટો",
                "વિચારનો ફ\u{ac1}ગ\u{acd}ગો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("balan-balan tunani"),
            keywords: &["balan-balan", "kumfa", "mai ban dariya", "tunani"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בועת מחשבה"),
            keywords: &["בועה", "בועת מחשבה", "מחשבה", "רעיון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विचार ब\u{941}लब\u{941}ला"),
            keywords: &[
                "कॉमिक",
                "ब\u{941}लब\u{941}ला",
                "विचार",
                "विचार ग\u{941}ब\u{94d}बारा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oblačić za misao"),
            keywords: &["misao", "oblačić", "oblačić za misao", "strip"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gondolatbuborék"),
            keywords: &["buborék", "gondolat", "gondolatbuborék", "képregény"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մտքի ամպիկ"),
            keywords: &["կոմիքս", "միտք", "մտքի ամպիկ", "պղպջակ", "փուչիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gelembung pikiran"),
            keywords: &[
                "balon",
                "gelembung",
                "gelembung pikiran",
                "komik",
                "mikir",
                "pikir",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("blonblon echichè"),
            keywords: &["blonblo", "blonblon", "echichè", "mkpaọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hugsanablaðra"),
            keywords: &["blaðra", "hugsa", "hugsanablaðra", "skrípó"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("nuvoletta"),
            keywords: &["fumetto", "nuvoletta"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("雲形の吹き出し"),
            keywords: &["もくもく", "吹き出し", "考え事", "雲形の吹き出し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balon pikiran"),
            keywords: &["balon", "komik", "pikiran", "plendhungan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფიქრის ბუშტი"),
            keywords: &["აზრი", "ბუშტი", "სასაცილო", "ფიქრის ბუშტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ой көпіршігі"),
            keywords: &["көпіршік", "ой", "ой көпіршігі", "қалқыма терезе"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tankeboble"),
            keywords: &["tanke", "tankeboble"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពពកបង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងគ\u{17b7}ត"),
            keywords: &[
                "គ\u{17b7}ត",
                "ន\u{17b7}យាយ",
                "ពពក",
                "ពពកបង\u{17d2}ហាញពាក\u{17d2}យក\u{17c6}ព\u{17bb}ងគ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆಲೋಚನ\u{cc6} ಬಲ\u{cc2}ನ\u{ccd}"),
            keywords: &[
                "ಆಲೋಚನ\u{cc6} ಬಲ\u{cc2}ನ\u{ccd}",
                "ಚ\u{cbf}ಂತನ\u{cc6}ಯ ಬಬಲ\u{ccd}",
                "ಚ\u{cbf}ಂತನ\u{cc6}ಯ ಬಲ\u{cc2}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("생각 풍선"),
            keywords: &["생각", "생각 풍선"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विचारी बोमाडो"),
            keywords: &["फ\u{941}गो", "बोमाडो", "विचार", "विचारी बोमाडो", "विनोदी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ойлонуу көбүгү"),
            keywords: &["комикс", "көбүк", "ой", "ойлонуу көбүгү", "шарча"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Denkblos"),
            keywords: &["Ball", "Blos", "Comic", "Denkblos", "Gedanken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປ\u{eb9}ມເປ\u{ebb}\u{ec9}າຄວາມຄ\u{eb4}ດ"),
            keywords: &[
                "ຄວາມຄ\u{eb4}ດ",
                "ປ\u{eb9}ມເປ\u{ebb}\u{ec9}າ",
                "ປ\u{eb9}ມເປ\u{ebb}\u{ec9}າຄວາມຄ\u{eb4}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("minties debesėlis"),
            keywords: &[
                "balionas",
                "debesėlis",
                "komiksas",
                "minties debesėlis",
                "mintis",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("domu burbulis"),
            keywords: &["burbulis", "domas", "domu burbulis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pūangi whakaaro"),
            keywords: &["mirumiru", "pūangi", "whakaaro", "whakakata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("балон за размислување"),
            keywords: &[
                "балон",
                "балон за размислување",
                "меур",
                "размислување",
                "стрип",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചിന\u{d4d}ത\u{d3e} ബല\u{d42}ൺ"),
            keywords: &[
                "ക\u{d41}മിള",
                "കോമിക\u{d4d}ക\u{d4d}",
                "ചിന\u{d4d}ത",
                "ചിന\u{d4d}ത\u{d3e} ബല\u{d42}ൺ",
                "ബല\u{d42}ൺ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бодож байгаа бөмбөлөг"),
            keywords: &["бодож байгаа бөмбөлөг", "бодох", "бөмбөлөг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विचार दर\u{94d}शविणारा फ\u{941}गा"),
            keywords: &[
                "कॉमिक",
                "फ\u{941}गा",
                "बबल",
                "विचार",
                "विचार दर\u{94d}शविणारा फ\u{941}गा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gelembung fikir"),
            keywords: &["belon", "fikir", "gelembung", "komik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bużżieqa tal-ħsibijiet"),
            keywords: &[
                "bużżieqa",
                "bużżieqa tal-ħsibijiet",
                "djalogu",
                "komiku",
                "taħdit",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အတ\u{103d}ေး ပ\u{1030}ဖောင\u{103a}းအက\u{103d}က\u{103a}"),
            keywords: &[
                "ပ\u{1030}စည\u{103a}ဖောင\u{103a}း",
                "ပ\u{1030}ဖောင\u{103a}း",
                "ဟာသ",
                "အတ\u{103d}ေး",
                "အတ\u{103d}ေး ပ\u{1030}ဖောင\u{103a}းအက\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tankeboble"),
            keywords: &["boble", "tanke", "tankeboble", "tegneserie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सोच ब\u{947}ल\u{941}न"),
            keywords: &[
                "फोका",
                "ब\u{947}ल\u{941}न",
                "विचार",
                "सोच ब\u{947}ल\u{941}न",
                "ह\u{901}साउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gedachteballon"),
            keywords: &[
                "ballon",
                "denkwolkje",
                "gedachteballon",
                "gedachten",
                "strip",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tankeboble"),
            keywords: &["boble", "tanke", "tankeboble", "teikneserie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b4d}ରଗ\u{b3e}ଢ\u{b3c} ଚ\u{b3f}ନ\u{b4d}ତ\u{b3e} ବେଲ\u{b41}ନ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "କମ\u{b3f}କ\u{b4d}",
                "ପ\u{b4d}ରଗ\u{b3e}ଢ\u{b3c} ଚ\u{b3f}ନ\u{b4d}ତ\u{b3e} ବେଲ\u{b41}ନ\u{b4d}\u{200c}",
                "ବବଲ\u{b4d}",
                "ଭ\u{b3e}ବନ\u{b3e}",
                "ଭ\u{b3e}ବନ\u{b3e} ବେଲ\u{b41}ନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਿਚਾਰ ਬਬਲ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਬ\u{a41}ਲਬ\u{a41}ਲਾ",
                "ਵਿਚਾਰ",
                "ਵਿਚਾਰ ਗ\u{a41}ਬਾਰਾ",
                "ਵਿਚਾਰ ਬਬਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خیالی بھکانہ"),
            keywords: &[
                "حباب",
                "خیال",
                "خیالی بھکانہ",
                "م\u{64f}ضح\u{650}کہ خیز",
                "پکانہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Blonbló Píkchọ Abaut Tínkin"),
            keywords: &[
                "Blonbló",
                "Blonbló Píkchọ Abaut Tínkin",
                "Bọ\u{301}bul",
                "Jok",
                "Plè",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "Tink",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dymek myśli"),
            keywords: &["dymek myśli", "myśl", "myśleć"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خبرو پوقانه"),
            keywords: &["د خبرو پوقانه", "فکر", "مسخره l", "پوګاڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("balão de pensamento"),
            keywords: &["balão", "balão de pensamento", "engraçado", "pensamento"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["balão", "balão de pensamento", "desenho", "pensamento"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuyaypa glubun"),
            keywords: &[
                "glubu",
                "kusi",
                "phukpu",
                "rimana",
                "rimasqa",
                "yuyaypa glubun",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("balon de gândire"),
            keywords: &["balon", "balon de gândire", "bandă desenată", "gând"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-618"),
            keywords: &["E10-618"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("облачко с мыслями"),
            keywords: &[
                "мысли",
                "облако",
                "облачко",
                "облачко с мыслями",
                "размышления",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akazu kagaragaza gutekereza"),
            keywords: &[
                "akabaruni",
                "akazu kagaragaza gutekereza",
                "gisekeje",
                "igitekerezo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خيال وارو ڦوڪڻو"),
            keywords: &["بلبلا", "خيال وارو ڦوڪڻو", "سوچ", "مزاحيه", "ڦوڪڻو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ත\u{dd4}ව\u{dd2}ල\u{dd2} බැල\u{dd6}නය"),
            keywords: &[
                "බැල\u{dd6}\u{dd6}නය",
                "බ\u{dd4}බ\u{dd4}ල",
                "ස\u{dd2}ත\u{dd4}ව\u{dd2}ල\u{dd2}",
                "ස\u{dd2}ත\u{dd4}ව\u{dd2}ල\u{dd2} බැල\u{dd4}නය",
                "ස\u{dd2}ත\u{dd4}ව\u{dd2}ල\u{dd2} බැල\u{dd6}නය",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("myšlienka"),
            keywords: &["bublina", "komiks", "myšlienka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oblaček z mislimi"),
            keywords: &["balon", "misel", "oblaček", "oblaček z mislimi", "strip"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("baalluunta fakarka"),
            keywords: &[
                "baalluunta fakarka",
                "baaxumbo",
                "fakarka",
                "lbaaluun",
                "majaajileeye",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("flluskë mendimi"),
            keywords: &[
                "balonë",
                "flluskë",
                "flluskë mendimi",
                "mendim",
                "vizatim komik",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("облачић за мисли"),
            keywords: &["oблaчић", "мисao", "облачић за мисли", "стрип"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["облачић за мисли"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oblačić za misli"),
            keywords: &["misao", "oblačić", "oblačić za misli", "strip"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oblačić za misli"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tankebubbla"),
            keywords: &["bubbla", "funderar", "tankebubbla"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kitufe cha mawazo"),
            keywords: &["ishara", "kibonzo", "kitufe cha mawazo", "puto", "wazo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிந\u{bcd}தனை பலூன\u{bcd}"),
            keywords: &[
                "குமிழ\u{bcd}",
                "சிந\u{bcd}தனை",
                "சிந\u{bcd}தனை பலூன\u{bcd}",
                "நகைச\u{bcd}சுவை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆల\u{c4b}చన బుడగ"),
            keywords: &["ఆల\u{c4b}చన", "బుడగ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳубоби андеша"),
            keywords: &["балон", "мазҳакавӣ", "фикр", "ҳубоб", "ҳубоби андеша"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e39}กโป\u{e48}งความค\u{e34}ด"),
            keywords: &[
                "ความค\u{e34}ด",
                "ล\u{e39}กโป\u{e48}ง",
                "ล\u{e39}กโป\u{e48}งความค\u{e34}ด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("pikir şary"),
            keywords: &["gülkünç", "köpük", "pikir", "pikir şary", "şar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pulalea fakakaukau"),
            keywords: &["pulalea fakakaukau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("düşünce balonu"),
            keywords: &["balon", "düşünce", "düşünce balonu", "çizgi roman"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوي شارچىسى"),
            keywords: &["ئوي شارچىسى", "ئويلاش", "شار", "كۆپۈك", "كۈلكىلىك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("булька роздумів"),
            keywords: &["булька роздумів", "думка", "комікси", "хмаринка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سوچ غبارہ"),
            keywords: &["سوچ", "علامت", "غبارہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘y-hayol buluti"),
            keywords: &["latifa", "o‘y-hayol", "o‘y-hayol buluti", "pufak", "shar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bong bóng suy nghĩ"),
            keywords: &[
                "bong bóng",
                "bong bóng suy nghĩ",
                "hài hước",
                "khí cầu",
                "nghĩ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("rëddu bind xalaat"),
            keywords: &["bul", "mànq", "reelu", "rëddu bind xalaat", "xalaat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhaluni yokucinga"),
            keywords: &[
                "hlekisa",
                "ibhaluni",
                "ibhaluni yokucinga",
                "ingcinga",
                "iqamza",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bàlúnù Ero"),
            keywords: &["Bàlúnù Ero", "bàlúnù", "àdàlú", "àwàdà", "èrò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("諗野氣球"),
            keywords: &["搞笑", "氣球", "泡泡", "諗野", "諗野氣球"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("谂野气球"),
            keywords: &["搞笑", "气球", "泡泡", "谂野", "谂野气球"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("内心活动气泡"),
            keywords: &["内心活动气泡", "对话框", "思想活动", "气泡"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心聲對話框"),
            keywords: &["對話框", "心聲對話框"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ibhaluni lokucabanga"),
            keywords: &["ibhaluni", "ibhaluni lokucabanga", "opopayi", "umcabango"],
        },
    ],
};
#[doc = "💤"]
pub const ZZZ: crate::Emoji = crate::Emoji {
    glyph: "💤",
    codepoint: "1F4A4",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "zzz",
    group: "Smileys & Emotion",
    subgroup: "emotion",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("zzz"),
            keywords: &["slaap", "strokie", "zzz"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዝ ዝ ዝ"),
            keywords: &["አስቂኝ", "እንቅልፍ", "ዝ ዝ ዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("نعسان"),
            keywords: &["شخير", "مشاعر", "نعسان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নিদ\u{9cd}ৰ\u{9be}ল\u{9c1}"),
            keywords: &["কমিক", "নিদ\u{9cd}ৰ\u{9be}", "নিদ\u{9cd}ৰ\u{9be}ল\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zzz"),
            keywords: &["komik", "yatmaq", "zzz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сон"),
            keywords: &["камічны", "сон", "храп"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("спане"),
            keywords: &["комикс", "спане"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9c1}ম প\u{9be}চ\u{9cd}ছে"),
            keywords: &[
                "কমিক",
                "ঘ\u{9c1}ম প\u{9be}চ\u{9cd}ছে",
                "ঘ\u{9c1}মন\u{9cd}ত অবস\u{9cd}থ\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("zzz"),
            keywords: &["kousket", "zzz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zzz"),
            keywords: &["spavanje", "stripovi", "zzz"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("zzz"),
            keywords: &["còmic", "son", "zzz"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏃᏃᏃ"),
            keywords: &["ᎤᏬᏟᏗ", "ᎦᏟ", "ᏃᏃᏃ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zzz"),
            keywords: &["chrr", "komiks", "spánek", "spát", "zzz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("zzz"),
            keywords: &["comig", "cysgu", "zzz"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("søvnig"),
            keywords: &["følelse", "snorke", "sove", "søvnig"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Schlafen"),
            keywords: &["Comic", "Schlaf", "Schlafen", "Schnarchen", "ZZZ"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζζζ"),
            keywords: &["ζζζ", "κόμικ", "ύπνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("zzz"),
            keywords: &["comic", "sleep", "zzz"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["comic", "sleep", "sleeping", "sleepy", "zzz"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("símbolo de sueño"),
            keywords: &["cómic", "dormir", "sueño", "símbolo de sueño", "zzz"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cómics",
                "dormido",
                "emoción",
                "estar durmiendo",
                "roncar",
                "símbolo de sueño",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("símbolo de sueño"),
            keywords: &[
                "cómics",
                "emoción",
                "estar durmiendo",
                "roncar",
                "símbolo de sueño",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("símbolo de sueño"),
            keywords: &["comic", "dormir", "sueño", "símbolo de sueño", "zzz"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("zzz"),
            keywords: &["koomiks", "uni", "zzz"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zzz"),
            keywords: &["komiki", "lo", "zzz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خروپف"),
            keywords: &["خروپف", "خواب", "مصور", "کمیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("zzz"),
            keywords: &["sarjakuva", "uni", "zzz"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("zzz"),
            keywords: &["inaantok", "komiks", "natutulog", "tulog", "zzz"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("zzz"),
            keywords: &["snorkar", "svevur", "zzz"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("endormi"),
            keywords: &["dormir", "endormi", "ronfler"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["dormir", "endormi", "ronfler", "zzz"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("codladh"),
            keywords: &["codladh", "srannadh", "tuirseach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("suain"),
            keywords: &["cadal", "dealbh-èibhinn", "suain", "zzz"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("símbolo de estar durmindo"),
            keywords: &[
                "cómic",
                "durmir",
                "sono",
                "símbolo de estar durmindo",
                "zzz",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નસકોરા"),
            keywords: &[
                "ઊ\u{a82}ઘત\u{ac1}\u{a82}",
                "ઊ\u{a82}ઘર\u{ac7}ટી",
                "નસકોરા",
                "રમ\u{ac2}જી",
                "લાગણી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("zzz"),
            keywords: &["barci", "mai ban dariya", "zzz"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סימן נחירה"),
            keywords: &["נוחר", "נחירה", "נחירות", "סימן נחירה", "שינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उनी\u{902}दा"),
            keywords: &[
                "Zzz",
                "उनी\u{902}दा",
                "कॉमिक",
                "खर\u{94d}राट\u{947} भरना",
                "भावना",
                "सोना",
            ],
        },
       