#[doc = "🗣\u{fe0f}"]
pub const SPEAKING_HEAD: crate::Emoji = crate::Emoji {
    glyph: "🗣\u{fe0f}",
    codepoint: "1F5E3 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "speaking head",
    group: "People & Body",
    subgroup: "person-symbol",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🗣",
        codepoint: "1F5E3",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "speaking head",
        group: "People & Body",
        subgroup: "person-symbol",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kop wat praat"),
            keywords: &["gesig", "kop", "kop wat praat", "praat", "silhoeët"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እየተናገረ ያለ ራስ"),
            keywords: &["መናገር", "ራስ", "ባለ አንድ ቀለም ምስል", "እየተናገረ ያለ ራስ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رأس تتحدث"),
            keywords: &["تحدث", "رأس", "رأس تتحدث", "نطق", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কথ\u{9be} কোৱ\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "কথ\u{9be} কোৱ\u{9be}",
                "কথ\u{9be} কোৱ\u{9be} ম\u{9c1}খ",
                "চিলহ\u{9c1}ট",
                "ম\u{9c1}খ",
                "ম\u{9c1}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("danışan baş"),
            keywords: &["baş", "danışan", "danışmaq", "siluet", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("гаворачая галава"),
            keywords: &["гаворачая галава", "гаворачы", "галава", "сілуэт", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Говореща глава"),
            keywords: &["Говореща глава", "глава", "говореща", "лице", "силует"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("কথ\u{9be} বল\u{9be} ম\u{9c1}খ"),
            keywords: &[
                "কথ\u{9be} বল\u{9be}",
                "কথ\u{9be} বল\u{9be} ম\u{9c1}খ",
                "কথ\u{9be}রত",
                "ছ\u{9be}য\u{9bc}\u{9be}",
                "ম\u{9c1}খ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("silueta glave koja govori"),
            keywords: &["govor", "silueta", "silueta glave koja govori"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona que parla"),
            keywords: &[
                "parlar",
                "persona",
                "persona que parla",
                "silueta que parla",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏁᎩ ᎠᏍᎪᎵ"),
            keywords: &["ᎠᏍᎪᎵ", "ᎤᎧᏛ", "ᎤᏙᏢᏒᎢ", "ᎧᏁᎦ", "ᎧᏁᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mluvící hlava"),
            keywords: &[
                "hlava",
                "mluvit",
                "mluvící hlava",
                "silueta",
                "smajlík",
                "tvář",
                "výraz",
                "řeč",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pen yn siarad"),
            keywords: &["pen", "pen yn siarad", "siarad", "silwét", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("talende hoved"),
            keywords: &["ansigt", "hoved", "silhuet", "tale", "talende"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sprechender Kopf"),
            keywords: &[
                "Gesicht",
                "Kopf",
                "Silhouette",
                "sprechen",
                "sprechend",
                "sprechender Kopf",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κεφάλι που μιλάει"),
            keywords: &[
                "κεφάλι",
                "κεφάλι που μιλάει",
                "μιλώ",
                "ομιλία",
                "πρόσωπο",
                "φιγούρα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("speaking head"),
            keywords: &["face", "head", "silhouette", "speak", "speaking"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "face",
                "head",
                "silhouette",
                "speak",
                "speaking",
                "talk",
                "talking",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cabeza parlante"),
            keywords: &["cabeza", "cabeza parlante", "cara", "hablar", "silueta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("silueta hablando"),
            keywords: &["cabeza", "cara", "hablar", "silueta", "silueta hablando"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõnelev pea"),
            keywords: &["kõnelev pea", "nägu", "pea", "rääkimine", "siluett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aurrera hitz egiten ari den burua"),
            keywords: &[
                "aurpegi",
                "aurrera hitz egiten ari den burua",
                "buru",
                "hitz egin",
                "hizketan ari den burua",
                "silueta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درحال صحبت کردن"),
            keywords: &[
                "درحال صحبت کردن",
                "سایه\u{200c}نما",
                "سر",
                "صحبت",
                "صحبت کردن",
                "صورت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("puhuva pää"),
            keywords: &[
                "naama",
                "puhu",
                "puhuminen",
                "puhuva pää",
                "pää",
                "siluetti",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ulong nagsasalita"),
            keywords: &["nagsasalita", "silhouette", "ulo", "ulong nagsasalita"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("høvd sum prátar"),
            keywords: &[
                "høvd",
                "høvd sum prátar",
                "prát",
                "prátar",
                "skuggamynd",
                "tosar",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("tête qui parle"),
            keywords: &["parler", "silhouette", "tête qui parle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["parler", "parole", "silhouette", "tête qui parle", "visage"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ceann ag caint"),
            keywords: &[
                "ag caint",
                "aghaidh",
                "caint",
                "ceann",
                "ceann ag caint",
                "scáthphictiúr",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ceann a’ bruidhinn"),
            keywords: &[
                "aodann",
                "ceann",
                "ceann a’ bruidhinn",
                "sgàil-dhealbh bruidhinn",
                "sgàil-riochd",
                "silhouette",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("silueta de persoa falando"),
            keywords: &[
                "cabeza",
                "cara",
                "falar",
                "silueta",
                "silueta de persoa falando",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બોલતો ચહ\u{ac7}રો"),
            keywords: &[
                "પાર\u{acd}શ\u{acd}વ ચિત\u{acd}ર",
                "બોલતો ચહ\u{ac7}રો",
                "બોલવ\u{ac1}\u{a82}",
                "બોલો",
                "માથ\u{ac1}\u{a82}",
                "મ\u{ac1}ખ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kai mai yin magana"),
            keywords: &[
                "daga kai",
                "fuska",
                "kai",
                "kai mai yin magana",
                "magana",
                "yin magana",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צללית ראש מדבר"),
            keywords: &["מדבר", "פרצוף", "צללית", "ראש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बोलता च\u{947}हरा"),
            keywords: &["च\u{947}हर\u{947} का आकार", "बोलता च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("glava koja govori"),
            keywords: &["glava", "glava koja govori", "govor", "lice", "silueta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("beszélő fej"),
            keywords: &["arc", "beszéd", "beszélő fej", "fej", "sziluett"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոսացող գլուխ"),
            keywords: &["գլուխ", "դեմք", "խոսալ", "խոսացող", "ուրվագիծ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kepala berbicara"),
            keywords: &["berbicara", "bicara", "kepala", "siluet", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("isi na-ekwu okwu"),
            keywords: &[
                "ihu",
                "isi",
                "isi na-ekwu okwu",
                "kwuo",
                "na-ekwu okwu",
                "silhouette",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("talandi höfuð"),
            keywords: &["andlit", "höfuð", "skuggamynd", "tala", "talandi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che parla"),
            keywords: &["parlare", "persona", "persona che parla", "profilo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("話す人のシルエット"),
            keywords: &["シルエット", "話す", "話す人のシルエット", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sirah omong"),
            keywords: &["bayangan", "omong", "rai", "sirah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოლაპარაკე თავი"),
            keywords: &["თავი", "ლაპარაკი", "მოლაპარაკე თავი", "სახე", "სილუეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сөйлеу"),
            keywords: &["бас", "бет", "сұлба", "сөйлеп жатыр", "сөйлеу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("talende hoved"),
            keywords: &["ansigt", "hoved", "silhuet", "tale", "talende"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយ"),
            keywords: &[
                "ក\u{17c6}ព\u{17bb}ងន\u{17b7}យាយ",
                "ក\u{17d2}បាល",
                "ន\u{17b7}យាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಾತನಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ತಲ\u{cc6}"),
            keywords: &[
                "ಮಾತನಾಡು",
                "ಮಾತನಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ತಲ\u{cc6}",
                "ಮಾತನಾಡುವ ಸ\u{cc2}ಚಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("말하고 있는 옆얼굴"),
            keywords: &["말하고 있는 옆얼굴", "말함", "실루엣", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उलोवपी तकली"),
            keywords: &[
                "उलयता",
                "उलोवच\u{947}\u{902}",
                "उलोवपी तकली",
                "काळी आक\u{943}ती",
                "च\u{947}रो",
                "तकली",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сүйлөп жаткан баш"),
            keywords: &["баш", "бет", "сүйлөп жаткан баш", "сүйлөө", "сөлөкөт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schwätzende Kapp"),
            keywords: &[
                "Gesiicht",
                "Kapp",
                "Silhouette",
                "schwätzen",
                "schwätzend",
                "schwätzende Kapp",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເງ\u{ebb}າຄ\u{ebb}ນກຳລ\u{eb1}ງເວ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ເງ\u{ebb}າ",
                "ເງ\u{ebb}າຄ\u{ebb}ນກຳລ\u{eb1}ງເວ\u{ebb}\u{ec9}າ",
                "ເວ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kalbanti galva"),
            keywords: &[
                "galva",
                "kalbanti galva",
                "kalbėjimas",
                "kalbėti",
                "siluetas",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("runājoša galva"),
            keywords: &["galva", "runājoša galva", "runāt", "siluets"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("upoko kōrero"),
            keywords: &["ataata", "kanohi", "kōrero", "kōrero ana", "upoko"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глава што зборува"),
            keywords: &["глава", "глава што зборува", "зборува", "лице", "силуета"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സംസ\u{d3e}രിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "തല",
                "നിഴൽച\u{d4d}ചിത\u{d4d}രം",
                "പറയ\u{d41}ക",
                "മ\u{d41}ഖം",
                "സംസ\u{d3e}രിക\u{d4d}ക\u{d41}ക",
                "സംസ\u{d3e}രിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "സംസ\u{d3e}രിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ярьж буй толгой"),
            keywords: &["сүүдэр", "толгой", "ярих", "ярьж буй толгой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बोलणारी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "च\u{947}हरा",
                "छायाचित\u{94d}र",
                "डोक\u{947}",
                "बोलणारी व\u{94d}यक\u{94d}ती",
                "बोलण\u{947}",
                "बोला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kepala bercakap"),
            keywords: &["bayang", "bercakap", "cakap", "kepala", "muka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("titkellem ras"),
            keywords: &["jitkellmu", "ras", "silwett", "titkellem", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စကားပြောနေသည\u{1037}\u{103a} ဦးခေါင\u{103a}း"),
            keywords: &[
                "စကား",
                "စကားပြော",
                "စကားပြောနေသည\u{1037}\u{103a} ဦးခေါင\u{103a}း",
                "ပ\u{102f}\u{1036}ရ\u{102d}ပ\u{103a}မည\u{103a}း",
                "မျက\u{103a}န\u{103e}ာ",
                "ဦးခေါင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("snakkende hode i profil"),
            keywords: &[
                "fjes",
                "hode",
                "silhuett",
                "snakke",
                "snakkende hode i profil",
                "snakker",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बोलिरह\u{947}को व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "अन\u{941}हार",
                "छाया\u{901}",
                "टाउको",
                "बोलिरह\u{947}को",
                "बोलिरह\u{947}को व\u{94d}यक\u{94d}ति",
                "बोल\u{94d}न\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("silhouet van sprekend hoofd"),
            keywords: &[
                "gezicht",
                "hoofd",
                "praten",
                "pratend",
                "silhouet",
                "silhouet van sprekend hoofd",
                "spreken",
                "sprekend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("snakkande hovud i profil"),
            keywords: &[
                "fjes",
                "hovud",
                "profil",
                "silhuett",
                "snakkande hovud",
                "snakkande hovud i profil",
                "snakkar",
                "snakke",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଥ\u{b3e} କହ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଣ\u{b4d}ଡ"),
            keywords: &[
                "କଥ\u{b3e} କହ\u{b3f}ବ\u{b3e}",
                "କଥ\u{b3e} କହ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଣ\u{b4d}ଡ",
                "କହ\u{b3f}ବ\u{b3e}",
                "ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}",
                "ମ\u{b41}ଣ\u{b4d}ଡ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4b}ਲਦਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਪਰਛਾਵਾ\u{a02}",
                "ਬ\u{a4b}ਲਣਾ",
                "ਬ\u{a4b}ਲਦਾ ਚਿਹਰਾ",
                "ਬ\u{a4b}ਲਦਾ ਵਿਅਕਤੀ",
                "ਸਿਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بولن آلا سر"),
            keywords: &["بولن آلا سر", "بولنا", "تصویری خاکہ", "دی شکل", "سر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hẹd Wé De Tọk"),
            keywords: &[
                "De Spik",
                "Dák Shép Ọf Pẹ\u{301}sin Ọ Sọ\u{301}mtin",
                "Fes",
                "Hẹd",
                "Hẹd Wé De Tọk",
                "Spik",
                "Tọk",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mówiąca głowa"),
            keywords: &["mówiąca głowa", "mówić", "powiedzieć", "profil", "sylwetka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د خبرو سر"),
            keywords: &["بې مخ", "خبرې کول", "د خبرو سر", "سر", "مخ", "وييل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("silhueta falando"),
            keywords: &["cabeça", "falando", "silhueta", "voz"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cabeça a falar"),
            keywords: &["cabeça", "cabeça a falar", "cara", "falar", "silhueta"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uma parlachkan"),
            keywords: &["parlachkan", "parlay", "rikchay", "uma", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("cap vorbitor"),
            keywords: &[
                "cap", "față", "profil", "siluetă", "vorbi", "vorbire", "vorbitor",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-826"),
            keywords: &["E10-826"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("говорящая голова"),
            keywords: &["говорящая голова", "голова", "речь", "силуэт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutwe uvuga"),
            keywords: &["igicucucucu", "isura", "kuvuga", "umutwe", "umutwe uvuga"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿو ڳالهائيندي"),
            keywords: &["مٿو", "نقش ٺاهڻ", "چهرو", "ڳالهاء\u{650}", "ڳالهائيندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කථ\u{dcf} කරන හ\u{dd2}ස"),
            keywords: &[
                "කථ\u{dcf} කරන හ\u{dd2}ස",
                "කථ\u{dcf} කරනව\u{dcf}",
                "කථ\u{dcf} ක\u{dd2}ර\u{dd3}ම",
                "ම\u{dd4}හ\u{dd4}ණ",
                "හ\u{dd2}ස",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("hovoriaca hlava"),
            keywords: &["hlava", "hovoriaca", "hovoriť", "silueta", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("govoreča glava"),
            keywords: &[
                "glava",
                "govoreča glava",
                "govoriti",
                "govorjenje",
                "obraz",
                "silhueta",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Madax hadlaya"),
            keywords: &[
                "Madax hadlaya",
                "farshaxan sawir mugdi ah",
                "hadal",
                "hadlaya",
                "madax",
                "waji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kokë që flet"),
            keywords: &["flas", "fytyrë", "kokë që flet", "siluetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глава која говори"),
            keywords: &["гoвoр", "глaвa", "глава која говори", "лице", "силуeтa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("glava koja govori"),
            keywords: &["glava", "glava koja govori", "govor", "lice", "silueta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("silhuett som talar"),
            keywords: &["silhuett", "silhuett som talar", "talar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichwa kinachozugumza"),
            keywords: &[
                "kichwa",
                "kichwa kinachozugumza",
                "kivuli",
                "kuzungumza",
                "uso",
                "zungumza",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("kichwa kinachozungumza"),
            keywords: &[
                "kichwa",
                "kichwa kinachozungumza",
                "kivuli",
                "kuzungumza",
                "uso",
                "zungumza",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தலைமைப\u{bcd} பேச\u{bcd}ச\u{bbe}ளர\u{bcd}"),
            keywords: &[
                "தலை",
                "தலைமைப\u{bcd} பேச\u{bcd}ச\u{bbe}ளர\u{bcd}",
                "நிழல\u{bcd} உருவம\u{bcd}",
                "பேச\u{bcd}ச\u{bbe}ளர\u{bcd}",
                "பேச\u{bcd}சு",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}ట\u{c4d}ల\u{c3e}డుతున\u{c4d}న తల"),
            keywords: &[
                "తల",
                "న\u{c40}డ",
                "మ\u{c3e}ట\u{c4d}ల\u{c3e}డటం",
                "మ\u{c3e}ట\u{c4d}ల\u{c3e}డుతున\u{c4d}న తల",
                "మ\u{c3e}ట\u{c4d}ల\u{c3e}డుతున\u{c4d}న\u{c3e}రు",
                "ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("сари гап зада истода"),
            keywords: &[
                "гап зада истода",
                "гап задан",
                "рӯй",
                "сар",
                "сари гап зада истода",
                "суроб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เงาคนกำล\u{e31}งพ\u{e39}ด"),
            keywords: &["คน", "พ\u{e39}ด", "เงา", "เงาคนกำล\u{e31}งพ\u{e39}ด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gürleýän kelle"),
            keywords: &["gürlemek", "gürleýän", "kelle", "sudur", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mata talanoa"),
            keywords: &["mata talanoa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("konuşan kişi"),
            keywords: &[
                "bağırma",
                "kafa",
                "konuşan kişi",
                "konuşma",
                "profil",
                "siluet",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆزلەۋاتقان باش"),
            keywords: &["باش", "سايە", "سۆزلەش", "سۆزلەۋاتقان باش", "چىراي", "گەپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("голова, що говорить"),
            keywords: &[
                "говорити",
                "голова",
                "голова, що говорить",
                "обличчя",
                "силует",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بولتا سر"),
            keywords: &["بولتا سر", "بولنا", "سر", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("gapirayotgan bosh"),
            keywords: &[
                "bosh",
                "gapirayotgan bosh",
                "gapirish",
                "nutq",
                "siluet",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu người đang nói"),
            keywords: &[
                "cái đầu",
                "hình bóng",
                "khuôn mặt",
                "nói",
                "đang nói",
                "đầu người đang nói",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wax bopp"),
            keywords: &["bopp", "kanam", "takkandeer", "wax"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intloko ethethayo"),
            keywords: &[
                "i-silhouette",
                "intloko",
                "intloko ethethayo",
                "thetha",
                "ubuso",
                "ukuthetha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("orí tí ń sọ\u{300}rọ\u{300}"),
            keywords: &[
                "bíríbírí",
                "ojú",
                "orí",
                "orí tí ń sọ\u{300}rọ\u{300}",
                "sọ\u{300}rọ\u{300}",
                "ń sọ\u{300}rọ\u{300}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("講野嘅頭"),
            keywords: &["剪影", "臉", "講", "講野", "講野嘅頭", "頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("讲野嘅头"),
            keywords: &["剪影", "头", "脸", "讲", "讲野", "讲野嘅头"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("说话"),
            keywords: &["剪影", "头", "讲话", "说话"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("說話的人影"),
            keywords: &["說話", "說話的人影"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("講緊嘢嘅人頭剪影"),
            keywords: &["講嘢｜人頭｜剪影", "講緊嘢嘅人頭剪影"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhanda elikhulumayo"),
            keywords: &[
                "ikhanda",
                "ikhanda elikhulumayo",
                "isithombe",
                "ubuso",
                "ukukhuluma",
            ],
        },
    ],
};
#[doc = "👤"]
pub const BUST_IN_SILHOUETTE: crate::Emoji = crate::Emoji {
    glyph: "👤",
    codepoint: "1F464",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "bust in silhouette",
    group: "People & Body",
    subgroup: "person-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("borssilhoeët"),
            keywords: &["borssilhoeët", "profiel", "silhoeët"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሰው ጥላ"),
            keywords: &["ሐውልት", "የሰው ጥላ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صورة ظلية"),
            keywords: &["أشخاص", "صورة", "صورة ظلية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছিল\u{9c1}য\u{9bc}েটত আবক\u{9cd}ষ ম\u{9c2}ৰ\u{9cd}তি"),
            keywords: &[
                "আবক\u{9cd}ষ ম\u{9c2}র\u{9cd}তি",
                "ছিল\u{9c1}য\u{9bc}েট",
                "ছিল\u{9c1}য\u{9bc}েটত আবক\u{9cd}ষ ম\u{9c2}ৰ\u{9cd}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("büst silueti"),
            keywords: &["büst", "büst silueti", "siluet"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сілуэт бюста"),
            keywords: &["бюст", "сілуэт", "сілуэт бюста"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Силует на бюст"),
            keywords: &["Силует на бюст", "бюст", "силует"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সিল\u{9c1}য\u{9bc}েটে আবক\u{9cd}ষ ম\u{9c2}র\u{9cd}তি"),
            keywords: &[
                "আবক\u{9cd}ষ",
                "ছ\u{9be}য\u{9bc}\u{9be}",
                "সিল\u{9c1}য\u{9bc}েটে আবক\u{9cd}ষ ম\u{9c2}র\u{9cd}তি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("silueta glave s ramenima"),
            keywords: &["glava", "ramena", "silueta", "silueta glave s ramenima"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("silueta d’un bust"),
            keywords: &["bust", "silueta", "silueta d’un bust"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏲᏨᎢ ᎥᎿ ᎤᏙᏢᏒᎢ"),
            keywords: &["ᎤᏙᏢᏒᎢ", "ᎤᏲᏨᎢ", "ᎤᏲᏨᎢ ᎥᎿ ᎤᏙᏢᏒᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("silueta busty"),
            keywords: &["busta", "bysta", "silueta", "silueta busty"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("penddelw mewn silwét"),
            keywords: &["penddelw", "penddelw mewn silwét", "silwét"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("buste i silhuet"),
            keywords: &["buste", "buste i silhuet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Silhouette einer Büste"),
            keywords: &["Büste", "Person", "Silhouette einer Büste"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("περίγραμμα προτομής"),
            keywords: &["περίγραμμα προτομής", "προτομή", "φιγούρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bust in silhouette"),
            keywords: &["bust", "bust in silhouette", "silhouette"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("silueta de busto"),
            keywords: &["busto", "personas", "silueta", "silueta de busto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("büsti siluett"),
            keywords: &["büst", "büsti siluett", "siluett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("soinaren silueta"),
            keywords: &["silueta", "soin", "soinaren silueta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تندیس سایه\u{200c}نما"),
            keywords: &[
                "تندیس",
                "سایه\u{200c}نما",
                "سیاه\u{200c}نما",
                "سیلوئت",
                "نیم\u{200c}چهره\u{200c}نما",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rintasiluetti"),
            keywords: &["rintakuva", "rintasiluetti", "siluetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("silhouette ng bust"),
            keywords: &["bust", "silhouette", "silhouette ng bust"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skuggamynd av bringumynd"),
            keywords: &["bringumynd", "skuggamynd", "skuggamynd av bringumynd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("silhouette de buste"),
            keywords: &["buste", "silhouette de buste"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["buste", "silhouette", "silhouette de buste"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scáthchruth cinn"),
            keywords: &["cabhail", "corp", "duine", "scáthchruth cinn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("silhouette de chom"),
            keywords: &[
                "com",
                "sgàil-dhealbh",
                "sgàil-riochd",
                "silhouette",
                "silhouette de chom",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("silueta dun busto"),
            keywords: &["busto", "persoa", "silueta", "silueta dun busto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}ટથી ઉપલા ભાગન\u{ac1}\u{a82} પાર\u{acd}શ\u{acd}વચિત\u{acd}ર"),
            keywords: &[
                "પાર\u{acd}શ\u{acd}વચિત\u{acd}ર",
                "પ\u{ac7}ટથી ઉપલા ભાગન\u{ac1}\u{a82} પાર\u{acd}શ\u{acd}વચિત\u{acd}ર",
                "પ\u{ac7}ટથી ઉપલો ભાગ",
                "લોકો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("daga kai har ƙirji"),
            keywords: &["daga kai", "daga kai har ƙirji", "ƙirji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("צללית ראש וחזה"),
            keywords: &["חזה", "צללית", "צללית ראש וחזה", "ראש"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर क\u{947} शरीर की छाया"),
            keywords: &["ऊपर का शरीर", "ऊपर क\u{947} शरीर की छाया", "छाया", "लोग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("poprsje u silueti"),
            keywords: &["poprsje", "poprsje u silueti", "silueta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ember sziluettje melltől felfelé"),
            keywords: &["ember", "ember sziluettje melltől felfelé", "sziluett"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուրվագծված կիսանդրի"),
            keywords: &["կիսանդրի", "ուրվագիծ", "ուրվագծված կիսանդրի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("siluet foto setengah badan"),
            keywords: &["bayangan", "siluet foto setengah badan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("isi na ubu mmadụ atụrụ atụ dị na ọchịchịrị"),
            keywords: &[
                "atụ dị na ọchịchịrị",
                "isi na ubu mmadụ atụrụ",
                "isi na ubu mmadụ atụrụ atụ dị na ọchịchịrị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brjóstmynd í skugga"),
            keywords: &["brjóstmynd", "brjóstmynd í skugga", "framan á", "fólk"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("profilo di persona"),
            keywords: &["persona", "profilo", "profilo di persona"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("人のシルエット"),
            keywords: &["1人", "シルエット", "上半身", "人のシルエット"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bayangan patung sirah tekan dhadha"),
            keywords: &[
                "bayangan",
                "bayangan patung sirah tekan dhadha",
                "patung sirah tekan dhadha",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბიუსტის სილუეტი"),
            keywords: &["ბიუსტი", "ბიუსტის სილუეტი", "სილუეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("адам сұлбасы"),
            keywords: &["адам сұлбасы", "мүсін", "сұлба"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("buste i silhuet"),
            keywords: &["buste", "buste i silhuet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រមោលមន\u{17bb}ស\u{17d2}សត\u{17d2}រ\u{17b9}មស\u{17d2}មាឡើងលើ"),
            keywords: &[
                "មន\u{17bb}ស\u{17d2}ស",
                "ស\u{17d2}រមោល",
                "ស\u{17d2}រមោលមន\u{17bb}ស\u{17d2}សត\u{17d2}រ\u{17b9}មស\u{17d2}មាឡើងលើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎದ\u{cc6}ಮಟ\u{ccd}ಟದ ರೇಖಾಚ\u{cbf}ತ\u{ccd}ರ"),
            keywords: &[
                "ಎದ\u{cc6}ಮಟ\u{ccd}ಟದ ರೇಖಾಚ\u{cbf}ತ\u{ccd}ರ",
                "ಬಸ\u{ccd}ಟ\u{ccd}",
                "ಸ\u{cbf}ಲ\u{cc2}ಯ\u{cc6}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사람 그림자"),
            keywords: &["사람", "사람 그림자", "상반신", "상체"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळी आक\u{943}ती"),
            keywords: &["आक\u{943}ती", "काळी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бюст сөлөкөтү"),
            keywords: &["бюст", "бюст сөлөкөтү", "сөлөкөт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mënschlech Silhouette"),
            keywords: &["Büst", "Silhouette", "mënschlech"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເງ\u{ebb}າເຄ\u{eb4}\u{ec8}ງໂຕຄ\u{ebb}ນດຽວ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ເງ\u{ebb}າ",
                "ເງ\u{ebb}າເຄ\u{eb4}\u{ec8}ງໂຕຄ\u{ebb}ນດຽວ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("biusto siluetas"),
            keywords: &["biustas", "biusto siluetas", "siluetas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("krūšutēla siluets"),
            keywords: &["krūšutēla siluets", "krūšutēls", "siluets"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("poho rō ataata"),
            keywords: &["ataata", "poho", "poho rō ataata"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("силуета на биста"),
            keywords: &["биста", "силуета", "силуета на биста"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d4d}യക\u{d4d}തിയ\u{d41}ടെ നിഴൽച\u{d4d}ചിത\u{d4d}രം"),
            keywords: &[
                "നിഴൽ ശരീരം",
                "നിഴൽച\u{d4d}ചിത\u{d4d}രം",
                "ബസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}",
                "വ\u{d4d}യക\u{d4d}തിയ\u{d41}ടെ നിഴൽച\u{d4d}ചിത\u{d4d}രം",
                "സില\u{d4d}ല\u{d57}ട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүний сүүдэр дүрс"),
            keywords: &["сүүдэр дүрс", "хүний сүүдэр дүрс", "цээж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रकाशात दिसणारी शरीराच\u{94d}या वरील भागाची आक\u{943}ती"),
            keywords: &[
                "अर\u{94d}धप\u{94d}रतिमा",
                "छायाचित\u{94d}र",
                "छायाचित\u{94d}रातील अर\u{94d}धप\u{94d}रतिमा",
                "प\u{94d}रकाशात दिसणारी शरीराच\u{94d}या वरील भागाची आक\u{943}ती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bayang dada"),
            keywords: &["bayang", "dada"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bust f’silwett"),
            keywords: &["bust", "bust f’silwett", "silwett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{102d}\u{102f}ယ\u{103a}တစ\u{103a}ပ\u{102d}\u{102f}င\u{103a}း အရ\u{102d}ပ\u{103a}ပ\u{102f}\u{1036}",
            ),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}တစ\u{103a}ပ\u{102d}\u{102f}င\u{103a}း",
                "က\u{102d}\u{102f}ယ\u{103a}တစ\u{103a}ပ\u{102d}\u{102f}င\u{103a}း အရ\u{102d}ပ\u{103a}ပ\u{102f}\u{1036}",
                "ပ\u{102f}\u{1036}ရ\u{102d}ပ\u{103a}မည\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("silhuett av byste"),
            keywords: &["byste", "menneske", "silhuett", "silhuett av byste"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छायाचित\u{94d}रमा बस\u{94d}ट"),
            keywords: &[
                "छायाचित\u{94d}र",
                "छायाचित\u{94d}रमा बस\u{94d}ट",
                "बस\u{94d}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("silhouet van persoon"),
            keywords: &["buste", "silhouet", "silhouet van persoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("silhuett av byste"),
            keywords: &["byste", "menneske", "silhuett", "silhuett av byste"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}ରେ ଫ\u{b3e}ଟ"),
            keywords: &[
                "ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}",
                "ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}ରେ ଫ\u{b3e}ଟ",
                "ଫ\u{b3e}ଟ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛਾਤੀ ਤ\u{a71}ਕ ਬਣਤਰ"),
            keywords: &["ਛਾਤੀ", "ਛਾਤੀ ਤ\u{a71}ਕ ਬਣਤਰ", "ਬਣਤਰ", "ਲ\u{a4b}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خاکے وچ زنانی دی چھاتی"),
            keywords: &["تصویری خاکہ", "خاکے وچ زنانی دی چھاتی", "زنانی دی چھاتی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dák Shép Ọf Ọ\u{301}p Pát Ọf Pẹ\u{301}sin Bọdí"),
            keywords: &[
                "Dák Shép Ọf Pẹ\u{301}sin Ọ Sọ\u{301}mtin",
                "Dák Shép Ọf Ọ\u{301}p Pát Ọf Pẹ\u{301}sin Bọdí",
                "Ọ\u{301}p Pát Ọf Pẹ\u{301}sin Bọdí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sylwetka popiersia"),
            keywords: &["osoba", "sylwetka popiersia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بې مخه سړی"),
            keywords: &["بسټ", "بې مخ", "بې مخه سړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("silhueta de busto"),
            keywords: &["busto", "pessoas", "silhueta", "silhueta de busto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["busto", "silhueta", "silhueta de busto"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ukhu rikchay"),
            keywords: &["rikchay", "ukhu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("siluetă bust"),
            keywords: &["bust", "siluetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-545"),
            keywords: &["E10-545"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("силуэт человека"),
            keywords: &[
                "бюст",
                "лицо",
                "силуэт",
                "силуэт человека",
                "темный",
                "человек",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ishusho y’igihimba cy’umuntu"),
            keywords: &["igicucu", "igihimba", "ishusho y’igihimba cy’umuntu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خطي تصوير ۾ مورتي"),
            keywords: &["خطي تصوير ۾ مورتي", "مورتي، خطي تصوير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ල\u{dd4}වටයෙහ\u{dd2} උඩ\u{dd4}කය"),
            keywords: &[
                "උඩ\u{dd4}කය",
                "ස\u{dd2}ල\u{dd4}වටය",
                "ස\u{dd2}ල\u{dd4}වටයෙහ\u{dd2} උඩ\u{dd4}කය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("silueta busty"),
            keywords: &["busta", "silueta", "silueta busty"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("silhueta doprsja"),
            keywords: &["doprsje", "silhueta", "silhueta doprsja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Sawir muuqaal dumar qaarka hore mugdi ah"),
            keywords: &[
                "Farshaxan sawir xabad dumar ah",
                "Sawir muuqaal dumar qaarka hore mugdi ah",
                "farshaxan sawir oo mugdi ah",
                "sawir muuqaal rag mugdi ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bust siluetë"),
            keywords: &["bust", "siluetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("силуета човека"),
            keywords: &["горњи део тела", "силуeтa", "силуета човека"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("силуета човјека"),
            keywords: &["силуета човјека"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("silueta čoveka"),
            keywords: &["gornji deo tela", "silueta", "silueta čoveka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("silueta čovjeka"),
            keywords: &["silueta čovjeka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("figur i silhuett"),
            keywords: &["figur", "figur i silhuett", "människa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kivuli cha kichwa na mabega ya mtu"),
            keywords: &[
                "kivuli",
                "kivuli cha kichwa na mabega ya mtu",
                "sanamu ya kichwa na mabega ya mtu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}ர\u{bcd}பளவு வரை நிழல\u{bcd}"),
            keywords: &[
                "நிழல\u{bcd} படம\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
                "ம\u{bbe}ர\u{bcd}பளவு வரை நிழல\u{bcd}",
                "ம\u{bbe}ர\u{bcd}பளவு வரை நிழல\u{bcd} படம\u{bcd}",
                "ம\u{bbe}ர\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "నడుము ప\u{c48}భ\u{c3e}గంల\u{c4b}న\u{c3f} వ\u{c4d}యక\u{c4d}త\u{c3f} న\u{c40}డ",
            ),
            keywords: &[
                "నడుము",
                "నడుము ప\u{c48}భ\u{c3e}గంల\u{c4b}న\u{c3f} వ\u{c4d}యక\u{c4d}త\u{c3f} న\u{c40}డ",
                "న\u{c40}డ",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нимпайкара дар суроб"),
            keywords: &["нимпайкара", "нимпайкара дар суроб", "суроб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เงาคร\u{e36}\u{e48}งต\u{e31}วคนเด\u{e35}ยว"),
            keywords: &["คน", "เงาคร\u{e36}\u{e48}งต\u{e31}วคนเด\u{e35}ยว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sudury görünýän heýkel"),
            keywords: &["býust", "sudur", "sudury görünýän heýkel"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻata ʻoe sino"),
            keywords: &["ʻata ʻoe sino"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("siluet büst"),
            keywords: &["büst", "kişiler", "siluet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىشى سايىسى"),
            keywords: &["سايە", "كىشى سايىسى", "ھەيكەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("силует бюсту людини"),
            keywords: &["бюст", "силует", "силует бюсту людини"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آدمی کا خاکہ"),
            keywords: &["آدمی کا خاکہ", "خاکہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kontur suratli byust"),
            keywords: &["byust", "kontur suratli byust", "siluet"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bóng tượng bán thân"),
            keywords: &["bóng", "bóng tượng bán thân", "tượng bán thân"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yaram takkandeer"),
            keywords: &["takkandeer", "yaram"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfanekiso oqingqiweyo wentloko namagxa"),
            keywords: &[
                "intloko namagxa",
                "umfanekiso oqingqiweyo",
                "umfanekiso oqingqiweyo wentloko namagxa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Bujade Ni Biribiri"),
            keywords: &["Bujade Ni Biribiri", "bíríbírí", "bújáde"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("胸像剪影"),
            keywords: &["剪影", "胸像", "胸像剪影"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("胸像剪影"),
            keywords: &["剪影", "胸像", "胸像剪影"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("人像"),
            keywords: &["人像", "剪影", "半身像"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("肖像剪影"),
            keywords: &["剪影", "肖像剪影"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("人形剪影"),
            keywords: &["人形剪影", "人形剪影｜剪影"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isithombe somuntu"),
            keywords: &["isithombe", "isithombe somuntu", "umuntu"],
        },
    ],
};
#[doc = "👥"]
pub const BUSTS_IN_SILHOUETTE: crate::Emoji = crate::Emoji {
    glyph: "👥",
    codepoint: "1F465",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "busts in silhouette",
    group: "People & Body",
    subgroup: "person-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("borssilhoeëtte"),
            keywords: &["borssilhoeëtte", "profiele", "silhoeëtte"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሰው ጥላዎች"),
            keywords: &["ሐውልት", "የሰው ጥላ", "የሰው ጥላዎች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صورتان ظليتان"),
            keywords: &["أشخاص", "صورتان", "صورتان ظليتان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছিল\u{9c1}য\u{9bc}েটত আবক\u{9cd}ষ ম\u{9c2}ৰ\u{9cd}তিবোৰ"),
            keywords: &[
                "আবক\u{9cd}ষ ম\u{9c2}র\u{9cd}তি",
                "ছিল\u{9c1}য\u{9bc}েট",
                "ছিল\u{9c1}য\u{9bc}েটত আবক\u{9cd}ষ ম\u{9c2}ৰ\u{9cd}তিবোৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("büst siluetləri"),
            keywords: &["büst", "büst siluetləri", "siluet"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сілуэты бюстаў"),
            keywords: &["бюст", "сілуэт", "сілуэты бюстаў"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Силуети на бюстове"),
            keywords: &["Силуети на бюстове", "бюст", "силует"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সিল\u{9c1}য\u{9bc}েটে আবক\u{9cd}ষ ম\u{9c2}র\u{9cd}তিগ\u{9c1}লি"),
            keywords: &[
                "আবক\u{9cd}ষ",
                "ছ\u{9be}য\u{9bc}\u{9be}",
                "সিল\u{9c1}য\u{9bc}েটে আবক\u{9cd}ষ ম\u{9c2}র\u{9cd}তিগ\u{9c1}লি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("siluete glave s ramenima"),
            keywords: &["glava", "ramena", "silueta", "siluete glave s ramenima"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("silueta de bustos"),
            keywords: &["bustos", "silueta de bustos", "siluetes"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏲᎪᎢ ᎥᎿ ᎤᏙᏢᏒᎢ"),
            keywords: &["ᎠᏲᎪᎢ ᎥᎿ ᎤᏙᏢᏒᎢ", "ᎤᏙᏢᏒᎢ", "ᎤᏲᏨᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("silueta dvojice bust"),
            keywords: &["busta", "bysta", "silueta", "silueta dvojice bust"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("penddelwau mewn silwét"),
            keywords: &["penddelw", "penddelwau mewn silwét", "silwét"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("buster i silhuet"),
            keywords: &["buster", "buster i silhuet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Silhouette mehrerer Büsten"),
            keywords: &["Büsten", "Personen", "Silhouette mehrerer Büsten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("περίγραμμα προτομών"),
            keywords: &["περίγραμμα προτομών", "προτομή", "φιγούρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("busts in silhouette"),
            keywords: &["bust", "busts in silhouette", "silhouette"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dos siluetas de bustos"),
            keywords: &["bustos", "dos siluetas de bustos", "personas", "siluetas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("büstide siluetid"),
            keywords: &["büst", "büstide siluetid", "siluett"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("soinen siluetak"),
            keywords: &["silueta", "soin", "soinen siluetak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تندیس\u{200c}های سایه\u{200c}نما"),
            keywords: &[
                "تندیس",
                "تندیس\u{200c}های سایه\u{200c}نما",
                "سایه\u{200c}نما",
                "سیاه\u{200c}نما",
                "سیلوئت",
                "نیم\u{200c}چهره\u{200c}نما",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kaksi rintasiluettia"),
            keywords: &["kaksi rintasiluettia", "rintakuva", "siluetti"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("silhouette ng mga bust"),
            keywords: &["bust", "silhouette", "silhouette ng mga bust"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skuggamynd av bringumyndum"),
            keywords: &[
                "bringumynd",
                "bryngumyndir",
                "skuggamynd",
                "skuggamynd av bringumyndum",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("silhouettes de bustes"),
            keywords: &["bustes", "silhouettes de bustes"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bustes", "silhouettes", "silhouettes de bustes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scáthchruth ceann"),
            keywords: &["cabhlacha", "coirp", "daoine", "scáthchruth ceann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("silhouette de chuim"),
            keywords: &[
                "com",
                "sgàil-dhealbh",
                "sgàil-riochd",
                "silhouette",
                "silhouette de chuim",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("silueta de dous bustos"),
            keywords: &["bustos", "persoas", "silueta", "silueta de dous bustos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac7}ટથી ઉપલા ભાગના પાર\u{acd}શ\u{acd}વચિત\u{acd}ર"),
            keywords: &[
                "પાર\u{acd}શ\u{acd}વચિત\u{acd}ર",
                "પ\u{ac7}ટથી ઉપલા ભાગના પાર\u{acd}શ\u{acd}વચિત\u{acd}ર",
                "પ\u{ac7}ટથી ઉપલા ભાગન\u{ac1}\u{a82} પાર\u{acd}શ\u{acd}વચિત\u{acd}ર",
                "પ\u{ac7}ટથી ઉપલો ભાગ",
                "લોકો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("daga kanu har ƙirji"),
            keywords: &["daga kai", "daga kanu har ƙirji", "ƙirji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שתי צלליות ראש וחזה"),
            keywords: &["חזה", "צללית", "ראש", "שתי צלליות ראש וחזה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर क\u{947} शरीर की छायाए\u{902}"),
            keywords: &[
                "ऊपर का शरीर",
                "ऊपर क\u{947} शरीर की छाया",
                "ऊपर क\u{947} शरीर की छायाए\u{902}",
                "छाया",
                "लोग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("poprsja u silueti"),
            keywords: &["poprsja u silueti", "poprsje", "silueta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("két ember sziluettje melltől felfelé"),
            keywords: &["ember", "két ember sziluettje melltől felfelé", "sziluett"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուրվագծված կիսանդրիներ"),
            keywords: &["կիսանդրի", "ուրվագիծ", "ուրվագծված կիսանդրիներ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("beberapa siluet foto setengah badan"),
            keywords: &["bayangan", "beberapa siluet foto setengah badan", "siluet"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("isi na ubu mmadụ atụrụ atụ dị na ọchịchịrị gasị"),
            keywords: &[
                "atụ dị na ọchịchịrị",
                "isi na ubu mmadụ atụrụ",
                "isi na ubu mmadụ atụrụ atụ dị na ọchịchịrị gasị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("brjóstmyndir í skugga"),
            keywords: &["brjóstmynd", "brjóstmyndir í skugga", "framan á", "fólk"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("profilo di due persone"),
            keywords: &["persone", "profilo", "profilo di due persone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("2人のシルエット"),
            keywords: &["2人", "2人のシルエット", "シルエット", "上半身"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bayangan patung sirah tekan dhadha loro"),
            keywords: &[
                "bayangan",
                "bayangan patung sirah tekan dhadha loro",
                "patung sirah tekan dhadha",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბიუსტების სილუეტი"),
            keywords: &["ბიუსტების სილუეტი", "ბიუსტი", "სილუეტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("адамдар сұлбасы"),
            keywords: &["адамдар сұлбасы", "мүсін", "сұлба"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("buster i silhuet"),
            keywords: &["buster", "buster i silhuet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ស\u{17d2}រមោលមន\u{17bb}ស\u{17d2}សព\u{17b8}រនាក\u{17cb}ត\u{17d2}រ\u{17b9}មស\u{17d2}មាឡើងលើ",
            ),
            keywords: &[
                "ព\u{17b8}រនាក\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សព\u{17b8}រនាក\u{17cb}",
                "ស\u{17d2}រមោល",
                "ស\u{17d2}រមោលមន\u{17bb}ស\u{17d2}សព\u{17b8}រនាក\u{17cb}ត\u{17d2}រ\u{17b9}មស\u{17d2}មាឡើងលើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಸ\u{cbf}ಲ\u{cc2}ಯ\u{cc6}ಟ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಬಸ\u{ccd}ಟ\u{ccd}\u{200c}ಗಳು",
            ),
            keywords: &[
                "ಬಸ\u{ccd}ಟ\u{ccd}",
                "ಸ\u{cbf}ಲ\u{cc2}ಯ\u{cc6}ಟ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಬಸ\u{ccd}ಟ\u{ccd}",
                "ಸ\u{cbf}ಲ\u{cc2}ಯ\u{cc6}ಟ\u{ccd}\u{200c}ನಲ\u{ccd}ಲ\u{cbf} ಬಸ\u{ccd}ಟ\u{ccd}\u{200c}ಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사람들 그림자"),
            keywords: &["사람들", "사람들 그림자", "상반신", "상체"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळी आक\u{943}ती २"),
            keywords: &["आक\u{943}ती", "काळी", "काळी आक\u{943}ती २"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бюсттар сөлөкөтү"),
            keywords: &["бюст", "бюсттар сөлөкөтү", "сөлөкөт"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("mënschlech Silhouetten"),
            keywords: &["Büst", "Silhouette", "mënschlech", "mënschlech Silhouetten"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເງ\u{ebb}າເຄ\u{eb4}\u{ec8}ງໂຕສອງຄ\u{ebb}ນ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ເງ\u{ebb}າ",
                "ເງ\u{ebb}າເຄ\u{eb4}\u{ec8}ງໂຕສອງຄ\u{ebb}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("biustų siluetai"),
            keywords: &["biustas", "biustų siluetai", "siluetas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("divu krūšutēlu silueti"),
            keywords: &["divu krūšutēlu silueti", "krūšutēls", "siluets"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā poho rō ataata"),
            keywords: &["ataata", "ngā poho rō ataata", "poho"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("силуета на бисти"),
            keywords: &["биста", "силуета", "силуета на бисти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d4d}യക\u{d4d}തികള\u{d41}ടെ നിഴൽച\u{d4d}ചിത\u{d4d}രം"),
            keywords: &[
                "ആള\u{d41}കൾ",
                "നിഴൽ ശരീരം",
                "നിഴൽച\u{d4d}ചിത\u{d4d}രം",
                "ബസ\u{d4d}\u{200c}റ\u{d4d}റ\u{d4d}",
                "വ\u{d4d}യക\u{d4d}തികള\u{d41}ടെ നിഴൽച\u{d4d}ചിത\u{d4d}രം",
                "സില\u{d4d}ല\u{d57}ട\u{d4d}ട\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("2 сүүдэр"),
            keywords: &["2 сүүдэр", "сүүдэр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रकाशात दिसणार\u{94d}\u{200d}या शरीराच\u{94d}या आक\u{943}त\u{94d}या"),
            keywords: &[
                "अर\u{94d}धप\u{94d}रतिमा",
                "छायाचित\u{94d}र",
                "छायाचित\u{94d}रातील अर\u{94d}धप\u{94d}रतिमा",
                "प\u{94d}रकाशात दिसणार\u{94d}\u{200d}या शरीराच\u{94d}या आक\u{943}त\u{94d}या",
                "प\u{94d}रकाशात दिसणार\u{94d}\u{200d}या शरीराच\u{94d}या वरील भागाच\u{94d}या आक\u{943}त\u{94d}या",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bayang beberapa dada"),
            keywords: &["bayang", "bayang beberapa dada", "dada"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("busti f’silwett"),
            keywords: &["bust", "busti f’silwett", "silwett"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{102d}\u{102f}ယ\u{103a}တစ\u{103a}ပ\u{102d}\u{102f}င\u{103a}းများ၏ အရ\u{102d}ပ\u{103a}ပ\u{102f}\u{1036}",
            ),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}တစ\u{103a}ပ\u{102d}\u{102f}င\u{103a}း",
                "က\u{102d}\u{102f}ယ\u{103a}တစ\u{103a}ပ\u{102d}\u{102f}င\u{103a}းများ၏ အရ\u{102d}ပ\u{103a}ပ\u{102f}\u{1036}",
                "ပ\u{102f}\u{1036}ရ\u{102d}ပ\u{103a}မည\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("silhuett av byster"),
            keywords: &["byste", "menneske", "silhuett", "silhuett av byster"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छायाचित\u{94d}रमा बस\u{94d}टहर\u{942}"),
            keywords: &[
                "छायाचित\u{94d}र",
                "छायाचित\u{94d}रमा बस\u{94d}टहर\u{942}",
                "बस\u{94d}ट",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("silhouet van twee personen"),
            keywords: &["buste", "silhouet", "silhouet van twee personen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("silhuett av byster"),
            keywords: &["byste", "menneske", "silhuett", "silhuett av byster"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}ରେ ଫ\u{b3e}ଟଗ\u{b41}ଡ\u{b3f}କ",
            ),
            keywords: &[
                "ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}",
                "ଛ\u{b3e}ୟ\u{b3e}ମ\u{b42}ର\u{b4d}ତ\u{b4d}ତ\u{b3f}ରେ ଫ\u{b3e}ଟଗ\u{b41}ଡ\u{b3f}କ",
                "ଫ\u{b3e}ଟ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਛਾਤੀਆ\u{a02} ਤ\u{a71}ਕ ਬਣਤਰ"),
            keywords: &["ਛਾਤੀ", "ਛਾਤੀਆ\u{a02} ਤ\u{a71}ਕ ਬਣਤਰ", "ਬਣਤਰ", "ਲ\u{a4b}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خاکے وچ زنانیاں دیاں چھاتیاں"),
            keywords: &[
                "تصویری خاکہ",
                "خاکے وچ زنانیاں دیاں چھاتیاں",
                "زنانی دی چھاتی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Dák Shép Ọf Ọ\u{301}p Pát Ọf Tú Pípul Bọdí"),
            keywords: &[
                "Dák Shép Ọf Pẹ\u{301}sin Ọ Sọ\u{301}mtin",
                "Dák Shép Ọf Ọ\u{301}p Pát Ọf Tú Pípul Bọdí",
                "Ọ\u{301}p Pát Ọf Pẹ\u{301}sin Bọdí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sylwetki popiersi"),
            keywords: &["osoby", "sylwetki", "sylwetki popiersi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پرته له مخ سړي"),
            keywords: &["بسټ", "بې مخ", "بې مخه سړي", "پرته له مخ سړي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("silhueta de bustos"),
            keywords: &["busto", "pessoas", "silhueta", "silhueta de bustos"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["busto", "silhueta", "silhueta de bustos"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ukhu rikchaykuna"),
            keywords: &["rikchay", "ukhu", "ukhu rikchaykuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("siluete busturi"),
            keywords: &["bust", "siluete busturi", "siluetă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-546"),
            keywords: &["E10-546"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("два силуэта"),
            keywords: &[
                "бюст",
                "два силуэта",
                "двое",
                "лицо",
                "люди",
                "силуэт",
                "темный",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amashusho y’igihimba cy’umuntu"),
            keywords: &["amashusho y’igihimba cy’umuntu", "igicucu", "igihimba"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("خطي تصوير ۾ مورتيون"),
            keywords: &["خطي تصوير ۾ مورتيون", "مورتي، خطي تصوير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ල\u{dd4}වටයෙහ\u{dd2}\u{dd2} උඩ\u{dd4}කයවල\u{dca}"),
            keywords: &[
                "උඩ\u{dd4}කය",
                "ස\u{dd2}ල\u{dd4}වටය",
                "ස\u{dd2}ල\u{dd4}වටයෙහ\u{dd2}\u{dd2} උඩ\u{dd4}කයවල\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("silueta búst"),
            keywords: &["busta", "silueta", "silueta búst"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("silhueti doprsja"),
            keywords: &["doprsje", "silhueta", "silhueti doprsja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Farshaxan sawir xabad dumar oo mugdi ah"),
            keywords: &[
                "Farshaxan sawir xabad dumar ah",
                "Farshaxan sawir xabad dumar oo mugdi ah",
                "farshaxan sawir oo mugdi ah",
                "sawir muuqaal rag mugdi ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("buste siluetë"),
            keywords: &["bust", "buste siluetë", "siluetë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("силуете људи"),
            keywords: &["горњи део тела", "силуeтa", "силуете људи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["силуете људи"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("siluete ljudi"),
            keywords: &["gornji deo tela", "silueta", "siluete ljudi"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["siluete ljudi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("figurer i silhuett"),
            keywords: &["figurer", "figurer i silhuett", "människor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vivuli vya vichwa na mabega ya watu"),
            keywords: &[
                "kivuli",
                "sanamu za kichwa na mabega ya mtu katika kivuli",
                "vivuli vya vichwa na mabega ya watu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}ர\u{bcd}பளவு வரை நிழல\u{bcd}கள\u{bcd}"),
            keywords: &[
                "நிழல\u{bcd}படம\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
                "ம\u{bbe}ர\u{bcd}பளவு வரை நிழல\u{bcd}கள\u{bcd}",
                "ம\u{bbe}ர\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("నడుము ప\u{c48}భ\u{c3e}గంల\u{c4b}న\u{c3f} వ\u{c4d}యక\u{c4d}తుల న\u{c40}డలు"),
            keywords: &[
                "నడుము",
                "నడుము ప\u{c48}భ\u{c3e}గంల\u{c4b}న\u{c3f} వ\u{c4d}యక\u{c4d}తుల న\u{c40}డలు",
                "న\u{c40}డ",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нимпайкараҳо дар суроб"),
            keywords: &["нимпайкара", "нимпайкараҳо дар суроб", "суроб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เงาคร\u{e36}\u{e48}งต\u{e31}ว 2 คน"),
            keywords: &["ผ\u{e39}\u{e49}คน", "เงาคร\u{e36}\u{e48}งต\u{e31}ว 2 คน"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sudury görünýän heýkeller"),
            keywords: &["býust", "sudur", "sudury görünýän heýkeller"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo ʻata ʻoe sino"),
            keywords: &["ongo ʻata ʻoe sino"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("siluet büstler"),
            keywords: &["büst", "kişiler", "siluet", "siluet büstler"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كىشىلەرنىڭ سايىسى"),
            keywords: &["سايە", "كىشىلەرنىڭ سايىسى", "ھەيكەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("силуети двох людських бюстів"),
            keywords: &["бюст", "силует", "силуети двох людських бюстів"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آدمیوں کے خاکے"),
            keywords: &["آدمیوں کے خاکے", "خاکہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kontur suratli byustlar"),
            keywords: &["byust", "kontur suratli byustlar", "siluet"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("các bóng tượng bán thân"),
            keywords: &["bóng", "các bóng tượng bán thân", "tượng bán thân"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ay yaram takkandeer"),
            keywords: &["ay yaram takkandeer", "takkandeer", "yaram"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imifanekiso eqingqiweyo yentloko namagxa"),
            keywords: &[
                "imifanekiso eqingqiweyo yentloko namagxa",
                "intloko namagxa",
                "umfanekiso oqingqiweyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Ibujade Ni Biribiri"),
            keywords: &["Awọn Ibujade Ni Biribiri", "bíríbírí", "bújáde"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("兩個胸像嘅剪影"),
            keywords: &["兩個胸像嘅剪影", "剪影", "胸像"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("两个胸像嘅剪影"),
            keywords: &["两个胸像嘅剪影", "剪影", "胸像"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双人像"),
            keywords: &["剪影", "半身像", "双人像"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雙人肖像剪影"),
            keywords: &["剪影", "雙人肖像剪影"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雙人剪影"),
            keywords: &["雙人剪影", "雙人剪影｜剪影"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isithombe sabantu"),
            keywords: &["abantu", "isithombe", "isithombe sabantu"],
        },
    ],
};
#[doc = "🫂"]
pub const PEOPLE_HUGGING: crate::Emoji = crate::Emoji {
    glyph: "🫂",
    codepoint: "1FAC2",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "people hugging",
    group: "People & Body",
    subgroup: "person-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mense wat mekaar druk"),
            keywords: &[
                "dankie",
                "druk",
                "drukkie",
                "hallo",
                "mense wat mekaar druk",
                "totsiens",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰዎች ሲተቃቀፉ"),
            keywords: &["ሰዎች ሲተቃቀፉ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخصان يتعانقان"),
            keywords: &["ترحيب", "توديع", "شخصان يتعانقان", "شكر", "عناق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9cd}যক\u{9cd}তিয\u{9bc}ে স\u{9be}বটি ধৰি আছে"),
            keywords: &[
                "ধন\u{9cd}যব\u{9be}দ",
                "বিদ\u{9be}য\u{9bc}",
                "ব\u{9cd}যক\u{9cd}তিয\u{9bc}ে স\u{9be}বটি ধৰি আছে",
                "স\u{9be}বটি ধৰ\u{9be}",
                "হেল\u{9cd}লো",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qucaqlaşan insanlar"),
            keywords: &[
                "qucaqlaşan insanlar",
                "qucaqlaşma",
                "salam",
                "sağ ol",
                "təşəkkürlər",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("людзі абдымаюцца"),
            keywords: &["абдымкі", "бывай", "вітаю", "дзякуй", "людзі абдымаюцца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("прегръщащи се хора"),
            keywords: &[
                "благодаря",
                "довиждане",
                "здравей",
                "прегръдка",
                "прегръщащи се хора",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আলিঙ\u{9cd}গন"),
            keywords: &[
                "আলিঙ\u{9cd}গন",
                "ধন\u{9cd}যব\u{9be}দ",
                "বিদ\u{9be}য\u{9bc}",
                "হ\u{9cd}য\u{9be}লো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ljudi se grle"),
            keywords: &[
                "doviđenja",
                "grljenje",
                "ljudi se grle",
                "pozdrav",
                "zahvaljivanje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persones que s’abracen"),
            keywords: &[
                "abraçada",
                "adeu",
                "gràcies",
                "hola",
                "persones que s’abracen",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏂᏴᏫ ᏓᏓᏍᏆᏂᏱᏍᎬ"),
            keywords: &["ᎠᏂᏴᏫ ᏓᏓᏍᏆᏂᏱᏍᎬ", "ᎣᏏᏲ", "ᏓᏓᏍᏆᏂᏱᏍᎬ", "ᏙᎾᏓᎪᎲᎢ", "ᏩᏙ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("objímající se lidé"),
            keywords: &[
                "díky",
                "náruč",
                "objetí",
                "objímající se lidé",
                "pozdrav",
                "sbohem",
                "vděčnost",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("pobl yn cofleidio"),
            keywords: &["cwtsh", "diolch", "helo", "hwyl fawr", "pobl yn cofleidio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("knus"),
            keywords: &["farvel", "goddag", "hej", "knus", "kram", "tak"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich umarmende Personen"),
            keywords: &[
                "Danke",
                "Hallo",
                "Tschüss",
                "Umarmung",
                "sich umarmende Personen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομα αγκαλιάζονται"),
            keywords: &[
                "άτομα αγκαλιάζονται",
                "αγκαλιά",
                "αντίο",
                "γεια",
                "ευχαριστώ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("people hugging"),
            keywords: &["goodbye", "hello", "hug", "people hugging", "thanks"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("personas abrazándose"),
            keywords: &[
                "abrazo",
                "adiós",
                "despedida",
                "gracias",
                "personas abrazándose",
                "saludo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("personas que se abrazan"),
            keywords: &["personas que se abrazan"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kallistavad inimesed"),
            keywords: &[
                "hüvastijätt",
                "kallistavad inimesed",
                "kallistus",
                "tervitus",
                "tänu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("elkar besarkatzen ari den jendea"),
            keywords: &[
                "agur",
                "besarkada",
                "elkar besarkatzen ari den jendea",
                "eskerrik asko",
                "kaixo",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("درآغوش گرفتن"),
            keywords: &["تشکر", "خداحافظ", "درآغوش گرفتن", "روبوسی", "سلام"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("halaus"),
            keywords: &["halaus", "hei", "kiitos", "näkemiin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tao na magkayakap"),
            keywords: &[
                "akap",
                "kumusta",
                "paalam",
                "salamat",
                "tao na magkayakap",
                "yakap",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fólk sum klemmast"),
            keywords: &["bei", "fólk sum klemmast", "hey", "klemm", "takk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étreinte"),
            keywords: &["au revoir", "bonjour", "câlin", "gratitude", "étreinte"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("personnes qui s’étreignent"),
            keywords: &[
                "accolade",
                "au revoir",
                "bonjour",
                "merci",
                "personnes qui s’étreignent",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("daoine ag tabhairt barróige"),
            keywords: &[
                "barróg",
                "beannú",
                "buíochas",
                "daoine ag tabhairt barróige",
                "slán",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("caidreabh"),
            keywords: &[
                "caidir",
                "caidreabh",
                "dealachadh",
                "fàilte",
                "soraidh slàn",
                "taing",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoas abrazándose"),
            keywords: &["abrazo", "adeus", "aperta", "persoas abrazándose"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એકબીજાન\u{ac7} ભ\u{ac7}ટતા લોકો"),
            keywords: &[
                "આભાર",
                "એકબીજાન\u{ac7} ભ\u{ac7}ટતા લોકો",
                "ગ\u{ac1}ડબાય",
                "જોરથી ભ\u{ac7}ટવ\u{ac1}\u{a82}",
                "હ\u{ac7}લો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אנשים מתחבקים"),
            keywords: &["אהבה", "אנשים מתחבקים", "חיבוק", "פרידה", "תודה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("गल\u{947} मिलत\u{947} ह\u{941}ए लोग"),
            keywords: &[
                "अलविदा",
                "गल\u{947} मिलत\u{947} ह\u{941}ए लोग",
                "गल\u{947} मिलना",
                "धन\u{94d}यवाद",
                "नमस\u{94d}कार",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osobe koje se grle"),
            keywords: &[
                "hvala",
                "osobe koje se grle",
                "pozdrav",
                "zagrljaj",
                "zbogom",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egymást ölelő emberek"),
            keywords: &[
                "egymást ölelő emberek",
                "helló",
                "köszönet",
                "viszlát",
                "ölelés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրկախառնվող մարդիկ"),
            keywords: &[
                "բարև",
                "գրկախառնություն",
                "գրկախառնվող մարդիկ",
                "հրաժեշտ",
                "ողջույն",
                "ցտեսություն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang berpelukan"),
            keywords: &[
                "halo",
                "orang berpelukan",
                "peluk",
                "selamat tinggal",
                "terima kasih",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fólk að faðmast"),
            keywords: &["faðmlag", "fólk að faðmast", "halló", "kveðja", "þakklæti"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persone che si abbracciano"),
            keywords: &[
                "abbraccio",
                "addio",
                "ciao",
                "grazie",
                "persone che si abbracciano",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ハグする人"),
            keywords: &[
                "ありがとう",
                "お別れ",
                "こんにちは",
                "さようなら",
                "ハグする人",
                "挨拶",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong rangkulan"),
            keywords: &[
                "halo",
                "matur nuwun",
                "pamitan",
                "rangkulan",
                "wong rangkulan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩახუტებული ხალხი"),
            keywords: &[
                "გაგიმარჯოს",
                "გადახვევა",
                "გამარჯობა",
                "გაუმარჯოს",
                "ნახვამდის",
                "ჩახუტებული ხალხი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құшақтасқан адамдар"),
            keywords: &[
                "алғыс айту",
                "сәлемдесу",
                "қоштасу",
                "құшақтасу",
                "құшақтасқан адамдар",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងឱប"),
            keywords: &[
                "មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងឱប",
                "លាហើយ",
                "ស\u{17bd}ស\u{17d2}ដ\u{17b8}",
                "អរគ\u{17bb}ណ",
                "ឱប",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತಬ\u{ccd}ಬ\u{cbf}ಕೊಂಡ\u{cbf}ರುವ ಜನರು"),
            keywords: &[
                "ತಬ\u{ccd}ಬ\u{cbf}ಕೊ",
                "ತಬ\u{ccd}ಬ\u{cbf}ಕೊಂಡ\u{cbf}ರುವ ಜನರು",
                "ಧನ\u{ccd}ಯವಾದಗಳು",
                "ವ\u{cbf}ದಾಯ",
                "ಹಲೋ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("포옹하는 사람"),
            keywords: &["고마워", "안녕", "잘 가", "포옹", "포옹하는 사람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("लोक व\u{947}\u{902}ग मारतात"),
            keywords: &[
                "ग\u{942}डबाय",
                "द\u{947}व बर\u{947}\u{902} कर\u{942}\u{902}",
                "लोक व\u{947}\u{902}ग मारतात",
                "व\u{947}\u{902}ग मारप",
                "ह\u{945}लो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кучакташкан адамдар"),
            keywords: &[
                "жакшы кал",
                "кучак",
                "кучакташкан адамдар",
                "рахмат",
                "салам",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນກອດກ\u{eb1}ນ"),
            keywords: &[
                "ກອດ",
                "ຂອບໃຈ",
                "ຄ\u{ebb}ນກອດກ\u{eb1}ນ",
                "ລາກອນ",
                "ສະບາຍດ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("apsikabinę žmonės"),
            keywords: &["apsikabinti", "apsikabinę žmonės", "dėkui", "labas", "viso"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēki apkampjas"),
            keywords: &[
                "apskāviens",
                "ardievu",
                "cilvēki apkampjas",
                "labdien",
                "paldies",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("луѓе се гушкаат"),
            keywords: &[
                "благодарам",
                "гушкање",
                "здраво",
                "луѓе се гушкаат",
                "фала",
                "чао",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആലിംഗനം ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന ആള\u{d41}കൾ"),
            keywords: &[
                "ആലിംഗനം",
                "ആലിംഗനം ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന ആള\u{d41}കൾ",
                "നന\u{d4d}ദി",
                "വിട",
                "ഹലോ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тэврэлдэж буй хүмүүс"),
            keywords: &[
                "баяртай",
                "сайн уу",
                "талархал",
                "тэврэлдэж буй хүмүүс",
                "тэврэлт",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मिठी मारणार\u{94d}\u{200d}या व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "ग\u{941}डबाय",
                "धन\u{94d}यवाद",
                "मिठी मारणार\u{94d}\u{200d}या व\u{94d}यक\u{94d}ती",
                "मिठी मारण\u{947}",
                "ह\u{945}लो",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang berpelukan"),
            keywords: &[
                "helo",
                "orang berpelukan",
                "peluk",
                "selamat tinggal",
                "terima kasih",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖက\u{103a}နေသည\u{1037}\u{103a}ပ\u{102f}\u{1036}"),
            keywords: &[
                "ကျေးဇ\u{1030}း",
                "ဂ\u{103d}တ\u{103a}ဘ\u{102d}\u{102f}င\u{103a}",
                "ဖက\u{103a}",
                "ဖက\u{103a}နေသည\u{1037}\u{103a}ပ\u{102f}\u{1036}",
                "ဟယ\u{103a}လ\u{102d}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("klem"),
            keywords: &["farvel", "ha det", "hadet", "hei", "klem", "takk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मानिसहर\u{942}ल\u{947} अङ\u{94d}गालो हालिरह\u{947}का"),
            keywords: &[
                "अङ\u{94d}गालो",
                "ग\u{941}डबाइ",
                "धन\u{94d}यवाद",
                "नमस\u{94d}कार",
                "मानिसहर\u{942}ल\u{947} अङ\u{94d}गालो हालिरह\u{947}का",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("personen in een omhelzing"),
            keywords: &[
                "bedankt",
                "dag",
                "hallo",
                "omhelzing",
                "personen in een omhelzing",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("klem"),
            keywords: &["farvel", "hadet", "hei", "klem", "takk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲୋକମ\u{b3e}ନେ ଆଲ\u{b3f}ଙ\u{b4d}ଗନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଆଲ\u{b3f}ଙ\u{b4d}ଗନ",
                "ଧନ\u{b4d}ୟବ\u{b3e}ଦ",
                "ବ\u{b3f}ଦ\u{b3e}ୟ",
                "ଲୋକମ\u{b3e}ନେ ଆଲ\u{b3f}ଙ\u{b4d}ଗନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ହ\u{b3e}ଲୋ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਗਲ\u{a47} ਮਿਲ ਰਹ\u{a47} ਲ\u{a4b}ਕ"),
            keywords: &[
                "ਅਲਵਿਦਾ",
                "ਗਲ\u{a47} ਮਿਲ ਰਹ\u{a47} ਲ\u{a4b}ਕ",
                "ਜ\u{a71}ਫੀ",
                "ਧ\u{a70}ਨਵਾਦ",
                "ਹ\u{a48}ਲ\u{a4b}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pípul Wé Hól Ích Ọ\u{301}da Tait"),
            keywords: &[
                "Baibaí",
                "Hól Tait",
                "Hẹ\u{301}lo",
                "Họg",
                "Pípul Wé Hól Ích Ọ\u{301}da Tait",
                "Pípul Wé Họ\u{301}g Ích Ọ\u{301}da",
                "Tánkio",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("obejmujące się osoby"),
            keywords: &[
                "cześć",
                "do widzenia",
                "dzięki",
                "obejmujące się osoby",
                "uścisk",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خلک غاړۍ کيږې"),
            keywords: &["خدای پامانيۍ", "خلک غاړۍ کيږې", "مننه", "هيلو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoas se abraçando"),
            keywords: &["abraço", "adeus", "obrigado", "olá", "pessoas se abraçando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoas abraçadas"),
            keywords: &[
                "abraço",
                "adeus",
                "obrigado",
                "olá",
                "pessoas abraçadas",
                "pessoas se abraçando",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runakuna makʼalliwan"),
            keywords: &[
                "aywa",
                "imaynalla",
                "makʼalli",
                "pachi",
                "runakuna makʼalliwan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoane îmbrățișate"),
            keywords: &[
                "adio",
                "la revedere",
                "mulțumesc",
                "persoane îmbrățișate",
                "salut",
                "îmbrățișare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-026"),
            keywords: &["E13-026"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обнимающиеся люди"),
            keywords: &["обнимающиеся люди", "объятия", "пока", "привет", "спасибо"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڀاڪر پائيندڙ شخص"),
            keywords: &["مهرباني", "هيلو", "ڀاڪر", "ڀاڪر پائيندڙ شخص", "گوڊ بائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}න\u{dd2}ස\u{dca}ස\u{dd4} බද\u{dcf}ගන\u{dca}නව\u{dcf}"),
            keywords: &[
                "ආය\u{dd4}බෝවන\u{dca}",
                "ම\u{dd2}න\u{dd2}ස\u{dca}ස\u{dd4} බද\u{dcf}ගන\u{dca}නව\u{dcf}",
                "වැළඳ ගැන\u{dd3}ම",
                "ස\u{dca}ත\u{dd6}ත\u{dd2}ය\u{dd2}",
                "හෙලෝ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("objímajúci sa ľudia"),
            keywords: &[
                "lúčenie",
                "objatie",
                "objímajúci sa ľudia",
                "zbohom",
                "ďakujem",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("osebi, ki se objemata"),
            keywords: &[
                "hvala",
                "nasvidenje",
                "objem",
                "osebi, ki se objemata",
                "živijo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dad hab isi siinaya"),
            keywords: &[
                "dad hab isi siinaya",
                "hab siin",
                "haloow",
                "macsalaama",
                "mahadsanid",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njerëz që përqafohen"),
            keywords: &[
                "faleminderit",
                "mirupafshim",
                "njerëz që përqafohen",
                "përqafim",
                "përshëndetje",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("људи се грле"),
            keywords: &["довиђења", "загрљај", "здраво", "хвала", "људи се грле"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ljudi se grle"),
            keywords: &["doviđenja", "hvala", "ljudi se grle", "zagrljaj", "zdravo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("personer kramas"),
            keywords: &["adjö", "hej", "kram", "personer kramas", "tack"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("watu wanaokumbatiana"),
            keywords: &[
                "asante",
                "hujambo",
                "kumbatia",
                "kwaheri",
                "watu wanaokumbatiana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கட\u{bcd}டிப\u{bcd}பிடித\u{bcd}தல\u{bcd}"),
            keywords: &[
                "கட\u{bcd}டிப\u{bcd}பிடி",
                "கட\u{bcd}டிப\u{bcd}பிடித\u{bcd}தல\u{bcd}",
                "குட\u{bcd}பை",
                "நன\u{bcd}றி",
                "வணக\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4c}గ\u{c3f}ల\u{c3f}ంచుకుంటున\u{c4d}న వ\u{c4d}యక\u{c4d}తులు"),
            keywords: &[
                "క\u{c4c}గ\u{c3f}ల\u{c3f}ంచుకుంటున\u{c4d}న వ\u{c4d}యక\u{c4d}తులు",
                "క\u{c4c}గ\u{c3f}ల\u{c3f}ంత",
                "ధన\u{c4d}యవ\u{c3e}ద\u{c3e}లు",
                "పలకర\u{c3f}ంపు",
                "వ\u{c40}డ\u{c4d}క\u{c4b}లు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนกอดก\u{e31}น"),
            keywords: &[
                "กอด",
                "ขอบค\u{e38}ณ",
                "คนกอดก\u{e31}น",
                "ลาก\u{e48}อน",
                "สว\u{e31}สด\u{e35}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gujaklaşýan adamlar"),
            keywords: &[
                "gujaklamak",
                "gujaklaşýan adamlar",
                "sag bol",
                "sagbolsun",
                "salam",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kakai fāʻufua"),
            keywords: &["kakai fāʻufua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kucaklaşan insanlar"),
            keywords: &[
                "güle güle",
                "hoşçakal",
                "hoşçakalın",
                "kucaklaşan insanlar",
                "merhaba",
                "sağol",
                "sağolun",
                "selam",
                "teşekkür",
                "teşekkürler",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("люди обіймаються"),
            keywords: &[
                "вдячність",
                "люди обіймаються",
                "обійми",
                "привітання",
                "прощання",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گلے ملتے لوگ"),
            keywords: &["الوداع", "شکریہ", "گلے ملتے لوگ", "گلے ملنا", "ہیلو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quchoqlashayotgan odamlar"),
            keywords: &[
                "minnatdorlik",
                "quchoqlashayotgan odamlar",
                "quchoqlashish",
                "rahmat",
                "salom",
                "xayr",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai người ôm nhau"),
            keywords: &["cảm ơn", "hai người ôm nhau", "tạm biệt", "xin chào", "ôm"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("擁抱"),
            keywords: &["多謝", "您好", "抱抱", "拜拜", "擁抱"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拥抱"),
            keywords: &["多谢", "您好", "抱抱", "拜拜", "拥抱"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("人的拥抱"),
            keywords: &["人的拥抱", "再见", "您好", "感谢", "拥抱"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("擁抱的人"),
            keywords: &["抱抱", "掰掰", "擁抱的人", "謝謝"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("abantu abanganayo"),
            keywords: &["abantu abanganayo"],
        },
    ],
};
#[doc = "👣"]
pub const FOOTPRINTS: crate::Emoji = crate::Emoji {
    glyph: "👣",
    codepoint: "1F463",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "footprints",
    group: "People & Body",
    subgroup: "person-symbol",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("voetspore"),
            keywords: &["klere", "spoor", "voetafdrukke", "voetspoor", "voetspore"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእግር ዱካ"),
            keywords: &["አልባሳት", "አሻራ", "አካል", "የእግር ዱካ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أثر قدمين"),
            keywords: &["أثر قدم", "أثر قدمين", "جسم", "خطى", "قدم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পদচিহ\u{9cd}ন"),
            keywords: &[
                "ক\u{9be}পোৰ",
                "চিহ\u{9cd}ন",
                "পদচিহ\u{9cd}ন",
                "পদচিহ\u{9cd}নবোৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayaq izləri"),
            keywords: &["ayaq izi", "ayaq izləri", "geyim", "iz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сляды ног"),
            keywords: &["адбітак", "сляды", "сляды ног", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стъпки"),
            keywords: &["облекло", "следа", "стъпка", "стъпки", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}য\u{9bc}ের ছ\u{9be}প"),
            keywords: &[
                "ছ\u{9be}প",
                "প\u{9be}য\u{9bc}ের ছ\u{9be}প",
                "পোশ\u{9be}ক",
                "শরীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otisci stopala"),
            keywords: &["dio tijela", "otisak", "otisci stopala", "stopala"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("petjades"),
            keywords: &["cos", "empremta", "petja", "petjades", "vestit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᎳᏏᏅᎢ ᏚᏙᏪᎸᎢ"),
            keywords: &["ᏗᎿᏬ", "ᏚᎳᏏᏅ ᏚᏙᏪᎸᎢ", "ᏚᎳᏏᏅᎢ ᏚᏙᏪᎸᎢ", "ᏚᏙᏪᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stopy"),
            keywords: &["oblečení", "otisk", "stopa", "stopy", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("olion traed"),
            keywords: &["corff", "dilledyn", "olion traed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fodspor"),
            keywords: &["fodspor", "fødder"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fußabdrücke"),
            keywords: &["Abdruck", "Fuß", "Fußabdruck", "Fußabdrücke"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Fussabdrücke"),
            keywords: &["Abdruck", "Fuss", "Fussabdrücke"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πατημασιές"),
            keywords: &["ίχνος", "πατημασιά", "πατημασιές", "ρουχισμός", "σώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("footprints"),
            keywords: &["clothing", "footprint", "footprints", "print"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("huellas de pies"),
            keywords: &["cuerpo", "huellas", "huellas de pies", "pies"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("huellas"),
            keywords: &["cuerpo", "huellas", "pie", "pisada"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("huellas de pies"),
            keywords: &["cuerpo", "huellas de pies", "pie", "pisada"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("huellas de pies"),
            keywords: &["cuerpo", "huellas de pies", "pie", "pisada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jalajäljed"),
            keywords: &["jalajälg", "jalajäljed", "jälg", "keha"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oin-aztarnak"),
            keywords: &["arropa", "aztarna", "gorputz", "oin", "oin-aztarnak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("رد پا"),
            keywords: &["اثر", "بدن", "جای پا", "رد پا", "پوشاک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jalanjäljet"),
            keywords: &["jalanjäljet", "jalanjäljki", "jälki", "vaatteet", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga bakas ng paa"),
            keywords: &["bakas", "disenyo", "mga bakas ng paa", "paa", "yapak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fótaspor"),
            keywords: &["fótaspor", "føtur", "il", "slóð", "spor"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("traces de pas"),
            keywords: &["pied", "traces de pas"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["empreinte", "pas", "pied", "trace", "traces de pas"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("loirg choise"),
            keywords: &["cos", "loirg choise", "lorg", "lorg coise"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lorgan coise"),
            keywords: &["aodach", "lorg", "lorg coise", "lorgan coise"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pegadas de pés"),
            keywords: &["pegada", "pegadas de pés", "pés"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પગના\u{a82} નિશાન"),
            keywords: &["નિશાન", "પગ", "પગના\u{a82} નિશાન", "શરીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("sawaye"),
            keywords: &["buga", "sawaye", "sawu", "sutura"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טביעות רגל"),
            keywords: &["טביעות רגל", "עקבות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पदचिह\u{94d}न"),
            keywords: &["छाप", "पदचिह\u{94d}न", "प\u{948}र", "शरीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otisci stopala"),
            keywords: &["noge", "otisak", "otisci stopala", "stopala", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lábnyomok"),
            keywords: &["lábnyom", "lábnyomok", "nyomok"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոտնահետքեր"),
            keywords: &["հագուստ", "հետք", "մարմին", "ոտնահետք", "ոտնահետքեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jejak kaki"),
            keywords: &["badan", "jejak", "kaki", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụzọụkwụ gasị"),
            keywords: &["akwà", "bipụta", "ụzọụkwụ", "ụzọụkwụ gasị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fótspor"),
            keywords: &["fótspor", "fótur", "líkami", "spor"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("impronta di piedi"),
            keywords: &["corpo", "impronta", "impronta di piedi", "piede"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("足あと"),
            keywords: &["足", "足あと"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tipak sikil"),
            keywords: &["klambi", "tipak", "tipak sikil"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფეხების ნაკვალევი"),
            keywords: &[
                "ნაკვალევი",
                "სხეული",
                "ტანი",
                "ტანსაცმელი",
                "ფეხების ნაკვალევი",
                "ფეხის ნაკვალევი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аяқ іздері"),
            keywords: &["аяқ іздері", "дене", "киім", "ізі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fodspor"),
            keywords: &["fodspor", "fødder"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដានជើង"),
            keywords: &["ដាន", "ដានជើង", "សម\u{17d2}លៀកប\u{17c6}ពាក\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cc6}ಜ\u{ccd}ಜ\u{cc6} ಗುರುತುಗಳು"),
            keywords: &[
                "ಪಾದ",
                "ಹ\u{cc6}ಜ\u{ccd}ಜ\u{cc6} ಗುರುತುಗಳು",
                "ಹ\u{cc6}ಜ\u{ccd}ಜ\u{cc6}ಗುರುತು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("발자국"),
            keywords: &["발", "발바닥", "발자국", "족적"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पावला\u{902}च\u{947} ठश\u{947}"),
            keywords: &["कपड\u{947}", "छाप", "ठसो", "पावला\u{902}च\u{947} ठश\u{947}"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("буттун изи"),
            keywords: &["буттун изи", "дене", "из", "кийим"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Foussofdréck"),
            keywords: &["Foussofdrock", "Foussofdréck", "Kleeder", "Ofdrock"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຮອຍຕ\u{eb5}ນ"),
            keywords: &["ຮອຍຕ\u{eb5}ນ", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pėdsakai"),
            keywords: &["drabužiai", "kūnas", "pėdsakai", "pėdsakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pēdu nospiedumi"),
            keywords: &["nospiedumi", "pēdu nospiedumi", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā tapuwae"),
            keywords: &["kākahu", "ngā tapuwae", "tapuwae", "tā"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("отпечатоци од стапала"),
            keywords: &["отпечатоци", "отпечатоци од стапала", "стапало", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ൽപ\u{d4d}പ\u{d3e}ട\u{d4d}"),
            keywords: &[
                "ക\u{d3e}ൽപ\u{d4d}പ\u{d3e}ട\u{d4d}",
                "പ\u{d3e}ട\u{d4d}",
                "പ\u{d3e}ദം",
                "പ\u{d3e}ദമ\u{d41}ദ\u{d4d}ര",
                "മ\u{d41}ദ\u{d4d}ര",
                "വസ\u{d4d}\u{200c}ത\u{d4d}രങ\u{d4d}ങൾ",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөлийн мөр"),
            keywords: &["мөр", "улаан", "хөл", "хөлийн мөр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पावल\u{947}"),
            keywords: &["कपड\u{947}", "ठसा", "पाऊल", "पावल\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jejak kaki"),
            keywords: &["badan", "cetak", "jejak", "jejak kaki", "pakaian"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("marki tas-saqajn"),
            keywords: &["impronta", "ipprintja", "marki tas-saqajn", "ħwejjeġ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခြေရာများ"),
            keywords: &["ခြေရာ", "ခြေရာများ", "အရာ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fotavtrykk"),
            keywords: &["avtrykk", "fot", "fotavtrykk", "fotspor", "kropp", "spor"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ट\u{94d}टाको डोब"),
            keywords: &["कपडा", "ख\u{941}ट\u{94d}टाको डोब", "डोब", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("voetafdrukken"),
            keywords: &["afdruk", "kleding", "voetafdruk", "voetafdrukken"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fotavtrykk"),
            keywords: &["avtrykk", "fot", "fotavtrykk", "fotspor", "kropp", "spor"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଦଚ\u{b3f}ହ\u{b4d}ନଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ପ\u{b3e}ଦ",
                "ପ\u{b3e}ଦଚ\u{b3f}ହ\u{b4d}ନ",
                "ପ\u{b3e}ଦଚ\u{b3f}ହ\u{b4d}ନଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଶରୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ੜਾ\u{a02} ਦ\u{a47} ਨਿਸ\u{a3c}ਾਨ"),
            keywords: &[
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਪ\u{a48}ੜਾ\u{a02}",
                "ਪ\u{a48}ੜਾ\u{a02} ਦ\u{a47} ਨਿਸ\u{a3c}ਾਨ",
                "ਸਰੀਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("پیرا دے نشان"),
            keywords: &["پرنٹ", "پیر دا نشان", "پیرا دے نشان", "کپڑے"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fútmak-dẹm"),
            keywords: &[
                "Fútmak",
                "Fútmak-dẹm",
                "Klọt",
                "Lẹ\u{301}gmak-dẹm",
                "Mak Lẹ\u{301}gmak",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ślady stóp"),
            keywords: &["odciski stóp", "stopy", "ślady", "ślady stóp"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پښو نښي"),
            keywords: &["لباس", "نښه", "پښو نښه", "پښو نښي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pegadas"),
            keywords: &["corpo", "gravura", "pegadas", "pé"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["corpo", "pegada", "pegadas", "pé"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yupinay"),
            keywords: &["p’acha", "yupi", "yupinay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("urme de pași"),
            keywords: &["talpă", "urme de pași", "urmă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-544"),
            keywords: &["E10-544"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("следы"),
            keywords: &["нога", "подошва", "рельеф", "след", "следы", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ahakandagiye ibirenge"),
            keywords: &[
                "ahakandagiye ibirenge",
                "aho ikirenge cyakandaiye",
                "akarango",
                "kwambara",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيرن جا نشان"),
            keywords: &["پير جو نشان", "پيرن جا نشان", "ڇاپو", "ڪپڙا پائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dcf} සලක\u{dd4}ණ\u{dd4}"),
            keywords: &[
                "ඇඳ\u{dd4}ම\u{dca}",
                "ප\u{dcf} සලක\u{dd4}ණ\u{dd4}",
                "ශර\u{dd3}රය",
                "සලක\u{dd4}ණ\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("stopy"),
            keywords: &["stopa", "stopy", "topánka", "šľapaj"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stopinje"),
            keywords: &["oblačila", "odtis", "stopinja", "stopinje", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("raadad"),
            keywords: &["calaamad", "dharka", "raad", "raadad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjurmë këmbësh"),
            keywords: &["gjurmë", "gjurmë këmbe", "gjurmë këmbësh", "trup", "veshje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("отисци стопала"),
            keywords: &["oтисaк", "нoгe", "отисци стопала", "стoпaлa", "тело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["отисци стопала"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("otisci stopala"),
            keywords: &["noge", "otisak", "otisci stopala", "stopala", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["otisci stopala"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fotavtryck"),
            keywords: &["avtryck", "fotavtryck", "fötter"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nyayo"),
            keywords: &["alama", "mavazi", "mwili", "nyayo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}லடித\u{bcd} தடம\u{bcd}"),
            keywords: &[
                "அச\u{bcd}சு",
                "உடை",
                "க\u{bbe}லடித\u{bcd} தடங\u{bcd}கள\u{bcd}",
                "க\u{bbe}லடித\u{bcd} தடம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ల\u{c3f}ముద\u{c4d}రలు"),
            keywords: &[
                "అడుగులు",
                "క\u{c3e}ల\u{c3f} ముద\u{c4d}రలు",
                "క\u{c3e}ల\u{c3f}ముద\u{c4d}రలు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("изҳои пой"),
            keywords: &["изи пой", "изҳои пой", "либос", "чоп кардан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("รอยเท\u{e49}า"),
            keywords: &["รอยเท\u{e49}า", "อว\u{e31}ยวะ", "เท\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýak yzlary"),
            keywords: &["aýak yzlary", "aýak yzy", "eşik", "yz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("topuvaʻe"),
            keywords: &["topuvaʻe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ayak izi"),
            keywords: &["ayak", "ayak izi", "gövde", "iz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئاياغ ئىزى"),
            keywords: &["ئاياغ ئىزى", "ئىز", "كىيىم"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("сліди ніг"),
            keywords: &["відбиток", "нога", "одяг", "слід", "сліди ніг", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("قدموں کے نشانات"),
            keywords: &["جسم", "قدم", "قدموں کے نشانات", "نشان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oyoq izlari"),
            keywords: &["iz", "kiyim", "oyoq izi", "oyoq izlari", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu chân"),
            keywords: &["các dấu chân", "dấu chân", "in dấu", "quần áo"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fu tànk teguwoon"),
            keywords: &["emprime", "fu tànk teguwoon", "màrku-tànk", "yéere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("imizila yeenyawo"),
            keywords: &["imizila yeenyawo", "impahla", "umzila", "umzila weenyawo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ipa ẹsẹ"),
            keywords: &["Ipa ẹsẹ", "aṣọ", "ipasẹ\u{300}", "ìpasẹ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("腳印"),
            keywords: &["印", "服裝", "腳印"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("脚印"),
            keywords: &["印", "服装", "脚印"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("脚印"),
            keywords: &["脚印", "足迹"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("腳印"),
            keywords: &["腳印", "足跡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinsalela zezinyawo"),
            keywords: &[
                "impahla yokugqoka",
                "izinsalela zezinyawo",
                "ukuphrinta",
                "umzimba",
            ],
        },
    ],
};
