#[doc = "🧑\u{200d}⚕\u{fe0f}"]
pub const HEALTH_WORKER: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}⚕\u{fe0f}",
    codepoint: "1F9D1 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "health worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑\u{200d}⚕",
        codepoint: "1F9D1 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "health worker",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gesondheidswerker"),
            keywords: &[
                "dokter",
                "gesondheidsorg",
                "gesondheidswerker",
                "terapeut",
                "verpleegster",
                "verpleër",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጤና ሰራተኛ"),
            keywords: &["የጤና ሰራተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موظف بقطاع الصحة"),
            keywords: &["رعاية صحية", "طبيب", "معالج", "ممرض", "موظف بقطاع الصحة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কৰ\u{9cd}মী"),
            keywords: &[
                "চিকিত\u{9cd}\u{200c}সক",
                "থেৰ\u{9be}পিষ\u{9cd}ট",
                "ন\u{9be}ৰ\u{9cd}চ",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কৰ\u{9cd}মী",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যৰ যতন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tibb işçisi"),
            keywords: &["həkim", "səhiyyə", "terapist", "tibb işçisi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("медыцынскі работнік"),
            keywords: &[
                "ахова здароўя",
                "доктар",
                "медсястра",
                "медыцынскі работнік",
                "тэрапеўт",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("здравен служител"),
            keywords: &[
                "здравен служител",
                "здравеопазване",
                "лекар",
                "медицинска сестра",
                "терапевт",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যকর\u{9cd}মী"),
            keywords: &[
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "থের\u{9be}পিস\u{9cd}ট",
                "ন\u{9be}র\u{9cd}স",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যকর\u{9cd}মী",
                "হেল\u{9cd}থকেয\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zdravstveni radnik"),
            keywords: &[
                "doktor",
                "medicinska sestra",
                "terapeut",
                "zdravstvena njega",
                "zdravstveni radnik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("professional de la salut"),
            keywords: &[
                "doctor",
                "infermer",
                "professional de la salut",
                "salut",
                "terapeuta",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᎯ ᏃᏛᎿᏕᎬᎢ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &["ᎠᎦᎾᎦᏘ", "ᎠᎦᎾᎦᏘ ᎠᏍᏕᎵᏍᎩ", "ᎠᏓᏍᏕᎸᎯᏙᎯ", "ᏙᎯ ᏃᏛᎿᏕᎬᎢ ᏧᎸᏫᏍᏓᏁᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zdravotník/zdravotnice"),
            keywords: &[
                "doktor",
                "doktorka",
                "nemocnice",
                "sestřička",
                "terapeut",
                "terapeutka",
                "zdravotnice",
                "zdravotník",
                "zdravotník/zdravotnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr iechyd"),
            keywords: &[
                "gofal iechyd",
                "gweithiwr iechyd",
                "meddyg",
                "nyrs",
                "therapydd",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("sundhedspersonale"),
            keywords: &[
                "doktor",
                "læge",
                "specialist",
                "sundhed",
                "sundhedspersonale",
                "sundhedsvæsenet",
                "sygeplejerske",
                "terapeut",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Arzt/Ärztin"),
            keywords: &[
                "Arzt",
                "Arzt/Ärztin",
                "Gesundheitswesen",
                "Krankenschwester",
                "Therapeut",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργαζόμενος του τομέα υγείας"),
            keywords: &[
                "γιατρός",
                "εργαζόμενος του τομέα υγείας",
                "θεραπευτής",
                "ιατροφαρμακευτική περίθαλψη",
                "νοσοκόμος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("health worker"),
            keywords: &[
                "doctor",
                "health worker",
                "healthcare",
                "nurse",
                "therapist",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "care",
                "doctor",
                "health",
                "health worker",
                "healthcare",
                "nurse",
                "therapist",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional sanitario"),
            keywords: &[
                "doctor",
                "enfermero",
                "médico",
                "profesional sanitario",
                "salud",
                "terapeuta",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tervishoiutöötaja"),
            keywords: &[
                "arst",
                "meditsiiniõde",
                "terapeut",
                "tervishoid",
                "tervishoiutöötaja",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sendagilea"),
            keywords: &["erizain", "osasun", "sendagile", "sendagilea", "terapeuta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مأمور بهداشت"),
            keywords: &[
                "درمانگر",
                "مأمور بهداشت",
                "مراقبت بهداشتی",
                "پرستار",
                "پزشک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hoitotyöntekijä"),
            keywords: &[
                "hoitotyöntekijä",
                "lääkäri",
                "sairaanhoitaja",
                "terapeutti",
                "terveydenhoito",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("health worker"),
            keywords: &["doktor", "health worker", "healthcare", "nars", "therapist"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heilsuverkfrøðingur"),
            keywords: &[
                "heilsuverkfrøðingur",
                "lekifrøðingur",
                "lækni",
                "sjúkrarøktarfrøðingur",
                "sjúkrasystir",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("professionnel de la santé (tous genres)"),
            keywords: &[
                "docteur",
                "infirmier",
                "médecin",
                "professionnel de la santé (tous genres)",
                "santé",
                "thérapeute",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("professionnel de la santé"),
            keywords: &[
                "docteur",
                "infirmier",
                "médecin",
                "professionnel de la santé",
                "professionnel de la santé (tous genres)",
                "santé",
                "thérapeute",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí sláinte"),
            keywords: &["oibrí sláinte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-slàinte"),
            keywords: &[
                "altram",
                "banaltram",
                "cùram-slàinte",
                "dotair",
                "leasaiche",
                "lighiche",
                "nurs",
                "obraiche-slàinte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa sanitaria"),
            keywords: &[
                "enfermeiro",
                "home",
                "médico",
                "persoa sanitaria",
                "sanitario",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આરોગ\u{acd}ય કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "આરોગ\u{acd}ય કાર\u{acd}યકર\u{acd}તા",
                "આરોગ\u{acd}યસ\u{a82}ભાળ",
                "ઉપચારક",
                "ડૉક\u{acd}ટર",
                "નર\u{acd}સ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עובד בשירותי הבריאות"),
            keywords: &[
                "אח",
                "דוקטור",
                "מטפל",
                "עובד בשירותי הבריאות",
                "רופא",
                "תרפיסט",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}वास\u{94d}थ\u{94d}य कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "डॉक\u{94d}टर",
                "थ\u{948}र\u{947}पिस\u{94d}ट",
                "नर\u{94d}स",
                "स\u{94d}वास\u{94d}थ\u{94d}य कार\u{94d}यकर\u{94d}ता",
                "स\u{94d}वास\u{94d}थ\u{94d}य द\u{947}खभाल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zdravstveni djelatnik"),
            keywords: &[
                "liječnik",
                "medicinska sestra",
                "terapeut",
                "zdravstveni djelatnik",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("egészségügyi dolgozó"),
            keywords: &[
                "egészségügy",
                "egészségügyi dolgozó",
                "orvos",
                "terapeuta",
                "ápolónő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բուժաշխատող"),
            keywords: &["առողջապահություն", "բժիշկ", "բուժաշխատող", "բուժքույր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("petugas kesehatan"),
            keywords: &[
                "dokter",
                "perawat",
                "perawatan kesehatan",
                "petugas kesehatan",
                "terapis",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heilbrigðisstarfsmaður"),
            keywords: &[
                "heilbrigðismál",
                "heilbrigðisstarfsmaður",
                "hjúkrunarfræðingur",
                "læknir",
                "sérfræðingur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che lavora nella sanità"),
            keywords: &[
                "infermiera",
                "infermiere",
                "medico",
                "persona che lavora nella sanità",
                "sanità",
                "terapista",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("医者"),
            keywords: &["セラピスト", "医師", "医者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mantri"),
            keywords: &[
                "dokter",
                "mantri",
                "parumatan kasehatan",
                "perawat",
                "terapis",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯანდაცვის თანამშრომელი"),
            keywords: &[
                "ექთანი",
                "ექიმი",
                "თერაპევტი",
                "ჯანდაცვა",
                "ჯანდაცვის თანამშრომელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("медициналық қызметкер"),
            keywords: &[
                "денсаулық сақтау",
                "дәрігер",
                "медбике",
                "медициналық қызметкер",
                "терапевт",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}នាក\u{17cb}ងារស\u{17bb}ខភាព"),
            keywords: &[
                "ការថែទា\u{17c6}ស\u{17bb}ខភាព",
                "គ\u{17b7}លាន\u{17bb}បដ\u{17d2}ឋាក",
                "គ\u{17d2}រ\u{17bc}ពេទ\u{17d2}យ",
                "ភ\u{17d2}នាក\u{17cb}ងារស\u{17bb}ខភាព",
                "វេជ\u{17d2}ជបណ\u{17d2}ឌ\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಆರೋಗ\u{ccd}ಯ ಸಹಾಯಕ"),
            keywords: &[
                "ಆರೋಗ\u{ccd}ಯ ಕಾಳಜ\u{cbf}",
                "ಆರೋಗ\u{ccd}ಯ ಸಹಾಯಕ",
                "ಚ\u{cbf}ಕ\u{cbf}ತ\u{ccd}ಸಕ",
                "ದಾದ\u{cbf}",
                "ವೈದ\u{ccd}ಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("의료인"),
            keywords: &["간호사", "의료", "의료인", "의사", "테라피스트"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भलायकी कर\u{94d}मचारी"),
            keywords: &[
                "थ\u{945}रापिस\u{94d}ट",
                "दोतोर",
                "नर\u{94d}स",
                "भलायकी कर\u{94d}मचारी",
                "भलायकी जतन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("медицина кызматкери"),
            keywords: &["медицина кызматкери"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{eb1}ກງານກວດສ\u{eb8}ຂະພາບ"),
            keywords: &[
                "ການເບ\u{eb4}\u{ec8}ງແຍງສ\u{eb8}ຂະພາບ",
                "ທ\u{ec8}ານໝ\u{ecd}",
                "ນ\u{eb1}ກບ\u{ecd}າບ\u{eb1}ດ",
                "ພະຍາບານ",
                "ພະນ\u{eb1}ກງານກວດສ\u{eb8}ຂະພາບ",
                "ພະນ\u{eb1}ກງານສາທາລະນະສ\u{eb8}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sveikatos darbuotojas"),
            keywords: &[
                "gydytojas",
                "slaugymas",
                "sveikatos darbuotojas",
                "sveikatos priežiūra",
                "terapistas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("veselības aprūpes darbinieks"),
            keywords: &[
                "medmāsa",
                "veselības aprūpe",
                "veselības aprūpes darbinieks",
                "ārsts",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("здравствен работник"),
            keywords: &[
                "доктор",
                "здравствен работник",
                "здравство",
                "медицинска сестра",
                "терапевт",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആരോഗ\u{d4d}യ സേവകൻ"),
            keywords: &[
                "ആരോഗ\u{d4d}യ സേവകൻ",
                "ആരോഗ\u{d4d}യരക\u{d4d}ഷ",
                "ഡോക\u{d4d}ടർ",
                "തെറ\u{d3e}പ\u{d4d}പിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "നഴ\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрүүл мэндийн ажилтан"),
            keywords: &[
                "засалч",
                "сувилагч",
                "эмч",
                "эрүүл мэнд",
                "эрүүл мэндийн ажилтан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आरोग\u{94d}याविषयक कार\u{94d}य करणारी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "आरोग\u{94d}यदक\u{94d}षता",
                "आरोग\u{94d}याविषयक कार\u{94d}य करणारी व\u{94d}यक\u{94d}ती",
                "उपचारतज\u{94d}ञ",
                "डॉक\u{94d}टर",
                "परिचारिका",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja kesihatan"),
            keywords: &[
                "ahli terapi",
                "doktor",
                "jururawat",
                "pekerja kesihatan",
                "penjagaan kesihatan",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျန\u{103a}းမာရေးလ\u{102f}ပ\u{103a}သား"),
            keywords: &[
                "ကျန\u{103a}းမာရေးစောင\u{1037}\u{103a}ရ\u{103e}ောက\u{103a}မ\u{103e}\u{102f}",
                "ကျန\u{103a}းမာရေးလ\u{102f}ပ\u{103a}သား",
                "ဆရာဝန\u{103a}",
                "သ\u{1030}နာပြ\u{102f}",
                "အထ\u{1030}းက\u{102f} ဆရာဝန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("helsearbeider"),
            keywords: &[
                "doktor",
                "helsearbeider",
                "helsevesen",
                "lege",
                "sykepleier",
                "terapeut",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{94d}वास\u{94d}थ\u{94d}यकर\u{94d}मी"),
            keywords: &[
                "डाक\u{94d}टर",
                "थ\u{947}रापिस\u{94d}ट",
                "नर\u{94d}स",
                "स\u{94d}वास\u{94d}थ\u{94d}य स\u{94d}याहार",
                "स\u{94d}वास\u{94d}थ\u{94d}यकर\u{94d}मी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezondheidsmedewerker"),
            keywords: &[
                "dokter",
                "gezondheidsmedewerker",
                "gezondheidszorg",
                "therapeut",
                "verpleegster",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("helsearbeidar"),
            keywords: &[
                "dokter",
                "helsearbeidar",
                "helsevesen",
                "lege",
                "sjukepleiar",
                "terapaut",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟ କର\u{b4d}ମୀ"),
            keywords: &[
                "ଚ\u{b3f}କ\u{b3f}ତ\u{b4d}ସକ",
                "ଡ\u{b3c}\u{b3e}କ\u{b4d}ତର",
                "ସେବ\u{b3f}କ\u{b3e}",
                "ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟ କର\u{b4d}ମୀ",
                "ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟଯତ\u{b4d}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿਹਤਕਰਮੀ"),
            keywords: &[
                "ਡਾਕਟਰ",
                "ਥ\u{a48}ਰ\u{a47}ਪਿਸਟ",
                "ਨਰਸ ਸਿਹਤ ਸ\u{a70}ਭਾਲ",
                "ਸਿਹਤ ਸ\u{a70}ਭਾਲ",
                "ਸਿਹਤਕਰਮੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}ka Fọ Wiá Dẹm De Lúk Áftá Sík Pípul"),
            keywords: &[
                "Dọ\u{301}ktọ",
                "Nọs",
                "To Lúk Áftá Sík Pípul",
                "Wọ\u{301}ka Fọ Wiá Dẹm De Lúk Áftá Sík Pípul",
                "Ẹ\u{301}spat Dọ\u{301}ktọ Fọ Síknẹs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pracownik służby zdrowia"),
            keywords: &[
                "lekarz",
                "opieka zdrowotna",
                "pracownik służby zdrowia",
                "terapeuta",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("روغتيايي کارمند"),
            keywords: &["تهراپسټ", "روغتيا ساتنه", "روغتيايي کارمند", "نرس", "ډاکټر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("profissional de saúde"),
            keywords: &[
                "cuidados de saúde",
                "enfermeira",
                "médico",
                "profissional de saúde",
                "terapeuta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "cuidados de saúde",
                "enfermeira",
                "enfermeiro",
                "médica",
                "médico",
                "profissional de saúde",
                "terapeuta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qhali kaywan llamkaq"),
            keywords: &[
                "enfermera",
                "hanpiq",
                "qhali kay",
                "qhali kaywan llamkaq",
                "terapista",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană lucrătoare în domeniul sănătății"),
            keywords: &[
                "asistentă",
                "doctor",
                "medic",
                "persoană lucrătoare în domeniul sănătății",
                "soră medicală",
                "terapeut",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-007"),
            keywords: &["E13-007"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("медицинский работник"),
            keywords: &[
                "врач",
                "доктор",
                "медбрат",
                "медицина",
                "медицинский работник",
                "медсестра",
                "терапевт",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيلٿ ورڪر"),
            keywords: &["نرس", "هيلٿ ورڪر", "هيلٿ ڪيئر", "ٿيراپسٽ", "ڊاڪٽر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සෞඛ\u{dca}\u{200d}ය සේවකය\u{dcf}"),
            keywords: &[
                "ච\u{dd2}ක\u{dd2}ත\u{dca}සක",
                "දොස\u{dca}තර",
                "සෞඛ\u{dca}\u{200d}ය සේවකය\u{dcf}",
                "සෞඛ\u{dca}\u{200d}ය සේව\u{dcf}",
                "හෙද\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdravotník"),
            keywords: &["doktor", "lekár", "medik", "nemocnica", "zdravotník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("delavec v zdravstvu"),
            keywords: &[
                "delavec v zdravstvu",
                "medicinska sestra",
                "terapevt",
                "zdravnik",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaqaale caafimaad"),
            keywords: &[
                "dhaqtar, shaqaale caafimaad, daryeel caafimaad, kalkaaliso, daweeyaha",
                "shaqaale caafimaad",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person punonjës shëndetësor"),
            keywords: &[
                "doktor",
                "infermier",
                "person punonjës shëndetësor",
                "punonjës shëndetësor",
                "shëndetësi",
                "terapeut",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("здравствени радник"),
            keywords: &[
                "доктор",
                "здравствени радник",
                "здравство",
                "лекар",
                "медицинска сестра",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["здравствени радник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zdravstveni radnik"),
            keywords: &[
                "doktor",
                "lekar",
                "medicinska sestra",
                "zdravstveni radnik",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zdravstveni radnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("läkare"),
            keywords: &[
                "läkare",
                "sjuksköterska",
                "sjukvård",
                "terapeut",
                "vårdpersonal",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mhudumu wa afya"),
            keywords: &[
                "daktari",
                "huduma ya afya",
                "mhudumu wa afya",
                "muuguzi",
                "tabibu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சுக\u{bbe}த\u{bbe}ர பணிய\u{bbe}ளர\u{bcd}"),
            keywords: &[
                "சிகிச\u{bcd}சை அளிப\u{bcd}பவர\u{bcd}",
                "சுக\u{bbe}த\u{bbe}ர பணிய\u{bbe}ளர\u{bcd}",
                "செவிலியர\u{bcd}",
                "மருத\u{bcd}துவ சேவை",
                "மருத\u{bcd}துவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c48}ద\u{c4d}య సహ\u{c3e}యకులు"),
            keywords: &[
                "ఆర\u{c4b}గ\u{c4d}య సంరక\u{c4d}షణ",
                "నర\u{c4d}స\u{c4d}",
                "వ\u{c48}ద\u{c4d}య సహ\u{c3e}యకులు",
                "వ\u{c48}ద\u{c4d}యుర\u{c3e}లు",
                "వ\u{c48}ద\u{c4d}యులు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมอ"),
            keywords: &[
                "น\u{e31}กบำบ\u{e31}ด",
                "พยาบาล",
                "หมอ",
                "เจ\u{e49}าหน\u{e49}าท\u{e35}\u{e48}อนาม\u{e31}ย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saglyk işgäri"),
            keywords: &[
                "lukman",
                "saglygy goraýyş",
                "saglyk işgäri",
                "terapewt",
                "şepagat uýasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("neesi"),
            keywords: &["neesi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağlık çalışanı"),
            keywords: &[
                "doktor",
                "hasta bakıcı",
                "hemşire",
                "sağlık personeli",
                "sağlık çalışanı",
                "terapist",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("медик"),
            keywords: &["лікар", "медик", "медицина", "медсестра", "терапевт"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہیلتھ ورکر"),
            keywords: &["تھیراپسٹ", "نرس", "ڈاکٹر", "ہیلتھ ورکر", "ہیلتھ کیئر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tibbiyot xodimi"),
            keywords: &[
                "doktor",
                "hamshira",
                "shifokor",
                "sogʻliqni saqlash",
                "tibbiyot xodimi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân viên y tế"),
            keywords: &[
                "bác sĩ",
                "chăm sóc sức khỏe",
                "nhà trị liệu",
                "nhân viên y tế",
                "y tá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("保健員"),
            keywords: &["保健員", "治療師", "護士", "醫生", "醫療保健"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("保健员"),
            keywords: &["保健员", "医生", "医疗保健", "护士", "治疗师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("卫生工作者"),
            keywords: &["医生", "卫生工作者", "护士", "治疗师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("醫護人員"),
            keywords: &["治療", "護士", "醫生", "醫護", "醫護人員"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wezempilo"),
            keywords: &[
                "uchwepheshe",
                "udokotela",
                "ukunakekela kwezempilo",
                "umsebenzi wezempilo",
                "unesi",
            ],
        },
    ],
};
#[doc = "🧑🏻\u{200d}⚕\u{fe0f}"]
pub const HEALTH_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}⚕\u{fe0f}",
    codepoint: "1F9D1 1F3FB 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "health worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏻\u{200d}⚕",
        codepoint: "1F9D1 1F3FB 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "health worker: light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}⚕\u{fe0f}"]
pub const HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}⚕\u{fe0f}",
    codepoint: "1F9D1 1F3FC 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "health worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏼\u{200d}⚕",
        codepoint: "1F9D1 1F3FC 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "health worker: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}⚕\u{fe0f}"]
pub const HEALTH_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}⚕\u{fe0f}",
    codepoint: "1F9D1 1F3FD 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "health worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏽\u{200d}⚕",
        codepoint: "1F9D1 1F3FD 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "health worker: medium skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}⚕\u{fe0f}"]
pub const HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}⚕\u{fe0f}",
    codepoint: "1F9D1 1F3FE 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "health worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏾\u{200d}⚕",
        codepoint: "1F9D1 1F3FE 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "health worker: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}⚕\u{fe0f}"]
pub const HEALTH_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}⚕\u{fe0f}",
    codepoint: "1F9D1 1F3FF 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "health worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏿\u{200d}⚕",
        codepoint: "1F9D1 1F3FF 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "health worker: dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨\u{200d}⚕\u{fe0f}"]
pub const MAN_HEALTH_WORKER: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}⚕\u{fe0f}",
    codepoint: "1F468 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man health worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨\u{200d}⚕",
        codepoint: "1F468 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man health worker",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike gesondheidswerker"),
            keywords: &[
                "dokter",
                "man",
                "manlike gesondheidswerker",
                "medies",
                "mediese sorg",
                "mediese werker",
                "terapeut",
                "verpleër",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ነርስ"),
            keywords: &["ሐኪም", "ተባዕት", "ቴራፒስት", "ነርስ", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عامل بقطاع الصحة"),
            keywords: &["رعاية صحية", "طبيب", "عامل بقطاع الصحة", "معالج", "ممرض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কৰ\u{9cd}মচ\u{9be}ৰী"),
            keywords: &[
                "চিকিৎসক",
                "থেৰ\u{9be}পিষ\u{9cd}ট",
                "ন\u{9be}ৰ\u{9cd}চ",
                "প\u{9c1}ৰ\u{9c1}ষ স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কৰ\u{9cd}মচ\u{9be}ৰী",
                "ম\u{9be}ন\u{9c1}হ",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যৰ যতন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi həkim"),
            keywords: &["həkim", "kişi", "səhiyyə", "terapevt", "xəstə baxıcısı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("доктар"),
            keywords: &["ахова здароўя", "доктар", "мужчына", "тэрапеўт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("здравен работник"),
            keywords: &[
                "доктор",
                "здравен работник",
                "здравна система",
                "лекар",
                "мъж",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কর\u{9cd}মী"),
            keywords: &[
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "থের\u{9be}পিস\u{9cd}ট",
                "ন\u{9be}র\u{9cd}স",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কর\u{9cd}মী",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য পরিচর\u{9cd}য\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zdravstveni radnik muškarac"),
            keywords: &[
                "doktor",
                "liječnik",
                "ljekar",
                "medicinski tehničar",
                "zdravstveni radnik",
                "zdravstveni radnik muškarac",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home professional de la salut"),
            keywords: &[
                "doctor",
                "home professional de la salut",
                "infermer",
                "masculí",
                "metge",
                "salut",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏙᎯᏃᏛᎿᏕᎬᎢ ᎤᎦᏎᏍᏗ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᎦᎾᎦᏘ",
                "ᎠᏍᎦᏯ",
                "ᎠᏍᎦᏯ ᏙᎯᏃᏛᎿᏕᎬᎢ ᎤᎦᏎᏍᏗ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᎠᏓᏍᏕᎸᎯᏙᎯ",
                "ᎦᎾᎦᏘ ᎠᏍᏕᎵᏍᎩ",
                "ᏙᎯᏃᏛᎿᏕᎬᎢ ᎤᎦᏎᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zdravotník"),
            keywords: &["doktor", "nemocnice", "terapeut", "zdravotník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr iechyd gwrywaidd"),
            keywords: &[
                "gofal iechyd",
                "gweithiwr iechyd gwrywaidd",
                "gwrywaidd",
                "meddyg",
                "nyrs",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig sundhedsperson"),
            keywords: &[
                "kittel",
                "læge",
                "mand",
                "mandlig sundhedsperson",
                "sygeplejerske",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Arzt"),
            keywords: &["Arzt", "Arztkittel", "Doktor"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργαζόμενος στην υγεία"),
            keywords: &[
                "γιατρός",
                "εργαζόμενος στην υγεία",
                "νοσηλευτής",
                "νοσοκόμος",
                "υγεία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man health worker"),
            keywords: &[
                "doctor",
                "healthcare",
                "man",
                "man health worker",
                "nurse",
                "therapist",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "doctor",
                "health care",
                "man",
                "man health worker",
                "nurse",
                "therapist",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional sanitario hombre"),
            keywords: &[
                "doctor",
                "enfermero",
                "médico",
                "profesional sanitario hombre",
                "sanitario",
                "terapeuta hombre",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "doctor",
                "enfermero",
                "médico",
                "profesional sanitario hombre",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesarst"),
            keywords: &["arst", "meditsiin", "meditsiiniõde", "mees", "meesarst"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon sendagilea"),
            keywords: &[
                "erizaina",
                "gizon",
                "gizon sendagilea",
                "gizonezko",
                "osasun",
                "sendagile",
                "terapeuta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مددکار بهداشت مرد"),
            keywords: &[
                "مددکار",
                "مددکار بهداشت",
                "مددکار بهداشت آقا",
                "مددکار بهداشت مرد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mieshoitotyöntekijä"),
            keywords: &[
                "lääkäri",
                "mies",
                "mieshoitotyöntekijä",
                "sairaanhoitaja",
                "terapeutti",
                "terveydenhuolto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking health worker"),
            keywords: &[
                "doktor",
                "health worker",
                "lalaki",
                "lalaking health worker",
                "nars",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur lækni"),
            keywords: &[
                "heilsurøkt",
                "lækni",
                "mannligur lækni",
                "maður",
                "sjúkrarøktarfrøðingur",
                "sjúkrasystir",
                "terapevtur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("professionnel de la santé"),
            keywords: &[
                "docteur",
                "homme",
                "infirmier",
                "professionnel de la santé",
                "santé",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("professionnel de la santé homme"),
            keywords: &[
                "docteur",
                "homme",
                "infirmier",
                "professionnel de la santé",
                "professionnel de la santé homme",
                "santé",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí sláinte fireann"),
            keywords: &[
                "altra",
                "cúram sláinte",
                "dochtúir",
                "fear",
                "oibrí sláinte fireann",
                "teiripeoir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-slàinte fireann"),
            keywords: &[
                "cùram-slàinte",
                "dotair",
                "duine",
                "fear",
                "fireannach",
                "leasaiche",
                "lighiche",
                "neach-altraim",
                "nurs",
                "obraiche-slàinte fireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("traballador sanitario"),
            keywords: &["enfermeiro", "home", "médico", "traballador sanitario"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ આરોગ\u{acd}ય કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "આરોગ\u{acd}યસ\u{a82}ભાળ",
                "ઉપચારક",
                "ડૉક\u{acd}ટર",
                "નર\u{acd}સ",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ આરોગ\u{acd}ય કાર\u{acd}યકર\u{acd}તા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum ma’aikacin kula da lafiya"),
            keywords: &[
                "kula da lafiya",
                "likita",
                "mai ba da kula",
                "mutum",
                "mutum ma’aikacin kula da lafiya",
                "nas",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רופא"),
            keywords: &["אח", "איש", "דוקטור", "מטפל", "רופא", "שירותי בריאות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष स\u{94d}वास\u{94d}थ\u{94d}य कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "चिकित\u{94d}सक",
                "डॉक\u{94d}टर",
                "नर\u{94d}स",
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष स\u{94d}वास\u{94d}थ\u{94d}य कार\u{94d}यकर\u{94d}ता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("liječnik"),
            keywords: &["bolničar", "doktor", "liječnik", "terapeut"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("doktor"),
            keywords: &["doktor", "orvos", "terapeuta", "ápoló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բժիշկ"),
            keywords: &["առողջապահություն", "բժիշկ", "բժշկություն", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja kesehatan pria"),
            keywords: &[
                "dokter",
                "laki-laki",
                "pekerja kesehatan pria",
                "perawatan kesehatan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke ọrụ ahụike"),
            keywords: &[
                "dọkịta",
                "nletaahụike",
                "nwoke",
                "nwoke ọrụ ahụike",
                "nọọsụ",
                "onye dọkịta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns heilbrigðisstarfsmaður"),
            keywords: &[
                "heilsa",
                "hjúkrunarfræðingur",
                "karl",
                "karlkyns heilbrigðisstarfsmaður",
                "læknir",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("operatore sanitario"),
            keywords: &[
                "camice",
                "dottore",
                "operatore sanitario",
                "ospedale",
                "uomo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性の医者"),
            keywords: &["医師", "医者", "男", "男性", "男性の医者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mantri lanang"),
            keywords: &[
                "dokter",
                "mantri lanang",
                "parumatan kasehatan",
                "perawat",
                "terapis",
                "wong lanang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ექიმი კაცი"),
            keywords: &["ექთანი", "ექიმი", "თერაპევტი", "კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дәрігер"),
            keywords: &["денсаулық", "дәрігер", "ер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mandlig sundhedsperson"),
            keywords: &[
                "kittel",
                "læge",
                "mand",
                "mandlig sundhedsperson",
                "sygeplejerske",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេទ\u{17d2}យប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ការថែទា\u{17c6}ស\u{17bb}ខភាព",
                "គ\u{17b7}លាន\u{17bb}បដ\u{17d2}ឋាក",
                "គ\u{17d2}រ\u{17bc}ពេទ\u{17d2}យ",
                "ប\u{17d2}រ\u{17bb}ស",
                "ពេទ\u{17d2}យប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಆರೋಗ\u{ccd}ಯಾಧ\u{cbf}ಕಾರ\u{cbf}"),
            keywords: &[
                "ಆರೋಗ\u{ccd}ಯ ರಕ\u{ccd}ಷಣ\u{cc6}",
                "ಚ\u{cbf}ಕ\u{cbf}ತ\u{ccd}ಸಕ",
                "ಪುರುಷ",
                "ಪುರುಷ ಆರೋಗ\u{ccd}ಯಾಧ\u{cbf}ಕಾರ\u{cbf}",
                "ವೈದ\u{ccd}ಯರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 의료인"),
            keywords: &[
                "간호사",
                "남자",
                "의료",
                "의료인",
                "의료진",
                "의사",
                "진료",
                "테라피스트",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो भलायकी कर\u{94d}मचारी"),
            keywords: &[
                "थ\u{945}रापिस\u{94d}ट",
                "दादलो",
                "दादलो भलायकी कर\u{94d}मचारी",
                "दादलो भलायकी कामगार",
                "दोतोर",
                "नर\u{94d}स",
                "भलायकी जतन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек медицина кызматкери"),
            keywords: &[
                "доктор",
                "медага",
                "саламаттыкты сактоо",
                "терапевт",
                "эркек доктор",
                "эркек медицина кызматкери",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Medeziner"),
            keywords: &[
                "Dokter",
                "Gesondheet",
                "Infirmier",
                "Mann",
                "Medeziner",
                "Therapeut",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດວຽກສ\u{eb8}ຂະພາບ"),
            keywords: &[
                "ບຳບ\u{eb1}ດ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດວຽກສ\u{eb8}ຂະພາບ",
                "ພະຍາບານ",
                "ສ\u{eb8}ຂະພາບ",
                "ແພດ",
                "ໝ\u{ecd}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("medikas"),
            keywords: &[
                "gydytojas",
                "medikas",
                "slaugytojas",
                "sveikata",
                "terapeutas",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("veselības aprūpes speciālists"),
            keywords: &[
                "brālītis",
                "dakteris",
                "terapeits",
                "veselības aprūpes speciālists",
                "vīrietis",
                "ārsts",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaimahi hauora tāne"),
            keywords: &[
                "atawhai hauora",
                "kaimahi hauora tāne",
                "kaiwhakaora",
                "rata",
                "tapuhi",
                "tāne",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("доктор"),
            keywords: &["доктор", "здравство", "машко", "терапевт"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആരോഗ\u{d4d}യ പ\u{d4d}രവർത\u{d4d}തകൻ"),
            keywords: &[
                "ആരോഗ\u{d4d}യ പ\u{d4d}രവർത\u{d4d}തകൻ",
                "ആരോഗ\u{d4d}യപ\u{d3e}ലനം",
                "ഡോക\u{d4d}ടർ",
                "നഴ\u{d4d}സ\u{d4d}",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй эрүүл мэндийн ажилтан"),
            keywords: &[
                "сувилагч",
                "эмч",
                "эрэгтэй",
                "эрэгтэй эрүүл мэндийн ажилтан",
                "эрүүл мэнд",
                "эрүүл мэндийн эрэгтэй ажилтан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{941}ष आरोग\u{94d}य कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "आरोग\u{94d}यदक\u{94d}षता",
                "उपचारतज\u{94d}ञ",
                "डॉक\u{94d}टर",
                "परिचारिका",
                "प\u{941}र\u{941}ष आरोग\u{94d}य कार\u{94d}यकर\u{94d}ता",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष आरोग\u{94d}य कार\u{94d}यकर\u{94d}ता",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja kesihatan lelaki"),
            keywords: &[
                "ahli terapi",
                "doktor",
                "jururawat",
                "lelaki",
                "pekerja kesihatan lelaki",
                "penjagaan kesihatan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħaddiem fil-kura tal-bniedem"),
            keywords: &[
                "bniedem",
                "infermiera",
                "kura tas-saħħa",
                "tabib",
                "terapista",
                "ħaddiem fil-kura tal-bniedem",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား ကျန\u{103a}းမာရေးလ\u{102f}ပ\u{103a}သား"),
            keywords: &[
                "ကျန\u{103a}းမာရေး စောင\u{1037}\u{103a}ရ\u{103e}ောက\u{103a}မ\u{103e}\u{102f}",
                "ဆရာဝန\u{103a}",
                "သ\u{1030}နာပြ\u{102f}",
                "အထ\u{1030}းက\u{102f} ဆရာဝန\u{103a}",
                "အမျ\u{102d}\u{102f}းသား ကျန\u{103a}းမာရေးလ\u{102f}ပ\u{103a}သား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig helsearbeider"),
            keywords: &[
                "doktor",
                "helsevesen",
                "lege",
                "mann",
                "mannlig helsearbeider",
                "sykepleier",
                "terapeut",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष स\u{94d}वास\u{94d}थ\u{94d}यकर\u{94d}मी"),
            keywords: &[
                "चिकित\u{94d}सक",
                "छोरामान\u{94d}छ\u{947}",
                "थ\u{947}रापिस\u{94d}ट",
                "नर\u{94d}स",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष स\u{94d}वास\u{94d}थ\u{94d}यकर\u{94d}मी",
                "स\u{94d}वास\u{94d}थ\u{94d}यको ह\u{947}रविचार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke gezondheidsmedewerker"),
            keywords: &[
                "dokter",
                "gezondheidszorg",
                "man",
                "mannelijke gezondheidsmedewerker",
                "therapeut",
                "verpleger",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg helsearbeidar"),
            keywords: &[
                "dokter",
                "helsevesen",
                "lege",
                "mann",
                "mannleg helsearbeidar",
                "sjukepleiar",
                "terapeut",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟ କର\u{b4d}ମୀ"),
            keywords: &[
                "ଡ\u{b3e}କ\u{b4d}ତର",
                "ଥେର\u{b3e}ପ\u{b3f}ଷ\u{b4d}ଟ",
                "ନର\u{b4d}ସ\u{b4d}\u{200c}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟ କର\u{b4d}ମୀ",
                "ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟସେବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਸਿਹਤ ਵਰਕਰ"),
            keywords: &[
                "ਚਿਕਿਤਸਕ",
                "ਡਾਕਟਰ",
                "ਨਰਸ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਸਿਹਤ ਵਰਕਰ",
                "ਬ\u{a70}ਦਾ",
                "ਸਿਹਤ-ਸ\u{a70}ਭਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("صحت تے کم کرن آلا بندہ"),
            keywords: &[
                "بندہ",
                "صحت تے کم کرن آلا بندہ",
                "طبیب",
                "ماہر معالجیات",
                "نرس",
                "نگہداشت\u{650} صحت",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wọ\u{301}kman Fọ Wiá Dẹm De Lúk Áftá Sík Pípul"),
            keywords: &[
                "Dọ\u{301}ktọ",
                "Man",
                "Man Wé De Wọ\u{301}k Wiá Dẹm De Lúk Áftá Sík Pípul",
                "Nọs",
                "To Lúk Áftá Sík Pípul",
                "Wọ\u{301}kman Fọ Wiá Dẹm De Lúk Áftá Sík Pípul",
                "Ẹ\u{301}spat Dọ\u{301}ktọ Fọ Síknẹs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lekarz"),
            keywords: &["lekarz", "mężczyzna", "terapeuta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی روغتيايي کارکوونکی"),
            keywords: &[
                "تهراپسټ",
                "د روغتيا پاملرنه",
                "سړی روغتيايي کارکوونکی",
                "نرس",
                "ډاکټر",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem profissional da saúde"),
            keywords: &[
                "doutor",
                "enfermeiro",
                "homem",
                "homem profissional da saúde",
                "médico",
                "saúde",
                "terapeuta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("profissional de saúde (homem)"),
            keywords: &[
                "doutor",
                "enfermeiro",
                "homem",
                "médico",
                "profissional da saúde (homem)",
                "profissional da área da saúde",
                "profissional de saúde (homem)",
                "saúde",
                "terapeuta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata qhali kaywan llamkaq"),
            keywords: &[
                "enfermera",
                "hanpiq",
                "qhali kay",
                "tata",
                "tata qhali kaywan llamkaq",
                "terapista",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lucrător în domeniul sănătății"),
            keywords: &[
                "bărbat",
                "doctor",
                "infirmier",
                "lucrător în domeniul sănătății",
                "servicii medicale",
                "terapeut",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1158"),
            keywords: &["E10-1158"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("врач"),
            keywords: &["врач", "доктор", "медбрат", "мужчина", "терапевт"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo muzima w’umukozi"),
            keywords: &[
                "dogiteri",
                "ubuvuzi",
                "umuforomokazi",
                "umugabo",
                "umugabo muzima w’umukozi",
                "umuvuzi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو صحت خدمتگار"),
            keywords: &[
                "ماڻهو صحت خدمتگار",
                "ماڻهو، صحت جو خيال، ڊاڪٽر، نرس، ٿراپسٽ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දොස\u{dca}තර"),
            keywords: &[
                "ච\u{dd2}ක\u{dd2}ත\u{dca}සක",
                "දොස\u{dca}තර",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "ස\u{dcf}ත\u{dca}ත\u{dd4}ක\u{dcf}රය\u{dcf}",
                "සෞඛ\u{dca}\u{200d}යය සත\u{dca}ක\u{dcf}ර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdravotník muž"),
            keywords: &["doktor", "lekár", "muž", "nemocnica", "zdravotník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zdravstveni delavec"),
            keywords: &[
                "fant",
                "medicinski tehnik",
                "moški",
                "terapevt",
                "zdravnik",
                "zdravstveni delavec",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin shaqaale caafimaad ah"),
            keywords: &[
                "daryeel caafimaad",
                "daweeye",
                "dhakhtar",
                "kalkaaliye",
                "nin",
                "nin shaqaale caafimaad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("punonjës shëndetësor"),
            keywords: &[
                "burrë",
                "doktor",
                "infermier",
                "kujdes mjekësor",
                "punonjës shëndetësor",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац здравствени радник"),
            keywords: &[
                "доктор",
                "здравствени радник",
                "здравство",
                "лекар",
                "мушкарац",
                "мушкарац здравствени радник",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушкарац здравствени радник"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac zdravstveni radnik"),
            keywords: &[
                "doktor",
                "lekar",
                "muškarac",
                "muškarac zdravstveni radnik",
                "zdravstveni radnik",
                "zdravstvo",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muškarac zdravstveni radnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig läkare"),
            keywords: &["doktor", "hälsovård", "läkare", "man", "manlig", "skötare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mhudumu wa afya wa kiume"),
            keywords: &[
                "daktari",
                "mganga",
                "mhudumu wa afya wa kiume",
                "muuguzi",
                "tabibu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} மருத\u{bcd}துவர\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "ட\u{bbe}க\u{bcd}டர\u{bcd}",
                "மருத\u{bcd}துவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c48}ద\u{c4d}యుడు"),
            keywords: &[
                "ఆర\u{c4b}గ\u{c4d}య సంరక\u{c4d}షణ",
                "చ\u{c3f}క\u{c3f}త\u{c4d}సకుడు",
                "నర\u{c4d}స\u{c4d}",
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "వ\u{c48}ద\u{c4d}యుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди корманди тандурустӣ"),
            keywords: &[
                "духтур",
                "мард",
                "марди корманди тандурустӣ",
                "нигоҳдории тандурустӣ",
                "терапевт",
                "ҳамшираи шавқат",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมอชาย"),
            keywords: &[
                "การด\u{e39}แลส\u{e38}ขภาพ",
                "น\u{e31}กบำบ\u{e31}ด",
                "นายแพทย\u{e4c}",
                "พยาบาล",
                "หมอ",
                "หมอชาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek saglygy goraýyş işgäri"),
            keywords: &[
                "erkek",
                "erkek saglygy goraýyş işgäri",
                "lukman",
                "saglygy goraýyş",
                "terapewt",
                "şepagat dogany",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("neesi tangata"),
            keywords: &["neesi tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek sağlık çalışanı"),
            keywords: &[
                "adam",
                "doktor",
                "erkek",
                "erkek sağlık çalışanı",
                "hastabakıcı",
                "sağlık",
                "terapist",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساغلاملىق خىزمەتچىسى ئەر"),
            keywords: &[
                "ئەر",
                "ئەمچى",
                "دوختۇر",
                "ساغلاملىق خىزمەتچىسى",
                "ساغلاملىق خىزمەتچىسى ئەر",
                "سىستېرا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("медичний працівник"),
            keywords: &[
                "лікар",
                "медбрат",
                "медик",
                "медичний працівник",
                "охорона здоровʼя",
                "чоловік",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد ہیلتھ ورکر"),
            keywords: &["صحت", "مرد", "مرد ہیلتھ ورکر", "ڈاکٹر", "کارکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak shifokor"),
            keywords: &[
                "doktor",
                "erkak shifokor",
                "salomatlik",
                "shifokor",
                "terapevt",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân viên y tế nam"),
            keywords: &[
                "bác sĩ",
                "chăm sóc sức khỏe",
                "nam",
                "nhân viên y tế nam",
                "trị liệu",
                "y tá",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fajkat bu góor"),
            keywords: &[
                "doktor",
                "faj",
                "fajkat",
                "fajkat bu góor",
                "góor",
                "infirmiyee",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsebenzi wezonyango oyindoda"),
            keywords: &[
                "indoda",
                "ingcali yokunyanga",
                "ugqirha",
                "ukhathalelo lwempilo",
                "umsebenzi wezonyango oyindoda",
                "unesi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrín òṣìṣẹ\u{301} ètò ìlera"),
            keywords: &[
                "ajọ ìlera",
                "dókítà",
                "nọ\u{301}ọ\u{300}sì",
                "olùdámọ\u{300}ràn",
                "ọkùnrin",
                "ọkùnrín òṣìṣẹ\u{301} ètò ìlera",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男醫護人員"),
            keywords: &["治療師", "男", "男醫護人員", "護士", "醫生", "醫療保健"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男医护人员"),
            keywords: &["医生", "医疗保健", "护士", "治疗师", "男", "男医护人员"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男医生"),
            keywords: &["医护人员", "医生", "护士", "治疗师", "男人", "男医生"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男醫生"),
            keywords: &["男", "男醫生", "醫生"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男醫護人員"),
            keywords: &["男醫生", "男醫護人員", "護士", "醫師", "醫生", "醫護人員"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unesi wesilisa"),
            keywords: &[
                "indoda",
                "udokotela",
                "unesi",
                "unesi wendoda",
                "unesi wesilisa",
            ],
        },
    ],
};
#[doc = "👨🏻\u{200d}⚕\u{fe0f}"]
pub const MAN_HEALTH_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}⚕\u{fe0f}",
    codepoint: "1F468 1F3FB 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man health worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏻\u{200d}⚕",
        codepoint: "1F468 1F3FB 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man health worker: light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}⚕\u{fe0f}"]
pub const MAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}⚕\u{fe0f}",
    codepoint: "1F468 1F3FC 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man health worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏼\u{200d}⚕",
        codepoint: "1F468 1F3FC 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man health worker: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}⚕\u{fe0f}"]
pub const MAN_HEALTH_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}⚕\u{fe0f}",
    codepoint: "1F468 1F3FD 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man health worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏽\u{200d}⚕",
        codepoint: "1F468 1F3FD 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man health worker: medium skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}⚕\u{fe0f}"]
pub const MAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}⚕\u{fe0f}",
    codepoint: "1F468 1F3FE 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man health worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏾\u{200d}⚕",
        codepoint: "1F468 1F3FE 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man health worker: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}⚕\u{fe0f}"]
pub const MAN_HEALTH_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}⚕\u{fe0f}",
    codepoint: "1F468 1F3FF 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man health worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏿\u{200d}⚕",
        codepoint: "1F468 1F3FF 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man health worker: dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩\u{200d}⚕\u{fe0f}"]
pub const WOMAN_HEALTH_WORKER: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}⚕\u{fe0f}",
    codepoint: "1F469 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman health worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩\u{200d}⚕",
        codepoint: "1F469 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman health worker",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike gesondheidswerker"),
            keywords: &[
                "dokter",
                "medies",
                "mediese werker",
                "terapeut",
                "verpleegster",
                "vrou",
                "vroulike gesondheidswerker",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ነርስ"),
            keywords: &["ሴት", "ቴራፒስት", "ነርስ", "ኪም", "የጤና እንክብካቤ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عاملة بقطاع الصحة"),
            keywords: &[
                "رعاية صحية",
                "طبيبة",
                "عاملة بقطاع الصحة",
                "معالجة",
                "ممرضة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কৰ\u{9cd}মচ\u{9be}ৰী"),
            keywords: &[
                "চিকিৎসক",
                "থেৰ\u{9be}পিষ\u{9cd}ট",
                "ন\u{9be}ৰ\u{9cd}চ",
                "মহিল\u{9be}",
                "মহিল\u{9be} স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কৰ\u{9cd}মচ\u{9be}ৰী",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}যৰ যতন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın həkim"),
            keywords: &["həkim", "qadın", "səhiyyə", "terapevt", "tibb bacısı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("доктарка"),
            keywords: &["ахова здароўя", "доктарка", "жанчына", "тэрапеўт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("здравна работничка"),
            keywords: &[
                "жена",
                "здравна работничка",
                "здравна система",
                "лекарка",
                "медицинска сестра",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কর\u{9cd}মী"),
            keywords: &[
                "ড\u{9be}ক\u{9cd}ত\u{9be}র",
                "থের\u{9be}পিস\u{9cd}ট",
                "ন\u{9be}র\u{9cd}স",
                "মহিল\u{9be}",
                "মহিল\u{9be} স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য কর\u{9cd}মী",
                "স\u{9cd}ব\u{9be}স\u{9cd}থ\u{9cd}য পরিচর\u{9cd}য\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zdravstvena radnica"),
            keywords: &[
                "doktorica",
                "liječnica",
                "ljekarka",
                "medicinska sestra",
                "zdravstvena radnica",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona professional de la salut"),
            keywords: &[
                "doctora",
                "dona",
                "dona professional de la salut",
                "infermera",
                "metgessa",
                "professional de la salut",
                "salut",
                "terapeuta",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏙᎯ ᏃᏛᎿᏕᎬᎢ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᎦᎾᎦᏘ",
                "ᎠᎦᎾᎦᏘ ᎠᏍᏕᎵᏍᎩ",
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᏙᎯ ᏃᏛᎿᏕᎬᎢ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᎠᏓᏍᏕᎸᎯᏙᎯ",
                "ᏙᎯ ᏃᏛᎿᏕᎬᎢ ᎤᎦᏎᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zdravotnice"),
            keywords: &[
                "doktorka",
                "nemocnice",
                "sestřička",
                "terapeutka",
                "zdravotnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr iechyd benywaidd"),
            keywords: &[
                "benywaidd",
                "gofal iechyd",
                "gweithiwr iechyd benywaidd",
                "meddyg",
                "nyrs",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig sundhedsperson"),
            keywords: &[
                "kittel",
                "kvinde",
                "kvindelig sundhedsperson",
                "læge",
                "sygeplejerske",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ärztin"),
            keywords: &["Arztkittel", "Ärztin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργαζόμενη στην υγεία"),
            keywords: &[
                "γιατρός",
                "εργαζόμενη στην υγεία",
                "νοσηλεύτρια",
                "νοσοκόμα",
                "υγεία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman health worker"),
            keywords: &[
                "doctor",
                "healthcare",
                "nurse",
                "therapist",
                "woman",
                "woman health worker",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "doctor",
                "health care",
                "nurse",
                "therapist",
                "woman",
                "woman health worker",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional sanitario mujer"),
            keywords: &[
                "doctora",
                "enfermera",
                "médica",
                "profesional sanitario mujer",
                "sanitaria",
                "terapeuta mujer",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "doctora",
                "enfermera",
                "médica",
                "profesional sanitario mujer",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisarst"),
            keywords: &["arst", "meditsiin", "meditsiiniõde", "naine", "naisarst"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume sendagilea"),
            keywords: &[
                "emakume",
                "emakume sendagilea",
                "emakumezko",
                "erizain",
                "osasun",
                "sendagile",
                "terapeuta",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مددکار بهداشت زن"),
            keywords: &[
                "مددکار",
                "مددکار بهداشت",
                "مددکار بهداشت خانم",
                "مددکار بهداشت زن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naishoitotyöntekijä"),
            keywords: &[
                "lääkäri",
                "nainen",
                "naishoitotyöntekijä",
                "sairaanhoitaja",
                "terapeutti",
                "terveydenhuollon naisammattilainen",
                "terveydenhuolto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng health worker"),
            keywords: &[
                "babae",
                "babaeng health worker",
                "doktor",
                "health worker",
                "nars",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur lækni"),
            keywords: &[
                "heilsurøkt",
                "kona",
                "kvinna",
                "kvinnuligur lækni",
                "lækni",
                "sjúkrarøktarfrøðingur",
                "sjúkrasystir",
                "terapevtur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("professionnelle de la santé"),
            keywords: &[
                "docteur",
                "femme",
                "infirmière",
                "professionnelle de la santé",
                "santé",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "docteur",
                "docteure",
                "femme",
                "infirmière",
                "professionnelle de la santé",
                "santé",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí sláinte baineann"),
            keywords: &[
                "altra",
                "bean",
                "cúram sláinte",
                "dochtúir",
                "oibrí sláinte baineann",
                "teiripeoir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-slàinte boireann"),
            keywords: &[
                "banaltram",
                "boireannach",
                "cùram-slàinte",
                "dotair",
                "leasaiche",
                "lighiche",
                "nurs",
                "obraiche-slàinte boireann",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("traballadora sanitaria"),
            keywords: &["enfermeira", "muller", "médica", "traballadora sanitaria"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી આરોગ\u{acd}ય કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "આરોગ\u{acd}યસ\u{a82}ભાળ",
                "ઉપચારક",
                "ડૉક\u{acd}ટર",
                "નર\u{acd}સ",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી આરોગ\u{acd}ય કાર\u{acd}યકર\u{acd}તા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace ma’aikacin kula da lafiya"),
            keywords: &[
                "kula da lafiya",
                "likita",
                "mace",
                "mace ma’aikacin kula da lafiya",
                "mai ba da kula",
                "nas",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רופאה"),
            keywords: &["אחות", "אישה", "מטפלת", "רופאה", "שירותי בריאות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला स\u{94d}वास\u{94d}थ\u{94d}य कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "चिकित\u{94d}सक",
                "डॉक\u{94d}टर",
                "नर\u{94d}स",
                "महिला",
                "महिला स\u{94d}वास\u{94d}थ\u{94d}य कार\u{94d}यकर\u{94d}ता",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("liječnica"),
            keywords: &["bolničarka", "doktorica", "liječnica", "terapeutkinja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("doktornő"),
            keywords: &["doktornő", "nővér", "orvos", "terapeuta", "ápolónő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բժշկուհի"),
            keywords: &[
                "առողջապահություն",
                "բժիշկ",
                "բժշկություն",
                "բժշկուհի",
                "կին",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja kesehatan wanita"),
            keywords: &[
                "dokter",
                "pekerja kesehatan wanita",
                "perawatan kesehatan",
                "perempuan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị onye ọrụ ahụike"),
            keywords: &[
                "dọkịta",
                "nletaahụike",
                "nwanyị",
                "nwanyị onye ọrụ ahụike",
                "nọọsụ",
                "onye dọkịta",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns heilbrigðisstarfsmaður"),
            keywords: &[
                "heilsa",
                "hjúkrunarfræðingur",
                "kona",
                "kvenkyns heilbrigðisstarfsmaður",
                "læknir",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("operatrice sanitaria"),
            keywords: &[
                "camice",
                "donna",
                "dottoressa",
                "operatrice sanitaria",
                "ospedale",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性の医者"),
            keywords: &["医師", "医者", "女", "女性", "女性の医者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mantri wadon"),
            keywords: &[
                "dokter",
                "mantri wadon",
                "parumatan kasehatan",
                "perawat",
                "terapis",
                "wong wadon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ექიმი ქალი"),
            keywords: &["ექთანი", "ექიმი", "თერაპევტი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("дәрігер әйел"),
            keywords: &["денсаулық", "дәрігер", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig sundhedsperson"),
            keywords: &[
                "kittel",
                "kvinde",
                "kvindelig sundhedsperson",
                "læge",
                "sygeplejerske",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ពេទ\u{17d2}យស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "គ\u{17b7}លាន\u{17bb}បដ\u{17d2}ឋាយ\u{17b7}កា",
                "គ\u{17d2}រ\u{17bc}ពេទ\u{17d2}យ",
                "ព\u{17b7}ន\u{17b7}ត\u{17d2}យស\u{17bb}ខភាព",
                "ពេទ\u{17d2}យស\u{17d2}រ\u{17b8}",
                "ព\u{17d2}យាបាល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳಾ ಆರೋಗ\u{ccd}ಯಾಧ\u{cbf}ಕಾರ\u{cbf}"),
            keywords: &[
                "ಆರೋಗ\u{ccd}ಯ ರಕ\u{ccd}ಷಣ\u{cc6}",
                "ಚ\u{cbf}ಕ\u{cbf}ತ\u{ccd}ಸಕ\u{cbf}",
                "ದಾದ\u{cbf}",
                "ಮಹ\u{cbf}ಳಾ ಆರೋಗ\u{ccd}ಯಾಧ\u{cbf}ಕಾರ\u{cbf}",
                "ವೈದ\u{ccd}ಯರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 의료인"),
            keywords: &[
                "간호사",
                "여자",
                "의료",
                "의료인",
                "의료진",
                "의사",
                "진료",
                "테라피스트",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल भलायकी कर\u{94d}मचारी"),
            keywords: &[
                "थ\u{945}रापिस\u{94d}ट",
                "दोतोर",
                "नर\u{94d}स",
                "बायल",
                "बायल भलायकी कर\u{94d}मचारी",
                "भलायकी जतन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял медицина кызматкери"),
            keywords: &[
                "аял",
                "аял медицина кызматкери",
                "доктор",
                "медайым",
                "саламаттыкты сактоо",
                "терапевт",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Medezinerin"),
            keywords: &[
                "Dokter",
                "Fra",
                "Gesondheet",
                "Infirmière",
                "Medezinerin",
                "Therapeut",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດວຽກສ\u{eb8}ຂະພາບ"),
            keywords: &[
                "ບຳບ\u{eb1}ດ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດວຽກສ\u{eb8}ຂະພາບ",
                "ພະຍາບານ",
                "ສ\u{eb8}ຂະພາບ",
                "ແພດ",
                "ໝ\u{ecd}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("medikė"),
            keywords: &[
                "gydytoja",
                "medikė",
                "moteris",
                "seselė",
                "sveikata",
                "terapeutė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("veselības aprūpes speciāliste"),
            keywords: &[
                "daktere",
                "medmāsa",
                "sieviete",
                "terapeite",
                "veselības aprūpes speciāliste",
                "ārste",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine atawhai hauora"),
            keywords: &[
                "atawhai hauora",
                "kaiwhakaora",
                "rata",
                "tapuhi",
                "wahine",
                "wahine atawhai hauora",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("докторка"),
            keywords: &[
                "доктор",
                "докторка",
                "жена",
                "здравство",
                "медицинска сестра",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആരോഗ\u{d4d}യ പ\u{d4d}രവർത\u{d4d}തക"),
            keywords: &[
                "ആരോഗ\u{d4d}യ പ\u{d4d}രവർത\u{d4d}തക",
                "ആരോഗ\u{d4d}യപ\u{d3e}ലനം",
                "ഡോക\u{d4d}ടർ",
                "നഴ\u{d4d}സ\u{d4d}",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй эрүүл мэндийн ажилтан"),
            keywords: &[
                "сувилагч",
                "эмч",
                "эмчлэгч",
                "эмэгтэй эрүүл мэндийн ажилтан",
                "эрүүл мэнд",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला आरोग\u{94d}य कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "आरोग\u{94d}यदक\u{94d}षता",
                "उपचारतज\u{94d}ञ",
                "डॉक\u{94d}टर",
                "परिचारिका",
                "महिला",
                "महिला आरोग\u{94d}य कार\u{94d}यकर\u{94d}ता",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja kesihatan wanita"),
            keywords: &[
                "ahli terapi",
                "doktor",
                "jururawat",
                "pekerja kesihatan wanita",
                "penjagaan kesihatan",
                "perempuan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara fil-kura tas-saħħa"),
            keywords: &[
                "infermiera",
                "kura tas-saħħa",
                "mara",
                "mara fil-kura tas-saħħa",
                "tabib",
                "terapista",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း ကျန\u{103a}းမာရေးလ\u{102f}ပ\u{103a}သား"),
            keywords: &[
                "ကျန\u{103a}းမာရေးစောင\u{1037}\u{103a}ရ\u{103e}ောက\u{103a}မ\u{103e}\u{102f}",
                "ဆရာဝန\u{103a}",
                "သ\u{1030}နာပြ\u{102f}",
                "အထ\u{1030}းက\u{102f} ဆရာဝန\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ကျန\u{103a}းမာရေးလ\u{102f}ပ\u{103a}သား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig helsearbeider"),
            keywords: &[
                "doktor",
                "helsevesen",
                "kvinne",
                "kvinnelig helsearbeider",
                "lege",
                "sykepleier",
                "terapeut",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला स\u{94d}वास\u{94d}थ\u{94d}यकर\u{94d}मी"),
            keywords: &[
                "चिकित\u{94d}सक",
                "छोरीमान\u{94d}छ\u{947}",
                "थ\u{947}रापिस\u{94d}ट",
                "नर\u{94d}स",
                "महिला",
                "महिला स\u{94d}वास\u{94d}थ\u{94d}यकर\u{94d}मी",
                "स\u{94d}वास\u{94d}थ\u{94d}यको ह\u{947}रविचार",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gezondheidsmedewerkster"),
            keywords: &[
                "dokter",
                "gezondheidsmedewerkster",
                "gezondheidszorg",
                "therapeute",
                "verpleegster",
                "vrouw",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg helsearbeidar"),
            keywords: &[
                "dokter",
                "helseesen",
                "kvinne",
                "kvinneleg helsearbeidar",
                "lege",
                "sjukepleiar",
                "terapeut",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟ କର\u{b4d}ମୀ"),
            keywords: &[
                "ଡ\u{b3e}କ\u{b4d}ତର",
                "ଥେର\u{b3e}ପ\u{b3f}ଷ\u{b4d}ଟ",
                "ନର\u{b4d}ସ\u{b4d}\u{200c}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟ କର\u{b4d}ମୀ",
                "ସ\u{b4d}ୱ\u{b3e}ସ\u{b4d}ଥ\u{b4d}ୟସେବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਸਿਹਤ ਵਰਕਰ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਸਿਹਤ ਵਰਕਰ",
                "ਔਰਤ",
                "ਚਿਕਿਤਸਕ",
                "ਡਾਕਟਰ",
                "ਨਰਸ",
                "ਸਿਹਤ-ਸ\u{a70}ਭਾਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("صحت تے کم کرن آلی زنانی"),
            keywords: &[
                "زنانی",
                "صحت تے کم کرن آلی زنانی",
                "طبیب",
                "ماہر معالجیات",
                "نرس",
                "نگہداشت\u{650} صحت",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé De Lúk Áftá Sík Pípul"),
            keywords: &[
                "Dọ\u{301}ktọ",
                "Nọs",
                "To Lúk Áftá Sík Pípul",
                "Wúman",
                "Wúman Wé De Lúk Áftá Sík Pípul",
                "Wọ\u{301}kwúman Fọ Wiá Dẹm De Lúk Áftá Sík Pípul",
                "Ẹ\u{301}spat Dọ\u{301}ktọ Fọ Síknẹs",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lekarka"),
            keywords: &["kobieta", "lekarka", "terapeutka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه روغتيايي کارکوونکي"),
            keywords: &[
                "تهراپسټ",
                "د روغتيا پاملرنه",
                "نرس",
                "ډاکټر",
                "ښځه روغتيايي کارکوونکي",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher profissional da saúde"),
            keywords: &[
                "doutora",
                "enfermeira",
                "mulher",
                "mulher profissional da saúde",
                "médica",
                "saúde",
                "terapeuta",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("profissional de saúde (mulher)"),
            keywords: &[
                "doutora",
                "enfermeira",
                "mulher",
                "médica",
                "profissional da saúde (mulher)",
                "profissional da área da saúde",
                "profissional de saúde (mulher)",
                "serviço de saúde",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi qhali kaywan llamkaq"),
            keywords: &[
                "enfermera",
                "hanpiq",
                "qhali kay",
                "terapista",
                "warmi",
                "warmi qhali kaywan llamkaq",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lucrătoare în domeniul sănătății"),
            keywords: &[
                "asistentă",
                "doctoriță",
                "femeie",
                "infirmieră",
                "lucrătoare în domeniul sănătății",
                "servicii medicale",
                "soră medicală",
                "terapeută",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1174"),
            keywords: &["E10-1174"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-врач"),
            keywords: &["врач", "доктор", "женщина", "женщина-врач", "медсестра"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore ukora mu by’ubuzima"),
            keywords: &[
                "dogiteri",
                "ubuvuzi",
                "umuforomokazi",
                "umugore",
                "umugore ukora mu by’ubuzima",
                "umuvuzi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت صحت خدمتگار"),
            keywords: &["عورت صحت خدمتگار", "عورت، صحت جو خيال، ڊاڪٽر، نرس، ٿراپسٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දොස\u{dca}තරවර\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ච\u{dd2}ක\u{dd2}ත\u{dca}සකවර\u{dd2}ය",
                "දොස\u{dca}තරවර\u{dd2}ය",
                "සෞඛ\u{dca}\u{200d}යය සත\u{dca}ක\u{dcf}ර",
                "හෙද\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdravotníčka"),
            keywords: &["doktorka", "lekárka", "nemocnica", "zdravotníčka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zdravstvena delavka"),
            keywords: &[
                "dekle",
                "medicinska sestra",
                "terapevtka",
                "zdravnica",
                "zdravstvena delavka",
                "zdravstvo",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag shaqaale caafimaad ah"),
            keywords: &[
                "daryeel caafimaad",
                "daweeye",
                "dhakhtar",
                "kalkaaliso",
                "naag",
                "naag shaqaale caafimaad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("punonjëse shëndetësor"),
            keywords: &[
                "doktore",
                "grua",
                "infermiere",
                "kujdes mjekësor",
                "punonjëse shëndetësor",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("здравствена радница"),
            keywords: &[
                "доктор",
                "жена",
                "здравствена радница",
                "здравство",
                "лекар",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["здравствена радница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zdravstvena radnica"),
            keywords: &[
                "doktor",
                "lekar",
                "zdravstvena radnica",
                "zdravstvo",
                "žena",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["zdravstvena radnica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig läkare"),
            keywords: &[
                "doktor",
                "hälsovård",
                "kvinna",
                "kvinnlig",
                "läkare",
                "skötare",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mhudumu wa afya wa kike"),
            keywords: &[
                "daktari",
                "mganga",
                "mhudumu wa afya wa kike",
                "muuguzi",
                "tabibu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} மருத\u{bcd}துவர\u{bcd}"),
            keywords: &[
                "ட\u{bbe}க\u{bcd}டர\u{bcd}",
                "பெண\u{bcd}",
                "மருத\u{bcd}துவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c48}\u{c48}ద\u{c4d}యుర\u{c3e}లు"),
            keywords: &[
                "ఆర\u{c4b}గ\u{c4d}య సంరక\u{c4d}షణ",
                "చ\u{c3f}క\u{c3f}త\u{c4d}సకుర\u{c3e}లు",
                "నర\u{c4d}స\u{c4d}",
                "మహ\u{c3f}ళ",
                "వ\u{c48}ద\u{c4d}యుర\u{c3e}లు",
                "వ\u{c48}\u{c48}ద\u{c4d}యుర\u{c3e}లు",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани корманди тандурустӣ"),
            keywords: &[
                "духтур",
                "зан",
                "зани корманди тандурустӣ",
                "нигоҳдории тандурустӣ",
                "терапевт",
                "ҳамшираи шавқат",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมอหญ\u{e34}ง"),
            keywords: &[
                "การด\u{e39}แลส\u{e38}ขภาพ",
                "น\u{e31}กบำบ\u{e31}ด",
                "พยาบาล",
                "หมอ",
                "หมอหญ\u{e34}ง",
                "แพทย\u{e4c}หญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan saglygy goraýyş işgäri"),
            keywords: &[
                "lukman",
                "saglygy goraýyş",
                "terapewt",
                "zenan",
                "zenan saglygy goraýyş işgäri",
                "şepagat uýasy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("neesi fefine"),
            keywords: &["neesi fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın sağlık çalışanı"),
            keywords: &[
                "bayan",
                "doktor",
                "hemşire",
                "kadın",
                "kadın sağlık çalışanı",
                "sağlık",
                "terapist",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساغلاملىق خىزمەتچىسى ئايال"),
            keywords: &[
                "ئايال",
                "ئەمچى",
                "دوختۇر",
                "ساغلاملىق خىزمەتچىسى",
                "ساغلاملىق خىزمەتچىسى ئايال",
                "سىستېرا",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("медична працівниця"),
            keywords: &[
                "жінка",
                "лікар",
                "медик",
                "медична працівниця",
                "медсестра",
                "охорона здоровʼя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت ہیلتھ ورکر"),
            keywords: &["صحت", "عورت", "عورت ہیلتھ ورکر", "ڈاکٹر", "کارکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol shifokor"),
            keywords: &[
                "ayol",
                "ayol shifokor",
                "doktor",
                "hamshira",
                "sog‘liqni saqlash",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân viên y tế nữ"),
            keywords: &[
                "bác sĩ",
                "chăm sóc sức khỏe",
                "nhân viên y tế nữ",
                "nữ",
                "trị liệu",
                "y tá",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fajkat bu jigéen"),
            keywords: &[
                "doktoor",
                "faj-nit",
                "fajkat",
                "fajkat bu jigéen",
                "jigéen",
                "saas-faam",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsebenzi wempilo olibhinqa"),
            keywords: &[
                "ibhinqa",
                "ingcali yonyango",
                "ugqirha",
                "umkhathaleli wempilo",
                "umsebenzi wempilo olibhinqa",
                "unesi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrin òṣìṣẹ\u{301} ètò ìlera"),
            keywords: &[
                "ajọ ìlera",
                "dókítà",
                "nọ\u{301}ọ\u{300}sì",
                "obìrin",
                "obìrin òṣìṣẹ\u{301} ètò ìlera",
                "olùdámọ\u{300}ràn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女醫護人員"),
            keywords: &["女", "女醫護人員", "治療師", "護士", "醫生", "醫療保健"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女医护人员"),
            keywords: &["医生", "医疗保健", "女", "女医护人员", "护士", "治疗师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女医生"),
            keywords: &["医护人员", "医生", "女人", "女医生", "护士", "治疗师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女醫生"),
            keywords: &["女", "女醫生", "醫生"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女醫護人員"),
            keywords: &["女醫生", "女醫護人員", "護士", "醫師", "醫生", "醫護人員"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unesi wesifazane"),
            keywords: &["owesifazane", "udokotela", "unesi", "unesi wesifazane"],
        },
    ],
};
#[doc = "👩🏻\u{200d}⚕\u{fe0f}"]
pub const WOMAN_HEALTH_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}⚕\u{fe0f}",
    codepoint: "1F469 1F3FB 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman health worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏻\u{200d}⚕",
        codepoint: "1F469 1F3FB 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman health worker: light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}⚕\u{fe0f}"]
pub const WOMAN_HEALTH_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}⚕\u{fe0f}",
    codepoint: "1F469 1F3FC 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman health worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏼\u{200d}⚕",
        codepoint: "1F469 1F3FC 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman health worker: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}⚕\u{fe0f}"]
pub const WOMAN_HEALTH_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}⚕\u{fe0f}",
    codepoint: "1F469 1F3FD 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman health worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏽\u{200d}⚕",
        codepoint: "1F469 1F3FD 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman health worker: medium skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}⚕\u{fe0f}"]
pub const WOMAN_HEALTH_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}⚕\u{fe0f}",
    codepoint: "1F469 1F3FE 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman health worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏾\u{200d}⚕",
        codepoint: "1F469 1F3FE 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman health worker: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}⚕\u{fe0f}"]
pub const WOMAN_HEALTH_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}⚕\u{fe0f}",
    codepoint: "1F469 1F3FF 200D 2695 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman health worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏿\u{200d}⚕",
        codepoint: "1F469 1F3FF 200D 2695",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman health worker: dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑\u{200d}🎓"]
pub const STUDENT: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🎓",
    codepoint: "1F9D1 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "student",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("student"),
            keywords: &["graad", "gradeplegtigheid", "gradueer", "student"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተማሪ"),
            keywords: &["ተማሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طال\u{650}ب"),
            keywords: &["خريج", "طالب", "طال\u{650}ب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিক\u{9cd}ষ\u{9be}ৰ\u{9cd}থী"),
            keywords: &["ডিগ\u{9cd}ৰীধ\u{9be}ৰী", "শিক\u{9cd}ষ\u{9be}ৰ\u{9cd}থী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tələbə"),
            keywords: &["məzun", "tələbə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("навучэнец"),
            keywords: &["выпускнік", "навучэнец", "студэнт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("учащ"),
            keywords: &["завършил", "студент", "учащ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছ\u{9be}ত\u{9cd}র ছ\u{9be}ত\u{9cd}রি"),
            keywords: &[
                "ছ\u{9be}ত\u{9cd}র ছ\u{9be}ত\u{9cd}রি",
                "বিদ\u{9cd}য\u{9be}র\u{9cd}থী",
                "স\u{9cd}ন\u{9be}তক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("student"),
            keywords: &["diplomirani", "student"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("estudiant"),
            keywords: &["estudiant", "graduat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏕᎶᏆᏍᎩ"),
            keywords: &["ᏗᏍᏆᏗᏍᎩ", "ᏗᏕᎶᏆᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("studující"),
            keywords: &[
                "absolvent",
                "absolventka",
                "student",
                "studentka",
                "studující",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n astudio"),
            keywords: &["myfyriwr", "person sy’n astudio", "wedi graddio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("studerende"),
            keywords: &["dimittend", "kandidat", "student", "studerende"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Student(in)"),
            keywords: &["Absolvent", "Student", "Student(in)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σπουδαστής"),
            keywords: &["απόφοιτος", "σπουδαστής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("student"),
            keywords: &["graduate", "student"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estudiante"),
            keywords: &["estudiante", "graduado", "licenciado", "universitario"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("estudiante"),
            keywords: &["estudiante"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("estudiante"),
            keywords: &["estudiante"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õpilane"),
            keywords: &["koolilõpetaja", "õpilane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ikaslea"),
            keywords: &["graduatu", "ikasle", "ikaslea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانش\u{200c}آموز"),
            keywords: &["دانشجو", "دانش\u{200c}آموز", "فارغ\u{200c}التحصیل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("opiskelija"),
            keywords: &["lakki", "opiskelija", "opiskelu", "valmistujaiset"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("estudyante"),
            keywords: &["estudyante", "graduate", "mag-aaral", "nakapagtapos"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("studentur"),
            keywords: &["lesandi", "næmingur", "prógv", "studentur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étudiant (tous genres)"),
            keywords: &["diplôme", "étudiant", "étudiant (tous genres)", "étudiante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("étudiant universitaire"),
            keywords: &["diplômé", "étudiant", "étudiant universitaire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("mac léinn"),
            keywords: &["mac léinn"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("oileanach"),
            keywords: &["ceumnachadh", "oileanach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estudante"),
            keywords: &["estudante", "graduado", "universitario"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છાત\u{acd}ર"),
            keywords: &["છાત\u{acd}ર", "સ\u{acd}નાતક"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סטודנט/ית"),
            keywords: &["בוגר", "בוגרת", "סטודנט", "סטודנט/ית", "סטודנטית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विद\u{94d}यार\u{94d}थी"),
            keywords: &["विद\u{94d}यार\u{94d}थी", "स\u{94d}नातक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("diplomant"),
            keywords: &["diplomant", "student"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("diák"),
            keywords: &["diák", "végzős"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուսանող"),
            keywords: &["աշակերտ", "շրջանավարտ", "ուսանող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("murid"),
            keywords: &["kelulusan", "murid"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nemi"),
            keywords: &["nemi", "útskrift"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("studente"),
            keywords: &["diploma", "studente", "studentessa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("学生"),
            keywords: &["卒業", "学生", "角帽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mahasiswa"),
            keywords: &["mahasiswa", "wisuda"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სტუდენტი"),
            keywords: &["გამოსაშვები", "დიპლომი", "კურსდამთავრებული", "სტუდენტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("студент"),
            keywords: &["студент", "түлек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17b7}ស\u{17d2}សន\u{17b7}ស\u{17d2}ស\u{17b7}ត"),
            keywords: &[
                "ន\u{17b7}ស\u{17d2}ស\u{17b7}ត",
                "ន\u{17b7}ស\u{17d2}ស\u{17b7}តបញ\u{17d2}ចប\u{17cb}ការស\u{17b7}ក\u{17d2}សា",
                "ស\u{17b7}ស\u{17d2}សន\u{17b7}ស\u{17d2}ស\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}"),
            keywords: &["ಪಧವೀದರ", "ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("학생"),
            keywords: &["졸업식", "학사모", "학생"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विद\u{94d}यार\u{94d}थी"),
            keywords: &["पदवीधर", "विद\u{94d}यार\u{94d}थी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("студент"),
            keywords: &["студент"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ກຮຽນ"),
            keywords: &["ຄະແນນ", "ນ\u{eb1}ກຮຽນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paskutinio kurso studentas"),
            keywords: &["baigimas", "paskutinio kurso studentas", "studentas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("absolvents"),
            keywords: &["absolvents", "izlaidums", "students"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("студент"),
            keywords: &["дипломец", "студент"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിദ\u{d4d}യ\u{d3e}ർത\u{d4d}ഥി"),
            keywords: &["ബിര\u{d41}ദധ\u{d3e}രി", "വിദ\u{d4d}യ\u{d3e}ർത\u{d4d}ഥി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оюутан"),
            keywords: &["оюутан", "төгсөгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विद\u{94d}यार\u{94d}थी असल\u{947}ला म\u{941}लगा"),
            keywords: &["पदवीधर", "विद\u{94d}यार\u{94d}थी असल\u{947}ला म\u{941}लगा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pelajar"),
            keywords: &["graduan", "pelajar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျောင\u{103a}းသ\u{1030}ကျောင\u{103a}းသား"),
            keywords: &[
                "ကျောင\u{103a}းတက\u{103a}နေသ\u{1030}",
                "ကျောင\u{103a}းသ\u{1030}ကျောင\u{103a}းသား",
                "ဘ\u{103d}\u{1032}\u{1037}ရ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("student"),
            keywords: &["skole", "student", "universitet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("विद\u{94d}यार\u{94d}थी"),
            keywords: &["विद\u{94d}यार\u{94d}थी", "स\u{94d}नातक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("student"),
            keywords: &["scholier", "student"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("student"),
            keywords: &["skule", "student", "universitet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ର\u{b4d}ଥୀ"),
            keywords: &["ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ର\u{b4d}ଥୀ", "ସ\u{b4d}ନ\u{b3e}ତକ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿਖਿਆਰਥੀ"),
            keywords: &["ਗਰ\u{a48}ਜ\u{a42}ਏਟ", "ਵਿਦਿਆਰਥੀ", "ਸਿਖਿਆਰਥੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Stúdẹnt"),
            keywords: &["Grájúet", "Stúdẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("student"),
            keywords: &["absolwent", "student"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("محصل"),
            keywords: &["محصل", "ګرېجوېټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("aluno"),
            keywords: &["aluno", "estudante", "graduando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aluno", "estudante", "universitário"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yachakuq"),
            keywords: &["graduado", "yachakuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("student sau studentă"),
            keywords: &[
                "absolvent",
                "absolventă",
                "student",
                "student sau studentă",
                "studentă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-008"),
            keywords: &["E13-008"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("учащийся"),
            keywords: &["бакалавр", "выпускник", "студент", "учащийся"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شاگرد"),
            keywords: &["شاگرد", "گريجويٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ශ\u{dd2}ෂ\u{dca}\u{200d}යය\u{dcf}"),
            keywords: &[
                "උප\u{dcf}ධ\u{dd2}ධ\u{dcf}ර\u{dd3}ය\u{dcf}",
                "ශ\u{dd2}ෂ\u{dca}\u{200d}යය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("študent"),
            keywords: &["promócia", "univerzita", "študent"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("diplomant"),
            keywords: &["diplomant", "diplomantka", "študent"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("arday"),
            keywords: &["Arday", "arday", "qalin jabiye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person student"),
            keywords: &["diplomant", "person student", "student"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("студент/киња"),
            keywords: &["дипломац", "студент/киња"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("студент(киња)"),
            keywords: &["студент(киња)"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("student/kinja"),
            keywords: &["diplomac", "student/kinja"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("student(kinja)"),
            keywords: &["student(kinja)"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("student"),
            keywords: &["student", "studerande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanafunzi"),
            keywords: &["mahafali", "mwanafunzi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}ணவர\u{bcd}"),
            keywords: &["பட\u{bcd}டத\u{bbe}ரி", "ம\u{bbe}ணவர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అభ\u{c4d}య\u{c3e}సకుడు"),
            keywords: &[
                "అభ\u{c4d}య\u{c3e}సకుడు",
                "గ\u{c4d}ర\u{c3e}డ\u{c4d}యుయ\u{c47}ట\u{c4d}",
                "వ\u{c3f}ద\u{c4d}య\u{c3e}ర\u{c4d}థ\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("บ\u{e31}ณฑ\u{e34}ต"),
            keywords: &["บ\u{e31}ณฑ\u{e34}ต", "ร\u{e31}บปร\u{e34}ญญา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("talyp"),
            keywords: &["talyp", "uçurym"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ako"),
            keywords: &["tokotaha ako"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("öğrenci"),
            keywords: &["mezun", "talebe", "öğrenci"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("слухач"),
            keywords: &["випускник", "слухач", "студент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طالب علم"),
            keywords: &["طالب علم", "طالبعلم", "گریجویٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("talaba"),
            keywords: &["bitirish", "oʻqishni bitirish", "talaba"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sinh viên"),
            keywords: &["sinh viên", "tốt nghiệp"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("學生"),
            keywords: &["學生", "畢業"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("学生"),
            keywords: &["学生", "毕业"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("学生"),
            keywords: &["学生", "毕业", "毕业生"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("學生"),
            keywords: &["學生", "畢業"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umfundi"),
            keywords: &["ophothulile", "umfundi"],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🎓"]
pub const STUDENT_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🎓",
    codepoint: "1F9D1 1F3FB 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "student: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🎓"]
pub const STUDENT_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🎓",
    codepoint: "1F9D1 1F3FC 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "student: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🎓"]
pub const STUDENT_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🎓",
    codepoint: "1F9D1 1F3FD 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "student: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🎓"]
pub const STUDENT_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🎓",
    codepoint: "1F9D1 1F3FE 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "student: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🎓"]
pub const STUDENT_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🎓",
    codepoint: "1F9D1 1F3FF 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "student: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🎓"]
pub const MAN_STUDENT: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🎓",
    codepoint: "1F468 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man student",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike student"),
            keywords: &["graad", "gradeplegtigheid", "manlike student", "toga"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ተመራቂ"),
            keywords: &["ተመራቂ", "ተማሪ", "ተባዕት", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طالب"),
            keywords: &["خريج", "طالب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছ\u{9be}ত\u{9cd}ৰ"),
            keywords: &[
                "ছ\u{9be}ত\u{9cd}ৰ",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "স\u{9cd}ন\u{9be}তক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oğlan tələbə"),
            keywords: &["kişi", "məzun", "oğlan tələbə", "tələbə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("студэнт"),
            keywords: &["выпускнік", "мужчына", "студэнт"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("студент"),
            keywords: &["висше образование", "дипломиран младеж", "студент", "учащ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছ\u{9be}ত\u{9cd}র"),
            keywords: &[
                "ছ\u{9be}ত\u{9cd}র",
                "প\u{9c1}র\u{9c1}ষ",
                "স\u{9cd}ন\u{9be}তক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("studier"),
            keywords: &["studier"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("student muškarac"),
            keywords: &["diplomirani", "muškarac", "student"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("noi estudiant"),
            keywords: &["graduació", "graduat", "home", "masculí", "noi estudiant"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄍𑄖\u{11133}𑄢\u{11127}\u{11134}"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄍𑄖\u{11133}𑄢\u{11127}\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏗᏕᎶᏆᏍᎩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᏗᏍᏆᏗᏍᎩ", "ᏗᏕᎶᏆᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("student"),
            keywords: &["absolvent", "muž", "student"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("myfyriwr"),
            keywords: &["dyn", "graddio", "gwrywaidd", "myfyriwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig studerende"),
            keywords: &[
                "dimittend",
                "eksamenshat",
                "mand",
                "mandlig studerende",
                "studerende",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Student"),
            keywords: &["Absolvent", "Doktorhut", "Student", "Uni"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φοιτητής"),
            keywords: &["άντρας", "απόφοιτος", "φοιτητής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man student"),
            keywords: &["graduate", "man", "student"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estudiante hombre"),
            keywords: &[
                "estudiante",
                "graduado",
                "hombre",
                "licenciado",
                "universitario",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesõpilane"),
            keywords: &["lõpetaja", "mees", "meesõpilane", "õpilane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mutil ikaslea"),
            keywords: &["gizon", "gizonezko", "graduatu", "ikasle", "mutil ikaslea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانشجوی مرد"),
            keywords: &[
                "دانشجو",
                "دانشجوی مرد",
                "دانش\u{200c}آموز",
                "شاگرد",
                "فارغ\u{200c}التحصیل",
                "محصل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesopiskelija"),
            keywords: &[
                "lakki",
                "mies",
                "miesopiskelija",
                "opiskelu",
                "valmistujaiset",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking mag-aaral"),
            keywords: &[
                "estudyante",
                "graduate",
                "lalaki",
                "lalaking mag-aaral",
                "mag-aaral",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur studentur"),
            keywords: &["mannligur studentur", "maður", "studentur", "útbúgvin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étudiant"),
            keywords: &["diplômé", "homme", "étudiant"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scoláire fir"),
            keywords: &["céimí", "fear", "mac léinn", "scoláire fir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("oileanach fireann"),
            keywords: &[
                "ceumnaiche",
                "duine",
                "fear",
                "fireannach",
                "oileanach",
                "oileanach fireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estudante de sexo masculino"),
            keywords: &[
                "estudante",
                "estudante de sexo masculino",
                "graduado",
                "home",
                "universitario",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિદ\u{acd}યાર\u{acd}થી"),
            keywords: &[
                "પ\u{ac1}ર\u{ac1}ષ",
                "વિદ\u{acd}યાર\u{acd}થી",
                "સ\u{acd}નાતક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum ɗalibi"),
            keywords: &["mai digiri", "mutum", "ɗalibi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סטודנט"),
            keywords: &["איש", "בוגר", "בן", "גבר", "סטודנט", "תלמיד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छात\u{94d}र"),
            keywords: &["छात\u{94d}र"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("student"),
            keywords: &["diplomant", "student"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi tanuló"),
            keywords: &["diák", "egyetemista", "férfi", "tanuló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուսանող տղա"),
            keywords: &["ուսանող", "տղա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sarjana pria"),
            keywords: &["laki-laki", "sarjana pria", "toga", "universitas", "wisuda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke nwata akwụkwọ"),
            keywords: &[
                "nwaakwụkwọ",
                "nwoke",
                "nwoke nwata akwụkwọ",
                "onye gụchara akwụkwọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns námsmaður"),
            keywords: &[
                "karl",
                "karlkyns námsmaður",
                "nemandi",
                "námsmaður",
                "útskrift",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("studente maschio"),
            keywords: &["laurea", "maschio", "ragazzo", "studente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男子学生"),
            keywords: &["卒業", "学生", "男", "男子学生", "男性", "角帽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mahasiswa lanang"),
            keywords: &["lanang", "mahasiswa", "wisuda"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სტუდენტი კაცი"),
            keywords: &["კაცი", "მეცნიერი", "სტუდენტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("студент бала"),
            keywords: &["ер", "студент", "студент бала", "түлек"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("studerende"),
            keywords: &["dimittend", "eksamenshat", "mand", "studerende"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17b7}ស\u{17d2}សប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ន\u{17b7}ស\u{17d2}ស\u{17b7}ត",
                "បញ\u{17d2}ចប\u{17cb}ការស\u{17b7}ក\u{17d2}សា",
                "ប\u{17d2}រ\u{17bb}ស",
                "ស\u{17b7}ស\u{17d2}សប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}"),
            keywords: &[
                "ಪದವ\u{cbf}ಧರ",
                "ಪುರುಷ",
                "ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}",
                "ಹುಡುಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남학생"),
            keywords: &["남자", "남학생", "졸업식", "학사모", "학생"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो विद\u{94d}यार\u{94d}थी"),
            keywords: &["दादलो", "पदवीधर", "विद\u{94d}यार\u{94d}थी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек студент"),
            keywords: &["бүтүрүүчү", "студент", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Student"),
            keywords: &["Absolvent", "Mann", "Student", "diploméiert"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ກຮຽນຊາຍ"),
            keywords: &[
                "ຈ\u{ebb}ບການສ\u{eb6}ກສາ",
                "ນ\u{eb1}ກຮຽນ",
                "ນ\u{eb1}ກຮຽນຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ໜ\u{eb8}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("studentas"),
            keywords: &["absolventas", "studentas", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("students"),
            keywords: &["absolvents", "students", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ākonga tāne"),
            keywords: &["paetahi", "tāne", "ākonga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж студент"),
            keywords: &["дипломец", "маж", "студент"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിദ\u{d4d}യ\u{d3e}ർഥി"),
            keywords: &["ആൺ", "വിദ\u{d4d}യ\u{d3e}ർഥി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй оюутан"),
            keywords: &["оюутан", "төгсөгч", "эр", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विद\u{94d}यार\u{94d}थी"),
            keywords: &[
                "प\u{941}र\u{942}ष",
                "विद\u{94d}यार\u{94d}थी",
                "स\u{94d}नातक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pelajar lelaki"),
            keywords: &["graduan", "lelaki", "pelajar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("student maskil"),
            keywords: &["gradwat", "raġel", "student", "student maskil"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျောင\u{103a}းသား"),
            keywords: &[
                "ကျောင\u{103a}းသား",
                "ဘ\u{103d}\u{1032}\u{1037}ရ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig student"),
            keywords: &["mann", "mannlig student", "skole", "student", "universitet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}\u{941}र\u{942}ष विद\u{94d}यार\u{94d}थी"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "प\u{941}\u{941}र\u{942}ष विद\u{94d}यार\u{94d}थी",
                "विद\u{94d}यार\u{94d}थी",
                "श\u{948}क\u{94d}षिक योग\u{94d}ता प\u{94d}राप\u{94d}त व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke student"),
            keywords: &["man", "mannelijke student", "scholier", "student"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg student"),
            keywords: &["mann", "mannleg student", "skule", "student", "universitet"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ର\u{b4d}ଥୀ"),
            keywords: &[
                "ପ\u{b41}ର\u{b41}ଷ",
                "ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ର\u{b4d}ଥୀ",
                "ସ\u{b4d}ନ\u{b3e}ତକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਿਦਿਆਰਥੀ"),
            keywords: &[
                "ਗਰ\u{a48}ਜ\u{a42}ਏਟ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਵਿਦਿਆਰਥੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد طالب علم"),
            keywords: &["بندہ", "طالب علم", "مرد طالب علم", "گریجویٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Stúdẹnt"),
            keywords: &["Grájúet", "Man", "Mán Stúdẹnt", "Stúdẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna student"),
            keywords: &["mężczyzna", "student"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی محصل"),
            keywords: &["سړی", "محصل", "ګريجويټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("estudante"),
            keywords: &["aluno", "estudante", "formando", "homem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estudante (homem)"),
            keywords: &[
                "aluno",
                "estudante",
                "estudante (homem)",
                "homem",
                "universitário",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata yachakuq"),
            keywords: &["graduado", "tata", "yachakuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("student"),
            keywords: &["absolvent", "student"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1163"),
            keywords: &["E10-1163"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("студент"),
            keywords: &["выпускник", "мужчина", "парень", "студент"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’umunyeshuri"),
            keywords: &[
                "kuzamura mu ntera",
                "umugabo",
                "umugabo w’umunyeshuri",
                "umunyeshuri",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد شاگرد"),
            keywords: &["مرد شاگرد", "مرد، شاگرد، گريجوئيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ස\u{dd4}ව\u{dcf}"),
            keywords: &[
                "උප\u{dcf}ධ\u{dd2} ප\u{dca}\u{200d}රද\u{dcf}නෝත\u{dca}සවය",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "ස\u{dd2}ස\u{dd4}ව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("študent muž"),
            keywords: &["muž", "promócia", "univerzita", "študent"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("študent"),
            keywords: &["diplomant", "fant", "maturant", "moški", "študent"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin arday ah"),
            keywords: &["arday", "nin", "nin arday ah", "qallinjabin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("student"),
            keywords: &["diplomim", "mashkull", "student"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("студент"),
            keywords: &["диплома", "матура", "мушкарац", "студент"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("student"),
            keywords: &["diploma", "matura", "muškarac", "student"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig student"),
            keywords: &["man", "manlig", "student", "studerande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanafunzi na kofia ya kufuzu"),
            keywords: &[
                "fuzu",
                "hitumu",
                "kofia",
                "mahafali",
                "mwanafunzi na kofia ya kufuzu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "fuzu",
                "hitimu",
                "kofia",
                "mahafali",
                "mwanafunzi na kofia ya kufuzu",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}ணவன\u{bcd}"),
            keywords: &["பட\u{bcd}டம\u{bcd}", "ம\u{bbe}ணவன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}ద\u{c4d}య\u{c3e}ర\u{c4d}థ\u{c3f}"),
            keywords: &[
                "పట\u{c4d}టభద\u{c4d}రుడు",
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "వ\u{c3f}ద\u{c4d}య\u{c3e}ర\u{c4d}థ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди донишҷӯ"),
            keywords: &["донишҷӯ", "мард", "марди донишҷӯ", "хатмкунанда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e31}กเร\u{e35}ยนชาย"),
            keywords: &[
                "น\u{e31}กเร\u{e35}ยน",
                "น\u{e31}กเร\u{e35}ยนชาย",
                "ผ\u{e39}\u{e49}ชาย",
                "เร\u{e35}ยนจบ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek talyp"),
            keywords: &["erkek", "talyp", "uçurym"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tamasiʻi ako"),
            keywords: &["tamasiʻi ako"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek öğrenci"),
            keywords: &["adam", "erkek", "mezun", "öğrenci"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوغۇل ئوقۇغۇچى"),
            keywords: &["ئوغۇل", "ئوقۇش پۈتتۈرۈش", "ئوقۇغۇچى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("студент"),
            keywords: &["абітурієнт", "випускник", "студент", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد طالب علم"),
            keywords: &["اسکول", "طالب علم", "مرد", "مرد طالب علم", "گریجوئیشن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak talaba"),
            keywords: &["bitiruvchi", "erkak", "kishi", "talaba"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sinh viên nam"),
            keywords: &["nam", "sinh viên", "sinh viên nam", "tốt nghiệp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndongo bu góor"),
            keywords: &["diplom", "góor", "ndongo", "ndongo bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfundi oyindoda"),
            keywords: &["indoda", "isidanga", "umfundi", "umfundi oyindoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin akẹ\u{301}kọ\u{300}ọ\u{301}"),
            keywords: &["akẹ\u{301}kọ\u{300}ọ\u{301}", "kàwégboyè", "ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男學生"),
            keywords: &["學生", "男", "男學生", "畢業"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男学生"),
            keywords: &["学生", "毕业", "男", "男学生"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男学生"),
            keywords: &["学生", "毕业", "男", "男学生"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男畢業生"),
            keywords: &["男", "男畢業生", "畢業"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男學生"),
            keywords: &["學生", "男", "男學生", "畢業生"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umfundi wesilisa"),
            keywords: &["indoda", "isifundiswa", "umfundi", "umfundi wesilisa"],
        },
    ],
};
#[doc = "👨🏻\u{200d}🎓"]
pub const MAN_STUDENT_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🎓",
    codepoint: "1F468 1F3FB 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man student: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🎓"]
pub const MAN_STUDENT_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🎓",
    codepoint: "1F468 1F3FC 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man student: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🎓"]
pub const MAN_STUDENT_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🎓",
    codepoint: "1F468 1F3FD 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man student: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🎓"]
pub const MAN_STUDENT_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🎓",
    codepoint: "1F468 1F3FE 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man student: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🎓"]
pub const MAN_STUDENT_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🎓",
    codepoint: "1F468 1F3FF 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man student: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🎓"]
pub const WOMAN_STUDENT: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🎓",
    codepoint: "1F469 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman student",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike student"),
            keywords: &["graad", "gradeplegtigheid", "toga", "vroulike student"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ተመራቂ"),
            keywords: &["ሴት", "ተመራቂ", "ተማሪ", "እንስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طالبة"),
            keywords: &["خريجة", "طالبة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছ\u{9be}ত\u{9cd}ৰী"),
            keywords: &["ছ\u{9be}ত\u{9cd}ৰী", "মহিল\u{9be}", "স\u{9cd}ন\u{9be}তক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qız tələbə"),
            keywords: &["məzun", "qadın", "qız tələbə", "tələbə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("студэнтка"),
            keywords: &["выпускніца", "жанчына", "студэнтка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("студентка"),
            keywords: &["висше образование", "жена", "студентка", "учаща"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছ\u{9be}ত\u{9cd}রী"),
            keywords: &["ছ\u{9be}ত\u{9cd}রী", "মহিল\u{9be}", "স\u{9cd}ন\u{9be}তক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("studierez"),
            keywords: &["studierez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("studentica"),
            keywords: &["diplomirani", "student", "studentica", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("noia estudiant"),
            keywords: &["dona", "femení", "graduació", "graduada", "noia estudiant"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄍𑄖\u{11133}𑄢\u{11127}\u{11134}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄍𑄖\u{11133}𑄢\u{11127}\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᏕᎶᏆᏍᎩ"),
            keywords: &["ᎠᎨᏯ", "ᏗᏍᏆᏗᏍᎩ", "ᏗᏕᎶᏆᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("studentka"),
            keywords: &["absolventka", "studentka", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("myfyrwraig"),
            keywords: &["benywaidd", "graddio", "menyw", "myfyrwraig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig studerende"),
            keywords: &[
                "dimittend",
                "eksamenshat",
                "kvinde",
                "kvindelig studerende",
                "studerende",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Studentin"),
            keywords: &["Absolventin", "Doktorhut", "Studentin", "Uni"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("φοιτήτρια"),
            keywords: &["απόφοιτη", "γυναίκα", "φοιτήτρια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman student"),
            keywords: &["graduate", "student", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("estudiante mujer"),
            keywords: &[
                "estudiante",
                "graduada",
                "licenciada",
                "mujer",
                "universitaria",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisõpilane"),
            keywords: &["lõpetaja", "naine", "naisõpilane", "õpilane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("neska ikaslea"),
            keywords: &[
                "emakume",
                "emakumezko",
                "graduatu",
                "ikasle",
                "neska ikaslea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانشجوی زن"),
            keywords: &[
                "دانشجو",
                "دانشجوی زن",
                "دانش\u{200c}آموز",
                "شاگرد",
                "فارغ\u{200c}التحصیل",
                "محصل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisopiskelija"),
            keywords: &[
                "lakki",
                "nainen",
                "naisopiskelija",
                "opiskelu",
                "valmistujaiset",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng mag-aaral"),
            keywords: &[
                "babae",
                "babaeng mag-aaral",
                "estudyante",
                "graduate",
                "mag-aaral",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur studentur"),
            keywords: &[
                "kona",
                "kvinna",
                "kvinnuligur studentur",
                "studentur",
                "útbúgvin",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("étudiante"),
            keywords: &["diplômée", "femme", "étudiante"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scoláire baineann"),
            keywords: &["bean", "céimí", "mac léinn", "scoláire baineann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ban-oileanach"),
            keywords: &[
                "ban-oileanach",
                "boireannach",
                "ceumnaiche",
                "oileanach",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("estudante de sexo feminino"),
            keywords: &[
                "estudante",
                "estudante de sexo feminino",
                "graduada",
                "muller",
                "universitaria",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિદ\u{acd}યાર\u{acd}થિની"),
            keywords: &[
                "વિદ\u{acd}યાર\u{acd}થિની",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}નાતક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace ɗalibi"),
            keywords: &["mace", "mai digiri", "ɗalibi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סטודנטית"),
            keywords: &["אישה", "בוגרת", "בת", "סטודנטית", "תלמידה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("छात\u{94d}रा"),
            keywords: &["छात\u{94d}रा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("studentica"),
            keywords: &["diplomantica", "studentica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női tanuló"),
            keywords: &["diák", "egyetemista", "nő", "női tanuló", "tanuló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուսանողուհի"),
            keywords: &["աղջիկ", "ուսանող", "ուսանողուհի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("sarjana wanita"),
            keywords: &[
                "perempuan",
                "sarjana wanita",
                "toga",
                "universitas",
                "wisuda",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị nwaakwụkwọ"),
            keywords: &["nwaakwụkwọ", "nwanyị", "onye gụchara akwụkwọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns námsmaður"),
            keywords: &[
                "kona",
                "kvenkyns námsmaður",
                "nemandi",
                "námsmaður",
                "útskrift",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("studentessa"),
            keywords: &["femmina", "laurea", "ragazza", "studentessa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女子学生"),
            keywords: &["卒業", "女", "女子学生", "女性", "学生", "角帽"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mahasiswa wadon"),
            keywords: &["mahasiswa", "wadon", "wisuda"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სტუდენტი ქალი"),
            keywords: &["მეცნიერი", "სტუდენტი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("студент қыз"),
            keywords: &["студент", "түлек", "қыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig studerende"),
            keywords: &[
                "dimittend",
                "eksamenshat",
                "kvinde",
                "kvindelig studerende",
                "studerende",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17b7}ស\u{17d2}សស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ន\u{17b7}ស\u{17d2}ស\u{17b7}ត",
                "បញ\u{17d2}ចប\u{17cb}ការស\u{17b7}ក\u{17d2}សា",
                "ស\u{17b7}ស\u{17d2}សស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}ನ\u{cbf}"),
            keywords: &[
                "ಪದವ\u{cbf}ಧರ\u{cc6}",
                "ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}",
                "ವ\u{cbf}ದ\u{ccd}ಯಾರ\u{ccd}ಥ\u{cbf}ನ\u{cbf}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಹುಡುಗ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여학생"),
            keywords: &["여자", "여학생", "졸업식", "학사모", "학생"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल विद\u{94d}यार\u{94d}थी"),
            keywords: &["पदवीधर", "बायल", "विद\u{94d}यार\u{94d}थी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял студент"),
            keywords: &["аял", "бүтүрүүчү", "студент"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Studentin"),
            keywords: &["Absolventin", "Fra", "Studentin", "diploméiert"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ກຮຽນຍ\u{eb4}ງ"),
            keywords: &[
                "ຈ\u{ebb}ບການສ\u{eb6}ກສາ",
                "ນ\u{eb1}ກຮຽນ",
                "ນ\u{eb1}ກຮຽນຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("studentė"),
            keywords: &["absolventė", "moteris", "studentė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("studente"),
            keywords: &["absolvente", "sieviete", "studente"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ākonga wahine"),
            keywords: &["paetahi", "wahine", "ākonga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("студентка"),
            keywords: &["дипломка", "жена", "студентка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിദ\u{d4d}യ\u{d3e}ർഥിനി"),
            keywords: &["പെൺ", "വിദ\u{d4d}യ\u{d3e}ർഥിനി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй оюутан"),
            keywords: &["оюутан", "төгсөгч", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विद\u{94d}यार\u{94d}थिनी"),
            keywords: &[
                "महिला",
                "विद\u{94d}यार\u{94d}थिनी",
                "विद\u{94d}यार\u{94d}थी",
                "स\u{94d}नातक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pelajar wanita"),
            keywords: &["graduan", "pelajar", "perempuan", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("student femminil"),
            keywords: &["gradwat", "mara", "student", "student femminil"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကျောင\u{103a}းသ\u{1030}"),
            keywords: &[
                "ကျောင\u{103a}းသ\u{1030}",
                "ဘ\u{103d}\u{1032}\u{1037}ရ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig student"),
            keywords: &[
                "kvinne",
                "kvinnelig student",
                "skole",
                "student",
                "universitet",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला विद\u{94d}यार\u{94d}थी"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "महिला",
                "विद\u{94d}यार\u{94d}थी",
                "श\u{948}क\u{94d}षिक योग\u{94d}यता प\u{94d}राप\u{94d}त व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("studente"),
            keywords: &["scholiere", "studente", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg student"),
            keywords: &[
                "kvinne",
                "kvinneleg student",
                "skule",
                "student",
                "universitet",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ର\u{b4d}ଥୀ"),
            keywords: &[
                "ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ର\u{b4d}ଥୀ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ସ\u{b4d}ନ\u{b3e}ତକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਿਦਿਆਰਥਣ"),
            keywords: &["ਇਸਤਰੀ", "ਔਰਤ", "ਗਰ\u{a48}ਜ\u{a42}ਏਟ", "ਵਿਦਿਆਰਥਣ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("طالبہ"),
            keywords: &["زنانی", "طالب علم", "طالبہ", "گریجویٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Stúdẹnt"),
            keywords: &["Grájuet", "Stúdẹnt", "Wúman", "Wúmán Stúdẹnt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("studentka"),
            keywords: &["kobieta", "studentka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه محصل"),
            keywords: &["ښځه محصل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("aluna"),
            keywords: &["aluna", "estudante", "formanda", "mulher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("estudante (mulher)"),
            keywords: &[
                "aluna",
                "estudante",
                "estudante (mulher)",
                "mulher",
                "universitária",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi yachakuq"),
            keywords: &["graduada", "warmi", "yachakuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("studentă"),
            keywords: &["absolventă", "studentă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1179"),
            keywords: &["E10-1179"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("студентка"),
            keywords: &["выпускница", "девушка", "женщина", "студентка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore w’umunyeshuri"),
            keywords: &[
                "umugore",
                "umugore w’umunyeshuri",
                "umunyeshuri",
                "uzamurwa mu ntera",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت شاگرد"),
            keywords: &["عورت شاگرد", "عورت، شاگرد، گريجوئيٽ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd2}ස\u{dd4}ව\u{dd2}ය"),
            keywords: &[
                "උප\u{dcf}ධ\u{dd2} ප\u{dca}\u{200d}රද\u{dcf}නෝත\u{dca}සවය",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
                "ස\u{dd2}ස\u{dd4}ව\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("študentka"),
            keywords: &["promócia", "univerzita", "študentka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("študentka"),
            keywords: &["dekle", "diplomantka", "maturantka", "študentka", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag ardayad ah"),
            keywords: &["arday", "naag", "naag ardayad ah", "qallinjabin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("studente"),
            keywords: &["diplomim", "femër", "studente"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("студенткиња"),
            keywords: &["диплома", "жена", "матура", "студент", "студенткиња"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("studentkinja"),
            keywords: &["diploma", "matura", "student", "studentkinja", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig student"),
            keywords: &["kvinna", "kvinnlig", "student", "studerande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanafunzi wa kike na kofia ya kufuzu"),
            keywords: &[
                "fuzu",
                "hitumu",
                "kofia",
                "mahafali",
                "mwanafunzi wa kike na kofia ya kufuzu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &[
                "fuzu",
                "hitimu",
                "kofia",
                "mahafali",
                "mwanafunzi wa kike na kofia ya kufuzu",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ம\u{bbe}ணவி"),
            keywords: &["பட\u{bcd}டம\u{bcd}", "ம\u{bbe}ணவி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}ద\u{c4d}య\u{c3e}ర\u{c4d}థ\u{c3f}న\u{c3f}"),
            keywords: &[
                "పట\u{c4d}టభద\u{c4d}రుర\u{c3e}లు",
                "మహ\u{c3f}ళ",
                "వ\u{c3f}ద\u{c4d}య\u{c3e}ర\u{c4d}థ\u{c3f}న\u{c3f}",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани донишҷӯ"),
            keywords: &["донишҷӯ", "зан", "зани донишҷӯ", "хатмкунанда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e31}กเร\u{e35}ยนหญ\u{e34}ง"),
            keywords: &[
                "น\u{e31}กเร\u{e35}ยน",
                "น\u{e31}กเร\u{e35}ยนหญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "เร\u{e35}ยนจบ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan talyp"),
            keywords: &["talyp", "uçurym", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taʻahine ako"),
            keywords: &["taʻahine ako"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kız öğrenci"),
            keywords: &["bayan", "kadın", "kız öğrenci", "mezun", "öğrenci"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىز ئوقۇغۇچى"),
            keywords: &["ئوقۇش پۈتتۈرۈش", "ئوقۇغۇچى", "قىز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("студентка"),
            keywords: &["абітурієнтка", "випускниця", "жінка", "студентка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت طالب علم"),
            keywords: &["اسکول", "طالب علم", "عورت", "عورت طالب علم", "گریجوئیشن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol talaba"),
            keywords: &["ayol", "bitiruvchi", "talaba"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sinh viên nữ"),
            keywords: &["nữ", "sinh viên", "sinh viên nữ", "tốt nghiệp"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ndongo lu jigéen"),
            keywords: &["diplom", "jigéen", "ndongo", "ndongo lu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfundi olibhinqa"),
            keywords: &["ibhinqa", "isidanga", "umfundi", "umfundi olibhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrin akẹ\u{301}kọ\u{300}ọ\u{301}"),
            keywords: &["akẹ\u{301}kọ\u{300}ọ\u{301}", "kàwégboyè", "obìrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女學生"),
            keywords: &["女", "女學生", "學生", "畢業"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女学生"),
            keywords: &["女", "女学生", "学生", "毕业"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女学生"),
            keywords: &["女", "女学生", "学生", "毕业"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女畢業生"),
            keywords: &["女", "女畢業生", "畢業"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女學生"),
            keywords: &["女", "女學生", "學生", "畢業生"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umfundi wesifazane"),
            keywords: &["isifundiswa", "owesimame", "umfundi", "umfundi wesifazane"],
        },
    ],
};
#[doc = "👩🏻\u{200d}🎓"]
pub const WOMAN_STUDENT_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🎓",
    codepoint: "1F469 1F3FB 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman student: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🎓"]
pub const WOMAN_STUDENT_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🎓",
    codepoint: "1F469 1F3FC 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman student: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🎓"]
pub const WOMAN_STUDENT_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🎓",
    codepoint: "1F469 1F3FD 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman student: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🎓"]
pub const WOMAN_STUDENT_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🎓",
    codepoint: "1F469 1F3FE 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman student: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🎓"]
pub const WOMAN_STUDENT_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🎓",
    codepoint: "1F469 1F3FF 200D 1F393",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman student: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🏫"]
pub const TEACHER: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🏫",
    codepoint: "1F9D1 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "teacher",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("onderwyser"),
            keywords: &["instrukteur", "onderwyser", "professor"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አስተማሪ"),
            keywords: &["አስተማሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أستاذ"),
            keywords: &["أستاذ", "مدرس", "معلم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিক\u{9cd}ষক"),
            keywords: &["নিৰ\u{9cd}দেশক", "প\u{9cd}ৰ’ফেচৰ", "শিক\u{9cd}ষক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("müəllim"),
            keywords: &["instruktor", "müəllim", "professor"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("выкладчык"),
            keywords: &["выкладчык", "настаўнік", "прафесар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("преподавател"),
            keywords: &["инструктор", "лектор", "преподавател", "учител"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অধ\u{9cd}য\u{9be}পক"),
            keywords: &[
                "অধ\u{9cd}য\u{9be}পক",
                "উপদেষ\u{9cd}ট\u{9be}",
                "শিক\u{9cd}ষক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("učitelj"),
            keywords: &["instruktor", "profesor", "učitelj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("professor"),
            keywords: &["instructor", "mestre", "professor"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏕᏲᎲᏍᎩ"),
            keywords: &["ᎠᏓᏎᎮᎯ", "ᎤᏔᎾ ᏗᏕᏲᎲᏍᎩ", "ᏗᏕᏲᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vyučující"),
            keywords: &[
                "instruktor",
                "instruktorka",
                "profesor",
                "profesorka",
                "učitel",
                "učitelka",
                "vyučující",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n addysgu"),
            keywords: &["atho", "athrawes", "hyfforddwr", "person sy’n addysgu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lærer"),
            keywords: &[
                "instruktor",
                "lektor",
                "lærer",
                "professor",
                "skolelærer",
                "underviser",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lehrer(in)"),
            keywords: &["Dozent", "Lehrer", "Lehrer(in)", "Professor"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Lehrer(in)"),
            keywords: &["Dozent", "Lehrer", "Lehrer(in)", "Professor"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καθηγητής"),
            keywords: &["δάσκαλος", "εκπαιδευτής", "καθηγητής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("teacher"),
            keywords: &["instructor", "professor", "teacher"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["instructor", "lecturer", "professor", "teacher"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["instructor", "lecturer", "professor", "teacher"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("docente"),
            keywords: &[
                "docente",
                "educador",
                "enseñanza",
                "instructor",
                "maestro",
                "profesor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("maestro"),
            keywords: &["maestro"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["docente", "instructor", "maestro", "profesor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("õpetaja"),
            keywords: &["koolitaja", "professor", "õpetaja"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("irakaslea"),
            keywords: &["irakasle", "irakaslea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("معلم"),
            keywords: &["استاد", "مربی", "معلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("opettaja"),
            keywords: &["koulu", "opettaja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("guro"),
            keywords: &["guro", "propesor", "tagaturo"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lærari"),
            keywords: &["lærari", "professari", "vegleiðari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personnel enseignant"),
            keywords: &[
                "enseignant",
                "enseignante",
                "formateur",
                "formatrice",
                "personnel enseignant",
                "professeur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("professeur"),
            keywords: &["enseignant", "instituteur", "professeur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("múinteoir"),
            keywords: &["múinteoir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tidsear"),
            keywords: &["neach-teagaisg", "oide", "ollamh", "tidsear"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ensinante"),
            keywords: &["ensinante", "escola", "mestre", "profesor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("અધ\u{acd}યાપક"),
            keywords: &[
                "અધ\u{acd}યાપક",
                "પ\u{acd}રશિક\u{acd}ષક",
                "પ\u{acd}રાધ\u{acd}યાપક",
                "શિક\u{acd}ષક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מצוות המורים"),
            keywords: &[
                "מדריך",
                "מדריכה",
                "מורה",
                "מלמד",
                "מלמדת",
                "מצוות המורים",
                "מרצה",
                "עוזר הוראה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शिक\u{94d}षक"),
            keywords: &[
                "प\u{94d}रशिक\u{94d}षक",
                "प\u{94d}रोफ\u{93c}\u{947}सर",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("profesor"),
            keywords: &["instruktor", "profesor", "učitelj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tanár / tanárnő"),
            keywords: &["oktató", "professzor", "tanár", "tanár / tanárnő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուսուցիչ"),
            keywords: &["դասախոս", "դասատու", "ուսուցիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("guru"),
            keywords: &["dosen", "guru", "instruktur"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kennari"),
            keywords: &["kennari", "leiðbeinandi", "prófessor"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("insegnante"),
            keywords: &[
                "insegnante",
                "maestra",
                "maestro",
                "professore",
                "professoressa",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("教師"),
            keywords: &["先生", "担任", "教師", "教授", "講師"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("guru"),
            keywords: &["dosen", "guru", "instruktur"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მასწავლებელი"),
            keywords: &["ლექტორი", "მასწავლებელი", "პროფესორი", "ტუტორი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оқытушы"),
            keywords: &["мұғалім", "оқытушы", "ұстаз"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រ\u{17bc}បង\u{17d2}រៀន"),
            keywords: &[
                "គ\u{17d2}រ\u{17bc}បង\u{17d2}រៀន",
                "គ\u{17d2}រ\u{17bc}បង\u{17d2}វ\u{17b9}ក",
                "សាស\u{17d2}ត\u{17d2}រាចារ\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{cbf}ಕ\u{ccd}ಷಕರು"),
            keywords: &[
                "ಪ\u{ccd}ರಾಧ\u{ccd}ಯಾಪಕ",
                "ಬೋಧಕ",
                "ಶ\u{cbf}ಕ\u{ccd}ಷಕ",
                "ಶ\u{cbf}ಕ\u{ccd}ಷಕರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("교사"),
            keywords: &["강사", "교사", "교수"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शिक\u{94d}षक"),
            keywords: &[
                "प\u{94d}रोफ\u{947}सर",
                "मार\u{94d}गदर\u{94d}शक",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мугалим"),
            keywords: &["мугалим"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອາຈານ"),
            keywords: &["ຄ\u{eb9}", "ສາດສະດາຈານ", "ອາຈານ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokantis žmogus"),
            keywords: &[
                "dėstytojas",
                "instruktorius",
                "mokantis žmogus",
                "mokytojas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pedagogs"),
            keywords: &["instruktors", "pedagogs", "profesors", "skolotājs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("учител"),
            keywords: &["наставник", "професор", "учител"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ടീച\u{d4d}ചർ"),
            keywords: &["ഗ\u{d41}ര\u{d41}", "ടീച\u{d4d}ചർ", "പ\u{d4d}രൊഫസർ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("багш"),
            keywords: &["багш", "зааварлагч", "профессор"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिक\u{94d}षक असल\u{947}ला प\u{941}र\u{942}ष"),
            keywords: &[
                "प\u{941}र\u{942}ष असल\u{947}ला शिक\u{94d}षक",
                "प\u{94d}रशिक\u{94d}षण द\u{947}णारा",
                "प\u{94d}राध\u{94d}\u{200d}यापक",
                "शिक\u{94d}षक असल\u{947}ला प\u{941}र\u{942}ष",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("guru"),
            keywords: &["guru", "pengajar", "profesor"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆရာဆရာမ"),
            keywords: &["ဆရာ", "ဆရာဆရာမ", "နည\u{103a}းပြ", "ပါမောက\u{1039}ခ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lærer"),
            keywords: &["lærer", "skole", "undervisning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शिक\u{94d}षक/शिक\u{94d}षिका"),
            keywords: &[
                "निर\u{94d}द\u{947}शक",
                "प\u{94d}रोफ\u{947}सर",
                "शिक\u{94d}षक/शिक\u{94d}षिका",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("docent"),
            keywords: &["docent", "leraar", "professor"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lærar"),
            keywords: &["lærar", "skule", "undervisning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}କ\u{b4d}ଷକ"),
            keywords: &[
                "ଅଧ\u{b4d}ୟ\u{b3e}ପକ",
                "ଉପଦେଷ\u{b4d}ଟ\u{b3e}",
                "ଶ\u{b3f}କ\u{b4d}ଷକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿ\u{a71}ਖਿਅਕ"),
            keywords: &["ਅਧਿਆਪਕ", "ਪ\u{a4d}ਰ\u{a4b}ਫ\u{a48}ਸਰ", "ਸਿ\u{a71}ਖਿਅਕ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tícha"),
            keywords: &["Prọfẹ\u{301}sọ", "Tícha", "Ínstrọ\u{301}ktọ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nauczyciel"),
            keywords: &["instruktor", "nauczyciel", "pedagog", "profesor"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښوونکی"),
            keywords: &["معلم", "پروفيسر", "ښوونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("professora na escola"),
            keywords: &["instrutora", "professora", "professora na escola"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("professor"),
            keywords: &["educador", "formador", "instrutor", "professor"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("maestro"),
            keywords: &["instructor", "maestro", "yachachiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("profesor sau profesoară"),
            keywords: &[
                "instructor",
                "profesor",
                "profesor sau profesoară",
                "învățător",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-009"),
            keywords: &["E13-009"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("педагог"),
            keywords: &[
                "инструктор",
                "педагог",
                "преподаватель",
                "профессор",
                "учитель",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("استاد"),
            keywords: &["استاد", "ٽيچر", "پروفيسر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd4}ර\u{dd4}වරය\u{dcf}"),
            keywords: &[
                "උපදේශක",
                "ග\u{dd4}ර\u{dd4}වරය\u{dcf}",
                "මහ\u{dcf}ච\u{dcf}ර\u{dca}යවරය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("učiteľ"),
            keywords: &["pedagóg", "profesor", "učiteľ", "škola"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("profesor"),
            keywords: &["inštruktor", "profesor", "učitelj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bare"),
            keywords: &["bare", "macallin"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person mësues"),
            keywords: &["instruktor", "mësues", "person mësues", "profesor"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("учитељ"),
            keywords: &["инструктор", "професор", "учитељ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("učitelj"),
            keywords: &["instruktor", "profesor", "učitelj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lärare"),
            keywords: &["instruktör", "lärare", "professor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwalimu"),
            keywords: &["mkufunzi", "mwalimu", "profesa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆசிரியர\u{bcd}"),
            keywords: &[
                "ஆசிரியர\u{bcd}",
                "பயிற\u{bcd}றுவிப\u{bcd}ப\u{bbe}ளர\u{bcd}",
                "பேர\u{bbe}சிரியர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉప\u{c3e}ధ\u{c4d}య\u{c3e}యులు"),
            keywords: &[
                "ఉప\u{c3e}ధ\u{c4d}య\u{c3e}యులు",
                "ప\u{c4d}ర\u{c4a}ఫ\u{c46}సర\u{c4d}",
                "శ\u{c3f}క\u{c4d}షకులు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คร\u{e39}"),
            keywords: &["คร\u{e39}", "ศาสตราจารย\u{e4c}", "อาจารย\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mugallym"),
            keywords: &["instruktor", "mugallym", "professor"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faiako"),
            keywords: &["faiako"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("öğretmen"),
            keywords: &["doçent", "eğitimci", "profesör", "öğretmen"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("освітянин"),
            keywords: &["викладач", "освітянин", "учитель", "інструктор"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("استاد"),
            keywords: &["استاد", "معلم", "پروفیسر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oʻqituvchi"),
            keywords: &["instruktor", "oʻqituvchi", "professor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giáo viên"),
            keywords: &["giáo sư", "giáo viên", "người hướng dẫn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("老師"),
            keywords: &["導師", "教授", "老師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("老师"),
            keywords: &["导师", "教授", "老师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("老师"),
            keywords: &["教师", "教授", "老师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("老師"),
            keywords: &["教師", "教授", "老師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uthisha"),
            keywords: &["umqondisi", "uprofesa", "uthisha"],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🏫"]
pub const TEACHER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🏫",
    codepoint: "1F9D1 1F3FB 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "teacher: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🏫"]
pub const TEACHER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🏫",
    codepoint: "1F9D1 1F3FC 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "teacher: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🏫"]
pub const TEACHER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🏫",
    codepoint: "1F9D1 1F3FD 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "teacher: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🏫"]
pub const TEACHER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🏫",
    codepoint: "1F9D1 1F3FE 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "teacher: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🏫"]
pub const TEACHER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🏫",
    codepoint: "1F9D1 1F3FF 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "teacher: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🏫"]
pub const MAN_TEACHER: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🏫",
    codepoint: "1F468 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man teacher",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike onderwyser"),
            keywords: &[
                "manlike onderwyser",
                "meneer",
                "onderwyser",
                "opvoeder",
                "skool",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ አስተማሪ"),
            keywords: &["ተባዕት", "አስተማሪ", "ወንድ", "ፕሮፌሰር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معلم"),
            keywords: &["أستاذ", "أستاذ جامعي", "مدرس", "مربي", "معلم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ শিক\u{9cd}ষক"),
            keywords: &[
                "অধ\u{9cd}য\u{9be}পক",
                "নিৰ\u{9cd}দেশক",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "শিক\u{9cd}ষক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi müəllim"),
            keywords: &["kişi", "müəllim", "professor"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("настаўнік"),
            keywords: &["выкладчык", "мужчына", "настаўнік", "прафесар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("учител"),
            keywords: &["инструктор", "лектор", "преподавател", "учител"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিক\u{9cd}ষক"),
            keywords: &[
                "অধ\u{9cd}য\u{9be}পক",
                "ইনস\u{9cd}ট\u{9cd}র\u{9be}কটর",
                "প\u{9c1}র\u{9c1}ষ",
                "শিক\u{9cd}ষক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kelenner"),
            keywords: &["kelenner"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("profesor"),
            keywords: &["muškarac", "nastavnik", "profesor", "učitelj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home professor"),
            keywords: &["home", "instructor", "masculí", "mestre", "professor"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄟𑄌\u{11134}𑄑\u{11127}𑄢\u{11134}"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄟𑄌\u{11134}𑄑\u{11127}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏗᏕᏲᎲᏍᎩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏓᏅᏫᏍᏗᏍᎩ", "ᏄᎬᏫᏳᏒ ᏗᏕᏲᎲᏍᎦ", "ᏗᏕᏲᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("učitel"),
            keywords: &["instruktor", "muž", "profesor", "učitel"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("athro"),
            keywords: &["athro", "dyn", "gwrywaidd", "hyfforddwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig lærer"),
            keywords: &["lærer", "mand", "mandlig lærer", "professor", "underviser"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lehrer"),
            keywords: &["Dozent", "Lehrer", "Professor"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δάσκαλος"),
            keywords: &["άντρας", "δάσκαλος", "εκπαίδευση", "καθηγητής"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man teacher"),
            keywords: &["instructor", "man", "professor", "teacher"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("docente hombre"),
            keywords: &[
                "docente hombre",
                "educador",
                "hombre",
                "instructor",
                "maestro",
                "profesor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesõpetaja"),
            keywords: &["juhendaja", "mees", "meesõpetaja", "professor", "õpetaja"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon irakaslea"),
            keywords: &["gizon", "gizon irakaslea", "gizonezko", "irakasle", "maisu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آموزگار مرد"),
            keywords: &["آقای معلم", "آموزگار مرد", "استاد", "دبیر", "مدرس", "معلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesopettaja"),
            keywords: &["koulu", "mies", "miesopettaja", "ohjaaja", "opettaja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking guro"),
            keywords: &["guro", "lalaki", "lalaking guro", "propesor", "titser"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur lærari"),
            keywords: &[
                "lærari",
                "mannligur lærari",
                "maður",
                "professari",
                "vegleiðari",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("enseignant"),
            keywords: &[
                "enseignant",
                "homme",
                "instituteur",
                "instructeur",
                "professeur",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("múinteoir fireann"),
            keywords: &["fear", "múinteoir fireann", "oide", "ollamh", "teagascóir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("oide fireann"),
            keywords: &[
                "duine",
                "fear",
                "fireannach",
                "oide",
                "oide fireann",
                "ollamh",
                "tidsear",
                "àrd-ollamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("profesor"),
            keywords: &["escola", "home", "mestre", "profesor"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શિક\u{acd}ષક"),
            keywords: &[
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{acd}રશિક\u{acd}ષક",
                "પ\u{acd}રોફ\u{ac7}સર",
                "શિક\u{acd}ષક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum malami"),
            keywords: &["frafesa", "mai koyarwa", "malami", "mutum"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מורה"),
            keywords: &["איש", "בן", "גבר", "מורה", "מנחה", "מרצה", "פרופסור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अध\u{94d}यापक"),
            keywords: &[
                "अध\u{94d}यापक",
                "आदमी",
                "प\u{941}र\u{941}ष",
                "प\u{94d}रशिक\u{94d}षक",
                "प\u{94d}रोफ\u{947}सर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("učitelj"),
            keywords: &["nastavnik", "profesor", "učitelj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tanár"),
            keywords: &["férfi", "oktató", "professzor", "tanár"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ ուսուցիչ"),
            keywords: &["դասատու", "ուսուցիչ", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pengajar pria"),
            keywords: &["laki-laki", "pengajar", "pengajar pria", "sekolah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke onyenkuzi"),
            keywords: &["nwoke", "onyenkuzi", "onyentụzịaka", "ọkammụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns kennari"),
            keywords: &[
                "karl",
                "karlkyns kennari",
                "kennari",
                "leiðbeinandi",
                "skóli",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("professore"),
            keywords: &["insegnante", "professore", "scuola", "studio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性の教師"),
            keywords: &["先生", "教師", "教授", "男", "男性", "男性の教師"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("guru lanang"),
            keywords: &["dosen", "guru", "instruktur", "lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მასწავლებელი კაცი"),
            keywords: &[
                "ინსტრუქტორი",
                "კაცი",
                "მასწავლებელი",
                "მეცნიერი",
                "პროფესორი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мұғалім"),
            keywords: &["ер", "мұғалім", "оқытушы", "ұстаз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("lærer"),
            keywords: &["lærer", "mand", "professor", "underviser"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លោកគ\u{17d2}រ\u{17bc}"),
            keywords: &[
                "គ\u{17d2}រ\u{17bc}",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "លោកគ\u{17d2}រ\u{17bc}",
                "សាស\u{17d2}ត\u{17d2}រាចារ\u{17d2}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{cbf}ಕ\u{ccd}ಷಕ"),
            keywords: &[
                "ಪುರುಷ",
                "ಪ\u{ccd}ರಾಧ\u{ccd}ಯಾಪಕ",
                "ಬೋಧಕ",
                "ಶ\u{cbf}ಕ\u{ccd}ಷಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남교사"),
            keywords: &["강사", "강연자", "교사", "교수", "남교사", "남자", "선생님"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो शिक\u{94d}षक"),
            keywords: &[
                "दादलो",
                "प\u{94d}रोफ\u{947}सर",
                "मार\u{94d}गदर\u{94d}शक",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек мугалим"),
            keywords: &["мугалим", "окутуучу", "профессор", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Enseignant"),
            keywords: &["Enseignant", "Mann", "Professer", "Schoulmeeschter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອາຈານຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &[
                "ຄ\u{eb9}",
                "ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ສອນ",
                "ອາຈານ",
                "ອາຈານຜ\u{eb9}\u{ec9}ຊາຍ",
                "ໜ\u{eb8}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokytojas"),
            keywords: &["dėstytojas", "mokytojas", "profesorius", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skolotājs"),
            keywords: &["pasniedzējs", "profesors", "skolotājs", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne kaiako"),
            keywords: &["kaiako", "kaitohutohu", "mātanga", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж учител"),
            keywords: &["инструктор", "маж", "наставник", "професор", "учител"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അധ\u{d4d}യ\u{d3e}പകൻ"),
            keywords: &[
                "അധ\u{d4d}യ\u{d3e}പകൻ",
                "പരിശീലകൻ",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "പ\u{d4d}രൊഫസർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй багш"),
            keywords: &["багш", "профессор", "сургагч", "эр", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिक\u{94d}षक"),
            keywords: &[
                "निद\u{947}शक",
                "प\u{941}र\u{942}ष",
                "प\u{94d}राध\u{94d}यापक",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("guru lelaki"),
            keywords: &["guru", "lelaki", "pengajar", "profesor"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għalliem"),
            keywords: &["għalliem", "professur", "raġel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆရာ"),
            keywords: &[
                "ဆရာ",
                "နည\u{103a}းပြ",
                "ပါမောက\u{1039}ခ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig lærer"),
            keywords: &["lærer", "mann", "mannlig lærer", "skole", "undervisning"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष शिक\u{94d}षक"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "प\u{94d}रशिक\u{94d}षक",
                "प\u{94d}राध\u{94d}यापक",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke docent"),
            keywords: &[
                "docent",
                "leraar",
                "mannelijke docent",
                "meester",
                "professor",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg lærar"),
            keywords: &["lærar", "mann", "mannleg lærar", "skule", "undervisning"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ଶ\u{b3f}କ\u{b4d}ଷକ"),
            keywords: &[
                "ଅଧ\u{b4d}ୟ\u{b3e}ପକ",
                "ଉପଦେଷ\u{b4d}ଟ\u{b3e}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ଶ\u{b3f}କ\u{b4d}ଷକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਧਿਆਪਕ"),
            keywords: &[
                "ਅਧਿਆਪਕ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a4d}ਰ\u{a4b}ਫ\u{a48}ਸਰ",
                "ਬ\u{a70}ਦਾ",
                "ਸਿ\u{a71}ਖਿਅਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد استاد"),
            keywords: &["استاد", "بندہ", "مرد استاد", "پروفیسر", "ہدایتاں دین آلا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Tícha"),
            keywords: &[
                "Man",
                "Mán Tícha",
                "Prọfẹ\u{301}sọ",
                "Tícha",
                "Ínstrọ\u{301}ktọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna nauczyciel"),
            keywords: &["mężczyzna", "nauczyciel", "profesor", "wykładowca"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی ښوونکی"),
            keywords: &["سړی ښوونکی", "سړی، ښوونکی پروفيسر، معلم"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("professor"),
            keywords: &["homem", "instrutor", "mestre", "professor"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("professor (homem)"),
            keywords: &["homem", "instrutor", "professor", "professor (homem)"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata yachachiq"),
            keywords: &["instructor", "maestro", "tata", "yachachiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("profesor"),
            keywords: &["instructor", "profesor", "învățător"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1166"),
            keywords: &["E10-1166"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("учитель"),
            keywords: &["мужчина", "преподаватель", "профессор", "учитель"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’umwarimu"),
            keywords: &["umugabo", "umugabo w’umwarimu", "umujyanama", "umwarimu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد استاد"),
            keywords: &["مرد استاد", "مرد، پروفيسر، سيکارڻ وارو، استاد"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ග\u{dd4}ර\u{dd4}වරය\u{dcf}"),
            keywords: &[
                "උපදේශක",
                "ග\u{dd4}ර\u{dd4}වරය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ග\u{dd4}ර\u{dd4}වරය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "මහ\u{dcf}ච\u{dcf}ර\u{dca}යත\u{dd4}ම\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("učiteľ muž"),
            keywords: &["muž", "pedagóg", "profesor", "učiteľ", "škola"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("učitelj"),
            keywords: &["fant", "inštruktor", "moški", "profesor", "učitelj"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin macallin ah"),
            keywords: &["barafasoor", "hagge", "macallin", "nin", "nin macallin ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mësues"),
            keywords: &["burrë", "instruktor", "mësues", "profesor"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("професор"),
            keywords: &["мушкарац", "професор", "учитељ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["професор"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("profesor"),
            keywords: &["muškarac", "profesor", "učitelj"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["profesor"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig lärare"),
            keywords: &["instruktör", "lärare", "man", "manlig", "professor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwalimu na ubao"),
            keywords: &["darasa", "mwalimu", "mwalimu na ubao", "shule"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} ஆசிரியர\u{bcd}"),
            keywords: &["ஆசிரியர\u{bcd}", "ஆண\u{bcd}", "பள\u{bcd}ளி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4b}ధకుడు"),
            keywords: &[
                "పురుషుడు",
                "ప\u{c4d}ర\u{c4a}ఫ\u{c46}సర\u{c4d}",
                "బ\u{c4b}ధకుడు",
                "మగ\u{c3e}డు",
                "శ\u{c3f}క\u{c4d}షకుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди муаллим"),
            keywords: &[
                "дастурдиҳанда",
                "мард",
                "марди муаллим",
                "муаллим",
                "профессор",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คร\u{e39}ชาย"),
            keywords: &[
                "คร\u{e39}",
                "คร\u{e39}ชาย",
                "ผ\u{e39}\u{e49}ชาย",
                "ศาสตราจารย\u{e4c}",
                "อาจารย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek mugallym"),
            keywords: &["erkek", "lektor", "mugallym", "professor"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faiako tangata"),
            keywords: &["faiako tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek öğretmen"),
            keywords: &["adam", "erkek", "eğitmen", "profesör", "öğretmen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر ئوقۇتقۇچى"),
            keywords: &["ئوقۇتقۇچى", "ئەر", "مۇئەللىم", "پىروفېسسور"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("учитель"),
            keywords: &[
                "викладач",
                "вчитель",
                "професор",
                "учитель",
                "чоловік",
                "інструктор",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد استاد"),
            keywords: &["استاد", "اسکول", "مرد استاد", "پروفیسر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak o‘qituvchi"),
            keywords: &["erkak", "o‘qituvchi", "professor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giáo viên nam"),
            keywords: &[
                "giáo sư",
                "giáo viên",
                "giáo viên nam",
                "nam",
                "người hướng dẫn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jàngaletkat bu góor"),
            keywords: &[
                "góor",
                "jàngalekat",
                "jàngaletkat bu góor",
                "meetar",
                "profesër",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utitshala oyindoda"),
            keywords: &[
                "indoda",
                "injingalwazi",
                "umqeqeshi",
                "utitshala",
                "utitshala oyindoda",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin olùkọ\u{301}"),
            keywords: &[
                "olùkọ\u{301}",
                "olùtanisọ\u{301}nà",
                "ọkùnrin",
                "ọ\u{300}mọ\u{300}wé àgbà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男教師"),
            keywords: &["教師", "教授", "男", "男教師", "講師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男教师"),
            keywords: &["教师", "教授", "男", "男教师", "讲师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男老师"),
            keywords: &["教师", "教授", "男", "男老师", "老师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男老師"),
            keywords: &["教授", "男", "男老師", "老師", "講師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uthisha wesilisa"),
            keywords: &[
                "indoda",
                "umyaleli",
                "usolwazi",
                "uthisha",
                "uthisha wesilisa",
            ],
        },
    ],
};
#[doc = "👨🏻\u{200d}🏫"]
pub const MAN_TEACHER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🏫",
    codepoint: "1F468 1F3FB 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man teacher: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🏫"]
pub const MAN_TEACHER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🏫",
    codepoint: "1F468 1F3FC 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man teacher: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🏫"]
pub const MAN_TEACHER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🏫",
    codepoint: "1F468 1F3FD 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man teacher: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🏫"]
pub const MAN_TEACHER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🏫",
    codepoint: "1F468 1F3FE 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man teacher: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🏫"]
pub const MAN_TEACHER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🏫",
    codepoint: "1F468 1F3FF 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man teacher: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🏫"]
pub const WOMAN_TEACHER: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🏫",
    codepoint: "1F469 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman teacher",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike onderwyser"),
            keywords: &[
                "juffrou",
                "onderwyser",
                "onderwyseres",
                "opvoeder",
                "skool",
                "vroulike onderwyser",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት አስተማሪ"),
            keywords: &["ሴት", "አስተማሪ", "ፕሮፌሰር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("معلمة"),
            keywords: &["أستاذة", "أستاذة جامعية", "مدرسة", "مربية", "معلمة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিক\u{9cd}ষয\u{9bc}িত\u{9cd}ৰী"),
            keywords: &[
                "অধ\u{9cd}য\u{9be}পক",
                "নিৰ\u{9cd}দেশক",
                "মহিল\u{9be}",
                "শিক\u{9cd}ষক",
                "শিক\u{9cd}ষয\u{9bc}িত\u{9cd}ৰী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın müəllim"),
            keywords: &["müəllim", "professor", "qadın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("настаўніца"),
            keywords: &["выкладчыца", "жанчына", "настаўніца", "прафесар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("учителка"),
            keywords: &["инструкторка", "лектор", "преподавателка", "учителка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিক\u{9cd}ষিক\u{9be}"),
            keywords: &[
                "অধ\u{9cd}য\u{9be}পিক\u{9be}",
                "ইনস\u{9cd}ট\u{9cd}র\u{9be}কটর",
                "মহিল\u{9be}",
                "শিক\u{9cd}ষিক\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kelennerez"),
            keywords: &["kelennerez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("profesorica"),
            keywords: &["nastavnik", "profesor", "profesorica", "učitelj", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("professora"),
            keywords: &["dona", "femení", "instructora", "mestra", "professora"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄟𑄌\u{11134}𑄑\u{11127}𑄢\u{11134}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄟𑄌\u{11134}𑄑\u{11127}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᏕᏲᎲᏍᎩ"),
            keywords: &["ᎠᎨᏯ", "ᎠᏓᏎᎮᎯ", "ᎤᏔᎾ ᏗᏕᏲᎲᏍᎩ", "ᏗᏕᏲᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("učitelka"),
            keywords: &["instruktorka", "profesorka", "učitelka", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("athrawes"),
            keywords: &["athrawes", "benywaidd", "hyfforddwraig", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig lærer"),
            keywords: &[
                "kvinde",
                "kvindelig lærer",
                "lærerinde",
                "professor",
                "underviser",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lehrerin"),
            keywords: &["Dozentin", "Lehrerin", "Professorin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δασκάλα"),
            keywords: &["γυναίκα", "δασκάλα", "εκπαίδευση", "καθηγήτρια"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman teacher"),
            keywords: &["instructor", "professor", "teacher", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("docente mujer"),
            keywords: &[
                "docente mujer",
                "educadora",
                "instructora",
                "maestra",
                "mujer",
                "profesora",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisõpetaja"),
            keywords: &["juhendaja", "naine", "naisõpetaja", "professor", "õpetaja"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume irakaslea"),
            keywords: &[
                "andereño",
                "emakume",
                "emakume irakaslea",
                "emakumezko",
                "irakasle",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آموزگار زن"),
            keywords: &["آموزگار زن", "استاد", "خانم معلم", "دبیر", "مدرس", "معلم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisopettaja"),
            keywords: &["koulu", "nainen", "naisopettaja", "opettaja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng guro"),
            keywords: &["babae", "babaeng guro", "guro", "propesor", "titser"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur lærari"),
            keywords: &[
                "kona",
                "kvinna",
                "kvinnuligur lærari",
                "lærari",
                "lærarinna",
                "professari",
                "vegleiðari",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("enseignante"),
            keywords: &[
                "enseignante",
                "femme",
                "institutrice",
                "instructrice",
                "professeure",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("múinteoir baineann"),
            keywords: &["bean", "múinteoir baineann", "oide", "ollamh", "teagascóir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ban-oide"),
            keywords: &[
                "ban-oide",
                "boireannach",
                "oide",
                "ollamh",
                "tidsear",
                "tè",
                "àrd-ollamh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("profesora"),
            keywords: &["colexio", "escola", "mestra", "muller", "profesora"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શિક\u{acd}ષિકા"),
            keywords: &[
                "પ\u{acd}રશિક\u{acd}ષક",
                "પ\u{acd}રોફ\u{ac7}સર",
                "શિક\u{acd}ષકા",
                "શિક\u{acd}ષિકા",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace malami"),
            keywords: &["frafesa", "mace", "mai koyarwa", "malami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מו\u{5b9}ר\u{5b8}ה"),
            keywords: &[
                "אישה",
                "מו\u{5b9}ר\u{5b8}ה",
                "מורה",
                "מנחה",
                "מרצה",
                "פרופסורית",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अध\u{94d}यापिका"),
            keywords: &[
                "अध\u{94d}यापिका",
                "प\u{94d}रशिक\u{94d}षक",
                "प\u{94d}रोफ\u{947}सर",
                "महिला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("učiteljica"),
            keywords: &["nastavnica", "profesorica", "učiteljica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tanárnő"),
            keywords: &["nő", "oktató", "professzorasszony", "tanárnő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուսուցչուհի"),
            keywords: &["դասատու", "կին", "ուսուցիչ", "ուսուցչուհի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pengajar wanita"),
            keywords: &["pengajar", "pengajar wanita", "perempuan", "sekolah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị ọkammụta"),
            keywords: &["nwanyị", "onyenkuzi", "onyentụzịaka", "ọkammụta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns kennari"),
            keywords: &[
                "kennari",
                "kona",
                "kvenkyns kennari",
                "leiðbeinandi",
                "skóli",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("professoressa"),
            keywords: &["insegnante", "professoressa", "scuola", "studio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性の教師"),
            keywords: &["先生", "女", "女性", "女性の教師", "教師", "教授"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("guru wadon"),
            keywords: &["dosen", "guru", "instruktur", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მასწავლებელი ქალი"),
            keywords: &[
                "ინსტრუქტორი",
                "მასწავლებელი",
                "მეცნიერი",
                "პროფესორი",
                "ქალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мұғалім әйел"),
            keywords: &["мұғалім", "оқытушы", "ұстаз", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig lærer"),
            keywords: &[
                "kvinde",
                "kvindelig lærer",
                "lærerinde",
                "professor",
                "underviser",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកគ\u{17d2}រ\u{17bc}"),
            keywords: &[
                "គ\u{17d2}រ\u{17bc}",
                "នារ\u{17b8}",
                "សាស\u{17d2}ត\u{17d2}រាចារ\u{17d2}យ",
                "ស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកគ\u{17d2}រ\u{17bc}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{cbf}ಕ\u{ccd}ಷಕ\u{cbf}"),
            keywords: &[
                "ಪ\u{ccd}ರಾಧ\u{ccd}ಯಾಪಕ\u{cbf}",
                "ಬೋಧಕ\u{cbf}",
                "ಶ\u{cbf}ಕ\u{ccd}ಷಕ\u{cbf}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여교사"),
            keywords: &["강사", "강연자", "교사", "교수", "선생님", "여교사", "여자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल शिक\u{94d}षक"),
            keywords: &[
                "प\u{94d}रोफ\u{947}सर",
                "बायल",
                "मार\u{94d}गदर\u{94d}शक",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял мугалим"),
            keywords: &["аял", "мугалим", "окутуучу", "профессор"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Enseignante"),
            keywords: &["Enseignante", "Fra", "Professer", "Schoulmeeschtesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອາຈານຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ"),
            keywords: &[
                "ຄ\u{eb9}",
                "ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ສອນ",
                "ອາຈານ",
                "ອາຈານຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ໜ\u{eb8}\u{ec8}ມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokytoja"),
            keywords: &["dėstytoja", "mokytoja", "moteris", "profesorė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("skolotāja"),
            keywords: &["pasniedzēja", "profesore", "sieviete", "skolotāja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaiako wahine"),
            keywords: &["kaiako", "kaitohutohu", "mātanga", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("учителка"),
            keywords: &["жена", "наставничка", "професорка", "учителка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അധ\u{d4d}യ\u{d3e}പിക"),
            keywords: &[
                "അധ\u{d4d}യ\u{d3e}പിക",
                "ടീച\u{d4d}ചർ",
                "പരിശീലക",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй багш"),
            keywords: &["багш", "профессор", "сургагч", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिक\u{94d}षिका"),
            keywords: &[
                "निद\u{947}शक",
                "प\u{94d}राध\u{94d}यापक",
                "महिला शिक\u{94d}षिका",
                "शिक\u{94d}षक",
                "शिक\u{94d}षिका",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("guru wanita"),
            keywords: &["guru", "pengajar", "profesor", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għalliema"),
            keywords: &["għalliem", "għalliema", "mara", "professur"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆရာမ"),
            keywords: &[
                "ဆရာမ",
                "နည\u{103a}းပြ",
                "ပါမောက\u{1039}ခ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig lærer"),
            keywords: &[
                "kvinne",
                "kvinnelig lærer",
                "lærer",
                "skole",
                "undervisning",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला शिक\u{94d}षिका"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "प\u{94d}रशिक\u{94d}षक",
                "प\u{94d}राध\u{94d}यापक",
                "महिला",
                "महिला शिक\u{94d}षिका",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("docente"),
            keywords: &["docente", "juf", "lerares", "professor"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg lærar"),
            keywords: &[
                "kvinne",
                "kvinneleg lærar",
                "lærar",
                "skule",
                "undervisning",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ଶ\u{b3f}କ\u{b4d}ଷକ"),
            keywords: &[
                "ଅଧ\u{b4d}ୟ\u{b3e}ପକ",
                "ଉପଦେଷ\u{b4d}ଟ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ଶ\u{b3f}କ\u{b4d}ଷକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅਧਿਆਪਕਾ"),
            keywords: &[
                "ਅਧਿਆਪਕਾ",
                "ਇਸਤਰੀ",
                "ਔਰਤ",
                "ਪ\u{a4d}ਰ\u{a4b}ਫ\u{a48}ਸਰ",
                "ਸਿ\u{a71}ਖਿਅਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانہ استانی"),
            keywords: &[
                "استاد",
                "زنانہ استانی",
                "زنانی",
                "پروفیسر",
                "ہدایتاں دین آلا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Tícha"),
            keywords: &[
                "Prọfẹ\u{301}sọ",
                "Tícha",
                "Wúman",
                "Wúmán Tícha",
                "Ínstrọ\u{301}ktọ",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nauczycielka"),
            keywords: &["kobieta", "nauczycielka", "profesor", "wykładowczyni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه ښوونکي"),
            keywords: &["ښوونکی، پروفيسر، معلم، ښځه", "ښځه ښوونکي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("professora"),
            keywords: &["instrutora", "mestra", "mulher", "professora"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["instrutora", "mulher", "professora"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi yachachiq"),
            keywords: &["instructor", "maestro", "warmi", "yachachiq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("profesoară"),
            keywords: &["instructoare", "profesoară", "învățătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1182"),
            keywords: &["E10-1182"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("учительница"),
            keywords: &["женщина", "преподаватель", "профессор", "учительница"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwarimukazi"),
            keywords: &["umugore", "umujyanama", "umwarimu", "umwarimukazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت استاد"),
            keywords: &["عورت استاد", "مرد جج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ග\u{dd4}ර\u{dd4}වර\u{dd2}ය"),
            keywords: &[
                "උපදේශක",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ග\u{dd4}ර\u{dd4}වර\u{dd2}ය",
                "මහ\u{dcf}ච\u{dcf}ර\u{dca}යත\u{dd4}ම\u{dd2}ය",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("učiteľka"),
            keywords: &["pedagogička", "profesorka", "učiteľka", "škola", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("učiteljica"),
            keywords: &[
                "dekle",
                "inštruktorica",
                "profesorica",
                "učiteljica",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag macallimad ah"),
            keywords: &[
                "barafasoor",
                "hagge",
                "macallin",
                "naag",
                "naag macallimad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mësuese"),
            keywords: &["Instruktore", "grua", "mësuese", "profesore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("професорка"),
            keywords: &["жена", "професор", "професорка", "учитељ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("profesorka"),
            keywords: &["profesor", "profesorka", "učitelj", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig lärare"),
            keywords: &[
                "instruktör",
                "kvinna",
                "kvinnlig",
                "kvinnlig lärare",
                "lärarinna",
                "professor",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwalimu wa kike na ubao"),
            keywords: &["darasa", "mwalimu", "mwalimu wa kike na ubao", "shule"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} ஆசிரியர\u{bcd}"),
            keywords: &["ஆசிரியர\u{bcd}", "பள\u{bcd}ளி", "பெண\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4b}ధకుర\u{c3e}లు"),
            keywords: &[
                "ప\u{c4d}ర\u{c4a}ఫ\u{c46}సర\u{c4d}",
                "బ\u{c4b}ధకుర\u{c3e}లు",
                "మహ\u{c3f}ళ",
                "శ\u{c3f}క\u{c4d}షకుర\u{c3e}లు",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани муаллим"),
            keywords: &[
                "дастурдиҳанда",
                "зан",
                "зани муаллим",
                "муаллим",
                "профессор",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คร\u{e39}หญ\u{e34}ง"),
            keywords: &[
                "คร\u{e39}",
                "คร\u{e39}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ศาสตราจารย\u{e4c}",
                "อาจารย\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan mugallym"),
            keywords: &["lektor", "mugallym", "professor", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faiako fefine"),
            keywords: &["faiako fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın öğretmen"),
            keywords: &["bayan", "eğitmen", "kadın", "profesör", "öğretmen"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال ئوقۇتقۇچى"),
            keywords: &["ئايال", "ئوقۇتقۇچى", "مۇئەللىم", "پىروفېسسور"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("учителька"),
            keywords: &[
                "викладачка",
                "вчителька",
                "жінка",
                "професор",
                "учителька",
                "інструктор",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("استانی"),
            keywords: &["استانی", "اسکول", "پروفیسر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol o‘qituvchi"),
            keywords: &["ayol", "o‘qituvchi", "professor"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("giáo viên nữ"),
            keywords: &[
                "giáo sư",
                "giáo viên",
                "giáo viên nữ",
                "người hướng dẫn",
                "phụ nữ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jàngalekat bu jigéen"),
            keywords: &[
                "jigéen",
                "jàngalekat",
                "jàngalekat bu jigéen",
                "meetar",
                "profesër",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("utitshala olibhinqa"),
            keywords: &[
                "ibhinqa",
                "umqeqeshi",
                "unjingalwazi",
                "utitshala",
                "utitshala olibhinqa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin olùkọ\u{301}"),
            keywords: &[
                "obìnrin olùkọ\u{301}",
                "obìrin",
                "olùkọ\u{301}",
                "olùtanisọ\u{301}nà",
                "ọ\u{300}mọ\u{300}wé àgbà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女教師"),
            keywords: &["女", "女教師", "教師", "教授", "講師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女教师"),
            keywords: &["女", "女教师", "教师", "教授", "讲师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女老师"),
            keywords: &["女", "女老师", "教师", "教授", "老师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女老師"),
            keywords: &["女", "女老師", "教授", "老師", "講師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uthisha wesifazane"),
            keywords: &[
                "owesimame",
                "umyaleli",
                "usolwazi",
                "uthisha",
                "uthisha wesifazane",
            ],
        },
    ],
};
#[doc = "👩🏻\u{200d}🏫"]
pub const WOMAN_TEACHER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🏫",
    codepoint: "1F469 1F3FB 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman teacher: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🏫"]
pub const WOMAN_TEACHER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🏫",
    codepoint: "1F469 1F3FC 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman teacher: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🏫"]
pub const WOMAN_TEACHER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🏫",
    codepoint: "1F469 1F3FD 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman teacher: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🏫"]
pub const WOMAN_TEACHER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🏫",
    codepoint: "1F469 1F3FE 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman teacher: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🏫"]
pub const WOMAN_TEACHER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🏫",
    codepoint: "1F469 1F3FF 200D 1F3EB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman teacher: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}⚖\u{fe0f}"]
pub const JUDGE: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}⚖\u{fe0f}",
    codepoint: "1F9D1 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "judge",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑\u{200d}⚖",
        codepoint: "1F9D1 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "judge",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("regter"),
            keywords: &["regter", "regtershammer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዳኛ"),
            keywords: &["ዳኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قاضي"),
            keywords: &["عدالة", "عدل", "قاضي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিচ\u{9be}ৰক"),
            keywords: &["বিচ\u{9be}ৰক", "স\u{9cd}কেলসম\u{9c2}হ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("hakim"),
            keywords: &["hakim", "tərəzi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("суддзя"),
            keywords: &["суддзя", "шалі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("съдия"),
            keywords: &["везни", "съдия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিচ\u{9be}রপতি"),
            keywords: &[
                "ত\u{9c1}ল\u{9be}দণ\u{9cd}ড",
                "বিচ\u{9be}রক",
                "বিচ\u{9be}রপতি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sudija"),
            keywords: &["sudija", "vaga s dva tasa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("jutge"),
            keywords: &["balança", "jutge"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎫᎪᏗᏍᎩ"),
            keywords: &["ᏗᎦᏛᏗ", "ᏗᎫᎪᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("soudce/soudkyně"),
            keywords: &[
                "právo",
                "soudce",
                "soudce/soudkyně",
                "soudkyně",
                "spravedlnost",
                "váhy",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n barnu"),
            keywords: &["barnwr", "clorian", "person sy’n barnu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dommer"),
            keywords: &["dommer", "domstol", "retfærdighed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Richter(in)"),
            keywords: &["Richter(in)", "Waage"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δικαστής"),
            keywords: &["δικαστής", "ζυγαριά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("judge"),
            keywords: &["judge", "justice", "scales"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["judge", "law"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["judge", "law"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fiscal"),
            keywords: &["fiscal", "juez", "juicio", "magistrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("juez"),
            keywords: &["juez"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("juez"),
            keywords: &["juez"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kohtunik"),
            keywords: &["kohtunik", "kohus", "õigusemõistmine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("epailea"),
            keywords: &["balantzak", "epaile", "epailea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قاضی"),
            keywords: &["ترازو", "قاضی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tuomari"),
            keywords: &["tuomari", "vaaka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hukom"),
            keywords: &["hukom", "timbangan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("dómari"),
            keywords: &["dómari", "rættvísi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("juge"),
            keywords: &["balance", "juge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("juge"),
            keywords: &["balance", "juge"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("breitheamh"),
            keywords: &["breitheamh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("britheamh"),
            keywords: &["britheamh", "meidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("membro da xudicatura"),
            keywords: &[
                "balanza",
                "membro da xudicatura",
                "xudicatura",
                "xustiza",
                "xuíz",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જજ"),
            keywords: &["જજ", "ત\u{acd}રાજવ\u{ac1}\u{a82}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שופט/ת"),
            keywords: &[
                "מאזני הצדק",
                "מאזניים",
                "משפט",
                "משפטים",
                "שופט",
                "שופט/ת",
                "שופטת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जज"),
            keywords: &["जज", "न\u{94d}याय", "न\u{94d}यायाधीश"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("arbitar"),
            keywords: &["arbitar", "sudac", "vaga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bíró / bírónő"),
            keywords: &["bíró", "bíró / bírónő", "mérleg"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դատավոր"),
            keywords: &["դատավոր", "կշեռք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hakim"),
            keywords: &["hakim", "timbangan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("dómari"),
            keywords: &["dómari", "vog"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("giudice"),
            keywords: &["bilancia", "giudice", "giustizia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("裁判官"),
            keywords: &["裁判", "裁判官"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("hakim"),
            keywords: &["hakim", "timbangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოსამართლე"),
            keywords: &["მოსამართლე", "სასწორი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сот"),
            keywords: &["сот", "әділет"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចៅក\u{17d2}រម"),
            keywords: &["ចៅក\u{17d2}រម", "ជញ\u{17d2}ជ\u{17b8}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{ccd}ಯಾಯಾಧೀಶ"),
            keywords: &["ನ\u{ccd}ಯಾಯಾಧೀಶ", "ಮಾಪಕಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("판사"),
            keywords: &["저울", "판사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("न\u{94d}यायाधीश"),
            keywords: &["तागडी", "न\u{94d}यायाधीश"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сот"),
            keywords: &["сот"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ພ\u{eb4}ພາກສາ"),
            keywords: &["ຕາຊ\u{eb1}\u{ec8}ງ", "ຜ\u{eb9}\u{ec9}ພ\u{eb4}ພາກສາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("teisiantis žmogus"),
            keywords: &["svarstyklės", "teisiantis žmogus", "teisėjas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("soģis"),
            keywords: &["soģis", "svari", "tiesnesis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("судија"),
            keywords: &["вага", "судија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d4d}യ\u{d3e}യ\u{d3e}ധിപൻ"),
            keywords: &["ത\u{d41}ല\u{d3e}സ\u{d41}കൾ", "ന\u{d4d}യ\u{d3e}യ\u{d3e}ധിപൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шүүгч"),
            keywords: &["хэмжүүрүүд", "шүүгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{94d}याय द\u{947}णारा"),
            keywords: &["न\u{94d}याय द\u{947}णारा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hakim"),
            keywords: &["hakim", "neraca"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တရားသ\u{1030}ကြ\u{102e}း"),
            keywords: &[
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}",
                "တရားသ\u{1030}ကြ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("dommer"),
            keywords: &["dommer", "jus", "juss"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("न\u{94d}यायधिश"),
            keywords: &["तराज\u{941}", "न\u{94d}यायधिश", "न\u{94d}यायाधीश"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("rechter"),
            keywords: &["rechter", "weegschaal"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("dommar"),
            keywords: &["dommar", "jus", "juss"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3f}ଚ\u{b3e}ରପତ\u{b3f}"),
            keywords: &["ବ\u{b3f}ଚ\u{b3e}ରପତ\u{b3f}", "ସ\u{b4d}କେଲ\u{b4d}\u{200c}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a71}ਜ"),
            keywords: &["ਜ\u{a71}ਜ", "ਤਰਾਜ\u{a42}", "ਤ\u{a71}ਕੜੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jọj"),
            keywords: &["Jọj", "Skel"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("sędzia"),
            keywords: &["orzekać", "sędzia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("قاضي"),
            keywords: &["تلې", "قاضي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("juiz no tribunal"),
            keywords: &["balança", "juiz", "juiz no tribunal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("juiz"),
            keywords: &["balança", "juiz", "justiça"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("juez"),
            keywords: &["aysana", "juez"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("judecător sau judecătoare"),
            keywords: &["balanță", "judecător", "judecător sau judecătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-010"),
            keywords: &["E13-010"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("судья"),
            keywords: &["весы", "правосудие", "судья", "фемида"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جج"),
            keywords: &["اسڪيل", "جج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}න\u{dd2}ස\u{dd4}ර\u{dd4}"),
            keywords: &["ත\u{dd4}ල\u{dcf}ව", "ව\u{dd2}න\u{dd2}ස\u{dd4}ර\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sudca"),
            keywords: &["justícia", "sudca", "váhy"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("varuh zakona"),
            keywords: &["sodnik", "tehtnica", "varuh zakona"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qaalli"),
            keywords: &["qaalli", "qaalli, miisaanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person gjykatës"),
            keywords: &["gjykatës", "person gjykatës", "peshore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("судија/ница"),
            keywords: &["правда", "судија", "судија/ница"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sudija/nica"),
            keywords: &["pravda", "sudija", "sudija/nica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("domare"),
            keywords: &["advokat", "domare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("hakimu"),
            keywords: &["haki", "hakimu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bc0}திபதி"),
            keywords: &["ந\u{bc0}திபதி", "மதிப\u{bcd}ப\u{bc0}டுகள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}"),
            keywords: &[
                "న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}",
                "స\u{c4d}క\u{c47}ల\u{c4d}స\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}พ\u{e34}พากษา"),
            keywords: &["ตราช\u{e31}\u{e48}ง", "ผ\u{e39}\u{e49}พ\u{e34}พากษา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kazy"),
            keywords: &["kazy", "terezi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakamaau"),
            keywords: &["fakamaau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hakim"),
            keywords: &["adalet", "hakim", "terazi", "yargıç"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суддя"),
            keywords: &["суддя", "терези"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جج"),
            keywords: &["جج", "پیمانے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sudya"),
            keywords: &["sudya", "tarozi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thẩm phán"),
            keywords: &["cầm cân nảy mực", "thẩm phán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("法官"),
            keywords: &["尺度", "法官"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("法官"),
            keywords: &["尺度", "法官"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("法官"),
            keywords: &["法官", "法律"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("法官"),
            keywords: &["正義", "法官"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umahluleli"),
            keywords: &["izikali", "umahluleli"],
        },
    ],
};
#[doc = "🧑🏻\u{200d}⚖\u{fe0f}"]
pub const JUDGE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}⚖\u{fe0f}",
    codepoint: "1F9D1 1F3FB 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "judge: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏻\u{200d}⚖",
        codepoint: "1F9D1 1F3FB 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "judge: light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}⚖\u{fe0f}"]
pub const JUDGE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}⚖\u{fe0f}",
    codepoint: "1F9D1 1F3FC 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "judge: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏼\u{200d}⚖",
        codepoint: "1F9D1 1F3FC 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "judge: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}⚖\u{fe0f}"]
pub const JUDGE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}⚖\u{fe0f}",
    codepoint: "1F9D1 1F3FD 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "judge: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏽\u{200d}⚖",
        codepoint: "1F9D1 1F3FD 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "judge: medium skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}⚖\u{fe0f}"]
pub const JUDGE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}⚖\u{fe0f}",
    codepoint: "1F9D1 1F3FE 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "judge: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏾\u{200d}⚖",
        codepoint: "1F9D1 1F3FE 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "judge: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}⚖\u{fe0f}"]
pub const JUDGE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}⚖\u{fe0f}",
    codepoint: "1F9D1 1F3FF 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "judge: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧑🏿\u{200d}⚖",
        codepoint: "1F9D1 1F3FF 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12.1f32,
        name: "judge: dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨\u{200d}⚖\u{fe0f}"]
pub const MAN_JUDGE: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}⚖\u{fe0f}",
    codepoint: "1F468 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man judge",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨\u{200d}⚖",
        codepoint: "1F468 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man judge",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike regter"),
            keywords: &["hof", "landdros", "magistraat", "manlike regter", "regter"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ዳኛ"),
            keywords: &["ሚዛን", "ተባዕት", "ወንድ", "ወንድ ዳኛ", "ፍትህ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قاض\u{64d}"),
            keywords: &["عدالة", "عدل", "قاض\u{64d}"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ ন\u{9cd}য\u{9be}য\u{9bc}\u{9be}ধীশ"),
            keywords: &[
                "ন\u{9cd}য\u{9be}য\u{9bc}",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ ন\u{9cd}য\u{9be}য\u{9bc}\u{9be}ধীশ",
                "স\u{9cd}কেলসম\u{9c2}হ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi hakim"),
            keywords: &["kişi", "kişi hakim", "tərəzi", "ədalət"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("суддзя-мужчына"),
            keywords: &["мужчына", "правасуддзе", "суддзя-мужчына", "шалі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж съдия"),
            keywords: &["везни", "мъж съдия", "правосъдие", "съдия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ বিচ\u{9be}রক"),
            keywords: &[
                "ছেল",
                "দ\u{9be}\u{981}ড\u{9bc}িপ\u{9be}ল\u{9cd}ল\u{9be}",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ বিচ\u{9be}রক",
                "বিচ\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("barner"),
            keywords: &["barner"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac sudija"),
            keywords: &["muškarac", "pravda", "sudija", "vaga"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home jutge"),
            keywords: &["balança", "home", "justícia", "jutge", "masculí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏗᎫᎪᏗᏍᎩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ ᏗᎫᎪᏗᏍᎩ", "ᏗᎦᏛᏗ", "ᏗᎧᎿᏩᏛᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("soudce"),
            keywords: &["muž", "právo", "soudce", "spravedlnost", "váhy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("barnwr"),
            keywords: &["barnwr", "clorian", "cyfiawnder", "dyn", "gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig dommer"),
            keywords: &["jura", "lov", "mand", "mandlig dommer", "retfærdighed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Richter"),
            keywords: &["Gerechtigkeit", "Recht", "Richter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας δικαστής"),
            keywords: &["άντρας", "δικαστήριο", "δικαστής", "νομική"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man judge"),
            keywords: &["judge", "justice", "man", "scales"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fiscal hombre"),
            keywords: &["fiscal hombre", "hombre", "juez", "justicia", "magistrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("juez hombre"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeskohtunik"),
            keywords: &["kohus", "mees", "meeskohtunik", "õigusemõistmine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon epailea"),
            keywords: &[
                "balantza",
                "gizon",
                "gizon epailea",
                "gizonezko",
                "justizia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قاضی مرد"),
            keywords: &[
                "آقای قاضی",
                "آقای وکیل",
                "دادرس",
                "دادستان",
                "دادگاه",
                "قاضی مرد",
                "وکیل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miestuomari"),
            keywords: &["laki", "mies", "miestuomari", "oikeus", "tuomari"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking hukom"),
            keywords: &["hukom", "hustisya", "huwes", "lalaki", "lalaking hukom"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur dómari"),
            keywords: &["dómari", "mannligur dómari", "maður", "rættvísi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("juge homme"),
            keywords: &["balance", "homme", "juge homme", "justice"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["balance", "homme", "juge", "justice"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("breitheamh fireann"),
            keywords: &["breitheamh fireann", "ceartas", "fear", "meá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("britheamh fireann"),
            keywords: &[
                "britheamh",
                "britheamh fireann",
                "duine",
                "fear",
                "fireannach",
                "meidh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xuíz"),
            keywords: &["balanza", "home", "xustiza", "xuíz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ન\u{acd}યાયાધીશ"),
            keywords: &[
                "તરાજ\u{ac1}",
                "ન\u{acd}યાય",
                "ન\u{acd}યાયાધીશ",
                "પ\u{ac1}ર\u{ac1}ષ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum joji"),
            keywords: &["mutum", "mutum joji", "shari’a", "sikeloli"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שופט"),
            keywords: &["איש", "גבר", "מאזניים", "משפט", "צדק", "שופט"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("न\u{94d}यायाधीश"),
            keywords: &[
                "आदमी",
                "तराज\u{942}",
                "न\u{94d}याय",
                "न\u{94d}यायाधीश",
                "प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sudac"),
            keywords: &["pravda", "pravo", "sudac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bíró"),
            keywords: &["bíró"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ դատավոր"),
            keywords: &["դատավոր", "տղամարդ", "օրենք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hakim pria"),
            keywords: &["hakim pria", "hukum", "laki-laki", "pengadilan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke ikpe"),
            keywords: &["ikpe nkwụọtọ", "nsialọ", "nwoke", "nwoke ikpe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns dómari"),
            keywords: &["dómari", "dómur", "karl", "karlkyns dómari", "réttur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("giudice uomo"),
            keywords: &["bilancia", "giudice", "giustizia", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性の裁判官"),
            keywords: &["男", "男性", "男性の裁判官", "裁判", "裁判官"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("hakim lanang"),
            keywords: &["adil", "hakim lanang", "lanang", "pradata", "timbangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოსამართლე კაცი"),
            keywords: &["კაცი", "მოსამართლე"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сот ер"),
            keywords: &["ер", "сот", "әділет"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dommer"),
            keywords: &["dommer", "jura", "lov", "mand", "retfærdighed"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចៅក\u{17d2}រ\u{17bb}មប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ចៅក\u{17d2}រម",
                "ចៅក\u{17d2}រ\u{17bb}មប\u{17d2}រ\u{17bb}ស",
                "ត\u{17bb}លាការ",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ನ\u{ccd}ಯಾಯಾಧೀಶರು"),
            keywords: &[
                "ನ\u{ccd}ಯಾಯ",
                "ಪುರುಷ",
                "ಪುರುಷ ನ\u{ccd}ಯಾಯಾಧೀಶರು",
                "ಮಾಪಕಗಳು",
                "ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 판사"),
            keywords: &["남자", "법조인", "정의", "판사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो न\u{94d}यायाधीश"),
            keywords: &["तागडी", "दादलो", "दादलो न\u{94d}यायाधीश", "न\u{94d}याय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек сот"),
            keywords: &["сот", "тараза", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Riichter"),
            keywords: &["Geriicht", "Justiz", "Riichter", "Wo"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ພ\u{eb4}ພາກສາຊາຍ"),
            keywords: &[
                "ຊາຍ",
                "ຍ\u{eb8}ດຕ\u{eb4}ທຳ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ພ\u{eb4}ພາກສາຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("teisėjas"),
            keywords: &["svarstyklės", "teisingumas", "teisėjas", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tiesnesis"),
            keywords: &["likums", "svari", "tiesnesis", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaiwhakawā tāne"),
            keywords: &["kaiwhakawā tāne", "te whakawā", "tāne", "whārite"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж судија"),
            keywords: &["маж", "правда", "судија"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജഡ\u{d4d}ജി"),
            keywords: &["കോടതി", "ജഡ\u{d4d}ജി", "നീതി", "പ\u{d41}ര\u{d41}ഷൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй шүүгч"),
            keywords: &["дэнс", "шүүх", "эр", "эрэгтэй", "эрэгтэй шүүгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{94d}यायाधीश"),
            keywords: &[
                "तराज\u{942}",
                "न\u{94d}याय",
                "न\u{94d}यायाधीश",
                "प\u{941}र\u{942}ष",
                "शिक\u{94d}षक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hakim lelaki"),
            keywords: &["hakim", "lelaki", "neraca"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imħallef maskil"),
            keywords: &["imħallef maskil", "miżien", "raġel", "ġustizzja"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား တရားသ\u{1030}ကြ\u{102e}း"),
            keywords: &[
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}",
                "တရားသ\u{1030}ကြ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig dommer"),
            keywords: &[
                "dommer",
                "jus",
                "juss",
                "mann",
                "mannlig dommer",
                "rettssak",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष न\u{94d}यायधिश"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "न\u{94d}याय",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष न\u{94d}यायधिश",
                "स\u{94d}क\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke rechter"),
            keywords: &["man", "mannelijke rechter", "rechter"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg dommar"),
            keywords: &[
                "dommar",
                "jus",
                "juss",
                "mann",
                "mannleg dommar",
                "rettssak",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ବ\u{b3f}ଚ\u{b3e}ରପତ\u{b3f}"),
            keywords: &[
                "ତର\u{b3e}ଜ\u{b41}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ବ\u{b3f}ଚ\u{b3e}ରପତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a71}ਜ ਸਾਹਬ"),
            keywords: &["ਜਸਟਿਸ", "ਜ\u{a71}ਜ ਸਾਹਬ", "ਪ\u{a41}ਰਸ\u{a3c}", "ਬ\u{a70}ਦਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد جج"),
            keywords: &["انصاف", "بندہ", "تکڑی", "مرد جج"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Jọj"),
            keywords: &[
                "Jọ\u{301}stis",
                "Man",
                "Mán Jọj",
                "Skel Wé Dẹm De Ték Mẹ\u{301}zhọ\u{301} Sọ\u{301}mtin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna sędzia"),
            keywords: &["mężczyzna", "sędzia"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی قاضي"),
            keywords: &["انصاف، سړی، سړی قاضي، تلې", "سړی قاضي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("juiz"),
            keywords: &["balança", "homem", "juiz", "justiça"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("juiz (homem)"),
            keywords: &["balança", "homem", "juiz", "juiz (homem)", "justiça"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata juez"),
            keywords: &["aysana", "justicia", "tata", "tata juez"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("judecător"),
            keywords: &["balanță", "judecător", "justiție"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1159"),
            keywords: &["E10-1159"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-судья"),
            keywords: &["закон", "мужчина", "мужчина-судья", "суд", "судья"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’umucamanza"),
            keywords: &["ubutabera", "umugabo", "umugabo w’umucamanza", "umunzani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد جج"),
            keywords: &["انصاف، مرد، ترازو", "مرد جج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}න\u{dd2}ස\u{dd4}ර\u{dd4}ත\u{dd4}ම\u{dcf}"),
            keywords: &[
                "ත\u{dd4}ල\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "ව\u{dd2}න\u{dd2}ස\u{dd4}ර\u{dd4}ත\u{dd4}ම\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sudca muž"),
            keywords: &["muž", "právo", "sudca", "zákon"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sodnik"),
            keywords: &[
                "fant",
                "moški",
                "pravica",
                "pravosodje",
                "sodnik",
                "tehtnica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin garsoore ah"),
            keywords: &["caddaalad", "miisaan", "nin", "nin garsoore ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjykatës"),
            keywords: &["burrë", "drejtësi", "gjykatës", "peshore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац судија"),
            keywords: &["мушкарац", "правда", "судија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac sudija"),
            keywords: &["muškarac", "pravda", "sudija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig domare"),
            keywords: &["advokat", "jurist", "man", "manlig", "manlig domare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jaji wa kiume"),
            keywords: &["hakimu", "jaji", "jaji wa kiume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} ந\u{bc0}திபதி"),
            keywords: &["ஆண\u{bcd}", "சட\u{bcd}டம\u{bcd}", "ந\u{bc0}திபதி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మగ న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}"),
            keywords: &[
                "న\u{c4d}య\u{c3e}యం",
                "పురుషుడు",
                "మగ న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}",
                "మగ\u{c3e}డు",
                "స\u{c4d}క\u{c47}ల\u{c4d}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди судя"),
            keywords: &["адолат", "мард", "марди судя", "тарозу"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}พ\u{e34}พากษาชาย"),
            keywords: &[
                "ความย\u{e38}ต\u{e34}ธรรม",
                "ตราช\u{e31}\u{e48}ง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}พ\u{e34}พากษาชาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek kazy"),
            keywords: &["adalat", "erkek", "erkek kazy", "terezi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakamaau tangata"),
            keywords: &["fakamaau tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek hakim"),
            keywords: &["adalet", "adam", "erkek", "erkek hakim", "terazi", "yargıç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر سوتچى"),
            keywords: &["ئۆلچەم", "ئەر", "ئەر سوتچى", "سوت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суддя-чоловік"),
            keywords: &["правосуддя", "суддя", "суддя-чоловік", "терези", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد جج"),
            keywords: &["انصاف", "عدالت", "مرد", "مرد جج", "کورٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak sudya"),
            keywords: &["adliya", "erkak", "erkak sudya", "kishi", "tarozi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thẩm phán nam"),
            keywords: &["công lý", "cầm cân nảy mực", "nam", "thẩm phán nam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àttekat góor"),
            keywords: &["balaas", "góor", "justis", "àttekat góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umgwebi oyindoda"),
            keywords: &["indoda", "izikali", "ubulungisa", "umgwebi oyindoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin adájọ\u{301}"),
            keywords: &["òdodo onídajọ", "ọkùnrin adájọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男法官"),
            keywords: &["正義", "男", "男法官", "秤"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男法官"),
            keywords: &["正义", "男", "男法官", "秤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男法官"),
            keywords: &["正义", "法官", "法律", "男", "男法官"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男法官"),
            keywords: &["法官", "男", "男法官"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijaji lesilisa"),
            keywords: &["ijaji lesilisa", "indoda", "owesilisa", "ubulungiswa"],
        },
    ],
};
#[doc = "👨🏻\u{200d}⚖\u{fe0f}"]
pub const MAN_JUDGE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}⚖\u{fe0f}",
    codepoint: "1F468 1F3FB 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man judge: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏻\u{200d}⚖",
        codepoint: "1F468 1F3FB 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man judge: light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}⚖\u{fe0f}"]
pub const MAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}⚖\u{fe0f}",
    codepoint: "1F468 1F3FC 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man judge: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏼\u{200d}⚖",
        codepoint: "1F468 1F3FC 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man judge: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}⚖\u{fe0f}"]
pub const MAN_JUDGE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}⚖\u{fe0f}",
    codepoint: "1F468 1F3FD 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man judge: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏽\u{200d}⚖",
        codepoint: "1F468 1F3FD 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man judge: medium skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}⚖\u{fe0f}"]
pub const MAN_JUDGE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}⚖\u{fe0f}",
    codepoint: "1F468 1F3FE 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man judge: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏾\u{200d}⚖",
        codepoint: "1F468 1F3FE 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man judge: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}⚖\u{fe0f}"]
pub const MAN_JUDGE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}⚖\u{fe0f}",
    codepoint: "1F468 1F3FF 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man judge: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👨🏿\u{200d}⚖",
        codepoint: "1F468 1F3FF 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man judge: dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩\u{200d}⚖\u{fe0f}"]
pub const WOMAN_JUDGE: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}⚖\u{fe0f}",
    codepoint: "1F469 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman judge",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩\u{200d}⚖",
        codepoint: "1F469 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman judge",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike regter"),
            keywords: &["hof", "landdros", "magistraat", "regter", "vroulike regter"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ዳኛ"),
            keywords: &["ሚዛን", "ሴት", "እንስት", "ዳኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قاضية"),
            keywords: &["عدالة", "عدل", "قاضية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} ন\u{9cd}য\u{9be}য\u{9bc}\u{9be}ধীশ"),
            keywords: &[
                "ন\u{9cd}য\u{9be}য\u{9bc}\u{9be}ধীশ",
                "মহিল\u{9be}",
                "স\u{9cd}কেলসম\u{9c2}হ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın hakim"),
            keywords: &["hakim", "qadın", "tərəzi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("суддзя-жанчына"),
            keywords: &["жанчына", "суддзя", "суддзя-жанчына", "шалі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("съдийка"),
            keywords: &[
                "везни",
                "правосъдие",
                "служителка на правосъдието",
                "съдийка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} বিচ\u{9be}রক"),
            keywords: &[
                "দ\u{9be}\u{981}ড\u{9bc}িপ\u{9be}ল\u{9cd}ল\u{9be}",
                "বিচ\u{9be}র",
                "মহিল\u{9be}",
                "মহিল\u{9be} বিচ\u{9be}রক",
                "মেয\u{9bc}ে",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("barnerez"),
            keywords: &["barnerez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena sudija"),
            keywords: &["sudija", "vaga", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("jutgessa"),
            keywords: &["balança", "dona", "femení", "justícia", "jutgessa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᎫᎪᏗᏍᎩ"),
            keywords: &["ᎠᎨᏯ", "ᏗᎦᏛᏗ", "ᏗᎫᎪᏗᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("soudkyně"),
            keywords: &["právo", "soudkyně", "spravedlnost", "váhy", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("barnwres"),
            keywords: &["barnwres", "benywaidd", "clorian", "cyfiawnder", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig dommer"),
            keywords: &["jura", "kvinde", "kvindelig dommer", "lov", "retfærdighed"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Richterin"),
            keywords: &["Gerechtigkeit", "Recht", "Richterin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα δικαστής"),
            keywords: &["γυναίκα", "δικαστήριο", "δικαστής", "νομική"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman judge"),
            keywords: &["judge", "justice", "scales", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("fiscal mujer"),
            keywords: &["fiscal mujer", "jueza", "justicia", "magistrada", "mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("juez mujer"),
            keywords: &[
                "fiscal mujer",
                "juez mujer",
                "jueza",
                "justicia",
                "magistrada",
                "mujer",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naiskohtunik"),
            keywords: &["kohus", "naine", "naiskohtunik", "õigusemõistmine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume epailea"),
            keywords: &[
                "balantzak",
                "emakume",
                "emakume epailea",
                "emakumezko",
                "epaiketa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قاضی زن"),
            keywords: &[
                "خانم قاضی",
                "خانم وکیل",
                "دادرس",
                "دادگاه",
                "قاضی زن",
                "وکیل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naistuomari"),
            keywords: &["laki", "nainen", "naistuomari", "oikeus", "tuomari"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng hukom"),
            keywords: &["babae", "babaeng hukom", "hukom", "hustisya", "huwes"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur dómari"),
            keywords: &["dómari", "kona", "kvinna", "kvinnuligur dómari", "rættvísi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("juge femme"),
            keywords: &["balance", "femme", "juge"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("breitheamh baineann"),
            keywords: &["bean", "breitheamh", "breitheamh baineann", "meá"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("britheamh boireann"),
            keywords: &[
                "boireannach",
                "britheamh",
                "britheamh boireann",
                "meidh",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xuíza"),
            keywords: &["balanza", "muller", "xustiza", "xuíza"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ન\u{acd}યાયાધીશ"),
            keywords: &[
                "તરાજ\u{ac1}",
                "ન\u{acd}યાય",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી ન\u{acd}યાયાધીશ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace joji"),
            keywords: &["joji", "mace", "sikeloli"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שופטת"),
            keywords: &["אישה", "מאזניים", "משפט", "צדק", "שופטת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला न\u{94d}यायाधीश"),
            keywords: &["तराज\u{942}", "न\u{94d}यायाधीश", "महिला"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sutkinja"),
            keywords: &["pravda", "sutkinja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("bírónő"),
            keywords: &["bírónő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին դատավոր"),
            keywords: &["դատավոր", "կին", "օրենք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hakim wanita"),
            keywords: &["hakim wanita", "hukum", "pengadilan", "perempuan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị ikpe nkwụọtọ"),
            keywords: &["ikpe nkwụọtọ", "nsialọ", "nwanyị", "nwanyị ikpe nkwụọtọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns dómari"),
            keywords: &["dómari", "dómur", "kona", "kvenkyns dómari", "réttur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("giudice donna"),
            keywords: &["bilancia", "donna", "giudice", "giustizia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性の裁判官"),
            keywords: &["女", "女性", "女性の裁判官", "裁判", "裁判官"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("hakim wadon"),
            keywords: &["hakim wadon", "pradata", "timbangan", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოსამართლე ქალი"),
            keywords: &["მოსამართლე", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сот әйел"),
            keywords: &["сот", "әділет", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig dommer"),
            keywords: &["jura", "kvinde", "kvindelig dommer", "lov", "retfærdighed"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចៅក\u{17d2}រ\u{17bb}មស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ចៅក\u{17d2}រម",
                "ចៅក\u{17d2}រ\u{17bb}មស\u{17d2}រ\u{17b8}",
                "ត\u{17bb}លាការ",
                "នារ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳಾ ನ\u{ccd}ಯಾಯಾಧೀಶರು"),
            keywords: &[
                "ನ\u{ccd}ಯಾಯಾಧೀಶರು",
                "ಮಹ\u{cbf}ಳಾ ನ\u{ccd}ಯಾಯಾಧೀಶರು",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮಾಪಕಗಳು",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 판사"),
            keywords: &["법조인", "여자", "정의", "판사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल न\u{94d}यायाधीश"),
            keywords: &["तागडी", "न\u{94d}यायाधीश", "बायल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял сот"),
            keywords: &["аял", "сот", "тараза"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Riichterin"),
            keywords: &["Fra", "Riichterin", "Wo"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ພ\u{eb4}ພາກສາຍ\u{eb4}ງ"),
            keywords: &[
                "ຍ\u{eb4}ງ",
                "ຍ\u{eb8}ດຕ\u{eb4}ທຳ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ພ\u{eb4}ພາກສາຍ\u{eb4}ງ",
                "ແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("teisėja"),
            keywords: &["moteris", "svarstyklės", "teisingumas", "teisėja"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("tiesnese"),
            keywords: &["likums", "sieviete", "svari", "tiesnese"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaiwhakawā wahine"),
            keywords: &["kaiwhakawā", "wahine", "whārite"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("судијка"),
            keywords: &["жена", "судијка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വനിത\u{d3e} ജഡ\u{d4d}ജി"),
            keywords: &[
                "കോടതി",
                "നീതി",
                "വനിത\u{d3e} ജഡ\u{d4d}ജി",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй шүүгч"),
            keywords: &["дэнс", "шүүгч", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला न\u{94d}यायाधीश"),
            keywords: &["तराज\u{942}", "न\u{94d}यायाधीश", "महिला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hakim wanita"),
            keywords: &["hakim", "neraca", "perempuan", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imħallef mara"),
            keywords: &["imħallef", "mara", "miżien"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း တရားသ\u{1030}ကြ\u{102e}း"),
            keywords: &[
                "ချ\u{102d}န\u{103a}ခ\u{103d}င\u{103a}",
                "တရားသ\u{1030}ကြ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig dommer"),
            keywords: &[
                "dommer",
                "jus",
                "juss",
                "kvinne",
                "kvinnelig dommer",
                "rettssak",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला न\u{94d}यायधिश"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "न\u{94d}यायधिश",
                "महिला",
                "स\u{94d}क\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke rechter"),
            keywords: &["rechter", "vrouw", "vrouwelijke rechter"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg dommar"),
            keywords: &[
                "dommar",
                "jus",
                "juss",
                "kvinne",
                "kvinneleg dommar",
                "rettssak",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ବ\u{b3f}ଚ\u{b3e}ରପତ\u{b3f}"),
            keywords: &[
                "ବ\u{b3f}ଚ\u{b3e}ରପତ\u{b3f}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ସ\u{b4d}କେଲ\u{b4d}\u{200c}ଗ\u{b41}ଡ\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a71}ਜ ਸਾਹਿਬਾ"),
            keywords: &["ਇਸਤਰੀ", "ਔਰਤ", "ਜ\u{a71}ਜ ਸਾਹਿਬਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جج زنانی"),
            keywords: &["تکڑی", "جج", "زنانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Jọj"),
            keywords: &[
                "Jọj",
                "Skel Wé Dẹm De Ték Mẹ\u{301}zhọ\u{301} Sọ\u{301}mtin",
                "Wúman",
                "Wúmán Jọj",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta sędzia"),
            keywords: &["kobieta", "kobieta sędzia", "sędzina"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه قاضي"),
            keywords: &["تلې", "قاضي", "ښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("juíza"),
            keywords: &["balança", "justiça", "juíza", "mulher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["balança", "justiça", "juíza", "mulher"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi jueza"),
            keywords: &["aysana", "jueza", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("judecătoare"),
            keywords: &["balanță", "judecătoare", "justiție"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1175"),
            keywords: &["E10-1175"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-судья"),
            keywords: &["женщина", "женщина-судья", "закон", "суд", "судья"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore w’umucamanza"),
            keywords: &["ubutabera", "umugore", "umugore w’umucamanza", "umunzani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جج"),
            keywords: &["جج، عورت، ترازو", "عورت جج"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}න\u{dd2}ස\u{dd4}ර\u{dd4}වර\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ත\u{dd4}ල\u{dcf}",
                "ව\u{dd2}න\u{dd2}ස\u{dd4}ර\u{dd4}වර\u{dd2}ය",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("sudkyňa"),
            keywords: &["právo", "sudkyňa", "zákon", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sodnica"),
            keywords: &["dekle", "pravica", "sodnica", "tehtnica", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag garsoore ah"),
            keywords: &["garsoore", "miisaanka", "naag", "naag garsoore ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjykatëse"),
            keywords: &["drejtësi", "gjykatëse", "grua", "peshore"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена судија"),
            keywords: &["жена", "правда", "судија"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena sudija"),
            keywords: &["pravda", "sudija", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig domare"),
            keywords: &["advokat", "jurist", "kvinna", "kvinnlig", "kvinnlig domare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jaji wa kike"),
            keywords: &["haki", "hakimu", "jaji", "jaji wa kike"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} ந\u{bc0}திபதி"),
            keywords: &["சட\u{bcd}டம\u{bcd}", "ந\u{bc0}திபதி", "பெண\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడ న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}"),
            keywords: &[
                "ఆడ న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}",
                "న\u{c4d}య\u{c3e}యమూర\u{c4d}త\u{c3f}",
                "మహ\u{c3f}ళ",
                "స\u{c4d}క\u{c47}ల\u{c4d}స\u{c4d}",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани судя"),
            keywords: &["зан", "зани судя", "судя", "тарозу"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}พ\u{e34}พากษาหญ\u{e34}ง"),
            keywords: &[
                "การต\u{e31}ดส\u{e34}น",
                "ตราช\u{e31}\u{e48}ง",
                "ผ\u{e39}\u{e49}พ\u{e34}พากษาหญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan kazy"),
            keywords: &["adalat", "terezi", "zenan", "zenan kazy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fakamaau fefine"),
            keywords: &["fakamaau fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın hakim"),
            keywords: &["adalet", "bayan", "kadın", "kadın hakim", "terazi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال سوتچى"),
            keywords: &["ئايال", "ئايال سوتچى", "ئۆلچەم", "سوت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-суддя"),
            keywords: &["жінка", "жінка-суддя", "суддя", "терези правосуддя"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت جج"),
            keywords: &["انصاف", "عدالت", "عورت", "عورت جج", "کورٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol sudya"),
            keywords: &["ayol", "sudya", "tarozi", "xotin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thẩm phán nữ"),
            keywords: &["cầm cân nảy mực", "nữ", "thẩm phán", "thẩm phán nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("àttekat bu jigéen"),
            keywords: &["jigéen", "scales", "àttekat", "àttekat bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umgwebi olibhinqa"),
            keywords: &["ibhinqa", "izikali", "umgwebi", "umgwebi olibhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin adájọ\u{301}"),
            keywords: &["adájọ\u{301}", "obìnrin adájọ\u{301}", "obìrin síkélì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女法官"),
            keywords: &["女", "女法官", "正義", "秤"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女法官"),
            keywords: &["女", "女法官", "正义", "秤"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女法官"),
            keywords: &["女", "女法官", "正义", "法官", "法律"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女法官"),
            keywords: &["女", "女法官", "法官"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijaji lesifazane"),
            keywords: &["ijaji", "ijaji lesifazane", "owesmame"],
        },
    ],
};
#[doc = "👩🏻\u{200d}⚖\u{fe0f}"]
pub const WOMAN_JUDGE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}⚖\u{fe0f}",
    codepoint: "1F469 1F3FB 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman judge: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏻\u{200d}⚖",
        codepoint: "1F469 1F3FB 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman judge: light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}⚖\u{fe0f}"]
pub const WOMAN_JUDGE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}⚖\u{fe0f}",
    codepoint: "1F469 1F3FC 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman judge: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏼\u{200d}⚖",
        codepoint: "1F469 1F3FC 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman judge: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}⚖\u{fe0f}"]
pub const WOMAN_JUDGE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}⚖\u{fe0f}",
    codepoint: "1F469 1F3FD 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman judge: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏽\u{200d}⚖",
        codepoint: "1F469 1F3FD 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman judge: medium skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}⚖\u{fe0f}"]
pub const WOMAN_JUDGE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}⚖\u{fe0f}",
    codepoint: "1F469 1F3FE 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman judge: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏾\u{200d}⚖",
        codepoint: "1F469 1F3FE 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman judge: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}⚖\u{fe0f}"]
pub const WOMAN_JUDGE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}⚖\u{fe0f}",
    codepoint: "1F469 1F3FF 200D 2696 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman judge: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👩🏿\u{200d}⚖",
        codepoint: "1F469 1F3FF 200D 2696",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman judge: dark skin tone",
        group: "People & Body",
        subgroup: "person-role",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧑\u{200d}🌾"]
pub const FARMER: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🌾",
    codepoint: "1F9D1 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "farmer",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("boer"),
            keywords: &["boer", "tuinier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ገበሬ"),
            keywords: &["ገበሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("م\u{64f}زارع"),
            keywords: &["عامل زراعي", "فلاح", "مزارع", "منسق حدائق", "م\u{64f}زارع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("খেতিয\u{9bc}ক"),
            keywords: &["খেতিয\u{9bc}ক", "পশ\u{9c1}প\u{9be}লক", "ম\u{9be}লী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fermer"),
            keywords: &["bağban", "fermer", "rençer"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("аграрый"),
            keywords: &["агароднік", "аграрый", "фермер"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("земеделец"),
            keywords: &["градинар", "земеделец", "собственик на ранчо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9c3}ষক"),
            keywords: &[
                "ক\u{9c3}ষক",
                "খ\u{9be}ম\u{9be}রের ম\u{9be}লিক",
                "ম\u{9be}লী",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("farmer"),
            keywords: &["farmer", "poljoprivrednik", "vrtlar"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pagès"),
            keywords: &["agricultor", "granger", "pagès"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᎶᎩᏍᎩ"),
            keywords: &["ᎠᏫᏒᏍᎩ", "ᎤᎾᏝᎾᎢ", "ᏗᎦᎶᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("farmář/farmářka"),
            keywords: &[
                "farmář",
                "farmář/farmářka",
                "farmářka",
                "sedlák",
                "selka",
                "zahradnice",
                "zahradník",
                "zemědělec",
                "zemědělkyně",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n ffermio"),
            keywords: &["ffarmwr", "garddwr", "person sy’n ffermio", "ranshwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bonde"),
            keywords: &["bonde", "bondemand", "gartner", "gårdejer", "landmand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bauer/Bäuerin"),
            keywords: &["Bauer", "Bauer/Bäuerin", "Farmer", "Gärtner", "Landwirt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καλλιεργητής"),
            keywords: &[
                "αγρότης",
                "γεωργός",
                "ιδιοκτήτης φάρμας",
                "καλλιεργητής",
                "κηπουρός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("farmer"),
            keywords: &["farmer", "gardener", "rancher"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la agricultura"),
            keywords: &[
                "agricultor",
                "cultivador",
                "granjero",
                "jardinero",
                "labrador",
                "profesional de la agricultura",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("granjero"),
            keywords: &["granjero"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["cultivo", "granja", "profesional de la agricultura"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("talunik"),
            keywords: &["aednik", "farmer", "talunik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("nekazaria"),
            keywords: &["baserritar", "lorezain", "nekazari", "nekazaria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کشاورز"),
            keywords: &["باغبان", "مزرعه\u{200c}دار", "کشاورز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("maanviljelijä"),
            keywords: &["farmari", "maanviljelijä", "puutarhuri"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magsasaka"),
            keywords: &["hardinero", "magsasaka", "rantsero"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bóndi"),
            keywords: &["bóndi", "urtagarðsmaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fermier (tous genres)"),
            keywords: &[
                "fermier",
                "fermier (tous genres)",
                "fermière",
                "jardinier",
                "jardinière",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("fermier"),
            keywords: &["agriculteur", "fermier", "jardinier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("feirmeoir"),
            keywords: &["feirmeoir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tuathanach"),
            keywords: &[
                "croitear",
                "cruitear",
                "gàirnealair",
                "rainsear",
                "tuathanach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa dedicada á agricultura"),
            keywords: &[
                "agricultor",
                "cultivo",
                "gando",
                "granxeiro",
                "persoa dedicada á agricultura",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac3}ષિકાર"),
            keywords: &["ક\u{ac3}ષિકાર", "માળી", "રા\u{a82}ચર"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חקלאי/ת"),
            keywords: &["חווה", "חקלאות", "חקלאי", "חקלאי/ת", "חקלאית", "טבע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{943}षक"),
            keywords: &["किसान", "क\u{943}षक", "पश\u{941}पालक", "माली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("farmer"),
            keywords: &["farmer", "poljoprivrednik", "vrtlar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gazda / női gazda"),
            keywords: &["földműves", "gazda", "gazda / női gazda", "növénytermesztő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ֆերմեր"),
            keywords: &["ագարակատեր", "այգեպան", "ֆերմեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("petani"),
            keywords: &["pekebun", "petani", "peternak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bóndi"),
            keywords: &["bóndi", "garðyrkjumaður", "stórbóndi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("agricoltore"),
            keywords: &["agricoltore", "allevatore", "contadino", "giardiniere"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("農家"),
            keywords: &["ガーデナー", "農場主", "農家", "農業"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tani"),
            keywords: &["juragan tani", "tani", "tukang kebon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფერმერი"),
            keywords: &["მებაღე", "მიწათმოქმედი", "ფერმა", "ფერმერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фермер"),
            keywords: &["бағбан", "бақташы", "фермер"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កស\u{17b7}ករ"),
            keywords: &[
                "កស\u{17b7}ករ",
                "ម\u{17d2}ចាស\u{17cb}កស\u{17b7}ដ\u{17d2}ឋាន",
                "អ\u{17d2}នកថែស\u{17bd}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೃಷ\u{cbf}ಕ"),
            keywords: &["ಕೃಷ\u{cbf}ಕ", "ತೋಟಗಾರ", "ರಾಂಚರ\u{ccd}", "ರೈತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("농부"),
            keywords: &["농부", "농사꾼", "농장 주인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{947}तकार"),
            keywords: &["भाटकार", "माळी", "श\u{947}तकार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фермер"),
            keywords: &["фермер"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊາວນາ"),
            keywords: &["ຊາວນາ", "ຊາວສວນ", "ເຈ\u{ebb}\u{ec9}າຂອງສວນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ūkininkaujantis žmogus"),
            keywords: &["sodininkas", "ūkininkas", "ūkininkaujantis žmogus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fermeris"),
            keywords: &["dārznieks", "fermeris", "lauksaimnieks", "zemnieks"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("фармер"),
            keywords: &["градинар", "земјоделец", "фармер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കർഷകൻ"),
            keywords: &["കർഷകൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("фермер"),
            keywords: &["фермер", "цэцэрлэгч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{947}ती करणारा"),
            keywords: &[
                "माळी",
                "श\u{947}तकरी",
                "श\u{947}ता\u{902}वर प\u{94d}राण\u{94d}या\u{902}च\u{947} स\u{902}गोपन करणारा",
                "श\u{947}ती करणारा",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("petani"),
            keywords: &["pekebun", "peladang ternak", "petani"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လယ\u{103a}လ\u{102f}ပ\u{103a}သ\u{1030}"),
            keywords: &[
                "တောင\u{103a}သ\u{1030}လယ\u{103a}သမား",
                "လယ\u{103a}လ\u{102f}ပ\u{103a}သ\u{1030}",
                "ဥယျာဉ\u{103a}မ\u{103e}\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gårdbruker"),
            keywords: &["bonde", "gårdbruker", "jordbruk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किसान"),
            keywords: &["किसान", "गार\u{94d}डनर", "रान\u{94d}चर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boer"),
            keywords: &["boer", "tuinder", "veehouder"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gardbrukar"),
            keywords: &["bonde", "gardbrukar", "jordbruk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b43}ଷକ"),
            keywords: &["କ\u{b43}ଷକ", "ପଶ\u{b41}ପ\u{b3e}ଳକ", "ମ\u{b3e}ଳୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਿਸਾਨ"),
            keywords: &["ਕਿਸਾਨ", "ਖ\u{a47}ਤੀਬਾੜੀ ਕਰਨ ਵਾਲਾ", "ਮਾਲੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáma"),
            keywords: &[
                "Fáma",
                "Gádína",
                "Pẹ\u{301}sin Wé Gẹ\u{301}t Bíg Fam Wiá Dẹm De Lúk Áftá Hóm Ánímọl",
                "Óná Ọf Bíg Fam Fọ Hóm Ánímọl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rolnik"),
            keywords: &["farmer", "ogrodnik", "rolnik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بزګر"),
            keywords: &["بزګر", "مالي", "پادوان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("agricultor"),
            keywords: &["agricultor", "jardineiro", "rancheiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("lavrador"),
            keywords: &["agricultor", "jardineiro", "lavrador", "rancheiro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("granjero"),
            keywords: &["granjero", "jardinero", "ranchero"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fermier sau fermieră"),
            keywords: &[
                "crescător de vite",
                "fermier",
                "fermier sau fermieră",
                "grădinar",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-011"),
            keywords: &["E13-011"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фермер"),
            keywords: &["дачник", "садовник", "скотовод", "фермер"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هاري"),
            keywords: &["باغائي", "رينچر", "هاري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගොව\u{dd2}ය\u{dcf}"),
            keywords: &[
                "උයන\u{dca}පල\u{dca}ල\u{dcf}",
                "ගොව\u{dd2}ය\u{dcf}",
                "වත\u{dd4}ක\u{dcf}රය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("roľník"),
            keywords: &["farmár", "poľnohospodár", "roľník", "sedliak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kmet"),
            keywords: &["kmet", "vrtnar", "živinorejec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Beeraley"),
            keywords: &["Beeraley", "beeraley. beer ilaaliye, waardiye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person bujk"),
            keywords: &["bujk", "fermer", "kopshtar", "person bujk"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пољопривредник"),
            keywords: &["баштован", "пољопривредник"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("poljoprivrednik"),
            keywords: &["baštovan", "poljoprivrednik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bonde"),
            keywords: &["bonde", "jordbrukare", "lantbrukare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkulima"),
            keywords: &["mkulima", "mkulima wa mifugo", "mkulima wa mimea"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விவச\u{bbe}யி"),
            keywords: &[
                "தோட\u{bcd}டக\u{bcd}க\u{bbe}ரர\u{bcd}",
                "பண\u{bcd}ணையில\u{bcd} பணி செய\u{bcd}பவர\u{bcd}",
                "விவச\u{bbe}யி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c48}తు"),
            keywords: &[
                "త\u{c4b}టమ\u{c3e}ల\u{c3f}",
                "ప\u{c46}ంపకంద\u{c3e}రు",
                "ర\u{c48}తు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชาวนา"),
            keywords: &["ชาวนา", "ชาวสวน", "เจ\u{e49}าของฟาร\u{e4c}ม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("fermer"),
            keywords: &["bagban", "fermer", "rançoçy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ngoue"),
            keywords: &["tokotaha ngoue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çiftçi"),
            keywords: &["bahçıvan", "rençper", "çiftçi"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("селянин"),
            keywords: &["землероб", "садівник", "селянин", "скотар"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کسان"),
            keywords: &["مالی", "کاشتکار", "کسان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("fermer"),
            keywords: &["bogʻbon", "dehqon", "fermer"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nông dân"),
            keywords: &["chủ trang trại", "người làm vườn", "nông dân"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("農夫"),
            keywords: &["園丁", "牧場工人", "農夫"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("农夫"),
            keywords: &["农夫", "园丁", "牧场工人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("农民"),
            keywords: &["农民", "园丁"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("農民"),
            keywords: &["園丁", "農人", "農夫", "農民"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umlimi"),
            keywords: &["osika izihlahla", "umlimi", "uwasengadini"],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🌾"]
pub const FARMER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🌾",
    codepoint: "1F9D1 1F3FB 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "farmer: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🌾"]
pub const FARMER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🌾",
    codepoint: "1F9D1 1F3FC 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "farmer: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🌾"]
pub const FARMER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🌾",
    codepoint: "1F9D1 1F3FD 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "farmer: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🌾"]
pub const FARMER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🌾",
    codepoint: "1F9D1 1F3FE 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "farmer: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🌾"]
pub const FARMER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🌾",
    codepoint: "1F9D1 1F3FF 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "farmer: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🌾"]
pub const MAN_FARMER: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🌾",
    codepoint: "1F468 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man farmer",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike boer"),
            keywords: &["boer", "koringaar", "manlike boer", "plaas"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ገበሬ"),
            keywords: &["ሰው", "ተክል", "ወንድ", "ገበሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مزارع"),
            keywords: &["عامل زراعي", "فلاح", "مزارع", "منسق حدائق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ খেতিয\u{9bc}ক"),
            keywords: &[
                "খেতিয\u{9bc}ক",
                "পশ\u{9c1}প\u{9be}লক",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ম\u{9be}লী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi fermer"),
            keywords: &["bağban", "fermer", "kişi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фермер"),
            keywords: &["агароднік", "мужчына", "фермер"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фермер"),
            keywords: &[
                "градинар",
                "производител",
                "селскостопански работник",
                "фермер",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলে,প\u{9c1}র\u{9c1}ষ, চ\u{9be}ষী ,ক\u{9c3}ষক"),
            keywords: &[
                "ক\u{9c3}ষক",
                "চ\u{9be}ষী",
                "ছেলে",
                "ছেলে,প\u{9c1}র\u{9c1}ষ, চ\u{9be}ষী ,ক\u{9c3}ষক",
                "প\u{9c1}র\u{9c1}ষ",
                "ম\u{9be}লি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("labourer-douar"),
            keywords: &["labourer-douar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("poljoprivrednik"),
            keywords: &["farmer", "muškarac", "poljoprivrednik", "rančer"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home pagès"),
            keywords: &["agricultor", "granger", "home", "masculí", "pagès"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄦𑄣\u{11134}𑄌\u{1112a}𑄠𑄬"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄦𑄣\u{11134}𑄌\u{1112a}𑄠𑄬"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏗᎦᎶᎩᏍᎩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏫᏒᏍᎩ", "ᎤᎾᏝᎾᎢ", "ᏗᎦᎶᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("farmář"),
            keywords: &["farmář", "muž", "sedlák", "zahradník", "zemědělec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffermwr"),
            keywords: &["dyn", "ffermwr", "garddwr", "gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("landmand"),
            keywords: &["bonde", "bondemand", "gartner", "landmand", "mand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bauer"),
            keywords: &["Bauer", "Landwirt", "Ähre"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγρότης"),
            keywords: &["άντρας", "αγρότης", "κήπος", "καλλιέργεια", "κηπουρός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man farmer"),
            keywords: &["farmer", "gardener", "man", "rancher"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["farmer", "gardener", "man"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la agricultura hombre"),
            keywords: &[
                "agricultor",
                "campo",
                "granjero",
                "hombre",
                "labrador",
                "profesional de la agricultura hombre",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("granjero hombre"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesfarmer"),
            keywords: &["aednik", "farmer", "mees", "meesfarmer", "põllumees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon nekazaria"),
            keywords: &[
                "baserritar",
                "gizon",
                "gizon nekazaria",
                "gizonezko",
                "lorezain",
                "nekazari",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کشاورز مرد"),
            keywords: &["برزگر", "خوشه برنج", "دهقان", "زارع", "کشاورز مرد", "کشت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesmaanviljelijä"),
            keywords: &[
                "maanviljelijä",
                "mies",
                "miesmaanviljelijä",
                "puutarhuri",
                "sato",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking magsasaka"),
            keywords: &[
                "hardinero",
                "lalaki",
                "lalaking magsasaka",
                "magsasaka",
                "rantsero",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur bóndi"),
            keywords: &["bóndi", "mannligur bóndi", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fermier"),
            keywords: &["agriculteur", "fermier", "homme", "jardinier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("fermier homme"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("feirmeoir fireann"),
            keywords: &[
                "fear",
                "feirmeoir",
                "feirmeoir fireann",
                "garraíodóir",
                "rainseoir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tuathanaiche fireann"),
            keywords: &[
                "croitear",
                "duine",
                "fear",
                "fireannach",
                "gàirnealair",
                "rainsear",
                "tuathanaiche",
                "tuathanaiche fireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("agricultor"),
            keywords: &["agricultor", "cultivo", "gando", "granxeiro", "home"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac7}ડ\u{ac2}ત"),
            keywords: &[
                "ખ\u{ac7}ડ\u{ac2}ત",
                "પ\u{ac1}ર\u{ac1}ષ",
                "માળી",
                "ર\u{ac7}ન\u{acd}ચર",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum manomi"),
            keywords: &["gadina", "mai kiwon shanu", "manomi", "mutum"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חקלאי"),
            keywords: &["איש", "גנן", "חוואי", "חקלאי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("किसान"),
            keywords: &[
                "आदमी",
                "किसान",
                "ख\u{947}त लगान\u{947}वाला",
                "प\u{941}र\u{941}ष",
                "माली",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("poljoprivrednik"),
            keywords: &["farmer", "poljoprivrednik", "seljak", "vrtlar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gazda"),
            keywords: &["férfi", "földműves", "gazda", "kertész"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ ֆերմեր"),
            keywords: &[
                "ագարակատեր",
                "այգեգործ",
                "գյուղացի",
                "տղամարդ ֆերմեր",
                "ֆերմեր",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("petani pria"),
            keywords: &["laki-laki", "padi", "petani pria", "sawah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke ọrụ ugbo"),
            keywords: &[
                "nwoke",
                "nwoke ọrụ ugbo",
                "onye ọchị nnama",
                "ọrụ ugbo",
                "ọsụ ahịhịa",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns bóndi"),
            keywords: &["bóndi", "garðyrkjumaður", "karl", "karlkyns bóndi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("contadino"),
            keywords: &["allevatore", "contadino", "fattoria", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("農家の男性"),
            keywords: &["男", "男性", "農夫", "農家", "農家の男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pak tani"),
            keywords: &["juragan tani", "lanang", "pak tani", "tani", "tukang kebon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფერმერი კაცი"),
            keywords: &["კაცი", "მებაღე", "ფერმერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер фермер"),
            keywords: &["бағбан", "ер", "фермер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("landmand"),
            keywords: &["bonde", "bondemand", "gartner", "landmand", "mand"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កស\u{17b7}ករប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "កស\u{17b7}ករ",
                "កស\u{17b7}ករប\u{17d2}រ\u{17bb}ស",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "អ\u{17d2}នកចម\u{17d2}ការ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಕೃಷ\u{cbf}ಕ"),
            keywords: &["ಕುರ\u{cbf}ಗಾರ", "ಕೃಷ\u{cbf}ಕ", "ತೋಟಗಾರ", "ಪುರುಷ", "ರೈತ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 농부"),
            keywords: &["남자", "농부", "농사꾼", "농장 주인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो श\u{947}तकार"),
            keywords: &["दादलो", "भाटकार", "माळी", "श\u{947}तकार"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек фермер"),
            keywords: &["багбан", "малчы", "фермер", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bauer"),
            keywords: &["Bauer", "Gäertner", "Mann", "Véiziichter"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊາວນາຊາຍ"),
            keywords: &[
                "ກະສ\u{eb4}ກອນ",
                "ຄ\u{ebb}ນສວນ",
                "ຊາວນາ",
                "ຊາວນາຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ເຮ\u{eb1}ດນາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ūkininkas"),
            keywords: &["darbininkas", "sodininkas", "vyras", "ūkininkas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lauksaimnieks"),
            keywords: &["dārzenieks", "lauksaimnieks", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaipāmu tāne"),
            keywords: &["kaimahi oneone", "kaipāmu", "kairāti", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("земјоделец"),
            keywords: &["градинар", "земјоделец", "маж"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d43}ഷിക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "ക\u{d43}ഷിക\u{d4d}ക\u{d3e}രൻ",
                "കർഷകൻ",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй тариачин"),
            keywords: &["ногооч эр", "тариачин", "фермер", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{947}तकरी"),
            keywords: &["प\u{941}र\u{942}ष", "माळी", "लागवड करणारा", "श\u{947}तकरी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("petani lelaki"),
            keywords: &["lelaki", "pekebun", "peladang ternak", "petani"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bidwi maskil"),
            keywords: &["bidwi", "bidwi maskil", "raġel", "raħħal", "ġardinar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လယ\u{103a}သမား"),
            keywords: &[
                "ကောက\u{103a}စ\u{102d}\u{102f}က\u{103a}သ\u{1030}",
                "ပန\u{103a}းပျ\u{102d}\u{102f}းသ\u{1030}",
                "လယ\u{103a}သမား",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig gårdbruker"),
            keywords: &[
                "bonde",
                "dyrke",
                "gårdbruker",
                "jordbruk",
                "mann",
                "mannlig gårdbruker",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष क\u{943}षक"),
            keywords: &[
                "क\u{943}षक",
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "माली",
                "र\u{94d}यान\u{94d}चर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke boer"),
            keywords: &["boer", "man", "mannelijke boer", "tuinder", "veehouder"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg gardbrukar"),
            keywords: &[
                "bonde",
                "dyrke",
                "gardbrukar",
                "jordbruk",
                "mann",
                "mannleg gardbrukar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ କ\u{b43}ଷକ"),
            keywords: &[
                "କ\u{b43}ଷକ",
                "ପଶ\u{b41}ପ\u{b3e}ଳକ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ମ\u{b3e}ଳୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਕਿਸਾਨ"),
            keywords: &["ਕਿਸਾਨ", "ਪ\u{a41}ਰਸ\u{a3c}", "ਬ\u{a70}ਦਾ", "ਮਾਲੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد کسان"),
            keywords: &["بندہ", "مالی", "مرد کسان", "مویشی پالن الا", "کسان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Fáma"),
            keywords: &[
                "Fáma",
                "Gádína",
                "Man",
                "Mán Fáma",
                "Pẹ\u{301}sin Wé Gẹ\u{301}t Bíg Fam Wiá Dẹm De Lúk Áftá Hóm Ánímọl",
                "Óná Ọf Bíg Fam Fọ Hóm Ánímọl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna rolnik"),
            keywords: &["farmer", "mężczyzna", "ogrodnik", "rolnik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی بزګر"),
            keywords: &["بزګر، مالي، سړی، رينچر", "سړی بزګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fazendeiro"),
            keywords: &["agricultor", "fazendeiro", "homem", "jardineiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("agricultor"),
            keywords: &[
                "agricultor",
                "fazendeiro",
                "homem",
                "jardineiro",
                "lavrador",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata granjero"),
            keywords: &["granjero", "jardinero", "ranchero", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fermier"),
            keywords: &["agricultor", "fermier", "grădinar", "țăran"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1161"),
            keywords: &["E10-1161"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-фермер"),
            keywords: &["дачник", "мужчина", "мужчина-фермер", "садовник", "фермер"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’umworozi"),
            keywords: &[
                "umugabo",
                "umugabo w’umworozi",
                "umunyabusitani",
                "umutunzi",
                "umworozi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد هاري"),
            keywords: &["مرد هاري", "مرد، هاري، مالڪ، مالي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ගොව\u{dd2}ය\u{dcf}"),
            keywords: &[
                "උයන\u{dca}පල\u{dca}ල\u{dcf}",
                "ගොව\u{dd2}පළ හ\u{dd2}ම\u{dd2}කර\u{dd4}",
                "ගොව\u{dd2}ය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ගොව\u{dd2}ය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("roľník muž"),
            keywords: &["farmár", "muž", "poľnohospodár", "roľník", "sedliak"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kmetovalec"),
            keywords: &[
                "fant",
                "kavboj",
                "kmet",
                "kmetovalec",
                "moški",
                "vrtnar",
                "živinorejec",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin beeraleey ah"),
            keywords: &[
                "beer-qote",
                "beeraleey",
                "beerinfoof",
                "nin",
                "nin beeraleey ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bujk"),
            keywords: &["bujk", "burrë", "kopshtar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац пољопривредник"),
            keywords: &["башта", "мушкарац", "пољопривредник", "село", "фарма"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac poljoprivrednik"),
            keywords: &["bašta", "farma", "muškarac", "poljoprivrednik", "selo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig bonde"),
            keywords: &[
                "bonde",
                "jordbruk",
                "man",
                "manlig bonde",
                "trädgårdsmästare",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkulima wa kiume"),
            keywords: &["kofia", "mchele", "mkulima", "mkulima wa kiume", "mpunga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} விவச\u{bbe}யி"),
            keywords: &["ஆண\u{bcd}", "விவச\u{bbe}யம\u{bcd}", "விவச\u{bbe}யி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మగ ర\u{c48}తు"),
            keywords: &[
                "త\u{c4b}టమ\u{c3e}ల\u{c3f}",
                "పురుషుడు",
                "మగ త\u{c4b}ట మన\u{c3f}ష\u{c3f}",
                "మగ ర\u{c48}తు",
                "మగ\u{c3e}డు",
                "ర\u{c48}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди фермер"),
            keywords: &[
                "боғбон",
                "мард",
                "марди фермер",
                "соҳиби фермаи чорво",
                "фермер",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชาวนาชาย"),
            keywords: &[
                "ชาวนา",
                "ชาวนาชาย",
                "ชาวสวน",
                "ผ\u{e39}\u{e49}ชาย",
                "เจ\u{e49}าของฟาร\u{e4c}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek daýhan"),
            keywords: &["bagban", "daýhan", "erkek", "oba hojalykçy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata ngoue"),
            keywords: &["tangata ngoue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek çiftçi"),
            keywords: &["adam", "bahçıvan", "erkek", "çiftlik sahibi", "çiftçi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر دېھقان"),
            keywords: &["ئەر", "باغۋەن", "تېرىقچى", "دېھقان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фермер"),
            keywords: &["господар", "садівник", "фермер", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد کاشت کار"),
            keywords: &["باغبان", "مرد", "مرد کاشت کار", "کاشت کار", "کسان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak fermer"),
            keywords: &["bog‘bon", "erkak", "fermer", "rancho egasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nông dân nam"),
            keywords: &[
                "nam",
                "người làm vườn",
                "người nuôi súc vật",
                "nông dân",
                "nông dân nam",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baykat bu góor"),
            keywords: &[
                "baykat",
                "baykat bu góor",
                "boroom-ràns",
                "góor",
                "sardiñee",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfama oyindoda"),
            keywords: &[
                "indoda",
                "umfama",
                "umfama oyindoda",
                "umnini-fama",
                "umsebenzi-gadi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin àgbẹ\u{301}"),
            keywords: &[
                "aṣọ\u{301}gbà",
                "olùtọ\u{301}jú màlùú",
                "àgbẹ\u{301}",
                "ọkùnrin",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男農夫"),
            keywords: &["園丁", "牧人", "男", "男農夫", "農夫"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男农夫"),
            keywords: &["农夫", "园丁", "牧人", "男", "男农夫"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("农夫"),
            keywords: &["农夫", "农民", "园丁", "男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("農夫"),
            keywords: &["園丁", "男", "農夫", "農民"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男農夫"),
            keywords: &["園丁", "男", "男農夫", "農夫", "農民"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umlimi wesilisa"),
            keywords: &["indoda", "umlimi", "umlimi wesilisa"],
        },
    ],
};
#[doc = "👨🏻\u{200d}🌾"]
pub const MAN_FARMER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🌾",
    codepoint: "1F468 1F3FB 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man farmer: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🌾"]
pub const MAN_FARMER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🌾",
    codepoint: "1F468 1F3FC 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man farmer: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🌾"]
pub const MAN_FARMER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🌾",
    codepoint: "1F468 1F3FD 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man farmer: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🌾"]
pub const MAN_FARMER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🌾",
    codepoint: "1F468 1F3FE 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man farmer: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🌾"]
pub const MAN_FARMER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🌾",
    codepoint: "1F468 1F3FF 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man farmer: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🌾"]
pub const WOMAN_FARMER: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🌾",
    codepoint: "1F469 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman farmer",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike boer"),
            keywords: &["boer", "koringaar", "plaas", "vroulike boer"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ገበሬ"),
            keywords: &["ሰው", "ሴት", "ተክል", "ገበሬ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مزارعة"),
            keywords: &["عاملة زراعية", "فلاحة", "مزارعة", "منسقة حدائق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} খেতিয\u{9bc}ক"),
            keywords: &[
                "খেতিয\u{9bc}ক",
                "পশ\u{9c1}প\u{9be}লক",
                "মহিল\u{9be}",
                "ম\u{9be}লী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın fermer"),
            keywords: &["bağban", "fermer", "qadın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фермерка"),
            keywords: &["агародніца", "жанчына", "фермерка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фермерка"),
            keywords: &[
                "градинарка",
                "производителка",
                "селско стопанство",
                "фермерка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}ে , মহিল\u{9be} ,চ\u{9be}ষী , ক\u{9c3}ষক"),
            keywords: &[
                "ক\u{9c3}ষক",
                "চ\u{9be}ষী",
                "মহিল\u{9be}",
                "ম\u{9be}লি",
                "মেয\u{9bc}ে",
                "মেয\u{9bc}ে , মহিল\u{9be} ,চ\u{9be}ষী , ক\u{9c3}ষক",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("labourerez-douar"),
            keywords: &["labourerez-douar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("poljoprivrednica"),
            keywords: &[
                "farmer",
                "poljoprivrednica",
                "poljoprivrednik",
                "rančerica",
                "žena",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pagesa"),
            keywords: &["agricultora", "dona", "femení", "grangera", "pagesa"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄦𑄣\u{11134}𑄣\u{1112e} 𑄟\u{11128}𑄣𑄬"),
            keywords: &["𑄦𑄣\u{11134}𑄣\u{1112e} 𑄟\u{11128}𑄣𑄬"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᎦᎶᎩᏍᎩ"),
            keywords: &["ᎠᎨᏯ", "ᎠᏫᏒᏍᎩ", "ᎤᎾᏝᎾᎢ", "ᏗᎦᎶᎩᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("farmářka"),
            keywords: &["farmářka", "selka", "zahradnice", "zemědělkyně", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ffarmwraig"),
            keywords: &["benywaidd", "ffarmwraig", "ffermio", "garddio", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig landmand"),
            keywords: &[
                "bonde",
                "gartner",
                "kvinde",
                "kvindelig landmand",
                "landmand",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bäuerin"),
            keywords: &["Bäuerin", "Landwirtin", "Ähre"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγρότισσα"),
            keywords: &["αγρότισσα", "γυναίκα", "κήπος", "καλλιέργεια", "κηπουρός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman farmer"),
            keywords: &["farmer", "gardener", "rancher", "woman"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["farmer", "gardener", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la agricultura mujer"),
            keywords: &[
                "agricultora",
                "campo",
                "granjera",
                "labradora",
                "mujer",
                "profesional de la agricultura mujer",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("granjera mujer"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisfarmer"),
            keywords: &["aednik", "farmer", "naine", "naisfarmer"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume nekazaria"),
            keywords: &[
                "baserritar",
                "emakume",
                "emakume nekazaria",
                "emakumezko",
                "lorezain",
                "nekazari",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کشاورز زن"),
            keywords: &["برزگر", "خوشه برنج", "دهقان", "زارع", "کشاورز زن", "کشت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naismaanviljelijä"),
            keywords: &[
                "maanviljelijä",
                "nainen",
                "naismaanviljelijä",
                "puutarhuri",
                "sato",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng magsasaka"),
            keywords: &[
                "babae",
                "babaeng magsasaka",
                "hardinera",
                "magsasaka",
                "rantsero",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur bóndi"),
            keywords: &["bóndi", "kona", "kvinna", "kvinnuligur bóndi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fermière"),
            keywords: &["agricultrice", "femme", "fermière", "jardinière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("feirmeoir baineann"),
            keywords: &[
                "bean",
                "feirmeoir",
                "feirmeoir baineann",
                "garraíodóir",
                "rainseoir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tuathanaiche boireann"),
            keywords: &[
                "boireannach",
                "croitear",
                "gàirnealair",
                "rainsear",
                "tuathanaiche",
                "tuathanaiche boireann",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("agricultora"),
            keywords: &["agricultora", "cultivo", "gando", "granxeira", "muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ખ\u{ac7}ડ\u{ac2}ત"),
            keywords: &[
                "ખ\u{ac7}ડ\u{ac2}ત",
                "માળી",
                "ર\u{ac7}ન\u{acd}ચર",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace manomi"),
            keywords: &["gadina", "mace", "mai kiwon shanu", "manomi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("חקלאית"),
            keywords: &["אישה", "גננית", "חוואית", "חקלאית", "עובדת משק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला किसान"),
            keywords: &["किसान", "ख\u{947}त लगान\u{947}वाली", "महिला", "माली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("poljoprivrednica"),
            keywords: &["farmerica", "poljoprivrednica", "seljakinja", "vrtlarica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női gazda"),
            keywords: &["földműves", "gazda", "kertész", "nő", "női gazda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին ֆերմեր"),
            keywords: &["ագարակատեր", "գյուղացի", "կին", "ֆերմեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("petani wanita"),
            keywords: &["padi", "perempuan", "petani wanita", "sawah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị ọrụ ugbo"),
            keywords: &[
                "nwanyị",
                "nwanyị ọrụ ugbo",
                "onye ọchị nnama",
                "ọrụ ugbo",
                "ọsụ ahịhịa",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns bóndi"),
            keywords: &["bóndi", "garðyrkjumaður", "kona", "kvenkyns bóndi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("contadina"),
            keywords: &["allevatrice", "contadina", "donna", "fattoria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("農家の女性"),
            keywords: &["女", "女性", "農家", "農家の女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bu tani"),
            keywords: &["bu tani", "juragan tani", "tani", "tukang kebon", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფერმერი ქალი"),
            keywords: &["მებაღე", "ფერმერი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("фермер әйел"),
            keywords: &["бағбан", "фермер", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig landmand"),
            keywords: &[
                "bonde",
                "gartner",
                "kvinde",
                "kvindelig landmand",
                "landmand",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កស\u{17b7}ករស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "កស\u{17b7}ករ",
                "កស\u{17b7}ករស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកចម\u{17d2}ការ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೃಷ\u{cbf}ಕ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಕುರ\u{cbf}ಗಾರ",
                "ಕೃಷ\u{cbf}ಕ",
                "ತೋಟಗಾರ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 농부"),
            keywords: &["농부", "농사꾼", "농장 주인", "여자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल श\u{947}तकान\u{94d}न"),
            keywords: &["बायल", "भाटकान\u{94d}न", "माळी", "श\u{947}तकान\u{94d}न"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял фермер"),
            keywords: &["аял", "багбан", "малчы", "фермер"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Bauerefra"),
            keywords: &["Bauerefra", "Fra", "Gäertnerin", "Véiziichterin"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊາວນາຍ\u{eb4}ງ"),
            keywords: &[
                "ກະສ\u{eb4}ກອນ",
                "ຄ\u{ebb}ນສວນ",
                "ຊາວນາ",
                "ຊາວນາຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ເຮ\u{eb1}ດນາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ūkininkė"),
            keywords: &["darbininkė", "moteris", "sodininkė", "ūkininkė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lauksaimniece"),
            keywords: &["dārzeniece", "lauksaimniece", "sieviete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine kaipāmu"),
            keywords: &["kaimahi oneone", "kaipāmu", "kairāti", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("земјоделка"),
            keywords: &["градинар", "жена", "земјоделец", "земјоделка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കർഷക"),
            keywords: &["ക\u{d43}ഷിക\u{d4d}ക\u{d3e}രി", "കർഷക", "സ\u{d4d}ത\u{d4d}രീ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй тариачин"),
            keywords: &["ногооч", "тариачин", "фермер", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला श\u{947}तकरी"),
            keywords: &["महिला", "माळी", "लागवड करणारा", "श\u{947}तकरी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("petani wanita"),
            keywords: &[
                "pekebun",
                "peladang ternak",
                "perempuan",
                "petani",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("bidwi femminil"),
            keywords: &["bidwi", "bidwi femminil", "mara", "raħħal", "ġardinar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လယ\u{103a}သ\u{1030}မ"),
            keywords: &[
                "ကောက\u{103a}စ\u{102d}\u{102f}က\u{103a}သမ",
                "ပန\u{103a}းပျ\u{102d}\u{102f}းသ\u{1030}",
                "လယ\u{103a}သ\u{1030}မ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig gårdbruker"),
            keywords: &[
                "bonde",
                "dyrke",
                "gårdbruker",
                "jordbruk",
                "kvinne",
                "kvinnelig gårdbruker",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला क\u{943}षक"),
            keywords: &[
                "क\u{943}षक",
                "छोरीमान\u{94d}छ\u{947}",
                "महिला",
                "माली",
                "र\u{94d}यान\u{94d}चर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("boerin"),
            keywords: &["boerin", "tuinder", "veehouder", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg gardbrukar"),
            keywords: &[
                "bonde",
                "dyrke",
                "gardbrukar",
                "jordbruk",
                "kvinne",
                "kvinneleg gardbrukar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} କ\u{b43}ଷକ"),
            keywords: &[
                "କ\u{b43}ଷକ",
                "ପଶ\u{b41}ପ\u{b3e}ଳକ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମ\u{b3e}ଳୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਕਿਸਾਨ"),
            keywords: &["ਇਸਤਰੀ", "ਇਸਤਰੀ ਕਿਸਾਨ", "ਔਰਤ", "ਮਾਲਣ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانی کسان"),
            keywords: &["زنانی", "مالی", "مویشی پالن الا", "کسان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Fáma"),
            keywords: &[
                "Fáma",
                "Gádína",
                "Pẹ\u{301}sin Wé Gẹ\u{301}t Bíg Fam Wiá Dẹm De Lúk Áftá Hóm Ánímọl",
                "Wúman",
                "Wúmán Fáma",
                "Óná Ọf Bíg Fam Fọ Hóm Ánímọl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("rolniczka"),
            keywords: &["farmerka", "kobieta", "ogrodniczka", "rolniczka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه د بزګر"),
            keywords: &["بزګر", "مالي", "پادوان", "ښځه", "ښځه د بزګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fazendeira"),
            keywords: &["agricultora", "fazendeira", "jardineira", "mulher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("agricultora"),
            keywords: &[
                "agricultora",
                "fazendeira",
                "jardineira",
                "lavradora",
                "mulher",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi granjera"),
            keywords: &[
                "granjero",
                "jardinero",
                "ranchero",
                "warmi",
                "warmi granjera",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fermieră"),
            keywords: &["agricultoare", "femeie grădinar", "fermieră", "țărancă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1177"),
            keywords: &["E10-1177"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-фермер"),
            keywords: &[
                "дачница",
                "женщина",
                "женщина-фермер",
                "садовник",
                "садовница",
                "фермер",
                "фермерша",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umworozikazi"),
            keywords: &[
                "umugore",
                "umunyabusitani",
                "umutunzi",
                "umworozi",
                "umworozikazi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت هاري"),
            keywords: &["عورت هاري", "عورت، هاري، مالڪ، مالي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගෙව\u{dd2}ල\u{dd2}ය"),
            keywords: &[
                "උයන\u{dca}පල\u{dca}ල\u{dcf}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ගෙව\u{dd2}ල\u{dd2}ය",
                "ගොව\u{dd2}පළ හ\u{dd2}ම\u{dd2}ක\u{dcf}ර\u{dd2}ය",
                "ගොව\u{dd2}ය\u{dcf}",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("roľníčka"),
            keywords: &["farmárka", "poľnohospodár", "roľníčka", "sedliačka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kmetovalka"),
            keywords: &[
                "dekle",
                "kmetica",
                "kmetovalka",
                "vrtnarka",
                "ženska",
                "živinorejka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag beeraleeyad ah"),
            keywords: &[
                "beer-qote",
                "beeraleey",
                "beerinfoof",
                "naag",
                "naag beeraleeyad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bujkeshë"),
            keywords: &["bujkeshë", "grua", "kopshtare"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("пољопривредница"),
            keywords: &["башта", "жена", "пољопривредница", "село", "фарма"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("poljoprivrednica"),
            keywords: &["bašta", "farma", "poljoprivrednica", "selo", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig bonde"),
            keywords: &[
                "bonde",
                "jordbruk",
                "kvinna",
                "kvinnlig bonde",
                "trädgårdsmästare",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkulima wa kike"),
            keywords: &["kofia", "mchele", "mkulima", "mkulima wa kike", "mpunga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} விவச\u{bbe}யி"),
            keywords: &["பெண\u{bcd}", "விவச\u{bbe}யம\u{bcd}", "விவச\u{bbe}யி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడ ర\u{c48}తు"),
            keywords: &[
                "ఆడ త\u{c4b}టమ\u{c3e}ల\u{c3f}",
                "ఆడ ర\u{c48}తు",
                "మగ త\u{c4b}ట మన\u{c3f}ష\u{c3f}",
                "మహ\u{c3f}ళ",
                "ర\u{c48}తు",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани фермер"),
            keywords: &[
                "боғбон",
                "зан",
                "зани фермер",
                "соҳиби фермаи чорво",
                "фермер",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชาวนาหญ\u{e34}ง"),
            keywords: &[
                "ชาวนา",
                "ชาวนาหญ\u{e34}ง",
                "ชาวสวน",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "เจ\u{e49}าของฟาร\u{e4c}ม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan daýhan"),
            keywords: &["bagban", "daýhan", "oba hojalykçy", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine ngoue"),
            keywords: &["fefine ngoue"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın çiftçi"),
            keywords: &["bahçıvan", "bayan", "kadın", "çiftlik sahibi", "çiftçi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال دېھقان"),
            keywords: &["ئايال", "باغۋەن", "تېرىقچى", "دېھقان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фермерка"),
            keywords: &["господарка", "жінка", "садівниця", "фермерка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت کاشت کار"),
            keywords: &["باغبان", "عورت", "عورت کاشت کار", "کاشت کار", "کسان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol fermer"),
            keywords: &["ayol", "bog‘bon", "fermer", "rancho egasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nông dân nữ"),
            keywords: &[
                "người làm vườn",
                "người nuôi súc vật",
                "nông dân",
                "nông dân nữ",
                "nữ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baykat bu jigéen"),
            keywords: &["baykat", "baykat bu jigéen", "jigéen", "sardiñee", "yarkat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umfama olibhinqa"),
            keywords: &[
                "ibhinqa",
                "umfama",
                "umfama olibhinqa",
                "umnini-fama",
                "umsebenzi-gadi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrinàgbẹ\u{301}"),
            keywords: &[
                "aṣọ\u{301}gbà",
                "obìrin",
                "obìrinàgbẹ\u{301}",
                "olùtọ\u{301}jú màlùú",
                "àgbẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女農夫"),
            keywords: &["園丁", "女", "女農夫", "牧人", "農夫"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女农夫"),
            keywords: &["农夫", "园丁", "女", "女农夫", "牧人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("农妇"),
            keywords: &["农妇", "农民", "园丁", "女"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("農婦"),
            keywords: &["園丁", "女", "農婦", "農民"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女農夫"),
            keywords: &["園丁", "女", "女農夫", "農婦", "農民"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umlimi wesimame"),
            keywords: &["owesimame", "umlimi", "umlimi wesimame"],
        },
    ],
};
#[doc = "👩🏻\u{200d}🌾"]
pub const WOMAN_FARMER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🌾",
    codepoint: "1F469 1F3FB 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman farmer: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🌾"]
pub const WOMAN_FARMER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🌾",
    codepoint: "1F469 1F3FC 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman farmer: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🌾"]
pub const WOMAN_FARMER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🌾",
    codepoint: "1F469 1F3FD 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman farmer: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🌾"]
pub const WOMAN_FARMER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🌾",
    codepoint: "1F469 1F3FE 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman farmer: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🌾"]
pub const WOMAN_FARMER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🌾",
    codepoint: "1F469 1F3FF 200D 1F33E",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman farmer: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🍳"]
pub const COOK: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🍳",
    codepoint: "1F9D1 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "cook",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kok"),
            keywords: &["kok", "sjef"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማብሰል"),
            keywords: &["ማብሰል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طاهي"),
            keywords: &["شيف", "طاه", "طاهي", "طباخ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ৰ\u{9be}ন\u{9cd}ধনি"),
            keywords: &[
                "ম\u{9c1}খ\u{9cd}য ৰ\u{9be}ন\u{9cd}ধনি",
                "ৰ\u{9be}ন\u{9cd}ধনি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("aşpaz"),
            keywords: &["aşpaz", "baş aşpaz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("повар"),
            keywords: &["кухар", "повар", "шэф"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("готвач"),
            keywords: &["готвач", "майстор-готвач"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("র\u{9be}\u{981}ধ\u{9c1}নী"),
            keywords: &["র\u{9be}\u{981}ধ\u{9c1}নী", "শেফ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuhar"),
            keywords: &["kuhar", "šef kuhinje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cuiner"),
            keywords: &["cuiner", "xef"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏍᏓᏴᎲᏍᎩ"),
            keywords: &["ᎠᏓᏍᏓᏴᎲᏍᎩ", "ᏗᏓᏍᏓᏴᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuchař/kuchařka"),
            keywords: &[
                "kuchař",
                "kuchař/kuchařka",
                "kuchařka",
                "šéfkuchař",
                "šéfkuchařka",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n coginio"),
            keywords: &["cogydd", "person sy’n coginio", "sieff"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kok"),
            keywords: &["kok", "køkkenchef"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Koch/Köchin"),
            keywords: &["Koch", "Koch/Köchin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σεφ"),
            keywords: &["μάγειρας", "σεφ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("cook"),
            keywords: &["chef", "cook"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chef"),
            keywords: &["chef", "cocinero", "cocinillas", "guisandero", "pinche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("cocinero"),
            keywords: &["cocinero"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["chef", "cocina"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kokk"),
            keywords: &["kokk", "peakokk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sukaldaria"),
            keywords: &["chef", "sukaldari", "sukaldaria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آشپز"),
            keywords: &["آشپز", "سرآشپز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kokki"),
            keywords: &["keittiömestari", "kokki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tagaluto"),
            keywords: &["chef", "tagaluto"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kokkur"),
            keywords: &["høvuðskokkur", "kokkur", "matgera"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cuisinier (tous genres)"),
            keywords: &["chef", "cuisinier", "cuisinier (tous genres)", "cuisinière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("chef"),
            keywords: &["chef"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cócaire"),
            keywords: &["cócaire"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còcaire"),
            keywords: &["còcaire"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("profesional da cociña"),
            keywords: &["cociña", "profesional da cociña", "xefe de cociña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{ac2}ક"),
            keywords: &["ક\u{ac2}ક", "શ\u{ac7}ફ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טבח/ית"),
            keywords: &["טבח", "טבח/ית", "טבחית", "שף", "שפית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बावर\u{94d}ची"),
            keywords: &["बावर\u{94d}ची", "रसोइया", "श\u{947}फ\u{93c}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šef kuhinje"),
            keywords: &["kuhar", "šef kuhinje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szakács / szakácsnő"),
            keywords: &["szakács", "szakács / szakácsnő", "séf"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոհարար"),
            keywords: &["խոհարար", "շեֆ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("koki"),
            keywords: &["chef", "koki"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kokkur"),
            keywords: &["kokkur", "matreiðslumaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che cucina"),
            keywords: &["chef", "cuoco", "persona che cucina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("コック"),
            keywords: &["コック", "シェフ", "料理"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mangsak"),
            keywords: &["koki", "mangsak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზარეული"),
            keywords: &["მზარეული", "შეფი", "შეფმზარეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аспаз"),
            keywords: &["аспаз", "бас аспаз"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17bb}ងភៅ"),
            keywords: &["ច\u{17bb}ងភៅ", "មេច\u{17bb}ងភៅ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಡುಗ\u{cc6}ಮಾಡುವವರು"),
            keywords: &["ಅಡುಗ\u{cc6}ಮಾಡುವವರು", "ಶ\u{cc6}ಫ\u{ccd}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("요리사"),
            keywords: &["셰프", "요리사", "주방장"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("रा\u{902}दपी"),
            keywords: &["रा\u{902}दपी", "श\u{945}फ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ашпозчу"),
            keywords: &["ашпозчу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຕ\u{ec8}ງກ\u{eb4}ນ"),
            keywords: &["ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວ", "ແຕ\u{ec8}ງກ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gaminantis žmogus"),
            keywords: &["gaminantis žmogus", "virėjas", "šefas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis pavārs"),
            keywords: &["pavārs", "vīrietis pavārs", "šefpavārs"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("готвач"),
            keywords: &["готвач", "шеф"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("അട\u{d41}ക\u{d4d}കളക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "അട\u{d41}ക\u{d4d}കളക\u{d4d}ക\u{d3e}രൻ",
                "പ\u{d3e}ചകമ\u{d41}ഖ\u{d4d}യൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хоол хийх"),
            keywords: &["тогооч", "хоол хийх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आचारी"),
            keywords: &["आचारी", "श\u{947}फ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tukang masak"),
            keywords: &["cef", "tukang masak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အချက\u{103a}အပြ\u{102f}တ\u{103a}"),
            keywords: &[
                "ချက\u{103a}ပြ\u{102f}တ\u{103a}သ\u{1030}",
                "စာဖ\u{102d}\u{102f}မ\u{103e}\u{1030}း",
                "အချက\u{103a}အပြ\u{102f}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kokk"),
            keywords: &["kokk", "matlaging", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भान\u{94d}स\u{947}"),
            keywords: &["भान\u{94d}स\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kok"),
            keywords: &["chef-kok", "kok"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kokk"),
            keywords: &["kokk", "matlaging", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ରୋଷେୟ\u{b3e}"),
            keywords: &["ରୋଷେଇ", "ରୋଷେୟ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਾ\u{a02}ਗਰੀ"),
            keywords: &["ਰਸ\u{a4b}ਈਆ", "ਲਾ\u{a02}ਗਰੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Kuk"),
            keywords: &["Chẹf", "Kuk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kucharz"),
            keywords: &["kucharz", "szef kuchni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اشپز"),
            keywords: &["اشپز", "چف"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("chef de cozinha"),
            keywords: &["chef", "chef de cozinha", "cozinheiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cozinheiro"),
            keywords: &["chefe de cozinha", "cozinheiro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wayk’uq"),
            keywords: &["chef", "wayk’uq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bucătar sau bucătăreasă"),
            keywords: &["bucătar", "bucătar sau bucătăreasă", "chef"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-012"),
            keywords: &["E13-012"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("повар"),
            keywords: &["повар", "шеф", "шеф-повар"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("باورچي"),
            keywords: &["باورچي", "ڪوڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අරක\u{dca}කැම\u{dd2}ය\u{dcf}"),
            keywords: &[
                "අරක\u{dca}කැම\u{dd2}ය\u{dcf}",
                "ස\u{dd6}පවේද\u{dd3}ය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kuchár"),
            keywords: &["kuchyňa", "kuchár", "šéfkuchár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuharski mojster"),
            keywords: &["kuhar", "kuharski mojster"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunno kariye"),
            keywords: &["cunno kariye", "madaxa sare, cunno kariye"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person kuzhinier"),
            keywords: &["kuzhinier", "person kuzhinier", "shef kuzhine"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кувар"),
            keywords: &["кувар", "шеф"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuvar"),
            keywords: &["kuvar", "šef"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kock"),
            keywords: &["kock", "köksmästare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mpishi"),
            keywords: &["mpishi", "mpishi mkuu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சமையல\u{bcd}க\u{bbe}ரர\u{bcd}"),
            keywords: &["சமையல\u{bcd}க\u{bbe}ரர\u{bcd}", "செஃப\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వంట చ\u{c47}స\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "వంట చ\u{c47}స\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వంట పన\u{c3f} చ\u{c47}స\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ก\u{e38}\u{e4a}ก"),
            keywords: &["ก\u{e38}\u{e4a}ก", "เชฟ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşpez"),
            keywords: &["aşpez", "baş aşpez"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ngaohikai"),
            keywords: &["tokotaha ngaohikai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("aşçı"),
            keywords: &["aşçı", "yemek pişirme"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("куховар"),
            keywords: &["кухар", "куховар", "шеф"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("باورچی"),
            keywords: &["باورچی", "شیف"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oshpaz"),
            keywords: &["bosh oshpaz", "oshpaz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu bếp"),
            keywords: &["nấu ăn", "đầu bếp"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("廚師"),
            keywords: &["廚師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("厨师"),
            keywords: &["厨师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("厨师"),
            keywords: &["做饭", "厨师", "大厨"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("廚師"),
            keywords: &["廚師", "烹飪"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("pheka"),
            keywords: &["pheka", "umpheki"],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🍳"]
pub const COOK_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🍳",
    codepoint: "1F9D1 1F3FB 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "cook: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🍳"]
pub const COOK_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🍳",
    codepoint: "1F9D1 1F3FC 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "cook: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🍳"]
pub const COOK_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🍳",
    codepoint: "1F9D1 1F3FD 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "cook: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🍳"]
pub const COOK_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🍳",
    codepoint: "1F9D1 1F3FE 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "cook: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🍳"]
pub const COOK_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🍳",
    codepoint: "1F9D1 1F3FF 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "cook: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🍳"]
pub const MAN_COOK: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🍳",
    codepoint: "1F468 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man cook",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike kok"),
            keywords: &["eier", "kok", "manlike kok", "pan"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ አብሳይ"),
            keywords: &["ማብሰል", "ሰው", "አብሳይ", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طباخ"),
            keywords: &["شيف", "طاه", "طباخ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ ৰ\u{9be}ন\u{9cd}ধনি"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষ", "ৰ\u{9be}ন\u{9cd}ধনি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi aşbaz"),
            keywords: &["aşbaz", "kişi", "şef"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кухар"),
            keywords: &["кухар", "мужчына", "шэф-повар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж готвач"),
            keywords: &["готвач", "готвещ мъж", "мъж готвач"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ছেলে ,প\u{9c1}র\u{9c1}ষ , ক\u{9c1}ক , প\u{9be}চক , র\u{9be}\u{981}ধ\u{9c1}নি",
            ),
            keywords: &[
                "ক\u{9c1}ক",
                "ছেলে",
                "ছেলে ,প\u{9c1}র\u{9c1}ষ , ক\u{9c1}ক , প\u{9be}চক , র\u{9be}\u{981}ধ\u{9c1}নি",
                "প\u{9c1}র\u{9c1}ষ",
                "র\u{9be}\u{981}ধ\u{9c1}নি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("keginer"),
            keywords: &["keginer"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuhar muškarac"),
            keywords: &["kuhar", "muškarac", "šef kuhinje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home cuiner"),
            keywords: &["cuiner", "home", "masculí", "xef"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄝𑄉\u{1112e}𑄌\u{11134}\u{11128}"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄝𑄉\u{1112e}𑄌\u{11134}\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎠᏓᏍᏓᏴᎲᏍᎦ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏓᏍᏓᏴᎲᏍᎦ", "ᎣᎯᏍᏗ ᎠᏓᏍᏓᏴᎲᏍᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuchař"),
            keywords: &["kuchař", "muž", "šéfkuchař"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cogydd"),
            keywords: &["coginio", "cogydd", "dyn", "gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig kok"),
            keywords: &["kok", "madlavning", "mand", "mandlig kok", "stegepande"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Koch"),
            keywords: &["Koch", "Kochen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάγειρας"),
            keywords: &["άντρας", "μάγειρας", "μαγειρική", "σεφ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man cook"),
            keywords: &["chef", "cook", "man"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chef hombre"),
            keywords: &["chef", "cocinero", "hombre", "pinche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["chef", "cocinero", "hombre"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeskokk"),
            keywords: &["kokk", "mees", "meeskokk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon sukaldaria"),
            keywords: &[
                "chef",
                "gizon",
                "gizon sukaldaria",
                "gizonezko",
                "sukaldari",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آشپز مرد"),
            keywords: &["آشپز مرد", "آشپزی", "سرآشپز", "شف", "پخت و پز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mieskokki"),
            keywords: &["kokki", "mies", "mieskokki", "paistinpannu", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kusinero"),
            keywords: &["chef", "cook", "kusinero", "lalaki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur kokkur"),
            keywords: &["kokkur", "mannligur kokkur", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cuisinier"),
            keywords: &["chef", "cuisinier", "homme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cócaire fireann"),
            keywords: &["chef", "cócaire", "cócaire fireann", "fear"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("còcaire fireann"),
            keywords: &["còcaire", "còcaire fireann", "duine", "fear", "fireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cociñeiro"),
            keywords: &["cociñar", "cociñeiro", "home", "xefe de cociña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રસોઇયો"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ", "મહારાજ", "રસોઇયો", "રસોઈયો"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum kuku"),
            keywords: &["kuku", "mai girki", "mutum"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טבח"),
            keywords: &["גבר", "טבח", "מבשל", "שף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("रसोइया"),
            keywords: &["आदमी", "प\u{941}र\u{941}ष", "महाराज", "रसोइया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kuhar"),
            keywords: &["kuhar", "šef kuhinje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szakács"),
            keywords: &["férfi", "szakács", "séf"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ խոհարար"),
            keywords: &["խոհարար", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("koki pria"),
            keywords: &["dapur", "koki pria", "laki-laki", "memasak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-esi nri"),
            keywords: &["na-esi", "nri", "nwoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns kokkur"),
            keywords: &["elda", "karl", "karlkyns kokkur", "kokkur", "matreiðsla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuoco"),
            keywords: &["chef", "cucinare", "cuoco", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性のコック"),
            keywords: &["コック", "シェフ", "料理", "男", "男性", "男性のコック"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("koki lanang"),
            keywords: &["koki", "lanang", "mangsak"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზარეული კაცი"),
            keywords: &["კაცი", "მზარეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер аспаз"),
            keywords: &["аспаз", "аспазшы", "ер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kok"),
            keywords: &["kok", "madlavning", "mand", "stegepande"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17bb}ងភៅប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ច\u{17bb}ងភៅ",
                "ច\u{17bb}ងភៅប\u{17d2}រ\u{17bb}ស",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "អ\u{17d2}នកចម\u{17d2}អ\u{17b7}នអាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಡುಗ\u{cc6} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ"),
            keywords: &[
                "ಅಡುಗ\u{cc6} ಮಾಡು",
                "ಅಡುಗ\u{cc6} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ",
                "ಪುರುಷ",
                "ಬಾಣಸ\u{cbf}ಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 요리사"),
            keywords: &["남자", "셰프", "요리사", "주방장"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो रा\u{902}दपी"),
            keywords: &["दादलो", "रा\u{902}दपी", "श\u{945}फ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек ашпозчу"),
            keywords: &["ашпозчу", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Chefkach"),
            keywords: &["Chef", "Chefkach", "Kach", "Mann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວຊາຍ"),
            keywords: &[
                "ຄ\u{ebb}ວກ\u{eb4}ນ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວ",
                "ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("virėjas"),
            keywords: &["virėjas", "vyras", "šefas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pavārs"),
            keywords: &["pavārs", "vīrietis", "šefpavārs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaitao tāne"),
            keywords: &["kaitaka kai", "kaitao", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж готвач"),
            keywords: &["готвач", "маж", "машко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ചകക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "പ\u{d3e}ചകക\u{d4d}ക\u{d3e}രൻ",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "ഭക\u{d4d}ഷണം പ\u{d3e}കം ചെയ\u{d4d}യ\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй тогооч"),
            keywords: &["тогооч", "эр", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}वय\u{902}पाकी"),
            keywords: &["प\u{941}र\u{942}ष", "श\u{947}फ", "स\u{94d}वय\u{902}पाकी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tukang masak lelaki"),
            keywords: &["cef", "lelaki", "tukang masak", "tukang masak lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kok maskil"),
            keywords: &["chef", "kok", "kok maskil", "raġel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား စားဖ\u{102d}\u{102f}မ\u{103e}\u{1030}း"),
            keywords: &[
                "စားဖ\u{102d}\u{102f}မ\u{103e}\u{1030}း",
                "အချက\u{103a}အပြ\u{102f}တ\u{103a}",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig kokk"),
            keywords: &["mann", "mannlig kokk", "matlaging", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष भान\u{94d}स\u{947}"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "भान\u{94d}स\u{947}",
                "स\u{947}फ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke kok"),
            keywords: &["chef-kok", "kok", "man", "mannelijke kok"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg kokk"),
            keywords: &["mann", "mannleg kokk", "matlaging", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ପ\u{b3e}ଚକ"),
            keywords: &[
                "ପ\u{b3e}ଚକ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ମ\u{b41}ଖ\u{b4d}ୟ ପ\u{b3e}ଚକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਰਸ\u{a4b}ਈਆ"),
            keywords: &[
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਰਸ\u{a4b}ਈਆ",
                "ਸ\u{a3c}\u{a48}\u{a71}ਫ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھانا پکان آلا بندہ"),
            keywords: &["باورچی", "بندہ", "روٹی پکان آلا", "کھانا پکان آلا بندہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Kuk"),
            keywords: &["Chẹf", "Kuk", "Man", "Mán Kuk", "Ẹ\u{301}spát Kuk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna kucharz"),
            keywords: &["kucharz", "mężczyzna", "szef kuchni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی پخوونکی"),
            keywords: &["اشپز", "سړی", "پخوونکی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cozinheiro"),
            keywords: &["chef", "cozinheiro", "homem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cozinheiro (homem)"),
            keywords: &["chef", "cozinheiro", "cozinheiro (homem)", "homem"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata wayk’uq"),
            keywords: &["chef", "tata", "wayk’uq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bucătar"),
            keywords: &["bucătar", "bucătărie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1162"),
            keywords: &["E10-1162"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-повар"),
            keywords: &["готовить", "еда", "мужчина", "мужчина-повар", "повар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’umutetsi"),
            keywords: &[
                "umugabo",
                "umugabo w’umutetsi",
                "umutetsi",
                "umutetsi wabyigiye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد بورچي"),
            keywords: &["مرد بورچي", "مرد، بورچي، خصوصي بورچي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කෝක\u{dd2}ය\u{dcf}"),
            keywords: &[
                "අරක\u{dca}කැම\u{dd2}ය\u{dcf}",
                "කෝක\u{dd2}ය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kuchár muž"),
            keywords: &["kuchyňa", "kuchár", "muž", "šéfkuchár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuhar"),
            keywords: &["chef", "fant", "kuhar", "moški", "šef kuhinje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin kariye ah"),
            keywords: &["kariye", "madaxa kariyaha", "nin", "nin kariye ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuzhinier"),
            keywords: &["burrë", "kuzhinier", "kuzhinë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац кувар"),
            keywords: &["кувар", "кухиња", "мушкарац", "шеф"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушкарац кувар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac kuvar"),
            keywords: &["kuhinja", "kuvar", "muškarac", "šef"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muškarac kuvar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig kock"),
            keywords: &["man", "manlig kock", "matlagning", "restaurang"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mpishi wa kiume"),
            keywords: &["kikaango", "mpishi", "mpishi wa kiume", "sufuria"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} சமையல\u{bcd} வல\u{bcd}லுநர\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "ஆண\u{bcd} சமையல\u{bcd} வல\u{bcd}லுநர\u{bcd}",
                "சமையல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వంటవ\u{c3e}డు"),
            keywords: &[
                "పురుషుడు",
                "మగ వంటవ\u{c3e}డు",
                "మగ\u{c3e}డు",
                "వంటవ\u{c3e}డు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди ошпаз"),
            keywords: &["мард", "марди ошпаз", "ошпаз", "сардори ошпазон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พ\u{e48}อคร\u{e31}ว"),
            keywords: &["ผ\u{e39}\u{e49}ชาย", "พ\u{e48}อคร\u{e31}ว", "เชฟ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek aşpez"),
            keywords: &["aşpez", "erkek", "şef"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata ngaohikai"),
            keywords: &["tangata ngaohikai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek aşçı"),
            keywords: &["adam", "erkek", "erkek aşçı", "yemek yapma", "şef"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر ئاشپەز"),
            keywords: &["ئاش", "ئاشپەز", "ئەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кухар"),
            keywords: &["кулінар", "кухар", "чоловік", "шеф-кухар"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد باورچی"),
            keywords: &["باورچی", "شیف", "مرد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak oshpaz"),
            keywords: &["bosh oshpaz", "erkak", "kishi", "oshpaz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu bếp nam"),
            keywords: &["nam", "nấu ăn", "đầu bếp", "đầu bếp nam"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("toggkat góor"),
            keywords: &["góor", "seef", "toggkat"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umpheki oyindoda"),
            keywords: &["indoda", "pheka", "umpheki", "umpheki oyindoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin olùse ónjẹ"),
            keywords: &["olùse ónjẹ", "olúse ónjẹ", "ọkùnrin", "ọkùnrin olùse ónjẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男廚師"),
            keywords: &["大廚", "廚師", "男", "男廚師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男厨师"),
            keywords: &["厨师", "大厨", "男", "男厨师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男厨师"),
            keywords: &["做饭", "厨师", "大厨", "男", "男厨师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男廚師"),
            keywords: &["廚師", "男", "男廚師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umpheki wesilisa"),
            keywords: &["indoda", "umpheki", "umpheki wesilisa"],
        },
    ],
};
#[doc = "👨🏻\u{200d}🍳"]
pub const MAN_COOK_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🍳",
    codepoint: "1F468 1F3FB 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man cook: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🍳"]
pub const MAN_COOK_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🍳",
    codepoint: "1F468 1F3FC 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man cook: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🍳"]
pub const MAN_COOK_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🍳",
    codepoint: "1F468 1F3FD 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man cook: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🍳"]
pub const MAN_COOK_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🍳",
    codepoint: "1F468 1F3FE 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man cook: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🍳"]
pub const MAN_COOK_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🍳",
    codepoint: "1F468 1F3FF 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man cook: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🍳"]
pub const WOMAN_COOK: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🍳",
    codepoint: "1F469 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman cook",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike kok"),
            keywords: &["eier", "kok", "pan", "vroulike kok"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት አብሳይ"),
            keywords: &["ማብሰል", "ሴት", "አብሳይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طباخة"),
            keywords: &["شيف", "طاهية", "طباخة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} ৰ\u{9be}ন\u{9cd}ধনি"),
            keywords: &["মহিল\u{9be}", "ৰ\u{9be}ন\u{9cd}ধনি"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın aşbaz"),
            keywords: &["aşbaz", "qadın", "şef"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кухарка"),
            keywords: &["жанчына", "кухарка", "шэф-кухар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("готвачка"),
            keywords: &["готвачка", "готвеща жена"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "মেয\u{9bc}ে , মহিল\u{9be} , ক\u{9c1}ক , প\u{9be}চক , র\u{9be}\u{981}ধ\u{9c1}নি",
            ),
            keywords: &[
                "ক\u{9c1}ক",
                "প\u{9be}চক",
                "মহিল\u{9be}",
                "মেয\u{9bc}ে",
                "মেয\u{9bc}ে , মহিল\u{9be} , ক\u{9c1}ক , প\u{9be}চক , র\u{9be}\u{981}ধ\u{9c1}নি",
                "র\u{9be}\u{981}ধ\u{9c1}নি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("keginerez"),
            keywords: &["keginerez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kuharica"),
            keywords: &["kuhar", "kuharica", "šef kuhinje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cuinera"),
            keywords: &["cuinera", "dona", "femení", "xef"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄝𑄉\u{1112e}𑄌\u{11134}\u{11128}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄝𑄉\u{1112e}𑄌\u{11134}\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᏓᏍᏓᏴᎲᏍᎩ"),
            keywords: &["ᎠᎨᏯ", "ᏗᏓᏍᏓᏴᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kuchařka"),
            keywords: &["kuchařka", "šéfkuchařka", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cogyddes"),
            keywords: &["benywaidd", "coginio", "cogydd", "cogyddes", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig kok"),
            keywords: &["kok", "kvinde", "kvindelig kok", "madlavning", "stegepande"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Köchin"),
            keywords: &["Köchin", "kochen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μαγείρισσα"),
            keywords: &["γυναίκα", "μαγείρισσα", "μαγειρική", "σεφ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman cook"),
            keywords: &["chef", "cook", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("chef mujer"),
            keywords: &["chef", "cocinera", "mujer", "pinche"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["chef", "cocinera", "mujer"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naiskokk"),
            keywords: &["kokk", "naine", "naiskokk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume sukaldaria"),
            keywords: &[
                "chef",
                "emakume",
                "emakume sukaldaria",
                "emakumezko",
                "sukaldari",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آشپز زن"),
            keywords: &["آشپز زن", "آشپزی", "سرآشپز", "شف", "پخت و پز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naiskokki"),
            keywords: &["kokki", "nainen", "naiskokki", "paistinpannu", "ruoka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kusinera"),
            keywords: &["babae", "chef", "cook", "kusinera"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur kokkur"),
            keywords: &["kokkur", "kona", "kvinna", "kvinnuligur kokkur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cuisinière"),
            keywords: &["chef", "cuisinière", "femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cócaire baineann"),
            keywords: &["bean", "chef", "cócaire", "cócaire baineann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ban-chòcaire"),
            keywords: &["ban-chòcaire", "boireannach", "còcaire", "tè"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cociñeira"),
            keywords: &["cociñar", "cociñeira", "muller", "xefa de cociña"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રસોયણ"),
            keywords: &["રસોયણ", "રા\u{a82}ધવ\u{ac1}\u{a82}", "સ\u{acd}ત\u{acd}રી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace kuku"),
            keywords: &["kuku", "mace", "mai girki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("טבחית"),
            keywords: &["אישה", "טבחית", "מבשלת", "שפית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला रसोइया"),
            keywords: &["बावर\u{94d}ची", "महिला", "रसोइया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kuharica"),
            keywords: &["kuharica", "šefica kuhinje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szakácsnő"),
            keywords: &["nő", "szakácsnő", "séf"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոհարարուհի"),
            keywords: &["խոհարար", "խոհարարուհի", "կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("koki wanita"),
            keywords: &["dapur", "koki wanita", "memasak", "perempuan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-esi"),
            keywords: &["na-esi", "nri", "nwanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns kokkur"),
            keywords: &["elda", "kokkur", "kona", "kvenkyns kokkur", "matreiðsla"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cuoca"),
            keywords: &["chef", "cucinare", "cuoca", "donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性のコック"),
            keywords: &["コック", "シェフ", "女", "女性", "女性のコック", "料理"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("koki wadon"),
            keywords: &["koki", "mangsak", "wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მზარეული ქალი"),
            keywords: &["მზარეული", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аспаз әйел"),
            keywords: &["аспаз", "аспазшы", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig kok"),
            keywords: &["kok", "kvinde", "kvindelig kok", "madlavning", "stegepande"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17bb}ងភៅស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ច\u{17bb}ងភៅ",
                "ច\u{17bb}ងភៅស\u{17d2}រ\u{17b8}",
                "នារ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកចម\u{17d2}អ\u{17b7}នអាហារ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಡುಗ\u{cc6} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ"),
            keywords: &[
                "ಅಡುಗ\u{cc6} ಮಾಡು",
                "ಅಡುಗ\u{cc6} ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಬಾಣಸ\u{cbf}ಗ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 요리사"),
            keywords: &["셰프", "여자", "요리사", "주방장"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल रा\u{902}दपी"),
            keywords: &["बायल", "रा\u{902}दपी", "श\u{945}फ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял ашпозчу"),
            keywords: &["ашпозчу", "аял"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Chefkächen"),
            keywords: &["Cheffin", "Chefkächen", "Fra", "Kächen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວຍ\u{eb4}ງ"),
            keywords: &[
                "ຄ\u{ebb}ວກ\u{eb4}ນ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວ",
                "ພ\u{ecd}\u{ec8}ຄ\u{ebb}ວຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("virėja"),
            keywords: &["moteris", "virėja", "šefė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pavāre"),
            keywords: &["pavāre", "sieviete", "šefpavāre"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaitao wahine"),
            keywords: &["kaitaka kai", "kaitao", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("готвачка"),
            keywords: &["готвачка", "жена", "женско"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d3e}ചകക\u{d4d}ക\u{d3e}രി"),
            keywords: &[
                "പ\u{d3e}ചകക\u{d4d}ക\u{d3e}രി",
                "ഭക\u{d4d}ഷണം പ\u{d3e}കം ചെയ\u{d4d}യ\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй тогооч"),
            keywords: &["тогооч", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}वय\u{902}पाकीण"),
            keywords: &[
                "महिला",
                "श\u{947}फ",
                "स\u{94d}वय\u{902}पाकी",
                "स\u{94d}वय\u{902}पाकीण",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tukang masak wanita"),
            keywords: &[
                "cef",
                "perempuan",
                "tukang masak",
                "tukang masak wanita",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("kok femminil"),
            keywords: &["chef", "kok", "kok femminil", "mara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း စားဖ\u{102d}\u{102f}မ\u{103e}\u{1030}း"),
            keywords: &[
                "စားဖ\u{102d}\u{102f}မ\u{103e}\u{1030}း",
                "အချက\u{103a}အပြ\u{102f}တ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig kokk"),
            keywords: &["kvinne", "kvinnelig kokk", "matlaging", "restaurant"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला भान\u{94d}स\u{947}"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "भान\u{94d}स\u{947}",
                "महिला",
                "स\u{947}फ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kokkin"),
            keywords: &["chef-kok", "kokkin", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg kokk"),
            keywords: &["kvinne", "kvinneleg kokk", "matlaging", "restaurant"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ପ\u{b3e}ଚ\u{b3f}କ\u{b3e}"),
            keywords: &[
                "ପ\u{b3e}ଚ\u{b3f}କ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମ\u{b41}ଖ\u{b4d}ୟ ପ\u{b3e}ଚକ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਰਸ\u{a4b}ਈਆ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਰਸ\u{a4b}ਈਆ",
                "ਔਰਤ",
                "ਸ\u{a3c}\u{a48}\u{a71}ਫ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھانا پکان آلی زنانی"),
            keywords: &["باورچی", "روٹی پکان آلا", "زنانی", "کھانا پکان آلی زنانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Kuk"),
            keywords: &["Chẹf", "Kuk", "Wúman", "Wúmán Kuk", "Ẹ\u{301}spát Kuk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kucharka"),
            keywords: &["kobieta", "kucharka", "szef kuchni"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه پخوونکی"),
            keywords: &["اشپز", "پخوونکی", "ښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cozinheira"),
            keywords: &["chef", "cozinheira", "mulher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi wayk’uq"),
            keywords: &["chef", "warmi", "wayk’uq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bucătăreasă"),
            keywords: &["bucătăreasă", "bucătărie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1178"),
            keywords: &["E10-1178"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("повариха"),
            keywords: &["готовить", "еда", "женщина", "повар", "повариха"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umutetsikazi"),
            keywords: &["umugore", "umutetsi", "umutetsi wabyigiye", "umutetsikazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت بورچي"),
            keywords: &["عورت بورچي", "عورت، بورچي، خصوصي بورچي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කෝක\u{dd2}ය"),
            keywords: &[
                "අරක\u{dca}කැම\u{dd2}ය\u{dcf}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "කෝක\u{dd2}ය",
                "කෝක\u{dd2}ය\u{dcf}",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kuchárka"),
            keywords: &["kuchyňa", "kuchárka", "šéfkuchárka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kuharica"),
            keywords: &["chef", "dekle", "kuharica", "šefinja kuhinje", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag kariso ah"),
            keywords: &["kariye", "madaxa kariyaha", "naag", "naag kariso ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kuzhiniere"),
            keywords: &["grua", "kuzhiniere", "kuzhinë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("куварица"),
            keywords: &["жена", "кувар", "куварица", "кухиња", "шеф"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kuvarica"),
            keywords: &["kuhinja", "kuvar", "kuvarica", "šef", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig kock"),
            keywords: &["kvinna", "kvinnlig kock", "matlaging", "restaurang"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mpishi wa kike"),
            keywords: &[
                "kikaango",
                "mpishi",
                "mpishi wa kike",
                "mwanamke",
                "sufuria",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} சமையல\u{bcd} வல\u{bcd}லுநர\u{bcd}"),
            keywords: &[
                "சமையல\u{bcd}",
                "பெண\u{bcd}",
                "பெண\u{bcd} சமையல\u{bcd} வல\u{bcd}லுநர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వంట\u{c3e}వ\u{c3f}డ"),
            keywords: &[
                "ఆడ వంట మన\u{c3f}ష\u{c3f}",
                "మహ\u{c3f}ళ",
                "వంట మన\u{c3f}ష\u{c3f}",
                "వంట\u{c3e}వ\u{c3f}డ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани ошпаз"),
            keywords: &["зан", "зани ошпаз", "ошпаз", "сардори ошпазон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แม\u{e48}คร\u{e31}ว"),
            keywords: &["ผ\u{e39}\u{e49}หญ\u{e34}ง", "เชฟ", "แม\u{e48}คร\u{e31}ว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan aşpez"),
            keywords: &["aşpez", "zenan", "şef"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine ngaohikai"),
            keywords: &["fefine ngaohikai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın aşçı"),
            keywords: &["bayan", "kadın", "kadın aşçı", "yemek yapma", "şef"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال ئاشپەز"),
            keywords: &["ئاش", "ئاشپەز", "ئايال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кухарка"),
            keywords: &["жінка", "кулінарка", "кухарка", "шеф-кухарка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت باورچی"),
            keywords: &["باورچی", "شیف", "عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol oshpaz"),
            keywords: &["ayol", "bosh oshpaz", "oshpaz", "xotin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đầu bếp nữ"),
            keywords: &["nấu ăn", "nữ", "đầu bếp", "đầu bếp nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("toggkat bu jigéen"),
            keywords: &["jigéen", "seef", "toggkat", "toggkat bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umpheki olibhinqa"),
            keywords: &["ibhinqa", "pheka", "umpheki", "umpheki olibhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrin olùse ónjẹ"),
            keywords: &["obìrin", "obìrin olùse ónjẹ", "olùse ónjẹ", "olúse ónjẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女廚師"),
            keywords: &["大廚", "女", "女廚師", "廚師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女厨师"),
            keywords: &["厨师", "大厨", "女", "女厨师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女厨师"),
            keywords: &["做饭", "厨师", "大厨", "女", "女厨师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女廚師"),
            keywords: &["女", "女廚師", "廚師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umpheki wesimame"),
            keywords: &["owesimame", "umpheki", "umpheki wesimame"],
        },
    ],
};
#[doc = "👩🏻\u{200d}🍳"]
pub const WOMAN_COOK_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🍳",
    codepoint: "1F469 1F3FB 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman cook: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🍳"]
pub const WOMAN_COOK_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🍳",
    codepoint: "1F469 1F3FC 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman cook: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🍳"]
pub const WOMAN_COOK_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🍳",
    codepoint: "1F469 1F3FD 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman cook: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🍳"]
pub const WOMAN_COOK_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🍳",
    codepoint: "1F469 1F3FE 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman cook: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🍳"]
pub const WOMAN_COOK_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🍳",
    codepoint: "1F469 1F3FF 200D 1F373",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman cook: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🔧"]
pub const MECHANIC: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🔧",
    codepoint: "1F9D1 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "mechanic",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("werktuigkundige"),
            keywords: &["elektrisiën", "loodgieter", "werktuigkundige"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሜካኒክ"),
            keywords: &["ሜካኒክ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("خبير ميكانيكي"),
            keywords: &[
                "تاجر",
                "حرفي",
                "خبير ميكانيكي",
                "سباك",
                "كهربائي",
                "ميكانيكي",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেক\u{9be}নিক"),
            keywords: &[
                "ইলেক\u{9cd}ট\u{9cd}ৰিচিয\u{9bc}\u{9be}ন",
                "ট\u{9cd}ৰেডব\u{9cd}যক\u{9cd}তি",
                "প\u{9cd}ল\u{9be}ম\u{9cd}ব\u{9be}ৰ",
                "মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mexanik"),
            keywords: &["elektrik", "mexanik", "santexnik", "ticarətçi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("механік"),
            keywords: &["майстар", "механік", "сантэхнік", "электрык"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("механик"),
            keywords: &["водопроводчик", "електротехник", "механик"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেক\u{9be}নিক"),
            keywords: &[
                "ইলেকট\u{9cd}রিশিয\u{9bc}\u{9be}ন",
                "ছোট ব\u{9cd}যবস\u{9be}দ\u{9be}র",
                "প\u{9cd}ল\u{9be}মব\u{9be}র",
                "মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mehaničar"),
            keywords: &[
                "električar",
                "fizički radnik",
                "mehaničar",
                "vodoinstalater",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mecànic"),
            keywords: &["electricista", "lampista", "mecànic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏙᏆᎴᎷ ᎣᏍᏓ ᏱᏗᎬᏁᎯ"),
            keywords: &[
                "ᎠᎵᎢᏛᎲᏍᎩ",
                "ᎠᎹ ᏧᏪᏓᏍᏗᎢ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
                "ᎠᎾᎦᎵᏍᎩ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏙᏆᎴᎷ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mechanik/mechanička"),
            keywords: &[
                "elektrikář",
                "elektrikářka",
                "mechanik",
                "mechanik/mechanička",
                "mechanička",
                "montér",
                "montérka",
                "opravář",
                "opravářka",
                "řemeslnice",
                "řemeslník",
                "živnostnice",
                "živnostník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mecanig"),
            keywords: &["crefftwr", "mecanig", "plymer", "trydanwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mekaniker"),
            keywords: &[
                "elektriker",
                "håndværker",
                "mekaniker",
                "skruenøgle",
                "vvs-tekniker",
                "vvs’er",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mechaniker(in)"),
            keywords: &["Elektriker", "Klempner", "Mechaniker", "Mechaniker(in)"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Mechaniker(in)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μηχανικός"),
            keywords: &[
                "ειδικευμένος εργάτης",
                "ηλεκτρολόγος",
                "μηχανικός",
                "υδραυλικός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mechanic"),
            keywords: &["electrician", "mechanic", "plumber", "tradesperson"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "electrician",
                "mechanic",
                "plumber",
                "tradesperson",
                "tradie",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la mecánica"),
            keywords: &[
                "electricista",
                "fontanero",
                "mecánico",
                "operario",
                "profesional de la mecánica",
                "técnico",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["electricidad", "plomería", "profesional de la mecánica"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mehaanik"),
            keywords: &["elektrik", "mehaanik", "torulukksepp", "torumees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mekanikaria"),
            keywords: &[
                "elektrikari",
                "iturgin",
                "mekanikari",
                "mekanikaria",
                "saltzaile",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مکانیک"),
            keywords: &["برق\u{200c}کار", "لوله\u{200c}کش", "مکانیک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mekaanikko"),
            keywords: &["mekaanikko", "putkiasentaja", "sähköasentaja", "työkalu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mekaniko"),
            keywords: &["elektrisyan", "mekaniko", "tubero"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mekanikari"),
            keywords: &["maksinsmiður", "mekanikari", "rørsmiður", "smiður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mécanicien (tous genres)"),
            keywords: &[
                "artisan",
                "mécanicien",
                "mécanicien (tous genres)",
                "mécanicienne",
                "plombier",
                "électricien",
                "électricienne",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("mécanicien"),
            keywords: &["mécanicien", "ouvrier", "plombier", "électricien"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meicneoir"),
            keywords: &["meicneoir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meacanaig"),
            keywords: &["ceàrd", "dealanair", "meacanaig", "plumair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("profesional da mecánica"),
            keywords: &[
                "electricidade",
                "fontaneiría",
                "mecánica",
                "profesional da mecánica",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ય\u{a82}ત\u{acd}ર - કારીગર"),
            keywords: &[
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિશિયન",
                "પ\u{acd}લમ\u{acd}બર",
                "ય\u{a82}ત\u{acd}ર - કારીગર",
                "વ\u{ac7}પારી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונאי/ת"),
            keywords: &["חשמלאי", "חשמלאית", "מכונאי", "מכונאי/ת", "מכונאית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{948}क\u{947}निक"),
            keywords: &[
                "नलसाज\u{93c}",
                "बिजली का काम करन\u{947} वाला",
                "म\u{948}क\u{947}निक",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("serviser"),
            keywords: &[
                "električar",
                "majstor",
                "mehaničar",
                "serviser",
                "vodoinstalater",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szerelő / szerelőnő"),
            keywords: &[
                "szaki",
                "szerelő",
                "szerelő / szerelőnő",
                "villanyszerelő",
                "vízvezeték-szerelő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փականագործ"),
            keywords: &[
                "արհեստավոր",
                "էլեկտրիկ",
                "մեխանիկ",
                "ջրմուղագործ",
                "փականագործ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mekanik"),
            keywords: &[
                "mekanik",
                "pekerja terlatih",
                "tukang ledeng",
                "tukang listrik",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vélvirki"),
            keywords: &[
                "iðnverkamaður",
                "pípulagningarmaður",
                "rafvirki",
                "vélvirki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("meccanico"),
            keywords: &[
                "elettricista",
                "idraulico",
                "meccanico",
                "tecnico specializzato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("整備士"),
            keywords: &["スパナ", "メカニック", "作業員", "工作", "整備士"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montir"),
            keywords: &["montir", "tukang", "tukang ledheng", "tukang listik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელოსანი"),
            keywords: &["ელექტრიკოსი", "ელექტროტექნიკოსი", "სანტექნიკი", "ხელოსანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("механик"),
            keywords: &["бейінді маман", "механик", "сантехник", "электрик"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជាងម\u{17c9}ាស\u{17ca}\u{17b8}ន"),
            keywords: &[
                "ជាងទ\u{17bb}យោ",
                "ជាងម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "ជាងអគ\u{17d2}គ\u{17b7}សន\u{17b8}",
                "ឈ\u{17d2}ម\u{17bd}ញ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}"),
            keywords: &[
                "ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಷನ\u{ccd}",
                "ಪ\u{ccd}ಲಂಬರ\u{ccd}",
                "ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}",
                "ಮ\u{ccd}ಯಾಕಾನ\u{cbf}ಕ\u{ccd}",
                "ವ\u{ccd}ಯಾಪಾರ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("정비공"),
            keywords: &["배관공", "전기 기사", "정비공"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{945}कानीक"),
            keywords: &[
                "इल\u{945}क\u{94d}ट\u{94d}रिशियन",
                "प\u{94d}लम\u{94d}बर",
                "म\u{945}कानीक",
                "व\u{947}पारी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("механик"),
            keywords: &["механик"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{ec8}າງ"),
            keywords: &["ຊ\u{ec8}າງ", "ຊ\u{ec8}າງປະປາ", "ຊ\u{ec8}າງໄຟຟ\u{ec9}າ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("remontuojantis žmogus"),
            keywords: &[
                "elektrikas",
                "mechanikas",
                "remontuojantis žmogus",
                "santechnikas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis mehāniķis"),
            keywords: &["elektriķis", "mehāniķis", "santehniķis", "vīrietis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("механичар"),
            keywords: &["водоводџија", "електричар", "занаетчија", "механичар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെക\u{d4d}ക\u{d3e}നിക\u{d4d}ക\u{d4d}"),
            keywords: &["മെക\u{d4d}ക\u{d3e}നിക\u{d4d}ക\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("механик"),
            keywords: &["механик", "сантехникч", "худалдаачин", "цахилгаанчин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{902}त\u{94d}रज\u{94d}ञ"),
            keywords: &[
                "इल\u{947}क\u{94d}ट\u{94d}रिशियन",
                "त\u{902}त\u{94d}रज\u{94d}ञ",
                "प\u{94d}ल\u{902}बर",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mekanik"),
            keywords: &["juruelektrik", "mekanik", "tukang", "tukang paip"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ပြင\u{103a}သ\u{1030}"),
            keywords: &[
                "စက\u{103a}ပြင\u{103a}သ\u{1030}",
                "ပ\u{102d}\u{102f}က\u{103a}ပြင\u{103a}သ\u{1030}",
                "မ\u{102e}းပြင\u{103a}သ\u{1030}",
                "အရောင\u{103a}းအဝယ\u{103a}သမား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mekaniker"),
            keywords: &[
                "bil",
                "elektriker",
                "håndverker",
                "mekaniker",
                "motor",
                "rørlegger",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{947}कानिक"),
            keywords: &[
                "प\u{94d}लम\u{94d}बर",
                "म\u{947}कानिक",
                "विद\u{94d}य\u{941}त\u{94d} कर\u{94d}मचारी",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("monteur"),
            keywords: &["elektricien", "handelsman", "loodgieter", "monteur"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mekanikar"),
            keywords: &[
                "bil",
                "elektrikar",
                "handverkar",
                "mekanikar",
                "motor",
                "røyrleggjar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେକ\u{b3e}ନ\u{b3f}କ"),
            keywords: &[
                "ପ\u{b3e}ଇପ\u{b4d}\u{200c}ମ\u{b3f}ସ\u{b4d}ତ\u{b4d}ରୀ",
                "ବ\u{b3f}ଦ\u{b4d}ୟ\u{b41}ତମ\u{b3f}ସ\u{b4d}ତ\u{b4d}ରୀ",
                "ବ\u{b4d}ୟବସ\u{b3e}ୟୀକ ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ମେକ\u{b3e}ନ\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਸ\u{a3c}ੀਨਸਾਜ\u{a3c}"),
            keywords: &[
                "ਇਲ\u{a48}ਕਟ\u{a4d}ਰੀਸ\u{a3c}ੀਅਨ",
                "ਪਲ\u{a70}ਬਰ",
                "ਮਕ\u{a48}ਨਿਕ",
                "ਮਸ\u{a3c}ੀਨਸਾਜ\u{a3c}",
                "ਵਪਾਰੀ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mẹkánik"),
            keywords: &[
                "Mẹkánik",
                "Plọ\u{301}mba HándWọ\u{301}ka",
                "Ẹlẹ\u{301}ktríshian",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mechanik"),
            keywords: &["elektryk", "hydraulik", "mechanik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مستري"),
            keywords: &["سوداګر", "مستري", "مېخانيک", "پلمبر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mecânico trabalhando"),
            keywords: &[
                "comerciante",
                "eletricista",
                "encanador",
                "mecânico",
                "mecânico trabalhando",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mecânico"),
            keywords: &["canalizador", "eletricista", "mecânico", "ofício"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mecanico"),
            keywords: &["electrico", "mecanico", "plomero", "ranqhaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mecanic"),
            keywords: &["electrician", "instalator", "mecanic", "meseriaș"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-013"),
            keywords: &["E13-013"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("механик"),
            keywords: &["механик", "сантехник", "специалист", "электрик"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مستري"),
            keywords: &["اليڪٽريشن", "مستري", "ٽريڊ پرسن", "پلمبر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}"),
            keywords: &[
                "ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ජල නළ ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("remeselník"),
            keywords: &["elektrikár", "inštalatér", "remeselník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("serviser"),
            keywords: &["električar", "mehanik", "serviser", "trgovec", "vodovodar"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("makaanik"),
            keywords: &["makaanik", "tuubeeyste"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person mekanik"),
            keywords: &[
                "elektricist",
                "hidraulik",
                "mekanik",
                "person mekanik",
                "zanatçi",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("механичар"),
            keywords: &["водоинсталатер", "електричар", "мајстор", "механичар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mehaničar"),
            keywords: &["električar", "majstor", "mehaničar", "vodoinstalater"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mekaniker"),
            keywords: &["elektriker", "mekaniker", "rörmontör"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("makanika"),
            keywords: &["fundi bomba", "fundi umeme", "makanika", "mfanyabiashara"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மெக\u{bcd}க\u{bbe}னிக\u{bcd}"),
            keywords: &[
                "எலக\u{bcd}ட\u{bcd}ர\u{bc0}ஷியன\u{bcd}",
                "பிளம\u{bcd}பர\u{bcd}",
                "மெக\u{bcd}க\u{bbe}னிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}"),
            keywords: &[
                "ఎలక\u{c4d}ట\u{c4d}ర\u{c40}ష\u{c3f}యన\u{c4d}",
                "ప\u{c4d}లంబర\u{c4d}",
                "మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}",
                "వ\u{c4d}య\u{c3e}ప\u{c3e}రవ\u{c47}త\u{c4d}త",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e48}างกล"),
            keywords: &[
                "ช\u{e48}าง",
                "ช\u{e48}างกล",
                "ช\u{e48}างประปา",
                "ช\u{e48}างไฟฟ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mehanik"),
            keywords: &["elektrik", "hünärmen", "mehanik", "santehnik"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻenisia"),
            keywords: &["ʻenisia"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tamirci"),
            keywords: &["elektrikçi", "tamirci", "tesisatçı"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фахівець із механіки"),
            keywords: &[
                "електрик",
                "майстер",
                "механік",
                "сантехнік",
                "фахівець із механіки",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مکینک"),
            keywords: &["الیکٹریشن", "مکینک", "پلمبر", "کاریگر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mexanik"),
            keywords: &["chilangar", "elektrik", "mexanik", "santexnik", "sotuvchi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thợ máy"),
            keywords: &["thợ máy", "thợ sửa ống nước", "thợ thủ công", "thợ điện"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("機械技工"),
            keywords: &["技工", "機械技工", "水喉技工", "電工"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("机械技工"),
            keywords: &["技工", "机械技工", "水喉技工", "电工"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("技工"),
            keywords: &["技工", "水管工", "电工"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("技工"),
            keywords: &["修理", "工人", "師傅", "技工"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umakhenikha"),
            keywords: &[
                "ipulazi",
                "umakhenikha",
                "umlungisi kagesi",
                "umshini",
                "umthengisi",
            ],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🔧"]
pub const MECHANIC_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🔧",
    codepoint: "1F9D1 1F3FB 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "mechanic: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🔧"]
pub const MECHANIC_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🔧",
    codepoint: "1F9D1 1F3FC 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "mechanic: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🔧"]
pub const MECHANIC_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🔧",
    codepoint: "1F9D1 1F3FD 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "mechanic: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🔧"]
pub const MECHANIC_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🔧",
    codepoint: "1F9D1 1F3FE 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "mechanic: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🔧"]
pub const MECHANIC_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🔧",
    codepoint: "1F9D1 1F3FF 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "mechanic: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🔧"]
pub const MAN_MECHANIC: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🔧",
    codepoint: "1F468 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man mechanic",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike motorwerktuigkundige"),
            keywords: &[
                "manlike motorwerktuigkundige",
                "mechanic",
                "moersleutel",
                "motorwerktuigkundige",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ሜካኒክ"),
            keywords: &["ሜካኒክ", "ሰው", "ወንድ", "የቧንቧ ሰራተኛ", "የኤሊክትሪክ ሰራተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ميكانيكي"),
            keywords: &["حرفي", "عامل", "ميكانيكي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ মেক\u{9be}নিক"),
            keywords: &[
                "ইলেক\u{9cd}ট\u{9cd}ৰিচিয\u{9bc}\u{9be}ন",
                "ট\u{9cd}ৰেডপ\u{9be}ৰ\u{9cd}চন",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9cd}ল\u{9be}ম\u{9cd}ব\u{9be}ৰ",
                "মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi mexanik"),
            keywords: &["elektrik", "kişi", "mexanik", "peşəkar", "çilingər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-механік"),
            keywords: &[
                "майстар",
                "механік",
                "мужчына",
                "мужчына-механік",
                "сантэхнік",
                "электрык",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж механик"),
            keywords: &[
                "водопроводчик",
                "електротехник",
                "майстор",
                "механик",
                "мъж",
                "специалист",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলে , প\u{9c1}র\u{9c1}ষ , মেক\u{9be}নিক"),
            keywords: &[
                "ইলেকট\u{9cd}রিশিয\u{9bc}\u{9be}ন",
                "ছেলে",
                "ছেলে , প\u{9c1}র\u{9c1}ষ , মেক\u{9be}নিক",
                "ট\u{9cd}রেডপ\u{9be}র\u{9cd}সন",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9cd}ল\u{9be}ম\u{9cd}ব\u{9be}র",
                "মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mehaničar muškarac"),
            keywords: &[
                "električar",
                "mehaničar",
                "muškarac",
                "trgovac",
                "vodoinstalater",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home mecànic"),
            keywords: &["electricista", "home", "lampista", "masculí", "mecànic"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄇𑄣\u{11128}𑄉\u{11127}𑄢\u{11134}"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄇𑄣\u{11128}𑄉\u{11127}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏙᏆᎴᎷ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᎵᎢᏛᎲᏍᎩ",
                "ᎠᎹ ᏧᏪᏓᏍᏗᎢ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
                "ᎠᏍᎦᏯ",
                "ᎠᏍᎦᏯ ᏙᏆᎴᎷ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏗᎾᎦᎵᏍᎩ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏙᏆᎴᎷ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mechanik"),
            keywords: &[
                "elektrikář",
                "mechanik",
                "montér",
                "muž",
                "opravář",
                "řemeslník",
                "živnostník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("peiriannydd gwrywaidd"),
            keywords: &[
                "dyn",
                "peiriannydd",
                "peiriannydd gwrywaidd",
                "plymwr",
                "trydanwr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig mekaniker"),
            keywords: &[
                "håndværker",
                "mand",
                "mandlig mekaniker",
                "mekaniker",
                "skruenøgle",
                "værktøj",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mechaniker"),
            keywords: &["Elektriker", "Handwerker", "Klempner", "Mechaniker"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας μηχανικός"),
            keywords: &["άντρας", "ηλεκτρολόγος", "μηχανικός", "υδραυλικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man mechanic"),
            keywords: &["electrician", "man", "mechanic", "plumber", "tradesperson"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "electrician",
                "man",
                "mechanic",
                "plumber",
                "tradesman",
                "tradesperson",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la mecánica hombre"),
            keywords: &[
                "electricista",
                "fontanero",
                "hombre",
                "mecánico",
                "operario",
                "profesional de la mecánica hombre",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesmehaanik"),
            keywords: &[
                "elektrik",
                "mees",
                "meesmehaanik",
                "mehaanik",
                "torulukksepp",
                "torumees",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon mekanikaria"),
            keywords: &[
                "elektrikari",
                "gizon",
                "gizon mekanikaria",
                "gizonezko",
                "iturgin",
                "mekarikari",
                "saltzaile",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تعمیرکار مرد"),
            keywords: &[
                "برق\u{200c}کار",
                "تعمیرکار مرد",
                "لوله\u{200c}کش",
                "مکانیک",
                "کارگر",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesmekaanikko"),
            keywords: &[
                "jakoavain",
                "mekaanikko",
                "mies",
                "miesmekaanikko",
                "työkalu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking mekaniko"),
            keywords: &[
                "elektrisyan",
                "lalaki",
                "lalaking mekaniko",
                "makinista",
                "mekaniko",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur mekanikari"),
            keywords: &[
                "elektrikari",
                "mannligur mekanikari",
                "maður",
                "mekanikari",
                "rørsmiður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mécanicien"),
            keywords: &[
                "homme",
                "mécanicien",
                "mécanique",
                "plombier",
                "électricien",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("mécanicien homme"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meicneoir fireann"),
            keywords: &[
                "ceardaí",
                "fear",
                "leictreoir",
                "meicneoir",
                "meicneoir fireann",
                "pluiméir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meacanaig fireann"),
            keywords: &[
                "dealanair",
                "duine",
                "fear",
                "fireannach",
                "meacanaig",
                "meacanaig fireann",
                "neach-ciùird",
                "plumair",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mecánico"),
            keywords: &["electricista", "fontaneiro", "home", "mecánico"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}ક\u{ac5}નિક"),
            keywords: &[
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિશન",
                "કારીગર",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{acd}લમ\u{acd}બર",
                "મ\u{ac7}ક\u{ac5}નિક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum makanika"),
            keywords: &[
                "mai aikin lantarki",
                "mai gyaran famfo",
                "makanika",
                "mutum",
                "ɗan kasuwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונאי"),
            keywords: &[
                "איש",
                "איש מקצוע",
                "גבר",
                "חשמלאי",
                "טכנאי",
                "מכונאי",
                "שרברב",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मिस\u{94d}त\u{94d}री"),
            keywords: &[
                "आदमी",
                "प\u{941}र\u{941}ष",
                "बिजली मिस\u{94d}त\u{94d}री",
                "मिस\u{94d}त\u{94d}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mehaničar"),
            keywords: &["električar", "majstor", "mehaničar", "vodoinstalater"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szerelő"),
            keywords: &["férfi", "szerelő", "villanyszerelő", "vízszerelő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ փականագործ"),
            keywords: &["էլեկտրիկ", "մեխանիկ", "տղամարդ", "փականագործ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("montir pria"),
            keywords: &["laki-laki", "montir pria", "perbaikan", "tukang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke mechanik"),
            keywords: &[
                "mechanik",
                "nwoke",
                "onyeazụmaahịa",
                "ọrụ ngwaọkụ",
                "ọrụụlọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karl með skiptilykil"),
            keywords: &[
                "karl",
                "karl með skiptilykil",
                "verkfæri",
                "viðgerð",
                "viðhald",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("meccanico uomo"),
            keywords: &[
                "chiave inglese",
                "idraulico",
                "meccanico",
                "tecnico specializzato",
                "uomo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性の整備士"),
            keywords: &["スパナ", "メカニック", "工作", "男", "男性", "男性の整備士"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montir lanang"),
            keywords: &[
                "lanang",
                "montir",
                "tukang",
                "tukang ledheng",
                "tukang listrik",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მექანიკოსი კაცი"),
            keywords: &["ელექტრიკი", "კაცი", "მექანიკოსი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер механик"),
            keywords: &["ер", "механик", "сантехник", "электрик"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mekaniker"),
            keywords: &["håndværker", "mand", "mekaniker", "skruenøgle", "værktøj"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជាងម\u{17c9}ាស\u{17ca}\u{17b8}នប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ជាង",
                "ជាងទ\u{17bb}យោ",
                "ជាងភ\u{17d2}លើង",
                "ជាងម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "ជាងម\u{17c9}ាស\u{17ca}\u{17b8}នប\u{17d2}រ\u{17bb}ស",
                "ឈ\u{17d2}ម\u{17bd}ញ",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}"),
            keywords: &[
                "ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಷ\u{cbf}ಯನ\u{ccd}",
                "ಕೊಳಾಯ\u{cbf}ಗಾರ",
                "ಪುರುಷ",
                "ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 정비공"),
            keywords: &["기술자", "남자", "배관공", "수리공", "전기 기사", "정비공"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो म\u{945}कानीक"),
            keywords: &[
                "इल\u{945}क\u{94d}ट\u{94d}रिशियन",
                "दादलो",
                "प\u{94d}लम\u{94d}बर",
                "म\u{945}कानीक",
                "व\u{947}पारी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек механик"),
            keywords: &["механик", "сантехник", "соодагер", "электрик", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mecanicien"),
            keywords: &[
                "Elektriker",
                "Handwierker",
                "Installateur",
                "Mann",
                "Mecanicien",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{ec8}າງກ\u{ebb}ນຊາຍ"),
            keywords: &[
                "ຊ\u{ec8}າງກ\u{ebb}ນຊາຍ",
                "ຊ\u{ec8}າງແປງ",
                "ຊ\u{ec8}າງໄຟ",
                "ຊ\u{ec8}າງໄຟຟ\u{ec9}າ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mechanikas"),
            keywords: &[
                "elektrikas",
                "mechanikas",
                "prekybininkas",
                "santechnikas",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mehāniķis"),
            keywords: &["elektriķis", "mehāniķis", "santehniķis", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaiaka mīhini tāne"),
            keywords: &[
                "kaiaka mīhini",
                "kaiaka mīhini tāne",
                "kaimahi hiko",
                "kaimahi paipa wai",
                "kaimahi-ā-rehe",
                "tāne",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж механичар"),
            keywords: &["електричар", "маж", "механичар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മെക\u{d4d}ക\u{d3e}നിക\u{d4d}"),
            keywords: &[
                "ഇലക\u{d4d}ട\u{d4d}രീഷ\u{d4d}യൻ",
                "പ\u{d4d}ലംബർ",
                "മെക\u{d4d}ക\u{d3e}നിക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй механикч"),
            keywords: &[
                "механик",
                "сантехникч",
                "худалдаачин",
                "цахилгаанчин",
                "эрэгтэй",
                "эрэгтэй механикч",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("य\u{902}त\u{94d}रज\u{94d}ञ"),
            keywords: &[
                "नळकारागीर",
                "प\u{941}र\u{942}ष",
                "य\u{902}त\u{94d}रज\u{94d}ञ",
                "वीजत\u{902}त\u{94d}री",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mekanik lelaki"),
            keywords: &["juruelektrik", "lelaki", "mekanik", "tukang", "tukang paip"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mekkanik maskili"),
            keywords: &[
                "electrician",
                "mekkanik",
                "mekkanik maskili",
                "plumber",
                "raġel",
                "ħaddiem tas-sengħa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား စက\u{103a}ပြင\u{103a}သ\u{1030}"),
            keywords: &[
                "စက\u{103a}ပြင\u{103a}သ\u{1030}",
                "ပ\u{102d}\u{102f}က\u{103a}ဆက\u{103a}သ\u{1030}",
                "မ\u{102e}းသမား",
                "အမျ\u{102d}\u{102f}းသား",
                "အရောင\u{103a}းအဝယ\u{103a}သမား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig mekaniker"),
            keywords: &[
                "bil",
                "elektriker",
                "håndverker",
                "mann",
                "mannlig mekaniker",
                "mekaniker",
                "motor",
                "rørlegger",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष मिस\u{94d}त\u{94d}री"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "प\u{94d}लम\u{94d}बर",
                "बिज\u{941}लीको काम गर\u{94d}न\u{947} व\u{94d}यक\u{94d}ति",
                "मिस\u{94d}त\u{94d}री",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke monteur"),
            keywords: &[
                "elektricien",
                "handelsman",
                "loodgieter",
                "man",
                "mannelijke monteur",
                "monteur",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg mekanikar"),
            keywords: &[
                "bil",
                "elektrikar",
                "handverkar",
                "mann",
                "mannleg mekanikar",
                "mekanikar",
                "motor",
                "røyrleggjar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ମେକ\u{b3e}ନ\u{b3f}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ଇଲେକ\u{b4d}ଟ\u{b4d}ର\u{b3f}ସ\u{b3f}ଆନ\u{b4d}\u{200c}",
                "ପ\u{b3e}ଇପ\u{b4d}\u{200c} ମ\u{b3f}ସ\u{b4d}ତ\u{b4d}ରୀ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ବ\u{b4d}ୟବସ\u{b3e}ୟୀ",
                "ମେକ\u{b3e}ନ\u{b3f}କ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਕ\u{a48}ਨਿਕ"),
            keywords: &[
                "ਇਲ\u{a48}ਕਟ\u{a4d}ਰਿਸ\u{a3c}ਨ",
                "ਪਲ\u{a70}ਬਰ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਮਕ\u{a48}ਨਿਕ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد مکینک"),
            keywords: &[
                "الیکٹریشن",
                "بندہ",
                "تربیت یافتہ مزدور",
                "مرد مکینک",
                "مکینک",
                "پلمبر",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Mẹkánik"),
            keywords: &[
                "Man",
                "Mán Mẹkánik",
                "Mẹkánik",
                "Plọ\u{301}mba Hándwọ\u{301}ka",
                "Ẹlẹ\u{301}ktríshian",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna elektryk"),
            keywords: &["elektryk", "hydraulik", "mechanik", "mężczyzna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی مستري"),
            keywords: &["تجار", "سړی", "مستري", "ميخانيک", "پلمبر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mecânico"),
            keywords: &[
                "eletricista",
                "encanador",
                "homem",
                "mecânico",
                "prestador de serviços",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mecânico (homem)"),
            keywords: &[
                "canalizador",
                "electricista",
                "eletricista",
                "homem",
                "mecânico",
                "mecânico (homem)",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata mecanico"),
            keywords: &["electrico", "mecanico", "plomero", "ranqhaq", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mecanic bărbat"),
            keywords: &["bărbat", "electrician", "instalator", "mecanic", "meșter"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1170"),
            keywords: &["E10-1170"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-механик"),
            keywords: &[
                "механик",
                "мужчина",
                "мужчина-механик",
                "сантехник",
                "электрик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’umukanishi"),
            keywords: &[
                "inzobere mu mwuga",
                "kanyamashanyazi",
                "kanyamigezi",
                "umugabo",
                "umugabo w’umukanishi",
                "umukanishi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد مستري"),
            keywords: &["مرد مستري", "مرد، واپاري، مستري، پلمبر، اليڪٽريشن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}"),
            keywords: &[
                "ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ගන\u{dd4}දෙන\u{dd4} ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "ජල නළ ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} ශ\u{dd2}ල\u{dca}ප\u{dd2}ය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("remeselník muž"),
            keywords: &["elektrikár", "inštalatér", "muž", "remeselník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mehanik"),
            keywords: &[
                "avtomehanik",
                "električar",
                "fant",
                "mehanik",
                "mehanična delavnica",
                "moški",
                "orodje",
                "prodajalec",
                "vodovodar",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin makaanik ah"),
            keywords: &[
                "dhuumo yaqaan",
                "ganacsade",
                "koronto yaqaan",
                "makaanik",
                "nin",
                "nin makaanik ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mekanik"),
            keywords: &["burrë", "elektricist", "hidraulik", "mekanik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац механичар"),
            keywords: &["алат", "мајстор", "механичар", "мушкарац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушкарац механичар"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac mehaničar"),
            keywords: &["alat", "majstor", "mehaničar", "muškarac"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muškarac mehaničar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig mekaniker"),
            keywords: &[
                "bil",
                "elektriker",
                "man",
                "manlig mekaniker",
                "mekaniker",
                "motor",
                "rörmokare",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fundi mitambo wa kiume"),
            keywords: &[
                "fundi gari",
                "fundi mitambo wa kiume",
                "mekanika",
                "mwanamume",
                "spana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} மெக\u{bcd}க\u{bbe}னிக\u{bcd}"),
            keywords: &["ஆண\u{bcd}", "மெக\u{bcd}க\u{bbe}னிக\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మగ మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}"),
            keywords: &[
                "ఎలక\u{c4d}ట\u{c4d}ర\u{c40}ష\u{c3f}యన\u{c4d}",
                "పురుషుడు",
                "ప\u{c4d}లంబర\u{c4d}",
                "మగ మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}",
                "మగ\u{c3e}డు",
                "మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}",
                "వ\u{c4d}య\u{c3e}ప\u{c3e}రవ\u{c47}త\u{c4d}త",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди механик"),
            keywords: &[
                "водопроводчӣ",
                "мард",
                "марди механик",
                "механик",
                "савдогар",
                "устои барқ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e48}างซ\u{e48}อมชาย"),
            keywords: &[
                "ช\u{e48}าง",
                "ช\u{e48}างกล",
                "ช\u{e48}างซ\u{e48}อมชาย",
                "ช\u{e48}างประปา",
                "ช\u{e48}างไฟฟ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek mehanik"),
            keywords: &["elektrik", "erkek", "mehanik", "santehnik", "söwdagär"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻenisinia tangata"),
            keywords: &["ʻenisinia tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek tamirci"),
            keywords: &[
                "adam",
                "elektrikçi",
                "erkek",
                "esnaf",
                "tamirci",
                "tesisatçı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر رېمونتچى"),
            keywords: &["ئەر", "توكچى", "تۇرۇبا ئىشچىسى", "رېمونتچى", "سودىگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("механік"),
            keywords: &[
                "водопровідник",
                "електрик",
                "електротехнік",
                "механік",
                "фахівець",
                "чоловік",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد مکینک"),
            keywords: &["الیکٹریشن", "مرد", "مکینک", "کاریگر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak mexanik"),
            keywords: &[
                "elektrik",
                "erkak mexanik",
                "hunarmand",
                "mexanik",
                "santexnik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thợ máy nam"),
            keywords: &[
                "cơ khí",
                "nam",
                "người đàn ông",
                "thợ",
                "thợ máy nam",
                "thợ sửa ống nước",
                "thợ điện",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mekaniyee bu góor"),
            keywords: &[
                "elektrisiyee",
                "góor",
                "jaaykat",
                "mekanisee",
                "mekaniyee bu góor",
                "plombiyee",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umkhandi oyindoda"),
            keywords: &[
                "incutshe yombane",
                "indoda",
                "umkhandi",
                "umkhandi oyindoda",
                "umntu ongumrhwebi",
                "umtywini",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin atún ọkọ\u{300} ṣe"),
            keywords: &[
                "atún ináṣe",
                "atún ọkọ\u{300} ṣe",
                "pílọ\u{301}bà",
                "ẹni ṣòwò",
                "ọkùnrin",
                "ọkùnrin atún ọkọ\u{300} ṣe",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男技工"),
            keywords: &["商人", "技工", "水管工人", "男", "男技工", "電工"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男技工"),
            keywords: &["商人", "技工", "水管工人", "电工", "男", "男技工"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男技工"),
            keywords: &["技工", "水管工", "电工", "男", "男技工"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男技工"),
            keywords: &["技工", "機械技師", "男", "男技工", "黑手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umakhenikha wesilisa"),
            keywords: &[
                "indoda",
                "odayisayo",
                "umakhenikha",
                "umakhenikha wesilisa",
                "umkhandi kagesi",
                "uplamba",
            ],
        },
    ],
};
#[doc = "👨🏻\u{200d}🔧"]
pub const MAN_MECHANIC_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🔧",
    codepoint: "1F468 1F3FB 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man mechanic: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🔧"]
pub const MAN_MECHANIC_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🔧",
    codepoint: "1F468 1F3FC 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man mechanic: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🔧"]
pub const MAN_MECHANIC_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🔧",
    codepoint: "1F468 1F3FD 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man mechanic: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🔧"]
pub const MAN_MECHANIC_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🔧",
    codepoint: "1F468 1F3FE 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man mechanic: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🔧"]
pub const MAN_MECHANIC_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🔧",
    codepoint: "1F468 1F3FF 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man mechanic: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🔧"]
pub const WOMAN_MECHANIC: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🔧",
    codepoint: "1F469 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman mechanic",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike motorwerktuigkundige"),
            keywords: &[
                "mechanic",
                "moersleutel",
                "motorwerktuigkundige",
                "vroulike motorwerktuigkundige",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ሜካኒክ"),
            keywords: &["ሜካኒክ", "ሰው", "ሴት", "የቧንቧ ሰራተኛ", "የኤሊክትሪክ ሰራተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ميكانيكية"),
            keywords: &["حرفية", "عاملة", "ميكانيكية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} মেক\u{9be}নিক"),
            keywords: &[
                "ইলেক\u{9cd}ট\u{9cd}ৰিচিয\u{9bc}\u{9be}ন",
                "ট\u{9cd}ৰেডপ\u{9be}ৰ\u{9cd}চন",
                "প\u{9cd}ল\u{9be}ম\u{9cd}ব\u{9be}ৰ",
                "মহিল\u{9be}",
                "মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın mexanik"),
            keywords: &["elektrik", "mexanik", "peşəkar", "qadın", "çilingər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына-механік"),
            keywords: &[
                "жанчына",
                "жанчына-механік",
                "майстрыха",
                "механік",
                "сантэхнік",
                "электрык",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена механик"),
            keywords: &["жена механик", "майсторка", "специалистка", "техник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}ে , মহিল\u{9be} , মেক\u{9be}নিক"),
            keywords: &[
                "ইলেকট\u{9cd}রিশিয\u{9bc}\u{9be}ন",
                "ট\u{9cd}রেডপ\u{9be}র\u{9cd}সন",
                "প\u{9cd}ল\u{9be}ম\u{9cd}ব\u{9be}র",
                "মহিল\u{9be}",
                "মেক\u{9be}নিক",
                "মেয\u{9bc}ে , মহিল\u{9be} , মেক\u{9be}নিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mehaničarka"),
            keywords: &[
                "električarka",
                "mehaničarka",
                "trgovkinja",
                "vodoinstalaterka",
                "žena",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mecànica"),
            keywords: &["dona", "electricista", "femení", "lampista", "mecànica"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄇𑄣\u{11128}𑄉\u{11127}𑄢\u{11134}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄇𑄣\u{11128}𑄉\u{11127}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏙᏆᎴᎷ ᎣᏍᏓ ᏱᏗᎬᏁᎯ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᏙᏆᎴᎷ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
                "ᎠᎵᎢᏛᎲᏍᎩ",
                "ᎠᎹ ᏧᏪᏓᏍᏗᎢ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
                "ᎠᎾᎦᎵᏍᎩ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏙᏆᎴᎷ ᎣᏍᏓ ᏱᏗᎬᏁᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mechanička"),
            keywords: &[
                "elektrikářka",
                "mechanička",
                "montérka",
                "opravářka",
                "řemeslnice",
                "žena",
                "živnostnice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("peiriannydd benywaidd"),
            keywords: &["benywaidd", "peiriannydd", "plymio", "trydanwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig mekaniker"),
            keywords: &[
                "håndværker",
                "kvinde",
                "kvindelig mekaniker",
                "mekaniker",
                "skruenøgle",
                "værktøj",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mechanikerin"),
            keywords: &["Elektrikerin", "Handwerkerin", "Klempnerin", "Mechanikerin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα μηχανικός"),
            keywords: &["γυναίκα", "ηλεκτρολόγος", "μηχανικός", "υδραυλικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman mechanic"),
            keywords: &[
                "electrician",
                "mechanic",
                "plumber",
                "tradesperson",
                "woman",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "electrician",
                "mechanic",
                "plumber",
                "tradesperson",
                "tradeswoman",
                "woman",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la mecánica mujer"),
            keywords: &[
                "electricista",
                "fontanera",
                "mecánica",
                "mujer",
                "operaria",
                "profesional de la mecánica mujer",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naismehaanik"),
            keywords: &[
                "elektrik",
                "mehaanik",
                "naine",
                "naismehaanik",
                "torulukksepp",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume mekanikaria"),
            keywords: &[
                "elektrikari",
                "emakume",
                "emakume mekanikaria",
                "emakumezko",
                "iturgin",
                "saltzaile",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تعمیرکار زن"),
            keywords: &[
                "برق\u{200c}کار",
                "تعمیرکار زن",
                "لوله\u{200c}کش",
                "مکانیک",
                "کارگر",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naismekaanikko"),
            keywords: &[
                "jakoavain",
                "mekaanikko",
                "nainen",
                "naismekaanikko",
                "työkalu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng mekaniko"),
            keywords: &[
                "babae",
                "babaeng mekaniko",
                "elektrisyan",
                "makinista",
                "mekaniko",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur mekanikari"),
            keywords: &[
                "elektrikari",
                "kona",
                "kvinna",
                "kvinnuligur mekanikari",
                "mekanikari",
                "rørsmiður",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mécanicienne"),
            keywords: &[
                "femme",
                "mécanicienne",
                "mécanique",
                "plombier",
                "électricienne",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("meicneoir baineann"),
            keywords: &[
                "bean",
                "ceardaí",
                "leictreoir",
                "meicneoir",
                "meicneoir baineann",
                "pluiméir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("meacanaig boireann"),
            keywords: &[
                "boireannach",
                "dealanair",
                "meacanaig",
                "meacanaig boireann",
                "neach-ciùird",
                "plumair",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mecánica"),
            keywords: &["electricista", "fontaneira", "mecánica", "muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી મ\u{ac7}ક\u{ac5}નિક"),
            keywords: &[
                "ઇલ\u{ac7}ક\u{acd}ટ\u{acd}રિશન",
                "પ\u{acd}લમ\u{acd}બર",
                "મ\u{ac7}ક\u{ac5}નિક",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace makanika"),
            keywords: &[
                "mace",
                "mai aikin lantarki",
                "mai gyaran famfo",
                "makanika",
                "‘yar kasuwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכונאית"),
            keywords: &["אישה", "אשת מקצוע", "חשמלאית", "טכנאית", "מכונאית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला मिस\u{94d}त\u{94d}री"),
            keywords: &[
                "प\u{94d}लम\u{94d}बर",
                "महिला",
                "मिस\u{94d}त\u{94d}री",
                "म\u{948}क\u{947}निक",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mehaničarka"),
            keywords: &[
                "električarka",
                "majstorica",
                "mehaničarka",
                "vodoinstalaterka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szerelőnő"),
            keywords: &["nő", "szerelő", "szerelőnő", "villanyszerelő", "vízszerelő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին փականագործ"),
            keywords: &["էլեկտրիկ", "կին", "մեխանիկ", "փականագործ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("montir wanita"),
            keywords: &["montir wanita", "perbaikan", "perempuan", "tukang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị mechanik"),
            keywords: &[
                "mechanik",
                "nwanyị",
                "onyeazụmaahịa",
                "ọrụ ngwaọkụ",
                "ọrụụlọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona með skiptilykil"),
            keywords: &[
                "kona",
                "kona með skiptilykil",
                "verkfæri",
                "viðgerð",
                "viðhald",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("meccanico donna"),
            keywords: &[
                "chiave inglese",
                "donna",
                "idraulico donna",
                "meccanico",
                "tecnico specializzato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性の整備士"),
            keywords: &["スパナ", "メカニック", "女", "女性", "女性の整備士", "工作"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("montir wadon"),
            keywords: &[
                "montir",
                "tukang",
                "tukang ledheng",
                "tukang listrik",
                "wadon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მექანიკოსი ქალი"),
            keywords: &["ელექტრიკი", "მექანიკოსი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("механик әйел"),
            keywords: &["механик", "сантехник", "электрик", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig mekaniker"),
            keywords: &[
                "håndværker",
                "kvinde",
                "kvindelig mekaniker",
                "mekaniker",
                "skruenøgle",
                "værktøj",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជាងម\u{17c9}ាស\u{17ca}\u{17b8}នស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ជាង",
                "ជាងទ\u{17bb}យោ",
                "ជាងភ\u{17d2}លើង",
                "ជាងម\u{17c9}ាស\u{17ca}\u{17b8}ន",
                "ជាងម\u{17c9}ាស\u{17ca}\u{17b8}នស\u{17d2}រ\u{17b8}",
                "ឈ\u{17d2}ម\u{17bd}ញ",
                "នារ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳಾ ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}"),
            keywords: &[
                "ಎಲ\u{cc6}ಕ\u{ccd}ಟ\u{ccd}ರ\u{cbf}ಷ\u{cbf}ಯನ\u{ccd}",
                "ಮಹ\u{cbf}ಳಾ ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}",
                "ಮ\u{cc6}ಕ\u{ccd}ಯಾನ\u{cbf}ಕ\u{ccd}",
                "ವಹ\u{cbf}ವಾಟು ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 정비공"),
            keywords: &["기술자", "배관공", "수리공", "여자", "전기 기사", "정비공"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल म\u{945}कानीक"),
            keywords: &[
                "इल\u{945}क\u{94d}ट\u{94d}रिशियन",
                "प\u{94d}लम\u{94d}बर",
                "बायल",
                "म\u{945}कानीक",
                "व\u{947}पारी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял механик"),
            keywords: &["аял", "механик", "сантехник", "соодагер", "электрик"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mecanicienne"),
            keywords: &[
                "Elektrikerin",
                "Fra",
                "Handwierkerin",
                "Installatrice",
                "Mecanicienne",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{ec8}າງກ\u{ebb}ນຍ\u{eb4}ງ"),
            keywords: &[
                "ຊ\u{ec8}າງກ\u{ebb}ນຍ\u{eb4}ງ",
                "ຊ\u{ec8}າງແປງ",
                "ຊ\u{ec8}າງໄຟ",
                "ຊ\u{ec8}າງໄຟຟ\u{ec9}າ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mechanikė"),
            keywords: &[
                "elektrikė",
                "mechanikė",
                "moteris",
                "prekybininkė",
                "santechnikė",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mehāniķe"),
            keywords: &["elektriķe", "mehāniķe", "santehniķe", "sieviete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaiaka mīhini wahine"),
            keywords: &[
                "kaiaka mīhini",
                "kaiaka mīhini wahine",
                "kaimahi hiko",
                "kaimahi paipa wai",
                "kaimahi-ā-rehe",
                "wahine",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("механичарка"),
            keywords: &["електричар", "жена", "механичар", "механичарка"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വനിത\u{d3e} മെക\u{d4d}ക\u{d3e}നിക\u{d4d}"),
            keywords: &[
                "പ\u{d4d}ലംബർ",
                "മെക\u{d4d}ക\u{d3e}നിക\u{d4d}",
                "വനിത\u{d3e} ഇലക\u{d4d}ട\u{d4d}രീഷ\u{d4d}യൻ",
                "വനിത\u{d3e} മെക\u{d4d}ക\u{d3e}നിക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй механикч"),
            keywords: &[
                "механикч",
                "сантехникч",
                "худалдаачин",
                "цахилгаанчин",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला य\u{902}त\u{94d}रज\u{94d}ञ"),
            keywords: &[
                "नळकारागीर",
                "महिला",
                "य\u{902}त\u{94d}रज\u{94d}ञ",
                "वीजत\u{902}त\u{94d}री",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mekanik wanita"),
            keywords: &[
                "juruelektrik",
                "mekanik",
                "perempuan",
                "tukang",
                "tukang paip",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mekkanik mara"),
            keywords: &[
                "electrician",
                "mara",
                "mekkanik",
                "plumber",
                "ħaddiem tas-sengħa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း စက\u{103a}ပြင\u{103a}သ\u{1030}"),
            keywords: &[
                "စက\u{103a}ပြင\u{103a}သ\u{1030}",
                "ပ\u{102d}\u{102f}က\u{103a}ဆက\u{103a}သ\u{1030}",
                "မ\u{102e}းသမား",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း စက\u{103a}ပြင\u{103a}သ\u{1030}",
                "အမျ\u{102d}\u{102f}းသား",
                "အရောင\u{103a}းအဝယ\u{103a}သမား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig mekaniker"),
            keywords: &[
                "bil",
                "elektriker",
                "håndverker",
                "kvinne",
                "kvinnelig mekaniker",
                "mekaniker",
                "motor",
                "rørlegger",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला मिस\u{94d}त\u{94d}री"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "प\u{94d}लम\u{94d}बर",
                "बिज\u{941}\u{941}लीको काम गर\u{94d}न\u{947} व\u{94d}यक\u{94d}ति",
                "महिला",
                "मिस\u{94d}त\u{94d}री",
                "व\u{94d}यापारी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("monteuse"),
            keywords: &[
                "elektricien",
                "handelsvrouw",
                "loodgieter",
                "monteuse",
                "vrouw",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg mekanikar"),
            keywords: &[
                "bil",
                "elektrikar",
                "handverkar",
                "kvinne",
                "kvinneleg mekanikar",
                "mekanikar",
                "motor",
                "røyrleggjar",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ମେକ\u{b3e}ନ\u{b3f}କ\u{b4d}\u{200c}"),
            keywords: &[
                "ଇଲେକ\u{b4d}ଟ\u{b4d}ର\u{b3f}ସ\u{b3f}ଆନ\u{b4d}\u{200c}",
                "ପ\u{b3e}ଇପ\u{b4d}\u{200c} ମ\u{b3f}ସ\u{b4d}ତ\u{b4d}ରୀ",
                "ବ\u{b4d}ୟବସ\u{b3e}ୟୀ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମେକ\u{b3e}ନ\u{b3f}କ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਮਕ\u{a48}ਨਿਕ"),
            keywords: &[
                "ਇਲ\u{a48}ਕਟ\u{a4d}ਰਿਸ\u{a3c}ਨ",
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਮਕ\u{a48}ਨਿਕ",
                "ਔਰਤ",
                "ਪਲ\u{a70}ਬਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مکینک زنانی"),
            keywords: &["الیکٹریشن", "تربیت یافتہ مزدور", "زنانی", "مکینک", "پلمبر"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Mẹkánik"),
            keywords: &[
                "Mẹkánik",
                "Plọ\u{301}mba Hándwọ\u{301}ka",
                "Wúman",
                "Wúmán Mẹkánik",
                "Ẹlẹ\u{301}ktríshian",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta elektryk"),
            keywords: &["elektryk", "hydraulik", "kobieta", "mechanik"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه مستري"),
            keywords: &["تجار", "مستري", "ميخانيک", "پلمبر", "ښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mecânica"),
            keywords: &[
                "eletricista",
                "encanadora",
                "mecânica",
                "mulher",
                "prestadora de serviços",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "canalizadora",
                "electricista",
                "eletricista",
                "mecânica",
                "mulher",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi mecanico"),
            keywords: &["electrico", "mecanico", "plomero", "ranqhaq", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mecanic femeie"),
            keywords: &[
                "electriciană",
                "femeie",
                "instalatoare",
                "mecanic",
                "meșter",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1186"),
            keywords: &["E10-1186"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-механик"),
            keywords: &[
                "женщина",
                "женщина-механик",
                "механик",
                "сантехник",
                "электрик",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore w’umukanishi"),
            keywords: &[
                "inzobere mu mwuga",
                "kanyamashanyazi",
                "kanyamigezi",
                "umugore",
                "umugore w’umukanishi",
                "umukanishi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت مستري"),
            keywords: &["عورت مستري", "عورت واپاري، مستري، پلمبر، اليڪٽريشن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ර\u{dca}ම\u{dd2}කවර\u{dd2}ය"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ක\u{dcf}ර\u{dca}ම\u{dd2}කවර\u{dd2}ය",
                "ගන\u{dd4}දෙන\u{dd4} ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "ජල නළ ක\u{dcf}ර\u{dca}ම\u{dd2}කය\u{dcf}",
                "ව\u{dd2}ද\u{dd4}ල\u{dd2} ශ\u{dd2}ල\u{dca}ප\u{dd2}ණ\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("remeselníčka"),
            keywords: &["elektrikárka", "inštalatérka", "remeselníčka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mehaničarka"),
            keywords: &[
                "avtomehaničarka",
                "dekle",
                "električarka",
                "mehaničarka",
                "mehanična delavnica",
                "orodje",
                "prodajalka",
                "vodovodarka",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag makaanikad ah"),
            keywords: &[
                "dhuumo yaqaan",
                "ganacsade",
                "koronto yaqaan",
                "makaanik",
                "naag",
                "naag makaanikad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mekanike"),
            keywords: &["burrë", "elektriciste", "hidraulike", "mekanike"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("механичарка"),
            keywords: &["алат", "жена", "мајстор", "механичарка"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mehaničarka"),
            keywords: &["alat", "majstor", "mehaničarka", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig mekaniker"),
            keywords: &["bil", "kvinna", "kvinnlig mekaniker", "mekaniker", "motor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("fundi mitambo wa kike"),
            keywords: &[
                "fundi bomba",
                "fundi mitambo wa kike",
                "mekanika",
                "mwanamke",
                "spana",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} மெக\u{bcd}க\u{bbe}னிக\u{bcd}"),
            keywords: &["பெண\u{bcd}", "மெக\u{bcd}க\u{bbe}னிக\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడ మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}"),
            keywords: &[
                "ఆడ మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}",
                "ఎలక\u{c4d}ట\u{c4d}ర\u{c40}ష\u{c3f}యన\u{c4d}",
                "ప\u{c4d}లంబర\u{c4d}",
                "మహ\u{c3f}ళ",
                "మ\u{c46}క\u{c3e}న\u{c3f}క\u{c4d}",
                "వ\u{c4d}య\u{c3e}ప\u{c3e}రవ\u{c47}త\u{c4d}త",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани механик"),
            keywords: &[
                "водопроводчӣ",
                "зан",
                "зани механик",
                "механик",
                "савдогар",
                "устои барқ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e48}างซ\u{e48}อมหญ\u{e34}ง"),
            keywords: &[
                "ช\u{e48}าง",
                "ช\u{e48}างกล",
                "ช\u{e48}างซ\u{e48}อมหญ\u{e34}ง",
                "ช\u{e48}างประปา",
                "ช\u{e48}างไฟฟ\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan mehanik"),
            keywords: &["elektrik", "mehanik", "santehnik", "söwdagär", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻenisinia fefine"),
            keywords: &["ʻenisinia fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın tamirci"),
            keywords: &[
                "bayan",
                "elektrikçi",
                "esnaf",
                "kadın",
                "tamirci",
                "tesisatçı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال رېمونتچى"),
            keywords: &["ئايال", "توكچى", "تۇرۇبا ئىشچىسى", "رېمونتچى", "سودىگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-механік"),
            keywords: &[
                "жінка-електротехнік",
                "жінка-механік",
                "жінка-сантехнік",
                "жінка-фахівець",
                "майстриня",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت مکینک"),
            keywords: &["الیکٹریشن", "عورت مکینک", "مرد", "مکینک", "کاریگر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol mexanik"),
            keywords: &["ayol", "elektrik", "hunarmand", "mexanik", "santexnik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thợ máy nữ"),
            keywords: &[
                "cơ khí",
                "nữ",
                "phụ nữ",
                "thợ",
                "thợ máy nữ",
                "thợ sửa ống nước",
                "thợ điện",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen mekanik"),
            keywords: &["electrisiyee", "jaaykat", "jigéen", "mekanik", "plumber"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umkhandi olibhinqa"),
            keywords: &[
                "ibhinqa",
                "incutshe yombane",
                "umkhandi",
                "umkhandi olibhinqa",
                "umntu ongumrhwebi",
                "umtywini",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrin atún ọkọ\u{300} ṣe"),
            keywords: &[
                "atún ináṣe",
                "atún ọkọ\u{300} ṣe",
                "obìrin",
                "obìrin atún ọkọ\u{300} ṣe",
                "pílọ\u{301}bà",
                "ẹni ṣòwò",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女技工"),
            keywords: &["商人", "女", "女技工", "技工", "水管工人", "電工"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女技工"),
            keywords: &["商人", "女", "女技工", "技工", "水管工人", "电工"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女技工"),
            keywords: &["女", "女技工", "技工", "水管工", "电工"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女技工"),
            keywords: &["女", "女技工", "技工", "機械技師", "黑手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umakhenikha wesimame"),
            keywords: &[
                "odayisayo",
                "owesifazane",
                "umakhenikha",
                "umakhenikha wesimame",
                "umkhandi kagesi",
                "uplamba",
            ],
        },
    ],
};
#[doc = "👩🏻\u{200d}🔧"]
pub const WOMAN_MECHANIC_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🔧",
    codepoint: "1F469 1F3FB 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman mechanic: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🔧"]
pub const WOMAN_MECHANIC_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🔧",
    codepoint: "1F469 1F3FC 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman mechanic: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🔧"]
pub const WOMAN_MECHANIC_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🔧",
    codepoint: "1F469 1F3FD 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman mechanic: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🔧"]
pub const WOMAN_MECHANIC_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🔧",
    codepoint: "1F469 1F3FE 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman mechanic: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🔧"]
pub const WOMAN_MECHANIC_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🔧",
    codepoint: "1F469 1F3FF 200D 1F527",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman mechanic: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🏭"]
pub const FACTORY_WORKER: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🏭",
    codepoint: "1F9D1 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "factory worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("fabriekswerker"),
            keywords: &[
                "fabriek",
                "fabriekswerker",
                "industrieel",
                "montering",
                "nywerheid",
                "werker",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የፋብሪካ ሰራተኛ"),
            keywords: &["የፋብሪካ ሰራተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عامل في مصنع"),
            keywords: &["تجميع", "صناعة", "عامل", "عامل في مصنع", "مصنع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফেক\u{9cd}টৰীৰ কৰ\u{9cd}মী"),
            keywords: &[
                "উদ\u{9cd}যোগিক",
                "কৰ\u{9cd}মী",
                "ফেক\u{9cd}টৰী",
                "ফেক\u{9cd}টৰীৰ কৰ\u{9cd}মী",
                "বৈঠক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("fabrik işçisi"),
            keywords: &["fabrik", "fabrik işçisi", "işçi", "sənaye", "yığım"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("завадчанін"),
            keywords: &["завадчанін", "завод", "мужчына", "прамыслоўца", "працаўнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("работник във фабрика"),
            keywords: &[
                "завод",
                "индустрия",
                "производство",
                "промишленост",
                "работник",
                "работник във фабрика",
                "фабрика",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}রখ\u{9be}ন\u{9be}র কর\u{9cd}মী"),
            keywords: &[
                "কর\u{9cd}মী",
                "ক\u{9be}রখ\u{9be}ন\u{9be}",
                "ক\u{9be}রখ\u{9be}ন\u{9be}র কর\u{9cd}মী",
                "শিল\u{9cd}প",
                "সম\u{9be}গম",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("radnik u fabrici"),
            keywords: &[
                "fabrika",
                "industrija",
                "montaža",
                "radnik",
                "radnik u fabrici",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("operari"),
            keywords: &["fàbrica", "industrial", "operari", "treballador"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᎸᏫᏍᏓᏁᏗ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᏂᎦᏓ ᏚᏂᎸᏫᏍᏓᏁᎲᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᎤᏙᎴᏒᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᏚᏙᏢᏒᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏧᎸᏫᏍᏓᏁᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba pracující v továrně"),
            keywords: &[
                "dělnice",
                "dělník",
                "osoba pracující v továrně",
                "průmysl",
                "továrna",
                "výroba",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n gweithio mewn ffatri"),
            keywords: &[
                "diwydiannol",
                "ffatri",
                "gweithiwr",
                "person sy’n gweithio mewn ffatri",
                "rhes gydosod",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fabriksarbejder"),
            keywords: &[
                "arbejder",
                "fabrik",
                "fabriksarbejder",
                "industri",
                "samlebånd",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fabrikarbeiter(in)"),
            keywords: &[
                "Arbeiter",
                "Fabrik",
                "Fabrikarbeiter(in)",
                "Montage",
                "industriell",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Fabrikarbeiter(in)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργάτης εργοστασίου"),
            keywords: &[
                "βιομηχανικό",
                "εργάτης εργοστασίου",
                "εργαζόμενος",
                "εργοστάσιο",
                "συναρμολόγηση",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("factory worker"),
            keywords: &["assembly", "factory", "industrial", "worker"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional industrial"),
            keywords: &[
                "fábrica",
                "montaje",
                "obrero",
                "operario",
                "profesional industrial",
                "trabajador",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("obrero de fábrica"),
            keywords: &["obrero de fábrica"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["fábrica", "montaje", "profesional industrial"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tehasetööline"),
            keywords: &["liinitööline", "tehas", "tehasetööline", "tööline"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fabrikako langilea"),
            keywords: &[
                "fabrika",
                "fabrikako langilea",
                "industria",
                "langile",
                "mihiztatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارگر کارخانه"),
            keywords: &["صنعتی", "مونتاژ", "کارخانه", "کارگر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tehdastyöntekijä"),
            keywords: &[
                "kokoaminen",
                "tehdas",
                "tehdastyöntekijä",
                "teollisuus",
                "työntekijä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trabahador sa pabrika"),
            keywords: &[
                "industriyal",
                "pabrika",
                "pag-assemble",
                "trabahador",
                "trabahador sa pabrika",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sveisari"),
            keywords: &["arbeiðsfólk", "sj´óðari", "sveisari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ouvrier (tous genres)"),
            keywords: &[
                "assemblage",
                "industrie",
                "ouvrier",
                "ouvrier (tous genres)",
                "ouvrière",
                "usine",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("travailleur d’usine"),
            keywords: &[
                "assemblage",
                "industrie",
                "ouvrier",
                "ouvrier (tous genres)",
                "ouvrière",
                "travailleur d’usine",
                "usine",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí monarchan"),
            keywords: &["oibrí monarchan"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach-obrach factaraidh"),
            keywords: &[
                "factaraidh",
                "gnìomhachas",
                "neach-obrach",
                "obraiche",
                "tional",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("traballador de fábrica"),
            keywords: &[
                "fábrica",
                "obreiro",
                "operario",
                "traballador",
                "traballador de fábrica",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac5}ક\u{acd}ટરી કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "એસ\u{ac7}મ\u{acd}બલી",
                "ઔદ\u{acd}યોગિક",
                "કાર\u{acd}યકર\u{acd}તા",
                "ફ\u{ac5}ક\u{acd}ટરી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פועל/ת"),
            keywords: &["בית חרושת", "מפעל", "פועל", "פועל/ת", "פועלת", "תעשייה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{93c}\u{948}क\u{94d}ट\u{94d}री मज\u{93c}द\u{942}र"),
            keywords: &[
                "औद\u{94d}योगिक",
                "कारखाना",
                "फ\u{93c}\u{948}क\u{94d}ट\u{94d}री मज\u{93c}द\u{942}र",
                "मज\u{93c}द\u{942}र",
                "सभा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("radnik u tvornici"),
            keywords: &[
                "industrija",
                "radnik",
                "radnik u tvornici",
                "traka",
                "tvornica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("munkás"),
            keywords: &["dolgozó", "gyári", "munkás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բանվոր"),
            keywords: &["աշխատող", "արդյունաբերություն", "բանվոր", "գործարան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja pabrik"),
            keywords: &["industri", "pabrik", "pekerja", "perakitan"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("verksmiðjustarfsmaður"),
            keywords: &[
                "fjöldaframleiðsla",
                "iðnaður",
                "starfsmaður",
                "verksmiðja",
                "verksmiðjustarfsmaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che lavora in fabbrica"),
            keywords: &[
                "assemblaggio",
                "fabbrica",
                "industria",
                "operaio",
                "persona che lavora in fabbrica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("溶接工"),
            keywords: &["モノづくり", "工員", "工場", "溶接工"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buruh pabrik"),
            keywords: &["buruh", "industri", "karoseri", "pabrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქარხნის მუშა"),
            keywords: &["აწყობა", "ინდუსტრია", "მუშა", "ქარხანა", "ქარხნის მუშა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("зауыт жұмысшысы"),
            keywords: &[
                "жұмысшы",
                "зауыт",
                "зауыт жұмысшысы",
                "құрастыру",
                "өнеркәсіп",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កម\u{17d2}មកររោងចក\u{17d2}រ"),
            keywords: &[
                "កម\u{17d2}មករ",
                "កម\u{17d2}មកររោងចក\u{17d2}រ",
                "ការដ\u{17c6}ឡើង",
                "រោងចក\u{17d2}រ",
                "ឧស\u{17d2}សាហកម\u{17d2}ម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಖಾನ\u{cc6} ಕ\u{cc6}ಲಸಗಾರ"),
            keywords: &[
                "ಕಾರ\u{ccd}ಖಾನ\u{cc6}",
                "ಕ\u{cc6}ಲಸಗಾರ",
                "ಕೈಗಾರ\u{cbf}ಕಾ",
                "ಸಭ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공장 직원"),
            keywords: &["공업", "공장", "조립공", "직원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{945}क\u{94d}ट\u{94d}री कामगार"),
            keywords: &[
                "अस\u{945}म\u{94d}बली। फ\u{945}क\u{94d}ट\u{94d}री। उद\u{94d}य\u{947}गध\u{902}दो। कामगार",
                "फ\u{945}क\u{94d}ट\u{94d}री कामगार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("завод жумушчусу"),
            keywords: &["завод жумушчусу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນງານໃນໂຮງງານ"),
            keywords: &[
                "ການຊ\u{eb8}ມນ\u{eb8}ມ",
                "ຄ\u{ebb}ນງານ",
                "ຄ\u{ebb}ນງານໃນໂຮງງານ",
                "ອ\u{eb8}ດສາຫະກຳ",
                "ໂຮງງານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gamyklos darbuotojas"),
            keywords: &[
                "darbininkas",
                "gamykla",
                "gamyklos darbuotojas",
                "industrinis",
                "surinkimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rūpnīcas strādnieks"),
            keywords: &[
                "montāža",
                "nozare",
                "rūpnīca",
                "rūpnīcas strādnieks",
                "strādnieks",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("работник во фабрика"),
            keywords: &[
                "индустрија",
                "лента",
                "работник",
                "работник во фабрика",
                "фабрика",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d3e}ക\u{d4d}ടറിത\u{d4d}തൊഴില\u{d3e}ളി"),
            keywords: &[
                "അസംബ\u{d4d}ലി",
                "തൊഴില\u{d3e}ളി",
                "ഫ\u{d3e}ക\u{d4d}ടറി",
                "ഫ\u{d3e}ക\u{d4d}ടറിത\u{d4d}തൊഴില\u{d3e}ളി",
                "വ\u{d4d}യവസ\u{d3e}യ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үйлдвэрийн ажилтан"),
            keywords: &[
                "аж үйлдвэрийн",
                "ажилтан",
                "угсрах",
                "үйлдвэр",
                "үйлдвэрийн ажилтан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कारखान\u{94d}यात काम करणारा"),
            keywords: &[
                "औद\u{94d}योगिक",
                "कामगार",
                "कारखाना",
                "कारखान\u{94d}यात काम करणारा",
                "परिषद",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja kilang"),
            keywords: &["industri", "kilang", "pekerja", "pemasangan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ရ\u{102f}\u{1036}အလ\u{102f}ပ\u{103a}သမား"),
            keywords: &[
                "စက\u{103a}မ\u{103e}\u{102f}လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "စက\u{103a}ရ\u{102f}\u{1036}",
                "စက\u{103a}ရ\u{102f}\u{1036}အလ\u{102f}ပ\u{103a}သမား",
                "တပ\u{103a}ဆင\u{103a}ခြင\u{103a}း",
                "အလ\u{102f}ပ\u{103a}သမား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("industriarbeider"),
            keywords: &[
                "arbeider",
                "fabrikk",
                "industri",
                "industriarbeider",
                "produksjon",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उद\u{94d}योग कर\u{94d}मचारी"),
            keywords: &[
                "अस\u{947}म\u{94d}\u{200d}बली",
                "उद\u{94d}योग कर\u{94d}मचारी",
                "औद\u{94d}योगिक",
                "कर\u{94d}मचारी",
                "कारखाना",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fabrieksarbeider"),
            keywords: &[
                "arbeider",
                "fabriek",
                "fabrieksarbeider",
                "industrieel",
                "lopende band",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("industriarbeidar"),
            keywords: &[
                "arbeidar",
                "fabrikk",
                "industri",
                "industriarbeidar",
                "produksjon",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ରଖ\u{b3e}ନ\u{b3e} କର\u{b4d}ମଚ\u{b3e}ରୀ"),
            keywords: &[
                "କର\u{b4d}ମଚ\u{b3e}ରୀ",
                "କ\u{b3e}ରଖ\u{b3e}ନ\u{b3e}",
                "ବ\u{b3f}ଧ\u{b3e}ନସଭ\u{b3e}",
                "ଶ\u{b3f}ଳ\u{b4d}ପ ସମ\u{b4d}ୱନ\u{b4d}ଧୀୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਰਖਾਨਾ ਮਜ\u{a3c}ਦ\u{a42}ਰ"),
            keywords: &[
                "ਅਸ\u{a48}\u{a02}ਬਲੀ",
                "ਉਦਯ\u{a4b}ਗਿਕ",
                "ਕਾਰਖਾਨਾ ਮਜ\u{a3c}ਦ\u{a42}ਰ",
                "ਫ\u{a48}ਕਟਰੀ",
                "ਬ\u{a70}ਦਾ",
                "ਵਰਕਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Fáktrí Wọ\u{301}ka"),
            keywords: &[
                "Asẹ\u{301}mbúl Fáktri",
                "Fáktri",
                "Fáktrí Wọ\u{301}ka",
                "Wọ\u{301}ka",
                "Índọ\u{301}stri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pracownik fabryki"),
            keywords: &["fabryka", "montażysta", "pracownik", "pracownik fabryki"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د فابريکې کارمند"),
            keywords: &[
                "د فابريکې کارمند",
                "صنعتي",
                "فابريکه",
                "يوځای کول",
                "کارمند",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("funcionário de fábrica"),
            keywords: &[
                "funcionário de fábrica",
                "fábrica",
                "industrial",
                "montagem",
                "trabalhador",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("trabalhador fabril"),
            keywords: &[
                "funcionário de fábrica",
                "fábrica",
                "industrial",
                "montagem",
                "trabalhador",
                "trabalhador fabril",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("fabrica llamkaq"),
            keywords: &["asamblea", "fabrica", "industrial", "llamkaq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("muncitor sau muncitoare în fabrică"),
            keywords: &[
                "colectiv",
                "fabrică",
                "industrial",
                "muncitor",
                "muncitor sau muncitoare în fabrică",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-014"),
            keywords: &["E13-014"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рабочий"),
            keywords: &["завод", "промышленность", "рабочий"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فيڪٽري ورڪر"),
            keywords: &["اسيمبلي", "انڊسٽريل", "فيڪٽري", "ورڪر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කර\u{dca}ම\u{dcf}න\u{dca}තශ\u{dcf}ල\u{dcf} සේවකය\u{dcf}"),
            keywords: &[
                "එකලස\u{dca} ක\u{dd2}ර\u{dd3}ම",
                "කර\u{dca}ම\u{dcf}න\u{dca}ත ශ\u{dcf}ල\u{dcf}ව",
                "කර\u{dca}ම\u{dcf}න\u{dca}තශ\u{dcf}ල\u{dcf} සේවකය\u{dcf}",
                "ක\u{dcf}ර\u{dca}ම\u{dd2}ක",
                "සේවකය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("robotník"),
            keywords: &["priemysel", "robotník", "továreň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("tovarniški delavec"),
            keywords: &[
                "delavec",
                "industrijski",
                "tekoči trak",
                "tovarna",
                "tovarniški delavec",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaqaale warshadeed"),
            keywords: &["kulan laysku ururay", "shaqaale warshadeed"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person punëtor fabrike"),
            keywords: &[
                "fabrikë",
                "industrial",
                "linjë",
                "person punëtor fabrike",
                "punëtor",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("радник у фабрици"),
            keywords: &[
                "индустрија",
                "производна трака",
                "радник",
                "радник у фабрици",
                "фабрика",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("radnik u fabrici"),
            keywords: &[
                "fabrika",
                "industrija",
                "proizvodna traka",
                "radnik",
                "radnik u fabrici",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fabriksarbetare"),
            keywords: &[
                "arbetare",
                "fabriksarbetare",
                "industri",
                "industriarbetare",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mfanyakazi wa kiwanda"),
            keywords: &[
                "kiwanda",
                "kusanyiko",
                "mfanyakazi",
                "mfanyakazi wa kiwanda",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தொழிற\u{bcd}ச\u{bbe}லை தொழில\u{bbe}ளி"),
            keywords: &[
                "சபை",
                "தொழிற\u{bcd}ச\u{bbe}லை",
                "தொழில\u{bbe}ளி",
                "தொழில\u{bcd}துறை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కర\u{c4d}మ\u{c3e}గ\u{c3e}ర క\u{c3e}ర\u{c4d}మ\u{c3f}కుడు"),
            keywords: &[
                "అస\u{c46}ంబ\u{c4d}ల\u{c40}",
                "కర\u{c4d}మ\u{c3e}గ\u{c3e}ర క\u{c3e}ర\u{c4d}మ\u{c3f}కుడు",
                "కర\u{c4d}మ\u{c3e}గ\u{c3e}రం",
                "క\u{c3e}ర\u{c4d}మ\u{c3f}కుడు",
                "పర\u{c3f}శ\u{c4d}రమ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พน\u{e31}กงานโรงงาน"),
            keywords: &[
                "คนงาน",
                "พน\u{e31}กงาน",
                "พน\u{e31}กงานโรงงาน",
                "อ\u{e38}ตสาหกรรม",
                "โรงงาน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("fabrik işçisi"),
            keywords: &["fabrik", "fabrik işçisi", "işçi", "senagat", "ýygnama"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ngāue fale faʻuʻanga"),
            keywords: &["tokotaha ngāue fale faʻuʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("fabrika işçisi"),
            keywords: &[
                "endüstri",
                "fabrika",
                "fabrika işçisi",
                "işçi",
                "montaj",
                "sanayi",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фабричний працівник"),
            keywords: &[
                "завод",
                "конвеєр",
                "промисловість",
                "робітник",
                "фабричний працівник",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فیکٹری ورکر"),
            keywords: &["اسمبلی", "صنعتی", "فیکٹری", "فیکٹری ورکر", "کارکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("zavod ishchisi"),
            keywords: &[
                "ishchi",
                "montaj",
                "sanoat",
                "yigʻish",
                "zavod",
                "zavod ishchisi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("công nhân nhà máy"),
            keywords: &[
                "công nghiệp",
                "công nhân",
                "công nhân nhà máy",
                "lắp ráp",
                "nhà máy",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("工廠工人"),
            keywords: &["工人", "工廠", "工廠工人", "工業", "組裝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("工厂工人"),
            keywords: &["工业", "工人", "工厂", "工厂工人", "组装"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("工人"),
            keywords: &["工业", "工人", "工厂", "装配"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("工廠作業員"),
            keywords: &["作業員", "工廠", "工廠作業員", "工業", "焊接"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wasefemini"),
            keywords: &[
                "ifemu",
                "izimboni",
                "umhlangano",
                "umsebenzi",
                "umsebenzi wasefemini",
            ],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🏭"]
pub const FACTORY_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🏭",
    codepoint: "1F9D1 1F3FB 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "factory worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🏭"]
pub const FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🏭",
    codepoint: "1F9D1 1F3FC 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "factory worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🏭"]
pub const FACTORY_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🏭",
    codepoint: "1F9D1 1F3FD 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "factory worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🏭"]
pub const FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🏭",
    codepoint: "1F9D1 1F3FE 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "factory worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🏭"]
pub const FACTORY_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🏭",
    codepoint: "1F9D1 1F3FF 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "factory worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🏭"]
pub const MAN_FACTORY_WORKER: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🏭",
    codepoint: "1F468 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man factory worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike fabriekswerker"),
            keywords: &["fabriekswerker", "manlike fabriekswerker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ የፋብሪካ ሰራተኛ"),
            keywords: &["መገጣጠሚያ", "ሰራተኛ", "ኢንዱስትሪ", "ወንድ", "ወንድ የፋብሪካ ሰራተኛ", "ፋብሪካ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عامل مصنع"),
            keywords: &["تجميع", "صناعة", "عامل", "مصنع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ ফেক\u{9cd}টৰী কৰ\u{9cd}মচ\u{9be}ৰী"),
            keywords: &[
                "উদ\u{9cd}যোগিক",
                "কৰ\u{9cd}মচ\u{9be}ৰী",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ফেক\u{9cd}টৰী",
                "বৈঠক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi fabrik işçisi"),
            keywords: &[
                "fabrik",
                "işçi",
                "kişi",
                "kişi fabrik işçisi",
                "sənaye",
                "yığım",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("працаўнік завода"),
            keywords: &[
                "завод",
                "мужчына",
                "прамыслоўца",
                "працаўнік",
                "працаўнік завода",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("работник в завод"),
            keywords: &["мъж", "производство", "работник в завод", "фабрика"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলে , প\u{9c1}র\u{9c1}ষ , মিলের কর\u{9cd}মি"),
            keywords: &[
                "অ\u{9cd}য\u{9be}সেমব\u{9cd}লি",
                "ইনড\u{9be}সট\u{9cd}রি",
                "কর\u{9cd}মী",
                "ক\u{9be}রখ\u{9be}ন\u{9be}",
                "ছেলে",
                "ছেলে , প\u{9c1}র\u{9c1}ষ , মিলের কর\u{9cd}মি",
                "প\u{9c1}র\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("micherour"),
            keywords: &["micherour"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("radnik u fabrici muškarac"),
            keywords: &[
                "fabrika",
                "industrija",
                "montaža",
                "muškarac",
                "radnik",
                "radnik u fabrici",
                "radnik u fabrici muškarac",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home operari"),
            keywords: &[
                "fàbrica",
                "home operari",
                "industrial",
                "operari",
                "treballador",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄜\u{11133}𑄠𑄇\u{11134}𑄑\u{1112e}𑄢\u{11128}𑄖\u{11134} 𑄇𑄟\u{11134} 𑄉\u{11127}𑄢\u{11128}𑄠𑄬 𑄟\u{11127}𑄢\u{11127}𑄘\u{11134}",
            ),
            keywords: &[
                "𑄜\u{11133}𑄠𑄇\u{11134}𑄑\u{1112e}𑄢\u{11128}𑄖\u{11134} 𑄇𑄟\u{11134} 𑄉\u{11127}𑄢\u{11128}𑄠𑄬 𑄟\u{11127}𑄢\u{11127}𑄘\u{11134}",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏃᏢᏅᏗ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᏍᎦᏯ",
                "ᎠᏍᎦᏯ ᎤᏃᏢᏅᏗ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᎤᎾᏓᏟᏌᎲ",
                "ᎤᏃᏢᏅᏗ",
                "ᏧᏂᎸᏫᏍᏓᏁᎯ",
                "ᏧᏂᎸᏫᏍᏓᏁᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dělník v továrně"),
            keywords: &["dělník", "dělník v továrně", "muž", "průmysl", "výroba"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr ffatri"),
            keywords: &["cydosod", "diwydiant", "dyn", "ffatri", "gweithiwr ffatri"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig fabriksarbejder"),
            keywords: &[
                "arbejder",
                "fabrik",
                "industri",
                "mand",
                "mandlig fabriksarbejder",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fabrikarbeiter"),
            keywords: &["Fabrik", "Fabrikarbeiter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργάτης"),
            keywords: &["άντρας", "εργάτης", "εργοστάσιο", "οικοδομή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man factory worker"),
            keywords: &["assembly", "factory", "industrial", "man", "worker"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional industrial hombre"),
            keywords: &[
                "fábrica",
                "montaje",
                "obrero",
                "operario",
                "profesional industrial hombre",
                "trabajador",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meessoost tehasetööline"),
            keywords: &[
                "liinitööline",
                "mees",
                "meessoost tehasetööline",
                "tehas",
                "tööline",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fabrikako gizon langilea"),
            keywords: &[
                "fabrika",
                "fabrikako gizon langilea",
                "gizon",
                "gizonezko",
                "industria",
                "langile",
                "mihiztatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارگر کارخانه مرد"),
            keywords: &["عمله", "کارگر", "کارگر کارخانه", "کارگر کارخانه مرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miestehdastyöntekijä"),
            keywords: &[
                "hitsaaja",
                "mies",
                "miestehdastyöntekijä",
                "tehdas",
                "työntekijä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking manggagawa sa pabrika"),
            keywords: &[
                "lalaking manggagawa sa pabrika",
                "manggagawa",
                "obrero",
                "pabrika",
                "trabahador",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur sveisari"),
            keywords: &[
                "arbeiðsmaður",
                "mannligur sveisari",
                "maður",
                "sjóðari",
                "sveisari",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ouvrier"),
            keywords: &["assemblage", "industrie", "ouvrier", "usine"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["assemblage", "homme", "industrie", "ouvrier", "usine"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí monarchan fireann"),
            keywords: &[
                "cóimeáil",
                "fear",
                "monarcha",
                "oibrí",
                "oibrí monarchan fireann",
                "tionsclaíoch",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-factaraidh fireann"),
            keywords: &[
                "duine",
                "factaraidh",
                "fear",
                "fireannach",
                "gnìomhachas",
                "neach-obrach",
                "obraiche",
                "obraiche-factaraidh fireann",
                "tionaladh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("operario"),
            keywords: &["fábrica", "home", "obreiro", "operario", "traballador"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ ફ\u{ac5}ક\u{acd}ટરી કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "ઔદ\u{acd}યોગિક",
                "કાર\u{acd}યકર\u{acd}તા",
                "પ\u{ac1}ર\u{ac1}ષ",
                "ફ\u{ac5}ક\u{acd}ટરી",
                "મ\u{a82}ડલી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum ma’aikacin masana’antu"),
            keywords: &[
                "masana’anta",
                "masana’antu",
                "ma’aikaci",
                "ma’aikatar harhaɗa",
                "mutum",
                "mutum ma’aikacin masana’antu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פועל"),
            keywords: &["איש", "גבר", "מפעיל", "עובד מפעל", "עובד תעשייה", "פועל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष फ\u{948}क\u{94d}टरी मजद\u{942}र"),
            keywords: &[
                "आदमी",
                "औद\u{94d}योगिक",
                "कारखाना",
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष फ\u{948}क\u{94d}टरी मजद\u{942}र",
                "मज\u{93c}द\u{942}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tvornički radnik"),
            keywords: &[
                "industrija",
                "radnik",
                "traka",
                "tvornica",
                "tvornički radnik",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi munkás"),
            keywords: &["dolgozó", "férfi", "gyári", "munkás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ բանվոր"),
            keywords: &["արդյունաբերություն", "բանվոր", "գործարան", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja pabrik pria"),
            keywords: &["laki-laki", "pabrik", "pekerja", "pekerja pabrik pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke onyeọrụ ụlọ ọrụ"),
            keywords: &[
                "nwoke",
                "nwoke onyeọrụ ụlọ ọrụ",
                "onyeọrụ",
                "ọgbakọ",
                "ụlọ ọrụ",
                "ụlọọrụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns verksmiðjustarfsmaður"),
            keywords: &[
                "iðnaður",
                "karl",
                "karlkyns verksmiðjustarfsmaður",
                "verkfæri",
                "verksmiðja",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("operaio"),
            keywords: &["fabbrica", "industria", "operaio", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性の溶接工"),
            keywords: &["溶接", "男", "男性", "男性の溶接工"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buruh pabrik lanang"),
            keywords: &["buruh", "industri", "karoseri", "lanang", "pabrik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქარხნის მუშაკი კაცი"),
            keywords: &[
                "ინდუსტრია",
                "კაცი",
                "ქარხანა",
                "ქარხნის მუშაკი",
                "ქარხნის მუშაკი კაცი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұмысшы"),
            keywords: &["ер", "ер зауытшы", "жұмысшы", "зауыт", "өнеркәсіп"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("fabriksarbejder"),
            keywords: &["arbejder", "fabrik", "fabriksarbejder", "industri", "mand"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កម\u{17d2}មកររោងចក\u{17d2}រប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "កម\u{17d2}មករ",
                "កម\u{17d2}មកររោងចក\u{17d2}រប\u{17d2}រ\u{17bb}ស",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "រោងចក\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಖಾನ\u{cc6}ಯ ಕಾರ\u{ccd}ಮ\u{cbf}ಕ"),
            keywords: &[
                "ಕಾರ\u{ccd}ಖಾನ\u{cc6}",
                "ಕಾರ\u{ccd}ಖಾನ\u{cc6}ಯ ಕಾರ\u{ccd}ಮ\u{cbf}ಕ",
                "ಕ\u{cc6}ಲಸಗಾರ",
                "ಕೈಗಾರ\u{cbf}ಕ\u{cc6}",
                "ವ\u{cbf}ಧಾನಸಭ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공장 남자 직원"),
            keywords: &["공업", "공장", "남자", "조립공", "직원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो फ\u{945}क\u{94d}ट\u{94d}री कामगार"),
            keywords: &[
                "अस\u{945}म\u{94d}बली। फ\u{945}क\u{94d}ट\u{94d}री। उद\u{94d}य\u{947}गध\u{902}दो। दादलो। कामगार",
                "दादलो फ\u{945}क\u{94d}ट\u{94d}री कामगार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек завод жумушчусу"),
            keywords: &[
                "жумушчу",
                "завод",
                "фабрика",
                "цех",
                "эркек",
                "эркек завод жумушчусу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Aarbechter"),
            keywords: &["Aarbechter", "Fabrik", "Industrie", "Mann", "Montage"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{eb1}ກງານໂຮງງານຊາຍ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ພະນ\u{eb1}ກງານໂຮງງານຊາຍ",
                "ອ\u{eb8}ດສາຫະກຳ",
                "ແຮງງານ",
                "ໂຮງງານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fabriko darbininkas"),
            keywords: &[
                "darbuotojas",
                "fabrikas",
                "fabriko darbininkas",
                "gamyba",
                "susirinkimas",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fabrikas strādnieks"),
            keywords: &[
                "fabrikas strādnieks",
                "ražošana",
                "rūpnīca",
                "strādnieks",
                "vīrietis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne mahi wheketere"),
            keywords: &[
                "ahumahi",
                "hangahanga",
                "kaimahi",
                "tāne",
                "tāne mahi wheketere",
                "wheketere",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("работник"),
            keywords: &["индустрија", "маж", "работник", "фабрика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d3e}ക\u{d4d}ടറി ജീവനക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "ജോലിക\u{d4d}ക\u{d3e}രൻ",
                "ഫ\u{d3e}ക\u{d4d}ടറി",
                "ഫ\u{d3e}ക\u{d4d}ടറി ജീവനക\u{d4d}ക\u{d3e}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй үйлдвэрийн ажилтан"),
            keywords: &[
                "аж үйлдвэрийн",
                "ажилтан",
                "угсрах",
                "эрэгтэй",
                "эрэгтэй үйлдвэрийн ажилтан",
                "үйлдвэр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कारखाना कामगार"),
            keywords: &[
                "औद\u{94d}योगिक",
                "कामगार",
                "कारखाना",
                "परिषद",
                "प\u{941}र\u{942}ष",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja kilang lelaki"),
            keywords: &["industri", "kilang", "lelaki", "pekerja", "pemasangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħaddiem tal-fabbrika"),
            keywords: &[
                "assemblaġġ",
                "fabbrika",
                "industrijali",
                "raġel",
                "ħaddiem",
                "ħaddiem tal-fabbrika",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ရ\u{102f}\u{1036}လ\u{102f}ပ\u{103a}သား"),
            keywords: &[
                "စက\u{103a}မ\u{103e}\u{102f}လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "စက\u{103a}ရ\u{102f}\u{1036}",
                "စက\u{103a}ရ\u{102f}\u{1036}လ\u{102f}ပ\u{103a}သား",
                "တပ\u{103a}ဆင\u{103a}ခြင\u{103a}း",
                "အမျ\u{102d}\u{102f}းသား",
                "အလ\u{102f}ပ\u{103a}သမား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig industriarbeider"),
            keywords: &[
                "arbeider",
                "fabrikk",
                "industri",
                "industriarbeider",
                "mann",
                "mannlig industriarbeider",
                "produksjon",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कारखानाको प\u{941}र\u{942}ष मजद\u{941}र"),
            keywords: &[
                "औद\u{94d}योगिक",
                "कारखाना",
                "कारखानाको प\u{941}र\u{942}ष मजद\u{941}र",
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "मजद\u{941}र",
                "सभा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke fabrieksarbeider"),
            keywords: &[
                "arbeider",
                "fabriek",
                "industrieel",
                "lopende band",
                "man",
                "mannelijke fabrieksarbeider",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg industriarbeidar"),
            keywords: &[
                "arbeidar",
                "fabrikk",
                "industri",
                "industriarbeidar",
                "mann",
                "mannleg industriarbeidar",
                "produksjon",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ କ\u{b3e}ରଖ\u{b3e}ନ\u{b3e} ଶ\u{b4d}ରମ\u{b3f}କ"),
            keywords: &[
                "ଔଦ\u{b4d}ୟୋଗ\u{b3f}କ",
                "କ\u{b3e}ରଖ\u{b3e}ନ\u{b3e}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ଶ\u{b4d}ରମ\u{b3f}କ",
                "ସମ\u{b3e}ବେଶ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਫ\u{a48}ਕਟਰੀ ਵਰਕਰ"),
            keywords: &[
                "ਅਸ\u{a48}\u{a02}ਬਲੀ",
                "ਉਦਯ\u{a4b}ਗਿਕ",
                "ਕਾਮਾ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਫ\u{a48}ਕਟਰੀ ਵਰਕਰ",
                "ਫ\u{a48}ਕਟਰੀ",
                "ਬ\u{a70}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیکٹری وچ کم کرن آلا بندہ"),
            keywords: &[
                "اجتماع",
                "بندہ",
                "صنعتی",
                "فیکٹری",
                "فیکٹری وچ کم کرن آلا بندہ",
                "کم کرن آلا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Fáktrí Wọ\u{301}ka"),
            keywords: &[
                "Asẹ\u{301}mbúl Fáktri",
                "Fáktri",
                "Man",
                "Mán Fáktrí Wọ\u{301}ka",
                "Wọ\u{301}ka",
                "Índọ\u{301}stri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna pracownik fabryki"),
            keywords: &[
                "fabryka",
                "montażysta",
                "mężczyzna",
                "mężczyzna pracownik fabryki",
                "pracownik",
                "pracownik fabryki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی د فابريکې کارګر"),
            keywords: &[
                "سړی",
                "سړی د فابريکې کارګر",
                "صنعتي",
                "فابريکه",
                "يوځای کول",
                "کار کوونکی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("operário"),
            keywords: &["fábrica", "homem", "indústria", "operário", "trabalhador"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("operário fabril"),
            keywords: &[
                "fábrica",
                "homem",
                "industrial",
                "montagem",
                "operário",
                "operário fabril",
                "trabalhador",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata fabrica llamkaq"),
            keywords: &["asamblea", "fabrica", "industrial", "llamkaq", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("muncitor în fabrică"),
            keywords: &[
                "asamblare",
                "fabrică",
                "industrial",
                "muncitor",
                "muncitor în fabrică",
                "uzină",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1167"),
            keywords: &["E10-1167"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-рабочий"),
            keywords: &[
                "завод",
                "мужчина",
                "мужчина-рабочий",
                "промышленность",
                "рабочий",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo ukora mu ruganda"),
            keywords: &[
                "cy’inganda",
                "inteko",
                "umugabo",
                "umugabo ukora mu ruganda",
                "umukozi",
                "uruganda",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد ڪارخانو مزدور"),
            keywords: &["مرد ڪارخانو مزدور", "مرد، صنحت، اسيمبلي، ڪارخانو، مزدور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} කම\u{dca}හල\u{dca} කම\u{dca}කර\u{dd4}ව\u{dcf}"),
            keywords: &[
                "එකලස",
                "කම\u{dca}කර\u{dd4}ව\u{dcf}",
                "කම\u{dca}හල",
                "ක\u{dcf}ර\u{dca}ම\u{dd2}ක",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} කම\u{dca}හල\u{dca} කම\u{dca}කර\u{dd4}ව\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("robotník muž"),
            keywords: &["muž", "priemysel", "robotník", "továreň"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("delavec v tovarni"),
            keywords: &[
                "delavec",
                "delavec v tovarni",
                "fant",
                "industrijski",
                "moški",
                "proizvodnja",
                "tekoči trak",
                "tovarna",
                "tovarnar",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin shaqaale warshad ah"),
            keywords: &[
                "isugeynta",
                "nin",
                "nin shaqaale warshad ah",
                "shaqaale",
                "warshad",
                "warshad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("punëtor fabrike"),
            keywords: &[
                "burrë",
                "fabrikë",
                "industri",
                "montator",
                "punëtor fabrike",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("радник"),
            keywords: &["индустрија", "мушкарац", "радник", "фабрика"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("radnik"),
            keywords: &["fabrika", "industrija", "muškarac", "radnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig fabriksarbetare"),
            keywords: &[
                "fabrik",
                "industri",
                "man",
                "manlig fabriksarbetare",
                "produktion",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume na gesi ya kuchoma"),
            keywords: &[
                "fundi",
                "jua kali",
                "kuchomelea",
                "mfanyakazi",
                "mwanamume na gesi ya kuchoma",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} தொழில\u{bbe}ளி"),
            keywords: &["ஆண\u{bcd}", "தொழிற\u{bcd}ச\u{bbe}லை", "தொழில\u{bbe}ளி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}మ\u{c3f}కుడు"),
            keywords: &[
                "అస\u{c46}ంబ\u{c4d}ల\u{c40}",
                "కర\u{c4d}మ\u{c3e}గ\u{c3e}రం",
                "క\u{c3e}ర\u{c4d}మ\u{c3f}కుడు",
                "పర\u{c3f}శ\u{c4d}రమ",
                "పురుషుడు",
                "మగ\u{c3e}డు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди коргари фабрика"),
            keywords: &[
                "ассамблея",
                "коргар",
                "мард",
                "марди коргари фабрика",
                "саноатӣ",
                "фабрика",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พน\u{e31}กงานโรงงานชาย"),
            keywords: &[
                "คนงาน",
                "ผ\u{e39}\u{e49}ชาย",
                "พน\u{e31}กงานโรงงานชาย",
                "อ\u{e38}ตสาหกรรม",
                "โรงงาน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek zawod işçisi"),
            keywords: &[
                "erkek",
                "erkek zawod işçisi",
                "gurnama",
                "işçi",
                "senagat",
                "zawod",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata ngāue fale faʻuʻanga"),
            keywords: &["tangata ngāue fale faʻuʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek fabrika işçisi"),
            keywords: &[
                "adam",
                "erkek",
                "erkek fabrika işçisi",
                "fabrika",
                "işçi",
                "montaj",
                "sanayi",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر زاۋۇت ئىشچىسى"),
            keywords: &[
                "ئىشچى",
                "ئەر",
                "ئەر زاۋۇت ئىشچىسى",
                "زاۋۇت",
                "سانائەت",
                "قوراشتۇرۇش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("робітник"),
            keywords: &[
                "конвеєр",
                "промисловий",
                "робітник",
                "трудівник",
                "фабрика",
                "чоловік",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد فیکٹری کارکن"),
            keywords: &["فیکٹری", "مرد", "کارکن", "کاریگر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak zavod ishchisi"),
            keywords: &[
                "erkak",
                "erkak zavod ishchisi",
                "ishchi",
                "sanoat",
                "yigʻuv",
                "zavod",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("công nhân nhà máy nam"),
            keywords: &[
                "công nghiệp",
                "công nhân",
                "công nhân nhà máy nam",
                "lắp ráp",
                "nam",
                "nhà máy",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("liggéeykatu isin bu góor"),
            keywords: &[
                "góor",
                "indistri",
                "isin",
                "liggéeykat",
                "liggéeykatu isin bu góor",
                "ndaje",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsebenzi wasefektri oyindoda"),
            keywords: &[
                "amashishini",
                "ifektri",
                "indoda",
                "ukuhlanganisa",
                "umsebenzi",
                "umsebenzi wasefektri oyindoda",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin òṣìṣẹ\u{301} ilé-iṣẹ\u{301}"),
            keywords: &[
                "ilé iṣẹ\u{301}",
                "ìpéjọpọ\u{300}",
                "òṣìṣẹ\u{301}",
                "ọkùnrin",
                "ọkùnrin òṣìṣẹ\u{301} ilé-iṣẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男工廠工人"),
            keywords: &["工人", "工廠", "工業", "男", "男工廠工人", "裝配"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男工厂工人"),
            keywords: &["工业", "工人", "工厂", "男", "男工厂工人", "装配"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男工人"),
            keywords: &["工业", "工厂", "男工人", "装配"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("工廠男作業員"),
            keywords: &["作業員", "工廠", "工廠男作業員", "男"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男工廠工人"),
            keywords: &["工廠", "工廠工人", "焊工", "焊接", "男", "男工廠工人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wasefemini wesilisa"),
            keywords: &[
                "ifemu",
                "owesilisa",
                "ukuhlangana",
                "umsebenzi",
                "umsebenzi wasefemini wesilisa",
            ],
        },
    ],
};
#[doc = "👨🏻\u{200d}🏭"]
pub const MAN_FACTORY_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🏭",
    codepoint: "1F468 1F3FB 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man factory worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🏭"]
pub const MAN_FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🏭",
    codepoint: "1F468 1F3FC 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man factory worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🏭"]
pub const MAN_FACTORY_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🏭",
    codepoint: "1F468 1F3FD 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man factory worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🏭"]
pub const MAN_FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🏭",
    codepoint: "1F468 1F3FE 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man factory worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🏭"]
pub const MAN_FACTORY_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🏭",
    codepoint: "1F468 1F3FF 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man factory worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🏭"]
pub const WOMAN_FACTORY_WORKER: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🏭",
    codepoint: "1F469 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman factory worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike fabriekswerker"),
            keywords: &["fabriekswerker", "vroulike fabriekswerker"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት የፋብሪካ ሰራተኛ"),
            keywords: &["መገጣጠሚያ", "ሰራተኛ", "ሴት የፋብሪካ ሰራተኛ", "ኢንዱስትሪ", "ፋብሪካ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عاملة مصنع"),
            keywords: &["تجميع", "صناعة", "عاملة", "مصنع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} ফেক\u{9cd}টৰী কৰ\u{9cd}মচ\u{9be}ৰী"),
            keywords: &[
                "উদ\u{9cd}যোগিক",
                "কৰ\u{9cd}মচ\u{9be}ৰী",
                "ফেক\u{9cd}টৰী",
                "বৈঠক",
                "মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın fabrik işçisi"),
            keywords: &[
                "fabrik",
                "işçi",
                "qadın",
                "qadın fabrik işçisi",
                "sənaye",
                "yığım",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("працаўніца завода"),
            keywords: &[
                "жанчына",
                "завод",
                "прамысловасць",
                "працаўніца",
                "працаўніца завода",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("работничка в завод"),
            keywords: &["жена", "производство", "работничка в завод", "фабрика"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}ে , মহিল\u{9be} , মিলের কর\u{9cd}মি"),
            keywords: &[
                "অ\u{9cd}য\u{9be}সেমব\u{9cd}লি",
                "ইনড\u{9be}সট\u{9cd}রি",
                "কর\u{9cd}মী",
                "ক\u{9be}রখ\u{9be}ন\u{9be}",
                "মহিল\u{9be}",
                "মেয\u{9bc}ে",
                "মেয\u{9bc}ে , মহিল\u{9be} , মিলের কর\u{9cd}মি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("micherourez"),
            keywords: &["micherourez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("radnica u fabrici"),
            keywords: &[
                "fabrika",
                "industrija",
                "montaža",
                "radnica u fabrici",
                "radnik",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("operària"),
            keywords: &["fàbrica", "industrial", "operària", "treballadora"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some(
                "𑄜\u{11133}𑄠𑄇\u{11134}𑄑\u{1112e}𑄢\u{11128}𑄖\u{11134} 𑄇𑄟\u{11134} 𑄉\u{11127}𑄢\u{11128}𑄠𑄬 𑄟\u{11128}𑄣𑄬",
            ),
            keywords: &[
                "𑄜\u{11133}𑄠𑄇\u{11134}𑄑\u{1112e}𑄢\u{11128}𑄖\u{11134} 𑄇𑄟\u{11134} 𑄉\u{11127}𑄢\u{11128}𑄠𑄬 𑄟\u{11128}𑄣𑄬",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᎦᎸᏫᏍᏓᏁᏗ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᏗᎦᎸᏫᏍᏓᏁᏗ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏂᎦᏓ ᏚᏂᎸᏫᏍᏓᏁᎲᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᎤᏙᎴᏒᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᏚᏙᏢᏒᎢ",
                "ᏧᎸᏫᏍᏓᏁᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dělnice v továrně"),
            keywords: &["dělnice", "dělnice v továrně", "průmysl", "výroba", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithwraig ffatri"),
            keywords: &[
                "benyw",
                "cydosod",
                "diwydiant",
                "ffatri",
                "gweithwraig ffatri",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig fabriksarbejder"),
            keywords: &[
                "arbejder",
                "fabrik",
                "industri",
                "kvinde",
                "kvindelig fabriksarbejder",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fabrikarbeiterin"),
            keywords: &["Fabrik", "Fabrikarbeiterin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("εργάτρια"),
            keywords: &["γυναίκα", "εργάτρια", "εργοστάσιο", "οικοδομή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman factory worker"),
            keywords: &["assembly", "factory", "industrial", "woman", "worker"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional industrial mujer"),
            keywords: &[
                "fábrica",
                "montaje",
                "obrera",
                "operaria",
                "profesional industrial mujer",
                "trabajadora",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naissoost tehasetööline"),
            keywords: &[
                "liinitööline",
                "naine",
                "naissoost tehasetööline",
                "tehas",
                "tööline",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("fabrikako emakume langilea"),
            keywords: &[
                "emakume",
                "emakumezko",
                "fabrika",
                "fabrikako emakume langilea",
                "industria",
                "langile",
                "mihiztatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارگر کارخانه زن"),
            keywords: &["عمله", "کارگر", "کارگر کارخانه", "کارگر کارخانه زن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naistehdastyöntekijä"),
            keywords: &[
                "hitsaaja",
                "nainen",
                "naistehdastyöntekijä",
                "tehdas",
                "työntekijä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng manggagawa sa pabrika"),
            keywords: &[
                "babaeng manggagawa sa pabrika",
                "manggagawa",
                "obrero",
                "pabrika",
                "trabahadora",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur sveisari"),
            keywords: &[
                "arbeiðskvinna",
                "kona",
                "kvinna",
                "kvinnuligur sveisari",
                "sj´óðari",
                "sveisari",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ouvrière"),
            keywords: &["assemblage", "industrie", "ouvrière", "usine"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["assemblage", "femme", "industrie", "ouvrière", "usine"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí monarchan baineann"),
            keywords: &[
                "bean",
                "cóimeáil",
                "monarcha",
                "oibrí",
                "oibrí monarchan baineann",
                "tionsclaíoch",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-factaraidh boireann"),
            keywords: &[
                "boireannach",
                "factaraidh",
                "gnìomhachas",
                "neach-obrach",
                "obraiche",
                "obraiche-factaraidh boireann",
                "tionaladh",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("operaria"),
            keywords: &["fábrica", "muller", "obreira", "operaria", "traballadora"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ફ\u{ac5}ક\u{acd}ટરી કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "ઔદ\u{acd}યોગિક",
                "કાર\u{acd}યકર\u{acd}તા",
                "ફ\u{ac5}ક\u{acd}ટરી",
                "મ\u{a82}ડલી",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace ma’aikacin masana’antu"),
            keywords: &[
                "mace",
                "mace ma’aikacin masana’antu",
                "masana’anta",
                "masana’antu",
                "ma’aikaci",
                "ma’aikatar harhaɗa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פועלת"),
            keywords: &[
                "אישה",
                "מפעילה",
                "מפעל",
                "מרכיבה",
                "עובדת",
                "עובדת תעשייה",
                "פועלת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला फ\u{948}क\u{94d}टरी मजद\u{942}र"),
            keywords: &[
                "औद\u{94d}योगिक",
                "कारखाना",
                "मज\u{93c}द\u{942}र",
                "महिला",
                "महिला फ\u{948}क\u{94d}टरी मजद\u{942}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("tvornička radnica"),
            keywords: &[
                "industrija",
                "radnica",
                "traka",
                "tvornica",
                "tvornička radnica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női munkás"),
            keywords: &["dolgozó", "gyári", "munkás", "nő", "női munkás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բանվորուհի"),
            keywords: &[
                "արդյունաբերություն",
                "բանվոր",
                "բանվորուհի",
                "գործարան",
                "կին",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja pabrik wanita"),
            keywords: &["pabrik", "pekerja", "pekerja pabrik wanita", "perempuan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị onyeọrụ ụlọ ọrụ"),
            keywords: &[
                "nwanyị",
                "nwanyị onyeọrụ ụlọ ọrụ",
                "onyeọrụ",
                "ọgbakọ",
                "ụlọ ọrụ",
                "ụlọọrụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns verksmiðjustarfsmaður"),
            keywords: &[
                "iðnaður",
                "kona",
                "kvenkyns verksmiðjustarfsmaður",
                "verkfæri",
                "verksmiðja",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("operaia"),
            keywords: &["donna", "fabbrica", "industria", "operaia"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性の溶接工"),
            keywords: &["女", "女性", "女性の溶接工", "溶接"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("buruh pabrik wadon"),
            keywords: &[
                "buruh",
                "buruh pabrik wadon",
                "industri",
                "karoseri",
                "lanang",
                "pabrik",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქარხნის მუშაკი ქალი"),
            keywords: &[
                "ინდუსტრია",
                "ქალი",
                "ქარხანა",
                "ქარხნის მუშაკი",
                "ქარხნის მუშაკი ქალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұмысшы әйел"),
            keywords: &["жұмысшы", "зауыт", "әйел", "әйел зауытшы", "өнеркәсіп"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig fabriksarbejder"),
            keywords: &[
                "arbejder",
                "fabrik",
                "industri",
                "kvinde",
                "kvindelig fabriksarbejder",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កម\u{17d2}មការន\u{17b8}រោងចក\u{17d2}រ"),
            keywords: &[
                "កម\u{17d2}មករ",
                "កម\u{17d2}មការន\u{17b8}",
                "កម\u{17d2}មការន\u{17b8}រោងចក\u{17d2}រ",
                "នារ\u{17b8}",
                "រោងចក\u{17d2}រ",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾರ\u{ccd}ಖಾನ\u{cc6}ಯ ಕಾರ\u{ccd}ಮ\u{cbf}ಕ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಕಾರ\u{ccd}ಖಾನ\u{cc6}",
                "ಕಾರ\u{ccd}ಖಾನ\u{cc6}ಯ ಕಾರ\u{ccd}ಮ\u{cbf}ಕ ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಕೈಗಾರ\u{cbf}ಕ\u{cc6}",
                "ವ\u{cbf}ಧಾನಸಭ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("공장 여자 직원"),
            keywords: &["공업", "공장", "여자", "조립공", "직원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल फ\u{945}क\u{94d}ट\u{94d}री कामगार"),
            keywords: &[
                "अस\u{945}म\u{94d}बली। फ\u{945}क\u{94d}ट\u{94d}री। उद\u{94d}य\u{947}गध\u{902}दो। बायल। कामगार",
                "बायल फ\u{945}क\u{94d}ट\u{94d}री कामगार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял завод жумушчусу"),
            keywords: &[
                "аял",
                "аял завод жумушчусу",
                "жумушчу",
                "завод",
                "фабрика",
                "цех",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Aarbechterin"),
            keywords: &["Aarbechterin", "Fabrik", "Fra", "Industrie", "Montage"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{eb1}ກງານໂຮງງານຍ\u{eb4}ງ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ພະນ\u{eb1}ກງານໂຮງງານຍ\u{eb4}ງ",
                "ອ\u{eb8}ດສາຫະກຳ",
                "ແຮງງານ",
                "ໂຮງງານ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fabriko darbininkė"),
            keywords: &[
                "darbuotoja",
                "fabrikas",
                "fabriko darbininkė",
                "gamyba",
                "moteris",
                "susirinkimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("fabrikas strādniece"),
            keywords: &[
                "fabrikas strādniece",
                "ražošana",
                "rūpnīca",
                "sieviete",
                "strādniece",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine mahi wheketere"),
            keywords: &[
                "ahumahi",
                "hangahanga",
                "kaimahi",
                "wahine",
                "wahine mahi wheketere",
                "wheketere",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("работничка"),
            keywords: &["жена", "индустрија", "работничка", "фабрика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഫ\u{d3e}ക\u{d4d}ടറി ജീവനക\u{d4d}ക\u{d3e}രി"),
            keywords: &[
                "ജോലിക\u{d4d}ക\u{d3e}രി",
                "ഫ\u{d3e}ക\u{d4d}ടറി",
                "ഫ\u{d3e}ക\u{d4d}ടറി ജീവനക\u{d4d}ക\u{d3e}രി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй үйлдвэрийн ажилтан"),
            keywords: &[
                "аж үйлдвэрийн",
                "ажилтан",
                "угсрах",
                "эмэгтэй",
                "эмэгтэй үйлдвэрийн ажилтан",
                "үйлдвэр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला कारखाना कामगार"),
            keywords: &["औद\u{94d}योगिक", "कामगार", "कारखाना", "परिषद", "महिला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja kilang wanita"),
            keywords: &[
                "industri",
                "kilang",
                "pekerja",
                "pemasangan",
                "perempuan",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħaddiema tal-fabbrika"),
            keywords: &[
                "assemblaġġ",
                "fabbrika",
                "industrijali",
                "mara",
                "ħaddiem",
                "ħaddiema tal-fabbrika",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ရ\u{102f}\u{1036}အလ\u{102f}ပ\u{103a}သမ"),
            keywords: &[
                "စက\u{103a}မ\u{103e}\u{102f}လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "စက\u{103a}ရ\u{102f}\u{1036}",
                "စက\u{103a}ရ\u{102f}\u{1036}အလ\u{102f}ပ\u{103a}သမ",
                "တပ\u{103a}ဆင\u{103a}ခြင\u{103a}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အလ\u{102f}ပ\u{103a}သမ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig industriarbeider"),
            keywords: &[
                "fabrikk",
                "industri",
                "kvinne",
                "kvinnelig industriarbeider",
                "produksjon",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कारखानाको महिला मजद\u{941}र"),
            keywords: &[
                "औद\u{94d}योगिक",
                "कारखाना",
                "कारखानाको महिला मजद\u{941}र",
                "छोरीमान\u{94d}छ\u{947}",
                "मजद\u{941}र",
                "महिला",
                "सभा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fabrieksarbeidster"),
            keywords: &[
                "arbeidster",
                "fabriek",
                "fabrieksarbeidster",
                "industrieel",
                "lopende band",
                "vrouw",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg industriarbeidar"),
            keywords: &[
                "fabrikk",
                "industri",
                "kvinne",
                "kvinneleg industriarbeidar",
                "produksjon",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} କ\u{b3e}ରଖ\u{b3e}ନ\u{b3e} ଶ\u{b4d}ରମ\u{b3f}କ"),
            keywords: &[
                "ଔଦ\u{b4d}ୟୋଗ\u{b3f}କ",
                "କ\u{b3e}ରଖ\u{b3e}ନ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ଶ\u{b4d}ରମ\u{b3f}କ",
                "ସମ\u{b3e}ବେଶ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਫ\u{a48}ਕਟਰੀ ਵਰਕਰ"),
            keywords: &[
                "ਅਸ\u{a48}\u{a02}ਬਲੀ",
                "ਇਸਤਰੀ",
                "ਔਰਤ",
                "ਫ\u{a48}ਕਟਰੀ",
                "ਵਰਕਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیکٹری وچ کم کرن آلی زنانی"),
            keywords: &[
                "اجتماع",
                "زنانی",
                "صنعتی",
                "فیکٹری",
                "فیکٹری وچ کم کرن آلی زنانی",
                "کم کرن آلا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Fáktrí Wọ\u{301}ka"),
            keywords: &[
                "Asẹ\u{301}mbúl Fáktri",
                "Fáktri",
                "Wúman",
                "Wúmán Fáktrí Wọ\u{301}ka",
                "Wọ\u{301}ka",
                "Índọ\u{301}stri",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pracownica fabryki"),
            keywords: &[
                "fabryka",
                "kobieta",
                "montażystka",
                "pracownica",
                "pracownica fabryki",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه د فابريکې کارګر"),
            keywords: &[
                "صنعتي",
                "فابريکه",
                "يوځای کول",
                "ښځه",
                "ښځه د فابريکې کارګر",
                "کار کوونکی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("operária"),
            keywords: &["fábrica", "indústria", "mulher", "operária", "trabalhadora"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("operária fabril"),
            keywords: &[
                "fábrica",
                "industrial",
                "montagem",
                "mulher",
                "operária",
                "operária fabril",
                "trabalhadora",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi fabrica llamkaq"),
            keywords: &["asamblea", "fabrica", "industrial", "llamkaq", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("muncitoare în fabrică"),
            keywords: &[
                "asamblare",
                "fabrică",
                "industrial",
                "muncitoare",
                "muncitoare în fabrică",
                "uzină",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1183"),
            keywords: &["E10-1183"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("работница"),
            keywords: &["женщина", "завод", "промышленность", "работница", "рабочий"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore ukora mu ruganda"),
            keywords: &[
                "cy’inganda",
                "inteko",
                "umugore",
                "umugore ukora mu ruganda",
                "umukozi",
                "uruganda",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت ڪارخانو مزدور"),
            keywords: &["عورت ڪارخانو مزدور", "عورت، صنحت، اسيمبلي، ڪارخانو، مزدور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැහැණ\u{dd4} කම\u{dca}හල\u{dca} කම\u{dca}කර\u{dd4}ව\u{dcf}"),
            keywords: &[
                "එකලස",
                "කම\u{dca}කර\u{dd4}ව\u{dcf}",
                "කම\u{dca}හල",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ක\u{dcf}ර\u{dca}ම\u{dd2}ක",
                "ගැහැණ\u{dd4} කම\u{dca}හල\u{dca} කම\u{dca}කර\u{dd4}ව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("robotníčka"),
            keywords: &["priemysel", "robotníčka", "továreň", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("delavka v tovarni"),
            keywords: &[
                "dekle",
                "delavka",
                "delavka v tovarni",
                "industrijski",
                "proizvodnja",
                "tekoči trak",
                "tovarna",
                "tovarnarka",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag shaqaale warshad ah"),
            keywords: &[
                "isugeynta",
                "naag",
                "naag shaqaale warshad ah",
                "shaqaale",
                "warshad",
                "warshad ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("punëtore fabrike"),
            keywords: &[
                "fabrikë",
                "grua",
                "industri",
                "montatore",
                "punëtore fabrike",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("радница"),
            keywords: &["жена", "индустрија", "радница", "фабрика"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("radnica"),
            keywords: &["fabrika", "industrija", "radnica", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig fabriksarbetare"),
            keywords: &[
                "fabrik",
                "industri",
                "kvinna",
                "kvinnlig fabriksarbetare",
                "produktion",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke na gesi ya kuchoma"),
            keywords: &[
                "fundi",
                "jua kali",
                "kuchomelea",
                "mfanyakazi",
                "mwanamke na gesi ya kuchoma",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} தொழில\u{bbe}ளி"),
            keywords: &["தொழிற\u{bcd}ச\u{bbe}லை", "தொழில\u{bbe}ளி", "பெண\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}మ\u{c3f}కుర\u{c3e}లు"),
            keywords: &[
                "అస\u{c46}ంబ\u{c4d}ల\u{c40}",
                "కర\u{c4d}మ\u{c3e}గ\u{c3e}రం",
                "క\u{c3e}ర\u{c4d}మ\u{c3f}కుర\u{c3e}లు",
                "పర\u{c3f}శ\u{c4d}రమ",
                "మహ\u{c3f}ళ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани коргари фабрика"),
            keywords: &[
                "ассамблея",
                "зан",
                "зани коргари фабрика",
                "коргар",
                "саноатӣ",
                "фабрика",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พน\u{e31}กงานโรงงานหญ\u{e34}ง"),
            keywords: &[
                "คนงาน",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "พน\u{e31}กงานโรงงานหญ\u{e34}ง",
                "อ\u{e38}ตสาหกรรม",
                "โรงงาน",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan zawod işçisi"),
            keywords: &[
                "gurnama",
                "işçi",
                "senagat",
                "zawod",
                "zenan",
                "zenan zawod işçisi",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine ngāue fale faʻuʻanga"),
            keywords: &["fefine ngāue fale faʻuʻanga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın fabrika işçisi"),
            keywords: &[
                "bayan",
                "fabrika",
                "işçi",
                "kadın",
                "kadın fabrika işçisi",
                "montaj",
                "sanayi",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال زاۋۇت ئىشچىسى"),
            keywords: &[
                "ئايال",
                "ئايال زاۋۇت ئىشچىسى",
                "ئىشچى",
                "زاۋۇت",
                "سانائەت",
                "قوراشتۇرۇش",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("робітниця"),
            keywords: &[
                "жінка",
                "конвеєр",
                "промисловий",
                "робітниця",
                "трудівниця",
                "фабрика",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت فیکٹری کارکن"),
            keywords: &["عورت", "فیکٹری", "کارکن", "کاریگر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol zavod ishchisi"),
            keywords: &[
                "ayol",
                "ayol zavod ishchisi",
                "ishchi",
                "sanoat",
                "yigʻuv",
                "zavod",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("công nhân nhà máy nữ"),
            keywords: &[
                "công nghiệp",
                "công nhân",
                "công nhân nhà máy nữ",
                "lắp ráp",
                "nhà máy",
                "nữ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen juy liggéeykat ci isin"),
            keywords: &[
                "bu isin",
                "isin",
                "jigéen",
                "jigéen juy liggéeykat ci isin",
                "liggéeykat",
                "ndaje",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsebenzi wasefektri olibhinqa"),
            keywords: &[
                "amashishini",
                "ibhinqa",
                "ifektri",
                "ukuhlanganisa",
                "umsebenzi",
                "umsebenzi wasefektri olibhinqa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrin òṣìṣẹ\u{301} ilé-iṣẹ\u{301}"),
            keywords: &[
                "ilé iṣẹ\u{301}",
                "obìrin",
                "obìrin òṣìṣẹ\u{301} ilé-iṣẹ\u{301}",
                "ìpéjọpọ\u{300}",
                "òṣìṣẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女工廠工人"),
            keywords: &["女", "女工廠工人", "工人", "工廠", "工業", "裝配"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女工厂工人"),
            keywords: &["女", "女工厂工人", "工业", "工人", "工厂", "装配"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女工人"),
            keywords: &["女工人", "工业", "工厂", "装配"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("工廠女作業員"),
            keywords: &["作業員", "女", "工廠", "工廠女作業員"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女工廠工人"),
            keywords: &["女", "女工廠工人", "工廠", "工廠工人", "焊工", "焊接"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wasefemini wesifazane"),
            keywords: &[
                "ifemu",
                "owesifazane",
                "ukuhlangana",
                "umsebenzi",
                "umsebenzi wasefemini wesifazane",
            ],
        },
    ],
};
#[doc = "👩🏻\u{200d}🏭"]
pub const WOMAN_FACTORY_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🏭",
    codepoint: "1F469 1F3FB 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman factory worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🏭"]
pub const WOMAN_FACTORY_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🏭",
    codepoint: "1F469 1F3FC 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman factory worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🏭"]
pub const WOMAN_FACTORY_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🏭",
    codepoint: "1F469 1F3FD 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman factory worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🏭"]
pub const WOMAN_FACTORY_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🏭",
    codepoint: "1F469 1F3FE 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman factory worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🏭"]
pub const WOMAN_FACTORY_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🏭",
    codepoint: "1F469 1F3FF 200D 1F3ED",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman factory worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}💼"]
pub const OFFICE_WORKER: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}💼",
    codepoint: "1F9D1 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "office worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kantoorwerker"),
            keywords: &[
                "argitek",
                "besigheid",
                "bestuurder",
                "kantoorwerker",
                "witboordjiewerker",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቤሮ ሰራተኛ"),
            keywords: &["የቤሮ ሰራተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موظف مكتب"),
            keywords: &["شركة", "مدير", "مهندس", "موظف", "موظف مكتب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}ৰ কৰ\u{9cd}মী"),
            keywords: &[
                "আৰ\u{9cd}কিটেক\u{9cd}ট",
                "ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}ৰ কৰ\u{9cd}মী",
                "বগ\u{9be}-কল\u{9be}ৰ",
                "ব\u{9cd}যৱস\u{9be}য\u{9bc}",
                "মেনেজ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ofis işçisi"),
            keywords: &["ağ yaxalıqlı", "biznes", "memar", "menecer", "ofis işçisi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("службовец"),
            keywords: &["белы каўнер", "бізнес", "менеджар", "офіс", "службовец"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("служител"),
            keywords: &[
                "архитект",
                "бизнес",
                "костюм",
                "мениджър",
                "служител",
                "служител в офис",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অফিস কর\u{9cd}মী"),
            keywords: &[
                "অফিস কর\u{9cd}মী",
                "উচ\u{9cd}চ পদস\u{9cd}থ কর\u{9cd}মকর\u{9cd}ত\u{9be}",
                "ব\u{9cd}যবস\u{9be}",
                "ম\u{9cd}য\u{9be}নেজ\u{9be}র",
                "স\u{9cd}থপতি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("radnik u kancelariji"),
            keywords: &[
                "arhitekta",
                "bijela kragna",
                "menadžer",
                "poslovanje",
                "radnik u kancelariji",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("treballador d’oficina"),
            keywords: &["arquitecte", "negoci", "oficina", "treballador d’oficina"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᎸᏫᏍᏓᏁᏗᎢ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᏓᏅᏖᏟᏙᎯ",
                "ᎤᏁᎦ-ᎤᎩᏝᏝᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᎤᏙᏢᏒᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗᎢ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᏗᏟᎶᏍᏔᏅᎲᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("manažer/manažerka"),
            keywords: &[
                "architekt",
                "architektka",
                "byznys",
                "bílý límeček",
                "kancelář",
                "manažer",
                "manažer/manažerka",
                "manažerka",
                "úřednice",
                "úředník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr swyddfa"),
            keywords: &[
                "busnes",
                "coler wen",
                "gweithiwr swyddfa",
                "pensaer",
                "rheolwr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kontormedarbejder"),
            keywords: &[
                "arkitekt",
                "business",
                "forretningsmand",
                "funktionær",
                "kontor",
                "kontoransat",
                "kontormedarbejder",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Büroangestellte(r)"),
            keywords: &[
                "Architekt",
                "Business",
                "Büroangestellte(r)",
                "Manager",
                "Schlips und Kragen",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Büroangestellte(r)"),
            keywords: &["Architekt", "Business", "Büroangestellte(r)", "Manager"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υπάλληλος γραφείου"),
            keywords: &[
                "αρχιτέκτονας",
                "διευθυντής",
                "επιχείρηση",
                "υπάλληλος",
                "υπάλληλος γραφείου",
                "υπεύθυνος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("office worker"),
            keywords: &[
                "architect",
                "business",
                "manager",
                "office worker",
                "white-collar",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("oficinista"),
            keywords: &[
                "arquitecto",
                "director",
                "ejecutivo",
                "empresa",
                "oficinista",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("oficinista"),
            keywords: &["oficinista"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("profesional"),
            keywords: &[
                "arquitecto",
                "director",
                "ejecutivo",
                "empresa",
                "profesional",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kontoritöötaja"),
            keywords: &[
                "ametnik",
                "arhitekt",
                "juhataja",
                "kontoritöötaja",
                "valgekrae",
                "ärimees",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bulegaria"),
            keywords: &[
                "alkandora",
                "arkitekto",
                "bulegaria",
                "enpresa",
                "kudeatzaile",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارمند"),
            keywords: &["مدیر", "معمار", "کارمند", "کارمند اداری", "کسب و کار"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("toimistotyöntekijä"),
            keywords: &[
                "arkkitehti",
                "toimisto",
                "toimistotyöntekijä",
                "valkokaulus",
                "yritys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("trabahador sa opisina"),
            keywords: &[
                "arkitekto",
                "business",
                "manager",
                "puting collar",
                "trabahador sa opisina",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrivstovufólk"),
            keywords: &["embætisfólk", "handilsfólk", "skrivstovufólk", "starvsfólk"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("employé de bureau (tous genres)"),
            keywords: &[
                "affaires",
                "architecte",
                "bureau",
                "employé de bureau",
                "employé de bureau (tous genres)",
                "employée de bureau",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("employé de bureau"),
            keywords: &[
                "affaires",
                "architecte",
                "cadre",
                "col blanc",
                "employé de bureau",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí oifige"),
            keywords: &["oibrí oifige"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach-obrach oifise"),
            keywords: &[
                "ailtire",
                "gnothachas",
                "gnìomhachas",
                "manaidsear",
                "neach-obrach oifise",
                "oifis",
                "stiùiriche",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("oficinista"),
            keywords: &["administrativo", "empregado", "oficinista"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑફિસ કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "આર\u{acd}કિટ\u{ac7}ક\u{acd}ટ",
                "ઑફિસ કાર\u{acd}યકર\u{acd}તા",
                "વ\u{acd}યવસાય",
                "વ\u{acd}હાઇટ-કૉલર",
                "સ\u{a82}ચાલક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עובד/ת משרד"),
            keywords: &["איש עסקים", "משרד", "עובד/ת משרד", "צווארון לבן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कार\u{94d}यालय कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "कर\u{94d}मचारी",
                "कार\u{94d}यालय कार\u{94d}यकर\u{94d}ता",
                "प\u{94d}रब\u{902}धक",
                "वास\u{94d}त\u{941}कार",
                "व\u{94d}यवसाय",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uredski djelatnik"),
            keywords: &[
                "arhitekt",
                "menadžer",
                "poslovni čovjek",
                "službenik",
                "uredski djelatnik",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("irodai dolgozó"),
            keywords: &[
                "irodai dolgozó",
                "menedzser",
                "építész",
                "értelmiségi",
                "üzletember",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրասենյակային աշխատող"),
            keywords: &[
                "գործարար",
                "գրասենյակային աշխատող",
                "կառավարիչ",
                "ճարտարապետ",
                "սպիտակ օձիք",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja kantoran"),
            keywords: &[
                "arsitek",
                "bisnis",
                "kerah putih",
                "manajer",
                "pekerja kantoran",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skrifstofustarfsmaður"),
            keywords: &[
                "arkítekt",
                "hvítflibbi",
                "skrifstofustarfsmaður",
                "viðskipti",
                "yfirmaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che fa un lavoro d’ufficio"),
            keywords: &[
                "architetto",
                "business",
                "impiegato",
                "manager",
                "persona che fa un lavoro d’ufficio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("会社員"),
            keywords: &["サラリーマン", "ビジネスパーソン", "会社員"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pegawe"),
            keywords: &["arsitek", "bisnis", "manajer", "pegawe", "pegawe kantor"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ოფისის თანამშრომელი"),
            keywords: &[
                "არქიტექტორი",
                "ბიზნესი",
                "დირექტორი",
                "მენეჯერი",
                "ოფისის თანამშრომელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кеңсе қызметкері"),
            keywords: &[
                "архитектор",
                "бизнес",
                "кеңсе қызметкері",
                "кеңседе жұмыс істейтін қызметкер",
                "менеджер",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}គ\u{17d2}គល\u{17b7}កការ\u{17b7}យាល\u{17d0}យ"),
            keywords: &[
                "ធ\u{17bb}រក\u{17b7}ច\u{17d2}ច",
                "ប\u{17bb}គ\u{17d2}គល\u{17b7}កការ\u{17b7}យាល\u{17d0}យ",
                "ស\u{17d2}ថាបត\u{17d2}យករ",
                "អ\u{17d2}នកគ\u{17d2}រប\u{17cb}គ\u{17d2}រង",
                "អ\u{17d2}នកធ\u{17d2}វើការក\u{17d2}ន\u{17bb}ងការ\u{17b7}យាល\u{17d0}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಛೇರ\u{cbf}ಯ ಕ\u{cc6}ಲಸಗಾರ"),
            keywords: &[
                "ಕಛೇರ\u{cbf}ಯ ಕ\u{cc6}ಲಸಗಾರ",
                "ನ\u{cbf}ರ\u{ccd}ವಾಹಕ",
                "ಬ\u{cbf}ಳ\u{cbf} - ಕಾಲರ\u{ccd}",
                "ವಾಸ\u{ccd}ತುವ\u{cbf}ನ\u{ccd}ಯಾಸಕಾರ",
                "ವ\u{ccd}ಯಾಪಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("회사원"),
            keywords: &["건축가", "관리자", "매니저", "화이트칼라", "회사원"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कच\u{947}र\u{947}\u{902}तलो कर\u{94d}मचारी"),
            keywords: &[
                "ऑफिस कर\u{94d}मचारी",
                "कच\u{947}र\u{947}\u{902}तलो कर\u{94d}मचारी",
                "कच\u{947}र\u{947}\u{902}तलो कामगार",
                "म\u{945}न\u{947}जर",
                "वास\u{94d}त\u{941}शास\u{94d}त\u{94d}रज\u{94d}ञ",
                "वास\u{94d}त\u{941}शिल\u{94d}पशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "व\u{947}वसाय",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кеңсе кызматкери"),
            keywords: &["кеңсе кызматкери"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{eb1}ກງານຫ\u{ec9}ອງການ"),
            keywords: &[
                "ບ\u{ecd}ລ\u{eb4}ຫານ",
                "ຜ\u{eb9}\u{ec9}ຈ\u{eb1}ດການ",
                "ພະນ\u{eb1}ກງານຫ\u{ec9}ອງການ",
                "ສະຖາປານ\u{eb4}ກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dirbantysis biure"),
            keywords: &[
                "architektas",
                "balta apykaklė",
                "dirbantysis biure",
                "vadybininkas",
                "verslas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis biroja darbinieks"),
            keywords: &[
                "arhitekts",
                "baltā apkaklīte",
                "pārvaldnieks",
                "uzņēmējs",
                "vīrietis biroja darbinieks",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("канцелариски работник"),
            keywords: &["архитект", "бизнис", "канцелариски работник", "менаџер"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓഫീസ\u{d4d} ജോലിക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "ആർക\u{d4d}കിടെക\u{d4d}റ\u{d4d}റ\u{d4d}",
                "ഓഫീസ\u{d4d} ജോലിക\u{d4d}ക\u{d3e}രൻ",
                "ബിസിനസ\u{d4d}",
                "മ\u{d3e}നേജർ",
                "വെള\u{d4d}ളക\u{d4d}കോളർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("оффисын ажилтан"),
            keywords: &[
                "архитектор",
                "бизнес",
                "менежер",
                "оффисын ажилтан",
                "цагаан захтан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कार\u{94d}यालयात काम करणारा"),
            keywords: &[
                "कार\u{94d}यालया\u{902}मध\u{94d}\u{200d}य\u{947} प\u{94d}रतिष\u{94d}ठित काम करणारा",
                "कार\u{94d}यालयात काम करणारा",
                "वास\u{94d}त\u{941}शिल\u{94d}पकार",
                "व\u{94d}यवसाय",
                "व\u{94d}यवस\u{94d}थापक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja pejabat"),
            keywords: &[
                "arkitek",
                "kolar putih",
                "pekerja pejabat",
                "pengurus",
                "perniagaan",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{102f}\u{1036}းဝန\u{103a}ထမ\u{103a}း"),
            keywords: &[
                "ဗ\u{102d}သ\u{102f}ကာ ပညာရ\u{103e}င\u{103a}",
                "မန\u{103a}နေဂျာ",
                "ရ\u{102f}\u{1036}းဝန\u{103a}ထမ\u{103a}း",
                "လ\u{102f}ပ\u{103a}ငန\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kontorarbeider"),
            keywords: &["kontor", "kontorarbeider", "leder", "næringsliv"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}यालय कर\u{94d}मचारी"),
            keywords: &[
                "आर\u{94d}किट\u{947}क\u{94d}ट",
                "कार\u{94d}यालय कर\u{94d}मचारी",
                "प\u{94d}रबन\u{94d}धक",
                "व\u{94d}यापार",
                "स\u{947}तो-कलर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kantoormedewerker"),
            keywords: &["architect", "bedrijf", "kantoormedewerker", "manager"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kontorarbeidar"),
            keywords: &["kontor", "kontorarbeidar", "leiar", "næringsliv"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ଳୟ କର\u{b4d}ମଚ\u{b3e}ରୀ"),
            keywords: &[
                "କ\u{b3e}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ଳୟ କର\u{b4d}ମଚ\u{b3e}ରୀ",
                "ଧଳ\u{b3e}-କଲ\u{b3e}ର",
                "ପର\u{b3f}ଚ\u{b3e}ଳକ",
                "ବ\u{b4d}ୟବସ\u{b3e}ୟ",
                "ସ\u{b4d}ଥପତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਫ\u{a3c}ਤਰ ਕਰਮਚਾਰੀ"),
            keywords: &[
                "ਆਫਿਸ ਵਰਕਰ",
                "ਆਰਕੀਟ\u{a48}ਕਟ",
                "ਦਫਤਰ",
                "ਦਫ\u{a3c}ਤਰ ਕਰਮਚਾਰੀ",
                "ਬ\u{a70}ਦਾ",
                "ਮ\u{a48}ਨ\u{a47}ਜਰ",
                "ਸਫ\u{a48}ਦ-ਕਾਲਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ọ\u{301}fís Wọ\u{301}ka"),
            keywords: &[
                "Bíznẹs",
                "Máníja",
                "To Wọ\u{301}k Fọ Ọ\u{301}fis Ínstẹ\u{301}d Ọf Fáktri",
                "Ákítẹkt",
                "Ọ\u{301}fís Wọ\u{301}ka",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pracownik biurowy"),
            keywords: &[
                "architekt",
                "biznesmen",
                "menedżer",
                "praca biurowa",
                "pracownik biurowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دفتري کارمند"),
            keywords: &["دفتري کارمند", "سپين کالر", "مدير", "مهندس", "کاروبار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("trabalhador de escritório"),
            keywords: &[
                "arquiteto",
                "colarinho branco",
                "gerente",
                "negócios",
                "trabalhador de escritório",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("empregado de escritório"),
            keywords: &[
                "arquiteto",
                "empregado de escritório",
                "gerente",
                "negócios",
                "trabalhador de escritório",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("oficina llamkaq"),
            keywords: &[
                "kamachiq",
                "oficina llamkaq",
                "oficinista",
                "qatuna",
                "wasi k’achanchaq",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("funcționar sau funcționară"),
            keywords: &[
                "arhitect",
                "director",
                "funcționar sau funcționară",
                "guler alb",
                "manager",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-015"),
            keywords: &["E13-015"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("офисный работник"),
            keywords: &[
                "белый воротничок",
                "бизнес",
                "менеджер",
                "офис",
                "офисный работник",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آفيس ورڪر"),
            keywords: &["آرڪيٽيڪٽ", "آفيس ورڪر", "سفيد-پوش", "مئنيجر", "ڪاروبار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}ර\u{dca}ය\u{dcf}ල සේවකය\u{dcf}"),
            keywords: &[
                "කළමන\u{dcf}කර\u{dd4}",
                "ක\u{dcf}ර\u{dca}ය\u{dcf}ල සේවකය\u{dcf}",
                "ගෘහ න\u{dd2}ර\u{dca}ම\u{dcf}ණ ශ\u{dd2}ල\u{dca}ප\u{dd2}ය\u{dcf}",
                "ව\u{dca}\u{200d}ය\u{dcf}ප\u{dcf}ර",
                "ස\u{dd4}ද\u{dd4} කොලරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pracovník v kancelárii"),
            keywords: &["kancelária", "manažér", "pracovník v kancelárii", "úradník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("delavec v pisarni"),
            keywords: &[
                "arhitekt",
                "delavec v pisarni",
                "direktor",
                "pisarniški delavec",
                "podjetje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("shaqaale xafiis"),
            keywords: &[
                "ajitekjar, ganacsi, maamule, shaqaale xafiis, white-collar",
                "shaqaale xafiis",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person punonjës zyre"),
            keywords: &[
                "arkitekt",
                "biznes",
                "menaxher",
                "person punonjës zyre",
                "punonjës zyre",
                "zyrtar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("канцеларијски радник"),
            keywords: &["архитекта", "бизнис", "канцеларијски радник", "менаџер"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kancelarijski radnik"),
            keywords: &["arhitekta", "biznis", "kancelarijski radnik", "menadžer"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kontorist"),
            keywords: &[
                "affärsman",
                "arkitekt",
                "kontorist",
                "tjänsteman",
                "ämbetsman",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mfanyakazi wa ofisi"),
            keywords: &[
                "biashara",
                "kazi ya ofisi",
                "meneja",
                "mfanyakazi wa ofisi",
                "msanifu majengo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அலுவலகப\u{bcd} பணிய\u{bbe}ளர\u{bcd}"),
            keywords: &[
                "அலுவலகப\u{bcd} பணிய\u{bbe}ளர\u{bcd}",
                "கட\u{bcd}டிடக\u{bcd}கலை",
                "மேல\u{bbe}ளர\u{bcd}",
                "வணிக",
                "வைட\u{bcd} க\u{bbe}லர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}ర\u{c4d}య\u{c3e}లయ ఉద\u{c4d}య\u{c4b}గ\u{c3f}"),
            keywords: &[
                "ఆర\u{c4d}క\u{c3f}ట\u{c46}క\u{c4d}ట\u{c4d}",
                "క\u{c3e}ర\u{c4d}య\u{c3e}లయ ఉద\u{c4d}య\u{c4b}గ\u{c3f}",
                "ప\u{c4d}రభుత\u{c4d}వ ఉద\u{c4d}య\u{c4b}గులు",
                "మ\u{c47}న\u{c47}జర\u{c4d}",
                "వ\u{c4d}య\u{c3e}ప\u{c3e}రం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พน\u{e31}กงานออฟฟ\u{e34}ศ"),
            keywords: &[
                "ธ\u{e38}รก\u{e34}จ",
                "ผ\u{e39}\u{e49}จ\u{e31}ดการ",
                "พน\u{e31}กงานบร\u{e34}ษ\u{e31}ท",
                "พน\u{e31}กงานออฟฟ\u{e34}ศ",
                "สถาปน\u{e34}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("edara işçisi"),
            keywords: &[
                "ak ýaka",
                "binagär",
                "dolandyryjy",
                "edara işçisi",
                "işewürlik",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ngāue ʻōfisi"),
            keywords: &["tokotaha ngāue ʻōfisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ofis çalışanı"),
            keywords: &[
                "beyaz yakalı",
                "iş yeri",
                "mimar",
                "müdür",
                "ofis çalışanı",
                "yönetici",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("офісний працівник"),
            keywords: &[
                "архітектор",
                "бізнес",
                "білий комірець",
                "менеджер",
                "офісний працівник",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آفس ورکر"),
            keywords: &["آفس ورکر", "ماہر تعمیرات", "مینیجر", "وائٹ کالر", "کاروبار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ofis xodimi"),
            keywords: &[
                "arxitektor",
                "biznes",
                "menejer",
                "ofis ishchisi",
                "ofis xodimi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân viên văn phòng"),
            keywords: &[
                "công việc văn phòng",
                "kinh doanh",
                "kiến trúc sư",
                "người quản lý",
                "nhân viên văn phòng",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("辦公室員工"),
            keywords: &["商業", "建築師", "白領", "經理", "辦公室員工"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("办公室员工"),
            keywords: &["办公室员工", "商业", "建筑师", "白领", "经理"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("白领"),
            keywords: &["商人", "建筑师", "白领", "经理"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("上班族"),
            keywords: &["上班族", "商務", "白領", "經理"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wase-ofisi"),
            keywords: &[
                "ibhizinisi",
                "imenenja",
                "isiphika esimhlophe",
                "umakhi",
                "umsebenzi wase-ofisi",
            ],
        },
    ],
};
#[doc = "🧑🏻\u{200d}💼"]
pub const OFFICE_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}💼",
    codepoint: "1F9D1 1F3FB 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "office worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}💼"]
pub const OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}💼",
    codepoint: "1F9D1 1F3FC 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "office worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}💼"]
pub const OFFICE_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}💼",
    codepoint: "1F9D1 1F3FD 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "office worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}💼"]
pub const OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}💼",
    codepoint: "1F9D1 1F3FE 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "office worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}💼"]
pub const OFFICE_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}💼",
    codepoint: "1F9D1 1F3FF 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "office worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}💼"]
pub const MAN_OFFICE_WORKER: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}💼",
    codepoint: "1F468 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man office worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike kantoorwerker"),
            keywords: &[
                "besigheid",
                "bestuurder",
                "kantoorwerker",
                "manlike kantoorwerker",
                "witboordjie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ የቢሮ ሰራተኛ"),
            keywords: &["መሐንዲስ", "ንግድ", "አስተዳዳሪ", "ወንድ", "ወንድ የቢሮ ሰራተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موظف"),
            keywords: &["شركة", "مدير", "مكتب", "موظف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "প\u{9c1}ৰ\u{9c1}ষ ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}ৰ কৰ\u{9cd}মচ\u{9be}ৰী",
            ),
            keywords: &[
                "অফিচ\u{9be}ৰ",
                "আৰ\u{9cd}কিটেক\u{9cd}ট",
                "ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}ৰ কৰ\u{9cd}মচ\u{9be}ৰী",
                "ব\u{9cd}যৱস\u{9be}য\u{9bc}",
                "মেনেজ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi ofis işçisi"),
            keywords: &[
                "ağ yaxalıqlı",
                "biznes",
                "kişi",
                "kişi ofis işçisi",
                "memar",
                "menecer",
                "ofis",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("служачы"),
            keywords: &[
                "белы каўнер",
                "бізнес",
                "менеджар",
                "мужчына",
                "офіс",
                "служачы",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("служител в офис"),
            keywords: &["бизнес", "костюм", "мениджър", "служител в офис"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলে , প\u{9c1}র\u{9c1}ষ , অফিস কর\u{9cd}মি"),
            keywords: &[
                "অফিস কর\u{9cd}মি",
                "আর\u{9cd}কিটেক\u{9cd}ট",
                "ছেলে , প\u{9c1}র\u{9c1}ষ , অফিস কর\u{9cd}মি",
                "প\u{9c1}র\u{9c1}ষ",
                "ম\u{9cd}য\u{9be}নেজ\u{9be}র",
                "হোয\u{9bc}\u{9be}ইট - কল\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("implijad"),
            keywords: &["implijad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac u kancelariji"),
            keywords: &[
                "bijela kragna",
                "menadžer",
                "muškarac u kancelariji",
                "posao",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home treballador d’oficina"),
            keywords: &[
                "arquitecte",
                "home",
                "home treballador d’oficina",
                "negoci",
                "oficina",
                "treballador d’oficina",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏬᏟ ᏧᎸᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᏍᎦᏯ",
                "ᎠᏍᎦᏯ ᎤᏬᏟ ᏧᎸᏫᏍᏓᏁᎯ",
                "ᎠᏓᏅᏖᏟᏙᎯ",
                "ᎤᏁᎦ ᎤᎦᏝᏝᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗᎢ ᎤᏙᏢᏒ",
                "ᏗᏟᎶᏍᏔᏅᎲᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("manažer"),
            keywords: &[
                "byznys",
                "bílý límeček",
                "kancelář",
                "manažer",
                "muž",
                "úředník",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr swyddfa gwrywaidd"),
            keywords: &[
                "busnes",
                "dyn",
                "gweithiwr swyddfa gwrywaidd",
                "pensaer",
                "swyddfa",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig kontoransat"),
            keywords: &[
                "business",
                "jakkesæt",
                "kontor",
                "kontormand",
                "mandlig kontoransat",
                "mappe",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Büroangestellter"),
            keywords: &["Angestellter", "Büro", "Büroangestellter", "Manager"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας υπάλληλος γραφείου"),
            keywords: &[
                "άντρας υπάλληλος γραφείου",
                "γραφείο",
                "επιχείρηση",
                "εταιρία",
                "υπάλληλος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man office worker"),
            keywords: &[
                "architect",
                "business",
                "man",
                "man office worker",
                "manager",
                "white-collar",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "business man",
                "man office worker",
                "manager",
                "office worker",
                "white collar",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("oficinista hombre"),
            keywords: &[
                "director",
                "ejecutivo",
                "empresa",
                "hombre",
                "oficina",
                "oficinista",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("profesional hombre"),
            keywords: &[
                "director",
                "ejecutivo",
                "empresa",
                "hombre",
                "oficina",
                "profesional",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeskontoritöötaja"),
            keywords: &[
                "arhitekt",
                "juhataja",
                "meeskontoritöötaja",
                "valgekrae",
                "ärimees",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon bulegaria"),
            keywords: &[
                "alkandora",
                "arkitektoa",
                "enpresa",
                "gizon bulegaria",
                "gizona",
                "gizonezkoa",
                "kudeatzailea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارمند مرد"),
            keywords: &["تاجر", "مدیر", "مهندس", "کارمند اداری", "کارمند مرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miestoimistotyöntekijä"),
            keywords: &[
                "mies",
                "miestoimistotyöntekijä",
                "toimisto",
                "työntekijä",
                "valkokaulus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("empleyado sa opisina"),
            keywords: &["empleyado sa opisina", "empleyedo", "kaopisina", "opisina"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrivstovumaður"),
            keywords: &[
                "arkitektur",
                "deildarstjóri",
                "løgfrøðingur",
                "maður",
                "skrivstova",
                "skrivstovumaður",
                "stjóri",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("employé de bureau"),
            keywords: &[
                "affaires",
                "architecte",
                "bureau",
                "employé de bureau",
                "homme",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("employé de bureau homme"),
            keywords: &[
                "affaires",
                "architecte",
                "bureau",
                "employé de bureau",
                "employé de bureau homme",
                "homme",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí oifige fireann"),
            keywords: &[
                "ailtire",
                "bainisteoir",
                "bóna bán",
                "fear",
                "gnó",
                "oibrí oifige fireann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-oifis fireann"),
            keywords: &[
                "ailtire",
                "duine",
                "fear",
                "fireannach",
                "gnothachas",
                "gnìomhachas manaidsear",
                "obraiche-oifis fireann",
                "oifis",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("administrativo"),
            keywords: &["administrativo", "empregado", "home", "oficinista"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ ઑફિસ કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "આર\u{acd}કિટ\u{ac7}ક\u{acd}ટ",
                "ઑફિસ",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ ઑફિસ કાર\u{acd}યકર\u{acd}તા",
                "વ\u{acd}યવસાય",
                "સ\u{a82}ચાલક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum ma’aikacin ofis"),
            keywords: &[
                "aikin ofis",
                "kasuwanci",
                "mai ilimin zane",
                "manaja",
                "mutum",
                "mutum ma’aikacin ofis",
                "ofis",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עובד משרד"),
            keywords: &[
                "אדריכל",
                "איש עסקים",
                "מנהל",
                "משרד",
                "עובד משרד",
                "פקיד",
                "צווארון לבן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष कार\u{94d}यालय कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "आदमी",
                "कार\u{94d}यालय",
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष कार\u{94d}यालय कार\u{94d}यकर\u{94d}ता",
                "प\u{94d}रब\u{902}धक",
                "वास\u{94d}त\u{941}कार",
                "व\u{94d}यापार",
                "सफ\u{947}द कॉलर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("službenik"),
            keywords: &[
                "arhitekt",
                "menadžer",
                "poslovni čovjek",
                "službenik",
                "ured",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi irodista"),
            keywords: &["alkalmazott", "férfi", "férfi irodista", "irodai"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ գրասենյակի աշխատող"),
            keywords: &[
                "բիզնես",
                "գրասենյակ",
                "ղեկավար",
                "տղամարդ",
                "տղամարդ գրասենյակի աշխատող",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja kantor pria"),
            keywords: &["kantor", "karyawan", "laki-laki", "pekerja kantor pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke onye ọrụ ọfịịsị"),
            keywords: &[
                "akwa-ọfịịsị",
                "azụmaahịa",
                "nwoke",
                "nwoke onye ọrụ ọfịịsị",
                "onyenjikwa",
                "ọfịịsị",
                "ọkammụta eserese",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns skrifstofustarfsmaður"),
            keywords: &[
                "karl",
                "karlkyns skrifstofustarfsmaður",
                "skrifstofa",
                "stjórnandi",
                "viðskipti",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("impiegato"),
            keywords: &[
                "architetto",
                "business",
                "impiegato",
                "manager",
                "ufficio",
                "uomo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性会社員"),
            keywords: &[
                "サラリーマン",
                "ビジネスパーソン",
                "ビジネスマン",
                "会社員",
                "男性",
                "男性会社員",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pegawe kantor lanang"),
            keywords: &[
                "arsitek",
                "bisnis",
                "lanang",
                "manajer",
                "pegawe",
                "pegawe kantor lanang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თანამშრომელი კაცი"),
            keywords: &[
                "არქიტექტურა",
                "ბიზნესი",
                "თანამშრომელი კაცი",
                "კაცი",
                "მენეჯერი",
                "ოფისი",
                "სამსახური",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кеңседе жұмыс істейтін қызметкер"),
            keywords: &[
                "бизнес",
                "ер",
                "кеңсе",
                "кеңседе жұмыс істейтін қызметкер",
                "менеджер",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kontoransat"),
            keywords: &[
                "business",
                "jakkesæt",
                "kontor",
                "kontoransat",
                "kontormand",
                "mappe",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}គ\u{17d2}គល\u{17b7}កប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ជ\u{17c6}ន\u{17bd}ញ",
                "ធ\u{17bb}រក\u{17b7}ច\u{17d2}ច",
                "ប\u{17bb}គ\u{17d2}គល\u{17b7}កការ\u{17b7}យាល\u{17d0}យ",
                "ប\u{17bb}គ\u{17d2}គល\u{17b7}កប\u{17d2}រ\u{17bb}ស",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "ស\u{17d2}ថាបត\u{17d2}យករ",
                "អ\u{17d2}នកគ\u{17d2}រប\u{17cb}គ\u{17d2}រង",
                "អ\u{17d2}នកធ\u{17d2}វើការក\u{17d2}ន\u{17bb}ងការ\u{17b7}យាល\u{17d0}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಛೇರ\u{cbf}ಯ ಪುರುಷ ಕ\u{cc6}ಲಸಗಾರ"),
            keywords: &[
                "ಕಛೇರ\u{cbf}",
                "ಕಛೇರ\u{cbf}ಯ ಕ\u{cc6}ಲಸಗಾರ",
                "ಕಛೇರ\u{cbf}ಯ ಪುರುಷ ಕ\u{cc6}ಲಸಗಾರ",
                "ಮ\u{ccd}ಯಾನೇಜರ\u{ccd}",
                "ವಾಸ\u{ccd}ತುಶ\u{cbf}ಲ\u{ccd}ಪ\u{cbf}",
                "ವ\u{ccd}ಯವಹಾರ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 회사원"),
            keywords: &[
                "건축가",
                "관리자",
                "남자",
                "남자 회사원",
                "매니저",
                "비즈니스맨",
                "샐러리맨",
                "화이트칼라",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो कच\u{947}र\u{947}\u{902}तलो कर\u{94d}मचारी"),
            keywords: &[
                "कच\u{947}र\u{947}\u{902}तलो कर\u{94d}मचारी दादलो",
                "दादलो",
                "दादलो कच\u{947}र\u{947}\u{902}तलो कर\u{94d}मचारी",
                "धवी-कॉलर",
                "व\u{947}वसाय",
                "व\u{947}वस\u{94d}थापक",
                "शिल\u{94d}पकार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек офис жумушчусу"),
            keywords: &[
                "архитектор",
                "бизнес",
                "мамлекеттик кызматкер",
                "офис менеджер",
                "эркек",
                "эркек офис жумушчусу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Employé"),
            keywords: &[
                "Architekt",
                "Büro",
                "Employé",
                "Geschäft",
                "Manager",
                "Mann",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{eb1}ກງານຫ\u{ec9}ອງການຊາຍ"),
            keywords: &[
                "ທ\u{eb8}ລະກ\u{eb4}ດ",
                "ຜ\u{eb9}\u{ec9}ຈ\u{eb1}ດການ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ພະນ\u{eb1}ກງານ",
                "ພະນ\u{eb1}ກງານຫ\u{ec9}ອງການຊາຍ",
                "ສະຖາປະນ\u{eb4}ກ",
                "ຫ\u{ec9}ອງການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("biuro darbuotojas"),
            keywords: &[
                "architektas",
                "biuras",
                "biuro darbuotojas",
                "darbas įstaigoje",
                "vadybininkas",
                "verslas",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("biroja darbinieks"),
            keywords: &[
                "arhitekts",
                "baltās apkaklītes",
                "biroja darbinieks",
                "birojs",
                "menedžeris",
                "uzņēmējdarbība",
                "virietis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaimahi tari tāne"),
            keywords: &[
                "kaihoahoa whare",
                "kaimahi tari tāne",
                "kaiwhakahaere",
                "kara-mā",
                "pakihi",
                "tari",
                "tāne",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("административец"),
            keywords: &[
                "административец",
                "архитект",
                "бизнисмен",
                "канцеларија",
                "маж",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓഫീസ\u{d4d} ജീവനക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "ഉദ\u{d4d}യോഗസ\u{d4d}ഥൻ",
                "ഓഫീസ\u{d4d}",
                "ഓഫീസ\u{d4d} ജീവനക\u{d4d}ക\u{d3e}രൻ",
                "ബിസിനസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй оффисын ажилтан"),
            keywords: &[
                "архитект",
                "бизнес",
                "менежер",
                "оффисын ажилтан эрэгтэй",
                "эрэгтэй",
                "эрэгтэй оффисын ажилтан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{941}ष ऑफिस कर\u{94d}मचारी"),
            keywords: &[
                "ऑफिस व\u{94d}हाईट-कॉलर",
                "प\u{941}र\u{941}ष ऑफिस कर\u{94d}मचारी",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष ऑफिस कर\u{94d}मचारी",
                "वास\u{94d}त\u{941}शास\u{94d}त\u{94d}रज\u{94d}ञ",
                "व\u{94d}यवसाय",
                "व\u{94d}यवस\u{94d}थापक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja pejabat lelaki"),
            keywords: &[
                "arkitek",
                "kolar putih",
                "lelaki",
                "pejabat",
                "pekerja pejabat lelaki",
                "pengurus",
                "perniagaan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jaħdem f’uffiċċju"),
            keywords: &[
                "maniġer",
                "negozju",
                "perit",
                "raġel",
                "raġel jaħdem f’uffiċċju",
                "uffiċċju",
                "ħaddiema professjonali",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား ရ\u{102f}\u{1036}းဝန\u{103a}ထမ\u{103a}း"),
            keywords: &[
                "ဉာဏလ\u{102f}ပ\u{103a}သား",
                "ဗ\u{102d}သ\u{102f}ကာ ပညာရ\u{103e}င\u{103a}",
                "မန\u{103a}နေဂျာ",
                "လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "အမျ\u{102d}\u{102f}းသား ရ\u{102f}\u{1036}းဝန\u{103a}ထမ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig kontorarbeider"),
            keywords: &[
                "kontor",
                "leder",
                "mann",
                "mannlig kontorarbeider",
                "næringsliv",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}यालयको प\u{941}र\u{942}षकर\u{94d}मी"),
            keywords: &[
                "आर\u{94d}किट\u{947}क\u{94d}ट",
                "कार\u{94d}यालयको प\u{941}र\u{942}षकर\u{94d}मी",
                "प\u{941}र\u{942}ष",
                "प\u{94d}रबन\u{94d}धक",
                "व\u{94d}यवसाय",
                "स\u{947}तो रङ\u{94d}गको कठालो भएको ल\u{941}गा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke kantoormedewerker"),
            keywords: &[
                "architect",
                "bedrijf",
                "kantoor",
                "kantoormedewerker",
                "man",
                "manager",
                "mannelijke kantoormedewerker",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg kontorarbeidar"),
            keywords: &[
                "kontor",
                "leiar",
                "mann",
                "mannleg kontorarbeidar",
                "næringsliv",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ କ\u{b3e}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ଳୟ କର\u{b4d}ମଚ\u{b3e}ରୀ"),
            keywords: &[
                "ଧଳ\u{b3e}-ଗଳ\u{b3e}ବନ\u{b4d}ଧ",
                "ପର\u{b3f}ଚ\u{b3e}ଳକ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ କ\u{b3e}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ଳୟ କର\u{b4d}ମଚ\u{b3e}ରୀ",
                "ବ\u{b4d}ୟବସ\u{b3e}ୟ",
                "ସ\u{b4d}ଥପତ\u{b3f}ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ବ\u{b3f}ତ\u{b4d}\u{200c} ବ\u{b3e} ଆର\u{b4d}କ\u{b3f}ଟେକ\u{b4d}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਆਫਿਸ ਵਰਕਰ"),
            keywords: &[
                "ਆਰਕੀਟ\u{a48}ਕਟ",
                "ਕਾਰ\u{a4b}ਬਾਰ",
                "ਦਫਤਰ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਆਫਿਸ ਵਰਕਰ",
                "ਬ\u{a70}ਦਾ",
                "ਮ\u{a48}ਨ\u{a47}ਜਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دفتر وچ کم کرن آلا مرد"),
            keywords: &[
                "بندہ",
                "بیوپار",
                "دفتر",
                "دفتر وچ کم کرن آلا مرد",
                "سفید پوش",
                "فن تعمیر دا ماہر",
                "منتظم",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Ọ\u{301}fís Wọ\u{301}ka"),
            keywords: &[
                "Bíznẹs",
                "Man",
                "Man Ọ\u{301}fís Wọ\u{301}ka",
                "Mán Ọ\u{301}fís Wọ\u{301}ka",
                "Máníja",
                "To Wọ\u{301}k Fọ Ọ\u{301}fis Ínstẹ\u{301}d Ọf Fáktri",
                "Ákítẹkt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna pracownik biurowy"),
            keywords: &[
                "architekt",
                "biuro",
                "biznesmen",
                "mężczyzna",
                "mężczyzna pracownik biurowy",
                "pracownik biurowy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی دفتري کارګر"),
            keywords: &[
                "سپين پوس",
                "سړی",
                "سړی دفتري کارګر",
                "منتظم",
                "مهندس",
                "کاروبار",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("funcionário de escritório"),
            keywords: &[
                "arquiteto",
                "colarinho branco",
                "empresário",
                "funcionário de escritório",
                "gerente",
                "homem",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("funcionário de escritório"),
            keywords: &[
                "administrador",
                "empresa",
                "funcionário de escritório",
                "gerente",
                "homem",
                "trabalhador de escritório",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata oficina llamkaq"),
            keywords: &[
                "kamachiq",
                "oficinista",
                "qatuna",
                "tata",
                "tata oficina llamkaq",
                "wasi k’achanchaq",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("funcționar"),
            keywords: &[
                "administrație",
                "arhitect",
                "birou",
                "business",
                "funcționar",
                "manager",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1169"),
            keywords: &["E10-1169"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("офисный работник - мужчина"),
            keywords: &[
                "белый воротничок",
                "бизнес",
                "менеджер",
                "мужчина",
                "офис",
                "офисный работник",
                "офисный работник - мужчина",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo ukorera mu biro"),
            keywords: &[
                "ibiro",
                "impuguke",
                "ubucuruzi",
                "umugabo",
                "umugabo ukorera mu biro",
                "umuhuzabikorwa",
                "umushushanyi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد آفيس ورڪر"),
            keywords: &[
                "مرد آفيس ورڪر",
                "مرد، آفيس، ڪاروبار، مينيجر، آرڪيٽيڪٽ، اڇو ڪالر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ක\u{dcf}ර\u{dca}ය\u{dcf}ල කම\u{dca}කර\u{dd4}ව\u{dcf}",
            ),
            keywords: &[
                "කළමන\u{dcf}කර\u{dd4}",
                "ක\u{dcf}ර\u{dca}ය\u{dcf}ලය",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ක\u{dcf}ර\u{dca}ය\u{dcf}ල කම\u{dca}කර\u{dd4}ව\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ව\u{dca}\u{200d}ය\u{dcf}ප\u{dcf}රය",
                "ස\u{dd4}ද\u{dd4} කොලරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pracovník v kancelárii muž"),
            keywords: &[
                "kancelária",
                "manažér",
                "muž",
                "pracovník v kancelárii muž",
                "úradník",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pisarniški delavec"),
            keywords: &[
                "arhitekt",
                "direktor",
                "fant",
                "moški",
                "pisarna",
                "pisarniški",
                "pisarniški delavec",
                "podjetje",
                "tajnik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin shaqaale xafiis ah"),
            keywords: &[
                "ganacsi",
                "maamule",
                "muhindis dhismo",
                "nin",
                "nin shaqaale xafiis ah",
                "shaqo xafiiseed",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("punonjës zyre"),
            keywords: &["arkitekt", "biznes", "burrë", "menaxher", "punonjës zyre"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац у канцеларији"),
            keywords: &[
                "асистент",
                "канцеларија",
                "мушкарац",
                "мушкарац у канцеларији",
                "секретарица",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac u kancelariji"),
            keywords: &[
                "asistent",
                "kancelarija",
                "muškarac",
                "muškarac u kancelariji",
                "sekretarica",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kontorstjänsteman"),
            keywords: &["chef", "kontor", "kontorstjänsteman", "man", "näringsliv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume aliyevaa nadhifu"),
            keywords: &["mtu", "mwanamume aliyevaa nadhifu", "suti", "tai"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} பணிய\u{bbe}ளர\u{bcd}"),
            keywords: &[
                "அதிக\u{bbe}ரி",
                "அலுவலகம\u{bcd}",
                "ஆண\u{bcd}",
                "பணிய\u{bbe}ளர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉద\u{c4d}య\u{c4b}గస\u{c4d}థుడు"),
            keywords: &[
                "ఆర\u{c4d}క\u{c3f}ట\u{c46}క\u{c4d}ట\u{c4d}",
                "ఉద\u{c4d}య\u{c4b}గస\u{c4d}థుడు",
                "న\u{c3f}ర\u{c4d}వ\u{c3e}హకుడు",
                "పురుషుడు",
                "ప\u{c4d}రభుత\u{c4d}వ ఉద\u{c4d}య\u{c4b}గులు",
                "వ\u{c4d}య\u{c3e}ప\u{c3e}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди корманди идора"),
            keywords: &[
                "идора",
                "корманди илмӣ",
                "мард",
                "марди корманди идора",
                "меъмор",
                "мудир",
                "соҳибкорӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พน\u{e31}กงานบร\u{e34}ษ\u{e31}ทชาย"),
            keywords: &[
                "ธ\u{e38}รก\u{e34}จ",
                "ผ\u{e39}\u{e49}จ\u{e31}ดการ",
                "พน\u{e31}กงานบร\u{e34}ษ\u{e31}ทชาย",
                "พน\u{e31}กงานออฟฟ\u{e34}ศ",
                "สถาปน\u{e34}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek ofis işgäri"),
            keywords: &[
                "binagär",
                "erkek",
                "erkek ofis işgäri",
                "işewürlik",
                "ofis",
                "ofis işgäri",
                "ýolbaşçy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata ngāue ʻōfisi"),
            keywords: &["tangata ngāue ʻōfisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek ofis çalışanı"),
            keywords: &[
                "adam",
                "beyaz yaka",
                "erkek",
                "erkek ofis çalışanı",
                "iş",
                "mimar",
                "ofis",
                "yönetici",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىشخانا خىزمەتچىسى ئەر"),
            keywords: &[
                "ئىشخانا",
                "ئىشخانا خىزمەتچىسى",
                "ئىشخانا خىزمەتچىسى ئەر",
                "ئەر",
                "باشقۇرغۇچى",
                "سودا",
                "لايىھەلىگۈچى",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("службовець"),
            keywords: &[
                "менеджер",
                "офіс",
                "офісний працівник",
                "службовець",
                "чоловік",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد دفتر کارکن"),
            keywords: &["دفتر", "مرد", "ملازم", "کارکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak ofis xodimi"),
            keywords: &[
                "arxitektor",
                "biznes",
                "erkak ofis xodimi",
                "menejer",
                "ofis",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân viên văn phòng nam"),
            keywords: &[
                "công việc văn phòng",
                "kinh doanh",
                "kiến trúc sư",
                "người quản lý",
                "người đàn ông",
                "nhân viên văn phòng nam",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kuy liggéey ci biro"),
            keywords: &[
                "arsitek",
                "biro",
                "bisnes",
                "góor",
                "kuy liggéey ci biro",
                "liggéeykat bu xarañ",
                "njiit",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsebenzi waseofisini oyindoda"),
            keywords: &[
                "ikhola emhlophe",
                "indoda",
                "iofisi",
                "ishishini",
                "umanejala",
                "umsebenzi waseofisini oyindoda",
                "umyili wezakhiwo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin òṣìṣẹ\u{301} ọ\u{301}físì"),
            keywords: &[
                "alábóòjútò",
                "iṣẹ\u{301} ọ\u{301}físì",
                "olùyà ilé",
                "òwò",
                "ọkùnrin",
                "ọkùnrin òṣìṣẹ\u{301} ọ\u{301}físì",
                "ọ\u{301}físì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男辦公室職員"),
            keywords: &[
                "建築師",
                "業務",
                "男",
                "男辦公室職員",
                "白領",
                "經理",
                "辦公室",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男办公室职员"),
            keywords: &[
                "业务",
                "办公室",
                "建筑师",
                "男",
                "男办公室职员",
                "白领",
                "经理",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男白领"),
            keywords: &["商人", "建筑师", "男白领", "经理"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男性上班族"),
            keywords: &["上班族", "男", "男性上班族", "白領"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男職員"),
            keywords: &["上班族", "男", "男職員", "白領", "職員"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wasehhovisi wesilisa"),
            keywords: &[
                "ihhovisi",
                "indoda",
                "osebenza kahle",
                "umphathi",
                "umsebenzi wasehhovisi wesilisa",
                "usomabhizinisi",
            ],
        },
    ],
};
#[doc = "👨🏻\u{200d}💼"]
pub const MAN_OFFICE_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}💼",
    codepoint: "1F468 1F3FB 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man office worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}💼"]
pub const MAN_OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}💼",
    codepoint: "1F468 1F3FC 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man office worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}💼"]
pub const MAN_OFFICE_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}💼",
    codepoint: "1F468 1F3FD 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man office worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}💼"]
pub const MAN_OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}💼",
    codepoint: "1F468 1F3FE 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man office worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}💼"]
pub const MAN_OFFICE_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}💼",
    codepoint: "1F468 1F3FF 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man office worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}💼"]
pub const WOMAN_OFFICE_WORKER: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}💼",
    codepoint: "1F469 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman office worker",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike kantoorwerker"),
            keywords: &[
                "besigheid",
                "bestuurder",
                "kantoorwerker",
                "vroulike kantoorwerker",
                "witboordjie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት የቢሮ ሰራተኛ"),
            keywords: &["መሐንዲስ", "ሴት", "ሴት የቢሮ ሰራተኛ", "ንግድ", "አስተዳዳሪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موظفة"),
            keywords: &["شركة", "مديرة", "مكتب", "موظفة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "মহিল\u{9be} ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}ৰ কৰ\u{9cd}মচ\u{9be}ৰী",
            ),
            keywords: &[
                "অফিচ\u{9be}ৰ",
                "আৰ\u{9cd}কিটেক\u{9cd}ট",
                "ক\u{9be}ৰ\u{9cd}য\u{9cd}যলয\u{9bc}",
                "ব\u{9cd}যৱস\u{9be}য\u{9bc}",
                "মহিল\u{9be}",
                "মহিল\u{9be} ক\u{9be}ৰ\u{9cd}য\u{9cd}য\u{9be}লয\u{9bc}ৰ কৰ\u{9cd}মচ\u{9be}ৰী",
                "মেনেজ\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın ofis işçisi"),
            keywords: &[
                "ağ yaxalıqlı",
                "biznes",
                "memar",
                "menecer",
                "ofis",
                "qadın",
                "qadın ofis işçisi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("служачая"),
            keywords: &[
                "белы каўнер",
                "бізнес",
                "жанчына",
                "менеджар",
                "офіс",
                "служачая",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("служителка в офис"),
            keywords: &["бизнес", "жена мениджър", "костюм", "служителка в офис"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}ে , মহিল\u{9be} , অফিস কর\u{9cd}মি"),
            keywords: &[
                "অফিস কর\u{9cd}মি",
                "আর\u{9cd}কিটেক\u{9cd}ট",
                "মহিল\u{9be}",
                "মেয\u{9bc}ে , মহিল\u{9be} , অফিস কর\u{9cd}মি",
                "ম\u{9cd}য\u{9be}নেজ\u{9be}র",
                "হোয\u{9bc}\u{9be}ইট - কল\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("implijadez"),
            keywords: &["implijadez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena u kancelariji"),
            keywords: &[
                "arhitekta",
                "bijela kragna",
                "menadžer",
                "posao",
                "žena",
                "žena u kancelariji",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("treballadora d’oficina"),
            keywords: &[
                "arquitecta",
                "dona",
                "negoci",
                "oficina",
                "treballadora d’oficina",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏗᎦᎸᏫᏍᏓᏁᏗ ᏧᏄᏫᏍᏓᏁᎯ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᏗᎦᎸᏫᏍᏓᏁᏗ ᏧᏄᏫᏍᏓᏁᎯ",
                "ᎠᏓᏅᏖᏟᏙᎯ",
                "ᎤᏁᎦ-ᎤᎩᏝᏝᎢ",
                "ᏗᎦᎸᏫᏍᏓᏁᏗ ᎤᏙᏢᏒᎢ",
                "ᏗᏟᎶᏍᏔᏅᎲᏍᎩ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("manažerka"),
            keywords: &[
                "byznys",
                "bílý límeček",
                "kancelář",
                "manažerka",
                "úřednice",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gweithiwr swyddfa benywaidd"),
            keywords: &[
                "busnes",
                "gweithiwr swyddfa benywaidd",
                "menyw",
                "pensaer",
                "swyddfa",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig kontoransat"),
            keywords: &[
                "business",
                "kontor",
                "kvinde",
                "kvindelig kontoransat",
                "mappe",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Büroangestellte"),
            keywords: &["Angestellte", "Büro", "Büroangestellte", "Mangerin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα υπάλληλος γραφείου"),
            keywords: &[
                "γραφείο",
                "γυναίκα υπάλληλος γραφείου",
                "επιχείρηση",
                "εταιρία",
                "υπάλληλος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman office worker"),
            keywords: &[
                "architect",
                "business",
                "manager",
                "white-collar",
                "woman",
                "woman office worker",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &[
                "business woman",
                "manager",
                "office worker",
                "white collar",
                "woman office worker",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("oficinista mujer"),
            keywords: &[
                "directora",
                "ejecutiva",
                "empresa",
                "mujer",
                "oficina",
                "oficinista",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("profesional mujer"),
            keywords: &[
                "directora",
                "ejecutiva",
                "empresa",
                "mujer",
                "oficina",
                "profesional",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naiskontoritöötaja"),
            keywords: &[
                "arhitekt",
                "juhataja",
                "naiskontoritöötaja",
                "valgekrae",
                "ärinaine",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume bulegaria"),
            keywords: &[
                "alkandora",
                "arkitektoa",
                "emakume bulegaria",
                "emakumea",
                "emakumezkoa",
                "enpresa",
                "kudeatzailea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("کارمند زن"),
            keywords: &["تاجر", "مدیر", "مهندس", "کارمند اداری", "کارمند زن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naistoimistotyöntekijä"),
            keywords: &[
                "nainen",
                "naistoimistotyöntekijä",
                "toimisto",
                "työntekijä",
                "valkokaulus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng empleyado sa opisina"),
            keywords: &[
                "arkitekto",
                "babaeng empleyado sa opisina",
                "empleyada sa opisina",
                "empleyeda",
                "kaopisina",
                "negosyo",
                "opisina",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrivstovukvinna"),
            keywords: &[
                "arkitektur",
                "deildarstjóri",
                "kona",
                "kvinna",
                "løgfrøðingur",
                "skrivstova",
                "skrivstovukvinna",
                "stjóri",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("employée de bureau"),
            keywords: &[
                "affaires",
                "architecte",
                "bureau",
                "employée de bureau",
                "femme",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("oibrí oifige baineann"),
            keywords: &[
                "ailtire",
                "bainisteoir",
                "bean",
                "bóna bán",
                "gnó",
                "oibrí oifige baineann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("obraiche-oifis boireann"),
            keywords: &[
                "ailtire",
                "boireannach",
                "gnothachas",
                "gnìomhachas manaidsear",
                "obraiche-oifis boireann",
                "oifis",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("administrativa"),
            keywords: &["administrativa", "empregada", "muller", "oficinista"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ઑફિસ કાર\u{acd}યકર\u{acd}તા"),
            keywords: &[
                "આર\u{acd}કિટ\u{ac7}ક\u{acd}ટ",
                "ઑફિસ",
                "વ\u{acd}યવસાય",
                "સ\u{a82}ચાલક",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી ઑફિસ કાર\u{acd}યકર\u{acd}તા",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace ma’aikacin ofis"),
            keywords: &[
                "aikin ofis",
                "kasuwanci",
                "mace",
                "mace ma’aikacin ofis",
                "mai ilimin zane",
                "manaja",
                "ofis",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עובדת משרד"),
            keywords: &[
                "אדריכלית",
                "אשת עסקים",
                "מנהלת",
                "משרד",
                "עובדת משרד",
                "פקידה",
                "צווארון לבן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला कार\u{94d}यालय कार\u{94d}यकर\u{94d}ता"),
            keywords: &[
                "कार\u{94d}यालय",
                "प\u{94d}रब\u{902}धक",
                "महिला",
                "महिला कार\u{94d}यालय कार\u{94d}यकर\u{94d}ता",
                "वास\u{94d}त\u{941}कार",
                "व\u{94d}यापार",
                "सफ\u{947}द कॉलर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("službenica"),
            keywords: &[
                "arhitektkinja",
                "menadžerica",
                "poslovna žena",
                "službenica",
                "ured",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női irodista"),
            keywords: &["alkalmazott", "irodai", "női", "női irodista"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին գրասենյակի աշխատող"),
            keywords: &[
                "բիզնես",
                "գրասենյակ",
                "կին",
                "կին գրասենյակի աշխատող",
                "ղեկավար",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pekerja kantor wanita"),
            keywords: &["kantor", "karyawan", "pekerja kantor wanita", "perempuan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị onye ọrụ ọfịịsị"),
            keywords: &[
                "akwa-ọfịịsị",
                "azụmaahịa",
                "nwanyị",
                "nwanyị onye ọrụ ọfịịsị",
                "onyenjikwa",
                "ọfịịsị",
                "ọkammụta eserese",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns skrifstofustarfsmaður"),
            keywords: &[
                "kona",
                "kvenkyns skrifstofustarfsmaður",
                "skrifstofa",
                "stjórnandi",
                "viðskipti",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("impiegata"),
            keywords: &[
                "architetto",
                "business",
                "donna",
                "impiegata",
                "manager",
                "ufficio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性会社員"),
            keywords: &[
                "OL",
                "サラリーマン",
                "ビジネスパーソン",
                "会社員",
                "女性",
                "女性会社員",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("pegawe kantor wadon"),
            keywords: &[
                "arsitek",
                "bisnis",
                "manajer",
                "pegawe",
                "pegawe kantor wadon",
                "wadon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თანამშრომელი ქალი"),
            keywords: &[
                "არქიტექტურა",
                "ბიზნესი",
                "თანამშრომელი ქალი",
                "მენეჯერი",
                "ოფისი",
                "სამსახური",
                "ქალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кеңседе жұмыс істейтін қызметкер әйел"),
            keywords: &[
                "бизнес",
                "кеңсе",
                "кеңседе жұмыс істейтін қызметкер әйел",
                "менеджер",
                "әйел",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig kontoransat"),
            keywords: &[
                "business",
                "kontor",
                "kvinde",
                "kvindelig kontoransat",
                "mappe",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}គ\u{17d2}គល\u{17b7}កស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ជ\u{17c6}ន\u{17bd}ញ",
                "ធ\u{17bb}រក\u{17b7}ច\u{17d2}ច",
                "នារ\u{17b8}",
                "ប\u{17bb}គ\u{17d2}គល\u{17b7}កការ\u{17b7}យាល\u{17d0}យ",
                "ប\u{17bb}គ\u{17d2}គល\u{17b7}កស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}ថាបត\u{17d2}យករ",
                "ស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកគ\u{17d2}រប\u{17cb}គ\u{17d2}រង",
                "អ\u{17d2}នកធ\u{17d2}វើការក\u{17d2}ន\u{17bb}ង\u{200b}ការ\u{17b7}យាល\u{17d0}យ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಛೇರ\u{cbf}ಯ ಕ\u{cc6}ಲಸಗಾರ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಕಛೇರ\u{cbf}",
                "ಕಛೇರ\u{cbf}ಯ ಕ\u{cc6}ಲಸಗಾರ\u{ccd}ತ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮ\u{ccd}ಯಾನೇಜರ\u{ccd}",
                "ವಾಸ\u{ccd}ತುಶ\u{cbf}ಲ\u{ccd}ಪ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 회사원"),
            keywords: &[
                "건축가",
                "관리자",
                "매니저",
                "비즈니스맨",
                "샐러리맨",
                "여자",
                "여자 회사원",
                "화이트칼라",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल कच\u{947}र\u{947}\u{902}तली कर\u{94d}मचारी"),
            keywords: &[
                "धवी - कॉलर",
                "बायल",
                "बायल कच\u{947}र\u{947}\u{902}तली कर\u{94d}मचारी",
                "व\u{947}वसाय",
                "व\u{947}वस\u{94d}थापक",
                "शिल\u{94d}पकार",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял офис жумушчусу"),
            keywords: &[
                "архитектор",
                "аял",
                "аял офис жумушчусу",
                "бизнес",
                "мамлекеттик кызматкер",
                "офис менеджер",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Employée"),
            keywords: &[
                "Architektin",
                "Büro",
                "Employée",
                "Fra",
                "Geschäft",
                "Managerin",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{eb1}ກງານຫ\u{ec9}ອງການຍ\u{eb4}ງ"),
            keywords: &[
                "ທ\u{eb8}ລະກ\u{eb4}ດ",
                "ຜ\u{eb9}\u{ec9}ຈ\u{eb1}ດການ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ພະນ\u{eb1}ກງານ",
                "ພະນ\u{eb1}ກງານຫ\u{ec9}ອງການຍ\u{eb4}ງ",
                "ສະຖາປະນ\u{eb4}ກ",
                "ຫ\u{ec9}ອງການ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("biuro darbuotoja"),
            keywords: &[
                "architektė",
                "biuro darbuotoja",
                "darbas įstaigoje",
                "moteris",
                "vadybininkė",
                "verslas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("biroja darbiniece"),
            keywords: &[
                "arhitekte",
                "baltās apkaklītes",
                "biroja darbiniece",
                "birojs",
                "menedžere",
                "sieviete",
                "uzņēmējdarbība",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaimahi tari wahine"),
            keywords: &[
                "kaihoahoa whare",
                "kaimahi tari wahine",
                "kaiwhakahaere",
                "kara-mā",
                "pakihi",
                "tari",
                "wahine",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("административка"),
            keywords: &[
                "административка",
                "архитект",
                "бизнисменка",
                "канцеларија",
                "маж",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഓഫീസ\u{d4d} ജീവനക\u{d4d}ക\u{d3e}രി"),
            keywords: &[
                "ഉദ\u{d4d}യോഗസ\u{d4d}ഥ",
                "ഓഫീസ\u{d4d}",
                "ഓഫീസ\u{d4d} ജീവനക\u{d4d}ക\u{d3e}രി",
                "ബിസിനസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй оффисын ажилтан"),
            keywords: &[
                "архитект",
                "бизнес",
                "менежер",
                "оффисын ажилтан эмэгтэй",
                "эмэгтэй",
                "эмэгтэй оффисын ажилтан",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला ऑफिस कर\u{94d}मचारी"),
            keywords: &[
                "ऑफिस",
                "महिला ऑफिस कर\u{94d}मचारी",
                "वास\u{94d}त\u{941}शास\u{94d}त\u{94d}रज\u{94d}ञ",
                "व\u{94d}यवसाय",
                "व\u{94d}यवस\u{94d}थापक",
                "व\u{94d}हाईट-कॉलर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pekerja pejabat wanita"),
            keywords: &[
                "kolar putih",
                "pekerja pejabat wanita",
                "pengurus",
                "urus niaga",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara taħdem f’uffiċċju"),
            keywords: &[
                "maniġer",
                "mara",
                "mara taħdem f’uffiċċju",
                "negozju",
                "perit",
                "uffiċċju",
                "ħaddiema professjonali",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း ရ\u{102f}\u{1036}းဝန\u{103a}ထမ\u{103a}း"),
            keywords: &[
                "ဉာဏလ\u{102f}ပ\u{103a}သား",
                "ဗ\u{102d}သ\u{102f}ကာ ပညာရ\u{103e}င\u{103a}",
                "မန\u{103a}နေဂျာ",
                "လ\u{102f}ပ\u{103a}ငန\u{103a}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ရ\u{102f}\u{1036}းဝန\u{103a}ထမ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig kontorarbeider"),
            keywords: &[
                "kontor",
                "kvinne",
                "kvinnelig kontorarbeider",
                "leder",
                "næringsliv",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कार\u{94d}यालयको महिलाकर\u{94d}मी"),
            keywords: &[
                "आर\u{94d}किट\u{947}क\u{94d}ट",
                "कार\u{94d}यालयको महिलाकर\u{94d}मी",
                "प\u{94d}रबन\u{94d}धक",
                "महिला",
                "व\u{94d}यवसाय",
                "स\u{947}तो रङ\u{94d}गको कठालो भएको ल\u{941}गा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kantoormedewerkster"),
            keywords: &[
                "architecte",
                "bedrijf",
                "kantoor",
                "kantoormedewerkster",
                "manager",
                "vrouw",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg kontorarbeidar"),
            keywords: &[
                "kontor",
                "kvinne",
                "kvinneleg kontorarbeidar",
                "leiar",
                "næringsliv",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} କ\u{b3e}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ଳୟ କର\u{b4d}ମଚ\u{b3e}ରୀ"),
            keywords: &[
                "ଧଳ\u{b3e}-ଗଳ\u{b3e}ବନ\u{b4d}ଧ",
                "ପର\u{b3f}ଚ\u{b3e}ଳକ",
                "ବ\u{b4d}ୟବସ\u{b3e}ୟ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} କ\u{b3e}ର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}ଳୟ କର\u{b4d}ମଚ\u{b3e}ରୀ",
                "ସ\u{b4d}ଥପତ\u{b3f}ବ\u{b3f}ଦ\u{b4d}ୟ\u{b3e}ବ\u{b3f}ତ\u{b4d}\u{200c} ବ\u{b3e} ଆର\u{b4d}କ\u{b3f}ଟେକ\u{b4d}ଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਆਫਿਸ ਵਰਕਰ"),
            keywords: &[
                "ਆਰਕੀਟ\u{a48}ਕਟ",
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਆਫਿਸ ਵਰਕਰ",
                "ਔਰਤ",
                "ਕਾਰ\u{a4b}ਬਾਰ",
                "ਦਫਤਰ",
                "ਮ\u{a48}ਨ\u{a47}ਜਰ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دفتر وچ کم کرن آلی زنانی"),
            keywords: &[
                "بیوپار",
                "دفتر",
                "دفتر وچ کم کرن آلی زنانی",
                "زنانی",
                "سفید پوش",
                "فن تعمیر دا ماہر",
                "منتظم",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Ọ\u{301}fís Wọ\u{301}ka"),
            keywords: &[
                "Bíznẹs",
                "Man",
                "Máníja",
                "To Wọ\u{301}k Fọ Ọ\u{301}fis Ínstẹ\u{301}d Ọf Fáktri",
                "Wúman",
                "Wúman Ọ\u{301}fís Wọ\u{301}ka",
                "Wúmán Ọ\u{301}fís Wọ\u{301}ka",
                "Ákítẹkt",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pracownica biurowa"),
            keywords: &[
                "architekt",
                "biuro",
                "bizneswoman",
                "kobieta",
                "pracownica biurowa",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه دفتر کارګر"),
            keywords: &[
                "سپين پوس",
                "سړی دفتري کارګر",
                "منتظم",
                "مهندس",
                "ښځه دفتر کارګر",
                "کاروبار",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("funcionária de escritório"),
            keywords: &[
                "arquiteta",
                "colarinho branco",
                "empresária",
                "funcionára de escritório",
                "funcionária de escritório",
                "gerente",
                "mulher",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("funcionária de escritório"),
            keywords: &[
                "administradora",
                "empresa",
                "funcionária de escritório",
                "gerente",
                "mulher",
                "trabalhadora de escritório",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi oficina llamkaq"),
            keywords: &[
                "kamachiq",
                "oficinista",
                "qatuna",
                "warmi",
                "warmi oficina llamkaq",
                "wasi k’achanchaq",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("funcționară"),
            keywords: &[
                "administrație",
                "arhitectă",
                "birou",
                "business",
                "femeie manager",
                "funcționară",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1185"),
            keywords: &["E10-1185"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("офисная работница"),
            keywords: &[
                "белый воротничок",
                "бизнес",
                "женщина",
                "менеджер",
                "офис",
                "офисная работница",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore ukorera mu biro"),
            keywords: &[
                "ibiro",
                "impuguke",
                "ubucuruzi",
                "umugore",
                "umugore ukorera mu biro",
                "umuhuzabikorwa",
                "umushushanyi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت آفيس ورڪر"),
            keywords: &[
                "عورت آفيس ورڪر",
                "عورت، آفيس، ڪاروبار، مينيجر، آرڪيٽيڪٽ، اڇو ڪالر",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැහැණ\u{dd4} ක\u{dcf}ර\u{dca}ය\u{dcf}ල කම\u{dca}කර\u{dd4}ව\u{dcf}"),
            keywords: &[
                "කළමන\u{dcf}කර\u{dd4}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ගැහැණ\u{dd4} ක\u{dcf}ර\u{dca}ය\u{dcf}ල කම\u{dca}කර\u{dd4}ව\u{dcf}",
                "න\u{dd2}ර\u{dca}ම\u{dcf}ණ ශ\u{dd2}ල\u{dca}ප\u{dd2}ණ\u{dd2}ය",
                "ව\u{dca}\u{200d}ය\u{dcf}ප\u{dcf}රය",
                "ස\u{dd4}ද\u{dd4} කොලරය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pracovníčka v kancelárii"),
            keywords: &[
                "kancelária",
                "manažérka",
                "pracovníčka v kancelárii",
                "úradníčka",
                "žena",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pisarniška delavka"),
            keywords: &[
                "arhitektka",
                "dekle",
                "direktorica",
                "pisarna",
                "pisarniška delavka",
                "pisarniški",
                "podjetje",
                "tajnica",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag shaqaale xafiis ah"),
            keywords: &[
                "ganacsi",
                "maamule",
                "muhindiska dhismaha",
                "naag",
                "naag shaqaale xafiis ah",
                "naag xafiis ka shaqaysa",
                "shaqo xafiis",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("punonjëse zyre"),
            keywords: &["arkitekte", "biznes", "grua", "menaxher", "punonjëse zyre"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена у канцеларији"),
            keywords: &[
                "асистент",
                "жена",
                "жена у канцеларији",
                "канцеларија",
                "секретарица",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena u kancelariji"),
            keywords: &[
                "asistent",
                "kancelarija",
                "sekretarica",
                "žena",
                "žena u kancelariji",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kontorstjänstekvinna"),
            keywords: &[
                "chef",
                "kontor",
                "kontorstjänstekvinna",
                "kvinna",
                "näringsliv",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke aliyevaa nadhifu"),
            keywords: &["mwanamke", "mwanamke aliyevaa nadhifu", "suti", "tai"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} பணிய\u{bbe}ளர\u{bcd}"),
            keywords: &[
                "அதிக\u{bbe}ரி",
                "அலுவலகம\u{bcd}",
                "பணிய\u{bbe}ளர\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉద\u{c4d}య\u{c4b}గస\u{c4d}థుర\u{c3e}లు"),
            keywords: &[
                "ఆర\u{c4d}క\u{c3f}ట\u{c46}క\u{c4d}ట\u{c4d}",
                "ఉద\u{c4d}య\u{c4b}గస\u{c4d}థుర\u{c3e}లు",
                "న\u{c3f}ర\u{c4d}వ\u{c3e}హకుర\u{c3e}లు",
                "ప\u{c4d}రభుత\u{c4d}వ ఉద\u{c4d}య\u{c4b}గులు",
                "మహ\u{c3f}ళ",
                "వ\u{c4d}య\u{c3e}ప\u{c3e}రం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани корманди идора"),
            keywords: &[
                "зан",
                "зани корманди идора",
                "идора",
                "корманди илмӣ",
                "меъмор",
                "мудир",
                "соҳибкорӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พน\u{e31}กงานบร\u{e34}ษ\u{e31}ทหญ\u{e34}ง"),
            keywords: &[
                "ธ\u{e38}รก\u{e34}จ",
                "ผ\u{e39}\u{e49}จ\u{e31}ดการ",
                "พน\u{e31}กงานบร\u{e34}ษ\u{e31}ทหญ\u{e34}ง",
                "พน\u{e31}กงานออฟฟ\u{e34}ศ",
                "สถาปน\u{e34}ก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan ofis işgäri"),
            keywords: &[
                "binagär",
                "işewürlik",
                "ofis işgäri",
                "zenan",
                "zenan ofis işgäri",
                "ýolbaşçy",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine ngāue ʻōfisi"),
            keywords: &["fefine ngāue ʻōfisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın ofis çalışanı"),
            keywords: &[
                "bayan",
                "beyaz yaka",
                "iş",
                "kadın",
                "kadın ofis çalışanı",
                "mimar",
                "ofis",
                "yönetici",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئىشخانا خىزمەتچىسى ئايال"),
            keywords: &[
                "ئايال",
                "ئىشخانا",
                "ئىشخانا خىزمەتچىسى",
                "ئىشخانا خىزمەتچىسى ئايال",
                "باشقۇرغۇچى",
                "سودا",
                "لايىھەلىگۈچى",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("службовка"),
            keywords: &[
                "жінка",
                "менеджер",
                "офіс",
                "офісна працівниця",
                "службовка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت دفتر کارکن"),
            keywords: &["دفتر", "عورت", "ملازم", "کارکن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol ofis xodimi"),
            keywords: &[
                "arxitektor",
                "ayol ofis xodimi",
                "biznes",
                "menejer",
                "ofis",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân viên văn phòng nữ"),
            keywords: &[
                "công việc văn phòng",
                "kinh doanh",
                "kiến trúc sư",
                "người phụ nữ",
                "người quản lý",
                "nhân viên văn phòng nữ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen biro liggéeykat"),
            keywords: &[
                "arsitekt",
                "biro",
                "bisnes",
                "jigéen",
                "jigéen biro liggéeykat",
                "liggéeykat bu xarañ",
                "patroŋ",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umsebenzi waseofisini olibhinqa"),
            keywords: &[
                "ibhinqa",
                "ikhola emhlophe",
                "iofisi",
                "ishishini",
                "umanejala",
                "umsebenzi waseofisini olibhinqa",
                "umyili wezakhiwo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìrin òṣìṣẹ\u{301} ọ\u{301}físì"),
            keywords: &[
                "alábóòjútò",
                "iṣẹ\u{301} ọ\u{301}físì",
                "obìrin",
                "obìrin òṣìṣẹ\u{301} ọ\u{301}físì",
                "olùyà ilé",
                "òwò",
                "ọ\u{301}físì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女辦公室職員"),
            keywords: &[
                "女",
                "女辦公室職員",
                "建築師",
                "業務",
                "白領",
                "經理",
                "辦公室",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女办公室职员"),
            keywords: &[
                "业务",
                "办公室",
                "女",
                "女办公室职员",
                "建筑师",
                "白领",
                "经理",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女白领"),
            keywords: &["商人", "女白领", "建筑师", "经理"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女性上班族"),
            keywords: &["上班族", "女", "女性上班族", "白領"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女職員"),
            keywords: &["OL", "上班族", "女", "女職員", "白領", "職員"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umsebenzi wasehhovisi wesifazane"),
            keywords: &[
                "ihhovisi",
                "osebenza kahle",
                "owesifazane",
                "umphathi",
                "umsebenzi wasehhovisi wesifazane",
                "usomabhizinisi",
            ],
        },
    ],
};
#[doc = "👩🏻\u{200d}💼"]
pub const WOMAN_OFFICE_WORKER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}💼",
    codepoint: "1F469 1F3FB 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman office worker: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}💼"]
pub const WOMAN_OFFICE_WORKER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}💼",
    codepoint: "1F469 1F3FC 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman office worker: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}💼"]
pub const WOMAN_OFFICE_WORKER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}💼",
    codepoint: "1F469 1F3FD 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman office worker: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}💼"]
pub const WOMAN_OFFICE_WORKER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}💼",
    codepoint: "1F469 1F3FE 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman office worker: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}💼"]
pub const WOMAN_OFFICE_WORKER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}💼",
    codepoint: "1F469 1F3FF 200D 1F4BC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman office worker: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🔬"]
pub const SCIENTIST: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🔬",
    codepoint: "1F9D1 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "scientist",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wetenskaplike"),
            keywords: &[
                "bioloog",
                "chemikus",
                "fisikus",
                "ingenieur",
                "wetenskaplike",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳይንቲስት"),
            keywords: &["ሳይንቲስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عال\u{650}م"),
            keywords: &[
                "بيولوجي",
                "عالم",
                "عال\u{650}م",
                "فيزيائي",
                "كيميائي",
                "مهندس",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বৈজ\u{9cd}ঞ\u{9be}নিক"),
            keywords: &[
                "ইঞ\u{9cd}জিনিয\u{9bc}\u{9be}ৰ",
                "কেমিষ\u{9cd}ট",
                "জীৱবিজ\u{9cd}ঞ\u{9be}নী",
                "পদ\u{9be}ৰ\u{9cd}থ বিজ\u{9cd}ঞ\u{9be}নী",
                "বৈজ\u{9cd}ঞ\u{9be}নিক",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("alim"),
            keywords: &["alim", "bioloq", "fizik", "kimyaçı", "mühəndis", "qadın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("навуковец"),
            keywords: &["біёлаг", "навуковец", "фізік", "хімік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("учен"),
            keywords: &["биолог", "инженер", "учен", "физик", "химик"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বৈজ\u{9cd}ঞ\u{9be}নিক"),
            keywords: &[
                "ইঞ\u{9cd}জিনিয\u{9bc}\u{9be}র",
                "কেমিস\u{9cd}ট",
                "ফিজিসিস\u{9cd}ট",
                "ব\u{9be}য\u{9bc}োলজিস\u{9cd}ট",
                "বৈজ\u{9cd}ঞ\u{9be}নিক",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("naučnik"),
            keywords: &["biolog", "fizičar", "hemičar", "inžinjer", "naučnik"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("científic"),
            keywords: &["biòleg", "científic", "enginyer", "físic", "químic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎦᏛᎲᏍᎩ"),
            keywords: &["ᎤᎦᏛᎲᏍᎩ", "ᎤᎦᏛᏂᏙᎯ", "ᎬᏃᏓ ᎤᎦᏛᎲᏍᎩ", "ᏗᏎᏍᏗ ᏧᎦᏎᏍᏗ", "ᏗᏟᎶᏍᏔᏅᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vědec/vědkyně"),
            keywords: &[
                "biolog",
                "bioložka",
                "chemik",
                "chemička",
                "fyzik",
                "fyzička",
                "inženýr",
                "inženýrka",
                "matematik",
                "matematička",
                "vědec",
                "vědec/vědkyně",
                "vědkyně",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person sy’n ymwneud â gwyddoniaeth"),
            keywords: &[
                "biolegydd",
                "cemegydd",
                "ffisegydd",
                "gwyddonydd",
                "peiriannydd",
                "person sy’n ymwneud â gwyddoniaeth",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("videnskabsmand"),
            keywords: &[
                "biolog",
                "forsker",
                "fysiker",
                "ingeniør",
                "kemiker",
                "naturvidenskabsmand",
                "videnskabsmand",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wissenschaftler(in)"),
            keywords: &[
                "Biologe",
                "Chemiker",
                "Ingenieur",
                "Physiker",
                "Wissenschaftler",
                "Wissenschaftler(in)",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: None,
            keywords: &["Wissenschaftler(in)"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("επιστήμονας"),
            keywords: &["βιολόγος", "επιστήμονας", "μηχανικός", "φυσικός", "χημικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("scientist"),
            keywords: &["biologist", "chemist", "engineer", "physicist", "scientist"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la ciencia"),
            keywords: &[
                "biólogo",
                "científico",
                "físico",
                "investigador",
                "profesional de la ciencia",
                "químico",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "biología",
                "ciencia",
                "física",
                "profesional de la ciencia",
                "química",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("teadlane"),
            keywords: &["bioloog", "füüsik", "insener", "keemik", "teadlane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zientzialaria"),
            keywords: &[
                "biologo",
                "fisikari",
                "ingeniari",
                "kimikari",
                "zientzialari",
                "zientzialaria",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانشمند"),
            keywords: &[
                "دانشمند",
                "زیست\u{200c}شناس",
                "شیمی\u{200c}دان",
                "فیزیک\u{200c}دان",
                "مهندس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tutkija"),
            keywords: &[
                "biologi",
                "insinööri",
                "kemisti",
                "lääkäri",
                "tiede",
                "tutkija",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("siyentipiko"),
            keywords: &["biologist", "chemist", "inhinyero", "siyentipiko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("náttúruvísindafólk"),
            keywords: &[
                "alisfrøðingur",
                "evnafrøðingur",
                "lívsfrøðingur",
                "náttúruvísindafólk",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scientifique"),
            keywords: &["chimiste", "scientifique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("scientifique"),
            keywords: &[
                "biologiste",
                "chimiste",
                "ingénieur",
                "physicien",
                "scientifique",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("eolaí"),
            keywords: &["eolaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach-saidheans"),
            keywords: &[
                "bith-eòlas",
                "ceimigeachd",
                "einnseinear",
                "eòlaiche",
                "eòlas-nàdair",
                "fiosaigs",
                "fiosraigeachd",
                "innleadair",
                "neach",
                "neach-saidheans",
                "saidheans",
                "saidheantair",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("especialista en ciencia"),
            keywords: &[
                "biólogo",
                "científico",
                "especialista en ciencia",
                "químico",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિજ\u{acd}ઞાની"),
            keywords: &[
                "એન\u{acd}જિનિઅર",
                "જીવવિજ\u{acd}ઞાની",
                "ભૌતિકવિજ\u{acd}ઞાની",
                "રસાયણશાસ\u{acd}ત\u{acd}રી",
                "વિજ\u{acd}ઞાની",
                "વ\u{ac8}જ\u{acd}ઞાનિક",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מדען/ית"),
            keywords: &["מדען", "מדען/ית", "מדענית", "מהנדס", "מהנדסת", "מעבדה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "इ\u{902}जीनियर",
                "जीवविज\u{94d}ञानी",
                "भौतिक विज\u{94d}ञानी",
                "रसायनज\u{94d}ञ",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("biokemičar"),
            keywords: &[
                "biokemičar",
                "biolog",
                "fizičar",
                "inženjer",
                "kemičar",
                "znanstvenik",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tudás"),
            keywords: &["biológus", "fizikus", "mérnök", "tudás", "tudós", "vegyész"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գիտնական"),
            keywords: &["գիտնական", "ինժեներ", "կենսաբան", "քիմիկոս", "ֆիզիկոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ilmuwan"),
            keywords: &[
                "ahli biologi",
                "ahli fisika",
                "ahli kimia",
                "ilmuwan",
                "insinyur",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vísindafræðingur"),
            keywords: &[
                "efnafræðingur",
                "eðlisfræðingur",
                "líffræðingur",
                "verkfræðingur",
                "vísindafræðingur",
                "vísindamaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che lavora in campo scientifico"),
            keywords: &[
                "biologo",
                "chimico",
                "fisico",
                "ingegnere",
                "persona che lavora in campo scientifico",
                "scienziato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("科学者"),
            keywords: &["化学者", "物理学者", "生物学者", "科学者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ilmuwan"),
            keywords: &[
                "ahli biologi",
                "ahli fisika",
                "ahli kimia",
                "ilmuwan",
                "insinyur",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეცნიერი"),
            keywords: &[
                "ბიოლოგი",
                "ინჟინერი",
                "მეაფთიაქე",
                "მეცნიერი",
                "ფიზიკოსი",
                "ქიმიკოსი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ғалым"),
            keywords: &["биолог", "инженер", "физик", "химик", "ғалым"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រ"),
            keywords: &[
                "គ\u{17b8}ម\u{17b8}វ\u{17b7}ទ\u{17bc}",
                "ជ\u{17b8}វវ\u{17b7}ទ\u{17bc}",
                "រ\u{17bc}បវ\u{17b7}ទ\u{17bc}",
                "វ\u{17b7}ស\u{17d2}វករ",
                "អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}"),
            keywords: &[
                "ಎಂಜ\u{cbf}ನ\u{cbf}ಯರ\u{ccd}",
                "ಜೀವಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ಭ\u{ccc}ತಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ರಸಾಯನಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("과학자"),
            keywords: &["과학자", "기술자", "물리학자", "생물학자", "화학자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शास\u{94d}त\u{94d}रज\u{94d}ञ"),
            keywords: &[
                "इ\u{902}जिनियर",
                "जीवशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "फिजिसिस\u{94d}ट",
                "रसायनशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "शास\u{94d}त\u{94d}रज\u{94d}ञ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("илимпоз"),
            keywords: &["илимпоз"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດ"),
            keywords: &[
                "ນ\u{eb1}ກຊ\u{eb5}ວະວ\u{eb4}ທະຍາ",
                "ນ\u{eb1}ກຟ\u{eb5}ຊ\u{eb4}ກ",
                "ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດ",
                "ນ\u{eb1}ກເຄມ\u{eb5}",
                "ວ\u{eb4}ສະວະກອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokslo darbuotojas"),
            keywords: &[
                "biologas",
                "chemikas",
                "fizikas",
                "inžinierius",
                "mokslininkas",
                "mokslo darbuotojas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis zinātnieks"),
            keywords: &[
                "biologs",
                "fiziķis",
                "inženieris",
                "vīrietis zinātnieks",
                "zinātnieks",
                "ķīmiķis",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("научник"),
            keywords: &["биолог", "инженер", "научник", "физичар", "хемичар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ശ\u{d3e}സ\u{d4d}ത\u{d4d}രക\u{d3e}രൻ"),
            keywords: &[
                "ഊർജ\u{d4d}ജതന\u{d4d}ത\u{d4d}രജ\u{d4d}ഞൻ",
                "എഞ\u{d4d}ചിനീയർ",
                "കെമിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "ജീവശ\u{d3e}സ\u{d4d}ത\u{d4d}രജ\u{d4d}ഞൻ",
                "ശ\u{d3e}സ\u{d4d}ത\u{d4d}രക\u{d3e}രൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шинжлэх ухаанч"),
            keywords: &["биологич", "инженер", "физикч", "химич", "шинжлэх ухаанч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शास\u{94d}त\u{94d}रज\u{94d}ञ"),
            keywords: &[
                "अभिय\u{902}ता",
                "जीवशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "भौतिकशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "रसायनशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "व\u{948}ज\u{94d}ञानिक",
                "शास\u{94d}त\u{94d}रज\u{94d}ञ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("saintis"),
            keywords: &["ahli biologi", "ahli fizik", "ahli kimia", "saintis"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}"),
            keywords: &[
                "ဇ\u{102e}ဝဗေဒပညာရ\u{103e}င\u{103a}",
                "ဓာတ\u{102f}ဗေဒပညာရ\u{103e}င\u{103a}",
                "ရ\u{1030}ပဗေဒပညာရ\u{103e}င\u{103a}",
                "သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
                "အင\u{103a}ဂျင\u{103a}န\u{102e}ယာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("forsker"),
            keywords: &[
                "biologi",
                "forsker",
                "forskning",
                "kjemi",
                "lab",
                "laboratorium",
                "medisin",
                "vitenskap",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "इन\u{94d}जिनियर",
                "चिकित\u{94d}सक",
                "जीव व\u{948}ज\u{94d}ञानिक",
                "रसायन व\u{948}ज\u{94d}ञानिक",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wetenschapper"),
            keywords: &[
                "bioloog",
                "ingenieur",
                "natuurkundige",
                "scheikundige",
                "wetenschapper",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("forskar"),
            keywords: &[
                "biologi",
                "forskar",
                "forsking",
                "kjemi",
                "lab",
                "laboratorium",
                "medisin",
                "vitskap",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ"),
            keywords: &[
                "ଜୀବ ବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନୀ",
                "ପଦ\u{b3e}ର\u{b4d}ଥ ବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନୀ",
                "ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ",
                "ଯନ\u{b4d}ତ\u{b4d}ରୀ",
                "ରସ\u{b3e}ୟନବ\u{b3f}ଦ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਿਗਿਆਨੀ"),
            keywords: &[
                "ਇ\u{a70}ਜੀਨੀਅਰ",
                "ਕ\u{a48}ਮਿਸਟ",
                "ਜੀਵ-ਵਿਗਿਆਨੀ",
                "ਬ\u{a70}ਦਾ",
                "ਭ\u{a4c}ਤਿਕ ਵਿਗਿਆਨੀ",
                "ਵਿਗਿਆਨੀ",
                "ਹਿਸਾਬਦਾਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sáyẹ\u{301}ns Ẹ\u{301}spat"),
            keywords: &[
                "Bayọ\u{301}lọ\u{301}gí Ẹ\u{301}spat",
                "Fízíks Ẹ\u{301}spat",
                "Kẹ\u{301}místrí Ẹ\u{301}spat",
                "Sáyẹ\u{301}ns Ẹ\u{301}spat",
                "Ẹnjinia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("naukowiec"),
            keywords: &["biolog", "chemik", "fizyk", "inżynier", "naukowiec"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("څېړونکی"),
            keywords: &["انجينير", "د فزکس پوهاند", "نبات پوه", "څېړونکی", "کمياګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cientista"),
            keywords: &["biólogo", "cientista", "engenheiro", "físico", "químico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hamut’asqa"),
            keywords: &["biologo", "fisico", "hamut’asqa", "ingeniero", "quimico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("om de știință"),
            keywords: &["biolog", "chimist", "fizician", "inginer", "om de știință"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-016"),
            keywords: &["E13-016"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ученый"),
            keywords: &["биолог", "инженер", "наука", "ученый", "физик", "химик"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سائنس دان"),
            keywords: &["انجنيئر", "بايولاجسٽ", "سائنس دان", "فزڪس دان", "ڪيميادان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}"),
            keywords: &[
                "ඉංජ\u{dd2}නේර\u{dd4}",
                "ජ\u{dd3}ව ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "භෞත\u{dd2}ක ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "රස\u{dcf}යන ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vedec"),
            keywords: &["inžinier", "vedec", "výskum"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("raziskovalec"),
            keywords: &[
                "biolog",
                "fizik",
                "inženir",
                "kemik",
                "matematik",
                "raziskovalec",
                "znanstvenik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("saynisyahan"),
            keywords: &[
                "biyolojisti, kimistyahan, injineer, fisikyahan, saynisyahan",
                "saynisyahan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person shkencëtar"),
            keywords: &[
                "biolog",
                "fizikan",
                "inxhinier",
                "kimist",
                "person shkencëtar",
                "shkencëtar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("научник/ца"),
            keywords: &[
                "биологичар",
                "инжењер",
                "научник",
                "научник/ца",
                "физичар",
                "хемичар",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("naučnik/ca"),
            keywords: &[
                "biologičar",
                "fizičar",
                "hemičar",
                "inženjer",
                "naučnik",
                "naučnik/ca",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("forskare"),
            keywords: &["biolog", "forskare", "fysiker", "kemist", "vetenskapsman"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanasayansi"),
            keywords: &[
                "mhandisi",
                "mwanabiolojia",
                "mwanafizikia",
                "mwanakemia",
                "mwanasayansi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விஞ\u{bcd}ஞ\u{bbe}னி"),
            keywords: &[
                "இயற\u{bcd}பியல\u{bbe}ளர\u{bcd}",
                "உயிரியல\u{bbe}ளர\u{bcd}",
                "பொறிய\u{bbe}ளர\u{bcd}",
                "விஞ\u{bcd}ஞ\u{bbe}னி",
                "வேதியியல\u{bbe}ளர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3e}స\u{c4d}త\u{c4d}రవ\u{c47}త\u{c4d}త"),
            keywords: &[
                "ఇంజ\u{c3f}న\u{c40}ర\u{c4d}",
                "క\u{c46}మ\u{c3f}స\u{c4d}ట\u{c4d}",
                "బయ\u{c3e}లజ\u{c3f}స\u{c4d}ట\u{c4d}",
                "భ\u{c4c}త\u{c3f}క శ\u{c3e}స\u{c4d}త\u{c4d}రవ\u{c47}త\u{c4d}త",
                "శ\u{c3e}స\u{c4d}త\u{c4d}రవ\u{c47}త\u{c4d}త",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e31}กว\u{e34}ทยาศาสตร\u{e4c}"),
            keywords: &[
                "น\u{e31}กช\u{e35}วว\u{e34}ทยา",
                "น\u{e31}กฟ\u{e34}ส\u{e34}กส\u{e4c}",
                "น\u{e31}กว\u{e34}ทยาศาสตร\u{e4c}",
                "น\u{e31}กเคม\u{e35}",
                "ว\u{e34}ศวกร",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("alym"),
            keywords: &["alym", "biolog", "fizik", "himik", "inžener"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha faisaienisi"),
            keywords: &["tokotaha faisaienisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bilim insanı"),
            keywords: &["bilim insanı", "biyolog", "fizikçi", "kimyacı", "kimyager"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("науковий працівник"),
            keywords: &[
                "біолог",
                "науковець",
                "науковий працівник",
                "фізик",
                "хімік",
                "інженер",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سائنسدان"),
            keywords: &[
                "انجینیئر",
                "سائنسدان",
                "ماہر حیاتیات",
                "ماہر طبیعات",
                "کیمسٹ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("olim"),
            keywords: &["biolog", "fizik", "injener", "muhandis", "olim", "ximik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà khoa học"),
            keywords: &[
                "kỹ sư",
                "nhà hóa học",
                "nhà khoa học",
                "nhà sinh vật học",
                "nhà vật lý",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("科學家"),
            keywords: &["化學家", "工程師", "物理學家", "生物學家", "科學家"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("科学家"),
            keywords: &["化学家", "工程师", "物理学家", "生物学家", "科学家"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("科学家"),
            keywords: &["化学家", "工程学家", "物理学家", "生物学家", "科学家"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("科學家"),
            keywords: &["化學家", "工程師", "物理學家", "生物學家", "科學家"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("usosayensi"),
            keywords: &[
                "amakhemikhali",
                "i-physicist",
                "isazi sezinto eziphilayo",
                "unjiniyela",
                "usosayensi",
            ],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🔬"]
pub const SCIENTIST_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🔬",
    codepoint: "1F9D1 1F3FB 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "scientist: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🔬"]
pub const SCIENTIST_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🔬",
    codepoint: "1F9D1 1F3FC 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "scientist: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🔬"]
pub const SCIENTIST_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🔬",
    codepoint: "1F9D1 1F3FD 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "scientist: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🔬"]
pub const SCIENTIST_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🔬",
    codepoint: "1F9D1 1F3FE 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "scientist: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🔬"]
pub const SCIENTIST_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🔬",
    codepoint: "1F9D1 1F3FF 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "scientist: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🔬"]
pub const MAN_SCIENTIST: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🔬",
    codepoint: "1F468 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man scientist",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike wetenskaplike"),
            keywords: &[
                "bioloog",
                "manlike wetenskaplike",
                "proefbuis",
                "wetenskaplike",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ሳይንቲስት"),
            keywords: &["ሳይንቲስት", "ባዮሎጂስት", "ኢንጂነር", "ኬሚስት", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عالم"),
            keywords: &["بيولوجي", "عالم", "فيزيائي", "كيميائي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ বৈজ\u{9cd}ঞ\u{9be}নিক"),
            keywords: &[
                "ইঞ\u{9cd}জিনিয\u{9bc}\u{9be}ৰ",
                "গণিতজ\u{9cd}ঞ",
                "জীৱবিজ\u{9cd}ঞ\u{9be}নী",
                "পদ\u{9be}ৰ\u{9cd}থ বিজ\u{9cd}ঞ\u{9be}নী",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "বৈজ\u{9cd}ঞ\u{9be}নিক",
                "ৰস\u{9be}য\u{9bc}নবিদ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi alim"),
            keywords: &[
                "alim",
                "bioloq",
                "fizik",
                "kimyaçı",
                "kişi",
                "mühəndis",
                "riyaziyyatçı",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вучоны"),
            keywords: &["біёлаг", "вучоны", "мужчына", "навуковец", "фізік", "хімік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж учен"),
            keywords: &[
                "биолог",
                "инженер",
                "математик",
                "мъж учен",
                "научен работник",
                "учен",
                "химик",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ বিজ\u{9cd}ঞ\u{9be}নী"),
            keywords: &[
                "ইঞ\u{9cd}জিনিয\u{9bc}\u{9be}র",
                "জীববিজ\u{9cd}ঞ\u{9be}নী",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9cd}রক\u{9c3}তিবিজ\u{9cd}ঞ\u{9be}নী",
                "বিজ\u{9cd}ঞ\u{9be}নী",
                "রস\u{9be}য\u{9bc}নবিদ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skiantour"),
            keywords: &["skiantour"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("naučnik muškarac"),
            keywords: &[
                "biolog",
                "fizičar",
                "hemičar",
                "inžinjer",
                "naučnik",
                "naučnik muškarac",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home científic"),
            keywords: &[
                "biòleg",
                "científic",
                "enginyer",
                "físic",
                "home científic",
                "químic",
            ],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄝\u{11128}𑄉\u{11133}𑄠\u{11134}𑄚\u{11128}"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄝\u{11128}𑄉\u{11133}𑄠\u{11134}𑄚\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᎦᏛᎲᏍᎩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎤᎦᏛᎲᏍᎩ", "ᎤᎦᏛᏂᏙᎯ", "ᏗᏎᏍᏗ ᏧᎦᏎᏍᏗ", "ᏗᏟᎶᏍᏔᏅᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vědec"),
            keywords: &[
                "biolog",
                "chemik",
                "fyzik",
                "inženýr",
                "matematik",
                "muž",
                "věda",
                "vědec",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwyddonydd"),
            keywords: &["biolegydd", "cemegydd", "dyn", "gwyddonydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig forsker"),
            keywords: &[
                "mandlig forsker",
                "naturvidenskab",
                "naturvidenskabsmand",
                "videnskab",
                "videnskabsmand",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wissenschaftler"),
            keywords: &["Forscher", "Labor", "Wissenschaftler"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας επιστήμονας"),
            keywords: &[
                "άντρας επιστήμονας",
                "έρευνα",
                "βιολόγος",
                "επιστήμονας",
                "χημικός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man scientist"),
            keywords: &[
                "biologist",
                "chemist",
                "engineer",
                "man",
                "physicist",
                "scientist",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la ciencia hombre"),
            keywords: &[
                "biólogo",
                "científico",
                "físico",
                "hombre",
                "profesional de la ciencia hombre",
                "químico",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesteadlane"),
            keywords: &["bioloog", "füüsik", "insener", "keemik", "meesteadlane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon zientzialaria"),
            keywords: &[
                "biologoa",
                "fisikaria",
                "gizon zientzialaria",
                "gizona",
                "gizonezkoa",
                "ingeniaria",
                "kimikaria",
                "zientzialaria",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانشمند مرد"),
            keywords: &[
                "دانشمند مرد",
                "زیست\u{200c}شناس",
                "شیمی\u{200c}دان",
                "فیزیک\u{200c}دان",
                "محقق",
                "میکروب\u{200c}شناس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miestutkija"),
            keywords: &["mies", "miestutkija", "tiede", "tutkija"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking siyentipiko"),
            keywords: &["lalaking siyentipiko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vísindamaður"),
            keywords: &["maður", "náttúruvísindi", "vísind", "vísindamaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scientifique homme"),
            keywords: &["chimiste", "homme", "scientifique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "biologiste",
                "chimiste",
                "homme",
                "physicien",
                "scientifique",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("eolaí fireann"),
            keywords: &[
                "bitheolaí",
                "ceimiceoir",
                "eolaí",
                "eolaí fireann",
                "fear",
                "fiscieoir",
                "innealtoir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach-saidheans fireann"),
            keywords: &[
                "bith-eòlaiche",
                "ceimigear",
                "duine",
                "einnseanair",
                "fear",
                "fiosaigiche",
                "fireannach",
                "innleadair",
                "matamataigear",
                "neach-saidheans",
                "neach-saidheans fireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("científico"),
            keywords: &["biólogo", "científico", "home", "químico"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ વ\u{ac8}જ\u{acd}ઞાનિક"),
            keywords: &[
                "એન\u{acd}જિનિઅર",
                "ગણિતશાસ\u{acd}ત\u{acd}રી",
                "જીવવિજ\u{acd}ઞાની",
                "પ\u{ac1}ર\u{ac1}ષ",
                "ભૌતિકવિજ\u{acd}ઞાની",
                "રસાયણશાસ\u{acd}ત\u{acd}રી",
                "વ\u{ac8}જ\u{acd}ઞાનિક",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum masanin kimiya"),
            keywords: &[
                "injiniya",
                "mai ilimin lissafi",
                "masanin ilimin fiziks",
                "masanin ilimin halittu",
                "masanin kimiya",
                "mutum",
                "mutum masanin kimiya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מדען"),
            keywords: &["איש", "ביולוג", "גבר", "כימאי", "מדען", "מהנדס", "פיזיקאי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "आदमी",
                "इ\u{902}जीनियर",
                "गणितज\u{94d}ञ",
                "जीवविज\u{94d}ञानी",
                "प\u{941}र\u{941}ष",
                "भौतिक विज\u{94d}ञानी",
                "रसायनज\u{94d}ञ",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znanstvenik"),
            keywords: &["biolog", "fizičar", "inženjer", "kemičar", "znanstvenik"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi tudós"),
            keywords: &["fizikus", "férfi", "férfi tudós", "kémikus", "matematikus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ գիտնական"),
            keywords: &["գիտնական", "կենսաբան", "տղամարդ", "քիմիկոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ilmuwan pria"),
            keywords: &["ilmuwan pria", "laboratorium", "laki-laki", "sains"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke ọkammụta sayensi"),
            keywords: &[
                "injineer",
                "nwoke",
                "nwoke ọkammụta sayensi",
                "oree ọgwụ",
                "ọkammụta ahụ mmadụ",
                "ọkammụta phizisi",
                "ọkammụta sayensi",
                "ọkammụta sọm",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vísindamaður"),
            keywords: &["efnafræði", "karl", "rannsóknir", "vísindamaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scienziato"),
            keywords: &["biologia", "chimica", "scienza", "scienziato", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性科学者"),
            keywords: &["男", "男性", "男性科学者", "科学者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ilmuwan lanang"),
            keywords: &[
                "ahli biologi",
                "ahli fisika",
                "ahli kimia",
                "ilmuwan",
                "insinyur",
                "lanang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეცნიერი კაცი"),
            keywords: &[
                "ბილოგი",
                "კაცი",
                "მათემატიკოსი",
                "მეცნიერი",
                "ფიზიკოსი",
                "ქიმიკოსი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер ғалым"),
            keywords: &["биолог", "ер", "инженер", "ғалым"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("forsker"),
            keywords: &[
                "forsker",
                "naturvidenskab",
                "naturvidenskabsmand",
                "videnskab",
                "videnskabsmand",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "គ\u{17b8}ម\u{17b8}វ\u{17b7}ទ\u{17bc}",
                "ជ\u{17b8}វវ\u{17b7}ទ\u{17bc}",
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "រ\u{17bc}បវ\u{17b7}ទ\u{17bc}",
                "វ\u{17b7}ស\u{17d2}វករ",
                "អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រ",
                "អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}"),
            keywords: &[
                "ಎಂಜ\u{cbf}ನ\u{cbf}ಯರ\u{ccd}",
                "ಗಣ\u{cbf}ತಜ\u{ccd}ಞ",
                "ಜೀವಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ಪುರುಷ ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}",
                "ರಸಾಯನಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 과학자"),
            keywords: &[
                "과학자",
                "남자",
                "물리학자",
                "생물학자",
                "실험",
                "실험실",
                "연구자",
                "화학자",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो शास\u{94d}त\u{94d}रज\u{94d}ञ"),
            keywords: &[
                "इ\u{902}जिनियर",
                "जीवशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "दादलो",
                "फिजिसिस\u{94d}ट",
                "रसायनशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "शास\u{94d}त\u{94d}रज\u{94d}ञ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек илимпоз"),
            keywords: &[
                "биолог",
                "инженер",
                "окумуштуу",
                "химик",
                "эркек",
                "эркек илимпоз",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wëssenschaftler"),
            keywords: &[
                "Biolog",
                "Chemiker",
                "Ingenieur",
                "Mann",
                "Mathematiker",
                "Physiker",
                "Wëssenschaftler",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດຊາຍ"),
            keywords: &[
                "ນ\u{eb1}ກຊ\u{eb5}ວະສາດ",
                "ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດຊາຍ",
                "ນ\u{eb1}ກເຄມ\u{eb5}ສາດ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ວ\u{eb4}ສະວະກອນ",
                "ແພດ",
                "ໝ\u{ecd}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokslininkas"),
            keywords: &[
                "biologas",
                "chemikas",
                "fizikas",
                "inžinierius",
                "matematikas",
                "mokslininkas",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zinātnieks"),
            keywords: &[
                "biologs",
                "fiziķis",
                "inženieris",
                "matemātiķis",
                "vīrietis",
                "zinātnieks",
                "ķīmiķis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaimātai pūtaiao tāne"),
            keywords: &[
                "kaimātai ahupūngao",
                "kaimātai koiora",
                "kaimātai matū",
                "kaimātai pāngarau",
                "kaimātai pūhanga",
                "kaimātai pūtaiao",
                "kaimātai pūtaiao tāne",
                "tāne",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж научник"),
            keywords: &["биолог", "инженер", "маж", "научник", "хемичар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ശ\u{d3e}സ\u{d4d}ത\u{d4d}രജ\u{d4d}ഞൻ"),
            keywords: &[
                "ഊർജ\u{d4d}ജതന\u{d4d}ത\u{d4d}രജ\u{d4d}ഞൻ",
                "കെമിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "ബയോളജിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "ശ\u{d3e}സ\u{d4d}ത\u{d4d}രജ\u{d4d}ഞൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй эрдэмтэн"),
            keywords: &[
                "биологич",
                "инженер",
                "физикч",
                "химич",
                "эрэгтэй",
                "эрэгтэй эрдэмтэн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{941}ष व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "अभिय\u{902}ता",
                "गणितज\u{94d}ञ",
                "जीवशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "प\u{941}र\u{941}ष व\u{948}ज\u{94d}ञानिक",
                "प\u{941}र\u{942}ष",
                "भौतिकशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "रसायनशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("saintis lelaki"),
            keywords: &[
                "ahli biologi",
                "ahli fizik",
                "ahli kimia",
                "ahli matematik",
                "jurutera",
                "lelaki",
                "saintis",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xjenzat maskili"),
            keywords: &[
                "bijologu",
                "fiżiċist",
                "inġiniera",
                "matematiku",
                "raġel",
                "spiżjar",
                "xjenzat",
                "xjenzat maskili",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}"),
            keywords: &[
                "ဇ\u{102e}ဝဗေဒပညာရ\u{103e}င\u{103a}",
                "ဓာတ\u{102f}ဗေဒပညာရ\u{103e}င\u{103a}",
                "ရ\u{1030}ပဗေဒ ပညာရ\u{103e}င\u{103a}",
                "သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
                "အင\u{103a}ဂျင\u{103a}န\u{102e}ယာ",
                "အမျ\u{102d}\u{102f}းသား သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig forsker"),
            keywords: &[
                "kjemi",
                "laboratorium",
                "mann",
                "mannlig forsker",
                "vitenskap",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{942}ष व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "इञ\u{94d}जिनियर",
                "जीव शास\u{94d}त\u{94d}री",
                "प\u{941}र\u{942}ष",
                "भौतिक शास\u{94d}त\u{94d}री",
                "रसायन शास\u{94d}त\u{94d}री",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke wetenschapper"),
            keywords: &[
                "bioloog",
                "ingenieur",
                "man",
                "mannelijke wetenschapper",
                "natuurkundige",
                "scheikundige",
                "wetenschapper",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg forskar"),
            keywords: &[
                "kjemi",
                "laboratorium",
                "mann",
                "mannleg forskar",
                "vitskap",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ"),
            keywords: &[
                "ଇଞ\u{b4d}ଜ\u{b3f}ନ\u{b3f}ୟର\u{b4d}\u{200c}",
                "ଜୀବବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନୀ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ",
                "ଭୌତ\u{b3f}କ ବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନୀ",
                "ରସ\u{b3e}ୟନବ\u{b3f}ତ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਵਿਗਿਆਨੀ"),
            keywords: &[
                "ਇ\u{a70}ਜੀਨੀਅਰ",
                "ਕ\u{a48}ਮਿਸਟ",
                "ਜੀਵ-ਵਿਗਿਆਨੀ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਵਿਗਿਆਨੀ",
                "ਬ\u{a70}ਦਾ",
                "ਭ\u{a4c}ਤਿਕ ਵਿਗਿਆਨੀ",
                "ਹਿਸਾਬਦਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد سائنسدان"),
            keywords: &[
                "انجینیئر",
                "بندہ",
                "ریاضی دان",
                "سائنسدان",
                "ماہر حیاتیات",
                "ماہر طبعیات",
                "مرد سائنسدان",
                "کیمیا دان",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Sáyẹ\u{301}ns Ẹ\u{301}spat"),
            keywords: &[
                "Bayọ\u{301}lọ\u{301}gí Ẹ\u{301}spat",
                "Fízíks Ẹ\u{301}spat",
                "Kẹ\u{301}místrí Ẹ\u{301}spat",
                "Man",
                "Mán Sáyẹ\u{301}ns Ẹ\u{301}spat",
                "Sáyẹ\u{301}ns",
                "Ẹnjinia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna naukowiec"),
            keywords: &[
                "biolog",
                "chemik",
                "inżynier",
                "mężczyzna",
                "mężczyzna naukowiec",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړي څېړونکی"),
            keywords: &[
                "انجينير",
                "د بيالوژي پوهاند",
                "د فزکس پوهاند",
                "سائينس دان",
                "سړي څېړونکی",
                "کيميا ګر",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cientista homem"),
            keywords: &[
                "biólogo",
                "cientista homem",
                "físico",
                "homem",
                "professor",
                "químico",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cientista (homem)"),
            keywords: &[
                "biólogo",
                "cientista (homem)",
                "engenheiro",
                "farmacêutico",
                "matemático",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata hamut’asqa"),
            keywords: &[
                "biologo",
                "fisico",
                "hamut’asqa",
                "ingeniero",
                "quimico",
                "tata",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("om de știință bărbat"),
            keywords: &[
                "biolog",
                "bărbat",
                "chimist",
                "fizician",
                "inginer",
                "om de știință",
                "om de știință bărbat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1171"),
            keywords: &["E10-1171"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-ученый"),
            keywords: &[
                "биология",
                "мужчина",
                "мужчина-ученый",
                "наука",
                "ученый",
                "химия",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo w’impuguke mu bya siyansi"),
            keywords: &[
                "impuguke mu bya siyansi",
                "injeniyeri",
                "umpuguke mu by’ibinyabuzima",
                "umpuguke mu by’ubutabire",
                "umpuguke mu by’ubutabire mu by’ubugenge",
                "umugabo",
                "umugabo w’impuguke mu bya siyansi",
                "umunyamibare",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد سائنسدان"),
            keywords: &[
                "مرد سائنسدان",
                "مرد، سائنسدان، انجنيئر، رياضي دان، ڪيمسٽ، ماهر طبيعيات، ماهر حياتيات",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}"),
            keywords: &[
                "ඉංජ\u{dd2}නේර\u{dd4}ව\u{dcf}",
                "ගණ\u{dd2}තඥය\u{dcf}",
                "ජ\u{dd3}වව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "භෞත\u{dd2}කඥය\u{dcf}",
                "ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vedec muž"),
            keywords: &["inžinier", "muž", "vedec", "výskum"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znanstvenik"),
            keywords: &[
                "biolog",
                "fant",
                "fizik",
                "inženir",
                "kemik",
                "matematik",
                "moški",
                "znanstvenik",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qabiir saynisyahan ah"),
            keywords: &[
                "cilmiga nafleeyda barta",
                "farmashiiste",
                "injineer",
                "khabiirka cilmiga sayniska",
                "khabiirka fiisikiska",
                "nin",
                "qabiir saynisyahan ah",
                "saynisyahan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shkencëtar"),
            keywords: &["biolog", "fizikan", "kimist", "shkencëtar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("научник"),
            keywords: &["биолог", "мушкарац", "научник", "хемичар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("naučnik"),
            keywords: &["biolog", "hemičar", "muškarac", "naučnik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig forskare"),
            keywords: &[
                "kemi",
                "laboratorium",
                "man",
                "manlig forskare",
                "vetenskap",
                "vetenskapsman",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanasayansi wa kiume"),
            keywords: &[
                "hadubini",
                "miwani",
                "mwanasayansi",
                "mwanasayansi wa kiume",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} விஞ\u{bcd}ஞ\u{bbe}னி"),
            keywords: &["அறிவியல\u{bcd}", "ஆண\u{bcd}", "விஞ\u{bcd}ஞ\u{bbe}னி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3e}స\u{c4d}త\u{c4d}రజ\u{c4d}ఞుడు"),
            keywords: &[
                "ఇంజ\u{c3f}న\u{c40}ర\u{c4d}",
                "క\u{c46}మ\u{c3f}స\u{c4d}ట\u{c4d}",
                "పురుషుడు",
                "బయ\u{c3e}లజ\u{c3f}స\u{c4d}ట\u{c4d}",
                "భ\u{c4c}త\u{c3f}క శ\u{c3e}స\u{c4d}త\u{c4d}రవ\u{c47}త\u{c4d}త",
                "శ\u{c3e}స\u{c4d}త\u{c4d}రజ\u{c4d}ఞుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди олим"),
            keywords: &[
                "биолог",
                "кимиёшинос",
                "мард",
                "марди олим",
                "математик",
                "муҳандис",
                "олим",
                "физик",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e31}กว\u{e34}ทยาศาสตร\u{e4c}ชาย"),
            keywords: &[
                "น\u{e31}กช\u{e35}วว\u{e34}ทยา",
                "น\u{e31}กฟ\u{e34}ส\u{e34}กส\u{e4c}",
                "น\u{e31}กว\u{e34}ทยาศาสตร\u{e4c}",
                "น\u{e31}กว\u{e34}ทยาศาสตร\u{e4c}ชาย",
                "น\u{e31}กเคม\u{e35}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek alym"),
            keywords: &["alym", "biolog", "erkek", "fizik", "himik", "inžener"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata faisaienisi"),
            keywords: &["tangata faisaienisi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek bilim insanı"),
            keywords: &[
                "adam",
                "bilim adamı",
                "biyolog",
                "erkek",
                "erkek bilim insanı",
                "fizikçi",
                "kimyacı",
                "matematikçi",
                "mühendis",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر ئالىم"),
            keywords: &[
                "ئالىم",
                "ئىنژىنېر",
                "ئەر",
                "بىيولوگ",
                "خىمىك",
                "فىزىك",
                "ماتېماتىك",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("науковець"),
            keywords: &[
                "біолог",
                "науковець",
                "фізик",
                "хімік",
                "чоловік",
                "інженер",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد سائنسدان"),
            keywords: &["بیالوجسٹ", "سائنسدان", "مرد", "کیمسٹ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak olim"),
            keywords: &["biolog", "erkak", "kimyogar", "muhandis", "olim"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhà khoa học nam"),
            keywords: &[
                "kỹ sư",
                "người đàn ông",
                "nhà hóa học",
                "nhà khoa học",
                "nhà khoa học nam",
                "nhà sinh vật học",
                "nhà vật lý",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xaralakat bu góor"),
            keywords: &[
                "biyolosist",
                "engeñër",
                "fisiyee",
                "góor",
                "matematisiyee",
                "simist",
                "xaralakat",
                "xaralakat bu góor",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isazinzulu esiyindoda"),
            keywords: &[
                "igcisa lebhayoloji",
                "igcisa lefizikisi",
                "ikhemesti",
                "indoda",
                "ingcali yemathematika",
                "isazinzulu",
                "isazinzulu esiyindoda",
                "unonjineli",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrín síyẹ\u{301}nsì"),
            keywords: &[
                "bìyólọ\u{301}gì",
                "físísítì",
                "kẹ\u{301}mísítì",
                "onímọ\u{300} lrọ",
                "onímọ\u{300} síyẹ\u{301}nsì",
                "onímọ\u{300} ìṣirò",
                "ọkùnrin",
                "ọkùnrín síyẹ\u{301}nsì",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男科學家"),
            keywords: &[
                "化學家",
                "工程師",
                "物理學家",
                "生物學家",
                "男科學家",
                "科學家",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男科学家"),
            keywords: &[
                "化学家",
                "工程师",
                "数学家",
                "物理学家",
                "生物学家",
                "男",
                "男科学家",
                "科学家",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男科学家"),
            keywords: &[
                "化学家",
                "工程学家",
                "物理学家",
                "生物学家",
                "男",
                "男科学家",
                "科学家",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男科學家"),
            keywords: &["男", "男科學家", "科學家"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("usosayensi wesilisa"),
            keywords: &[
                "indoda",
                "unjiniyela",
                "usokhemesi",
                "usosayensi",
                "usosayensi wesilisa",
            ],
        },
    ],
};
#[doc = "👨🏻\u{200d}🔬"]
pub const MAN_SCIENTIST_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🔬",
    codepoint: "1F468 1F3FB 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man scientist: light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🔬"]
pub const MAN_SCIENTIST_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🔬",
    codepoint: "1F468 1F3FC 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man scientist: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🔬"]
pub const MAN_SCIENTIST_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🔬",
    codepoint: "1F468 1F3FD 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man scientist: medium skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🔬"]
pub const MAN_SCIENTIST_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🔬",
    codepoint: "1F468 1F3FE 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man scientist: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🔬"]
pub const MAN_SCIENTIST_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🔬",
    codepoint: "1F468 1F3FF 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man scientist: dark skin tone",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🔬"]
pub const WOMAN_SCIENTIST: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🔬",
    codepoint: "1F469 200D 1F52C",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman scientist",
    group: "People & Body",
    subgroup: "person-role",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike wetenskaplike"),
            keywords: &[
                "bioloog",
                "proefbuis",
                "vroulike wetenskaplike",
                "wetenskaplike",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ሳይንቲስት"),
            keywords: &["ሳይንቲስት", "ሴት", "ባዮሎጂስት", "ኢንጂነር", "ኬሚስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عال\u{650}مة"),
            keywords: &["بيولوجية", "عال\u{650}مة", "فيزيائية", "كيميائية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} বৈজ\u{9cd}ঞ\u{9be}নিক"),
            keywords: &[
                "ইঞ\u{9cd}জিনিয\u{9bc}\u{9be}ৰ",
                "গণিতজ\u{9cd}ঞ",
                "জীৱবিজ\u{9cd}ঞ\u{9be}নী",
                "পদ\u{9be}ৰ\u{9cd}থ বিজ\u{9cd}ঞ\u{9be}নী",
                "বৈজ\u{9cd}ঞ\u{9be}নিক",
                "মহিল\u{9be}",
                "ৰস\u{9be}য\u{9bc}নবিদ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın alim"),
            keywords: &[
                "alim",
                "bioloq",
                "fizik",
                "kimyaçı",
                "mühəndis",
                "qadın",
                "riyaziyyatçı",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вучоная"),
            keywords: &[
                "біёлаг",
                "вучоная",
                "жанчына",
                "жанчына-навуковец",
                "фізік",
                "хімік",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена учен"),
            keywords: &[
                "биолог",
                "жена учен",
                "инженер",
                "математичка",
                "научна работничка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} বিজ\u{9cd}ঞ\u{9be}নী"),
            keywords: &[
                "ইঞ\u{9cd}জিনিয\u{9bc}\u{9be}র",
                "জীববিজ\u{9cd}ঞ\u{9be}নী",
                "বিজ\u{9cd}ঞ\u{9be}নী",
                "মহিল\u{9be}",
                "রস\u{9be}য\u{9bc}নবিদ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skiantourez"),
            keywords: &["skiantourez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("naučnica"),
            keywords: &[
                "biologinja",
                "fizičarka",
                "hemičarka",
                "inžinjerka",
                "naučnica",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("científica"),
            keywords: &["biòloga", "científica", "enginyera", "física", "química"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄝\u{11128}𑄉\u{11133}𑄠\u{11134}𑄚\u{11128}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄝\u{11128}𑄉\u{11133}𑄠\u{11134}𑄚\u{11128}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᎦᏛᎲᏍᎩ"),
            keywords: &["ᎠᎨᏯ", "ᎤᎦᏛᎲᏍᎩ", "ᎤᎦᏛᏂᏙᎯ", "ᏗᏎᏍᏗ ᏧᎦᏎᏍᏗ", "ᏗᏟᎶᏍᏔᏅᎲᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vědkyně"),
            keywords: &[
                "bioložka",
                "chemička",
                "fyzička",
                "inženýrka",
                "matematička",
                "věda",
                "vědkyně",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("gwyddonwraig"),
            keywords: &["biolegydd", "cemegydd", "gwyddonwraig", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig forsker"),
            keywords: &[
                "kvinde",
                "kvindelig forsker",
                "naturvidenskab",
                "videnskab",
                "videnskabsmand",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wissenschaftlerin"),
            keywords: &["Forscherin", "Labor", "Wissenschaftlerin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα επιστήμονας"),
            keywords: &[
                "έρευνα",
                "βιολόγος",
                "γυναίκα επιστήμονας",
                "επιστήμονας",
                "χημικός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman scientist"),
            keywords: &[
                "biologist",
                "chemist",
                "engineer",
                "physicist",
                "scientist",
                "woman",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("profesional de la ciencia mujer"),
            keywords: &[
                "bióloga",
                "científica",
                "física",
                "mujer",
                "profesional de la ciencia mujer",
                "química",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisteadlane"),
            keywords: &["bioloog", "füüsik", "insener", "keemik", "naisteadlane"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume zientzialaria"),
            keywords: &[
                "biologoa",
                "emakume zientzialaria",
                "emakumea",
                "emakumezkoa",
                "fisikaria",
                "ingeniaria",
                "kimikaria",
                "zientzialaria",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دانشمند زن"),
            keywords: &[
                "دانشمند زن",
                "زیست\u{200c}شناس",
                "شیمی\u{200c}دان",
                "فیزیک\u{200c}دان",
                "محقق",
                "میکروب\u{200c}شناس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naistutkija"),
            keywords: &["nainen", "naistutkija", "tiede", "tutkija"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng siyentipiko"),
            keywords: &["babaeng siyentipiko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vísindakvinna"),
            keywords: &[
                "kona",
                "kvinna",
                "náttúruvísindi",
                "vísind",
                "vísindakvinna",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("scientifique femme"),
            keywords: &["chimiste", "femme", "scientifique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "biologiste",
                "chimiste",
                "femme",
                "physicienne",
                "scientifique",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("eolaí baineann"),
            keywords: &[
                "bean",
                "bitheolaí",
                "ceimiceoir",
                "eolaí",
                "eolaí baineann",
                "fisiceoir",
                "innealtóir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach-saidheans boireann"),
            keywords: &[
                "bith-eòlaiche",
                "boireannach",
                "ceimigear",
                "einnseanair",
                "fiosaigiche",
                "innleadair",
                "matamataigear",
                "neach-saidheans",
                "neach-saidheans boireann",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("científica"),
            keywords: &["bióloga", "científica", "muller", "química"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી વ\u{ac8}જ\u{acd}ઞાનિક"),
            keywords: &[
                "એન\u{acd}જિનિઅર",
                "ગણિતશાસ\u{acd}ત\u{acd}રી",
                "જીવવિજ\u{acd}ઞાની",
                "ભૌતિકવિજ\u{acd}ઞાની",
                "રસાયણશાસ\u{acd}ત\u{acd}રી",
                "વ\u{ac8}જ\u{acd}ઞાનિક",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace masanin kimiya"),
            keywords: &[
                "injiniya",
                "mace",
                "mace masanin kimiya",
                "mai ilimin lissafi",
                "masanin ilimin fiziks",
                "masanin ilimin halittu",
                "masanin kimiya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מדענית"),
            keywords: &["אישה", "ביולוגית", "כימאית", "מדענית", "מהנדסת", "פיזיקאית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "इ\u{902}जीनियर",
                "गणितज\u{94d}ञ",
                "जीवविज\u{94d}ञानी",
                "भौतिक विज\u{94d}ञानी",
                "महिला",
                "रसायनज\u{94d}ञ",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znanstvenica"),
            keywords: &[
                "biologinja",
                "fizičarka",
                "inženjerka",
                "kemičarka",
                "znanstvenica",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női tudós"),
            keywords: &["fizikus", "kémikus", "matematikus", "nő", "női tudós"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին գիտնական"),
            keywords: &["գիտնական", "կենսաբան", "կին", "քիմիկոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("ilmuwan wanita"),
            keywords: &["ilmuwan wanita", "laboratorium", "perempuan", "sains"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị ọkammụta sayensi"),
            keywords: &[
                "injineer",
                "nwanyị",
                "nwanyị ọkammụta sayensi",
                "oree ọgwụ",
                "ọkammụta ahụ mmadụ",
                "ọkammụta phizisi",
                "ọkammụta sayensi",
                "ọkammụta sọm",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vísindakona"),
            keywords: &[
                "efnafræði",
                "kona",
                "rannsóknir",
                "vísindakona",
                "vísindamaður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("scienziata"),
            keywords: &["biologia", "chimica", "donna", "scienza", "scienziata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性科学者"),
            keywords: &["女", "女性", "女性科学者", "科学者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ilmuwan wadon"),
            keywords: &[
                "ahli biologi",
                "ahli fisika",
                "ahli kimia",
                "ilmuwan",
                "insinyur",
                "wadon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მეცნიერი ქალი"),
            keywords: &[
                "ბილოგი",
                "მათემატიკოსი",
                "მეცნიერი",
                "ფიზიკოსი",
                "ქალი",
                "ქიმიკოსი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ғалым әйел"),
            keywords: &["биолог", "инженер", "ғалым", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvindelig forsker"),
            keywords: &[
                "kvinde",
                "kvindelig forsker",
                "naturvidenskab",
                "videnskab",
                "videnskabsmand",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "គ\u{17b8}ម\u{17b8}វ\u{17b7}ទ\u{17bc}",
                "ជ\u{17b8}វវ\u{17b7}ទ\u{17bc}",
                "នារ\u{17b8}",
                "រ\u{17bc}បវ\u{17b7}ទ\u{17bc}",
                "វ\u{17b7}ស\u{17d2}វករ",
                "ស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រ",
                "អ\u{17d2}នកវ\u{17b7}ទ\u{17d2}យាសាស\u{17d2}ត\u{17d2}រស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳಾ ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}"),
            keywords: &[
                "ಎಂಜ\u{cbf}ನ\u{cbf}ಯರ\u{ccd}",
                "ಭ\u{ccc}ತಶಾಸ\u{ccd}ತ\u{ccd}ರಜ\u{ccd}ಞ",
                "ಮಹ\u{cbf}ಳಾ ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ವ\u{cbf}ಜ\u{ccd}ಞಾನ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 과학자"),
            keywords: &[
                "과학자",
                "물리학자",
                "생물학자",
                "실험",
                "실험실",
                "여자",
                "연구자",
                "화학자",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल शास\u{94d}त\u{94d}रज\u{94d}ञ"),
            keywords: &["बायल शास\u{94d}त\u{94d}रज\u{94d}ञ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял илимпоз"),
            keywords: &["аял", "аял илимпоз", "инженер", "окумуштуу", "химик"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Wëssenschaftlerin"),
            keywords: &[
                "Biolog",
                "Chemikerin",
                "Fra",
                "Ingenieur",
                "Mathematikerin",
                "Physikerin",
                "Wëssenschaftlerin",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດຍ\u{eb4}ງ"),
            keywords: &[
                "ນ\u{eb1}ກຊ\u{eb5}ວະສາດ",
                "ນ\u{eb1}ກວ\u{eb4}ທະຍາສາດຍ\u{eb4}ງ",
                "ນ\u{eb1}ກເຄມ\u{eb5}ສາດ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ວ\u{eb4}ສະວະກອນ",
                "ແພດ",
                "ໝ\u{ecd}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mokslininkė"),
            keywords: &[
                "biologė",
                "chemikė",
                "fizikė",
                "inžinierė",
                "matematikė",
                "mokslininkė",
                "moteris",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zinātniece"),
            keywords: &[
                "bioloģe",
                "fiziķe",
                "inženiere",
                "matemātiķe",
                "sieviete",
                "zinātniece",
                "ķīmiķe",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaimātai pūtaiao wahine"),
            keywords: &[
                "kaimātai ahupūngao",
                "kaimātai koiora",
                "kaimātai matū",
                "kaimātai pāngarau",
                "kaimātai pūhanga",
                "kaimātai pūtaiao",
                "kaimātai pūtaiao wahine",
                "wahine",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена научник"),
            keywords: &["биолог", "жена", "жена научник", "инженер", "хемичар"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ശ\u{d3e}സ\u{d4d}ത\u{d4d}രജ\u{d4d}ഞ"),
            keywords: &[
                "ഊർജ\u{d4d}ജതന\u{d4d}ത\u{d4d}രജ\u{d4d}ഞ",
                "കെമിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "ബയോളജിസ\u{d4d}റ\u{d4d}റ\u{d4d}",
                "ശ\u{d3e}സ\u{d4d}ത\u{d4d}രജ\u{d4d}ഞ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй эрдэмтэн"),
            keywords: &[
                "биологич",
                "инженер",
                "физикч",
                "химич",
                "эмэгтэй",
                "эмэгтэй эрдэмтэн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "अभिय\u{902}ता",
                "गणितज\u{94d}ञ",
                "जीवशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "भौतिकशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "महिला व\u{948}ज\u{94d}ञानिक",
                "रसायनशास\u{94d}त\u{94d}रज\u{94d}ञ",
                "व\u{948}ज\u{94d}ञानिक महिला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("saintis wanita"),
            keywords: &[
                "ahli biologi",
                "ahli fizik",
                "ahli kimia",
                "saintis",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("xjenzata mara"),
            keywords: &[
                "bijologu",
                "fiżiċist",
                "inġinier",
                "mara",
                "matematiku",
                "spiżjar",
                "xjenzat",
                "xjenzata mara",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
            ),
            keywords: &[
                "ဇ\u{102e}ဝဗေဒပညာရ\u{103e}င\u{103a}",
                "ဓာတ\u{102f}ဗေဒပညာရ\u{103e}င\u{103a}",
                "ရ\u{1030}ပဗေဒပညာရ\u{103e}င\u{103a}",
                "သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
                "အင\u{103a}ဂျင\u{103a}န\u{102e}ယာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း သ\u{102d}ပ\u{1039}ပ\u{1036}ပညာရ\u{103e}င\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig forsker"),
            keywords: &[
                "kjemi",
                "kvinne",
                "kvinnelig forsker",
                "laboratorium",
                "vitenskap",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिला व\u{948}ज\u{94d}ञानिक"),
            keywords: &[
                "इञ\u{94d}जिनियर",
                "जीव शास\u{94d}त\u{94d}री",
                "भौतिक शास\u{94d}त\u{94d}री",
                "महिला",
                "रसायन शास\u{94d}त\u{94d}री",
                "व\u{948}ज\u{94d}ञानिक",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("wetenschapster"),
            keywords: &[
                "biologe",
                "ingenieur",
                "natuurkundige",
                "scheikundige",
                "vrouw",
                "wetenschapster",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg forskar"),
            keywords: &[
                "kjemi",
                "kvinne",
                "kvinneleg forskar",
                "laboratorium",
                "vitskap",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ"),
            keywords: &[
                "ଇଞ\u{b4d}ଜ\u{b3f}ନ\u{b3f}ୟର\u{b4d}\u{200c}",
                "ଜୀବବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନୀ",
                "ବୈଜ\u{b4d}ଞ\u{b3e}ନ\u{b3f}କ",
                "ଭୌତ\u{b3f}କ ବ\u{b3f}ଜ\u{b4d}ଞ\u{b3e}ନୀ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ରସ\u{b3e}ୟନବ\u{b3f}ତ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਵਿਗਿਆਨੀ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਵਿਗਿਆਨੀ",
                "ਇ\u{a70}ਜੀਨੀਅਰ",
                "ਔਰਤ",
                "ਕ\u{a48}ਮਿਸਟ",
                "ਜੀਵ-ਵਿਗਿਆਨੀ",
                "ਭ\u{a4c}ਤਿਕ ਵਿਗਿਆਨੀ",
                "ਹਿਸਾਬਦਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سائنسدان زنانی"),
            keywords: &[
                "انجینیئر",
                "ریاضی دان",
                "زنانی",
                "سائنسدان",
                "ماہر حیاتیات",
                "ماہر طبعیات",
                "کیمیا دان",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Sáyẹ\u{301}ns Ẹ\u{301}spat"),
            keywords: &[
                "Bayọ\u{301}lọ\u{301}gí Ẹ\u{301}spat",
                "Fízíks Ẹ\u{301}spat",
                "Kẹ\u{301}místrí Ẹ\u{301}spat",
                "Sáyẹ\u{301}ns",
                "Wúman",
                "Wúmán Sáyẹ\u{301}ns Ẹ\u{301}spat",
                "Ẹnjinia",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta naukowiec"),
            keywords: &[
                "biolog",
                "chemik",
                "inżynier",
                "kobieta",
                "kobieta naukowiec",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه څېړونکی"),
            keywords: &[
                "انجينير",
                "د بيالوژي پوهاند",
                "د فزکس پوهاند",
                "سائينس دان",
                "ښځه څېړونکی",
                "کيميا ګر",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cientista mulher"),
            keywords: &[
                "bióloga",
                "cientista mulher",
                "física",
                "mulher",
                "professora",
                "química",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("cientista (mulher)"),
            keywords: &[
                "bióloga",
                "cientista (mulher)",
                "engenheira",
                "farmacêutica",
                "matemática",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi hamut’asqa"),
            keywords: &[
                "biologa",
                "fisica",
                "hamut’asqa",
                "ingeniera",
                "quimica",
                "warmi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("om de știință femeie"),
            keywords: &[
                "biologă",
                "chimistă",
                "femeie",
                "fiziciană",
                "inginer",
                "om de știință",
                "om de știință femeie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1187"),
            keywords: &["E10-1187"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ученая"),
            keywords: &["биология", "женщина", "наука", "ученая", "химия"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("impugukekazi mu bya siyansi"),
            keywords: &[
                "enjeniyeri",
                "impuguke mu bya siyansi",
                "impuguke mu by’ibinyabuzima",
                "impuguke mu by’ubugenge",
                "impuguke mu by’ubutabire",
                "impuguke mu mibare",
                "impugukekazi mu bya siyansi",
                "umugore",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت سائنسدان"),
            keywords: &[
                "عورت سائنسدان",
                "عورت، سائنسدان، انجنيئر، رياضي دان، ڪيمسٽ، ماهر طبيعيات، ماهر حياتيات",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥවර\u{dd2}ය"),
            keywords: &[
                "ඉංජ\u{dd2}නේර\u{dd4}වර\u{dd2}ය",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ගණ\u{dd2}තඥය\u{dcf}",
                "ජ\u{dd3}වව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥය\u{dcf}",
                "භෞත\u{dd2}කඥය\u{dcf}",
                "ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ඥවර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vedkyňa"),
            keywords: &["inžinierka", "vedkyňa", "výskum", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znanstvenica"),
            keywords: &[
                "biologinja",
                "dekle",
                "fizika",
                "inženirka",
                "kemija",
                "matematika",
                "znanstvenica",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
         