#[doc = "🧘"]
pub const PERSON_IN_LOTUS_POSITION: crate::Emoji = crate::Emoji {
    glyph: "🧘",
    codepoint: "1F9D8",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person in lotus position",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon in die lotusposisie"),
            keywords: &["joga", "meditasie", "persoon in die lotusposisie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሎታስ ኣቀማመጥ"),
            keywords: &["በሎታስ ኣቀማመጥ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص مترب\u{651}ع"),
            keywords: &["شخص مترب\u{651}ع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পদ\u{9cd}ম\u{9be}সন কৰ\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ধ\u{9cd}য\u{9be}ন",
                "পদ\u{9cd}ম\u{9be}সন কৰ\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "যোগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lotus pozisiyasında adam"),
            keywords: &["lotus pozisiyasında adam", "meditasiya", "yoqa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек у позе лотаса"),
            keywords: &["медытацыя", "чалавек у позе лотаса", "ёга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("човек в поза „лотус“"),
            keywords: &["йога", "медитация", "човек в поза „лотус“"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পদ\u{9cd}ম\u{9be}সনে বস\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ধ\u{9cd}য\u{9be}ন",
                "পদ\u{9cd}ম\u{9be}সনে বস\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "যোগ\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba u položaju lotosa"),
            keywords: &["joga", "meditacija", "osoba u položaju lotosa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona en la posició de lotus"),
            keywords: &[
                "ioga",
                "lotus",
                "meditació",
                "persona en la posició de lotus",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᏚᏓᏝᏗᏍᏗ"),
            keywords: &["ᎤᏯᏪᏐᎸᏢᎢ ᎠᏓᏅᏖᏢᏍᎬᎢ", "ᏲᎦ", "ᏴᏫ ᏚᏓᏝᏗᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba v lotosovém sedu"),
            keywords: &[
                "jóga",
                "lotos",
                "lotosová",
                "meditace",
                "osoba v lotosovém sedu",
                "pozice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person mewn ystum lingroes"),
            keywords: &["myfyrdod", "person mewn ystum lingroes", "yoga"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lotusstilling"),
            keywords: &["lotusstilling", "meditation", "yoga"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Person im Lotossitz"),
            keywords: &["Meditation", "Person im Lotossitz", "Yoga"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο σε θέση λωτού"),
            keywords: &["άτομο σε θέση λωτού", "γιόγκα", "διαλογισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person in lotus position"),
            keywords: &["meditation", "person in lotus position", "yoga"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona en posición de loto"),
            keywords: &["meditación", "persona en posición de loto", "yoga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lootosasendis inimene"),
            keywords: &["jooga", "lootosasendis inimene", "meditatsioon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona bat loto-posizioan"),
            keywords: &["meditazio", "pertsona bat loto-posizioan", "yoga"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فرد در حالت خلسه"),
            keywords: &["خلسه", "فرد در حالت خلسه", "مکاشفه", "یوگا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("henkilö lootusasennossa"),
            keywords: &["henkilö lootusasennossa", "jooga", "mietiskely"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tao na naka-lotus position"),
            keywords: &["meditation", "tao na naka-lotus position", "yoga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur í lotusstøðu"),
            keywords: &[
                "fólk",
                "joga",
                "lotus",
                "lotusstøða",
                "meditatión",
                "persónur",
                "persónur í lotusstøðu",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne dans la posture du lotus"),
            keywords: &[
                "méditation",
                "personne dans la posture du lotus",
                "position du lotus",
                "yoga",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine i suíomh na loiteoige"),
            keywords: &["ag machnamh", "duine i suíomh na loiteoige", "ióga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach na shuidhe lòtais"),
            keywords: &["meòrachadh", "neach na shuidhe lòtais", "yoga"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ioga"),
            keywords: &["ioga", "meditación", "posición de loto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{acd}યક\u{acd}તિ કમળ જ\u{ac7}વી સ\u{acd}થિતિમા\u{a82}"),
            keywords: &[
                "ધ\u{acd}યાન",
                "યોગ",
                "વ\u{acd}યક\u{acd}તિ કમળ જ\u{ac7}વી સ\u{acd}થિતિમા\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum a wurin furen lotus"),
            keywords: &["mutum a wurin furen lotus", "tsokaci", "yoga"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מישהי בתנוחת לוטוס"),
            keywords: &["יוגה", "לוטוס", "מדיטציה", "מישהי בתנוחת לוטוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पद\u{94d}मासन म\u{947}\u{902} ब\u{948}ठा व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "ध\u{94d}यान",
                "पद\u{94d}मासन म\u{947}\u{902} ब\u{948}ठा व\u{94d}यक\u{94d}ति",
                "योग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba u položaju lotosa"),
            keywords: &["meditacija", "osoba u položaju lotosa", "yoga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ember lótuszülésben"),
            keywords: &["ember lótuszülésben", "jóga", "meditáció"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոտոսի դիրքով նստած մարդ"),
            keywords: &["լոտոսի դիրքով նստած մարդ", "մեդիտացիա", "յոգա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang dalam posisi teratai"),
            keywords: &["meditasi", "orang dalam posisi teratai", "yoga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye chịkọrọ ụkwụ ya abụọ ọnụ"),
            keywords: &["echiche ime mmụọ", "onye chịkọrọ ụkwụ ya abụọ ọnụ", "yoga"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður í lótuspósu"),
            keywords: &["maður í lótuspósu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona in posizione del loto"),
            keywords: &["meditazione", "persona in posizione del loto", "yoga"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヨガのポーズをする人"),
            keywords: &["ヨガ", "ヨガのポーズをする人", "瞑想"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong njagong sila"),
            keywords: &["medhitasi", "wong njagong sila", "yoga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფეხმორთხმული ადამიანი"),
            keywords: &["იოგა", "ლოტუსი", "მედიტაცია", "ფეხმორთხმული ადამიანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("малдас құрып отырған адам"),
            keywords: &["малдас құрып отырған адам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងអង\u{17d2}គ\u{17bb}យជាទម\u{17d2}រង\u{17cb}ផ\u{17d2}កាឈ\u{17bc}ក",
            ),
            keywords: &[
                "មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងអង\u{17d2}គ\u{17bb}យជាទម\u{17d2}រង\u{17cb}ផ\u{17d2}កាឈ\u{17bc}ក",
                "យ\u{17c9}\u{17bc}ហ\u{17d2}គា",
                "សមាធ\u{17b7}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಪದ\u{ccd}ಮಾಸನದಲ\u{ccd}ಲ\u{cbf} ಕುಳ\u{cbf}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ),
            keywords: &[
                "ಧ\u{ccd}ಯಾನ",
                "ಪದ\u{ccd}ಮಾಸನದಲ\u{ccd}ಲ\u{cbf} ಕುಳ\u{cbf}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಯೋಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가부좌한 사람"),
            keywords: &["가부좌", "가부좌한 사람", "요가"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पद\u{94d}मासना\u{902}त बशिल\u{94d}लो व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "पद\u{94d}मासना\u{902}त बशिल\u{94d}लो व\u{94d}यक\u{94d}ती",
                "योग",
                "साधना",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("йога жасап отурган адам"),
            keywords: &["йога", "йога жасап отурган адам", "медитация"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun a Lotuspositioun"),
            keywords: &["Meditatioun", "Persoun a Lotuspositioun", "Yoga"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນນ\u{eb1}\u{ec8}ງທ\u{ec8}າຂ\u{eb1}ດສະມາທ\u{eb4}"),
            keywords: &[
                "ການນ\u{eb1}\u{ec8}ງສະມາທ\u{eb4}",
                "ຄ\u{ebb}ນນ\u{eb1}\u{ec8}ງທ\u{ec8}າຂ\u{eb1}ດສະມາທ\u{eb4}",
                "ໂຍຄະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žmogus lotoso pozoje"),
            keywords: &["joga", "meditacija", "žmogus lotoso pozoje"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks lotosa pozā"),
            keywords: &["cilvēks lotosa pozā", "joga", "meditācija"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata tūranga rotu"),
            keywords: &["tangata tūranga rotu", "whakaaro", "yoga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице во положба лотус"),
            keywords: &["лице во положба лотус", "медитација", "јога"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പത\u{d4d}മ\u{d3e}സനത\u{d4d}തില\u{d41}ള\u{d4d}ള വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ധ\u{d4d}യ\u{d3e}നം",
                "പത\u{d4d}മ\u{d3e}സനത\u{d4d}തില\u{d41}ള\u{d4d}ള വ\u{d4d}യക\u{d4d}തി",
                "യോഗ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лотус байрлалтай хүн"),
            keywords: &["бясалгал", "лотус байрлалтай хүн", "ёог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कमळाच\u{94d}या आकारात व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "कमळाच\u{94d}या आकारात व\u{94d}यक\u{94d}ती",
                "ध\u{94d}यान",
                "योग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang dalam kedudukan teratai"),
            keywords: &["orang dalam kedudukan teratai", "tafakur", "yoga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna fil-pożizzjoni ta’ lotus"),
            keywords: &["joga", "meditazzjoni", "persuna fil-pożizzjoni ta’ lotus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("တင\u{103a}ပျဥ\u{103a}ခ\u{103d}ေထ\u{102d}\u{102f}င\u{103a}သ\u{1030}"),
            keywords: &[
                "တင\u{103a}ပျဥ\u{103a}ခ\u{103d}ေထ\u{102d}\u{102f}င\u{103a}သ\u{1030}",
                "တရားထ\u{102d}\u{102f}င\u{103a}ခြင\u{103a}း",
                "ယောဂ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lotusstilling"),
            keywords: &["lotusstilling", "meditasjon", "yoga"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पद\u{94d}मासानमा व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "ध\u{94d}यान",
                "पद\u{94d}मासानमा व\u{94d}यक\u{94d}ति",
                "योगा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon in lotushouding"),
            keywords: &["meditatie", "persoon in lotushouding", "yoga"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lotusstilling"),
            keywords: &["lotusstilling", "meditasjon", "yoga"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ପଦ\u{b4d}ମ\u{b3e}ସନ ସ\u{b4d}ଥ\u{b3f}ତ\u{b3f}ରେ ଅଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଧ\u{b4d}ୟ\u{b3e}ନ",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ପଦ\u{b4d}ମ\u{b3e}ସନ ସ\u{b4d}ଥ\u{b3f}ତ\u{b3f}ରେ ଅଛନ\u{b4d}ତ\u{b3f}",
                "ଯୋଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਮਲ ਦੀ ਸਥਿਤੀ ਵਿ\u{a71}ਚ ਵਿਅਕਤੀ"),
            keywords: &["ਕਮਲ ਦੀ ਸਥਿਤੀ ਵਿ\u{a71}ਚ ਵਿਅਕਤੀ", "ਯ\u{a4b}ਗਾ", "ਸਿਮਰਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کنول دی حالت وچ بندا"),
            keywords: &["غور کرنا", "کنول دی حالت وچ بندا", "یوگا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Sidọ\u{301}n Fọ Graun Fọ Lótús Wè"),
            keywords: &[
                "Mẹditéshọn",
                "Pẹ\u{301}sin Wé Sidọ\u{301}n Fọ Graun Fọ Lótús Wè",
                "To Tínk Díp Dip",
                "Yóga",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba w pozycji lotosu"),
            keywords: &["joga", "medytacja", "osoba w pozycji lotosu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص د پرلت په حالت کې"),
            keywords: &["شخص د پرلت په حالت کې", "مراقبه", "يوګا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa na posição de lótus"),
            keywords: &["ioga", "meditação", "pessoa na posição de lótus", "yoga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ioga", "meditação", "pessoa na posição de lótus", "yoga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa yoga yupipi"),
            keywords: &["jamut’ay", "runa yoga yupipi", "yoga"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană în poziția lotus"),
            keywords: &["mediație", "persoană în poziția lotus", "yoga"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1129"),
            keywords: &["E10-1129"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек в позе лотоса"),
            keywords: &["йога", "медитация", "расслабление", "человек в позе лотоса"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu wicaye ageretse akaguru ku kandi"),
            keywords: &[
                "meditasiyo",
                "umuntu wicaye ageretse akaguru ku kandi",
                "yoga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص لوٽس پوزيشن ۾"),
            keywords: &["شخص لوٽس پوزيشن ۾", "ميڊيٽيشن", "يوگا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "පද\u{dca}ම\u{dcf}ක\u{dcf}ර ඉර\u{dd2}යව\u{dca}වෙන\u{dca} ස\u{dd2}ට\u{dd2}න ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
            ),
            keywords: &[
                "පද\u{dca}ම\u{dcf}ක\u{dcf}ර ඉර\u{dd2}යව\u{dca}වෙන\u{dca} ස\u{dd2}ට\u{dd2}න ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "භ\u{dcf}වන\u{dcf}ව",
                "යෝග",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek v\u{a0}lotosovom sede"),
            keywords: &[
                "joga",
                "meditácia",
                "človek",
                "človek v\u{a0}lotosovom sede",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba v lotusovem položaju"),
            keywords: &["joga", "meditacija", "oseba v lotusovem položaju"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof ku jira habka fadhiga luga is gudubka"),
            keywords: &[
                "milicsi",
                "qof ku jira habka fadhiga luga is gudubka",
                "qofka ku jira habka fadhiga luga is gudubka",
                "xakamaynta neefta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person në pozicion ëndërrues"),
            keywords: &["jogë", "meditim", "person në pozicion ëndërrues"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лотос поза"),
            keywords: &["лотос поза", "лотус поза", "медитација", "јога"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lotos poza"),
            keywords: &["joga", "lotos poza", "lotus poza", "meditacija"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person i lotusposition"),
            keywords: &["meditering", "person i lotusposition", "yoga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu anayetaamali"),
            keywords: &["mtu anayetaamali", "tafakuri", "yoga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பத\u{bcd}ம\u{bbe}சனம\u{bcd}"),
            keywords: &[
                "ஆசனம\u{bcd}",
                "திய\u{bbe}னம\u{bcd}",
                "பத\u{bcd}ம\u{bbe}சனம\u{bcd}",
                "யோக\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పద\u{c4d}మం భంగ\u{c3f}మల\u{c4b} వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "ధ\u{c4d}య\u{c3e}నం",
                "పద\u{c4d}మం భంగ\u{c3f}మల\u{c4b} వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "య\u{c4b}\u{c3e}గ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахси дар ҳолати лотус"),
            keywords: &["йога", "медитатсия", "шахси дар ҳолати лотус"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนน\u{e31}\u{e48}งสมาธ\u{e34}"),
            keywords: &[
                "คนน\u{e31}\u{e48}งสมาธ\u{e34}",
                "น\u{e31}\u{e48}งข\u{e31}ดสมาธ\u{e34}",
                "โยคะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lotus oturyşyndaky adam"),
            keywords: &["lotus oturyşyndaky adam", "meditasiýa", "ýoga"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha tangutu fehauaki"),
            keywords: &["tokotaha tangutu fehauaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("lotus pozisyonundaki kişi"),
            keywords: &["lotus pozisyonundaki kişi", "meditasyon", "yoga"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گىياھ ھەرىكەتلىك كىشى"),
            keywords: &["تىنچلىنىش", "يوگا", "گىياھ ھەرىكەتلىك كىشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина в позі лотоса"),
            keywords: &["йога", "людина в позі лотоса", "медитація", "поза лотоса"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پالتی مار کر بیٹھا شخص"),
            keywords: &["مراقبہ", "پالتی مار کر بیٹھا شخص", "یوگا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lotus holatidagi odam"),
            keywords: &["lotus holatidagi odam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người ngồi kiết già"),
            keywords: &["người ngồi kiết già", "thiền", "yoga"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ku farankulaayu"),
            keywords: &["nit ku farankulaayu", "xalaat", "yoga"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu okwimo ye-lotus"),
            keywords: &["i-yoga", "ukucamngca", "umntu okwimo ye-lotus"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ènìyàn nípò ìgbàgbé"),
            keywords: &["Yógà", "Ènìyàn nípò ìgbàgbé", "ṣàṣàrò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("坐蓮嘅人"),
            keywords: &["冥想", "坐蓮嘅人", "瑜伽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("坐莲嘅人"),
            keywords: &["冥想", "坐莲嘅人", "瑜伽"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盘腿的人"),
            keywords: &["冥想", "瑜伽", "盘腿的人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盤坐"),
            keywords: &["盤坐"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("盤腿坐嘅人"),
            keywords: &["冥想", "打坐", "瑜珈", "盤腿坐", "盤腿坐嘅人", "蓮花坐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu esikhundleni se-lotus"),
            keywords: &["iyoga", "ukucabanga", "umuntu esikhundleni se-lotus"],
        },
    ],
};
#[doc = "🧘🏻"]
pub const PERSON_IN_LOTUS_POSITION_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏻",
    codepoint: "1F9D8 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person in lotus position: light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧘🏼"]
pub const PERSON_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏼",
    codepoint: "1F9D8 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person in lotus position: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧘🏽"]
pub const PERSON_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏽",
    codepoint: "1F9D8 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person in lotus position: medium skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧘🏾"]
pub const PERSON_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏾",
    codepoint: "1F9D8 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person in lotus position: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧘🏿"]
pub const PERSON_IN_LOTUS_POSITION_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏿",
    codepoint: "1F9D8 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person in lotus position: dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧘\u{200d}♂\u{fe0f}"]
pub const MAN_IN_LOTUS_POSITION: crate::Emoji = crate::Emoji {
    glyph: "🧘\u{200d}♂\u{fe0f}",
    codepoint: "1F9D8 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man in lotus position",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘\u{200d}♂",
        codepoint: "1F9D8 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man in lotus position",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man in lotusposisie"),
            keywords: &["joga", "man in lotusposisie", "meditasie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሎታስ ኣቀማመጥ ወንድ"),
            keywords: &["በሎታስ ኣቀማመጥ ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل مترب\u{651}ع"),
            keywords: &["رجل مترب\u{651}ع"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পদ\u{9cd}ম\u{9be}সন কৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "ধ\u{9cd}য\u{9be}ন",
                "পদ\u{9cd}ম\u{9be}সন কৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
                "যোগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lotus pozisiyasında kişi"),
            keywords: &["lotus pozisiyasında kişi", "meditasiya", "yoqa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына ў позе лотаса"),
            keywords: &["медытацыя", "мужчына ў позе лотаса", "ёга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж в поза „лотос“"),
            keywords: &["йога", "медитация", "мъж в поза „лотос“"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পদ\u{9cd}ম\u{9be}সনে বস\u{9be} প\u{9c1}র\u{9c1}ষ"),
            keywords: &[
                "ধ\u{9cd}য\u{9be}ন",
                "পদ\u{9cd}ম\u{9be}সনে বস\u{9be} প\u{9c1}র\u{9c1}ষ",
                "যোগ\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac u položaju lotosa"),
            keywords: &["joga", "meditacija", "muškarac u položaju lotosa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home en la posició de lotus"),
            keywords: &["home en la posició de lotus", "ioga", "lotus", "meditació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏚᏓᏝᏗᏍᏗ"),
            keywords: &["ᎠᏍᎦᏯ ᏚᏓᏝᏗᏍᏗ", "ᎤᏯᏪᏐᎸᏢᎢ ᎠᏓᏅᏖᏢᏍᎬᎢ", "ᏲᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž v lotosovém sedu"),
            keywords: &[
                "jóga",
                "lotos",
                "lotosová",
                "meditace",
                "muž v lotosovém sedu",
                "pozice",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn mewn ystum lingroes"),
            keywords: &["dyn mewn ystum lingroes", "myfyrdod", "yoga"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand i lotusstilling"),
            keywords: &["mand", "mand i lotusstilling", "meditation", "yoga"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann im Lotossitz"),
            keywords: &["Mann im Lotossitz", "Meditation", "Yoga"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας σε θέση λωτού"),
            keywords: &["άντρας σε θέση λωτού", "γιόγκα", "διαλογισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man in lotus position"),
            keywords: &["man in lotus position", "meditation", "yoga"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre en posición de loto"),
            keywords: &["hombre en posición de loto", "meditación", "yoga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lootosasendis mees"),
            keywords: &["jooga", "lootosasendis mees", "meditatsioon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon bat loto-posizioan"),
            keywords: &["gizon bat loto-posizioan", "meditazio", "yoga"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد در حالت خلسه"),
            keywords: &["خلسه", "مرد در حالت خلسه", "مکاشفه", "یوگا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mies lootusasennossa"),
            keywords: &["jooga", "mies lootusasennossa", "mietiskely"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaki na naka-lotus position"),
            keywords: &["lalaki na naka-lotus position", "meditation", "yoga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður í lotusstøðu"),
            keywords: &[
                "joga",
                "lotus",
                "lotusstøða",
                "maður",
                "maður í lotusstøðu",
                "meditatión",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme dans la posture du lotus"),
            keywords: &[
                "homme dans la posture du lotus",
                "méditation",
                "position du lotus",
                "yoga",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear i suíomh na loiteoige"),
            keywords: &["ag machnamh", "fear", "fear i suíomh na loiteoige", "ióga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine na shuidhe lòtais"),
            keywords: &["duine na shuidhe lòtais", "meòrachadh", "yoga"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home practicando ioga"),
            keywords: &[
                "home",
                "home practicando ioga",
                "meditación",
                "posición de loto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ કમળ જ\u{ac7}વી સ\u{acd}થિતિમા\u{a82}"),
            keywords: &[
                "ધ\u{acd}યાન",
                "પ\u{ac1}ર\u{ac1}ષ કમળ જ\u{ac7}વી સ\u{acd}થિતિમા\u{a82}",
                "યોગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji a wurin furen lotus"),
            keywords: &["namiji a wurin furen lotus", "tsokaci", "yoga"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איש בתנוחת לוטוס"),
            keywords: &["איש בתנוחת לוטוס", "יוגה", "לוטוס", "מדיטציה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पद\u{94d}मासन म\u{947}\u{902} ब\u{948}ठा प\u{941}र\u{941}ष"),
            keywords: &[
                "ध\u{94d}यान",
                "पद\u{94d}मासन म\u{947}\u{902} ब\u{948}ठा प\u{941}र\u{941}ष",
                "योग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac u položaju lotosa"),
            keywords: &["meditacija", "muškarac u položaju lotosa", "yoga"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi lótuszülésben"),
            keywords: &["férfi lótuszülésben", "jóga", "meditáció"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոտոսի դիրքով նստած տղամարդ"),
            keywords: &["լոտոսի դիրքով նստած տղամարդ", "մեդիտացիա", "յոգա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria dalam posisi teratai"),
            keywords: &["meditasi", "pria dalam posisi teratai", "yoga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke chịkọrọ ụkwụ ya abụọ ọnụ"),
            keywords: &["echiche ime mmụọ", "nwoke chịkọrọ ụkwụ ya abụọ ọnụ", "yoga"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karl í lótuspósu"),
            keywords: &["karl í lótuspósu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo in posizione del loto"),
            keywords: &["meditazione", "uomo in posizione del loto", "yoga"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヨガのポーズをする男"),
            keywords: &["ヨガ", "ヨガのポーズをする男", "男", "男性", "瞑想"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang njagong sila"),
            keywords: &["medhitasi", "wong lanang njagong sila", "yoga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფეხმორთხმული კაცი"),
            keywords: &["იოგა", "ლოტუსი", "მედიტაცია", "ფეხმორთხმული კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("малдас құрып отырған ер адам"),
            keywords: &["малдас құрып отырған ер адам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ប\u{17bb}រសក\u{17c6}ព\u{17bb}ងអង\u{17d2}គ\u{17bb}យជាទម\u{17d2}រង\u{17cb}ផ\u{17d2}កាឈ\u{17bc}ក",
            ),
            keywords: &[
                "ប\u{17bb}រសក\u{17c6}ព\u{17bb}ងអង\u{17d2}គ\u{17bb}យជាទម\u{17d2}រង\u{17cb}ផ\u{17d2}កាឈ\u{17bc}ក",
                "យ\u{17c9}\u{17bc}ហ\u{17d2}គា",
                "សមាធ\u{17b7}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪದ\u{ccd}ಮಾಸನದಲ\u{ccd}ಲ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಧ\u{ccd}ಯಾನ",
                "ಪದ\u{ccd}ಮಾಸನದಲ\u{ccd}ಲ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಯೋಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가부좌한 남자"),
            keywords: &["가부좌", "가부좌한 남자", "요가"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पद\u{94d}मासना\u{902}त बशिल\u{94d}लो दादलो"),
            keywords: &["पद\u{94d}मासना\u{902}त बशिल\u{94d}लो दादलो", "योग", "साधना"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("йога жасап жаткан эркек"),
            keywords: &["йога", "йога жасап жаткан эркек", "медитация"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann a Lotuspositioun"),
            keywords: &["Mann a Lotuspositioun", "Meditatioun", "Yoga"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍນ\u{eb1}\u{ec8}ງທ\u{ec8}າຂ\u{eb1}ດສະມາທ\u{eb4}"),
            keywords: &[
                "ການນ\u{eb1}\u{ec8}ງສະມາທ\u{eb4}",
                "ຜ\u{eb9}\u{ec9}ຊາຍນ\u{eb1}\u{ec8}ງທ\u{ec8}າຂ\u{eb1}ດສະມາທ\u{eb4}",
                "ໂຍຄະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyras lotoso pozoje"),
            keywords: &["joga", "meditacija", "vyras lotoso pozoje"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis lotosa pozā"),
            keywords: &["joga", "meditācija", "vīrietis lotosa pozā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tūranga rotu"),
            keywords: &["tāne tūranga rotu", "whakaaro", "yoga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж во положба лотус"),
            keywords: &["маж во положба лотус", "медитација", "јога"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പത\u{d4d}മ\u{d3e}സനത\u{d4d}തില\u{d41}ള\u{d4d}ള പ\u{d41}ര\u{d41}ഷൻ"),
            keywords: &[
                "ധ\u{d4d}യ\u{d3e}നം",
                "പത\u{d4d}മ\u{d3e}സനത\u{d4d}തില\u{d41}ള\u{d4d}ള പ\u{d41}ര\u{d41}ഷൻ",
                "യോഗ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лотус байрлалтай эрэгтэй"),
            keywords: &["бясалгал", "лотус байрлалтай эрэгтэй", "ёог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कमळाच\u{94d}या आकारात प\u{941}र\u{942}ष"),
            keywords: &[
                "कमळाच\u{94d}या आकारात प\u{941}र\u{942}ष",
                "ध\u{94d}यान",
                "योग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki duduk teratai"),
            keywords: &["lelaki duduk teratai", "tafakur", "yoga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel fil-pożizzjoni ta’ lotus"),
            keywords: &["joga", "meditazzjoni", "raġel fil-pożizzjoni ta’ lotus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တင\u{103a}ပျဥ\u{103a}ခ\u{103d}ေထ\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "တင\u{103a}ပျဥ\u{103a}ခ\u{103d}ေထ\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
                "တရားထ\u{102d}\u{102f}င\u{103a}ခြင\u{103a}း",
                "ယောဂ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann i lotusstilling"),
            keywords: &["mann i lotusstilling", "meditasjon", "yoga"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पद\u{94d}मासानमा छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "ध\u{94d}यान",
                "पद\u{94d}मासानमा छोरामान\u{94d}छ\u{947}",
                "योगा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man in lotushouding"),
            keywords: &["man in lotushouding", "meditatie", "yoga"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann i lotusstilling"),
            keywords: &["mann i lotusstilling", "meditasjon", "yoga"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b41}ର\u{b41}ଷ ପଦ\u{b4d}ମ\u{b3e}ସନ ସ\u{b4d}ଥ\u{b3f}ତ\u{b3f}ରେ ଅଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଧ\u{b4d}ୟ\u{b3e}ନ",
                "ପ\u{b41}ର\u{b41}ଷ ପଦ\u{b4d}ମ\u{b3e}ସନ ସ\u{b4d}ଥ\u{b3f}ତ\u{b3f}ରେ ଅଛନ\u{b4d}ତ\u{b3f}",
                "ଯୋଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਮਲ ਦੀ ਸਥਿਤੀ ਵਿ\u{a71}ਚ ਆਦਮੀ"),
            keywords: &["ਕਮਲ ਦੀ ਸਥਿਤੀ ਵਿ\u{a71}ਚ ਆਦਮੀ", "ਧਿਆਨ", "ਯ\u{a4b}ਗਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کنول دی حآلت وچ مرد"),
            keywords: &["غور کرنا", "کنول دی حآلت وچ مرد", "یوگا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé Sidọ\u{301}n Fọ Graun Fọ Lótús Wè"),
            keywords: &[
                "Man Wé Sidọ\u{301}n Fọ Graun Fọ Lótús Wè",
                "Mẹditéshọn",
                "To Tínk Díp Dip",
                "Yóga",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna w pozycji lotosu"),
            keywords: &["joga", "medytacja", "mężczyzna w pozycji lotosu"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی د پرلت په حالت کې"),
            keywords: &["سړی د پرلت په حالت کې", "مراقبه", "يوګا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem na posição de lótus"),
            keywords: &["homem na posição de lótus", "ioga", "meditação", "yoga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["homem na posição de lótus", "ioga", "meditação", "yoga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata yoga yupipi"),
            keywords: &["jamut’ay", "tata yoga yupipi", "yoga"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat în poziția lotus"),
            keywords: &["bărbat în poziția lotus", "mediație", "yoga"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1249"),
            keywords: &["E10-1249"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина в позе лотоса"),
            keywords: &[
                "йога",
                "медитация",
                "мужчина",
                "мужчина в позе лотоса",
                "расслабление",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo wicaye ageretse akaguru ku kandi"),
            keywords: &[
                "meditasiyo",
                "umugabo wicaye ageretse akaguru ku kandi",
                "yoga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد لوٽس پوزيشن ۾"),
            keywords: &["مرد لوٽس پوزيشن ۾", "ميڊيٽيشن", "يوگا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "පද\u{dca}ම\u{dcf}ක\u{dcf}ර ඉර\u{dd2}යව\u{dca}වෙන\u{dca} ස\u{dd2}ට\u{dd2}න ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
            ),
            keywords: &[
                "පද\u{dca}ම\u{dcf}ක\u{dcf}ර ඉර\u{dd2}යව\u{dca}වෙන\u{dca} ස\u{dd2}ට\u{dd2}න ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "භ\u{dcf}වන\u{dcf}ව",
                "යෝග",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž v\u{a0}lotosovom sede"),
            keywords: &["joga", "meditácia", "muž", "muž v\u{a0}lotosovom sede"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški v lotusovem položaju"),
            keywords: &["joga", "meditacija", "moški v lotusovem položaju"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin ku jira habka fadhiga luga is gudubka"),
            keywords: &[
                "milicsi",
                "nin ku jira fadhiga luga is gudubka",
                "nin ku jira habka fadhiga luga is gudubka",
                "xakamaynta neefta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë në pozicion ëndërrues"),
            keywords: &["burrë në pozicion ëndërrues", "jogë", "meditim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац у лотос пози"),
            keywords: &[
                "медитација",
                "мушкарац у лотос пози",
                "мушкарац у лотус пози",
                "јога",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac u lotos pozi"),
            keywords: &[
                "joga",
                "meditacija",
                "muškarac u lotos pozi",
                "muškarac u lotus pozi",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man i lotusposition"),
            keywords: &["man i lotusposition", "meditering", "yoga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume anayetaamali"),
            keywords: &["mwanamume anayetaamali", "taamuli", "yoga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பத\u{bcd}ம\u{bbe}சனம\u{bcd} செய\u{bcd}யும\u{bcd} ஆண\u{bcd}"),
            keywords: &[
                "ஆசனம\u{bcd}",
                "திய\u{bbe}னம\u{bcd}",
                "பத\u{bcd}ம\u{bbe}சனம\u{bcd}",
                "பத\u{bcd}ம\u{bbe}சனம\u{bcd} செய\u{bcd}யும\u{bcd} ஆண\u{bcd}",
                "யோக\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పద\u{c4d}మం భంగ\u{c3f}మల\u{c4b} పురుషుడు"),
            keywords: &[
                "ధ\u{c4d}య\u{c3e}నం",
                "పద\u{c4d}మం భంగ\u{c3f}మల\u{c4b} పురుషుడు",
                "య\u{c4b}గ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди дар ҳолати лотус"),
            keywords: &["йога", "марди дар ҳолати лотус", "медитатсия"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายน\u{e31}\u{e48}งสมาธ\u{e34}"),
            keywords: &[
                "น\u{e31}\u{e48}งข\u{e31}ดสมาธ\u{e34}",
                "ผ\u{e39}\u{e49}ชายน\u{e31}\u{e48}งสมาธ\u{e34}",
                "โยคะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lotus oturyşyndaky erkek"),
            keywords: &["lotus oturyşyndaky erkek", "meditasiýa", "ýoga"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata tangutu fehauaki"),
            keywords: &["tangata tangutu fehauaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("lotus pozisyonundaki erkek"),
            keywords: &["lotus pozisyonundaki erkek", "meditasyon", "yoga"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گىياھ ھەرىكەتلىك ئەر"),
            keywords: &["تىنچلىنىش", "يوگا", "گىياھ ھەرىكەتلىك ئەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік у позі лотоса"),
            keywords: &["йога", "медитація", "поза лотоса", "чоловік у позі лотоса"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پالتی مار کر بیٹھا آدمی"),
            keywords: &["مراقبہ", "پالتی مار کر بیٹھا آدمی", "یوگا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lotus holatidagi erkak"),
            keywords: &["lotus holatidagi erkak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông ngồi kiết già"),
            keywords: &["người đàn ông ngồi kiết già", "thiền", "yoga"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor gu farankulaayu"),
            keywords: &["góor gu farankulaayu", "xalaat", "yoga"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda ekwimo ye-lotus"),
            keywords: &["i-yoga", "indoda ekwimo ye-lotus", "ukucamngca"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkùnrin nípò ìgbàgbé"),
            keywords: &["Yógà", "ṣàṣàrò", "Ọkùnrin nípò ìgbàgbé"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("坐蓮嘅男人"),
            keywords: &["冥想", "坐蓮嘅男人", "瑜伽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("坐莲嘅男人"),
            keywords: &["冥想", "坐莲嘅男人", "瑜伽"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盘腿的男人"),
            keywords: &["和尚", "瑜伽男", "盘腿的男人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盤坐男子"),
            keywords: &["盤坐男子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("盤腿坐嘅男人"),
            keywords: &["冥想", "打坐", "瑜珈", "盤腿坐", "盤腿坐嘅男人", "蓮花坐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesilisa esikhundleni se-lotus"),
            keywords: &["iyoga", "owesilisa esikhundleni se-lotus", "ukucabanga"],
        },
    ],
};
#[doc = "🧘🏻\u{200d}♂\u{fe0f}"]
pub const MAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9D8 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man in lotus position: light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏻\u{200d}♂",
        codepoint: "1F9D8 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man in lotus position: light skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏼\u{200d}♂\u{fe0f}"]
pub const MAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9D8 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man in lotus position: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏼\u{200d}♂",
        codepoint: "1F9D8 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man in lotus position: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏽\u{200d}♂\u{fe0f}"]
pub const MAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9D8 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man in lotus position: medium skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏽\u{200d}♂",
        codepoint: "1F9D8 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man in lotus position: medium skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏾\u{200d}♂\u{fe0f}"]
pub const MAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9D8 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man in lotus position: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏾\u{200d}♂",
        codepoint: "1F9D8 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man in lotus position: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏿\u{200d}♂\u{fe0f}"]
pub const MAN_IN_LOTUS_POSITION_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9D8 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man in lotus position: dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏿\u{200d}♂",
        codepoint: "1F9D8 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man in lotus position: dark skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘\u{200d}♀\u{fe0f}"]
pub const WOMAN_IN_LOTUS_POSITION: crate::Emoji = crate::Emoji {
    glyph: "🧘\u{200d}♀\u{fe0f}",
    codepoint: "1F9D8 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman in lotus position",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘\u{200d}♀",
        codepoint: "1F9D8 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman in lotus position",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou in lotusposisie"),
            keywords: &["joga", "meditasie", "vrou in lotusposisie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("በሎታስ ኣቀማመጥ ሴት"),
            keywords: &["በሎታስ ኣቀማመጥ ሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("امرأة مترب\u{651}عة"),
            keywords: &["امرأة مترب\u{651}عة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পদ\u{9cd}ম\u{9be}সন কৰ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "ধ\u{9cd}য\u{9be}ন",
                "পদ\u{9cd}ম\u{9be}সন কৰ\u{9be} মহিল\u{9be}",
                "যোগ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lotus pozisiyasında qadın"),
            keywords: &["lotus pozisiyasında qadın", "meditasiya", "yoqa"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына ў позе лотаса"),
            keywords: &["жанчына ў позе лотаса", "медытацыя", "ёга"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена в поза „лотос“"),
            keywords: &["жена в поза „лотос“", "йога", "медитация"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পদ\u{9cd}ম\u{9be}সনে বস\u{9be} মহিল\u{9be}"),
            keywords: &[
                "ধ\u{9cd}য\u{9be}ন",
                "পদ\u{9cd}ম\u{9be}সনে বস\u{9be} মহিল\u{9be}",
                "যোগ\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena u položaju lotosa"),
            keywords: &["joga", "meditacija", "žena u položaju lotosa"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona en la posició de lotus"),
            keywords: &["dona en la posició de lotus", "ioga", "lotus", "meditació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏚᏓᏝᏗᏍᏗ"),
            keywords: &["ᎠᎨᏯ ᏚᏓᏝᏗᏍᏗ", "ᎤᏯᏪᏐᎸᏢᎢ ᎠᏓᏅᏖᏢᏍᎬᎢ", "ᏲᎦ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena v lotosovém sedu"),
            keywords: &[
                "jóga",
                "lotos",
                "lotosová",
                "meditace",
                "pozice",
                "žena v lotosovém sedu",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw mewn ystum lingroes"),
            keywords: &["menyw mewn ystum lingroes", "myfyrdod", "yoga"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde i lotusstilling"),
            keywords: &["kvinde", "kvinde i lotusstilling", "meditation", "yoga"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau im Lotossitz"),
            keywords: &["Frau im Lotossitz", "Meditation", "Yoga"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα σε θέση λωτού"),
            keywords: &["γιόγκα", "γυναίκα σε θέση λωτού", "διαλογισμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman in lotus position"),
            keywords: &["meditation", "woman in lotus position", "yoga"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer en posición de loto"),
            keywords: &["meditación", "mujer en posición de loto", "yoga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lootosasendis naine"),
            keywords: &["jooga", "lootosasendis naine", "meditatsioon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume bat loto-posizioan"),
            keywords: &["emakume bat loto-posizioan", "meditazio", "yoga"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن در حالت خلسه"),
            keywords: &["خلسه", "زن در حالت خلسه", "مکاشفه", "یوگا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nainen lootusasennossa"),
            keywords: &["jooga", "mietiskely", "nainen lootusasennossa"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babae na naka-lotus position"),
            keywords: &["babae na naka-lotus position", "meditation", "yoga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna í lotusstøðu"),
            keywords: &[
                "joga",
                "kona",
                "kvinna",
                "kvinna í lotusstøðu",
                "lotus",
                "lotusstøða",
                "meditatión",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme dans la posture du lotus"),
            keywords: &[
                "femme dans la posture du lotus",
                "méditation",
                "position du lotus",
                "yoga",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean i suíomh na loiteoige"),
            keywords: &["ag machnamh", "bean", "bean i suíomh na loiteoige", "ióga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach na shuidhe lòtais"),
            keywords: &["boireannach na shuidhe lòtais", "meòrachadh", "yoga"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller practicando ioga"),
            keywords: &[
                "meditación",
                "muller",
                "muller practicando ioga",
                "posición de loto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી કમળ જ\u{ac7}વી સ\u{acd}થિતિમા\u{a82}"),
            keywords: &[
                "ધ\u{acd}યાન",
                "યોગ",
                "સ\u{acd}ત\u{acd}રી કમળ જ\u{ac7}વી સ\u{acd}થિતિમા\u{a82}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace a wurin furen lotus"),
            keywords: &["mace a wurin furen lotus", "tsokaci", "yoga"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה בתנוחת לוטוס"),
            keywords: &["אישה בתנוחת לוטוס", "יוגה", "לוטוס", "מדיטציה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पद\u{94d}मासन म\u{947}\u{902} ब\u{948}ठी महिला"),
            keywords: &[
                "ध\u{94d}यान",
                "पद\u{94d}मासन म\u{947}\u{902} ब\u{948}ठी महिला",
                "योग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena u položaju lotosa"),
            keywords: &["meditacija", "yoga", "žena u položaju lotosa"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nő lótuszülésben"),
            keywords: &["jóga", "meditáció", "nő lótuszülésben"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոտոսի դիրքով նստած կին"),
            keywords: &["լոտոսի դիրքով նստած կին", "մեդիտացիա", "յոգա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita dalam posisi teratai"),
            keywords: &["meditasi", "wanita dalam posisi teratai", "yoga"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị chịkọrọ ụkwụ ya abụọ ọnụ"),
            keywords: &[
                "echiche ime mmụọ",
                "nwanyị chịkọrọ ụkwụ ya abụọ ọnụ",
                "yoga",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona í lótusp´ósu"),
            keywords: &["kona í lótusp´ósu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna in posizione del loto"),
            keywords: &["donna in posizione del loto", "meditazione", "yoga"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ヨガのポーズをする女"),
            keywords: &["ヨガ", "ヨガのポーズをする女", "女", "女性", "瞑想"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon njagong sila"),
            keywords: &["medhitasi", "wong wadon njagong sila", "yoga"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფეხმორთხმული ქალი"),
            keywords: &["იოგა", "ლოტუსი", "მედიტაცია", "ფეხმორთხმული ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("малдас құрып отырған әйел"),
            keywords: &["малдас құрып отырған әйел"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}ក\u{17c6}ព\u{17bb}ងអង\u{17d2}គ\u{17bb}យជាទម\u{17d2}រង\u{17cb}ផ\u{17d2}កាឈ\u{17bc}ក",
            ),
            keywords: &[
                "យ\u{17c9}\u{17bc}ហ\u{17d2}គា",
                "សមាធ\u{17b7}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}ក\u{17c6}ព\u{17bb}ងអង\u{17d2}គ\u{17bb}យជាទម\u{17d2}រង\u{17cb}ផ\u{17d2}កាឈ\u{17bc}ក",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪದ\u{ccd}ಮಾಸನದಲ\u{ccd}ಲ\u{cbf} ಕುಳ\u{cbf}ತ\u{cbf}ರುವ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಧ\u{ccd}ಯಾನ",
                "ಪದ\u{ccd}ಮಾಸನದಲ\u{ccd}ಲ\u{cbf} ಕುಳ\u{cbf}ತ\u{cbf}ರುವ ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಯೋಗ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("가부좌한 여자"),
            keywords: &["가부좌", "가부좌한 여자", "요가"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पद\u{94d}मासना\u{902}त बशिल\u{94d}ली बायल"),
            keywords: &["पद\u{94d}मासना\u{902}त बशिल\u{94d}ली बायल", "योग", "साधना"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("йога жасап жаткан аял"),
            keywords: &["йога", "йога жасап жаткан аял", "медитация"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra a Lotuspositioun"),
            keywords: &["Fra a Lotuspositioun", "Meditatioun", "Yoga"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງນ\u{eb1}\u{ec8}ງທ\u{ec8}າຂ\u{eb1}ດສະມາທ\u{eb4}"),
            keywords: &[
                "ການນ\u{eb1}\u{ec8}ງສະມາທ\u{eb4}",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງນ\u{eb1}\u{ec8}ງທ\u{ec8}າຂ\u{eb1}ດສະມາທ\u{eb4}",
                "ໂຍຄະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteris lotoso pozoje"),
            keywords: &["joga", "meditacija", "moteris lotoso pozoje"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete lotosa pozā"),
            keywords: &["joga", "meditācija", "sieviete lotosa pozā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tūranga rotu"),
            keywords: &["wahine tūranga rotu", "whakaaro", "yoga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена во положба лотус"),
            keywords: &["жена во положба лотус", "медитација", "јога"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പത\u{d4d}മ\u{d3e}സനത\u{d4d}തില\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}ത\u{d4d}രീ"),
            keywords: &[
                "ധ\u{d4d}യ\u{d3e}നം",
                "പത\u{d4d}മ\u{d3e}സനത\u{d4d}തില\u{d41}ള\u{d4d}ള സ\u{d4d}\u{200c}ത\u{d4d}രീ",
                "യോഗ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лотус байрлалтай эмэгтэй"),
            keywords: &["бясалгал", "лотус байрлалтай эмэгтэй", "ёог"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कमळाच\u{94d}या आकारात स\u{94d}त\u{94d}री"),
            keywords: &[
                "कमळाच\u{94d}या आकारात स\u{94d}त\u{94d}री",
                "ध\u{94d}यान",
                "योग",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wanita duduk teratai"),
            keywords: &["tafakur", "wanita duduk teratai", "yoga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara fil-pożizzjoni ta’ lotus"),
            keywords: &["joga", "mara fil-pożizzjoni ta’ lotus", "meditazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တင\u{103a}ပျဥ\u{103a}ခ\u{103d}ေထ\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "တင\u{103a}ပျဥ\u{103a}ခ\u{103d}ေထ\u{102d}\u{102f}င\u{103a}သည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "တရားထ\u{102d}\u{102f}င\u{103a}ခြင\u{103a}း",
                "ယောဂ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne i lotusstilling"),
            keywords: &["kvinne i lotusstilling", "meditasjon", "yoga"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पद\u{94d}मासानमा छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "ध\u{94d}यान",
                "पद\u{94d}मासानमा छोरीमान\u{94d}छ\u{947}",
                "योगा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw in lotushouding"),
            keywords: &["meditatie", "vrouw in lotushouding", "yoga"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne i lotusstilling"),
            keywords: &["kvinne i lotusstilling", "meditasjon", "yoga"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ମହ\u{b3f}ଳ\u{b3e} ପଦ\u{b4d}ମ\u{b3e}ସନ ସ\u{b4d}ଥ\u{b3f}ତ\u{b3f}ରେ ଅଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଧ\u{b4d}ୟ\u{b3e}ନ",
                "ମହ\u{b3f}ଳ\u{b3e} ପଦ\u{b4d}ମ\u{b3e}ସନ ସ\u{b4d}ଥ\u{b3f}ତ\u{b3f}ରେ ଅଛନ\u{b4d}ତ\u{b3f}",
                "ଯୋଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਮਲ ਦੀ ਸਥਿਤੀ ਵਿ\u{a71}ਚ ਔਰਤ"),
            keywords: &["ਕਮਲ ਦੀ ਸਥਿਤੀ ਵਿ\u{a71}ਚ ਔਰਤ", "ਧਿਆਨ", "ਯ\u{a4b}ਗਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کنول دی حالت وچ زنانی"),
            keywords: &["غور کرنا", "کنول دی حالت وچ زنانی", "یوگا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Sidọ\u{301}n Fọ Graun Fọ Lótús Wè"),
            keywords: &[
                "Mẹditéshọn",
                "To Tínk Díp Dip",
                "Wúman Sidọ\u{301}n Fọ Graun Fọ Lótús Wè",
                "Wúman Wé Sidọ\u{301}n Fọ Graun Fọ Lótús Wè",
                "Yóga",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta w pozycji lotosu"),
            keywords: &["joga", "kobieta w pozycji lotosu", "medytacja"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه د پرلت په حالت کې"),
            keywords: &["مراقبه", "يوګا", "ښځه د پرلت په حالت کې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher na posição de lótus"),
            keywords: &["ioga", "meditação", "mulher na posição de lótus", "yoga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["ioga", "meditação", "mulher na posição de lótus", "yoga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi yoga yupipi"),
            keywords: &["jamut’ay", "warmi yoga yupipi", "yoga"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie în poziția lotus"),
            keywords: &["femeie în poziția lotus", "mediație", "yoga"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1248"),
            keywords: &["E10-1248"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина в позе лотоса"),
            keywords: &[
                "женщина",
                "женщина в позе лотоса",
                "йога",
                "медитация",
                "расслабление",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore wicaye ageretse akaguru ku kandi"),
            keywords: &[
                "meditasiyo",
                "umugore wicaye ageretse akaguru ku kandi",
                "yoga",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت لوٽس پوزيشن ۾"),
            keywords: &["عورت لوٽس پوزيشن ۾", "ميڊيٽيشن", "يوگا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "පද\u{dca}ම\u{dcf}ක\u{dcf}ර ඉර\u{dd2}යව\u{dca}වෙන\u{dca} ස\u{dd2}ට\u{dd2}න ගැහැණ\u{dd2}ය",
            ),
            keywords: &[
                "පද\u{dca}ම\u{dcf}ක\u{dcf}ර ඉර\u{dd2}යව\u{dca}වෙන\u{dca} ස\u{dd2}ට\u{dd2}න ගැහැණ\u{dd2}ය",
                "භ\u{dcf}වන\u{dcf}ව",
                "යෝග",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žena v\u{a0}lotosovom sede"),
            keywords: &["joga", "meditácia", "žena", "žena v\u{a0}lotosovom sede"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska v lotusovem položaju"),
            keywords: &["joga", "meditacija", "ženska v lotusovem položaju"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag u fadhida habka luga is-gudubka"),
            keywords: &[
                "haweeney ku jirta fadhiga luga is-gudubka",
                "milicsi",
                "naag u fadhida habka luga is-gudubka",
                "xakamaynta neefta",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua në pozicion ëndërrues"),
            keywords: &["grua në pozicion ëndërrues", "jogë", "meditim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена у лотос пози"),
            keywords: &[
                "жена у лотос пози",
                "жена у лотус пози",
                "медитација",
                "јога",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena u lotos pozi"),
            keywords: &[
                "joga",
                "meditacija",
                "žena u lotos pozi",
                "žena u lotus pozi",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinna i lotusposition"),
            keywords: &["kvinna i lotusposition", "meditering", "yoga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke anayetaamali"),
            keywords: &["mwanamke anayetaamali", "taamuli", "yoga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பத\u{bcd}ம\u{bbe}சனம\u{bcd} செய\u{bcd}யும\u{bcd} பெண\u{bcd}"),
            keywords: &[
                "ஆசனம\u{bcd}",
                "திய\u{bbe}னம\u{bcd}",
                "பத\u{bcd}ம\u{bbe}சனம\u{bcd}",
                "பத\u{bcd}ம\u{bbe}சனம\u{bcd} செய\u{bcd}யும\u{bcd} பெண\u{bcd}",
                "யோக\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పద\u{c4d}మం భంగ\u{c3f}మల\u{c4b} మహ\u{c3f}ళ"),
            keywords: &[
                "ధ\u{c4d}య\u{c3e}నం",
                "పద\u{c4d}మం భంగ\u{c3f}మల\u{c4b} మహ\u{c3f}ళ",
                "య\u{c4b}గ\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани дар ҳолати лотус"),
            keywords: &["зани дар ҳолати лотус", "йога", "медитатсия"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งน\u{e31}\u{e48}งสมาธ\u{e34}"),
            keywords: &[
                "น\u{e31}\u{e48}งข\u{e31}ดสมาธ\u{e34}",
                "ผ\u{e39}\u{e49}หญ\u{e34}งน\u{e31}\u{e48}งสมาธ\u{e34}",
                "โยคะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("lotus oturyşyndaky zenan"),
            keywords: &["lotus oturyşyndaky zenan", "meditasiýa", "ýoga"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine tangutu fehauaki"),
            keywords: &["fefine tangutu fehauaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("lotus pozisyonundaki kadın"),
            keywords: &["lotus pozisyonundaki kadın", "meditasyon", "yoga"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("گىياھ ھەرىكەتلىك ئايال"),
            keywords: &["تىنچلىنىش", "يوگا", "گىياھ ھەرىكەتلىك ئايال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка в позі лотоса"),
            keywords: &["жінка в позі лотоса", "йога", "медитація"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پالتی مار کر بیٹھی عورت"),
            keywords: &["مراقبہ", "پالتی مار کر بیٹھی عورت", "یوگا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("lotus holatidagi ayol"),
            keywords: &["lotus holatidagi ayol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ ngồi kiết già"),
            keywords: &["người phụ nữ ngồi kiết già", "thiền", "yoga"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen ju farankulaayu"),
            keywords: &["jigéen ju farankulaayu", "xalaat", "yoga"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elikwimo ye-lotus"),
            keywords: &["i-yoga", "ibhinqa elikwimo ye-lotus", "ukucamngca"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Obìnrin nípò ìgbàgbé"),
            keywords: &["Obìnrin nípò ìgbàgbé", "Yógà", "ṣàṣàrò"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("坐蓮嘅女人"),
            keywords: &["冥想", "坐蓮嘅女人", "瑜伽"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("坐莲嘅女人"),
            keywords: &["冥想", "坐莲嘅女人", "瑜伽"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("盘腿的女人"),
            keywords: &["尼姑", "比丘尼", "瑜伽女", "盘腿的女人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盤坐女子"),
            keywords: &["盤坐女子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("盤腿坐嘅女人"),
            keywords: &["冥想", "打坐", "瑜珈", "盤腿坐", "盤腿坐嘅女人", "蓮花坐"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesifazane esikhundleni se-lotus"),
            keywords: &["iyoga", "owesifazane esikhundleni se-lotus", "ukucabanga"],
        },
    ],
};
#[doc = "🧘🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_IN_LOTUS_POSITION_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9D8 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman in lotus position: light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏻\u{200d}♀",
        codepoint: "1F9D8 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman in lotus position: light skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_IN_LOTUS_POSITION_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9D8 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman in lotus position: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏼\u{200d}♀",
        codepoint: "1F9D8 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman in lotus position: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_IN_LOTUS_POSITION_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9D8 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman in lotus position: medium skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏽\u{200d}♀",
        codepoint: "1F9D8 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman in lotus position: medium skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_IN_LOTUS_POSITION_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9D8 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman in lotus position: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏾\u{200d}♀",
        codepoint: "1F9D8 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman in lotus position: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧘🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_IN_LOTUS_POSITION_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧘🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9D8 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman in lotus position: dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧘🏿\u{200d}♀",
        codepoint: "1F9D8 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman in lotus position: dark skin tone",
        group: "People & Body",
        subgroup: "person-resting",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🛀"]
pub const PERSON_TAKING_BATH: crate::Emoji = crate::Emoji {
    glyph: "🛀",
    codepoint: "1F6C0",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person taking bath",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon wat bad"),
            keywords: &["bad", "badskuim", "persoon wat bad", "water"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ገላውን የሚታጠብ ሰው"),
            keywords: &["የገላ መታጠቢያ ገንዳ", "ገላን መታጠብ", "ገላውን የሚታጠብ ሰው"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}شخص يستحم"),
            keywords: &["حوض استحمام", "\u{202b}شخص يستحم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("গ\u{9be} ধ\u{9c1}ই থক\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "গ\u{9be} ধ\u{9c1}ই থক\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "গ\u{9be} ধোৱ\u{9be}",
                "ব\u{9be}থট\u{9be}ব",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vanna qəbul edən adam"),
            keywords: &["hamam", "vanna", "vanna qəbul edən adam"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек прымае ванну"),
            keywords: &["вада", "ванна", "чалавек", "чалавек прымае ванну"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("къпещ се човек"),
            keywords: &["баня", "вана", "къпещ се човек"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}যক\u{9cd}তি স\u{9cd}ন\u{9be}ন করছে"),
            keywords: &[
                "ব\u{9be}থটব",
                "ব\u{9cd}যক\u{9cd}তি স\u{9cd}ন\u{9be}ন করছে",
                "স\u{9cd}ন\u{9be}ন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kupanje"),
            keywords: &["kada", "kupanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona a la banyera"),
            keywords: &["bany", "banyera", "persona", "persona a la banyera"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎠᏓᏬᏍᎬᎢ"),
            keywords: &["ᎠᏓᏬᏍᏗ", "ᎤᎾᏙᏬᏍᏗ", "ᏴᏫ ᎠᏓᏬᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba ve vaně"),
            keywords: &["koupel", "koupelna", "osoba ve vaně", "vana"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person mewn bath"),
            keywords: &["bath", "person mewn bath", "twba"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bad"),
            keywords: &["bad", "badekar", "karbad"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("badende Person"),
            keywords: &["Bad", "Badewanne", "Badezimmer", "badende Person"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άνθρωπος που κάνει μπάνιο"),
            keywords: &["άνθρωπος που κάνει μπάνιο", "μπάνιο", "μπανιέρα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person taking bath"),
            keywords: &["bath", "bathtub", "person taking bath"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["bath", "bathtub", "person taking bath", "tub"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona en la bañera"),
            keywords: &["bañera", "baño", "persona", "persona en la bañera"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona en tina"),
            keywords: &["persona en tina"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("inimene vannis"),
            keywords: &["inimene vannis", "vann"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona bat bainatzen"),
            keywords: &["bainu", "bainuontzi", "pertsona bat bainatzen"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فرد در وان"),
            keywords: &["حمام", "فرد در وان", "وان حمام"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kylpijä"),
            keywords: &["kylpijä", "kylpy", "kylpyamme"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong naliligo"),
            keywords: &["bathtub", "ligo", "taong naliligo", "tubig"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur í baðikari"),
            keywords: &["bað", "baðikar", "fólk", "persónur", "persónur í baðikari"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne prenant un bain"),
            keywords: &["baignoire", "bain", "personne prenant un bain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine ag folcadh"),
            keywords: &["duine ag folcadh", "folcadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach san amar"),
            keywords: &[
                "amar",
                "ballan",
                "ionnlad",
                "ionnlaid",
                "neach san amar",
                "tuba",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa bañándose"),
            keywords: &["bañarse", "bañeira", "persoa bañándose"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}નાન કરતી વ\u{acd}યક\u{acd}તિ"),
            keywords: &["સ\u{acd}નાન", "સ\u{acd}નાન કરતી વ\u{acd}યક\u{acd}તિ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai yin wanka"),
            keywords: &["baho", "mutum mai yin wanka", "wanka"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם באמבטיה"),
            keywords: &["אדם באמבטיה", "אמבטיה", "מקלחת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नहाता ह\u{941}आ व\u{94d}यक\u{94d}ति"),
            keywords: &["नहाता ह\u{941}आ व\u{94d}यक\u{94d}ति", "बाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba koja se kupa u kadi"),
            keywords: &["kada", "kupanje", "osoba koja se kupa u kadi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fürdő ember"),
            keywords: &["fürdés", "fürdő ember", "fürdőkád"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լոգանք ընդունող մարդ"),
            keywords: &["լոգանք ընդունող մարդ", "լոգասենյակ", "լոգարան"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang di bak mandi"),
            keywords: &["bak mandi", "mandi", "orang di bak mandi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-asa ahụ"),
            keywords: &["asamụahụ", "ngwa asamụahụ", "onye na-asa ahụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bað"),
            keywords: &["bað", "baðkar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che fa il bagno"),
            keywords: &["fare il bagno", "lavarsi", "persona che fa il bagno"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("風呂に入る人"),
            keywords: &["バスタブ", "浴槽", "風呂", "風呂に入る人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong adus kungkum"),
            keywords: &["bak kungkum", "kungkum", "wong adus kungkum"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ადამიანი აბაზანაში"),
            keywords: &["აბაზანა", "ადამიანი აბაზანაში", "ვარცლი", "სააბაზანო"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("адам ваннада жуынып жатыр"),
            keywords: &["адам ваннада жуынып жатыр", "ванна"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("bad"),
            keywords: &["bad", "badekar"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងដេកត\u{17d2}រា\u{17c6}ក\u{17d2}ន\u{17bb}ងអាង",
            ),
            keywords: &[
                "ដេកត\u{17d2}រា\u{17c6}",
                "មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងដេកត\u{17d2}រា\u{17c6}ក\u{17d2}ន\u{17bb}ងអាង",
                "អាង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{ccd}ನಾನ ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಸ\u{ccd}ನಾನ",
                "ಸ\u{ccd}ನಾನ ಮಾಡುತ\u{ccd}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಸ\u{ccd}ನಾನದ ಟಬ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("목욕하는 사람"),
            keywords: &["목욕하는 사람", "욕조"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("न\u{94d}हावपी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "न\u{94d}हावप",
                "न\u{94d}हावपी मनीस",
                "न\u{94d}हावपी व\u{94d}यक\u{94d}ती",
                "बाथटब",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жуунуп жаткан адам"),
            keywords: &["ванна", "жуун", "жуунуп жаткан адам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun an der Bidden"),
            keywords: &["Bidden", "Buedbidden", "Persoun an der Bidden"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນອາບນ\u{ecd}\u{ec9}າ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ຄ\u{ebb}ນອາບນ\u{ecd}\u{ec9}າ",
                "ອາບນ\u{ecd}\u{ec9}າ",
                "ອ\u{ec8}າງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žmogus prausiasi vonioje"),
            keywords: &["vonia", "žmogus prausiasi vonioje"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks vannā"),
            keywords: &[
                "cilvēks mazgājas",
                "cilvēks vannā",
                "mazgāties",
                "vanna",
                "ūdens",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata kaukau ana"),
            keywords: &["kaukau", "tangata kaukau ana", "tāpu kaukau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("човек во када"),
            keywords: &["када", "човек", "човек во када"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ളിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "ക\u{d41}ളി",
                "ക\u{d41}ളിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "ബ\u{d3e}ത\u{d4d}ത\u{d4d}\u{200c}ടബ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("усанд орж байгаа хүн"),
            keywords: &["орох", "ус", "усанд орж байгаа хүн", "хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आ\u{902}घोळ करणारी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "आ\u{902}घोळ",
                "आ\u{902}घोळ करणारी व\u{94d}यक\u{94d}ती",
                "बाथटब",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang sedang mandi"),
            keywords: &["mandi", "orang sedang mandi", "tab mandi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tieħu banju"),
            keywords: &["banju", "persuna tieħu banju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရေချ\u{102d}\u{102f}းကန\u{103a}တ\u{103d}င\u{103a} ရေချ\u{102d}\u{102f}းနေသ\u{1030}",
            ),
            keywords: &[
                "ရေချ\u{102d}\u{102f}းကန\u{103a}",
                "ရေချ\u{102d}\u{102f}းကန\u{103a}တ\u{103d}င\u{103a} ရေချ\u{102d}\u{102f}းနေသ\u{1030}",
                "ရေချ\u{102d}\u{102f}းခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("person i badekar"),
            keywords: &["bad", "badekar", "person i badekar"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("न\u{941}हाउन\u{947} व\u{94d}यक\u{94d}ति"),
            keywords: &["न\u{941}हाउन\u{947} व\u{94d}यक\u{94d}ति", "बाथ", "बाथटब"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon in badkuip"),
            keywords: &["bad", "badkuip", "persoon in badkuip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("person i badekar"),
            keywords: &["bad", "badekar", "person i badekar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗ\u{b3e}ଧୋଉଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଗ\u{b3e}ଧୋଉଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ବ\u{b3e}ଥଟବ\u{b4d}\u{200c}",
                "ସ\u{b4d}ନ\u{b3e}ନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਹਾਉ\u{a02}ਦਾ ਵਿਅਕਤੀ"),
            keywords: &["ਨਹਾਉ\u{a02}ਦਾ ਵਿਅਕਤੀ", "ਨਹਾਉਣਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بندہ غسل کر دیاں ہوئیاں"),
            keywords: &["باتھ-ٹب", "بندہ غسل کر دیاں ہوئیاں", "نہاؤنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé De Baf"),
            keywords: &[
                "Baf",
                "Bíg Lọ\u{301}ng Bézin Wé Pẹ\u{301}sin De Ẹ\u{301}ntá To Baf",
                "Pẹ\u{301}sin Wé De Baf",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba biorąca kąpiel"),
            keywords: &["kąpiel", "osoba biorąca kąpiel", "wanna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص غسل کوي"),
            keywords: &["د غسل ټب", "شخص غسل کوي", "غسل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa tomando banho"),
            keywords: &["banheira", "pessoa tomando banho"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa a tomar banho"),
            keywords: &["banheira", "banho", "pessoa a tomar banho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa armakuyniyuq"),
            keywords: &["armakunapaq", "bañera", "runa armakuyniyuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană care face baie"),
            keywords: &["cadă", "om", "persoană care face baie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-980"),
            keywords: &["E10-980"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек в ванне"),
            keywords: &["ванна", "ванная", "вода", "человек", "человек в ванне"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu uri kwiyuhagira"),
            keywords: &["koga", "ubwiherero", "umuntu uri kwiyuhagira"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص وهجندي"),
            keywords: &["شخص وهجندي", "وهنجڻ وارو ٽب، وهنجڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dcf}න ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "න\u{dcf}න ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "න\u{dcf}න බේසම",
                "නෑම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek vo vani"),
            keywords: &["kúpeľ", "vaňa", "človek vo vani"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki se kopa"),
            keywords: &["kad", "kopel", "oseba, ki se kopa"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof qubeysanaya"),
            keywords: &["qof qubeysanaya", "qubeys", "tuubo qubeys"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri që lahet"),
            keywords: &["banjë", "larje", "njeri që lahet", "vaskë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа која се купа"),
            keywords: &["кaдa", "купaњe", "особа која се купа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba koja se kupa"),
            keywords: &["kada", "kupanje", "osoba koja se kupa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person som badar"),
            keywords: &["bad", "badar", "badkar", "person som badar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu anayeoga"),
            keywords: &["bafu", "hodhi", "mtu anayeoga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குளியல\u{bcd}"),
            keywords: &["குளியல\u{bcd}", "குளியல\u{bcd} தொட\u{bcd}டி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}న\u{c3e}నం చ\u{c47}స\u{c4d}తున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "స\u{c4d}న\u{c3e}నం",
                "స\u{c4d}న\u{c3e}నం చ\u{c47}స\u{c4d}తున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("нафаре, ки душ карда истодааст"),
            keywords: &["ванна", "нафаре, ки душ карда истодааст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนนอนแช\u{e48}น\u{e49}ำในอ\u{e48}าง"),
            keywords: &[
                "คนนอนแช\u{e48}น\u{e49}ำในอ\u{e48}าง",
                "อาบน\u{e49}ำ",
                "อ\u{e48}าง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wannada suwa düşýän adam"),
            keywords: &["duş", "wanna", "wannada suwa düşýän adam"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha kaukau"),
            keywords: &["tokotaha kaukau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("banyo yapan kişi"),
            keywords: &["banyo", "banyo yapan kişi", "küvet"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۇيۇنۇۋاتقان كىشى"),
            keywords: &["يۇيۇش", "يۇيۇنداق", "يۇيۇنۇۋاتقان كىشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина, що приймає ванну"),
            keywords: &["ванна", "купатися", "людина, що приймає ванну"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نہاتا ہوا شخص"),
            keywords: &["باتھ ٹب", "نہاتا ہوا شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("hammom qilayotgan kishi"),
            keywords: &["hammom qilayotgan kishi", "tos", "vanna"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đang tắm bồn"),
            keywords: &["bồn tắm", "người đang tắm bồn", "tắm"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit kuy sangu"),
            keywords: &["beñuwaar", "nit kuy sangu", "sangu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ohlambayo"),
            keywords: &["ibhafu", "ibhafu yokuhlambela", "umntu ohlambayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni Nwẹ"),
            keywords: &["àgbá ìwé", "ìwẹ\u{300}", "Ẹni Nwẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("沖涼嘅人"),
            keywords: &["沖涼", "沖涼嘅人", "浴缸"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("冲凉嘅人"),
            keywords: &["冲凉", "冲凉嘅人", "浴缸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("洗澡的人"),
            keywords: &["洗澡", "洗澡的人", "浴缸"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("盆浴"),
            keywords: &["洗澡", "盆浴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("浸浴嘅人"),
            keywords: &["浴缸｜浸浴嘅人｜浸浴", "浸浴嘅人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu ogezayo"),
            keywords: &["ubhavu wokugezela", "ukugeza", "umuntu ogezayo"],
        },
    ],
};
#[doc = "🛀🏻"]
pub const PERSON_TAKING_BATH_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛀🏻",
    codepoint: "1F6C0 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person taking bath: light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛀🏼"]
pub const PERSON_TAKING_BATH_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛀🏼",
    codepoint: "1F6C0 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person taking bath: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛀🏽"]
pub const PERSON_TAKING_BATH_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛀🏽",
    codepoint: "1F6C0 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person taking bath: medium skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛀🏾"]
pub const PERSON_TAKING_BATH_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛀🏾",
    codepoint: "1F6C0 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person taking bath: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛀🏿"]
pub const PERSON_TAKING_BATH_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛀🏿",
    codepoint: "1F6C0 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person taking bath: dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛌"]
pub const PERSON_IN_BED: crate::Emoji = crate::Emoji {
    glyph: "🛌",
    codepoint: "1F6CC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person in bed",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon in bed"),
            keywords: &["bed", "hotel", "persoon in bed", "slaap"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አልጋ ላይ የተኛ ሰው"),
            keywords: &["ሆቴል", "አልጋ ላይ የተኛ ሰው", "እንቅልፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص على سرير"),
            keywords: &["شخص على سرير", "فندق", "نوم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9c1}ই থক\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "শ\u{9c1}ই থক\u{9be}",
                "শ\u{9c1}ই থক\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "হোটেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yataqda uzanmış adam"),
            keywords: &["otel", "yataqda uzanmış adam", "yatmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек у ложку"),
            keywords: &["гатэль", "сон", "чалавек у ложку"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Човек в леглото"),
            keywords: &["Човек в леглото", "сън", "хотел"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}যক\u{9cd}তি বিছ\u{9be}ন\u{9be}য\u{9bc} আছেন"),
            keywords: &[
                "ব\u{9cd}যক\u{9cd}তি বিছ\u{9be}ন\u{9be}য\u{9bc} আছেন",
                "শোওয\u{9bc}\u{9be}",
                "হোটেল",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba u krevetu"),
            keywords: &["hotel", "osoba u krevetu", "spavanje"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona al llit"),
            keywords: &["dormir", "hotel", "llit", "persona", "persona al llit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎦᏂᏟ ᎦᏅᎬ"),
            keywords: &["ᎦᏢᏅᏗ", "ᏧᏂᏒᏍᏗ", "ᏴᏫ ᎦᏂᏟ ᎦᏅᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba v posteli"),
            keywords: &["hotel", "osoba v posteli", "spánek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person mewn gwely"),
            keywords: &["cysgu", "gwesty", "person mewn gwely"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("person i seng"),
            keywords: &["hotel", "person i seng", "sove"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("im Bett liegende Person"),
            keywords: &["Bett", "im Bett liegende Person", "schlafen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άνθρωπος σε κρεβάτι"),
            keywords: &["άνθρωπος σε κρεβάτι", "ξενοδοχείο", "ύπνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person in bed"),
            keywords: &["hotel", "person in bed", "sleep"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["hotel", "person in bed", "sleep", "sleeping"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona en la cama"),
            keywords: &["dormir", "hotel", "persona en la cama"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("persona durmiendo"),
            keywords: &["cama", "dormir", "hotel", "persona durmiendo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("inimene voodis"),
            keywords: &["hotell", "inimene voodis", "uni"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona bat ohean"),
            keywords: &["hotel", "lo", "pertsona bat ohean"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فرد در تختخواب"),
            keywords: &["خوابیدن", "فرد در تختخواب", "هتل"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nukkuja"),
            keywords: &["hotelli", "nukkua", "nukkuja", "uni"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong nakahiga"),
            keywords: &["hotel", "natutulog", "taong nakahiga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur í song"),
            keywords: &["fólk", "persónur", "persónur í song", "song", "svevur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne au lit"),
            keywords: &["lit", "personne au lit"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine sa leaba"),
            keywords: &["codladh", "duine sa leaba", "óstán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach san leabaidh"),
            keywords: &["cadal", "neach san leabaidh", "taigh-òsta"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa durmindo"),
            keywords: &["durmir", "hotel", "persoa durmindo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પથારીમા\u{a82} સ\u{ac2}તી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "ઊ\u{a82}ઘ",
                "નિ\u{a82}દ\u{acd}રા",
                "પથારીમા\u{a82} સ\u{ac2}તી વ\u{acd}યક\u{acd}તિ",
                "હોટલ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum a kan gado"),
            keywords: &["barci", "hotal", "mutum a kan gado"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם במיטה"),
            keywords: &["אדם במיטה", "לישון", "מיטה", "מלון", "שינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बिस\u{94d}तर म\u{947}\u{902} सोता व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "बिस\u{94d}तर म\u{947}\u{902} सोता व\u{94d}यक\u{94d}ति",
                "होटल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba u krevetu"),
            keywords: &["hotel", "osoba u krevetu", "spavanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ember az ágyban"),
            keywords: &["alvás", "ember az ágyban", "szálloda"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մահճակալին պառկած մարդ"),
            keywords: &["հյուրանոց", "մահճակալին պառկած մարդ", "քնել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang di tempat tidur"),
            keywords: &["hotel", "orang di tempat tidur", "tidur"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye nọ n’àkwà"),
            keywords: &["onye nọ n’àkwà", "ụlọ nkwarị", "ụra"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("manneskja í rúmi"),
            keywords: &["hótel", "manneskja í rúmi", "sofa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona a letto"),
            keywords: &["dormire", "hotel", "letto", "notte", "persona a letto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ベッドに寝る人"),
            keywords: &["ベッド", "ベッドに寝る人", "ホテル", "寝る"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong turu"),
            keywords: &["hotel", "turu", "wong turu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ადამიანი საწოლში"),
            keywords: &["ადამიანი საწოლში", "სასტუმრო", "ძილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұйықтап жатқан адам"),
            keywords: &["қонақ үй", "ұйықтап жатқан адам", "ұйқы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("person i seng"),
            keywords: &["person i seng", "sove"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សដេកលើគ\u{17d2}រែ"),
            keywords: &[
                "ដេក",
                "មន\u{17bb}ស\u{17d2}សដេក",
                "មន\u{17bb}ស\u{17d2}សដេកលើគ\u{17d2}រែ",
                "លើគ\u{17d2}រែ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಾಸ\u{cbf}ಗ\u{cc6}ಯ ಮೇಲ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ನ\u{cbf}ದ\u{ccd}ರ\u{cc6}",
                "ಹಾಸ\u{cbf}ಗ\u{cc6}ಯ ಮೇಲ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಹೊಟೇಲ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("침대에 누운 사람"),
            keywords: &["침대", "침대에 누운 사람", "호텔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("खाटीच\u{947}र न\u{94d}हिदिल\u{94d}लो व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "खाटीच\u{947}र न\u{94d}हिदिल\u{94d}लो व\u{94d}यक\u{94d}ती",
                "न\u{94d}हीद",
                "हॉट\u{947}ल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төшөктөгү адам"),
            keywords: &["мейманкана", "төшөктөгү адам", "укта"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun am Bett"),
            keywords: &["Hotel", "Persoun am Bett", "schlofen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນນອນເທ\u{eb4}ງຕຽງ"),
            keywords: &["ຄ\u{ebb}ນນອນ", "ຄ\u{ebb}ນນອນເທ\u{eb4}ງຕຽງ", "ໂຮງແຮມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žmogus lovoje"),
            keywords: &["miegoti", "viešbutis", "žmogus lovoje"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks gultā"),
            keywords: &["cilvēks", "cilvēks gultā", "gulta", "gulēt"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata rō moenga"),
            keywords: &["hōtēra", "moe", "tangata rō moenga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("човек во кревет"),
            keywords: &["хотел", "човек", "човек во кревет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കട\u{d4d}ടിലിൽ കിടക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "ഉറക\u{d4d}കം",
                "കട\u{d4d}ടിലിൽ കിടക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "ഹോട\u{d4d}ടൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("орондоо байгаа хүн"),
            keywords: &["зочид буудал", "ор", "орондоо байгаа хүн", "унтах", "хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बिछान\u{94d}यातील व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "झोप",
                "बिछान\u{94d}यातील व\u{94d}यक\u{94d}ती",
                "हॉट\u{947}ल",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang tidur atas katil"),
            keywords: &["hotel", "orang tidur atas katil", "tidur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna fis-sodda"),
            keywords: &["lukanda", "persuna fis-sodda", "rqad"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခ\u{102f}တင\u{103a}ပေါ\u{103a}က လ\u{1030}"),
            keywords: &[
                "ခ\u{102f}တင\u{103a}ပေါ\u{103a} အ\u{102d}ပ\u{103a}နေသ\u{1030}",
                "ခ\u{102f}တင\u{103a}ပေါ\u{103a}က လ\u{1030}",
                "ဟ\u{102d}\u{102f}တယ\u{103a}",
                "အ\u{102d}ပ\u{103a}စက\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("person i seng"),
            keywords: &["hotell", "person i seng", "sove"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("खाटमा भएको व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "खाटमा भएको व\u{94d}यक\u{94d}ति",
                "स\u{941}त\u{94d}न\u{947}",
                "होट\u{947}ल",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon in bed"),
            keywords: &["hotel", "persoon in bed", "slapen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("person i seng"),
            keywords: &["hotell", "person i seng", "sove"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ଶେଯରେ ଅଛନ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ଶେଯରେ ଅଛନ\u{b4d}ତ\u{b3f}",
                "ଶୋଇବ\u{b3e}",
                "ହୋଟେଲ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਿਸਤਰ ‘ਤ\u{a47} ਸ\u{a41}\u{a71}ਤਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਨੀ\u{a02}ਦ",
                "ਬਿਸਤਰ ‘ਤ\u{a47} ਸ\u{a41}\u{a71}ਤਾ ਵਿਅਕਤੀ",
                "ਹ\u{a4b}ਟਲ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بیڈ وچ بندہ"),
            keywords: &["بیڈ وچ بندہ", "سونا", "ہوٹل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé De Slip"),
            keywords: &[
                "Họtẹl",
                "Pẹ\u{301}sin Wé De Slip",
                "Pẹ\u{301}sin Wé Lai Daún Fọ Bẹd To Slip",
                "Slip",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba w łóżku"),
            keywords: &["hotel", "nocleg", "osoba w łóżku", "sen"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص په بستره کې"),
            keywords: &["خوب", "شخص په بستره کې", "هوتل"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa deitada na cama"),
            keywords: &["hotel", "pessoa", "pessoa deitada na cama", "sono"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa na cama"),
            keywords: &["dormir", "hotel", "pessoa na cama"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa puñunapi"),
            keywords: &["puñuy", "runa puñunapi", "tampuwasi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană în pat"),
            keywords: &["hotel", "om", "pat", "persoană în pat", "somn"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-987"),
            keywords: &["E10-987"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек в кровати"),
            keywords: &[
                "гостиница",
                "кровать",
                "отель",
                "сон",
                "человек",
                "человек в кровати",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu uryamye"),
            keywords: &["hoteli", "kuryama", "umuntu uryamye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بستر ۾ شخص"),
            keywords: &["بستر ۾ شخص", "سمهڻ", "هوٽل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇ\u{200d}ඳෙහ\u{dd2} ස\u{dd2}ට\u{dd2}න ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "ඇ\u{200d}ඳෙහ\u{dd2} ස\u{dd2}ට\u{dd2}න ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "න\u{dd2}න\u{dca}ද",
                "හෝටලය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek v posteli"),
            keywords: &["hotel", "posteľ", "spánok", "človek v posteli"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba v postelji"),
            keywords: &["hotel", "oseba v postelji", "spanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof sariir ku jira"),
            keywords: &["hudheel", "hurdo", "qof sariir ku jira"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri në krevat"),
            keywords: &["fle", "gjumë", "hotel", "njeri në krevat"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа у кревету"),
            keywords: &["особа у кревету", "спaвaњe", "хoтeл"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba u krevetu"),
            keywords: &["hotel", "osoba u krevetu", "spavanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person i en säng"),
            keywords: &["hotell", "person i en säng", "säng", "sömn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu aliyelala kitandani"),
            keywords: &["hoteli", "lala", "mtu aliyelala kitandani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("படுக\u{bcd}கையில\u{bcd} படுத\u{bcd}திருப\u{bcd}பவர\u{bcd}"),
            keywords: &[
                "தூக\u{bcd}கம\u{bcd}",
                "படுக\u{bcd}கையில\u{bcd} படுத\u{bcd}திருப\u{bcd}பவர\u{bcd}",
                "படுத\u{bcd}திருப\u{bcd}பவர\u{bcd}",
                "விடுதி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పరుపు మ\u{c40}ద ఉన\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "పరుపు",
                "పరుపు మ\u{c40}ద ఉన\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("одам дар бистар"),
            keywords: &["меҳмонхона", "одам дар бистар", "хоб кардан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนนอนหล\u{e31}บ"),
            keywords: &["คนนอนหล\u{e31}บ", "หล\u{e31}บ", "โรงแรม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýatalgada ýatan adam"),
            keywords: &["myhmanhana", "uky", "ýatalgada ýatan adam"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ʻi mohenga"),
            keywords: &["tokotaha ʻi mohenga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yatakta yatan kişi"),
            keywords: &["otel", "uyuma", "yatakta yatan kişi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كارىۋاتتىكى كىشى"),
            keywords: &["ئۇخلاش", "كارىۋاتتىكى كىشى", "مېھمانخانا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина в ліжку"),
            keywords: &["готель", "людина в ліжку", "сон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بستر میں لیٹا شخص"),
            keywords: &["بستر میں لیٹا شخص", "نیند", "ہوٹل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("karavotda yotgan kishi"),
            keywords: &["karavotda yotgan kishi", "mehmonxona", "uxlash", "uyqu"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người trên giường"),
            keywords: &["khách sạn", "người trên giường", "ngủ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ci kaw lal"),
            keywords: &["nelaw", "nit ci kaw lal", "otel"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu osebhedini"),
            keywords: &["ihotele", "lala", "umntu osebhedini"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹniyan Nibusun"),
            keywords: &["ilé ìtura", "sùn", "Ẹniyan Nibusun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("喺床上嘅人"),
            keywords: &["喺床上嘅人", "訓覺", "酒店"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("喺床上嘅人"),
            keywords: &["喺床上嘅人", "训觉", "酒店"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("躺在床上的人"),
            keywords: &["入睡", "宾馆", "躺在床上的人", "酒店"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("睡覺"),
            keywords: &["睡覺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("瞓覺"),
            keywords: &["床｜瞓覺嘅人｜瞓覺", "瞓覺"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu olele"),
            keywords: &["ihhotela", "ukulala", "umuntu olele"],
        },
    ],
};
#[doc = "🛌🏻"]
pub const PERSON_IN_BED_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛌🏻",
    codepoint: "1F6CC 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "person in bed: light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛌🏼"]
pub const PERSON_IN_BED_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛌🏼",
    codepoint: "1F6CC 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "person in bed: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛌🏽"]
pub const PERSON_IN_BED_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛌🏽",
    codepoint: "1F6CC 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "person in bed: medium skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛌🏾"]
pub const PERSON_IN_BED_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛌🏾",
    codepoint: "1F6CC 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "person in bed: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🛌🏿"]
pub const PERSON_IN_BED_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🛌🏿",
    codepoint: "1F6CC 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "person in bed: dark skin tone",
    group: "People & Body",
    subgroup: "person-resting",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
