#[doc = "🙍"]
pub const PERSON_FROWNING: crate::Emoji = crate::Emoji {
    glyph: "🙍",
    codepoint: "1F64D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person frowning",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon wat frons"),
            keywords: &["frons", "gebaar", "ongelukkig", "persoon wat frons"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተኮሳተረ ሰው"),
            keywords: &["የተኮሳተረ", "የተኮሳተረ ሰው", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص عابس"),
            keywords: &["إشارة", "شخص", "شخص عابس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9cd}ৰ\u{9c2}ক\u{9c1}টি মৰ\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ভঙ\u{9cd}গী",
                "ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি",
                "ভ\u{9cd}ৰ\u{9c2}ক\u{9c1}টি মৰ\u{9be} ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaşqabaqlı adam"),
            keywords: &["jest", "qaşqabaqlı", "qaşqabaqlı adam"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("засмучаны чалавек"),
            keywords: &["жэст", "засмуціцца", "засмучаны чалавек"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Намръщен човек"),
            keywords: &["Намръщен човек", "гримаса", "жест"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9cd}রোধি ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "ক\u{9cd}রোধি ব\u{9cd}যক\u{9cd}তি",
                "ভ\u{9cd}র\u{9c2} ক\u{9c1}চ\u{981}ক\u{9be}নো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("namrštena osoba"),
            keywords: &["gestikulacija", "izraz lica", "mrštenje", "namrštena osoba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona emmurriada"),
            keywords: &[
                "emmurriament",
                "persona",
                "persona arrufada",
                "persona emmurriada",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᏓᏁᎪᏳ"),
            keywords: &["ᎠᏎᏟᏙᎯ", "ᎤᏓᏁᎪᏳ", "ᏴᏫ ᎤᏓᏁᎪᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamračená osoba"),
            keywords: &["výraz", "zamračená osoba", "zamračení"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn gwgu"),
            keywords: &["gwg", "person yn gwgu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("Utilfreds person"),
            keywords: &["Utilfreds person", "alvorlig mine", "udtryk", "utilfreds"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("missmutige Person"),
            keywords: &["Gesicht", "missmutige Person"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συνοφρυωμένο άτομο"),
            keywords: &["συνοφρυωμένο άτομο", "συνοφρύωμα", "χειρονομία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person frowning"),
            keywords: &["frown", "gesture", "person frowning"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona frunciendo el ceño"),
            keywords: &[
                "ceño",
                "fruncido",
                "gesto",
                "persona",
                "persona frunciendo el ceño",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "ceño",
                "enojado",
                "mal",
                "mujer frunciendo el ceño",
                "persona",
                "persona frunciendo el ceño",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona frunciendo el ceño"),
            keywords: &["cara", "ceño", "fruncido", "persona frunciendo el ceño"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("persona frunciendo el ceño"),
            keywords: &["ceño fruncido", "gesto", "persona frunciendo el ceño"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kulmu kortsutav inimene"),
            keywords: &["ilme", "kulmu kortsutav inimene", "kulmukortsutus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopeta zimurtzen ari den pertsona"),
            keywords: &[
                "keinu",
                "kopeta",
                "kopeta zimurtzen ari den pertsona",
                "zimurtu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آدم اخمو"),
            keywords: &["آدم اخمو", "اخم", "اشاره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("surullinen henkilö"),
            keywords: &["ele", "surullinen", "surullinen henkilö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong nakasimangot"),
            keywords: &[
                "ekspresyon",
                "expression",
                "nakasimangot",
                "simangot",
                "taong nakasimangot",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("illbrýntur persónur"),
            keywords: &["fólk", "illbrýnt", "illbrýntur persónur", "persónur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne fronçant les sourcils"),
            keywords: &["froncer", "personne fronçant les sourcils", "sourcils"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("personne mécontente"),
            keywords: &["froncer", "mécontente", "personne", "sourcils"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine le púic air"),
            keywords: &["duine", "duine le púic air", "gotha", "gruama"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach le drèin"),
            keywords: &["drèin", "gluasad", "neach le drèin"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa enfurruñada"),
            keywords: &["cello", "enfurruñado", "persoa enfurruñada", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભવા\u{a82} ચડાવ\u{ac7}લ વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "ભવા\u{a82} ચડાવવા\u{a82}",
                "ભવા\u{a82} ચડાવ\u{ac7}લ વ\u{acd}યક\u{acd}તિ",
                "વ\u{acd}યક\u{acd}તિ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai ɓacin rai"),
            keywords: &["karimcin", "mutum mai ɓacin rai", "ɓacin rai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה לא מרוצה"),
            keywords: &["אישה לא מרוצה", "זועמת", "זועפת", "כועסת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नाक–भौ\u{902} चढ\u{93c}ाया व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "नाक–भौ\u{902} चढ\u{93c}ाना",
                "नाक–भौ\u{902} चढ\u{93c}ाया व\u{94d}यक\u{94d}ति",
                "व\u{94d}यक\u{94d}ति",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba koja se mršti"),
            keywords: &["izraz lica", "mrštenje", "osoba koja se mršti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rosszalló ember"),
            keywords: &["rosszallás", "rosszalló ember", "rosszalló tekintet"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոժոռված դեմքով անձ"),
            keywords: &["ժեստ", "խոժոռված", "խոժոռված դեմքով անձ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang marah"),
            keywords: &["gerakan", "marah", "orang marah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-agbarụ ihu"),
            keywords: &["mgbarụ", "ogbugbu", "onye na-agbarụ ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("manneskja með ygglibrún"),
            keywords: &["fýlusvipur", "manneskja með ygglibrún"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona corrucciata"),
            keywords: &["corrucciata", "gesto", "persona"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しかめ面の人"),
            keywords: &["しかめっ面", "しかめ面", "しかめ面の人", "しかめ顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong sedhih"),
            keywords: &["isarat", "sedhih", "wong sedhih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჭმუხნილი პიროვნება"),
            keywords: &["ჟესტი", "შეკრული", "შეჭმუხნილი", "შეჭმუხნილი პიროვნება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қабағын түю"),
            keywords: &["қабағын түю", "қимыл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("rynkede bryn"),
            keywords: &["rynkede bryn", "udtryk", "utilfreds"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "មន\u{17bb}ស\u{17d2}ស\u{200b}ក\u{17c6}ព\u{17bb}ងក\u{17d2}រៀមក\u{17d2}រ\u{17c6}",
            ),
            keywords: &[
                "ក\u{17d2}រៀមក\u{17d2}រ\u{17c6}",
                "មន\u{17bb}ស\u{17d2}ស",
                "មន\u{17bb}ស\u{17d2}ស\u{200b}ក\u{17c6}ព\u{17bb}ងក\u{17d2}រៀមក\u{17d2}រ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಗಂಟ\u{cbf}ಕ\u{ccd}ಕು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("찌푸린 사람"),
            keywords: &["짜증", "찌푸린 사람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मनीस रागार जाता"),
            keywords: &["मनीस", "मनीस रागार जाता", "रागार", "रागार जाला", "हावभाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кабагын бүркөгөн адам"),
            keywords: &["кабагын бүркөгөн адам", "кабак бүркө", "маанай"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("d’Stir fronzend Persoun"),
            keywords: &["Geste", "Stir", "d’Stir fronzend Persoun", "fronzen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນເຮ\u{eb1}ດໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງ"),
            keywords: &[
                "ຄ\u{eb4}\u{ec9}ວ",
                "ຄ\u{ebb}ນເຮ\u{eb1}ດໜ\u{ec9}າຫຍ\u{eb8}\u{ec9}ງ",
                "ຫຍ\u{eb8}\u{ec9}ງ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paniuręs žmogus"),
            keywords: &["gestas", "paniuręs žmogus", "raukytis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("norūpējies cilvēks"),
            keywords: &["bēdīgs", "norūpējies cilvēks", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata poururu"),
            keywords: &["poururu", "tangata poururu", "tohu ā-ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("намуртен човек"),
            keywords: &["гест", "намуртен", "намуртен човек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നീരസഭ\u{d3e}വമ\u{d41}ള\u{d4d}ള വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "നീരസം",
                "നീരസഭ\u{d3e}വമ\u{d41}ള\u{d4d}ള വ\u{d4d}യക\u{d4d}തി",
                "നെറ\u{d4d}റി ച\u{d41}ളിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урвайсан хүн"),
            keywords: &["урвайсан хүн", "урвайх", "хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आठ\u{94d}या य\u{947}ण\u{947}"),
            keywords: &[
                "आठ\u{94d}या",
                "आठ\u{94d}या असल\u{947}ली व\u{94d}यक\u{94d}ती",
                "आठ\u{94d}या य\u{947}ण\u{947}",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang berkerut dahi"),
            keywords: &["berkerut", "isyarat", "orang berkerut dahi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna titkerrah"),
            keywords: &["persuna titkerrah", "titkerrah", "ġesti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေသ\u{1030}"),
            keywords: &[
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}",
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေသ\u{1030}",
                "အမ\u{1030}အရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rynker brynene"),
            keywords: &["mimikk", "rynker brynene", "rynker pannen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("रिसाएको व\u{94d}यक\u{94d}ति"),
            keywords: &["भाव प\u{94d}रदर\u{94d}शन", "रिसाएको व\u{94d}यक\u{94d}ति"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fronsend persoon"),
            keywords: &["frons", "fronsend persoon", "uitdrukking"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rynkar bryna"),
            keywords: &["mimikk", "rynkar bryna", "rynkar panna"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଇଙ\u{b4d}ଗ\u{b3f}ତ",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉ\u{a02}ਦਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉ\u{a02}ਦਾ ਵਿਅਕਤੀ",
                "ਨਰਾਜ\u{a3c} ਵਿਅਕਤੀ",
                "ਨਰਾਜ\u{a3c}ਗੀ",
                "ਵਿਅਕਤੀ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیوری آلا بندہ"),
            keywords: &["اشارہ", "تیوری آلا بندہ", "تیوری چڑھونا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Skwíz Fes"),
            keywords: &[
                "Fraun",
                "Pẹ\u{301}sin Wé De Fraun",
                "Pẹ\u{301}sin Wé Skwíz Fes",
                "Sain",
                "Skwíz Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zachmurzona osoba"),
            keywords: &["smutek na twarzy", "smutny", "zachmurzona osoba"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص وروځې راغورځوي"),
            keywords: &["اشاره", "شخص وروځې راغورځوي", "وروځې روغورځول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("franzindo a sobrancelha"),
            keywords: &[
                "franzindo a sobrancelha",
                "gesto",
                "pessoa",
                "pessoa franzindo a sobrancelha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa de sobrolho franzido"),
            keywords: &["cara triste", "gesto", "pessoa de sobrolho franzido"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llakisqa runa"),
            keywords: &["gesto", "llaki", "llakisqa runa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană întristată"),
            keywords: &["gest", "persoană întristată", "supărare", "întristare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-913"),
            keywords: &["E10-913"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нахмурившийся человек"),
            keywords: &[
                "лицо",
                "нахмурившийся человек",
                "расстроен",
                "хмурый",
                "человек",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu utishimye"),
            keywords: &["ikimenyetso", "kurakara", "umuntu utishimye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پريشان ماڻهو"),
            keywords: &["پريشان ماڻهو", "پريشان، اشارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රවන ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "අභ\u{dd2}න",
                "රවන ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "රැව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zamračený človek"),
            keywords: &["výraz", "zamračená", "zamračený človek"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki se mršči"),
            keywords: &["gesta", "mrščenje", "oseba, ki se mršči"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof wajiga kaduudaya"),
            keywords: &["qof wajiga kaduudaya", "waji kaduudid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri i vrenjtur"),
            keywords: &["gjest", "njeri i vrenjtur", "vrenjtje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("намрштена особа"),
            keywords: &["крeтање", "мрштeњe", "намрштена особа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("namrštena osoba"),
            keywords: &["kretanje", "mrštenje", "namrštena osoba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sur person"),
            keywords: &["person", "sur", "sur uppsyn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu anayekunja kipaji cha uso"),
            keywords: &["chukizwa", "ishara", "mtu anayekunja kipaji cha uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வருத\u{bcd}தம\u{bbe}க இருப\u{bcd}பவர\u{bcd}"),
            keywords: &[
                "வருத\u{bcd}தத\u{bcd}தைத\u{bcd} தெரிவித\u{bcd}தல\u{bcd}",
                "வருத\u{bcd}தம\u{bbe}க இருப\u{bcd}பவர\u{bcd}",
                "வருத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4b}పంత\u{c4b} తల ద\u{c3f}ంచుకున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "క\u{c4b}పం",
                "క\u{c4b}పంత\u{c4b} తల ద\u{c3f}ంచుకున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "తల",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки қавоқ андохта истодааст"),
            keywords: &[
                "имову ишора",
                "шахсе, ки қавоқ андохта истодааст",
                "қавоқ андохтан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขมวดค\u{e34}\u{e49}ว"),
            keywords: &[
                "ขมวดค\u{e34}\u{e49}ว",
                "ค\u{e34}\u{e49}ว",
                "บ\u{e36}\u{e49}งต\u{e36}ง",
                "หน\u{e49}า",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çytyk adam"),
            keywords: &["çytyk adam"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha matamamahi"),
            keywords: &["tokotaha matamamahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("somurtma"),
            keywords: &["hareket", "kişi", "somurtan kişi", "somurtma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشۇمىسىنى تۈرگەن كىشى"),
            keywords: &["ئشارە", "قوشۇما", "قوشۇمىسىنى تۈرگەن كىشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("похмура людина"),
            keywords: &["жест", "нахмурений", "похмура людина"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تیوری چڑھائے شخص"),
            keywords: &["اشارہ", "تیوری", "تیوری چڑھائے شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xo‘mraygan odam"),
            keywords: &["imo-ishora", "qovog‘ini solish", "xo‘mraygan odam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đang cau mày"),
            keywords: &["cau mày", "cử chỉ", "người đang cau mày"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ku yéen yi lemu"),
            keywords: &["aj-yéen", "liyaar", "nit ku yéen yi lemu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ofinge iintshiya"),
            keywords: &["finga iintshaya", "jekula", "umntu ofinge iintshiya"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni N Bojujẹ"),
            keywords: &["fajúro", "fọwọ\u{301}júwè", "Ẹni N Bojujẹ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("皺眉嘅人"),
            keywords: &["皺眉", "皺眉嘅人", "表情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("皱眉嘅人"),
            keywords: &["皱眉", "皱眉嘅人", "表情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("皱眉"),
            keywords: &["不开心", "皱眉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("皺眉"),
            keywords: &["皺眉", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("皺眉嘅人"),
            keywords: &["皺眉", "皺眉嘅人", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu ohwaqabele"),
            keywords: &["ukuhwaqabala", "umuntu ohwaqabele"],
        },
    ],
};
#[doc = "🙍🏻"]
pub const PERSON_FROWNING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏻",
    codepoint: "1F64D 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person frowning: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙍🏼"]
pub const PERSON_FROWNING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏼",
    codepoint: "1F64D 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person frowning: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙍🏽"]
pub const PERSON_FROWNING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏽",
    codepoint: "1F64D 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person frowning: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙍🏾"]
pub const PERSON_FROWNING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏾",
    codepoint: "1F64D 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person frowning: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙍🏿"]
pub const PERSON_FROWNING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏿",
    codepoint: "1F64D 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person frowning: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙍\u{200d}♂\u{fe0f}"]
pub const MAN_FROWNING: crate::Emoji = crate::Emoji {
    glyph: "🙍\u{200d}♂\u{fe0f}",
    codepoint: "1F64D 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man frowning",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍\u{200d}♂",
        codepoint: "1F64D 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man frowning",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man wat frons"),
            keywords: &["frons", "gebaar", "man wat frons", "ongelukkig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ተኮሳትሮ"),
            keywords: &["ወንድ", "ወንድ ተኮሳትሮ", "የተኮሳተረ", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("متجهم"),
            keywords: &["عبوس", "متجهم", "مقطب الجبين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি মৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ভঙ\u{9cd}গিম\u{9be}",
                "ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি মৰ\u{9be}",
                "ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি মৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kefsiz kişi"),
            keywords: &["jest", "kefsiz kişi", "kişi", "qaşqabaqlı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("засмучаны мужчына"),
            keywords: &["жэст", "засмучаны", "мужчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("намръщен мъж"),
            keywords: &["мръщене", "намръщен мъж", "обиден мъж", "обидена гримаса"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ , ছেলে ভ\u{9c1}র\u{9c1} ক\u{9c1}\u{981}চক\u{9be}নো"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ছেলে",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ , ছেলে ভ\u{9c1}র\u{9c1} ক\u{9c1}\u{981}চক\u{9be}নো",
                "ভ\u{9c1}র\u{9c1} ক\u{9c1}\u{981}চক\u{9be}নো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("namršten muškarac"),
            keywords: &["gestikulacija", "mrštenje", "muškarac", "namršten muškarac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home emmurriat"),
            keywords: &["arrufar", "celles", "gest", "home emmurriat", "masculí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏓᏁᎪᏳᎭ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏎᏟᏙᎯ", "ᎤᏓᏁᎪᏳᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamračený muž"),
            keywords: &["muž", "výraz", "zamračený"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn gwgu"),
            keywords: &["dyn", "dyn yn gwgu", "gwgu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("Utilfreds mand"),
            keywords: &[
                "Utilfreds mand",
                "mand",
                "mand med alvorlig mine",
                "panderynken",
                "utilfreds",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("missmutiger Mann"),
            keywords: &["Gesicht", "Mann", "Stirn runzeln", "missmutiger Mann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συνοφρυωμένος"),
            keywords: &["άντρας", "θλίψη", "μορφασμός", "συνοφρυωμένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man frowning"),
            keywords: &["frowning", "gesture", "man"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre frunciendo el ceño"),
            keywords: &[
                "ceño",
                "fruncido",
                "gesto",
                "hombre",
                "hombre frunciendo el ceño",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kulmu kortsutav mees"),
            keywords: &["ilme", "kulmu kortsutav mees", "kulmukortsutus", "mees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopeta zimurtzen ari den gizona"),
            keywords: &[
                "gizon",
                "gizonezko",
                "keinu",
                "kopeta",
                "kopeta zimurtzen ari den gizona",
                "zimurtu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد اخم می\u{200c}کند"),
            keywords: &[
                "اخمو",
                "مرد ابرو در هم می\u{200c}کشد",
                "مرد اخم می\u{200c}کند",
                "مرد عبوس",
                "ناخشنود",
                "ناراضی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("surullinen mies"),
            keywords: &["harmi", "mies", "suru", "surullinen mies"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking nakasimangot"),
            keywords: &[
                "ekspresyon",
                "lalaki",
                "lalaking nakasimangot",
                "nakakunot-noo",
                "nakasimangot",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("illbrýntur maður"),
            keywords: &["illbrýntur", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme fronçant les sourcils"),
            keywords: &[
                "froncement",
                "geste",
                "homme",
                "homme fronçant les sourcils",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "froncement",
                "geste",
                "homme",
                "homme fronçant les sourcils",
                "sourcils",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear le púic air"),
            keywords: &[
                "ag cur grainc",
                "cor",
                "fear",
                "fear ag cur grainc",
                "fear le púic air",
                "fearann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine le drèin"),
            keywords: &[
                "drèin",
                "duine",
                "duine le drèin",
                "fear",
                "fireannach",
                "gluasad",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home enfurruñado"),
            keywords: &["cello", "enfurruñado", "home", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભવા\u{a82} ચડાવવા\u{a82}વાળો પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "પ\u{ac1}ર\u{ac1}ષ",
                "ભવા\u{a82} ચડાવવા\u{a82}",
                "ભવા\u{a82} ચડાવવા\u{a82}વાળો પ\u{ac1}ર\u{ac1}ષ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji mai ɓacin rai"),
            keywords: &["karimcin", "mutum", "namiji mai ɓacin rai", "ɓacin rai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר מדוכדך"),
            keywords: &["איש", "גבר", "גבר מדוכדך", "זועף", "מדוכא", "עצוב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नाक-भौ\u{902} चढ\u{93c}ाया प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "इशारा",
                "नाक-भौ\u{902} चढ\u{93c}ाया प\u{941}र\u{941}ष",
                "नाक–भौ\u{902} चढ\u{93c}ाया",
                "प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("namršteni muškarac"),
            keywords: &["izraz lica", "mrštenje", "muškarac", "namršteni muškarac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rosszalló férfi"),
            keywords: &["férfi", "gesztus", "rosszallás", "rosszalló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոժոռված տղամարդ"),
            keywords: &["խոժոռված", "մարդ", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria muka tidak senang"),
            keywords: &[
                "laki-laki",
                "muka",
                "pria muka tidak senang",
                "tidak senang",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-agbarụ ihu"),
            keywords: &["na-agbarụ", "nwoke", "nwoke na-agbarụ ihu", "ogbugbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður með skeifu"),
            keywords: &["fýla", "karl", "leiður", "maður með skeifu", "skeifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo corrucciato"),
            keywords: &["corrucciato", "gesto", "maschio", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しかめ面の男"),
            keywords: &["しかめっ面", "しかめ面の男", "しかめ顔", "男", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang sedhih"),
            keywords: &["isarat", "sedhih", "wong lanang", "wong lanang sedhih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჭმუხნილი კაცი"),
            keywords: &["კაცი", "ჟესტი", "შეჭმუხნილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ашулы ер"),
            keywords: &["ашулы", "ер", "ызалы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand rynker panden"),
            keywords: &[
                "mand",
                "mand rynker panden",
                "rynke panden",
                "rynkede bryn",
                "rynket pande",
                "utilfreds",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសម\u{17bb}ខក\u{17d2}រញ\u{17c9}\u{17bc}វ"),
            keywords: &[
                "ក\u{17d2}រញ\u{17c9}\u{17bc}វ",
                "ទ\u{17b9}កម\u{17bb}ខ",
                "ប\u{17bb}រស",
                "ប\u{17bb}រសម\u{17bb}ខក\u{17d2}រញ\u{17c9}\u{17bc}វ",
                "ប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಖ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ದ ಪುರುಷ"),
            keywords: &[
                "ಅಂಗಸನ\u{ccd}ನ\u{cc6}",
                "ಪುರುಷ",
                "ಮುಖ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ದ ಪುರುಷ",
                "ಹುಬ\u{ccd}ಬು ಗಂಟ\u{cbf}ಕ\u{ccd}ಕು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("찌푸린 남자"),
            keywords: &["얼굴", "찌푸린 남자", "찌푸림", "찡그림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो रागार जाता"),
            keywords: &["दादलो", "दादलो रागार जाता", "रागार जाता", "हावभाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кабагын бүркөгөн эркек"),
            keywords: &["ишарат", "кабагын бүркөгөн эркек", "кабагын чытуу", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("d’Stir fronzende Mann"),
            keywords: &["Geste", "Mann", "Stir", "d’Stir fronzende Mann", "fronzen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດໜ\u{ec9}າບ\u{eb6}\u{ec9}ງ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດໜ\u{ec9}າບ\u{eb6}\u{ec9}ງ",
                "ໜ\u{ec9}າບ\u{eb6}\u{ec9}ງ",
                "ໜ\u{ec9}າບ\u{eb9}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paniuręs vyras"),
            keywords: &["gestas", "paniuręs", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("norūpējies vīrietis"),
            keywords: &["dusmoties", "norūpējies vīrietis", "vīrietis", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne poururu"),
            keywords: &["poururu", "tohu ā-ringa", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("намуртен маж"),
            keywords: &["гест", "маж", "муртење", "намуртен маж"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെറ\u{d4d}റി ച\u{d41}ളിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "നീരസം പ\u{d4d}രകടിപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന",
                "നെറ\u{d4d}റി ച\u{d41}ളിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дурамжхан эрэгтэй"),
            keywords: &[
                "дохио зангаа",
                "дурамжхан эрэгтэй",
                "хөмсөг зангидах",
                "эр",
                "эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आठ\u{94d}या असल\u{947}ला प\u{941}र\u{941}ष"),
            keywords: &[
                "आठ\u{94d}या",
                "आठ\u{94d}या असल\u{947}ला प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki berkerut dahi"),
            keywords: &[
                "gerak isyarat",
                "lelaki",
                "lelaki berkerut dahi",
                "mengerut dahi",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jitkerrah"),
            keywords: &["jitkerrah", "raġel", "ġesti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
                "ဝမ\u{103a}းနည\u{103a}းကြေက\u{103d}\u{1032}",
                "ဝမ\u{103a}းနည\u{103a}းကြေက\u{103d}\u{1032}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann som rynker brynene"),
            keywords: &[
                "mann",
                "mann som rynker brynene",
                "mimikk",
                "rynker pannen",
                "skeptisk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आ\u{901}खा तरिरह\u{947}को मान\u{94d}छ\u{947}"),
            keywords: &[
                "आ\u{901}खा तरिरह\u{947}को",
                "आ\u{901}खा तरिरह\u{947}को मान\u{94d}छ\u{947}",
                "इसारा",
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fronsende man"),
            keywords: &["frons", "fronsende man", "man", "uitdrukking"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann som rynkar bryna"),
            keywords: &[
                "mann",
                "mann som rynkar bryna",
                "mimikk",
                "rynkar panna",
                "skeptisk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b41}ର\u{b41}ଷ ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉ\u{a02}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉ\u{a02}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉਣਾ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیوری چڑھاندا بندہ"),
            keywords: &[
                "اشارہ",
                "بندہ",
                "تیوری چڑھاندا بندہ",
                "تیوری چڑھاندیاں ہوئیاں",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé De Fraún Im Fes"),
            keywords: &[
                "Man",
                "Man Wé De Fraún Im Fes",
                "Sain",
                "Skwíz Fes",
                "To Fraun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zachmurzony mężczyzna"),
            keywords: &["mężczyzna", "zachmurzony mężczyzna", "zmarszczone brwi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی وروځې راغورځوي"),
            keywords: &["اشاره", "سړی", "سړی وروځې راغورځوي", "وروځې راغورځول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem franzindo a sobrancelha"),
            keywords: &[
                "carrancudo",
                "desconfiado",
                "homem",
                "homem franzindo a sobrancelha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem de sobrolho franzido"),
            keywords: &[
                "condenar",
                "franzir nariz",
                "homem",
                "homem de sobrolho franzido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llakisqa tata"),
            keywords: &["gesto", "llakisqa", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat întristat"),
            keywords: &["bărbat întristat", "gest", "supărare", "întristare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1219"),
            keywords: &["E10-1219"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нахмурившийся мужчина"),
            keywords: &[
                "мужчина",
                "нахмурившийся мужчина",
                "расстроен",
                "хмурый",
                "человек",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo utishimye"),
            keywords: &["ikimenyetso", "umugabo", "utishimye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد پريشان"),
            keywords: &["مرد پريشان", "پريشان، اشارو، ماڻهو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රවන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "අභ\u{dd2}න",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "රවන ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "රැව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zamračený muž"),
            keywords: &["muž", "tvár", "zamračený"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški z namrščenim obrazom"),
            keywords: &[
                "fant",
                "moški",
                "moški z namrščenim obrazom",
                "mrščiti se",
                "neodobravanje",
                "obraz",
                "obrazna mimika",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin wajiga kaduudaya"),
            keywords: &["meedaar", "nin", "nin wajiga kaduudaya", "waji kaduudidda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë i vrenjtur"),
            keywords: &["burrë", "burrë i vrenjtur", "gjest", "i vrenjtur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("намрштен мушкарац"),
            keywords: &["мрштење", "мушкарац", "намрштен мушкарац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("namršten muškarac"),
            keywords: &["mrštenje", "muškarac", "namršten muškarac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sur man"),
            keywords: &["gest", "man", "sur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume anayekunja kipaji cha uso"),
            keywords: &[
                "chukizwa",
                "ishara",
                "mwanamume",
                "mwanamume anayekunja kipaji cha uso",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வருத\u{bcd}தம\u{bbe}ன ஆண\u{bcd}"),
            keywords: &[
                "அழுகை",
                "ஆண\u{bcd}",
                "கவலை",
                "வருத\u{bcd}தம\u{bbe}ன ஆண\u{bcd}",
                "வருத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముఖం చ\u{c3f}ట\u{c4d}ల\u{c3f}ంచ\u{c3f}న పురుషుడు"),
            keywords: &[
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "ముఖం చ\u{c3f}ట\u{c4d}ల\u{c3f}ంచడం",
                "ముఖం చ\u{c3f}ట\u{c4d}ల\u{c3f}ంచ\u{c3f}న పురుషుడు",
                "సంజ\u{c4d}ఞ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки қавоқ андохта истодааст"),
            keywords: &[
                "имову ишора",
                "мард",
                "марде, ки қавоқ андохта истодааст",
                "қавоқандозӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายหน\u{e49}าบ\u{e36}\u{e49}ง"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายหน\u{e49}าบ\u{e36}\u{e49}ง",
                "หน\u{e49}าบ\u{e36}\u{e49}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çytylýan erkek"),
            keywords: &["erkek", "çytylmak", "çytylýan erkek", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata matamamahi"),
            keywords: &["tangata matamamahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("somurtan erkek"),
            keywords: &["adam", "erkek", "mimik", "somurtan erkek", "somurtma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشۇمىسىنى تۈرگەن ئەر"),
            keywords: &["ئىشارە", "ئەر", "قوشۇما", "قوشۇمىسىنى تۈرگەن ئەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("похмурий чоловік"),
            keywords: &["засмучений", "похмурий чоловік", "розчарування", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھورتا ہوا مرد"),
            keywords: &[
                "مرد",
                "ناراضگی ظاہر کرتا ہوا مرد",
                "گھورتا ہوا مرد",
                "گھورنا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xo‘mraygan erkak"),
            keywords: &["erkak", "xoʻmrayish", "xo‘mraygan erkak", "yuz ifodasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông cau mày"),
            keywords: &["cau mày", "cử chỉ", "nam", "người đàn ông cau mày"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor aj-yéen"),
            keywords: &["aj-yéen", "góor", "liyaar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda efinge iintshiya"),
            keywords: &[
                "indoda",
                "indoda efinge iintshiya",
                "jekula",
                "ukufinga iintshiya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tí ń fajúro"),
            keywords: &[
                "fífajúro",
                "fífowọ\u{301}júwè",
                "ọkùnrin",
                "ọkùnrin tí ń fajúro",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("皺眉嘅男人"),
            keywords: &["男", "皺眉", "皺眉嘅男人", "表情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("皱眉嘅男人"),
            keywords: &["男", "皱眉", "皱眉嘅男人", "表情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("皱眉男"),
            keywords: &["不开心", "男", "皱眉", "皱眉男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生皺眉"),
            keywords: &["男", "男生皺眉", "皺眉", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男子皺眉"),
            keywords: &["男人", "男子皺眉", "皺眉", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda ehwaqabele"),
            keywords: &["indoda", "indoda ehwaqabele", "ukuhwaqabala"],
        },
    ],
};
#[doc = "🙍🏻\u{200d}♂\u{fe0f}"]
pub const MAN_FROWNING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F64D 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man frowning: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏻\u{200d}♂",
        codepoint: "1F64D 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man frowning: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏼\u{200d}♂\u{fe0f}"]
pub const MAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F64D 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man frowning: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏼\u{200d}♂",
        codepoint: "1F64D 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man frowning: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏽\u{200d}♂\u{fe0f}"]
pub const MAN_FROWNING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F64D 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man frowning: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏽\u{200d}♂",
        codepoint: "1F64D 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man frowning: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏾\u{200d}♂\u{fe0f}"]
pub const MAN_FROWNING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F64D 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man frowning: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏾\u{200d}♂",
        codepoint: "1F64D 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man frowning: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏿\u{200d}♂\u{fe0f}"]
pub const MAN_FROWNING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F64D 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man frowning: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏿\u{200d}♂",
        codepoint: "1F64D 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man frowning: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍\u{200d}♀\u{fe0f}"]
pub const WOMAN_FROWNING: crate::Emoji = crate::Emoji {
    glyph: "🙍\u{200d}♀\u{fe0f}",
    codepoint: "1F64D 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman frowning",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍\u{200d}♀",
        codepoint: "1F64D 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman frowning",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou wat frons"),
            keywords: &["frons", "gebaar", "ongelukkig", "vrou wat frons"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ተኮሳትራ"),
            keywords: &["ሴት ተኮሳትራ", "ወንድ", "የተኮሳተረ", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("متجهمة"),
            keywords: &["عبوسة", "متجهمة", "مقطبة الجبين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি মৰ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "জেশ\u{9cd}ব\u{9be}ৰ",
                "ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি মৰ\u{9be}",
                "ভ\u{9cd}ৰ\u{9c1}ক\u{9c1}টি মৰ\u{9be} মহিল\u{9be}",
                "মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kefsiz qadın"),
            keywords: &["jest", "kefsiz qadın", "qadın", "qaşbaqlı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("засмучаная жанчына"),
            keywords: &["жанчына", "жэст", "засмучаная"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("намръщена жена"),
            keywords: &[
                "мръщене",
                "намръщена жена",
                "обидена гримаса",
                "обидена жена",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} , মেয\u{9bc}ে ভ\u{9c1}র\u{9c1} ক\u{9c1}\u{981}চক\u{9be}নো"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ভ\u{9c1}র\u{9c1} ক\u{9c1}\u{981}চক\u{9be}নো",
                "মহিল\u{9be}",
                "মহিল\u{9be} , মেয\u{9bc}ে ভ\u{9c1}র\u{9c1} ক\u{9c1}\u{981}চক\u{9be}নো",
                "মেয\u{9bc}ে",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("namrštena žena"),
            keywords: &["gestikulacija \\ mrštenje", "namrštena žena", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona emmurriada"),
            keywords: &["arrufar", "celles", "dona emmurriada", "femení", "gest"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᏓᏁᎪᏳᎭ"),
            keywords: &["ᎠᎨᏯ", "ᎠᏎᏟᏙᏗ", "ᎤᏓᏁᎪᏳᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zamračená žena"),
            keywords: &["výraz", "zamračená žena", "zamračený", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn gwgu"),
            keywords: &["gwgu", "menyw", "menyw yn gwgu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("Utilfreds kvinde"),
            keywords: &[
                "Utilfreds kvinde",
                "kvinde",
                "kvinde med alvorlig mine",
                "panderynken",
                "utilfreds",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("missmutige Frau"),
            keywords: &["Frau", "Gesicht", "Stirn runzeln", "missmutige Frau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("συνοφρυωμένη"),
            keywords: &["γυναίκα", "θλίψη", "μορφασμός", "συνοφρυωμένη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman frowning"),
            keywords: &["frowning", "gesture", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer frunciendo el ceño"),
            keywords: &[
                "ceño",
                "fruncido",
                "gesto",
                "mujer",
                "mujer frunciendo el ceño",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mujer que frunce el seño"),
            keywords: &[
                "ceño",
                "fruncido",
                "gesto",
                "mujer",
                "mujer que frunce el seño",
                "persona",
                "triste",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mujer frunciendo el ceño"),
            keywords: &[
                "cara",
                "ceño",
                "fruncido",
                "mujer",
                "mujer frunciendo el ceño",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mujer frunciendo el ceño"),
            keywords: &[
                "ceño fruncido",
                "gesto",
                "mujer",
                "mujer frunciendo el ceño",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kulmu kortsutav naine"),
            keywords: &["ilme", "kulmu kortsutav naine", "kulmukortsutus", "naine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("kopeta zimurtzen ari den emakumea"),
            keywords: &[
                "emakume",
                "emakumezko",
                "keinu",
                "kopeta",
                "kopeta zimurtzen ari den emakumea",
                "zimurtu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن اخم می\u{200c}کند"),
            keywords: &[
                "اخمو",
                "زن ابرو در هم می\u{200c}کشد",
                "زن اخم می\u{200c}کند",
                "مرد عبوس",
                "ناخشنود",
                "ناراضی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("surullinen nainen"),
            keywords: &["harmi", "nainen", "suru", "surullinen nainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng nakasimangot"),
            keywords: &[
                "babae",
                "babaeng nakasimangot",
                "ekspresyon",
                "nakakunot-noo",
                "nakasimangot",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("illbrýnt kvinna"),
            keywords: &["illbrýnt", "kona", "kvinna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme fronçant les sourcils"),
            keywords: &[
                "femme",
                "femme fronçant les sourcils",
                "froncement",
                "geste",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "femme",
                "femme fronçant les sourcils",
                "froncement",
                "geste",
                "sourcils",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean le púic uirthi"),
            keywords: &[
                "ag cur grainc",
                "baineann",
                "bean",
                "bean ag cur grainc",
                "bean le púic uirthi",
                "cor",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach le drèin"),
            keywords: &[
                "boireannach",
                "boireannach le drèin",
                "drèin",
                "gluasad",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller enfurruñada"),
            keywords: &["cello", "enfurruñada", "muller", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ભવા\u{a82} ચડાવવા\u{a82}વાળી સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "ભવા\u{a82} ચડાવવા\u{a82}",
                "ભવા\u{a82} ચડાવવા\u{a82}વાળી સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai ɓacin rai"),
            keywords: &["karimcin", "mace", "mace mai ɓacin rai", "ɓacin rai"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מדוכדכת"),
            keywords: &["אישה", "אישה מדוכדכת", "זועפת", "מדוכאת", "עצובה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नाक–भौ\u{902} चढ\u{93c}ाई महिला"),
            keywords: &[
                "इशारा",
                "नाक–भौ\u{902} चढ\u{93c}ाई",
                "नाक–भौ\u{902} चढ\u{93c}ाई महिला",
                "महिला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("namrštena žena"),
            keywords: &["izraz lica", "mrštenje", "namrštena žena", "žena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("rosszalló nő"),
            keywords: &["gesztus", "nő", "rosszallás", "rosszalló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոժոռված կին"),
            keywords: &["խոժոռված", "կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita muka tidak senang"),
            keywords: &[
                "muka",
                "perempuan",
                "tidak senang",
                "wanita muka tidak senang",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-agbarụ ihu"),
            keywords: &["na-agbarụ", "nwanyị", "nwanyị na-agbarụ ihu", "ogbugbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona með skeifu"),
            keywords: &["fýla", "kona", "kona með skeifu", "leið", "skeifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna corrucciata"),
            keywords: &["corrucciata", "donna", "femmina", "gesto"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("しかめ面の女"),
            keywords: &["しかめっ面", "しかめ面の女", "しかめ顔", "女", "女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon sedhih"),
            keywords: &["isarat", "sedhih", "wong lanang", "wong wadon sedhih"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჭმუხნილი ქალი"),
            keywords: &["ჟესტი", "ქალი", "შეჭმუხნილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ашулы әйел"),
            keywords: &["ашулы", "ызалы", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde rynker panden"),
            keywords: &[
                "kvinde",
                "kvinde rynker panden",
                "rynke panden",
                "rynkede bryn",
                "rynket pande",
                "utilfreds",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}ម\u{17bb}ខក\u{17d2}រញ\u{17c9}\u{17bc}វ"),
            keywords: &[
                "ក\u{17d2}រញ\u{17c9}\u{17bc}វ",
                "ទ\u{17b9}កម\u{17bb}ខ",
                "នារ\u{17b8}",
                "នារ\u{17b8}ម\u{17bb}ខក\u{17d2}រញ\u{17c9}\u{17bc}វ",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಖ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ದ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಅಂಗಸನ\u{ccd}ನ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮುಖ ಗಂಟ\u{cbf}ಕ\u{ccd}ಕ\u{cbf}ದ ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಹುಬ\u{ccd}ಬು ಗಂಟ\u{cbf}ಕ\u{ccd}ಕು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("찌푸린 여자"),
            keywords: &["얼굴", "찌푸린 여자", "찌푸림", "찡그림"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल रागार जाता"),
            keywords: &["बायल", "बायल रागार जाता", "रागार जाता", "हावभाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кабагын бүркөгөн аял"),
            keywords: &["аял", "ишарат", "кабагын бүркөгөн аял", "кабагын чытуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("d’Stir fronzend Fra"),
            keywords: &["Fra", "Geste", "Stir", "d’Stir fronzend Fra", "fronzen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດໜ\u{ec9}າບ\u{eb6}\u{ec9}ງ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດໜ\u{ec9}າບ\u{eb6}\u{ec9}ງ",
                "ໜ\u{ec9}າບ\u{eb6}\u{ec9}ງ",
                "ໜ\u{ec9}າບ\u{eb9}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paniurusi moteris"),
            keywords: &["gestas", "moteris", "paniurusi"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("norūpējusies sieviete"),
            keywords: &["dusmoties", "norūpējusies sieviete", "sieviete", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine poururu"),
            keywords: &["poururu", "tohu ā-ringa", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("намуртена жена"),
            keywords: &["гест", "жена", "муртење", "намуртена жена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെറ\u{d4d}റി ച\u{d41}ളിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ"),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "നീരസം പ\u{d4d}രകടിപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന",
                "നെറ\u{d4d}റി ച\u{d41}ളിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дурамжхан эмэгтэй"),
            keywords: &[
                "дохио зангаа",
                "дурамжхан эмэгтэй",
                "хөмсөг зангидах",
                "эм",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("आठ\u{94d}या असल\u{947}ली महिला"),
            keywords: &[
                "आठ\u{94d}या",
                "आठ\u{94d}या असल\u{947}ली महिला",
                "महिला",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan berkerut dahi"),
            keywords: &[
                "gerak isyarat",
                "mengerut dahi",
                "perempuan",
                "perempuan berkerut dahi",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara titkerrah"),
            keywords: &["mara", "titkerrah", "ġesti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "မျက\u{103a}မ\u{103e}ောင\u{103a}ကြ\u{102f}တ\u{103a}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "ဝမ\u{103a}းနည\u{103a}းကြေက\u{103d}\u{1032}",
                "ဝမ\u{103a}းနည\u{103a}းကြေက\u{103d}\u{1032}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne som rynker brynene"),
            keywords: &[
                "kvinne",
                "kvinne som rynker brynene",
                "mimikk",
                "rynker pannen",
                "skeptisk",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आ\u{901}\u{901}खा तरिरह\u{947}की मान\u{94d}छ\u{947}"),
            keywords: &[
                "आ\u{901}\u{901}खा तरिरह\u{947}की मान\u{94d}छ\u{947}",
                "आ\u{901}खा तरिरह\u{947}की मान\u{94d}छ\u{947}",
                "इसारा",
                "छोरीमान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("fronsende vrouw"),
            keywords: &["frons", "fronsende vrouw", "uitdrukking", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne som rynkar bryna"),
            keywords: &[
                "kinne som rynkar bryna",
                "kvinne",
                "kvinne som rynkar bryna",
                "mimikk",
                "rynkar panna",
                "skeptisk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ମହ\u{b3f}ଳ\u{b3e} ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b3f}ବ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ଭ\u{b4d}ର\u{b41}କ\u{b41}ଞ\u{b4d}ଚନ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉ\u{a02}ਦੀ ਇਸਤਰੀ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਔਰਤ",
                "ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉ\u{a02}ਦੀ ਇਸਤਰੀ",
                "ਤਿਉੜੀ ਚੜ\u{a4d}ਹਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تیوری چڑھاندی زنانی"),
            keywords: &[
                "اشارہ",
                "تیوری چڑھاندی زنانی",
                "تیوری چڑھاندیاں ہوئیاں",
                "زنانی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé De Fraún Im Fes"),
            keywords: &[
                "Sain",
                "Skwíz Fes",
                "To Fraun",
                "Wúman",
                "Wúman Wé De Fraún Im Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zachmurzona kobieta"),
            keywords: &["kobieta", "zachmurzona kobieta", "zmarszczone brwi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه وروځې راغورځوي"),
            keywords: &["اشاره", "وروځې راغورځول", "ښځه", "ښځه وروځې راغورځوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher franzindo a sobrancelha"),
            keywords: &[
                "carrancuda",
                "desconfiada",
                "mulher",
                "mulher franzindo a sobrancelha",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher de sobrolho franzido"),
            keywords: &[
                "condenar",
                "desagrado",
                "franzir nariz",
                "homem",
                "mulher de sobrolho franzido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("llakisqa warmi"),
            keywords: &["gesto", "llakisqa", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie întristată"),
            keywords: &["femeie întristată", "gest", "supărare", "întristare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1218"),
            keywords: &["E10-1218"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нахмурившаяся женщина"),
            keywords: &[
                "женщина",
                "нахмурившаяся женщина",
                "расстроена",
                "хмурая",
                "человек",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore utishimye"),
            keywords: &["ikimenyetso", "umugore", "utishimye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت پريشان"),
            keywords: &["عورت پريشان", "پريشاني، اشارو، عورت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රවන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "අභ\u{dd2}න",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "රවන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "රැව\u{dd3}ම",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zamračená žena"),
            keywords: &["tvár", "zamračená", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska z namrščenim obrazom"),
            keywords: &[
                "dekle",
                "mrščiti se",
                "neodobravanje",
                "obraz",
                "obrazna mimika",
                "ženska",
                "ženska z namrščenim obrazom",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag wajiga kaduudaya"),
            keywords: &[
                "meedaar",
                "naag",
                "naag wajiga kaduudaya",
                "waji kaduudidda",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua e vrenjtur"),
            keywords: &["e vrenjtur", "gjest", "grua", "grua e vrenjtur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("намрштена жена"),
            keywords: &["жена", "мрштење", "намрштена жена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("namrštena žena"),
            keywords: &["mrštenje", "namrštena žena", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sur kvinna"),
            keywords: &["gest", "kvinna", "sur"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke anayekunja kipaji cha uso"),
            keywords: &[
                "chukizwa",
                "ishara",
                "mwanamke anayekunja kipaji cha uso",
                "mwanamume",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வருத\u{bcd}தம\u{bbe}ன பெண\u{bcd}"),
            keywords: &[
                "அழுகை",
                "கவலை",
                "பெண\u{bcd}",
                "வருத\u{bcd}தம\u{bbe}ன பெண\u{bcd}",
                "வருத\u{bcd}தம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముఖం చ\u{c3f}ట\u{c4d}ల\u{c3f}ంచ\u{c3f}న స\u{c4d}త\u{c4d}ర\u{c40}"),
            keywords: &[
                "మహ\u{c3f}ళ",
                "ముఖం చ\u{c3f}ట\u{c4d}ల\u{c3f}ంచడం",
                "ముఖం చ\u{c3f}ట\u{c4d}ల\u{c3f}ంచ\u{c3f}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "సంజ\u{c4d}ఞ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки қавоқ андохта истодааст"),
            keywords: &[
                "зан",
                "зане, ки қавоқ андохта истодааст",
                "имову ишора",
                "қавоқандозӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งหน\u{e49}าบ\u{e36}\u{e49}ง"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งหน\u{e49}าบ\u{e36}\u{e49}ง",
                "หน\u{e49}าบ\u{e36}\u{e49}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çytylýan zenan"),
            keywords: &["zenan", "çytylmak", "çytylýan zenan", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine matamamahi"),
            keywords: &["fefine matamamahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("somurtan kadın"),
            keywords: &["bayan", "kadın", "mimik", "somurtan kadın", "somurtma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوشۇمىسىنى تۈرگەن ئايال"),
            keywords: &["ئايال", "ئىشارە", "قوشۇما", "قوشۇمىسىنى تۈرگەن ئايال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("похмура жінка"),
            keywords: &["жінка", "засмучена", "похмура жінка", "розчарування"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("گھورتی ہوئی عورت"),
            keywords: &[
                "عورت",
                "ناراضگی ظاہر کرتی ہوئی عورت",
                "گھورتی ہوئی عورت",
                "گھورنا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("xo‘mraygan ayol"),
            keywords: &["ayol", "xoʻmrayish", "xo‘mraygan ayol", "yuz ifodasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ cau mày"),
            keywords: &["cau mày", "cử chỉ", "người phụ nữ cau mày", "phụ nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen aj-yéen"),
            keywords: &["aj-yéen", "jigéen", "liyaar"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elifinge iintshiya"),
            keywords: &[
                "ibhinqa",
                "ibhinqa elifinge iintshiya",
                "jekula",
                "ukufinga iintshiya",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń fajúro"),
            keywords: &[
                "fífajúro",
                "fọwọ\u{301}júwè",
                "obìnrin",
                "obìnrin tí ń fajúro",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("皺眉嘅女人"),
            keywords: &["女", "皺眉", "皺眉嘅女人", "表情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("皱眉嘅女人"),
            keywords: &["女", "皱眉", "皱眉嘅女人", "表情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("皱眉女"),
            keywords: &["不开心", "女", "皱眉", "皱眉女"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生皺眉"),
            keywords: &["女", "女生皺眉", "皺眉", "表情"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女子皺眉"),
            keywords: &["女人", "女子皺眉", "皺眉", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame ohwaqabele"),
            keywords: &["owesimame", "owesimame ohwaqabele", "ukuhwaqabala"],
        },
    ],
};
#[doc = "🙍🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_FROWNING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F64D 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman frowning: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏻\u{200d}♀",
        codepoint: "1F64D 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman frowning: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_FROWNING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F64D 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman frowning: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏼\u{200d}♀",
        codepoint: "1F64D 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman frowning: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_FROWNING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F64D 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman frowning: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏽\u{200d}♀",
        codepoint: "1F64D 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman frowning: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_FROWNING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F64D 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman frowning: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏾\u{200d}♀",
        codepoint: "1F64D 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman frowning: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙍🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_FROWNING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙍🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F64D 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman frowning: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙍🏿\u{200d}♀",
        codepoint: "1F64D 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman frowning: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎"]
pub const PERSON_POUTING: crate::Emoji = crate::Emoji {
    glyph: "🙎",
    codepoint: "1F64E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person pouting",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dikbek persoon"),
            keywords: &["dikbek", "dikbek persoon", "dikbekpersoon", "gebaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሁኔታው ያልጣመው ሰው"),
            keywords: &["ሁኔታው ያልጣመው ሰው", "ወሲብ የጠማት", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}شخص متجهم"),
            keywords: &["إشارة", "شخص", "\u{202b}شخص متجهم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ভঙ\u{9cd}গিম\u{9be}",
                "ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be}",
                "ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be} ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("acıq edən adam"),
            keywords: &["acıq edən adam", "acıq etmək", "jest"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("надзьмуты чалавек"),
            keywords: &["жэст", "крыўда", "надзьмуты", "надзьмуты чалавек"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Нацупен човек"),
            keywords: &["Нацупен човек", "жест", "нацупен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বিস\u{9cd}ফ\u{9c1}রিত ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "বিস\u{9cd}ফ\u{9be}রিত চোখ",
                "বিস\u{9cd}ফ\u{9c1}রিত ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nadurena osoba"),
            keywords: &["durenje", "gestikulacija", "izraz lica", "nadurena osoba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona enutjada"),
            keywords: &["enuig", "persona", "persona enutjada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᏇᏟᎬ"),
            keywords: &["ᎠᏎᏟᏙᎯ", "ᎤᏇᏟᎬ", "ᏴᏫ ᎤᏇᏟᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("podrážděná osoba"),
            keywords: &["podrážděná osoba", "podráždění", "výraz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn pwdu"),
            keywords: &["person yn pwdu", "pwdu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("surmulende person"),
            keywords: &["gestus", "surmule", "surmulende person"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schmollende Person"),
            keywords: &["Schmollen", "schmollende Person"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσουφιασμένο άτομο"),
            keywords: &["κίνηση", "κατσουφιασμένο άτομο", "μορφασμός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person pouting"),
            keywords: &["gesture", "person pouting", "pouting"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona haciendo pucheros"),
            keywords: &["gesto", "persona", "persona haciendo pucheros", "pucheros"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "enojada",
                "mujer",
                "persona",
                "persona haciendo pucheros",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona haciendo pucheros"),
            keywords: &["gesto", "persona", "persona haciendo pucheros", "pucheros"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("persona enojada"),
            keywords: &["enojada", "gesto", "persona enojada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mossitav inimene"),
            keywords: &["ilme", "mossis", "mossitav", "mossitav inimene"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona muturtua"),
            keywords: &["keinu", "muturtu", "pertsona muturtua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آدم ناراضی"),
            keywords: &["آدم ناراضی", "اخم", "جمع کردن لب", "ناراضی", "ژست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mököttävä henkilö"),
            keywords: &["ele", "mököttävä", "mököttävä henkilö"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong naka-pout"),
            keywords: &[
                "ekspresyon",
                "expression",
                "naka-pout",
                "pout",
                "taong naka-pout",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur við gron"),
            keywords: &["fólk", "gron", "persónur", "persónur við gron"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne qui boude"),
            keywords: &["bouder", "geste", "moue", "personne qui boude"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["baboune", "bouder", "geste", "moue", "personne qui boude"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine le puisín air"),
            keywords: &[
                "duine",
                "duine le phus orthu",
                "duine le puisín air",
                "duine pusach",
                "gotha",
                "pus",
                "smut",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach le bus air"),
            keywords: &["bus", "busach", "gluasad", "neach le bus air"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa furiosa"),
            keywords: &["furioso", "ira", "persoa furiosa", "rabia", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિસાતી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "રિસાતી વ\u{acd}યક\u{acd}તિ",
                "રિસાવ\u{ac1}\u{a82}",
                "વ\u{acd}યક\u{acd}તિ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai nunawa ɓacin zuciya"),
            keywords: &["karimci", "mutum mai nunawa ɓacin zuciya", "ɓacin zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה זועפת"),
            keywords: &["אישה זועפת", "זועפת", "כועסת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("खीझा व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "खीझ",
                "खीझा व\u{94d}यक\u{94d}ति",
                "व\u{94d}यक\u{94d}ति",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba koja se duri"),
            keywords: &["durenje", "izraz lica", "osoba koja se duri"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("duzzogó ember"),
            keywords: &["duzzogás", "duzzogó ember"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դժգոհ անձ"),
            keywords: &["դժգոհ", "դժգոհ անձ", "ժեստ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang tidak senang"),
            keywords: &["cemberut", "gerakan", "orang tidak senang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-asọpụta ọnụ"),
            keywords: &["na-asọpụta ọnụ", "ogbugbu", "onye na-asọpụta ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("manneskja í fýlu"),
            keywords: &["fýlusvipur", "manneskja í fýlu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona imbronciata"),
            keywords: &["gesto", "imbronciata", "persona"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("不機嫌な人"),
            keywords: &["ぷんぷん", "不機嫌", "不機嫌な人", "人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong mbesengut"),
            keywords: &["isarat", "mbesengut", "wong mbesengut"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაბერილი პიროვნება"),
            keywords: &["გაბერილი", "გაბერილი პიროვნება", "ჟესტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("беті бұртию"),
            keywords: &["беті бүртию", "беті бұртию", "қимыл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("surmulende person"),
            keywords: &["gestus", "surmule", "surmulende person"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងម\u{17bd}រម\u{17c9}ៅ"),
            keywords: &[
                "ខ\u{17b9}ង",
                "មន\u{17bb}ស\u{17d2}ស",
                "មន\u{17bb}ស\u{17d2}សក\u{17c6}ព\u{17bb}ងម\u{17bd}រម\u{17c9}ៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೊಂಡುತನದ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &["ಮಗುವ\u{cbf}ನ ಮೊಂಡತನ", "ಮೊಂಡುತನದ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뾰로통한 사람"),
            keywords: &["뾰로통한 사람", "뿌루퉁한 사람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती पावट करता"),
            keywords: &["पावट करता", "व\u{94d}यक\u{94d}ती पावट करता", "हावभाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тултуюп таарынган адам"),
            keywords: &["маанай", "таарын", "тултуй", "тултуюп таарынган адам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("motzend Persoun"),
            keywords: &["Geste", "motzen", "motzend Persoun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນເຮ\u{eb1}ດໜ\u{ec9}າບ\u{ecd}\u{ec8}ພ\u{ecd}ໃຈ"),
            keywords: &[
                "ຄ\u{ebb}ນເຮ\u{eb1}ດໜ\u{ec9}າບ\u{ecd}\u{ec8}ພ\u{ecd}ໃຈ",
                "ຄຽດ",
                "ງອນ",
                "ບ\u{ecd}\u{ec8}ພ\u{ecd}ໃຈ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susiraukęs žmogus"),
            keywords: &["gestas", "raukymasis", "susiraukęs žmogus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sabozies cilvēks"),
            keywords: &["sabozies", "sabozies cilvēks", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata tupere"),
            keywords: &["tangata tupere", "tohu ā-ringa", "tupere"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("налутен човек"),
            keywords: &["гест", "налутен", "налутен човек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ദേഷ\u{d4d}യപ\u{d4d}പെട\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}ക\u{d41}ക",
                "ദേഷ\u{d4d}യപ\u{d4d}പെട\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി",
                "ദേഷ\u{d4d}യപ\u{d4d}പെട\u{d41}ന\u{d4d}ന\u{d41}",
                "വ\u{d4d}യക\u{d4d}തി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гайхсан хүн"),
            keywords: &["гайхах", "гайхсан хүн", "хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("रागीष\u{94d}ट व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "अस\u{902}तोष",
                "अस\u{902}तोष दाखवणारी व\u{94d}यक\u{94d}ती",
                "रागीष\u{94d}ट व\u{94d}यक\u{94d}ती",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang mencebik"),
            keywords: &["isyarat", "mulut muncung", "orang mencebik"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tisporġi x-xofftejn"),
            keywords: &[
                "jisporġi x-xofftejn",
                "persuna tisporġi x-xofftejn",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{1030}တ\u{1030}တ\u{1030} လ\u{1030}"),
            keywords: &[
                "စ\u{1030}တ\u{1030}တ\u{1030} လ\u{1030}",
                "အမ\u{1030}အယျာ စ\u{1030}တ\u{1030}တ\u{1030} လျ\u{1030} စ\u{1030}တ\u{1030}တ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("furter"),
            keywords: &["furter", "furting", "mimikk", "surmuling"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ख फ\u{941}लाइरह\u{947}को व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "भाव प\u{94d}रदर\u{94d}शन",
                "म\u{941}ख फ\u{941}लाइरह\u{947}को व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pruilend persoon"),
            keywords: &["pruilen", "pruilend persoon", "uitdrukking"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("furtar"),
            keywords: &["furtar", "furter", "furting", "mimikk", "surmuling"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}",
                "ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਰਾਜ\u{a3c}ਗੀ ਜਾਹਰ ਕਰਦਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਨਰਾਜ\u{a3c}ਗੀ ਜਾਹਰ ਕਰਦਾ ਵਿਅਕਤੀ",
                "ਨਰਾਜ\u{a3c}\u{a3c}ਗੀ",
                "ਵਿਅਕਤੀ",
                "ਵਿਅਕਤੀ ਨਰਾਜ\u{a3c} ਹ\u{a4b} ਰਿਹਾ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لٹکیا ہوئیا بندہ"),
            keywords: &["اشارہ", "لٹکیا ہوئیا بندہ", "منہ بسورنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé De Mék Lọ\u{301}ng Fes"),
            keywords: &[
                "Pẹ\u{301}sin Wé De Mék Lọ\u{301}ng Fes",
                "Sain",
                "To Mék Lọ\u{301}ng Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadąsana osoba"),
            keywords: &[
                "buźka",
                "kapryśna",
                "mina",
                "nadąsana osoba",
                "niezadowolona",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص تندی کوت کوي"),
            keywords: &["اشاره", "تندی کوت کول", "شخص تندی کوت کوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa fazendo bico"),
            keywords: &["fazendo bico", "gesto", "pessoa", "pessoa fazendo bico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa amuada"),
            keywords: &["gesto", "mal-humorado", "pessoa amuada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phiñachisqa runa"),
            keywords: &["gesto", "phiñachisqa runa", "piñachisqa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană bosumflată"),
            keywords: &["expresie facială", "persoană bosumflată", "îmbufnare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-914"),
            keywords: &["E10-914"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обиженный человек"),
            keywords: &["недовольство", "обида", "обиженный", "обиженный человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu uhakana"),
            keywords: &["ikimenyetso", "umuntu uhakana", "uwarakaye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو ناپسند ڪندي"),
            keywords: &["اشارو، ناپسند", "ماڻهو ناپسند ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අමන\u{dcf}පය දක\u{dca}වන ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "අභ\u{dd2}න",
                "අමන\u{dcf}පය දක\u{dca}වන ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "අමන\u{dcf}පය දැක\u{dca}ව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("podráždený človek"),
            keywords: &["podráždený človek", "trucujúca", "výraz"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki kuha mulo"),
            keywords: &["gesta", "kujanje", "oseba, ki kuha mulo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bushin qaniinidda"),
            keywords: &["bushin qaniinidda", "meedaar", "qof bushinta qaniinaya"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri i pakënaqur"),
            keywords: &["gjest", "i pakënaqur", "njeri i pakënaqur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("надурена особа"),
            keywords: &["дурeњe", "крeтање", "надурена особа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nadurena osoba"),
            keywords: &["durenje", "kretanje", "nadurena osoba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("plutande person"),
            keywords: &["person som plutar", "plutande person", "plutar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu aliyebibidua midomo"),
            keywords: &["bibidua midomo", "ishara", "mtu aliyebibidua midomo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோபம\u{bbe}க இருப\u{bcd}பவர\u{bcd}"),
            keywords: &[
                "கோபத\u{bcd}தைக\u{bcd} க\u{bbe}ட\u{bcd}டுதல\u{bcd}",
                "கோபம\u{bbe}க இருப\u{bcd}பவர\u{bcd}",
                "கோபம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అల\u{c3f}గ\u{c3f}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "అలక",
                "అల\u{c3f}గ\u{c3f}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки лабҳояшро каҷ карда истодааст"),
            keywords: &[
                "имову ишора",
                "каҷкунии лаб",
                "шахсе, ки лабҳояшро каҷ карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปากย\u{e37}\u{e48}น"),
            keywords: &["งอน", "ปากย\u{e37}\u{e48}น", "หน\u{e49}า", "โกรธ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gamaşyk adam"),
            keywords: &["gamaşyk", "gamaşyk adam", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha mataʻita"),
            keywords: &["tokotaha mataʻita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("darılma"),
            keywords: &["darılan kişi", "darılma", "hareket", "kişi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھومايغان كىشى"),
            keywords: &["ئىشارە", "ھومايغان كىشى", "ھومىيىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина, що дується"),
            keywords: &["жест", "злий", "людина, що дується"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نا شاد شخص"),
            keywords: &["اشارہ", "نا شاد", "نا شاد شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("norozi odam"),
            keywords: &["imo-ishora", "norozi", "norozi odam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đang bĩu môi"),
            keywords: &["bĩu môi", "cử chỉ", "người đang bĩu môi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit kuy puucatu"),
            keywords: &["liyaar", "nit kuy puucatu", "puucatu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu otsalisa umlomo"),
            keywords: &["jekula", "ukutsolisa umlomo", "umntu otsalisa umlomo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni Yahọn sita"),
            keywords: &["fífowọ\u{301}júwè", "ṣíṣù ètè síta", "Ẹni Yahọn sita"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("撅嘴嘅人"),
            keywords: &["撅嘴", "撅嘴嘅人", "表情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("撅嘴嘅人"),
            keywords: &["撅嘴", "撅嘴嘅人", "表情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("撅嘴"),
            keywords: &["不开心", "噘嘴", "撅嘴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("生氣的人"),
            keywords: &["生氣", "生氣的人"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("撅嘴嘅人"),
            keywords: &["撅嘴嘅人", "撅嘴嘅人｜嬲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu odangele"),
            keywords: &["ukudangala", "umuntu odangele"],
        },
    ],
};
#[doc = "🙎🏻"]
pub const PERSON_POUTING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏻",
    codepoint: "1F64E 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person pouting: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙎🏼"]
pub const PERSON_POUTING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏼",
    codepoint: "1F64E 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person pouting: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙎🏽"]
pub const PERSON_POUTING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏽",
    codepoint: "1F64E 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person pouting: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙎🏾"]
pub const PERSON_POUTING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏾",
    codepoint: "1F64E 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person pouting: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙎🏿"]
pub const PERSON_POUTING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏿",
    codepoint: "1F64E 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person pouting: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙎\u{200d}♂\u{fe0f}"]
pub const MAN_POUTING: crate::Emoji = crate::Emoji {
    glyph: "🙎\u{200d}♂\u{fe0f}",
    codepoint: "1F64E 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man pouting",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎\u{200d}♂",
        codepoint: "1F64E 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man pouting",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dikbek man"),
            keywords: &["dikbek", "dikbek man", "gebaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ማለክለክ"),
            keywords: &["ማለክለክ", "ወንድ", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل عابس"),
            keywords: &["رجل عابس", "عبوس", "متجهم", "مقطب الجبين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ভঙ\u{9cd}গিম\u{9be}",
                "ম\u{9c1}খ ওফন\u{9cd}দোৱ\u{9be}",
                "ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("acıqlı kişi"),
            keywords: &["acıqlı", "jest", "kişi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("надзьмуты мужчына"),
            keywords: &["жэст", "крыўда", "мужчына", "надзьмуты"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("нацупен мъж"),
            keywords: &["гримаса", "намусен мъж", "нацупен мъж", "недоволна гримаса"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ , ছেলে প\u{9be}উটিং"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ছেলে",
                "প\u{9be}উটিং",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ , ছেলে প\u{9be}উটিং",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("naduren muškarac"),
            keywords: &["durenje", "gestikulacija", "muškarac", "naduren muškarac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home enutjat"),
            keywords: &["enuig", "gest", "home", "home enutjat", "masculí"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏇᏟᎬ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏎᏟᏙᎯ", "ᎤᏇᏟᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("podrážděný muž"),
            keywords: &["muž", "podrážděný", "výraz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn pwdu"),
            keywords: &["dyn", "dyn yn pwdu", "pwdu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("surmulende mand"),
            keywords: &["mand", "sur", "surmule", "surmulende mand", "utilfreds"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schmollender Mann"),
            keywords: &["Gesicht", "Mann", "schmollen", "schmollender Mann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσουφιασμένος άντρας"),
            keywords: &[
                "άντρας",
                "απογοήτευση",
                "θυμός",
                "κατσουφιασμένος άντρας",
                "μορφασμός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man pouting"),
            keywords: &["gesture", "man", "pouting"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre haciendo pucheros"),
            keywords: &["gesto", "hombre", "hombre haciendo pucheros", "pucheros"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("hombre enojado"),
            keywords: &["enojado", "gesto", "hombre"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mossitav mees"),
            keywords: &["ilme", "mees", "mossis", "mossitav"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon muturtua"),
            keywords: &["gizon", "gizon muturtua", "gizonezko", "keinu", "muturtu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد اخم\u{200c}وتخم می\u{200c}کند"),
            keywords: &[
                "ابرو در هم کشیدن",
                "اخم و\u{200c} تخم",
                "اخمو",
                "ترش\u{200c}رویی",
                "عبوس",
                "لب\u{200c}ولوچه آویزان",
                "مرد اخم\u{200c}وتخم می\u{200c}کند",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mököttävä mies"),
            keywords: &["harmi", "mies", "mököttävä mies", "mökötys"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking nakanguso"),
            keywords: &["lalaki", "lalaking nakanguso", "nakalabi", "nakanguso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður við gron"),
            keywords: &["gron", "maður", "maður við gron"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme qui boude"),
            keywords: &["boude", "geste", "homme", "homme qui boude"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "baboune",
                "boude",
                "geste",
                "homme",
                "homme qui boude",
                "moue",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear le puisín air"),
            keywords: &[
                "cor",
                "fear",
                "fear le puisín air",
                "fear le pus",
                "fearann",
                "pus",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine le bus air"),
            keywords: &[
                "bus",
                "busach",
                "duine",
                "duine le bus air",
                "fear",
                "fireannach",
                "gluasad",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home furioso"),
            keywords: &["furioso", "home", "ira", "rabia", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિસાય\u{ac7}લો પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "પ\u{ac1}ર\u{ac1}ષ",
                "રિસાય\u{ac7}લો પ\u{ac1}ર\u{ac1}ષ",
                "રિસાવ\u{ac1}\u{a82}",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai ɓacin zuciya"),
            keywords: &[
                "karimcin",
                "mutum",
                "mutum mai ɓacin zuciya",
                "ɓacin zuciya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר מבואס"),
            keywords: &[
                "אוף",
                "איש",
                "גבר",
                "גבר מבואס",
                "מחמיץ פנים",
                "מעקם את האף",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("होठ निकाला ह\u{941}आ प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "इशारा",
                "प\u{941}र\u{941}ष",
                "होठ निकाला",
                "होठ निकाला ह\u{941}आ प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nadureni muškarac"),
            keywords: &["durenje", "izraz lica", "muškarac", "nadureni muškarac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("duzzogó férfi"),
            keywords: &["duzzogás", "duzzogó", "férfi", "gesztus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խռոված տղամարդ"),
            keywords: &["խռոված", "մարդ", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria tidak senang"),
            keywords: &["bibir", "laki-laki", "pria tidak senang", "tidak senang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-asọpụta ọnụ"),
            keywords: &["na-asọpụta ọnụ", "nwoke", "nwoke na-asọpụta ọnụ", "ogbugbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður í fýlu"),
            keywords: &["fýla", "fýlusvipur", "karl", "maður í fýlu", "súr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo imbronciato"),
            keywords: &["gesto", "imbronciato", "maschio", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("不機嫌な男"),
            keywords: &["ぷんぷん", "不機嫌", "不機嫌な男", "男", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang mbesengut"),
            keywords: &[
                "isarat",
                "mbesengut",
                "wong lanang",
                "wong lanang mbesengut",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაბუტული კაცი"),
            keywords: &["გაბუტული", "კაცი", "ჟესტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ренжулі ер"),
            keywords: &["ер", "ренжулі", "ренжіген"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand surmuler"),
            keywords: &["mand", "mand surmuler", "sur", "surmule", "utilfreds"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសម\u{17bd}រម\u{17c9}ៅ"),
            keywords: &[
                "ទ\u{17b9}កម\u{17bb}ខ",
                "ប\u{17bb}រស",
                "ប\u{17bb}រសម\u{17bd}រម\u{17c9}ៅ",
                "ប\u{17d2}រ\u{17bb}ស",
                "ម\u{17bd}រម\u{17c9}ៅ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ಡುಕು ಮುಖದ ಪುರುಷ"),
            keywords: &[
                "ಅಂಗ ಸನ\u{ccd}ನ\u{cc6}",
                "ಪುರುಷ",
                "ಸ\u{cbf}ಡುಕು ಮುಖ",
                "ಸ\u{cbf}ಡುಕು ಮುಖದ ಪುರುಷ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뾰로통한 남자"),
            keywords: &[
                "불만",
                "뾰로통",
                "뾰로통한 남자",
                "뾰로통한 여자",
                "뿌루퉁",
                "심통",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो पावट करता"),
            keywords: &["दादलो", "दादलो पावट करता", "पावट करता", "हावभाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тултуюп таарынган эркек"),
            keywords: &["ишарат", "тултуюп таарынган эркек", "тултуюу", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("motzende Mann"),
            keywords: &["Geste", "Mann", "motzend", "motzende Mann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເບະສ\u{ebb}ບ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເບະສ\u{ebb}ບ",
                "ເບະສ\u{ebb}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susiraukęs vyras"),
            keywords: &["gestas", "susiraukęs", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sabozies vīrietis"),
            keywords: &["bēdāties", "sabozies vīrietis", "vīrietis", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tupere"),
            keywords: &["tohu ā-ringa", "tupere", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("налутен маж"),
            keywords: &["гест", "лутење", "маж", "налутен маж"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}കൽ",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урвагар эрэгтэй"),
            keywords: &["дохио зангаа", "урвагар эрэгтэй", "урвайх", "эр", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अस\u{902}तोष दाखवणारा प\u{941}र\u{941}ष"),
            keywords: &[
                "अस\u{902}तोष",
                "अस\u{902}तोष दाखवणारा प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki mencebik"),
            keywords: &[
                "gerak isyarat",
                "lelaki",
                "lelaki mencebik",
                "memuncungkan mulut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jisporġi x-xofftejn"),
            keywords: &[
                "jisporġi x-xofftejn",
                "raġel",
                "raġel jisporġi x-xofftejn",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "စ\u{102d}တ\u{103a}တ\u{102d}\u{102f}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "စ\u{102d}တ\u{103a}တ\u{102d}\u{102f}",
                "စ\u{102d}တ\u{103a}တ\u{102d}\u{102f}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann som furter"),
            keywords: &["furting", "mann", "mann som furter", "mimikk", "surmuling"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("थ\u{941}त\u{941}नो त\u{947}र\u{94d}साइरह\u{947}को छोरोमान\u{94d}छ\u{947}"),
            keywords: &[
                "इसारा",
                "छोरामान\u{94d}छ\u{947}",
                "थ\u{941}त\u{941}नो त\u{947}र\u{94d}साइरह\u{947}को",
                "थ\u{941}त\u{941}नो त\u{947}र\u{94d}साइरह\u{947}को छोरोमान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pruilende man"),
            keywords: &["man", "pruilen", "pruilende man", "uitdrukking"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann som furtar"),
            keywords: &["furting", "mann", "mann som furtar", "mimikk", "surmuling"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}",
                "ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ ਕ\u{a71}ਢਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ ਕ\u{a71}ਢਣਾ",
                "ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ ਕ\u{a71}ਢਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ بسوردا بندہ"),
            keywords: &["اشارہ", "بندہ", "منہ بسوردا بندہ", "منہ بسورنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé De Mék Lọ\u{301}ng Fes"),
            keywords: &[
                "Man",
                "Man Wé De Mék Lọ\u{301}ng Fes",
                "Sain",
                "To Mék Lọ\u{301}ng Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadąsany mężczyzna"),
            keywords: &["mężczyzna", "nadąsany", "niezadowolony"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی تندی کوت کوي"),
            keywords: &["اشاره", "تندی کوت کول", "سړی", "سړی تندی کوت کوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem fazendo bico"),
            keywords: &["bico", "cara feia", "homem", "homem fazendo bico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem amuado"),
            keywords: &["beicinho", "gesto", "homem", "homem amuado"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phiñachisqa tata"),
            keywords: &["gesto", "phiñachisqa tata", "piñachisqa", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat bosumflat"),
            keywords: &[
                "bosumflare",
                "bărbat",
                "bărbat bosumflat",
                "gest",
                "îmbufnare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1221"),
            keywords: &["E10-1221"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обиженный мужчина"),
            keywords: &["недовольство", "обида", "обиженный", "обиженный мужчина"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo urakaye"),
            keywords: &["ikimenyetso", "umugabo", "urakaye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد ناپسند ڪندي"),
            keywords: &["اشارو، ناپسند، مرد", "مرد ناپسند ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට උල\u{dca}කරන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "අභ\u{dd2}න",
                "කට උල\u{dca}කරන ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "කට උල\u{dca}ක\u{dd2}ර\u{dd3}ම",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("podráždený muž"),
            keywords: &["muž", "podráždený muž", "trucujúci", "výraz"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški, ki kuha mulo"),
            keywords: &[
                "fant",
                "kujanje",
                "moški",
                "moški, ki kuha mulo",
                "obrazna mimika",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin bushinta qaniinaya"),
            keywords: &[
                "bushin qaniinidda",
                "meedaar",
                "nin",
                "nin bushinta qaniinaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë i pakënaqur"),
            keywords: &["burrë", "burrë i pakënaqur", "gjest", "var buzët"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("надурен мушкарац"),
            keywords: &["дурење", "мушкарац", "надурен мушкарац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("naduren muškarac"),
            keywords: &["durenje", "muškarac", "naduren muškarac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("plutande man"),
            keywords: &["man", "plutande man", "plutar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume anayebibidua midomo"),
            keywords: &["bibidua midomo", "ishara", "mwanamume anayebibidua midomo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோபம\u{bbe}ன ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "ஆத\u{bcd}திரம\u{bcd}",
                "கோபம\u{bbe}ன ஆண\u{bcd}",
                "கோபம\u{bcd}",
                "சினம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}హం ముడుచుకున\u{c4d}న పురుషుడు"),
            keywords: &[
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "మ\u{c4a}హం ముడుచుకున\u{c4d}న పురుషుడు",
                "మ\u{c4a}హం ముడుచుక\u{c4b}వడం",
                "సంజ\u{c4d}ఞ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки лабҳояшро каҷ карда истодааст"),
            keywords: &[
                "имову ишора",
                "каҷкунии лаб",
                "мард",
                "марде, ки лабҳояшро каҷ карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายโกรธ"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายโกรธ",
                "โกรธ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gamaşyk erkek"),
            keywords: &["erkek", "gamaşyk", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata mataʻita"),
            keywords: &["tangata mataʻita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("darılan erkek"),
            keywords: &["adam", "darılan erkek", "darılma", "erkek", "mimik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھومايغان ئەر"),
            keywords: &["ئىشارە", "ئەر", "ھومايغان ئەر", "ھومىيىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік, що дується"),
            keywords: &["злість", "сердиться", "чоловік", "чоловік, що дується"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ بسورتا ہوا مرد"),
            keywords: &[
                "اداسی ظاہر کرنا",
                "مرد",
                "منھ بسورنا",
                "منہ بسورتا ہوا مرد",
                "ہونٹ دبانا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("arazlagan erkak"),
            keywords: &["arazlagan", "erkak", "yuz ifodasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông bĩu môi"),
            keywords: &["bĩu môi", "cử chỉ", "nam", "người đàn ông bĩu môi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor puucatu"),
            keywords: &["góor", "liyaar", "puucatu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda etsolisa umlomo"),
            keywords: &[
                "indoda",
                "indoda etsolisa umlomo",
                "jekula",
                "ukutsolisa umlomo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tí ń ṣíṣù ètè síta"),
            keywords: &[
                "fowọ\u{301}júwè",
                "ṣíṣù ètè síta",
                "ọkùnrin",
                "ọkùnrin tí ń ṣíṣù ètè síta",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("撅嘴嘅男人"),
            keywords: &["撅嘴", "撅嘴嘅男人", "男", "表情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("撅嘴嘅男人"),
            keywords: &["撅嘴", "撅嘴嘅男人", "男", "表情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("撅嘴男"),
            keywords: &["不开心", "噘嘴", "撅嘴男", "男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生噘嘴"),
            keywords: &["噘嘴", "生氣", "男生噘嘴"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男子噘嘴"),
            keywords: &["撅嘴", "男人", "男子噘嘴", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda edangele"),
            keywords: &["indoda", "indoda edangele", "ukudangala"],
        },
    ],
};
#[doc = "🙎🏻\u{200d}♂\u{fe0f}"]
pub const MAN_POUTING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F64E 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man pouting: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏻\u{200d}♂",
        codepoint: "1F64E 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man pouting: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏼\u{200d}♂\u{fe0f}"]
pub const MAN_POUTING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F64E 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man pouting: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏼\u{200d}♂",
        codepoint: "1F64E 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man pouting: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏽\u{200d}♂\u{fe0f}"]
pub const MAN_POUTING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F64E 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man pouting: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏽\u{200d}♂",
        codepoint: "1F64E 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man pouting: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏾\u{200d}♂\u{fe0f}"]
pub const MAN_POUTING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F64E 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man pouting: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏾\u{200d}♂",
        codepoint: "1F64E 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man pouting: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏿\u{200d}♂\u{fe0f}"]
pub const MAN_POUTING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F64E 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man pouting: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏿\u{200d}♂",
        codepoint: "1F64E 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man pouting: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎\u{200d}♀\u{fe0f}"]
pub const WOMAN_POUTING: crate::Emoji = crate::Emoji {
    glyph: "🙎\u{200d}♀\u{fe0f}",
    codepoint: "1F64E 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman pouting",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎\u{200d}♀",
        codepoint: "1F64E 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman pouting",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dikbek vrou"),
            keywords: &["dikbek", "dikbek vrou", "gebaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ማለክለክ"),
            keywords: &["ማለክለክ", "ሴት", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة عابسة"),
            keywords: &["سيدة عابسة", "عبوسة", "متجهمة", "مقطبة الجبين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "ভঙ\u{9cd}গিম\u{9be}",
                "মহিল\u{9be}",
                "ম\u{9c1}খ ওফন\u{9cd}দোৱ\u{9be}",
                "ম\u{9c1}খ ওফন\u{9cd}দোৱ\u{9be} মহিল\u{9be}",
                "ম\u{9c1}খ ফ\u{9c1}লোৱ\u{9be} মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("acıqlı qadın"),
            keywords: &["acıqlı", "jest", "qadın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("надзьмутая жанчына"),
            keywords: &["жанчына", "жэст", "крыўда", "надзьмутая"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("нацупена жена"),
            keywords: &[
                "гримаса",
                "намусена жена",
                "нацупена жена",
                "недоволна гримаса",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} , মেয\u{9bc}ে প\u{9be}উটিং"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "প\u{9be}উটিং",
                "মহিল\u{9be}",
                "মহিল\u{9be} , মেয\u{9bc}ে প\u{9be}উটিং",
                "মেয\u{9bc}ে",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nadurena žena"),
            keywords: &["durenje", "gestikulacija", "nadurena žena", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona enutjada"),
            keywords: &["dona", "dona enutjada", "enuig", "femení", "gest"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᏇᏟᎬ"),
            keywords: &["ᎠᎨᏯ", "ᎠᏌᏟᏙᎯ", "ᎤᏇᏟᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("podrážděná žena"),
            keywords: &["podrážděná žena", "podrážděný", "výraz", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn pwdu"),
            keywords: &["menyw", "menyw yn pwdu", "pwdu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("surmulende kvinde"),
            keywords: &["kvinde", "sur", "surmule", "surmulende kvinde", "utilfreds"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schmollende Frau"),
            keywords: &["Frau", "Gesicht", "schmollen", "schmollende Frau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατσουφιασμένη γυναίκα"),
            keywords: &[
                "απογοήτευση",
                "γυναίκα",
                "θυμός",
                "κατσουφιασμένη γυναίκα",
                "μορφασμός",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman pouting"),
            keywords: &["gesture", "pouting", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer haciendo pucheros"),
            keywords: &["gesto", "mujer", "mujer haciendo pucheros", "pucheros"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mujer enojada"),
            keywords: &["enojada", "gesto", "mujer"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mossitav naine"),
            keywords: &["ilme", "mossis", "mossitav", "naine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume muturtua"),
            keywords: &[
                "emakume muturtua",
                "emakumea",
                "emakumezkoa",
                "keinua",
                "muturtua",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن اخم\u{200c}وتخم می\u{200c}کند"),
            keywords: &[
                "ابرو در هم کشیدن",
                "اخم و\u{200c} تخم",
                "اخمو",
                "ترش\u{200c}رویی",
                "زن اخم\u{200c}وتخم می\u{200c}کند",
                "عبوس",
                "لب\u{200c}ولوچه آویزان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mököttävä nainen"),
            keywords: &["harmi", "mököttävä nainen", "mökötys", "nainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng nakanguso"),
            keywords: &["babae", "babaeng nakanguso", "nakalabi", "nakanguso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna við gron"),
            keywords: &["gron", "kona", "kvinna", "kvinna við gron"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme qui boude"),
            keywords: &["boude", "femme", "femme qui boude", "geste"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "baboune",
                "boude",
                "femme",
                "femme qui boude",
                "geste",
                "moue",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean le puisín uirthi"),
            keywords: &[
                "baineann",
                "bean",
                "bean le puisín uirthi",
                "bean le pus",
                "cor",
                "pus",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach le bus oirre"),
            keywords: &[
                "boireannach",
                "boireannach le bus oirre",
                "bus",
                "busach",
                "gluasad",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller furiosa"),
            keywords: &["furiosa", "ira", "muller", "rabia", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("રિસાય\u{ac7}લી સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "રિસાય\u{ac7}લી સ\u{acd}ત\u{acd}રી",
                "રિસાવ\u{ac1}\u{a82}",
                "સ\u{acd}ત\u{acd}રી",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai ɓacin zuciya"),
            keywords: &["karimci", "mace", "mace mai ɓacin zuciya", "ɓacin zuciya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מבואסת"),
            keywords: &["אוף", "אישה", "אישה מבואסת", "מחמיצה פנים", "מעקמת את האף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("होठ निकली ह\u{941}ई महिला"),
            keywords: &[
                "इशारा",
                "औरत",
                "महिला",
                "होठ निकली ह\u{941}ई महिला",
                "होठ निकाला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nadurena žena"),
            keywords: &["durenje", "izraz lica", "nadurena žena", "žena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("duzzogó nő"),
            keywords: &["duzzogás", "duzzogó", "gesztus", "nő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խռոված կին"),
            keywords: &["խռոված", "կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita tidak senang"),
            keywords: &["bibir", "perempuan", "tidak senang", "wanita tidak senang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-asọpụta ọnụ"),
            keywords: &[
                "na-asọpụta ọnụ",
                "nwanyi",
                "nwanyị na-asọpụta ọnụ",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona í fýlu"),
            keywords: &["fýla", "fýlusvipur", "kona", "kona í fýlu", "súr"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna imbronciata"),
            keywords: &["donna", "femmina", "gesto", "imbronciata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("不機嫌な女"),
            keywords: &["ぷんぷん", "不機嫌", "不機嫌な女", "女", "女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon mbesengut"),
            keywords: &["isarat", "mbesengut", "wong wadon", "wong wadon mbesengut"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაბუტული ქალი"),
            keywords: &["გაბუტული", "ჟესტი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ренжулі әйел"),
            keywords: &["ренжулі", "ренжіген", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde surmuler"),
            keywords: &["kvinde", "kvinde surmuler", "sur", "surmule", "utilfreds"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}ម\u{17bd}រម\u{17c9}ៅ"),
            keywords: &[
                "ទ\u{17b9}កម\u{17bb}ខ",
                "នារ\u{17b8}",
                "នារ\u{17b8}ម\u{17bd}រម\u{17c9}ៅ",
                "ម\u{17bd}រម\u{17c9}ៅ",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cbf}ಡುಕು ಮುಖದ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಅಂಗಸನ\u{ccd}ನ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{cbf}ಡುಕು ಮುಖ",
                "ಸ\u{cbf}ಡುಕು ಮುಖದ ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뾰로통한 여자"),
            keywords: &["불만", "뾰로통", "뾰로통한 여자", "뿌루퉁", "심통"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल पावट करता"),
            keywords: &["पावट करता", "बायल", "बायल पावट करता", "हावभाव"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тултуюп таарынган аял"),
            keywords: &["аял", "ишарат", "тултуюп таарынган аял", "тултуюу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("motzend Fra"),
            keywords: &["Fra", "Geste", "motzen", "motzend Fra"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເບະສ\u{ebb}ບ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເບະສ\u{ebb}ບ",
                "ເບະສ\u{ebb}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susiraukusi moteris"),
            keywords: &["gestas", "moteris", "susiraukusi"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sabozusies sieviete"),
            keywords: &["bēdāties", "sabozusies sieviete", "sieviete", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tupere"),
            keywords: &["tohu ā-ringa", "tupere", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("налутена жена"),
            keywords: &["гест", "жена", "лутење", "налутена жена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "ച\u{d41}ണ\u{d4d}ട\u{d41}ക\u{d42}ർപ\u{d4d}പിക\u{d4d}കൽ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урвагар эмэгтэй"),
            keywords: &["дохио зангаа", "урвагар эмэгтэй", "урвайх", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("अस\u{902}तोष दाखवणारी महिला"),
            keywords: &[
                "अस\u{902}तोष",
                "अस\u{902}तोष दाखवणारी महिला",
                "अस\u{902}तोष दाखवणारी स\u{94d}त\u{94d}री",
                "स\u{94d}त\u{94d}री",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan mencebik"),
            keywords: &[
                "gerak isyarat",
                "memuncungkan mulut",
                "perempuan",
                "perempuan mencebik",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara tisporġi x-xofftejn"),
            keywords: &[
                "mara",
                "mara tisporġi x-xofftejn",
                "tisporġi x-xofftejn",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "စ\u{102d}တ\u{103a}တ\u{102d}\u{102f}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "စ\u{102d}တ\u{103a}တ\u{102d}\u{102f}",
                "စ\u{102d}တ\u{103a}တ\u{102d}\u{102f}နေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne som furter"),
            keywords: &[
                "furting",
                "kvinne",
                "kvinne som furter",
                "mimikk",
                "surmuling",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some(
                "थ\u{941}त\u{941}\u{941}नो त\u{947}र\u{94d}साइरह\u{947}की छोरीमान\u{94d}छ\u{947}",
            ),
            keywords: &[
                "इसारा",
                "छोरीमान\u{94d}छ\u{947}",
                "थ\u{941}त\u{941}नो त\u{947}र\u{94d}साइरह\u{947}को",
                "थ\u{941}त\u{941}\u{941}नो त\u{947}र\u{94d}साइरह\u{947}की छोरीमान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("pruilende vrouw"),
            keywords: &["pruilen", "pruilende vrouw", "uitdrukking", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne som furtar"),
            keywords: &[
                "furting",
                "kvinne",
                "kvinne som furtar",
                "mimikk",
                "surmuling",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}",
                "ମ\u{b41}ହ\u{b01} ଫ\u{b41}ଲ\u{b3e}ଇବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ ਕ\u{a71}ਢਦੀ ਇਸਤਰੀ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਔਰਤ",
                "ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ ਕ\u{a71}ਢਣਾ",
                "ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ ਕ\u{a71}ਢਦੀ ਇਸਤਰੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ بسوردی زنانی"),
            keywords: &["اشارہ", "زنانی", "منہ بسوردی زنانی", "منہ بسورنا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé De Mék Lọ\u{301}ng Fes"),
            keywords: &[
                "Sain",
                "To Mék Lọ\u{301}ng Fes",
                "Wúman",
                "Wúman Wé De Mék Lọ\u{301}ng Fes",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nadąsana kobieta"),
            keywords: &["kobieta", "nadąsana", "niezadowolona"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه تندی کوت کوي"),
            keywords: &["اشاره", "تندی کوت کول", "ښځه", "ښځه تندی کوت کوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher fazendo bico"),
            keywords: &["bico", "cara feia", "mulher", "mulher fazendo bico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher amuada"),
            keywords: &["beicinho", "gesto", "mulher", "mulher amuada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("phiñachisqa warmi"),
            keywords: &["gesto", "phiñachisqa warmi", "piñachisqa", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie bosumflată"),
            keywords: &[
                "bosumflare",
                "femeie",
                "femeie bosumflată",
                "gest",
                "îmbufnare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1220"),
            keywords: &["E10-1220"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("обиженная женщина"),
            keywords: &["недовольство", "обида", "обиженная", "обиженная женщина"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore urakaye"),
            keywords: &["ikimenyetso", "umugore", "umugore urakaye", "uwarakaye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت ناپسند ڪندي"),
            keywords: &["اشارو، ناپسند، عورت", "عورت ناپسند ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට උල\u{dca}කරන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "අභ\u{dd2}න",
                "කට උල\u{dca}කරන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "කට උල\u{dca}ක\u{dd2}ර\u{dd3}ම",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("podráždená žena"),
            keywords: &["podráždená", "trucujúca", "výraz", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska, ki kuha mulo"),
            keywords: &[
                "dekle",
                "kujanje",
                "obrazna mimika",
                "ženska",
                "ženska, ki kuha mulo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag bushinta qaniinaysa"),
            keywords: &[
                "bushin qaniinidda",
                "meedaar",
                "naag",
                "naag bushinta qaniinaysa",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua e pakënaqur"),
            keywords: &["gjest", "grua", "grua e pakënaqur", "var buzët"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("надурена жена"),
            keywords: &["дурење", "жена", "надурена жена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nadurena žena"),
            keywords: &["durenje", "nadurena žena", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("plutande kvinna"),
            keywords: &["kvinna", "plutande kvinna", "plutar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke anayebibidua midomo"),
            keywords: &["bibidua midomo", "ishara", "mwanamke anayebibidua midomo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கோபம\u{bbe}க இருக\u{bcd}கும\u{bcd} பெண\u{bcd}"),
            keywords: &[
                "ஆத\u{bcd}திரம\u{bcd}",
                "கோபம\u{bbe}க இருக\u{bcd}கும\u{bcd} பெண\u{bcd}",
                "கோபம\u{bcd}",
                "சினம\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4a}హం ముడుచుకున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}"),
            keywords: &[
                "మహ\u{c3f}ళ",
                "మ\u{c4a}హం ముడుచుకున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "మ\u{c4a}హం ముడుచుక\u{c4b}వడం",
                "సంజ\u{c4d}ఞ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки лабҳояшро каҷ карда истодааст"),
            keywords: &[
                "зан",
                "зане, ки лабҳояшро каҷ карда истодааст",
                "имову ишора",
                "каҷкунии лаб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งโกรธ"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งโกรธ",
                "โกรธ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gamaşyk zenan"),
            keywords: &["gamaşyk", "zenan", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine mataʻita"),
            keywords: &["fefine mataʻita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("darılan kadın"),
            keywords: &["bayan", "darılan kadın", "darılma", "kadın", "mimik"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ھومايغان ئايال"),
            keywords: &["ئايال", "ئىشارە", "ھومايغان ئايال", "ھومىيىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка, що дується"),
            keywords: &["жінка", "жінка, що дується", "злість", "сердиться"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ بسورتی ہوا عورت"),
            keywords: &[
                "اداسی ظاہر کرنا",
                "عورت",
                "منھ بسورنا",
                "منہ بسورتی ہوا عورت",
                "ہونٹ دبانا",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("arazlagan ayol"),
            keywords: &["arazlagan", "ayol", "yuz ifodasi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ bĩu môi"),
            keywords: &["bĩu môi", "cử chỉ", "người phụ nữ bĩu môi", "nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen puucatu"),
            keywords: &["jigéen", "liyaar", "puucatu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elitsolisa umlomo"),
            keywords: &[
                "ibhinqa",
                "ibhinqa elitsolisa umlomo",
                "jekula",
                "ukutsolisa umlomo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń ṣíṣù ètè síta"),
            keywords: &[
                "fowọ\u{301}júwè",
                "obìnrin",
                "obìnrin tí ń ṣíṣù ètè síta",
                "ṣíṣù ètè síta",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("撅嘴嘅女人"),
            keywords: &["女", "撅嘴", "撅嘴嘅女人", "表情"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("撅嘴嘅女人"),
            keywords: &["女", "撅嘴", "撅嘴嘅女人", "表情"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("撅嘴女"),
            keywords: &["不开心", "噘嘴", "女", "撅嘴女"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生噘嘴"),
            keywords: &["噘嘴", "女生噘嘴", "生氣"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女子噘嘴"),
            keywords: &["女人", "女子噘嘴", "撅嘴", "表情"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame odangele"),
            keywords: &["odangele", "owesimame"],
        },
    ],
};
#[doc = "🙎🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_POUTING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F64E 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman pouting: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏻\u{200d}♀",
        codepoint: "1F64E 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman pouting: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_POUTING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F64E 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman pouting: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏼\u{200d}♀",
        codepoint: "1F64E 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman pouting: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_POUTING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F64E 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman pouting: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏽\u{200d}♀",
        codepoint: "1F64E 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman pouting: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_POUTING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F64E 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman pouting: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏾\u{200d}♀",
        codepoint: "1F64E 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman pouting: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙎🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_POUTING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙎🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F64E 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman pouting: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙎🏿\u{200d}♀",
        codepoint: "1F64E 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman pouting: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅"]
pub const PERSON_GESTURING_NO: crate::Emoji = crate::Emoji {
    glyph: "🙅",
    codepoint: "1F645",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person gesturing NO",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon wat wys NEE"),
            keywords: &[
                "gebaar",
                "hand",
                "keer",
                "nee",
                "persoon wat wys NEE",
                "verbied",
                "verbode",
                "wys nee",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ምልክት ለአይሆንም"),
            keywords: &["እጅ", "ክልክል", "የተከለከለ", "የእጅ ምልክት", "የእጅ ምልክት ለአይሆንም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}إشارة رفض"),
            keywords: &["أمر سيء", "لا", "ممنوع", "\u{202b}إشارة رفض"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নোহোৱ\u{9be} ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "নহয\u{9bc}",
                "নিষিদ\u{9cd}ধ",
                "নোহোৱ\u{9be} ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "প\u{9cd}ৰতিবন\u{9cd}ধিত",
                "ভঙ\u{9cd}গী",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yox jesti"),
            keywords: &[
                "jest",
                "qadağa",
                "qadağan olunmuş",
                "xeyr",
                "yox",
                "yox jesti",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек супраць"),
            keywords: &["жэст", "забаронена", "рука", "супраць", "чалавек супраць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жест за „не“"),
            keywords: &["жест", "жест за „не“", "забранено", "не", "ръка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ন\u{9be} এর অঙ\u{9cd}গভঙ\u{9cd}গি"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "ন\u{9be}",
                "ন\u{9be} এর অঙ\u{9cd}গভঙ\u{9cd}গি",
                "নিষিদ\u{9cd}ধ",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba pokazuje ne"),
            keywords: &[
                "gestikulacija",
                "neslaganje",
                "osoba pokazuje ne",
                "prekriženo",
                "zabranjeno",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gest de negació"),
            keywords: &["gest de negació", "mà", "negació", "no", "prohibit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎾᏛᏁᎲ ᎥᏝ"),
            keywords: &["ᎠᏅᏍᏙᏍᎦ", "ᎠᏎᏟᏙᎯ", "ᎤᏬᏱ", "ᎦᏅᏍᏙᏍᎦ", "ᏴᏫ ᎾᏛᏁᎲ ᎥᏝ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto nesouhlasu"),
            keywords: &[
                "gesto",
                "gesto nesouhlasu",
                "ne",
                "ruka",
                "zakázáno",
                "zákaz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn ystumio nad yw’n iawn"),
            keywords: &[
                "gwaharddedig",
                "llaw",
                "na",
                "person yn ystumio nad yw’n iawn",
                "ystum",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("signalerer nej"),
            keywords: &["forbudt", "nej", "signalerer nej"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Person mit überkreuzten Armen"),
            keywords: &["Person mit überkreuzten Armen", "verboten", "x"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο διαφωνεί"),
            keywords: &[
                "άτομο διαφωνεί",
                "απαγορευμένο",
                "απαγορεύεται",
                "δεν",
                "κίνηση",
                "χέρι",
                "όχι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person gesturing NO"),
            keywords: &[
                "forbidden",
                "gesture",
                "hand",
                "person gesturing NO",
                "prohibited",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona haciendo el gesto de \"no\""),
            keywords: &[
                "gesto",
                "mano",
                "no",
                "persona haciendo el gesto de \"no\"",
                "prohibido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gesto de está mal"),
            keywords: &[
                "brazos",
                "cruzados",
                "gesto",
                "gesto de está mal",
                "no",
                "prohibido",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona haciendo el gesto de \"no\""),
            keywords: &[
                "brazos",
                "cruzados",
                "gesto",
                "gesto de no",
                "persona",
                "persona haciendo el gesto de \"no\"",
                "prohibido",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("persona haciendo el gesto de NO"),
            keywords: &[
                "alto",
                "gesto",
                "mano",
                "persona haciendo el gesto de NO",
                "prohibido",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("eitav žest"),
            keywords: &["ei", "eitav žest", "keelatud", "käed", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ados ez dagoela adierazten ari den pertsona"),
            keywords: &[
                "ados ez dagoela adierazten ari den pertsona",
                "debekatuta",
                "esku",
                "ez",
                "galarazita",
                "keinu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابدا\u{64b} نه"),
            keywords: &["ابدا\u{64b} نه", "خیر", "دست", "ممنوع", "نه", "ژست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ei-ele"),
            keywords: &["ei", "ei-ele", "ele", "kielletty", "käsi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagpapahiwatig na hindi pwede"),
            keywords: &[
                "bawal",
                "gesture",
                "hindi pwede",
                "huwag",
                "ipinagbabawal",
                "kamay",
                "nagpapahiwatig na hindi pwede",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur sum veipar nei"),
            keywords: &[
                "fólk",
                "nei",
                "persónur",
                "persónur sum veipar nei",
                "veipar",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne faisant un geste d’interdiction"),
            keywords: &[
                "geste",
                "interdit",
                "main",
                "personne faisant un geste d’interdiction",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("Geste de négation"),
            keywords: &[
                "Geste de négation",
                "désaccord",
                "interdit",
                "main",
                "négation",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine ag comharthú NÍL"),
            keywords: &["bac", "cosc", "duine ag comharthú NÍL", "níl cead"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach a’ diùltadh rud"),
            keywords: &[
                "diùltadh",
                "gluasad",
                "làmh",
                "neach a’ diùltadh rud",
                "toirmisgte",
                "àicheadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto de prohibición"),
            keywords: &["prohibición", "xesto", "xesto de prohibición"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાર\u{ac1}\u{a82} નહી\u{a82}નો હાવભાવ"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "નહી\u{a82}",
                "પ\u{acd}રતિબ\u{a82}ધિત",
                "સાર\u{ac1}\u{a82} નથી",
                "સાર\u{ac1}\u{a82} નહી\u{a82}નો હાવભાવ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai nunawa A’A da hannu"),
            keywords: &[
                "an hana",
                "a’a",
                "babu",
                "hannu",
                "haram",
                "karimcin",
                "mutum mai nunawa A’A da hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מסמנת ״לא בסדר״"),
            keywords: &["אישה מסמנת ״לא בסדר״", "אסור", "לא", "סימן ידיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नही\u{902} कहता ह\u{941}आ व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "क\u{941}छ अच\u{94d}छा नही\u{902} ह\u{948} भाव",
                "क\u{941}छ ठीक नही\u{902}",
                "च\u{947}हरा",
                "नही\u{902}",
                "नही\u{902} कहता ह\u{941}आ व\u{94d}यक\u{94d}ति",
                "निषिद\u{94d}ध",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba pokazuje \"ne\""),
            keywords: &[
                "kretnja",
                "ne",
                "osoba pokazuje \"ne\"",
                "ruka",
                "zabranjeno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tiltás mutatása"),
            keywords: &[
                "kézjel",
                "nem szabad",
                "tilos",
                "tiltott",
                "tiltás mutatása",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոչ ցույց տվող"),
            keywords: &["արգելված", "ժեստ", "ձեռք", "ոչ", "ոչ ցույց տվող"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang mengisyaratkan TIDAK"),
            keywords: &[
                "dilarang",
                "gerakan",
                "nggak",
                "orang mengisyaratkan TIDAK",
                "tangan",
                "terlarang",
                "tidak",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-egosipta MBÀ"),
            keywords: &[
                "ajụ",
                "aka",
                "machido",
                "mba",
                "odịghị",
                "ogbugbu",
                "onye na-egosipta MBÀ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ekki gott"),
            keywords: &["bannað", "ekki gott", "hendur í kross"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che fa segno di no"),
            keywords: &[
                "faccina",
                "gesto di rifiuto",
                "non bene",
                "persona che fa segno di no",
                "rifiuto",
                "vietato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダメのポーズをする人"),
            keywords: &[
                "NG",
                "だめ",
                "ジェスチャー",
                "ダメのポーズをする人",
                "バツ",
                "人",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong ngisaratake AJA"),
            keywords: &[
                "isarat",
                "larangan",
                "ora kena",
                "ora oleh",
                "tangan",
                "wong ngisaratake AJA",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჟესტი „არა“"),
            keywords: &[
                "აკრძალვა",
                "აკრძალულია",
                "არა",
                "ჟესტი",
                "ჟესტი „არა“",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоқ"),
            keywords: &[
                "ЖОҚ деген адам қимылы",
                "жоқ",
                "рұқсат жоқ",
                "тыйым салынған",
                "қимыл",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("signalerer nej"),
            keywords: &["forbudt", "nej", "signalerer nej"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សខ\u{17d2}វែងដៃជាសញ\u{17d2}ញាថា ទេ"),
            keywords: &[
                "ដៃខ\u{17d2}វែង",
                "ទេ",
                "មន\u{17bb}ស\u{17d2}សខ\u{17d2}វែងដៃជាសញ\u{17d2}ញាថា ទេ",
                "ម\u{17b7}ន",
                "ហាមឃាត\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇಲ\u{ccd}ಲ ಹೇಳುತ\u{ccd}ತ\u{cbf}ರುವುದು"),
            keywords: &[
                "ಇಲ\u{ccd}ಲ",
                "ಇಲ\u{ccd}ಲ ಹೇಳುತ\u{ccd}ತ\u{cbf}ರುವುದು",
                "ಯಾವುದು ಉತ\u{ccd}ತಮವಾಗ\u{cbf}ಲ\u{ccd}ಲ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("안 된다는 제스처를 하는 사람"),
            keywords: &["금지", "손", "안 된다는 제스처를 하는 사람", "제스처"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती ना असो हावभाव करता"),
            keywords: &[
                "निषिध\u{94d}द । हावभाव । हात । ना असो हावभाव करपी व\u{94d}यक\u{94d}ती । प\u{94d}रतिब\u{902}धीत",
                "व\u{94d}यक\u{94d}ती ना असो हावभाव करता",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«жок» деген ишарат"),
            keywords: &[
                "«жок» деген ишарат",
                "жок",
                "ишарат",
                "кол",
                "тыюу салынган",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun, déi NEEN weist"),
            keywords: &[
                "Geste",
                "Hand",
                "Persoun, déi NEEN weist",
                "Verbueden",
                "neen",
                "net",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{ec8}າທາງ ບ\u{ecd}\u{ec8}"),
            keywords: &["ທ\u{ec8}າທາງ", "ບ\u{ecd}\u{ec8}", "ມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("neigiamas gestas"),
            keywords: &["draudžiama", "gestas", "ne", "neigiamas gestas", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks ar aizlieguma žestu"),
            keywords: &[
                "aizliegts",
                "cilvēks ar aizlieguma žestu",
                "cilvēks ar noraidījuma žestu",
                "nedrīkst",
                "nē",
                "roka",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata tohu ana KĀO"),
            keywords: &[
                "kore",
                "kāo",
                "ringa",
                "tangata tohu ana KĀO",
                "tohu ā-ringa",
                "whakakore",
                "whakakāhore",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("човек што неодобрува"),
            keywords: &[
                "гест",
                "забрането",
                "не",
                "рака",
                "човек што негира",
                "човек што неодобрува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "സമ\u{d4d}മതമല\u{d4d}ലെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ഇല\u{d4d}ല എന\u{d4d}ന\u{d41}ള\u{d4d}ള ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി",
                "കൈ",
                "നിരോധിക\u{d4d}കപ\u{d4d}പെട\u{d4d}ടത\u{d4d}",
                "വിലക\u{d4d}കപ\u{d4d}പെട\u{d4d}ടത\u{d4d}",
                "സമ\u{d4d}മതമല\u{d4d}ലെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("үгүйсгэсэн дохио"),
            keywords: &["дохио", "эмэгтэй", "үгүйсгэсэн дохио", "үгүйсгэх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रतिब\u{902}धित"),
            keywords: &[
                "ठीक नाही अस\u{947} हावभाव करणारी व\u{94d}यक\u{94d}ती",
                "नाही",
                "निषिद\u{94d}ध",
                "प\u{94d}रतिब\u{902}धित",
                "हात",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gerak isyarat tidak"),
            keywords: &[
                "bukan",
                "gerak isyarat tidak",
                "isyarat",
                "larang",
                "tangan",
                "tegah",
                "tidak",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tagħmel sinjal ta’ LE"),
            keywords: &[
                "bl-idejn",
                "ma",
                "mhux",
                "persuna tagħmel sinjal ta’ LE",
                "pprojbiti",
                "projbit",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မလ\u{102d}\u{102f} လက\u{103a}ဟန\u{103a}"),
            keywords: &[
                "တားမြစ\u{103a}ခြင\u{103a}း",
                "တားမြစ\u{103a}သည\u{1037}\u{103a} လက\u{103a}ဟန\u{103a}ပြနေသ\u{1030}",
                "မလ\u{102d}\u{102f} လက\u{103a}ဟန\u{103a}",
                "လက\u{103a}ဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gestikulerer NEI"),
            keywords: &["forbudt", "gestikulerer NEI", "ikke", "mimikk", "nei"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठीक नभएको स\u{902}क\u{947}त दिन\u{947} व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "अन\u{941}मति नभएको",
                "इसारा",
                "ठीक नभएको स\u{902}क\u{947}त दिन\u{947} व\u{94d}यक\u{94d}ति",
                "निष\u{947}ध",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon die nee-gebaar maakt"),
            keywords: &[
                "gebaar",
                "hand",
                "illegaal",
                "persoon die nee-gebaar maakt",
                "verboden",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gestikulerer NEI"),
            keywords: &["forbode", "gestikulerer NEI", "ikkje", "mimikk", "nei"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ନ\u{b3e}ହ\u{b3f}\u{b01} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ନ\u{b3e}ହ\u{b3f}\u{b01} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ କର\u{b41}ଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ",
                "ମନ\u{b3e} କର\u{b3f}ଦେବ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਹੀ\u{a02} ਦਾ ਸ\u{a70}ਕ\u{a47}ਤ ਕਰਨਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਚ\u{a70}ਗਾ ਨਹੀ\u{a02}",
                "ਚ\u{a70}ਗਾ ਨਹੀ\u{a02} ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਨਹੀ\u{a02}",
                "ਨਹੀ\u{a02} ਦਾ ਸ\u{a70}ਕ\u{a47}ਤ ਕਰਨਾ",
                "ਮਨ\u{a4d}ਹਾਹੀ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بندہ نہیں دا اشارہ کر دیاں ہوئیاں"),
            keywords: &[
                "اشارہ",
                "بندہ نہیں دا اشارہ کر دیاں ہوئیاں",
                "حرام",
                "ممنوع کیتا",
                "نہیں",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Ték Hand De Shó Sé Na NO I Min"),
            keywords: &[
                "Hand",
                "Mék Yu Nọ\u{301} Dú Sọ\u{301}mtin",
                "Nó Alau",
                "Pẹ\u{301}sin Wé Ték Hand De Shó Sé Na NO I Min",
                "Pẹ\u{301}sin Wé Ték Hand Shó Sé Na NO I Min",
                "Sain",
                "To Fọbíd Sọ\u{301}mtin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba pokazująca gest NIE"),
            keywords: &["nie wolno", "osoba pokazująca gest NIE", "zakaz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص د نه اشاره کوي"),
            keywords: &["اشاره", "شخص د نه اشاره کوي", "لاس", "ممنوع", "منع کول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa fazendo gesto de “não”"),
            keywords: &["gesto", "mão", "pessoa fazendo gesto de “não”", "proibido"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa que faz gesto de não"),
            keywords: &[
                "gesto",
                "mão",
                "não",
                "pessoa que faz gesto de não",
                "proibido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa MANA rikuy"),
            keywords: &["amasqa", "amatasqa", "gesto", "maki", "runa MANA rikuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană făcând un gest de negație"),
            keywords: &[
                "gest",
                "interzis",
                "mâini",
                "nu",
                "persoană făcând un gest de negație",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-905"),
            keywords: &["E10-905"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек против"),
            keywords: &[
                "жест",
                "запрещено",
                "нельзя",
                "руки",
                "человек",
                "человек против",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu ugaragaza OYA"),
            keywords: &[
                "bibujijwe",
                "ikiganza",
                "ikimenyetso",
                "nti",
                "oya",
                "umuntu ugaragaza OYA",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو نه جو اشارو ڪندي"),
            keywords: &["ماڻهو نه جو اشارو ڪندي", "منع ڪيل، اشارو، هٿ، نه، روڪيل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නැත යන අභ\u{dd2}නය"),
            keywords: &[
                "අත",
                "අභ\u{dd2}න",
                "තහනම\u{dca}",
                "නැත",
                "නැත යන අභ\u{dd2}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek s\u{a0}prekríženými rukami"),
            keywords: &[
                "gesto",
                "nie",
                "ruka",
                "zakázané",
                "človek s\u{a0}prekríženými rukami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki kaže NE"),
            keywords: &[
                "gesta",
                "ne",
                "ni dovoljeno",
                "oseba, ki kaže NE",
                "prepovedano",
                "roka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof ku meedaaraya MAYA"),
            keywords: &[
                "gacan",
                "mamnuuc",
                "meedaar",
                "qof ku meedaaraya MAYA",
                "reebban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("«jo» me gjeste"),
            keywords: &["dorë", "gjest", "i ndaluar", "ndalohet", "«jo» me gjeste"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа која показује „не“"),
            keywords: &[
                "зaбрaњeнo",
                "нe",
                "нeмa",
                "особа која показује „не“",
                "покрет",
                "рукa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba koja pokazuje „ne“"),
            keywords: &[
                "ne",
                "nema",
                "osoba koja pokazuje „ne“",
                "pokret",
                "ruka",
                "zabranjeno",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person gestikulerar NEJ"),
            keywords: &[
                "förbjudet",
                "gest",
                "gest för NEJ",
                "person gestikulerar NEJ",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu anayeonyesha ishara ya kukataa"),
            keywords: &[
                "hapana",
                "ishara",
                "katazwa",
                "marufuku",
                "mkono",
                "mtu anayeonyesha ishara ya kukataa",
                "siyo",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "செய\u{bcd}யக\u{bcd}கூட\u{bbe}து என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
            ),
            keywords: &[
                "இல\u{bcd}லை",
                "செய\u{bcd}யக\u{bcd}கூட\u{bbe}து என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "சைகை",
                "முடிந\u{bcd}தது",
                "வேண\u{bcd}ட\u{bbe}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వద\u{c4d}దు అన\u{c3f} సూచ\u{c3f}ంచ\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f} ముఖం"),
            keywords: &[
                "ముఖం",
                "వద\u{c4d}దు అన\u{c3f} సూచ\u{c3f}ంచ\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f} ముఖం",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки \"НЕ\" ишора карда истодааст"),
            keywords: &[
                "даст",
                "имову ишора",
                "мамнуъ",
                "манъшуда",
                "не",
                "шахсе, ки \"НЕ\" ишора карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e37}อทำท\u{e48}าไม\u{e48}โอเค"),
            keywords: &[
                "ม\u{e37}อ",
                "ม\u{e37}อทำท\u{e48}าไม\u{e48}โอเค",
                "ห\u{e49}าม",
                "ไม\u{e48}เห\u{e47}นด\u{e49}วย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ÝOK ümleýän adam"),
            keywords: &[
                "bolanok",
                "el",
                "gadagan",
                "ÝOK ümleýän adam",
                "ÝOK ümleýän kişi",
                "üm",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha kaunima fetuiaki"),
            keywords: &["tokotaha kaunima fetuiaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hayır hareketi"),
            keywords: &[
                "hareket",
                "hayır",
                "hayır hareketi",
                "iyi değil",
                "yasak",
                "yüz",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياق دەپ ئىشارە قىلغان كىشى"),
            keywords: &[
                "ئىشارە",
                "ئەمەس",
                "توسۇش",
                "قول",
                "ياق",
                "ياق دەپ ئىشارە قىلغان كىشى",
                "چەكلەنگەن",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина, що жестом показує «ні»"),
            keywords: &[
                "жест",
                "заборонено",
                "людина",
                "людина, що жестом показує «ні»",
                "рука",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نہیں کا اشارہ"),
            keywords: &["منع کرنا", "نہیں", "نہیں کا اشارہ", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yo‘q ishorasi"),
            keywords: &[
                "imo-ishora",
                "man qilingan",
                "qo‘l",
                "taqiqlangan",
                "yoʻq ishorasi",
                "yo‘q ishorasi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người ra hiệu phản đối"),
            keywords: &[
                "cấm",
                "cử chỉ",
                "không cho phép",
                "người ra hiệu phản đối",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ku naan déedet"),
            keywords: &[
                "bul",
                "déet",
                "liyaar",
                "loxo",
                "luñ aaye",
                "luñ tere",
                "nit ku naan déedet",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ojekulayo ukuthi HAYI"),
            keywords: &[
                "hayi",
                "isandla",
                "ithintelweyo",
                "jekula",
                "nakanye",
                "umntu ojekulayo ukuthi HAYI",
                "yalelwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni Nsọ RARA"),
            keywords: &[
                "fowọ\u{301}júwè",
                "rárá",
                "èwọ\u{300}",
                "Ẹni Nsọ RARA",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做拒絕手勢嘅人"),
            keywords: &["不", "做拒絕手勢嘅人", "唔准", "唔好", "手", "手勢", "禁止"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做拒绝手势嘅人"),
            keywords: &["不", "做拒绝手势嘅人", "唔准", "唔好", "手", "手势", "禁止"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("禁止手势"),
            keywords: &["不行", "反对", "禁止", "禁止手势"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("不行"),
            keywords: &["NG", "不行"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("用手臂做出交叉手勢嘅人"),
            keywords: &[
                "交叉手勢",
                "唔係",
                "唔得",
                "手勢",
                "用手臂做出交叉手勢嘅人",
                "禁止",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu oveza ukuthi akulungile"),
            keywords: &[
                "cha",
                "enqaba",
                "isandla",
                "okungavumelekile",
                "okunqantshiwe",
                "umuntu oveza ukuthi akulungile",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙅🏻"]
pub const PERSON_GESTURING_NO_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏻",
    codepoint: "1F645 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing NO: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙅🏼"]
pub const PERSON_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏼",
    codepoint: "1F645 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing NO: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙅🏽"]
pub const PERSON_GESTURING_NO_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏽",
    codepoint: "1F645 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing NO: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙅🏾"]
pub const PERSON_GESTURING_NO_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏾",
    codepoint: "1F645 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing NO: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙅🏿"]
pub const PERSON_GESTURING_NO_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏿",
    codepoint: "1F645 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing NO: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙅\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_NO: crate::Emoji = crate::Emoji {
    glyph: "🙅\u{200d}♂\u{fe0f}",
    codepoint: "1F645 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing NO",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅\u{200d}♂",
        codepoint: "1F645 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing NO",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man wys NEE"),
            keywords: &[
                "gebaar",
                "hand",
                "man",
                "man wys NEE",
                "nee",
                "verbied",
                "verbode",
                "wys nee",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ምልክት ለአይሆንም ወንድ"),
            keywords: &["እጅ", "ወንድ", "የተከለከለ", "የእጅ ምልክት", "የእጅ ምልክት ለአይሆንም ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("غير موافق"),
            keywords: &["إشارة رفض", "غير موافق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নোহোৱ\u{9be} ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "নহয\u{9bc}",
                "নিষিদ\u{9cd}ধ",
                "নোহোৱ\u{9be} ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9cd}ৰতিবন\u{9cd}ধিত",
                "ভঙ\u{9cd}গী",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əleyhinə olan kişi"),
            keywords: &[
                "jest",
                "kişi",
                "qadağandır",
                "yox",
                "əl",
                "əleyhinə",
                "əleyhinə olan kişi",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына супраць"),
            keywords: &["жэст", "мужчына", "нязгода", "супраць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж, правещ жест за „не“"),
            keywords: &[
                "жест с ръка",
                "жест „не“",
                "забрана",
                "мъж, правещ жест за „не“",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষের দেখ\u{9be}নো ঠিক নেই অঙ\u{9cd}গিভঙ\u{9cd}গি"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "নিষিদ\u{9cd}ধ",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষের দেখ\u{9be}নো ঠিক নেই অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "প\u{9c1}র\u{9c1}ষের দেখ\u{9be}নো ন\u{9be} এর অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac pokazuje ne"),
            keywords: &[
                "gestikulacija",
                "muškarac",
                "muškarac pokazuje ne",
                "neslaganje",
                "zabranjeno",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home amb gest de negació"),
            keywords: &["gest", "home", "home amb gest de negació", "mà", "prohibit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏓᏐᏰᏍᎬ ᎥᏝ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎢᏯᏛᏁᏗ ᏂᎨᏒᎾ", "ᎤᏬᏱ", "ᎥᏝ", "ᎦᏅᏍᏙᏍᎦ", "ᏓᏐᏰᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž s gestem nesouhlasu"),
            keywords: &["muž", "muž s gestem nesouhlasu", "ne", "nesouhlas", "zákaz"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn ystumio nad yw’n iawn"),
            keywords: &[
                "dyn",
                "dyn yn ystumio nad yw’n iawn",
                "gwaharddedig",
                "na",
                "ystum",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand signalerer nej"),
            keywords: &[
                "forbudt",
                "gestus",
                "ikke i orden",
                "mand",
                "mand signalerer nej",
                "nej",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann mit überkreuzten Armen"),
            keywords: &["Arme", "Gesicht", "Mann", "Mann mit überkreuzten Armen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας διαφωνεί"),
            keywords: &[
                "άντρας",
                "άντρας διαφωνεί",
                "αποδοκιμασία",
                "διαφωνία",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man gesturing NO"),
            keywords: &[
                "forbidden",
                "gesture",
                "hand",
                "man",
                "man gesturing NO",
                "prohibited",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre haciendo el gesto de \"no\""),
            keywords: &[
                "gesto",
                "hombre",
                "hombre haciendo el gesto de \"no\"",
                "mano",
                "prohibido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("eitavat žesti näitav mees"),
            keywords: &[
                "eitavat žesti näitav mees",
                "keelatud",
                "käed ristis",
                "mees",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ados ez dagoela adierazten ari den gizona"),
            keywords: &[
                "ados ez dagoela adierazten ari den gizona",
                "debekatuta",
                "eskua",
                "galarazita",
                "gizona",
                "gizonezkoa",
                "keinua",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد نمی\u{200c}پذیرد"),
            keywords: &[
                "ابدا\u{64b} نه",
                "رد",
                "مخالف بودن",
                "مرد نمی\u{200c}پذیرد",
                "ممنوع",
                "نه",
                "ژست مخالفت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ei käy -merkkiä näyttävä mies"),
            keywords: &[
                "ei",
                "ei käy -merkkiä näyttävä mies",
                "ele",
                "kielletty",
                "mies",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking kumukumpas na hindi ok"),
            keywords: &[
                "ayaw",
                "bawal",
                "hindi",
                "hindi pwede",
                "lalaking kumukumpas na hindi ok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður sum veipar nei"),
            keywords: &["maður", "maður sum veipar nei", "nei", "veipar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme faisant un geste d’interdiction"),
            keywords: &[
                "geste",
                "homme",
                "homme faisant un geste d’interdiction",
                "interdit",
                "main",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("homme faisant un geste de négation"),
            keywords: &[
                "désaccord",
                "homme",
                "homme faisant un geste de négation",
                "interdit",
                "main",
                "négation",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear ag comharthú NÍL"),
            keywords: &[
                "coiscthe",
                "comhartha",
                "cosc",
                "fear",
                "fear ag comharthú NÍL",
                "fear ag rá níl",
                "lámh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine a’ diùltadh rud"),
            keywords: &[
                "duine",
                "duine a’ diùltadh rud",
                "fear",
                "fireannach",
                "gluasad",
                "làmh",
                "toirmisgte",
                "àicheadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home facendo xesto de prohibición"),
            keywords: &[
                "home",
                "home facendo xesto de prohibición",
                "prohibición",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાર\u{ac1}\u{a82} નહી\u{a82}નો હાવભાવ પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "નહી\u{a82}",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{acd}રતિબ\u{a82}ધિત",
                "સાર\u{ac1}\u{a82} નથી",
                "સાર\u{ac1}\u{a82} નહી\u{a82}નો હાવભાવ પ\u{ac1}ર\u{ac1}ષ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji mai nunawa A’A da hannu"),
            keywords: &[
                "an hana",
                "a’a",
                "hannu",
                "haram",
                "karimcin",
                "mutum",
                "namiji mai nunawa A’A da hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר מסמן ״לא״"),
            keywords: &[
                "איש",
                "אסור",
                "גבר",
                "גבר מסמן ״לא״",
                "גבר מסמן ״לא״ עם הידיים",
                "לא",
                "לא בסדר",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नही\u{902} कहता ह\u{941}आ प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "इशारा",
                "कोई",
                "ठीक नही\u{902}",
                "नही\u{902} कहता ह\u{941}आ प\u{941}र\u{941}ष",
                "निषिद\u{94d}ध",
                "प\u{941}र\u{941}ष",
                "मना किया",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac pokazuje \"ne\""),
            keywords: &[
                "muškarac pokazuje \"ne\"",
                "ne",
                "nedopušteno",
                "nije u redu",
                "zabranjeno",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tiltást mutató férfi"),
            keywords: &[
                "férfi",
                "gesztus",
                "kézmozdulat",
                "tilos",
                "tiltás",
                "tiltást mutató férfi",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդը դեմ է"),
            keywords: &["արգելված", "դեմ", "ժեստ", "տղամարդ", "տղամարդը դեմ է"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria mengisyaratkan TIDAK"),
            keywords: &["isyarat", "laki-laki", "pria mengisyaratkan TIDAK", "tidak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-egosipta MBÀ"),
            keywords: &[
                "ajụ",
                "aka",
                "machido",
                "mba",
                "nwoke",
                "nwoke na-egosipta MBÀ",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður segir ekki í lagi"),
            keywords: &["bannað", "ekki", "karl", "maður segir ekki í lagi", "nei"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo con gesto di rifiuto"),
            keywords: &[
                "no",
                "proibito",
                "rifiuto",
                "uomo",
                "uomo con gesto di rifiuto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダメのポーズをする男"),
            keywords: &[
                "NG",
                "ジェスチャー",
                "ダメのポーズをする男",
                "バツ",
                "男",
                "男性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang ngisaratake AJA"),
            keywords: &[
                "isarat",
                "larangan",
                "ora kena",
                "ora oleh",
                "tangan",
                "wong lanang",
                "wong lanang ngisaratake AJA",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი ჟესტით „არა“"),
            keywords: &["აკრძალულია", "არა", "კაცი", "კაცი ჟესტით „არა“", "ჟესტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарсымын деп тұрған ер"),
            keywords: &["болмайды", "ер", "қарсы", "қарсымын деп тұрған ер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand signalerer nej"),
            keywords: &[
                "forbudt",
                "gestus",
                "ikke i orden",
                "mand",
                "mand signalerer nej",
                "nej",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសចេញកាយវ\u{17b7}ការបដ\u{17b7}សេធ"),
            keywords: &[
                "ឃាត\u{17cb}",
                "បដ\u{17b7}សេធ",
                "ប\u{17bb}រសចេញកាយវ\u{17b7}ការបដ\u{17b7}សេធ",
                "ម\u{17b7}នយល\u{17cb}ព\u{17d2}រម",
                "ហាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇಲ\u{ccd}ಲ ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ"),
            keywords: &[
                "ಇಲ\u{ccd}ಲ ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ",
                "ಕೈ",
                "ನ\u{cbf}ಷೇಧ\u{cbf}ತ",
                "ಪುರುಷ",
                "ಸರ\u{cbf}ಯ\u{cbf}ಲ\u{ccd}ಲ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("안 된다는 제스처를 하는 남자"),
            keywords: &["손동작", "안 돼", "안 된다는 제스처를 하는 남자", "엑스자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ना असो हावभाव करपी दादलो"),
            keywords: &[
                "ना असो हावभाव करपी दादलो",
                "निषिध\u{94d}द । हावभाव । हात । दादलो । ना असो हावभाव करपी दादलो प\u{94d}रतिब\u{902}धीत",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ЖОК деп жаткан эркек"),
            keywords: &[
                "«жок» деп жаткан эркек",
                "ЖОК деп жаткан эркек",
                "каршы",
                "макул эмес",
                "эркек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann, deen NEEN weist"),
            keywords: &[
                "Geste",
                "Hand",
                "Mann",
                "Mann, deen NEEN weist",
                "neen",
                "net",
                "verbueden",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າບ\u{ecd}\u{ec8}ໂອເຄ"),
            keywords: &[
                "ຕ\u{ec9}ອງຫ\u{ec9}າມ",
                "ບ\u{ecd}\u{ec8}ໂອໂຄ",
                "ບ\u{ecd}\u{ec8}ໄດ\u{ec9}",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າບ\u{ecd}\u{ec8}ໂອເຄ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("draudžiantis vyras"),
            keywords: &[
                "draudžiama",
                "draudžiantis vyras",
                "gestas",
                "neleistina",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis ar aizlieguma žestu"),
            keywords: &[
                "nepiekrišana",
                "pret",
                "vīrietis",
                "vīrietis ar aizlieguma žestu",
                "vīrietis ar noraidījuma žestu",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tohu ana KĀO"),
            keywords: &[
                "kore",
                "kāo",
                "ringa",
                "tohu ā-ringa",
                "tāne",
                "tāne tohu ana KĀO",
                "whakakore",
                "whakakāhore",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж што неодобрува"),
            keywords: &["гест", "забрането", "маж", "маж што неодобрува", "рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വിലക\u{d4d}ക\u{d41}ന\u{d4d}ന ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ഇല\u{d4d}ല എന\u{d4d}ന\u{d41}ള\u{d4d}ള ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന പ\u{d41}ര\u{d41}ഷൻ",
                "കൈ",
                "നിരോധിക\u{d4d}കപ\u{d4d}പെട\u{d4d}ടത\u{d4d}",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "വിലക\u{d4d}കപ\u{d4d}പെട\u{d4d}ടത\u{d4d}",
                "വിലക\u{d4d}ക\u{d41}ന\u{d4d}ന ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүгээр биш гэж харуулж буй эрэгтэй"),
            keywords: &[
                "гар",
                "дохио",
                "зүгээр биш гэж харуулж буй эрэгтэй",
                "хориотой",
                "эрэгтэй",
                "ҮГҮЙ гэсэн дохио үзүүлж буй эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठीक नाही म\u{94d}हणणारा प\u{941}र\u{941}ष"),
            keywords: &[
                "ठीक नाही अस\u{947} हावभाव करणारा प\u{941}र\u{941}ष नाही",
                "ठीक नाही म\u{94d}हणणारा प\u{941}र\u{941}ष",
                "निषिद\u{94d}ध",
                "प\u{941}र\u{941}ष",
                "प\u{94d}रतिब\u{902}धित",
                "हात",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki memberi isyarat tidak ok"),
            keywords: &[
                "dilarang",
                "gerak isyarat",
                "lelaki",
                "lelaki memberi isyarat tidak",
                "lelaki memberi isyarat tidak ok",
                "tidak",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jagħmel sinjal ta’ LE"),
            keywords: &[
                "bl-idejn",
                "mhux",
                "pprojbiti",
                "projbit",
                "raġel",
                "raġel jagħmel sinjal ta’ LE",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တားမြစ\u{103a}ကြောင\u{103a}း လက\u{103a}ဟန\u{103a}ပြသ\u{1030} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "တားမြစ\u{103a}",
                "တားမြစ\u{103a}ကြောင\u{103a}း လက\u{103a}ဟန\u{103a}ပြသ\u{1030} အမျ\u{102d}\u{102f}းသား",
                "လက\u{103a}",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann som gestikulerer NEI"),
            keywords: &[
                "avbryt",
                "forbudt",
                "mann",
                "mann som gestikulerer NEI",
                "nei",
                "stopp",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठीक नभएको स\u{902}\u{902}क\u{947}त दिन\u{947} छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "अन\u{941}मति नभएको",
                "इसारा",
                "छोरा मान\u{94d}छ\u{947}",
                "ठीक नभएको स\u{902}\u{902}क\u{947}त दिन\u{947} छोरामान\u{94d}छ\u{947}",
                "ठीक नभएको स\u{902}क\u{947}त दिन\u{947} छोरामान\u{94d}छ\u{947}",
                "निष\u{947}ध",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man die nee-gebaar maakt"),
            keywords: &[
                "gebaar",
                "hand",
                "man",
                "man die nee-gebaar maakt",
                "nee",
                "verboden",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann som gestikulerer NEI"),
            keywords: &[
                "avbryt",
                "forbode",
                "mann",
                "mann som gestikulerer NEI",
                "nei",
                "stopp",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b41}ର\u{b41}ଷ ନ\u{b3e}ହ\u{b3f}\u{b01} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ କର\u{b41}ଛ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ନ\u{b3e}ହ\u{b3f}\u{b01} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ କର\u{b41}ଛ\u{b3f}",
                "ମନ\u{b3e} କର\u{b3f}ଦେବ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠੀਕ ਨਹੀ\u{a02} ਦਾ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਠੀਕ ਨਹੀ\u{a02}",
                "ਠੀਕ ਨਹੀ\u{a02} ਦਾ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਨਹੀ\u{a02}",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a4d}ਰਤੀਬ\u{a70}ਧਿਤ",
                "ਬ\u{a70}ਦਾ",
                "ਮਨਾਹੀਆ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نہیں دا اشارہ کردا بندہ"),
            keywords: &[
                "اشارہ",
                "بندہ",
                "حرام",
                "ممنوع کیتا",
                "نہیں",
                "نہیں دا اشارہ کردا بندہ",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé Ték Hand Shó Sé Na NO I Min"),
            keywords: &[
                "Hand",
                "Man",
                "Man Wé Ték Hand De Shó Sé Na NO I Min",
                "Man Wé Ték Hand Shó Sé Na NO I Min",
                "Mék Yu Nọ\u{301} Dú Sọ\u{301}mtin",
                "Nó Alau",
                "Sain",
                "To Fọbíd Sọ\u{301}mtin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna pokazujący gest NIE"),
            keywords: &[
                "mężczyzna",
                "mężczyzna pokazujący gest NIE",
                "nie",
                "ręce",
                "zakaz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی د نه اشاره کوي"),
            keywords: &["اشاره", "سړی د نه اشاره کوي", "لاس", "ممنوع", "منع کول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem fazendo gesto de “não”"),
            keywords: &[
                "gesto",
                "homem",
                "homem fazendo gesto de “não”",
                "mão",
                "proibido",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem que faz gesto de não"),
            keywords: &[
                "gesto",
                "homem",
                "homem que faz gesto de não",
                "não",
                "proibido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tat MANA gestowan"),
            keywords: &["amasqa", "amatasqa", "gesto", "maki", "tat MANA gestowan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat făcând un gest de negație"),
            keywords: &[
                "bărbat",
                "bărbat făcând un gest de negație",
                "gest",
                "interzis",
                "mâini",
                "nu",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1211"),
            keywords: &["E10-1211"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина против"),
            keywords: &[
                "жест",
                "запрещено",
                "мужчина",
                "мужчина против",
                "нельзя",
                "руки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo werekana ikimenyetso cya OYA"),
            keywords: &[
                "bibujijwe",
                "ikiganza",
                "ikimenyetso",
                "oya",
                "umugabo",
                "umugabo werekana ikimenyetso cya OYA",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد نه جو اشارو ڪندي"),
            keywords: &["مرد نه جو اشارو ڪندي", "منع ڪيل، اشارو، هٿ، نه، روڪيل، مرد"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2} නැත\u{dd2} බව පෙන\u{dca}වන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "අත",
                "තහනම\u{dca}",
                "නැහැ",
                "හර\u{dd2} නැත\u{dd2} බව පෙන\u{dca}වන ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "හර\u{dd2} නැහැ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž s prekríženými rukami"),
            keywords: &[
                "gesto",
                "muž",
                "muž s prekríženými rukami",
                "nie",
                "ruka",
                "zakázané",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški, ki s kretnjo izraža prepoved"),
            keywords: &[
                "fant",
                "kretnja",
                "moški",
                "moški, ki s kretnjo izraža prepoved",
                "ne",
                "neodobravanje",
                "ni dovoljeno",
                "ni v redu",
                "prepovedano",
                "roka",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin ku meedaaraya MAYA"),
            keywords: &[
                "gacan",
                "mamnuuc",
                "meedaar",
                "nin ku meedaaraya MAYA",
                "qof ku meedaaraya MAYA",
                "reebban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë që bën gjestin e ndaluar"),
            keywords: &[
                "burrë",
                "burrë që bën gjestin e ndaluar",
                "e ndaluar",
                "gjest",
                "jo në rregull",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац показује „не“"),
            keywords: &[
                "гестикулација",
                "мушкарац",
                "мушкарац показује „не“",
                "не",
                "руке",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac pokazuje „ne“"),
            keywords: &[
                "gestikulacija",
                "muškarac",
                "muškarac pokazuje „ne“",
                "ne",
                "ruke",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man gestikulerar NEJ"),
            keywords: &["förbjudet", "gest", "man", "man gestikulerar NEJ"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("Mtu anayeonyesha ishara ya HAPANA"),
            keywords: &[
                "Mtu anayeonyesha ishara ya HAPANA",
                "hapana",
                "ishara",
                "kataa",
                "mkono",
                "mwanamume anayeonyesha ishara ya kukataa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மறுக\u{bcd}கும\u{bcd} ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "செய\u{bcd}ய\u{bbe}தே",
                "மறு",
                "மறுக\u{bcd}கும\u{bcd} ஆண\u{bcd}",
                "வேண\u{bcd}ட\u{bbe}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అంగ\u{c40}కర\u{c3f}ంచను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న పురుషుడు"),
            keywords: &[
                "అంగ\u{c40}కర\u{c3f}ంచను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న పురుషుడు",
                "చ\u{c47}య\u{c3f}",
                "న\u{c3f}ష\u{c3f}ద\u{c4d}దం",
                "న\u{c3f}ష\u{c47}ధ\u{c3f}ంచబడ\u{c3f}ంద\u{c3f}",
                "పురుషుడు",
                "సంజ\u{c4d}ఞ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки \"НЕ\" ишора карда истодааст"),
            keywords: &[
                "даст",
                "имову ишора",
                "мамнуъ",
                "манъшуда",
                "мард",
                "марде, ки \"НЕ\" ишора карда истодааст",
                "не",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายทำท\u{e48}าไม\u{e48}โอเค"),
            keywords: &[
                "ต\u{e49}องห\u{e49}าม",
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายทำท\u{e48}าไม\u{e48}โอเค",
                "ห\u{e49}าม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ÝOK ümleýän erkek"),
            keywords: &[
                "bolanok",
                "el",
                "erkek",
                "gadagan",
                "ÝOK ümleýän erkek",
                "üm",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata kaunima fetuiaki"),
            keywords: &["tangata kaunima fetuiaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hayır hareketi yapan erkek"),
            keywords: &[
                "el",
                "erkek",
                "hareket",
                "hayır",
                "hayır hareketi yapan erkek",
                "iyi değil",
                "yasak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياق دەپ ئىشارە قىلغان ئەر"),
            keywords: &[
                "ئىشارە",
                "ئەر",
                "ئەمەس",
                "توسۇش",
                "قول",
                "ياق",
                "ياق دەپ ئىشارە قىلغان ئەر",
                "چەكلەنگەن",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік, що жестом показує «ні»"),
            keywords: &[
                "заборона",
                "проти",
                "чоловік",
                "чоловік, що жестом показує «ні»",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹھیک نہیں ہونے کا اشارہ کرتا ہوا مرد"),
            keywords: &[
                "اشارہ",
                "روکنا",
                "مرد",
                "منع کرنا",
                "ٹھیک نہیں ہونے کا اشارہ کرتا ہوا مرد",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak yo‘q demoqda"),
            keywords: &[
                "erkak yoʻq demoqda",
                "erkak yo‘q demoqda",
                "imo-ishora",
                "man qilingan",
                "qo‘l",
                "taqiqlangan",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông ra hiệu phản đối"),
            keywords: &[
                "bị cấm",
                "cấm",
                "cử chỉ",
                "người đàn ông",
                "người đàn ông ra hiệu phản đối",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor buy liyaar Déet"),
            keywords: &[
                "bul",
                "góor",
                "góor buy liyaar Déet",
                "liyaar",
                "loxo",
                "luñ aaye",
                "luñ tere",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda elijekulayo ukuthi HAYI"),
            keywords: &[
                "hayi",
                "indoda",
                "indoda elijekulayo ukuthi HAYI",
                "isandla",
                "ithintelwe",
                "jekula",
                "yalelwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tí ń sọ RÁRÁ"),
            keywords: &[
                "fowọ\u{301}júwè",
                "rárá",
                "èwọ\u{300}",
                "ọkùnrin tí ń sọ RÁRÁ",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做拒絕手勢嘅男人"),
            keywords: &[
                "做拒絕手勢嘅男人",
                "唔准",
                "唔好",
                "手",
                "手勢",
                "男",
                "禁止",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做拒绝手势嘅男人"),
            keywords: &[
                "做拒绝手势嘅男人",
                "唔准",
                "唔好",
                "手",
                "手势",
                "男",
                "禁止",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("禁止手势男"),
            keywords: &["不行", "反对", "男", "禁止", "禁止手势男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生手比叉"),
            keywords: &["NG", "不行", "叉", "男生手比叉", "禁止"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("用手臂做出交叉手勢嘅男人"),
            keywords: &[
                "NO",
                "交叉手勢",
                "唔係",
                "唔得",
                "用手臂做出交叉手勢嘅男人",
                "男",
                "禁止",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda eveza ukuthi akulungile"),
            keywords: &[
                "cha",
                "enqaba",
                "indoda",
                "indoda eveza ukuthi akulungile",
                "isandla",
                "okungavumelekile",
                "okunqantshiwe",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙅🏻\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_NO_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F645 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing NO: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏻\u{200d}♂",
        codepoint: "1F645 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing NO: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏼\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F645 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing NO: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏼\u{200d}♂",
        codepoint: "1F645 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing NO: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏽\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_NO_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F645 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing NO: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏽\u{200d}♂",
        codepoint: "1F645 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing NO: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏾\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F645 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing NO: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏾\u{200d}♂",
        codepoint: "1F645 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing NO: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏿\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_NO_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F645 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing NO: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏿\u{200d}♂",
        codepoint: "1F645 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing NO: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_NO: crate::Emoji = crate::Emoji {
    glyph: "🙅\u{200d}♀\u{fe0f}",
    codepoint: "1F645 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing NO",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅\u{200d}♀",
        codepoint: "1F645 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing NO",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou wys NEE"),
            keywords: &[
                "gebaar",
                "hand",
                "nee",
                "verbied",
                "verbode",
                "vrou",
                "vrou wys NEE",
                "wys nee",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ምልክት ለአይሆንም ሴት"),
            keywords: &[
                "ሴት",
                "እጅ",
                "ክልክል",
                "የተከለከለ",
                "የእጅ ምልክት",
                "የእጅ ምልክት ለአይሆንም ሴት",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("غير موافقة"),
            keywords: &["إشارة رفض", "غير موافقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নোহোৱ\u{9be} ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "নহয\u{9bc}",
                "নিষিদ\u{9cd}ধ",
                "নোহোৱ\u{9be} ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} মহিল\u{9be}",
                "প\u{9cd}ৰতিবন\u{9cd}ধিত",
                "ভঙ\u{9cd}গী",
                "মহিল\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əleyhinə olan qadın"),
            keywords: &[
                "jest",
                "qadağandır",
                "qadın",
                "əl",
                "əleyhinə",
                "əleyhinə olan qadın",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына супраць"),
            keywords: &["жанчына", "жэст", "нязгода", "супраць"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена, правеща жест за „не“"),
            keywords: &[
                "жена, правеща жест за „не“",
                "жест с ръка",
                "жест „не“",
                "забрана",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}র দেখ\u{9be}নো ঠিক নেই অঙ\u{9cd}গিভঙ\u{9cd}গি"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ঠিক নেই",
                "নিষিদ\u{9cd}ধ",
                "মহিল\u{9be}",
                "মহিল\u{9be}র দেখ\u{9be}নো ঠিক নেই অঙ\u{9cd}গিভঙ\u{9cd}গি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena pokazuje ne"),
            keywords: &[
                "gestikulacija",
                "neslaganje",
                "zabranjeno",
                "žena",
                "žena pokazuje ne",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona amb gest de negació"),
            keywords: &["dona", "dona amb gest de negació", "gest", "mà", "prohibit"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏓᏐᏰᏍᎬ ᎥᏝ"),
            keywords: &["ᎠᎨᏯ", "ᎢᏯᏛᏁᏗ ᏂᎨᏒᎾ", "ᎤᏬᏱ", "ᎥᏝ", "ᎦᏅᏍᏙᏍᎦ", "ᏓᏐᏰᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena s gestem nesouhlasu"),
            keywords: &[
                "ne",
                "nesouhlas",
                "zákaz",
                "žena",
                "žena s gestem nesouhlasu",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn ystumio nad yw’n iawn"),
            keywords: &[
                "gwaharddedig",
                "menyw",
                "menyw yn ystumio nad yw’n iawn",
                "na",
                "ystum",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde signalerer nej"),
            keywords: &[
                "forbudt",
                "gestus",
                "ikke i orden",
                "kvinde",
                "kvinde signalerer nej",
                "nej",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau mit überkreuzten Armen"),
            keywords: &["Arme", "Frau", "Frau mit überkreuzten Armen", "Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα διαφωνεί"),
            keywords: &[
                "αποδοκιμασία",
                "γυναίκα",
                "γυναίκα διαφωνεί",
                "διαφωνία",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman gesturing NO"),
            keywords: &[
                "forbidden",
                "gesture",
                "hand",
                "prohibited",
                "woman",
                "woman gesturing NO",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer haciendo el gesto de \"no\""),
            keywords: &[
                "gesto",
                "mano",
                "mujer",
                "mujer haciendo el gesto de \"no\"",
                "prohibido",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("eitavat žesti näitav naine"),
            keywords: &[
                "eitavat žesti näitav naine",
                "keelatud",
                "käed ristis",
                "naine",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezezko keinua egiten ari den emakumea"),
            keywords: &[
                "ados ez dagoela adierazten ari den emakumea",
                "debekatuta",
                "emakumea",
                "emakumezkoa",
                "eskua",
                "ezezko keinua egiten ari den emakumea",
                "galarazita",
                "keinua",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن نمی\u{200c}پذیرد"),
            keywords: &[
                "ابدا\u{64b} نه",
                "رد",
                "زن نمی\u{200c}پذیرد",
                "مخالف بودن",
                "ممنوع",
                "نه",
                "ژست مخالفت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ei käy -merkkiä näyttävä nainen"),
            keywords: &[
                "ei",
                "ei käy -merkkiä näyttävä nainen",
                "ele",
                "kielletty",
                "nainen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng kumukumpas na hindi ok"),
            keywords: &[
                "ayaw",
                "babaeng kumukumpas na hindi ok",
                "bawal",
                "hindi",
                "hindi pwede",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna sum veipar nei"),
            keywords: &["kona", "kvinna", "kvinna sum veipar nei", "nei", "veipar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme faisant un geste d’interdiction"),
            keywords: &[
                "femme",
                "femme faisant un geste d’interdiction",
                "geste",
                "interdit",
                "main",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("femme faisant un geste de négation"),
            keywords: &[
                "désaccord",
                "femme",
                "femme faisant un geste de négation",
                "interdit",
                "main",
                "négation",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean ag comharthú NÍL"),
            keywords: &[
                "bean",
                "bean ag comharthú NÍL",
                "bean ag rá níl",
                "coiscthe",
                "comhartha",
                "cosc",
                "lámh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach a’ diùltadh rud"),
            keywords: &[
                "boireannach",
                "boireannach a’ diùltadh rud",
                "gluasad",
                "làmh",
                "toirmisgte",
                "tè",
                "àicheadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller facendo xesto de prohibición"),
            keywords: &[
                "muller",
                "muller facendo xesto de prohibición",
                "prohibición",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સાર\u{ac1}\u{a82} નહી\u{a82}નો હાવભાવ સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "નહી\u{a82}",
                "પ\u{acd}રતિબ\u{a82}ધિત",
                "સાર\u{ac1}\u{a82} નથી",
                "સાર\u{ac1}\u{a82} નહી\u{a82}નો હાવભાવ સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai nunawa A’A da hannu"),
            keywords: &[
                "an hana",
                "a’a",
                "hannu",
                "haram",
                "karimcin",
                "mace",
                "mace mai nunawa A’A da hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מסמנת ״לא״"),
            keywords: &[
                "אישה",
                "אישה מסמנת ״לא טוב״",
                "אישה מסמנת ״לא״",
                "אסור",
                "לא",
                "לא בסדר",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नही\u{902} कहती ह\u{941}ई महिला"),
            keywords: &[
                "इशारा",
                "कोई",
                "ठीक नही\u{902}",
                "नही\u{902} कहती ह\u{941}ई महिला",
                "निषिद\u{94d}ध",
                "मना किया",
                "महिला",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena pokazuje \"ne\""),
            keywords: &[
                "ne",
                "nedopušteno",
                "nije u redu",
                "zabranjeno",
                "žena pokazuje \"ne\"",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tiltást mutató nő"),
            keywords: &[
                "gesztus",
                "kézmozdulat",
                "nő",
                "tilos",
                "tiltás",
                "tiltást mutató nő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կինը դեմ է"),
            keywords: &["արգելված", "դեմ", "ժեստ", "կին", "կինը դեմ է"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita mengisyaratkan TIDAK"),
            keywords: &[
                "isyarat",
                "perempuan",
                "tangan",
                "tidak",
                "wanita mengisyaratkan TIDAK",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-egosipta MBÀ"),
            keywords: &[
                "ajụ",
                "aka",
                "machido",
                "mba",
                "nwanyị",
                "nwanyị na-egosipta MBÀ",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona segir ekki í lagi"),
            keywords: &["bannað", "ekki", "kona", "kona segir ekki í lagi", "nei"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna con gesto di rifiuto"),
            keywords: &[
                "donna",
                "donna con gesto di rifiuto",
                "no",
                "proibito",
                "rifiuto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ダメのポーズをする女"),
            keywords: &[
                "NG",
                "ジェスチャー",
                "ダメのポーズをする女",
                "バツ",
                "女",
                "女性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon menehi isarat AJA"),
            keywords: &[
                "isarat",
                "ora kena",
                "ora oleh",
                "tangan",
                "wong wadon",
                "wong wadon menehi isarat AJA",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი ჟესტით „არა“"),
            keywords: &["აკრძალულია", "არა", "ჟესტი", "ქალი", "ქალი ჟესტით „არა“"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарсымын деп тұрған әйел"),
            keywords: &["болмайды", "қарсы", "қарсымын деп тұрған әйел", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde signalerer nej"),
            keywords: &[
                "forbudt",
                "gestus",
                "ikke i orden",
                "kvinde",
                "kvinde signalerer nej",
                "nej",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}ចេញកាយវ\u{17b7}ការបដ\u{17b7}សេធ"),
            keywords: &[
                "ឃាត\u{17cb}",
                "នារ\u{17b8}ចេញកាយវ\u{17b7}ការបដ\u{17b7}សេធ",
                "បដ\u{17b7}សេធ",
                "ម\u{17b7}នយល\u{17cb}ព\u{17d2}រម",
                "ហាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಇಲ\u{ccd}ಲ ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಇಲ\u{ccd}ಲ ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಕೈ",
                "ನ\u{cbf}ಷೇಧ\u{cbf}ತ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸರ\u{cbf}ಯ\u{cbf}ಲ\u{ccd}ಲ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("안 된다는 제스처를 하는 여자"),
            keywords: &["손동작", "안 돼", "안 된다는 제스처를 하는 여자", "엑스자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ना असो हावभाव करपी बायल"),
            keywords: &[
                "ना असो हावभाव करपी बायल",
                "निषिध\u{94d}द । हावभाव । हात । प\u{94d}रतिब\u{902}धीत । बायल । ना असो हावभाव करपी बायल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«жок» деп жаткан аял"),
            keywords: &["«жок» деп жаткан аял", "аял", "каршы", "макул эмес"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra, déi NEEN weist"),
            keywords: &[
                "Fra",
                "Fra, déi NEEN weist",
                "Geste",
                "Hand",
                "neen",
                "net",
                "verbueden",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າບ\u{ecd}\u{ec8}ໂອເຄ"),
            keywords: &[
                "ຕ\u{ec9}ອງຫ\u{ec9}າມ",
                "ບ\u{ecd}\u{ec8}ໂອໂຄ",
                "ບ\u{ecd}\u{ec8}ໄດ\u{ec9}",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າບ\u{ecd}\u{ec8}ໂອເຄ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("draudžianti moteris"),
            keywords: &[
                "draudžiama",
                "draudžianti moteris",
                "gestas",
                "moteris",
                "neleistina",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete ar aizlieguma žestu"),
            keywords: &[
                "aizliegts",
                "nedrīkst",
                "roka",
                "sieviete",
                "sieviete ar aizlieguma žestu",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tohu ana KĀO"),
            keywords: &[
                "kore",
                "kāo",
                "ringa",
                "tohu ā-ringa",
                "wahine",
                "wahine tohu ana KĀO",
                "whakakore",
                "whakakāhore",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена што неодобрува"),
            keywords: &["гест", "жена", "жена што неодобрува", "забрането", "рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വിലക\u{d4d}ക\u{d41}ന\u{d4d}ന ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ഇല\u{d4d}ല എന\u{d4d}ന\u{d41}ള\u{d4d}ള ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "കൈ",
                "നിരോധിക\u{d4d}കപ\u{d4d}പെട\u{d4d}ടത\u{d4d}",
                "വിലക\u{d4d}കപ\u{d4d}പെട\u{d4d}ടത\u{d4d}",
                "വിലക\u{d4d}ക\u{d41}ന\u{d4d}ന ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүгээр биш гэж харуулж буй эмэгтэй"),
            keywords: &[
                "гар",
                "дохио",
                "зүгээр биш гэж харуулж буй эмэгтэй",
                "хориотой",
                "эмэгтэй",
                "ҮГҮЙ гэсэн дохио үзүүлж буй эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठीक नाही म\u{94d}हणणारी महिला"),
            keywords: &[
                "ठीक नाही अस\u{947} हावभाव करणारी महिला",
                "ठीक नाही म\u{94d}हणणारी महिला",
                "नाही",
                "निषिद\u{94d}ध",
                "प\u{94d}रतिब\u{902}धित",
                "महिला",
                "हात",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan memberi isyarat tidak ok"),
            keywords: &[
                "dilarang",
                "gerak isyarat",
                "perempuan",
                "perempuan memberi isyarat TIDAK",
                "perempuan memberi isyarat tidak ok",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara tagħmel sinjal ta’ LE"),
            keywords: &[
                "bl-idejn",
                "mara",
                "mara tagħmel sinjal ta’ LE",
                "mhux",
                "pprojbiti",
                "projbit",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "တားမြစ\u{103a}ကြောင\u{103a}း လက\u{103a}ဟန\u{103a}ပြသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "တားမြစ\u{103a}",
                "တားမြစ\u{103a}ကြောင\u{103a}း လက\u{103a}ဟန\u{103a}ပြသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "လက\u{103a}",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne som gestikulerer NEI"),
            keywords: &[
                "avbryt",
                "forbudt",
                "kvinne",
                "kvinne som gestikulerer NEI",
                "nei",
                "stopp",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठीक नभएको स\u{902}क\u{947}\u{947}त दिन\u{947} छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "अन\u{941}मति नभएको",
                "इसारा",
                "ठीक नभएको स\u{902}क\u{947}त दिन\u{947} छोरीमान\u{94d}छ\u{947}",
                "ठीक नभएको स\u{902}क\u{947}\u{947}त दिन\u{947} छोरीमान\u{94d}छ\u{947}",
                "निष\u{947}ध",
                "महिला",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw die nee-gebaar maakt"),
            keywords: &[
                "gebaar",
                "hand",
                "illegaal",
                "verboden",
                "vrouw",
                "vrouw die nee-gebaar maakt",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne som gestikulerer NEI"),
            keywords: &[
                "avbryt",
                "forbode",
                "kvinne",
                "kvinne som gestikulerer NEI",
                "nei",
                "stopp",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ମହ\u{b3f}ଳ\u{b3e} ନ\u{b3e} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ନ\u{b3f}ଷ\u{b3f}ଦ\u{b4d}ଧ",
                "ମନ\u{b3e} କର\u{b3f}ଦେବ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ନ\u{b3e} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨਹੀ\u{a02} ਦਾ ਸ\u{a70}ਕ\u{a47}ਤ ਕਰਦੀ ਔਰਤ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਔਰਤ",
                "ਠੀਕ ਨਹੀ\u{a02}",
                "ਨਹੀ\u{a02}",
                "ਨਹੀ\u{a02} ਦਾ ਸ\u{a70}ਕ\u{a47}ਤ ਕਰਦੀ ਔਰਤ",
                "ਪ\u{a4d}ਰਤੀਬ\u{a70}ਧਿਤ",
                "ਮਨਾਹੀਆ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نہیں دا اشارہ کردی زنانی"),
            keywords: &[
                "اشارہ",
                "حرام",
                "زنانی",
                "ممنوع کیتا",
                "نہیں",
                "نہیں دا اشارہ کردی زنانی",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Tẹk Hand De Shó Sé Na NO I Min"),
            keywords: &[
                "Hand",
                "Mék Yu Nọ\u{301} Dú Sọ\u{301}mtin",
                "Nó Alau",
                "Sain",
                "To Fọbíd Sọ\u{301}mtin",
                "Wúman",
                "Wúman Tẹk Hand De Shó Sé Na NO I Min",
                "Wúman Wé Ték Hand De Shó Sé Na NO I Min",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta pokazująca gest NIE"),
            keywords: &[
                "kobieta",
                "kobieta pokazująca gest NIE",
                "nie",
                "ręce",
                "zakaz",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه د نه اشاره کوي"),
            keywords: &["اشاره", "لاس", "ممنوع", "منع کول", "ښځه د نه اشاره کوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher fazendo gesto de “não”"),
            keywords: &[
                "gesto",
                "mulher",
                "mulher fazendo gesto de “não”",
                "mão",
                "proibido",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher que faz gesto de não"),
            keywords: &[
                "gesto",
                "mulher",
                "mulher que faz gesto de não",
                "não",
                "proibido",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi MANA gestowan"),
            keywords: &[
                "amasqa",
                "amatasqa",
                "gesto",
                "warmi",
                "warmi MANA gestowan",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie făcând un gest de negație"),
            keywords: &[
                "femeie",
                "femeie făcând un gest de negație",
                "gest",
                "interzis",
                "mâini",
                "nu",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1210"),
            keywords: &["E10-1210"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина против"),
            keywords: &[
                "женщина",
                "женщина против",
                "жест",
                "запрещено",
                "нельзя",
                "руки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore werekana ikimenyetso cya OYA"),
            keywords: &[
                "bibujijwe",
                "ikiganza",
                "ikimenyetso",
                "oya",
                "umugore",
                "umugore werekana ikimenyetso cya OYA",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت نه جو اشارو ڪندي"),
            keywords: &[
                "عورت نه جو اشارو ڪندي",
                "منع ڪيل، اشارو، هٿ، نه، روڪيل، عورت",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2} නැත\u{dd2} බව පෙන\u{dca}වන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "අත",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "තහනම\u{dca}",
                "හර\u{dd2} නැත\u{dd2} බව පෙන\u{dca}වන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "හර\u{dd2} නැහැ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žena s prekríženými rukami"),
            keywords: &[
                "gesto",
                "nie",
                "ruka",
                "zakázané",
                "žena",
                "žena s prekríženými rukami",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska, ki s kretnjo izraža prepoved"),
            keywords: &[
                "dekle",
                "kretnja",
                "ne",
                "neodobravanje",
                "ni dovoljeno",
                "ni v redu",
                "prepovedano",
                "roka",
                "ženska",
                "ženska, ki s kretnjo izraža prepoved",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag ku meedaaraysa MAYA"),
            keywords: &[
                "gacan",
                "mamnuuc",
                "meedaar",
                "naag",
                "naag ku meedaaraysa MAYA",
                "reebban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua që bën gjestin e ndaluar"),
            keywords: &[
                "e ndaluar",
                "gjest",
                "grua",
                "grua që bën gjestin e ndaluar",
                "jo në rregull",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена показује „не“"),
            keywords: &["гестикулација", "жена", "жена показује „не“", "не", "руке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena pokazuje „ne“"),
            keywords: &["gestikulacija", "ne", "ruke", "žena", "žena pokazuje „ne“"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinna gestikulerar NEJ"),
            keywords: &["förbjudet", "gest", "kvinna", "kvinna gestikulerar NEJ"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke anayeonyesha ishara ya kukataa"),
            keywords: &[
                "hapana",
                "ishara",
                "kataa",
                "mkono",
                "mwanamke anayeonyesha ishara ya kukataa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மறுக\u{bcd}கும\u{bcd} பெண\u{bcd}"),
            keywords: &[
                "செய\u{bcd}ய\u{bbe}தே",
                "பெண\u{bcd}",
                "மறு",
                "மறுக\u{bcd}கும\u{bcd} பெண\u{bcd}",
                "வேண\u{bcd}ட\u{bbe}ம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "అంగ\u{c40}కర\u{c3f}ంచను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}",
            ),
            keywords: &[
                "అంగ\u{c40}కర\u{c3f}ంచను",
                "అంగ\u{c40}కర\u{c3f}ంచను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "చ\u{c47}య\u{c3f}",
                "న\u{c3f}ష\u{c3f}ద\u{c4d}ధం",
                "న\u{c3f}ష\u{c47}ధ\u{c3f}ంచబడ\u{c3f}ంద\u{c3f}",
                "మహ\u{c3f}ళ",
                "వద\u{c4d}దు",
                "సంజ\u{c4d}ఞ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки \"НЕ\" ишора карда истодааст"),
            keywords: &[
                "даст",
                "зан",
                "зане, ки \"НЕ\" ишора карда истодааст",
                "имову ишора",
                "мамнуъ",
                "манъшуда",
                "не",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งทำท\u{e48}าไม\u{e48}โอเค"),
            keywords: &[
                "ต\u{e49}องห\u{e49}าม",
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งทำท\u{e48}าไม\u{e48}โอเค",
                "ห\u{e49}าม",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ÝOK ümleýän zenan"),
            keywords: &[
                "bolanok",
                "el",
                "gadagan",
                "zenan",
                "ÝOK ümleýän zenan",
                "üm",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine kaunima fetuiaki"),
            keywords: &["fefine kaunima fetuiaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("hayır hareketi yapan kadın"),
            keywords: &[
                "bayan",
                "el",
                "hareket",
                "hayır",
                "hayır hareketi yapan kadın",
                "iyi değil",
                "kadın",
                "yasak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ياق دەپ ئىشارە قىلغان ئايال"),
            keywords: &[
                "ئايال",
                "ئىشارە",
                "ئەمەس",
                "توسۇش",
                "قول",
                "ياق",
                "ياق دەپ ئىشارە قىلغان ئايال",
                "چەكلەنگەن",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка, що жестом показує «ні»"),
            keywords: &[
                "жінка",
                "жінка, що жестом показує «ні»",
                "заборона",
                "проти",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹھیک نہیں ہونے کا اشارہ کرتی ہوئی عورت"),
            keywords: &[
                "اشارہ",
                "روکنا",
                "عورت",
                "منع کرنا",
                "ٹھیک نہیں ہونے کا اشارہ کرتی ہوئی عورت",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol yo‘q demoqda"),
            keywords: &[
                "ayol yoʻq demoqda",
                "ayol yo‘q demoqda",
                "imo-ishora",
                "man qilingan",
                "qo‘l",
                "taqiqlangan",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ ra hiệu phản đối"),
            keywords: &[
                "bị cấm",
                "cấm",
                "cử chỉ",
                "người phụ nữ",
                "người phụ nữ ra hiệu phản đối",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen juy liyaar Déet"),
            keywords: &[
                "bul",
                "jigéen",
                "jigéen juy liyaar Déet",
                "liyaar",
                "loxo",
                "luñ aaye",
                "luñ tere",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elijekulayo ukuthi HAYI"),
            keywords: &[
                "hayi",
                "ibhinqa",
                "ibhinqa elijekulayo ukuthi HAYI",
                "isandla",
                "ithintelweyo",
                "jekula",
                "yalelwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń sọ RÁRÁ"),
            keywords: &[
                "fowọ\u{301}júwè",
                "obìnrin",
                "obìnrin tí ń sọ RÁRÁ",
                "rárá",
                "èwọ\u{300}",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做拒絕手勢嘅女人"),
            keywords: &[
                "做拒絕手勢嘅女人",
                "唔准",
                "唔好",
                "女",
                "手",
                "手勢",
                "禁止",
            ],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做拒绝手势嘅女人"),
            keywords: &[
                "做拒绝手势嘅女人",
                "唔准",
                "唔好",
                "女",
                "手",
                "手势",
                "禁止",
            ],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("禁止手势女"),
            keywords: &["不行", "反对", "女", "禁止", "禁止手势女"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生手比叉"),
            keywords: &["NG", "不行", "叉", "女生手比叉", "禁止"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("用手臂做出交叉手勢嘅女人"),
            keywords: &[
                "NO",
                "交叉手勢",
                "唔係",
                "唔得",
                "女",
                "用手臂做出交叉手勢嘅女人",
                "禁止",
            ],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame oveza ukuthi akulungile"),
            keywords: &[
                "cha",
                "enqaba",
                "isandla",
                "okungavumelekile",
                "okunqantshiwe",
                "owesimame",
                "owesimame oveza ukuthi akulungile",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙅🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_NO_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F645 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing NO: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏻\u{200d}♀",
        codepoint: "1F645 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing NO: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_NO_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F645 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing NO: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏼\u{200d}♀",
        codepoint: "1F645 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing NO: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_NO_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F645 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing NO: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏽\u{200d}♀",
        codepoint: "1F645 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing NO: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_NO_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F645 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing NO: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏾\u{200d}♀",
        codepoint: "1F645 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing NO: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙅🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_NO_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙅🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F645 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing NO: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙅🏿\u{200d}♀",
        codepoint: "1F645 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing NO: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆"]
pub const PERSON_GESTURING_OK: crate::Emoji = crate::Emoji {
    glyph: "🙆",
    codepoint: "1F646",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person gesturing OK",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon wys als is goed"),
            keywords: &[
                "gebaar",
                "goed",
                "hand",
                "ok",
                "persoon wys als is goed",
                "wys goed",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ምልክት ለእሺ"),
            keywords: &["እሺ", "እጅ", "የእጅ ምልክት", "የእጅ ምልክት ለእሺ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة موافقة"),
            keywords: &["إشارة", "إشارة موافقة", "مضبوط", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঠিক আছে ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ঠিক",
                "ঠিক আছে ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "ভঙ\u{9cd}গিম\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ok jesti"),
            keywords: &["jest", "ok", "ok jesti", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек паказвае згоду"),
            keywords: &[
                "добра",
                "жэст",
                "згода",
                "ок",
                "чалавек за",
                "чалавек паказвае згоду",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жест за „окей“"),
            keywords: &["ok", "жест", "жест за „окей“", "окей", "ръка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ওকের অঙ\u{9cd}গভঙ\u{9cd}গি"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "ওকের অঙ\u{9cd}গভঙ\u{9cd}গি",
                "ঠিক আছে",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba pokazuje ok"),
            keywords: &[
                "gestikulacija",
                "odobravanje",
                "osoba pokazuje ok",
                "ruke",
                "slaganje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gest d’aprovació"),
            keywords: &["aprovació", "gest", "gest d’aprovació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎠᏎᏟᏙᎲ ᎭᏩ"),
            keywords: &["ᎤᏬᏱ", "ᎭᏩ", "ᏓᏐᏰᏍᎬ", "ᏴᏫ ᎠᏎᏟᏙᎲ ᎭᏩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto souhlasu"),
            keywords: &["gesto", "gesto souhlasu", "ok", "ruka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn ystumio iawn"),
            keywords: &["iawn", "llaw", "ok", "person yn ystumio iawn", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("signalerer ok"),
            keywords: &["allright", "ansigt", "signalerer ok"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Person mit Händen auf dem Kopf"),
            keywords: &["Person mit Händen auf dem Kopf", "alles in Ordnung", "o"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο συμφωνεί"),
            keywords: &["άτομο συμφωνεί", "εντάξει", "κίνηση", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person gesturing OK"),
            keywords: &["OK", "gesture", "hand", "person gesturing OK"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona haciendo el gesto de \"de acuerdo\""),
            keywords: &[
                "OK",
                "gesto",
                "mano",
                "persona haciendo el gesto de \"de acuerdo\"",
                "vale",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gesto de está bien"),
            keywords: &["bien", "gesto", "gesto de está bien", "ok"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona haciendo el gesto de \"de acuerdo\""),
            keywords: &[
                "bien",
                "gesto",
                "ok",
                "persona gesto de \"de acuerdo\"",
                "persona haciendo el gesto de \"de acuerdo\"",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("persona haciendo el gesto de OK"),
            keywords: &[
                "OK",
                "está bien",
                "gesto",
                "mano",
                "persona haciendo el gesto de OK",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nõustuv žest"),
            keywords: &["käed", "nõustuv žest", "ok", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ados dagoela adierazten ari den pertsona"),
            keywords: &[
                "ados",
                "ados dagoela adierazten ari den pertsona",
                "esku",
                "keinu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("باشه"),
            keywords: &["اوکی", "باشه", "تأیید", "دست", "ژست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ok-ele"),
            keywords: &["ele", "käsi", "ok", "ok-ele"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagpapahiwatig na ok"),
            keywords: &["gesture", "kamay", "nagpapahiwatig na ok", "ok", "pwede"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur sum veipar ok"),
            keywords: &["fólk", "ok", "persónur", "persónur sum veipar ok", "veipar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne faisant un geste d’acceptation"),
            keywords: &[
                "OK",
                "geste",
                "main",
                "personne faisant un geste d’acceptation",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("geste d’affirmation"),
            keywords: &["OK", "accord", "affirmation", "geste d’affirmation", "main"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine ag comharthú OK"),
            keywords: &[
                "OK",
                "ceart go leor",
                "duine ag comharthú OK",
                "duine à dhéanamh OK",
                "gach rud i gceart",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach ag aontachadh ri rud"),
            keywords: &[
                "aontachadh",
                "gluasad",
                "làmh",
                "neach ag aontachadh ri rud",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa coas mans na cabeza"),
            keywords: &[
                "aprobación",
                "hurra",
                "mans na cabeza",
                "persoa coas mans na cabeza",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઑક\u{ac7}નો હાવભાવ"),
            keywords: &[
                "ઑક\u{ac7} હાવભાવ",
                "ઑક\u{ac7}નો હાવભાવ",
                "ચહ\u{ac7}રો",
                "બધ\u{ac1}\u{a82} બરાબર છ\u{ac7}",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai nunawa TO da hannu"),
            keywords: &["TO", "hannu", "karimcin", "mutum mai nunawa TO da hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מסמנת OK עם הידיים"),
            keywords: &["ok", "אוקיי", "אישה מסמנת OK עם הידיים", "סימן ידיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठीक ह\u{948} कहता ह\u{941}आ व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "इशारा",
                "च\u{947}हरा",
                "ठीक भाव",
                "ठीक ह\u{948}",
                "ठीक ह\u{948} कहता ह\u{941}आ व\u{94d}यक\u{94d}ति",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba pokazuje \"u redu\""),
            keywords: &[
                "kretnja",
                "ok",
                "osoba pokazuje \"u redu\"",
                "ruka",
                "u redu",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("beleegyezés mutatása"),
            keywords: &["beleegyezés mutatása", "kézjel", "oké", "rendben"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ok ցույց տվող"),
            keywords: &["ok", "ok ցույց տվող", "ժեստ", "ձեռք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang mengisyaratkan OKE"),
            keywords: &["gerakan", "oke", "orang mengisyaratkan OKE", "tangan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-egosipta Ọ DỊ MMA"),
            keywords: &["aka", "ogbugbu", "onye na-egosipta Ọ DỊ MMA", "Ọ DỊ MMA"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("allt í lagi"),
            keywords: &["allt í lagi", "í lagi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona con gesto OK"),
            keywords: &["OK", "gesto", "persona con gesto OK", "tutto bene"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("OKのポーズをする人"),
            keywords: &[
                "OK",
                "OKのポーズをする人",
                "オーケー",
                "ジェスチャー",
                "丸",
                "人",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong ngisaratake OK"),
            keywords: &["OK", "isarat", "tangan", "wong ngisaratake OK"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჟესტი „კარგი“"),
            keywords: &["კარგი", "ჟესტი", "ჟესტი „კარგი“", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жарайды"),
            keywords: &["жарайды", "қимыл", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("signalerer ok"),
            keywords: &["allright", "ansigt", "signalerer ok"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "មន\u{17bb}ស\u{17d2}សផ\u{17d2}គ\u{17bb}\u{17c6}ដៃលើក\u{17d2}បាលជាសញ\u{17d2}ញាថា យល\u{17cb}ព\u{17d2}រម",
            ),
            keywords: &[
                "OK",
                "កាយវ\u{17b7}ការ",
                "ដៃ",
                "មន\u{17bb}ស\u{17d2}សផ\u{17d2}គ\u{17bb}\u{17c6}ដៃលើក\u{17d2}បាលជាសញ\u{17d2}ញាថា យល\u{17cb}ព\u{17d2}រម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರ\u{cbf} ಹೇಳುತ\u{ccd}ತ\u{cbf}ರುವುದು"),
            keywords: &[
                "ಸರ\u{cbf}",
                "ಸರ\u{cbf} ಸ\u{cc2}ಚಕ",
                "ಸರ\u{cbf} ಹೇಳುತ\u{ccd}ತ\u{cbf}ರುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오케이라는 제스처를 하는 사람"),
            keywords: &[
                "OK",
                "오케이",
                "오케이 제스처",
                "오케이라는 제스처를 하는 사람",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बर\u{947}\u{902} आसा असो हावभाव करपी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "बर\u{947}\u{902} आसा असो हावभाव करपी व\u{94d}यक\u{94d}ती",
                "हावभाव । हात । बर\u{947}\u{902} आसा । बर\u{947}\u{902} आसा असो हावभाव करपी व\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«жарайт» деп жаткан адам"),
            keywords: &[
                "«жарайт» деген ишарат",
                "«жарайт» деп жаткан адам",
                "жарайт",
                "ишарат",
                "кол",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun, déi OK weist"),
            keywords: &["Geste", "Hand", "OK", "Persoun, déi OK weist"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{ec8}າທາງ ຕ\u{ebb}ກລ\u{ebb}ງ"),
            keywords: &["ຕ\u{ebb}ກລ\u{ebb}ງ", "ທ\u{ec8}າທາງ", "ມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("teigiamas gestas"),
            keywords: &["gerai", "gestai", "ranka", "teigiamas gestas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks ar apstiprinājuma žestu"),
            keywords: &[
                "cilvēks ar apstiprinājuma žestu",
                "labi",
                "ok",
                "roka",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata tohu ana ĀE"),
            keywords: &["ringa", "tangata tohu ana ĀE", "tohu ā-ringa", "ĀE"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("човек што одобрува"),
            keywords: &[
                "во ред",
                "гест",
                "ок",
                "рака",
                "човек што одобрува",
                "човек што се согласува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "സമ\u{d4d}മതമെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "കൈ",
                "നല\u{d4d}ല ഭ\u{d3e}വം",
                "ഭ\u{d3e}വം",
                "ശരി",
                "സമ\u{d4d}മതമെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зөвшөөрч байгаа дохио"),
            keywords: &["дохио", "зөвшөөрч байгаа дохио", "зөвшөөрөх", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठीक आह\u{947} हावभाव"),
            keywords: &[
                "ठीक",
                "ठीक आह\u{947} अस\u{947} हावभाव करणारी व\u{94d}यक\u{94d}ती",
                "ठीक आह\u{947} हावभाव",
                "हात",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gerak isyarat okey"),
            keywords: &["gerak isyarat okey", "isyarat", "okey", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tagħmel sinjal ta’ OK"),
            keywords: &["OK", "bl-idejn", "persuna tagħmel sinjal ta’ OK", "ġesti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}\u{102f}ကေဟ\u{102f} အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030}"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ဟန\u{103a}",
                "အ\u{102d}\u{102f}ကေ ပြဟန\u{103a}",
                "အ\u{102d}\u{102f}ကေဟ\u{102f} အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gestikulerer OK"),
            keywords: &["gestikulerer OK", "greit", "ok"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("भाव प\u{94d}रदर\u{94d}शन ठीक छ"),
            keywords: &[
                "ठीक",
                "भाव प\u{94d}रदर\u{94d}शन",
                "भाव प\u{94d}रदर\u{94d}शन ठीक छ",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon die OK-gebaar maakt"),
            keywords: &["OK", "gebaar", "hand", "persoon die OK-gebaar maakt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gestikulerer OK"),
            keywords: &["gestikulerer OK", "greitt", "ok"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଠ\u{b3f}କ\u{b4d} ଅଛ\u{b3f}",
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠੀਕ ਦਾ ਸ\u{a70}ਕ\u{a47}ਤ ਕਰਦਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "OK ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਚਿਹਰਾ",
                "ਠੀਕ ਦਾ ਸ\u{a70}ਕ\u{a47}ਤ ਕਰਦਾ ਵਿਅਕਤੀ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਸ\u{a71}ਭ ਵਧੀਆ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بندہ ٹھیک اے دا اشارہ کر دیاں ہوئیاں"),
            keywords: &[
                "اشارہ",
                "بندہ ٹھیک اے دا اشارہ کر دیاں ہوئیاں",
                "ٹھیک اے",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Tẹk Hand De Shó Sé Na OK I Min"),
            keywords: &[
                "Hand",
                "OK",
                "Pẹ\u{301}sin Tẹk Hand De Shó Sé Na OK I Min",
                "Pẹ\u{301}sin Wé Ték Hand De Shó Sé Na OK I Min",
                "Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba pokazująca gest OK"),
            keywords: &["OK", "osoba pokazująca gest OK", "ręce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص د او کی اشاره کوي"),
            keywords: &["اشاره", "او کی", "شخص د او کی اشاره کوي", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa fazendo gesto de “OK”"),
            keywords: &["OK", "gesto", "mão", "pessoa fazendo gesto de “OK”"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa que faz gesto de OK"),
            keywords: &["gesto", "mão", "ok", "pessoa que faz gesto de OK"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa UYAKUY rikuy"),
            keywords: &["UYAKUY", "gesto", "maki", "runa UYAKUY rikuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană făcând un gest de OK"),
            keywords: &["acord", "gest", "ok", "persoană făcând un gest de OK"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-906"),
            keywords: &["E10-906"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек за"),
            keywords: &[
                "жест",
                "ок",
                "окей",
                "отлично",
                "руки",
                "человек",
                "человек за",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu ugaragaza Yego"),
            keywords: &["Yego", "ikiganza", "ikimenyetso", "umuntu ugaragaza Yego"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو ٺيڪ جو اشارو ڪندي"),
            keywords: &["اشارو، هٿ، نه", "ماڻهو ٺيڪ جو اشارو ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2} යන අභ\u{dd2}නය"),
            keywords: &[
                "අත",
                "අභ\u{dd2}\u{dd2}න",
                "හර\u{dd2}",
                "හර\u{dd2} යන අභ\u{dd2}නය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek s\u{a0}rukami nad hlavou"),
            keywords: &["gesto", "ok", "ruka", "človek s\u{a0}rukami nad hlavou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki kaže V REDU"),
            keywords: &["gesta", "oseba, ki kaže V REDU", "roka", "v redu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag ku meedaaraysa HAA"),
            keywords: &[
                "HAA",
                "gacan",
                "meedaar",
                "naag ku meedaaraysa HAA",
                "qof ku meedaaraya HAA",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("«në rregull» me gjeste"),
            keywords: &[
                "dorë",
                "gjest",
                "në rregull",
                "ok",
                "«në rregull» me gjeste",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа која показује „у реду“"),
            keywords: &[
                "oк",
                "дoбрo",
                "особа која показује „у реду“",
                "покрет",
                "рукa",
                "у рeду",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba koja pokazuje „u redu“"),
            keywords: &[
                "dobro",
                "ok",
                "osoba koja pokazuje „u redu“",
                "pokret",
                "ruka",
                "u redu",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person gestikulerar OK"),
            keywords: &[
                "gest",
                "gest för OK",
                "hand",
                "okej",
                "person gestikulerar OK",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu anayeonyesha ishara ya kukubali"),
            keywords: &[
                "ishara",
                "mkono",
                "mtu anayeonyesha ishara ya kukubali",
                "sawa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சரி என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "ஓகே",
                "சரி",
                "சரி என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "சரி சைகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సర\u{c47} అన\u{c3f} సూచ\u{c3f}ంచ\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f} ముఖం"),
            keywords: &[
                "ముఖం",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "సర\u{c47} అన\u{c3f} సూచ\u{c3f}ంచ\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f} ముఖం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки \"ОК\" ишора карда истодааст"),
            keywords: &[
                "ОК",
                "даст",
                "имову ишора",
                "шахсе, ки \"ОК\" ишора карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทำท\u{e48}าโอเค"),
            keywords: &["ตกลง", "ทำท\u{e48}าโอเค", "โอเค"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Bolýar ümleýän adam"),
            keywords: &["Bolýar ümleýän adam", "bolýar", "el", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha kaunima fetuiaki ʻolunga"),
            keywords: &["tokotaha kaunima fetuiaki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tamam hareketi"),
            keywords: &["hareket", "oldu", "tamam hareketi", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ماقۇل دەپ ئىشارە قىلغان كىشى"),
            keywords: &["ئىشارە", "قول", "ماقۇل", "ماقۇل دەپ ئىشارە قىلغان كىشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина, що жестом показує «окей»"),
            keywords: &["жест", "людина, що жестом показує «окей»", "окей", "рука"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاں کا اشارہ"),
            keywords: &["ٹھیک ہے", "ہاتھ", "ہاں کا اشارہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ok ishorasi"),
            keywords: &["imo-ishora", "ok", "ok ishorasi", "qo‘l"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người ra hiệu đồng ý"),
            keywords: &["cử chỉ", "người ra hiệu đồng ý", "ok", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ku naan waaw-kay"),
            keywords: &["liyaar", "loxo", "nit ku naan waaw-kay", "waaw-kay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ojekula ukuthi Kulungile"),
            keywords: &[
                "Kulungile",
                "isandla",
                "jekula",
                "umntu ojekula ukuthi Kulungile",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni Nsọ O DARA"),
            keywords: &["fowọ\u{301}júwè", "ÓDÁRA", "Ẹni Nsọ O DARA", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做 OK 手勢嘅人"),
            keywords: &["OK", "做 OK 手勢嘅人", "手", "手勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做 OK 手势嘅人"),
            keywords: &["OK", "做 OK 手势嘅人", "手", "手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("OK手势"),
            keywords: &["OK手势", "ok", "好的"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("可以"),
            keywords: &["OK", "可以"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("用手勢表示 OK 嘅人"),
            keywords: &["用手勢表示 OK 嘅人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu oveza ukuthi kulungile"),
            keywords: &[
                "isandla",
                "kulungile",
                "umuntu oveza ukuthi kulungile",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙆🏻"]
pub const PERSON_GESTURING_OK_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏻",
    codepoint: "1F646 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing OK: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙆🏼"]
pub const PERSON_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏼",
    codepoint: "1F646 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing OK: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙆🏽"]
pub const PERSON_GESTURING_OK_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏽",
    codepoint: "1F646 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing OK: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙆🏾"]
pub const PERSON_GESTURING_OK_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏾",
    codepoint: "1F646 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing OK: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙆🏿"]
pub const PERSON_GESTURING_OK_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏿",
    codepoint: "1F646 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person gesturing OK: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙆\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_OK: crate::Emoji = crate::Emoji {
    glyph: "🙆\u{200d}♂\u{fe0f}",
    codepoint: "1F646 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing OK",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆\u{200d}♂",
        codepoint: "1F646 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing OK",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man wys als is goed"),
            keywords: &[
                "gebaar",
                "goed",
                "hand",
                "man",
                "man wys als is goed",
                "ok",
                "wys goed",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ምልክት ለእሺ ወንድ"),
            keywords: &["እሺ", "እጅ", "ወንድ", "የእጅ ምልክት", "የእጅ ምልክት ለእሺ ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موافق"),
            keywords: &["إشارة موافقة", "موافق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঠিক আছে ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "ঠিক",
                "ঠিক আছে ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ভঙ\u{9cd}গিম\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lehinə olan kişi"),
            keywords: &["jest", "kişi", "lehinə", "lehinə olan kişi", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына паказвае згоду"),
            keywords: &[
                "добра",
                "жэст",
                "мужчына",
                "мужчына за",
                "мужчына паказвае згоду",
                "ок",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж, правещ жест за „окей“"),
            keywords: &[
                "жест с ръка",
                "жест „да“",
                "мъж, правещ жест за „окей“",
                "потвърждение",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষের দেখ\u{9be}নো ঠিক আছে অঙ\u{9cd}গিভঙ\u{9cd}গি"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ঠিক আছে",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষের দেখ\u{9be}নো ঠিক আছে অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac pokazuje ok"),
            keywords: &[
                "gestikulacija",
                "muškarac",
                "muškarac pokazuje OK",
                "muškarac pokazuje ok",
                "odobravanje",
                "slaganje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home amb gest d’aprovació"),
            keywords: &["OK", "acord", "gest", "home amb gest d’aprovació", "mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏓᏐᏰᏍᎬ ᎭᏩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎤᏬᏱ", "ᎭᏩ", "ᏓᏐᏰᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž s gestem souhlasu"),
            keywords: &["ano", "muž", "muž s gestem souhlasu", "ok", "souhlas"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn ystumio iawn"),
            keywords: &["dyn", "dyn yn ystumio iawn", "iawn", "ok", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand signalerer ok"),
            keywords: &[
                "gestus",
                "i orden",
                "mand",
                "mand signalerer ok",
                "ok",
                "tilladt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann mit Händen auf dem Kopf"),
            keywords: &["Arme", "Gesicht", "Mann", "Mann mit Händen auf dem Kopf"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας συμφωνεί"),
            keywords: &["άντρας", "άντρας συμφωνεί", "εντάξει", "χειρονομία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man gesturing OK"),
            keywords: &["OK", "gesture", "hand", "man", "man gesturing OK"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre haciendo el gesto de \"de acuerdo\""),
            keywords: &[
                "OK",
                "gesto",
                "hombre haciendo el gesto de \"de acuerdo\"",
                "mano",
                "vale",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("hombre haciendo el gesto de OK"),
            keywords: &[
                "OK",
                "está bien",
                "gesto",
                "hombre",
                "hombre haciendo el gesto de OK",
                "mano",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nõustuvat žesti näitav mees"),
            keywords: &[
                "korras",
                "käed pea peal",
                "nõustuvat žesti näitav mees",
                "ok",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ados dagoela adierazten ari den gizona"),
            keywords: &[
                "ados",
                "ados dagoela adierazten ari den gizona",
                "esku",
                "gizon",
                "gizonezko",
                "keinu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد می\u{200c}پذیرد"),
            keywords: &[
                "اوکی",
                "باشه",
                "تأیید",
                "درست",
                "مرد می\u{200c}پذیرد",
                "ژشت موافقت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ok-merkkiä näyttävä mies"),
            keywords: &["ele", "kyllä", "mies", "ok", "ok-merkkiä näyttävä mies"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking kumukumpas na ok"),
            keywords: &["lalaki", "lalaking kumukumpas na ok", "okay", "oo", "pwede"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður sum veipar ok"),
            keywords: &["maður", "maður sum veipar ok", "ok", "veipar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme faisant un geste d’acceptation"),
            keywords: &[
                "geste d’accord",
                "homme",
                "homme faisant un geste d’acceptation",
                "main",
                "ok",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("homme faisant un geste d’affirmation"),
            keywords: &[
                "OK",
                "accord",
                "affirmation",
                "homme",
                "homme faisant un geste d’affirmation",
                "main",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear ag comharthú OK"),
            keywords: &[
                "ceart go leor",
                "cor",
                "fear",
                "fear a aontaíonn",
                "fear ag comharthú OK",
                "fearann",
                "lámh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine ag aontachadh ri rud"),
            keywords: &[
                "aontachadh",
                "duine",
                "duine ag aontachadh ri rud",
                "fear",
                "fireannach",
                "gluasad",
                "làmh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home coas mans na cabeza"),
            keywords: &[
                "aprobación",
                "home coas mans na cabeza",
                "hurra",
                "mans na cabeza",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ ઑક\u{ac7}નો હાવભાવ"),
            keywords: &[
                "ઑક\u{ac7} હાવભાવ",
                "ચહ\u{ac7}રો",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ ઑક\u{ac7}નો હાવભાવ",
                "બધ\u{ac1}\u{a82} બરાબર છ\u{ac7}",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji mai nunawa TO da hannu"),
            keywords: &[
                "TO",
                "mutum",
                "namiji mai nunawa TO da hannu",
                "nunawa da hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר עם הידיים על הראש"),
            keywords: &[
                "איש",
                "בסדר",
                "גבר",
                "גבר עם הידיים על הראש",
                "ידיים על הראש",
                "כן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठीक ह\u{948} कहता ह\u{941}आ प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "इशारा",
                "ठीक",
                "ठीक ह\u{948} कहता ह\u{941}आ प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac pokazuje \"u redu\""),
            keywords: &["gestikulacija", "muškarac pokazuje \"u redu\"", "u redu"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("beleegyezést mutató férfi"),
            keywords: &[
                "beleegyezés",
                "beleegyezést mutató férfi",
                "férfi",
                "gesztus",
                "kézmozdulat",
                "oké",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդը կողմ է"),
            keywords: &["ժեստ", "կողմ", "ձեռք", "տղամարդ", "տղամարդը կողմ է"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria mengisyaratkan OKE"),
            keywords: &[
                "isyarat",
                "laki-laki",
                "oke",
                "pria mengisyaratkan OKE",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-egosipta Ọ DỊ MMA"),
            keywords: &[
                "aka",
                "nwoke",
                "nwoke na-egosipta Ọ DỊ MMA",
                "ogbugbu",
                "Ọ DỊ MMA",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður segir allt í lagi"),
            keywords: &["já", "karl", "maður segir allt í lagi", "í lagi", "ókei"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo con gesto OK"),
            keywords: &["d’accordo", "gesto", "ok", "uomo", "uomo con gesto OK"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("OKのポーズをする男"),
            keywords: &[
                "OKのポーズをする男",
                "オッケー",
                "オーケー",
                "ジェスチャー",
                "丸",
                "男性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang ngisaratake OK"),
            keywords: &[
                "OK",
                "isarat",
                "tangan",
                "wong lanang",
                "wong lanang ngisaratake OK",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი ჟესტით „კარგი“"),
            keywords: &["ok", "კარგი", "კაცი", "კაცი ჟესტით „კარგი“", "ჟესტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құптап тұрған ер"),
            keywords: &["ер", "жақтау", "құптап тұрған ер", "құптау"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand signalerer ok"),
            keywords: &[
                "gestus",
                "i orden",
                "mand",
                "mand signalerer ok",
                "ok",
                "tilladt",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសចេញកាយវ\u{17b7}ការយល\u{17cb}ព\u{17d2}រម"),
            keywords: &[
                "កាយវ\u{17b7}ការ",
                "ប\u{17bb}រសចេញកាយវ\u{17b7}ការយល\u{17cb}ព\u{17d2}រម",
                "យល\u{17cb}ព\u{17d2}រម",
                "អន\u{17bb}ញ\u{17d2}ញាត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರ\u{cbf} ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ"),
            keywords: &[
                "ಅಂಗ ಸನ\u{ccd}ನ\u{cc6}",
                "ಕೈ",
                "ಪುರುಷ",
                "ಸರ\u{cbf}",
                "ಸರ\u{cbf} ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오케이라는 제스처를 하는 남자"),
            keywords: &[
                "OK",
                "손동작",
                "오케이",
                "오케이라는 제스처를 하는 남자",
                "좋아",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बर\u{947}\u{902} आसा असो हावभाव करपी दादलो"),
            keywords: &[
                "बर\u{947}\u{902} आसा असो हावभाव करपी दादलो",
                "हावभाव । हात । दादलो । बर\u{947}\u{902} आसा असो हावभाव करपी दादलो । बर\u{947}\u{902} आसा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«жарайт» деп жаткан эркек"),
            keywords: &["«жарайт» деп жаткан эркек", "макулдук", "ооба", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann, deen OK weist"),
            keywords: &["Geste", "Hand", "Mann", "Mann, deen OK weist", "OK"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າໂອເຄ"),
            keywords: &[
                "ທ\u{ec8}າທາງ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າໂອເຄ",
                "ມ\u{eb7}",
                "ແຂນ",
                "ໂອເຄ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("leidžiantis vyras"),
            keywords: &["gerai", "gestas", "leidžiantis vyras", "ranka", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis ar apstiprinājuma žestu"),
            keywords: &[
                "par",
                "piekrišana",
                "vīrietis",
                "vīrietis ar apstiprinājuma žestu",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tohu ana ĀE"),
            keywords: &["ringa", "tohu ā-ringa", "tāne", "tāne tohu ana ĀE", "ĀE"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж што одобрува"),
            keywords: &["гест", "дозволено", "маж", "маж што одобрува", "рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "സമ\u{d4d}മതമെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "സമ\u{d4d}മതം",
                "സമ\u{d4d}മതമെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүгээр гэж харуулж буй эрэгтэй"),
            keywords: &[
                "ТИЙМ",
                "ТИЙМ гэсэн дохио үзүүлж буй эрэгтэй",
                "гар",
                "дохио",
                "зүгээр гэж харуулж буй эрэгтэй",
                "эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठीक म\u{94d}हणणारा प\u{941}र\u{941}ष"),
            keywords: &[
                "ठीक",
                "ठीक आह\u{947} अस\u{947} हावभाव करणारा प\u{941}र\u{941}ष",
                "ठीक म\u{94d}हणणारा प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष",
                "हात",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki memberi isyarat ok"),
            keywords: &[
                "gerak isyarat",
                "lelaki",
                "lelaki memberi isyarat ok",
                "ok",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jagħmel sinjal ta’ OK"),
            keywords: &[
                "OK",
                "bl-idejn",
                "raġel",
                "raġel jagħmel sinjal ta’ OK",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အဆင\u{103a}ပြေကြောင\u{103a}း အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "လက\u{103a}",
                "အဆင\u{103a}ပြေကြောင\u{103a}း အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030} အမျ\u{102d}\u{102f}းသား",
                "အမ\u{1030}အရာ",
                "အမျ\u{102d}\u{102f}းသား",
                "အ\u{102d}\u{102f}ကေဟ\u{102f} အမ\u{1030}အရာလ\u{102f}ပ\u{103a}ပြနေသ\u{1030} အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann som gestikulerer OK"),
            keywords: &["greit", "mann", "mann som gestikulerer OK", "ok"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठीक भएको स\u{902}क\u{947}त दिन\u{947} छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "इसारा",
                "छोरामान\u{94d}छ\u{947}",
                "ठीक छ",
                "ठीक भएको स\u{902}क\u{947}त दिन\u{947} छोरामान\u{94d}छ\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man die OK-gebaar maakt"),
            keywords: &["OK", "gebaar", "hand", "man", "man die OK-gebaar maakt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann som gestikulerer OK"),
            keywords: &["greitt", "mann", "mann som gestikulerer OK", "ok"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ",
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଛ\u{b3f}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠੀਕ ਹ\u{a48} ਦਾ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਠੀਕ",
                "ਠੀਕ ਹ\u{a48} ਦਾ ਇਸ\u{a3c}ਾਰਾ ਕਰਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹھیک اے دا اشارہ کردا بندہ"),
            keywords: &[
                "اشارہ",
                "بندہ",
                "ٹھیک اے",
                "ٹھیک اے دا اشارہ کردا بندہ",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Tẹk Hand De Shó Sé Na OK I Min"),
            keywords: &[
                "Hand",
                "Man",
                "Man Tẹk Hand De Shó Sé Na OK I Min",
                "OK",
                "Pẹ\u{301}sin Wé Ték Hand De Shó Sé Na OK I Min",
                "Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna pokazujący „ojej!”"),
            keywords: &[
                "mężczyzna",
                "mężczyzna pokazujący „ojej!”",
                "ojej",
                "ręce",
                "zachwyt",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی د او کی اشاره کوي"),
            keywords: &["اشاره", "او کی", "سړی", "سړی د او کی اشاره کوي", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem fazendo gesto de “OK”"),
            keywords: &["OK", "gesto", "homem", "homem fazendo gesto de “OK”", "mão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem que faz gesto de OK"),
            keywords: &["gesto", "homem", "homem que faz gesto de OK", "mão", "ok"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata UYAKUY gestowan"),
            keywords: &["UYAKUY", "gesto", "maki", "tata", "tata UYAKUY gestowan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat făcând un gest de OK"),
            keywords: &["bărbat făcând un gest de OK", "gest", "mâini", "ok"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1213"),
            keywords: &["E10-1213"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина за"),
            keywords: &[
                "жест",
                "мужчина",
                "мужчина за",
                "ок",
                "окей",
                "отлично",
                "руки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo werekana ikimenyetso cya Yego"),
            keywords: &[
                "Ikimenyetso",
                "Yego",
                "ikiganza",
                "umugabo",
                "umugabo werekana ikimenyetso cya Yego",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد ٺيڪ جو اشارو ڪندي"),
            keywords: &["اشارو، هٿ، مرد، ٺيڪ", "مرد ٺيڪ جو اشارو ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2} බව පෙන\u{dca}වන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "අත",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "හර\u{dd2}",
                "හර\u{dd2} බව පෙන\u{dca}වන ම\u{dd2}න\u{dd2}ස\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž s\u{a0}rukami nad hlavou"),
            keywords: &["hlava", "muž", "muž s\u{a0}rukami nad hlavou", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški, ki s kretnjo izraža odobravanje"),
            keywords: &[
                "fant",
                "kretnja",
                "moški",
                "moški, ki s kretnjo izraža odobravanje",
                "ok",
                "roka",
                "v redu",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin ku meedaaraya HAA"),
            keywords: &["gacan", "meedaar", "nin", "nin ku meedaaraya HAA"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë që bën gjestin në rregull"),
            keywords: &[
                "burrë",
                "burrë që bën gjestin në rregull",
                "dorë",
                "gjest",
                "në rregull",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац показује „ок“"),
            keywords: &[
                "гестикулација",
                "мушкарац",
                "мушкарац показује „ок“",
                "ок",
                "руке",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac pokazuje „ok“"),
            keywords: &[
                "gestikulacija",
                "muškarac",
                "muškarac pokazuje „ok“",
                "ok",
                "ruke",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man gestikulerar OK"),
            keywords: &["gest", "gest för OK", "hand", "man gestikulerar OK", "okej"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("Mtu anayeonyesha ishara ya NDIO"),
            keywords: &[
                "Mtu anayeonyesha ishara ya NDIO",
                "ishara",
                "kukubali",
                "mwanamume anayeonyesha ishara ya kukubali",
                "ndiyo",
                "sawa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தலையில\u{bcd} கைகளை வைத\u{bcd}திருக\u{bcd}கும\u{bcd} ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "கை",
                "தலை",
                "தலையில\u{bcd} கைகளை வைத\u{bcd}திருக\u{bcd}கும\u{bcd} ஆண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "అంగ\u{c40}కర\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న పురుషుడు",
            ),
            keywords: &[
                "అంగ\u{c40}కర\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న పురుషుడు",
                "చ\u{c47}య\u{c3f}",
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "సంజ\u{c4d}ఞ",
                "సర\u{c47}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки \"ОК\" ишора карда истодааст"),
            keywords: &[
                "ОК",
                "даст",
                "имову ишора",
                "мард",
                "марде, ки \"ОК\" ишора карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายทำท\u{e48}าโอเค"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายทำท\u{e48}าโอเค",
                "ม\u{e37}อ",
                "โอเค",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Bolýar ümleýän erkek"),
            keywords: &["Bolýar ümleýän erkek", "bolýar", "el", "erkek", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata kaunima fetuiaki ʻolunga"),
            keywords: &["tangata kaunima fetuiaki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tamam hareketi yapan erkek"),
            keywords: &[
                "adam",
                "el",
                "erkek",
                "hareket",
                "tamam",
                "tamam hareketi yapan erkek",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ماقۇل دەپ ئىشارە قىلغان ئەر"),
            keywords: &[
                "ئىشارە",
                "ئەر",
                "قول",
                "ماقۇل",
                "ماقۇل دەپ ئىشارە قىلغان ئەر",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік, що жестом показує «окей»"),
            keywords: &[
                "добре",
                "згода",
                "ок",
                "чоловік",
                "чоловік, що жестом показує «окей»",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹھیک ہے کا اشارہ کرتا ہوا مرد"),
            keywords: &[
                "اجازت دینا",
                "اشارہ",
                "اوکے",
                "مرد",
                "ٹھیک ہے کا اشارہ کرتا ہوا مرد",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak ha demoqda"),
            keywords: &["erkak", "erkak ha demoqda", "ha", "imo-ishora", "qo‘l"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông ra hiệu đồng ý"),
            keywords: &["cử chỉ", "nam", "người đàn ông ra hiệu đồng ý", "ok", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor buy liyaar waaw-kay"),
            keywords: &[
                "góor",
                "góor buy liyaar waaw-kay",
                "liyaar",
                "loxo",
                "waaw-kay",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda ejekula ukuthi Kulungile"),
            keywords: &[
                "Kulungile",
                "indoda",
                "indoda ejekula ukuthi Kulungile",
                "isandla",
                "jekula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tí ń sọ ÓDÁRA"),
            keywords: &[
                "fowọ\u{301}júwé",
                "ÓDÁRA",
                "ọkùnrin",
                "ọkùnrin tí ń sọ ÓDÁRA",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做 OK 手勢嘅男人"),
            keywords: &["OK", "做 OK 手勢嘅男人", "手", "手勢", "男"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做 OK 手势嘅男人"),
            keywords: &["OK", "做 OK 手势嘅男人", "手", "手势", "男"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("OK手势男"),
            keywords: &["OK", "OK手势男", "可以", "同意", "好的", "男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生手比圈"),
            keywords: &["OK", "可以", "圈", "男生手比圈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("用手勢表示 OK 嘅男人"),
            keywords: &["OK", "可以｜男人｜手勢", "用手勢表示 OK 嘅男人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesilisa oveza ukuthi kulungile"),
            keywords: &[
                "indoda",
                "isandla",
                "kulungile",
                "owesilisa oveza ukuthi kulungile",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙆🏻\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_OK_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F646 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing OK: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏻\u{200d}♂",
        codepoint: "1F646 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing OK: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏼\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F646 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing OK: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏼\u{200d}♂",
        codepoint: "1F646 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing OK: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏽\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_OK_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F646 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing OK: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏽\u{200d}♂",
        codepoint: "1F646 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing OK: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏾\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F646 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing OK: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏾\u{200d}♂",
        codepoint: "1F646 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing OK: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏿\u{200d}♂\u{fe0f}"]
pub const MAN_GESTURING_OK_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F646 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man gesturing OK: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏿\u{200d}♂",
        codepoint: "1F646 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man gesturing OK: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_OK: crate::Emoji = crate::Emoji {
    glyph: "🙆\u{200d}♀\u{fe0f}",
    codepoint: "1F646 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing OK",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆\u{200d}♀",
        codepoint: "1F646 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing OK",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou wys als is goed"),
            keywords: &[
                "gebaar",
                "goed",
                "hand",
                "ok",
                "vrou",
                "vrou wys als is goed",
                "wys goed",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ ምልክት ለእሺ ሴት"),
            keywords: &["ሴት", "እሺ", "እጅ", "የእጅ ምልክት", "የእጅ ምልክት ለእሺ ሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("موافقة"),
            keywords: &["إشارة موافقة", "موافقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঠিক আছে ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "ঠিক",
                "ঠিক আছে ভঙ\u{9cd}গিম\u{9be} দেখ\u{9c1}ওৱ\u{9be} মহিল\u{9be}",
                "ভঙ\u{9cd}গিম\u{9be}",
                "মহিল\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("lehinə olan qadın"),
            keywords: &["jest", "lehinə", "lehinə olan qadın", "qadın", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына паказвае згоду"),
            keywords: &[
                "добра",
                "жанчына",
                "жанчына за",
                "жанчына паказвае згоду",
                "жэст",
                "ок",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена, правеща жест за „окей“"),
            keywords: &[
                "жена, правеща жест за „окей“",
                "жест с ръка",
                "жест „да“",
                "потвърждение",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}র দেখ\u{9be}নো ঠিক আছে অঙ\u{9cd}গিভঙ\u{9cd}গি"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ঠিক আছে",
                "মহিল\u{9be}",
                "মহিল\u{9be}র দেখ\u{9be}নো ঠিক আছে অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena pokazuje ok"),
            keywords: &[
                "gestikulacija",
                "odobravanje",
                "slaganje",
                "žena",
                "žena pokazuje OK",
                "žena pokazuje ok",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona amb gest d’aprovació"),
            keywords: &["OK", "acord", "dona amb gest d’aprovació", "gest", "mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏓᏐᏰᏍᎬ ᎭᏩ"),
            keywords: &["ᎠᎨᏯ", "ᎤᏬᏱ", "ᎭᏩ", "ᏓᏐᏰᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena s gestem souhlasu"),
            keywords: &["ano", "ok", "souhlas", "žena", "žena s gestem souhlasu"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn ystumio iawn"),
            keywords: &["iawn", "menyw", "menyw yn ystumio iawn", "ok", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde signalerer ok"),
            keywords: &[
                "gestus",
                "i orden",
                "kvinde",
                "kvinde signalerer ok",
                "ok",
                "tilladt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau mit Händen auf dem Kopf"),
            keywords: &["Arme", "Frau", "Frau mit Händen auf dem Kopf", "Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα συμφωνεί"),
            keywords: &["γυναίκα", "γυναίκα συμφωνεί", "εντάξει", "χειρονομία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman gesturing OK"),
            keywords: &["OK", "gesture", "hand", "woman", "woman gesturing OK"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer haciendo el gesto de \"de acuerdo\""),
            keywords: &[
                "OK",
                "gesto",
                "mano",
                "mujer haciendo el gesto de \"de acuerdo\"",
                "vale",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mujer haciendo el gesto de OK"),
            keywords: &[
                "OK",
                "está bien",
                "gesto",
                "mano",
                "mujer",
                "mujer haciendo el gesto de OK",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nõustuvat žesti näitav naine"),
            keywords: &[
                "korras",
                "käed pea peal",
                "nõustuvat žesti näitav naine",
                "ok",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ados dagoela adierazten ari den emakumea"),
            keywords: &[
                "ados",
                "ados dagoela adierazten ari den emakumea",
                "emakume",
                "emakumezko",
                "esku",
                "keinu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن می\u{200c}پذیرد"),
            keywords: &[
                "اوکی",
                "باشه",
                "تأیید",
                "درست",
                "زن می\u{200c}پذیرد",
                "ژشت موافقت",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ok-merkkiä näyttävä nainen"),
            keywords: &["ele", "kyllä", "nainen", "ok", "ok-merkkiä näyttävä nainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng kumukumpas na ok"),
            keywords: &["babae", "babaeng kumukumpas na ok", "okay", "oo", "pwede"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna sum veipar ok"),
            keywords: &["kona", "kvinna", "kvinna sum veipar ok", "ok", "veipar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme faisant un geste d’acceptation"),
            keywords: &[
                "femme",
                "femme faisant un geste d’acceptation",
                "geste d’accord",
                "main",
                "ok",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("femme faisant un geste d’affirmation"),
            keywords: &[
                "OK",
                "accord",
                "affirmation",
                "femme",
                "femme faisant un geste d’affirmation",
                "main",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean ag comharthú OK"),
            keywords: &[
                "baineann",
                "bean",
                "bean a aontaíonn",
                "bean ag comharthú OK",
                "ceart go leor",
                "cor",
                "lámh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach ag aontachadh ri rud"),
            keywords: &[
                "aontachadh",
                "boireannach",
                "boireannach ag aontachadh ri rud",
                "gluasad",
                "làmh",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller coas mans na cabeza"),
            keywords: &[
                "aprobación",
                "hurra",
                "mans na cabeza",
                "muller coas mans na cabeza",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી, ઑક\u{ac7}નો હાવભાવ"),
            keywords: &[
                "ઑક\u{ac7} હાવભાવ",
                "ચહ\u{ac7}રો",
                "બધ\u{ac1}\u{a82} બરાબર છ\u{ac7}",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી, ઑક\u{ac7}નો હાવભાવ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai nunawa TO da hannu"),
            keywords: &[
                "TO",
                "hannu",
                "karimcin",
                "mace",
                "mace mai nunawa TO da hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה עם הידיים על הראש"),
            keywords: &[
                "אישה",
                "אישה עם הידיים על הראש",
                "בסדר",
                "ידיים על הראש",
                "כן",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठीक ह\u{948} कहती ह\u{941}ई महिला"),
            keywords: &[
                "इशारा",
                "ठीक",
                "ठीक ह\u{948} कहती ह\u{941}ई महिला",
                "महिला",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena pokazuje \"u redu\""),
            keywords: &["gestikulacija", "u redu", "žena pokazuje \"u redu\""],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("beleegyezést mutató nő"),
            keywords: &[
                "beleegyezés",
                "beleegyezést mutató nő",
                "gesztus",
                "kézmozdulat",
                "nő",
                "oké",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կինը կողմ է"),
            keywords: &["ժեստ", "կին", "կինը կողմ է", "կողմ", "ձեռք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita mengisyaratkan OKE"),
            keywords: &[
                "isyarat",
                "oke",
                "perempuan",
                "tangan",
                "wanita mengisyaratkan OKE",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-egosipta Ọ DỊ MMA"),
            keywords: &[
                "aka",
                "nwanyị",
                "nwanyị na-egosipta Ọ DỊ MMA",
                "ogbugbu",
                "Ọ DỊ MMA",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona segir allt í lagi"),
            keywords: &["já", "kona", "kona segir allt í lagi", "í lagi", "ókei"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna con gesto OK"),
            keywords: &["donna", "donna con gesto OK", "d’accordo", "gesto", "ok"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("OKのポーズをする女"),
            keywords: &[
                "OKのポーズをする女",
                "オッケー",
                "オーケー",
                "ジェスチャー",
                "丸",
                "女性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon ngisaratake OK"),
            keywords: &[
                "OK",
                "isarat",
                "tangan",
                "wong wadon",
                "wong wadon ngisaratake OK",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი ჟესტით „კარგი“"),
            keywords: &["ok", "კარგი", "ჟესტი", "ქალი", "ქალი ჟესტით „კარგი“"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құптап тұрған әйел"),
            keywords: &["жақтау", "құптап тұрған әйел", "құптау", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde signalerer ok"),
            keywords: &[
                "gestus",
                "i orden",
                "kvinde",
                "kvinde signalerer ok",
                "ok",
                "tilladt",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}ចេញកាយវ\u{17b7}ការយល\u{17cb}ព\u{17d2}រម"),
            keywords: &[
                "កាយវ\u{17b7}ការ",
                "នារ\u{17b8}ចេញកាយវ\u{17b7}ការយល\u{17cb}ព\u{17d2}រម",
                "យល\u{17cb}ព\u{17d2}រម",
                "អន\u{17bb}ញ\u{17d2}ញាត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರ\u{cbf} ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ"),
            keywords: &[
                "ಅಂಗ ಸನ\u{ccd}ನ\u{cc6}",
                "ಕೈ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸರ\u{cbf}",
                "ಸರ\u{cbf} ಎನ\u{ccd}ನುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오케이라는 제스처를 하는 여자"),
            keywords: &[
                "OK",
                "손동작",
                "오케이",
                "오케이라는 제스처를 하는 여자",
                "좋아",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बर\u{947}\u{902} आसा असो हावभाव करपी बायल"),
            keywords: &[
                "बर\u{947}\u{902} आसा असो हावभाव करपी बायल",
                "हावभाव । हात । बर\u{947}\u{902} आसा । बायल । बर\u{947}\u{902} आसा असो हावभाव करपी बायल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«жарайт» деп жаткан аял"),
            keywords: &["«жарайт» деп жаткан аял", "аял", "макулдук", "ооба"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra, déi OK weist"),
            keywords: &["Fra", "Fra, déi OK weist", "Geste", "Hand", "OK"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າໂອເຄ"),
            keywords: &[
                "ທ\u{ec8}າທາງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເຮ\u{eb1}ດມ\u{eb7}ວ\u{ec8}າໂອເຄ",
                "ມ\u{eb7}",
                "ແຂນ",
                "ໂອເຄ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("leidžianti moteris"),
            keywords: &["gerai", "gestas", "leidžianti moteris", "moteris", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete ar apstiprinājuma žestu"),
            keywords: &[
                "par",
                "piekrišana",
                "sieviete",
                "sieviete ar apstiprinājuma žestu",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tohu ana ĀE"),
            keywords: &[
                "ringa",
                "tohu ā-ringa",
                "wahine",
                "wahine tohu ana ĀE",
                "ĀE",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена што одобрува"),
            keywords: &["гест", "дозволено", "жена", "жена што одобрува", "рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "സമ\u{d4d}മതമെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "സമ\u{d4d}മതം",
                "സമ\u{d4d}മതമെന\u{d4d}ന\u{d4d} ആംഗ\u{d4d}യം ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүгээр гэж харуулж буй эмэгтэй"),
            keywords: &[
                "ТИЙМ",
                "ТИЙМ гэсэн дохио үзүүлж буй эмэгтэй",
                "гар",
                "дохио",
                "зүгээр гэж харуулж буй эмэгтэй",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठीक म\u{94d}हणणारी महिला"),
            keywords: &[
                "ठीक",
                "ठीक आह\u{947} अस\u{947} हावभाव करणारी महिला",
                "ठीक म\u{94d}हणणारी महिला",
                "महिला",
                "हात",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan memberi isyarat ok"),
            keywords: &[
                "gerak isyarat",
                "ok",
                "perempuan",
                "perempuan memberi isyarat ok",
                "tangan",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara tagħmel sinjal ta’ OK"),
            keywords: &[
                "OK",
                "bl-idejn",
                "mara",
                "mara tagħmel sinjal ta’ OK",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အဆင\u{103a}ပြေကြောင\u{103a}း အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "လက\u{103a}",
                "အဆင\u{103a}ပြေကြောင\u{103a}း အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမ\u{1030}အရာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အ\u{102d}\u{102f}ကေ",
                "အ\u{102d}\u{102f}ကေဟ\u{102f} အမ\u{1030}အရာ လ\u{102f}ပ\u{103a}ပြနေသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne som gestikulerer OK"),
            keywords: &["greit", "kvinne", "kvinne som gestikulerer OK", "ok"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठीक भएको स\u{902}\u{902}क\u{947}त दिन\u{947} छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "इसारा",
                "छोरीमान\u{94d}छ\u{947}",
                "ठीक छ",
                "ठीक भएको स\u{902}\u{902}क\u{947}त दिन\u{947} छोरीमान\u{94d}छ\u{947}",
                "ठीक भएको स\u{902}क\u{947}त दिन\u{947} छोरीमान\u{94d}छ\u{947}",
                "महिला",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw die OK-gebaar maakt"),
            keywords: &["OK", "gebaar", "hand", "vrouw", "vrouw die OK-gebaar maakt"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne som gestikulerer OK"),
            keywords: &["greitt", "kvinne", "kvinne som gestikulerer OK", "ok"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ ଦେଖ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}",
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଛ\u{b3f}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠੀਕ ਹ\u{a48} ਦਾ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਇਸਤਰੀ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਔਰਤ",
                "ਠੀਕ",
                "ਠੀਕ ਹ\u{a48} ਦਾ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਇਸਤਰੀ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹھیک اے دا اشارہ کردی زنانی"),
            keywords: &[
                "اشارہ",
                "زنانی",
                "ٹھیک اے",
                "ٹھیک اے دا اشارہ کردی زنانی",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Tẹk Hand De Shó Sé Na OK I Min"),
            keywords: &[
                "Hand",
                "OK",
                "Sain",
                "Wúman",
                "Wúman Tẹk Hand De Shó Sé Na OK I Min",
                "Wúman Wé Ték Hand De Shó Sé Na OK I Min",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta pokazująca gest OK"),
            keywords: &["kobieta", "kobieta pokazująca gest OK", "ręce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه د او کی اشاره کوي"),
            keywords: &["اشاره", "او کی", "لاس", "ښځه", "ښځه د او کی اشاره کوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher fazendo gesto de “OK”"),
            keywords: &[
                "OK",
                "gesto",
                "mulher",
                "mulher fazendo gesto de “OK”",
                "mão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher que faz gesto de OK"),
            keywords: &["gesto", "mulher", "mulher que faz gesto de OK", "mão", "ok"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi UYAKUY gestowan"),
            keywords: &["UYAKUY", "gesto", "maki", "warmi", "warmi UYAKUY gestowan"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie făcând un gest de OK"),
            keywords: &["femeie făcând un gest de OK", "gest", "mâini", "ok"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1212"),
            keywords: &["E10-1212"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина за"),
            keywords: &[
                "женщина",
                "женщина за",
                "жест",
                "ок",
                "окей",
                "отлично",
                "руки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore werekana ikimenyetso cya Yego"),
            keywords: &[
                "Ikimenyetso",
                "Yego",
                "ikiganza",
                "umugore",
                "umugore werekana ikimenyetso cya Yego",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت ٺيڪ جو اشارو ڪندي"),
            keywords: &["اشارو، هٿ، ٺيڪ، عورت", "عورت ٺيڪ جو اشارو ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2} බව පෙන\u{dca}වන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "අත",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
                "හර\u{dd2}",
                "හර\u{dd2} බව පෙන\u{dca}වන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žena s\u{a0}rukami nad hlavou"),
            keywords: &["hlava", "ruka", "žena", "žena s\u{a0}rukami nad hlavou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska, ki s kretnjo izraža odobravanje"),
            keywords: &[
                "dekle",
                "kretnja",
                "ok",
                "roka",
                "v redu",
                "ženska",
                "ženska, ki s kretnjo izraža odobravanje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("haweeney ku meedaaraysa MAYA"),
            keywords: &[
                "gacan } HAA",
                "haweeney ku meedaaraysa MAYA",
                "meedaar",
                "naag",
                "naag ku meedaaraysa HAA",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua që bën gjestin në rregull"),
            keywords: &[
                "dorë",
                "gjest",
                "grua",
                "grua që bën gjestin në rregull",
                "në rregull",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена показује „ок“"),
            keywords: &["гестикулација", "жена", "жена показује „ок“", "ок", "руке"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena pokazuje „ok“"),
            keywords: &["gestikulacija", "ok", "ruke", "žena", "žena pokazuje „ok“"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinna gestikulerar OK"),
            keywords: &[
                "gest",
                "gest för OK",
                "hand",
                "kvinna gestikulerar OK",
                "okej",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke anayeonyesha ishara ya kukubali"),
            keywords: &[
                "ishara",
                "kukubali",
                "mwanamke anayeonyesha ishara ya kukubali",
                "ndiyo",
                "sawa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("தலையில\u{bcd} கைகளை வைத\u{bcd}திருக\u{bcd}கும\u{bcd} பெண\u{bcd}"),
            keywords: &[
                "கை",
                "தலை",
                "தலையில\u{bcd} கைகளை வைத\u{bcd}திருக\u{bcd}கும\u{bcd} பெண\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "అంగ\u{c40}కర\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}",
            ),
            keywords: &[
                "అంగ\u{c40}కర\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను అన\u{c3f} చ\u{c46}బుతున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "చ\u{c47}య\u{c3f}",
                "మహ\u{c3f}ళ",
                "సంజ\u{c4d}ఞ",
                "సర\u{c47}",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки \"ОК\" ишора карда истодааст"),
            keywords: &[
                "ОК",
                "даст",
                "зан",
                "зане, ки \"ОК\" ишора карда истодааст",
                "имову ишора",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งทำท\u{e48}าโอเค"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งทำท\u{e48}าโอเค",
                "ม\u{e37}อ",
                "โอเค",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Bolýar ümleýän zenan"),
            keywords: &["Bolýar ümleýän zenan", "bolýar", "el", "zenan", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine kaunima fetuiaki ʻolunga"),
            keywords: &["fefine kaunima fetuiaki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tamam hareketi yapan kadın"),
            keywords: &[
                "bayan",
                "el",
                "hareket",
                "kadın",
                "tamam",
                "tamam hareketi yapan kadın",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ماقۇل دەپ ئىشارە قىلغان ئايال"),
            keywords: &[
                "ئايال",
                "ئىشارە",
                "قول",
                "ماقۇل",
                "ماقۇل دەپ ئىشارە قىلغان ئايال",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка, що жестом показує «окей»"),
            keywords: &[
                "добре",
                "жінка",
                "жінка, що жестом показує «окей»",
                "згода",
                "ок",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹھیک ہے کا اشارہ کرتی ہوئی عورت"),
            keywords: &[
                "اجازت دینا",
                "اشارہ",
                "اوکے",
                "عورت",
                "ٹھیک ہے کا اشارہ کرتی ہوئی عورت",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol ha demoqda"),
            keywords: &["ayol", "ayol ha demoqda", "ha", "imo-ishora", "qo‘l"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ ra hiệu đồng ý"),
            keywords: &[
                "cử chỉ",
                "người phụ nữ ra hiệu đồng ý",
                "người đàn ông ra hiệu đồng ý",
                "nữ",
                "ok",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen juy liyaar waaw-kay"),
            keywords: &[
                "jigéen",
                "jigéen juy liyaar waaw-kay",
                "liyaar",
                "loxo",
                "waaw-kay",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elijekula ukuthi Kulungile"),
            keywords: &[
                "Kulungile",
                "ibhinqa",
                "ibhinqa elijekula ukuthi Kulungile",
                "isandla",
                "jekula",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń sọ ÓDÁRA"),
            keywords: &[
                "fowọ\u{301}júwè",
                "obìnrin",
                "obìnrin tí ń sọ ÓDÁRA",
                "ÓDÁRA",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做 OK 手勢嘅女人"),
            keywords: &["OK", "做 OK 手勢嘅女人", "女", "手", "手勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做 OK 手势嘅女人"),
            keywords: &["OK", "做 OK 手势嘅女人", "女", "手", "手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("OK手势女"),
            keywords: &["OK", "OK手势女", "可以", "同意", "女", "好的"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生手比圈"),
            keywords: &["OK", "可以", "圈", "女生手比圈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("用手勢表示 OK 嘅女人"),
            keywords: &["OK", "可以｜女人｜手勢", "用手勢表示 OK 嘅女人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame oveza ukuthi kulungile"),
            keywords: &[
                "isandla",
                "kulungile",
                "owesimame oveza ukuthi kulungile",
                "owesmame",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙆🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_OK_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F646 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing OK: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏻\u{200d}♀",
        codepoint: "1F646 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing OK: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_OK_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F646 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing OK: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏼\u{200d}♀",
        codepoint: "1F646 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing OK: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_OK_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F646 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing OK: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏽\u{200d}♀",
        codepoint: "1F646 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing OK: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_OK_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F646 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing OK: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏾\u{200d}♀",
        codepoint: "1F646 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing OK: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙆🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_GESTURING_OK_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙆🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F646 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman gesturing OK: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙆🏿\u{200d}♀",
        codepoint: "1F646 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman gesturing OK: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁"]
pub const PERSON_TIPPING_HAND: crate::Emoji = crate::Emoji {
    glyph: "💁",
    codepoint: "1F481",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person tipping hand",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon hou hand geknak"),
            keywords: &[
                "fooitjie",
                "hand",
                "help",
                "inligting",
                "persoon hou hand geknak",
                "persoon wat hand geknak hou",
                "skrander",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መረጃ ሰጪ ግለሰብ"),
            keywords: &["መረጃ", "መረጃ ሰጪ", "መረጃ ሰጪ ግለሰብ", "እጅ", "እገዛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}شخص بيد مائلة"),
            keywords: &["أشخاص", "مساعدة", "معلومات", "\u{202b}شخص بيد مائلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তথ\u{9cd}য ডেস\u{9cd}কৰ ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "তথ\u{9cd}য",
                "তথ\u{9cd}য ডেস\u{9cd}কৰ ব\u{9cd}যক\u{9cd}তি",
                "প\u{9cd}ৰ\u{9be}ণৱন\u{9cd}ত",
                "সহ\u{9be}য\u{9bc}",
                "হ\u{9be}ত",
                "হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("məlumat verən şəxs"),
            keywords: &[
                "davranışsız",
                "kömək",
                "məlumat",
                "məlumat verən şəxs",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек трасе рукой"),
            keywords: &[
                "бойкі",
                "дапамога",
                "рука",
                "чалавек трасе рукой",
                "інфармацыя",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Човек от информационна служба"),
            keywords: &[
                "Човек от информационна служба",
                "информация",
                "помощ",
                "ръка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("তথ\u{9cd}য ডেস\u{9cd}কের ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "তথ\u{9cd}য",
                "তথ\u{9cd}য ডেস\u{9cd}কের ব\u{9cd}যক\u{9cd}তি",
                "প\u{9cd}র\u{9be}ণবন\u{9cd}ত",
                "সহ\u{9be}য\u{9bc}ত\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba otkriva namjere"),
            keywords: &[
                "gestikulacija",
                "informacija",
                "osoba otkriva namjere",
                "pomoć",
                "ruke",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona amb mà inclinada cap amunt"),
            keywords: &[
                "ajuda",
                "flexió",
                "informació",
                "mà",
                "persona amb mà inclinada cap amunt",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎬᏂᎨᏒ ᏂᎬᏁᎲ ᏆᏂᏲᏍᏗ"),
            keywords: &[
                "ᎠᎵᏍᏕᎸᏗ",
                "ᎤᎵᏍᎦᏂᏏ",
                "ᎤᏘᏌᏗ",
                "ᎤᏬᏱ",
                "ᎬᎧᏃᎮᏗ",
                "ᏴᏫ ᎬᏂᎨᏒ ᏂᎬᏁᎲ ᏆᏂᏲᏍᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba s dlaní vzhůru"),
            keywords: &[
                "concierge",
                "drzost",
                "informace",
                "ironie",
                "osoba s dlaní vzhůru",
                "pomoc",
                "poslíček",
                "recepce",
                "recepční",
                "ruka",
                "sarkasmus",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn gwyro llaw"),
            keywords: &[
                "gwybodaeth",
                "help",
                "llaw",
                "person yn gwyro llaw",
                "tipio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("person vender håndfladen op"),
            keywords: &["hjælp", "person vender håndfladen op"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Infoschalter-Mitarbeiter(in)"),
            keywords: &[
                "Gesicht",
                "Hilfe",
                "Informationen",
                "Infoschalter-Mitarbeiter(in)",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο προσφέρει"),
            keywords: &[
                "άτομο προσφέρει",
                "βοήθεια",
                "πληροφορίες",
                "πρόσχαρος",
                "χέρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person tipping hand"),
            keywords: &[
                "hand",
                "help",
                "information",
                "person tipping hand",
                "sassy",
                "tipping",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona de mostrador de información"),
            keywords: &[
                "información",
                "mano",
                "mostrador",
                "persona",
                "persona de mostrador de información",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona de mostrador de información"),
            keywords: &[
                "información",
                "mesa",
                "persona",
                "persona de mostrador de información",
                "persona en mostrador de información",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("persona en mostrador de información"),
            keywords: &[
                "ayuda",
                "información",
                "mano",
                "persona",
                "persona en mostrador de información",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("infoleti töötaja"),
            keywords: &["abi", "info", "infoleti töötaja", "käsi", "teave"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskean dabilen pertsona"),
            keywords: &[
                "eskean dabilen pertsona",
                "esku",
                "eskupeko",
                "informazio",
                "kokin",
                "laguntza",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آماده کمک"),
            keywords: &["آماده کمک", "اطلاعات", "دست", "سرزنده", "کمک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kämmentä ylöspäin näyttävä henkilö"),
            keywords: &[
                "apu",
                "info",
                "kämmentä ylöspäin näyttävä henkilö",
                "käsi",
                "nenäkäs",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong nakatikwas ang kamay"),
            keywords: &[
                "impormasyon",
                "kamay",
                "tao sa information desk",
                "taong nakatikwas ang kamay",
                "tulong",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur sum nertir við"),
            keywords: &["fólk", "nertir við", "persónur", "persónur sum nertir við"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne paume vers le haut"),
            keywords: &["aide", "information", "main", "personne paume vers le haut"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("personne au guichet"),
            keywords: &[
                "aide",
                "information",
                "main",
                "personne au guichet",
                "personne paume vers le haut",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine lena lámh amach"),
            keywords: &["deasc faisnéise", "duine lena lámh amach", "faisnéis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach le làmh sìnte a-mach, bas air uachdar"),
            keywords: &[
                "bas",
                "cobhair",
                "fiosrachadh",
                "làmh",
                "neach le làmh sìnte a-mach, bas air uachdar",
                "sìnte",
                "taic",
                "uachdar",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa coa man medio levantada"),
            keywords: &[
                "asistencia",
                "axuda",
                "información",
                "man",
                "medio levantada",
                "persoa coa man medio levantada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માહિતી આપતી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "માહિતી",
                "માહિતી આપતી વ\u{acd}યક\u{acd}તિ",
                "માહિતી ડ\u{ac7}સ\u{acd}ક",
                "લોકો",
                "સહાય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum hannu mai ba da ci-goro"),
            keywords: &[
                "bayani",
                "bayar da ci-goro",
                "hannu",
                "mutum hannu mai ba da ci-goro",
                "taimako",
                "ƙarfin zuciya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם בדלפק מידע או מבקש טיפ"),
            keywords: &[
                "אדם בדלפק מידע או מבקש טיפ",
                "דלפק מידע",
                "חוצפה",
                "טיפ",
                "יד",
                "מידע",
                "עזרה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}चना क\u{947}\u{902}द\u{94d}र का व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "लोग",
                "सहायता",
                "स\u{942}चना",
                "स\u{942}चना क\u{947}\u{902}द\u{94d}र",
                "स\u{942}चना क\u{947}\u{902}द\u{94d}र का व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba s nagnutim dlanom"),
            keywords: &["informacije", "osoba s nagnutim dlanom", "pomoć", "ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ember az információs pultnál"),
            keywords: &[
                "ember az információs pultnál",
                "információ",
                "kéz",
                "segítség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տեղեկատու բյուրոյի աշխատող"),
            keywords: &[
                "հանդուգն",
                "ձեռք",
                "տեղեկատու բյուրոյի աշխատող",
                "տեղեկատվություն",
                "օգնել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang menengadahkan tangan"),
            keywords: &[
                "bantuan",
                "informasi",
                "orang menengadahkan tangan",
                "resepsionis",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-ehulata aka"),
            keywords: &[
                "aka",
                "na-ehulata",
                "onye na-ehulata aka",
                "ozi",
                "sassy",
                "ènyèmaka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("upplýsingaborð"),
            keywords: &["aðstoð", "fólk", "hjálp", "upplýsingaborð", "upplýsingar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona al punto informazioni"),
            keywords: &[
                "assistenza",
                "informazioni",
                "persona al punto informazioni",
                "persone",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("案内する人"),
            keywords: &["受付", "受付嬢", "案内", "案内する人", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong tangane anyangga"),
            keywords: &[
                "anyangga",
                "informasi",
                "nggaya",
                "pitulungan",
                "tangan",
                "wong tangane anyangga",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("საინფორმაციო დახლის თანამშრომელი"),
            keywords: &[
                "დახმარება",
                "ინფორმაცია",
                "საინფორმაციო დახლის თანამშრომელი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақпарат орталығы"),
            keywords: &["ақпарат", "ақпарат орталығы", "дөрекі", "жәрдем", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("information"),
            keywords: &["hjælp", "information"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សបង\u{17d2}ហើបព\u{17d0}ត\u{17cc}មាន"),
            keywords: &[
                "ជ\u{17bd}យ",
                "ដៃ",
                "បញ\u{17d2}ចេញព\u{17d0}ត\u{17cc}មាន",
                "ប\u{17d2}រាប\u{17cb}ព\u{17d0}ត\u{17cc}មាន",
                "ព\u{17d0}ត\u{17cc}មាន",
                "មន\u{17bb}ស\u{17d2}សបង\u{17d2}ហើបព\u{17d0}ត\u{17cc}មាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಾಹ\u{cbf}ತ\u{cbf} ಡ\u{cc6}ಸ\u{ccd}ಕ\u{ccd} ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಕೈ",
                "ಮಾಹ\u{cbf}ತ\u{cbf} ಡ\u{cc6}ಸ\u{ccd}ಕ\u{ccd} ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಸಹಾಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손바닥 꺾은 사람"),
            keywords: &["데스크 안내원", "손바닥 꺾은 사람", "안내 데스크"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायर हात वयर काडटा"),
            keywords: &[
                "आदार",
                "ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा",
                "ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा करपी व\u{94d}यक\u{94d}ती",
                "बायर हात वयर काडटा",
                "ब\u{947}बनाव",
                "म\u{94d}हायती",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("маалымат тактасындагы адам"),
            keywords: &[
                "жардам",
                "кол",
                "маалымат",
                "маалымат тактасындагы адам",
                "орой",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun, déi d’Hand op hält"),
            keywords: &[
                "Hand",
                "Hëllef",
                "Informatiounen",
                "Persoun, déi d’Hand op hält",
                "frech",
                "ophalen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂຕະສອບຖາມຂ\u{ecd}\u{ec9}ມ\u{eb9}ນ"),
            keywords: &[
                "ຂ\u{ecd}\u{ec9}ມ\u{eb9}ນ",
                "ຊ\u{ec8}ວຍເຫ\u{ebc}\u{eb7}ອ",
                "ສອບຖາມ",
                "ໂຕະ",
                "ໂຕະສອບຖາມຂ\u{ecd}\u{ec9}ມ\u{eb9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("informacijos skyriaus darbuotojas"),
            keywords: &[
                "informacija",
                "informacijos skyriaus darbuotojas",
                "pagalba",
                "ranka",
                "įžūlus",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("persona ar pastieptu roku"),
            keywords: &[
                "informācija",
                "palīdzība",
                "pastiept",
                "persona ar pastieptu roku",
                "roka",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata ringa tāringi"),
            keywords: &[
                "mōhiohio",
                "ringa",
                "tangata ringa tāringi",
                "tāringi",
                "whakatete",
                "āwhina",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со феминизиран гест"),
            keywords: &["информации", "лице со феминизиран гест", "помош", "рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിവരങ\u{d4d}ങൾ നൽക\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ആള\u{d41}കൾ",
                "ഉത\u{d4d}സ\u{d3e}ഹം",
                "കൈ",
                "വിവര ഡെസ\u{d4d}\u{200c}ക\u{d4d}ക\u{d4d}",
                "വിവരം",
                "വിവരങ\u{d4d}ങൾ നൽക\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി",
                "സഹ\u{d3e}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мэдээллийн ажилтан"),
            keywords: &["ажилтан", "мэдээллийн ажилтан", "мэдээлэл", "эмэгтэй хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("माहिती द\u{947}णारी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "खट\u{94d}याळ",
                "टिप द\u{947}णारी व\u{94d}यक\u{94d}ती",
                "टिप द\u{947}ण\u{947}",
                "मदत",
                "माहिती",
                "माहिती द\u{947}णारी व\u{94d}यक\u{94d}ती",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pegawai kaunter pertanyaan"),
            keywords: &[
                "bantu",
                "berani",
                "maklumat",
                "pegawai kaunter pertanyaan",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tbaxxi idha"),
            keywords: &[
                "għajnuna",
                "idha",
                "l-informazzjoni",
                "persuna tbaxxi idha",
                "tbaxxi",
                "tost",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသ\u{1030}"),
            keywords: &[
                "က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသ\u{1030}",
                "စ\u{102f}\u{1036}စမ\u{103a}းရေး",
                "လက\u{103a}",
                "အက\u{1030}အည\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjelpende person"),
            keywords: &["hjelp", "hjelpende person", "informasjon", "menneske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}चना ड\u{947}स\u{94d}कको व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "मद\u{94d}दत जानकारी",
                "स\u{942}चना ड\u{947}स\u{94d}कको व\u{94d}यक\u{94d}ति",
                "स\u{94d}यास\u{94d}सी",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon achter informatiebalie"),
            keywords: &[
                "brutaal",
                "hand",
                "hulp",
                "informatie",
                "knikken",
                "persoon achter informatiebalie",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjelpande person"),
            keywords: &["hjelp", "hjelpande person", "informasjon", "menneske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ହ\u{b3e}ତ ଅବନତ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଅବନତ କର\u{b3f}ବ\u{b3e}",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ହ\u{b3e}ତ ଅବନତ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ସହ\u{b3e}ୟତ\u{b3e}",
                "ସ\u{b3e}ସ\u{b3f}",
                "ସ\u{b42}ଚନ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਣਕਾਰੀ ਦ\u{a47}ਣ ਵਾਲਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਜਾਣਕਾਰੀ",
                "ਜਾਣਕਾਰੀ ਡ\u{a48}ਸਕ",
                "ਜਾਣਕਾਰੀ ਦ\u{a47}ਣ ਵਾਲਾ ਵਿਅਕਤੀ",
                "ਮਦਦ",
                "ਲ\u{a4b}ਕ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ نال تھپکی دیندا بندہ"),
            keywords: &[
                "تھپکی دینا",
                "مدد",
                "معلومات",
                "ڈھیٹ",
                "ہتھ",
                "ہتھ نال تھپکی دیندا بندہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé De Shó Im Hand"),
            keywords: &[
                "Bold",
                "Hand",
                "Hẹ\u{301}lẹp",
                "Pẹ\u{301}sin Wé De Shó Im Hand",
                "Ínfọméshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba z wystawioną dłonią"),
            keywords: &[
                "osoba z wystawioną dłonią",
                "pomoc",
                "pomocna dłoń",
                "pomogę",
                "życzliwy",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص لاس ښايي"),
            keywords: &["شخص لاس ښايي", "لاس", "لاس ښوول", "مرسته", "معلومات"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa com a palma virada para cima"),
            keywords: &[
                "ajuda",
                "informações",
                "mão",
                "pessoa com a palma virada para cima",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("assistente de balcão de informações"),
            keywords: &[
                "ajuda",
                "assistente de balcão de informações",
                "atencioso",
                "informações",
                "mão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa willakuy kitipi"),
            keywords: &[
                "maki",
                "mana p’inakuy",
                "qillqasqa",
                "runa willakuy kitipi",
                "willakuy",
                "yanapakuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană care explică"),
            keywords: &["ajutor", "asistență", "informații", "persoană care explică"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-574"),
            keywords: &["E10-574"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек тянет руку"),
            keywords: &["информация", "помощь", "рука", "человек тянет руку"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu wazamuye urutoki"),
            keywords: &[
                "amakuru",
                "gutega ikiganza",
                "ikiganza",
                "kwirya",
                "ubufasha",
                "umuntu wazamuye urutoki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص هٿ ٿپڪائيندي"),
            keywords: &[
                "بي ادب",
                "شخص هٿ ٿپڪائيندي",
                "ضرب لڳائڻ",
                "مدد",
                "معلومات",
                "هٿ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("උපක\u{dcf}ර කව\u{dd4}ළ\u{dd4} ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "අත",
                "උපක\u{dcf}ර කව\u{dd4}ළ\u{dd4} ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "උපක\u{dcf}රය",
                "එඩ\u{dd2}තර",
                "තොරත\u{dd4}ර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek s nastavenou dlaňou"),
            keywords: &["dlaň", "nastavená", "ruka", "človek s nastavenou dlaňou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki dela na informacijah"),
            keywords: &[
                "informacije",
                "oseba, ki dela na informacijah",
                "pomoč",
                "roka",
                "zgovorno",
                "živahno",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof warbixin bixinaya"),
            keywords: &[
                "bixinaya",
                "caawin",
                "daacad ah",
                "gacan",
                "qof warbixin bixinaya",
                "warbixin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("personi i sportelit të informacionit"),
            keywords: &[
                "aktiv",
                "dorë",
                "informacion",
                "ndihmë",
                "personi i sportelit të informacionit",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа која даје информације"),
            keywords: &[
                "инфoрмaциje",
                "особа која даје информације",
                "пoмoћ",
                "рукa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba koja daje informacije"),
            keywords: &[
                "informacije",
                "osoba koja daje informacije",
                "pomoć",
                "ruka",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("receptionist"),
            keywords: &["information", "människor", "reception", "receptionist"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mhudumu anayetoa maelezo"),
            keywords: &[
                "anayejiamini",
                "maelezo",
                "mhudumu anayetoa maelezo",
                "mkono",
                "usaidizi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வரவேற\u{bcd}ப\u{bbe}ளினி"),
            keywords: &[
                "உதவி",
                "உதவும\u{bcd} கரம\u{bcd}",
                "குறும\u{bcd}பு",
                "தகவல\u{bcd}",
                "வரவேற\u{bcd}ப\u{bbe}ளினி",
                "வழிக\u{bbe}ட\u{bcd}டல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సమ\u{c3e}చ\u{c3e}రం అంద\u{c3f}ంచ\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "సమ\u{c3e}చ\u{c3e}రం",
                "సమ\u{c3e}చ\u{c3e}రం అంద\u{c3f}ంచ\u{c47} వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки бо дасташ ишора карда истодааст"),
            keywords: &[
                "густох",
                "даст",
                "кӯмак",
                "маълумот",
                "чаппакунӣ",
                "шахсе, ки бо дасташ ишора карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โต\u{e4a}ะสอบถาม"),
            keywords: &["ความช\u{e48}วยเหล\u{e37}อ", "โต\u{e4a}ะสอบถาม"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini açan adam"),
            keywords: &[
                "batyrgaý",
                "el",
                "elini açan adam",
                "kömek",
                "maglumat",
                "çaý puly bermek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha nima mafola"),
            keywords: &["tokotaha nima mafola"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elini yana yatırma"),
            keywords: &["bilgilendirme", "elini yana yatırma", "kişiler", "yardım"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاپان ھەققى بەرگەن كىشى"),
            keywords: &[
                "ئۇچۇر",
                "تاپان ھەققى",
                "تاپان ھەققى بەرگەن كىشى",
                "قول",
                "قوپال",
                "ياردەم",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина, що простягає руку допомоги"),
            keywords: &[
                "допомога",
                "людина, що простягає руку допомоги",
                "працівник довідкового бюро",
                "рука",
                "інформація",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("معلوماتی ڈیسک والا بندہ"),
            keywords: &["مدد", "معلومات", "معلوماتی ڈیسک والا بندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ma’lumotxona xodimi"),
            keywords: &[
                "ma’lumot",
                "ma’lumotxona xodimi",
                "qo‘l",
                "surbet",
                "yordam",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người ra hiệu trợ giúp"),
            keywords: &[
                "giúp",
                "mách nước",
                "người ra hiệu trợ giúp",
                "tay",
                "thông tin",
                "tươi tắn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit kuy joxee wet"),
            keywords: &[
                "jàppale",
                "leeral",
                "loxo",
                "ndimbal",
                "nit kuy joxee wet",
                "tàng",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ophethule isandla"),
            keywords: &[
                "i-sassy",
                "inkcazelo",
                "isandla",
                "ukuphethula",
                "umntu ophethule isandla",
                "uncedo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni N Tọka Ọwọ"),
            keywords: &[
                "tọ\u{301}ka",
                "ìrànwọ\u{301}",
                "ìròyìn",
                "Ẹni N Tọka Ọwọ",
                "ọlọyaya",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做提示手勢嘅人"),
            keywords: &["做提示手勢嘅人", "幫助", "手", "提示", "時髦", "資訊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做提示手势嘅人"),
            keywords: &["做提示手势嘅人", "帮助", "手", "提示", "时髦", "资讯"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("前台"),
            keywords: &["信息", "前台", "帮助"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("服務台人員"),
            keywords: &["俏皮", "服務台人員", "服務員"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("攤開手嘅人"),
            keywords: &["攤開手嘅人", "攤開手｜貼士"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu ocela ngesandla"),
            keywords: &[
                "imali",
                "isandla",
                "ulwazi",
                "umuntu ocela ngesandla",
                "usizo",
            ],
        },
    ],
};
#[doc = "💁🏻"]
pub const PERSON_TIPPING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏻",
    codepoint: "1F481 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person tipping hand: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💁🏼"]
pub const PERSON_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏼",
    codepoint: "1F481 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person tipping hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💁🏽"]
pub const PERSON_TIPPING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏽",
    codepoint: "1F481 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person tipping hand: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💁🏾"]
pub const PERSON_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏾",
    codepoint: "1F481 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person tipping hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💁🏿"]
pub const PERSON_TIPPING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏿",
    codepoint: "1F481 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person tipping hand: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💁\u{200d}♂\u{fe0f}"]
pub const MAN_TIPPING_HAND: crate::Emoji = crate::Emoji {
    glyph: "💁\u{200d}♂\u{fe0f}",
    codepoint: "1F481 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man tipping hand",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁\u{200d}♂",
        codepoint: "1F481 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man tipping hand",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man hou hand geknak"),
            keywords: &[
                "fooitjie",
                "hand",
                "help",
                "inligting",
                "man",
                "man hou hand geknak",
                "man wat hand geknak hou",
                "skrander",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ መረጃ ሰጪ"),
            keywords: &["መረጃ ሰጪ", "ሴት", "እጅ", "እገዛ", "ወንድ መረጃ ሰጪ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل بيد مائلة"),
            keywords: &["رجل بيد مائلة", "يد مائلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9cd}ৰ\u{9be}ণৱন\u{9cd}ত",
                "হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be}",
                "হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
                "হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be} ম\u{9be}ন\u{9c1}হ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl uzadan kişi"),
            keywords: &["kişi", "sırtıq", "əl uzadan kişi", "əl uzatmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына трасе рукой"),
            keywords: &[
                "бойкі",
                "мужчына",
                "мужчына працягвае руку",
                "мужчына трасе рукой",
                "трасе рукой",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж от информационна служба"),
            keywords: &["информация", "мъж от информационна служба", "помощ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলেদের টিপ চ\u{9be}ওয\u{9bc}\u{9be}"),
            keywords: &[
                "ছেলে",
                "ছেলেদের টিপ চ\u{9be}ওয\u{9bc}\u{9be}",
                "টিপ চ\u{9be}ওয\u{9bc}\u{9be}",
                "প\u{9c1}র\u{9c1}ষ",
                "মজ\u{9be}দ\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac otkriva namjere"),
            keywords: &[
                "gestikulacija",
                "informacija",
                "muškarac",
                "muškarac otkriva namjere",
                "ruke",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home amb mà inclinada cap amunt"),
            keywords: &[
                "ajuda",
                "home",
                "home amb mà inclinada cap amunt",
                "informació",
                "mà",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏘᏌᏗ ᎤᏬᏱ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ ᎤᏘᏌᏗ ᎤᏬᏱ", "ᎤᎵᏍᎦᏂᏏ", "ᎤᏘᏌᏗ ᎤᏬᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž s dlaní vzhůru"),
            keywords: &[
                "concierge",
                "drzost",
                "informace",
                "ironie",
                "muž",
                "muž s dlaní vzhůru",
                "pomoc",
                "poslíček",
                "recepce",
                "recepční",
                "ruka",
                "sarkasmus",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn gwyro ei law"),
            keywords: &["dyn", "dyn yn gwyro ei law", "gwybodaeth", "llaw", "tipio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand vender håndfladen op"),
            keywords: &[
                "flabet",
                "hjælp",
                "information",
                "mand",
                "mand vender håndfladen op",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Infoschalter-Mitarbeiter"),
            keywords: &[
                "Auskunft",
                "Informationen",
                "Infoschalter-Mitarbeiter",
                "Mann",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας προσφέρει"),
            keywords: &["άντρας", "άντρας προσφέρει", "πρόσχαρος", "χειρονομία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man tipping hand"),
            keywords: &["man", "man tipping hand", "sassy", "tipping hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("empleado de mostrador de información"),
            keywords: &[
                "empleado de mostrador de información",
                "hombre",
                "información",
                "mano",
                "mostrador",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "empleado",
                "empleado de mostrador de información",
                "hombre",
                "hombre en mostrador de información",
                "información",
                "mesa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("infoleti meestöötaja"),
            keywords: &["abi", "infoleti meestöötaja", "mees", "teave"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskean dabilen gizona"),
            keywords: &[
                "eskean dabilen gizona",
                "eskupeko",
                "gizon",
                "gizonezko",
                "kokin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد کمک می\u{200c}کند"),
            keywords: &[
                "انعام دادن",
                "انعام گرفتن",
                "رو کردن",
                "مرد دستش را رو می\u{200c}کند",
                "مرد کمک می\u{200c}کند",
                "کمک کردن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kämmentä ylöspäin näyttävä mies"),
            keywords: &["kämmentä ylöspäin näyttävä mies", "käsi", "mies", "nenäkäs"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking nakatikwas ang kamay"),
            keywords: &[
                "lalaki",
                "lalaking nakatikwas ang kamay",
                "nakakumpas",
                "nakatikwas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður sum nertir við"),
            keywords: &["maður", "maður sum nertir við", "nertir við"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme paume vers le haut"),
            keywords: &["homme", "homme paume vers le haut", "paume vers le haut"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("guichetier"),
            keywords: &[
                "aide",
                "assistant",
                "concierge",
                "guichetier",
                "homme",
                "information",
                "réceptionniste",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear lena lámh amach"),
            keywords: &[
                "fear",
                "fear le lámh amach",
                "fear lena lámh amach",
                "fearann",
                "lámh amach",
                "sotalach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine le làmh sìnte a-mach, bas air uachdar"),
            keywords: &[
                "bas",
                "cobhair",
                "duine",
                "duine le làmh sìnte a-mach, bas air uachdar",
                "fear",
                "fiosrachadh",
                "fireannach",
                "làmh",
                "sìnte",
                "taic",
                "uachdar",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home coa man medio levantada"),
            keywords: &[
                "asistencia",
                "axuda levantada",
                "home coa man medio levantada",
                "información",
                "man",
                "medio levantada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માહિતી આપતો પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "પ\u{ac1}ર\u{ac1}ષ",
                "માહિતી",
                "માહિતી આપતો પ\u{ac1}ર\u{ac1}ષ",
                "માહિતી ડ\u{ac7}સ\u{acd}ક",
                "સહાય",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji hannu mai ba da ci-goro"),
            keywords: &[
                "hannu mai ba da ci-goro",
                "mutum",
                "namiji hannu mai ba da ci-goro",
                "ƙarfin zuciya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איש בדלפק מידע או מבקש טיפ"),
            keywords: &[
                "איש",
                "איש בדלפק מידע או מבקש טיפ",
                "גבר",
                "גבר מבקש טיפ",
                "חצוף",
                "מבקש נדבה",
                "שובב",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}चना द\u{947}ता प\u{941}र\u{941}ष"),
            keywords: &[
                "टिपि\u{902}ग",
                "प\u{941}र\u{941}ष",
                "स\u{942}चना द\u{947}ता प\u{941}र\u{941}ष",
                "स\u{945}सी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac s nagnutim dlanom"),
            keywords: &["drskost", "muškarac s nagnutim dlanom", "otvorena ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyitott tenyerű férfi"),
            keywords: &[
                "férfi",
                "információ",
                "nyitott tenyerű férfi",
                "nyitott tenyér",
                "segítség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդը բացում է իր մտադրությունները"),
            keywords: &[
                "հանդուգն",
                "տղամարդ",
                "տղամարդը բացում է իր մտադրությունները",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria menengadahkan tangan"),
            keywords: &[
                "bantuan",
                "isyarat",
                "laki-laki",
                "pria menengadahkan tangan",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-ehulata aka"),
            keywords: &["na-ehulata aka", "nwoke", "nwoke na-ehulata aka", "sassy"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður réttir út lófa"),
            keywords: &["karl", "léttur", "lófi", "maður réttir út lófa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo al punto informazioni"),
            keywords: &[
                "indicazione",
                "informazioni",
                "sarcastico",
                "uomo",
                "uomo al punto informazioni",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("案内する男"),
            keywords: &["ジェスチャー", "案内", "案内する男", "男", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang tangane anyangga"),
            keywords: &[
                "nggaya",
                "tangan anyangga",
                "wong lanang",
                "wong lanang tangane anyangga",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი დახრილი ხელით"),
            keywords: &["დახრილ ხელი", "კაცი", "კაცი დახრილი ხელით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолын созып тұрған ер"),
            keywords: &["ер", "қол созу", "қолын созып тұрған ер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand vender håndfladen op"),
            keywords: &[
                "flabet",
                "hjælp",
                "information",
                "mand",
                "mand vender håndfladen op",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសបង\u{17d2}ហើបព\u{17d0}ត\u{17cc}មាន"),
            keywords: &[
                "បញ\u{17d2}ចេញព\u{17d0}ត\u{17cc}មាន",
                "ប\u{17bb}រស",
                "ប\u{17bb}រសបង\u{17d2}ហើបព\u{17d0}ត\u{17cc}មាន",
                "ប\u{17d2}រាប\u{17cb}ព\u{17d0}ត\u{17cc}មាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ"),
            keywords: &[
                "ಉದ\u{ccd}ಧಟತನ",
                "ಕೈ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ",
                "ಪುರುಷ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손바닥 꺾은 남자"),
            keywords: &["손 꺾음", "손바닥", "손바닥 꺾은 남자", "젖힌 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some(
                "ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा करपी दादलो",
            ),
            keywords: &[
                "ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा करपी दादलो",
                "दादलो । ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा करपी दादलो । ब\u{947}बनाव । ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा करपी दादलो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("Баш кийимин чечип учурашкан эркек"),
            keywords: &[
                "Баш кийимин чечип учурашкан эркек",
                "орой",
                "сырын айтуу",
                "эркек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann, deen d’Hand op hält"),
            keywords: &[
                "Mann",
                "Mann, deen d’Hand op hält",
                "frech",
                "opgehalen Hand",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍແບມ\u{eb7}"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍແບມ\u{eb7}",
                "ມ\u{eb7}",
                "ແບ",
                "ແບມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("lengvai ranką pakėlęs vyras"),
            keywords: &[
                "gyvas",
                "lengvai pakelta ranka",
                "lengvai ranką pakėlęs vyras",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis ar pastieptu roku"),
            keywords: &[
                "bezkaunība",
                "vīrietis",
                "vīrietis ar pastieptu roku",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne ringa tāringi"),
            keywords: &["ringa tāringi", "tāne", "tāne ringa tāringi", "whakatete"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("феминизиран маж"),
            keywords: &["маж", "феминизиран"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിവരം നൽക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "പ\u{d41}ര\u{d41}ഷൻ",
                "വിവരം",
                "വിവരം നൽക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "സഹ\u{d3e}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гараа дэлгэж буй эрэгтэй"),
            keywords: &[
                "гараа дэлгэж буй эрэгтэй",
                "гараа дэлгэх",
                "марзан",
                "эр",
                "эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टिप द\u{947}णारा प\u{941}र\u{941}ष"),
            keywords: &[
                "खट\u{94d}याळ",
                "टिप द\u{947}णारा प\u{941}र\u{941}ष",
                "टिप द\u{947}ण\u{947}",
                "प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki menadah tangan"),
            keywords: &["lelaki", "lelaki menadah tangan", "menadah tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel ibaxxi idejh"),
            keywords: &["raġel", "raġel ibaxxi idejh", "tbaxxija tal-idejn", "tost"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသည\u{1037}\u{103a} ဝန\u{103a}ဆောင\u{103a}မ\u{103e}\u{102f}ပေးသ\u{1030} အမျ\u{102d}\u{102f}းသား",
                "က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
                "ဘောက\u{103a}ဆ\u{1030}း",
                "လက\u{103a}",
                "လက\u{103a}ဖြန\u{1037}\u{103a}ထားသော ဝန\u{103a}ဆောင\u{103a}မ\u{103e}\u{102f}ပေးသ\u{1030} အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjelpende mann"),
            keywords: &["hjelpe", "hjelpende mann", "informasjon", "mann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}चना दिन\u{947} छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
                "स\u{942}चना दिन\u{947} छोरामान\u{94d}छ\u{947}",
                "स\u{942}चना दिन\u{947} हात",
                "स\u{94d}यास\u{94d}सी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man achter informatiebalie"),
            keywords: &[
                "brutaal",
                "man",
                "man achter informatiebalie",
                "pols knikken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjelpande mann"),
            keywords: &["hjelpande mann", "hjelpe", "informasjon", "mann"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ହ\u{b3e}ତ ଅବନତ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଅବନତ ହୋଇଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ହ\u{b3e}ତ ଅବନତ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ସ\u{b3e}ସ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a42}ਚਨਾ ਦਿ\u{a70}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਆਸਮਾਨ ਵ\u{a71}ਲ ਹਥ\u{a47}ਲੀ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਸਸੀ",
                "ਸ\u{a42}ਚਨਾ ਦਿ\u{a70}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تھپکی دیندا مرد"),
            keywords: &["بندہ", "تھپکی دیندا مرد", "تھپکی دیندا ہتھ", "ڈھیٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man De Tró Im Hand"),
            keywords: &["Bold", "Man", "Man De Tró Im Hand", "Man Wé De Shó Im Hand"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna z wystawioną dłonią"),
            keywords: &["mężczyzna", "mężczyzna z wystawioną dłonią", "otwarta dłoń"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی لاس ښايي"),
            keywords: &["ساسي", "سړی", "سړی لاس ښايي", "لاس ښوول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem com a palma virada para cima"),
            keywords: &["homem", "homem com a palma virada para cima"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "assistente de balcão de informações (homem)",
                "atrevido",
                "homem",
                "homem com a palma virada para cima",
                "mão de gorjeta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata willakuy kitipi"),
            keywords: &[
                "mana p’inakuy",
                "qillqasqa maki",
                "tata",
                "tata willakuy kitipi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat care explică"),
            keywords: &["asistență", "bărbat", "bărbat care explică", "informații"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1201"),
            keywords: &["E10-1201"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина тянет руку"),
            keywords: &["информация", "мужчина тянет руку", "помощь", "рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo uteze ikiganza"),
            keywords: &[
                "kwirya",
                "tipping hand",
                "umugabo",
                "umugabo uteze ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد هٿ ٿپڪائيندي"),
            keywords: &["بي ادب", "مرد", "مرد هٿ ٿپڪائيندي", "هٿ ٿپڪائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත හෙළන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "අත හෙළන ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "අත හෙළ\u{dd3}ම",
                "ආත\u{dca}ම\u{dd3}ය",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž s nastavenou dlaňou"),
            keywords: &[
                "dlaň",
                "muž",
                "muž s nastavenou dlaňou",
                "nastavená",
                "ruka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("uslužbenec na informacijah"),
            keywords: &[
                "informacije",
                "moški",
                "pomoč",
                "uslužbenec na informacijah",
                "zgovoren",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin war bixinaya"),
            keywords: &[
                "daacad",
                "nin",
                "nin war bixinaya",
                "nin warbixin bixinaya",
                "warbixin bixin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë që tregon me dorë"),
            keywords: &["burrë", "burrë që tregon me dorë", "informacion", "tregues"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац открива намере"),
            keywords: &[
                "гестикулација",
                "информације",
                "мушкарац",
                "мушкарац открива намере",
                "руке",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мушкарац открива намјере"),
            keywords: &["мушкарац открива намјере"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac otkriva namere"),
            keywords: &[
                "gestikulacija",
                "informacije",
                "muškarac",
                "muškarac otkriva namere",
                "ruke",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("muškarac otkriva namjere"),
            keywords: &["muškarac otkriva namjere"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjälpande man"),
            keywords: &["hjälpa", "hjälpande man", "information", "man"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume anayetoa maelezo"),
            keywords: &[
                "mkono",
                "mwanamume",
                "mwanamume anayetoa maelezo",
                "usaidizi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} வரவேற\u{bcd}ப\u{bbe}ளர\u{bcd}"),
            keywords: &["ஆண\u{bcd}", "உதவி", "வரவேற\u{bcd}ப\u{bbe}ளர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}త\u{c3f}న\u{c3f} వంచ\u{c3f}న పురుషుడు"),
            keywords: &[
                "చ\u{c47}త\u{c3f}న\u{c3f} వంచడం",
                "చ\u{c47}త\u{c3f}న\u{c3f} వంచ\u{c3f}న పురుషుడు",
                "త\u{c46}ల\u{c3f}వ\u{c3f}గ\u{c3e}",
                "పురుషుడు",
                "మగ\u{c3e}డు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки бо дасташ ишора карда истодааст"),
            keywords: &[
                "густох",
                "дасти ишоракунанда",
                "мард",
                "марде, ки бо дасташ ишора карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายแบม\u{e37}อ"),
            keywords: &[
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายแบม\u{e37}อ",
                "แบม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini açan erkek"),
            keywords: &[
                "batyrgaý",
                "elini açan erkek",
                "erkek",
                "çaý puly berýän el",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata nima mafola"),
            keywords: &["tangata nima mafola"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elini yana yatıran erkek"),
            keywords: &[
                "adam",
                "elini yana yatıran erkek",
                "erkek",
                "küstah",
                "yana yatmış el",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاپان ھەققى بەرگەن ئەر"),
            keywords: &["ئەر", "تاپان ھەققى", "تاپان ھەققى بەرگەن ئەر", "قوپال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік, що простягає руку допомоги"),
            keywords: &[
                "відповідати",
                "нестриманість",
                "тягнути руку",
                "чоловік",
                "чоловік тягне руку",
                "чоловік, що простягає руку допомоги",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تجویز دیتا ہوا مرد"),
            keywords: &["تجویر", "تجویز دیتا ہوا مرد", "رائے", "مرد", "معلومات"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak qo‘l cho‘zmoqda"),
            keywords: &["erkak", "erkak qo‘l cho‘zmoqda", "qo‘l cho‘zish", "surbet"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông ra hiệu trợ giúp"),
            keywords: &[
                "nam",
                "người đàn ông ra hiệu trợ giúp",
                "tay ra hiệu",
                "tươi tắn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor loxo jàppale"),
            keywords: &["góor", "góor loxo jàppale", "loxo jàppale", "sassy"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda ephethula isandla"),
            keywords: &[
                "i-sassy",
                "indoda",
                "indoda ephethula isandla",
                "ukuphethula isandla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tí ń tọ\u{301}ka ọwọ\u{301}"),
            keywords: &[
                "sassy",
                "taka ọwọ\u{301}",
                "ọkùnrin",
                "ọkùnrin tí ń tọ\u{301}ka ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做提示手勢嘅男人"),
            keywords: &["做提示手勢嘅男人", "提示手勢", "時髦", "男"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做提示手势嘅男人"),
            keywords: &["做提示手势嘅男人", "提示手势", "时髦", "男"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("前台男"),
            keywords: &["前台", "前台男", "男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生抬手"),
            keywords: &["小費", "男", "男生抬手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男子抬手"),
            keywords: &["攤開手｜貼士｜男人", "男子抬手"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda ecela ngesandla"),
            keywords: &[
                "imali",
                "indoda",
                "indoda ecela ngesandla",
                "isandla",
                "usizo",
            ],
        },
    ],
};
#[doc = "💁🏻\u{200d}♂\u{fe0f}"]
pub const MAN_TIPPING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F481 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man tipping hand: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏻\u{200d}♂",
        codepoint: "1F481 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man tipping hand: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏼\u{200d}♂\u{fe0f}"]
pub const MAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F481 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man tipping hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏼\u{200d}♂",
        codepoint: "1F481 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man tipping hand: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏽\u{200d}♂\u{fe0f}"]
pub const MAN_TIPPING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F481 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man tipping hand: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏽\u{200d}♂",
        codepoint: "1F481 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man tipping hand: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏾\u{200d}♂\u{fe0f}"]
pub const MAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F481 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man tipping hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏾\u{200d}♂",
        codepoint: "1F481 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man tipping hand: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏿\u{200d}♂\u{fe0f}"]
pub const MAN_TIPPING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F481 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man tipping hand: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏿\u{200d}♂",
        codepoint: "1F481 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man tipping hand: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁\u{200d}♀\u{fe0f}"]
pub const WOMAN_TIPPING_HAND: crate::Emoji = crate::Emoji {
    glyph: "💁\u{200d}♀\u{fe0f}",
    codepoint: "1F481 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman tipping hand",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁\u{200d}♀",
        codepoint: "1F481 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman tipping hand",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou hou hand geknak"),
            keywords: &[
                "fooitjie",
                "hand",
                "help",
                "inligting",
                "skrander",
                "vrou",
                "vrou hou hand geknak",
                "vrou wat hand geknak hou",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት መረጃ ሰጪ"),
            keywords: &["መረጃ ሰጪ", "ሴት", "ሴት መረጃ ሰጪ", "እጅ", "እገዛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة بيد مائلة"),
            keywords: &["سيدة بيد مائلة", "يد مائلة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "প\u{9cd}ৰ\u{9be}ণৱন\u{9cd}ত",
                "মহিল\u{9be}",
                "হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be}",
                "হ\u{9be}ত ত\u{9c1}লি ধৰ\u{9be} মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl uzadan qadın"),
            keywords: &["qadın", "sırtıq", "əl uzadan qadın", "əl uzamaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына трасе рукой"),
            keywords: &[
                "бойкая",
                "жанчына",
                "жанчына трасе рукой",
                "жанчына цягне руку",
                "трасе рукой",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена от информационна служба"),
            keywords: &["жена от информационна служба", "информация", "помощ"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}েদের টিপ চ\u{9be}ওয\u{9bc}\u{9be}"),
            keywords: &[
                "টিপ চ\u{9be}ওয\u{9bc}\u{9be}",
                "মজ\u{9be}দ\u{9be}র",
                "মহিল\u{9be}",
                "মেয\u{9bc}ে",
                "মেয\u{9bc}েদের টিপ চ\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena otkriva namjere"),
            keywords: &[
                "gestikulacija",
                "informacija",
                "ruke",
                "žena",
                "žena otkriva namjere",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona amb mà inclinada cap amunt"),
            keywords: &[
                "ajuda",
                "dona",
                "dona amb mà inclinada cap amunt",
                "informació",
                "mà",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᏘᏌᏗ ᎤᏬᏱ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᎤᏘᏌᏗ ᎤᏬᏱ", "ᎤᎵᏍᎦᏂᏏ", "ᎤᏘᏌᏗ ᎤᏬᏱᏬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena s dlaní vzhůru"),
            keywords: &[
                "concierge",
                "drzost",
                "informace",
                "ironie",
                "pomoc",
                "poslíček",
                "recepce",
                "recepční",
                "ruka",
                "sarkasmus",
                "žena",
                "žena s dlaní vzhůru",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn gwyro ei llaw"),
            keywords: &[
                "gwybodaeth",
                "llaw",
                "menyw",
                "menyw yn gwyro ei llaw",
                "tipio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde vender håndfladen op"),
            keywords: &[
                "flabet",
                "hjælp",
                "håndflade",
                "information",
                "kvinde",
                "kvinde vender håndfladen op",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Infoschalter-Mitarbeiterin"),
            keywords: &[
                "Auskunft",
                "Frau",
                "Informationen",
                "Infoschalter-Mitarbeiterin",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα προσφέρει"),
            keywords: &["γυναίκα", "γυναίκα προσφέρει", "πρόσχαρη", "χειρονομία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman tipping hand"),
            keywords: &["sassy", "tipping hand", "woman", "woman tipping hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("empleada de mostrador de información"),
            keywords: &[
                "empleada de mostrador de información",
                "información",
                "mano",
                "mostrador",
                "mujer",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "empleada",
                "empleada de mostrador de información",
                "información",
                "mesa",
                "mujer",
                "mujer en mostrador de información",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("infoleti naistöötaja"),
            keywords: &["abi", "infoleti naistöötaja", "naine", "teave"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskean dabilen emakumea"),
            keywords: &[
                "emakume",
                "emakumezko",
                "eskean dabilen emakumea",
                "esku",
                "eskupeko",
                "kokin",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن کمک می\u{200c}کند"),
            keywords: &[
                "انعام دادن",
                "انعام گرفتن",
                "رو کردن",
                "زن دستش را رو می\u{200c}کند",
                "زن کمک می\u{200c}کند",
                "کمک کردن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kämmentä ylöspäin näyttävä nainen"),
            keywords: &[
                "kämmentä ylöspäin näyttävä nainen",
                "käsi",
                "nainen",
                "nenäkäs",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng nakatikwas ang kamay"),
            keywords: &[
                "babae",
                "babaeng nakatikwas ang kamay",
                "nakakumpas",
                "nakatikwas",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna sum nertir við"),
            keywords: &["kona", "kvinna", "kvinna sum nertir við", "nertir við"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme paume vers le haut"),
            keywords: &["femme", "femme paume vers le haut", "paume vers le haut"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("guichetière"),
            keywords: &[
                "aide",
                "assistante",
                "concierge",
                "femme",
                "guichetière",
                "information",
                "réceptionniste",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean lena lámh amach"),
            keywords: &[
                "baineann",
                "bean",
                "bean le lámh amach",
                "bean lena lámh amach",
                "lámh amach",
                "sotalach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("tè le làmh sìnte a-mach, bas air uachdar"),
            keywords: &[
                "bas",
                "boireannach",
                "boireannach le làmh sìnte a-mach, bas air uachdar",
                "cobhair",
                "fiosrachadh",
                "làmh",
                "sìnte",
                "taic",
                "tè",
                "tè le làmh sìnte a-mach, bas air uachdar",
                "uachdar",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller coa man medio levantada"),
            keywords: &[
                "asistencia",
                "axuda",
                "información",
                "man",
                "medio levantada",
                "muller coa man medio levantada",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માહિતી આપતી સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "માહિતી",
                "માહિતી આપતી સ\u{acd}ત\u{acd}રી",
                "માહિતી ડ\u{ac7}સ\u{acd}ક",
                "સહાય",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace hannu mai ba da ci-goro"),
            keywords: &[
                "hannu mai ba da ci-goro",
                "mace",
                "mace hannu mai ba da ci-goro",
                "ƙarfin zuciya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מבקשת טיפ"),
            keywords: &[
                "אישה",
                "אישה מבקשת טיפ",
                "דלפק מידע",
                "חוצפה",
                "טיפ",
                "יד",
                "מידע",
                "עזרה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{942}चना द\u{947}ती महिला"),
            keywords: &[
                "औरत",
                "टिपि\u{902}ग",
                "महिला",
                "स\u{942}चना द\u{947}ती महिला",
                "स\u{945}सी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena s nagnutim dlanom"),
            keywords: &["drskost", "otvorena ruka", "žena s nagnutim dlanom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyitott tenyerű nő"),
            keywords: &[
                "információ",
                "nyitott tenyerű nő",
                "nyitott tenyér",
                "nő",
                "segítség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կինը բացում է իր մտադրությունները"),
            keywords: &["կին", "կինը բացում է իր մտադրությունները", "հանդուգն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita menengadahkan tangan"),
            keywords: &[
                "bantuan",
                "isyarat",
                "perempuan",
                "tangan",
                "wanita menengadahkan tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-ehulata aka"),
            keywords: &["na-ehulata aka", "nwanyị", "nwanyị na-ehulata aka", "sassy"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona réttir út lófa"),
            keywords: &["kona", "kona réttir út lófa", "létt", "lófi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna al punto informazioni"),
            keywords: &[
                "donna",
                "donna al punto informazioni",
                "indicazione",
                "informazioni",
                "sarcastica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("案内する女"),
            keywords: &["ジェスチャー", "女", "女性", "案内", "案内する女"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon tangane anyangga"),
            keywords: &[
                "nggaya",
                "tangan anyangga",
                "wong wadon",
                "wong wadon tangane anyangga",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი დახრილი ხელით"),
            keywords: &["დახრილ ხელი", "ქალი", "ქალი დახრილი ხელით"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолын созып тұрған әйел"),
            keywords: &["қол созу", "қолын созып тұрған әйел", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde vender håndfladen op"),
            keywords: &[
                "flabet",
                "hjælp",
                "håndflade",
                "information",
                "kvinde",
                "kvinde vender håndfladen op",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}បង\u{17d2}ហើបព\u{17d0}ត\u{17cc}មាន"),
            keywords: &[
                "នារ\u{17b8}",
                "នារ\u{17b8}បង\u{17d2}ហើបព\u{17d0}ត\u{17cc}មាន",
                "បញ\u{17d2}ចេញព\u{17d0}ត\u{17cc}មាន",
                "ប\u{17d2}រាប\u{17cb}ព\u{17d0}ត\u{17cc}មាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ"),
            keywords: &[
                "ಉದ\u{ccd}ಧಟತನ",
                "ಕೈ ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손바닥 꺾은 여자"),
            keywords: &["손 꺾음", "손바닥", "손바닥 꺾은 여자", "젖힌 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल हात वयर काडटा"),
            keywords: &[
                "ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा",
                "ट\u{94d}र\u{947} धरिल\u{94d}ल\u{94d}या व\u{947}टरावरी\u{902} हातम\u{941}द\u{94d}रा करपी व\u{94d}यक\u{94d}ती",
                "बायल",
                "बायल हात वयर काडटा",
                "ब\u{947}बनाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("Баш кийимин чечип учурашкан аял"),
            keywords: &[
                "Баш кийимин чечип учурашкан аял",
                "аял",
                "орой",
                "сырын айтуу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra, déi d’Hand op hält"),
            keywords: &["Fra", "Fra, déi d’Hand op hält", "frech", "opgehalen Hand"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງແບມ\u{eb7}"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງແບມ\u{eb7}",
                "ມ\u{eb7}",
                "ແບ",
                "ແບມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ranką pakėlusi moteris"),
            keywords: &[
                "gyvas",
                "lengvai pakelta ranka",
                "moteris",
                "ranką pakėlusi moteris",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete ar pastieptu roku"),
            keywords: &[
                "bezkaunība",
                "sieviete",
                "sieviete ar pastieptu roku",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine ringa tāringi"),
            keywords: &[
                "ringa tāringi",
                "wahine",
                "wahine ringa tāringi",
                "whakatete",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шмизла"),
            keywords: &["жена", "шмизла"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിവരം നൽക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ"),
            keywords: &[
                "വിവരം",
                "വിവരം നൽക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "സഹ\u{d3e}യം",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гараа дэлгэж буй эмэгтэй"),
            keywords: &[
                "гараа дэлгэж буй эмэгтэй",
                "гараа дэлгэх",
                "марзан",
                "эм",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टिप द\u{947}णारी महिला"),
            keywords: &[
                "खट\u{94d}याळ",
                "टिप द\u{947}णारी महिला",
                "टिप द\u{947}ण\u{947}",
                "महिला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan menadah tangan"),
            keywords: &[
                "menadah tangan",
                "perempuan",
                "perempuan menadah tangan",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara tbaxxi idha"),
            keywords: &["mara", "mara tbaxxi idha", "tbaxxija tal-idejn", "tost"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "က\u{1030}ည\u{102e}ပါရစေဟ\u{102f} လက\u{103a}ဟန\u{103a}ပြနေသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjelpende kvinne"),
            keywords: &["hjelpe", "hjelpende kvinne", "informasjon", "kvinne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{942}\u{942}चना दिन\u{947} छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "महिला",
                "स\u{942}चना दिन\u{947} छोरीमान\u{94d}छ\u{947}",
                "स\u{942}चना दिन\u{947} हात",
                "स\u{942}\u{942}चना दिन\u{947} छोरीमान\u{94d}छ\u{947}",
                "स\u{94d}यास\u{94d}सी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw achter informatiebalie"),
            keywords: &[
                "brutaal",
                "pols knikken",
                "vrouw",
                "vrouw achter informatiebalie",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjelpande kvinne"),
            keywords: &["hjelpande kvinne", "hjelpe", "informasjon", "kvinne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ହ\u{b3e}ତ ଅବନତ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଅବନତ ହୋଇଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ହ\u{b3e}ତ ଅବନତ କର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ସ\u{b3e}ସ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a42}ਚਨਾ ਦਿ\u{a70}ਦੀ ਇਸਤਰੀ"),
            keywords: &[
                "ਆਸਮਾਨ ਵ\u{a71}ਲ ਹਥ\u{a47}ਲੀ",
                "ਇਸਤਰੀ",
                "ਔਰਤ",
                "ਸਸੀ",
                "ਸ\u{a42}ਚਨਾ ਦਿ\u{a70}ਦੀ ਇਸਤਰੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تھپکی دیندی زنانی"),
            keywords: &["تھپکی دیندا ہتھ", "تھپکی دیندی زنانی", "زنانی", "ڈھیٹ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman De Tró Im Hand"),
            keywords: &[
                "Hand",
                "Hápí",
                "Pẹ\u{301}sin Wé De Réz Im Hand Ọp",
                "Rez",
                "Sain",
                "Wúman De Tró Im Hand",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta z wystawioną dłonią"),
            keywords: &["kobieta", "kobieta z wystawioną dłonią", "otwarta dłoń"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه لاس ښايي"),
            keywords: &["ساسي", "لاس ښوول", "ښځه", "ښځه لاس ښايي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher com a palma virada para cima"),
            keywords: &["mulher", "mulher com a palma virada para cima"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "assistente de balcão de informações (mulher)",
                "atrevida",
                "mulher",
                "mulher com a palma virada para cima",
                "mão de gorjeta",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi willakuy kitipi"),
            keywords: &[
                "mana p’inakuy",
                "qillqasqa maki",
                "warmi",
                "warmi willakuy kitipi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie care explică"),
            keywords: &["asistență", "femeie", "femeie care explică", "informații"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1200"),
            keywords: &["E10-1200"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина тянет руку"),
            keywords: &["женщина тянет руку", "информация", "помощь", "рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore uteze ikiganza"),
            keywords: &[
                "ikiganza giteze",
                "kwirya",
                "umugore",
                "umugore uteze ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت هٿ ٿپڪائيندي"),
            keywords: &["بي ادب", "عورت", "عورت هٿ ٿپڪائيندي", "هٿ ٿپڪائڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත හෙළන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "අත හෙළන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "අත හෙළ\u{dd3}ම",
                "ආත\u{dca}ම\u{dd3}ය",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žena s nastavenou dlaňou"),
            keywords: &[
                "dlaň",
                "nastavená",
                "ruka",
                "žena",
                "žena s nastavenou dlaňou",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("uslužbenka na informacijah"),
            keywords: &[
                "informacije",
                "pomoč",
                "uslužbenka na informacijah",
                "zgovorna",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag warbixin bixinaysa"),
            keywords: &[
                "daacad",
                "naag",
                "naag warbixin bixinaysa",
                "warbixin bixin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua që tregon me dorë"),
            keywords: &["grua", "grua që tregon me dorë", "informacion", "tregues"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена открива намере"),
            keywords: &[
                "гестикулација",
                "жена",
                "жена открива намере",
                "информације",
                "руке",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("жена открива намјере"),
            keywords: &["жена открива намјере"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena otkriva namere"),
            keywords: &[
                "gestikulacija",
                "informacije",
                "ruke",
                "žena",
                "žena otkriva namere",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("žena otkriva namjere"),
            keywords: &["žena otkriva namjere"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjälpande kvinna"),
            keywords: &["hjälpa", "hjälpande kvinna", "information", "kvinna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke anayetoa maelezo"),
            keywords: &["mkono", "mwanamke", "mwanamke anayetoa maelezo", "usaidizi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} வரவேற\u{bcd}ப\u{bbe}ளர\u{bcd}"),
            keywords: &["உதவி", "பெண\u{bcd}", "வரவேற\u{bcd}ப\u{bbe}ளர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}త\u{c3f}న\u{c3f} వంచ\u{c3f}న స\u{c4d}త\u{c4d}ర\u{c40}"),
            keywords: &[
                "చ\u{c47}త\u{c3f}న\u{c3f} వంచడం",
                "చ\u{c47}త\u{c3f}న\u{c3f} వంచ\u{c3f}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "త\u{c46}ల\u{c3f}వ\u{c3f}గ\u{c3e}",
                "మహ\u{c3f}ళ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки бо дасташ ишора карда истодааст"),
            keywords: &[
                "густох",
                "дасти ишоракунанда",
                "зан",
                "зане, ки бо дасташ ишора карда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งแบม\u{e37}อ"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งแบม\u{e37}อ",
                "แบม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini açan zenan"),
            keywords: &[
                "batyrgaý",
                "elini açan zenan",
                "zenan",
                "çaý puly berýän el",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine nima mafola"),
            keywords: &["fefine nima mafola"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elini yana yatıran kadın"),
            keywords: &[
                "bayan",
                "elini yana yatıran kadın",
                "kadın",
                "küstah",
                "yana yatmış el",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تاپان ھەققى بەرگەن ئايال"),
            keywords: &[
                "ئايال",
                "تاپان ھەققى بەرگەن ئايال",
                "تاپان ھەققى بەرگەن قول",
                "قوپال",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка, що простягає руку допомоги"),
            keywords: &[
                "відповідати",
                "жінка",
                "жінка тягне руку",
                "жінка, що простягає руку допомоги",
                "нестриманість",
                "тягнути руку",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تجویز دیتی ہوئی عورت"),
            keywords: &["تجویر", "تجویز دیتی ہوئی عورت", "رائے", "عورت", "معلومات"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol qo‘l cho‘zmoqda"),
            keywords: &["ayol", "ayol qo‘l cho‘zmoqda", "qo‘l cho‘zish", "surbet"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ ra hiệu trợ giúp"),
            keywords: &[
                "người phụ nữ ra hiệu trợ giúp",
                "nữ",
                "tay ra hiệu",
                "tươi tắn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen loxo jàppale"),
            keywords: &["jigéen", "jigéen loxo jàppale", "loxo jàppale", "tàng"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa eluphethula isandla"),
            keywords: &[
                "i-sassy",
                "ibhinqa",
                "ibhinqa eluphethula isandla",
                "ukuphethula isandla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń tọ\u{301}ka ọwọ\u{301}"),
            keywords: &[
                "obìnrin",
                "obìnrin tí ń tọ\u{301}ka ọwọ\u{301}",
                "sassy",
                "tọ\u{301}ka ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("做提示手勢嘅女人"),
            keywords: &["做提示手勢嘅女人", "女", "提示手勢", "時髦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("做提示手势嘅女人"),
            keywords: &["做提示手势嘅女人", "女", "提示手势", "时髦"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("前台女"),
            keywords: &["前台", "前台女", "女"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生抬手"),
            keywords: &["女", "女生抬手", "小費"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("攤開手嘅女人"),
            keywords: &["攤開手嘅女人", "攤開手｜貼士｜女人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame ocela ngesandla"),
            keywords: &[
                "isandla",
                "owesimame imali",
                "owesimame ocela ngesandla",
                "usizo",
            ],
        },
    ],
};
#[doc = "💁🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_TIPPING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F481 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman tipping hand: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏻\u{200d}♀",
        codepoint: "1F481 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman tipping hand: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_TIPPING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F481 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman tipping hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏼\u{200d}♀",
        codepoint: "1F481 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman tipping hand: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_TIPPING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F481 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman tipping hand: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏽\u{200d}♀",
        codepoint: "1F481 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman tipping hand: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_TIPPING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F481 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman tipping hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏾\u{200d}♀",
        codepoint: "1F481 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman tipping hand: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "💁🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_TIPPING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💁🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F481 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman tipping hand: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "💁🏿\u{200d}♀",
        codepoint: "1F481 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman tipping hand: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋"]
pub const PERSON_RAISING_HAND: crate::Emoji = crate::Emoji {
    glyph: "🙋",
    codepoint: "1F64B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person raising hand",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon wat hand opsteek"),
            keywords: &[
                "gebaar",
                "gelukkig",
                "gelukkige persoon met hand in die lug",
                "hand",
                "omhoog",
                "persoon wat hand opsteek",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደስ ያለው እጁን የሚያወጣ ሰው"),
            keywords: &["እጅ", "ከፍ ያደረገ", "የእጅ ምልክት", "ደስ ያለው እጁን የሚያወጣ ሰው", "ደስተኛ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}شخص يرفع يده"),
            keywords: &["إشارة", "رفع اليد", "سعادة", "شخص", "\u{202b}شخص يرفع يده"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত দ\u{9be}ঙি থক\u{9be} স\u{9c1}খী ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ভঙ\u{9cd}গীম\u{9be}",
                "স\u{9c1}খী",
                "হ\u{9be}ত",
                "হ\u{9be}ত দঙ\u{9be}",
                "হ\u{9be}ত দ\u{9be}ঙি থক\u{9be} স\u{9c1}খী ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əlini qaldıran xoşbəxt adam"),
            keywords: &[
                "jest",
                "qaldırılmış",
                "xoşbəxt",
                "əl",
                "əlini qaldıran xoşbəxt adam",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек цягне руку"),
            keywords: &[
                "жэст",
                "паднятая рука",
                "радасны",
                "рука",
                "чалавек цягне руку",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Щастлив човек, вдигнал ръка"),
            keywords: &[
                "Щастлив човек, вдигнал ръка",
                "вдигнат",
                "жест",
                "ръка",
                "щастлив",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}খি ব\u{9cd}যক\u{9cd}তি যিনি হ\u{9be}ত ত\u{9c1}লেছেন"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "উত\u{9cd}থিত",
                "খ\u{9c1}শি",
                "স\u{9c1}খি ব\u{9cd}যক\u{9cd}তি যিনি হ\u{9be}ত ত\u{9c1}লেছেন",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba podiže ruku"),
            keywords: &[
                "gestikulacija",
                "informacije",
                "osoba podiže ruku",
                "ruke",
                "sretan",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona amb la mà aixecada"),
            keywords: &[
                "mà aixecada",
                "persona",
                "persona amb la mà aixecada",
                "persona contenta que aixeca la mà",
                "somriure",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᏬᏰᎾ ᎠᎵᏌᎵᏛᏍᎬᎢ"),
            keywords: &["ᎤᎵᎮᎵᏍᏗ", "ᎤᏌᎳᏗ", "ᎤᏬᏱ", "ᏓᏐᏰᏍᎬ", "ᏴᏫ ᎤᏬᏰᎾ ᎠᎵᏌᎵᏛᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba se zvednutou rukou"),
            keywords: &[
                "gesto",
                "osoba se zvednutou rukou",
                "ruka",
                "zvednutá",
                "šťastný",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn codi llaw"),
            keywords: &["hapus", "llaw", "person yn codi llaw", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("person med løftet hånd"),
            keywords: &["hej", "løftet hånd", "person med løftet hånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Person mit erhobenem Arm"),
            keywords: &["Person mit erhobenem Arm", "Siegerpose"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο με σηκωμένο χέρι"),
            keywords: &[
                "άτομο με σηκωμένο χέρι",
                "κίνηση",
                "σηκωμένο",
                "χέρι",
                "χαρούμενος",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person raising hand"),
            keywords: &["gesture", "hand", "happy", "person raising hand", "raised"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona con la mano levantada"),
            keywords: &[
                "feliz",
                "gesto",
                "levantar",
                "mano",
                "persona con la mano levantada",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("persona levantando la mano"),
            keywords: &[
                "contenta",
                "levantar",
                "mano",
                "persona",
                "persona levantando la mano",
                "yo",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "levantar",
                "mano",
                "persona",
                "persona levantando la mano",
                "yo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("persona con la mano levantada"),
            keywords: &[
                "gesto",
                "levantar",
                "mano",
                "persona",
                "persona con la mano levantada",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kätt tõstev rõõmus inimene"),
            keywords: &[
                "käsi",
                "kätt tõstev rõõmus inimene",
                "rõõmus",
                "õnnelik",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskua altxatzen ari den pertsona"),
            keywords: &[
                "altxatuta",
                "esku",
                "eskua altxatzen ari den pertsona",
                "keinu",
                "pozik",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ای ول"),
            keywords: &["ای ول", "بالا", "دست", "شاد", "ژست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("iloinen henkilö viittaa"),
            keywords: &[
                "ele",
                "iloinen",
                "iloinen henkilö viittaa",
                "käsi",
                "nostettu",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("masayang tao na nakataas ang kamay"),
            keywords: &[
                "gesture",
                "kamay",
                "masaya",
                "masayang tao na nakataas ang kamay",
                "nakataas ang kamay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur sum lyftur hondina upp"),
            keywords: &[
                "fólk",
                "hond",
                "lyft",
                "persónur",
                "persónur sum lyftur hondina upp",
                "upp",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne qui lève la main"),
            keywords: &[
                "content",
                "geste",
                "levée",
                "main",
                "personne qui lève la main",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine lena lámh suas"),
            keywords: &[
                "duine",
                "duine ag ardú láimhe",
                "duine lena lámh suas",
                "gotha",
                "lámh á hardú",
                "sona",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach a’ togail a làmh"),
            keywords: &[
                "gluasad",
                "làmh",
                "neach a’ togail a làmh",
                "tog",
                "togail",
                "toiliche",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("levantar a man"),
            keywords: &["levantar a man", "man levantada", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ ઉપર ઉઠાવતી ખ\u{ac1}શ વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "ઉપર હાથ ઉઠાવવો",
                "ખ\u{ac1}શ",
                "વ\u{acd}યક\u{acd}તિ",
                "હાથ ઉપર ઉઠાવતી ખ\u{ac1}શ વ\u{acd}યક\u{acd}તિ",
                "હાથ ઉપર ઉઠાવ\u{ac7}લ વ\u{acd}યક\u{acd}તિ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai ɗagawa hannu"),
            keywords: &[
                "hannu",
                "karimcin",
                "murna",
                "mutum mai ɗagawa hannu",
                "ɗagagge",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מרימה את היד"),
            keywords: &[
                "אישה מרימה את היד",
                "אישה שמחה מרימה יד",
                "יד מורמת",
                "סימן ידיים",
                "שמחה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाथ उठाता ख\u{941}श व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "ख\u{941}श",
                "व\u{94d}यक\u{94d}ति",
                "हाथ उठाता ख\u{941}श व\u{94d}यक\u{94d}ति",
                "हाथ उठाता व\u{94d}यक\u{94d}ति",
                "हाथ उठाना",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba s podignutom rukom"),
            keywords: &[
                "kretnja",
                "osoba s podignutom rukom",
                "podići",
                "ruka",
                "sreća",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vidáman intő ember"),
            keywords: &["boldog", "integet", "vidám", "vidáman intő ember"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռք բարձրացնող ուրախ անձ"),
            keywords: &[
                "բարձրացված",
                "երջանիկ",
                "ժեստ",
                "ձեռք",
                "ձեռք բարձրացնող ուրախ անձ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang mengangkat tangan"),
            keywords: &[
                "angkat",
                "gerakan",
                "orang mengangkat tangan",
                "senang",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-ewelite aka"),
            keywords: &[
                "aka",
                "aṅụrị",
                "ewelitere",
                "ogbugbu",
                "onye na-ewelite aka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("gleði"),
            keywords: &["gleði", "upprétt hönd", "önnur hönd"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona con mano alzata"),
            keywords: &[
                "felice",
                "gesto",
                "mano alzata",
                "persona",
                "persona con mano alzata",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手を挙げる人"),
            keywords: &["人", "手を挙げる", "手を挙げる人", "挙手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong ngacungake tangan"),
            keywords: &[
                "bungah",
                "isarat",
                "ngacung",
                "tangan",
                "wong ngacungake tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბედნიერი ხელაწეული პიროვნება"),
            keywords: &[
                "აწეული",
                "ბედნიერი",
                "ბედნიერი ხელაწეული პიროვნება",
                "ჟესტი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолды көтеру"),
            keywords: &["көтерілген", "қимыл", "қол", "қолды көтеру", "қуанышты"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("glad person"),
            keywords: &["glad person", "hej", "løftet hånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សលើកដៃ"),
            keywords: &[
                "កាយវ\u{17b7}ការ",
                "ដៃ",
                "មន\u{17bb}ស\u{17d2}សលើកដៃ",
                "លើក",
                "សប\u{17d2}បាយ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಂತೋಷದ\u{cbf}ಂದ ಕೈ ಎತ\u{ccd}ತುತ\u{ccd}ತ\u{cbf}ರುವುದು"),
            keywords: &[
                "ಪೋಷ\u{cbf}ಸುವ ಕೈ",
                "ಸಂತೋಷದ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಸಂತೋಷದ\u{cbf}ಂದ ಕೈ ಎತ\u{ccd}ತುತ\u{ccd}ತ\u{cbf}ರುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("한 손 든 사람"),
            keywords: &[
                "즐거워하는 사람",
                "한 손 든 사람",
                "한 손을 든 사람",
                "한 손을 들고 즐거워하는 사람",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती हात वयर काडटा"),
            keywords: &[
                "व\u{94d}यक\u{94d}ती हात वयर काडटा",
                "हावभाव। हात। ख\u{941}शाल। व\u{94d}यक\u{94d}ती हात वयर काडटा। वयर काडला",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол көтөрүп жаткан бактылуу адам"),
            keywords: &[
                "бактылуу",
                "ишарат",
                "кол",
                "кол көтөрүп жаткан адам",
                "кол көтөрүп жаткан бактылуу адам",
                "көтөрүлгөн",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun, déi d’Hand hieft"),
            keywords: &[
                "Geste",
                "Hand",
                "Persoun, déi d’Hand hieft",
                "gehuewen",
                "glécklech",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນດ\u{eb5}ໃຈຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຄວາມສ\u{eb8}ກ",
                "ຄ\u{ebb}ນດ\u{eb5}ໃຈຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ",
                "ທ\u{ec8}າທາງ",
                "ມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žmogus, iškėlęs ranką"),
            keywords: &[
                "gestas",
                "iškelta",
                "laimingas",
                "ranka",
                "žmogus, iškėlęs ranką",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks ar paceltu roku"),
            keywords: &[
                "cilvēks ar paceltu roku",
                "laimīgs",
                "pacelts",
                "roka",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata ringa tū"),
            keywords: &["koa", "ringa", "tangata ringa tū", "tohu ā-ringa", "tū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице со подигната рака"),
            keywords: &[
                "гест",
                "лице со подигната рака",
                "подигната",
                "радост",
                "среќа",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "കൈ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}ന സന\u{d4d}തോഷവ\u{d3e}ന\u{d3e}യ വ\u{d4d}യക\u{d4d}തി",
            ),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ഉയർത\u{d4d}ത\u{d41}ക",
                "കൈ",
                "കൈ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}ന സന\u{d4d}തോഷവ\u{d3e}ന\u{d3e}യ വ\u{d4d}യക\u{d4d}തി",
                "സന\u{d4d}തോഷം",
                "സന\u{d4d}തോഷവ\u{d3e}ന\u{d3e}യ വ\u{d4d}യക\u{d4d}തി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баярлаж, гараа өргөсөн хүн"),
            keywords: &[
                "баярлаж, гараа өргөсөн хүн",
                "баярласан",
                "гар",
                "өргөх хүн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("एक हात उ\u{902}चावणारी आन\u{902}दी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "आन\u{902}दी",
                "उ\u{902}चावल\u{947}ल\u{947}",
                "एक हात उ\u{902}चावणारी आन\u{902}दी व\u{94d}यक\u{94d}ती",
                "हात",
                "हात उ\u{902}चावणारी व\u{94d}यक\u{94d}ती",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang gembira mengangkat tangan"),
            keywords: &[
                "angkat",
                "gembira",
                "isyarat",
                "orang gembira mengangkat tangan",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tgħolli idha"),
            keywords: &[
                "bl-idejn",
                "għolli",
                "kuntentizza",
                "persuna tgħolli idha",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ပြနေသော ပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}နေသ\u{1030}",
            ),
            keywords: &[
                "ပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}ခြင\u{103a}း",
                "လက\u{103a}",
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ပြနေသ\u{1030}",
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ပြနေသော ပျော\u{103a}ရ\u{103d}\u{103e}င\u{103a}နေသ\u{1030}",
                "အမ\u{1030}အရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rekker opp hånden"),
            keywords: &["hånd", "person", "rekker opp", "rekker opp hånden"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हात उठाइह\u{947}को ख\u{941}शी व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "उठाएको",
                "ख\u{941}शी",
                "भाव प\u{94d}रदर\u{94d}शन",
                "हात",
                "हात उठाइह\u{947}को ख\u{941}शी व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon met opgeheven hand"),
            keywords: &[
                "blij",
                "gebaar",
                "hand",
                "omhoog",
                "persoon met opgeheven hand",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rekker opp handa"),
            keywords: &["hand", "person", "rekker opp", "rekker opp handa"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ତ ଉଠ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଉଠ\u{b3e}ଇବ\u{b3e}",
                "ଖ\u{b41}ସୀ",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତ ଉଠ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਥ ਚ\u{a41}\u{a71}ਕਦਾ ਖ\u{a41}ਸ\u{a3c} ਵਿਅਕਤੀ"),
            keywords: &[
                "ਖ\u{a41}ਸ\u{a3c}",
                "ਵਿਅਕਤੀ",
                "ਵਿਅਕਤੀ ਰ\u{a71}ਥ ਚ\u{a41}\u{a71}ਕ ਰਿਹਾ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਹ\u{a71}ਥ ਚ\u{a41}\u{a71}ਕ ਰਿਹਾ",
                "ਹ\u{a71}ਥ ਚ\u{a41}\u{a71}ਕਦਾ ਖ\u{a41}ਸ\u{a3c} ਵਿਅਕਤੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ ا\u{64f}وچا کردا بندا"),
            keywords: &[
                "اشارہ",
                "ا\u{64f}بھریا ہوئیا",
                "خوش",
                "ہتھ",
                "ہتھ ا\u{64f}وچا کردا بندا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé De Réz Im Hand Ọp"),
            keywords: &[
                "Hand",
                "Hápí",
                "Pẹ\u{301}sin Wé De Réz Im Hand Ọp",
                "Rez",
                "Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba podnosząca rękę"),
            keywords: &["osoba podnosząca rękę", "ręka do góry", "witaj!"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص لاس اوچتوي"),
            keywords: &["اشاره", "اوچت کړي", "خوشاله", "شخص لاس اوچتوي", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa levantando a mão"),
            keywords: &[
                "feliz",
                "gesto",
                "levantando a mão",
                "pessoa",
                "pessoa levantando a mão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa de mão levantada"),
            keywords: &[
                "alegre",
                "gesto",
                "mão",
                "mão levantada",
                "pessoa de mão levantada",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa makita hatarichiy"),
            keywords: &[
                "gesto",
                "hatarichisqa",
                "kusi",
                "maki",
                "runa makita hatarichiy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană care ridică mâna"),
            keywords: &[
                "gest",
                "mână",
                "persoană care ridică mâna",
                "ridicat",
                "veselie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-911"),
            keywords: &["E10-911"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек с поднятой рукой"),
            keywords: &[
                "жест",
                "поднятая рука",
                "рука",
                "человек",
                "человек с поднятой рукой",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu wazamuye ikiganza"),
            keywords: &[
                "ikiganza",
                "ikimenyetso",
                "ikizamuye",
                "umuntu wazamuye ikiganza",
                "wishimye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص هٿ مٿي ڪندي"),
            keywords: &["اشارو", "خوش", "شخص هٿ مٿي ڪندي", "مٿي ڪيو", "هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "අත ඔසවන ප\u{dca}\u{200d}ර\u{dd3}ත\u{dd2}මත\u{dca} ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
            ),
            keywords: &[
                "අත",
                "අත ඔසවන ප\u{dca}\u{200d}ර\u{dd3}ත\u{dd2}මත\u{dca} ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "අභ\u{dd2}න",
                "උස\u{dca}සන ලද",
                "ප\u{dca}\u{200d}ර\u{dd3}ත\u{dd2}මත\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek so zdvihnutou rukou"),
            keywords: &["gesto", "ruka", "zdvihnutá", "človek so zdvihnutou rukou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vesela oseba, ki dvigne roko"),
            keywords: &[
                "dvignjeno",
                "gesta",
                "roka",
                "vesela oseba, ki dvigne roko",
                "veselo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof gacan taagaya"),
            keywords: &[
                "farxad",
                "gacan",
                "meedaar",
                "qof gacan taagaya",
                "qof gcan taagaya",
                "taagay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri i gëzuar që ngre dorën"),
            keywords: &[
                "dorë",
                "e gëzuar",
                "e ngritur",
                "gjest",
                "njeri i gëzuar që ngre dorën",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("срећна особа са подигнутом руком"),
            keywords: &[
                "крeтање",
                "пoдићи",
                "рукa",
                "срeћa",
                "срећна особа са подигнутом руком",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srećna osoba sa podignutom rukom"),
            keywords: &[
                "kretanje",
                "podići",
                "ruka",
                "sreća",
                "srećna osoba sa podignutom rukom",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person som räcker upp handen"),
            keywords: &[
                "person",
                "person som räcker upp handen",
                "räcker upp handen",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu mwenye furaha aliyeinua mkono"),
            keywords: &[
                "furaha",
                "inuliwa",
                "ishara",
                "mkono",
                "mtu mwenye furaha aliyeinua mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மகிழ\u{bcd}ச\u{bcd}சியில\u{bcd} ஒரு கையை உயர\u{bcd}த\u{bcd}துபவர\u{bcd}"),
            keywords: &[
                "மகிழ\u{bcd}ச\u{bcd}சி சின\u{bcd}னம\u{bcd}",
                "மகிழ\u{bcd}ச\u{bcd}சியில\u{bcd} ஒரு கையை உயர\u{bcd}த\u{bcd}துபவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఆనందంత\u{c4b} ఒక చ\u{c47}త\u{c3f}న\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ),
            keywords: &[
                "ఆనందం",
                "ఆనందంత\u{c4b} ఒక చ\u{c47}త\u{c3f}న\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "చ\u{c47}య\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки дасташро бардошта истодааст"),
            keywords: &[
                "бардошта",
                "даст",
                "имову ишора",
                "хурсанд",
                "шахсе, ки дасташро бардошта истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ยกม\u{e37}อข\u{e36}\u{e49}น"),
            keywords: &[
                "ม\u{e35}ความส\u{e38}ข",
                "ม\u{e37}อ",
                "ยกม\u{e37}อข\u{e36}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini galdyrýan adam"),
            keywords: &["bagtly", "el", "elini galdyrýan adam", "galdyrylan", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha nima ʻi ʻolunga"),
            keywords: &["tokotaha nima ʻi ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elini kaldırma"),
            keywords: &[
                "el kaldıran kişi",
                "elini kaldırma",
                "hareket",
                "kalkan el",
                "kişi",
                "mutlu",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قول كۆتۈرگەن كىشى"),
            keywords: &["ئىشارە", "خۇشال", "قول", "قول كۆتۈرگەن كىشى", "كۆتۈرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина з піднятою рукою"),
            keywords: &[
                "жест",
                "людина з піднятою рукою",
                "піднята",
                "рука",
                "щасливий",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ بلند کیے خوش شخص"),
            keywords: &["اٹھانا", "خوش", "ہاتھ", "ہاتھ بلند کیے خوش شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘lini ko‘tarib turgan xursand odam"),
            keywords: &[
                "imo-ishora",
                "ko‘tarilgan",
                "qo‘l",
                "qo‘lini ko‘tarib turgan xursand odam",
                "xursand",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người giơ cao tay"),
            keywords: &[
                "cử chỉ",
                "người giơ cao tay",
                "người vui vẻ giơ cao tay",
                "nâng lên",
                "tay",
                "vui vẻ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit kuy yëkkati loxo"),
            keywords: &[
                "buñ yëkkati",
                "kontaan",
                "liyaar",
                "loxo",
                "nit kuy yëkkati loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ophakamisa isandla"),
            keywords: &[
                "ephakanyisiweyo",
                "isandla",
                "jekula",
                "ukonwaba",
                "umntu ophakamisa isandla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni N Nawọ Soke"),
            keywords: &[
                "fọwọ\u{301}júwè",
                "gbéga",
                "ìdùnú",
                "Ẹni N Nawọ Soke",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舉手嘅人"),
            keywords: &["快樂", "手", "手勢", "舉手", "舉手嘅人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("举手嘅人"),
            keywords: &["举手", "举手嘅人", "快乐", "手", "手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("举手"),
            keywords: &["举手", "开心"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("嗨"),
            keywords: &["嗨", "舉手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("舉起一隻手"),
            keywords: &["舉起一隻手", "開心｜舉起一隻手｜哈囉｜hi"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu ophakamisa isandla"),
            keywords: &[
                "isandla",
                "ukujabula",
                "ukuphakamisa",
                "umuntu ophakamisa isandla",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙋🏻"]
pub const PERSON_RAISING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏻",
    codepoint: "1F64B 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person raising hand: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙋🏼"]
pub const PERSON_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏼",
    codepoint: "1F64B 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person raising hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙋🏽"]
pub const PERSON_RAISING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏽",
    codepoint: "1F64B 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person raising hand: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙋🏾"]
pub const PERSON_RAISING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏾",
    codepoint: "1F64B 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person raising hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙋🏿"]
pub const PERSON_RAISING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏿",
    codepoint: "1F64B 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person raising hand: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙋\u{200d}♂\u{fe0f}"]
pub const MAN_RAISING_HAND: crate::Emoji = crate::Emoji {
    glyph: "🙋\u{200d}♂\u{fe0f}",
    codepoint: "1F64B 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man raising hand",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋\u{200d}♂",
        codepoint: "1F64B 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man raising hand",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man wat hand opsteek"),
            keywords: &[
                "groet",
                "lig hand",
                "man lig hand",
                "man wat hand opsteek",
                "waai",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ እጅ ማውጣት"),
            keywords: &["እጅ", "ከፍ ያደረገ", "ወንድ", "የእጅ ምልክት", "የወንድ እጅ ማውጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل يرفع يده"),
            keywords: &["رجل يرفع يده", "يد مرفوعة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত দ\u{9be}ঙি থক\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ভঙ\u{9cd}গীম\u{9be}",
                "হ\u{9be}ত দঙ\u{9be}",
                "হ\u{9be}ত দ\u{9be}ঙি থক\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl qaldıran kişi"),
            keywords: &["jest", "kişi", "əl qaldıran kişi", "əl qaldırmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына цягне руку"),
            keywords: &["жэст", "мужчына", "мужчына цягне руку", "цягне руку"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("щастлив мъж, вдигнал ръка"),
            keywords: &[
                "вдигната ръка",
                "жест с ръка",
                "щастлив",
                "щастлив мъж, вдигнал ръка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলেদের হ\u{9be}ত তোল\u{9be}"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ছেলেদের হ\u{9be}ত তোল\u{9be}",
                "প\u{9c1}র\u{9c1}ষ",
                "হ\u{9be}ত",
                "হ\u{9be}ত তোল\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac podiže ruku"),
            keywords: &["gestikulacija", "muškarac", "muškarac podiže ruku"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home amb la mà aixecada"),
            keywords: &["gest", "home", "home amb la mà aixecada", "masculí", "mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏎᎵᏔ"),
            keywords: &["ᎠᏌᎳᏗᏍᎬ ᎤᏬᏰᏂ", "ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ ᎤᏎᎵᏔ", "ᏓᏐᏰᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž se zvednutou rukou"),
            keywords: &[
                "muž",
                "muž se zvednutou rukou",
                "přihlášení",
                "ruka",
                "zvednutí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn codi ei law"),
            keywords: &["dyn", "dyn yn codi ei law", "hapus", "llaw", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand med løftet hånd"),
            keywords: &[
                "gestus",
                "hej",
                "hilsen",
                "løftet hånd",
                "mand",
                "mand med løftet hånd",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann mit erhobenem Arm"),
            keywords: &["Geste", "Mann", "Mann mit erhobenem Arm", "Siegerpose"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας με σηκωμένο χέρι"),
            keywords: &[
                "άντρας",
                "άντρας με σηκωμένο χέρι",
                "χαιρετισμός",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man raising hand"),
            keywords: &["gesture", "man", "man raising hand", "raising hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre con la mano levantada"),
            keywords: &[
                "gesto",
                "hombre",
                "hombre con la mano levantada",
                "levantar",
                "mano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kätt tõstev mees"),
            keywords: &["käsi", "kätt tõstev mees", "mees", "tervitus", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskua altxatzen ari den gizona"),
            keywords: &[
                "eskua altxatuta",
                "eskua altxatzen ari den gizona",
                "gizon",
                "gizonezko",
                "keinu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد دستش را بالا می\u{200c}برد"),
            keywords: &[
                "احترام",
                "سلام دادن",
                "سلام کردن",
                "مرد دستش را بالا می\u{200c}برد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viittaava mies"),
            keywords: &["käsi", "mies", "viittaava mies", "viittaus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking nakataas ang kamay"),
            keywords: &[
                "lalaki",
                "lalaking nakataas ang kamay",
                "nakataas ang kamay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður sum lyftur hondina upp"),
            keywords: &[
                "hond",
                "lyft",
                "maður",
                "maður sum lyftur hondina upp",
                "upp",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme qui lève la main"),
            keywords: &["geste", "homme", "homme qui lève la main", "main levée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear lena lámh suas"),
            keywords: &[
                "cor",
                "fear",
                "fear le lámha suas",
                "fear lena lámh suas",
                "fearann",
                "lámha suas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine a’ togail a làmh"),
            keywords: &[
                "duine",
                "duine a’ togail a làmh",
                "fear",
                "fireannach",
                "gluasad",
                "làmh",
                "tog",
                "togail",
                "toiliche",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home levantando a man"),
            keywords: &["home", "home levantando a man", "man levantada", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ ઉપર ઉઠાવતો ખ\u{ac1}શ પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "ઉપર હાથ ઉઠાવવો",
                "પ\u{ac1}ર\u{ac1}ષ",
                "હાથ ઉપર ઉઠાવતો ખ\u{ac1}શ પ\u{ac1}ર\u{ac1}ષ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji mai ɗagawa hannu"),
            keywords: &[
                "karimcin",
                "mutum",
                "namiji mai ɗagawa hannu",
                "ɗagawa hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר מרים יד"),
            keywords: &["איש", "גבר", "גבר מרים יד", "מצביע", "מרים יד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाथ उठाया ह\u{941}आ प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "इशारा",
                "ऊपर उठा हाथ",
                "प\u{941}र\u{941}ष",
                "हाथ उठाया ह\u{941}आ प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac podiže ruku"),
            keywords: &["gestikulacija", "muškarac podiže ruku", "podignuta ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vidáman intő férfi"),
            keywords: &[
                "férfi",
                "gesztus",
                "intés",
                "kézmozdulat",
                "vidám",
                "vidáman intő férfi",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքը բարձրացրած տղամարդ"),
            keywords: &[
                "ժեստ",
                "ձեռքը բարձրացնել",
                "ձեռքը բարձրացրած տղամարդ",
                "մարդ",
                "տղամարդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria mengangkat tangan"),
            keywords: &[
                "angkat",
                "isyarat",
                "laki-laki",
                "pria mengangkat tangan",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-ewelite aka"),
            keywords: &["na-ewelite aka", "nwoke", "nwoke na-ewelite aka", "ogbugbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður réttir upp hönd"),
            keywords: &[
                "karl",
                "maður réttir upp hönd",
                "rétta upp hönd",
                "upprétt hönd",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo con mano alzata"),
            keywords: &["gesto", "mano alzata", "uomo", "uomo con mano alzata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手を挙げる男"),
            keywords: &["手を挙げる", "手を挙げる男", "挙手", "男", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang ngacungake tangan"),
            keywords: &[
                "isarat",
                "ngacungake tangan",
                "wong lanang",
                "wong lanang ngacungake tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელაწეული კაცი"),
            keywords: &["კაცი", "ჟესტი", "ხელაწეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолын көтеріп тұрған ер"),
            keywords: &["ер", "қимыл", "қол көтеру", "қолын көтеріп тұрған ер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand med løftet hånd"),
            keywords: &[
                "gestus",
                "hej",
                "hilsen",
                "løftet hånd",
                "mand",
                "mand med løftet hånd",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសលើកដៃ"),
            keywords: &[
                "កាយវ\u{17b7}ការ",
                "ប\u{17bb}រស",
                "ប\u{17bb}រសលើកដៃ",
                "លើកដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈ ಎತ\u{ccd}ತ\u{cbf}ದ ಪುರುಷ"),
            keywords: &[
                "ಅಂಗ ಸನ\u{ccd}ನ\u{cc6}",
                "ಕೈ ಎತ\u{ccd}ತ\u{cbf}ದ ಪುರುಷ",
                "ಕೈ ಎತ\u{ccd}ತು",
                "ಪುರುಷ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("한 손 든 남자"),
            keywords: &["손들기", "여기요", "저요", "한 손 든 남자", "한손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो हात वयर काडटा"),
            keywords: &[
                "दादलो हात वयर काडटा",
                "हावभाव। दादलो। दादलो हात वयर काडटा। हात वयर काडटा",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колун көтөрүп жаткан эркек"),
            keywords: &[
                "ишарат",
                "кол көтөрүү",
                "колун көтөрүп жаткан эркек",
                "эркек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann, deen d’Hand hieft"),
            keywords: &["Geste", "Mann", "Mann, deen d’Hand hieft", "gehuewen Hand"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍຍ\u{ebb}ກມ\u{eb7}"),
            keywords: &[
                "ຍ\u{ebb}ກມ\u{eb7}",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍຍ\u{ebb}ກມ\u{eb7}",
                "ມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ranką pakėlęs vyras"),
            keywords: &["gestas", "pakelta ranka", "ranką pakėlęs vyras", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis ar paceltu roku"),
            keywords: &[
                "pacelta roka",
                "vīrietis",
                "vīrietis ar paceltu roku",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne ringa tū"),
            keywords: &["ringa tū", "tohu ā-ringa", "tāne", "tāne ringa tū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж со подигната рака"),
            keywords: &["гест", "маж", "маж со подигната рака", "подигната рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൈ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "കൈ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "കൈ ഉയർത\u{d4d}തൽ",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "സന\u{d4d}തോഷം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гараа өргөж буй эрэгтэй"),
            keywords: &[
                "гараа өргөж буй эрэгтэй",
                "гараа өргөх",
                "дохио",
                "эр",
                "эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हात वर क\u{947}ल\u{947}ला प\u{941}र\u{941}ष"),
            keywords: &[
                "प\u{941}र\u{941}ष",
                "हात उ\u{902}चावणारा प\u{941}र\u{941}ष",
                "हात उ\u{902}चावण\u{947}",
                "हात वर क\u{947}ल\u{947}ला प\u{941}र\u{941}ष",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki mengangkat tangan"),
            keywords: &[
                "gerak isyarat",
                "lelaki",
                "lelaki mengangkat tangan",
                "mengangkat tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jgħolli idejh"),
            keywords: &["jgħolli l-idejn", "raġel", "raġel jgħolli idejh", "ġesti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ထားသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "လက\u{103a}မြ\u{103e}ောက\u{103a}",
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ထားသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသား",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann som rekker opp hånden"),
            keywords: &["mann", "mann som rekker opp hånden", "rekke opp hånden"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हात उठाइरह\u{947}को छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "इसारा",
                "उठिरह\u{947}को हात",
                "छोरा मान\u{94d}छ\u{947}",
                "प\u{941}\u{941}र\u{942}ष",
                "हात उठाइरह\u{947}को छोरामान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man met opgeheven hand"),
            keywords: &["gebaar", "hand opsteken", "man", "man met opgeheven hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann som rekker opp handa"),
            keywords: &["mann", "mann som rekker opp handa", "rekke opp handa"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ତ ଉଠ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଉଠ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ହ\u{b3e}ତ ଉଠ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਥ ਉਠਾਉ\u{a02}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਹ\u{a71}ਥ ਉਠਾਉ\u{a02}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਹ\u{a71}ਥ ਉਠਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ ا\u{64f}وتے کردا بندہ"),
            keywords: &[
                "اشارہ",
                "بندہ",
                "ہتھ ا\u{64f}وتے کردا بندہ",
                "ہتھ ا\u{64f}وتے کرنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé De Réz Im Hand Ọp"),
            keywords: &[
                "Hand",
                "Hand Wé Dẹm Réz Ọp",
                "Man Wé De Réz Im Hand Ọp",
                "Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna podnoszący rękę"),
            keywords: &[
                "gest",
                "hej",
                "mężczyzna",
                "mężczyzna podnoszący rękę",
                "powitanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی لاس اوچتوي"),
            keywords: &["اشاره", "سړی", "سړی لاس اوچتوي", "لاس اوچتول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem levantando a mão"),
            keywords: &[
                "gesto",
                "homem",
                "homem levantando a mão",
                "mão",
                "pedir a palavra",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem de mão levantada"),
            keywords: &["gesto", "homem", "homem de mão levantada", "mão levantada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata makita hatarichiy"),
            keywords: &[
                "gesto",
                "hatarichisqa maki",
                "tata",
                "tata makita hatarichiy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat care ridică mâna"),
            keywords: &["bărbat", "bărbat care ridică mâna", "gest", "mână ridicată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1217"),
            keywords: &["E10-1217"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина с поднятой рукой"),
            keywords: &[
                "жест",
                "мужчина",
                "мужчина с поднятой рукой",
                "поднятая рука",
                "рука",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo uzamuye ikiganza"),
            keywords: &[
                "ikimenyetso",
                "kuzamura ikiganza",
                "umugabo",
                "umugabo uzamuye ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد هٿ مٿي ڪندي"),
            keywords: &["اشارو", "مرد", "مرد هٿ مٿي ڪندي", "هٿ مٿي ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත ඔසවන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "අත එසව\u{dd3}ම",
                "අත ඔසවන ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "අභ\u{dd2}නය",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž so zdvihnutou rukou"),
            keywords: &["muž", "muž so zdvihnutou rukou", "ruka", "zdvihnutá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški, ki dviguje roko"),
            keywords: &[
                "dvigovanje roke",
                "fant",
                "kretnje",
                "moški",
                "moški, ki dviguje roko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin gcan taagaya"),
            keywords: &[
                "gacan taagid",
                "meedaar",
                "nin",
                "nin gacan taagaya",
                "nin gcan taagaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë që ngre dorën"),
            keywords: &["burrë", "burrë që ngre dorën", "dorë e ngritur", "gjest"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац подиже руку"),
            keywords: &[
                "гестикулација",
                "информације",
                "мушкарац",
                "мушкарац подиже руку",
                "руке",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac podiže ruku"),
            keywords: &[
                "gestikulacija",
                "informacije",
                "muškarac",
                "muškarac podiže ruku",
                "ruke",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man som räcker upp handen"),
            keywords: &["man", "man som räcker upp handen", "räcka upp handen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu aliyeinua mkono"),
            keywords: &[
                "furaha",
                "inua mkono",
                "mkono",
                "mtu aliyeinua mkono",
                "mwanamume mwenye furaha aliyeinua mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கை உயர\u{bcd}த\u{bcd}தும\u{bcd} ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "உயர\u{bcd}த\u{bcd}துதல\u{bcd}",
                "கை",
                "கை உயர\u{bcd}த\u{bcd}தும\u{bcd} ஆண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}య\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న పురుషుడు"),
            keywords: &[
                "చ\u{c47}య\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}తడం",
                "చ\u{c47}య\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న పురుషుడు",
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "సంజ\u{c4d}ఞ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки дасташро бардошта истодааст"),
            keywords: &[
                "дасти бардошта",
                "имову ишора",
                "мард",
                "марде, ки дасташро бардошта истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายยกม\u{e37}อ"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายยกม\u{e37}อ",
                "ยกม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini galdyrýan erkek"),
            keywords: &["elini galdyrýan erkek", "eliňi galdyrmak", "erkek", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata nima ʻi ʻolunga"),
            keywords: &["tangata nima ʻi ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elini kaldıran erkek"),
            keywords: &[
                "adam",
                "el kaldırma",
                "elini kaldıran erkek",
                "erkek",
                "hareket",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قول كۆتۈرگەن ئەر"),
            keywords: &["ئىشارە", "ئەر", "قول كۆتۈرگەن ئەر", "قول كۆتۈرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік із піднятою рукою"),
            keywords: &[
                "піднята рука",
                "рука",
                "чоловік",
                "чоловік із піднятою рукою",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ اٹھاتا ہوا مرد"),
            keywords: &["اشارہ", "مرد", "ہاتھ اٹھاتا ہوا مرد", "ہاتھ اٹھانا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak qo‘l ko‘tarmoqda"),
            keywords: &[
                "erkak",
                "erkak qo‘l ko‘tarmoqda",
                "imo-ishora",
                "qo‘l ko‘tarish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông giơ cao tay"),
            keywords: &[
                "cử chỉ",
                "giơ tay",
                "nam",
                "người đàn ông",
                "người đàn ông giơ cao tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor yëkkati loxo"),
            keywords: &["góor", "góor yëkkati loxo", "liyaar", "yëkkati loxo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda ephakamisa isandla"),
            keywords: &[
                "indoda",
                "indoda ephakamisa isandla",
                "jekula",
                "phakamisa isandla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrintí ń nawọ\u{301} sókè"),
            keywords: &[
                "fọwọ\u{301}júwè",
                "nawọ\u{301} sókè",
                "ọkùnrin",
                "ọkùnrintí ń nawọ\u{301} sókè",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舉手嘅男人"),
            keywords: &["手勢", "男", "舉手", "舉手嘅男人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("举手嘅男人"),
            keywords: &["举手", "举手嘅男人", "手势", "男"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男生举手"),
            keywords: &["举手", "男", "男生举手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生舉手"),
            keywords: &["嗨", "打招呼", "男", "男生舉手", "舉手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("開心｜舉起一隻手｜男人｜哈囉｜hi"),
            keywords: &["開心｜舉起一隻手｜男人｜哈囉｜hi"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda ephakamise isandla"),
            keywords: &[
                "indoda",
                "indoda ephakamise isandla",
                "isandla",
                "ukujabula",
                "ukuphakamisa",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙋🏻\u{200d}♂\u{fe0f}"]
pub const MAN_RAISING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F64B 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man raising hand: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏻\u{200d}♂",
        codepoint: "1F64B 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man raising hand: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏼\u{200d}♂\u{fe0f}"]
pub const MAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F64B 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man raising hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏼\u{200d}♂",
        codepoint: "1F64B 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man raising hand: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏽\u{200d}♂\u{fe0f}"]
pub const MAN_RAISING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F64B 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man raising hand: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏽\u{200d}♂",
        codepoint: "1F64B 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man raising hand: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏾\u{200d}♂\u{fe0f}"]
pub const MAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F64B 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man raising hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏾\u{200d}♂",
        codepoint: "1F64B 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man raising hand: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏿\u{200d}♂\u{fe0f}"]
pub const MAN_RAISING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F64B 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man raising hand: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏿\u{200d}♂",
        codepoint: "1F64B 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man raising hand: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋\u{200d}♀\u{fe0f}"]
pub const WOMAN_RAISING_HAND: crate::Emoji = crate::Emoji {
    glyph: "🙋\u{200d}♀\u{fe0f}",
    codepoint: "1F64B 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman raising hand",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋\u{200d}♀",
        codepoint: "1F64B 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman raising hand",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou wat hand opsteek"),
            keywords: &[
                "groet",
                "lig hand",
                "vrou lig hand",
                "vrou wat hand opsteek",
                "waai",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት እጅ ማውጣት"),
            keywords: &["ሴት", "እጅ", "ከፍ ያደረገ", "የሴት እጅ ማውጣት", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة ترفع يدها"),
            keywords: &["سيدة ترفع يدها", "يد مرفوعة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত দ\u{9be}ঙি থক\u{9be} স\u{9c1}খী মহিল\u{9be}"),
            keywords: &[
                "ভঙ\u{9cd}গীম\u{9be}",
                "মহিল\u{9be}",
                "হ\u{9be}ত দঙ\u{9be}",
                "হ\u{9be}ত দ\u{9be}ঙি থক\u{9be} স\u{9c1}খী মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl qaldıran qadın"),
            keywords: &["jest", "qadın", "əl qaldıran qadın", "əl qaldırmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына цягне руку"),
            keywords: &["жанчына", "жанчына цягне руку", "жэст", "цягне руку"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("щастлива жена, вдигнала ръка"),
            keywords: &[
                "вдигната ръка",
                "жест с ръка",
                "щастлива",
                "щастлива жена, вдигнала ръка",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}েদের হ\u{9be}ত তোল\u{9be}"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "মহিল\u{9be}",
                "মেয\u{9bc}েদের হ\u{9be}ত তোল\u{9be}",
                "হ\u{9be}ত",
                "হ\u{9be}ত তোল\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena podiže ruku"),
            keywords: &["gestikulacija", "žena", "žena podiže ruku"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona amb la mà aixecada"),
            keywords: &["dona", "dona amb la mà aixecada", "femení", "gest", "mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎠᏌᎳᏗᏍᎬ ᎤᏬᏰᏂ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ ᎠᏌᎳᏗᏍᎬ ᎤᏬᏰᏂ", "ᎠᏌᎳᏗᏍᎬ ᎤᏬᏰᏂ", "ᏓᏐᏰᏍᎬ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena se zvednutou rukou"),
            keywords: &[
                "přihlášení",
                "ruka",
                "zvednutí",
                "žena",
                "žena se zvednutou rukou",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn codi ei llaw"),
            keywords: &["hapus", "llaw", "menyw", "menyw yn codi ei llaw", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde med løftet hånd"),
            keywords: &[
                "gestus",
                "hej",
                "hilsen",
                "kvinde",
                "kvinde med løftet hånd",
                "løftet hånd",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau mit erhobenem Arm"),
            keywords: &["Frau", "Frau mit erhobenem Arm", "Geste", "Siegerpose"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα με σηκωμένο χέρι"),
            keywords: &[
                "γυναίκα",
                "γυναίκα με σηκωμένο χέρι",
                "χαιρετισμός",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman raising hand"),
            keywords: &["gesture", "raising hand", "woman", "woman raising hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer con la mano levantada"),
            keywords: &[
                "gesto",
                "levantar",
                "mano",
                "mujer",
                "mujer con la mano levantada",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kätt tõstev naine"),
            keywords: &["käsi", "kätt tõstev naine", "naine", "tervitus", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskua altxatzen ari den emakumea"),
            keywords: &[
                "emakume",
                "emakumezko",
                "eskua altxatuta",
                "eskua altxatzen ari den emakumea",
                "keinu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن دستش را بالا می\u{200c}برد"),
            keywords: &[
                "احترام",
                "زن دستش را بالا می\u{200c}برد",
                "سلام دادن",
                "سلام کردن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("viittaava nainen"),
            keywords: &["käsi", "nainen", "viittaava nainen", "viittaus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng nakataas ang kamay"),
            keywords: &["babae", "babaeng nakataas ang kamay", "nakataas ang kamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna sum lyftur hondina upp"),
            keywords: &[
                "hond",
                "kona",
                "kvinna",
                "kvinna sum lyftur hondina upp",
                "lyft",
                "upp",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme qui lève la main"),
            keywords: &["femme", "femme qui lève la main", "geste", "main levée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean lena lámh suas"),
            keywords: &[
                "baineann",
                "bean",
                "bean le lámha suas",
                "bean lena lámh suas",
                "cor",
                "lámha suas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach a’ togail a làmh"),
            keywords: &[
                "boireannach",
                "boireannach a’ togail a làmh",
                "gluasad",
                "làmh",
                "tog",
                "togail",
                "toiliche",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller levantando a man"),
            keywords: &[
                "man levantada",
                "muller",
                "muller levantando a man",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ ઉપર ઉઠાવતી ખ\u{ac1}શ સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "ઉપર હાથ ઉઠાવવો",
                "સ\u{acd}ત\u{acd}રી",
                "હાથ ઉપર ઉઠાવતી ખ\u{ac1}શ સ\u{acd}ત\u{acd}રી",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai ɗagawa hannu"),
            keywords: &["karimcin", "mace", "mace mai ɗagawa hannu", "ɗagawa hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מנופפת בידה"),
            keywords: &[
                "אישה",
                "אישה מנופפת בידה",
                "אישה מרימה יד",
                "מצביעה",
                "מרימה יד",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाथ उठाई ह\u{941}ई महिला"),
            keywords: &[
                "इशारा",
                "महिला",
                "हाथ उठाई ह\u{941}ई महिला",
                "हाथ उठान\u{947}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena podiže ruku"),
            keywords: &["gestikulacija", "podignuta ruka", "žena podiže ruku"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vidáman intő nő"),
            keywords: &[
                "gesztus",
                "intés",
                "kézmozdulat",
                "nő",
                "vidám",
                "vidáman intő nő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքը բարձրացրած կին"),
            keywords: &["ժեստ", "կին", "ձեռքը բարձրացնել", "ձեռքը բարձրացրած կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita mengangkat tangan"),
            keywords: &[
                "angkat",
                "isyarat",
                "perempuan",
                "tangan",
                "wanita mengangkat tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-ewelite aka"),
            keywords: &[
                "na-ewelite aka",
                "nwanyị",
                "nwanyị na-ewelite aka",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona réttir upp hönd"),
            keywords: &[
                "kona",
                "kona réttir upp hönd",
                "rétta upp hönd",
                "upprétt hönd",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna con mano alzata"),
            keywords: &["donna", "donna con mano alzata", "gesto", "mano alzata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手を挙げる女"),
            keywords: &["女", "女性", "手を挙げる", "手を挙げる女", "挙手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon ngacungake tangan"),
            keywords: &[
                "isarat",
                "ngacungake tangan",
                "wong wadon",
                "wong wadon ngacungake tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელაწეული ქალი"),
            keywords: &["ჟესტი", "ქალი", "ხელაწეული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолын көтеріп тұрған әйел"),
            keywords: &["қимыл", "қол көтеру", "қолын көтеріп тұрған әйел", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde med løftet hånd"),
            keywords: &[
                "gestus",
                "hej",
                "hilsen",
                "kvinde",
                "kvinde med løftet hånd",
                "løftet hånd",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}លើកដៃ"),
            keywords: &[
                "កាយវ\u{17b7}ការ",
                "នារ\u{17b8}",
                "នារ\u{17b8}លើកដៃ",
                "លើកដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈ ಎತ\u{ccd}ತ\u{cbf}ದ ಸ\u{ccd}ತ\u{ccd}ರೀ"),
            keywords: &[
                "ಅಂಗ ಸನ\u{ccd}ನ\u{cc6}",
                "ಕೈ ಎತ\u{ccd}ತ\u{cbf}ದ ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಕೈ ಎತ\u{ccd}ತು",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("한 손 든 여자"),
            keywords: &["손들기", "여기요", "저요", "한 손 든 여자", "한손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल हात उबारता"),
            keywords: &[
                "बायल",
                "बायल हात उबारता",
                "बायल हात वयर काडटा",
                "हात वयर काडटा",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("колун көтөрүп жаткан аял"),
            keywords: &["аял", "ишарат", "кол көтөрүү", "колун көтөрүп жаткан аял"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra, déi d’Hand hieft"),
            keywords: &["Fra", "Fra, déi d’Hand hieft", "Geste", "gehuewen Hand"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງຍ\u{ebb}ກມ\u{eb7}"),
            keywords: &[
                "ຍ\u{ebb}ກມ\u{eb7}",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງຍ\u{ebb}ກມ\u{eb7}",
                "ມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ranką iškėlusi moteris"),
            keywords: &[
                "gestas",
                "moteris",
                "pakelta ranka",
                "ranką iškėlusi moteris",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete ar paceltu roku"),
            keywords: &[
                "pacelta roka",
                "sieviete",
                "sieviete ar paceltu roku",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine ringa tū"),
            keywords: &["ringa tū", "tohu ā-ringa", "wahine", "wahine ringa tū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена со подигната рака"),
            keywords: &["гест", "жена", "жена со подигната рака", "подигната рака"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൈ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ"),
            keywords: &[
                "കൈ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "കൈ ഉയർത\u{d4d}തൽ",
                "സന\u{d4d}തോഷം",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гараа өргөж буй эмэгтэй"),
            keywords: &[
                "гараа өргөж буй эмэгтэй",
                "гараа өргөх",
                "дохио",
                "эм",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हात वर क\u{947}ल\u{947}ली महिला"),
            keywords: &[
                "महिला",
                "हात उ\u{902}चावणारी महिला",
                "हात उ\u{902}चावण\u{947}",
                "हात वर क\u{947}ल\u{947}ली महिला",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan mengangkat tangan"),
            keywords: &[
                "gerak isyarat",
                "mengangkat tangan",
                "perempuan",
                "perempuan mengangkat tangan",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara tgħolli idha"),
            keywords: &["għolli l-idejn", "mara", "mara tgħolli idha", "ġesti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ထားသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "လက\u{103a}မြ\u{103e}ောက\u{103a}",
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ထားသည\u{1037}\u{103a} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne som rekker opp hånden"),
            keywords: &["kvinne", "kvinne som rekker opp hånden", "rekke opp hånden"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हात उठाइरह\u{947}को छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "इसारा",
                "उठिरह\u{947}को हात",
                "छोरी मान\u{94d}छ\u{947}",
                "महिला",
                "हात उठाइरह\u{947}को छोरीमान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw met opgeheven hand"),
            keywords: &[
                "gebaar",
                "hand opsteken",
                "vrouw",
                "vrouw met opgeheven hand",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne som rekker opp handa"),
            keywords: &[
                "kinne som rekker opp handa",
                "kvinne",
                "kvinne som rekker opp handa",
                "rekke opp handa",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ତ ଉଠ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଉଠ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ହ\u{b3e}ତ ଉଠ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਥ ਉਠਾਉ\u{a02}ਦੀ ਇਸਤਰੀ"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਔਰਤ",
                "ਹ\u{a71}ਥ ਉਠਾਉ\u{a02}ਦੀ ਇਸਤਰੀ",
                "ਹ\u{a71}ਥ ਉਠਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ ا\u{64f}وتے کردی زنانی"),
            keywords: &[
                "اشارہ",
                "زنانی",
                "ہتھ ا\u{64f}وتے کردی زنانی",
                "ہتھ ا\u{64f}وتے کرنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé De Réz Im Hand Ọp"),
            keywords: &[
                "Hand Wé Dẹm Réz Ọp",
                "Sain",
                "Wúman",
                "Wúman Wé De Réz Im Hand Ọp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta podnosząca rękę"),
            keywords: &[
                "gest",
                "hej",
                "kobieta",
                "kobieta podnosząca rękę",
                "powitanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه لاس اوچتوي"),
            keywords: &["اشاره", "لاس اوچتول", "ښځه", "ښځه لاس اوچتوي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher levantando a mão"),
            keywords: &[
                "gesto",
                "mulher",
                "mulher levantando a mão",
                "mão",
                "pedir a palavra",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher de mão levantada"),
            keywords: &[
                "gesto",
                "mulher",
                "mulher de mão levantada",
                "mão levantada",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi makita hatarichiy"),
            keywords: &[
                "gesto",
                "hatarichisqa maki",
                "warmi",
                "warmi makita hatarichiy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie care ridică mâna"),
            keywords: &["femeie", "femeie care ridică mâna", "gest", "mână ridicată"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1216"),
            keywords: &["E10-1216"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина с поднятой рукой"),
            keywords: &[
                "женщина",
                "женщина с поднятой рукой",
                "жест",
                "поднятая рука",
                "рука",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore uzamuye ikiganza"),
            keywords: &[
                "ikimenyetso",
                "kuzamura ikiganza",
                "umugore",
                "umugore uzamuye ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت هٿ مٿي ڪندي"),
            keywords: &["اشارو", "عورت", "عورت هٿ مٿي ڪندي", "هٿ مٿي ڪندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත ඔසවන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "අත එසව\u{dd3}ම",
                "අත ඔසවන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "අභ\u{dd2}න",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žena so zdvihnutou rukou"),
            keywords: &["ruka", "zdvihnutá", "žena", "žena so zdvihnutou rukou"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska, ki dviguje roko"),
            keywords: &[
                "dekle",
                "dvigovanje roke",
                "kretnje",
                "ženska",
                "ženska, ki dviguje roko",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag gacan taagaysa"),
            keywords: &["gacan taagid", "meedaar", "naag", "naag gacan taagaysa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua që ngre dorën"),
            keywords: &["dorë e ngritur", "gjest", "grua", "grua që ngre dorën"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена подиже руку"),
            keywords: &[
                "гестикулација",
                "жена",
                "жена подиже руку",
                "информације",
                "руке",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena podiže ruku"),
            keywords: &[
                "gestikulacija",
                "informacije",
                "ruke",
                "žena",
                "žena podiže ruku",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinna som räcker upp handen"),
            keywords: &["kvinna", "kvinna som räcker upp handen", "räcka upp handen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke mwenye furaha aliyeinua mnoko"),
            keywords: &[
                "furaha",
                "inua mkono",
                "mkono",
                "mwanamke mwenye furaha aliyeinua mnoko",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கை உயர\u{bcd}த\u{bcd}தும\u{bcd} பெண\u{bcd}"),
            keywords: &[
                "உயர\u{bcd}த\u{bcd}துதல\u{bcd}",
                "கை",
                "கை உயர\u{bcd}த\u{bcd}தும\u{bcd} பெண\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "చ\u{c47}య\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న స\u{c4d}త\u{c4d}ర\u{c40}",
            ),
            keywords: &[
                "చ\u{c47}య\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}తడం",
                "చ\u{c47}య\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "మహ\u{c3f}ళ",
                "సంజ\u{c4d}ఞ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки дасташро бардошта истодааст"),
            keywords: &[
                "дасти бардошта",
                "зан",
                "зане, ки дасташро бардошта истодааст",
                "имову ишора",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งยกม\u{e37}อ"),
            keywords: &[
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งยกม\u{e37}อ",
                "ยกม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini galdyrýan zenan"),
            keywords: &["elini galdyrýan zenan", "eliňi galdyrmak", "zenan", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine nima ʻi ʻolunga"),
            keywords: &["fefine nima ʻi ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elini kaldıran kadın"),
            keywords: &[
                "bayan",
                "el kaldırma",
                "elini kaldıran kadın",
                "hareket",
                "kadın",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قول كۆتۈرگەن ئايال"),
            keywords: &["ئايال", "ئىشارە", "قول كۆتۈرگەن ئايال", "قول كۆتۈرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка з піднятою рукою"),
            keywords: &["жінка", "жінка з піднятою рукою", "піднята рука", "рука"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ اٹھاتی ہوئی عورت"),
            keywords: &["اشارہ", "عورت", "ہاتھ اٹھاتی ہوئی عورت", "ہاتھ اٹھانا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol qo‘l ko‘tarmoqda"),
            keywords: &[
                "ayol",
                "ayol qo‘l ko‘tarmoqda",
                "imo-ishora",
                "qo‘l ko‘tarish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ giơ cao tay"),
            keywords: &["cử chỉ", "giơ tay", "người phụ nữ giơ cao tay", "nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen yëkkati loxo"),
            keywords: &["jigéen", "jigéen yëkkati loxo", "liyaar", "yëkkati loxo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa eliphakamisa isandla"),
            keywords: &[
                "ibhinqa",
                "ibhinqa eliphakamisa isandla",
                "jekula",
                "ukuphakamisa isandla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń nawọ\u{301} sókè"),
            keywords: &[
                "fọwọ\u{301}júwè",
                "nawọ\u{301} sókè",
                "obìnrin",
                "obìnrin tí ń nawọ\u{301} sókè",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舉手嘅女人"),
            keywords: &["女", "手勢", "舉手", "舉手嘅女人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("举手嘅女人"),
            keywords: &["举手", "举手嘅女人", "女", "手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女生举手"),
            keywords: &["举手", "女", "女生举手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生舉手"),
            keywords: &["嗨", "女", "女生舉手", "打招呼", "舉手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("開心嘅女人舉起一隻手"),
            keywords: &["開心嘅女人舉起一隻手", "開心｜舉起一隻手｜女人｜哈囉｜hi"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame ophakamise isandla"),
            keywords: &[
                "isandla",
                "owesimame",
                "owesimame ophakamise isandla",
                "ukujabula",
                "ukuphakamisa",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙋🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_RAISING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F64B 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman raising hand: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏻\u{200d}♀",
        codepoint: "1F64B 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman raising hand: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_RAISING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F64B 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman raising hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏼\u{200d}♀",
        codepoint: "1F64B 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman raising hand: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_RAISING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F64B 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman raising hand: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏽\u{200d}♀",
        codepoint: "1F64B 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman raising hand: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_RAISING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F64B 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman raising hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏾\u{200d}♀",
        codepoint: "1F64B 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman raising hand: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙋🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_RAISING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙋🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F64B 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman raising hand: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙋🏿\u{200d}♀",
        codepoint: "1F64B 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman raising hand: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏"]
pub const DEAF_PERSON: crate::Emoji = crate::Emoji {
    glyph: "🧏",
    codepoint: "1F9CF",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf person",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dowe persoon"),
            keywords: &["doof", "dowe persoon", "hoor", "oor", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መስማት የተሳነው ሰው"),
            keywords: &["መስማት", "መስማት የተሳነው ሰው", "ተደራሽነት", "ደንቆሮ", "ጆሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص أصم"),
            keywords: &[
                "أذن",
                "أصم",
                "إمكانية الوصول",
                "احتياجات خاصة",
                "سماع",
                "شخص أصم",
                "صمم",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বধিৰ ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "কল\u{9be}",
                "ক\u{9be}ণ",
                "দিব\u{9cd}য\u{9be}ংগ",
                "বধিৰ ব\u{9cd}যক\u{9cd}তি",
                "শ\u{9c1}ন\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kar şəxs"),
            keywords: &["eşitmə", "kar", "kar şəxs", "qulaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("глухі чалавек"),
            keywords: &["вуха", "глухі", "глухі чалавек", "даступнасць", "слых"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глух човек"),
            keywords: &["глух човек", "глухота", "достъпна среда", "слух", "ухо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}নে ক\u{9be}ল\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "ক\u{9be}ন",
                "ক\u{9be}নে ক\u{9be}ল\u{9be}",
                "ক\u{9be}নে ক\u{9be}ল\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "শোন\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gluha osoba"),
            keywords: &["gluha osoba", "gluhoća", "pomagalo", "sluh", "uho"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona sorda"),
            keywords: &["accessibilitat", "oïda", "persona sorda", "sentir", "sord"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎵᎡᎾ ᏴᏫ"),
            keywords: &["ᎠᏛᎩᏍᎬ", "ᎦᎴᏂ", "ᎬᏴᏍᏗ ᎨᏒᎢ", "ᏧᎵᎡᎾ", "ᏧᎵᎡᎾ ᏴᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hluchá osoba"),
            keywords: &[
                "handicap",
                "hendikep",
                "hluchota",
                "hluchá osoba",
                "nedoslýchavost",
                "pomůcka",
                "postižení",
                "sluch",
                "ucho",
                "usnadnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person byddar"),
            keywords: &["byddar", "clust", "clywed", "hygyrchedd", "person byddar"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("døv person"),
            keywords: &["døv", "døv person", "høre", "tilgængelighed", "øre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gehörlose Person"),
            keywords: &[
                "Barrierefreiheit",
                "Ohr",
                "gehörlos",
                "gehörlose Person",
                "hören",
                "taub",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κωφό άτομο"),
            keywords: &["ακοή", "αυτί", "κωφό άτομο", "κωφός", "προσβασιμότητα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("deaf person"),
            keywords: &["accessibility", "deaf", "deaf person", "ear", "hear"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona sorda"),
            keywords: &[
                "accesibilidad",
                "escuchar",
                "oído",
                "oír",
                "persona sorda",
                "sordera",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kurt inimene"),
            keywords: &["juurdepääs", "kurt", "kurt inimene", "kuulmine", "kõrv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gorra"),
            keywords: &["belarri", "enzun", "gor", "gorra", "irisgarritasun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آدم ناشنوا"),
            keywords: &["آدم ناشنوا", "دسترس\u{200c}پذیری", "شنیدن", "ناشنوا", "گوش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuuro ihminen"),
            keywords: &["esteettömyys", "korva", "kuulo", "kuuro", "kuuro ihminen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong bingi"),
            keywords: &[
                "bingi",
                "pagiging naa-access",
                "pandinig",
                "tainga",
                "taong bingi",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("deyvur persónur"),
            keywords: &["deyvur", "persónur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne sourde"),
            keywords: &[
                "accessibilité",
                "entendre",
                "malentendant",
                "oreille",
                "personne sourde",
                "sourd",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine bodhar"),
            keywords: &["bodhar", "cluas", "duine bodhar", "inrochtaineacht", "éist"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach bodhar"),
            keywords: &[
                "bodhar",
                "cluas",
                "cluinntinn",
                "neach bodhar",
                "so-ruigsinneachd",
                "èisteachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa xorda"),
            keywords: &[
                "discapacidade",
                "linguaxe de signos",
                "persoa xorda",
                "xordo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બધિર વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "કાન",
                "બધિર",
                "બધિર વ\u{acd}યક\u{acd}તિ",
                "સા\u{a82}ભળવ\u{ac1}\u{a82}",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כבד שמיעה"),
            keywords: &["חירש", "כבד שמיעה", "לקוי שמיעה", "לקות שמיעה", "נגישות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बहरा व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "कान",
                "कान स\u{947} स\u{941}नना",
                "न स\u{941}नना",
                "बहरा",
                "बहरा व\u{94d}यक\u{94d}ति",
                "स\u{941}नना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gluha osoba"),
            keywords: &["gluha osoba", "gluhoća", "pomagalo", "sluh", "uho"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("siket ember"),
            keywords: &["akadálymentesség", "fül", "hall", "siket", "siket ember"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խուլ անձ"),
            keywords: &["ականջ", "լսողություն", "խուլ", "խուլ անձ", "հաշմանդամ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang tuli"),
            keywords: &[
                "aksesibilitas",
                "dengar",
                "kuping",
                "orang tuli",
                "telinga",
                "tuli",
                "tunarungu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heyrnarlaus"),
            keywords: &["aðgengi", "eyra", "heyra", "heyrnarlaus"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona con problemi di udito"),
            keywords: &[
                "accessibilità",
                "difficoltà uditive",
                "persona con problemi di udito",
                "problemi di udito",
                "sordità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("耳の不自由な人"),
            keywords: &[
                "アクセシビリティ",
                "人",
                "耳の不自由な人",
                "聞こえない",
                "聴覚",
                "障がい",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong budheg"),
            keywords: &["budheg", "kalancaran", "krungu", "kuping", "wong budheg"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყრუ ადამიანი"),
            keywords: &["სმენა", "სმენადაქვეითებული", "ყრუ ადამიანი", "ყური", "შშმ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саңырау адам"),
            keywords: &[
                "есту",
                "мүмкіндігі шектеулі",
                "саңырау",
                "саңырау адам",
                "құлақ",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សថ\u{17d2}លង\u{17cb}"),
            keywords: &[
                "ត\u{17d2}រចៀក",
                "ថ\u{17d2}លង\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សថ\u{17d2}លង\u{17cb}",
                "លទ\u{17d2}ធភាព\u{200b}ទទ\u{17bd}លបាន",
                "ឮ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ವ\u{cbf} ಕೇಳದ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಕ\u{cbf}ವ\u{cbf}",
                "ಕ\u{cbf}ವ\u{cbf} ಕೇಳದ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಕ\u{cbf}ವುಡು",
                "ಕೇಳು",
                "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("청각 장애가 있는 사람"),
            keywords: &["귀", "접근성", "청각 장애가 있는 사람", "청각장애", "청력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भ\u{947}ड\u{94d}डो व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "आयकप",
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "कान",
                "भ\u{947}ड\u{94d}डो",
                "भ\u{947}ड\u{94d}डो व\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дүлөй киши"),
            keywords: &["атайын мүмкүндүк", "дүлөй", "дүлөй киши", "кулак", "угуу"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນ\u{200b}ຫ\u{eb9}\u{200b}ໜວກ"),
            keywords: &[
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດ\u{200b}ເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ຄ\u{ebb}ນ\u{200b}ຫ\u{eb9}\u{200b}ໜວກ",
                "ຟ\u{eb1}ງ",
                "ຫ\u{eb9}",
                "ຫ\u{eb9}\u{200b}ໜວກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kurčias žmogus"),
            keywords: &[
                "ausis",
                "girdėti",
                "kurčias",
                "kurčias žmogus",
                "prieinamumas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nedzirdīga persona"),
            keywords: &[
                "auss",
                "dzirde",
                "nedzirdīga persona",
                "nedzirdīgs",
                "pieejamība",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глуво лице"),
            keywords: &["глув", "глуво лице", "пристапност", "слушање", "уво"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബധിരന\u{d3e}യ വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "കേൾവി",
                "ചെവി",
                "ബധിരന\u{d3e}യ വ\u{d4d}യക\u{d4d}തി",
                "ബധിരൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дүлий хүн"),
            keywords: &[
                "дүлий",
                "дүлий хүн",
                "сонсголгүй",
                "хөгжлийн бэрхшээл",
                "чих",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बहिरी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "ऐकण\u{947}",
                "कान",
                "बहिरा",
                "बहिरी व\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang pekak"),
            keywords: &[
                "dengar",
                "kebolehsampaian",
                "orang pekak",
                "pekak",
                "telinga",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နားမက\u{103d}ားသ\u{1030}"),
            keywords: &[
                "ကြားခြင\u{103a}း",
                "နား",
                "နားမကြားသ\u{1030}",
                "နားမက\u{103d}ားသ\u{1030}",
                "အများသ\u{102f}\u{1036}းစ\u{103d}\u{1032}န\u{102d}\u{102f}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("døv person"),
            keywords: &["døv", "døv person", "høre", "tilgjengelighet", "øre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बहिरो मानिस"),
            keywords: &[
                "उपलब\u{94d}धता",
                "कान",
                "बहिरो",
                "बहिरो मानिस",
                "स\u{941}न\u{94d}न\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("doof persoon"),
            keywords: &["doof", "doof persoon", "horen", "oor", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("døv person"),
            keywords: &["døv", "døv person", "høyre", "tilgjenge", "øyre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଧ\u{b3f}ର ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଅଭ\u{b3f}ଗମ\u{b4d}ୟତ\u{b3e}",
                "କ\u{b3e}ନ",
                "ବଧ\u{b3f}ର",
                "ବଧ\u{b3f}ର ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ଶ\u{b4d}ରବଣ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4b}ਲ\u{a3c}ਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਕ\u{a70}ਨ",
                "ਬ\u{a4b}ਲ\u{a3c}ਾ",
                "ਬ\u{a4b}ਲ\u{a3c}ਾ ਵਿਅਕਤੀ",
                "ਸਹ\u{a42}ਲਤ",
                "ਸ\u{a41}ਣਨਾ",
                "ਸ\u{a41}ਣਾਈ ਨਾ ਦ\u{a47}ਣਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Nọ\u{301} Fít Hia"),
            keywords: &[
                "Hia",
                "Ia",
                "Nọ\u{301} Fít Hia",
                "Pẹ\u{301}sin Wé Nọ\u{301} Fít Hia",
                "Ízí To Yuz",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba głucha"),
            keywords: &["dostępność", "głuchota", "osoba głucha", "słuch", "ucho"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوڼ شخص"),
            keywords: &["اورېدل", "غوږ", "لاسرسی", "کوڼ", "کوڼ شخص"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa surda"),
            keywords: &[
                "acessibilidade",
                "audição",
                "orelha",
                "pessoa surda",
                "surdos",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("luqtʼu runa"),
            keywords: &["haykurinalla", "luqtʼu", "luqtʼu runa", "ninri", "uyariy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană surdă"),
            keywords: &[
                "accesibilitate",
                "auz",
                "persoană surdă",
                "surditate",
                "surzenie",
                "ureche",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–056"),
            keywords: &["E12–056"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("глухой человек"),
            keywords: &[
                "глухой",
                "глухой человек",
                "люди с ограниченными возможностями",
                "ограниченные возможности",
                "слышать",
                "ухо",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻورو شخص"),
            keywords: &["رسائي", "ٻورو شخص", "ٻوڙو", "ٻڌڻ", "ڪن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}හ\u{dd2}ර\u{dd2} ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "ඇස\u{dd3}ම",
                "කන",
                "බ\u{dd2}හ\u{dd2}ර\u{dd2}",
                "බ\u{dd2}හ\u{dd2}ර\u{dd2} ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nepočujúci človek"),
            keywords: &[
                "handicap",
                "hendikep",
                "hluchota",
                "nedoslýchavosť",
                "nepočujúci človek",
                "postihnutie",
                "sluch",
                "ucho",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gluha oseba"),
            keywords: &["gluh", "gluha oseba", "invalid", "sluh", "uho"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof dhagoole ah"),
            keywords: &[
                "awood u yeelid",
                "dhag",
                "dhagoole",
                "maqal",
                "qof dhagoole ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("person i shurdhër"),
            keywords: &[
                "dëgjim",
                "i shurdhër",
                "person i shurdhër",
                "qasshmëri",
                "vesh",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глува особа"),
            keywords: &["глув", "глува особа", "приступачност", "слух", "ухо"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["глува особа"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gluva osoba"),
            keywords: &["gluv", "gluva osoba", "pristupačnost", "sluh", "uho"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["gluva osoba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hörselskadad person"),
            keywords: &[
                "döv",
                "hörsel",
                "hörselskadad person",
                "tillgänglighet",
                "öra",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kiziwi"),
            keywords: &["kiziwi", "kusikia", "sikio", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}து கேள\u{bbe}தவர\u{bcd}"),
            keywords: &[
                "க\u{bbe}து",
                "க\u{bbe}து கேள\u{bbe}தவர\u{bcd}",
                "கேட\u{bcd}பதில\u{bcd} சிரமம\u{bcd}",
                "செவிடு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}వ\u{c3f}ట\u{c3f} వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "చ\u{c46}వ\u{c3f}",
                "చ\u{c46}వ\u{c3f}ట\u{c3f} వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f}",
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f} ల\u{c4b}పం",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนห\u{e39}หนวก"),
            keywords: &[
                "การเข\u{e49}าถ\u{e36}ง",
                "คนห\u{e39}หนวก",
                "ฟ\u{e31}ง",
                "ห\u{e39}",
                "ห\u{e39}หนวก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ker adam"),
            keywords: &["elýeterlilik", "eşit", "gulak", "ker", "ker adam"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha tuli"),
            keywords: &["tokotaha tuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("işitme engelli kişi"),
            keywords: &[
                "erişilebilirlik",
                "işitme",
                "işitme engelli",
                "işitme engelli kişi",
                "kulak",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина з порушенням слуху"),
            keywords: &[
                "вада слуху",
                "глухота",
                "доступність",
                "людина з порушенням слуху",
                "слух",
                "спеціальні можливості",
                "чути",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سماعت سے محروم شخص"),
            keywords: &["بہرہ پن", "دسترس", "سماعت", "سماعت سے محروم شخص", "کان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kar odam"),
            keywords: &["eshitish", "kar", "kar odam", "nogironlik", "quloq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người khiếm thính"),
            keywords: &[
                "hỗ trợ tiếp cận",
                "khiếm thính",
                "nghe",
                "người khiếm thính",
                "tai",
                "điếc",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聾人"),
            keywords: &["無障礙", "耳仔", "聽", "聾", "聾人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("聋人"),
            keywords: &["听", "无障碍", "耳仔", "聋", "聋人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("失聪者"),
            keywords: &["听力", "失聪者", "无障碍", "耳朵", "聋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聽障人士"),
            keywords: &["耳朵", "聽力", "聽障人士", "聾", "行動不便"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["殘障", "耳朵", "聽力", "聽障人士", "聾"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu ongezwa"),
            keywords: &[
                "indlebe",
                "ukufinyelela",
                "ukungezwa",
                "ukuzwa",
                "umuntu ongezwa",
            ],
        },
    ],
};
#[doc = "🧏🏻"]
pub const DEAF_PERSON_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏻",
    codepoint: "1F9CF 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf person: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧏🏼"]
pub const DEAF_PERSON_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏼",
    codepoint: "1F9CF 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf person: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧏🏽"]
pub const DEAF_PERSON_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏽",
    codepoint: "1F9CF 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf person: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧏🏾"]
pub const DEAF_PERSON_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏾",
    codepoint: "1F9CF 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf person: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧏🏿"]
pub const DEAF_PERSON_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏿",
    codepoint: "1F9CF 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf person: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧏\u{200d}♂\u{fe0f}"]
pub const DEAF_MAN: crate::Emoji = crate::Emoji {
    glyph: "🧏\u{200d}♂\u{fe0f}",
    codepoint: "1F9CF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf man",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏\u{200d}♂",
        codepoint: "1F9CF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf man",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dowe man"),
            keywords: &["doof", "dowe man", "man"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደንቆሮ ሰው"),
            keywords: &["ወንድ", "ደንቆሮ", "ደንቆሮ ሰው"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل أصم"),
            keywords: &["أصم", "رجل", "صمم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বধিৰ প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষ", "বধিৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kar kişi"),
            keywords: &["kar", "kişi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("глухі мужчына"),
            keywords: &["глухі", "мужчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глух мъж"),
            keywords: &["глух", "мъж"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}নে কম শোন\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ক\u{9be}নে কম শোন\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "ক\u{9be}নে ক\u{9be}ল\u{9be}",
                "প\u{9c1}র\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gluh muškarac"),
            keywords: &["gluh", "muškarac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home sord"),
            keywords: &["home", "sord"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎵᎡᎾ ᎠᏍᎦᏯ"),
            keywords: &["ᎠᏍᎦᏯ", "ᏧᎵᎡᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hluchý muž"),
            keywords: &[
                "hluchota",
                "hluchý",
                "muž",
                "nedoslýchavost",
                "nedoslýchavý",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn byddar"),
            keywords: &["byddar", "dyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("døv mand"),
            keywords: &["døv mand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gehörloser Mann"),
            keywords: &["Mann", "gehörlos", "gehörloser Mann", "taub"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κωφός άντρας"),
            keywords: &["άντρας", "κωφός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("deaf man"),
            keywords: &["deaf", "man"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre sordo"),
            keywords: &["hombre", "sordera", "sordo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kurt mees"),
            keywords: &["kurt", "mees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon gorra"),
            keywords: &["gizon", "gizon gorra", "gizonezko", "gor"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد ناشنوا"),
            keywords: &["مرد", "ناشنوا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuuro mies"),
            keywords: &["kuuro", "mies"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking bingi"),
            keywords: &["bingi", "lalaki", "lalaking bingi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("deyvur maður"),
            keywords: &["deyvur", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme sourd"),
            keywords: &[
                "accessibilité",
                "entendre",
                "homme sourd",
                "malentendant",
                "oreille",
                "sourd",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear bodhar"),
            keywords: &["bodhar", "fear"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine bodhar"),
            keywords: &["bodhar", "duine", "fireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home xordo"),
            keywords: &["discapacidade", "home xordo", "linguaxe de signos", "xordo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બધિર પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &["બધિર", "બધિર પ\u{ac1}ર\u{ac1}ષ", "માણસ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איש כבד שמיעה"),
            keywords: &[
                "איש כבד שמיעה",
                "חירש",
                "כבד שמיעה",
                "לקוי שמיעה",
                "לקות שמיעה",
                "נגישות",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बहरा आदमी"),
            keywords: &[
                "कान",
                "कान स\u{947} स\u{941}नना",
                "न स\u{941}नना",
                "बहरा",
                "बहरा आदमी",
                "स\u{941}नना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gluhi muškarac"),
            keywords: &["gluh", "gluhi muškarac", "muškarac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("siket férfi"),
            keywords: &["férfi", "siket"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խուլ տղամարդ"),
            keywords: &["խուլ", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria tuli"),
            keywords: &["lelaki", "pria", "tuli", "tunarungu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heyrnarlaus karl"),
            keywords: &["heyrnarlaus", "heyrnarlaus karl", "maður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo con problemi di udito"),
            keywords: &[
                "sordità",
                "sordo",
                "uomo con difficoltà uditive",
                "uomo con problemi di udito",
                "uomo sordo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("耳の不自由な男性"),
            keywords: &[
                "アクセシビリティ",
                "男性",
                "耳の不自由な男性",
                "聴覚",
                "障がい",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang budheg"),
            keywords: &["budheg", "wong lanang", "wong lanang budheg"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყრუ კაცი"),
            keywords: &["კაცი", "სმენადაქვეითებული", "ყრუ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саңырау еркек"),
            keywords: &["еркек", "саңырау"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សប\u{17d2}រ\u{17bb}សថ\u{17d2}លង\u{17cb}"),
            keywords: &[
                "ថ\u{17d2}លង\u{17cb}",
                "ប\u{17bb}រស",
                "មន\u{17bb}ស\u{17d2}សប\u{17d2}រ\u{17bb}សថ\u{17d2}លង\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ವುಡ"),
            keywords: &["ಕ\u{cbf}ವುಡ", "ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("청각장애가 있는 남자"),
            keywords: &["남자", "청각장애", "청각장애가 있는 남자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भ\u{947}ड\u{94d}डो मनीस"),
            keywords: &["दादलो", "भ\u{947}ड\u{94d}डो", "भ\u{947}ड\u{94d}डो मनीस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дүлөй адам"),
            keywords: &["дүлөй", "дүлөй адам", "киши"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}\u{200b}ຊາຍຫ\u{eb9}\u{200b}ໜວກ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}\u{200b}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}\u{200b}ຊາຍຫ\u{eb9}\u{200b}ໜວກ",
                "ຫ\u{eb9}\u{200b}ໜວກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kurčias vyras"),
            keywords: &["kurčias", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nedzirdīgs vīrietis"),
            keywords: &["nedzirdīgs", "vīrietis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глув маж"),
            keywords: &["глув", "маж"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബധിരൻ"),
            keywords: &["പ\u{d41}ര\u{d41}ഷൻ", "ബധിരൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дүлий эрэгтэй"),
            keywords: &["дүлий", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बहिरा माण\u{942}स"),
            keywords: &["बहिरा", "माण\u{942}स"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki pekak"),
            keywords: &["lelaki", "pekak"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နားမကြားသ\u{1030} အမျ\u{102d}\u{102f}းသား"),
            keywords: &["နားမကြားသ\u{1030}", "အမျ\u{102d}\u{102f}းသား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("døv mann"),
            keywords: &["døv", "mann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बहिरो प\u{941}र\u{941}ष"),
            keywords: &["प\u{941}र\u{941}ष", "बहिरो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dove man"),
            keywords: &["doof", "dove man", "man"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("døv mann"),
            keywords: &["døv", "mann"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଧ\u{b3f}ର ପ\u{b41}ର\u{b41}ଷ"),
            keywords: &["ପ\u{b41}ର\u{b41}ଷ", "ବଧ\u{b3f}ର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4b}ਲ\u{a3c}ਾ ਆਦਮੀ"),
            keywords: &["ਆਦਮੀ", "ਬ\u{a4b}ਲ\u{a3c}ਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé Nọ\u{301} Fít Hia"),
            keywords: &["Man", "Man Wé Nọ\u{301} Fít Hia", "Nọ\u{301} Fít Hia"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("głuchy mężczyzna"),
            keywords: &["głuchota", "głuchy mężczyzna", "mężczyzna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوڼ سړی"),
            keywords: &["سړی", "کوڼ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem surdo"),
            keywords: &["homem", "surdo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ruqtʼu runa"),
            keywords: &["runa", "ruqtʼu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat surd"),
            keywords: &["bărbat", "surd"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–058"),
            keywords: &["E12–058"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("глухой мужчина"),
            keywords: &["глухой", "глухота", "мужчина"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻوڙو ماڻهو"),
            keywords: &["ماڻهو", "ٻوڙو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}හ\u{dd2}ර\u{dd2} ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &["බ\u{dd2}හ\u{dd2}ර\u{dd2}", "ම\u{dd2}න\u{dd2}ස\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nepočujúci muž"),
            keywords: &[
                "hluchota",
                "hluchý",
                "muž",
                "nedoslýchavosť",
                "nedoslýchavý",
                "nepočujúci",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gluh moški"),
            keywords: &["gluh", "moški"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin dhagoole ah"),
            keywords: &["dhagoole", "nin", "nin dhagoole ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë i shurdhër"),
            keywords: &["burrë", "burrë i shurdhër", "i shurdhër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глув човек"),
            keywords: &["глув", "човек"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("глув човјек"),
            keywords: &["глув човјек"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gluv čovek"),
            keywords: &["gluv", "čovek"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("gluv čovjek"),
            keywords: &["gluv čovjek"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hörselskadad man"),
            keywords: &["hörselskadad", "man"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume kiziwi"),
            keywords: &["kiziwi", "mwanamume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேட\u{bcd}கும\u{bcd} திறன\u{bcd} இல\u{bcd}ல\u{bbe}த ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "க\u{bbe}து கேள\u{bbe}தவர\u{bcd}",
                "கேட\u{bcd}கும\u{bcd} திறன\u{bcd} இல\u{bcd}ல\u{bbe}த ஆண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}వ\u{c3f}ట\u{c3f}వ\u{c3e}డు"),
            keywords: &[
                "చ\u{c46}వ\u{c3f}ట\u{c3f}వ\u{c3e}డు",
                "పురుషుడు",
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f} ల\u{c4b}పం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายห\u{e39}หนวก"),
            keywords: &[
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายห\u{e39}หนวก",
                "ห\u{e39}หนวก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ker erkek"),
            keywords: &["erkek", "ker"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata tuli"),
            keywords: &["tangata tuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("işitme engelli erkek"),
            keywords: &["adam", "erkek", "işitme engelli", "işitme engelli erkek"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік із порушенням слуху"),
            keywords: &[
                "глухий",
                "глухота",
                "обмежені можливості",
                "слух",
                "чоловік",
                "чоловік із порушенням слуху",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سماعت سے محروم مرد"),
            keywords: &["بہرہ", "سماعت سے محروم مرد", "مرد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kar erkak"),
            keywords: &["erkak", "kar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông khiếm thính"),
            keywords: &[
                "khiếm thính",
                "người đàn ông",
                "người đàn ông khiếm thính",
                "điếc",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聾嘅男人"),
            keywords: &["男人", "聾", "聾嘅男人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("聋嘅男人"),
            keywords: &["男人", "聋", "聋嘅男人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("失聪的男人"),
            keywords: &["听力障碍", "失聪的男人", "男", "耳朵", "聋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聽障男子"),
            keywords: &["男", "聽障", "聽障男子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("聽障男人"),
            keywords: &["男", "聽障", "聽障男人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda engezwa"),
            keywords: &["indoda", "indoda engezwa", "ongezwa"],
        },
    ],
};
#[doc = "🧏🏻\u{200d}♂\u{fe0f}"]
pub const DEAF_MAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9CF 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf man: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏻\u{200d}♂",
        codepoint: "1F9CF 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf man: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏼\u{200d}♂\u{fe0f}"]
pub const DEAF_MAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9CF 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf man: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏼\u{200d}♂",
        codepoint: "1F9CF 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf man: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏽\u{200d}♂\u{fe0f}"]
pub const DEAF_MAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9CF 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf man: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏽\u{200d}♂",
        codepoint: "1F9CF 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf man: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏾\u{200d}♂\u{fe0f}"]
pub const DEAF_MAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9CF 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf man: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏾\u{200d}♂",
        codepoint: "1F9CF 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf man: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏿\u{200d}♂\u{fe0f}"]
pub const DEAF_MAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9CF 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf man: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏿\u{200d}♂",
        codepoint: "1F9CF 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf man: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏\u{200d}♀\u{fe0f}"]
pub const DEAF_WOMAN: crate::Emoji = crate::Emoji {
    glyph: "🧏\u{200d}♀\u{fe0f}",
    codepoint: "1F9CF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf woman",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏\u{200d}♀",
        codepoint: "1F9CF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf woman",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("dowe vrou"),
            keywords: &["doof", "dowe vrou", "vrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደንቆሮ ሴት"),
            keywords: &["ሴት", "ደንቆሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة صماء"),
            keywords: &["سيدة", "صماء", "صمم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বধিৰ মহিল\u{9be}"),
            keywords: &["বধিৰ", "মহিল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kar qadın"),
            keywords: &["kar", "qadın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("глухая жанчына"),
            keywords: &["глухая", "жанчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("глуха жена"),
            keywords: &["глуха", "жена"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}নে ক\u{9be}ল\u{9be} মহিল\u{9be}"),
            keywords: &[
                "ক\u{9be}নে ক\u{9be}ল\u{9be}",
                "ক\u{9be}নে ক\u{9be}ল\u{9be} মহিল\u{9be}",
                "মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("gluha žena"),
            keywords: &["gluha", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona sorda"),
            keywords: &["dona", "sorda"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᎵᎡᎾ ᎠᎨᏯ"),
            keywords: &["ᎠᎨᏯ", "ᏧᎵᎡᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hluchá žena"),
            keywords: &[
                "hluchota",
                "hluchá",
                "nedoslýchavost",
                "nedoslýchavá",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw fyddar"),
            keywords: &["byddar", "menyw", "menyw fyddar"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("døv kvinde"),
            keywords: &["døv kvinde"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("gehörlose Frau"),
            keywords: &["Frau", "gehörlos", "gehörlose Frau", "taub"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κωφή γυναίκα"),
            keywords: &["γυναίκα", "κωφή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("deaf woman"),
            keywords: &["deaf", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer sorda"),
            keywords: &["mujer", "sorda", "sordera"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kurt naine"),
            keywords: &["kurt", "naine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume gorra"),
            keywords: &["emakume", "emakume gorra", "emakumezko", "gor"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن ناشنوا"),
            keywords: &["زن", "ناشنوا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuuro nainen"),
            keywords: &["kuuro", "nainen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng bingi"),
            keywords: &["babae", "babaeng bingi", "bingi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("deyv kvinna"),
            keywords: &["deyv", "kona", "kvinna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme sourde"),
            keywords: &[
                "accessibilité",
                "entendre",
                "femme sourde",
                "malentendant",
                "oreille",
                "sourd",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["femme", "malentendante", "sourde"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean bhodhar"),
            keywords: &["bean", "bean bhodhar", "bodhar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach bodhar"),
            keywords: &["bodhar", "boireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller xorda"),
            keywords: &[
                "discapacidade",
                "linguaxe de signos",
                "muller xorda",
                "xorda",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બધિર સ\u{acd}ત\u{acd}રી"),
            keywords: &["બધિર", "સ\u{acd}ત\u{acd}રી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה כבדת שמיעה"),
            keywords: &[
                "אישה כבדת שמיעה",
                "חירשת",
                "כבדת שמיעה",
                "לקוי שמיעה",
                "לקות שמיעה",
                "נגישות",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बहरी औरत"),
            keywords: &[
                "कान",
                "कान स\u{947} स\u{941}नना",
                "न स\u{941}नना",
                "बहरा",
                "बहरी औरत",
                "स\u{941}नना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gluha žena"),
            keywords: &["gluha", "žena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("siket nő"),
            keywords: &["nő", "siket"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խուլ կին"),
            keywords: &["խուլ", "կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita tuli"),
            keywords: &["perempuan", "tuli", "tunarungu", "wanita"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heyrnarlaus kona"),
            keywords: &["heyrnarlaus", "kona"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna con problemi di udito"),
            keywords: &[
                "donna con difficoltà uditive",
                "donna con problemi di udito",
                "donna sorda",
                "sorda",
                "sordità",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("耳の不自由な女性"),
            keywords: &[
                "アクセシビリティ",
                "女性",
                "耳の不自由な女性",
                "聴覚",
                "障がい",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon budheg"),
            keywords: &["budheg", "wong wadon", "wong wadon budheg"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყრუ ქალი"),
            keywords: &["სმენადაქვეითებული", "ქალი", "ყრუ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саңырау әйел"),
            keywords: &["саңырау", "әйел"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ត\u{17d2}រ\u{17b8}ថ\u{17d2}លង\u{17cb}"),
            keywords: &[
                "ថ\u{17d2}លង\u{17cb}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}ថ\u{17d2}លង\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ವುಡ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಕ\u{cbf}ವುಡ ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಕ\u{cbf}ವುಡ\u{cbf}",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("청각장애가 있는 여자"),
            keywords: &["여자", "청각장애", "청각장애가 있는 여자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भ\u{947}ड\u{94d}डी बायल"),
            keywords: &["बायल", "भ\u{947}ड\u{94d}डी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("дүлөй аял"),
            keywords: &["аял", "дүлөй"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}\u{200b}ຍ\u{eb4}ງ\u{200b}ຫ\u{eb9}\u{200b}ໜວກ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}\u{200b}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}\u{200b}ຍ\u{eb4}ງ\u{200b}ຫ\u{eb9}\u{200b}ໜວກ",
                "ຫ\u{eb9}\u{200b}ໜວກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kurčia moteris"),
            keywords: &["kurčia", "moteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nedzirdīga sieviete"),
            keywords: &["nedzirdīga", "sieviete"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("глува жена"),
            keywords: &["глува", "жена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ബധിര"),
            keywords: &["ബധിര", "സ\u{d4d}\u{200c}ത\u{d4d}രീ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дүлий эмэгтэй"),
            keywords: &["дүлий", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बहिरी महिला"),
            keywords: &["बहिरी", "महिला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan pekak"),
            keywords: &["pekak", "perempuan pekak", "wanita"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နားမကြားသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း"),
            keywords: &["နားမကြားသ\u{1030}", "အမျ\u{102d}\u{102f}းသမ\u{102e}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("døv kvinne"),
            keywords: &["døv", "kvinne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बहिरो महिला"),
            keywords: &["बहिरो", "महिला"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("dove vrouw"),
            keywords: &["doof", "dove vrouw", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("døv kvinne"),
            keywords: &["døv", "kvinne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବଧ\u{b3f}ର ମହ\u{b3f}ଳ\u{b3e}"),
            keywords: &["ବଧ\u{b3f}ର", "ମହ\u{b3f}ଳ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4b}ਲ\u{a3c}ੀ ਔਰਤ"),
            keywords: &["ਔਰਤ", "ਬ\u{a4b}ਲ\u{a3c}ੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé Nọ\u{301} Fít Hia"),
            keywords: &["Nọ\u{301} Fít Hia", "Wúman", "Wúman Wé Nọ\u{301} Fít Hia"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("głucha kobieta"),
            keywords: &["głucha kobieta", "głuchota", "kobieta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کڼه ښځه"),
            keywords: &["ښځه", "کڼه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher surda"),
            keywords: &["mulher", "surda"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("luqʼu warmi"),
            keywords: &["luqtʼu", "luqʼu warmi", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie surdă"),
            keywords: &["femeie", "surdă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–057"),
            keywords: &["E12–057"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("глухая женщина"),
            keywords: &["глухая", "глухота", "женщина"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻوڙي عورت"),
            keywords: &["عورت", "ٻوڙي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බ\u{dd2}හ\u{dd2}ර\u{dd2} ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &["ක\u{dcf}න\u{dca}ත\u{dcf}ව", "බ\u{dd2}හ\u{dd2}ර\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nepočujúca žena"),
            keywords: &[
                "hluchota",
                "hluchá",
                "nedoslýchavosť",
                "nedoslýchavá",
                "nepočujúca",
                "žena",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gluha ženska"),
            keywords: &["gluha", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag dhagoole ah"),
            keywords: &["dhagoole", "naag", "naag dhagoole ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua e shurdhër"),
            keywords: &["e shurdhër", "grua", "grua e shurdhër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("глува жена"),
            keywords: &["глува", "жена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("gluva žena"),
            keywords: &["gluva", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hörselskada kvinna"),
            keywords: &["hörselskada kvinna", "hörselskadad", "kvinna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke kiziwi"),
            keywords: &["kiziwi", "mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கேட\u{bcd}கும\u{bcd} திறன\u{bcd} இல\u{bcd}ல\u{bbe}த பெண\u{bcd}"),
            keywords: &[
                "க\u{bbe}து கேள\u{bbe}தவர\u{bcd}",
                "கேட\u{bcd}கும\u{bcd} திறன\u{bcd} இல\u{bcd}ல\u{bbe}த பெண\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}వ\u{c3f}ట\u{c3f} స\u{c4d}త\u{c4d}ర\u{c40}"),
            keywords: &[
                "చ\u{c46}వ\u{c3f}ట\u{c3f} స\u{c4d}త\u{c4d}ర\u{c40}",
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f} ల\u{c4b}పం",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งห\u{e39}หนวก"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งห\u{e39}หนวก",
                "ห\u{e39}หนวก",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ker zenan"),
            keywords: &["ker", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine tuli"),
            keywords: &["fefine tuli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("işitme engelli kadın"),
            keywords: &["işitme engelli", "işitme engelli kadın", "kadın"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка з порушенням слуху"),
            keywords: &[
                "глуха",
                "глухота",
                "жінка",
                "жінка з порушенням слуху",
                "обмежені можливості",
                "слух",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بہری عورت"),
            keywords: &["بہری", "عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kar ayol"),
            keywords: &["ayol", "kar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ khiếm thính"),
            keywords: &[
                "khiếm thính",
                "người phụ nữ",
                "người phụ nữ khiếm thính",
                "điếc",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聾嘅女人"),
            keywords: &["女人", "聾", "聾嘅女人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("聋嘅女人"),
            keywords: &["女人", "聋", "聋嘅女人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("失聪的女人"),
            keywords: &["听力障碍", "失聪的女人", "女", "耳朵", "聋"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聽障女子"),
            keywords: &["女", "聽障", "聽障女子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("聽障女人"),
            keywords: &["女", "聽障", "聽障女人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umama ongezwa"),
            keywords: &["ongezwa", "umama"],
        },
    ],
};
#[doc = "🧏🏻\u{200d}♀\u{fe0f}"]
pub const DEAF_WOMAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9CF 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf woman: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏻\u{200d}♀",
        codepoint: "1F9CF 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf woman: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏼\u{200d}♀\u{fe0f}"]
pub const DEAF_WOMAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9CF 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf woman: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏼\u{200d}♀",
        codepoint: "1F9CF 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf woman: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏽\u{200d}♀\u{fe0f}"]
pub const DEAF_WOMAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9CF 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf woman: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏽\u{200d}♀",
        codepoint: "1F9CF 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf woman: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏾\u{200d}♀\u{fe0f}"]
pub const DEAF_WOMAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9CF 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf woman: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏾\u{200d}♀",
        codepoint: "1F9CF 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf woman: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧏🏿\u{200d}♀\u{fe0f}"]
pub const DEAF_WOMAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧏🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9CF 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "deaf woman: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧏🏿\u{200d}♀",
        codepoint: "1F9CF 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 12f32,
        name: "deaf woman: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇"]
pub const PERSON_BOWING: crate::Emoji = crate::Emoji {
    glyph: "🙇",
    codepoint: "1F647",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person bowing",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon wat buig"),
            keywords: &[
                "buig",
                "gebaar",
                "guns",
                "jammer",
                "persoon wat buig",
                "verskoning",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ከወገቡ ጎንበስ ብሎ ሰላምታ የሚሰጥ ሰው"),
            keywords: &["ማጎንበስ", "ከወገቡ ጎንበስ ብሎ ሰላምታ የሚሰጥ ሰው", "የእጅ ምልክት", "ይቅርታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص ينحني اعتذار\u{64b}ا"),
            keywords: &[
                "أسف",
                "إشارة",
                "انحناء",
                "انحناء شديد",
                "شخص",
                "شخص ينحني اعتذار\u{64b}ا",
                "\u{202b}شخص يتأسف",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিৰ নত কৰ\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "ক\u{9cd}ষম\u{9be}",
                "দ\u{9c1}ঃখিত",
                "ভঙ\u{9cd}গীম\u{9be}",
                "শিৰ নত কৰ\u{9be}",
                "শিৰ নত কৰ\u{9be} ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("tənzim edən adam"),
            keywords: &[
                "jest",
                "tənzim edən adam",
                "tənzim etmək",
                "üzr",
                "üzr istəmək",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек кланяецца"),
            keywords: &["выбачэнне", "кланяцца", "прабач", "чалавек кланяецца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Покланящ се човек"),
            keywords: &[
                "Покланящ се човек",
                "жест",
                "извинение",
                "поклон",
                "съжалявам",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}যক\u{9cd}তির প\u{9cd}রণ\u{9be}ম"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "ক\u{9cd}ষম\u{9be} প\u{9cd}র\u{9be}র\u{9cd}থন\u{9be}",
                "দ\u{9c1}ঃখিত",
                "ব\u{9cd}যক\u{9cd}তির প\u{9cd}রণ\u{9be}ম",
                "ম\u{9be}থ\u{9be} নত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba se naklanja"),
            keywords: &[
                "gestikulacija",
                "izvinjenje",
                "naklon",
                "osoba se naklanja",
                "poniznost",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona capcota"),
            keywords: &["disculpa", "gest", "persona capcota", "reverència"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᏘᏌᏘ"),
            keywords: &["ᎡᏍᎦ ᎠᏰᎸᏅᏗ", "ᎡᏍᎦ ᎠᏰᎸᏍᎦ", "ᎤᎵᏍᏈᏗ", "ᏓᏐᏰᏍᎬ", "ᏴᏫ ᎤᏘᏌᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("uklánějící se osoba"),
            keywords: &[
                "gesto",
                "lítost",
                "omluva",
                "poklona",
                "prosba",
                "uklánějící se osoba",
                "úcta",
                "úklona",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn ymgrymu"),
            keywords: &[
                "person yn ymgrymu",
                "sori",
                "ymddiheuriad",
                "ymgrymiad",
                "ystum",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("bukker"),
            keywords: &["bukker", "undskyld"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich verbeugende Person"),
            keywords: &[
                "Entschuldigung",
                "Geste",
                "sich verbeugende Person",
                "verbeugen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο υποκλίνεται"),
            keywords: &[
                "άτομο υποκλίνεται",
                "κίνηση",
                "λυπάμαι",
                "συγνώμη",
                "υπόκλιση",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person bowing"),
            keywords: &["apology", "bow", "gesture", "person bowing", "sorry"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona haciendo una reverencia"),
            keywords: &[
                "disculpa",
                "gesto",
                "perdón",
                "persona haciendo una reverencia",
                "reverencia",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "gesto",
                "perdón",
                "persona",
                "persona haciendo una reverencia",
                "reverencia",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kummardav inimene"),
            keywords: &["kummardav inimene", "kummardus", "vabandus", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burua makurtzen ari den pertsona"),
            keywords: &[
                "barkamen",
                "barkatu",
                "burua makurtzen ari den pertsona",
                "keinu",
                "makurtu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عذرخواهی"),
            keywords: &["تعظیم", "شرمنده", "عذرخواهی", "متأسف", "ژست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kumartava henkilö"),
            keywords: &[
                "anteeksi",
                "anteeksipyyntö",
                "ele",
                "kumarrus",
                "kumartava henkilö",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("yumuyukong tao"),
            keywords: &[
                "paggalang",
                "paghingi ng paumanhin",
                "sorry",
                "tao",
                "yuko",
                "yumuyuko",
                "yumuyukong tao",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur sum bukkar"),
            keywords: &["bukkar", "fólk", "persónur", "persónur sum bukkar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne qui s’incline"),
            keywords: &["désolé", "geste", "incliné", "personne qui s’incline"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("personne qui s’incline"),
            keywords: &[
                "courbette",
                "désolé",
                "excuses",
                "incliné",
                "personne qui s’incline",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine ag umhlú"),
            keywords: &[
                "aiféala",
                "brón",
                "duine ag umhlú",
                "gabh mo leithscéal",
                "tá brón orm",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach a’ cromadh"),
            keywords: &[
                "cromadh",
                "duilich",
                "gluasad",
                "leisgeul",
                "neach a’ cromadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("reverencia"),
            keywords: &["desculpas", "reverencia", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{a82}દન કરતી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "ઊ\u{a82}ડ\u{ac7}થી નમ\u{ac7}લ",
                "નમવ\u{ac1}\u{a82}",
                "મન\u{ac7} માફ કરશો",
                "માફ કરશો",
                "વ\u{a82}દન કરતી વ\u{acd}યક\u{acd}તિ",
                "વ\u{acd}યક\u{acd}તિ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai sunkuya"),
            keywords: &[
                "gafarta",
                "haƙuri",
                "karimcin",
                "mutum mai sunkuya",
                "sunkuya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם משתחווה"),
            keywords: &["אדם משתחווה", "התנצלות", "משתחווה", "סליחה", "קידה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("झ\u{941}का ह\u{941}आ व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "क\u{94d}षमा कर\u{947}\u{902}",
                "घ\u{941}टनो\u{902} पर ब\u{948}ठना",
                "झ\u{941}का ह\u{941}आ व\u{94d}यक\u{94d}ति",
                "प\u{942}री तरह झ\u{941}कना",
                "म\u{941}झ\u{947} क\u{94d}षमा कर\u{947}\u{902}",
                "व\u{94d}यक\u{94d}ति",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba koja se klanja"),
            keywords: &[
                "ispričavanje",
                "klanjanje",
                "kretnja",
                "naklon",
                "osoba koja se klanja",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("meghajló ember"),
            keywords: &["bocsánatkérés", "meghajlás", "meghajló ember", "sajnálat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոնարհվող անձ"),
            keywords: &[
                "ժեստ",
                "խոնարհվել",
                "խոնարհվող անձ",
                "ներողություն",
                "ներողություն խնդրել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang membungkuk"),
            keywords: &[
                "bungkuk",
                "gerakan",
                "maaf",
                "nunduk",
                "orang membungkuk",
                "sori",
                "tunduk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-ehulata ala"),
            keywords: &["hulata", "ndo", "ogbugbu", "onye na-ehulata ala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fyrirgefðu"),
            keywords: &["auðmýkt", "fyrirgefðu", "hneiging", "hneigja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona che fa un inchino profondo"),
            keywords: &[
                "gesto",
                "mi dispiace",
                "persona",
                "persona che fa un inchino profondo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おじぎする人"),
            keywords: &["おじぎ", "おじぎする人", "ごめんなさい", "土下座"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong mbungkuk ngurmati"),
            keywords: &[
                "isarat",
                "kilap",
                "mbungkuk",
                "njaluk ngapura",
                "wong mbungkuk ngurmati",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თავდახრილი პიროვნება"),
            keywords: &[
                "ბოდიში",
                "დახრა",
                "თავდახრილი პიროვნება",
                "პატიება",
                "ჟესტი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бағынып тұрған адам"),
            keywords: &[
                "бағыну",
                "бағынып тұрған адам",
                "кешірім",
                "кешірім сұрау",
                "қимыл",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សឱនគោរព"),
            keywords: &[
                "កាយវ\u{17b7}ការ",
                "មន\u{17bb}ស\u{17d2}សឱនគោរព",
                "ស\u{17bb}\u{17c6}ទោស",
                "ស\u{17bc}មទោស",
                "ឱន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚನ\u{cc6}",
                "ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("절하는 사람"),
            keywords: &["사과하는 사람", "사과하며 절하는 사람", "절하는 사람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती बागवता"),
            keywords: &[
                "बागवप",
                "माफ करच\u{947}\u{902}",
                "माफी मागता",
                "व\u{94d}यक\u{94d}ती बागवता",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүгүнүп жаткан адам"),
            keywords: &["жүгүн", "жүгүнүп жаткан адам", "ишарат", "кечирим"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("sech vernäipend Persoun"),
            keywords: &[
                "Entschëllegung",
                "Geste",
                "Verneigung",
                "entschëllegt",
                "sech vernäipend Persoun",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນກ\u{ebb}\u{ec9}ມຂ\u{ecd}ໂທດ"),
            keywords: &[
                "ກ\u{ebb}\u{ec9}ມຕ\u{ebb}ວ",
                "ຂ\u{ecd}ໂທດ",
                "ຄຳນ\u{eb1}ບ",
                "ຄ\u{ebb}ນກ\u{ebb}\u{ec9}ມຂ\u{ecd}ໂທດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nusilenkęs žmogus"),
            keywords: &[
                "atsiprašymas",
                "gestas",
                "nusilenkimas",
                "nusilenkęs žmogus",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks paklanās"),
            keywords: &["atvainošanās", "cilvēks paklanās", "paklanīties", "žests"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata tuohu"),
            keywords: &["aroha", "tangata tuohu", "tohu", "tuohu", "whakapāha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("човек кој се поклонува"),
            keywords: &[
                "гест",
                "извинување",
                "поклонување",
                "човек кој се поклонува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തല ക\u{d41}നിയ\u{d4d}\u{200c}ക\u{d4d}ക\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ക\u{d41}നിയ\u{d41}ക",
                "ക\u{d4d}ഷമ",
                "ക\u{d4d}ഷമ\u{d3e}യ\u{d3e}ചന",
                "തല ക\u{d41}നിയ\u{d4d}\u{200c}ക\u{d4d}ക\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി",
                "മ\u{d3e}പ\u{d4d}പ\u{d4d}",
                "വന\u{d4d}ദിക\u{d4d}ക\u{d41}ക",
                "വന\u{d4d}ദിക\u{d4d}ക\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөхийж буй хүн"),
            keywords: &["бөхийж буй хүн", "бөхийх", "дохио", "уучлаарай", "уучлал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मान खाली घातल\u{947}ली व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "क\u{94d}षमा",
                "क\u{94d}षमायाचना",
                "झ\u{941}कण\u{947}",
                "मान खाली घातल\u{947}ली व\u{94d}यक\u{94d}ती",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang menunduk"),
            keywords: &["isyarat", "maaf", "minta maaf", "orang menunduk", "tunduk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tinkina"),
            keywords: &[
                "apoloġija",
                "inkina",
                "jiddispjaċina",
                "persuna tinkina",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဦးည\u{103d}တ\u{103a}နေသ\u{1030}"),
            keywords: &[
                "တောင\u{103a}ပန\u{103a}ခြင\u{103a}း",
                "အမ\u{1030}အရာ",
                "ဦးည\u{103d}တ\u{103a}နေသ\u{1030}",
                "ဦးည\u{103d}\u{103e}တ\u{103a}ခြင\u{103a}း",
                "ဦးည\u{103d}\u{103e}တ\u{103a}နေသ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bukker"),
            keywords: &["beklagelse", "beklager", "bukk", "bukker", "unnskyld"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("निह\u{941}रिरह\u{947}को व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "क\u{94d}षमा",
                "खी",
                "द\u{941}",
                "निह\u{941}रिरह\u{947}को व\u{94d}यक\u{94d}ति",
                "बो",
                "भाव प\u{94d}रदर\u{94d}शन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("buigende persoon"),
            keywords: &["buigende persoon", "buiging", "excuses", "gebaar", "sorry"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bukkar"),
            keywords: &["bukk", "bukkar", "orsak", "orsakar", "orsaking"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "କ\u{b4d}ଷମ\u{b3e} ପ\u{b4d}ର\u{b3e}ର\u{b4d}ଥନ\u{b3e} କର\u{b3f}ବ\u{b3e}",
                "ଦ\u{b41}ଃଖ\u{b3f}ତ",
                "ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ହ\u{b3e}ର ମ\u{b3e}ନ\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਝ\u{a41}ਕਿਆ ਹ\u{a4b}ਇਆ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਝ\u{a41}ਕਿਆ ਹ\u{a4b}ਇਆ ਵਿਅਕਤੀ",
                "ਝ\u{a41}\u{a71}ਕਣਾ",
                "ਬਹ\u{a41}ਤ ਝ\u{a41}ਕਾਅ",
                "ਮ\u{a41}ਆਫੀ",
                "ਮ\u{a48}ਨ\u{a42}\u{a70} ਮਾਫ ਕਰ\u{a4b}",
                "ਵਿਅਕਤੀ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ج\u{64f}ھکیا ہوئیا بندہ"),
            keywords: &[
                "اشارہ",
                "ج\u{64f}ھکنا",
                "ج\u{64f}ھکیا ہوئیا بندہ",
                "معذرت",
                "معذرت خواہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé De Baú Daun"),
            keywords: &[
                "Apọ\u{301}lọ\u{301}ji",
                "Bau",
                "Pẹ\u{301}sin Wé De Baú Daun",
                "Sain",
                "Sọ\u{301}ri",
                "To Tọ\u{301}k Sé Yu Dé Sọ\u{301}ri Fọ Rọ\u{301}ng Tin Wé Yu Dọ\u{301}n Du",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba w ukłonie"),
            keywords: &[
                "opuszczona głowa",
                "osoba w ukłonie",
                "przepraszam",
                "przykro mi",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص ښکته کيږي"),
            keywords: &[
                "اشاره",
                "بخښنه",
                "شخص ښکته کيږي",
                "شخص ښکته کيږې",
                "معذرت",
                "ښکته کېدل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa fazendo reverência"),
            keywords: &[
                "desculpa",
                "gesto",
                "perdão",
                "pessoa",
                "pessoa fazendo reverência",
                "reverência",
                "reverência respeitosa",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa a fazer vénia"),
            keywords: &[
                "desculpa",
                "gesto",
                "pedido de desculpas",
                "pessoa a fazer vénia",
                "vénia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("upaykusqa runa"),
            keywords: &[
                "gesto",
                "qhispichiway",
                "qhispichiy",
                "upaykusqa runa",
                "upaykuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană care se înclină"),
            keywords: &["persoană care se înclină", "respect", "scuză", "înclinare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-907"),
            keywords: &["E10-907"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек кланяется"),
            keywords: &[
                "извинение",
                "поклон",
                "просьба",
                "прощение",
                "человек",
                "человек кланяется",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu wunamye"),
            keywords: &[
                "ihangane",
                "ikimenyetso",
                "kunama",
                "ukwicuza",
                "umuntu wunamye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص جهڪندي"),
            keywords: &["اشارو", "افسوس", "جھڪڻ", "شخص جهڪندي", "معافي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හ\u{dd2}ස නවන ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "අභ\u{dd2}න",
                "ආච\u{dcf}ර ක\u{dd2}ර\u{dd3}ම",
                "සම\u{dcf}ව ඉල\u{dca}ල\u{dd3}ම",
                "හ\u{dd2}ස නවන ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klaňajúci sa človek"),
            keywords: &[
                "gesto",
                "klaňajúci sa človek",
                "poklona",
                "prepáčte",
                "človek",
                "ľutujem",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki se prikloni"),
            keywords: &[
                "gesta",
                "opravičilo",
                "oprosti",
                "oseba, ki se prikloni",
                "priklon",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof fooraraya"),
            keywords: &[
                "ka xummaansho",
                "meedaar",
                "qof fooraraya",
                "raaligalin",
                "waji foorarin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri i përkulur"),
            keywords: &[
                "falje",
                "gjest",
                "njeri i përkulur",
                "përkulje",
                "shfajësim",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа која се клања"),
            keywords: &[
                "извињење",
                "клaњaњe",
                "крeтање",
                "нaклoн",
                "особа која се клања",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba koja se klanja"),
            keywords: &[
                "izvinjenje",
                "klanjanje",
                "kretanje",
                "naklon",
                "osoba koja se klanja",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bugande person"),
            keywords: &["beklagar", "bugande person", "bugar", "gest"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu aliyeinama"),
            keywords: &["inama", "ishara", "msamaha", "mtu aliyeinama", "samahani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மன\u{bcd}னிப\u{bcd}பு கேட\u{bcd}பவர\u{bcd}"),
            keywords: &[
                "அடக\u{bcd}கம\u{bcd}",
                "பணிவு",
                "மன\u{bcd}னிப\u{bcd}பு",
                "மன\u{bcd}னிப\u{bcd}பு கேட\u{bcd}பவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}షమ\u{c3e}పణలు క\u{c4b}రుతున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "క\u{c4d}షమ\u{c3e}పణ",
                "క\u{c4d}షమ\u{c3e}పణలు క\u{c4b}రుతున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки хам шуда истодааст"),
            keywords: &[
                "бахшиш",
                "имову ишора",
                "узр",
                "хам шудан",
                "шахсе, ки хам шуда истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ท\u{e48}าขอโทษ"),
            keywords: &["ท\u{e48}าขอโทษ", "โค\u{e49}งต\u{e31}วคำน\u{e31}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tagzym edýän adam"),
            keywords: &["bagyşlaň", "tagzym", "tagzym edýän adam", "ötünç", "üm"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha punou"),
            keywords: &["tokotaha punou"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("başını öne eğme"),
            keywords: &["başını öne eğme", "eğilme", "hareket", "kişi", "üzgünüm"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېگىلگەن كىشى"),
            keywords: &["ئىشارە", "ئۆزۈر", "ئېگىلىش", "ئېگىلگەن كىشى", "كەچۈرۈڭ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина, що вклоняється"),
            keywords: &[
                "вибач",
                "вибачення",
                "жест",
                "людина, що вклоняється",
                "уклін",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جھکے ہوئے شخص"),
            keywords: &["اشارہ", "جھکنا", "جھکے ہوئے شخص", "معافی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ta’zim qilayotgan odam"),
            keywords: &[
                "imo-ishora",
                "kechirim so‘rash",
                "ta’zim",
                "ta’zim qilayotgan odam",
                "uzr so‘rash",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đang cúi đầu"),
            keywords: &[
                "cúi người",
                "cử chỉ",
                "lấy làm tiếc",
                "lời xin lỗi",
                "người đang cúi đầu",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit kuy sëgg-nuyoo"),
            keywords: &["ark", "jéggalu", "liyaar", "massawu", "nit kuy sëgg-nuyoo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ogobayo"),
            keywords: &["goba", "jekula", "ukuxolisa", "umntu ogobayo", "uxolo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni N Tẹriba"),
            keywords: &[
                "bẹ\u{300}bẹ\u{300}",
                "fọwọ\u{301}júwè",
                "pẹ\u{300}lẹ\u{301}",
                "tẹríba",
                "Ẹni N Tẹriba",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鞠躬嘅人"),
            keywords: &["姿勢", "對唔住", "道歉", "鞠躬", "鞠躬嘅人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鞠躬嘅人"),
            keywords: &["姿势", "对唔住", "道歉", "鞠躬", "鞠躬嘅人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鞠躬"),
            keywords: &["不好意思", "对不起", "道歉", "鞠躬"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鞠躬"),
            keywords: &["不好意思", "抱歉", "鞠躬"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["鞠躬", "鞠躬｜唔好意思｜對唔住｜sorry｜道歉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu othobile"),
            keywords: &["ukuthoba", "ukuxolisa", "umuntu othobile", "uphawu"],
        },
    ],
};
#[doc = "🙇🏻"]
pub const PERSON_BOWING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏻",
    codepoint: "1F647 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person bowing: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙇🏼"]
pub const PERSON_BOWING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏼",
    codepoint: "1F647 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person bowing: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙇🏽"]
pub const PERSON_BOWING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏽",
    codepoint: "1F647 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person bowing: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙇🏾"]
pub const PERSON_BOWING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏾",
    codepoint: "1F647 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person bowing: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙇🏿"]
pub const PERSON_BOWING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏿",
    codepoint: "1F647 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person bowing: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙇\u{200d}♂\u{fe0f}"]
pub const MAN_BOWING: crate::Emoji = crate::Emoji {
    glyph: "🙇\u{200d}♂\u{fe0f}",
    codepoint: "1F647 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man bowing",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇\u{200d}♂",
        codepoint: "1F647 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man bowing",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man buig"),
            keywords: &["buig", "gebaar", "guns", "jammer", "man", "verskoning"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ማጎንበስ"),
            keywords: &["ማጎንበስ", "ወንድ", "የእጅ ምልክት", "ይቅርታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل ينحني اعتذار\u{64b}ا"),
            keywords: &[
                "امتنان",
                "انحناء",
                "رجل ينحني",
                "رجل ينحني اعتذار\u{64b}ا",
                "ركوع",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিৰ নত কৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "উপক\u{9be}ৰ",
                "ক\u{9cd}ষম\u{9be}",
                "দ\u{9c1}ঃখিত",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ভঙ\u{9cd}গীম\u{9be}",
                "শিৰ নত কৰ\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
                "শিৰ নত কৰি থক\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("baş əyən kişi"),
            keywords: &[
                "alqış",
                "baş əyən kişi",
                "jest",
                "kişi",
                "lehinə",
                "tənzim",
                "üzrxahlıq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына нізка кланяецца"),
            keywords: &[
                "жэст",
                "мужчына",
                "мужчына нізка кланяецца",
                "павага",
                "прабач",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("покланящ се мъж"),
            keywords: &["жест", "извинение", "покланящ се мъж", "поклон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলেদর ম\u{9be}থ\u{9be} নত কর\u{9be}"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "ছেলেদর ম\u{9be}থ\u{9be} নত কর\u{9be}",
                "দ\u{9c1}ঃখিত",
                "প\u{9c1}র\u{9c1}ষ",
                "ম\u{9be}প চ\u{9be}ওয\u{9bc}\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac se naklanja"),
            keywords: &[
                "gestikulacija",
                "izvinjenje",
                "muškarac",
                "muškarac se naklanja",
                "naklon",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home capcot"),
            keywords: &["disculpa", "gest", "home", "home capcot", "reverència"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏘᏌᏘ"),
            keywords: &[
                "ᎠᏍᎦᏯ ᎤᏘᏌᏘ",
                "ᎠᏙᏍᏈᏗᎠ",
                "ᎡᏍᎦ ᎠᏰᎸᏍᎦ",
                "ᎡᏍᎦ ᎠᏰᎸᏍᎬ",
                "ᏓᏐᏰᏍᎬ",
                "ᏱᏗᏓᏛᏁᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("uklánějící se muž"),
            keywords: &[
                "gesto",
                "lítost",
                "muž",
                "omluva",
                "poklona",
                "prosba",
                "uklánějící se muž",
                "úcta",
                "úklona",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn ymgrymu’n isel"),
            keywords: &[
                "dyn",
                "dyn yn ymgrymu’n isel",
                "ffafr",
                "ymddiheuriad",
                "ymgrymiad",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand bukker dybt"),
            keywords: &[
                "buk",
                "mand",
                "mand bukker dybt",
                "undskyld",
                "undskyldning",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich verbeugender Mann"),
            keywords: &["Demut", "Mann", "sich verbeugender Mann", "verbeugen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας υποκλίνεται"),
            keywords: &[
                "άντρας",
                "άντρας υποκλίνεται",
                "συγγνώμη",
                "υπόκλιση",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man bowing"),
            keywords: &["apology", "bowing", "favor", "gesture", "man", "sorry"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["apology", "bowing", "favour", "gesture", "man", "sorry"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre haciendo una reverencia"),
            keywords: &[
                "disculpa",
                "gesto",
                "hombre haciendo una reverencia",
                "perdón",
                "reverencia",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sügavalt kummarduv mees"),
            keywords: &[
                "kummardus",
                "mees",
                "sügavalt kummarduv mees",
                "vabandus",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burua makurtzen ari den gizona"),
            keywords: &[
                "barkamena",
                "burua makurtzen ari den gizona",
                "gizona",
                "gizonezkoa",
                "keinua",
                "makurtu",
                "mesedea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد تعظیم می\u{200c}کند"),
            keywords: &[
                "خواهش داشتن",
                "درخواست کردن",
                "عذرخواهی",
                "عذرخواهی کردن",
                "متأسف",
                "مرد تعظیم می\u{200c}کند",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syvään kumartava mies"),
            keywords: &[
                "anteeksipyyntö",
                "ele",
                "kumarrus",
                "mies",
                "syvään kumartava mies",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking nakayuko"),
            keywords: &[
                "lalaking nakayuko",
                "nakayuko",
                "paggalang",
                "paumanhin",
                "yumuyuko",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður sum bukkar"),
            keywords: &["bukkar", "maður", "maður sum bukkar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme qui s’incline"),
            keywords: &["désolé", "geste", "homme", "homme qui s’incline", "incliné"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "courbette",
                "désolé",
                "excuses",
                "homme",
                "homme qui s’incline",
                "incliné",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear ag umhlú"),
            keywords: &[
                "fear",
                "fear ag umhlú",
                "gar",
                "leithscéal",
                "tá brón air",
                "umhlaigh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine a’ cromadh"),
            keywords: &[
                "cromadh",
                "duilich",
                "duine",
                "duine a’ cromadh",
                "fear",
                "fireannach",
                "fàbhar",
                "gluasad",
                "leisgeul",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home facendo unha reverencia"),
            keywords: &[
                "desculpas",
                "home",
                "home facendo unha reverencia",
                "reverencia",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{a82}દન કરતો પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "ઊ\u{a82}ડ\u{ac7}થી નમ\u{ac7}લ",
                "નમવ\u{ac1}\u{a82}",
                "પ\u{ac1}ર\u{ac1}ષ",
                "મન\u{ac7} માફ કરશો",
                "માફ કરશો",
                "વ\u{a82}દન કરતો પ\u{ac1}ર\u{ac1}ષ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji mai sunkuya"),
            keywords: &[
                "alheri",
                "gafarta",
                "haƙuri",
                "karimcin",
                "mutum",
                "namiji mai sunkuya",
                "yin sunkuya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר משתחווה"),
            keywords: &["איש", "גבר", "התנצלות", "טובה", "מצטער", "משתחווה", "סליחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सर झ\u{941}काता प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "इशारा",
                "एहसान",
                "झ\u{941}कन\u{947}",
                "प\u{941}र\u{941}ष",
                "माफ\u{93c} कीजिय\u{947}",
                "माफी",
                "सर झ\u{941}काता प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac u dubokom naklonu"),
            keywords: &[
                "isprika",
                "ispričavanje",
                "muškarac u dubokom naklonu",
                "naklon",
                "usluga",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("meghajló férfi"),
            keywords: &[
                "bocsánat",
                "bocsánatkérés",
                "férfi",
                "meghajlás",
                "meghajló",
                "sajnálat",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոնարհվող տղամարդ"),
            keywords: &[
                "ժեստ",
                "խոնարհվել",
                "խոնարհվող տղամարդ",
                "ներողություն",
                "տղամարդ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria membungkuk"),
            keywords: &["isyarat", "laki-laki", "maaf", "pria membungkuk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-ehulata ala"),
            keywords: &[
                "na-ehulata ala",
                "ndo",
                "ngọzi",
                "nwoke",
                "nwoke na-ehulata ala",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður hneigir sig"),
            keywords: &[
                "afsakið",
                "auðmýkt",
                "hneiging",
                "karl",
                "maður hneigir sig",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo che fa inchino profondo"),
            keywords: &[
                "gesto",
                "inchino",
                "scuse",
                "uomo",
                "uomo che fa inchino profondo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おじぎする男"),
            keywords: &[
                "おじぎ",
                "おじぎする男",
                "ごめんなさい",
                "土下座",
                "男",
                "男性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang mbungkuk ngurmati"),
            keywords: &[
                "isarat",
                "kilap",
                "mbungkuk",
                "njaluk ngapura",
                "njaluk tulung",
                "wong lanang",
                "wong lanang mbungkuk ngurmati",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თავდახრილი კაცი"),
            keywords: &["თავდახრილი", "კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басын иіп тұрған ер"),
            keywords: &[
                "бас ию",
                "басын иіп тұрған ер",
                "ер",
                "кешірім сұрау",
                "өтіну",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand bukker dybt"),
            keywords: &[
                "buk",
                "mand",
                "mand bukker dybt",
                "undskyld",
                "undskyldning",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសឱនល\u{17c6}ទោន"),
            keywords: &[
                "គោរព",
                "ប\u{17bb}រសឱនល\u{17c6}ទោន",
                "ស\u{17bb}\u{17c6}ទោស",
                "ឱន",
                "ឱនល\u{17c6}ទោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ"),
            keywords: &[
                "ಕ\u{ccd}ಷಮ\u{cc6} ಕೇಳು",
                "ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ",
                "ತಲ\u{cc6} ಬಾಗು",
                "ಪುರುಷ",
                "ಸಹಾಯ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("절하는 남자"),
            keywords: &["넙죽", "사과", "절하는 남자", "정중함", "큰절"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो बागवता"),
            keywords: &[
                "दादलो",
                "दादलो बागवता",
                "फावोर",
                "बागवप",
                "माफ करच\u{947}\u{902}",
                "माफी मागता",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүгүнүп жаткан эркек"),
            keywords: &[
                "жүгүнүп жаткан эркек",
                "жүгүнүү",
                "ишарат",
                "кечирим суроо",
                "эркек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("sech vernäipende Mann"),
            keywords: &[
                "Entschëllegung",
                "Gefalen",
                "Geste",
                "Mann",
                "entschëllegt",
                "sech vernäipende Mann",
                "vernäipen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍກ\u{ebb}\u{ec9}ມຄຳນ\u{eb1}ບ"),
            keywords: &[
                "ກ\u{ebb}\u{ec9}ມ",
                "ຄຳນ\u{eb1}ບ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍກ\u{ebb}\u{ec9}ມຄຳນ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nusilenkiantis vyras"),
            keywords: &[
                "apgailestavimas",
                "atsiprašymas",
                "gestas",
                "nusilenkiantis vyras",
                "nusilenkimas",
                "paslauga",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis paklanās"),
            keywords: &["cieņa", "paklanīšanās", "vīrietis", "vīrietis paklanās"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tuohu"),
            keywords: &["aroha", "tohu", "tuohu", "tāne", "whakapai", "whakapāha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж се поклонува"),
            keywords: &["извинување", "маж", "маж се поклонува", "поклонување"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലക\u{d41}നിയ\u{d4d}ക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "ക\u{d4d}ഷമ\u{d3e}പണം",
                "തല ക\u{d41}നിയ\u{d4d}ക\u{d4d}കൽ",
                "തലക\u{d41}നിയ\u{d4d}ക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөхийж буй эрэгтэй"),
            keywords: &[
                "бөхийж буй эрэгтэй",
                "бөхийх",
                "дохио",
                "тус гуйх",
                "уучлалт",
                "эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मान खाली घातल\u{947}ला प\u{941}र\u{941}ष"),
            keywords: &[
                "उपकार",
                "क\u{94d}षमा",
                "क\u{94d}षमायाचना",
                "झ\u{941}कण\u{947}",
                "प\u{941}र\u{941}ष",
                "मान खाली घातल\u{947}ला प\u{941}र\u{941}ष",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki menunduk"),
            keywords: &["gerak isyarat", "kemaafan", "lelaki", "maaf", "menunduk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jikina"),
            keywords: &[
                "apoloġija",
                "favur",
                "inkina",
                "jiddispjaċih",
                "raġel jikina",
                "reġel",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{102d}\u{102f}ရ\u{102d}\u{102f}ကျ\u{102d}\u{102f}းကျ\u{102d}\u{102f}း ဦးည\u{103d}\u{103e}တ\u{103a}နေသ\u{1030} အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "တောင\u{103a}းပန\u{103a}",
                "ရ\u{102d}\u{102f}ရ\u{102d}\u{102f}ကျ\u{102d}\u{102f}းကျ\u{102d}\u{102f}း ဦးည\u{103d}\u{103e}တ\u{103a}နေသ\u{1030} အမျ\u{102d}\u{102f}းသား",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသား",
                "ဦးည\u{103d}\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bukkende mann"),
            keywords: &["beklagelse", "bukk", "bukkende mann", "mann", "unnskyld"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आदरभावल\u{947} निह\u{941}रिरह\u{947}को छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "आदरभावल\u{947} निह\u{941}रिरह\u{947}को छोरामान\u{94d}छ\u{947}",
                "इसारा",
                "द\u{941}:खी",
                "निह\u{941}रिरह\u{947}को",
                "प\u{941}र\u{942}ष",
                "माफी",
                "सहयोग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("buigende man"),
            keywords: &[
                "buigen",
                "buigende man",
                "excuses",
                "gebaar",
                "gunst",
                "man",
                "sorry",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bukkande mann"),
            keywords: &["bukk", "bukkande mann", "mann", "orsak", "orsaking"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଅନ\u{b41}ଗ\u{b4d}ରହ",
                "କ\u{b4d}ଷମ\u{b3e} ପ\u{b4d}ର\u{b3e}ର\u{b4d}ଥନ\u{b3e} କର\u{b3f}ବ\u{b3e}",
                "ଦ\u{b41}ଃଖ\u{b3f}ତ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ",
                "ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿਰ ਝ\u{a41}ਕਾਉ\u{a02}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਅਫਸ\u{a4b}ਸ",
                "ਅਹਿਸਾਨ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਮਾਫੀ",
                "ਸਿਰ ਝ\u{a41}ਕਾਉ\u{a02}ਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਸਿਰ ਝ\u{a41}ਕਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ج\u{64f}ھکدا بندہ"),
            keywords: &[
                "اشارہ",
                "بندہ",
                "ج\u{64f}ھکدا بندہ",
                "ج\u{64f}ھکنا",
                "ساتھ دینا",
                "معذرت",
                "معذرت خواہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé De Baú Daun"),
            keywords: &[
                "Apọ\u{301}lọ\u{301}ji",
                "Baú Daun",
                "Hẹ\u{301}lẹ\u{301}p Pẹ\u{301}sin",
                "Man",
                "Man Wé De Baú Daun",
                "Sain",
                "Sọ\u{301}ri",
                "To Tọ\u{301}k Sé Yu Dé Sọ\u{301}ri Fọ Rọ\u{301}ng Tin Wé Yu Dọ\u{301}n Du",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna w ukłonie"),
            keywords: &[
                "gest",
                "mężczyzna",
                "mężczyzna w ukłonie",
                "przepraszam",
                "ukłon",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی ښکته کيږي"),
            keywords: &[
                "اشاره",
                "بخښنه",
                "سړی",
                "سړی ښکته کيږي",
                "مرسته",
                "معذرت",
                "ښکته کېدل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem fazendo reverência"),
            keywords: &[
                "desculpas",
                "gesto",
                "homem",
                "homem fazendo reverência",
                "homem pedindo desculpas",
                "respeito",
                "reverência",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem a fazer a vénia"),
            keywords: &[
                "desculpas",
                "favor",
                "gesto",
                "homem",
                "homem a fazer a vénia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("upaykusqa tata"),
            keywords: &[
                "gesto",
                "khuyay",
                "qhispichiway",
                "qhispichiy",
                "tata",
                "upaykusqa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat care se înclină"),
            keywords: &[
                "bărbat",
                "bărbat care se înclină",
                "favoare",
                "gest",
                "iertare",
                "scuză",
                "înclinare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1215"),
            keywords: &["E10-1215"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина кланяется"),
            keywords: &[
                "извинение",
                "мужчина",
                "мужчина кланяется",
                "поклон",
                "просьба",
                "прощение",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo wunamye"),
            keywords: &[
                "gutonesha",
                "ihangane",
                "ikimenyetso",
                "kunama",
                "ukwicuza",
                "umugabo",
                "umugabo wunamye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد جهڪندي"),
            keywords: &[
                "اشارو",
                "افسوس",
                "جي حق ۾",
                "جھڪندي",
                "مرد",
                "مرد جهڪندي",
                "معافي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැඹ\u{dd4}ර\u{dd2}න\u{dca} හ\u{dd2}ස නවන ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "උදව\u{dca}ව",
                "ගැඹ\u{dd4}ර\u{dd2}න\u{dca} හ\u{dd2}ස නවන ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "නැම\u{dd3}ම",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
                "සම\u{dcf}වන\u{dca}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klaňajúci sa muž"),
            keywords: &[
                "gesto",
                "klaňajúci sa muž",
                "muž",
                "poklona",
                "prepáčte",
                "ľutujem",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški, ki se globoko priklanja"),
            keywords: &[
                "fant",
                "gesta",
                "moški",
                "moški, ki se globoko priklanja",
                "opravičilo",
                "oprosti",
                "priklanjanje",
                "priklon",
                "usluga",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin fooraraya"),
            keywords: &[
                "ka xummaansho",
                "meedaar",
                "nin",
                "nin fooraraya",
                "raaligalin",
                "roonaan",
                "waji foorarin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë që përkulet për falje"),
            keywords: &["burrë që përkulet për falje", "falje", "gjest", "ndjesë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушки дубоки наклон"),
            keywords: &[
                "гестикулација",
                "извињење",
                "мушкарац",
                "мушки дубоки наклон",
                "наклон",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muški duboki naklon"),
            keywords: &[
                "gestikulacija",
                "izvinjenje",
                "muškarac",
                "muški duboki naklon",
                "naklon",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bugande man"),
            keywords: &["beklagelse", "buga", "bugande man", "man", "ursäkt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume aliyeinama"),
            keywords: &["inama", "mwanamume aliyeinama", "omba msamaha", "samahani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மன\u{bcd}னிப\u{bcd}பு கேட\u{bcd}கும\u{bcd} ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "ச\u{bbe}ரி",
                "மன\u{bcd}னித\u{bcd}துவிடு",
                "மன\u{bcd}னிப\u{bcd}பு",
                "மன\u{bcd}னிப\u{bcd}பு கேட\u{bcd}கும\u{bcd} ஆண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}షమ\u{c3e}పణలు క\u{c4b}రుకున\u{c4d}న పురుషుడు"),
            keywords: &[
                "క\u{c4d}షమ\u{c3e}పణలు క\u{c4b}రుకున\u{c4d}న పురుషుడు",
                "క\u{c4d}షమ\u{c3f}ంచండ\u{c3f}",
                "తల వంచడం",
                "పురుషుడు",
                "సంజ\u{c4d}ఞ",
                "సహ\u{c3e}యం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки хам шуда истодааст"),
            keywords: &[
                "бахшиш",
                "имову ишора",
                "лутф",
                "мард",
                "марде, ки хам шуда истодааст",
                "узр",
                "хам шуда истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายหมอบคำน\u{e31}บ"),
            keywords: &[
                "กราบ",
                "ขอโทษ",
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายหมอบคำน\u{e31}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tagzym edýän erkek"),
            keywords: &[
                "bagyşlaň",
                "erkek",
                "hemaýat",
                "tagzym",
                "tagzym edýän erkek",
                "ötünç",
                "üm",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata punou"),
            keywords: &["tangata punou"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("başını öne eğen erkek"),
            keywords: &[
                "adam",
                "baş eğme",
                "başını öne eğen erkek",
                "erkek",
                "hareket",
                "lütuf",
                "özür",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېگىلگەن ئەر"),
            keywords: &[
                "ئىشارە",
                "ئۆتۈنۈش",
                "ئۆزۈر",
                "ئېگىلىش",
                "ئېگىلگەن ئەر",
                "ئەر",
                "كەچۈرۈڭ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік, що вклоняється"),
            keywords: &[
                "вибачення",
                "повага",
                "покора",
                "чоловік",
                "чоловік, що вклоняється",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بہت زیادہ جھکا ہوا مرد"),
            keywords: &["افسوس", "بہت زیادہ جھکا ہوا مرد", "مرد", "معافی", "معذرت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak ta’zim qilmoqda"),
            keywords: &[
                "erkak",
                "erkak ta’zim qilmoqda",
                "iltifot",
                "imo-ishora",
                "taʼzim",
                "uzr",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông cúi đầu"),
            keywords: &[
                "cúi đầu",
                "cử chỉ",
                "người đàn ông",
                "người đàn ông cúi đầu",
                "xin lỗi",
                "ủng hộ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor sujjóotal"),
            keywords: &[
                "beral-loxo",
                "góor",
                "jéggalu",
                "liyaar",
                "massawu",
                "sujjóotal",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda egobayo"),
            keywords: &[
                "indoda",
                "indoda egobayo",
                "jekula",
                "ukugoba",
                "ukuxolisa",
                "uxolo",
                "xhasa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tí ń tẹríba"),
            keywords: &[
                "bẹ\u{300}bẹ\u{300}",
                "fọwọ\u{301}júwè",
                "pẹ\u{300}lẹ\u{301}",
                "títẹríba",
                "àànú",
                "ọkùnrin",
                "ọkùnrin tí ń tẹríba",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鞠躬嘅男人"),
            keywords: &["姿勢", "對唔住", "感謝", "男", "道歉", "鞠躬", "鞠躬嘅男人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鞠躬嘅男人"),
            keywords: &["姿势", "对唔住", "感谢", "男", "道歉", "鞠躬", "鞠躬嘅男人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男生鞠躬"),
            keywords: &["不好意思", "对不起", "男", "男生鞠躬", "道歉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生鞠躬"),
            keywords: &["不好意思", "男", "男生鞠躬", "道歉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鞠躬嘅男人"),
            keywords: &["鞠躬嘅男人", "鞠躬｜唔好意思｜對唔住｜sorry｜男人｜道歉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda ethobe kakhulu"),
            keywords: &[
                "indoda",
                "indoda ethobe kakhulu",
                "ukuthoba",
                "ukuxolisa",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙇🏻\u{200d}♂\u{fe0f}"]
pub const MAN_BOWING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F647 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man bowing: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏻\u{200d}♂",
        codepoint: "1F647 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man bowing: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏼\u{200d}♂\u{fe0f}"]
pub const MAN_BOWING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F647 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man bowing: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏼\u{200d}♂",
        codepoint: "1F647 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man bowing: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏽\u{200d}♂\u{fe0f}"]
pub const MAN_BOWING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F647 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man bowing: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏽\u{200d}♂",
        codepoint: "1F647 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man bowing: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏾\u{200d}♂\u{fe0f}"]
pub const MAN_BOWING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F647 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man bowing: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏾\u{200d}♂",
        codepoint: "1F647 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man bowing: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏿\u{200d}♂\u{fe0f}"]
pub const MAN_BOWING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F647 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man bowing: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏿\u{200d}♂",
        codepoint: "1F647 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man bowing: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇\u{200d}♀\u{fe0f}"]
pub const WOMAN_BOWING: crate::Emoji = crate::Emoji {
    glyph: "🙇\u{200d}♀\u{fe0f}",
    codepoint: "1F647 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman bowing",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇\u{200d}♀",
        codepoint: "1F647 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman bowing",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou buig"),
            keywords: &["buig", "gebaar", "guns", "jammer", "verskoning", "vrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ማጎንበስ"),
            keywords: &["ማጎንበስ", "ሴት", "የእጅ ምልክት", "ይቅርታ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة تنحني اعتذار\u{64b}ا"),
            keywords: &[
                "أسف",
                "اعتذار",
                "امتنان",
                "انحناء",
                "ركوع",
                "سيدة تنحني",
                "سيدة تنحني اعتذار\u{64b}ا",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিৰ নত কৰ\u{9be} মহিল\u{9be}"),
            keywords: &[
                "উপক\u{9be}ৰ",
                "দ\u{9c1}ঃখিত",
                "ভঙ\u{9cd}গী",
                "মহিল\u{9be}",
                "শিৰ নত কৰ\u{9be} মহিল\u{9be}",
                "শিৰ নত কৰি থক\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("baş əyən qadın"),
            keywords: &[
                "alqış",
                "baş əyən qadın",
                "jest",
                "lehinə",
                "qadın",
                "tənzim",
                "üzrxahlıq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына нізка кланяецца"),
            keywords: &[
                "жанчына",
                "жанчына нізка кланяецца",
                "жэст",
                "павага",
                "прабач",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("покланяща се жена"),
            keywords: &["жест", "извинение", "покланяща се жена", "поклон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}েদের ম\u{9be}থ\u{9be} নত কর\u{9be}"),
            keywords: &[
                "অঙ\u{9cd}গিভঙ\u{9cd}গি",
                "দ\u{9c1}ঃখিত",
                "মহিল\u{9be}",
                "ম\u{9be}প চ\u{9be}ওয\u{9bc}\u{9be}",
                "মেয\u{9bc}েদের ম\u{9be}থ\u{9be} নত কর\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena se naklanja"),
            keywords: &[
                "gestikulacija",
                "izvinjenje",
                "naklon",
                "žena",
                "žena se naklanja",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona capcota"),
            keywords: &["disculpa", "dona", "dona capcota", "gest", "reverència"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᏘᏌᏘ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᎤᏘᏌᏘ",
                "ᎠᏙᏍᏈᏗᎠ",
                "ᎡᏍᎦ ᎠᏰᎸᏍᎦ",
                "ᎡᏍᎦ ᎠᏰᎸᏍᎬ",
                "ᏓᏐᏰᏍᎬ",
                "ᏱᏗᏓᏛᏁᏗ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("uklánějící se žena"),
            keywords: &[
                "gesto",
                "lítost",
                "omluva",
                "poklona",
                "prosba",
                "uklánějící se žena",
                "úcta",
                "úklona",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn ymgrymu’n isel"),
            keywords: &[
                "ffafr",
                "menyw",
                "menyw yn ymgrymu’n isel",
                "ymddiheuriad",
                "ymgrymiad",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde bukker dybt"),
            keywords: &[
                "buk",
                "kvinde",
                "kvinde bukker dybt",
                "undskyld",
                "undskyldning",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich verbeugende Frau"),
            keywords: &["Demut", "Frau", "sich verbeugende Frau", "verbeugen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα υποκλίνεται"),
            keywords: &[
                "γυναίκα",
                "γυναίκα υποκλίνεται",
                "συγγνώμη",
                "υπόκλιση",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman bowing"),
            keywords: &["apology", "bowing", "favor", "gesture", "sorry", "woman"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["apology", "bowing", "favour", "gesture", "sorry", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer haciendo una reverencia"),
            keywords: &[
                "disculpa",
                "gesto",
                "mujer haciendo una reverencia",
                "perdón",
                "reverencia",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sügavalt kummarduv naine"),
            keywords: &[
                "kummardus",
                "naine",
                "sügavalt kummarduv naine",
                "vabandus",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burua makurtzen ari den emakumea"),
            keywords: &[
                "barkamena",
                "burua makurtzen ari den emakumea",
                "emakumea",
                "emakumezkoa",
                "keinua",
                "makurtu",
                "mesedea",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن تعظیم می\u{200c}کند"),
            keywords: &[
                "خواهش داشتن",
                "درخواست کردن",
                "زن تعظیم می\u{200c}کند",
                "عذرخواهی",
                "عذرخواهی کردن",
                "متأسف",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("syvään kumartava nainen"),
            keywords: &[
                "anteeksipyyntö",
                "ele",
                "kumarrus",
                "nainen",
                "syvään kumartava nainen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng nakayuko"),
            keywords: &[
                "babaeng nakayuko",
                "nakayuko",
                "paggalang",
                "paumanhin",
                "yumuyuko",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinna sum bukkar"),
            keywords: &["bukkar", "kona", "kvinna", "kvinna sum bukkar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme qui s’incline"),
            keywords: &[
                "désolée",
                "femme",
                "femme qui s’incline",
                "geste",
                "inclinée",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "courbette",
                "désolée",
                "excuses",
                "femme",
                "femme qui s’incline",
                "homme qui s’incline",
                "inclinée",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean ag umhlú"),
            keywords: &[
                "bean",
                "bean ag umhlú",
                "comhartha",
                "leithscéal",
                "tá brón uirthi",
                "umhlaigh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach a’ cromadh"),
            keywords: &[
                "boireannach",
                "boireannach a’ cromadh",
                "cromadh",
                "duilich",
                "fàbhar",
                "gluasad",
                "leisgeul",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller facendo unha reverencia"),
            keywords: &[
                "desculpas",
                "muller",
                "muller facendo unha reverencia",
                "reverencia",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{a82}દન કરતી સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "ઊ\u{a82}ડ\u{ac7}થી નમ\u{ac7}લ",
                "નમવ\u{ac1}\u{a82}",
                "મન\u{ac7} માફ કરશો",
                "માફ કરશો",
                "વ\u{a82}દન કરતી સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai sunkuya"),
            keywords: &[
                "alheri",
                "gafarta",
                "haƙuri",
                "karimcin",
                "mace",
                "mace mai sunkuya",
                "yin sunkuya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה משתחווה"),
            keywords: &["אישה", "התנצלות", "טובה", "מצטערת", "משתחווה", "סליחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सर झ\u{941}काती महिला"),
            keywords: &[
                "इशारा",
                "एहसान",
                "क\u{94d}षमा कर\u{947}\u{902}",
                "झ\u{941}कन\u{947}",
                "महिला",
                "माफी",
                "सर झ\u{941}काती महिला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena u dubokom naklonu"),
            keywords: &[
                "isprika",
                "ispričavanje",
                "naklon",
                "usluga",
                "žena u dubokom naklonu",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("meghajló nő"),
            keywords: &[
                "bocsánat",
                "bocsánatkérés",
                "meghajlás",
                "meghajló",
                "nő",
                "sajnálat",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոնարհվող կին"),
            keywords: &["ժեստ", "խոնարհվել", "խոնարհվող կին", "կին", "ներողություն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita membungkuk"),
            keywords: &["isyarat", "maaf", "perempuan", "wanita membungkuk"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-ehulata ala"),
            keywords: &[
                "na-ehulata ala",
                "ndo",
                "ngọzi",
                "nwanyị",
                "nwanyị na-ehulata ala",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona hneigir sig"),
            keywords: &["afsakið", "auðmýkt", "hneiging", "kona", "kona hneigir sig"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna che fa inchino profondo"),
            keywords: &[
                "donna",
                "donna che fa inchino profondo",
                "gesto",
                "inchino",
                "scuse",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おじぎする女"),
            keywords: &[
                "おじぎ",
                "おじぎする女",
                "ごめんなさい",
                "土下座",
                "女",
                "女性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon mbungkuk ngurmati"),
            keywords: &[
                "isarat",
                "kilap",
                "mbungkuk",
                "njaluk ngapura",
                "njaluk tulung",
                "wong wadon",
                "wong wadon mbungkuk ngurmati",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თავდახრილი ქალი"),
            keywords: &["თავდახრილი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("басын иіп тұрған әйел"),
            keywords: &[
                "бас ию",
                "басын иіп тұрған әйел",
                "кешірім сұрау",
                "әйел",
                "өтіну",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde bukker dybt"),
            keywords: &[
                "buk",
                "kvinde",
                "kvinde bukker dybt",
                "undskyld",
                "undskyldning",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}ឱនល\u{17c6}ទោន"),
            keywords: &[
                "គោរព",
                "នារ\u{17b8}ឱនល\u{17c6}ទោន",
                "ស\u{17bb}\u{17c6}ទោស",
                "ឱន",
                "ឱនល\u{17c6}ទោន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ"),
            keywords: &[
                "ಕ\u{ccd}ಷಮ\u{cc6} ಕೇಳು",
                "ಕ\u{ccd}ಷಮ\u{cc6}ಯಾಚ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ತಲ\u{cc6} ಬಾಗು",
                "ಸಹಾಯ",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("절하는 여자"),
            keywords: &["넙죽", "사과", "절하는 여자", "정중함", "큰절"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल बागवता"),
            keywords: &[
                "फावोर",
                "बागवप",
                "बायल",
                "बायल बागवता",
                "माफ करच\u{947}\u{902}",
                "माफी मागता",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүгүнүп жаткан аял"),
            keywords: &[
                "аял",
                "жүгүнүп жаткан аял",
                "жүгүнүү",
                "ишарат",
                "кечирим суроо",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("sech vernäipend Fra"),
            keywords: &[
                "Entschëllegung",
                "Fra",
                "Gefalen",
                "Geste",
                "entschëllegt",
                "sech vernäipend Fra",
                "vernäipen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງກ\u{ebb}\u{ec9}ມຄຳນ\u{eb1}ບ"),
            keywords: &[
                "ກ\u{ebb}\u{ec9}ມ",
                "ຄຳນ\u{eb1}ບ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງກ\u{ebb}\u{ec9}ມຄຳນ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nusilenkianti moteris"),
            keywords: &[
                "apgailestavimas",
                "atsiprašymas",
                "gestas",
                "moteris",
                "nusilenkianti moteris",
                "nusilenkimas",
                "paslauga",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete paklanās"),
            keywords: &["cieņa", "paklanīšanās", "sieviete", "sieviete paklanās"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tuohu"),
            keywords: &["aroha", "tohu", "tuohu", "wahine", "whakapai", "whakapāha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена се поклонува"),
            keywords: &["жена", "жена се поклонува", "извинување", "поклонување"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലക\u{d41}നിയ\u{d4d}ക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ"),
            keywords: &[
                "ക\u{d4d}ഷമ\u{d3e}പണം",
                "തല ക\u{d41}നിയ\u{d4d}ക\u{d4d}കൽ",
                "തലക\u{d41}നിയ\u{d4d}ക\u{d4d}ക\u{d41}ന\u{d4d}ന സ\u{d4d}ത\u{d4d}രീ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бөхийж буй эмэгтэй"),
            keywords: &[
                "бөхийж буй эмэгтэй",
                "бөхийх",
                "дохио",
                "тус гуйх",
                "уучлалт",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मान खाली घातल\u{947}ली महिला"),
            keywords: &[
                "उपकार",
                "क\u{94d}षमस\u{94d}व",
                "क\u{94d}षमायाचना",
                "झ\u{941}कण\u{947}",
                "महिला",
                "मान खाली घातल\u{947}ली महिला",
                "हावभाव",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan menunduk"),
            keywords: &[
                "gerak isyarat",
                "kemaafan",
                "maaf",
                "menunduk",
                "perempuan",
                "wanita",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara tikina"),
            keywords: &[
                "apoloġija",
                "favur",
                "inkina",
                "jiddispjaċih",
                "mara",
                "mara tikina",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရ\u{102d}\u{102f}ရ\u{102d}\u{102f}ကျ\u{102d}\u{102f}းကျ\u{102d}\u{102f}း ဦးည\u{103d}\u{103e}တ\u{103a}နေသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
            ),
            keywords: &[
                "တောင\u{103a}းပန\u{103a}",
                "ရ\u{102d}\u{102f}ရ\u{102d}\u{102f}ကျ\u{102d}\u{102f}းကျ\u{102d}\u{102f}း ဦးည\u{103d}\u{103e}တ\u{103a}နေသ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမ\u{1030}အယာ",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "ဦးည\u{103d}\u{103e}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bukkende kvinne"),
            keywords: &[
                "beklagelse",
                "bukk",
                "bukkende kvinne",
                "kvinne",
                "unnskyld",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आदरभावल\u{947}\u{947} निह\u{941}रिरह\u{947}की छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "आदरभावल\u{947}\u{947} निह\u{941}रिरह\u{947}की छोरीमान\u{94d}छ\u{947}",
                "इसारा",
                "द\u{941}:खी",
                "निह\u{941}रिरह\u{947}को",
                "महिला",
                "माफी",
                "सहयोग",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("buigende vrouw"),
            keywords: &[
                "buigen",
                "buigende vrouw",
                "excuses",
                "gebaar",
                "gunst",
                "sorry",
                "vrouw",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bukkande kvinne"),
            keywords: &["bukk", "bukkande kvinne", "kvinne", "orsak", "orsaking"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗଭଙ\u{b4d}ଗୀ",
                "ଅନ\u{b41}ଗ\u{b4d}ରହ",
                "କ\u{b4d}ଷମ\u{b3e} ପ\u{b4d}ର\u{b3e}ର\u{b4d}ଥନ\u{b3e} କର\u{b3f}ବ\u{b3e}",
                "ଦ\u{b41}ଃଖ\u{b3f}ତ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}",
                "ମ\u{b41}ଣ\u{b4d}ଡ ନ\u{b41}ଆ\u{b01}ଇବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਿਰ ਝ\u{a41}ਕਾਉ\u{a02}ਦੀ ਇਸਤਰੀ"),
            keywords: &[
                "ਅਫਸ\u{a4b}ਸ",
                "ਅਹਿਸਾਨ",
                "ਇਸਤਰੀ",
                "ਇਸ\u{a3c}ਾਰਾ",
                "ਔਰਤ",
                "ਮਾਫੀ",
                "ਸਿਰ ਝ\u{a41}ਕਾਉ\u{a02}ਦੀ ਇਸਤਰੀ",
                "ਸਿਰ ਝ\u{a41}ਕਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ج\u{64f}ھکدی زنانی"),
            keywords: &[
                "اشارہ",
                "ج\u{64f}ھکدی زنانی",
                "ج\u{64f}ھکنا",
                "زنانی",
                "ساتھ دینا",
                "معذرت",
                "معذرت خواہ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé De Baú Daun"),
            keywords: &[
                "Apọ\u{301}lọ\u{301}ji",
                "Baú Daun",
                "Hẹ\u{301}lẹ\u{301}p Pẹ\u{301}sin",
                "Sain",
                "Sọ\u{301}ri",
                "To Tọ\u{301}k Sé Yu Dé Sọ\u{301}ri Fọ Rọ\u{301}ng Tin Wé Yu Dọ\u{301}n Du",
                "Wúman",
                "Wúman Wé De Baú Daun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta w ukłonie"),
            keywords: &[
                "gest",
                "kobieta",
                "kobieta w ukłonie",
                "przepraszam",
                "ukłon",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه ښکته کيږې"),
            keywords: &[
                "اشاره",
                "بخښنه",
                "معذرت",
                "ښځه",
                "ښځه ښکته کيږې",
                "ښکته کېدل",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher fazendo reverência"),
            keywords: &[
                "desculpas",
                "gesto",
                "mulher",
                "mulher fazendo reverência",
                "mulher pedindo desculpas",
                "respeito",
                "reverência",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher a fazer a vénia"),
            keywords: &[
                "desculpas",
                "favor",
                "gesto",
                "mulher",
                "mulher a fazer a vénia",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("upaykusqa warmi"),
            keywords: &[
                "gesto",
                "khuyay",
                "qhispichiway",
                "qhispichiy",
                "upaykusqa",
                "warmi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie care se înclină"),
            keywords: &[
                "favoare",
                "femeie",
                "femeie care se înclină",
                "gest",
                "iertare",
                "scuză",
                "înclinare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1214"),
            keywords: &["E10-1214"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина кланяется"),
            keywords: &[
                "женщина",
                "женщина кланяется",
                "извинение",
                "поклон",
                "просьба",
                "прощение",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore wunamye"),
            keywords: &[
                "gutonesha",
                "ihangane",
                "ikimenyetso",
                "kunama",
                "ukwicuza",
                "umugore",
                "umugore wunamye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جھڪندي"),
            keywords: &["اشارو", "افسوس", "جي حق ۾", "جھڪندي", "عورت", "معافي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැඹ\u{dd4}ර\u{dd2}න\u{dca} හ\u{dd2}ස නවන ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "උදව\u{dca}ව",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ගැඹ\u{dd4}ර\u{dd2}න\u{dca} හ\u{dd2}ස නවන ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "නැම\u{dd3}ම",
                "සම\u{dcf}වන\u{dca}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("klaňajúca sa žena"),
            keywords: &[
                "gesto",
                "klaňajúca sa žena",
                "poklona",
                "prepáčte",
                "ľutujem",
                "žena",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska, ki se globoko priklanja"),
            keywords: &[
                "dekle",
                "gesta",
                "opravičilo",
                "oprosti",
                "priklanjanje",
                "priklon",
                "usluga",
                "ženska",
                "ženska, ki se globoko priklanja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag fooraraysa"),
            keywords: &[
                "ka xummaansho",
                "madax foorarin",
                "meedaar",
                "naag",
                "naag fooraraysa",
                "raaligalin",
                "roonaan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua që përkulet për falje"),
            keywords: &["falje", "gjest", "grua që përkulet për falje", "ndjesë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женски дубоки наклон"),
            keywords: &[
                "гестикулација",
                "жена",
                "женски дубоки наклон",
                "извињење",
                "наклон",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženski duboki naklon"),
            keywords: &[
                "gestikulacija",
                "izvinjenje",
                "naklon",
                "žena",
                "ženski duboki naklon",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bugande kvinna"),
            keywords: &["beklagelse", "buga", "bugande kvinna", "kvinna", "ursäkt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke aliyeinama"),
            keywords: &["inama", "mwanamke aliyeinama", "omba msamaha", "samahani"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மன\u{bcd}னிப\u{bcd}பு கேட\u{bcd}கும\u{bcd} பெண\u{bcd}"),
            keywords: &[
                "ச\u{bbe}ரி",
                "பெண\u{bcd}",
                "மன\u{bcd}னித\u{bcd}துவிடு",
                "மன\u{bcd}னிப\u{bcd}பு",
                "மன\u{bcd}னிப\u{bcd}பு கேட\u{bcd}கும\u{bcd} பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}షమ\u{c3e}పణలు క\u{c4b}రుకున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}"),
            keywords: &[
                "క\u{c4d}షమ\u{c3e}పణ",
                "క\u{c4d}షమ\u{c3e}పణలు క\u{c4b}రుకున\u{c4d}న స\u{c4d}త\u{c4d}ర\u{c40}",
                "క\u{c4d}షమ\u{c3f}ంచండ\u{c3f}",
                "తల వంచడం",
                "మహ\u{c3f}ళ",
                "సంజ\u{c4d}ఞ",
                "సహ\u{c3e}యం",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зане, ки хам шуда истодааст"),
            keywords: &[
                "бахшиш",
                "зан",
                "зане, ки хам шуда истодааст",
                "имову ишора",
                "лутф",
                "узр",
                "хам шуда истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งหมอบคำน\u{e31}บ"),
            keywords: &[
                "กราบ",
                "ขอโทษ",
                "ท\u{e48}าทาง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งหมอบคำน\u{e31}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("tagzym edýän zenan"),
            keywords: &[
                "bagyşlaň",
                "hemaýat",
                "tagzym",
                "tagzym edýän zenan",
                "zenan",
                "ötünç",
                "üm",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine punou"),
            keywords: &["fefine punou"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("başını öne eğen kadın"),
            keywords: &[
                "bayan",
                "baş eğme",
                "başını öne eğen kadın",
                "hareket",
                "kadın",
                "lütuf",
                "özür",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېگىلگەن ئايال"),
            keywords: &[
                "ئايال",
                "ئىشارە",
                "ئۆتۈنۈش",
                "ئۆزۈر",
                "ئېگىلىش",
                "ئېگىلگەن ئايال",
                "كەچۈرۈڭ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка, що вклоняється"),
            keywords: &[
                "вибачення",
                "жінка",
                "жінка, що вклоняється",
                "повага",
                "покора",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بہت زیادہ جھکی ہوئی عورت"),
            keywords: &[
                "افسوس",
                "بہت زیادہ جھکی ہوئی عورت",
                "عورت",
                "معافی",
                "معذرت",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol ta’zim qilmoqda"),
            keywords: &[
                "ayol",
                "ayol ta’zim qilmoqda",
                "iltifot",
                "imo-ishora",
                "taʼzim",
                "uzr",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ cúi đầu"),
            keywords: &[
                "cúi đầu",
                "cử chỉ",
                "người phụ nữ",
                "người phụ nữ cúi đầu",
                "xin lỗi",
                "ủng hộ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen sujjóotal"),
            keywords: &[
                "beral-loxo",
                "jigéen",
                "jéggalu",
                "liyaar",
                "massawu",
                "sujjóotal",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa eligobayo"),
            keywords: &[
                "ibhinqa",
                "ibhinqa eligobayo",
                "jekula",
                "ukugoba",
                "ukuxolisa",
                "uxolo",
                "xhasa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin tí ń tẹríba"),
            keywords: &[
                "bẹ\u{300}bẹ\u{300}",
                "fọwọ\u{301}júwè",
                "obìnrin",
                "obìnrin tí ń tẹríba",
                "pẹ\u{300}lẹ\u{301}",
                "títẹríba",
                "àànú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鞠躬嘅女人"),
            keywords: &["女", "姿勢", "對唔住", "感謝", "道歉", "鞠躬", "鞠躬嘅女人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鞠躬嘅女人"),
            keywords: &["女", "姿势", "对唔住", "感谢", "道歉", "鞠躬", "鞠躬嘅女人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女生鞠躬"),
            keywords: &["不好意思", "女", "女生鞠躬", "对不起", "道歉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女生鞠躬"),
            keywords: &["不好意思", "女", "女生鞠躬", "道歉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鞠躬嘅女人"),
            keywords: &["鞠躬嘅女人", "鞠躬｜唔好意思｜對唔住｜sorry｜女人｜道歉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("owesimame othobe kakhulu"),
            keywords: &[
                "owesimame",
                "owesimame othobe kakhulu",
                "ukuthoba",
                "ukuxolisa",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙇🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_BOWING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F647 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman bowing: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏻\u{200d}♀",
        codepoint: "1F647 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman bowing: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_BOWING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F647 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman bowing: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏼\u{200d}♀",
        codepoint: "1F647 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman bowing: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_BOWING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F647 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman bowing: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏽\u{200d}♀",
        codepoint: "1F647 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman bowing: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_BOWING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F647 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman bowing: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏾\u{200d}♀",
        codepoint: "1F647 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman bowing: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🙇🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_BOWING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙇🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F647 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman bowing: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🙇🏿\u{200d}♀",
        codepoint: "1F647 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman bowing: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🤦"]
pub const PERSON_FACEPALMING: crate::Emoji = crate::Emoji {
    glyph: "🤦",
    codepoint: "1F926",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "person facepalming",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hand teen voorkop slaan"),
            keywords: &[
                "facepalm",
                "gsig",
                "hand teen voorkop slaan",
                "moedeloos",
                "ongeloof",
                "palm",
                "verbyster",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ማዘን"),
            keywords: &["መደነቅ", "መዳፍ", "ማዘን", "አለማመን", "እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}شخص محبط"),
            keywords: &["إحباط", "راحة يد", "سخط", "\u{202b}شخص محبط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}ৰত হ\u{9be}ত দিয\u{9bc}\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "ক\u{9cd}ৰোধ",
                "ম\u{9c1}খ",
                "ম\u{9c2}ৰত হ\u{9be}ত দিয\u{9bc}\u{9be} ব\u{9cd}যক\u{9cd}তি",
                "হ\u{9be}তৰ ত\u{9c1}ল\u{9c1}ৱ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("inanmaq olmur"),
            keywords: &["daha sözüm yoxdur", "inanmaq olmur", "inanılmaz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("далонь на твары"),
            keywords: &[
                "далонь",
                "далонь на твары",
                "не магу паверыць",
                "няма слоў",
                "рука",
                "твар",
                "фэйспалм",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ръка върху лице"),
            keywords: &["лице", "невярване", "отчаяние", "ръка", "ръка върху лице"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}থ\u{9be}য\u{9bc} হ\u{9be}ত"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "বিরক\u{9cd}তি",
                "ম\u{9be}থ\u{9be}য\u{9bc}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba s rukom na čelu"),
            keywords: &["dlan", "lice", "nevjerica", "osoba s rukom na čelu"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona amb la mà a la cara"),
            keywords: &[
                "exasperació",
                "frustració",
                "incredulitat",
                "persona amb la mà a la cara",
                "vergonya",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ"),
            keywords: &["ᎤᎧᏛ", "ᎤᏬᎭᏁᎦᎸ", "ᏄᏬᎯᏳᏒᎾ", "ᏩᎵᏍᏆᏗᏍᎬᎢ", "ᏴᏫ ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba chytající se za hlavu"),
            keywords: &[
                "chycení",
                "dlaň",
                "facepalm",
                "hlava",
                "nevíra",
                "osoba chytající se za hlavu",
                "rozhořčení",
                "smajlík",
                "tvář",
                "výraz",
                "zoufalství",
                "čelo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cledr i’r wyneb"),
            keywords: &[
                "anghrediniaeth",
                "cledr",
                "cledr i’r wyneb",
                "cythrudd",
                "wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("slå sig for panden"),
            keywords: &[
                "ansigt",
                "dumt",
                "facepalm",
                "hånd",
                "håndflade",
                "irriteret",
                "skepsis",
                "slå sig for panden",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich an den Kopf fassende Person"),
            keywords: &[
                "Gesicht",
                "frustriert",
                "genervt",
                "sich an den Kopf fassende Person",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο αγανακτά"),
            keywords: &[
                "άτομο αγανακτά",
                "αγανάκτηση",
                "δυσπιστία",
                "παλάμη",
                "πρόσωπο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person facepalming"),
            keywords: &[
                "disbelief",
                "exasperation",
                "face",
                "palm",
                "person facepalming",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona con la mano en la frente"),
            keywords: &[
                "facepalm",
                "frente",
                "incredulidad",
                "mano",
                "persona con la mano en la frente",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona con la mano en la frente"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "cara",
                "exasperación",
                "frente",
                "incredulidad",
                "palma",
                "persona con la mano en la frente",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeleheide"),
            keywords: &["meeleheide", "nägu", "umbusk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-azpia aurpegian"),
            keywords: &[
                "aurpegi",
                "esku-azpi",
                "esku-azpia aurpegian",
                "sinesgaiztasun",
                "sumindura",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("با کف دست به پیشانی زدن"),
            keywords: &[
                "با کف دست به پیشانی زدن",
                "رنجش",
                "صورت",
                "ناباوری",
                "کف دست",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("peittää kasvot kädellä"),
            keywords: &[
                "epätoivo",
                "kasvot",
                "käsi",
                "peittää kasvot kädellä",
                "pettymys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("naka-facepalm"),
            keywords: &["di makapaniwala", "mukha", "naka-facepalm", "palad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vónbrotin persónur"),
            keywords: &[
                "facepalm",
                "fólk",
                "persónur",
                "vónbrot",
                "vónbrotin persónur",
                "ørkymlan",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne avec la paume sur le visage"),
            keywords: &[
                "exaspération",
                "incrédulité",
                "paume de main",
                "personne avec la paume sur le visage",
                "visage",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("personne avec paume de la main sur le visage"),
            keywords: &[
                "exaspération",
                "incroyable",
                "main",
                "personne avec paume de la main sur le visage",
                "visage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine lena aghaidh ina bhos"),
            keywords: &[
                "aghaidh",
                "ar mire",
                "bos",
                "ciaptha",
                "duine lena aghaidh ina bhos",
                "lámh",
                "ní chreidim",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach le aodann na làmhan"),
            keywords: &[
                "aodann",
                "dì-chreideamh",
                "farranachadh",
                "làmh",
                "neach le aodann na làmhan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("incredulidade"),
            keywords: &["cara", "exasperación", "incredulidade"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માથા ઉપર હાથ દ\u{ac7}વો"),
            keywords: &[
                "અવિશ\u{acd}વાસ",
                "ચહ\u{ac7}રો",
                "માથા ઉપર હાથ દ\u{ac7}વો",
                "રોષ",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum nunawa kunya"),
            keywords: &[
                "fushi",
                "fuska",
                "mutum nunawa kunya",
                "rashin imani",
                "tafin hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה עם יד על הפנים"),
            keywords: &[
                "אישה עם יד על הפנים",
                "זעזוע",
                "לא יכול להיות",
                "לא מאמינה שזה קורה לי",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माथ\u{947} पर हाथ"),
            keywords: &[
                "अविश\u{94d}वास",
                "च\u{947}हरा",
                "झ\u{941}\u{902}झलाहट",
                "माथ\u{947} पर हाथ",
                "हथ\u{947}ली",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lupanje dlanom o čelo"),
            keywords: &["dlan", "lice", "lupanje dlanom o čelo", "nevjerica", "očaj"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kézbe temetett arc"),
            keywords: &[
                "arc",
                "elkeseredés",
                "kéz",
                "kézbe temetett arc",
                "nem hiszem el",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խոսքեր չկան"),
            keywords: &["անհանվատություն", "դեմք", "խոսքեր չկան", "ձեռքի ափ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang tepuk jidat"),
            keywords: &[
                "cape deh",
                "capedeh",
                "capek deh",
                "orang tepuk jidat",
                "tepuk jidat",
                "yah",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye na-ezo ihu ya èzo"),
            keywords: &[
                "e zoro",
                "ezo",
                "ihu",
                "n’ihi ihe ndakwasi",
                "onye na-ezo ihu ya èzo",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hönd fyrir andlit"),
            keywords: &["andlit", "hönd", "hönd fyrir andlit", "lófi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona esasperata"),
            keywords: &[
                "esasperazione",
                "facepalm",
                "incredulità",
                "mano in fronte",
                "persona esasperata",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ひたいに手をあてる人"),
            keywords: &[
                "あちゃー",
                "ひたいに手",
                "ひたいに手をあてる人",
                "ジェスチャー",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong anutup raine mawa dlamakan"),
            keywords: &[
                "dlamakan",
                "gumun",
                "mangkel",
                "rai",
                "wong anutup raine mawa dlamakan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახეზე ხელის აფარება"),
            keywords: &[
                "გაღიზიანება",
                "სახე",
                "სახეზე ხელის აფარება",
                "ურწმუნოება",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түңілгендік белгісі"),
            keywords: &["белгі", "түңілгендік", "түңілгендік белгісі"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("facepalm"),
            keywords: &[
                "ansigt",
                "dumt",
                "facepalm",
                "hånd",
                "håndflade",
                "irritation",
                "irriteret",
                "skepsis",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ"),
            keywords: &[
                "ខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ",
                "ធ\u{17bb}ញថប\u{17cb}",
                "បាតដៃ",
                "ម\u{17b7}នជឿ",
                "ម\u{17bb}ខ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಖಮಚ\u{ccd}ಚ\u{cbf}ಕೊಳ\u{ccd}ಳುವುದು"),
            keywords: &[
                "ಅಂಗೈ",
                "ಅಪನಂಬ\u{cbf}ಕ\u{cc6}",
                "ಕ\u{cc6}ರಳ\u{cbf}ಸುವುದು",
                "ಮುಖ",
                "ಮುಖಮಚ\u{ccd}ಚ\u{cbf}ಕೊಳ\u{ccd}ಳುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("골치 아파하는 사람"),
            keywords: &[
                "골치 아파하는 사람",
                "맙소사",
                "손바닥",
                "얼굴",
                "이럴 수가",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कपलाच\u{947}र हात मारपी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "अविस\u{94d}वास",
                "उत\u{94d}क\u{902}ठा",
                "कपलाच\u{947}र हात मारपी व\u{94d}यक\u{94d}ती",
                "तळहात",
                "म\u{941}खामळ",
                "व\u{94d}यक\u{94d}ती म\u{941}खामळाच\u{947}र हात धरता",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сөз жок ишараты"),
            keywords: &["алакан", "ачуулануу", "бет", "ишенбөө", "сөз жок ишараты"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun, déi sech d’Hand widder de Kapp schléit"),
            keywords: &[
                "Frust",
                "Gesiicht",
                "Hand",
                "Persoun, déi sech d’Hand widder de Kapp schléit",
                "Zweiwel",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb7}ກ\u{ec8}າຍໜ\u{ec9}າ"),
            keywords: &[
                "ບ\u{ecd}\u{ec8}ເຊ\u{eb7}\u{ec8}ອ",
                "ມ\u{eb7}",
                "ມ\u{eb7}ກ\u{ec8}າຍໜ\u{ec9}າ",
                "ໃຈຮ\u{ec9}າຍ",
                "ໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("o varge"),
            keywords: &[
                "beviltiškumas",
                "neįtikėtinumas",
                "o varge",
                "susierzinimas",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks ar saķertu galvu"),
            keywords: &[
                "cilvēks ar saķertu galvu",
                "neticība",
                "nu nopietni",
                "plauksta",
                "seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata ringakanohi"),
            keywords: &[
                "hohoia",
                "kanohi",
                "kapu o te ringa",
                "tangata ringakanohi",
                "whakaparau",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("неверување"),
            keywords: &["неверување", "разочарување", "чудење"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലയിൽ കൈവയ\u{d4d}ക\u{d4d}കൽ"),
            keywords: &[
                "അവിശ\u{d4d}വ\u{d3e}സം",
                "തലയിൽ കൈ",
                "തലയിൽ കൈവയ\u{d4d}ക\u{d4d}കൽ",
                "മ\u{d41}ഖം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүүр лүү алгадах"),
            keywords: &["алга", "нүүр", "нүүр лүү алгадах", "үл итгэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कपाळाला हात"),
            keywords: &[
                "अविश\u{94d}वास",
                "कपाळाला हात",
                "कपाळाला हात लावणारी व\u{94d}यक\u{94d}ती",
                "च\u{947}हरा",
                "तळहात",
                "स\u{902}ताप",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tepuk dahi"),
            keywords: &["dahi", "muka", "tak percaya", "tepuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna tagħmel facepalm"),
            keywords: &[
                "eżasperazzjoni",
                "ma jitwemminx",
                "pala",
                "persuna tagħmel facepalm",
                "wiċċ",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မျက\u{103a}န\u{103e}ာလက\u{103a}ဝါးဖြင\u{1037}\u{103a}အ\u{102f}ပ\u{103a}ထားသောရ\u{102f}ပ\u{103a}",
            ),
            keywords: &[
                "စ\u{102d}တ\u{103a}အန\u{103e}ောင\u{1037}\u{103a}အယ\u{103e}က\u{103a}ဖြစ\u{103a}နေသော",
                "မယ\u{102f}\u{1036}ကြည\u{103a}မ\u{103e}\u{102f}",
                "မျက\u{103a}န\u{103e}ာလက\u{103a}ဝါးဖြင\u{1037}\u{103a}အ\u{102f}ပ\u{103a}ထားသောရ\u{102f}ပ\u{103a}",
                "ရ\u{102f}ပ\u{103a}",
                "လက\u{103a}ဝါး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("slår hånden mot pannen"),
            keywords: &[
                "ansikt",
                "facepalm",
                "fjes",
                "irritasjon",
                "oppgitt",
                "slår hånden mot pannen",
                "vantro",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिन\u{94d}तित"),
            keywords: &[
                "अन\u{941}हार",
                "अविश\u{94d}वास",
                "उत\u{94d}त\u{947}जना",
                "चिन\u{94d}तित",
                "हत\u{94d}क\u{947}ला",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon die het gezicht met de hand bedekt"),
            keywords: &[
                "ergernis",
                "gezicht",
                "ongeloof",
                "palm",
                "persoon die het gezicht met de hand bedekt",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("slår handa mot panna"),
            keywords: &[
                "andlet",
                "facepalm",
                "fjes",
                "irritasjon",
                "oppgjeven",
                "slår handa mot panna",
                "vantru",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ମ\u{b41}ହ\u{b01}ରେ ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ମ\u{b3e}ର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅବ\u{b3f}ଶ\u{b4d}ୱ\u{b3e}ସ",
                "କ\u{b4d}ରୋଧ",
                "ପ\u{b3e}ପ\u{b41}ଲ\u{b3f}",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f} ମ\u{b41}ହ\u{b01}ରେ ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ମ\u{b3e}ର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉਫ ਹ\u{a4b}"),
            keywords: &[
                "ਉਫ ਹ\u{a4b}",
                "ਚਿਹਰਾ",
                "ਝ\u{a41}\u{a70}ਜਲਾਹਟ",
                "ਹਥ\u{a47}ਲੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ منہ اوتے رکھدا بندہ"),
            keywords: &[
                "اشتعال",
                "دی شکل",
                "ہتھ دا سیدھا رخ",
                "ہتھ منہ اوتے رکھدا بندہ",
                "یقین نہ ہونا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Ték Wọ\u{301}n Hand Kọ\u{301}vá Im Fes"),
            keywords: &[
                "Fes",
                "Hand",
                "Nọ\u{301} Fít Bílív Sọ\u{301}mtin",
                "Pẹ\u{301}sin Wé Ték Wọ\u{301}n Hand Kọ\u{301}vá Im Fes",
                "Vẹ\u{301}ks Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba trzymająca się za czoło"),
            keywords: &[
                "fejspalm",
                "niedowierzanie",
                "osoba trzymająca się za czoło",
                "załamanie",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص مخ ته لاس نيولي"),
            keywords: &[
                "بې زړه کيدل",
                "بې يقيني",
                "شخص مخ ته لاس نيولي",
                "شخص مخ ته لاس نيولی",
                "مخ ته لاس نيول",
                "ورغوی",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa decepcionada"),
            keywords: &[
                "decepção",
                "desapontamento",
                "pessoa dececionada",
                "pessoa decepcionada",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa de palma na face"),
            keywords: &[
                "exasperação",
                "face",
                "incredulidade",
                "palma",
                "pessoa de palma na face",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa makian uyapi"),
            keywords: &["chunta", "iñiynin", "runa makian uyapi", "tapuna", "uya"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană care își acoperă fața cu o palmă"),
            keywords: &[
                "exasperare",
                "față",
                "incredibil",
                "palmă",
                "persoană care își acoperă fața cu o palmă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1032"),
            keywords: &["E10-1032"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек потерял дар речи"),
            keywords: &[
                "лицо",
                "не могу поверить",
                "нет слов",
                "раздражение",
                "рука",
                "фейспалм",
                "человек потерял дар речи",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu wifash mu maso"),
            keywords: &[
                "isura",
                "mu kiganza",
                "uhangayitse",
                "ukutemera",
                "umuntu wifash mu maso",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص جو نراڙ تي هٿ ڏيڻ"),
            keywords: &["شخص جو نراڙ تي هٿ ڏيڻ", "نراڙ، هٿاري، بي اعتمادي، ڪاوڙ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd4}හ\u{dd4}ණේ අල\u{dca}ල ගස\u{dcf} ස\u{dd2}ට\u{dd3}ම"),
            keywords: &[
                "අල\u{dca}ල",
                "අව\u{dd2}ශ\u{dca}ව\u{dcf}සය",
                "බලවත\u{dca} කෝපය",
                "ම\u{dd4}හ\u{dd4}ණ",
                "ම\u{dd4}හ\u{dd4}ණේ අල\u{dca}ල ගස\u{dcf} ස\u{dd2}ට\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("človek chytajúci sa za hlavu"),
            keywords: &[
                "dlaň",
                "neviera",
                "tvár",
                "zúfalstvo",
                "človek",
                "človek chytajúci sa za hlavu",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba z dlanjo na obrazu"),
            keywords: &[
                "dvom",
                "nejevera",
                "oseba z dlanjo na obrazu",
                "skepsa",
                "skomigniti",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof calaacal waji saaranaya"),
            keywords: &[
                "aammin darro",
                "calaacal",
                "caro",
                "qof calaacal waji saaranaya",
                "qof waji calaacal saaranaya",
                "waji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fytyrë me pëllëmbë në ballë"),
            keywords: &[
                "fytyrë",
                "fytyrë me pëllëmbë në ballë",
                "mosbesim",
                "nervozizëm",
                "pëllëmbë në ballë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шака о чело"),
            keywords: &["глупост", "кајање", "чело", "шака о чело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šaka o čelo"),
            keywords: &["glupost", "kajanje", "čelo", "šaka o čelo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person som slår sig för pannan"),
            keywords: &[
                "ansikte",
                "frustration",
                "handflata",
                "irritation",
                "person som slår sig för pannan",
                "slå sig för pannan",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya kutoamini"),
            keywords: &["ishara ya kutoamini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விரக\u{bcd}தி"),
            keywords: &["ஏம\u{bbe}ற\u{bcd}றம\u{bcd}", "விரக\u{bcd}தி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తల క\u{c4a}ట\u{c4d}టుకుంటున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "అపనమ\u{c4d}మకం",
                "అర\u{c3f}చ\u{c47}య\u{c3f}",
                "ఉద\u{c4d}ర\u{c47}కం",
                "తల క\u{c4a}ట\u{c4d}టుకుంటున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "ముఖం",
                "ముఖంప\u{c48} చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахсе, ки рӯяшро бо дастонаш пӯшида истодааст"),
            keywords: &[
                "кафи даст",
                "нобоварӣ",
                "рӯй",
                "хашмгинӣ",
                "шахсе, ки рӯяшро бо дастонаш пӯшида истодааст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หมดก\u{e31}น"),
            keywords: &[
                "ผ\u{e34}ดหว\u{e31}ง",
                "ส\u{e34}\u{e49}นหว\u{e31}ง",
                "หมดก\u{e31}น",
                "เส\u{e35}ยใจ",
                "โธ\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini maňlaýyna urýan adam"),
            keywords: &[
                "aýa",
                "elini maňlaýyna urýan adam",
                "gyzmalyk",
                "ynanmazlyk",
                "ýüz",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha nima ʻihe mata"),
            keywords: &["tokotaha nima ʻihe mata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yüzünü eliyle kapama"),
            keywords: &[
                "avuç",
                "inanmama",
                "yüz",
                "yüzünü eliyle kapama",
                "çileden çıkma",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزىنى تۇتقان كىشى"),
            keywords: &["ئىشەنچسىز", "تۇتۇش", "يامان", "يۈزىنى تۇتقان كىشى", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина з долонею до обличчя"),
            keywords: &[
                "людина з долонею до обличчя",
                "людина, що підносить долоню до обличчя",
                "обличчя",
                "роздратування",
                "розчарування",
                "рука",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پیشانی پر ہاتھ"),
            keywords: &[
                "بے یقینی",
                "غصہ",
                "پیشانی",
                "پیشانی پر ہاتھ",
                "چہرہ",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("boshqa gapim yo‘q"),
            keywords: &[
                "boshqa gapim yo‘q",
                "gap yo‘q",
                "ishonchsizlik",
                "jahl chiqish",
                "qo‘l",
                "yuz",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người lấy tay che mặt"),
            keywords: &[
                "hoài nghi",
                "lòng bàn tay",
                "mặt",
                "người lấy tay che mặt",
                "tức giận",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ku taf loxo ci kanamam"),
            keywords: &[
                "gu jaaxle",
                "gëdofi",
                "kanam",
                "loxo",
                "nit ku taf loxo ci kanamam",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu ogqume ubuso ngezandla"),
            keywords: &[
                "intende yesandla",
                "ubuso",
                "ukungakholwa",
                "umntu ogqume ubuso ngezandla",
                "umsindo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹni Fọwọ Boju"),
            keywords: &[
                "ojú",
                "àtẹ\u{301}lẹ\u{301} ọwa",
                "àìgbàgbọ\u{301}",
                "ìkórira",
                "Ẹni Fọwọ Boju",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("用手遮臉嘅人"),
            keywords: &["唔相信", "嬲", "手掌", "用手遮臉嘅人", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("用手遮脸嘅人"),
            keywords: &["唔相信", "嬲", "手掌", "用手遮脸嘅人", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("捂脸"),
            keywords: &["捂脸", "无语", "难以置信"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("哦不"),
            keywords: &["不", "哦不", "怎麼會"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("遮住塊面"),
            keywords: &["不敢相信｜不相信", "遮住塊面", "遮住面"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuzifihla"),
            keywords: &[
                "intende yesandla",
                "ubuso",
                "ukucikeka",
                "ukungakholwa",
                "ukuzifihla",
            ],
        },
    ],
};
#[doc = "🤦🏻"]
pub const PERSON_FACEPALMING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏻",
    codepoint: "1F926 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "person facepalming: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤦🏼"]
pub const PERSON_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏼",
    codepoint: "1F926 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "person facepalming: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤦🏽"]
pub const PERSON_FACEPALMING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏽",
    codepoint: "1F926 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "person facepalming: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤦🏾"]
pub const PERSON_FACEPALMING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏾",
    codepoint: "1F926 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "person facepalming: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤦🏿"]
pub const PERSON_FACEPALMING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏿",
    codepoint: "1F926 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "person facepalming: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤦\u{200d}♂\u{fe0f}"]
pub const MAN_FACEPALMING: crate::Emoji = crate::Emoji {
    glyph: "🤦\u{200d}♂\u{fe0f}",
    codepoint: "1F926 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man facepalming",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦\u{200d}♂",
        codepoint: "1F926 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man facepalming",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man slaan hand teen voorkop"),
            keywords: &[
                "facepalm",
                "gsig",
                "hand teen voorkop slaan",
                "man",
                "man slaan hand teen voorkop",
                "moedeloos",
                "ongeloof",
                "palm",
                "verbyster",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ፊት መቅላት"),
            keywords: &["መደነቅ", "መዳፍ", "አለማመን", "ወንድ ፊት መቅላት", "ፊት መቅላት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل يشعر بإحباط"),
            keywords: &["إحباط", "رجل يشعر بإحباط", "صدمة", "عدم تصديق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}ৰত হ\u{9be}ত দিয\u{9bc}\u{9be} প\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "ক\u{9cd}ৰোধ",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "ম\u{9c1}খত হ\u{9be}ত দিয\u{9bc}\u{9be}",
                "ম\u{9c2}ৰত হ\u{9be}ত দিয\u{9bc}\u{9be} প\u{9c1}ৰ\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzünü tutan kişi"),
            keywords: &[
                "acıqlanma",
                "inamsızlıq",
                "kişi",
                "üzünü tutan kişi",
                "üzünü tutmaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына з далонню на твары"),
            keywords: &[
                "мужчына",
                "мужчына з далонню на твары",
                "не магу паверыць",
                "няма слоў",
                "рука",
                "фэйспалм",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж с ръка върху лицето"),
            keywords: &[
                "жест с ръка",
                "мъж с ръка върху лицето",
                "невярване",
                "отчаяние",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলেদের কপ\u{9be}লে হ\u{9be}ত"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "কপ\u{9be}লে হ\u{9be}ত",
                "ক\u{9cd}রোধ",
                "ছেলে",
                "ছেলেদের কপ\u{9be}লে হ\u{9be}ত",
                "প\u{9c1}র\u{9c1}ষ",
                "ম\u{9be}থ\u{9be}য\u{9bc} হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac s rukom na čelu"),
            keywords: &[
                "gestikulacija",
                "muškarac s rukom na čelu",
                "nevjerica",
                "ogorčenje",
                "razočaranje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home amb la mà a la cara"),
            keywords: &[
                "exasperació",
                "home",
                "home amb la mà a la cara",
                "incredulitat",
                "mà",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ"),
            keywords: &[
                "ᎠᏍᎦᏯ",
                "ᎠᏍᎦᏯ ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ",
                "ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ",
                "ᎤᎿᎸᎯ",
                "ᏄᏬᎯᏳᏒᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž chytající se za hlavu"),
            keywords: &[
                "chycení",
                "dlaň",
                "facepalm",
                "hlava",
                "muž",
                "muž chytající se za hlavu",
                "nevíra",
                "rozhořčení",
                "smajlík",
                "tvář",
                "výraz",
                "zoufalství",
                "čelo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn yn codi cledr i’w wyneb"),
            keywords: &[
                "anghoel",
                "cledr",
                "cythrudd",
                "dyn",
                "dyn yn codi cledr i’w wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand slår sig for panden"),
            keywords: &[
                "facepalm",
                "græmmes",
                "håndflade",
                "irritation",
                "irriteret",
                "mand",
                "mand slår sig for panden",
                "skepsis",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich an den Kopf fassender Mann"),
            keywords: &[
                "Mann",
                "frustriert",
                "genervt",
                "sich an den Kopf fassender Mann",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας αγανακτά"),
            keywords: &[
                "άντρας",
                "άντρας αγανακτά",
                "αγανάκτηση",
                "πρόσωπο",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man facepalming"),
            keywords: &[
                "disbelief",
                "exasperation",
                "facepalm",
                "man",
                "man facepalming",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre con la mano en la frente"),
            keywords: &[
                "facepalm",
                "frente",
                "hombre con la mano en la frente",
                "incredulidad",
                "mano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "exasperación",
                "facepalm",
                "hombre",
                "hombre con la mano en la frente",
                "incredulidad",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "exasperación",
                "frente",
                "hombre",
                "hombre con la mano en la frente",
                "incredulidad",
                "palma",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käega vastu pead lööv mees"),
            keywords: &[
                "käega vastu pead lööv mees",
                "meeleheide",
                "mees",
                "uskumatu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-azpia aurpegian duen gizona"),
            keywords: &[
                "esku-azpi",
                "esku-azpia aurpegian duen gizona",
                "gizon",
                "gizonezko",
                "sinesgaitasun",
                "sumindura",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد با کف دست به پیشانی می\u{200c}زند"),
            keywords: &[
                "افتضاح",
                "ای وای",
                "باورم نمی\u{200c}شود",
                "خجالت دارد",
                "مرد با کف دست به پیشانی می\u{200c}زند",
                "مرد مستأصل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvonsa kädellä peittävä mies"),
            keywords: &[
                "kasvonsa kädellä peittävä mies",
                "kasvot",
                "käsi",
                "mies",
                "pettymys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking naka-facepalm"),
            keywords: &["facepalm", "lalaki", "lalaking naka-facepalm", "palad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vónbrotin maður"),
            keywords: &[
                "facepalm",
                "maður",
                "persónur",
                "vónbrot",
                "vónbrotin maður",
                "ørkymlan",
                "ørkymlanfólk",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme avec la paume sur le visage"),
            keywords: &[
                "exaspération",
                "homme",
                "homme avec la paume sur le visage",
                "incrédulité",
                "paume",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("homme avec paume de la main sur le visage"),
            keywords: &[
                "exaspération",
                "homme",
                "homme avec paume de la main sur le visage",
                "incroyable",
                "main",
                "visage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear lena aghaidh ina bhos"),
            keywords: &[
                "aghaidh i mbos",
                "díchreideamh",
                "fear",
                "fear lena aghaidh i mbos",
                "fear lena aghaidh ina bhos",
                "fearann",
                "mearú",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine le aodann na làmhan"),
            keywords: &[
                "aodann",
                "duine",
                "duine le aodann na làmhan",
                "dì-chreideamh",
                "farranachadh",
                "fear",
                "fireannach",
                "làmh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home facendo xesto de incredulidade"),
            keywords: &[
                "exasperación",
                "fronte",
                "home",
                "home facendo xesto de incredulidade",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માથા ઉપર હાથ દ\u{ac7}તો પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "અવિશ\u{acd}વાસ",
                "પ\u{ac1}ર\u{ac1}ષ",
                "માથા ઉપર હાથ દ\u{ac7}તો પ\u{ac1}ર\u{ac1}ષ",
                "માથા ઉપર હાથ દ\u{ac7}વો",
                "રોષ",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji nunawa kunya"),
            keywords: &[
                "fushi",
                "namiji",
                "namiji nunawa kunya",
                "rashin imani",
                "tafin hannu na fuska",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר מתוסכל"),
            keywords: &["אין מצב", "איש", "גבר", "גבר מתוסכל", "לא מאמין", "תסכול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माथ\u{947} पर हाथ रखा ह\u{941}आ प\u{941}र\u{941}ष"),
            keywords: &[
                "अविश\u{94d}वास",
                "क\u{94d}रोध",
                "प\u{941}र\u{941}ष",
                "माथ\u{947} पर हाथ रखा ह\u{941}आ प\u{941}र\u{941}ष",
                "माथ\u{947} प\u{947} हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac lupa dlanom o čelo"),
            keywords: &[
                "dlan o čelo",
                "muškarac lupa dlanom o čelo",
                "nevjerica",
                "očaj",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arcát a kezébe temető férfi"),
            keywords: &[
                "arc",
                "arcát a kezébe temető férfi",
                "elkeseredés",
                "férfi",
                "hitetlenség",
                "kézbe temetett arc",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդը կորցրել է խոսելու ունակությունը"),
            keywords: &[
                "անհավատություն",
                "դեմք",
                "ձեռքի ափ",
                "տղամարդ",
                "տղամարդը կորցրել է խոսելու ունակությունը",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria tepuk jidat"),
            keywords: &[
                "isyarat",
                "jidat",
                "laki-laki",
                "pria tepuk jidat",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke na-ezo ihu ya èzo"),
            keywords: &[
                "e zoro ezo",
                "ekwenyeghị",
                "ihu",
                "nwoke",
                "nwoke na-ezo ihu ya èzo",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður með hönd fyrir andlit"),
            keywords: &[
                "andlit",
                "hönd",
                "karl",
                "lófi",
                "maður með hönd fyrir andlit",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo esasperato"),
            keywords: &[
                "esasperazione",
                "facepalm",
                "gesto",
                "uomo",
                "uomo esasperato",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ひたいに手をあてる男"),
            keywords: &[
                "あちゃー",
                "ひたいに手",
                "ひたいに手をあてる男",
                "ジェスチャー",
                "男",
                "男性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang anutup raine mawa dlamakan"),
            keywords: &[
                "dlamakan ing rai",
                "gumun",
                "mangkel",
                "wong lanang",
                "wong lanang anutup raine mawa dlamakan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახეზე ხელაფარებული კაცი"),
            keywords: &["კაცი", "ჟესტი", "სახეზე ხელაფარებული კაცი", "ხელის აფარება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айтуға сөз таппай тұрған ер"),
            keywords: &["айтуға сөз таппай тұрған ер", "долдану", "ер", "өкіну"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand slår sig for panden"),
            keywords: &[
                "facepalm",
                "græmmes",
                "håndflade",
                "irritation",
                "irriteret",
                "mand",
                "mand slår sig for panden",
                "skepsis",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ"),
            keywords: &[
                "ខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ",
                "ប\u{17bb}រសខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ",
                "ប\u{17d2}រ\u{17bb}ស",
                "ម\u{17b7}នជឿ",
                "ហ\u{17bd}សច\u{17b7}ត\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಖಮುಚ\u{ccd}ಚ\u{cbf}ಕೊಳ\u{ccd}ಳುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ"),
            keywords: &[
                "ನಂಬಲಸಾಧ\u{ccd}ಯ",
                "ಪುರುಷ",
                "ಮುಖ ಮುಚ\u{ccd}ಚು",
                "ಮುಖಮುಚ\u{ccd}ಚ\u{cbf}ಕೊಳ\u{ccd}ಳುತ\u{ccd}ತ\u{cbf}ರುವ ಪುರುಷ",
                "ಹತಾಶ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("골치 아파하는 남자"),
            keywords: &["골치 아파하는 남자", "맙소사", "이럴 수가", "이마에 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कपलाच\u{947}र हात मारपी दादलो"),
            keywords: &[
                "अविस\u{94d}वास",
                "उत\u{94d}क\u{902}ठा",
                "कपलाच\u{947}र हात मारपी दादलो",
                "तळहात कपलाच\u{947}र",
                "म\u{941}खामळाच\u{947}र हात धरपी दादलो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бетин кармаган эркек"),
            keywords: &[
                "бетин кармаган эркек",
                "бетин колу менен жабуу",
                "ишенбегендик",
                "кыжырдануу",
                "эркек",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann, deen sech d’Hand widder de Kapp schléit"),
            keywords: &[
                "Frust",
                "Mann",
                "Mann, deen sech d’Hand widder de Kapp schléit",
                "Zweiwel",
                "entsat",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເອ\u{ebb}າມ\u{eb7}ກ\u{ec8}າຍປ\u{eb4}ດໜ\u{ec9}າ"),
            keywords: &[
                "ຍອມໃຈ",
                "ບ\u{ecd}\u{ec8}ຢາກຈະເຊ\u{eb7}\u{ec8}ອ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເອ\u{ebb}າມ\u{eb7}ກ\u{ec8}າຍປ\u{eb4}ດໜ\u{ec9}າ",
                "ເຟສປາມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susierzinęs vyras"),
            keywords: &["netikėjimas", "susierzinimas", "susierzinęs vyras", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis ar saķertu galvu"),
            keywords: &[
                "aizkaitinājums",
                "nav vārdu",
                "roka",
                "vīrietis",
                "vīrietis ar saķertu galvu",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne ringakanohi"),
            keywords: &["hohoia", "ringakanohi", "tāne", "whakaparau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж и неверување"),
            keywords: &[
                "маж и неверување",
                "машко",
                "неверување",
                "разочарување",
                "чудење",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലയിൽ കൈവയ\u{d4d}ക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "അവിശ\u{d4d}വ\u{d3e}സം",
                "തലയിൽ കൈവയ\u{d4d}ക\u{d4d}ക\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "തലയിൽ കൈവയ\u{d4d}ക\u{d4d}കൽ",
                "പ\u{d41}ര\u{d41}ഷൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("урам хугарч буй эрэгтэй"),
            keywords: &[
                "гараараа нүүрээ дарах",
                "гараараа нүүрээ дарсан эрэгтэй",
                "урам хугарч буй эрэгтэй",
                "эгдүүцэх",
                "эрэгтэй",
                "үл итгэх",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कपाळाला हात लावल\u{947}ला प\u{941}र\u{941}ष"),
            keywords: &[
                "अविश\u{94d}वास",
                "कपाळाला हात लावणारा प\u{941}र\u{941}ष",
                "कपाळाला हात लावण\u{947}",
                "कपाळाला हात लावल\u{947}ला प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष",
                "स\u{902}ताप",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki menepuk muka"),
            keywords: &[
                "kejengkelan",
                "lelaki",
                "lelaki menepuk muka",
                "tepuk muka",
                "tidak percaya",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel jagħmel facepalming"),
            keywords: &[
                "eżasperazzjoni",
                "facepalm",
                "ma jitwemminx",
                "raġel",
                "raġel jagħmel facepalming",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "မ\u{102d}မ\u{102d}မျက\u{103a}န\u{103e}ာက\u{102d}\u{102f} လက\u{103a}ဝါးဖြင\u{1037}\u{103a}အ\u{102f}ပ\u{103a}ထားသော အမျ\u{102d}\u{102f}းသား",
            ),
            keywords: &[
                "မယ\u{102f}\u{1036}ကြည\u{103a}န\u{102d}\u{102f}င\u{103a}",
                "မ\u{102d}မ\u{102d}မျက\u{103a}န\u{103e}ာက\u{102d}\u{102f} လက\u{103a}ဝါးဖြင\u{1037}\u{103a}အ\u{102f}ပ\u{103a}ထားသော အမျ\u{102d}\u{102f}းသား",
                "မျက\u{103a}န\u{103e}ာအ\u{102f}ပ\u{103a}",
                "လက\u{103a}ဝါး",
                "အမျ\u{102d}\u{102f}းသား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann som slår hånden mot pannen"),
            keywords: &[
                "ansikt",
                "facepalm",
                "fjes",
                "irritasjon",
                "mann",
                "mann som slår hånden mot pannen",
                "oppgitt",
                "vantro",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिन\u{94d}तित छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "अविश\u{94d}वास",
                "चिन\u{94d}तित छोरामान\u{94d}छ\u{947}",
                "चिन\u{94d}तित म\u{941}द\u{94d}रा",
                "छोरीमान\u{94d}छ\u{947}",
                "महिला",
                "स\u{941}स\u{94d}क\u{947}रा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man die het gezicht met de hand bedekt"),
            keywords: &[
                "ergernis",
                "facepalm",
                "man",
                "man die het gezicht met de hand bedekt",
                "ongeloof",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann som slår handa mot panna"),
            keywords: &[
                "ansikt",
                "facepalm",
                "fjes",
                "irritasjon",
                "mann",
                "mann som slår handa mot panna",
                "oppgjeven",
                "vantru",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b41}ର\u{b41}ଷ ମ\u{b41}ହ\u{b01}ରେ ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ମ\u{b3e}ର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
            ),
            keywords: &[
                "ଅବ\u{b3f}ଶ\u{b4d}ୱ\u{b3e}ସ",
                "କ\u{b4d}ରୋଧ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ମ\u{b41}ହ\u{b01}ରେ ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ମ\u{b3e}ର\u{b41}ଛନ\u{b4d}ତ\u{b3f}",
                "ମ\u{b41}ହ\u{b01}ରେ ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ମ\u{b3e}ର\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a71}ਥ\u{a47} ’ਤ\u{a47} ਹ\u{a71}ਥ ਰ\u{a71}ਖਦਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਅਵਿਸ\u{a3c}ਵਾਸ",
                "ਝ\u{a41}\u{a70}ਜਲਾਹਟ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
                "ਮ\u{a71}ਥ\u{a47} ’ਤ\u{a47} ਹ\u{a71}ਥ ਰ\u{a71}ਖਣਾ",
                "ਮ\u{a71}ਥ\u{a47} ’ਤ\u{a47} ਹ\u{a71}ਥ ਰ\u{a71}ਖਦਾ ਪ\u{a41}ਰਸ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ اوتے ہتھ رکھدا بندہ"),
            keywords: &[
                "اشتعال",
                "بندہ",
                "منہ اوتے ہتھ رکھدا بندہ",
                "منہ اوتے ہتھ رکھنا",
                "یقین نہ ہونا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé Ték Wọ\u{301}n Hand Kọ\u{301}vá Im Fes"),
            keywords: &[
                "Man",
                "Man Wé Ték Wọ\u{301}n Hand Kọ\u{301}vá Im Fes",
                "Nọ\u{301} Fít Bílív Sọ\u{301}mtin",
                "To Ték Wọ\u{301}n Hand Kọ\u{301}vá Yọ Fes",
                "Vẹ\u{301}ks Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna trzymający się za czoło"),
            keywords: &[
                "brak słów",
                "facepalm",
                "mężczyzna",
                "mężczyzna trzymający się za czoło",
                "niedowierzanie",
                "załamka",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړي مخ ته لاس نيولی"),
            keywords: &[
                "بې زړه کيدل",
                "بې يقيني",
                "سړي مخ ته لاس نيولی",
                "سړی",
                "مخ ته لاس نيول",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem decepcionado"),
            keywords: &["decepção", "desapontamento", "homem", "homem decepcionado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem de palma na face"),
            keywords: &[
                "descrença",
                "exaspero",
                "homem",
                "homem de palma na face",
                "mão na cara",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata makiwan uyapi"),
            keywords: &[
                "iñiynin",
                "maki t’aqlla",
                "tapuna",
                "tata",
                "tata makiwan uyapi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat care își acoperă fața cu o palmă"),
            keywords: &[
                "bărbat",
                "bărbat care își acoperă fața cu o palmă",
                "exasperare",
                "incredibil",
                "palmă peste față",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1231"),
            keywords: &["E10-1231"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина потерял дар речи"),
            keywords: &[
                "лицо",
                "мужчина потерял дар речи",
                "не могу поверить",
                "нет слов",
                "раздражение",
                "рука",
                "фейспалм",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo ushyize ikiganza mu maso"),
            keywords: &[
                "facepalm",
                "man",
                "uhangayitse",
                "ukutemera",
                "umugabo ushyize ikiganza mu maso",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو جو نراڙ تي هٿ ڏيڻ"),
            keywords: &[
                "بي اعتمادي، ڪاوڙ، نراڙ تي هٿ، مرد",
                "ماڻهو جو نراڙ تي هٿ ڏيڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ම\u{dd4}හ\u{dd4}ණේ අල\u{dca}ල ගස\u{dcf} ස\u{dd2}ට\u{dd2}න ම\u{dd2}න\u{dd2}ස\u{dcf}",
            ),
            keywords: &[
                "අව\u{dd2}ශ\u{dca}ව\u{dcf}සය",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}ය\u{dcf}",
                "බලවත\u{dca} කෝපය",
                "ම\u{dd4}හ\u{dd4}ණේ අල\u{dca}ල ගස\u{dcf} ස\u{dd2}ට\u{dd2}න ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "ම\u{dd4}හ\u{dd4}ණේ අල\u{dca}ල ගස\u{dcf} ස\u{dd2}ට\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž chytajúci sa za hlavu"),
            keywords: &[
                "dlaň",
                "muž",
                "muž chytajúci sa za hlavu",
                "neviera",
                "tvár",
                "zúfalstvo",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški, ki obraz prekriva z dlanjo"),
            keywords: &[
                "dvom",
                "facepalm",
                "fant",
                "moški",
                "moški, ki obraz prekriva z dlanjo",
                "obup",
                "ogorčenje",
                "prekriti obraz z dlanjo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin calaacal waji saaranaya"),
            keywords: &[
                "aammin darro",
                "calaacal waji saaris",
                "caro",
                "nin calaacal waji saaranaya",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë që vë dorën në kokë"),
            keywords: &[
                "burrë",
                "burrë që vë dorën në kokë",
                "mosbesim",
                "pëllëmbë në ballë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац с руком на челу"),
            keywords: &[
                "гестикулација",
                "глупост",
                "кајање",
                "мушкарац",
                "мушкарац с руком на челу",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac s rukom na čelu"),
            keywords: &[
                "gestikulacija",
                "glupost",
                "kajanje",
                "muškarac",
                "muškarac s rukom na čelu",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man som slår sig för pannan"),
            keywords: &[
                "facepalm",
                "frustration",
                "irritation",
                "man",
                "man som slår sig för pannan",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume anayeashiria kutoamini"),
            keywords: &["ishara", "kutoamini", "mwanamume anayeashiria kutoamini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("விரக\u{bcd}தியடைந\u{bcd}த ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "ஏம\u{bbe}ற\u{bcd}றம\u{bcd}",
                "விரக\u{bcd}தி",
                "விரக\u{bcd}தியடைந\u{bcd}த ஆண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("తల క\u{c4a}ట\u{c4d}టుకుంటున\u{c4d}న పురుషుడు"),
            keywords: &[
                "అపనమ\u{c4d}మకం",
                "తల క\u{c4a}ట\u{c4d}టుకుంటున\u{c4d}న పురుషుడు",
                "తల క\u{c4a}ట\u{c4d}టుక\u{c4b}వడం",
                "పురుషుడు",
                "మగ\u{c3e}డు",
                "వ\u{c47}ధ\u{c3f}ంపు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марде, ки рӯяшро бо дастонаш пӯшида истодааст"),
            keywords: &[
                "мард",
                "марде, ки рӯяшро бо дастонаш пӯшида истодааст",
                "нобоварӣ",
                "пӯшидани рӯй бо дастон",
                "хашмгинӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายเอาม\u{e37}อก\u{e48}ายหน\u{e49}าผาก"),
            keywords: &[
                "ผ\u{e34}ดหว\u{e31}ง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายเอาม\u{e37}อก\u{e48}ายหน\u{e49}าผาก",
                "ม\u{e37}อก\u{e48}ายหน\u{e49}าผาก",
                "ไม\u{e48}เช\u{e37}\u{e48}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elini maňlaýyna urýan erkek"),
            keywords: &[
                "aýasy bilen ýüzüne urmak",
                "elini maňlaýyna urýan erkek",
                "erkek",
                "gyzmalyk",
                "ynanmazlyk",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata nima ʻihe mata"),
            keywords: &["tangata nima ʻihe mata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eliyle yüzünü kapatan erkek"),
            keywords: &[
                "adam",
                "eliyle yüzünü kapatan erkek",
                "erkek",
                "inanmama",
                "utancından eliyle yüzünü kapatma",
                "çileden çıkma",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يۈزىنى تۇتقان ئەر"),
            keywords: &[
                "ئىشەنچسىز",
                "ئەر",
                "يامان",
                "يۈزىنى تۇتش",
                "يۈزىنى تۇتقان ئەر",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік із долонею до обличчя"),
            keywords: &[
                "рука",
                "сором",
                "фейспалм",
                "чоловік",
                "чоловік із долонею до обличчя",
                "чоловік, що підносить долоню до обличчя",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شرمندگی ظاہر کرتا ہوا مرد"),
            keywords: &[
                "بے یقینی",
                "شرمندگی",
                "شرمندگی ظاہر کرتا ہوا مرد",
                "مرد",
                "پیشانی",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak yuzini berkitmoqda"),
            keywords: &[
                "achchiqlanish",
                "erkak",
                "erkak yuzini berkitmoqda",
                "feyspalm",
                "ishonmaslik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông lấy tay che mặt"),
            keywords: &[
                "hoài nghi",
                "nam",
                "người lấy tay che mặt",
                "người đàn ông lấy tay che mặt",
                "tay che mặt",
                "tức giận",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor gu taf loxo ci kanamam"),
            keywords: &[
                "góor",
                "góor gu taf loxo ci kanamam",
                "jaaxle",
                "kanam",
                "loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda egqume ubuso ngezandla"),
            keywords: &[
                "indoda",
                "indoda egqume ubuso ngezandla",
                "ukugquma ubuso ngesandla",
                "ukungakholwa",
                "umsindo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin tín fọwọ\u{301}bojú"),
            keywords: &[
                "fọwọ\u{301}bojú",
                "okùnrin",
                "àìgbàgbọ\u{301}",
                "ìkórira",
                "ọkùnrin tín fọwọ\u{301}bojú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("用手遮臉嘅男人"),
            keywords: &["唔相信", "嬲", "手掌遮臉", "用手遮臉嘅男人", "男"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("用手遮脸嘅男人"),
            keywords: &["唔相信", "嬲", "手掌遮脸", "用手遮脸嘅男人", "男"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男生捂脸"),
            keywords: &["无语", "男", "男生捂脸", "难以置信"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男生遮臉"),
            keywords: &["捂臉", "無語", "男", "男生遮臉", "難以置信"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("遮住面嘅男人"),
            keywords: &["不敢相信｜不相信｜男", "遮住面", "遮住面嘅男人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuzifihla kowesilisa"),
            keywords: &[
                "intende yesandla",
                "ubuso",
                "ukucikeka",
                "ukungakholwa",
                "ukuzifihla kowesilisa",
            ],
        },
    ],
};
#[doc = "🤦🏻\u{200d}♂\u{fe0f}"]
pub const MAN_FACEPALMING_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F926 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man facepalming: light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦🏻\u{200d}♂",
        codepoint: "1F926 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man facepalming: light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🤦🏼\u{200d}♂\u{fe0f}"]
pub const MAN_FACEPALMING_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F926 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man facepalming: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦🏼\u{200d}♂",
        codepoint: "1F926 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man facepalming: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🤦🏽\u{200d}♂\u{fe0f}"]
pub const MAN_FACEPALMING_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F926 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man facepalming: medium skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦🏽\u{200d}♂",
        codepoint: "1F926 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man facepalming: medium skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🤦🏾\u{200d}♂\u{fe0f}"]
pub const MAN_FACEPALMING_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F926 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man facepalming: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦🏾\u{200d}♂",
        codepoint: "1F926 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man facepalming: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🤦🏿\u{200d}♂\u{fe0f}"]
pub const MAN_FACEPALMING_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤦🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F926 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man facepalming: dark skin tone",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦🏿\u{200d}♂",
        codepoint: "1F926 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man facepalming: dark skin tone",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🤦\u{200d}♀\u{fe0f}"]
pub const WOMAN_FACEPALMING: crate::Emoji = crate::Emoji {
    glyph: "🤦\u{200d}♀\u{fe0f}",
    codepoint: "1F926 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman facepalming",
    group: "People & Body",
    subgroup: "person-gesture",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🤦\u{200d}♀",
        codepoint: "1F926 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman facepalming",
        group: "People & Body",
        subgroup: "person-gesture",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou slaan hand teen voorkop"),
            keywords: &[
                "facepalm",
                "gsig",
                "hand teen voorkop slaan",
                "moedeloos",
                "ongeloof",
                "palm",
                "verbyster",
                "vrou",
                "vrou slaan hand teen voorkop",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ፊት መቅላት"),
            keywords: &["መደነቅ", "መዳፍ", "ሴት", "ሴት ፊት መቅላት", "አለማመን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة تشعر بإحباط"),
            keywords: &["إحباط", "سيدة تشعر بإحباط", "صدمة", "عدم تصديق"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c2}ৰত হ\u{9be}ত দি থক\u{9be} মহিল\u{9be}"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "ক\u{9cd}ৰোধ",
                "ফেচপ\u{9be}ম",
                "মহিল\u{9be}",
                "ম\u{9c2}ৰত হ\u{9be}ত দি থক\u{9be} মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("üzünü tutan qadın"),
            keywords: &[
                "acıqlanma",
                "inamsızlıq",
                "qadın",
                "üzünü tutan qadın",
                "üzünü tutmaq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына з далонню на твары"),
            keywords: &[
                "жанчына",
                "жанчына з далонню на твары",
                "не магу паверыць",
                "няма слоў",
                "рука",
                "фэйспалм",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена с ръка върху лицето"),
            keywords: &[
                "жена с ръка върху лицето",
                "жест с ръка",
                "невярване",
                "отчаяние",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}েদের কপ\u{9be}লে হ\u{9be}ত"),
            keywords: &[
                "অবিশ\u{9cd}ব\u{9be}স",
                "কপ\u{9be}লে হ\u{9be}ত",
                "ক\u{9cd}রোধ",
                "মহিল\u{9be}",
                "ম\u{9be}থ\u{9be}য\u{9bc} হ\u{9be}ত",
                "মেয\u{9bc}ে",
                "মেয\u{9bc}েদের কপ\u{9be}লে হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena s rukom na čelu"),
            keywords: &[
                "gestikulacija",
                "nevjerica",
                "ogorčenje",
                "razočaranje",
                "žena s rukom na čelu",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona amb la mà a la cara"),
            keywords: &[
                "dona",
                "dona amb la mà a la cara",
                "exasperació",
                "incredulitat",
                "mà",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ",
                "ᎤᎧᏛᎢ ᎠᏓᏏᏔᏗᏍᎬᎢ",
                "ᎤᎿᎸᎯ",
                "ᏄᏬᎯᏳᏒᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena chytající se za hlavu"),
            keywords: &[
                "chycení",
                "dlaň",
                "facepalm",
                "hlava",
                "nevíra",
                "rozhořčení",
                "smajlík",
                "tvář",
                "výraz",
                "zoufalství",
                "čelo",
                "žena",
                "žena chytající se za hlavu",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw yn codi cledr i’w wyneb"),
            keywords: &[
                "anghoel",
                "cledr",
                "cythrudd",
                "menyw",
                "menyw yn codi cledr i’w wyneb",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde slår sig for panden"),
            keywords: &[
                "facepalm",
                "græmmes",
                "håndflade",
                "irritation",
                "irriteret",
                "kvinde",
                "kvinde slår sig for panden",
                "skepsis",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("sich an den Kopf fassende Frau"),
            keywords: &[
                "Frau",
                "frustriert",
                "genervt",
                "sich an den Kopf fassende Frau",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα αγανακτά"),
            keywords: &[
                "αγανάκτηση",
                "γυναίκα",
                "γυναίκα αγανακτά",
                "πρόσωπο",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman facepalming"),
            keywords: &[
                "disbelief",
                "exasperation",
                "facepalm",
                "woman",
                "woman facepalming",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer con la mano en la frente"),
            keywords: &[
                "facepalm",
                "frente",
                "incredulidad",
                "mano",
                "mujer con la mano en la frente",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "exasperación",
                "facepalm",
                "incredulidad",
                "mujer",
                "mujer con la mano en la frente",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "exasperación",
                "frente",
                "incredulidad",
                "mujer",
                "mujer con la mano en la frente",
                "palma",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käega vastu pead lööv naine"),
            keywords: &[
                "käega vastu pead lööv naine",
                "meeleheide",
                "naine",
                "uskumatu",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-azpia aurpegian duen emakumea"),
            keywords: &[
                "emakume",
                "emakumezko",
                "esku-azpi",
                "esku-azpia aurpegian duen emakumea",
                "sinesgaitasun",
                "sumindura",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن با کف دست به پیشانی می\u{200c}زند"),
            keywords: &[
                "افتضاح",
                "ای وای",
                "باورم نمی\u{200c}شود",
                "خجالت دارد",
                "زن با کف دست به پیشانی می\u{200c}زند",
                "زن مستأصل",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kasvonsa kädellä peittävä nainen"),
            keywords: &[
                "kasvonsa kädellä peittävä nainen",
                "kasvot",
                "käsi",
                "nainen",
                "pettymys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng naka-facepalm"),
            keywords: &["babae", "babaeng naka-facepalm", "facepalm", "palad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vónbrotin kvinna"),
            keywords: &[
                "facepalm",
                "kona",
                "kvinna",
                "persónur",
                "vónbrot",
                "vónbrotin kvinna",
                "ørkymlan",
                "ørkymlanfólk",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme avec la paume sur le visage"),
            keywords: &[
                "exaspération",
                "femme",
                "femme avec la paume sur le visage",
                "incrédulité",
                "paume",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("femme avec paume de la main sur le visage"),
            keywords: &[
                "exaspération",
                "femme",
                "femme avec paume de la main sur le visage",
                "incroyable",
                "main",
                "visage",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean lena haghaidh ina bos"),
            keywords: &[
                "aghaidh i mbos",
                "baineann",
                "bean",
                "bean lena haghaidh i mbos",
                "bean lena haghaidh ina bos",
                "díchreideamh",
                "mearú",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach le aodann na làmhan"),
            keywords: &[
                "aodann",
                "boireannach",
                "boireannach le aodann na làmhan",
                "dì-chreideamh",
                "farranachadh",
                "làmh",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller facendo xesto de incredulidade"),
            keywords: &[
                "exasperación",
                "fronte",
                "muller",
                "muller facendo xesto de incredulidade",
                "xesto",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("માથા ઉપર હાથ દ\u{ac7}તી સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "અવિશ\u{acd}વાસ",
                "માથા ઉપર હાથ દ\u{ac7}તી સ\u{acd}ત\u{acd}રી",
                "માથા ઉપર હાથ દ\u{ac7}વો",
                "રોષ",
                "સ\u{acd}ત\u{acd}રી",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace nunawa kunya"),
            keywords: &[
                "fushi",
                "mace",
                "mace nunawa kunya",
                "rashin imani",
                "tafin hannu na fuska",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה מתוסכלת"),
            keywords: &["אין מצב", "אישה", "אישה מתוסכלת", "לא מאמינה", "תסכול"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("माथ\u{947} पर हाथ रखी ह\u{941}ई महिला"),
            keywords: &[
                "अविश\u{94d}वास",
                "क\u{94d}रोध",
                "महिला",
                "माथ\u{947} पर हाथ रखी ह\u{941}ई महिला",
                "माथ\u{947} प\u{947} हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena lupa dlanom o čelo"),
            keywords: &[
                "dlan o čelo",
                "nevjerica",
                "očaj",
                "žena lupa dlanom o čelo",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("arcát a kezébe temető nő"),
            keywords: &[
                "arc",
                "arcát a kezébe temető nő",
                "elkeseredés",
                "hitetlenség",
                "kézbe temetett arc",
                "nő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կինը կորցրել է խոսելու ունակությունը"),
            keywords: &[
                "անհավատություն",
                "դեմք",
                "կին",
                "կինը կորցրել է խոսելու ունակությունը",
                "ձեռքի ափ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita tepuk jidat"),
            keywords: &[
                "isyarat",
                "jidat",
                "perempuan",
                "tangan",
                "wanita tepuk jidat",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị na-ezo ihu ya èzo"),
            keywords: &[
                "e zoro ezo",
                "ekwenyeghị",
                "ihu",
                "nwanyị",
                "nwanyị na-ezo ihu ya èzo",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona með hönd fyrir andlit"),
            keywords: &[
                "andlit",
                "hönd",
                "kona",
                "kona með hönd fyrir andlit",
                "lófi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna esasperata"),
            keywords: &[
                "donna",
                "donna esasperata",
                "esasperazione",
                "facepalm",
                "gesto",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ひたいに手をあてる女"),
            keywords: &[
                "あちゃー",
                "ひたいに手",
                "ひたいに手をあてる女",
                "ジェスチャー",
                "女",
                "女性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon anutup raine mawa dlamakan"),
            keywords: &[
                "dlamakan ing rai",
                "gumun",
                "mangkel",
                "wong wadon",
                "wong wadon anutup raine mawa dlamakan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სახეზე ხელაფარებული ქალი"),
            keywords: &["ჟესტი", "სახეზე ხელაფარებული ქალი", "ქალი", "ხელის აფარება"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("айтуға сөз таппай тұрған әйел"),
            keywords: &["айтуға сөз таппай тұрған әйел", "долдану", "әйел", "өкіну"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde slår sig for panden"),
            keywords: &[
                "facepalm",
                "græmmes",
                "håndflade",
                "irritation",
                "irriteret",
                "kvinde",
                "kvinde slår sig for panden",
                "skepsis",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}ខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ"),
            keywords: &[
                "ខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ",
                "នារ\u{17b8}ខ\u{17d2}ទប\u{17cb}ម\u{17bb}ខ",
                "ម\u{17b7}នជឿ",
                "ស\u{17d2}រ\u{17b8}",
                "ហ\u{17bd}សច\u{17b7}ត\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಖಮುಚ\u{ccd}ಚ\u{cbf}ಕೊಳ\u{ccd}ಳುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ"),
            keywords: &[
                "ನಂಬಲಸಾಧ\u{ccd}ಯ",
                "ಮುಖ ಮುಚ\u{ccd}ಚು",
                "ಮುಖಮುಚ\u{ccd}ಚ\u{cbf}ಕೊಳ\u{ccd}ಳುತ\u{ccd}ತ\u{cbf}ರುವ ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಹತಾಶ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("골치 아파하는 여자"),
            keywords: &["골치 아파하는 여자", "맙소사", "이럴 수가", "이마에 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कपलाच\u{947}र हात मारपी बायल"),
            keywords: &[
                "अविस\u{94d}वास",
                "उत\u{94d}क\u{902}ठा",
                "कपलाच\u{947}र हात मारपी बायल",
                "तळहात कपलाच\u{947}र",
                "म\u{941}खामळाच\u{947}र हात धरपी बायल",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бетин кармаган аял"),
            keywords: &[
                "аял",
                "бетин кармаган аял",
                "бетин колу менен жабуу",
                "ишенбегендик",
                "кыжырдануу",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra, déi sech d’Hand widder de Kapp schléit"),
            keywords: &[
                "Fra",
                "Fra, déi sech d’Hand widder de Kapp schléit",
                "Frust",
                "Zweiwel",
                "entsat",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເອ\u{ebb}າມ\u{eb7}ກ\u{ec8}າຍປ\u{eb4}ດໜ\u{ec9}າ"),
            keywords: &[
                "ຍອມໃຈ",
                "ບ\u{ecd}\u{ec8}ຢາກຈະເຊ\u{eb7}\u{ec8}ອ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງເອ\u{ebb}າມ\u{eb7}ກ\u{ec8}າຍປ\u{eb4}ດໜ\u{ec9}າ",
                "ເຟສປາມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("susierzinusi moteris"),
            keywords: &[
                "moteris",
                "netikėjimas",
                "susierzinimas",
                "susierzinusi moteris",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete ar saķertu galvu"),
            keywords: &[
                "aizkaitinājums",
                "nav vārdu",
                "roka",
                "sieviete",
                "sieviete ar saķertu galvu",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine ringakanohi"),
            keywords: &["hohoia", "ringakanohi", "wahine", "whakaparau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена и неверување"),
            keywords: &[
                "жена и неверување",
                "женско",
                "неверување",
                "разочарување",
                "чудење",
            ],