#[doc = "👼"]
pub const BABY_ANGEL: crate::Emoji = crate::Emoji {
    glyph: "👼",
    codepoint: "1F47C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "baby angel",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("baba-engel"),
            keywords: &[
                "baba",
                "baba-engel",
                "engel",
                "fantasie",
                "gesig",
                "sprokie",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሕፃኑ መልዓክ"),
            keywords: &["ሕፃኑ መልዓክ", "ሕፃን", "መልዓክ", "ምናባዊ", "ተረት ተረት", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طفل ملاك"),
            keywords: &["حدوتة", "طفل ملاك", "ملاك", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিশ\u{9c1} দেৱদ\u{9c2}ত"),
            keywords: &[
                "কল\u{9cd}পন\u{9be}",
                "দেৱদ\u{9c2}ত",
                "পৰীৰ স\u{9be}ধ\u{9c1}",
                "ম\u{9c1}খ",
                "শিশ\u{9c1}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("körpə mələk"),
            keywords: &["fantastika", "körpə", "mələk", "nağıl", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("анёлак"),
            keywords: &["анёл", "анёлак", "дзіця", "казачны", "німб"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ангелче"),
            keywords: &["ангел", "ангелче", "бебе", "лице", "приказка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিশ\u{9c1} অ\u{9cd}য\u{9be}ঞ\u{9cd}জেল"),
            keywords: &[
                "কল\u{9cd}পন\u{9be}",
                "দেবদ\u{9c2}ত",
                "ম\u{9c1}খ",
                "র\u{9c2}পকথ\u{9be}",
                "শিশ\u{9c1} অ\u{9cd}য\u{9be}ঞ\u{9cd}জেল",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("babig ael"),
            keywords: &["ael", "babig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("anđelak"),
            keywords: &["anđelak", "anđeo", "bajka", "beba", "fantazija"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("angelet"),
            keywords: &["ales", "angelet", "bebè", "fantasia", "àngel"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ ᏗᎧᎿᏩᏗᏙᎯ"),
            keywords: &[
                "ᎠᏓᏪᎯ ᎧᏃᎮᏓ",
                "ᎤᎧᏛ",
                "ᎤᏍᏗ",
                "ᎤᏍᏗ ᏗᎧᎿᏩᏗᏙᎯ",
                "ᎰᏩ ᏂᎨᏒᎾ",
                "ᏗᎧᏅᏩᏗᏙᎯ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("andílek"),
            keywords: &[
                "andílek", "anděl", "dítě", "fantasy", "pohádka", "smajlík", "tvář", "výraz",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("babi angel"),
            keywords: &["angel", "babi", "ffantasi", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("babyengel"),
            keywords: &["babyengel", "engel"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Putte"),
            keywords: &["Engel", "Gesicht", "Märchen", "Putte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μωρό άγγελος"),
            keywords: &["άγγελος", "μωρό", "παραμύθι", "πρόσωπο", "φαντασία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baby angel"),
            keywords: &["angel", "baby", "face", "fairy tale", "fantasy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bebé ángel"),
            keywords: &["bebé", "cara", "cuento", "ángel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("cara de ángel bebé"),
            keywords: &["bebé", "cara", "cara de ángel bebé", "cuento", "ángel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "bebé",
                "cara",
                "cara de ángel bebé",
                "cuento de hadas",
                "fantasía",
                "ángel",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("inglibeebi"),
            keywords: &[
                "ingel",
                "inglibeebi",
                "inglilaps",
                "laps",
                "lapsenägu",
                "muinasjutt",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aingeru-itxura duen haurtxoa"),
            keywords: &[
                "aingeru-itxura duen haurtxoa",
                "aingerua",
                "aurpegia",
                "fantasia",
                "haurtxoa",
                "ipuina",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("فرشته کوچولو"),
            keywords: &[
                "بچه",
                "صورت",
                "فانتزی",
                "فرشته",
                "فرشته کوچولو",
                "پری",
                "کودک",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("enkelivauva"),
            keywords: &[
                "enkeli",
                "enkelivauva",
                "fantasia",
                "naama",
                "satu",
                "vauva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sanggol na anghel"),
            keywords: &[
                "angel",
                "anghel",
                "baby",
                "fantasy",
                "mukha",
                "sanggol",
                "sanggol na anghel",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pinkabarnaeingil"),
            keywords: &[
                "andlit",
                "eingil",
                "pinkabarnaeingil",
                "pinkubarn",
                "trúgv",
                "ævintýr",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bébé ange"),
            keywords: &["ange", "bébé", "fantastique", "visage"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aingeal óg"),
            keywords: &["aingeal", "aingeal óg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("aingeal òg"),
            keywords: &[
                "aingeal",
                "aingeal òg",
                "aodann",
                "fantastach",
                "faoinsgeul",
                "leanabh",
                "naoidhean",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("anxiño"),
            keywords: &["anxiño", "anxo", "bebé"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાળ દ\u{ac7}વદ\u{ac2}ત"),
            keywords: &[
                "ચહ\u{ac7}રો",
                "દ\u{ac7}વદ\u{ac2}ત",
                "પરી કથા",
                "બાળ દ\u{ac7}વદ\u{ac2}ત",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jaririn malaika"),
            keywords: &[
                "fuska",
                "jariri",
                "jaririn malaika",
                "labarin aljana",
                "malaika",
                "tatsuniya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מלאך תינוק"),
            keywords: &["אגדה", "מלאך", "פנטסיה", "תינוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नन\u{94d}ही परी"),
            keywords: &[
                "च\u{947}हरा",
                "नन\u{94d}ही परी",
                "नन\u{94d}ही\u{902} परी",
                "परी",
                "फ\u{948}\u{902}ट\u{947}सी",
                "बच\u{94d}ची",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("beba anđeo"),
            keywords: &["anđeo", "bajka", "beba", "lice", "mašta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("babaangyal"),
            keywords: &["angyal", "arc", "baba", "babaangyal", "mese"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանուկ-հրեշտակ"),
            keywords: &[
                "դեմք",
                "երեխա",
                "հեքիաթ",
                "հրեշտակ",
                "մանուկ-հրեշտակ",
                "ֆանտազիա",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("malaikat bayi"),
            keywords: &["bayi", "dongeng", "fantasi", "malaikat", "muka", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mụo ọma nwata ọhụrụ"),
            keywords: &[
                "akarọakọ",
                "arọrarọ",
                "ihu",
                "mmụọ ọma",
                "mụo ọma nwata ọhụrụ",
                "nwata ọhụrụ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("barnsengill"),
            keywords: &["andlit", "barnsengill", "engill", "ævintýri"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("angioletto"),
            keywords: &["angelo", "angioletto", "faccina", "favola"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("天使"),
            keywords: &["エンジェル", "天使", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("malaékat bayi"),
            keywords: &["bayi", "dongeng", "fantasi", "malaékat", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბავშვი ანგელოზი"),
            keywords: &[
                "ანგელოზი",
                "ბავშვი",
                "ზღაპარი",
                "სახე",
                "ფანტაზია",
                "ფანტასტიკა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("кішкентай періште"),
            keywords: &[
                "бет",
                "ертегі",
                "кішкентай періште",
                "періште",
                "сәби",
                "қиял",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("babyengel"),
            keywords: &["babyengel", "engel"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទេពធ\u{17b8}តាត\u{17bc}ច"),
            keywords: &[
                "ទេពធ\u{17b8}តា",
                "ទេពធ\u{17b8}តាត\u{17bc}ច",
                "ម\u{17bb}ខទេពធ\u{17b8}តាត\u{17bc}ច",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{cbf}ಶು ದೇವತ\u{cc6}"),
            keywords: &["ದೇವತ\u{cc6}", "ಶ\u{cbf}ಶು ದೇವತ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아기 천사"),
            keywords: &["아기 천사", "천사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बाल परी"),
            keywords: &["च\u{947}रो", "नवलकथा", "परी", "परी कथा", "बाल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бала периште"),
            keywords: &["бала", "бет", "жомок", "периште", "фантастика"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Engelchen"),
            keywords: &[
                "Bëbee",
                "Engel",
                "Engelchen",
                "Fantasie",
                "Gesiicht",
                "Mäerchen",
                "Puppelchen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນາງຟ\u{ec9}າເດ\u{eb1}ກ"),
            keywords: &["ນາງຟ\u{ec9}າ", "ນາງຟ\u{ec9}າເດ\u{eb1}ກ", "ເທບນ\u{eb4}ຍາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("angeliukas"),
            keywords: &[
                "angelas",
                "angeliukas",
                "fantazija",
                "kūdikis",
                "pasaka",
                "veidas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mazs eņģelītis"),
            keywords: &[
                "eņģelis",
                "fantāzija",
                "mazs eņģelītis",
                "mazulis",
                "pasaka",
                "seja",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pīpī anahera"),
            keywords: &[
                "anahera",
                "kanohi",
                "kōrero pakiwaitara",
                "moemoeā",
                "pēpi",
                "pīpī anahera",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бебе ангел"),
            keywords: &["ангел", "бебе", "насмевка", "невиност", "ореол"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ഞ\u{d4d}ഞ\u{d41}മ\u{d3e}ല\u{d3e}ഖ"),
            keywords: &[
                "ക\u{d41}ഞ\u{d4d}ഞ\u{d41}മ\u{d3e}ല\u{d3e}ഖ",
                "ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}",
                "ഫ\u{d3e}ന\u{d4d}റസി",
                "മ\u{d3e}ല\u{d3e}ഖ",
                "മ\u{d41}ഖം",
                "മ\u{d41}ത\u{d4d}തശ\u{d4d}ശിക\u{d4d}കഥ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нялх сахиусан тэнгэр"),
            keywords: &[
                "инээмсэглэл",
                "нялх",
                "нялх сахиусан тэнгэр",
                "сахиусан тэнгэр",
                "төсөөлөл",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बाल द\u{947}वद\u{942}त"),
            keywords: &[
                "आवड",
                "च\u{947}हरा",
                "द\u{947}वद\u{942}त",
                "परी कथा",
                "बाल द\u{947}वद\u{942}त",
                "बाळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pari-pari bayi"),
            keywords: &[
                "bayi",
                "cerita dongeng",
                "fantasi",
                "malaikat",
                "muka",
                "pari-pari bayi",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("anġlu tarbija"),
            keywords: &["anġlu", "fantasija", "tarbija", "wiċċ", "ħrafa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နတ\u{103a}သမ\u{102e}းကလေး"),
            keywords: &[
                "ကလေး",
                "စ\u{102d}တ\u{103a}က\u{1030}းယဉ\u{103a}",
                "နတ\u{103a}သမ\u{102e}း",
                "နတ\u{103a}သမ\u{102e}း ပ\u{102f}\u{1036}ပြင\u{103a}",
                "နတ\u{103a}သမ\u{102e}းကလေး",
                "မျက\u{103a}န\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("babyengel"),
            keywords: &["ansikt", "babyengel", "engel", "eventyr"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बच\u{94d}चा परी"),
            keywords: &[
                "अन\u{941}हार",
                "ख\u{947}स\u{94d}रा कल\u{94d}पना",
                "परी",
                "परीको कथा",
                "बच\u{94d}चा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("baby-engel"),
            keywords: &[
                "baby",
                "baby-engel",
                "engel",
                "fantasie",
                "gezicht",
                "sprookje",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("babyengel"),
            keywords: &["andlet", "babyengel", "engel", "eventyr"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ଶ\u{b41} ଦେବଦ\u{b42}ତ"),
            keywords: &[
                "କଳ\u{b4d}ପନ\u{b3e}",
                "ଦେବଦ\u{b42}ତ",
                "ପରୀ କ\u{b3e}ହ\u{b3e}ଣୀ",
                "ମ\u{b41}ହ\u{b01}",
                "ଶ\u{b3f}ଶ\u{b41}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a47}ਵਦ\u{a42}ਤ ਬ\u{a71}ਚਾ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਦ\u{a47}ਵਦ\u{a42}ਤ",
                "ਦ\u{a47}ਵਦ\u{a42}ਤ ਬ\u{a71}ਚਾ",
                "ਪਰੀ ਕਹਾਣੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فرشتہ بال"),
            keywords: &["بال", "تصور", "دی شکل", "فرشتہ", "پریاں دی کہانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bẹ\u{301}bí Énjẹl"),
            keywords: &[
                "Bebí",
                "Bẹ\u{301}bí Énjẹl",
                "Dédrim",
                "Fes",
                "Torí Abaut Spírit-dẹm Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Éngẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("aniołek"),
            keywords: &["aniołek", "bajka", "buzia aniołka", "fantasy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ماشوم فرښته"),
            keywords: &[
                "خيال",
                "د ښاپيرو کيسه",
                "فرشته",
                "ماشوم",
                "ماشوم فرښته",
                "مخ",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bebê anjo"),
            keywords: &["anjo", "bebê anjo", "conto de fadas", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("anjo bebé"),
            keywords: &["anjo", "bebé", "cara", "conto de fadas", "fantasia"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wawa angel"),
            keywords: &["angel", "fantasia", "hadas willana", "uya", "wawa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bebeluș îngeraș"),
            keywords: &[
                "basm",
                "bebeluș",
                "bebeluș îngeraș",
                "fantezie",
                "față",
                "înger",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-569"),
            keywords: &["E10-569"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ангелочек"),
            keywords: &[
                "ангел",
                "ангелочек",
                "дитя",
                "крылья",
                "лик",
                "нимб",
                "фэнтези",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("akamalayika"),
            keywords: &[
                "akamalayika",
                "amakabyankuru",
                "isura",
                "marayika",
                "uruhinja",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍي پري"),
            keywords: &["ننڍي پري", "پري، ننڍي، چهرو، پرين جي ڪهاڻي، تصور"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ළදර\u{dd4} ස\u{dd4}රද\u{dd6}තය\u{dcf}"),
            keywords: &[
                "ම\u{dd4}හ\u{dd4}ණ",
                "ස\u{dd2}හ\u{dd2}න ලෝකය",
                "ස\u{dd4}රංඟන\u{dcf} කථ\u{dcf}ව",
                "ස\u{dd4}රද\u{dd6}තය\u{dcf}",
                "ළදර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("anjelik"),
            keywords: &["anjel", "anjelik", "bábä", "rozprávka", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("angelček"),
            keywords: &[
                "angel",
                "angelček",
                "dojenček",
                "fantazija",
                "obraz",
                "pravljica",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("malaa’igta caruurta"),
            keywords: &[
                "canug",
                "khiyaali",
                "malaa’ig",
                "malaa’igta caruurta",
                "sheeko cirfiid",
                "waji",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("engjëll bebe"),
            keywords: &["bebe", "engjëll", "fantazi", "fytyrë", "përrallë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("беба анђео"),
            keywords: &["aнђeo", "бajкa", "бeбa", "беба анђео", "лице", "мaштa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["беба анђео"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beba anđeo"),
            keywords: &["anđeo", "bajka", "beba", "lice", "mašta"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["beba anđeo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bebisängel"),
            keywords: &["bebisängel", "saga", "ängel"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtoto malaika"),
            keywords: &["kichimbakazi", "malaika", "mtoto", "njozi", "uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குழந\u{bcd}தை ஏஞ\u{bcd}சல\u{bcd}"),
            keywords: &[
                "ஏஞ\u{bcd}சல\u{bcd}",
                "குழந\u{bcd}தை ஏஞ\u{bcd}சல\u{bcd}",
                "தேவதை",
                "தேவதைக\u{bcd} கதை",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3f}డ\u{c4d}డ రూపంల\u{c4b} ద\u{c47}వత"),
            keywords: &[
                "ద\u{c47}వత",
                "బ\u{c3f}డ\u{c4d}డ",
                "బ\u{c3f}డ\u{c4d}డ రూపంల\u{c4b} ద\u{c47}వత",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кӯдаки фаришта"),
            keywords: &[
                "афсона",
                "кӯдак",
                "кӯдаки фаришта",
                "малоика",
                "рӯй",
                "тахайюлот",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นางฟ\u{e49}าเด\u{e47}ก"),
            keywords: &["นางฟ\u{e49}า", "นางฟ\u{e49}าเด\u{e47}ก", "เทพน\u{e34}ยาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bäbek perişde"),
            keywords: &["bäbek", "erteki", "hyýal", "perişde", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻangelo valevale"),
            keywords: &["ʻangelo valevale"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bebek melek"),
            keywords: &["bebek melek", "melek", "peri masalı", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بوۋاق پەرىشتە"),
            keywords: &[
                "بوۋاق پەرىشتە",
                "بوۋاق چۆچەك",
                "فانتازىيە",
                "پەرىشتە",
                "چىراي",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("янголятко"),
            keywords: &[
                "ангел",
                "казка",
                "немовля",
                "обличчя",
                "фантазія",
                "янголятко",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بے بی فرشتہ"),
            keywords: &["افسانوی", "بچہ", "بے بی فرشتہ", "فرشتہ", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqaloq farishta"),
            keywords: &["chaqaloq", "ertak", "fantaziya", "farishta", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thiên thần nhỏ"),
            keywords: &[
                "bé con",
                "mặt",
                "thiên thần",
                "thiên thần nhỏ",
                "truyện cổ tích",
                "tưởng tượng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("liiru malaaka"),
            keywords: &[
                "feem",
                "kanam",
                "liir",
                "liiru malaaka",
                "léebu fee",
                "malaaka",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ingelosi elusana"),
            keywords: &[
                "iingcali",
                "ingelosi",
                "ingelosi elusana",
                "intsomi",
                "ubuso",
                "usana",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ángẹli ìkókó"),
            keywords: &[
                "ojú",
                "àlá",
                "ángẹli ìkókó",
                "áńgẹ\u{301}lì",
                "ìkókó",
                "ìtàn ọmọdé",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("寶貝天使"),
            keywords: &["天使", "嬰兒", "寶貝天使", "幻想", "童話", "臉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("宝贝天使"),
            keywords: &["天使", "婴儿", "宝贝天使", "幻想", "童话", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小天使"),
            keywords: &["儿童", "天使", "孩子", "小天使"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("天使"),
            keywords: &["兒童", "天使", "孩子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("天使嬰兒"),
            keywords: &["天使", "天使嬰兒", "嬰兒", "童話"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingelosi eyingane"),
            keywords: &["ingane", "ingelosi", "ingelosi eyingane", "ubuso"],
        },
    ],
};
#[doc = "👼🏻"]
pub const BABY_ANGEL_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👼🏻",
    codepoint: "1F47C 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby angel: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👼🏼"]
pub const BABY_ANGEL_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👼🏼",
    codepoint: "1F47C 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby angel: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👼🏽"]
pub const BABY_ANGEL_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👼🏽",
    codepoint: "1F47C 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby angel: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👼🏾"]
pub const BABY_ANGEL_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👼🏾",
    codepoint: "1F47C 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby angel: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👼🏿"]
pub const BABY_ANGEL_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👼🏿",
    codepoint: "1F47C 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby angel: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🎅"]
pub const SANTA_CLAUS: crate::Emoji = crate::Emoji {
    glyph: "🎅",
    codepoint: "1F385",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "Santa Claus",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Kersvader"),
            keywords: &["Kersfees", "Kersvader", "vader", "viering"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አባባ ገና"),
            keywords: &["አባባ ገና", "አባት", "ክብረ በዓል", "የገና አባት", "ገና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بابا نويل"),
            keywords: &["بابا نويل", "سانتا", "سانتا كلوز", "عيد الميلاد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9be}ণ\u{9cd}ট\u{9be} ক\u{9cd}ল’জ"),
            keywords: &[
                "উদয\u{9be}পন",
                "ক\u{9cd}ল’জ",
                "খ\u{9cd}ৰীষ\u{9cd}টম\u{9be}চ",
                "চ\u{9be}ণ\u{9cd}ট\u{9be}",
                "পিত\u{9c3}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("Santa Klaus"),
            keywords: &[
                "Santa Klaus",
                "ata",
                "bayram",
                "milad",
                "nağıl",
                "santa",
                "santa klaus",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("Санта Клаус"),
            keywords: &["Санта Клаус", "дзед мароз", "каляды", "раство", "свята"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дядо коледа"),
            keywords: &["дядо", "коледа", "празнуване", "приказка", "фантастичен"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9be}ন\u{9cd}ত\u{9be} ক\u{9cd}লজ"),
            keywords: &[
                "উদয\u{9be}পন কর\u{9be}",
                "ক\u{9cd}রিসম\u{9be}স",
                "ব\u{9be}ব\u{9be}",
                "র\u{9c2}পকথ\u{9be}",
                "স\u{9be}ন\u{9cd}ত\u{9be} ক\u{9cd}লজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("Tad Nedeleg"),
            keywords: &["Nedeleg", "Tad Nedeleg", "fest", "gouel", "lid", "tad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("djed mraz"),
            keywords: &["božić", "djed mraz", "nova godina", "praznici"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pare Noel"),
            keywords: &["Nadal", "Noel", "pare"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏠᎦᎴᏓ"),
            keywords: &["ᎠᎵᎮᎵᏍᏗᎢ", "ᎡᏙᏓ", "ᏓᏂᏍᏓᏲᎯᎲᎢ", "ᏧᏠᎦᎴᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("Santa Claus"),
            keywords: &[
                "Santa Claus",
                "fantasy",
                "oslava",
                "otec",
                "pohádka",
                "santa",
                "vánoce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("Siôn Corn"),
            keywords: &["Nadolig", "Siôn Corn", "dathliad", "santa"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("julemand"),
            keywords: &["jul", "julemand", "nisse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Weihnachtsmann"),
            keywords: &["Weihnachten", "Weihnachtsmann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Άι Βασίλης"),
            keywords: &[
                "Άι Βασίλης",
                "Χριστούγεννα",
                "γιορτή",
                "παραμύθι",
                "πατέρας",
                "φαντασία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Santa Claus"),
            keywords: &[
                "Christmas",
                "Santa Claus",
                "celebration",
                "claus",
                "father",
                "santa",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "Christmas",
                "Father Christmas",
                "Santa Claus",
                "celebration",
                "claus",
                "father",
                "santa",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("Santa"),
            keywords: &[
                "Christmas",
                "Father Christmas",
                "Santa",
                "Santa Claus",
                "celebration",
            ],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["Christmas", "Claus", "Father", "Santa", "celebration"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Papá Noel"),
            keywords: &[
                "Navidad",
                "Papá Noel",
                "celebración",
                "claus",
                "papá noel",
                "santa",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("Santa Claus"),
            keywords: &[
                "Navidad",
                "Papá Noel",
                "Santa Claus",
                "fiesta",
                "noel",
                "papá",
                "santa",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "Navidad",
                "Papá Noel",
                "Santa Claus",
                "claus",
                "noel",
                "papá",
                "santa",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jõuluvana"),
            keywords: &["jõulud", "jõuluvana", "muinasjutt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aita noel"),
            keywords: &["aita", "aita noel", "fantasia", "gabonak", "ospakizun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بابا نوئل"),
            keywords: &[
                "بابا نوئل",
                "جشن",
                "جن و پری",
                "سانتا",
                "فانتزی",
                "پدر",
                "کریسمس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("joulupukki"),
            keywords: &["fantasia", "joulu", "joulupukki", "juhla", "satu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("santa claus"),
            keywords: &[
                "Christmas",
                "Pasko",
                "Santa Claus",
                "holiday",
                "santa",
                "santa claus",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jólamaðurin"),
            keywords: &["jól", "jólamaður", "jólamaðurin", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("père Noël"),
            keywords: &["noël", "père", "père Noël"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Noël", "célébration", "fête", "père"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Daidí na Nollag"),
            keywords: &[
                "Daidí na Nollag",
                "Nollaig",
                "Saintí",
                "San Nioclás",
                "Santa",
                "ceiliúradh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bodach na Nollaig"),
            keywords: &[
                "Nollaig",
                "athair",
                "bodach na Nollaig",
                "bodach na nollaig",
                "comharrachadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Papá Noel"),
            keywords: &["Nadal", "Papá Noel", "Santa Claus", "celebración"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સા\u{a82}તા ક\u{acd}લોઝ"),
            keywords: &[
                "ઉજવણી",
                "નાતાલ",
                "ફાધર ક\u{acd}રિસમસ",
                "સા\u{a82}તા",
                "સા\u{a82}તા ક\u{acd}લોઝ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Santa Claus"),
            keywords: &[
                "Kirsimati",
                "Santa Claus",
                "claus",
                "santa",
                "shagali",
                "uba",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סנטה קלאוס"),
            keywords: &["חג המולד", "מתנות", "סנטה", "סנטה קלאוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{948}\u{902}टा क\u{94d}लॉज\u{93c}"),
            keywords: &[
                "क\u{94d}रिसमस",
                "फ\u{93c}ादर क\u{94d}रिसमस",
                "समारोह",
                "सा\u{902}ता",
                "सा\u{902}ता क\u{94d}लाज",
                "स\u{948}\u{902}टा क\u{94d}लॉज\u{93c}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("Djed Božićnjak"),
            keywords: &[
                "Djed Božićnjak",
                "bajka",
                "božić",
                "djed mraz",
                "mašta",
                "slavlje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mikulás"),
            keywords: &["arc", "fej", "mikulás", "télapó", "ünnep", "ünneplés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սանտա կլաուս"),
            keywords: &[
                "հայր",
                "հեքիաթ",
                "սանտա",
                "սանտա կլաուս",
                "սուրբ ծնունդ",
                "տոն",
                "ֆանտազիա",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Sinterklas"),
            keywords: &[
                "Sinterklas",
                "dongeng",
                "fantasi",
                "natal",
                "perayaan",
                "santa",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Nna Ekeresìmesi"),
            keywords: &[
                "Ekeresìmesì",
                "Emume",
                "Nna Ekeresìmesi",
                "claus",
                "nna",
                "santa",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jólasveinn"),
            keywords: &["hátíð", "jól", "jólasveinn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Babbo Natale"),
            keywords: &["Babbo Natale", "Natale", "festa"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サンタ"),
            keywords: &["クリスマス", "サンタ", "サンタクロース", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Sinter Klas"),
            keywords: &["Klas", "Natal", "Sinter Klas", "bapa", "pista"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სანტა კლაუსი"),
            keywords: &[
                "აღნიშვნა",
                "ახალი წელი",
                "ზეიმი",
                "ზღაპარი",
                "თოვლის ბაბუა",
                "კალანდა",
                "მამა",
                "სანტა",
                "სანტა კლაუსი",
                "ფანტაზია",
                "ფანტასტიკა",
                "შობა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("санта клаус"),
            keywords: &["Рождество", "клаус", "санта", "тойлау", "әке"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("julemand"),
            keywords: &["jul", "julemand", "nisse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("តាណ\u{17bc}អែល"),
            keywords: &[
                "ការប\u{17d2}រារព\u{17d2}ធព\u{17b7}ធ\u{17b8}",
                "គ\u{17d2}រ\u{17b7}ស\u{17d2}ដស\u{17d2}មាស",
                "តាណ\u{17bc}អែល",
                "ប\u{17bb}ណ\u{17d2}យណ\u{17bc}អែល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸಾಂತಾ ಕ\u{ccd}ಲಾಜ\u{ccd}"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕ\u{ccd}ರ\u{cbf}ಸ\u{ccd}ಮಸ\u{ccd}",
                "ಕ\u{ccd}ಲಾಸ\u{ccd}",
                "ತಂದ\u{cc6}",
                "ಸಂತಾ",
                "ಸಾಂಟಾ ಕ\u{ccd}ಲಾಸ\u{ccd}",
                "ಸಾಂತಾ ಕ\u{ccd}ಲಾಜ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("산타클로스"),
            keywords: &["산타", "산타 할아버지", "산타클로스", "크리스마스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("सा\u{902}ता क\u{94d}लॉज"),
            keywords: &[
                "क\u{94d}लॉज",
                "ख\u{94d}रिस\u{94d}तमस",
                "बाप\u{942}य",
                "सा\u{902}ता",
                "स\u{941}वाळो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аяз ата"),
            keywords: &["ата", "аяз ата", "клаус", "майрам", "рождество"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kleeschen"),
            keywords: &["Chrëschtdag", "Feier", "Kleeschen", "Papp"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊານຕາຄລ\u{eb1}ອສ"),
            keywords: &["ຄຣ\u{eb4}ສມາດ", "ຊາຕາຄຣ\u{eb1}ອສ", "ຊານຕາຄລ\u{eb1}ອສ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Kalėdų senelis"),
            keywords: &["Kalėdos", "Kalėdų senelis", "senelis", "tėvas", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Ziemassvētku vecītis"),
            keywords: &[
                "Ziemassvētku vecītis",
                "santaklauss",
                "vecītis",
                "ziemassvētki",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hana koko"),
            keywords: &["hana", "kirihimete", "koko", "matua", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дедо мраз"),
            keywords: &[
                "дедо мраз",
                "нова година",
                "прослава",
                "сказна",
                "фантазија",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d3e}ന\u{d4d}ത\u{d3e}ക\u{d4d}ലോസ\u{d4d}"),
            keywords: &[
                "അച\u{d4d}ചൻ",
                "ആഘോഷം",
                "ക\u{d4d}രിസ\u{d4d}\u{200c}ത\u{d41}മസ\u{d4d}",
                "മ\u{d41}ത\u{d4d}തശ\u{d4d}ശിക\u{d4d}കഥ",
                "സ\u{d3e}ന\u{d4d}ത",
                "സ\u{d3e}ന\u{d4d}ത\u{d3e}ക\u{d4d}ലോസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Санта Клаус"),
            keywords: &[
                "Зул сарын баяр",
                "Санта Клаус",
                "аав",
                "баяр тэмдэглэх",
                "клаус",
                "санта",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सा\u{902}ता क\u{94d}लॉज"),
            keywords: &[
                "उत\u{94d}सव",
                "क\u{94d}लॉज",
                "ख\u{94d}रिसमस",
                "फादर",
                "सा\u{902}ता",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("santa klaus"),
            keywords: &[
                "bapa",
                "cerita dongeng",
                "fantasi",
                "krismas",
                "perayaan",
                "santa",
                "santa klaus",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Santa Klaws"),
            keywords: &[
                "Milied",
                "Santa Klaws",
                "klaws",
                "missier",
                "santa",
                "ċelebarazzjoni",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆန\u{103a}တာ ကလော\u{1037}စ\u{103a}"),
            keywords: &[
                "ခရစ\u{103a}စမတ\u{103a}",
                "ဆန\u{103a}တာ",
                "ဆန\u{103a}တာ ကလော\u{1037}စ\u{103a}",
                "အောင\u{103a}ပ\u{103d}\u{1032}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("julenissen"),
            keywords: &["feiring", "jul", "julenissen", "nissefar", "nissen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सान\u{94d}ता क\u{94d}लज"),
            keywords: &[
                "ख\u{947}स\u{94d}रा कल\u{94d}पना",
                "परीको कथा",
                "ब\u{941}बा",
                "समारोह",
                "सान\u{94d}ता",
                "सान\u{94d}ता क\u{94d}लज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kerstman"),
            keywords: &["Kerstmis", "kerstman", "viering"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("julenissen"),
            keywords: &["feiring", "jul", "julenissen", "nissefar", "nissen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b3e}ଣ\u{b4d}ଟ\u{b3e} କ\u{b4d}ଲସ\u{b4d}\u{200d}"),
            keywords: &[
                "ଉତ\u{b4d}ସବ",
                "କ\u{b4d}ଲସ\u{b4d}\u{200d}",
                "ଖ\u{b4d}ରୀଷ\u{b4d}ଟମ\u{b3e}ସ\u{b4d}",
                "ପ\u{b3f}ତ\u{b3e}",
                "ସ\u{b3e}ଣ\u{b4d}ଟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a48}\u{a02}ਟਾ ਕਲਾਜ\u{a3c}"),
            keywords: &[
                "ਕ\u{a4d}ਰਿਸਮਸ",
                "ਜਸ\u{a3c}ਨ",
                "ਪਿਤਾ ਕ\u{a4d}ਰਿਸਮਸ",
                "ਸ\u{a48}\u{a02}ਟਾ",
                "ਸ\u{a48}\u{a02}ਟਾ ਕਲਾਜ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سنٹا کلاز"),
            keywords: &["جزو", "سانتا", "سنٹا کلاز", "منانا", "پی\u{651}و", "کرسمس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sántá Klọz"),
            keywords: &[
                "Fáda",
                "Klọz",
                "Krísmas",
                "Papá",
                "Sánta",
                "Sántá Klọz",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Święty Mikołaj"),
            keywords: &[
                "boże narodzenie",
                "legenda",
                "Święty Mikołaj",
                "święta",
                "święty mikołaj",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سانټا کلاز"),
            keywords: &["بابا", "سانټا", "لمانځل", "کرسمس", "کلاز"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("Papai Noel"),
            keywords: &["Natal", "Noel", "Papai Noel", "comemoração"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pai natal"),
            keywords: &["celebração", "conto de fadas", "fantasia", "natal", "pai"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Papa Noel"),
            keywords: &["Navidad", "Papa Noel", "noel", "papa", "raymi", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Moș Crăciun"),
            keywords: &["Crăciun", "Moș Crăciun", "moș", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-330"),
            keywords: &["E10-330"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Санта-Клаус"),
            keywords: &[
                "Санта-Клаус",
                "дед мороз",
                "дедушка мороз",
                "клаус",
                "новый год",
                "рождество",
                "санта",
                "санта-клаус",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Papa Noheli"),
            keywords: &["Noheli", "Papa Noheli", "data", "ibirori", "papa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سانتا ڪلاز"),
            keywords: &["سانتا ڪلاز", "ڪرشمس، جشن، پي، سانتا، ڪلاز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නත\u{dca}තල\u{dca} ස\u{dd3}ය\u{dcf}"),
            keywords: &[
                "නත\u{dca}තල\u{dca} ස\u{dd3}ය\u{dcf}",
                "ප\u{dd2}ය\u{dcf}",
                "ස\u{dd2}හ\u{dd2}න ලෝකය",
                "ස\u{dd4}රංඟන\u{dcf} කථ\u{dcf}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("Santa"),
            keywords: &["Santa", "Santa Claus", "muž", "oslava", "santa", "vianoce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("Božiček"),
            keywords: &[
                "Božiček",
                "božič",
                "božiček",
                "fantazija",
                "oče",
                "pravljica",
                "slavje",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Aabaha Ciidda Masiixigga"),
            keywords: &[
                "Aabaha Ciidda Masiixigga",
                "Aabaha ciidda Masiixigga",
                "Alla ka cabsi",
                "Ciidda Masiixigga",
                "aabaha farxdda",
                "aabe",
                "dabbaaldeg",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("babagjyshi i krishtlindjes"),
            keywords: &[
                "babagjyshi i krishtlindjes",
                "festim",
                "krishtlindje",
                "përrallë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("Деда Мраз"),
            keywords: &[
                "Деда Мраз",
                "бajкa",
                "бoжић",
                "бoжић бата",
                "дeда мрaз",
                "мaштa",
                "прослава",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("Дјед Мраз"),
            keywords: &["Дјед Мраз"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("Deda Mraz"),
            keywords: &[
                "Deda Mraz",
                "bajka",
                "božić",
                "božić bata",
                "deda mraz",
                "mašta",
                "proslava",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("Djed Mraz"),
            keywords: &["Djed Mraz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jultomte"),
            keywords: &["högtid", "jul", "jultomte", "tomten"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("baba krismasi"),
            keywords: &["baba", "kichimbakazi", "krismasi", "njozi", "sherehe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிறிஸ\u{bcd}துமஸ\u{bcd} த\u{bbe}த\u{bcd}த\u{bbe}"),
            keywords: &[
                "கிறிஸ\u{bcd}துமஸ\u{bcd}",
                "கொண\u{bcd}ட\u{bbe}ட\u{bcd}டம\u{bcd}",
                "த\u{bbe}த\u{bcd}த\u{bbe}",
                "பரிசு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3e}ంట\u{c3e} క\u{c4d}ల\u{c3e}స\u{c4d}"),
            keywords: &[
                "క\u{c4d}ర\u{c3f}స\u{c4d}మస\u{c4d}",
                "ఫ\u{c3e}దర\u{c4d} క\u{c4d}ర\u{c3f}స\u{c4d}మస\u{c4d}",
                "వ\u{c47}డుక",
                "శ\u{c3e}ంట\u{c3e}",
                "శ\u{c3e}ంట\u{c3e} క\u{c4d}ల\u{c3e}స\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бобои барфӣ"),
            keywords: &[
                "бобои барфӣ",
                "клаус",
                "мавлуди Исо",
                "падар",
                "санта",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซานต\u{e49}า"),
            keywords: &["คร\u{e34}สต\u{e4c}มาส", "ซานตาคลอส", "ซานต\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Aýaz baba"),
            keywords: &[
                "Aýaz baba",
                "Roždestwo",
                "aýaz",
                "baba",
                "baýramçylyk",
                "kaka",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Sānita Kalausi"),
            keywords: &["Sānita Kalausi", "tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Noel Baba"),
            keywords: &["Noel Baba", "kutlama", "noel", "santa claus"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مىلاد بوۋاي"),
            keywords: &["بوۋاي", "تەبرىكلەش", "مىلاد", "نورۇز"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Санта Клаус"),
            keywords: &[
                "Різдво",
                "Санта Клаус",
                "Святий Миколай",
                "дід",
                "святкування",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سانتا کلاز"),
            keywords: &["باپ", "جشن", "سانتا", "سانتا کلاز", "کرسمس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("santa-klaus"),
            keywords: &[
                "ertak",
                "fantaziya",
                "nishonlash",
                "qorbobo",
                "santa",
                "santa-klaus",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Ông già Noel"),
            keywords: &[
                "Giáng sinh",
                "cha",
                "claus",
                "lễ kỷ niệm",
                "santa",
                "Ông già Noel",
                "Ông già Noen",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("Pere nowel"),
            keywords: &["Pere nowel", "màggal", "nowel", "papa", "pere"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("U-Santa Claus"),
            keywords: &[
                "Ikrismesi",
                "U-Santa Claus",
                "u-claus",
                "u-santa",
                "umbhiyozo",
                "utata",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Baba Keresi"),
            keywords: &["Baba Keresi", "ayẹyẹ", "baba", "kérésì"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聖誕老人"),
            keywords: &["天父", "慶祝", "聖誕節", "聖誕老人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圣诞老人"),
            keywords: &["圣诞老人", "圣诞节", "天父", "庆祝"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圣诞老人"),
            keywords: &["圣诞", "圣诞老人", "节日"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聖誕老人"),
            keywords: &["聖誕老人", "聖誕老公公"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["慶祝", "聖誕節", "聖誕老人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubaba ukhisimusi"),
            keywords: &["insumansumane", "ubaba", "ukhisimusi", "umbungazo"],
        },
    ],
};
#[doc = "🎅🏻"]
pub const SANTA_CLAUS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🎅🏻",
    codepoint: "1F385 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "Santa Claus: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🎅🏼"]
pub const SANTA_CLAUS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🎅🏼",
    codepoint: "1F385 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "Santa Claus: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🎅🏽"]
pub const SANTA_CLAUS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🎅🏽",
    codepoint: "1F385 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "Santa Claus: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🎅🏾"]
pub const SANTA_CLAUS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🎅🏾",
    codepoint: "1F385 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "Santa Claus: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🎅🏿"]
pub const SANTA_CLAUS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🎅🏿",
    codepoint: "1F385 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "Santa Claus: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤶"]
pub const MRS_CLAUS: crate::Emoji = crate::Emoji {
    glyph: "🤶",
    codepoint: "1F936",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "Mrs. Claus",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("Moeder Kersfees"),
            keywords: &[
                "Kersfees",
                "Kersmoeder",
                "Moeder Kersfees",
                "moeder",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የገና እናት"),
            keywords: &["እናት", "ወ/ሮ ከላውስ", "የገና እናት", "ገና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة سانتا كلوز"),
            keywords: &["أم", "سانتا كلوز", "سيدة سانتا كلوز", "كريسماس"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মিচেচ ক\u{9cd}ল’জ"),
            keywords: &[
                "উদয\u{9be}পন",
                "ক\u{9cd}ল’জ",
                "খ\u{9cd}ৰীষ\u{9cd}টম\u{9be}চ",
                "ম\u{9be}ত\u{9c3}",
                "মিচেচ ক\u{9cd}ল’জ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("xanım Klaus"),
            keywords: &["Klaus", "Milad", "ana", "bayram", "xanım"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("місіс Клаус"),
            keywords: &[
                "каляды",
                "місіс Клаус",
                "місіс клаус",
                "новы год",
                "снягурка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("баба коледа"),
            keywords: &["баба", "коледа"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}দ\u{9be}র খ\u{9cd}রিষ\u{9cd}টম\u{9be}স"),
            keywords: &[
                "খ\u{9cd}রিষ\u{9cd}টম\u{9be}স",
                "ম\u{9be}",
                "ম\u{9be}দ\u{9be}র খ\u{9cd}রিষ\u{9cd}টম\u{9be}স",
                "মিসেস ক\u{9cd}লজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("Mamm Nedeleg"),
            keywords: &["Mamm Nedeleg", "Nedeleg", "fest", "gouel", "lid", "mamm"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("Baka Mraz"),
            keywords: &["Baka Mraz", "Božić", "Djeda Mraz", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mare Noel"),
            keywords: &["Nadal", "Noel", "còfia", "mare", "àvia"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎦᏁᎵ. ᏧᏠᎦᎴᏓ"),
            keywords: &[
                "ᎠᎨᏯ ᎦᏁᎵ.",
                "ᎠᎨᏯ ᎦᏁᎵ. ᏧᏠᎦᎴᏓ",
                "ᎠᎾᎵᎮᎵᎬᎢ",
                "ᎡᏥ",
                "ᏓᏂᏍᏓᏲᎯᎲᎢ",
                "ᏧᏠᎦᎴᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("Santa Clausová"),
            keywords: &[
                "Santa Clausová",
                "fantasy",
                "matka",
                "oslava",
                "pohádka",
                "santa",
                "vánoce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("Siân Corn"),
            keywords: &["Siân Corn", "mam", "y Nadolig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("julemandens kone"),
            keywords: &[
                "dame",
                "fru julemand",
                "jul",
                "julekvinde",
                "julemandens kone",
                "kvinde",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Weihnachtsfrau"),
            keywords: &["Weihnachten", "Weihnachtsfrau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Κυρία Άι Βασίλη"),
            keywords: &["Άι Βασίλης", "Κυρία Άι Βασίλη", "Χριστούγεννα", "γιορτές"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("Mrs. Claus"),
            keywords: &[
                "Christmas",
                "Mrs.",
                "Mrs. Claus",
                "celebration",
                "claus",
                "mother",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("Mrs Claus"),
            keywords: &[
                "Christmas",
                "Mrs",
                "Mrs Claus",
                "celebration",
                "claus",
                "mother",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Christmas", "Mrs Claus", "Mrs Santa Claus", "celebration"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Mrs. Claus"),
            keywords: &["Christmas", "Claus", "Mother", "Mrs.", "celebration"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Mamá Noel"),
            keywords: &["Mamá Noel", "Navidad", "abuela", "mamá", "noel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["Mamá Noel", "Navidad", "mamá", "mamá noel", "señora Claus"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["Claus", "Mamá", "Navidad", "Noel", "Señora", "fiesta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jõuluvana abikaasa"),
            keywords: &["abikaasa", "jõuluvana"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gabonetako ama"),
            keywords: &["ama", "gabonak", "gabonetako ama"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مامان نوئل"),
            keywords: &[
                "خاله ریزه",
                "مادربزرگ",
                "مامان بزرگ",
                "مامان نوئل",
                "پیرزن",
                "کریسمس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("joulupukin muori"),
            keywords: &["joulu", "joulupukin muori", "muori"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("Mrs Claus"),
            keywords: &[
                "Mrs Claus",
                "Mrs. Claus",
                "mother christmas",
                "nanay",
                "pasko",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("jólakonan"),
            keywords: &["jól", "jólakona", "jólakonan", "kona", "kvinna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mère Noël"),
            keywords: &["Noël", "mère"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Noël", "célébration", "fête", "mère"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Bean Uí Claus"),
            keywords: &["Bean Uí Claus", "bean", "hata", "hata nollag", "nollaig"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bean Bodach na Nollaig"),
            keywords: &[
                "bean",
                "bean Bodach na Nollaig",
                "bodach na nollaig",
                "comharrachadh",
                "màthair",
                "nollaig",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("Mamá Noel"),
            keywords: &["Mamá Noel", "Nadal", "mamá", "señora Noel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધર ક\u{acd}રિસ\u{acd}મસ"),
            keywords: &["ક\u{acd}રિસ\u{acd}મસ", "મધર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("Matar Claus"),
            keywords: &[
                "Kirsimati",
                "Matar",
                "Matar Claus",
                "claus",
                "shagalin biki",
                "uwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גב׳ סנטה"),
            keywords: &["גב׳ סנטה", "גב’ קלאוס", "חג המולד", "סנטה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मिस\u{947}ज\u{93c} क\u{94d}लाज"),
            keywords: &[
                "Mrs.क\u{94d}लॉस",
                "क\u{94d}रिस\u{94d}मस",
                "मा\u{902}",
                "मिस\u{947}ज\u{93c} क\u{94d}लाज",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("Baka Mraz"),
            keywords: &["Baka Mraz", "Božić", "žena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mikulás ruhás anyó"),
            keywords: &["anyó", "karácsony", "mikulás ruhás anyó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ձմեռ տատ"),
            keywords: &["Ձմեռ տատ", "նոր տարի", "սուրբ ծնունդ", "տատիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("Nyonya Sinterklas"),
            keywords: &["Nyonya Sinterklas", "ibu", "nenek", "oma"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Nne Ekeresìmesi"),
            keywords: &[
                "Mrs.",
                "Nne Ekeresìmesi",
                "claus",
                "ekeresìmesì",
                "nne",
                "Ènwemụaṅụrị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("jólamamma"),
            keywords: &["amma", "jól", "jólamamma", "mamma"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Mamma Natale"),
            keywords: &["Mamma Natale", "mamma natale", "natale"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性のサンタ"),
            keywords: &["クリスマス", "サンタクロース", "女", "女性", "女性のサンタ"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("Ibu Klas"),
            keywords: &["Ibu Klas", "Klas", "Natal", "ibu", "pista"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალბატონი კლაუსი"),
            keywords: &["დედა", "ქალბატონი კლაუსი", "შობა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ақшақар"),
            keywords: &["ақшақар"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("juledame"),
            keywords: &[
                "dame",
                "fru julemand",
                "jul",
                "juledame",
                "julekvinde",
                "julemandinde",
                "kvinde",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លោកយាយណ\u{17bc}អែល"),
            keywords: &[
                "ការប\u{17d2}រារព\u{17d2}ធ",
                "គ\u{17d2}រ\u{17b8}ស\u{17d2}ដស\u{17d2}មាស",
                "ប\u{17bb}ណ\u{17d2}យណ\u{17bc}អែល",
                "ម\u{17d2}ដាយ",
                "យាយណ\u{17bc}អែល",
                "លោកយាយណ\u{17bc}អែល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{ccd}ರ\u{cbf}ಸ\u{ccd}\u{200c}ಮಸ\u{ccd} ತಾಯ\u{cbf}"),
            keywords: &[
                "ಕ\u{ccd}ರ\u{cbf}ಸ\u{ccd}\u{200c}ಮಸ\u{ccd}",
                "ತಾಯ\u{cbf}",
                "ಮ\u{cbf}. ಕ\u{ccd}ಲಾಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("산타할머니"),
            keywords: &["산타", "산타클로스", "산타할머니", "크리스마스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{94d}रीमती क\u{94d}लॉज"),
            keywords: &[
                "श\u{94d}रीमती क\u{94d}लॉज",
                "स\u{941}वाळो । नाताळ । क\u{94d}लॉज । आवय । श\u{94d}रीमती. । श\u{94d}रीमती. क\u{94d}लॉज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("миссис клаус"),
            keywords: &["миссис клаус", "рождество"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Dem Kleesche seng Fra"),
            keywords: &[
                "Chrëschtdag",
                "Dem Kleesche seng Fra",
                "Feier",
                "Fra",
                "Kleeschen",
                "Mamm",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມ\u{ec8}ຄຣ\u{eb4}ສມາສ"),
            keywords: &[
                "ຄຣ\u{eb4}ສມາສ",
                "ນາງຄລອສ",
                "ແມ\u{ec8}",
                "ແມ\u{ec8}ຄຣ\u{eb4}ສມາສ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ponia Claus"),
            keywords: &["Kalėdos", "mama", "ponia", "ponia Claus", "šventė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("Ziemassvētku omīte"),
            keywords: &[
                "Ziemassvētku omīte",
                "omīte",
                "salavecis",
                "ziemassvētki",
                "ziemassvētku vecītis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kuia koko"),
            keywords: &["kirihimete", "koko", "kuia", "whaea", "whakanuinga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("баба мразица"),
            keywords: &["баба", "мразица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മദർ ക\u{d4d}രിസ\u{d4d}മസ\u{d4d}"),
            keywords: &[
                "അമ\u{d4d}മ",
                "ക\u{d4d}രിസ\u{d4d}മസ\u{d4d}",
                "മദർ ക\u{d4d}രിസ\u{d4d}മസ\u{d4d}",
                "മിസിസ\u{d4d} ക\u{d4d}ലോസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Зулсарын хатагтай"),
            keywords: &["Зулсар", "Зулсарын хатагтай", "Хатагтай", "эх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मदर ख\u{94d}रिसमस"),
            keywords: &[
                "उत\u{94d}सव",
                "क\u{94d}लॉज",
                "ख\u{94d}रिसमस",
                "मदर",
                "श\u{94d}रीमती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("Pn. Claus"),
            keywords: &["Pn. Claus", "ibu", "krismas", "puan claus"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("Is-Sinjura Klaws"),
            keywords: &["Is-Sinjura", "Klaws", "il-Milied", "omm", "ċelebarazzjoni"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မစ\u{1039}စစ\u{103a} စန\u{103a}တာကလော\u{1037}စ\u{103a}"),
            keywords: &[
                "ခရစ\u{103a}စမတ\u{103a}",
                "မစ\u{1039}စစ\u{103a} စန\u{103a}တာကလော\u{1037}စ\u{103a}",
                "မ\u{102d}ခင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("julenissemor"),
            keywords: &["jul", "julenissemor", "mor", "nisse"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("श\u{94d}रीमती क\u{94d}लज"),
            keywords: &[
                "आमा",
                "उत\u{94d}सव",
                "क\u{94d}रिस\u{94d}मस",
                "क\u{94d}लज",
                "श\u{94d}रीमती",
                "श\u{94d}रीमान\u{94d}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kerstvrouw"),
            keywords: &["kerstmis", "kerstvrouw", "moedertje kerst"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("julenissemor"),
            keywords: &["jul", "julenissemor", "mor", "nisse"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b4d}ରୀମତୀ କ\u{b4d}ଲସ\u{b4d}\u{200d}"),
            keywords: &[
                "ଖ\u{b4d}ରୀଷ\u{b4d}ଟମ\u{b3e}ସ\u{b4d} । ଉତ\u{b4d}ସବ ପ\u{b3e}ଳନ । ମ\u{b3e}ଆ । ଶ\u{b4d}ରୀମତୀ । କ\u{b4d}ଲସ\u{b4d}\u{200d}",
                "ଶ\u{b4d}ରୀମତୀ କ\u{b4d}ଲସ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a3c}\u{a4d}ਰੀਮਤੀ ਕਲਾਜ\u{a3c}"),
            keywords: &[
                "ਕ\u{a4d}ਰਿਸਮਿਸ",
                "ਮਾ\u{a02}",
                "ਸ\u{a3c}\u{a4d}ਰੀਮਤੀ ਕਲਾਜ\u{a3c}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مسز کلاز"),
            keywords: &["جزو", "ماں", "مسز", "مسز کلاز", "منانا", "کرسمس"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Misis Klọz"),
            keywords: &[
                "Klọz",
                "Krísmas",
                "Mamá",
                "Misis",
                "Mọ\u{301}da",
                "Sẹlibréshọn",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("żona św. Mikołaja"),
            keywords: &["mikołaj", "mikołajowa", "święta", "żona św. Mikołaja"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ميرمن کلاز"),
            keywords: &["سانټا", "لمانځل", "مور", "ميرمن کلاز", "کرسمس", "کلاز"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("Mamãe Noel"),
            keywords: &["Mamãe Noel", "Natal", "Noel", "comemoração"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mãe natal"),
            keywords: &["mãe", "natal", "senhora Noel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("Mama Noel"),
            keywords: &["Mama Noel", "Navidad", "mama", "noel", "raymi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Doamna Crăciun"),
            keywords: &["Crăciun", "Doamna Crăciun", "doamna", "sărbătoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1048"),
            keywords: &["E10-1048"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("миссис Клаус"),
            keywords: &[
                "миссис Клаус",
                "миссис клаус",
                "новый год",
                "рождество",
                "снегурочка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Mama Noheli"),
            keywords: &[
                "Mama Noheli",
                "Noheli",
                "ibirori",
                "madamazela.",
                "mama",
                "papa Noheli",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪلاز جي مائي"),
            keywords: &["ڪرشمس، جشن، ماء\u{64f}، مائي، ڪلاز", "ڪلاز جي مائي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නතල\u{dca} ආච\u{dca}ච\u{dd2}"),
            keywords: &[
                "අම\u{dca}ම\u{dcf}",
                "නතල\u{dca} ආච\u{dca}ච\u{dd2}",
                "නත\u{dca}තල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pani Santová"),
            keywords: &["oslava", "pani Santová", "santa", "vianoce", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("gospa Božiček"),
            keywords: &["Božič", "gospa", "gospa Božiček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Marwada Masiixigga"),
            keywords: &[
                "Alla ka cabsi",
                "Marwada Masiixigga",
                "Marwo",
                "ciidda masiixigga",
                "dabbaaldeg",
                "hooyo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjyshe krishtlindjesh"),
            keywords: &["gjyshe", "gjyshe krishtlindjesh", "krishtlindje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("бака Мраз"),
            keywords: &["бака", "бака Мраз", "божић", "мраз"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("baka Mraz"),
            keywords: &["baka", "baka Mraz", "božić", "mraz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tomtemor"),
            keywords: &["jul", "mor", "nisse", "tomtemor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkongwe"),
            keywords: &["bibi", "mkongwe", "nyanya"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிறிஸ\u{bcd}துமஸ\u{bcd} ப\u{bbe}ட\u{bcd}டி"),
            keywords: &[
                "கிறிஸ\u{bcd}துமஸ\u{bcd}",
                "ச\u{bbe}ன\u{bcd}ட\u{bbe}",
                "த\u{bbe}த\u{bcd}த\u{bbe}",
                "ப\u{bbe}ட\u{bcd}டி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c4d}ర\u{c40}మత\u{c3f} శ\u{c3e}ంట\u{c3e}"),
            keywords: &[
                "క\u{c4d}ర\u{c3f}స\u{c4d}మస\u{c4d}",
                "తల\u{c4d}ల\u{c3f}",
                "మ\u{c3f}స\u{c46}స\u{c4d} క\u{c4d}ల\u{c3e}జ\u{c4d}",
                "శ\u{c4d}ర\u{c40}మత\u{c3f} శ\u{c3e}ంట\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Хонум Клаус"),
            keywords: &[
                "Мавлуди Исо",
                "Хонум Клаус",
                "клаус",
                "модар",
                "хонум",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นางซานต\u{e49}า"),
            keywords: &[
                "คร\u{e34}สต\u{e4c}มาส",
                "นางซานต\u{e49}า",
                "นางแซนต\u{e49}า",
                "แม\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("Aýaz mama"),
            keywords: &[
                "Aýaz mama",
                "Hanym",
                "Roždestwo",
                "baýramçylyk",
                "eje",
                "klaus",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Sānita Kalausi fefine"),
            keywords: &["Sānita Kalausi", "Sānita Kalausi fefine", "fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Noel Anne"),
            keywords: &["Noel Anne", "anne", "noel"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مىلاد موماي"),
            keywords: &["بايرام", "تەبرىكلەش", "مىلاد", "مىلاد موماي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Пані Клаус"),
            keywords: &["Пані Клаус", "Різдво", "жінка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مدر کرسمس"),
            keywords: &["مدر", "کرسمس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qorqiz"),
            keywords: &["qorqiz", "rojdestvo"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mẹ giáng sinh"),
            keywords: &["bà già Noel", "giáng sinh", "mẹ", "mẹ giáng sinh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("meer nowel"),
            keywords: &["meer", "màggal", "nowel", "yaay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("UNksz. Claus"),
            keywords: &[
                "UNksz. Claus",
                "ikrismesi",
                "u-claus",
                "uNksz.",
                "umama",
                "umbhiyozo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Arabinrin Keresi"),
            keywords: &[
                "Arabinrin Keresi",
                "[kẹrẹsí",
                "ayẹyẹ",
                "kérésì",
                "omidan",
                "ìyá",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女聖誕老人"),
            keywords: &["女聖誕老人", "媽媽", "慶祝", "聖誕節"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女圣诞老人"),
            keywords: &["圣诞节", "女圣诞老人", "妈妈", "庆祝"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圣诞奶奶"),
            keywords: &["圣诞", "圣诞奶奶", "奶奶", "老妈"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("聖誕老奶奶"),
            keywords: &["奶", "老", "聖", "聖誕老奶奶", "誕"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("聖誕婆婆"),
            keywords: &["慶祝", "聖誕婆婆", "聖誕節"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umama kakhisimusi"),
            keywords: &[
                "uNkosikazi Claus",
                "ukhisimuzi",
                "umama",
                "umama kakhisimusi",
            ],
        },
    ],
};
#[doc = "🤶🏻"]
pub const MRS_CLAUS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤶🏻",
    codepoint: "1F936 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "Mrs. Claus: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤶🏼"]
pub const MRS_CLAUS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤶🏼",
    codepoint: "1F936 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "Mrs. Claus: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤶🏽"]
pub const MRS_CLAUS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤶🏽",
    codepoint: "1F936 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "Mrs. Claus: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤶🏾"]
pub const MRS_CLAUS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤶🏾",
    codepoint: "1F936 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "Mrs. Claus: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤶🏿"]
pub const MRS_CLAUS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤶🏿",
    codepoint: "1F936 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "Mrs. Claus: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🎄"]
pub const MX_CLAUS: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🎄",
    codepoint: "1F9D1 200D 1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mx claus",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mx claus"),
            keywords: &["Claus, Kersfeess", "mx claus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሚክስ ክላውስ"),
            keywords: &["ሚክስ ክላውስ", "ክላውስ, ገና"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("كلوز"),
            keywords: &["عيد الميلاد", "كلوز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেক\u{9cd}স ক\u{9cd}ল’জ"),
            keywords: &[
                "ক\u{9cd}ল’জ, খ\u{9cd}ৰীষ\u{9cd}টম\u{9be}চ",
                "মেক\u{9cd}স ক\u{9cd}ল’জ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mx klaus"),
            keywords: &["Klaus, milad", "mx klaus"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("спадарыня Клаус"),
            keywords: &["Клаус, каляды, Раство", "спадарыня Клаус"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("г-х коледа"),
            keywords: &["г-х коледа", "коледа"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9cd}য\u{9be}ক\u{9cd}স ক\u{9cd}লস"),
            keywords: &[
                "কল\u{9cd}স, ক\u{9cd}রিসম\u{9be}স",
                "ম\u{9cd}য\u{9be}ক\u{9cd}স ক\u{9cd}লস",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("g. Mraz"),
            keywords: &["Djeda Mraz, božić", "g. Mraz"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("Noel"),
            keywords: &["Noel", "Noel, Nadal"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏠᏱ ᏧᏠᎦᎴᏓ"),
            keywords: &["ᏧᏠᎦᎴᏓ, ᏓᏂᏍᏓᏲᎯᎲᎢ", "ᏧᏠᏱ ᏧᏠᎦᎴᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("Santa"),
            keywords: &[
                "Santa",
                "fantasy",
                "oslava",
                "pohádka",
                "santa",
                "santa claus",
                "vánoce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mx claus"),
            keywords: &["Claus, nadolig", "mx claus"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("julenisse"),
            keywords: &["jul", "julenisse", "nisse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Weihnachtsperson"),
            keywords: &["Weihnachten", "Weihnachtsperson"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("Άγιος Βασίλης"),
            keywords: &["Άγιος Βασίλης", "Άι Βασίλης", "Χριστούγεννα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mx claus"),
            keywords: &["Claus, christmas", "mx claus"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("Mx. Claus"),
            keywords: &["Claus, Christmas", "Mx. Claus"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("Noel"),
            keywords: &["Navidad", "Noel", "noel"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("papá noel"),
            keywords: &["Claus", "Navidad", "Papá Noel", "Santa", "papá noel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["Claus", "Navidad", "Santa Claus", "papá noel"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päkats"),
            keywords: &["päkapikk", "päkapikk, jõulud", "päkats"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bizarzuri"),
            keywords: &["bizar zuri", "bizarzuri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نوئل"),
            keywords: &["نوئل", "نوئل، کریسمس"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tonttu"),
            keywords: &["joulutonttu", "tonttu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mx claus"),
            keywords: &["Claus, pasko", "mx claus"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("santa"),
            keywords: &["Santa, noël", "santa"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("personnage de Noël"),
            keywords: &["Noël", "personnage de Noël"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("Saintí"),
            keywords: &["Saintí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Neach na Nollaig"),
            keywords: &[
                "Neach na Nollaig",
                "bean Bodach na Nollaig",
                "bodach na Nollaig",
                "neach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("señora Noel"),
            keywords: &["Nadal", "Noel", "señora Noel"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("એમએક\u{acd}સ ક\u{acd}લોઝ"),
            keywords: &["એમએક\u{acd}સ ક\u{acd}લોઝ", "ક\u{acd}લોઝ, નાતાલ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קלאוס"),
            keywords: &["גב׳ סנטה", "גב’ קלאוס", "חג המולד", "סנטה", "קלאוס"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("एम एक\u{94d}स क\u{94d}ला\u{945}\u{945}\u{945}\u{945}ज\u{93c}"),
            keywords: &[
                "एम एक\u{94d}स क\u{94d}ला\u{945}\u{945}\u{945}\u{945}ज\u{93c}",
                "एम एक\u{94d}स क\u{94d}लॉज\u{93c}",
                "क\u{94d}ला\u{945}\u{945}\u{945}\u{945}ज\u{93c}, क\u{94d}रिसमस",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("osoba Mraz"),
            keywords: &["Mraz, Božić", "osoba Mraz"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("télapó"),
            keywords: &["Mikulás, karácsony", "télapó"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("Ձմեռ պապ"),
            keywords: &["Ձմեռ պապ", "Ձմեռ պապ, Սուրբ ծնունդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("manusia sinterklas"),
            keywords: &["Natal, Sinterklas", "manusia sinterklas"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("frú sveinki"),
            keywords: &["Sveinki, jól", "frú sveinki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("Santa Claus"),
            keywords: &["Claus, Natale", "Santa Claus"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サンタさん"),
            keywords: &["クリスマス", "サンタさん", "サンタクロース"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bapa/ibu klas"),
            keywords: &["Klas, natal", "bapa/ibu klas"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სანტა"),
            keywords: &["კლაუსი", "სანტა", "შობა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("клаус мырза"),
            keywords: &["Клаус, рождество", "клаус мырза"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសណ\u{17bc}អែល"),
            keywords: &[
                "ប\u{17bb}ណ\u{17d2}យណ\u{17bc}អែល គ\u{17d2}រ\u{17b8}ស\u{17d2}តស\u{17d2}មាស",
                "ប\u{17bb}រសណ\u{17bc}អែល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಂಎಕ\u{ccd}ಸ\u{ccd}\u{200c} ಕ\u{ccd}ಲಾಸ\u{ccd}\u{200c}"),
            keywords: &[
                "ಎಂಎಕ\u{ccd}ಸ\u{ccd}\u{200c} ಕ\u{ccd}ಲಾಸ\u{ccd}\u{200c}",
                "ಕ\u{ccd}ಲಾಸ\u{ccd}, ಕ\u{ccd}ರ\u{cbf}ಸ\u{ccd}\u{200c}ಮಸ\u{ccd}\u{200c}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("산타"),
            keywords: &["산타", "산타클로스", "크리스마스"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{945}क\u{94d}स क\u{94d}लॉज"),
            keywords: &[
                "क\u{94d}लॉज, नाताळ । म\u{945}क\u{94d}स क\u{94d}लॉज",
                "म\u{945}क\u{94d}स क\u{94d}लॉज",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("клаус"),
            keywords: &["Клаус, рождество", "клаус", "рожд клаус"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄລ\u{eb1}ອສ (ບ\u{ecd}\u{ec8}\u{200b}ລະ\u{200b}ບ\u{eb8}\u{200b}ເພດ)"),
            keywords: &[
                "ຄລ\u{eb1}ອສ (ບ\u{ecd}\u{ec8}\u{200b}ລະ\u{200b}ບ\u{eb8}\u{200b}ເພດ)",
                "ຄລ\u{eb1}ອສ, ຄຣ\u{eb4}ສມາສ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("Kalėdų asmuo"),
            keywords: &["Kalėdos", "Kalėdų asmuo"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dzimumneitrāls santaklauss"),
            keywords: &["Ziemassvētku santaklauss", "dzimumneitrāls santaklauss"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лице Мраз"),
            keywords: &["Мраз, Божиќ", "лице Мраз"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("എംഎക\u{d4d}സ\u{d4d} സ\u{d3e}ൻറക\u{d4d}ലോസ\u{d4d}"),
            keywords: &[
                "എംഎക\u{d4d}സ\u{d4d} സ\u{d3e}ൻറക\u{d4d}ലോസ\u{d4d}",
                "സ\u{d3e}ൻറക\u{d4d}ലോസ\u{d4d}, ക\u{d4d}രിസ\u{d4d}മസ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хатагтай клаус"),
            keywords: &["Клаус, зул сар", "хатагтай клаус"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("mx क\u{94d}लॉज"),
            keywords: &[
                "mx क\u{94d}लॉज",
                "क\u{94d}लॉज, ख\u{94d}रिसमस । mx क\u{94d}लॉज",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang claus"),
            keywords: &["Claus, krismas", "orang claus"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မစ\u{1039}စ\u{103a} ကလော\u{1037}စ\u{103a}"),
            keywords: &[
                "ခရစ\u{103a}စမတ\u{103a} ကလော\u{1037}စ\u{103a}",
                "မစ\u{1039}စ\u{103a} ကလော\u{1037}စ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("julenisse"),
            keywords: &["feiring", "jul", "julenisse", "nisse", "person"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{947}क\u{94d}स क\u{94d}लज"),
            keywords: &[
                "क\u{94d}लज, क\u{94d}रिस\u{94d}मस",
                "म\u{947}क\u{94d}स क\u{94d}लज",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kersttransgender"),
            keywords: &["Kerstman, kerst", "kersttransgender"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("julenisse"),
            keywords: &["feiring", "jul", "julenisse", "nisse", "person"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମେକ\u{b4d}ସ କ\u{b4d}ଲସ\u{b4d}"),
            keywords: &[
                "କ\u{b4d}ଲସ\u{b4d}, ଖ\u{b4d}ରୀଷ\u{b4d}ଟମ\u{b3e}ସ",
                "ମେକ\u{b4d}ସ କ\u{b4d}ଲସ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਐਮਐਕਸ ਕਲਾਜ\u{a3c}"),
            keywords: &["ਐਮਐਕਸ ਕਲਾਜ\u{a3c}", "ਕਲਾਜ\u{a3c}, ਕ\u{a4d}ਰਿਸਮਸ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mx Klọz"),
            keywords: &["Klọz, Krísmas", "Mx Klọz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("Mikołajka"),
            keywords: &["Boże Narodzenie", "Mikołaj", "Mikołajka", "święta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("میکس کلاز"),
            keywords: &["میکس کلاز", "کلاز، کرسمس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("noel"),
            keywords: &["Noel, natal", "noel"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("Sra. Natal"),
            keywords: &["Natal", "Sra. Natal"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mx claus"),
            keywords: &["Claus, navidad", "mx claus"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("Crăciun"),
            keywords: &["Crăciun"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-084"),
            keywords: &["E13-084"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("Санта"),
            keywords: &["Дед Мороз", "Клаус", "Новый год", "Рождество", "Санта"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڪس ڪلاز"),
            keywords: &["مڪس ڪلاز", "ڪلاز، ڪرسمس"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("නත\u{dca}තල\u{dca} ස\u{dd3}ය"),
            keywords: &[
                "නත\u{dca}තල\u{dca} ස\u{dd3}ය",
                "නත\u{dca}තල\u{dca} ස\u{dd3}ය\u{dcf}",
                "ස\u{dd3}ය\u{dcf}, නත\u{dca}තල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("Mx Santa"),
            keywords: &["Mx Santa", "oslava", "santa", "vianoce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mx božiček"),
            keywords: &["božiček, božič", "mx božiček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("mx claus"),
            keywords: &["Claus, ciida masiixiga", "mx claus"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zx klaus"),
            keywords: &["Klaus, krishtlindje", "zx klaus"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа Мраз"),
            keywords: &["Мраз, Божић", "особа Мраз"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba Mraz"),
            keywords: &["Mraz, Božić", "osoba Mraz"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("könsneutral tomte"),
            keywords: &["könsneutral tomte", "tomte, jul"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichimbakazi yeyote"),
            keywords: &["kichimbakazi yeyote", "kichimbakazi, krismasi"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேக\u{bcd}ஸ\u{bcd} க\u{bcd}ள\u{bbe}ஸ\u{bcd}"),
            keywords: &[
                "க\u{bcd}ள\u{bbe}ஸ\u{bcd}, கிறிஸ\u{bcd}துமஸ\u{bcd}",
                "மேக\u{bcd}ஸ\u{bcd} க\u{bcd}ள\u{bbe}ஸ\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}క\u{c4d}స\u{c4d} క\u{c4d}ల\u{c4c}జ\u{c4d}"),
            keywords: &[
                "క\u{c4d}ల\u{c4c}జ\u{c4d}, క\u{c4d}ర\u{c3f}స\u{c4d}టమస\u{c4d}",
                "మ\u{c3e}క\u{c4d}స\u{c4d} క\u{c4d}ల\u{c4c}జ\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซานตาคลอส"),
            keywords: &["ซานตาคลอส", "ซานต\u{e49}า, คร\u{e34}สต\u{e4c}มาส"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("maks klaus"),
            keywords: &["Klaus, roždestwo", "maks klaus"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("Sānita Kalausi tokotaha"),
            keywords: &["Sānita Kalausi tokotaha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cinsiyet belirtmeyen noel karakteri"),
            keywords: &["Noel figürü", "cinsiyet belirtmeyen noel karakteri", "noel"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("Мікс Клаус"),
            keywords: &["Мікс Клаус"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("میکس کلاؤز"),
            keywords: &["میکس کلاؤز", "کلاؤز، کرسمس"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("miks-klauz"),
            keywords: &["klauz, rojdestvo", "miks-klauz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bà già Noel"),
            keywords: &["Noel, giáng sinh", "bà già Noel"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("聖誕打扮"),
            keywords: &["打扮", "聖誕打扮", "聖誕老人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("圣诞打扮"),
            keywords: &["圣诞打扮", "圣诞老人", "打扮"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("圣诞人"),
            keywords: &["人", "圣诞", "圣诞人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("跨性別聖誕老人"),
            keywords: &["聖誕老人", "跨性別聖誕老人"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("跨性別聖誕老人"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("u-mx claus"),
            keywords: &["Claus, ukhisimusi", "mx claus", "u-mx claus"],
        },
    ],
};
#[doc = "🧑🏻\u{200d}🎄"]
pub const MX_CLAUS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🎄",
    codepoint: "1F9D1 1F3FB 200D 1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mx claus: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🎄"]
pub const MX_CLAUS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🎄",
    codepoint: "1F9D1 1F3FC 200D 1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mx claus: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🎄"]
pub const MX_CLAUS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🎄",
    codepoint: "1F9D1 1F3FD 200D 1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mx claus: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🎄"]
pub const MX_CLAUS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🎄",
    codepoint: "1F9D1 1F3FE 200D 1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mx claus: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🎄"]
pub const MX_CLAUS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🎄",
    codepoint: "1F9D1 1F3FF 200D 1F384",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "mx claus: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦸"]
pub const SUPERHERO: crate::Emoji = crate::Emoji {
    glyph: "🦸",
    codepoint: "1F9B8",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "superhero",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("superheld"),
            keywords: &["goeie", "held", "heldin", "superheld", "superkrag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጀግና"),
            keywords: &["ጀግና", "ጀግና ሴት", "ጥሩ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطل خارق"),
            keywords: &["بطل", "بطل خارق", "بطلة", "طيب", "قوة خارقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9c1}প\u{9be}ৰহিৰ’"),
            keywords: &[
                "চ\u{9c1}প\u{9be}ৰপ\u{9be}ৱ\u{9be}ৰ",
                "চ\u{9c1}প\u{9be}ৰহিৰ’",
                "ভ\u{9be}ল",
                "হিৰ’",
                "হিৰ’ইন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("superqəhrəman"),
            keywords: &["qəhrəman", "supergüc", "superqəhrəman", "xeyirxah"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("супергерой"),
            keywords: &["гераіня", "герой", "дабро", "супергерой", "суперсіла"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена супергерой"),
            keywords: &[
                "героиня",
                "героична",
                "добра",
                "жена супергерой",
                "суперсили",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}প\u{9be}রহিরো"),
            keywords: &[
                "ভ\u{9be}লো",
                "স\u{9c1}প\u{9be}রপ\u{9be}ওয\u{9bc}\u{9be}র",
                "স\u{9c1}প\u{9be}রহিরো",
                "হিরো",
                "হিরোইন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gourharoz"),
            keywords: &["gourharoz", "haroz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("superheroj"),
            keywords: &["dobro", "heroina", "heroj", "superheroj", "supermoć"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("superheroi"),
            keywords: &["bo", "heroi", "heroïna", "superheroi", "súperpoder"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᎬᏫᏳᏒᎩ ᏩᏥᎸᏉᏛ"),
            keywords: &["ᎣᏍᏓ", "ᏄᎬᏫᏳᏒᎩ ᎤᏟᏂᎩᏓ", "ᏄᎬᏫᏳᏒᎩ ᏩᏥᎸᏉᏛ", "ᏩᏥᎸᏉᏛ", "ᏬᏂᎸᏉᏛᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("superhrdinská postava"),
            keywords: &[
                "hrdina",
                "hrdinka",
                "kladná postava",
                "superhrdina",
                "superhrdinka",
                "superhrdinská postava",
                "superschopnost",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("archarwr"),
            keywords: &["archarwr", "archbŵer", "arwr", "arwres", "da"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("superhelt"),
            keywords: &["god", "helt", "heltinde", "superhelt", "superkraft"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Superheld(in)"),
            keywords: &[
                "Comic",
                "Held",
                "Superheld",
                "Superheld(in)",
                "Superkraft",
                "gut",
                "Übermensch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("υπερήρωας"),
            keywords: &["ήρωας", "ηρωίδα", "καλός", "υπερήρωας", "υπερδύναμη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("superhero"),
            keywords: &["good", "hero", "heroine", "superhero", "superpower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("personaje de superhéroe"),
            keywords: &[
                "bien",
                "heroína",
                "héroe",
                "personaje de superhéroe",
                "superheroína",
                "superhéroe",
                "superpoder",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("superheroína"),
            keywords: &["bien", "heroína", "héroe", "superheroína", "superpoder"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("superkangelane"),
            keywords: &[
                "hea",
                "kangelane",
                "kangelanna",
                "superkangelane",
                "supervõime",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("superheroi"),
            keywords: &["heroi", "on", "superbotere", "superheroi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابرقهرمان"),
            keywords: &[
                "ابرقدرت",
                "ابرقهرمان",
                "خوب",
                "دلاور",
                "شیرزن",
                "شیرمرد",
                "قهرمان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("supersankari"),
            keywords: &[
                "hyvis",
                "hyvä",
                "sankari",
                "sankaritar",
                "supersankari",
                "supervoimat",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("superhero"),
            keywords: &[
                "babaeng superhero",
                "hero",
                "heroine",
                "superhero",
                "superpower",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("superhetja"),
            keywords: &["góður", "hetja", "super", "superhetja", "yvirnátúrligur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("super-héros"),
            keywords: &["bien", "heroïne", "héros", "super-héros", "super-pouvoir"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("superhéros"),
            keywords: &["gentil", "héros", "héroïne", "super pouvoirs", "superhéros"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sárlaoch"),
            keywords: &["banlaoch", "laoch", "maith", "sárchumhacht", "sárlaoch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàr-ghaisgeach"),
            keywords: &[
                "cumhachd",
                "gaisgeach",
                "math",
                "oil-chumhachd",
                "super",
                "sàr-ghaisgeach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("heroe"),
            keywords: &["heroe", "superheroe", "superheroína", "superpoderes"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}પરહીરો"),
            keywords: &[
                "ગ\u{ac1}ણવાન",
                "સ\u{ac1}પરપાવર",
                "સ\u{ac1}પરહીરો",
                "હીરો",
                "હીરોઇન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גיבור על"),
            keywords: &[
                "גיבור",
                "גיבור על",
                "גיבורה",
                "גיבורת על",
                "טוב",
                "כוחות על",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{941}परहीरो"),
            keywords: &[
                "बढ\u{93c}िया",
                "स\u{941}परपॉवर",
                "स\u{941}परहीरो",
                "हीरो",
                "हीरोइन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("superheroj"),
            keywords: &[
                "dobročinitelj",
                "junak",
                "junakinja",
                "superheroj",
                "supermoći",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szuperhős"),
            keywords: &["hős", "hősnő", "jó", "szuperhős", "szuperképesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սուպերհերոս"),
            keywords: &["գերուժ", "լավ", "հերոս", "հերոսուհի", "սուպերհերոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pahlawan super"),
            keywords: &[
                "baik",
                "kekuatan super",
                "pahlawan",
                "pahlawan super",
                "pahlawan wanita",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ofurhetja"),
            keywords: &["góð", "hetja", "kvenhetja", "ofurhetja", "ofurkraftur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("supereroe"),
            keywords: &["eroina", "supereroe", "supereroina", "superpoteri"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("スーパーヒーロー"),
            keywords: &["スーパーヒーロー", "ヒロイン", "ヒーロー", "善", "超人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("satriya mandraguna"),
            keywords: &[
                "becik",
                "kadigdayan linuwih",
                "satriya",
                "satriya mandraguna",
                "srikandhi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სუპერგმირი"),
            keywords: &["ზებუნებრივი", "კეთილი", "სუპერგმირი", "ქალი გმირი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("супер батыр"),
            keywords: &["батыр", "жақсы", "супер батыр", "супер күш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ព\u{17bc}លវ\u{17b8}រជន"),
            keywords: &[
                "ក\u{17c6}ព\u{17bc}លវ\u{17b8}រជន",
                "ថាមពលព\u{17b7}សេស",
                "ល\u{17d2}អ",
                "វ\u{17b8}រនារ\u{17b8}",
                "វ\u{17b8}រប\u{17bb}រស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಹೀರೊ"),
            keywords: &[
                "ಉತ\u{ccd}ತಮ",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಪವರ\u{ccd}",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಹೀರೊ",
                "ಹೀರೊ",
                "ಹೀರೊಯ\u{cbf}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("히로인"),
            keywords: &["정의", "초능력", "히로인", "히어로"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}परहिरो"),
            keywords: &[
                "उत\u{94d}तम",
                "स\u{941}परपावर",
                "स\u{941}परहिरो",
                "हिरो",
                "हिरोईन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("супер баатыр"),
            keywords: &[
                "баатыр",
                "баатыр кыз",
                "жакшы",
                "супер баатыр",
                "эбегейсиз зор күч",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb8}ດຍອດພະເອກ"),
            keywords: &[
                "ຈອມພະລ\u{eb1}ງ",
                "ດ\u{eb5}",
                "ບ\u{eb1}ນຈອມພະລ\u{eb1}ງ",
                "ພະເອກ",
                "ມາດພະເອກ",
                "ສ\u{eb8}ດຍອດພະເອກ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("superherojus"),
            keywords: &["geras", "herojus", "herojė", "supergalia", "superherojus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("supervaronis"),
            keywords: &["labais", "superspēks", "supervaronis", "varone", "varonis"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("суперхерој"),
            keywords: &["добро", "суперсила", "суперхерој", "хероина", "херој"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}പ\u{d4d}പർഹീറോ"),
            keywords: &[
                "അമ\u{d3e}ന\u{d41}ഷികശക\u{d4d}തി",
                "നല\u{d4d}ലത\u{d4d}",
                "ന\u{d3e}യകൻ",
                "ന\u{d3e}യിക",
                "സ\u{d42}പ\u{d4d}പർഹീറോ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("супер баатар"),
            keywords: &["баатар", "сайн", "супер баатар", "супер хүч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{941}परहिरो"),
            keywords: &["छान", "स\u{941}परपॉवर", "स\u{941}परहिरो", "हिरो", "हिरोइन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("adiwira"),
            keywords: &[
                "adi wira",
                "adiwira",
                "baik",
                "sangat berkuasa",
                "wira",
                "wirawati",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း"),
            keywords: &[
                "ကောင\u{103a}းမ\u{103d}န\u{103a}ခြင\u{103a}း",
                "လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း",
                "သ\u{1030}ရ\u{1032}ကောင\u{103a}း",
                "အစ\u{103d}မ\u{103a}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("superhelt"),
            keywords: &["god", "helt", "heltinne", "superhelt", "superkrefter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}परहिरो"),
            keywords: &[
                "राम\u{94d}रो",
                "स\u{941}परपावर",
                "स\u{941}परहिरो",
                "हिरो",
                "हिरोइन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("superheld"),
            keywords: &["goed", "held", "heldin", "superheld", "superkrachten"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("superhelt"),
            keywords: &["god", "helt", "heltinne", "superhelt", "superkrefter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b41}ପର\u{b4d}\u{200c}ହ\u{b3f}ରୋ"),
            keywords: &[
                "ଭଲ",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ପ\u{b3e}ୱ\u{b3e}ର",
                "ସ\u{b41}ପର\u{b4d}\u{200c}ହ\u{b3f}ରୋ",
                "ହ\u{b3f}ରୋ",
                "ହ\u{b3f}ରୋଇନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}ਪਰ-ਹੀਰ\u{a4b}"),
            keywords: &[
                "ਵਧੀਆ",
                "ਸ\u{a41}ਪਰ-ਹੀਰ\u{a4b}",
                "ਸ\u{a41}ਪਰਪਾਵਰ",
                "ਹੀਰ\u{a4b}",
                "ਹੀਰ\u{a4b}ਇਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Supahíro"),
            keywords: &["Bẹtá", "Gud", "Híro", "Supahíro", "Supapáwa", "Wúmán Híro"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("superbohater"),
            keywords: &[
                "bohater",
                "bohaterka",
                "pozytywny",
                "superbohater",
                "supermoc",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوي اتل"),
            keywords: &["اتل", "اتله", "لوي اتل", "لوي قوت", "ښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("super-herói"),
            keywords: &[
                "boa",
                "bom",
                "heroína",
                "herói",
                "super-herói",
                "superpoder",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bom", "heroína", "herói", "super-herói", "superpoder"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("superheroe"),
            keywords: &["allin", "heroe", "heroina", "superheroe", "superpoder"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("supererou"),
            keywords: &[
                "bun",
                "eroină",
                "erou",
                "supererou",
                "superputere",
                "superputeri",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-041"),
            keywords: &["E11-041"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("супергерой"),
            keywords: &["героиня", "герой", "супергерой", "супермен", "суперсила"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سپر هيرو"),
            keywords: &["بهترين", "سپر هيرو", "سپر پاور", "هيرو", "هيروئين"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ප\u{dd2}ර\u{dd2} ව\u{dd3}රය\u{dcf}"),
            keywords: &[
                "ව\u{dd3}රයෙක\u{dca}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} බලයක\u{dca}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} ව\u{dd3}රය\u{dcf}",
                "හෙරෝය\u{dd2}න\u{dca}",
                "හොඳය\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("superhrdina"),
            keywords: &[
                "hrdina",
                "hrdinka",
                "superhrdina",
                "superschopnosť",
                "superčlovek",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("superjunak/superjunakinja"),
            keywords: &[
                "dober",
                "junak",
                "junakinja",
                "super moč",
                "superjunak/superjunakinja",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("halyeey ah"),
            keywords: &[
                "awood sareeysa",
                "geesi",
                "geesiyad",
                "halyeey ah",
                "wanaagsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("superhero"),
            keywords: &["hero", "heroinë", "superfuqi", "superhero", "zemërmirë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("супер херој"),
            keywords: &["добро", "супер моћ", "супер херој", "херој"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("суперхерој"),
            keywords: &["суперхерој"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("super heroj"),
            keywords: &["dobro", "heroj", "super heroj", "super moć"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("superheroj"),
            keywords: &["superheroj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("superhjälte"),
            keywords: &[
                "god",
                "hjälte",
                "hjältinna",
                "superhjälte",
                "superkraft",
                "superkrafter",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shujaa"),
            keywords: &[
                "mzuri",
                "nguvu zisizo za kawaida",
                "shujaa",
                "shujaa wa kike",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூப\u{bcd}பர\u{bcd}ஹ\u{bc0}ரோ"),
            keywords: &[
                "சூப\u{bcd}பர\u{bcd}பவர\u{bcd}",
                "சூப\u{bcd}பர\u{bcd}ஹ\u{bc0}ரோ",
                "நல\u{bcd}லவர\u{bcd}",
                "ஹ\u{bc0}ரோ",
                "ஹ\u{bc0}ரோயின\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సూపర\u{c4d}\u{200c}హ\u{c40}ర\u{c4b}"),
            keywords: &[
                "మంచ\u{c3f}",
                "సూపర\u{c4d}\u{200c}పవర\u{c4d}",
                "సూపర\u{c4d}\u{200c}హ\u{c40}ర\u{c4b}",
                "హ\u{c40}ర\u{c4b}",
                "హ\u{c40}ర\u{c4b}య\u{c3f}న\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซ\u{e38}ปเปอร\u{e4c}ฮ\u{e35}โร\u{e48}"),
            keywords: &[
                "จอมพล\u{e31}ง",
                "ซ\u{e38}ปเปอร\u{e4c}ฮ\u{e35}โร\u{e48}",
                "ฮ\u{e35}โร\u{e48}",
                "เก\u{e48}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("supergahryman"),
            keywords: &["gahryman", "gowy", "supergahryman", "supergüýç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ivimālohi"),
            keywords: &["tokotaha ivimālohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("süper kahraman"),
            keywords: &[
                "iyi",
                "kadın kahraman",
                "kahraman",
                "süper güç",
                "süper kahraman",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("супергерой"),
            keywords: &["герой", "героїня", "добро", "супергерой", "суперсила"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سپر ہیرو"),
            keywords: &["اچھا", "سپر پاور", "سپر ہیرو", "ہیرو", "ہیروئن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("superqahramon"),
            keywords: &["qahramon", "superkuch", "supermen", "superqahramon", "zo‘r"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("siêu anh hùng"),
            keywords: &[
                "anh hùng",
                "nữ anh hùng",
                "siêu anh hùng",
                "siêu năng lực",
                "tốt",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("超人"),
            keywords: &["好", "英雄", "超人", "超級"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("超人"),
            keywords: &["好", "英雄", "超人", "超级"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("超级英雄"),
            keywords: &["女英雄", "好人", "英雄", "超级英雄", "超能力"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("超級英雄"),
            keywords: &["天賦", "女英雄", "英雄", "超級英雄", "超能力"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("超人"),
            keywords: &["天賦", "英雄", "超人", "超能力"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqhawe"),
            keywords: &["good", "hero", "heroine", "iqhawe", "superpower"],
        },
    ],
};
#[doc = "🦸🏻"]
pub const SUPERHERO_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏻",
    codepoint: "1F9B8 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "superhero: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦸🏼"]
pub const SUPERHERO_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏼",
    codepoint: "1F9B8 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "superhero: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦸🏽"]
pub const SUPERHERO_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏽",
    codepoint: "1F9B8 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "superhero: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦸🏾"]
pub const SUPERHERO_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏾",
    codepoint: "1F9B8 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "superhero: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦸🏿"]
pub const SUPERHERO_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏿",
    codepoint: "1F9B8 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "superhero: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦸\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERHERO: crate::Emoji = crate::Emoji {
    glyph: "🦸\u{200d}♂\u{fe0f}",
    codepoint: "1F9B8 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man superhero",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸\u{200d}♂",
        codepoint: "1F9B8 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man superhero",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike superheld"),
            keywords: &["goeie", "held", "man", "manlike superheld", "superkrag"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ ጀግና"),
            keywords: &["ወንድ", "የወንድ ጀግና", "ጀግና", "ጥሩ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطل خارق رجل"),
            keywords: &["بطل", "بطل خارق رجل", "رجل", "طيب", "قوة خارقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ চ\u{9c1}প\u{9be}ৰহিৰ’"),
            keywords: &[
                "চ\u{9c1}প\u{9be}ৰপ\u{9be}ৱ\u{9be}ৰ",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ চ\u{9c1}প\u{9be}ৰহিৰ’",
                "ভ\u{9be}ল",
                "হিৰ’",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi superqəhrəman"),
            keywords: &[
                "kişi",
                "kişi superqəhrəman",
                "qəhrəman",
                "supergüc",
                "xeyirxah",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-супергерой"),
            keywords: &[
                "герой",
                "дабро",
                "мужчына",
                "мужчына-супергерой",
                "суперсіла",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("супергерой"),
            keywords: &["герой", "добър", "супергерой", "супермен", "суперсила"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ স\u{9c1}প\u{9be}রহিরো"),
            keywords: &[
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ স\u{9c1}প\u{9be}রহিরো",
                "ভ\u{9be}লো",
                "স\u{9c1}প\u{9be}রপ\u{9be}ওয\u{9bc}\u{9be}র",
                "হিরো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("superheroj muškarac"),
            keywords: &[
                "dobro",
                "heroj",
                "muškarac",
                "superheroj muškarac",
                "supermoć",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home superheroi"),
            keywords: &["bo", "heroi", "home", "home superheroi", "superpoder"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏄᎬᏫᏳᏒᎩ ᏩᏥᎸᏉᏛ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ ᏄᎬᏫᏳᏒᎩ ᏩᏥᎸᏉᏛ", "ᎣᏍᏓ", "ᏄᎬᏫᏳᏒᎩ ᎤᏟᏂᎩᏓ", "ᏩᏥᎸᏉᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("superhrdina"),
            keywords: &[
                "hrdina",
                "kladná postava",
                "muž",
                "superhrdina",
                "superschopnost",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("archarwr gwrywaidd"),
            keywords: &["archarwr gwrywaidd", "archbŵer", "arwr", "da", "dyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig superhelt"),
            keywords: &["god", "helt", "mand", "mandlig superhelt", "superkraft"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Superheld"),
            keywords: &["Held", "Superheld"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας υπερήρωας"),
            keywords: &["άντρας", "άντρας υπερήρωας", "ήρωας", "καλός", "υπερδύναμη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man superhero"),
            keywords: &["good", "hero", "man", "man superhero", "superpower"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("superhéroe"),
            keywords: &[
                "bueno",
                "hombre",
                "héroe",
                "superhombre",
                "superhéroe",
                "superpoder",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("superhéroe"),
            keywords: &["bien", "hombre", "héroe", "superhéroe", "superpoder"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("superhéroe"),
            keywords: &["superhéroe"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeskangelane"),
            keywords: &["hea", "kangelane", "mees", "meeskangelane", "supervõimed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizonezko superheroi"),
            keywords: &[
                "gizon",
                "gizonezko superheroi",
                "heroi",
                "on",
                "superbotere",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابرقهرمان مرد"),
            keywords: &[
                "ابرقدرت",
                "ابرقهرمان",
                "ابرقهرمان مرد",
                "خوب",
                "دلاور",
                "شیرمرد",
                "قهرمان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miessupersankari"),
            keywords: &[
                "hyvis",
                "hyvä",
                "miessupersankari",
                "sankari",
                "supervoimat",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking superhero"),
            keywords: &[
                "hero",
                "lalaki",
                "lalaking superhero",
                "malakas",
                "superhero",
                "superpower",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannlig superhetja"),
            keywords: &[
                "góður",
                "hetja",
                "mannlig superhetja",
                "maður",
                "super",
                "yvirnát´úrligur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("super-héros homme"),
            keywords: &[
                "bien",
                "homme",
                "héros",
                "super-héros homme",
                "super-pouvoir",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("super-héros"),
            keywords: &["super-héros"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear-sárlaoch"),
            keywords: &["fear", "fear-sárlaoch", "laoch", "maith", "sárchumhacht"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàr-ghaisgeach fireann"),
            keywords: &[
                "cumhachd",
                "fireannach",
                "gaisgeach",
                "math",
                "oil-chumhachd",
                "super",
                "sàr-ghaisgeach",
                "sàr-ghaisgeach fireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("superheroe"),
            keywords: &["heroe", "home", "superheroe", "superpoderes"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ સ\u{ac1}પરહીરો"),
            keywords: &[
                "ગ\u{ac1}ણવાન",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ સ\u{ac1}પરહીરો",
                "સ\u{ac1}પરપાવર",
                "હીરો",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סופרמן"),
            keywords: &["גיבור", "גיבור על", "סופרמן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष स\u{941}परहीरो"),
            keywords: &[
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष स\u{941}परहीरो",
                "बढ\u{93c}िया",
                "स\u{941}परपॉवर",
                "हीरो",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("superjunak"),
            keywords: &[
                "dobročinitelj",
                "junak",
                "muškarac",
                "superjunak",
                "supermoći",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi szuperhős"),
            keywords: &[
                "férfi",
                "férfi szuperhős",
                "hős",
                "hősnő",
                "jó",
                "szuperképesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ սուպերհերոս"),
            keywords: &["գերուժ", "լավ", "հերոս", "տղամարդ", "տղամարդ սուպերհերոս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pahlawan super pria"),
            keywords: &[
                "baik",
                "kekuatan super",
                "pahlawan",
                "pahlawan super pria",
                "pria",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ofurmaður"),
            keywords: &["góður", "hetja", "maður", "ofurkraftur", "ofurmaður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("supereroe uomo"),
            keywords: &["eroe", "supereroe", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性のスーパーヒーロー"),
            keywords: &["ヒーロー", "善", "男性", "男性のスーパーヒーロー", "超人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("satriya mandraguna lanang"),
            keywords: &[
                "becik",
                "kadigdayan linuwih",
                "lanang",
                "satriya",
                "satriya mandraguna lanang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სუპერგმირი კაცი"),
            keywords: &["გმირი", "ზებუნებრივი", "კაცი", "კეთილი", "სუპერგმირი კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("еркек супер батыр"),
            keywords: &["батыр", "ер", "еркек супер батыр", "жақсы", "супер күш"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b8}រប\u{17bb}រស"),
            keywords: &[
                "ថាមពលព\u{17b7}សេស",
                "នារ\u{17b8}",
                "ល\u{17d2}អ",
                "វ\u{17b8}រនារ\u{17b8}",
                "វ\u{17b8}រប\u{17bb}រស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಹೀರೊ"),
            keywords: &[
                "ಉತ\u{ccd}ತಮ",
                "ಪುರುಷ",
                "ಪುರುಷ ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಹೀರೊ",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಪವರ\u{ccd}",
                "ಹೀರೊ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 히어로"),
            keywords: &["남자", "정의", "초능력", "히어로"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो स\u{941}परहिरो"),
            keywords: &[
                "उत\u{94d}तम",
                "दादलो",
                "दादलो स\u{941}परहिरो",
                "स\u{941}परपावर",
                "हिरो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("баатыр жигит"),
            keywords: &["баатыр", "жакшы", "жигит", "эбегейсиз зор күч"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະເອກຍອດຊາຍ"),
            keywords: &[
                "ຈອມພະລ\u{eb1}ງ",
                "ດ\u{eb5}",
                "ບ\u{eb8}ລ\u{eb8}ດ",
                "ພະເອກ",
                "ພະເອກຍອດຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyras superherojus"),
            keywords: &[
                "geras",
                "herojus",
                "supergalia",
                "vyras",
                "vyras superherojus",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis supervaronis"),
            keywords: &[
                "labais",
                "superspēks",
                "varonis",
                "vīrietis",
                "vīrietis supervaronis",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж суперхерој"),
            keywords: &["добро", "маж", "маж суперхерој", "суперсила", "херој"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ൻ സ\u{d42}പ\u{d4d}പർഹീറോ"),
            keywords: &[
                "അമ\u{d3e}ന\u{d41}ഷികശക\u{d4d}തി",
                "നല\u{d4d}ലത\u{d4d}",
                "ന\u{d3e}യകൻ",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "മ\u{d3e}ൻ സ\u{d42}പ\u{d4d}പർഹീറോ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй супер баатар"),
            keywords: &[
                "баатар",
                "сайн",
                "супер хүч",
                "эрэгтэй",
                "эрэгтэй супер баатар",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष स\u{941}परहिरो"),
            keywords: &[
                "छान",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष स\u{941}परहिरो",
                "स\u{941}परपॉवर",
                "हीरो",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("adi wira lelaki"),
            keywords: &[
                "adi wira lelaki",
                "baik",
                "lelaki",
                "sangat berkuasa",
                "wira",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း"),
            keywords: &[
                "ကောင\u{103a}မ\u{103d}န\u{103a}သော",
                "သ\u{1030}ရ\u{1032}ကောင\u{103a}း",
                "အစ\u{103d}မ\u{103a}း",
                "အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig superhelt"),
            keywords: &["god", "helt", "mann", "mannlig superhelt", "superkrefter"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरामान\u{94d}छ\u{947} स\u{941}परहिरो"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947}",
                "छोरामान\u{94d}छ\u{947} स\u{941}परहिरो",
                "राम\u{94d}रो",
                "स\u{941}परपावर",
                "हिरो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke superheld"),
            keywords: &[
                "goed",
                "held",
                "man",
                "mannelijke superheld",
                "superkrachten",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg superhelt"),
            keywords: &["god", "helt", "mann", "mannleg superhelt", "superkrefter"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ସ\u{b41}ପର\u{b4d}\u{200c} ହ\u{b3f}ରୋ"),
            keywords: &[
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ସ\u{b41}ପର\u{b4d}\u{200c} ହ\u{b3f}ରୋ",
                "ଭଲ",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ପ\u{b3e}ୱ\u{b3e}ର",
                "ହ\u{b3f}ରୋ",
                "ହ\u{b3f}ରୋଇନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਸ\u{a41}ਪਰਹੀਰ\u{a4b}"),
            keywords: &[
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਸ\u{a41}ਪਰਹੀਰ\u{a4b}",
                "ਵਧੀਆ",
                "ਸ\u{a41}ਪਰਪਾਵਰ",
                "ਹੀਰ\u{a4b}",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Supahíro"),
            keywords: &["Bẹtá", "Gud", "Híro", "Man", "Mán Supahíro", "Supapáwa"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna superbohater"),
            keywords: &[
                "bohater",
                "mężczyzna",
                "mężczyzna superbohater",
                "pozytywny",
                "supermoc",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی لوي اتل"),
            keywords: &["اتل", "سړی", "سړی لوي اتل", "لوي قوت", "ښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem super-herói"),
            keywords: &["bom", "herói", "homem", "homem super-herói", "superpoder"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bom", "herói", "homem", "homem super-herói", "superpoder"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa superheroe"),
            keywords: &["allin", "heroe", "runa", "runa superheroe", "superpoder"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("supererou bărbat"),
            keywords: &["bun", "bărbat", "erou", "supererou bărbat", "superputere"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-043"),
            keywords: &["E11-043"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-супергерой"),
            keywords: &[
                "герой",
                "мужчина-супергерой",
                "супергерой",
                "супермен",
                "суперсила",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد سپر هيرو"),
            keywords: &["بهترين", "سپر پاور", "مرد", "مرد سپر هيرو", "هيرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}න\u{dd2}ස\u{dcf} ස\u{dd4}ප\u{dd2}ර\u{dd2} ව\u{dd3}රය\u{dcf}"),
            keywords: &[
                "ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "ම\u{dd2}න\u{dd2}ස\u{dcf} ස\u{dd4}ප\u{dd2}ර\u{dd2} ව\u{dd3}රය\u{dcf}",
                "ව\u{dd3}රයෙක\u{dca}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} බලවත\u{dcf}",
                "හොඳය\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("supermuž"),
            keywords: &["hrdina", "muž", "supermuž", "superschopnosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("superjunak"),
            keywords: &["dober", "junak", "moški", "super moč", "superjunak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin halyeey ah"),
            keywords: &[
                "awood sareeysa",
                "geesi",
                "nin",
                "nin halyeey ah",
                "wanaagsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë superhero"),
            keywords: &[
                "burrë",
                "burrë superhero",
                "hero",
                "heroinë",
                "superfuqi",
                "zemërmirë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац супер херој"),
            keywords: &[
                "добро",
                "мушкарац",
                "мушкарац супер херој",
                "супер моћ",
                "херој",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("мушкарац суперхерој"),
            keywords: &["мушкарац суперхерој"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac super heroj"),
            keywords: &[
                "dobro",
                "heroj",
                "muškarac",
                "muškarac super heroj",
                "super moć",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("muškarac superheroj"),
            keywords: &["muškarac superheroj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig superhjälte"),
            keywords: &["god", "hjälte", "man", "manlig superhjälte", "superkraft"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shujaa wa kiume"),
            keywords: &[
                "mwanamume",
                "mzuri",
                "nguvu zisizo za kawaida",
                "shujaa",
                "shujaa wa kiume",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} சூப\u{bcd}பர\u{bcd} ஹ\u{bc0}ரோ"),
            keywords: &[
                "ஆண\u{bcd}",
                "ஆண\u{bcd} சூப\u{bcd}பர\u{bcd} ஹ\u{bc0}ரோ",
                "சூப\u{bcd}பர\u{bcd}பவர\u{bcd}",
                "நல\u{bcd}லவர\u{bcd}",
                "ஹ\u{bc0}ரோ",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}న\u{c4d} సూపర\u{c4d}\u{200c}హ\u{c40}ర\u{c4b}"),
            keywords: &[
                "మంచ\u{c3f}",
                "మ\u{c46}న\u{c4d} సూపర\u{c4d}\u{200c}హ\u{c40}ర\u{c4b}",
                "మ\u{c4d}య\u{c3e}న\u{c4d}",
                "సూపర\u{c4d}\u{200c}పవర\u{c4d}",
                "హ\u{c40}ర\u{c4b}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พระเอก"),
            keywords: &[
                "จอมพล\u{e31}ง",
                "ต\u{e31}วพ\u{e48}อ",
                "ผ\u{e39}\u{e49}ชาย",
                "พระเอก",
                "ฮ\u{e35}โร\u{e48}",
                "เก\u{e48}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek supergahryman"),
            keywords: &[
                "erkek adam",
                "erkek supergahryman",
                "gahryman",
                "gowy",
                "supergüýç",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata ivimālohi"),
            keywords: &["tangata ivimālohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek süper kahraman"),
            keywords: &[
                "erkek",
                "erkek süper kahraman",
                "iyi",
                "kahraman",
                "süper güç",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-супергерой"),
            keywords: &[
                "герой",
                "добро",
                "суперсила",
                "чоловік",
                "чоловік-супергерой",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد سپر ہیرو"),
            keywords: &["اچھا", "سپر پاور", "مرد", "مرد سپر ہیرو", "ہیرو"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak qahramon"),
            keywords: &[
                "erkak qahramon",
                "qahramon",
                "superkuch",
                "supermen",
                "zo‘r",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nam siêu anh hùng"),
            keywords: &[
                "anh hùng",
                "nam giới",
                "nam siêu anh hùng",
                "siêu năng lực",
                "tốt",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男超人"),
            keywords: &["好", "男", "男超人", "英雄", "超級"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男超人"),
            keywords: &["好", "男", "男超人", "英雄", "超级"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男超级英雄"),
            keywords: &["好人", "男人", "男超级英雄", "英雄", "超能力"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("超人"),
            keywords: &["天賦", "男人", "英雄", "超人", "超能力"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男超人"),
            keywords: &["天賦", "男", "男超人", "英雄", "超人", "超能力"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("man superhero"),
            keywords: &["good", "hero", "man", "man superhero", "superpower"],
        },
    ],
};
#[doc = "🦸🏻\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERHERO_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9B8 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man superhero: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏻\u{200d}♂",
        codepoint: "1F9B8 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man superhero: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏼\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9B8 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man superhero: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏼\u{200d}♂",
        codepoint: "1F9B8 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man superhero: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏽\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERHERO_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9B8 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man superhero: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏽\u{200d}♂",
        codepoint: "1F9B8 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man superhero: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏾\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9B8 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man superhero: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏾\u{200d}♂",
        codepoint: "1F9B8 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man superhero: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏿\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERHERO_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9B8 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man superhero: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏿\u{200d}♂",
        codepoint: "1F9B8 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man superhero: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERHERO: crate::Emoji = crate::Emoji {
    glyph: "🦸\u{200d}♀\u{fe0f}",
    codepoint: "1F9B8 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman superhero",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸\u{200d}♀",
        codepoint: "1F9B8 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman superhero",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike superheld"),
            keywords: &["goeie", "held", "heldin", "superkrag", "vroulike superheld"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ጀግና"),
            keywords: &["ሴት", "የሴት ጀግና", "ጀግና", "ጥሩ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بطلة خارقة"),
            keywords: &["بطل", "بطلة", "بطلة خارقة", "سيدة", "طيب", "قوة خارقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} চ\u{9c1}প\u{9be}ৰহিৰ’"),
            keywords: &[
                "চ\u{9c1}প\u{9be}ৰপ\u{9be}ৱ\u{9be}ৰ",
                "ভ\u{9be}ল",
                "মহিল\u{9be}",
                "মহিল\u{9be} চ\u{9c1}প\u{9be}ৰহিৰ’",
                "হিৰ’",
                "হিৰ’ইন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın superqəhrəman"),
            keywords: &[
                "qadın",
                "qadın superqəhrəman",
                "qəhrəman",
                "supergüc",
                "xeyirxah",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына-супергерой"),
            keywords: &[
                "гераіня",
                "герой",
                "дабро",
                "жанчына",
                "жанчына-супергерой",
                "суперсіла",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("супергерой от женски пол"),
            keywords: &[
                "героиня",
                "герой",
                "жена",
                "праведна",
                "способности",
                "супергерой от женски пол",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} স\u{9c1}প\u{9be}রহিরো"),
            keywords: &[
                "ভ\u{9be}লো",
                "মহিল\u{9be}",
                "মহিল\u{9be} স\u{9c1}প\u{9be}রহিরো",
                "স\u{9c1}প\u{9be}রপ\u{9be}ওয\u{9bc}\u{9be}র",
                "হিরো",
                "হিরোইন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("superheroj žena"),
            keywords: &["dobro", "heroina", "heroj", "superheroj žena", "supermoć"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona superheroïna"),
            keywords: &["bo", "dona", "dona superheroïna", "heroïna", "superpoder"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏄᎬᏫᏳᏒᎩ ᏩᏥᎸᏉᏛ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᏄᎬᏫᏳᏒᎩ ᏩᏥᎸᏉᏛ",
                "ᎣᏍᏓ",
                "ᏄᎬᏫᏳᏒᎩ ᎤᏟᏂᎩᏓ",
                "ᏩᏥᎸᏉᏛ",
                "ᏬᏂᎸᏉᏛᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("superhrdinka"),
            keywords: &[
                "hrdinka",
                "kladná postava",
                "superhrdina",
                "superhrdinka",
                "superschopnost",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("archarwr benywaidd"),
            keywords: &[
                "archarwr benywaidd",
                "archbŵer",
                "arwr",
                "arwres",
                "da",
                "menyw",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig superhelt"),
            keywords: &[
                "god",
                "helt",
                "heltinde",
                "kvinde",
                "kvindelig superhelt",
                "superkraft",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Heldin"),
            keywords: &["Heldin", "Superheldin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα υπερήρωας"),
            keywords: &[
                "ήρωας",
                "γυναίκα",
                "γυναίκα υπερήρωας",
                "ηρωίδα",
                "καλή",
                "υπερδύναμη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman superhero"),
            keywords: &[
                "good",
                "hero",
                "heroine",
                "superpower",
                "woman",
                "woman superhero",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("superheroína"),
            keywords: &[
                "heroína",
                "héroe",
                "mujer",
                "superheroína",
                "superhéroe",
                "superpoder",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mujer superheroína"),
            keywords: &[
                "bien",
                "heroína",
                "héroe",
                "mujer",
                "mujer superheroína",
                "superpoder",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mujer superheroína"),
            keywords: &["mujer superheroína"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naissuperkangelane"),
            keywords: &[
                "hea",
                "kangelane",
                "kangelanna",
                "naine",
                "naissuperkangelane",
                "supervõimed",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumezko superheroi"),
            keywords: &[
                "emakume",
                "emakumezko superheroi",
                "heroi",
                "on",
                "superbotere",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابرقهرمان زن"),
            keywords: &[
                "ابرقدرت",
                "ابرقهرمان",
                "ابرقهرمان زن",
                "خوب",
                "دلاور",
                "شیرزن",
                "قهرمان",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naissupersankari"),
            keywords: &[
                "hyvis",
                "hyvä",
                "naissupersankari",
                "sankari",
                "sankaritar",
                "supervoimat",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng superhero"),
            keywords: &[
                "babae",
                "babaeng superhero",
                "hero",
                "superhero",
                "superpower",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnulig superhetja"),
            keywords: &[
                "góð",
                "hetja",
                "kvinnulig superhetja",
                "super",
                "yvirnátúrlig",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("super-héroïne"),
            keywords: &[
                "bien",
                "femme",
                "héros",
                "héroïne",
                "super-héroïne",
                "super-pouvoir",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bien, femme, héroïne, héros, super pouvoir",
                "super-héroïne",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ban-sárlaoch"),
            keywords: &[
                "ban-sárlaoch",
                "banloach",
                "bean",
                "laoch",
                "maith",
                "sárchumhacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàr-ghaisgeach boireann"),
            keywords: &[
                "boireannach",
                "cumhachd",
                "gaisgeach",
                "math",
                "oil-chumhachd",
                "super",
                "sàr-ghaisgeach",
                "sàr-ghaisgeach boireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("superheroína"),
            keywords: &["heroe", "heroína", "muller", "superheroína", "supermuller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી સ\u{ac1}પરહીરો"),
            keywords: &[
                "ગ\u{ac1}ણવાન",
                "સ\u{ac1}પરપાવર",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી સ\u{ac1}પરહીરો",
                "હીરો",
                "હીરોઇન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("סופרוומן"),
            keywords: &["אישה", "גיבורה", "גיבורת על", "סופרוומן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला स\u{941}परहीरो"),
            keywords: &[
                "बढ\u{93c}िया",
                "महिला",
                "महिला स\u{941}परहीरो",
                "स\u{941}परपॉवर",
                "हीरो",
                "हीरोइन",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("superjunakinja"),
            keywords: &[
                "dobročinitelj",
                "junak",
                "junakinja",
                "superjunakinja",
                "supermoći",
                "žena",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női szuperhős"),
            keywords: &[
                "hős",
                "hősnő",
                "jó",
                "nő",
                "női szuperhős",
                "szuperképesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին սուպերհերոս"),
            keywords: &["գերուժ", "լավ", "կին սուպերհերոս", "հերոս", "հերոսուհի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pahlawan super wanita"),
            keywords: &[
                "baik",
                "kekuatan super",
                "pahlawan",
                "pahlawan super wanita",
                "wanita",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ofurkona"),
            keywords: &[
                "góð",
                "hetja",
                "kona",
                "kvenhetja",
                "ofurkona",
                "ofurkraftur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("supereroina"),
            keywords: &["donna", "supereroina", "superpoteri"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性のスーパーヒーロー"),
            keywords: &[
                "ヒロイン",
                "ヒーロー",
                "善",
                "女性",
                "女性のスーパーヒーロー",
                "超人",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("srikandhi"),
            keywords: &[
                "becik",
                "kadigdayan linuwih",
                "satriya",
                "srikandhi",
                "wadon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სუპერგმირი ქალი"),
            keywords: &[
                "გმირი",
                "გმირი ქალი",
                "ზებუნებრივი",
                "კეთილი",
                "სუპერგმირი ქალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("батыр әйел"),
            keywords: &["батыр", "жақсы", "супер күш", "әйел"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("វ\u{17b8}រនារ\u{17b8}"),
            keywords: &[
                "ថាមពលព\u{17b7}សេស",
                "នារ\u{17b8}",
                "ល\u{17d2}អ",
                "វ\u{17b8}រនារ\u{17b8}",
                "វ\u{17b8}រប\u{17bb}រស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳಾ ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಹೀರೊ"),
            keywords: &[
                "ಉತ\u{ccd}ತಮ",
                "ಮಹ\u{cbf}ಳಾ ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಹೀರೊ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಪವರ\u{ccd}",
                "ಹೀರೊ",
                "ಹೀರೊಯ\u{cbf}ನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 히어로"),
            keywords: &["여성", "여자 히어로", "정의", "초능력", "히로인", "히어로"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल स\u{941}परहिरो"),
            keywords: &[
                "उत\u{94d}तम",
                "बायल",
                "बायल स\u{941}परहिरो",
                "स\u{941}परपावर",
                "हिरो",
                "हिरोईन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("супер баатыр кыз"),
            keywords: &[
                "аял",
                "баатыр",
                "баатыр кыз",
                "жакшы",
                "супер баатыр кыз",
                "эбегейсиз зор күч",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສ\u{eb8}ດຍອດນາງເອກ"),
            keywords: &[
                "ຈອມພະລ\u{eb1}ງ",
                "ດ\u{eb5}",
                "ພະເອກ",
                "ມາດນາງເອກ",
                "ສ\u{eb8}ດຍອດນາງເອກ",
                "ແມ\u{ec8}ຍ\u{eb4}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteris superherojė"),
            keywords: &[
                "geras",
                "herojus",
                "herojė",
                "moteris",
                "moteris superherojė",
                "supergalia",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete supervarone"),
            keywords: &[
                "labais",
                "sieviete",
                "sieviete supervarone",
                "superspēks",
                "varone",
                "varonis",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена-суперхерој"),
            keywords: &[
                "добро",
                "жена",
                "жена-суперхерој",
                "суперсила",
                "хероина",
                "херој",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d41}മൺ സ\u{d42}പ\u{d4d}പർഹീറോ"),
            keywords: &[
                "അമ\u{d3e}ന\u{d41}ഷികശക\u{d4d}തി",
                "നല\u{d4d}ലത\u{d4d}",
                "ന\u{d3e}യകൻ",
                "ന\u{d3e}യിക",
                "വ\u{d41}മൺ സ\u{d42}പ\u{d4d}പർഹീറോ",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй супер баатар"),
            keywords: &["баатар", "сайн", "супер хүч", "эмэгтэй супер баатар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला स\u{941}परहिरो"),
            keywords: &[
                "छान",
                "महिला",
                "महिला स\u{941}परहिरो",
                "स\u{941}परपॉवर",
                "हीरो",
                "हीरोईन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("adi wira wanita"),
            keywords: &[
                "adi wira wanita",
                "baik",
                "sangat berkuasa",
                "wanita",
                "wira",
                "wirawati",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း"),
            keywords: &[
                "ကောင\u{103a}းမ\u{103d}န\u{103a}သော",
                "သ\u{1030}ရ\u{1032}ကောင\u{103a}း",
                "အစ\u{103d}မ\u{103a}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း လ\u{1030}စ\u{103d}မ\u{103a}းကောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig superhelt"),
            keywords: &[
                "god",
                "helt",
                "heltinne",
                "kvinne",
                "kvinnelig superhelt",
                "superkrefter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरीमान\u{94d}छ\u{947} स\u{941}परहिरो"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947}",
                "छोरीमान\u{94d}छ\u{947} स\u{941}परहिरो",
                "राम\u{94d}रो",
                "स\u{941}परपावर",
                "हिरो",
                "हिरोइन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke superheld"),
            keywords: &[
                "goed",
                "held",
                "heldin",
                "superkrachten",
                "vrouw",
                "vrouwelijke superheld",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg superhelt"),
            keywords: &[
                "god",
                "helt",
                "heltinne",
                "kvinne",
                "kvinneleg superhelt",
                "superkrefter",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ସ\u{b41}ପର\u{b4d}\u{200c} ହ\u{b3f}ରୋ"),
            keywords: &[
                "ଭଲ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ସ\u{b41}ପର\u{b4d}\u{200c} ହ\u{b3f}ରୋ",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ପ\u{b3e}ୱ\u{b3e}ର",
                "ହ\u{b3f}ରୋ",
                "ହ\u{b3f}ରୋଇନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਸ\u{a41}ਪਰਹੀਰ\u{a4b}"),
            keywords: &[
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਸ\u{a41}ਪਰਹੀਰ\u{a4b}",
                "ਵਧੀਆ",
                "ਸ\u{a41}ਪਰਪਾਵਰ",
                "ਹੀਰ\u{a4b}",
                "ਹੀਰ\u{a4b}ਇਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Supahíro"),
            keywords: &[
                "Bẹtá",
                "Gud",
                "Híro",
                "Supapáwa",
                "Wúman",
                "Wúman Supahíro",
                "Wúmán Híro",
                "Wúmán Supahíro",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta superbohater"),
            keywords: &[
                "bohaterka",
                "kobieta",
                "kobieta superbohater",
                "pozytywna",
                "supermoc",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه لوي اتله"),
            keywords: &["اتل", "اتله", "لوي اتل", "ښځه", "ښځه لوي اتله"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("super-heroína"),
            keywords: &[
                "boa",
                "heroína",
                "herói",
                "mulher",
                "super-heroína",
                "superpoder",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["boa", "heroína", "herói", "super-heroína", "superpoder"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi superheroe"),
            keywords: &[
                "allin",
                "heroe",
                "heroina",
                "superpoder",
                "warmi",
                "warmi superheroe",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("supererou femeie"),
            keywords: &[
                "bună",
                "eroină",
                "erou",
                "femeie",
                "supererou femeie",
                "superputere",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-042"),
            keywords: &["E11-042"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-супергерой"),
            keywords: &[
                "героиня",
                "женщина-супергерой",
                "супервумен",
                "супергероиня",
                "суперсила",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت سپر هيرو"),
            keywords: &[
                "بهترين",
                "سپر پاور",
                "عورت",
                "عورت سپر هيرو",
                "هيرو",
                "هيروئين",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf} ස\u{dd4}ප\u{dd2}ර\u{dd2} ව\u{dd3}රය\u{dcf}"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf} ස\u{dd4}ප\u{dd2}ර\u{dd2} ව\u{dd3}රය\u{dcf}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ව\u{dd3}රයෙක\u{dca}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} බලය",
                "හ\u{dd2}රෝය\u{dd2}න\u{dca}",
                "හොඳය\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("superžena"),
            keywords: &["hrdinka", "superschopnosť", "superžena", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("superjunakinja"),
            keywords: &["dober", "junak", "junakinja", "super moč", "superjunakinja"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("haweeney geesinnimadeedu sareeyso"),
            keywords: &[
                "awood sareeysa",
                "geesi",
                "geesiyad",
                "haweeney",
                "haweeney geesinnimadeedu sareeyso",
                "wanagsan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("superheroinë"),
            keywords: &[
                "grua",
                "hero",
                "heroinë",
                "superfuqi",
                "superheroinë",
                "zemërmirë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена супер херој"),
            keywords: &["добро", "жена", "жена супер херој", "супер моћ", "хероина"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("жена суперхерој"),
            keywords: &["жена суперхерој"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena super heroj"),
            keywords: &["dobro", "heroina", "super moć", "žena", "žena super heroj"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("žena superheroj"),
            keywords: &["žena superheroj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig superhjälte"),
            keywords: &[
                "god",
                "hjälte",
                "hjältinna",
                "kvinna",
                "kvinnlig superhjälte",
                "man",
                "superkraft",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("shujaa wa kike"),
            keywords: &[
                "mwanamke",
                "mzuri",
                "nguvu zisizo za kawaida",
                "shujaa",
                "shujaa wa kike",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} சூப\u{bcd}பர\u{bcd} ஹ\u{bc0}ரோ"),
            keywords: &[
                "சூப\u{bcd}பர\u{bcd}பவர\u{bcd}",
                "நல\u{bcd}லவர\u{bcd}",
                "பெண\u{bcd}",
                "பெண\u{bcd} சூப\u{bcd}பர\u{bcd} ஹ\u{bc0}ரோ",
                "ஹ\u{bc0}ரோ",
                "ஹ\u{bc0}ரோயின\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉమ\u{c46}న\u{c4d} సూపర\u{c4d}\u{200c}హ\u{c40}ర\u{c4b}"),
            keywords: &[
                "ఉమ\u{c46}న\u{c4d} సూపర\u{c4d}\u{200c}హ\u{c40}ర\u{c4b}",
                "మంచ\u{c3f}",
                "మ\u{c4d}య\u{c3e}న\u{c4d}",
                "సూపర\u{c4d}\u{200c}పవర\u{c4d}",
                "హ\u{c40}ర\u{c4b}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ยอดหญ\u{e34}ง"),
            keywords: &[
                "จอมพล\u{e31}ง",
                "ต\u{e31}วแม\u{e48}",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ยอดหญ\u{e34}ง",
                "ฮ\u{e35}โร\u{e48}",
                "เก\u{e48}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan supergahryman"),
            keywords: &[
                "gahryman",
                "gowy",
                "supergüýç",
                "zenan",
                "zenan supergahryman",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine ivimālohi"),
            keywords: &["fefine ivimālohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın süper kahraman"),
            keywords: &[
                "iyi",
                "kadın",
                "kadın süper kahraman",
                "kahraman",
                "süper güç",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-супергерой"),
            keywords: &[
                "герой",
                "добро",
                "жінка",
                "жінка-супергерой",
                "супер",
                "супервумен",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خاتون سپر ہیرو"),
            keywords: &[
                "اچھا",
                "خاتون سپر ہیرو",
                "سپر پاور",
                "عورت",
                "ہیرو",
                "ہیروئن",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol superqahramon"),
            keywords: &[
                "ayol",
                "ayol superqahramon",
                "qahramon",
                "superkuch",
                "zo‘r",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nữ siêu anh hùng"),
            keywords: &[
                "anh hùng",
                "nữ anh hùng",
                "nữ siêu anh hùng",
                "phụ nữ",
                "siêu năng lực",
                "tốt",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女超人"),
            keywords: &["女", "女超人", "好", "英雄", "超級"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女超人"),
            keywords: &["女", "女超人", "好", "英雄", "超级"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女超级英雄"),
            keywords: &["女人", "女超级英雄", "好人", "英雄", "超能力"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女超人"),
            keywords: &["天賦", "女英雄", "女超人", "英雄", "超能力"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["天賦", "女", "女超人", "英雄", "超人", "超能力"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("woman superhero"),
            keywords: &[
                "good",
                "hero",
                "heroine",
                "superpower",
                "woman",
                "woman superhero",
            ],
        },
    ],
};
#[doc = "🦸🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERHERO_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9B8 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman superhero: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏻\u{200d}♀",
        codepoint: "1F9B8 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman superhero: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERHERO_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9B8 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman superhero: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏼\u{200d}♀",
        codepoint: "1F9B8 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman superhero: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERHERO_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9B8 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman superhero: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏽\u{200d}♀",
        codepoint: "1F9B8 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman superhero: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERHERO_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9B8 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman superhero: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏾\u{200d}♀",
        codepoint: "1F9B8 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman superhero: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦸🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERHERO_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦸🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9B8 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman superhero: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦸🏿\u{200d}♀",
        codepoint: "1F9B8 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman superhero: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹"]
pub const SUPERVILLAIN: crate::Emoji = crate::Emoji {
    glyph: "🦹",
    codepoint: "1F9B9",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "supervillain",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("superskurk"),
            keywords: &["boos", "krimineel", "skurk", "superkrag", "superskurk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጀግና ምስል"),
            keywords: &["ሃያል", "ተንኮለኛ", "ክፉ", "ወንጀል", "የጀግና ምስል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شرير خارق"),
            keywords: &[
                "جريمة",
                "شر",
                "شرير",
                "شرير خارق",
                "شريرة",
                "قوة خارقة",
                "مجرم",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চ\u{9c1}প\u{9be}ৰভিলেইন"),
            keywords: &[
                "অপৰ\u{9be}ধী",
                "চ\u{9c1}প\u{9be}ৰপ\u{9be}ৱ\u{9be}ৰ",
                "চ\u{9c1}প\u{9be}ৰভিলেইন",
                "দ\u{9c1}ষ\u{9cd}ট",
                "ভিলেইন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("supercani"),
            keywords: &["cani", "cinayətkar", "pis", "supercani", "supergüc"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("суперзлачынца"),
            keywords: &["злачынца", "зло", "ліхадзей", "суперзлачынца", "суперсіла"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("суперзлодей"),
            keywords: &["зло", "злодей", "престъпник", "суперзлодей", "суперсила"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("স\u{9c1}প\u{9be}রভিলেন"),
            keywords: &[
                "অসৎ",
                "উৎস\u{9c1}ক",
                "ভিলেন",
                "স\u{9c1}প\u{9be}রপ\u{9be}ওয\u{9bc}\u{9be}র",
                "স\u{9c1}প\u{9be}রভিলেন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("super zlikovac"),
            keywords: &[
                "kriminalac",
                "super zlikovac",
                "supermoć",
                "zlikovac",
                "zlo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("superdolent"),
            keywords: &["criminal", "dolent", "malvat", "superdolent", "superpoder"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏄᎬᏫᏳᏒᎩ ᎠᏍᎦᏂ"),
            keywords: &["ᎠᏍᎦᏂ", "ᎤᏍᎦᏅᏨᎯ ᎨᏒᎢ", "ᎤᏐᏅᎢ", "ᏄᎬᏫᏳᏒᎩ ᎠᏍᎦᏂ", "ᏄᎬᏫᏳᏒᎩ ᎤᏟᏂᎩᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("superzločinec"),
            keywords: &[
                "superpadouch",
                "superschopnost",
                "superzloduch",
                "superzločinec",
                "zločinec",
                "záporná postava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("archleidr"),
            keywords: &["archbŵer", "archleidr", "drwg", "dyn drwg", "troseddwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("superskurk"),
            keywords: &["kriminel", "ond", "skurk", "superkraft", "superskurk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bösewicht"),
            keywords: &["Bösewicht", "böse"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αρχικακός"),
            keywords: &["αρχικακός", "κακοποιός", "κακό", "κακός", "υπερδύναμη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("supervillain"),
            keywords: &["criminal", "evil", "superpower", "supervillain", "villain"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("personaje de supervillano"),
            keywords: &[
                "mal",
                "personaje de supervillano",
                "superpoder",
                "supervillana",
                "supervillano",
                "villana",
                "villano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("supervillano"),
            keywords: &["delito", "mal", "superpoder", "supervillano", "villano"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("superkurikael"),
            keywords: &[
                "kuri",
                "kurikael",
                "kurjategija",
                "superkurikael",
                "supervõimed",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("superbilau"),
            keywords: &["bilau", "gaizto", "kriminal", "superbilau", "superbotere"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابرشرور"),
            keywords: &[
                "آدم شرور",
                "ابرشرور",
                "ابرقدرت",
                "اهریمن",
                "تبهکار",
                "شرور بزرگ",
                "مجرم",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("superpahis"),
            keywords: &[
                "kelmi",
                "konna",
                "paha",
                "rikollinen",
                "roisto",
                "superpahis",
                "supervoimat",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("supervillain"),
            keywords: &["criminal", "kaaway", "kalaban", "masama", "supervillain"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("superskálkur"),
            keywords: &[
                "bakbeist",
                "illmenni",
                "skálkur",
                "super",
                "superskálkur",
                "óndur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("super-vilain"),
            keywords: &[
                "criminel",
                "mal",
                "méchant",
                "super-pouvoir",
                "super-vilain",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sárbhithiúnach"),
            keywords: &[
                "bithiúnach",
                "coirpeach",
                "drochdhuine",
                "olc",
                "sárbhithiúnach",
                "sárchumhacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàr-shlaightear"),
            keywords: &[
                "cumhachd",
                "eucoireach",
                "oil-chumhachd",
                "olc",
                "slaightear",
                "super",
                "sàr-shlaightear",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vilán"),
            keywords: &["malo", "superpoderes", "vilán"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac1}પરવિલન"),
            keywords: &[
                "ખલનાયક",
                "ગ\u{ac1}ન\u{ac7}ગાર",
                "દ\u{ac1}ષ\u{acd}ટ",
                "વિલન",
                "સ\u{ac1}પરપાવર",
                "સ\u{ac1}પરવિલન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("נבל על"),
            keywords: &["כוחות הרשע", "נבל", "נבל על", "פושע", "רשע"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{941}परविल\u{947}न"),
            keywords: &[
                "अपराधी",
                "ब\u{941}राई",
                "विल\u{947}न",
                "स\u{941}परपॉवर",
                "स\u{941}परविल\u{947}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zločinac"),
            keywords: &["kriminalac", "supermoći", "zlo", "zločinac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("főgonosz"),
            keywords: &["bűnöző", "főgonosz", "gazember", "gonosz", "szuperképesség"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սուպերչարագործ"),
            keywords: &["գերուժ", "հանցագործ", "չարագործ", "չարիք", "սուպերչարագործ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penjahat super"),
            keywords: &[
                "jahat",
                "kekuatan super",
                "kriminal",
                "penjahat",
                "penjahat super",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skúrkur"),
            keywords: &["glæpamaður", "illmenni", "illur", "ofurkraftur", "skúrkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("supercattivo"),
            keywords: &["cattivo", "criminale", "supercattivo", "superpotere"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("悪役"),
            keywords: &["ヴィラン", "悪", "悪役", "犯人", "超人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mungsuh digdaya"),
            keywords: &[
                "ala",
                "kadigdayan linuwih",
                "mungsuh",
                "mungsuh digdaya",
                "wong jahat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბოროტი გმირი"),
            keywords: &[
                "ბოროტი",
                "ბოროტი გმირი",
                "ზებუნებრივი",
                "კრიმინალი",
                "უარყოფითი გმირი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("супер зұлым"),
            keywords: &["залым", "супер зұлым", "супер күш", "шайтан", "қылмыстық"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ព\u{17bc}លជនអាក\u{17d2}រក\u{17cb}"),
            keywords: &[
                "ក\u{17c6}ព\u{17bc}លជនអាក\u{17d2}រក\u{17cb}",
                "ជនអាក\u{17d2}រក\u{17cb}",
                "ថាមពលព\u{17b7}សេស",
                "អាក\u{17d2}រក\u{17cb}",
                "ឧក\u{17d2}រ\u{17b7}ដ\u{17d2}ឋជន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ವ\u{cbf}ಲನ\u{ccd}"),
            keywords: &[
                "ಅಪರಾಧ\u{cbf}",
                "ಖಳನಾಯಕ",
                "ದುಷ\u{ccd}ಟ",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಪವರ\u{ccd}",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ವ\u{cbf}ಲನ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("슈퍼 악당"),
            keywords: &["범죄자", "빌런", "슈퍼 악당", "악당", "초능력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{941}परविलन"),
            keywords: &[
                "ग\u{941}न\u{94d}या\u{902}वकारी",
                "वायट",
                "विलन",
                "स\u{941}परपावर",
                "स\u{941}परविलन",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карасантай"),
            keywords: &[
                "зөөкүр",
                "карасантай",
                "кылмышкер",
                "терс каарман",
                "эбегейсиз зор күч",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈອມວາຍລ\u{ec9}າຍ"),
            keywords: &[
                "ຈອມພະລ\u{eb1}ງ",
                "ຈອມວາຍລ\u{ec9}າຍ",
                "ຊ\u{ebb}\u{ec8}ວຮ\u{ec9}າຍ",
                "ວາຍລ\u{ec9}າຍ",
                "ສ\u{eb5}\u{ec8}ງຊ\u{ebb}\u{ec8}ວຮ\u{ec9}າຍ",
                "ອາດສະຍາກອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("superpiktadarys"),
            keywords: &[
                "blogas",
                "nusikaltėlis",
                "piktadarys",
                "supergalia",
                "superpiktadarys",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("superļaunais"),
            keywords: &[
                "krimināls",
                "nelietis",
                "superspēks",
                "superļaunais",
                "ļaunums",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("супер-негативец"),
            keywords: &[
                "зло",
                "криминалец",
                "негативец",
                "супер-негативец",
                "суперсила",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d42}പ\u{d4d}പർവില\u{d4d}ലൻ"),
            keywords: &[
                "അമ\u{d3e}ന\u{d41}ഷികശക\u{d4d}\u{200c}തി",
                "ക\u{d4d}രിമിനൽ",
                "ദ\u{d41}ഷ\u{d4d}\u{200c}ടത",
                "പ\u{d4d}രതിന\u{d3e}യകൻ",
                "സ\u{d42}പ\u{d4d}പർവില\u{d4d}ലൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ид шидийн хүчтэй эсрэг дүр"),
            keywords: &[
                "гэмт хэрэг",
                "ид шидийн хүчтэй эсрэг дүр",
                "супер хүч",
                "чөтгөр",
                "эсрэг гол дүр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{941}परव\u{94d}हीलन"),
            keywords: &[
                "ग\u{941}न\u{94d}ह\u{947}गार",
                "द\u{941}ष\u{94d}ट",
                "व\u{94d}हीलन",
                "स\u{941}परपॉवर",
                "स\u{941}परव\u{94d}हीलन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ketua penjahat"),
            keywords: &[
                "jahat",
                "ketua penjahat",
                "penjahat",
                "penjenayah",
                "sangat berkuasa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထ\u{102d}ပ\u{103a}တန\u{103a}း လ\u{1030}ဆ\u{102d}\u{102f}း"),
            keywords: &[
                "ထ\u{102d}ပ\u{103a}တန\u{103a}း လ\u{1030}ဆ\u{102d}\u{102f}း",
                "မကောင\u{103a}းဆ\u{102d}\u{102f}းဝါး",
                "ရာဇဝတ\u{103a}ကောင\u{103a}",
                "လ\u{1030}ဆ\u{102d}\u{102f}း",
                "အစ\u{103d}မ\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("superskurk"),
            keywords: &["kriminell", "ond", "skurk", "superkrefter", "superskurk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}परभिल\u{947}न"),
            keywords: &[
                "अपराधी",
                "द\u{941}ष\u{94d}ट",
                "भिल\u{947}न",
                "स\u{941}परपावर",
                "स\u{941}परभिल\u{947}न",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("superschurk"),
            keywords: &[
                "boef",
                "crimineel",
                "slecht",
                "superkrachten",
                "superschurk",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("superskurk"),
            keywords: &["kriminell", "skurk", "superkrefter", "superskurk", "vond"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସ\u{b41}ପର\u{b4d}\u{200c} ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}"),
            keywords: &[
                "ଅପର\u{b3e}ଧୀ",
                "ଦ\u{b41}ଷ\u{b4d}ଟ",
                "ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ପ\u{b3e}ୱ\u{b3e}ର",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਹਾ\u{a02}-ਖਲਨਾਇਕ"),
            keywords: &[
                "ਅਪਰਾਧੀ",
                "ਖਲਨਾਇਕ",
                "ਦ\u{a41}ਸ\u{a3c}ਟ",
                "ਮਹਾ\u{a02}-ਖਲਨਾਇਕ",
                "ਸ\u{a41}ਪਰਪਾਵਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wíkẹ\u{301}d Krímínal"),
            keywords: &[
                "Bad",
                "Bád Pẹ\u{301}sin",
                "Krímínal",
                "Pẹ\u{301}sin Wé Bád Wẹ\u{301}l Wẹl",
                "Supapáwa",
                "Wíkẹd",
                "Wíkẹ\u{301}d Krímínal",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("superłotr"),
            keywords: &[
                "czarny charakter",
                "przestępca",
                "supermoc",
                "superłotr",
                "złoczyńca",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لوي ورانکاری"),
            keywords: &["جنايتکار", "خراب", "لوي قوت", "لوي ورانکاری", "ورانکاری"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("supervilão"),
            keywords: &["criminoso", "mal", "superpoder", "supervilão", "vilão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["criminoso", "mau", "superpoder", "supervilão", "vilão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("supervillano"),
            keywords: &["criminal", "supay", "superpoder", "supervillano", "villano"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("super-ticălos"),
            keywords: &[
                "criminal",
                "malefic",
                "super-ticălos",
                "superputere",
                "ticălos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-044"),
            keywords: &["E11-044"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("суперзлодей"),
            keywords: &["зло", "злодей", "суперзлодей"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سپر ولن"),
            keywords: &["برائي", "سپر ولن", "سپر پاور", "ولن", "ڏوهي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}ප\u{dd2}ර\u{dd2} ද\u{dd4}ෂ\u{dca}ටය\u{dcf}"),
            keywords: &[
                "අපර\u{dcf}ධක\u{dcf}රයෙක\u{dca}",
                "ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
                "නරකය\u{dd2}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} බලවත\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("superdarebácka bytosť"),
            keywords: &[
                "darebák",
                "superdarebácka bytosť",
                "superschopnosť",
                "zlo",
                "zloduch",
                "zločinec",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("super negativec"),
            keywords: &[
                "kriminalec",
                "negativec",
                "super moč",
                "super negativec",
                "zloben",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof sheyddaankiisu sareeyo"),
            keywords: &[
                "awood sareeysa",
                "dambiile",
                "qof sheyddaankiisu sareeyo",
                "sheyddaan ah",
                "xun",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("superzuzar"),
            keywords: &["i lig", "kriminel", "superfuqi", "superzuzar", "zemërkeq"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("негативац"),
            keywords: &["зло", "злочинац", "криминал", "негативац", "супер моћ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["негативац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("negativac"),
            keywords: &["kriminal", "negativac", "super moć", "zlo", "zločinac"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["negativac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("superskurk"),
            keywords: &[
                "brottsling",
                "elak",
                "ond",
                "skurk",
                "superkraft",
                "superkrafter",
                "superskurk",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jambazi sugu"),
            keywords: &[
                "jambazi",
                "jambazi sugu",
                "mhalifu",
                "nguvu zisizo za kawaida",
                "uovu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூப\u{bcd}பர\u{bcd} வில\u{bcd}லன\u{bcd}"),
            keywords: &[
                "குற\u{bcd}றவ\u{bbe}ளி",
                "சூப\u{bcd}பர\u{bcd} பவர\u{bcd}",
                "சூப\u{bcd}பர\u{bcd} வில\u{bcd}லன\u{bcd}",
                "த\u{bc0}யவர\u{bcd}",
                "வில\u{bcd}லன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సూపర\u{c4d}\u{200c}వ\u{c3f}లన\u{c4d}"),
            keywords: &[
                "క\u{c4d}ర\u{c3f}మ\u{c3f}నల\u{c4d}",
                "చ\u{c46}డు",
                "వ\u{c3f}లన\u{c4d}",
                "సూపర\u{c4d}\u{200c}పవర\u{c4d}",
                "సూపర\u{c4d}\u{200c}వ\u{c3f}లన\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ยอดมน\u{e38}ษย\u{e4c}"),
            keywords: &[
                "ต\u{e31}วร\u{e49}าย",
                "ป\u{e35}ศาจ",
                "ผ\u{e39}\u{e49}ร\u{e49}าย",
                "ยอดมน\u{e38}ษย\u{e4c}",
                "อาชญากร",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("superbetpäl"),
            keywords: &["betpäl", "erbet", "jenaýatçy", "superbetpäl", "supergüýç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha kākā"),
            keywords: &["tokotaha kākā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("süper kötü"),
            keywords: &["kötü", "suçlu", "süper güç", "süper kötü", "şeytani"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суперзлодій"),
            keywords: &["зло", "злодій", "злочинець", "суперзлодій", "суперсила"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سپر ولن"),
            keywords: &["برائی", "سپر ولن", "سپر پاور", "مجرم", "ولن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("salbiy superqahramon"),
            keywords: &[
                "jinoyat",
                "salbiy qahramon",
                "salbiy superqahramon",
                "superkuch",
                "yovuz",
                "yovuzlik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nhân vật siêu phản diện"),
            keywords: &[
                "nhân vật phản diện",
                "nhân vật siêu phản diện",
                "siêu năng lực",
                "tội phạm",
                "ác",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("超級壞人"),
            keywords: &["壞人", "犯罪", "超人", "超級壞人", "邪惡"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("超级坏人"),
            keywords: &["坏人", "犯罪", "超人", "超级坏人", "邪恶"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("超级大坏蛋"),
            keywords: &["坏蛋", "恶魔", "罪犯", "超级大坏蛋", "超能力"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("超級反派"),
            keywords: &["反派", "犯罪", "超級反派", "超能力", "邪惡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("supervillain"),
            keywords: &["criminal", "evil", "superpower", "supervillain", "villain"],
        },
    ],
};
#[doc = "🦹🏻"]
pub const SUPERVILLAIN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏻",
    codepoint: "1F9B9 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "supervillain: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦹🏼"]
pub const SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏼",
    codepoint: "1F9B9 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "supervillain: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦹🏽"]
pub const SUPERVILLAIN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏽",
    codepoint: "1F9B9 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "supervillain: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦹🏾"]
pub const SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏾",
    codepoint: "1F9B9 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "supervillain: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦹🏿"]
pub const SUPERVILLAIN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏿",
    codepoint: "1F9B9 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "supervillain: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦹\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERVILLAIN: crate::Emoji = crate::Emoji {
    glyph: "🦹\u{200d}♂\u{fe0f}",
    codepoint: "1F9B9 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man supervillain",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹\u{200d}♂",
        codepoint: "1F9B9 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man supervillain",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike superskurk"),
            keywords: &[
                "boos",
                "krimineel",
                "man",
                "manlike superskurk",
                "skurk",
                "superkrag",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የወንድ ጀግና ምስል"),
            keywords: &["ሃያል", "ሰው", "ተንኮለኛ", "ክፉ", "ወንጀለኛ", "የወንድ ጀግና ምስል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شرير خارق رجل"),
            keywords: &[
                "جريمة",
                "رجل",
                "شر",
                "شرير",
                "شرير خارق رجل",
                "قوة خارقة",
                "مجرم",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ চ\u{9c1}প\u{9be}ৰভিলেইন"),
            keywords: &[
                "অপৰ\u{9be}ধী",
                "চ\u{9c1}প\u{9be}ৰপ\u{9be}ৱ\u{9be}ৰ",
                "দ\u{9c1}ষ\u{9cd}ট",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ চ\u{9c1}প\u{9be}ৰভিলেইন",
                "ভিলেইন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi supercani"),
            keywords: &[
                "cani",
                "kişi",
                "kişi supercani",
                "kriminal",
                "pis",
                "supergüc",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("суперзлачынец"),
            keywords: &[
                "злачынца",
                "зло",
                "ліхадзей",
                "мужчына",
                "суперзлачынец",
                "суперсіла",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж суперзлодей"),
            keywords: &[
                "зло",
                "злодей",
                "мъж",
                "мъж суперзлодей",
                "престъпник",
                "суперсила",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ স\u{9c1}প\u{9be}রভিলেন"),
            keywords: &[
                "অপর\u{9be}ধী",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ স\u{9c1}প\u{9be}রভিলেন",
                "ভিলেন",
                "মন\u{9cd}দ",
                "স\u{9c1}প\u{9be}রপ\u{9be}ওয\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac super zlikovac"),
            keywords: &[
                "kriminalac",
                "muškarac",
                "muškarac super zlikovac",
                "supermoć",
                "zlikovac",
                "zlo",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home superdolent"),
            keywords: &[
                "criminal",
                "dolent",
                "home",
                "home superdolent",
                "malvat",
                "superpoder",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏄᎬᏫᏳᏒᎩ ᎠᏍᎦᏂ"),
            keywords: &[
                "ᎠᏍᎦᏂ",
                "ᎠᏍᎦᏯ",
                "ᎠᏍᎦᏯ ᏄᎬᏫᏳᏒᎩ ᎠᏍᎦᏂ",
                "ᎤᏍᎦᏅᏨᎯ ᎨᏒᎢ",
                "ᎤᏐᏅᎢ",
                "ᏄᎬᏫᏳᏒᎩ ᎤᏟᏂᎩᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("superpadouch"),
            keywords: &[
                "muž",
                "padouch",
                "superpadouch",
                "superschopnost",
                "superzločinec",
                "záporná postava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("archleidr gwrywaidd"),
            keywords: &[
                "archbŵer",
                "archleidr gwrywaidd",
                "drwg",
                "dyn",
                "troseddwr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig superskurk"),
            keywords: &[
                "kriminel",
                "mand",
                "mandlig superskurk",
                "ond",
                "skurk",
                "superkraft",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("männlicher Bösewicht"),
            keywords: &["Bösewicht", "böse", "männlicher Bösewicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας αρχικακός"),
            keywords: &[
                "άντρας",
                "άντρας αρχικακός",
                "κακοποιός",
                "κακό",
                "κακός",
                "υπερδύναμη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man supervillain"),
            keywords: &[
                "criminal",
                "evil",
                "man",
                "man supervillain",
                "superpower",
                "villain",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("supervillano"),
            keywords: &["hombre", "mal", "malvado", "supervillano", "villano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("hombre supervillano"),
            keywords: &[
                "delito",
                "hombre",
                "hombre supervillano",
                "mal",
                "superpoder",
                "villano",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("hombre supervillano"),
            keywords: &["hombre supervillano"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meessoost superkurikael"),
            keywords: &[
                "kuri",
                "kurikael",
                "kurjategija",
                "mees",
                "meessoost superkurikael",
                "supervõimed",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizonezko superbilau"),
            keywords: &[
                "bilau",
                "gaizto",
                "gizon",
                "gizonezko superbilau",
                "kriminal",
                "superbotere",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابرشرور مرد"),
            keywords: &[
                "آدم شرور",
                "ابرشرور مرد",
                "ابرقدرت",
                "اهریمن",
                "تبهکار",
                "مرد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miessuperpahis"),
            keywords: &[
                "kelmi",
                "konna",
                "miessuperpahis",
                "paha",
                "rikollinen",
                "roisto",
                "supervoimat",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking supervillain"),
            keywords: &[
                "kalaban",
                "kontrabida",
                "kriminal",
                "lalaki",
                "lalaking supervillain",
                "superpower",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur superskálkur"),
            keywords: &[
                "bakbeist",
                "illmenni",
                "mannligur superskálkur",
                "maður",
                "skálkur",
                "super",
                "óndur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("super-vilain homme"),
            keywords: &[
                "criminel",
                "homme",
                "mal",
                "méchant",
                "super-pouvoir",
                "super-vilain homme",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "criminel, homme, mal, méchant, super pouvoir",
                "super-vilain homme",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear-dhrochdhuine"),
            keywords: &[
                "coirpeach",
                "drochdhuine",
                "fear",
                "fear-dhrochdhuine",
                "olc",
                "sárchumhacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàr-shlaightear fireann"),
            keywords: &[
                "cumhachd",
                "eucoireach",
                "fireannach",
                "oil-chumhachd",
                "olc",
                "slaightear",
                "super",
                "sàr-shlaightear fireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("supervil´án"),
            keywords: &["home", "malo", "superpoderes", "supervil´án", "vilán"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ સ\u{ac1}પરવિલન"),
            keywords: &[
                "ખલનાયક",
                "ગ\u{ac1}ન\u{ac7}ગાર",
                "દ\u{ac1}ષ\u{acd}ટ",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ સ\u{ac1}પરવિલન",
                "વિલન",
                "સ\u{ac1}પરપાવર",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רשע בעל כוחות על"),
            keywords: &[
                "כוחות הרשע",
                "כוחות על",
                "נבל",
                "פושע",
                "רשע",
                "רשע בעל כוחות על",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष स\u{941}परविल\u{947}न"),
            keywords: &[
                "अपराधी",
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष स\u{941}परविल\u{947}न",
                "ब\u{941}राई",
                "विल\u{947}न",
                "स\u{941}परपॉवर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stripovski zločinac"),
            keywords: &[
                "kriminalac",
                "muškarac",
                "stripovski zločinac",
                "supermoći",
                "zlo",
                "zločinac",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi főgonosz"),
            keywords: &[
                "bűnöző",
                "férfi",
                "férfi főgonosz",
                "gazember",
                "gonosz",
                "szuperképesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ չարագործ"),
            keywords: &["գերուժ", "հանցագործ", "չարագործ", "չարիք", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penjahat super pria"),
            keywords: &[
                "jahat",
                "kekuatan super",
                "kriminal",
                "penjahat",
                "penjahat super pria",
                "pria",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("illmenni"),
            keywords: &["glæpamaður", "illmenni", "illur", "ofurkraftur", "skúrkur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("supercattivo uomo"),
            keywords: &[
                "cattivo",
                "criminale",
                "supercattivo uomo",
                "superpotere",
                "uomo",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性の悪役"),
            keywords: &["ヴィラン", "悪", "犯人", "男性", "男性の悪役", "超人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mungsuh digdaya lanang"),
            keywords: &[
                "ala",
                "kadigdayan linuwih",
                "lanang",
                "mungsuh",
                "mungsuh digdaya lanang",
                "wong jahat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბოროტი გმირი კაცი"),
            keywords: &[
                "ბოროტი",
                "ბოროტი გმირი კაცი",
                "ზებუნებრივი",
                "კაცი",
                "კრიმინალი",
                "უარყოფითი გმირი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер супер залым"),
            keywords: &[
                "ер",
                "ер супер залым",
                "залым",
                "супер күш",
                "шайтан",
                "қылмыстық",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ព\u{17bc}លប\u{17bb}រសអាក\u{17d2}រក\u{17cb}"),
            keywords: &[
                "ក\u{17c6}ព\u{17bc}លប\u{17bb}រសអាក\u{17d2}រក\u{17cb}",
                "ជនអាក\u{17d2}រក\u{17cb}",
                "ថាមពលព\u{17b7}សេស",
                "ប\u{17bb}រស",
                "អាក\u{17d2}រក\u{17cb}",
                "ឧក\u{17d2}រ\u{17b7}ដ\u{17d2}ឋជន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ವ\u{cbf}ಲನ\u{ccd}"),
            keywords: &[
                "ಅಪರಾಧ\u{cbf}",
                "ದುಷ\u{ccd}ಟ",
                "ಪುರುಷ",
                "ಪುರುಷ ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ವ\u{cbf}ಲನ\u{ccd}",
                "ವ\u{cbf}ಲನ\u{ccd}",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಪವರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 슈퍼 악당"),
            keywords: &["남자 슈퍼 악당", "범죄자", "빌런", "악당", "초능력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो स\u{941}परविलन"),
            keywords: &[
                "ग\u{941}न\u{94d}या\u{902}वकारी",
                "दादलो",
                "दादलो स\u{941}परविलन",
                "दादलो स\u{941}परविल\u{947}न",
                "वायट",
                "विल\u{947}न",
                "स\u{941}परपावर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карасантай жигит"),
            keywords: &[
                "зөөкүр",
                "карасантай жигит",
                "кылмышкер",
                "терс каарман",
                "эбегейсиз зор күч",
                "эркек",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະຍາມານຈອມວາຍລ\u{ec9}າຍ"),
            keywords: &[
                "ຈອມພະລ\u{eb1}ງ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ພະຍາມານຈອມວາຍລ\u{ec9}າຍ",
                "ວາຍລ\u{ec9}າຍ",
                "ສ\u{eb5}\u{ec8}ງຊ\u{ebb}\u{ec8}ວຮ\u{ec9}າຍ",
                "ອາດສະຍາກອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyras piktadarys"),
            keywords: &[
                "blogas",
                "nusikaltėlis",
                "piktadarys",
                "supergalia",
                "vyras",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("superļaunais vīrietis"),
            keywords: &[
                "krimināls",
                "nelietis",
                "superspēks",
                "superļaunais vīrietis",
                "vīrietis",
                "ļaunums",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж супернегативец"),
            keywords: &[
                "зло",
                "криминалец",
                "маж",
                "маж супернегативец",
                "негативец",
                "суперсила",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d3e}ൻ സ\u{d42}പ\u{d4d}പർവില\u{d4d}ലൻ"),
            keywords: &[
                "അമ\u{d3e}ന\u{d41}ഷികശക\u{d4d}തി",
                "ക\u{d4d}രിമിനൽ",
                "ദ\u{d41}ഷ\u{d4d}\u{200c}ടത",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "മ\u{d3e}ൻ സ\u{d42}പ\u{d4d}പർവില\u{d4d}ലൻ",
                "വില\u{d4d}ലൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ид шидийн хүчтэй эрэгтэй эсрэг дүр"),
            keywords: &[
                "гэмт хэрэг",
                "ид шидийн хүчтэй эрэгтэй эсрэг дүр",
                "супер хүч",
                "чөтгөр",
                "эрэгтэй",
                "эсрэг гол дүр",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{941}ष स\u{941}परव\u{94d}हीलन"),
            keywords: &[
                "ग\u{941}न\u{94d}ह\u{947}गार",
                "द\u{941}ष\u{94d}ट",
                "प\u{941}र\u{941}ष स\u{941}परव\u{94d}हीलन",
                "प\u{941}र\u{942}ष",
                "व\u{94d}हीलन",
                "स\u{941}परपॉवर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ketua penjahat lelaki"),
            keywords: &[
                "jahat",
                "ketua penjahat lelaki",
                "lelaki",
                "penjahat",
                "penjenayah",
                "sangat berkuasa",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသား ထ\u{102d}ပ\u{103a}တန\u{103a}းလ\u{1030}ဆ\u{102d}\u{102f}း",
            ),
            keywords: &[
                "မကောင\u{103a}းဆ\u{102d}\u{102f}းဝါး",
                "ရာဇဝတ\u{103a}ကောင\u{103a}",
                "လ\u{1030}ဆ\u{102d}\u{102f}း",
                "အစ\u{103d}မ\u{103a}း",
                "အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား ထ\u{102d}ပ\u{103a}တန\u{103a}းလ\u{1030}ဆ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig superskurk"),
            keywords: &[
                "kriminell",
                "mann",
                "mannlig superskurk",
                "ond",
                "skurk",
                "superkrefter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरामान\u{94d}छ\u{947} स\u{941}परभिल\u{947}न"),
            keywords: &[
                "अपराधी",
                "छोरामान\u{94d}छ\u{947}",
                "छोरामान\u{94d}छ\u{947} स\u{941}परभिल\u{947}न",
                "द\u{941}ष\u{94d}ट",
                "भिल\u{947}न",
                "स\u{941}परपावर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke superschurk"),
            keywords: &[
                "boef",
                "crimineel",
                "man",
                "mannelijke superschurk",
                "slecht",
                "superkrachten",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg superskurk"),
            keywords: &[
                "kriminell",
                "mann",
                "mannleg superskurk",
                "skurk",
                "superkrefter",
                "vond",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ପ\u{b41}ର\u{b41}ଷ ସ\u{b41}ପର\u{b4d}\u{200c} ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}",
            ),
            keywords: &[
                "ଅପର\u{b3e}ଧୀ",
                "ଦ\u{b41}ଷ\u{b4d}ଟ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ ସ\u{b41}ପର\u{b4d}\u{200c} ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}",
                "ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ପ\u{b3e}ୱ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਮਹਾ\u{a02}-ਖਲਨਾਇਕ"),
            keywords: &[
                "ਅਪਰਾਧੀ",
                "ਖਲਨਾਇਕ",
                "ਦ\u{a41}ਸ\u{a3c}ਟ",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c} ਮਹਾ\u{a02}-ਖਲਨਾਇਕ",
                "ਸ\u{a41}ਪਰਪਾਵਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wíkẹ\u{301}d Mán Krímínal"),
            keywords: &[
                "Bad",
                "Bád Pẹ\u{301}sin",
                "Krímínal",
                "Man Wé Bád Wẹ\u{301}l Wẹl",
                "Supapáwa",
                "Wíkẹd",
                "Wíkẹ\u{301}d Mán Krímínal",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna superłotr"),
            keywords: &[
                "czarny bohater",
                "mężczyzna",
                "mężczyzna superłotr",
                "przestępca",
                "supermoc",
                "złoczyńca",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی لوي ورانکاری"),
            keywords: &[
                "جنايتکار",
                "خراب",
                "سړی لوي ورانکاری",
                "لوي قوت",
                "ورانکاری",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem supervilão"),
            keywords: &[
                "criminoso",
                "homem",
                "homem supervilão",
                "mal",
                "superpoder",
                "vilão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "criminoso",
                "homem",
                "homem supervilão",
                "mau",
                "superpoderoso",
                "vilão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa supervillano"),
            keywords: &[
                "criminal",
                "runa",
                "runa supervillano",
                "supay",
                "superpoder",
                "villano",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("super-ticălos bărbat"),
            keywords: &[
                "bărbat",
                "criminal",
                "malefic",
                "super-ticălos bărbat",
                "superputere",
                "ticălos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-046"),
            keywords: &["E11-046"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-суперзлодей"),
            keywords: &["зло", "злодей", "мужчина-суперзлодей", "суперзлодей"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد سپر ولن"),
            keywords: &["برائي", "سپر پاور", "مرد", "مرد سپر ولن", "ولن", "ڏوهي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ස\u{dd4}ප\u{dd2}ර\u{dd2} ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
            ),
            keywords: &[
                "අපර\u{dcf}ධක\u{dcf}රයෙක\u{dca}",
                "ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
                "නරකය\u{dd2}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ස\u{dd4}ප\u{dd2}ර\u{dd2} ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
                "ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} බලවත\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("superdarebák"),
            keywords: &[
                "darebák",
                "muž",
                "superdarebák",
                "superschopnosť",
                "zlo",
                "zloduch",
                "zločinec",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški super negativec"),
            keywords: &[
                "kriminalec",
                "moški",
                "moški super negativec",
                "negativec",
                "super moč",
                "zloben",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin sheyddaannimadiisu sareeyso"),
            keywords: &[
                "awood sareeysa",
                "dambiile",
                "nin",
                "nin sheyddaannimadiisu sareeyso",
                "nin sheyddannimadiisu sareeyso",
                "qof sheyddaan ah",
                "xun",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë superzuzar"),
            keywords: &[
                "burrë superzuzar",
                "i lig",
                "kriminel",
                "superfuqi",
                "zuzar",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац негативац"),
            keywords: &["зло", "криминал", "мушкарац", "негативац", "супер моћ"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушкарац негативац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac negativac"),
            keywords: &["kriminal", "muškarac", "negativac", "super moć", "zlo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muškarac negativac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig superskurk"),
            keywords: &[
                "brottsling",
                "man",
                "manlig superskurk",
                "ond",
                "skurk",
                "superkraft",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jambazi wa kiume"),
            keywords: &[
                "jambazi",
                "jambazi wa kiume",
                "mhalifu",
                "mwanamume",
                "nguvu zisizo za kawaida",
                "uovu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} சூப\u{bcd}பர\u{bcd} வில\u{bcd}லன\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "ஆண\u{bcd} சூப\u{bcd}பர\u{bcd} வில\u{bcd}லன\u{bcd}",
                "குற\u{bcd}றவ\u{bbe}ளி",
                "சூப\u{bcd}பர\u{bcd} பவர\u{bcd}",
                "த\u{bc0}யவர\u{bcd}",
                "வில\u{bcd}லன\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c4d}య\u{c3e}న\u{c4d} సూపర\u{c4d}\u{200c}వ\u{c3f}లన\u{c4d}"),
            keywords: &[
                "క\u{c4d}ర\u{c3f}మ\u{c3f}నల\u{c4d}",
                "చ\u{c46}డు",
                "మ\u{c4d}య\u{c3e}న\u{c4d}",
                "మ\u{c4d}య\u{c3e}న\u{c4d} సూపర\u{c4d}\u{200c}వ\u{c3f}లన\u{c4d}",
                "వ\u{c3f}లన\u{c4d}",
                "సూపర\u{c4d}\u{200c}పవర\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}วโกง"),
            keywords: &[
                "ต\u{e31}วร\u{e49}าย",
                "ต\u{e31}วโกง",
                "ป\u{e35}ศาจ",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ร\u{e49}าย",
                "อาชญากร",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek superbetpäl"),
            keywords: &[
                "betpäl",
                "erbet",
                "erkek adam",
                "erkek superbetpäl",
                "jenaýatçy",
                "supergüýç",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata kākā"),
            keywords: &["tangata kākā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek süper kötü"),
            keywords: &[
                "erkek",
                "erkek süper kötü",
                "kötü",
                "suçlu",
                "süper güç",
                "şeytani",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суперлиходій"),
            keywords: &[
                "зло",
                "злодій",
                "злочинець",
                "суперлиходій",
                "суперсила",
                "чоловік",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد سپر ولن"),
            keywords: &["برائی", "سپر پاور", "مجرم", "مرد", "مرد سپر ولن", "ولن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("salbiy erkak superqahramon"),
            keywords: &[
                "erkak",
                "jinoyat",
                "salbiy",
                "superkuch",
                "superqahramon",
                "yovuz",
                "yovuzlik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nam siêu phản diện"),
            keywords: &[
                "nam giới",
                "nam siêu phản diện",
                "nhân vật phản diện",
                "siêu năng lực",
                "tội phạm",
                "ác",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("超級男壞人"),
            keywords: &["壞人", "犯罪", "超人", "超級男壞人", "邪惡｜男"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("超级男坏人"),
            keywords: &["坏人", "犯罪", "超人", "超级男坏人", "邪恶｜男"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男超级大坏蛋"),
            keywords: &["坏蛋", "男人", "男超级大坏蛋", "罪犯", "超能力"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男超級反派"),
            keywords: &["反派", "犯罪", "男人", "男超級反派", "超能力", "邪惡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("man supervillain"),
            keywords: &[
                "criminal",
                "evil",
                "man",
                "man supervillain",
                "superpower",
                "villain",
            ],
        },
    ],
};
#[doc = "🦹🏻\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERVILLAIN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9B9 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man supervillain: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏻\u{200d}♂",
        codepoint: "1F9B9 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man supervillain: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏼\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9B9 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man supervillain: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏼\u{200d}♂",
        codepoint: "1F9B9 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man supervillain: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏽\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERVILLAIN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9B9 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man supervillain: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏽\u{200d}♂",
        codepoint: "1F9B9 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man supervillain: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏾\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9B9 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man supervillain: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏾\u{200d}♂",
        codepoint: "1F9B9 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man supervillain: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏿\u{200d}♂\u{fe0f}"]
pub const MAN_SUPERVILLAIN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9B9 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man supervillain: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏿\u{200d}♂",
        codepoint: "1F9B9 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "man supervillain: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERVILLAIN: crate::Emoji = crate::Emoji {
    glyph: "🦹\u{200d}♀\u{fe0f}",
    codepoint: "1F9B9 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman supervillain",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹\u{200d}♀",
        codepoint: "1F9B9 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman supervillain",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike superskurk"),
            keywords: &[
                "boos",
                "krimineel",
                "skurk",
                "superkrag",
                "vrou",
                "vroulike superskurk",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የሴት ጀግና ምስል"),
            keywords: &["ሃያል", "ተንኮለኛ", "ክፉ", "ወንጀል", "የሴት ጀግና ምስል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شريرة خارقة"),
            keywords: &["جريمة", "شر", "شريرة", "شريرة خارقة", "قوة خارقة", "مجرمة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} চ\u{9c1}প\u{9be}ৰভিলেইন"),
            keywords: &[
                "অপৰ\u{9be}ধী",
                "চ\u{9c1}প\u{9be}ৰপ\u{9be}ৱ\u{9be}ৰ",
                "দ\u{9c1}ষ\u{9cd}ট",
                "ভিলেইন",
                "মহিল\u{9be}",
                "মহিল\u{9be} চ\u{9c1}প\u{9be}ৰভিলেইন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın supercani"),
            keywords: &[
                "cani",
                "kriminal",
                "pis",
                "qadın",
                "qadın supercani",
                "supergüc",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("суперзлачынка"),
            keywords: &[
                "жанчына",
                "злачынца",
                "зло",
                "ліхадзей",
                "суперзлачынка",
                "суперсіла",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена суперзлодей"),
            keywords: &[
                "жена",
                "жена суперзлодей",
                "зло",
                "злодей",
                "престъпник",
                "суперсила",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} স\u{9c1}প\u{9be}রভিলেন"),
            keywords: &[
                "অপর\u{9be}ধী",
                "ভিলেন",
                "মন\u{9cd}দ",
                "মহিল\u{9be}",
                "মহিল\u{9be} স\u{9c1}প\u{9be}রভিলেন",
                "স\u{9c1}প\u{9be}রপ\u{9be}ওয\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena super zlikovac"),
            keywords: &[
                "kriminalac",
                "supermoć",
                "zlikovac",
                "zlo",
                "žena super zlikovac",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona superdolenta"),
            keywords: &[
                "criminal",
                "dolenta",
                "dona",
                "dona superdolenta",
                "malvada",
                "superpoder",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏄᎬᏫᏳᏒᎩ ᎠᏍᎦᏂ"),
            keywords: &[
                "ᎠᎨᏯ",
                "ᎠᎨᏯ ᏄᎬᏫᏳᏒᎩ ᎠᏍᎦᏂ",
                "ᎠᏍᎦᏂ",
                "ᎤᏍᎦᏅᏨᎯ ᎨᏒᎢ",
                "ᎤᏐᏅᎢ",
                "ᏄᎬᏫᏳᏒᎩ ᎤᏟᏂᎩᏓ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("superpadouška"),
            keywords: &[
                "padouška",
                "superpadouška",
                "superschopnost",
                "superzloduška",
                "záporná postava",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("archleidr benywaidd"),
            keywords: &[
                "archbŵer",
                "archleidr benywaidd",
                "drwg",
                "dyn drwg",
                "menyw",
                "troseddwr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig superskurk"),
            keywords: &[
                "kriminel",
                "kvinde",
                "kvindelig superskurk",
                "ond",
                "skurk",
                "superkraft",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weiblicher Bösewicht"),
            keywords: &["Bösewicht", "böse", "weiblicher Bösewicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα αρχικακός"),
            keywords: &[
                "γυναίκα",
                "γυναίκα αρχικακός",
                "κακή",
                "κακοποιός",
                "κακό",
                "υπερδύναμη",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman supervillain"),
            keywords: &[
                "criminal",
                "evil",
                "superpower",
                "villain",
                "woman",
                "woman supervillain",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("supervillana"),
            keywords: &["mal", "malvada", "mujer", "supervillana", "villana"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("supervillana"),
            keywords: &[
                "delito",
                "mal",
                "mujer",
                "superpoder",
                "supervillana",
                "villana",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("supervillana"),
            keywords: &["supervillana"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naissoost superkurikael"),
            keywords: &[
                "kuri",
                "kurikael",
                "kurjategija",
                "naine",
                "naissoost superkurikael",
                "supervõimed",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumezko superbilau"),
            keywords: &[
                "bilau",
                "emakume",
                "emakumezko superbilau",
                "gaizto",
                "kriminal",
                "superbotere",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ابرشرور زن"),
            keywords: &[
                "آدم شرور",
                "ابرشرور زن",
                "ابرقدرت",
                "اهریمن",
                "تبهکار",
                "زن",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naissuperpahis"),
            keywords: &[
                "kelmi",
                "konna",
                "naissuperpahis",
                "paha",
                "rikollinen",
                "roisto",
                "supervoimat",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng supervillain"),
            keywords: &[
                "babae",
                "babaeng supervillain",
                "kalaban",
                "kontrabida",
                "kriminal",
                "superpower",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur superskálkur"),
            keywords: &[
                "bakbeist",
                "illmenni",
                "kona",
                "kvinna",
                "kvinnuligur superskálkur",
                "skálkur",
                "super",
                "ónd",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("super-vilain femme"),
            keywords: &[
                "criminelle",
                "femme",
                "mal",
                "méchante",
                "super-pouvoir",
                "super-vilain femme",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "criminelle, femme, mal, méchante, super pouvoir",
                "super-vilain femme",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ban-drochdhuine"),
            keywords: &[
                "ban-drochdhuine",
                "bean",
                "coirpeach",
                "drochdhuine",
                "olc",
                "sárchumhacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sàr-shlaightear boireann"),
            keywords: &[
                "boireannach",
                "cumhachd",
                "eucoireach",
                "oil-chumhachd",
                "olc",
                "slaightear",
                "super",
                "sàr-shlaightear boireann",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("supervilá"),
            keywords: &["mala", "muller", "superpoderes", "supervilá", "vilá"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી સ\u{ac1}પરવિલન"),
            keywords: &[
                "ખલનાયક",
                "ગ\u{ac1}ન\u{ac7}ગાર",
                "દ\u{ac1}ષ\u{acd}ટ",
                "વિલન",
                "સ\u{ac1}પરપાવર",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી સ\u{ac1}પરવિલન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מרשעת על"),
            keywords: &["כוחות הרשע", "מרשעת", "מרשעת על", "פושעת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला स\u{941}परविल\u{947}न"),
            keywords: &[
                "अपराधी",
                "ब\u{941}राई",
                "महिला",
                "महिला स\u{941}परविल\u{947}न",
                "विल\u{947}न",
                "स\u{941}परपॉवर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stripovska zločinka"),
            keywords: &[
                "kriminalka",
                "stripovska zločinka",
                "supermoći",
                "zlo",
                "zločinka",
                "žena",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női főgonosz"),
            keywords: &[
                "bűnöző",
                "gazember",
                "gonosz",
                "nő",
                "női főgonosz",
                "szuperképesség",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին չարագործ"),
            keywords: &["գերուժ", "կին", "հանցագործ", "չարագործ", "չարիք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("penjahat super wanita"),
            keywords: &[
                "jahat",
                "kekuatan super",
                "kriminal",
                "penjahat",
                "penjahat super wanita",
                "wanita",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("illkvendi"),
            keywords: &["glæpamaður", "ill", "illkvendi", "kona", "ofurkraftur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("supercattiva"),
            keywords: &[
                "cattivo",
                "criminale",
                "donna",
                "supercattiva",
                "superpotere",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性の悪役"),
            keywords: &["ヴィラン", "女性", "女性の悪役", "悪", "犯人", "超人"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mungsuh digdaya wadon"),
            keywords: &[
                "ala",
                "kadigdayan linuwih",
                "mungsuh",
                "mungsuh digdaya wadon",
                "penjahat wadon",
                "wadon",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბოროტი გმირი ქალი"),
            keywords: &[
                "ბოროტი",
                "ბოროტი გმირი ქალი",
                "ზებუნებრივი",
                "კრიმინალი",
                "უარყოფითი გმირი",
                "ქალი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел супер залым"),
            keywords: &[
                "залым",
                "супер күш",
                "шайтан",
                "қылмыстық",
                "әйел",
                "әйел супер залым",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17c6}ព\u{17bc}លនារ\u{17b8}អាក\u{17d2}រក\u{17cb}"),
            keywords: &[
                "ក\u{17c6}ព\u{17bc}លនារ\u{17b8}អាក\u{17d2}រក\u{17cb}",
                "ជនអាក\u{17d2}រក\u{17cb}",
                "ថាមពលព\u{17b7}សេស",
                "នារ\u{17b8}",
                "អាក\u{17d2}រក\u{17cb}",
                "ឧក\u{17d2}រ\u{17b7}ដ\u{17d2}ឋជន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ವ\u{cbf}ಲನ\u{ccd}"),
            keywords: &[
                "ಅಪರಾಧ\u{cbf}",
                "ದುಷ\u{ccd}ಟ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6} ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ವ\u{cbf}ಲನ\u{ccd}",
                "ವ\u{cbf}ಲನ\u{ccd}",
                "ಸ\u{cc2}ಪರ\u{ccd}\u{200c}ಪವರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 슈퍼 악당"),
            keywords: &["범죄자", "빌런", "악당", "여자", "여자 슈퍼 악당", "초능력"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल स\u{941}परविल\u{947}न"),
            keywords: &[
                "ग\u{941}न\u{94d}या\u{902}वकारी",
                "बायल",
                "बायल स\u{941}परविल\u{947}न",
                "वायट",
                "विल\u{947}न",
                "स\u{941}परपावर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("карасантай кыз"),
            keywords: &[
                "зөөкүр",
                "карасантай кыз",
                "кыз",
                "кылмышкер",
                "терс каарман",
                "эбегейсиз зор күч",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນາງມານຈອມວາຍລ\u{ec9}າຍ"),
            keywords: &[
                "ນາງມານຈອມວາຍລ\u{ec9}າຍ",
                "ວາຍລ\u{ec9}າຍ",
                "ສ\u{eb5}\u{ec8}ງຊ\u{ebb}\u{ec8}ວຮ\u{ec9}າຍ",
                "ອາດສະຍາກອນ",
                "ເພດຍ\u{eb5}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteris piktadarė"),
            keywords: &["bloga", "moteris", "nusikaltėlė", "piktadarė", "supergalia"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("superļaunā sieviete"),
            keywords: &[
                "krimināls",
                "nelietis",
                "sieviete",
                "superspēks",
                "superļaunā sieviete",
                "ļaunums",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена супернегативец"),
            keywords: &[
                "жена",
                "жена супернегативец",
                "зло",
                "криминалец",
                "негативец",
                "суперсила",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d41}മൺ സ\u{d42}പ\u{d4d}പർവില\u{d4d}ലൻ"),
            keywords: &[
                "അമ\u{d3e}ന\u{d41}ഷികശക\u{d4d}തി",
                "ക\u{d4d}രിമിനൽ",
                "ദ\u{d41}ഷ\u{d4d}\u{200c}ടത",
                "വില\u{d4d}ലൻ",
                "വ\u{d41}മൺ സ\u{d42}പ\u{d4d}പർവില\u{d4d}ലൻ",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ид шидийн хүчтэй эмэгтэй эсрэг дүр"),
            keywords: &[
                "гол дүрийн эсрэг дүр",
                "гэмт хэрэг",
                "ид шидийн хүчтэй эмэгтэй эсрэг дүр",
                "супер хүч",
                "чөтгөр",
                "эмэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला स\u{941}परव\u{94d}हीलन"),
            keywords: &[
                "ग\u{941}न\u{94d}ह\u{947}गार",
                "द\u{941}ष\u{94d}ट",
                "महिला",
                "महिला स\u{941}परव\u{94d}हीलन",
                "व\u{94d}हीलन",
                "स\u{941}परपॉवर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ketua penjahat wanita"),
            keywords: &[
                "jahat",
                "ketua penjahat wanita",
                "penjahat",
                "penjenayah",
                "sangat berkuasa",
                "wanita",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ထ\u{102d}ပ\u{103a}တန\u{103a}းလ\u{1030}ဆ\u{102d}\u{102f}း",
            ),
            keywords: &[
                "မကောင\u{103a}းဆ\u{102d}\u{102f}းဝါး",
                "ရာဇဝတ\u{103a}ကောင\u{103a}",
                "လ\u{1030}ဆ\u{102d}\u{102f}း",
                "အစ\u{103d}မ\u{103a}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ထ\u{102d}ပ\u{103a}တန\u{103a}းလ\u{1030}ဆ\u{102d}\u{102f}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig superskurk"),
            keywords: &[
                "kriminell",
                "kvinne",
                "kvinnelig superskurk",
                "ond",
                "skurk",
                "superkrefter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरीमान\u{94d}छ\u{947} स\u{941}परभिल\u{947}न"),
            keywords: &[
                "अपराधी",
                "छोरीमान\u{94d}छ\u{947}",
                "छोरीमान\u{94d}छ\u{947} स\u{941}परभिल\u{947}न",
                "द\u{941}ष\u{94d}ट",
                "भिल\u{947}न",
                "स\u{941}परपावर",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke superschurk"),
            keywords: &[
                "boef",
                "crimineel",
                "slecht",
                "superkrachten",
                "vrouw",
                "vrouwelijke superschurk",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg superskurk"),
            keywords: &[
                "kriminell",
                "kvinne",
                "kvinneleg superskurk",
                "skurk",
                "superkrefter",
                "vond",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ସ\u{b41}ପର\u{b4d}\u{200c} ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ"),
            keywords: &[
                "ଅପର\u{b3e}ଧୀ",
                "ଦ\u{b41}ଷ\u{b4d}ଟ",
                "ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ\u{b4d}\u{200c}",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ସ\u{b41}ପର\u{b4d}\u{200c} ଭ\u{b3f}ଲ\u{b3f}ୟ\u{b3e}ନ",
                "ସ\u{b41}ପର\u{b4d}\u{200c} ପ\u{b3e}ୱ\u{b3e}ର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਮਹਾ\u{a02}-ਖਲਨਾਇਕ"),
            keywords: &[
                "ਅਪਰਾਧੀ",
                "ਇਸਤਰੀ",
                "ਇਸਤਰੀ ਮਹਾ\u{a02}-ਖਲਨਾਇਕ",
                "ਖਲਨਾਇਕ",
                "ਦ\u{a41}ਸ\u{a3c}ਟ",
                "ਸ\u{a41}ਪਰਪਾਵਰ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wíkẹ\u{301}d Wúmán Krímínal"),
            keywords: &[
                "Bad",
                "Bád Pẹ\u{301}sin",
                "Krímínal",
                "Supapáwa",
                "Wíkẹd",
                "Wíkẹ\u{301}d Wúmán Krímínal",
                "Wúman",
                "Wúman Wé Bád Wẹ\u{301}l Wẹl",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta superłotr"),
            keywords: &[
                "czarny bohater",
                "kobieta",
                "kobieta superłotr",
                "przestępca",
                "supermoc",
                "złoczyńca",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه لوي ورانکارې"),
            keywords: &[
                "جنايتکار",
                "خراب",
                "لوي قوت",
                "ورانکاری",
                "ښځه لوي ورانکاری",
                "ښځه لوي ورانکارې",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("supervilã"),
            keywords: &[
                "criminosa",
                "mulher",
                "má",
                "superpoder",
                "supervilã",
                "vilã",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mulher supervilã"),
            keywords: &[
                "criminosa",
                "mulher",
                "mulher supervilã",
                "má",
                "superpoder",
                "vilã",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi supervillana"),
            keywords: &[
                "criminal",
                "supay",
                "superpoder",
                "villana",
                "warmi",
                "warmi supervillana",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("super-ticălos femeie"),
            keywords: &[
                "criminală",
                "femeie",
                "malefică",
                "super-ticălos femeie",
                "superputere",
                "ticăloasă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-045"),
            keywords: &["E11-045"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-суперзлодей"),
            keywords: &["женщина-суперзлодей", "зло", "злодей", "суперзлодей"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت سپر ولن"),
            keywords: &["برائي", "سپر پاور", "عورت", "عورت سپر ولن", "ولن", "ڏوهي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf}ව ද\u{dd4}ෂ\u{dca}ටය\u{dcf}"),
            keywords: &[
                "අපර\u{dcf}ධක\u{dcf}රයෙක\u{dca}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
                "ක\u{dcf}න\u{dca}ත\u{dcf}වක\u{dca}",
                "ද\u{dd4}ෂ\u{dca}ටය\u{dcf}",
                "නරකය\u{dd2}",
                "ස\u{dd4}ප\u{dd2}ර\u{dd2} බලවත\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("superdarebáčka"),
            keywords: &[
                "darebák",
                "superdarebáčka",
                "superschopnosť",
                "zlo",
                "zloduch",
                "zločinec",
                "žena",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("super negativka"),
            keywords: &[
                "kriminalka",
                "negativka",
                "super moč",
                "super negativka",
                "zlobna",
                "ženska",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("haweeney shayddaannimadeedu sareeyso"),
            keywords: &[
                "awood sareeysa",
                "dambiile",
                "haweeney",
                "haweeney shayddaannimadeedu sareeyso",
                "qof sheyddaan ah",
                "xun",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("superzuzare"),
            keywords: &["e ligë", "kriminele", "superfuqi", "superzuzare", "zuzare"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена негативац"),
            keywords: &[
                "жена",
                "жена негативац",
                "зло",
                "злочинац",
                "криминал",
                "супер моћ",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["жена негативац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena negativac"),
            keywords: &[
                "kriminal",
                "super moć",
                "zlo",
                "zločinac",
                "žena",
                "žena negativac",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["žena negativac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig superskurk"),
            keywords: &[
                "brottsling",
                "kvinna",
                "kvinnlig superskurk",
                "ond",
                "skurk",
                "superkraft",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jambazi wa kike"),
            keywords: &[
                "jambazi",
                "jambazi wa kike",
                "mhalifu",
                "mwanamke",
                "nguvu zisizo za kawaida",
                "uovu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூப\u{bcd}பர\u{bcd} வில\u{bcd}லி"),
            keywords: &[
                "குற\u{bcd}றவ\u{bbe}ளி",
                "சூப\u{bcd}பர\u{bcd} பவர\u{bcd}",
                "சூப\u{bcd}பர\u{bcd} வில\u{bcd}லி",
                "த\u{bc0}யவர\u{bcd}",
                "வில\u{bcd}லன\u{bcd}",
                "வில\u{bcd}லி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉమ\u{c46}న\u{c4d} సూపర\u{c4d}\u{200c}వ\u{c3f}లన\u{c4d}"),
            keywords: &[
                "ఉమ\u{c46}న\u{c4d}",
                "ఉమ\u{c46}న\u{c4d} సూపర\u{c4d}\u{200c}వ\u{c3f}లన\u{c4d}",
                "క\u{c4d}ర\u{c3f}మ\u{c3f}నల\u{c4d}",
                "చ\u{c46}డు",
                "వ\u{c3f}లన\u{c4d}",
                "సూపర\u{c4d}\u{200c}పవర\u{c4d}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นางร\u{e49}าย"),
            keywords: &[
                "ต\u{e31}วร\u{e49}าย",
                "นางร\u{e49}าย",
                "ป\u{e35}ศาจ",
                "ผ\u{e39}\u{e49}ร\u{e49}าย",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "อาชญากร",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan superbetpäl"),
            keywords: &[
                "betpäl",
                "erbet",
                "jenaýatçy",
                "supergüýç",
                "zenan",
                "zenan superbetpäl",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine kākā"),
            keywords: &["fefine kākā"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın süper kötü"),
            keywords: &[
                "kadın",
                "kadın süper kötü",
                "kötü",
                "suçlu",
                "süper güç",
                "şeytani",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("суперлиходійка"),
            keywords: &[
                "жінка",
                "зло",
                "злодій",
                "злочинець",
                "суперлиходійка",
                "суперсила",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خاتون سپر ولن"),
            keywords: &["برائی", "خاتون سپر ولن", "سپر پاور", "عورت", "مجرم", "ولن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("salbiy ayol superqahramon"),
            keywords: &[
                "jinoyat",
                "salbiy ayol superqahramon",
                "salbiy qahramon",
                "superkuch",
                "yovuz",
                "yovuzlik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nữ siêu phản diện"),
            keywords: &[
                "nhân vật phản diện",
                "nữ siêu phản diện",
                "phụ nữ",
                "siêu năng lực",
                "tội phạm",
                "ác",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("超級女壞人"),
            keywords: &["壞人", "犯罪", "超人", "超級女壞人", "邪惡｜女"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("超级女坏人"),
            keywords: &["坏人", "犯罪", "超人", "超级女坏人", "邪恶｜女"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女超级大坏蛋"),
            keywords: &["坏蛋", "女人", "女超级大坏蛋", "罪犯", "超能力"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女超級反派"),
            keywords: &["反派", "女人", "女超級反派", "犯罪", "超能力", "邪惡"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("woman supervillain"),
            keywords: &[
                "criminal",
                "evil",
                "superpower",
                "villain",
                "woman",
                "woman supervillain",
            ],
        },
    ],
};
#[doc = "🦹🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERVILLAIN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9B9 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman supervillain: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏻\u{200d}♀",
        codepoint: "1F9B9 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman supervillain: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERVILLAIN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9B9 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman supervillain: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏼\u{200d}♀",
        codepoint: "1F9B9 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman supervillain: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERVILLAIN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9B9 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman supervillain: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏽\u{200d}♀",
        codepoint: "1F9B9 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman supervillain: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERVILLAIN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9B9 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman supervillain: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏾\u{200d}♀",
        codepoint: "1F9B9 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman supervillain: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🦹🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_SUPERVILLAIN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦹🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9B9 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman supervillain: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🦹🏿\u{200d}♀",
        codepoint: "1F9B9 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 11f32,
        name: "woman supervillain: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙"]
pub const MAGE: crate::Emoji = crate::Emoji {
    glyph: "🧙",
    codepoint: "1F9D9",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mage",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("magus"),
            keywords: &["heks", "magus", "toorder", "towenaar", "towenares"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አስማት"),
            keywords: &["አስማት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سحرة"),
            keywords: &["سحرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}দ\u{9c1}কৰ"),
            keywords: &[
                "ঐন\u{9cd}দ\u{9cd}ৰজ\u{9be}লিক",
                "ড\u{9be}ইনি",
                "ম\u{9be}য\u{9bc}\u{9be}বী",
                "য\u{9be}দ\u{9c1}কৰ",
                "য\u{9be}দ\u{9c1}কৰী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("maq"),
            keywords: &["cadugər", "küpəgirən qarı", "maq", "ovsunçu", "sehrbaz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чараўнік"),
            keywords: &["ведзьма", "вядзьмак", "чараўнік", "чараўніца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена магьосник"),
            keywords: &["вещица", "жена магьосник", "магьосница"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেজ"),
            keywords: &[
                "উইচ",
                "উইজ\u{9be}র\u{9cd}ড",
                "জ\u{9be}দ\u{9c1}কর",
                "জ\u{9be}দ\u{9c1}করী",
                "মেজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("maj"),
            keywords: &["maj", "sorser"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("čarobnjak"),
            keywords: &["mag", "vještica", "vrač", "čarobnjak", "čarobnjakinja"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mag"),
            keywords: &["bruixa", "bruixot", "fetiller", "fetillera", "mag"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏪ"),
            keywords: &["ᎠᏓᏪ", "ᏗᏓᏁᏎᏍᎩ", "ᏗᏓᏁᏎᏍᎩ ᎠᎨᏯ", "ᏗᏙᏂᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mág"),
            keywords: &["kouzelník", "mág", "čaroděj", "čarodějník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dewin"),
            keywords: &["dewin", "gwrach", "swynwr", "swynwraig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("magiker"),
            keywords: &["magi", "magiker", "mand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Magier(in)"),
            keywords: &["Hexe", "Hexenmeister", "Magier(in)", "Zauberer", "Zauberin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάγος"),
            keywords: &["μάγισσα", "μάγος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mage"),
            keywords: &["mage", "sorcerer", "sorceress", "witch", "wizard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona maga"),
            keywords: &["bruja", "brujo", "hechicera", "hechicero", "persona maga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("maag"),
            keywords: &["maag", "nõiamoor", "nõid", "võlur"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mago"),
            keywords: &["azti", "mago", "sorgin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساحر"),
            keywords: &["افسونگر", "جادوگر", "جادوگر زن", "ساحر", "ساحره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("velho"),
            keywords: &[
                "maagi",
                "noita",
                "sauva",
                "taikasauva",
                "taikavoima",
                "taikuri",
                "tietäjä",
                "velho",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("salamangkero"),
            keywords: &["mangkukulam", "salamangkero", "wizard"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur sum dugir gand"),
            keywords: &["fólk", "galdur", "persónur sum dugir gand", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mage"),
            keywords: &["ensorceleur", "mage", "magicien", "sorcier", "sorcière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["enchanteur", "mage", "magicien", "sorcier", "sorcière"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine draíochta"),
            keywords: &["asarlaí", "cailleach", "draoi", "duine draíochta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("draoidh"),
            keywords: &["ban-draoidh", "bana-bhuidseach", "buidseach", "draoidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("feiticeiro"),
            keywords: &["druída", "feiticeiro", "meigo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મ\u{ac7}જ"),
            keywords: &["મ\u{ac7}જ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai dabo"),
            keywords: &["mai dabo", "maye", "mayya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קוסם"),
            keywords: &["אשף", "כישוף", "מכשף", "קוסם", "קסם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जाद\u{942}गर, करामाती"),
            keywords: &[
                "जाद\u{942}गर",
                "जाद\u{942}गर, करामाती",
                "जाद\u{942}गरनी",
                "भ\u{942}तसाधक",
                "भ\u{942}तसाधिका",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("magičar"),
            keywords: &["magičar", "vještac", "vještica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("varázsló"),
            keywords: &["boszorkány", "boszorkánymester", "mágus", "varázsló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մոգ"),
            keywords: &["կախարդ", "մոգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("magi"),
            keywords: &["magi", "penyihir", "tukang sihir"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye abrakatabra"),
            keywords: &[
                "dibia nwanyị",
                "dibịa nwoke",
                "nwanyị kwenyere n’ike abrakatabra",
                "nwoke kwenyere n’ike abrakatabra",
                "onye abrakatabra",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("galdramaður"),
            keywords: &["galdramaður", "norn", "seiðkarl", "seiðkona"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mago"),
            keywords: &["mago", "strega", "stregone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("魔法使い"),
            keywords: &["魔女", "魔法", "魔法使い"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong winasis"),
            keywords: &["bagawan", "dhukun", "resi", "wong winasis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯადოქარი"),
            keywords: &[
                "გრძნეული",
                "თვალთმაქცი",
                "კუდიანი",
                "მაგი",
                "მაჩხიბი",
                "მისანი",
                "ჯადოსანი",
                "ჯადოქარი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сиқыршы"),
            keywords: &["сиқыршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកវេទមន\u{17d2}ត"),
            keywords: &[
                "ធ\u{17d2}មប\u{17cb}",
                "អ\u{17d2}នកមន\u{17d2}តអាគម",
                "អ\u{17d2}នកវេទមន\u{17d2}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಂತ\u{ccd}ರವಾದ\u{cbf}"),
            keywords: &[
                "ಮಂತ\u{ccd}ರವಾದ\u{cbf}",
                "ಮಾಟಗಾತ\u{cbf}",
                "ವ\u{cbf}ಜಾರ\u{ccd}ಡ\u{ccd}",
                "ಸೋರ\u{ccd}ಸ\u{cc6}ರರ\u{ccd}",
                "ಸೋರ\u{ccd}ಸ\u{ccd}\u{200c}ರ\u{cc6}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("마법사"),
            keywords: &["마녀", "마법사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जाद\u{942}टोणो करपी"),
            keywords: &[
                "च\u{947}टकीण",
                "च\u{947}ट\u{942}क",
                "जाद\u{942}टोणो करपी",
                "सोरस\u{947}रर",
                "सोरस\u{947}र\u{947}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сыйкырчы"),
            keywords: &["жадыгер", "маг", "сыйкырчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zauberer(in)"),
            keywords: &["Hex", "Hexemeeschter", "Zauberer", "Zauberer(in)"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ວ\u{eb4}ເສດ"),
            keywords: &[
                "ນ\u{eb1}ກເວດຊາຍ",
                "ນ\u{eb1}ກເວດຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ວ\u{eb4}ເສດ",
                "ພ\u{ecd}\u{ec8}ມ\u{ebb}ດ",
                "ແມ\u{ec8}ມ\u{ebb}ດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("magas"),
            keywords: &["burtininkas", "kerėtoja", "kerėtojas", "magas", "ragana"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mags"),
            keywords: &["burvis", "mags", "ragana"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāngata matakite"),
            keywords: &[
                "rūānuku",
                "tohunga mākutu",
                "tāngata matakite",
                "wahine mākutu",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("магичар"),
            keywords: &[
                "вештерка",
                "волшебник",
                "магичар",
                "маѓепсник",
                "маѓепсница",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}ലവിദ\u{d4d}യ അറിയ\u{d41}ന\u{d4d}നയ\u{d3e}ൾ"),
            keywords: &[
                "ജ\u{d3e}ലവിദ\u{d4d}യ അറിയ\u{d41}ന\u{d4d}നയ\u{d3e}ൾ",
                "മന\u{d4d}ത\u{d4d}രവ\u{d3e}ദി",
                "മ\u{d3e}ന\u{d4d}ത\u{d4d}രികൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шидтэн"),
            keywords: &["бөө", "илбэчин", "шидтэн", "шулам"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जाद\u{941}गर"),
            keywords: &[
                "च\u{947}टकीण",
                "च\u{947}टक\u{94d}या",
                "जाद\u{941}गर",
                "जाद\u{941}गार",
                "विझार\u{94d}ड",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ahli silap mata"),
            keywords: &["ahli sihir", "ahli silap mata", "dukun sihir"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("magu"),
            keywords: &["magu", "saħħar", "saħħara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{103e}ော\u{103a}ဆရာ"),
            keywords: &[
                "စ\u{102f}န\u{103a}းမ",
                "မ\u{103e}ော\u{103a}ဆရာ",
                "ဝ\u{102d}ဇ\u{1039}ဇာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trollperson"),
            keywords: &["heks", "trollkvinne", "trollmann", "trollperson"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जाद\u{941}गर"),
            keywords: &[
                "जाद\u{941}गर",
                "ट\u{941}नाम\u{941}ना जान\u{94d}न\u{947} छोरामान\u{94d}छ\u{947}",
                "ट\u{941}नाम\u{941}ना जान\u{94d}न\u{947} छोरीमान\u{94d}छ\u{947}",
                "बोक\u{94d}सा",
                "बोक\u{94d}सी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("magiër"),
            keywords: &["heks", "magiër", "tovenaar", "tovenares"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trollperson"),
            keywords: &["heks", "trollkvinne", "trollmann", "trollperson"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯ\u{b3e}ଦ\u{b41}କର"),
            keywords: &[
                "ଯ\u{b3e}ଦ\u{b41}କର",
                "ଯ\u{b3e}ଦ\u{b41}କର । ଡ\u{b3e}ହ\u{b3e}ଣୀ । ଯ\u{b3e}ଦ\u{b41}କର । ତନ\u{b4d}ତ\u{b4d}ରକ\u{b3e}ର\u{b3f}ଣୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਦ\u{a42}ਗਰ"),
            keywords: &["ਜਾਦ\u{a42}ਗਰ", "ਜਾਦ\u{a42}ਗਰਨੀ", "ਡ\u{a48}ਣ", "ਸਹਾਇਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جادوگر"),
            keywords: &["جادوگر", "جادوگرنی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Majíshan"),
            keywords: &[
                "Jujú Man",
                "Jujú Wúman",
                "Majíkshan",
                "Majíshan",
                "Man Wích",
                "Wích",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mag"),
            keywords: &["czarnoksiężnik", "czarodziej", "mag"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جادوګر"),
            keywords: &["جادوګر", "جادوګره", "مداري", "ويزارډ", "کوډګره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mago"),
            keywords: &["bruxa", "feiticeira", "maga", "mago"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bruxa", "bruxo", "feiticeira", "feiticeiro", "maga", "mago"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("watuq"),
            keywords: &[
                "runa layqa",
                "runa watuq",
                "warmi layqa",
                "warmi watuq",
                "watuq",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mag"),
            keywords: &["mag", "magician", "vraci", "vrăjitor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1130"),
            keywords: &["E10-1130"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("маг"),
            keywords: &["волшебник", "маг", "чародей"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umumaji"),
            keywords: &["umumaji", "umupfumu", "umupfumukazi", "umurozi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جادوگر"),
            keywords: &["جادوگر", "جادوگر، ڏائڻ، جادوگر، جادوگرني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dcf}ය\u{dcf}කර\u{dd4}ව\u{dcf}"),
            keywords: &[
                "මන\u{dca}ත\u{dca}\u{200d}රක\u{dcf}ර\u{dd2}ය",
                "ම\u{dcf}ය\u{dcf}කර\u{dd4}ව\u{dcf}",
                "ම\u{dcf}ය\u{dcf}ක\u{dcf}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čarodejná bytosť"),
            keywords: &[
                "bosorák",
                "kúzelník",
                "strigôň",
                "čarodejná bytosť",
                "čarodejník",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki čara"),
            keywords: &["oseba, ki čara", "čarovnica", "čarovnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sixiroole"),
            keywords: &[
                "naag saaxirad",
                "saaxir",
                "saaxirad",
                "sixir yaqaan",
                "sixiroole",
                "xirfadda sixirka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("magjistar"),
            keywords: &["magjistar", "magjistricë", "shtrigë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("маг"),
            keywords: &["вештица", "маг", "чаробњак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mag"),
            keywords: &["mag", "veštica", "čarobnjak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("magiker"),
            keywords: &["häxa", "magiker", "trollkarl"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlozi"),
            keywords: &["mchawi", "mchawi wa kike", "mlozi", "mlozi mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மந\u{bcd}திரவ\u{bbe}தி"),
            keywords: &[
                "மந\u{bcd}திரவ\u{bbe}தி",
                "ம\u{bbe}யவித\u{bcd}தைக\u{bcd}க\u{bbe}ரர\u{bcd}",
                "ம\u{bbe}ய\u{bbe}வி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కుడు"),
            keywords: &[
                "ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కుడు",
                "ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కుర\u{c3e}లు",
                "మంత\u{c4d}రగత\u{c4d}త\u{c46}",
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("коҳин"),
            keywords: &[
                "зани афсунгар",
                "коҳин",
                "марди афсунгар",
                "соҳир",
                "ҷодугар",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e31}กเวทย\u{e4c}"),
            keywords: &[
                "น\u{e31}กเวทย\u{e4c}",
                "ผ\u{e39}\u{e49}ว\u{e34}เศษ",
                "พ\u{e48}อมด",
                "แม\u{e48}มด",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jadygöý"),
            keywords: &["dogagöý", "gözbagçy", "jadygöý", "porhan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha taula-faʻahikehe"),
            keywords: &["tokotaha taula-faʻahikehe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("büyücü"),
            keywords: &["büyücü", "cadı", "sihirbaz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سېھرىگەر"),
            keywords: &["جادۇ", "جادۇگەر", "سھېرى", "سېھرىگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("маг"),
            keywords: &["відьма", "маг", "чаклун", "чаклунка", "чародій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جادوگر"),
            keywords: &["جادوگر", "جادوگرنی", "ساحر", "ماہر جادوگر", "ڈائن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sehrgar"),
            keywords: &["afsungar", "jodugar", "kohin", "sehrgar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháp sư"),
            keywords: &["bà cốt", "pháp sư", "phù thủy", "thầy phù thuỷ", "đạo sĩ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mage"),
            keywords: &["dëmm", "luxuskat", "mage"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-mage"),
            keywords: &["i-mage", "igqwirha", "igqwirhakazi", "umntu onobugqi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("onídán"),
            keywords: &["onídán", "oṣó", "àjẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("巫師"),
            keywords: &["女巫", "巫婆", "巫師", "男巫"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("巫师"),
            keywords: &["女巫", "巫婆", "巫师", "男巫"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("法师"),
            keywords: &["女巫", "女魔术师", "法师", "男巫", "男魔术师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("魔術師"),
            keywords: &["魔術師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("巫師"),
            keywords: &["巫師", "術士", "魔法師"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-mage"),
            keywords: &["i-mage", "isangoma", "iwizadi", "izangoma", "umthakathi"],
        },
    ],
};
#[doc = "🧙🏻"]
pub const MAGE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏻",
    codepoint: "1F9D9 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mage: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧙🏼"]
pub const MAGE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏼",
    codepoint: "1F9D9 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mage: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧙🏽"]
pub const MAGE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏽",
    codepoint: "1F9D9 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mage: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧙🏾"]
pub const MAGE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏾",
    codepoint: "1F9D9 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mage: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧙🏿"]
pub const MAGE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏿",
    codepoint: "1F9D9 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mage: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧙\u{200d}♂\u{fe0f}"]
pub const MAN_MAGE: crate::Emoji = crate::Emoji {
    glyph: "🧙\u{200d}♂\u{fe0f}",
    codepoint: "1F9D9 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man mage",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙\u{200d}♂",
        codepoint: "1F9D9 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man mage",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike magus"),
            keywords: &["manlike magus", "towenaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አስማተኛ ወንድ"),
            keywords: &["አስማተኛ ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساحر"),
            keywords: &["ساحر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ য\u{9be}দ\u{9c1}কৰ"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষ য\u{9be}দ\u{9c1}কৰ", "য\u{9be}দ\u{9c1}কৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi maq"),
            keywords: &["kişi maq", "ovsunçu", "sehrbaz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чарадзей"),
            keywords: &["вядзьмак", "чарадзей", "чараўнік"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж магьосник"),
            keywords: &["вълшебник", "мъж магьосник", "чародей"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ মেজ"),
            keywords: &[
                "উইজ\u{9be}র\u{9cd}ড",
                "জ\u{9be}দ\u{9c1}কর",
                "প\u{9c1}র\u{9c1}ষ মেজ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hudour"),
            keywords: &["hudour"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac čarobnjak"),
            keywords: &["mag", "muškarac čarobnjak", "čarobnjak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home mag"),
            keywords: &["bruixot", "fetiller", "home mag"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎠᏓᏪ"),
            keywords: &["ᎠᏍᎦᏯ ᎠᏓᏪ", "ᎠᏓᏪ", "ᏗᏓᏁᏎᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("čaroděj"),
            keywords: &["kouzelník", "mág", "čaroděj", "čarodějník"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dewin gwrywaidd"),
            keywords: &["dewin", "dewin gwrywaidd", "swynwr"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig magiker"),
            keywords: &["magi", "mand", "mandlig magiker"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Magier"),
            keywords: &["Hexenmeister", "Magier", "Zauberer"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας μάγος"),
            keywords: &["άντρας μάγος", "μάγος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man mage"),
            keywords: &["man mage", "sorcerer", "wizard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mago"),
            keywords: &["brujo", "hechicero", "mago"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesmaag"),
            keywords: &["meesmaag", "võlur"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon mago"),
            keywords: &["belagile", "gizon mago"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساحر مرد"),
            keywords: &["ساحر", "ساحر مرد", "طلسم\u{200c}گر مرد", "مرد جادوگر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesvelho"),
            keywords: &[
                "maagi",
                "miesvelho",
                "noita",
                "sauva",
                "taikasauva",
                "taikavoima",
                "taikuri",
                "tietäjä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking salamangkero"),
            keywords: &["lalaking salamangkero", "wizard"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gandakallur"),
            keywords: &[
                "gandakallur",
                "gandur",
                "kallur",
                "maður",
                "trøllmaður",
                "ævintýr",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mage homme"),
            keywords: &["mage homme", "magicien", "sorcier"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["enchanteur", "homme", "mage", "magicien", "sorcier"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear draíochta"),
            keywords: &["draoi", "fear draíochta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("draoidh fireann"),
            keywords: &["buidseach", "draoidh", "draoidh fireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("meigo"),
            keywords: &["druída", "feiticeiro", "meigo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ મ\u{ac7}જ"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ મ\u{ac7}જ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai dabo"),
            keywords: &["maye", "mutum mai dabo"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קוסם עם זקן"),
            keywords: &["כישוף", "מכשף", "קוסם", "קוסם עם זקן", "קסם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("करामाती प\u{941}र\u{941}ष"),
            keywords: &["करामाती प\u{941}र\u{941}ष", "जाद\u{942}गर", "भ\u{942}तसाधक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čarobnjak"),
            keywords: &["vještac", "čarobnjak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi varázsló"),
            keywords: &["boszorkánymester", "férfi varázsló", "mágus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կախարդ"),
            keywords: &["կախարդ", "մոգ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("magi pria"),
            keywords: &["magi pria", "penyihir", "tukang sihir"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke abrakatabra"),
            keywords: &[
                "dibia nwoke",
                "nwoke abrakatabra",
                "nwoke kwenyere n’ike abrakatabra",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("galdrakarl"),
            keywords: &["galdrakarl", "seiðkarl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mago uomo"),
            keywords: &["mago", "mago uomo", "stregone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男の魔法使い"),
            keywords: &["男", "男の魔法使い", "男性", "魔法使い"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong winasis lanang"),
            keywords: &["bagawan", "dhukun", "wong winasis lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯადოქარი კაცი"),
            keywords: &["მისანი", "ჯადოსანი", "ჯადოქარი", "ჯადოქარი კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер сиқыршы"),
            keywords: &["ер сиқыршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកវេទមន\u{17d2}តប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ធ\u{17d2}មប\u{17cb}ប\u{17d2}រ\u{17bb}ស",
                "អ\u{17d2}នកមន\u{17d2}តអាគមប\u{17d2}រ\u{17bb}ស",
                "អ\u{17d2}នកវេទមន\u{17d2}តប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಮಂತ\u{ccd}ರವಾದ\u{cbf}"),
            keywords: &[
                "ಪುರುಷ ಮಂತ\u{ccd}ರವಾದ\u{cbf}",
                "ವ\u{cbf}ಜಾರ\u{ccd}ಡ\u{ccd}",
                "ಸೋರ\u{ccd}ಸರರ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 마법사"),
            keywords: &["남자 마법사", "마법사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जाद\u{942}टोणो करपी दादलो"),
            keywords: &[
                "जाद\u{942}टोणो करपी दादलो",
                "व\u{94d}हिझार\u{94d}ड",
                "सोरस\u{947}रर",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек сыйкырчы"),
            keywords: &["сыйкырчы", "эркек сыйкырчы"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zauberer"),
            keywords: &["Hexemeeschter", "Zauberer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ວ\u{eb4}ເສດຊາຍ"),
            keywords: &["ຜ\u{eb9}\u{ec9}ວ\u{eb4}ເສດຊາຍ", "ພ\u{ecd}\u{ec8}ມ\u{ebb}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyras magas"),
            keywords: &["burtininkas", "kerėtojas", "vyras magas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zintnieks"),
            keywords: &["burvis", "zintnieks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohunga matakite"),
            keywords: &["rūānuku", "tohunga matakite", "tohunga mākutu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж магичар"),
            keywords: &["волшебник", "маж магичар", "маѓепсник"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}ലവിദ\u{d4d}യക\u{d4d}ക\u{d3e}രൻ"),
            keywords: &[
                "ജ\u{d3e}ലവിദ\u{d4d}യക\u{d4d}ക\u{d3e}രൻ",
                "മന\u{d4d}ത\u{d4d}രവ\u{d3e}ദി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй шидтэн"),
            keywords: &["бөө", "чөтгөр", "эрэгтэй шидтэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष जाद\u{941}गर"),
            keywords: &[
                "च\u{947}टकीण",
                "च\u{947}टक\u{94d}या",
                "प\u{941}र\u{942}ष जाद\u{941}गर",
                "प\u{941}र\u{942}ष जाद\u{941}गार",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ahli sihir lelaki"),
            keywords: &["ahli sihir lelaki", "dukun sihir lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel magu"),
            keywords: &["assistent", "raġel magu", "saħħar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား မ\u{103e}ော\u{103a}ဆရာ"),
            keywords: &[
                "မ\u{103e}ော\u{103a}ဆရာ",
                "အမျ\u{102d}\u{102f}းသား မ\u{103e}ော\u{103a}ဆရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trollmann"),
            keywords: &["heksemester", "trollmann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरामान\u{94d}छ\u{947} जाद\u{941}गर"),
            keywords: &[
                "छोरामान\u{94d}छ\u{947} जाद\u{941}गर",
                "ट\u{941}नाम\u{941}ना जान\u{94d}न\u{947} छोरामान\u{94d}छ\u{947}",
                "बोक\u{94d}सा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke magiër"),
            keywords: &["heksenmeester", "mannelijke magiër", "tovenaar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trollmann"),
            keywords: &["heksemeister", "trollmann"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ଯ\u{b3e}ଦ\u{b41}କର"),
            keywords: &[
                "ପ\u{b41}ର\u{b41}ଷ ଯ\u{b3e}ଦ\u{b41}କର",
                "ଯ\u{b3e}ଦ\u{b41}କର । ତ\u{b3e}ନ\u{b4d}ତ\u{b4d}ର\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਦਮੀ ਜਾਦ\u{a42}ਗਰ"),
            keywords: &["ਆਦਮੀ ਜਾਦ\u{a42}ਗਰ", "ਜਾਦ\u{a42}ਗਰ", "ਸਹਾਇਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جادوگر بندہ"),
            keywords: &["جادوگر", "جادوگر بندہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Majíshan"),
            keywords: &["Jujú Man", "Man Wích", "Mán Majíkshan", "Mán Majíshan"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna mag"),
            keywords: &["czarnoksiężnik", "czarodziej", "mężczyzna mag"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی جادوګر"),
            keywords: &["جادوګره", "سړی جادوګر", "کوډګر"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem mago"),
            keywords: &["feiticeiro", "homem mago", "mago"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["bruxo", "feiticeiro", "homem mago"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata watuq"),
            keywords: &["layqa", "tata watuq", "watuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat mag"),
            keywords: &["bărbat mag", "magician", "vraci", "vrăjitor"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1251"),
            keywords: &["E10-1251"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("волшебник"),
            keywords: &["волшебник", "маг", "чародей"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umumajigabo"),
            keywords: &["umumajigabo", "umupfumu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد، جادوگر"),
            keywords: &["جادوگر", "مرد، جادوگر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ම\u{dcf}ය\u{dcf}කර\u{dd4}ව\u{dcf}"),
            keywords: &[
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ම\u{dcf}ය\u{dcf}කර\u{dd4}ව\u{dcf}",
                "මන\u{dca}ත\u{dca}\u{200d}රකර\u{dd4}ව\u{dcf}",
                "ම\u{dcf}ය\u{dcf}කර\u{dd4}ව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čarodejník"),
            keywords: &["bosorák", "kúzelník", "strigôň", "čarodejník"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čarovnik"),
            keywords: &["mag", "čarodej", "čarovnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin xirfad u leh sixirka"),
            keywords: &["nin xirfad u leh sixirka", "saaxir", "saaxirad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë magjistar"),
            keywords: &["burrë magjistar", "magjistar", "shtrigan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаробњак"),
            keywords: &["вештац", "чаробњак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чаробњак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čarobnjak"),
            keywords: &["veštac", "čarobnjak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čarobnjak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig magiker"),
            keywords: &["manlig magiker", "trollkarl"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mchawi wa kiume"),
            keywords: &["mchawi wa kiume", "mlozi wa kiume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} மந\u{bcd}திரவ\u{bbe}தி"),
            keywords: &["ஆண\u{bcd}", "மந\u{bcd}திரவ\u{bbe}தி", "ம\u{bbe}ய\u{bbe}வி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంత\u{c4d}రగ\u{c3e}డు"),
            keywords: &[
                "ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కుడు",
                "మంత\u{c4d}రగ\u{c3e}డు",
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди коҳин"),
            keywords: &["марди афсунгар", "марди коҳин", "соҳир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พ\u{e48}อมด"),
            keywords: &["ผ\u{e39}\u{e49}ว\u{e34}เศษ", "พ\u{e48}อมด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jadygöý erkek"),
            keywords: &["gözbagçy", "jadygöý", "jadygöý erkek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata taula-faʻahikehe"),
            keywords: &["tangata taula-faʻahikehe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek büyücü"),
            keywords: &["büyücü", "erkek büyücü", "sihirbaz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر سېھرىگەر"),
            keywords: &["ئەر سېھرىگەر", "جادۇگەر", "سېھرىگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чаклун"),
            keywords: &["чаклун", "чародій"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جادوگر آدمی"),
            keywords: &["جادوگر", "جادوگر آدمی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak sehrgar"),
            keywords: &["afsungar", "erkak sehrgar", "jodugar", "kohin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháp sư nam"),
            keywords: &["pháp sư", "pháp sư nam", "phù thủy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mage bu góor"),
            keywords: &["dëmm", "luxuskat", "mage bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-mage eyindoda"),
            keywords: &["i-mage eyindoda", "igqwirha", "umntu onobugqi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkùnrin onídán"),
            keywords: &["Oṣó", "Ọkùnrin onídán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男巫師"),
            keywords: &["巫師", "男巫", "男巫師"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男巫师"),
            keywords: &["巫师", "男巫", "男巫师"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男法师"),
            keywords: &["男巫", "男法师", "男魔术师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男巫"),
            keywords: &["男巫"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男巫師"),
            keywords: &["巫師", "男巫師", "男魔法師", "魔法師"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-mage yowesilisa"),
            keywords: &["i-mage yowesilisa", "isangoma", "iwizadi"],
        },
    ],
};
#[doc = "🧙🏻\u{200d}♂\u{fe0f}"]
pub const MAN_MAGE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9D9 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man mage: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏻\u{200d}♂",
        codepoint: "1F9D9 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man mage: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏼\u{200d}♂\u{fe0f}"]
pub const MAN_MAGE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9D9 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man mage: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏼\u{200d}♂",
        codepoint: "1F9D9 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man mage: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏽\u{200d}♂\u{fe0f}"]
pub const MAN_MAGE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9D9 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man mage: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏽\u{200d}♂",
        codepoint: "1F9D9 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man mage: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏾\u{200d}♂\u{fe0f}"]
pub const MAN_MAGE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9D9 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man mage: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏾\u{200d}♂",
        codepoint: "1F9D9 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man mage: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏿\u{200d}♂\u{fe0f}"]
pub const MAN_MAGE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9D9 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man mage: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏿\u{200d}♂",
        codepoint: "1F9D9 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man mage: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙\u{200d}♀\u{fe0f}"]
pub const WOMAN_MAGE: crate::Emoji = crate::Emoji {
    glyph: "🧙\u{200d}♀\u{fe0f}",
    codepoint: "1F9D9 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman mage",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙\u{200d}♀",
        codepoint: "1F9D9 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman mage",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike magus"),
            keywords: &["heks", "towenares", "vroulike magus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አስማተኛ ሴት"),
            keywords: &["አስማተኛ ሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساحرة"),
            keywords: &["ساحرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} য\u{9be}দ\u{9c1}কৰ"),
            keywords: &[
                "ড\u{9be}ইনি",
                "মহিল\u{9be} য\u{9be}দ\u{9c1}কৰ",
                "য\u{9be}দ\u{9c1}কৰণী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın maq"),
            keywords: &["cadugər", "küpəgirən qarı", "qadın maq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чараўніца"),
            keywords: &["ведзьма", "чарадзейка", "чараўніца"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("магьосница"),
            keywords: &["вълшебница", "магьосница", "чародейка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} মেজ"),
            keywords: &["উইচ", "জ\u{9be}দ\u{9c1}করী", "মহিল\u{9be} মেজ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("hudourez"),
            keywords: &["hudourez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena čarobnjak"),
            keywords: &["vještica", "čarobnica", "žena čarobnjak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona maga"),
            keywords: &["bruixa", "dona maga", "fetillera"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎠᏓᏪ"),
            keywords: &["ᎠᎨᏯ ᎠᏓᏪ", "ᏗᏓᏁᏎᏍᎩ", "ᏗᏙᏂᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("čarodějka"),
            keywords: &["kouzelnice", "mágyně", "vědma", "čarodějka", "čarodějnice"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dewin benywaidd"),
            keywords: &["dewin benywaidd", "dewines", "gwrach", "swynwraig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig magiker"),
            keywords: &["kvinde", "kvindelig magiker", "magi", "troldkvinde"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Magierin"),
            keywords: &["Hexe", "Magierin", "Zauberin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάγισσα"),
            keywords: &["μάγισσα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman mage"),
            keywords: &["sorceress", "witch", "woman mage"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("maga"),
            keywords: &["bruja", "hechicera", "maga"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naismaag"),
            keywords: &["naismaag", "nõid"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume mago"),
            keywords: &["emakume mago", "sorgin"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ساحر زن"),
            keywords: &["افسونگر", "جادوگر زن", "زن جادوگر", "ساحر زن", "ساحره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisvelho"),
            keywords: &[
                "maagi",
                "naisvelho",
                "noita",
                "sauva",
                "taikasauva",
                "taikavoima",
                "taikuri",
                "tietäjä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng salamangkero"),
            keywords: &["babaeng salamangkero", "mangkukulam"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gandakelling"),
            keywords: &[
                "gandakelling",
                "gandakona",
                "gandur",
                "kelling",
                "kona",
                "kvinna",
                "ævintýr",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mage femme"),
            keywords: &["ensorceleuse", "mage femme", "sorcière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["enchanteresse", "femme", "mage", "magicienne", "sorcière"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean dhraíochta"),
            keywords: &["bean dhraíochta", "cailleach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ban-draoidh"),
            keywords: &["ban-draoidh", "bana-bhuidseach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("meiga"),
            keywords: &["bruxa", "feiticeira", "meiga"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી મ\u{ac7}જ"),
            keywords: &["સ\u{acd}ત\u{acd}રી મ\u{ac7}જ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai dabo"),
            keywords: &["mace mai dabo", "mayya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("קוסמת"),
            keywords: &["כישוף", "מכשפה", "קוסמת", "קסם"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("करामाती महिला"),
            keywords: &["करामाती महिला", "जाद\u{942}गरनी", "भ\u{942}तसाधिका"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("čarobnica"),
            keywords: &["vještica", "čarobnica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("varázslónő"),
            keywords: &["boszorkány", "varázslónő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կախարդուհի"),
            keywords: &["կախարդ", "կախարդուհի", "կին", "վհուկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("magi wanita"),
            keywords: &["magi wanita", "penyihir", "tukang sihir"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị onye abrakatabra"),
            keywords: &[
                "dibia nwanyị",
                "nwanyị kwenyere n’ike abrakatabra",
                "nwanyị onye abrakatabra",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("galdrakona"),
            keywords: &["galdrakona", "norn", "seiðkona"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("maga"),
            keywords: &["maga", "strega"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女の魔法使い"),
            keywords: &["女", "女の魔法使い", "女性", "魔女", "魔法使い"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong winasis wadon"),
            keywords: &["bagawan", "dhukun", "wong winasis wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯადოქარი ქალი"),
            keywords: &["ალქაჯი", "კუდიანი", "ჯადოქარი ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел сиқыршы"),
            keywords: &["әйел сиқыршы"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អ\u{17d2}នកវេទមន\u{17d2}តស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ធ\u{17d2}មប\u{17cb}ស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកមន\u{17d2}តអាគមស\u{17d2}រ\u{17b8}",
                "អ\u{17d2}នកវេទមន\u{17d2}តស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳಾ ಮಂತ\u{ccd}ರವಾದ\u{cbf}"),
            keywords: &[
                "ಮಹ\u{cbf}ಳಾ ಮಂತ\u{ccd}ರವಾದ\u{cbf}",
                "ಮಾಟಗಾತ\u{cbf}",
                "ಸೋರ\u{ccd}ಸ\u{cc6}ಸ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 마법사"),
            keywords: &["마녀", "마법사", "여자 마법사"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जाद\u{942}टोणो करपी बायल"),
            keywords: &["च\u{947}टकीण", "जाद\u{942}टोणो करपी बायल", "सोरस\u{947}रस"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял сыйкырчы"),
            keywords: &["аял сыйкырчы", "мастан"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hex"),
            keywords: &["Hex"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ວ\u{eb4}ເສດຍ\u{eb4}ງ"),
            keywords: &["ຜ\u{eb9}\u{ec9}ວ\u{eb4}ເສດຍ\u{eb4}ງ", "ແມ\u{ec8}ມ\u{ebb}ດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("magė"),
            keywords: &["kerėtoja", "magė", "ragana"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zintniece"),
            keywords: &["burve", "ragana", "zintniece"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine matakite"),
            keywords: &["wahine matakite", "wahine mākutu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена магичар"),
            keywords: &["вештерка", "жена магичар", "маѓепсница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജ\u{d3e}ലവിദ\u{d4d}യക\u{d4d}ക\u{d3e}രി"),
            keywords: &[
                "ജ\u{d3e}ലവിദ\u{d4d}യക\u{d4d}ക\u{d3e}രി",
                "മന\u{d4d}ത\u{d4d}രവ\u{d3e}ദിനി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй шидтэн"),
            keywords: &["бөө", "шулам", "эмэгтэй шидтэн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला जाद\u{941}गर"),
            keywords: &["च\u{947}टकीण", "च\u{947}टक\u{94d}या", "महिला जाद\u{941}गर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ahli sihir wanita"),
            keywords: &["ahli sihir wanita", "dukun sihir wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara magu"),
            keywords: &["mara magu", "saħħar", "saħħara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း မ\u{103e}ော\u{103a}ဆရာ"),
            keywords: &[
                "စ\u{102f}န\u{103a}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း မ\u{103e}ော\u{103a}ဆရာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("trollkvinne"),
            keywords: &["heks", "trollkvinne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरीमान\u{94d}छ\u{947} जाद\u{941}गर"),
            keywords: &[
                "छोरीमान\u{94d}छ\u{947} जाद\u{941}गर",
                "ट\u{941}नाम\u{941}ना जान\u{94d}न\u{947} छोरीमान\u{94d}छ\u{947}",
                "बोक\u{94d}सी",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke magiër"),
            keywords: &["heks", "tovenares", "vrouwelijke magiër"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("trollkvinne"),
            keywords: &["heks", "trollkvinne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ଯ\u{b3e}ଦ\u{b41}କର"),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣୀ । ତନ\u{b4d}ତ\u{b4d}ରକ\u{b3e}ର\u{b3f}ଣୀ",
                "ମହ\u{b3f}ଳ\u{b3e} ଯ\u{b3e}ଦ\u{b41}କର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਾਦ\u{a42}ਗਰਨੀ"),
            keywords: &["ਚ\u{a41}ੜ\u{a48}ਲ", "ਜਾਦ\u{a42}ਗਰਨੀ", "ਡ\u{a48}ਣ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جادوگر زنانی"),
            keywords: &["جادوگر زنانی", "جادوگرنی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Majíshan"),
            keywords: &[
                "Jujú Wúman",
                "Wúmán Majíkshan",
                "Wúmán Majíshan",
                "Wúmán Wích",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta mag"),
            keywords: &["czarownica", "kobieta mag", "wiedźma"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه جادوګره"),
            keywords: &["جادوګره", "ښځه جادوګره", "کوډګره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("maga"),
            keywords: &["bruxa", "feiticeira", "maga"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("maga"),
            keywords: &["bruxa", "feiticeira", "maga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi watuq"),
            keywords: &["bruja", "layqa", "warmi watuq"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie mag"),
            keywords: &["femeie mag", "magiciană", "vrăjitoare"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1250"),
            keywords: &["E10-1250"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("волшебница"),
            keywords: &["ведьма", "волшебница", "чародейка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umumajikazi"),
            keywords: &["umumajikazi", "umupfumukazi", "umurozi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جادوگرني"),
            keywords: &["عورت جادوگرني", "ڏائڻ، جادوگرني"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dcf}ය\u{dcf}ක\u{dcf}ර\u{dd2}ය"),
            keywords: &[
                "මන\u{dca}ත\u{dca}\u{200d}රක\u{dcf}ර\u{dd2}ය",
                "ම\u{dcf}ය\u{dcf}ක\u{dcf}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("čarodejníčka"),
            keywords: &["bosorka", "kúzelníčka", "striga", "čarodejníčka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("čarovnica"),
            keywords: &["čarodejka", "čarovnica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag xirfad u leh sixirka"),
            keywords: &["naag saaxirad", "naag xirfad u leh sixirka", "saaxirad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("magjistare"),
            keywords: &["magjistare", "magjistricë", "shtrigë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("чаробница"),
            keywords: &["вештица", "чаробница"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["чаробница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("čarobnica"),
            keywords: &["veštica", "čarobnica"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["čarobnica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig magiker"),
            keywords: &["häxa", "kvinnlig magiker"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mlozi wa kike"),
            keywords: &["mchawi", "mchawi wa kike", "mlozi wa kike"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} மந\u{bcd}திரவ\u{bbe}தி"),
            keywords: &[
                "சூனியக\u{bcd}க\u{bbe}ரி",
                "பெண\u{bcd} மந\u{bcd}திரவ\u{bbe}தி",
                "ம\u{bbe}ய\u{bbe}வி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మంత\u{c4d}రగత\u{c4d}త\u{c46}"),
            keywords: &[
                "ఇంద\u{c4d}రజ\u{c3e}ల\u{c3f}కుర\u{c3e}లు",
                "మంత\u{c4d}రగత\u{c4d}త\u{c46}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани коҳин"),
            keywords: &["зани афсунгар", "зани коҳин", "ҷодугар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แม\u{e48}มด"),
            keywords: &["ผ\u{e39}\u{e49}ว\u{e34}เศษ", "แม\u{e48}มด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jadygöý aýal"),
            keywords: &["dogagöý", "jadygöý", "jadygöý aýal"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine taula-faʻahikehe"),
            keywords: &["fefine taula-faʻahikehe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın büyücü"),
            keywords: &["büyücü", "cadı", "kadın büyücü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال سېھرىگەر"),
            keywords: &["ئايال سېھرىگەر", "داخان", "سېھرىگەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чаклунка"),
            keywords: &["відьма", "чаклунка", "чародійка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جادوگر عورت"),
            keywords: &["جادوگر عورت", "جادوگرنی", "چڑیل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol sehrgar"),
            keywords: &["ayol sehrgar", "jodugar", "kohin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("pháp sư nữ"),
            keywords: &["bà cốt", "pháp sư nữ", "phù thủy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mage bu jigéen"),
            keywords: &["dëmm", "mage bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-mage elibhinqa"),
            keywords: &["i-mage elibhinqa", "igqwirha", "igqwirhakazi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Obìnrin onídán"),
            keywords: &["Obìnrin onídán", "àjé\u{329}", "àjẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女巫師"),
            keywords: &["女巫", "女巫師", "巫婆"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女巫师"),
            keywords: &["女巫", "女巫师", "巫婆"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女法师"),
            keywords: &["女巫", "女法师", "女魔术师"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女巫師"),
            keywords: &["女巫師"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["女巫", "女巫師", "女術士", "女魔法師", "巫婆"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-mage yowesifazane"),
            keywords: &["i-mage yowesifazane", "isangoma", "umthakathi"],
        },
    ],
};
#[doc = "🧙🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_MAGE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9D9 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman mage: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏻\u{200d}♀",
        codepoint: "1F9D9 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman mage: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_MAGE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9D9 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman mage: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏼\u{200d}♀",
        codepoint: "1F9D9 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman mage: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_MAGE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9D9 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman mage: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏽\u{200d}♀",
        codepoint: "1F9D9 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman mage: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_MAGE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9D9 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman mage: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏾\u{200d}♀",
        codepoint: "1F9D9 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman mage: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧙🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_MAGE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧙🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9D9 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman mage: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧙🏿\u{200d}♀",
        codepoint: "1F9D9 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman mage: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚"]
pub const FAIRY: crate::Emoji = crate::Emoji {
    glyph: "🧚",
    codepoint: "1F9DA",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fairy",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("feetjie"),
            keywords: &["Oberan", "Puck", "Tatania", "feetjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጠንቋይ"),
            keywords: &["ጠንቋይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جني\u{651}ة خيالية"),
            keywords: &["جني\u{651}ة", "جني\u{651}ة خيالية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("পৰী"),
            keywords: &["অবেৰ’ন", "ট\u{9be}ইটেনিয\u{9bc}\u{9be}", "প\u{9be}ক", "পৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("pəri"),
            keywords: &["Oberon", "Puck", "Titania", "pəri"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("фея"),
            keywords: &["Абэрон", "Пак", "Тытанія", "фея"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("фея"),
            keywords: &["Оберон", "Пук", "Титания", "фея"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("পরী"),
            keywords: &[
                "ওবোরন",
                "ট\u{9be}ইটেনিয\u{9bc}\u{9be}",
                "দ\u{9c1}ষ\u{9cd}ট\u{9c1} ছেলে",
                "পরী",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("boudig"),
            keywords: &["Titania", "boudig"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vila"),
            keywords: &["Oberon", "Puck", "Titania", "vila"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("fada"),
            keywords: &["Oberó", "Puck", "Titània", "fada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᏍᏗ ᎦᏃᎯᎵᏙᎯ"),
            keywords: &["ᎣᏩᎾᏂ", "ᏋᎩ", "ᏘᏔᏂᏯ", "ᏴᏫ ᎤᏍᏗ ᎦᏃᎯᎵᏙᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("víla"),
            keywords: &["duch", "oberon", "puk", "skřítek", "titánie", "víla"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tylwyth teg"),
            keywords: &["Oberon", "Puck", "Titania", "tylwyth teg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fe"),
            keywords: &["fe", "magi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Märchenfee"),
            keywords: &["Märchenfee", "Oberon", "Puck", "Titania"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νεράιδα"),
            keywords: &["Oberon", "Puck", "Titania", "νεράιδα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("fairy"),
            keywords: &["Oberon", "Puck", "Titania", "fairy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hada"),
            keywords: &["campanilla", "hada", "oberón", "puck", "titania"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["campanita", "hada", "oberón", "puck", "titania"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("haldjas"),
            keywords: &["Oberon", "Puck", "Titania", "haldjas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("maitagarri"),
            keywords: &["Oberon", "Puck", "Titania", "maitagarri"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پری"),
            keywords: &[
                "ابرون",
                "تیتانیا",
                "جن و پری",
                "ملکه پریان",
                "هاب\u{200c}گابلین",
                "پادشاه پریان",
                "پری",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keiju"),
            keywords: &[
                "Oberon",
                "Puck",
                "Titania",
                "hyönteismäinen",
                "ilmatar",
                "keiju",
                "keijukainen",
                "luonnotar",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("diwata"),
            keywords: &["Oberon", "Puck", "Titania", "diwata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("álva"),
            keywords: &["álva", "álvur", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personnage féérique"),
            keywords: &["Obéron", "Puck", "Titania", "personnage féérique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["fée", "personnage féérique"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("síog"),
            keywords: &["síog"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sìthiche"),
            keywords: &["oberon", "puck", "sìth", "sìthiche", "titania"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fada"),
            keywords: &["fada"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પરી"),
            keywords: &["પરી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljana"),
            keywords: &["Oberon", "Puck", "Titania", "aljana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיה"),
            keywords: &["טיטניה", "טינקרבל", "פיה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("परी"),
            keywords: &["ऑब\u{947}रॉन", "टाइट\u{948}निया", "पक", "परी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vilinsko biće"),
            keywords: &["Kosjenka", "Malik Tintilinić", "vilinsko biće"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tündér"),
            keywords: &["Oberon", "Puck", "Titánia", "tündér"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("փերի"),
            keywords: &["Տիտանիա", "Օբերոն", "փերի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("peri"),
            keywords: &["Oberon", "Puck", "Titania", "peri"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akụkọ"),
            keywords: &["Oberon", "Puck", "Titania", "akụkọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("álfur"),
            keywords: &["Bokki", "Títanía", "Óberon", "álfur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fata"),
            keywords: &["Oberon", "Puck", "Titania", "fata"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("妖精"),
            keywords: &["オベロン", "パック", "伝説", "妖精", "魔法"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bangsa dewi"),
            keywords: &["Oberon", "Puck", "Titania", "bangsa dewi", "dewi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფერია"),
            keywords: &["ტიტანია", "ფერია"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("пері"),
            keywords: &["пері"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សទេព"),
            keywords: &[
                "ទ\u{17b8}តានៀ",
                "ផាក\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សទេព",
                "អ\u{17bc}បេរ\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯಕ\u{ccd}ಷ\u{cc6}"),
            keywords: &[
                "ಒಬ\u{cc6}ರಾನ\u{ccd}",
                "ಟ\u{cbf}ಟಾನ\u{cbf}ಯಾ",
                "ಪಕ\u{ccd}",
                "ಯಕ\u{ccd}ಷ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("요정"),
            keywords: &["요정"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("परी"),
            keywords: &["ओब\u{947}रॉन", "टिटानीया", "पक", "परी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("фея"),
            keywords: &["Оберон", "Титания", "гоблин", "фея"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fee"),
            keywords: &["Fee", "Oberon", "Puck", "Titania"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນາງຟ\u{ec9}າ"),
            keywords: &[
                "ທ\u{eb4}ທາເນຍ",
                "ນາງຟ\u{ec9}າ",
                "ພ\u{eb1}ກ",
                "ໂອເບ\u{eb5}ຣອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("fėja"),
            keywords: &["Oberon", "Puck", "Titania", "fėja"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("feja"),
            keywords: &["Oberons", "Paks", "Titānija", "feja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("patupaiarehe"),
            keywords: &["Oberon", "Puck", "Titania", "patupaiarehe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("самовила"),
            keywords: &["Оберон", "Пак", "Титанија", "самовила"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യക\u{d4d}ഷിഗന\u{d4d}ധർവ\u{d4d}വ\u{d3e}ദികൾ"),
            keywords: &[
                "ഒബ\u{d4d}റോൺ",
                "ടൈറ\u{d4d}റ\u{d3e}നിയ",
                "പ\u{d41}ക\u{d4d}ക\u{d4d}",
                "യക\u{d4d}ഷിഗന\u{d4d}ധർവ\u{d4d}വ\u{d3e}ദികൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дагина"),
            keywords: &["Оберон", "Питания", "Пук", "дагина"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("परी"),
            keywords: &["ओब\u{947}रॉन", "टायट\u{947}निया", "पक", "परी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pari-pari"),
            keywords: &["Oberon", "Puck", "Titania", "pari-pari"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fatatina"),
            keywords: &["Oberon", "Puck", "Titania", "fatatina"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နတ\u{103a}သမ\u{102e}း"),
            keywords: &[
                "တ\u{102d}\u{102f}က\u{103a}တန\u{103a}န\u{102e}းရား",
                "နတ\u{103a}သမ\u{102e}း",
                "ပက\u{103a}ခ\u{103a}",
                "အ\u{102d}\u{102f}ဘာရ\u{103d}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fe"),
            keywords: &["Oberon", "Puck", "Titania", "fe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("परी"),
            keywords: &["ओब\u{947}रन", "टिटानिया", "पक", "परी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("elfje"),
            keywords: &["Oberon", "Puck", "Titania", "elfje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fe"),
            keywords: &["Oberon", "Puck", "Titania", "fe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପରୀ"),
            keywords: &[
                "ତ\u{b3f}ତ\u{b3e}ନ\u{b3f}ଆ । ପ\u{b41}କ\u{b4d}\u{200d} । ଓବେରନ\u{b4d}\u{200d}",
                "ପରୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਰੀ"),
            keywords: &["ਓਬ\u{a47}ਰਨ", "ਟਿਟ\u{a48}ਨਿਆ", "ਪਰੀ", "ਪ\u{a71}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیری"),
            keywords: &["اوبیرون", "شرارتی ب\u{64f}ھتنا", "فیری", "ٹائیٹانیا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Spírit Wé Rizẹ\u{301}mbúl Taíní Húmánbin"),
            keywords: &[
                "Obẹ\u{301}rọn: Kíng Ọf Spírit-dẹm Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Pọk: Wọ\u{301}n Spírít Wé de Lív Fọ Íngland",
                "Spírit Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Títánia: Kwín Ọf Spírit-dem Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wróżka"),
            keywords: &["Oberon", "Puk", "Tytania", "wróżka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښاپيرۍ"),
            keywords: &["اوبيرون", "تيتانيه", "پک", "ښاپيرۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("fada"),
            keywords: &["fada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hada"),
            keywords: &["Oberon", "Puck", "Titania", "hada"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zână"),
            keywords: &["Oberon", "Puck", "Titania", "zână"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1131"),
            keywords: &["E10-1131"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("фея"),
            keywords: &["Динь-Динь", "Титания", "крылья", "сказка", "фея", "фэнтези"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuzimu"),
            keywords: &["Oberoni", "Paka", "Titaniya", "umuzimu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پري"),
            keywords: &["پري", "پرين جي راڻي، ڀوت، پرين جو راجا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}රඟන"),
            keywords: &[
                "ඔබෙරෝන\u{dca}",
                "ටය\u{dd2}ට\u{dcf}න\u{dd2}ය\u{dcf}",
                "පක\u{dca}",
                "ස\u{dd4}රඟන",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("rozprávková bytosť"),
            keywords: &["rozprávka", "rozprávková bytosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vilinsko bitje"),
            keywords: &["vilinsko bitje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qurux badan"),
            keywords: &["boqorka quruxda", "naag qurux badan", "qurux badan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zanë"),
            keywords: &["Oberoni", "Puku", "Titania", "zanë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вила"),
            keywords: &["Оберон", "Пак", "Титанија", "вила"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vila"),
            keywords: &["Oberon", "Pak", "Titanija", "vila"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fé"),
            keywords: &["Oberon", "Puck", "Titania", "fé", "älva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichimbakazi"),
            keywords: &[
                "jini",
                "kichimbakazi",
                "kichimbakazi malkia",
                "kichimbakazi mfalme",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "ஓபெர\u{bbe}ன\u{bcd}",
                "கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}",
                "டைட\u{bcd}ட\u{bbe}னிய\u{bbe}",
                "பக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3e}నపద ప\u{c3e}త\u{c4d}ర"),
            keywords: &[
                "ఓబ\u{c46}ర\u{c3e}న\u{c4d}",
                "జ\u{c3e}నపద ప\u{c3e}త\u{c4d}ర",
                "ట\u{c3f}ట\u{c3e}న\u{c3f}య\u{c3e}",
                "పక\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("парӣ"),
            keywords: &["Оберон", "Парии бад", "Титания", "парӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("นางฟ\u{e49}า"),
            keywords: &["นางฟ\u{e49}า", "แฟร\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("peri"),
            keywords: &["Oberon", "Puk", "Titaniýa", "peri"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("feeli"),
            keywords: &["feeli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("peri"),
            keywords: &["Oberon", "Puck", "Titania", "peri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەرۋاھ"),
            keywords: &["ئوبېرون", "ئەرۋاھ", "تىتانىيە", "مۇزتوپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("фея"),
            keywords: &["Оберон", "Пак", "Титанія", "фея"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پری"),
            keywords: &["اوبیران", "ٹائٹینیا", "پری", "پک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pari"),
            keywords: &["Titaniya", "ertak", "pari", "qanot", "sohira"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tiên"),
            keywords: &["Oberon", "Puck", "Titania", "tiên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fee"),
            keywords: &["Oberon", "Puk", "Titania", "fee"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umkholonjane"),
            keywords: &["I-Titania", "i-Oberon", "i-Puck", "umkholonjane"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iwin"),
            keywords: &["Iwin", "Oberon", "Puck", "Titania"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("仙子"),
            keywords: &["仙子", "奧布朗", "帕克", "提泰妮婭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("仙子"),
            keywords: &["仙子", "奥布朗", "帕克", "提泰妮娅"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("精灵"),
            keywords: &["天卫三", "天卫十五", "天卫四", "精灵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("仙女"),
            keywords: &["仙女"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("仙子"),
            keywords: &["仙子", "妖精"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("nganekwane"),
            keywords: &["i-Oberon", "i-Puck", "i-Titania", "nganekwane"],
        },
    ],
};
#[doc = "🧚🏻"]
pub const FAIRY_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏻",
    codepoint: "1F9DA 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fairy: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧚🏼"]
pub const FAIRY_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏼",
    codepoint: "1F9DA 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fairy: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧚🏽"]
pub const FAIRY_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏽",
    codepoint: "1F9DA 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fairy: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧚🏾"]
pub const FAIRY_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏾",
    codepoint: "1F9DA 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fairy: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧚🏿"]
pub const FAIRY_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏿",
    codepoint: "1F9DA 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "fairy: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧚\u{200d}♂\u{fe0f}"]
pub const MAN_FAIRY: crate::Emoji = crate::Emoji {
    glyph: "🧚\u{200d}♂\u{fe0f}",
    codepoint: "1F9DA 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man fairy",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚\u{200d}♂",
        codepoint: "1F9DA 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man fairy",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike fee"),
            keywords: &["Oberon", "Puck", "manlike fee"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጠንቋይ ወንድ"),
            keywords: &["ጠንቋይ ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جن\u{651}ي"),
            keywords: &["جن\u{651}ي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দেৱদ\u{9c2}ত"),
            keywords: &["অবেৰ’ন", "দেৱদ\u{9c2}ত", "প\u{9be}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi pəri"),
            keywords: &["Oberon", "Puck", "kişi pəri"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-фея"),
            keywords: &["Абэрон", "Пак", "мужчына-фея"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж фея"),
            keywords: &["Оберон", "Пук", "мъж фея"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলে পরী"),
            keywords: &["ওবোরন", "ছেলে পরী", "দ\u{9c1}ষ\u{9cd}ট\u{9c1} ছেলে"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vilenjak"),
            keywords: &["Oberon", "Puck", "vilenjak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home fada"),
            keywords: &["Oberó", "Puck", "home fada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏴᏫ ᎤᏍᏗ ᎦᏃᎯᎵᏙᎯ"),
            keywords: &["ᎠᏍᎦᏯ ᏴᏫ ᎤᏍᏗ ᎦᏃᎯᎵᏙᎯ", "ᎣᏆᏯᏂ", "ᏋᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("okřídlený skřítek"),
            keywords: &["oberon", "okřídlený skřítek", "puk", "vílák"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tylwythen teg"),
            keywords: &["Oberon", "Puck", "tylwythen teg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig fe"),
            keywords: &["magi", "mand", "mandlig fe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("männliche Fee"),
            keywords: &["Oberon", "Puck", "Zauberer", "männliche Fee"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("νεράιδος"),
            keywords: &["Oberon", "Puck", "νεράιδος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man fairy"),
            keywords: &["Oberon", "Puck", "man fairy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hada hombre"),
            keywords: &["hada", "hada hombre", "oberón", "puck"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeshaldjas"),
            keywords: &["Oberon", "Puck", "meeshaldjas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("(gizon) maitagarri"),
            keywords: &["(gizon) maitagarri", "Oberon", "Puck"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پری مرد"),
            keywords: &[
                "ابرون",
                "جن و پری",
                "لولو",
                "هاب\u{200c}گابلین",
                "پادشاه پریان",
                "پری مرد",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mieskeiju"),
            keywords: &["Oberon", "Puck", "hyönteismäinen", "mieskeiju", "siivet"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking diwata"),
            keywords: &["Oberon", "Puck", "lalaking diwata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur álvur"),
            keywords: &["mannligur álvur", "maður", "álvur", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("féetaud"),
            keywords: &["Obéron", "Puck", "féetaud"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["féetaud", "homme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sióg fhireann"),
            keywords: &["sióg fearann", "sióg fhireann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sìtheach"),
            keywords: &["oberon", "puck", "sìth", "sìtheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fada de sexo masculino"),
            keywords: &["fada", "fada de sexo masculino", "home"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ પરી"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ પરી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum aljani"),
            keywords: &["Oberon", "Puck", "mutum aljani"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיה בן"),
            keywords: &["אוברון", "פוק", "פיה בן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("द\u{947}वद\u{942}त"),
            keywords: &["ऑब\u{947}रॉन", "द\u{947}वद\u{942}त", "पक"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kućni duh"),
            keywords: &["Malik Tintilinić", "kućni duh"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi tündér"),
            keywords: &["Oberon", "Puck", "férfi tündér"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ-փերի"),
            keywords: &["Օբերոն", "տղամարդ-փերի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("peri pria"),
            keywords: &["Oberon", "Puck", "peri pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akụkọ nwoke"),
            keywords: &["Oberon", "Puck", "akụkọ nwoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("álfakarl"),
            keywords: &["álfakarl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("folletto alato"),
            keywords: &["Oberon", "Puck", "folletto alato"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男の妖精"),
            keywords: &["妖精", "男", "男の妖精", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dewa"),
            keywords: &["Oberon", "Puck", "dewa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი ფერია"),
            keywords: &["კაცი ფერია", "ობერონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер пері"),
            keywords: &["ер пері"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទេវប\u{17bb}ត\u{17d2}រ"),
            keywords: &[
                "ទេវប\u{17bb}ត\u{17d2}រ",
                "ផាក\u{17cb}",
                "អ\u{17bc}បេរ\u{17c9}\u{17bb}ន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಕಾಲ\u{ccd}ಪನ\u{cbf}ಕ"),
            keywords: &[
                "ಒಬ\u{cc6}ರನ\u{ccd}",
                "ಪಕ\u{ccd}",
                "ಪುರುಷ ಕಾಲ\u{ccd}ಪನ\u{cbf}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 요정"),
            keywords: &["남자 요정"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो परी"),
            keywords: &["ऑब\u{947}रॉन", "दादलो परी", "पक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек фея"),
            keywords: &["Оберон", "гоблин", "эркек фея"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("männlech Fee"),
            keywords: &["Oberon", "Puck", "männlech Fee"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເທວະດາ"),
            keywords: &["ພ\u{eb1}ກ", "ເທວະດາ", "ໂອເບ\u{eb5}ຣອນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("burtininkas"),
            keywords: &["Oberon", "Puck", "burtininkas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("laumiņš"),
            keywords: &["Oberons", "Paks", "laumiņš", "pasaku burvis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("patupaiarehe tāne"),
            keywords: &["Oberon", "Puck", "patupaiarehe tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("виленик"),
            keywords: &["Оберон", "Пак", "виленик"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഗന\u{d4d}ധർവ\u{d4d}വൻ"),
            keywords: &[
                "ഒബ\u{d4d}റോൺ",
                "ഗന\u{d4d}ധർവ\u{d4d}വൻ",
                "പ\u{d41}ക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй илбэчин"),
            keywords: &["Оберон", "Пук", "эрэгтэй илбэчин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष परी"),
            keywords: &["ओब\u{947}रॉन", "पक", "प\u{941}र\u{942}ष परी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pari-pari lelaki"),
            keywords: &["Oberon", "Puck", "pari-pari lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fatat maskil"),
            keywords: &["Oberon", "Puck", "fatat maskil"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နတ\u{103a}သားငယ\u{103a}"),
            keywords: &[
                "နတ\u{103a}သားငယ\u{103a}",
                "ပက\u{103a}ခ\u{103a}",
                "အ\u{102d}\u{102f}ဘာရ\u{103d}န\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig fe"),
            keywords: &["Oberon", "Puck", "fe", "mannlig fe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("द\u{947}वद\u{942}त"),
            keywords: &["ओब\u{947}रन", "द\u{947}वद\u{942}त", "पक"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijk elfje"),
            keywords: &["Oberon", "Puck", "mannelijk elfje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg fe"),
            keywords: &["Oberon", "Puck", "fe", "mannleg fe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ପରୀ"),
            keywords: &[
                "ପ\u{b41}କ\u{b4d}\u{200d} । ଓବେରନ\u{b4d}\u{200d}",
                "ପ\u{b41}ର\u{b41}ଷ ପରୀ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਦਮੀ ਪਰੀ"),
            keywords: &["ਆਦਮੀ ਪਰੀ", "ਓਬ\u{a47}ਰਨ", "ਪ\u{a71}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیری بندہ"),
            keywords: &["اوبیرون", "شرارتی ب\u{64f}ھتنا", "فیری بندہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bád Spírit Wé Rizẹ\u{301}mbúl Smọ\u{301}l Man"),
            keywords: &[
                "Bád Spírit Wé Rizẹ\u{301}mbúl Smọ\u{301}l Man",
                "Mán Spírit Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Obẹ\u{301}rọn: Kíng Ọf Spírit-dẹm Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Pọk: Wọ\u{301}n Spírít Wé de Lív Fọ Íngland",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna wróżka"),
            keywords: &["Oberon", "Puk", "mężczyzna wróżka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی خاپېری"),
            keywords: &["اوبيرون", "سړی خاپېری", "پک"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem fada"),
            keywords: &["fada", "homem fada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["homem fada", "homem-fada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata hada"),
            keywords: &["Oberon", "Puck", "tata hada"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat zână"),
            keywords: &["Oberon", "Puck", "bărbat zână"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1253"),
            keywords: &["E10-1253"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-фея"),
            keywords: &[
                "крылья",
                "мужчина",
                "мужчина-фея",
                "сказка",
                "фея",
                "фэнтези",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuzimugabo"),
            keywords: &["Oberoni", "Paka", "umuzimugabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد فرشتو"),
            keywords: &["مرد فرشتو", "ڀوت، پرين جو راجا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ස\u{dd4}රඟන"),
            keywords: &[
                "ඔබෙරෝන\u{dca}",
                "පක\u{dca}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ස\u{dd4}රඟන",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("škriatok"),
            keywords: &["rozprávka", "škriatok"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vilinec"),
            keywords: &["vilinec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin qurux badan"),
            keywords: &["nin qurux badan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë zanë"),
            keywords: &["Oberoni", "Puku", "burrë zanë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вилењак"),
            keywords: &["Оберон", "Пак", "вилењак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vilenjak"),
            keywords: &["Oberon", "Pak", "vilenjak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig älva"),
            keywords: &["Oberon", "Puck", "manlig älva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichimbakazi wa kiume"),
            keywords: &["jini", "kichimbakazi mfalme", "kichimbakazi wa kiume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd} கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}",
                "ஓபெர\u{bbe}ன\u{bcd}",
                "பக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3e}నపద స\u{c3e}హన మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు"),
            keywords: &[
                "ఓబ\u{c46}ర\u{c3e}న\u{c4d}",
                "జ\u{c3e}నపద స\u{c3e}హన మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు",
                "పక\u{c4d}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("парии мард"),
            keywords: &["Оберон", "Парии бад", "парии мард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เทพบ\u{e38}ตร"),
            keywords: &["เทพบ\u{e38}ตร", "แฟร\u{e35}\u{e48}ผ\u{e39}\u{e49}ชาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("peri erkek"),
            keywords: &["Oberon", "Puk", "peri erkek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("feeli tangata"),
            keywords: &["feeli tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek peri"),
            keywords: &["Oberon", "Puck", "erkek peri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر ئەرۋاھ"),
            keywords: &["ئوبېرون", "ئەر ئەرۋاھ", "مۇزتوپ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-фея"),
            keywords: &["Оберон", "Пак", "чоловік-фея"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد پری"),
            keywords: &["اوبیران", "مرد پری", "پک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak pari"),
            keywords: &["erkak", "erkak pari", "qanot", "sehrgar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ông tiên"),
            keywords: &["Oberon", "Puck", "ông tiên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fee bu góor"),
            keywords: &["Oberon", "Puk", "fee bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umkholonjane oyindoda"),
            keywords: &["I-Oberon", "I-Puck", "umkholonjane oyindoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iwin ọkùnrin"),
            keywords: &["Iwin ọkùnrin", "Oberon", "Puck"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男仙子"),
            keywords: &["奧布朗", "帕克", "男仙子"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男仙子"),
            keywords: &["奥布朗", "帕克", "男仙子"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("仙人"),
            keywords: &["仙人", "仙男", "天卫十五", "天卫四", "男精灵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男妖精"),
            keywords: &["男妖精"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男仙子"),
            keywords: &["男仙子", "男妖精"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ngelosi yesilisa"),
            keywords: &["i-Oberon", "i-Puck", "ngelosi yesilisa"],
        },
    ],
};
#[doc = "🧚🏻\u{200d}♂\u{fe0f}"]
pub const MAN_FAIRY_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9DA 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man fairy: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏻\u{200d}♂",
        codepoint: "1F9DA 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man fairy: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏼\u{200d}♂\u{fe0f}"]
pub const MAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9DA 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man fairy: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏼\u{200d}♂",
        codepoint: "1F9DA 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man fairy: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏽\u{200d}♂\u{fe0f}"]
pub const MAN_FAIRY_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9DA 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man fairy: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏽\u{200d}♂",
        codepoint: "1F9DA 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man fairy: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏾\u{200d}♂\u{fe0f}"]
pub const MAN_FAIRY_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9DA 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man fairy: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏾\u{200d}♂",
        codepoint: "1F9DA 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man fairy: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏿\u{200d}♂\u{fe0f}"]
pub const MAN_FAIRY_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9DA 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man fairy: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏿\u{200d}♂",
        codepoint: "1F9DA 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man fairy: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚\u{200d}♀\u{fe0f}"]
pub const WOMAN_FAIRY: crate::Emoji = crate::Emoji {
    glyph: "🧚\u{200d}♀\u{fe0f}",
    codepoint: "1F9DA 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman fairy",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚\u{200d}♀",
        codepoint: "1F9DA 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman fairy",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike feetjie"),
            keywords: &["Tatania", "vroulike feetjie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጠንቋይ ሴት"),
            keywords: &["ጠንቋይ ሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جن\u{651}ية"),
            keywords: &["جن\u{651}ية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("স\u{9c1}ন\u{9cd}দৰী পৰী"),
            keywords: &[
                "ট\u{9be}ইটেনিয\u{9bc}\u{9be}",
                "পৰী",
                "স\u{9c1}ন\u{9cd}দৰী পৰী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın pəri"),
            keywords: &["Titania", "qadın pəri"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына-фея"),
            keywords: &["Тытанія", "жанчына-фея"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена фея"),
            keywords: &["Титания", "жена фея"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} পরী"),
            keywords: &["ট\u{9be}ইটেনিয\u{9bc}\u{9be}", "মহিল\u{9be} পরী"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena vila"),
            keywords: &["Titania", "žena vila"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona fada"),
            keywords: &["Titània", "dona fada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏴᏫ ᎤᏍᏗ ᎦᏃᎯᎵᏙᎯ"),
            keywords: &["ᎠᎨᏯ ᏴᏫ ᎤᏍᏗ ᎦᏃᎯᎵᏙᎯ", "ᏘᏔᏂᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("okřídlená víla"),
            keywords: &["divoženka", "elfka", "okřídlená víla", "rusalka", "titánie"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tylwythen deg"),
            keywords: &["Titania", "tylwythen deg"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig fe"),
            keywords: &["kvinde", "kvindelig fe", "magi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fee"),
            keywords: &["Fee", "Titania"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα νεράιδα"),
            keywords: &["Titania", "γυναίκα νεράιδα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman fairy"),
            keywords: &["Titania", "woman fairy"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hada mujer"),
            keywords: &["campanilla", "hada", "hada mujer", "titania"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naishaldjas"),
            keywords: &["Titania", "naishaldjas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("(emakume) maitagarri"),
            keywords: &["(emakume) maitagarri", "Titania"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پری زن"),
            keywords: &["تیتانیا", "ملکه پریان", "پری زن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naiskeiju"),
            keywords: &[
                "Titania",
                "ilmatar",
                "keijukainen",
                "keijukuningatar",
                "luonnotar",
                "metsänneito",
                "naiskeiju",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng diwata"),
            keywords: &["Titania", "babaeng diwata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnulig álva"),
            keywords: &[
                "kona",
                "kvinna",
                "kvinnulig álva",
                "álva",
                "álvadrotning",
                "ævintýr",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fée"),
            keywords: &["Titania", "fée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["femme", "fée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("sióg bhaineann"),
            keywords: &["sióg bhaineann", "sióga baineann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bean-shìthe"),
            keywords: &["bean-shìthe", "sìth", "titania"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("fada de sexo feminino"),
            keywords: &[
                "Campaíña",
                "fada",
                "fada de sexo feminino",
                "fada madriña",
                "muller",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી પરી"),
            keywords: &["સ\u{acd}ત\u{acd}રી પરી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace aljana"),
            keywords: &["Titania", "mace aljana"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פיה בת"),
            keywords: &["טיטניה", "טינקרבל", "פיה בת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अप\u{94d}सरा"),
            keywords: &["अप\u{94d}सरा", "टाइट\u{948}निया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vila"),
            keywords: &["Kosjenka", "vila"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női tündér"),
            keywords: &["Titánia", "női tündér"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին-փերի"),
            keywords: &["Տիտանիա", "կին-փերի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("peri wanita"),
            keywords: &["Titania", "peri wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akụkọ nwanyị"),
            keywords: &["Titania", "akụkọ nwanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("álfadís"),
            keywords: &["álfadís"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("fata donna"),
            keywords: &["Titania", "fata donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女の妖精"),
            keywords: &["女", "女の妖精", "女性", "妖精"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("dewi"),
            keywords: &["Titania", "dewi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი ფერია"),
            keywords: &["ალი", "ტიტანია", "ქალი ფერია"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел пері"),
            keywords: &["әйел пері"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទេពធ\u{17b8}តា"),
            keywords: &["ទ\u{17b8}តានៀ", "ទេពធ\u{17b8}តា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ಕಾಲ\u{ccd}ಪನ\u{cbf}ಕ"),
            keywords: &[
                "ಟ\u{cbf}ಟಾನ\u{cbf}ಯ",
                "ಮಹ\u{cbf}ಳಾ ಯಕ\u{ccd}ಷ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6} ಕಾಲ\u{ccd}ಪನ\u{cbf}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 요정"),
            keywords: &["여자 요정"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल परी"),
            keywords: &["टिटानीया", "बायल परी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял фея"),
            keywords: &["Титания", "аял фея"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("weiblech Fee"),
            keywords: &["Titania", "weiblech Fee"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນາງຟ\u{ec9}າຍ\u{eb4}ງ"),
            keywords: &["ທ\u{eb4}ທາເນຍ", "ນາງຟ\u{ec9}າຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteris fėja"),
            keywords: &["Titania", "moteris fėja"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("laumiņa"),
            keywords: &["Titānija", "laumiņa"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("patupaiarehe wahine"),
            keywords: &["Titania", "patupaiarehe wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена самовила"),
            keywords: &["Титанија", "жена самовила"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യക\u{d4d}ഷി"),
            keywords: &["ടൈറ\u{d4d}റ\u{d3e}നിയ", "യക\u{d4d}ഷി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй илбэчин"),
            keywords: &["Титания", "эмэгтэй илбэчин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}त\u{94d}री परी"),
            keywords: &["टायटानिया", "स\u{94d}त\u{94d}री परी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pari-pari wanita"),
            keywords: &["Titania", "pari-pari wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("fatat femminil"),
            keywords: &["Titania", "fatat femminil"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နတ\u{103a}သမ\u{102e}းငယ\u{103a}"),
            keywords: &[
                "တ\u{102d}\u{102f}က\u{103a}တန\u{103a}န\u{102e}းရား",
                "နတ\u{103a}သမ\u{102e}းငယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig fe"),
            keywords: &["Titania", "fe", "kvinnelig fe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरीमान\u{94d}छ\u{947} परी"),
            keywords: &["छोरीमान\u{94d}छ\u{947} परी", "टिटानिया"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijk elfje"),
            keywords: &["Titania", "vrouwelijk elfje"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg fe"),
            keywords: &["Titania", "fe", "kvinneleg fe"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ପରୀ"),
            keywords: &["ତ\u{b3f}ତ\u{b3e}ନ\u{b3f}ଆ", "ମହ\u{b3f}ଳ\u{b3e} ପରୀ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਸਤਰੀ ਪਰੀ"),
            keywords: &["ਇਸਤਰੀ ਪਰੀ", "ਟਿਟ\u{a48}ਨਿਆ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فیری زنانی"),
            keywords: &["فیری زنانی", "ٹائیٹانیا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bád Spírit Wé Rizẹ\u{301}mbúl Smọ\u{301}l Wúmán"),
            keywords: &[
                "Bád Spírit Wé Rizẹ\u{301}mbúl Smọ\u{301}l Wúmán",
                "Títánia: Kwín Ọf Spírit-dem Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
                "Wúman Spírit Wé Rizẹ\u{301}mbúl Taíní Húmánbin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta wróżka"),
            keywords: &["Tytania", "kobieta wróżka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه ښاپيرۍ"),
            keywords: &["تيتانيه", "ښځه ښاپيرۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher fada"),
            keywords: &["fada", "mulher fada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["mulher fada", "mulher-fada"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi hada"),
            keywords: &["Titania", "warmi hada"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie zână"),
            keywords: &["Titania", "femeie zână"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1252"),
            keywords: &["E10-1252"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-фея"),
            keywords: &[
                "Динь-Динь",
                "Титания",
                "женщина-фея",
                "крылья",
                "сказка",
                "фея",
                "фэнтези",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuzimukazi"),
            keywords: &["Titaniya", "umuzimukazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت پري"),
            keywords: &["عورت پري", "پرين جي راڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}රංගන\u{dcf}ව"),
            keywords: &["ටය\u{dd2}ට\u{dcf}න\u{dd2}ය\u{dcf}", "ස\u{dd4}රංගන\u{dcf}ව"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("víla"),
            keywords: &["rozprávka", "víla"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vila"),
            keywords: &["vila"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag qurux badan"),
            keywords: &["naag qurux badan", "qurux badan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua zanë"),
            keywords: &["Titania", "grua zanë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена вила"),
            keywords: &["Титанија", "жена вила"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena vila"),
            keywords: &["Titanija", "žena vila"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig fé"),
            keywords: &["Titania", "kvinnlig fé", "kvinnlig älva"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kichimbakazi wa kike"),
            keywords: &["kichimbakazi malkia", "kichimbakazi wa kike"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}"),
            keywords: &[
                "டைட\u{bcd}ட\u{bbe}னிய\u{bbe}",
                "பெண\u{bcd} கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3e}నపద స\u{c3e}హన మంత\u{c4d}రగత\u{c4d}త\u{c46}"),
            keywords: &[
                "జ\u{c3e}నపద స\u{c3e}హన మంత\u{c4d}రగత\u{c4d}త\u{c46}",
                "ట\u{c3f}ట\u{c3e}న\u{c3f}య\u{c3e}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("парии зан"),
            keywords: &["Титания", "парии зан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เทพธ\u{e34}ดา"),
            keywords: &[
                "เทพธ\u{e34}ดา",
                "แฟร\u{e35}\u{e48}ผ\u{e39}\u{e49}หญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("perizat"),
            keywords: &["Titaniýa", "perizat"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("feeli fefine"),
            keywords: &["feeli fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın peri"),
            keywords: &["Titania", "kadın peri"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال ئەرۋاھ"),
            keywords: &["ئايال ئەرۋاھ", "تىتانىيە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-фея"),
            keywords: &["Титанія", "жінка-фея"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پری عورت"),
            keywords: &["ٹائٹینیا", "پری عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol pari"),
            keywords: &["Titaniya", "ayol pari"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bà tiên"),
            keywords: &["Titania", "bà tiên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("fee bu jigéen"),
            keywords: &["Titania", "fee bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umkholonjane olibhinqa"),
            keywords: &["I-Titania", "umkholonjane olibhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Iwin obìnrin"),
            keywords: &["Iwin obìnrin", "Tìtàníà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女仙子"),
            keywords: &["女仙子", "提泰妮婭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女仙子"),
            keywords: &["女仙子", "提泰妮娅"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("仙女"),
            keywords: &["仙女", "女精灵", "妖精王后"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女妖精"),
            keywords: &["女妖精"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女仙子"),
            keywords: &["女仙子", "女妖精"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ngelosi yesifazane"),
            keywords: &["i-Titania", "ngelosi yesifazane"],
        },
    ],
};
#[doc = "🧚🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_FAIRY_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9DA 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman fairy: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏻\u{200d}♀",
        codepoint: "1F9DA 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman fairy: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_FAIRY_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9DA 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman fairy: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏼\u{200d}♀",
        codepoint: "1F9DA 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman fairy: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_FAIRY_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9DA 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman fairy: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏽\u{200d}♀",
        codepoint: "1F9DA 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman fairy: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_FAIRY_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9DA 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman fairy: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏾\u{200d}♀",
        codepoint: "1F9DA 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman fairy: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧚🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_FAIRY_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧚🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9DA 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman fairy: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧚🏿\u{200d}♀",
        codepoint: "1F9DA 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman fairy: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛"]
pub const VAMPIRE: crate::Emoji = crate::Emoji {
    glyph: "🧛",
    codepoint: "1F9DB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "vampire",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vampier"),
            keywords: &["Dracula", "vampier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥርስ ያለው ጭራቅ"),
            keywords: &["ጥርስ ያለው ጭራቅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مص\u{651}اص دماء"),
            keywords: &["مص\u{651}اص دماء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভেম\u{9cd}প\u{9be}য\u{9bc}\u{9be}ৰ"),
            keywords: &[
                "অম\u{9c3}ত\u{9cd}য\u{9c1}",
                "ড\u{9cd}ৰ\u{9be}ক\u{9c1}ল\u{9be}",
                "ভেম\u{9cd}প\u{9be}য\u{9bc}\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vampir"),
            keywords: &["Drakula", "vampir", "xortdan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вампір"),
            keywords: &["Дракула", "бессмяротны", "вампір"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вампирка"),
            keywords: &["Дракула", "вампирка", "немъртва"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9cd}য\u{9be}ম\u{9cd}প\u{9be}য\u{9bc}\u{9be}র"),
            keywords: &[
                "আধমর\u{9be}",
                "ড\u{9cd}র\u{9be}ক\u{9c1}ল\u{9be}",
                "ভ\u{9cd}য\u{9be}ম\u{9cd}প\u{9be}য\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("suner/ez-gwad"),
            keywords: &["Dracula", "suner-gwad", "suner/ez-gwad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vampir"),
            keywords: &["Drakula", "vampir", "živi mrtvac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("vampir"),
            keywords: &["Dràcula", "mort vivent", "morta vivent", "vampir"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎩᎦ ᎠᏓᏁᎩᎡᎯ"),
            keywords: &["ᎤᏲᎱᏒ ᏂᎨᏒᎾ", "ᎩᎦ ᎠᏓᏁᎩᎡᎯ", "ᎩᎦ ᎠᏗᏔᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej upíra"),
            keywords: &["drákula", "nemrtvý", "obličej upíra", "vampýr"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fampir"),
            keywords: &["Draciwla", "fampir", "meirw byw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vampyr"),
            keywords: &["Dracula", "vampyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Vampir"),
            keywords: &["Dracula", "Untoter", "Vampir"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βρυκόλακας"),
            keywords: &["Δράκουλας", "απέθαντη", "βρυκόλακας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("vampire"),
            keywords: &["Dracula", "undead", "vampire"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vampiro"),
            keywords: &["drácula", "muerto viviente", "no muerto", "vampiro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["drácula", "muerto viviente", "vampiro"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vampiir"),
            keywords: &["Dracula", "surematu", "vampiir"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("banpiro"),
            keywords: &["Drakula", "banpiro", "hildako bizidun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خون\u{200c}آشام"),
            keywords: &["خون\u{200c}آشام", "دراکولا", "مرده متحرک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vampyyri"),
            keywords: &[
                "Dracula",
                "elävä kuollut",
                "hampaat",
                "torahammas",
                "vampyyri",
                "verenhimo",
                "verenimijä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bampira"),
            keywords: &["Drakula", "bampira", "buhay na patay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vampýrur"),
            keywords: &["blóðsúgvari", "drakula", "vampýrur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vampire"),
            keywords: &["Dracula", "mort-vivant", "vampire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Dracula", "mort-vivant", "vampire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("vaimpír"),
            keywords: &["Dracula", "neamh-mharbh", "vaimpír"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bhampair"),
            keywords: &["bhampair", "closach", "dracula"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("criatura vampírica"),
            keywords: &["criatura vampírica", "vampiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પિચાશ"),
            keywords: &["પિચાશ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mai shan jini"),
            keywords: &["Dracula", "mai shan jini", "mara mutuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ערפד"),
            keywords: &["דרקולה", "חי מת", "ערפד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{948}म\u{94d}पायर"),
            keywords: &[
                "ड\u{94d}र\u{948}क\u{94d}य\u{941}ला",
                "मर कर भी जीवित",
                "व\u{948}म\u{94d}पायर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("neživa osoba"),
            keywords: &["Drakula", "neživa osoba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("vámpír"),
            keywords: &["Drakula", "vámpír", "élőhalott"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վամպիր"),
            keywords: &["Դրակուլա", "ատամներ", "արյուն", "վամպիր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("vampir"),
            keywords: &["Drakula", "mayat hidup", "vampir"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọmị ọbara"),
            keywords: &["Dracula", "akụkọ mmụọ", "ọmị ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vampíra"),
            keywords: &["Drakúla", "hinir ódauðlegu", "vampíra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vampiro"),
            keywords: &["Dracula", "morto vivente", "vampiro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("吸血鬼"),
            keywords: &["ドラキュラ", "バンパイア", "吸血鬼"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("vampir"),
            keywords: &["Drakula", "lelembut", "vampir"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვამპირი"),
            keywords: &["დრაკულა", "ვამპირი", "ცოცხალ-მკვდარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("вампир"),
            keywords: &["вампир"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17b7}សាចជញ\u{17d2}ជក\u{17cb}ឈាម"),
            keywords: &[
                "ត\u{17d2}រាខ\u{17d2}យ\u{17bc}ឡា",
                "ប\u{17b7}សាចជញ\u{17d2}ជក\u{17cb}ឈាម",
                "ប\u{17b7}សាចម\u{17b7}នចេះស\u{17d2}លាប\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ರಕ\u{ccd}ತಪ\u{cbf}ಶಾಚ\u{cbf}"),
            keywords: &[
                "ಡ\u{ccd}ರಾಕುಲಾ",
                "ರಕ\u{ccd}ತಪ\u{cbf}ಶಾಚ\u{cbf}",
                "ವ\u{ccd}ಯಾಂಪೈರ\u{ccd}",
                "ಶವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뱀파이어"),
            keywords: &["드라큘라", "뱀파이어", "언데드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पिशाच\u{94d}च"),
            keywords: &["ड\u{94d}र\u{945}क\u{941}ला", "न मरपी", "पिशाच\u{94d}च"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кан соргуч"),
            keywords: &["Дракула", "кан соргуч", "өлбөс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vampir"),
            keywords: &["Dracula", "Vampir", "ondout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວມພາຍ"),
            keywords: &["ຜ\u{eb5}ດ\u{eb4}ບ", "ແດຣກຄ\u{eb4}ວລາ", "ແວມພາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vampyras"),
            keywords: &["Drakula", "nemirtingas", "vampyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vampīrs"),
            keywords: &["Drakula", "nemirstīgais", "vampīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaitoto"),
            keywords: &["Dracula", "kaitoto", "oramate"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вампир"),
            keywords: &["Дракула", "вампир", "жив мртовец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("രക\u{d4d}തരക\u{d4d}ഷസ\u{d4d}സ\u{d4d}"),
            keywords: &[
                "അൺഡെഡ\u{d4d}",
                "ഡ\u{d4d}ര\u{d3e}ക\u{d4d}ക\u{d41}ള",
                "രക\u{d4d}തരക\u{d4d}ഷസ\u{d4d}സ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цус сорогч"),
            keywords: &["Дракула", "цус сорогч", "үхээгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{94d}ह\u{901}पायर"),
            keywords: &[
                "जिव\u{902}त नसल\u{947}ला",
                "ड\u{94d}र\u{945}क\u{94d}य\u{941}ला",
                "व\u{94d}ह\u{901}पायर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("puntianak"),
            keywords: &["Dracula", "mayat hidup", "puntianak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("vampira"),
            keywords: &["Dracula", "qam mil-mewt", "vampira"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{103d}ေးစ\u{102f}ပ\u{103a}ဖ\u{102f}တ\u{103a}ကောင\u{103a}"),
            keywords: &[
                "ဒရက\u{103a}က\u{1030}လာ",
                "မသေန\u{102d}\u{102f}င\u{103a}သော",
                "သ\u{103d}ေးစ\u{102f}ပ\u{103a}ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vampyr"),
            keywords: &["Dracula", "vampyr", "vandød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पिशाच"),
            keywords: &["पिशाच", "भ\u{942}त", "म\u{943}त आत\u{94d}मा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vampier"),
            keywords: &["Dracula", "ondode", "vampier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vampyr"),
            keywords: &["Dracula", "vampyr", "vandød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3f}ଶ\u{b3e}ଚ"),
            keywords: &[
                "ଡ\u{b4d}ର\u{b3e}କ\u{b41}ଲ\u{b3e} । ପ\u{b4d}ରେତ\u{b3e}ତ\u{b4d}ମ\u{b3e}",
                "ପ\u{b3f}ଶ\u{b3e}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪਿਸ\u{a3c}ਾਚ"),
            keywords: &["ਜੀਉ\u{a02}ਦਾ", "ਡਰ\u{a48}ਕ\u{a41}ਲਾ", "ਪਿਸ\u{a3c}ਾਚ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خونخوار بلا"),
            keywords: &["آسیب", "خونخوار بلا", "ڈریکولا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vámpáya"),
            keywords: &["Drakúla", "Vámpáya", "Zombí"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wampir"),
            keywords: &["Drakula", "nieumarli", "wampir"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("بلا"),
            keywords: &["بلا", "نامړ", "ډریکولا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("vampiro"),
            keywords: &["Drácula", "vampiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["Drácula", "morto-vivo", "vampiro"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("vampiro"),
            keywords: &["Dracula", "mana wañusqa", "vampiro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("vampir"),
            keywords: &["Dracula", "strigoi", "vampir"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1132"),
            keywords: &["E10-1132"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вампир"),
            keywords: &["Дракула", "вампир", "граф", "зубы", "кровь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ivampire"),
            keywords: &["Darakula", "ingabo", "ivampire"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڏائڻ"),
            keywords: &["ڀوت، جن", "ڏائڻ", "ڏاهڻ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැම\u{dca}පයර\u{dca}"),
            keywords: &[
                "ඩ\u{dca}\u{200d}රක\u{dd2}ය\u{dd6}ල\u{dcf}",
                "නොමැර\u{dd4}ණ\u{dd4}",
                "වැම\u{dca}පයර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("upírska bytosť"),
            keywords: &["drakula", "upíri", "upírska bytosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vampirji"),
            keywords: &["Drakula", "nesmrtnost", "vampir", "vampirji"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("reer-aakhiraad dhiig cab ah"),
            keywords: &[
                "aan dhiman",
                "cirfiid",
                "nin reer-aakhiraad dhiig cab ah",
                "reer-aakhiraad dhiig cab ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vampir"),
            keywords: &["Drakula", "i pavdekur", "vampir"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вампир"),
            keywords: &["Дракула", "вампир", "повампирен"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vampir"),
            keywords: &["Drakula", "povampiren", "vampir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vampyr"),
            keywords: &["Drakula", "vampyr", "vandöd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mnyonya damu"),
            keywords: &["Dracula", "mnyonya damu", "zimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இரத\u{bcd}தக\u{bcd} க\u{bbe}ட\u{bcd}டேரி"),
            keywords: &[
                "இரத\u{bcd}தக\u{bcd} க\u{bbe}ட\u{bcd}டேரி",
                "டிர\u{bbe}குல\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("రక\u{c4d}తప\u{c3f}ప\u{c3e}స\u{c3f}"),
            keywords: &[
                "డ\u{c4d}ర\u{c3e}క\u{c4d}యుల\u{c3e}",
                "మరణం ల\u{c47}న\u{c3f}ద\u{c3f}",
                "రక\u{c4d}తప\u{c3f}ప\u{c3e}స\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("вампир"),
            keywords: &["Дракула", "вампир", "вампирҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แวมไพร\u{e4c}"),
            keywords: &["อมตะ", "แดร\u{e47}กค\u{e39}ล\u{e48}า", "แวมไพร\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wampir"),
            keywords: &["Drakula", "wampir", "ölümsiz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha misi toto"),
            keywords: &["tokotaha misi toto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("vampir"),
            keywords: &["Drakula", "hortlak", "vampir"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قانخور مۇردا"),
            keywords: &["دراكۇلا", "قانخور مۇردا", "مۇردا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вампір"),
            keywords: &["Дракула", "вампір", "нежить"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خون خوار"),
            keywords: &["خون خوار", "زندہ", "ڈریکلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vampir"),
            keywords: &["Drakula", "qon", "tish", "vampir"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ma cà rồng"),
            keywords: &["Dracula", "ma cà rồng", "xác sống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wàmpiir"),
            keywords: &["Dracula", "bu deewul", "wàmpiir"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-vampire"),
            keywords: &["I-Dracula", "i-vampire", "ongafanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Fánpáyà"),
            keywords: &["Dàràkúlà", "Fánpáyà", "àìkú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("吸血鬼"),
            keywords: &["亡靈", "吸血鬼", "德古拉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("吸血鬼"),
            keywords: &["亡灵", "吸血鬼", "德古拉"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("吸血鬼"),
            keywords: &["不死族", "吸血鬼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("吸血鬼"),
            keywords: &["吸血鬼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["Vote 不死族", "吸血鬼", "德古拉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ivemphaya"),
            keywords: &["ivemphaya", "ongafile", "u-Dracula"],
        },
    ],
};
#[doc = "🧛🏻"]
pub const VAMPIRE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏻",
    codepoint: "1F9DB 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "vampire: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧛🏼"]
pub const VAMPIRE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏼",
    codepoint: "1F9DB 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "vampire: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧛🏽"]
pub const VAMPIRE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏽",
    codepoint: "1F9DB 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "vampire: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧛🏾"]
pub const VAMPIRE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏾",
    codepoint: "1F9DB 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "vampire: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧛🏿"]
pub const VAMPIRE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏿",
    codepoint: "1F9DB 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "vampire: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧛\u{200d}♂\u{fe0f}"]
pub const MAN_VAMPIRE: crate::Emoji = crate::Emoji {
    glyph: "🧛\u{200d}♂\u{fe0f}",
    codepoint: "1F9DB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man vampire",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛\u{200d}♂",
        codepoint: "1F9DB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man vampire",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike vampier"),
            keywords: &["Dracula", "manlike vampier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥርስ ያለው ወንድ ጭራቅ"),
            keywords: &["ጥርስ ያለው ወንድ ጭራቅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصاص دماء"),
            keywords: &["مصاص دماء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ ভেম\u{9cd}প\u{9be}য\u{9bc}\u{9be}ৰ"),
            keywords: &[
                "অম\u{9c3}ত\u{9cd}য\u{9c1}",
                "ড\u{9cd}ৰ\u{9be}ক\u{9c1}ল\u{9be}",
                "প\u{9c1}ৰ\u{9c1}ষ ভেম\u{9cd}প\u{9be}য\u{9bc}\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi vampir"),
            keywords: &["Drakula", "kişi vampir", "xortdan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-вампір"),
            keywords: &["Дракула", "бессмяротны", "мужчына-вампір"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж вампир"),
            keywords: &["Дракула", "мъж вампир", "немъртъв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ ভ\u{9cd}য\u{9be}ম\u{9cd}প\u{9be}য\u{9bc}\u{9be}র"),
            keywords: &[
                "আধমর\u{9be}",
                "ড\u{9cd}র\u{9be}ক\u{9c1}ল\u{9be}",
                "প\u{9c1}র\u{9c1}ষ ভ\u{9cd}য\u{9be}ম\u{9cd}প\u{9be}য\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("suner-gwad"),
            keywords: &["Dracula", "suner-gwad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac vampir"),
            keywords: &["Drakula", "muškarac vampir", "živi mrtvac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home vampir"),
            keywords: &["Dràcula", "home vampir", "mort vivent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎩᎦ ᎠᏓᏁᎩᏛᎯ"),
            keywords: &["ᎠᏍᎦᏯ ᎩᎦ ᎠᏓᏁᎩᏛᎯ", "ᎤᏲᎱᏒ ᏂᎨᏒᎾ", "ᎩᎦ ᎠᏗᏔᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("upír"),
            keywords: &["drákula", "nemrtvý", "upír", "vampýr"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fampir gwrywaidd"),
            keywords: &["Draciwla", "fampir gwrywaidd", "meirw byw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig vampyr"),
            keywords: &["Dracula", "mandlig vampyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("männlicher Vampir"),
            keywords: &["Dracula", "Untoter", "männlicher Vampir"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας βρυκόλακας"),
            keywords: &["Δράκουλας", "άντρας βρυκόλακας", "απέθαντος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man vampire"),
            keywords: &["Dracula", "man vampire", "undead"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vampiro hombre"),
            keywords: &["drácula", "muerto viviente", "no muerto", "vampiro hombre"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["drácula", "muerto viviente", "vampiro", "vampiro hombre"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesvampiir"),
            keywords: &["Dracula", "meesvampiir", "surematu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon banpiro"),
            keywords: &["Drakula", "gizon banpiro", "hildako bizidun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خون\u{200c}آشام مرد"),
            keywords: &["خون\u{200c}آشام مرد", "دراکولا", "مرده متحرک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("miesvampyyri"),
            keywords: &[
                "Dracula",
                "elävä kuollut",
                "hampaat",
                "miesvampyyri",
                "torahammas",
                "verenhimo",
                "verenimijä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking bampira"),
            keywords: &["Drakula", "buhay na patay", "lalaking bampira"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur vampýrur"),
            keywords: &["blóðsúgvari", "drakula", "mannligur vampýrur", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vampire homme"),
            keywords: &["Dracula", "mort-vivant", "vampire homme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["Dracula", "homme", "mort-vivant", "vampire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("vaimpír fhireann"),
            keywords: &[
                "Dracula",
                "fear",
                "neamh-mharbh",
                "vaimpír",
                "vaimpír fhireann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bhampair fireann"),
            keywords: &["bhampair fireann", "closach", "dracula"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vampiro"),
            keywords: &["Drácula", "home", "vampiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ પિચાશ"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ પિચાશ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai shan jini"),
            keywords: &["Dracula", "mara mutuwa", "mutum mai shan jini"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ערפד בן"),
            keywords: &["דרקולה", "ערפד בן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष व\u{948}म\u{94d}पायर"),
            keywords: &[
                "ड\u{94d}र\u{948}क\u{94d}य\u{941}ला",
                "प\u{941}र\u{941}ष व\u{948}म\u{94d}पायर",
                "मर कर भी जीवित",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vampir"),
            keywords: &["Drakula", "vampir"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi vámpír"),
            keywords: &["Drakula", "férfi vámpír", "élőhalott", "élőholt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ-վամպիր"),
            keywords: &["Դրակուլա", "ատամներ", "արյուն", "տղամարդ-վամպիր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("vampir pria"),
            keywords: &["Drakula", "mayat hidup", "vampir pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke ọmị ọbara"),
            keywords: &["Dracula", "akụkọ mmụọ", "nwoke ọmị ọbara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns vampíra"),
            keywords: &["Drakúla", "hinir ódauðlegu", "karlkyns vampíra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vampiro uomo"),
            keywords: &["Dracula", "morto vivente", "vampiro uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男の吸血鬼"),
            keywords: &[
                "ドラキュラ",
                "バンパイア",
                "吸血鬼",
                "男",
                "男の吸血鬼",
                "男性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("vampir lanang"),
            keywords: &["Drakula", "lelembut", "vampir lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვამპირი კაცი"),
            keywords: &["დრაკულა", "ვამპირი კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер вампир"),
            keywords: &["ер вампир"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17b7}សាចប\u{17d2}រ\u{17bb}សជញ\u{17d2}ជក\u{17cb}ឈាម"),
            keywords: &[
                "ត\u{17d2}រាខ\u{17d2}យ\u{17bc}ឡា",
                "ប\u{17b7}សាចប\u{17d2}រ\u{17bb}សជញ\u{17d2}ជក\u{17cb}ឈាម",
                "ប\u{17b7}សាចម\u{17b7}នចេះស\u{17d2}លាប\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ರಕ\u{ccd}ತಪ\u{cbf}ಶಾಚ\u{cbf}"),
            keywords: &[
                "ಡ\u{ccd}ರಾಕುಲಾ",
                "ಪುರುಷ ರಕ\u{ccd}ತಪ\u{cbf}ಶಾಚ\u{cbf}",
                "ಪುರುಷ ವ\u{ccd}ಯಾಂಪೇರ\u{ccd}",
                "ಶವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 뱀파이어"),
            keywords: &["남자 뱀파이어", "드라큘라", "언데드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो पिशाच\u{94d}च"),
            keywords: &[
                "ड\u{94d}र\u{945}क\u{941}ला",
                "दादलो पिशाच\u{94d}च",
                "न मरपी",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек кан соргуч"),
            keywords: &["Дракула", "эркек кан соргуч", "өлбөс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vampirmann"),
            keywords: &["Dracula", "Vampirmann", "ondout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວມພາຍຊາຍ"),
            keywords: &["ຜ\u{eb5}ດ\u{eb4}ບ", "ແດຣກຄ\u{eb4}ວລາ", "ແວມພາຍຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vampyras vyras"),
            keywords: &["Drakula", "nemirtingas", "vampyras vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīriešu kārtas vampīrs"),
            keywords: &["Drakula", "nemirstīgais", "vīriešu kārtas vampīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne kaitoto"),
            keywords: &["Dracula", "oramate", "tāne kaitoto"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж вампир"),
            keywords: &["Дракула", "жив мртовец", "маж вампир"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആൺ രക\u{d4d}തരക\u{d4d}ഷസ\u{d4d}സ\u{d4d}"),
            keywords: &[
                "അൺഡെഡ\u{d4d}",
                "ആൺ രക\u{d4d}തരക\u{d4d}ഷസ\u{d4d}സ\u{d4d}",
                "ഡ\u{d4d}ര\u{d3e}ക\u{d4d}ക\u{d41}ള",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй цус сорогч"),
            keywords: &["Дракула", "эрэгтэй цус сорогч", "үхээгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष व\u{94d}ह\u{901}पायर"),
            keywords: &[
                "जिव\u{902}त नसल\u{947}ला",
                "ड\u{94d}र\u{945}क\u{94d}य\u{941}ला",
                "प\u{941}र\u{942}ष व\u{94d}ह\u{901}पायर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("puntianak lelaki"),
            keywords: &["Dracula", "mayat hidup", "puntianak lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel vampira"),
            keywords: &["Dracula", "qam mil-mewt", "raġel vampira"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသား သ\u{103d}ေးစ\u{102f}ပ\u{103a}ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ),
            keywords: &[
                "ဒရက\u{103a}က\u{1030}လာ",
                "မသေန\u{102d}\u{102f}င\u{103a}သော",
                "အမျ\u{102d}\u{102f}းသား သ\u{103d}ေးစ\u{102f}ပ\u{103a}ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig vampyr"),
            keywords: &["Dracula", "mannlig vampyr", "vandød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}र\u{94d}कट\u{94d}टा"),
            keywords: &[
                "भ\u{942}त",
                "म\u{941}र\u{94d}कट\u{94d}टा",
                "म\u{943}त आत\u{94d}मा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke vampier"),
            keywords: &["Dracula", "mannelijke vampier", "ondode"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg vampyr"),
            keywords: &["Dracula", "mannleg vampyr", "vandød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ପ\u{b3f}ଶ\u{b3e}ଚ"),
            keywords: &[
                "ଡ\u{b4d}ର\u{b3e}କ\u{b41}ଲ\u{b3e} । ପ\u{b4d}ରେତ\u{b3e}ତ\u{b4d}ମ\u{b3e}",
                "ପ\u{b41}ର\u{b41}ଷ ପ\u{b3f}ଶ\u{b3e}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਦਮੀ ਪਿਸ\u{a3c}ਾਚ"),
            keywords: &["ਆਦਮੀ ਪਿਸ\u{a3c}ਾਚ", "ਜੀਉ\u{a02}ਦਾ", "ਡਰ\u{a48}ਕ\u{a41}ਲਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خونخوار مرد"),
            keywords: &["آسیب", "خونخوار مرد", "ڈریکولا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Vámpáya"),
            keywords: &[
                "Drakúla",
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Dú Laik Sé I Dé Alaif",
                "Mán Vámpáya",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna wampir"),
            keywords: &["Drakula", "mężczyzna wampir", "nieumarły"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی بلا"),
            keywords: &["سړی بلا", "نا مړ", "ډریکولا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem vampiro"),
            keywords: &["Drácula", "homem vampiro", "vampiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["Drácula", "homem vampiro", "homem-vampiro", "morto-vivo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata vampiro"),
            keywords: &["Dracula", "mana wañusqa", "tata vampiro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat vampir"),
            keywords: &["Dracula", "bărbat vampir", "strigoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1255"),
            keywords: &["E10-1255"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-вампир"),
            keywords: &[
                "Дракула",
                "вампир",
                "граф",
                "зубы",
                "кровь",
                "мужчина",
                "мужчина-вампир",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ivampayagabo"),
            keywords: &["Darakula", "ingabo", "ivampayagabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد ڀوت"),
            keywords: &["مرد ڀوت", "ڀوت، جن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} වැම\u{dca}පයර\u{dca}"),
            keywords: &[
                "ඩ\u{dca}\u{200d}රක\u{dd2}ය\u{dd6}ල\u{dcf}",
                "නොමැර\u{dd4}ණ\u{dd4}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} වැම\u{dca}පයර\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("upír"),
            keywords: &["drakula", "muž", "upír"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vampir"),
            keywords: &["Drakula", "moški vampir", "nesmrtnost", "vampir"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin reer-aakhiraad dhiig cab ah"),
            keywords: &["aan dhiman", "cirfiid", "nin reer-aakhiraad dhiig cab ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë vampir"),
            keywords: &["Drakula", "burrë vampir", "i pavdekur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушки вампир"),
            keywords: &["Дракула", "мушки вампир", "повампирен"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muški vampir"),
            keywords: &["Drakula", "muški vampir", "povampiren"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig vampyr"),
            keywords: &["Drakula", "manlig vampyr", "vandöd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mnyonya damu wa kiume"),
            keywords: &["Dracula", "mnyonya damu wa kiume", "zimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} இரத\u{bcd}தக\u{bcd} க\u{bbe}ட\u{bcd}டேரி"),
            keywords: &[
                "ஆண\u{bcd} இரத\u{bcd}தக\u{bcd} க\u{bbe}ட\u{bcd}டேரி",
                "ச\u{bbe}க\u{bbe}வரம\u{bcd} பெற\u{bcd}றது",
                "டிர\u{bbe}குல\u{bbe}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మగ రక\u{c4d}తప\u{c3f}ప\u{c3e}స\u{c3f}"),
            keywords: &[
                "డ\u{c4d}ర\u{c3e}క\u{c4d}యుల\u{c3e}",
                "మగ రక\u{c4d}తప\u{c3f}ప\u{c3e}స\u{c3f}",
                "మరణం ల\u{c47}న\u{c3f}ద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мардии вампир"),
            keywords: &["Дракула", "вампирҳо", "мардии вампир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แวมไพร\u{e4c}ผ\u{e39}\u{e49}ชาย"),
            keywords: &[
                "อมตะ",
                "แดร\u{e47}กค\u{e39}ล\u{e48}า",
                "แวมไพร\u{e4c}ผ\u{e39}\u{e49}ชาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wampir erkek"),
            keywords: &["Drakula", "wampir erkek", "ölümsiz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata misi toto"),
            keywords: &["tangata misi toto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek vampir"),
            keywords: &["Drakula", "erkek vampir", "hortlak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر مۇردا"),
            keywords: &["ئەر مۇردا", "دراكۇلا", "مۇردا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-вампір"),
            keywords: &["Дракула", "вампір", "упир", "чоловік-вампір"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خون خوار آدمی"),
            keywords: &["خون خوار آدمی", "زندہ", "ڈریکلا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak vampir"),
            keywords: &["Drakula", "erkak", "erkak vampir", "qon", "tish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ma cà rồng nam"),
            keywords: &["Dracula", "ma cà rồng nam", "xác sống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wàmpiir bu góor"),
            keywords: &["Dracula", "bu deewul", "wàmpiir bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-vampire eyindoda"),
            keywords: &["I-Dracula", "i-vampire eyindoda", "ongafanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Fánpáyà ọkùnrin"),
            keywords: &["Dàràkúlà", "Fánpáyà ọkùnrin", "àìkú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男吸血鬼"),
            keywords: &["亡靈", "德古拉", "男吸血鬼"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男吸血鬼"),
            keywords: &["亡灵", "德古拉", "男吸血鬼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男吸血鬼"),
            keywords: &["男不死族", "男吸血鬼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男吸血鬼"),
            keywords: &["男吸血鬼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["不死族", "德古拉｜男吸血鬼", "男吸血鬼"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ivemphaya lendoda"),
            keywords: &["ivemphaya lendoda", "udracula ongafile"],
        },
    ],
};
#[doc = "🧛🏻\u{200d}♂\u{fe0f}"]
pub const MAN_VAMPIRE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9DB 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man vampire: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏻\u{200d}♂",
        codepoint: "1F9DB 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man vampire: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏼\u{200d}♂\u{fe0f}"]
pub const MAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9DB 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man vampire: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏼\u{200d}♂",
        codepoint: "1F9DB 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man vampire: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏽\u{200d}♂\u{fe0f}"]
pub const MAN_VAMPIRE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9DB 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man vampire: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏽\u{200d}♂",
        codepoint: "1F9DB 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man vampire: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏾\u{200d}♂\u{fe0f}"]
pub const MAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9DB 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man vampire: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏾\u{200d}♂",
        codepoint: "1F9DB 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man vampire: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏿\u{200d}♂\u{fe0f}"]
pub const MAN_VAMPIRE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9DB 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man vampire: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏿\u{200d}♂",
        codepoint: "1F9DB 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man vampire: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛\u{200d}♀\u{fe0f}"]
pub const WOMAN_VAMPIRE: crate::Emoji = crate::Emoji {
    glyph: "🧛\u{200d}♀\u{fe0f}",
    codepoint: "1F9DB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman vampire",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛\u{200d}♀",
        codepoint: "1F9DB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman vampire",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike vampier"),
            keywords: &["lewende dooies", "vroulike vampier"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥርስ ያላት ሴት ጭራቅ"),
            keywords: &["ጥርስ ያላት ሴት ጭራቅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مص\u{651}اصة دماء"),
            keywords: &["مص\u{651}اصة دماء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} ভেম\u{9cd}প\u{9be}য\u{9bc}\u{9be}ৰ"),
            keywords: &[
                "অম\u{9c3}ত\u{9cd}য\u{9c1}",
                "মহিল\u{9be} ভেম\u{9cd}প\u{9be}য\u{9bc}\u{9be}ৰ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın vampir"),
            keywords: &["qadın vampir", "xortdan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вампірка"),
            keywords: &["бессмяротны", "вампірка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена вампир"),
            keywords: &["жена вампир", "немъртъв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} ভ\u{9cd}য\u{9be}ম\u{9cd}প\u{9be}য\u{9bc}\u{9be}র"),
            keywords: &[
                "আধমর\u{9be}",
                "মহিল\u{9be} ভ\u{9cd}য\u{9be}ম\u{9cd}প\u{9be}য\u{9bc}\u{9be}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("sunerez-gwad"),
            keywords: &["sunerez-gwad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vampirica"),
            keywords: &["vampirica", "živi mrtvac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona vampir"),
            keywords: &["dona vampir", "morta vivent", "vampiressa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎩᎦ ᎠᏓᏁᎩᎡᎯ"),
            keywords: &["ᎠᎨᏯ ᎩᎦ ᎠᏓᏁᎩᎡᎯ", "ᎤᏲᎱᏒᎢ ᏂᎨᏒᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("upírka"),
            keywords: &["nemrtvá", "upírka", "vampýrka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("fampir benywaidd"),
            keywords: &["fampir benywaidd", "meirw byw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig vampyr"),
            keywords: &["kvindelig vampyr", "vampyr"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weiblicher Vampir"),
            keywords: &["Untoter", "weiblicher Vampir"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα βρυκόλακας"),
            keywords: &["απέθαντη", "γυναίκα βρυκόλακας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman vampire"),
            keywords: &["undead", "woman vampire"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("vampiresa"),
            keywords: &["muerta viviente", "no muerta", "vampiresa"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["muerta viviente", "vampiresa"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisvampiir"),
            keywords: &["naisvampiir", "surematu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume banpiro"),
            keywords: &["emakume banpiro", "hildako bizidun"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دراکولای زن"),
            keywords: &["دراکولای زن", "زن دراکولا", "مرده متحرک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naisvampyyri"),
            keywords: &[
                "elävä kuollut",
                "hampaat",
                "naisvampyyri",
                "torahammas",
                "verenhimo",
                "verenimijä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng bampira"),
            keywords: &["babaeng bampira", "buhay na patay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur vampýrur"),
            keywords: &[
                "blóðsúgvari",
                "drakula",
                "kona",
                "kvinna",
                "kvinnuligur vampýrur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vampire femme"),
            keywords: &["morte-vivante", "vampire femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["femme", "morte-vivante", "vampire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("vaimpír bhaineann"),
            keywords: &[
                "bean",
                "neamh-mharbh",
                "vaimpír baineann",
                "vaimpír bhaineann",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bhampair boireann"),
            keywords: &["bhampair boireann", "closach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vampiresa"),
            keywords: &["muller", "vampiresa", "vampiro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મહિલા પિશાચ"),
            keywords: &["મહિલા પિશાચ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai shan jini"),
            keywords: &["mace mai shan jini", "mara mutuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ערפדית"),
            keywords: &["באפי", "דרוסילה", "ערפדית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला व\u{948}म\u{94d}पायर"),
            keywords: &["मर कर भी जीवित", "महिला व\u{948}म\u{94d}पायर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vampirica"),
            keywords: &["neživa", "vampirica"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női vámpír"),
            keywords: &["női vámpír", "élőhalott", "élőholt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին-վամպիր"),
            keywords: &["ատամներ", "արյուն", "կին", "կին-վամպիր", "վամպիր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("vampir wanita"),
            keywords: &["mayat hidup", "vampir wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị ọmị obara"),
            keywords: &["akụkọ mmụọ", "nwanyị ọmị obara"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns vampíra"),
            keywords: &["hinir ódauðlegu", "kvenkyns vampíra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vampira"),
            keywords: &["non morto", "vampira"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女の吸血鬼"),
            keywords: &[
                "ドラキュラ",
                "バンパイア",
                "吸血鬼",
                "女",
                "女の吸血鬼",
                "女性",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("vampir wadon"),
            keywords: &["lelembut", "vampir wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვამპირი ქალი"),
            keywords: &["ვამპირი ქალი", "ცოცხალ-მკვდარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел вампир"),
            keywords: &["әйел вампир"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17b7}សាចស\u{17d2}រ\u{17b8}ជញ\u{17d2}ជក\u{17cb}ឈាម"),
            keywords: &[
                "ប\u{17b7}សាចម\u{17b7}នចេះស\u{17d2}លាប\u{17cb}",
                "ប\u{17b7}សាចស\u{17d2}រ\u{17b8}ជញ\u{17d2}ជក\u{17cb}ឈាម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ರಕ\u{ccd}ತಪ\u{cbf}ಶಾಚ\u{cbf}"),
            keywords: &[
                "ಮಹ\u{cbf}ಳಾ ವ\u{ccd}ಯಾಂಪೇರ\u{ccd}",
                "ಮಹ\u{cbf}ಳ\u{cc6} ರಕ\u{ccd}ತಪ\u{cbf}ಶಾಚ\u{cbf}",
                "ಶವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 뱀파이어"),
            keywords: &["드라큘라", "언데드", "여자 뱀파이어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल पिशाच\u{94d}च"),
            keywords: &["न मरपी", "बायल पिशाच\u{94d}च"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял кан соргуч"),
            keywords: &["аял кан соргуч", "өлбөс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vampirfra"),
            keywords: &["Vampirfra", "ondout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແວມພາຍຍ\u{eb4}ງ"),
            keywords: &["ຜ\u{eb5}ດ\u{eb4}ບ", "ແວມພາຍຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vampyrė"),
            keywords: &["nemirtingas", "vampyrė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vampīre"),
            keywords: &["nemirstīgs", "vampīre"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine kaitoto"),
            keywords: &["oramate", "wahine kaitoto"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена вампир"),
            keywords: &["жена вампир", "жив мртовец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെൺ രക\u{d4d}തരക\u{d4d}ഷസ\u{d4d}സ\u{d4d}"),
            keywords: &["അൺഡെഡ\u{d4d}", "പെൺ രക\u{d4d}തരക\u{d4d}ഷസ\u{d4d}സ\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй цус сорогч"),
            keywords: &["эмэгтэй цус сорогч", "үхээгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}त\u{94d}री व\u{94d}ह\u{901}पायर"),
            keywords: &[
                "जिव\u{902}त नसल\u{947}ला",
                "स\u{94d}त\u{94d}री व\u{94d}ह\u{901}पायर",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("puntianak wanita"),
            keywords: &["mayat hidup", "puntianak wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara vampira"),
            keywords: &["mara vampira", "qam mil-mewt"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း သ\u{103d}ေးစ\u{102f}ပ\u{103a}ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ),
            keywords: &[
                "မသေန\u{102d}\u{102f}င\u{103a}သော",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း သ\u{103d}ေးစ\u{102f}ပ\u{103a}ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig vampyr"),
            keywords: &["kvinnelig vampyr", "vandød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("किचकन\u{94d}नी"),
            keywords: &["किचकन\u{94d}नी", "म\u{943}त आत\u{94d}मा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke vampier"),
            keywords: &["ondode", "vrouwelijke vampier"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg vampyr"),
            keywords: &["kvinneleg vampyr", "vandød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ପ\u{b3f}ଶ\u{b3e}ଚ"),
            keywords: &[
                "ପ\u{b4d}ରେତ\u{b3e}ତ\u{b4d}ମ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e} ପ\u{b3f}ଶ\u{b3e}ଚ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਾਦਾ ਪਿਸ\u{a3c}ਾਚ"),
            keywords: &["ਜੀਉ\u{a02}ਦਾ", "ਮਾਦਾ ਪਿਸ\u{a3c}ਾਚ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("خونخوار زنانی"),
            keywords: &["آسیب", "خونخوار زنانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Vámpáya"),
            keywords: &[
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Dú Laik Sé I Dé Alaif",
                "Wúmán Vámpáya",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta wampir"),
            keywords: &["kobieta wampir", "nieumarli"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه بلا"),
            keywords: &["نامړ", "ښځه بلا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher vampira"),
            keywords: &["mulher vampira", "vampira"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("vampira"),
            keywords: &["morta-viva", "vampira"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi vampiro"),
            keywords: &["mana wañusqa", "warmi vampiro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie vampir"),
            keywords: &["femeie vampir", "strigoaie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1254"),
            keywords: &["E10-1254"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-вампир"),
            keywords: &["вампирша", "женщина", "женщина-вампир", "зубы", "кровь"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ivampayakazi"),
            keywords: &["abatarapfuye", "ivampayakazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت ڀوت"),
            keywords: &["جن", "عورت ڀوت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැණ\u{dd4} වැම\u{dca}පයර\u{dca}"),
            keywords: &["ගැණ\u{dd4} වැම\u{dca}පයර\u{dca}", "නොමැර\u{dd4}ණ\u{dd4}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("upírka"),
            keywords: &["upír", "upírka", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vampirka"),
            keywords: &["nesmrtnost", "vampirka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag reer-aakhiraad dhiig cab ah"),
            keywords: &["aan dhimanayn", "naag reer-aakhiraad dhiig cab ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua vampir"),
            keywords: &["e pavdekur", "grua vampir"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женски вампир"),
            keywords: &["женски вампир", "повампирен"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženski vampir"),
            keywords: &["povampiren", "ženski vampir"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig vampyr"),
            keywords: &["kvinnlig vampyr", "vandöd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mnyonya damu wa kike"),
            keywords: &["mnyonya damu wa kike", "zimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} இரத\u{bcd}தக\u{bcd} க\u{bbe}ட\u{bcd}டேரி"),
            keywords: &[
                "ச\u{bbe}க\u{bbe}வரம\u{bcd} பெற\u{bcd}றது",
                "பெண\u{bcd} இரத\u{bcd}தக\u{bcd} க\u{bbe}ட\u{bcd}டேரி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఆడ రక\u{c4d}తప\u{c3f}ప\u{c3e}స\u{c3f}"),
            keywords: &[
                "ఆడ రక\u{c4d}తప\u{c3f}ప\u{c3e}స\u{c3f}",
                "మరణం ల\u{c47}న\u{c3f}ద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани вампир"),
            keywords: &["вампирҳо", "зани вампир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แวมไพร\u{e4c}ผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &["อมตะ", "แวมไพร\u{e4c}ผ\u{e39}\u{e49}หญ\u{e34}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wampir aýal"),
            keywords: &["wampir aýal", "ölümsiz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine misi toto"),
            keywords: &["fefine misi toto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın vampir"),
            keywords: &["hortlak", "kadın vampir"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال مۇردا"),
            keywords: &["ئايال مۇردا", "مۇردا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-вампір"),
            keywords: &["жінка-вампір", "упириця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("خون خوار عورت"),
            keywords: &["خون خوار عورت", "زندہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol vampir"),
            keywords: &["ayol", "ayol vampir", "qon", "tish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ma cà rồng nữ"),
            keywords: &["ma cà rồng nữ", "xác sống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wàmpiir bu jigéen"),
            keywords: &["bu deewul", "wàmpiir bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-vampire elibhinqa"),
            keywords: &["i-vampire elibhinqa", "ongafanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Fánpáyà obìnrin"),
            keywords: &["Fánpáyà obìnrin", "àìlèkú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女吸血鬼"),
            keywords: &["亡靈", "女吸血鬼"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女吸血鬼"),
            keywords: &["亡灵", "女吸血鬼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女吸血鬼"),
            keywords: &["女不死族", "女吸血鬼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女吸血鬼"),
            keywords: &["女吸血鬼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["不死族", "女吸血鬼", "德古拉｜女吸血鬼"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ivemphaya lesifazane"),
            keywords: &["ivemphaya lesifazane", "ngafile"],
        },
    ],
};
#[doc = "🧛🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_VAMPIRE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9DB 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman vampire: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏻\u{200d}♀",
        codepoint: "1F9DB 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman vampire: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_VAMPIRE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9DB 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman vampire: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏼\u{200d}♀",
        codepoint: "1F9DB 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman vampire: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_VAMPIRE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9DB 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman vampire: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏽\u{200d}♀",
        codepoint: "1F9DB 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman vampire: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_VAMPIRE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9DB 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman vampire: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏾\u{200d}♀",
        codepoint: "1F9DB 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman vampire: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧛🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_VAMPIRE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧛🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9DB 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman vampire: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧛🏿\u{200d}♀",
        codepoint: "1F9DB 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman vampire: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜"]
pub const MERPERSON: crate::Emoji = crate::Emoji {
    glyph: "🧜",
    codepoint: "1F9DC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merperson",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("meerpersoon"),
            keywords: &["meerman", "meermin", "meerpersoon"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ግማሽ ሰው ግማሽ ዓሳ"),
            keywords: &["ግማሽ ሰው ግማሽ ዓሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مخلوق بحري بجسد بشري وذيل سمكة"),
            keywords: &[
                "كائن بحري بجسد بشري وذيل سمكة",
                "مخلوق بحري بجسد بشري وذيل سمكة",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৎস\u{9cd}যব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "মৎস\u{9cd}যকন\u{9cd}য\u{9be}",
                "মৎস\u{9cd}যপ\u{9c1}ৰ\u{9c1}ষ",
                "মৎস\u{9cd}যব\u{9cd}যক\u{9cd}তি",
                "মৎস\u{9cd}যমহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dəniz adamı"),
            keywords: &["dəniz adamı", "dəniz kişisi", "dəniz qadını", "su pərisi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("русалкі"),
            keywords: &["жанчына", "мужчына", "русалка", "русалкі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена амфибия"),
            keywords: &["жена амфибия", "мъж амфибия", "русалка", "човек амфибия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}রপ\u{9be}র\u{9cd}সেন"),
            keywords: &[
                "ম\u{9be}রউইমেন",
                "ম\u{9be}রপ\u{9be}র\u{9cd}সেন",
                "ম\u{9be}রমেড",
                "ম\u{9be}রমেন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sirena"),
            keywords: &["muškarac", "sirena", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona sirena"),
            keywords: &["dona sirena", "persona sirena", "sirena"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎠᏣᏗ ᎤᎬᎭᏟ"),
            keywords: &["ᎠᎨᏯ ᎠᏣᏗ ᎤᎬᎭᏟ", "ᎠᏍᎦᏯ ᎠᏣᏗ ᎤᎬᎭᏟ", "ᏴᏫ ᎠᏣᏗ ᎤᎬᎭᏟ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mořská bytost"),
            keywords: &[
                "moře",
                "mořská",
                "mořská bytost",
                "mořský",
                "muž",
                "nymfa",
                "panic",
                "panna",
                "postava",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("môrberson"),
            keywords: &["morwas", "môr-fenyw", "môr-forwyn", "môrberson"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("havvæsen"),
            keywords: &["hav", "havfolk", "havvæsen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wassermensch"),
            keywords: &["Meerjungfrau", "Wasserfrau", "Wassermann", "Wassermensch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γοργόνα"),
            keywords: &["γοργόνα", "γοργόνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("merperson"),
            keywords: &["mermaid", "merman", "merperson", "merwoman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona sirena"),
            keywords: &["persona sirena", "sirena"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["persona sirena", "sirena", "sireno"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("näkk"),
            keywords: &["meesnäkk", "merineitsi", "naisnäkk", "näkk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("itsas izaki"),
            keywords: &["itsas izaki", "lamina", "sirena"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دریامردمان"),
            keywords: &[
                "بالاتنه انسان پایین\u{200c}تنه ماهی",
                "دریازن",
                "دریامردمان",
                "پری دریایی",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("merenväki"),
            keywords: &[
                "kalanpyrstö",
                "merenhaltija",
                "merenväki",
                "vedenhaltija",
                "vetehinen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("merperson"),
            keywords: &["lalaking sirena", "merperson", "sirena"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("havfólk"),
            keywords: &["hav", "havfrúgv", "havfólk", "havmaður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("créature aquatique"),
            keywords: &["créature aquatique", "sirène", "triton"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["créature aquatique", "sirène", "triton"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine murúch"),
            keywords: &["duine murúch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach-mara"),
            keywords: &[
                "duine-mara",
                "maighdeann-chuain",
                "maighdeann-mhara",
                "neach-mara",
                "sluagh-mara",
                "òigh-mhara",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("serea"),
            keywords: &["serea"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મરપર\u{acd}સન"),
            keywords: &["મરપર\u{acd}સન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljanun ruwa"),
            keywords: &[
                "aljanar ruwa",
                "aljanin ruwa",
                "aljanun ruwa",
                "babbar aljanar ruwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בתולת ים"),
            keywords: &["בת הים", "בתולת ים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मत\u{94d}स\u{94d}यमानव"),
            keywords: &[
                "मत\u{94d}स\u{94d}यकन\u{94d}या",
                "मत\u{94d}स\u{94d}यप\u{941}र\u{941}ष",
                "मत\u{94d}स\u{94d}यमानव",
                "मत\u{94d}स\u{94d}यस\u{94d}त\u{94d}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("morska sirena"),
            keywords: &["morska sirena", "muška sirena", "sirena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sellő"),
            keywords: &["hablegény", "hableány", "sellő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մարդաձուկ"),
            keywords: &["մարդաձուկ", "ջրահարս", "տրիտոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang duyung"),
            keywords: &[
                "orang duyung",
                "pria duyung",
                "putri duyung",
                "wanita duyung",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onyewọta"),
            keywords: &["mamịwọta", "nwanyịwọta", "onyewọta", "papịwọta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sæbúi"),
            keywords: &["hafmeyja", "hafmær", "marbendill", "sæbúi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sirena"),
            keywords: &["sirena"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("人魚"),
            keywords: &["マーマン", "マーメイド", "人魚"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("duyung"),
            keywords: &["duyung", "duyung lanang", "duyung wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ადამიანთევზა"),
            keywords: &["ადამიანთევზა", "ალი", "კაცთევზა", "ქალთევზა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("теңіз тұрғыны"),
            keywords: &["теңіз тұрғыны"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សមច\u{17d2}ឆា"),
            keywords: &[
                "នាងមច\u{17d2}ឆា",
                "ប\u{17d2}រ\u{17bb}សមច\u{17d2}ឆា",
                "មន\u{17bb}ស\u{17d2}សមច\u{17d2}ឆា",
                "ស\u{17d2}រ\u{17b8}មច\u{17d2}ឆា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮತ\u{ccd}ಸ\u{ccd}ಯ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಮತ\u{ccd}ಸ\u{ccd}ಯ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಮತ\u{ccd}ಸ\u{ccd}ಯಕನ\u{ccd}ಯ\u{cc6}",
                "ಮತ\u{ccd}ಸ\u{ccd}ಯಪುರುಷ",
                "ಮತ\u{ccd}ಸ\u{ccd}ಯಮಹ\u{cbf}ಳ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("인어"),
            keywords: &["인어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मत\u{94d}स\u{94d}यव\u{94d}यक\u{94d}ती"),
            keywords: &[
                "जलपरा",
                "जलपरी",
                "जलव\u{94d}यक\u{94d}ती",
                "मत\u{94d}स\u{94d}यव\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сууда жашаган жандык (русалка сымал)"),
            keywords: &[
                "аял русалка",
                "русалка",
                "сууда жашаган жандык (русалка сымал)",
                "эркек русалка",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mierpersoun"),
            keywords: &["Mierjonfra", "Miermann", "Mierpersoun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເງ\u{eb7}ອກຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &[
                "ນາງເງ\u{eb7}ອກ",
                "ເງ\u{eb7}ອກ",
                "ເງ\u{eb7}ອກຜ\u{eb9}\u{ec9}ຊາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("undinius"),
            keywords: &["undinius", "undinė", "undinėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēks nāra"),
            keywords: &["cilvēks nāra", "nāra", "nāris", "nārveidīgs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata-ika"),
            keywords: &["tangata-ika", "tāne-ika", "wahine-ika"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("морско лице"),
            keywords: &["морска жена", "морски маж", "морско лице", "сирена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മത\u{d4d}സ\u{d4d}യമന\u{d41}ഷ\u{d4d}യൻ"),
            keywords: &[
                "മത\u{d4d}സ\u{d4d}യകന\u{d4d}യക",
                "മത\u{d4d}സ\u{d4d}യനരൻ",
                "മത\u{d4d}സ\u{d4d}യമന\u{d41}ഷ\u{d4d}യൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лусын хүн"),
            keywords: &[
                "лусын дагина",
                "лусын хүн",
                "лусын эмэгтэй",
                "лусын эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मरपर\u{94d}सन"),
            keywords: &[
                "जलपरी",
                "प\u{941}र\u{942}ष जलपरी",
                "मरपर\u{94d}सन",
                "मरव\u{94d}ह\u{941}मन",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("manusia duyung"),
            keywords: &[
                "duyung betina",
                "duyung jantan",
                "ikan duyung",
                "manusia duyung",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("merperson"),
            keywords: &["merman", "merperson", "merwoman", "serena"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေလ\u{1030}"),
            keywords: &["ရေလ\u{1030}", "ရေသ\u{1030}ထ\u{102e}း", "ရေသ\u{1030}မ"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("havperson"),
            keywords: &["havfrue", "havkvinne", "havmann", "havperson"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मत\u{94d}स\u{94d}यमान\u{94d}छ\u{947}"),
            keywords: &[
                "जलपरी",
                "मत\u{94d}स\u{94d}यछोरामान\u{94d}छ\u{947}",
                "मत\u{94d}स\u{94d}यछोरीमान\u{94d}छ\u{947}",
                "मत\u{94d}स\u{94d}यमान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zeemeermin"),
            keywords: &["meerman", "meermin", "sirene", "zeemeermin"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("havperson"),
            keywords: &["havfrue", "havkvinne", "havmann", "havperson"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମରପର\u{b4d}ସନ"),
            keywords: &[
                "ମତ\u{b4d}ସ\u{b3e}ଗଂନ\u{b3e}",
                "ମରପର\u{b4d}ସନ",
                "ମରପର\u{b4d}ସନ\u{b4d}",
                "ମରମ\u{b4d}ୟ\u{b3e}ନ\u{b4d} । ମରଓମ\u{b4d}ୟ\u{b3e}ନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਲ ਮਾਨਵ"),
            keywords: &["ਜਲ ਔਰਤ", "ਜਲ ਪ\u{a41}ਰਸ\u{a3c}", "ਜਲ ਮਾਨਵ", "ਜਲਪਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جل دیو"),
            keywords: &["جل دیو", "جل مانس", "جل پری", "ماہی زن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Bi Mamíwọtá"),
            keywords: &[
                "Mamíwọtá",
                "Mán Mamíwọtá",
                "Pẹ\u{301}sin Wé Bi Mamíwọtá",
                "Wúmán Mamíwọtá",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("syrena"),
            keywords: &["syrena"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مرپرسن"),
            keywords: &["مرميډ مرمين", "مرپرسن", "مرښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa sereia"),
            keywords: &["pessoa sereia", "sereia"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tritão"),
            keywords: &["sereia", "tritão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa sirena"),
            keywords: &["runa sirena", "sirena", "tata triton", "warmi sirena"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană sirenă"),
            keywords: &["persoană sirenă", "sirene", "sirenă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1133"),
            keywords: &["E10-1133"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("русалка"),
            keywords: &["полурыба", "русалка", "тритон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("muntusamaki"),
            keywords: &[
                "madamusamaki",
                "mugabosamaki",
                "mukobwasamaki",
                "muntusamaki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميل پرسن"),
            keywords: &["جل پري، جل مانس", "ميل پرسن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dd4}"),
            keywords: &[
                "ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dcf}",
                "ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dd2}ය",
                "ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dd4}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("morská bytosť"),
            keywords: &["more", "morská bytosť", "muž", "panna"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("morska oseba"),
            keywords: &[
                "morska deklica",
                "morska oseba",
                "morska ženska",
                "morski mož",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof cajiib ah"),
            keywords: &[
                "gabareey-maanyo",
                "haweeney cajiib ah",
                "qof cajiib ah",
                "wiilo-maanyo",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sirenë deti"),
            keywords: &["sirenë deti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа из мора"),
            keywords: &["особа из мора", "сирена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba iz mora"),
            keywords: &["osoba iz mora", "sirena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vattenväsen"),
            keywords: &["näcken", "sjöjungfru", "sjörå", "vattenväsen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguva mtu"),
            keywords: &["nguva", "nguva dume", "nguva kike", "nguva mtu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடல\u{bcd}மனிதன\u{bcd}"),
            keywords: &["கடல\u{bcd}கன\u{bcd}னி", "கடல\u{bcd}மனிதன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జల వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "జల వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "జలకన\u{c4d}య",
                "జలపురుషుడు",
                "జలస\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахси обӣ"),
            keywords: &["марди обӣ", "парии обӣ", "шахси обӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คร\u{e36}\u{e48}งคนคร\u{e36}\u{e48}งปลา"),
            keywords: &["คร\u{e36}\u{e48}งคนคร\u{e36}\u{e48}งปลา", "เมอร\u{e4c}เมด"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suw adam"),
            keywords: &["suw adam", "suw erkegi", "suw gyzy", "suw perisi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha meimeite"),
            keywords: &["tokotaha meimeite"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balık insan"),
            keywords: &["balık insan"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلىق ئادەم"),
            keywords: &["بېلقىز", "بېلىق ئادەم", "سۇ پەرىسى", "سۇپەرىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("казкова водяна істота"),
            keywords: &[
                "жінка-русалка",
                "казкова водяна істота",
                "русалка",
                "чоловік-русалка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پانی کے جاندار"),
            keywords: &["جل پری", "پانی کے جاندار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("suv parisi"),
            keywords: &["suv parisi", "triton", "yarim baliq", "yarim odam"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người cá"),
            keywords: &["chàng tiên cá", "công chúa cá", "người cá", "nàng tiên cá"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sireen bu nit"),
            keywords: &[
                "sireen",
                "sireen bu góor",
                "sireen bu jigéen",
                "sireen bu nit",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-merperson"),
            keywords: &[
                "i-merperson",
                "i-merwoman",
                "indoda-ntlazi yasentsomini",
                "intombi-ntlazi yasentsomini",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yemọja ènìyàn"),
            keywords: &["Yemọja", "Yemọja ènìyàn"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("人魚"),
            keywords: &["人魚", "女美人魚", "男美人魚", "美人魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("人鱼"),
            keywords: &["人鱼", "女美人鱼", "男美人鱼", "美人鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("人鱼"),
            keywords: &["人鱼", "女人鱼", "男人鱼", "美人鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("人魚"),
            keywords: &["人魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-merperson"),
            keywords: &["i-mermaid", "i-merman", "i-merperson", "i-merwoman"],
        },
    ],
};
#[doc = "🧜🏻"]
pub const MERPERSON_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏻",
    codepoint: "1F9DC 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merperson: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧜🏼"]
pub const MERPERSON_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏼",
    codepoint: "1F9DC 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merperson: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧜🏽"]
pub const MERPERSON_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏽",
    codepoint: "1F9DC 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merperson: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧜🏾"]
pub const MERPERSON_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏾",
    codepoint: "1F9DC 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merperson: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧜🏿"]
pub const MERPERSON_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏿",
    codepoint: "1F9DC 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merperson: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧜\u{200d}♂\u{fe0f}"]
pub const MERMAN: crate::Emoji = crate::Emoji {
    glyph: "🧜\u{200d}♂\u{fe0f}",
    codepoint: "1F9DC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merman",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜\u{200d}♂",
        codepoint: "1F9DC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "merman",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("meerman"),
            keywords: &["Triton", "meerman"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ግማሽ ሰው ግማሽ ዓሳ"),
            keywords: &["ወንድ ግማሽ ሰው ግማሽ ዓሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مخلوق له جسد رجل وذيل سمكة"),
            keywords: &["مخلوق له جسد رجل وذيل سمكة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৎস\u{9cd}যপ\u{9c1}ৰ\u{9c1}ষ"),
            keywords: &["ট\u{9cd}ৰ\u{9be}ইট’ন", "মৎস\u{9cd}যপ\u{9c1}ৰ\u{9c1}ষ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dəniz kişisi"),
            keywords: &["Triton", "dəniz kişisi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-русалка"),
            keywords: &["Трытон", "мужчына-русалка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж амфибия"),
            keywords: &["Тритон", "мъж амфибия"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}রম\u{9cd}য\u{9be}ন"),
            keywords: &["ট\u{9cd}রিটন", "ম\u{9be}রম\u{9cd}য\u{9be}ন"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morgan"),
            keywords: &["morgan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac sirena"),
            keywords: &["Triton", "muškarac sirena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home sirena"),
            keywords: &["Tritó", "home sirena"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎠᏣᏗ ᎤᎬᎭᏟ"),
            keywords: &["ᎠᏍᎦᏯ ᎠᏣᏗ ᎤᎬᎭᏟ", "ᎠᏓᎯᏍᏙᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mořský muž"),
            keywords: &[
                "mořský",
                "mořský muž",
                "nymfa",
                "panic",
                "poseidón",
                "tritón",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("morwas"),
            keywords: &["Triton", "morwas"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("havmand"),
            keywords: &["Triton", "hav", "havmand", "mand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wassermann"),
            keywords: &["Triton", "Wassermann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γοργόνος"),
            keywords: &["Τρίτων", "γοργόνος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("merman"),
            keywords: &["Triton", "merman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sirena hombre"),
            keywords: &["sirena", "sirena hombre", "tritón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("sireno"),
            keywords: &["sirena", "sirena hombre", "sireno", "tritón"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesnäkk"),
            keywords: &["Triton", "meesnäkk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon-itxurako itsas izaki"),
            keywords: &["Triton", "gizon-itxurako itsas izaki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دریامرد"),
            keywords: &["تریتون", "دریامرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("merenmies"),
            keywords: &[
                "Ahti",
                "Triton",
                "kalanpyrstö",
                "merenhaltija",
                "merenmies",
                "merenväki",
                "vedenhaltija",
                "vetehinen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking sirena"),
            keywords: &["Triton", "lalaking sirena"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("havmaður"),
            keywords: &["havmaður", "triton"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("triton"),
            keywords: &["Triton", "triton"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["triton"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("murúch fir"),
            keywords: &["murúch fir", "tríotón"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine-mara"),
            keywords: &["Lìr", "Triton", "duine-mara", "sluagh-mara"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("serea de sexo masculino"),
            keywords: &["home", "serea", "serea de sexo masculino"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મરમ\u{ac7}ન"),
            keywords: &["મરમ\u{ac7}ન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljanin ruwa"),
            keywords: &["Triton", "aljanin ruwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בן ים"),
            keywords: &["בן ים", "טריטון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मत\u{94d}स\u{94d}यप\u{941}र\u{941}ष"),
            keywords: &["ट\u{94d}राइटन", "मत\u{94d}स\u{94d}यप\u{941}र\u{941}ष"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muška sirena"),
            keywords: &["Triton", "muška sirena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi sellő"),
            keywords: &["Triton", "férfi sellő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տրիտոն"),
            keywords: &["ձուկ", "տղամարդ", "տրիտոն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria duyung"),
            keywords: &["Triton", "pria duyung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwokewọta"),
            keywords: &["Tritọn", "nwokewọta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("marbendill"),
            keywords: &["Tríton", "marbendill"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("tritone"),
            keywords: &["Tritone", "tritone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マーマン"),
            keywords: &["マーマン", "人魚", "男", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("duyung lanang"),
            keywords: &["Triton", "duyung lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცთევზა"),
            keywords: &["კაცთევზა", "ტრიტონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құйрықты"),
            keywords: &["тритон", "құйрықты"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រ\u{17bb}សមច\u{17d2}ឆា"),
            keywords: &["ត\u{17d2}រាយត\u{17bb}ន", "ប\u{17d2}រ\u{17bb}សមច\u{17d2}ឆា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮತ\u{ccd}ಸ\u{ccd}ಯ ಪುರುಷ"),
            keywords: &["ಟ\u{ccd}ರ\u{cbf}ಟನ\u{ccd}", "ಮತ\u{ccd}ಸ\u{ccd}ಯ ಪುರುಷ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 인어"),
            keywords: &["남자 인어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मत\u{94d}स\u{94d}यदादलो"),
            keywords: &["ट\u{94d}रायटन", "मत\u{94d}स\u{94d}यदादलो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек русалка"),
            keywords: &["Тритон", "эркек русалка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Miermann"),
            keywords: &["Miermann", "Triton"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເງ\u{eb7}ອກຊາຍ"),
            keywords: &["ເງ\u{eb7}ອກຊາຍ", "ໄທຣທ\u{eb1}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vandenis/undinius"),
            keywords: &["Tritonas", "vandenis/undinius"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis nāra"),
            keywords: &["Tritons", "vīrietis nāra"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne-ika"),
            keywords: &["Tiritono", "tāne-ika"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж сирена"),
            keywords: &["маж сирена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മത\u{d4d}സ\u{d4d}യനരൻ"),
            keywords: &["ട\u{d4d}രിട\u{d4d}ടോൺ", "മത\u{d4d}സ\u{d4d}യനരൻ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лусын хаан"),
            keywords: &["Тритон", "лусын хаан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मरम\u{945}न"),
            keywords: &["ट\u{94d}रायटन", "मरम\u{945}न"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("duyung jantan"),
            keywords: &["Triton", "duyung jantan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("merman"),
            keywords: &["Triton", "merman"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေသ\u{1030}ထ\u{102e}း"),
            keywords: &[
                "ထရ\u{103d}\u{102d}င\u{103a}တ\u{103d}န\u{103a}",
                "ရေသ\u{1030}ထ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("havmann"),
            keywords: &["Triton", "havmann"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मत\u{94d}स\u{94d}यछोरामान\u{94d}छ\u{947}"),
            keywords: &["ट\u{94d}रिटन", "मत\u{94d}स\u{94d}यछोरामान\u{94d}छ\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zeemeerman"),
            keywords: &["Triton", "zeemeerman"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("havmann"),
            keywords: &["Triton", "havmann"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମରମ\u{b4d}ୟ\u{b3e}ନ\u{b4d}"),
            keywords: &[
                "ଟ\u{b4d}ର\u{b3e}ଇଟନ\u{b4d}\u{200d}",
                "ମରମ\u{b4d}ୟ\u{b3e}ନ\u{b4d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਲ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &["ਜਲ ਪ\u{a41}ਰਸ\u{a3c}", "ਟ\u{a4d}ਰਾਈਟਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جل مانس"),
            keywords: &["جل مانس", "ٹرائی ٹن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Mamíwọtá"),
            keywords: &[
                "Mán Mamíwọtá",
                "Trítọn: Wọ\u{301}n Bád Spírit Wé De Lív Fọ Wọta",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna syrena"),
            keywords: &["Tryton", "mężczyzna syrena"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مرمین"),
            keywords: &["مرمین", "ټريټان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sereio"),
            keywords: &["Tritão", "sereio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("tritão (homem)"),
            keywords: &["Tritão", "tritão", "tritão (homem)"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata triton"),
            keywords: &["Triton", "tata triton"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat sirenă"),
            keywords: &["Triton", "bărbat sirenă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1257"),
            keywords: &["E10-1257"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("тритон"),
            keywords: &["мужчина", "полурыба", "русалка", "тритон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mugabosamaki"),
            keywords: &["Tirito", "mugabosamaki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جل مانس"),
            keywords: &["جل مانس", "ساگر ديوتا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dcf}"),
            keywords: &[
                "ට\u{dca}\u{200d}ර\u{dd2}ටෝන\u{dca}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("morský muž"),
            keywords: &["more", "morský muž", "muž"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("morski mož"),
            keywords: &["Triton", "morski mož"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wiilo-maanyo"),
            keywords: &["ninka gabareey-maanyada", "wiilo-maanyo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë sirenë"),
            keywords: &["Triton", "burrë sirenë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац из мора"),
            keywords: &["Тритон", "мушкарац из мора"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac iz mora"),
            keywords: &["Triton", "muškarac iz mora"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("strömkarl"),
            keywords: &["Triton", "strömkarl"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguva dume"),
            keywords: &["nguva Triton", "nguva dume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} கடல\u{bcd}மனிதன\u{bcd}"),
            keywords: &["ஆண\u{bcd} கடல\u{bcd}மனிதன\u{bcd}", "டிரைட\u{bcd}டன\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జలపురుషుడు"),
            keywords: &["జలపురుషుడు", "ట\u{c4d}ర\u{c3f}టన\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди обӣ"),
            keywords: &["Самандар", "марди обӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เง\u{e37}อกชาย"),
            keywords: &["เง\u{e37}อกชาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suw erkegi"),
            keywords: &["Triton şa", "suw erkegi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata meimeite"),
            keywords: &["tangata meimeite"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("balık adam"),
            keywords: &["balık adam"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلىق ئەر"),
            keywords: &["بېلىق ئەر", "ترىتون"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-русалка"),
            keywords: &["Тритон", "чоловік-русалка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جل مانس"),
            keywords: &["جل مانس", "سمندری دیوتا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("triton"),
            keywords: &["erkak", "triton", "yarim baliq", "yarim erkak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chàng tiên cá"),
            keywords: &["chàng tiên cá", "thần nửa người nửa cá"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sireen bu góor"),
            keywords: &["Fettu ñatti bopp", "sireen bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-merman"),
            keywords: &["I-Triton", "i-merman"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yemọja ọkùnrin"),
            keywords: &["Triton", "Yemọja ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男美人魚"),
            keywords: &["Triton", "男美人魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男美人鱼"),
            keywords: &["Triton", "男美人鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男人鱼"),
            keywords: &["特里同", "男人鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男人魚"),
            keywords: &["男人魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["男人魚", "男人魚｜人魚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-merman"),
            keywords: &["i-Triton", "i-merman"],
        },
    ],
};
#[doc = "🧜🏻\u{200d}♂\u{fe0f}"]
pub const MERMAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9DC 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merman: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏻\u{200d}♂",
        codepoint: "1F9DC 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "merman: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏼\u{200d}♂\u{fe0f}"]
pub const MERMAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9DC 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merman: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏼\u{200d}♂",
        codepoint: "1F9DC 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "merman: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏽\u{200d}♂\u{fe0f}"]
pub const MERMAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9DC 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merman: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏽\u{200d}♂",
        codepoint: "1F9DC 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "merman: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏾\u{200d}♂\u{fe0f}"]
pub const MERMAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9DC 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merman: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏾\u{200d}♂",
        codepoint: "1F9DC 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "merman: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏿\u{200d}♂\u{fe0f}"]
pub const MERMAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9DC 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "merman: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏿\u{200d}♂",
        codepoint: "1F9DC 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "merman: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜\u{200d}♀\u{fe0f}"]
pub const MERMAID: crate::Emoji = crate::Emoji {
    glyph: "🧜\u{200d}♀\u{fe0f}",
    codepoint: "1F9DC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mermaid",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜\u{200d}♀",
        codepoint: "1F9DC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "mermaid",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("meermin"),
            keywords: &["meermin"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ግማሽ ሰው ግማሽ ዓሳ"),
            keywords: &["ሴት ግማሽ ሰው ግማሽ ዓሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("حورية بحر"),
            keywords: &["حورية بحر", "عروسة البحر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মৎস\u{9cd}যকন\u{9cd}য\u{9be}"),
            keywords: &["মৎস\u{9cd}যকন\u{9cd}য\u{9be}", "মৎস\u{9cd}যমহিল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("su pərisi"),
            keywords: &["dəniz qadını", "su pərisi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("русалка"),
            keywords: &["жанчына-русалка", "русалка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("русалка"),
            keywords: &["жена амфибия", "русалка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9be}রমেড"),
            keywords: &["ম\u{9be}রউইমেন", "ম\u{9be}রমেড"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("morganez"),
            keywords: &["morganez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena sirena"),
            keywords: &["sirena", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("sirena"),
            keywords: &["dona sirena", "sirena"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎠᏣᏗ ᎤᎬᎭᏟ"),
            keywords: &["ᎠᎨᏯ ᎠᏣᏗ ᎠᎹ", "ᎠᎨᏯ ᎠᏣᏗ ᎤᎬᎭᏟ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mořská panna"),
            keywords: &["mořská", "mořská panna", "nymfa", "víla", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("môr-forwyn"),
            keywords: &["môr-fenyw", "môr-forwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("havfrue"),
            keywords: &["hav", "havfrue", "kvinde"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Meerjungfrau"),
            keywords: &["Meerjungfrau", "Nixe", "Wasserfrau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα γοργόνα"),
            keywords: &["γοργόνα", "γυναίκα γοργόνα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mermaid"),
            keywords: &["mermaid", "merwoman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("sirena"),
            keywords: &["sirena"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["sirena", "sirena mujer"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("merineitsi"),
            keywords: &["merineitsi", "naisnäkk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("lamina"),
            keywords: &["lamina", "sirena"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پری دریایی"),
            keywords: &["دریازن", "پری دریایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("merenneito"),
            keywords: &[
                "kalanpyrstö",
                "merenneito",
                "merenväki",
                "pyrstö",
                "seireeni",
                "vedenväki",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sirena"),
            keywords: &["babaeng sirena", "sirena"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("havfrúgv"),
            keywords: &["havfrúgv"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("sirène"),
            keywords: &["sirène"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("murúch"),
            keywords: &["bean", "murúch"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("maighdeann-mhara"),
            keywords: &[
                "maighdeann-chuain",
                "maighdeann-mhara",
                "sluagh-mara",
                "òigh-mhara",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("serea de sexo feminino"),
            keywords: &["muller", "serea", "serea de sexo feminino"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મરમ\u{ac7}ઈડ"),
            keywords: &["મરમ\u{ac7}ઈડ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljanar ruwa"),
            keywords: &["aljanar ruwa", "babbar aljanar ruwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בת הים"),
            keywords: &["בת הים", "סירונית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मत\u{94d}स\u{94d}यकन\u{94d}या"),
            keywords: &[
                "मत\u{94d}स\u{94d}यकन\u{94d}या",
                "मत\u{94d}स\u{94d}यस\u{94d}त\u{94d}री",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sirena"),
            keywords: &["sirena", "ženska sirena"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("sellőlány"),
            keywords: &["női sellő", "sellőlány"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջրահարս"),
            keywords: &["կին", "ձուկ", "ջրահարս"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("putri duyung"),
            keywords: &["putri duyung", "wanita duyung"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mamịwọta"),
            keywords: &["mamịwọta", "nwanyịwọta"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hafmeyja"),
            keywords: &["hafmeyja", "hafmær"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("sirena donna"),
            keywords: &["sirena", "sirena donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マーメイド"),
            keywords: &["マーメイド", "人魚", "女", "女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("duyung wadon"),
            keywords: &["duyung wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალთევზა"),
            keywords: &["ალი", "ქალთევზა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("су перісі"),
            keywords: &["су перісі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នាងមច\u{17d2}ឆា"),
            keywords: &["នាងមច\u{17d2}ឆា", "ស\u{17d2}រ\u{17b8}មច\u{17d2}ឆា"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮತ\u{ccd}ಸ\u{ccd}ಯ ಕನ\u{ccd}ಯ\u{cc6}"),
            keywords: &[
                "ಮತ\u{ccd}ಸ\u{ccd}ಯ ಕನ\u{ccd}ಯ\u{cc6}",
                "ಮತ\u{ccd}ಸ\u{ccd}ಯ ಮಹ\u{cbf}ಳ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 인어"),
            keywords: &["여자 인어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मत\u{94d}स\u{94d}यकन\u{94d}या"),
            keywords: &["मत\u{94d}स\u{94d}यकन\u{94d}या", "मत\u{94d}स\u{94d}यबायल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("русалка"),
            keywords: &["аял русалка", "русалка"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mierjongfra"),
            keywords: &["Mierfra", "Mierjongfra"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນາງເງ\u{eb7}ອກ"),
            keywords: &["ນາງເງ\u{eb7}ອກ", "ເງ\u{eb7}ອກຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("undinėlė"),
            keywords: &["undinėlė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nāra"),
            keywords: &["nāra", "sieviete nāra"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("hine-ika"),
            keywords: &["hine-ika", "wahine-ika"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("сирена"),
            keywords: &["морска жена", "сирена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മത\u{d4d}സ\u{d4d}യകന\u{d4d}യക"),
            keywords: &[
                "മത\u{d4d}സ\u{d4d}യകന\u{d4d}യക",
                "മത\u{d4d}സ\u{d4d}യസ\u{d4d}\u{200c}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("лусын дагина"),
            keywords: &["лусын дагина", "лусын эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जलपरी"),
            keywords: &["जलपरी", "मरव\u{94d}ह\u{941}मन"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("ikan duyung"),
            keywords: &["duyung jantan", "ikan duyung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("serena"),
            keywords: &["merwoman", "serena"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရေသ\u{1030}မ"),
            keywords: &[
                "ရေသ\u{1030}မ",
                "ရေသ\u{1030}မ (အမျ\u{102d}\u{102f}းသမ\u{102e}း)",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("havfrue"),
            keywords: &["havfrue", "havkvinne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जलपरी"),
            keywords: &["जलपरी", "मत\u{94d}स\u{94d}यछोरीमान\u{94d}छ\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("sirene"),
            keywords: &["meermin", "sirene"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("havfrue"),
            keywords: &["havfrue", "havkvinne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମତ\u{b4d}ସ\u{b3e}ଗଂନ\u{b3e}"),
            keywords: &["ମତ\u{b4d}ସ\u{b3e}ଗଂନ\u{b3e}", "ମରଓମ\u{b4d}ୟ\u{b3e}ନ\u{b4d}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਲਪਰੀ"),
            keywords: &["ਜਲ ਔਰਤ", "ਜਲਪਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ماہی زن"),
            keywords: &["جل پری", "ماہی زن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Mamíwọtá"),
            keywords: &["Mamíwọtá", "Wúmán Mamíwọtá"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta syrena"),
            keywords: &["kobieta syrena", "syrena"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مرمیڈ"),
            keywords: &["مرمیڈ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sereia"),
            keywords: &["sereia"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sirena"),
            keywords: &["sirena", "warmi sirena"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("sirenă"),
            keywords: &["sirenă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1256"),
            keywords: &["E10-1256"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-русалка"),
            keywords: &["женщина", "женщина-русалка", "полурыба", "русалка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("makobwasamaki"),
            keywords: &["madamusamaki", "makobwasamaki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جل پري"),
            keywords: &["جل پري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dcf}"),
            keywords: &[
                "ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dcf}",
                "ද\u{dd2}යක\u{dd2}ඳ\u{dd4}ර\u{dd2}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("morská panna"),
            keywords: &["more", "morská panna", "panna"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("morska deklica"),
            keywords: &["morska deklica"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gabreey-maanyo"),
            keywords: &["gabareey-maanyo", "gabreey-maanyo", "haweeney cajiib ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua sirenë"),
            keywords: &["grua sirenë", "sirenë deti"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("сирена"),
            keywords: &["жена из мора", "сирена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("sirena"),
            keywords: &["sirena", "žena iz mora"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("sjöjungfru"),
            keywords: &["sjöjungfru", "sjörå"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("nguva"),
            keywords: &["nguva", "nguva kike"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கடல\u{bcd}கன\u{bcd}னி"),
            keywords: &[
                "கடல\u{bcd}கன\u{bcd}னி",
                "கடல\u{bcd}மனிதன\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జలకన\u{c4d}య"),
            keywords: &["జలకన\u{c4d}య", "జలస\u{c4d}త\u{c4d}ర\u{c40}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("парии обӣ"),
            keywords: &["парии обӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เง\u{e37}อก"),
            keywords: &["เง\u{e37}อก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("suw gyzy"),
            keywords: &["suw aýaly", "suw gyzy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine meimeite"),
            keywords: &["fefine meimeite"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("denizkızı"),
            keywords: &["balık kadın", "denizkızı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بېلىق قىز"),
            keywords: &["بېلىق قىز", "سۇ پەرىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("русалка"),
            keywords: &["жінка-русалка", "русалка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جل پری"),
            keywords: &["جل پری", "سمندری عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol suv parisi"),
            keywords: &[
                "ayol",
                "ayol suv parisi",
                "suv parisi",
                "yarim ayol",
                "yarim baliq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nàng tiên cá"),
            keywords: &["công chúa cá", "nàng tiên cá"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("sireen"),
            keywords: &["sireen", "sireen bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intombi-ntlanzi yasentsomini"),
            keywords: &["i-merwoman", "intombi-ntlanzi yasentsomini"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("iyemọja"),
            keywords: &["Yemọja obìnrin", "iyemọja"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("美人魚"),
            keywords: &["女美人魚", "美人魚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("美人鱼"),
            keywords: &["女美人鱼", "美人鱼"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("美人鱼"),
            keywords: &["女人鱼", "美人鱼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("美人魚"),
            keywords: &["美人魚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["美人魚", "美人魚｜人魚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-mermaid"),
            keywords: &["i-mermaid", "i-merwoman"],
        },
    ],
};
#[doc = "🧜🏻\u{200d}♀\u{fe0f}"]
pub const MERMAID_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9DC 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mermaid: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏻\u{200d}♀",
        codepoint: "1F9DC 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "mermaid: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏼\u{200d}♀\u{fe0f}"]
pub const MERMAID_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9DC 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mermaid: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏼\u{200d}♀",
        codepoint: "1F9DC 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "mermaid: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏽\u{200d}♀\u{fe0f}"]
pub const MERMAID_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9DC 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mermaid: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏽\u{200d}♀",
        codepoint: "1F9DC 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "mermaid: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏾\u{200d}♀\u{fe0f}"]
pub const MERMAID_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9DC 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mermaid: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏾\u{200d}♀",
        codepoint: "1F9DC 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "mermaid: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧜🏿\u{200d}♀\u{fe0f}"]
pub const MERMAID_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧜🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9DC 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "mermaid: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧜🏿\u{200d}♀",
        codepoint: "1F9DC 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "mermaid: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝"]
pub const ELF: crate::Emoji = crate::Emoji {
    glyph: "🧝",
    codepoint: "1F9DD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "elf",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("elf"),
            keywords: &["elf", "toweragtig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ኤልፍ"),
            keywords: &["ኤልፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جن\u{651}ي صغير"),
            keywords: &["إلف", "إيلف", "جن\u{651}ي صغير", "كائن سحري", "مخلوق سحري"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("যোগীনী"),
            keywords: &["য\u{9be}দ\u{9c1}কৰী", "যোগীনী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("elf"),
            keywords: &["elf", "sehrli"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("эльф"),
            keywords: &["казачныя", "эльф"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("елф"),
            keywords: &["елф", "магическо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("এল\u{9cd}ফ"),
            keywords: &["এল\u{9cd}ফ", "জ\u{9be}দ\u{9c1}করী"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("patuljak"),
            keywords: &["magija", "patuljak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("elf"),
            keywords: &["elf", "màgic"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ ᎤᏍᏆᏂᎪᏗᏳ"),
            keywords: &["ᎤᏕᎵᏛ ᎬᏗ ᎠᏛᏁᎸᏗ", "ᏴᏫ ᎤᏍᏆᏂᎪᏗᏳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("obličej elfa"),
            keywords: &["elf", "kouzelná", "les", "magie", "obličej elfa", "postava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coblyn"),
            keywords: &["coblyn", "hudol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elver"),
            keywords: &["elver", "magi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Elf(e)"),
            keywords: &["Elbe", "Elben", "Elbin", "Elf(e)", "magisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ξωτικό"),
            keywords: &["μαγικό", "ξωτικό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("elf"),
            keywords: &["elf", "magical"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("elfo"),
            keywords: &["elfo", "mágico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("päkapikk"),
            keywords: &["maagiline", "päkapikk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("elfo"),
            keywords: &["elfo", "magiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ا\u{650}لف"),
            keywords: &["ا\u{650}لف", "جادویی", "سحرآمیز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("haltia"),
            keywords: &[
                "Legolas",
                "alf",
                "haltia",
                "keiju",
                "keijukainen",
                "suippokorva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("duwende"),
            keywords: &["duwende", "mahiwaga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("álvur"),
            keywords: &["álva", "álvur", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("elfe"),
            keywords: &["elfe", "magique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lucharachán"),
            keywords: &["draíochtúil", "lucharachán", "síogaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ailbhear"),
            keywords: &["ailbhear", "draoidheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("elfo"),
            keywords: &["elfo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઈલ\u{acd}ફ"),
            keywords: &["ઈલ\u{acd}ફ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jinsiri"),
            keywords: &["abin dabo", "jinsiri"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אלף"),
            keywords: &["אלף", "יצור קסום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जाद\u{941}ई प\u{94d}राणी"),
            keywords: &["जाद\u{941}ई", "जाद\u{941}ई प\u{94d}राणी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šumski vilenjak"),
            keywords: &["magično", "šumski vilenjak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tünde"),
            keywords: &["mágikus", "tünde"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("էլֆ"),
            keywords: &["էլֆ", "կախարդական", "կախարդանք", "հեքիաթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kurcaci"),
            keywords: &["ajaib", "kurcaci"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("elfụ"),
            keywords: &["elfụ", "àbràkàtabrà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("huldumaður"),
            keywords: &[
                "galdrar",
                "huldumaður",
                "töfrandi",
                "töfrar",
                "yfirnáttúrleiki",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("elfo"),
            keywords: &["elfo", "magico"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("エルフ"),
            keywords: &["エルフ", "妖精", "小妖精"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peri"),
            keywords: &["ajaib", "peri"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ელფი"),
            keywords: &["ელფი", "ზღაპარი", "მაგიური", "ჯადოსნული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ергежейлі"),
            keywords: &["ергежейлі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អែលហ\u{17d2}វ"),
            keywords: &["ដែលចេះវេទមន\u{17d2}ត", "អែលហ\u{17d2}វ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯಕ\u{ccd}ಷ\u{cbf}ಣ\u{cbf}"),
            keywords: &["ಮಾಂತ\u{ccd}ರ\u{cbf}ಕ", "ಯಕ\u{ccd}ಷ\u{cbf}ಣ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("엘프"),
            keywords: &["엘프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वनद\u{947}वता"),
            keywords: &["जाद\u{941}ई", "वनद\u{947}वता"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эльф"),
            keywords: &["сыйкырдуу", "эльф"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Elf"),
            keywords: &["Elf", "magesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເອວຟ\u{ecc}"),
            keywords: &["ວ\u{eb4}ເສດ", "ເອວຟ\u{ecc}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("elfas"),
            keywords: &["elfas", "magiškas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("elfs"),
            keywords: &["elfs", "maģisks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("erepe"),
            keywords: &["erepe", "mākutu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("шумски елф"),
            keywords: &["магично", "шумски елф"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ദ\u{d41}ർഭ\u{d42}തം"),
            keywords: &["ദ\u{d41}ർഭ\u{d42}തം", "മ\u{d3e}ന\u{d4d}ത\u{d4d}രികം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("одой хүн"),
            keywords: &["ид шидийн", "одой хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वनद\u{947}व"),
            keywords: &["चमत\u{94d}कारी", "वनद\u{947}व"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang halus"),
            keywords: &["ajaib", "orang halus"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għafrit"),
            keywords: &["għafrit", "maġiku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နတ\u{103a}သ\u{1030}ငယ\u{103a}"),
            keywords: &["နတ\u{103a}သ\u{1030}ငယ\u{103a}", "ပယောဂဆန\u{103a}သော"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("alv"),
            keywords: &["alv", "magi"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो मानव जस\u{94d}तो जीव"),
            keywords: &["जाद\u{941}मय", "सानो मानव जस\u{94d}तो जीव"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("elf"),
            keywords: &["elf", "magisch"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("alv"),
            keywords: &["alv", "magi"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅପ\u{b4d}ସର\u{b3e}"),
            keywords: &[
                "ଅପ\u{b4d}ସର\u{b3e}",
                "କ\u{b41}ହ\u{b41}କ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4c}ਣਾ"),
            keywords: &["ਜਾਦ\u{a42}ਈ", "ਬ\u{a4c}ਣਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}ھوت"),
            keywords: &["ب\u{64f}ھوت", "جادوئی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ẹlf"),
            keywords: &[
                "Bád Spírit",
                "Dẹ\u{301}vul",
                "Jujú",
                "Májik",
                "Sétan",
                "Ẹlf",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("elf"),
            keywords: &["elf", "magiczny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ګوړا"),
            keywords: &["جادويي", "ګوړا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("elfo"),
            keywords: &["elfo", "mágico"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["elfo", "mágico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("elfo"),
            keywords: &["elfo", "magico"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("elf"),
            keywords: &["elf", "magie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1134"),
            keywords: &["E10-1134"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("эльф"),
            keywords: &["магия", "сказка", "уши", "фэнтези", "эльф"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ishitani"),
            keywords: &["bitangaje", "ishitani"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بونا"),
            keywords: &["بونا", "جادو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එල\u{dca}ෆ\u{dca}"),
            keywords: &["ඉන\u{dca}ද\u{dca}රජ\u{dcf}ල\u{dd2}ක", "එල\u{dca}ෆ\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lesná bytosť"),
            keywords: &["fantasy", "lesná bytosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škrati"),
            keywords: &["vilin", "čarovnija", "škrati"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ruuxaan"),
            keywords: &["ruuxaan", "sixir ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("kukudh"),
            keywords: &["kukudh", "magjik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("виловњак"),
            keywords: &["виловњак", "магично"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vilovnjak"),
            keywords: &["magično", "vilovnjak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("alv"),
            keywords: &["alv", "magisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kibwengo"),
            keywords: &["kibwengo", "mazingaombwe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எல\u{bcd}ஃப\u{bcd}"),
            keywords: &[
                "எல\u{bcd}ஃப\u{bcd}",
                "கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}",
                "மந\u{bcd}திரவ\u{bbe}தம\u{bcd}",
                "ம\u{bbe}யக\u{bcd}கதை",
                "மேஜிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎల\u{c4d}ఫ\u{c4d}"),
            keywords: &["ఎల\u{c4d}ఫ\u{c4d}", "మ\u{c3e}ంత\u{c4d}ర\u{c3f}క"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пакана"),
            keywords: &["пакана", "соҳирӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอลฟ\u{e4c}"),
            keywords: &["จอมเวทย\u{e4c}", "เอลฟ\u{e4c}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elf"),
            keywords: &["elf", "jadyly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kiʻi feeli"),
            keywords: &["kiʻi feeli"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elf"),
            keywords: &["elf", "sihirli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پىر"),
            keywords: &["سېھرىي", "پىر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ельф"),
            keywords: &["ельф", "магічний"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پریت"),
            keywords: &["جادوئی", "پریت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("elf"),
            keywords: &["elf", "ertak", "quloq", "sehrli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("yêu ma"),
            keywords: &["phép thuật", "yêu ma"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("elfe"),
            keywords: &["elfe", "yéeme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uhili"),
            keywords: &["ubugqi", "uhili"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Egbére"),
            keywords: &["Egbére", "ìdán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("小精靈"),
            keywords: &["小精靈", "神奇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("小精灵"),
            keywords: &["小精灵", "神奇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小精灵"),
            keywords: &["小精灵", "魔术"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小精靈"),
            keywords: &["小精靈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("精靈"),
            keywords: &["精靈", "精靈｜魔法"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-elf"),
            keywords: &["i-elf", "mlingo"],
        },
    ],
};
#[doc = "🧝🏻"]
pub const ELF_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏻",
    codepoint: "1F9DD 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "elf: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧝🏼"]
pub const ELF_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏼",
    codepoint: "1F9DD 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "elf: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧝🏽"]
pub const ELF_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏽",
    codepoint: "1F9DD 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "elf: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧝🏾"]
pub const ELF_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏾",
    codepoint: "1F9DD 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "elf: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧝🏿"]
pub const ELF_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏿",
    codepoint: "1F9DD 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "elf: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧝\u{200d}♂\u{fe0f}"]
pub const MAN_ELF: crate::Emoji = crate::Emoji {
    glyph: "🧝\u{200d}♂\u{fe0f}",
    codepoint: "1F9DD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man elf",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝\u{200d}♂",
        codepoint: "1F9DD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man elf",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike elf"),
            keywords: &["manlike elf", "toweragtig"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ኤልፍ"),
            keywords: &["ወንድ ኤልፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جن\u{651}ي صغير ذكر"),
            keywords: &[
                "جن\u{651}ي صغير ذكر",
                "ذكر إلف",
                "ذكر إيلف",
                "كائن سحري",
                "مخلوق سحري",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ এল\u{9cd}ফ"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষ এল\u{9cd}ফ", "য\u{9be}দ\u{9c1}কৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi elf"),
            keywords: &["kişi elf", "sehrli"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-эльф"),
            keywords: &["казачны", "мужчына-эльф"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж елф"),
            keywords: &["вълшебен", "мъж елф"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ এল\u{9cd}ফ"),
            keywords: &["জ\u{9be}দ\u{9c1}করী", "প\u{9c1}র\u{9c1}ষ এল\u{9cd}ফ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("elf"),
            keywords: &["elf"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac patuljak"),
            keywords: &["magija", "muškarac patuljak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home elf"),
            keywords: &["home elf", "màgic", "màgica"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏴᏫ ᎢᏳᏍᏗ"),
            keywords: &["ᎠᏍᎦᏯ ᏴᏫ ᎢᏳᏍᏗ", "ᎤᏕᎵᏛ ᎬᏗ ᎠᏛᏁᎸᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("elf"),
            keywords: &["elf", "kouzelná", "les", "lesní", "magie", "muž", "postava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coblyn gwrwywaidd"),
            keywords: &["coblyn gwrwywaidd", "hudol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elvermand"),
            keywords: &["elvermand", "magi", "mand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Elf"),
            keywords: &["Alb", "Elbe", "Elf", "magisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας ξωτικό"),
            keywords: &["άντρας ξωτικό", "μαγικός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man elf"),
            keywords: &["magical", "man elf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("elfo hombre"),
            keywords: &["elfo", "elfo hombre", "mágico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meespäkapikk"),
            keywords: &["maagiline", "meespäkapikk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon elfo"),
            keywords: &["gizon elfo", "magiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ا\u{650}لف مرد"),
            keywords: &["ا\u{650}لف مرد", "جادویی", "سحرآمیز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mieshaltia"),
            keywords: &[
                "Legolas",
                "alf",
                "haltia",
                "keiju",
                "mieshaltia",
                "suippokorva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking duwende"),
            keywords: &["lalaking duwende", "mahiwaga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannfólka álvur"),
            keywords: &["mannfólka álvur", "maður", "álvur", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("elfe homme"),
            keywords: &["elfe homme", "magique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["elfe", "homme", "magique"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("síofra fireann"),
            keywords: &["draíochtúil", "síofra fireann", "síogaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("ailbhear fireann"),
            keywords: &["ailbhear fireann", "draoidheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("elfo de sexo masculino"),
            keywords: &["elfo", "elfo de sexo masculino"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ ઈલ\u{acd}ફ"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ ઈલ\u{acd}ફ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jinsiri namiji"),
            keywords: &["abin dabo", "jinsiri namiji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אלף בן"),
            keywords: &["אלף בן", "יצור קסום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जाद\u{941}ई प\u{941}र\u{941}ष"),
            keywords: &["जाद\u{941}ई", "जाद\u{941}ई प\u{941}र\u{941}ष"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vilenjak"),
            keywords: &["magično", "vilenjak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi tünde"),
            keywords: &["férfi tünde", "mágikus"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ-էլֆ"),
            keywords: &["կախարդական", "հեքիաթ", "տղամարդ-էլֆ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kurcaci pria"),
            keywords: &["ajaib", "kurcaci pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke elfụ"),
            keywords: &["nwoke elfụ", "àbràkàtabrà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("huldukarl"),
            keywords: &["huldukarl"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("elfo uomo"),
            keywords: &["elfo uomo", "magico"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男のエルフ"),
            keywords: &["エルフ", "男", "男のエルフ", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peri lanang"),
            keywords: &["ajaib", "peri lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი ელფი"),
            keywords: &["ზღაპარი", "კაცი ელფი", "მაგიური", "ჯადოსნული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер ергежейлі"),
            keywords: &["ер ергежейлі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អែលហ\u{17d2}វប\u{17d2}រ\u{17bb}ស"),
            keywords: &["ដែលចេះវេទមន\u{17d2}ត", "អែលហ\u{17d2}វប\u{17d2}រ\u{17bb}ស"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಯಕ\u{ccd}ಷ"),
            keywords: &["ಪುರುಷ ಯಕ\u{ccd}ಷ", "ಮಾಂತ\u{ccd}ರ\u{cbf}ಕ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 엘프"),
            keywords: &["남자 엘프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वनद\u{947}व"),
            keywords: &["जाद\u{941}ई", "वनद\u{947}व"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек эльф"),
            keywords: &["сыйкырдуу", "эркек эльф"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Elfemann"),
            keywords: &["Elfemann", "magesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເອວຟ\u{ecc}ຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &["ວ\u{eb4}ເສດ", "ເອວຟ\u{ecc}ຜ\u{eb9}\u{ec9}ຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("elfas vyras"),
            keywords: &["elfas vyras", "magiškas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("elfu vīrietis"),
            keywords: &["elfu vīrietis", "maģisks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("erepe tāne"),
            keywords: &["erepe tāne", "mākutu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж шумски елф"),
            keywords: &["магично", "маж шумски елф"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആൺ ദ\u{d41}ർഭ\u{d42}തം"),
            keywords: &["ആൺ ദ\u{d41}ർഭ\u{d42}തം", "മ\u{d3e}ന\u{d4d}ത\u{d4d}രികം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй одой"),
            keywords: &["ид шидийн", "эрэгтэй одой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वनद\u{947}वता"),
            keywords: &["चमत\u{94d}कारी", "वनद\u{947}वता"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang halus lelaki"),
            keywords: &["ajaib", "orang halus lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għafrit raġel"),
            keywords: &["għafrit raġel", "maġiku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား နတ\u{103a}သ\u{1030}ငယ\u{103a}"),
            keywords: &[
                "ပယောဂဆန\u{103a}သော",
                "အမျ\u{102d}\u{102f}းသား နတ\u{103a}သ\u{1030}ငယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig alv"),
            keywords: &["magi", "mannlig alv"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो छोरोमान\u{94d}छ\u{947}को स\u{94d}वर\u{941}प भएको जीव"),
            keywords: &[
                "जाद\u{941}मय",
                "सानो छोरोमान\u{94d}छ\u{947}को स\u{94d}वर\u{941}प भएको जीव",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke elf"),
            keywords: &["magisch", "mannelijke elf"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg alv"),
            keywords: &["magi", "mannleg alv"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ଏଲଫ\u{b4d}\u{200d}"),
            keywords: &[
                "କ\u{b41}ହ\u{b41}କ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ",
                "ପ\u{b41}ର\u{b41}ଷ ଏଲଫ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4c}ਣਾ ਆਦਮੀ"),
            keywords: &["ਜਾਦ\u{a42}ਈ", "ਬ\u{a4c}ਣਾ ਆਦਮੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}ھوت بندا"),
            keywords: &["ب\u{64f}ھوت بندا", "جادوئی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Ẹlf"),
            keywords: &["Májik", "Mán Ẹlf"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna elf"),
            keywords: &["magiczny", "mężczyzna elf"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی ګوړا"),
            keywords: &["جادويي", "سړی ګوړا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("elfo homem"),
            keywords: &["duende homem", "elfo", "elfo homem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("elfo (homem)"),
            keywords: &["elfo (homem)", "mágico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata elfo"),
            keywords: &["magico", "tata elfo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat elf"),
            keywords: &["bărbat elf", "magie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1259"),
            keywords: &["E10-1259"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-эльф"),
            keywords: &[
                "магия",
                "мужчина",
                "мужчина-эльф",
                "сказка",
                "уши",
                "фэнтези",
                "эльф",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ishitanigabo"),
            keywords: &["bitangaje", "ishitanigabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد بونا"),
            keywords: &["جادو", "مرد بونا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} එල\u{dca}ෆ\u{dca}"),
            keywords: &[
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} එල\u{dca}ෆ\u{dca}",
                "ම\u{dcf}ය\u{dcf}ව\u{dd3}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("elf"),
            keywords: &["elf", "fantasy"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škrat"),
            keywords: &["vilin", "čarovnija", "škrat"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ruuxaanta ragga"),
            keywords: &["ruuxaanta ragga", "sixir ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë kukudh"),
            keywords: &["burrë kukudh", "magjik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац виловњак"),
            keywords: &["магичан мушкарац", "мушкарац виловњак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac vilovnjak"),
            keywords: &["magičan muškarac", "muškarac vilovnjak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig alv"),
            keywords: &["magisk", "manlig alv"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kibwengo dume"),
            keywords: &["kibwengo dume", "mazingaombwe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} எல\u{bcd}ஃப\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd} எல\u{bcd}ஃப\u{bcd}",
                "கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}",
                "மந\u{bcd}திரவ\u{bbe}தம\u{bcd}",
                "ம\u{bbe}யக\u{bcd}கதை",
                "மேஜிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు"),
            keywords: &[
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}క",
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుడు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди пакана"),
            keywords: &["марди пакана", "соҳирӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอลฟ\u{e4c}ผ\u{e39}\u{e49}ชาย"),
            keywords: &["จอมเวทย\u{e4c}", "เอลฟ\u{e4c}ผ\u{e39}\u{e49}ชาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek elf"),
            keywords: &["erkek elf", "jadyly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kiʻi feeli tangata"),
            keywords: &["kiʻi feeli tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek elf"),
            keywords: &["erkek elf", "sihirli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر پىر"),
            keywords: &["ئەر پىر", "سېھرىي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-ельф"),
            keywords: &["чарівний", "чоловік-ельф"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پریت آدمی"),
            keywords: &["جادوئی", "پریت آدمی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak elf"),
            keywords: &["erkak", "erkak elf", "ertak", "quloq", "sehrli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nam quỷ"),
            keywords: &["nam quỷ", "phép thuật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("elfe bu góor"),
            keywords: &["elfe bu góor", "yéeme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uhili oyindoda"),
            keywords: &["ubugqi", "uhili oyindoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("egbére ọkùnrin"),
            keywords: &["egbére ọkùnrin", "ìdán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男精靈"),
            keywords: &["男精靈", "神奇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男精灵"),
            keywords: &["男精灵", "神奇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男小精灵"),
            keywords: &["男小精灵", "男性魔术"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男精靈"),
            keywords: &["男精靈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["男精靈", "男精靈｜魔法"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-elf yesilisa"),
            keywords: &["i-elf yesilisa", "mlingo"],
        },
    ],
};
#[doc = "🧝🏻\u{200d}♂\u{fe0f}"]
pub const MAN_ELF_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9DD 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man elf: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏻\u{200d}♂",
        codepoint: "1F9DD 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man elf: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏼\u{200d}♂\u{fe0f}"]
pub const MAN_ELF_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9DD 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man elf: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏼\u{200d}♂",
        codepoint: "1F9DD 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man elf: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏽\u{200d}♂\u{fe0f}"]
pub const MAN_ELF_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9DD 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man elf: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏽\u{200d}♂",
        codepoint: "1F9DD 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man elf: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏾\u{200d}♂\u{fe0f}"]
pub const MAN_ELF_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9DD 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man elf: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏾\u{200d}♂",
        codepoint: "1F9DD 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man elf: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏿\u{200d}♂\u{fe0f}"]
pub const MAN_ELF_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9DD 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man elf: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏿\u{200d}♂",
        codepoint: "1F9DD 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man elf: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝\u{200d}♀\u{fe0f}"]
pub const WOMAN_ELF: crate::Emoji = crate::Emoji {
    glyph: "🧝\u{200d}♀\u{fe0f}",
    codepoint: "1F9DD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman elf",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝\u{200d}♀",
        codepoint: "1F9DD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman elf",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike elf"),
            keywords: &["toweragtig", "vroulike elf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ኤልፍ"),
            keywords: &["ሴት ኤልፍ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("جني\u{651}ة صغيرة"),
            keywords: &[
                "أنثى إلف",
                "أنثى إيلف",
                "جني\u{651}ة صغيرة",
                "كائن سحري",
                "مخلوقة سحرية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} এল\u{9cd}ফ"),
            keywords: &["মহিল\u{9be} এল\u{9cd}ফ", "য\u{9be}দ\u{9c1}কৰী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın elf"),
            keywords: &["qadın elf", "sehrli"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("эльфійка"),
            keywords: &["казачная", "эльфійка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена елф"),
            keywords: &["вълшебен", "жена елф"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} এল\u{9cd}ফ"),
            keywords: &["জ\u{9be}দ\u{9c1}করী", "মহিল\u{9be} এল\u{9cd}ফ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("elfez"),
            keywords: &["elfez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena patuljak"),
            keywords: &["magija", "žena patuljak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona elfa"),
            keywords: &["dona elfa", "màgic", "màgica"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏴᏫ ᎢᏳᏍᏗ"),
            keywords: &["ᎠᎨᏯ ᏴᏫ ᎢᏳᏍᏗ", "ᎤᏕᎵᏛ ᎬᏗ ᎠᏛᏁᎸᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("elfka"),
            keywords: &["divoženka", "elfka", "kouzelná", "les", "magie", "postava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coblyn benywaidd"),
            keywords: &["coblyn benywaidd", "hudol"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elverkvinde"),
            keywords: &["elverkvinde", "kvinde", "magi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Elfe"),
            keywords: &["Elbin", "Elfe", "magisch"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα ξωτικό"),
            keywords: &["γυναίκα ξωτικό", "μαγική"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman elf"),
            keywords: &["magical", "woman elf"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("elfa"),
            keywords: &["elfa", "mujer", "mágico"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naispäkapikk"),
            keywords: &["maagiline", "naispäkapikk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume elfo"),
            keywords: &["emakume elfo", "magiko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ا\u{650}لف زن"),
            keywords: &["ا\u{650}لف زن", "جادویی", "سحرآمیز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("haltiatar"),
            keywords: &[
                "Galadriel",
                "alf",
                "haltia",
                "haltiatar",
                "keiju",
                "suippokorva",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng duwende"),
            keywords: &["babaeng duwende", "mahiwaga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("konufólka álva"),
            keywords: &["konufólka álva", "maður", "álva", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("elfe femme"),
            keywords: &["elfe femme", "magique"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["elfe", "femme", "magique"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("síofra baineann"),
            keywords: &["draíochtúil", "síofra baineann", "síofróg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bean-ailbhear"),
            keywords: &["bean-ailbhear", "draoidheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("elfo de sexo feminino"),
            keywords: &["elfa", "elfo de sexo feminino"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ઈલ\u{acd}ફ"),
            keywords: &["સ\u{acd}ત\u{acd}રી ઈલ\u{acd}ફ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jinsiri na mace"),
            keywords: &["abin dabo", "jinsiri na mace"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אלפית"),
            keywords: &["אלפית", "יצור קסום"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जाद\u{941}ई स\u{94d}त\u{94d}री"),
            keywords: &["जाद\u{941}ई", "जाद\u{941}ई स\u{94d}त\u{94d}री"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vilenjakinja"),
            keywords: &["magično", "vilenjakinja"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női tünde"),
            keywords: &["mágikus", "női tünde"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին-էլֆ"),
            keywords: &["կախարդական", "կախարդանք", "կին-էլֆ", "հեքիաթ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("kurcaci wanita"),
            keywords: &["ajaib", "kurcaci wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị elfụ"),
            keywords: &["nwanyị elfụ", "àbràkàtabrà"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("huldukona"),
            keywords: &["huldukona"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("elfo donna"),
            keywords: &["elfo donna", "magico"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女のエルフ"),
            keywords: &["エルフ", "女", "女のエルフ", "女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("peri wadon"),
            keywords: &["ajaib", "peri wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი ელფი"),
            keywords: &["ზღაპარი", "მაგიური", "ქალი ელფი", "ჯადოსნული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел ергежейлі"),
            keywords: &["әйел ергежейлі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អែលហ\u{17d2}វស\u{17d2}រ\u{17b8}"),
            keywords: &["ដែលចេះវេទមន\u{17d2}ត", "អែលហ\u{17d2}វស\u{17d2}រ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ಯಕ\u{ccd}ಷ\u{cbf}ಣ\u{cbf}"),
            keywords: &[
                "ಮಹ\u{cbf}ಳ\u{cc6} ಯಕ\u{ccd}ಷ\u{cbf}ಣ\u{cbf}",
                "ಮಾಂತ\u{ccd}ರ\u{cbf}ಕ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 엘프"),
            keywords: &["여자 엘프"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("वन द\u{947}वी"),
            keywords: &["जाद\u{941}ई", "वन द\u{947}वी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял эльф"),
            keywords: &["аял эльф", "кереметтүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Elfefra"),
            keywords: &["Elfefra", "magesch"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເອວຟ\u{ecc}ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ"),
            keywords: &["ວ\u{eb4}ເສດ", "ເອວຟ\u{ecc}ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("elfė"),
            keywords: &["elfė", "magiška"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("elfa"),
            keywords: &["elfa", "maģiska"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("erepe wahine"),
            keywords: &["erepe wahine", "mākutu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена шумски елф"),
            keywords: &["жена шумски елф", "магично"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെൺ ദ\u{d41}ർഭ\u{d42}തം"),
            keywords: &["പെൺ ദ\u{d41}ർഭ\u{d42}തം", "മ\u{d3e}ന\u{d4d}ത\u{d4d}രികം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй одой"),
            keywords: &["ид шидийн", "эмэгтэй одой"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वनद\u{947}वी"),
            keywords: &["चमत\u{94d}कारी", "वनद\u{947}वी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang halus wanita"),
            keywords: &["ajaib", "orang halus wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għafrit mara"),
            keywords: &["għafrit mara", "maġiku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း နတ\u{103a}သ\u{1030}ငယ\u{103a}"),
            keywords: &[
                "ပယောဂဆန\u{103a}သော",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း နတ\u{103a}သ\u{1030}ငယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig alv"),
            keywords: &["kvinnelig alv", "magi"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सानो छोरीमान\u{94d}छ\u{947}को स\u{94d}वर\u{941}प भएको जीव"),
            keywords: &[
                "जाद\u{941}मय",
                "सानो छोरीमान\u{94d}छ\u{947}को स\u{94d}वर\u{941}प भएको जीव",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke elf"),
            keywords: &["magisch", "vrouwelijke elf"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg alv"),
            keywords: &["kvinneleg alv", "magi"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ଅପ\u{b4d}ସର\u{b3e}"),
            keywords: &[
                "କ\u{b41}ହ\u{b41}କ ସମ\u{b4d}ବନ\u{b4d}ଧୀୟ",
                "ମହ\u{b3f}ଳ\u{b3e} ଅପ\u{b4d}ସର\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a4c}ਣੀ"),
            keywords: &["ਜਾਦ\u{a42}ਈ", "ਬ\u{a4c}ਣੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}ھوت زنانی"),
            keywords: &["ب\u{64f}ھوت زنانی", "جادوئی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Ẹlf"),
            keywords: &["Májik", "Wúmán Ẹlf"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta elf"),
            keywords: &["kobieta elf", "magiczny"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه ګوړا"),
            keywords: &["جادويي", "ښځه ګوړا"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("elfa"),
            keywords: &["duende mulher", "elfa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("elfo (mulher)"),
            keywords: &["elfo (mulher)", "mágico"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi elfo"),
            keywords: &["magico", "warmi elfo"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie elf"),
            keywords: &["elfă", "femeie elf", "magie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1258"),
            keywords: &["E10-1258"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-эльф"),
            keywords: &["женщина-эльф", "магия", "фэнтези", "эльф", "эльфийка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ishitanikazi"),
            keywords: &["bitangaje", "ishitanikazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت بونا"),
            keywords: &["جادو", "عورت بونا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගෑන\u{dd4} එල\u{dca}ෆ\u{dca}"),
            keywords: &[
                "ඉන\u{dca}ද\u{dca}රජ\u{dcf}ල\u{dd2}ක",
                "ගෑන\u{dd4} එල\u{dca}ෆ\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("elfka"),
            keywords: &["elfka", "fantasy"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("škratovka"),
            keywords: &["vilinka", "škratovka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ruuxaanta haweenka"),
            keywords: &["ruuxaanta haweenka", "sixir ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua kukudh"),
            keywords: &["grua kukudh", "magjik"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена виловњак"),
            keywords: &["жена виловњак", "магична жена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena vilovnjak"),
            keywords: &["magična žena", "žena vilovnjak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig alv"),
            keywords: &["kvinnlig alv", "magisk"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kibwengo cha kike"),
            keywords: &["kibwengo cha kike", "kibwengo wa kike", "mazingaombwe"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} எல\u{bcd}ஃப\u{bcd}"),
            keywords: &[
                "கற\u{bcd}பனைக\u{bcd} கத\u{bbe}ப\u{bbe}த\u{bcd}திரம\u{bcd}",
                "பெண\u{bcd} எல\u{bcd}ஃப\u{bcd}",
                "மந\u{bcd}திரவ\u{bbe}தம\u{bcd}",
                "ம\u{bbe}யக\u{bcd}கதை",
                "மேஜிக\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుర\u{c3e}లు"),
            keywords: &[
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}క",
                "మ\u{c3e}ంత\u{c4d}ర\u{c3f}కుర\u{c3e}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани пакана"),
            keywords: &["зани пакана", "соҳирӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เอลฟ\u{e4c}ผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &["จอมเวทย\u{e4c}", "เอลฟ\u{e4c}ผ\u{e39}\u{e49}หญ\u{e34}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal elf"),
            keywords: &["aýal elf", "jadyly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kiʻi feeli fefine"),
            keywords: &["kiʻi feeli fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın elf"),
            keywords: &["kadın elf", "sihirli"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال پىر"),
            keywords: &["ئايال پىر", "سېھرىي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-ельф"),
            keywords: &["жінка-ельф", "чарівна"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پریت عورت"),
            keywords: &["جادوئی", "پریت عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol elf"),
            keywords: &["ayol", "ayol elf", "ertak", "quloq", "sehrli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nữ quỷ"),
            keywords: &["nữ quỷ", "phép thuật"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("elfe bu jigéen"),
            keywords: &["elfe bu jigéen", "yéeme"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uhili olibhinqa"),
            keywords: &["ubugqi", "uhili olibhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("egbére obìnrin"),
            keywords: &["egbére obìnrin", "ìdán"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女精靈"),
            keywords: &["女精靈", "神奇"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女精灵"),
            keywords: &["女精灵", "神奇"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女小精灵"),
            keywords: &["女小精灵", "女性魔术"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女精靈"),
            keywords: &["女精靈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["女精靈", "女精靈｜魔法"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-elf yesifazane"),
            keywords: &["i-elf yesifazane", "okomlingo"],
        },
    ],
};
#[doc = "🧝🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_ELF_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9DD 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman elf: light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏻\u{200d}♀",
        codepoint: "1F9DD 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman elf: light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_ELF_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9DD 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman elf: medium-light skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏼\u{200d}♀",
        codepoint: "1F9DD 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman elf: medium-light skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_ELF_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9DD 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman elf: medium skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏽\u{200d}♀",
        codepoint: "1F9DD 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman elf: medium skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_ELF_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9DD 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman elf: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏾\u{200d}♀",
        codepoint: "1F9DD 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman elf: medium-dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧝🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_ELF_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧝🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9DD 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman elf: dark skin tone",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧝🏿\u{200d}♀",
        codepoint: "1F9DD 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman elf: dark skin tone",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧞"]
pub const GENIE: crate::Emoji = crate::Emoji {
    glyph: "🧞",
    codepoint: "1F9DE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "genie",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("towergees"),
            keywords: &["djinn", "towergees"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጅኒ"),
            keywords: &["ጅኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مارد سحري"),
            keywords: &["مارد سحري"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জিন"),
            keywords: &["জিন", "প\u{9cd}ৰেত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("cin"),
            keywords: &["cin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("джын"),
            keywords: &["джын"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("женски джин"),
            keywords: &["джин", "дух", "женски джин"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জীনি"),
            keywords: &["জীনি", "জ\u{9cd}বীন জ\u{9be}তি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("duh iz boce"),
            keywords: &["duh iz boce", "džin"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("geni"),
            keywords: &["geni"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏥᎾᏱ"),
            keywords: &["ᏥᎾᏱ", "ᏥᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("duch z lahve"),
            keywords: &["aladin", "duch", "duch z lahve", "džin", "lahev", "lampa"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("genie"),
            keywords: &["djinn", "genie"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("magisk ånd"),
            keywords: &["lampe", "magi", "magisk ånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Flaschengeist"),
            keywords: &["Dschinn", "Flaschengeist"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τζίνι"),
            keywords: &["τζίνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("genie"),
            keywords: &["djinn", "genie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("genio"),
            keywords: &["genio", "lámpara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("džinn"),
            keywords: &["džinn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("iratxo"),
            keywords: &["djinn", "iratxo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("جن"),
            keywords: &["جن", "غول چراغ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("henki"),
            keywords: &["genius", "henki", "jinni", "juno", "lamppu"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("genie"),
            keywords: &["djinn", "genie"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("andi"),
            keywords: &["andi", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("génie"),
            keywords: &["djinn", "génie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ginid"),
            keywords: &["ginid", "sióg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taibhse Arabach"),
            keywords: &["djinn", "genie", "taibhse", "taibhse Arabach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xenio"),
            keywords: &["desexos", "xenio"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જીની"),
            keywords: &["જીની"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljanin larabawa"),
            keywords: &["aljani", "aljanin larabawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שד"),
            keywords: &["אשמדאי", "ג׳יני", "שד", "שדון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जिन\u{94d}न"),
            keywords: &["जिनी", "जिन\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("džin"),
            keywords: &["duh", "džin"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("dzsinn"),
            keywords: &["dzsinn"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ջին"),
            keywords: &["հեքիաթ", "ջին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jin"),
            keywords: &["jin"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa mmegbu"),
            keywords: &["mmụọ siri ike", "nwa mmegbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("andi"),
            keywords: &["andi", "djinn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("genio"),
            keywords: &["djinn", "genio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("精霊"),
            keywords: &["精霊", "魔神"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bangsa jim"),
            keywords: &["bangsa jim", "jin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჯინი"),
            keywords: &["ლამპარი", "ჯინი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жын"),
            keywords: &["жын"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17b8}ន\u{17b8}"),
            keywords: &["ជ\u{17b8}ន", "ជ\u{17b8}ន\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜ\u{cbf}ನೀ"),
            keywords: &["ಜ\u{cbf}ಂಜನ\u{ccd}", "ಜ\u{cbf}ನೀ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("지니"),
            keywords: &["정령", "지니"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जिनी"),
            keywords: &["जिनी", "जीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жин"),
            keywords: &["жин"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Genie"),
            keywords: &["Djinn", "Genie"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb4}ນ\u{eb5}\u{ec8}"),
            keywords: &["ຈ\u{eb4}ນ\u{eb5}\u{ec8}", "ດ\u{eb5}ຈ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dvasia"),
            keywords: &["dvasia", "džinas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("džins"),
            keywords: &["burvis", "džins"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūrehu"),
            keywords: &["djinn", "tūrehu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("џини"),
            keywords: &["џин", "џини"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ജിന\u{d4d}ന\u{d4d}"),
            keywords: &["ജിന\u{d4d}ന\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("жини"),
            keywords: &["Жин", "жини"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जिनी"),
            keywords: &["जिनी", "जिन\u{94d}न"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jin"),
            keywords: &["jin"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġenju"),
            keywords: &["djinn", "ġenju"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a}ဘ\u{102e}လ\u{1030}း"),
            keywords: &[
                "မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a} နတ\u{103a}ဘ\u{102e}လ\u{1030}းတစ\u{103a}မျ\u{102d}\u{102f}း",
                "မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a}ဘ\u{102e}လ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ånd"),
            keywords: &["djinn", "ånd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अलौ\u{902}किक शक\u{94d}ति"),
            keywords: &["अलौ\u{902}किक शक\u{94d}ति", "जिन"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("geest in de fles"),
            keywords: &["djinn", "geest in de fles"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ånd"),
            keywords: &["djinn", "ånd"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3f}ନ\u{b3f}"),
            keywords: &["ଜ\u{b3f}ନ\u{b3f}", "ଜ\u{b3f}ନ\u{b4d}ନ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਿ\u{a70}ਨ"),
            keywords: &["ਜਿਨੀ", "ਜਿ\u{a70}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جن"),
            keywords: &["جن", "ل\u{64f}کی ہوئی مخلوق"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Jiínii"),
            keywords: &[
                "Bád Spírit Wé Im Nem Na Jiínii",
                "Bád Spírit Wé Im Nem Na Jíin",
                "Jiínii",
                "Jíin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dżin"),
            keywords: &["dżin"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("جینی"),
            keywords: &["جين", "جینی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gênio"),
            keywords: &["gênio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("génio"),
            keywords: &["djinn", "génio"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("genio lamparamanta"),
            keywords: &["genio", "genio lamparamanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("duh"),
            keywords: &["djinn", "duh"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1135"),
            keywords: &["E10-1135"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("джинн"),
            keywords: &["джинн", "лампа", "потереть", "сказка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igini"),
            keywords: &["igini", "ijini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("جن"),
            keywords: &["جن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බහ\u{dd2}රවය\u{dcf}"),
            keywords: &["ජ\u{dd2}න\u{dca}", "බහ\u{dd2}රවය\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("džin"),
            keywords: &["džin", "fľaša", "lampa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("duh iz steklenice"),
            keywords: &["duh iz steklenice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jinka"),
            keywords: &["jinka", "sixirka jinka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("xhind"),
            keywords: &["xhind"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("добри дух"),
            keywords: &["добри дух", "џин"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dobri duh"),
            keywords: &["dobri duh", "džin"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ande"),
            keywords: &["ande", "djinn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jini"),
            keywords: &["jini", "pepo jini"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜ\u{bc0}னி"),
            keywords: &["ஜ\u{bc0}னி", "டிஜின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3f}న\u{c40}"),
            keywords: &["జ\u{c3f}న\u{c40}", "జ\u{c3f}న\u{c4d}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҷин"),
            keywords: &["ҷин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e31}กษ\u{e4c}จ\u{e35}น\u{e35}\u{e48}"),
            keywords: &[
                "ย\u{e31}กษ\u{e4c}จ\u{e34}นน\u{e35}\u{e48}",
                "ย\u{e31}กษ\u{e4c}จ\u{e35}น\u{e35}\u{e48}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jyn-arwah"),
            keywords: &["jyn", "jyn-arwah"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faʻahikehe"),
            keywords: &["faʻahikehe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("cin"),
            keywords: &["cin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("شاياتۇن"),
            keywords: &["جىن", "شاياتۇن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("джин"),
            keywords: &["джин"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("جن"),
            keywords: &["جن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("jin"),
            keywords: &["afsun", "chiroq", "ertak", "jin"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("thần"),
            keywords: &["ma thần", "thần"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jinne"),
            keywords: &["jinne"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("i-genie"),
            keywords: &["i-djinn", "i-genie"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ànjọ\u{300}nnú"),
            keywords: &["Ànjọ\u{300}nnú", "Ànjọ\u{300}nnú arabia"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("神燈精靈"),
            keywords: &["巨靈", "神燈精靈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("神灯精灵"),
            keywords: &["巨灵", "神灯精灵"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("妖怪"),
            keywords: &["妖怪", "神灵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("精靈"),
            keywords: &["精靈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("燈神"),
            keywords: &["燈神", "精靈｜燈神"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijeni"),
            keywords: &["i-djinn", "ijeni"],
        },
    ],
};
#[doc = "🧞\u{200d}♂\u{fe0f}"]
pub const MAN_GENIE: crate::Emoji = crate::Emoji {
    glyph: "🧞\u{200d}♂\u{fe0f}",
    codepoint: "1F9DE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man genie",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧞\u{200d}♂",
        codepoint: "1F9DE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man genie",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike towergees"),
            keywords: &["djinn", "manlike towergees"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ጅኒ"),
            keywords: &["ወንድ ጅኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مارد"),
            keywords: &["مارد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষৰ আত\u{9cd}ম\u{9be}"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষৰ আত\u{9cd}ম\u{9be}", "প\u{9cd}ৰেত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi cin"),
            keywords: &["cin", "kişi cin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-джын"),
            keywords: &["джын", "мужчына-джын"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж джин"),
            keywords: &["джин", "мъж джин"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ জীনি"),
            keywords: &["জ\u{9cd}বীন জ\u{9be}তি", "প\u{9c1}র\u{9c1}ষ জীনি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac duh iz boce"),
            keywords: &["džin", "muškarac duh iz boce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home geni"),
            keywords: &["geni", "home geni"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᏥᎾᏱ"),
            keywords: &["ᎠᏍᎦᏯ ᏥᎾᏱ", "ᏥᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("džin"),
            keywords: &["aladin", "duch", "džin", "lahev", "lampa", "muž"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("genie gwrywaidd"),
            keywords: &["djinn", "genie gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig magisk ånd"),
            keywords: &["magi", "mand", "mandlig magisk ånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("männlicher Flaschengeist"),
            keywords: &["Dschinn", "männlicher Flaschengeist"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας τζίνι"),
            keywords: &["άντρας τζίνι", "τζίνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man genie"),
            keywords: &["djinn", "man genie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("genio hombre"),
            keywords: &["djinn", "genio", "genio hombre", "lámpara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meesdžinn"),
            keywords: &["džinn", "meesdžinn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon iratxo"),
            keywords: &["djinn", "gizon iratxo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد جن"),
            keywords: &["جن", "جن مرد", "غول چراغ", "مرد جن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mieshenki"),
            keywords: &["genius", "henki", "jinni", "lamppu", "mieshenki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking genie"),
            keywords: &["djinn", "lalaking genie"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur andi"),
            keywords: &["andi", "mannligur andi", "maður", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("génie homme"),
            keywords: &["djinn", "génie homme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["djinn", "génie", "homme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ginid fhireann"),
            keywords: &["fearann", "ginid", "ginid fhireann", "sióg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taibhse fhireann"),
            keywords: &["djinn", "genie", "taibhse", "taibhse fhireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xenio de sexo masculino"),
            keywords: &["desexos", "xenio", "xenio de sexo masculino"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ જીની"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ જીની"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljanin larabawa namiji"),
            keywords: &["aljani", "aljanin larabawa namiji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("דמון"),
            keywords: &["אשמדאי", "ג׳יני", "דמון", "שד", "שדון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष जिन\u{94d}न"),
            keywords: &["जिन\u{94d}न", "प\u{941}र\u{941}ष जिन\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muški džin"),
            keywords: &["duh", "muški džin"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi dzsinn"),
            keywords: &["dzsinn", "férfi dzsinn"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ ջին"),
            keywords: &["հեքիաթ", "ջին", "տղամարդ ջին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jin pria"),
            keywords: &["jin", "jin pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke mmegbu"),
            keywords: &["mmụọ siri ike", "nwoke mmegbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns andi"),
            keywords: &["djinn", "karlkyns andi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("genio uomo"),
            keywords: &["djinn", "genio uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男の精霊"),
            keywords: &["男", "男の精霊", "男性", "精霊", "魔神"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jim lanang"),
            keywords: &["jim lanang", "jin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი ჯინი"),
            keywords: &["კაცი ჯინი", "ლამპარი", "ჯინი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер жын"),
            keywords: &["ер жын"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17b8}ន\u{17b8}ប\u{17d2}រ\u{17bb}ស"),
            keywords: &["ជ\u{17b8}ន", "ជ\u{17b8}ន\u{17b8}ប\u{17d2}រ\u{17bb}ស"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಜ\u{cbf}ನೀ"),
            keywords: &["ಜ\u{cbf}ನೀ", "ಪುರುಷ ಜ\u{cbf}ನೀ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 지니"),
            keywords: &["남자 지니", "정령"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो जीन"),
            keywords: &["जीन", "दादलो जिनी", "दादलो जीन"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек жин"),
            keywords: &["жин", "эркек жин"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Geniemann"),
            keywords: &["Djinn", "Geniemann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb4}ນ\u{eb5}\u{ec8}ຊາຍ"),
            keywords: &["ຈ\u{eb4}ນ\u{eb5}\u{ec8}ຊາຍ", "ດ\u{eb5}ຈ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("džinas"),
            keywords: &["džinas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis džins"),
            keywords: &["burvis", "džins", "vīrietis džins"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tūrehu"),
            keywords: &["djinn", "tāne tūrehu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж џини"),
            keywords: &["маж џини", "џин"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആൺ ജിന\u{d4d}ന\u{d4d}"),
            keywords: &["ആൺ ജിന\u{d4d}ന\u{d4d}", "ജിന\u{d4d}ന\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй жини"),
            keywords: &["жинь", "эрэгтэй жини"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष जिनी"),
            keywords: &["जिन\u{94d}न", "प\u{941}र\u{942}ष जिनी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jin jantan"),
            keywords: &["jin", "jin jantan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġenju raġel"),
            keywords: &["djinn", "ġenju raġel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသား မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a}ဘ\u{102e}းလ\u{1030}း",
            ),
            keywords: &[
                "မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a} နတ\u{103a}ဘ\u{102e}လ\u{1030}းတစ\u{103a}မျ\u{102d}\u{102f}း",
                "အမျ\u{102d}\u{102f}းသား မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a}ဘ\u{102e}းလ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig ånd"),
            keywords: &["djinn", "mannlig ånd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अलौ\u{902}किक शक\u{94d}ति भएको छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "अलौ\u{902}किक शक\u{94d}ति भएको छोरामान\u{94d}छ\u{947}",
                "जिन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke geest in de fles"),
            keywords: &["djinn", "mannelijke geest in de fles"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg ånd"),
            keywords: &["djinn", "mannleg ånd"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ଜ\u{b3f}ନ\u{b3f}"),
            keywords: &["ଜ\u{b3f}ନ\u{b4d}ନ", "ପ\u{b41}ର\u{b41}ଷ ଜ\u{b3f}ନ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਜਿ\u{a70}ਨ"),
            keywords: &["ਜਿਨੀ", "ਪ\u{a41}ਰਸ\u{a3c} ਜਿ\u{a70}ਨ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("مرد جن"),
            keywords: &["ل\u{64f}کی ہوئی مخلوق", "مرد جن"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Jiínii"),
            keywords: &["Bád Spírit", "Jíin", "Mán Jiínii"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna dżin"),
            keywords: &["dżin", "mężczyzna dżin"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی جینی"),
            keywords: &["جين", "سړی جینی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem gênio"),
            keywords: &["homem gênio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("génio (homem)"),
            keywords: &["djinn", "génio (homem)"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata genio lamparamanta"),
            keywords: &["genio", "tata genio lamparamanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat duh"),
            keywords: &["bărbat duh", "djinn"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1261"),
            keywords: &["E10-1261"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-джинн"),
            keywords: &[
                "джинн",
                "лампа",
                "мужчина",
                "мужчина-джинн",
                "потереть",
                "сказка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("iginigabo"),
            keywords: &["iginigabo", "ijini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد جن"),
            keywords: &["جن", "مرد جن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} බහ\u{dd2}රවය\u{dcf}"),
            keywords: &[
                "ජ\u{dd2}න\u{dca}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} බහ\u{dd2}රවය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mužský džin"),
            keywords: &["džin", "fľaša", "lampa", "mužský džin"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški duh iz steklenice"),
            keywords: &["moški duh iz steklenice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jinka ragga"),
            keywords: &["jinka", "jinka ragga"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë xhind"),
            keywords: &["burrë xhind", "xhind"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушки добри дух"),
            keywords: &["мушки добри дух", "мушки џин"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muški dobri duh"),
            keywords: &["muški dobri duh", "muški džin"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig ande"),
            keywords: &["ande", "manlig ande", "manlig djinn"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jini dume"),
            keywords: &["jini dume", "mazimwi dume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} ஜ\u{bc0}னி"),
            keywords: &["ஆண\u{bcd} ஜ\u{bc0}னி", "டிஜின\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుష జ\u{c3f}న\u{c40}"),
            keywords: &["జ\u{c3f}న\u{c4d}", "పురుష జ\u{c3f}న\u{c40}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди ҷин"),
            keywords: &["марди ҷин", "ҷин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e31}กษ\u{e4c}จ\u{e35}น\u{e35}\u{e48}ชาย"),
            keywords: &[
                "ย\u{e31}กษ\u{e4c}จ\u{e34}นน\u{e35}\u{e48}ชาย",
                "ย\u{e31}กษ\u{e4c}จ\u{e35}น\u{e35}\u{e48}ชาย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek jyn"),
            keywords: &["erkek jyn", "jyn"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faʻahikehe tangata"),
            keywords: &["faʻahikehe tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek cin"),
            keywords: &["cin", "erkek cin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر جىن"),
            keywords: &["ئەر جىن", "جىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-джин"),
            keywords: &["джин", "чоловік-джин"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد جن"),
            keywords: &["جن", "مرد جن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak jin"),
            keywords: &["afsun", "chiroq", "erkak", "erkak jin", "ertak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nam thần"),
            keywords: &["ma thần", "nam thần"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jinne ju góor"),
            keywords: &["jinne", "jinne ju góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda ye-genie"),
            keywords: &["i-djinn", "indoda ye-genie"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ànjọ\u{300}nnú ọkùnrin"),
            keywords: &["Ànjọ\u{300}nnú arabia", "Ànjọ\u{300}nnú ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男神燈精靈"),
            keywords: &["巨靈", "男神燈精靈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男神灯精灵"),
            keywords: &["巨灵", "男神灯精灵"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男妖怪"),
            keywords: &["男妖怪", "男神灵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("藍精靈"),
            keywords: &["藍精靈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男燈神"),
            keywords: &["男燈神", "精靈｜男燈神"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijeni yesilisa"),
            keywords: &["i-djinn", "ijeni yesilisa"],
        },
    ],
};
#[doc = "🧞\u{200d}♀\u{fe0f}"]
pub const WOMAN_GENIE: crate::Emoji = crate::Emoji {
    glyph: "🧞\u{200d}♀\u{fe0f}",
    codepoint: "1F9DE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman genie",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧞\u{200d}♀",
        codepoint: "1F9DE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman genie",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike towergees"),
            keywords: &["djinn", "vroulike towergees"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ጅኒ"),
            keywords: &["ሴት ጅኒ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ماردة"),
            keywords: &["ماردة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}ৰ আত\u{9cd}ম\u{9be}"),
            keywords: &["প\u{9cd}ৰেত", "মহিল\u{9be}ৰ আত\u{9cd}ম\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın cin"),
            keywords: &["cin", "qadın cin"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына-джын"),
            keywords: &["джын", "жанчына-джын"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена джин"),
            keywords: &["джин", "жена джин"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} জীনি"),
            keywords: &["জ\u{9cd}বীন জ\u{9be}তি", "মহিল\u{9be} জীনি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena duh iz boce"),
            keywords: &["džin", "žena duh iz boce"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona geni"),
            keywords: &["dona geni", "geni"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᏥᎾᏱ"),
            keywords: &["ᎠᎨᏯ ᏥᎾᏱ", "ᏥᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("džinka"),
            keywords: &["aladin", "duch", "džin", "džinka", "lahev", "lampa", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("genie benywaidd"),
            keywords: &["djinn", "genie benywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig magisk ånd"),
            keywords: &["kvinde", "kvindelig magisk ånd", "magi"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weiblicher Flaschengeist"),
            keywords: &["Dschinn", "weiblicher Flaschengeist"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα τζίνι"),
            keywords: &["γυναίκα τζίνι", "τζίνι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman genie"),
            keywords: &["djinn", "woman genie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("genio mujer"),
            keywords: &["genio", "genio mujer", "lámpara"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naisdžinn"),
            keywords: &["džinn", "naisdžinn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume iratxo"),
            keywords: &["djinn", "emakume iratxo"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن جن"),
            keywords: &["جن", "جن زن", "زن جن", "غول چراغ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naishenki"),
            keywords: &["henki", "juno", "lamppu", "naishenki"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng genie"),
            keywords: &["babaeng genie", "djinn"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur andi"),
            keywords: &["andi", "kona", "kvinna", "kvinnuligur andi", "ævintýr"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("génie femme"),
            keywords: &["djinn", "génie femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["djinn", "femme", "génie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ginid bhaineann"),
            keywords: &["baineann", "ginid", "ginid bhaineann", "sióg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("taibhse bhoireann"),
            keywords: &["djinn", "genie", "taibhse", "taibhse bhoireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xenio de sexo feminino"),
            keywords: &["desexos", "xenia", "xenio de sexo feminino"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી જીની"),
            keywords: &["સ\u{acd}ત\u{acd}રી જીની"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("aljanin larabawa na mace"),
            keywords: &["aljani", "aljanin larabawa na mace"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שדה"),
            keywords: &["ג׳יני", "שדה", "שדונית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{94d}त\u{94d}री जिन\u{94d}न"),
            keywords: &["जिन\u{94d}न", "स\u{94d}त\u{94d}री जिन\u{94d}न"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženski džin"),
            keywords: &["duh", "ženski džin"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női dzsinn"),
            keywords: &["dzsinn", "női dzsinn"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին ջին"),
            keywords: &["կին ջին", "հեքիաթ", "ջին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jin wanita"),
            keywords: &["jin", "jin wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị mmegbu"),
            keywords: &["mmụọ siri ike", "nwanyị mmegbu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns andi"),
            keywords: &["djinn", "kvenkyns andi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("genio donna"),
            keywords: &["djinn", "genio donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女の精霊"),
            keywords: &["女", "女の精霊", "女性", "精霊", "魔神"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jim wadon"),
            keywords: &["jim wadon", "jin"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი ჯინი"),
            keywords: &["ლამპარი", "ქალი ჯინი", "ჯინი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел жын"),
            keywords: &["әйел жын"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជ\u{17b8}ន\u{17b8}ស\u{17d2}រ\u{17b8}"),
            keywords: &["ជ\u{17b8}ន", "ជ\u{17b8}ន\u{17b8}ស\u{17d2}រ\u{17b8}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ಜ\u{cbf}ನೀ"),
            keywords: &["ಜ\u{cbf}ಂಜನ\u{ccd}", "ಮಹ\u{cbf}ಳ\u{cc6} ಜ\u{cbf}ನೀ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 지니"),
            keywords: &["여자 지니", "정령"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल जिनी"),
            keywords: &["जीन", "बायल जिनी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("албарсты"),
            keywords: &["албарсты", "жин"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Geniefra"),
            keywords: &["Djinn", "Geniefra"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb4}ນ\u{eb5}\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &["ຈ\u{eb4}ນ\u{eb5}\u{ec8}ຍ\u{eb4}ງ", "ດ\u{eb5}ຈ\u{eb4}ນ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("džinė"),
            keywords: &["džinė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete džins"),
            keywords: &["džins", "sieviete džins"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tūrehu"),
            keywords: &["djinn", "wahine tūrehu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена џини"),
            keywords: &["жена џини", "џин"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെൺ ജിന\u{d4d}ന\u{d4d}"),
            keywords: &["ജിന\u{d4d}ന\u{d4d}", "പെൺ ജിന\u{d4d}ന\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("Эмэгтэй жини"),
            keywords: &["Эмэгтэй жини", "жинь"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}त\u{94d}री जिनी"),
            keywords: &["जिन\u{94d}न", "स\u{94d}त\u{94d}री जिनी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jin betina"),
            keywords: &["jin", "jin betina"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġenju mara"),
            keywords: &["djinn", "ġenju mara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a}ဘ\u{102e}းလ\u{1030}း",
            ),
            keywords: &[
                "မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a} နတ\u{103a}ဘ\u{102e}လ\u{1030}းတစ\u{103a}မျ\u{102d}\u{102f}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း မ\u{102e}းခ\u{103d}က\u{103a}စောင\u{1037}\u{103a}ဘ\u{102e}းလ\u{1030}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig ånd"),
            keywords: &["djinn", "kvinnelig ånd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("अलौ\u{902}किक शक\u{94d}ति भएकी छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "अलौ\u{902}किक शक\u{94d}ति भएकी छोरीमान\u{94d}छ\u{947}",
                "जिन",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke geest in de fles"),
            keywords: &["djinn", "vrouwelijke geest in de fles"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg ånd"),
            keywords: &["djinn", "kvinneleg ånd"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ଜ\u{b3f}ନ\u{b3f}"),
            keywords: &["ଜ\u{b3f}ନ\u{b4d}ନ", "ମହ\u{b3f}ଳ\u{b3e} ଜ\u{b3f}ନ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤ ਜਿ\u{a70}ਨ"),
            keywords: &["ਔਰਤ ਜਿ\u{a70}ਨ", "ਜਿਨੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانی جن"),
            keywords: &["زنانی جن", "ل\u{64f}کی ہوئی مخلوق"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Jiínii"),
            keywords: &["Bád Spírit", "Jíin", "Wúmán Jiínii"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta dżin"),
            keywords: &["dżin", "kobieta dżin"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه جینی"),
            keywords: &["جين", "ښځه جینی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher gênio"),
            keywords: &["mulher gênio"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("génio (mulher)"),
            keywords: &["djinn", "génio (mulher)"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi genio lamparamanta"),
            keywords: &["genio", "warmi genio lamparamanta"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie duh"),
            keywords: &["djinn", "femeie duh"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1260"),
            keywords: &["E10-1260"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-джинн"),
            keywords: &[
                "джинн",
                "женщина",
                "женщина-джинн",
                "лампа",
                "потереть",
                "сказка",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("iginikazi"),
            keywords: &["iginikazi", "ijini"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت جن"),
            keywords: &["جن", "عورت جن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැන\u{dd4} බහ\u{dd2}රවය\u{dcf}"),
            keywords: &["ගැන\u{dd4} බහ\u{dd2}රවය\u{dcf}", "ජ\u{dd2}න\u{dca}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ženský džin"),
            keywords: &["džin", "fľaša", "lampa", "ženský džin"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženski duh iz steklenice"),
            keywords: &["ženski duh iz steklenice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("jinka haweenka"),
            keywords: &["jinka", "jinka haweenka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua xhind"),
            keywords: &["grua xhind", "xhind"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("женски добри дух"),
            keywords: &["женски добри дух", "женски џин"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ženski dobri duh"),
            keywords: &["ženski dobri duh", "ženski džin"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig ande"),
            keywords: &["djinn", "kvinnlig ande"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jini la kike"),
            keywords: &["jini la kike", "mazimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} ஜ\u{bc0}னி"),
            keywords: &["டிஜின\u{bcd}", "பெண\u{bcd} ஜ\u{bc0}னி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40} జ\u{c3f}న\u{c40}"),
            keywords: &[
                "జ\u{c3f}న\u{c4d}",
                "స\u{c4d}త\u{c4d}ర\u{c40} జ\u{c3f}న\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани ҷин"),
            keywords: &["зани ҷин", "ҷин"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ย\u{e31}กษ\u{e4c}จ\u{e35}น\u{e35}\u{e48}หญ\u{e34}ง"),
            keywords: &[
                "ย\u{e31}กษ\u{e4c}จ\u{e34}นน\u{e35}\u{e48}หญ\u{e34}ง",
                "ย\u{e31}กษ\u{e4c}จ\u{e35}น\u{e35}\u{e48}หญ\u{e34}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal jyn"),
            keywords: &["aýal jyn", "jyn"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faʻahikehe fefine"),
            keywords: &["faʻahikehe fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın cin"),
            keywords: &["cin", "kadın cin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال جىن"),
            keywords: &["ئايال جىن", "جىن"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-джин"),
            keywords: &["джин", "жінка-джин"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت جن"),
            keywords: &["جن", "عورت جن"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol jin"),
            keywords: &["afsun", "ayol", "ayol jin", "chiroq", "ertak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nữ thần"),
            keywords: &["ma thần", "nữ thần"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jinne ju jigéen"),
            keywords: &["jinne", "jinne ju jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa le-genie"),
            keywords: &["i-djinn", "ibhinqa le-genie"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ànjọ\u{300}nnú obìnrin"),
            keywords: &["Ànjọ\u{300}nnú arabia", "Ànjọ\u{300}nnú obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女神燈精靈"),
            keywords: &["女神燈精靈", "巨靈"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女神灯精灵"),
            keywords: &["女神灯精灵", "巨灵"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女妖怪"),
            keywords: &["女妖怪", "女神灵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女藍精靈"),
            keywords: &["女藍精靈"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女燈神"),
            keywords: &["女燈神", "精靈｜女燈神"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ijeni yesifazane"),
            keywords: &["i-djinn", "ijeni yesifazane"],
        },
    ],
};
#[doc = "🧟"]
pub const ZOMBIE: crate::Emoji = crate::Emoji {
    glyph: "🧟",
    codepoint: "1F9DF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "zombie",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("zombie"),
            keywords: &["lewende dooies", "wandelende dooies", "zombie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዞምቢ"),
            keywords: &["ዞምቢ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("زومبي"),
            keywords: &["زومبي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জম\u{9cd}বি"),
            keywords: &[
                "অম\u{9c3}ত\u{9cd}য\u{9c1}",
                "জম\u{9cd}বি",
                "ৱ\u{9be}কিং ডেড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("zombi"),
            keywords: &["gəzən ölü", "xortdan", "zombi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зомбі"),
            keywords: &["жывы мярцвяк", "зомбі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зомби"),
            keywords: &["зомби", "немъртъв", "ходещи мъртви"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জম\u{9cd}বি"),
            keywords: &["আধমর\u{9be}", "ওয\u{9bc}\u{9be}কিং ডেড", "জম\u{9cd}বি"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zombi"),
            keywords: &["hodajući mrtvac", "zombi", "živi mrtvac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("zombi"),
            keywords: &["mort vivent", "walking dead", "zombi"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏲᎱᏒ ᎤᏗᏛᏓ"),
            keywords: &["ᎠᎢᏒᎢ ᎤᏲᎱᏒᎢ", "ᎤᏲᎱᏒ ᎤᏗᏛᏓ", "ᎤᏲᎱᏒᎯ ᏂᎨᏒᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zombie"),
            keywords: &[
                "chodící",
                "ghúl",
                "mrtvola",
                "mrtvá",
                "mrtvý",
                "nemrtvá",
                "nemrtvý",
                "zombie",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sombi"),
            keywords: &["meirw ar droed", "meirw byw", "sombi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("zombie"),
            keywords: &["levende død", "zombie"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zombie"),
            keywords: &["Untoter", "Zombie", "wandelnder Toter"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ζόμπι"),
            keywords: &["απέθαντος", "ζόμπι", "νεκροζώντανος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("zombie"),
            keywords: &["undead", "walking dead", "zombie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zombi"),
            keywords: &["caminante", "muerto viviente", "no muerto", "zombi"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona zombi"),
            keywords: &["persona zombi"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("zombi"),
            keywords: &["elav surnu", "surematu", "zombi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("zonbi"),
            keywords: &["hildako bizidun", "hildako ibiltari", "zonbi"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرده متحرک"),
            keywords: &["جسد متحرک", "زامبی", "مرده متحرک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("zombi"),
            keywords: &["elävä kuollut", "tahdoton", "voodoo", "zombi", "zombie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("zombie"),
            keywords: &["buhay na patay", "walking dead", "zombie"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sombi"),
            keywords: &["sombi", "uppvakningur", "zombie"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("zombie"),
            keywords: &["mort-vivant", "zombie"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("zombaí"),
            keywords: &["neamh-mharbh", "zombaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("zombie"),
            keywords: &["closach", "coiseachd", "marbh", "zombie"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zombi"),
            keywords: &["Walking Dead", "non-morto", "zombi"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઝોમ\u{acd}બી"),
            keywords: &["ઝોમ\u{acd}બી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gaya mai rai"),
            keywords: &["gaya mai motsi", "gaya mai rai", "mara mutuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זומבי"),
            keywords: &["זומבי", "מת מהלך"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ज\u{93c}ॉम\u{94d}बी"),
            keywords: &[
                "ज\u{93c}ॉम\u{94d}बी",
                "मर कर भी जीवित",
                "वॉकि\u{902}ग ड\u{947}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zombi"),
            keywords: &["zombi", "živi mrtvac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("zombi"),
            keywords: &["sétáló halott", "zombi", "élőhalott", "élőholt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զոմբի"),
            keywords: &["զոմբի", "կենդանի", "մարդ", "մեռել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("zombi"),
            keywords: &["mayat berjalan", "mayat hidup", "zombi"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye nwụrụ anwụ na-aga ije"),
            keywords: &[
                "akụkọ mmụọ",
                "ndị nwụrụ anwụ na-aga ije",
                "onye nwụrụ anwụ na-aga ije",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("uppvakningur"),
            keywords: &["hinir gangandi dauðu", "hinir ódauðlegu", "uppvakningur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("zombie"),
            keywords: &["morto vivente", "zombie"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("ゾンビ"),
            keywords: &["ゾンビ", "ホラー"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("zombi"),
            keywords: &["lelembut", "setan bentayangan", "zombi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზომბი"),
            keywords: &["ზომბი", "ცოცხალ-მკვდარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("зомби"),
            keywords: &["зомби"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហ\u{17d2}ស\u{17c6}ប\u{17ca}\u{17b8}"),
            keywords: &[
                "ខ\u{17d2}មោចដើរ",
                "ប\u{17b7}សាចម\u{17b7}នចេះស\u{17d2}លាប\u{17cb}",
                "ហ\u{17d2}ស\u{17c6}ប\u{17ca}\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಜೊಂಬ\u{cbf}"),
            keywords: &["ಜೊಂಬ\u{cbf}", "ನಡ\u{cc6}ದಾಡುವ ಶವ", "ಶವ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("좀비"),
            keywords: &["언데드", "워킹 데드", "좀비"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("झोम\u{94d}बी"),
            keywords: &["चलपी प\u{94d}र\u{947}ता\u{902}", "झोम\u{94d}बी", "न मरपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("зомби"),
            keywords: &["басып жүргөн өлүк", "зомби", "өлбөс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zombie"),
            keywords: &["Zombie", "ondout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊອມບ\u{eb5}\u{ec9}"),
            keywords: &["ຊອມບ\u{eb5}\u{ec9}", "ຜ\u{eb5}ດ\u{eb4}ບ", "ວອກຄ\u{eb4}ງເດດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("zombis"),
            keywords: &["nemirtingas", "vaikštantis numirėlis", "zombis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zombijs"),
            keywords: &["dzīvais mironis", "nemirstīgs", "zombijs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tūpāpaku"),
            keywords: &["oramate", "tūpāpaku", "tūpāpaku hīkoi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("зомби"),
            keywords: &["жив мртовец", "зомби"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വേത\u{d3e}ളം"),
            keywords: &[
                "അൺഡെഡ\u{d4d}",
                "വ\u{d3e}ക\u{d4d}കിംഗ\u{d4d} ഡെഡ\u{d4d}",
                "വേത\u{d3e}ളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зомби"),
            keywords: &["зомби", "үхээгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("झोम\u{94d}बी"),
            keywords: &[
                "चालणारा म\u{943}त",
                "जिव\u{902}त नसल\u{947}ला",
                "झोम\u{94d}बी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("zombi"),
            keywords: &["bangkai bernyawa", "mayat hidup", "zombi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("żombi"),
            keywords: &["mejtin jimxu", "qam mil-mewt", "żombi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{102f}တ\u{103a}ကောင\u{103a}"),
            keywords: &[
                "ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
                "မသေသော",
                "လမ\u{103a}းလျ\u{103e}ောက\u{103a}နေသည\u{1037}\u{103a} အသေကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("zombie"),
            keywords: &["udød", "vandød", "zombie"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{94d}य\u{941}\u{901}त\u{947}को म\u{943}त मान\u{94d}छ\u{947}"),
            keywords: &[
                "म\u{941}र\u{94d}कट\u{94d}टा",
                "म\u{943}त आत\u{94d}मा",
                "व\u{94d}य\u{941}\u{901}त\u{947}को म\u{943}त मान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zombie"),
            keywords: &["lopende dode", "ondode", "zombie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("zombie"),
            keywords: &["udød", "vandød", "zombie"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜୋମ\u{b4d}ବ\u{b3f}"),
            keywords: &[
                "ଜୋମ\u{b4d}ବ\u{b3f}",
                "ପ\u{b4d}ରେତ\u{b3e}ତ\u{b4d}ମ\u{b3e} । ଚ\u{b3e}ଲ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b43}ତ ଶରୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a3c}\u{a4c}\u{a02}ਬੀ"),
            keywords: &[
                "ਜ\u{a3c}\u{a4c}\u{a02}ਬੀ",
                "ਜੀਉ\u{a02}ਦਾ",
                "ਤ\u{a41}ਰਦਾ ਮਰਿਆ ਆਦਮੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زومبی"),
            keywords: &["آسیب", "ت\u{64f}ردی پ\u{650}ھردی لاش", "زومبی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Zombí"),
            keywords: &[
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Dú Laik Sé I Dé Alaif",
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Waká",
                "Zombí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("zombie"),
            keywords: &["chodzące trupy", "nieumarli", "zombie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زومبی"),
            keywords: &["زومبي", "زومبی", "مړ ګرځېدل", "نا مړ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("zumbi"),
            keywords: &["cazumbi", "zumbi"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("zombie"),
            keywords: &["morto-vivo", "zombie"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("zombi"),
            keywords: &["mana wañusqa", "zombi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("zombi"),
            keywords: &["morți vii", "strigoi", "zombi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1136"),
            keywords: &["E10-1136"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зомби"),
            keywords: &["живой", "зомби", "мертвец"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izombi"),
            keywords: &["abapfuye bahagaze", "abatarapfuye", "izombi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("زومبي"),
            keywords: &["زومبي", "ڀوت، موئل هلندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සොම\u{dca}බ\u{dd2}"),
            keywords: &[
                "නොමැර\u{dd4}ණ\u{dd4}",
                "මැර\u{dd3} ඇව\u{dd2}ද\u{dd2}ම",
                "සොම\u{dca}බ\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zombia"),
            keywords: &["mátoha", "mŕtvola", "zombia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zombi"),
            keywords: &["nemrtev", "zombi", "živi mrtvec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof dhintay soo noolaaday"),
            keywords: &["aan dhiman", "mayd socda", "qof dhintay soo noolaaday"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zombi"),
            keywords: &["i pa vdekur", "i vdekur që ecën", "zombi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зомби"),
            keywords: &["зомби", "повампирен", "ходајући мртвац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zombi"),
            keywords: &["hodajući mrtvac", "povampiren", "zombi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("zombie"),
            keywords: &["levande död", "odöd", "vandöd", "zombie"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dubwana"),
            keywords: &["dubwana", "mazimwi", "zimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஜோம\u{bcd}பி"),
            keywords: &["ச\u{bbe}க\u{bbe}வரம\u{bcd} பெற\u{bcd}றது", "ஜோம\u{bcd}பி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("జ\u{c3e}ంబ\u{c40}"),
            keywords: &[
                "జ\u{c3e}ంబ\u{c40}",
                "నడ\u{c3f}చ\u{c47} శవం",
                "మరణం ల\u{c47}న\u{c3f}ద\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зомби"),
            keywords: &["вампирҳо", "зомби", "мурдаҳои роҳгард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซอมบ\u{e35}\u{e49}"),
            keywords: &["ซอมบ\u{e35}\u{e49}", "ผ\u{e35}ด\u{e34}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zombi"),
            keywords: &["zombi", "ölümsiz", "ýöreýän öli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tēvolo"),
            keywords: &["tēvolo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("zombi"),
            keywords: &["hortlak", "yürüyen ölü", "zombi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("زومبى"),
            keywords: &["تىرىك مۇردا", "زومبى", "مۇردا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зомбі"),
            keywords: &["живий мрець", "зомбі", "нечисть"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("زندہ مردہ"),
            keywords: &["زندہ", "زندہ مردہ", "چلتا پھرتا مردہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("zombi"),
            keywords: &["murda", "tirik", "zombi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xác chết sống lại"),
            keywords: &["xác chết sống lại", "xác sống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("zombi"),
            keywords: &["bu deewul", "néew buy dox", "zombi"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithunzela"),
            keywords: &["isidumbu esihambayo", "isithunzela", "ongafanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹbọra"),
            keywords: &["Àìlèkú", "àkúdáàyà", "Ẹbọra"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("殭屍"),
            keywords: &["亡靈", "殭屍", "行屍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("殭尸"),
            keywords: &["亡灵", "殭尸", "行尸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("僵尸"),
            keywords: &["不死族", "僵尸", "行尸走肉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("殭屍"),
            keywords: &["殭屍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("喪屍"),
            keywords: &["喪屍", "喪屍｜殭屍｜不死人｜行屍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isilwane"),
            keywords: &["hamba efile", "isilwane", "ngafile"],
        },
    ],
};
#[doc = "🧟\u{200d}♂\u{fe0f}"]
pub const MAN_ZOMBIE: crate::Emoji = crate::Emoji {
    glyph: "🧟\u{200d}♂\u{fe0f}",
    codepoint: "1F9DF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "man zombie",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧟\u{200d}♂",
        codepoint: "1F9DF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "man zombie",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("manlike zombie"),
            keywords: &["lewende dooies", "manlike zombie", "wandelende dooies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ዞምቢ"),
            keywords: &["ወንድ ዞምቢ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل زومبي"),
            keywords: &["رجل زومبي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ জম\u{9cd}বি"),
            keywords: &[
                "অম\u{9c3}ত\u{9cd}য\u{9c1}",
                "প\u{9c1}ৰ\u{9c1}ষ জম\u{9cd}বি",
                "ৱ\u{9be}কিং ডেড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi zombi"),
            keywords: &["gəzən ölü", "kişi zombi", "xortdan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына-зомбі"),
            keywords: &["жывы мярцвяк", "мужчына-зомбі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж зомби"),
            keywords: &["мъж зомби", "немъртъв", "ходещ мъртъв"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ জম\u{9cd}বি"),
            keywords: &[
                "আধমর\u{9be}",
                "ওয\u{9bc}\u{9be}কিং ডেড",
                "প\u{9c1}র\u{9c1}ষ জম\u{9cd}বি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("zombi"),
            keywords: &["zombi"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac zombi"),
            keywords: &["hodajući mrtvac", "muškarac zombi", "živi mrtvac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home zombi"),
            keywords: &["home zombi", "mort vivent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ ᎤᏲᎱᏒ ᎤᏗᏛᏓ"),
            keywords: &["ᎠᎢᏒᎢ ᎤᏲᎱᏒᎢ", "ᎠᏍᎦᏯ ᎤᏲᎱᏒ ᎤᏗᏛᏓ", "ᎤᏲᎱᏒᎯ ᏂᎨᏒᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nemrtvý muž"),
            keywords: &[
                "chodící",
                "ghúl",
                "mrtvola",
                "mrtvý",
                "nemrtvý",
                "nemrtvý muž",
                "zombie",
                "zombík",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sombi gwrywaidd"),
            keywords: &["meirw ar droed", "meirw byw", "sombi gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mandlig zombie"),
            keywords: &["lavende død", "mand", "mandlig zombie"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("männlicher Zombie"),
            keywords: &["Untoter", "männlicher Zombie", "wandelnder Toter"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Zombiemann"),
            keywords: &["Zombiemann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας ζόμπι"),
            keywords: &["άντρας ζόμπι", "απέθαντοι", "νεκροζώντανοι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man zombie"),
            keywords: &["man zombie", "undead", "walking dead"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zombi hombre"),
            keywords: &["caminante", "muerto viviente", "no muerto", "zombi hombre"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["muerto viviente", "zombi hombre"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeszombi"),
            keywords: &["elav surnu", "meeszombi", "surematu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon zonbi"),
            keywords: &["gizon zonbi", "hildako bizidun", "hildako ibiltari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرده متحرک مرد"),
            keywords: &["جسد متحرک", "زامبی زن", "مرده متحرک زن", "مرده متحرک مرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mieszombi"),
            keywords: &["elävä kuollut", "mieszombi", "tahdoton", "voodoo", "zombie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking zombie"),
            keywords: &["buhay na patay", "lalaking zombie", "walking dead"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("mannligur sombi"),
            keywords: &[
                "mannligur sombi",
                "maður",
                "sombi",
                "uppvakningur",
                "zombie",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("zombie homme"),
            keywords: &["mort-vivant", "zombie homme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["homme", "mort-vivant", "zombie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("zombaí fireann"),
            keywords: &["fearann", "neamh-mharbh", "zombaí", "zombaí fireann"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("zombie fireann"),
            keywords: &["closach", "coiseachd", "marbh", "zombie fireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zombi de sexo masculino"),
            keywords: &[
                "Walking Dead",
                "home",
                "non-morto",
                "zombi de sexo masculino",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ ઝોમ\u{acd}બી"),
            keywords: &["પ\u{ac1}ર\u{ac1}ષ ઝોમ\u{acd}બી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gaya mai rai namiji"),
            keywords: &["gaya mai motsi", "gaya mai rai namiji", "mara mutuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זומבי גבר"),
            keywords: &["זומבי גבר", "מת מהלך"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष ज\u{93c}ॉम\u{94d}बी"),
            keywords: &[
                "प\u{941}र\u{941}ष ज\u{93c}ॉम\u{94d}बी",
                "मर कर भी जीवित",
                "वॉकि\u{902}ग ड\u{947}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muški zombi"),
            keywords: &["muški zombi", "živi mrtvac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi zombi"),
            keywords: &["férfi zombi", "sétáló halott", "élőhalott", "élőholt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ զոմբի"),
            keywords: &["կենդանի", "մեռել", "տղամարդ", "տղամարդ զոմբի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("zombi pria"),
            keywords: &["mayat berjalan", "mayat hidup", "zombi pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke nwụrụ anwụ na-aga ije"),
            keywords: &[
                "akụkọ mmụọ",
                "ndị nwụrụ anwụ na-aga ije",
                "nwoke nwụrụ anwụ na-aga ije",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karlkyns uppvakningur"),
            keywords: &[
                "hinir gangandi dauðu",
                "hinir ódauðlegu",
                "karlkyns uppvakningur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("zombie uomo"),
            keywords: &["morto vivente", "zombie uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男のゾンビ"),
            keywords: &["ゾンビ", "ホラー", "男", "男のゾンビ", "男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("zombi lanang"),
            keywords: &["lelembut", "setan bentayangan", "zombi lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზომბი კაცი"),
            keywords: &["ზომბი კაცი", "ცოცხალ-მკვდარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер зомби"),
            keywords: &["ер зомби"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហ\u{17d2}ស\u{17c6}ប\u{17ca}\u{17b8}ប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ខ\u{17d2}មោចដើរ",
                "ប\u{17b7}សាចម\u{17b7}នចេះស\u{17d2}លាប\u{17cb}",
                "ហ\u{17d2}ស\u{17c6}ប\u{17ca}\u{17b8}ប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ ಜೊಂಬ\u{cbf}"),
            keywords: &["ನಡ\u{cc6}ದಾಡುವ ಶವ", "ಪುರುಷ ಜೊಂಬ\u{cbf}", "ಶವ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 좀비"),
            keywords: &["남자 좀비", "언데드", "워킹 데드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो झोम\u{94d}बी"),
            keywords: &["चलपी प\u{94d}र\u{947}त", "दादलो झोम\u{94d}बी", "न मरपी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек зомби"),
            keywords: &["басып жүргөн өлүк", "эркек зомби", "өлбөс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zombiemann"),
            keywords: &["Zombie", "Zombiemann", "ondout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊອມບ\u{eb5}\u{ec9}ຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &[
                "ຊອມບ\u{eb5}\u{ec9}ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{eb5}ດ\u{eb4}ບ",
                "ວອກຄ\u{eb4}ງເດດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("zombis vyras"),
            keywords: &["nemirtingas", "vaikštantis numirėlis", "zombis vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zombijvīrietis"),
            keywords: &[
                "nemirstīgs",
                "staigājošais mironis",
                "vīrietis zombijs",
                "zombijvīrietis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne tūpāpaku"),
            keywords: &["oramate", "tāne tūpāpaku", "tūpāpaku hīkoi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж зомби"),
            keywords: &["жив мртовец", "зомби", "маж зомби"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആൺ വേത\u{d3e}ളം"),
            keywords: &[
                "അൺഡെഡ\u{d4d}",
                "ആൺ വേത\u{d3e}ളം",
                "വ\u{d3e}ക\u{d4d}കിംഗ\u{d4d} ഡെഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй зомби"),
            keywords: &["зомби", "эрэгтэй зомби", "үхээгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष झोम\u{94d}बी"),
            keywords: &[
                "चालणारा म\u{943}त",
                "जिव\u{902}त नसल\u{947}ला",
                "प\u{941}र\u{942}ष झोम\u{94d}बी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("zombi lelaki"),
            keywords: &["bangkai bernyawa", "mayat hidup", "zombi lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel żombi"),
            keywords: &["mejtin jimxu", "qam mil-mewt", "raġel żombi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား ဖ\u{102f}တ\u{103a}ကောင\u{103a}"),
            keywords: &[
                "မသေသော",
                "လမ\u{103a}းလျ\u{103e}ောက\u{103a}နေသည\u{1037}\u{103a} အသေကောင\u{103a}",
                "အမျ\u{102d}\u{102f}းသား ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mannlig zombie"),
            keywords: &["mannlig zombie", "udød", "vandød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{94d}य\u{941}\u{901}त\u{947}को म\u{943}त छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "म\u{941}र\u{94d}कट\u{94d}टा",
                "म\u{943}त आत\u{94d}मा",
                "व\u{94d}य\u{941}\u{901}त\u{947}को म\u{943}त छोरामान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mannelijke zombie"),
            keywords: &["lopende dode", "mannelijke zombie", "ondode"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mannleg zombie"),
            keywords: &["mannleg zombie", "udød", "vandød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ ଜୋମ\u{b4d}ବ\u{b3f}"),
            keywords: &[
                "ପ\u{b41}ର\u{b41}ଷ ଜୋମ\u{b4d}ବ\u{b3f}",
                "ପ\u{b4d}ରେତ\u{b3e}ତ\u{b4d}ମ\u{b3e} । ଚ\u{b3e}ଲ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b43}ତ ଶରୀର",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a41}ਰਸ\u{a3c} ਜ\u{a3c}\u{a4c}\u{a02}ਬੀ"),
            keywords: &[
                "ਜੀਉ\u{a02}ਦਾ",
                "ਤ\u{a41}ਰਦਾ ਮਰਿਆ ਆਦਮੀ",
                "ਪ\u{a41}ਰਸ\u{a3c} ਜ\u{a3c}\u{a4c}\u{a02}ਬੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بندا زومبی"),
            keywords: &["آسیب", "بندا زومبی", "ت\u{64f}ردی پ\u{650}ھردی لاش"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mán Zombí"),
            keywords: &[
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Dú Laik Sé I Dé Alaif",
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Waká",
                "Mán Zombí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna zombie"),
            keywords: &["chodzące trupy", "mężczyzna zombie", "nieumarli"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی زومبی"),
            keywords: &["سړی زومبي", "سړی زومبی", "نامړ", "ګرځنده مړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem zumbi"),
            keywords: &["cazumbi", "homem zumbi"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("morto-vivo"),
            keywords: &["homem zombie", "morto-vivo"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata zombi"),
            keywords: &["mana wañusqa", "tata zombi", "zombi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat zombi"),
            keywords: &["bărbat zombi", "morți vii", "strigoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1263"),
            keywords: &["E10-1263"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина-зомби"),
            keywords: &[
                "живой",
                "живой метрвец",
                "зомби",
                "мертвец",
                "мужчина",
                "мужчина-зомби",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izombigabo"),
            keywords: &["abapfuye bahagaze", "abatarapfuye", "izombigabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مرد زومبي"),
            keywords: &["مرد زومبي", "ڀوت، موئل هلندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} සොම\u{dca}බ\u{dd2}"),
            keywords: &[
                "නොමැර\u{dd4}ණ\u{dd4}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} සොම\u{dca}බ\u{dd2}",
                "මැර\u{dd3} ඇව\u{dd2}ද\u{dd2}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mužská zombia"),
            keywords: &["mužská zombia", "mátoha", "mŕtvola"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zombi moški"),
            keywords: &["nemrtev", "zombi moški", "živi mrtvec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin dhintay oo soo noolaaday"),
            keywords: &[
                "aan dhiman",
                "mayd socda",
                "nin dhintay oo soo noolaaday",
                "nin dhintay soo laabtay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë zombi"),
            keywords: &["burrë zombi", "i pa vdekur", "i vdekur që ecën"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац зомби"),
            keywords: &["мушкарац зомби", "повампирена", "ходајућа мртвакиња"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac zombi"),
            keywords: &["hodajuća mrtvakinja", "muškarac zombi", "povampirena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("manlig zombie"),
            keywords: &["levande död", "manlig zombie", "odöd", "vandöd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dubwana dume"),
            keywords: &["dubwana", "dubwana dume", "zimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd} ஜோம\u{bcd}பி"),
            keywords: &[
                "ஆண\u{bcd} ஜோம\u{bcd}பி",
                "ச\u{bbe}க\u{bbe}வரம\u{bcd} பெற\u{bcd}றது",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుష జ\u{c3e}ంబ\u{c40}"),
            keywords: &[
                "నడ\u{c3f}చ\u{c47} శవం",
                "పురుష జ\u{c3e}ంబ\u{c40}",
                "మరణం ల\u{c47}న\u{c3f}వ\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди зомби"),
            keywords: &["вампирҳо", "марди зомби", "мурдаҳои роҳгард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซอมบ\u{e35}\u{e49}ผ\u{e39}\u{e49}ชาย"),
            keywords: &["ซอมบ\u{e35}\u{e49}ผ\u{e39}\u{e49}ชาย", "ผ\u{e35}ด\u{e34}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek zombi"),
            keywords: &["erkek zombi", "ölümsiz", "ýöreýän öli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tēvolo tangata"),
            keywords: &["tēvolo tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek zombi"),
            keywords: &["erkek zombi", "hortlak", "yürüyen ölü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر زومبى"),
            keywords: &["ئەر زومبى", "تىرىك مۇردا", "مۇردا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік-зомбі"),
            keywords: &["живий мрець", "зомбі", "упир", "чоловік-зомбі"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("زندہ مردہ مرد"),
            keywords: &["زندہ", "زندہ مردہ مرد", "چلتا پھرتا مردہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak zombi"),
            keywords: &["erkak", "erkak zombi", "murda", "tirik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xác chết nam sống lại"),
            keywords: &["xác chết nam sống lại", "xác chết sống lại", "xác sống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("zombi bu góor"),
            keywords: &["bu deewul", "néew buy dox", "zombi bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithunzela esiyindoda"),
            keywords: &["isidumbu esihambayo", "isithunzela esiyindoda", "ongafanga"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹbọra ọkùnrin"),
            keywords: &["Àìlèkú", "àkúdáàyà", "Ẹbọra ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男殭屍"),
            keywords: &["亡靈", "男殭屍", "行屍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男殭尸"),
            keywords: &["亡灵", "男殭尸", "行尸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男僵尸"),
            keywords: &["男僵尸", "男行尸走肉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男殭屍"),
            keywords: &["男殭屍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("男喪屍"),
            keywords: &["男喪屍", "男喪屍｜男殭屍｜不死人｜行屍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isipoki sowesilisa"),
            keywords: &["hamba efile", "isipoki sowesilisa", "ngafile"],
        },
    ],
};
#[doc = "🧟\u{200d}♀\u{fe0f}"]
pub const WOMAN_ZOMBIE: crate::Emoji = crate::Emoji {
    glyph: "🧟\u{200d}♀\u{fe0f}",
    codepoint: "1F9DF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "woman zombie",
    group: "People & Body",
    subgroup: "person-fantasy",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧟\u{200d}♀",
        codepoint: "1F9DF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 5f32,
        name: "woman zombie",
        group: "People & Body",
        subgroup: "person-fantasy",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vroulike zombie"),
            keywords: &["lewende dooies", "vroulike zombie", "wandelende dooies"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት ዞምቢ"),
            keywords: &["ሴት ዞምቢ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("امرأة زومبي"),
            keywords: &["امرأة زومبي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be} জম\u{9cd}বি"),
            keywords: &[
                "অম\u{9c3}ত\u{9cd}য\u{9c1}",
                "মহিল\u{9be} জম\u{9cd}বি",
                "ৱ\u{9be}কিং ডেড",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın zombi"),
            keywords: &["gəzən ölü", "qadın zombi", "xortdan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына-зомбі"),
            keywords: &["жанчына-зомбі", "жывы мярцвяк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена зомби"),
            keywords: &["жена зомби", "немъртва", "ходеща мъртва"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be} জম\u{9cd}বি"),
            keywords: &[
                "আধমর\u{9be}",
                "ওয\u{9bc}\u{9be}কিং ডেড",
                "মহিল\u{9be} জম\u{9cd}বি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("zombiez"),
            keywords: &["zombiez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena zombi"),
            keywords: &["hodajući mrtvac", "žena zombi", "živi mrtvac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona zombi"),
            keywords: &["dona zombi", "morta vivent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ ᎤᏲᎱᏒ ᎤᏗᏛᏓ"),
            keywords: &["ᎠᎢᏒᎢ ᎤᏲᎱᏒᎢ", "ᎠᎨᏯ ᎤᏲᎱᏒ ᎤᏗᏛᏓ", "ᎤᏲᎱᏒᎯ ᏂᎨᏒᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nemrtvá žena"),
            keywords: &[
                "chodící",
                "ghúl",
                "mrtvola",
                "mrtvá",
                "nemrtvá",
                "nemrtvá žena",
                "zombice",
                "zombie",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("sombi benywaidd"),
            keywords: &["meirw ar droed", "meirw byw", "sombi benywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvindelig zombie"),
            keywords: &["kvinde", "kvindelig zombie", "levende død"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("weiblicher Zombie"),
            keywords: &["Untote", "wandelnde Tote", "weiblicher Zombie"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα ζόμπι"),
            keywords: &["απέθαντη", "γυναίκα ζόμπι", "νεκροζώντανη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman zombie"),
            keywords: &["undead", "walking dead", "woman zombie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("zombi mujer"),
            keywords: &["caminante", "muerta viviente", "no muerta", "zombi mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["muerta viviente", "zombi hombre", "zombi mujer"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naiszombi"),
            keywords: &["elav surnu", "naiszombi", "surematu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume zonbi"),
            keywords: &["emakume zonbi", "hildako bizidun", "hildako ibiltari"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرده متحرک زن"),
            keywords: &["جسد متحرک", "زامبی مرد", "مرده متحرک زن", "مرده متحرک مرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("naiszombi"),
            keywords: &["elävä kuollut", "naiszombi", "tahdoton", "voodoo", "zombie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babaeng zombie"),
            keywords: &["babaeng zombie", "buhay na patay", "walking dead"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kvinnuligur sombi"),
            keywords: &[
                "kona",
                "kvinna",
                "kvinnuligur sombi",
                "sombi",
                "uppvakna",
                "zombie",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("zombie femme"),
            keywords: &["morte-vivante", "zombie femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["femme", "morte-vivante", "zombie"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("zombaí baineann"),
            keywords: &["baineann", "neamh-mharbh", "zombaí"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("zombie boireann"),
            keywords: &["closach", "coiseachd", "marbh", "zombie boireann"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("zombi de sexo feminino"),
            keywords: &[
                "Walking Dead",
                "muller",
                "non-morta",
                "zombi de sexo feminino",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી ઝોમ\u{acd}બી"),
            keywords: &["સ\u{acd}ત\u{acd}રી ઝોમ\u{acd}બી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gaya mai rai na mace"),
            keywords: &["gaya mai motsi", "gaya mai rai na mace", "mara mutuwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זומבי אישה"),
            keywords: &["זומבי אישה", "מתה מהלכת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला ज\u{93c}ॉम\u{94d}बी"),
            keywords: &[
                "मर कर भी जीवित",
                "महिला ज\u{93c}ॉम\u{94d}बी",
                "वॉकि\u{902}ग ड\u{947}ड",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ženski zombi"),
            keywords: &["ženski zombi", "živi mrtvac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("női zombi"),
            keywords: &["női zombi", "sétáló halott", "élőhalott", "élőholt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին զոմբի"),
            keywords: &["կենդանի", "կին", "կին զոմբի", "մեռել"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("zombi wanita"),
            keywords: &["mayat berjalan", "mayat hidup", "zombi wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị nwụrụ anwụ na-aga ije"),
            keywords: &[
                "akụkọ mmụọ",
                "ndị nwụrụ anwụ na-aga ije",
                "nwanyị nwụrụ anwụ na-aga ije",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kvenkyns uppvakningur"),
            keywords: &[
                "hinir gangandi dauðu",
                "hinir ódauðlegu",
                "kvenkyns uppvakningur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("zombie donna"),
            keywords: &["morto vivente", "zombie donna"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女のゾンビ"),
            keywords: &["ゾンビ", "ホラー", "女", "女のゾンビ", "女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("zombi wadon"),
            keywords: &["lelembut", "setan bentayangan", "zombi wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზომბი ქალი"),
            keywords: &["ზომბი ქალი", "ცოცხალ-მკვდარი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел зомби"),
            keywords: &["әйел зомби"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ហ\u{17d2}ស\u{17c6}ប\u{17ca}\u{17b8}ស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ខ\u{17d2}មោចដើរ",
                "ប\u{17b7}សាចម\u{17b7}នចេះស\u{17d2}លាប\u{17cb}",
                "ហ\u{17d2}ស\u{17c6}ប\u{17ca}\u{17b8}ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6} ಜೊಂಬ\u{cbf}"),
            keywords: &["ನಡ\u{cc6}ದಾಡುವ ಶವ", "ಮಹ\u{cbf}ಳ\u{cc6} ಜೊಂಬ\u{cbf}", "ಶವ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 좀비"),
            keywords: &["언데드", "여자 좀비", "워킹데드"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल झोम\u{94d}बी"),
            keywords: &["चलपी प\u{94d}र\u{947}त", "न मरपी", "बायल झोम\u{94d}बी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял зомби"),
            keywords: &["аял зомби", "басып жүргөн өлүк", "өлбөс"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zombiefra"),
            keywords: &["Zombie", "Zombiefra", "ondout"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊອມບ\u{eb5}\u{ec9}ຍ\u{eb4}ງ"),
            keywords: &[
                "ຊອມບ\u{eb5}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb5}ດ\u{eb4}ບ",
                "ວອກຄ\u{eb4}ງເດດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("zombė"),
            keywords: &["nemirtinga", "vaikštanti numirėlė", "zombė"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zombijsieviete"),
            keywords: &[
                "nemirstīgs",
                "sieviete zombijs",
                "staigājošais mironis",
                "zombijsieviete",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine tūpāpaku"),
            keywords: &["oramate", "tūpāpaku hīkoi", "wahine tūpāpaku"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена зомби"),
            keywords: &["жена зомби", "жив мртовец", "зомби"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെൺ വേത\u{d3e}ളം"),
            keywords: &[
                "അൺഡെഡ\u{d4d}",
                "പെൺ വേത\u{d3e}ളം",
                "വ\u{d3e}ക\u{d4d}കിംഗ\u{d4d} ഡെഡ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй зомби"),
            keywords: &["зомби", "эмэгтэй зомби", "үхээгүй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{94d}त\u{94d}री झोम\u{94d}बी"),
            keywords: &[
                "चालणारा म\u{943}त",
                "जिव\u{902}त नसल\u{947}ला",
                "स\u{94d}त\u{94d}री झोम\u{94d}बी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("zombi wanita"),
            keywords: &["bangkai bernyawa", "mayat hidup", "zombi wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara żombi"),
            keywords: &["mara żombi", "mejtin jimxu", "qam mil-mewt"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း ဖ\u{102f}တ\u{103a}ကောင\u{103a}"),
            keywords: &[
                "မသေသော",
                "လမ\u{103a}းလျ\u{103e}ောက\u{103a}နေသည\u{1037}\u{103a} အသေကောင\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း ဖ\u{102f}တ\u{103a}ကောင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinnelig zombie"),
            keywords: &["kvinnelig zombie", "udød", "vandød"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("व\u{94d}य\u{941}\u{901}त\u{947}को म\u{943}त छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "म\u{941}र\u{94d}कट\u{94d}टा",
                "म\u{943}त आत\u{94d}मा",
                "व\u{94d}य\u{941}\u{901}त\u{947}को म\u{943}त छोरीमान\u{94d}छ\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouwelijke zombie"),
            keywords: &["lopende dode", "ondode", "vrouwelijke zombie"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinneleg zombie"),
            keywords: &["kvinneleg zombie", "udød", "vandød"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e} ଜୋମ\u{b4d}ବ\u{b3f}"),
            keywords: &[
                "ପ\u{b4d}ରେତ\u{b3e}ତ\u{b4d}ମ\u{b3e} । ଚ\u{b3e}ଲ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b43}ତ ଶରୀର",
                "ମହ\u{b3f}ଳ\u{b3e} ଜୋମ\u{b4d}ବ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤ ਜ\u{a3c}\u{a4c}\u{a02}ਬੀ"),
            keywords: &[
                "ਔਰਤ ਜ\u{a3c}\u{a4c}\u{a02}ਬੀ",
                "ਜੀਉ\u{a02}ਦਾ",
                "ਤ\u{a41}ਰਦਾ ਮਰਿਆ ਆਦਮੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانی زومبی"),
            keywords: &["آسیب", "ت\u{64f}ردی پ\u{650}ھردی لاش", "زنانی زومبی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúmán Zombí"),
            keywords: &[
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Dú Laik Sé I Dé Alaif",
                "Dẹ\u{301}d Pẹ\u{301}sin Wé De Waká",
                "Wúmán Zombí",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta zombie"),
            keywords: &["chodzące trupy", "kobieta zombie", "nieumarli"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه زومبی"),
            keywords: &["نامړ", "ښځه زومبي", "ښځه زومبی", "ګرځنده مړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher zumbi"),
            keywords: &["cazumbi", "mulher zumbi"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("morta-viva"),
            keywords: &["morta-viva", "mulher zombie"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi zombi"),
            keywords: &["mana wañusqa", "warmi zombi", "zombi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie zombi"),
            keywords: &["femeie zombi", "morți vii", "strigoi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1262"),
            keywords: &["E10-1262"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина-зомби"),
            keywords: &["женщина", "женщина-зомби", "живой", "зомби", "мертвец"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izombikazi"),
            keywords: &["abapfuye bahagaze", "abatarapfuye", "izombikazi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت زومبي"),
            keywords: &["عورت زومبي", "ڀوت، موئل هلندي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැන\u{dd4} සොම\u{dca}බ\u{dd2}"),
            keywords: &[
                "ගැන\u{dd4} සොම\u{dca}බ\u{dd2}",
                "නොමැර\u{dd4}ණ\u{dd4}",
                "මැර\u{dd3} ඇව\u{dd2}ද\u{dd2}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ženská zombia"),
            keywords: &["mátoha", "mŕtvola", "ženská zombia"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zombi ženska"),
            keywords: &["nemrtev", "zombi ženska", "živi mrtvec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("haweeney dhimatay soo laabatay"),
            keywords: &[
                "aan dhiman",
                "haweeney dhimatay soo laabatay",
                "haweeney dhimatay soo noolaatay",
                "mayd socda",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua zombi"),
            keywords: &["grua zombi", "i pa vdekur", "i vdekur që ecën"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена зомби"),
            keywords: &["жена зомби", "повампирен", "ходајући мртвац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["жена зомби"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena zombi"),
            keywords: &["hodajući mrtvac", "povampiren", "žena zombi"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["žena zombi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinnlig zombie"),
            keywords: &["kvinnlig zombie", "levande död", "odöd", "vandöd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dubwana jike"),
            keywords: &["dubwana jike", "mazimwi", "zimwi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd} ஜோம\u{bcd}பி"),
            keywords: &[
                "ச\u{bbe}க\u{bbe}வரம\u{bcd} பெற\u{bcd}றது",
                "பெண\u{bcd} ஜோம\u{bcd}பி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40} జ\u{c3e}ంబ\u{c40}"),
            keywords: &[
                "నడ\u{c3f}చ\u{c47} శవం",
                "మరణం ల\u{c47}న\u{c3f}ద\u{c3f}",
                "స\u{c4d}త\u{c4d}ర\u{c40} జ\u{c3e}ంబ\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани зомби"),
            keywords: &["вампирҳо", "зани зомби", "мурдаҳои роҳгард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ซอมบ\u{e35}\u{e49}ผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &[
                "ซอมบ\u{e35}\u{e49}ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e35}ด\u{e34}บ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal zombi"),
            keywords: &["aýal zombi", "ölümsiz", "ýöreýän öli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tēvolo fefine"),
            keywords: &["tēvolo fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın zombi"),
            keywords: &["hortlak", "kadın zombi", "yürüyen ölü"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال زومبى"),
            keywords: &["ئايال زومبى", "تىرىك مۇردا", "مۇردا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка-зомбі"),
            keywords: &["живий мрець", "жінка-зомбі", "зомбі", "нечисть", "упириця"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("زندہ مردہ عورت"),
            keywords: &["زندہ", "زندہ مردہ عورت", "چلتا پھرتا مردہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol zombi"),
            keywords: &["ayol", "ayol zombi", "murda", "tirik"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xác chết nữ sống lại"),
            keywords: &["xác chết nữ sống lại", "xác chết sống lại", "xác sống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("zombi bu jigéen"),
            keywords: &["bu deewul", "néew buy dox", "zombi bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isithunzela esilibhinqa"),
            keywords: &[
                "isidumbu esihambayo",
                "isithunzela esilibhinqa",
                "ongafanga",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹbọra obìnrin"),
            keywords: &["Àìlèkú", "àkúdáàyà", "Ẹbọra obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女殭屍"),
            keywords: &["亡靈", "女殭屍", "行屍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女殭尸"),
            keywords: &["亡灵", "女殭尸", "行尸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女僵尸"),
            keywords: &["女僵尸", "女行尸走肉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女殭屍"),
            keywords: &["女殭屍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("女喪屍"),
            keywords: &["女喪屍", "女喪屍｜女殭屍｜不死人｜行屍"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isilwane sowesifazane"),
            keywords: &["hamba efile", "isilwane sowesifazane", "ngafile"],
        },
    ],
};
