#[doc = "👶"]
pub const BABY: crate::Emoji = crate::Emoji {
    glyph: "👶",
    codepoint: "1F476",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "baby",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("baba"),
            keywords: &["baba", "jonk"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሕጻን"),
            keywords: &["ሕጻን", "ጨቅላ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رضيع"),
            keywords: &["رضيع", "طفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কেচ\u{9c1}ৱ\u{9be}"),
            keywords: &["কেচ\u{9c1}ৱ\u{9be}", "তৰ\u{9c1}ণ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("körpə"),
            keywords: &["cavan", "körpə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("немаўля"),
            keywords: &["малеча", "немаўля"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("бебе"),
            keywords: &["бебе"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শিশ\u{9c1}"),
            keywords: &["ব\u{9be}চ\u{9cd}চ\u{9be}", "শিশ\u{9c1}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("babig"),
            keywords: &["babig", "yaouank"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("beba"),
            keywords: &["beba", "mlado"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nadó"),
            keywords: &["bebè", "nadó", "nounat"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄇\u{1112a}𑄏\u{11128} 𑄌\u{11128}𑄌\u{11134}\u{11128}𑄇\u{11134}"),
            keywords: &["𑄇\u{1112a}𑄏\u{11128} 𑄌\u{11128}𑄌\u{11134}\u{11128}𑄇\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏍᏗ"),
            keywords: &["ᎠᏓᎨ", "ᎤᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nemluvně"),
            keywords: &["batole", "kojenec", "malé dítě", "nemluvně"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("babi"),
            keywords: &["babi", "ifanc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("baby"),
            keywords: &["baby", "barn", "menneske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Baby"),
            keywords: &["Baby", "Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μωρό"),
            keywords: &["μωρό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("baby"),
            keywords: &["baby", "young"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bebé"),
            keywords: &["bebé", "joven", "niño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("bebé"),
            keywords: &["bebé", "cara", "persona"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["bebé", "cara", "infante", "nene"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("beebi"),
            keywords: &["beebi", "imik", "tita", "titt"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haurtxoa"),
            keywords: &["haurtxo", "haurtxoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نوزاد"),
            keywords: &["خردسال", "طفل", "نوزاد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vauva"),
            keywords: &["lapsi", "nuori", "vauva"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("sanggol"),
            keywords: &["bata", "sanggol"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("pinkubarn"),
            keywords: &["barn", "pinkubarn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bébé"),
            keywords: &["bébé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["bébé", "petit"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("babaí"),
            keywords: &["babaí", "óg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("naoidhean"),
            keywords: &["leanabh", "naoidhean", "òg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bebé"),
            keywords: &["bebé"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શિશ\u{ac1}"),
            keywords: &["લોકો", "શિશ\u{ac1}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jariri"),
            keywords: &["jariri", "ƙarami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("תינוק"),
            keywords: &["פעוט", "תינוק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("शिश\u{941}"),
            keywords: &["नवजात", "शिश\u{941}"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("beba"),
            keywords: &["beba", "djetešce", "dojenče"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("baba"),
            keywords: &["baba", "kisbaba"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մանուկ"),
            keywords: &["երեխա", "մանուկ", "նորածին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("bayi"),
            keywords: &["bayi", "muda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwata ọhụrụ"),
            keywords: &["nwata ọhụrụ", "obere"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ungbarn"),
            keywords: &["fólk", "ungbarn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("neonato"),
            keywords: &["bebè", "figlio", "neonato", "persone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("赤ん坊"),
            keywords: &["ベビー", "赤ちゃん", "赤ん坊", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bayi"),
            keywords: &["bayi", "nom"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჩვილი"),
            keywords: &["ბავშვი", "ჩვილი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("ṣebyan"),
            keywords: &["ṣebyan"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сәби"),
            keywords: &["бөпе", "нәресте", "сәби"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("baby"),
            keywords: &["baby", "barn", "menneske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទារក"),
            keywords: &["ក\u{17bc}នង\u{17c9}ែត", "ក\u{17d2}មេង", "ទារក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಳ\u{cc6}ಮಗು"),
            keywords: &["ಎಳ\u{cc6}ಮಗು", "ಶ\u{cbf}ಶು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아기"),
            keywords: &["아기", "유아"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शिश\u{941}"),
            keywords: &["शिश\u{941}", "सान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кичинекей бала"),
            keywords: &["кичинекей", "кичинекей бала", "наристе"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Puppelchen"),
            keywords: &["Bëbee", "Puppelchen", "jonk"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແອນ\u{ec9}ອຍ"),
            keywords: &["ຄ\u{ebb}ນ", "ແອນ\u{ec9}ອຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kūdikis"),
            keywords: &["jaunas", "kūdikis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zīdainis"),
            keywords: &["bērns", "mazulis", "seja", "zīdainis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pēpi"),
            keywords: &["pēpi", "tamariki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бебе"),
            keywords: &["бебе", "мало"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}"),
            keywords: &["ക\u{d41}ഞ\u{d4d}ഞ\u{d4d}", "ചെറ\u{d41}പ\u{d4d}പം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нялх хүүхэд"),
            keywords: &["нялх", "хүүхэд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("बाळ"),
            keywords: &["तर\u{942}ण", "बाळ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bayi"),
            keywords: &["bayi"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tarbija"),
            keywords: &["tarbija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကလေးငယ\u{103a}"),
            keywords: &["ကလေးငယ\u{103a}", "လ\u{1030}ကလေး"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("baby"),
            keywords: &["baby", "menneske", "ung"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("शिश\u{941}"),
            keywords: &["बच\u{94d}चा", "शिश\u{941}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("baby"),
            keywords: &["baby", "jong"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("baby"),
            keywords: &["baby", "menneske", "ung"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ଶ\u{b41}"),
            keywords: &["ଯ\u{b41}ବକ", "ଶ\u{b3f}ଶ\u{b41}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਾਲ"),
            keywords: &["ਛ\u{a4b}ਟਾ ਬ\u{a71}ਚਾ", "ਬਾਲ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نیانا"),
            keywords: &["جوان", "نیانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Taata"),
            keywords: &["Bebí", "Píkin Wé Stíl De Sọ\u{301}k Brẹst", "Taata", "Yọng"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("niemowlę"),
            keywords: &["dziecko", "niemowlę"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("کوچنی"),
            keywords: &["ځوان", "کوچنی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bebê"),
            keywords: &["bebê", "neném"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bebé"),
            keywords: &["bebé", "criança", "pessoa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("wawa"),
            keywords: &["wawa", "wayna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bebeluș"),
            keywords: &["bebe", "bebeluș", "copilaș", "tânăr"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-563"),
            keywords: &["E10-563"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("младенец"),
            keywords: &["дитя", "карапуз", "маленький", "младенец", "ребенок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("uruhinja"),
            keywords: &["rukiri ruto", "uruhinja"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننڍو ٻار"),
            keywords: &["ننڍو ٻار", "ننڍو ٻار، جوان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("බබ\u{dcf}"),
            keywords: &["බබ\u{dcf}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bábätko"),
            keywords: &["bábä", "bábätko"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dojenček"),
            keywords: &["dojenček"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cunug"),
            keywords: &["cunug", "yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("bebe"),
            keywords: &["bebe", "foshnjë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("беба"),
            keywords: &["бeбa", "беба", "младост"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["беба"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("beba"),
            keywords: &["beba", "mladost"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["beba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("bebis"),
            keywords: &["baby", "bebis", "liten", "ung"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtoto"),
            keywords: &["mchanga", "mtoto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குழந\u{bcd}தை"),
            keywords: &[
                "குட\u{bcd}டிப\u{bcd}ப\u{bbe}ப\u{bcd}ப\u{bbe}",
                "குட\u{bcd}டிப\u{bcd}பையன\u{bcd}",
                "குழந\u{bcd}தை",
                "ப\u{bbe}ப\u{bcd}ப\u{bbe}",
                "மக\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c3f}డ\u{c4d}డ"),
            keywords: &["బ\u{c3f}డ\u{c4d}డ"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("тифл"),
            keywords: &["кӯдак", "тифл", "ҷавон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทารก"),
            keywords: &["ทารก", "เด\u{e47}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bäbek"),
            keywords: &["bäbek", "ýaş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("valevale"),
            keywords: &["valevale"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bebek"),
            keywords: &["bebek", "kişiler"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بوۋاق"),
            keywords: &["بوۋاق", "ياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("немовля"),
            keywords: &["дитина", "малеча", "немовля"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("طفل"),
            keywords: &["انسان", "بچہ", "طفل"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chaqaloq"),
            keywords: &["chaqaloq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trẻ con"),
            keywords: &["trẻ con", "trẻ em"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("liir"),
            keywords: &["liir", "ndaw"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("usana"),
            keywords: &["mtsha", "usana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìkókó"),
            keywords: &["ìkókó", "ọ\u{300}dọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嬰兒"),
            keywords: &["嬰兒", "年青"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("婴儿"),
            keywords: &["婴儿", "年青"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("小宝贝"),
            keywords: &["宝宝", "小宝贝"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小寶寶"),
            keywords: &["小嬰兒", "小寶寶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("嬰兒"),
            keywords: &["嬰兒", "小嬰兒"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("usana"),
            keywords: &["ingane", "usana"],
        },
    ],
};
#[doc = "👶🏻"]
pub const BABY_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👶🏻",
    codepoint: "1F476 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👶🏼"]
pub const BABY_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👶🏼",
    codepoint: "1F476 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👶🏽"]
pub const BABY_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👶🏽",
    codepoint: "1F476 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👶🏾"]
pub const BABY_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👶🏾",
    codepoint: "1F476 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👶🏿"]
pub const BABY_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👶🏿",
    codepoint: "1F476 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "baby: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧒"]
pub const CHILD: crate::Emoji = crate::Emoji {
    glyph: "🧒",
    codepoint: "1F9D2",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "child",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("kind"),
            keywords: &["geslag-neutraal", "jongmens", "kind"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ልጅ"),
            keywords: &["ልጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طفل"),
            keywords: &["طفل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শিশ\u{9c1}"),
            keywords: &["তৰ\u{9c1}ণ", "লিংগ নিউট\u{9cd}ৰেল", "শিশ\u{9c1}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("uşaq"),
            keywords: &["cavan", "gender-neytral", "uşaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дзіця"),
            keywords: &["дзіця", "малады", "невядомы пол", "нявызначаны пол"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дете"),
            keywords: &["без определен пол", "дете", "млад", "неутрален пол"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}চ\u{9cd}চ\u{9be}"),
            keywords: &[
                "ব\u{9be}চ\u{9cd}চ\u{9be}",
                "য\u{9c1}বক",
                "লিঙ\u{9cd}গ- নিরপেক\u{9cd}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("bugel"),
            keywords: &["bugel", "yaouank"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dijete"),
            keywords: &["dijete", "mlado", "neodređeni spol", "srednji rod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("criatura"),
            keywords: &["criatura", "infant"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄌\u{11128}𑄉\u{1112e}𑄚\u{11134} 𑄉\u{1112a}𑄢\u{1112e}"),
            keywords: &["𑄌\u{11128}𑄉\u{1112e}𑄚\u{11134} 𑄉\u{1112a}𑄢\u{1112e}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏲᏟ"),
            keywords: &["ᎠᏓ", "ᎠᏲᏟ", "ᎢᏳᏍᏗ ᎨᎲ ᏄᏬᎵᏍᏛᎾ", "ᎢᏳᏍᏗ ᎨᎲ-ᎢᏳᏍᏗᏊ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dítě"),
            keywords: &["dítě", "malé", "neutrální"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("plentyn"),
            keywords: &["ifanc", "niwtral o ran rhyw", "plentyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("barn"),
            keywords: &["barn", "ungt menneske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Kind"),
            keywords: &["Kind", "geschlechtsneutral", "jung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παιδί"),
            keywords: &["άφυλος", "νέος", "παιδί"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("child"),
            keywords: &["child", "gender-neutral", "unspecified gender", "young"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["child", "gender-neutral", "toddler", "young"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "child",
                "gender-neutral",
                "toddler",
                "unspecified gender",
                "young",
            ],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("infante"),
            keywords: &["crío", "género", "infante", "joven", "neutro"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("joven"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "género neutro",
                "género no especificado",
                "infante",
                "joven",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("laps"),
            keywords: &["laps", "noor", "sooliselt neutraalne"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("haur"),
            keywords: &["gazte", "genero neutroko", "haur"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بچه"),
            keywords: &["بچه", "بی\u{200c}جنس", "جنس خنثی", "جوان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("lapsi"),
            keywords: &["lapsi", "lapsuus", "nuori", "sukupuolineutraali"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bata"),
            keywords: &[
                "anak",
                "bata",
                "hindi tinukoy na kasarian",
                "kasarian-neutral",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("barn"),
            keywords: &["barn", "óviti"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("enfant"),
            keywords: &["enfant", "genre neutre", "jeune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["enfant", "genre non défini", "jeune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("leanbh"),
            keywords: &["leanbh", "neodrach ó thaobh inscne de", "óg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine-cloinne"),
            keywords: &["duine-cloinne", "gun ghnè", "òg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("criatura"),
            keywords: &["criatura", "nena", "neno", "rapaz", "rapaza"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાળક"),
            keywords: &[
                "અનિર\u{acd}દિષ\u{acd}ટ લિ\u{a82}ગ",
                "બાળક",
                "ય\u{ac1}વાન",
                "લિ\u{a82}ગ તટસ\u{acd}થ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗa"),
            keywords: &["mara danganta ga jinsi", "ƙarami", "ɗa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ילד"),
            keywords: &["א-בינארי", "ילד", "ילדה", "צעיר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बच\u{94d}चा"),
            keywords: &[
                "बच\u{94d}चा",
                "य\u{941}वा",
                "ल\u{948}\u{902}गिक र\u{942}प स\u{947} निष\u{94d}पक\u{94d}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dijete"),
            keywords: &["dijete", "mlado", "rodno neutralno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("gyerek"),
            keywords: &["gyerek", "gyermek"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("երեխա"),
            keywords: &["երեխա", "փոքրիկ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("anak"),
            keywords: &["anak", "gender tak tentu", "muda", "netral gender"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwata"),
            keywords: &["nwata", "obere nwa", "oke na nne-ndịnaetiti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("barn"),
            keywords: &["barn", "kynhlutlaust", "ungt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bimbo"),
            keywords: &["bimbo", "giovane"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("子供"),
            keywords: &["子供", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bocah"),
            keywords: &["bocah", "jender netral", "nom", "ora tamtu lanang wadone"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბავშვი"),
            keywords: &["ახალგაზრდა", "ბავშვი", "გენდერ-ნეიტრალური"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("agrud"),
            keywords: &["agrud"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бала"),
            keywords: &["бала"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}មេង"),
            keywords: &[
                "ក\u{17d2}មេង",
                "សម\u{17d2}រាប\u{17cb}ភេទទា\u{17c6}ងអស\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಗು"),
            keywords: &[
                "ಅನ\u{cbf}ರ\u{ccd}ದ\u{cbf}ಷ\u{ccd}ಟ ಲ\u{cbf}ಂಗ",
                "ಮಗು",
                "ಯುವ",
                "ಲ\u{cbf}ಂಗ-ತಟಸ\u{ccd}ಥ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("어린이"),
            keywords: &["어린이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("भ\u{941}रग\u{947}\u{902}"),
            keywords: &[
                "बाळक । तटस\u{94d}थ लि\u{902}ग। अनिर\u{94d}दिश\u{94d}ट लि\u{902}ग । तरणाटो",
                "भ\u{941}रग\u{947}\u{902}",
            ],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("zarok"),
            keywords: &["zarok"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чүрпө"),
            keywords: &["жынысы белгисиз", "кичинекей", "чүрпө"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Kand"),
            keywords: &["Kand", "jonk", "neutral"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb1}ກ"),
            keywords: &["ເດ\u{eb1}ກ", "ເພດກາງ", "ໜ\u{eb8}\u{ec8}ມ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vaikas"),
            keywords: &["jaunas", "neutrali lytis", "vaikas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bērns"),
            keywords: &["bezdzimuma", "bērns", "dzimumneitrāls", "jauns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tamaiti"),
            keywords: &["ira-kūpapa", "tamaiti", "tamariki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дете"),
            keywords: &["дете", "младо", "пол-неутрален"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d41}ട\u{d4d}ടി"),
            keywords: &[
                "അനിശ\u{d4d}ചിത ലിംഗഭേദം",
                "ക\u{d41}ട\u{d4d}ടി",
                "ചെറ\u{d41}പ\u{d4d}പം",
                "ലിംഗഭേദമില\u{d4d}ല",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хүүхэд"),
            keywords: &["жендер-саармаг", "залуу", "хүүхэд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{942}ल"),
            keywords: &["तर\u{942}ण", "म\u{942}ल", "लि\u{902}ग-तटस\u{94d}थ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kanak-kanak"),
            keywords: &["kanak-kanak", "muda"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tfal"),
            keywords: &["newtrali fil-ġeneru", "tfal", "żgħażagħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ကလေး"),
            keywords: &[
                "ကလေး",
                "ငယ\u{103a}ရ\u{103d}ယ\u{103a}သော",
                "လ\u{102d}င\u{103a}မခ\u{103d}\u{1032}ခြားသော",
                "လ\u{102d}င\u{103a}သတ\u{103a}မ\u{103e}တ\u{103a}မထားသော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("barn"),
            keywords: &["barn", "kjønnsnøytral", "menneske", "ung"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बच\u{94d}चा"),
            keywords: &[
                "बच\u{94d}चा",
                "ल\u{948}ङ\u{94d}गिक हिसाबल\u{947} तटस\u{94d}थ",
                "शिश\u{941}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("kind"),
            keywords: &["genderneutraal", "jong", "kind"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("barn"),
            keywords: &["barn", "kjønnsnøytral", "menneske", "ung"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଛୋଟ ପ\u{b3f}ଲ\u{b3e}"),
            keywords: &[
                "ଅନ\u{b3f}ର\u{b4d}ଦ\u{b4d}ଦ\u{b3f}ଷ\u{b4d}ଟ ଲ\u{b3f}ଙ\u{b4d}ଗ",
                "ଛୋଟ ପ\u{b3f}ଲ\u{b3e}",
                "ପ\u{b3f}ଲ\u{b3e}",
                "ଯ\u{b41}ବକ",
                "ଲ\u{b3f}ଙ\u{b4d}ଗ-ନ\u{b3f}ରପେକ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬ\u{a71}ਚਾ"),
            keywords: &["ਛ\u{a4b}ਟਾ ਬ\u{a71}ਚਾ", "ਬ\u{a71}ਚਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بال"),
            keywords: &["بال", "جوان", "غیر جانبدار-صنف"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smọ\u{301}l Pikin"),
            keywords: &[
                "Smọ\u{301}l Pikin",
                "Smọ\u{301}l Pikin Wé Dẹm Nó Tọk Wẹ\u{301}dá Na Man Ọ Wúman",
                "Smọ\u{301}l Pikin Wé Nọ\u{301} Bi Man Ọ Wúman",
                "Yọng",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dziecko"),
            keywords: &["dziecko", "młody", "płeć neutralna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ماشوم"),
            keywords: &["بې پلوه جنسیت", "غیرمعین جنس", "ماشوم", "ځوان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("criança"),
            keywords: &["criança"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["criança", "género neutro", "jovem", "novo", "pessoa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("irqi"),
            keywords: &[
                "genero",
                "irqi",
                "mana akllasqa",
                "neutral genero",
                "yuqalla",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("copil"),
            keywords: &["copil", "neutru", "tânăr"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1123"),
            keywords: &["E10-1123"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ребенок"),
            keywords: &["гендерно нейтральный", "дитя", "малыш", "ребенок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umwana"),
            keywords: &["ukiri muto", "umwana", "utagaragaza igitsina"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻار"),
            keywords: &["جنس غير جانبدار، جوان", "ٻار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ළමය\u{dcf}"),
            keywords: &[
                "තර\u{dd4}ණ",
                "දර\u{dd4}ව\u{dcf}",
                "නම\u{dca} නොකළ ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ප\u{dd4}ර\u{dd4}ෂ භ\u{dcf}වය",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ප\u{dd4}ර\u{dd4}ෂ",
                "ළමය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dieťa"),
            keywords: &["decko", "dieťa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("otrok"),
            keywords: &["otrok"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ilmo"),
            keywords: &[
                "dhexdhexaadnimada jinsiga",
                "ilmo",
                "jinsiga aan la sheegin",
                "yar",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fëmijë"),
            keywords: &["fëmijë", "minoren"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дете"),
            keywords: &["дете", "младост"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дијете"),
            keywords: &["дијете"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dete"),
            keywords: &["dete", "mladost"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("dijete"),
            keywords: &["dijete"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("barn"),
            keywords: &["barn", "könsneutral", "ung"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kijana"),
            keywords: &["asiyejitambulisha na jinsia yoyote", "kijana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறு குழந\u{bcd}தை"),
            keywords: &["குழந\u{bcd}தை", "சிறு குழந\u{bcd}தை", "மழலை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("శ\u{c3f}శువు"),
            keywords: &["యువ", "ల\u{c3f}ంగం-తటస\u{c4d}థం", "శ\u{c3f}శువు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("кӯдак"),
            keywords: &["баробарии ҷинсҳо", "кӯдак", "ҷавон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เด\u{e47}ก"),
            keywords: &["เด\u{e47}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çaga"),
            keywords: &[
                "jynsyýeti görkezilmedik",
                "jynsyýeti tapawut etmeýän",
                "çaga",
                "ýaş",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fānau"),
            keywords: &["fānau"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("çocuk"),
            keywords: &["genç", "kişi", "çocuk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بالا"),
            keywords: &["بالا", "جىنسسىز", "ياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дитина"),
            keywords: &[
                "гендерно-нейтральний",
                "дитина",
                "малеча",
                "неозначеної статі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بچہ"),
            keywords: &["بچہ", "صنفی غیر جانبدار", "نوجوان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("bola"),
            keywords: &["bola", "jinsi noaniq", "neytral jins", "yosh bola"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("trẻ em"),
            keywords: &[
                "giới tính chung",
                "giới tính không xác định",
                "trẻ",
                "trẻ em",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xale"),
            keywords: &["du góor du jigéen", "ndaw", "xale"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntwana"),
            keywords: &["engathathi-cala ngokwesini", "omtsha", "umntwana"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọmọ"),
            keywords: &["gé\u{329}ndà-ṣekuṣẹyẹ", "màjèsín", "ọmọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("小童"),
            keywords: &["中性", "小童", "年青"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("小童"),
            keywords: &["中性", "小童", "年青"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("儿童"),
            keywords: &["儿童", "年轻人", "性别不明", "性别中立"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("小孩"),
            keywords: &["小孩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ingane"),
            keywords: &["ingane", "mncane", "ubulili obuphakathi"],
        },
    ],
};
#[doc = "🧒🏻"]
pub const CHILD_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧒🏻",
    codepoint: "1F9D2 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "child: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧒🏼"]
pub const CHILD_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧒🏼",
    codepoint: "1F9D2 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "child: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧒🏽"]
pub const CHILD_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧒🏽",
    codepoint: "1F9D2 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "child: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧒🏾"]
pub const CHILD_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧒🏾",
    codepoint: "1F9D2 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "child: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧒🏿"]
pub const CHILD_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧒🏿",
    codepoint: "1F9D2 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "child: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👦"]
pub const BOY: crate::Emoji = crate::Emoji {
    glyph: "👦",
    codepoint: "1F466",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "boy",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("seun"),
            keywords: &["jonk", "kind", "seun"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወንድ ልጅ"),
            keywords: &["ተባዕት/ወንድ ልጅ", "ወንድ ልጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صبي"),
            keywords: &["ذكر", "صبي", "ولد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ল’ৰ\u{9be}"),
            keywords: &["তৰ\u{9c1}ণ", "ল’ৰ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("oğlan"),
            keywords: &["kişi", "oğlan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("хлопчык"),
            keywords: &["дзіця", "мужчына", "хлопчык"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("момче"),
            keywords: &["момче"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ছেলে"),
            keywords: &["ছেলে", "য\u{9c1}বক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("paotr"),
            keywords: &["paotr", "yaouank"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dječak"),
            keywords: &["dječak", "mladić"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("noi"),
            keywords: &["jove", "nen", "noi"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄛\u{11131}"),
            keywords: &["𑄟\u{11127}𑄢\u{11127}𑄘\u{11134} 𑄛\u{11131}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏧᏣ"),
            keywords: &["ᎠᏧᏣ", "ᎠᏫᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("chlapec"),
            keywords: &["chlapec", "hoch", "kluk"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bachgen"),
            keywords: &["bachgen", "gwrywaidd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("dreng"),
            keywords: &["dreng", "menneske", "person", "ung"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Junge"),
            keywords: &["Gesicht", "Junge"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αγόρι"),
            keywords: &["αγόρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("boy"),
            keywords: &["boy", "young"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["boy", "young", "young person"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("niño"),
            keywords: &["joven", "niño"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "chico", "joven", "nene", "niño", "persona"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["joven", "niño"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["chico", "joven", "niño"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("poiss"),
            keywords: &["noormees", "poiss"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mutila"),
            keywords: &["gizon", "mutil", "mutila"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پسر"),
            keywords: &["مذکر", "مرد", "پسر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("poika"),
            keywords: &["miespuolinen", "nuori", "poika"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("batang lalaki"),
            keywords: &["bata", "batang lalaki", "binatilyo", "lalaki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("drongur"),
            keywords: &["drongur", "piltur", "smádrongur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("garçon"),
            keywords: &["garçon", "jeune"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["garçon", "jeune"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("buachaill"),
            keywords: &["buachaill", "óg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gille"),
            keywords: &["balach", "gille", "òg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("neno"),
            keywords: &["neno", "rapaz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છોકરો"),
            keywords: &["છોકરો", "ય\u{ac1}વાન"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("yaro"),
            keywords: &["yaro", "ƙarami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בן"),
            keywords: &["בן", "ילד", "נער"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लड\u{93c}का"),
            keywords: &["लड\u{93c}का", "लोग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("dječak"),
            keywords: &["dečkić", "dečko", "dječak", "muško"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fiú"),
            keywords: &["fiú", "kisfiú", "srác"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղա"),
            keywords: &["տղա"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("anak laki-laki"),
            keywords: &["anak laki-laki", "muda"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwa nwoke"),
            keywords: &["nwa nwoke", "nwata", "nwoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("drengur"),
            keywords: &["drengur", "fólk", "strákur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bambino"),
            keywords: &["bambino", "persone", "ragazzino"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男の子"),
            keywords: &["子供", "少年", "男の子", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bocah lanang"),
            keywords: &["bocah lanang", "nom"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ბიჭი"),
            keywords: &["ახალგაზრდა", "ბიჭი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("aqruṛ"),
            keywords: &["aqruṛ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ұл"),
            keywords: &["ер бала", "ұл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("dreng"),
            keywords: &["dreng", "menneske", "person"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}មេងប\u{17d2}រ\u{17bb}ស"),
            keywords: &[
                "ក\u{17d2}មេងប\u{17d2}រ\u{17bb}ស",
                "ប\u{17d2}រ\u{17bb}ស",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខក\u{17d2}មេងប\u{17d2}រ\u{17bb}ស",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹುಡುಗ"),
            keywords: &["ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}", "ಹುಡುಗ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자 아이"),
            keywords: &["남자 아이", "소년"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चलो"),
            keywords: &["चलो", "सान"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бала"),
            keywords: &["бала", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Jong"),
            keywords: &["Jong", "jonk", "klengen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb1}ກຊາຍ"),
            keywords: &["ຄ\u{ebb}ນ", "ເດ\u{eb1}ກຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("berniukas"),
            keywords: &["berniukas", "jaunas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zēns"),
            keywords: &["puika", "seja", "zēns"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tamatāne"),
            keywords: &["tama", "tamariki", "tamatāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("момче"),
            keywords: &["машко", "момче"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ആൺക\u{d41}ട\u{d4d}ടി"),
            keywords: &["ആൺക\u{d41}ട\u{d4d}ടി", "ചെറ\u{d41}പ\u{d4d}പം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй хүүхэд"),
            keywords: &["хүүхэд", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{941}लगा"),
            keywords: &["तर\u{942}ण", "म\u{941}लगा"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kanak-kanak lelaki"),
            keywords: &["kanak-kanak lelaki", "lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tifel"),
            keywords: &["tifel", "żagħżugħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယောက\u{103a}ျားကလေး"),
            keywords: &["ယောက\u{103a}ျားကလေး", "အဖ\u{102d}\u{102f}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("gutt"),
            keywords: &["gutt", "menneske", "ung"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{947}टा"),
            keywords: &["क\u{947}टा", "जवान"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("jongen"),
            keywords: &["jong", "jongen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("gut"),
            keywords: &["gut", "menneske", "ung"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଳକ"),
            keywords: &["ବ\u{b3e}ଳକ", "ଯ\u{b41}ବକ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}\u{a70}ਡਾ"),
            keywords: &["ਜਵਾਨ", "ਨ\u{a4c}ਜਵਾਨ", "ਮ\u{a41}\u{a70}ਡਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منڈا"),
            keywords: &["جوان", "منڈا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smọ\u{301}l Bọi"),
            keywords: &["Bọi", "Smọ\u{301}l Bọi", "Yọng"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("chłopiec"),
            keywords: &["chłopiec"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هلک"),
            keywords: &["هلک", "ځوان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("menino"),
            keywords: &["jovem", "menino"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rapaz"),
            keywords: &["jovem", "menino", "pessoa", "rapaz"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yuqalla"),
            keywords: &["wayna", "yuqalla"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("băiat"),
            keywords: &["băiat", "copil", "tânăr"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-547"),
            keywords: &["E10-547"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мальчик"),
            keywords: &["дитя", "маленький", "малыш", "мальчик", "ребенок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuhungu"),
            keywords: &["mutoya", "umuhungu"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇوڪرو"),
            keywords: &["ڇوڪرو", "ڇوڪرو، جوان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}ම\u{dd2} ළමය\u{dcf}"),
            keywords: &[
                "ප\u{dd2}ර\u{dd2}ම\u{dd2} ළමය\u{dcf}",
                "ප\u{dd2}\u{dd2}ර\u{dd2}ම\u{dd2} ළමය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("chlapec"),
            keywords: &["chalan", "chlapec"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("fant"),
            keywords: &["deček", "fant"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("wiil"),
            keywords: &["wiil", "yar"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("djalë"),
            keywords: &["djalë", "mashkull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дечак"),
            keywords: &["дeчaк", "дечак", "младост"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дјечак"),
            keywords: &["дјечак"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dečak"),
            keywords: &["dečak", "mladost"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("dječak"),
            keywords: &["dječak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pojke"),
            keywords: &["kille", "pojke", "ung"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mvulana"),
            keywords: &["kijana", "mvulana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறுவன\u{bcd}"),
            keywords: &[
                "ஆடவர\u{bcd}",
                "ஆண\u{bcd}",
                "சிறுவன\u{bcd}",
                "பையன\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అబ\u{c4d}బ\u{c3e}య\u{c3f}"),
            keywords: &["అబ\u{c4d}బ\u{c3e}య\u{c3f}", "పురుషుడు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("писар"),
            keywords: &["писар", "ҷавон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เด\u{e47}กชาย"),
            keywords: &["คน", "เด\u{e47}กชาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("oglan"),
            keywords: &["oglan", "ýaş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tamasiʻi"),
            keywords: &["tamasiʻi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek çocuk"),
            keywords: &["erkek çocuk", "kişiler"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوغۇل"),
            keywords: &["ئوغۇل", "ياش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("хлопчик"),
            keywords: &["малеча", "хлопець", "хлопчик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لڑکا"),
            keywords: &["انسان", "لڑکا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘g‘il bola"),
            keywords: &["bola", "erkak", "o‘g‘il bola"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con trai"),
            keywords: &["con trai", "cậu bé"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xale bu góor"),
            keywords: &["ndaw", "xale bu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inkwenkwe"),
            keywords: &["inkwenkwe", "osemtsha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọmọkùnrin"),
            keywords: &["ọmọkùnrin", "ọ\u{300}dọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男仔"),
            keywords: &["年青", "男仔"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男仔"),
            keywords: &["年青", "男仔"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男孩"),
            keywords: &["儿童", "男孩"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男孩"),
            keywords: &["男孩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umfana"),
            keywords: &["umfana"],
        },
    ],
};
#[doc = "👦🏻"]
pub const BOY_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👦🏻",
    codepoint: "1F466 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "boy: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👦🏼"]
pub const BOY_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👦🏼",
    codepoint: "1F466 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "boy: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👦🏽"]
pub const BOY_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👦🏽",
    codepoint: "1F466 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "boy: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👦🏾"]
pub const BOY_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👦🏾",
    codepoint: "1F466 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "boy: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👦🏿"]
pub const BOY_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👦🏿",
    codepoint: "1F466 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "boy: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👧"]
pub const GIRL: crate::Emoji = crate::Emoji {
    glyph: "👧",
    codepoint: "1F467",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "girl",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("meisie"),
            keywords: &["diereriem", "jonk", "kind", "meisie", "virgo"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ልጃገረድ"),
            keywords: &["ልጃገረድ", "ቪርጎ", "ኮረዳ", "ዞድያክ", "ድንግል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فتاة"),
            keywords: &["أنثى", "بنت", "فتاة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছোৱ\u{9be}লী"),
            keywords: &[
                "কন\u{9cd}য\u{9be}ৰ\u{9be}শি",
                "ছোৱ\u{9be}লী",
                "তৰ\u{9c1}ণ",
                "ৰ\u{9be}শি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qız uşağı"),
            keywords: &["cavan", "qız bürcü", "qız uşağı", "zodiak"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дзяўчынка"),
            keywords: &[
                "дзева",
                "дзяўчынка",
                "дзіця",
                "жанчына",
                "задыяк",
                "малышка",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("момиче"),
            keywords: &["дева", "девойка", "момиче"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মেয\u{9bc}ে"),
            keywords: &[
                "কন\u{9cd}য\u{9be}র\u{9be}শি",
                "ক\u{9c1}ম\u{9be}রী",
                "তর\u{9c1}ণী",
                "মেয\u{9bc}ে",
                "র\u{9be}শিচক\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("placʼh"),
            keywords: &["placʼh", "yaouank"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("djevojčica"),
            keywords: &["Djevica", "djevojka", "djevojčica", "horoskop"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("noia"),
            keywords: &["jove", "nena", "noia"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄛\u{11131}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄛\u{11131}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏳᏣ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏳᏣ", "ᎦᏙᎩ", "ᏃᏈᏏ ᏓᏟᎶᏍᏗᎲᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dívka"),
            keywords: &["dívka", "děvče", "holka", "panna", "zvěrokruh"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("merch"),
            keywords: &["benywaidd", "ifanc", "merch", "y Forwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("pige"),
            keywords: &["menneske", "person", "pige", "ung"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mädchen"),
            keywords: &["Gesicht", "Mädchen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κορίτσι"),
            keywords: &["ζώδιο", "κορίτσι", "νεαρή", "παρθένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("girl"),
            keywords: &["Virgo", "girl", "young", "zodiac"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["Virgo", "girl", "young person", "zodiac"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("niña"),
            keywords: &["chica", "joven", "niña"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("niña"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["Virgo", "chica", "joven", "niña", "zodiaco"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tüdruk"),
            keywords: &["neiu", "plika", "tüdruk"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("neska"),
            keywords: &["emakume", "neska"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دختر"),
            keywords: &["باکره", "دختر", "دوشیزه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tyttö"),
            keywords: &[
                "horoskooppi",
                "horoskooppimerkki",
                "neiti",
                "neito",
                "neitsyt",
                "nuori",
                "tyttö",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("batang babae"),
            keywords: &["babae", "bata", "batang babae", "dalagita"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("genta"),
            keywords: &["genta", "smágenta"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("fille"),
            keywords: &["fille", "jeune", "vierge", "zodiaque"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cailín"),
            keywords: &["An Mhaighdean", "cailín", "stoidiaca", "óg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("caileag"),
            keywords: &["caileag", "grian-chriosach", "maighdeann", "òg"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nena"),
            keywords: &["Virgo", "nena", "rapaza", "zodíaco"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("છોકરી"),
            keywords: &["કન\u{acd}યા", "છોકરી", "ય\u{ac1}વાન", "રાશિ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("yarinya"),
            keywords: &["Virgo", "yarinya", "zodiac", "ƙarami"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בת"),
            keywords: &["בת", "ילדה", "נערה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लड\u{93c}की"),
            keywords: &["कन\u{94d}या", "य\u{941}वा", "राशि", "लड\u{93c}की"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("djevojčica"),
            keywords: &["djeva", "djevica", "djevojčica", "zodijak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lány"),
            keywords: &["kislány", "lány", "lányka"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աղջիկ"),
            keywords: &["աղջիկ", "կենդանակերպ", "կույս", "օրիորդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("anak perempuan"),
            keywords: &["anak perempuan", "muda", "virgo", "zodiak"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwata nwaanyị"),
            keywords: &["Nwata", "nwata nwaanyị", "vigo", "zodiak"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("stúlka"),
            keywords: &["meyja", "stelpa", "stjörnumerki", "stúlka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bambina"),
            keywords: &["bambina", "persone", "ragazzina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女の子"),
            keywords: &["女", "女の子", "子供", "少女", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("bocah wadon"),
            keywords: &["Virgo", "bocah wadon", "nom", "palintangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გოგო"),
            keywords: &["გოგო", "ზოდიაქო", "ქალიშვილი", "ქალწული", "ჰოროსკოპი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("Taqruṛt"),
            keywords: &["Taqruṛt"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қыз"),
            keywords: &["бикеш", "зодиак", "қыз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("pige"),
            keywords: &["menneske", "person", "pige"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ក\u{17d2}មេងស\u{17d2}រ\u{17b8}"),
            keywords: &[
                "ក\u{17d2}មេងស\u{17d2}រ\u{17b8}",
                "ម\u{17bb}ខ",
                "ម\u{17bb}ខក\u{17d2}មេងស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹುಡುಗ\u{cbf}"),
            keywords: &[
                "ಕನ\u{ccd}ನ\u{cc6}",
                "ಕನ\u{ccd}ಯಾರಾಶ\u{cbf}",
                "ರಾಶ\u{cbf}ಚಕ\u{ccd}ರ",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಹುಡುಗ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자 아이"),
            keywords: &["소녀", "여자 아이"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चली"),
            keywords: &["कन\u{94d}या", "चली", "रास", "सान"],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("keç"),
            keywords: &["keç"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кыз"),
            keywords: &["бийкеч", "зодиак", "кыз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Meedchen"),
            keywords: &["Jongfra", "Meedchen", "Stärzeechen", "jonk"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເດ\u{eb1}ກຍ\u{eb4}ງ"),
            keywords: &["ຄ\u{ebb}ນ", "ເດ\u{eb1}ກຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mergaitė"),
            keywords: &["jauna", "mergaitė", "mergelė", "zodiakas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("meitene"),
            keywords: &["Jaunava", "jauna", "meitene", "zodiaks"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōtiro"),
            keywords: &["Virgo", "kōtiro", "poutiriao", "tamariki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("девојче"),
            keywords: &["девојка", "девојче", "женско", "мома"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പെൺക\u{d41}ട\u{d4d}ടി"),
            keywords: &[
                "കന\u{d4d}നിര\u{d3e}ശി",
                "ചെറ\u{d41}പ\u{d4d}പം",
                "പെൺക\u{d41}ട\u{d4d}ടി",
                "ര\u{d3e}ശിചക\u{d4d}രം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй хүүхэд"),
            keywords: &["хүүхэд", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{941}लगी"),
            keywords: &["कन\u{94d}या", "तर\u{942}ण", "म\u{941}लगी", "राशी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("budak perempuan"),
            keywords: &["Virgo", "budak perempuan", "muda", "zodiak"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("tifla"),
            keywords: &["Virgo", "tifla", "żgħażagħ", "żodjaku"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မ\u{102d}န\u{103a}းကလေး"),
            keywords: &[
                "ကန\u{103a}ရာသ\u{102e}",
                "ငယ\u{103a}ရ\u{103d}ယ\u{103a}သ\u{1030}",
                "ဆယ\u{1037}\u{103a}န\u{103e}စ\u{103a}ရာသ\u{102e}ခ\u{103d}င\u{103a}",
                "မ\u{102d}န\u{103a}းကလေး",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("jente"),
            keywords: &[
                "Jomfruen",
                "jente",
                "menneske",
                "stjernebilde",
                "stjernetegn",
                "ung",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{947}टी"),
            keywords: &["कन\u{94d}या", "क\u{941}मारी", "क\u{947}टी", "राशि"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("meisje"),
            keywords: &["jong", "maagd", "meisje", "sterrenbeeld"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("jente"),
            keywords: &[
                "jente",
                "jomfrua",
                "menneske",
                "stjernebilete",
                "stjerneteikn",
                "ung",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b3e}ଳ\u{b3f}କ\u{b3e}"),
            keywords: &[
                "କନ\u{b4d}ୟ\u{b3e}",
                "ବ\u{b3e}ଳ\u{b3f}କ\u{b3e}",
                "ଯ\u{b41}ବକ",
                "ର\u{b3e}ଶ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a41}ੜੀ"),
            keywords: &["ਕ\u{a41}ੜੀ", "ਕ\u{a70}ਨਿਆ", "ਮ\u{a41}ਟਿਆਰ", "ਲੜਕੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کڑی"),
            keywords: &["ب\u{64f}رج", "ب\u{64f}رج سنبلہ", "جوان", "کڑی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Smọ\u{301}l Gẹl"),
            keywords: &["Gẹl", "Smọ\u{301}l Gẹl", "Vẹ\u{301}go", "Yọng", "Zódiak"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dziewczynka"),
            keywords: &["dziewczynka", "panna", "znak zodiaku"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نجلۍ"),
            keywords: &["د وږي مياشت", "زېږگه", "نجلۍ", "ځوان"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("menina"),
            keywords: &["garota", "menina"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("rapariga"),
            keywords: &["jovem", "menina", "pessoa", "rapariga"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi warma"),
            keywords: &["Virgo", "warmi warma", "wayna", "zodiaco"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("fată"),
            keywords: &["Fecioară", "copil", "fată", "tânără", "zodiac"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-548"),
            keywords: &["E10-548"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("девочка"),
            keywords: &["девочка", "дитя", "маленькая", "малышка", "ребенок"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umukobwa"),
            keywords: &["Virigo", "mutoya", "umukobwa", "zodiyake"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڇوڪري"),
            keywords: &["سنبلا، جوان، برج", "ڇوڪري"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ගැහ\u{dd4}ණ\u{dd4} ළමය\u{dcf}"),
            keywords: &[
                "කන\u{dca}\u{200d}ය\u{dcf} ර\u{dcf}ශ\u{dd2}ය",
                "කන\u{dca}\u{200d}ය\u{dcf}ව",
                "ගැහ\u{dd4}ණ\u{dd4} ළමය\u{dcf}",
                "තර\u{dd4}ණ\u{dd2}ය",
                "ර\u{dcf}ශ\u{dd3} චක\u{dca}\u{200d}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dievča"),
            keywords: &["dievča", "panna"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dekle"),
            keywords: &["dekle", "devica", "zodiak"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gabar"),
            keywords: &["gabar", "waalidka", "yar", "zodiac"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vajzë"),
            keywords: &["vajzë", "virgjëreshë", "zodiak"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("девојчица"),
            keywords: &["девица", "девојчица", "зодијак", "младост"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("дјевојчица"),
            keywords: &["дјевојчица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("devojčica"),
            keywords: &["devica", "devojčica", "mladost", "zodijak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("djevojčica"),
            keywords: &["djevojčica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("flicka"),
            keywords: &["flicka", "jungfru", "stjärntecken", "tjej", "ung"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("msichana"),
            keywords: &["bikira", "mashuke", "msichana", "mwali", "zodiaki"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சிறுமி"),
            keywords: &[
                "இளம\u{bcd} பெண\u{bcd}",
                "சிறுமி",
                "பெண\u{bcd}",
                "பொண\u{bcd}ணு",
                "மக\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("అమ\u{c4d}మ\u{c3e}య\u{c3f}"),
            keywords: &["అమ\u{c4d}మ\u{c3e}య\u{c3f}", "స\u{c4d}త\u{c4d}ర\u{c40}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("духтар"),
            keywords: &["Сунбула", "бурҷи дувоздаҳгона", "духтар", "ҷавон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เด\u{e47}กหญ\u{e34}ง"),
            keywords: &["คน", "เด\u{e47}กหญ\u{e34}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gyz"),
            keywords: &["Gyz", "gyz", "täleýnama", "ýaş"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("taʻahine"),
            keywords: &["taʻahine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kız çocuk"),
            keywords: &["genç", "kişiler", "kız çocuk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قىز"),
            keywords: &["قىز", "قىزچاق", "مۆچەل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("дівчинка"),
            keywords: &["діва", "дівчина", "дівчинка", "зодіак"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لڑکی"),
            keywords: &["انسان", "لڑکی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qiz bola"),
            keywords: &["bokira", "bo‘yi yetgan", "burj", "qiz bola", "sunbula"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("con gái"),
            keywords: &["Xử Nữ", "con gái", "cung hoàng đạo", "cô gái", "trẻ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("xale bu jigéen"),
            keywords: &["Wirgo", "ndaw", "sojak", "xale bu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("intombazana"),
            keywords: &["I-Virgo", "i-zodiac", "intombazana", "osemtsha"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọmọbìrin"),
            keywords: &["Virgo", "àmi oṣù ìbí", "ọmọbìrin", "ọ\u{300}dọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女仔"),
            keywords: &["女仔", "年青", "星座", "處女"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女仔"),
            keywords: &["处女", "女仔", "年青", "星座"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女孩"),
            keywords: &["儿童", "女孩"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女孩"),
            keywords: &["女孩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("intombazane"),
            keywords: &["indombazane", "intombazane", "intombi"],
        },
    ],
};
#[doc = "👧🏻"]
pub const GIRL_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👧🏻",
    codepoint: "1F467 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "girl: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👧🏼"]
pub const GIRL_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👧🏼",
    codepoint: "1F467 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "girl: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👧🏽"]
pub const GIRL_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👧🏽",
    codepoint: "1F467 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "girl: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👧🏾"]
pub const GIRL_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👧🏾",
    codepoint: "1F467 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "girl: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👧🏿"]
pub const GIRL_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👧🏿",
    codepoint: "1F467 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "girl: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑"]
pub const PERSON: crate::Emoji = crate::Emoji {
    glyph: "🧑",
    codepoint: "1F9D1",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("volwassene"),
            keywords: &[
                "geslagneutraal",
                "ongespesifiseerde geslag",
                "persoon",
                "volwassene",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጎልማሳ"),
            keywords: &["ጎልማሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بالغ"),
            keywords: &["بالغ", "شخص", "كبير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9cd}ৰ\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক"),
            keywords: &[
                "প\u{9cd}ৰ\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক",
                "লিংগ নিউট\u{9cd}ৰেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("böyük"),
            keywords: &["böyük", "gender-neytral"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дарослы"),
            keywords: &["дарослы", "дарослы чалавек", "няпэўнага полу"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("възрастен"),
            keywords: &[
                "без определен пол",
                "възрастен",
                "неутрален пол",
                "пълнолетен",
                "човек",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9cd}র\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক"),
            keywords: &[
                "প\u{9cd}র\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক",
                "লিঙ\u{9cd}গ-নিরপেক\u{9cd}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("den deuet"),
            keywords: &["den deuet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba"),
            keywords: &["neodređeni spol", "odrasla osoba", "osoba", "srednji rod"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona"),
            keywords: &["adult", "persona"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ"),
            keywords: &["ᎢᏳᏍᏗ ᎨᎲ ᏄᏬᎵᏍᏛᎾ", "ᎢᏳᏍᏗ ᎨᎲ-ᎢᏳᏍᏗᏊ", "ᎤᏔᎾ", "ᏴᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("dospělý člověk"),
            keywords: &["dospělák", "dospělý člověk", "neutrální", "osoba", "člověk"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person"),
            keywords: &["niwtral o ran rhyw", "oedolyn", "person"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("voksen"),
            keywords: &["person", "voksen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Erwachsener"),
            keywords: &[
                "Erwachsener",
                "Mensch",
                "Person",
                "erwachsene Person",
                "geschlechtsneutral",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ενήλικας"),
            keywords: &["άφυλος", "ενήλικας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person"),
            keywords: &["adult", "gender-neutral", "person", "unspecified gender"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona adulta"),
            keywords: &["género", "neutro", "persona adulta"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona"),
            keywords: &["género", "neutro", "persona", "persona adulta"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["género neutro", "género no especificado", "persona adulta"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("täiskasvanu"),
            keywords: &["sooliselt neutraalne", "täiskasvanu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona"),
            keywords: &["genero neutroko", "heldu", "pertsona"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بزرگسال"),
            keywords: &["بزرگسال", "جنس خنثی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aikuinen"),
            keywords: &[
                "aikaihminen",
                "aikuinen",
                "aikuisuus",
                "keski-ikäinen",
                "sukupuolineutraali",
                "täysikasvuinen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tao"),
            keywords: &[
                "hindi hindi tinukoy na kasarian",
                "kasarian-neutral",
                "matanda",
                "tao",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur"),
            keywords: &["persónur", "vaksin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("adulte"),
            keywords: &["adulte", "genre neutre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["adulte", "genre non défini", "personne"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("aosach"),
            keywords: &["aosach", "neodrach ó thaobh inscne de"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("inbheach"),
            keywords: &["gun ghnè", "inbheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa"),
            keywords: &[
                "adulto",
                "identidade sexual indeterminada",
                "persoa",
                "xénero neutro",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "અનિર\u{acd}દિષ\u{acd}ટ લિ\u{a82}ગ",
                "પ\u{ac1}ખ\u{acd}ત",
                "લિ\u{a82}ગ-તટસ\u{acd}થ",
                "વ\u{acd}યક\u{acd}તિ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babba"),
            keywords: &["babba", "mara danganta ga jinsi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם"),
            keywords: &["אדם", "בגיר", "ללא מגדר", "מבוגר", "מגדר נייטרלי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "ल\u{948}\u{902}गिक र\u{942}प स\u{947} निष\u{94d}पक\u{94d}ष",
                "वयस\u{94d}क",
                "व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("odrasla osoba"),
            keywords: &["odrasla osoba", "rodno neutralno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felnőtt"),
            keywords: &["felnőtt"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեծահասակ"),
            keywords: &["մեծահասակ", "չափահաս", "չեզոք սեռ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dewasa"),
            keywords: &["dewasa", "gender tak tentu", "netral gender", "orang"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okenye"),
            keywords: &["oke na nne-ndịnaetiti", "okenye"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("manneskja"),
            keywords: &["fullorðinn", "kynhlutlaust", "manneskja"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona"),
            keywords: &["adulto", "persona"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("大人"),
            keywords: &["大人", "成人", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong"),
            keywords: &[
                "jender netral",
                "ora tamtu lanang wadone",
                "wong",
                "wong diwasa",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სრულწლოვანი"),
            keywords: &["გენდერ-ნეიტრალური", "სრულწლოვანი", "სქესის მიუთითებლად"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amengaḍ"),
            keywords: &["amengaḍ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ересек"),
            keywords: &["ересек"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សធ\u{17c6}"),
            keywords: &[
                "មន\u{17bb}ស\u{17d2}ស",
                "មន\u{17bb}ស\u{17d2}សធ\u{17c6}",
                "មន\u{17bb}ស\u{17d2}សពេញវ\u{17d0}យ",
                "ម\u{17b7}នបញ\u{17d2}ជាក\u{17cb}ភេទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಅನ\u{cbf}ರ\u{ccd}ದ\u{cbf}ಷ\u{ccd}ಟ ಲ\u{cbf}ಂಗ",
                "ಲ\u{cbf}ಂಗ-ತಟಸ\u{ccd}ಥ",
                "ವಯಸ\u{ccd}ಕ",
                "ವಯಸ\u{ccd}ಕರು",
                "ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사람"),
            keywords: &["사람", "성별 없음", "성인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "प\u{94d}रौढ । तटस\u{94d}थ लि\u{902}ग । व\u{94d}यक\u{94d}ती । अनिर\u{94d}दिश\u{94d}ट लि\u{902}ग",
                "व\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("kes"),
            keywords: &["kes"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("адам"),
            keywords: &["адам", "жынысы белгисиз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Erwuessenen"),
            keywords: &["Erwuessenen", "neutral"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ໃຫຍ\u{ec8}"),
            keywords: &["ຜ\u{eb9}\u{ec9}ໃຫຍ\u{ec8}", "ເພດກາງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("suaugusysis"),
            keywords: &["neutrali lytis", "suaugusysis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pieaugušais"),
            keywords: &["bezdzimuma", "dzimumneitrāls", "pieaugušais"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pakeke"),
            keywords: &["ira-kūpapa", "pakeke"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("возрасно лице"),
            keywords: &["возрасно лице", "пол-неутрален"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "അനിശ\u{d4d}ചിത ലിംഗഭേദം",
                "മ\u{d41}തിർന\u{d4d}നയ\u{d3e}ൾ",
                "ലിംഗഭേദമില\u{d4d}ല",
                "വ\u{d4d}യക\u{d4d}തി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("том хүн"),
            keywords: &["жендер-саармаг", "том хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तर\u{942}ण"),
            keywords: &["तर\u{942}ण", "लि\u{902}ग-तटस\u{94d}थ"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dewasa"),
            keywords: &["dewasa", "gender-neutral"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("adult"),
            keywords: &["adult", "newtrali fil-ġeneru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လ\u{1030}"),
            keywords: &[
                "လ\u{102d}င\u{103a}မခ\u{103d}\u{1032}ခြားသော",
                "လ\u{102d}င\u{103a}သတ\u{103a}မ\u{103e}တ\u{103a}မထားသော",
                "လ\u{1030}",
                "အရ\u{103d}ယ\u{103a}ရောက\u{103a}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("voksen"),
            keywords: &["kjønnsnøytral", "menneske", "person", "voksen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("वयस\u{94d}क"),
            keywords: &[
                "ल\u{948}ङ\u{94d}गिक हिसाबल\u{947} तटस\u{94d}थ",
                "वयस\u{94d}क",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("volwassene"),
            keywords: &["genderneutraal", "volwassene"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vaksen"),
            keywords: &["kjønnsnøytral", "menneske", "person", "vaksen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ଅନ\u{b3f}ର\u{b4d}ଦ\u{b4d}ଦ\u{b3f}ଷ\u{b4d}ଟ ଲ\u{b3f}ଙ\u{b4d}ଗ",
                "ପ\u{b4d}ର\u{b3e}ପ\u{b4d}ତ ବୟସ\u{b4d}କ",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}ତ\u{b4d}ୱ",
                "ଲ\u{b3f}ଙ\u{b4d}ଗ-ନ\u{b3f}ରପେକ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵਿਅਕਤੀ"),
            keywords: &["ਬਾਲਗ", "ਵਿਅਕਤੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بالغ"),
            keywords: &["بالغ", "غیر جانبدار-صنف"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin"),
            keywords: &[
                "Machọ\u{301} Pẹ\u{301}sin",
                "Pẹ\u{301}sin",
                "Pẹ\u{301}sin Wé Dẹm Nó Tọk Wẹ\u{301}dá Na Man Ọ Wúman",
                "Pẹ\u{301}sin Wé Nọ\u{301} Bi Man Ọ Wúman",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dorosły"),
            keywords: &["dorosły", "płeć neutralna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص"),
            keywords: &["بالغ", "شخص", "نامعلومه جنس", "نرښځۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa"),
            keywords: &["adulto", "gênero não especificado", "pessoa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["adulta", "adulto", "género neutro", "pessoa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa"),
            keywords: &[
                "genero neutral",
                "mana akllasqa genero",
                "puriq runa",
                "runa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("adult"),
            keywords: &["adult", "neutru", "persoană"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1122"),
            keywords: &["E10-1122"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("взрослый"),
            keywords: &["взрослый", "гендерно нейтральный", "совершеннолетний"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu mukuru"),
            keywords: &["umuntu mukuru", "utagaragaza igitsina"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("بالغ"),
            keywords: &["بالغ", "غيرجانبدار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}ය\u{dcf}"),
            keywords: &[
                "නම\u{dca} නොකළ ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ප\u{dd4}ර\u{dd4}ෂ භ\u{dcf}වය",
                "ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}",
                "වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}ය\u{dcf}",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ප\u{dd4}ර\u{dd4}ෂ භ\u{dcf}වය උද\u{dcf}ස\u{dd3}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("dospelý"),
            keywords: &["dospelá", "dospelý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odrasla oseba"),
            keywords: &["odrasla oseba"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof"),
            keywords: &[
                "dhexdhexaadnimada jinsiga",
                "jinsiga aan la sheegin",
                "qof",
                "qof weyn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("fëmijë i rritur"),
            keywords: &[
                "adoleshent",
                "adoleshente",
                "e rritur",
                "fëmijë i rritur",
                "i rritur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("одрасла особа"),
            keywords: &["неутралан пол", "одрасла особа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("odrasla osoba"),
            keywords: &["neutralan pol", "odrasla osoba"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("person"),
            keywords: &["könsneutral", "person", "vuxen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu mzima"),
            keywords: &["asiyejitambulisha na jinsia yoyote", "mtu mzima"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வயது வந\u{bcd}தவர\u{bcd}"),
            keywords: &["ஆண\u{bcd}", "பெண\u{bcd}", "வயது வந\u{bcd}தவர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వయ\u{c4b}జనుడు"),
            keywords: &["ల\u{c3f}ంగం-తటస\u{c4d}థం", "వయ\u{c4b}జనుడు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калонсол"),
            keywords: &["баробарии ҷинсҳо", "калонсол"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คน"),
            keywords: &[
                "คน",
                "ผ\u{e39}\u{e49}ใหญ\u{e48}",
                "เป\u{e47}นกลางทางเพศ",
                "ไม\u{e48}ระบ\u{e38}เพศ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şahs"),
            keywords: &[
                "adam",
                "jynsyýeti görkezilmedik",
                "jynsyýeti tapawut etmeýän",
                "uly ýaşly",
                "şahs",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kakai lalahi"),
            keywords: &["kakai lalahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yetişkin"),
            keywords: &["kişi", "yetişkin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چوڭلار"),
            keywords: &["جىنىسسىز", "چوڭلار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина"),
            keywords: &[
                "гендерно-нейтральний",
                "дорослий",
                "людина",
                "неозначеної статі",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("شخص"),
            keywords: &["بالغ", "شخص", "صنفی غیر جانبدار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("voyaga yetgan"),
            keywords: &[
                "jinsi noaniq",
                "katta",
                "neytral jins",
                "shaxs",
                "voyaga yetgan",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người"),
            keywords: &[
                "giới tính chung",
                "giới tính không xác định",
                "người",
                "người lớn",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mag"),
            keywords: &["du góor du jigéen", "mag"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu omdala"),
            keywords: &["engathathi-cala ngokwesini", "umntu omdala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àgbà"),
            keywords: &["gé\u{329}ndà-ṣekuṣẹyẹ", "àgbà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("成人"),
            keywords: &["中性", "成人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("成人"),
            keywords: &["中性", "成人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("成人"),
            keywords: &["性别中立", "性格不明", "成人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("大人"),
            keywords: &["大人"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("mdala"),
            keywords: &["mdala", "ubulili-phakathi"],
        },
    ],
};
#[doc = "🧑🏻"]
pub const PERSON_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻",
    codepoint: "1F9D1 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼",
    codepoint: "1F9D1 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽"]
pub const PERSON_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽",
    codepoint: "1F9D1 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾",
    codepoint: "1F9D1 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿"]
pub const PERSON_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿",
    codepoint: "1F9D1 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👱"]
pub const PERSON_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱",
    codepoint: "1F471",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "person: blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon met blonde hare"),
            keywords: &["blond", "hare", "persoon met blonde hare"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጎልማሳ/ሉጫ ጸጉር ያለው"),
            keywords: &["ሉጫ", "ሉጫ ጸጉር ያለው ሰው", "ጎልማሳ/ሉጫ ጸጉር ያለው", "ጸጉር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص أشقر"),
            keywords: &["أشقر", "شخص أشقر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9cd}যক\u{9cd}তি: সোণ\u{9be}লী চ\u{9c1}লি"),
            keywords: &[
                "চ\u{9c1}লি",
                "ব\u{9cd}যক\u{9cd}তি: সোণ\u{9be}লী চ\u{9c1}লি",
                "সোণ\u{9be}লী চ\u{9c1}লিৰ ব\u{9cd}যক\u{9cd}তি",
                "স\u{9cd}বৰ\u{9cd}ণকেশী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarı saçlı adam"),
            keywords: &["sarı saçlı adam", "sarışın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бялявы чалавек"),
            keywords: &["бялявы", "бялявы чалавек"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("блондин/ка"),
            keywords: &["блондин", "блондин/ка", "блондинка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}যক\u{9cd}তি: স\u{9cd}বর\u{9cd}ণকেশী চ\u{9c1}ল"),
            keywords: &[
                "চ\u{9c1}ল",
                "ব\u{9cd}যক\u{9cd}তি: স\u{9cd}বর\u{9cd}ণকেশী চ\u{9c1}ল",
                "স\u{9cd}বর\u{9cd}ণ-কেশী ব\u{9cd}যক\u{9cd}তি",
                "স\u{9cd}বর\u{9cd}ণকেশী",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("den melegan"),
            keywords: &["den", "melegan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba s plavom kosom"),
            keywords: &["kosa", "osoba s plavom kosom", "plavo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona: cabells rossos"),
            keywords: &[
                "cabells",
                "persona amb els cabells rossos",
                "persona: cabells rossos",
                "ros",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏴᏫ: ᏓᎶᏂᎨ-ᎤᏍᏘᎩ"),
            keywords: &["ᎤᏍᏘᎩ", "ᏓᎶᏂᎨ", "ᏓᎶᏂᎨ-ᎤᏍᏘᎩ ᏴᏫ", "ᏴᏫ: ᏓᎶᏂᎨ-ᎤᏍᏘᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("člověk s blond vlasy"),
            keywords: &["blond", "světlé vlasy", "člověk s blond vlasy"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person â gwallt golau"),
            keywords: &["gwallt golau", "person â gwallt golau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blond person"),
            keywords: &["blond", "blond person", "hår"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Person: blondes Haar"),
            keywords: &[
                "Gesicht",
                "Person: blondes Haar",
                "blonde Haare",
                "blonde Person",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο: ξανθά μαλλιά"),
            keywords: &["άτομο: ξανθά μαλλιά", "μαλλιά", "ξανθός", "ξανθός άνθρωπος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person: blond hair"),
            keywords: &["blond", "blond-haired person", "hair", "person: blond hair"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona adulta rubia"),
            keywords: &["persona adulta rubia", "rubia", "rubias", "rubio", "rubios"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "persona", "persona adulta rubia", "rubio"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cara", "persona adulta rubia", "persona rubia"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("inimene: blondide juustega"),
            keywords: &[
                "blond",
                "blondide juustega inimene",
                "blondiin",
                "inimene: blondide juustega",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona ilehoria"),
            keywords: &["ile", "ilehori", "pertsona ilehoria"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("آدم: موبلوند"),
            keywords: &["آدم بلوند", "آدم: موبلوند", "بلوند", "بور", "طلایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaaleatukkainen henkilö"),
            keywords: &[
                "blondi",
                "hiukset",
                "vaalea",
                "vaaleahiuksinen henkilö",
                "vaaleatukkainen henkilö",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong may blond na buhok"),
            keywords: &[
                "blond",
                "buhok",
                "lalaki",
                "tao",
                "taong may blond na buhok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljóshærdur persónur"),
            keywords: &["fólk", "ljóshærd", "ljóshærdur", "ljóshærdur persónur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne blonde"),
            keywords: &["blond", "cheveux", "personne blonde"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["blond", "personne blonde"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine: gruaig fhionn"),
            keywords: &[
                "duine le gruaig fhionn",
                "duine: gruaig fhionn",
                "fionn",
                "gruaig",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("neach le falt bàn"),
            keywords: &["bàn", "falt", "neach le falt bàn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa loura"),
            keywords: &["loiro", "louro", "persoa loira", "persoa loura"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પીળાશ પડતા\u{a82} વાળવાળી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "પીળાશ પડતા\u{a82} વાળ",
                "પીળાશ પડતા\u{a82} વાળવાળી વ\u{acd}યક\u{acd}તિ",
                "વાળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutum mai farin gashi"),
            keywords: &["mai farin gashi", "mutum mai farin gashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם עם שיער בלונדיני"),
            keywords: &["אדם עם שיער בלונדיני", "בלונד", "בלונדיני"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भ\u{942}र\u{947} बालो\u{902} वाला आदमी"),
            keywords: &[
                "भ\u{942}र\u{947} बालो\u{902} वाला आदमी",
                "लोग",
                "स\u{941}नहर\u{947} बाल",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plavokosa osoba"),
            keywords: &["kosa", "plava kosa", "plavokosa osoba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szőke hajú ember"),
            keywords: &["szőke", "szőke hajú ember"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շիկահեր մարդ"),
            keywords: &["շեկ", "շիկահեր", "շիկահեր մարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang: rambut pirang"),
            keywords: &[
                "orang berambut pirang",
                "orang: rambut pirang",
                "pirang",
                "rambut",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("Onye-isi awọ"),
            keywords: &["Onye-isi awọ", "isi awọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ljóshærð manneskja"),
            keywords: &["fólk", "ljóshærð manneskja", "ljóst hár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona bionda"),
            keywords: &["biondo", "persona bionda", "persone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("金髪の人"),
            keywords: &["ブロンド", "人", "金髪", "金髪の人", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong: rambute pirang"),
            keywords: &[
                "pirang",
                "rambut",
                "wong arambut pirang",
                "wong: rambute pirang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქერათმიანი ადამიანი"),
            keywords: &["ქერა", "ქერათმიანი ადამიანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аққұба адам"),
            keywords: &["аққұба", "аққұба адам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("person"),
            keywords: &["blond person", "menneske", "person"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សសក\u{17cb}ទង\u{17cb}ដែង"),
            keywords: &[
                "ទង\u{17cb}ដែង",
                "មន\u{17bb}ស\u{17d2}សសក\u{17cb}ទង\u{17cb}ដែង",
                "សក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಹೊಂಬಣ\u{ccd}ಣದ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("금발인 사람"),
            keywords: &["금발", "금발인 사람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती: पि\u{902}गश\u{947} क\u{947}\u{902}स"),
            keywords: &[
                "क\u{947}\u{902}स",
                "पि\u{902}गश\u{947}",
                "पि\u{902}गश\u{94d}या क\u{947}\u{902}साचो व\u{94d}यक\u{94d}ती: पि\u{902}गश\u{947} क\u{947}\u{902}स",
                "व\u{94d}यक\u{94d}ती",
                "व\u{94d}यक\u{94d}ती: पि\u{902}गश\u{947} क\u{947}\u{902}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сары чачтуу киши"),
            keywords: &["сары чач", "сары чачтуу киши"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("blond Persoun"),
            keywords: &["blond", "blond Persoun"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນຜ\u{ebb}ມສ\u{eb5}ເຫ\u{ebc}\u{eb7}ອງອ\u{ec8}ອນ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ຄ\u{ebb}ນຜ\u{ebb}ມສ\u{eb5}ເຫ\u{ebc}\u{eb7}ອງອ\u{ec8}ອນ",
                "ຜ\u{ebb}ມສ\u{eb5}ເຫ\u{ebc}\u{eb7}ອງອ\u{ec8}ອນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("šviesiaplaukis žmogus"),
            keywords: &["šviesiaplaukis", "šviesiaplaukis žmogus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("blonds cilvēks"),
            keywords: &["blonds", "blonds cilvēks", "seja"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata mākekehu"),
            keywords: &["mākekehu", "tangata mākekehu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("русокосо лице"),
            keywords: &["коса", "русокос", "русокосо лице"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d4d}യക\u{d4d}തി: സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടി"),
            keywords: &[
                "തലമ\u{d41}ടി",
                "വ\u{d4d}യക\u{d4d}തി: സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടി",
                "സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടിയ\u{d41}ള\u{d4d}ള വ\u{d4d}യക\u{d4d}തി",
                "സ\u{d4d}വർണ\u{d4d}ണവർണ\u{d4d}ണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шаргал үстэй хүн"),
            keywords: &["хүн", "шаргал", "шаргал үстэй хүн", "үс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सोन\u{947}री क\u{947}सा\u{902}ची व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "क\u{947}स",
                "सोन\u{947}री",
                "सोन\u{947}री क\u{947}सा\u{902}ची व\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang: rambut perang"),
            keywords: &[
                "orang berambut perang",
                "orang: rambut perang",
                "perang",
                "rambut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna b’xagħar isfar"),
            keywords: &["persuna b’xagħar isfar", "xagħara isfar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030}"),
            keywords: &[
                "ဆ\u{1036}ကေသာ",
                "ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာ",
                "ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030}",
                "ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သောသ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Person: blond"),
            keywords: &["Person: blond", "blond", "blond person", "hår", "menneske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{948}लो कपाल भएको मान\u{94d}छ\u{947}"),
            keywords: &[
                "क\u{948}लो कपाल भएको मान\u{94d}छ\u{947}",
                "फ\u{941}ल\u{947}को",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon met blond haar"),
            keywords: &["blond", "haar", "persoon met blond haar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Person: blond"),
            keywords: &["Person: blond", "blond", "blond person", "hår", "menneske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}: ସ\u{b41}ନେଲ\u{b3f} କେଶ"),
            keywords: &[
                "କେଶ",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}: ସ\u{b41}ନେଲ\u{b3f} କେଶ",
                "ସ\u{b41}ନେଲ\u{b3f}",
                "ସ\u{b41}ନେଲ\u{b3f}-କେଶ ଥ\u{b3f}ବ\u{b3e} ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}ਨਿਹਰੀ ਵਾਲਾ\u{a02} ਵਾਲਾ ਵਿਅਕਤੀ"),
            keywords: &["ਸ\u{a41}ਨਿਹਰੀ ਵਾਲ", "ਸ\u{a41}ਨਿਹਰੀ ਵਾਲਾ\u{a02} ਵਾਲਾ ਵਿਅਕਤੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}ھورے والاں آلا بندہ"),
            keywords: &["ب\u{64f}ھورے والاں آلا بندہ", "گورے رنگ آلی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Gẹ\u{301}t Blọ\u{301}nd Hea"),
            keywords: &[
                "Blọnd",
                "Pẹ\u{301}sin Wé Gẹ\u{301}t Blọ\u{301}nd Hea",
                "Pẹ\u{301}sin Wé Gẹ\u{301}t Blọ\u{301}nd Hea Hea",
                "Pẹ\u{301}sin: Blọ\u{301}nd Hea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba z włosami blond"),
            keywords: &["blond", "osoba z włosami blond", "włosy"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شخص: د سرو ويښتانو"),
            keywords: &[
                "د زيړ ويښتانو",
                "د زيړ ويښتانو شخص",
                "شخص: د سرو ويښتانو",
                "وېښتان",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pessoa: cabelo louro"),
            keywords: &[
                "cabelo",
                "loiro",
                "louro",
                "pessoa loira",
                "pessoa loura",
                "pessoa: cabelo louro",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "loira",
                "loiro",
                "loura",
                "louro",
                "pessoa com cabelo loiro",
                "pessoa com cabelo louro",
                "pessoa: cabelo louro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa: qʼillu chukcha"),
            keywords: &[
                "chukcha",
                "qʼillu",
                "qʼillu chukcha runa",
                "runa: qʼillu chukcha",
                "runa:qʼillu chukcha",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană blondă"),
            keywords: &[
                "blond",
                "om",
                "persoană blondă",
                "persoană cu păr blond",
                "păr",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-558"),
            keywords: &["E10-558"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("человек со светлыми волосами"),
            keywords: &[
                "блондин",
                "волосы",
                "светлые",
                "человек",
                "человек со светлыми волосами",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu ufite imisatsi y’umweru"),
            keywords: &["inzobe", "umuntu ufite imisatsi y’umweru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخش: سنهڙا وار"),
            keywords: &[
                "شخش: سنهڙا وار",
                "شخص: سنهڙا وار",
                "ننڍڙا وار",
                "ننڍڙي وارن وارو شخص",
                "وار",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තඹ පැහැ කොණ\u{dca}ඩය සහ\u{dd2}ත ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "තඹ පැහැ",
                "තඹ පැහැ කොණ\u{dca}ඩය සහ\u{dd2}ත ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("svetlovlasý človek"),
            keywords: &["blond", "svetlovlasý človek"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba: svetli lasje"),
            keywords: &[
                "lasje",
                "oseba: svetli lasje",
                "svetli lasje",
                "svetlolasa oseba",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof: timo cad"),
            keywords: &["qof timo cad leh", "qof: timo cad", "timo", "timo cad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri biond"),
            keywords: &["biond", "njeri biond"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа са плавом косом"),
            keywords: &["особа са плавом косом", "плaвa кoсa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba sa plavom kosom"),
            keywords: &["osoba sa plavom kosom", "plava kosa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blond person"),
            keywords: &["blond", "blond person", "människor"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu mwenye nywele za shaba"),
            keywords: &[
                "mtu mwenye nywele ya shaba",
                "mtu mwenye nywele za shaba",
                "mtu: nywele ya shaba",
                "nywele",
                "rangi ya shaba",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பொன\u{bcd} நிறத\u{bcd}தில\u{bcd} முடி கொண\u{bcd}டவர\u{bcd}"),
            keywords: &[
                "பொன\u{bcd} நிறத\u{bcd}தில\u{bcd} முடி கொண\u{bcd}டவர\u{bcd}",
                "பொன\u{bcd} நிறம\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
                "மஞ\u{bcd}சள\u{bcd} நிறம\u{bcd}",
                "முடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ర\u{c3e}గ\u{c3f} రంగు జుట\u{c4d}టు గల వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "జుట\u{c4d}టు",
                "ర\u{c3e}గ\u{c3f}",
                "ర\u{c3e}గ\u{c3f} రంగు జుట\u{c4d}టు గల వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахси зардинамӯй"),
            keywords: &["зардинамӯй", "шахси зардинамӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนผมทอง"),
            keywords: &["คนผมทอง", "ผม", "ผมทอง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("adam: sary saçly"),
            keywords: &["adam: sary saçly", "sary saçly", "saç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha ʻulu kelo"),
            keywords: &["tokotaha ʻulu kelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarışın kişi"),
            keywords: &["sarı saçlı kişi", "sarışın", "sarışın kişi", "saç"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئالتۇن چاچ كىشى"),
            keywords: &["ئالتۇن چاچ", "ئالتۇن چاچ كىشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина з білявим волоссям"),
            keywords: &[
                "біляве",
                "волосся",
                "людина з білявим волоссям",
                "людина: біляве волосся",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سنہرے بالوں والا شخص"),
            keywords: &["بال", "بندہ", "سنہرے", "سنہرے بالوں والا شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shaxs: mallasoch"),
            keywords: &["mallasoch", "sariq sochli odam", "shaxs: mallasoch", "soch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người tóc vàng hoe"),
            keywords: &["người tóc vàng hoe", "người: tóc vàng hoe", "tóc vàng hoe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit ku karaw yu weex"),
            keywords: &["karaw gu mboq", "nit ku karaw yu weex"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu oneenwele ezimhlophe"),
            keywords: &["mhlophe", "umntu oneenwele ezimhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Eniyan Onirun funfun"),
            keywords: &["Eniyan Onirun funfun", "oníru funfun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("金色頭髮嘅人"),
            keywords: &["金色頭髮", "金色頭髮嘅人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("金色头发嘅人"),
            keywords: &["金色头发", "金色头发嘅人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("金色头发的人"),
            keywords: &["金发", "金色头发的人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("金髮人"),
            keywords: &["金髮", "金髮人"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("金髮嘅人"),
            keywords: &["金頭髮", "金髮人", "金髮嘅人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu: izinwele ezinhlophe"),
            keywords: &[
                "izinwele",
                "mhlophe",
                "umuntu onezinwele ezimhlophe",
                "umuntu: izinwele ezinhlophe",
            ],
        },
    ],
};
#[doc = "👱🏻"]
pub const PERSON_LIGHT_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏻",
    codepoint: "1F471 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person: light skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👱🏼"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏼",
    codepoint: "1F471 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person: medium-light skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👱🏽"]
pub const PERSON_MEDIUM_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏽",
    codepoint: "1F471 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person: medium skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👱🏾"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏾",
    codepoint: "1F471 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person: medium-dark skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👱🏿"]
pub const PERSON_DARK_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏿",
    codepoint: "1F471 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "person: dark skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨"]
pub const MAN: crate::Emoji = crate::Emoji {
    glyph: "👨",
    codepoint: "1F468",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "man",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man"),
            keywords: &["man", "volwassene"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰው"),
            keywords: &["ሰው", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل"),
            keywords: &["بالغ", "رجل", "شخص", "كبير"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}নিহ"),
            keywords: &["প\u{9c1}ৰ\u{9c1}ষ", "ম\u{9c1}নিহ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi"),
            keywords: &["kişi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына"),
            keywords: &["мужчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж"),
            keywords: &["мъж"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ"),
            keywords: &["নর", "প\u{9c1}র\u{9c1}ষ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwaz"),
            keywords: &["deuet", "gwaz"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac"),
            keywords: &["muškarac", "muško", "odrasla osoba"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home"),
            keywords: &["home", "masculí"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟𑄚\u{1112a}𑄌\u{11134}"),
            keywords: &["𑄟𑄚\u{1112a}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ"),
            keywords: &["ᎠᏍᎦᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž"),
            keywords: &["muž"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn"),
            keywords: &["dyn", "oedolyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand"),
            keywords: &["mand", "menneske", "person"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann"),
            keywords: &["Mann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας"),
            keywords: &["άντρας", "ενήλικας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man"),
            keywords: &["adult", "man"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre"),
            keywords: &["adulto", "hombre"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "hombre", "persona", "señor"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["adulto", "cara", "hombre", "persona", "señor"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mees"),
            keywords: &["mees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizona"),
            keywords: &["gizon", "gizona", "gizonezko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد"),
            keywords: &["آقا", "مرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("mies"),
            keywords: &["mies", "miespuolinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaki"),
            keywords: &["lalaki", "matanda"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður"),
            keywords: &["mannfólk", "maður", "vaksin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme"),
            keywords: &["homme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["adulte", "homme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear"),
            keywords: &["fear"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine"),
            keywords: &["duine", "fear", "fireannach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home"),
            keywords: &["adulto", "home"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &["પ\u{ac1}ખ\u{acd}ત", "પ\u{ac1}ર\u{ac1}ષ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji"),
            keywords: &["namiji"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איש"),
            keywords: &["איש", "גבר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{941}र\u{941}ष"),
            keywords: &["प\u{941}र\u{941}ष", "लोग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac"),
            keywords: &["muškarac", "muško"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi"),
            keywords: &["férfi"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տղամարդ"),
            keywords: &["տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria"),
            keywords: &["orang dewasa", "pria"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke"),
            keywords: &["nwoke"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karl"),
            keywords: &["fólk", "karl", "maður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo"),
            keywords: &["maschio", "persone", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("男性"),
            keywords: &["大人", "男", "男性", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang"),
            keywords: &["lanang", "wong diwasa", "wong lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი"),
            keywords: &["ზრდასრული", "კაცი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("argaz"),
            keywords: &["argaz"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер адам"),
            keywords: &["ер", "ер адам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mand"),
            keywords: &["mand", "menneske", "person"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រស"),
            keywords: &[
                "ប\u{17bb}រស",
                "ប\u{17d2}រ\u{17bb}ស",
                "មន\u{17bb}ស\u{17d2}សធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ"),
            keywords: &["ಪುರುಷ", "ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("남자"),
            keywords: &["남성", "남자", "성인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो"),
            keywords: &["दादलो", "प\u{94d}रौढ"],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("mêr"),
            keywords: &["mêr"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эркек"),
            keywords: &["киши", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mann"),
            keywords: &["Mann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍ"),
            keywords: &["ຄ\u{ebb}ນ", "ຜ\u{eb9}\u{ec9}ຊາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyras"),
            keywords: &["vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis"),
            keywords: &["kungs", "seja", "vīrietis", "vīrs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne"),
            keywords: &["tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж"),
            keywords: &["маж", "машко"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ര\u{d41}ഷൻ"),
            keywords: &["പ\u{d41}ര\u{d41}ഷൻ", "മ\u{d41}തിർന\u{d4d}നയ\u{d3e}ൾ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй хүн"),
            keywords: &["хүн", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष"),
            keywords: &["प\u{941}र\u{942}ष"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki"),
            keywords: &["dewasa", "lelaki"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel"),
            keywords: &["raġel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား"),
            keywords: &["အဖ\u{102d}\u{102f}", "အမျ\u{102d}\u{102f}းသား"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann"),
            keywords: &["mann", "menneske", "voksen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरामान\u{94d}छ\u{947}"),
            keywords: &["छोरामान\u{94d}छ\u{947}", "प\u{941}र\u{942}ष"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man"),
            keywords: &["man"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann"),
            keywords: &["mann", "menneske", "vaksen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ"),
            keywords: &["ପ\u{b41}ର\u{b41}ଷ", "ବୟସ\u{b4d}କ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਦਮੀ"),
            keywords: &["ਆਦਮੀ", "ਬ\u{a70}ਦਾ", "ਲ\u{a4b}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بندہ"),
            keywords: &["بندہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man"),
            keywords: &["Machọ\u{301} Pẹ\u{301}sin", "Man"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna"),
            keywords: &["mężczyzna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی"),
            keywords: &["سړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem"),
            keywords: &["adulto", "homem"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["adulto", "homem", "pessoa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tata"),
            keywords: &["puriq runa", "tata"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat"),
            keywords: &["adult", "bărbat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-549"),
            keywords: &["E10-549"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мужчина"),
            keywords: &["взрослый", "мужчина", "усы", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo"),
            keywords: &["umugabo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو"),
            keywords: &["ماڻهو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ර\u{dd2}\u{dd2}ම\u{dd2}ය\u{dcf}"),
            keywords: &[
                "ප\u{dd2}ර\u{dd2}\u{dd2}ම\u{dd2}ය\u{dcf}",
                "ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("muž"),
            keywords: &["dospelý", "muž"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški"),
            keywords: &["fant", "moški"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ninka"),
            keywords: &["nin", "ninka", "qof weyn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë"),
            keywords: &["burrë", "mashkull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац"),
            keywords: &["мушкaрaц", "мушкарац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac"),
            keywords: &["muškarac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man"),
            keywords: &["man", "vuxen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume"),
            keywords: &["mtu mzima", "mwanamume"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ஆண\u{bcd}"),
            keywords: &["ஆண\u{bcd}", "ஆண\u{bcd}மகன\u{bcd}", "மக\u{bcd}கள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుషుడు"),
            keywords: &["పురుషుడు", "మగ\u{c3e}డు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мард"),
            keywords: &["мард"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชาย"),
            keywords: &["คน", "ผ\u{e39}\u{e49}ชาย"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek"),
            keywords: &["erkek", "erkek adam", "uly ýaşly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata"),
            keywords: &["tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek"),
            keywords: &["erkek", "kişiler"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئەر"),
            keywords: &["ئەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік"),
            keywords: &["дорослий", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد"),
            keywords: &["انسان", "مرد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak"),
            keywords: &["erkak", "katta yoshli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đàn ông"),
            keywords: &["người lớn", "đàn ông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor"),
            keywords: &["góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda"),
            keywords: &["indoda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọkùnrin"),
            keywords: &["Ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男人"),
            keywords: &["男人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男人"),
            keywords: &["男人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("男人"),
            keywords: &["成人", "男人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男人"),
            keywords: &["男", "男人", "男性"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda"),
            keywords: &["indoda", "owesilisa", "ubaba"],
        },
    ],
};
#[doc = "👨🏻"]
pub const MAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏻",
    codepoint: "1F468 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "man: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏼",
    codepoint: "1F468 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "man: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽"]
pub const MAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏽",
    codepoint: "1F468 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "man: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾"]
pub const MAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏾",
    codepoint: "1F468 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "man: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿"]
pub const MAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👨🏿",
    codepoint: "1F468 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "man: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧔"]
pub const PERSON_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔",
    codepoint: "1F9D4",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bebaarde persoon"),
            keywords: &["baard", "bebaarde persoon", "man"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጺማም ሰው"),
            keywords: &["ጺማም ሰው"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("شخص بلحية"),
            keywords: &["شخص بلحية", "شخص مع لحية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ: দ\u{9be}ঢ\u{9bc}ি"),
            keywords: &[
                "দ\u{9be}ঢ\u{9bc}ি",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ: দ\u{9be}ঢ\u{9bc}ি",
                "ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("saqqallı şəxs"),
            keywords: &["saqqal", "saqqallı şəxs"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек з барадой"),
            keywords: &["барада", "чалавек з барадой"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("човек с брада"),
            keywords: &["брада", "човек с брада"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9be}ড\u{9bc}িওয\u{9bc}\u{9be}ল\u{9be} ব\u{9cd}যক\u{9cd}তি"),
            keywords: &[
                "দ\u{9be}ড\u{9bc}ি",
                "দ\u{9be}ড\u{9bc}িওয\u{9bc}\u{9be}ল\u{9be} প\u{9c1}র\u{9c1}ষ",
                "দ\u{9be}ড\u{9bc}িওয\u{9bc}\u{9be}ল\u{9be} ব\u{9cd}যক\u{9cd}তি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("osoba s bradom"),
            keywords: &["brada", "muškarac s bradom", "osoba s bradom"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona: barba"),
            keywords: &["barba", "persona", "persona: barba"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ: ᏗᎭᏄᎸᎯ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ: ᏗᎭᏄᎸᎯ", "ᏗᎭᏄᎸᎯ", "ᏴᏫ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("osoba s plnovousem"),
            keywords: &["osoba s plnovousem", "plnovous", "vous", "vousáč"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person: barf"),
            keywords: &["barf", "dyn â barf", "person barfog", "person: barf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("person med skæg"),
            keywords: &["fuldskæg", "person", "person med skæg", "skæg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Person: Bart"),
            keywords: &["Bart", "Mensch: Bart", "Person mit Bart", "Person: Bart"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άτομο: μούσι"),
            keywords: &["άτομο", "άτομο: μούσι", "μούσι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("person: beard"),
            keywords: &["beard", "person", "person: beard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre con barba"),
            keywords: &["barbas", "barbudo", "hombre", "hombre con barba", "persona"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "barba",
                "barbón",
                "cara",
                "hombre con barba",
                "persona con barba",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mees: habemega"),
            keywords: &["habe", "habemega isik", "mees: habemega"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("pertsona bizarduna"),
            keywords: &["bizar", "pertsona bizarduna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد: ریش\u{200c}دار"),
            keywords: &[
                "آدم",
                "ریشو",
                "ریش\u{200c}دار",
                "مرد",
                "مرد: ریش\u{200c}دار",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("parrakas henkilö"),
            keywords: &[
                "karvainen",
                "parrakas henkilö",
                "parta",
                "pulisongit",
                "sänki",
                "viikset",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("taong may balbas"),
            keywords: &["balbas", "lalaki: balbas", "tao", "taong may balbas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("persónur við skeggi"),
            keywords: &["persónur", "persónur við skeggi", "skegg"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne barbue"),
            keywords: &["barbe", "personne barbue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "barbe",
                "barbu",
                "homme barbu",
                "personne",
                "personne barbue",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("duine: feasóg"),
            keywords: &["duine", "duine: feasóg", "fear", "fear: feasóg", "feasóg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine le feusag"),
            keywords: &["duine le feusag", "feusag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa con barba"),
            keywords: &["barba", "barbudo", "persoa con barba"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દાઢી વાળી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "દાઢી",
                "દાઢી વાળી વ\u{acd}યક\u{acd}તિ",
                "પ\u{ac1}ર\u{ac1}ષ",
                "વ\u{acd}યક\u{acd}તિ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mutumi mai gemu"),
            keywords: &["gemu", "mutumi mai gemu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אדם מזוקן"),
            keywords: &["אדם מזוקן", "זקן", "מזוקן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाढ\u{93c}ी वाला आदमी"),
            keywords: &["दाढ\u{93c}ी", "दाढ\u{93c}ी वाला आदमी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac s bradom"),
            keywords: &["brada", "muškarac", "muškarac s bradom", "osoba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szakállas ember"),
            keywords: &["szakáll", "szakállas ember"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մորուքով մարդ"),
            keywords: &["մորուք", "մորուքով մարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("orang: janggut"),
            keywords: &["janggut", "orang", "orang: janggut"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("onye nwere ahụọnụ"),
            keywords: &["onye nwere ahụọnụ", "àhụọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("maður með skegg"),
            keywords: &["maður með skegg", "skegg"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona con la barba"),
            keywords: &["barba", "persona", "persona con la barba"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あごひげの人"),
            keywords: &["あごひげ", "あごひげの人", "ひげ", "人", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong: jenggot"),
            keywords: &["jenggot", "wong", "wong: jenggot"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("წვეროსანი"),
            keywords: &["წვერი", "წვეროსანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сақалды ер адам"),
            keywords: &["сақалды адам", "сақалды ер адам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សមានព\u{17bb}កចង\u{17d2}កា"),
            keywords: &[
                "ប\u{17bb}រស",
                "ប\u{17bb}រសមានព\u{17bb}កចង\u{17d2}កា",
                "ព\u{17bb}កចង\u{17d2}កា",
                "មន\u{17bb}ស\u{17d2}ស",
                "មន\u{17bb}ស\u{17d2}សមានព\u{17bb}កចង\u{17d2}កា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗಡ\u{ccd}ಡಧಾರ\u{cbf} ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"),
            keywords: &[
                "ಗಡ\u{ccd}ಡ",
                "ಗಡ\u{ccd}ಡಧಾರ\u{cbf} ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수염 난 사람"),
            keywords: &["사람", "수염", "수염 난 사람"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{94d}यक\u{94d}ती:खाड"),
            keywords: &["खाड", "व\u{94d}यक\u{94d}ती", "व\u{94d}यक\u{94d}ती:खाड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сакалчан киши"),
            keywords: &["сакал", "сакалчан киши"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Persoun mat Baart"),
            keywords: &["Baart", "Persoun mat Baart"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນມ\u{eb5}ໜວດ"),
            keywords: &["ຄ\u{ebb}ນມ\u{eb5}ໜວດ", "ໜວດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("barzdotas žmogus"),
            keywords: &["barzda", "barzdotas žmogus"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bārdains vīrietis"),
            keywords: &["bārda", "bārdaina persona", "bārdains vīrietis", "persona"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tangata pāhau"),
            keywords: &["pāhau", "tangata pāhau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("забраден човек"),
            keywords: &["брада", "забраден човек"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d4d}യക\u{d4d}തി: ത\u{d3e}ടി"),
            keywords: &[
                "ത\u{d3e}ടി",
                "വ\u{d4d}യക\u{d4d}തി",
                "വ\u{d4d}യക\u{d4d}തി: ത\u{d3e}ടി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сахалтай хүн"),
            keywords: &["сахал", "сахалтай хүн"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दाढी असल\u{947}ली व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "दाढी",
                "दाढी असल\u{947}ली व\u{94d}यक\u{94d}ती",
                "प\u{941}र\u{941}ष",
                "व\u{94d}यक\u{94d}ती",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang: janggut"),
            keywords: &["janggut", "orang", "orang: janggut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("persuna bil-baffi"),
            keywords: &["baffi", "persuna bil-baffi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသား- မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}ရ\u{103e}\u{102d}သ\u{1030}",
            ),
            keywords: &[
                "မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}",
                "လ\u{1030}",
                "အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား- မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}ရ\u{103e}\u{102d}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("person: skjegg"),
            keywords: &[
                "mann",
                "mann med skjegg",
                "mann: skjegg",
                "person",
                "person: skjegg",
                "skjegg",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दाह\u{94d}रीवाल मान\u{94d}छ\u{947}"),
            keywords: &["दाह\u{94d}री", "दाह\u{94d}रीवाल मान\u{94d}छ\u{947}"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("persoon: baard"),
            keywords: &["baard", "persoon", "persoon: baard"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("person: skjegg"),
            keywords: &[
                "mann",
                "mann med skjegg",
                "mann: skjegg",
                "person",
                "person: skjegg",
                "skjegg",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ: ଦ\u{b3e}ଢ\u{b3c}\u{b3f}"),
            keywords: &[
                "ଦ\u{b3e}ଢ\u{b3f}",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ: ଦ\u{b3e}ଢ\u{b3c}\u{b3f}",
                "ପ\u{b41}ର\u{b41}ଷ: ଦ\u{b3e}ଢ\u{b3f}",
                "ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਾੜ\u{a4d}ਹੀ ਵਾਲਾ ਬ\u{a70}ਦਾ"),
            keywords: &["ਦਾੜ\u{a4d}ਹੀ", "ਦਾੜ\u{a4d}ਹੀ ਵਾਲਾ ਬ\u{a70}ਦਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("داڑھی آلا بندا"),
            keywords: &["داڑھی", "داڑھی آلا بندا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pẹ\u{301}sin Wé Gẹ\u{301}t Biabiá"),
            keywords: &[
                "Biabiá",
                "Pẹ\u{301}sin",
                "Pẹ\u{301}sin Wé Gẹ\u{301}t Biabiá",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("osoba z brodą"),
            keywords: &["broda", "osoba", "osoba z brodą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی: ږيره"),
            keywords: &["سړی", "سړی: ږيره", "شخص", "ږيره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem: barba"),
            keywords: &["barba", "barbudo", "homem", "homem: barba", "pessoa"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa: barba"),
            keywords: &["barba", "pessoa", "pessoa: barba"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa: kʼaki"),
            keywords: &["kʼaki", "runa", "runa: kʼaki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat cu barbă"),
            keywords: &["barbă", "bărbat", "bărbat cu barbă", "persoană"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1125"),
            keywords: &["E10-1125"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бородатый человек"),
            keywords: &["борода", "бородатый человек", "бородач", "мужчина"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu ufite ubwanwa"),
            keywords: &["ubwanwa", "umuntu ufite ubwanwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("شخص: ڏاڙهي"),
            keywords: &["شخص: ڏاڙهي", "ماڻهو", "ماڻهو: ڏاڙهي", "ڏاڙهي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("රැව\u{dd4}ල සහ\u{dd2}ත ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "රැව\u{dd4}ල",
                "රැව\u{dd4}ල සහ\u{dd2}ත ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bradáč"),
            keywords: &["brada", "bradáč", "fúzatý", "fúzy"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba: brada"),
            keywords: &["brada", "moški", "moški: brada", "oseba", "oseba: brada"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin: gar"),
            keywords: &["gar", "nin", "nin: gar", "qof"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njëri me mjekër"),
            keywords: &["mjekër", "njëri me mjekër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("особа са брадом"),
            keywords: &["брада", "особа са брадом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("osoba sa bradom"),
            keywords: &["brada", "osoba sa bradom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man med skägg"),
            keywords: &["man med skägg", "person med skägg", "skägg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mtu mwenye ndevu"),
            keywords: &["mtu", "mtu mwenye ndevu", "mtu: ndevu", "ndevu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bbe}டி வைத\u{bcd}தவர\u{bcd}"),
            keywords: &["ஆண\u{bcd}", "த\u{bbe}டி", "த\u{bbe}டி வைத\u{bcd}தவர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుషుడు; గడ\u{c4d}డం"),
            keywords: &[
                "గడ\u{c4d}డం",
                "గడ\u{c4d}డం గల వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "పురుషుడు",
                "పురుషుడు; గడ\u{c4d}డం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("шахси ришдор"),
            keywords: &["риш", "шахси ришдор"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายม\u{e35}เครา"),
            keywords: &[
                "คน",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายม\u{e35}เครา",
                "ม\u{e35}เครา",
                "หนวดเครา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("kişi: sakal"),
            keywords: &["kişi: sakal", "sakal", "şahs", "şahs: sakal"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha kava"),
            keywords: &["kava", "tokotaha"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sakallı kişi"),
            keywords: &["sakal", "sakallı kişi"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ساقاللىق كىشى"),
            keywords: &["ساقال", "ساقاللىق كىشى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("людина з бородою"),
            keywords: &["борода", "бородань", "людина з бородою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("داڑھی والا شخص"),
            keywords: &["داڑھی", "داڑھی والا شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak: soqolli"),
            keywords: &[
                "erkak",
                "erkak: soqol",
                "erkak: soqolli",
                "shaxs",
                "soqol",
                "soqolli",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người có râu"),
            keywords: &["người", "người có râu", "người đàn ông có râu", "râu"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nit am sikkim"),
            keywords: &["nit am sikkim", "sikkim"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu oneentshebe"),
            keywords: &["iintshebe", "umntu oneentshebe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("apárí"),
            keywords: &["apárí", "irùngbọ\u{300}n"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("留鬚嘅人"),
            keywords: &["留鬚嘅人", "鬚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("留须嘅人"),
            keywords: &["留须嘅人", "须"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("有胡子的人"),
            keywords: &["人", "有胡子的人", "男", "络腮胡", "胡子", "胡须"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("蓄鬍的人"),
            keywords: &["蓄鬍的人"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("留鬚嘅人"),
            keywords: &["留鬚嘅人", "鬍鬚", "鬚"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda: intshebe"),
            keywords: &["indoda", "indoda: intshebe", "intshebe", "umuntu"],
        },
    ],
};
#[doc = "🧔🏻"]
pub const PERSON_LIGHT_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏻",
    codepoint: "1F9D4 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: light skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧔🏼"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏼",
    codepoint: "1F9D4 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: medium-light skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧔🏽"]
pub const PERSON_MEDIUM_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏽",
    codepoint: "1F9D4 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: medium skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧔🏾"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏾",
    codepoint: "1F9D4 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: medium-dark skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧔🏿"]
pub const PERSON_DARK_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏿",
    codepoint: "1F9D4 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "person: dark skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧔\u{200d}♂\u{fe0f}"]
pub const MAN_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔\u{200d}♂\u{fe0f}",
    codepoint: "1F9D4 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "man: beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔\u{200d}♂",
        codepoint: "1F9D4 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "man: beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("man: baard"),
            keywords: &["baard", "baard: man", "man", "man: baard"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሰው: ጺም"),
            keywords: &["ሰው: ጺም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل بلحية"),
            keywords: &["رجل", "رجل بلحية", "رجل مع لحية", "لحية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ: দ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "দ\u{9be}ড\u{9bc}ি",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ: দ\u{9be}ড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("kişi; saqqal"),
            keywords: &["kişi", "kişi: saqqal", "kişi; saqqal", "saqqal"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мужчына: барада"),
            keywords: &["барада", "мужчына", "мужчына: барада"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мъж: брада"),
            keywords: &["брада", "мъж", "мъж: брада"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ: দ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "দ\u{9be}ড\u{9bc}ি",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ: দ\u{9be}ড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac s bradom"),
            keywords: &[
                "brada",
                "muškarac",
                "muškarac s bradom",
                "muškarac: s bradom",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home: barba"),
            keywords: &["barba", "home", "home: barba"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("muž s plnovousem"),
            keywords: &["muž s plnovousem", "plnovous", "vous", "vousáč"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn: barf"),
            keywords: &["barf", "dyn", "dyn: barf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mand med skæg"),
            keywords: &["fuldskæg", "mand", "mand med skæg", "skæg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann: Bart"),
            keywords: &["Mann: Bart"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας: μούσι"),
            keywords: &["άντρας", "άντρας: μούσι", "μούσι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man: beard"),
            keywords: &["beard", "man", "man: beard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre: barba"),
            keywords: &["barba", "hombre", "hombre: barba"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("hombre: barba"),
            keywords: &["barba", "hombre: barba"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["hombre: barba"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("habemega mees"),
            keywords: &["habe", "habemega mees", "mees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizona: bizarra"),
            keywords: &["bizarra", "gizona", "gizona: bizarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد: ریش"),
            keywords: &["ریش", "مرد", "مرد: ریش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("parrakas mies"),
            keywords: &["mies", "parrakas mies", "parta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaki: balbas"),
            keywords: &["balbas", "lalaki", "lalaki: balbas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("maður við skeggi"),
            keywords: &["maður", "maður við skeggi", "skegg"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme barbu"),
            keywords: &["barbe", "homme barbu"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("homme barbu"),
            keywords: &["barbe", "homme", "homme barbu"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear: feasóg"),
            keywords: &["fear", "fear: feasóg", "feasóg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fireannach: feusag"),
            keywords: &[
                "duine",
                "fear",
                "feusag",
                "fireannach",
                "fireannach: feusag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home con barba"),
            keywords: &["barba", "barbudo", "home con barba"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ : દાઢી"),
            keywords: &[
                "દાઢી",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ : દાઢી",
                "પ\u{ac1}ર\u{ac1}ષ: દાઢી",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גבר עם זקן"),
            keywords: &["גבר עם זקן", "גבר, זקן, גבר עם זקן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आदमी: दाढ\u{93c}ी"),
            keywords: &["आदमी", "आदमी: दाढ\u{93c}ी", "दाढ\u{93c}ी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("muškarac: brada"),
            keywords: &["brada", "muškarac", "muškarac: brada"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("férfi: szakáll"),
            keywords: &["férfi: szakáll"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մորուքավոր տղամարդ"),
            keywords: &["մորուք", "մորուքավոր", "մորուքով տղամարդ", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria: janggut"),
            keywords: &["janggut", "pria", "pria: janggut"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("karl: skegg"),
            keywords: &["karl", "karl: skegg", "skegg"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo con la barba"),
            keywords: &["barba", "uomo", "uomo con la barba"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あごひげの男性"),
            keywords: &["あごひげ", "あごひげの男性", "ひげ", "男", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang: jenggot"),
            keywords: &["jenggot", "wong lanang", "wong lanang: jenggot"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კაცი: წვერი"),
            keywords: &["კაცი: წვერი", "მამაკაცი", "მამაკაცი: წვერი", "წვერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ер адам: сақал"),
            keywords: &["ер адам: сақал"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រស៖ ព\u{17bb}កចង\u{17d2}កា"),
            keywords: &[
                "ប\u{17bb}រស",
                "ប\u{17bb}រស៖ ព\u{17bb}កចង\u{17d2}កា",
                "ព\u{17bb}កចង\u{17d2}កា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪುರುಷ: ಗಡ\u{ccd}ಡ"),
            keywords: &["ಗಡ\u{ccd}ಡ", "ಪುರುಷ", "ಪುರುಷ: ಗಡ\u{ccd}ಡ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수염 난 남자"),
            keywords: &["남자", "수염", "수염 난 남자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो मनीस: खाड"),
            keywords: &["खाड", "दादलो", "दादलो मनीस: खाड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("киши: сакал"),
            keywords: &["киши", "киши: сакал", "сакал"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍມ\u{eb5}ໜວດ"),
            keywords: &["ຜ\u{eb9}\u{ec9}ຊາຍ", "ຜ\u{eb9}\u{ec9}ຊາຍມ\u{eb5}ໜວດ", "ໜວດ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vyras: barzda"),
            keywords: &["barzda", "vyras", "vyras: barzda"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vīrietis ar bārdu"),
            keywords: &["bārda", "vīrietis", "vīrietis ar bārdu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("маж: брада"),
            keywords: &["брада", "маж", "маж: брада"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ര\u{d41}ഷൻ: ത\u{d3e}ടി"),
            keywords: &["പ\u{d41}ര\u{d41}ഷൻ: ത\u{d3e}ടി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эрэгтэй: сахал"),
            keywords: &["сахал", "эрэгтэй", "эрэгтэй: сахал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{941}र\u{942}ष: दाढी"),
            keywords: &[
                "दाढी",
                "दाढी असल\u{947}ला प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष",
                "प\u{941}र\u{942}ष: दाढी",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki: janggut"),
            keywords: &["janggut", "lelaki", "lelaki: janggut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသား - မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}"),
            keywords: &[
                "မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}",
                "အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား - မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann: skjegg"),
            keywords: &["mann", "mann: skjegg", "skjegg"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{941}र\u{941}ष: दाह\u{94d}री"),
            keywords: &[
                "दाह\u{94d}री",
                "प\u{941}र\u{941}ष",
                "प\u{941}र\u{941}ष: दाह\u{94d}री",
                "प\u{941}र\u{941}ष:दाह\u{94d}री",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man: baard"),
            keywords: &["baard", "man", "man: baard"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann: skjegg"),
            keywords: &["mann", "mann: skjegg", "skjegg"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਆਦਮੀ: ਦਾੜ\u{a4d}ਹੀ"),
            keywords: &["ਆਦਮੀ", "ਆਦਮੀ: ਦਾੜ\u{a4d}ਹੀ", "ਦਾੜ\u{a4d}ਹੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé Gẹ\u{301}t Biabiá"),
            keywords: &["Biabiá", "Man", "Man Wé Gẹ\u{301}t Biabiá"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mężczyzna z brodą"),
            keywords: &["broda", "mężczyzna", "mężczyzna z brodą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی: ږیره"),
            keywords: &["سړی", "سړی: ږیره", "ږیره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem: barbudo"),
            keywords: &["barba", "homem", "homem: barba", "homem: barbudo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("homem: barba"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa: kaki"),
            keywords: &["kaki", "runa", "runa: kaki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat: barbă"),
            keywords: &["barbă", "bărbat", "bărbat: barbă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-005"),
            keywords: &["E13.1-005"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бородатый мужчина"),
            keywords: &["борода", "бородатый мужчина", "мужчина"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو: ڏاڙهي"),
            keywords: &["ماڻهو", "ماڻهو: ڏاڙهي", "ڏاڙهي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}න\u{dd2}ස\u{dcf}: රැව\u{dd4}ල"),
            keywords: &[
                "ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "ම\u{dd2}න\u{dd2}ස\u{dcf}: රැව\u{dd4}ල",
                "රැව\u{dd4}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bradatý muž"),
            keywords: &["brada", "bradatý muž", "muž"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški: brada"),
            keywords: &["brada", "moški", "moški: brada"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin: gadh"),
            keywords: &["gadh", "nin", "nin: gadh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë: mjekër"),
            keywords: &["burrë", "burrë: mjekër", "mjekër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мушкарац: брада"),
            keywords: &["брада", "мушкарац: брада", "човек", "човек: брада"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["мушкарац: брада"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("muškarac: brada"),
            keywords: &["brada", "muškarac: brada", "čovek", "čovek: brada"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["muškarac: brada"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("man: skägg"),
            keywords: &["man", "man: skägg", "skägg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume: ndevu"),
            keywords: &["mwanamume", "mwanamume: ndevu", "ndevu"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bbe}டி வைத\u{bcd}த ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "த\u{bbe}டி",
                "த\u{bbe}டி வைத\u{bcd}த ஆண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పురుషుడు: గ\u{c46}డ\u{c4d}డం"),
            keywords: &[
                "గ\u{c46}డ\u{c4d}డం",
                "పురుషుడు",
                "పురుషుడు: గ\u{c46}డ\u{c4d}డం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชายม\u{e35}เครา"),
            keywords: &[
                "ชายม\u{e35}เครา",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายม\u{e35}เครา",
                "ม\u{e35}เครา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("adam: sakal"),
            keywords: &["adam", "adam: sakal", "sakal"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata kava"),
            keywords: &["kava", "tangata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("erkek: sakal"),
            keywords: &["erkek", "erkek: sakal", "sakal"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік із бородою"),
            keywords: &["борода", "бородатий", "чоловік із бородою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مرد: داڑھی"),
            keywords: &["داڑھی", "مرد", "مرد: داڑھی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("soqolli erkak"),
            keywords: &["erkak", "soqol", "soqolli erkak"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông có râu"),
            keywords: &["người đàn ông", "người đàn ông có râu", "râu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("男人：鬍鬚"),
            keywords: &["男人", "男人：鬍鬚", "鬍鬚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("男人：胡须"),
            keywords: &["男人", "男人：胡须", "胡须"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("有络腮胡子的男人"),
            keywords: &["有络腮胡子的男人", "男人", "胡子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("男人: 蓄鬍的人"),
            keywords: &["男人", "男人: 蓄鬍的人", "鬍子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "🧔🏻\u{200d}♂\u{fe0f}"]
pub const MAN_LIGHT_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F9D4 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "man: light skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏻\u{200d}♂",
        codepoint: "1F9D4 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "man: light skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏼\u{200d}♂\u{fe0f}"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F9D4 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "man: medium-light skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏼\u{200d}♂",
        codepoint: "1F9D4 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "man: medium-light skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏽\u{200d}♂\u{fe0f}"]
pub const MAN_MEDIUM_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F9D4 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "man: medium skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏽\u{200d}♂",
        codepoint: "1F9D4 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "man: medium skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏾\u{200d}♂\u{fe0f}"]
pub const MAN_MEDIUM_DARK_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F9D4 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "man: medium-dark skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏾\u{200d}♂",
        codepoint: "1F9D4 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "man: medium-dark skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏿\u{200d}♂\u{fe0f}"]
pub const MAN_DARK_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F9D4 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "man: dark skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏿\u{200d}♂",
        codepoint: "1F9D4 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "man: dark skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔\u{200d}♀\u{fe0f}"]
pub const WOMAN_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔\u{200d}♀\u{fe0f}",
    codepoint: "1F9D4 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "woman: beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔\u{200d}♀",
        codepoint: "1F9D4 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "woman: beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou: baard"),
            keywords: &["baard", "vrou", "vrou: baard"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት: ጺም"),
            keywords: &["ሴት: ጺም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("امرأة بلحية"),
            keywords: &["امرأة", "امرأة بلحية", "امرأة مع لحية", "لحية"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}: দ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "দ\u{9be}ড\u{9bc}ি",
                "মহিল\u{9be}",
                "মহিল\u{9be}: দ\u{9be}ড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın: saqqal"),
            keywords: &["kişi", "kişi: saqqal", "qadın: saqqal", "saqqal"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына: барада"),
            keywords: &["барада", "жанчына", "жанчына: барада"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена: брада"),
            keywords: &["брада", "жена", "жена: брада"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}: দ\u{9be}ড\u{9bc}ি"),
            keywords: &[
                "দ\u{9be}ড\u{9bc}ি",
                "মহিল\u{9be}",
                "মহিল\u{9be}: দ\u{9be}ড\u{9bc}ি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena: brada"),
            keywords: &["brada", "žena", "žena: brada"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona: barba"),
            keywords: &["barba", "dona", "dona: barba"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena s plnovousem"),
            keywords: &[
                "plnovous",
                "vous",
                "vousatá žena",
                "žena",
                "žena s plnovousem",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw: barf"),
            keywords: &["barf", "fenyw", "menyw: barf"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde med skæg"),
            keywords: &["fuldskæg", "kvinde", "kvinde med skæg", "skæg"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau: Bart"),
            keywords: &["Frau: Bart"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα: μούσι"),
            keywords: &["γυναίκα", "γυναίκα: μούσι", "μούσι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman: beard"),
            keywords: &["beard", "woman", "woman: beard"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer: barba"),
            keywords: &["barba", "mujer", "mujer: barba"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["barba", "mujer", "mujer: barba"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("habemega naine"),
            keywords: &["habe", "habemega naine", "naine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumea: bizarra"),
            keywords: &["bizarra", "emakumea", "emakumea: bizarra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن: ریش"),
            keywords: &["ریش", "زن", "زن: ریش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("parrakas nainen"),
            keywords: &["nainen", "parrakas nainen", "parta"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babae: balbas"),
            keywords: &["babae", "babae: balbas", "balbas"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kona við skeggi"),
            keywords: &["kona", "kona við skeggi", "konufólk", "kvinna", "skegg"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme barbue"),
            keywords: &["barbe", "femme barbue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("femme barbue"),
            keywords: &["femme barbue"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean: feasóg"),
            keywords: &["bean", "bean: feasóg", "feasóg"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach: feusag"),
            keywords: &["boireannach", "boireannach: feusag", "feusag", "tè"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller con barba"),
            keywords: &["barba", "barbuda", "muller con barba"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી: દાઢી"),
            keywords: &["દાઢી", "સ\u{acd}ત\u{acd}રી", "સ\u{acd}ત\u{acd}રી: દાઢી"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה עם זקן"),
            keywords: &["אישה עם זקן", "אישה, זקן, אישה עם זקן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला: दाढ\u{93c}ी"),
            keywords: &["दाढ\u{93c}ी", "महिला", "महिला: दाढ\u{93c}ी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena: brada"),
            keywords: &["brada", "žena", "žena: brada"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nő: szakáll"),
            keywords: &["nő: szakáll"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մորուքավոր կին"),
            keywords: &["կին", "մորուք", "մորուքավոր", "մորուքով կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita: janggut"),
            keywords: &["janggut", "wanita", "wanita: janggut"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona: skegg"),
            keywords: &["kona", "kona: skegg", "skegg"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna con la barba"),
            keywords: &["barba", "donna", "donna con la barba"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("あごひげの女性"),
            keywords: &["あごひげ", "あごひげの女性", "ひげ", "女", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon: jenggot"),
            keywords: &["jenggot", "wong wadon", "wong wadon: jenggot"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი: წვერი"),
            keywords: &["ქალი", "ქალი: წვერი", "წვერი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел адам: сақал"),
            keywords: &["әйел адам: сақал"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}ត\u{17d2}រ\u{17b8}៖ ព\u{17bb}កចង\u{17d2}កា"),
            keywords: &[
                "ព\u{17bb}កចង\u{17d2}កា",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}៖ ព\u{17bb}កចង\u{17d2}កា",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}: ಗಡ\u{ccd}ಡ"),
            keywords: &[
                "ಗಡ\u{ccd}ಡ",
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಮಹ\u{cbf}ಳ\u{cc6}: ಗಡ\u{ccd}ಡ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("수염 난 여자"),
            keywords: &["수염", "수염 난 여자", "여자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल मनीस: खाड"),
            keywords: &["खाड", "बायल", "बायल मनीस: खाड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял : сакал"),
            keywords: &["аял", "аял : сакал", "аял: сакал", "сакал"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງມ\u{eb5}ໜວດ"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງມ\u{eb5}ໜວດ",
                "ໜວດ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteris: barzda"),
            keywords: &["barzda", "moteris", "moteris: barzda"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete ar bārdu"),
            keywords: &["bārda", "sieviete", "sieviete ar bārdu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена: брада"),
            keywords: &["брада", "жена", "жена: брада"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ത\u{d4d}രീ: ത\u{d3e}ടി"),
            keywords: &["സ\u{d4d}ത\u{d4d}രീ: ത\u{d3e}ടി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй: сахал"),
            keywords: &["сахал", "эмэгтэй", "эмэгтэй: сахал"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला: दाढी"),
            keywords: &["दाढी", "दाढी असल\u{947}ली महिला", "महिला", "महिला: दाढी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wanita: janggut"),
            keywords: &["janggut", "wanita", "wanita: janggut"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း - မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}"),
            keywords: &[
                "မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း - မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း- မ\u{102f}တ\u{103a}ဆ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne: skjegg"),
            keywords: &["kvinne", "kvinne: skjegg", "skjegg"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("महिलाःदाह\u{94d}री"),
            keywords: &["दाह\u{94d}री", "महिला", "महिलाःदाह\u{94d}री"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw: baard"),
            keywords: &["baard + vrouw: baard", "vrouw", "vrouw: baard"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne: skjegg"),
            keywords: &["kvinne", "kvinne: skjegg", "skjegg"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤ: ਦਾੜ\u{a4d}ਹੀ"),
            keywords: &["ਔਰਤ", "ਔਰਤ: ਦਾੜ\u{a4d}ਹੀ", "ਦਾੜ\u{a4d}ਹੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé Gẹ\u{301}t Biabiá"),
            keywords: &["Biabiá", "Wúman", "Wúman Wé Gẹ\u{301}t Biabiá"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta z brodą"),
            keywords: &["broda", "kobieta", "kobieta z brodą"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه: ږیره"),
            keywords: &["ږیره", "ښځه", "ښځه: ږیره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher: barba"),
            keywords: &["barba", "mulher", "mulher: barba"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi: kʼaki"),
            keywords: &["kʼaki", "warmi", "warmi: kʼaki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie: barbă"),
            keywords: &["barbă", "femeie", "femeie: barbă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13.1-006"),
            keywords: &["E13.1-006"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бородатая женщина"),
            keywords: &["борода", "бородатая женщина", "женщина"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت: ڏاڙهي"),
            keywords: &["عورت", "عورت: ڏاڙهي", "ڏاڙهي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf}ව: රැව\u{dd4}ල"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ක\u{dcf}න\u{dca}ත\u{dcf}ව: රැව\u{dd4}ල",
                "රැව\u{dd4}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("bradatá žena"),
            keywords: &["brada", "bradatá žena", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska: brada"),
            keywords: &["brada", "ženska", "ženska: brada"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gabadh: gadh"),
            keywords: &["gabadh", "gabadh: gadh", "gadh"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua: mjekër"),
            keywords: &["grua", "grua: mjekër", "mjekër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена: брада"),
            keywords: &["жена: брада"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena: brada"),
            keywords: &["žena: brada"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinna: skägg"),
            keywords: &["kvinna", "kvinna: skägg", "skägg"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke: ndevu"),
            keywords: &["mwanamke", "mwanamke: ndevu", "ndevu"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("த\u{bbe}டி வைத\u{bcd}த பெண\u{bcd}"),
            keywords: &[
                "த\u{bbe}டி",
                "த\u{bbe}டி வைத\u{bcd}த பெண\u{bcd}",
                "பெண\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c4d}త\u{c4d}ర\u{c40}: గ\u{c46}డ\u{c4d}డం"),
            keywords: &[
                "గ\u{c46}డ\u{c4d}డం",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
                "స\u{c4d}త\u{c4d}ర\u{c40}: గ\u{c46}డ\u{c4d}డం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งม\u{e35}เครา"),
            keywords: &[
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งม\u{e35}เครา",
                "ม\u{e35}เครา",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýal: sakal"),
            keywords: &["aýal", "aýal: sakal", "sakal"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine kava"),
            keywords: &["fefine kava"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın: sakal"),
            keywords: &["kadın", "kadın: sakal", "sakal"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка з бородою"),
            keywords: &["борода", "бородатий", "жінка з бородою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت: داڑھی"),
            keywords: &["داڑھی", "عورت", "عورت: داڑھی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("soqolli ayol"),
            keywords: &["ayol", "soqol", "soqolli ayol"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ có râu"),
            keywords: &["người phụ nữ", "người phụ nữ có râu", "râu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女人：鬍鬚"),
            keywords: &["女人", "女人：鬍鬚", "鬍鬚"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女人：胡须"),
            keywords: &["女人", "女人：胡须", "胡须"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("有络腮胡子的女人"),
            keywords: &["女人", "有络腮胡子的女人", "胡子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女人: 蓄鬍的人"),
            keywords: &["女人", "女人: 蓄鬍的人", "鬍子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
    ],
};
#[doc = "🧔🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_LIGHT_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F9D4 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "woman: light skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏻\u{200d}♀",
        codepoint: "1F9D4 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "woman: light skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F9D4 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "woman: medium-light skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏼\u{200d}♀",
        codepoint: "1F9D4 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "woman: medium-light skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_MEDIUM_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F9D4 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "woman: medium skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏽\u{200d}♀",
        codepoint: "1F9D4 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "woman: medium skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F9D4 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "woman: medium-dark skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏾\u{200d}♀",
        codepoint: "1F9D4 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "woman: medium-dark skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧔🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_DARK_SKIN_TONE_BEARD: crate::Emoji = crate::Emoji {
    glyph: "🧔🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F9D4 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 13.1f32,
    name: "woman: dark skin tone, beard",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🧔🏿\u{200d}♀",
        codepoint: "1F9D4 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 13.1f32,
        name: "woman: dark skin tone, beard",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👨\u{200d}🦰"]
pub const MAN_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🦰",
    codepoint: "1F468 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏻\u{200d}🦰"]
pub const MAN_LIGHT_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🦰",
    codepoint: "1F468 1F3FB 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: light skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🦰"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🦰",
    codepoint: "1F468 1F3FC 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-light skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🦰"]
pub const MAN_MEDIUM_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🦰",
    codepoint: "1F468 1F3FD 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🦰"]
pub const MAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🦰",
    codepoint: "1F468 1F3FE 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-dark skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🦰"]
pub const MAN_DARK_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🦰",
    codepoint: "1F468 1F3FF 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: dark skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🦱"]
pub const MAN_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🦱",
    codepoint: "1F468 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏻\u{200d}🦱"]
pub const MAN_LIGHT_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🦱",
    codepoint: "1F468 1F3FB 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: light skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🦱"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🦱",
    codepoint: "1F468 1F3FC 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-light skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🦱"]
pub const MAN_MEDIUM_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🦱",
    codepoint: "1F468 1F3FD 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🦱"]
pub const MAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🦱",
    codepoint: "1F468 1F3FE 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-dark skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🦱"]
pub const MAN_DARK_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🦱",
    codepoint: "1F468 1F3FF 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: dark skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🦳"]
pub const MAN_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🦳",
    codepoint: "1F468 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏻\u{200d}🦳"]
pub const MAN_LIGHT_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🦳",
    codepoint: "1F468 1F3FB 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: light skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🦳"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🦳",
    codepoint: "1F468 1F3FC 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-light skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🦳"]
pub const MAN_MEDIUM_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🦳",
    codepoint: "1F468 1F3FD 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🦳"]
pub const MAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🦳",
    codepoint: "1F468 1F3FE 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-dark skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🦳"]
pub const MAN_DARK_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🦳",
    codepoint: "1F468 1F3FF 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: dark skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨\u{200d}🦲"]
pub const MAN_BALD: crate::Emoji = crate::Emoji {
    glyph: "👨\u{200d}🦲",
    codepoint: "1F468 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏻\u{200d}🦲"]
pub const MAN_LIGHT_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👨🏻\u{200d}🦲",
    codepoint: "1F468 1F3FB 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: light skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏼\u{200d}🦲"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👨🏼\u{200d}🦲",
    codepoint: "1F468 1F3FC 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-light skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏽\u{200d}🦲"]
pub const MAN_MEDIUM_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👨🏽\u{200d}🦲",
    codepoint: "1F468 1F3FD 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏾\u{200d}🦲"]
pub const MAN_MEDIUM_DARK_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👨🏾\u{200d}🦲",
    codepoint: "1F468 1F3FE 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: medium-dark skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👨🏿\u{200d}🦲"]
pub const MAN_DARK_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👨🏿\u{200d}🦲",
    codepoint: "1F468 1F3FF 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "man: dark skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩"]
pub const WOMAN: crate::Emoji = crate::Emoji {
    glyph: "👩",
    codepoint: "1F469",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "woman",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vrou"),
            keywords: &["volwassene", "vrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሴት"),
            keywords: &["ሴት", "እንስት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة"),
            keywords: &["أنثى", "أنسة", "بالغة", "سيدة", "شخص", "كبيرة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তিৰোত\u{9be}"),
            keywords: &["তিৰোত\u{9be}", "মহিল\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qadın"),
            keywords: &["qadın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жанчына"),
            keywords: &["жанчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жена"),
            keywords: &["жена"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}"),
            keywords: &["ন\u{9be}রী", "মহিল\u{9be}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("maouez"),
            keywords: &["deuet", "maouez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena"),
            keywords: &["odrasla osoba", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona"),
            keywords: &["dona", "femení"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄟\u{11128}𑄣𑄬 𑄟𑄚\u{1112a}𑄌\u{11134}"),
            keywords: &["𑄟\u{11128}𑄣𑄬 𑄟𑄚\u{1112a}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ"),
            keywords: &["ᎠᎨᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("žena"),
            keywords: &["žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw"),
            keywords: &["menyw", "oedolyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("kvinde"),
            keywords: &["kvinde", "menneske", "person"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau"),
            keywords: &["Frau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα"),
            keywords: &["γυναίκα", "ενήλικας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman"),
            keywords: &["adult", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer"),
            keywords: &["adulta", "mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["cara", "mujer", "persona", "señora"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naine"),
            keywords: &["naine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakumea"),
            keywords: &["emakume", "emakumea", "emakumezko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن"),
            keywords: &["خانم", "زن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nainen"),
            keywords: &["nainen", "naispuolinen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babae"),
            keywords: &["babae", "matanda"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kona"),
            keywords: &["kona", "konufólk", "kvinna", "vaksin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme"),
            keywords: &["femme"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["adulte", "femme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean"),
            keywords: &["bean"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach"),
            keywords: &["boireannach", "tè"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller"),
            keywords: &["adulta", "muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી"),
            keywords: &["પ\u{ac1}ખ\u{acd}ત", "સ\u{acd}ત\u{acd}રી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace"),
            keywords: &["mace"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה"),
            keywords: &["אישה", "בחורה", "בת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("महिला"),
            keywords: &["महिला", "वयस\u{94d}क"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("žena"),
            keywords: &["žena", "žensko"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nő"),
            keywords: &["nő"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("կին"),
            keywords: &["կին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita"),
            keywords: &["ibu", "perempuan", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị"),
            keywords: &["nwanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("kona"),
            keywords: &["fólk", "kona"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna"),
            keywords: &["donna", "femmina", "persone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("女性"),
            keywords: &["大人", "女", "女性", "顔"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon"),
            keywords: &["wadon", "wong diwasa", "wong wadon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქალი"),
            keywords: &["ქალი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("tameṭṭut"),
            keywords: &["tameṭṭut"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("әйел"),
            keywords: &["әйел", "әйел адам"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("kvinde"),
            keywords: &["kvinde", "menneske", "person"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រ\u{17d2}ត\u{17b8}"),
            keywords: &[
                "នារ\u{17b8}",
                "មន\u{17bb}ស\u{17d2}សធ\u{17c6}",
                "ម\u{17bb}ខស\u{17d2}រ\u{17d2}ត\u{17b8}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17d2}ត\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &["ಮಹ\u{cbf}ಳ\u{cc6}", "ಸ\u{ccd}ತ\u{ccd}ರೀ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("여자"),
            keywords: &["성인", "여성", "여자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल"),
            keywords: &["प\u{94d}रौढ", "बायल"],
        },
        #[cfg(feature = "ku")]
        crate::Annotation {
            lang: "ku",
            tts: Some("jin"),
            keywords: &["jin"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("аял"),
            keywords: &["аял"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Fra"),
            keywords: &["Fra"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມ\u{ec8}ຍ\u{eb4}ງ"),
            keywords: &["ຄ\u{ebb}ນ", "ແມ\u{ec8}ຍ\u{eb4}ງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("moteris"),
            keywords: &["moteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sieviete"),
            keywords: &["dāma", "kundze", "seja", "sieviete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine"),
            keywords: &["wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("жена"),
            keywords: &["жена", "женско"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}\u{200c}ത\u{d4d}രീ"),
            keywords: &[
                "മ\u{d41}തിർന\u{d4d}നയ\u{d3e}ൾ",
                "സ\u{d4d}\u{200c}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эмэгтэй хүн"),
            keywords: &["хүн", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("महिला"),
            keywords: &["महिला"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan"),
            keywords: &["perempuan", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara"),
            keywords: &["mara"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အမျ\u{102d}\u{102f}းသမ\u{102e}း"),
            keywords: &["အမ", "အမျ\u{102d}\u{102f}းသမ\u{102e}း"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne"),
            keywords: &["kvinne", "menneske", "voksen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("छोरीमान\u{94d}छ\u{947}"),
            keywords: &["छोरीमान\u{94d}छ\u{947}", "महिला"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw"),
            keywords: &["vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne"),
            keywords: &["kvinne", "menneske", "vaksen"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}"),
            keywords: &["ବୟସ\u{b4d}କ", "ମହ\u{b3f}ଳ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਔਰਤ"),
            keywords: &["ਔਰਤ", "ਜ\u{a3c}ਨਾਨੀ", "ਲ\u{a4b}ਕ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("زنانی"),
            keywords: &["زنانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman"),
            keywords: &["Machọ\u{301} Pẹ\u{301}sin", "Wúman"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kobieta"),
            keywords: &["kobieta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه"),
            keywords: &["ښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher"),
            keywords: &["adulta", "mulher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["adulta", "mulher", "pessoa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi"),
            keywords: &["puriq runa", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie"),
            keywords: &["adultă", "femeie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-550"),
            keywords: &["E10-550"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("женщина"),
            keywords: &["взрослая", "волосы", "длинные", "женщина", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore"),
            keywords: &["umugore"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت"),
            keywords: &["عورت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &["ක\u{dcf}න\u{dca}ත\u{dcf}ව", "වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("žena"),
            keywords: &["dospelá", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska"),
            keywords: &["dekle", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag"),
            keywords: &["naag", "qof weyn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua"),
            keywords: &["femër", "grua"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("жена"),
            keywords: &["жeнa", "жена"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("žena"),
            keywords: &["žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("kvinna"),
            keywords: &["kvinna", "vuxen"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke"),
            keywords: &["msichana", "mwanamke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பெண\u{bcd}"),
            keywords: &["பெண\u{bcd}", "மகளிர\u{bcd}", "மக\u{bcd}கள\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మహ\u{c3f}ళ"),
            keywords: &["ఆడద\u{c3f}", "మహ\u{c3f}ళ", "స\u{c4d}త\u{c4d}ర\u{c40}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зан"),
            keywords: &["зан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}ง"),
            keywords: &["คน", "ผ\u{e39}\u{e49}หญ\u{e34}ง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan"),
            keywords: &["aýal", "uly ýaşly", "zenan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine"),
            keywords: &["fefine"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kadın"),
            keywords: &["kadın", "kişiler"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئايال"),
            keywords: &["ئايال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка"),
            keywords: &["доросла", "жінка"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("عورت"),
            keywords: &["انسان", "عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol"),
            keywords: &["ayol", "katta yoshli"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("phụ nữ"),
            keywords: &["người lớn", "phụ nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jigéen"),
            keywords: &["jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa"),
            keywords: &["ibhinqa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Obìnrin"),
            keywords: &["Obìnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("女人"),
            keywords: &["女人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("女人"),
            keywords: &["女人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("女人"),
            keywords: &["女", "女人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("女人"),
            keywords: &["女", "女人", "女性"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umama"),
            keywords: &["owesimame", "umama"],
        },
    ],
};
#[doc = "👩🏻"]
pub const WOMAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏻",
    codepoint: "1F469 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "woman: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏼",
    codepoint: "1F469 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "woman: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽"]
pub const WOMAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏽",
    codepoint: "1F469 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "woman: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏾",
    codepoint: "1F469 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "woman: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿"]
pub const WOMAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👩🏿",
    codepoint: "1F469 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "woman: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🦰"]
pub const WOMAN_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🦰",
    codepoint: "1F469 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏻\u{200d}🦰"]
pub const WOMAN_LIGHT_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🦰",
    codepoint: "1F469 1F3FB 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: light skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🦰"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🦰",
    codepoint: "1F469 1F3FC 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-light skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🦰"]
pub const WOMAN_MEDIUM_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🦰",
    codepoint: "1F469 1F3FD 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🦰"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🦰",
    codepoint: "1F469 1F3FE 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-dark skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🦰"]
pub const WOMAN_DARK_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🦰",
    codepoint: "1F469 1F3FF 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: dark skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🦰"]
pub const PERSON_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🦰",
    codepoint: "1F9D1 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏻\u{200d}🦰"]
pub const PERSON_LIGHT_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🦰",
    codepoint: "1F9D1 1F3FB 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: light skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🦰"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🦰",
    codepoint: "1F9D1 1F3FC 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-light skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🦰"]
pub const PERSON_MEDIUM_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🦰",
    codepoint: "1F9D1 1F3FD 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🦰"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🦰",
    codepoint: "1F9D1 1F3FE 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-dark skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🦰"]
pub const PERSON_DARK_SKIN_TONE_RED_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🦰",
    codepoint: "1F9D1 1F3FF 200D 1F9B0",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: dark skin tone, red hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🦱"]
pub const WOMAN_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🦱",
    codepoint: "1F469 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏻\u{200d}🦱"]
pub const WOMAN_LIGHT_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🦱",
    codepoint: "1F469 1F3FB 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: light skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🦱"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🦱",
    codepoint: "1F469 1F3FC 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-light skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🦱"]
pub const WOMAN_MEDIUM_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🦱",
    codepoint: "1F469 1F3FD 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🦱"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🦱",
    codepoint: "1F469 1F3FE 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-dark skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🦱"]
pub const WOMAN_DARK_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🦱",
    codepoint: "1F469 1F3FF 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: dark skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🦱"]
pub const PERSON_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🦱",
    codepoint: "1F9D1 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏻\u{200d}🦱"]
pub const PERSON_LIGHT_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🦱",
    codepoint: "1F9D1 1F3FB 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: light skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🦱"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🦱",
    codepoint: "1F9D1 1F3FC 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-light skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🦱"]
pub const PERSON_MEDIUM_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🦱",
    codepoint: "1F9D1 1F3FD 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🦱"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🦱",
    codepoint: "1F9D1 1F3FE 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-dark skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🦱"]
pub const PERSON_DARK_SKIN_TONE_CURLY_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🦱",
    codepoint: "1F9D1 1F3FF 200D 1F9B1",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: dark skin tone, curly hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🦳"]
pub const WOMAN_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🦳",
    codepoint: "1F469 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏻\u{200d}🦳"]
pub const WOMAN_LIGHT_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🦳",
    codepoint: "1F469 1F3FB 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: light skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🦳"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🦳",
    codepoint: "1F469 1F3FC 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-light skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🦳"]
pub const WOMAN_MEDIUM_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🦳",
    codepoint: "1F469 1F3FD 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🦳"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🦳",
    codepoint: "1F469 1F3FE 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-dark skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🦳"]
pub const WOMAN_DARK_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🦳",
    codepoint: "1F469 1F3FF 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: dark skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🦳"]
pub const PERSON_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🦳",
    codepoint: "1F9D1 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏻\u{200d}🦳"]
pub const PERSON_LIGHT_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🦳",
    codepoint: "1F9D1 1F3FB 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: light skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🦳"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🦳",
    codepoint: "1F9D1 1F3FC 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-light skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🦳"]
pub const PERSON_MEDIUM_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🦳",
    codepoint: "1F9D1 1F3FD 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🦳"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🦳",
    codepoint: "1F9D1 1F3FE 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-dark skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🦳"]
pub const PERSON_DARK_SKIN_TONE_WHITE_HAIR: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🦳",
    codepoint: "1F9D1 1F3FF 200D 1F9B3",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: dark skin tone, white hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩\u{200d}🦲"]
pub const WOMAN_BALD: crate::Emoji = crate::Emoji {
    glyph: "👩\u{200d}🦲",
    codepoint: "1F469 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏻\u{200d}🦲"]
pub const WOMAN_LIGHT_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👩🏻\u{200d}🦲",
    codepoint: "1F469 1F3FB 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: light skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏼\u{200d}🦲"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👩🏼\u{200d}🦲",
    codepoint: "1F469 1F3FC 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-light skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏽\u{200d}🦲"]
pub const WOMAN_MEDIUM_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👩🏽\u{200d}🦲",
    codepoint: "1F469 1F3FD 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏾\u{200d}🦲"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👩🏾\u{200d}🦲",
    codepoint: "1F469 1F3FE 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: medium-dark skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👩🏿\u{200d}🦲"]
pub const WOMAN_DARK_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "👩🏿\u{200d}🦲",
    codepoint: "1F469 1F3FF 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "woman: dark skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑\u{200d}🦲"]
pub const PERSON_BALD: crate::Emoji = crate::Emoji {
    glyph: "🧑\u{200d}🦲",
    codepoint: "1F9D1 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏻\u{200d}🦲"]
pub const PERSON_LIGHT_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "🧑🏻\u{200d}🦲",
    codepoint: "1F9D1 1F3FB 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: light skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏼\u{200d}🦲"]
pub const PERSON_MEDIUM_LIGHT_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "🧑🏼\u{200d}🦲",
    codepoint: "1F9D1 1F3FC 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-light skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏽\u{200d}🦲"]
pub const PERSON_MEDIUM_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "🧑🏽\u{200d}🦲",
    codepoint: "1F9D1 1F3FD 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏾\u{200d}🦲"]
pub const PERSON_MEDIUM_DARK_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "🧑🏾\u{200d}🦲",
    codepoint: "1F9D1 1F3FE 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: medium-dark skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧑🏿\u{200d}🦲"]
pub const PERSON_DARK_SKIN_TONE_BALD: crate::Emoji = crate::Emoji {
    glyph: "🧑🏿\u{200d}🦲",
    codepoint: "1F9D1 1F3FF 200D 1F9B2",
    status: crate::Status::FullyQualified,
    introduction_version: 12.1f32,
    name: "person: dark skin tone, bald",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👱\u{200d}♀\u{fe0f}"]
pub const WOMAN_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱\u{200d}♀\u{fe0f}",
    codepoint: "1F471 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman: blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱\u{200d}♀",
        codepoint: "1F471 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman: blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blondine"),
            keywords: &["blond", "blonde vrou", "blondine", "hare", "vrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወርቃማ ጸጉር ያላት ሴት"),
            keywords: &["ሰው", "ሴት", "ወርቃማ", "ወርቃማ ጸጉር ያላት ሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("امرأة شقراء"),
            keywords: &["امرأة", "امرأة شقراء الشعر", "شقراء"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মহিল\u{9be}: সোণ\u{9be}লী চ\u{9c1}লি"),
            keywords: &[
                "চ\u{9c1}লি",
                "মহিল\u{9be}",
                "মহিল\u{9be}: সোণ\u{9be}লী চ\u{9c1}লি",
                "সোণ\u{9be}লী চ\u{9c1}লিৰ মহিল\u{9be}",
                "স\u{9cd}বৰ\u{9cd}ণকেশী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarışın qadın"),
            keywords: &["qadın", "sarışın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бялявая жанчына"),
            keywords: &["бландзінка", "бялявая", "жанчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("блондинка"),
            keywords: &["блондинка", "руса жена", "руса коса"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মহিল\u{9be}: স\u{9cd}বর\u{9cd}ণকেশী"),
            keywords: &[
                "চ\u{9c1}ল",
                "মহিল\u{9be}",
                "মহিল\u{9be}: স\u{9cd}বর\u{9cd}ণকেশী",
                "স\u{9cd}বর\u{9cd}ণকেশী",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("meleganez"),
            keywords: &["maouez", "meleganez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("žena s plavom kosom"),
            keywords: &["kosa", "plavo", "plavuša", "žena", "žena s plavom kosom"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona: cabell ros"),
            keywords: &["cabell", "dona", "dona: cabell ros", "rossa"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎨᏯ: ᏓᎶᏂᎨ ᎤᏍᏘᎩ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎨᏯ: ᏓᎶᏂᎨ ᎤᏍᏘᎩ", "ᎤᏍᏘᎩ", "ᏓᎶᏂᎨ", "ᏓᎶᏂᎨ-ᎤᏍᏘᎩ ᎠᎨᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("blondýna"),
            keywords: &[
                "blond",
                "blondýna",
                "blondýnka",
                "plavovláska",
                "světlovláska",
                "žena",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("menyw â gwallt golau"),
            keywords: &["blonde", "gwallt golau", "menyw", "menyw â gwallt golau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blond kvinde"),
            keywords: &["blond kvinde", "blondine", "kvinde", "lyshåret"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Frau: blond"),
            keywords: &[
                "Frau",
                "Frau: blond",
                "Gesicht",
                "Haar",
                "blond",
                "blonde Frau",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γυναίκα: ξανθά μαλλιά"),
            keywords: &["γυναίκα", "γυναίκα: ξανθά μαλλιά", "μαλλιά", "ξανθιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("woman: blond hair"),
            keywords: &[
                "blond-haired woman",
                "blonde",
                "hair",
                "woman",
                "woman: blond hair",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mujer rubia"),
            keywords: &["mujer", "rubia", "rubiales"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cara", "güera", "mujer", "mujer rubia"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["mujer", "mujer: rubia", "rubia"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("naine: blond"),
            keywords: &["blond", "blondiin", "naine", "naine: blond"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("emakume ilehoria"),
            keywords: &["emakume", "emakume ilehoria", "emakumezko", "ilehori"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زن: موبور"),
            keywords: &["بلوند", "بور", "زن بلوند", "زن بور", "زن: موبور", "موطلایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaaleatukkainen nainen"),
            keywords: &[
                "blondi",
                "hiukset",
                "nainen",
                "vaalea",
                "vaaleahiuksinen nainen",
                "vaaleatukkainen nainen",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("babae: blond na buhok"),
            keywords: &[
                "babae",
                "babae: blond na buhok",
                "babaeng blond ang buhok",
                "blonde",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljóshærd kvinna"),
            keywords: &["kona", "kvinna", "ljóshærd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme blonde"),
            keywords: &["blonde", "cheveux", "femme blonde"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["blonde", "femme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bean: gruaig fhionn"),
            keywords: &[
                "bean",
                "bean le gruaig fhionn",
                "bean: gruaig fhionn",
                "duine",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("boireannach le falt bàn"),
            keywords: &[
                "boireannach",
                "boireannach le falt bàn",
                "bàn",
                "falt",
                "tè",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("muller loura"),
            keywords: &["loira", "loura", "muller"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{acd}ત\u{acd}રી: સોન\u{ac7}રી વાળ"),
            keywords: &[
                "પીળાશ પડતા\u{a82} વાળવાળી સ\u{acd}ત\u{acd}રી",
                "વાળ",
                "સોન\u{ac7}રી વાળવાળી સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી",
                "સ\u{acd}ત\u{acd}રી: સોન\u{ac7}રી વાળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("mace mai farin gashi"),
            keywords: &["mace", "mace mai farin gashi", "mai farin gashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בלונדינית"),
            keywords: &["אישה", "בלונדינית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{941}नहर\u{947} बालो\u{902} वाली औरत"),
            keywords: &["गोरी", "महिला", "स\u{941}नहर\u{947} बालो\u{902} वाली औरत"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plavokosa žena"),
            keywords: &["plavojka", "plavokosa žena", "plavuša"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szőke nő"),
            keywords: &["nő", "szőke"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շիկահեր կին"),
            keywords: &["կին", "մազեր", "շեկ", "շիկահեր", "վարսեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita berambut pirang"),
            keywords: &[
                "perempuan",
                "pirang",
                "rambut",
                "wanita berambut pirang",
                "wanita: rambut pirang",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwanyị nwere isi-awọ"),
            keywords: &["isi awọ", "nwanyị", "nwanyị nwere isi-awọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ljóshærð kona"),
            keywords: &["kona", "ljóshærð", "ljóst hár"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna bionda"),
            keywords: &["bionda", "donna", "femmina"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("金髪の女性"),
            keywords: &["ブロンド", "女", "女性", "金髪", "金髪の女性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon: rambut pirang"),
            keywords: &[
                "pirang",
                "rambut",
                "wong wadon",
                "wong wadon arambut pirang",
                "wong wadon: rambut pirang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქერათმიანი ქალი"),
            keywords: &["ქალი", "ქერა", "ქერათმიანი ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аққұба әйел"),
            keywords: &["аққұба", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blond kvinde"),
            keywords: &["blond kvinde", "blondine", "kvinde", "lyshåret"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("នារ\u{17b8}សក\u{17cb}ទង\u{17cb}ដែង"),
            keywords: &[
                "ទង\u{17cb}ដែង",
                "នារ\u{17b8}",
                "នារ\u{17b8}សក\u{17cb}ទង\u{17cb}ដែង",
                "សក\u{17cb}",
                "ស\u{17d2}រ\u{17b8}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &[
                "ಮಹ\u{cbf}ಳ\u{cc6}",
                "ಸ\u{ccd}ತ\u{ccd}ರೀ",
                "ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ಮಹ\u{cbf}ಳ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("금발 여자"),
            keywords: &["금발", "여성", "여자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बायल : पि\u{902}गश\u{947} क\u{947}\u{902}स"),
            keywords: &[
                "क\u{947}\u{902}स",
                "पि\u{902}गश\u{947}",
                "पि\u{902}गश\u{947}-क\u{947}सा\u{902}ची बायल",
                "बायल",
                "बायल : पि\u{902}गश\u{947} क\u{947}\u{902}स",
                "बायल: पि\u{902}गश\u{947} क\u{947}\u{902}स",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сары чачтуу аял"),
            keywords: &["аял", "сары чач", "сары чачтуу аял"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Blondin"),
            keywords: &["Blondin", "Fra", "blond"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{eb4}ງຜ\u{ebb}ມບລອນ"),
            keywords: &[
                "ຍ\u{eb4}ງຜ\u{ebb}ມບລອນ",
                "ບລອນ",
                "ຜ\u{eb9}\u{ec9}ຍ\u{eb4}ງ",
                "ຜ\u{ebb}ມທອງ",
                "ຜ\u{ebb}ມສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("blondinė"),
            keywords: &["blondinė", "moteris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("blondīne"),
            keywords: &["blonda", "blondi mati", "blondīne", "sieviete"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("wahine mākekehu"),
            keywords: &["mākekehu", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("русокоса жена"),
            keywords: &["жена", "руса коса", "русокоса жена"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സ\u{d4d}ത\u{d4d}രീ: സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടി"),
            keywords: &[
                "തലമ\u{d41}ടി",
                "സ\u{d4d}ത\u{d4d}രീ",
                "സ\u{d4d}ത\u{d4d}രീ: സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടി",
                "സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടിക\u{d4d}ക\u{d3e}രി",
                "സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടിയ\u{d41}ള\u{d4d}ള സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар үстэй эмэгтэй"),
            keywords: &["цайвар шар үс", "шар үстэй эмэгтэй", "эм", "эмэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सोन\u{947}री क\u{947}सा\u{902}ची महिला"),
            keywords: &[
                "क\u{947}स",
                "महिला",
                "सोन\u{947}री",
                "सोन\u{947}री क\u{947}सा\u{902}ची महिला",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("perempuan: rambut perang"),
            keywords: &[
                "perang",
                "perempuan: rambut perang",
                "wanita",
                "wanita rambut perang",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara b’xagħar isfar"),
            keywords: &["mara", "mara b’xagħar isfar", "xagħar isfar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း- ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030}",
            ),
            keywords: &[
                "ရ\u{103d}\u{103e}ေရောင\u{103a}",
                "ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030} အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း- ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kvinne: blond"),
            keywords: &["blond", "blondine", "hår", "kvinne", "kvinne: blond"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{948}लो कपाल भएकी छोरीमान\u{94d}छ\u{947}"),
            keywords: &[
                "क\u{948}लो",
                "क\u{948}लो कपाल भएकी छोरीमान\u{94d}छ\u{947}",
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("vrouw met blond haar"),
            keywords: &["blond", "haar", "vrouw", "vrouw met blond haar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kvinne: blond"),
            keywords: &["blond", "blondine", "hår", "kvinne", "kvinne: blond"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମହ\u{b3f}ଳ\u{b3e}: ସ\u{b41}ନେଲ\u{b3f} କେଶ"),
            keywords: &[
                "କେଶ",
                "ମହ\u{b3f}ଳ\u{b3e}",
                "ମହ\u{b3f}ଳ\u{b3e}: ସ\u{b41}ନେଲ\u{b3f} କେଶ",
                "ସ\u{b41}ନେଲ\u{b3f}",
                "ସ\u{b41}ନେଲ\u{b3f}-କେଶଥ\u{b3f}ବ\u{b3e} ମହ\u{b3f}ଳ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a71}ਕ\u{a47} ਵਾਲਾ\u{a02} ਵਾਲੀ ਇਸਤਰੀ"),
            keywords: &["ਇਸਤਰੀ", "ਔਰਤ", "ਕ\u{a71}ਕ\u{a47} ਵਾਲਾ\u{a02} ਵਾਲੀ ਇਸਤਰੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}ھورے والاں آلی زنانی"),
            keywords: &["ب\u{64f}ھورے والاں آلی زنانی", "بھورے والاں آلی", "زنانی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Wúman Wé Gẹ\u{301}t Blọ\u{301}nd Hea"),
            keywords: &[
                "Blọnd Hea",
                "Wúman Wé Gẹ\u{301}t Blọ\u{301}nd Hea",
                "Wúman: Blọ\u{301}nd Hea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("blondynka"),
            keywords: &["blondynka", "kobieta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښځه: د زېړ وېښتانو"),
            keywords: &[
                "د زېړ ويښتانو ښځه",
                "زېړ ويښتان",
                "ويښتان",
                "ښځه",
                "ښځه: د زېړ وېښتانو",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mulher: cabelo loiro"),
            keywords: &["loira", "loura", "mulher", "mulher: cabelo loiro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "loura",
                "mulher",
                "mulher com cabelo loiro",
                "mulher com cabelo louro",
                "mulher loira",
                "mulher: cabelo loiro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("warmi: qʼillu chukcha"),
            keywords: &[
                "chukcha",
                "qʼillo chukcha warmi",
                "qʼillu",
                "warmi",
                "warmi: qʼillu chukcha",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("femeie blondă"),
            keywords: &["blondă", "femeie", "femeie cu păr blond", "păr"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1194"),
            keywords: &["E10-1194"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("блондинка"),
            keywords: &[
                "блондинка",
                "женщина",
                "женщина со светлыми волосами",
                "светлые волосы",
                "человек со светлыми волосами",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugore ufite imisatsi yera"),
            keywords: &["inzobe", "umugore", "umugore ufite imisatsi yera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("عورت: ڀورا وار"),
            keywords: &["عورت", "عورت: ڀورا وار", "ڀورا وار", "ڀورن وارن واري عورت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තඹ පැහැ කොණ\u{dca}ඩය සහ\u{dd2}ත ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "තඹ පැහැ",
                "තඹ පැහැ කොණ\u{dca}ඩය සහ\u{dd2}ත ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("blondína"),
            keywords: &["blond", "blondína", "blondínka", "svetlovlasá", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ženska: blondinka"),
            keywords: &["blondinka", "dekle", "lasje", "ženska", "ženska: blondinka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag: timo cad"),
            keywords: &[
                "naag",
                "naag timo cad",
                "naag: timo cad",
                "timo",
                "timo cad",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua bionde"),
            keywords: &["bionde", "femër", "grua"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плавуша"),
            keywords: &["жена", "плава коса", "плавуша"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plavuša"),
            keywords: &["plava kosa", "plavuša", "žena"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blond kvinna"),
            keywords: &["blond", "blondin", "kvinna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamke mwenye nywele ya kimanjano"),
            keywords: &[
                "manjano",
                "mwanamke",
                "mwanamke mwenye nywele ya kimanjano",
                "nywele",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பொன\u{bcd}னிற முடி கொண\u{bcd}ட பெண\u{bcd}"),
            keywords: &[
                "பெண\u{bcd}",
                "பொன\u{bcd}னிற முடி கொண\u{bcd}ட பெண\u{bcd}",
                "பொன\u{bcd}னிறம\u{bcd}",
                "மஞ\u{bcd}சள\u{bcd}",
                "முடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ల\u{c4d}లన\u{c3f} జుట\u{c4d}టు గల స\u{c4d}త\u{c4d}ర\u{c40}"),
            keywords: &[
                "త\u{c46}ల\u{c4d}లన\u{c3f} జుట\u{c4d}టు",
                "త\u{c46}ల\u{c4d}లన\u{c3f} జుట\u{c4d}టు గల స\u{c4d}త\u{c4d}ర\u{c40}",
                "మహ\u{c3f}ళ",
                "స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани зардинамӯй"),
            keywords: &["зан", "зани зардинамӯй", "зардинамӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}หญ\u{e34}งผมทอง"),
            keywords: &[
                "ผม",
                "ผมทอง",
                "ผ\u{e39}\u{e49}หญ\u{e34}ง",
                "ผ\u{e39}\u{e49}หญ\u{e34}งผมทอง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("zenan: sary saçly"),
            keywords: &["sary saçly", "saç", "zenan", "zenan: sary saçly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("fefine ʻulu kelo"),
            keywords: &["fefine ʻulu kelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarışın kadın"),
            keywords: &["bayan", "kadın", "sarışın"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئالتۇن چاچ ئايال"),
            keywords: &["ئالتۇن چاچ", "ئالتۇن چاچ ئايال", "ئايال"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жінка з білявим волоссям"),
            keywords: &["блондинка", "білява", "жінка з білявим волоссям"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سنہرے بالوں والی عورت"),
            keywords: &["بھورے بال", "سنہرے بال", "سنہرے بالوں والی عورت", "عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ayol: mallasoch"),
            keywords: &["ayol", "ayol: mallasoch", "mallasoch", "soch"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người phụ nữ tóc vàng hoe"),
            keywords: &["người phụ nữ tóc vàng hoe", "nữ", "phụ nữ", "tóc vàng hoe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("karaw gu am kawar gu mboq jigéen"),
            keywords: &[
                "jigéen",
                "karaw gu am kawar gu mboq jigéen",
                "karaw gu mboq",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elineenwele ezimhlophe"),
            keywords: &["ibhinqa", "ibhinqa elineenwele ezimhlophe", "mhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("obìnrin onírun funfun"),
            keywords: &["obìnrin", "obìnrin onírun funfun", "onírun funfun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("金色頭髮嘅女人"),
            keywords: &["女", "金色頭髮", "金色頭髮嘅女人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("金色头发嘅女人"),
            keywords: &["女", "金色头发", "金色头发嘅女人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("金发女"),
            keywords: &["女", "金发", "金发女"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("金髮女"),
            keywords: &["女", "金髮", "金髮女"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("金髮女人"),
            keywords: &["女", "金髮", "金髮女人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umama: izinwele ezimhlophe"),
            keywords: &[
                "izinwele",
                "mhlophe",
                "umama",
                "umama onezinwele ezinhlophe",
                "umama: izinwele ezimhlophe",
            ],
        },
    ],
};
#[doc = "👱🏻\u{200d}♀\u{fe0f}"]
pub const WOMAN_LIGHT_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏻\u{200d}♀\u{fe0f}",
    codepoint: "1F471 1F3FB 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman: light skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏻\u{200d}♀",
        codepoint: "1F471 1F3FB 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman: light skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏼\u{200d}♀\u{fe0f}"]
pub const WOMAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏼\u{200d}♀\u{fe0f}",
    codepoint: "1F471 1F3FC 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman: medium-light skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏼\u{200d}♀",
        codepoint: "1F471 1F3FC 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman: medium-light skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏽\u{200d}♀\u{fe0f}"]
pub const WOMAN_MEDIUM_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏽\u{200d}♀\u{fe0f}",
    codepoint: "1F471 1F3FD 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman: medium skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏽\u{200d}♀",
        codepoint: "1F471 1F3FD 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman: medium skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏾\u{200d}♀\u{fe0f}"]
pub const WOMAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏾\u{200d}♀\u{fe0f}",
    codepoint: "1F471 1F3FE 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman: medium-dark skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏾\u{200d}♀",
        codepoint: "1F471 1F3FE 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman: medium-dark skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏿\u{200d}♀\u{fe0f}"]
pub const WOMAN_DARK_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏿\u{200d}♀\u{fe0f}",
    codepoint: "1F471 1F3FF 200D 2640 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "woman: dark skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏿\u{200d}♀",
        codepoint: "1F471 1F3FF 200D 2640",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "woman: dark skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱\u{200d}♂\u{fe0f}"]
pub const MAN_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱\u{200d}♂\u{fe0f}",
    codepoint: "1F471 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man: blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱\u{200d}♂",
        codepoint: "1F471 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man: blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("blonde man"),
            keywords: &["blond", "blonde man", "hare", "man"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወርቃማ ጸጉር ያለው ወንድ"),
            keywords: &["ሰው", "ወርቃማ", "ወርቃማ ጸጉር ያለው ወንድ", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل أشقر"),
            keywords: &["أشقر", "رجل", "رجل أشقر الشعر"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("প\u{9c1}ৰ\u{9c1}ষ: সোণ\u{9be}লী চ\u{9c1}লি"),
            keywords: &[
                "চ\u{9c1}লি",
                "প\u{9c1}ৰ\u{9c1}ষ",
                "প\u{9c1}ৰ\u{9c1}ষ: সোণ\u{9be}লী চ\u{9c1}লি",
                "সোণ\u{9be}লী চ\u{9c1}লিৰ প\u{9c1}ৰ\u{9c1}ষ",
                "স\u{9cd}বৰ\u{9cd}ণকেশী",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sarışın kişi"),
            keywords: &["kişi", "sarışın"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бялявы мужчына"),
            keywords: &["бландзін", "бялявы", "мужчына"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("блондин"),
            keywords: &["блондин", "рус мъж", "руса коса"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9c1}র\u{9c1}ষ: স\u{9cd}বর\u{9cd}ণকেশী চ\u{9c1}ল"),
            keywords: &[
                "ছেলে",
                "প\u{9c1}র\u{9c1}ষ",
                "প\u{9c1}র\u{9c1}ষ: স\u{9cd}বর\u{9cd}ণকেশী চ\u{9c1}ল",
                "স\u{9cd}বর\u{9cd}ণকেশ",
                "স\u{9cd}বর\u{9cd}ণকেশ ওয\u{9bc}\u{9be}ল\u{9be} প\u{9c1}র\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("melegan"),
            keywords: &["gwaz", "melegan"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("muškarac s plavom kosom"),
            keywords: &[
                "kosa",
                "muškarac",
                "muškarac s plavom kosom",
                "plavo",
                "plavušan",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home: cabell ros"),
            keywords: &["cabell", "home", "home: cabell ros", "ros"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏍᎦᏯ: ᏓᎶᏂᎨ ᎤᏍᏘᎩ"),
            keywords: &["ᎠᏍᎦᏯ", "ᎠᏍᎦᏯ: ᏓᎶᏂᎨ ᎤᏍᏘᎩ", "ᎤᏍᏘᎩ", "ᏓᎶᏂᎨ", "ᏓᎶᏂᎨ-ᎤᏍᏘᎩ ᎠᏍᎦᏯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("blonďák"),
            keywords: &["blond", "blonďák", "muž", "plavovlasý", "světlovlasý"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dyn â gwallt golau"),
            keywords: &["blond", "dyn", "dyn â gwallt golau", "gwallt golau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("blond mand"),
            keywords: &["blond", "lyshåret", "mand"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mann: blond"),
            keywords: &[
                "Gesicht",
                "Haar",
                "Mann",
                "Mann: blond",
                "blond",
                "blonder Mann",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("άντρας: ξανθά μαλλιά"),
            keywords: &["άντρας", "άντρας: ξανθά μαλλιά", "μαλλιά", "ξανθός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("man: blond hair"),
            keywords: &[
                "blond",
                "blond-haired man",
                "hair",
                "man",
                "man: blond hair",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hombre rubio"),
            keywords: &["hombre", "rubiales", "rubio"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["cara", "güero", "hombre rubio", "rubio"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["hombre", "hombre: rubio", "rubio"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mees: blond"),
            keywords: &["blond", "blondiin", "mees", "mees: blond"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gizon ilehoria"),
            keywords: &["gizon", "gizon ilehoria", "gizonezko", "ilehori"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مرد: مو بور"),
            keywords: &[
                "بلوند",
                "بور",
                "طلایی",
                "مرد بلوند",
                "مرد بور",
                "مرد: مو بور",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vaaleatukkainen mies"),
            keywords: &[
                "blondi",
                "hiukset",
                "mies",
                "vaalea",
                "vaaleahiuksinen mies",
                "vaaleatukkainen mies",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("lalaking blonde"),
            keywords: &["blonde", "lalaki", "lalaking blonde"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ljóshærdur maður"),
            keywords: &["ljóshærdur", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme blond"),
            keywords: &["blond", "cheveux", "homme blond"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["blond", "homme"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fear: gruaig fhionn"),
            keywords: &[
                "fear",
                "fear: gruaig fhionn",
                "fearr le gruaig fhionn",
                "fionn",
                "gruaig",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("duine le falt bàn"),
            keywords: &[
                "bàn",
                "duine",
                "duine le falt bàn",
                "falt",
                "fear",
                "fireannach",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("home louro"),
            keywords: &["home", "loiro", "louro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{ac1}ર\u{ac1}ષ: પીળાશ પડતા\u{a82} વાળ"),
            keywords: &[
                "પીળાશ પડતા\u{a82} વાળવાળો પ\u{ac1}ર\u{ac1}ષ",
                "પીળાશ પડતો",
                "પ\u{ac1}ર\u{ac1}ષ",
                "પ\u{ac1}ર\u{ac1}ષ: પીળાશ પડતા\u{a82} વાળ",
                "વાળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("namiji mai farin gashi"),
            keywords: &["mai farin gashi", "mutum", "namiji mai farin gashi"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בלונדיני"),
            keywords: &["איש", "בלונדיני", "גבר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{941}नहर\u{947} बालो\u{902} वाला प\u{941}र\u{941}ष"),
            keywords: &[
                "आदमी",
                "गोरा",
                "प\u{941}र\u{941}ष",
                "स\u{941}नहर\u{947} बालो\u{902} वाला प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("plavokosi muškarac"),
            keywords: &["kosa", "muškarac", "plava kosa", "plavokosi muškarac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szőke férfi"),
            keywords: &["férfi", "szőke"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("շիկահեր տղամարդ"),
            keywords: &["շեկ", "շիկահեր", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria berambut pirang"),
            keywords: &[
                "laki-laki",
                "pirang",
                "pria berambut pirang",
                "pria: rambut pirang",
                "rambut",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nwoke nwere isi-awọ"),
            keywords: &["isi awọ", "nwoke", "nwoke nwere isi-awọ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("ljóshærður maður"),
            keywords: &["ljóshærður", "ljóst hár", "maður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo biondo"),
            keywords: &["biondo", "maschio", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("金髪の男性"),
            keywords: &["ブロンド", "男", "男性", "金髪", "金髪の男性"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong lanang: rambut pirang"),
            keywords: &[
                "pirang",
                "rambut",
                "wong lanang",
                "wong lanang arambut pirang",
                "wong lanang: rambut pirang",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ქერათმიანი კაცი"),
            keywords: &["კაცი", "ქერა", "ქერათმიანი კაცი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аққұба ер адам"),
            keywords: &["аққұба", "аққұба ер адам", "ер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("blond mand"),
            keywords: &["blond", "lyshåret", "mand"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសសក\u{17cb}ទង\u{17cb}ដែង"),
            keywords: &[
                "ទង\u{17cb}ដែង",
                "ប\u{17bb}រស",
                "ប\u{17bb}រសសក\u{17cb}ទង\u{17cb}ដែង",
                "ប\u{17d2}រ\u{17bb}ស",
                "សក\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ಪುರುಷ"),
            keywords: &[
                "ಪುರುಷ",
                "ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ಪುರುಷ",
                "ಹೊಂಬಣ\u{ccd}ಣ ಕ\u{cc2}ದಲ\u{cbf}ನ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("금발 남자"),
            keywords: &["금발", "남성", "남자"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दादलो : पि\u{902}गश\u{947} क\u{947}\u{902}स"),
            keywords: &[
                "क\u{947}\u{902}स",
                "दादलो",
                "दादलो : पि\u{902}गश\u{947} क\u{947}\u{902}स",
                "दादलो: पि\u{902}गश\u{947} क\u{947}\u{902}स",
                "पि\u{902}गश\u{947}",
                "पि\u{902}गश\u{947} क\u{947}सा\u{902}चो दादलो",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сары чачтуу эркек"),
            keywords: &["сары чач", "сары чачтуу эркек", "эркек"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("blonde Mann"),
            keywords: &["Mann", "blond", "blonde Mann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊາຍຜ\u{ebb}ມບລອນ"),
            keywords: &[
                "ຊາຍຜ\u{ebb}ມບລອນ",
                "ບລອນ",
                "ຜ\u{eb9}\u{ec9}ຊາຍ",
                "ຜ\u{ebb}ມທອງ",
                "ຜ\u{ebb}ມສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("blondinas"),
            keywords: &["blondinas", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("blondīns"),
            keywords: &["blondīns", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāne mākekehu"),
            keywords: &["mākekehu", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("русокос маж"),
            keywords: &["маж", "руса коса", "русокос маж"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പ\u{d41}ര\u{d41}ഷൻ: സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടി"),
            keywords: &[
                "തലമ\u{d41}ടി",
                "പ\u{d41}ര\u{d41}ഷൻ",
                "പ\u{d41}ര\u{d41}ഷൻ: സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടി",
                "സ\u{d4d}വർണ\u{d4d}ണത\u{d4d}തലമ\u{d41}ടിയ\u{d41}ള\u{d4d}ള പ\u{d41}ര\u{d41}ഷൻ",
                "സ\u{d4d}വർണ\u{d4d}ണവർണ\u{d4d}ണം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шар үстэй эрэгтэй"),
            keywords: &["цайвар шар үс", "шар үстэй эрэгтэй", "эр", "эрэгтэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("सोन\u{947}री क\u{947}सा\u{902}चा प\u{941}र\u{941}ष"),
            keywords: &[
                "क\u{947}स",
                "प\u{941}र\u{941}ष",
                "सोन\u{947}री",
                "सोन\u{947}री क\u{947}सा\u{902}चा प\u{941}र\u{941}ष",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki: rambut perang"),
            keywords: &[
                "lelaki",
                "lelaki berambut perang muda",
                "lelaki: berambut perang muda",
                "lelaki: rambut perang",
                "perang muda",
                "rambut",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel b’xagħar isfar"),
            keywords: &["raġel", "raġel b’xagħar isfar", "xagħar isfar"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အမျ\u{102d}\u{102f}းသား- ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030}",
            ),
            keywords: &[
                "ဆ\u{1036}ကေသာ",
                "ရ\u{103d}\u{103e}ေရောင\u{103a}",
                "ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030} အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား",
                "အမျ\u{102d}\u{102f}းသား- ရ\u{103d}\u{103e}ေရောင\u{103a}ဆ\u{1036}ကေသာရ\u{103e}\u{102d}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mann: blond"),
            keywords: &["blond", "hår", "mann", "mann: blond"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("क\u{948}लो कपाल भएको छोरामान\u{94d}छ\u{947}"),
            keywords: &[
                "क\u{948}लो",
                "क\u{948}लो कपाल भएको छोरामान\u{94d}छ\u{947}",
                "छोरामान\u{94d}छ\u{947}",
                "प\u{941}र\u{942}ष",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("man met blond haar"),
            keywords: &["blond", "haar", "man", "man met blond haar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mann: blond"),
            keywords: &["blond", "hår", "mann", "mann: blond"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b41}ର\u{b41}ଷ: ସ\u{b41}ନେଲ\u{b3f} କେଶ"),
            keywords: &[
                "କେଶ",
                "ପ\u{b41}ର\u{b41}ଷ",
                "ପ\u{b41}ର\u{b41}ଷ: ସ\u{b41}ନେଲ\u{b3f} କେଶ",
                "ସ\u{b41}ନେଲ\u{b3f}",
                "ସ\u{b41}ନେଲ\u{b3f}-କେଶଥ\u{b3f}ବ\u{b3e} ପ\u{b41}ର\u{b41}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a71}ਕ\u{a47} ਵਾਲਾ\u{a02} ਵਾਲਾ ਪ\u{a41}ਰਸ\u{a3c}"),
            keywords: &[
                "ਕ\u{a71}ਕ\u{a47} ਵਾਲਾ\u{a02} ਵਾਲਾ ਪ\u{a41}ਰਸ\u{a3c}",
                "ਪ\u{a41}ਰਸ\u{a3c}",
                "ਬ\u{a70}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ب\u{64f}ھورے والاں آلا آدمی"),
            keywords: &["بندہ", "ب\u{64f}ھورے والاں آلا آدمی", "گورے رنگ آلی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Man Wé Gẹ\u{301}t Blọ\u{301}nd Hea"),
            keywords: &[
                "Blọnd",
                "Hea",
                "Man",
                "Man Wé Gẹ\u{301}t Blọ\u{301}nd Hea",
                "Man: Blọ\u{301}nd Hea",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("blondyn"),
            keywords: &["blondyn", "mężczyzna"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سړی: د زيړ وېښتانو"),
            keywords: &[
                "د زېړ ويښتانو",
                "د زېړ وېښتانو سړی",
                "سړی",
                "سړی: د زيړ وېښتانو",
                "وېښتان",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem: cabelo loiro"),
            keywords: &["cabelo", "homem", "homem: cabelo loiro", "loiro", "louro"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "homem",
                "homem com cabelo loiro",
                "homem com cabelo louro",
                "homem loiro",
                "homem: cabelo loiro",
                "louro",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("runa: qillu chukcha"),
            keywords: &[
                "chukcha",
                "qʼillu",
                "runa",
                "runa: qillu chukcha",
                "runa:qillu chukcha",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bărbat blond"),
            keywords: &["blond", "bărbat", "bărbat cu păr blond", "păr"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1195"),
            keywords: &["E10-1195"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("блондин"),
            keywords: &[
                "блондин",
                "мужчина",
                "мужчина со светлыми волосами",
                "светлые волосы",
                "человек со светлыми волосами",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umugabo ufite imisatsi yera"),
            keywords: &["inzobe", "umugabo", "umugabo ufite imisatsi yera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ماڻهو: ڀورا وار"),
            keywords: &[
                "ماڻهو",
                "ماڻهو: ڀورا وار",
                "وار",
                "ڀورا وار",
                "ڀورن وارن وارو ماڻهو",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("තඹ පැහැ කොණ\u{dca}ඩය සහ\u{dd2}ත ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "තඹ පැහැ",
                "තඹ පැහැ කොණ\u{dca}ඩය සහ\u{dd2}ත ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "ප\u{dd2}ර\u{dd2}ම\u{dd2}",
                "ම\u{dd2}න\u{dd2}හ\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("blondín"),
            keywords: &["blond", "blondín", "muž", "svetlovlasý"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("moški: blondinec"),
            keywords: &["blondinec", "fant", "lasje", "moški", "moški: blondinec"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin: timo cad"),
            keywords: &["nin", "nin timo cad", "nin: timo cad", "timo", "timo cad"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë biond"),
            keywords: &["biond", "burrë", "mashkull"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плав мушкарац"),
            keywords: &["мушкарац", "плав мушкарац", "плава коса"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("plav muškarac"),
            keywords: &["muškarac", "plav muškarac", "plava kosa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("blond man"),
            keywords: &["blond", "man"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mwanamume mwenye nywele ya kimanjano"),
            keywords: &[
                "manjano",
                "mwanamume",
                "mwanamume mwenye nywele ya kimanjano",
                "nywele",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பொன\u{bcd}னிற முடி கொண\u{bcd}ட ஆண\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "பொன\u{bcd}னினிறம\u{bcd}",
                "பொன\u{bcd}னிற முடி கொண\u{bcd}ட ஆண\u{bcd}",
                "மஞ\u{bcd}சள\u{bcd}",
                "முடி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("త\u{c46}ల\u{c4d}లన\u{c3f} జుట\u{c4d}టు గల పురుషుడు"),
            keywords: &[
                "త\u{c46}ల\u{c4d}లన\u{c3f} జుట\u{c4d}టు",
                "త\u{c46}ల\u{c4d}లన\u{c3f} జుట\u{c4d}టు గల పురుషుడు",
                "పురుషుడు",
                "మగ\u{c3e}డు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди зардинамӯй"),
            keywords: &["зардинамӯй", "мард", "марди зардинамӯй"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ผ\u{e39}\u{e49}ชายผมทอง"),
            keywords: &[
                "ผม",
                "ผมทอง",
                "ผ\u{e39}\u{e49}ชาย",
                "ผ\u{e39}\u{e49}ชายผมทอง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("erkek adam: sary saç"),
            keywords: &[
                "erkek adam",
                "erkek adam: sary saç",
                "sary saçly",
                "sary saçly erkek adam",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tangata ʻulu kelo"),
            keywords: &["tangata ʻulu kelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sarışın erkek"),
            keywords: &["adam", "erkek", "sarışın"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئالتۇن چاچ ئەر"),
            keywords: &["ئالتۇن چاچ", "ئالتۇن چاچ ئەر", "ئەر"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("чоловік із білявим волоссям"),
            keywords: &[
                "блондин",
                "білявий",
                "волосся",
                "чоловік із білявим волоссям",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سنہرے بالوں والا مرد"),
            keywords: &["بھورے بال", "سنہرے بال", "سنہرے بالوں والا مرد", "مرد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("erkak: mallasoch"),
            keywords: &[
                "erkak",
                "erkak: mallasoch",
                "mallasoch",
                "sariq sochli erkak",
                "soch",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người đàn ông tóc vàng hoe"),
            keywords: &[
                "người đàn ông tóc vàng hoe",
                "tóc vàng hoe",
                "đàn ông",
                "đàn ông: tóc vàng hoe",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("góor gu am karaw gu mboq"),
            keywords: &["góor", "góor gu am karaw gu mboq", "karaw gu mboq"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda eneenwele ezimhlophe"),
            keywords: &["indoda", "indoda eneenwele ezimhlophe", "mhlophe"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọkùnrin onírun funfun"),
            keywords: &["onírun funfun", "ọkùnrin", "ọkùnrin onírun funfun"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("金色頭髮嘅男人"),
            keywords: &["男", "金色頭髮", "金色頭髮嘅男人"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("金色头发嘅男人"),
            keywords: &["男", "金色头发", "金色头发嘅男人"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("金发男"),
            keywords: &["男", "金发", "金发男"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("金髮男"),
            keywords: &["男", "金髮", "金髮男"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("金髮男人"),
            keywords: &["男", "金髮", "金髮男人"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indoda: izinwele ezimhlophe"),
            keywords: &[
                "indoda",
                "indoda enezinwele ezimhlophe",
                "indoda: izinwele ezimhlophe",
                "izinwele",
                "mhlophe",
            ],
        },
    ],
};
#[doc = "👱🏻\u{200d}♂\u{fe0f}"]
pub const MAN_LIGHT_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏻\u{200d}♂\u{fe0f}",
    codepoint: "1F471 1F3FB 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man: light skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏻\u{200d}♂",
        codepoint: "1F471 1F3FB 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man: light skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏼\u{200d}♂\u{fe0f}"]
pub const MAN_MEDIUM_LIGHT_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏼\u{200d}♂\u{fe0f}",
    codepoint: "1F471 1F3FC 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man: medium-light skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏼\u{200d}♂",
        codepoint: "1F471 1F3FC 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man: medium-light skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏽\u{200d}♂\u{fe0f}"]
pub const MAN_MEDIUM_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏽\u{200d}♂\u{fe0f}",
    codepoint: "1F471 1F3FD 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man: medium skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏽\u{200d}♂",
        codepoint: "1F471 1F3FD 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man: medium skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏾\u{200d}♂\u{fe0f}"]
pub const MAN_MEDIUM_DARK_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏾\u{200d}♂\u{fe0f}",
    codepoint: "1F471 1F3FE 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man: medium-dark skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏾\u{200d}♂",
        codepoint: "1F471 1F3FE 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man: medium-dark skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "👱🏿\u{200d}♂\u{fe0f}"]
pub const MAN_DARK_SKIN_TONE_BLOND_HAIR: crate::Emoji = crate::Emoji {
    glyph: "👱🏿\u{200d}♂\u{fe0f}",
    codepoint: "1F471 1F3FF 200D 2642 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 4f32,
    name: "man: dark skin tone, blond hair",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👱🏿\u{200d}♂",
        codepoint: "1F471 1F3FF 200D 2642",
        status: crate::Status::MinimallyQualified,
        introduction_version: 4f32,
        name: "man: dark skin tone, blond hair",
        group: "People & Body",
        subgroup: "person",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[],
};
#[doc = "🧓"]
pub const OLDER_PERSON: crate::Emoji = crate::Emoji {
    glyph: "🧓",
    codepoint: "1F9D3",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "older person",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ouer volwassene"),
            keywords: &[
                "geslagneutraal",
                "ongespesifiseerde geslag",
                "oud",
                "ouer persoon",
                "ouer volwassene",
                "volwassene",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ያረጀ ጎልማሳ"),
            keywords: &["ያረጀ ጎልማሳ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("بالغ أكبر في السن"),
            keywords: &["بالغ أكبر في السن", "عجوز", "كبير في السن"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বয\u{9bc}স\u{9cd}ক প\u{9cd}ৰ\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক"),
            keywords: &[
                "বয\u{9bc}স\u{9cd}ক",
                "বয\u{9bc}স\u{9cd}ক প\u{9cd}ৰ\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক",
                "লিংগ নিউট\u{9cd}ৰেল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşlı böyük"),
            keywords: &["gender-neytral", "qoca", "yaşlı böyük"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("у гадах"),
            keywords: &["няпэўнага полу", "у гадах", "чалавек сталага ўзросту"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("по-възрастен човек"),
            keywords: &[
                "без определен пол",
                "възрастен",
                "неопределен пол",
                "по-възрастен човек",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("বড\u{9bc} প\u{9cd}র\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক"),
            keywords: &[
                "বড\u{9bc} প\u{9cd}র\u{9be}প\u{9cd}তবয\u{9bc}স\u{9cd}ক",
                "বয\u{9bc}স\u{9cd}ক",
                "লিঙ\u{9cd}গ-নিরপেক\u{9cd}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("den kozh"),
            keywords: &["den", "kozh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("starija odrasla osoba"),
            keywords: &[
                "neodređen spol",
                "srednji rod",
                "starija odrasla osoba",
                "staro",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("persona gran"),
            keywords: &["adult", "gran", "persona"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{1112a}𑄢\u{1112e} 𑄉𑄝\u{1112a}𑄢\u{11134}"),
            keywords: &["𑄝\u{1112a}𑄢\u{1112e} 𑄉𑄝\u{1112a}𑄢\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏴᎵ ᎤᏔᎾ"),
            keywords: &[
                "ᎠᎦᏴᎵ",
                "ᎠᎦᏴᎵ ᎤᏔᎾ",
                "ᎠᎦᏴᎵ ᏴᏫ",
                "ᎢᏳᏍᏗ ᎨᎲ ᏄᏬᎵᏍᏛᎾ",
                "ᎢᏳᏍᏗ ᎨᎲ-ᎢᏳᏍᏗᏊ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("starší dospělý člověk"),
            keywords: &[
                "neutrální",
                "osoba",
                "stará",
                "starý",
                "starší dospělý člověk",
                "člověk",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("oedolyn oedranus"),
            keywords: &["hen", "niwtral o ran rhyw", "oedolyn oedranus"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gammel person"),
            keywords: &["gammel person", "voksen", "ældre menneske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("älterer Erwachsener"),
            keywords: &[
                "alt",
                "geschlechtsneutral",
                "ohne eindeutiges Geschlecht",
                "älterer Erwachsener",
                "älterer Mensch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεγαλύτερος ενήλικας"),
            keywords: &["άφυλος", "ηλικιωμένος", "μεγαλύτερος ενήλικας"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("older person"),
            keywords: &[
                "adult",
                "gender-neutral",
                "old",
                "older person",
                "unspecified gender",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("persona mayor"),
            keywords: &[
                "género",
                "maduro",
                "mayor",
                "neutro",
                "persona adulta madura",
                "persona mayor",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("adulto mayor"),
            keywords: &[
                "adulto mayor",
                "género",
                "maduro",
                "mayor",
                "neutro",
                "persona adulta madura",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("persona mayor"),
            keywords: &[
                "género",
                "maduro",
                "mayor",
                "neutro",
                "persona mayor",
                "persona vieja",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "adulto",
                "género neutro",
                "género no especificado",
                "mayor",
                "persona anciana",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("eakas"),
            keywords: &["eakas", "sooliselt neutraalne", "vana"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("agure"),
            keywords: &["adineko", "agure", "genero neutroko"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("میان\u{200c}سال"),
            keywords: &["جنس خنثی", "مسن", "میان\u{200c}سال", "پیر"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vanhus"),
            keywords: &[
                "ikäihminen",
                "seniori",
                "sukupuolineutraali",
                "vanha",
                "vanhus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mas matandang tao"),
            keywords: &[
                "hindi tinukoy na kasarian",
                "kasarian-neutral",
                "magulang",
                "mas matandang tao",
                "matanda",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tilkomin"),
            keywords: &["eldri", "tilkomin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("personne âgée"),
            keywords: &["adulte", "genre neutre", "personne âgée", "âgé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["adulte", "genre non défini", "personne", "âgée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seanduine"),
            keywords: &["neodrach ó thaobh inscne de", "sean", "seanduine"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("seann-inbheach"),
            keywords: &["gun ghnè", "sean", "seann", "seann-inbheach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("persoa maior"),
            keywords: &["ancián", "persoa maior", "vello", "xénero neutro"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{ac3}દ\u{acd}ધ વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "અનિર\u{acd}દિષ\u{acd}ટ લિ\u{a82}ગ",
                "જ\u{ac2}ના",
                "જ\u{ac2}ની વ\u{acd}યક\u{acd}તિ",
                "પ\u{ac1}ખ\u{acd}ત",
                "લિ\u{a82}ગ-તટસ\u{acd}થ",
                "વ\u{ac3}દ\u{acd}ધ વ\u{acd}યક\u{acd}તિ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babba mafi tsoho"),
            keywords: &["babba mafi tsoho", "mara danganta ga jinsi", "tsoho"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איש מבוגר"),
            keywords: &["איש מבוגר", "מבוגר", "מבוגרת", "מגדר נייטרלי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("व\u{943}द\u{94d}ध व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "ल\u{948}\u{902}गिक र\u{942}प स\u{947} निष\u{94d}पक\u{94d}ष",
                "व\u{943}द\u{94d}ध",
                "व\u{943}द\u{94d}ध व\u{94d}यक\u{94d}ति",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("starija osoba"),
            keywords: &["rodno neutralno", "stara osoba", "starija osoba"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("idősebb felnőtt"),
            keywords: &["idős", "idősebb felnőtt", "nemi szempontból semleges"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տարեց մարդ"),
            keywords: &["ծեր", "չեզոք սեռ", "տարեց", "տարեց մարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lanjut usia"),
            keywords: &["lanjut usia", "netral gender", "tua"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kara dị okenye"),
            keywords: &["kara dị okenye", "oke na nne-ndịnaetiti", "okenye"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eldri fullorðinn"),
            keywords: &["eldri fullorðinn", "gamall", "kynhlutlaust"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("persona anziana"),
            keywords: &["adulto anziano", "anziano", "persona anziana"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("お年寄り"),
            keywords: &["お年寄り", "老人", "顔", "高齢者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong tuwa"),
            keywords: &[
                "jender netral",
                "ora tamtu lanang wadone",
                "tuwa",
                "wong diwasa",
                "wong tuwa",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჭარმაგი"),
            keywords: &["გენდერ-ნეიტრალური", "ჭარმაგი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amengaḍ meqqren"),
            keywords: &["amengaḍ meqqren"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарт адам"),
            keywords: &["ересек", "қарт адам"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មន\u{17bb}ស\u{17d2}សចាស\u{17cb}"),
            keywords: &[
                "ចាស\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សចាស\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សធ\u{17c6}",
                "ម\u{17b7}នបញ\u{17d2}ជាក\u{17cb}ភេទ",
                "អភេទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹ\u{cbf}ರ\u{cbf}ಯ ವಯಸ\u{ccd}ಕರು"),
            keywords: &[
                "ಲ\u{cbf}ಂಗ-ತಟಸ\u{ccd}ಥ",
                "ಹ\u{cbf}ರ\u{cbf}ಯ",
                "ಹ\u{cbf}ರ\u{cbf}ಯ ವಯಸ\u{ccd}ಕರು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("노인"),
            keywords: &["노인", "성별 없음", "성인"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: None,
            keywords: &[
                "अउल\u{94d}ल\u{947}खीत लि\u{902}ग",
                "जाण\u{94d}टो",
                "जाण\u{94d}टो मनीस",
                "प\u{94d}रौढ",
                "लि\u{902}ग-तटस\u{94d}थ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кары адам"),
            keywords: &["жынысы белгисиз", "кары адам"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("eeleren Erwuessenen"),
            keywords: &["al", "eeleren Erwuessenen", "neutral"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ໃຫຍ\u{ec8}ທ\u{eb5}\u{ec8}ມ\u{eb5}ອາຍ\u{eb8}"),
            keywords: &[
                "ຜ\u{eb9}\u{ec9}ໃຫຍ\u{ec8}ທ\u{eb5}\u{ec8}ມ\u{eb5}ອາຍ\u{eb8}",
                "ເພດກາງ",
                "ແກ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kitas suaugusysis"),
            keywords: &["kitas suaugusysis", "neutrali lytis", "senas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vecāks pieaugušais"),
            keywords: &["bezdzimuma", "dzimumneitrāls", "vecs", "vecāks pieaugušais"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kaumātua"),
            keywords: &["ira-kūpapa", "kaumātua"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("постаро возрасно лице"),
            keywords: &["пол-неутрален", "постаро возрасно лице", "старо"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വയസ\u{d4d}സ\u{d3e}യ വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "അനിശ\u{d4d}ചിത ലിംഗഭേദം",
                "പ\u{d4d}ര\u{d3e}യ\u{d3e}ധിക\u{d4d}യമ\u{d41}ള\u{d4d}ള വ\u{d4d}യക\u{d4d}തി",
                "മ\u{d41}തിർന\u{d4d}നയ\u{d3e}ൾ",
                "ലിംഗഭേദമില\u{d4d}ല",
                "വയസ\u{d4d}സ\u{d3e}യ വ\u{d4d}യക\u{d4d}തി",
                "വ\u{d3e}ർദ\u{d4d}ധക\u{d4d}യം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("настай хүн"),
            keywords: &["жендер-саармаг", "настай хүн", "хөгшин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}रौढ"),
            keywords: &["प\u{94d}रौढ", "लि\u{902}ग-तटस\u{94d}थ", "व\u{943}द\u{94d}ध"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("dewasa lebih tua"),
            keywords: &["dewasa lebih tua", "gender-neutral", "tua"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("adulti anzjan"),
            keywords: &["adulti anzjan", "anzjan", "newtrali fil-ġeneru"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အသက\u{103a}ကြ\u{102e}းသ\u{1030}"),
            keywords: &[
                "လ\u{102d}င\u{103a}မခ\u{103d}\u{1032}ခြားသော",
                "လ\u{102d}င\u{103a}သတ\u{103a}မ\u{103e}တ\u{103a}မထားသော",
                "သက\u{103a}ကြ\u{102e}း",
                "အရ\u{103d}ယ\u{103a}ရောက\u{103a}သ\u{1030}",
                "အသက\u{103a}ကြ\u{102e}းသ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("eldre voksen"),
            keywords: &[
                "eldre voksen",
                "gammel",
                "kjønnsnøytral",
                "menneske",
                "voksen",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पाको वयस\u{94d}क"),
            keywords: &[
                "पाको वयस\u{94d}क",
                "ल\u{948}ङ\u{94d}गिक हिसाबल\u{947} तटस\u{94d}थ",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oudere persoon"),
            keywords: &[
                "genderneutraal",
                "oud",
                "oudere persoon",
                "oudere volwassene",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("eldre vaksen"),
            keywords: &[
                "eldre vaksen",
                "gamal",
                "kjønnsnøytral",
                "menneske",
                "vaksen",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅଧ\u{b3f}କ ବୟସ\u{b4d}କ"),
            keywords: &[
                "ଅଧ\u{b3f}କ ବୟସ\u{b4d}କ",
                "ଅନ\u{b3f}ର\u{b4d}ଦ\u{b4d}ଦ\u{b3f}ଷ\u{b4d}ଟ ଲ\u{b3f}ଙ\u{b4d}ଗ",
                "ବ\u{b43}ଦ\u{b4d}ଧ",
                "ବୟସ\u{b4d}କ",
                "ଲ\u{b3f}ଙ\u{b4d}ଗ-ନ\u{b3f}ରପେକ\u{b4d}ଷ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਵ\u{a71}ਡੀ ਉਮਰ ਦਾ ਆਦਮੀ"),
            keywords: &["ਬਜ\u{a3c}\u{a41}ਰਗ", "ਵ\u{a71}ਡੀ ਉਮਰ ਦਾ ਆਦਮੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سیانے بالغ"),
            keywords: &["سیانے بالغ", "غیر جانبدار-صنف", "پرانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Síniọ\u{301} Pẹ\u{301}sin"),
            keywords: &[
                "Machọ\u{301} Pẹ\u{301}sin",
                "Old",
                "Pẹ\u{301}sin Wé Dẹm Nó Tọk Wẹ\u{301}dá Na Man Ọ Wúman",
                "Pẹ\u{301}sin Wé Nọ\u{301} Bi Man Ọ Wúman",
                "Síniọ\u{301} Pẹ\u{301}sin",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("starszy dorosły"),
            keywords: &["płeć neutralna", "starszy dorosły", "stary"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زوړ شخص"),
            keywords: &["بالغ", "زوړ", "زوړ شخص", "نامعلومه جنس", "نر ښځۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("idoso"),
            keywords: &["adulto", "idoso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("pessoa idosa"),
            keywords: &["género neutro", "pessoa de idade", "pessoa idosa"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñawpa runa"),
            keywords: &[
                "genero",
                "genero neutral",
                "hatun",
                "mana akllasqa",
                "puriq runa",
                "ñawpa runa",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("persoană în vârstă"),
            keywords: &[
                "adult",
                "bătrân",
                "neutru",
                "persoană în vârstă",
                "vârstnic",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1124"),
            keywords: &["E10-1124"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пожилой человек"),
            keywords: &[
                "в возрасте",
                "гендерно нейтральный",
                "пожилой",
                "пожилой человек",
                "старый",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umuntu mukuru ushaje"),
            keywords: &["umuntu mukuru ushaje", "ushaje", "utagaragaza igitsina"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وڏي عمر جو بالغ"),
            keywords: &["غيرجانبدرا، وڏو", "وڏي عمر جو بالغ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මහල\u{dd4} වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}ය\u{dcf}"),
            keywords: &[
                "මහල\u{dd4}",
                "මහල\u{dd4} වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}ය\u{dcf}",
                "ස\u{dca}ත\u{dca}\u{200d}ර\u{dd3} ප\u{dd4}ර\u{dd4}ෂභ\u{dcf}වය උද\u{dcf}ස\u{dd3}න",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("starší človek"),
            keywords: &["starý", "starší človek", "človek"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("starejši odrasli"),
            keywords: &["spolno nevtralen", "starejši", "starejši odrasli"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qof weyn"),
            keywords: &[
                "dhexdehexaadnimada jinsiga",
                "jansiga aan la sheegin",
                "qof weyn",
                "weyn",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("i ri"),
            keywords: &["i ri", "i rritur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("старија одрасла особа"),
            keywords: &["неутралан пол", "стaрoст", "старија одрасла особа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("starija odrasla osoba"),
            keywords: &["neutralan pol", "starija odrasla osoba", "starost"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("äldre person"),
            keywords: &["gammal", "könsneutral", "vuxen", "äldre", "äldre person"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mzee"),
            keywords: &["asiyejitambulisha na jinsia yoyote", "mzee"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வயத\u{bbe}னவர\u{bcd}"),
            keywords: &[
                "ஆண\u{bcd}",
                "பெண\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
                "வயத\u{bbe}னவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వృద\u{c4d}ధులు"),
            keywords: &["ల\u{c3f}ంగం-తటస\u{c4d}థ", "వృద\u{c4d}ధ", "వృద\u{c4d}ధులు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("калонсоли пир"),
            keywords: &["баробарии ҷинсҳо", "калонсоли пир", "пир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คนชรา"),
            keywords: &[
                "คนชรา",
                "ผ\u{e39}\u{e49}ใหญ\u{e48}",
                "เป\u{e47}นกลางทางเพศ",
                "แก\u{e48}",
                "ไม\u{e48}ระบ\u{e38}เพศ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gartaşan kişi"),
            keywords: &[
                "garry",
                "gartaşan",
                "gartaşan adam",
                "gartaşan kişi",
                "jynsyýeti görkezilmedik",
                "jynsyýeti tapawut etmeýän",
                "uly ýaşly",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tokotaha motuʻa"),
            keywords: &["tokotaha motuʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaşlı yetişkin"),
            keywords: &["kişi", "yaşlı", "yaşlı yetişkin"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قېرىلار"),
            keywords: &["جىنىسسىز", "قېرى", "قېرىلار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("літня людина"),
            keywords: &[
                "гендерно-нейтральний",
                "дорослий",
                "літня людина",
                "неозначеної статі",
                "старий",
                "старша людина",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بوڑھا بالغ"),
            keywords: &["بوڑھا", "بوڑھا بالغ", "صنفی غیر جانبدار"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qari odam"),
            keywords: &[
                "jinsi noaniq",
                "keksa",
                "neytral jins",
                "qari odam",
                "qariya",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("người lớn tuổi"),
            keywords: &[
                "già",
                "giới tính không xác định",
                "giới tính trung lập",
                "người lớn tuổi",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("mag mu gën a màgget"),
            keywords: &["du góor du jigéen", "mag mu gën a màgget", "màgget"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umntu omdala ngakumbi"),
            keywords: &[
                "endala",
                "engathathi-cala ngokwesini",
                "umntu omdala ngakumbi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àgbàlagbà"),
            keywords: &["arúgbó", "gé\u{329}ndà-ṣekuṣẹyẹ", "àgbàlagbà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("老人"),
            keywords: &["中性", "老人", "老年"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("老人"),
            keywords: &["中性", "老人", "老年"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("老年人"),
            keywords: &["性别不明", "性别中性", "成人", "老人", "老年人"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("長者"),
            keywords: &["長者"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["老人家", "老年人", "長者"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("omdala omdala"),
            keywords: &["mdala", "omdala omdala", "ubulili-phakathi"],
        },
    ],
};
#[doc = "🧓🏻"]
pub const OLDER_PERSON_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧓🏻",
    codepoint: "1F9D3 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "older person: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧓🏼"]
pub const OLDER_PERSON_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧓🏼",
    codepoint: "1F9D3 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "older person: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧓🏽"]
pub const OLDER_PERSON_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧓🏽",
    codepoint: "1F9D3 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "older person: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧓🏾"]
pub const OLDER_PERSON_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧓🏾",
    codepoint: "1F9D3 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "older person: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧓🏿"]
pub const OLDER_PERSON_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🧓🏿",
    codepoint: "1F9D3 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "older person: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👴"]
pub const OLD_MAN: crate::Emoji = crate::Emoji {
    glyph: "👴",
    codepoint: "1F474",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "old man",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ou man"),
            keywords: &["man", "ou man", "oud"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሽማግሌ"),
            keywords: &["ሽማግሌ", "ወንድ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رجل عجوز"),
            keywords: &["أشخاص", "رجل", "عجوز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বয\u{9bc}ষষ\u{9cd}ঠ ম\u{9be}ন\u{9c1}হ"),
            keywords: &[
                "প\u{9c1}ৰ\u{9c1}ষ",
                "বয\u{9bc}ষষ\u{9cd}ঠ ম\u{9be}ন\u{9c1}হ",
                "বয\u{9bc}স\u{9cd}ক",
                "ব\u{9c3}দ\u{9cd}ধ ম\u{9be}ন\u{9c1}হ",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşlı kişi"),
            keywords: &["kişi", "yaşlı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дзядуля"),
            keywords: &["дзядуля", "мужчына", "стары"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("старец"),
            keywords: &["възрастен", "мъж", "стар", "старец"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}দ\u{9cd}ধ প\u{9c1}র\u{9c1}ষ"),
            keywords: &[
                "প\u{9c1}র\u{9c1}ষ",
                "বয\u{9bc}স\u{9cd}ক",
                "ব\u{9c3}দ\u{9cd}ধ প\u{9c1}র\u{9c1}ষ",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gwaz kozh"),
            keywords: &["gwaz", "kozh"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("starac"),
            keywords: &["muškarac", "odrasla osoba", "star", "starac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("home gran"),
            keywords: &["ancià", "gran", "home"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{1112a}𑄢\u{1112e} 𑄟𑄚\u{1112a}𑄌\u{11134}"),
            keywords: &["𑄝\u{1112a}𑄢\u{1112e} 𑄟𑄚\u{1112a}𑄌\u{11134}"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏛᏐᏅ"),
            keywords: &["ᎠᎬᏴᎵ", "ᎠᏍᎦᏯ", "ᎤᏛᏐᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("starý muž"),
            keywords: &["muž", "pán", "senior", "starý", "stařec"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hen ddyn"),
            keywords: &["dyn", "gwrywaidd", "hen", "hen ddyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gammel mand"),
            keywords: &["gammel mand", "mand", "menneske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("älterer Mann"),
            keywords: &["Gesicht", "Mann", "Senior", "älterer Mann"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηλικιωμένος"),
            keywords: &["άντρας", "ενήλικας", "ηλικιωμένος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("old man"),
            keywords: &["adult", "man", "old"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("anciano"),
            keywords: &["anciano", "hombre", "mayor"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("hombre mayor"),
            keywords: &["cara", "hombre", "mayor", "señor", "viejo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["adulto", "anciano", "hombre", "hombre mayor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("eakas mees"),
            keywords: &["eakas mees", "mees", "vana"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aitona"),
            keywords: &["agure", "aitona", "gizon", "gizonezko", "zahar"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیرمرد"),
            keywords: &["مرد", "پیر", "پیرمرد"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vanha mies"),
            keywords: &["mies", "vanha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("matandang lalaki"),
            keywords: &["lalaki", "matanda", "matandang lalaki"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gamal maður"),
            keywords: &["eldri", "gamal", "mannfólk", "maður"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("homme âgé"),
            keywords: &["homme", "âgé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["adulte", "homme", "âgé"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seanfhear"),
            keywords: &["fear", "sean", "seanfhear"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bodach"),
            keywords: &["bodach", "duine", "fear", "fireannach", "sean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vello"),
            keywords: &["ancián", "home", "vello"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{ac3}દ\u{acd}ધ પ\u{ac1}ર\u{ac1}ષ"),
            keywords: &[
                "પ\u{ac1}ખ\u{acd}ત",
                "પ\u{ac1}ર\u{ac1}ષ",
                "વ\u{ac3}દ\u{acd}ધ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dattijo"),
            keywords: &["dattijo", "mutum", "tsoho"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("איש זקן"),
            keywords: &["איש", "בן", "גבר", "זקן", "מבוגר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{942}ढ\u{93c}ा प\u{941}र\u{941}ष"),
            keywords: &[
                "प\u{941}र\u{941}ष",
                "ब\u{941}ज\u{941}र\u{94d}ग",
                "ब\u{942}ढ\u{93c}ा प\u{941}र\u{941}ष",
                "लोग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("starac"),
            keywords: &["starac", "starost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("idős férfi"),
            keywords: &["idős férfi", "öregember"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տարեց տղամարդ"),
            keywords: &["ծեր", "տարեց", "տղամարդ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("pria tua"),
            keywords: &["kakek", "laki-laki", "pria", "tua"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okenye nwoke"),
            keywords: &["nwoke", "okenye"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eldri maður"),
            keywords: &["eldri maður", "fólk", "gamall", "maður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("uomo anziano"),
            keywords: &["anziano", "nonno", "persone", "uomo"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おじいさん"),
            keywords: &["おじいさん", "お年寄り", "男性", "老人", "顔", "高齢者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong tuwa lanang"),
            keywords: &["tuwa", "wong diwasa", "wong lanang", "wong tuwa lanang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოხუცი კაცი"),
            keywords: &["კაცი", "მოხუცი"],
        },
        #[cfg(feature = "kab")]
        crate::Annotation {
            lang: "kab",
            tts: Some("amɣaṛ"),
            keywords: &["amɣaṛ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарт"),
            keywords: &["ер", "кәрі", "қарт"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gammel mand"),
            keywords: &["gammel mand", "mand", "menneske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17bb}រសច\u{17c6}ណាស\u{17cb}"),
            keywords: &[
                "ចាស\u{17cb}",
                "ប\u{17bb}រស",
                "ប\u{17bb}រសច\u{17c6}ណាស\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សធ\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುದುಕ"),
            keywords: &["ಪುರುಷ", "ಮುದುಕ", "ವೃದ\u{ccd}ದ", "ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("할아버지"),
            keywords: &["남성", "남자", "노인", "성인", "할아버지"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("абышка"),
            keywords: &["абышка", "кары"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ale Mann"),
            keywords: &["Mann", "al", "ale Mann"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຜ\u{eb9}\u{ec9}ຊາຍເຖ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ຊາຍເຖ\u{ebb}\u{ec9}າ",
                "ຜ\u{eb9}\u{ec9}ຊາຍເຖ\u{ebb}\u{ec9}າ",
                "ຜ\u{eb9}\u{ec9}ເຖ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("senas vyras"),
            keywords: &["senas", "vyras"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vecs vīrietis"),
            keywords: &["seja", "vecs", "vectēvs", "vīrietis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("koroua"),
            keywords: &["kaumātua", "koroua", "tāne"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("старец"),
            keywords: &["маж", "машко", "стар", "старец"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d43}ദ\u{d4d}ധൻ"),
            keywords: &[
                "പ\u{d41}ര\u{d41}ഷൻ",
                "മ\u{d41}തിർന\u{d4d}നയ\u{d3e}ൾ",
                "വ\u{d3e}ർദ\u{d4d}ധക\u{d4d}യം",
                "വ\u{d43}ദ\u{d4d}ധൻ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ахимаг насны эрэгтэй хүн"),
            keywords: &[
                "ахимаг",
                "ахимаг насны эрэгтэй хүн",
                "нас",
                "хүн",
                "эрэгтэй",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{943}द\u{94d}ध प\u{941}र\u{942}ष"),
            keywords: &["प\u{941}र\u{942}ष", "व\u{943}द\u{94d}ध"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lelaki tua"),
            keywords: &["lelaki", "tua"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("raġel xiħ"),
            keywords: &["raġel", "xiħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သက\u{103a}ကြ\u{102e}း အမျ\u{102d}\u{102f}းသား"),
            keywords: &[
                "သက\u{103a}ကြ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသား",
                "အရ\u{103d}ယ\u{103a}ရောက\u{103a}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("eldre mann"),
            keywords: &["eldre", "mann", "menneske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{942}ढो छोरामान\u{94d}छ\u{947}"),
            keywords: &["छोरामान\u{94d}छ\u{947}", "ब\u{942}ढो"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oude man"),
            keywords: &["man", "oud", "oude man", "ouder"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("eldre mann"),
            keywords: &["eldre", "mann", "menneske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b43}ଦ\u{b4d}ଧ ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}"),
            keywords: &[
                "ପ\u{b41}ର\u{b41}ଷ",
                "ବ\u{b43}ଦ\u{b4d}ଧ",
                "ବ\u{b43}ଦ\u{b4d}ଧ ବ\u{b4d}ୟକ\u{b4d}ତ\u{b3f}",
                "ବୟସ\u{b4d}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਜ\u{a3c}\u{a41}ਰਗ ਆਦਮੀ"),
            keywords: &[
                "ਬਜ\u{a3c}\u{a41}ਰਗ",
                "ਬਜ\u{a3c}\u{a41}ਰਗ ਆਦਮੀ",
                "ਬ\u{a70}ਦਾ",
                "ਲ\u{a4b}ਕ",
                "ਵ\u{a71}ਡਾ",
                "ਵ\u{a71}ਡੀ ਉਮਰ ਦਾ ਬ\u{a70}ਦਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بڈھا بندا"),
            keywords: &["بندہ", "بڈھا بندا", "پرانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Óld Man"),
            keywords: &["Machọ\u{301} Pẹ\u{301}sin", "Man", "Old", "Óld Man"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("starszy mężczyzna"),
            keywords: &["starszy mężczyzna", "staruszek", "starzec"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زوړ سړی"),
            keywords: &["بالغ", "زوړ", "سړی"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("homem idoso"),
            keywords: &["adulto", "homem", "idoso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("idoso"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hatun tata"),
            keywords: &["hatun", "hatun tata", "puriq runa", "runa"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bătrân"),
            keywords: &["adult", "bărbat", "bătrân"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-561"),
            keywords: &["E10-561"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пожилой мужчина"),
            keywords: &["годы", "мужчина", "пожилой", "старик", "старый", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umusaza"),
            keywords: &["umugabo", "umusaza", "ushaje"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوڙهو ماڻهو"),
            keywords: &["ماڻهو، پوڙهو", "پوڙهو ماڻهو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වයසක ම\u{dd2}න\u{dd2}ස\u{dcf}"),
            keywords: &[
                "මහළ\u{dd4}",
                "ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "වයසක ම\u{dd2}න\u{dd2}ස\u{dcf}",
                "වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("starší muž"),
            keywords: &["muž", "starý", "starší muž"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("starec"),
            keywords: &["moški", "starec", "staro"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("nin da’ weyn"),
            keywords: &["nin", "nin da’ weyn", "qof weyn", "weyn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("burrë i moshuar"),
            keywords: &["burrë", "burrë i moshuar", "i moshuar", "i vjetër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("старац"),
            keywords: &["мушкарац", "одрасла особа", "стaрaц", "старац"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["старац"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("starac"),
            keywords: &["muškarac", "odrasla osoba", "starac"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["starac"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gammal man"),
            keywords: &["gammal", "man", "vuxen", "äldre man"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("babu"),
            keywords: &["babu", "mwanamume", "mzee"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வயத\u{bbe}ன ஆண\u{bcd}"),
            keywords: &[
                "த\u{bbe}த\u{bcd}த\u{bbe}",
                "பெரியவர\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
                "வயத\u{bbe}ன ஆண\u{bcd}",
                "வயத\u{bbe}னவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముసల\u{c3e}యన"),
            keywords: &[
                "త\u{c3e}తయ\u{c4d}య",
                "ముసల\u{c3e}యన",
                "ముసల\u{c3f} వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("марди пир"),
            keywords: &["мард", "марди пир", "пир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ชายแก\u{e48}"),
            keywords: &["คนแก\u{e48}", "ชาย", "ชายแก\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("goja"),
            keywords: &["adam", "garry", "goja", "uly ýaşly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("motuʻa"),
            keywords: &["motuʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaşlı erkek"),
            keywords: &["erkek", "kişiler", "yaşlı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بوۋاي"),
            keywords: &["ئەر", "بوۋاي", "قېرى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("літній чоловік"),
            keywords: &["дорослий", "літній чоловік", "старий", "чоловік"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بوڑھا آدمی"),
            keywords: &["انسان", "بوڑھا", "بوڑھا آدمی", "مرد"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chol"),
            keywords: &["chol", "erkak", "katta yoshli", "qariya"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cụ ông"),
            keywords: &["cụ ông", "già", "người lớn", "đàn ông"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màgget gu góor"),
            keywords: &["góor", "màgget", "màgget gu góor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indoda endala"),
            keywords: &["indoda", "indoda endala", "ndala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Agbalagba Ọkunrin"),
            keywords: &["Agbalagba Ọkunrin", "àgbàlagbà", "ọkùnrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("老伯伯"),
            keywords: &["男人", "老伯伯", "老年"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("老伯伯"),
            keywords: &["男人", "老伯伯", "老年"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("老爷爷"),
            keywords: &["老人", "老头", "老爷爷"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("老爺爺"),
            keywords: &["老爺爺", "老頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("老人"),
            keywords: &["老人", "老公公｜老伯伯"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhehla"),
            keywords: &["ikhehla", "ogugile", "owesilisa"],
        },
    ],
};
#[doc = "👴🏻"]
pub const OLD_MAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👴🏻",
    codepoint: "1F474 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old man: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👴🏼"]
pub const OLD_MAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👴🏼",
    codepoint: "1F474 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old man: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👴🏽"]
pub const OLD_MAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👴🏽",
    codepoint: "1F474 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old man: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👴🏾"]
pub const OLD_MAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👴🏾",
    codepoint: "1F474 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old man: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👴🏿"]
pub const OLD_MAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👴🏿",
    codepoint: "1F474 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old man: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👵"]
pub const OLD_WOMAN: crate::Emoji = crate::Emoji {
    glyph: "👵",
    codepoint: "1F475",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "old woman",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ou vrou"),
            keywords: &["ou vrou", "oud", "volwassene", "vrou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አሮጊት ሴት"),
            keywords: &["ሴት", "ሽማግሌ", "አሮጊት ሴት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سيدة عجوز"),
            keywords: &["أشخاص", "سيدة", "عجوز"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বয\u{9bc}ষষ\u{9cd}ঠ মহিল\u{9be}"),
            keywords: &[
                "বয\u{9bc}ষষ\u{9cd}ঠ মহিল\u{9be}",
                "বয\u{9bc}স\u{9cd}ক",
                "মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaşlı qadın"),
            keywords: &["qadın", "yaşlı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("бабуля"),
            keywords: &["бабуля", "жанчына", "старая"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("старица"),
            keywords: &["възрастна", "жена", "стара", "старица"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9c3}দ\u{9cd}ধ মহিল\u{9be}"),
            keywords: &[
                "বয\u{9bc}স\u{9cd}ক ন\u{9be}রী",
                "ব\u{9c3}দ\u{9cd}ধ মহিল\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("maouez kozh"),
            keywords: &["kozh", "maouez"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("starica"),
            keywords: &["odrasla osoba", "starica", "žena"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dona gran"),
            keywords: &["anciana", "dona", "gran"],
        },
        #[cfg(feature = "ccp")]
        crate::Annotation {
            lang: "ccp",
            tts: Some("𑄝\u{1112a}𑄢\u{1112e} 𑄟\u{11128}𑄣𑄬"),
            keywords: &["𑄝\u{1112a}𑄢\u{1112e} 𑄟\u{11128}𑄣𑄬"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎬᏴᎵᎨ"),
            keywords: &["ᎠᎨᏯ", "ᎠᎬᏴᎵ", "ᎠᎬᏴᎵᎨ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stará žena"),
            keywords: &["paní", "seniorka", "stará", "starý", "stařena", "žena"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hen fenyw"),
            keywords: &["benywaidd", "hen", "hen fenyw", "menyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("gammel kvinde"),
            keywords: &["gammel kvinde", "kvinde", "menneske"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ältere Frau"),
            keywords: &["Frau", "Gesicht", "Seniorin", "ältere Frau"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ηλικιωμένη"),
            keywords: &["γυναίκα", "ενήλικας", "ηλικιωμένη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("old woman"),
            keywords: &["adult", "old", "woman"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("anciana"),
            keywords: &["anciana", "mayor", "mujer"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mujer mayor"),
            keywords: &["cara", "mayor", "mujer", "señora", "vieja"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["adulta", "anciana", "mujer", "mujer mayor"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("eakas naine"),
            keywords: &["eakas naine", "naine", "vana"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("amona"),
            keywords: &["agure", "amona", "emakume", "emakumezko", "zahar"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پیرزن"),
            keywords: &["زن", "پیر", "پیرزن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vanha nainen"),
            keywords: &["nainen", "vanha"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("matandang babae"),
            keywords: &["babae", "matanda", "matandang babae"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("gomul kona"),
            keywords: &["eldri", "gomul", "kona", "konufólk", "kvinna"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("femme âgée"),
            keywords: &["femme", "âgée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["adulte", "femme", "âgée"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("seanbhean"),
            keywords: &["bean", "sean", "seanbhean"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cailleach"),
            keywords: &["boireannach", "cailleach", "sean", "tè"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("vella"),
            keywords: &["anciá", "muller", "vella"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વ\u{ac3}દ\u{acd}ધ સ\u{acd}ત\u{acd}રી"),
            keywords: &[
                "પ\u{ac1}ખ\u{acd}ત",
                "વ\u{ac3}દ\u{acd}ધ",
                "સ\u{acd}ત\u{acd}રી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dattijuwa"),
            keywords: &["dattijuwa", "mace", "tsoho"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אישה זקנה"),
            keywords: &["אישה", "בת", "גברת", "זקנה", "מבוגרת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ब\u{942}ढ\u{93c}ी महिला"),
            keywords: &[
                "ब\u{941}ज\u{941}र\u{94d}ग",
                "ब\u{942}ढ\u{93c}ी महिला",
                "महिला",
                "लोग",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("starica"),
            keywords: &["starica", "starost"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("idős nő"),
            keywords: &["idős nő", "öreg néni"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("տարեց կին"),
            keywords: &["ծեր", "կին", "տարեց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("wanita tua"),
            keywords: &["nenek", "perempuan", "tua", "wanita"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("okenye nwaanyị"),
            keywords: &["nwanyị", "okenye", "okenye nwaanyị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eldri kona"),
            keywords: &["eldri kona", "fólk", "gömul", "kona"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("donna anziana"),
            keywords: &["anziana", "donna", "nonna", "persone"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("おばあさん"),
            keywords: &["おばあさん", "お年寄り", "女性", "老人", "顔", "高齢者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("wong wadon tuwa"),
            keywords: &["tuwa", "wong diwasa", "wong wadon", "wong wadon tuwa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოხუცი ქალი"),
            keywords: &["მოხუცი", "ქალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қарт әйел"),
            keywords: &["кәрі", "қарт әйел", "әйел"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("gammel kvinde"),
            keywords: &["gammel kvinde", "kvinde", "menneske"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17d2}រ\u{17d2}ត\u{17b8}ច\u{17c6}ណាស\u{17cb}"),
            keywords: &[
                "ចាស\u{17cb}",
                "មន\u{17bb}ស\u{17d2}សចាស\u{17cb}",
                "ស\u{17d2}ត\u{17d2}រ\u{17b8}",
                "ស\u{17d2}រ\u{17d2}ត\u{17b8}ច\u{17c6}ណាស\u{17cb}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವಯಸ\u{ccd}ಸಾದ ಮಹ\u{cbf}ಳ\u{cc6}"),
            keywords: &["ವಯಸ\u{ccd}ಸಾದ ಮಹ\u{cbf}ಳ\u{cc6}", "ವಯಸ\u{ccd}ಸಾದವರು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("할머니"),
            keywords: &["노인", "성인", "여성", "여자", "할머니"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: None,
            keywords: &["जाण\u{94d}टी", "प\u{94d}रौढ", "बायल"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кемпир"),
            keywords: &["кары", "кемпир"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("al Fra"),
            keywords: &["Fra", "al"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແມ\u{ec8}ຍ\u{eb4}ງເຖ\u{ebb}\u{ec9}າ"),
            keywords: &[
                "ຄ\u{ebb}ນ",
                "ຍ\u{eb4}ງເຖ\u{ebb}\u{ec9}າ",
                "ຜ\u{eb9}\u{ec9}ເຖ\u{ebb}\u{ec9}າ",
                "ແມ\u{ec8}ຍ\u{eb4}ງເຖ\u{ebb}\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sena moteris"),
            keywords: &["moteris", "sena"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("veca sieviete"),
            keywords: &["seja", "sieviete", "veca sieviete", "vecmamma", "vecs"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kuia"),
            keywords: &["kaumātua", "kuia", "wahine"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("старица"),
            keywords: &["жена", "женско", "стара", "старица"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d43}ദ\u{d4d}ധ"),
            keywords: &[
                "മ\u{d41}തിർന\u{d4d}നയ\u{d3e}ൾ",
                "വ\u{d3e}ർദ\u{d4d}ധക\u{d4d}യം",
                "വ\u{d43}ദ\u{d4d}ധ",
                "സ\u{d4d}ത\u{d4d}രീ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ахимаг насны эмэгтэй хүн"),
            keywords: &[
                "ахимаг",
                "ахимаг насны эмэгтэй хүн",
                "нас",
                "хүн",
                "эмэгтай",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("व\u{943}द\u{94d}ध महिला"),
            keywords: &["महिला", "व\u{943}द\u{94d}ध"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("wanita tua"),
            keywords: &["tua", "wanita"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("mara xiħa"),
            keywords: &["mara", "xiħa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သက\u{103a}ကြ\u{102e}း အမျ\u{102d}\u{102f}းသမ\u{102e}း"),
            keywords: &[
                "သက\u{103a}ကြ\u{102e}း",
                "အမျ\u{102d}\u{102f}းသမ\u{102e}း",
                "အရ\u{103d}ယ\u{103a}ရောက\u{103a}သ\u{1030}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("eldre kvinne"),
            keywords: &["eldre", "kvinne", "menneske"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ब\u{942}ढी आइमाई"),
            keywords: &["ब\u{942}ढी", "ब\u{942}ढी आइमाई", "महिला"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oude vrouw"),
            keywords: &["oud", "oude vrouw", "ouder", "vrouw"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("eldre kvinne"),
            keywords: &["eldre", "kvinne", "menneske"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ବ\u{b43}ଦ\u{b4d}ଧ ମହ\u{b3f}ଳ\u{b3e}"),
            keywords: &["ବ\u{b43}ଦ\u{b4d}ଧ", "ବୟସ\u{b4d}କ", "ମହ\u{b3f}ଳ\u{b3e}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਜ\u{a3c}\u{a41}ਰਗ ਔਰਤ"),
            keywords: &[
                "ਜ\u{a3c}ਨਾਨੀ",
                "ਬਜ\u{a3c}\u{a41}ਰਗ",
                "ਬਜ\u{a3c}\u{a41}ਰਗ ਔਰਤ",
                "ਲ\u{a4b}ਕ",
                "ਵ\u{a71}ਡੀ",
                "ਵ\u{a71}ਡੀ ਉਮਰ ਦੀ ਜ\u{a3c}ਨਾਨੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("بڈھی زنانی"),
            keywords: &["بڈھی زنانی", "زنانی", "پرانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Óld Wúman"),
            keywords: &["Machọ\u{301} Pẹ\u{301}sin", "Old", "Wúman", "Óld Wúman"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("starsza kobieta"),
            keywords: &["kobieta", "starsza kobieta", "staruszka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زړه ښځه"),
            keywords: &["بالغ", "زوړ", "زړه ښځه", "ښځه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("idosa"),
            keywords: &["adulta", "idosa", "mulher"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["idosa", "mulher de idade avançada", "mulher idosa", "velha"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hatun mama"),
            keywords: &["hatun", "hatun mama", "puriq runa", "warmi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("bătrână"),
            keywords: &["adultă", "bătrână", "femeie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-562"),
            keywords: &["E10-562"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пожилая женщина"),
            keywords: &["женщина", "пожилая", "старая", "старуха", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umukecuru"),
            keywords: &["umukecuru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پوڙهي عورت"),
            keywords: &["پوڙهي عورت", "پوڙهي، عورت"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වයසක ක\u{dcf}න\u{dca}ත\u{dcf}ව"),
            keywords: &[
                "ක\u{dcf}න\u{dca}ත\u{dcf}වක\u{dca}",
                "වයසක",
                "වයසක ක\u{dcf}න\u{dca}ත\u{dcf}ව",
                "වැඩ\u{dd2}හ\u{dd2}ට\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("staršia žena"),
            keywords: &["stará", "staršia žena", "žena"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("starka"),
            keywords: &["starka", "staro", "ženska"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("naag weyn"),
            keywords: &["da’ weyn", "naag", "naag weyn", "qof weyn"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grua e moshuar"),
            keywords: &["e moshuar", "e vjetër", "grua", "grua e moshuar"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("старица"),
            keywords: &["жена", "одрасла особа", "стaрицa", "старица"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["старица"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("starica"),
            keywords: &["odrasla osoba", "starica", "žena"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["starica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("gammal kvinna"),
            keywords: &["gammal", "kvinna", "vuxen", "äldre kvinna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("bibi"),
            keywords: &["bibi", "mwanamke", "mzee"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வயத\u{bbe}ன பெண\u{bcd}"),
            keywords: &[
                "ப\u{bbe}ட\u{bcd}டி",
                "பெரியவர\u{bcd}",
                "மக\u{bcd}கள\u{bcd}",
                "வயத\u{bbe}ன பெண\u{bcd}",
                "வயத\u{bbe}னவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముసల\u{c3e}వ\u{c3f}డ"),
            keywords: &[
                "బ\u{c3e}మ\u{c4d}మ",
                "ముసల\u{c3e}వ\u{c3f}డ",
                "ముసల\u{c3f} స\u{c4d}త\u{c4d}ర\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("зани пир"),
            keywords: &["зан", "зани пир", "пир"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หญ\u{e34}งแก\u{e48}"),
            keywords: &["คนแก\u{e48}", "หญ\u{e34}ง", "หญ\u{e34}งแก\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("garry aýal"),
            keywords: &["aýal", "garry", "uly ýaşly"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("finemotuʻa"),
            keywords: &["finemotuʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaşlı kadın"),
            keywords: &["kadın", "kişiler", "yaşlı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("موماي"),
            keywords: &["ئايال", "قېرى", "موماي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("літня жінка"),
            keywords: &["доросла", "жінка", "літня жінка", "стара"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بوڑھی عورت"),
            keywords: &["انسان", "بوڑھی", "عورت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kampir"),
            keywords: &["ayol", "kampir", "katta yoshli", "qariya"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cụ bà"),
            keywords: &["cụ bà", "già", "người lớn", "phụ nữ"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("màgget gu jigéen"),
            keywords: &["jigéen", "màgget", "màgget gu jigéen"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ibhinqa elidala"),
            keywords: &["ibhinqa", "ibhinqa elidala", "ndala"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Agbalagba Obinrin"),
            keywords: &["Agbalagba Obinrin", "agbalagba", "obinrin"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("老婆婆"),
            keywords: &["女人", "老婆婆", "老年"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("老婆婆"),
            keywords: &["女人", "老婆婆", "老年"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("老奶奶"),
            keywords: &["老人", "老太", "老奶奶"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("老奶奶"),
            keywords: &["老太", "老太太", "老奶奶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("老婦"),
            keywords: &["老太太", "老婆婆", "老婦"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ugogo"),
            keywords: &["ogugile", "owesimame", "ugogo"],
        },
    ],
};
#[doc = "👵🏻"]
pub const OLD_WOMAN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👵🏻",
    codepoint: "1F475 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old woman: light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👵🏼"]
pub const OLD_WOMAN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👵🏼",
    codepoint: "1F475 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old woman: medium-light skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👵🏽"]
pub const OLD_WOMAN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👵🏽",
    codepoint: "1F475 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old woman: medium skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👵🏾"]
pub const OLD_WOMAN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👵🏾",
    codepoint: "1F475 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old woman: medium-dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👵🏿"]
pub const OLD_WOMAN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👵🏿",
    codepoint: "1F475 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "old woman: dark skin tone",
    group: "People & Body",
    subgroup: "person",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
