#[doc = "👏"]
pub const CLAPPING_HANDS: crate::Emoji = crate::Emoji {
    glyph: "👏",
    codepoint: "1F44F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "clapping hands",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handeklap"),
            keywords: &["hand", "handeklap", "klap", "liggaam"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አጨብጫቢ እጆች"),
            keywords: &["ማጨብጨብ", "አካል", "አጨብጫቢ እጆች", "እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يدان تصفقان"),
            keywords: &["أيادي", "تصفيق", "علامة", "يدان تصفقان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত ত\u{9be}লি"),
            keywords: &["ত\u{9be}লি", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl çalan əllər"),
            keywords: &["orqan", "əl", "əl çalan əllər", "əl çalmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пляскае ў ладкі"),
            keywords: &[
                "авацыі",
                "апладысменты",
                "пляскае ў ладкі",
                "плясканне",
                "рука",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пляскащи ръце"),
            keywords: &["Пляскащи ръце", "пляскане", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ত জোড\u{9bc} করে ত\u{9be}লি ব\u{9be}জ\u{9be}নো"),
            keywords: &[
                "শরীর",
                "হ\u{9be}ত",
                "হ\u{9be}ত জোড\u{9bc} করে ত\u{9be}লি ব\u{9be}জ\u{9be}নো",
                "হ\u{9be}তত\u{9be}লি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("aplaudiranje"),
            keywords: &["aplaudiranje", "aplauz", "dlanovi", "ruke"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mans que aplaudeixen"),
            keywords: &["aplaudiment", "aplaudint", "mans", "mans que aplaudeixen"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏓᏏᏛᏂᎲᎢ"),
            keywords: &["ᏓᏍᏛ", "ᏓᏏᏛᏂᎲᎢ", "ᏛᏂᎭ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("tleskající ruce"),
            keywords: &["ruka", "tleskající ruce", "tleskat", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwylo yn curo"),
            keywords: &["corff", "curo", "dwylo yn curo", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("klappende hænder"),
            keywords: &[
                "applaus",
                "bifald",
                "klappende hænder",
                "klapper",
                "klapsalve",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("klatschende Hände"),
            keywords: &[
                "Beifall",
                "Hände",
                "Klatschen",
                "applaudieren",
                "klatschende Hände",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παλαμάκια"),
            keywords: &["παλαμάκια", "σώμα", "χέρι", "χειροκροτώ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("clapping hands"),
            keywords: &["clap", "clapping hands", "hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("manos aplaudiendo"),
            keywords: &["aplaudir", "manos", "manos aplaudiendo", "palmas", "señal"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("manos aplaudiendo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("plaksutavad käed"),
            keywords: &["aplaus", "keha", "käsi", "plaksutamine", "plaksutavad käed"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("txaloka ari diren eskuak"),
            keywords: &["esku", "gorputz", "txalo", "txaloka ari diren eskuak"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست زدن"),
            keywords: &["بدن", "دست", "دست زدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käsien taputus"),
            keywords: &["käsi", "käsien taputus", "taputtaa", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pumapalakpak"),
            keywords: &["gesture", "kamay", "palakpak", "pumapalakpak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("klappandi hendur"),
            keywords: &["hendur", "hond", "klapp", "klappandi hendur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("applaudissements"),
            keywords: &["applaudissements", "bravo", "mains"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["applaudissements", "bravo", "main"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bualadh bos"),
            keywords: &["bualadh bos", "lámha"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("bualadh bhasan"),
            keywords: &["bas", "bois", "bualadh", "bualadh bhasan", "làmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mans aplaudindo"),
            keywords: &["aplaudir", "aplauso", "mans", "mans aplaudindo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("તાળી પાડતા\u{a82} હાથ"),
            keywords: &["ચિહ\u{acd}ન", "તાળી", "તાળી પાડતા\u{a82} હાથ", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hannuwa mai tafawa"),
            keywords: &["hannu", "hannuwa mai tafawa", "tafa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מחיאות כפיים"),
            keywords: &["הדרן", "ידיים", "כל הכבוד", "מחיאות כפיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाथ की ताली का चिह\u{94d}न"),
            keywords: &[
                "चिह\u{94d}न",
                "ताली",
                "हाथ",
                "हाथ की ताली",
                "हाथ की ताली का चिह\u{94d}न",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruke koje plješću"),
            keywords: &["pljeskanje", "ruka", "ruke koje plješću", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tapsoló kéz"),
            keywords: &["kéz", "taps", "tapsoló kéz", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ծափահարող ձեռքեր"),
            keywords: &["ծափահարել", "ծափահարող ձեռքեր", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tepuk tangan"),
            keywords: &["badan", "tangan", "tepuk", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-akụ aka"),
            keywords: &["aka", "kụọ", "na-akụ aka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lófaklapp"),
            keywords: &["hendur", "hendur klappa", "klapp", "lófaklapp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mani che applaudono"),
            keywords: &["applaudire", "applauso", "mani", "mani che applaudono"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("拍手"),
            keywords: &["パチパチ", "手", "拍手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan keplok-keplok"),
            keywords: &["keplok", "tangan", "tangan keplok-keplok"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელები, რომლებიც ტაშს უკრავს"),
            keywords: &[
                "სხეული",
                "ტანი",
                "ტაში",
                "ხელები, რომლებიც ტაშს უკრავს",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("шапалақтау"),
            keywords: &["дене", "шапалақ", "шапалақтау", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hænder klapper"),
            keywords: &["håndtegn", "hænder klapper", "klapper"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ទះដៃ"),
            keywords: &["ទះដៃ", "ល\u{17d2}អណាស\u{17cb}", "ស\u{17d2}វាគមន\u{17cd}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಪ\u{ccd}ಪಾಳ\u{cc6}ಯ ಕೈಗಳು"),
            keywords: &[
                "ಕೈ ತಟ\u{ccd}ಟುವ",
                "ಚಪ\u{ccd}ಪಾಳ\u{cc6} ತಟ\u{ccd}ಟುವ",
                "ಚಪ\u{ccd}ಪಾಳ\u{cc6}ಯ ಕೈಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손뼉"),
            keywords: &["박수", "박수 치기", "손뼉", "손뼉 치기"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ताळयो मारपी हात"),
            keywords: &["ताळयो मारपी हात", "ताळी मारप", "ताळी मारपी हात", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол чабуу"),
            keywords: &["дене", "кол чабуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("klappend Hänn"),
            keywords: &["Hand", "klappen", "klappend Hänn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{ebb}ບມ\u{eb7}"),
            keywords: &["ຕ\u{ebb}ບມ\u{eb7}", "ມ\u{eb7}", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plojančios rankos"),
            keywords: &["plojančios rankos", "ploti", "rankos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("aplausi"),
            keywords: &["aplaudēt", "aplausi", "roka", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa pakipaki"),
            keywords: &["pakipaki", "ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("аплауз"),
            keywords: &["аплауз", "рака", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൈയ\u{d4d}യടി"),
            keywords: &[
                "കൈ",
                "കൈകൊട\u{d4d}ട\u{d41}ക",
                "കൈകൊട\u{d4d}ടൽ ചിഹ\u{d4d}നം",
                "കൈയ\u{d4d}യടി",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алга таших"),
            keywords: &["алга", "гар", "таших", "хуруу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("टाळ\u{94d}या वाजविण\u{947}"),
            keywords: &["टाळ\u{94d}या", "टाळ\u{94d}या वाजविण\u{947}", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("bertepuk tangan"),
            keywords: &["badan", "bertepuk tangan", "tangan", "tepuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("idejn iċapċpu"),
            keywords: &["id", "idejn iċapċpu", "ċapċap"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ခ\u{102f}ပ\u{103a}တ\u{102e}းနေသည\u{1037}\u{103a} လက\u{103a}များ"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ခ\u{102f}ပ\u{103a}",
                "လက\u{103a}ခ\u{102f}ပ\u{103a}တ\u{102e}း",
                "လက\u{103a}ခ\u{102f}ပ\u{103a}တ\u{102e}းနေသည\u{1037}\u{103a} လက\u{103a}များ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("klappende hender"),
            keywords: &["hender", "hånd", "klappende hender", "klapping"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ताली बजाइरह\u{947}का हातहर\u{942}"),
            keywords: &["ताली", "ताली बजाइरह\u{947}का हातहर\u{942}", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("klappende handen"),
            keywords: &["hand", "klappen", "klappende handen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("klappande hender"),
            keywords: &["hand", "hender", "klappande hender", "klapping"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ତ\u{b3e}ଳ\u{b3f} ମ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ତ\u{b3e}ଳ\u{b3f} ମ\u{b3e}ର\u{b3f}ବ\u{b3e}",
                "ତ\u{b3e}ଳ\u{b3f} ମ\u{b3e}ର\u{b41}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤਾੜੀ ਮਾਰਦ\u{a47} ਹ\u{a71}ਥਾ\u{a02} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਤਾੜੀ",
                "ਤਾੜੀ ਮਾਰਦ\u{a47} ਹ\u{a71}ਥਾ\u{a02} ਦਾ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تالیاں وجاندا ہتھ"),
            keywords: &["تالیاں وجاندا ہتھ", "تاڑی", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand-dẹm Wé De Klap"),
            keywords: &["Hand", "Hand-dẹm Wé De Klap", "Klap"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("klaskanie"),
            keywords: &["brawa", "klaskanie", "klaskać", "oklaski"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاسونه پړکول"),
            keywords: &["لاس", "لاسونه پړکول", "پړکول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mãos aplaudindo"),
            keywords: &["aplauso", "mãos", "mãos aplaudindo", "sinal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mãos a bater palmas"),
            keywords: &["bater palmas", "corpo", "mão", "mãos a bater palmas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("jayllisqa makikuna"),
            keywords: &["jayllisqa makikuna", "jaylliy", "maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mâini care aplaudă"),
            keywords: &["aplauze", "mâini", "mâini care aplaudă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-524"),
            keywords: &["E10-524"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("аплодисменты"),
            keywords: &[
                "аплодисменты",
                "движение",
                "жест",
                "овация",
                "рука",
                "хлопать",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibiganza bikoma amashyi"),
            keywords: &["gukoma amashyi", "ibiganza bikoma amashyi", "ikiganza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تاڙيون وڄائيندڙ هٿ"),
            keywords: &["تاڙي", "تاڙيون وڄائيندڙ هٿ", "هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dca}ප\u{dd4}ඩ\u{dd2} ගැස\u{dd3}ම"),
            keywords: &["අත", "අත\u{dca}ප\u{dd4}ඩ\u{dd2} ගැස\u{dd3}ම", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("tlieskajúce ruky"),
            keywords: &["potlesk", "ruka", "tlieskajúce ruky", "tlieskať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("ploskajoči dlani"),
            keywords: &["dlan", "ploskajoči dlani", "ploskati", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sacabinta gacmaha"),
            keywords: &["gacan", "sacab", "sacabinta gacmaha"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("duar që duartrokasin"),
            keywords: &["dorë", "duar që duartrokasin", "duartrokas", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("руке које тапшу"),
            keywords: &["рукa", "руке које тапшу", "тапшање", "тело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["руке које тапшу"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ruke koje tapšu"),
            keywords: &["ruka", "ruke koje tapšu", "tapšanje", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ruke koje tapšu"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("klappande händer"),
            keywords: &["klappa", "klappa händer", "klappande händer"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mikono inayopiga makofi"),
            keywords: &["mikono inayopiga makofi", "mkono", "mwili", "piga makofi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைதட\u{bcd}டல\u{bcd}"),
            keywords: &[
                "கை தட\u{bcd}டுதல\u{bcd}",
                "கைகள\u{bcd}",
                "கைதட\u{bcd}டல\u{bcd}",
                "சின\u{bcd}னம\u{bcd}",
                "தட\u{bcd}டுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చప\u{c4d}పట\u{c4d}లు క\u{c4a}ట\u{c4d}టడం"),
            keywords: &["క\u{c4a}ట\u{c4d}టడం", "చప\u{c4d}పట\u{c4d}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастҳои қарсакзананда"),
            keywords: &["даст", "дастҳои қарсакзананда", "қарсак задан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตบม\u{e37}อ"),
            keywords: &["ตบม\u{e37}อ", "ม\u{e37}อ", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çapak çalýan eller"),
            keywords: &["el", "çapak çalýan eller", "çarpmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima pasipasi"),
            keywords: &["nima pasipasi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("el çırpma"),
            keywords: &["el çırpma", "eller", "işaret", "çırpma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("چاۋاك"),
            keywords: &["قول", "چاۋاك"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("руки, що аплодують"),
            keywords: &["плескати", "рука", "руки, що аплодують", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("تالیاں بجاتے ہاتھ"),
            keywords: &["تالی", "تالیاں بجاتے ہاتھ", "جسم", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chapak"),
            keywords: &["chapak", "qo‘l", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vỗ tay"),
            keywords: &["hai bàn tay đang vỗ", "tay", "vỗ tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo yuy tàccu"),
            keywords: &["loxo", "loxo yuy tàccu", "tàccu"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izandla eziqhwabayo"),
            keywords: &["isandla", "izandla eziqhwabayo", "qhwaba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("N Patẹwọ"),
            keywords: &["N Patẹwọ", "pàtẹ\u{301}wọ\u{301}", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("拍手"),
            keywords: &["手", "拍手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("拍手"),
            keywords: &["手", "拍手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鼓掌"),
            keywords: &["拍手", "鼓掌"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鼓掌"),
            keywords: &["拍手", "鼓掌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("拍手"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukushaya izandla"),
            keywords: &["izindla", "ukushaya izandla", "umzimba"],
        },
    ],
};
#[doc = "👏🏻"]
pub const CLAPPING_HANDS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👏🏻",
    codepoint: "1F44F 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "clapping hands: light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👏🏼"]
pub const CLAPPING_HANDS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👏🏼",
    codepoint: "1F44F 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "clapping hands: medium-light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👏🏽"]
pub const CLAPPING_HANDS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👏🏽",
    codepoint: "1F44F 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "clapping hands: medium skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👏🏾"]
pub const CLAPPING_HANDS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👏🏾",
    codepoint: "1F44F 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "clapping hands: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👏🏿"]
pub const CLAPPING_HANDS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👏🏿",
    codepoint: "1F44F 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "clapping hands: dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙌"]
pub const RAISING_HANDS: crate::Emoji = crate::Emoji {
    glyph: "🙌",
    codepoint: "1F64C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "raising hands",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("persoon met hande in die lug"),
            keywords: &[
                "gebaar",
                "hand",
                "hande in die lug",
                "hoera",
                "liggaam",
                "omhoog",
                "persoon met hande in die lug",
                "viering",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እጆቹን በቃ ብሎ ያነሳ ሰው"),
            keywords: &["እጅ", "እጆቹን በቃ ብሎ ያነሳ ሰው", "ከፍ ያደረገ", "ክብረ በዓል", "የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تشجيع"),
            keywords: &["احتفال", "اليدان", "تشجيع", "رفع اليدين احتفالا\u{64b}"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত উঠোৱ\u{9be}"),
            keywords: &[
                "উত\u{9cd}থিত",
                "উদয\u{9be}পন",
                "ভঙ\u{9cd}গিম\u{9be}",
                "হ\u{9be}ত",
                "হ\u{9be}ত উঠোৱ\u{9be}",
                "হ\u{9c1}ৰে",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əllərini qaldıran adam"),
            keywords: &[
                "bayram",
                "jest",
                "orqan",
                "qaldırılmış",
                "ura",
                "əl",
                "əllərini qaldıran adam",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("чалавек паднімае рукі"),
            keywords: &["жэст", "рукі", "свята", "ура", "чалавек паднімае рукі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Човек с вдигнати ръце"),
            keywords: &[
                "Човек с вдигнати ръце",
                "вдигнат",
                "жест",
                "празнуване",
                "ура",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9cd}যক\u{9cd}তি হ\u{9be}ত ত\u{9c1}লে আছে"),
            keywords: &[
                "অঙ\u{9cd}গভঙ\u{9cd}গি",
                "আনন\u{9cd}দ ধ\u{9cd}বনি কর\u{9be}",
                "উত\u{9cd}থিত",
                "উদয\u{9be}পন কর\u{9be}",
                "ব\u{9cd}যক\u{9cd}তি হ\u{9be}ত ত\u{9c1}লে আছে",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruke podignute u zrak"),
            keywords: &[
                "dlanovi",
                "gestikulacija",
                "radovanje",
                "ruke",
                "ruke podignute u zrak",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mans enlaire"),
            keywords: &["celebració", "hurra", "mans aixecades", "mans enlaire"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎪᏰᎾ ᏗᏌᎵᏛᏅᎢ"),
            keywords: &[
                "ᎠᎵᎮᎵᏍᏗ",
                "ᎣᏍᏓ ᎿᏛᎦ",
                "ᎤᎵᏌᎳᏓ",
                "ᎤᏬᏱ",
                "ᏓᏐᏰᏍᎬ",
                "ᏗᎪᏰᎾ ᏗᏌᎵᏛᏅᎢ",
                "ᏚᎵᏌᎳᏛᎢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvednuté ruce"),
            keywords: &[
                "gesto",
                "hurá",
                "oslava",
                "ruka",
                "tělo",
                "zdvižená",
                "zvednutá",
                "zvednuté ruce",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("person yn codi dwylo"),
            keywords: &["corff", "dathliad", "llaw", "person yn codi dwylo", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løftede hænder"),
            keywords: &[
                "begge hænder oppe",
                "hurra",
                "hænderne over hovedet",
                "juhu",
                "løftede hænder",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zwei erhobene Handflächen"),
            keywords: &["feiern", "zwei erhobene Handflächen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χέρια ψηλά"),
            keywords: &[
                "γιορτή",
                "ζήτω",
                "κίνηση",
                "σηκωμένο",
                "σώμα",
                "χέρι",
                "χέρια ψηλά",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("raising hands"),
            keywords: &[
                "celebration",
                "gesture",
                "hand",
                "hooray",
                "raised",
                "raising hands",
            ],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &[
                "celebration",
                "gesture",
                "hand",
                "hooray",
                "raised",
                "raising hands",
                "woo hoo",
                "yay",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("manos levantadas celebrando"),
            keywords: &[
                "celebración",
                "gesto",
                "hurra",
                "mano",
                "manos levantadas celebrando",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("chocar las manos"),
            keywords: &[
                "celebrar",
                "chocar",
                "chocar las manos",
                "cinco",
                "festejo",
                "manos",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("manos levantadas celebrando"),
            keywords: &[
                "chocar",
                "cinco",
                "festejo",
                "manos",
                "manos levantadas celebrando",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("manos levantadas celebrando"),
            keywords: &[
                "chocar",
                "cinco",
                "festejo",
                "manos",
                "manos levantadas celebrando",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ülestõstetud käed"),
            keywords: &["hurraa", "käed", "tähistamine", "ülestõstetud käed", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuak altxatzen ari den pertsona"),
            keywords: &[
                "altxatu",
                "esku",
                "eskuak altxatzen ari den pertsona",
                "keinu",
                "ospakizun",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تمجید"),
            keywords: &["بالابرده", "تحسین", "تمجید", "جشن", "دست", "هورا", "ژست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nousevat kädet"),
            keywords: &[
                "ele",
                "hurraa",
                "juhla",
                "käsi",
                "nostettu",
                "nousevat kädet",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakataas na mga kamay"),
            keywords: &["hooray", "kamay", "nagdiriwang", "nakataas na mga kamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("upplyftar hendur"),
            keywords: &["hendur", "hond", "upp", "upplyftar hendur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mains levées"),
            keywords: &["air", "mains", "mains levées"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["air", "célébration", "geste", "hourra", "levées", "mains"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámha ardaithe"),
            keywords: &[
                "ardú lámha",
                "ceiliúradh",
                "hurá",
                "lámha ardaithe",
                "na lámha",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("a’ togail làmhan"),
            keywords: &[
                "a’ togail làmhan",
                "gluasad",
                "hò-rò",
                "làmh",
                "subhachas",
                "tog",
                "togail",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mans levantadas"),
            keywords: &["celebración", "chocar", "mans", "mans levantadas", "xesto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ ઉઠાવતી વ\u{acd}યક\u{acd}તિ"),
            keywords: &[
                "ઉજવણી",
                "ઉજવણીમા\u{a82} બ\u{a82}ન\u{ac7} હાથ ઉઠાવવા",
                "બ\u{a82}ન\u{ac7} હાથ",
                "હાથ ઉઠાવતી વ\u{acd}યક\u{acd}તિ",
                "હ\u{ac1}રર\u{ac7}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗagaggun hannuwa"),
            keywords: &[
                "hannu",
                "karimcin",
                "murna",
                "shagali",
                "ɗagagge",
                "ɗagaggun hannuwa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפות ידיים מורמות"),
            keywords: &["כפות ידיים", "כפות ידיים מורמות", "סימן", "שמחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}श होकर दोनो\u{902} हाथ उठाना"),
            keywords: &[
                "उत\u{94d}सव",
                "ख\u{941}श होकर दोनो\u{902} हाथ उठाना",
                "दोनो\u{902} हाथ",
                "ह\u{941}र\u{94d}र\u{947}",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("podignute ruke"),
            keywords: &[
                "bravo",
                "hura",
                "podignute ruke",
                "podići",
                "ruka",
                "slavlje",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kezét felemelő ember"),
            keywords: &[
                "kezét felemelő ember",
                "kéz",
                "test",
                "vidámság",
                "ünneplés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքերը բարձրացնող անձ"),
            keywords: &[
                "բարձրացված",
                "ժեստ",
                "ձեռք",
                "ձեռքերը բարձրացնող անձ",
                "մարմին",
                "ուռա",
                "տոն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mengangkat tangan"),
            keywords: &[
                "angkat tangan",
                "gerakan",
                "hore",
                "mengangkat tangan",
                "perayaan",
                "tangan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ndị eweliri elu"),
            keywords: &[
                "aka",
                "aka ndị eweliri elu",
                "huree",
                "ogbugbu",
                "welitere",
                "ènwemụaṅụrị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("húrra"),
            keywords: &["báðar hendur", "fagna", "hendur upp í loft", "húrra"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mani alzate"),
            keywords: &["evviva", "mani", "mani alzate", "urrà", "vittoria"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バンザイ"),
            keywords: &["バンザイ", "両手", "手", "手を上げる"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan loro diangkat"),
            keywords: &[
                "diangkat",
                "hore",
                "isarat",
                "pista",
                "tangan",
                "tangan loro diangkat",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელებაწეული პიროვნება"),
            keywords: &[
                "აღნიშვნა",
                "აწეული",
                "ზეიმი",
                "ჟესტი",
                "სხეული",
                "ტანი",
                "ხელებაწეული პიროვნება",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолдарды көтеру"),
            keywords: &[
                "алақай",
                "көтерілген",
                "тойлау",
                "қимыл",
                "қол",
                "қолдарды көтеру",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hurra"),
            keywords: &["begge hænder oppe", "hurra"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លើកបង\u{17d2}ហាញបាតដៃទា\u{17c6}ងព\u{17b8}រ"),
            keywords: &[
                "ដៃ",
                "បាតដៃព\u{17b8}រ",
                "លើកដៃ",
                "លើកបង\u{17d2}ហាញបាតដៃទា\u{17c6}ងព\u{17b8}រ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈಗಳನ\u{ccd}ನು ಎತ\u{ccd}ತುವುದು"),
            keywords: &[
                "ಆಚರಣ\u{cc6}",
                "ಕೈ",
                "ಕೈಗಳನ\u{ccd}ನು ಎತ\u{ccd}ತುತ\u{ccd}ತ\u{cbf}ರುವ ವ\u{ccd}ಯಕ\u{ccd}ತ\u{cbf}",
                "ಕೈಗಳನ\u{ccd}ನು ಎತ\u{ccd}ತುವುದು",
                "ಹುರ\u{ccd}ರೇ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("만세"),
            keywords: &[
                "두 손을 든 사람",
                "만세",
                "만세 하고 있는 사람",
                "제스처",
                "하이파이브",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उखलिल\u{94d}ल\u{947} हात"),
            keywords: &[
                "उखलिल\u{94d}ल\u{947} हात",
                "उखलिल\u{94d}ल\u{947}\u{902}",
                "स\u{941}वाळो",
                "हात",
                "हावभाव",
                "ह\u{941}र\u{94d}र\u{947}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол көтөрүп жаткан адам"),
            keywords: &[
                "ишарат",
                "кол",
                "кол көтөрүп жаткан адам",
                "көтөрүлгөн колдор",
                "майрам",
                "ураа",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Hänn an d’Luucht"),
            keywords: &[
                "Feier",
                "Geste",
                "Hand",
                "Hänn an d’Luucht",
                "an der Luucht",
                "hurra",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຄ\u{ebb}ນຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຄ\u{ebb}ນຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ",
                "ດ\u{eb5}ໃຈ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žmogus, iškėlęs rankas"),
            keywords: &[
                "gestas",
                "iškelta",
                "kūnas",
                "ranka",
                "valio",
                "šventė",
                "žmogus, iškėlęs rankas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("paceltas rokas"),
            keywords: &["paceltas rokas", "pacelts", "rokas", "svinēt", "uzvara"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā ringa tū"),
            keywords: &[
                "ngā ringa tū",
                "ringa",
                "tohu ā-ringa",
                "tū",
                "whakanuinga",
                "āhaha",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("кренати дланки"),
            keywords: &["гест", "кренати дланки", "подигнати", "прослава", "ура"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൈകൾ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി"),
            keywords: &[
                "ആംഗ\u{d4d}യം",
                "ആഘോഷം",
                "കൈ",
                "കൈ ഉയർത\u{d4d}ത\u{d41}ക",
                "കൈകൾ ഉയർത\u{d4d}ത\u{d41}ന\u{d4d}ന വ\u{d4d}യക\u{d4d}തി",
                "ശരീരം",
                "ഹ\u{d41}റേയ\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гараа өргөж байгаа хүн"),
            keywords: &["гар", "гараа өргөж байгаа хүн", "хоёр гар", "хүн", "өргөх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दोन\u{94d}ही हात उ\u{902}चावणारी व\u{94d}यक\u{94d}ती"),
            keywords: &[
                "उचावण\u{947}",
                "उत\u{94d}सव",
                "दोन\u{94d}ही हात उ\u{902}चावणारी व\u{94d}यक\u{94d}ती",
                "दोन\u{94d}ही हात उ\u{902}चावण\u{947}",
                "हात",
                "हातवार\u{947} करण\u{947}",
                "ह\u{941}र\u{94d}र\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("orang mengangkat tangan"),
            keywords: &[
                "angkat",
                "badan",
                "hore",
                "isyarat",
                "orang mengangkat tangan",
                "perayaan",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("idejn mgħollija"),
            keywords: &[
                "bl-idejn",
                "hooray",
                "idejn mgħollija",
                "mgħollija",
                "ċelebrazzjoni",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}မြ\u{103e}ောက\u{103a}ပြနေသ\u{1030}"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ဟန\u{103a}",
                "လက\u{103a}မြ\u{103e}ောက\u{103a}ပြနေသ\u{1030}",
                "လက\u{103a}ဟန\u{103a}",
                "အောင\u{103a}ပ\u{103d}\u{1032}ခ\u{1036}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hevede hender"),
            keywords: &[
                "begge hender",
                "feirer",
                "feiring",
                "hevede hender",
                "hånd",
                "rekker begge armene i været",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हात उठाइरह\u{947}को व\u{94d}यक\u{94d}ति"),
            keywords: &[
                "उठाएको",
                "भाव प\u{94d}रदर\u{94d}शन",
                "शरीर",
                "समारोह",
                "हात",
                "हात उठाइरह\u{947}को व\u{94d}यक\u{94d}ति",
                "ह\u{941}र\u{94d}र\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("juichend omhooggestoken handen"),
            keywords: &[
                "gebaar",
                "hand",
                "hoera",
                "juichend omhooggestoken handen",
                "omhoog",
                "viering",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("heva hender"),
            keywords: &[
                "begge hender",
                "feirar",
                "feiring",
                "hand",
                "hea hender",
                "heva hender",
                "rekkjer begge armane i veret",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଠ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଉଠ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଉଭୟ ହ\u{b3e}ତ",
                "ଖ\u{b41}ସୀ",
                "ଖ\u{b41}ସୀରେ ଉଭୟ ହ\u{b3e}ତ ଉପରକ\u{b41} ଉଠ\u{b3e}ଇବ\u{b3e}",
                "ହ\u{b41}ରେ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a4b}ਵ\u{a47}\u{a02} ਹ\u{a71}ਥ ਖੜ\u{a4d}ਹ\u{a47} ਕਰਨ ਵਾਲਾ ਵਿਅਕਤੀ"),
            keywords: &[
                "ਖ\u{a41}\u{a41}ਸ\u{a3c}ੀ",
                "ਜਸ\u{a3c}ਨ",
                "ਜਸ\u{a3c}ਨ ਵਿ\u{a71}ਚ ਦ\u{a4b}ਵ\u{a47} ਹ\u{a71}ਥ ਉ\u{a71}ਤ\u{a47} ਚ\u{a41}\u{a71}ਕ ਰਿਹ",
                "ਦ\u{a4b}ਵ\u{a47} ਹ\u{a71}ਥ",
                "ਦ\u{a4b}ਵ\u{a47}\u{a02} ਹ\u{a71}ਥ ਖੜ\u{a4d}ਹ\u{a47} ਕਰਨ ਵਾਲਾ ਵਿਅਕਤੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ ا\u{64f}وچا کرنا"),
            keywords: &[
                "اشارہ",
                "ا\u{64f}بھریا ہوئیا",
                "خوشی دی آواز",
                "منانا",
                "ہتھ",
                "ہتھ ا\u{64f}وچا کرنا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand-dẹm Wé Dẹm Réz Ọp"),
            keywords: &[
                "Hand-dẹm Wé Dẹm Réz Ọp",
                "Klózd Hand",
                "Klózd Hand Wé De Fés Rait",
                "Raít Said",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wzniesione ręce"),
            keywords: &["hura!", "super", "wzniesione ręce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاسونه اوچتول"),
            keywords: &[
                "اشاره",
                "اوچت",
                "لاس",
                "لاسونه اوچتول",
                "لاسونه اوچول",
                "لمانځل",
                "هوری",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mãos para cima"),
            keywords: &[
                "ambas as mãos",
                "comemoração",
                "levantando ambas as mãos para comemorar",
                "mãos para cima",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mãos no ar"),
            keywords: &[
                "celebração",
                "corpo",
                "gesto",
                "mão",
                "mãos levantadas",
                "mãos no ar",
                "viva",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("juqharisqa makikuna"),
            keywords: &[
                "achhalay",
                "gesto",
                "juqharisqa",
                "juqharisqa makikuna",
                "maki",
                "raymi",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mâini ridicate"),
            keywords: &["mâini", "mâini ridicate", "ridicat", "sărbătoare", "ura"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-912"),
            keywords: &["E10-912"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ура"),
            keywords: &["вверх", "жест", "класс", "отлично", "победа", "руки", "ура"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibiganza bizamuye"),
            keywords: &[
                "ibiganza bizamuye",
                "ibirori",
                "ikiganza",
                "ikimenyetso",
                "ikizamuye",
                "oye",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي ٿيندڙ هٿ"),
            keywords: &["جشن، اشارو، هٿ، مٿي اٿيل", "مٿي ٿيندڙ هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dca} ඔසවන ප\u{dd4}ද\u{dca}ගලය\u{dcf}"),
            keywords: &[
                "අත",
                "අත\u{dca} ඔසවන ප\u{dd4}ද\u{dca}ගලය\u{dcf}",
                "උත\u{dca}සවය",
                "උස\u{dca}සන ලද",
                "ඔල\u{dca}වරසන\u{dca} ද\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdvihnuté ruky"),
            keywords: &[
                "gesto",
                "hurá",
                "oslava",
                "ruka",
                "zdvihnuté",
                "zdvihnuté ruky",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oseba, ki dvigne roke"),
            keywords: &[
                "dvignjeno",
                "gesta",
                "hura",
                "oseba, ki dvigne roke",
                "roka",
                "slavje",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacmo kor u taagid"),
            keywords: &[
                "baraawo",
                "dabbaaldeg",
                "gacan",
                "gacmo kor u taagid",
                "kor u taagid",
                "meedaar",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("njeri që ngre duart"),
            keywords: &["festim", "gjest", "njeri që ngre duart", "urra"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("подигнуте руке"),
            keywords: &[
                "брaвo",
                "пoдићи",
                "подигнуте руке",
                "покрет",
                "руке",
                "слава",
                "урa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("podignute ruke"),
            keywords: &[
                "bravo",
                "podignute ruke",
                "podići",
                "pokret",
                "ruke",
                "slava",
                "ura",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("båda händerna i luften"),
            keywords: &["båda händerna i luften", "hurra", "räcker upp händerna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mikono iliyoinuliwa"),
            keywords: &[
                "inuliwa",
                "ishara",
                "kusherehekea",
                "mikono iliyoinuliwa",
                "mkono",
                "mwili",
                "shangwe",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "மகிழ\u{bcd}ச\u{bcd}சியில\u{bcd} இரண\u{bcd}டு கைகளை உயர\u{bcd}த\u{bcd}துபவர\u{bcd}",
            ),
            keywords: &[
                "மகிழ\u{bcd}ச\u{bcd}சி சின\u{bcd}னம\u{bcd}",
                "மகிழ\u{bcd}ச\u{bcd}சியில\u{bcd} இரண\u{bcd}டு கைகளை உயர\u{bcd}த\u{bcd}துபவர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ర\u{c46}ండు చ\u{c47}తులు ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ),
            keywords: &[
                "చ\u{c47}తులు",
                "ర\u{c46}ండు చ\u{c47}తులు ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастҳои бардоштаистода"),
            keywords: &[
                "бардошта",
                "даст",
                "дастҳои бардоштаистода",
                "имову ишора",
                "ура",
                "ҷашн",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39} 2 ม\u{e37}อ"),
            keywords: &[
                "ช\u{e39} 2 ม\u{e37}อ",
                "ด\u{e35}ใจ",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("elleri galdyrmak"),
            keywords: &[
                "baýramçylyk",
                "el",
                "elleri galdyrmak",
                "galdyrylan",
                "urra",
                "üm",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo nima hiki ki ʻolunga"),
            keywords: &["ongo nima hiki ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eller havaya"),
            keywords: &[
                "eller havaya",
                "her iki el",
                "kutlama",
                "kutlamak için iki eli birden kaldırma",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قول كۆتۈرۈش"),
            keywords: &["ئىشارە", "ئۇررا", "تەبرىكلەش", "قول", "كۆتۈرۈش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("руки, підняті для святкування"),
            keywords: &[
                "жест",
                "піднята",
                "рука",
                "руки, підняті для святкування",
                "святкування",
                "ура",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ بلند کیے ہوئے شخص"),
            keywords: &["جسم", "جشن", "ہاتھ", "ہاتھ بلند کیے ہوئے شخص"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘llarini ko‘targan odam"),
            keywords: &[
                "imo-ishora",
                "ko‘tarilgan",
                "nishonlash",
                "qo‘l",
                "qo‘llarini ko‘targan odam",
                "tan",
                "urra",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai bàn tay giơ lên"),
            keywords: &[
                "cử chỉ",
                "hai bàn tay giơ lên",
                "hoan hô",
                "lễ kỷ niệm",
                "nâng lên",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yëkkati ay loxo"),
            keywords: &[
                "buñ yëkkati",
                "liyaar",
                "loxo",
                "màggal",
                "wëey",
                "yëkkati ay loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukunyusa izandla"),
            keywords: &[
                "ephakanyisiweyo",
                "isandla",
                "jekula",
                "ukunyusa izandla",
                "umbhiyozo",
                "yeleyele",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ina Awọn Ọwọ"),
            keywords: &[
                "Ina Awọn Ọwọ",
                "ayẹyẹ",
                "fọwọ\u{301}júwè",
                "hooray",
                "nawọ\u{301}",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舉高雙手"),
            keywords: &["慶祝", "手", "手勢", "舉起", "舉高雙手", "萬歲"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("举高双手"),
            keywords: &["万岁", "举起", "举高双手", "庆祝", "手", "手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("举双手"),
            keywords: &["举双手", "击掌", "双手", "庆祝"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("歡呼"),
            keywords: &["歡呼", "舉雙手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("舉雙手歡呼"),
            keywords: &["high five", "舉雙手", "舉雙手歡呼"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umuntu ophakamise izandla"),
            keywords: &[
                "halala",
                "isandla",
                "ukuphakamisa",
                "umbungazo",
                "umuntu ophakamise izandla",
                "umzimba",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙌🏻"]
pub const RAISING_HANDS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙌🏻",
    codepoint: "1F64C 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raising hands: light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙌🏼"]
pub const RAISING_HANDS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙌🏼",
    codepoint: "1F64C 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raising hands: medium-light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙌🏽"]
pub const RAISING_HANDS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙌🏽",
    codepoint: "1F64C 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raising hands: medium skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙌🏾"]
pub const RAISING_HANDS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙌🏾",
    codepoint: "1F64C 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raising hands: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙌🏿"]
pub const RAISING_HANDS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙌🏿",
    codepoint: "1F64C 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raising hands: dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👐"]
pub const OPEN_HANDS: crate::Emoji = crate::Emoji {
    glyph: "👐",
    codepoint: "1F450",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "open hands",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oop hande"),
            keywords: &["hand", "liggaam", "oop", "oop hande"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተከፈቱ ሁለት እጆች"),
            keywords: &["አካል", "እጅ", "ክፍት", "የተከፈቱ ሁለት እጆች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يدان مفتوحتان"),
            keywords: &["علامة", "علامة فتح اليدين", "مفتوحة", "يد", "يدان مفتوحتان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মেল\u{9be} হ\u{9be}ত"),
            keywords: &["খোল\u{9be}", "মেল\u{9be} হ\u{9be}ত", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("açıq əllər"),
            keywords: &["açıq", "açıq əllər", "orqan", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("адкрытыя рукі"),
            keywords: &["адкрытыя", "бяспека", "рукі"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Отворени ръце"),
            keywords: &["Отворени ръце", "отворен", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("খোল\u{9be} হ\u{9be}ত"),
            keywords: &["খোল\u{9be}", "শরীর", "হ\u{9be}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("otvoreni dlanovi"),
            keywords: &["dlanovi", "otvoreni dlanovi", "ruke"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mans obertes"),
            keywords: &["cos", "mans obertes", "mà", "oberta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏚᎢᏓ ᏙᏬᏰᎾ"),
            keywords: &["ᎠᏍᏚᎢᏓ", "ᎤᏬᏱ", "ᏗᏚᎢᏓ ᏙᏬᏰᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("rozevřené dlaně"),
            keywords: &["otevřený", "rozevřené dlaně", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwylo agored"),
            keywords: &["agored", "corff", "dwylo agored", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("åbne hænder"),
            keywords: &["håndtegn", "åbne hænder", "åbne hænder-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("offene Hände"),
            keywords: &["Hände", "offen", "offene Hände"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("ανοικτά χέρια"),
            keywords: &["ανοικτά χέρια", "ανοιχτό", "σώμα", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("open hands"),
            keywords: &["hand", "open", "open hands"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("manos abiertas"),
            keywords: &["abiertas", "manos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["abiertas", "gesto", "manos"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("avatud käed"),
            keywords: &["avatud", "avatud käed", "keha", "käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku irekiak"),
            keywords: &["esku", "esku irekiak", "gorputz", "ireki"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست\u{200c}های باز"),
            keywords: &["باز", "بدن", "دست", "دست\u{200c}های باز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("avoimet kädet"),
            keywords: &["avoimet kädet", "avoin", "käsi", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bukas-palad"),
            keywords: &["bukas-palad", "gesture", "kamay", "palad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("opnar hendur"),
            keywords: &["hendur", "hond", "opin", "opnar hendur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mains ouvertes"),
            keywords: &["main", "mains ouvertes", "ouvert"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["main", "mains ouvertes", "ouvertes"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámha ar oscailt"),
            keywords: &["lámha", "lámha ar oscailt", "lámha oscailte"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmhan fosgailte"),
            keywords: &["fosgailte", "làmh", "làmhan fosgailte"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mans abertas"),
            keywords: &["abertas", "mans"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ખ\u{ac1}લ\u{acd}લા\u{a82} હાથ"),
            keywords: &[
                "ખ\u{ac1}લ\u{acd}લા\u{a82}",
                "ખ\u{ac1}લ\u{acd}લા\u{a82} હાથન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "ચિહ\u{acd}ન",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("buɗaɗɗun hannuwa"),
            keywords: &["a buɗe", "buɗaɗɗun hannuwa", "hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפות ידיים פתוחות"),
            keywords: &["ידיים פתוחות", "כפות ידיים פתוחות", "קבלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ख\u{941}ल\u{947} हाथ"),
            keywords: &[
                "ख\u{941}ला",
                "ख\u{941}ल\u{947} हाथ",
                "ख\u{941}ल\u{947} हाथ का चिह\u{94d}न",
                "चिह\u{94d}न",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("otvorene ruke"),
            keywords: &["otvorene ruke", "otvoreno", "ruka", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("széttárt kéz"),
            keywords: &["kitárva", "kéz", "széttárt kéz", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բաց ձեռքեր"),
            keywords: &["բաց", "բաց ձեռքեր", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan terbuka"),
            keywords: &["badan", "tangan", "terbuka", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka mepere emepe"),
            keywords: &["aka", "aka mepere emepe", "mmepe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("opinn lófi"),
            keywords: &["hendur", "lófar", "opinn lófi", "opnir lófar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mani aperte"),
            keywords: &[
                "aperta",
                "mani aperte",
                "mano",
                "segno",
                "segno delle mani aperte",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("両手のひら"),
            keywords: &["おっはー", "両手のひら", "手", "手のひら"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan loro mlumah"),
            keywords: &["mlumah", "tangan", "tangan loro mlumah"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გაშლილი ხელები"),
            keywords: &["გაშლილი ხელები", "სხეული", "ტანი", "ღია", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("алақанды көрсету"),
            keywords: &["алақанды көрсету", "ашық", "дене", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("åbne hænder"),
            keywords: &["håndtegn", "åbne hænder", "åbne hænder-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លាបង\u{17d2}ហាញបាតដៃទា\u{17c6}ងព\u{17b8}រ"),
            keywords: &["លាដៃ", "លាបង\u{17d2}ហាញបាតដៃទា\u{17c6}ងព\u{17b8}រ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ತ\u{cc6}ರ\u{cc6}ದ\u{cbf}ರುವ ಕೈಗಳು"),
            keywords: &[
                "ತ\u{cc6}ರ\u{cc6}ಗಳ ಕೈಗಳ ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
                "ತ\u{cc6}ರ\u{cc6}ದ ಕೈಗಳು",
                "ತ\u{cc6}ರ\u{cc6}ದ\u{cbf}ರುವ ಕೈಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("양손을 모아서 벌린 모양"),
            keywords: &["두 손 펼치기", "양손을 모아서 벌린 모양", "펼친 두 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उकत\u{947} हात"),
            keywords: &["उकत\u{947} हात", "उकत\u{947}\u{902}", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ачык алакандар"),
            keywords: &["алакан", "ач", "ачык алакандар", "дене"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("oppen Hänn"),
            keywords: &["Hand", "oppen", "oppen Hänn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແບມ\u{eb7}ອອກສອງຂ\u{ec9}າງ"),
            keywords: &["ຮ\u{ec8}າງກາຍ", "ແບມ\u{eb7}", "ແບມ\u{eb7}ອອກສອງຂ\u{ec9}າງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("atviros rankos"),
            keywords: &["atviros", "rankos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("atvērtas rokas"),
            keywords: &["atvērtas rokas", "roka", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa tuwhera"),
            keywords: &["ringa", "tuwhera"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("отворени дланки"),
            keywords: &["дланка", "отворени дланки", "отворено", "рака", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ത\u{d41}റന\u{d4d}ന കൈകൾ"),
            keywords: &[
                "കൈ",
                "ത\u{d41}റക\u{d4d}ക\u{d41}ക",
                "ത\u{d41}റന\u{d4d}ന കൈകൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дэлгэсэн алга"),
            keywords: &["алга", "гар", "дэлгэсэн алга", "дэлгээтэй", "нээлттэй"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ख\u{941}ल\u{947} हात"),
            keywords: &["ख\u{941}ल\u{947}", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tangan terbuka"),
            keywords: &["badan", "tangan", "terbuka"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("idejn miftuħa"),
            keywords: &["id", "idejn miftuħa", "miftuħa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{103d}င\u{1037}\u{103a}ထားသည\u{1037}\u{103a} လက\u{103a}များ"),
            keywords: &[
                "ဖ\u{103d}င\u{1037}\u{103a}ထားသည\u{1037}\u{103a} လက\u{103a}များ",
                "လက\u{103a}",
                "လက\u{103a}န\u{103e}စ\u{103a}ခြောင\u{103a}း ဖြန\u{1037}\u{103a}ထားပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("åpne hender"),
            keywords: &["hender", "hånd", "åpne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ला हातहर\u{942}"),
            keywords: &["ख\u{941}ला", "ख\u{941}ला हातहर\u{942}", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("open handen"),
            keywords: &["hand", "open", "open handen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("opne hender"),
            keywords: &["hand", "hender", "opne"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଖୋଲ\u{b3e} ହ\u{b3e}ତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଖୋଲ\u{b3e} ହ\u{b3e}ତ",
                "ଖୋଲ\u{b3e} ହ\u{b3e}ତ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ଖୋଲ\u{b3e} ହ\u{b3e}ତଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଖୋଲ\u{b3f}ବ\u{b3e}",
                "ଚ\u{b3f}ହ\u{b4d}ନ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਹ\u{a71}ਥ"),
            keywords: &[
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹਾ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਹ\u{a71}ਥ",
                "ਖ\u{a41}\u{a71}ਲ\u{a4d}ਹ\u{a47} ਹ\u{a71}ਥ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھلے ہتھ"),
            keywords: &["ک\u{64f}ھلا", "کھلے ہتھ", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ópún Hand-dẹm"),
            keywords: &["Hand", "Ópun", "Ópún Hand-dẹm"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("otwarte dłonie"),
            keywords: &["otwarte dłonie", "puste ręce", "złapać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خلاص لاسونه"),
            keywords: &["خلاص", "خلاص لاسونه", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mãos abertas"),
            keywords: &[
                "abertas",
                "mão",
                "mãos abertas",
                "sinal",
                "sinal de mãos abertas",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["aberta", "corpo", "mão", "mãos abertas"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kichasqa makikuna"),
            keywords: &["kichasqa makikuna", "kichay", "maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("palme deschise"),
            keywords: &["deschise", "mână", "palme"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-525"),
            keywords: &["E10-525"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ладони в стороны"),
            keywords: &["врозь", "ладони", "ладони в стороны", "открытые", "рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’ibiganza bibumbuye"),
            keywords: &["gufungura", "ikiganza", "ikimenyetso cy’ibiganza bibumbuye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کليل هٿ"),
            keywords: &["هٿ", "کليل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}වෘත අත\u{dca}"),
            keywords: &["අත", "ව\u{dd2}වෘත", "ව\u{dd2}වෘත අත\u{dca}", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("roztvorené dlane"),
            keywords: &["otvorená", "roztvorené dlane", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("odprti dlani"),
            keywords: &["dlan", "odprti dlani", "odprto", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacmo furan"),
            keywords: &["furan", "gacan", "gacmo furan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("duar të hapura"),
            keywords: &["dorë", "duar të hapura", "e hapur", "hap", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("расклопљене шаке"),
            keywords: &["oтвoрeнo", "расклопљене шаке", "рукa", "тело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["расклопљене шаке"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rasklopljene šake"),
            keywords: &["otvoreno", "rasklopljene šake", "ruka", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["rasklopljene šake"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öppna händer"),
            keywords: &["händer", "öppna"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mikono iliyowazi"),
            keywords: &["mikono iliyowazi", "mkono", "mwili", "wazi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைகளை விரித\u{bcd}தல\u{bcd}"),
            keywords: &[
                "கைகளை விரித\u{bcd}தல\u{bcd}",
                "கைகள\u{bcd}",
                "திறந\u{bcd}த கைகள\u{bcd}",
                "விரித\u{bcd}த கைகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఉత\u{c4d}త చ\u{c47}తులు"),
            keywords: &[
                "ఉత\u{c4d}త చ\u{c47}తుల గుర\u{c4d}తు",
                "ఉత\u{c4d}త చ\u{c47}తులు",
                "సంబర\u{c3e}ల\u{c4d}ల\u{c4b} చ\u{c47}తులు ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f} ఆడ\u{c3f}ప\u{c3e}డ\u{c47} గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастҳои кушода"),
            keywords: &["даст", "дастҳои кушода", "кушода"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แบม\u{e37}อ"),
            keywords: &["ม\u{e37}อ", "อว\u{e31}ยวะ", "แบม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("açyk eller"),
            keywords: &["açmak", "açyk eller", "el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima homo"),
            keywords: &["nima homo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("eller açık"),
            keywords: &["açık", "el", "eller açık", "eller açık işareti", "işaret"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوچۇق قول"),
            keywords: &["ئوچۇق", "قول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("відкриті долоні"),
            keywords: &["відкритий", "відкриті долоні", "рука", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھلے ہاتھ"),
            keywords: &["جسم", "کھلے ہاتھ", "کھولے", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ochiq qo‘llar"),
            keywords: &["ochiq", "ochiq qo‘llar", "qo‘l", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai bàn tay đang xòe"),
            keywords: &["hai bàn tay đang xòe", "mở ra", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo yu ubbeeku"),
            keywords: &["loxo", "loxo yu ubbeeku", "ubbeeku"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izandla ezivulekileyo"),
            keywords: &["isandla", "izandla ezivulekileyo", "vulekileyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Ọwọ Ṣiṣi"),
            keywords: &["Awọn Ọwọ Ṣiṣi", "ṣí", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打開手"),
            keywords: &["手", "打開", "打開手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打开手"),
            keywords: &["手", "打开", "打开手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("张开双手"),
            keywords: &["双手", "张开双手", "摊手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("攤開手"),
            keywords: &["手", "攤開手", "雙手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izandla ezivuliwe"),
            keywords: &["isandla", "izandla ezivuliwe", "ukuvula", "umzimba"],
        },
    ],
};
#[doc = "👐🏻"]
pub const OPEN_HANDS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👐🏻",
    codepoint: "1F450 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "open hands: light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👐🏼"]
pub const OPEN_HANDS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👐🏼",
    codepoint: "1F450 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "open hands: medium-light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👐🏽"]
pub const OPEN_HANDS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👐🏽",
    codepoint: "1F450 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "open hands: medium skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👐🏾"]
pub const OPEN_HANDS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👐🏾",
    codepoint: "1F450 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "open hands: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👐🏿"]
pub const OPEN_HANDS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👐🏿",
    codepoint: "1F450 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "open hands: dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤲"]
pub const PALMS_UP_TOGETHER: crate::Emoji = crate::Emoji {
    glyph: "🤲",
    codepoint: "1F932",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "palms up together",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("palms op teen mekaar"),
            keywords: &["bid", "palms op teen mekaar", "palms teenaan langs mekaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("መዳፍ አንድ ላይ ወደላይ"),
            keywords: &["መዳፍ አንድ ላይ ወደላይ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("راحتان مفتوحتان"),
            keywords: &["راحتان مفتوحتان", "صلاة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("একেলগে উঠোৱ\u{9be} হ\u{9be}ত"),
            keywords: &[
                "একেলগে উঠোৱ\u{9be} হ\u{9be}ত",
                "প\u{9cd}ৰ\u{9be}ৰ\u{9cd}থন\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əllər yuxarı"),
            keywords: &["dua", "əllər yuxarı"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("складзеныя разам далоні"),
            keywords: &["моліцца", "складзеныя разам далоні"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Събрани длани, сочещи нагоре"),
            keywords: &["Събрани длани, сочещи нагоре", "молитва"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}তের ত\u{9be}ল\u{9c1} একস\u{9be}থে ওপরের দিকে"),
            keywords: &[
                "প\u{9cd}র\u{9be}র\u{9cd}থন\u{9be}",
                "হ\u{9be}তের ত\u{9be}ল\u{9c1} একস\u{9be}থে ওপরের দিকে",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dlanovi spojeni prema gore"),
            keywords: &["dlanovi spojeni prema gore", "molitva"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mans juntes amb els palmells cap amunt"),
            keywords: &["mans juntes amb els palmells cap amunt", "pregària"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᎾᏙᏯᏂᎠ ᎦᎸᎳᏗ ᎠᏒᏅᏍᏗ"),
            keywords: &["ᎠᏓᏙᎵᏍᏗ", "ᏚᎾᏙᏯᏂᎠ ᎦᎸᎳᏗ ᎠᏒᏅᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zdvižené dlaně vedle sebe"),
            keywords: &["prosba", "zdvižené dlaně vedle sebe"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cledrau dwylo yn yr awyr gyda’u gilydd"),
            keywords: &["cledrau dwylo yn yr awyr gyda’u gilydd", "gweddïo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("håndflader samlet og løftet"),
            keywords: &["bøn", "håndflader samlet og løftet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Handflächen nach oben"),
            keywords: &["Handflächen nach oben", "beten"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("παλάμες μαζί"),
            keywords: &["παλάμες μαζί", "προσευχή"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("palms up together"),
            keywords: &["palms up together", "prayer"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("palmas hacia arriba juntas"),
            keywords: &["oración", "palmas hacia arriba juntas"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("peopesad üleval koos"),
            keywords: &["palve", "peopesad üleval koos"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-azpiak elkartuta"),
            keywords: &["esku-azpiak elkartuta", "otoitza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست دعا"),
            keywords: &["دست دعا", "دعا", "راز و نیاز", "عبادت", "نماز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kämmenet vierekkäin"),
            keywords: &["anelu", "kämmenet vierekkäin"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakataas na magkadikit na palad"),
            keywords: &["dasal", "nakataas na magkadikit na palad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lógvar sum eru saman"),
            keywords: &[
                "bøn",
                "hendur",
                "hond",
                "lógvar",
                "lógvar sum eru saman",
                "lógvi",
                "saman",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("paume contre paume doigts vers le haut"),
            keywords: &["mains", "paume contre paume doigts vers le haut", "prière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "moins jointes",
                "paume contre paume",
                "paume contre paume doigts vers le haut",
                "prière",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bosa le chéile"),
            keywords: &[
                "bos na láimhe ardaithe le chéile",
                "bosa le chéile",
                "paidir",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("an dà bhois suas còmhla"),
            keywords: &["an dà bhois suas còmhla", "ùrnaigh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("palmas xuntas"),
            keywords: &["palmas", "xuntas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હથ\u{ac7}ળીઓ એક સાથ\u{ac7}"),
            keywords: &["હથ\u{ac7}ળીઓ એક સાથ\u{ac7}"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tafunan hannu a sama tare"),
            keywords: &["addu’a", "tafunan hannu a sama tare"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפות ידיים מוצמדות ופונות כלפי מעלה"),
            keywords: &["כפות ידיים מוצמדות ופונות כלפי מעלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हथ\u{947}लियो\u{902} को एकसाथ ऊपर करना"),
            keywords: &[
                "प\u{94d}रार\u{94d}थना",
                "हथ\u{947}लियो\u{902} को एकसाथ ऊपर करना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("spojeni dlanovi"),
            keywords: &["molitva", "spojeni dlanovi"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felfelé fordított tenyerek"),
            keywords: &["felfelé fordított tenyerek", "ima"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքերի ափերը վեր"),
            keywords: &["աղոթք", "ձեռքերի ափերը վեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan diangkat dan dirapatkan bersama"),
            keywords: &["berdoa", "doa", "tangan diangkat dan dirapatkan bersama"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nchịkọta aka abụọ ọnụ"),
            keywords: &["ekpere", "nchịkọta aka abụọ ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lófar saman"),
            keywords: &["lófar saman", "spenntar greipar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mani unite in alto"),
            keywords: &["mani unite in alto", "preghiera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手のひらを揃えた両手"),
            keywords: &["両手", "手", "手のひらを揃えた両手", "祈り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan loro mandho nadhah amin"),
            keywords: &[
                "ndonga",
                "tangan loro mandho nadhah amin",
                "tangan loro nadhah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზეცისკენ აღპყრობილი ხელისგულები"),
            keywords: &["ზეცისკენ აღპყრობილი ხელისგულები", "ლოცვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("алақандарын көтеру"),
            keywords: &["алақандарын көтеру"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដាក\u{17cb}បាតដៃទន\u{17d2}ទ\u{17b9}មគ\u{17d2}នា"),
            keywords: &[
                "ដាក\u{17cb}បាតដៃទន\u{17d2}ទ\u{17b9}មគ\u{17d2}នា",
                "លើកដៃប\u{17bd}ងស\u{17bd}ង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎರಡ\u{cc2} ಹಸ\u{ccd}ತಗಳನ\u{ccd}ನು ಜೋಡ\u{cbf}ಸ\u{cbf}ರುವುದು"),
            keywords: &[
                "ಎರಡ\u{cc2} ಹಸ\u{ccd}ತಗಳನ\u{ccd}ನು ಜೋಡ\u{cbf}ಸ\u{cbf}ರುವುದು",
                "ಪ\u{ccd}ರಾರ\u{ccd}ಥನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("내민 두 손"),
            keywords: &["기도", "내민 두 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओ\u{902}जळ एकठा\u{902}य"),
            keywords: &[
                "एकठा\u{902}य ओ\u{902}जळ",
                "ओ\u{902}जळ एकठा\u{902}य",
                "प\u{94d}रार\u{94d}थना",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("алакан жаюу"),
            keywords: &["алакан жаюу", "сыйынуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("zesummegefaalten Hänn"),
            keywords: &["Gebiet", "zesummegefaalten Hänn"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{ebb}ກຝ\u{ec8}າມ\u{eb7}ຂ\u{eb6}\u{ec9}ນພ\u{ec9}ອມກ\u{eb1}ນ"),
            keywords: &[
                "ຍ\u{ebb}ກຝ\u{ec8}າມ\u{eb7}ຂ\u{eb6}\u{ec9}ນພ\u{ec9}ອມກ\u{eb1}ນ",
                "ນ\u{eb1}ກພາວະນາ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delnai suglausti"),
            keywords: &["delnai suglausti", "malda"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plaukstas kopā"),
            keywords: &["lūdzējs", "plaukstas kopā"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa rewa tahi"),
            keywords: &["inoi", "ringa rewa tahi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дланки една до друга"),
            keywords: &["дланки една до друга", "молитва"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇര\u{d41}കൈകള\u{d41}ം ഒര\u{d41}മിച\u{d4d}ച\u{d41}യർത\u{d4d}തൽ"),
            keywords: &[
                "ഇര\u{d41}കൈകള\u{d41}ം ഒര\u{d41}മിച\u{d4d}ച\u{d41}യർത\u{d4d}തൽ",
                "പ\u{d4d}ര\u{d3e}ർത\u{d4d}ഥന",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("алгаа хавсрах"),
            keywords: &["алгаа хавсрах", "мөргөлч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हाता\u{902}ची अो\u{902}जळ"),
            keywords: &[
                "प\u{94d}रार\u{94d}थना",
                "हाता\u{902}ची अो\u{902}जळ",
                "हाता\u{902}ची ओ\u{902}जळ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tapak tangan rapat"),
            keywords: &["berdoa", "tapak tangan rapat"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("pali tal-idejn flimkien"),
            keywords: &["pali tal-idejn flimkien", "talb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လက\u{103a}န\u{103e}စ\u{103a}ဘက\u{103a}အတ\u{1030}တ\u{1030}မြ\u{103e}ောက\u{103a}သည\u{103a}",
            ),
            keywords: &[
                "ဆ\u{102f}တောင\u{103a}းသ\u{1030}",
                "လက\u{103a}န\u{103e}စ\u{103a}ဘက\u{103a}အတ\u{1030}တ\u{1030}မြ\u{103e}ောက\u{103a}သည\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("håndflatene sammen"),
            keywords: &["ber", "bønn", "hånd", "håndflatene sammen"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथि जोडिएको जोर हात"),
            keywords: &["प\u{94d}रार\u{94d}थना", "माथि जोडिएको जोर हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("beide handpalmen omhoog"),
            keywords: &["beide handpalmen omhoog", "gebed"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handflatene saman"),
            keywords: &["ber", "bøn", "hand", "handflatene saman"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ଏକତ\u{b4d}ର ଉପରକ\u{b41} କର\u{b3f}ବ\u{b3e}"),
            keywords: &[
                "ପ\u{b3e}ପ\u{b41}ଲ\u{b3f} ଏକତ\u{b4d}ର ଉପରକ\u{b41} କର\u{b3f}ବ\u{b3e}",
                "ପ\u{b4d}ର\u{b3e}ର\u{b4d}ଥନ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਜ\u{a41}ੜੀਆ\u{a02} ਹਥ\u{a47}ਲੀਆ\u{a02}"),
            keywords: &[
                "ਅਰਦਾਸ",
                "ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਜ\u{a41}ੜੀਆ\u{a02} ਹਥ\u{a47}ਲੀਆ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اکٹھے ہتھلیاں ا\u{64f}وتے کرنا"),
            keywords: &["اکٹھے ہتھلیاں ا\u{64f}وتے کرنا", "نماز"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ópún Hand-dẹm Wé Dé Togẹ\u{301}da"),
            keywords: &["Préya", "Ópún Hand-dẹm Wé Dé Togẹ\u{301}da"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłonie do góry razem"),
            keywords: &["dłonie do góry razem", "modlitwa"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لپه لاسونه"),
            keywords: &["عبادت", "لپه لاسونه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("palmas unidas para cima"),
            keywords: &["oração", "palmas unidas para cima"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("palmas juntas abertas"),
            keywords: &[
                "mãos abertas",
                "mãos estendidas",
                "palmas abertas",
                "palmas juntas abertas",
                "palmas juntas para cima",
                "prece",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("makikunawan plegaria unancha"),
            keywords: &["makikunawan plegaria unancha", "plegaria"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("palme ridicate împreună"),
            keywords: &["palme ridicate împreună", "rugăciune"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1044"),
            keywords: &["E10-1044"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ладони лодочкой"),
            keywords: &[
                "вверх",
                "вместе",
                "ладони",
                "ладони лодочкой",
                "ладони, сложенные лодочкой",
                "молитва",
                "руки",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibiganza byombi hejuru"),
            keywords: &["ibiganza byombi hejuru", "isengesho"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("تريون مٿي گڏ"),
            keywords: &["تريون مٿي گڏ", "دعا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත\u{dca}ලවල\u{dca} එකට ඉහළ ඔසව\u{dcf}"),
            keywords: &[
                "අත\u{dca}ලවල\u{dca} එකට ඉහළ ඔසව\u{dcf}",
                "ය\u{dcf}ච\u{dca}ඤ\u{dcf} කරනව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdvihnuté dlane"),
            keywords: &["modlitba", "modliť sa", "zdvihnuté dlane"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvignjeni odprti dlani"),
            keywords: &["dvignjeni odprti dlani", "molitev"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaacalaha si wadajir ah kor loogu taaggo"),
            keywords: &[
                "calaacalaha si wadajir ah kor loo taaggo",
                "calaacalaha si wadajir ah kor loogu taaggo",
                "duco",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("pëllëmbë të bashkuara"),
            keywords: &["besimtar", "falje", "lutje", "pëllëmbë të bashkuara"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("дланови нагоре заједно"),
            keywords: &["дланови нагоре заједно", "молитва"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("dlanovi nagore zajedno"),
            keywords: &["dlanovi nagore zajedno", "molitva"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("handflatorna upp"),
            keywords: &["bön", "handflatorna upp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("viganja vilivyoshikana"),
            keywords: &["maombi", "viganja vilivyoshikana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இறைஞ\u{bcd}சும\u{bcd} கைகள\u{bcd}"),
            keywords: &[
                "இறைஞ\u{bcd}சும\u{bcd} கைகள\u{bcd}",
                "கடவுள\u{bcd}",
                "கைகள\u{bcd}",
                "தொழுதல\u{bcd}",
                "பிர\u{bbe}ர\u{bcd}த\u{bcd}தனை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఒకద\u{c3e}న\u{c3f}త\u{c4b} ఒకట\u{c3f} ముడ\u{c3f}వ\u{c47}స\u{c3f}న అరచ\u{c47}తులు",
            ),
            keywords: &[
                "ఒకద\u{c3e}న\u{c3f}త\u{c4b} ఒకట\u{c3f} ముడ\u{c3f}వ\u{c47}స\u{c3f}న అరచ\u{c47}తులు",
                "ప\u{c4d}ర\u{c3e}ర\u{c4d}థన",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастҳо якҷоя боло"),
            keywords: &["дастҳо якҷоя боло", "дуо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แบสองม\u{e37}อ"),
            keywords: &["แบสองม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýalary birleşdirip ýokary galdyrmak"),
            keywords: &["aýalary birleşdirip ýokary galdyrmak", "doga-dileg"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo aofinima hiki ki ʻolunga"),
            keywords: &["ongo aofinima hiki ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("iki avuç açık"),
            keywords: &["dua eden eller", "iki avuç açık"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوچۇم"),
            keywords: &["ئوچۇم", "دۇئا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("долоні, підняті разом"),
            keywords: &["долоні, підняті разом", "молитва"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ایک ساتھ ہتھیلیاں اٹھانا"),
            keywords: &["ایک ساتھ ہتھیلیاں اٹھانا", "نماز"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kaftlar ochiq"),
            keywords: &["kaftlar ochiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai bàn tay chạm vào nhau"),
            keywords: &["hai bàn tay chạm vào nhau", "lời cầu nguyện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tallal loxo ñaan"),
            keywords: &["tallal loxo ñaan", "ñaan"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iintende zesandla ezikunye"),
            keywords: &["iintende zesandla ezikunye", "umthandazo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("àtẹ\u{301}lẹ\u{301}ọwọ\u{301} papọ\u{300}"),
            keywords: &["àdúrà", "àtẹ\u{301}lẹ\u{301}ọwọ\u{301} papọ\u{300}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手掌一起"),
            keywords: &["手掌一起", "祈禱"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手掌一起"),
            keywords: &["手掌一起", "祈祷"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("掌心向上托起"),
            keywords: &["掌心向上托起", "祷告"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雙手掌朝上"),
            keywords: &["祈禱", "雙手掌朝上"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("雙手掌心向上"),
            keywords: &["祈禱", "雙手掌心向上"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izandla zombili phezulu"),
            keywords: &["izandla zombili phezulu", "umthandazo"],
        },
    ],
};
#[doc = "🤲🏻"]
pub const PALMS_UP_TOGETHER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤲🏻",
    codepoint: "1F932 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "palms up together: light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤲🏼"]
pub const PALMS_UP_TOGETHER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤲🏼",
    codepoint: "1F932 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "palms up together: medium-light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤲🏽"]
pub const PALMS_UP_TOGETHER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤲🏽",
    codepoint: "1F932 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "palms up together: medium skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤲🏾"]
pub const PALMS_UP_TOGETHER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤲🏾",
    codepoint: "1F932 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "palms up together: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤲🏿"]
pub const PALMS_UP_TOGETHER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤲🏿",
    codepoint: "1F932 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "palms up together: dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤝"]
pub const HANDSHAKE: crate::Emoji = crate::Emoji {
    glyph: "🤝",
    codepoint: "1F91D",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "handshake",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handskud"),
            keywords: &["bladskud", "groet", "handskud", "ooreenkoms"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እጅ መጨባበጥ"),
            keywords: &["መጨባበጥ", "ስምምነት", "ስብሰባ", "እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("مصافحة"),
            keywords: &["اتفاق", "اجتماع", "مصافحة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("কৰমৰ\u{9cd}দন"),
            keywords: &[
                "কৰমৰ\u{9cd}দন",
                "চ\u{9c1}ক\u{9cd}তি",
                "মিটিং",
                "লৰোৱ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("salamlaşmaq"),
            keywords: &["görüşmək", "salam", "salamlaşmaq", "əl sıxmaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("поціск рук"),
            keywords: &["дамовіліся", "поціск рук", "рукапацісканне", "сустрэча"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ръкостискане"),
            keywords: &["ръка", "ръкостискане", "среща", "съгласие"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("করমর\u{9cd}দন"),
            keywords: &[
                "করমর\u{9cd}দন",
                "মিট কর\u{9be}",
                "র\u{9be}জি",
                "হ\u{9be}ত",
                "হ\u{9be}ত মেল\u{9be}নো",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("rukovanje"),
            keywords: &["dogovor", "ruka", "rukovanje", "sastanak", "stisak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("encaixada de mans"),
            keywords: &[
                "acord",
                "encaixada",
                "encaixada de mans",
                "mans",
                "salutació",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏓᏲᎵᎲᎢ"),
            keywords: &["ᎠᏓᏲᎵᎲᎢ", "ᎠᏓᏲᎵᏍᏗ", "ᎠᏖᎸᏗ", "ᎤᏬᏱ", "ᏓᎾᏠᏍᎬᎢ", "ᏗᏓᏁᏤᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("stisk rukou"),
            keywords: &[
                "podání",
                "potřesení",
                "potřást",
                "ruka",
                "rukou",
                "ruky",
                "seznámení",
                "souhlas",
                "stisk",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ysgwyd dwylo"),
            keywords: &["cyfarfod", "cytuno", "llaw", "ysgwyd", "ysgwyd dwylo"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("håndtryk"),
            keywords: &["aftale", "enighed", "hilsen", "håndtryk", "hænder", "mødes"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Handschlag"),
            keywords: &["Handschlag", "Hände", "Händeschütteln", "Vereinbarung"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χειραψία"),
            keywords: &["συμφωνία", "συνάντηση", "σφίγγω", "χέρι", "χειραψία"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("handshake"),
            keywords: &["agreement", "hand", "handshake", "meeting", "shake"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("apretón de manos"),
            keywords: &["acuerdo", "apretón", "apretón de manos", "manos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["acuerdo", "apretón", "apretón de manos", "manos", "reunión"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("käepigistus"),
            keywords: &["kohtumine", "käepigistus", "käsi", "tervitus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-ematea"),
            keywords: &["adostasun", "bilera", "esku", "esku-emate", "esku-ematea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست دادن"),
            keywords: &[
                "دست",
                "دست دادن",
                "قرار",
                "قرار کاری",
                "قول",
                "ملاقات",
                "موافق",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kädenpuristus"),
            keywords: &["kädenpuristus", "käsi", "kätellä", "sopimus", "tapaaminen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pagkakamay"),
            keywords: &["kamay", "kasunduan", "meeting", "pagkakamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lógvatak"),
            keywords: &["hendur", "hond", "lógvatak", "taka í"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poignée de main"),
            keywords: &[
                "mains",
                "poignée",
                "poignée de main",
                "présentation",
                "rencontre",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "accord",
                "main",
                "poignée",
                "poignée de main",
                "présentation",
                "rencontre",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croitheadh lámh"),
            keywords: &[
                "aontú",
                "beannú",
                "croitheadh láimhe",
                "croitheadh lámh",
                "síocháin",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crathadh-làimhe"),
            keywords: &[
                "aontachadh",
                "coinneamh",
                "crath",
                "crathadh",
                "crathadh-làimhe",
                "làmh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("aperta de mans"),
            keywords: &["aperta", "aperta de mans", "mans", "trato"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ મિલાવવો"),
            keywords: &[
                "કરાર",
                "મિલાવવ\u{ac1}\u{a82}",
                "મીટિ\u{a82}ગ",
                "હાથ",
                "હાથ મિલાવવો",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("shan hannu"),
            keywords: &["hannu", "sha", "shan hannu", "taro", "yarjejeniya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לחיצת יד"),
            keywords: &["הסכם", "לחיצת יד", "פגישה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाथ मिलाना"),
            keywords: &["मिलाना", "मीटि\u{902}ग", "समझौता", "हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("rukovanje"),
            keywords: &["dogovor", "ruka", "rukovanje", "sastanak", "stisak ruke"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kézfogás"),
            keywords: &["kézfogás", "megállapodás", "találkozás", "üdvözlés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքսեղմում"),
            keywords: &[
                "համաձայնություն",
                "հանդիպում",
                "ձեռք",
                "ձեռքսեղմում",
                "սեղմել",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jabat tangan"),
            keywords: &["jabat tangan", "salaman", "sepakat", "setuju", "tangan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nkwenaka"),
            keywords: &[
                "aka",
                "ekwemụaka",
                "kwee",
                "nkwekọrịta",
                "nkwenaka",
                "nzukọ",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("handaband"),
            keywords: &["handaband", "heilsa", "heilsast", "samkomulag"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("stretta di mano"),
            keywords: &["conoscere", "mano", "presentarsi", "stretta di mano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("握手"),
            keywords: &["よろしく", "合意", "手", "握手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("salaman"),
            keywords: &["rapat", "salam", "salaman", "sarujuk", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელის ჩამორთმევა"),
            keywords: &[
                "გაცნობა",
                "შეთანხმება",
                "ჩამორთმევა",
                "ხელი",
                "ხელის ჩამორთმევა",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қол алысты"),
            keywords: &["алысты", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("håndtryk"),
            keywords: &[
                "enighed",
                "hilsen",
                "hilser",
                "hånd",
                "håndtryk",
                "hænder",
                "krop",
                "mødes",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចាប\u{17cb}ដៃ"),
            keywords: &[
                "ការព\u{17d2}រមព\u{17d2}រៀង",
                "ចាប\u{17cb}",
                "ចាប\u{17cb}ដៃ",
                "ដៃ",
                "ប\u{17d2}រជ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಸ\u{ccd}ತಲಾಘವ"),
            keywords: &[
                "ಅಲುಗಾಡ\u{cbf}ಸು",
                "ಒಪ\u{ccd}ಪಂದ",
                "ಕೈ",
                "ಮೀಟ\u{cbf}ಂಗ\u{ccd}",
                "ಹಸ\u{ccd}ತಲಾಘವ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("악수"),
            keywords: &["미팅", "손", "악수", "합의", "회의"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("श\u{947}कह\u{901}ड"),
            keywords: &[
                "करार",
                "बसका\u{902}",
                "श\u{947}क",
                "श\u{947}कह\u{901}ड",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол алышуу"),
            keywords: &["жолугуу", "келишүү", "кол алышуу"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Handdrock"),
            keywords: &["Hand", "Handdrock", "Ofkommes", "Reunioun", "drécken"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb1}ບມ\u{eb7}"),
            keywords: &[
                "ຂ\u{ecd}\u{ec9}ຕ\u{ebb}ກລ\u{ebb}ງ",
                "ຈ\u{eb1}ບ",
                "ຈ\u{eb1}ບມ\u{eb7}",
                "ປະຊ\u{eb8}ມ",
                "ມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rankos paspaudimas"),
            keywords: &[
                "pasisveikinimas",
                "paspaudimas",
                "ranka",
                "rankos paspaudimas",
                "susitarimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rokasspiediens"),
            keywords: &["līgums", "roka", "rokasspiediens", "sarokoties", "tikšanās"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("rūrū"),
            keywords: &["ringa", "rūrū", "tūtaki", "whakaaetanga"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("ракување"),
            keywords: &["договор", "ракување", "средба"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹസ\u{d4d}തദ\u{d3e}നം"),
            keywords: &[
                "ക\u{d41}ല\u{d41}ക\u{d4d}ക\u{d41}ക",
                "ക\u{d42}ടിക\u{d4d}ക\u{d3e}ഴ\u{d4d}ച",
                "കൈ",
                "സമ\u{d4d}മതം",
                "ഹസ\u{d4d}തദ\u{d3e}നം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гар барилт"),
            keywords: &["барилт", "гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हस\u{94d}ता\u{902}दोलन"),
            keywords: &[
                "करार",
                "भ\u{947}ट",
                "हलविण\u{947}",
                "हस\u{94d}ता\u{902}दोलन",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("berjabat tangan"),
            keywords: &["berjabat tangan", "perjumpaan", "persetujuan", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħu bl-idejn"),
            keywords: &[
                "b’idejn",
                "ftehim",
                "handshake",
                "laqgħa",
                "ħu",
                "ħu bl-idejn",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ဆ\u{103d}\u{1032}န\u{103e}\u{102f}တ\u{103a}ဆက\u{103a}"),
            keywords: &[
                "ဆ\u{103d}\u{1032}လ\u{103e}\u{102f}ပ\u{103a}",
                "တ\u{103d}ေ\u{1037}ဆ\u{102f}\u{1036}ခြင\u{103a}း",
                "လက\u{103a}",
                "လက\u{103a}ဆ\u{103d}\u{1032}န\u{103e}\u{102f}တ\u{103a}ဆက\u{103a}",
                "သဘောတ\u{1030}ည\u{102e}ချက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("håndhilse"),
            keywords: &["avtale", "hånd", "håndhilse", "håndtrykk", "møte"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हात मिलाउन\u{947} कार\u{94d}य"),
            keywords: &[
                "ब\u{948}ठक",
                "सम\u{94d}झौ\u{902}ता",
                "हल\u{94d}लाउन\u{947}",
                "हात",
                "हात मिलाउन\u{947} कार\u{94d}य",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("handdruk"),
            keywords: &["deal", "hand", "handdruk", "ontmoeting", "overeenkomst"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("handhelse"),
            keywords: &["avtale", "hand", "handhelse", "handtrykk", "møte"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କରମର\u{b4d}ଦ\u{b4d}ଦନ"),
            keywords: &[
                "କରମର\u{b4d}ଦ\u{b4d}ଦନ",
                "ସହମତ",
                "ସ\u{b3e}କ\u{b4d}ଷ\u{b3e}ତ",
                "ହଲ\u{b3e}ଇବ\u{b3e}",
                "ହ\u{b3e}ଣ\u{b4d}ଡଶେକ\u{b4d}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਥ-ਮਿਲਾਉਣਾ"),
            keywords: &[
                "ਮਿਲਾਉਣਾ",
                "ਮੀਟਿ\u{a70}ਗ",
                "ਸਮਝ\u{a4c}ਤਾ",
                "ਹ\u{a71}ਥ",
                "ਹ\u{a71}ਥ-ਮਿਲਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ ملانا"),
            keywords: &["راضی نامہ", "ملاقات", "ہتھ", "ہتھ ملانا", "ہلانا"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hándshek"),
            keywords: &["Agrímẹnt", "Hand", "Hándshek", "Mítin", "Shek"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uścisk dłoni"),
            keywords: &["powitanie", "spotkanie", "uścisk", "uścisk dłoni", "zgoda"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ستړې مشي"),
            keywords: &["خوځول", "ستړې مشي", "لاس", "ملاقات", "موافقه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("aperto de mãos"),
            keywords: &[
                "aperto",
                "aperto de mãos",
                "combinado",
                "cumprimento",
                "mãos",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("aperto de mão"),
            keywords: &[
                "acordo",
                "aperto",
                "aperto de mão",
                "mão",
                "passou-bem",
                "reunião",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("pipuyasqa makikunapura"),
            keywords: &[
                "huñunakuy",
                "maki",
                "pipuyasqa",
                "pipuyasqa makikunapura",
                "pipuyasqa makukunapura",
                "uyniy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("strângere de mână"),
            keywords: &[
                "acord",
                "mână",
                "noroc",
                "strângere de mână",
                "întâlnire",
                "înțelegere",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1023"),
            keywords: &["E10-1023"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рукопожатие"),
            keywords: &["встреча", "договорились", "рукопожатие", "согласие"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gusuhuzanya"),
            keywords: &[
                "guhura",
                "gusuhuzanya",
                "gutigisa",
                "ikiganza",
                "kwemeranya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هٿ ملائڻ"),
            keywords: &["معاهدو", "ملائڻ", "هٿ", "گڏجاڻي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අතට අත ද\u{dd3}ම"),
            keywords: &[
                "අත",
                "අතට අත ද\u{dd3}ම",
                "එකඟත\u{dca}වය",
                "සෙලව\u{dd3}ම",
                "හම\u{dd4}ව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("potrasenie rukami"),
            keywords: &[
                "dohoda",
                "dohodnuté",
                "podať",
                "potrasenie rukami",
                "potriasť",
                "ruka",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("rokovanje"),
            keywords: &["roka", "rokovanje", "sporazum", "srečanje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan-qaadka salaanta"),
            keywords: &[
                "gacan",
                "gacan-qaadka salaanta",
                "heshiiska",
                "kulan",
                "salan",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shtrëngim duarsh"),
            keywords: &["dorë", "marrëveshje", "shtrëngim duarsh", "takim", "tundje"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("руковање"),
            keywords: &["договор", "договорено", "решено", "руковање", "састанак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["руковање"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("rukovanje"),
            keywords: &["dogovor", "dogovoreno", "rešeno", "rukovanje", "sastanak"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["rukovanje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("handskakning"),
            keywords: &["avtal", "hand", "handskakning", "möte"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kusalimiana"),
            keywords: &["kusalimiana", "maafikiano", "makubaliano", "salamu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைகுலுக\u{bcd}கல\u{bcd}"),
            keywords: &[
                "ஒப\u{bcd}பந\u{bcd}தம\u{bcd}",
                "கை",
                "கைகுலுக\u{bcd}கல\u{bcd}",
                "சந\u{bcd}திப\u{bcd}பு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కరచ\u{c3e}లనం"),
            keywords: &[
                "ఒప\u{c4d}పందం",
                "కరచ\u{c3e}లనం",
                "చ\u{c3e}లనం",
                "చ\u{c47}య\u{c3f}",
                "సమ\u{c3e}వ\u{c47}శం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастфишӯрӣ"),
            keywords: &[
                "вохӯрӣ",
                "даст",
                "дастфишурӣ",
                "дастфишӯрӣ",
                "созишнома",
                "фишурдан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จ\u{e31}บม\u{e37}อ"),
            keywords: &[
                "ค\u{e37}นด\u{e35}",
                "จ\u{e31}บม\u{e37}อ",
                "ร\u{e48}วมงาน",
                "ร\u{e48}วมม\u{e37}อ",
                "เชคแฮนด\u{e4c}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("el gysyşmak"),
            keywords: &["duşuşyk", "el", "gysyşmak", "ylalaşyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lulululu"),
            keywords: &["lulululu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("el sıkışma"),
            keywords: &["anlaşma", "el", "el sıkışma", "sallama", "toplantı"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قول قىسىش"),
            keywords: &["ئۇچرىشىش", "قوشۇلۇش", "قول", "قول ئېلىشىش", "قول قىسىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рукостискання"),
            keywords: &["згода", "потискання", "руки", "рукостискання"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ ملانا"),
            keywords: &["ملانا", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘l siqish"),
            keywords: &["kelishuv", "qo‘l siqish", "uchrashuv"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bắt tay"),
            keywords: &["bắt tay", "gặp mặt", "rung", "tay", "đồng ý"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("joxante loxo"),
            keywords: &["déggoo", "joxante", "loxo", "ndaje"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukubamba isandla"),
            keywords: &[
                "intlanganiso",
                "isandla",
                "isivumelwano",
                "shukumisa",
                "ukubamba isandla",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ìbọwọ\u{301}"),
            keywords: &[
                "gbọn",
                "Ìbọwọ\u{301}",
                "ìbọwọ\u{301}",
                "ìfaramọ\u{301}",
                "ìpàdé",
                "ọwọ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("握手"),
            keywords: &["同意", "手", "握", "握手", "開會"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("握手"),
            keywords: &["同意", "开会", "手", "握", "握手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("握手"),
            keywords: &["会面", "协议", "握手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("握手"),
            keywords: &["手", "握", "握手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("xhawula"),
            keywords: &[
                "isandla",
                "isivumelwano",
                "nyakazisa",
                "ukuxhawula",
                "umhlangano",
                "xhawula",
            ],
        },
    ],
};
#[doc = "🙏"]
pub const FOLDED_HANDS: crate::Emoji = crate::Emoji {
    glyph: "🙏",
    codepoint: "1F64F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "folded hands",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gevoude hande"),
            keywords: &[
                "asseblief",
                "bid",
                "dankie",
                "gebaar",
                "gevoude hande",
                "hand",
                "liggaam",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የእጅ መዳፎቹን ያጣበቀ ሰው"),
            keywords: &["መጠየቅ", "መጸለይ", "ምስጋና", "እጅ", "የተጣመረ", "የእጅ መዳፎቹን ያጣበቀ ሰው"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يدان مضمومتان"),
            keywords: &["أداء صلاة", "إشارة", "صلاة", "يد", "يدان مضمومتان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত জোৰ কৰ\u{9be}"),
            keywords: &[
                "অন\u{9c1}গ\u{9cd}ৰহ",
                "ধন\u{9cd}যব\u{9be}দ",
                "প\u{9cd}ৰ\u{9be}ৰ\u{9cd}থন\u{9be}",
                "সোধ\u{9be}",
                "হ\u{9be}ত",
                "হ\u{9be}ত জোৰ কৰ\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qatlanmış əllər"),
            keywords: &[
                "dua etmək",
                "jest",
                "orqan",
                "qatlanmış",
                "qatlanmış əllər",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("складзеныя рукі"),
            keywords: &[
                "жэст",
                "калі ласка",
                "малітва",
                "просьба",
                "рукі",
                "складзеныя рукі",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Събрани ръце"),
            keywords: &["Събрани ръце", "благодаря", "молба", "моля", "моля се"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নমস\u{9cd}ক\u{9be}র"),
            keywords: &[
                "অন\u{9c1}গ\u{9cd}রহ করে",
                "জ\u{9be}নতে চ\u{9be}ওয\u{9bc}\u{9be}",
                "ধন\u{9cd}যব\u{9be}দ",
                "নমস\u{9cd}ক\u{9be}র",
                "ম\u{9be}থ\u{9be} নত",
                "হ\u{9be}ত",
                "হ\u{9be}ত জোড\u{9bc} কর\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("sastavljeni dlanovi"),
            keywords: &[
                "gestikulacija",
                "molba",
                "molitva",
                "sastavljeni dlanovi",
                "zahvalnost",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mans en oració"),
            keywords: &["gràcies", "mans", "mans en oració", "pregar", "si us plau"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏚᏆᏰᏅᏍᏛ"),
            keywords: &["ᎠᎵᎮᎵᏤᏗ", "ᎠᏛᏛᏗ", "ᎠᏴᏈᏛᎢ", "ᎤᎵᏍᏈᏗ", "ᏚᏆᏰᏅᏍᏛ", "ᏧᏬᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("sepjaté ruce"),
            keywords: &[
                "díky",
                "gesto",
                "modlitba",
                "otázka",
                "prosím",
                "ruka",
                "sepjaté",
                "sepjaté ruce",
                "tělo",
                "úklona",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwylo wedi plygu"),
            keywords: &["corff", "dwylo wedi plygu", "gweddi", "plygu", "ystum"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("foldede hænder"),
            keywords: &["bøn", "foldede hænder", "namaste", "namasté"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("betende Hände"),
            keywords: &["Gebet", "beten", "betende Hände", "bitte"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χέρια ενωμένα"),
            keywords: &[
                "ενωμένα",
                "ευχαριστώ",
                "ζητώ",
                "κίνηση",
                "παρακαλώ",
                "προσευχή",
                "σώμα",
                "υπόκλιση",
                "χέρι",
                "χέρια ενωμένα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("folded hands"),
            keywords: &[
                "ask",
                "folded hands",
                "hand",
                "high 5",
                "high five",
                "please",
                "pray",
                "thanks",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("manos en oración"),
            keywords: &["mano", "manos en oración", "oración", "orar", "rezar"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "favor",
                "gracias",
                "manos",
                "manos en oración",
                "oración",
                "orar",
                "rezar",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "favor",
                "gracias",
                "manos en oración",
                "oración",
                "orar",
                "rezar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "favor",
                "gracias",
                "manos en oración",
                "oración",
                "orar",
                "rezar",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("palveasendis käed"),
            keywords: &[
                "aitäh",
                "käed",
                "palve",
                "palveasendis käed",
                "tänan",
                "žest",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erregutzen ari diren eskuak"),
            keywords: &[
                "erregutzen ari diren eskuak",
                "eskatu",
                "eskerrak",
                "mesedez",
                "otoitz",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خواهش می\u{200c}کنم"),
            keywords: &[
                "خواهش",
                "خواهش می\u{200c}کنم",
                "درخواست",
                "دست",
                "دستان دعاگو",
                "دعا",
                "سپاس",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kämmenet yhdessä"),
            keywords: &[
                "kiitos",
                "kumarrus",
                "kämmenet yhdessä",
                "pliis",
                "pyyntö",
                "rukous",
                "yläfemma",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("magkalapat na mga palad"),
            keywords: &[
                "humihiling",
                "kamay",
                "magkalapat na mga palad",
                "nagdarasal",
                "nagpapasalamat",
                "nakikisuyo",
                "yuko",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("falda hendur"),
            keywords: &["bøn", "eggja saman hendur", "falda", "hendur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("mains en prière"),
            keywords: &["mains", "mains en prière", "prière"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "mains",
                "mains en prière",
                "merci",
                "moins jointes",
                "prière",
                "svp",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámha le chéile"),
            keywords: &["ag guí", "guí", "lámh", "lámha le chéile", "paidir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmhan paisgte"),
            keywords: &[
                "cromadh",
                "faighneachd",
                "gluasad",
                "iarraidh",
                "làmh",
                "làmhan paisgte",
                "paisgte",
                "taing",
                "ùrnaigh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("mans en oración"),
            keywords: &["mans", "mans en oración", "orar", "por favor", "rezar"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વાળ\u{ac7}લા હાથ"),
            keywords: &[
                "અદબ વાળ\u{ac7}લા હાથ",
                "પ\u{acd}રાર\u{acd}થના",
                "પ\u{acd}રાર\u{acd}થના કરવી",
                "વાળ\u{ac7}લા હાથ",
                "હાથ",
                "હાવભાવ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kalmasassun hannuwa"),
            keywords: &[
                "addu’a",
                "don Allah",
                "godiya",
                "hannu",
                "kalmasassu",
                "kalmasassun hannuwa",
                "karimcin",
                "roƙo",
                "sunkuya",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כפות ידיים מוצמדות"),
            keywords: &[
                "כפות ידיים",
                "כפות ידיים מוצמדות",
                "סימן ידיים",
                "תודה",
                "תפילה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("अभिवादन"),
            keywords: &[
                "अभिवादन",
                "नमस\u{94d}त\u{947}",
                "प\u{942}जा",
                "प\u{94d}रार\u{94d}थना",
                "प\u{94d}रार\u{94d}थना करना",
                "हाथ",
                "हाथ जोड\u{93c}ना",
                "हावभाव",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("sklopljeni dlanovi"),
            keywords: &[
                "molitva",
                "moljenje",
                "naklon",
                "ruke",
                "sklopljeni dlanovi",
                "zahvala",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("összetett kéz"),
            keywords: &["ima", "kérés", "köszönet", "test", "összetett kéz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքերի ափերը միացված"),
            keywords: &[
                "աղոթել",
                "ժեստ",
                "խնդրել",
                "խնդրում եմ",
                "խոնարհվել",
                "ձեռք",
                "ձեռքերի ափերը միացված",
                "մարմին",
                "միացված",
                "շնորհակալություն",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("melipat tangan"),
            keywords: &[
                "berdoa",
                "bungkuk",
                "gerakan",
                "lipat",
                "makasih",
                "melipat tangan",
                "mohon",
                "tangan",
                "tolong",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ejikọrọ ọnụ"),
            keywords: &[
                "aka",
                "aka ejikọrọ ọnụ",
                "biko",
                "daalụ",
                "hulata",
                "jikọrọ ọnụ",
                "jụọ",
                "kpee ekpere",
                "ogbugbu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bæn"),
            keywords: &["bæn", "spenna greipar", "spenntar greipar"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mani giunte"),
            keywords: &["gesto", "mani giunte", "mano", "pregare", "preghiera"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("祈り"),
            keywords: &["お願い", "ごめんなさい", "合掌", "祈り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan nyembah"),
            keywords: &[
                "maturnuwun",
                "ndonga",
                "njaluk",
                "nyenyuwun",
                "tangan",
                "tangan nyembah",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ერთმანეთზე მიდებული ხელები"),
            keywords: &[
                "გთხოვ",
                "ერთად",
                "ერთმანეთზე მიდებული ხელები",
                "თხოვნა",
                "ლოცვა",
                "მადლობა",
                "ჟესტი",
                "სხეული",
                "ტანი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ғибадат қылу"),
            keywords: &[
                "рақмет",
                "сұрау",
                "ғибадат қылу",
                "қол",
                "қосылған қолдар",
                "өтініш",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("foldede hænder"),
            keywords: &["bøn", "foldede hænder"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17c6}ពះ"),
            keywords: &["គោរព", "ស\u{17c6}ពះ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಮಸ\u{ccd}ಕಾರ"),
            keywords: &["ಕೈ", "ನಮಸ\u{ccd}ಕಾರ", "ಪ\u{ccd}ರಾರ\u{ccd}ಥನ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기도"),
            keywords: &["기도", "기도하는 사람", "두 손 모아 기도하는 사람", "합장"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जोडिल\u{94d}ल\u{947} हात"),
            keywords: &[
                "जोडिल\u{94d}ल\u{947} हात",
                "द\u{947}व बर\u{947}\u{902} कर\u{942}\u{902}",
                "प\u{94d}रार\u{94d}थना",
                "याचना",
                "विचारप",
                "हात",
                "हात जोडप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("алаканын бириктирген колдор"),
            keywords: &[
                "алаканын бириктирген колдор",
                "жалын",
                "кол",
                "ыраазычылык",
                "өтүн",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gefaalten Hänn"),
            keywords: &[
                "Geste",
                "Hand",
                "Merci",
                "bieden",
                "froen",
                "gefaalt",
                "gefaalten Hänn",
                "vernäipen",
                "wann ech gelift",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ພະນ\u{ebb}ມມ\u{eb7}"),
            keywords: &[
                "ຂອບໃຈຫ ເຄ\u{ebb}າລ\u{ebb}ບ",
                "ຖາມ",
                "ພະນ\u{ebb}ມມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
                "ໄຫວ\u{ec9}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("suglausti delnai"),
            keywords: &["melstis", "prašymas", "ranka", "suglausti delnai"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lūgšanā saliktas rokas"),
            keywords: &[
                "lūgt",
                "lūgties",
                "lūgšanā saliktas rokas",
                "rokas",
                "žests",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa whiri"),
            keywords: &[
                "ihoi",
                "koa",
                "pōkai",
                "ringa",
                "ringa whiri",
                "tohu",
                "tuohu",
                "ui",
                "whakawhetai",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("споени дланки"),
            keywords: &["благодарност", "гест", "молба", "молитва", "споени дланки"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d42}പ\u{d4d}പ\u{d41}കൈ"),
            keywords: &[
                "ക\u{d42}പ\u{d4d}പ\u{d41}കൈ",
                "കൈ",
                "ചോദിക\u{d4d}ക\u{d41}ക",
                "ദയവ\u{d3e}യി",
                "നന\u{d4d}ദി",
                "പ\u{d4d}ര\u{d3e}ർത\u{d4d}ഥിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хавсарсан гарын алга"),
            keywords: &["алга", "гар", "хавсарсан гарын алга", "хавсрах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जोडल\u{947}ल\u{947} तळहात"),
            keywords: &[
                "क\u{943}पया",
                "जोडल\u{947}ल\u{947} तळहात",
                "धन\u{94d}यवाद",
                "नमस\u{94d}कार करण\u{947}",
                "प\u{94d}रार\u{94d}थना",
                "विचारण\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("menyusun jari"),
            keywords: &[
                "doa",
                "menyusun jari",
                "tangan",
                "tanya",
                "terima kasih",
                "tolong",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("idejn magħluqa"),
            keywords: &[
                "Staqsi",
                "bl-idejn",
                "grazzi",
                "idejn magħluqa",
                "inkina",
                "jekk jogħġbok",
                "jitolbu",
                "magħluqa",
                "ġesti",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ယ\u{103e}က\u{103a}ထားသည\u{1037}\u{103a} လက\u{103a}များ"),
            keywords: &[
                "ကျေးဇ\u{1030}းတင\u{103a}ကြောင\u{103a}းပြ လက\u{103a}ဟန\u{103a}",
                "ဆ\u{102f}တောင\u{103a}းပ\u{102f}\u{1036} လက\u{103a}ဟန\u{103a}",
                "ယ\u{103e}က\u{103a}ထားသည\u{1037}\u{103a} လက\u{103a}များ",
                "လက\u{103a}",
                "လက\u{103a}အ\u{102f}ပ\u{103a}ချ\u{102e}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("foldede hender"),
            keywords: &["be", "ber", "bevegelse", "bønn", "foldede hender", "hånd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जोडिएका हातहर\u{942}"),
            keywords: &[
                "क\u{943}पया",
                "जोडिएका हातहर\u{942}",
                "धन\u{94d}यवाद",
                "प\u{94d}राथना गर\u{94d}न\u{941}",
                "बिन\u{94d}ती भावमा जोडिएका हातहर\u{942}",
                "सोध\u{94d}न\u{941}",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gevouwen handen"),
            keywords: &[
                "alsjeblieft",
                "bedankt",
                "bidden",
                "gevouwen handen",
                "hand",
                "vragen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("falda hender"),
            keywords: &["be", "ber", "bøn", "falda hender", "hand", "rørsle"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯୋଡ\u{b3c} ହସ\u{b4d}ତ"),
            keywords: &[
                "ଦୟ\u{b3e}କର\u{b3f}",
                "ଧନ\u{b4d}ୟବ\u{b3e}ଦ",
                "ପଚ\u{b3e}ର\u{b3f}ବ\u{b3e}",
                "ପ\u{b4d}ର\u{b3e}ର\u{b4d}ଥନ\u{b3e}",
                "ଯୋଡ\u{b3c} ହସ\u{b4d}ତ",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତ ଯୋଡ\u{b3c}\u{b3f}ବ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜ\u{a41}ੜ\u{a47} ਹ\u{a4b}ਏ ਹ\u{a71}ਥ"),
            keywords: &[
                "ਅਰਦਾਸ",
                "ਅਰਦਾਸ ਕਰਨਾ",
                "ਜ\u{a41}ੜ\u{a47} ਹ\u{a4b}ਏ ਹ\u{a71}ਥ",
                "ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دوہرے کیتے ہتھ"),
            keywords: &[
                "اشارہ",
                "ج\u{64f}ھکنا",
                "دعا",
                "دوہرا کیتا",
                "دوہرے کیتے ہتھ",
                "شکریہ",
                "میربانی کر کے",
                "پوچھنا",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand-dẹm Wé Dẹm Fold"),
            keywords: &[
                "Abẹg",
                "Aks",
                "Hand",
                "Hand-dẹm Wé Dẹm Fold",
                "Prè",
                "Tánk-io",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("złożone ręce"),
            keywords: &["modlitwa", "prosić", "złożone ręce"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مننې لاسونه"),
            keywords: &[
                "اشاره",
                "بند",
                "عبادت",
                "غوښتل",
                "لاس",
                "مننه",
                "مننې لاسونه",
                "مهربانی",
                "پوښتنه",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mãos juntas"),
            keywords: &["gesto", "mão", "mãos juntas", "reza", "rezando", "rezar"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "agradecimento",
                "mão",
                "mãos juntas",
                "pedido",
                "por favor",
                "reverência",
                "rezar",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("makikuna rezando"),
            keywords: &["maki", "makikuna rezando", "orar", "pachi", "tapuy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mâini unite"),
            keywords: &["mulțumiri", "mâini", "mâini unite", "rugăciune", "te rog"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-915"),
            keywords: &["E10-915"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сложенные руки"),
            keywords: &[
                "молитва",
                "пожалуйста",
                "просьба",
                "руки",
                "сложенные руки",
                "умолять",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibiganza bifatanye"),
            keywords: &[
                "gihinnye",
                "gusenga",
                "ibiganza bifatanye",
                "ikiganza",
                "ikimenyetso",
                "kubaza",
                "kunama",
                "murakoze cyane",
                "nyaboneka",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ويڙهيل هٿ"),
            keywords: &[
                "ادا",
                "جھڪڻ",
                "عبادت ڪرڻ",
                "مهرباني",
                "مهرباني ڪري",
                "هٿ",
                "ويڙهيل",
                "پڇڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එක\u{dca} කළ දෙඅත\u{dca}"),
            keywords: &[
                "අත",
                "ආච\u{dcf}ර ක\u{dd2}ර\u{dd3}ම",
                "එක\u{dca} කළ දෙඅත\u{dca}",
                "කර\u{dd4}ණ\u{dcf}කර",
                "ය\u{dcf}ච\u{dca}ඥ\u{dcf} ක\u{dd2}ර\u{dd3}ම",
                "ස\u{dca}ත\u{dd6}ත\u{dd2}ය පළ ක\u{dd2}ර\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zopäté ruky"),
            keywords: &[
                "modlitba",
                "modliť sa",
                "prosba",
                "prosiť",
                "ruka",
                "zopäté ruky",
                "ďakovať",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("staknjeni dlani"),
            keywords: &[
                "gesta",
                "hvala",
                "moliti",
                "predklon",
                "prosim",
                "prositi",
                "roka",
                "sklenjeno",
                "staknjeni dlani",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacmo laaban"),
            keywords: &[
                "duco",
                "fadlan",
                "gacan",
                "gacmo laaban",
                "mahadsanid",
                "weydiin",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("duar të mbledhura"),
            keywords: &[
                "duar të mbledhura",
                "faleminderit",
                "gjest",
                "lutje",
                "përkulem",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("спојени дланови"),
            keywords: &[
                "зaхвaлност",
                "крeтање",
                "мoлитвa",
                "мoљeњe",
                "нaклoн",
                "рукe",
                "спојени дланови",
                "тело",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["спојени дланови"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("spojeni dlanovi"),
            keywords: &[
                "kretanje",
                "molitva",
                "moljenje",
                "naklon",
                "ruke",
                "spojeni dlanovi",
                "telo",
                "zahvalnost",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["spojeni dlanovi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("beende händer"),
            keywords: &["be", "beende händer", "ber", "händer", "knäppta händer"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mikono iliyokunjwa"),
            keywords: &[
                "asante",
                "inama",
                "kunjwa",
                "mikono iliyokunjwa",
                "omba",
                "tafadhali",
                "uliza",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கூப\u{bcd}பிய கைகள\u{bcd}"),
            keywords: &[
                "கூப\u{bcd}பிய கைகள\u{bcd}",
                "கைகள\u{bcd}",
                "கோரிக\u{bcd}கை",
                "நன\u{bcd}றி",
                "வேண\u{bcd}டுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}తులు ముడుచుకున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}"),
            keywords: &[
                "చ\u{c47}తులు",
                "చ\u{c47}తులు ముడుచుకున\u{c4d}న వ\u{c4d}యక\u{c4d}త\u{c3f}",
                "వ\u{c4d}యక\u{c4d}త\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дастҳои қат кардашуда"),
            keywords: &[
                "даст",
                "дастҳои қат кардашуда",
                "дуо кардан",
                "имову ишора",
                "лутфан",
                "пурсидан",
                "ташаккур",
                "хам шудан",
                "қат кардашуда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("พนมม\u{e37}อ"),
            keywords: &[
                "ขอบค\u{e38}ณ",
                "พนมม\u{e37}อ",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
                "เคารพ",
                "ไหว\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("birleşen eller"),
            keywords: &[
                "birleşen eller",
                "dileg",
                "el",
                "haýyş",
                "sag boluň",
                "soramak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo nima tataʻo"),
            keywords: &["ongo nima tataʻo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("birleşen eller"),
            keywords: &["birleşen eller", "dua", "dua etme", "el", "hareket"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوۋۇشقان قول"),
            keywords: &[
                "ئىشارە",
                "ئېگىش",
                "ئېگىلىش",
                "دۇئا",
                "رەھمەت",
                "سوراش",
                "قول",
                "قوۋۇشقان قول",
                "مەرھەمەت",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("руки, стиснуті разом"),
            keywords: &[
                "будь ласка",
                "дякую",
                "прошу",
                "рука",
                "руки, стиснуті разом",
                "складені",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بندھے ہاتھ"),
            keywords: &["اشارہ", "بندھے ہاتھ", "دعا", "شکریہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qovushtirilgan qo‘llar"),
            keywords: &[
                "ibodat",
                "iltimos",
                "juftlangan qoʻllar",
                "minnatdorlik",
                "qovushtirilgan qo‘llar",
                "qoʻl",
                "soʻrash",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chắp tay"),
            keywords: &["chắp tay", "cảm ơn", "cầu nguyện", "hỏi", "làm ơn", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("lem ay loxo"),
            keywords: &[
                "ark",
                "buñ lem",
                "jaamu",
                "jërëjëf",
                "laaj",
                "lem ay loxo",
                "liyaar",
                "loxo",
                "ngir yàlla",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("izandla ezisongiweyo"),
            keywords: &[
                "buza",
                "enkosi",
                "esongiweyo",
                "goba",
                "isandla",
                "izandla ezisongiweyo",
                "jekula",
                "nceda",
                "thandaza",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ika Awọn Ọwọ"),
            keywords: &[
                "Ika Awọn Ọwọ",
                "adúpé",
                "bèrè",
                "fọwọ\u{301}júwè",
                "gbèdúrà",
                "jọ\u{300}wọ\u{301}",
                "kákò",
                "tẹríba",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("合手"),
            keywords: &["合手", "問", "多謝", "手", "祈禱"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("合手"),
            keywords: &["合手", "多谢", "手", "手势", "祈祷", "请", "问", "鞠躬"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双手合十"),
            keywords: &["双手合十", "拜托", "祈求", "祈祷", "祝福"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("感恩"),
            keywords: &["感恩", "雙手合一"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izandla ezigoqiwe"),
            keywords: &[
                "cela",
                "goqa",
                "isandla",
                "izandla ezigoqiwe",
                "thoba",
                "ukubonga",
                "ukuncenga",
                "ukuthandaza",
                "umzimba",
                "uphawu",
            ],
        },
    ],
};
#[doc = "🙏🏻"]
pub const FOLDED_HANDS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙏🏻",
    codepoint: "1F64F 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "folded hands: light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙏🏼"]
pub const FOLDED_HANDS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙏🏼",
    codepoint: "1F64F 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "folded hands: medium-light skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙏🏽"]
pub const FOLDED_HANDS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙏🏽",
    codepoint: "1F64F 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "folded hands: medium skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙏🏾"]
pub const FOLDED_HANDS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙏🏾",
    codepoint: "1F64F 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "folded hands: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🙏🏿"]
pub const FOLDED_HANDS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🙏🏿",
    codepoint: "1F64F 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "folded hands: dark skin tone",
    group: "People & Body",
    subgroup: "hands",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
