#[doc = "👈"]
pub const BACKHAND_INDEX_POINTING_LEFT: crate::Emoji = crate::Emoji {
    glyph: "👈",
    codepoint: "1F448",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "backhand index pointing left",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wysvingerrughand wat links wys"),
            keywords: &[
                "hand",
                "liggaam",
                "rughand",
                "vinger",
                "wys",
                "wysvinger",
                "wysvingerrughand wat links wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የግራ አይበሉባ እጅ የተቀሰረ አመልካች ጣት"),
            keywords: &[
                "ነጥብ",
                "እጅ",
                "ወደ ኋላ መገልበጥ",
                "የግራ አይበሉባ እጅ የተቀሰረ አመልካች ጣት",
                "ጣት",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إصبع لليسار"),
            keywords: &["إصبع", "إصبع لليسار", "السبابة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী আঙ\u{9c1}লি ব\u{9be}ও\u{981}ফ\u{9be}লে নিৰ\u{9cd}দেশ কৰ\u{9be}",
            ),
            keywords: &[
                "আঙ\u{9c1}লি",
                "তৰ\u{9cd}জনী",
                "নিৰ\u{9cd}দেশ",
                "ব\u{9be}ও\u{981}হ\u{9be}ত",
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী আঙ\u{9c1}লি ব\u{9be}ও\u{981}ফ\u{9be}লে নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("solu göstərən sol əlin işarə barmağı"),
            keywords: &[
                "barmaq",
                "göstərmək",
                "işarə",
                "sol əl",
                "solu göstərən sol əlin işarə barmağı",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рука з указальным пальцам улева"),
            keywords: &[
                "налева",
                "палец",
                "рука",
                "рука з указальным пальцам улева",
                "указальны палец улева",
                "цела",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("показалец, сочещ наляво"),
            keywords: &[
                "Показалец наляво откъм опакото на ръката",
                "показалец",
                "показалец, сочещ наляво",
                "пръст",
                "соча",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ব\u{9be}মে ইশ\u{9be}র\u{9be} কর\u{9be} উল\u{9cd}টো হ\u{9be}তের তর\u{9cd}জনী",
            ),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "ব\u{9be}মে ইশ\u{9be}র\u{9be} কর\u{9be} উল\u{9cd}টো হ\u{9be}তের তর\u{9cd}জনী",
                "ব\u{9cd}য\u{9be}কহ\u{9cd}য\u{9be}ন\u{9cd}ড",
                "স\u{9c2}চক",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pokazivanje kažiprstom ulijevo"),
            keywords: &[
                "kažiprst",
                "lijevo",
                "nadlanica",
                "pokazivanje",
                "pokazivanje kažiprstom ulijevo",
                "prst",
                "ruka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dit índex que apunta cap a l’esquerra"),
            keywords: &["dit índex que apunta cap a l’esquerra", "esquerra", "índex"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᎠᏎᎯ ᎠᎦᏍᎦᏂ"),
            keywords: &[
                "ᎠᏎᎯ",
                "ᎣᏂᏗᏜᎪᏯᏗ",
                "ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᎠᏎᎯ ᎠᎦᏍᎦᏂ",
                "ᎤᏬᏱ",
                "ᎦᏰᏌᏛ",
                "ᏩᏎᏢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruka s prstem ukazujícím vlevo"),
            keywords: &[
                "hřbet ruky",
                "prst",
                "ruka",
                "ruka s prstem ukazujícím vlevo",
                "tělo",
                "ukazovat",
                "ukazováček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynegfys yr wrthlaw yn pwyntio i’r chwith"),
            keywords: &[
                "bys",
                "corff",
                "gwrthlaw",
                "llaw",
                "mynegfys yr wrthlaw yn pwyntio i’r chwith",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("peger mod venstre"),
            keywords: &[
                "finger",
                "finger peger til venstre",
                "pegefinger",
                "peger mod venstre",
                "peger til venstre",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("nach links weisender Zeigefinger"),
            keywords: &[
                "Finger",
                "Handrückseite",
                "links",
                "nach links weisender Zeigefinger",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δείκτης χεριού προς τα αριστερά"),
            keywords: &[
                "δάχτυλο",
                "δείκτης",
                "δείκτης χεριού προς τα αριστερά",
                "δείχνω",
                "σώμα",
                "χέρι",
                "χτύπημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("backhand index pointing left"),
            keywords: &[
                "backhand",
                "backhand index pointing left",
                "finger",
                "hand",
                "index",
                "point",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dorso de mano con índice a la izquierda"),
            keywords: &[
                "dedo",
                "dorso de mano con índice a la izquierda",
                "izquierda",
                "mano",
                "índice",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "apuntar",
                "dedo",
                "dorso",
                "dorso de mano con índice a la izquierda",
                "izquierda",
                "mano",
                "señalar",
                "índice",
                "índice hacia la izquierda",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mano apuntando índice a la izquierda"),
            keywords: &[
                "apuntar",
                "dedo",
                "dorso",
                "mano apuntando índice a la izquierda",
                "mano con dedo índice hacia la izquierda",
                "índice",
                "índice hacia la izquierda",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "apuntar",
                "dedo",
                "dorso de mano con índice a la izquierda",
                "izquierda",
                "señalar",
                "índice",
                "índice hacia la izquierda",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vasakule osutav sõrm"),
            keywords: &[
                "keha",
                "käsi",
                "nimetissõrm",
                "osutamine",
                "sõrm",
                "vasakule osutav sõrm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ezkerrera seinalatzen ari den hatz erakuslea"),
            keywords: &[
                "erakusle",
                "esku",
                "ezkerrera seinalatzen ari den hatz erakuslea",
                "hatz",
                "seinalatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اشاره به چپ"),
            keywords: &["اشاره", "اشاره به چپ", "انگشت", "بدن", "دست", "پشت دست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vasemmalle osoittava etusormi kämmenselkä katsojaan päin"),
            keywords: &[
                "etusormi",
                "kämmenselkä",
                "käsi",
                "osoittaa",
                "sormi",
                "vartalo",
                "vasemmalle osoittava etusormi kämmenselkä katsojaan päin",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("backhand ng hintuturo na nakaturo sa kaliwa"),
            keywords: &[
                "backhand",
                "backhand ng hintuturo na nakaturo sa kaliwa",
                "daliri",
                "hintuturo",
                "index finger",
                "kamay",
                "nakaturo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fremstifingur peikar til vinstru"),
            keywords: &[
                "fingur",
                "fremstifingur",
                "fremstifingur peikar til vinstru",
                "hond",
                "peikifingur",
                "vinstru",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main avec index pointant à gauche"),
            keywords: &[
                "doigt",
                "gauche",
                "index",
                "main",
                "main avec index pointant à gauche",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "dos de la main avec index pointant vers la gauche",
                "gauche",
                "index",
                "main",
                "main avec index pointant à gauche",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cúl corrmhéire ag díriú ar chlé"),
            keywords: &[
                "corrmhéar",
                "cúl cormhéar ag pointeáil ar chlé",
                "cúl corrmhéire ag díriú ar chlé",
                "lámh",
                "méar",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("druim na làimhe, colgag a’ tomhadh clì"),
            keywords: &[
                "colgag",
                "corrag",
                "druim na làimhe",
                "druim na làimhe, colgag a’ tomhadh clì",
                "làmh",
                "meur",
                "tomhadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("índice apuntando á esquerda"),
            keywords: &[
                "dedo",
                "esquerda",
                "man",
                "índice",
                "índice apuntando á esquerda",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબી બાજ\u{ac1} ચી\u{a82}ધતી આ\u{a82}ગળી"),
            keywords: &[
                "આ\u{a82}ગળી",
                "ડાબી આ\u{a82}ગળી",
                "ડાબી બાજ\u{ac1} ચી\u{a82}ધતી આ\u{a82}ગળી",
                "પહ\u{ac7}લી આ\u{a82}ગળી",
                "હાથનો પાછલો ભાગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan ali na baya mai nunawa hagu"),
            keywords: &[
                "bayan hannu",
                "hannu",
                "nuna",
                "yatsa",
                "ɗan ali",
                "ɗan ali na baya mai nunawa hagu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גב יד מצביעה שמאלה"),
            keywords: &[
                "אצבע",
                "גב יד מצביעה שמאלה",
                "יד",
                "להצביע",
                "מצביעה",
                "שמאלה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाई\u{902} ओर इशारा करती तर\u{94d}जनी"),
            keywords: &[
                "अ\u{902}ग\u{941}लि",
                "तर\u{94d}जनी अ\u{902}ग\u{941}लि",
                "पीछ\u{947} का हाथ",
                "बाई\u{902} ओर इशारा करती तर\u{94d}जनी",
                "बाए\u{902} अ\u{902}ग\u{941}लि",
                "बाए\u{902} इशारा करती ऊ\u{902}गली",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kažiprst koji pokazuje ulijevo"),
            keywords: &[
                "kažiprst",
                "kažiprst koji pokazuje ulijevo",
                "pokazivanje",
                "prst",
                "šaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kéz balra mutató ujjal"),
            keywords: &[
                "kéz",
                "kéz balra mutató ujjal",
                "mutatóujj",
                "tenyér",
                "test",
                "ujj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեպի ձախ ուղղված ցուցամատ"),
            keywords: &[
                "դեպի ձախ ուղղված ցուցամատ",
                "ձեռք",
                "մատ",
                "մարմին",
                "ուղղված",
                "ցուցամատ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("menunjuk ke arah kiri"),
            keywords: &[
                "badan",
                "jari",
                "kiri",
                "menunjuk ke arah kiri",
                "tangan",
                "telunjuk",
                "tubuh",
                "tunjuk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àzụaka na-arụ aka akaèkpè"),
            keywords: &[
                "backhand",
                "finger",
                "hand",
                "index",
                "point",
                "àzụaka na-arụ aka akaèkpè",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fingur bendir til vinstri"),
            keywords: &[
                "benda",
                "benda til vinstri",
                "fingur",
                "fingur bendir til vinstri",
                "hönd",
                "vísifingur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("indice verso sinistra"),
            keywords: &[
                "dito",
                "dito indice",
                "dito verso sinistra",
                "indice verso sinistra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左指差し"),
            keywords: &["左", "左指差し", "手", "指差し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("geger tangan nuding ngiwa"),
            keywords: &[
                "driji",
                "driji panuduh",
                "geger tangan",
                "geger tangan nuding ngiwa",
                "nuding",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელის ზურგიდან მარხცნივ გაშვერილი საჩვენებელი თითი"),
            keywords: &[
                "თითი",
                "მითითება",
                "საჩვენებელი",
                "სხეული",
                "ტანი",
                "ხელი",
                "ხელის ზურგიდან მარხცნივ გაშვერილი საჩვენებელი თითი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол жаққа саусақпен қолды сыртқа қаратып көрсету"),
            keywords: &[
                "артқа",
                "индекс",
                "көрсету",
                "саусақ",
                "сол жаққа саусақпен қолды сыртқа қаратып көрсету",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("venstre"),
            keywords: &[
                "finger",
                "finger peger til venstre",
                "pegefinger",
                "peger til venstre",
                "venstre",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}អ\u{17bb}លទៅឆ\u{17d2}វេង"),
            keywords: &[
                "ចង\u{17d2}អ\u{17bb}ល",
                "ចង\u{17d2}អ\u{17bb}លទៅឆ\u{17d2}វេង",
                "ឆ\u{17d2}វេង",
                "ដៃចង\u{17d2}អ\u{17bb}ល",
                "ប\u{17d2}រអប\u{17cb}ដៃ",
                "ម\u{17d2}រាមដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಹ\u{cbf}ಮ\u{ccd}ಮುಖ ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ ಎಡಕ\u{ccd}ಕ\u{cc6} ಸ\u{cc2}ಚ\u{cbf}ಸುತ\u{ccd}ತದ\u{cc6}",
            ),
            keywords: &[
                "ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು",
                "ತೋರ\u{ccd}ಬ\u{cc6}ರಳು",
                "ಹ\u{cbf}ಮ\u{ccd}ಮುಖ ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ ಎಡಕ\u{ccd}ಕ\u{cc6} ಸ\u{cc2}ಚ\u{cbf}ಸುತ\u{ccd}ತದ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽을 가리키는 손등"),
            keywords: &[
                "검지손가락",
                "손가락 왼쪽으로",
                "손가락으로 왼쪽 가리키기",
                "왼쪽",
                "왼쪽을 가리키는 검지손가락",
                "왼쪽을 가리키는 손등",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तर\u{94d}जनी दाव\u{94d}यान दाखोवपी हाताची फाट"),
            keywords: &[
                "तर\u{94d}जनी",
                "तर\u{94d}जनी दाव\u{94d}यान दाखोवपी हाताची फाट",
                "दाखोवप",
                "बोट",
                "हात",
                "हाताची फाट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сол тарапты көрсөткөн сөөмөй"),
            keywords: &[
                "кол",
                "көрсөт",
                "манжа",
                "сол тарапты көрсөткөн сөөмөй",
                "сөөмөй",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no lénks weisende Fanger vun hanne gesinn"),
            keywords: &[
                "Fanger",
                "Hand",
                "Réckhand",
                "Zeigefanger",
                "no lénks weisende Fanger vun hanne gesinn",
                "weisen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb4}\u{ec9}ວຊ\u{eb5}\u{ec9}ໄປຊ\u{ec9}າຍ"),
            keywords: &[
                "ຊ\u{eb5}\u{ec9}",
                "ຊ\u{ec9}າຍ",
                "ນ\u{eb4}\u{ec9}ວ",
                "ນ\u{eb4}\u{ec9}ວຊ\u{eb5}\u{ec9}ໄປຊ\u{ec9}າຍ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("į kairę pirštu rodanti ranka"),
            keywords: &[
                "indeksas",
                "pirštas",
                "ranka",
                "rodyti",
                "į kairę pirštu rodanti ranka",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa kreisi vērsts rādītājpirksts"),
            keywords: &[
                "delna",
                "pa kreisi vērsts rādītājpirksts",
                "pirksts",
                "roka",
                "rādīt",
                "rādītājpirksts",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōroa tāmuri tohu mauī"),
            keywords: &[
                "kōroa",
                "kōroa tāmuri tohu mauī",
                "matimati",
                "ringa",
                "tohu",
                "tāmuri",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("показалец свртен налево"),
            keywords: &[
                "лево",
                "покажува",
                "показалец",
                "показалец свртен налево",
                "прст",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
            ),
            keywords: &[
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
                "ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}",
                "കൈ",
                "ച\u{d42}ണ\u{d4d}ട\u{d41}ക",
                "പ\u{d41}റംകൈ",
                "പോയന\u{d4d}റ\u{d41}ചെയ\u{d4d}യ\u{d41}ക",
                "വിരൽ",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн зүг зааж байгаа"),
            keywords: &[
                "гар",
                "гарын ар тал",
                "долоовор хуруугаараа зүүн тийш зааж буй гар",
                "зүүн зүг зааж байгаа",
                "хуруу",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी डावीकड\u{947} दर\u{94d}शविण\u{947}",
            ),
            keywords: &[
                "तर\u{94d}जनी",
                "दर\u{94d}शविण\u{947}",
                "बोट",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947}",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी डावीकड\u{947} दर\u{94d}शविण\u{947}",
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी डावीकड\u{947} दर\u{94d}शविण\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari telunjuk tunjuk kiri"),
            keywords: &["jari telunjuk tunjuk kiri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("indiċi b’lura iipponta lejn ix-xellug"),
            keywords: &[
                "b’lura",
                "idejn",
                "indiċi",
                "indiċi b’lura iipponta lejn ix-xellug",
                "punt",
                "suba’",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ဘယ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ),
            keywords: &[
                "ဘယ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
                "ဘယ\u{103a}သ\u{102d}\u{102f}\u{1037} လက\u{103a}ပြန\u{103a} လက\u{103a}ည\u{103e}\u{102d}\u{102f}းည\u{103d}\u{103e}န\u{103a}ခြင\u{103a}း",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ည\u{103e}\u{102d}\u{102f}း",
                "လက\u{103a}ည\u{103e}\u{102d}\u{102f}းည\u{103d}\u{103e}န\u{103a}ခြင\u{103a}း",
                "လက\u{103a}ပြန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("peker mot venstre – bakhånd"),
            keywords: &[
                "finger",
                "hånd",
                "pekende finger",
                "peker mot venstre – bakhånd",
                "peker venstre",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाया\u{901}तिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला"),
            keywords: &[
                "औ\u{902}ला",
                "पछाडिको हात",
                "बाया\u{901}तिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला",
                "विन\u{94d}द\u{941}",
                "स\u{942}चक",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achterkant van hand met naar links wijzende wijsvinger"),
            keywords: &[
                "achterkant van hand met naar links wijzende wijsvinger",
                "hand",
                "lichaam",
                "vinger",
                "vinger wijst naar links",
                "wijsvinger",
                "wijzen",
                "wijzend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("peikar mot venstre – bakhand"),
            keywords: &[
                "finger",
                "hand",
                "peikande finger",
                "peikar mot venstre – bakhand",
                "peikar venstre",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b3e}ମକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ବ\u{b3e}ମ ତର\u{b4d}ଜନୀର ପଛ ପଟ",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ତର\u{b4d}ଜନୀ",
                "ବ\u{b3e}ମକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ବ\u{b3e}ମ ତର\u{b4d}ଜନୀର ପଛ ପଟ",
                "ବ\u{b3e}ମକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ବ\u{b3e}ମ ତର\u{b4d}ଜନୀର ପଛପଟ",
                "ସ\u{b42}ଚ\u{b3f}ତ କର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତର ପଛ ପଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}ਬ\u{a47} ਪਾਸ\u{a47} ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲ"),
            keywords: &[
                "ਇ\u{a70}ਡ\u{a48}ਕਸ ਉ\u{a02}ਗਲ",
                "ਉ\u{a02}ਗਲ",
                "ਖ\u{a71}ਬੀ ਉ\u{a02}ਗਲ",
                "ਖ\u{a71}ਬ\u{a47} ਇਸ\u{a3c}ਾਰਾ ਉ\u{a02}ਗਲ",
                "ਖ\u{a71}ਬ\u{a47} ਪਾਸ\u{a47} ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲ",
                "ਹ\u{a71}ਥ ਪਿਛਲਾ ਪਾਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ دے مخالف پاسیوں شہادت دی انگلی نال اوتے کھبے اشارہ کردیاں ہوئیاں"),
            keywords: &[
                "اشارہ کرنا",
                "ا\u{64f}نگل",
                "بیک ہینڈ",
                "ضمینہ",
                "ہتھ",
                "ہتھ دے مخالف پاسیوں شہادت دی انگلی نال اوتے کھبے اشارہ کردیاں ہوئیاں",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Lẹft"),
            keywords: &[
                "Bakhand",
                "Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Lẹft",
                "Fínga",
                "Hand",
                "Lẹft",
                "Niá-Tọ\u{301}mb-Fínga",
                "Pọint",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("palec w lewo"),
            keywords: &[
                "lewa strona",
                "palec",
                "palec w lewo",
                "w lewo",
                "wskazujący",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په چپ لاس په شهادت ګوته اشاره کول"),
            keywords: &[
                "اشاره",
                "د لاس شا",
                "شهادت ګوته",
                "لاس",
                "په چپ لاس په شهادت ګوته اشاره کول",
                "ګوته",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dorso da mão com dedo indicador apontando para a esquerda"),
            keywords: &[
                "costas da mão",
                "dedo",
                "dedo apontado para esquerda",
                "dedo indicador",
                "dorso da mão com dedo indicador apontando para a esquerda",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("costas da mão com dedo indicador a apontar para a esquerda"),
            keywords: &[
                "apontar",
                "costas da mão",
                "costas da mão com dedo indicador a apontar para a esquerda",
                "dedo",
                "indicador",
                "mão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼupsi rukʼanawan lluqʼiman chimpuy"),
            keywords: &[
                "chimpuy",
                "indice",
                "jinchʼa",
                "maki",
                "rukana",
                "tʼupsi rukʼanawan lluqʼiman chimpuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dos de mână cu arătătorul spre stânga"),
            keywords: &[
                "arătător",
                "deget",
                "dos de mână cu arătătorul spre stânga",
                "dosul palmei",
                "mână",
                "stânga",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-517"),
            keywords: &["E10-517"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("указывающий налево палец"),
            keywords: &[
                "влево",
                "налево",
                "палец",
                "указательный",
                "указывающий налево палец",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urutoki rutunze ibumoso"),
            keywords: &[
                "gutunga",
                "ikiganza",
                "mukubitarukoko",
                "umugongo w’ikiganza",
                "urutoki",
                "urutoki rutunze ibumoso",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي هٿ جي آڱر کاٻي طرف اشارو ڪندي"),
            keywords: &[
                "آڱر",
                "اشارو ڪرڻ",
                "شهادت واري آڱر",
                "هٿ",
                "کاٻو هٿ",
                "کاٻي هٿ جي آڱر کاٻي طرف اشارو ڪندي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වමට යොම\u{dd4} ව\u{dd6} අත ප\u{dd2}ට\u{dd4}පස දබරැඟ\u{dd2}ල\u{dca}ල"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "ප\u{dd2}ට\u{dd2} අත\u{dca} පහර",
                "ලක\u{dca}ෂ\u{dca}\u{200d}ය",
                "වමට යොම\u{dd4} ව\u{dd6} අත ප\u{dd2}ට\u{dd4}පස දබරැඟ\u{dd2}ල\u{dca}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ukazovák doľava"),
            keywords: &["doľava", "prst", "ruka", "ukazovať", "ukazovák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hrbtna stran dlani s kazalcem, ki kaže levo"),
            keywords: &[
                "dlan",
                "hrbtna stran",
                "hrbtna stran dlani s kazalcem, ki kaže levo",
                "kazalec",
                "kazati",
                "prst",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("Gacan tilmaamaysa bidix"),
            keywords: &[
                "Gacan tilmaamaysa bidix",
                "bidix",
                "far",
                "farta muujinta gacanta gadaale tilmaamaysa bidix",
                "gacan",
                "gacanta gadaal",
                "muujin",
                "tilmaam",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gishti tregues që tregon majtas"),
            keywords: &[
                "dorë",
                "gisht",
                "gishti tregues që tregon majtas",
                "kurrizi i dorës",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кажипрст који показује улево"),
            keywords: &[
                "кaжипрст",
                "кажипрст који показује улево",
                "пoкaзивaњe",
                "прст",
                "рукa",
                "улево",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("кажипрст који показује улијево"),
            keywords: &["кажипрст који показује улијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kažiprst koji pokazuje ulevo"),
            keywords: &[
                "kažiprst",
                "kažiprst koji pokazuje ulevo",
                "pokazivanje",
                "prst",
                "ruka",
                "ulevo",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("kažiprst koji pokazuje ulijevo"),
            keywords: &["kažiprst koji pokazuje ulijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vänsterpekande finger"),
            keywords: &["peka åt vänster", "pekfinger", "vänsterpekande finger"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidole cha shahada kinachoelekeza kushoto"),
            keywords: &[
                "cha shahada",
                "elekeza",
                "kidole",
                "kidole cha shahada kinachoelekeza kushoto",
                "mkono",
                "nyuma ya mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடது நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}"),
            keywords: &[
                "ஆள\u{bcd}க\u{bbe}ட\u{bcd}டி விரல\u{bcd}",
                "இடது நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}",
                "இடதுநோக\u{bcd}கிய விரல\u{bcd}",
                "விரல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమ చూపుడు వ\u{c47}లు"),
            keywords: &["ఎడమ", "ఎడమ చూపుడు వ\u{c47}లు", "వ\u{c47}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ангушти ишорат ба тарафи чап ишора карда истода"),
            keywords: &[
                "ангушт",
                "ангушти ишорат ба тарафи чап ишора карда истода",
                "даст",
                "нишондиҳанда",
                "нуқта",
                "пушти даст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e34}\u{e49}วช\u{e35}\u{e49}ทางซ\u{e49}าย"),
            keywords: &[
                "ช\u{e35}\u{e49}",
                "ซ\u{e49}าย",
                "น\u{e34}\u{e49}ว",
                "น\u{e34}\u{e49}วช\u{e35}\u{e49}ทางซ\u{e49}าย",
                "ม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepi görkezýän el-arkasy süýem barmak"),
            keywords: &[
                "barmak",
                "el",
                "eliň arkasy",
                "görkezmek",
                "süýem",
                "çepi görkezýän el-arkasy süýem barmak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuhu tuʻanima tonu ki hema"),
            keywords: &["tuhu tuʻanima tonu ki hema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elinin tersiyle solu gösteren işaret parmağı"),
            keywords: &[
                "elin arkası",
                "elinin tersiyle solu gösteren işaret parmağı",
                "işaret parmağı",
                "parmak",
                "solu gösteren parmak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارقىچە سولنى كۆرسەتكەن كۆرسەتكۈچ بارماق"),
            keywords: &[
                "ئارقىچە سولنى كۆرسەتكەن كۆرسەتكۈچ بارماق",
                "بارماق",
                "قول",
                "قولنىڭ ئارقىسى",
                "كۆرسىتىش",
                "كۆرسەتكۈچ بارماق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палець тильним боком, що вказує вліво"),
            keywords: &[
                "вказівний палець тильною стороною, що вказує вліво",
                "палець",
                "палець тильним боком, що вказує вліво",
                "показувати",
                "рука",
                "тіло",
                "указувати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بائیں اشارہ کرتی بیک ہینڈ شہادت کی انگلی"),
            keywords: &[
                "انگلی",
                "بائیں",
                "بائیں اشارہ کرتی بیک ہینڈ شہادت کی انگلی",
                "جسم",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘rsatkich barmoq chapga"),
            keywords: &[
                "barmoq",
                "ko‘rsatkich",
                "ko‘rsatkich barmog‘i orqa tomoni bilan chapga qarab turgan qo‘l",
                "ko‘rsatkich barmoq chapga",
                "qo‘l",
                "qo‘l orqa tomoni",
                "yo‘naltirish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón trỏ trái chỉ sang trái"),
            keywords: &[
                "chỉ",
                "mu bàn tay",
                "ngón tay",
                "ngón trỏ",
                "ngón trỏ trái chỉ sang trái",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ginaaw loxo buy joxoñ càmmoñ"),
            keywords: &[
                "baaraam",
                "baaraamu joxoñ",
                "ginaaw loxo buy joxoñ càmmoñ",
                "ginaawu loxo",
                "joxoñ",
                "loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isalathiso somva wesandla esalatha ekhohlo"),
            keywords: &[
                "isalathiso",
                "isalathiso somva wesandla esalatha ekhohlo",
                "isandla",
                "umnwe",
                "umva wesandla",
                "yalatha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyin Ọwọ Ti O Tọka Si Apa Osi"),
            keywords: &[
                "ìka",
                "ìka kékeré",
                "Ẹyin Ọwọ Ti O Tọka Si Apa Osi",
                "ẹ\u{300}yìn ọwọ\u{301}",
                "ọwọ\u{301}",
                "ọ\u{300}gángán",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("反手指向左邊"),
            keywords: &["反手", "反手指向左邊", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("反手指向左边"),
            keywords: &["反手", "反手指向左边", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("反手食指向左指"),
            keywords: &["反手", "反手食指向左指", "向左指", "手", "指左", "食指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("左"),
            keywords: &["左", "手", "指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukukhomba ngengemuva lesandla sokunxele ngomunwe wokukhomba"),
            keywords: &[
                "isandla",
                "ukukhomba",
                "ukukhomba ngengemuva lesandla sokunxele ngomunwe wokukhomba",
                "umunwe",
                "umunwe wokukhomba",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👈🏻"]
pub const BACKHAND_INDEX_POINTING_LEFT_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👈🏻",
    codepoint: "1F448 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing left: light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👈🏼"]
pub const BACKHAND_INDEX_POINTING_LEFT_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👈🏼",
    codepoint: "1F448 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing left: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👈🏽"]
pub const BACKHAND_INDEX_POINTING_LEFT_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👈🏽",
    codepoint: "1F448 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing left: medium skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👈🏾"]
pub const BACKHAND_INDEX_POINTING_LEFT_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👈🏾",
    codepoint: "1F448 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing left: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👈🏿"]
pub const BACKHAND_INDEX_POINTING_LEFT_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👈🏿",
    codepoint: "1F448 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing left: dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👉"]
pub const BACKHAND_INDEX_POINTING_RIGHT: crate::Emoji = crate::Emoji {
    glyph: "👉",
    codepoint: "1F449",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "backhand index pointing right",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wysvingerrughand wat regs wys"),
            keywords: &[
                "hand",
                "liggaam",
                "rughand",
                "vinger",
                "wys",
                "wysvinger",
                "wysvingerrughand wat regs wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቀኝ አይበሉባ እጅ የተቀሰረ አመልካች ጣት"),
            keywords: &[
                "ነጥብ",
                "እጅ",
                "ወደ ኋላ መገልበጥ",
                "የቀኝ አይበሉባ እጅ የተቀሰረ አመልካች ጣት",
                "ጣት",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إصبع لليمين"),
            keywords: &["إصبع", "إصبع لليمين", "السبابة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী আঙ\u{9c1}লি সো\u{981}ফ\u{9be}লে নিৰ\u{9cd}দেশ কৰ\u{9be}",
            ),
            keywords: &[
                "আঙ\u{9c1}লি",
                "তৰ\u{9cd}জনী",
                "নিৰ\u{9cd}দেশ",
                "ব\u{9be}ও\u{981}হ\u{9be}ত",
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী আঙ\u{9c1}লি সো\u{981}ফ\u{9be}লে নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sağı göstərən sol əlin işarə barmağı"),
            keywords: &[
                "barmaq",
                "göstərmək",
                "işarə",
                "sağı göstərən sol əlin işarə barmağı",
                "sol əl",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рука з указальным пальцам управа"),
            keywords: &[
                "направа",
                "палец",
                "рука",
                "рука з указальным пальцам управа",
                "указальны палец управа",
                "цела",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("показалец, сочещ надясно"),
            keywords: &[
                "Показалец надясно откъм опакото на ръката",
                "показалец",
                "показалец, сочещ надясно",
                "пръст",
                "соча",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "ড\u{9be}নে ইশ\u{9be}র\u{9be} কর\u{9be} উল\u{9cd}টো হ\u{9be}তের তর\u{9cd}জনী",
            ),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "ড\u{9be}নে ইশ\u{9be}র\u{9be} কর\u{9be} উল\u{9cd}টো হ\u{9be}তের তর\u{9cd}জনী",
                "পয\u{9bc}েন\u{9cd}ট",
                "ব\u{9cd}য\u{9be}কহ\u{9cd}য\u{9be}ন\u{9cd}ড",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pokazivanje kažiprstom udesno"),
            keywords: &[
                "desno",
                "kažiprst",
                "nadlanica",
                "pokazivanje",
                "pokazivanje kažiprstom udesno",
                "prst",
                "ruka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dit índex que apunta cap a la dreta"),
            keywords: &["dit índex que apunta cap a la dreta", "dreta", "índex"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᎠᏎᎯ ᎠᎦᏘᏏ"),
            keywords: &[
                "ᎠᏎᎯ",
                "ᎣᏂᏗᏜᎪᏯᏗ",
                "ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᎠᏎᎯ ᎠᎦᏘᏏ",
                "ᎤᏬᏱ",
                "ᎦᏰᏌᏛ",
                "ᏩᏎᏢ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruka s prstem ukazujícím vpravo"),
            keywords: &[
                "hřbet ruky",
                "prst",
                "ruka",
                "ruka s prstem ukazujícím vpravo",
                "tělo",
                "ukazovat",
                "ukazováček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynegfys yr wrthlaw yn pwyntio i’r dde"),
            keywords: &[
                "bys",
                "corff",
                "gwrthlaw",
                "llaw",
                "mynegfys yr wrthlaw yn pwyntio i’r dde",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("peger mod højre"),
            keywords: &[
                "finger",
                "finger peger til højre",
                "pegefinger",
                "peger mod højre",
                "peger til højre",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("nach rechts weisender Zeigefinger"),
            keywords: &[
                "Finger",
                "Handrückseite",
                "nach rechts weisender Zeigefinger",
                "rechts",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δείκτης χεριού προς τα δεξιά"),
            keywords: &[
                "δάχτυλο",
                "δείκτης",
                "δείκτης χεριού προς τα δεξιά",
                "δείχνω",
                "σώμα",
                "χέρι",
                "χτύπημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("backhand index pointing right"),
            keywords: &[
                "backhand",
                "backhand index pointing right",
                "finger",
                "hand",
                "index",
                "point",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dorso de mano con índice a la derecha"),
            keywords: &[
                "dedo",
                "derecha",
                "dorso de mano con índice a la derecha",
                "mano",
                "índice",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mano apuntando índice a la derecha"),
            keywords: &[
                "apuntar",
                "dedo",
                "dorso",
                "mano apuntando índice a la derecha",
                "mano con dedo índice hacia la derecha",
                "índice",
                "índice hacia la derecha",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paremale osutav sõrm"),
            keywords: &[
                "keha",
                "käsi",
                "nimetissõrm",
                "osutamine",
                "paremale osutav sõrm",
                "sõrm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("eskuinera seinalatzen ari den hatz erakuslea"),
            keywords: &[
                "erakusle",
                "esku",
                "eskuinera seinalatzen ari den hatz erakuslea",
                "hatz",
                "seinalatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اشاره به راست"),
            keywords: &["اشاره", "اشاره به راست", "انگشت", "بدن", "دست", "پشت دست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("oikealle osoittava etusormi kämmenselkä katsojaan päin"),
            keywords: &[
                "etusormi",
                "kämmenselkä",
                "käsi",
                "oikealle osoittava etusormi kämmenselkä katsojaan päin",
                "osoittaa",
                "sormi",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("backhand ng hintuturo na nakaturo sa kanan"),
            keywords: &[
                "backhand ng hintuturo na nakaturo sa kanan",
                "daliri",
                "hintuturo",
                "kamay",
                "nakaturo",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fremstifingur peikar til høgru"),
            keywords: &[
                "fingur",
                "fremstifingur",
                "fremstifingur peikar til høgru",
                "hond",
                "høgru",
                "peikifingur",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main avec index pointant à droite"),
            keywords: &[
                "doigt",
                "droite",
                "index",
                "main",
                "main avec index pointant à droite",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "dos de la main avec index pointant vers la droite",
                "droite",
                "index",
                "main",
                "main avec index pointant à droite",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cúl corrmhéire ag díriú ar dheis"),
            keywords: &[
                "corrmhéar",
                "cúl cormhéar ag pointeáil ar dheis",
                "cúl corrmhéire ag díriú ar dheis",
                "lámh",
                "méar",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("druim na làimhe, colgag a’ tomhadh deas"),
            keywords: &[
                "colgag",
                "corrag",
                "druim na làimhe",
                "druim na làimhe, colgag a’ tomhadh deas",
                "làmh",
                "meur",
                "tomhadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("índice apuntando á dereita"),
            keywords: &[
                "dedo",
                "dereita",
                "man",
                "índice",
                "índice apuntando á dereita",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમણી બાજ\u{ac1} ચી\u{a82}ધતી આ\u{a82}ગળી"),
            keywords: &[
                "આ\u{a82}ગળી",
                "જમણી આ\u{a82}ગળી",
                "જમણી બાજ\u{ac1} ચી\u{a82}ધતી આ\u{a82}ગળી",
                "પહ\u{ac7}લી આ\u{a82}ગળી",
                "હાથનો પાછલો ભાગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan ali na baya mai nunawa dama"),
            keywords: &[
                "bayan hannu",
                "hannu",
                "nuna",
                "yatsa",
                "ɗan ali",
                "ɗan ali na baya mai nunawa dama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גב יד מצביעה ימינה"),
            keywords: &[
                "אצבע",
                "גב יד מצביעה ימינה",
                "יד",
                "ימינה",
                "להצביע",
                "מצביעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाई\u{902} ओर इशारा करती तर\u{94d}जनी"),
            keywords: &[
                "अ\u{902}ग\u{941}लि",
                "तर\u{94d}जनी अ\u{902}ग\u{941}लि",
                "दाई\u{902} ओर इशारा करती तर\u{94d}जनी",
                "दाए\u{902} अ\u{902}ग\u{941}लि",
                "दाए\u{902} इशारा करती ऊ\u{902}गली",
                "पीछ\u{947} का हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kažiprst koji pokazuje udesno"),
            keywords: &[
                "kažiprst",
                "kažiprst koji pokazuje udesno",
                "pokazivanje",
                "prst",
                "šaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kéz jobbra mutató ujjal"),
            keywords: &[
                "kéz",
                "kéz jobbra mutató ujjal",
                "mutatóujj",
                "tenyér",
                "test",
                "ujj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեպի աջ ուղղված ցուցամատ"),
            keywords: &[
                "դեպի աջ ուղղված ցուցամատ",
                "ձեռք",
                "մատ",
                "մարմին",
                "ուղղված",
                "ցուցամատ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("menunjuk ke arah kanan"),
            keywords: &[
                "badan",
                "jari",
                "kanan",
                "menunjuk ke arah kanan",
                "tangan",
                "telunjuk",
                "tubuh",
                "tunjuk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àzụaka na-arụ aka akanri"),
            keywords: &[
                "backhand",
                "finger",
                "hand",
                "index",
                "point",
                "àzụaka na-arụ aka akanri",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fingur bendir til hægri"),
            keywords: &[
                "benda",
                "benda til hægri",
                "fingur",
                "fingur bendir til hægri",
                "hönd",
                "vísifingur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("indice verso destra"),
            keywords: &[
                "dito",
                "dito indice",
                "dito verso destra",
                "indice verso destra",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右指差し"),
            keywords: &["右", "右指差し", "手", "指差し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("geger tangan nuding nengen"),
            keywords: &[
                "driji",
                "driji panuduh",
                "geger tangan",
                "geger tangan nuding nengen",
                "nuding",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელის ზურგიდან მარჯვნივ გაშვერილი საჩვენებელი თითი"),
            keywords: &[
                "თითი",
                "მითითება",
                "საჩვენებელი",
                "სხეული",
                "ტანი",
                "ხელი",
                "ხელის ზურგი",
                "ხელის ზურგიდან მარჯვნივ გაშვერილი საჩვენებელი თითი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жаққа саусақпен қолды сыртқа қаратып көрсету"),
            keywords: &[
                "артқа",
                "индекс",
                "көрсету",
                "оң жаққа саусақпен қолды сыртқа қаратып көрсету",
                "саусақ",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højre"),
            keywords: &[
                "finger",
                "finger peger til højre",
                "højre",
                "pegefinger",
                "peger til højre",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}អ\u{17bb}លទៅស\u{17d2}តា\u{17c6}"),
            keywords: &[
                "ខ\u{17d2}នងដៃ",
                "ចង\u{17d2}អ\u{17bb}ល",
                "ចង\u{17d2}អ\u{17bb}លទៅស\u{17d2}តា\u{17c6}",
                "ដៃចង\u{17d2}អ\u{17bb}ល",
                "ប\u{17d2}រអប\u{17cb}ដៃ",
                "ម\u{17d2}រាមដៃ",
                "ស\u{17d2}តា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಹ\u{cbf}ಮ\u{ccd}ಮುಖ ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ ಬಲಕ\u{ccd}ಕ\u{cc6} ಸ\u{cc2}ಚ\u{cbf}ಸುತ\u{ccd}ತದ\u{cc6}",
            ),
            keywords: &[
                "ಬಲ ತೋರ\u{ccd}ಬ\u{cc6}ರಳು",
                "ಹ\u{cbf}ಮ\u{ccd}ಮುಖ ಸ\u{cc2}ಚ\u{ccd}ಯಂಕ ಬಲಕ\u{ccd}ಕ\u{cc6} ಸ\u{cc2}ಚ\u{cbf}ಸುತ\u{ccd}ತದ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오른쪽을 가리키는 손등"),
            keywords: &[
                "검지손가락",
                "손가락 오른쪽으로",
                "손가락으로 오른쪽 가리키기",
                "오른쪽",
                "오른쪽을 가리키는 검지손가락",
                "오른쪽을 가리키는 손등",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तर\u{94d}जनी उजव\u{94d}यान दाखोवपी हाताची फाट"),
            keywords: &[
                "तर\u{94d}जनी",
                "तर\u{94d}जनी उजव\u{94d}यान दाखोवपी हाताची फाट",
                "दाखोवप",
                "बोट",
                "हात",
                "हाताची फाट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оң тарапты көрсөткөн сөөмөй"),
            keywords: &[
                "кол",
                "көрсөт",
                "манжа",
                "оң тарапты көрсөткөн сөөмөй",
                "сөөмөй",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no riets weisende Fanger vun hanne gesinn"),
            keywords: &[
                "Fanger",
                "Hand",
                "Réckhand",
                "Zeigefanger",
                "no riets weisende Fanger vun hanne gesinn",
                "weisen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb4}\u{ec9}ວຊ\u{eb5}\u{ec9}ໄປຂວາ"),
            keywords: &[
                "ຂວາ",
                "ຊ\u{eb5}\u{ec9}",
                "ນ\u{eb4}\u{ec9}ວ",
                "ນ\u{eb4}\u{ec9}ວຊ\u{eb5}\u{ec9}ໄປຂວາ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("į dešinę pirštu rodanti ranka"),
            keywords: &[
                "indeksas",
                "pirštas",
                "ranka",
                "rodyti",
                "į dešinę pirštu rodanti ranka",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pa labi vērsts rādītājpirksts"),
            keywords: &[
                "delna",
                "pa labi vērsts rādītājpirksts",
                "pirksts",
                "roka",
                "rādīt",
                "rādītājpirksts",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōroa tāmuri tohu matau"),
            keywords: &[
                "kōroa",
                "kōroa tāmuri tohu matau",
                "matimati",
                "ringa",
                "tohu",
                "tāmuri",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("показалец свртен надесно"),
            keywords: &[
                "десно",
                "покажува",
                "показалец",
                "показалец свртен надесно",
                "прст",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
            ),
            keywords: &[
                "ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}",
                "കൈ",
                "ച\u{d42}ണ\u{d4d}ട\u{d41}ക",
                "പ\u{d41}റംകൈ",
                "പോയന\u{d4d}റ\u{d41}ചെയ\u{d4d}യ\u{d41}ക",
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
                "വിരൽ",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун зүг зааж байгаа"),
            keywords: &[
                "баруун зүг зааж байгаа",
                "баруун тийш зааж буй долоовор хуруу",
                "гар",
                "гарын ар тал",
                "хуруу",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी उजवीकड\u{947} दर\u{94d}शविण\u{947}",
            ),
            keywords: &[
                "तर\u{94d}जनी",
                "दर\u{94d}शविण\u{947}",
                "बोट",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947}",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी उजवीकड\u{947} दर\u{94d}शविण\u{947}",
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी उजवीकड\u{947} दर\u{94d}शविण\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari telunjuk tunjuk kanan"),
            keywords: &["belakang tangan", "jari telunjuk tunjuk kanan", "tunjuk"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("indiċi b’lura li jipponta lejn il-lemin"),
            keywords: &[
                "b’lura",
                "idejn",
                "indiċi",
                "indiċi b’lura li jipponta lejn il-lemin",
                "punt",
                "suba’",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ညာသ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ),
            keywords: &[
                "ညာသ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
                "ညာသ\u{102d}\u{102f}\u{1037} လက\u{103a}ပြန\u{103a} လက\u{103a}ည\u{103e}\u{102d}\u{102f}းည\u{103d}\u{103e}န\u{103a}ခြင\u{103a}း",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ည\u{103e}\u{102d}\u{102f}း",
                "လက\u{103a}ည\u{103e}\u{102d}\u{102f}းည\u{103d}\u{103e}န\u{103a}ခြင\u{103a}း",
                "လက\u{103a}ပြန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("peker mot høyre – bakhånd"),
            keywords: &[
                "finger",
                "hånd",
                "pekende finger",
                "peker mot høyre – bakhånd",
                "peker opp",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दाया\u{901}तिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला"),
            keywords: &[
                "औ\u{902}ला",
                "दाया\u{901}तिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला",
                "पछाडिको हात",
                "विन\u{94d}द\u{941}",
                "स\u{942}चक",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achterkant van hand met naar rechts wijzende wijsvinger"),
            keywords: &[
                "achterkant van hand met naar rechts wijzende wijsvinger",
                "hand",
                "lichaam",
                "vinger",
                "vinger wijst naar rechts",
                "wijsvinger",
                "wijzen",
                "wijzend",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("peikar mot høgre – bakhand"),
            keywords: &[
                "finger",
                "hand",
                "peikande finger",
                "peikar mot høgre – bakhand",
                "peikar opp",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତର ପଛପଟ ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ଡ\u{b3e}ହ\u{b3e}ଣକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତର ପଛପଟ ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ସ\u{b42}ଚୀତ କର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତର ପଛପଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}ਜ\u{a47} ਪਾਸ\u{a47}\u{a47} ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲ"),
            keywords: &[
                "ਇ\u{a70}ਡ\u{a48}ਕਸ ਉ\u{a02}ਗਲ",
                "ਸਰੀਰ",
                "ਸ\u{a42}ਚੀ",
                "ਸ\u{a71}ਜ\u{a47} ਪਾਸ\u{a47}\u{a47} ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲ",
                "ਹ\u{a71}ਥ ਦਾ ਪਿਛਲਾ ਪਾਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ دے مخالف پاسیوں شہادت دی انگلی نال سجے اشارہ کردیاں ہوئیاں"),
            keywords: &[
                "اشارہ کرنا",
                "ا\u{64f}نگل",
                "بیک ہینڈ",
                "ضمینہ",
                "ہتھ",
                "ہتھ دے مخالف پاسیوں شہادت دی انگلی نال سجے اشارہ کردیاں ہوئیاں",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Rait"),
            keywords: &[
                "Bakhand",
                "Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Rait",
                "Fínga",
                "Hand",
                "Niá-Tọ\u{301}mb-Fínga",
                "Pọint",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłoń z palcem wskazującym w prawo"),
            keywords: &[
                "dłoń z palcem wskazującym w prawo",
                "palec",
                "prawa strona",
                "w prawo",
                "wskazujący",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په ښي لاس په شهادت ګوته اشاره کول"),
            keywords: &[
                "اشاره",
                "د لاس شا",
                "شهادت ګوته",
                "لاس",
                "په ښي لاس په شهادت ګوته اشاره کول",
                "ګوته",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dorso da mão com dedo indicador apontando para a direita"),
            keywords: &[
                "costas da mão",
                "dedo",
                "dedo apontado para direita",
                "dedo indicador",
                "dorso da mão com dedo indicador apontando para a direita",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("costas da mão com dedo indicador a apontar para a direita"),
            keywords: &[
                "apontar",
                "corpo",
                "costas da mão",
                "costas da mão com dedo indicador a apontar para a direita",
                "dedo",
                "indicador",
                "mão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼupsi rukʼanawan pañaman chimpuy"),
            keywords: &[
                "chimpuy",
                "indice",
                "jinchʼa",
                "maki",
                "rukana",
                "tʼupsi rukʼanawan pañaman chimpuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dos de mână cu arătătorul spre dreapta"),
            keywords: &[
                "arătător",
                "deget",
                "dos de mână cu arătătorul spre dreapta",
                "dosul palmei",
                "dreapta",
                "mână",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-518"),
            keywords: &["E10-518"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("указывающий направо палец"),
            keywords: &[
                "вправо",
                "направо",
                "палец",
                "указательный",
                "указывающий направо палец",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urutoki rutunze iburyo"),
            keywords: &[
                "gutunga",
                "ikiganza",
                "mukubitarukoko",
                "umugongo w’ikiganza",
                "urutoki",
                "urutoki rutunze iburyo",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي هٿ جي آڱر ساڄي طرف اشارو ڪندي"),
            keywords: &[
                "آڱر",
                "اشارو ڪرڻ",
                "شهادت واري آڱر",
                "هٿ",
                "کاٻو هٿ",
                "کاٻي هٿ جي آڱر ساڄي طرف اشارو ڪندي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some(
                "දක\u{dd4}ණට යොම\u{dd4} ව\u{dd6} අත ප\u{dd2}ට\u{dd4}පස දබරැඟ\u{dd2}ල\u{dca}ල",
            ),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "දක\u{dd4}ණට යොම\u{dd4} ව\u{dd6} අත ප\u{dd2}ට\u{dd4}පස දබරැඟ\u{dd2}ල\u{dca}ල",
                "ප\u{dd2}ට\u{dd2} අත\u{dca} පහර",
                "ලක\u{dca}ෂ\u{dca}\u{200d}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ukazovák doprava"),
            keywords: &["doprava", "prst", "ruka", "ukazovať", "ukazovák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hrbtna stran dlani s kazalcem, ki kaže desno"),
            keywords: &[
                "dlan",
                "hrbtna stran",
                "hrbtna stran dlani s kazalcem, ki kaže desno",
                "kazalec",
                "kazati",
                "prst",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan tilmaamaysa midig"),
            keywords: &[
                "far",
                "farta muujinta gacanta gadaale tilmaamaysa midig",
                "gacan",
                "gacan tilmaamaysa midig",
                "gacanta gadaale",
                "muujin",
                "tilmaam",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gisht tregues i drejtuar djathtas"),
            keywords: &[
                "dorë",
                "gisht",
                "gisht tregues i drejtuar djathtas",
                "kurrizi i dorës",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кажипрст који показује удесно"),
            keywords: &[
                "кaжипрст",
                "кажипрст који показује удесно",
                "пoкaзивaњe",
                "прст",
                "рукa",
                "удесно",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кажипрст који показује удесно"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kažiprst koji pokazuje udesno"),
            keywords: &[
                "kažiprst",
                "kažiprst koji pokazuje udesno",
                "pokazivanje",
                "prst",
                "ruka",
                "udesno",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kažiprst koji pokazuje udesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högerpekande finger"),
            keywords: &["högerpekande finger", "peka åt höger", "pekfinger"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidole cha shahada kinachoelekeza kulia"),
            keywords: &[
                "cha shahada",
                "elekeza",
                "kidole",
                "kidole cha shahada kinachoelekeza kulia",
                "mkono",
                "nyuma ya mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலது நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}"),
            keywords: &[
                "ஆள\u{bcd}க\u{bbe}ட\u{bcd}டி விரல\u{bcd}",
                "வலது நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}",
                "வலதுநோக\u{bcd}கிய விரல\u{bcd}",
                "விரல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుడ\u{c3f} చూపుడు వ\u{c47}లు"),
            keywords: &["కుడ\u{c3f}", "కుడ\u{c3f} చూపుడు వ\u{c47}లు", "వ\u{c47}లు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ангушти ишорат ба тарафи рост ишора карда истода"),
            keywords: &[
                "ангушт",
                "ангушти ишорат ба тарафи рост ишора карда истода",
                "даст",
                "нишондиҳанда",
                "нуқта",
                "пушти даст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e34}\u{e49}วช\u{e35}\u{e49}ทางขวา"),
            keywords: &[
                "ขวา",
                "ช\u{e35}\u{e49}",
                "น\u{e34}\u{e49}ว",
                "น\u{e34}\u{e49}วช\u{e35}\u{e49}ทางขวา",
                "ม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("sagy görkezýän el-arkasy süýem barmak"),
            keywords: &[
                "barmak",
                "el",
                "eliň arkasy",
                "görkezmek",
                "sagy görkezýän el-arkasy süýem barmak",
                "süýem",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuhu tuʻanima tonu ki mataʻu"),
            keywords: &["tuhu tuʻanima tonu ki mataʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elinin tersiyle sağı gösteren işaret parmağı"),
            keywords: &[
                "elin arkası",
                "elinin tersiyle sağı gösteren işaret parmağı",
                "işaret parmağı",
                "parmak",
                "sağı gösteren parmak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارقىچە ئوڭنى كۆرسەتكەن كۆرسەتكۈچ بارماق"),
            keywords: &[
                "ئارقىچە ئوڭنى كۆرسەتكەن كۆرسەتكۈچ بارماق",
                "بارماق",
                "قول",
                "قولنىڭ ئارقىسى",
                "كۆرسىتىش",
                "كۆرسەتكۈچ بارماق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палець тильним боком, що вказує вправо"),
            keywords: &[
                "вказівний",
                "палець",
                "палець тильним боком, що вказує вправо",
                "рука",
                "указувати",
                "управо",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دائیں اشارہ کرتی بیک ہینڈ شہادت کی انگلی"),
            keywords: &[
                "انگلی",
                "جسم",
                "دائیں",
                "دائیں اشارہ کرتی بیک ہینڈ شہادت کی انگلی",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘rsatkich barmoq oʻngga"),
            keywords: &[
                "barmoq",
                "barmoq orqa tomoni",
                "ko‘rsatkich",
                "ko‘rsatkich barmog‘i orqa tomoni bilan o‘ngga qarab turgan qo‘l",
                "ko‘rsatkich barmoq oʻngga",
                "qo‘l",
                "yo‘naltirish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón trỏ trái chỉ sang phải"),
            keywords: &[
                "chỉ",
                "mu bàn tay",
                "ngón tay",
                "ngón trỏ",
                "ngón trỏ trái chỉ sang phải",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ginaaw loxo buy joxoñ ndijoor"),
            keywords: &[
                "baaraam",
                "baaraamu joxoñ",
                "ginaaw loxo buy joxoñ ndijoor",
                "ginaawu loxo",
                "joxoñ",
                "loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isalathiso somva wesandla esalatha ekunene"),
            keywords: &[
                "isalathiso",
                "isalathiso somva wesandla esalatha ekunene",
                "isandla",
                "umnwe",
                "umva wesandla",
                "yalatha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyin Ọwọ Ti O Tọka Si Apa Ọtun"),
            keywords: &[
                "ìka",
                "ìka kékeré",
                "Ẹyin Ọwọ Ti O Tọka Si Apa Ọtun",
                "ẹ\u{300}yìn ọwọ\u{301}",
                "ọwọ\u{301}",
                "ọ\u{300}gángán",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("反手指向右邊"),
            keywords: &["反手", "反手指向右邊", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("反手指向右边"),
            keywords: &["反手", "反手指向右边", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("反手食指向右指"),
            keywords: &["反手", "反手食指向右指", "向右指", "手", "指右", "食指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("右"),
            keywords: &["右", "手", "指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukukhomba ngengemuva lesandla sokudla ngomunwe wokukhomba"),
            keywords: &[
                "isandla",
                "ukukhomba",
                "ukukhomba ngengemuva lesandla sokudla ngomunwe wokukhomba",
                "umunwe",
                "umunwe wokukhomba",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👉🏻"]
pub const BACKHAND_INDEX_POINTING_RIGHT_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👉🏻",
    codepoint: "1F449 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing right: light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👉🏼"]
pub const BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👉🏼",
    codepoint: "1F449 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing right: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👉🏽"]
pub const BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👉🏽",
    codepoint: "1F449 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing right: medium skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👉🏾"]
pub const BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👉🏾",
    codepoint: "1F449 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing right: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👉🏿"]
pub const BACKHAND_INDEX_POINTING_RIGHT_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👉🏿",
    codepoint: "1F449 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing right: dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👆"]
pub const BACKHAND_INDEX_POINTING_UP: crate::Emoji = crate::Emoji {
    glyph: "👆",
    codepoint: "1F446",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "backhand index pointing up",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wysvingerrughand wat op wys"),
            keywords: &[
                "hand",
                "liggaam",
                "op",
                "rughand",
                "vinger",
                "wys",
                "wysvingerrughand wat op wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ የተቀሰረ አይበሉባ በኩል አመልካች ጣት"),
            keywords: &[
                "ላይ",
                "ነጥብ",
                "እጅ",
                "ወደ ላይ የተቀሰረ አይበሉባ በኩል አመልካች ጣት",
                "ወደ ኋላ መገልበጥ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إصبع لأعلى"),
            keywords: &["إصبع", "إصبع لأعلى", "السبابة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী ওপৰলৈ নিৰ\u{9cd}দেশ কৰ\u{9be}"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "ওপৰ",
                "তৰ\u{9cd}জনী",
                "নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "ব\u{9be}ও\u{981}হ\u{9be}ত",
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী ওপৰলৈ নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yuxarını göstərən sol əlin işarə barmağı"),
            keywords: &[
                "barmaq",
                "göstərmək",
                "işarə",
                "sol əl",
                "yuxarı",
                "yuxarını göstərən sol əlin işarə barmağı",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рука з указальным пальцам уверх"),
            keywords: &[
                "палец",
                "рука",
                "рука з указальным пальцам уверх",
                "угару",
                "указальны палец уверх",
                "цела",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("показалец, сочещ нагоре"),
            keywords: &[
                "Показалец нагоре откъм опакото на ръката",
                "нагоре",
                "показалец",
                "показалец, сочещ нагоре",
                "соча",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আঙ\u{9c1}ল দিয\u{9bc}ে উপরের দিকে ইশ\u{9be}র\u{9be} কর\u{9be}"),
            keywords: &[
                "আঙ\u{9c1}ল দিয\u{9bc}ে উপরের দিকে ইশ\u{9be}র\u{9be} কর\u{9be}",
                "আঙ\u{9cd}গ\u{9c1}ল",
                "আপ",
                "পয\u{9bc}েন\u{9cd}ট",
                "ব\u{9cd}য\u{9be}কহ\u{9cd}য\u{9be}ন\u{9cd}ড",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pokazivanje kažiprstom gore"),
            keywords: &[
                "gore",
                "kažiprst",
                "nadlanica",
                "pokazivanje",
                "pokazivanje kažiprstom gore",
                "prst",
                "ruka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dit índex que apunta cap amunt"),
            keywords: &["amunt", "dit índex", "dit índex que apunta cap amunt"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏩᏎᎯᎲ ᎦᎸᎳᏓᎬᏘ"),
            keywords: &[
                "ᎠᏎᎯ",
                "ᎠᏏᏁᎦ",
                "ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏩᏎᎯᎲ ᎦᎸᎳᏓᎬᏘ",
                "ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏩᏎᎯᎲᎢ ᎦᎸᎳᏓᎬᏘ",
                "ᎤᏬᏱ",
                "ᎦᎸᎳᏗ",
                "ᎦᏰᏌᏛ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruka s prstem ukazujícím nahoru"),
            keywords: &[
                "hřbet ruky",
                "nahoru",
                "prst",
                "ruka",
                "ruka s prstem ukazujícím nahoru",
                "tělo",
                "ukazovat",
                "ukazováček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynegfys yr wrthlaw yn pwyntio i fyny"),
            keywords: &[
                "bys",
                "corff",
                "gwrthlaw",
                "mynegfys",
                "mynegfys yr wrthlaw yn pwyntio i fyny",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("peger opad"),
            keywords: &[
                "finger",
                "finger peger op",
                "pegefinger",
                "peger op",
                "peger opad",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("nach oben weisender Zeigefinger von hinten"),
            keywords: &[
                "Finger",
                "Handrückseite",
                "aufwärts",
                "nach oben weisender Zeigefinger von hinten",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δείκτης χεριού προς τα επάνω ανάποδα"),
            keywords: &[
                "δάχτυλο",
                "δείκτης",
                "δείκτης χεριού προς τα επάνω ανάποδα",
                "δείχνω",
                "επάνω",
                "σώμα",
                "χέρι",
                "χτύπημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("backhand index pointing up"),
            keywords: &[
                "backhand",
                "backhand index pointing up",
                "finger",
                "hand",
                "point",
                "up",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dorso de mano con índice hacia arriba"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo",
                "dorso de mano con índice hacia arriba",
                "mano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dorso de mano con dedo índice hacia arriba"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo",
                "dorso de mano con dedo índice hacia arriba",
                "dorso de mano con índice hacia arriba",
                "mano",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "apuntar",
                "dedo",
                "dorso de mano con dedo índice hacia arriba",
                "mano",
                "señalar",
                "índice",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mano con dedo índice hacia arriba"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo",
                "dorso de mano con dedo índice hacia arriba",
                "dorso de mano con índice hacia arriba",
                "mano",
                "mano con dedo índice hacia arriba",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("üles osutav sõrm tagantvaates"),
            keywords: &[
                "keha",
                "käsi",
                "nimetissõrm",
                "osutamine",
                "sõrm",
                "üles osutav sõrm tagantvaates",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora seinalatzen ari den hatza"),
            keywords: &[
                "erakusle",
                "esku",
                "gora seinalatzen ari den hatz erakuslearen atzealdea",
                "gora seinalatzen ari den hatza",
                "hatz",
                "seinalatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اشاره به بالا با پشت دست"),
            keywords: &[
                "اشاره",
                "اشاره به بالا با پشت دست",
                "انگشت",
                "بالا",
                "بدن",
                "دست",
                "پشت دست",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ylös osoittava etusormi kämmenselkä katsojaan päin"),
            keywords: &[
                "etusormi",
                "kämmenselkä",
                "käsi",
                "osoittaa",
                "sormi",
                "vartalo",
                "ylös",
                "ylös osoittava etusormi kämmenselkä katsojaan päin",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("backhand ng hintuturo na nakaturo sa itaas"),
            keywords: &[
                "backhand",
                "backhand ng hintuturo na nakaturo sa itaas",
                "daliri",
                "hintuturo",
                "kamay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fremstifingur peikar uppeftir"),
            keywords: &[
                "fingur",
                "fremstifingur",
                "fremstifingur peikar uppeftir",
                "hond",
                "peikifingur",
                "upp",
                "uppeftir",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main avec index pointant vers le haut"),
            keywords: &[
                "doigt",
                "index",
                "main",
                "main avec index pointant vers le haut",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "dos de la main avec index pointant vers le haut",
                "haut",
                "index",
                "main",
                "main avec index pointant vers le haut",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cúl corrmhéire ag díriú suas"),
            keywords: &[
                "corrmhéar",
                "cúl cormhéar ag pointeáil suas",
                "cúl corrmhéire ag díriú suas",
                "lámh",
                "méar",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("druim na làimhe, colgag a’ tomhadh suas"),
            keywords: &[
                "colgag",
                "corrag",
                "druim na làimhe",
                "druim na làimhe, colgag a’ tomhadh suas",
                "làmh",
                "meur",
                "suas",
                "tomhadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dedo índice apuntando cara arriba"),
            keywords: &[
                "arriba",
                "dedo índice apuntando cara arriba",
                "man",
                "índice",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથની પાછલી બાજ\u{ac1}એથી ઉપર ચી\u{a82}ધતી તર\u{acd}જની"),
            keywords: &[
                "આ\u{a82}ગળી",
                "ઉપર આ\u{a82}ગળી",
                "ઉપરની બાજ\u{ac1} ચી\u{a82}ધાય\u{ac7}લી આ\u{a82}ગળી",
                "પહ\u{ac7}લી આ\u{a82}ગળી",
                "હાથની પાછલી બાજ\u{ac1}એથી ઉપર ચી\u{a82}ધતી તર\u{acd}જની",
                "હાથનો પાછલો ભાગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan ali na baya mai nunawa sama"),
            keywords: &[
                "bayan hannu",
                "hannu",
                "nuna",
                "sama",
                "yatsa",
                "ɗan ali",
                "ɗan ali na baya mai nunawa sama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גב יד מצביעה למעלה"),
            keywords: &[
                "אצבע",
                "גב יד מצביעה למעלה",
                "יד",
                "להצביע",
                "למעלה",
                "מצביעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीछ\u{947} का हाथ और ऊपर इशारा करती तर\u{94d}जनी"),
            keywords: &[
                "अ\u{902}ग\u{941}लि",
                "अ\u{902}ग\u{941}लि ऊपर",
                "ऊपर इशारा करती ऊ\u{902}गली",
                "तर\u{94d}जनी अ\u{902}ग\u{941}लि",
                "पीछ\u{947} का हाथ",
                "पीछ\u{947} का हाथ और ऊपर इशारा करती तर\u{94d}जनी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kažiprst koji pokazuje prema gore"),
            keywords: &[
                "gore",
                "kažiprst",
                "kažiprst koji pokazuje prema gore",
                "pokazivanje",
                "prst",
                "šaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tenyér felfelé mutató ujjal"),
            keywords: &[
                "felfelé",
                "kéz",
                "mutatóujj",
                "tenyér",
                "tenyér felfelé mutató ujjal",
                "test",
                "ujj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեպի վեր ուղղված ցուցամատ"),
            keywords: &[
                "դեպի վեր ուղղված ցուցամատ",
                "ձեռք",
                "մատ",
                "մարմին",
                "ուղղված",
                "վեր",
                "ցուցամատ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("menunjuk ke atas (dibalik)"),
            keywords: &[
                "atas",
                "badan",
                "jari",
                "menunjuk ke atas (dibalik)",
                "tangan",
                "telunjuk",
                "tubuh",
                "tunjuk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àzụaka na-arụ aka n’elu"),
            keywords: &["aka", "mkpịsịaka", "na-arụ", "n’elu", "àzụaka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fingur bendir upp"),
            keywords: &[
                "bakhönd bendir upp",
                "benda",
                "fingur",
                "fingur bendir upp",
                "hönd",
                "upp",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("indice alzato"),
            keywords: &[
                "dito alzato",
                "dito in su",
                "dito indice",
                "indice alzato",
                "indice in su",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手の甲上指差し"),
            keywords: &["上", "手", "手の甲上指差し", "指差し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("geger tangan nuding ndhuwur"),
            keywords: &[
                "driji",
                "geger tangan",
                "geger tangan nuding ndhuwur",
                "ndhuwur",
                "nuding",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელის ზურგიდან ზემოთ აშვერილი საჩვენებელი თითი"),
            keywords: &[
                "ზემოთ",
                "თითი",
                "მითითება",
                "საჩვენებელი",
                "სხეული",
                "ტანი",
                "ხელი",
                "ხელის ზურგი",
                "ხელის ზურგიდან ზემოთ აშვერილი საჩვენებელი თითი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғары саусақпен қолды сыртқа қаратып көрсету"),
            keywords: &[
                "артқа",
                "жоғары",
                "жоғары саусақпен қолды сыртқа қаратып көрсету",
                "көрсету",
                "саусақ",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("finger peger op"),
            keywords: &["finger", "finger peger op", "pegefinger", "peger op"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}អ\u{17bb}លទៅលើដោយបង\u{17d2}ហាញខ\u{17d2}នងដៃ"),
            keywords: &[
                "ខ\u{17d2}នងដៃ",
                "ចង\u{17d2}អ\u{17bb}ល",
                "ចង\u{17d2}អ\u{17bb}លទៅលើដោយបង\u{17d2}ហាញខ\u{17d2}នងដៃ",
                "បាតដៃ",
                "ម\u{17d2}រាមដៃ",
                "ឡើងលើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಹ\u{cbf}ಂಬದ\u{cbf}ಯ ಕೈ ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು",
            ),
            keywords: &[
                "ಮೇಲಕ\u{ccd}ಕ\u{cc6} ಬ\u{cc6}ರಳು",
                "ಹ\u{cbf}ಂಬದ\u{cbf}ಯ ಕೈ ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("위쪽을 가리키는 손등"),
            keywords: &[
                "검지손가락",
                "손가락 위로",
                "손가락으로 위를 가리키기",
                "위",
                "위를 가리키는 검지손가락",
                "위쪽",
                "위쪽을 가리키는 손등",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तर\u{94d}जनी वयल\u{947} वट\u{947}न दाखोवपी हाताची फाट"),
            keywords: &[
                "तर\u{94d}जनी वयल\u{947} वट\u{947}न दाखोवपी हाताची फाट",
                "दाखोवप",
                "बोट",
                "वयर",
                "हात",
                "हाताची फाट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сөөмөйү өйдө караган колдун арткы бети"),
            keywords: &[
                "кол",
                "көрсөт",
                "сөөмөй",
                "сөөмөйү өйдө караган колдун арткы бети",
                "өйдө",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no uewe weisende Fanger vun hanne gesinn"),
            keywords: &[
                "Fanger",
                "Hand",
                "Réckhand",
                "Zeigefanger",
                "no uewe weisende Fanger vun hanne gesinn",
                "no uewen",
                "weisen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebc}\u{eb1}ງມ\u{eb7}ນ\u{eb5}\u{ec9}ວຊ\u{eb5}\u{ec9}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ຊ\u{eb5}\u{ec9}",
                "ນ\u{eb4}\u{ec9}ວ",
                "ມ\u{eb7}",
                "ຫ\u{ebc}\u{eb1}ງມ\u{eb7}ນ\u{eb5}\u{ec9}ວຊ\u{eb5}\u{ec9}ຂ\u{eb6}\u{ec9}ນ",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delnu nusukta aukštyn pirštu rodanti ranka"),
            keywords: &[
                "delnu nusukta aukštyn pirštu rodanti ranka",
                "indeksas",
                "kūnas",
                "pirštas",
                "ranka",
                "rodyti",
                "į viršų",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšup vērsts rādītājpirksts ar prom vērstu delnu"),
            keywords: &[
                "augšup vērsts rādītājpirksts ar prom vērstu delnu",
                "delna",
                "pirksts",
                "roka",
                "rādīt",
                "rādītājpirksts",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōroa tāmuri tohu ake"),
            keywords: &["ake", "kōroa", "matimati", "ringa", "tohu", "tāmuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("показалец свртен нагоре"),
            keywords: &[
                "горе",
                "покажува",
                "показалец",
                "показалец свртен нагоре",
                "прст",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
            ),
            keywords: &[
                "ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}",
                "കൈ",
                "ച\u{d42}ണ\u{d4d}ട\u{d41}ക",
                "പ\u{d41}റംകൈ",
                "പോയന\u{d4d}റ\u{d41}ചെയ\u{d4d}യ\u{d41}ക",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
                "വിരൽ",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээ зааж буй алганы ар тал"),
            keywords: &[
                "гар",
                "гарын ар тал",
                "дээшээ зааж буй алганы ар тал",
                "дээшээ зааж буй долоовор хуруу",
                "хуруу",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी वर दर\u{94d}शविण\u{947}",
            ),
            keywords: &[
                "तर\u{94d}जनी",
                "दर\u{94d}शविण\u{947}",
                "बोट",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947}",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी वर दर\u{94d}शविण\u{947}",
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी वर दर\u{94d}शविण\u{947}",
                "वर",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari telunjuk tunjuk hala ke atas"),
            keywords: &[
                "atas",
                "belakang tangan",
                "jari",
                "jari telunjuk belakang tangan tuding ke atas",
                "jari telunjuk tunjuk hala ke atas",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("indiċi b’lura li jipponta ’l fuq"),
            keywords: &[
                "id",
                "indiċ",
                "indiċi b’lura",
                "indiċi b’lura li jipponta ’l fuq",
                "ipponta",
                "suba’",
                "’l fuq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ),
            keywords: &[
                "ည\u{103d}\u{103e}န\u{103a}ပြ",
                "လက\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ပြန\u{103a}",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} လက\u{103a}ပြန\u{103a} လက\u{103a}ည\u{103e}\u{102d}\u{102f}းည\u{103d}\u{103e}န\u{103a}နေပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("peker opp – bakhånd"),
            keywords: &[
                "finger",
                "hånd",
                "pekende finger",
                "peker opp",
                "peker opp – bakhånd",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथितिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला"),
            keywords: &[
                "औ\u{901}लाल\u{947} द\u{947}खाउन\u{941}",
                "औ\u{902}ला",
                "पछाडिको हात",
                "माथि",
                "माथितिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achterkant van hand met omhoog wijzende wijsvinger"),
            keywords: &[
                "achterkant van hand met omhoog wijzende wijsvinger",
                "hand",
                "hand met rug naar voren",
                "omhoog",
                "vinger",
                "wijsvinger",
                "wijzen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("peikar opp – bakhand"),
            keywords: &[
                "finger",
                "hand",
                "peikande finger",
                "peikar opp",
                "peikar opp – bakhand",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଉପରକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତର ପଛପଟ ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ଉପର",
                "ଉପରକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତର ପଛପଟ ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ସ\u{b42}ଚୀତ କର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତର ପଛପଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਹ\u{a71}ਥ ਦਾ ਪਿਛਲਾ ਹਿ\u{a71}\u{a71}ਸਾ ਅਤ\u{a47} ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲੀ",
            ),
            keywords: &[
                "ਇ\u{a70}ਡ\u{a48}ਕਸ ਉ\u{a02}ਗਲ",
                "ਉ\u{a02}ਗਲ",
                "ਉ\u{a71}ਪਰ ਇਸ\u{a3c}ਾਰਾ ਉ\u{a02}ਗਲ",
                "ਹ\u{a71}ਥ ਦਾ ਪਿਛਲਾ ਹਿ\u{a71}\u{a71}ਸਾ ਅਤ\u{a47} ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲੀ",
                "ਹ\u{a71}ਥ ਪਿਛਲਾ ਪਾਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ دے مخالف پاسیوں شہادت دی انگلی نال اوتے اشارہ کردیاں ہوئیاں"),
            keywords: &[
                "اشارہ کرنا",
                "ا\u{64f}نگل",
                "ا\u{64f}وتے",
                "بیک ہینڈ",
                "ضمینہ",
                "ہتھ",
                "ہتھ دے مخالف پاسیوں شہادت دی انگلی نال اوتے اشارہ کردیاں ہوئیاں",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Ọp"),
            keywords: &[
                "Bakhand",
                "Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Ọp",
                "Fínga",
                "Hand",
                "Pọint",
                "Ọp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłoń z palcem wskazującym w górę"),
            keywords: &[
                "do góry",
                "dłoń z palcem wskazującym w górę",
                "góra",
                "palec",
                "w górę",
                "wskazujący",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شهادت ګوته لاس شاخوا پورته نیول"),
            keywords: &[
                "شهادت ګوته",
                "شهادت ګوته لاس شاخوا پورته نیول",
                "شهادت ګوته پورته نیول",
                "لاس",
                "پورته",
                "ګوته",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dorso da mão com dedo indicador apontando para cima"),
            keywords: &[
                "costas da mão",
                "dedo",
                "dedo apontado para cima",
                "dedo indicador",
                "dorso da mão com dedo indicador apontando para cima",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("costas da mão com dedo indicador a apontar para cima"),
            keywords: &[
                "apontar",
                "corpo",
                "costas da mão",
                "costas da mão com dedo indicador a apontar para cima",
                "dedo",
                "indicador",
                "mão",
                "para cima",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼupsi rukʼanawan hanaqman chimpuy"),
            keywords: &[
                "chimpuy",
                "hanaq",
                "jinchʼa",
                "maki",
                "rukana",
                "tʼupsi rukʼanawan hanaqman chimpuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dos de mână cu arătătorul în sus"),
            keywords: &[
                "arătător",
                "deget",
                "dos de mână cu arătătorul în sus",
                "dos de mână cu degetul arătător îndreptat în sus",
                "dosul palmei",
                "indica",
                "sus",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-515"),
            keywords: &["E10-515"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("указывающий вверх палец"),
            keywords: &[
                "вверх",
                "наверх",
                "палец",
                "указательный",
                "указывающий вверх палец",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urutoki rutunze hejuru"),
            keywords: &[
                "gutunga",
                "hejuru",
                "ikiganza",
                "mukubitarukoko",
                "urutoki",
                "urutoki rutunze hejuru",
                "werekeza inyuma",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي هٿ جي آڱر مٿي اشارو ڪندي"),
            keywords: &[
                "آڱر",
                "اشارو ڪرڻ",
                "شهادت واري آڱر",
                "مٿي",
                "هٿ",
                "کاٻو هٿ",
                "کاٻي هٿ جي آڱر مٿي اشارو ڪندي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත ප\u{dd2}ට\u{dd4}පස ඉහළට යොම\u{dd4} ව\u{dd6} දබරැඟ\u{dd2}ල\u{dca}ල"),
            keywords: &[
                "අත",
                "අත ප\u{dd2}ට\u{dd4}පස ඉහළට යොම\u{dd4} ව\u{dd6} දබරැඟ\u{dd2}ල\u{dca}ල",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "ඉහළට එල\u{dca}ල කර",
                "දබර",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ukazovák spakruky nahor"),
            keywords: &["nahor", "prst", "ruka", "spakruky", "ukazovať", "ukazovák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hrbtna stran dlani s kazalcem, ki kaže gor"),
            keywords: &[
                "dlan",
                "gor",
                "hrbtna stran",
                "hrbtna stran dlani s kazalcem, ki kaže gor",
                "kazalec",
                "kazati",
                "prst",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan tilmaamaysa kor"),
            keywords: &[
                "far",
                "farta muujinta gacanta gadaale tilmaamaysa kor",
                "gacan",
                "gacan tilmaamaysa kor",
                "gacanta gadaal",
                "kor",
                "tilmaam",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gisht tregues i drejtuar lart"),
            keywords: &[
                "dorë",
                "gisht",
                "gisht tregues i drejtuar lart",
                "gisht tregues i drejtuar lartë",
                "tregoj",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кажипрст који показује нагоре отпозади"),
            keywords: &[
                "кaжипрст",
                "кажипрст који показује нагоре отпозади",
                "нагoрe",
                "пoкaзивaњe",
                "прeдњa стрaнa",
                "прст",
                "рукa",
                "тело",
                "шaкa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кажипрст који показује нагоре отпозади"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kažiprst koji pokazuje nagore otpozadi"),
            keywords: &[
                "kažiprst",
                "kažiprst koji pokazuje nagore otpozadi",
                "nagore",
                "pokazivanje",
                "prednja strana",
                "prst",
                "ruka",
                "telo",
                "šaka",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kažiprst koji pokazuje nagore otpozadi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("pekfinger upp"),
            keywords: &["finger", "peka uppåt", "pekfinger", "pekfinger upp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidole cha kwanza kinachoelekeza juu kwa nyuma"),
            keywords: &[
                "cha shahada",
                "elekeza",
                "juu",
                "kidole cha kwanza kinachoelekeza juu kwa nyuma",
                "kidole cha shahada kinachoelekeza juu kwa nyuma",
                "mkono",
                "nyuma ya mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "மேல\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரலின\u{bcd} பின\u{bcd}பக\u{bcd}கம\u{bcd}",
            ),
            keywords: &[
                "ஆள\u{bcd}க\u{bbe}ட\u{bcd}டி விரல\u{bcd}",
                "மேல\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரலின\u{bcd} பின\u{bcd}பக\u{bcd}கம\u{bcd}",
                "மேல\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}",
                "மேல\u{bcd}நோக\u{bcd}கிய விரல\u{bcd}",
                "விரல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చూపుడు వ\u{c47}లు ప\u{c48}క\u{c46}త\u{c4d}తటం"),
            keywords: &[
                "చూపుట",
                "చూపుడు వ\u{c47}లు ప\u{c48}క\u{c46}త\u{c4d}తటం",
                "వ\u{c47}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пушти даст ангушти ишорат ба боло ишора карда истода"),
            keywords: &[
                "ангушт",
                "боло",
                "даст",
                "нишондиҳанда",
                "пушти даст",
                "пушти даст ангушти ишорат ба боло ишора карда истода",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("หล\u{e31}งม\u{e37}อน\u{e34}\u{e49}วช\u{e35}\u{e49}ข\u{e36}\u{e49}น"),
            keywords: &[
                "ข\u{e36}\u{e49}น",
                "ช\u{e35}\u{e49}",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
                "หล\u{e31}งม\u{e37}อน\u{e34}\u{e49}วช\u{e35}\u{e49}ข\u{e36}\u{e49}น",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("el-arkasy süýem barmak ýokaryk"),
            keywords: &[
                "barmak",
                "el",
                "el-arkasy süýem barmak ýokaryk",
                "eliň arkasy",
                "görkezmek",
                "süýem",
                "ýokary",
                "ýokaryny görkezýän el-arkasy süýem barmak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuhu tuʻanima tonu ki ʻolunga"),
            keywords: &["tuhu tuʻanima tonu ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elinin tersiyle yukarıyı gösteren işaret parmağı"),
            keywords: &[
                "elin arkası",
                "elinin tersiyle yukarıyı gösteren işaret parmağı",
                "işaret parmağı",
                "parmak",
                "yukarıyı gösteren parmak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارقىچە ئۈستىنى كۆرسەتكەن كۆرسەتكۈچ بارماق"),
            keywords: &[
                "ئارقىچە ئۈستىنى كۆرسەتكەن كۆرسەتكۈچ بارماق",
                "ئۈستى",
                "بارماق",
                "قول",
                "قولنىڭ ئارقىسى",
                "كۆرسىتىش",
                "كۆرسەتكۈچ بارماق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палець тильним боком, що вказує вгору"),
            keywords: &[
                "вказівний",
                "палець",
                "палець тильним боком, що вказує вгору",
                "рука",
                "угору",
                "указувати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر اشارہ کرتی بیک ہینڈ شہادت کی انگلی"),
            keywords: &[
                "اوپر",
                "اوپر اشارہ کرتی بیک ہینڈ شہادت کی انگلی",
                "جسم",
                "شہادت کی انگلی",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘rsatkich barmoq tepaga"),
            keywords: &[
                "barmoq",
                "koʻrsatish",
                "ko‘rsatkich barmog‘i orqa tomoni bilan tepaga qarab turgan qo‘l",
                "ko‘rsatkich barmoq tepaga",
                "qoʻl",
                "qoʻl orqasi",
                "qoʻl orqasi va tepaga qaratilgan koʻrsatkich barmoq",
                "tepaga",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón trỏ trái chỉ lên"),
            keywords: &[
                "chỉ",
                "lên",
                "ngón tay",
                "ngón trỏ trái chỉ lên",
                "tay",
                "tay trái",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ginaaw loxo buy joxoñ ci kaw"),
            keywords: &[
                "baaraam",
                "baaraamu joxoñ",
                "ginaaw loxo buy joxoñ ci kaw",
                "ginaawu loxo",
                "joxoñ",
                "kaw",
                "loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isalathiso somva wesandla esalatha phezulu"),
            keywords: &[
                "isalathiso",
                "isalathiso somva wesandla esalatha phezulu",
                "isandla",
                "phezulu",
                "umnwe",
                "umva wesandla",
                "yalatha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyin Ọwọ Ti O Tọka Si Oke"),
            keywords: &[
                "sókè",
                "tọ\u{301}ka",
                "ìka",
                "ìka kékeré",
                "Ẹyin Ọwọ Ti O Tọka Si Oke",
                "ẹ\u{300}yìn ọwọ\u{301}",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("反手指向上邊"),
            keywords: &["上", "反手", "反手指向上邊", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("反手指向上边"),
            keywords: &["上", "反手", "反手指向上边", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("反手食指向上指"),
            keywords: &["反手", "反手食指向上指", "向上指", "手", "指上", "食指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("上"),
            keywords: &["上", "手", "指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukukhomba phezulu ngengemuva lesandla ngomunwe wokukhomba"),
            keywords: &[
                "isandla",
                "phezulu",
                "ukukhomba",
                "ukukhomba phezulu ngengemuva lesandla ngomunwe wokukhomba",
                "umunwe",
                "umunwe wokukhomba",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👆🏻"]
pub const BACKHAND_INDEX_POINTING_UP_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👆🏻",
    codepoint: "1F446 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing up: light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👆🏼"]
pub const BACKHAND_INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👆🏼",
    codepoint: "1F446 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing up: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👆🏽"]
pub const BACKHAND_INDEX_POINTING_UP_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👆🏽",
    codepoint: "1F446 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing up: medium skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👆🏾"]
pub const BACKHAND_INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👆🏾",
    codepoint: "1F446 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing up: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👆🏿"]
pub const BACKHAND_INDEX_POINTING_UP_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👆🏿",
    codepoint: "1F446 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing up: dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖕"]
pub const MIDDLE_FINGER: crate::Emoji = crate::Emoji {
    glyph: "🖕",
    codepoint: "1F595",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "middle finger",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("middelvinger"),
            keywords: &["hand", "liggaam", "middelvinger", "op", "vinger", "wys"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የመሃል ጣት"),
            keywords: &["አካል", "እጅ", "የመሃል ጣት", "ጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إصبع الوسطى"),
            keywords: &["إصبع", "إصبع الوسطى", "جسد", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মধ\u{9cd}যম\u{9be} আঙ\u{9c1}লি"),
            keywords: &["আঙ\u{9c1}লি", "মধ\u{9cd}যম\u{9be} আঙ\u{9c1}লি", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("orta barmaq"),
            keywords: &["barmaq", "orta barmaq", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сярэдні палец"),
            keywords: &["палец", "рука", "сярэдні палец", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("среден пръст"),
            keywords: &["пръст", "ръка", "среден пръст", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মধ\u{9cd}যম\u{9be}"),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "মধ\u{9cd}যম\u{9be}",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srednji prst"),
            keywords: &["gore", "nadlanica", "pokazivanje", "srednji prst"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dit del cor"),
            keywords: &["dit", "dit cor", "dit del cor", "dit del mig", "mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏰᏟ ᎦᏰᏌᏛ"),
            keywords: &["ᎠᏰᏟ ᎦᏰᏌᏛ", "ᎤᏬᏱ", "ᎦᏰᏌᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("prostředníček"),
            keywords: &["prostředníček", "prst", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bys canol"),
            keywords: &["bys", "bys canol", "corff", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("langefinger"),
            keywords: &["finger", "hånd", "krop", "langefinger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mittelfinger"),
            keywords: &["Finger", "Hand", "Mittelfinger"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μεσαίο δάχτυλο"),
            keywords: &["δάχτυλο", "μεσαίο δάχτυλο", "σώμα", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("middle finger"),
            keywords: &["finger", "hand", "middle finger"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dedo corazón hacia arriba"),
            keywords: &[
                "corazón",
                "dedo",
                "dedo corazón hacia arriba",
                "mano",
                "peineta",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dorso de mano con dedo medio hacia arriba"),
            keywords: &[
                "dedo",
                "dorso de mano con dedo medio hacia arriba",
                "insulto",
                "mano",
                "medio",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mano con el dedo medio levantado"),
            keywords: &[
                "dedo",
                "insulto",
                "mano",
                "mano con el dedo medio levantado",
                "medio",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keskmine sõrm"),
            keywords: &["keha", "keskmine", "käsi", "sõrm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erdiko hatza"),
            keywords: &["erdiko hatza", "esku", "gorputz", "hatz"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("انگشت میانه"),
            keywords: &["انگشت", "انگشت میانه", "بدن", "دست", "ناسزا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keskisormi"),
            keywords: &["keskisormi", "käsi", "sormi", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hinlalato"),
            keywords: &["daliri", "gesture", "hinlalato", "kamay", "middle finger"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("longutong peikar uppeftir"),
            keywords: &[
                "fingur",
                "hond",
                "longutong",
                "longutong peikar uppeftir",
                "upp",
                "uppeftir",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("doigt d’honneur"),
            keywords: &["doigt", "doigt d’honneur", "main", "majeur"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["doigt d’honneur", "main", "majeur"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("méar láir"),
            keywords: &["corp", "lámh", "méar", "méar láir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("Fionnlagh Fada / Màiri Fhada"),
            keywords: &["Fionnlagh Fada / Màiri Fhada", "corrag", "làmh", "meur"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dedo do medio levantado"),
            keywords: &[
                "dedo",
                "dedo do medio levantado",
                "insulto",
                "man",
                "ofensivo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મધ\u{acd}યમા"),
            keywords: &[
                "આ\u{a82}ગળી",
                "મધ\u{acd}યમા",
                "વચલી આ\u{a82}ગળી",
                "વચ\u{acd}ચ\u{ac7}ની આ\u{a82}ગળી",
                "શરીર",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan yatsan tsakiya"),
            keywords: &["hannu", "yatsa", "ɗan yatsan tsakiya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אצבע משולשת"),
            keywords: &["אצבע משולשת", "תנועה מזרחית"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बीच की अ\u{901}ग\u{941}ली"),
            keywords: &["पीछ\u{947} का हाथ", "बीच की अ\u{901}ग\u{941}ली"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("srednji prst"),
            keywords: &["prst", "ruka", "srednji prst", "tijelo", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("középső ujj"),
            keywords: &["kéz", "középső ujj", "test", "ujj"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("միջնամատ"),
            keywords: &["ձեռք", "մատ", "միջնամատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jari tengah"),
            keywords: &["jari", "jari tengah", "tangan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpịsịaka etiti"),
            keywords: &["aka", "mkpịsịaka", "mkpịsịaka etiti"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("langatöng"),
            keywords: &["fingur", "hönd", "langatöng", "líkami"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dito medio"),
            keywords: &["dito medio", "insulto", "offendere"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("立てた中指"),
            keywords: &["上", "中指", "手", "指差し", "立てた中指"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("driji tengah"),
            keywords: &["driji", "driji tengah", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შუა თითი"),
            keywords: &["თითი", "სხეული", "ტანი", "შუა თითი", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ортаңғы саусақ"),
            keywords: &["дене", "ортаңғы саусақ", "саусақ", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("langefinger"),
            keywords: &["finger", "hånd", "krop", "langefinger"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}រាមដៃកណ\u{17d2}ដាល"),
            keywords: &[
                "ដៃ",
                "ម\u{17d2}រាមដៃ",
                "ម\u{17d2}រាមដៃកណ\u{17d2}ដាល",
                "ម\u{17d2}រាមដៃកណ\u{17d2}តាល",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಧ\u{ccd}ಯದ ಬ\u{cc6}ರಳು"),
            keywords: &["ಮಧ\u{ccd}ಯದ ಬ\u{cc6}ರಳು", "ಮೇಲಕ\u{ccd}ಕ\u{cc6} ಬ\u{cc6}ರಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("중지"),
            keywords: &["가운데 손가락", "욕설", "중지"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("मदल\u{947}\u{902} बोट"),
            keywords: &["बोट", "मदल\u{947}\u{902} बोट", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ортон"),
            keywords: &["дене", "кол", "манжа", "ортон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mëttelfanger"),
            keywords: &["Fanger", "Hand", "Mëttelfanger"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb5}\u{ec9}ວກາງ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ຊ\u{eb5}\u{ec9}",
                "ນ\u{eb4}\u{ec9}ວ",
                "ນ\u{eb5}\u{ec9}ວກາງ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vidurinis pirštas"),
            keywords: &["pirštas", "ranka", "vidurinis pirštas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vidējais pirksts"),
            keywords: &[
                "delna",
                "pirksts",
                "roka",
                "rādīt",
                "vidējais pirksts",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("māpere"),
            keywords: &["matimati", "māpere", "ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("среден прст"),
            keywords: &["дланка", "прст", "рака", "среден", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നട\u{d41}വിരൽ"),
            keywords: &["കൈ", "നട\u{d41}വിരൽ", "വിരൽ", "ശരീരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дунд хуруу"),
            keywords: &["алга", "гар", "дунд", "хуруу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मधल\u{947} बोट"),
            keywords: &["बोट", "मधल\u{947} बोट", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari hantu"),
            keywords: &["badan", "jari", "jari hantu", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("suba’ tan-nofs"),
            keywords: &["id", "suba’", "suba’ tan-nofs"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ခလယ\u{103a}"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ခလယ\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("langfinger"),
            keywords: &["finger", "hånd", "kropp", "langfinger", "vise fingeren"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बीचको औ\u{902}ला"),
            keywords: &["औ\u{902}ला", "बीचको औ\u{902}ला", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("middelvinger"),
            keywords: &["hand", "middelvinger", "vinger"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("langfinger"),
            keywords: &["finger", "hand", "kropp", "langfinger", "vise fingeren"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମଝ\u{b3f} ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}"),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ମଝ\u{b3f} ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਵਿਚਕਾਰਲੀ ਉ\u{a02}ਗਲ"),
            keywords: &[
                "ਉ\u{a02}ਗਲ",
                "ਉ\u{a71}ਪਰ ਇਸ\u{a3c}ਾਰਾ ਉ\u{a02}ਗਲ",
                "ਉ\u{a71}ਪਰ ਉ\u{a02}ਗਲ",
                "ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਵਿਚਕਾਰਲੀ ਉ\u{a02}ਗਲ",
                "ਹ\u{a71}ਥ ਦਾ ਪਿਛਲਾ ਪਾਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("درمیانی ا\u{64f}نگل"),
            keywords: &["ا\u{64f}نگل", "درمیانی ا\u{64f}نگل", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mídúl Fínga"),
            keywords: &["Fínga", "Hand", "Mídúl Fínga"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("środkowy palec"),
            keywords: &["gest", "wulgarny gest", "środkowy palec"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("منځنې ګوته"),
            keywords: &["لاس", "منځنې ګوته", "ګوته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dedo do meio"),
            keywords: &["dedo", "dedo do meio", "gesto ofensivo", "mão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dedo médio"),
            keywords: &["dedo", "dedo médio", "mão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chawpi rukana"),
            keywords: &["chawpi rukana", "maki", "rukana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("degetul mijlociu"),
            keywords: &["deget", "degetul mijlociu", "gest", "insultă", "mijlociu"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-808"),
            keywords: &["E10-808"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("средний палец"),
            keywords: &["жест", "палец", "рука", "средний"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("musumbazose"),
            keywords: &["ikiganza", "musumbazose", "urutoki"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وچين آڱر"),
            keywords: &["آڱر", "هٿ", "وچين آڱر"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මැදඟ\u{dd2}ල\u{dca}ල"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "මැදඟ\u{dd2}ල\u{dca}ල",
                "ශර\u{dd3}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("prostredník"),
            keywords: &["prostredník", "prst", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("sredinec"),
            keywords: &["dlan", "kazati", "prst", "sredinec", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("farta dhexe"),
            keywords: &["far", "farta dhexe", "gacan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gishti i mesit"),
            keywords: &["dorë", "gisht", "gishti i mesit", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("средњи прст"),
            keywords: &["прст", "рукa", "средњи прст"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["средњи прст"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("srednji prst"),
            keywords: &["prst", "ruka", "srednji prst"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["srednji prst"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("långfinger upp"),
            keywords: &["finger", "hand", "långfinger upp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidole cha kati"),
            keywords: &["kidole", "kidole cha kati", "mkono", "mwili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நடு விரல\u{bcd}"),
            keywords: &["நடு விரல\u{bcd}", "நடுவில\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మధ\u{c4d}య వ\u{c47}లు చూపుట"),
            keywords: &[
                "చ\u{c47}య\u{c3f}",
                "మధ\u{c4d}య వ\u{c47}లు చూపుట",
                "వ\u{c47}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ангушти байн"),
            keywords: &["ангушт", "ангушти байн", "даст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39}น\u{e34}\u{e49}วกลาง"),
            keywords: &[
                "ข\u{e36}\u{e49}น",
                "ช\u{e35}\u{e49}",
                "ช\u{e39}น\u{e34}\u{e49}วกลาง",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("orta barmak"),
            keywords: &["barmak", "el", "orta barmak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuhu ʻi loto"),
            keywords: &["tuhu ʻi loto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("orta parmak"),
            keywords: &["beden", "el", "orta parmak", "parmak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوتتۇرا بارماق"),
            keywords: &["ئوتتۇرا بارماق", "بارماق", "قول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("середній палець"),
            keywords: &["палець", "рука", "середній палець"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("درمیانی انگلی"),
            keywords: &["جسم", "درمیانی انگلی", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘rta barmoq"),
            keywords: &["barmoq", "o‘rta barmoq", "qo‘l", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón giữa"),
            keywords: &["ngón giữa", "ngón tay", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baaraamu digg"),
            keywords: &["baaraam", "baaraamu digg", "loxo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umnwe ophakathi"),
            keywords: &["isandla", "umnwe", "umnwe ophakathi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìka àárín"),
            keywords: &["ìka", "ìka àárín", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("中指"),
            keywords: &["中指", "手", "手指"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("中指"),
            keywords: &["中指", "手", "手指"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("竖中指"),
            keywords: &["中指", "反手", "手", "竖中指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("中指"),
            keywords: &["中指", "比中指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umunwe omaphakathi"),
            keywords: &["isandla", "umunwe", "umunwe omaphakathi", "umzimba"],
        },
    ],
};
#[doc = "🖕🏻"]
pub const MIDDLE_FINGER_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖕🏻",
    codepoint: "1F595 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "middle finger: light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖕🏼"]
pub const MIDDLE_FINGER_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖕🏼",
    codepoint: "1F595 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "middle finger: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖕🏽"]
pub const MIDDLE_FINGER_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖕🏽",
    codepoint: "1F595 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "middle finger: medium skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖕🏾"]
pub const MIDDLE_FINGER_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖕🏾",
    codepoint: "1F595 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "middle finger: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖕🏿"]
pub const MIDDLE_FINGER_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖕🏿",
    codepoint: "1F595 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "middle finger: dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👇"]
pub const BACKHAND_INDEX_POINTING_DOWN: crate::Emoji = crate::Emoji {
    glyph: "👇",
    codepoint: "1F447",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "backhand index pointing down",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wysvingerrughand wat af wys"),
            keywords: &[
                "af",
                "hand",
                "liggaam",
                "rughand",
                "vinger",
                "wys",
                "wysvingerrughand wat af wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ታች የተቀሰረ አይበሉባ በኩል አመልካች ጣት"),
            keywords: &[
                "ታች",
                "ነጥብ",
                "እጅ",
                "ወደ ታች የተቀሰረ አይበሉባ በኩል አመልካች ጣት",
                "ወደ ኋላ መገልበጥ",
            ],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إصبع لأسفل"),
            keywords: &["إصبع", "إصبع لأسفل", "السبابة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some(
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী তলফ\u{9be}লে নিৰ\u{9cd}দেশ কৰ\u{9be}",
            ),
            keywords: &[
                "আঙ\u{9c1}লি",
                "তলফ\u{9be}ল",
                "তৰ\u{9cd}জনী",
                "নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "ব\u{9be}ও\u{981}হ\u{9be}ত",
                "ব\u{9be}ও\u{981}হ\u{9be}তৰ তৰ\u{9cd}জনী তলফ\u{9be}লে নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("aşağını göstərən sol əlin işarə barmağı"),
            keywords: &[
                "aşağı",
                "aşağını göstərən sol əlin işarə barmağı",
                "barmaq",
                "göstərmək",
                "işarə",
                "sol əl",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рука з указальным пальцам уніз"),
            keywords: &[
                "палец",
                "рука",
                "рука з указальным пальцам уніз",
                "указальны палец уніз",
                "уніз",
                "цела",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("показалец, сочещ надолу"),
            keywords: &[
                "Показалец надолу откъм опакото на ръката",
                "надолу",
                "показалец",
                "показалец, сочещ надолу",
                "соча",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আঙ\u{9c1}ল দিয\u{9bc}ে নীচের দিকে ইশ\u{9be}র\u{9be} কর\u{9be}"),
            keywords: &[
                "আঙ\u{9c1}ল দিয\u{9bc}ে নীচের দিকে ইশ\u{9be}র\u{9be} কর\u{9be}",
                "আঙ\u{9cd}গ\u{9c1}ল",
                "নিচের দিকে",
                "পয\u{9bc}েন\u{9cd}ট",
                "ব\u{9cd}য\u{9be}কহ\u{9cd}য\u{9be}ন\u{9cd}ড",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kažiprst dolje"),
            keywords: &[
                "dolje",
                "kažiprst",
                "nadlanica",
                "pokazivanje",
                "prst",
                "ruka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dit índex que apunta cap avall"),
            keywords: &["avall", "dit índex que apunta cap avall", "índex"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏩᏎᎯᎲᎢ ᎡᎳᏗ"),
            keywords: &[
                "ᎠᏎᎯ",
                "ᎡᎳᏗ",
                "ᎣᏂᏗᏜᎪᏯᏗ",
                "ᎣᏂᏗᏜᎪᏯᏗ ᎠᏍᏓᏩᏛᏍᏗ ᏩᏎᎯᎲᎢ ᎡᎳᏗ",
                "ᎤᏬᏱ",
                "ᎦᏰᏌᏛ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruka s prstem ukazujícím dolů"),
            keywords: &[
                "dolů",
                "hřbet ruky",
                "prst",
                "ruka",
                "ruka s prstem ukazujícím dolů",
                "tělo",
                "ukazovat",
                "ukazováček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynegfys yr wrthlaw yn pwyntio i lawr"),
            keywords: &[
                "bys",
                "corff",
                "gwrthlaw",
                "mynegfys",
                "mynegfys yr wrthlaw yn pwyntio i lawr",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("peger nedad"),
            keywords: &[
                "finger",
                "finger peger ned",
                "pegefinger",
                "peger ned",
                "peger nedad",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("nach unten weisender Zeigefinger"),
            keywords: &[
                "Finger",
                "Handrückseite",
                "abwärts",
                "nach unten weisender Zeigefinger",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δείκτης χεριού προς τα κάτω ανάποδα"),
            keywords: &[
                "δάχτυλο",
                "δείκτης",
                "δείκτης χεριού προς τα κάτω ανάποδα",
                "δείχνω",
                "κάτω",
                "σώμα",
                "χέρι",
                "χτύπημα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("backhand index pointing down"),
            keywords: &[
                "backhand",
                "backhand index pointing down",
                "down",
                "finger",
                "hand",
                "point",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dorso de mano con índice hacia abajo"),
            keywords: &[
                "abajo",
                "apuntar",
                "dedo",
                "dorso de mano con índice hacia abajo",
                "mano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dorso de mano con dedo índice hacia abajo"),
            keywords: &["dorso de mano con dedo índice hacia abajo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "abajo",
                "apuntar",
                "dorso de mano con dedo índice hacia abajo",
                "mano",
                "señalar",
                "índice",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &[
                "abajo",
                "apuntar",
                "dorso de mano con dedo índice hacia abajo",
                "mano",
                "señalar",
                "índice",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("alla osutav sõrm"),
            keywords: &[
                "alla osutav sõrm",
                "keha",
                "käsi",
                "nimetissõrm",
                "osutamine",
                "sõrm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("behera seinalatzen ari den hatza"),
            keywords: &[
                "behera seinalatzen ari den hatz erakuslearen atzealdea",
                "behera seinalatzen ari den hatza",
                "erakusle",
                "esku",
                "hatz",
                "seinalatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اشاره به پایین"),
            keywords: &[
                "اشاره",
                "اشاره به پایین",
                "انگشت",
                "بدن",
                "دست",
                "پایین",
                "پشت دست",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("alas osoittava etusormi kämmenselkä katsojaan päin"),
            keywords: &[
                "alas",
                "alas osoittava etusormi kämmenselkä katsojaan päin",
                "etusormi",
                "kämmenselkä",
                "käsi",
                "osoittaa",
                "sormi",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("backhand ng hintuturo na nakaturo sa ibaba"),
            keywords: &[
                "backhand",
                "backhand ng hintuturo na nakaturo sa ibaba",
                "daliri",
                "hintuturo",
                "kamay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("longutong peikar niðureftir"),
            keywords: &[
                "fingur",
                "hond",
                "longutong",
                "longutong peikar niðureftir",
                "niður",
                "niðureftir",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main avec index pointant vers le bas"),
            keywords: &[
                "bas",
                "doigt",
                "index",
                "main",
                "main avec index pointant vers le bas",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "bas",
                "dos de la main avec index pointant vers le bas",
                "index",
                "main",
                "main avec index pointant vers le bas",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cúl corrmhéire ag díriú síos"),
            keywords: &[
                "corrmhéar",
                "cúl cormhéar ag pointeáil síos",
                "cúl corrmhéire ag díriú síos",
                "lámh",
                "méar",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("druim na làimhe, colgag a’ tomhadh sìos"),
            keywords: &[
                "colgag",
                "corrag",
                "druim na làimhe",
                "druim na làimhe, colgag a’ tomhadh sìos",
                "làmh",
                "meur",
                "sìos",
                "tomhadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dedo apuntando cara abaixo"),
            keywords: &["abaixo", "dedo", "dedo apuntando cara abaixo", "man"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથની પાછલી બાજ\u{ac1}એથી નીચ\u{ac7} ચી\u{a82}ધતી તર\u{acd}જની"),
            keywords: &[
                "આ\u{a82}ગળી",
                "નીચી આ\u{a82}ગળી",
                "નીચ\u{ac7}ની બાજ\u{ac1} ચી\u{a82}ધાય\u{ac7}લી આ\u{a82}ગળી",
                "પહ\u{ac7}લી આ\u{a82}ગળી",
                "હાથની પાછલી બાજ\u{ac1}એથી નીચ\u{ac7} ચી\u{a82}ધતી તર\u{acd}જની",
                "હાથનો પાછલો ભાગ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan ali na baya mai nunawa ƙasa"),
            keywords: &[
                "bayan hannu",
                "hannu",
                "nuna",
                "yatsa",
                "ƙasa",
                "ɗan ali",
                "ɗan ali na baya mai nunawa ƙasa",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גב יד מצביעה למטה"),
            keywords: &[
                "אצבע",
                "גב יד מצביעה למטה",
                "יד",
                "להצביע",
                "למטה",
                "מצביעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पीछ\u{947} का हाथ और नीच\u{947} इशारा करती तर\u{94d}जनी"),
            keywords: &[
                "अ\u{902}ग\u{941}लि",
                "अ\u{902}ग\u{941}लि नीच\u{947}",
                "तर\u{94d}जनी अ\u{902}ग\u{941}लि",
                "नीच\u{947} इशारा करती ऊ\u{902}गली",
                "पीछ\u{947} का हाथ",
                "पीछ\u{947} का हाथ और नीच\u{947} इशारा करती तर\u{94d}जनी",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kažiprst koji pokazuje prema dolje"),
            keywords: &[
                "dolje",
                "kažiprst",
                "kažiprst koji pokazuje prema dolje",
                "pokazivanje",
                "prst",
                "šaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tenyér lefelé mutató ujjal"),
            keywords: &[
                "kéz",
                "lefelé",
                "mutatóujj",
                "tenyér",
                "tenyér lefelé mutató ujjal",
                "test",
                "ujj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("դեպի վար ուղղված ցուցամատ"),
            keywords: &[
                "դեպի վար ուղղված ցուցամատ",
                "ձեռք",
                "մատ",
                "մարմին",
                "ուղղված",
                "վար",
                "ցուցամատ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("menunjuk ke bawah"),
            keywords: &[
                "badan",
                "bawah",
                "jari",
                "menunjuk ke bawah",
                "tangan",
                "tengah",
                "tubuh",
                "tunjuk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("àzụaka na-arụ aka n’ala"),
            keywords: &[
                "aka",
                "ala",
                "mkpịsịaka",
                "na-arụ",
                "àzụaka",
                "àzụaka na-arụ aka n’ala",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fingur bendir niður"),
            keywords: &[
                "bakhönd bendir niður",
                "benda",
                "fingur",
                "fingur bendir niður",
                "hönd",
                "niður",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("indice abbassato"),
            keywords: &[
                "dito abbassato",
                "dito in giù",
                "dito indice",
                "indice abbassato",
                "indice in giù",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("下指差し"),
            keywords: &["下", "下指差し", "手", "指差し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("geger tangan nuding ngisor"),
            keywords: &[
                "driji",
                "geger tangan",
                "geger tangan nuding ngisor",
                "ngisor",
                "nuding",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელის ზურგიდან ქვემოთ დაშვერილი საჩვენებელი თითი"),
            keywords: &[
                "თითი",
                "მითითება",
                "საჩვენებელი",
                "სხეული",
                "ტანი",
                "ქვემოთ",
                "ხელი",
                "ხელის ზურგი",
                "ხელის ზურგიდან ქვემოთ დაშვერილი საჩვენებელი თითი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("төмен саусақпен қолды сыртқа қаратып көрсету"),
            keywords: &[
                "артқа",
                "көрсету",
                "саусақ",
                "төмен",
                "төмен саусақпен қолды сыртқа қаратып көрсету",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ned"),
            keywords: &[
                "finger",
                "finger peger ned",
                "ned",
                "pegefinger",
                "peger ned",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}អ\u{17bb}លទៅក\u{17d2}រោម"),
            keywords: &[
                "ក\u{17d2}រោម",
                "ខ\u{17d2}នងដៃ",
                "ចង\u{17d2}អ\u{17bb}ល",
                "ចង\u{17d2}អ\u{17bb}លទៅក\u{17d2}រោម",
                "ប\u{17d2}រអប\u{17cb}ដៃ",
                "ម\u{17d2}រាមដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some(
                "ಹ\u{cbf}ಂಬದ\u{cbf} ಕೈ ಕ\u{cc6}ಳಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು",
            ),
            keywords: &[
                "ಕ\u{cc6}ಳಕ\u{ccd}ಕ\u{cc6} ಬ\u{cc6}ರಳು",
                "ಕ\u{cc6}ಳಗ\u{cbf}ನ ಬ\u{cc6}ರಳು",
                "ಹ\u{cbf}ಂಬದ\u{cbf} ಕೈ ಕ\u{cc6}ಳಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("아래쪽을 가리키는 손등"),
            keywords: &[
                "검지손가락",
                "손가락 아래로",
                "손가락으로 아래를 가리키기",
                "아래",
                "아래를 가리키는 검지손가락",
                "아래쪽",
                "아래쪽을 가리키는 손등",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तर\u{94d}जनी सकयल\u{947} वट\u{947}न दाखोवपी हाताची फाट"),
            keywords: &[
                "तर\u{94d}जनी सकयल\u{947} वट\u{947}न दाखोवपी हाताची फाट",
                "दाखोवप",
                "बोट",
                "वयर",
                "हात",
                "हाताची फाट",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("төмөн жакты көрсөткөн сөөмөй"),
            keywords: &["кол", "сөөмөй", "төмөн", "төмөн жакты көрсөткөн сөөмөй"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no ënne weisende Fanger vun hanne gesinn"),
            keywords: &[
                "Fanger",
                "Hand",
                "Réckhand",
                "Zeigefanger",
                "no ënne weisende Fanger vun hanne gesinn",
                "no ënnen",
                "weisen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{ebc}\u{eb1}ງມ\u{eb7}ນ\u{eb5}\u{ec9}ວຊ\u{eb5}\u{ec9}ລ\u{ebb}ງ"),
            keywords: &[
                "ຊ\u{eb5}\u{ec9}",
                "ນ\u{eb4}\u{ec9}ວ",
                "ມ\u{eb7}",
                "ລ\u{ebb}ງ",
                "ຫ\u{ebc}\u{eb1}ງມ\u{eb7}ນ\u{eb5}\u{ec9}ວຊ\u{eb5}\u{ec9}ລ\u{ebb}ງ",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delnu nusukta žemyn pirštu rodanti ranka"),
            keywords: &[
                "delnu nusukta žemyn pirštu rodanti ranka",
                "indeksas",
                "pirštas",
                "ranka",
                "rodyti",
                "į apačią",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lejup vērsts rādītājpirksts"),
            keywords: &[
                "delna",
                "lejup vērsts rādītājpirksts",
                "pirksts",
                "roka",
                "rādīt",
                "rādītājpirksts",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōroa tāmuri tohu iho"),
            keywords: &["iho", "kōroa", "matimati", "ringa", "tohu", "tāmuri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("показалец свртен надолу"),
            keywords: &[
                "долу",
                "покажува",
                "показалец",
                "показалец свртен надолу",
                "прст",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
            ),
            keywords: &[
                "ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}",
                "കൈ",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d}",
                "ത\u{d3e}ഴേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന ച\u{d42}ണ\u{d4d}ട\u{d41}വിരൽ",
                "പ\u{d41}റംകൈ",
                "പോയന\u{d4d}റ\u{d41}ചെയ\u{d4d}യ\u{d41}ക",
                "വിരൽ",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("доошоо зааж буй алганы ард тал"),
            keywords: &[
                "гар",
                "гарын ар тал",
                "доошоо",
                "доошоо зааж буй алганы ард тал",
                "доошоо зааж буй долоовор хуруу",
                "хуруу",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी खाली दर\u{94d}शविण\u{947}",
            ),
            keywords: &[
                "खाली",
                "तर\u{94d}जनी",
                "दर\u{94d}शविण\u{947}",
                "बोट",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947}",
                "म\u{941}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी खाली दर\u{94d}शविण\u{947}",
                "म\u{941}ठ\u{94d}ठीच\u{94d}या मागील बाज\u{942}न\u{947} तर\u{94d}जनी खाली दर\u{94d}शविण\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari telunjuk belakang tangan tuding ke bawah"),
            keywords: &[
                "bawah",
                "belakang tangan",
                "jari",
                "jari telunjuk belakang tangan menunjuk ke bawah",
                "jari telunjuk belakang tangan tuding ke bawah",
                "tangan",
                "tunjuk",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("indiċi b’lura li jipponta ’l isfel"),
            keywords: &[
                "id",
                "indiċi",
                "indiċi b’lura",
                "indiċi b’lura li jipponta ’l isfel",
                "punt",
                "suba’",
                "’l isfel",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အောက\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ပြန\u{103a}",
                "လက\u{103a}ပြန\u{103a} အောက\u{103a}သ\u{102d}\u{102f}\u{1037} လ\u{102d}\u{102f}က\u{103a}ည\u{103e}\u{102d}\u{102f}းထ\u{102d}\u{102f}းနေပ\u{102f}\u{1036}",
                "အောက\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ပြန\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("peker ned – bakhånd"),
            keywords: &[
                "finger",
                "hånd",
                "pekende finger",
                "peker ned",
                "peker ned – bakhånd",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("तलतिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला"),
            keywords: &["तलतिर द\u{947}खाइरह\u{947}को उल\u{94d}टो हातको चोर औ\u{902}ला"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achterkant van hand met omlaag wijzende wijsvinger"),
            keywords: &[
                "achterkant van hand met omlaag wijzende wijsvinger",
                "hand",
                "hand met rug naar voren",
                "omlaag",
                "vinger",
                "wijsvinger",
                "wijzen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("peikar ned – bakhand"),
            keywords: &[
                "finger",
                "hand",
                "peikande finger",
                "peikar ned",
                "peikar ned – bakhand",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ତଳକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତର ପଛପଟ ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ତଳ",
                "ତଳକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତର ପଛପଟ ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ସ\u{b42}ଚୀତ କର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତର ପଛପଟ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some(
                "ਹ\u{a71}ਥ ਦਾ ਪਿਛਲਾ ਹਿ\u{a71}ਸਾ ਅਤ\u{a47} ਥ\u{a71}ਲ\u{a47} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲੀ",
            ),
            keywords: &[
                "ਇ\u{a70}ਡ\u{a48}ਕਸ ਉ\u{a02}ਗਲ",
                "ਉ\u{a02}ਗਲ",
                "ਥ\u{a71}ਲ\u{a47} ਇਸ\u{a3c}ਾਰਾ ਉ\u{a02}ਗਲ",
                "ਥ\u{a71}ਲ\u{a47} ਉ\u{a02}ਗਲ",
                "ਹ\u{a71}ਥ ਦਾ ਪਿਛਲਾ ਹਿ\u{a71}ਸਾ ਅਤ\u{a47} ਥ\u{a71}ਲ\u{a47} ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲੀ",
                "ਹ\u{a71}ਥ ਪਿਛਲਾ ਪਾਸਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ دے مخالف پاسیوں انگشت شہادت نال ہیٹھاں اشارہ کردیاں ہوئیاں"),
            keywords: &[
                "اشارہ کرنا",
                "ا\u{64f}نگل",
                "بیک ہینڈ",
                "ضمینہ",
                "ہتھ",
                "ہتھ دے مخالف پاسیوں انگشت شہادت نال ہیٹھاں اشارہ کردیاں ہوئیاں",
                "ہیٹھاں",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Daun"),
            keywords: &[
                "Bakhand",
                "Bakhánd Niá-Tọ\u{301}mb-Fínga De Pọínt Daun",
                "Daun",
                "Fínga",
                "Hand",
                "Pọint",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłoń z palcem wskazującym w dół"),
            keywords: &[
                "dół",
                "dłoń z palcem wskazującym w dół",
                "na dół",
                "palec",
                "w dół",
                "wskazujący",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("په شهادت ګوته لاس شاخوا لاندي اشاره کول"),
            keywords: &[
                "اشاره",
                "شهادت ګوته",
                "لاس",
                "لاس شاخوا",
                "لاندي",
                "په شهادت ګوته لاس شاخوا لاندي اشاره کول",
                "ګوته",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dorso da mão com dedo indicador apontando para baixo"),
            keywords: &[
                "costas da mão",
                "dedo",
                "dedo apontado para baixo",
                "dedo indicador",
                "dorso da mão com dedo indicador apontando para baixo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("costas da mão com dedo indicador a apontar para baixo"),
            keywords: &[
                "apontar",
                "corpo",
                "costas da mão",
                "costas da mão com dedo indicador a apontar para baixo",
                "dedo",
                "indicador",
                "mão",
                "para baixo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼupsi rukʼanawan uranman chimpuy"),
            keywords: &[
                "chimpuy",
                "jinchʼa",
                "maki",
                "rukana",
                "tʼupsi rukʼanawan uranman chimpuy",
                "uran",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dos de mână cu arătătorul în jos"),
            keywords: &[
                "arătător",
                "deget",
                "dos de mână cu arătătorul în jos",
                "dos de mână cu degetul arătător îndreptat în jos",
                "dosul palmei",
                "indica",
                "jos",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-516"),
            keywords: &["E10-516"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("указывающий вниз палец"),
            keywords: &["вниз", "палец", "указательный", "указывающий вниз палец"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("urutoki rutunze hasi"),
            keywords: &[
                "gutunga",
                "ikiganza",
                "mukubitarukoro",
                "rwerekeje hasi",
                "urutoki",
                "urutoki rutunze hasi",
                "werekeza inyuma",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي هٿ جي آڱر هيٺ اشارو ڪندي"),
            keywords: &[
                "آڱر",
                "اشارو ڪرڻ",
                "شهادت واري آڱر",
                "مٿي",
                "هٿ",
                "کاٻو هٿ",
                "کاٻي هٿ جي آڱر هيٺ اشارو ڪندي",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පහළට යොම\u{dd4} ව\u{dd6} අත ප\u{dd2}ට\u{dd4}පස දබරැඟ\u{dd2}ල\u{dca}ල"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "දබර",
                "පහළට එල\u{dca}ල කර",
                "පහළට යොම\u{dd4} ව\u{dd6} අත ප\u{dd2}ට\u{dd4}පස දබරැඟ\u{dd2}ල\u{dca}ල",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ukazovák spakruky nadol"),
            keywords: &["nadol", "prst", "ruka", "spakruky", "ukazovať", "ukazovák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("hrbtna stran dlani s kazalcem, ki kaže dol"),
            keywords: &[
                "dlan",
                "dol",
                "hrbtna stran",
                "hrbtna stran dlani s kazalcem, ki kaže dol",
                "kazalec",
                "kazati",
                "prst",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan tilmaamaysa hoos"),
            keywords: &[
                "far",
                "farta muujinta gacanta gadaale tilmaamaysa hoos",
                "gacan",
                "gacan tilmaamaysa hoos",
                "gacanta gadaale",
                "hoos",
                "tilmaam",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gisht tregues i drejtuar poshtë"),
            keywords: &["dorë", "gisht", "gisht tregues i drejtuar poshtë", "tregoj"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кажипрст који показује надоле отпозади"),
            keywords: &[
                "кaжипрст",
                "кажипрст који показује надоле отпозади",
                "надoлe",
                "пoкaзивaњe",
                "прст",
                "рукa",
                "тело",
                "шaкa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("кажипрст који показује надоље отпозади"),
            keywords: &["кажипрст који показује надоље отпозади"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kažiprst koji pokazuje nadole otpozadi"),
            keywords: &[
                "kažiprst",
                "kažiprst koji pokazuje nadole otpozadi",
                "nadole",
                "pokazivanje",
                "prst",
                "ruka",
                "telo",
                "šaka",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("kažiprst koji pokazuje nadolje otpozadi"),
            keywords: &["kažiprst koji pokazuje nadolje otpozadi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nedåtpekande finger"),
            keywords: &["finger", "nedåtpekande finger", "peka nedåt", "pekfinger"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidole cha kwanza kinachoelekeza chini kwa nyuma"),
            keywords: &[
                "cha shahada",
                "elekeza",
                "kidole",
                "kidole cha kwanza kinachoelekeza chini kwa nyuma",
                "kidole cha shahada kinachoelekeza chini kwa nyuma",
                "mkono",
                "nyuma ya mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "க\u{bc0}ழ\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரலின\u{bcd} பின\u{bcd}பக\u{bcd}கம\u{bcd}",
            ),
            keywords: &[
                "ஆள\u{bcd}க\u{bbe}ட\u{bcd}டி விரல\u{bcd}",
                "க\u{bc0}ழே",
                "க\u{bc0}ழ\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரலின\u{bcd} பின\u{bcd}பக\u{bcd}கம\u{bcd}",
                "க\u{bc0}ழ\u{bcd}நோக\u{bcd}கிக\u{bcd} க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}",
                "கை",
                "விரல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చూపుడు వ\u{c47}లు క\u{c3f}ంద\u{c3f}క\u{c3f} చూపుట"),
            keywords: &[
                "చూపుట",
                "చూపుడు వ\u{c47}లు క\u{c3f}ంద\u{c3f}క\u{c3f} చూపుట",
                "వ\u{c47}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ангушти ишорат ба поён ишора карда истода"),
            keywords: &[
                "ангушт",
                "ангушти ишорат ба поён ишора карда истода",
                "даст",
                "нишондиҳанда",
                "нуқта",
                "поён",
                "пушти даст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e34}\u{e49}วช\u{e35}\u{e49}ลง"),
            keywords: &[
                "ช\u{e35}\u{e49}",
                "น\u{e34}\u{e49}ว",
                "น\u{e34}\u{e49}วช\u{e35}\u{e49}ลง",
                "ม\u{e37}อ",
                "ลง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aşagy görkezýän el-arkasy süýem barmak"),
            keywords: &[
                "aşagy görkezýän el-arkasy süýem barmak",
                "aşak",
                "barmak",
                "el",
                "eliň arkasy",
                "görkezmek",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuhu tuʻanima tonu ki lalo"),
            keywords: &["tuhu tuʻanima tonu ki lalo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elinin tersiyle aşağıyı gösteren işaret parmağı"),
            keywords: &[
                "aşağıyı gösteren parmak",
                "elin arkası",
                "elinin tersiyle aşağıyı gösteren işaret parmağı",
                "işaret parmağı",
                "parmak",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئارقىچە ئاستىنى كۆرسەتكەن كۆرسەتكۈچ بارماق"),
            keywords: &[
                "ئارقىچە ئاستىنى كۆرسەتكەن كۆرسەتكۈچ بارماق",
                "ئاستى",
                "بارماق",
                "قول",
                "قولنىڭ ئارقىسى",
                "كۆرسىتىش",
                "كۆرسەتكۈچ بارماق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("палець тильним боком, що вказує вниз"),
            keywords: &[
                "вказівний",
                "палець",
                "палець тильним боком, що вказує вниз",
                "тильний",
                "указувати",
                "униз",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیچے اشارہ کرتی بیک ہینڈ شہادت کی انگلی"),
            keywords: &[
                "جسم",
                "شہادت کی انگلی",
                "نیچے",
                "نیچے اشارہ کرتی بیک ہینڈ شہادت کی انگلی",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘rsatkich barmoq pastga"),
            keywords: &[
                "barmoq",
                "koʻrsatish",
                "ko‘rsatkich barmog‘i orqa tomoni bilan pastga qarab turgan qo‘l",
                "ko‘rsatkich barmoq pastga",
                "pastga",
                "qoʻl",
                "qoʻl orqasi",
                "qoʻl orqasi va pastga qaratilgan koʻrsatkich barmoq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón trỏ trái chỉ xuống"),
            keywords: &[
                "mu bàn tay",
                "ngón tay",
                "ngón trỏ",
                "ngón trỏ trái chỉ xuống",
                "tay",
                "trỏ",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ginaaw loxo buy joxoñ ci suuf"),
            keywords: &[
                "baaraam",
                "baaraamu joxoñ",
                "ginaaw loxo buy joxoñ ci suuf",
                "ginaawu loxo",
                "joxoñ",
                "loxo",
                "suuf",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isalathiso somva wesandla esalatha ezantsi"),
            keywords: &[
                "ezantsi",
                "isalathiso",
                "isalathiso somva wesandla esalatha ezantsi",
                "isandla",
                "phezulu",
                "umnwe",
                "umva wesandla",
                "yalatha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹyin Ọwọ Ti O Tọka Si Isalẹ"),
            keywords: &[
                "tọ\u{301}ka",
                "ìka",
                "ìka kékeré",
                "ìsàlẹ\u{300}",
                "Ẹyin Ọwọ Ti O Tọka Si Isalẹ",
                "ẹ\u{300}yìn ọwọ\u{301}",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("反手指向下邊"),
            keywords: &["下", "反手", "反手指向下邊", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("反手指向下边"),
            keywords: &["下", "反手", "反手指向下边", "手", "手指", "指", "指向"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("反手食指向下指"),
            keywords: &["反手", "反手食指向下指", "向下指", "手", "指下", "食指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("下"),
            keywords: &["下", "手", "指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukukhomba phansi ngengemuva lesandla ngomunwe wokukhomba"),
            keywords: &[
                "isandla",
                "phansi",
                "ukukhomba",
                "ukukhomba phansi ngengemuva lesandla ngomunwe wokukhomba",
                "umunwe",
                "umunwe wokukhomba",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👇🏻"]
pub const BACKHAND_INDEX_POINTING_DOWN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👇🏻",
    codepoint: "1F447 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing down: light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👇🏼"]
pub const BACKHAND_INDEX_POINTING_DOWN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👇🏼",
    codepoint: "1F447 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing down: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👇🏽"]
pub const BACKHAND_INDEX_POINTING_DOWN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👇🏽",
    codepoint: "1F447 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing down: medium skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👇🏾"]
pub const BACKHAND_INDEX_POINTING_DOWN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👇🏾",
    codepoint: "1F447 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing down: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👇🏿"]
pub const BACKHAND_INDEX_POINTING_DOWN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👇🏿",
    codepoint: "1F447 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "backhand index pointing down: dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "☝\u{fe0f}"]
pub const INDEX_POINTING_UP: crate::Emoji = crate::Emoji {
    glyph: "☝\u{fe0f}",
    codepoint: "261D FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "index pointing up",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "☝",
        codepoint: "261D",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "index pointing up",
        group: "People & Body",
        subgroup: "hand-single-finger",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wysvinger wat op wys"),
            keywords: &[
                "hand",
                "liggaam",
                "op",
                "vinger",
                "wys",
                "wysvinger wat op wys",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ የተቀሰረ አመልካች ጣት"),
            keywords: &["ላይ", "ነጥብ", "እጅ", "ወደ ላይ የተቀሰረ አመልካች ጣት", "ጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سبابة يشير لأعلى"),
            keywords: &[
                "أعلى",
                "إشارة",
                "إصبع",
                "جسد",
                "سبابة",
                "سبابة يشير لأعلى",
                "يد",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("তৰ\u{9cd}জনী ওপৰলৈ নিৰ\u{9cd}দেশ কৰ\u{9be}"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "ওপৰ",
                "তৰ\u{9cd}জনী",
                "তৰ\u{9cd}জনী ওপৰলৈ নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "নিৰ\u{9cd}দেশ কৰ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("işarə barmağı"),
            keywords: &[
                "barmaq",
                "göstərmək",
                "işarə",
                "işarə barmağı",
                "yuxarı",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("указальны палец уверх"),
            keywords: &["палец", "рука", "угару", "указальны палец уверх", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Показалец нагоре"),
            keywords: &["Показалец нагоре", "нагоре", "показалец", "пръст", "соча"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("উপরের দিকে ইশ\u{9be}র\u{9be} কর\u{9be}"),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "আপ",
                "উপরের দিকে ইশ\u{9be}র\u{9be} কর\u{9be}",
                "পয\u{9bc}েন\u{9cd}ট",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kažiprst pokazuje gore"),
            keywords: &[
                "dlan",
                "gore",
                "kažiprst",
                "kažiprst pokazuje gore",
                "pokazivanje",
                "pokazivanje kažiprstom gore s okrenutim dlanom",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("índex que apunta cap amunt"),
            keywords: &["amunt", "índex", "índex que apunta cap amunt"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏎᎯ ᏩᏎᎯᎲᎢ ᎦᎸᎳᏗ"),
            keywords: &["ᎠᏎᎯ", "ᎠᏎᎯ ᏩᏎᎯᎲᎢ ᎦᎸᎳᏗ", "ᎤᏬᏱ", "ᎦᎸᎳᏗ", "ᎦᏰᏌᏛ", "ᏩᏎᏢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruka ukazující nahoru"),
            keywords: &[
                "nahoru",
                "prst",
                "ruka",
                "ruka ukazující nahoru",
                "tělo",
                "ukazovat",
                "ukazováček",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("mynegfys yn pwyntio i fyny"),
            keywords: &[
                "corff",
                "i fyny",
                "mynegfys",
                "mynegfys yn pwyntio i fyny",
                "pwyntio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("rækker finger op"),
            keywords: &[
                "finger",
                "hånd",
                "krop",
                "op",
                "opadvendt",
                "pege",
                "pegefinger",
                "rækker finger op",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("nach oben weisender Zeigefinger von vorne"),
            keywords: &[
                "Finger",
                "Hand",
                "Handvorderseite",
                "Zeigefinger",
                "nach oben",
                "nach oben weisender Zeigefinger von vorne",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δείκτης χεριού προς τα επάνω"),
            keywords: &[
                "δάχτυλο",
                "δείκτης",
                "δείκτης χεριού προς τα επάνω",
                "δείχνω",
                "επάνω",
                "σώμα",
                "χέρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("index pointing up"),
            keywords: &[
                "finger",
                "hand",
                "index",
                "index pointing up",
                "point",
                "up",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dedo índice hacia arriba"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo",
                "dedo índice hacia arriba",
                "mano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo",
                "dedo hacia arriba",
                "dedo índice hacia arriba",
                "mano",
                "palma",
                "señalar",
                "índice",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("dedo índice hacia arriba"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo índice hacia arriba",
                "señalar",
                "índice",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("dedo índice hacia arriba"),
            keywords: &[
                "apuntar",
                "arriba",
                "dedo índice hacia arriba",
                "señalar",
                "índice",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("üles osutav sõrm"),
            keywords: &[
                "keha",
                "käsi",
                "nimetissõrm",
                "osutamine",
                "sõrm",
                "üles osutav sõrm",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("gora seinalatzen ari den hatz erakuslea"),
            keywords: &[
                "erakusle",
                "esku",
                "gora seinalatzen ari den hatz erakuslea",
                "hatz",
                "seinalatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("اشاره به بالا"),
            keywords: &["اشاره", "اشاره به بالا", "انگشت", "بالا", "بدن", "دست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ylös osoittava etusormi"),
            keywords: &[
                "etusormi",
                "käsi",
                "osoittaa",
                "sormi",
                "vartalo",
                "ylös",
                "ylös osoittava etusormi",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hintuturo na nakaturo sa itaas"),
            keywords: &[
                "daliri",
                "hintuturo",
                "hintuturo na nakaturo sa itaas",
                "hintuturong nakaturo sa itaas",
                "kamay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lógvi og fremstifingur peikar uppeftir"),
            keywords: &[
                "fingur",
                "fremstifingur",
                "hond",
                "lógvi",
                "lógvi og fremstifingur peikar uppeftir",
                "peikifingur",
                "upp",
                "uppeftir",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("index pointant vers le haut"),
            keywords: &["doigt", "index", "index pointant vers le haut", "main"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("index pointant vers le haut"),
            keywords: &["index pointant vers le haut"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("corrmhéar ag díriú suas"),
            keywords: &[
                "corrmhéar",
                "corrmhéar ag díriú suas",
                "corrmhéar ag pointeáil suas",
                "lámh",
                "méar",
                "suas",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("colgag a’ tomhadh suas"),
            keywords: &[
                "colgag",
                "colgag a’ tomhadh suas",
                "corrag",
                "làmh",
                "meur",
                "suas",
                "tomhadh",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("índice apuntando cara arriba"),
            keywords: &[
                "advertencia",
                "arriba",
                "man",
                "índice",
                "índice apuntando cara arriba",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉપર ચી\u{a82}ધતી તર\u{acd}જની"),
            keywords: &[
                "આ\u{a82}ગળી",
                "ઉપર",
                "ઉપર ચી\u{a82}ધતી તર\u{acd}જની",
                "ચી\u{a82}ધતી",
                "પ\u{acd}રથમ આ\u{a82}ગળી",
                "શરીર",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗan ali mai nunawa sama"),
            keywords: &[
                "hannu",
                "nuna",
                "sama",
                "yatsa",
                "ɗan ali",
                "ɗan ali mai nunawa sama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מצביעה למעלה"),
            keywords: &["אצבע", "יד", "להצביע", "למעלה", "מצביעה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ऊपर की ओर इशारा करती तर\u{94d}जनी"),
            keywords: &[
                "उ\u{902}गली",
                "ऊपर",
                "ऊपर की ओर इशारा करती तर\u{94d}जनी",
                "पॉइ\u{902}ट",
                "शरीर",
                "स\u{942}चका\u{902}क",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kažiprst pokazuje gore"),
            keywords: &[
                "gore",
                "kažiprst",
                "kažiprst pokazuje gore",
                "pokazivanje",
                "prst",
                "šaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kéz felfelé mutató ujjal"),
            keywords: &[
                "felfelé",
                "kéz",
                "kéz felfelé mutató ujjal",
                "mutatóujj",
                "test",
                "ujj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վեր ուղղված ցուցամատ"),
            keywords: &[
                "ձեռք",
                "ձեռքի ափ",
                "մատ",
                "մարմին",
                "ուղղված",
                "վեր",
                "ցուցամատ",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("menunjuk ke atas"),
            keywords: &[
                "atas",
                "badan",
                "jari",
                "menunjuk ke atas",
                "tangan",
                "telunjuk",
                "tubuh",
                "tunjuk",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-arụ aka n’elu"),
            keywords: &["aka", "mkpịsịaka", "na-arụ", "n’elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vísifingur bendir upp"),
            keywords: &[
                "benda",
                "benda upp",
                "fingur",
                "hönd",
                "vísifingur",
                "vísifingur bendir upp",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("indice verso l’alto"),
            keywords: &[
                "dito",
                "dito verso l’alto",
                "indicare",
                "indice verso l’alto",
                "tu",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上指差し"),
            keywords: &["上", "上指差し", "手", "指差し"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("driji panuduh ngacung"),
            keywords: &[
                "driji",
                "driji panuduh",
                "driji panuduh ngacung",
                "ngacung",
                "nuding",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ზემოთ აშვერილი საჩვენებელი თითი"),
            keywords: &[
                "ზემოთ",
                "ზემოთ აშვერილი საჩვენებელი თითი",
                "თითი",
                "მითითება",
                "საჩვენებელი",
                "სხეული",
                "ტანი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жоғарыға саусақпен көрсету"),
            keywords: &[
                "жоғары",
                "жоғарыға саусақпен көрсету",
                "индекс",
                "көрсету",
                "саусақ",
                "саусақпен жоғары көрсету",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("opadvendt pegefinger"),
            keywords: &[
                "finger",
                "hånd",
                "krop",
                "op",
                "opadvendt",
                "pege",
                "pegefinger",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ចង\u{17d2}អ\u{17bb}លទៅលើ"),
            keywords: &[
                "ចង\u{17d2}អ\u{17bb}ល",
                "ចង\u{17d2}អ\u{17bb}លទៅលើ",
                "ដៃចង\u{17d2}អ\u{17bb}ល",
                "ប\u{17d2}រអប\u{17cb}ដៃ",
                "ម\u{17d2}រាមដៃ",
                "លើ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು"),
            keywords: &[
                "ಬ\u{cc6}ರಳು",
                "ಮೇಲಕ\u{ccd}ಕ\u{cc6} ತೋರ\u{cbf}ಸುತ\u{ccd}ತ\u{cbf}ರುವುದು",
                "ಮೇಲ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("위쪽을 가리키는 손"),
            keywords: &["가리키기", "검지", "위쪽을 가리키는 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तर\u{94d}जनी वयर दाखयता"),
            keywords: &["तर\u{94d}जनी", "दाखयता", "बोट", "वयर", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өйдө жакты көрсөткөн сөөмөй"),
            keywords: &[
                "кол",
                "көрсөт",
                "сөөмөйү өйдө караган кол",
                "өйдө",
                "өйдө жакты көрсөткөн сөөмөй",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("no uewe weisende Fanger"),
            keywords: &[
                "Fanger",
                "Hand",
                "Zeigefanger",
                "no uewe weisende Fanger",
                "no uewen",
                "weisen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຝ\u{ec8}າມ\u{eb7}ນ\u{eb5}\u{ec9}ວຊ\u{eb5}\u{ec9}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຂ\u{eb6}\u{ec9}ນ",
                "ຊ\u{eb5}\u{ec9}",
                "ນ\u{eb4}\u{ec9}ວ",
                "ຝ\u{ec8}າມ\u{eb7}ນ\u{eb5}\u{ec9}ວຊ\u{eb5}\u{ec9}ຂ\u{eb6}\u{ec9}ນ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("delnu atsukta aukštyn pirštu rodanti ranka"),
            keywords: &[
                "delnu atsukta aukštyn pirštu rodanti ranka",
                "indeksas",
                "pirštas",
                "ranka",
                "rodyti",
                "į viršų",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšup vērsts rādītājpirksts"),
            keywords: &[
                "augšup vērsts rādītājpirksts",
                "delna",
                "pirksts",
                "roka",
                "rādīt",
                "rādītājpirksts",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōroa tohu ake"),
            keywords: &["ake", "kōroa", "matimati", "ringa", "tohu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("показалец нагоре"),
            keywords: &[
                "горе",
                "покажува",
                "показалец",
                "показалец нагоре",
                "показалец свртен нагоре",
                "прст",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന വിരൽ"),
            keywords: &[
                "ഇൻഡക\u{d4d}\u{200c}സ\u{d4d}",
                "കൈ",
                "ച\u{d42}ണ\u{d4d}ട\u{d41}ക",
                "പോയന\u{d4d}റ\u{d41}ചെയ\u{d4d}യ\u{d41}ക",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d}",
                "മ\u{d41}കളിലേക\u{d4d}ക\u{d4d} ച\u{d42}ണ\u{d4d}ട\u{d41}ന\u{d4d}ന വിരൽ",
                "വിരൽ",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("дээшээг зааж байгаа"),
            keywords: &["гар", "дээшээ", "дээшээг зааж байгаа", "заах", "хуруу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("वर दर\u{94d}शविणारी तर\u{94d}जनी"),
            keywords: &[
                "तर\u{94d}जनी",
                "दर\u{94d}शविणारी",
                "दर\u{94d}शविण\u{947}",
                "बोट",
                "वर",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari telunjuk menunjuk ke atas"),
            keywords: &[
                "hala ke atas",
                "jari",
                "jari telunjuk menunjuk ke atas",
                "tangan",
                "telunjuk",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("indiċi li jipponta ’l fuq"),
            keywords: &[
                "id",
                "indiċi",
                "indiċi li jipponta ’l fuq",
                "ipponta",
                "suba’",
                "’l fuq",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ည\u{103e}\u{102d}\u{102f}း",
                "လက\u{103a}ည\u{103e}\u{102d}\u{102f}းထောင\u{103a}ခြင\u{103a}း",
                "အပေါ\u{103a}သ\u{102d}\u{102f}\u{1037} ည\u{103d}\u{103e}န\u{103a}ပြနေသည\u{1037}\u{103a} အည\u{103d}\u{103e}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("peker opp"),
            keywords: &[
                "finger",
                "hånd",
                "kropp",
                "opp",
                "peke",
                "pekefinger",
                "peker opp",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("माथितिर द\u{947}खाइरह\u{947}को चोर औ\u{902}ला"),
            keywords: &[
                "औ\u{902}ला",
                "माथि",
                "माथितिर द\u{947}खाइरह\u{947}को चोर औ\u{902}ला",
                "शरीर",
                "स\u{902}क\u{947}त",
                "स\u{942}चक",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("omhoog wijzende wijsvinger"),
            keywords: &[
                "hand",
                "omhoog",
                "omhoog wijzende wijsvinger",
                "vinger",
                "wijsvinger",
                "wijzen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("peikar opp"),
            keywords: &[
                "finger",
                "hand",
                "kropp",
                "opp",
                "peikar opp",
                "peike",
                "peikefinger",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଉପରକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ଉପର",
                "ଉପରକ\u{b41} ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ତର\u{b4d}ଜନୀ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ସ\u{b42}ଚୀତ କର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲ"),
            keywords: &[
                "ਇ\u{a70}ਡ\u{a48}ਕਸ ਉ\u{a02}ਗਲ",
                "ਉ\u{a02}ਗਲ",
                "ਉ\u{a71}ਪਰ ਵ\u{a71}ਲ ਇਸ\u{a3c}ਾਰਾ ਕਰਦੀ ਉ\u{a02}ਗਲ",
                "ਮ\u{a48}\u{a02} ਜਿ\u{a71}ਤਿਆ",
                "ਮ\u{a48}\u{a02} ਪਹਿਲ\u{a47} ਨ\u{a70}ਬਰ ‘ਤ\u{a47} ਹਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اوتے اشارہ کردی شہادت آلی ا\u{64f}نگل"),
            keywords: &[
                "اشارہ کرنا",
                "اوتے اشارہ کردی شہادت آلی ا\u{64f}نگل",
                "ا\u{64f}نگل",
                "ا\u{64f}وتے",
                "ضمینہ",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Niá-Tọ\u{301}mb-Fínga De Pọínt Ọp"),
            keywords: &[
                "Fínga",
                "Hand",
                "Niá-Tọ\u{301}mb-Fínga",
                "Niá-Tọ\u{301}mb-Fínga De Pọínt Ọp",
                "Pọint",
                "Ọp",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("palec wskazujący w górę"),
            keywords: &[
                "do góry",
                "góra",
                "palec",
                "palec wskazujący w górę",
                "w górę",
                "wskazujący",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("شهادت ګوته پورته نیول"),
            keywords: &[
                "شهادت ګوته",
                "شهادت ګوته پورته نیول",
                "لاس",
                "پورته",
                "ګوته",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("indicador apontando para cima"),
            keywords: &[
                "dedo",
                "dedo apontando para cima",
                "indicador",
                "indicador apontando para cima",
                "mão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("dedo indicador a apontar para cima"),
            keywords: &[
                "apontar",
                "dedo",
                "dedo indicador a apontar para cima",
                "indicador",
                "mão",
                "para cima",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rukʼanawan hanaqman chimpuy"),
            keywords: &[
                "chimpuy",
                "hanaq",
                "indice",
                "maki",
                "rukana",
                "rukʼanawan hanaqman chimpuy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("deget arătător îndreptat în sus"),
            keywords: &[
                "deget",
                "deget arătător îndreptat în sus",
                "indicator",
                "sus",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-051"),
            keywords: &["E10-051"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("указательный палец вверх"),
            keywords: &["вверх", "направление", "палец", "рука", "указательный"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("gutunga mukubitarukoko hejuru"),
            keywords: &[
                "gutunga",
                "gutunga mukubitarukoko hejuru",
                "heju",
                "ikiganza",
                "mukubitarukoko",
                "urutoki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("آڱر مٿي طرف اشارو ڪندي"),
            keywords: &[
                "آڱر",
                "آڱر مٿي طرف اشارو ڪندي",
                "اشارو ڪرڻ",
                "شهادت واري آڱر",
                "هٿ",
                "کاٻو هٿ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉහළට යොම\u{dd4} ව\u{dd6} දබරැඟ\u{dd2}ල\u{dca}ල"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "ඉහළට",
                "ඉහළට යොම\u{dd4} ව\u{dd6} දබරැඟ\u{dd2}ල\u{dca}ල",
                "ලක\u{dca}ෂ\u{dca}\u{200d}ය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ukazovák nahor"),
            keywords: &["nahor", "prst", "ruka", "ukazovať", "ukazovák"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kazalec, ki kaže gor"),
            keywords: &[
                "dlan",
                "gor",
                "kazalec",
                "kazalec, ki kaže gor",
                "kazati",
                "prst",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("farta muujinta tilmaamaysa kor"),
            keywords: &[
                "far",
                "farta muujinta tilmaamaysa kor",
                "gacan",
                "kor",
                "muujinta",
                "muujinta tilmaamaysa kor",
                "tilmaam",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gisht tregues që tregon lart"),
            keywords: &["dorë", "gisht", "gisht tregues që tregon lart", "tregues"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кажипрст који показује нагоре"),
            keywords: &[
                "гoрe",
                "кaжипрст",
                "кажипрст који показује нагоре",
                "пoкaзивaњe",
                "прст",
                "рукa",
                "тело",
                "шaкa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["кажипрст који показује нагоре"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kažiprst koji pokazuje nagore"),
            keywords: &[
                "gore",
                "kažiprst",
                "kažiprst koji pokazuje nagore",
                "pokazivanje",
                "prst",
                "ruka",
                "telo",
                "šaka",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["kažiprst koji pokazuje nagore"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("finger upp"),
            keywords: &["finger", "finger upp", "förmaning", "peka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kidole cha shahada kinachoelekeza juu"),
            keywords: &[
                "cha shahada",
                "elekeza",
                "juu",
                "kidole",
                "kidole cha shahada kinachoelekeza juu",
                "mkono",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மேல\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}"),
            keywords: &[
                "மேலே",
                "மேல\u{bcd} நோக\u{bcd}கி க\u{bbe}ட\u{bcd}டும\u{bcd} விரல\u{bcd}",
                "மேல\u{bcd}நோக\u{bcd}கிய விரல\u{bcd}",
                "விரல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చూపుడు వ\u{c47}లు ప\u{c48}క\u{c3f} చూపుట"),
            keywords: &[
                "చూపుట",
                "చూపుడు వ\u{c47}లు ప\u{c48}క\u{c3f} చూపుట",
                "వ\u{c47}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ангушти ишорат ба боло ишора карда истода"),
            keywords: &[
                "ангушт",
                "ангушти ишорат ба боло ишора карда истода",
                "боло",
                "даст",
                "нишондиҳанда",
                "нуқта",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e34}\u{e49}วช\u{e35}\u{e49}ข\u{e36}\u{e49}น"),
            keywords: &[
                "ข\u{e36}\u{e49}น",
                "ช\u{e35}\u{e49}",
                "น\u{e34}\u{e49}ว",
                "น\u{e34}\u{e49}วช\u{e35}\u{e49}ข\u{e36}\u{e49}น",
                "ม\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýokaryny görkezýän süýem barmak"),
            keywords: &[
                "barmak",
                "el",
                "görkezmek",
                "süýem",
                "ýokary",
                "ýokaryny görkezýän süýem barmak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuhu tonu ki ʻolunga"),
            keywords: &["tuhu tonu ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yukarıyı gösteren işaret parmağı"),
            keywords: &[
                "beden",
                "el",
                "gösterme",
                "işaret parmağı",
                "parmak",
                "yukarı",
                "yukarıyı gösteren işaret parmağı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۈستىنى كۆرسەتكەن كۆرسەتكۈچ بارماق"),
            keywords: &[
                "ئۈستى",
                "ئۈستىنى كۆرسەتكەن كۆرسەتكۈچ بارماق",
                "بارماق",
                "قول",
                "كۆرسىتىش",
                "كۆرسەتكۈچ بارماق",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вказівний палець, що вказує вгору"),
            keywords: &[
                "вказівний",
                "вказівний палець, що вказує вгору",
                "палець",
                "рука",
                "угору",
                "указувати",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوپر اشارہ کرتی شہادت کی انگلی"),
            keywords: &[
                "انگلی",
                "اوپر",
                "اوپر اشارہ کرتی شہادت کی انگلی",
                "جسم",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘rsatkich barmoq tepada"),
            keywords: &[
                "barmoq",
                "ko‘rsatkich",
                "ko‘rsatkich barmog‘i tepaga qarab turgan qo‘l",
                "ko‘rsatkich barmoq tepada",
                "qo‘l",
                "tana",
                "tepaga",
                "yo‘naltirish",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón trỏ chỉ lên trên"),
            keywords: &[
                "chỉ",
                "lên",
                "ngón tay",
                "ngón trỏ",
                "ngón trỏ chỉ lên trên",
                "tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baaraamu joxoñ buy joxoñ ci kaw"),
            keywords: &[
                "baaraam",
                "baaraamu joxoñ",
                "baaraamu joxoñ buy joxoñ ci kaw",
                "joxoñ",
                "kaw",
                "loxo",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isalathiso esalatha phezulu"),
            keywords: &[
                "isalathiso",
                "isalathiso esalatha phezulu",
                "isandla",
                "phezulu",
                "umnwe",
                "yalatha",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìka kékeré tí ń tọ\u{301}ka sókè"),
            keywords: &[
                "sókè",
                "tọ\u{301}ka",
                "ìka",
                "ìka kékeré",
                "ìka kékeré tí ń tọ\u{301}ka sókè",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("指向上邊"),
            keywords: &["上", "手", "手指", "指", "指向", "指向上邊"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("指向上边"),
            keywords: &["上", "手", "手指", "指", "指向", "指向上边"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("食指向上指"),
            keywords: &["向上指", "手", "指上", "食指", "食指向上指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("注意"),
            keywords: &["提示", "注意"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umunwe wokukhomba okhombe phezulu"),
            keywords: &[
                "isandla",
                "ukukhomba",
                "umunwe",
                "umunwe wokukhomba",
                "umunwe wokukhomba okhombe phezulu",
                "umzimba",
            ],
        },
    ],
};
#[doc = "☝🏻"]
pub const INDEX_POINTING_UP_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "☝🏻",
    codepoint: "261D 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "index pointing up: light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "☝🏼"]
pub const INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "☝🏼",
    codepoint: "261D 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "index pointing up: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "☝🏽"]
pub const INDEX_POINTING_UP_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "☝🏽",
    codepoint: "261D 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "index pointing up: medium skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "☝🏾"]
pub const INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "☝🏾",
    codepoint: "261D 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "index pointing up: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "☝🏿"]
pub const INDEX_POINTING_UP_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "☝🏿",
    codepoint: "261D 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "index pointing up: dark skin tone",
    group: "People & Body",
    subgroup: "hand-single-finger",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
