#[doc = "✍\u{fe0f}"]
pub const WRITING_HAND: crate::Emoji = crate::Emoji {
    glyph: "✍\u{fe0f}",
    codepoint: "270D FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "writing hand",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✍",
        codepoint: "270D",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "writing hand",
        group: "People & Body",
        subgroup: "hand-prop",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hand wat skryf"),
            keywords: &["hand", "hand wat skryf", "liggaam", "skryf"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እየጻፈ ያለ እጅ"),
            keywords: &["መጻፍ", "አካል", "እየጻፈ ያለ እጅ", "እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يد تكتب"),
            keywords: &["كتابة", "يد", "يد تكتب"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("লিখি থক\u{9be} হ\u{9be}ত"),
            keywords: &["লিখ\u{9be}", "লিখি থক\u{9be} হ\u{9be}ত", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yazı əli"),
            keywords: &["orqan", "yazmaq", "yazı əli", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пішучая рука"),
            keywords: &["асадка", "пісьмо", "пішучая рука", "рука", "ручка"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Пишеща ръка"),
            keywords: &["Пишеща ръка", "пиша", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("লেখ\u{9be}র হ\u{9be}ত"),
            keywords: &["লেখ\u{9be}", "লেখ\u{9be}র হ\u{9be}ত", "শরীর", "হ\u{9be}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruka koja piše"),
            keywords: &["pisanje", "ruka", "ruka koja piše"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mà que escriu"),
            keywords: &["escriure", "mà", "mà que escriu"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏬᏱ ᎪᏪᎳᏅᎢ"),
            keywords: &["ᎤᏬᏱ", "ᎤᏬᏱ ᎪᏪᎳᏅᎢ", "ᎪᏪᎶᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("píšící ruka"),
            keywords: &["psát", "píšící ruka", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwylo yn ysgrifennu"),
            keywords: &["corff", "dwylo yn ysgrifennu", "llaw", "ysgrifennu"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("skrivende hånd"),
            keywords: &["hånd", "skrive", "skrivende hånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("schreibende Hand"),
            keywords: &["Hand", "Schreiben", "schreiben", "schreibende Hand"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χέρι που γράφει"),
            keywords: &["γράφω", "σώμα", "χέρι", "χέρι που γράφει"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("writing hand"),
            keywords: &["hand", "write", "writing hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano escribiendo"),
            keywords: &["cuerpo", "escribir", "lápiz", "mano", "mano escribiendo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mano escribiendo"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["escribir", "mano", "mano escribiendo"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kirjutav käsi"),
            keywords: &["keha", "kirjutamine", "kirjutav käsi", "käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("idazten ari den eskua"),
            keywords: &["esku", "gorputz", "idatzi", "idazten ari den eskua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نوشتن با دست"),
            keywords: &["دست", "نوشتن", "نوشتن با دست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kirjoittava käsi"),
            keywords: &["kirjoittaa", "kirjoittava käsi", "käsi", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nagsusulat na kamay"),
            keywords: &["kamay", "nagsusulat", "nagsusulat na kamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("skrivandi hond"),
            keywords: &["hond", "skriva", "skrivandi hond"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main qui écrit"),
            keywords: &["main", "main qui écrit", "écrire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["main", "main qui écrit", "écrire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh scríbhneoireachta"),
            keywords: &[
                "corp",
                "lámh",
                "lámh scríbhneoireachta",
                "lámha ag scríobh",
                "scríbhneoireacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh a’ sgrìobhadh"),
            keywords: &["làmh", "làmh a’ sgrìobhadh", "sgrìobh", "sgrìobhadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("man escribindo"),
            keywords: &["bolígrafo", "escribir", "lapis", "man", "man escribindo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("લખી રહ\u{ac7}લો હાથ"),
            keywords: &[
                "લખતો",
                "લખવ\u{ac1}\u{a82}",
                "લખાણ",
                "લખી રહ\u{ac7}લો હાથ",
                "શરીર",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hannu mai rubutawa"),
            keywords: &["hannu", "hannu mai rubutawa", "rubuta"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד כותבת"),
            keywords: &["יד", "כותבת", "כתב יד", "כתיבה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("लिखता ह\u{941}आ हाथ"),
            keywords: &["लिखता ह\u{941}आ हाथ", "लिखना", "शरीर", "हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruka koja piše"),
            keywords: &["pisanje", "ruka", "ruka koja piše", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("író kéz"),
            keywords: &["kéz", "test", "írás", "író kéz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("գրող ձեռք"),
            keywords: &["գրել", "գրող ձեռք", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan menulis"),
            keywords: &[
                "badan",
                "nulis",
                "tangan",
                "tangan menulis",
                "tubuh",
                "tulis",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka na-ede ihe"),
            keywords: &["aka", "aka na-ede ihe", "dèe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("skrifandi hönd"),
            keywords: &["hönd", "líkami", "skrifa", "skrifandi hönd"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano che scrive"),
            keywords: &["mano che scrive", "scrivere", "scrivere a mano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("書いている手"),
            keywords: &["手", "手で書く", "手書き", "書いている手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan nulis"),
            keywords: &["nulis", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელი, რომელიც წერს"),
            keywords: &["სხეული", "ტანი", "წერა", "ხელი", "ხელი, რომელიც წერს"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қолмен жазу"),
            keywords: &["дене", "жазу", "қол", "қолмен жазу"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("skrivende hånd"),
            keywords: &["hånd", "krop", "skrive", "skrivende hånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដៃកាន\u{17cb}ប\u{17ca}\u{17b7}ចសរសេរ"),
            keywords: &[
                "ដៃកាន\u{17cb}ប\u{17ca}\u{17b7}កសរសេរ",
                "ដៃកាន\u{17cb}ប\u{17ca}\u{17b7}ចសរសេរ",
                "ប\u{17ca}\u{17b7}ក",
                "ប\u{17ca}\u{17b7}ច",
                "សរសេរ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬರ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಕೈ"),
            keywords: &["ಬರ\u{cc6}ಯುತ\u{ccd}ತ\u{cbf}ರುವ ಕೈ", "ಬರ\u{cc6}ಯುವ ಕೈ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("글을 쓰고 있는 손"),
            keywords: &["글을 쓰고 있는 손", "손", "연필 쥔 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बरोवपाचो हात"),
            keywords: &["बरोवपाचो हात", "हात । बरोवप । बरोवपाचो हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жазып жаткан кол"),
            keywords: &["дене", "жаз", "жазып жаткан кол", "кол"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("schreiwend Hand"),
            keywords: &["Hand", "schreiwen", "schreiwend Hand"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ມ\u{eb7}ກຳລ\u{eb1}ງຂຽນ"),
            keywords: &["ຂຽນ", "ມ\u{eb7}", "ມ\u{eb7}ກຳລ\u{eb1}ງຂຽນ", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("rašanti ranka"),
            keywords: &["ranka", "rašanti ranka", "rašyti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("rakstoša roka"),
            keywords: &["rakstoša roka", "rakstīt", "roka", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa tuhituhi"),
            keywords: &["ringa", "ringa tuhituhi", "tuhi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рака што пишува"),
            keywords: &["пишува", "рака", "рака што пишува", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("എഴ\u{d41}ത\u{d41}ന\u{d4d}ന കൈ"),
            keywords: &[
                "എഴ\u{d41}ത\u{d41}ക",
                "എഴ\u{d41}ത\u{d41}ന\u{d4d}ന കൈ",
                "കൈ",
                "കൈയ\u{d4d}യെഴ\u{d41}ത\u{d4d}ത\u{d4d}",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("бичиж байгаа гар"),
            keywords: &["бичиж байгаа гар", "бичих", "гар", "үзэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("लिखाण करणारा हात"),
            keywords: &["लिखाण करणारा हात", "लिहिण\u{947}", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tangan menulis"),
            keywords: &["badan", "tangan", "tangan menulis", "tulis"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id li tikteb biha"),
            keywords: &["id", "id li tikteb biha", "tikteb"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စာရေးနေသည\u{1037}\u{103a} လက\u{103a}"),
            keywords: &[
                "စာရေးခြင\u{103a}း",
                "စာရေးနေသည\u{1037}\u{103a} လက\u{103a}",
                "စာရေးနေသော လက\u{103a}",
                "လက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("skrivende hånd"),
            keywords: &["hånd", "kropp", "skrive", "skrivende hånd"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ल\u{947}खिरह\u{947}को हात"),
            keywords: &[
                "ल\u{947}खिरह\u{947}को हात",
                "ल\u{947}ख\u{94d}न\u{947}",
                "शरीर",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("schrijvende hand"),
            keywords: &["hand", "schrijven", "schrijvende hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("skrivande hand"),
            keywords: &["hand", "kropp", "skrivande hand", "skrive"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଲେଖ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ"),
            keywords: &["ଲେଖ\u{b3f}ବ\u{b3e}", "ହ\u{b3e}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲਿਖਣਾ, ਲਿਖਾਈ"),
            keywords: &[
                "ਲਿਖਣ ਵਾਲਾ ਹ\u{a71}ਥ",
                "ਲਿਖਣਾ",
                "ਲਿਖਣਾ, ਲਿਖਾਈ",
                "ਲਿਖਾਵਟ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("لکھائی کردا ہتھ"),
            keywords: &["لکھائی کردا ہتھ", "لکھنا", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand Wé De Raít Sọ\u{301}mtin"),
            keywords: &["Hand", "Hand Wé De Raít Sọ\u{301}mtin", "Rait"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pisząca dłoń"),
            keywords: &["pisać", "pisać odręcznie", "pisząca dłoń", "piszę"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لیکونکې لاس"),
            keywords: &["لاس", "لیکل", "لیکونکې لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("escrevendo à mão"),
            keywords: &["caneta", "escrevendo", "escrevendo à mão", "mão"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão a escrever"),
            keywords: &["corpo", "escrever", "mão", "mão a escrever"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("maki qillqachkan"),
            keywords: &["maki", "maki qillqachkan", "qillqay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mână scriind"),
            keywords: &["mână", "mână scriind", "scris"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-128"),
            keywords: &["E10-128"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("пишущая рука"),
            keywords: &["бумага", "письмо", "пишущая рука", "рука", "ручка"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganza cyandika"),
            keywords: &["ikiganza cyandika", "intoki", "kwandikisha"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لکندڙ هٿ"),
            keywords: &["لکندڙ هٿ", "لکڻ", "هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ල\u{dd2}යම\u{dd2}න\u{dca} ස\u{dd2}ට\u{dd2}න අත"),
            keywords: &[
                "අත",
                "ල\u{dd2}යම\u{dd2}න\u{dca} ස\u{dd2}ට\u{dd2}න අත",
                "ල\u{dd2}ව\u{dd3}ම",
                "ශර\u{dd3}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("píšuca ruka"),
            keywords: &["pero", "písať", "píšuca ruka", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pišoča dlan"),
            keywords: &["dlan", "pisati", "pišoča dlan", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan wax qoraysa"),
            keywords: &["gacan", "gacan wax qoraysa", "qor"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorë që shkruan"),
            keywords: &["dorë", "dorë që shkruan", "shkruaj", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рука која пише"),
            keywords: &["писaњe", "рукa", "рука која пише"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рука која пише"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ruka koja piše"),
            keywords: &["pisanje", "ruka", "ruka koja piše"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ruka koja piše"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hand som skriver"),
            keywords: &["hand", "hand som skriver", "skriver"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono unaoandika"),
            keywords: &["andika", "mkono", "mkono unaoandika", "mwili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எழுதுதல\u{bcd}"),
            keywords: &["எழுது", "எழுதுதல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c4d}ర\u{c3e}స\u{c4d}తున\u{c4d}న చ\u{c47}య\u{c3f}"),
            keywords: &[
                "చ\u{c47}య\u{c3f}",
                "వ\u{c4d}ర\u{c3e}యడం",
                "వ\u{c4d}ర\u{c3e}స\u{c4d}తున\u{c4d}న చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дасти навишта истода"),
            keywords: &["даст", "дасти навишта истода", "навиштан"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เข\u{e35}ยนหน\u{e31}งส\u{e37}อ"),
            keywords: &[
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
                "เข\u{e35}ยน",
                "เข\u{e35}ยนหน\u{e31}งส\u{e37}อ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýazýan el"),
            keywords: &["el", "ýazmak", "ýazýan el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima ʻoku tohi"),
            keywords: &["nima ʻoku tohi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yazı yazan el"),
            keywords: &["beden", "el", "yazma", "yazı yazan el"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("يېزىۋاتقان قول"),
            keywords: &["قول", "يېزىش", "يېزىۋاتقان قول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рука, що пише"),
            keywords: &["писати", "рука", "рука, що пише", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("لکھتا ہوا ہاتھ"),
            keywords: &["جسم", "لکھتا ہوا ہاتھ", "لکھنا", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yozayotgan qo‘l"),
            keywords: &["qo‘l", "tana", "yozayotgan qo‘l", "yozish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn tay đang viết"),
            keywords: &["bàn tay đang viết", "tay", "viết"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo buy bind"),
            keywords: &["bind", "loxo", "loxo buy bind"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandla esibhalayo"),
            keywords: &["bhala", "isandla", "isandla esibhalayo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ńkọ\u{301}wé"),
            keywords: &["kọ\u{300}wé", "ńkọ\u{301}wé", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("寫字嘅手"),
            keywords: &["寫字", "寫字嘅手", "手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("写字嘅手"),
            keywords: &["写字", "写字嘅手", "手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("写字"),
            keywords: &["写", "写字", "笔"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("寫"),
            keywords: &["寫", "書寫", "記錄"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla esibhalayo"),
            keywords: &["isandla", "isandla esibhalayo", "ukubhala", "umzimba"],
        },
    ],
};
#[doc = "✍🏻"]
pub const WRITING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✍🏻",
    codepoint: "270D 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "writing hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✍🏼"]
pub const WRITING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✍🏼",
    codepoint: "270D 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "writing hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✍🏽"]
pub const WRITING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✍🏽",
    codepoint: "270D 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "writing hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✍🏾"]
pub const WRITING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✍🏾",
    codepoint: "270D 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "writing hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✍🏿"]
pub const WRITING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✍🏿",
    codepoint: "270D 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "writing hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💅"]
pub const NAIL_POLISH: crate::Emoji = crate::Emoji {
    glyph: "💅",
    codepoint: "1F485",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "nail polish",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("naellak"),
            keywords: &[
                "kosmetiek",
                "liggaam",
                "manikuur",
                "nael",
                "naellak",
                "verf",
                "versorg",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የጥፍር ቀለም"),
            keywords: &["እንክብካቤ", "ኮስሞቲክስ", "የጣት ውበት ጥበቃ", "የጥፍር ቀለም", "ጥፍር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("طلاء أظافر"),
            keywords: &[
                "أظافر",
                "تهذيب أظافر",
                "طلاء أظافر",
                "مانكير",
                "مستحضرات تجميل",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("নেইল প’লিচ"),
            keywords: &[
                "কছমেটিক\u{9cd}স",
                "নখ",
                "নেইল প’লিচ",
                "প’লিচ",
                "মেনিকিয\u{9bc}ৰ",
                "যত\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dırnaq laklamaq"),
            keywords: &[
                "dırnaq",
                "dırnaq laklamaq",
                "kosmetika",
                "lak",
                "manikür",
                "orqan",
                "qulluq",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лак для ногцяў"),
            keywords: &["догляд", "касметыка", "лак для ногцяў", "ногці", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Лак за нокти"),
            keywords: &["Лак за нокти", "козметика", "лак", "маникюр", "нокти"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("নেল পলিশ"),
            keywords: &[
                "নখ",
                "নেল পলিশ",
                "প\u{9be}লিশ",
                "প\u{9cd}রস\u{9be}ধনী",
                "ম\u{9cd}য\u{9be}নিকিউর",
                "যত\u{9cd}ন",
                "শরীর",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("lakiranje noktiju"),
            keywords: &[
                "kozmetika",
                "lak za nokte",
                "lakiranje noktiju",
                "nokti",
                "uljepšavanje",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("esmalt d’ungles"),
            keywords: &[
                "cosmètics",
                "esmalt",
                "esmalt d’ungles",
                "manicura",
                "ungla",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏑᎦᏢ ᎦᏅᎵᏰᏗ"),
            keywords: &["ᎠᎦᏎᏍᏙᏗ", "ᎠᏓᏅᎵᏰᏙᏗ", "ᎤᏑᎦᏢ", "ᎦᏅᎵᏰᏗ", "ᏗᏍᏙᏰᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("lak na nehty"),
            keywords: &[
                "kosmetika",
                "lak",
                "lak na nehty",
                "manikúra",
                "nehet",
                "péče",
                "tělo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("farnais ewinedd"),
            keywords: &["corff", "ewyn", "farnais ewinedd", "gofal", "triniaeth"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("neglelak"),
            keywords: &["kosmetik", "manicure", "negle", "neglelak"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nagellack"),
            keywords: &["Kosmetik", "Maniküre", "Nagel", "Nagellack", "Nagelpflege"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("βάψιμο νυχιών"),
            keywords: &[
                "βάψιμο νυχιών",
                "βερνίκι",
                "καλλυντικά",
                "μανικιούρ",
                "νύχι",
                "σώμα",
                "φροντίδα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nail polish"),
            keywords: &["care", "cosmetics", "manicure", "nail", "polish"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pintarse las uñas"),
            keywords: &[
                "cosmética",
                "esmalte",
                "manicura",
                "pintarse las uñas",
                "uñas",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pintarse las uñas"),
            keywords: &["esmalte", "pintarse las uñas", "uñas"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pintarse las uñas"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("küünelakk"),
            keywords: &[
                "hooldus",
                "keha",
                "kosmeetika",
                "küünelakk",
                "küüs",
                "lakk",
                "maniküür",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("azazkaletako esmaltea"),
            keywords: &[
                "azazkal",
                "azazkaletako esmaltea",
                "edertasun",
                "esmalte",
                "gorputz",
                "kosmetika",
                "manikura",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لاک زدن"),
            keywords: &["آرایش", "رسیدگی", "لاک", "لاک زدن", "مانیکور", "ناخن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kynsilakka"),
            keywords: &[
                "kosmetiikka",
                "kynsi",
                "kynsihuolto",
                "kynsilakka",
                "manikyyri",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nail polish"),
            keywords: &[
                "cosmetics",
                "daliri",
                "kamay",
                "kuko",
                "manicure",
                "nail polish",
                "polish",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("neglalakk"),
            keywords: &["fríðkanarevni", "negl", "neglalakk", "vakurleikarøkt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("vernis à ongles"),
            keywords: &["maquillage", "vernis à ongles"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &[
                "manucure",
                "maquillage",
                "ongle",
                "vernis",
                "vernis à ongles",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("vearnais ingne"),
            keywords: &["cosmaidí", "smideadh", "vearnais ingne"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("lìomh ìnean"),
            keywords: &["cùram", "làmh-mhaiseachadh", "lìomh", "maise", "ìnean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pintar as uñas"),
            keywords: &["cosmético", "esmalte", "manicura", "pintar as uñas", "uñas"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ન\u{ac7}ઇલ પોલિશ"),
            keywords: &[
                "કોસ\u{acd}મ\u{ac7}ટિક\u{acd}સ",
                "નખ",
                "નખની સ\u{a82}ભાળ",
                "ન\u{ac7}ઇલ પોલિશ",
                "હાથ તથા નખની સાજસ\u{a82}ભાળ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("jan farce"),
            keywords: &[
                "farce",
                "jan farce",
                "kayan shafawa",
                "kula",
                "mai",
                "yankan farce",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מריחת לק"),
            keywords: &[
                "טיפוח",
                "לק",
                "מניקור",
                "מריחת לק",
                "מריחת לק על ציפורניים",
                "ציפורניים",
                "קוסמטיקה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("न\u{947}ल पॉलिश"),
            keywords: &[
                "कॉस\u{94d}म\u{947}टिक",
                "नाख\u{942}न",
                "नाख\u{942}नो\u{902} की द\u{947}खर\u{947}ख",
                "न\u{947}ल पॉलिश",
                "म\u{947}नीक\u{94d}योर",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("lak za nokte"),
            keywords: &["kozmetika", "lak", "lak za nokte", "manikura", "nokti"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("körömlakk"),
            keywords: &["kifestés", "köröm", "körömlakk", "lakk", "manikűr"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եղունգների լաքապատում"),
            keywords: &[
                "եղունգ",
                "եղունգների լաքապատում",
                "խնամք",
                "կոսմետիկա",
                "հղկել",
                "մատնահարդարում",
                "մարմին",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("poles kuku"),
            keywords: &[
                "cat kuku",
                "kosmetik",
                "kuku",
                "manikur",
                "perawatan",
                "poles kuku",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nteji mbọaka"),
            keywords: &[
                "mbọ",
                "mkpụcha aka",
                "nleta",
                "nteji",
                "nteji mbọaka",
                "ọtanjele",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("naglalakk"),
            keywords: &["handsnyrting", "naglalakk", "neglur", "snyrtivörur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("smalto per unghie"),
            keywords: &["cosmetici", "manicure", "smalto", "smalto per unghie"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("マニキュアを塗る手"),
            keywords: &["ネイル", "マニキュア", "マニキュアを塗る手", "爪"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cet kuku"),
            keywords: &["cet kuku", "kosmetik", "kuku", "menikur", "ngrumat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფრჩხილების ლაქი"),
            keywords: &[
                "კოსმეტიკა",
                "მანიკური",
                "მოვლა",
                "სხეული",
                "ტანი",
                "ფრჩხილების ლაქი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("маникюр"),
            keywords: &["бояу", "косметика", "күтім", "маникюр", "тырнақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("neglelak"),
            keywords: &["kosmetik", "negle", "neglelak"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លាបថ\u{17d2}នា\u{17c6}ក\u{17d2}រចក"),
            keywords: &["ក\u{17d2}រចក", "លាបថ\u{17d2}នា\u{17c6}ក\u{17d2}រចក"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನೈಲ\u{ccd} ಪಾಲೀಷ\u{ccd}"),
            keywords: &[
                "ಉಗುರು ಪಾಲ\u{cbf}ಷ\u{ccd}",
                "ನೈಲ\u{ccd} ಪಾಲೀಷ\u{ccd}",
                "ಹಸ\u{ccd}ತಾಲಂಕಾರ ಮಾಡು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("매니큐어"),
            keywords: &["네일 아트", "네일 케어", "매니큐어"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("न\u{947}ल पॉलिश"),
            keywords: &[
                "जतन । सौ\u{902}दर\u{94d}यप\u{94d}रसाधन । म\u{945}निक\u{94d}य\u{941}अर ।न\u{947}ल पॉलिश",
                "न\u{947}ल पॉलिश",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тырмак боёо"),
            keywords: &[
                "косметика",
                "маникюр",
                "тырмак",
                "тырмак боёо",
                "өзүнө кам көрүү",
            ],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Neellack"),
            keywords: &["Kosmetik", "Lack", "Manikür", "Neel", "Neellack", "fleegen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທາເລ\u{eb1}ບມ\u{eb7}"),
            keywords: &["ທາເລ\u{eb1}ບ", "ທາເລ\u{eb1}ບມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nagų lakas"),
            keywords: &[
                "kosmetika",
                "lakas",
                "manikiūras",
                "nagų lakas",
                "priežiūra",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("nagu laka"),
            keywords: &[
                "kosmētika",
                "laka",
                "manikīrs",
                "nagi",
                "nagu laka",
                "skaistumkopšana",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("pani maikūkū"),
            keywords: &[
                "maikūkū",
                "pani",
                "tiaki",
                "whakapai maikūkū",
                "whakapaipai",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лак за нокти"),
            keywords: &["козметика", "лак за нокти", "маникир", "нега", "нокти"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നെയിൽ പോളിഷ\u{d4d}"),
            keywords: &[
                "കോസ\u{d4d}\u{200c}മെറ\u{d4d}റിക\u{d4d}\u{200c}സ\u{d4d}",
                "നഖം",
                "നെയിൽ പോളിഷ\u{d4d}",
                "പരിരക\u{d4d}ഷ",
                "പോളിഷ\u{d4d}",
                "മ\u{d3e}നിക\u{d4d}യ\u{d42}ർ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хумсаа будах"),
            keywords: &["арчлах", "косметик", "маникур", "хумс", "хумсаа будах"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("न\u{947}ल पॉलीश"),
            keywords: &[
                "नख",
                "निगा",
                "निगा राखण\u{947}",
                "न\u{947}ल पॉलीश",
                "पॉलीश",
                "सौ\u{902}दर\u{94d}य प\u{94d}रसाधन\u{947}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("pengilat kuku"),
            keywords: &["kosmetik", "kuku", "pengilat", "penjagaan", "rias tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("nail polish"),
            keywords: &[
                "dwiefer",
                "kosmetiċi",
                "kura",
                "manicure",
                "nail polish",
                "polish",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}သည\u{103a}း ဆ\u{102d}\u{102f}းဆေး"),
            keywords: &[
                "ပြ\u{102f}စ\u{102f}သည\u{103a}",
                "လက\u{103a}သည\u{103a}း",
                "လက\u{103a}သည\u{103a}း ဆ\u{102d}\u{102f}းဆေး",
                "လက\u{103a}သည\u{103a}းည\u{103e}ပ\u{103a}ခြင\u{103a}း",
                "အလ\u{103e}ပြင\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("neglelakk"),
            keywords: &["kosmetikk", "manikyr", "negl", "neglelakk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नङ पालिस"),
            keywords: &[
                "नङ पालिस",
                "नङ\u{94d}",
                "पालिस",
                "म\u{94d}यानिक\u{94d}य\u{941}र",
                "श\u{94d}र\u{943}ङ\u{94d}गार",
                "ह\u{947}रचाह",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("nagellak"),
            keywords: &[
                "cosmetica",
                "lak",
                "manicure",
                "nagel",
                "nagellak",
                "verzorging",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("naglelakk"),
            keywords: &["kosmetikk", "manikyr", "nagl", "naglelakk"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନଖ ପ\u{b3e}ଲ\u{b3f}ସ\u{b4d}\u{200c}"),
            keywords: &[
                "ନଖ",
                "ନଖ ପ\u{b3e}ଲ\u{b3f}ସ\u{b4d}\u{200c}",
                "ପ\u{b3e}ଲ\u{b3f}ସ\u{b4d}\u{200c} କର\u{b3f}ବ\u{b3e}",
                "ପ\u{b4d}ରସ\u{b3e}ଧନ",
                "ଯତ\u{b4d}ନ",
                "ହ\u{b3e}ତ ଓ ନଖର ସୌଦର\u{b4d}ଯ\u{b4d}ୟବର\u{b4d}ଦ\u{b4d}ଧକ ପର\u{b3f}ଚର\u{b4d}ଯ\u{b4d}ୟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a47}ਲ ਪਾਲਿਸ\u{a3c}"),
            keywords: &[
                "ਨਹ\u{a41}\u{a70} ਦੀ ਦ\u{a47}ਖਭਾਲ",
                "ਨਹ\u{a41}\u{a70} ਪਾਲਸ\u{a3c}",
                "ਨ\u{a47}ਲ ਪਾਲਿਸ\u{a3c}",
                "ਮ\u{a48}ਨੀਕਿਓਰ",
                "ਸ\u{a3c}ਿ\u{a70}ਗਾਰ ਸਮਾਨ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نوں پالش"),
            keywords: &[
                "احتیاط",
                "سنگھار دا سامان",
                "نوں پالش",
                "ن\u{64f}و",
                "پالش",
                "ہتھاں دی صفائی",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Nél Pọ\u{301}lish"),
            keywords: &[
                "Kia",
                "Kọsmẹ\u{301}tiks",
                "Nel",
                "Nél Pọ\u{301}lish",
                "To Lúk Áftá Yọ Nel an Hand",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("lakier do paznokci"),
            keywords: &[
                "ciało",
                "kosmetyki",
                "lakier do paznokci",
                "lakierować paznokcie",
                "manicure",
                "pielęgnacja",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("نوکانو رنګ"),
            keywords: &[
                "رنګ",
                "مانیکیور",
                "نوک",
                "نوکانو رنګ",
                "پاملرنه",
                "کاسمټکیس",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("esmalte de unha"),
            keywords: &["cosméticos", "esmalte", "esmalte de unha", "unhas"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("verniz para as unhas"),
            keywords: &[
                "cosméticos",
                "manicura",
                "unha",
                "verniz",
                "verniz para as unhas",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("esmalte sillukunapaq"),
            keywords: &[
                "cosmeticos",
                "esmalte",
                "esmalte sillukunapaq",
                "manicura",
                "qhaway",
                "sillu",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ojă pe unghii"),
            keywords: &[
                "lac de unghii",
                "manichiură",
                "ojă",
                "ojă pe unghii",
                "unghie",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-578"),
            keywords: &["E10-578"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("маникюр"),
            keywords: &[
                "кисть с лаком",
                "лак для ногтей",
                "маникюр",
                "ногти",
                "уход за руками",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("verini y’inzara"),
            keywords: &[
                "amavuta yo kwisiga",
                "gusiga inzara",
                "inzara",
                "kwitak ku ntoki n’nzara",
                "kwiyitaho",
                "mubiri",
                "verini y’inzara",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ننهن پالش"),
            keywords: &[
                "رنگڻ",
                "سنڀال",
                "سينگار",
                "ننهن",
                "ننهن مکڻي",
                "ننهن پالش",
                "ننهن ڪتڻ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dd2}ය ආලේපන"),
            keywords: &[
                "අත\u{dca} සහ න\u{dd2}ය අලංක\u{dcf}රකරණය",
                "අලේපන",
                "න\u{dd2}ය ආලේපන",
                "ව\u{dd2}ලව\u{dd4}න\u{dca}",
                "සත\u{dca}ක\u{dcf}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("lakovanie nechtov"),
            keywords: &[
                "kozmetika",
                "lak",
                "lakovanie nechtov",
                "manikúra",
                "necht",
                "starostlivosť",
                "telo",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("lak za nohte"),
            keywords: &[
                "kozmetika",
                "lak",
                "lak za nohte",
                "manikira",
                "nega",
                "noht",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhalaalinta ciddiyaha"),
            keywords: &[
                "ciddi",
                "daryeel",
                "dhalaalinta",
                "dhalaalinta ciddiyaha",
                "qurxinta",
                "qurxinta ciddiyaha",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("manikyr"),
            keywords: &["kozmetikë", "kujdes", "lyej", "manikyr", "thua"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("лак за нокте"),
            keywords: &["кoзмeтикa", "лак за нокте", "мaникир", "нeгa", "нoкaт"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["лак за нокте"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("lak za nokte"),
            keywords: &["kozmetika", "lak za nokte", "manikir", "nega", "nokat"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["lak za nokte"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nagellack"),
            keywords: &["manikyr", "måla naglar", "nagellack", "smink"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("rangi ya kupaka kwenye kucha"),
            keywords: &[
                "kucha",
                "mwili",
                "rangi",
                "rangi ya kupaka kwenye kucha",
                "tengeneza kucha",
                "tunza",
                "vipodozi",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நகச\u{bcd}ச\u{bbe}யம\u{bcd}"),
            keywords: &[
                "அழகுப\u{bcd}பொருட\u{bcd}கள\u{bcd}",
                "நகச\u{bcd}ச\u{bbe}யம\u{bcd}",
                "நகப\u{bcd}பூச\u{bcd}சு",
                "நகம\u{bcd}",
                "பர\u{bbe}மரிப\u{bcd}பு",
                "மெனிக\u{bcd}கியூர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c4b}ర\u{c4d}ల రంగు"),
            keywords: &["గ\u{c4b}ర\u{c4d}ల రంగు", "గ\u{c4b}ళ\u{c4d}లు", "రంగు"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("лок барои нохунҳо"),
            keywords: &[
                "косметика",
                "лок",
                "лок барои нохунҳо",
                "маникюр",
                "нохун",
                "ғамхорӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ส\u{e35}ทาเล\u{e47}บ"),
            keywords: &["ทำเล\u{e47}บ", "ส\u{e35}ทาเล\u{e47}บ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dyrnak lagy"),
            keywords: &[
                "dyrnak",
                "dyrnak lagy",
                "ideg",
                "kosmetika",
                "lak",
                "manikýur",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("valivali ngeʻesinima"),
            keywords: &["valivali ngeʻesinima"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("oje sürme"),
            keywords: &["kozmetik", "manikür", "oje", "oje sürme", "tırnak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىرناق بوياش"),
            keywords: &[
                "ئاسراش",
                "تىرناق",
                "تىرناق ئېلىش",
                "تىرناق بوياش",
                "خېنە",
                "گىرىم",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("лак для нігтів"),
            keywords: &[
                "догляд",
                "косметика",
                "лак для нігтів",
                "манікюр",
                "ніготь",
                "тіло",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("نیل پالش"),
            keywords: &["جسم", "خیال", "ناخن", "نیل پالش", "پالش"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tirnoq uchun lok"),
            keywords: &[
                "kosmetika",
                "lok",
                "manikyur",
                "parvarish",
                "tana",
                "tirnoq",
                "tirnoq uchun lok",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("sơn móng tay"),
            keywords: &[
                "chăm sóc",
                "làm móng tay",
                "móng tay",
                "mỹ phẩm",
                "sơn móng tay",
                "đánh bóng",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("jakkal wew"),
            keywords: &["faj", "jakkal wew", "jekkal", "kosmetik", "manikiir", "wew"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ipolishi yeenzipho"),
            keywords: &[
                "i-manicure",
                "ipolishi",
                "ipolishi yeenzipho",
                "izinto zokuchokoza",
                "ukhathalelo",
                "uzipho",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ikun Eekanna"),
            keywords: &[
                "Ikun Eekanna",
                "aṣaralóge",
                "kíkùn",
                "àkun ojú",
                "èékánná",
                "ìtọ\u{301}jú",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("指甲油"),
            keywords: &["修甲", "化妝品", "指甲", "指甲油", "護理"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("指甲油"),
            keywords: &["修甲", "化妆品", "护理", "指甲", "指甲油"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("涂指甲油"),
            keywords: &["指甲油", "涂指甲油", "美甲"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("指甲油"),
            keywords: &["指甲油", "美甲"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhyutheksi"),
            keywords: &[
                "amakhozimetiksi",
                "ikhyutheksi",
                "ukucwala izinzipho",
                "ukunakekela",
                "umzimba",
                "uzipho",
            ],
        },
    ],
};
#[doc = "💅🏻"]
pub const NAIL_POLISH_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💅🏻",
    codepoint: "1F485 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nail polish: light skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💅🏼"]
pub const NAIL_POLISH_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💅🏼",
    codepoint: "1F485 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nail polish: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💅🏽"]
pub const NAIL_POLISH_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💅🏽",
    codepoint: "1F485 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nail polish: medium skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💅🏾"]
pub const NAIL_POLISH_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💅🏾",
    codepoint: "1F485 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nail polish: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💅🏿"]
pub const NAIL_POLISH_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💅🏿",
    codepoint: "1F485 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nail polish: dark skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤳"]
pub const SELFIE: crate::Emoji = crate::Emoji {
    glyph: "🤳",
    codepoint: "1F933",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "selfie",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("selfie"),
            keywords: &["foon", "kamera", "selfie"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እራስ ፎቶ ማንሳት"),
            keywords: &["ስልክ", "እራስ ፎቶ ማንሳት", "ካሜራ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("صورة سيلفي"),
            keywords: &["سيلفي", "صورة سيلفي", "كاميرا", "هاتف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ছেল\u{9cd}\u{200c}ফি"),
            keywords: &["কেমেৰ\u{9be}", "ছেল\u{9cd}\u{200c}ফি", "ফোন"],
        },
        #[cfg(feature = "ast")]
        crate::Annotation {
            lang: "ast",
            tts: Some("selfie"),
            keywords: &["selfie"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("özçəkim"),
            keywords: &["foto", "selfi", "özçəkim", "şəkil"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэлфі"),
            keywords: &["сэлфі", "тэлефон", "фота"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("селфи"),
            keywords: &["камера", "селфи", "телефон"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("সেলফি"),
            keywords: &["ক\u{9cd}য\u{9be}মের\u{9be}", "ফোন", "সেলফি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("emboltred"),
            keywords: &["emboltred"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("selfi"),
            keywords: &["fotoaparat", "selfi", "slikanje", "telefon"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("autofoto"),
            keywords: &["autofoto", "càmera", "foto", "mòbil", "selfie"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏮᏌ ᏗᏓᏟᎶᏍᏔᏅᎢ"),
            keywords: &["ᎣᏮᏌ ᏗᏓᏟᎶᏍᏔᏅᎢ", "ᏗᏟᎶᏗᏍᎩᏍᎩ", "ᏗᏟᏃᎮᏗᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("selfie"),
            keywords: &["fotoaparát", "selfie", "selfíčko", "telefon"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("hunlun"),
            keywords: &["camera", "ffôn", "hunlun"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("selfie"),
            keywords: &[
                "arm",
                "foto",
                "fotografere",
                "fotografi",
                "kamera",
                "mobil",
                "mobiltelefon",
                "selfie",
                "tager billeder",
                "tager selfies",
                "telefon",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Selfie"),
            keywords: &["Selfie", "Smartphone"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("selfie"),
            keywords: &[
                "selfie",
                "κάμερα",
                "σέλφι",
                "τηλέφωνο",
                "φωτογραφική μηχανή",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("selfie"),
            keywords: &["camera", "phone", "selfie"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("selfi"),
            keywords: &["autofoto", "cámara", "selfi", "selfie", "teléfono"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("selfie"),
            keywords: &["autofoto", "cámara", "selfie", "teléfono"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("selfi"),
            keywords: &["celular", "cámara", "móvil", "selfi", "teléfono"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("selfi"),
            keywords: &["selfi"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("selfi"),
            keywords: &["kaamera", "selfi", "telefon"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("autoargazkia"),
            keywords: &["autoargazki", "autoargazkia", "kamera", "telefono"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("خودگرفت"),
            keywords: &["خودگرفت", "سلفی", "عکس از خود"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("selfie"),
            keywords: &["kamera", "omakuva", "puhelin", "selfie"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("selfie"),
            keywords: &["camera", "mobile phone", "selfie", "telepono"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sjálvsmynd"),
            keywords: &["selfie", "sjálvsmynd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("selfie"),
            keywords: &["appareil photo", "selfie", "téléphone"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("autophoto"),
            keywords: &["appareil photo", "autophoto", "selfie", "téléphone"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("féinín"),
            keywords: &["ceamara", "féinín", "fón", "guthán"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fèineag"),
            keywords: &["camara", "fèineag", "fòn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("autofoto"),
            keywords: &["autofoto", "cámara", "foto", "teléfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}લ\u{acd}ફી"),
            keywords: &["ક\u{ac5}મરા", "ફોન", "સ\u{ac7}લ\u{acd}ફી"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hoton kanka"),
            keywords: &["hoton kanka", "kyamara", "waya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מצלמת סלפי"),
            keywords: &["טלפון", "יד מצלמת סלפי", "מצלמה", "סלפי"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{947}ल\u{94d}फ\u{93c}ी"),
            keywords: &["क\u{948}मरा", "फ\u{93c}ोन", "स\u{947}ल\u{94d}फ\u{93c}ी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("selfie"),
            keywords: &["fotoaparat", "selfie", "slikanje", "telefon"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szelfi"),
            keywords: &["fényképező", "szelfi", "telefon"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սելֆի"),
            keywords: &["լուսանկար", "հեռախոս", "սելֆի"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("selfie"),
            keywords: &["foto selfie", "kamera", "ponsel", "selfi", "selfie"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("selfi"),
            keywords: &["ekwenti", "igwefòto", "selfi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("sjálfa"),
            keywords: &["myndavél", "sjálfa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("selfie"),
            keywords: &["autoscatto", "fotocamera", "selfie", "telefono"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("セルフィー"),
            keywords: &["スマホ", "セルフィー", "自分撮り", "自撮り"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("foto selfi"),
            keywords: &["foto selfi", "hp", "kamera", "selfi"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("სელფი"),
            keywords: &["კამერა", "სელფი", "ტელეფონი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("селфи"),
            keywords: &["селфи"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("selfie"),
            keywords: &[
                "arm",
                "foto",
                "fotograf",
                "fotograferer",
                "fotografi",
                "kamera",
                "mobil",
                "mobiltelefon",
                "selfie",
                "tager billeder",
                "telefon",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("selfie"),
            keywords: &[
                "selfie",
                "កាមេរ\u{17c9}ា",
                "ថត",
                "ទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸ\u{cc6}ಲ\u{ccd}ಫ\u{cbf}"),
            keywords: &["ಕ\u{ccd}ಯಾಮರಾ", "ಫೋನ\u{ccd}", "ಸ\u{cc6}ಲ\u{ccd}ಫ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("셀카"),
            keywords: &["사진", "셀카", "셀피", "카메라"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("स\u{947}ल\u{94d}फी"),
            keywords: &["क\u{945}म\u{947}रा", "फोन", "स\u{947}ल\u{94d}फी"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("селфи"),
            keywords: &["селфи", "сүрөт", "телефон"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Selfie"),
            keywords: &["Handy", "Kamera", "Selfie"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຊວຟ\u{eb5}"),
            keywords: &[
                "ກ\u{ec9}ອງຖ\u{ec8}າຍຮ\u{eb9}ບ",
                "ເຊວຟ\u{eb5}",
                "ໂທລະສ\u{eb1}ບ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("asmenukė"),
            keywords: &["asmenukė", "fotoaparatas", "telefonas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pašfoto"),
            keywords: &["kamera", "pašfoto", "tālrunis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kiriāhua"),
            keywords: &["kiriāhua", "kāmera", "waea"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("селфи"),
            keywords: &["камера", "селфи", "телефон"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("സെൽഫി"),
            keywords: &["ക\u{d4d}യ\u{d3e}മറ", "ഫോൺ", "സെൽഫി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("селфи"),
            keywords: &["селфи"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("स\u{947}ल\u{94d}फी"),
            keywords: &["क\u{945}म\u{947}रा", "फोन", "स\u{947}ल\u{94d}फी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("swafoto"),
            keywords: &["kamera", "selfie", "swafoto", "telefon"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("stessu"),
            keywords: &["kamera", "stessu", "telefown"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဆ\u{1032}လ\u{103a}ဖ\u{102e}"),
            keywords: &[
                "ကင\u{103a}မရာ",
                "ဆ\u{1032}လ\u{103a}ဖ\u{102e}",
                "ဖ\u{102f}န\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("selfie"),
            keywords: &["kamera", "selfie", "telefon"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{947}ल\u{94d}फी"),
            keywords: &["क\u{94d}याम\u{947}रा", "फोन", "स\u{947}ल\u{94d}फी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("selfie"),
            keywords: &["camera", "selfie", "telefoon"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("selfie"),
            keywords: &["kamera", "selfie", "telefon"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସେଲଫ\u{b3f}"),
            keywords: &[
                "କ\u{b4d}ୟ\u{b3e}ମେର\u{b3e}",
                "ଫୋନ\u{b4d}\u{200c}",
                "ସେଲଫ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a48}ਲਫੀ"),
            keywords: &["ਕ\u{a48}ਮਰਾ", "ਫ\u{a3c}\u{a4b}ਨ", "ਸ\u{a48}ਲਫੀ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سیلفی"),
            keywords: &["سیلفی", "فون", "کیمرہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Sẹ\u{301}lfi"),
            keywords: &["Fon", "Kámẹ\u{301}ra", "Sẹ\u{301}lfi"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("selfie"),
            keywords: &["aparat", "selfie", "telefon", "zdjęcie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سيلفي"),
            keywords: &["سيلفي", "فون", "کامره"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("selfie"),
            keywords: &["camera", "celular", "foto", "selfie", "smartphone"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["câmara", "selfie", "telemóvel"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("selfie"),
            keywords: &["camara", "selfie", "telefono"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("selfie"),
            keywords: &["aparat de fotografiat", "selfie", "telefon"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1045"),
            keywords: &["E10-1045"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("селфи"),
            keywords: &["селфи", "снимок", "телефон"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("serifi"),
            keywords: &["kamera", "kwifotora", "serifi", "telefone"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سيلفي"),
            keywords: &["سيلفي", "فون", "ڪئميرا"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("සෙල\u{dca}ෆ\u{dd2}"),
            keywords: &["කැමර\u{dcf}ව", "ද\u{dd4}රකථනය", "සෙල\u{dca}ෆ\u{dd2}"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("selfie"),
            keywords: &["selfie", "telefón"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("selfi"),
            keywords: &["fotoaparat", "kamera", "mobilni telefon", "selfi"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sawir iska-qaadis"),
            keywords: &["kamarad", "sawir iska-qaadis", "taleefoon"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("foto vetjake"),
            keywords: &["foto vetjake", "kamerë", "sellfi", "telefon", "vetjake"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("селфи"),
            keywords: &["кaмерa", "селфи", "телефон"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["селфи"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("selfi"),
            keywords: &["kamera", "selfi", "telefon"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["selfi"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("selfie"),
            keywords: &["kamera", "selfie", "telefon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("selfi"),
            keywords: &["kamera", "selfi", "simu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("செல\u{bcd}ஃபி"),
            keywords: &["கேமர\u{bbe}", "செல\u{bcd}ஃபி", "மொபைல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("స\u{c46}ల\u{c4d}ఫ\u{c40}"),
            keywords: &[
                "క\u{c46}మ\u{c46}ర\u{c3e}",
                "ఫ\u{c4b}న\u{c4d}",
                "స\u{c46}ల\u{c4d}ఫ\u{c40}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("селфи"),
            keywords: &["камера", "селфи", "телефон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เซลฟ\u{e35}\u{e48}"),
            keywords: &["กล\u{e49}อง", "ม\u{e37}อถ\u{e37}อ", "เซลฟ\u{e35}\u{e48}"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("selfi"),
            keywords: &["kamera", "selfi", "telefon"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("faitaaʻi pē kita"),
            keywords: &["faitaaʻi pē kita"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("selfie"),
            keywords: &["kamera", "selfie", "telefon"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئۆزتارتىم"),
            keywords: &["ئۆزتارتىم", "تېلېفون", "كامېرا"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("селфі"),
            keywords: &["автопортрет", "камера", "селфі", "телефон"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سیلفی"),
            keywords: &["تصویر", "سیلفی", "فون", "کیمرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("selfi"),
            keywords: &["kamera", "selfi", "telefon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tự sướng"),
            keywords: &["máy ảnh", "tự sướng", "điện thoại"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("selfie"),
            keywords: &["nataalukaay", "selfie", "telefon"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iselfi"),
            keywords: &["ifowuni", "ikhamera", "iselfi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Yiya Ara ẹni"),
            keywords: &[
                "Yiya Ara ẹni",
                "fóònù",
                "fọ\u{301}tò àdáyà",
                "kámẹ\u{301}rà",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("自拍"),
            keywords: &["手機", "相機", "自拍"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("自拍"),
            keywords: &["手机", "相机", "自拍"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("自拍"),
            keywords: &["手机", "相机", "自拍"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("自拍"),
            keywords: &["拍", "自", "自拍"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uzishuthe"),
            keywords: &["ifoni", "ikhamela", "ukuzishutha", "uzishuthe"],
        },
    ],
};
#[doc = "🤳🏻"]
pub const SELFIE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤳🏻",
    codepoint: "1F933 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "selfie: light skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤳🏼"]
pub const SELFIE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤳🏼",
    codepoint: "1F933 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "selfie: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤳🏽"]
pub const SELFIE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤳🏽",
    codepoint: "1F933 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "selfie: medium skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤳🏾"]
pub const SELFIE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤳🏾",
    codepoint: "1F933 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "selfie: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤳🏿"]
pub const SELFIE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤳🏿",
    codepoint: "1F933 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "selfie: dark skin tone",
    group: "People & Body",
    subgroup: "hand-prop",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
