#[doc = "👌"]
pub const OK_HAND: crate::Emoji = crate::Emoji {
    glyph: "👌",
    codepoint: "1F44C",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "OK hand",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("ok-handteken"),
            keywords: &["hand", "liggaam", "ok", "ok-handteken"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እሺ ምልክት እጅ"),
            keywords: &["አካል", "እሺ", "እሺ ምልክት እጅ", "እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يد تشير للموافقة"),
            keywords: &["علامة", "موافقة", "يد تشير للموافقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঠিক আছে"),
            keywords: &["ঠিক আছে", "বঢ\u{9bc}িয\u{9bc}\u{9be}", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ok işarəsi"),
            keywords: &["ok", "ok işarəsi", "orqan", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жэст «ОК»"),
            keywords: &["добра", "жэст", "жэст «ОК»", "ок", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Жест „окей“"),
            keywords: &["ok", "Жест „окей“", "окей", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঠিক আছে"),
            keywords: &["ঠিক আছে", "শরীর", "হ\u{9be}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("prsti pokazuju ok"),
            keywords: &["ok", "prsti pokazuju ok"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("senyal d’aprovació amb la mà"),
            keywords: &[
                "acceptació",
                "mà",
                "mà d’acceptació",
                "ok",
                "senyal d’aprovació",
                "senyal d’aprovació amb la mà",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏏᏊ ᎪᏯᏛ"),
            keywords: &["ᎣᏍᏓ", "ᎣᏏᏊ ᎪᏯᏛ", "ᎤᏬᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto OK"),
            keywords: &["OK", "gesto OK", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llaw ocê"),
            keywords: &["corff", "llaw", "llaw ocê", "ok"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ok-tegn"),
            keywords: &["OK-håndtegn", "OK-tegn", "ok-tegn"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("OK-Zeichen"),
            keywords: &[
                "Hand",
                "OK",
                "OK-Zeichen",
                "exzellent",
                "in Ordnung",
                "perfekt",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χειρονομία οκ"),
            keywords: &["OK", "σώμα", "χέρι", "χειρονομία οκ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("OK hand"),
            keywords: &["OK", "hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["OK", "hand", "perfect"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("señal de aprobación con la mano"),
            keywords: &[
                "aprobación",
                "mano",
                "ok",
                "señal de aprobación con la mano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("señal de OK"),
            keywords: &["gesto", "mano", "ok", "señal de OK"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("señal de aprobación con la mano"),
            keywords: &[
                "gesto",
                "mano",
                "ok",
                "señal",
                "señal de aprobación con la mano",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("OK-käemärk"),
            keywords: &["OK-käemärk", "keha", "käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("adostasuna adierazten duen eskua"),
            keywords: &[
                "ados",
                "adostasuna adierazten duen eskua",
                "eskua",
                "gorputza",
                "ok",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت اوکی"),
            keywords: &["اوکی", "باشه", "بله", "تأیید", "دست", "علامت اوکی", "قبول"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("ok-sormiele"),
            keywords: &["käsi", "ok", "ok-sormiele", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kamay na nagpapahiwatig ng ok"),
            keywords: &["kamay", "kamay na nagpapahiwatig ng ok", "ok", "pera"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("ok tekin"),
            keywords: &["gott", "hond", "ok", "tekin", "viðurkent"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("ok"),
            keywords: &["geste", "main", "ok"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["OK", "main", "ok"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh OK"),
            keywords: &["OK", "lámh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla làimhe OK"),
            keywords: &["aontachadh", "làmh", "samhla làimhe OK"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto de “OK”"),
            keywords: &["OK", "man", "perfecto", "xesto de “OK”"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બરાબર ચિહ\u{acd}ન"),
            keywords: &["ચિહ\u{acd}ન", "બરાબર", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hannun TO"),
            keywords: &["TO", "hannu", "hannun TO"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מסמנת שהכל בסדר"),
            keywords: &["ok", "אוקיי", "אישור", "בסדר", "יד", "יד מסמנת שהכל בסדר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ठीक का हाथ चिह\u{94d}न"),
            keywords: &["चिह\u{94d}न", "ठीक", "ठीक का हाथ चिह\u{94d}न", "हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak rukom \"u redu\""),
            keywords: &["ruka", "tijelo", "u redu", "znak rukom \"u redu\"", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ok jel"),
            keywords: &["kéz", "ok jel", "oké", "rendben", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ok ցույց տվող ձեռք"),
            keywords: &["ok", "ok ցույց տվող ձեռք", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("oke"),
            keywords: &["badan", "oke", "tangan", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("AKA dị mma"),
            keywords: &["AKA dị mma", "DỊ MMA", "aka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("Í lagi"),
            keywords: &["OK", "bending", "handarmerki", "Í lagi", "ókei"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano che fa OK"),
            keywords: &["OK", "mano", "mano che fa OK", "segno di OK"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("OKの手"),
            keywords: &["OK", "OKの手", "オッケー", "オーケー", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan nuduhake tandha OK"),
            keywords: &["OK", "tangan", "tangan nuduhake tandha OK"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ო’ქეის ჟესტი ხელით"),
            keywords: &["კარგი", "ო’ქეის ჟესტი ხელით", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ОК"),
            keywords: &["ОК", "дене", "жарайды", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ok-tegn"),
            keywords: &["OK-håndtegn", "OK-tegn", "ok-tegn"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ធ\u{17d2}វើម\u{17d2}រាមដៃ OK"),
            keywords: &["OK", "ដៃ", "ធ\u{17d2}វើម\u{17d2}រាមដៃ OK"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಸರ\u{cbf} ಕೈ"),
            keywords: &[
                "ಉತ\u{ccd}ತಮ",
                "ಸರ\u{cbf} ಕೈ",
                "ಸರ\u{cbf} ಚ\u{cbf}ಹ\u{ccd}ನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오케이를 표시한 손"),
            keywords: &["돈", "오케이 신호", "오케이를 표시한 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("ओक\u{947} हात"),
            keywords: &["ओक\u{947}", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«ОК» белгиси"),
            keywords: &["«ОК» белгиси", "ОК", "дене", "кол"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("OK-Handzeechen"),
            keywords: &["Hand", "OK", "OK-Handzeechen", "Zeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{ebb}ກມ\u{eb7}ຕ\u{ebb}ກລ\u{ebb}ງ"),
            keywords: &[
                "ຍ\u{ebb}ກມ\u{eb7}ຕ\u{ebb}ກລ\u{ebb}ງ",
                "ນ\u{eb4}\u{ec9}ວ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("GERAI ženklas rankomis"),
            keywords: &["GERAI ženklas rankomis", "gerai", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("simbols OK"),
            keywords: &["labi", "ok", "roka", "simbols OK", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa ĀE"),
            keywords: &["ringa", "ĀE"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рака што се согласува"),
            keywords: &["дланка", "добро", "ок", "рака", "рака што се согласува"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "അസല\u{d3e}യെന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചിഹ\u{d4d}നം",
            ),
            keywords: &[
                "അസല\u{d3e}യെന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചിഹ\u{d4d}നം",
                "കൈ",
                "ശരി",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ок"),
            keywords: &["гар", "дохио зангаа", "ок"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठीक आह\u{947} अस\u{947} दर\u{94d}शविणारा हात"),
            keywords: &["ठीक", "ठीक आह\u{947} अस\u{947} दर\u{94d}शविणारा हात", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol OK"),
            keywords: &["okey", "simbol OK", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id OK"),
            keywords: &["OK", "id"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အ\u{102d}\u{102f}ကေ လက\u{103a}"),
            keywords: &[
                "လက\u{103a}",
                "အ\u{102d}\u{102f}ကေ လက\u{103a}",
                "အ\u{102d}\u{102f}ကေ ဟ\u{102f}ပြနေသည\u{1037}\u{103a} လက\u{103a}ဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("OK-hånd"),
            keywords: &["OK", "OK-hånd", "hånd", "tegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ठीक छ जनाउन\u{947} औ\u{902}ला"),
            keywords: &["ठीक", "ठीक छ जनाउन\u{947} औ\u{902}ला", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("OK-handgebaar"),
            keywords: &["OK", "OK-handgebaar", "hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("OK-hand"),
            keywords: &["OK", "OK-hand", "hand", "teikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଠ\u{b3f}କ\u{b4d}\u{200c} ହ\u{b3e}ତ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ଅଛ\u{b3f} ଚ\u{b3f}ହ\u{b4d}ନ ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ଠ\u{b3f}କ\u{b4d}\u{200c} ହ\u{b3e}ତ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਠੀਕ ਦਾ ਹ\u{a71}ਥ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "OK",
                "OK ਹ\u{a71}ਥ ਦਾ ਨਿਸ\u{a3c}ਾਨ",
                "OKਨਿਸ\u{a3c}ਾਨ",
                "ਠੀਕ ਦਾ ਹ\u{a71}ਥ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ٹھیک اے ہتھ"),
            keywords: &["ٹھیک اے", "ٹھیک اے ہتھ", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("OK Hand"),
            keywords: &["Hand", "OK"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłoń z gestem OK"),
            keywords: &["dłoń z gestem OK", "znak OK"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوکی لاس"),
            keywords: &["اوکی", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sinal de ok"),
            keywords: &["mão", "mão sinalizando ok", "ok", "sinal", "sinal de ok"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gesto de OK"),
            keywords: &[
                "OK com a mão",
                "corpo",
                "gesto de OK",
                "mão",
                "mão com gesto de OK",
                "ok",
                "sinal de OK com a mão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("UYAKUY maki"),
            keywords: &["UYAKUY", "maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul ok"),
            keywords: &["gest", "mână", "ok", "semnul ok"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-521"),
            keywords: &["E10-521"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жест «все хорошо»"),
            keywords: &[
                "жест",
                "жест \"все хорошо\"",
                "жест «все хорошо»",
                "ок",
                "окей",
                "рука",
                "хорошо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganza cyemeza"),
            keywords: &["Yego", "ikiganza", "ikiganza cyemeza"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٺيڪ وارو هٿ"),
            keywords: &["هٿ", "ٺيڪ", "ٺيڪ وارو هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හර\u{dd2}\u{dd2} යන\u{dca}න දක\u{dca}වන අත"),
            keywords: &[
                "අත",
                "හර\u{dd2}",
                "හර\u{dd2}\u{dd2} යන\u{dca}න දක\u{dca}වන අත",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("výborne"),
            keywords: &["ok", "ruka", "výborne"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("roka, ki kaže V REDU"),
            keywords: &["dlan", "roka, ki kaže V REDU", "telo", "v redu"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacanta saxda ah"),
            keywords: &["gacan", "gacanta saxda ah", "sax"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("«ok» me dorë"),
            keywords: &["dorë", "në rregull", "ok", "trup", "«ok» me dorë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак руком „у реду“"),
            keywords: &["знак руком „у реду“", "рукa", "у рeду"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["знак руком „у реду“"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak rukom „u redu“"),
            keywords: &["ruka", "u redu", "znak rukom „u redu“"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["znak rukom „u redu“"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("OK-tecken"),
            keywords: &["OK", "OK-tecken", "hand", "tecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono wa kuonyesha mambo yako shwari"),
            keywords: &[
                "mkono",
                "mkono wa kuonyesha mambo yako shwari",
                "mwili",
                "sawa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சரி சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "அருமை",
                "ஓகே",
                "கை",
                "சரி சின\u{bcd}னம\u{bcd}",
                "சூப\u{bcd}பர\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("సమ\u{c4d}మత\u{c3f} గుర\u{c4d}తు"),
            keywords: &["గుర\u{c4d}తు", "సమ\u{c4d}మత\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("Дасти ОК"),
            keywords: &["Дасти ОК", "ОК", "даст"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทำม\u{e37}อโอเค"),
            keywords: &[
                "ทำม\u{e37}อโอเค",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("OK eli"),
            keywords: &["OK eli", "bolýar", "el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima fakaʻilonga sai"),
            keywords: &["nima fakaʻilonga sai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("tamam işareti"),
            keywords: &["Tamam", "Tamam el işareti", "el", "işaret", "tamam işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ماقۇل بەلگىسى"),
            keywords: &["قول", "ماقل", "ماقۇل بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жест «окей»"),
            keywords: &["«о’кей»", "жест «окей»", "рука", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اوکے کا نشان بناتا ہاتھ"),
            keywords: &["اوکے", "اوکے کا نشان بناتا ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("qo‘lda qilingan ok"),
            keywords: &["OK", "qoʻl", "qo‘lda qilingan ok", "yaxshi"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn tay làm dấu OK"),
            keywords: &["bàn tay làm dấu OK", "ok", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("laxo waaw-kay"),
            keywords: &["laxo waaw-kay", "loxo", "waaw-kay"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandla esithi Kulungile"),
            keywords: &["Kulungile", "isandla", "isandla esithi Kulungile"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọwọ ODARA"),
            keywords: &["ÓDÁRA", "Ọwọ ODARA", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("OK 手勢"),
            keywords: &["OK", "OK 手勢", "手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("OK 手势"),
            keywords: &["OK", "OK 手势", "手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("OK"),
            keywords: &["OK", "手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("OK 手勢"),
            keywords: &["OK", "OK 手勢", "沒問題"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla sokuthi kulungile"),
            keywords: &[
                "isandla",
                "isandla sokuthi kulungile",
                "kulungile",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👌🏻"]
pub const OK_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👌🏻",
    codepoint: "1F44C 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "OK hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👌🏼"]
pub const OK_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👌🏼",
    codepoint: "1F44C 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "OK hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👌🏽"]
pub const OK_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👌🏽",
    codepoint: "1F44C 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "OK hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👌🏾"]
pub const OK_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👌🏾",
    codepoint: "1F44C 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "OK hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👌🏿"]
pub const OK_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👌🏿",
    codepoint: "1F44C 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "OK hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤌"]
pub const PINCHED_FINGERS: crate::Emoji = crate::Emoji {
    glyph: "🤌",
    codepoint: "1F90C",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pinched fingers",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vingerpunte saamgedruk"),
            keywords: &[
                "beklemtoon",
                "handgebaar",
                "ondervraging",
                "sarkasties",
                "vingerpunte saamgedruk",
                "vingers",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቆነጠጡ ጣቶች"),
            keywords: &["የቆነጠጡ ጣቶች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أصابع مضمومة"),
            keywords: &["أصابع", "أصابع مضمومة", "إيماءة باليد", "تهك\u{651}م", "ضم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টিপ\u{9be} ম\u{9be}ৰি ৰখ\u{9be} আঙ\u{9c1}লি"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "জিজ\u{9cd}ঞ\u{9be}স\u{9be}",
                "টিপ\u{9be} ম\u{9be}ৰি ৰখ\u{9be}",
                "টিপ\u{9be} ম\u{9be}ৰি ৰখ\u{9be} আঙ\u{9c1}লি",
                "ব\u{9cd}যঙ\u{9cd}গ",
                "হ\u{9be}তৰ ভঙ\u{9cd}গিম\u{9be}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("çimdik"),
            keywords: &["barmaqlar", "sarkastik", "sorğu-sual", "çimdik", "əl jesti"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зведзеныя пальцы"),
            keywords: &[
                "жэст рукі",
                "зведзеныя",
                "пальцы",
                "пытанне",
                "сарказм",
                "шчыпок",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("събрани пръсти"),
            keywords: &["въпрос", "жест с ръка", "пръсти", "саркастично", "събрани"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অল\u{9cd}প একট\u{9c1}"),
            keywords: &[
                "অল\u{9cd}প একট\u{9c1}",
                "আঙ\u{9cd}গ\u{9c1}ল",
                "চিমটিক\u{9be}ট\u{9be}",
                "জিজ\u{9cd}ঞেস কর\u{9be}",
                "বিদ\u{9cd}র\u{9c1}পপ\u{9c2}র\u{9cd}ণ",
                "হ\u{9be}তের অঙ\u{9cd}গিভঙ\u{9cd}গি",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("skupljeni prsti"),
            keywords: &[
                "gest rukom",
                "ispitivanje",
                "prsti",
                "sarkastično",
                "skupljeni prsti",
                "uštinuti",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dits junts"),
            keywords: &[
                "dits",
                "dits junts",
                "gest de la mà",
                "interrogació",
                "sarcàstic",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏇᏄᎩᏍᏗ ᏕᎦᏰᏌᏛ"),
            keywords: &["ᎠᏓᎵᏍᎦᎾᏁᎯ", "ᎠᏛᏛᎲᏍᎩ", "ᎤᏬᏰᏂ ᎠᏌᎳᏙᏗ", "ᏕᎦᏰᏌᏛ", "ᏗᏓᏇᏄᎩᏍᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("špetka z pěti prstů"),
            keywords: &[
                "gesto rukou",
                "ironie",
                "italské sarkastické gesto",
                "otázka",
                "prsty",
                "sarkasmus",
                "sevřené",
                "špetka z pěti prstů",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bysedd wedi’u pinsio"),
            keywords: &[
                "arwydd â llaw",
                "bysedd",
                "bysedd wedi’u pinsio",
                "holi",
                "sarcastig",
                "wedi pinsio",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("samlede fingre"),
            keywords: &[
                "fingre",
                "gestus",
                "håndtegn",
                "samlede fingre",
                "sammenknebne",
                "sarkastisk",
                "udspørge",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("zusammengedrückte Finger"),
            keywords: &[
                "Bündelhand",
                "Finger",
                "Handgeste",
                "zusammengedrückt",
                "zusammengedrückte Finger",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δάχτυλα που κλείνουν"),
            keywords: &[
                "ανάκριση",
                "δάχτυλα",
                "δάχτυλα που κλείνουν",
                "κλειστά",
                "σαρκαστικό",
                "χειρονομία",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pinched fingers"),
            keywords: &[
                "fingers",
                "hand gesture",
                "interrogation",
                "pinched",
                "sarcastic",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dedos juntos apuntando hacia arriba"),
            keywords: &[
                "dedos",
                "dedos juntos apuntando hacia arriba",
                "gesto",
                "italia",
                "italiano",
                "mano",
                "sarcasmo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("dedos unidos"),
            keywords: &["dedos unidos"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kokkusurutud sõrmed"),
            keywords: &["kokkusurutud", "küsimus", "sarkastiline", "sõrmed", "žest"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hatz elkartuak"),
            keywords: &[
                "elkartuta",
                "esku-keinua",
                "galdera",
                "hatz elkartuak",
                "hatzak",
                "sarkasmoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("انگشتان جمع\u{200c}شده"),
            keywords: &[
                "اشاره با دست",
                "انگشتان",
                "جمع\u{200c}شده",
                "سؤال",
                "طنزآلود",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käsi supussa"),
            keywords: &[
                "kuulustelu",
                "käsi supussa",
                "käsiele",
                "mitä",
                "sarkastinen",
                "sormet",
                "supussa",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakurot na daliri"),
            keywords: &["daliri", "hand gesture", "pakurot", "pakurot na daliri"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("samlaðir fingrar"),
            keywords: &["fingrar", "hond", "hondtekin", "samlaðir fingrar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bout des doigts joints"),
            keywords: &[
                "argumentation",
                "bout des doigts joints",
                "doigts",
                "geste",
                "main",
                "parler avec les mains",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("main qui interroge"),
            keywords: &[
                "geste de la main",
                "interrogation",
                "main qui interroge",
                "sarcastique",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("méara fáiscthe le chéile"),
            keywords: &[
                "ceistiú",
                "comhartha láimhe",
                "fáiscthe",
                "méara",
                "méara fáiscthe le chéile",
                "tarcaisneach",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("crudhagan"),
            keywords: &[
                "beumach",
                "beur",
                "ceist",
                "corrag",
                "cruadhagan",
                "crudhagan",
                "gluasad làimhe",
                "meur",
                "meòir",
                "tearrachdail",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto de \"ateigado\""),
            keywords: &[
                "a tope",
                "ateigado",
                "de bote en bote",
                "petado",
                "xesto de \"ateigado\"",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચીમટી દ\u{ac7}વા ત\u{ac8}યાર આ\u{a82}ગળીઓ"),
            keywords: &[
                "આ\u{a82}ગળીઓ",
                "કટાક\u{acd}ષવાળ\u{ac1}\u{a82}",
                "ચીમટી આપવી",
                "ચીમટી દ\u{ac7}વા ત\u{ac8}યાર આ\u{a82}ગળીઓ",
                "પ\u{ac2}છપરછ",
                "હાથનો સ\u{a82}ક\u{ac7}ત",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מסמנת רק רגע"),
            keywords: &["אצבעות", "יד מסמנת רק רגע", "כף יד", "רק רגע", "תיכף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सिकोड\u{93c}ी ह\u{941}ई अ\u{902}ग\u{941}लिया\u{901}"),
            keywords: &[
                "उ\u{902}गलिया\u{902}",
                "प\u{942}छ-ताछ",
                "व\u{94d}य\u{902}ग\u{94d}यप\u{942}र\u{94d}ण",
                "सिकोड\u{93c}ी ह\u{941}ई अ\u{902}ग\u{941}लिया\u{901}",
                "स\u{942}खा ह\u{941}आ",
                "हाथ का इशारा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("skupljeni prsti"),
            keywords: &[
                "gesta rukom",
                "ispitivanje",
                "prsti",
                "sarkastično",
                "skupljeni prsti",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("összecsippentett ujjak"),
            keywords: &[
                "gúnyos",
                "kihallgatás",
                "kézmozdulat",
                "ujjak",
                "összecsippentett",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտղունց"),
            keywords: &["բացատրություն", "ժեստ", "հեգնանք", "մատներ", "պտղունց"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jari terkuncup"),
            keywords: &[
                "interogasi",
                "isyarat tangan",
                "jari",
                "sarkastik",
                "terkuncup",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("klípandi fingur"),
            keywords: &[
                "fingur",
                "handahreyfing",
                "kaldhæðni",
                "klípa",
                "klípandi fingur",
                "yfirheyrsla",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano a pigna"),
            keywords: &[
                "dita",
                "dita unite",
                "gesto della mano",
                "interrogativo",
                "mano a pigna",
                "sarcastico",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("上向きにすぼめた手"),
            keywords: &["すぼめる", "ジェスチャー", "上向きにすぼめた手", "手", "指"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("driji digatukake"),
            keywords: &["basa tangan", "digatukake", "driji", "interogasi", "landep"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("შეჯგუფებული თითები"),
            keywords: &["დაკითხვა", "თითები", "სარკასტული", "შეჯგუფებული"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("түйістірілген бес саусақ"),
            keywords: &[
                "мысқыл",
                "саусақтар",
                "сұрау",
                "түйістіру",
                "түйістірілген бес саусақ",
                "қол қимылы",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ម\u{17d2}រាមច\u{17d2}ប\u{17b7}ច"),
            keywords: &[
                "កាយវ\u{17b7}ការដៃ",
                "ការស\u{17ca}ើបអង\u{17d2}កេត",
                "ច\u{17c6}អកបញ\u{17d2}ឈ\u{17ba}ច\u{17b7}ត\u{17d2}ត",
                "ច\u{17d2}ប\u{17b7}ច",
                "ម\u{17d2}រាមច\u{17d2}ប\u{17b7}ច",
                "ម\u{17d2}រាមដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮಡಚ\u{cbf}ಕೊಂಡ ಬ\u{cc6}ರಳುಗಳು"),
            keywords: &[
                "ಕಹ\u{cbf}ಯಾದ",
                "ಕೈ ಸ\u{cc2}ಚಕ",
                "ಬ\u{cc6}ರಳುಗಳು",
                "ಮಡಚ\u{cbf}ಕೊಂಡ",
                "ವ\u{cbf}ಚಾರಣ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꼬집는 손가락"),
            keywords: &["꼬집는", "빈정대는", "손가락", "손동작", "질문"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चिमटीची\u{902} बोटा\u{902}"),
            keywords: &[
                "चवकशी",
                "चिमटीची\u{902} बोटा\u{902}",
                "चिमटो काडप",
                "बोटा\u{902}",
                "व\u{94d}य\u{902}गात\u{94d}मक",
                "हाताचो हावभाव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кыстырылган манжалар"),
            keywords: &["кыстырылган манжалар"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຈ\u{eb8}\u{ec9}ມ\u{200b}ນ\u{eb4}\u{ec9}ວ\u{200b}ມ\u{eb7}"),
            keywords: &[
                "ການສອບຖາມ",
                "ຈ\u{eb8}\u{ec9}ມ",
                "ຈ\u{eb8}\u{ec9}ມ\u{200b}ນ\u{eb4}\u{ec9}ວ\u{200b}ມ\u{eb7}",
                "ນ\u{eb4}\u{ec9}ວມ\u{eb7}",
                "ພາສາມ\u{eb7}",
                "ສຽດສ\u{eb5}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("suspausti pirštai"),
            keywords: &["pirštai", "rankos gestas", "sarkastiškas", "suspausti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pastiepti pirksti"),
            keywords: &[
                "pastiepti pirksti",
                "pirksti",
                "rokas žests",
                "sarkastisks",
                "saspiests",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стиснати прсти"),
            keywords: &[
                "гест со рака",
                "испрашување",
                "прсти",
                "саркастично",
                "стиснати",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d41}ള\u{d4d}ളിപ\u{d4d}പിടിച\u{d4d}ച വിരല\u{d41}കൾ"),
            keywords: &[
                "ആക\u{d4d}ഷേപസ\u{d42}ചകം",
                "കൈയ\u{d3e}ംഗ\u{d4d}യം",
                "ചോദ\u{d4d}യംചെയ\u{d4d}യൽ",
                "ന\u{d41}ള\u{d4d}ളിപ\u{d4d}പിടിച\u{d4d}ച",
                "വിരല\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гарын хуруунуудаа нийлүүлж чимхэх"),
            keywords: &[
                "байцаалт",
                "гарын зангаа",
                "гарын хуруунуудаа нийлүүлж чимхэх",
                "хуруунууд",
                "чимхэх",
                "ёжтой",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चिम\u{942}टभर"),
            keywords: &[
                "चिम\u{942}टभर",
                "चौकशी",
                "व\u{94d}य\u{902}गात\u{94d}मक",
                "हाताची बोट\u{947}",
                "हातान\u{947} दर\u{94d}शविल\u{947}ल\u{94d}या भावना",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("jari mencubit"),
            keywords: &[
                "gerak isyarat tangan",
                "jari",
                "mencubit",
                "sarkastik",
                "soal siasat",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စ\u{102f}ထားသော လက\u{103a}ချောင\u{103a}း"),
            keywords: &[
                "စစ\u{103a}ဆေး",
                "စ\u{102f}ထားသော လက\u{103a}ချောင\u{103a}း",
                "ဆ\u{102d}တ\u{103a}",
                "လက\u{103a}ချောင\u{103a}းများ",
                "လက\u{103a}ဟန\u{103a}",
                "အရ\u{103d}\u{1032}\u{1037}တ\u{102d}\u{102f}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hånd med fingertuppene sammen"),
            keywords: &[
                "fingre",
                "fingrene sammen",
                "hånd",
                "hånd med fingertuppene sammen",
                "sarkastisk",
                "spørsmål",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिमोटिएका औ\u{901}लाहर\u{942}"),
            keywords: &[
                "औ\u{901}ला",
                "चिमोटिएका औ\u{901}ला",
                "चिमोटिएका औ\u{901}लाहर\u{942}",
                "व\u{94d}य\u{902}ग\u{94d}यात\u{94d}मक",
                "सोधाइ",
                "हातको इसारा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("samengeknepen vingers"),
            keywords: &[
                "handgebaar",
                "ondervraging",
                "samengeknepen",
                "sarcastisch",
                "vingers",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hand med fingertuppane saman"),
            keywords: &[
                "fingrane saman",
                "fingrar",
                "hand",
                "hand med fingertuppane saman",
                "sarkastisk",
                "spørsmål",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କରେ ଚ\u{b3f}ମ\u{b41}ଟ\u{b3f}ବ\u{b3e}",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କରେ ଚ\u{b3f}ମ\u{b41}ଟ\u{b3f}ବ\u{b3e}",
                "ଚ\u{b3f}ମ\u{b41}ଟ\u{b3f}ବ\u{b3e}",
                "ପ\u{b4d}ରଶ\u{b4d}ନ କର\u{b3f}ବ\u{b3e}",
                "ବ\u{b3f}ଦ\u{b4d}ର\u{b41}ପ\u{b3e}ତ\u{b4d}ମକ",
                "ହ\u{b3e}ତର ଇଙ\u{b4d}ଗ\u{b3f}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਇਕ\u{a71}ਠੀਆ\u{a02} ਉ\u{a02}ਗਲਾ\u{a02}"),
            keywords: &[
                "ਇਕ\u{a71}ਠੀਆ\u{a02} ਉ\u{a02}ਗਲਾ\u{a02}",
                "ਉ\u{a02}ਗਲਾ\u{a02}",
                "ਪ\u{a41}\u{a71}ਛ-ਪੜਤਾਲ",
                "ਵਿਅ\u{a70}ਗਮਈ",
                "ਹ\u{a71}ਥ ਦਾ ਇਸ\u{a3c}ਾਰਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Pínch Fínga"),
            keywords: &[
                "Fínga-dẹm",
                "Hánd Sain",
                "Kwẹ\u{301}shọn Pínch",
                "Pínch Fínga",
                "Wétín Yu Tọk Bi Ópózít Ọf Wétín Yu Min",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("złączone palce"),
            keywords: &[
                "gest",
                "palce",
                "przesłuchanie",
                "sarkazm",
                "złączone palce",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چونګ ګوتې"),
            keywords: &["تفتيش", "تنزيه", "د لاس اشاره", "چونګ", "ګوتې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dedos comprimidos"),
            keywords: &[
                "beliscado",
                "dedos",
                "dedos comprimidos",
                "gesto de mão",
                "interrogação",
                "sarcástico",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼipsisqa rukanakuna"),
            keywords: &[
                "maki gestu",
                "rukanakuna",
                "sawkalli",
                "tapurikuy",
                "tʼipisqa",
                "tʼipsisqa rukanakuna",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("degete strânse"),
            keywords: &[
                "degete",
                "degete strânse",
                "gest cu mâna",
                "interogație",
                "sarcastic",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-004"),
            keywords: &["E13-004"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("щепоть"),
            keywords: &[
                "вопрос",
                "жест",
                "пальцы",
                "рега",
                "сарказм",
                "щепотка",
                "щепоть",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پنچ ٿيل آڱريون"),
            keywords: &[
                "آڱريون",
                "انٽيروگيشن",
                "سارڪيسٽڪ",
                "هٿ جو اشرو",
                "پنچ ٿيل",
                "پنچ ٿيل آڱريون",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වක\u{dd4}ට\u{dd4} කළ ඇඟ\u{dd2}ල\u{dd2}"),
            keywords: &[
                "අත\u{dca} ඉඟ\u{dd2}ය",
                "ඇඟ\u{dd2}ල\u{dd2}",
                "උපහ\u{dcf}ස\u{dcf}ත\u{dca}මක",
                "ප\u{dca}\u{200d}රශ\u{dca}න ක\u{dd2}ර\u{dd3}ම",
                "වක\u{dd4}ට\u{dd4} කළ",
                "වක\u{dd4}ට\u{dd4} කළ ඇඟ\u{dd2}ල\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("štipka"),
            keywords: &["málo", "prsty", "trocha", "troška", "štipka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prsti, stisnjeni skupaj"),
            keywords: &[
                "izpraševanje",
                "kretnja z roko",
                "prsti",
                "prsti, stisnjeni skupaj",
                "sarkastično",
                "stisnjen",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faro la isku wada duubay"),
            keywords: &["faro la isku wada duubay", "tilmaamta gacanta"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gishta të mbledhur"),
            keywords: &[
                "gishta",
                "gishta të mbledhur",
                "gjest me dorë",
                "hetim",
                "mbledhur",
                "sarkastik",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("скупљени прсти"),
            keywords: &["знак руком", "саркастично", "скупљени прсти", "упитно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("skupljeni prsti"),
            keywords: &["sarkastično", "skupljeni prsti", "upitno", "znak rukom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fingerportmonnä"),
            keywords: &[
                "fingerportmonnä",
                "fingrar",
                "förhör",
                "handgest",
                "knuten",
                "sarkastisk",
            ],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono wenye vidole vinavyobana"),
            keywords: &[
                "ishara ya mkono",
                "kejeli",
                "kubanwa",
                "kuuliza",
                "mkono wenye vidole vinavyobana",
                "vidole",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிணைக\u{bcd}கப\u{bcd}பட\u{bcd}ட விரல\u{bcd}கள\u{bcd}"),
            keywords: &[
                "கிண\u{bcd}டல\u{bbe}ன",
                "கிள\u{bcd}ளியது",
                "கை சைகை",
                "பிணைக\u{bcd}கப\u{bcd}பட\u{bcd}ட விரல\u{bcd}கள\u{bcd}",
                "விரல\u{bcd}கள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గ\u{c3f}చ\u{c4d}చుతున\u{c4d}నట\u{c4d}లు ఉండ\u{c47} వ\u{c47}ళ\u{c4d}లు"),
            keywords: &[
                "గ\u{c3f}చ\u{c4d}చడం",
                "గ\u{c3f}చ\u{c4d}చుతున\u{c4d}నట\u{c4d}లు ఉండ\u{c47} వ\u{c47}ళ\u{c4d}లు",
                "చ\u{c47}త\u{c3f} స\u{c48}గ",
                "ప\u{c4d}రశ\u{c4d}న\u{c3f}ంచడం",
                "వంట\u{c3f}వ\u{c3f} చ\u{c47}యడం",
                "వ\u{c47}ళ\u{c4d}లు",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e38}บน\u{e34}\u{e49}ว"),
            keywords: &[
                "การถาม",
                "ท\u{e48}าทางม\u{e37}อ",
                "น\u{e34}\u{e49}ว",
                "ปากจ\u{e31}ด",
                "ห\u{e38}บน\u{e34}\u{e49}ว",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gysylan barmaklar"),
            keywords: &["barmaklar", "el hereketi", "gysylan", "soramak", "teýeneli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("louhiʻinima fakamaʻopoʻopo"),
            keywords: &["louhiʻinima fakamaʻopoʻopo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kıstırma hareketi yapan parmaklar"),
            keywords: &[
                "bravo",
                "harika",
                "kıstırma hareketi yapan parmaklar",
                "lezzetli",
                "parmaklar",
                "çok güzel",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зведені пальці"),
            keywords: &["жест рукою", "запитання", "зведені", "пальці", "сарказм"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بھینچی ہوئی انگلیاں"),
            keywords: &[
                "انگلیاں",
                "بھینچی ہوئی انگلیاں",
                "تفتیش",
                "طنزیہ",
                "ہاتھ کا اشارہ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chimdilgan barmoqlar"),
            keywords: &[
                "barmoqlar",
                "chimdilgan",
                "istehzoli",
                "juftlangan",
                "qoʻl ishorasi",
                "soʻroq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ngón tay khum lại"),
            keywords: &[
                "cử chỉ tay",
                "khum lại",
                "mỉa mai",
                "ngón tay",
                "ngón tay khum lại",
                "thẩm vấn",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("卒手指"),
            keywords: &["卒", "卒手指", "嘲笑", "手勢", "手指", "質問"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("卒手指"),
            keywords: &["卒", "卒手指", "嘲笑", "手势", "手指", "质问"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("捏手指"),
            keywords: &["匮乏", "审讯", "手势", "手指", "挖苦", "捏手指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捏手指"),
            keywords: &["手勢", "手指", "捏", "捏手指", "疑問"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iminwe encinziwe"),
            keywords: &[
                "iminwe",
                "iminwe encinziwe",
                "ncinziwe",
                "ukubhuqa",
                "ukuphenywa",
                "ukwenza ngezandla",
            ],
        },
    ],
};
#[doc = "🤌🏻"]
pub const PINCHED_FINGERS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤌🏻",
    codepoint: "1F90C 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pinched fingers: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤌🏼"]
pub const PINCHED_FINGERS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤌🏼",
    codepoint: "1F90C 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pinched fingers: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤌🏽"]
pub const PINCHED_FINGERS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤌🏽",
    codepoint: "1F90C 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pinched fingers: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤌🏾"]
pub const PINCHED_FINGERS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤌🏾",
    codepoint: "1F90C 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pinched fingers: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤌🏿"]
pub const PINCHED_FINGERS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤌🏿",
    codepoint: "1F90C 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "pinched fingers: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤏"]
pub const PINCHING_HAND: crate::Emoji = crate::Emoji {
    glyph: "🤏",
    codepoint: "1F90F",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "pinching hand",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("knypende hand"),
            keywords: &["klein hoeveelheid", "knypende hand"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እጅ መቆንጠጥ"),
            keywords: &["ትንሽ መጠን", "እጅ መቆንጠጥ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يد تشير بمقدار ضئيل"),
            keywords: &[
                "كمية صغيرة",
                "مقدار صغير",
                "مقدار ضئيل",
                "يد تشير بمقدار ضئيل",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("টিপ\u{9be} ম\u{9be}ৰি ৰখ\u{9be} হ\u{9be}তৰ চিহ\u{9cd}ন"),
            keywords: &[
                "কম পৰিম\u{9be}ণ",
                "টিপ\u{9be} ম\u{9be}ৰি ৰখ\u{9be} হ\u{9be}তৰ চিহ\u{9cd}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sıxan əl"),
            keywords: &["kiçik say", "sıxan əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("тры пальцы"),
            keywords: &["маленькая колькасць", "тры пальцы"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ръка с приближени палец и показалец"),
            keywords: &[
                "малка сума",
                "нещо малко",
                "ръка с приближени палец и показалец",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চিমটি ক\u{9be}ট\u{9be} হ\u{9be}ত"),
            keywords: &["একট\u{9c1} খ\u{9be}নি", "চিমটি ক\u{9be}ট\u{9be} হ\u{9be}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruka koja štipa"),
            keywords: &["ruka koja štipa", "ruka pokazuje malo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mà que pessiga"),
            keywords: &["mà que pessiga", "quantitat petita"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏓᏇᏄᎩᏍᏗ ᎤᏬᏰᏂ"),
            keywords: &["ᎦᏲᏟ", "ᏗᏓᏇᏄᎩᏍᏗ ᎤᏬᏰᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto „málo“"),
            keywords: &["gesto „málo“", "malé množství", "troška", "špetka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bysedd yn pinshio"),
            keywords: &["bach iawn", "bysedd yn pinshio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lidt vist med tommel- og pegefinger"),
            keywords: &["lidt", "lidt vist med tommel- og pegefinger"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Wenig-Geste"),
            keywords: &[
                "Wenig-Geste",
                "klein",
                "kleine Menge",
                "kleiner Betrag",
                "unbedeutend",
                "wenig",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χέρι που τσιμπάει"),
            keywords: &["μικρή ποσότητα", "χέρι που τσιμπάει"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("pinching hand"),
            keywords: &["pinching hand", "small amount"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano pellizcando"),
            keywords: &["mano pellizcando", "pellizco", "poco", "poquito"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pöialt ja nimetissõrme lähestikku hoidev käsi"),
            keywords: &[
                "pöialt ja nimetissõrme lähestikku hoidev käsi",
                "väike kogus",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("atximurka egiten ari den eskua"),
            keywords: &["atximurka egiten ari den eskua", "pixka bat"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست در حال نیشگون گرفتن"),
            keywords: &["دست در حال نیشگون گرفتن", "مقدار کم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nipistävä käsi"),
            keywords: &[
                "hippunen",
                "nipistysote",
                "nipistävä käsi",
                "pieni määrä",
                "vähäinen määrä",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kamay na kumukurot"),
            keywords: &["kamay na kumukurot", "maliit na halaga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fingrar sum vísa ikki nógv"),
            keywords: &[
                "eitt sindur",
                "fingrar",
                "fingrar sum vísa ikki nógv",
                "hond",
                "hondtekin",
                "ikki nógv",
                "lítið",
            ],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pouce et index rapprochés"),
            keywords: &[
                "petite quantité",
                "petite somme",
                "peu",
                "pouce et index rapprochés",
                "un peu",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh ag pinseáil"),
            keywords: &["lámh ag pinseáil", "píosa beag"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh le sradag"),
            keywords: &["beagan", "làmh le sradag", "sradag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto de \"un chisco\""),
            keywords: &[
                "chisco",
                "miga",
                "pouquichiño",
                "pouquiño",
                "xesto de \"un chisco\"",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ચપટી વગાડતો હાથ"),
            keywords: &["ઓછા પ\u{acd}રમાણમા\u{a82}", "ચપટી વગાડતો હાથ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד צובטת"),
            keywords: &[
                "בכמות קטנה",
                "טיפונת",
                "יד צובטת",
                "יד שעושה תנועת צביטה",
                "מעט",
                "צביטה",
                "קצת",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थोड\u{93c}ा सा"),
            keywords: &["एक च\u{941}टकी", "थोड\u{93c}ा सा", "हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruka koja štipa"),
            keywords: &["mala količina", "ruka koja štipa"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csippentő kéz"),
            keywords: &["csippentő kéz", "kis összeg"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("պտղունց ցույց տվող ձեռք"),
            keywords: &["պտղունց ցույց տվող ձեռք", "փոքր քանակ", "քիչ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan menjepit"),
            keywords: &["sejumlah kecil", "tangan menjepit"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("klípandi hönd"),
            keywords: &["klípandi hönd", "lítið magn"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano che fa il gesto del pizzico"),
            keywords: &[
                "mano che fa il gesto del pizzico",
                "piccola quantità",
                "poco",
                "un pochino",
                "un po’",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("つまんでいる指"),
            keywords: &["ちょっと", "つまんでいる指", "少しだけ", "手", "指"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan njiwit"),
            keywords: &["sethithik bae", "tangan njiwit"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცოტა"),
            keywords: &["პატარა", "ცოტა", "ცოტაოდენი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саусақпен қысып алу"),
            keywords: &["аз ғана мөлшер", "саусақпен қысып алу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17d2}ប\u{17b7}ចដៃ"),
            keywords: &["ច\u{17d2}ប\u{17b7}ចដៃ", "បរ\u{17b7}មាណត\u{17b7}ច"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಗ\u{cbf}ಲ\u{ccd}ಲುವ ಕೈ"),
            keywords: &["ಕಡ\u{cbf}ಮ\u{cc6} ಪ\u{ccd}ರಮಾಣ", "ಗ\u{cbf}ಲ\u{ccd}ಲುವ ಕೈ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("꼬집는 손"),
            keywords: &["꼬집는 손", "적은 양을 나타내는 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("चिमटो काडपी हात"),
            keywords: &["चिमटो काडपी हात", "ल\u{94d}हान प\u{94d}रमाण"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("чычмыган кол"),
            keywords: &["аз санда", "чычмыган кол"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຢ\u{eb4}ບ\u{200b}ມ\u{eb7}"),
            keywords: &[
                "ຈຳ\u{200b}ນວນ\u{200b}ໜ\u{ec9}ອຍ",
                "ຢ\u{eb4}ບ\u{200b}ມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("žnybianti ranka"),
            keywords: &["mažas kiekis", "žnybianti ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("roka rāda drusciņu"),
            keywords: &["nedaudz", "roka rāda drusciņu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("дланка што штипе"),
            keywords: &["дланка што штипе", "мала сума"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ക\u{d41}റച\u{d4d}ച\u{d4d} എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന കൈ",
            ),
            keywords: &[
                "ക\u{d41}റച\u{d4d}ച\u{d4d}",
                "ക\u{d41}റച\u{d4d}ച\u{d4d} എന\u{d4d}ന\u{d4d} ക\u{d3e}ണിക\u{d4d}ക\u{d41}ന\u{d4d}ന കൈ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чимхэж буй гар"),
            keywords: &["бага зэрэг", "чимхэж буй гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("चिमटा काढणारा हात"),
            keywords: &["कमी प\u{94d}रमाण", "चिमटा काढणारा हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tangan mencubit"),
            keywords: &["sedikit", "tangan mencubit"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ချောင\u{103a}းချင\u{103a}း ဖ\u{102d}ဟန\u{103a}ပြခြင\u{103a}း"),
            keywords: &[
                "လက\u{103a}ချောင\u{103a}းချင\u{103a}း ဖ\u{102d}ဟန\u{103a}ပြခြင\u{103a}း",
                "အနည\u{103a}းငယ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hånd som klyper"),
            keywords: &["hånd som klyper", "lite", "liten"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("चिमोट\u{94d}न\u{947} हात"),
            keywords: &["चिमोट\u{94d}न\u{947} हात", "थोर\u{948} मात\u{94d}रा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hand met samengeknepen vingers"),
            keywords: &[
                "gebaar voor kleine hoeveelheid",
                "hand met samengeknepen vingers",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hand som klyp"),
            keywords: &["hand som klyp", "lite", "liten"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଚ\u{b3f}ମ\u{b41}ଟ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ"),
            keywords: &[
                "ଅଳ\u{b4d}ପ ମ\u{b3e}ତ\u{b4d}ର\u{b3e}",
                "ଚ\u{b3f}ମ\u{b41}ଟ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a42}\u{a70}ਢੀ ਜਿ\u{a70}ਨਾ"),
            keywords: &["ਚ\u{a42}\u{a70}ਢੀ ਜਿ\u{a70}ਨਾ", "ਥ\u{a4b}ੜ\u{a4d}ਹਾ ਜਿਹਾ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand Wé De Pinch"),
            keywords: &["Hand Wé De Pinch", "Smọ\u{301}l Amaunt"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłoń z gestem „trochę”"),
            keywords: &["dłoń z gestem „trochę”", "mała ilość"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سکونډونکی لاس"),
            keywords: &["سکونډونکی لاس", "کوچنی مقدار"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mão beliscando"),
            keywords: &["mão beliscando", "pequena quantidade"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão a dar um beliscão"),
            keywords: &["mão a dar um beliscão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tʼipsisqa maki"),
            keywords: &["huchuy chanin", "tʼipsisqa maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mână cu două degete apropiate"),
            keywords: &[
                "cantitate mică",
                "mână cu două degete apropiate",
                "valoare mică",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–024"),
            keywords: &["E12–024"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жест «мало»"),
            keywords: &[
                "жест «мало»",
                "мало",
                "небольшое количество",
                "немного",
                "чуть-чуть",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پنچنگ هٿ"),
            keywords: &["پنچنگ هٿ", "گهٽ مقدار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත ම\u{dd2}ර\u{dd2}ක\u{dd3}ම"),
            keywords: &[
                "අත ම\u{dd2}ර\u{dd2}ක\u{dd3}ම",
                "ක\u{dd4}ඩ\u{dcf} ප\u{dca}\u{200d}රම\u{dcf}ණයක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("málo"),
            keywords: &["malé množstvo", "málo", "trocha", "troška"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("roka s ščepcem"),
            keywords: &["majhna količina", "malo", "roka s ščepcem"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("qanjaruufo"),
            keywords: &["qaddar yar", "qanjaruufo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorështrënguar"),
            keywords: &["dorështrënguar", "kurnac", "sasi e vogël"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рука штипа"),
            keywords: &["мало", "прстохват", "рука штипа"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ruka štipa"),
            keywords: &["malo", "prstohvat", "ruka štipa"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("nypande hand"),
            keywords: &["liten mängd", "nypande hand"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("vidole vinavyobana"),
            keywords: &["kiasi kidogo", "vidole vinavyobana"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கிள\u{bcd}ளுதல\u{bcd}"),
            keywords: &[
                "கிள\u{bcd}ளு",
                "கிள\u{bcd}ளுதல\u{bcd}",
                "லேச\u{bbe}க கிள\u{bcd}ளுதல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c3f}ట\u{c3f}క\u{c46}డు చూపుతున\u{c4d}న చ\u{c47}య\u{c3f}"),
            keywords: &[
                "క\u{c4a}ద\u{c4d}ద\u{c3f} మ\u{c4a}త\u{c4d}తం",
                "చ\u{c3f}ట\u{c3f}క\u{c46}డు చూపుతున\u{c4d}న చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทำม\u{e37}อบ\u{e35}บน\u{e34}\u{e49}วเข\u{e49}าหาก\u{e31}น"),
            keywords: &[
                "ทำม\u{e37}อบ\u{e35}บน\u{e34}\u{e49}วเข\u{e49}าหาก\u{e31}น",
                "ปร\u{e34}มาณน\u{e49}อย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çümmükleýän el"),
            keywords: &["az mukdar", "çümmükleýän el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima fakamaʻopoʻopo"),
            keywords: &["nima fakamaʻopoʻopo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kıstırma hareketi yapan el"),
            keywords: &["azıcık", "bir tutam", "kıstırma hareketi yapan el"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жест «мало»"),
            keywords: &[
                "дещиця",
                "жест «мало»",
                "мало",
                "небагато",
                "невелика кількість",
                "трохи",
                "щіпка",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("چٹکی لیتا ہوا ہاتھ"),
            keywords: &["تھوڑی مقدار", "چٹکی لیتا ہوا ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chimduvchi qoʻl"),
            keywords: &["biroz", "chimduvchi qoʻl", "kam", "kichik", "ozgina"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tay chụm"),
            keywords: &["số lượng nhỏ", "tay chụm"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("捏手"),
            keywords: &["小量", "捏手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("捏手"),
            keywords: &["小量", "捏手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("捏合的手势"),
            keywords: &["一点", "小", "少量", "捏合的手势"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("捏"),
            keywords: &["少量", "捏"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("捏｜少少｜一啲啲"),
            keywords: &["少量", "捏｜少少｜一啲啲"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla esincinzayo"),
            keywords: &["inani elincane", "isandla esincinzayo"],
        },
    ],
};
#[doc = "🤏🏻"]
pub const PINCHING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤏🏻",
    codepoint: "1F90F 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "pinching hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤏🏼"]
pub const PINCHING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤏🏼",
    codepoint: "1F90F 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "pinching hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤏🏽"]
pub const PINCHING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤏🏽",
    codepoint: "1F90F 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "pinching hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤏🏾"]
pub const PINCHING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤏🏾",
    codepoint: "1F90F 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "pinching hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤏🏿"]
pub const PINCHING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤏🏿",
    codepoint: "1F90F 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "pinching hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✌\u{fe0f}"]
pub const VICTORY_HAND: crate::Emoji = crate::Emoji {
    glyph: "✌\u{fe0f}",
    codepoint: "270C FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "victory hand",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "✌",
        codepoint: "270C",
        status: crate::Status::Unqualified,
        introduction_version: 0.6f32,
        name: "victory hand",
        group: "People & Body",
        subgroup: "hand-fingers-partial",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oorwinninghandteken"),
            keywords: &["hand", "liggaam", "oorwinning", "oorwinninghandteken", "v"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የድል አድራጊነት ምልክት እጅ"),
            keywords: &["አካል", "እጅ", "የድል አድራጊነት ምልክት እጅ", "ድል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("علامة النصر"),
            keywords: &["انتصار", "علامة النصر", "مقص"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("বিজয\u{9bc}ী হ\u{9be}ত"),
            keywords: &["বিজয\u{9bc}ী", "ভি", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qələbə işarəsi"),
            keywords: &["orqan", "qələbə", "qələbə işarəsi", "v", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жэст перамогі"),
            keywords: &["жэст", "жэст перамогі", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Жест за победа"),
            keywords: &["Жест за победа", "победа", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}তে জয\u{9bc}ের চিহ\u{9cd}ন কর\u{9be}"),
            keywords: &[
                "জয\u{9bc}",
                "ভি আক\u{9be}র",
                "শরীর",
                "হ\u{9be}ত",
                "হ\u{9be}তে জয\u{9bc}ের চিহ\u{9cd}ন কর\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("dva prsta u znaku pobjede"),
            keywords: &["dva prsta", "dva prsta u znaku pobjede", "pobjeda"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("senyal de la victòria"),
            keywords: &["senyal", "senyal de la victòria", "victòria"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏓᏠᏒ ᎤᏬᏱ"),
            keywords: &["v", "ᎤᏓᏠᏒ", "ᎤᏓᏠᏒ ᎤᏬᏱ", "ᎤᏬᏰᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto vítězství"),
            keywords: &["gesto vítězství", "ruka", "tělo", "v", "vítězství"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llaw fuddugol"),
            keywords: &["buddugoliaeth", "corff", "llaw", "llaw fuddugol", "v"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("v-tegn"),
            keywords: &["V-tegn", "v-tegn", "yeah"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Victory-Geste"),
            keywords: &["Sieg", "V", "Victory-Geste"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σήμα της νίκης"),
            keywords: &["v", "νίκη", "σήμα της νίκης", "σώμα", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("victory hand"),
            keywords: &["hand", "v", "victory"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["hand", "peace hand", "peace sign", "v", "v sign", "victory"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano con señal de victoria"),
            keywords: &[
                "mano",
                "mano con señal de victoria",
                "señal de victoria",
                "victoria",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gesto de victoria"),
            keywords: &[
                "V",
                "dedos",
                "gesto de victoria",
                "mano",
                "tijera",
                "victoria",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mano con señal de victoria"),
            keywords: &[
                "amor y paz",
                "mano con señal de victoria",
                "tijera",
                "victoria",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mano con señal de victoria"),
            keywords: &[
                "amor y paz",
                "mano con señal de victoria",
                "tijera",
                "victoria",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("võit"),
            keywords: &["keha", "käsi", "v", "võit"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("garaipena adierazten duen eskua"),
            keywords: &[
                "eskua",
                "garaipena",
                "garaipena adierazten duen eskua",
                "gorputza",
                "v",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت پیروزی"),
            keywords: &["بدن", "دست", "علامت پیروزی", "وی", "پیروزی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("voitonmerkki"),
            keywords: &["käsi", "v", "vartalo", "voitonmerkki", "voitto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("peace sign"),
            keywords: &["daliri", "kamay", "peace sign", "tagumpay", "v sign"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sigurstekin"),
            keywords: &["hond", "sigur", "sigurstekin", "tekin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("V de la victoire"),
            keywords: &["V de la victoire", "ciseaux", "main", "victoire"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["V de la victoire", "ciseaux", "victoire"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha an bhua"),
            keywords: &[
                "bua",
                "comhartha an bhua",
                "lámh bua",
                "lámh síocháin",
                "lámh síochána",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh a thug buaidh"),
            keywords: &["buaidh", "làmh", "làmh a thug buaidh", "v"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto de vitoria"),
            keywords: &["man", "triunfo", "vitoria", "xesto", "xesto de vitoria"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("વિજયન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "કાતર",
                "વિજય",
                "વિજયન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "વિજયી હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hannun nasara"),
            keywords: &["hannu", "hannun nasara", "nasara", "v"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אצבעות מסמנות ניצחון"),
            keywords: &["אצבעות", "אצבעות מסמנות ניצחון", "וי", "יד", "ניצחון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("विजयी हाथ"),
            keywords: &["क\u{948}\u{902}ची", "जीत", "विजय", "विजयी हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruka sa znakom pobjede"),
            keywords: &["pobjeda", "ruka sa znakom pobjede", "v", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("győzelmi jelet mutató kéz"),
            keywords: &[
                "betű",
                "győzelmi jelet mutató kéz",
                "jel",
                "kéz",
                "kézjel",
                "test",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հաղթական ձեռք"),
            keywords: &["v", "հաղթական ձեռք", "հաղթանակ", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("isyarat kemenangan"),
            keywords: &[
                "badan",
                "isyarat kemenangan",
                "jari",
                "menang",
                "tangan",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka mmeri"),
            keywords: &["aka", "mmeri", "v"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("friðarmerki"),
            keywords: &["friðarmerki", "friður", "sigur", "sigurmerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("vittoria"),
            keywords: &["forbice", "mano", "segno di vittoria", "vittoria", "yeah"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("Vサイン"),
            keywords: &["Vサイン", "チョキ", "ピース", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan nuduhake tandha kamenangan"),
            keywords: &[
                "kamenangan",
                "tangan",
                "tangan nuduhake tandha kamenangan",
                "v",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გამარჯვების გამოხატვა ხელით"),
            keywords: &[
                "v",
                "გამარჯვება",
                "გამარჯვების გამოხატვა ხელით",
                "სხეული",
                "ტანი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саусақтармен «V» тәрізді көрсету"),
            keywords: &["V", "жеңіс", "саусақтармен «V» тәрізді көрсету", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("v-tegn"),
            keywords: &["V-tegn", "v-tegn", "yeah"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លើម\u{17d2}រាមដៃព\u{17b8}រជាអក\u{17d2}សរ V"),
            keywords: &[
                "ជ\u{17d0}យជម\u{17d2}នះ",
                "ដៃ",
                "លើម\u{17d2}រាមដៃព\u{17b8}រជាអក\u{17d2}សរ V",
                "អក\u{17d2}សរ v",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವ\u{cbf}ಜಯದ ಕೈ"),
            keywords: &["ವ\u{cbf}ಜಯ", "ವ\u{cbf}ಜಯದ ಕೈ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("브이 표시"),
            keywords: &["가위", "브이 표시", "찌"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("विजयाचो हात"),
            keywords: &["विजय", "विजयाचो हात", "व\u{94d}ही", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("эки дегенди көрсөткөн манжалар"),
            keywords: &["ийгилик", "кол", "эки дегенди көрсөткөн манжалар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Victoire-Handzeechen"),
            keywords: &["Hand", "V", "Victoire", "Victoire-Handzeechen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb9}ສອງນ\u{eb4}\u{ec9}ວ"),
            keywords: &[
                "ຊ\u{eb9}ສອງນ\u{eb4}\u{ec9}ວ",
                "ມ\u{eb7}",
                "ສອງນ\u{eb4}\u{ec9}ວ",
                "ສ\u{eb9}\u{ec9}ໆ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pergalės ženklą rodanti ranka"),
            keywords: &["pergalė", "pergalės ženklą rodanti ranka", "ranka", "v"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("uzvaras simbols"),
            keywords: &["roka", "uzvara", "uzvaras simbols", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa wikitōria"),
            keywords: &["ringa", "v", "wikitōria"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рака покажува победа"),
            keywords: &["дланка", "победа", "прст", "рака", "рака покажува победа"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിജയ ചിഹ\u{d4d}നം"),
            keywords: &["v", "കൈ", "വിജയ ചിഹ\u{d4d}നം", "വിജയം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("амжилт хүссэн гар"),
            keywords: &["v", "амжилт хүссэн гар", "гар", "ялалт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("विजय दर\u{94d}शविणारा हात"),
            keywords: &["विजय", "विजय दर\u{94d}शविणारा हात", "व\u{94d}ही", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol kemenangan"),
            keywords: &["badan", "kemenangan", "simbol kemenangan", "tangan", "v"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id tar-rebħa"),
            keywords: &["id", "id tar-rebħa", "rebħa", "v"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အောင\u{103a}မြင\u{103a}မ\u{103e}\u{102f}ပြ လက\u{103a}ဟန\u{103a}"),
            keywords: &[
                "လက\u{103a}",
                "အင\u{103a}\u{1039}ဂလ\u{102d}ပ\u{103a} အက\u{1039}ခရာ ဗ\u{103d}\u{102e} ပ\u{102f}\u{1036}စ\u{1036} လက\u{103a}ချောင\u{103a}းထောင\u{103a}နေပ\u{102f}\u{1036}",
                "အောင\u{103a}မြင\u{103a}မ\u{103e}\u{102f}ပြ လက\u{103a}ဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("seierstegn"),
            keywords: &["hånd", "peace-tegn", "seierstegn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जित जनाउन\u{947} औ\u{902}ला"),
            keywords: &["जित जनाउन\u{947} औ\u{902}ला", "भी", "विजयी", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("winnende hand"),
            keywords: &["hand", "v", "vredesteken", "winnende hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("seiersteikn"),
            keywords: &["hand", "peaceteikn", "seiersteikn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜୟଲ\u{b3e}ଭ ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ"),
            keywords: &[
                "ଜ\u{b3f}ତ\u{b3f}ବ\u{b3e}",
                "ଜୟଲ\u{b3e}ଭ ସ\u{b42}ଚ\u{b3e}ଉଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ଭ\u{b3f}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜਿ\u{a71}ਤ ਦਾ ਹ\u{a71}ਥ ਚਿ\u{a70}ਨ\u{a4d}ਹ"),
            keywords: &[
                "ਕ\u{a48}\u{a02}ਚੀ",
                "ਜਿ\u{a71}ਤ",
                "ਜਿ\u{a71}ਤ ਦਾ ਹ\u{a71}ਥ ਚਿ\u{a70}ਨ\u{a4d}ਹ",
                "ਜਿ\u{a71}ਤ ਹ\u{a71}ਥ",
                "ਹਾ\u{a02}",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("فتح دا ہتھ"),
            keywords: &["v", "جیت", "فتح دا ہتھ", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Víktri Hand"),
            keywords: &["Hand", "V", "Víktri"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gest V"),
            keywords: &["gest V", "gest zwycięstwa", "znak V", "znak Victorii"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د بریا نښه"),
            keywords: &["v", "بریا", "د بریا نښه", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mão em V de vitória"),
            keywords: &[
                "mão com sinal de vitória",
                "mão em V de vitória",
                "sim!",
                "vitória",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão em V de vitória"),
            keywords: &["corpo", "mão", "mão em V de vitória", "v", "vitória"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("yalli maki"),
            keywords: &["maki", "v", "yalli"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul victoriei"),
            keywords: &["degete", "mână", "semnul victoriei", "v", "victorie"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-127"),
            keywords: &["E10-127"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жест V"),
            keywords: &["виктория", "жест V", "пальцы", "победа", "рука", "триумф"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("Ikiganza cy’intsinzi"),
            keywords: &["Ikiganza cy’intsinzi", "ikiganza", "intsinzi", "v"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("فتح جو نشان"),
            keywords: &["فتح جو نشان", "فتح، هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ජයග\u{dca}\u{200d}රහණය දක\u{dca}වන අත"),
            keywords: &[
                "අත",
                "ජ",
                "ජයග\u{dca}\u{200d}රහණය",
                "ජයග\u{dca}\u{200d}රහණය දක\u{dca}වන අත",
                "ශර\u{dd3}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("víťazstvo"),
            keywords: &["ruka", "v", "víťazstvo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dlan s prstoma, ki kažeta znak za zmago"),
            keywords: &[
                "dlan",
                "dlan s prstoma, ki kažeta znak za zmago",
                "telo",
                "v",
                "zmaga",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacanta guusha"),
            keywords: &["gacanta", "guusha", "v"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dora e fitores"),
            keywords: &["dora e fitores", "dorë", "fitore", "trup", "v"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак победе"),
            keywords: &["v", "знак победе", "пoбeдa", "рукa", "тело", "шaкa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("знак побједе"),
            keywords: &["знак побједе"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak pobede"),
            keywords: &["pobeda", "ruka", "telo", "v", "znak pobede", "šaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("znak pobjede"),
            keywords: &["znak pobjede"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("v-tecken"),
            keywords: &["seger", "v-tecken"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono wa ushindi"),
            keywords: &["mkono", "mkono wa ushindi", "mwili", "ushindi", "v"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வெற\u{bcd}றிச\u{bcd} சின\u{bcd}னம\u{bcd}"),
            keywords: &[
                "அடைய\u{bbe}ளம\u{bcd}",
                "சைகை",
                "வெற\u{bcd}றி",
                "வெற\u{bcd}றி சின\u{bcd}னம\u{bcd}",
                "வெற\u{bcd}றிச\u{bcd} சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("వ\u{c3f}జయ సంక\u{c47}తం"),
            keywords: &["వ\u{c3f}జయ సంక\u{c47}తం", "వ\u{c3f}జయం", "సంక\u{c47}తం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дасти зафар"),
            keywords: &["v", "даст", "дасти зафар", "зафар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39} 2 น\u{e34}\u{e49}ว"),
            keywords: &["ช\u{e39} 2 น\u{e34}\u{e49}ว", "ช\u{e39}สองน\u{e34}\u{e49}ว"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýeňiş alamatyny görkezýän el"),
            keywords: &["el", "v", "ýeňiş", "ýeňiş alamatyny görkezýän el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima ikuna"),
            keywords: &["nima ikuna"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("zafer işareti"),
            keywords: &["oleey", "zafer", "zafer eli", "zafer işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("غەلبە ئىشارىسى"),
            keywords: &["v", "غەلبە", "غەلبە ئىشارىسى", "قول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жест перемоги"),
            keywords: &["V", "жест перемоги", "перемога", "рука", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("فتح کا نشان بناتا ہاتھ"),
            keywords: &["جسم", "فتح", "فتح کا نشان بناتا ہاتھ", "نشان", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("v harfini ko‘rsatib turgan qo‘l"),
            keywords: &["gʻalaba", "qoʻl", "v", "v harfini ko‘rsatib turgan qo‘l"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tay chiến thắng"),
            keywords: &["chiến thắng", "tay", "tay chiến thắng", "v"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo ndam"),
            keywords: &["loxo", "ndam", "v"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandla sempumelelo"),
            keywords: &["impumelelo", "isandla", "isandla sempumelelo", "v"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("aṣeyọrí ọwọ\u{301}"),
            keywords: &["aṣeyọrí", "v", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("勝利手勢"),
            keywords: &["v", "勝利", "勝利手勢", "手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("胜利手势"),
            keywords: &["v", "手", "胜利", "胜利手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("胜利手势"),
            keywords: &["V", "成功", "手", "胜利", "胜利手势"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("勝利"),
            keywords: &["勝利", "耶"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("V字手勢"),
            keywords: &["V字手勢", "剪刀手勢", "勝利手勢"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla sokunqoba"),
            keywords: &["isandla", "isandla sokunqoba", "ukunqoba", "umzimba"],
        },
    ],
};
#[doc = "✌🏻"]
pub const VICTORY_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✌🏻",
    codepoint: "270C 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "victory hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✌🏼"]
pub const VICTORY_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✌🏼",
    codepoint: "270C 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "victory hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✌🏽"]
pub const VICTORY_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✌🏽",
    codepoint: "270C 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "victory hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✌🏾"]
pub const VICTORY_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✌🏾",
    codepoint: "270C 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "victory hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✌🏿"]
pub const VICTORY_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✌🏿",
    codepoint: "270C 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "victory hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤞"]
pub const CROSSED_FINGERS: crate::Emoji = crate::Emoji {
    glyph: "🤞",
    codepoint: "1F91E",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "crossed fingers",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("duim vashou"),
            keywords: &["duim vashou", "duimvashou", "geluk", "hand", "hoop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጣት ማጣመር"),
            keywords: &["ማጣመር", "እድል", "እጅ", "ጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أصابع مشبكة"),
            keywords: &["أصابع", "أصابع مشبكة", "حظ"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9cd}ৰছ\u{9cd}\u{200c}ড ফিঙ\u{9cd}গ\u{9be}ৰ\u{9cd}ছ\u{9cd}"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "ক\u{9cd}ৰছ",
                "ক\u{9cd}ৰছ\u{9cd}\u{200c}ড ফিঙ\u{9cd}গ\u{9be}ৰ\u{9cd}ছ\u{9cd}",
                "ভ\u{9be}গ\u{9cd}য",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ümid edirəm"),
            keywords: &["inam", "ümid", "ümid edirəm"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("скрыжаваныя пальцы"),
            keywords: &["скрыжаваныя пальцы", "удача"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стискане на палци"),
            keywords: &["късмет", "палци", "ръка", "стискане", "стискане на палци"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আশ\u{9be} করি যেন হয\u{9bc}"),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "আশ\u{9be} করি",
                "আশ\u{9be} করি যেন হয\u{9bc}",
                "ভ\u{9be}গ\u{9cd}য",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("držanje palčeva"),
            keywords: &["držanje palčeva", "držati", "fige", "palac", "sreća"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dits creuats"),
            keywords: &["creuats", "dits", "sort"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏧᏓᎿᏫᏓ ᏕᎦᏰᏌᏛ"),
            keywords: &["ᎤᏢᏱᏕᏓ", "ᎤᏬᏱ", "ᎦᏰᏌᏛ", "ᏧᏓᎿᏫᏓ", "ᏧᏓᎿᏫᏓ ᏕᎦᏰᏌᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zkřížené prsty"),
            keywords: &["prsty", "ruka", "zkřížené prsty", "zkřížit", "štěstí"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bysedd wedi’u croesi"),
            keywords: &["bys", "bysedd wedi’u croesi", "croesi", "llaw", "lwc"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("krydsede fingre"),
            keywords: &[
                "finger",
                "held og lykke",
                "håb",
                "hånd",
                "krop",
                "krydsede fingre",
                "krydser fingre",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hand mit gekreuzten Fingern"),
            keywords: &["Finger", "Hand", "Hand mit gekreuzten Fingern", "gekreuzt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καλή τύχη"),
            keywords: &["δάχτυλα", "καλή τύχη", "σταυρώνω", "τύχη", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("crossed fingers"),
            keywords: &["cross", "crossed fingers", "finger", "hand", "luck"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dedos cruzados"),
            keywords: &["cruzar", "dedos", "dedos cruzados", "mano", "suerte"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("dedos cruzados"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("dedos cruzados"),
            keywords: &["dedos cruzados", "mano", "suerte"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sõrmed risti"),
            keywords: &["käsi", "risti", "sõrmed", "õnn"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hatz gurutzatuak"),
            keywords: &["eskua", "gurutzatu", "hatz gurutzatuak", "hatza", "zortea"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("انگشتان گره خورده"),
            keywords: &[
                "انگشت",
                "انگشتان گره خورده",
                "بخت",
                "دست",
                "شانس",
                "پنجه",
                "گره",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sormet ristissä"),
            keywords: &["käsi", "onni", "risti", "sormet ristissä", "sormi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("naka-cross na mga daliri"),
            keywords: &[
                "cross",
                "daliri",
                "kamay",
                "naka-cross na mga daliri",
                "swerte",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("krossaðir fingrar"),
            keywords: &["eydna", "fingrar", "hond", "krossaðir fingrar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("doigts croisés"),
            keywords: &["croisés", "doigts", "main"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["chance", "croisés", "doigts", "main"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("méarsa trasna"),
            keywords: &[
                "ag súil",
                "crosach",
                "méara",
                "méara crosach ar a chéile",
                "méarsa trasna",
                "ádh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beò an dòchas"),
            keywords: &[
                "beò an dòchas",
                "corrag",
                "dòchas",
                "fortan",
                "làmh",
                "meur",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dedos cruzados"),
            keywords: &["cruzar", "dedos", "dedos cruzados", "man", "sorte"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ક\u{acd}રૉસ\u{acd}ડ ફિ\u{a82}ગર\u{acd}સ"),
            keywords: &[
                "ક\u{acd}રૉસ",
                "ક\u{acd}રૉસ\u{acd}ડ ફિ\u{a82}ગર\u{acd}સ",
                "ફિ\u{a82}ગર",
                "ભાગ\u{acd}ય",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("haɗaɗɗun yatsu"),
            keywords: &["hannu", "haɗa", "haɗaɗɗun yatsu", "sa’a", "yatsa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מחזיקה אצבעות"),
            keywords: &["אצבעות", "בהצלחה", "יד מחזיקה אצבעות", "מחזיק"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("क\u{94d}रॉस बनाती अ\u{902}ग\u{941}लिया\u{901}"),
            keywords: &[
                "उ\u{902}गली",
                "क\u{94d}रॉस",
                "क\u{94d}रॉस बनाती अ\u{902}ग\u{941}लिया\u{901}",
                "भाग\u{94d}य",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("prekriženi prsti"),
            keywords: &["držati", "fige", "palac", "prekriženi prsti", "sreća"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("keresztezett ujjak"),
            keywords: &["keresztezett", "keresztezett ujjak", "szerencse", "ujj"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("խաչած մատներ"),
            keywords: &["խաչած մատներ", "խաչել", "հաջողություն", "ձեռք", "մատ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jari menyilang"),
            keywords: &[
                "beruntung",
                "jari",
                "jari menyilang",
                "semoga beruntung",
                "semoga hoki",
                "silang jari",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("mkpịakọ mkpịsịaka gasị"),
            keywords: &[
                "aka",
                "isiọma",
                "mkpịakọ",
                "mkpịakọ mkpịsịaka gasị",
                "mkpịsịaka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krosslagðir fingur"),
            keywords: &["fingur", "hendi", "kross", "krosslagðir fingur", "lukka"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dita incrociate"),
            keywords: &["dita", "dita incrociate", "fortuna", "incrociare", "mano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("指をクロス"),
            keywords: &["手", "指", "指をクロス"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("driji loro tetalenan"),
            keywords: &[
                "driji",
                "driji loro tetalenan",
                "kabegjan",
                "tangan",
                "tetalen",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გადაჯვარედინებული თითები"),
            keywords: &[
                "გადაჯვარედინება",
                "გადაჯვარედინებული თითები",
                "თითი",
                "იღბალი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саусақтарын айқастырған"),
            keywords: &["айқастырған", "саусақ", "саусақтарын айқастырған"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("krydsede fingre"),
            keywords: &[
                "finger",
                "held og lykke",
                "håb",
                "hånd",
                "krop",
                "krydsede fingre",
                "krydser fingre",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}វែងម\u{17d2}រាមដៃ"),
            keywords: &[
                "ខ\u{17d2}វែង",
                "ខ\u{17d2}វែងម\u{17d2}រាមដៃ",
                "ដៃ",
                "ម\u{17d2}រាមដៃ",
                "ស\u{17c6}ណាង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನ\u{cbf}ರೀಕ\u{ccd}ಷ\u{cc6}"),
            keywords: &[
                "ಅದೃಷ\u{ccd}ಟ",
                "ಕೈ",
                "ತ\u{cbf}ರುಪುವ\u{cbf}ಕ\u{cc6}",
                "ನ\u{cbf}ರೀಕ\u{ccd}ಷ\u{cc6}",
                "ಬ\u{cc6}ರಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("검지와 중지 크로스"),
            keywords: &[
                "검지",
                "검지와 중지 크로스",
                "교차",
                "손가락",
                "중지",
                "크로스",
            ],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("क\u{94d}रॉस क\u{947}ल\u{94d}ली\u{902} बोटा\u{902}"),
            keywords: &[
                "क\u{94d}रॉस",
                "क\u{94d}रॉस क\u{947}ल\u{94d}ली\u{902} बोटा\u{902}",
                "नशीब",
                "बोट",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кайчылаштырылган манжалар"),
            keywords: &["ийгилик", "кайчылаштырылган манжалар"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gekräizt Fanger"),
            keywords: &["Fanger", "Gléck", "Hand", "gekräizt Fanger", "kräizen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ນ\u{eb4}\u{ec9}ວໄຂວ\u{ec8}ກ\u{eb1}ນ"),
            keywords: &[
                "ນ\u{eb4}\u{ec9}ວ",
                "ນ\u{eb4}\u{ec9}ວໄຂວ\u{ec8}ກ\u{eb1}ນ",
                "ມ\u{eb7}",
                "ໂຊກດ\u{eb5}",
                "ໄຂວ\u{ec8}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("sukryžiuoti pirštai"),
            keywords: &[
                "kryžius",
                "laimė",
                "pirštai",
                "ranka",
                "sukryžiuoti pirštai",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("sakrustoti pirksti"),
            keywords: &[
                "pirksts",
                "roka",
                "sakrustot",
                "sakrustoti pirksti",
                "turēt īkšķus",
                "veiksme",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("matimati whiri"),
            keywords: &["matimati", "ringa", "waimarie", "whiri"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стискање палци"),
            keywords: &["палци", "прсти", "среќа", "стискање палци"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഭ\u{d3e}ഗ\u{d4d}യസ\u{d42}ചന"),
            keywords: &[
                "കൈ",
                "ഭ\u{d3e}ഗ\u{d4d}യം",
                "ഭ\u{d3e}ഗ\u{d4d}യസ\u{d42}ചന",
                "വിരൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("солбисон хуруу"),
            keywords: &["солбисон", "хуруу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some(
                "श\u{941}भ\u{947}च\u{94d}छा स\u{902}क\u{947}त द\u{947}णारी एकम\u{947}का\u{902}ना क\u{94d}रॉस करणारी बोट\u{947}",
            ),
            keywords: &[
                "एकम\u{947}का\u{902}ना क\u{94d}रॉस करण\u{947}",
                "भाग\u{94d}य",
                "श\u{941}भ\u{947}च\u{94d}छा स\u{902}क\u{947}त द\u{947}णारी एकम\u{947}का\u{902}ना क\u{94d}रॉस करणारी बोट\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("silang jari"),
            keywords: &["jari", "nasib", "silang", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("swaba nkroċjati"),
            keywords: &["bl-idejn", "inkroċja", "subgħa", "swaba nkroċjati", "xorti"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("က\u{1036}ကောင\u{103a}းပါစေပြ လက\u{103a}ဟန\u{103a}"),
            keywords: &[
                "က\u{1036}ကောင\u{103a}းပါစေပြ လက\u{103a}ဟန\u{103a}",
                "က\u{1036}တရား",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ချောင\u{103a}းချင\u{103a}းချ\u{102d}တ\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("kryssede fingre"),
            keywords: &["finger", "hell", "hånd", "kryss", "kryssede fingre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}रार\u{94d}थना गरिरह\u{947}को म\u{941}द\u{94d}रा"),
            keywords: &[
                "औ\u{902}ला",
                "काट\u{94d}न\u{941}",
                "प\u{94d}रार\u{94d}थना गरिरह\u{947}को म\u{941}द\u{94d}रा",
                "भाग\u{94d}य",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("gekruiste vingers"),
            keywords: &["gekruist", "gekruiste vingers", "geluk", "hand", "vinger"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("kryssande fingrar"),
            keywords: &["finger", "hand", "hell", "kryss", "kryssande fingrar"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ),
            keywords: &[
                "ଛକ\u{b3f} । ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f} । ହ\u{b3e}ତ । ଭ\u{b3e}ଗ\u{b4d}ୟ",
                "ଛକ\u{b3f}ଯ\u{b41}କ\u{b4d}ତ ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕਾਟਵੀਆ\u{a02} ਉ\u{a02}ਗਲਾ\u{a02}"),
            keywords: &[
                "ਉ\u{a02}ਗਲੀ",
                "ਕਰਾਸ",
                "ਕਾਟਵੀਆ\u{a02} ਉ\u{a02}ਗਲਾ\u{a02}",
                "ਕਿਸਮਤ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}نگلاں آرپار کرنا"),
            keywords: &[
                "ا\u{64f}نگل",
                "ا\u{64f}نگلاں آرپار کرنا",
                "قسمت",
                "پار کرنا",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Krọ\u{301}s Fínga-dẹm"),
            keywords: &["Fínga", "Hand", "Krọs", "Krọ\u{301}s Fínga-dẹm", "Lọk"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("skrzyżowane palce"),
            keywords: &["kciuki", "powodzenia", "skrzyżowane palce", "trzymać"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("متقاطع ګوتي"),
            keywords: &["بخت", "لاس", "متقاطع", "ګوتي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dedos cruzados"),
            keywords: &["cruzados", "dedos", "mão", "sorte"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("figas"),
            keywords: &["cruzados", "dedos", "figas", "mão", "sorte"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("rankʼusqa rukanakuna"),
            keywords: &[
                "maki",
                "rankʼusqa rukanakuna",
                "rankʼuy",
                "rukana",
                "suerte",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("degete încrucișate"),
            keywords: &[
                "degete",
                "degete încrucișate",
                "mână",
                "noroc",
                "încrucișare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1024"),
            keywords: &["E10-1024"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("скрещенные пальцы"),
            keywords: &[
                "жест удачи",
                "пальцы",
                "скрестить",
                "скрещенные пальцы",
                "удача",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("intoki zinyuranyemo"),
            keywords: &[
                "amahirwe",
                "ikiganza",
                "intoki zinyuranyemo",
                "umusaraba",
                "urutoki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪراس ٿيل آڱريون"),
            keywords: &["آڱر", "قسمت", "هٿ", "ڪراس", "ڪراس ٿيل آڱريون"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හරස\u{dca} කළ ඇඟ\u{dd2}ල\u{dd2}"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "ව\u{dcf}සන\u{dcf}ව",
                "හරස\u{dca}",
                "හරස\u{dca} කළ ඇඟ\u{dd2}ල\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("držím palce"),
            keywords: &["držať", "držím palce", "palce", "ruka", "šťastie"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("prekrižani prsti"),
            keywords: &["prekrižani prsti", "prsti", "roka", "sreča"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("faraha gudban; Alla bari"),
            keywords: &[
                "Alla bari",
                "far",
                "faraha gudban",
                "faraha gudban; Alla bari",
                "faro isdhaafsan",
                "gacan",
                "iskutallaab",
                "nasiib",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gishta të kryqëzuar"),
            keywords: &["dorë", "fat", "gisht", "gishta të kryqëzuar", "kryqëzim"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("прекрштени прсти"),
            keywords: &[
                "жеља",
                "катанац",
                "обећање",
                "прекрштени прсти",
                "прсти",
                "срећа",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("prekršteni prsti"),
            keywords: &[
                "katanac",
                "obećanje",
                "prekršteni prsti",
                "prsti",
                "sreća",
                "želja",
            ],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("korsade fingrar"),
            keywords: &["finger", "hand", "korsa", "korsade fingrar", "lycka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya kubahatisha"),
            keywords: &["ishara ya kubahatisha", "kubahatisha", "mkono"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("அதிர\u{bcd}ஷ\u{bcd}டம\u{bcd}"),
            keywords: &["அதிர\u{bcd}ஷ\u{bcd}டம\u{bcd}", "கை", "விரல\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4d}ర\u{c3e}స\u{c4d} చ\u{c47}స\u{c3f}న వ\u{c47}ళ\u{c4d}లు"),
            keywords: &[
                "అదృష\u{c4d}టం",
                "క\u{c4d}ర\u{c3e}స\u{c4d}",
                "క\u{c4d}ర\u{c3e}స\u{c4d} చ\u{c47}స\u{c3f}న వ\u{c47}ళ\u{c4d}లు",
                "చ\u{c47}య\u{c3f}",
                "వ\u{c47}ళ\u{c4d}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ангуштони ба ҳам гузошташуда"),
            keywords: &[
                "ангушт",
                "ангуштони ба ҳам гузошташуда",
                "даст",
                "муваффақият",
                "салиб",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("น\u{e34}\u{e49}วไขว\u{e49}"),
            keywords: &[
                "น\u{e34}\u{e49}วไขว\u{e49}",
                "ภาวนา",
                "ม\u{e37}อ",
                "โชคด\u{e35}",
                "ไขว\u{e49}",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("atanak edilen barmak"),
            keywords: &["atanak", "atanak edilen barmak", "barmak", "el", "şowlulyk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("louhiʻinima fehauaki"),
            keywords: &["louhiʻinima fehauaki"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("şans dileme"),
            keywords: &["el", "parmak", "çapraz", "şans", "şans dileme"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كېسىشكەن بارماقلار"),
            keywords: &["ئاق يول", "بارماق", "قول", "كېسىشكەن", "كېسىشكەن بارماقلار"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("схрещені пальці"),
            keywords: &["пальці", "схрещені", "удача"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کراس بناتی انگلیاں"),
            keywords: &["امید", "انگلی", "قسمت", "کراس", "کراس بناتی انگلیاں"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("kesishgan barmoqlar"),
            keywords: &["kesishgan barmoqlar", "omad"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("hai ngón tay bắt chéo"),
            keywords: &[
                "bàn tay",
                "chéo",
                "hai ngón tay bắt chéo",
                "may mắn",
                "ngón tay",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("laxasante ñaari baaraam"),
            keywords: &["baaraam", "laxasante ñaari baaraam", "loxo", "wërsëk"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iminwe enqamlezeneyo"),
            keywords: &[
                "iminwe enqamlezeneyo",
                "intlahla",
                "isandla",
                "ukunqamleza",
                "umnwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Igbekalera"),
            keywords: &["Igbekalera", "dábùú", "orírere", "ìka", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("交叉手指"),
            keywords: &["交叉", "交叉手指", "幸運", "手", "手指"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("交叉手指"),
            keywords: &["交叉", "交叉手指", "幸运", "手", "手指"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("交叉的手指"),
            keywords: &["交叉", "交叉的手指", "幸运", "手", "手指"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("祝好運"),
            keywords: &["加油", "好", "祝", "祝好運", "運"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iminwe ebhanqiwe"),
            keywords: &[
                "bhanqa",
                "iminwe ebhanqiwe",
                "inhlanhla",
                "isandla",
                "umunwe",
            ],
        },
    ],
};
#[doc = "🤞🏻"]
pub const CROSSED_FINGERS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤞🏻",
    codepoint: "1F91E 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "crossed fingers: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤞🏼"]
pub const CROSSED_FINGERS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤞🏼",
    codepoint: "1F91E 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "crossed fingers: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤞🏽"]
pub const CROSSED_FINGERS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤞🏽",
    codepoint: "1F91E 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "crossed fingers: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤞🏾"]
pub const CROSSED_FINGERS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤞🏾",
    codepoint: "1F91E 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "crossed fingers: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤞🏿"]
pub const CROSSED_FINGERS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤞🏿",
    codepoint: "1F91E 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "crossed fingers: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤟"]
pub const LOVE_YOU_GESTURE: crate::Emoji = crate::Emoji {
    glyph: "🤟",
    codepoint: "1F91F",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "love-you gesture",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("lief-vir-jou-gebaar"),
            keywords: &["Lvj", "hand", "lief-vir-jou-gebaar"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምልክትህን ወድጀዋለሁ"),
            keywords: &["ምልክትህን ወድጀዋለሁ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة أحبك"),
            keywords: &["أحبك", "إشارة أحبك", "بحبك"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9be}লপোৱ\u{9be}ৰ ইঙ\u{9cd}গিত"),
            keywords: &[
                "প\u{9cd}ৰেম",
                "ভ\u{9be}লপোৱ\u{9be}ৰ ইঙ\u{9cd}গিত",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sevgi jesti"),
            keywords: &["sevgi jesti", "sevgi əli"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жэст «люблю цябе»"),
            keywords: &["ILY", "жэст «люблю цябе»", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("жест „обичам те“"),
            keywords: &["жест „обичам те“", "обичам те", "ръка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}লব\u{9be}স\u{9be}র ইঙ\u{9cd}গিত"),
            keywords: &[
                "ভ\u{9be}লব\u{9be}স\u{9be}",
                "ভ\u{9be}লব\u{9be}স\u{9be}র ইঙ\u{9cd}গিত",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("volim te"),
            keywords: &["VT", "ruka", "volim", "volim te"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("gest de t’estimo"),
            keywords: &["dits", "gest de t’estimo", "mà", "t’estimo"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎬᎨᏳᎢ ᎤᏬᏯᏂᏍᎩ"),
            keywords: &["ᎤᏬᏰᏂ", "ᎬᎨᏳ", "ᎬᎨᏳᎢ ᎤᏬᏯᏂᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto „miluji tě“"),
            keywords: &["gesto", "gesto „miluji tě“", "láska", "miluju", "ruka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd caru ti"),
            keywords: &["arwydd caru ti", "caru ti", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("elsker dig-gestus"),
            keywords: &["Elsker dig", "Hånd", "elsker dig-gestus"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ich-liebe-dich-Geste"),
            keywords: &["Hand", "Ich liebe dich", "ich-liebe-dich-Geste"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κίνηση σε αγαπώ"),
            keywords: &["κίνηση σε αγαπώ", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("love-you gesture"),
            keywords: &["ILY", "hand", "love-you gesture"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("love you gesture"),
            keywords: &["ILY", "hand", "love you gesture", "love-you gesture"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("gesto de te quiero"),
            keywords: &["gesto de te quiero", "mano", "quiero"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("armastust väljendav žest"),
            keywords: &["ILY", "armastust väljendav žest", "käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("adarren keinua"),
            keywords: &["adarren keinua", "eskua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("علامت دوستت دارم"),
            keywords: &["دست", "دوست دارم", "دوستت دارم", "علامت دوستت دارم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("rakastan sinua -ele"),
            keywords: &["fanitus", "käsi", "rakastan sinua -ele", "rakkaus"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("love-you gesture"),
            keywords: &["ILY", "kamay", "love-you gesture"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kærleikshandabragd"),
            keywords: &["hond", "kærleiki", "kærleikshandabragd"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("signe je t’aime"),
            keywords: &["amour", "main", "signe je t’aime"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["amour", "je t’aime", "main", "signe", "signe je t’aime"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("comhartha grá"),
            keywords: &["comhartha", "comhartha ghrá", "grá", "lámh", "téarma ceana"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gluasad “Tha gaol agam ort”"),
            keywords: &["agam", "gaol", "gluasad “Tha gaol agam ort”", "làmh", "ort"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto das iniciais de \"I Love You\""),
            keywords: &[
                "I Love You",
                "ILY",
                "man",
                "xesto",
                "xesto das iniciais de \"I Love You\"",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાવભાવ પ\u{acd}રત\u{acd}ય\u{ac7} પ\u{acd}ર\u{ac7}મ"),
            keywords: &["હાવભાવ પ\u{acd}રત\u{acd}ય\u{ac7} પ\u{acd}ર\u{ac7}મ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("nunin soyayya"),
            keywords: &["ILY", "hannu", "nunin soyayya"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("בוהן, אצבע וזרת מורמות"),
            keywords: &["אהבה", "בוהן, אצבע וזרת מורמות", "יד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("किसी स\u{947} प\u{94d}यार जतान\u{947} क\u{947} हावभाव"),
            keywords: &[
                "ILY",
                "किसी स\u{947} प\u{94d}यार जतान\u{947} क\u{947} हावभाव",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("gesta \"volim te\""),
            keywords: &["gesta \"volim te\"", "ljubav", "ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szeretlek kézmozdulat"),
            keywords: &["kéz", "szeretlek", "szeretlek kézmozdulat"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("«սիրում եմ քեզ» նշան"),
            keywords: &["«սիրում եմ քեզ» նշան", "ձեռք", "սեռ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gerakan sayang kamu"),
            keywords: &["ILU", "ILY", "gerakan sayang kamu", "tangan"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ogbugbu-ịhụnanya"),
            keywords: &["ILY", "aka", "ogbugbu-ịhụnanya"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("elska-þig merki"),
            keywords: &["ILY", "elska-þig merki", "hendi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gesto ti amo"),
            keywords: &["gesto ti amo", "gesto tvb"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("アイラブユー"),
            keywords: &["アイラブユー", "愛してる", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan nuduhake tandha tresna sliramu"),
            keywords: &["ILY", "tangan", "tangan nuduhake tandha tresna sliramu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ჟესტი „მიყვარხარ“"),
            keywords: &["მიყვარხარ", "ჟესტი „მიყვარხარ“", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сені сүйемін белгісі"),
            keywords: &["сені сүйемін белгісі"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កាយវ\u{17b7}ការបង\u{17d2}ហាញក\u{17d2}ដ\u{17b8}ស\u{17d2}រឡាញ\u{17cb}"),
            keywords: &[
                "ILY",
                "កាយវ\u{17b7}ការបង\u{17d2}ហាញក\u{17d2}ដ\u{17b8}ស\u{17d2}រឡាញ\u{17cb}",
                "ប\u{17d2}រអប\u{17cb}ដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪ\u{ccd}ರೀತ\u{cbf}ಸುತ\u{ccd}ತೇನ\u{cc6} ಸ\u{cc2}ಚನ\u{cc6}"),
            keywords: &[
                "ಐಎಲ\u{ccd}\u{200c}ವೈ",
                "ಕೈ",
                "ಪ\u{ccd}ರೀತ\u{cbf}ಸುತ\u{ccd}ತೇನ\u{cc6} ಸ\u{cc2}ಚನ\u{cc6}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("사랑을 표시하는 손"),
            keywords: &["사랑 제스처", "사랑을 표시하는 손", "사랑해"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("त\u{941}ज\u{947}र मोग करता हावभाव"),
            keywords: &["आयलवय\u{941}", "त\u{941}ज\u{947}र मोग करता हावभाव", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сүйөм сени деген ишарат"),
            keywords: &["кол", "сени сүйөм", "сүйөм сени деген ишарат"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Léift-Geste"),
            keywords: &["Hand", "ILY", "Léift-Geste"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ທ\u{ec8}າເລ\u{eb5}ບຢ\u{eb9}"),
            keywords: &["ILY", "ທ\u{ec8}າເລ\u{eb5}ບຢ\u{eb9}", "ມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("„myliu tave“ gestas"),
            keywords: &["MYLIU", "ranka", "„myliu tave“ gestas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mīlas žests"),
            keywords: &["EMT", "mīlas žests", "roka"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu aroha-ki-a-koe"),
            keywords: &["aroha", "ringa", "tohu aroha-ki-a-koe"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("знак „те сакам“"),
            keywords: &["знак „те сакам“", "рака", "те сакам"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some(
                "ഞ\u{d3e}ൻ നിന\u{d4d}നെ സ\u{d4d}\u{200c}നേഹിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41} എന\u{d4d}ന ആംഗ\u{d4d}യം",
            ),
            keywords: &[
                "ഐ ലവ\u{d4d} യ\u{d42}",
                "കൈ",
                "ഞ\u{d3e}ൻ നിന\u{d4d}നെ സ\u{d4d}\u{200c}നേഹിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41}",
                "ഞ\u{d3e}ൻ നിന\u{d4d}നെ സ\u{d4d}\u{200c}നേഹിക\u{d4d}ക\u{d41}ന\u{d4d}ന\u{d41} എന\u{d4d}ന ആംഗ\u{d4d}യം",
                "വിരല\u{d41}കൾ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хайртай гэсэн дохио"),
            keywords: &["БЧХ", "гар", "хайртай гэсэн дохио"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("प\u{94d}र\u{947}म करतो/त\u{947} सा\u{902}गणार\u{947} हातवार\u{947}"),
            keywords: &[
                "प\u{94d}र\u{947}म करतो/त\u{947} सा\u{902}गणार\u{947} हातवार\u{947}",
                "माझ\u{902} त\u{941}झ\u{94d}यावर ख\u{941}प प\u{94d}र\u{947}म आह\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gerak isyarat cinta kamu"),
            keywords: &["ACK", "gerak isyarat cinta kamu", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ġest ta’ mħabba"),
            keywords: &["ILY", "id", "ġest ta’ mħabba"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ချစ\u{103a}တယ\u{103a}လ\u{102d}\u{102f}\u{1037}ပြောတ\u{1032}\u{1037} အမ\u{1030}အရာ",
            ),
            keywords: &[
                "ချစ\u{103a}တယ\u{103a}လ\u{102d}\u{102f}\u{1037}ပြောတ\u{1032}\u{1037} အမ\u{1030}အရာ",
                "ချစ\u{103a}တယ\u{103a}ဟ\u{102f} လက\u{103a}ချောင\u{103a}းများဖြင\u{1037}\u{103a} ပြေနေပ\u{102f}\u{1036}",
                "လက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("glad i deg-tegn"),
            keywords: &["ILY", "glad i deg", "glad i deg-tegn", "hånd", "tegnspråk"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("प\u{94d}र\u{947}मप\u{942}र\u{94d}ण भाव"),
            keywords: &[
                "प\u{94d}र\u{947}मप\u{942}र\u{94d}ण भाव",
                "म तिमीलाई माया गर\u{94d}छ\u{941}",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ik-hou-van-je-gebaar"),
            keywords: &["ILY", "hand", "ik-hou-van-je-gebaar"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("glad i deg-teikn"),
            keywords: &[
                "ILY",
                "glad i deg",
                "glad i deg-teikn",
                "hand",
                "teiknspråk",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ତ\u{b41}ମକ\u{b41} ଭଲପ\u{b3e}ଏ ଇଙ\u{b4d}ଗ\u{b3f}ତ"),
            keywords: &[
                "ଆଇଏଲୱ\u{b3e}ଇ",
                "ତ\u{b41}ମକ\u{b41} ଭଲପ\u{b3e}ଏ ଇଙ\u{b4d}ଗ\u{b3f}ତ",
                "ତ\u{b41}ମକ\u{b41}- ଭଲପ\u{b3e}ଏ ଇଙ\u{b4d}ଗ\u{b3f}ତ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਤ\u{a41}ਹਾਨ\u{a42}\u{a70} ਪਿਆਰ ਕਰਨ ਦਾ ਇਸ\u{a3c}ਾਰਾ"),
            keywords: &[
                "ਤ\u{a41}ਹਾਨ\u{a42}\u{a70} ਪਿਆਰ ਕਰਨ ਦਾ ਇਸ\u{a3c}ਾਰਾ",
                "ਪਿਆਰ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("تہاڈے نال پریم آ دا اشارہ"),
            keywords: &[
                "اسم صفت دے مطابق کیتا گیا کم",
                "تہاڈے نال پریم آ دا اشارہ",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("A Lọ\u{301}v Yu Sain"),
            keywords: &[
                "A Lọ\u{301}v Yu",
                "A Lọ\u{301}v Yu Sain",
                "A Lọ\u{301}v Yú Sain",
                "ALY",
                "Hand",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gest Kocham cię"),
            keywords: &["gest Kocham cię", "kocham", "ręka"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د مینې اشاره"),
            keywords: &["ILY", "د مینې اشاره", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("gesto de \"te amo\""),
            keywords: &["gesto de \"te amo\"", "mão", "te amo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("gesto \"amo-te\""),
            keywords: &["amo-te", "gesto \"amo-te\"", "gesto de amo-te", "mão"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("munanki yupi"),
            keywords: &["ILY", "maki", "munanki yupi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gest cu semnificația te iubesc"),
            keywords: &["gest cu semnificația te iubesc", "mână", "te iubesc"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1025"),
            keywords: &["E10-1025"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("я-тебя-люблю"),
            keywords: &[
                "ILY",
                "жест",
                "рука",
                "я тебя люблю",
                "я-тебя-люблю",
                "язык глухих",
                "язык знаков",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cya ndagukunda"),
            keywords: &["ILY", "ikiganza", "ikimenyetso cya ndagukunda"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پيار جو اشارو"),
            keywords: &["هٿ", "پيار جو اشارو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඔබට ආදරෙය\u{dd2} ඉඟ\u{dd2}ය"),
            keywords: &["අත", "ඔආඉ", "ඔබට ආදරෙය\u{dd2} ඉඟ\u{dd2}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ľúbim ťa"),
            keywords: &["ruka", "ľúbim ťa", "ľúbiť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za ljubim te"),
            keywords: &["RTM", "roka", "znak za ljubim te"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("meedaarta waan ku jecelahay ah"),
            keywords: &[
                "WKJ",
                "gacan",
                "meedaarta waan ku jecelahay",
                "meedaarta waan ku jecelahay ah",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjesti \"të dua\""),
            keywords: &["\"Të dua\"", "dorë", "gjesti \"të dua\""],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("покрет волим те"),
            keywords: &["волим те", "покрет волим те", "рукa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pokret volim te"),
            keywords: &["pokret volim te", "ruka", "volim te"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("jag älskar dig-gest"),
            keywords: &["hand", "jag älskar dig-gest"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya \"nakupenda\""),
            keywords: &["ishara ya \"nakupenda\"", "mkono", "nakupenda"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("லவ\u{bcd}-யூ சைகை"),
            keywords: &["ஐ லவ\u{bcd} யூ", "கை", "சைகை", "லவ\u{bcd}-யூ சைகை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "న\u{c3f}న\u{c4d}ను ప\u{c4d}ర\u{c47}మ\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను అన\u{c47} సంజ\u{c4d}ఞ",
            ),
            keywords: &[
                "చ\u{c47}య\u{c3f}",
                "న\u{c3f}న\u{c4d}ను ప\u{c4d}ర\u{c47}మ\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను",
                "న\u{c3f}న\u{c4d}ను ప\u{c4d}ర\u{c47}మ\u{c3f}స\u{c4d}తున\u{c4d}న\u{c3e}ను అన\u{c47} సంజ\u{c4d}ఞ",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("имову ишораи \"Туро дӯст медорам\""),
            keywords: &["ILY", "даст", "имову ишораи \"Туро дӯст медорам\""],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ทำม\u{e37}อ ‘ฉ\u{e31}นร\u{e31}กเธอ’"),
            keywords: &["ทำม\u{e37}อ ‘ฉ\u{e31}นร\u{e31}กเธอ’", "ม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("seni söýýän ümi"),
            keywords: &["MSS", "el", "seni söýýän ümi"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima fakaʻilonga mafu"),
            keywords: &["nima fakaʻilonga mafu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("seni seviyorum işareti"),
            keywords: &["SS", "el", "seni seviyorum işareti"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سۆيىمەن دېگەن ئىشارە"),
            keywords: &["سۆيىمەن", "سۆيىمەن دېگەن ئىشارە", "قول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жест «кохаю тебе»"),
            keywords: &["жест «кохаю тебе»", "піднята рука"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آپ سے محبت کا اشارہ"),
            keywords: &["آپ سے محبت", "آپ سے محبت کا اشارہ", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("sevaman degan ishora"),
            keywords: &["sevaman degan ishora"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cử chỉ yêu nhau"),
            keywords: &["anh yêu em", "cử chỉ yêu nhau", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("liyaar mbëggeel"),
            keywords: &["ILY", "liyaar mbëggeel", "loxo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umjekulo othi ndiyakuthanda"),
            keywords: &["I-ILY", "isandla", "umjekulo othi ndiyakuthanda"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ìfọwọ\u{301}júwè mo ní ìfẹ\u{301}"),
            keywords: &["ILY", "ìfọwọ\u{301}júwè mo ní ìfẹ\u{301}", "Ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("愛您嘅手勢"),
            keywords: &["愛您嘅手勢", "我愛您", "手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("爱您嘅手势"),
            keywords: &["我爱您", "手", "爱您嘅手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("爱你的手势"),
            keywords: &["我爱你", "手", "爱你的手势"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("愛你手勢"),
            keywords: &["愛你手勢", "我愛你", "手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("我愛你手勢"),
            keywords: &["愛你手勢", "我愛你", "我愛你手勢", "手"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukukhombisa uthando"),
            keywords: &["ILY", "isandla", "ukukhombisa uthando"],
        },
    ],
};
#[doc = "🤟🏻"]
pub const LOVE_YOU_GESTURE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤟🏻",
    codepoint: "1F91F 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "love-you gesture: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤟🏼"]
pub const LOVE_YOU_GESTURE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤟🏼",
    codepoint: "1F91F 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "love-you gesture: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤟🏽"]
pub const LOVE_YOU_GESTURE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤟🏽",
    codepoint: "1F91F 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "love-you gesture: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤟🏾"]
pub const LOVE_YOU_GESTURE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤟🏾",
    codepoint: "1F91F 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "love-you gesture: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤟🏿"]
pub const LOVE_YOU_GESTURE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤟🏿",
    codepoint: "1F91F 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "love-you gesture: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤘"]
pub const SIGN_OF_THE_HORNS: crate::Emoji = crate::Emoji {
    glyph: "🤘",
    codepoint: "1F918",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sign of the horns",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("horingteken"),
            keywords: &[
                "hand",
                "horings",
                "horingteken",
                "liggaam",
                "rock",
                "vinger",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የቀንዶች ምልክት"),
            keywords: &["ቀንዶች", "አካል", "እጅ", "የቀንዶች ምልክት", "ጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة قرون"),
            keywords: &["إشارة قرون", "إصبع", "جسد", "قرون", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হৰ\u{9cd}ণ দিয\u{9bc}\u{9be}ৰ চিহ\u{9cd}ন"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "শিং",
                "হ\u{9be}ত",
                "হৰ\u{9cd}ণ দিয\u{9bc}\u{9be}ৰ চিহ\u{9cd}ন",
                "ৰক-অন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("buynuz işarəsi"),
            keywords: &[
                "barmaq",
                "buynuz işarəsi",
                "buynuzlar",
                "orqan",
                "əl",
                "əla",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("жэст «каза»"),
            keywords: &["жыве рок", "жэст «каза»", "пальцы", "рогі", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Знак на рогата"),
            keywords: &["Знак на рогата", "пръст", "рога", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হর\u{9cd}ণ দেওয\u{9bc}\u{9be}র চিহ\u{9cd}ন"),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "মন ম\u{9be}ত\u{9be}ন",
                "শরীর",
                "শিং",
                "হর\u{9cd}ণ দেওয\u{9bc}\u{9be}র চিহ\u{9cd}ন",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("znak rogova"),
            keywords: &["pokazivanje", "rogovi", "ruka", "znak", "znak rogova"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dits en forma de banyes"),
            keywords: &["banyes", "dits", "dits en forma de banyes", "rock"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏲᎾ ᏓᏟᎶᏍᏛ"),
            keywords: &["ᎤᏬᏱ", "ᎤᏲᎾ ᏓᏟᎶᏍᏛ", "ᎦᏰᏌᏛ", "ᏅᏯ-ᏄᏍᏗ", "ᏧᏲᎾ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto parohů"),
            keywords: &[
                "gesto parohů",
                "parohy",
                "paroháč",
                "prst",
                "rock",
                "rohy",
                "ruka",
                "tělo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("arwydd y cyrn"),
            keywords: &["arwydd y cyrn", "bys", "corff", "cyrn", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("djævletegn"),
            keywords: &[
                "djævletegn",
                "finger",
                "heavy metal",
                "horn",
                "hånd",
                "metal",
                "rock",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Teufelsgruß"),
            keywords: &["Finger", "Hand", "Hörner", "Rock", "Teufel", "Teufelsgruß"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Teufelsgruss"),
            keywords: &["Finger", "Hand", "Hörner", "Rock", "Teufel", "Teufelsgruss"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χειρονομία ροκ"),
            keywords: &[
                "δάχτυλο",
                "κέρατα",
                "ροκάρω",
                "σώμα",
                "χέρι",
                "χειρονομία ροκ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("sign of the horns"),
            keywords: &["finger", "hand", "horns", "rock-on", "sign of the horns"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["finger", "hand", "horns", "rock on"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["finger", "hand", "horns", "rock on", "sign of the horns"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano haciendo el signo de cuernos"),
            keywords: &[
                "cuernos",
                "dedo",
                "mano",
                "mano haciendo el signo de cuernos",
                "rock",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gesto de cuernos"),
            keywords: &[
                "cuernos",
                "dedos",
                "gesto de cuernos",
                "mano",
                "rock",
                "roll",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mano haciendo los cuernos"),
            keywords: &[
                "cuernos",
                "dedos",
                "mano haciendo los cuernos",
                "rock",
                "roll",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mano haciendo los cuernos"),
            keywords: &[
                "cuernos",
                "dedos",
                "mano haciendo los cuernos",
                "rock",
                "roll",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("sarvede märk"),
            keywords: &["keha", "käsi", "rokk", "sarved", "sarvede märk", "sõrm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("adarrak adierazten dituen eskua"),
            keywords: &[
                "adarra",
                "adarrak adierazten dituen eskua",
                "eskua",
                "gorputza",
                "hatza",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نماد شاخ"),
            keywords: &["انگشت", "دست", "راک", "شاخ", "شیطان", "نماد شاخ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sarviele"),
            keywords: &["käsi", "rock", "sarvet", "sarviele", "sormi", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("rock ’n’ roll"),
            keywords: &[
                "daliri",
                "kamay",
                "rock ‘n’ roll",
                "rock ’n’ roll",
                "rock-on",
                "sungay",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("horntekin"),
            keywords: &["horn", "horntekin", "rock", "rokkur", "tekin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cornes avec les doigts"),
            keywords: &["cornes", "cornes avec les doigts", "main"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["cornes", "cornes avec les doigts", "doigts", "main", "rock"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("siombail na n-adharc"),
            keywords: &[
                "lean ort",
                "lámh",
                "lámh na binne",
                "méar",
                "siombail na n-adharc",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("samhla nan adharc"),
            keywords: &[
                "adharc",
                "corrag",
                "làmh",
                "meur",
                "rocamaid",
                "samhla nan adharc",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("man facendo os cornos"),
            keywords: &["cornos", "man", "man facendo os cornos", "rock and roll"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શિ\u{a82}ગડાન\u{ac1}\u{a82} ચિહ\u{acd}ન"),
            keywords: &[
                "આ\u{a82}ગળી",
                "રોક-ઑન",
                "શરીર",
                "શિ\u{a82}ગડા\u{a82}",
                "શિ\u{a82}ગડાન\u{ac1}\u{a82} ચિહ\u{acd}ન",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("alamar ƙahoni"),
            keywords: &["alamar ƙahoni", "hannu", "moriya", "yatsa", "ƙahoni"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מסמנת קרניים"),
            keywords: &[
                "אצבע מורה",
                "זרת",
                "יד",
                "יד מסמנת קרניים",
                "יד מסמנת קרניים באצבע מורה ובזרת",
                "קרניים",
                "רוק-אנ׳-רול",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("सी\u{902}ग का चिन\u{94d}ह"),
            keywords: &[
                "उ\u{902}गली",
                "रॉक ऑन",
                "शरीर",
                "सी\u{902}ग",
                "सी\u{902}ग का चिन\u{94d}ह",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("znak rogova"),
            keywords: &["prst", "rogovi", "tijelo", "znak rogova", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("metálvilla"),
            keywords: &["kéz", "metál", "metálvilla", "szarvak", "ördögvilla"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("եղջյուրների նշան"),
            keywords: &["եղջյուրներ", "եղջյուրների նշան", "ձեռք", "մատ", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lambang tanduk"),
            keywords: &[
                "badan",
                "jari",
                "lambang tanduk",
                "tanduk",
                "tangan",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akara nke mpi gasị"),
            keywords: &[
                "aka",
                "akara nke mpi gasị",
                "mkpịsịaka",
                "mkpịsịaka abụọ",
                "mpi gasị",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("rokkmerki"),
            keywords: &["fingur", "glennt", "hönd", "líkami", "rokkmerki"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("segno delle corna"),
            keywords: &[
                "corna",
                "fare le corna",
                "rock and roll",
                "segno delle corna",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("角の指サイン"),
            keywords: &["キツネ", "手", "角の指サイン"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tandha sungu"),
            keywords: &[
                "driji",
                "isarat gandem apike",
                "sungu",
                "tandha sungu",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("რქების ნიშანი"),
            keywords: &[
                "თითი",
                "როკი",
                "რქები",
                "რქების ნიშანი",
                "სხეული",
                "ტანი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мүйіз белгісі"),
            keywords: &["мүйіз", "мүйіз белгісі", "саусақ", "тамаша", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("djævletegn"),
            keywords: &[
                "djævletegn",
                "finger",
                "heavy metal",
                "horn",
                "hånd",
                "krop",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រើម\u{17d2}រាមធ\u{17d2}វើជាសញ\u{17d2}ញាស\u{17d2}នែង"),
            keywords: &[
                "ប\u{17d2}រើម\u{17d2}រាមធ\u{17d2}វើជាសញ\u{17d2}ញាស\u{17d2}នែង",
                "ម\u{17d2}រាមព\u{17b8}រ",
                "ស\u{17d2}នែង",
                "អេម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೊಂಬುಗಳ ಸ\u{cc2}ಚನ\u{cc6}"),
            keywords: &["ಕೊಂಬು", "ಕೊಂಬುಗಳ ಸ\u{cc2}ಚನ\u{cc6}", "ಕೊಂಬುಗಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뿔 모양 손짓"),
            keywords: &["락 음악", "뿔 모양 손짓", "손 모양", "힙합"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("शि\u{902}गा\u{902}च\u{947}\u{902} चिन\u{94d}न"),
            keywords: &[
                "बोट",
                "रॉक-ऑन",
                "शि\u{902}गा\u{902}",
                "शि\u{902}गा\u{902}च\u{947}\u{902} चिन\u{94d}न",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мүйүз белгиси"),
            keywords: &["дене", "кол", "манжа", "мүйүз", "мүйүз белгиси"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mano cornuta, Harenzeechen"),
            keywords: &[
                "Fanger",
                "Hand",
                "Haren",
                "Mano cornuta, Harenzeechen",
                "rocken",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb9}ນ\u{eb5}\u{ec9}ວແບບສ\u{eb1}ນຍາລ\u{eb1}ກເຂ\u{ebb}າ"),
            keywords: &[
                "ຊ\u{eb9}ນ\u{eb5}\u{ec9}ວແບບສ\u{eb1}ນຍາລ\u{eb1}ກເຂ\u{ebb}າ",
                "ນ\u{eb4}\u{ec9}ວມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
                "ເຂ\u{ebb}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ragų ženklas"),
            keywords: &["pirštas", "ragai", "ragų ženklas", "ranka", "rokas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("ragu simbols"),
            keywords: &[
                "Dio",
                "pirksts",
                "ragi",
                "ragu simbols",
                "roka",
                "rokmūzika",
                "smagais metāls",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tohu o ngā pihi"),
            keywords: &["kai kaha", "matimati", "pihi", "ringa", "tohu o ngā pihi"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("рака што покажува рогови"),
            keywords: &["прст", "рака", "рака што покажува рогови", "рогови", "рок"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൊമ\u{d4d}പ\u{d41}കള\u{d41}ടെ ചിഹ\u{d4d}നം"),
            keywords: &[
                "ആഘോഷിക\u{d4d}ക\u{d41}ക",
                "കൈ",
                "കൊമ\u{d4d}പ\u{d41}കള\u{d41}ടെ ചിഹ\u{d4d}നം",
                "കൊമ\u{d4d}പ\u{d41}കൾ",
                "വിരൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("эвэрний тэмдэг"),
            keywords: &["гар", "рок", "хуруу", "эвэр", "эвэрний тэмдэг"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("शिगा\u{902}च\u{947} चिन\u{94d}ह"),
            keywords: &[
                "बोट",
                "रॉक ऑन",
                "शि\u{902}ग",
                "शि\u{902}गा\u{902}च\u{947} चिन\u{94d}ह",
                "शिगा\u{902}च\u{947} चिन\u{94d}ह",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol tanduk"),
            keywords: &["badan", "jari", "rock", "simbol tanduk", "tanduk", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("sinjal tal-qrun"),
            keywords: &["id", "qrun", "rock-on", "sinjal tal-qrun", "suba’"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဦးချ\u{102d}\u{102f}များ၏ သင\u{103a}\u{1039}ကေတ"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
                "ဦးချ\u{102d}\u{102f}",
                "ဦးချ\u{102d}\u{102f}ပ\u{102f}\u{1036}စ\u{1036} လက\u{103a}ဟန\u{103a} သင\u{103a}\u{1039}ကေတ",
                "ဦးချ\u{102d}\u{102f}များ၏ သင\u{103a}\u{1039}ကေတ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("rock’n’roll"),
            keywords: &["finger", "horn", "hånd", "rock’n’roll"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("सि\u{902}ङको चिन\u{94d}ह"),
            keywords: &[
                "औ\u{902}ला",
                "रक-अन",
                "सि\u{902}ङको चिन\u{94d}ह",
                "सिङ\u{94d}",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("duivelshorens"),
            keywords: &["duivelshorens", "hand", "hoorns", "rock on", "vinger"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("rock’n’roll"),
            keywords: &["finger", "hand", "horn", "rock’n’roll"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଶ\u{b3f}ଙ\u{b4d}ଗ ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ରକ\u{b4d}\u{200c}-ଅନ\u{b4d}\u{200c}",
                "ଶ\u{b3f}ଙ\u{b4d}ଗ",
                "ଶ\u{b3f}ଙ\u{b4d}ଗ ଚ\u{b3f}ହ\u{b4d}ନ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a41}ਸ\u{a3c}ੀ ਜਾਹਰ ਕਰਨਾ"),
            keywords: &[
                "ਉ\u{a02}ਗਲ",
                "ਖ\u{a41}ਸ\u{a3c}ੀ ਜਾਹਰ ਕਰਨਾ",
                "ਜਿ\u{a71}ਤ",
                "ਸਿ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سینگ سائن آف کرو"),
            keywords: &["ا\u{64f}نگل", "راک-آن", "سینگ", "سینگ سائن آف کرو", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Họ\u{301}n Sain"),
            keywords: &[
                "Fínga",
                "Hand",
                "Họn Sain",
                "Họn-dẹm",
                "Họ\u{301}n Sain",
                "Rọ\u{301}k-ọ\u{301}n Sain",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("gest rogów"),
            keywords: &["gest rogów", "rocker", "rogi", "znak rockersów"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("دوشاخه"),
            keywords: &["دوشاخ", "دوشاخه", "لاس", "مست", "ګوتي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("saudação do rock"),
            keywords: &["chifres", "dedos", "mão", "saudação do rock"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão a fazer cornos"),
            keywords: &[
                "cornos",
                "corpo",
                "dedo",
                "mão",
                "mão a fazer cornos",
                "rock’n’roll",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waqrakuna unancha"),
            keywords: &["maki", "rock", "rukana", "waqrakuna", "waqrakuna unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul cu coarne"),
            keywords: &["coarne", "deget", "mână", "rock", "semnul cu coarne"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1018"),
            keywords: &["E10-1018"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рокерский жест"),
            keywords: &[
                "жест",
                "коза",
                "пальцы",
                "рок",
                "рокерский жест",
                "рука",
                "фанат",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikimenyetso cy’amahembe"),
            keywords: &[
                "amahembe",
                "ikiganza",
                "ikimenyetso cy’amahembe",
                "ikimenyetso cy’intsinzi",
                "urutoki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("سڱن جو نشان"),
            keywords: &["آڱر", "سڱ", "سڱن جو نشان", "شور مچايو", "هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හෝන\u{dca}ස\u{dca} ලක\u{dd4}ණ"),
            keywords: &[
                "අං",
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "රොක\u{dca} ඔන\u{dca}",
                "හෝන\u{dca}ස\u{dca} ලක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("paroháč"),
            keywords: &["paroháč", "prst", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("znak za rogove"),
            keywords: &[
                "dlan",
                "prst",
                "rock za vedno",
                "rogovi",
                "telo",
                "znak za rogove",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("calaamadda geesaha"),
            keywords: &["calaamadda geesaha", "far", "gacan", "geesaha", "qirid"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shenja e brirëve"),
            keywords: &["dorë", "gisht", "rok", "shenja e brirëve"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак рогова"),
            keywords: &[
                "знак рогова",
                "метал",
                "прст",
                "рoгoви",
                "рукa",
                "тело",
                "шaкa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["знак рогова"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak rogova"),
            keywords: &[
                "metal",
                "prst",
                "rogovi",
                "ruka",
                "telo",
                "znak rogova",
                "šaka",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["znak rogova"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("djävulstecknet"),
            keywords: &["djävulstecknet", "hand", "horn", "hårdrock"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya pembe"),
            keywords: &[
                "cheza",
                "ishara ya pembe",
                "kidole",
                "mkono",
                "mwili",
                "pembe",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "அசத\u{bcd}திவிட\u{bcd}ட\u{bc0}ர\u{bcd}கள\u{bcd} என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
            ),
            keywords: &[
                "அசத\u{bcd}திட\u{bc0}ங\u{bcd}க",
                "அசத\u{bcd}திவிட\u{bcd}ட\u{bc0}ர\u{bcd}கள\u{bcd} என\u{bcd}பதைக\u{bcd} குறிக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "கொம\u{bcd}பு போன\u{bcd}ற சைகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c4a}మ\u{c4d}ములు సూచ\u{c3f}ంచ\u{c47} గుర\u{c4d}తు"),
            keywords: &[
                "క\u{c4a}మ\u{c4d}ము",
                "క\u{c4a}మ\u{c4d}ములు సూచ\u{c3f}ంచ\u{c47} గుర\u{c4d}తు",
                "గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ишораи шохҳо"),
            keywords: &["ангушт", "даст", "ишораи ду шох", "ишораи шохҳо", "шохҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39}น\u{e34}\u{e49}วชาวร\u{e47}อก"),
            keywords: &[
                "ช\u{e39}น\u{e34}\u{e49}วชาวร\u{e47}อก",
                "ม\u{e37}อ",
                "ร\u{e47}อก",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("şah belgisi"),
            keywords: &["barmak", "el", "yrgyldatmak", "şah belgisi", "şahlar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima fakaʻilonga fakatēvolo"),
            keywords: &["nima fakaʻilonga fakatēvolo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("boynuz işareti"),
            keywords: &["beden", "boynuz", "boynuz işareti", "el", "parmak", "rock"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مۈڭگۈز بەلگىسى"),
            keywords: &["بارماق", "تاش", "قول", "مۈڭگۈز", "مۈڭگۈز بەلگىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жест «роги»"),
            keywords: &[
                "жест «роги»",
                "коза",
                "палець",
                "рука",
                "символ рогів рукою",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ سے سینگوں کا نشان"),
            keywords: &["انگلی", "جسم", "سینگ", "ہاتھ", "ہاتھ سے سینگوں کا نشان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shox belgisi"),
            keywords: &["barmoq", "qo‘l", "rok", "shox belgisi", "shoxlar", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("ký hiệu cặp sừng"),
            keywords: &["ký hiệu cặp sừng", "ngón tay", "sừng", "tay", "tuyệt vời"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo def màndarga béjjen"),
            keywords: &[
                "baaraam",
                "béjjen",
                "lem",
                "loxo",
                "loxo def màndarga béjjen",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("uphawu lweempondo"),
            keywords: &[
                "iimpondo",
                "isandla",
                "qhubeka",
                "umnwe",
                "uphawu lweempondo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aami Awọn Iwo"),
            keywords: &["19900", "Aami Awọn Iwo", "ìka", "ìwo", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牛角手勢"),
            keywords: &["手", "手指", "搖滾", "牛角", "牛角手勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牛角手势"),
            keywords: &["手", "手指", "摇滚", "牛角", "牛角手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("摇滚"),
            keywords: &["手", "摇滚", "角", "金属礼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("ROCK"),
            keywords: &["ROCK", "搖滾精神"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("uphawu lwezimpondo"),
            keywords: &[
                "isandla",
                "izimpondo",
                "umunwe",
                "umzimba",
                "uphawu lwezimpondo",
            ],
        },
    ],
};
#[doc = "🤘🏻"]
pub const SIGN_OF_THE_HORNS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤘🏻",
    codepoint: "1F918 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sign of the horns: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤘🏼"]
pub const SIGN_OF_THE_HORNS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤘🏼",
    codepoint: "1F918 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sign of the horns: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤘🏽"]
pub const SIGN_OF_THE_HORNS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤘🏽",
    codepoint: "1F918 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sign of the horns: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤘🏾"]
pub const SIGN_OF_THE_HORNS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤘🏾",
    codepoint: "1F918 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sign of the horns: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤘🏿"]
pub const SIGN_OF_THE_HORNS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤘🏿",
    codepoint: "1F918 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "sign of the horns: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤙"]
pub const CALL_ME_HAND: crate::Emoji = crate::Emoji {
    glyph: "🤙",
    codepoint: "1F919",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "call me hand",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("bel my hand"),
            keywords: &["bel", "bel my hand", "hand"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ደውልልኝ የእጅ ምልክት"),
            keywords: &["እጅ", "ደውልልኝ", "ደውልልኝ የእጅ ምልክት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("إشارة للاتصال"),
            keywords: &["إشارة للاتصال", "اتصال", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফোন কৰ\u{9be}"),
            keywords: &["কল", "ফোন কৰ\u{9be}", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mənə zəng et"),
            keywords: &["mənə zəng et", "telefon", "yığmaq", "zəng", "əlaqə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("пазвані мне"),
            keywords: &["жэст", "пазвані", "пазвані мне", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("знак за обаждане"),
            keywords: &["знак", "знак за обаждане", "обаждане", "ръка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ফোন কোরো"),
            keywords: &["কল", "ফোন কোরো", "হ\u{9be}ত"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nazovi"),
            keywords: &["nazovi", "poziv", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mà que representa una trucada"),
            keywords: &["mà", "mà que representa una trucada", "trucada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏍᏓᏁᎸᎩ ᎤᏬᏱ"),
            keywords: &["ᎤᏬᏱ", "ᏗᏍᏓᏁᎸᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("gesto „zavolej mi“"),
            keywords: &[
                "gesto „zavolej mi“",
                "ruka",
                "zatelefonovat",
                "zavolat",
                "zavolej",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llaw ffonia fi"),
            keywords: &["ffonio", "llaw", "llaw ffonia fi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ring til mig-hånd"),
            keywords: &[
                "hånd",
                "krop",
                "opringning",
                "ring til mig-hånd",
                "ringer",
                "telefonhånd",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("ruf-mich-an-Handzeichen"),
            keywords: &[
                "Hand",
                "Ruf-mich-an-Handzeichen",
                "anrufen",
                "ruf-mich-an-Handzeichen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("τηλεφώνησέ μου"),
            keywords: &["κλήση", "τηλεφώνησέ μου", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("call me hand"),
            keywords: &["call", "call me hand", "hand"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: Some("call-me hand"),
            keywords: &["call", "call-me hand", "hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["call", "call-me hand", "hand", "shaka"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("call me hand"),
            keywords: &["call", "call me hand", "call-me hand", "hand"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano haciendo el gesto de llamar"),
            keywords: &[
                "llamar",
                "mano",
                "mano haciendo el gesto de llamar",
                "meñique",
                "pulgar",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("gesto de llamada"),
            keywords: &["gesto", "gesto de llamada", "llamada", "mano"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("mano haciendo el gesto de llamar"),
            keywords: &[
                "gesto",
                "llamada",
                "mano",
                "mano haciendo el gesto de llamar",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("mano haciendo el gesto de llamar"),
            keywords: &[
                "gesto",
                "llamada",
                "mano",
                "mano haciendo el gesto de llamar",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("helista mulle"),
            keywords: &["helista", "helista mulle", "käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("deitzeko esku-keinua"),
            keywords: &["deitu", "deitzeko esku-keinua", "eskua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست به شکل تلفن"),
            keywords: &["تلفن", "تماس بگیر", "دست", "دست به شکل تلفن", "زنگ بزن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("soita minulle"),
            keywords: &["käsi", "soita", "soita minulle"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tawagan mo ko"),
            keywords: &["kamay", "tawag", "tawagan mo ko"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("telefontekin"),
            keywords: &["hond", "tekin", "telefon", "telefontekin"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("signe appel téléphonique avec les doigts"),
            keywords: &[
                "appel",
                "main",
                "signe",
                "signe appel téléphonique avec les doigts",
                "téléphone",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("appelle-moi"),
            keywords: &["appel", "appelle-moi", "main", "signe", "téléphone"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("an lámh cur glao orm"),
            keywords: &[
                "an lámh cur glao orm",
                "glaoch",
                "glaoigh orm",
                "guthán",
                "lámh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh a’ comharradh “Cuir fòn thugam”"),
            keywords: &["fòn", "làmh", "làmh a’ comharradh “Cuir fòn thugam”"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("xesto de chamar por teléfono"),
            keywords: &["chamar", "chámame", "man", "xesto de chamar por teléfono"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મન\u{ac7} કૉલ કરો હાથ"),
            keywords: &["કૉલ", "મન\u{ac7} કૉલ કરો હાથ", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hannun kira ni"),
            keywords: &["hannu", "hannun kira ni", "kira"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מסמנת ’תתקשר אליי’"),
            keywords: &["יד", "יד מסמנת ’תתקשר אליי’", "תתקשר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कॉल करन\u{947} का स\u{902}क\u{947}त"),
            keywords: &["कॉल", "कॉल करन\u{947} का स\u{902}क\u{947}त", "हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nazovi me"),
            keywords: &["nazovi me", "poziv", "ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("„hívj fel” kézjel"),
            keywords: &["hívás", "kéz", "„hívj fel” kézjel"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("զանգիր ինձ"),
            keywords: &["զանգել", "զանգիր ինձ", "ձեռք"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("panggil saya"),
            keywords: &["panggil saya", "telepon", "telepon aku", "telepon saya"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("kpọọ mụ aka"),
            keywords: &["aka", "kpọọ", "kpọọ mụ aka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hringdu"),
            keywords: &["hringdu", "hringitákn", "hringja", "hönd"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano con gesto di chiamata"),
            keywords: &[
                "chiamare",
                "mano",
                "mano con gesto di chiamata",
                "telefonare",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("電話の合図"),
            keywords: &["手", "電話", "電話のジェスチャー", "電話の合図"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan nuduhake tandha telpuna aku"),
            keywords: &["tangan", "tangan nuduhake tandha telpuna aku", "telpun"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("„დამირეკე“ ჟესტი"),
            keywords: &["დარეკვა", "ხელი", "„დამირეკე“ ჟესტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("хабарлас"),
            keywords: &["хабарлас"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("ring til mig-hånd"),
            keywords: &[
                "hånd",
                "krop",
                "opringning",
                "ring til mig-hånd",
                "ringer",
                "telefonhånd",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដៃជាសញ\u{17d2}ញាតេទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ"),
            keywords: &[
                "ដៃ",
                "ដៃជាសញ\u{17d2}ញាតេទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
                "តេទ\u{17bc}រស\u{17d0}ព\u{17d2}ទ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕರ\u{cc6} ಮಾಡು ಸಂಜ\u{ccd}ಞ\u{cc6}"),
            keywords: &["ಕರ\u{cc6} ಮಾಡು", "ಕರ\u{cc6} ಮಾಡು ಸಂಜ\u{ccd}ಞ\u{cc6}", "ಕೈ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("전화를 걸라는 손 모양"),
            keywords: &["손가락", "손모양", "전화", "전화를 걸라는 손 모양"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{94d}हाका कॉल कर हात"),
            keywords: &["कॉल", "म\u{94d}हाका कॉल कर हात", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("“мага чал” ишараты"),
            keywords: &["ишарат", "кол", "мага чал", "“мага чал” ишараты"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Telefon-Handzeechen"),
            keywords: &["Hand", "Telefon-Handzeechen", "uruffen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເຮ\u{eb1}ດມ\u{eb7}ໂທຫາຂ\u{ec9}ອຍ"),
            keywords: &["ມ\u{eb7}", "ເຮ\u{eb1}ດມ\u{eb7}ໂທຫາຂ\u{ec9}ອຍ", "ໂທ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("gestas paskambink man"),
            keywords: &["gestas paskambink man", "ranka", "skambinti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("piezvani man"),
            keywords: &["piezvani man", "roka", "zvans"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa waea mai"),
            keywords: &["ringa", "ringa waea mai", "waea"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јави ми се"),
            keywords: &["дланка", "повик", "јави ми се"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിളിക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള സ\u{d42}ചന"),
            keywords: &[
                "കൈ",
                "വിളിക\u{d4d}ക\u{d3e}ന\u{d41}ള\u{d4d}ള സ\u{d42}ചന",
                "വിളിക\u{d4d}ക\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("залгаарай дохио"),
            keywords: &["дохио", "залгаарай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("मला कॉल करा हात"),
            keywords: &["कॉल", "मला कॉल करा हात", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telefon saya"),
            keywords: &["tangan", "telefon", "telefon saya"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id ċempilli"),
            keywords: &["id", "id ċempilli", "sejħa"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဖ\u{102f}န\u{103a}းခေါ\u{103a}ပါပြ လက\u{103a}ဟန\u{103a}"),
            keywords: &[
                "ခေါ\u{103a}ဆ\u{102d}\u{102f}သည\u{103a}",
                "ဖ\u{102f}န\u{103a}းခေါ\u{103a}ပါပြ လက\u{103a}ဟန\u{103a}",
                "လက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("ring meg-hånd"),
            keywords: &["hånd", "ring meg-hånd", "ringe"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("मलाई फोन गर\u{94d}न\u{941} भन\u{94d}न\u{947} सङ\u{94d}क\u{947}त"),
            keywords: &[
                "फोन गर\u{94d}न\u{941}",
                "मलाई फोन गर\u{94d}न\u{941} भन\u{94d}न\u{947} सङ\u{94d}क\u{947}त",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bel me-gebaar"),
            keywords: &["bel me-gebaar", "bellen", "hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("ring meg-hand"),
            keywords: &["hand", "ring meg-hand", "ringje"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କଲ\u{b4d}\u{200c} ମ\u{b3f} ହ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡ"),
            keywords: &[
                "କଲ\u{b4d}\u{200c}",
                "କଲ\u{b4d}\u{200c} ମ\u{b3f} ହ\u{b4d}ୟ\u{b3e}ଣ\u{b4d}ଡ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a48}ਨ\u{a42}\u{a70} ਕਾਲ ਕਰ\u{a4b} ਸ\u{a70}ਕ\u{a47}ਤ"),
            keywords: &[
                "ਕਾਲ",
                "ਟ\u{a48}ਲੀਫ\u{a3c}\u{a4b}ਨ",
                "ਮ\u{a48}ਨ\u{a42}\u{a70} ਕਾਲ ਕਰ\u{a4b} ਸ\u{a70}ਕ\u{a47}ਤ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کال کردا ہتھ"),
            keywords: &["کال", "کال کردا ہتھ", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Mék Yu Fón Mí Hand"),
            keywords: &["Hand", "Kọl", "Mék Yu Fón Mí Hand"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("dłoń w geście „Zadzwoń do mnie”"),
            keywords: &["dzwonić", "dłoń w geście „Zadzwoń do mnie”", "telefonować"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("زنګ وهلو اشاره"),
            keywords: &["زنګ", "زنګ وهلو اشاره", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("sinal \"me liga\""),
            keywords: &["ligar", "sinal \"me liga\""],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("liga-me"),
            keywords: &[
                "chamada",
                "gesto \"liga-me\"",
                "gesto de liga-me",
                "gesto liga-me",
                "liga-me",
                "mão",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("waqyawani maki"),
            keywords: &["maki", "qayana", "waqyawani maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semnul sună-mă"),
            keywords: &["apela", "mână", "semnul sună-mă", "suna"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1019"),
            keywords: &["E10-1019"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("жест «позвони мне»"),
            keywords: &[
                "жест",
                "жест \"позвони мне\"",
                "жест «позвони мне»",
                "позвони",
                "позвони мне",
                "рука",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganza gisaba guhamagarwa"),
            keywords: &["guhamagara", "ikiganza", "ikiganza gisaba guhamagarwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مونکي ڪال ڪريو هٿ"),
            keywords: &["مونکي ڪال ڪريو هٿ", "هٿ", "ڪال"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මට ඇමත\u{dd4}මක\u{dca} දෙන\u{dca}න ඇගව\u{dd3}ම"),
            keywords: &[
                "අත",
                "ඇමත\u{dd4}ම",
                "මට ඇමත\u{dd4}මක\u{dca} දෙන\u{dca}න ඇගව\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zavoláme si"),
            keywords: &["hovor", "ruka", "telefonovať", "zavolať", "zavoláme si"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pokliči me"),
            keywords: &["pokliči", "pokliči me", "roka"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacanta ah isoo wac"),
            keywords: &["gacan", "gacanta ah isoo wac", "isoo wac", "wac"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorë me shenjën “më telefono”"),
            keywords: &["dorë", "dorë me shenjën “më telefono”", "telefono"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("знак руком за телефон"),
            keywords: &["знак руком за телефон", "зови", "рука"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["знак руком за телефон"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("znak rukom za telefon"),
            keywords: &["ruka", "znak rukom za telefon", "zovi"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["znak rukom za telefon"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ring mig-hand"),
            keywords: &["hand", "ring", "ring mig-hand"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya “nipigie simu”"),
            keywords: &["ishara ya “nipigie simu”", "mkono", "nipigie simu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("என\u{bcd}னை அழை"),
            keywords: &["அழை", "என\u{bcd}னை அழை", "கை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "క\u{c3e}ల\u{c4d} చ\u{c47}య\u{c3f} అన\u{c3f} సూచ\u{c3f}ంచ\u{c47} చ\u{c47}య\u{c3f}",
            ),
            keywords: &[
                "క\u{c3e}ల\u{c4d}",
                "క\u{c3e}ల\u{c4d} చ\u{c47}య\u{c3f} అన\u{c3f} సూచ\u{c3f}ంచ\u{c47} చ\u{c47}య\u{c3f}",
                "చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ба ман занг занед"),
            keywords: &["ба ман занг занед", "даст", "занг"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ม\u{e37}อโทร"),
            keywords: &["ม\u{e37}อ", "ม\u{e37}อโทร", "โทร"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("jaňlaş eli"),
            keywords: &["el", "jaň", "jaňlaş eli"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima fakaʻilonga tā mai"),
            keywords: &["nima fakaʻilonga tā mai"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beni ara işareti"),
            keywords: &["ara", "beni ara işareti", "el"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تېلېفون قىلىڭ"),
            keywords: &["تېلېفون قىلىڭ", "قول", "چاقىرىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("жест «подзвони мені»"),
            keywords: &[
                "жест «подзвони мені»",
                "жест рукою «подзвони мені»",
                "рука",
                "телефон",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کال کرنے کا اشارہ"),
            keywords: &["اشارہ", "کال", "کال کرنے کا اشارہ", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("menga telefon qil"),
            keywords: &["ishora", "menga telefon qil", "qo‘l", "telefon qil"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn tay gọi cho tôi"),
            keywords: &["bàn tay", "bàn tay gọi cho tôi", "gọi điện"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo nanga ma woo"),
            keywords: &["loxo", "loxo nanga ma woo", "woote"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandla esithi ndifowunele"),
            keywords: &["isandla", "isandla esithi ndifowunele", "umnxeba"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọwọ Ipeni"),
            keywords: &["ìpè", "Ọwọ Ipeni", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("打電話俾我嘅手勢"),
            keywords: &["手", "打電話", "打電話俾我嘅手勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("打电话俾我嘅手势"),
            keywords: &["手", "打电话", "打电话俾我嘅手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("给我打电话"),
            keywords: &["手", "电话", "给我打电话"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("打給我"),
            keywords: &["打", "打給我", "電話"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("call 我"),
            keywords: &["call 我", "打", "電話"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ngifonele"),
            keywords: &["fona", "isandla", "ngifonele"],
        },
    ],
};
#[doc = "🤙🏻"]
pub const CALL_ME_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤙🏻",
    codepoint: "1F919 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "call me hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤙🏼"]
pub const CALL_ME_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤙🏼",
    codepoint: "1F919 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "call me hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤙🏽"]
pub const CALL_ME_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤙🏽",
    codepoint: "1F919 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "call me hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤙🏾"]
pub const CALL_ME_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤙🏾",
    codepoint: "1F919 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "call me hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤙🏿"]
pub const CALL_ME_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤙🏿",
    codepoint: "1F919 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "call me hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-partial",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
