#[doc = "👋"]
pub const WAVING_HAND: crate::Emoji = crate::Emoji {
    glyph: "👋",
    codepoint: "1F44B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "waving hand",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("wuiwende hand"),
            keywords: &["hand", "liggaam", "waai", "wuif", "wuiwende hand"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ተወዛዋዥ እጅ"),
            keywords: &["ሞገድ", "ተወዛዋዥ እጅ", "አካል", "እጅ", "እጅ ማወዛወዝ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تلويح باليد"),
            keywords: &["تلويح", "تلويح باليد", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ত লৰোৱ\u{9be}"),
            keywords: &["লহৰ", "লৰোৱ\u{9be}", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("əl sallayan əllər"),
            keywords: &["orqan", "yelləmə", "yelləmək", "əl", "əl sallayan əllər"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("махае рукой"),
            keywords: &["вітаю", "махае рукой", "маханне", "рука"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Махане с ръка"),
            keywords: &["Махане с ръка", "махане", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ত ন\u{9be}ড\u{9bc}\u{9be}নো"),
            keywords: &[
                "দোল\u{9be}নো",
                "ন\u{9be}ড\u{9bc}\u{9be}নো",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mahanje rukom"),
            keywords: &["mahanje", "mahanje rukom", "mahanje rukom ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mà que saluda"),
            keywords: &["mà", "mà que saluda", "salutació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏲᎵᎭ"),
            keywords: &["ᎠᏐᏰᎭ", "ᎠᏲᎵᎭ", "ᎤᏬᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mávající ruka"),
            keywords: &["mávající ruka", "mávat", "mávání", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llaw yn chwifio"),
            keywords: &["chwifio", "llaw", "llaw yn chwifio"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vinker"),
            keywords: &["hånd", "vinker"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("winkende Hand"),
            keywords: &["Hand", "Winken", "winkende Hand"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χέρι που χαιρετά"),
            keywords: &["νεύμα", "σώμα", "χέρι", "χέρι που χαιρετά", "χαιρετώ"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("waving hand"),
            keywords: &["hand", "wave", "waving"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano saludando"),
            keywords: &["agitar", "mano", "mano saludando", "saludar", "saludo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("mano saludando"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("lehvitav käsi"),
            keywords: &["keha", "käsi", "lehvitav käsi", "lehvitus"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mugitzen ari den eskua"),
            keywords: &["eskua", "gorputza", "mugitu", "mugitzen ari den eskua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("تکان دادن دست"),
            keywords: &["بدن", "تکان دادن", "تکان دادن دست", "دست", "موج"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("käden heilautus"),
            keywords: &[
                "heilautus",
                "käden heilautus",
                "käsi",
                "vartalo",
                "vilkuttaa",
                "vilkutus",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("kumakaway na kamay"),
            keywords: &["bumabati", "kamay", "kumakaway", "kumakaway na kamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("veitrandi hond"),
            keywords: &["hond", "veitra", "veitrandi hond", "vinka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("signe de la main"),
            keywords: &["coucou", "main", "signe de la main"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["coucou", "main", "signe", "signe de la main"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh ag croitheadh"),
            keywords: &["croitheadh", "lámh", "lámh ag croitheadh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh a’ smèideadh"),
            keywords: &["làmh", "làmh a’ smèideadh", "smèid", "smèideadh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("man saudando"),
            keywords: &["man", "man saudando", "saudar", "saúdo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ હલાવવા"),
            keywords: &["હલાવવા", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hannu mai wurgawa"),
            keywords: &["hannu", "hannu mai wurgawa", "wurga", "wurgawa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד מנופפת"),
            keywords: &["ביי", "יד", "להתראות", "מנופפת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हाथ हिलाना"),
            keywords: &["हाथ", "हिलाना"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruka koja maše"),
            keywords: &["mahanje", "ruka", "ruka koja maše", "tijelo", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("integető kéz"),
            keywords: &["integetés", "integető kéz", "kéz", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թափահարող ձեռք"),
            keywords: &["թափահարել", "թափահարող", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan melambai"),
            keywords: &["badan", "lambai", "tangan", "tangan melambai", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("na-efe aka"),
            keywords: &["aka", "na-efe", "ofufe"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hönd veifar"),
            keywords: &["hönd", "hönd veifar", "veifa"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano che saluta"),
            keywords: &["mano", "mano che saluta", "salutare"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手を振る"),
            keywords: &["バイバイ", "手", "手を振る"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan ngawe-awe"),
            keywords: &["awe-awe", "tangan", "tangan ngawe-awe"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ხელის ქნევა"),
            keywords: &["ტალღა", "ქნევა", "ხელი", "ხელის ქნევა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қол бұлғау"),
            keywords: &["бұлғап тұр", "бұлғау", "дене", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vinker"),
            keywords: &["hånd", "vinker"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("បក\u{17cb}ដៃ"),
            keywords: &["ដៃ", "បក\u{17cb}", "បក\u{17cb}ដៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕೈ ಬೀಸುತ\u{ccd}ತ\u{cbf}ರುವುದು"),
            keywords: &["ಕೈ ಬೀಸುತ\u{ccd}ತ\u{cbf}ರುವುದು", "ಕೈ ಬೀಸುವ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("흔드는 손"),
            keywords: &["펼친 손", "흔드는 손"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हात हालोवप"),
            keywords: &["हात", "हालोवचो", "हालोवप"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол булгалоо"),
            keywords: &["булгалоо", "дене", "кол"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("wénkend Hand"),
            keywords: &["Hand", "wénken", "wénkend"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂບກມ\u{eb7}"),
            keywords: &["ມ\u{eb7}", "ຮ\u{ec8}າງກາຍ", "ໂບກມ\u{eb7}"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mojuojanti ranka"),
            keywords: &["mojuoja", "mojuojanti ranka", "mojuoti", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mājoša roka"),
            keywords: &["mājoša roka", "māt", "roka", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa pōhirihiri"),
            keywords: &["pōhiri", "pōhirihiri", "ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мавтање со рака"),
            keywords: &["мавтање", "мавтање со рака", "поздрав", "рака", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വീശ\u{d41}ന\u{d4d}ന കൈ"),
            keywords: &[
                "കൈ",
                "വീശ\u{d41}ക",
                "വീശ\u{d41}ന\u{d4d}ന കൈ",
                "വീശ\u{d41}ന\u{d4d}ന\u{d41}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("мэндчилж байгаа гар"),
            keywords: &["гар", "даллаж буй гар", "даллах", "мэндчилж байгаа гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हव\u{947}त हलविणारा हात"),
            keywords: &[
                "हवा",
                "हव\u{947}त हलविणारा हात",
                "हव\u{947}त हलविण\u{947}",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lambai tangan"),
            keywords: &["badan", "lambai", "melambai", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id ixxejjer"),
            keywords: &["id", "id ixxejjer", "qed ixejjer", "xejjer"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေသည\u{1037}\u{103a} လက\u{103a}"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းပြနေသည\u{1037}\u{103a}ပ\u{102f}\u{1036}",
                "ဝ\u{103e}ေ\u{1037}ယမ\u{103a}းနေသည\u{1037}\u{103a} လက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("vinkende hånd"),
            keywords: &["hånd", "vinke", "vinkende hånd", "vinking"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हल\u{94d}लाइरह\u{947}को हात"),
            keywords: &[
                "शरीर",
                "हल\u{94d}लाइरह\u{947}को",
                "हल\u{94d}ल\u{947}को",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("zwaaiende hand"),
            keywords: &["hand", "zwaai", "zwaaien", "zwaaiende hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("vinkande hand"),
            keywords: &["hand", "vinkande hand", "vinke", "vinking"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦୋଳ\u{b3e}ୟମ\u{b3e}ନ ହ\u{b3e}ତ"),
            keywords: &[
                "ଦୋଳ\u{b3e}ୟମ\u{b3e}ନ ହ\u{b3e}ତ",
                "ହଲ\u{b3e}ଇବ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਥ ਹਿਲਾਉਣਾ"),
            keywords: &["ਲਹਿਰਾਉਣਾ", "ਹ\u{a71}ਥ", "ਹ\u{a71}ਥ ਹਿਲਾਉਣਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ ہلاندیاں"),
            keywords: &["لہر", "لہراندا", "ہتھ", "ہتھ ہلاندیاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand Wé De Wev"),
            keywords: &["Baibaí", "Hand", "Hand Wé De Wev", "Wev"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("machająca dłoń"),
            keywords: &["machająca dłoń"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاس خورول"),
            keywords: &["خورول", "خوځول", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mão acenando"),
            keywords: &["aceno", "mão", "mão acenando"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão a acenar"),
            keywords: &["acenar", "aceno", "corpo", "mão", "mão a acenar"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qinquykachasqa maki"),
            keywords: &["maki", "qinquykachasqa", "qinquykachay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mână fluturată"),
            keywords: &["despărțire", "mână", "mână fluturată", "semn"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-520"),
            keywords: &["E10-520"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("машет рукой"),
            keywords: &["взмах", "машет рукой", "привет", "приветствие", "рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganza gipepera"),
            keywords: &["gupepera", "ikiganza", "ikiganza gipepera"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("لڏندڙ هٿ"),
            keywords: &["لهر", "لڏندڙ هٿ", "لڏڻ", "هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අත වැන\u{dd3}ම"),
            keywords: &["අත", "අත වනම\u{dd2}න\u{dca}", "අත වැන\u{dd3}ම"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mávajúca ruka"),
            keywords: &["mávajúca ruka", "mávať", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mahajoča dlan"),
            keywords: &["dlan", "mahajoča dlan", "mahanje", "mahati", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan haadin"),
            keywords: &["gacan", "gacan haadin", "haadi", "haadinayaa"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorë që tundet"),
            keywords: &["dorë", "dorë që tundet", "që tundet", "trup", "tund"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("рука која маше"),
            keywords: &["мaхaњe", "рукa", "рука која маше"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["рука која маше"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("ruka koja maše"),
            keywords: &["mahanje", "ruka", "ruka koja maše"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["ruka koja maše"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vinkande hand"),
            keywords: &["hand", "vinka", "vinkande hand"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono unaopunga"),
            keywords: &["kupunga", "mkono", "mkono unaopunga", "mwili", "punga"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கையசைத\u{bcd}தல\u{bcd}"),
            keywords: &[
                "கை",
                "கையசைக\u{bcd}கும\u{bcd} சின\u{bcd}னம\u{bcd}",
                "கையசைத\u{bcd}தல\u{bcd}",
                "சின\u{bcd}னம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c47}య\u{c3f} ఊపడం"),
            keywords: &["ఊపడం", "చ\u{c47}య\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("ҳаракати пешу қафои даст"),
            keywords: &[
                "даст",
                "мавҷ",
                "ҳаракати пешу қафо",
                "ҳаракати пешу қафои даст",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("โบกม\u{e37}อ"),
            keywords: &["ม\u{e37}อ", "อว\u{e31}ยวะ", "โบก", "โบกม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("galgaýan el"),
            keywords: &["el", "galgatmak", "galgaýan"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima taʻataʻalo"),
            keywords: &["nima taʻataʻalo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("el sallama"),
            keywords: &["el", "sallama"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قول پۇلاڭلىتىش"),
            keywords: &["قول", "پۇلاڭلاش", "پۇلاڭلىتىش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рука махає"),
            keywords: &["долоня", "махати", "помах", "рука махає", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہاتھ لہرانا"),
            keywords: &["جسم", "لہرانا", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("shapaloq"),
            keywords: &["qoʻl", "shapaloq", "silkitish", "siltash"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("vẫy tay"),
            keywords: &["tay", "vẫy", "đang vẫy"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("tàllal loxo"),
            keywords: &["buy tàllal", "loxo", "tàllal"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ukuwangawangisa isandla"),
            keywords: &["isandla", "ukuwangawangisa", "wangawangisa"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("N Juwọ"),
            keywords: &["N Juwọ", "juwọ\u{301}", "ń juwọ\u{301}", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("揮手"),
            keywords: &["手", "揮手", "揮緊手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("挥手"),
            keywords: &["手", "挥手", "挥紧手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("挥手"),
            keywords: &["你好", "再见", "挥手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("揮手"),
            keywords: &["手", "揮手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuphakamisa isandla"),
            keywords: &["isandla", "ukuphakamisa isandla", "umzimba"],
        },
    ],
};
#[doc = "👋🏻"]
pub const WAVING_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👋🏻",
    codepoint: "1F44B 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waving hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👋🏼"]
pub const WAVING_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👋🏼",
    codepoint: "1F44B 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waving hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👋🏽"]
pub const WAVING_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👋🏽",
    codepoint: "1F44B 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waving hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👋🏾"]
pub const WAVING_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👋🏾",
    codepoint: "1F44B 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waving hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👋🏿"]
pub const WAVING_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👋🏿",
    codepoint: "1F44B 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "waving hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤚"]
pub const RAISED_BACK_OF_HAND: crate::Emoji = crate::Emoji {
    glyph: "🤚",
    codepoint: "1F91A",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "raised back of hand",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("handrug"),
            keywords: &["agterkant van hand", "hand", "handrug"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ኋል የተዘረጋ እጅ"),
            keywords: &["ወደ ኋል", "ወደ ኋል የተዘረጋ እጅ", "የተዘረጋ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("\u{202b}ظهر يد مرفوعة"),
            keywords: &["ظاهر يد", "مرفوع", "\u{202b}ظهر يد مرفوعة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}তৰ পিছফ\u{9be}ল"),
            keywords: &[
                "হ\u{9be}ত তোল\u{9be}",
                "হ\u{9be}ত দঙ\u{9be}",
                "হ\u{9be}তৰ পিছফ\u{9be}ল",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yuxarı qalxan əl arxası"),
            keywords: &[
                "arxa",
                "qaldırmaq",
                "yuxarı",
                "yuxarı qalxan əl arxası",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паднятая далонь"),
            keywords: &["далонь", "паднятая"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("вдигната длан"),
            keywords: &["вдигната", "длан"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}তের পেছন দিক"),
            keywords: &["হ\u{9be}ত তোল\u{9be}", "হ\u{9be}তের পেছন দিক"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("ruka gore"),
            keywords: &["dlan", "podignuto", "ruka", "ruka gore", "uspravno"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("revers de la mà"),
            keywords: &["alçada", "mà", "revers", "revers de la mà"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᏒᎵᏛᏅ ᎣᏂᏗᏢ ᎣᏬᏰᎾ"),
            keywords: &["ᎠᏒᎵᏛᏅ ᎣᏂᏗᏢ ᎣᏬᏰᎾ", "ᎣᏬᏰᏂᎣᏂᏗᏜ", "ᎤᎵᏌᎳᏓᏅᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("hřbet zvednuté ruky"),
            keywords: &[
                "hřbet",
                "hřbet zvednuté ruky",
                "ruka",
                "zdvižená",
                "zvednutá",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cefn llaw wedi’i chodi"),
            keywords: &["cefn llaw", "cefn llaw wedi’i chodi", "wedi’i chodi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løftet håndryg"),
            keywords: &[
                "bagside af hånd",
                "hånd",
                "håndryg",
                "løftet hånd",
                "løftet håndryg",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("erhobene Hand von hinten"),
            keywords: &[
                "Hand",
                "erhoben",
                "erhobene Hand von hinten",
                "erhobener Handrücken",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σηκωμένο χέρι ανάποδα"),
            keywords: &[
                "ανάποδη χεριού",
                "σηκωμένη ανάποδη χεριού",
                "σηκωμένο",
                "σηκωμένο χέρι ανάποδα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("raised back of hand"),
            keywords: &["backhand", "raised", "raised back of hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("dorso de la mano"),
            keywords: &["dorso", "dorso de la mano", "levantado", "mano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("palma de la mano"),
            keywords: &["mano", "palma", "palma de la mano"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("dorso de la mano"),
            keywords: &[
                "dorso",
                "dorso de la mano",
                "dorso de la mano alzado",
                "mano",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("dorso de la mano levantada"),
            keywords: &[
                "dorso de la mano",
                "dorso de la mano levantada",
                "dorso de la mano saludando",
                "levantada",
            ],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("tõstetud käsi"),
            keywords: &["käsi", "tõstetud"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku-azpia altxatuta"),
            keywords: &["altxatuta", "esku-azpi", "esku-azpia altxatuta"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پشت دست"),
            keywords: &["اجازه", "بالا بردن دست", "دست", "موافقت", "پشت دست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kämmenselkä koholla"),
            keywords: &[
                "kohotettu",
                "kädenselkä",
                "kädenselkä koholla",
                "kämmenselkä koholla",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakataas na baliktad na kamay"),
            keywords: &["baliktad", "nakataas", "nakataas na baliktad na kamay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("handarbak"),
            keywords: &["handarbak"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dos de main levée"),
            keywords: &["dos de main levée", "levée", "main"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["dos de main", "dos de main levée", "levée", "main"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cúl láimhe in airde"),
            keywords: &[
                "cúl",
                "cúl láimhe in airde",
                "in airde",
                "lámh",
                "lámh in airde",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cùl làimhe air a thogail"),
            keywords: &["cùl", "cùl làimhe air a thogail", "làmh", "togail"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("palma da man"),
            keywords: &["deter", "man", "palma", "palma da man"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાથ"),
            keywords: &["બ\u{ac7}કહ\u{ac7}ન\u{acd}ડ", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗagaggen bayan hannu"),
            keywords: &["bayan hannu", "ɗagagge", "ɗagaggen bayan hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("גב יד פרוש"),
            keywords: &["גב יד", "גב יד פרוש", "כלפי מעלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उठ\u{947} ह\u{941}ए हाथ क\u{947} पीछ\u{947} का भाग"),
            keywords: &[
                "उठा",
                "उठ\u{947} ह\u{941}ए हाथ क\u{947} पीछ\u{947} का भाग",
                "पिछला हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("ruka gore"),
            keywords: &["dlan", "podignuto", "ruka", "ruka gore", "uspravno"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("kézfej"),
            keywords: &["felemelt", "kézfej"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձեռքի ափ"),
            keywords: &["բարձրացրած", "ձեռքի ափ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("angkat tangan"),
            keywords: &["angkat tangan", "berhenti", "jangan", "stop"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("azụ aka nke ewelitere elu"),
            keywords: &["azụ aka", "azụ aka nke ewelitere elu", "ewelitere elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("upprétt hönd"),
            keywords: &["hönd", "lófi", "upprétt"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dorso mano alzata"),
            keywords: &["alzata", "dorso mano alzata", "mano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("手の甲"),
            keywords: &["手", "手の甲"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan diangkat nuduhake gegere bae"),
            keywords: &[
                "diangkat",
                "geger tangan",
                "tangan diangkat nuduhake gegere bae",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აწეული ხელის ზურგიდან"),
            keywords: &["აწეული", "აწეული ხელის ზურგიდან", "ხელის ზურგი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("алақанын көрсетті"),
            keywords: &["алақан", "алақанын көрсетті", "көрсет"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("løftet baghånd"),
            keywords: &["baghånd", "hånd", "krop", "løftet"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17d2}នងដៃលាឡើង"),
            keywords: &["ខ\u{17d2}នងដៃ", "ខ\u{17d2}នងដៃលាឡើង", "លើកឡើង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಅಂಗೈ ಹ\u{cbf}ಂಭಾಗ ತೋರ\u{cbf}ಸು"),
            keywords: &[
                "ಅಂಗೈ ಹ\u{cbf}ಂಭಾಗ",
                "ಅಂಗೈ ಹ\u{cbf}ಂಭಾಗ ತೋರ\u{cbf}ಸು",
                "ತೋರ\u{cbf}ಸು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손등"),
            keywords: &["들어보이기", "손등", "손바닥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उखलिल\u{94d}ल\u{94d}या हाताची फाट"),
            keywords: &[
                "उखलिल\u{94d}ल\u{94d}या हाताची फाट",
                "उबारिल\u{94d}लो",
                "हाताची फाट",
                "हाताची फाट उबारल\u{94d}या",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көтөрүлгөн алакан"),
            keywords: &["алакан", "көтөрүлгөн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("héichgehalenen Handréck"),
            keywords: &["Handréck", "héichgehalen", "héichgehalenen Handréck"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{ebb}ກຫ\u{ebc}\u{eb1}ງມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຍ\u{ebb}ກ",
                "ຍ\u{ebb}ກຫ\u{ebc}\u{eb1}ງມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ",
                "ຫ\u{ebc}\u{eb1}ງມ\u{eb7}",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pakelta viršutinė plaštakos pusė"),
            keywords: &["pakelta", "pakelta viršutinė plaštakos pusė", "plaštaka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pacelta plauksta"),
            keywords: &["pacelta", "pacelta plauksta", "roka"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("tāmuri tū"),
            keywords: &["tāmuri", "tū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("подигната дланка"),
            keywords: &["горе", "дланка", "подигната"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉയർത\u{d4d}തിയ പ\u{d41}റം കൈ"),
            keywords: &[
                "ഉയർത\u{d4d}തിയ പ\u{d41}റം കൈ",
                "ഉയർത\u{d4d}തിയത\u{d4d}",
                "പ\u{d41}റം കൈ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өргөсөн гарын ар"),
            keywords: &["гарын ар", "өргөсөн", "өргөсөн гарын ар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उचल\u{942}न हाताची मागची बाज\u{942} दाखवण\u{947}"),
            keywords: &[
                "उचल\u{942}न",
                "उचल\u{942}न हाताची मागची बाज\u{942}",
                "उचल\u{942}न हाताची मागची बाज\u{942} दाखवण\u{947}",
                "मागची बाज\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("angkat belakang tapak tangan"),
            keywords: &["angkat", "angkat belakang tapak tangan", "tapak tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id minn wara mgħollija"),
            keywords: &["id minn wara", "id minn wara mgħollija", "mgħollija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လက\u{103a}ပြန\u{103a}ထောင\u{103a}ပြဟန\u{103a}"),
            keywords: &[
                "ထောင\u{103a}ပြ",
                "လက\u{103a}ပြန\u{103a}",
                "လက\u{103a}ပြန\u{103a}ထောင\u{103a}ပြဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("løftet håndbak"),
            keywords: &["hånd", "håndbak", "løftet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पछाडिबाट उठ\u{947}को हात"),
            keywords: &[
                "उठ\u{947}को",
                "पछाडिबाट उठ\u{947}को हात",
                "हातको पछाडि पाटो",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("achterkant van opgeheven hand"),
            keywords: &[
                "achterkant van opgeheven hand",
                "hand",
                "handrug",
                "opgestoken",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("løfta handbak"),
            keywords: &["handbak", "løfta"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଠ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ ପଛ"),
            keywords: &[
                "ଉଠ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ ପଛ",
                "ଉଠ\u{b3e}ଯ\u{b3e}ଇଛ\u{b3f}",
                "ହ\u{b3e}ତର ପଛ ଭ\u{b3e}ଗ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖੜ\u{a4d}ਹਾ ਕੀਤਾ ਪ\u{a41}\u{a71}ਠਾ ਹ\u{a71}ਥ"),
            keywords: &[
                "ਖੜ\u{a4d}ਹਾ ਕੀਤਾ ਪ\u{a41}\u{a71}ਠਾ ਹ\u{a71}ਥ",
                "ਪਿਛਲਾ ਹ\u{a71}ਥ",
                "ਪ\u{a41}\u{a71}ਠਾ ਪ\u{a70}ਜਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ہتھ دا ابھریا پچھلا پاسا"),
            keywords: &[
                "ا\u{64f}بھریا ہوئیا",
                "بیک ہینڈ",
                "ہتھ دا ابھریا پچھلا پاسا",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand Im Bak Wé Dẹm Réz Ọp"),
            keywords: &["Hand Im Bak", "Hand Im Bak Wé Dẹm Réz Ọp", "Rez"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wzniesiony grzbiet dłoni"),
            keywords: &[
                "powitanie",
                "pozdrowienie",
                "pożegnanie",
                "uniesiona dłoń",
                "wzniesiony grzbiet dłoni",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("لاس شاخوا اچوتول"),
            keywords: &["اوچت", "لاس شاخوا", "لاس شاخوا اچوتول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dorso da mão levantado"),
            keywords: &[
                "dorso da mão levantado",
                "levantada",
                "mão",
                "palma",
                "pare",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão com costas para fora"),
            keywords: &["levantada", "mão com costas para fora", "palma"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("juqharisqa maki"),
            keywords: &["jinchʼa", "juqharisqa", "juqharisqa maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dosul palmei ridicat"),
            keywords: &["dosul palmei", "dosul palmei ridicat", "ridicat"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1020"),
            keywords: &["E10-1020"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("поднятая рука"),
            keywords: &["ладонь", "поднятая", "поднятая рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("inyuma y’ikiganza kizamuye"),
            keywords: &[
                "inyuma y’ikiganza kizamuye",
                "ruzamuye",
                "urushyi rw’ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هٿ جي پٺ مٿي ڪيل"),
            keywords: &["مٿي ڪيل", "هٿ جي پٺ مٿي ڪيل", "پويون هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ප\u{dd2}ට\u{dd2} අත ඔසවන ලද\u{dd2}"),
            keywords: &[
                "ඔසව\u{dd2}ම",
                "ප\u{dd2}ට\u{dd2} අත",
                "ප\u{dd2}ට\u{dd2} අත ඔසවන ලද\u{dd2}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdvihnutá ruka spakruky"),
            keywords: &["ruka", "spakruky", "zdvihnutá"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvignjena hrbtna stran dlani"),
            keywords: &[
                "dlan",
                "dvignjena",
                "dvignjena hrbtna stran dlani",
                "hrbtna stran",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kor u qaaday gacanta gadaal"),
            keywords: &[
                "gacanta gadaal",
                "kor u qaaday gacanta gadaal",
                "kor u qaadid",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorë e ngritur nga ana e kurrizit"),
            keywords: &[
                "dorë e ngritur nga ana e kurrizit",
                "i ngritur",
                "kurriz dore",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("подигнут длан"),
            keywords: &["длан", "подигнут длан", "подигнуто", "стани", "шака"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("podignut dlan"),
            keywords: &["dlan", "podignut dlan", "podignuto", "stani", "šaka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("höjd handrygg"),
            keywords: &["hand", "höjd handrygg", "lyft"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("kuinua mkono"),
            keywords: &["kuinua mkono", "mkono juu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உயர\u{bcd}த\u{bcd}திய கை"),
            keywords: &[
                "உயர\u{bcd}த\u{bcd}திய கை",
                "உயர\u{bcd}த\u{bcd}துதல\u{bcd}",
                "கை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ప\u{c48}క\u{c46}త\u{c4d}త\u{c3f} చూప\u{c3f}స\u{c4d}తున\u{c4d}న చ\u{c47}త\u{c3f} వ\u{c46}నుకవ\u{c48}పు",
            ),
            keywords: &[
                "చ\u{c47}త\u{c3f} వ\u{c46}నుకవ\u{c48}పు",
                "ప\u{c48}క\u{c46}త\u{c4d}తడం",
                "ప\u{c48}క\u{c46}త\u{c4d}త\u{c3f} చూప\u{c3f}స\u{c4d}తున\u{c4d}న చ\u{c47}త\u{c3f} వ\u{c46}నుకవ\u{c48}పు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("пушти дасти бардошташуда"),
            keywords: &["бардошташуда", "пушти даст", "пушти дасти бардошташуда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ยกม\u{e37}อ"),
            keywords: &["ยกม\u{e37}อ", "หล\u{e31}งม\u{e37}อ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("galdyrylan el arkasy"),
            keywords: &["eliň arkasy", "galdyrylan", "galdyrylan el arkasy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuʻanima hiki ki ʻolunga"),
            keywords: &["tuʻanima hiki ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("elinin tersini kaldırma"),
            keywords: &["elinin tersi", "elinin tersini kaldırma", "kaldırma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆتۈرگەن قولنىڭ ئارقىسى"),
            keywords: &["قارا قول", "كۆتۈرگەن", "كۆتۈرگەن قولنىڭ ئارقىسى"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піднята рука тильною стороною"),
            keywords: &[
                "долоня",
                "піднята",
                "піднята рука тильною стороною",
                "тильна",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کھڑے ہاتھ کی پشت"),
            keywords: &["پشت", "کھڑا", "کھڑے ہاتھ کی پشت", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘tarilgan kaft"),
            keywords: &["kaft", "ko‘tarilgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mu bàn tay giơ lên"),
            keywords: &["giơ lên", "mu bàn tay", "mu bàn tay giơ lên"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("ginaawu loxo bu jog"),
            keywords: &["buñ yëkkati", "ginaaw loxo", "ginaawu loxo bu jog"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umva wesandla onyusiweyo"),
            keywords: &[
                "esinyusiweyo",
                "isandla esimnyama",
                "umva wesandla onyusiweyo",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Na Ẹhin Ọwọ Soke"),
            keywords: &["Na Ẹhin Ọwọ Soke", "nà sókè", "ẹ\u{300}yìn ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("反手舉起"),
            keywords: &["反手", "反手舉起", "舉起"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("反手举起"),
            keywords: &["举起", "反手", "反手举起"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("立起的手背"),
            keywords: &["手", "手背", "立起", "立起的手背"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("豎起手掌"),
            keywords: &["手", "掌", "豎", "豎起手掌"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("thula"),
            keywords: &["ingemuva lesandla", "siphakamisiwe", "thula"],
        },
    ],
};
#[doc = "🤚🏻"]
pub const RAISED_BACK_OF_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤚🏻",
    codepoint: "1F91A 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "raised back of hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤚🏼"]
pub const RAISED_BACK_OF_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤚🏼",
    codepoint: "1F91A 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "raised back of hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤚🏽"]
pub const RAISED_BACK_OF_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤚🏽",
    codepoint: "1F91A 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "raised back of hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤚🏾"]
pub const RAISED_BACK_OF_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤚🏾",
    codepoint: "1F91A 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "raised back of hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤚🏿"]
pub const RAISED_BACK_OF_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤚🏿",
    codepoint: "1F91A 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "raised back of hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖐\u{fe0f}"]
pub const HAND_WITH_FINGERS_SPLAYED: crate::Emoji = crate::Emoji {
    glyph: "🖐\u{fe0f}",
    codepoint: "1F590 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "hand with fingers splayed",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "🖐",
        codepoint: "1F590",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "hand with fingers splayed",
        group: "People & Body",
        subgroup: "hand-fingers-open",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hand in die lug met vingers oopgesprei"),
            keywords: &[
                "hand",
                "hand in die lug met vingers oopgesprei",
                "liggaam",
                "oopgesprei",
                "vinger",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ለሰላምታ ወደ ላይ የተዘረጉ የእጅ ጣቶች"),
            keywords: &["ለሰላምታ ወደ ላይ የተዘረጉ የእጅ ጣቶች", "መዘርጋት", "አካል", "እጅ", "ጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يد مرفوعة بأصابع متفرقة"),
            keywords: &["إصبع", "تباعد", "جسد", "يد", "يد مرفوعة بأصابع متفرقة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আঙ\u{9c1}লি প\u{9cd}ৰস\u{9be}ৰিত কৰি হ\u{9be}ত মেল\u{9be}"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "আঙ\u{9c1}লি প\u{9cd}ৰস\u{9be}ৰিত কৰি হ\u{9be}ত মেল\u{9be}",
                "প\u{9cd}ৰস\u{9be}ৰিত",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("barmaqları aralı şəkildə qaldırılmış əl"),
            keywords: &[
                "aralı",
                "barmaq",
                "barmaqları aralı şəkildə qaldırılmış əl",
                "orqan",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паднятая рука з растапыранымі пальцамі"),
            keywords: &[
                "паднятая рука з растапыранымі пальцамі",
                "пальцы",
                "растапырванне",
                "рука",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Вдигната ръка с разперени пръсти"),
            keywords: &[
                "Вдигната ръка с разперени пръсти",
                "пръст",
                "разперен",
                "ръка",
                "тяло",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("আঙ\u{9cd}গ\u{9c1}ল প\u{9cd}রস\u{9be}রিত করে হ\u{9be}ত তোল\u{9be}"),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল",
                "আঙ\u{9cd}গ\u{9c1}ল প\u{9cd}রস\u{9be}রিত করে হ\u{9be}ত তোল\u{9be}",
                "প\u{9cd}রস\u{9be}রিত কর\u{9be}",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podignuta šaka s raširenim prstima"),
            keywords: &[
                "podignuta šaka s raširenim prstima",
                "pokazivanje",
                "prsti",
                "rašireno",
                "ruka",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mà oberta"),
            keywords: &["dits", "dits oberts", "mà amb els dits oberts", "mà oberta"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏌᎳᏓ ᎤᏬᏱ ᎢᏧᏓᎵ ᏕᎦᏰᏌᏛ"),
            keywords: &["ᎢᏧᏓᎵ", "ᎤᏌᎳᏓ ᎤᏬᏱ ᎢᏧᏓᎵ ᏕᎦᏰᏌᏛ", "ᎤᏬᏱ", "ᎦᏰᏌᏛ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ruka s roztaženými prsty"),
            keywords: &[
                "prst",
                "roztažené",
                "ruka",
                "ruka s roztaženými prsty",
                "tělo",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llaw wedi ei chodi â bysedd wedi eu lledu"),
            keywords: &[
                "bys",
                "corff",
                "llaw",
                "llaw wedi ei chodi â bysedd wedi eu lledu",
                "wedi lledu",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hånd med spredte fingre"),
            keywords: &[
                "finger",
                "hånd",
                "hånd med spredte fingre",
                "krop",
                "spredte",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Hand mit gespreizten Fingern"),
            keywords: &[
                "5",
                "Finger",
                "Hand",
                "Hand mit gespreizten Fingern",
                "fünf",
                "gespreizt",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μούντζα"),
            keywords: &["ανοιχτά δάχτυλα", "δάχτυλο", "μούντζα", "φάσκελο", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("hand with fingers splayed"),
            keywords: &["finger", "hand", "hand with fingers splayed", "splayed"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano abierta"),
            keywords: &["abierta", "dedo", "mano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["abierta", "dedos", "mano", "palma", "yo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["dedos", "mano", "mano abierta", "palma de la mano"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["dedo", "dedos", "mano", "mano abierta", "separados"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("harali sõrmedega käsi"),
            keywords: &["harali", "harali sõrmedega käsi", "keha", "käsi", "sõrm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku altxatua eta hatz hedatuak"),
            keywords: &[
                "esku altxatua eta hatz hedatuak",
                "eskua",
                "gorputza",
                "hatza",
                "hedatu",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست با انگشتان باز"),
            keywords: &[
                "انگشتان",
                "خداحافظی",
                "دست",
                "دست با انگشتان باز",
                "سلام",
                "پنج",
            ],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nostettu käsi ja sormet erillään"),
            keywords: &[
                "käsi",
                "levitetty",
                "nostettu käsi ja sormet erillään",
                "sormi",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakataas na nakabukas na kamay"),
            keywords: &[
                "daliri",
                "kamay",
                "nakabukas na kamay",
                "nakataas na nakabukas na kamay",
                "palad",
                "tumigil",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fimm fingrar"),
            keywords: &["fimm", "fingrar", "hond"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main levée doigts écartés"),
            keywords: &["main", "main levée doigts écartés"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("main aux doigts écartés"),
            keywords: &["doigts écartés", "main", "main aux doigts écartés"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh le méara spréite"),
            keywords: &[
                "ar leathadh",
                "corp",
                "lámh",
                "lámh le méara spréite",
                "lámha suas lena mhéara ar leathadh",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh air a togail le corragan sìnte"),
            keywords: &[
                "corrag",
                "làmh",
                "làmh air a togail le corragan sìnte",
                "meur",
                "sìnte",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("man aberta"),
            keywords: &["aberta", "man"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac7}લાવ\u{ac7}લી આ\u{a82}ગળી વાળો ઉઠાવ\u{ac7}લો હાથ"),
            keywords: &[
                "આ\u{a82}ગળી",
                "ફ\u{ac7}લાવ\u{ac7}લી આ\u{a82}ગળી વાળો ઉઠાવ\u{ac7}લો હાથ",
                "ફ\u{ac7}લાવ\u{ac7}લ\u{ac1}\u{a82}",
                "શરીર",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗagaggen hannu tare da yatsa a faɗaɗɗe"),
            keywords: &[
                "faɗaɗa hannu",
                "hannu",
                "yatsa",
                "ɗagaggen hannu tare da yatsa a faɗaɗɗe",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כף יד פתוחה מורמת"),
            keywords: &["חמסה", "יד", "כיף", "כף יד פתוחה מורמת", "מורמת", "פתוחה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{948}ली ह\u{941}ई अ\u{901}ग\u{941}लियो\u{902} वाला उठा ह\u{941}आ हाथ"),
            keywords: &[
                "फ\u{948}ली ह\u{941}ई अ\u{901}ग\u{941}लियो\u{902} वाला उठा ह\u{941}आ हाथ",
                "बस",
                "रोकना",
                "हाथ का प\u{902}जा",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("podignuta ruka s raširenim prstima"),
            keywords: &[
                "podignuta ruka s raširenim prstima",
                "prst",
                "rašireno",
                "šaka",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felemelt kéz szétálló ujjakkal"),
            keywords: &[
                "felemelt kéz szétálló ujjakkal",
                "kéz",
                "szétálló",
                "test",
                "ujj",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բացված մատներով բարձրացված ձեռք"),
            keywords: &[
                "բացված",
                "բացված մատներով բարձրացված ձեռք",
                "ձեռք",
                "մատ",
                "մարմին",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telapak tangan terbuka"),
            keywords: &[
                "badan",
                "jari",
                "tangan",
                "telapak tangan terbuka",
                "terbuka",
                "tos",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("welitere aka elu n’iji mgbasa mkpịsịaka"),
            keywords: &[
                "aka",
                "mgbasa mkpịsịaka",
                "mkpịsịaka",
                "welitere aka elu n’iji mgbasa mkpịsịaka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("upprétt hönd með glennta fingur"),
            keywords: &[
                "fingur",
                "glennt",
                "hönd",
                "líkami",
                "upprétt hönd með glennta fingur",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano aperta"),
            keywords: &[
                "cinque dita",
                "mano alzata",
                "mano aperta",
                "palmo della mano",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("開いた手"),
            keywords: &["パー", "手", "開いた手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan sing driji-drijine megar"),
            keywords: &[
                "driji",
                "megar",
                "tangan",
                "tangan sing driji-drijine megar",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აწეული ხელი გაშლილი თითებით"),
            keywords: &[
                "აწეული ხელი გაშლილი თითებით",
                "გაშლილი",
                "თითი",
                "სხეული",
                "ტანი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("саусақтарының арасын ашып, қолды көтеру"),
            keywords: &[
                "дене",
                "жайылған",
                "саусақ",
                "саусақтарының арасын ашып, қолды көтеру",
                "қол",
            ],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("hånd med spredte fingre"),
            keywords: &["hånd", "hånd med spredte fingre", "krop", "spredte"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លើកម\u{17d2}រាមដៃប\u{17d2}រា\u{17c6}"),
            keywords: &[
                "ប\u{17d2}រា\u{17c6}",
                "ម\u{17d2}រាមដៃ",
                "ម\u{17d2}រាមប\u{17d2}រា\u{17c6}",
                "លើកម\u{17d2}រាមដៃប\u{17d2}រា\u{17c6}",
                "\u{200b} បាតដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಚಾಚ\u{cbf}ರುವ ಬ\u{cc6}ರಳುಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಎತ\u{ccd}ತ\u{cbf}ರುವ ಕೈ"),
            keywords: &[
                "ಕೈ ಎತ\u{ccd}ತ\u{cbf}ರುವುದು",
                "ಚಾಚ\u{cbf}ರುವ ಬ\u{cc6}ರಳುಗಳೊಂದ\u{cbf}ಗ\u{cc6} ಎತ\u{ccd}ತ\u{cbf}ರುವ ಕೈ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("쫙 편 손바닥"),
            keywords: &["손바닥", "안녕", "인사", "쫙 편 손바닥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("बोटा\u{902} विस\u{94d}कळीत हात"),
            keywords: &[
                "बोट",
                "बोटा\u{902} विस\u{94d}कळीत बोटा\u{902}",
                "बोटा\u{902} विस\u{94d}कळीत हात",
                "विस\u{94d}कळीत",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("беш манжа"),
            keywords: &["ачык", "бармак", "беш", "дене", "манжа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("gehuewen Hand mat ausgestreckte Fanger"),
            keywords: &[
                "Fanger",
                "Hand",
                "ausgestreckt",
                "gehuewen Hand mat ausgestreckte Fanger",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນໂດຍທ\u{eb5}\u{ec8}ນ\u{eb5}\u{ec9}ວມ\u{eb7}ຈ\u{ec8}າງອອກ",
            ),
            keywords: &[
                "ຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນໂດຍທ\u{eb5}\u{ec8}ນ\u{eb5}\u{ec9}ວມ\u{eb7}ຈ\u{ec8}າງອອກ",
                "ນ\u{eb4}\u{ec9}ວມ\u{eb7}",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("iškelta ranka su išskėstais pirštais"),
            keywords: &[
                "iškelta ranka su išskėstais pirštais",
                "išskėsta",
                "pirštas",
                "ranka",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pacelta roka ar izvērstiem pirkstiem"),
            keywords: &[
                "izvērsts",
                "pacelta roka ar izvērstiem pirkstiem",
                "pirksts",
                "roka",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa tū matimati paraha"),
            keywords: &["matimati", "paraha", "ringa", "ringa tū matimati paraha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("крената рака со раширени прсти"),
            keywords: &[
                "дланка",
                "крената рака со раширени прсти",
                "прст",
                "рака",
                "раширена",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വിടർത\u{d4d}തിയ വിരല\u{d41}കള\u{d41}ള\u{d4d}ള കൈ"),
            keywords: &[
                "കൈ",
                "വിടർത\u{d4d}തിയ",
                "വിടർത\u{d4d}തിയ വിരല\u{d41}കള\u{d41}ള\u{d4d}ള കൈ",
                "വിരൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хуруунуудаа салгасан гарын алга"),
            keywords: &[
                "гар",
                "салгасан",
                "хуруу",
                "хуруунуудаа салгасан гарын алга",
                "хуруунуудыг салгасан гар",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पसरविल\u{947}ल\u{94d}या बोटा\u{902}सह उ\u{902}चावल\u{947}ला हात"),
            keywords: &[
                "पसरविल\u{947}ल\u{947}",
                "पसरविल\u{947}ल\u{94d}या बोटा\u{902}सह उ\u{902}चावल\u{947}ला हात",
                "बोट",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tangan dengan jari terkepak"),
            keywords: &[
                "badan",
                "jari",
                "renggang",
                "tangan",
                "tangan dengan jari terkepak",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id mgħollija bl-iswaba’ mfettħa"),
            keywords: &["id", "id mgħollija bl-iswaba’ mfettħa", "mfettħa", "suba’"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "လက\u{103a}ချောင\u{103a}းများ ဖြန\u{1037}\u{103a}ပြ\u{102e}း မြ\u{103e}ောက\u{103a}ထားသည\u{1037}\u{103a} လက\u{103a}",
            ),
            keywords: &[
                "ဖြန\u{1037}\u{103a}ထားခြင\u{103a}း",
                "လက\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
                "လက\u{103a}ချောင\u{103a}းများ ဖြန\u{1037}\u{103a}ပြ\u{102e}း မြ\u{103e}ောက\u{103a}ထားသည\u{1037}\u{103a} လက\u{103a}",
                "လက\u{103a}ဖြန\u{1037}\u{103a}ပြထားသော လက\u{103a}ဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("flat hånd med spredte fingre"),
            keywords: &["finger", "flat hånd med spredte fingre", "hånd", "spredt"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{948}लाएको औ\u{902}लाहर\u{942}सहित उठाइएका हात"),
            keywords: &[
                "औ\u{902}ला",
                "फ\u{948}लाएको",
                "फ\u{948}लाएको औ\u{902}लाहर\u{942}सहित उठाइएका हात",
                "शरीर",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("opgeheven hand met uitgestoken vingers"),
            keywords: &[
                "gespreid",
                "hand",
                "opgeheven hand met uitgestoken vingers",
                "vinger",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("flat hand med spreidde fingrar"),
            keywords: &[
                "finger",
                "flat hand med spreidde fingerer",
                "flat hand med spreidde fingrar",
                "hand",
                "spreidd",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ ଖୋଲ\u{b3e} କର\u{b3f} ରଖ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
            ),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ ଖୋଲ\u{b3e} କର\u{b3f} ରଖ\u{b3f}ଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ",
                "ଫର\u{b4d}ଚ\u{b3e}ଇବ\u{b3e}",
                "ହ\u{b3e}ତ",
                "ହ\u{b3e}ତ ସହ\u{b3f}ତ ଫର\u{b4d}ଚ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a70}ਜਾ ਵਿਖਾਉਣਾ"),
            keywords: &[
                "ਉ\u{a02}ਗਲ",
                "ਪ\u{a70}ਜਾ ਵਿਖਾਉਣਾ",
                "ਹ\u{a71}ਥ",
                "ਹ\u{a71}ਥ ਵਿਖਾਉਣਾ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("چوڑیاں کیتیاں ا\u{64f}نگلاں نال ا\u{64f}وتے کیتا ہتھ"),
            keywords: &[
                "ا\u{64f}نگل",
                "وسعت د\u{650}تا",
                "چوڑیاں کیتیاں ا\u{64f}نگلاں نال ا\u{64f}وتے کیتا ہتھ",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand Wé Dẹm Sprẹ\u{301}d Di Fínga-dẹm"),
            keywords: &[
                "Fínga",
                "Hand",
                "Hand Wé Dẹm Sprẹ\u{301}d Di Fínga-dẹm",
                "Sprẹd",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("uniesiona otwarta dłoń"),
            keywords: &[
                "otwarta dłoń wszystkie palce",
                "palce",
                "rozpostarte palce",
                "uniesiona otwarta dłoń",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پنجه"),
            keywords: &["لاس", "پنجه", "ګوته"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mão aberta com os dedos separados"),
            keywords: &[
                "cinco dedos",
                "dedos",
                "mão",
                "mão aberta com os dedos separados",
                "mão aberta indicando cinco",
                "palma da mão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão erguida com dedos afastados"),
            keywords: &[
                "corpo",
                "dedo",
                "dedos abertos",
                "mão",
                "mão erguida com dedos afastados",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("maki iskay ruk’anakunawa mast’asqa"),
            keywords: &[
                "maki",
                "maki iskay ruk’anakunawa mastʼasqa",
                "maki iskay ruk’anakunawa mast’asqa",
                "mastʼasqa",
                "rukana",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mână ridicată cu degetele depărtate"),
            keywords: &[
                "deget",
                "deschis",
                "mână",
                "mână ridicată cu degetele depărtate",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-807"),
            keywords: &["E10-807"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("раскрытая ладонь"),
            keywords: &["ладонь", "пальцы", "раскрытая", "рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganza kizamuye intoki zitandukanyije"),
            keywords: &[
                "bitanye",
                "ikiganza",
                "ikiganza kizamuye intoki zitandukanyije",
                "urutoki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي ڪيل هٿ کليل آڱرين سان"),
            keywords: &["آڱر", "مٿي ڪيل هٿ کليل آڱرين سان", "هٿ", "پکڙيل هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ව\u{dd2}දහන ලද ඇඟ\u{dd2}ල\u{dd2} සහ\u{dd2}ත එසව\u{dd6} අත"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "පළල\u{dca} කළ",
                "ව\u{dd2}දහන ලද ඇඟ\u{dd2}ල\u{dd2} සහ\u{dd2}ත එසව\u{dd6} අත",
                "ශර\u{dd3}රය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("roztiahnutá ruka"),
            keywords: &["prst", "roztiahnutá", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvignjena dlan z razprtimi prsti"),
            keywords: &[
                "dlan",
                "dvignjena dlan z razprtimi prsti",
                "prst",
                "razprto",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan iyo faraha ayaa lagu fidiyay"),
            keywords: &["far", "gacan", "gacan iyo faraha ayaa lagu fidiyay"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorë e ngritur me gishtat të hapur"),
            keywords: &[
                "dorë",
                "dorë e ngritur me gishtat të hapur",
                "e hapur",
                "trup",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("шака са раширеним прстима"),
            keywords: &[
                "прст",
                "рaширeнo",
                "рукa",
                "тело",
                "шaкa",
                "шака са раширеним прстима",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["шака са раширеним прстима"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("šaka sa raširenim prstima"),
            keywords: &[
                "prst",
                "rašireno",
                "ruka",
                "telo",
                "šaka",
                "šaka sa raširenim prstima",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["šaka sa raširenim prstima"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hand med utspretade fingrar"),
            keywords: &["finger", "hand", "hand med utspretade fingrar"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono ulioinuliwa wenye vidole vilivyotanuliwa"),
            keywords: &[
                "kidole",
                "mkono",
                "mkono ulioinuliwa wenye vidole vilivyotanuliwa",
                "tanuliwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "ஐந\u{bcd}து விரல\u{bcd}களும\u{bcd} ந\u{bc0}ட\u{bcd}டப\u{bcd}பட\u{bcd}ட நிலையில\u{bcd} உயர\u{bcd}த\u{bcd}திய கை",
            ),
            keywords: &[
                "ஐந\u{bcd}து விரல\u{bcd}களும\u{bcd} ந\u{bc0}ட\u{bcd}டப\u{bcd}பட\u{bcd}ட நிலையில\u{bcd} உயர\u{bcd}த\u{bcd}திய கை",
                "ஐந\u{bcd}து விரல\u{bcd}கள\u{bcd}",
                "சைகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "వ\u{c47}ళ\u{c4d}లు త\u{c46}ర\u{c3f}చ\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న చ\u{c47}య\u{c3f}",
            ),
            keywords: &[
                "చ\u{c47}య\u{c3f}",
                "వ\u{c47}ళ\u{c4d}లు",
                "వ\u{c47}ళ\u{c4d}లు త\u{c46}ర\u{c3f}చ\u{c3f} ప\u{c48}క\u{c3f} ఎత\u{c4d}త\u{c3f}న చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дасти бардошта бо ангуштони паҳнкарда"),
            keywords: &[
                "ангушт",
                "даст",
                "дасти бардошта бо ангуштони паҳнкарда",
                "паҳнкарда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39}ม\u{e37}อกางน\u{e34}\u{e49}ว"),
            keywords: &[
                "ช\u{e39}ม\u{e37}อกางน\u{e34}\u{e49}ว",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("barmaklaryň arasy açylan el"),
            keywords: &[
                "arasy açylan",
                "barmak",
                "barmaklaryň arasy açylan el",
                "el",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima fālalahi"),
            keywords: &["nima fālalahi"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("parmaklar açık el kaldırma"),
            keywords: &[
                "avuç",
                "beden",
                "el",
                "parmak",
                "parmaklar açık el kaldırma",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بارماقلىرىنى يېيىپ كۆتۈرگەن قول"),
            keywords: &["بارماق", "بارماقلىرىنى يېيىپ كۆتۈرگەن قول", "قول", "يايغان"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піднята рука з розведеними пальцями"),
            keywords: &[
                "палець",
                "піднята рука з розведеними пальцями",
                "розчепірений",
                "рука",
                "тіло",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پھیلی ہوئی انگلیوں کے ساتھ بلند ہاتھ"),
            keywords: &[
                "انگلی",
                "جسم",
                "پھیلانا",
                "پھیلی ہوئی انگلیوں کے ساتھ بلند ہاتھ",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("barmoqlari yoyilgan qoʻl"),
            keywords: &[
                "barmoq",
                "barmoqlari yoyilgan holatda ko‘tarilgan qo‘l",
                "barmoqlari yoyilgan qoʻl",
                "qo‘l",
                "tana",
                "yoyilgan",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tay xòe ngón giơ lên"),
            keywords: &["ngón tay", "tay", "tay xòe ngón giơ lên", "xòe"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("buñ yëkkati loxo ak baaraam yuñ tàllal"),
            keywords: &[
                "baaraam",
                "buñ yëkkati loxo ak baaraam yuñ tàllal",
                "loxo",
                "tàllal",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandla esiphakanyisiweyo esineminwe ethe saa"),
            keywords: &[
                "isandla",
                "isandla esiphakanyisiweyo esineminwe ethe saa",
                "saa",
                "umnwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("nawọ\u{301} sókè pẹ\u{300}lú ìyàka"),
            keywords: &[
                "nawọ\u{301} sókè pẹ\u{300}lú ìyàka",
                "yàka",
                "ìka",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手指張開"),
            keywords: &["張開", "手", "手指", "手指張開"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手指张开"),
            keywords: &["张开", "手", "手指", "手指张开"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("手掌"),
            keywords: &["击掌", "布", "手", "手掌", "禁止"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("停止"),
            keywords: &["停止", "對外張開五指"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla esiphakanyisiwe esivuliwe"),
            keywords: &[
                "esivuliwe",
                "isandla",
                "isandla esiphakanyisiwe esivuliwe",
                "umunwe",
                "umzimba",
            ],
        },
    ],
};
#[doc = "🖐🏻"]
pub const HAND_WITH_FINGERS_SPLAYED_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖐🏻",
    codepoint: "1F590 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hand with fingers splayed: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖐🏼"]
pub const HAND_WITH_FINGERS_SPLAYED_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖐🏼",
    codepoint: "1F590 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hand with fingers splayed: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖐🏽"]
pub const HAND_WITH_FINGERS_SPLAYED_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖐🏽",
    codepoint: "1F590 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hand with fingers splayed: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖐🏾"]
pub const HAND_WITH_FINGERS_SPLAYED_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖐🏾",
    codepoint: "1F590 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hand with fingers splayed: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖐🏿"]
pub const HAND_WITH_FINGERS_SPLAYED_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖐🏿",
    codepoint: "1F590 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "hand with fingers splayed: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✋"]
pub const RAISED_HAND: crate::Emoji = crate::Emoji {
    glyph: "✋",
    codepoint: "270B",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "raised hand",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("hand in die lug"),
            keywords: &["hand", "hand in die lug", "liggaam"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ የተደረገ እጅ"),
            keywords: &["አካል", "እጅ", "ወደ ላይ የተደረገ እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("يد مرفوعة"),
            keywords: &["جسد", "قبضة", "يد", "يد مرفوعة"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("অন\u{9c1}গ\u{9cd}ৰহ কৰি ৰখক"),
            keywords: &["অন\u{9c1}গ\u{9cd}ৰহ কৰি ৰখক", "হ\u{9be}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaldırımış əl"),
            keywords: &["orqan", "qaldırımış əl", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("паднятая рука"),
            keywords: &["паднятая рука", "рука", "стоп", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Вдигната ръка"),
            keywords: &["Вдигната ръка", "ръка", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("অন\u{9c1}গ\u{9cd}রহ করে থ\u{9be}ম\u{9c1}ন"),
            keywords: &[
                "অন\u{9c1}গ\u{9cd}রহ করে থ\u{9be}ম\u{9c1}ন",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podignuta šaka"),
            keywords: &["podignuta šaka", "pokazivanje", "prsti", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("mà aixecada"),
            keywords: &["cos", "mà", "mà aixecada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎣᏬᏰᎾ ᎠᏌᎵᏛᏅᎢ"),
            keywords: &["ᎣᏬᏰᎾ ᎠᏌᎵᏛᏅᎢ", "ᎤᏬᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvednutá ruka"),
            keywords: &["ruka", "tělo", "zvednutá ruka"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llaw wedi codi"),
            keywords: &["corff", "llaw", "llaw wedi codi"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løftet hånd"),
            keywords: &["hånd", "krop", "løftet hånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("erhobene Hand"),
            keywords: &["Hand", "erhobene Hand"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σηκωμένο χέρι"),
            keywords: &["σηκωμένο χέρι", "σώμα", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("raised hand"),
            keywords: &["hand", "high 5", "high five", "raised hand"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("mano levantada"),
            keywords: &["levantada", "mano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["abierta", "mano", "mano levantada", "palma", "papel"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["mano", "mano abierta", "mano levantada", "palma de la mano"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["mano", "mano levantada"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ülestõstetud käsi"),
            keywords: &["keha", "käsi", "ülestõstetud käsi"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("esku altxatua"),
            keywords: &["esku altxatua", "eskua"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دست بالابرده"),
            keywords: &["احترام", "دست", "دست بالابرده", "سلام"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nostettu käsi"),
            keywords: &["käsi", "nostettu käsi", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakataas na kamay"),
            keywords: &["kamay", "nakataas na kamay", "palad"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hond"),
            keywords: &["hond", "lógvi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("main levée"),
            keywords: &["feuille", "main", "main levée"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["levée", "main"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh ardaithe"),
            keywords: &["lámh ardaithe", "páipéar"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("làmh air a togail"),
            keywords: &["làmh", "làmh air a togail"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("man levantada"),
            keywords: &["levantada", "man"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉઠાવ\u{ac7}લો હાથ"),
            keywords: &["ઉઠાવ\u{ac7}લો હાથ", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗagaggen hannu"),
            keywords: &["hannu", "ɗagaggen hannu"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כף יד מורמת"),
            keywords: &["יד", "כף יד מורמת", "מורמת", "עצור"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उठा ह\u{941}आ हाथ"),
            keywords: &["उठा ह\u{941}आ हाथ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("podignuta ruka"),
            keywords: &["podignuta ruka", "ruka", "tijelo", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felemelt kéz"),
            keywords: &["fel", "felemelt kéz", "kéz", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրացված ձեռք"),
            keywords: &["բարձրացված ձեռք", "ձեռք", "մարմին"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telapak tangan terbuka dengan jari rapat"),
            keywords: &[
                "badan",
                "rapat",
                "tangan",
                "telapak tangan terbuka dengan jari rapat",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ewèliri"),
            keywords: &["aka", "aka ewèliri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lófi"),
            keywords: &["lófi", "upprétt hönd"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("mano alzata"),
            keywords: &["alzata", "carta", "mano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("挙手"),
            keywords: &["パー", "手", "挙手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tangan diangkat"),
            keywords: &["angkat", "tangan", "tangan diangkat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აწეული ხელი"),
            keywords: &["აწეული ხელი", "სხეული", "ტანი", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("қол көтеру"),
            keywords: &["дене", "қол", "қол көтеру"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("løftet hånd"),
            keywords: &["hånd", "krop", "løftet hånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លើកដៃ"),
            keywords: &["បាតដៃ", "លើកដៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎತ\u{ccd}ತ\u{cbf}ರುವ ಕೈ"),
            keywords: &["ಎತ\u{ccd}ತ\u{cbf}ದ ಕೈ", "ಎತ\u{ccd}ತ\u{cbf}ರುವ ಕೈ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("손바닥"),
            keywords: &["보", "보자기", "손바닥"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उखलिल\u{94d}लो हात"),
            keywords: &["उखलिल\u{94d}लो हात", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кол көтөрүү"),
            keywords: &["дене", "кол", "кол көтөрүү"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("héichgehalen Hand"),
            keywords: &["Hand", "héichgehalen Hand"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ຍ\u{ebb}ກມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("iškelta ranka"),
            keywords: &["iškelta ranka", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pacelta roka"),
            keywords: &["pacelta roka", "roka", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ringa tū"),
            keywords: &["ringa", "ringa tū"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("крената рака"),
            keywords: &["дланка", "крената рака", "рака", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉയർത\u{d4d}തിയ കൈ"),
            keywords: &["ഉയർത\u{d4d}തിയ കൈ", "കൈ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("өргөсөн гар"),
            keywords: &["гар", "өргөсөн гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उ\u{902}चावल\u{947}ला हात"),
            keywords: &["उ\u{902}चावल\u{947}ला हात", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("angkat tangan"),
            keywords: &["angkat tangan", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("id mgħollija"),
            keywords: &["id", "id mgħollija"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြ\u{103e}ောက\u{103a}ပြထားသည\u{1037}\u{103a} လက\u{103a}"),
            keywords: &[
                "မြ\u{103e}ောက\u{103a}ပြထားသည\u{1037}\u{103a} လက\u{103a}",
                "လက\u{103a}",
                "လက\u{103a}ဖြန\u{1037}\u{103a}ပြနေပ\u{102f}\u{1036}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hevet hånd"),
            keywords: &["flat hånd", "hevet hånd", "håndflate"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उठाइएको हात"),
            keywords: &["उठाइएको हात", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("opgeheven hand"),
            keywords: &["hand", "opgeheven hand"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("heva hand"),
            keywords: &["flat hand", "handflate", "heva hand"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଠ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ"),
            keywords: &["ଉଠ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ହ\u{b3e}ତ", "ହ\u{b3e}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a41}\u{a71}ਕਿਆ ਹ\u{a4b}ਇਆ ਹ\u{a71}ਥ"),
            keywords: &[
                "ਉ\u{a71}ਠਿਆ ਹ\u{a71}ਥ",
                "ਕਾਗਜ\u{a3c}",
                "ਚ\u{a41}\u{a71}ਕਿਆ ਹ\u{a4b}ਇਆ ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ا\u{64f}وتے کیتا ہتھ"),
            keywords: &["ا\u{64f}وتے کیتا ہتھ", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hand Wé Dẹm Réz Ọp"),
            keywords: &["Hand", "Hand Wé Dẹm Réz Ọp"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wzniesiona dłoń"),
            keywords: &["dłoń", "stop", "uwaga", "wzniesiona dłoń"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("اوچت لاس"),
            keywords: &["اوچت لاس", "لاس"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("mão levantada"),
            keywords: &["mão erguida", "mão levantada"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("mão erguida"),
            keywords: &["corpo", "mão", "mão erguida"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("huqharisqa maki"),
            keywords: &["huqharisqa maki", "maki"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("mână ridicată"),
            keywords: &["mână", "mână ridicată", "sus"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-126"),
            keywords: &["E10-126"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("поднятая ладонь"),
            keywords: &["вверх", "пальцы", "поднятая ладонь", "рука"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ikiganza kizamuye"),
            keywords: &["Ikiganza", "ikiganza kizamuye"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي ڪيل هٿ"),
            keywords: &["مٿي ڪيل هٿ", "هٿ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එසව\u{dd6}\u{dd6} අත"),
            keywords: &["අත", "එසව\u{dd6}\u{dd6} අත", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdvihnutá ruka"),
            keywords: &["ruka", "stop", "stáť", "zdvihnutá ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvignjena dlan"),
            keywords: &["dlan", "dvignjena dlan", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan kor loo qaday"),
            keywords: &["gacan", "gacan kor loo qaaday", "gacan kor loo qaday"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dorë e ngritur"),
            keywords: &["dorë", "dorë e ngritur", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("подигнута рука"),
            keywords: &["подигнута рука", "рукa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["подигнута рука"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("podignuta ruka"),
            keywords: &["podignuta ruka", "ruka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["podignuta ruka"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hand i luften"),
            keywords: &["hand", "hand i luften", "handflata", "uppräckt"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono ulioinuliwa"),
            keywords: &["mkono", "mkono ulioinuliwa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கையை உயர\u{bcd}த\u{bcd}தி க\u{bbe}ட\u{bcd}டுதல\u{bcd}"),
            keywords: &[
                "அடைய\u{bbe}ளம\u{bcd}",
                "கைகளைக\u{bcd} க\u{bbe}ட\u{bcd}டுதல\u{bcd}",
                "கையை உயர\u{bcd}த\u{bcd}தி க\u{bbe}ட\u{bcd}டுதல\u{bcd}",
                "சைகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎత\u{c4d}త\u{c3f}న చ\u{c47}య\u{c3f}"),
            keywords: &[
                "అభయ హస\u{c4d}తం",
                "అరచ\u{c47}య\u{c3f}",
                "ఆగుము చ\u{c3f}హ\u{c4d}నం",
                "ఎత\u{c4d}త\u{c3f}న చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("дасти бардошта"),
            keywords: &["даст", "дасти бардошта"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ต\u{e31}\u{e49}งฝ\u{e48}าม\u{e37}อ"),
            keywords: &[
                "ต\u{e31}\u{e49}งฝ\u{e48}าม\u{e37}อ",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("galdyrylan el"),
            keywords: &["el", "galdyrylan el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima hiki ki ʻolunga"),
            keywords: &["nima hiki ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("el kaldırma"),
            keywords: &["el kaldırma", "havada el"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆتۈرگەن قول"),
            keywords: &["قول", "كۆتۈرگەن قول"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піднята рука"),
            keywords: &["піднята рука", "рука", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلند ہاتھ"),
            keywords: &["بلند ہاتھ", "جسم", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘tarilgan qo‘l"),
            keywords: &["ko‘tarilgan qo‘l", "qo‘l", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn tay giơ lên"),
            keywords: &["bàn tay giơ lên", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo bu jog"),
            keywords: &["loxo", "loxo bu jog"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("isandla esinyusiweyo"),
            keywords: &["isandla", "isandla esinyusiweyo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ọwọ Nina Soke"),
            keywords: &["Ọwọ Nina Soke", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舉手"),
            keywords: &["手", "舉手"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("举手"),
            keywords: &["举手", "手"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("举起手"),
            keywords: &["举手", "举起手", "手"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("舉手"),
            keywords: &["招手", "舉手"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla esiphanyisiwe"),
            keywords: &["isandla", "isandla esiphanyisiwe", "umzimba"],
        },
    ],
};
#[doc = "✋🏻"]
pub const RAISED_HAND_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✋🏻",
    codepoint: "270B 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised hand: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✋🏼"]
pub const RAISED_HAND_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✋🏼",
    codepoint: "270B 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised hand: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✋🏽"]
pub const RAISED_HAND_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✋🏽",
    codepoint: "270B 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised hand: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✋🏾"]
pub const RAISED_HAND_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✋🏾",
    codepoint: "270B 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised hand: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✋🏿"]
pub const RAISED_HAND_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✋🏿",
    codepoint: "270B 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised hand: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖖"]
pub const VULCAN_SALUTE: crate::Emoji = crate::Emoji {
    glyph: "🖖",
    codepoint: "1F596",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "vulcan salute",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vulkansaluut"),
            keywords: &["hand", "liggaam", "vinger", "vulkan", "vulkansaluut"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ቩልካን ሰላምታ"),
            keywords: &["ቩልካን", "ቩልካን ሰላምታ", "አካል", "እጅ", "ጣት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("تحية فولكان"),
            keywords: &["إصبع", "تحية فولكان", "جسد", "سبوك", "فولكان", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভল\u{9cd}ক\u{9be}ন ছেল\u{9c1}ট"),
            keywords: &[
                "আঙ\u{9c1}লি",
                "ভল\u{9cd}ক\u{9be}ন",
                "ভল\u{9cd}ক\u{9be}ন ছেল\u{9c1}ট",
                "স\u{9cd}প’ক",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("vulkan salamı"),
            keywords: &["barmaq", "orqan", "spok", "vulkan", "vulkan salamı", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вулканскі салют"),
            keywords: &["вулканскі салют", "жэст", "спок", "стартрэк"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Поздрав на вулканите"),
            keywords: &["Поздрав на вулканите", "вулкан", "пръст", "ръка", "спок"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9cd}য\u{9be}লক\u{9be}ন স\u{9cd}য\u{9be}ল\u{9c1}ট"),
            keywords: &[
                "আক\u{9be}র ইঙ\u{9cd}গিত",
                "আঙ\u{9cd}গ\u{9c1}ল",
                "ভ\u{9be}লক\u{9be}ন",
                "ভ\u{9cd}য\u{9be}লক\u{9be}ন স\u{9cd}য\u{9be}ল\u{9c1}ট",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("vulkanski pozdrav"),
            keywords: &["pozdrav", "ruka", "spock", "vulkanac", "vulkanski pozdrav"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("salutació vulcaniana"),
            keywords: &["Spock", "dit", "mà", "salutació vulcaniana", "vulcanià"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎪᏍᏓᏱᏗᎦᎵᏟᎩ ᎠᏓᏲᎵᏍᏗ"),
            keywords: &[
                "ᎤᏬᏱ",
                "ᎦᏰᏌᏛ",
                "ᏗᎪᏍᏓᏱᏗᎦᎵᏟᎩ",
                "ᏗᎪᏍᏓᏱᏗᎦᎵᏟᎩ ᎠᏓᏲᎵᏍᏗ",
                "ᏧᎵᏍᏆᎾᎵᏚᎦᏖᏌᎾᎸ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("vulkánský pozdrav"),
            keywords: &[
                "prst",
                "ruka",
                "spock",
                "tělo",
                "vulkán",
                "vulkánský pozdrav",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("saliwt fulcanaidd"),
            keywords: &["bys", "corff", "llaw", "saliwt fulcanaidd", "spock"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("vulcan-hilsen"),
            keywords: &["finger", "hånd", "krop", "spock", "vulcan", "vulcan-hilsen"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("vulkanischer Gruß"),
            keywords: &[
                "Spock",
                "Star Trek",
                "lebe lang und in Frieden",
                "spreizen",
                "vulkanisch",
                "vulkanischer Gruß",
            ],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Vulkanischer Gruss"),
            keywords: &[
                "Finger",
                "Hand",
                "Spock",
                "Vulkanier(in)",
                "Vulkanischer Gruss",
                "vulkanisch",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("χαιρετισμός σποκ"),
            keywords: &[
                "vulcan",
                "δάχτυλο",
                "σποκ",
                "σώμα",
                "χέρι",
                "χαιρετισμός σποκ",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("vulcan salute"),
            keywords: &["finger", "hand", "spock", "vulcan", "vulcan salute"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("Vulcan salute"),
            keywords: &["Vulcan salute", "finger", "hand", "spock", "vulcan"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("saludo vulcano"),
            keywords: &["mano", "saludo", "spock", "vulcano"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &[
                "dedos", "mano", "saludo", "spock", "star", "trek", "vulcano",
            ],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["saludo", "spock", "star", "trek", "vulcano"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vulcanite tervitus"),
            keywords: &[
                "keha",
                "käsi",
                "spock",
                "sõrm",
                "vulcan",
                "vulcanite tervitus",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("vulcandar agur"),
            keywords: &[
                "agur vulcandarra",
                "eskua",
                "hatza",
                "spock",
                "vulcandar agur",
                "vulcandar agurra",
                "vulcandarra",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سلام ولکان"),
            keywords: &["اسپاک", "انگشت", "دست", "سلام", "ولکان", "پیشتازان فضا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("vulkanilaisten tervehdys"),
            keywords: &[
                "käsi",
                "sormi",
                "spock",
                "vartalo",
                "vulkanilainen",
                "vulkanilaisten tervehdys",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("vulcan salute"),
            keywords: &["daliri", "kamay", "spock", "star trek", "vulcan salute"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("vulkan heilsan"),
            keywords: &["heilsan", "spock", "vulcan", "vulkan"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("salut vulcain"),
            keywords: &["main", "salut vulcain", "vulcain"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["main", "salut", "spock", "vulcain"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cuirtéis Bholcáin"),
            keywords: &["cuirtéis Bholcáin", "lámh", "méar", "spock"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beannachd muinntir Vulcan"),
            keywords: &[
                "beannachd muinntir Vulcan",
                "corrag",
                "làmh",
                "meur",
                "spock",
                "vulcan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("saúdo vulcaniano"),
            keywords: &["Spock", "Star Trek", "man", "saúdo", "saúdo vulcaniano"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("સ\u{ac7}લ\u{acd}ય\u{ac1}ટની એક રીત"),
            keywords: &[
                "આ\u{a82}ગળી",
                "વલ\u{acd}કન",
                "શરીર",
                "સ\u{ac7}લ\u{acd}ય\u{ac1}ટની એક રીત",
                "સ\u{acd}પોઅક",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("gaisuwar vulcan"),
            keywords: &["gaisuwar vulcan", "hannu", "spock", "vulcan", "yatsa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("הצדעה וולקנית"),
            keywords: &[
                "אצבעות",
                "ברכת וולקנים",
                "ברכת כהנים",
                "הצדעה וולקנית",
                "וולקן",
                "וולקנים",
                "יד",
                "ספוק",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("स\u{947}ल\u{94d}य\u{942}ट का एक तरीका"),
            keywords: &[
                "रोमन अग\u{94d}निद\u{947}वता",
                "वल\u{94d}कन स\u{947}ल\u{94d}य\u{942}ट",
                "विश\u{94d}वकर\u{94d}मा",
                "स\u{947}ल\u{94d}य\u{942}ट का एक तरीका",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("vulkanski pozdrav"),
            keywords: &["prst", "spock", "vulkan", "vulkanski pozdrav", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("star trek-üdvözlet"),
            keywords: &[
                "kéz",
                "spock",
                "star trek",
                "star trek-üdvözlet",
                "test",
                "ujj",
                "vulcan",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("վուլկանցիների ողջույն"),
            keywords: &["ձեռք", "մատ", "մարմին", "վուլկան", "վուլկանցիների ողջույն"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("salam vulcan"),
            keywords: &[
                "badan",
                "jari",
                "salam vulcan",
                "spock",
                "tangan",
                "tubuh",
                "vulcan",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ajọọ èkèle"),
            keywords: &["ajọọ èkèle", "aka", "mgbasa mkpịsịaka", "mkpịsịaka"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vulcan-kveðja"),
            keywords: &[
                "fingur",
                "hendi",
                "kveðja",
                "spock",
                "vulcan-kveðja",
                "vúlkan",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("saluto vulcaniano"),
            keywords: &["Spock", "Star Trek", "saluto", "saluto vulcaniano"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("バルカンの挨拶"),
            keywords: &["スポック", "バルカンの挨拶", "バルカン人", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ngurmat cara bangsa vulcan"),
            keywords: &[
                "driji",
                "ngurmat cara bangsa vulcan",
                "spock",
                "tangan",
                "vulcan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ვულკანელების მისალმება"),
            keywords: &[
                "ვულკანელების მისალმება",
                "თითი",
                "მისალმება",
                "სხეული",
                "ტანი",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("вулканша сәлемдесу"),
            keywords: &["вулкан", "вулканша сәлемдесу", "саусақ", "спок", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("vulcan-hilsen"),
            keywords: &["finger", "hånd", "krop", "vulcan-hilsen"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ផ\u{17d2}គ\u{17bb}\u{17c6}ម\u{17d2}រាមដៃជាព\u{17b8}រគ\u{17bc}"),
            keywords: &[
                "ផ\u{17d2}គ\u{17bb}\u{17c6}ម\u{17d2}រាមដៃជាព\u{17b8}រគ\u{17bc}",
                "ម\u{17d2}រាមផ\u{17d2}គ\u{17bb}\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ವಲ\u{ccd}ಕೇನ\u{ccd} ಸಲ\u{ccd}ಯ\u{cc2}ಟ\u{ccd}"),
            keywords: &[
                "ವಲ\u{ccd}ಕೇನ\u{ccd} ಸಲ\u{ccd}ಕ\u{cc2}ಟ\u{ccd}",
                "ವಲ\u{ccd}ಕೇನ\u{ccd} ಸಲ\u{ccd}ಯ\u{cc2}ಟ\u{ccd}",
                "ಸಲ\u{ccd}ಯ\u{cc2}ಟ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("벌칸식 인사"),
            keywords: &["경례", "벌칸식 인사", "손 모양"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("व\u{941}लकन स\u{945}ल\u{94d}य\u{941}ट"),
            keywords: &[
                "बोट",
                "व\u{941}लकन",
                "व\u{941}लकन स\u{945}ल\u{94d}य\u{941}ट",
                "स\u{94d}पॉक",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("вулкандыктарча салам"),
            keywords: &["вулкан", "вулкандыктарча салам", "дене", "кол", "манжа"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Vulcan-Grouss"),
            keywords: &["Fanger", "Hand", "Spock", "Vulcan", "Vulcan-Grouss"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb9}ນ\u{eb4}\u{ec9}ວແບບວ\u{eb1}ນແຄນ"),
            keywords: &[
                "ຊ\u{eb9}ນ\u{eb4}\u{ec9}ວແບບວ\u{eb1}ນແຄນ",
                "ນ\u{eb4}\u{ec9}ວມ\u{eb7}",
                "ວ\u{eb1}ນແຄນ",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("vulkanų rasės pasisveikinimo ženklas"),
            keywords: &[
                "kūnas",
                "pirštas",
                "ranka",
                "vulkanai",
                "vulkanų rasės pasisveikinimo ženklas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("vulkāniešu sveiciens"),
            keywords: &[
                "Spoks",
                "Vulkāns",
                "pirksts",
                "roka",
                "vulkāniešu sveiciens",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("whakakōtua vulcan"),
            keywords: &["matimati", "ringa", "spock", "vulcan", "whakakōtua vulcan"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("вулкански поздрав"),
            keywords: &["вулканец", "вулкански поздрав", "дланка", "поздрав", "прст"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വൾക\u{d4d}കൻ സല\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}"),
            keywords: &[
                "കൈ",
                "വിരൽ",
                "വൾക\u{d4d}കൻ",
                "വൾക\u{d4d}കൻ സല\u{d4d}യ\u{d42}ട\u{d4d}ട\u{d4d}",
                "സ\u{d4d}\u{200c}പോക\u{d4d}ക\u{d4d}",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("вулкан мэндчилгээ"),
            keywords: &["вулкан", "гар", "дохио зангаа", "мэндчилгээ"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दीर\u{94d}घाय\u{941}ष\u{94d}याचा आशीर\u{94d}वाद द\u{947}णारा हात"),
            keywords: &[
                "औक\u{94d}षव\u{902}त व\u{94d}हा",
                "दीर\u{94d}घाय\u{941}ष\u{94d}याचा आशीर\u{94d}वाद द\u{947}णारा हात",
                "बोट",
                "स\u{94d}पॉक",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tabik vulcan"),
            keywords: &["badan", "jari", "spock", "tabik vulcan", "tangan", "valkan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("salut ta’ vulcan"),
            keywords: &["id", "salut ta’ vulcan", "spock", "suba’", "vulcan"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဗ\u{1030}လ\u{103a}ကန\u{103a} ဆလ\u{102f}"),
            keywords: &[
                "ဗ\u{1030}လ\u{103a}ကန\u{103a} ဆလ\u{102f}",
                "ဗော\u{103a}လ\u{103a}ကန\u{103a} ဂ\u{102f}ဏ\u{103a}ပြ\u{102f}လက\u{103a}ဟန\u{103a}",
                "လက\u{103a}",
                "လက\u{103a}ချောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("Vulcan-hilsen"),
            keywords: &["Vulcan-hilsen", "finger", "hånd", "spock", "vulcan"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बल\u{94d}कन सलामी"),
            keywords: &["औ\u{902}ला", "बल\u{94d}कन", "शरीर", "सलामी", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("Vulcaanse groet"),
            keywords: &["Vulcaanse groet", "hand", "spock", "vinger", "vulcan"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("Vulcan-helsing"),
            keywords: &["Vulcan-helsing", "finger", "hand", "spock", "vulcan"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଭଲକ\u{b3e}ନ\u{b4d}\u{200c} ସ\u{b3e}ଲ\u{b4d}ୟ\u{b41}ଟ\u{b4d}\u{200c}"),
            keywords: &[
                "ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ଭଲକ\u{b3e}ନ\u{b4d}\u{200c}",
                "ଭଲକ\u{b3e}ନ\u{b4d}\u{200c} ସ\u{b3e}ଲ\u{b4d}ୟ\u{b41}ଟ\u{b4d}\u{200c}",
                "ସ\u{b4d}ପକ\u{b4d}\u{200c}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸਲ\u{a42}ਟ ਕਰਨ ਵਾਲਾ ਹ\u{a71}ਥ, ਵਲਕਨ ਸਲ\u{a42}ਟ"),
            keywords: &[
                "ਉ\u{a02}ਗਲ",
                "ਵਲਕਨ ਸਲ\u{a42}ਟ",
                "ਸਲ\u{a42}ਟ ਕਰਨ ਦਾ ਇ\u{a71}ਕ ਢ\u{a70}ਗ",
                "ਸਲ\u{a42}ਟ ਕਰਨ ਵਾਲਾ ਹ\u{a71}ਥ, ਵਲਕਨ ਸਲ\u{a42}ਟ",
                "ਸ\u{a70}ਕ\u{a47}ਤ ਢ\u{a70}ਗ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("قلزات دے دیوتا نوں سلامی دینا"),
            keywords: &[
                "افسانوی کردار",
                "ا\u{64f}نگل",
                "قلزات دا دیوتا",
                "قلزات دے دیوتا نوں سلامی دینا",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Vọ\u{301}lkán Salut"),
            keywords: &[
                "Fínga",
                "Hand",
                "Salut",
                "Spọk",
                "Vọ\u{301}lkan",
                "Vọ\u{301}lkán Salut",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("salut wolkański"),
            keywords: &["dłoń", "palce", "salut wolkański", "wolkański"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښه راغلاست"),
            keywords: &["لاس", "ټوپ", "ښه", "ښه راغلاست", "ګوتي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("saudação vulcana"),
            keywords: &[
                "dedos",
                "jornada nas estrelas",
                "mão",
                "saudação",
                "saudação vulcana",
                "spock",
                "star trek",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("saudação vulcana"),
            keywords: &[
                "corpo",
                "dedo",
                "mão",
                "saudação vulcana",
                "spock",
                "vulcano",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("vulcano napay"),
            keywords: &["maki", "rukana", "spock", "vulcano", "vulcano napay"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("salut vulcanian"),
            keywords: &["deget", "salut", "salut vulcanian", "spock", "vulcan"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-809"),
            keywords: &["E10-809"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("вулканский салют"),
            keywords: &[
                "вулканский салют",
                "жест",
                "нимой",
                "приветствие",
                "рука",
                "спок",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("indamukanyo ya vulcan"),
            keywords: &[
                "gutandukanya intoki enye",
                "ikiganza",
                "ikigirwamana cy’umuriro",
                "indamukanyo ya vulcan",
                "urutoki",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ولڪن سلام"),
            keywords: &["آڱر", "اسپوڪ", "هٿ", "ولڪن", "ولڪن سلام"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("වල\u{dca}කන\u{dca} සැල\u{dd2}ය\u{dd4}ට\u{dca}"),
            keywords: &[
                "අත",
                "ඇඟ\u{dd2}ල\u{dca}ල",
                "වල\u{dca}කන\u{dca}",
                "වල\u{dca}කන\u{dca} සැල\u{dd2}ය\u{dd4}ට\u{dca}",
                "ස\u{dca}පොක\u{dca}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("vulkánsky pozdrav"),
            keywords: &["prst", "ruka", "spock", "vulkán", "vulkánsky pozdrav"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("vulkanski pozdrav"),
            keywords: &[
                "dlan",
                "prst",
                "spock",
                "telo",
                "vulkan",
                "vulkanski pozdrav",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("salaan sharaf"),
            keywords: &[
                "fara salaan",
                "gacan",
                "isku-dhaf",
                "salaan sharaf",
                "sharaf",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("përshëndetja e vulkanit"),
            keywords: &["dorë", "përshëndetja e vulkanit", "spock", "vulkan"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("вулкански поздрав"),
            keywords: &["вулкaн", "вулкански поздрав", "прст", "рукa", "спок"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["вулкански поздрав"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("vulkanski pozdrav"),
            keywords: &["prst", "ruka", "spok", "vulkan", "vulkanski pozdrav"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["vulkanski pozdrav"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vulcan-hälsning"),
            keywords: &["Star Trek", "hand", "spock", "vulcan", "vulcan-hälsning"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ishara ya vulkani"),
            keywords: &[
                "ishara ya vulkani",
                "kidole",
                "mkono",
                "mwili",
                "spoku",
                "vulkani",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("உல\u{bcd}கேன\u{bcd} சல\u{bcd}யூட\u{bcd}"),
            keywords: &[
                "உல\u{bcd}கேன\u{bcd} சல\u{bcd}யூட\u{bcd}",
                "சல\u{bcd}யூட\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "ఆయుర\u{c3e}ర\u{c4b}గ\u{c4d}య ఐశ\u{c4d}వర\u{c4d}య ప\u{c4d}ర\u{c3e}ప\u{c4d}త\u{c3f}రస\u{c4d}తు",
            ),
            keywords: &[
                "ఆయుర\u{c3e}ర\u{c4b}గ\u{c4d}య ఐశ\u{c4d}వర\u{c4d}య ప\u{c4d}ర\u{c3e}ప\u{c4d}త\u{c3f}రస\u{c4d}తు",
                "ఆయువు",
                "ఆర\u{c4b}గ\u{c4d}యం",
                "ఐశ\u{c4d}వర\u{c4d}యం ప\u{c4a}ంద\u{c3e}లన\u{c47} ఆక\u{c3e}ంక\u{c4d}ష సంక\u{c47}తం",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("саломдиҳии вулқонӣ"),
            keywords: &[
                "аланга",
                "ангушт",
                "даст",
                "ишораи спок",
                "саломдиҳии вулқонӣ",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39}น\u{e34}\u{e49}วแบบว\u{e31}ลแคน"),
            keywords: &[
                "ช\u{e39}น\u{e34}\u{e49}วแบบว\u{e31}ลแคน",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
                "ว\u{e31}ลแคน",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("wulkan salam"),
            keywords: &["barmak", "el", "syňrak", "wulkan salam", "ýanardag"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima mavaeua"),
            keywords: &["nima mavaeua"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("Vulkan selamı"),
            keywords: &[
                "Vulkan selamı",
                "beden",
                "el",
                "parmak",
                "spock",
                "vulcan selamı",
                "vulkan",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ۋولقان سالام"),
            keywords: &["بارماق", "سپوك", "قول", "ۋولقان", "ۋولقان سالام"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вулканське вітання"),
            keywords: &[
                "вулкан",
                "вулканське вітання",
                "зоряний шлях",
                "палець",
                "рука",
                "спок",
                "тіло",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("وولکن سلیوٹ"),
            keywords: &["انگلی", "ا\u{64e}تش فشاں", "جسم", "وولکن سلیوٹ", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("vulkan salyuti"),
            keywords: &["barmoq", "qo‘l", "spok", "tana", "vulkan", "vulkan salyuti"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tay thần lửa"),
            keywords: &["ngón tay", "spock", "tay", "tay thần lửa", "thần lửa"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("loxo xaajale ñeenti baaraam"),
            keywords: &[
                "baaraam",
                "ferñet",
                "loxo",
                "loxo xaajale ñeenti baaraam",
                "wolkaa",
            ],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umbuliso we-vulcan"),
            keywords: &[
                "i-spock",
                "i-vulcan",
                "isandla",
                "umbuliso we-vulcan",
                "umnwe",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Kiki Ibẹri Funni"),
            keywords: &["Kiki Ibẹri Funni", "spock", "vulcan", "ìka", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("瓦肯式敬禮手勢"),
            keywords: &["手", "手指", "敬禮", "瓦肯式", "瓦肯式敬禮手勢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("瓦肯式敬礼手势"),
            keywords: &["手", "手指", "敬礼", "瓦肯式", "瓦肯式敬礼手势"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("瓦肯举手礼"),
            keywords: &["手", "敬礼", "斯波克", "星际迷航", "瓦肯", "瓦肯举手礼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("你好"),
            keywords: &["你好", "瓦肯式敬禮"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["你好", "火神星人", "舉手禮"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("i-vulcan salute"),
            keywords: &["i-vulcan salute", "isandla", "umunwe", "umzimba", "vulcan"],
        },
    ],
};
#[doc = "🖖🏻"]
pub const VULCAN_SALUTE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖖🏻",
    codepoint: "1F596 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "vulcan salute: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖖🏼"]
pub const VULCAN_SALUTE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖖🏼",
    codepoint: "1F596 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "vulcan salute: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖖🏽"]
pub const VULCAN_SALUTE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖖🏽",
    codepoint: "1F596 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "vulcan salute: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖖🏾"]
pub const VULCAN_SALUTE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖖🏾",
    codepoint: "1F596 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "vulcan salute: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🖖🏿"]
pub const VULCAN_SALUTE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🖖🏿",
    codepoint: "1F596 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "vulcan salute: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-open",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
