#[doc = "👍"]
pub const THUMBS_UP: crate::Emoji = crate::Emoji {
    glyph: "👍",
    codepoint: "1F44D",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "thumbs up",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("laaik baie"),
            keywords: &["+1", "duim", "hand", "laaik baie", "liggaam", "op"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውራ ጣት ወደ ላይ"),
            keywords: &["ላይ", "አውራ ጣት", "አውራ ጣት ወደ ላይ", "እጅ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبول"),
            keywords: &["أعلى", "إبهام", "علامة", "قبول", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভ\u{9be}ল কৰিছো"),
            keywords: &[
                "+১",
                "ওপৰ",
                "ব\u{9c1}ঢ\u{9bc}\u{9be} আঙ\u{9c1}লি",
                "ভ\u{9be}ল কৰিছো",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("baş barmaq yuxarı"),
            keywords: &["baş barmaq", "baş barmaq yuxarı", "orqan", "yuxarı", "əl"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікі палец уверх"),
            keywords: &[
                "+1",
                "вялікі палец уверх",
                "лайк",
                "падабайка",
                "палец",
                "уверх",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Палец нагоре"),
            keywords: &["+1", "Палец нагоре", "нагоре", "палец", "ръка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}লো করেছো"),
            keywords: &[
                "1",
                "উর\u{9cd}দ\u{9cd}ধম\u{9c1}খী",
                "ব\u{9c1}ড\u{9bc}ো আঙ\u{9cd}গ\u{9c1}ল",
                "ভ\u{9be}লো করেছো",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("palac gore"),
            keywords: &["+1", "gore", "palac", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("polze cap amunt"),
            keywords: &["amunt", "polze", "polze cap amunt"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᎦᏰᏌᏛ ᎤᎵᏌᎳᏓ"),
            keywords: &["+1", "ᎤᏔᎾ ᎥᎦᏰᏌᏛ", "ᎤᏔᎾ ᎦᏰᏌᏛ ᎤᎵᏌᎳᏓ", "ᎤᏬᏱ", "ᎦᎸᎳᏓᎬᏘ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("palec nahoru"),
            keywords: &["+1", "nahoru", "palec", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bys bawd i fyny"),
            keywords: &["bys bawd", "bys bawd i fyny", "corff", "ok"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tommelfinger op"),
            keywords: &["OK", "håndtegn", "ok", "tommelfinger op"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Daumen hoch"),
            keywords: &["Daumen", "Daumen hoch", "Hand", "gut", "nach oben"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σηκωμένος αντίχειρας"),
            keywords: &[
                "+1",
                "αντίχειρας",
                "επάνω",
                "σηκωμένος αντίχειρας",
                "σώμα",
                "χέρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thumbs up"),
            keywords: &["+1", "hand", "thumb", "thumbs up", "up"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pulgar hacia arriba"),
            keywords: &["arriba", "mano", "pulgar", "pulgar hacia arriba", "señal"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["+1", "arriba", "mano", "pulgar", "pulgar hacia arriba"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "+1",
                "OK",
                "de acuerdo",
                "pulgar",
                "pulgar hacia arriba",
                "señal de OK",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("meeldib"),
            keywords: &["keha", "käsi", "meeldib", "pöial"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erpurua gora"),
            keywords: &["erpurua", "eskua", "gora", "gorputza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پسندیدن"),
            keywords: &["1+", "بالا", "دست", "شست", "پسندیدن"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("peukalo ylös"),
            keywords: &["+1", "käsi", "peukalo", "vartalo", "ylös"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("thumbs up"),
            keywords: &["+1", "hinlalaki", "kamay", "ok", "thumbs up"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tummil upp"),
            keywords: &["gott", "samdur", "tummil", "tummil upp"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pouce vers le haut"),
            keywords: &["main", "pouce vers le haut", "super"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["OK", "génial", "oui", "pouce vers le haut", "super"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ordóg suas"),
            keywords: &["OK", "moladh", "ordóg", "ordóg suas"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("math fhèin"),
            keywords: &["+1", "làmh", "math", "math fhèin", "suas", "òrdag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("polgar cara arriba"),
            keywords: &["+1", "gústame", "man", "polgar", "polgar cara arriba"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("થમ\u{acd}બ\u{acd}સ અપ"),
            keywords: &[
                "અ\u{a82}ગ\u{ac1}ઠો",
                "ઉ\u{a82}ચો",
                "ચિહ\u{acd}ન",
                "થમ\u{acd}બ\u{acd}સ અપ",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("da kyau"),
            keywords: &["+1", "babban yatsa", "da kyau", "hannu", "sama"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אגודל למעלה"),
            keywords: &["אגודל", "אהבתי", "אישור", "טוב", "לייק", "למעלה", "סבבה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थ\u{902}ब\u{94d}स अप"),
            keywords: &[
                "अ\u{902}ग\u{942}ठा",
                "ऊपर",
                "चिह\u{94d}न",
                "थ\u{902}ब\u{94d}स अप",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("palac gore"),
            keywords: &["+1", "dobro", "gore", "palac", "ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felfelé mutató hüvelykujj"),
            keywords: &[
                "felfelé mutató hüvelykujj",
                "hüvelykujj felfelé",
                "kéz",
                "oké",
                "rendben",
                "test",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բութ մատը վեր"),
            keywords: &["+1", "բութ", "բութ մատը վեր", "ձեռք", "մարմին", "վեր"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jempol ke atas"),
            keywords: &[
                "+1",
                "atas",
                "badan",
                "jempol",
                "jempol ke atas",
                "tangan",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("oboaka n’elu"),
            keywords: &["+1", "aka", "elu", "oboaka", "oboaka n’elu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þumall upp"),
            keywords: &["bending", "hönd", "þumall upp"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pollice in su"),
            keywords: &["mano", "pollice", "pollice in su", "segno", "su"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サムズアップ"),
            keywords: &[
                "OK",
                "オッケー",
                "オーケー",
                "グッド",
                "サムズアップ",
                "上",
                "手",
                "親指",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jempol ngacung"),
            keywords: &["+1", "jempol", "ngacung", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცერა ზემოთ"),
            keywords: &["+1", "ზემოთ", "სხეული", "ტანი", "ცერა", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тамаша"),
            keywords: &["бас бармақ", "жоғары", "тамаша", "қол", "қосымша 1 ұпай"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tommelfinger op"),
            keywords: &["håndtegn", "tommelfinger op"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មេដៃឡើងលើ"),
            keywords: &["+1", "ដៃ", "មេដៃ", "មេដៃឡើងលើ", "ឱ\u{17d2}យមេដៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಥಂಬ\u{ccd}ಸ\u{ccd} ಅಪ\u{ccd}"),
            keywords: &[
                "ಒಪ\u{ccd}ಪ\u{cbf}ಗ\u{cc6}ಯ ಸಂಕೇತ",
                "ಥಂಬ\u{ccd}ಸ\u{ccd} ಅಪ\u{ccd}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("올린 엄지"),
            keywords: &["따봉", "올린 엄지", "좋아요", "최고"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आखाणो वयर"),
            keywords: &["+1", "आखाणो", "वयर", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«сонун»"),
            keywords: &["+1", "«начар»", "«сонун»", "бармак", "жогору", "кол"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Daum no uewen"),
            keywords: &["+1", "Daum", "Daum no uewen", "Hand", "no uewen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂປ\u{ec9}ມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ"),
            keywords: &[
                "ນ\u{eb4}\u{ec9}ວ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
                "ໂປ\u{ec9}ມ\u{eb7}ຂ\u{eb6}\u{ec9}ນ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nykštys į viršų"),
            keywords: &["liuks", "nykštys", "nykštys į viršų", "ranka", "į viršų"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("augšupvērsts īkšķis"),
            keywords: &[
                "+1",
                "augšup",
                "augšupvērsts īkšķis",
                "patīk",
                "roka",
                "īkšķis",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōnui ake"),
            keywords: &["+1", "ake", "kōnui", "ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("палец нагоре"),
            keywords: &["горе", "палец", "палец нагоре", "рака", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൊള\u{d4d}ള\u{d3e}ം"),
            keywords: &[
                "ഇഷ\u{d4d}\u{200c}ടമ\u{d3e}യി",
                "കൈ",
                "കൊള\u{d4d}ള\u{d3e}ം",
                "നന\u{d4d}ന\u{d3e}യി",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сайн"),
            keywords: &["амжилттай", "гар", "сайн", "таалагдсан", "хуруу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थम\u{94d}स अप"),
            keywords: &["+1", "अ\u{902}गठा", "थम\u{94d}स अप", "वर", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol bagus"),
            keywords: &["+1", "atas", "badan", "ibu jari", "simbol bagus", "tangan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("behem ’il fuq"),
            keywords: &["+1", "behem", "behem ’il fuq", "id", "’il fuq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ထောင\u{103a}ပြထားသည\u{1037}\u{103a} လက\u{103a}မ"),
            keywords: &[
                "ထောင\u{103a}ပြထားသည\u{1037}\u{103a} လက\u{103a}မ",
                "လက\u{103a}",
                "လက\u{103a}မ",
                "လက\u{103a}မထောင\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tommel opp"),
            keywords: &["hånd", "tegn", "tommel", "tommel opp"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गजब"),
            keywords: &["गजब", "ब\u{942}ढी औ\u{902}ला", "माथि", "हात", "\u{200c}+1"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("duim omhoog"),
            keywords: &["+1", "duim", "hand", "omhoog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tommel opp"),
            keywords: &["hand", "teikn", "tommel", "tommel opp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସଫଳ ହେବ\u{b3e} ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "+1",
                "ଉପର",
                "ବ\u{b41}ଢ\u{b3c}\u{b3e} ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ସଫଳ ହେବ\u{b3e} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਥ\u{a70}ਮਸ ਅ\u{a71}ਪ"),
            keywords: &[
                "ਅ\u{a70}ਗ\u{a42}ਠਾ",
                "ਉ\u{a71}ਪਰ",
                "ਥ\u{a70}ਮਸ ਅ\u{a71}ਪ",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("انگوٹھا اوتے"),
            keywords: &["1", "انگوٹھا", "انگوٹھا اوتے", "ا\u{64f}وتے", "ہتھ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}mb Ọp"),
            keywords: &[
                "+1",
                "Hand",
                "Tọmb De Pọínt Ọp",
                "Tọ\u{301}mb Ọp",
                "Tọ\u{301}mbs Ọp",
                "Ọp",
                "Ọ\u{301}p Yu",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kciuk w górę"),
            keywords: &["OK", "brawo", "kciuk w górę", "lubię", "podoba mi się"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډیر ښه"),
            keywords: &["+1", "غټه ګوته", "لاس", "پورته", "ډیر ښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("polegar para cima"),
            keywords: &["dedão", "mão", "para cima", "polegar para cima", "sinal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("polegar para cima"),
            keywords: &[
                "corpo",
                "gosto",
                "mão",
                "para cima",
                "polegar",
                "polegar para cima",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("hanaqpi rukʼana"),
            keywords: &["+1", "hanaq", "hanaqpi rukʼana", "maki", "rukʼana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn de aprobare"),
            keywords: &[
                "+1",
                "aprobare",
                "da",
                "mână",
                "pozitiv",
                "semn de aprobare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-522"),
            keywords: &["E10-522"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("большой палец вверх"),
            keywords: &[
                "большой палец вверх",
                "вверх",
                "нравится",
                "одобрение",
                "палец",
                "рука",
                "хорошо",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibikumwe bireba hejuru"),
            keywords: &[
                "+1",
                "hejuru",
                "ibikumwe bireba hejuru",
                "igikumwe",
                "ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي انگوٺو"),
            keywords: &["خوب، بهترين، واه واه", "مٿي انگوٺو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මහපටැඟ\u{dd2}ල\u{dca}ල ඉහළට"),
            keywords: &[
                "1",
                "අත",
                "ඉහළට.",
                "මහපටැඟ\u{dd2}ල\u{dca}ල",
                "මහපටැඟ\u{dd2}ල\u{dca}ල ඉහළට",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("palec nahor"),
            keywords: &["+1", "nahor", "palec", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("palec gor"),
            keywords: &["+1", "dlan", "gor", "palec", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("suulka kor"),
            keywords: &["+1", "gacan", "kor", "suul", "suulka kor"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gishti i madh lart"),
            keywords: &["+1", "dorë", "gisht i madh", "gishti i madh lart"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("палац нагоре"),
            keywords: &[
                "+1",
                "oцeнa",
                "дoбрo",
                "нагoрe",
                "пaлaц",
                "палац нагоре",
                "рукa",
                "тело",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["палац нагоре"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("palac nagore"),
            keywords: &["+1", "dobro", "nagore", "ocena", "palac", "ruka", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["palac nagore"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tummen upp"),
            keywords: &["gillar", "tumme", "tummen upp", "upp"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dole gumba juu"),
            keywords: &["1", "dole gumba juu", "gumba", "juu", "mkono", "mwili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("சூப\u{bcd}பர\u{bcd}"),
            keywords: &[
                "சின\u{bcd}னம\u{bcd}",
                "சூப\u{bcd}பர\u{bcd}",
                "பெருவிரல\u{bcd}",
                "முடிந\u{bcd}தது",
                "வெற\u{bcd}றி",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("బ\u{c4a}టన\u{c3f} వ\u{c47}లు ప\u{c48}క\u{c3f} చూప\u{c47} గుర\u{c4d}తు"),
            keywords: &[
                "గుర\u{c4d}తు",
                "బ\u{c4a}టన\u{c3f} వ\u{c47}లు ప\u{c48}క\u{c3f} చూప\u{c47} గుర\u{c4d}తు",
                "వ\u{c47}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("хуб"),
            keywords: &["+1", "боло", "даст", "нарангушт", "хуб"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ช\u{e39}น\u{e34}\u{e49}วโป\u{e49}งข\u{e36}\u{e49}น"),
            keywords: &[
                "ช\u{e39}น\u{e34}\u{e49}วโป\u{e49}งข\u{e36}\u{e49}น",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("başam barmak ýokary"),
            keywords: &["+1", "başam barmak", "başam barmak ýokary", "el", "ýokary"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("motuʻatuhu ki ʻolunga"),
            keywords: &["motuʻatuhu ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("baş parmak yukarıda"),
            keywords: &[
                "baş parmak",
                "baş parmak yukarıda",
                "el",
                "işaret",
                "yukarı",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قوللاش"),
            keywords: &["+1", "ئۈستى", "باش بارما", "قول", "قوللاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("великі пальці вгору"),
            keywords: &["+1", "великі пальці вгору", "подобається", "рука", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("سب اچھا کا نشان بناتا انگوٹھا"),
            keywords: &[
                "+1",
                "انگوٹھا",
                "اوپر",
                "بہت اچھے",
                "سب اچھا کا نشان بناتا انگوٹھا",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tepaga qaragan bosh barmoq"),
            keywords: &[
                "+1",
                "bosh barmoq",
                "qo‘l",
                "tana",
                "tepaga",
                "tepaga qaragan bosh barmoq",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu ra hiệu đồng ý"),
            keywords: &["+1", "dấu ra hiệu đồng ý", "lên", "ngón tay cái", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baaraamu waaw"),
            keywords: &["+1", "baaraam bu dijj", "baaraamu waaw", "kaw", "loxo"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubhontsi ojonge phezulu"),
            keywords: &[
                "+1",
                "isandla",
                "phezulu",
                "ubhontsi",
                "ubhontsi ojonge phezulu",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Atanpako Loke"),
            keywords: &["+1", "Atanpako Loke", "àtànpàkò", "òkè", "ọwọ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("豎起手指公"),
            keywords: &["+1", "手", "手指公", "豎起", "豎起手指公"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("竖起手指公"),
            keywords: &["+1", "手", "手指公", "竖起", "竖起手指公"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("拇指向上"),
            keywords: &["同意", "手", "拇指向上", "真棒", "赞成", "顶一下"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("讚"),
            keywords: &["好棒", "讚"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["有眼光", "無問題", "繼續努力", "讚", "選得好"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukumisa isithupha"),
            keywords: &["+1", "isandla", "isithupha", "phezulu", "ukumisa isithupha"],
        },
    ],
};
#[doc = "👍🏻"]
pub const THUMBS_UP_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👍🏻",
    codepoint: "1F44D 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs up: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👍🏼"]
pub const THUMBS_UP_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👍🏼",
    codepoint: "1F44D 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs up: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👍🏽"]
pub const THUMBS_UP_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👍🏽",
    codepoint: "1F44D 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs up: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👍🏾"]
pub const THUMBS_UP_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👍🏾",
    codepoint: "1F44D 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs up: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👍🏿"]
pub const THUMBS_UP_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👍🏿",
    codepoint: "1F44D 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs up: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👎"]
pub const THUMBS_DOWN: crate::Emoji = crate::Emoji {
    glyph: "👎",
    codepoint: "1F44E",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "thumbs down",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("laaik niks"),
            keywords: &["-1", "af", "duim", "hand", "laaik niks", "liggaam"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውራ ጣት ወደ ታች"),
            keywords: &["ታች", "አውራ ጣት", "አውራ ጣት ወደ ታች", "እጅ", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رفض"),
            keywords: &["أسفل", "إبهام", "رفض", "علامة", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9c1}ঢ\u{9bc}\u{9be} আঙ\u{9c1}লি তললৈ নমোৱ\u{9be}"),
            keywords: &[
                "-১",
                "তল",
                "ব\u{9c1}ঢ\u{9bc}\u{9be} আঙ\u{9c1}লি",
                "ব\u{9c1}ঢ\u{9bc}\u{9be} আঙ\u{9c1}লি তললৈ নমোৱ\u{9be}",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("baş barmaq aşağı"),
            keywords: &[
                "-1",
                "aşağı",
                "baş barmaq",
                "baş barmaq aşağı",
                "orqan",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вялікі палец уніз"),
            keywords: &["-1", "вялікі палец уніз", "дызлайк", "палец", "уніз"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Палец надолу"),
            keywords: &["-1", "Палец надолу", "надолу", "палец", "ръка"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ভ\u{9be}লো করতে প\u{9be}রোনি"),
            keywords: &[
                "1",
                "নিম\u{9cd}নম\u{9c1}খী",
                "ব\u{9c1}ড\u{9bc}ো আঙ\u{9cd}গ\u{9c1}ল",
                "ভ\u{9be}লো করতে প\u{9be}রোনি",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("palac dolje"),
            keywords: &["-1", "dolje", "palac", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("polze cap avall"),
            keywords: &["avall", "polze", "polze cap avall"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏔᎾ ᎦᏰᏌᏛ ᎡᎳᏗᏜ"),
            keywords: &["-1", "ᎡᎳᏗ", "ᎤᏔᎾ ᎦᏰᏌᏛ", "ᎤᏔᎾ ᎦᏰᏌᏛ ᎡᎳᏗᏜ", "ᎤᏬᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("palec dolů"),
            keywords: &["-1", "dolů", "palec", "ruka", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("bys bawd i lawr"),
            keywords: &["bys bawd", "bys bawd i lawr", "corff", "i lawr", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tommelfinger ned"),
            keywords: &["håndtegn", "nedstemt", "tommelfinger ned"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Daumen runter"),
            keywords: &["Daumen", "Daumen runter", "Hand", "nach unten", "schlecht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κατεβασμένος αντίχειρας"),
            keywords: &[
                "-1",
                "αντίχειρας",
                "κάτω",
                "κατεβασμένος αντίχειρας",
                "σώμα",
                "χέρι",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("thumbs down"),
            keywords: &["-1", "down", "hand", "thumb", "thumbs down"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pulgar hacia abajo"),
            keywords: &["abajo", "mano", "pulgar", "pulgar hacia abajo", "señal"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["-1", "abajo", "mano", "pulgar", "pulgar hacia abajo"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &[
                "-1",
                "abajo",
                "desacuerdo",
                "mano",
                "pulgar",
                "pulgar hacia abajo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ei meeldi"),
            keywords: &["ei meeldi", "keha", "käsi", "pöial"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("erpurua behera"),
            keywords: &["behera", "erpurua", "eskua", "gorputza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("نپسندیدن"),
            keywords: &["1-", "دست", "شست", "نپسندیدن", "پایین"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("peukalo alas"),
            keywords: &["-1", "alas", "käsi", "peukalo", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("thumbs down"),
            keywords: &["boo", "daliri", "hindi ok", "hinlalaki", "thumbs down"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tummil niður"),
            keywords: &["niður", "tummil", "vánaligt", "ósamdur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pouce vers le bas"),
            keywords: &["main", "nul", "pouce vers le bas"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["non", "nul", "négatif", "pouce vers le bas"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("ordóg síos"),
            keywords: &["OK", "cáineadh", "ordóg", "ordóg síos"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("mo chreach"),
            keywords: &["-1", "dona", "làmh", "mo chreach", "sìos", "òrdag"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("polgar cara abaixo"),
            keywords: &["man", "non me gusta", "polgar cara abaixo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નીચો અ\u{a82}ગ\u{ac2}ઠો"),
            keywords: &[
                "અ\u{a82}ગ\u{ac1}ઠો",
                "ચિહ\u{acd}ન",
                "નીચો",
                "નીચો અ\u{a82}ગ\u{ac2}ઠો",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("babu kyau"),
            keywords: &["-1", "babban yatsa", "babu kyau", "hannu", "ƙasa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אגודל למטה"),
            keywords: &["אגודל למטה", "לא אהבתי", "לא טוב", "למטה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("थ\u{902}ब\u{94d}स डाउन"),
            keywords: &[
                "अ\u{902}ग\u{942}ठा",
                "चिह\u{94d}न",
                "थ\u{902}ब\u{94d}स डाउन",
                "नीच\u{947}",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("palac dolje"),
            keywords: &["-1", "dolje", "loše", "palac", "ruka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lefelé mutató hüvelykujj"),
            keywords: &[
                "hüvelykujj lefelé",
                "kéz",
                "lefelé mutató hüvelykujj",
                "test",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բութ մատը ներքև"),
            keywords: &[
                "-1",
                "բութ մատ",
                "բութ մատը ներքև",
                "ձեռք",
                "մարմին",
                "ներքև",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("jempol ke bawah"),
            keywords: &[
                "-1",
                "badan",
                "bawah",
                "jempol",
                "jempol ke bawah",
                "tangan",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("oboaka n’ala"),
            keywords: &["-1", "aka", "ala", "oboaka", "oboaka n’ala"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("þumall niður"),
            keywords: &["bending", "hönd", "þumall niður"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pollice verso"),
            keywords: &["giù", "mano", "pollice", "pollice in giù", "pollice verso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("サムズダウン"),
            keywords: &[
                "NG",
                "だめ",
                "サムズダウン",
                "ブーイング",
                "ボツ",
                "下",
                "手",
            ],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jempol ngacung mudhun"),
            keywords: &[
                "-1",
                "jempol",
                "jempol ngacung mudhun",
                "ngacung mudhun",
                "tangan",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცერა ქვემოთ"),
            keywords: &["-1", "სხეული", "ტანი", "ქვემოთ", "ცერა", "ხელი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("нашар"),
            keywords: &["1 ұпай алынады", "бас бармақ", "нашар", "төмен", "қол"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tommelfinger ned"),
            keywords: &["håndtegn", "tommelfinger ned"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មេដៃច\u{17bb}ះក\u{17d2}រោម"),
            keywords: &[
                "-1",
                "ច\u{17bb}ះក\u{17d2}រោម",
                "ដៃ",
                "មេដៃ",
                "មេដៃច\u{17bb}ះក\u{17d2}រោម",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಥಂಬ\u{ccd}ಸ\u{ccd} ಡ\u{ccc}ನ\u{ccd}"),
            keywords: &[
                "ಅಸಮ\u{ccd}ಮತ\u{cbf}ಯ ಸಂಕೇತ",
                "ಥಂಬ\u{ccd}ಸ\u{ccd} ಡ\u{ccc}ನ\u{ccd}",
                "ಹ\u{cc6}ಬ\u{ccd}ಬ\u{cc6}ರಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("내린 엄지"),
            keywords: &["내린 엄지", "싫어요", "야유", "최악"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आखाणो सकयल"),
            keywords: &["-1", "आखाणो", "सकयल", "हात"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("«начар»"),
            keywords: &["-1", "«начар»", "бармак", "кол", "төмөн"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Daum no ënnen"),
            keywords: &["-1", "Daum", "Daum no ënnen", "Hand", "no ënnen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ໂປ\u{ec9}ມ\u{eb7}ລ\u{ebb}ງ"),
            keywords: &[
                "ນ\u{eb4}\u{ec9}ວ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
                "ໂປ\u{ec9}ມ\u{eb7}ລ\u{ebb}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nykštys į apačią"),
            keywords: &["blogai", "nykštys", "nykštys į apačią", "ranka"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("lejupvērsts īkšķis"),
            keywords: &[
                "-1",
                "lejup",
                "lejupvērsts īkšķis",
                "nepatīk",
                "roka",
                "īkšķis",
                "ķermenis",
            ],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("kōnui iho"),
            keywords: &["-1", "iho", "kōnui", "ringa"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("палец надолу"),
            keywords: &["долу", "палец", "палец надолу", "рака", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മോശം"),
            keywords: &[
                "ഇഷ\u{d4d}\u{200c}ടമ\u{d3e}യില\u{d4d}ല",
                "കൈ",
                "നല\u{d4d}ലതല\u{d4d}ല",
                "മോശം",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("муу"),
            keywords: &["амжилтгүй", "гар", "муу", "таалагдаагүй", "хуруу"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("थम\u{94d}स डाउन"),
            keywords: &["-1", "अ\u{902}गठा", "खाली", "थम\u{94d}स डाउन", "हात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("simbol tidak bagus"),
            keywords: &[
                "-1",
                "badan",
                "bawah",
                "ibu jari",
                "simbol tidak bagus",
                "tangan",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("behem ’l isfel"),
            keywords: &["-1", "behem", "behem ’l isfel", "id", "’l isfel"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အောက\u{103a}သ\u{102d}\u{102f}\u{1037}ပြနေသည\u{1037}\u{103a} လက\u{103a}မ"),
            keywords: &[
                "လက\u{103a}",
                "လက\u{103a}မ",
                "လက\u{103a}မ အောက\u{103a}စ\u{102d}\u{102f}က\u{103a}ပြနေသည\u{1037}\u{103a} လက\u{103a}ဟန\u{103a}",
                "အောက\u{103a}သ\u{102d}\u{102f}\u{1037}ပြနေသည\u{1037}\u{103a} လက\u{103a}မ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tommel ned"),
            keywords: &["hånd", "tegn", "tommel", "tommel ned"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("गाली"),
            keywords: &["गाली", "तल", "ब\u{941}ढी औ\u{902}ला", "शरीर", "हात"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("duim omlaag"),
            keywords: &["-1", "duim", "hand", "lichaam", "omlaag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tommel ned"),
            keywords: &["hand", "teikn", "tommel", "tommel ned"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଅସଫଳତ\u{b3e} ଚ\u{b3f}ହ\u{b4d}ନ"),
            keywords: &[
                "-1",
                "ଅସଫଳତ\u{b3e} ଚ\u{b3f}ହ\u{b4d}ନ",
                "ତଳକ\u{b41}",
                "ବ\u{b41}ଢ\u{b3c}\u{b3e} ଆଙ\u{b4d}ଗ\u{b41}ଠ\u{b3f}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a70}ਗ\u{a42}ਠਾ ਥ\u{a71}ਲ\u{a47}"),
            keywords: &[
                "ਅ\u{a70}ਗ\u{a42}ਠਾ ਥ\u{a71}ਲ\u{a47}",
                "ਅ\u{a70}ਗ\u{a42}ਠ\u{a47}",
                "ਅ\u{a70}ਗ\u{a42}\u{a42}ਠਾ ਥ\u{a71}ਲ\u{a47}",
                "ਥ\u{a71}ਲ\u{a47}",
                "ਨਿਸ\u{a3c}ਾਨ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("انگوٹھا ہیٹھاں"),
            keywords: &["-1", "انگوٹھا", "ہتھ", "ہیٹھاں"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọ\u{301}mb Daun"),
            keywords: &[
                "-1",
                "Daun",
                "Hand",
                "Tọmb",
                "Tọ\u{301}mb Daun",
                "Tọ\u{301}mbs Daun",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kciuk w dół"),
            keywords: &["brzydkie", "kciuk w dół", "nie lubię", "nie podoba mi się"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ډیر بد"),
            keywords: &["+1", "غټه ګوته", "لاس", "ډیر بد"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("polegar para baixo"),
            keywords: &["dedão", "mão", "para baixo", "polegar para baixo", "sinal"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("polegar para baixo"),
            keywords: &[
                "corpo",
                "mão",
                "não gosto",
                "para baixo",
                "polegar",
                "polegar para baixo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("uranpi rukʼana"),
            keywords: &["-1", "maki", "rukʼana", "uran", "uranpi rukʼana"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("semn de dezaprobare"),
            keywords: &[
                "-1",
                "dezaprobare",
                "mână",
                "negativ",
                "nu",
                "semn de dezaprobare",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-523"),
            keywords: &["E10-523"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("большой палец вниз"),
            keywords: &[
                "большой палец вниз",
                "вниз",
                "палец",
                "плохо",
                "порицание",
                "рука",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ibikumwe bireba hasi"),
            keywords: &[
                "-1",
                "cyerekeje hasi",
                "ibikumwe bireba hasi",
                "igikumwe",
                "ikiganza",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هيٺ انگوٺو"),
            keywords: &["انڪار، ڪنو، هيٺ، هٿ", "هيٺ انگوٺو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මහපටැඟ\u{dd2}\u{dd2}ල\u{dca}ල පහළට"),
            keywords: &[
                "-1",
                "අත",
                "පහළට",
                "මහපටැඟ\u{dd2}ල\u{dca}ල",
                "මහපටැඟ\u{dd2}\u{dd2}ල\u{dca}ල පහළට",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("palec nadol"),
            keywords: &["-1", "nadol", "palec", "ruka"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("palec dol"),
            keywords: &["-1", "dlan", "dol", "palec", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("suulka hoos"),
            keywords: &["-1", "gacan", "hoos", "suul", "suulka hoos"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gishti i madh poshtë"),
            keywords: &[
                "-1",
                "dorë",
                "gisht i madh",
                "gishti i madh poshtë",
                "poshtë",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("палац надоле"),
            keywords: &[
                "-1",
                "oцeнa",
                "лoшe",
                "надoлe",
                "пaлaц",
                "палац надоле",
                "рукa",
                "тело",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("палац надоље"),
            keywords: &["палац надоље"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("palac nadole"),
            keywords: &["-1", "loše", "nadole", "ocena", "palac", "ruka", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("palac nadolje"),
            keywords: &["palac nadolje"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tummen ned"),
            keywords: &["ner", "ogilla", "tumme", "tummen ned"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("dole gumba chini"),
            keywords: &["-1", "chini", "dole gumba chini", "gumba", "mkono", "mwili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பிடிக\u{bcd}கவில\u{bcd}லை"),
            keywords: &[
                "சின\u{bcd}னம\u{bcd}",
                "தோல\u{bcd}வி",
                "நன\u{bcd}ற\u{bbe}க இல\u{bcd}லை",
                "பிடிக\u{bcd}கவில\u{bcd}லை",
                "பெருவிரல\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "బ\u{c4a}టన\u{c3f} వ\u{c47}లు క\u{c3f}ంద\u{c3f}క\u{c3f} చూప\u{c47} గుర\u{c4d}తు",
            ),
            keywords: &[
                "గుర\u{c4d}తు",
                "బ\u{c4a}టన\u{c3f} వ\u{c47}లు క\u{c3f}ంద\u{c3f}క\u{c3f} చూప\u{c47} గుర\u{c4d}తు",
                "వ\u{c47}లు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бад"),
            keywords: &["-1", "бад", "даст", "нарангушт", "поён"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("คว\u{e48}ำน\u{e34}\u{e49}วโป\u{e49}งลง"),
            keywords: &[
                "คว\u{e48}ำน\u{e34}\u{e49}วโป\u{e49}งลง",
                "น\u{e34}\u{e49}ว",
                "ม\u{e37}อ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("başam barmak aşak"),
            keywords: &["-1", "aşak", "başam barmak", "başam barmak aşak", "el"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("motuʻatuhu ki lalo"),
            keywords: &["motuʻatuhu ki lalo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("baş parmak aşağıda"),
            keywords: &["aşağı", "baş parmak", "baş parmak aşağıda", "el", "işaret"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("پۇتلاش"),
            keywords: &["-1", "ئاستى", "باش بارماق", "قول", "پۇتلاش"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("великі пальці вниз"),
            keywords: &["-1", "великі пальці вниз", "не подобається", "рука", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("اچھا نہ ہونے کا نشان بناتا انگوٹھا"),
            keywords: &[
                "-1",
                "انگوٹھا",
                "اچھا نہ ہونے کا نشان بناتا انگوٹھا",
                "بہت برے",
                "نیچے",
                "ہاتھ",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("pastga qaragan bosh barmoq"),
            keywords: &[
                "-1",
                "bosh barmoq",
                "pastga",
                "pastga qaragan bosh barmoq",
                "qo‘l",
                "tana",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("dấu ra hiệu từ chối"),
            keywords: &["-1", "dấu ra hiệu từ chối", "ngón tay cái", "tay", "xuống"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("baaraamu déet"),
            keywords: &["-1", "baaraam bu dijj", "baaraamu déet", "loxo", "suuf"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubhontsi ojonge ezantsi"),
            keywords: &[
                "-1",
                "ezantsi",
                "isandla",
                "ubhontsi",
                "ubhontsi ojonge ezantsi",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Atanpako Nisalẹ"),
            keywords: &[
                "-1",
                "Atanpako Nisalẹ",
                "àtànpàkò",
                "ìsàlẹ\u{300}",
                "ọwọ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手指公向下"),
            keywords: &["-1", "下", "手", "手指公", "手指公向下"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手指公向下"),
            keywords: &["-1", "下", "手", "手指公", "手指公向下"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("拇指向下"),
            keywords: &["不赞成", "反对", "手", "拇指向下", "责备"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("遜"),
            keywords: &["好爛", "遜"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("渣"),
            keywords: &["不可能", "差", "沒辦法", "渣", "爛", "爛選擇"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukubhekisa phansi isithupha"),
            keywords: &[
                "-1",
                "isandla",
                "isithupha",
                "phansi",
                "ukubhekisa phansi isithupha",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👎🏻"]
pub const THUMBS_DOWN_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👎🏻",
    codepoint: "1F44E 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs down: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👎🏼"]
pub const THUMBS_DOWN_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👎🏼",
    codepoint: "1F44E 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs down: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👎🏽"]
pub const THUMBS_DOWN_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👎🏽",
    codepoint: "1F44E 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs down: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👎🏾"]
pub const THUMBS_DOWN_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👎🏾",
    codepoint: "1F44E 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs down: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👎🏿"]
pub const THUMBS_DOWN_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👎🏿",
    codepoint: "1F44E 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "thumbs down: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✊"]
pub const RAISED_FIST: crate::Emoji = crate::Emoji {
    glyph: "✊",
    codepoint: "270A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "raised fist",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vuis in die lug"),
            keywords: &[
                "gebal",
                "hand",
                "liggaam",
                "slaan",
                "vuis",
                "vuis in die lug",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ላይ የተያዘ ቡጢ"),
            keywords: &["ቡጢ", "እጅ", "ወደ ላይ የተያዘ ቡጢ", "የተጨበጠ", "ጡጫ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبضة يد مرفوعة"),
            keywords: &["جسد", "قبضة", "قبضة يد مرفوعة", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("উত\u{9cd}থিত ম\u{9c1}ষ\u{9cd}টি"),
            keywords: &[
                "উত\u{9cd}থিত ম\u{9c1}ষ\u{9cd}টি",
                "ভ\u{9c1}ক\u{9c1}",
                "ম\u{9c1}ষ\u{9cd}টি",
                "ম\u{9c1}ষ\u{9cd}টিবদ\u{9cd}ধ",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qaldırılmış yumruq"),
            keywords: &[
                "orqan",
                "qaldırılmış yumruq",
                "sıxılmış",
                "yumruq",
                "yumruqlamaq",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("падняты кулак"),
            keywords: &["кулак", "падняты кулак", "рука", "рэвалюцыя", "удар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Вдигнат юмрук"),
            keywords: &["Вдигнат юмрук", "ръка", "стиснат", "удар", "юмрук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some(
                "আঙ\u{9cd}গ\u{9c1}ল স\u{9be}মনের দিকে করে ম\u{9c1}ড\u{9bc}ে র\u{9be}খ\u{9be}",
            ),
            keywords: &[
                "আঙ\u{9cd}গ\u{9c1}ল স\u{9be}মনের দিকে করে ম\u{9c1}ড\u{9bc}ে র\u{9be}খ\u{9be}",
                "কিল",
                "ম\u{9c1}ষ\u{9cd}ট\u{9be}ঘ\u{9be}ত",
                "ম\u{9c1}ষ\u{9cd}টিবদ\u{9cd}ধ",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("podignuta pesnica"),
            keywords: &["pesnica", "podignuta pesnica", "podignuta šaka", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("puny alçat"),
            keywords: &["mà", "puny", "puny alçat"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎵᏇᏅ ᎠᏒᎵᏛᏅᎢ"),
            keywords: &["ᎠᎵᏇᏅ ᎠᏒᎵᏛᏅᎢ", "ᎤᏂᏴᎲᎢ", "ᎤᏬᏱ", "ᏍᏈᎾ", "ᏍᏈᎾ ᎬᏗ ᎠᎬᏂᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zvednutá pěst"),
            keywords: &["pěst", "ruka", "tělo", "zaťatá", "zvednutá pěst", "úder"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwrn wedi codi"),
            keywords: &["cau", "corff", "dwrn", "dwrn wedi codi", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("løftet knytnæve"),
            keywords: &["hånd", "knytnæve", "knyttet", "løftet knytnæve", "slå"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("erhobene Faust"),
            keywords: &["Faust", "erhobene Faust"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σηκωμένη γροθιά"),
            keywords: &["γροθιά", "μπουνιά", "σηκωμένη γροθιά", "σφιγμένο", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("raised fist"),
            keywords: &["clenched", "fist", "hand", "punch", "raised fist"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puño en alto"),
            keywords: &["cerrado", "mano", "puñetazo", "puño", "puño en alto"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("puño levantado"),
            keywords: &["cerrada", "mano", "piedra", "puño", "puño levantado"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("puño en alto"),
            keywords: &[
                "cerrada",
                "mano",
                "piedra",
                "puño",
                "puño en alto",
                "puño levantado",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("ülestõstetud rusikas"),
            keywords: &["keha", "käsi", "löök", "rusikas", "ülestõstetud rusikas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ukabil altxatua"),
            keywords: &[
                "eskua",
                "estutu",
                "ukabil altxatua",
                "ukabila",
                "ukabilkada",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مشت کردن"),
            keywords: &["بدن", "مشت", "مشت کردن", "کوبیدن", "گره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nostettu nyrkki"),
            keywords: &[
                "isku",
                "käsi",
                "nostettu nyrkki",
                "nyrkki",
                "puristettu",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("nakataas na kamao"),
            keywords: &[
                "kamao",
                "kamay",
                "nakasarang kamao",
                "nakataas na kamao",
                "suntok",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("knýttur nevi"),
            keywords: &["knýttur", "nevi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poing levé"),
            keywords: &["main", "pierre", "poing", "poing levé"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["levé", "main", "pierre", "poing"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dorn ardaithe"),
            keywords: &["buille", "carraig", "dorn", "dorn ardaithe", "dúnta"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dòrn air a thogail"),
            keywords: &["buille", "dòrn", "dòrn air a thogail", "dùinte", "làmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("puño en alto"),
            keywords: &["arriba", "loita", "puño", "puño en alto"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ઉઠાવ\u{ac7}લ મ\u{ac1}ઠ\u{acd}ઠી"),
            keywords: &[
                "ઉઠાવ\u{ac7}લ મ\u{ac1}ઠ\u{acd}ઠી",
                "મ\u{ac1}ઠ\u{acd}ઠી",
                "હાથ",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ɗagaggen dunƙulen hannu"),
            keywords: &[
                "dunƙulalle",
                "dunƙulen hannu",
                "hannu",
                "naushi",
                "ɗagaggen dunƙulen hannu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אגרוף מורם"),
            keywords: &["אגרוף", "אגרוף מורם", "אלימות", "כוח", "מכה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("उठी ह\u{941}ई म\u{941}ट\u{94d}ठी"),
            keywords: &["उठी ह\u{941}ई म\u{941}ट\u{94d}ठी", "हिला दिया"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("podignuta šaka"),
            keywords: &["podignuta šaka", "ruka", "stisnuto", "udarac", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("felemelt ököl"),
            keywords: &["felemelt", "test", "ököl", "ütés"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բարձրացված բռունցք"),
            keywords: &[
                "բարձրացված բռունցք",
                "բռունցք",
                "հարված",
                "ձեռք",
                "մարմին",
                "սեղմված",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan terkepal ke atas"),
            keywords: &[
                "badan",
                "kepal",
                "tangan",
                "tangan terkepal ke atas",
                "tinju",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ọkpọ ewelitere"),
            keywords: &[
                "aka",
                "aka afụ\u{300}rụ\u{300} afụ\u{300}",
                "aka ọkpọ ewelitere",
                "ịkụ ọkpọ",
                "ọkpọaka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hnefi"),
            keywords: &["hnefi", "uppréttur hnefi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pugno"),
            keywords: &["alzato", "pugno", "sasso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("げんこつ"),
            keywords: &["げんこつ", "グー", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ngacungake kepel"),
            keywords: &["kepel", "ngacungake kepel", "ngantem", "nggegem", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("აწეული მუშტი"),
            keywords: &[
                "აწეული მუშტი",
                "დარტყმა",
                "მუშტი",
                "სხეული",
                "ტანი",
                "შეკრული",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұдырық көтеру"),
            keywords: &["дене", "жұдырық", "жұдырық көтеру", "жұмылған", "соққы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("løftet knytnæve"),
            keywords: &[
                "hånd",
                "knytnæve",
                "knyttet",
                "krop",
                "løftet knytnæve",
                "slå",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("លើកកណ\u{17d2}តាប\u{17cb}ដៃ"),
            keywords: &[
                "កណ\u{17d2}តាប\u{17cb}ដៃ",
                "ក\u{17d2}តាប\u{17cb}",
                "ក\u{17d2}តាប\u{17cb}ដៃ",
                "លើកកណ\u{17d2}តាប\u{17cb}ដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎತ\u{ccd}ತ\u{cbf}ರುವ ಮುಷ\u{ccd}ಟ\u{cbf}"),
            keywords: &[
                "ಎತ\u{ccd}ತ\u{cbf}ರುವ ಮುಷ\u{ccd}ಟ\u{cbf}",
                "ಕೈ",
                "ಮುಷ\u{ccd}ಟ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주먹"),
            keywords: &["묵", "바위", "주먹"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उखलिल\u{94d}ली म\u{942}ठ"),
            keywords: &[
                "आवळिल\u{94d}ली",
                "उखलिल\u{94d}ली म\u{942}ठ",
                "म\u{942}ठ",
                "म\u{942}ठ मारप",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көтөрүлгөн муштум"),
            keywords: &["дене", "кол", "көтөрүлгөн муштум", "муштум", "сокку"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("héichgehale Fauscht"),
            keywords: &["Fauscht", "Hand", "boxen", "héichgehale Fauscht", "zouen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຊ\u{eb9}ກຳປ\u{eb1}\u{ec9}ນ"),
            keywords: &[
                "ກຳປ\u{eb1}\u{ec9}ນ",
                "ຊ\u{eb9}ກຳປ\u{eb1}\u{ec9}ນ",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("iškeltas kumštis"),
            keywords: &[
                "iškeltas kumštis",
                "kumštis",
                "ranka",
                "smūgis",
                "sugniaužta",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pacelta dūre"),
            keywords: &["dūre", "pacelta dūre", "roka", "sist", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("meke tū"),
            keywords: &["kumu", "meke", "meke tū", "ringa", "tuki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("крената тупаница"),
            keywords: &["бокс", "крената тупаница", "рака", "стегната", "тупаница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഉയർത\u{d4d}തിയ മ\u{d41}ഷ\u{d4d}\u{200c}ടി"),
            keywords: &[
                "ഇടിക\u{d4d}ക\u{d41}ക",
                "ഉയർത\u{d4d}തിയ മ\u{d41}ഷ\u{d4d}\u{200c}ടി",
                "കൈ",
                "നിവർത\u{d4d}തിയ മ\u{d41}ഷ\u{d4d}ടി",
                "മ\u{d41}ഷ\u{d4d}\u{200c}ടി",
                "മ\u{d41}ഷ\u{d4d}\u{200c}ടി ച\u{d41}ര\u{d41}ട\u{d4d}ടി",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зангидсан гар"),
            keywords: &["гар", "зангидах", "зангидсан гар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उ\u{902}चावल\u{947}ली म\u{941}ठ\u{94d}ठी"),
            keywords: &[
                "उ\u{902}चावल\u{947}ली म\u{941}ठ\u{94d}ठी",
                "उ\u{902}चावल\u{947}ली म\u{942}ठ",
                "चिकटल\u{947}ली म\u{942}ठ",
                "प\u{902}च",
                "म\u{942}ठ",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("angkat penumbuk"),
            keywords: &[
                "angkat penumbuk",
                "badan",
                "penumbuk",
                "tangan",
                "tergenggam",
                "tumbuk",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ponn mgħolli"),
            keywords: &["daqqa ta’ ponn", "id", "ponn", "ponn mgħolli", "ħafen"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မြ\u{103e}ောက\u{103a}ပြထားသည\u{1037}\u{103a} လက\u{103a}သ\u{102e}း"),
            keywords: &[
                "မြ\u{103e}ောက\u{103a}ပြထားသည\u{1037}\u{103a} လက\u{103a}သ\u{102e}း",
                "လက\u{103a}",
                "လက\u{103a}သ\u{102e}းဆ\u{102f}ပ\u{103a}",
                "လက\u{103a}သ\u{102e}းဆ\u{102f}ပ\u{103a} မြ\u{103e}ောက\u{103a}ပြနေသည\u{1037}\u{103a}ဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hevet knyttneve"),
            keywords: &["hevet knyttneve", "hånd", "knyttet neve", "neve"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("उठाइएको म\u{941}ठ\u{94d}ठी"),
            keywords: &[
                "उठाइएको म\u{941}ठ\u{94d}ठी",
                "क\u{94d}ल\u{947}न\u{94d}च गरिएको",
                "म\u{941}क\u{94d}का",
                "म\u{941}ठ\u{94d}ठी",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("opgeheven vuist"),
            keywords: &["gebald", "hand", "opgeheven vuist", "stoot", "vuist"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("heva knyttneve"),
            keywords: &["hand", "heva knyttneve", "knytta neve", "neve"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଉଠ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}"),
            keywords: &[
                "ଉଠ\u{b3e} ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
                "ଉଠ\u{b3e}ଯ\u{b3e}ଇଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
                "ଦ\u{b43}ଢ ଭ\u{b3e}ବରେ ଧର\u{b3f}ବ\u{b3e}",
                "ମ\u{b41}ଠ\u{b3e}",
                "ମ\u{b41}ଥ ମ\u{b3e}ର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਚ\u{a41}\u{a71}\u{a71}ਕੀ ਹ\u{a4b}ਈ ਮ\u{a41}\u{a71}ਠੀ"),
            keywords: &[
                "ਉ\u{a71}ਠੀ ਮ\u{a41}\u{a71}ਠੀ",
                "ਚਟਾਨ",
                "ਚ\u{a41}\u{a71}\u{a71}ਕੀ ਹ\u{a4b}ਈ ਮ\u{a41}\u{a71}ਠੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("ابھاری ہوئی م\u{64f}ٹھی"),
            keywords: &[
                "ابھاری ہوئی م\u{64f}ٹھی",
                "م\u{64f}کا مارنا",
                "مٹھی",
                "کسیا ہوئیا",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Réz Klózd Hand Ọp"),
            keywords: &[
                "Blo",
                "Hand",
                "Klozd",
                "Klózd Hand",
                "Prẹ\u{301}s Taít Tait",
                "Réz Klózd Hand Ọp",
                "Skwíz Taít Tait",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("wzniesiona pięść"),
            keywords: &["pięść", "uniesiona", "wzniesiona pięść", "zaciśnięta"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("موټۍ پورته نیول"),
            keywords: &["سوک", "لاس", "موټي", "موټۍ پورته نیول"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("punho levantado"),
            keywords: &["punho erguido", "punho levantado"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("punho erguido"),
            keywords: &[
                "cerrado",
                "corpo",
                "mão",
                "punho",
                "punho erguido",
                "punho levantado",
                "soco",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("juqharisqa saqma"),
            keywords: &["ch’uqmi", "juqharisqa saqma", "maki", "pipuyasqa", "saqma"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pumn ridicat"),
            keywords: &[
                "lovitură",
                "mână",
                "pumn",
                "pumn ridicat",
                "strâns",
                "încleștat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-125"),
            keywords: &["E10-125"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("поднятый кулак"),
            keywords: &["кулак", "пальцы", "поднятый кулак", "рука", "удар"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igipfunsi kizamuye"),
            keywords: &[
                "cyakanzwe",
                "igipfunsi",
                "igipfunsi kizamuye",
                "ikiganza",
                "ingumi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مٿي ڪيل مٺي"),
            keywords: &["م\u{64f}ٺ", "مٿي ڪيل مٺي", "هٿ", "ٺونشو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("එසව\u{dd6} ම\u{dd2}ට මෙළව\u{dd3}ම"),
            keywords: &[
                "අත",
                "එසව\u{dd6} ම\u{dd2}ට මෙළව\u{dd3}ම",
                "ම\u{dd2}ට මෙළව\u{dd3}ම",
                "ම\u{dd2}ට මෙළව\u{dd6}",
                "ම\u{dd2}ට\u{dd2}න\u{dca} පහර ද\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zdvihnutá päsť"),
            keywords: &["päsť", "ruka", "zdvihnutá päsť", "zovretá", "úder"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("dvignjena pest"),
            keywords: &[
                "dlan",
                "dvignjena pest",
                "pest",
                "pokrčeno",
                "telo",
                "udarec",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("kor u qaadid tantoonyo (feer)"),
            keywords: &[
                "feer tuur",
                "gacan",
                "kor u qaadid tantoonyo",
                "kor u qaadid tantoonyo (feer)",
                "tantoonyo",
                "xannibay",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grusht i ngritur"),
            keywords: &[
                "dorë",
                "grusht",
                "grusht i ngritur",
                "grushtoj",
                "i mbledhur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("песница"),
            keywords: &["песница", "рукa", "стиснутo", "тело", "удaрaц", "шaкa"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["песница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pesnica"),
            keywords: &["pesnica", "ruka", "stisnuto", "telo", "udarac", "šaka"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["pesnica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("knytnäve i luften"),
            keywords: &["hand", "knytnäve", "knytnäve i luften"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngumi iliyoinuliwa"),
            keywords: &[
                "konde",
                "kunja ngumi",
                "mkono",
                "mwili",
                "ngumi",
                "ngumi iliyoinuliwa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கைவிரலை மடக\u{bcd}குதல\u{bcd}"),
            keywords: &[
                "அடைய\u{bbe}ளம\u{bcd}",
                "கைவிரலை மடக\u{bcd}குதல\u{bcd}",
                "சைகை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f}"),
            keywords: &["ఐక\u{c4d}యత", "ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мушти бардошта"),
            keywords: &[
                "даст",
                "мушт",
                "мушт задан",
                "мушти бардошта",
                "фушурдашуда",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กำม\u{e37}อ"),
            keywords: &["กำม\u{e37}อ", "ค\u{e49}อน", "หม\u{e31}ด", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("galdyrylan ýumruk"),
            keywords: &[
                "düwülen",
                "el",
                "galdyrylan ýumruk",
                "ýumruk",
                "ýumruklamak",
            ],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuke hiki ki ʻolunga"),
            keywords: &["tuke hiki ki ʻolunga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yumruk kaldırma"),
            keywords: &["havada yumruk", "yumruk kaldırma"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆتۈرگەن مۇشت"),
            keywords: &["تۈگكەن", "تەستەك", "قول", "كۆتۈرگەن مۇشت", "مۇشت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("піднятий кулак"),
            keywords: &["кулак", "піднятий кулак", "рука", "стиснутий", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بلند م\u{64f}ٹھی"),
            keywords: &["بلند م\u{64f}ٹھی", "جسم", "مٹھی", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘tarilgan musht"),
            keywords: &["ko‘tarilgan musht", "musht", "qo‘l", "tana", "tugilgan"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nắm đấm giơ lên"),
            keywords: &["cú đấm", "nắm tay", "nắm đấm giơ lên", "siết chặt", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kurfañ bu jog"),
            keywords: &["dóor", "kurfañ", "kurfañ bu jog", "loxo", "ŋëb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqindi elinyusiweyo"),
            keywords: &["fumbatha", "inqindi", "inqindi elinyusiweyo", "isandla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Naṣẹ Soke"),
            keywords: &[
                "Naṣẹ Soke",
                "fún ọwọ\u{301} pọ\u{300}",
                "ìṣẹ\u{301}",
                "òwọ\u{301} ẹ\u{300}ṣẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("舉起拳頭"),
            keywords: &["手", "打", "拳頭", "握緊", "舉起拳頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("举起拳头"),
            keywords: &["举起拳头", "手", "打", "拳头", "握紧"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("举起拳头"),
            keywords: &["举起拳头", "手", "拳头", "握拳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("拳頭"),
            keywords: &["拳頭", "握拳"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqupha elimisiwe"),
            keywords: &[
                "iqupha",
                "iqupha elimisiwe",
                "isandla",
                "ukufumbatha isibhakela",
                "umzimba",
            ],
        },
    ],
};
#[doc = "✊🏻"]
pub const RAISED_FIST_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✊🏻",
    codepoint: "270A 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised fist: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✊🏼"]
pub const RAISED_FIST_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✊🏼",
    codepoint: "270A 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised fist: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✊🏽"]
pub const RAISED_FIST_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✊🏽",
    codepoint: "270A 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised fist: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✊🏾"]
pub const RAISED_FIST_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✊🏾",
    codepoint: "270A 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised fist: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "✊🏿"]
pub const RAISED_FIST_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "✊🏿",
    codepoint: "270A 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "raised fist: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👊"]
pub const ONCOMING_FIST: crate::Emoji = crate::Emoji {
    glyph: "👊",
    codepoint: "1F44A",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "oncoming fist",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vuishou"),
            keywords: &["gebal", "hand", "liggaam", "slaan", "vuis", "vuishou"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የተሰነዘረ ጡጫ"),
            keywords: &["ቡጢ", "እጅ", "የተሰነዘረ ጡጫ", "የተጨበጠ", "ጡጫ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبضة يد"),
            keywords: &["قبضة يد", "كف", "يد"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("আসন\u{9cd}ন ম\u{9c1}ষ\u{9cd}টি"),
            keywords: &[
                "আসন\u{9cd}ন ম\u{9c1}ষ\u{9cd}টি",
                "ভ\u{9c1}ক\u{9c1}",
                "ম\u{9c1}ষ\u{9cd}টি",
                "ম\u{9c1}ষ\u{9cd}টিবদ\u{9cd}ধ",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("yaxınlaşan yumruq"),
            keywords: &[
                "orqan",
                "sıxılmış",
                "yaxınlaşan yumruq",
                "yumruq",
                "yumruqlamaq",
                "əl",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ляціць кулак"),
            keywords: &["кулак", "ляціць кулак", "небяспека", "рука", "удар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("юмрук"),
            keywords: &["ръка", "стиснат", "тяло", "удар", "юмрук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ঘ\u{9c1}\u{981}সি"),
            keywords: &[
                "কিল",
                "ঘ\u{9c1}\u{981}সি",
                "ম\u{9c1}ষ\u{9cd}ট\u{9be}ঘ\u{9be}ত",
                "ম\u{9c1}ষ\u{9cd}টিবদ\u{9cd}ধ",
                "শরীর",
                "হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nabacivanje pesnicom"),
            keywords: &["nabacivanje pesnicom", "pesnica", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cop de puny"),
            keywords: &["a prop", "cop", "cop de puny", "mà", "puny"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏂᏓᏳᏍᏗᏛ ᎠᎵᏇᏅ"),
            keywords: &["ᎤᏂᏴᎲᎢ", "ᎤᏬᏱ", "ᏂᏓᏳᏍᏗᏛ ᎠᎵᏇᏅ", "ᏍᏈᎾ", "ᏍᏈᎾ ᎬᏗ ᎠᎬᏂᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("namířená pěst"),
            keywords: &["namířená pěst", "pěst", "ruka", "tělo", "zaťatá", "úder"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwrn yn agosáu"),
            keywords: &["cau", "corff", "dwrn", "dwrn yn agosáu", "llaw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("knytnæve"),
            keywords: &["hånd", "knytnæve", "knyttet hånd"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("geballte Faust"),
            keywords: &["Faust", "Hand", "geballte Faust"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γροθιά"),
            keywords: &["γροθιά", "μπουνιά", "σφιγμένο", "χέρι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("oncoming fist"),
            keywords: &["clenched", "fist", "hand", "oncoming fist", "punch"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puño cerrado"),
            keywords: &["puñetazo", "puño", "puño cerrado"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("puño cerrado"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("puño cerrado"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("rusikalöök"),
            keywords: &["keha", "käsi", "löök", "rusikalöök", "rusikas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ukabilkada"),
            keywords: &["eskua", "estutu", "gorputza", "ukabila", "ukabilkada"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("با مشت کوبیدن"),
            keywords: &["با مشت کوبیدن", "بدن", "مشت", "مشت کردن", "کوبیدن", "گره"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kohti tuleva nyrkki"),
            keywords: &[
                "isku",
                "kohti tuleva nyrkki",
                "käsi",
                "nyrkki",
                "puristettu",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pasuntok na kamao"),
            keywords: &["kamao", "kamay", "nakasara", "pasuntok na kamao", "suntok"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("sláandi knýttur nevi"),
            keywords: &["knýttur", "nevi", "sláandi knýttur nevi", "slær"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poing de face"),
            keywords: &["coup de poing", "main", "poing", "poing de face"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["coup de poing", "main", "poing", "poing de face"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dorn atá chugat"),
            keywords: &["dorn", "dorn atá chugat", "lámh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dòrn a’ tighinn thugad"),
            keywords: &["buille", "dòrn", "dòrn a’ tighinn thugad", "dùinte", "làmh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("puñada"),
            keywords: &["golpe", "puñada", "puño"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બ\u{a82}ધ મ\u{ac1}ઠ\u{acd}ઠી"),
            keywords: &["બ\u{a82}ધ મ\u{ac1}ઠ\u{acd}ઠી", "મ\u{ac1}ઠ\u{acd}ઠી", "હાથ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dunƙulen hannu mai zuwa"),
            keywords: &[
                "dunƙulalle",
                "dunƙulen hannu",
                "dunƙulen hannu mai zuwa",
                "hannu",
                "naushi",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מכת אגרוף"),
            keywords: &["אגרוף", "אלימות", "כוח", "מכה", "מכת אגרוף"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("भी\u{902}ची म\u{941}ट\u{94d}ठी"),
            keywords: &[
                "भी\u{902}ची म\u{941}ट\u{94d}ठी",
                "म\u{941}ट\u{94d}ठी",
                "हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stisnuta šaka"),
            keywords: &["ruka", "stisnuta šaka", "stisnuto", "udarac", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("ütésre emelt ököl"),
            keywords: &["felemelt", "test", "ököl", "ütés", "ütésre emelt ököl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("հանդիպակաց բռունցք"),
            keywords: &[
                "բռունցք",
                "հանդիպակաց բռունցք",
                "հարված",
                "ձեռք",
                "մարմին",
                "սեղմված",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tangan terkepal ke depan"),
            keywords: &[
                "badan",
                "kepal",
                "tangan",
                "tangan terkepal ke depan",
                "tinju",
                "tonjok",
                "tubuh",
            ],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ọkpọ na-abịa abịa"),
            keywords: &[
                "aka",
                "aka afụ\u{300}rụ\u{300} afụ\u{300}",
                "aka ọkpọ na-abịa abịa",
                "ịkụ ọkpọ",
                "ọkpọaka",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("krepptur hnefi"),
            keywords: &[
                "hnefi",
                "hönd",
                "krepptur hnefi",
                "kýla",
                "samankrepptur hnefi",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pugno chiuso"),
            keywords: &["mano", "pugno", "pugno chiuso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("グー"),
            keywords: &["げんこつ", "グー", "パンチ", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kepel mara"),
            keywords: &["kepel", "kepel mara", "ngantem", "nggegem", "tangan"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოახლოებული მუშტი"),
            keywords: &[
                "დარტყმა",
                "მოახლოებული მუშტი",
                "მუშტი",
                "სხეული",
                "ტანი",
                "შეკრული",
                "ხელი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жұдырық"),
            keywords: &["дене", "жұдырық", "жұмылған", "соққы"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("knytnæve"),
            keywords: &["hånd", "knytnæve", "knyttet hånd"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កណ\u{17d2}តាប\u{17cb}ដៃមើលច\u{17c6}ព\u{17b8}ម\u{17bb}ខ"),
            keywords: &[
                "កណ\u{17d2}តាប\u{17cb}ដៃមើលច\u{17c6}ព\u{17b8}ម\u{17bb}ខ",
                "ក\u{17d2}ដាប\u{17cb}",
                "ក\u{17d2}តាប\u{17cb}ដៃ",
                "ដាល\u{17cb}",
                "ដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಷ\u{ccd}ಟ\u{cbf}"),
            keywords: &[
                "ಮುಂದ\u{cc6} ಬರುತ\u{ccd}ತ\u{cbf}ರುವ ಮುಷ\u{ccd}ಟ\u{cbf}",
                "ಮುಷ\u{ccd}ಟ\u{cbf}",
                "ಮುಷ\u{ccd}ಟ\u{cbf} ಬ\u{cbf}ಗ\u{cbf}ಹ\u{cbf}ಡ\u{cbf}ಯುವುದು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("주먹 전면"),
            keywords: &["주먹", "주먹 전면", "펀치"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पडपी म\u{942}ठ"),
            keywords: &[
                "आवळिल\u{94d}ली",
                "पडपी म\u{942}ठ",
                "म\u{942}ठ",
                "म\u{942}ठ मारप",
                "हात",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("уруп жаткан муштум"),
            keywords: &["дене", "кол", "муштум", "сокку", "уруп жаткан муштум"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("entgéintkommend Fauscht"),
            keywords: &[
                "Fauscht",
                "Hand",
                "boxen",
                "entgéintkommend Fauscht",
                "zouen",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກຳປ\u{eb1}\u{ec9}ນທ\u{eb5}\u{ec8}ຊ\u{eb1}ດເຂ\u{ebb}\u{ec9}າມາ"),
            keywords: &[
                "ກຳປ\u{eb1}\u{ec9}ນ",
                "ກຳປ\u{eb1}\u{ec9}ນທ\u{eb5}\u{ec8}ຊ\u{eb1}ດເຂ\u{ebb}\u{ec9}າມາ",
                "ມ\u{eb7}",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("artėjantis kumštis"),
            keywords: &[
                "artėjantis kumštis",
                "kumštis",
                "ranka",
                "smūgis",
                "sugniaužtas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pretim vērsta dūre"),
            keywords: &["dūre", "pretim vērsta dūre", "roka", "sist", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("meke anga mai"),
            keywords: &["kumu", "meke", "meke anga mai", "ringa", "tuki"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("тупаница што се приближува"),
            keywords: &[
                "бокс",
                "рака",
                "стегната",
                "тупаница",
                "тупаница што се приближува",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("നേരെ വര\u{d41}ന\u{d4d}ന മ\u{d41}ഷ\u{d4d}\u{200c}ടി"),
            keywords: &[
                "ഇടിക\u{d4d}ക\u{d41}ക",
                "കൈ",
                "നേരെ വര\u{d41}ന\u{d4d}ന മ\u{d41}ഷ\u{d4d}\u{200c}ടി",
                "മ\u{d41}ഷ\u{d4d}\u{200c}ടി ച\u{d41}ര\u{d41}ട\u{d4d}ടി",
                "മ\u{d41}ഷ\u{d4d}\u{200c}\u{200c}ടി",
                "ശരീരം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("цохилт"),
            keywords: &["гар", "мэндчилгээ", "цохилт"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ठोसा मारणारी म\u{941}ठ\u{94d}ठी"),
            keywords: &[
                "चिकटल\u{947}ली म\u{942}ठ",
                "ठोसा मारणारी म\u{941}ठ\u{94d}ठी",
                "ठोसा मारणारी म\u{942}ठ",
                "प\u{902}च",
                "म\u{942}ठ",
                "हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penumbuk dari depan"),
            keywords: &[
                "badan",
                "penumbuk",
                "penumbuk dari depan",
                "tangan",
                "tergenggam",
                "tumbuk",
            ],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ponn dieħel"),
            keywords: &["daqqa ta’ ponn", "id", "ponn", "ponn dieħel", "ħafen"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "ရင\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ရတော\u{1037}မည\u{1037}\u{103a} လက\u{103a}သ\u{102e}း",
            ),
            keywords: &[
                "ရင\u{103a}ဆ\u{102d}\u{102f}င\u{103a}ရတော\u{1037}မည\u{1037}\u{103a} လက\u{103a}သ\u{102e}း",
                "လက\u{103a}",
                "လက\u{103a}သ\u{102e}း",
                "လက\u{103a}သ\u{102e}းဆ\u{102f}ပ\u{103a}",
                "လက\u{103a}သ\u{102e}းထ\u{102d}\u{102f}းဟန\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("knyttneve"),
            keywords: &["hånd", "knyttneve", "neve"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बन\u{94d}न\u{947} म\u{941}ठ\u{94d}ठी"),
            keywords: &[
                "क\u{94d}ल\u{947}न\u{94d}च गरिएको",
                "बन\u{94d}न\u{947} म\u{941}ठ\u{94d}ठी",
                "म\u{941}क\u{94d}का",
                "म\u{941}ठ\u{94d}ठी",
                "हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("stotende vuist"),
            keywords: &["gebald", "hand", "stoot", "stotende vuist", "vuist"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("knyttneve"),
            keywords: &["hand", "knyttneve", "neve"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}"),
            keywords: &[
                "ଦ\u{b43}ଢ ଭ\u{b3e}ବରେ ଧର\u{b3f}ବ\u{b3e}",
                "ମ\u{b41}ଠ\u{b3e}",
                "ମ\u{b41}ଥ ମ\u{b3e}ର\u{b3f}ବ\u{b3e}",
                "ସମ\u{b4d}ମ\u{b41}ଖର\u{b41} ଆସ\u{b41}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
                "ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a41}\u{a71}ਕਾ ਮਾਰਨਾ"),
            keywords: &[
                "ਬ\u{a70}ਦ ਮ\u{a41}\u{a71}ਠੀ",
                "ਮ\u{a41}\u{a71}ਕਾ ਮਾਰਨਾ",
                "ਮ\u{a41}\u{a71}ਠੀ",
                "ਹ\u{a71}ਥ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("آن آلی م\u{64f}ٹھی"),
            keywords: &[
                "آن آلی م\u{64f}ٹھی",
                "م\u{64f}کا مارنا",
                "مٹھی",
                "کسیا ہوئیا",
                "ہتھ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klózd Hand Wán Gív Pẹ\u{301}sin Blo"),
            keywords: &[
                "Hand",
                "Klózd Hand",
                "Klózd Hand Wán Gív Pẹ\u{301}sin Blo",
                "Prẹ\u{301}s Taít Tait",
                "Skwíz Taít Tait",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pięść od przodu"),
            keywords: &[
                "cios pięścią",
                "pięść",
                "pięść od przodu",
                "prawy prosty",
                "sierpowy",
                "zaciśnięta pięść",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مخامخ موټۍ"),
            keywords: &["سوک", "لاس", "مخامخ موټۍ", "موټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("soco"),
            keywords: &["mão", "punho", "soco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("punho a aproximar-se"),
            keywords: &[
                "cerrado",
                "corpo",
                "mão",
                "punho",
                "punho a aproximar-se",
                "punho fechado",
                "soco",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("saqma unancha"),
            keywords: &["ch’uqmi", "juqharisqa saqma", "maki", "saqma unancha"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("lovitură de pumn"),
            keywords: &[
                "lovitură",
                "lovitură de pumn",
                "mână",
                "pumn",
                "strâns",
                "încleștat",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-519"),
            keywords: &["E10-519"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кулак"),
            keywords: &["кулак", "опасность", "рука", "удар", "удар кулаком"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igipfunsi kikureba"),
            keywords: &[
                "cyakanzwe",
                "igipfunsi",
                "igipfunsi kikureba",
                "ikiganza",
                "ingumi",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ايندڙ مڪو"),
            keywords: &["ايندڙ مڪو", "م\u{64f}ٺ", "هٿ", "ٺونشو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඉද\u{dd2}\u{dd2}ර\u{dd2}යට එන ම\u{dd2}ට මෙළව\u{dd3}ම"),
            keywords: &[
                "අත",
                "ඉද\u{dd2}ර\u{dd2}යට එන ම\u{dd2}ට මෙළව\u{dd3}ම",
                "ඉද\u{dd2}\u{dd2}ර\u{dd2}යට එන ම\u{dd2}ට මෙළව\u{dd3}ම",
                "ම\u{dd2}ට මෙළව\u{dd3}ම",
                "ම\u{dd2}ට මෙළව\u{dd6}",
                "ම\u{dd2}ට\u{dd2}න\u{dca} පහර ද\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("päsť spredu"),
            keywords: &["päsť", "päsť spredu", "ruka", "zovretá", "úder"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("bližajoča se pest"),
            keywords: &[
                "bližajoča se pest",
                "dlan",
                "pest",
                "pokrčeno",
                "telo",
                "udarec",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("feer soo socoto"),
            keywords: &[
                "feer soo socoto",
                "feer tuuris",
                "gacan",
                "tantoonyo",
                "tantoonyo soo socota",
                "xanniban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grusht që vjen"),
            keywords: &["dorë", "grusht", "grusht që vjen", "grushtoj", "i mbledhur"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("усмерена песница"),
            keywords: &[
                "рукa",
                "стиснутo",
                "тело",
                "удaрaц",
                "усмерена песница",
                "шaкa",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("усмјерена песница"),
            keywords: &["усмјерена песница"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("usmerena pesnica"),
            keywords: &[
                "ruka",
                "stisnuto",
                "telo",
                "udarac",
                "usmerena pesnica",
                "šaka",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("usmjerena pesnica"),
            keywords: &["usmjerena pesnica"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("knuten hand"),
            keywords: &["knuten hand", "knytnäve"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngumi uliyonyooshewa"),
            keywords: &[
                "konde",
                "kunja ngumi",
                "mkono",
                "mwili",
                "ngumi",
                "ngumi uliyonyooshewa",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("ngumi iliyonyooshewa"),
            keywords: &[
                "konde",
                "kunja ngumi",
                "mkono",
                "mwili",
                "ngumi",
                "ngumi iliyonyooshewa",
            ],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("குத\u{bcd}திவிடுவேன\u{bcd}"),
            keywords: &[
                "குத\u{bcd}திவிடுவேன\u{bcd}",
                "குத\u{bcd}து",
                "குத\u{bcd}து சின\u{bcd}னம\u{bcd}",
                "கை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f} బ\u{c3f}గ\u{c3f}ంచ\u{c3f}న గుర\u{c4d}తు"),
            keywords: &[
                "ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f} గుర\u{c4d}తు",
                "ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f} బ\u{c3f}గ\u{c3f}ంచ\u{c3f}న గుర\u{c4d}తు",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мушти муқобил"),
            keywords: &["даст", "мушт", "мушт задан", "мушти муқобил", "фушурдашуда"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กำป\u{e31}\u{e49}น"),
            keywords: &["กำป\u{e31}\u{e49}น", "ชก", "ม\u{e37}อ", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gelýän ýumruk"),
            keywords: &["düwülen", "el", "gelýän ýumruk", "ýumruk", "ýumruklamak"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuke ki muʻa"),
            keywords: &["tuke ki muʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("yaklaşan yumruk"),
            keywords: &["el", "yaklaşan yumruk", "yumruk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كەلگەن مۇشت"),
            keywords: &["تۈگكەن", "تەستەك", "قول", "كەلگەن مۇشت", "مۇشت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кулак, що насувається"),
            keywords: &[
                "кулак",
                "кулак, що насувається",
                "рука",
                "стиснутий",
                "тіло",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آتا ہوا م\u{64f}کا"),
            keywords: &["آتا ہوا م\u{64f}کا", "جسم", "مکا", "ہاتھ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yaqinlashayotgan musht"),
            keywords: &["musht", "tana", "tugilgan", "yaqinlashayotgan musht"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nắm đấm"),
            keywords: &["cú đấm", "nắm tay", "nắm đấm", "siết chặt", "tay"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kurfañ buy ñëw"),
            keywords: &["dóor", "kurfañ", "kurfañ buy ñëw", "loxo", "ŋëb"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqindi elizayo"),
            keywords: &["fumbatha", "inqindi", "inqindi elizayo", "isandla"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹṣẹ Ti o Nbọ"),
            keywords: &[
                "fún ọwọ\u{301} pọ\u{300}",
                "ìṣẹ\u{301}",
                "òwọ\u{301} ẹ\u{300}ṣẹ\u{301}",
                "Ẹṣẹ Ti o Nbọ",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("迎面而來嘅拳頭"),
            keywords: &["手", "打", "拳頭", "握緊", "迎面而來嘅拳頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("迎面而来嘅拳头"),
            keywords: &["手", "打", "拳头", "握紧", "迎面而来嘅拳头"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("出拳"),
            keywords: &["出拳", "手", "打", "拳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("出拳"),
            keywords: &["出拳", "拳頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("iqupha elizayo"),
            keywords: &[
                "iqupha",
                "iqupha elizayo",
                "isandla",
                "ukufumbatha isibhakela",
                "umzimba",
            ],
        },
    ],
};
#[doc = "👊🏻"]
pub const ONCOMING_FIST_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👊🏻",
    codepoint: "1F44A 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "oncoming fist: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👊🏼"]
pub const ONCOMING_FIST_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👊🏼",
    codepoint: "1F44A 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "oncoming fist: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👊🏽"]
pub const ONCOMING_FIST_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👊🏽",
    codepoint: "1F44A 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "oncoming fist: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👊🏾"]
pub const ONCOMING_FIST_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👊🏾",
    codepoint: "1F44A 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "oncoming fist: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👊🏿"]
pub const ONCOMING_FIST_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👊🏿",
    codepoint: "1F44A 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "oncoming fist: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤛"]
pub const LEFT_FACING_FIST: crate::Emoji = crate::Emoji {
    glyph: "🤛",
    codepoint: "1F91B",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "left-facing fist",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vuis links"),
            keywords: &["linkerkant", "links", "vuis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ግራ የዞረ ቡጢ"),
            keywords: &["ቡጢ", "ወደ ግራ", "ወደ ግራ የዞረ ቡጢ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبضة لليسار"),
            keywords: &["قبضة", "قبضة لليسار", "يسار"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ব\u{9be}ও\u{981}ফ\u{9be}লে-ম\u{9c1}খ কৰ\u{9be} ম\u{9c1}ষ\u{9cd}টি"),
            keywords: &[
                "ব\u{9be}ও\u{981}ফ\u{9be}ল",
                "ব\u{9be}ও\u{981}ফ\u{9be}লে-ম\u{9c1}খ কৰ\u{9be} ম\u{9c1}ষ\u{9cd}টি",
                "ম\u{9c1}ষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sola yönələn yumruq"),
            keywords: &["sol", "sola yönələn yumruq", "yumruq", "zərbə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кулак улева"),
            keywords: &["кулак", "улева"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("обърнат наляво юмрук"),
            keywords: &["наляво", "обърнат наляво юмрук", "юмрук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}\u{981}দিকে ঘ\u{9c1}\u{981}ষি ম\u{9be}র\u{9be}"),
            keywords: &[
                "ঘ\u{9c1}\u{981}ষি",
                "ব\u{9be}\u{981}দিকে",
                "ব\u{9be}\u{981}দিকে ঘ\u{9c1}\u{981}ষি ম\u{9be}র\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šaka ulijevo"),
            keywords: &["ulijevo", "šaka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("puny dret"),
            keywords: &["dret", "puny", "salutació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏍᎦᏂ-ᏍᏈᎾ ᎤᎦᏙᏍᏓ"),
            keywords: &["ᎠᎦᏍᎦᏂ-ᏍᏈᎾ ᎤᎦᏙᏍᏓ", "ᎠᎦᏍᎦᏂᏗᏜ", "ᏍᏈᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pěst mířící doleva"),
            keywords: &["doleva", "pěst", "pěst mířící doleva"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwrn tua’r chwith"),
            keywords: &["dwrn", "dwrn tua’r chwith", "tua’r chwith"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("venstrevendt knytnæve"),
            keywords: &[
                "hånd",
                "hånd knyttet mod venstre",
                "knytnæve",
                "knyttet hånd",
                "venstre",
                "venstrevendt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Faust nach links"),
            keywords: &["Faust", "Faust nach links", "nach links"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γροθιά προς αριστερά"),
            keywords: &[
                "αριστερή γροθιά",
                "γροθιά",
                "γροθιά προς αριστερά",
                "προς αριστερά",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("left-facing fist"),
            keywords: &["fist", "left-facing fist", "leftwards"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["fist", "left-facing fist", "leftward"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puño hacia la izquierda"),
            keywords: &["izquierda", "puño", "puño hacia la izquierda"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("puño a la izquierda"),
            keywords: &["izquierda", "puño", "puño a la izquierda"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("puño hacia la izquierda"),
            keywords: &["izquierda", "puño", "puño hacia la izquierda"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("puño hacia la izquierda"),
            keywords: &["izquierda", "puño", "puño hacia la izquierda"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("vasakule suunatud rusikas"),
            keywords: &["rusikas", "vasakule", "vasakule suunatud rusikas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ukabila ezkerrera begira"),
            keywords: &["ezkerrera", "ukabila", "ukabila ezkerrera begira"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مشت به چپ"),
            keywords: &["به چپ", "مشت", "مشت به چپ", "چپ"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nyrkki vasemmalle"),
            keywords: &["nyrkki", "nyrkki vasemmalle", "vasen"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakaliwang kamao"),
            keywords: &["kamao", "pakaliwa", "pakaliwang kamao"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nevi í vendur til vinstru"),
            keywords: &["knýttur", "nevi", "nevi í vendur til vinstru", "vinstru"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poing à gauche"),
            keywords: &["gauche", "main", "poing", "poing à gauche"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["gauche", "poing", "poing à gauche"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dorn ar chlé"),
            keywords: &["ar chlé", "dorn", "dorn ar chlé"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dòrn ris an taobh chlì"),
            keywords: &["clì", "dòrn", "dòrn ris an taobh chlì"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("puño cara á esquerda"),
            keywords: &["esquerda", "man", "puño", "puño cara á esquerda"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ડાબીબાજ\u{ac1}ની મ\u{ac1}ઠ\u{acd}ઠી"),
            keywords: &[
                "ડાબીબાજ\u{ac1}",
                "ડાબીબાજ\u{ac1}ની મ\u{ac1}ઠ\u{acd}ઠી",
                "મ\u{ac1}ઠ\u{acd}ઠી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dunƙulen hannu mai fuskanta hagu"),
            keywords: &[
                "dunƙulen hannu",
                "dunƙulen hannu mai fuskanta hagu",
                "ta hannun hagu",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד קמוצה שמאלה"),
            keywords: &["אגרוף", "יד קמוצה שמאלה", "שמאלה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाई\u{902} ओर म\u{941}ठ\u{94d}ठी"),
            keywords: &[
                "बाई\u{902} ओर म\u{941}ठ\u{94d}ठी",
                "बाई\u{902} तरफ",
                "म\u{941}क\u{94d}का",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šaka ulijevo"),
            keywords: &["ulijevo", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("balra néző ököl"),
            keywords: &["bal szélső", "balra néző ököl", "ököl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բռունցքը ձախ"),
            keywords: &["բռունցք", "բռունցքը ձախ", "ձախ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tinju kiri"),
            keywords: &["kepalan tangan", "kiri", "tinju kiri", "tonjok"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ọkpọ chewere-akaèkpè"),
            keywords: &["aka ọkpọ", "aka ọkpọ chewere-akaèkpè", "gara akaèkpè"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hægri hnefi"),
            keywords: &["hnefi", "hægri hnefi", "hönd", "krepptur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pugno a sinistra"),
            keywords: &["pugno", "pugno a sinistra", "sinistra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("左向きのこぶし"),
            keywords: &["こぶし", "パンチ", "左", "左向きのこぶし", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kepel katon saka sisih kiwa"),
            keywords: &["kepel", "kepel katon saka sisih kiwa", "sisih kiwa"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მარცხნივ მიმართული მუშტი"),
            keywords: &["მარცხნივ", "მარცხნივ მიმართული მუშტი", "მუშტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сол жақ жұдырық"),
            keywords: &["жұдырық", "сол", "сол жақ жұдырық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("venstrevendt knytnæve"),
            keywords: &[
                "hånd",
                "hånd knyttet mod venstre",
                "knytnæve",
                "knyttet hånd",
                "krop",
                "venstre",
                "venstrevendt",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កណ\u{17d2}តាប\u{17cb}ដៃឆ\u{17d2}វេង"),
            keywords: &[
                "កណ\u{17d2}តាប\u{17cb}ដៃ",
                "កណ\u{17d2}តាប\u{17cb}ដៃឆ\u{17d2}វេង",
                "ខាងឆ\u{17d2}វេង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಎಡ ಮುಷ\u{ccd}ಠ\u{cbf}"),
            keywords: &["ಎಡ ಮುಷ\u{ccd}ಠ\u{cbf}", "ಎಡಭಾಗ", "ಮುಷ\u{ccd}ಠ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왼쪽을 향하는 주먹"),
            keywords: &["왼쪽", "왼쪽을 향하는 주먹", "왼편", "주먹"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दाव\u{94d}यान मारपी म\u{942}ठ"),
            keywords: &[
                "दाव\u{94d}यान",
                "दाव\u{94d}यान मारपी म\u{942}ठ",
                "म\u{942}ठ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("солго караган муштум"),
            keywords: &["муштум", "солго караган", "солго караган муштум"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("lénksgeriicht Fauscht"),
            keywords: &["Fauscht", "lénksgeriicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ecd}າປ\u{eb1}\u{ec9}ນໄປທາງຊ\u{ec9}າຍ"),
            keywords: &[
                "ກ\u{ecd}າປ\u{eb1}\u{ec9}ນໄປທາງຊ\u{ec9}າຍ",
                "ຊ\u{eb5}\u{ec9}ໄປຊ\u{ec9}າຍ",
                "ຊ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("į kairę nukreiptas kumštis"),
            keywords: &["kairėn", "kumštis", "į kairę nukreiptas kumštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dūre pa kreisi"),
            keywords: &["dūre", "dūre pa kreisi", "pa kreisi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("meke anga-mauī"),
            keywords: &["meke", "meke anga-mauī", "whakatemauī"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("лева тупаница"),
            keywords: &["лева тупаница", "налево", "тупаница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള മ\u{d41}ഷ\u{d4d}\u{200c}ടി"),
            keywords: &[
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d41}ള\u{d4d}ള മ\u{d41}ഷ\u{d4d}\u{200c}ടി",
                "ഇടത\u{d4d}തേക\u{d4d}ക\u{d4d}",
                "ച\u{d41}ര\u{d41}ട\u{d4d}ട\u{d41}ക",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүүн харсан зангидсан гар"),
            keywords: &["гар", "зангидсан", "зүүн", "харсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डाव\u{94d}याबाज\u{942}ची म\u{942}ठ"),
            keywords: &[
                "डावीबाज\u{942}",
                "डाव\u{94d}याबाज\u{942}ची म\u{942}ठ",
                "प\u{902}च",
                "म\u{942}ठ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penumbuk ke kiri"),
            keywords: &["ke kiri", "penumbuk", "penumbuk ke kiri"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ponn iħares lejn ix-xellug"),
            keywords: &["l-ewwel", "lejn ix-xellug", "ponn iħares lejn ix-xellug"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဘယ\u{103a}ပြ ညာလက\u{103a}သ\u{102e}း"),
            keywords: &[
                "ဘယ\u{103a}ပြ ညာလက\u{103a}သ\u{102e}း",
                "ဘယ\u{103a}ဝ\u{102d}\u{102f}က\u{103a}",
                "လက\u{103a}သ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("knyttneve mot venstre"),
            keywords: &[
                "hånd",
                "knyttneve mot venstre",
                "neve",
                "venstre",
                "venstrevendt",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("बाया\u{901} फर\u{94d}क\u{947}को म\u{941}ड\u{94d}की"),
            keywords: &[
                "बाया\u{901} फर\u{94d}क\u{947}को म\u{941}ड\u{94d}की",
                "बाया\u{901}तर\u{94d}फ",
                "म\u{941}ड\u{94d}की",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naar links gerichte vuist"),
            keywords: &["linksom", "naar links gerichte vuist", "vuist"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("knyttneve mot venstre"),
            keywords: &[
                "hand",
                "knyttneve mot venstre",
                "neve",
                "venstre",
                "venstrehendt",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ବ\u{b3e}ମ-ଆଡ\u{b3c}କ\u{b41} ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
            ),
            keywords: &[
                "ବ\u{b3e}ମ ଆଡ\u{b3c}କ\u{b41}",
                "ବ\u{b3e}ମ-ଆଡ\u{b3c}କ\u{b41} ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
                "ମ\u{b41}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਖ\u{a71}ਬ\u{a47} ਵ\u{a71}ਲ ਨ\u{a42}\u{a70} ਮ\u{a41}\u{a71}ਠੀ"),
            keywords: &[
                "ਖ\u{a71}ਬ\u{a47} ਪਾਸ\u{a47}",
                "ਖ\u{a71}ਬ\u{a47} ਵ\u{a71}ਲ ਨ\u{a42}\u{a70} ਮ\u{a41}\u{a71}ਠੀ",
                "ਮ\u{a41}\u{a71}ਠੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کھبے پاسے سامنا کردی م\u{64f}ٹھی"),
            keywords: &["مٹھی", "کھبے پاسے", "کھبے پاسے سامنا کردی م\u{64f}ٹھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klós Hand Wé De Fés Lẹft"),
            keywords: &[
                "Klós Hand Wé De Fés Lẹft",
                "Klózd Hand",
                "Klózd Hand Wé De Fés Lẹft",
                "Lẹ\u{301}ft Said",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pięść skierowana w lewo"),
            keywords: &[
                "cios",
                "pięść",
                "pięść skierowana w lewo",
                "uderzenie z prawej",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("چپ موټۍ"),
            keywords: &["موټۍ", "چپ خوا", "چپ موټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("punho esquerdo"),
            keywords: &["esquerdo", "punho", "soco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("punho voltado para a esquerda"),
            keywords: &["esquerda", "punho", "punho voltado para a esquerda"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("lluqʼi saqma"),
            keywords: &["lluqʼi saqma", "lluq’iman", "saqma"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pumn spre stânga"),
            keywords: &["pumn", "pumn spre stânga", "spre stânga"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1021"),
            keywords: &["E10-1021"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кулак влево"),
            keywords: &["влево", "кулак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igipfunsi kireba ibumoso"),
            keywords: &["igipfunsi", "igipfunsi kireba ibumoso", "kireba ibumoso"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("کاٻي طرف منهن ڪندڙ مٺي"),
            keywords: &["مٺي", "کاٻي طرف منهن ڪندڙ مٺي", "کاٻي پاسي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}ට මොළ ව\u{dd6} වම"),
            keywords: &[
                "ම\u{dd2}ට මොළ ව\u{dd3}ම",
                "ම\u{dd2}ට මොළ ව\u{dd6} වම",
                "වමට",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("päsť doľava"),
            keywords: &["doľava", "päsť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pest, obrnjena levo"),
            keywords: &["levo", "pest", "pest, obrnjena levo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("feerka tilmaamaysa bidix"),
            keywords: &[
                "dhanka bidix",
                "feerka",
                "feerka tilmaamaya bidix",
                "feerka tilmaamaysa bidix",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grusht i majtë në anën e përparme"),
            keywords: &["grusht", "grusht i majtë në anën e përparme", "i majtë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("песница улево"),
            keywords: &["песница", "улево"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("песница улијево"),
            keywords: &["песница улијево"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pesnica ulevo"),
            keywords: &["pesnica", "ulevo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("pesnica ulijevo"),
            keywords: &["pesnica ulijevo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("vänstervänd näve"),
            keywords: &["näve", "vänster", "vänstervänd"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngumi ya kulia"),
            keywords: &["ngumi ya kulia"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலதுகைய\u{bbe}ல\u{bcd} ஒரு குத\u{bcd}து"),
            keywords: &[
                "இடப\u{bcd}பக\u{bcd}கம\u{bcd}",
                "குத\u{bcd}து",
                "கை",
                "வலதுகைய\u{bbe}ல\u{bcd} ஒரு குத\u{bcd}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎడమవ\u{c48}పు ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f}"),
            keywords: &["ఎడమవ\u{c48}పు", "ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мушт аз тарафи чап"),
            keywords: &["ба тарафи чап", "мушт", "мушт аз тарафи чап"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กำป\u{e31}\u{e49}นขวา"),
            keywords: &["กำป\u{e31}\u{e49}น", "กำป\u{e31}\u{e49}นขวา", "ขวา"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("çepe ýumruk"),
            keywords: &["çepe", "ýumruk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuke ki hema"),
            keywords: &["tuke ki hema"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sola bakan yumruk"),
            keywords: &["sola bakan yumruk", "sola doğru", "yumruk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("سول مۇشت"),
            keywords: &["سول مۇشت", "سولغا", "مۇشت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кулак уліво"),
            keywords: &["кулак", "уліво"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بائیں سمت میں مکا"),
            keywords: &["بائیں سمت", "بائیں سمت میں مکا", "مکا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("chapga qaragan musht"),
            keywords: &["chap", "chapga qaragan musht", "musht"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nắm đấm hướng phía trái"),
            keywords: &["hướng trái", "nắm đấm", "nắm đấm hướng phía trái"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kurfañu càmmoñ"),
            keywords: &["jëm càmmoñ", "kurfañ", "kurfañu càmmoñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqindi elijonge ekhohlo"),
            keywords: &["ekhohlo", "inqindi", "inqindi elijonge ekhohlo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹsẹ ti O Kọju sosi"),
            keywords: &["apá ọ\u{300}sì", "Ẹsẹ ti O Kọju sosi", "ẹ\u{300}ṣẹ\u{301}"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向左嘅拳頭"),
            keywords: &["向左", "向左嘅拳頭", "拳頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向左嘅拳头"),
            keywords: &["向左", "向左嘅拳头", "拳头"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("朝左的拳头"),
            keywords: &["拳头", "朝左", "朝左的拳头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("握右拳"),
            keywords: &["右", "拳", "握", "握右拳"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("拳頭向左"),
            keywords: &["拳頭", "拳頭向左", "擊拳", "重擊"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inqindi ebheke kwesokunxele"),
            keywords: &["inqindi", "inqindi ebheke kwesokunxele", "kwesokunxele"],
        },
    ],
};
#[doc = "🤛🏻"]
pub const LEFT_FACING_FIST_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤛🏻",
    codepoint: "1F91B 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "left-facing fist: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤛🏼"]
pub const LEFT_FACING_FIST_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤛🏼",
    codepoint: "1F91B 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "left-facing fist: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤛🏽"]
pub const LEFT_FACING_FIST_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤛🏽",
    codepoint: "1F91B 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "left-facing fist: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤛🏾"]
pub const LEFT_FACING_FIST_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤛🏾",
    codepoint: "1F91B 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "left-facing fist: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤛🏿"]
pub const LEFT_FACING_FIST_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤛🏿",
    codepoint: "1F91B 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "left-facing fist: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤜"]
pub const RIGHT_FACING_FIST: crate::Emoji = crate::Emoji {
    glyph: "🤜",
    codepoint: "1F91C",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "right-facing fist",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vuis regs"),
            keywords: &["regs", "regterkant", "vuis"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ወደ ቀኝ የዞረ ቡጢ"),
            keywords: &["ቡጢ", "ወደ ቀኝ", "ወደ ቀኝ የዞረ ቡጢ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قبضة لليمين"),
            keywords: &["قبضة", "قبضة لليمين", "يمين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("সো\u{981}ফ\u{9be}লে-ম\u{9c1}খ কৰ\u{9be} ম\u{9c1}ষ\u{9cd}টি"),
            keywords: &[
                "ম\u{9c1}ষ\u{9cd}টি",
                "সো\u{981}ফ\u{9be}ল",
                "সো\u{981}ফ\u{9be}লে-ম\u{9c1}খ কৰ\u{9be} ম\u{9c1}ষ\u{9cd}টি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sağa yönələn yumruq"),
            keywords: &["sağ", "sağa yönələn yumruq", "yumruq", "zərbə"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("кулак управа"),
            keywords: &["кулак", "управа"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("обърнат надясно юмрук"),
            keywords: &["надясно", "обърнат надясно юмрук", "юмрук"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ড\u{9be}নদিকে ঘ\u{981}ষি ম\u{9be}র\u{9be}"),
            keywords: &[
                "ঘ\u{9c1}\u{981}ষি",
                "ড\u{9be}নদিকে",
                "ড\u{9be}নদিকে ঘ\u{981}ষি ম\u{9be}র\u{9be}",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("šaka udesno"),
            keywords: &["udesno", "šaka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("puny esquerre"),
            keywords: &["esquerre", "puny", "salutació"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘᏏ-ᏩᎦᏘᎲ ᎠᎵᏇᏅ"),
            keywords: &["ᎠᎦᏘᏏ-ᏩᎦᏘᎲ ᎠᎵᏇᏅ", "ᎠᎦᏘᏏᏗᏜ", "ᏍᏈᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("pěst mířící doprava"),
            keywords: &["doprava", "pěst", "pěst mířící doprava"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dwrn tua’r dde"),
            keywords: &["dwrn", "dwrn tua’r dde", "tua’r dde"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("højrevendt knytnæve"),
            keywords: &[
                "hånd",
                "hånd knyttet mod højre",
                "højre",
                "højrevendt",
                "knytnæve",
                "knyttet hånd",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Faust nach rechts"),
            keywords: &["Faust", "Faust nach rechts", "nach rechts"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γροθιά προς δεξιά"),
            keywords: &["γροθιά", "γροθιά προς δεξιά", "δεξιά γροθιά", "προς δεξιά"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("right-facing fist"),
            keywords: &["fist", "right-facing fist", "rightwards"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["fist", "right-facing fist", "rightward"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("puño hacia la derecha"),
            keywords: &["derecha", "puño", "puño hacia la derecha"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("puño a la derecha"),
            keywords: &["derecha", "puño", "puño a la derecha"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("puño hacia la derecha"),
            keywords: &["derecha", "puño", "puño hacia la derecha"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("puño hacia la derecha"),
            keywords: &["derecha", "puño", "puño hacia la derecha"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("paremale suunatud rusikas"),
            keywords: &["paremale", "paremale suunatud rusikas", "rusikas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("ukabila eskuinera begira"),
            keywords: &["eskuinera", "ukabila", "ukabila eskuinera begira"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مشت به راست"),
            keywords: &["به راست", "راست", "مشت", "مشت به راست"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nyrkki oikealle"),
            keywords: &["nyrkki", "nyrkki oikealle", "oikea"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pakanang kamao"),
            keywords: &["kamao", "pakanan", "pakanang kamao"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nevi í vendur til høgru"),
            keywords: &["høgru", "knýttur", "nevi", "nevi í vendur til høgru"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poing à droite"),
            keywords: &["droite", "main", "poing", "poing à droite"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["droite", "poing", "poing à droite"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("dorn ar dheis"),
            keywords: &["ar dheis", "dorn", "dorn ar dheis"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("dòrn ris an taobh deas"),
            keywords: &["deas", "dòrn", "dòrn ris an taobh deas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("puño cara á dereita"),
            keywords: &["dereita", "man", "puño", "puño cara á dereita"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જમણીબાજ\u{ac1}ની મ\u{ac1}ઠ\u{acd}ઠી"),
            keywords: &[
                "જમણીબાજ\u{ac1}",
                "જમણીબાજ\u{ac1}ની મ\u{ac1}ઠ\u{acd}ઠી",
                "મ\u{ac1}ઠ\u{acd}ઠી",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("dunƙulen hannu mai fuskanta dama"),
            keywords: &[
                "dunƙulen hannu",
                "dunƙulen hannu mai fuskanta dama",
                "ta hannun dama",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד קמוצה ימינה"),
            keywords: &["אגרוף", "יד קמוצה ימינה", "ימינה"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दाई\u{902} ओर म\u{941}ठ\u{94d}ठी"),
            keywords: &[
                "दाई\u{902} ओर म\u{941}ठ\u{94d}ठी",
                "दाई\u{902} तरफ",
                "म\u{941}क\u{94d}का",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("šaka udesno"),
            keywords: &["udesno", "šaka"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("jobbra néző ököl"),
            keywords: &["jobb szélső", "jobbra néző ököl", "ököl"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բռունցքը աջ"),
            keywords: &["աջ", "բռունցք", "բռունցքը աջ"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tinju kanan"),
            keywords: &["kanan", "kepalan tangan", "tinju kanan", "tonjok"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("aka ọkpọ chewere-akanri"),
            keywords: &["aka ọkpọ", "aka ọkpọ chewere-akanri", "gara akanri"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vinstri hnefi"),
            keywords: &["hnefi", "hönd", "krepptur", "vinstri hnefi"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("pugno a destra"),
            keywords: &["destra", "pugno", "pugno a destra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("右向きのこぶし"),
            keywords: &["こぶし", "パンチ", "右", "右向きのこぶし", "手"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kepel katon saka sisih tengen"),
            keywords: &["kepel", "kepel katon saka sisih tengen", "sisih tengen"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მარჯვნივ მიმართული მუშტი"),
            keywords: &["მარჯვნივ", "მარჯვნივ მიმართული მუშტი", "მუშტი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("оң жақ жұдырық"),
            keywords: &["жұдырық", "оң", "оң жақ жұдырық"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("højrevendt knytnæve"),
            keywords: &[
                "hånd",
                "hånd knyttet mod højre",
                "højre",
                "højrevendt",
                "knytnæve",
                "knyttet hånd",
                "krop",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កណ\u{17d2}តាប\u{17cb}ដៃស\u{17d2}តា\u{17c6}"),
            keywords: &[
                "កណ\u{17d2}តាប\u{17cb}ដៃ",
                "កណ\u{17d2}តាប\u{17cb}ដៃស\u{17d2}តា\u{17c6}",
                "ខាងស\u{17d2}តា\u{17c6}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಲ ಮುಷ\u{ccd}ಠ\u{cbf}"),
            keywords: &["ಬಲ ಮುಷ\u{ccd}ಠ\u{cbf}", "ಬಲಭಾಗ", "ಮುಷ\u{ccd}ಠ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("오른쪽을 향하는 주먹"),
            keywords: &["오른쪽", "오른쪽을 향하는 주먹", "오른편", "주먹"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("उजव\u{94d}यान मारपी म\u{942}ठ"),
            keywords: &[
                "उजव\u{94d}यान",
                "उजव\u{94d}यान मारपी म\u{942}ठ",
                "म\u{942}ठ",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("оңго караган муштум"),
            keywords: &["муштум", "оңго караган", "оңго караган муштум"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("rietsgeriicht Fauscht"),
            keywords: &["Fauscht", "rietsgeriicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກ\u{ecd}າປ\u{eb1}\u{ec9}ນໄປທາງຂວາ"),
            keywords: &[
                "ກ\u{ecd}າປ\u{eb1}\u{ec9}ນໄປທາງຂວາ",
                "ຊ\u{eb5}\u{ec9}ໄປຂວາ",
                "ຊ\u{ec9}າຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("į dešinę nukreiptas kumštis"),
            keywords: &["dešinėn", "kumštis", "į dešinę nukreiptas kumštis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("dūre pa labi"),
            keywords: &["dūre", "dūre pa labi", "pa labi"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("meke anga-matau"),
            keywords: &["meke", "meke anga-matau", "whakatematau"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("десна тупаница"),
            keywords: &["десна тупаница", "надесно", "тупаница"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വലത\u{d4d}തോട\u{d4d}ട\u{d4d} ച\u{d41}ര\u{d41}ട\u{d4d}ടിയ കൈ"),
            keywords: &[
                "ച\u{d41}ര\u{d41}ട\u{d4d}ട\u{d41}ക",
                "വലത\u{d4d}തേക\u{d4d}ക\u{d4d}",
                "വലത\u{d4d}തോട\u{d4d}ട\u{d4d} ച\u{d41}ര\u{d41}ട\u{d4d}ടിയ കൈ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("баруун харсан зангидсан гар"),
            keywords: &["баруун", "гар", "зангидсан", "харсан"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("उजव\u{94d}याबाज\u{942}ची म\u{942}ठ"),
            keywords: &[
                "उजवीबाज\u{942}",
                "उजव\u{94d}याबाज\u{942}ची म\u{942}ठ",
                "म\u{942}ठ",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("penumbuk ke kanan"),
            keywords: &["ke kanan", "penumbuk", "penumbuk ke kanan"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ponn iħares lemin"),
            keywords: &["l-ewwel", "lejn il-lemin", "ponn iħares lemin"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ညာပြ ဘယ\u{103a}လက\u{103a}သ\u{102e}း"),
            keywords: &[
                "ညာပြ ဘယ\u{103a}လက\u{103a}သ\u{102e}း",
                "ညာဝ\u{102d}\u{102f}က\u{103a}",
                "လက\u{103a}သ\u{102e}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("knyttneve mot høyre"),
            keywords: &["hånd", "høyre", "høyrevendt", "knyttneve mot høyre", "neve"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दाया\u{901} फर\u{94d}क\u{947}को म\u{941}ड\u{94d}की"),
            keywords: &[
                "दाया\u{901} फर\u{94d}क\u{947}को म\u{941}ड\u{94d}की",
                "दाया\u{901}तर\u{94d}फ",
                "म\u{941}\u{941}ड\u{94d}की",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("naar rechts gerichte vuist"),
            keywords: &["naar rechts gerichte vuist", "rechtsom", "vuist"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("knyttneve mot høgre"),
            keywords: &["hand", "høgre", "høgrehendt", "knyttneve mot høgre", "neve"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ଡ\u{b3e}ହ\u{b3e}ଣ-ଆଡ\u{b3c}କ\u{b41} ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
            ),
            keywords: &[
                "ଡ\u{b3e}ହ\u{b3e}ଣ ଆଡ\u{b3c}କ\u{b41}",
                "ଡ\u{b3e}ହ\u{b3e}ଣ-ଆଡ\u{b3c}କ\u{b41} ମ\u{b41}ହ\u{b01} କର\u{b3f}ଥ\u{b3f}ବ\u{b3e} ମ\u{b41}ଠ\u{b3e}",
                "ମ\u{b41}ଠ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a71}ਜ\u{a47} ਵ\u{a71}ਲ ਨ\u{a42}\u{a70} ਮ\u{a41}\u{a71}ਠੀ"),
            keywords: &[
                "ਮ\u{a41}\u{a71}ਠੀ",
                "ਸ\u{a71}ਜ\u{a47} ਪਾਸ\u{a47}",
                "ਸ\u{a71}ਜ\u{a47} ਵ\u{a71}ਲ ਨ\u{a42}\u{a70} ਮ\u{a41}\u{a71}ਠੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("سجے پاسے سامنا کردی مٹھی"),
            keywords: &["سجے پاسے", "سجے پاسے سامنا کردی مٹھی", "مٹھی"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Klós Hand Wé De Fés Rait"),
            keywords: &[
                "Klós Hand Wé De Fés Rait",
                "Klózd Hand",
                "Klózd Hand Wé De Fés Rait",
                "Raít Said",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("pięść skierowana w prawo"),
            keywords: &[
                "cios",
                "pięść",
                "pięść skierowana w prawo",
                "uderzenie z lewej",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ښۍ موټۍ"),
            keywords: &["موټۍ", "ښۍ خوا", "ښۍ موټۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("punho direito"),
            keywords: &["direito", "punho", "soco"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("punho voltado para a direita"),
            keywords: &["direita", "punho", "punho voltado para a direita"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("paña saqma"),
            keywords: &["paña saqma", "pañaman", "saqma"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("pumn spre dreapta"),
            keywords: &["pumn", "pumn spre dreapta", "spre dreapta"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1022"),
            keywords: &["E10-1022"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кулак вправо"),
            keywords: &["вправо", "кулак"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("igipfunsi kireba iburyo"),
            keywords: &["igipfunsi", "igipfunsi kireba iburyo", "kireba iburyo"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ساڄي طرف منهن ڪندڙ مٺي"),
            keywords: &["ساڄي طرف منهن ڪندڙ مٺي", "ساڄي پاسي", "مٺي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ම\u{dd2}ට මොළ ව\u{dd6} දක\u{dd4}ණ"),
            keywords: &[
                "දක\u{dd4}ණට",
                "ම\u{dd2}ට මොළ ව\u{dd3}ම",
                "ම\u{dd2}ට මොළ ව\u{dd6} දක\u{dd4}ණ",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("päsť doprava"),
            keywords: &["doprava", "päsť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pest, obrnjena desno"),
            keywords: &["desno", "pest", "pest, obrnjena desno"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("feerka tilmaamaya midig"),
            keywords: &["dhanka midig", "feerka", "feerka tilmaamaya midig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("grusht i djathtë në anën e përparme"),
            keywords: &["grusht", "grusht i djathtë në anën e përparme", "i djathtë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("песница удесно"),
            keywords: &["песница", "удесно"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pesnica udesno"),
            keywords: &["pesnica", "udesno"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("högervänd näve"),
            keywords: &["höger", "högervänd", "näve"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ngumi ya kushoto"),
            keywords: &["ngumi ya kushoto"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இடதுகைய\u{bbe}ல\u{bcd} ஒரு குத\u{bcd}து"),
            keywords: &[
                "இடதுகைய\u{bbe}ல\u{bcd} ஒரு குத\u{bcd}து",
                "குத\u{bcd}து",
                "கை",
                "வலப\u{bcd}பக\u{bcd}கம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కుడ\u{c3f}వ\u{c48}పు ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f}"),
            keywords: &["కుడ\u{c3f}వ\u{c48}పు", "ప\u{c3f}డ\u{c3f}క\u{c3f}ల\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мушти тарафи рост"),
            keywords: &["ба тарафи рост", "мушт", "мушти тарафи рост"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กำป\u{e31}\u{e49}นซ\u{e49}าย"),
            keywords: &[
                "กำป\u{e31}\u{e49}น",
                "กำป\u{e31}\u{e49}นซ\u{e49}าย",
                "ซ\u{e49}าย",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("saga ýumruk"),
            keywords: &["saga", "ýumruk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("tuke ki mataʻu"),
            keywords: &["tuke ki mataʻu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("sağa bakan yumruk"),
            keywords: &["sağa bakan yumruk", "sağa doğru", "yumruk"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئوڭ مۇشت"),
            keywords: &["ئوڭ مۇشت", "ئوڭغا", "مۇشت"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кулак управо"),
            keywords: &["кулак", "управо"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دائیں سمت میں مکا"),
            keywords: &["دائیں سمت", "دائیں سمت میں مکا", "مکا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("o‘ngga qaragan musht"),
            keywords: &["musht", "o‘ng", "o‘ngga qaragan musht"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("nắm đấm hướng sang phải"),
            keywords: &["hướng phải", "nắm đấm", "nắm đấm hướng sang phải"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("kurfañu ndijoor"),
            keywords: &["jëm ndijoor", "kurfañ", "kurfañu ndijoor"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("inqindi elijonge ekunene"),
            keywords: &["ekunene", "inqindi", "inqindi elijonge ekunene"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹsẹ ti O Kọju sọtun"),
            keywords: &[
                "apá ọ\u{300}tún",
                "Ẹsẹ ti O Kọju sọtun",
                "ẹ\u{300}ṣẹ\u{301}",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("向右嘅拳頭"),
            keywords: &["向右", "向右嘅拳頭", "拳頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("向右嘅拳头"),
            keywords: &["向右", "向右嘅拳头", "拳头"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("朝右的拳头"),
            keywords: &["手", "拳头", "朝右", "朝右的拳头"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("握左拳"),
            keywords: &["左", "拳", "握", "握左拳"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("拳頭向右"),
            keywords: &["拳頭", "拳頭向右", "擊拳", "重擊"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inqindi ebheke kwesokudla"),
            keywords: &["inqindi", "inqindi ebheke kwesokudla", "kwesokudla"],
        },
    ],
};
#[doc = "🤜🏻"]
pub const RIGHT_FACING_FIST_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤜🏻",
    codepoint: "1F91C 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "right-facing fist: light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤜🏼"]
pub const RIGHT_FACING_FIST_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤜🏼",
    codepoint: "1F91C 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "right-facing fist: medium-light skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤜🏽"]
pub const RIGHT_FACING_FIST_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤜🏽",
    codepoint: "1F91C 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "right-facing fist: medium skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤜🏾"]
pub const RIGHT_FACING_FIST_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤜🏾",
    codepoint: "1F91C 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "right-facing fist: medium-dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🤜🏿"]
pub const RIGHT_FACING_FIST_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🤜🏿",
    codepoint: "1F91C 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 3f32,
    name: "right-facing fist: dark skin tone",
    group: "People & Body",
    subgroup: "hand-fingers-closed",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
