#[doc = "💪"]
pub const FLEXED_BICEPS: crate::Emoji = crate::Emoji {
    glyph: "💪",
    codepoint: "1F4AA",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "flexed biceps",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("gebulte biseps"),
            keywords: &[
                "biseps",
                "bult",
                "gebulte biseps",
                "komies",
                "liggaam",
                "spier",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ታጥፎ የተወጠረ የእጅ ጡንቻ"),
            keywords: &["ታጥፎ የተወጠረ የእጅ ጡንቻ", "አስቂኝ", "አካል", "የእጅ ጡንቻ", "ጡንቻ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عضلة الذراع"),
            keywords: &["عضلات", "عضلة الذراع", "قوية", "مرنة", "هزل"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ফ\u{9c1}ল\u{9be} ব\u{9be}ইচেপ"),
            keywords: &["কমিক", "ফ\u{9c1}ল\u{9be}", "ব\u{9be}ইচেপ", "ম\u{9be}ংসপেশী"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qatlanmış əzələ"),
            keywords: &["biseps", "komik", "qatlanmış əzələ", "əymək", "əzələ"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("дэманстрацыя біцэпса"),
            keywords: &["біцэпс", "дэманстрацыя біцэпса", "мышцы", "спорт", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("Стегнат бицепс"),
            keywords: &["Стегнат бицепс", "бицепс", "мускул", "стегнат", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ব\u{9be}\u{981}ক\u{9be}নো ব\u{9be}ইসেপস"),
            keywords: &[
                "কমিক",
                "পেশী",
                "ব\u{9be}\u{981}ক\u{9be}নো ব\u{9be}ইসেপস",
                "ব\u{9be}ইসেপ",
                "শরীর",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kigenn daoubennek argrezet"),
            keywords: &["kigenn", "kigenn daoubennek", "kigenn daoubennek argrezet"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pokazivanje bicepsa"),
            keywords: &["bicepsi", "mišići", "pokazivanje bicepsa", "stripovi"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("bíceps tensat"),
            keywords: &[
                "bíceps",
                "bíceps tensat",
                "flexió de bíceps",
                "forçut",
                "múscul",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏫᎦᎳᎦ ᎤᏟᎸᏛ ᎦᎸᎳᏗᏟ ᎧᏃᎨᎾ"),
            keywords: &[
                "ᎣᏇᏓᏢ",
                "ᎤᏬᏟᏗ",
                "ᏗᎧᏃᎨᏂ ᎦᎸᎳᏗᏢ",
                "ᏗᏓᏁᏍᏗ",
                "ᏫᎦᎳᎦ ᎤᏟᎸᏛ ᎦᎸᎳᏗᏟ ᎧᏃᎨᎾ",
            ],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zatnutý biceps"),
            keywords: &[
                "biceps",
                "obrázek",
                "sval",
                "svaly",
                "síla",
                "tělo",
                "zatnutý biceps",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("cyhyrau deuben wedi eu hystwytho"),
            keywords: &[
                "corff",
                "cyhyrau",
                "cyhyrau deuben wedi eu hystwytho",
                "ystwytho",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("armmuskler"),
            keywords: &["armmuskler", "muskel", "stærk"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("angespannter Bizeps"),
            keywords: &["Comic", "Muskeln anspannen", "angespannter Bizeps", "stark"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("σφιχτός δικέφαλος"),
            keywords: &[
                "δικέφαλος",
                "επίδειξη",
                "κόμικ",
                "μυς",
                "σφιχτός δικέφαλος",
                "σώμα",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("flexed biceps"),
            keywords: &["biceps", "comic", "flex", "flexed biceps", "muscle"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("bíceps flexionado"),
            keywords: &["bíceps", "cómic", "flexionado", "fuerte", "músculo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("bíceps flexionado"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("pingutatud biitseps"),
            keywords: &["keha", "lihas", "muskel", "pingutatud biitseps"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bizepsak"),
            keywords: &[
                "bizepsa", "bizepsak", "flexioa", "giharra", "gorputza", "komikia",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("عضله\u{654} بازو"),
            keywords: &["بدن", "عضله\u{654} بازو", "ماهیچه", "مصور", "ورزیده"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("pullistettu hauis"),
            keywords: &[
                "hauis",
                "lihas",
                "pullistaa",
                "pullistettu hauis",
                "sarjakuva",
                "vartalo",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("pinalaking biceps"),
            keywords: &[
                "biceps",
                "braso",
                "macho",
                "muscle",
                "naka-flex",
                "pinalaking biceps",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("spentur biseps"),
            keywords: &["biseps", "spentur", "tvíhøvdavøddi"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("biceps contracté"),
            keywords: &["biceps", "contracté", "corps", "muscle"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("bícéips lúbtha"),
            keywords: &["bícéips", "bícéips lúbtha", "láidir", "matáin"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("giorrachadh fèithean dà-cheannach"),
            keywords: &[
                "dealbh-èibhinn",
                "fèithean",
                "fèithean dà-cheannach",
                "giorrachadh fèithean dà-cheannach",
                "lùth",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("bíceps"),
            keywords: &["bíceps", "forte", "forza", "músculo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("બાવડ\u{ac1}"),
            keywords: &[
                "ફલ\u{ac7}ક\u{acd}સ",
                "બાવડ\u{ac1}",
                "મજબ\u{ac2}ત",
                "રમ\u{ac2}જી",
                "સ\u{acd}નાય\u{ac1}",
            ],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("tanƙwararrun ƙwanji"),
            keywords: &[
                "mai ban dariya",
                "tanƙwara",
                "tanƙwararrun ƙwanji",
                "tsoka",
                "ƙwanji",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("יד עושה שריר"),
            keywords: &["זרוע", "חזק", "יד", "יד עושה שריר", "שריר"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("बाइस\u{947}प\u{94d}स"),
            keywords: &[
                "कॉमिक",
                "डोल\u{947}",
                "द\u{94d}विशिर",
                "बलशाली",
                "बाइस\u{947}प\u{94d}स",
                "मा\u{902}सप\u{947}शी",
                "लचीला",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stegnuti biceps"),
            keywords: &["biceps", "mišić", "napeto", "stegnuti biceps", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("befeszített bicepsz"),
            keywords: &[
                "befeszített bicepsz",
                "bicepsz",
                "izom",
                "karizom",
                "képregény",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ձգված բիցեպս"),
            keywords: &["բիցեպս", "կոմիքս", "ձգել", "ձգված բիցեպս", "մարմին", "մկան"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("biceps flectite"),
            keywords: &[
                "biceps",
                "biceps contrahite",
                "biceps flectite",
                "flexion",
                "forte",
                "musculo",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lengan berotot"),
            keywords: &["badan", "biseps", "lengan berotot", "otot", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("akpụ\u{300} aka"),
            keywords: &["akaọkpọ", "akpụ\u{300} aka", "akwara", "mkpaọchị"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("upphandleggsvöðvar"),
            keywords: &[
                "skrípó",
                "spenna vöðva",
                "spenntir vöðvar",
                "upphandleggsvöðvar",
                "vöðvar",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bicipite"),
            keywords: &["bicipite", "forte", "fumetto", "muscolo", "teso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("力こぶ"),
            keywords: &["ムキムキ", "力こぶ", "筋トレ", "筋肉"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("otot lengen mlenthung"),
            keywords: &[
                "lelucon",
                "ngotot",
                "otot",
                "otot lengen",
                "otot lengen mlenthung",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მოხრილი ბიცეპსები"),
            keywords: &[
                "ბიცეფსი",
                "კუნთები",
                "მოხრილი ბიცეპსები",
                "სასაცილო",
                "სხეული",
                "ტანი",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("бицепс"),
            keywords: &["бицепс", "бұлшық ет", "дене", "иілу", "комик"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("armmuskler"),
            keywords: &["armmuskler", "muskel", "stærk"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("សាច\u{17cb}ដ\u{17bb}\u{17c6}ដើមដៃ"),
            keywords: &[
                "ដៃ",
                "សាចដ\u{17bb}\u{17c6}",
                "សាច\u{17cb}ដ\u{17bb}\u{17c6}ដើមដៃ",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಗ\u{cbf}ರುವ ಸ\u{ccd}ನಾಯುಗಳು"),
            keywords: &[
                "ಬಾಗ\u{cbf}ದ ಸ\u{ccd}ನಾಯು",
                "ಬಾಗ\u{cbf}ರುವ ಸ\u{ccd}ನಾಯುಗಳು",
                "ಬಾಗ\u{cbf}ಸ\u{cbf}ದ ಸ\u{ccd}ನಾಯು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("알통"),
            keywords: &["강함", "근육", "알통", "이두박근", "힘"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{941}गिल\u{94d}ल\u{947} बायस\u{947}प\u{94d}स"),
            keywords: &[
                "फ\u{941}ग",
                "फ\u{941}गिल\u{94d}ल\u{947} बायस\u{947}प\u{94d}स",
                "बायस\u{947}प\u{94d}स",
                "विनो\u{902}द",
                "स\u{94d}नाय\u{942}",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("түйүлгөн булчуң"),
            keywords: &["булчуң", "дене", "тамаша", "түй", "түйүлгөн булчуң"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("ugespaante Bizeps"),
            keywords: &["Bizeps", "Comic", "Muskel", "ugespaante Bizeps", "uspanen"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ເບ\u{ec8}ງກ\u{ec9}າມ"),
            keywords: &["ກ\u{ec9}າມ", "ເບ\u{ec8}ງກ\u{ec9}າມ", "ແຂງແຮງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("paryškinti bicepsai"),
            keywords: &[
                "bicepsai",
                "komiksas",
                "kūnas",
                "paryškinti bicepsai",
                "raumuo",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("bicepss"),
            keywords: &["bicepss", "muskulis", "saliekt", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("uarua whakapakari"),
            keywords: &["uarua", "uaua", "whakakata", "whakapakari"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("покажува бицепс"),
            keywords: &["бицепс", "мускул", "покажува бицепс", "тело", "цртан"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കൈയ\u{d4d}യിലെ മസിൽ"),
            keywords: &[
                "കൈയ\u{d4d}യിലെ മസിൽ",
                "കോമിക\u{d4d}ക\u{d4d}",
                "മസിൽ",
                "ശക\u{d4d}തി ക\u{d3e}ണിക\u{d4d}ക\u{d41}ക",
                "ശരീരം",
                "ശ\u{200c}ക\u{d4d}തി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("гарын булчин"),
            keywords: &["булчин", "гар", "гарын булчин"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}गविल\u{947}ला द\u{902}ड"),
            keywords: &[
                "द\u{902}ड",
                "फ\u{941}गविण\u{947}",
                "फ\u{941}गविल\u{947}ला",
                "विनोदी",
                "स\u{94d}नाय\u{942}",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("biseps dilenturtegang"),
            keywords: &["bisep", "biseps dilenturtegang", "komik", "lentur"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("biceps bil-muskoli"),
            keywords: &["biceps", "biceps bil-muskoli", "flex", "komiku", "muskoli"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some(
                "က\u{103d}ေးထားသည\u{1037}\u{103a} လက\u{103a}ရ\u{102f}\u{1036}းကြ\u{103d}က\u{103a}သား",
            ),
            keywords: &[
                "ကာတ\u{103d}န\u{103a}း",
                "ကြ\u{103d}က\u{103a}သား",
                "က\u{103d}ေးဆန\u{1037}\u{103a}ခြင\u{103a}း",
                "က\u{103d}ေးထားသည\u{1037}\u{103a} လက\u{103a}ရ\u{102f}\u{1036}းကြ\u{103d}က\u{103a}သား",
                "လက\u{103a}ရ\u{102f}\u{1036}းကြ\u{103d}က\u{103a}သား",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("biceps"),
            keywords: &[
                "biceps",
                "fleks",
                "muskel",
                "muskelfleksing",
                "sterk",
                "tegneserie",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फ\u{941}लाएको बाइस\u{947}प\u{94d}स"),
            keywords: &[
                "फ\u{941}लाएको बाइस\u{947}प\u{94d}स",
                "फ\u{94d}ल\u{947}क\u{94d}स",
                "बाइस\u{947}प\u{94d}स",
                "मा\u{902}शप\u{947}शी",
                "ह\u{901}साउन\u{947}",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("spierballen"),
            keywords: &["biceps", "spannen", "spier", "spierballen", "strip"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("biceps"),
            keywords: &[
                "biceps",
                "fleks",
                "muskel",
                "muskelfleksing",
                "sterk",
                "teikneserie",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some(
                "ହ\u{b3e}ତର ମ\u{b3e}ଂସ ପେଶୀ କ\u{b41} ପ\u{b4d}ରଦର\u{b4d}ଶ\u{b3f}ତ କର\u{b3f}ବ\u{b3e}",
            ),
            keywords: &[
                "ଦୋମ\u{b41}ଣ\u{b4d}ଡ\u{b3f}ଆ ପେଶୀ",
                "ନ\u{b41}ଆ\u{b01}ଇବ\u{b3e}",
                "ମ\u{b3e}ଂସପେଶୀ",
                "ହ\u{b3e}ତର ମ\u{b3e}ଂସ ପେଶୀ କ\u{b41} ପ\u{b4d}ରଦର\u{b4d}ଶ\u{b3f}ତ କର\u{b3f}ବ\u{b3e}",
                "ହ\u{b3e}ସ\u{b4d}ୟପ\u{b4d}ରଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਬਾਇਸ\u{a47}ਪਸ"),
            keywords: &[
                "ਕਾਮਿਕ",
                "ਬਾਇਸ\u{a47}ਪਸ",
                "ਮਜ\u{a3c}ਬ\u{a42}ਤ",
                "ਮਾਸਪ\u{a47}ਸ\u{a3c}ੀ",
                "ਲਚੀਲੀ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دو سراں آلا خم دار پٹھا"),
            keywords: &[
                "بائی سیپ",
                "خم کرنا",
                "دو سراں آلا خم دار پٹھا",
                "م\u{64f}ضح\u{650}کہ خیز",
                "پٹھے",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Hánd Mọ\u{301}zul Wé Bẹnd"),
            keywords: &[
                "Hánd Mọ\u{301}zul",
                "Hánd Mọ\u{301}zul Wé Bẹnd",
                "Mọ\u{301}zul",
                "Sọ\u{301}mtin Wé De Mék Pẹ\u{301}sin Laf",
                "bẹnd",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("napięty biceps"),
            keywords: &[
                "mięśnie",
                "muskularny",
                "muskuły",
                "napięty biceps",
                "silny",
                "siła",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("انعطافی مټې"),
            keywords: &["انعطاف", "انعطافی مټې", "عضلي", "مسخره", "مټې"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("bíceps"),
            keywords: &["bíceps", "contraído", "engraçado", "forte", "músculo"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("bíceps fletido"),
            keywords: &[
                "bíceps",
                "bíceps fletido",
                "corpo",
                "desenho",
                "flexão",
                "músculo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("iskaychasqa bicepkuna"),
            keywords: &[
                "challwan",
                "comic",
                "iskaychasqa bicepkuna",
                "musculo",
                "p’akchiy",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("biceps flexat"),
            keywords: &["amuzant", "biceps flexat", "corp", "forță", "mușchi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-615"),
            keywords: &["E10-615"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("бицепс"),
            keywords: &["бицепс", "мышцы"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amaboko ahinnye"),
            keywords: &[
                "amaboko ahinnye",
                "inkuru ishushanyije",
                "kugorora imitsi",
                "pinya",
                "umukaya",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڙيل ٻانهن تي ڏورو"),
            keywords: &["جھڪڻ", "مڙيل ٻانهن تي ڏورو", "پٺا", "ڏورو", "ڪامڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ස\u{dd4}නම\u{dca}\u{200d}ය මස\u{dca}ගොබ"),
            keywords: &[
                "නැම\u{dd3}ම",
                "බ\u{dcf}හ\u{dd4} පේශ\u{dd2}ය",
                "ම\u{dcf}ංශ පේශ\u{dd2}",
                "ස\u{dd4}නම\u{dca}\u{200d}ය මස\u{dca}ගොබ",
                "හ\u{dcf}ස\u{dca}\u{200d}යජනක",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("napnutý biceps"),
            keywords: &["biceps", "napnuté", "napnutý biceps", "sval", "telo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("napeti bicepsi"),
            keywords: &[
                "biceps",
                "mišica",
                "napenjati",
                "napeti bicepsi",
                "strip",
                "telo",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("suxulka oo laaban"),
            keywords: &[
                "kalagoyska suxulka",
                "kalagoyska suxulka laaban",
                "laab",
                "majaajilada",
                "muruq",
                "suxulka oo laaban",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("muskuli dykrerësh i mbledhur"),
            keywords: &[
                "i mbledhur",
                "muskul",
                "muskul dykrerësh",
                "muskuli dykrerësh i mbledhur",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стегнути бицепс"),
            keywords: &["бицeпс", "мишић", "стегнут", "стегнути бицепс", "тело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["стегнути бицепс"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stegnuti biceps"),
            keywords: &["biceps", "mišić", "stegnut", "stegnuti biceps", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["stegnuti biceps"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("spänd biceps"),
            keywords: &["muskler", "spänd biceps", "stark"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("misuli iliyotunishwa"),
            keywords: &[
                "kibonzo",
                "misuli iliyotunishwa",
                "misuli za mikono",
                "musuli",
                "mwili",
                "tunisha",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வலுவ\u{bbe}ன தசைகள\u{bcd}"),
            keywords: &[
                "இருதலை தசை",
                "நகைச\u{bcd}சுவை",
                "வலிமை",
                "வலுவ\u{bbe}ன கைகள\u{bcd}",
                "வலுவ\u{bbe}ன தசைகள\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కండలు"),
            keywords: &[
                "కండలు",
                "దృఢత\u{c4d}వం",
                "బల\u{c3f}ష\u{c4d}టమ\u{c48}న చ\u{c47}య\u{c3f}",
            ],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("мушаки битсепси қат кардашуда"),
            keywords: &[
                "битсепс",
                "мазҳакавӣ",
                "мушак",
                "мушаки битсепси қат кардашуда",
                "қат кардан",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เบ\u{e48}งกล\u{e49}าม"),
            keywords: &[
                "กล\u{e49}าม",
                "กล\u{e49}ามแขน",
                "เบ\u{e48}งกล\u{e49}าม",
                "แข\u{e47}งแรง",
                "ไบเซป",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("bükülen tirsek"),
            keywords: &["biseps", "bükmek", "bükülen tirsek", "dokuma", "gülkünç"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("pāpela ʻoku pelu"),
            keywords: &["pāpela ʻoku pelu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("pazı"),
            keywords: &[
                "esnek",
                "güçlü",
                "kas",
                "kas esnetme",
                "pazı",
                "çizgi roman",
            ],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېگىلگەن بىلەك"),
            keywords: &["ئېگىش", "ئېگىلگەن بىلەك", "بىلەك", "كۈلكىلىك", "مۇسكۇل"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("напружений біцепс"),
            keywords: &["біцепси", "зігнутий", "м’яз", "напружений біцепс", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("بازوؤں کے ڈولے"),
            keywords: &["بازوؤں کے ڈولے", "جسم", "ڈولے"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("baquvvat muskullar"),
            keywords: &[
                "baquvvat muskullar",
                "latifa",
                "moslashuvchan",
                "muskul",
                "muskullar",
                "tana",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bắp tay gập lại"),
            keywords: &[
                "bắp tay",
                "bắp tay gập lại",
                "cơ bắp",
                "gập lại",
                "hài hước",
            ],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("wane doole"),
            keywords: &["doole", "lem", "reelu", "sidit", "wane doole"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amankonyana agotyiweyo"),
            keywords: &[
                "amankonyana",
                "amankonyana agotyiweyo",
                "goba",
                "isihlunu",
                "ukuhlekisa",
            ],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Aya Fifẹ"),
            keywords: &["Aya Fifẹ", "egun ọwọ\u{301}", "iṣan", "nà", "àwàdà"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("手瓜"),
            keywords: &["二頭肌", "手瓜", "漫畫", "肌肉"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("手瓜"),
            keywords: &["二头肌", "手瓜", "漫画", "肌肉"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("肌肉"),
            keywords: &["二头肌", "强壮", "肌肉"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("肌肉"),
            keywords: &["二頭肌", "強壯", "肌肉"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["強壯", "強壯嘅二頭肌", "肌肉"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ukuveza amandla"),
            keywords: &["izikhwepha", "opopayi", "ukuveza amandla"],
        },
    ],
};
#[doc = "💪🏻"]
pub const FLEXED_BICEPS_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💪🏻",
    codepoint: "1F4AA 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "flexed biceps: light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💪🏼"]
pub const FLEXED_BICEPS_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💪🏼",
    codepoint: "1F4AA 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "flexed biceps: medium-light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💪🏽"]
pub const FLEXED_BICEPS_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💪🏽",
    codepoint: "1F4AA 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "flexed biceps: medium skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💪🏾"]
pub const FLEXED_BICEPS_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💪🏾",
    codepoint: "1F4AA 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "flexed biceps: medium-dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "💪🏿"]
pub const FLEXED_BICEPS_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "💪🏿",
    codepoint: "1F4AA 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "flexed biceps: dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦾"]
pub const MECHANICAL_ARM: crate::Emoji = crate::Emoji {
    glyph: "🦾",
    codepoint: "1F9BE",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "mechanical arm",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("meganiese arm"),
            keywords: &["meganiese arm", "prostese", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውቶማቲክ እጅ"),
            keywords: &["ሰው ሰራሽ", "ተደራሽነት", "አውቶማቲክ እጅ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ذراع اصطناعية"),
            keywords: &[
                "إمكانية الوصول",
                "احتياجات خاصة",
                "ترقيع",
                "ذراع اصطناعية",
                "صناعية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}ন\u{9cd}ত\u{9cd}ৰিক হ\u{9be}ত"),
            keywords: &[
                "ক\u{9c3}ত\u{9cd}ৰিম",
                "দিব\u{9cd}য\u{9be}ংগ",
                "য\u{9be}ন\u{9cd}ত\u{9cd}ৰিক হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mexaniki əl"),
            keywords: &["mexaniki əl", "protez"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("механічная рука"),
            keywords: &[
                "асаблівыя фізічныя патрэбы",
                "механічная рука",
                "пратэз",
                "інваліднасць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("механична ръка"),
            keywords: &["достъпност", "механична ръка", "протеза"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("য\u{9be}ন\u{9cd}ত\u{9cd}রিক হ\u{9be}ত"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "ক\u{9c3}ত\u{9cd}রিম",
                "য\u{9be}ন\u{9cd}ত\u{9cd}রিক হ\u{9be}ত",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("brecʼh mekanikel"),
            keywords: &["brecʼh", "brecʼh mekanikel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mehanička ruka"),
            keywords: &["mehanička ruka", "pomagalo", "proteza", "ruka"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pròtesi de braç"),
            keywords: &["accessibilitat", "pròtesi", "pròtesi de braç"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎷᎩᏍᎩ ᎧᏃᎨᏂ"),
            keywords: &["ᎦᎶᏄᎮᏛ", "ᎬᏴᏍᏗ ᎨᏒᎢ", "ᏔᎷᎩᏍᎩ ᎧᏃᎨᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mechanická paže"),
            keywords: &[
                "handicap",
                "hendikep",
                "invalidní",
                "mechanická paže",
                "pomůcka",
                "postižení",
                "protéza",
                "usnadnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("braich fecanyddol"),
            keywords: &["braich fecanyddol", "hygyrchedd", "prosthetig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mekanisk arm"),
            keywords: &["handicap", "mekanisk arm", "protese"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Armprothese"),
            keywords: &["Armprothese", "Barrierefreiheit", "Prothese"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μηχανικό χέρι"),
            keywords: &["μηχανικό χέρι", "προσβασιμότητα", "προσθετικό μέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mechanical arm"),
            keywords: &["accessibility", "mechanical arm", "prosthetic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("brazo mecánico"),
            keywords: &["accesibilidad", "brazo mecánico", "ortopedia", "prótesis"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mehaaniline käsi"),
            keywords: &["ligipääs", "mehaaniline käsi", "protees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("beso mekanikoa"),
            keywords: &["beso mekanikoa", "irisgarritasuna", "prostetikoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بازوی مکانیکی"),
            keywords: &["اندام ساختگی", "بازوی مکانیکی", "دسترس\u{200c}پذیری"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tekokäsi"),
            keywords: &["esteettömyys", "tekokäsi"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mekanikal na braso"),
            keywords: &["mekanikal na braso", "pagiging naa-access", "prosthetic"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kunstigur armur"),
            keywords: &["armur", "kunstigur armur", "maskinarmur", "mekaniskur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bras mécanique"),
            keywords: &["accessibilité", "bras mécanique", "bras robot", "prothèse"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["accessibilité", "bras", "bras mécanique", "prothèse"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("lámh mheicniúil"),
            keywords: &["inrochtaineacht", "lámh mheicniúil", "próistéiteach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("gàirdean meacanaigeach"),
            keywords: &[
                "ath-bhall-bodhaig",
                "gàirdean meacanaigeach",
                "so-ruigsinneachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("brazo mecánico"),
            keywords: &["brazo mecánico", "discapacidade", "prótese", "robot"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મશીનથી બન\u{ac7}લો હાથ"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "ક\u{ac3}ત\u{acd}રિમ",
                "મશીનથી બન\u{ac7}લો હાથ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("זרוע מכנית"),
            keywords: &["זרוע מכנית", "נגישות", "פרוטזה", "תותב", "תותבת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("या\u{902}त\u{94d}रिक हाथ"),
            keywords: &[
                "क\u{943}त\u{94d}रिम हाथ",
                "मशीनी हाथ",
                "या\u{902}त\u{94d}रिक हाथ",
                "रोबोटिक हाथ",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mehanička ruka"),
            keywords: &["mehanička ruka", "pomagalo", "proteza"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mechanikus kar"),
            keywords: &["akadálymentesség", "mechanikus kar", "protézis"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեխանիկական ձեռք"),
            keywords: &["հաշմանդամ", "մեխանիկական ձեռք", "պրոթեզ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bracio mechanic"),
            keywords: &[
                "accessibilitate",
                "bracio mechanic",
                "prothese",
                "prothesis",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lengan robot"),
            keywords: &["aksesibilitas", "lengan robot", "prostetik"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vélhandleggur"),
            keywords: &["aðgengi", "gervilimur", "vélhandleggur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("protesi robotica per il braccio"),
            keywords: &[
                "accessibilità",
                "protesi",
                "protesi robotica per il braccio",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("義手"),
            keywords: &["アクセシビリティ", "人工装具", "手", "義手", "腕"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("lengen mekanis"),
            keywords: &["kalancaran", "lengen mekanis", "prostetik"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მექანიკური მხარი"),
            keywords: &["კიდურის პროთეზი", "მექანიკური", "მხარი", "პროთეზი", "შშმ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("механикалық қол"),
            keywords: &["механикалық қол", "мүмкіндігі шектеулі", "протез"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ដៃមេកាន\u{17b7}ច"),
            keywords: &[
                "ដៃមេកាន\u{17b7}ច",
                "លទ\u{17d2}ធភាព\u{200b}ទទ\u{17bd}លបាន",
                "ស\u{17b7}ប\u{17d2}បន\u{17b7}ម\u{17d2}ម\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯಾಂತ\u{ccd}ರ\u{cbf}ಕ ಕೈ"),
            keywords: &[
                "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
                "ಪ\u{ccd}ರಾಸ\u{ccd}ಥ\u{cc6}ಟ\u{cbf}ಕ\u{ccd}",
                "ಯಾಂತ\u{ccd}ರ\u{cbf}ಕ ಕೈ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("기계 팔"),
            keywords: &["기계 팔", "인공 팔"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("या\u{902}त\u{94d}रिक द\u{902}ड"),
            keywords: &[
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "प\u{94d}रोस\u{94d}थ\u{947}टिक",
                "या\u{902}त\u{94d}रिक द\u{902}ड",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("механикалык кол"),
            keywords: &["атайын мүмкүндүк", "механикалык кол", "протездик"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຂນ\u{200b}ທຽມ"),
            keywords: &[
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ທຽມ",
                "ອະ\u{200b}ໄວ\u{200b}ຍະ\u{200b}ວະ\u{200b}ທຽມ",
                "ແຂນ\u{200b}ທຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mechaninė ranka"),
            keywords: &["mechaninė ranka", "prieinamumas", "protezavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mehāniska roka"),
            keywords: &["mehāniska roka", "pieejamība", "protēzes"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("механичка рака"),
            keywords: &["механичка рака", "пристапност", "простетика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യന\u{d4d}ത\u{d4d}രക\u{d4d}കൈ"),
            keywords: &[
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "ക\u{d43}ത\u{d4d}രിമമ\u{d3e}യ",
                "യന\u{d4d}ത\u{d4d}രക\u{d4d}കൈ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хиймэл механик гар"),
            keywords: &["механик гар", "протез", "хиймэл механик гар", "хүртээмж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("या\u{902}त\u{94d}रिक हात"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "क\u{943}त\u{94d}रिम",
                "या\u{902}त\u{94d}रिक हात",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lengan mekanikal"),
            keywords: &["kebolehsampaian", "lengan mekanikal", "prostetik"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ရ\u{102f}ပ\u{103a}လက\u{103a}မောင\u{103a}း"),
            keywords: &[
                "ခြေတ\u{102f}လက\u{103a}တ\u{102f}",
                "စက\u{103a}ရ\u{102f}ပ\u{103a}လက\u{103a}မောင\u{103a}း",
                "အသ\u{102f}\u{1036}းဝင\u{103a}သော",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mekanisk arm"),
            keywords: &["mekanisk arm", "protese", "tilgjengelighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("यान\u{94d}त\u{94d}रिकी हात"),
            keywords: &[
                "उपलब\u{94d}धता",
                "प\u{94d}रोस\u{94d}थ\u{947}टिक",
                "यान\u{94d}त\u{94d}रिकी हात",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("armprothese"),
            keywords: &["armprothese", "prothese", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mekanisk arm"),
            keywords: &["mekanisk arm", "protese", "tilgjenge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯ\u{b3e}ନ\u{b4d}ତ\u{b4d}ର\u{b3f}କ ହ\u{b3e}ତ"),
            keywords: &[
                "ଅଭ\u{b3f}ଗମ\u{b4d}ୟତ\u{b3e}",
                "ପ\u{b4d}ରୋସ\u{b4d}ଥେଟ\u{b3f}କ",
                "ଯ\u{b3e}ନ\u{b4d}ତ\u{b4d}ର\u{b3f}କ ହ\u{b3e}ତ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਕ\u{a48}ਨੀਕਲ ਬਾ\u{a02}ਹ"),
            keywords: &[
                "ਪਹ\u{a41}\u{a70}ਚਯ\u{a4b}ਗਤਾ",
                "ਬਨਾਉਟੀ",
                "ਮਕ\u{a48}ਨੀਕਲ ਬਾ\u{a02}ਹ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Atífíshál Hand"),
            keywords: &[
                "Atífíshál Hand",
                "Atífíshál Pát Ọf Pẹ\u{301}sin Bọdí",
                "Ízí To Yuz",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mechaniczne ramię"),
            keywords: &["dostępność", "mechaniczne ramię", "proteza"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ميخانيکي مټ"),
            keywords: &["لاسرسی", "مصنوعي اندام", "ميخانيکي مټ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("braço mecânico"),
            keywords: &["acessibilidade", "braço mecânico", "prótese"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mecanico maki"),
            keywords: &["mecanico maki", "prostetico", "yaykurinalla"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("braț mecanic"),
            keywords: &["accesibilitate", "braț mecanic", "protetic", "proteză"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–040"),
            keywords: &["E12–040"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("механическая рука"),
            keywords: &[
                "инвалид",
                "люди с ограниченными возможностями",
                "механическая рука",
                "ограниченные возможности",
                "протез",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("مڪينيڪل هٿ"),
            keywords: &["رسائي", "مڪينيڪل هٿ", "پروسٿيٽڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ය\u{dcf}න\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ක හස\u{dca}තය"),
            keywords: &[
                "ය\u{dcf}න\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ක හස\u{dca}තය",
                "සංලග\u{dca}න",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mechanická paža"),
            keywords: &[
                "handicap",
                "hendikep",
                "invalidné",
                "mechanická paža",
                "pomôcka",
                "postihnutie",
                "protéza",
                "uľahčenie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mehanska roka"),
            keywords: &["invalid", "mehanska roka", "proteza", "umetni ud"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("gacan mashiin ah"),
            keywords: &["awood leh", "gacan mashiin ah", "lug bir galis ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("krah mekanik"),
            keywords: &["krah mekanik", "protetik", "protezë", "qasshmëri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("механичка рука"),
            keywords: &["механичка рука", "приступачност", "протеза"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mehanička ruka"),
            keywords: &["mehanička ruka", "pristupačnost", "proteza"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mekanisk arm"),
            keywords: &["bionisk arm", "mekanisk arm", "protes"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mkono bandia"),
            keywords: &["mkono bandia", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எந\u{bcd}திரக\u{bcd} கை"),
            keywords: &[
                "உறுப\u{bcd}பு",
                "உறுப\u{bcd}பு ம\u{bbe}ற\u{bcd}றம\u{bcd}",
                "எந\u{bcd}திரக\u{bcd} கை",
                "செயற\u{bcd}கை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మర చ\u{c47}య\u{c3f}"),
            keywords: &[
                "కృత\u{c4d}ర\u{c3f}మం",
                "మర చ\u{c47}య\u{c3f}",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("แขนกล"),
            keywords: &["กายอ\u{e38}ปกรณ\u{e4c}", "การเข\u{e49}าถ\u{e36}ง", "แขนกล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mehaniki gol"),
            keywords: &["elýeterlilik", "mehaniki gol", "protez"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nima ukamea"),
            keywords: &["nima ukamea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mekanik kol"),
            keywords: &["erişilebilirlik", "mekanik kol", "protez"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("механічна рука"),
            keywords: &[
                "доступність",
                "механічна рука",
                "протез",
                "спеціальні можливості",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مشینی بازو"),
            keywords: &["دسترس", "مشینی بازو", "مصنوعی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mexanik qoʻl"),
            keywords: &["mexanik qoʻl", "nogironlik", "protez"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cánh tay giả"),
            keywords: &["cánh tay giả", "giả", "hỗ trợ", "hỗ trợ tiếp cận"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("機械臂"),
            keywords: &["機械臂", "義肢", "輔助"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("机械臂"),
            keywords: &["义肢", "机械臂", "辅助"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("机械手臂"),
            keywords: &["义肢", "手臂", "无障碍", "机械手臂"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("機械手臂"),
            keywords: &["機械手臂", "行動不便"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isandla sikamakhenikha"),
            keywords: &["isandla sikamakhenikha", "ukufakelwa", "ukufinyelela"],
        },
    ],
};
#[doc = "🦿"]
pub const MECHANICAL_LEG: crate::Emoji = crate::Emoji {
    glyph: "🦿",
    codepoint: "1F9BF",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "mechanical leg",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("meganiese been"),
            keywords: &["meganiese been", "prestese", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አውቶማቲክ እግር"),
            keywords: &["ሰው ሰራሽ", "ተደራሽነት", "አውቶማቲክ እግር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساق اصطناعية"),
            keywords: &[
                "إمكانية الوصول",
                "احتياجات خاصة",
                "ترقيع",
                "ساق اصطناعية",
                "صناعية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("য\u{9be}ন\u{9cd}ত\u{9cd}ৰিক ভৰি"),
            keywords: &[
                "ক\u{9c3}ত\u{9cd}ৰিম",
                "দিব\u{9cd}য\u{9be}ংগ",
                "য\u{9be}ন\u{9cd}ত\u{9cd}ৰিক ভৰি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("mexaniki ayaq"),
            keywords: &["mexaniki ayaq", "protez"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("механічная нага"),
            keywords: &[
                "асаблівыя фізічныя патрэбы",
                "механічная нага",
                "пратэз",
                "інваліднасць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("механичен крак"),
            keywords: &["достъпност", "механичен крак", "протеза"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("য\u{9be}ন\u{9cd}ত\u{9cd}রিক প\u{9be}"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "ক\u{9c3}ত\u{9cd}রিম",
                "য\u{9be}ন\u{9cd}ত\u{9cd}রিক প\u{9be}",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gar mekanikel"),
            keywords: &["gar", "gar mekanikel"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mehanička noga"),
            keywords: &["mehanička noga", "noga", "pomagalo", "proteza"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pr`òtesi de cama"),
            keywords: &["accessibilitat", "pr`òtesi de cama", "pròtesi"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏔᎷᎩᏍᎩ ᎦᏅᏍᎨᏂ"),
            keywords: &["ᎦᎶᏄᎮᏛ", "ᎬᏴᏍᏗ ᎨᏒᎢ", "ᏔᎷᎩᏍᎩ ᎦᏅᏍᎨᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mechanická noha"),
            keywords: &[
                "handicap",
                "hendikep",
                "invalidní",
                "mechanická noha",
                "pomůcka",
                "postižení",
                "protéza",
                "usnadnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coes fecanyddol"),
            keywords: &["coes fecanyddol", "hygyrchedd", "prosthetig"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mekanisk ben"),
            keywords: &["handicap", "mekanisk ben", "protese"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Beinprothese"),
            keywords: &["Barrierefreiheit", "Beinprothese", "Prothese"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μηχανικό πόδι"),
            keywords: &["μηχανικό πόδι", "προσβασιμότητα", "προσθετικό μέλος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mechanical leg"),
            keywords: &["accessibility", "mechanical leg", "prosthetic"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pierna mecánica"),
            keywords: &["accesibilidad", "ortopedia", "pierna mecánica", "prótesis"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("mehaaniline jalg"),
            keywords: &["ligipääs", "mehaaniline jalg", "protees"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hanka mekanikoa"),
            keywords: &["hanka mekanikoa", "irisgarritasuna", "prostetikoa"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پای مکانیکی"),
            keywords: &["اندام ساختگی", "دسترس\u{200c}پذیری", "پای مکانیکی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("tekojalka"),
            keywords: &["esteettömyys", "tekojalka"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mekanikal na binti"),
            keywords: &["mekanikal na binti", "pagiging naa-access", "prosthetic"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kunstigt bein"),
            keywords: &["bein", "kunstigt bein", "maskinbein", "mekaniskt"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("jambe mécanique"),
            keywords: &[
                "accessibilité",
                "jambe mécanique",
                "jambe robot",
                "prothèse",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["accessibilité", "jambe", "jambe mécanique", "prothèse"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cos mheicniúil"),
            keywords: &["cos mheicniúil", "inrochtaineacht", "próistéiteach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cas mheacanaigeach"),
            keywords: &[
                "ath-bhall-bodhaig",
                "cas mheacanaigeach",
                "so-ruigsinneachd",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("perna mecánica"),
            keywords: &["discapacidade", "perna mecánica", "prótese", "robot"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મશીનથી બન\u{ac7}લો પગ"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "ક\u{ac3}ત\u{acd}રિમ",
                "મશીનથી બન\u{ac7}લો પગ",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רגל מכנית"),
            keywords: &["נגישות", "פרוטזה", "רגל מכנית", "תותב", "תותבת"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("या\u{902}त\u{94d}रिक प\u{948}र"),
            keywords: &[
                "क\u{943}त\u{94d}रिम प\u{948}र",
                "मशीनी प\u{948}र",
                "या\u{902}त\u{94d}रिक प\u{948}र",
                "रोबोटिक प\u{948}र",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mehanička noga"),
            keywords: &["mehanička noga", "pomagalo", "proteza"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("mechanikus láb"),
            keywords: &["akadálymentesség", "mechanikus láb", "protézis"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("մեխանիկական ոտք"),
            keywords: &["հաշմանդամ", "մեխանիկական ոտք", "պրոտեզ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("gamba mechanic"),
            keywords: &["accessibilitate", "gamba mechanic", "prothese", "prothesis"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tungkai robot"),
            keywords: &["aksesibilitas", "prostetik", "tungkai robot"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("vélfótleggur"),
            keywords: &["aðgengi", "gervilimur", "vélfótleggur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("protesi robotica per la gamba"),
            keywords: &["accessibilità", "protesi", "protesi robotica per la gamba"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("義足"),
            keywords: &["アクセシビリティ", "人工装具", "義足", "脚", "足"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sikil mekanis"),
            keywords: &["kalancaran", "prostetik", "sikil mekanis"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("მექანიკური ფეხი"),
            keywords: &["კიდურის პროთეზი", "მექანიკური", "პროთეზი", "ფეხი", "შშმ"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("механикалық аяқ"),
            keywords: &["механикалық аяқ", "мүмкіндігі шектеулі", "протез"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជើងមេកាន\u{17b7}ច"),
            keywords: &[
                "ជើងមេកាន\u{17b7}ច",
                "លទ\u{17d2}ធភាព\u{200b}ទទ\u{17bd}លបាន",
                "ស\u{17b7}ប\u{17d2}បន\u{17b7}ម\u{17d2}ម\u{17b7}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಯಾಂತ\u{ccd}ರ\u{cbf}ಕ ಕಾಲು"),
            keywords: &[
                "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
                "ಪ\u{ccd}ರಾಸ\u{ccd}ಥ\u{cc6}ಟ\u{cbf}ಕ\u{ccd}",
                "ಯಾಂತ\u{ccd}ರ\u{cbf}ಕ ಕಾಲು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("인공 다리"),
            keywords: &["인공 기관", "인공 다리", "접근성"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("या\u{902}त\u{94d}रिक पा\u{902}य"),
            keywords: &[
                "ऍक\u{94d}स\u{945}सिबिलिटी",
                "प\u{94d}रोस\u{94d}थ\u{947}टिक",
                "या\u{902}त\u{94d}रिक पा\u{902}य",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("механикалык бут"),
            keywords: &["атайын мүмкүндүк", "механикалык бут", "протездик"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂາ\u{200b}ທຽມ"),
            keywords: &[
                "ຂາ\u{200b}ທຽມ",
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ທຽມ",
                "ອະ\u{200b}ໄວ\u{200b}ຍະ\u{200b}ວະ\u{200b}ທຽມ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("mechaninė koja"),
            keywords: &["mechaninė koja", "prieinamumas", "protezavimas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mehāniska kāja"),
            keywords: &["mehāniska kāja", "pieejamība", "protēzes"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("механичка нога"),
            keywords: &["механичка нога", "пристапност", "простетика"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("യന\u{d4d}ത\u{d4d}രക\u{d4d}ക\u{d3e}ൽ"),
            keywords: &[
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "ക\u{d43}ത\u{d4d}രിമമ\u{d3e}യ",
                "യന\u{d4d}ത\u{d4d}രക\u{d4d}ക\u{d3e}ൽ",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хиймэл механик хөл"),
            keywords: &["механиз хөл", "протез", "хиймэл механик хөл", "хүртээмж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("या\u{902}त\u{94d}रिक पाय"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "क\u{943}त\u{94d}रिम",
                "या\u{902}त\u{94d}रिक पाय",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kaki mekanikal"),
            keywords: &["kaki mekanikal", "kebolehsampaian", "prostetik"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("စက\u{103a}ရ\u{102f}ပ\u{103a}ခြေထောက\u{103a}"),
            keywords: &[
                "ခြေတ\u{102f}လက\u{103a}တ\u{102f}",
                "စက\u{103a}ရ\u{102f}ပ\u{103a}ခြေထောက\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("mekanisk bein"),
            keywords: &["mekanisk bein", "protese", "tilgjengelighet"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("यान\u{94d}त\u{94d}रिकी ख\u{941}ट\u{94d}टा"),
            keywords: &[
                "उपलब\u{94d}धता",
                "प\u{94d}रोस\u{94d}थ\u{947}टिक",
                "यान\u{94d}त\u{94d}रिकी ख\u{941}ट\u{94d}टा",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("beenprothese"),
            keywords: &["beenprothese", "prothese", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("mekanisk bein"),
            keywords: &["mekanisk bein", "protese", "tilgjenge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଯ\u{b3e}ନ\u{b4d}ତ\u{b4d}ର\u{b3f}କ ଗୋଡ"),
            keywords: &[
                "ଅଭ\u{b3f}ଗମ\u{b4d}ୟତ\u{b3e}",
                "ପ\u{b4d}ରୋସ\u{b4d}ଥେଟ\u{b3f}କ",
                "ଯ\u{b3e}ନ\u{b4d}ତ\u{b4d}ର\u{b3f}କ ଗୋଡ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮਕ\u{a48}ਨੀਕਲ ਲ\u{a71}ਤ"),
            keywords: &[
                "ਪਹ\u{a41}\u{a70}ਚਯ\u{a4b}ਗਤਾ",
                "ਬਨਾਉਟੀ",
                "ਮਕ\u{a48}ਨੀਕਲ ਲ\u{a71}ਤ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Atífíshál Lẹg"),
            keywords: &[
                "Atífíshál Lẹg",
                "Atífíshál Pát Ọf Pẹ\u{301}sin Bọdí",
                "Ízí To Yuz",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("proteza nogi"),
            keywords: &["dostępność", "proteza", "proteza nogi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ميخانيکي پنډۍ"),
            keywords: &["لاسرسی", "مصنوعي اندام", "ميخانيکي پنډۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("perna mecânica"),
            keywords: &["acessibilidade", "perna mecânica", "prótese"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("mecanico chaka"),
            keywords: &["mecanico chaka", "prostetico", "yaykurinalla"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("picior mecanic"),
            keywords: &["accesibilitate", "picior mecanic", "protetic", "proteză"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–041"),
            keywords: &["E12–041"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("механическая нога"),
            keywords: &[
                "инвалид",
                "люди с ограниченными возможностями",
                "механическая нога",
                "ограниченные возможности",
                "протез",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ميڪينيڪل ٽنگ"),
            keywords: &["رسائي", "ميڪينيڪل ٽنگ", "پروسٿيٽڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ය\u{dcf}න\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ක ප\u{dcf}දය"),
            keywords: &[
                "ය\u{dcf}න\u{dca}ත\u{dca}\u{200d}ර\u{dd2}ක ප\u{dcf}දය",
                "සංලග\u{dca}න",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mechanická noha"),
            keywords: &[
                "handicap",
                "hendikep",
                "invalidné",
                "mechanická noha",
                "pomôcka",
                "postihnutie",
                "protéza",
                "uľahčenie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("mehanska noga"),
            keywords: &["invalid", "mehanska noga", "proteza", "umetni ud"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lug mashiin ah"),
            keywords: &["la heli karo", "lug bir galis ah", "lug mashiin ah"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këmbë mekanike"),
            keywords: &["këmbë mekanike", "protetik", "protezë", "qasshmëri"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("механична нога"),
            keywords: &["механична нога", "приступачност", "протеза"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("механичка нога"),
            keywords: &["механичка нога"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mehanična noga"),
            keywords: &["mehanična noga", "pristupačnost", "proteza"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("mehanička noga"),
            keywords: &["mehanička noga"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mekaniskt ben"),
            keywords: &["bioniskt ben", "mekaniskt ben", "protes"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mguu bandia"),
            keywords: &["mguu bandia", "ufikivu"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எந\u{bcd}திரக\u{bcd} க\u{bbe}ல\u{bcd}"),
            keywords: &[
                "உறுப\u{bcd}பு",
                "உறுப\u{bcd}பு ம\u{bbe}ற\u{bcd}றம\u{bcd}",
                "எந\u{bcd}திரக\u{bcd} க\u{bbe}ல\u{bcd}",
                "செயற\u{bcd}கை",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మర క\u{c3e}లు"),
            keywords: &[
                "కృత\u{c4d}ర\u{c3f}మం",
                "మర క\u{c3e}లు",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขากล"),
            keywords: &["กายอ\u{e38}ปกรณ\u{e4c}", "การเข\u{e49}าถ\u{e36}ง", "ขากล"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("mehaniki aýak"),
            keywords: &["elýeterlilik", "mehaniki aýak", "protez"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaʻe ukamea"),
            keywords: &["vaʻe ukamea"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("mekanik bacak"),
            keywords: &["erişilebilirlik", "mekanik bacak", "protez"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("механічна нога"),
            keywords: &[
                "доступність",
                "механічна нога",
                "протез",
                "спеціальні можливості",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("مشینی ٹانگ"),
            keywords: &["دسترس", "مشینی ٹانگ", "مصنوعی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("mexanik oyoq"),
            keywords: &["mexanik oyoq", "nogironlik", "protez"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("chân giả"),
            keywords: &["chân giả", "giả", "hỗ trợ", "hỗ trợ tiếp cận"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("機械腳"),
            keywords: &["機械腳", "義肢", "輔助"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("机械脚"),
            keywords: &["义肢", "机械脚", "辅助"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("机械腿"),
            keywords: &["义肢", "无障碍", "机械腿", "腿"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("機械腳"),
            keywords: &["機械腳", "行動不便"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("inyawo likamakhenikha"),
            keywords: &["inyawo likamakhenikha", "ukufakelwa", "ukufinyelela"],
        },
    ],
};
#[doc = "🦵"]
pub const LEG: crate::Emoji = crate::Emoji {
    glyph: "🦵",
    codepoint: "1F9B5",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leg",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("been"),
            keywords: &["been", "ledemaat", "skop"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እግር"),
            keywords: &["መምታት", "አካላት", "እግር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("ساق"),
            keywords: &["ركل", "ساق", "طرف"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ঠেং"),
            keywords: &["অংগ", "গোৰ", "ঠেং"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qıç"),
            keywords: &["qıç", "təpik", "əza"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нага"),
            keywords: &["выспятак", "канечнасць", "нага"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("крак"),
            keywords: &["крайник", "крак", "ритник"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}"),
            keywords: &["প\u{9be}", "ল\u{9be}থি"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("gar"),
            keywords: &["gar"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("noga"),
            keywords: &["noga", "udarati nogom", "šutirati"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cama"),
            keywords: &["cama", "extremitat", "puntada de peu"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏍᎨᏂ"),
            keywords: &["ᎠᏓᏴᏖᏍᏗ", "ᎠᏰᎸᎢ", "ᎦᏅᏍᎨᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("noha"),
            keywords: &["končetina", "kopanec", "kopnutí", "noha"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("coes"),
            keywords: &["cicio", "coes"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("ben"),
            keywords: &["ben", "halte", "humpe", "sparke"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Bein"),
            keywords: &["Bein", "Treten", "Tritt"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πόδι"),
            keywords: &["άκρο", "κλωτσιά", "πόδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("leg"),
            keywords: &["kick", "leg", "limb"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pierna"),
            keywords: &["extremidad", "patada", "pierna"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pierna"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pierna"),
            keywords: &["pierna"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jalg"),
            keywords: &["jalalöök", "jalg", "jäse"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hanka"),
            keywords: &["gorputz-adarra", "hanka", "ostikada"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لنگ"),
            keywords: &["لنگ", "لگد", "پا"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jalka"),
            keywords: &["alaraaja", "jalka", "potkaista", "potku", "raaja"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("hita"),
            keywords: &["biyas", "hita", "sipa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("bein"),
            keywords: &["bein", "limur", "sparka"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("jambe"),
            keywords: &["coup de pied", "jambe", "membre"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cos"),
            keywords: &["cic", "cos", "géag"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sliasaid"),
            keywords: &["breab", "breabadh", "cas", "sliasaid"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("perna"),
            keywords: &["corpo", "extremidade", "patada", "perna"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પગ"),
            keywords: &["અ\u{a82}ગ", "કિક મારવી", "પગ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("רגל"),
            keywords: &["איבר", "בעיטה", "גפיים", "רגל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("प\u{948}र"),
            keywords: &["किक", "जोड\u{93c}", "प\u{948}र"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("noga"),
            keywords: &["noga", "udariti nogom", "šutirati"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lábszár"),
            keywords: &["comb", "lábszár", "rúgás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոտք"),
            keywords: &["հարվածել", "ոտք", "վերջույթ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("gamba"),
            keywords: &["colpo de pede", "gamba", "membro"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tungkai"),
            keywords: &["bagian tubuh", "tendang", "tungkai"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fótleggur"),
            keywords: &["fótleggur", "sparka", "útlimur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("gamba"),
            keywords: &["arto", "calcio", "gamba"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("脚"),
            keywords: &["キック", "脚", "足"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("sikil"),
            keywords: &["perangan awak", "sikil", "tendhang"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფეხი"),
            keywords: &["კიდური", "ფეხი", "წვივი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("аяқ"),
            keywords: &["аяқ", "тебу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ជើង"),
            keywords: &["ជើង", "ទាត\u{17cb}", "អវយវៈ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಾಲು"),
            keywords: &["ಒದ\u{cc6}ಯುವುದು", "ಕಾಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("한쪽 다리"),
            keywords: &["다리 한쪽", "킥", "한쪽 다리"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पा\u{902}य गात\u{94d}र"),
            keywords: &["किक", "गात\u{94d}र", "पा\u{902}य"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жоон сан"),
            keywords: &["жоон сан", "тебүү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຂາ"),
            keywords: &["ຂາ", "ເຕະ", "ແຂນຂາ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("koja"),
            keywords: &["galūnė", "koja", "spyris"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kāja"),
            keywords: &["ekstremitāte", "kāja", "spēriens"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("нога"),
            keywords: &["клоца", "нога"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ല\u{d4d}"),
            keywords: &["അവയവം", "ക\u{d3e}ല\u{d4d}", "തൊഴി"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хөл"),
            keywords: &["мөч", "хөл", "өшиглөх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("त\u{902}गडी"),
            keywords: &["अवयव", "किक", "त\u{902}गडी"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("kaki"),
            keywords: &["bahagian kaki", "kaki", "tendang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခြေထောက\u{103a}"),
            keywords: &[
                "ခြေဆ\u{1036}လက\u{103a}ဆ\u{1036}",
                "ခြေထောက\u{103a}",
                "ခြေဖြင\u{1037}\u{103a}ကန\u{103a}ခြင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("bein"),
            keywords: &["bein", "lem", "sparke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("ख\u{941}ट\u{94d}टा"),
            keywords: &["ख\u{941}ट\u{94d}टा", "हातख\u{941}ट\u{94d}टा"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("been"),
            keywords: &["been", "ledemaat", "schoppen"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("bein"),
            keywords: &["bein", "lem", "sparke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଗୋଡ"),
            keywords: &["ଅବୟବ", "କ\u{b3f}କ\u{b4d}\u{200c}", "ଗୋଡ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਲ\u{a71}ਤ"),
            keywords: &["ਅ\u{a70}ਗ", "ਠ\u{a41}\u{a71}ਡਾ ਮਾਰਨਾ", "ਲ\u{a71}ਤ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lẹg"),
            keywords: &["Kik", "Lẹg"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("noga"),
            keywords: &["kopniak", "kończyna", "noga"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پنډۍ"),
            keywords: &["اندام", "لته", "پنډۍ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("perna"),
            keywords: &["chute", "membro", "perna"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["extremidade", "perna", "pontapé"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chanka"),
            keywords: &["chanka", "jaytʼay", "miembro"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("picior"),
            keywords: &["membru", "picior", "șut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-038"),
            keywords: &["E11-038"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нога"),
            keywords: &["бедро", "нога", "пинок"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٽنگهه"),
            keywords: &["لت", "ٻانهن", "ٽنگهه"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කක\u{dd4}ල"),
            keywords: &[
                "කක\u{dd4}ල",
                "පය\u{dd2}න\u{dca} ගසනව\u{dcf}",
                "බ\u{dcf}හ\u{dd4}ව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("noha"),
            keywords: &["kopať", "kopnúť", "noha"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("noga"),
            keywords: &["brca", "noga", "okončina"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("lug"),
            keywords: &["addinka", "laad", "lug"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("këmbë"),
            keywords: &["gjymtyrë", "këmbë", "shkelm"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("нога"),
            keywords: &["нога", "шут"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("noga"),
            keywords: &["noga", "šut"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ben"),
            keywords: &["ben", "lem", "sparka"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mguu"),
            keywords: &["mguu", "teke"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}ல\u{bcd}"),
            keywords: &["உதை", "க\u{bbe}ல\u{bcd}", "மூட\u{bcd}டு"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("క\u{c3e}లు"),
            keywords: &["అవయవం", "క\u{c3e}లు", "తన\u{c4d}నడం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ขา"),
            keywords: &["ขา", "เตะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("aýak"),
            keywords: &["agza", "aýak", "aýak2", "depmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("vaʻe"),
            keywords: &["vaʻe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("bacak"),
            keywords: &["bacak", "tekme"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("нога"),
            keywords: &["копняк", "нога", "стегно", "удар ногою"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ٹانگ"),
            keywords: &["عضو", "ٹانگ", "ٹھوکر"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oyoq"),
            keywords: &["oyoq", "son", "tepish"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("Chân"),
            keywords: &["Chân", "chân", "chân tay", "đá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("腳"),
            keywords: &["肢", "腳", "踢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("脚"),
            keywords: &["肢", "脚", "踢"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("腿"),
            keywords: &["腿", "跛行", "踢"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("腿"),
            keywords: &["腳", "腿", "踢"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umlenze"),
            keywords: &["kick", "limb", "umlenze"],
        },
    ],
};
#[doc = "🦵🏻"]
pub const LEG_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦵🏻",
    codepoint: "1F9B5 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leg: light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦵🏼"]
pub const LEG_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦵🏼",
    codepoint: "1F9B5 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leg: medium-light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦵🏽"]
pub const LEG_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦵🏽",
    codepoint: "1F9B5 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leg: medium skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦵🏾"]
pub const LEG_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦵🏾",
    codepoint: "1F9B5 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leg: medium-dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦵🏿"]
pub const LEG_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦵🏿",
    codepoint: "1F9B5 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "leg: dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦶"]
pub const FOOT: crate::Emoji = crate::Emoji {
    glyph: "🦶",
    codepoint: "1F9B6",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "foot",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("voet"),
            keywords: &["skop", "stamp", "voet"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("እግር የታችኛው ክፍል"),
            keywords: &["መምታት", "መርገጥ", "እግር የታችኛው ክፍል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("قدم"),
            keywords: &["تعثر", "دس", "رفسة", "ركل", "ركلة", "قدم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ভৰি"),
            keywords: &["গোৰ", "ভৰি", "ভৰি পেল\u{9be}ই যোৱ\u{9be}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ayaq"),
            keywords: &["ayaq", "pəncə", "təpik"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("ступня"),
            keywords: &["выспятак", "ступня"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("стъпало"),
            keywords: &["настъпване", "ритник", "стъпало"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("প\u{9be}য\u{9bc}ের প\u{9be}থ\u{9be}"),
            keywords: &[
                "প\u{9be}য\u{9bc}ের প\u{9be}ত\u{9be}",
                "প\u{9be}য\u{9bc}ের প\u{9be}থ\u{9be}",
                "রেগে প\u{9be} ছো\u{981}ড\u{9bc}\u{9be}",
                "ল\u{9be}থি",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("troad"),
            keywords: &["troad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("stopalo"),
            keywords: &["korak", "stopalo", "udarac"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("peu"),
            keywords: &["peu", "puntada de peu", "trepitjada"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎳᏏᏕᏂ"),
            keywords: &["ᎠᏓᏴᏖᏍᏗ", "ᎤᎳᏏᏕᏂ", "ᏍᏓᏯ ᏬᎳᏏᏅ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("chodidlo"),
            keywords: &[
                "chodidlo",
                "kopanec",
                "kopnutí",
                "noha",
                "šlapka",
                "šlápnutí",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("troed"),
            keywords: &["cic", "stomp", "troed"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("fod"),
            keywords: &["fod", "sparke", "trampe"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Fuß"),
            keywords: &["Fuß", "Stampfen", "Treten"],
        },
        #[cfg(feature = "de_CH")]
        crate::Annotation {
            lang: "de_CH",
            tts: Some("Fuss"),
            keywords: &["Fuss", "Kick", "stampfen"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κάτω άκρο"),
            keywords: &["κάτω άκρο", "κλωτσάω", "κλωτσιά", "πόδι"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("foot"),
            keywords: &["foot", "kick", "stomp"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pie"),
            keywords: &["patada", "pie", "pisotón"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("jalalaba"),
            keywords: &["jalalaba", "jalalöök", "trampimine"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("oin"),
            keywords: &["oin", "oina", "ostikada", "zanpatu"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("پا"),
            keywords: &["پا", "پایکوبی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("jalkaterä"),
            keywords: &["jalkaterä", "potkaista", "potku", "tallata", "töminä"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("paa"),
            keywords: &["apakan", "paa", "sipa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("fótur"),
            keywords: &["fótur", "limur", "sparka", "trampa"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("pied"),
            keywords: &["coup de pied", "pas lourd", "pied"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("troigh"),
            keywords: &["cic", "gread", "troigh"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cas"),
            keywords: &["breab", "breabadh", "cas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pé"),
            keywords: &["patada", "pisada", "pé"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("પ\u{a82}જો"),
            keywords: &["કિક મારવી", "જોરથી પગ પછાડવો", "પ\u{a82}જો", "પગ"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("כף רגל"),
            keywords: &["בעיטה", "כף רגל", "רגל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("पा\u{901}व"),
            keywords: &["किक", "पा\u{901}व", "लात"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("stopalo"),
            keywords: &["korak", "stopalo", "udarac"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("lábfej"),
            keywords: &["dobogás", "lábfej", "rúgás"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոտնաթաթ"),
            keywords: &["հարվածել", "ոտնաթաթ", "տրորել"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("pede"),
            keywords: &["colpo de pede", "pede"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telapak kaki"),
            keywords: &["injak", "telapak kaki", "tendang"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("fótur"),
            keywords: &["fótur", "sparka", "stappa", "þramma"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("piede"),
            keywords: &["calciare", "camminare", "piede"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("足"),
            keywords: &["キック", "ダンス", "足", "踏みつける"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("tlapakan sikil"),
            keywords: &["pidak", "sikil", "tendhang", "tlapakan sikil"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტერფი"),
            keywords: &["კიდური", "ტერფი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("табан"),
            keywords: &["стомп", "табан", "тебу"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ប\u{17d2}រអប\u{17cb}ជើង"),
            keywords: &[
                "តន\u{17d2}ត\u{17d2}រ\u{17c6}",
                "ទាត\u{17cb}",
                "ប\u{17d2}រអប\u{17cb}ជើង",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಪಾದ"),
            keywords: &["ಒದ\u{cc6}ಯುವುದು", "ಪಾದ", "ಹ\u{cc6}ಜ\u{ccd}ಜ\u{cc6}ಹಾಕುವುದು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("한쪽 발"),
            keywords: &["발 한쪽", "발구르기", "킥", "한쪽 발"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("पा\u{902}य"),
            keywords: &["किक", "पा\u{902}य", "स\u{94d}टोम\u{94d}प"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("бут"),
            keywords: &["бут", "тебүү"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕ\u{eb5}ນ"),
            keywords: &["ຕ\u{eb5}ນ", "ສະດ\u{eb8}ດ", "ເຕະ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("pėda"),
            keywords: &["pėda", "spyris", "trepsėti"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("pēda"),
            keywords: &["pēda", "spēriens"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("стапало"),
            keywords: &["газење", "клоцање", "стапало"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ക\u{d3e}ൽപ\u{d4d}പ\u{d3e}ദം"),
            keywords: &[
                "അമർത\u{d4d}തിച\u{d4d}ചവിട\u{d4d}ടി നടക\u{d4d}ക\u{d41}ക",
                "ക\u{d3e}ൽപ\u{d4d}പ\u{d3e}ദം",
                "തൊഴി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тавхай"),
            keywords: &["тавхай", "товших", "өшиглөх"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("पाऊल"),
            keywords: &["किक", "पाऊल", "पाय आपटण\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hujung kaki"),
            keywords: &["hentak", "hujung kaki", "tendang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ခြေမျက\u{103a}စ\u{102d} အောက\u{103a}ပ\u{102d}\u{102f}င\u{103a}း"),
            keywords: &[
                "ကန\u{103a}ကျောက\u{103a}ခြင\u{103a}း",
                "ခြေဆောင\u{1037}\u{103a}ခြင\u{103a}း",
                "ခြေမျက\u{103a}စ\u{102d} အောက\u{103a}ပ\u{102d}\u{102f}င\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("fot"),
            keywords: &["fot", "sparke", "tråkke"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("पयर"),
            keywords: &["किक", "पयर", "स\u{94d}टोम\u{94d}प"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("voet"),
            keywords: &["schoppen", "stampen", "voet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("fot"),
            keywords: &["fot", "sparke", "trakke"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଦ"),
            keywords: &[
                "କ\u{b3f}କ\u{b4d}\u{200c}",
                "ଦ\u{b41}ମ\u{b4d}\u{200c} ଦ\u{b41}ମ\u{b4d}\u{200c} ଚ\u{b3e}ଲ\u{b3f}ବ\u{b3e}",
                "ପ\u{b3e}ଦ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਪ\u{a48}ਰ"),
            keywords: &[
                "ਠ\u{a41}\u{a71}ਡਾ ਮਾਰਨਾ",
                "ਪ\u{a48}ਰ",
                "ਪ\u{a48}ਰ ਘੜੀਸ ਕ\u{a47} ਤ\u{a41}ਰਨਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Daunlẹg"),
            keywords: &["Daunlẹg", "Kik"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("stopa"),
            keywords: &["kopniak", "stopa", "tupanie"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پښه"),
            keywords: &["لته", "په موټي وهنه", "پښه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pé"),
            keywords: &["chute", "pisão", "pé"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["pisar", "pontapé", "pé"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("chaki"),
            keywords: &["chaki", "jaytʼay saruy"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("laba piciorului"),
            keywords: &["călcat", "laba piciorului", "șut"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-039"),
            keywords: &["E11-039"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("щиколотка"),
            keywords: &["лодыжка", "нога", "стопа", "ступня", "щиколотка"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("پير"),
            keywords: &["اسٽومپ", "لت", "پير"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අඩ\u{dd2}ය"),
            keywords: &[
                "අඩ\u{dd2}ය",
                "නැට\u{dd4}මක\u{dca}",
                "පය\u{dd2}න\u{dca} ගසනව\u{dcf}",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("chodidlo"),
            keywords: &["chodidlo", "dupať", "kopať"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("stopalo"),
            keywords: &["brca", "stopalo", "topot"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("cagta"),
            keywords: &["cagta", "laad", "tallaabo xooggan"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("shputë"),
            keywords: &["shkelm", "shkelmim", "shputë"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("стопало"),
            keywords: &["згазити", "стопало"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("stopalo"),
            keywords: &["stopalo", "zgaziti"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("fot"),
            keywords: &["fot", "sparka", "stampa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("wayo"),
            keywords: &["kanyaga", "piga teke", "wayo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ப\u{bbe}தம\u{bcd}"),
            keywords: &["உதை", "ப\u{bbe}தம\u{bcd}", "மிதி"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ప\u{c3e}దం"),
            keywords: &["తన\u{c4d}ను", "నడవడం", "ప\u{c3e}దం"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("เท\u{e49}า"),
            keywords: &["กระท\u{e37}บ", "เตะ", "เท\u{e49}า"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("daban"),
            keywords: &["aýak", "basmak", "daban", "depmek"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("lauʻivaʻe"),
            keywords: &["lauʻivaʻe"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ayak"),
            keywords: &["ayak", "tekme"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ступня"),
            keywords: &["нога", "ніжка", "стопа", "ступня", "удар"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پاؤں"),
            keywords: &["ٹھوکر", "پاؤں", "پاؤں مارنا"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("toʼpiq"),
            keywords: &["boldir", "oyoq", "tepish", "tizza", "tizzagacha", "toʼpiq"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("bàn chân"),
            keywords: &["bàn chân", "dậm mạnh", "đá"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("腳掌"),
            keywords: &["腳掌", "踏", "踢"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("脚掌"),
            keywords: &["脚掌", "踏", "踢"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("脚"),
            keywords: &["脚", "踢", "踩"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("腳"),
            keywords: &["腳", "踢", "踩"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("unyawo"),
            keywords: &["kick", "stomp", "unyawo"],
        },
    ],
};
#[doc = "🦶🏻"]
pub const FOOT_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦶🏻",
    codepoint: "1F9B6 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "foot: light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦶🏼"]
pub const FOOT_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦶🏼",
    codepoint: "1F9B6 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "foot: medium-light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦶🏽"]
pub const FOOT_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦶🏽",
    codepoint: "1F9B6 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "foot: medium skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦶🏾"]
pub const FOOT_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦶🏾",
    codepoint: "1F9B6 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "foot: medium-dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦶🏿"]
pub const FOOT_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦶🏿",
    codepoint: "1F9B6 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "foot: dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👂"]
pub const EAR: crate::Emoji = crate::Emoji {
    glyph: "👂",
    codepoint: "1F442",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "ear",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oor"),
            keywords: &["liggaam", "oor"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጆሮ"),
            keywords: &["አካል", "ጆሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أذن"),
            keywords: &["أذن", "جسم"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ক\u{9be}ণ"),
            keywords: &["ক\u{9be}ণ", "শৰীৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("qulaq"),
            keywords: &["bədən", "qulaq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вуха"),
            keywords: &["вуха", "слых", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ухо"),
            keywords: &["тяло", "ухо"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ক\u{9be}ন"),
            keywords: &["ক\u{9be}ন", "শরীর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skouarn"),
            keywords: &["skouarn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uho"),
            keywords: &["dio tijela", "uho"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("orella"),
            keywords: &["cos", "orella"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎴᏂ"),
            keywords: &["ᎥᏰᎸᎢ", "ᎦᎴᏂ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ucho"),
            keywords: &["tělo", "ucho"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clust"),
            keywords: &["clust", "corff"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("øre"),
            keywords: &["høre", "krop", "øre"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ohr"),
            keywords: &["Körperteil", "Ohr"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυτί"),
            keywords: &["αυτί", "σώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ear"),
            keywords: &["body", "ear"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("oreja"),
            keywords: &["cuerpo", "oreja"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kõrv"),
            keywords: &["keha", "kõrv"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("belarri"),
            keywords: &["belarri", "belarria", "gorputza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("گوش"),
            keywords: &["بدن", "گوش"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("korva"),
            keywords: &["korva", "pää", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tainga"),
            keywords: &["katawan", "tainga", "tenga"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("oyra"),
            keywords: &["kroppur", "oyra"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("oreille"),
            keywords: &["corps", "oreille"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cluas"),
            keywords: &["cluas", "corp"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cluas"),
            keywords: &["bodhaig", "cluas"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("orella"),
            keywords: &["orella"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("કાન"),
            keywords: &["કાન", "શરીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("kunne"),
            keywords: &["jiki", "kunne"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוזן"),
            keywords: &["אוזן", "לשמוע", "צליל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("कान"),
            keywords: &["कान", "शरीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uho"),
            keywords: &["tijelo", "uho"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fül"),
            keywords: &["fej", "fül", "test", "testrész"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ականջ"),
            keywords: &["ականջ", "մարմին"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("aure"),
            keywords: &[
                "audientia",
                "audita",
                "audition",
                "aural",
                "aure",
                "auricular",
                "corpore",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telinga"),
            keywords: &["badan", "telinga", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("nti"),
            keywords: &["nti", "àhụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eyru"),
            keywords: &["eyru", "líkami"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("orecchio"),
            keywords: &["corpo", "orecchio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("耳"),
            keywords: &["からだ", "耳"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuping"),
            keywords: &["awak", "kuping"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყური"),
            keywords: &["სხეული", "ტანი", "ყური"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("құлақ"),
            keywords: &["дене", "құлақ"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("øre"),
            keywords: &["høre", "krop", "øre"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ត\u{17d2}រចៀក"),
            keywords: &["ត\u{17d2}រចៀក", "ស\u{17d2}តាប\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕ\u{cbf}ವ\u{cbf}"),
            keywords: &["ಕ\u{cbf}ವ\u{cbf}", "ದೇಹ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("귀"),
            keywords: &["귀", "몸"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("कान"),
            keywords: &["कान", "क\u{942}ड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("кулак"),
            keywords: &["дене", "кулак"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Ouer"),
            keywords: &["Kierper", "Ouer"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຫ\u{eb9}"),
            keywords: &["ຫ\u{eb9}", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ausis"),
            keywords: &["ausis", "kūnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("auss"),
            keywords: &["auss", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("taringa"),
            keywords: &["taringa", "tinana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("уво"),
            keywords: &["тело", "уво"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ചെവി"),
            keywords: &["ചെവി", "ശരീരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("чих"),
            keywords: &["бие", "чих"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("कान"),
            keywords: &["कान", "शरीर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telinga"),
            keywords: &["badan", "telinga"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("widna"),
            keywords: &["widna", "ġisem"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နားရ\u{103d}က\u{103a}"),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}ခန\u{1039}ဓာ",
                "နားရ\u{103d}က\u{103a}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øre"),
            keywords: &["kropp", "øre"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("कान"),
            keywords: &["कान", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oor"),
            keywords: &["lichaam", "oor"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("øyre"),
            keywords: &["kropp", "øyre"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ନ"),
            keywords: &["କ\u{b3e}ନ", "ଶରୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਕ\u{a70}ਨ"),
            keywords: &["ਕ\u{a70}ਨ", "ਸਰੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("کان"),
            keywords: &["جسم", "کان"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ia"),
            keywords: &["Bọdí Pat", "Hia", "Ia"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ucho"),
            keywords: &["ciało", "ucho"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غوږ"),
            keywords: &["بدن", "غوږ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("orelha"),
            keywords: &["corpo", "orelha"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ninri"),
            keywords: &["khurku", "ninri"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ureche"),
            keywords: &["corp", "ureche"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-511"),
            keywords: &["E10-511"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ухо"),
            keywords: &["тело", "ухо", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ugutwi"),
            keywords: &["igihimba", "ugutwi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڪن"),
            keywords: &["جسم", "ڪن"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කණ"),
            keywords: &["කණ", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ucho"),
            keywords: &["telo", "ucho"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("uho"),
            keywords: &["telo", "uho"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhagta"),
            keywords: &["dhagta", "jirka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vesh"),
            keywords: &["trup", "vesh"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("уво"),
            keywords: &["тело", "уво"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["уво"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uvo"),
            keywords: &["telo", "uvo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["uvo"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öra"),
            keywords: &["kropp", "öra"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sikio"),
            keywords: &["mwili", "sikio"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("க\u{bbe}து"),
            keywords: &["உடல\u{bcd}", "உடல\u{bcd} உறுப\u{bcd}பு", "க\u{bbe}து"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("చ\u{c46}వ\u{c3f}"),
            keywords: &["చ\u{c46}వ\u{c3f}", "శర\u{c40}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("гуш"),
            keywords: &["бадан", "гуш"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e39}"),
            keywords: &["ฟ\u{e31}ง", "ห\u{e39}", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gulak"),
            keywords: &["gulak", "göwre"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("telinga"),
            keywords: &["telinga"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kulak"),
            keywords: &["gövde", "kulak"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("قۇلاق"),
            keywords: &["قۇلاق", "گەۋدە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вухо"),
            keywords: &["вухо", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("کان"),
            keywords: &["جسم", "کان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("quloq"),
            keywords: &["quloq", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tai"),
            keywords: &["cơ thể", "tai"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("nopp"),
            keywords: &["nopp", "yaram"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("indlebe"),
            keywords: &["indlebe", "isiqu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Etí"),
            keywords: &["Ara", "Etí"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("耳仔"),
            keywords: &["耳仔", "身體"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("耳仔"),
            keywords: &["耳仔", "身体"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("耳朵"),
            keywords: &["听", "耳", "耳朵"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("耳朵"),
            keywords: &["耳朵", "身體部位"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indlebe"),
            keywords: &["indlebe", "umzimba"],
        },
    ],
};
#[doc = "👂🏻"]
pub const EAR_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👂🏻",
    codepoint: "1F442 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "ear: light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👂🏼"]
pub const EAR_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👂🏼",
    codepoint: "1F442 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "ear: medium-light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👂🏽"]
pub const EAR_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👂🏽",
    codepoint: "1F442 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "ear: medium skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👂🏾"]
pub const EAR_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👂🏾",
    codepoint: "1F442 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "ear: medium-dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👂🏿"]
pub const EAR_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👂🏿",
    codepoint: "1F442 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "ear: dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦻"]
pub const EAR_WITH_HEARING_AID: crate::Emoji = crate::Emoji {
    glyph: "🦻",
    codepoint: "1F9BB",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ear with hearing aid",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oor met gehoorapparaat"),
            keywords: &["gehoorprobleme", "oor met gehoorapparaat", "toeganklikheid"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጆሮ መስማት ከሚራዳ መሳሪያ ጋር"),
            keywords: &["መስማት መቸገር", "ተደረሽነት", "ጆሮ መስማት ከሚራዳ መሳሪያ ጋር"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أذن مع جهاز سمعي"),
            keywords: &[
                "أذن مع جهاز سمعي",
                "إمكانية الوصول",
                "احتياجات خاصة",
                "جهاز سمعي",
                "مساعدة سمعية",
            ],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("শ\u{9cd}ৰৱণ যন\u{9cd}ত\u{9cd}ৰ লগ\u{9be}ই থোৱ\u{9be} ক\u{9be}ণৰ ছবি"),
            keywords: &[
                "কল\u{9be}",
                "দিব\u{9cd}য\u{9be}ংগ",
                "শ\u{9cd}ৰৱণ যন\u{9cd}ত\u{9cd}ৰ লগ\u{9be}ই থোৱ\u{9be} ক\u{9be}ণৰ ছবি",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("eşitmə cihazlı qulaq"),
            keywords: &["eşitmə cihazlı qulaq", "eşitmə problemi"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вуха са слыхавым апаратам"),
            keywords: &[
                "асаблівыя фізічныя патрэбы",
                "вуха са слыхавым апаратам",
                "дрэнны слых",
                "інваліднасць",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("ухо със слухов апарат"),
            keywords: &["достъпност", "увреден слух", "ухо със слухов апарат"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9cd}রবণযন\u{9cd}ত\u{9cd}র সহ ক\u{9be}ন"),
            keywords: &[
                "অ\u{9cd}য\u{9be}ক\u{9cd}সেসিবিলিটি",
                "ক\u{9be}নে ক\u{9be}ল\u{9be}",
                "শ\u{9cd}রবণযন\u{9cd}ত\u{9cd}র সহ ক\u{9be}ন",
            ],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("uho sa slušnim aparatom"),
            keywords: &["otežan sluh", "pomagalo", "uho sa slušnim aparatom"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("orella amb audiòfon"),
            keywords: &[
                "accessibilitat",
                "orella amb audiòfon",
                "problema d’audició",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᎴᏂ ᎬᏗ ᎠᏛᎩᏍᎬ ᎬᏙᏗ"),
            keywords: &["ᎦᎴᏂ ᎬᏗ ᎠᏛᎩᏍᎬ ᎬᏙᏗ", "ᎬᏴᏍᏗ ᎨᏒᎢ", "ᏍᏔᏱ ᎤᏛᎪᏗ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ucho s naslouchátkem"),
            keywords: &[
                "handicap",
                "hendikep",
                "naslouchadlo",
                "nedoslýchavost",
                "pomůcka",
                "postižení",
                "ucho s naslouchátkem",
                "usnadnění",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("clust gyda chymorth clyw"),
            keywords: &["clust gyda chymorth clyw", "hygyrchedd", "trwm eu clyw"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("øre med høreapparat"),
            keywords: &["øre med høreapparat"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Ohr mit Hörgerät"),
            keywords: &[
                "Barrierefreiheit",
                "Hörgerät",
                "Hörhilfe",
                "Ohr mit Hörgerät",
                "gehörlos",
                "taub",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("αυτί με ακουστικό βαρηκοΐας"),
            keywords: &["αυτί με ακουστικό βαρηκοΐας", "βαρήκοος", "προσβασιμότητα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("ear with hearing aid"),
            keywords: &["accessibility", "ear with hearing aid", "hard of hearing"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("oreja con audífono"),
            keywords: &[
                "accesibilidad",
                "audífono",
                "oreja con audífono",
                "prótesis auditiva",
                "sordo",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("oreja con prótesis auditiva"),
            keywords: &[
                "accesibilidad",
                "audífono",
                "oreja con audífono",
                "oreja con prótesis auditiva",
                "prótesis auditiva",
                "sordo",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kuuldeaparaadiga kõrv"),
            keywords: &["juurdepääs", "kuuldeaparaadiga kõrv", "kuulmispuue"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("audifonoa duen belarria"),
            keywords: &["audifonoa duen belarria", "gortasuna", "irisgarritasuna"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("سمعک در گوش"),
            keywords: &["دسترس\u{200c}پذیری", "سمعک در گوش", "کم\u{200c}شنوایی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kuulolaite korvassa"),
            keywords: &[
                "esteettömyys",
                "huonokuuloinen",
                "kuulolaite",
                "kuulolaite korvassa",
                "kuulonalenema",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("tainga na may hearing aid"),
            keywords: &[
                "hirap makarinig",
                "pagiging naa-access",
                "tainga na may hearing aid",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("oyra við hoyritólið"),
            keywords: &["deyvur", "hoyritól", "oyra", "oyra við hoyritólið"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("oreille appareillée"),
            keywords: &[
                "accessibilité",
                "malentendant",
                "oreille appareillée",
                "prothèse auditive",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cluas le háis éisteachta"),
            keywords: &[
                "cluas le háis éisteachta",
                "deacrachtaí éisteachta",
                "inrochtaineacht",
            ],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cluas le claisteachan"),
            keywords: &[
                "bodhar",
                "claisneachd",
                "claisteachan",
                "cluas le claisteachan",
                "inneal-claisneachd",
                "inneal-cluinntinn",
                "so-ruigsinneachd",
                "èisteachd bheag",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("orella con audiófono"),
            keywords: &[
                "aparato auditivo",
                "discapacidade",
                "orella con audiófono",
                "xordo",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("શ\u{acd}રવણ ય\u{a82}ત\u{acd}રની સાથ\u{ac7} કાન"),
            keywords: &[
                "ઍક\u{acd}સ\u{ac7}સિબિલિટી",
                "ઓછ\u{ac1}\u{a82} સા\u{a82}ભળનાર\u{ac1}\u{a82}",
                "શ\u{acd}રવણ ય\u{a82}ત\u{acd}રની સાથ\u{ac7} કાન",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אוזן עם מכשיר שמיעה"),
            keywords: &[
                "אובדן שמיעה",
                "אוזן עם מכשיר שמיעה",
                "מכשיר שמיעה",
                "נגישות",
                "קשיי שמיעה",
            ],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("श\u{94d}रवण य\u{902}त\u{94d}र लगा कान"),
            keywords: &[
                "कान म\u{947}\u{902} मशीन",
                "श\u{94d}रवण य\u{902}त\u{94d}र",
                "श\u{94d}रवण य\u{902}त\u{94d}र लगा कान",
                "स\u{941}नन\u{947} की मशीन",
                "स\u{941}नन\u{947} म\u{947}\u{902} दिक\u{93c}\u{94d}क\u{93c}त",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("uho sa slušnim aparatom"),
            keywords: &["oštećen sluh", "pomagalo", "uho sa slušnim aparatom"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fül hallókészülékkel"),
            keywords: &["akadálymentesség", "fül hallókészülékkel", "nagyothalló"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լսողական ապարատով ականջ"),
            keywords: &["լսողական ապարատով ականջ", "խուլ", "հաշմանդամ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("aure con audiophono"),
            keywords: &[
                "accessibilitate",
                "aure con audiophono",
                "debile de audito",
                "dur de aure",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("telinga dengan alat bantu dengar"),
            keywords: &[
                "aksesibilitas",
                "sulit mendengar",
                "telinga dengan alat bantu dengar",
                "tuli",
                "tunarungu",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("eyra með heyrnartæki"),
            keywords: &[
                "aðgengileiki",
                "eyra með heyrnartæki",
                "heyrnarlaus",
                "heyrnarskerðing",
            ],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("orecchio con apparecchio acustico"),
            keywords: &[
                "accessibilità",
                "apparecchio acustico",
                "non udente",
                "non udenti",
                "orecchio con apparecchio acustico",
                "protesi acustica",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("補聴器を付けた耳"),
            keywords: &["アクセシビリティ", "耳", "聴覚", "補聴器を付けた耳"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("kuping sarwa piranti pangrungon"),
            keywords: &["budheg", "kalancaran", "kuping sarwa piranti pangrungon"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ყური სმენის აპარატით"),
            keywords: &[
                "სმენადაქვეითებული",
                "სმენის დარღვევის მქონე",
                "ყური სმენის აპარატით",
                "შშმ",
            ],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("есту аппараты бар құлақ"),
            keywords: &[
                "есту аппараты бар құлақ",
                "мүмкіндігі шектеулі",
                "нашар есту",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some(
                "ត\u{17d2}រចៀកពាក\u{17cb}ឧបករណ\u{17cd}ជ\u{17c6}ន\u{17bd}យការស\u{17d2}ដាប\u{17cb}",
            ),
            keywords: &[
                "ត\u{17d2}រចៀកពាក\u{17cb}ឧបករណ\u{17cd}ជ\u{17c6}ន\u{17bd}យការស\u{17d2}ដាប\u{17cb}",
                "មានការព\u{17b7}បាកក\u{17d2}ន\u{17bb}ងការស\u{17d2}ដាប\u{17cb}",
                "លទ\u{17d2}ធភាព\u{200b}ទទ\u{17bd}លបាន",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{ccd}ರವಣ ಯಂತ\u{ccd}ರ ಹೊಂದ\u{cbf}ರುವ ಕ\u{cbf}ವ\u{cbf}"),
            keywords: &[
                "ಆಲ\u{cbf}ಸಲು ಕಷ\u{ccd}ಟ",
                "ಪ\u{ccd}ರವೇಶ\u{cbf}ಸುವ\u{cbf}ಕ\u{cc6}",
                "ಶ\u{ccd}ರವಣ ಯಂತ\u{ccd}ರ ಹೊಂದ\u{cbf}ರುವ ಕ\u{cbf}ವ\u{cbf}",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("보청기를 낀 귀"),
            keywords: &["보청기를 낀 귀", "접근성", "청각장애"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("आयक\u{941}पाच\u{947}\u{902} य\u{902}त\u{94d}र बसयल\u{94d}लो कान"),
            keywords: &[
                "आयक\u{941}पाच\u{947}\u{902} य\u{902}त\u{94d}र बसयल\u{94d}लो कान",
                "ऍक\u{94d}स\u{945}सिबिलिटी। आयक\u{941}पाच\u{947}\u{902} य\u{902}त\u{94d}र बसयल\u{94d}लो कान। आयक\u{942}\u{902}क कठीण",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("угуу аппараты менен кулак"),
            keywords: &[
                "атайын мүмкүндүк",
                "угуу аппараты менен кулак",
                "угуу кыйынчылыгы",
            ],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some(
                "ຫ\u{eb9}\u{200b}\u{200b}ມ\u{eb5}ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ຊ\u{ec8}ວຍ\u{200b}ຟ\u{eb1}ງ",
            ),
            keywords: &[
                "ຄວາມ\u{200b}ສາ\u{200b}ມາດເຂ\u{ebb}\u{ec9}າ\u{200b}ເຖ\u{eb4}ງ",
                "ບ\u{ecd}\u{ec8}\u{200b}ໄດ\u{ec9}\u{200b}ຍ\u{eb4}ນ",
                "ຫ\u{eb9}\u{200b}\u{200b}ມ\u{eb5}ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ຊ\u{ec8}ວຍ\u{200b}ຟ\u{eb1}ງ",
                "ເຄ\u{eb7}\u{ec8}\u{200b}ອງ\u{200b}ຊ\u{ec8}ວຍ\u{200b}ຟ\u{eb1}ງ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("ausis su klausos aparatu"),
            keywords: &["ausis su klausos aparatu", "neprigirdintis", "prieinamumas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("auss ar dzirdes aparātu"),
            keywords: &[
                "apgrūtināta dzirde",
                "auss ar dzirdes aparātu",
                "pieejamība",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("уво со апарат за слушање"),
            keywords: &["уво со апарат за слушање"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ശ\u{d4d}രവണസഹ\u{d3e}യി വച\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചെവി"),
            keywords: &[
                "ആക\u{d4d}\u{200c}സസബിലിറ\u{d4d}റി",
                "കേൾവിത\u{d4d}തകര\u{d3e}റ\u{d4d}",
                "ശ\u{d4d}രവണസഹ\u{d3e}യി വച\u{d4d}ചിരിക\u{d4d}ക\u{d41}ന\u{d4d}ന ചെവി",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("сонсголын аппараттай чих"),
            keywords: &["сонсголын аппараттай чих", "сонсголын бэрхшээл", "хүртээмж"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("श\u{94d}रवणय\u{902}त\u{94d}र लावल\u{947}ला कान"),
            keywords: &[
                "अ\u{945}क\u{94d}स\u{947}सिबिलिटी",
                "कमी ऐक\u{942} य\u{947}ण\u{947}",
                "श\u{94d}रवणय\u{902}त\u{94d}र लावल\u{947}ला कान",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("telinga dengan alat bantu dengar"),
            keywords: &[
                "kebolehsampaian",
                "kesukaran mendengar",
                "telinga dengan alat bantu dengar",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("နားကြားက\u{102d}ရ\u{102d}ယာတပ\u{103a}ထားသော နား"),
            keywords: &[
                "နားကြားက\u{102d}ရ\u{102d}ယာတပ\u{103a}ထားသော နား",
                "နားမကြားသ\u{1030}",
                "အများအသ\u{102f}\u{1036}းပြ\u{102f}န\u{102d}\u{102f}င\u{103a}မ\u{103e}\u{102f}",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øre med høreapparat"),
            keywords: &["svak hørsel", "tilgjengelighet", "øre med høreapparat"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("स\u{941}न\u{94d}न\u{947} सहायकका साथ कान"),
            keywords: &[
                "उपलब\u{94d}धता",
                "स\u{941}न\u{94d}नमा समस\u{94d}या",
                "स\u{941}न\u{94d}न\u{947} सहायकका साथ कान",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oor met gehoorapparaat"),
            keywords: &["oor met gehoorapparaat", "slechthorend", "toegankelijkheid"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("øyre med høyreapparat"),
            keywords: &["svak høyrsel", "tilgjenge", "øyre med høyreapparat"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("କ\u{b3e}ନ ସହ\u{b3f}ତ ହ\u{b3f}ୟର\u{b3f}ଙ\u{b4d}ଗ ଏଡ\u{b4d}\u{200d}"),
            keywords: &[
                "ଅଭ\u{b3f}ଗମ\u{b4d}ୟତ\u{b3e}",
                "କମ ଶ\u{b4d}ରବଣ",
                "କ\u{b3e}ନ ସହ\u{b3f}ତ ହ\u{b3f}ୟର\u{b3f}ଙ\u{b4d}ଗ ଏଡ\u{b4d}\u{200d}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਸ\u{a41}ਣਨ ਵਾਲੀ ਮਸ\u{a3c}ੀਨ ਲ\u{a71}ਗਿਆ ਕ\u{a70}ਨ"),
            keywords: &[
                "ਪਹ\u{a41}\u{a70}ਚਯ\u{a4b}ਗਤਾ",
                "ਸ\u{a41}ਣਨ ਵਾਲੀ ਮਸ\u{a3c}ੀਨ ਲ\u{a71}ਗਿਆ ਕ\u{a70}ਨ",
                "ਸ\u{a41}ਣਨ ਵਿ\u{a71}ਚ ਸਮ\u{a71}ਸਿਆ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ia Wit Sọ\u{301}mtin Wé De Hẹ\u{301}lẹ\u{301}p Pẹ\u{301}sin Mék I Hia"),
            keywords: &[
                "Ia Wit Iá Hẹ\u{301}lẹp",
                "Ia Wit Sọ\u{301}mtin Wé De Hẹ\u{301}lẹ\u{301}p Pẹ\u{301}sin Mék I Hia",
                "Iá Hẹ\u{301}lẹp",
                "Ízí To Yuz",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ucho z aparatem słuchowym"),
            keywords: &["niedosłuch", "niedosłyszący", "ucho z aparatem słuchowym"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غوږ د اورېدنې د مرستې سره"),
            keywords: &["غوږ د اورېدنې د مرستې سره", "لاسرسی", "په غوږونو کوڼ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("ouvido com aparelho auditivo"),
            keywords: &[
                "acessibilidade",
                "deficiência auditiva",
                "ouvido com aparelho auditivo",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &[
                "acessibilidade",
                "deficiência auditiva",
                "orelha com aparelho auditivo",
                "ouvido com aparelho auditivo",
            ],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ninri uyarisqa yanapayniwan"),
            keywords: &[
                "haykurinalla",
                "ninri uyarisqa yanapayniwan",
                "pantasqa uyariypaq",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("ureche cu proteză auditivă"),
            keywords: &[
                "accesibilitate",
                "deficiențe auditive",
                "hipoacuzie",
                "ureche cu proteză auditivă",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E12–037"),
            keywords: &["E12–037"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("ухо со слуховым аппаратом"),
            keywords: &[
                "глухой",
                "глухота",
                "люди с ограниченными возможностями",
                "ограниченные возможности",
                "слабослышащий",
                "слух",
                "ухо со слуховым аппаратом",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ٻڌڻ جي آلي سان ڪن"),
            keywords: &["رسائي", "ٻڌڻ جي آلي سان ڪن", "ٻڌڻ ۾ مشڪل"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ශ\u{dca}\u{200d}රවණ\u{dcf}ධ\u{dcf}ර සහ\u{dd2}ත කන"),
            keywords: &[
                "ඇස\u{dd3}මට අම\u{dcf}ර\u{dd4}ය\u{dd2}",
                "ශ\u{dca}\u{200d}රවණ\u{dcf}ධ\u{dcf}ර සහ\u{dd2}ත කන",
                "ළඟ\u{dcf}ව\u{dd2}ය හැක\u{dd2} බව",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ucho s načúvadlom"),
            keywords: &[
                "handicap",
                "hendikep",
                "načúvadlo",
                "nedoslýchavosť",
                "pomôcka",
                "postihnutie",
                "ucho s načúvadlom",
                "uľahčenie",
            ],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("uho s slušnim aparatom"),
            keywords: &["naglušni", "okvara sluha", "uho s slušnim aparatom"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("dhag leh gargaarka maqalka"),
            keywords: &["dhag leh gargaarka maqalka", "la heli karo", "maqalka adag"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("vesh me aparat dëgjimi"),
            keywords: &["probleme dëgjimi", "qasshmëri", "vesh me aparat dëgjimi"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("уво са слушним апаратом"),
            keywords: &["приступачност", "тврд на уши", "уво са слушним апаратом"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("uvo sa slušnim aparatom"),
            keywords: &["pristupačnost", "tvrd na uši", "uvo sa slušnim aparatom"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öra med hörapparat"),
            keywords: &["öra med hörapparat"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("sikio lenye kifaa cha kusikia"),
            keywords: &[
                "sikio lenye kifaa cha kusikia",
                "tatizo la kutosikia vizuri",
                "ufikivu",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some(
                "செவித\u{bcd}துணைக\u{bcd} கருவி பொருத\u{bcd}தப\u{bcd}பட\u{bcd}டுள\u{bcd}ள க\u{bbe}து",
            ),
            keywords: &[
                "கேட\u{bcd}பதில\u{bcd} சிரமம\u{bcd}",
                "செவித\u{bcd}துணை",
                "செவித\u{bcd}துணைக\u{bcd} கருவி பொருத\u{bcd}தப\u{bcd}பட\u{bcd}டுள\u{bcd}ள க\u{bbe}து",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some(
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f} పర\u{c3f}కరం ప\u{c46}ట\u{c4d}ట\u{c3f}న చ\u{c46}వ\u{c3f}",
            ),
            keywords: &[
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f} పర\u{c3f}కరం ప\u{c46}ట\u{c4d}ట\u{c3f}న చ\u{c46}వ\u{c3f}",
                "వ\u{c3f}న\u{c3f}క\u{c3f}డ\u{c3f} సమస\u{c4d}య",
                "స\u{c4c}లభ\u{c4d}యం",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e39}ใส\u{e48}อ\u{e38}ปกรณ\u{e4c}ช\u{e48}วยฟ\u{e31}ง"),
            keywords: &[
                "การเข\u{e49}าถ\u{e36}ง",
                "ห\u{e39}ต\u{e36}ง",
                "ห\u{e39}ใส\u{e48}อ\u{e38}ปกรณ\u{e4c}ช\u{e48}วยฟ\u{e31}ง",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("eşidiş enjamly gulak"),
            keywords: &["elýeterlilik", "eşidiş enjamly gulak", "gulagy agyr"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("telinga moe meʻa fakafanongo"),
            keywords: &[
                "meʻa fakafanongo",
                "telinga",
                "telinga moe meʻa fakafanongo",
            ],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("işitme cihazı olan kulak"),
            keywords: &[
                "erişilebilirlik",
                "işitme cihazı olan kulak",
                "işitme güçlüğü",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("вухо зі слуховим апаратом"),
            keywords: &[
                "вади слуху",
                "вухо зі слуховим апаратом",
                "доступність",
                "спеціальні можливості",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آلہ سماعت کے ساتھ کان"),
            keywords: &["آلہ سماعت کے ساتھ کان", "دسترس", "کمزور سماعت"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("eshitish qurilmasi taqilgan quloq"),
            keywords: &[
                "eshitish qobiliyati past",
                "eshitish qurilmasi taqilgan quloq",
                "nogironlik",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("tai đeo thiết bị trợ thính"),
            keywords: &[
                "hỗ trợ",
                "hỗ trợ tiếp cận",
                "nặng tai",
                "tai đeo thiết bị trợ thính",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("戴助聽器嘅耳仔"),
            keywords: &["戴助聽器嘅耳仔", "無障礙", "聽障"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("戴助听器嘅耳仔"),
            keywords: &["听障", "戴助听器嘅耳仔", "无障碍"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("戴助听器的耳朵"),
            keywords: &[
                "助听器",
                "听力障碍",
                "失聪",
                "戴助听器的耳朵",
                "无障碍",
                "聋",
            ],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("戴助聽器的耳朵"),
            keywords: &["戴助聽器的耳朵", "聽障", "行動不便"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["戴助聽器的耳朵", "聽障", "身體殘障"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("indlebe enensiza yokuzwa"),
            keywords: &["indlebe enensiza yokuzwa", "ukufinyelela", "ukuzwa nzima"],
        },
    ],
};
#[doc = "🦻🏻"]
pub const EAR_WITH_HEARING_AID_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦻🏻",
    codepoint: "1F9BB 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ear with hearing aid: light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦻🏼"]
pub const EAR_WITH_HEARING_AID_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦻🏼",
    codepoint: "1F9BB 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ear with hearing aid: medium-light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦻🏽"]
pub const EAR_WITH_HEARING_AID_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦻🏽",
    codepoint: "1F9BB 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ear with hearing aid: medium skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦻🏾"]
pub const EAR_WITH_HEARING_AID_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦻🏾",
    codepoint: "1F9BB 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ear with hearing aid: medium-dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🦻🏿"]
pub const EAR_WITH_HEARING_AID_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "🦻🏿",
    codepoint: "1F9BB 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 12f32,
    name: "ear with hearing aid: dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👃"]
pub const NOSE: crate::Emoji = crate::Emoji {
    glyph: "👃",
    codepoint: "1F443",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "nose",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("neus"),
            keywords: &["liggaam", "neus"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፍንጫ"),
            keywords: &["አካል", "አፍንጫ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("أنف"),
            keywords: &["أنف", "جسم", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ন\u{9be}ক"),
            keywords: &["ন\u{9be}ক", "শৰীৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("burun"),
            keywords: &["burun", "bədən"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("нос"),
            keywords: &["нос", "нюх", "цела"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("нос"),
            keywords: &["нос", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ন\u{9be}ক"),
            keywords: &["ন\u{9be}ক", "শরীর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("fri"),
            keywords: &["fri"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("nos"),
            keywords: &["dio tijela", "nos"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("nas"),
            keywords: &["cos", "nas"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎧᏴᏐᎵ"),
            keywords: &["ᎥᏰᎸᎢ", "ᎧᏴᏐᎵ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("nos"),
            keywords: &["nos", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("trwyn"),
            keywords: &["corff", "trwyn"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("næse"),
            keywords: &["dufte", "krop", "lugte ansigt", "næse"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Nase"),
            keywords: &["Körperteil", "Nase"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μύτη"),
            keywords: &["μύτη", "σώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("nose"),
            keywords: &["body", "nose"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("nariz"),
            keywords: &["cuerpo", "nariz"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("nina"),
            keywords: &["keha", "nina"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("sudur"),
            keywords: &["gorputza", "sudur", "sudurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("بینی"),
            keywords: &["بدن", "بینی"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("nenä"),
            keywords: &["haju", "nenä", "pää", "tuoksu", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ilong"),
            keywords: &["ilong", "katawan"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("nøs"),
            keywords: &["kroppur", "nøs"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("nez"),
            keywords: &["corps", "nez"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("srón"),
            keywords: &["corp", "srón"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sròn"),
            keywords: &["bodhaig", "sròn"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("nariz"),
            keywords: &["nariz"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("નાક"),
            keywords: &["ચહ\u{ac7}રો", "નાક", "શરીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("hanci"),
            keywords: &["hanci", "jiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("אף"),
            keywords: &["אף", "להריח", "ריח"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("नाक"),
            keywords: &["च\u{947}हरा", "नाक", "शरीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("nos"),
            keywords: &["nos", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("orr"),
            keywords: &["fej", "orr", "test", "testrész"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("քիթ"),
            keywords: &["մարմին", "քիթ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("naso"),
            keywords: &["corpore", "naso"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("hidung"),
            keywords: &["badan", "hidung", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("imi"),
            keywords: &["imi", "àhụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("nef"),
            keywords: &["andlit", "líkami", "nef"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("naso"),
            keywords: &["corpo", "faccia", "naso"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("鼻"),
            keywords: &["からだ", "鼻"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("irung"),
            keywords: &["awak", "irung"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ცხვირი"),
            keywords: &["სხეული", "ტანი", "ცხვირი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("мұрын"),
            keywords: &["дене", "мұрын"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("næse"),
            keywords: &["dufte", "krop", "lugte ansigt", "næse"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ច\u{17d2}រម\u{17bb}ះ"),
            keywords: &["ច\u{17d2}រម\u{17bb}ះ", "ហ\u{17b7}ត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc2}ಗು"),
            keywords: &["ದೇಹ", "ಮ\u{cc2}ಗು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("코"),
            keywords: &["몸", "코"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("नाक"),
            keywords: &["क\u{942}ड", "नाक"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мурун"),
            keywords: &["дене", "мурун"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Nues"),
            keywords: &["Kierper", "Nues"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ດ\u{eb1}ງ"),
            keywords: &["ດ\u{eb1}ງ", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("nosis"),
            keywords: &["kūnas", "nosis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("deguns"),
            keywords: &["deguns", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ihu"),
            keywords: &["ihu", "tinana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("нос"),
            keywords: &["нос", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("മ\u{d42}ക\u{d4d}ക\u{d4d}"),
            keywords: &["മ\u{d42}ക\u{d4d}ക\u{d4d}", "ശരീരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хамар"),
            keywords: &["бие", "хамар"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("नाक"),
            keywords: &["नाक", "शरीर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("hidung"),
            keywords: &["badan", "hidung"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("imnieħer"),
            keywords: &["imnieħer", "ġisem"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}ာခေါင\u{103a}း"),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}ခန\u{1039}ဓာ",
                "နာခေါင\u{103a}း",
                "န\u{103e}ာခေါင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("nese"),
            keywords: &["fjes", "kropp", "nese"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("नाक"),
            keywords: &["नाक", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("neus"),
            keywords: &["lichaam", "neus"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("nase"),
            keywords: &["fjes", "kropp", "nase"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ନ\u{b3e}କ"),
            keywords: &["ନ\u{b3e}କ", "ଶରୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਨ\u{a71}ਕ"),
            keywords: &["ਚਿਹਰਾ", "ਨ\u{a71}ਕ", "ਸਰੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("نک"),
            keywords: &["جسم", "نک"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Noz"),
            keywords: &["Bọdí Pat", "Noz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("nos"),
            keywords: &["ciało", "nos"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("پوزه"),
            keywords: &["بدن", "پوزه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("nariz"),
            keywords: &["corpo", "nariz", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["corpo", "nariz"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("sinqa"),
            keywords: &["sinqa", "ukhu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("nas"),
            keywords: &["corp", "nas"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-512"),
            keywords: &["E10-512"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("нос"),
            keywords: &["нос", "тело", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("izuru"),
            keywords: &["igihimba", "izuru"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("نڪ"),
            keywords: &["جسم", "نڪ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("න\u{dcf}සය"),
            keywords: &["න\u{dcf}සය", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("nos"),
            keywords: &["nos", "telo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("nos"),
            keywords: &["nos", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sanka"),
            keywords: &["jirka", "sanka"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("hundë"),
            keywords: &["hundë", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("нос"),
            keywords: &["нос", "тело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["нос"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("nos"),
            keywords: &["nos", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["nos"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("näsa"),
            keywords: &["kropp", "näsa"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("pua"),
            keywords: &["mwili", "pua"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூக\u{bcd}கு"),
            keywords: &[
                "உடல\u{bcd}",
                "உடல\u{bcd} உறுப\u{bcd}பு",
                "முகம\u{bcd}",
                "மூக\u{bcd}கு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ముక\u{c4d}కు"),
            keywords: &["ముక\u{c4d}కు", "ముఖం", "శర\u{c40}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("бинӣ"),
            keywords: &["бадан", "бинӣ"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("จม\u{e39}ก"),
            keywords: &["จม\u{e39}ก", "ดม", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("burun"),
            keywords: &["burun", "göwre"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ihu"),
            keywords: &["ihu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("burun"),
            keywords: &["burun", "gövde", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("بۇرۇن"),
            keywords: &["بۇرۇن", "گەۋدە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("ніс"),
            keywords: &["ніс", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ناک"),
            keywords: &["جسم", "ناک"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("burun"),
            keywords: &["burun", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mũi"),
            keywords: &["cơ thể", "mũi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bakkan"),
            keywords: &["bakkan", "yaram"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("impumlo"),
            keywords: &["impumlo", "isiqu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Imu"),
            keywords: &["Ara", "Imu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("鼻"),
            keywords: &["身體", "鼻"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("鼻"),
            keywords: &["身体", "鼻"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("鼻子"),
            keywords: &["嗅", "闻", "鼻", "鼻子"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("鼻子"),
            keywords: &["身體部位", "鼻子"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("鼻"),
            keywords: &["身體部位", "鼻", "鼻子"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ikhala"),
            keywords: &["ikhala", "umzimba"],
        },
    ],
};
#[doc = "👃🏻"]
pub const NOSE_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👃🏻",
    codepoint: "1F443 1F3FB",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nose: light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👃🏼"]
pub const NOSE_MEDIUM_LIGHT_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👃🏼",
    codepoint: "1F443 1F3FC",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nose: medium-light skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👃🏽"]
pub const NOSE_MEDIUM_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👃🏽",
    codepoint: "1F443 1F3FD",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nose: medium skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👃🏾"]
pub const NOSE_MEDIUM_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👃🏾",
    codepoint: "1F443 1F3FE",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nose: medium-dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "👃🏿"]
pub const NOSE_DARK_SKIN_TONE: crate::Emoji = crate::Emoji {
    glyph: "👃🏿",
    codepoint: "1F443 1F3FF",
    status: crate::Status::FullyQualified,
    introduction_version: 1f32,
    name: "nose: dark skin tone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[],
};
#[doc = "🧠"]
pub const BRAIN: crate::Emoji = crate::Emoji {
    glyph: "🧠",
    codepoint: "1F9E0",
    status: crate::Status::FullyQualified,
    introduction_version: 5f32,
    name: "brain",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("brein"),
            keywords: &["brein", "intelligent"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አእምሮ"),
            keywords: &["አእምሮ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("دماغ"),
            keywords: &["دماغ", "ذكي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("মস\u{9cd}তিষ\u{9cd}ক"),
            keywords: &["ব\u{9c1}দ\u{9cd}ধিম\u{9be}ন", "মস\u{9cd}তিষ\u{9cd}ক"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("beyin"),
            keywords: &["beyin", "intelligent"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("мозг"),
            keywords: &["мозг", "разумны"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("мозък"),
            keywords: &["интелигентен", "мозък"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("মস\u{9cd}তিষ\u{9cd}ক"),
            keywords: &["ব\u{9c1}দ\u{9cd}ধিম\u{9be}ন", "মস\u{9cd}তিষ\u{9cd}ক"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("empenn"),
            keywords: &["empenn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("mozak"),
            keywords: &["inteligentan", "mozak"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cervell"),
            keywords: &["cervell", "intel·ligent"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᏅᏥᏓ"),
            keywords: &["ᎠᎧᎾᏗ", "ᎤᏅᏥᏓ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("mozek"),
            keywords: &["inteligence", "inteligentní", "mozek"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ymennydd"),
            keywords: &["deallus", "ymennydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerne"),
            keywords: &["hjerne", "intelligent"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Gehirn"),
            keywords: &["Gehirn", "intelligent"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μυαλό"),
            keywords: &["έξυπνος", "μυαλό"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("brain"),
            keywords: &["brain", "intelligent"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("cerebro"),
            keywords: &["cerebro", "inteligente"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("aju"),
            keywords: &["aju", "intelligentne"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("burmuin"),
            keywords: &["adimentsua", "argia", "azkarra", "burmuin", "burmuina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("مغز"),
            keywords: &["باهوش", "خردمند", "زیرک", "عاقل", "مغز"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("aivot"),
            keywords: &["aivot", "pää", "vartalo", "viisas", "äly"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("utak"),
            keywords: &["matalino", "utak"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("heili"),
            keywords: &["gløgg", "gløggur", "heili", "klók", "klókur", "kroppur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cerveau"),
            keywords: &["cerveau", "intelligent"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("inchinn"),
            keywords: &["inchinn", "éirimiúil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("eanchainn"),
            keywords: &["eanchainn", "glic", "tapaidh"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("cerebro"),
            keywords: &["cerebro", "intelixencia", "intelixente"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મગજ"),
            keywords: &["મગજ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ƙwaƙwalwa"),
            keywords: &["mai azanci", "ƙwaƙwalwa"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("מוח"),
            keywords: &["אינטליגנציה", "מוח", "שכל"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("मस\u{94d}तिष\u{94d}क, दिमाग"),
            keywords: &["ब\u{941}द\u{94d}धिमान", "मस\u{94d}तिष\u{94d}क, दिमाग"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("mozak"),
            keywords: &["inteligencija", "mozak"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("agy"),
            keywords: &["agy", "intelligens"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ուղեղ"),
            keywords: &["խելացի", "ուղեղ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("cerebro"),
            keywords: &["cerebro", "intelligente"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("otak"),
            keywords: &["cerdas", "genius", "kecerdasan", "otak", "pintar"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ụbụrụ"),
            keywords: &["amamiihe", "ụbụrụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("heili"),
            keywords: &["gáfur", "heili"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("cervello"),
            keywords: &["cervello", "intelligente"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("脳"),
            keywords: &["知識", "脳", "脳みそ", "頭"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("utek"),
            keywords: &["pinter", "utek"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ტვინი"),
            keywords: &["განათლებული", "ტვინი", "ჭკვიანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ми"),
            keywords: &["ми"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ខ\u{17bd}រក\u{17d2}បាល"),
            keywords: &["ខ\u{17bd}រក\u{17d2}បាល", "ឆ\u{17d2}លាតវៃ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc6}ದುಳು"),
            keywords: &["ಬುದ\u{ccd}ಧ\u{cbf}ವಂತ", "ಮ\u{cc6}ದುಳು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뇌"),
            keywords: &["뇌"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("म\u{947}\u{902}द\u{942}"),
            keywords: &["म\u{947}\u{902}द\u{942}", "ह\u{941}शारकाय"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("мээ"),
            keywords: &["акылдуу", "мээ"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Gehir"),
            keywords: &["Gehir", "intelligent"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ສະໝອງ"),
            keywords: &["ຄວາມສະຫ\u{ebc}າດ", "ສະໝອງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("smegenys"),
            keywords: &["protingas", "smegenys"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("smadzenes"),
            keywords: &["intelekts", "smadzenes"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("roro"),
            keywords: &["mōhio", "roro"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("мозок"),
            keywords: &["интелигентно", "мозок"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("തലച\u{d4d}ചോർ"),
            keywords: &["തലച\u{d4d}ചോർ", "വിവേകമ\u{d41}ള\u{d4d}ള"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("тархи"),
            keywords: &["тархи", "ухаантай"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("म\u{947}\u{902}द\u{942}"),
            keywords: &["म\u{947}\u{902}द\u{942}", "ह\u{941}शार"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("otak"),
            keywords: &["otak", "pintar"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("moħħ"),
            keywords: &["intelliġenti", "moħħ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ဦးန\u{103e}ောက\u{103a}"),
            keywords: &["အသ\u{102d}ဉာဏ\u{103a}", "ဦးန\u{103e}ောက\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjerne"),
            keywords: &["hjerne", "intelligent"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दिमाग"),
            keywords: &["तीक\u{94d}ष\u{94d}ण ब\u{941}द\u{94d}दी भएको", "दिमाग"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("brein"),
            keywords: &["brein", "intelligent"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjerne"),
            keywords: &["hjerne", "intelligent"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ମସ\u{b4d}ତ\u{b3f}ଷ\u{b4d}କ"),
            keywords: &[
                "ବ\u{b41}ଦ\u{b4d}ଧ\u{b3f}ମ\u{b3e}ନ",
                "ମସ\u{b4d}ତ\u{b3f}ଷ\u{b4d}କ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਿਮਾਗ"),
            keywords: &["ਦਿਮਾਗ", "ਸਮਝਦਾਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("دماغ"),
            keywords: &["دماغ", "ذہین"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bren"),
            keywords: &["Bren", "Gẹ\u{301}t Sẹns", "Sabí Buk", "Sẹns", "Waiz"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("mózg"),
            keywords: &["inteligentny", "mózg"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("مغز"),
            keywords: &["ذکاوت", "مغز"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("cérebro"),
            keywords: &["cérebro", "inteligente"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñuqtu"),
            keywords: &["umayuq", "ñuqtu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("creier"),
            keywords: &["creier", "inteligent"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-1137"),
            keywords: &["E10-1137"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("мозг"),
            keywords: &[
                "интеллигентный",
                "мозг",
                "мозги",
                "образованный",
                "ум",
                "умный",
            ],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("mutwe:"),
            keywords: &["mutwe:", "umunyabwenge"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دماغ"),
            keywords: &["دماغ", "هوشيار"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("මොළය"),
            keywords: &["බ\u{dd4}ද\u{dca}ධ\u{dd2}මත\u{dca}", "මොළය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("mozog"),
            keywords: &["bystrý", "inteligentný", "mozog"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("možgani"),
            keywords: &["inteligenca", "možgani"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("maskaxda"),
            keywords: &["caqli badan", "maskax", "maskaxda"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("tru"),
            keywords: &["i zgjuar", "inteligjent", "tru"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("мозак"),
            keywords: &["интелигентно", "мозак"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("mozak"),
            keywords: &["inteligentno", "mozak"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärna"),
            keywords: &["hjärna", "klok"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ubongo"),
            keywords: &["mwerevu", "ubongo"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("மூளை"),
            keywords: &["அறிவு", "புத\u{bcd}திச\u{bbe}லித\u{bcd}தனம\u{bcd}", "மூளை"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("మ\u{c46}దడు"),
            keywords: &["మ\u{c46}దడు", "మ\u{c47}ధ\u{c3e}వ\u{c3f}"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("майнаи сар"),
            keywords: &["доно", "майнаи сар"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("สมอง"),
            keywords: &["ฉลาด", "สมอง"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("beýin"),
            keywords: &["akylly", "beýin"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻuto"),
            keywords: &["ʻuto"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("beyin"),
            keywords: &["beyin", "zeki"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("مېڭە"),
            keywords: &["ئەقىللىق", "مېڭە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("мозок"),
            keywords: &["мозок", "інтелігент"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دماغ"),
            keywords: &["دماغ", "ذہین"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("miya"),
            keywords: &["miya"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("não"),
            keywords: &["não", "thông minh"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("yuur"),
            keywords: &["muus", "yuur"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ubuchopho"),
            keywords: &["ubuchopho", "ukrelekrele"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("ọpọlọ"),
            keywords: &["ọmọwé", "ọpọlọ"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("腦"),
            keywords: &["智力", "腦"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("脑"),
            keywords: &["智力", "脑"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("脑"),
            keywords: &["大脑", "头脑", "智慧", "智能", "脑"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("腦"),
            keywords: &["聰明", "腦"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ubuchopho"),
            keywords: &["hlakaniphile", "ubuchopho"],
        },
    ],
};
#[doc = "🫀"]
pub const ANATOMICAL_HEART: crate::Emoji = crate::Emoji {
    glyph: "🫀",
    codepoint: "1FAC0",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "anatomical heart",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("orgaanhart"),
            keywords: &[
                "hart",
                "hartklop",
                "kardiologie",
                "orgaan",
                "orgaanhart",
                "pols",
            ],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("የልብ አካል"),
            keywords: &["የልብ አካል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عضو القلب"),
            keywords: &["دقات القلب", "طب القلب", "عضو", "عضو القلب", "نبض", "وسط"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "অংগ",
                "শ\u{9be}ৰীৰিক",
                "স\u{9cd}পন\u{9cd}দন",
                "হ\u{9c3}দয\u{9bc}",
                "হ\u{9c3}দয\u{9bc} বিজ\u{9cd}ঞ\u{9be}ন",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ürək"),
            keywords: &["mərkəz", "orqan", "puls", "ürək", "ürək döyüntüsü"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("сэрца"),
            keywords: &[
                "кардыялогія",
                "орган",
                "пульс",
                "сэрца",
                "сэрцабіцце",
                "цэнтр",
            ],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("сърце"),
            keywords: &[
                "анатомия",
                "кардиология",
                "орган",
                "пулс",
                "сърдечен ритъм",
                "сърце",
            ],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9c3}দয\u{9bc}"),
            keywords: &[
                "অঙ\u{9cd}গ",
                "কেন\u{9cd}দ\u{9cd}র",
                "প\u{9be}ল\u{9cd}স",
                "হ\u{9c3}দয\u{9bc}",
                "হ\u{9c3}দিবিজ\u{9cd}ঞ\u{9be}ন",
                "হ\u{9c3}ৎস\u{9cd}পন\u{9cd}দন",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("kalon"),
            keywords: &["kalon"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("srce organ"),
            keywords: &[
                "centar",
                "kardiologija",
                "organ",
                "otkucaj srca",
                "puls",
                "srce organ",
            ],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("cor"),
            keywords: &["batec", "cardiologia", "cor", "pols", "òrgan"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎤᎿᏫ"),
            keywords: &["ᎠᏰᎸ", "ᎠᏰᏟ", "ᎤᎿᏫ", "ᏧᏩᏚᏃᎯ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("srdeční orgán"),
            keywords: &[
                "kardiologie",
                "puls",
                "pulz",
                "srdce",
                "srdeční orgán",
                "tep",
                "tlukot",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("Y galon"),
            keywords: &[
                "Y galon",
                "canol",
                "cardioleg",
                "curiad y galon",
                "organ",
                "pwlse",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("hjerte"),
            keywords: &["centrum", "hjerte", "hjerteslag", "organ", "puls"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Herz (Organ)"),
            keywords: &[
                "Herz",
                "Herz (Organ)",
                "Herzschlag",
                "Mitte",
                "Organ",
                "Puls",
                "pulsieren",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("καρδιά"),
            keywords: &[
                "ανατομία",
                "καρδιά",
                "καρδιολογία",
                "παλμοί",
                "σφυγμός",
                "όργανο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("anatomical heart"),
            keywords: &["anatomical", "cardiology", "heart", "organ", "pulse"],
        },
        #[cfg(feature = "en_001")]
        crate::Annotation {
            lang: "en_001",
            tts: None,
            keywords: &["anatomical heart", "cardiology", "heart", "organ", "pulse"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["anatomical heart", "cardiology", "heart", "organ", "pulse"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("corazón humano"),
            keywords: &[
                "anatómico",
                "centro",
                "corazón humano",
                "latido",
                "núcleo",
                "pulso",
                "órgano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("órgano cardíaco"),
            keywords: &[
                "cardiología",
                "centro",
                "latido",
                "pulso",
                "órgano",
                "órgano cardíaco",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("süda"),
            keywords: &["keskpunkt", "organ", "pulss", "süda", "südamelöök"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("bihotza organoa"),
            keywords: &[
                "bihotza organoa",
                "erdigunea",
                "kardiologia",
                "organoa",
                "pultsua",
                "taupada",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("قلب"),
            keywords: &["اندام", "ضربان قلب", "قلب", "مرکز", "نبض"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("sydän"),
            keywords: &[
                "elin",
                "kardiologia",
                "pulssi",
                "sydän",
                "syke",
                "verenkierto",
            ],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("puso"),
            keywords: &["organ", "pulso", "puso", "tibok ng puso"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("hjarta"),
            keywords: &["hjarta", "hjartasláttur", "pulsur", "yrkisgagn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("cœur"),
            keywords: &[
                "battements",
                "cardiologie",
                "cœur",
                "organe",
                "pouls",
                "pulsation",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("cœur"),
            keywords: &[
                "battement de coeur",
                "cardiologie",
                "cœur",
                "organe",
                "pouls",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("croí anatamaíoch"),
            keywords: &["anatamaíoch", "ball", "cairdeolaíocht", "croí", "cuisle"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cridhe"),
            keywords: &[
                "buille cridhe",
                "buille-chuisle",
                "cridhe",
                "cuisle",
                "meadhan",
                "organ",
                "plosgadh cridhe",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("órgano corazón"),
            keywords: &[
                "cardioloxía",
                "centro",
                "corazón",
                "pulso",
                "órgano corazón",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હ\u{ac3}દય અ\u{a82}ગ"),
            keywords: &[
                "અ\u{a82}ગ",
                "કાર\u{acd}ડિયોલોજી",
                "ક\u{ac7}\u{a82}દ\u{acd}ર",
                "ધબકારા",
                "નાડી",
                "હ\u{ac3}દય",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לב"),
            keywords: &["דופק", "לב", "מרכז", "פעימות לב"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("ह\u{943}दय अ\u{902}ग"),
            keywords: &[
                "अ\u{902}ग",
                "क\u{947}\u{902}द\u{94d}र",
                "दिल की धड\u{93c}कन",
                "धड\u{93c}कन",
                "ह\u{943}दय अ\u{902}ग",
                "ह\u{943}दयरोग विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("anatomsko srce"),
            keywords: &[
                "anatomski",
                "anatomsko srce",
                "kardiologija",
                "organ",
                "puls",
                "srce",
            ],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szív"),
            keywords: &[
                "kardiológia",
                "középpont",
                "pulzus",
                "szerv",
                "szív",
                "szívverés",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("սիրտ օրգան"),
            keywords: &[
                "զարկ",
                "զարկերակ",
                "կենտրոն",
                "սիրտ օրգան",
                "սրտաբանություն",
                "օրգան",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("corde"),
            keywords: &[
                "battimento del corde",
                "centro",
                "corde",
                "organo",
                "pulsation cardiac",
                "pulsation del corde",
                "rhythmo cardiac",
                "rhythmo del corde",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("organ jantung"),
            keywords: &["detak", "jantung", "kardiologi", "nadi", "organ", "tengah"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("hjartavöðvi"),
            keywords: &["hjartavöðvi", "hjartsláttur", "líffæri", "miðja", "púls"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("organo del cuore"),
            keywords: &[
                "battito",
                "cardiologia",
                "cuore",
                "organo",
                "organo del cuore",
                "pulsazione",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("心臓"),
            keywords: &["心拍", "心臓", "脈", "臓器", "鼓動"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("jantung"),
            keywords: &["anatomi", "deg-degan", "jantung", "kardiologi", "organ"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("გული"),
            keywords: &["გული", "გულისცემა", "ორგანო", "პულსი", "ცენტრი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("жүрек органы"),
            keywords: &["жүрек", "жүрек органы", "кардиология", "орган", "пульс"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("គ\u{17d2}រឿងក\u{17d2}ន\u{17bb}ងបេះដ\u{17bc}ង"),
            keywords: &[
                "កណ\u{17d2}ដាល",
                "គ\u{17d2}រឿងក\u{17d2}ន\u{17bb}ង",
                "គ\u{17d2}រឿងក\u{17d2}ន\u{17bb}ងបេះដ\u{17bc}ង",
                "ចង\u{17d2}វាក\u{17cb}បេះដ\u{17bc}ង",
                "ជ\u{17b8}ពចរ",
                "ហទយវ\u{17b7}ទ\u{17d2}យា\u{200b}",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹೃದಯ ಅಂಗ"),
            keywords: &[
                "ಅಂಗ",
                "ಕೇಂದ\u{ccd}ರ",
                "ನಾಡ\u{cbf}",
                "ಹೃದಯ ಅಂಗ",
                "ಹೃದಯ ಬಡ\u{cbf}ತ",
                "ಹೃದಯವ\u{cbf}ಜ\u{ccd}ಞಾನ",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("심장"),
            keywords: &["맥박", "심장", "심장학", "장기", "해부학"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("काळजाच\u{947} अवयव"),
            keywords: &[
                "अवयव। कार\u{94d}डिओलॉजी। काळीज। ऑर\u{94d}गन। नाडी",
                "काळजाच\u{947} अवयव",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("жүрөк"),
            keywords: &["жүрөк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ອະໄວຍະວະຫ\u{ebb}ວໃຈ"),
            keywords: &[
                "ການເຕ\u{eb1}\u{ec9}ນຂອງຫ\u{ebb}ວໃຈ",
                "ຊ\u{eb5}ບພະຈອນ",
                "ທາງກາງ",
                "ອະໄວຍະວະ",
                "ອະໄວຍະວະຫ\u{ebb}ວໃຈ",
                "ໂລກຫ\u{ebb}ວໃຈ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("širdis"),
            keywords: &["centras", "organas", "pulsas", "širdies plakimas", "širdis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("cilvēka sirds"),
            keywords: &[
                "cilvēka sirds",
                "kardioloģija",
                "orgāns",
                "pulss",
                "sirdspuksti",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("срцев орган"),
            keywords: &[
                "кардиологија",
                "орган",
                "пулс",
                "срцебиење",
                "срцев орган",
                "центар",
            ],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ഹ\u{d43}ദയഘടന"),
            keywords: &[
                "അവയവം",
                "ക\u{d3e}ർഡിയോളജി",
                "ഘടന\u{d3e}പരം",
                "ഹ\u{d43}ദയം",
                "ഹ\u{d43}ദയഘടന",
                "ഹ\u{d43}ദയത\u{d3e}ളം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("зүрх"),
            keywords: &[
                "анатомийн",
                "зүрх",
                "зүрхний өвчин судлал",
                "судасны цохилт",
                "эрхтэн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("ह\u{943}दय अवयव"),
            keywords: &[
                "अवयव",
                "क\u{947}\u{902}द\u{94d}र",
                "स\u{94d}प\u{902}दन",
                "ह\u{943}दय अवयव",
                "ह\u{943}दय गती",
                "ह\u{943}दयास\u{902}ब\u{902}धित शास\u{94d}त\u{94d}र",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("organ jantung"),
            keywords: &["anatomi", "degupan", "jantung", "kardiolagi", "organ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("န\u{103e}လ\u{102f}\u{1036}း"),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}ခန\u{1039}ဓာအစ\u{102d}တ\u{103a}အပ\u{102d}\u{102f}င\u{103a}း",
                "န\u{103e}လ\u{102f}\u{1036}း",
                "န\u{103e}လ\u{102f}\u{1036}းန\u{103e}င\u{1037}\u{103a}ဆ\u{102d}\u{102f}င\u{103a}သော",
                "သ\u{103d}ေးခ\u{102f}န\u{103a}န\u{103e}\u{102f}န\u{103a}း",
                "အင\u{103a}\u{1039}ဂါ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("hjertemuskel"),
            keywords: &[
                "hjerte-kar",
                "hjertemuskel",
                "hjerteslag",
                "kardiologi",
                "muskel",
                "organ",
                "puls",
                "senter",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ट\u{941} इन\u{94d}द\u{94d}रिय"),
            keywords: &[
                "अङ\u{94d}ग",
                "नाडी",
                "म\u{941}ट\u{941}",
                "म\u{941}ट\u{941} इन\u{94d}द\u{94d}रिय",
                "शरीर रचनात\u{94d}मक",
                "ह\u{943}दय विज\u{94d}ञान",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("hart"),
            keywords: &["centrum", "hart", "hartslag", "orgaan", "polsslag"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("hjartemuskel"),
            keywords: &[
                "hjarte-kar",
                "hjartemuskel",
                "hjarteslag",
                "kardiologi",
                "muskel",
                "organ",
                "puls",
                "senter",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b43}ଦୟ ଜନନେଦ\u{b4d}ର\u{b3f}ୟ"),
            keywords: &[
                "ଅଙ\u{b4d}ଗପ\u{b4d}ରତ\u{b4d}ୟଙ\u{b4d}ଗ",
                "ନ\u{b3e}ଡୀରସ\u{b4d}ପଦନ",
                "ମଧ\u{b4d}ୟ",
                "ହ\u{b43}ଦତତ\u{b4d}ତ\u{b4d}ୱ",
                "ହ\u{b43}ଦୟ ଜନନେଦ\u{b4d}ର\u{b3f}ୟ",
                "ହ\u{b43}ଦୟସ\u{b4d}ପଦନ",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦਿਲ ਦ\u{a47} ਅ\u{a70}ਗ"),
            keywords: &[
                "ਅ\u{a70}ਗ",
                "ਦਿਲ ਦੀ ਧੜਕਣ",
                "ਦਿਲ ਦ\u{a47} ਅ\u{a70}ਗ",
                "ਨਬਜ\u{a3c}",
                "ਸ\u{a48}\u{a02}ਟਰ",
                "ਹਿਰਦਾ-ਵਿਗਿਆਨ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("As Pẹ\u{301}sin Hat Bì"),
            keywords: &[
                "As Pẹ\u{301}sin Bọdí Bì",
                "As Pẹ\u{301}sin Hat Bì",
                "As Pẹ\u{301}sin Hat De Bit",
                "Bọ\u{301}dí Pat Ínsaíd Yọ Bọdí",
                "Hat",
                "Hátbit",
            ],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("serce"),
            keywords: &[
                "anatomia",
                "bicie serca",
                "kardiologia",
                "mięsień sercowy",
                "narząd",
                "organ",
                "puls",
                "serce",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("د زړه عضو"),
            keywords: &[
                "د زړه درزا",
                "د زړه عضو",
                "د زړونو پوهه",
                "درزا",
                "عضو",
                "مرکز",
            ],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("coração humano"),
            keywords: &[
                "cardiologia",
                "centro",
                "coração humano",
                "pulsação",
                "pulso",
                "órgão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("anatomico sunqu"),
            keywords: &["anatomico", "cardiologia", "organo", "pulso", "sunqu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("inimă"),
            keywords: &["anatomic", "cardiologie", "inimă", "organ", "puls"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-005"),
            keywords: &["E13-005"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("сердце человека"),
            keywords: &[
                "кардиология",
                "орган",
                "пульс",
                "сердце",
                "сердце человека",
                "центр",
            ],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("دل عضوو"),
            keywords: &["دل جلن", "دل عضوو", "سينٽر", "عضوو", "پلس", "ڪارڊيولاجي"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("හෘද ඉන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ය"),
            keywords: &[
                "ඉන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ය",
                "ස\u{dca}පන\u{dca}දනය",
                "හෘද ඉන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ය",
                "හෘද ව\u{dd2}ද\u{dca}\u{200d}ය\u{dcf}ව",
                "හෘද ස\u{dca}පන\u{dca}දනය",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("orgán srdca"),
            keywords: &["kardiológia", "orgán", "orgán srdca", "pulz", "srdce"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("človeško srce"),
            keywords: &[
                "kardiologija",
                "organ",
                "srce",
                "srčni utrip",
                "utrip",
                "človeško",
            ],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("garaaca wadnaha"),
            keywords: &[
                "garaaca wadnaha",
                "garaaca wadnaha, dawada wadnaha, wadnaha, xubin, wadna garaaca",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("zemër"),
            keywords: &["anatomik", "kardiologji", "organ", "puls", "zemër"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("анатомско срце"),
            keywords: &[
                "анатомски",
                "анатомско срце",
                "кардиологија",
                "орган",
                "пулс",
                "срце",
            ],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("анатомско срце"),
            keywords: &["анатомско срце"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("anatomsko srce"),
            keywords: &[
                "anatomski",
                "anatomsko srce",
                "kardiologija",
                "organ",
                "puls",
                "srce",
            ],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: Some("anatomsko srce"),
            keywords: &["anatomsko srce"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("hjärta"),
            keywords: &["hjärta", "kardiologi", "organ", "puls"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("moyo"),
            keywords: &[
                "kadiolojia",
                "katikati",
                "mapigo ya moyo",
                "moyo",
                "pigo la moyo",
                "sehemu ya mwili",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("இதய உறுப\u{bcd}பு"),
            keywords: &[
                "இதய உறுப\u{bcd}பு",
                "இதயத\u{bcd}துடிப\u{bcd}பு",
                "இதயவியல\u{bcd}",
                "உறுப\u{bcd}பு",
                "துடிப\u{bcd}பு",
                "மையம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("గుండ\u{c46}ల\u{c4b}న\u{c3f} భ\u{c3e}గం"),
            keywords: &[
                "క\u{c3e}ర\u{c4d}డ\u{c3f}య\u{c3e}లజ\u{c40}",
                "గుండ\u{c46}ల\u{c4b}న\u{c3f} భ\u{c3e}గం",
                "న\u{c3e}డ\u{c3f}",
                "భ\u{c3e}గం",
                "మధ\u{c4d}యభ\u{c3e}గం",
                "హృదయ స\u{c4d}పందన",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ห\u{e31}วใจ"),
            keywords: &[
                "กายว\u{e34}ภาค",
                "ช\u{e35}พจร",
                "หท\u{e31}ยว\u{e34}ทยา",
                "ห\u{e31}วใจ",
                "ห\u{e31}วใจเต\u{e49}น",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("ýürek"),
            keywords: &["merkez", "organ", "puls", "ýürek", "ýürek urşy"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("mafu"),
            keywords: &["mafu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kalp"),
            keywords: &[
                "kalp",
                "kalp atışı",
                "kardiyoloji",
                "merkez",
                "nabız",
                "organ",
            ],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("серце"),
            keywords: &[
                "кардіологія",
                "орган",
                "пульс",
                "серце",
                "серцебиття",
                "центр",
            ],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دل کا عضو"),
            keywords: &["دل", "دل کا عضو", "دل کی دھڑکن", "عضو", "نبض"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("yurak"),
            keywords: &[
                "aʼzo",
                "markaz",
                "puls",
                "tomir urishi",
                "yurak",
                "yurak urishi",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("cơ quan tim"),
            keywords: &[
                "cơ quan",
                "cơ quan tim",
                "khoa tim mạch",
                "nhịp tim",
                "trung tâm",
            ],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("心臟"),
            keywords: &["中心", "器官", "心臟", "心跳", "脈衝"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("心脏"),
            keywords: &["中心", "器官", "心脏", "心跳", "脉冲"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("心脏器官"),
            keywords: &["中心", "器官", "心率", "心脏器官", "心脏病学", "心跳"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("心臟"),
            keywords: &["器官", "心臟", "心跳", "脈搏"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("isitho senhliziyo"),
            keywords: &[
                "i-cardiology",
                "i-pulse",
                "isitho",
                "isitho senhliziyo",
                "phakathi nendawo",
                "ukushaya kwenhliziyo",
            ],
        },
    ],
};
#[doc = "🫁"]
pub const LUNGS: crate::Emoji = crate::Emoji {
    glyph: "🫁",
    codepoint: "1FAC1",
    status: crate::Status::FullyQualified,
    introduction_version: 13f32,
    name: "lungs",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("longe"),
            keywords: &["asem", "asemhaal", "inasem", "longe", "orgaan", "uitasem"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ሳንባ"),
            keywords: &["ሳንባ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("رئتان"),
            keywords: &["تنف\u{651}س", "جهاز التنفس", "رئتان", "زفير", "شهيق", "عضو"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}ও\u{981}ফ\u{9be}ও\u{981}"),
            keywords: &[
                "অংগ",
                "উশ\u{9be}হ",
                "শ\u{9cd}বসন",
                "শ\u{9cd}ব\u{9be}সগ\u{9cd}ৰহণ",
                "শ\u{9cd}ব\u{9be}সত\u{9cd}য\u{9be}গ",
                "হ\u{9be}ও\u{981}ফ\u{9be}ও\u{981}",
            ],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağciyərlər"),
            keywords: &[
                "ağciyərlər",
                "nəfəs",
                "nəfəsalma",
                "nəfəsvermə",
                "orqan",
                "tərləmə",
            ],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("лёгкія"),
            keywords: &["выдых", "дыханне", "лёгкія", "орган", "подых", "удых"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("дробове"),
            keywords: &["вдишване", "дишане", "дробове", "дъх", "издишване", "орган"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("শ\u{9cd}ব\u{9be}সযন\u{9cd}ত\u{9cd}র"),
            keywords: &[
                "অঙ\u{9cd}গ",
                "প\u{9cd}রশ\u{9cd}ব\u{9be}স",
                "শ\u{9cd}ব\u{9be}স",
                "শ\u{9cd}ব\u{9be}সত\u{9cd}য\u{9be}গ",
                "শ\u{9cd}ব\u{9be}সযন\u{9cd}ত\u{9cd}র",
            ],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("skevent"),
            keywords: &["skevent"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("pluća"),
            keywords: &["dah", "disanje", "izdisaj", "organ", "pluća", "udisaj"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("pulmons"),
            keywords: &[
                "exhalació",
                "inhalació",
                "pulmons",
                "respiració",
                "respirar",
                "òrgan",
            ],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᏛᎵᏗᏍᏙᏗᎢ"),
            keywords: &["ᎠᏰᎸ", "ᎧᏬᎳᏕᏛ", "ᎭᏫᏂ", "ᏗᏛᎵᏗᏍᏙᏗᎢ", "ᏙᏱ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("plíce"),
            keywords: &[
                "dech",
                "dýchání",
                "nádech",
                "orgán",
                "plíce",
                "respirace",
                "výdech",
            ],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("Yr ysgyfaint"),
            keywords: &[
                "Yr ysgyfaint",
                "allanadliad",
                "anadl",
                "anadlu",
                "mewnanadliad",
                "organ",
            ],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("lunger"),
            keywords: &[
                "indånding",
                "lunger",
                "organ",
                "respiration",
                "udånding",
                "vejrtrækning",
                "ånde",
                "åndedræt",
            ],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Lunge"),
            keywords: &[
                "Atem",
                "Lunge",
                "Lungenflügel",
                "Organ",
                "atmen",
                "ausatmen",
                "einatmen",
            ],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("πνεύμονες"),
            keywords: &[
                "ανάσα",
                "αναπνοή",
                "εισπνοή",
                "εκπνοή",
                "πνεύμονες",
                "όργανο",
            ],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("lungs"),
            keywords: &[
                "breath",
                "exhalation",
                "inhalation",
                "lungs",
                "organ",
                "respiration",
            ],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("pulmones"),
            keywords: &[
                "exhalar",
                "inhalar",
                "pulmones",
                "respiración",
                "respirar",
                "órgano",
            ],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("pulmones"),
            keywords: &[
                "aliento",
                "exhalación",
                "inhalación",
                "pulmones",
                "respiración",
                "órgano",
            ],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("pulmones"),
            keywords: &["pulmones"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kopsud"),
            keywords: &[
                "hingamine",
                "hingetõmme",
                "kopsud",
                "organ",
                "sissehingamine",
                "väljahingamine",
            ],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("birikak"),
            keywords: &[
                "arnas hartzea",
                "arnasa",
                "arnastu",
                "birikak",
                "hasperena",
                "inhalazioa",
                "organoa",
            ],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("ریه"),
            keywords: &["اندام", "بازدم", "تنفس", "دم", "ریه"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("keuhkot"),
            keywords: &["elin", "hengitys", "henkäisy", "keuhkot"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("baga"),
            keywords: &[
                "baga",
                "organ",
                "pagbuga ng hangin",
                "paghinga",
                "pagsinghot ng hangin",
            ],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("lungur"),
            keywords: &["andadráttur", "lungur", "yrkisgagn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("poumons"),
            keywords: &[
                "expiration",
                "inspiration",
                "organe",
                "poumons",
                "respiration",
                "souffle",
            ],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("poumons"),
            keywords: &[
                "expiration",
                "inspiration",
                "organe",
                "poumons",
                "respiration",
                "respirer",
            ],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("scámhóga"),
            keywords: &["anáil", "ball", "scámhóga"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sgamhan"),
            keywords: &[
                "anail",
                "analachadh",
                "analachd",
                "organ",
                "sgaman",
                "sgamhan",
            ],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("pulmóns"),
            keywords: &[
                "exhalación",
                "inhalación",
                "pulmóns",
                "respiración",
                "órgano",
            ],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("ફ\u{ac7}ફ\u{acd}સા\u{a82}"),
            keywords: &[
                "અ\u{a82}ગ",
                "ફ\u{ac7}ફ\u{acd}સા\u{a82}",
                "શ\u{acd}વાસ",
                "શ\u{acd}વાસ બહાર કાઢવો",
                "શ\u{acd}વાસ લ\u{ac7}વો",
                "શ\u{acd}વાસોચ\u{acd}છ\u{acd}વાસની પ\u{acd}રક\u{acd}રિયા",
            ],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("ריאות"),
            keywords: &["מערכת הנשימה", "נשימה", "ריאה", "ריאות"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("फ\u{947}फड\u{93c}ा"),
            keywords: &[
                "अ\u{902}ग",
                "फ\u{947}फड\u{93c}ा",
                "श\u{94d}वसन",
                "सा\u{902}स",
                "सा\u{902}स खी\u{902}चना",
                "सा\u{902}स छोड\u{93c}ना",
            ],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("pluća"),
            keywords: &["dah", "disanje", "izdisanje", "organ", "pluća", "udisanje"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("tüdő"),
            keywords: &[
                "belégzés",
                "kilégzés",
                "légzés",
                "lélegzet",
                "szerv",
                "tüdő",
            ],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("թոքեր"),
            keywords: &[
                "արտաշնչել",
                "թոքեր",
                "ներշնչել",
                "շնչառություն",
                "շունչ",
                "օրգան",
            ],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("pulmones"),
            keywords: &[
                "exhalation",
                "halito",
                "inhalation",
                "organo",
                "pulmones",
                "respiration",
                "sufflo",
                "suspiro",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("paru-paru"),
            keywords: &[
                "ekshalasi",
                "inhalasi",
                "napas",
                "organ",
                "paru-paru",
                "respirasi",
            ],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("lungu"),
            keywords: &["anda", "innöndun", "lungu", "líffæri", "öndun", "útöndun"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("polmoni"),
            keywords: &[
                "espirazione",
                "inspirazione",
                "organo",
                "polmoni",
                "respirazione",
                "respiro",
            ],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("肺"),
            keywords: &["呼吸", "肺", "臓器"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("paru"),
            keywords: &[
                "ambegan",
                "ngetokake ambegan",
                "nglebokake ambegan",
                "organ",
                "paru",
                "respirasi",
            ],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ფილტვები"),
            keywords: &["ამოსუნთქვა", "ორგანო", "სუნთქვა", "ფილტვები", "ჩასუნთქვა"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("өкпе"),
            keywords: &[
                "ауа жұту",
                "орган",
                "респирация",
                "тыныс",
                "тыныс алу",
                "өкпе",
            ],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ស\u{17bd}ត"),
            keywords: &[
                "ការដកដង\u{17d2}ហើម",
                "ការដកដង\u{17d2}ហើមច\u{17bc}ល",
                "ការដកដង\u{17d2}ហើមចេញ",
                "គ\u{17d2}រឿងក\u{17d2}ន\u{17bb}ង",
                "ដង\u{17d2}ហើម",
                "ស\u{17bd}ត",
            ],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಶ\u{ccd}ವಾಶಕೋಶಗಳು"),
            keywords: &[
                "ಅಂಗ",
                "ಉಚ\u{ccd}ವಾಸ",
                "ಉಸ\u{cbf}ರಾಟ",
                "ಉಸ\u{cbf}ರು",
                "ನ\u{cbf}ಶ\u{ccd}ವಾಸ",
                "ಶ\u{ccd}ವಾಶಕೋಶಗಳು",
            ],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("폐"),
            keywords: &["내쉬기", "들이마시기", "숨", "장기", "폐", "호흡"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("फ\u{941}फ\u{942}स"),
            keywords: &[
                "फ\u{941}फ\u{942}स",
                "स\u{94d}वास। स\u{94d}वासोच\u{94d}छवास। स\u{94d}वास घ\u{947}वप। फ\u{941}फ\u{942}स। ऑर\u{94d}गन। स\u{94d}वास सोडप",
            ],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("өпкө"),
            keywords: &["өпкө"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປອດ"),
            keywords: &[
                "ການຫາຍໃຈ",
                "ການຫາຍໃຈອອກ",
                "ການຫາຍໃຈເຂ\u{ebb}\u{ec9}າ",
                "ປອດ",
                "ລ\u{ebb}ມຫາຍໃຈ",
                "ອະໄວຍະວະ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("plaučiai"),
            keywords: &[
                "iškvėpimas",
                "kvėpavimas",
                "organas",
                "plaučiai",
                "įkvėpimas",
            ],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("plaušas"),
            keywords: &[
                "ekshalācija",
                "elpošana",
                "inhalācija",
                "orgāns",
                "plaušas",
                "respirācija",
            ],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("бели дробови"),
            keywords: &["бели дробови", "вдишување", "дишење", "издишување", "орган"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ശ\u{d4d}വ\u{d3e}സകോശം"),
            keywords: &[
                "അവയവം",
                "ഉച\u{d4d}ഛ\u{d4d}വ\u{d3e}സം",
                "നിശ\u{d4d}വ\u{d3e}സം",
                "റെസ\u{d4d}പിരേഷൻ",
                "ശ\u{d4d}വ\u{d3e}സം",
                "ശ\u{d4d}വ\u{d3e}സകോശം",
            ],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("уушиг"),
            keywords: &[
                "амьсгаа авах",
                "амьсгаа гаргах",
                "амьсгал",
                "уушиг",
                "эрхтэн",
            ],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("फ\u{941}फ\u{94d}फ\u{941}स\u{947}"),
            keywords: &[
                "अवयव",
                "फ\u{941}फ\u{94d}फ\u{941}स\u{947}",
                "श\u{94d}वास घ\u{947}ण\u{947}",
                "श\u{94d}वास सोडण\u{947}",
                "श\u{94d}वासोच\u{94d}छवास",
            ],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("paru-paru"),
            keywords: &[
                "nafas",
                "organ",
                "paru-paru",
                "penghembusan",
                "penyedutan",
                "pernafasan",
                "respirasi",
            ],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အဆ\u{102f}တ\u{103a}"),
            keywords: &[
                "ရ\u{103e}\u{102f}ထ\u{102f}တ\u{103a}",
                "ရ\u{103e}\u{102f}သ\u{103d}င\u{103a}း",
                "အင\u{103a}\u{1039}ဂါ",
                "အဆ\u{102f}တ\u{103a}",
                "အသက\u{103a}ရ\u{103e}\u{102f}",
                "အသက\u{103a}ရ\u{103e}\u{102f}လမ\u{103a}းကြောင\u{103a}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("lunger"),
            keywords: &[
                "innpust",
                "lunger",
                "organ",
                "pust",
                "puste",
                "respirasjon",
                "utpust",
            ],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("फोक\u{94d}सो"),
            keywords: &[
                "इन\u{94d}द\u{94d}रिय",
                "फोक\u{94d}सो",
                "श\u{94d}वास निकाल\u{94d}न\u{947}",
                "श\u{94d}वास फ\u{947}र\u{94d}न\u{947}",
                "श\u{94d}वास लिन\u{947}",
                "श\u{94d}वासप\u{94d}रश\u{94d}वास",
            ],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("longen"),
            keywords: &[
                "adem",
                "ademhaling",
                "inademen",
                "longen",
                "orgaan",
                "uitademen",
            ],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("lunger"),
            keywords: &[
                "innpust",
                "lunger",
                "organ",
                "pust",
                "puste",
                "respirasjon",
                "utpust",
            ],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଫ\u{b41}ସ\u{b4d}\u{200c}ଫ\u{b41}ସ\u{b4d}\u{200c}"),
            keywords: &[
                "ଅଙ\u{b4d}ଗପ\u{b4d}ରତ\u{b4d}ୟଙ\u{b4d}ଗ",
                "ନ\u{b3f}ଶ\u{b4d}ୱ\u{b3e}ସଛ\u{b3e}ଡ\u{b3f}ବ\u{b3e}",
                "ନ\u{b3f}ଶ\u{b4d}ୱ\u{b3e}ସପ\u{b4d}ରଶ\u{b4d}ୱ\u{b3e}ସ",
                "ପ\u{b4d}ରଶ\u{b4d}ୱ\u{b3e}ସନେବ\u{b3e}",
                "ଫ\u{b41}ସ\u{b4d}\u{200c}ଫ\u{b41}ସ\u{b4d}\u{200c}",
                "ଶ\u{b4d}ୱ\u{b3e}ସକ\u{b4d}ର\u{b3f}ୟ\u{b3e}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਫ\u{a47}ਫੜ\u{a47}"),
            keywords: &[
                "ਅ\u{a70}ਗ",
                "ਫ\u{a47}ਫੜ\u{a47}",
                "ਸਾਹ",
                "ਸਾਹ ਛ\u{a71}ਡਣਾ",
                "ਸਾਹ ਪ\u{a4d}ਰਣਾਲੀ",
                "ਸ\u{a41}ਆਸ ਲ\u{a48}ਣਾ",
            ],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Lọngs"),
            keywords: &["Brit", "Brít Aut", "Brít In", "Bọdí Pat", "Lọngs"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("płuca"),
            keywords: &[
                "narząd",
                "oddech",
                "oddychanie",
                "organ",
                "płuca",
                "wdech",
                "wydech",
            ],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سګي"),
            keywords: &["سا اخيستل", "سا راکښل", "سا ويستل", "سګي", "عضو"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("pulmões"),
            keywords: &[
                "espiração",
                "exalação",
                "inalação",
                "pulmões",
                "respiração",
                "órgão",
            ],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("surqʼankuna"),
            keywords: &[
                "inhalar",
                "organo",
                "respiracion",
                "samarquy",
                "samay",
                "surqʼankuna",
            ],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("plămâni"),
            keywords: &[
                "expirare",
                "inhalare",
                "inspirare",
                "organ",
                "plămâni",
                "respirare",
                "respirație",
            ],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E13-006"),
            keywords: &["E13-006"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("легкие"),
            keywords: &["вдох", "выдох", "дыхание", "легкие", "орган"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڦڦڙ"),
            keywords: &[
                "ساهه اندر کڻڻ",
                "ساهه ٻاهر ڪڍڻ",
                "ساهه کڻڻ",
                "ساهه کڻڻ جو عمل",
                "عضوو",
                "ڦڦڙ",
            ],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("පෙනහළ\u{dd4}"),
            keywords: &[
                "ආශ\u{dca}ව\u{dcf}සය",
                "ඉන\u{dca}ද\u{dca}\u{200d}ර\u{dd2}ය",
                "පෙනහළ\u{dd4}",
                "ශ\u{dca}වසනය",
                "හ\u{dd4}ස\u{dca}ම",
                "හ\u{dd4}ස\u{dca}ම ගැන\u{dd3}ම",
            ],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("pľúca"),
            keywords: &["dýchanie", "nádych", "orgán", "pľúca", "výdych"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("pljuča"),
            keywords: &["dih", "dihanje", "izdih", "organ", "pljuča", "vdih"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("sambabka"),
            keywords: &[
                "neef, neef bixinta, neef qaadashada, sambabka, xubin, neefsashada",
                "sambabka",
            ],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("mushkëri"),
            keywords: &[
                "frymë",
                "frymëmarrje",
                "frymënxjerrje",
                "mushkëri",
                "organ",
                "respiracion",
            ],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("плућа"),
            keywords: &["дах", "дисање", "издисај", "орган", "плућа", "удисај"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("pluća"),
            keywords: &["dah", "disanje", "izdisaj", "organ", "pluća", "udisaj"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("lungor"),
            keywords: &["andning", "exhalering", "inhalering", "lungor", "organ"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mapafu"),
            keywords: &[
                "kupumua",
                "kutoa pumzi",
                "kuvuta pumzi",
                "mapafu",
                "pumzi",
                "sehemu ya mwili",
            ],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("நுரைய\u{bc0}ரல\u{bcd}"),
            keywords: &[
                "உறுப\u{bcd}பு",
                "உள\u{bcd}ளிழுக\u{bcd}கும\u{bcd}",
                "சுவ\u{bbe}சம\u{bcd}",
                "நுரைய\u{bc0}ரல\u{bcd}",
                "மூச\u{bcd}சு",
                "வெளியேற\u{bcd}றம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఊప\u{c3f}ర\u{c3f}త\u{c3f}త\u{c4d}తులు"),
            keywords: &[
                "ఉచ\u{c4d}ఛ\u{c4d}వ\u{c3e}స",
                "ఊప\u{c3f}ర\u{c3f}త\u{c3f}త\u{c4d}తులు",
                "న\u{c3f}శ\u{c4d}వ\u{c3e}స",
                "భ\u{c3e}గం",
                "శ\u{c4d}వ\u{c3e}స",
                "శ\u{c4d}వ\u{c3e}సక\u{c4d}ర\u{c3f}య",
            ],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปอด"),
            keywords: &[
                "การหายใจ",
                "การหายใจออก",
                "การหายใจเข\u{e49}า",
                "ปอด",
                "ลมหายใจ",
                "อว\u{e31}ยวะ",
            ],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("öýken"),
            keywords: &["dem almak", "dem alyş", "dem çykarmak", "organ", "öýken"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("maʻamaʻa"),
            keywords: &["maʻamaʻa"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("akciğer"),
            keywords: &["akciğer", "nefes", "organ", "soluk", "solunum"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("легені"),
            keywords: &["вдих", "видих", "дихання", "легені", "орган", "подих"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("پھیپھڑے"),
            keywords: &[
                "تنفس",
                "سانس",
                "سانس باہر نکالنا",
                "سانس لینا",
                "عضو",
                "پھیپھڑے",
            ],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("oʻpka"),
            keywords: &[
                "aʼzo",
                "ingalatsiya",
                "nafas",
                "nafas chiqarish",
                "nafas olish",
                "organ",
                "oʻpka",
            ],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("phổi"),
            keywords: &["cơ quan", "hít vào", "hô hấp", "hơi thở", "phổi", "thở ra"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("肺"),
            keywords: &["吸氣", "呼吸", "呼氣", "器官", "肺"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("肺"),
            keywords: &["吸气", "呼吸", "呼气", "器官", "肺"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("肺"),
            keywords: &["吸气", "呼吸", "呼吸作用", "呼气", "器官", "肺"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("肺"),
            keywords: &["呼吸", "器官", "肺"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amaphaphu"),
            keywords: &[
                "amaphaphu",
                "isitho somzimba",
                "respiration",
                "ukudonsa umoya",
                "ukukhipha umoya",
                "umphefumulo",
            ],
        },
    ],
};
#[doc = "🦷"]
pub const TOOTH: crate::Emoji = crate::Emoji {
    glyph: "🦷",
    codepoint: "1F9B7",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "tooth",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tand"),
            keywords: &["tand", "tandarts"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ጥርስ"),
            keywords: &["የጥርስ ሃኪም", "ጥርስ"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("سن"),
            keywords: &["أسنان", "سن", "ضرس", "طبيب أسنان"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("দ\u{9be}\u{981}ত"),
            keywords: &["দন\u{9cd}ত-চিকিৎসক", "দ\u{9be}\u{981}ত"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("diş"),
            keywords: &["diş", "stomatoloq"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("зуб"),
            keywords: &["зуб", "стаматолаг"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("зъб"),
            keywords: &["зъб", "зъболекар"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("দ\u{9be}\u{981}ত"),
            keywords: &["দন\u{9cd}ত-চিকিৎসক", "দ\u{9be}\u{981}ত"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("dant"),
            keywords: &["dant"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("zub"),
            keywords: &["stomatolog", "zub"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("dent"),
            keywords: &["dent", "dentista"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏅᏙᎬ"),
            keywords: &["ᎦᏅᏙᎬ", "ᏗᏓᏅᏕᏍᎩ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("zub"),
            keywords: &["dentista", "zub", "zubař"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("dant"),
            keywords: &["dant", "deintydd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tand"),
            keywords: &["tand", "tandlæge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zahn"),
            keywords: &["Zahn", "Zahn ziehen", "Zahnarzt", "Zahnärztin"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("δόντι"),
            keywords: &["δόντι", "οδοντίατρος"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tooth"),
            keywords: &["dentist", "tooth"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("diente"),
            keywords: &["dentista", "diente", "molar", "muela"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("hammas"),
            keywords: &["hambaarst", "hammas"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hortz"),
            keywords: &["dentista", "hagina", "hortz", "hortza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دندان"),
            keywords: &["دندان", "دندانپزشک"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("hammas"),
            keywords: &["hammas", "hammaslääkäri", "hampaisto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("ngipin"),
            keywords: &["dentista", "ngipin"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tonn"),
            keywords: &["tannlækni", "tonn"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("dent"),
            keywords: &["dent", "dentiste"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("fiacal"),
            keywords: &["fiacal", "fiaclóir"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("fiacaill"),
            keywords: &["fiacaill", "fiaclair"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("dente"),
            keywords: &["dental", "dente", "dentista", "moa"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("દા\u{a82}ત"),
            keywords: &["દા\u{a82}ત"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("שן"),
            keywords: &["רופא שיניים", "שיניים", "שן"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("दा\u{901}त"),
            keywords: &["दा\u{901}त", "दा\u{901}त का डॉक\u{94d}टर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("zub"),
            keywords: &["zub", "zubar"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("fog"),
            keywords: &["fog", "fogorvos"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ատամ"),
            keywords: &["ատամ", "ատամնաբույժ"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("dente"),
            keywords: &[
                "dental",
                "dentari",
                "dente",
                "dentista",
                "odontologia",
                "orthodontista",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("gigi"),
            keywords: &["dokter gigi", "gigi"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tennur"),
            keywords: &["tannlæknir", "tennur"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("dente"),
            keywords: &["dente", "dentista"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("歯"),
            keywords: &["歯", "歯医者"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("untu"),
            keywords: &["dokter untu", "untu"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("კბილი"),
            keywords: &["დენტისტი", "კბილი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тіс"),
            keywords: &["тіс", "тіс дәрігері"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ធ\u{17d2}មេញ"),
            keywords: &["ទន\u{17d2}តពេទ\u{17d2}យ", "ធ\u{17d2}មេញ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಹಲ\u{ccd}ಲು"),
            keywords: &["ದಂತ ವೈದ\u{ccd}ಯ", "ಹಲ\u{ccd}ಲು"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("이빨"),
            keywords: &["이빨", "치과"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दा\u{902}त"),
            keywords: &["दा\u{902}त", "दाता\u{902}चो दोतोर"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тиш"),
            keywords: &["тиш", "тиш доктур"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ແຂ\u{ec9}ວ"),
            keywords: &["ທ\u{eb1}ນຕະແພດ", "ແຂ\u{ec9}ວ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("dantis"),
            keywords: &["dantis", "dantistas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("zobs"),
            keywords: &["zobs", "zobārsts"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("заб"),
            keywords: &["заб", "стоматолог"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("പല\u{d4d}ല\u{d4d}"),
            keywords: &["ദന\u{d4d}തരോഗവിദഗ\u{d4d}ദ\u{d4d}ധൻ", "പല\u{d4d}ല\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("шүд"),
            keywords: &["шүд", "шүдний эмч"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("दात"),
            keywords: &["ड\u{947}न\u{94d}टिस\u{94d}ट", "दात"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("gigi"),
            keywords: &["doktor gigi", "gigi"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("သ\u{103d}ား"),
            keywords: &["သ\u{103d}ား", "သ\u{103d}ားဆရာဝန\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tann"),
            keywords: &["tann", "tannlege"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("दा\u{901}त"),
            keywords: &["दा\u{901}त", "दा\u{901}तको डाक\u{94d}टर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tand"),
            keywords: &["tand", "tandarts"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tann"),
            keywords: &["tann", "tannlege"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଦ\u{b3e}ନ\u{b4d}ତ"),
            keywords: &["ଦନ\u{b4d}ତ ଚ\u{b3f}କ\u{b3f}ତ\u{b4d}ସକ", "ଦ\u{b3e}ନ\u{b4d}ତ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਦ\u{a70}ਦ"),
            keywords: &["ਦ\u{a70}ਦ", "ਦ\u{a70}ਦਾ\u{a02} ਦਾ ਡਾਕਟਰ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tit"),
            keywords: &["Dẹ\u{301}ntist", "Tit", "Tít Dọ\u{301}ktọ"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("ząb"),
            keywords: &["dentysta", "stomatolog", "ząb"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("غاښ"),
            keywords: &["دندان ساز", "غاښ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("dente"),
            keywords: &["dente", "dentista"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("kiru"),
            keywords: &["dentista", "kiru", "kirukuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("dinte"),
            keywords: &["dentist", "dinte", "stomatolog"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-040"),
            keywords: &["E11-040"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("зуб"),
            keywords: &["дантист", "зуб", "зубной", "зубы", "стоматолог"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("ڏند"),
            keywords: &["ڏند", "ڏند ساز"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("දත\u{dca}"),
            keywords: &["දත\u{dca}", "දන\u{dca}ත වෛද\u{dca}\u{200d}ය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("zub"),
            keywords: &["zub", "zubár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("zob"),
            keywords: &["zob", "zobozdravnik"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("ilig"),
            keywords: &["dhakhtarka ilkaha", "ilig"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("dhëmb"),
            keywords: &["dentist", "dhëmb"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("зуб"),
            keywords: &["зуб", "зубар"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("zub"),
            keywords: &["zub", "zubar"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tand"),
            keywords: &["tand", "tandläkare"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jino"),
            keywords: &["daktari wa meno", "jino"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("பல\u{bcd}"),
            keywords: &["பல\u{bcd}", "பல\u{bcd} மருத\u{bcd}துவர\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("పన\u{c4d}ను"),
            keywords: &["దంతవ\u{c48}ద\u{c4d}యులు", "పన\u{c4d}ను"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ฟ\u{e31}น"),
            keywords: &["ฟ\u{e31}น", "หมอฟ\u{e31}น"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("diş"),
            keywords: &["diş", "stomatolog"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("nifo"),
            keywords: &["nifo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("diş"),
            keywords: &["diş", "diş hekimi", "dişçi"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("зуб"),
            keywords: &["дантист", "зуб", "зуби", "стоматолог"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("دانت"),
            keywords: &["دانت", "معالج دندان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("tish"),
            keywords: &["dantist", "stomatolog", "tish", "tish doktori", "tishlar"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("răng"),
            keywords: &["nha sĩ", "răng"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("牙齒"),
            keywords: &["牙醫", "牙齒"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("牙齿"),
            keywords: &["牙医", "牙齿"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("牙齿"),
            keywords: &["牙医", "牙齿"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("牙齒"),
            keywords: &["牙醫", "牙齒"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("izinyo"),
            keywords: &["izinyo", "udokotela"],
        },
    ],
};
#[doc = "🦴"]
pub const BONE: crate::Emoji = crate::Emoji {
    glyph: "🦴",
    codepoint: "1F9B4",
    status: crate::Status::FullyQualified,
    introduction_version: 11f32,
    name: "bone",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("vleislose been"),
            keywords: &["beendere", "geraamte", "vleislose been"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አጥንት"),
            keywords: &["አጥንት", "ዐፅም"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عظمة"),
            keywords: &["عظام", "عظم", "عظمة", "هيكل عظمي"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("হ\u{9be}\u{981}ড\u{9bc}"),
            keywords: &["কংক\u{9be}ল", "হ\u{9be}\u{981}ড\u{9bc}"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("sümük"),
            keywords: &["skelet", "sümük"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("косць"),
            keywords: &["косць", "шкілет"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("кокал"),
            keywords: &["кокал", "скелет"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("হ\u{9be}ড\u{9bc}"),
            keywords: &["কঙ\u{9cd}ক\u{9be}ল", "হ\u{9be}ড\u{9bc}"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("askorn"),
            keywords: &["askorn"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("kost"),
            keywords: &["kost", "kostur"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("os"),
            keywords: &["esquelet", "os"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎪᎳ"),
            keywords: &["ᎤᎪᎳᎭ", "ᎪᎳ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("kost"),
            keywords: &["kost", "kostra"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("asgwrn"),
            keywords: &["asgwrn", "ysgerbwd"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("knogle"),
            keywords: &["knogle", "skelet"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Knochen"),
            keywords: &["Knochen", "Skelett"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("κόκαλο"),
            keywords: &["κόκαλο", "σκελετός"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("bone"),
            keywords: &["bone", "skeleton"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("hueso"),
            keywords: &["esqueleto", "hueso"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("hueso"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("hueso"),
            keywords: &["hueso"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("kont"),
            keywords: &["kont", "luustik"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("hezur"),
            keywords: &["eskeletoa", "hezur", "hezurra"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("استخوان"),
            keywords: &["استخوان", "اسکلت"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("luu"),
            keywords: &["luu", "luuranko", "luusto"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("buto"),
            keywords: &["buto", "kalansay"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("kjøtbein"),
            keywords: &["bein", "beinagrind", "kjøtbein"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("os"),
            keywords: &["os", "squelette"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("cnámh"),
            keywords: &["cnámh", "creatlach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("cnàimh"),
            keywords: &["cnàimh", "cnàimhneach"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("óso"),
            keywords: &["esqueleto", "óso"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("હાડકા\u{a82}"),
            keywords: &["હાડકા\u{a82}"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עצם"),
            keywords: &["עצם", "עצמות", "שלד"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("हड\u{94d}डी"),
            keywords: &["क\u{902}काल", "हड\u{94d}डी"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("kost"),
            keywords: &["kost", "kostur"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("csont"),
            keywords: &["csont", "csontváz"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("ոսկոր"),
            keywords: &["կմախք", "ոսկոր"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("osso"),
            keywords: &["osso", "osteologia", "skeleto"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("tulang"),
            keywords: &["tulang", "tulang belulang"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("bein"),
            keywords: &["bein", "beinagrind"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("osso"),
            keywords: &["osso", "scheletro"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("骨"),
            keywords: &["骨", "骨格"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("balung"),
            keywords: &["balung", "wrangka"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ძვალი"),
            keywords: &["ჩონჩხი", "ძვალი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("сүйек"),
            keywords: &["сүйек", "қаңқа"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ឆ\u{17d2}អ\u{17b9}ង"),
            keywords: &["គ\u{17d2}រោងឆ\u{17d2}អ\u{17b9}ង", "ឆ\u{17d2}អ\u{17b9}ង"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಮ\u{cc2}ಳ\u{cc6}"),
            keywords: &["ಅಸ\u{ccd}ಥ\u{cbf}ಪಂಚರ", "ಮ\u{cc2}ಳ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("뼈다귀"),
            keywords: &["뼈", "뼈다귀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("हाड"),
            keywords: &["सा\u{902}पळो", "हाड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("сөөк"),
            keywords: &["скелет", "сөөк"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ກະດ\u{eb9}ກ"),
            keywords: &["ກະດ\u{eb9}ກ", "ກະດ\u{eb9}ກຮ\u{ec8}າງ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("kaulas"),
            keywords: &["kaulas", "skeletas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("kauls"),
            keywords: &["kauls", "skelets"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("коска"),
            keywords: &["коска", "скелет"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("എല\u{d4d}ല\u{d4d}"),
            keywords: &["അസ\u{d4d}ഥിക\u{d42}ടം", "എല\u{d4d}ല\u{d4d}"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("яс"),
            keywords: &["араг яс", "яс"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("हाड"),
            keywords: &["सापळा", "हाड"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("tulang"),
            keywords: &["rangka", "tulang"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("အရ\u{102d}\u{102f}း"),
            keywords: &["အရ\u{102d}\u{102f}း", "အရ\u{102d}\u{102f}းစ\u{102f}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("knokkel"),
            keywords: &["knokkel", "skjelett"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("हड\u{94d}डी"),
            keywords: &["अस\u{94d}थिपञ\u{94d}जर", "हड\u{94d}डी"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("bot"),
            keywords: &["bot", "skelet"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("knokkel"),
            keywords: &["knokkel", "skjelett"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ହ\u{b3e}ଡ"),
            keywords: &["କଙ\u{b4d}କ\u{b3e}ଳ", "ହ\u{b3e}ଡ"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਹ\u{a71}ਡੀ"),
            keywords: &["ਪਿ\u{a70}ਜਰ", "ਹ\u{a71}ਡੀ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Bon"),
            keywords: &["Bon", "Skẹ\u{301}lẹ\u{301}tin"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("kość"),
            keywords: &["kość", "szkielet"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("هډوکی"),
            keywords: &["هډوکی", "ډهانچه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("osso"),
            keywords: &["esqueleto", "osso"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("tullu"),
            keywords: &["saqru", "tullu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("os"),
            keywords: &["os", "schelet"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E11-037"),
            keywords: &["E11-037"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("кость"),
            keywords: &["косточка", "кость", "скелет"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("هڏي"),
            keywords: &["هڏي", "ڍانچو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("අස\u{dca}ථ\u{dd2}"),
            keywords: &["අස\u{dca}ථ\u{dd2}", "ඇටසැක\u{dd2}ල\u{dca}ල"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("kosť"),
            keywords: &["kostra", "kosť"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("kost"),
            keywords: &["kost", "okostje"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("laf"),
            keywords: &["laf", "qalfoof"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("eshtër"),
            keywords: &["eshtër", "skelet"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("кост"),
            keywords: &["кост", "костур"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("kost"),
            keywords: &["kost", "kostur"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("benknota"),
            keywords: &["benknota", "skelett"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mfupa"),
            keywords: &["gofu", "mfupa"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("எலும\u{bcd}புத\u{bcd}துண\u{bcd}டு"),
            keywords: &[
                "எலும\u{bcd}புக\u{bcd}கூடு",
                "எலும\u{bcd}புத\u{bcd}துண\u{bcd}டு",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("ఎముక"),
            keywords: &["అస\u{c4d}త\u{c3f}పంజరం", "ఎముక"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("กระด\u{e39}ก"),
            keywords: &["กระด\u{e39}ก", "โครงกระด\u{e39}ก"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("süňk"),
            keywords: &["skelet", "süňk"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("hui"),
            keywords: &["hui"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("kemik"),
            keywords: &["iskelet", "kemik"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("кістка"),
            keywords: &["кальцій", "кості", "кістка", "скелет"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("ہڈی"),
            keywords: &["ڈھانچا", "ہڈی"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("suyak"),
            keywords: &["skelet", "suyak", "ustixon"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("xương"),
            keywords: &["bộ xương", "xương"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("骨頭"),
            keywords: &["骨頭"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("骨头"),
            keywords: &["骨头"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("骨头"),
            keywords: &["骨头", "骨骼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("骨頭"),
            keywords: &["骨頭"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ithambo"),
            keywords: &["amathambo", "ithambo"],
        },
    ],
};
#[doc = "👀"]
pub const EYES: crate::Emoji = crate::Emoji {
    glyph: "👀",
    codepoint: "1F440",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "eyes",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oë"),
            keywords: &["gesig", "oog", "oë"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዓይኖች"),
            keywords: &["አካል", "ዓይን", "ዓይኖች", "ፊት"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عينان"),
            keywords: &["عينان", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চক\u{9c1}জ\u{9c1}ৰি"),
            keywords: &["চক\u{9c1}", "চক\u{9c1}জ\u{9c1}ৰি", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("gözlər"),
            keywords: &["göz", "gözlər", "üz"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вочы"),
            keywords: &["вока", "вочы", "твар"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("очи"),
            keywords: &["лице", "око", "очи", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখ গ\u{9c1}লি"),
            keywords: &["চোখ", "চোখ গ\u{9c1}লি", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("daoulagad"),
            keywords: &["daoulagad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oči"),
            keywords: &["lice", "oko", "oči"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ulls"),
            keywords: &["cara", "cos", "ull", "ulls"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᏗᎦᏔ"),
            keywords: &["ᎤᎧᏛ", "ᏗᎦᏔ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oči"),
            keywords: &["obličej", "oko", "oči", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llygaid"),
            keywords: &["corff", "llygad", "llygaid", "wyneb"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("øjne"),
            keywords: &["ansigt", "se", "øjne"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Augen"),
            keywords: &["Auge", "Augen", "Gesicht"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάτια"),
            keywords: &["μάτι", "μάτια", "πρόσωπο", "σώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eyes"),
            keywords: &["eye", "eyes", "face"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ojos"),
            keywords: &["cara", "ojos"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("silmad"),
            keywords: &["keha", "nägu", "silm", "silmad"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begiak"),
            keywords: &["aurpegia", "begia", "begiak", "gorputza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("دو چشم"),
            keywords: &["دو چشم", "صورت", "چشم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silmät"),
            keywords: &["naama", "silmä", "silmät", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mga mata"),
            keywords: &["katawan", "mata", "mga mata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eygu"),
            keywords: &["eyga", "eygu"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("yeux"),
            keywords: &["corps", "visage", "yeux", "œil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("súile"),
            keywords: &["aghaidh", "súile"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sùilean"),
            keywords: &["aodann", "sùil", "sùilean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ollos"),
            keywords: &["ollos"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આ\u{a82}ખો"),
            keywords: &["આ\u{a82}ખો", "ચહ\u{ac7}રો", "શરીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("idanu"),
            keywords: &["fuska", "idanu", "ido"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עיניים"),
            keywords: &["להסתכל", "לצפות", "לראות", "עיניים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आ\u{901}ख\u{947}\u{902}"),
            keywords: &["आ\u{901}ख\u{947}\u{902}", "च\u{947}हरा"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oči"),
            keywords: &["lice", "oko", "oči", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szemek"),
            keywords: &["arc", "szem", "szemek", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աչքեր"),
            keywords: &["աչք", "աչքեր", "դեմք", "մարմին"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("oculos"),
            keywords: &[
                "facie",
                "ocular",
                "oculo",
                "oculos",
                "ophthalmologia",
                "vision",
                "visual",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("dua mata"),
            keywords: &["badan", "dua mata", "mata", "muka", "tubuh", "wajah"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anya gasị"),
            keywords: &["anya", "anya gasị", "ihu"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("augu"),
            keywords: &["andlit", "augu"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhi"),
            keywords: &["faccia", "occhi"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("目"),
            keywords: &["からだ", "両目", "目"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mata sakloron"),
            keywords: &["mata", "mata sakloron", "rai"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თვალები"),
            keywords: &["თვალები", "თვალი", "სახე", "სხეული", "ტანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көздер"),
            keywords: &["бет", "дене", "көз", "көздер"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("øjne"),
            keywords: &["ansigt", "se", "øjne"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("ភ\u{17d2}នែក"),
            keywords: &["ភ\u{17d2}នែក", "ម\u{17bb}ខ", "រាងកាយ"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಣ\u{ccd}ಣುಗಳು"),
            keywords: &["ಕಣ\u{ccd}ಣು", "ಕಣ\u{ccd}ಣುಗಳು", "ದೇಹ", "ಮುಖ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("왕눈이 눈알"),
            keywords: &["신체", "얼굴", "왕눈이 눈알"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोळ\u{947}"),
            keywords: &["च\u{947}रो", "दोळ\u{947}", "दोळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көздөр"),
            keywords: &["бет", "дене", "көз", "көздөр"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Aen"),
            keywords: &["A", "Aen", "Gesiicht"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາສອງເບ\u{eb7}\u{ec9}ອງ"),
            keywords: &[
                "ຕາ",
                "ຕາສອງເບ\u{eb7}\u{ec9}ອງ",
                "ຮ\u{ec8}າງກາຍ",
                "ໃບໜ\u{ec9}າ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akys"),
            keywords: &["akis", "akys", "veidas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("acis"),
            keywords: &["acis", "acs", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("ngā karu"),
            keywords: &["kanohi", "karu", "ngā karu"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("очи"),
            keywords: &["лице", "очи", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കണ\u{d4d}ണ\u{d41}കൾ"),
            keywords: &["കണ\u{d4d}ണ\u{d41}കൾ", "കണ\u{d4d}ണ\u{d4d}", "മ\u{d41}ഖം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хоёр нүд"),
            keywords: &["гайхах", "нүд", "хоёр"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोळ\u{947}"),
            keywords: &["च\u{947}हरा", "डोळा", "डोळ\u{947}"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("sepasang mata"),
            keywords: &["badan", "mata", "muka", "sepasang mata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għajnejn"),
            keywords: &["għajn", "għajnejn", "wiċċ"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မျက\u{103a}လ\u{102f}\u{1036}းများ"),
            keywords: &[
                "မျက\u{103a}န\u{103e}ာ",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
                "မျက\u{103a}လ\u{102f}\u{1036}းများ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øyne"),
            keywords: &["fjes", "øye", "øyne"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आ\u{901}खाहर\u{942}"),
            keywords: &["अन\u{941}हार", "आ\u{901}खा", "आ\u{901}खाहर\u{942}", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("ogen"),
            keywords: &["gezicht", "ogen", "oog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("auge"),
            keywords: &["auge", "fjes"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଖ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ"),
            keywords: &[
                "ଆଖ\u{b3f}",
                "ଆଖ\u{b3f}ଗ\u{b41}ଡ\u{b3c}\u{b3f}କ",
                "ମ\u{b41}ହ\u{b01}",
            ],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਖਾ\u{a02}"),
            keywords: &["ਅ\u{a71}ਖ", "ਅ\u{a71}ਖਾ\u{a02}", "ਚਿਹਰਾ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اکھاں"),
            keywords: &["اکھ", "اکھاں", "دی شکل"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ai-dẹm"),
            keywords: &["Ai", "Ai-dẹm", "Ais", "Fes"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("oczy"),
            keywords: &["oczy", "oko", "twarz"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سترګي"),
            keywords: &["سترګي", "سرتګه", "مخ"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("olhos"),
            keywords: &["olho", "olhos", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñawikuna"),
            keywords: &["uya", "ñawi", "ñawikuna"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("doi ochi"),
            keywords: &["doi", "față", "ochi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-509"),
            keywords: &["E10-509"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("глаза"),
            keywords: &["глаза", "два", "тело", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("amaso"),
            keywords: &["amaso", "ijisho", "isura"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اکيون"),
            keywords: &["اک", "اکيون", "چهرو"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇස\u{dca}"),
            keywords: &["ඇස\u{dca}", "ම\u{dd4}හ\u{dd4}ණ", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oči"),
            keywords: &["oko", "oči", "tvár"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oči"),
            keywords: &["obraz", "oči", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("indhaha"),
            keywords: &["il", "indhaha", "waji"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sytë"),
            keywords: &["fytyrë", "sy", "sytë", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("очи"),
            keywords: &["oкo", "лице", "очи"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oči"),
            keywords: &["lice", "oko", "oči"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("ögon"),
            keywords: &["öga", "ögon"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("macho"),
            keywords: &["jicho", "macho", "mwili", "uso"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}கள\u{bcd}"),
            keywords: &[
                "உடல\u{bcd} உறுப\u{bcd}பு",
                "கண\u{bcd}",
                "கண\u{bcd}கள\u{bcd}",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కళ\u{c4d}లు"),
            keywords: &["కళ\u{c4d}లు", "ముఖం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чашмон"),
            keywords: &["рӯй", "чашм", "чашмон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตา 2 ข\u{e49}าง"),
            keywords: &["ตา", "ตา 2 ข\u{e49}าง", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("gözler"),
            keywords: &["göz", "gözler", "ýüz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ongo kanoʻimata"),
            keywords: &["ongo kanoʻimata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("gözler"),
            keywords: &["gözler", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆزلەر"),
            keywords: &["كۆز", "كۆزلەر", "چىراي"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("очі"),
            keywords: &["обличчя", "око", "очі", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آنکھیں"),
            keywords: &["آنکھ", "آنکھیں", "چہرہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘zlar"),
            keywords: &["ko‘z", "ko‘zlar", "tana", "yuz"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("đôi mắt"),
            keywords: &["mắt", "mặt", "đôi mắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gët"),
            keywords: &["bët", "gët", "kanam"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("amehlo"),
            keywords: &["amehlo", "iliso", "ubuso"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Awọn Ojú"),
            keywords: &["Awọn Ojú", "eyinjú", "ojú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("雙眼"),
            keywords: &["眼", "臉", "雙眼"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("双眼"),
            keywords: &["双眼", "眼", "脸"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("双眼"),
            keywords: &["双眼"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("雙眼"),
            keywords: &["身體部位", "雙眼"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("amehlo"),
            keywords: &["amehlo", "ihlo", "ubuso", "umzimba"],
        },
    ],
};
#[doc = "👁\u{fe0f}"]
pub const EYE: crate::Emoji = crate::Emoji {
    glyph: "👁\u{fe0f}",
    codepoint: "1F441 FE0F",
    status: crate::Status::FullyQualified,
    introduction_version: 0.7f32,
    name: "eye",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[crate::Emoji {
        glyph: "👁",
        codepoint: "1F441",
        status: crate::Status::Unqualified,
        introduction_version: 0.7f32,
        name: "eye",
        group: "People & Body",
        subgroup: "body-parts",
        is_variant: true,
        variants: &[],
        annotations: &[],
    }],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("oog"),
            keywords: &["liggaam", "oog"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ዓይን"),
            keywords: &["አካል", "ዓይን"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("عين"),
            keywords: &["جسد", "عين"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("চক\u{9c1}"),
            keywords: &["চক\u{9c1}", "শৰীৰ"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("göz"),
            keywords: &["göz", "orqan"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("вока"),
            keywords: &["вока", "зрок"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("око"),
            keywords: &["око", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("চোখ"),
            keywords: &["চোখ", "শরীর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("lagad"),
            keywords: &["lagad"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("oko"),
            keywords: &["oko", "tijelo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("ull"),
            keywords: &["cos", "ull"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎦᏘ"),
            keywords: &["ᎠᎦᏘ", "ᎥᏰᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("oko"),
            keywords: &["oko", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("llygad"),
            keywords: &["corff", "llygad"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("øje"),
            keywords: &["krop", "øje"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Auge"),
            keywords: &["Auge", "Körperteil"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("μάτι"),
            keywords: &["μάτι", "σώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("eye"),
            keywords: &["body", "eye"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("ojo"),
            keywords: &["cuerpo", "ojo"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("silm"),
            keywords: &["keha", "silm"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("begi"),
            keywords: &["begi", "begia", "gorputza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("چشم"),
            keywords: &["بدن", "چشم"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("silmä"),
            keywords: &["pää", "silmä", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("mata"),
            keywords: &["katawan", "mata"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("eyga"),
            keywords: &["eyga", "kroppur"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("œil"),
            keywords: &["corps", "œil"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("súil"),
            keywords: &["corp", "súil"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("sùil"),
            keywords: &["bodhaig", "sùil"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("ollo"),
            keywords: &["ollo"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("આ\u{a82}ખ"),
            keywords: &["આ\u{a82}ખ", "શરીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("ido"),
            keywords: &["ido", "jiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("עין"),
            keywords: &["גוף האדם", "להסתכל", "לצפות", "לראות", "עין"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("आ\u{901}ख"),
            keywords: &["आ\u{901}ख", "शरीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("oko"),
            keywords: &["oko", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("szem"),
            keywords: &["szem", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("աչք"),
            keywords: &["աչք", "մարմին"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("oculo"),
            keywords: &[
                "corpore",
                "ocular",
                "oculo",
                "ophthalmologia",
                "vision",
                "visual",
            ],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("satu mata"),
            keywords: &["badan", "satu mata", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("anya"),
            keywords: &["anya", "àhụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("auga"),
            keywords: &["auga", "líkami"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("occhio"),
            keywords: &["corpo", "faccia", "occhio"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("片目"),
            keywords: &["一つ目", "片目", "目"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("mata"),
            keywords: &["awak", "mata"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("თვალი"),
            keywords: &["თვალი", "სხეული", "ტანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("көз"),
            keywords: &["дене", "көз"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("øje"),
            keywords: &["krop", "øje"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("កែវភ\u{17d2}នែក"),
            keywords: &["កែវភ\u{17d2}នែក", "សម\u{17d2}ល\u{17b9}ងមើល"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಕಣ\u{ccd}ಣು"),
            keywords: &["ಕಣ\u{ccd}ಣು", "ದೇಹ"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("눈"),
            keywords: &["눈", "시력", "신체", "얼굴"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("दोळो"),
            keywords: &["क\u{942}ड", "दोळो"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("көз"),
            keywords: &["дене", "көз"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("A"),
            keywords: &["A", "Kierper"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ຕາເບ\u{eb7}\u{ec9}ອງໜ\u{eb6}\u{ec8}ງ"),
            keywords: &[
                "ຕາ",
                "ຕາເບ\u{eb7}\u{ec9}ອງໜ\u{eb6}\u{ec8}ງ",
                "ຮ\u{ec8}າງກາຍ",
            ],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("akis"),
            keywords: &["akis", "kūnas"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("acs"),
            keywords: &["acs", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("karu"),
            keywords: &["karu", "tinana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("око"),
            keywords: &["лице", "око", "тело"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("കണ\u{d4d}ണ\u{d4d}"),
            keywords: &["കണ\u{d4d}ണ\u{d4d}", "ശരീരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("нүд"),
            keywords: &["бие", "нүд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("डोळा"),
            keywords: &["डोळा", "शरीर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mata"),
            keywords: &["badan", "mata"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("għajn"),
            keywords: &["għajn"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("မျက\u{103a}လ\u{102f}\u{1036}း"),
            keywords: &[
                "ခန\u{1039}ဓာက\u{102d}\u{102f}ယ\u{103a}",
                "မျက\u{103a}လ\u{102f}\u{1036}း",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("øye"),
            keywords: &["kropp", "øye"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("आ\u{901}खा"),
            keywords: &["आ\u{901}खा", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("oog"),
            keywords: &["lichaam", "oog"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("auga"),
            keywords: &["auga", "auge", "kropp"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଆଖ\u{b3f}"),
            keywords: &["ଆଖ\u{b3f}", "ଶରୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਅ\u{a71}ਖ"),
            keywords: &["ਅ\u{a71}ਖ", "ਨਜ\u{a3c}ਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("اکھ"),
            keywords: &["اکھ", "جسم"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Ai"),
            keywords: &["Ai", "Bọdí Pat"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("oko"),
            keywords: &["ciało", "oko"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("سترګه"),
            keywords: &["بدن", "سترګه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("olho"),
            keywords: &["olho", "parte do corpo", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["corpo", "olho"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("ñawi"),
            keywords: &["khurku", "ñawi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("un ochi"),
            keywords: &["corp", "un ochi"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-510"),
            keywords: &["E10-510"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("глаз"),
            keywords: &["глаз", "зрачок", "тело", "человек"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ijisho"),
            keywords: &["igihimba", "ijisho"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("اک"),
            keywords: &["اک", "جسم"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ඇස"),
            keywords: &["ඇස", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("oko"),
            keywords: &["oko", "telo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("oko"),
            keywords: &["oko", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("il"),
            keywords: &["il", "jir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("sy"),
            keywords: &["sy", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("око"),
            keywords: &["око", "тело"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["око"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("oko"),
            keywords: &["oko", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["oko"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("öga"),
            keywords: &["kropp", "öga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("jicho"),
            keywords: &["jicho", "mwili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("கண\u{bcd}"),
            keywords: &[
                "உடல\u{bcd} உறுப\u{bcd}பு",
                "கண\u{bcd}",
                "ப\u{bbe}ர\u{bcd}வை",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("కన\u{c4d}ను"),
            keywords: &["కన\u{c4d}ను", "శర\u{c40}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("чашм"),
            keywords: &["бадан", "чашм"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ตาข\u{e49}างเด\u{e35}ยว"),
            keywords: &["ตา", "ตาข\u{e49}างเด\u{e35}ยว", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("göz"),
            keywords: &["göwre", "göz"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("kanoʻimata"),
            keywords: &["kanoʻimata"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("göz"),
            keywords: &["beden", "göz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("كۆز"),
            keywords: &["كۆز", "گەۋدە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("око"),
            keywords: &["око", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("آنکھ"),
            keywords: &["آنکھ", "جسم"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("ko‘z"),
            keywords: &["ko‘z", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("mắt"),
            keywords: &["cơ thể", "mắt"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("bët"),
            keywords: &["bët", "yaram"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("iliso"),
            keywords: &["iliso", "isiqu"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("eyinjú"),
            keywords: &["Ara", "eyinjú"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("眼"),
            keywords: &["眼", "身體"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("眼"),
            keywords: &["眼", "身体"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("眼睛"),
            keywords: &["看", "眼", "眼睛"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("眼睛"),
            keywords: &["眼睛", "身體部位"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ihlo"),
            keywords: &["ihlo", "umzimba"],
        },
    ],
};
#[doc = "👅"]
pub const TONGUE: crate::Emoji = crate::Emoji {
    glyph: "👅",
    codepoint: "1F445",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "tongue",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("tong"),
            keywords: &["liggaam", "tong"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("ምላስ"),
            keywords: &["ምላስ", "አካል"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("لسان"),
            keywords: &["جسم", "لسان", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("জিভ\u{9be}"),
            keywords: &["জিভ\u{9be}", "শৰীৰ"],
        },
        #[cfg(feature = "ast")]
        crate::Annotation {
            lang: "ast",
            tts: Some("llingua"),
            keywords: &["cuerpu", "llingua"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("dil"),
            keywords: &["bədən", "dil"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("язык"),
            keywords: &["смак", "цела", "язык"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("език"),
            keywords: &["език", "тяло"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("জিভ"),
            keywords: &["জিভ", "শরীর"],
        },
        #[cfg(feature = "br")]
        crate::Annotation {
            lang: "br",
            tts: Some("teod"),
            keywords: &["teod"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("jezik"),
            keywords: &["jezik", "tijelo"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("llengua"),
            keywords: &["cos", "llengua"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎦᏂᎪ"),
            keywords: &["ᎥᏰᎸᎢ", "ᎦᏂᎪ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("jazyk"),
            keywords: &["jazyk", "tělo"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("tafod"),
            keywords: &["corff", "tafod"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("tunge"),
            keywords: &["krop", "smage", "tunge"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Zunge"),
            keywords: &["Körperteil", "Zunge"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("γλώσσα"),
            keywords: &["γλώσσα", "σώμα"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("tongue"),
            keywords: &["body", "tongue"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("lengua"),
            keywords: &["cuerpo", "lengua"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("keel"),
            keywords: &["keel", "keha"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("mingain"),
            keywords: &["gorputza", "mingain", "mingaina"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("زبان"),
            keywords: &["بدن", "زبان"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("kieli"),
            keywords: &["kieli", "pää", "suu", "uhma", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("dila"),
            keywords: &["belat", "dila", "panlasa"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("tunga"),
            keywords: &["gálva", "kroppur", "tunga"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("langue"),
            keywords: &["corps", "langue"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("teanga amach"),
            keywords: &["corp", "teanga", "teanga amach"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("teanga"),
            keywords: &["bodhaig", "teanga"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("lingua"),
            keywords: &["lingua"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("જીભ"),
            keywords: &["ચહ\u{ac7}રો", "જીભ", "શરીર"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("harshe"),
            keywords: &["harshe", "jiki"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("לשון"),
            keywords: &["גוף האדם", "ליקוק", "ללקק", "לק", "לשון"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("जीभ"),
            keywords: &["च\u{947}हरा", "जीभ", "शरीर"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("jezik"),
            keywords: &["jezik", "tijelo"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("nyelv"),
            keywords: &["nyelv", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("լեզու"),
            keywords: &["լեզու", "մարմին"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("lingua"),
            keywords: &["corpore", "lingua", "lingual"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("lidah"),
            keywords: &["badan", "lidah", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ire"),
            keywords: &["ire", "àhụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("tunga"),
            keywords: &["andlit", "líkami", "tunga"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("lingua"),
            keywords: &["corpo", "faccia", "lingua"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("舌"),
            keywords: &["べろ", "べー", "舌"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("ilat"),
            keywords: &["awak", "ilat"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("ენა"),
            keywords: &["ენა", "სხეული", "ტანი"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("тіл"),
            keywords: &["дене", "тіл"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("tunge"),
            keywords: &["krop", "smage", "tunge"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("អណ\u{17d2}តាត"),
            keywords: &["ល\u{17b7}ឍ", "អណ\u{17d2}តាត"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ನಾಲ\u{cbf}ಗ\u{cc6}"),
            keywords: &["ದೇಹ", "ನಾಲ\u{cbf}ಗ\u{cc6}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("혀"),
            keywords: &["메롱", "몸", "혀"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("जीभ"),
            keywords: &["क\u{942}ड", "जीभ"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("тил"),
            keywords: &["дене", "тил"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Zong"),
            keywords: &["Kierper", "Zong"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ລ\u{eb5}\u{ec9}ນ"),
            keywords: &["ລ\u{eb5}\u{ec9}ນ", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("liežuvis"),
            keywords: &["kūnas", "liežuvis"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mēle"),
            keywords: &["mute", "mēle", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("arero"),
            keywords: &["arero", "tinana"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("јазик"),
            keywords: &["тело", "јазик"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("ന\u{d3e}വ\u{d4d}"),
            keywords: &["ന\u{d3e}വ\u{d4d}", "ശരീരം"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("хэл"),
            keywords: &["бие", "хэл"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("जीभ"),
            keywords: &["जीभ", "शरीर"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("lidah"),
            keywords: &["badan", "lidah"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ilsien"),
            keywords: &["ilsien"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("လျ\u{103e}ာ"),
            keywords: &[
                "က\u{102d}\u{102f}ယ\u{103a}ခန\u{1039}ဓာ အစ\u{102d}တ\u{103a}အပ\u{102d}\u{102f}င\u{103a}း",
                "လျ\u{103e}ာ",
            ],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("tunge"),
            keywords: &["fjes", "kropp", "tunge"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("जिब\u{94d}रो"),
            keywords: &["जिब\u{94d}रो", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("tong"),
            keywords: &["lichaam", "tong"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("tunge"),
            keywords: &["fjes", "kropp", "tunge"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ଜ\u{b3f}ଭ"),
            keywords: &["ଜ\u{b3f}ଭ", "ଶରୀର"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਜੀਭ"),
            keywords: &["ਚਿਹਰਾ", "ਜੀਭ", "ਸਰੀਰ"],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("جیب"),
            keywords: &["جسم", "جیب"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Tọng"),
            keywords: &["Bọdí Pat", "Tọng"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("język"),
            keywords: &["ciało", "język"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("ژبه"),
            keywords: &["بدن", "ژبه"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("língua"),
            keywords: &["corpo", "língua", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["corpo", "língua"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("qallu"),
            keywords: &["khurku", "qallu"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("limbă"),
            keywords: &["corp", "limbă"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-514"),
            keywords: &["E10-514"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("язык"),
            keywords: &["розовый", "рот", "язык"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("ururimi"),
            keywords: &["igihimba", "ururimi"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("زبان"),
            keywords: &["جسم", "زبان"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("ද\u{dd2}ව"),
            keywords: &["ද\u{dd2}ව", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("jazyk"),
            keywords: &["jazyk", "telo"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("jezik"),
            keywords: &["jezik", "telo"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("carab"),
            keywords: &["carab", "jir"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gjuhë"),
            keywords: &["gjuhë", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("језик"),
            keywords: &["тело", "језик"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["језик"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("jezik"),
            keywords: &["jezik", "telo"],
        },
        #[cfg(feature = "sr_Latn_BA")]
        crate::Annotation {
            lang: "sr_Latn_BA",
            tts: None,
            keywords: &["jezik"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("tunga"),
            keywords: &["kropp", "tunga"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("ulimi"),
            keywords: &["mwili", "ulimi"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("ந\u{bbe}க\u{bcd}கு"),
            keywords: &[
                "உடல\u{bcd}",
                "உடல\u{bcd} உறுப\u{bcd}பு",
                "ந\u{bbe}க\u{bcd}கு",
                "முகம\u{bcd}",
            ],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c3e}లుక"),
            keywords: &["న\u{c3e}లుక", "ముఖం", "శర\u{c40}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("забон"),
            keywords: &["бадан", "забон"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ล\u{e34}\u{e49}น"),
            keywords: &["ล\u{e34}\u{e49}น", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("dil"),
            keywords: &["dil", "göwre"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ʻelelo"),
            keywords: &["ʻelelo"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("dil"),
            keywords: &["dil", "gövde", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("تىل"),
            keywords: &["تىل", "گەۋدە"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("язик"),
            keywords: &["тіло", "язик"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("زبان"),
            keywords: &["جسم", "زبان"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("til"),
            keywords: &["tana", "til"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("lưỡi"),
            keywords: &["cơ thể", "lưỡi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("làmmiñ"),
            keywords: &["làmmiñ", "yaram"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("ulwimi"),
            keywords: &["isiqu", "ulwimi"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ahọn"),
            keywords: &["Ahọn", "Ara"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("痢"),
            keywords: &["痢", "身體"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("痢"),
            keywords: &["痢", "身体"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("舌头"),
            keywords: &["舌", "舌头", "舔"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("舌頭"),
            keywords: &["舌頭", "身體部位"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["伸脷", "吐舌頭", "舌頭", "身體部位"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("ulimi"),
            keywords: &["ulimi", "umzimba"],
        },
    ],
};
#[doc = "👄"]
pub const MOUTH: crate::Emoji = crate::Emoji {
    glyph: "👄",
    codepoint: "1F444",
    status: crate::Status::FullyQualified,
    introduction_version: 0.6f32,
    name: "mouth",
    group: "People & Body",
    subgroup: "body-parts",
    is_variant: false,
    variants: &[],
    annotations: &[
        #[cfg(feature = "af")]
        crate::Annotation {
            lang: "af",
            tts: Some("mond"),
            keywords: &["liggaam", "lippe", "mond"],
        },
        #[cfg(feature = "am")]
        crate::Annotation {
            lang: "am",
            tts: Some("አፍ"),
            keywords: &["አካል", "አፍ", "ከንፈሮች"],
        },
        #[cfg(feature = "ar")]
        crate::Annotation {
            lang: "ar",
            tts: Some("فم"),
            keywords: &["جسم", "شفتان", "فم", "وجه"],
        },
        #[cfg(feature = "as")]
        crate::Annotation {
            lang: "as",
            tts: Some("ম\u{9c1}খ"),
            keywords: &["ও\u{981}ঠ", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "ast")]
        crate::Annotation {
            lang: "ast",
            tts: Some("boca"),
            keywords: &["boca", "llabios"],
        },
        #[cfg(feature = "az")]
        crate::Annotation {
            lang: "az",
            tts: Some("ağız"),
            keywords: &["ağız", "dodaqlar"],
        },
        #[cfg(feature = "be")]
        crate::Annotation {
            lang: "be",
            tts: Some("рот"),
            keywords: &["губы", "рот"],
        },
        #[cfg(feature = "bg")]
        crate::Annotation {
            lang: "bg",
            tts: Some("уста"),
            keywords: &["тяло", "уста", "устни"],
        },
        #[cfg(feature = "bn")]
        crate::Annotation {
            lang: "bn",
            tts: Some("ম\u{9c1}খ"),
            keywords: &["ঠোট", "ম\u{9c1}খ"],
        },
        #[cfg(feature = "bs")]
        crate::Annotation {
            lang: "bs",
            tts: Some("usta"),
            keywords: &["usne", "usta"],
        },
        #[cfg(feature = "ca")]
        crate::Annotation {
            lang: "ca",
            tts: Some("boca"),
            keywords: &["boca", "cos", "llavis"],
        },
        #[cfg(feature = "chr")]
        crate::Annotation {
            lang: "chr",
            tts: Some("ᎠᎰᎵ"),
            keywords: &["ᎠᎰᎵ", "ᏚᎭᏁᎦᎸᎢ"],
        },
        #[cfg(feature = "cs")]
        crate::Annotation {
            lang: "cs",
            tts: Some("ústa"),
            keywords: &["pusa", "rty", "tělo", "ústa"],
        },
        #[cfg(feature = "cy")]
        crate::Annotation {
            lang: "cy",
            tts: Some("ceg"),
            keywords: &["ceg", "corff", "gwefusau"],
        },
        #[cfg(feature = "da")]
        crate::Annotation {
            lang: "da",
            tts: Some("mund"),
            keywords: &["ansigt", "krop", "læber", "mund"],
        },
        #[cfg(feature = "de")]
        crate::Annotation {
            lang: "de",
            tts: Some("Mund"),
            keywords: &["Körperteil", "Lippen", "Mund"],
        },
        #[cfg(feature = "el")]
        crate::Annotation {
            lang: "el",
            tts: Some("στόμα"),
            keywords: &["στόμα", "σώμα", "χείλη"],
        },
        #[cfg(feature = "en")]
        crate::Annotation {
            lang: "en",
            tts: Some("mouth"),
            keywords: &["lips", "mouth"],
        },
        #[cfg(feature = "en_AU")]
        crate::Annotation {
            lang: "en_AU",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_CA")]
        crate::Annotation {
            lang: "en_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_GB")]
        crate::Annotation {
            lang: "en_GB",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "en_IN")]
        crate::Annotation {
            lang: "en_IN",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es")]
        crate::Annotation {
            lang: "es",
            tts: Some("boca"),
            keywords: &["boca", "cara", "cuerpo", "labios"],
        },
        #[cfg(feature = "es_419")]
        crate::Annotation {
            lang: "es_419",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_MX")]
        crate::Annotation {
            lang: "es_MX",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "es_US")]
        crate::Annotation {
            lang: "es_US",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "et")]
        crate::Annotation {
            lang: "et",
            tts: Some("suu"),
            keywords: &["huuled", "suu"],
        },
        #[cfg(feature = "eu")]
        crate::Annotation {
            lang: "eu",
            tts: Some("aho"),
            keywords: &["aho", "ahoa", "ezpainak", "gorputza"],
        },
        #[cfg(feature = "fa")]
        crate::Annotation {
            lang: "fa",
            tts: Some("لب"),
            keywords: &["بدن", "دهان", "لب"],
        },
        #[cfg(feature = "fi")]
        crate::Annotation {
            lang: "fi",
            tts: Some("suu"),
            keywords: &["huulet", "pää", "suu", "vartalo"],
        },
        #[cfg(feature = "fil")]
        crate::Annotation {
            lang: "fil",
            tts: Some("bibig"),
            keywords: &["bibig", "labi"],
        },
        #[cfg(feature = "fo")]
        crate::Annotation {
            lang: "fo",
            tts: Some("munnur"),
            keywords: &["kroppur", "munnur", "varrar"],
        },
        #[cfg(feature = "fr")]
        crate::Annotation {
            lang: "fr",
            tts: Some("bouche"),
            keywords: &["bouche", "corps", "lèvres"],
        },
        #[cfg(feature = "fr_CA")]
        crate::Annotation {
            lang: "fr_CA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ga")]
        crate::Annotation {
            lang: "ga",
            tts: Some("béal"),
            keywords: &["béal"],
        },
        #[cfg(feature = "gd")]
        crate::Annotation {
            lang: "gd",
            tts: Some("beul"),
            keywords: &["beul", "bilean"],
        },
        #[cfg(feature = "gl")]
        crate::Annotation {
            lang: "gl",
            tts: Some("boca"),
            keywords: &["beizos", "boca", "labios"],
        },
        #[cfg(feature = "gu")]
        crate::Annotation {
            lang: "gu",
            tts: Some("મોઢ\u{ac1}\u{a82}"),
            keywords: &["ચહ\u{ac7}રો", "મોઢ\u{ac1}\u{a82}", "શરીર", "હોઠ"],
        },
        #[cfg(feature = "ha")]
        crate::Annotation {
            lang: "ha",
            tts: Some("baki"),
            keywords: &["baki", "leɓuna"],
        },
        #[cfg(feature = "he")]
        crate::Annotation {
            lang: "he",
            tts: Some("פה"),
            keywords: &["נשיקה", "פה", "שפתיים"],
        },
        #[cfg(feature = "hi")]
        crate::Annotation {
            lang: "hi",
            tts: Some("म\u{941}\u{901}ह"),
            keywords: &["च\u{947}हरा", "म\u{941}\u{901}ह", "शरीर", "हो\u{902}ठ"],
        },
        #[cfg(feature = "hr")]
        crate::Annotation {
            lang: "hr",
            tts: Some("usta"),
            keywords: &["tijelo", "usne", "usta"],
        },
        #[cfg(feature = "hu")]
        crate::Annotation {
            lang: "hu",
            tts: Some("száj"),
            keywords: &["ajkak", "száj", "test"],
        },
        #[cfg(feature = "hy")]
        crate::Annotation {
            lang: "hy",
            tts: Some("բերան"),
            keywords: &["բերան", "մարմին", "շուրթեր"],
        },
        #[cfg(feature = "ia")]
        crate::Annotation {
            lang: "ia",
            tts: Some("bucca"),
            keywords: &["bucca", "labial", "labios", "oral", "ore"],
        },
        #[cfg(feature = "id")]
        crate::Annotation {
            lang: "id",
            tts: Some("mulut"),
            keywords: &["badan", "bibir", "mulut", "tubuh"],
        },
        #[cfg(feature = "ig")]
        crate::Annotation {
            lang: "ig",
            tts: Some("ọnụ"),
            keywords: &["egbugbereọnụ", "ọnụ"],
        },
        #[cfg(feature = "is")]
        crate::Annotation {
            lang: "is",
            tts: Some("munnur"),
            keywords: &["andlit", "líkami", "munnur", "varir"],
        },
        #[cfg(feature = "it")]
        crate::Annotation {
            lang: "it",
            tts: Some("bocca"),
            keywords: &["bocca", "corpo", "faccia", "labbra"],
        },
        #[cfg(feature = "ja")]
        crate::Annotation {
            lang: "ja",
            tts: Some("口"),
            keywords: &["キス", "口", "唇"],
        },
        #[cfg(feature = "jv")]
        crate::Annotation {
            lang: "jv",
            tts: Some("cangkem"),
            keywords: &["cangkem", "lambe"],
        },
        #[cfg(feature = "ka")]
        crate::Annotation {
            lang: "ka",
            tts: Some("პირი"),
            keywords: &["პირი", "სხეული", "ტანი", "ტუჩები"],
        },
        #[cfg(feature = "kk")]
        crate::Annotation {
            lang: "kk",
            tts: Some("ауыз"),
            keywords: &["ауыз", "дене", "ерін"],
        },
        #[cfg(feature = "kl")]
        crate::Annotation {
            lang: "kl",
            tts: Some("mund"),
            keywords: &["ansigt", "krop", "læber", "mund"],
        },
        #[cfg(feature = "km")]
        crate::Annotation {
            lang: "km",
            tts: Some("មាត\u{17cb}"),
            keywords: &["បប\u{17bc}រមាត\u{17cb}", "មាត\u{17cb}"],
        },
        #[cfg(feature = "kn")]
        crate::Annotation {
            lang: "kn",
            tts: Some("ಬಾಯ\u{cbf}"),
            keywords: &["ತುಟ\u{cbf}ಗಳು", "ದೇಹ", "ಬಾಯ\u{cbf}"],
        },
        #[cfg(feature = "ko")]
        crate::Annotation {
            lang: "ko",
            tts: Some("입"),
            keywords: &["몸", "입"],
        },
        #[cfg(feature = "kok")]
        crate::Annotation {
            lang: "kok",
            tts: Some("तो\u{902}ड"),
            keywords: &["ओ\u{902}ठ", "तो\u{902}ड"],
        },
        #[cfg(feature = "ky")]
        crate::Annotation {
            lang: "ky",
            tts: Some("ооз"),
            keywords: &["дене", "ооз", "эрин"],
        },
        #[cfg(feature = "lb")]
        crate::Annotation {
            lang: "lb",
            tts: Some("Mond"),
            keywords: &["Lëpsen", "Mond"],
        },
        #[cfg(feature = "lo")]
        crate::Annotation {
            lang: "lo",
            tts: Some("ປາກ"),
            keywords: &["ປາກ", "ຮ\u{ec8}າງກາຍ"],
        },
        #[cfg(feature = "lt")]
        crate::Annotation {
            lang: "lt",
            tts: Some("burna"),
            keywords: &["burna", "lūpos"],
        },
        #[cfg(feature = "lv")]
        crate::Annotation {
            lang: "lv",
            tts: Some("mute"),
            keywords: &["lūpas", "mute", "ķermenis"],
        },
        #[cfg(feature = "mi")]
        crate::Annotation {
            lang: "mi",
            tts: Some("waha"),
            keywords: &["ngā ngutu", "waha"],
        },
        #[cfg(feature = "mk")]
        crate::Annotation {
            lang: "mk",
            tts: Some("уста"),
            keywords: &["тело", "усни", "уста"],
        },
        #[cfg(feature = "ml")]
        crate::Annotation {
            lang: "ml",
            tts: Some("വ\u{d3e}യ"),
            keywords: &["ച\u{d41}ണ\u{d4d}ട\u{d41}കൾ", "വ\u{d3e}യ"],
        },
        #[cfg(feature = "mn")]
        crate::Annotation {
            lang: "mn",
            tts: Some("ам"),
            keywords: &["ам", "уруул", "шүд"],
        },
        #[cfg(feature = "mr")]
        crate::Annotation {
            lang: "mr",
            tts: Some("तो\u{902}ड"),
            keywords: &["ओठ", "तो\u{902}ड"],
        },
        #[cfg(feature = "ms")]
        crate::Annotation {
            lang: "ms",
            tts: Some("mulut"),
            keywords: &["badan", "bibir", "mulut"],
        },
        #[cfg(feature = "mt")]
        crate::Annotation {
            lang: "mt",
            tts: Some("ħalq"),
            keywords: &["xufftejn", "ħalq"],
        },
        #[cfg(feature = "my")]
        crate::Annotation {
            lang: "my",
            tts: Some("ပါးစပ\u{103a}"),
            keywords: &["န\u{103e}\u{102f}တ\u{103a}ခမ\u{103a}း", "ပါးစပ\u{103a}"],
        },
        #[cfg(feature = "nb")]
        crate::Annotation {
            lang: "nb",
            tts: Some("munn"),
            keywords: &["fjes", "kropp", "lepper", "munn"],
        },
        #[cfg(feature = "ne")]
        crate::Annotation {
            lang: "ne",
            tts: Some("म\u{941}ख"),
            keywords: &["ओठ", "म\u{941}ख", "शरीर"],
        },
        #[cfg(feature = "nl")]
        crate::Annotation {
            lang: "nl",
            tts: Some("mond"),
            keywords: &["lippen", "mond"],
        },
        #[cfg(feature = "nn")]
        crate::Annotation {
            lang: "nn",
            tts: Some("munn"),
            keywords: &["fjes", "kropp", "lepper", "munn"],
        },
        #[cfg(feature = "or")]
        crate::Annotation {
            lang: "or",
            tts: Some("ପ\u{b3e}ଟ\u{b3f}"),
            keywords: &["ଓଠ", "ପ\u{b3e}ଟ\u{b3f}"],
        },
        #[cfg(feature = "pa")]
        crate::Annotation {
            lang: "pa",
            tts: Some("ਮ\u{a42}\u{a70}ਹ"),
            keywords: &[
                "ਚਿਹਰਾ",
                "ਬ\u{a41}\u{a71}ਲ\u{a4d}ਹ",
                "ਮ\u{a41}\u{a70}ਹ",
                "ਮ\u{a42}\u{a70}ਹ",
            ],
        },
        #[cfg(feature = "pa_Arab")]
        crate::Annotation {
            lang: "pa_Arab",
            tts: Some("منہ"),
            keywords: &["ب\u{64f}ل", "منہ"],
        },
        #[cfg(feature = "pcm")]
        crate::Annotation {
            lang: "pcm",
            tts: Some("Maut"),
            keywords: &["Lip", "Lips", "Maut"],
        },
        #[cfg(feature = "pl")]
        crate::Annotation {
            lang: "pl",
            tts: Some("usta"),
            keywords: &["ciało", "usta", "wargi"],
        },
        #[cfg(feature = "ps")]
        crate::Annotation {
            lang: "ps",
            tts: Some("خوله"),
            keywords: &["خوله", "شونډي"],
        },
        #[cfg(feature = "pt")]
        crate::Annotation {
            lang: "pt",
            tts: Some("boca"),
            keywords: &["boca", "corpo", "lábios", "rosto"],
        },
        #[cfg(feature = "pt_PT")]
        crate::Annotation {
            lang: "pt_PT",
            tts: Some("↑↑↑"),
            keywords: &["boca", "corpo", "lábios"],
        },
        #[cfg(feature = "qu")]
        crate::Annotation {
            lang: "qu",
            tts: Some("simi"),
            keywords: &["simi", "sirpi"],
        },
        #[cfg(feature = "ro")]
        crate::Annotation {
            lang: "ro",
            tts: Some("gură"),
            keywords: &["buze", "gură"],
        },
        #[cfg(feature = "root")]
        crate::Annotation {
            lang: "root",
            tts: Some("E10-513"),
            keywords: &["E10-513"],
        },
        #[cfg(feature = "ru")]
        crate::Annotation {
            lang: "ru",
            tts: Some("рот"),
            keywords: &["алые", "губы", "зубы", "красные", "рот"],
        },
        #[cfg(feature = "rw")]
        crate::Annotation {
            lang: "rw",
            tts: Some("umunwa"),
            keywords: &["iminwa", "umunwa"],
        },
        #[cfg(feature = "sd")]
        crate::Annotation {
            lang: "sd",
            tts: Some("وات"),
            keywords: &["وات", "چپ"],
        },
        #[cfg(feature = "si")]
        crate::Annotation {
            lang: "si",
            tts: Some("කට"),
            keywords: &["කට", "තොල\u{dca}", "ශර\u{dd3}රය"],
        },
        #[cfg(feature = "sk")]
        crate::Annotation {
            lang: "sk",
            tts: Some("ústa"),
            keywords: &["pery", "ústa"],
        },
        #[cfg(feature = "sl")]
        crate::Annotation {
            lang: "sl",
            tts: Some("usta"),
            keywords: &["telo", "usta", "ustnice"],
        },
        #[cfg(feature = "so")]
        crate::Annotation {
            lang: "so",
            tts: Some("bishimo"),
            keywords: &["af", "bishimo"],
        },
        #[cfg(feature = "sq")]
        crate::Annotation {
            lang: "sq",
            tts: Some("gojë"),
            keywords: &["buzë", "gojë", "trup"],
        },
        #[cfg(feature = "sr")]
        crate::Annotation {
            lang: "sr",
            tts: Some("уста"),
            keywords: &["уснe", "уста"],
        },
        #[cfg(feature = "sr_Cyrl_BA")]
        crate::Annotation {
            lang: "sr_Cyrl_BA",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "sr_Latn")]
        crate::Annotation {
            lang: "sr_Latn",
            tts: Some("usta"),
            keywords: &["usne", "usta"],
        },
        #[cfg(feature = "sv")]
        crate::Annotation {
            lang: "sv",
            tts: Some("mun"),
            keywords: &["läppar", "mun"],
        },
        #[cfg(feature = "sw")]
        crate::Annotation {
            lang: "sw",
            tts: Some("mdomo"),
            keywords: &["mdomo", "midomo", "mwili"],
        },
        #[cfg(feature = "sw_KE")]
        crate::Annotation {
            lang: "sw_KE",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "ta")]
        crate::Annotation {
            lang: "ta",
            tts: Some("வ\u{bbe}ய\u{bcd}"),
            keywords: &["உதடுகள\u{bcd}", "வ\u{bbe}ய\u{bcd}"],
        },
        #[cfg(feature = "te")]
        crate::Annotation {
            lang: "te",
            tts: Some("న\u{c4b}రు"),
            keywords: &["న\u{c4b}రు", "ప\u{c46}దవులు", "ముఖం", "శర\u{c40}రం"],
        },
        #[cfg(feature = "tg")]
        crate::Annotation {
            lang: "tg",
            tts: Some("даҳон"),
            keywords: &["даҳон", "лабҳо"],
        },
        #[cfg(feature = "th")]
        crate::Annotation {
            lang: "th",
            tts: Some("ปาก"),
            keywords: &["ปาก", "อว\u{e31}ยวะ"],
        },
        #[cfg(feature = "tk")]
        crate::Annotation {
            lang: "tk",
            tts: Some("agyz"),
            keywords: &["agyz", "dodaklar"],
        },
        #[cfg(feature = "to")]
        crate::Annotation {
            lang: "to",
            tts: Some("ngutu"),
            keywords: &["ngutu"],
        },
        #[cfg(feature = "tr")]
        crate::Annotation {
            lang: "tr",
            tts: Some("ağız"),
            keywords: &["ağız", "dudaklar", "gövde", "yüz"],
        },
        #[cfg(feature = "ug")]
        crate::Annotation {
            lang: "ug",
            tts: Some("ئېغىز"),
            keywords: &["ئېغىز", "لەۋ"],
        },
        #[cfg(feature = "uk")]
        crate::Annotation {
            lang: "uk",
            tts: Some("рот"),
            keywords: &["губи", "рот", "тіло"],
        },
        #[cfg(feature = "ur")]
        crate::Annotation {
            lang: "ur",
            tts: Some("منہ"),
            keywords: &["جسم", "منہ"],
        },
        #[cfg(feature = "uz")]
        crate::Annotation {
            lang: "uz",
            tts: Some("og‘iz"),
            keywords: &["lablar", "og‘iz", "tana"],
        },
        #[cfg(feature = "vi")]
        crate::Annotation {
            lang: "vi",
            tts: Some("miệng"),
            keywords: &["miệng", "môi"],
        },
        #[cfg(feature = "wo")]
        crate::Annotation {
            lang: "wo",
            tts: Some("gémmiñ"),
            keywords: &["gémmiñ", "tuñ"],
        },
        #[cfg(feature = "xh")]
        crate::Annotation {
            lang: "xh",
            tts: Some("umlomo"),
            keywords: &["iinyheke", "umlomo"],
        },
        #[cfg(feature = "yo")]
        crate::Annotation {
            lang: "yo",
            tts: Some("Ẹnu"),
            keywords: &["ètè", "Ẹnu"],
        },
        #[cfg(feature = "yue")]
        crate::Annotation {
            lang: "yue",
            tts: Some("嘴"),
            keywords: &["咀唇", "嘴"],
        },
        #[cfg(feature = "yue_Hans")]
        crate::Annotation {
            lang: "yue_Hans",
            tts: Some("嘴"),
            keywords: &["咀唇", "嘴"],
        },
        #[cfg(feature = "zh")]
        crate::Annotation {
            lang: "zh",
            tts: Some("嘴"),
            keywords: &["口", "唇", "嘴"],
        },
        #[cfg(feature = "zh_Hant")]
        crate::Annotation {
            lang: "zh_Hant",
            tts: Some("嘴巴"),
            keywords: &["嘴巴", "身體部位"],
        },
        #[cfg(feature = "zh_Hant_HK")]
        crate::Annotation {
            lang: "zh_Hant_HK",
            tts: Some("↑↑↑"),
            keywords: &["↑↑↑"],
        },
        #[cfg(feature = "zu")]
        crate::Annotation {
            lang: "zu",
            tts: Some("umlomo"),
            keywords: &["izindebe", "umlomo", "umzimba"],
        },
    ],
};
